prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4009
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4009 - Oracle APEX AppBuilder
--
-- Application Export:
--   Application:     4009
--   Name:            Oracle APEX AppBuilder
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                  1,011
--       Items:                6,284
--       Computations:           783
--       Validations:          1,673
--       Processes:            1,515
--       Regions:              4,393
--       Buttons:              2,766
--       Dynamic Actions:      1,441
--     Shared Components:
--       Logic:
--         Items:                 30
--         Processes:             15
--         Computations:           8
--         Build Options:          5
--       Navigation:
--         Lists:                259
--         Breadcrumbs:            1
--           Entries:            863
--         NavBar Entries:         3
--       Security:
--         Authentication:         1
--         Authorization:         20
--       User Interface:
--         Templates:
--           Page:                 9
--           Region:              44
--           Label:               11
--           List:                16
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           1
--           Button:               7
--           Report:              18
--         LOVs:                 995
--         Shortcuts:             12
--         Plug-ins:              27
--       Globalization:
--         Messages:             436
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX AppBuilder')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286619367415899559')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135250'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'ja'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(532421019614096524.4009)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_runtime_api_usage=>'T:O'
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'HELP'
,p_substitution_value_01=>unistr('\30D8\30EB\30D7')
,p_substitution_string_02=>'PRODUCT_NAME'
,p_substitution_value_02=>'Application Express'
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9: &COMPANY.')
,p_substitution_string_04=>'MSG_LANGUAGE'
,p_substitution_value_04=>unistr('\8A00\8A9E')
,p_substitution_string_05=>'MSG_COPYRIGHT'
,p_substitution_value_05=>'Copyright &copy; 1999, 2019, Oracle. All rights reserved.'
,p_substitution_string_06=>'MSG_USER'
,p_substitution_value_06=>unistr('\30E6\30FC\30B6\30FC')
,p_substitution_string_07=>'MSG_JSCRIPT'
,p_substitution_value_07=>unistr('\3053\306E\88FD\54C1\306F\3001JavaScript\304C\6709\52B9\306A\72B6\614B\3067\5B9F\884C\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
,p_substitution_string_08=>'MSG_TBL_SUMMARY'
,p_substitution_value_08=>unistr('\30DA\30FC\30B8\30FB\30EC\30A4\30A2\30A6\30C8\8868')
,p_substitution_string_09=>'EDIT'
,p_substitution_value_09=>unistr('\7DE8\96C6')
,p_substitution_string_10=>'DONE'
,p_substitution_value_10=>unistr('\5B8C\4E86')
,p_substitution_string_11=>'TOP'
,p_substitution_value_11=>unistr('\30C8\30C3\30D7')
,p_substitution_string_12=>'CLOSE'
,p_substitution_value_12=>unistr('\9589\3058\308B')
,p_substitution_string_13=>'CONFIRM'
,p_substitution_value_13=>unistr('\78BA\8A8D')
,p_substitution_string_14=>'DATE_FORMAT'
,p_substitution_value_14=>'rr-mm-dd'
,p_substitution_string_15=>'LONG_DATE_FORMAT'
,p_substitution_value_15=>'yyyy mm dd fmDay'
,p_substitution_string_16=>'TIME_FORMAT'
,p_substitution_value_16=>'hh24:mi:ss'
,p_substitution_string_17=>'DATE_TIME_FORMAT'
,p_substitution_value_17=>'rr-mm-dd hh24:mi:ss'
,p_substitution_string_18=>'RETURN_TO_APP'
,p_substitution_value_18=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\623B\308B')
,p_substitution_string_19=>'DELETE_MSG'
,p_substitution_value_19=>unistr('\3053\306E\524A\9664\64CD\4F5C\3092\5B9F\884C\3057\307E\3059\304B\3002')
,p_substitution_string_20=>'PAGE'
,p_substitution_value_20=>unistr('\30DA\30FC\30B8')
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024140754'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_files_version=>11
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_tab_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(5297709875.4009)
,p_name=>'shared.components.tab.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(450480819599472048.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_link_target=>'f?p=&APP_ID.:643:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'643'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46189308080649570.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30BF\30D6\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:9000:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9000:9005'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(155545004712893410.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30BF\30D6\30FB\30BB\30C3\30C8\30FB\30D3\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:77:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'77'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'77'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(155551816129903365.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\6A19\6E96\30BF\30D6\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:123:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'123'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(36310824965543438.4009)
,p_list_item_display_sequence=>55
,p_list_item_link_text=>unistr('\89AA\30BF\30D6\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:331:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'331'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(188150925414136195.4009)
,p_list_item_display_sequence=>56
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:562:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'562'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4187304378934429.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&FLOW_ID.:200:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'200'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(31647421041127463.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\89AA\30BF\30D6\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:398:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'398'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'398'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11162415001016997.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=4000:58:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'58'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_template_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(12437772301.4009)
,p_name=>'shared.components.template.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12439783039.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8')
,p_list_item_link_target=>'f?p=&FLOW_ID.:4003:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4003'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181570910687524006.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:124:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'124'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(103318918740149314.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\30D1\30D6\30EA\30C3\30B7\30E5')
,p_list_item_link_target=>'f?p=&APP_ID.:727:&SESSION.::&DEBUG.:727:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'727:651'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203424522791353217.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30D7\30EC\30D3\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:4029:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4029'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4029'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12441785324.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:4656:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4656,707'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7436519543386292.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=4000:368:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'368'
);
end;
/
prompt --application/shared_components/navigation/lists/export_options
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(12802829107.4009)
,p_name=>'Export_options'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486267822373422835.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:523:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'523'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(79096314289012168.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'76'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(45716606101005971.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4900:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flows where security_group_id = :flow_security_group_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4900'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486260804328114855.4009)
,p_list_item_display_sequence=>41
,p_list_item_link_text=>unistr('Web\30B7\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:441:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'441'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(189447213907433212.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('XML\30A8\30AF\30B9\30DD\30FC\30C8\304A\3088\3073\30EC\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=4850:1:&SESSION.'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(60513615035446206.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30C6\30FC\30DE')
,p_list_item_link_target=>'f?p=&FLOW_ID.:224:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'224'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30477123909319995.4009)
,p_list_item_display_sequence=>85
,p_list_item_link_text=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4460:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4460'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(145288215599412878.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\30C7\30D5\30A9\30EB\30C8\5024')
,p_list_item_link_target=>'f?p=&APP_ID.:479:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'479,541'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(472191226795751981.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF')
,p_list_item_link_target=>'f?p=&APP_ID.:689:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'689'
);
end;
/
prompt --application/shared_components/navigation/lists/pull_templates
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(320074633987.4009)
,p_name=>'pull_templates'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(320076637876.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F5C\6210\30E1\30BD\30C3\30C9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(320078641296.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\5143')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'26:4320:4069:86:4321:241:219:655:468:177'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150871808522531061.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\6307\5B9A')
,p_list_item_link_target=>'f?p=&FLOW_ID.:498:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'498:225:343:353:412:413:415:418:423'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177583606462600141.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\898F\30C6\30F3\30D7\30EC\30FC\30C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'144:158:159:167:168:242:223:657:469'
);
end;
/
prompt --application/shared_components/navigation/lists/p4500_create_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(3734458575652.4009)
,p_name=>'P4500 Create Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3734460575652.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:259:&SESSION.::&DEBUG.:181,259,380,311:::'
,p_list_text_01=>'pd-create-page'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3734467605558.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\3068\3057\3066\306E\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:618:&SESSION.::&DEBUG.:618,301,302,305,308,309:::'
,p_list_text_01=>'pd-create-copy-page'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1478127242456137222.4009)
,p_list_item_display_sequence=>17
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1477161567189313896.4009)
,p_list_item_display_sequence=>19
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:97:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(692022803168016123.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30EA\30FC\30B8\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:362:&SESSION.:PD:&DEBUG.::P181_REGION_TYPE,P4700_SELECT_REPORT_TYPE:FORM,FORM_ON_A_TABLE:'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_text_01=>'pd-create-form-region'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1216142807755611878.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30EA\30FC\30B8\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:183:&SESSION.:PD:&DEBUG.:4016,4017,4018:P181_REGION_TYPE,P183_CHOOSE_REPORT_IMPLEMENTATION:REPORT,IRR:'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_text_01=>'pd-create-report-region'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(337326867726113326.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30EA\30FC\30B8\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:263:&SESSION.:PD:&DEBUG.:259,181,380:::'
,p_list_text_01=>'pd-create-breadcrumb-region'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3734469612579.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:364:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'pd-create-shared-component'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557581895922320741.4009)
,p_list_item_display_sequence=>52
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B0\30EB\30FC\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:521:&SESSION.::&DEBUG.:521:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1478127597899141859.4009)
,p_list_item_display_sequence=>55
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3734471629609.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\958B\767A\8005\306E\30B3\30E1\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:1234:&SESSION.::&DEBUG.:1234:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3734473632753.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30C1\30FC\30E0\958B\767A')
,p_list_text_01=>'teamDev'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3734475636636.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\6A5F\80FD')
,p_list_item_link_target=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.:143:P143_APPLICATION_ID,P143_PAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(3734473632753.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3734479650708.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\30D0\30B0')
,p_list_item_link_target=>'f?p=&APP_ID.:261:&SESSION.:SET_CURRENT_PAGE:&DEBUG.:261:P261_FEEDBACK_TYPE:BUG:'
,p_parent_list_item_id=>wwv_flow_api.id(3734473632753.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3734477646936.4009)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'To Do'
,p_list_item_link_target=>'f?p=&APP_ID.:261:&SESSION.:SET_CURRENT_PAGE:&DEBUG.:261:P261_FEEDBACK_TYPE:TODO:'
,p_parent_list_item_id=>wwv_flow_api.id(3734473632753.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/p4500_utilities_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(3741507057557.4009)
,p_name=>'P4500 Utilities Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3759689081747.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:21:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557582117917328385.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3741509057557.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A2\30C9\30D0\30A4\30B6')
,p_list_item_link_target=>'javascript:apex.navigation.popup({ url: ''f?p=&APP_ID.:8101:&SESSION.::&DEBUG.:8101:P8101_PAGE_ID:'' + pe.getCurrentPageId(), width: 1000, height: 800 }); void(0);'
,p_list_text_01=>'pd-advisor'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557573865167095591.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30AD\30E3\30C3\30B7\30E5')
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:RP,14:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3759736094374.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:912:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3759733090282.4009)
,p_list_item_display_sequence=>37
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:201:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3759730086463.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:164:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1564223914175232731.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557575668809165622.4009)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>unistr('\30AF\30ED\30B9\30FB\30DA\30FC\30B8\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:553:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3759741121124.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:674:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557582826599335455.4009)
,p_list_item_display_sequence=>75
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B0\30EB\30FC\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:520:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1564224201700236576.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3759743124173.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:89:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(715123908428313751.4009)
,p_list_item_display_sequence=>105
,p_list_item_link_text=>'----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(84646475110887465.4009)
,p_list_item_display_sequence=>108
,p_list_item_link_text=>unistr('\30C4\30FC\30EB\30C1\30C3\30D7\306E\8868\793A')
,p_list_text_01=>'pd-enable-tooltips'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(715120241154282785.4009)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\30EC\30A4\30A2\30A6\30C8')
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(715121304457300310.4009)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('2\30DA\30A4\30F3\30FB\30E2\30FC\30C9')
,p_parent_list_item_id=>wwv_flow_api.id(715120241154282785.4009)
,p_list_text_01=>'pd-two-column'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(715121981042303143.4009)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('3\30DA\30A4\30F3\30FB\30E2\30FC\30C9')
,p_parent_list_item_id=>wwv_flow_api.id(715120241154282785.4009)
,p_list_text_01=>'pd-three-column'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(715122647048306435.4009)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(715120241154282785.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(715123600559310924.4009)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\30EC\30A4\30A2\30A6\30C8\306E\30EA\30BB\30C3\30C8')
,p_parent_list_item_id=>wwv_flow_api.id(715120241154282785.4009)
,p_list_text_01=>'pd-reset-tab-layout'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_formontable
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(687318807667972.4009)
,p_name=>'Wizard_FormOnTable'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35119918419302928.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\8868/\30D3\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:453:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'453'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(687518807674747.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\3068\30EA\30FC\30B8\30E7\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4708'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523944451986072840.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wizard_api.page_exists (p_flow_id => :fb_flow_id, p_page_id => :F4000_P4708_PAGE_ID) = false',
'and ',
'wwv_flow_user_interface_dev.supports_tabs (',
'    p_application_id     => :FB_FLOW_ID, ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(110871008270343279.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wizard_api.page_exists (p_flow_id => :fb_flow_id, p_page_id => :F4000_P4708_PAGE_ID) = false',
'and',
'not wwv_flow_user_interface_dev.supports_tabs (',
'          p_application_id     => :FB_FLOW_ID, ',
'          p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(687918807681739.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\4E3B\30AD\30FC')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4713:442'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61214112392904165.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5217')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4771'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61214491625916813.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30DC\30BF\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4772'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61214799753924309.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30D6\30E9\30F3\30C1\51E6\7406')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P4708_PAGE_MODE'
,p_list_item_disp_condition2=>'NORMAL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4773'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6707307059037409.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'255'
);
end;
/
prompt --application/shared_components/navigation/lists/application_script_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(940230882533174.4009)
,p_name=>'Application Script Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(940613006537413.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A4\30F3\30B9\30C8\30FC\30EB\30FB\30B5\30DE\30EA\30FC\306E\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:2106:&SESSION.::&DEBUG.:RP:P2106_DEPLOYMENT_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10221704948316206.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:4900:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23417101078571978.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\30A4\30F3\30B9\30C8\30FC\30EB')
,p_list_item_link_target=>'f?p=4000:2100:&SESSION.::NO:RP,2100,2101,2102,2103,2104,2105:P2100_CANCEL_PAGE:2'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(57806406935019088.4009)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:2150:&SESSION.::&DEBUG.:2150:P2150_CANCEL_PAGE:2:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23486008772829647.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3055\308C\3066\3044\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:155:&SESSION.::&DEBUG.:155:FB_FLOW_ID,P2110_CANCEL_PAGE:&FB_FLOW_ID.,2:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from WWV_FLOW_INSTALL where FLOW_ID = :fb_flow_id and sys.dbms_lob.getlength(DEINSTALL_SCRIPT) > 2'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10173510414062342.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:632:&SESSION.::&DEBUG.:632:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_flashchart
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1192927752498551.4009)
,p_name=>'Wizard FlashChart'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(27749716114059996.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:751:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'751,752,616,4716,731,642,647,680, 265, 266'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'751:752'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1193504812510850.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\304A\3088\3073\30EA\30FC\30B8\30E7\30F3\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'616'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523939281792733010.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1194207367521038.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                    p_application_id     => :FB_FLOW_ID, ',
'                    p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30432723077534584.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30C1\30E3\30FC\30C8\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:731:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':P751_CHART_ENGINE = ''FLASH_CHART5'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'731'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(269543464571718472.4009)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:265:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':P751_CHART_ENGINE = ''JET_CHART'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'265'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(269548583138844638.4009)
,p_list_item_display_sequence=>66
,p_list_item_link_text=>unistr('\5217\306E\30DE\30C3\30D4\30F3\30B0')
,p_list_item_link_target=>'f?p=&APP_ID.:266:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':P751_CHART_ENGINE = ''JET_CHART'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'266'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1194626414526528.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':P751_CHART_ENGINE = ''FLASH_CHART5'' or (:P751_CHART_ENGINE = ''JET_CHART'' and :P751_JET_CHART_TYPE = ''GANTT'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'642'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_master_detail
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1929128107331631.4009)
,p_name=>'Wizard_Master_Detail'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1929506767334974.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DE\30B9\30BF\30FC\8868\3068\5217')
,p_list_item_link_target=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1929915078337395.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C7\30A3\30C6\30FC\30EB\8868\3068\5217')
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1930222351339475.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\4E3B\30AD\30FC\306E\5B9A\7FA9')
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'11'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1930528931341357.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\30FB\30EA\30F3\30AF')
,p_list_item_link_target=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_cnt pls_integer := null;',
'begin',
'  if (:P4_MASTER_OWNER != ''0'') and (:P4_MASTER_OWNER != ''0'') and',
'     (:P5_DETAIL_OWNER != ''0'') and (:P5_DETAIL_TABLE != ''0'') then',
'     for c1 in (select count(t) cnt',
'                from (select distinct o, t from (',
'                select a.owner o, a.table_name t',
'                  from sys.dba_constraints a, sys.dba_constraints b',
'                 where 1=1',
'                   and a.r_owner = :P4_MASTER_OWNER',
'                   and a.owner = :P4_MASTER_OWNER',
'                   and a.r_constraint_name = b.constraint_name',
'                   and a.constraint_type = ''R''',
'                   and b.owner = :P4_MASTER_OWNER',
'                   and b.table_name = :P4_MASTER_TABLE  ',
'                   and b.table_name not like ''BIN$%''     ',
'                   and b.constraint_type = ''P''',
'                )) x',
'                where x.o = :P5_DETAIL_OWNER',
'                and x.t = :P5_DETAIL_TABLE)',
'     loop',
'       l_cnt := c1.cnt;',
'     end loop;',
'  end if;',
'  if l_cnt = 0 then',
'    return true;  ',
'  else',
'    return false;',
'  end if;',
'end;'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'12'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165421413228778671.4009)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>unistr('\4E3B\30AD\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:507:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'(:P11_MASTER_KEY_TYPE <> ''ROWID'') or (:P11_DETAIL_KEY_TYPE <> ''ROWID'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'507:508'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1930804474343713.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&FLOW_ID.:293:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'293'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1931112785346142.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30EC\30A4\30A2\30A6\30C8')
,p_list_item_link_target=>'f?p=&FLOW_ID.:15:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'15'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1931425599349830.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_link_target=>'f?p=&FLOW_ID.:18:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'18:24'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523944833973084232.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1931710838355078.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1932018457357222.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&FLOW_ID.:35:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'35'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2778715503937249.4009)
,p_name=>'Workspace Utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(699057997282634091.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:182:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1500'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2779125546940169.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC\306E\30C7\30D5\30A9\30EB\30C8\5024')
,p_list_item_link_target=>'f?p=&APP_ID.:800:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-ui-defaults'
,p_list_text_01=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A\3001\30C6\30FC\30DE\304A\3088\3073\30B0\30ED\30FC\30D0\30EA\30BC\30FC\30B7\30E7\30F3\5C5E\6027\3092\5B9A\7FA9\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'800'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(525225511743184058.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('REST\5BFE\5FDCSQL\30B5\30FC\30D3\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-ords-rest'
,p_list_text_01=>unistr('\5916\90E8REST\5BFE\5FDCSQL\30B5\30FC\30D3\30B9\3078\306E\53C2\7167\3092\7BA1\7406\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(699079754496077658.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30CB\30E5\30FC\30B9\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=4800:7000:&SESSION.:'
,p_list_item_icon=>'icon-util-news'
,p_list_text_01=>unistr('&PRODUCT_NAME.\30DB\30FC\30E0\30DA\30FC\30B8\304A\3088\3073\30C1\30FC\30E0\958B\767A\306B\8868\793A\3055\308C\308B\30CB\30E5\30FC\30B9\3092\7BA1\7406\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(178939812163761988)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(533164636995207229.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30EA\30E2\30FC\30C8\30FB\30B5\30FC\30D0\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:1931:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-database-object'
,p_list_text_01=>unistr('Web\30BD\30FC\30B9\30FB\30E2\30B8\30E5\30FC\30EB\304A\3088\3073\8A8D\8A3C\306B\4F7F\7528\3059\308B\30EA\30E2\30FC\30C8\30FB\30B5\30FC\30D0\30FC\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\7BA1\7406\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(91019908621880192.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B0\30EB\30FC\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:722:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-app-groups'
,p_list_text_01=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\8AD6\7406\30B0\30EB\30FC\30D7\306B\7DE8\6210\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'722'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(522749587305194510.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('Web\8CC7\683C\8A3C\660E')
,p_list_item_link_target=>'f?p=&APP_ID.:1620:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-security-profiles'
,p_list_text_01=>unistr('REST\5BFE\5FDCSQL\307E\305F\306F\305D\306E\4ED6\306EREST\30B5\30FC\30D3\30B9\306B\63A5\7D9A\3059\308B\305F\3081\306E\30BB\30AD\30E5\30A2\306A\8CC7\683C\8A3C\660E\3092\7BA1\7406\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(113574116563879249.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30C6\30FC\30DE')
,p_list_item_link_target=>'f?p=&APP_ID.:763:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-workspace-themes'
,p_list_text_01=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\5185\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\5229\7528\53EF\80FD\306A\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30C6\30FC\30DE\3092\7BA1\7406\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'763'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(787290498859273399.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8...')
,p_list_item_link_target=>'f?p=&APP_ID.:523:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-export-repository'
,p_list_text_01=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8\3092\30A8\30AF\30B9\30DD\30FC\30C8\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(201138622968628415.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('&PRODUCT_NAME.\30D3\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:714:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-apex-views'
,p_list_text_01=>unistr('&PRODUCT_NAME.\30E1\30BF\30C7\30FC\30BF\306B\5BFE\3059\308B\69D8\3005\306A\30D3\30E5\30FC\3092\554F\3044\5408\305B\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'714,905'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47677831332249228.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\9593\30EC\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:9009:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-cross-app-reports'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'182'
,p_list_text_01=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\69D8\3005\306A\5C5E\6027\3001\6BD4\8F03\3001\30BB\30AD\30E5\30EA\30C6\30A3\304A\3088\3073UI\30EC\30DD\30FC\30C8\3092\78BA\8A8D\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9009'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_application_process_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(4020210037479119.4009)
,p_name=>'shared.components.application_process.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4030001947619598.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:4207:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4207'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11000225909481279.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'42'
);
end;
/
prompt --application/shared_components/navigation/lists/create_installation_script
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(4589709522084091.4009)
,p_name=>'Create Installation Script'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4590429608089842.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30E1\30BD\30C3\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:850:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'850'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4611332135223026.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30B9\30AF\30EA\30D7\30C8\5C5E\6027')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'nvl(:P850_MODE,''INSTALL'') in (''INSTALL'',''UPGRADE'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'855'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4591211039093928.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B9\30AF\30EA\30D7\30C8\306E\5B9A\7FA9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'856:857:858:578:669'
);
end;
/
prompt --application/shared_components/navigation/lists/run_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(4717527352803690.4009)
,p_name=>'run.page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4717913977809214.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8&FB_FLOW_PAGE_ID.\306E\5B9F\884C')
,p_list_item_link_target=>'f?p=&APP_ID.:RUN_PAGE:&SESSION.:BRANCH_TO_PAGE_ACCEPT:&DEBUG.::FB_FLOW_ID,FB_FLOW_PAGE_ID,F4000_P1_FLOW:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.,&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_steps p,',
'       wwv_flow_user_interfaces ui',
' where p.flow_id = :FB_FLOW_ID',
'   and p.id      = :FB_FLOW_PAGE_ID',
'   and ui.id     = p.user_interface_id',
'   and ( ui.global_page_id  <> :FB_FLOW_PAGE_ID',
'       or ui.global_page_id is null',
'       )'))
,p_list_text_01=>'runPage'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5741512908621046.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8&FB_FLOW_PAGE_ID.\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:4500:&SESSION.::&DEBUG.::FB_FLOW_ID,FB_FLOW_PAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'4150'
,p_list_text_01=>'editPage'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1521230401042075.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'9'
,p_list_text_01=>'sharedComponents'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(445219706544405464.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:674:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'utilities'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(123512627008588975.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'&P4150_LOCK.'
,p_list_item_link_target=>'f?p=&APP_ID.:291:&SESSION.::&DEBUG.:291:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4150'
,p_list_text_01=>'&P4150_LOCK_ICON.'
,p_list_text_02=>',23,268,201,523,8'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(123487516760321097.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30DA\30FC\30B8&FB_FLOW_PAGE_ID.\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:164:&SESSION.::&DEBUG.::FB_FLOW_PAGE_ID,FB_FLOW_ID:&FB_FLOW_PAGE_ID.,&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4150,23,268,201,523,8'
,p_list_text_01=>'export'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4844126798254470.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\691C\7D22')
,p_list_item_link_target=>'javascript:popUpNamed(''f?p=4000:273:&SESSION.:::RP:F4000_P273_PAGE:&FB_FLOW_PAGE_ID.'',''Finder'');'
,p_list_text_01=>'findItem'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/script_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(4852514958421306.4009)
,p_name=>'Script Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(24081006745684565.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B9\30AF\30EA\30D7\30C8\306E\30D7\30ED\30D1\30C6\30A3')
,p_list_item_link_target=>'javascript:pageSubmit(''APPLY_CHANGES_328'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'328'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4853228464425278.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B9\30AF\30EA\30D7\30C8\30FB\30A8\30C7\30A3\30BF')
,p_list_item_link_target=>'javascript:pageSubmit(''APPLY_CHANGES_865'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'865'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_tree_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(4884503079390537.4009)
,p_name=>'shared.components.tree.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4888317947398805.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C4\30EA\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'28'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4889111693401694.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:202:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from WWV_FLOW_TREES where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'202'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11042723644717174.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:45:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'45'
);
end;
/
prompt --application/shared_components/navigation/lists/page_tasks_4301
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(5093603989423342.4009)
,p_name=>'Page Tasks 4301'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5093917495427251.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8907\6570\306E\30DA\30FC\30B8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:339:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5094530439440376.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B0\30EB\30FC\30D7\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:520:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5094707714443306.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30ED\30C3\30AF\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:291:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/finder_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6207014968942318.4009)
,p_name=>'Finder Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12888222063068359.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:273:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'273'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6208031937947265.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:516:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'516'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6284502070657757.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\554F\5408\305B')
,p_list_item_link_target=>'f?p=&APP_ID.:527:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'527'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6207727781946089.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:514:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'514'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(60548519958087566.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'PL/SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:431:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'431'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1892802119936706.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30A4\30E1\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:539:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'Icons'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'539'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(451355613725606074.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\30C7\30D0\30C3\30B0')
,p_list_item_link_target=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'939,19'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(451401219021090108.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\30BB\30C3\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:34:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'34'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(483658821697886476.4009)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\30A8\30E9\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:959:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'959'
);
end;
/
prompt --application/shared_components/navigation/lists/list_item_edit_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6276618987043262.4009)
,p_name=>'list item edit tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6277013577051156.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\89AA\30EA\30B9\30C8\306E\5909\66F4 ')
,p_list_item_link_target=>'f?p=&APP_ID.:4053:&SESSION.::&DEBUG.:4053:P4053_ID:&F4000_P4052_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_security
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6730409642972302.4009)
,p_name=>'shared.components.security'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(131581022927862632.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30BB\30AD\30E5\30EA\30C6\30A3\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:509:&SESSION.::&DEBUG.:509:FB_FLOW_ID,509_FB_UPD_ID:&FB_FLOW_ID.,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6731321416975780.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:801:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6731930074978251.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:4070:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(715703720905977567.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30AF\30BB\30B9\5236\5FA1')
,p_list_item_link_target=>'f?p=&APP_ID.:2300:&SESSION.::&DEBUG.:RP,2300:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(107341512439481992.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\4FDD\8B77')
,p_list_item_link_target=>'f?p=&APP_ID.:510:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(154637234323820007.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('Web\8CC7\683C\8A3C\660E')
,p_list_item_link_target=>'f?p=&APP_ID.:1620:&SESSION.::&DEBUG.:1620:::'
,p_list_text_03=>'has-arrow'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_user_interface
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6736213021992272.4009)
,p_name=>'shared.components.user.interface'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(355051223966396435.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:197:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(716516312898369111.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C6\30FC\30DE')
,p_list_item_link_target=>'f?p=&APP_ID.:260:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(136592605767706703.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:4003:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6742208088009777.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'LOV'
,p_list_item_link_target=>'f?p=&APP_ID.:4110:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6744131637016530.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30B7\30E7\30FC\30C8\30AB\30C3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:4047:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(27476131766793984.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4400:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14966220663089761.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\8A2D\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:4445:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'NEVER'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6746028090034478.4009)
,p_name=>'shared.components.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6747207789038012.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EA\30B9\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:405:&SESSION.::&DEBUG.:RIR:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1404393804983091259.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:405:&SESSION.::&DEBUG.:RIR:IR_IS_NAVMENU:1:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_themes',
'  where flow_id = :fb_flow_id ',
'     and security_group_id = :flow_security_group_id ',
'     and navigation_type = ''L'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6748930298044550.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6(\30EC\30AC\30B7\30FC)')
,p_list_item_link_target=>'f?p=&APP_ID.:643:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_themes',
'  where flow_id = :fb_flow_id ',
'     and security_group_id = :flow_security_group_id ',
'     and navigation_type <> ''L'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6748216793040621.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:546:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6748621987042177.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30AF\30E9\30B7\30C3\30AF\30FB\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\30FB\30A8\30F3\30C8\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:4005:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_user_interfaces',
'where nav_bar_type = ''NAVBAR''',
'   and flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1418265896610430063.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\30FB\30EA\30B9\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:405:&SESSION.::&DEBUG.:RIR:IR_IS_NAVBAR:1:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_user_interfaces',
'where nav_bar_type = ''LIST''',
'   and flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_component_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6753822621133458.4009)
,p_name=>'shared component tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(204067027873902941.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23409530421523625.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694983664029694709.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B3\30E1\30F3\30C8\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:4310:&SESSION.::&DEBUG.::F4000_P4310_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185215606520315768.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\958B\767A\8005\306E\30B3\30E1\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:606:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185215915524318393.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\958B\767A\8005\30B3\30E1\30F3\30C8\306E\30AB\30EC\30F3\30C0')
,p_list_item_link_target=>'f?p=&APP_ID.:594:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_translations
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6868813338465446.4009)
,p_name=>'shared.components.translations'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(131583418902870966.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B0\30ED\30FC\30D0\30EA\30BC\30FC\30B7\30E7\30F3\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:506:&SESSION.::&DEBUG.:506:FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6873620180486312.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C6\30AD\30B9\30C8\30FB\30E1\30C3\30BB\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:4006:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6870414162475145.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\7FFB\8A33')
,p_list_item_link_target=>'f?p=&APP_ID.:4761:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_files
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6874810268492937.4009)
,p_name=>'shared.components.files'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9999913109548888.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\9759\7684\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D5\30A1\30A4\30EB')
,p_list_item_link_target=>'f?p=&APP_ID.:40:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6777811617190566.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\9759\7684\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30D5\30A1\30A4\30EB')
,p_list_item_link_target=>'f?p=&APP_ID.:312:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/application_monitor_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(7285601119000778.4009)
,p_name=>'Application Monitor Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7286509084003017.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3\306E\30E2\30CB\30BF\30FC')
,p_list_item_link_target=>'f?p=4350:22:&SESSION.::NO:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35256609257872204.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\958B\767A\8005\30B3\30E1\30F3\30C8\306E\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:606:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_process2
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(8047824983989923.4009)
,p_name=>'Wizard Create Process2'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/create_administration
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(8697111044414519.4009)
,p_name=>'create administration'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(8697515892415945.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:572:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'572'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1556520563339699770.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(8698001609430767.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                   p_application_id     => :FB_FLOW_ID, ',
'                   p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(8763130268808090.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:626:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'626'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_summarypage
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(8771208191950732.4009)
,p_name=>'wizard_SummaryPage'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(8776908610965769.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5100'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523948471338130108.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12306121730146667.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(8878700445197468.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A2\30A4\30C6\30E0\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5105'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9251713948619425.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30B5\30DE\30EA\30FC\30FB\30A2\30A4\30C6\30E0')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5110'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7559603306884347.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'303'
);
end;
/
prompt --application/shared_components/navigation/lists/supporting_objects_installation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10025113710400997.4009)
,p_name=>'Supporting Objects Installation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10025907954408780.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\524D\63D0\6761\4EF6')
,p_list_item_link_target=>'f?p=&APP_ID.:631:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10026522499412995.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7F6E\63DB\6587\5B57\5217 ')
,p_list_item_link_target=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P2_SUBSTR_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19115930214978417.4009)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:511:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P2_BUILD_OPT_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10026826654414177.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30A4\30F3\30B9\30C8\30FC\30EB\524D\306E\691C\8A3C')
,p_list_item_link_target=>'f?p=&APP_ID.:445:&SESSION.::&DEBUG.:RP:::'
,p_list_text_01=>'&P2_PRE_INS_VAL_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10117115357770425.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30A4\30F3\30B9\30C8\30FC\30EB\30FB\30B9\30AF\30EA\30D7\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:473:&SESSION.::&DEBUG.:RP:::'
,p_list_text_01=>'&P2_INST_SCRIPT_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47099730350498293.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30E1\30C3\30BB\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:567:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/supporting_objects_deinstallation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10121209647806692.4009)
,p_name=>'Supporting Objects Deinstallation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10122025231811196.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\524A\9664\30B9\30AF\30EA\30D7\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:576:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P2_DE_INS_SCRIPT_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47101131567536488.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\524A\9664\30E1\30C3\30BB\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:567:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.#DEINSTALL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_web_service_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11271810048283515.4009)
,p_name=>'shared.components.web_service.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11272321130286719.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Web\30B5\30FC\30D3\30B9\53C2\7167')
,p_list_item_link_target=>'f?p=&APP_ID.:170:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'170'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11279906285310777.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:63:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'63'
);
end;
/
prompt --application/shared_components/navigation/lists/page_branch_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11286824340344465.4009)
,p_name=>'page.branch.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11288626203354383.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30D6\30E9\30F3\30C1')
,p_list_item_link_target=>'f?p=&APP_ID.:4202:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4202'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(58002325682402982.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8907\6570\306E\30D6\30E9\30F3\30C1\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:746:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'746'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194567927186940748.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:881:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'881:563:885'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11287304385348126.4009)
,p_list_item_display_sequence=>64
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:64:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'64'
);
end;
/
prompt --application/shared_components/navigation/lists/page_process_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11322022496485821.4009)
,p_name=>'page.process.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11322821242494955.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D7\30ED\30BB\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:4201:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4201'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(57980905334378187.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8907\6570\306E\30D7\30ED\30BB\30B9\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:745:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'745'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193857202841290851.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:482:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'482:213:552:866'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11323227822496829.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:65:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'65'
);
end;
/
prompt --application/shared_components/navigation/lists/create_breadcrumb
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11694125812505020.4009)
,p_name=>'create breadcrumb'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11694630293505024.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:288:&SESSION.:'
,p_list_item_current_for_pages=>'288'
);
end;
/
prompt --application/shared_components/navigation/lists/page_region_view_mode
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(12991522578387911.4009)
,p_name=>'page.region.view.mode'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(13061519395907376.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\5C5E\6027')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_REPORT'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_page_plugs ',
' where page_id = :fb_flow_page_id',
'   and flow_id = :fb_flow_id',
'   and :flow_page_id not in (370,754)',
'   and (  (PLUG_SOURCE_TYPE in ( ''NATIVE_SQL_REPORT'',',
'                                 ''NATIVE_TABFORM'' )',
'          and id = :F4000_P4651_ID)',
'       or :flow_page_id = 420)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'420'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(17995509153269699.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30AB\30EC\30F3\30C0\5C5E\6027')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_CALENDAR'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from  wwv_flow_page_plugs ',
'where PLUG_SOURCE_TYPE = ''NATIVE_CALENDAR''',
'and   id = :F4000_P4651_ID and :APP_PAGE_ID NOT IN (122,697,670,661,836)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(28172021155412200.4009)
,p_list_item_display_sequence=>92
,p_list_item_link_text=>unistr('\30C1\30E3\30FC\30C8\5C5E\6027')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_FLASH_CHART5'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_page_plugs ',
'where page_id       = :fb_flow_page_id',
'  and flow_id       = :fb_flow_id',
'  and :flow_page_id not in (370)',
'  and (   (    PLUG_SOURCE_TYPE = ''NATIVE_FLASH_CHART5''',
'           and id               = :F4000_P4651_ID)',
'       or :flow_page_id = 754)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'754'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(85461617780828062.4009)
,p_list_item_display_sequence=>95
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\5C5E\6027')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_NATIVE_IR''); '
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_page_plugs ',
'where page_id = :fb_flow_page_id and',
'      flow_id = :fb_flow_id and',
'      :flow_page_id not in (754,370) and',
'      ((PLUG_SOURCE_TYPE = ''NATIVE_IR'' ',
'       and',
'      id = :F4000_P4651_ID ) or :flow_page_id in (601,687,694,742))'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'601:687:694'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33496613908438386.4009)
,p_list_item_display_sequence=>105
,p_list_item_link_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30B7\30EA\30FC\30BA')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_FLASH5_SERIES'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'834'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'834'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(197502903546075048.4009)
,p_list_item_display_sequence=>109
,p_list_item_link_text=>unistr('\4FDD\5B58\3055\308C\305F\30EC\30DD\30FC\30C8')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_SAVED_REPORTS'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_page_plugs ',
' where page_id = :fb_flow_page_id',
'   and flow_id = :fb_flow_id',
'   and :flow_page_id not in (754,370)',
'   and (   (    PLUG_SOURCE_TYPE = ''NATIVE_IR''',
'            and id               = :F4000_P4651_ID )',
'        or :flow_page_id in (601,687,694,742) )'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'742'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11159118868729265.4009)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\51FA\529B\5C5E\6027')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_PRINT_ATTR'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_page_plugs ',
' where page_id = :fb_flow_page_id',
'   and flow_id = :fb_flow_id',
'   and :flow_page_id not in (754,370)',
'   and (  (PLUG_SOURCE_TYPE in ( ''NATIVE_SQL_REPORT'',',
'                                 ''NATIVE_TABFORM'',',
'                                 ''NATIVE_IR'' )',
'          and id = :F4000_P4651_ID)',
'       or :flow_page_id in (960,774))'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'960,774'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22186214630159256.4009)
,p_list_item_display_sequence=>115
,p_list_item_link_text=>unistr('\5B9A\7FA9')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_CALENDAR_DEFINITION'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'697'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22153400161060412.4009)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\6708\6B21\30AB\30EC\30F3\30C0')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_MONTHLY_CALENDAR'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'122'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16872109954486071.4009)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\9031\6B21\30AB\30EC\30F3\30C0')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_WEEKLY_CALENDAR'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'670'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16872929001491541.4009)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\65E5\6B21\30AB\30EC\30F3\30C0')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_DAILY_CALENDAR'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'661'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30766002077732772.4009)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\30AB\30B9\30BF\30E0\30FB\30AB\30EC\30F3\30C0')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_CUSTOM_CALENDAR'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'836'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(173469005857069842.4009)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>unistr('\30DE\30C3\30D7\5C5E\6027')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_FLASH_MAP'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_page_plugs ',
'where page_id       = :fb_flow_page_id',
'  and flow_id       = :fb_flow_id',
'  and :flow_page_id not in (370)',
'  and (   (    PLUG_SOURCE_TYPE = ''NATIVE_FLASH_MAP''',
'           and id               = :F4000_P4651_ID)',
'       or :flow_page_id = 832)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'832'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(187618203631389359.4009)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('\30DE\30C3\30D7\30FB\30B7\30EA\30FC\30BA')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_MAP_SERIES'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'187'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'187'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3696311919048128.4009)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('\30EA\30B9\30C8\30FB\30AB\30EC\30F3\30C0')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_AGENDA_CALENDAR'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'80'
);
end;
/
prompt --application/shared_components/navigation/lists/page_region_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(13987931263515071.4009)
,p_name=>'page.region.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(13996410232565779.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EA\30FC\30B8\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4650:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4650'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(58023120665439320.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8907\6570\306E\30EA\30FC\30B8\30E7\30F3\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:747:&SESSION.::&DEBUG.:RP,747:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'747'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(189958910147635012.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:853:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'853:249:480:70:157:438:459:128:247:217:212:864:136:690'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11228932521987173.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:60:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'60'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_component_settings_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(14972101971160040.4009)
,p_name=>'shared.components.component_settings.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14972319391160042.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\8A2D\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:4445:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14972912989160044.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:4447:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/cross_application_reports_comparison
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15030113309394959.4009)
,p_name=>'Cross Application Reports / Comparison'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15030613786404487.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\6BD4\8F03')
,p_list_item_link_target=>'f?p=&APP_ID.:1300:&SESSION.:NORUN:&DEBUG.::::'
,p_list_item_icon=>'icon-util-app-compare'
,p_list_text_01=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\540D\306E\5DEE\5206\3092\554F\3044\5408\305B\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(17208701402593062.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\30FB\30B5\30DE\30EA\30FC\30FB\30AB\30A6\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:1301:&SESSION.:NORUN:&DEBUG.::::'
,p_list_item_icon=>'icon-util-component-counts'
,p_list_text_01=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\30FB\30AB\30A6\30F3\30C8\306E\5DEE\5206\3092\554F\3044\5408\305B\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_component_load_tables
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15132926917246073.4009)
,p_name=>'shared.component.load.tables'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15133112993246073.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30FB\30ED\30FC\30C9\5B9A\7FA9')
,p_list_item_link_target=>'f?p=&APP_ID.:1800:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15134306858246075.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:1808:&SESSION.:'
,p_list_item_current_for_pages=>'1808'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_form_on_ws
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15577802944637145.4009)
,p_name=>'wizard_form_on_ws'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15578929956644992.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'605'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523950262441140962.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15579201690646275.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15578618528641637.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30B5\30FC\30D3\30B9\306E\9078\629E')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'600'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15579621083651886.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30A2\30A4\30C6\30E0')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'620:884'
);
end;
/
prompt --application/shared_components/navigation/lists/create_page_introduction
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15960618523591402.4009)
,p_name=>'create.page.introduction'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15961725795593556.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:259:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'259,4700,751,752'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15962230990595065.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5B9A\7FA9')
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'500,849'
);
end;
/
prompt --application/shared_components/navigation/lists/create_component_introduction
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(16004105550701290.4009)
,p_name=>'create.component.introduction'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16006006374710902.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5236\5FA1\306E\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:0:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'323,364,336'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'323,364'
);
end;
/
prompt --application/shared_components/navigation/lists/create_menu_with_menu_option
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(16141621180084222.4009)
,p_name=>'create.menu.with.menu.option'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16142629838086700.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EA\30FC\30B8\30E7\30F3\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:263:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'263'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114048304156724467.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'481'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16143922350093999.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30A8\30F3\30C8\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:264:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'264'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16144801703097508.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:286:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'286'
);
end;
/
prompt --application/shared_components/navigation/lists/page_button_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(16353308133052510.4009)
,p_name=>'page.button.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16359625373152129.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DC\30BF\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4203:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4203'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168788531254407335.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DC\30BF\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\8A2D\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:228:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'228'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(51143127397134983.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\8907\6570\306E\30DC\30BF\30F3\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:724:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'724'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(189959220536638052.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:852:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'852:250:446:548:878'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11249424312117274.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:61:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'61,'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_data_load_wizard
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(16993520375207189.4009)
,p_name=>'Wizard Create Data Load Wizard'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16993707693207190.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30FB\30ED\30FC\30C9\8868')
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'1700,1701,1702,1704,1705,1706,4716'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1700'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16994300242207192.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C8\30E9\30F3\30B9\30D5\30A9\30FC\30E1\30FC\30B7\30E7\30F3\30FB\30EB\30FC\30EB')
,p_list_item_link_target=>'f?p=&APP_ID.:1702:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16994015104207191.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\8868\53C2\7167')
,p_list_item_link_target=>'f?p=&APP_ID.:1701:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20142616358500970.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:1704:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16994623223207192.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523936815498664127.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                   p_application_id     => :FB_FLOW_ID, ',
'                   p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(307986230539557923.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30DC\30BF\30F3\3068\30D6\30E9\30F3\30C1')
,p_list_item_link_target=>'f?p=&APP_ID.:1706:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1706'
);
end;
/
prompt --application/shared_components/navigation/lists/home_page_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(17113830931867323.4009)
,p_name=>'home.page.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(53347908603459381.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:2110:&SESSION.::&DEBUG.:RP,2110:FB_FLOW_ID,FB_FLOW_PAGE_ID,P2110_CANCEL_PAGE:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.,1:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flows ',
'where security_group_id = :flow_security_group_id and ',
':app_page_id = ''1'''))
,p_security_scheme=>wwv_flow_api.id(12472323342703137)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(115201606939032288.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30B3\30D4\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:499:&SESSION.::&DEBUG.:499,611:FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(212830002493156758.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B0\30EB\30FC\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:520:&SESSION.::&DEBUG.:RP:FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(34528309073406519.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30ED\30C3\30AF')
,p_list_item_link_target=>'f?p=&APP_ID.:291:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47796518629853915.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\4F9D\5B58\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:425:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(198461526128088208.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8\30FB\30EA\30DD\30B8\30C8\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(210726611906133664.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3\306E\30E2\30CB\30BF\30FC')
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'71'
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6996930509253802.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30C0\30C3\30B7\30E5\30DC\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:71:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'71,300,70'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4065812606027121.4009)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30C0\30C3\30B7\30E5\30DC\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_computation_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(17446232715505772.4009)
,p_name=>'page.computation.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(17447319340511375.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8A08\7B97')
,p_list_item_link_target=>'f?p=&APP_ID.:4204:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4204'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(57947507450331474.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8907\6570\306E\8A08\7B97\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:744:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'744'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193688712738615625.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:847:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'847:215:549:877'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(17448822934521895.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:152:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'152'
);
end;
/
prompt --application/shared_components/navigation/lists/create_page_dropdown
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(18268207632995006.4009)
,p_name=>'CREATE PAGE DROPDOWN'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18730913062805985.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C4\30EA\30FC')
,p_list_item_link_target=>'f?p=4000:112:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:TREE,TREE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18538906655275187.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\7A7A\767D\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:4714:&SESSION.::&DEBUG.:4714,4716,78,81,82,79,80,83:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18729403103784151.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:REPORT,SQL_REPORT'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18539619122278798.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30C1\30E3\30FC\30C8')
,p_list_item_link_target=>'f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:CHART,BAR_HTML'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18729709683786044.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30D5\30A9\30FC\30E0')
,p_list_item_link_target=>'f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:FORM,FORM_ON_A_TABLE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18730018341788537.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30A6\30A3\30B6\30FC\30C9')
,p_list_item_link_target=>'f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:WIZARD,SIMPLE_WIZARD'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18730312238796287.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30AB\30EC\30F3\30C0')
,p_list_item_link_target=>'f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:CALENDAR,CALENDAR'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18739623123960261.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30ED\30B0\30A4\30F3\30FB\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=4000:500:&SESSION.::NO:::'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(18564606387816293.4009)
,p_name=>'wizard Copy Page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203365725936637465.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\30B3\30D4\30FC\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:618:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'618'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18565123356821261.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\3059\308B\30DA\30FC\30B8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'301'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523947008998118995.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_link_target=>'f?p=&APP_ID.:305:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'305:316'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18565729375832463.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:305:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'305:316'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20734321130916756.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\65B0\3057\3044\540D\524D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'302'
);
end;
/
prompt --application/shared_components/navigation/lists/create_calendar_template
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(19035021988626357.4009)
,p_name=>'create calendar template'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19036431470638590.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30E1\30BD\30C3\30C9\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=&FLOW_ID.:161:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'161'
);
end;
/
prompt --application/shared_components/navigation/lists/report_layout_creation_steps
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(19263904166280419.4009)
,p_name=>'Report Layout Creation Steps'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19265711569292026.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30EC\30A4\30A2\30A6\30C8\30FB\30BF\30A4\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1401'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19266719244398256.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EC\30A4\30A2\30A6\30C8\30FB\30BD\30FC\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1402,1406'
);
end;
/
prompt --application/shared_components/navigation/lists/switch_theme
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(20663215911569971.4009)
,p_name=>'switch.theme'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20663630109574042.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:179:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'179'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20664529201583245.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4E92\63DB\6027\306E\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:386:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'386'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20670121761618936.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5207\66FF\3048\306E\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:180:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'180'
);
end;
/
prompt --application/shared_components/navigation/lists/web_service_reference_wizard
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(22410710903630445.4009)
,p_name=>'web service reference wizard'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33465030663752652.4009)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>unistr('REST\306E\8A73\7D30')
,p_list_item_link_target=>'f?p=&APP_ID.:871:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P870_WEB_REFERENCE_TYPE'
,p_list_item_disp_condition2=>'REST'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'871'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33473413946041089.4009)
,p_list_item_display_sequence=>12
,p_list_item_link_text=>unistr('REST\306E\5165\529B')
,p_list_item_link_target=>'f?p=&APP_ID.:872:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P870_WEB_REFERENCE_TYPE'
,p_list_item_disp_condition2=>'REST'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'872'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33478806692190351.4009)
,p_list_item_display_sequence=>13
,p_list_item_link_text=>unistr('REST\306E\51FA\529B')
,p_list_item_link_target=>'f?p=&APP_ID.:873:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P870_WEB_REFERENCE_TYPE'
,p_list_item_disp_condition2=>'REST'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'873'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22495103330356887.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('WSDL\306E\4F4D\7F6E')
,p_list_item_link_target=>'f?p=&APP_ID.:580:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P870_WEB_REFERENCE_TYPE'
,p_list_item_disp_condition2=>'WSDL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'580'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22505817687597564.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('Web\30B5\30FC\30D3\30B9\306E\8A73\7D30')
,p_list_item_link_target=>'f?p=&APP_ID.:585:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P870_WEB_REFERENCE_TYPE'
,p_list_item_disp_condition2=>'WSDL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'585'
);
end;
/
prompt --application/shared_components/navigation/lists/deployment_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(22452018965176093.4009)
,p_name=>'deployment tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22452810092182983.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30E1\30C3\30BB\30FC\30B8')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_567'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'567'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22521803109426954.4009)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\524D\63D0\6761\4EF6')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_631'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'631'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22503614097373329.4009)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('\7F6E\63DB')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_17'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'17'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22516317738412258.4009)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_511'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'511'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22484008809315095.4009)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>unistr('\691C\8A3C')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_445'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'445'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22468026031263279.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A4\30F3\30B9\30C8\30FC\30EB')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_473'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'473'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23543014930276179.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A2\30C3\30D7\30B0\30EC\30FC\30C9')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_667'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'667'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22498325263357607.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\524A\9664')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_576'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'576,579'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22452401088180364.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_633'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'633'
);
end;
/
prompt --application/shared_components/navigation/lists/create_shared_query_train
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(22638505565903517.4009)
,p_name=>'create shared query train'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22639713530905876.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\554F\5408\305B\306E\5B9A\7FA9')
,p_list_item_link_target=>'f?p=&APP_ID.:1110:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1110'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22640625305909268.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BD\30FC\30B9\554F\5408\305B')
,p_list_item_link_target=>'f?p=&APP_ID.:1113:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1113, 1119'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22641406735913386.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5B9A\7FA9\306E\30C0\30A6\30F3\30ED\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:1115:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1115'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(112560706550636283.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8\306E\30A2\30C3\30D7\30ED\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:1118:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1118'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22641712623915044.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:1114:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1114'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(22726621018248639.4009)
,p_name=>'shared.components.reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11534830686211676.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\554F\5408\305B')
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18838121614544449.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:1400:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_component_application_attributes
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(23333311543130294.4009)
,p_name=>'shared component application attributes'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23334104055137553.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5B9A\7FA9\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:4001:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23346722503199625.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:4310:&SESSION.::&DEBUG.::F4000_P4310_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/supporting_object_upgrade
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(23445516456661592.4009)
,p_name=>'Supporting Object Upgrade'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23447506544668156.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30C3\30D7\30B0\30EC\30FC\30C9\30FB\30B9\30AF\30EA\30D7\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:667:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P2_UPG_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47100700053527309.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A2\30C3\30D7\30B0\30EC\30FC\30C9\30FB\30E1\30C3\30BB\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:567:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.#UPGRADE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_application
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(23817524863605164.4009)
,p_name=>'Copy Application'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23817717317605164.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\306E\30BF\30FC\30B2\30C3\30C8\3092\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:499:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23818031260605166.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:611:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'611'
);
end;
/
prompt --application/shared_components/navigation/lists/script_results_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(24172418538839346.4009)
,p_name=>'script results tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(24173525249850711.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\30A4\30F3\30B9\30C8\30FC\30EB')
,p_list_item_link_target=>'f?p=&APP_ID.:2100:&SESSION.::&DEBUG.::P2100_CANCEL_PAGE:2:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(80633901866542564.4009)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:2150:&SESSION.::&DEBUG.:2150,2151,2152,2153,2154:P2150_CANCEL_PAGE:2:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(24173116592848238.4009)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:2110:&SESSION.::&DEBUG.:2110:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(24257620317868232.4009)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\30A4\30F3\30B9\30C8\30FC\30EB\30FB\30B9\30AF\30EA\30D7\30C8\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:473:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'2106'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(24256800577862502.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'2106'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37122929947493126.4009)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(96986426278147432.4009)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5B9F\884C')
,p_list_item_link_target=>'&P2106_HOME_LINK.'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'2106'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(98381926501308170.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5358\4E00\30B9\30AF\30EA\30D7\30C8\306E\8868\793A\3068\30C0\30A6\30F3\30ED\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:432:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :FLOW_PAGE_ID = 473 then',
'  for c1 in (select null',
'             from #OWNER#.wwv_flow_install_scripts',
'             where flow_id = :fb_flow_id ',
'             and security_group_id = :flow_security_group_id',
'             and nvl(script_type,''INSTALL'') = ''INSTALL'')',
'  loop',
'      return true;',
'  end loop;',
'end if;',
'return false;'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(403371215736939990.4009)
,p_list_item_display_sequence=>12
,p_list_item_link_text=>unistr('\5358\4E00\30B9\30AF\30EA\30D7\30C8\306E\8868\793A\3068\30C0\30A6\30F3\30ED\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:457:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :FLOW_PAGE_ID = 667 then',
'  for c1 in (select 1',
'             from #OWNER#.wwv_flow_install_scripts',
'             where flow_id = :fb_flow_id ',
'             and security_group_id = :flow_security_group_id',
'             and nvl(script_type,''INSTALL'') = ''UPGRADE'')',
'  loop',
'      return true;',
'  end loop;',
'end if;',
'return false;'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(403375103864031484.4009)
,p_list_item_display_sequence=>13
,p_list_item_link_text=>unistr('\5358\4E00\30B9\30AF\30EA\30D7\30C8\306E\8868\793A\3068\30C0\30A6\30F3\30ED\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:462:&SESSION.::&DEBUG.:462:::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :flow_page_id = 576 then',
'  for c1 in (select null',
'             from wwv_flow_install',
'             where flow_id = :fb_flow_id',
'             and security_group_id = :flow_security_group_id',
'             and nvl(sys.dbms_lob.getlength(deinstall_script),0) > 0)',
'  loop',
'      return true;',
'  end loop;',
'end if;',
'return false;',
''))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(118217100108549882.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3DDL\30B9\30AF\30EA\30D7\30C8\306E\4F5C\6210')
,p_list_item_link_target=>'javascript:doSubmit(''DDL_SCRIPT'')'
,p_list_item_disp_cond_type=>'SQL_EXPRESSION'
,p_list_item_disp_condition=>'1=2'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(236577109798623828.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\30B9\30AF\30EA\30D7\30C8\306E\518D\9806\5E8F\4ED8\3051')
,p_list_item_link_target=>'f?p=&APP_ID.:802:&SESSION.::&DEBUG.:802:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_install_scripts',
'where flow_id = :fb_flow_id ',
'and security_group_id = :flow_security_group_id',
'and nvl(script_type,''INSTALL'') = ''INSTALL''',
'and :APP_PAGE_ID = 473'))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(380042987976769926.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\30B9\30AF\30EA\30D7\30C8\306E\518D\9806\5E8F\4ED8\3051')
,p_list_item_link_target=>'f?p=&APP_ID.:38:&SESSION.::&DEBUG.:38:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_install_scripts',
'where flow_id = :fb_flow_id ',
'and security_group_id = :flow_security_group_id',
'and nvl(script_type,''INSTALL'') = ''UPGRADE''',
'and :APP_PAGE_ID = 667'))
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/create_dynamic_action
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(25338502483800688.4009)
,p_name=>'create.dynamic_action'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/create_application_process
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(25941806450198106.4009)
,p_name=>'create.application.process'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25942514415200446.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8B58\5225')
,p_list_item_link_target=>'f?p=&APP_ID.:147:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'147'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25943018571201605.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:148:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'148'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25955304550235459.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\3051')
,p_list_item_link_target=>'f?p=&APP_ID.:150:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'150'
);
end;
/
prompt --application/shared_components/navigation/lists/multi_table_create_application
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(26219416632336505.4009)
,p_name=>'multi-table create application'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(26219826675339401.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\540D\524D')
,p_list_item_link_target=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(26220100141341244.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:3001:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3001'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(170634803652169586.4009)
,p_list_item_display_sequence=>55
,p_list_item_link_text=>unistr('\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'17:476:433'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(174654710653590049.4009)
,p_list_item_display_sequence=>57
,p_list_item_link_text=>unistr('\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:3020:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3020'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(26338321326318015.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:3005:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3005'
);
end;
/
prompt --application/shared_components/navigation/lists/developer_resources
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(26512283167477231.4009)
,p_name=>'developer.resources'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(26512415103477231.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D5\30A9\30F3\30C8APEX\30A2\30A4\30B3\30F3')
,p_list_item_link_target=>'https://apex.oracle.com/fontapex'
,p_list_text_02=>'target="_blank"'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_plugins_edit_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(27884204995681439.4009)
,p_name=>'shared.components.plugins.edit.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15025526109384601.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\8A2D\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:4445:&SESSION.::&DEBUG.:4445,CIR:::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_plugin_dev.has_application_attributes (',
'    p_application_id => :P4410_FLOW_ID,',
'    p_plugin_type    => :P4410_PLUGIN_TYPE,',
'    p_plugin_name    => :P4410_NAME )'))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(28084903887018683.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D7\30E9\30B0\30A4\30F3\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:4460:&SESSION.::&DEBUG.:RP,4460:P4460_PLUGIN_ID:&P4410_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(27884715851681468.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:4420:&SESSION.::&DEBUG.:RP,CIR:IR_DISPLAY_NAME:&P4410_DISPLAY_NAME.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_plugins_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(27943608569240649.4009)
,p_name=>'shared.components.plugins.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(28086530815045307.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\30D7\30E9\30B0\30A4\30F3\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:4460:&SESSION.::&DEBUG.:RP,4460:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_dynamic_action_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(28119925264668131.4009)
,p_name=>'page.dynamic_action.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(28120209465673032.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:773:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'773'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(28120415005674680.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8907\6570\306E\52D5\7684\30A2\30AF\30B7\30E7\30F3\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:794:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'794'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194156219281175220.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:699:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'863:699'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(28120618815675737.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:795:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'795'
);
end;
/
prompt --application/shared_components/navigation/lists/web_service_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(28359907580129646.4009)
,p_name=>'web service tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(28360319831142579.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Web\30B5\30FC\30D3\30B9\53C2\7167\306E\624B\52D5\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:199:&SESSION.::&DEBUG.:196:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/synchronize_defaults
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(28511519360309024.4009)
,p_name=>'Synchronize Defaults'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/migrations
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(29129925984472722.4009)
,p_name=>'Migrations'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(29130106376476541.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Oracle Forms\79FB\884C')
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/form_on_ws_with_rpt
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(30094110886480012.4009)
,p_name=>'form_on_ws_with_rpt'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30094627509484763.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B5\30FC\30D3\30B9\3068\64CD\4F5C\306E\9078\629E')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'700'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30094903052487151.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\304A\3088\3073\30EA\30FC\30B8\30E7\30F3\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'705'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30095522099492672.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5165\529B\30A2\30A4\30C6\30E0')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'720:880'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22663523536956076.4009)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>unistr('\8A8D\8A3C')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flow_collections',
' where collection_name = ''WS_AUTH_ITEMS'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30095815304500150.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Web\30B5\30FC\30D3\30B9\306E\7D50\679C')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'725:842'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30096124308502737.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30D1\30E9\30E1\30FC\30BF')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'730:882:848'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1556523170111727633.4009)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30095212402489886.4009)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                   p_application_id     => :FB_FLOW_ID, ',
'                   p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30096432619505205.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'735'
);
end;
/
prompt --application/shared_components/navigation/lists/application_utilities_line3
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(30782715391876326.4009)
,p_name=>'application.utilities.line3'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30782921600876331.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4FDD\5B58\3055\308C\305F\30EC\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.:RP,RIR:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30783226672876332.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.:RP,RIR:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/caching
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(31086920674251816.4009)
,p_name=>'Caching'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(31098728732310986.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30AD\30E3\30C3\30B7\30E5\3055\308C\305F\3059\3079\3066\306E\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:638:&SESSION.::&DEBUG.:RIR:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(31087325522253253.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30AD\30E3\30C3\30B7\30E5\3055\308C\305F\3059\3079\3066\306E\30EA\30FC\30B8\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:656:&SESSION.::&DEBUG.:RIR:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sqlquery_on_ws_result
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(31960916110521509.4009)
,p_name=>'sqlquery_on_ws_result'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40191601175229120.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('Web\53C2\7167\30BF\30A4\30D7')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'755'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(31962812085529789.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Web\53C2\7167\60C5\5831')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'760,775,784'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(31963927323534138.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30D1\30E9\30E1\30FC\30BF\3068\30EC\30DD\30FC\30C8\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'765,780,790'
);
end;
/
prompt --application/shared_components/navigation/lists/list_utility_options
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(33430506092105266.4009)
,p_name=>'list utility options'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12826927626041434.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\3053\306E\30EA\30B9\30C8\3092\30AB\30EC\30F3\30C8\30FB\30DA\30FC\30B8\306B\8FFD\52A0')
,p_list_item_link_target=>'f?p=&APP_ID.:4016:&SESSION.::&DEBUG.:181,4016,4017,4018,259,380:P4016_SOURCE_TYPE,P407_IDENTIFY_LIST,F4000_P4016_TITLE:LIST,&F4000_P4050_LIST_ID.,&P4050_LIST_NAME.:'
,p_list_item_disp_cond_type=>'NOT_EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from WWV_FLOW_PAGE_PLUGS ',
'where list_id = :F4000_P4050_LIST_ID AND ',
'PAGE_ID = :fb_flow_page_id and ',
'flow_id = :fb_flow_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33455121161147439.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EA\30B9\30C8\306E\30B3\30D4\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:658:&SESSION.::&DEBUG.:602,658,663:P602_ID:&F4000_P4050_LIST_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33431712672107181.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\3042\308B\30EA\30B9\30C8\304B\3089\5225\306E\30EA\30B9\30C8\3078\306E\30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA\306E\30B3\30D4\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:477:&SESSION.::&DEBUG.:477:P477_COPY_LIST_FROM:&F4000_P4050_LIST_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from   wwv_flow_lists',
'where  id = :F4000_P4050_LIST_ID ',
'and    list_type = ''STATIC'''))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33434024793110611.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\3053\306E\30EA\30B9\30C8\5185\306B\304A\3051\308B\30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA\306E\89AA\306E\5909\66F4')
,p_list_item_link_target=>'f?p=&APP_ID.:2222:&SESSION.::&DEBUG.::P2222_LIST_ID:&F4000_P4050_LIST_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from   wwv_flow_lists',
'where  id = :F4000_P4050_LIST_ID ',
'and   list_type = ''STATIC'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40745428326672193.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\5B64\7ACB\30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:712:&SESSION.::&DEBUG.:RP:P712_LIST_ID:&F4000_P4050_LIST_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from   wwv_flow_lists',
'where  id = :F4000_P4050_LIST_ID ',
'and    list_type = ''STATIC'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(170300712666400884.4009)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA\306E\518D\9806\5E8F\4ED8\3051')
,p_list_item_link_target=>'f?p=&APP_ID.:536:&SESSION.::&DEBUG.::P536_LIST_ID:&F4000_P4050_LIST_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from   wwv_flow_lists',
'where  id = :F4000_P4050_LIST_ID ',
'and    list_type = ''STATIC'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_list_entries
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(33731702665524035.4009)
,p_name=>'Copy List Entries'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33733202927543059.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\306E\30BF\30FC\30B2\30C3\30C8\3092\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:477:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'477'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33733511584545617.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA\306E\30B3\30D4\30FC\306E\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:478:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'478'
);
end;
/
prompt --application/shared_components/navigation/lists/lock_functions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(34740016606195595.4009)
,p_name=>'lock.functions'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(34740422493197305.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30ED\30C3\30AF')
,p_list_item_link_target=>'f?p=&APP_ID.:291:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'291'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(34740830804199645.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30ED\30C3\30AF\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:299:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'299'
);
end;
/
prompt --application/shared_components/navigation/lists/standard_tab_management
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(35060712015585948.4009)
,p_name=>'standard.tab.management'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35061409029594543.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\9078\629E\3057\305F\6A19\6E96\30BF\30D6\3092\7570\306A\308B\89AA\30BF\30D6\306B\79FB\52D5')
,p_list_item_link_target=>'f?p=&FLOW_ID.:77:&SESSION.::&DEBUG.:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'  from WWV_FLOW_TOPLEVEL_TABS',
' where flow_id = :fb_flow_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35061718033597155.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\6A19\6E96\30BF\30D6\30FB\30BB\30C3\30C8\540D\306E\5909\66F4')
,p_list_item_link_target=>'f?p=&FLOW_ID.:345:&SESSION.::&DEBUG.:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_tabs where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35062024959599144.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\8868\793A\9806\5E8F\306E\5909\66F4')
,p_list_item_link_target=>'f?p=&FLOW_ID.:123:&SESSION.::&DEBUG.:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_tabs where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35062632017610572.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\9078\629E\3057\305F\6A19\6E96\30BF\30D6\3067\30DA\30FC\30B8\3092\95A2\9023\4ED8\3051')
,p_list_item_link_target=>'f?p=&APP_ID.:9005:&SESSION.::&DEBUG.:9005:F4000_P9005_TAB_ID:&F4000_CUR_STD_TAB.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_tabs where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35097012080765730.4009)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>unistr('\65B0\898F\6A19\6E96\30BF\30D6\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=4000:90:&SESSION.::NO:92,94,95,96,4722,4723,4724'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35063015871615372.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\65B0\898F\6A19\6E96\30BF\30D6\30FB\30BB\30C3\30C8\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=4000:9000:&SESSION.::::F4000_P9000_CUR_PTAB,F4000_CUR_STD_TAB:999999999999,'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/install_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(37438506954816730.4009)
,p_name=>'Install Progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37439316651819553.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2100:2115'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37439619768820400.4009)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\30E9\30A4\30BB\30F3\30B9')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install',
' where license_message is not null',
'   and flow_id = :fb_flow_id',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2101'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37440226347822326.4009)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7F6E\63DB')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install',
' where replace(prompt_substitution_01_yn||',
'                 prompt_substitution_02_yn||',
'                 prompt_substitution_03_yn||',
'                 prompt_substitution_04_yn||',
'                 prompt_substitution_05_yn||',
'                 prompt_substitution_06_yn||',
'                 prompt_substitution_07_yn||',
'                 prompt_substitution_08_yn||',
'                 prompt_substitution_09_yn||',
'                 prompt_substitution_10_yn||',
'                 prompt_substitution_11_yn||',
'                 prompt_substitution_12_yn||',
'                 prompt_substitution_13_yn||',
'                 prompt_substitution_14_yn||',
'                 prompt_substitution_15_yn||',
'                 prompt_substitution_16_yn||',
'                 prompt_substitution_17_yn||',
'                 prompt_substitution_18_yn||',
'                 prompt_substitution_19_yn||',
'                 prompt_substitution_20_yn,''N'','''') is not null',
'   and flow_id = :fb_flow_id',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2103'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(13556731674021001.4009)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install_build_opt',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2107'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37439922884821393.4009)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>unistr('\691C\8A3C')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select * from wwv_flow_install_checks',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2102:2108'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37440529810823352.4009)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2104'
);
end;
/
prompt --application/shared_components/navigation/lists/import_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(37899301707472090.4009)
,p_name=>'import progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37899710018474406.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D5\30A1\30A4\30EB\306E\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'460'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37900017290476513.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D5\30A1\30A4\30EB\306E\30A4\30F3\30DD\30FC\30C8\306E\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:163:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'163'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37910625087516631.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30A4\30F3\30B9\30C8\30FC\30EB')
,p_list_item_link_target=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'49:67:166:409:253:321:598:4450:929:494:612'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(272780339297125857.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30D7\30ED\30F3\30D7\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:2160:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/repository
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(38836703962860678.4009)
,p_name=>'repository'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(38837209849862399.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8\30FB\30EA\30DD\30B8\30C8\30EA\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'460,163,48,644'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(226337903706179254.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D5\30A1\30A4\30EB\306E\30D7\30EC\30D3\30E5\30FC')
,p_list_item_link_target=>'javascript:popupURL(''f?p=&FLOW_ID.:2120:&SESSION.::&DEBUG.::P2120_FILE_ID:&P163_FILE_ID.'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'163,49,48,494,644'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_calendar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(41547421928169148.4009)
,p_name=>'Wizard Create Calendar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(41548106129174056.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30EA\30FC\30B8\30E7\30F3\5C5E\6027')
,p_list_item_link_target=>'f?p=&FLOW_ID.:2006:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2006'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(41548516172176957.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:2002:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2002'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(111540408427704857.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30AB\30EC\30F3\30C0\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:2003:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2003'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(27339623408065125.4009)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>unistr('\30EA\30F3\30AF\306E\8A73\7D30')
,p_list_item_link_target=>'f?p=&APP_ID.:357:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'357'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(27361720513871146.4009)
,p_list_item_display_sequence=>46
,p_list_item_link_text=>unistr('\30C9\30E9\30C3\30B0\30FB\30A2\30F3\30C9\30FB\30C9\30ED\30C3\30D7\30FB\30D7\30ED\30BB\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:615:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.is_desktop_ui (',
'	    p_application_id   =>  :FB_FLOW_ID,',
'	    p_user_interface_id => :P259_USER_INTERFACE_ID );'))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(243813102489268605.4009)
,p_list_item_display_sequence=>48
,p_list_item_link_text=>unistr('\30D7\30ED\30BB\30B9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:470:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(27289930306839993.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:354:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'354'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_md_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(42519297248600803.4009)
,p_name=>'Wizard Create MD Page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(42519403820600804.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'32,326,98,961'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(42519866060600806.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(42520260714600807.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'not wwv_flow_user_interface_dev.supports_tabs (',
'          p_application_id     => :FB_FLOW_ID, ',
'          p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(42521082419600808.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'P29_MD_TYPE'
,p_list_item_disp_condition2=>'MD_SINGLE_PG:MD_TWO_PG'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'239'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(42521842664600808.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\30FB\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P29_MD_TYPE'
,p_list_item_disp_condition2=>'MD_EMAIL_STYLE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'99'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(42522643669600809.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30C7\30A3\30C6\30FC\30EB\30FB\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'P29_MD_TYPE'
,p_list_item_disp_condition2=>'MD_SINGLE_PG:MD_TWO_PG'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'257'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_dashboard
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(43062373542725339.4009)
,p_name=>'Wizard Create Dashboard'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(43062548622725340.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'326,759,98,961'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(43062989624725341.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(43063368505725341.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'not wwv_flow_user_interface_dev.supports_tabs (',
'          p_application_id     => :FB_FLOW_ID, ',
'          p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(43064541793725341.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30C0\30C3\30B7\30E5\30DC\30FC\30C9\30FB\30EC\30A4\30A2\30A6\30C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'962'
);
end;
/
prompt --application/shared_components/navigation/lists/home_page_apex_4_0_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(46890703166185102.4009)
,p_name=>'Home Page APEX 4.0 list'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46891214941188463.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5B9F\884C')
,p_list_item_link_target=>'&F4000_P1_RUN_LINK.'
,p_list_item_icon=>'app-builder-run-app'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46891420828190182.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex-sql-script'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46891900873193850.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::FB_FLOW_ID,FB_FLOW_PAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.:'
,p_list_item_icon=>'app-builder-shared-components'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177830030226412242.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:674:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex-utilities'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46892107107195637.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8/\30A4\30F3\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:461:&SESSION.::&DEBUG.::FB_FLOW_ID,FB_FLOW_PAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.:'
,p_list_item_icon=>'app-builder-export-import'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_region_utilities_report_regions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47104812669691866.4009)
,p_name=>'page.region.utilities.report.regions'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47106211554691868.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\6A19\6E96\30EC\30DD\30FC\30C8\5217\30D8\30C3\30C0\30FC\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:217:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(445540813206505532.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\5217\30D8\30C3\30C0\30FC\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:690:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47106522548691869.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\304C\898B\3064\304B\3089\306A\304B\3063\305F\5834\5408\306E\30E1\30C3\30BB\30FC\30B8\3059\3079\3066\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:212:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492651908993878213.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306E\8A2D\5B9A\306E\66F4\65B0')
,p_list_item_link_target=>'f?p=&APP_ID.:940:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47105918660691868.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('SQL\554F\5408\305B\30EA\30FC\30B8\30E7\30F3\30FB\30BD\30FC\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:247:&SESSION.::&DEBUG.:RIR:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492644402142781679.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306E\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=4350:92:&SESSION.::&DEBUG.:RIR:IR_NFLOW_ID:&FB_FLOW_ID.'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/cross_application_reports_security
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47648606548052805.4009)
,p_name=>'Cross Application Reports / Security'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47650319458052824.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30BB\30AD\30E5\30EA\30C6\30A3\30FB\30D7\30ED\30D5\30A1\30A4\30EB')
,p_list_item_link_target=>'f?p=&APP_ID.:9014:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-security-profiles'
,p_list_text_01=>unistr('\5404\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30BB\30AD\30E5\30EA\30C6\30A3\8A73\7D30\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47650917494052824.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:9015:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-auth-scheme'
,p_list_text_01=>unistr('\5404\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\3059\3079\3066\306E\8A8D\8A3C\30B9\30AD\30FC\30E0\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47650613876052824.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30D1\30B9\30EF\30FC\30C9\30FB\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:7777:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-password'
,p_list_text_01=>unistr('\500B\3005\306E\30D1\30B9\30EF\30FC\30C9\30FB\30A2\30A4\30C6\30E0\3068\305D\306E\8A2D\5B9A\3092\78BA\8A8D\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/cross_application_reports_user_interface
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47656832568088745.4009)
,p_name=>'Cross Application Reports / User Interface'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47658830638088749.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\30B5\30DE\30EA\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:737:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-theme-summary'
,p_list_text_01=>unistr('\30C7\30D5\30A9\30EB\30C8\30FB\30C6\30FC\30DE\3068\30C6\30FC\30DE\30FB\30AB\30A6\30F3\30C8\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_application_item_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47807005066095922.4009)
,p_name=>'shared.components.application_item.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47807417533099513.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:4100:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4100'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47808827230102390.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'130'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192556407703412832.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:533:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'533'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_application_computation_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47827519966525945.4009)
,p_name=>'shared.components.application_computation.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47827910747532792.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A08\7B97')
,p_list_item_link_target=>'f?p=&APP_ID.:4101:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4101'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47828120790535668.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:43:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'43'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_build_option_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47909111131552473.4009)
,p_name=>'shared.components.build_option.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47909728792557644.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4910:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4910'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47909902258559446.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:203:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'203'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192566112775480588.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:535:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'535'
);
end;
/
prompt --application/shared_components/navigation/lists/delete_multiple_pages
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(48377323742917579.4009)
,p_name=>'delete Multiple Pages'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48377606904922202.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C1\30A7\30C3\30AF\3057\305F\30DA\30FC\30B8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:339:&SESSION.::&DEBUG.:339:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'339'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48377811406923459.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\7BC4\56F2\5225\30DA\30FC\30B8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:72:&SESSION.::&DEBUG.:72:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'72'
);
end;
/
prompt --application/shared_components/navigation/lists/install_progress_upgrade
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(48681713885605105.4009)
,p_name=>'Install Progress (Upgrade)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48681921050605105.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2150'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48682216352605105.4009)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\30E9\30A4\30BB\30F3\30B9')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install',
' where license_message is not null',
'   and flow_id = :fb_flow_id',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2151'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48682518004605105.4009)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7F6E\63DB')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install',
' where replace(prompt_substitution_01_yn||',
'                 prompt_substitution_02_yn||',
'                 prompt_substitution_03_yn||',
'                 prompt_substitution_04_yn||',
'                 prompt_substitution_05_yn||',
'                 prompt_substitution_06_yn||',
'                 prompt_substitution_07_yn||',
'                 prompt_substitution_08_yn||',
'                 prompt_substitution_09_yn||',
'                 prompt_substitution_10_yn||',
'                 prompt_substitution_11_yn||',
'                 prompt_substitution_12_yn||',
'                 prompt_substitution_13_yn||',
'                 prompt_substitution_14_yn||',
'                 prompt_substitution_15_yn||',
'                 prompt_substitution_16_yn||',
'                 prompt_substitution_17_yn||',
'                 prompt_substitution_18_yn||',
'                 prompt_substitution_19_yn||',
'                 prompt_substitution_20_yn,''N'','''') is not null',
'   and flow_id = :fb_flow_id',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2153'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48682805062605105.4009)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install_build_opt',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2157'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48683114640605105.4009)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>unistr('\691C\8A3C')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select * from wwv_flow_install_checks',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2152,2158'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48683423866605106.4009)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2154'
);
end;
/
prompt --application/shared_components/navigation/lists/create_script_stuff
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(51024904532702691.4009)
,p_name=>'create script stuff'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(51027724271708323.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\8868\306E\30B9\30AF\30EA\30D7\30C8\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:669:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/structured_query
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(55535125515641311.4009)
,p_name=>'Structured_Query'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/create_web_reference_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(57083604297327751.4009)
,p_name=>'create_web_reference_tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1030018641100391162.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('RESTFul Web\53C2\7167\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:871:&SESSION.::&DEBUG.:871:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(57084621958332785.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Web\30B5\30FC\30D3\30B9\53C2\7167\306E\624B\52D5\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:199:&SESSION.::&DEBUG.:199:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/install_preview_upgrade
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(57809829707044603.4009)
,p_name=>'Install Preview (Upgrade)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(57810025849044605.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30C3\30D7\30B0\30EC\30FC\30C9\30FB\30B9\30AF\30EA\30D7\30C8\306E\30D7\30EC\30D3\30E5\30FC')
,p_list_item_link_target=>'javascript:popupURL(''f?p=&APP_ID.:2109:&SESSION.::&DEBUG.::P2109_MODE:UPGRADE'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/export_install_navigate
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(58916220936178306.4009)
,p_name=>'export.install.navigate'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(58917130286181031.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8\30FB\30EA\30DD\30B8\30C8\30EA\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486309116766298442.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:523:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'461'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(445307613122457455.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'680'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_theme_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(58949101764235429.4009)
,p_name=>'shared.components.theme.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1030175014751098308.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30FC\30DE')
,p_list_item_link_target=>'f?p=&APP_ID.:260:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(44080124445670825.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:173:&SESSION.::&DEBUG.:RP:P173_SHOW:1:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'173,435,491,492'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193120127053383246.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:681:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'681'
);
end;
/
prompt --application/shared_components/navigation/lists/view_ui_default
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(59836303269637894.4009)
,p_name=>'view.ui.default'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(59850310111658783.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\8868\306E\30C7\30D5\30A9\30EB\30C8\306E\8868\793A')
,p_list_item_link_target=>'javascript:popupURL(''f?p=4000:391:&SESSION.:::391,RP:P391_SCHEMA,P391_TABLE:&UI_SCHEMA.,&UI_TABLE.'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'769,4795,4811,4017'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177740131510804118.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8868\30C7\30A3\30AF\30B7\30E7\30CA\30EA\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=4500:802:&SESSION.::NO:RP,802:P800_SCHEMA,P802_TABLE_ID:&UI_SCHEMA.,&UI_TABLE_ID.'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'769,4795,4811,4017'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491980431480090226.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\306E\8868\793A')
,p_list_item_link_target=>'javascript:popupURL(''f?p=4000:579:&SESSION.:::RIR:P391_SCHEMA:&UI_SCHEMA.'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491968306537007365.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=4500:6:&SESSION.::NO:RIR:P800_SCHEMA:&UI_SCHEMA.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/theme_home_page_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(60448901162323653.4009)
,p_name=>'theme home page utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(60452220471348108.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\30B3\30D4\30FC')
,p_list_item_link_target=>'f?p=&FLOW_ID.:401:&SESSION.::&DEBUG.:401::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(60458828136378754.4009)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\524A\9664')
,p_list_item_link_target=>'f?p=&FLOW_ID.:221:&SESSION.::&DEBUG.:221::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(60449412936327043.4009)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&FLOW_ID.:224:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(60449817785328400.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\30A4\30F3\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.::P460_FILE_TYPE:THEME:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(60460231384389174.4009)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>unistr('\8B58\5225\756A\53F7\306E\5909\66F4')
,p_list_item_link_target=>'f?p=&FLOW_ID.:397:&SESSION.::&DEBUG.:397::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1433728355595982335.4009)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3\306E\30EA\30B9\30C8\30A2')
,p_list_item_link_target=>'f?p=&APP_ID.:117:&SESSION.::&DEBUG.:117:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(112939916055325918.4009)
,p_list_item_display_sequence=>8
,p_list_item_link_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30C6\30FC\30DE\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:763:&SESSION.::&DEBUG.:RP,764,789,762:P764_FLOW_ID:&FB_FLOW_ID.:'
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_auth_scheme
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(61117217587002695.4009)
,p_name=>'Wizard Create Auth Scheme'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_formonsp
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(61194681533640692.4009)
,p_name=>'Wizard_FormOnSP'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61194883702734213.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D7\30ED\30B7\30FC\30B8\30E3')
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61195220694739150.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\3068\30EA\30FC\30B8\30E7\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4705'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523942931171940092.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'not wwv_flow_wizard_api.page_exists (p_flow_id => :FB_FLOW_ID,',
'                                     p_page_id => :F4000_P4705_PAGE_ID)',
'and',
'wwv_flow_user_interface_dev.supports_tabs (',
'    p_application_id     => :FB_FLOW_ID, ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(111032127291547203.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'not wwv_flow_wizard_api.page_exists (p_flow_id => :FB_FLOW_ID,',
'                                     p_page_id => :F4000_P4705_PAGE_ID)',
'and',
'not wwv_flow_user_interface_dev.supports_tabs (',
'          p_application_id     => :FB_FLOW_ID, ',
'          p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25203205345891807.4009)
,p_list_item_display_sequence=>37
,p_list_item_link_text=>unistr('\8D77\52D5\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'192:193'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61195416258742575.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30D6\30E9\30F3\30C1\51E6\7406')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P4705_PAGE_MODE'
,p_list_item_disp_condition2=>'NORMAL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4702'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61195619302745857.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5F15\6570')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4706'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6889900708746289.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'269'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_queryandupdate
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(61344818353755082.4009)
,p_name=>'Wizard_QueryAndUpdate'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(228553803814437231.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'(  wwv_flow_user_interface_dev.supports_feature ( ',
'           p_user_interface_id => :P259_USER_INTERFACE_ID,',
'           p_name              => ''CLASSIC_REPORT'' )',
'    or wwv_flow_user_interface_dev.supports_feature ( ',
'           p_user_interface_id => :P259_USER_INTERFACE_ID,',
'           p_name              => ''INTERACTIVE_REPORT'' )',
'   or wwv_flow_user_interface_dev.supports_feature ( ',
'           p_user_interface_id => :P259_USER_INTERFACE_ID,',
'           p_name              => ''INTERACTIVE_GRID'' )',
'    )',
'and :P4041_TYPE <> ''L''',
''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4041'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(236520428554356872.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30EA\30B9\30C8\30FB\30D3\30E5\30FC\30FB\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:4041:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_user_interface_dev.supports_feature ( ',
'   p_user_interface_id => :P259_USER_INTERFACE_ID,',
'   p_name              => ''JQM_LIST_VIEW'' )',
'and :P4041_TYPE = ''L''',
''))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523946278406098620.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(244226925625575227.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'not wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61345251703760834.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30FB\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_NOT_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'P4041_IMPLEMENTATION'
,p_list_item_disp_condition2=>'INTERACTIVE:CLASSIC:LISTVIEW:IG'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4703'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1830144361723993.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30FB\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'P4041_IMPLEMENTATION'
,p_list_item_disp_condition2=>'INTERACTIVE:CLASSIC:LISTVIEW:IG'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4735'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61345778748773642.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8')
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4039'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61346217753778866.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8')
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_NOT_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'P4041_IMPLEMENTATION'
,p_list_item_disp_condition2=>'INTERACTIVE:CLASSIC:LISTVIEW'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'339,4776'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1831622212746953.4009)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8')
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'P4041_IMPLEMENTATION'
,p_list_item_disp_condition2=>'INTERACTIVE:CLASSIC:LISTVIEW'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4736'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(236520830914370945.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30EA\30B9\30C8\30FB\30D3\30E5\30FC\30FB\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:4775:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4775'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_basicreport_2
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(61699916790121470.4009)
,p_name=>'Wizard_BasicReport(2)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61700418314132934.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4701,4795,4796,4716,327,16'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4701'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523920690482388878.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(109443311830022928.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61849657525455286.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4701,4795,4796,4716,327,16'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4795'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(61849813580459070.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\5C5E\6027')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4701,4795,4796,4716,327,16'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4796'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6778417427639529.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4701,4795,4796,4716,327,16'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'327'
);
end;
/
prompt --application/shared_components/navigation/lists/authorization_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(62154210909909582.4009)
,p_name=>'authorization.reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(62154920044921741.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0\304C\6307\5B9A\3055\308C\3066\3044\308B\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8')
,p_list_item_link_target=>'javascript:popupURL(''f?p=4000:4046:&SESSION.::&DEBUG.::P4046_OPT:1'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(62154609655918761.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0\304C\6307\5B9A\3055\308C\3066\3044\306A\3044\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8')
,p_list_item_link_target=>'javascript:popupURL(''f?p=4000:4046:&SESSION.::&DEBUG.::P4046_OPT:2'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_calendar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(62236810622390487.4009)
,p_name=>'Wizard_Calendar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(62237153018397042.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4785'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523940665752859180.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(109671331726211248.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                   p_application_id     => :FB_FLOW_ID, ',
'                   p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(62237436934399132.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_disp_condition2=>'EASY_CALENDAR'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4790'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(62384616373249992.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30AB\30EC\30F3\30C0\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4791'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(26738320599084163.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30EA\30F3\30AF\306E\8A73\7D30')
,p_list_item_link_target=>'f?p=&APP_ID.:244:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'244'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(243644813740234048.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30D7\30ED\30BB\30B9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:157:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7148525331174291.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'281'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7148830872175915.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\6210\529F')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'282'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'282'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_list_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(62973516530710918.4009)
,p_name=>'shared.components.list.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16379422446669293.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EA\30B9\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:405:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'405'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(188592804007726720.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30EA\30B9\30C8\8A73\7D30')
,p_list_item_link_target=>'f?p=&APP_ID.:4050:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4050'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3734320150685363.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5B9A\7FA9')
,p_list_item_link_target=>'f?p=&FLOW_ID.:4050:&SESSION.::&DEBUG.:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4050'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165042505638783535.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30A8\30F3\30C8\30EA')
,p_list_item_link_target=>'f?p=&FLOW_ID.:145:&SESSION.::&DEBUG.::F4000_P4051_ID:&F4000_P4050_LIST_ID.'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'145,2,17'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'145,2,17'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(152909708490771744.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\672A\4F7F\7528')
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_lists where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'10'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(188112617636897422.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\30A8\30F3\30C8\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:557:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'557'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3698822128638837.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:156:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_lists where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'156,417'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11021905065645615.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'44'
);
end;
/
prompt --application/shared_components/navigation/lists/p1500_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(63310734885303893.4009)
,p_name=>'p1500 tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(63311397822303926.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B5\30F3\30D7\30EB\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A4\30F3\30B9\30C8\30FC\30EB')
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.:::50,RP:P50_APP_GROUP:SAMPLE'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(63311798337303926.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\751F\7523\6027\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A4\30F3\30B9\30C8\30FC\30EB')
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.:::50,RP:P50_APP_GROUP:PACKAGE'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/breadcrumb_entry_views
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(65506221314219691.4009)
,p_name=>'breadcrumb entry views'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(65506604823224331.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\968E\5C64\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:287:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'287'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'287'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(65507001060251687.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8868\5F62\5F0F\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:530:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'530'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'530'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(32758015061754994.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\3053\306E\30D6\30EC\30C3\30C9\30AF\30E9\30E0\5185\306B\304A\3051\308B\30A8\30F3\30C8\30EA\306E\89AA\306E\5909\66F4')
,p_list_item_link_target=>'f?p=&APP_ID.:36:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'36'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'36'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(167790417687129135.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\672A\4F7F\7528\306E\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30A8\30F3\30C8\30EA\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:463:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_formonequijoin
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(70041819940286906.4009)
,p_name=>'Wizard_FormOnEquijoin'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(70044515443302336.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4810'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523942466683902769.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wizard_api.page_exists (p_flow_id => :fb_flow_id, p_page_id => :F4000_P4810_PAGE_ID) = false',
'and',
'wwv_flow_user_interface_dev.supports_tabs (',
'    p_application_id     => :FB_FLOW_ID, ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(111107623526670500.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wizard_api.page_exists (p_flow_id => :fb_flow_id, p_page_id => :F4000_P4810_PAGE_ID) = false',
'and',
'not wwv_flow_user_interface_dev.supports_tabs (',
'          p_application_id     => :FB_FLOW_ID, ',
'          p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(70045210197305060.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'P4810_FORM_TYPE'
,p_list_item_disp_condition2=>'FORMONSQL:FORM'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4735'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(280259037283041066.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P4810_FORM_TYPE'
,p_list_item_disp_condition2=>'FORMONPROC'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4711'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(70045988490306843.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30D5\30A9\30FC\30E0\5C5E\6027')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P4700_SELECT_REPORT_TYPE'
,p_list_item_disp_condition2=>'FORM'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4812'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_button_template
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(79547928409156701.4009)
,p_name=>'Wizard Create Button Template'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(79552721077160159.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F5C\6210\30E1\30BD\30C3\30C9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(79555017842161642.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8A73\7D30')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'218'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(82926628922893097.4009)
,p_name=>'wizard Create Page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(82928115767899188.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4714'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523948020363125451.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(82930304553904440.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(82934321362911818.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'79'
);
end;
/
prompt --application/shared_components/navigation/lists/application_group_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(91618427870317883.4009)
,p_name=>'Application Group Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(92285408876511015.4009)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\5272\5F53\3066\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:736:&SESSION.::&DEBUG.:RP,736:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(91618806877321244.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\672A\5272\5F53\3066\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:736:&SESSION.::&DEBUG.:RP,736:P736_SHOW:UNASSIGNED:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ir_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(91747231305508774.4009)
,p_name=>'ir_tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(196353019228502005.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4FDD\5B58\3055\308C\305F\30EC\30DD\30FC\30C8\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3\306E\8868\793A')
,p_list_item_link_target=>'f?p=4350:93:&SESSION.:::RIR,CIR:IR_APPLICATION_ID,IR_PAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(442777026341677254.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=4350:92:&SESSION.:::RIR,CIR:IR_NFLOW_ID,IR_NPAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_interactive_report_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(92836304316872750.4009)
,p_name=>'wizard_create_interactive_report_page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(92837021977877846.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'326,759,98,961'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523948867681134525.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wizard_api.page_exists (',
'  p_flow_id => :fb_flow_id, ',
'  p_page_id => :F4000_P4701_FLOW_STEP_ID',
') = false',
'and',
'wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(92837632366880883.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wizard_api.page_exists (',
'  p_flow_id => :fb_flow_id, ',
'  p_page_id => :F4000_P4701_FLOW_STEP_ID',
') = false',
'and',
'not wwv_flow_user_interface_dev.supports_tabs (',
'          p_application_id     => :FB_FLOW_ID, ',
'          p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(92911312702130656.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_list_item_disp_condition=>'P759_REPORT_TYPE'
,p_list_item_disp_condition2=>'WEBSERVICE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'769'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(235189540462900083.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Web\53C2\7167\30BF\30A4\30D7')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P759_REPORT_TYPE'
,p_list_item_disp_condition2=>'WEBSERVICE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'778'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(235190199021968007.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Web\53C2\7167\60C5\5831')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P759_REPORT_TYPE'
,p_list_item_disp_condition2=>'WEBSERVICE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'779:781:859'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(235190496270971838.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30D1\30E9\30E1\30FC\30BF\304A\3088\3073\30AA\30D7\30B7\30E7\30F3')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P759_REPORT_TYPE'
,p_list_item_disp_condition2=>'WEBSERVICE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'782:783:860'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_page_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(92837202675352059.4009)
,p_name=>'edit Page Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(200213907900661288.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B3\30E1\30F3\30C8\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:4310:&SESSION.::&DEBUG.::F4000_P4310_ID:&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4001'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'f?p=4000:4310:&SESSION.::::F4000_P4310_ID:&FB_FLOW_ID.'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(138317724706866221.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30FC\30DE&P4003_THEME.\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:267:&SESSION.::&DEBUG.::P267_ID:&P4003_THEME_ID.:'
,p_list_item_disp_cond_type=>'ITEM_NOT_NULL_OR_ZERO'
,p_list_item_disp_condition=>'P4003_THEME'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(59111509360577354.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30C6\30F3\30D7\30EC\30FC\30C8\3092\5225\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30C6\30F3\30D7\30EC\30FC\30C8\306B\7F6E\63DB\3002')
,p_list_item_link_target=>'f?p=&APP_ID.:220:&SESSION.::&DEBUG.:220,222:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4003'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(92869222480537469.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\554F\5408\305B\306E\30BD\30FC\30B9\306E\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:450:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'420'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(72090306039442533.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('LOV\306E\5909\63DB')
,p_list_item_link_target=>'f?p=&APP_ID.:216:&SESSION.::&DEBUG.:216:P216_ITEM_ID:&F4000_P4311_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_step_items ',
'where ',
'id=:F4000_P4311_ID and ',
'(named_lov is null or named_lov = ''0'' or named_lov = ''%''||''null%'') and ',
':flow_page_id = ''4311'' and',
':P4311_LOV is not null'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(93046821589098546.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\540D\524D\4ED8\304DLOV\306E\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:4110:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':APP_PAGE_ID = 4311 and',
':P4311_NAMED_LOV is not null'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20045419823744097.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\30EA\30FC\30B8\30E7\30F3\4F4D\7F6E\306E\4F7F\7528\72B6\6CC1\306E\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:206:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4003'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'206'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(31490816073500952.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\884C\30BB\30EC\30AF\30BF\306E\8FFD\52A0')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_ADD_CHECK'');'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    has_row_selector boolean := false;',
'begin',
'    for c1 in (',
'        select 1 from ',
'    	wwv_flow_region_report_column',
'    	where region_id = :P420_REGION_ID',
'    	and column_alias like ''CHECK$%''',
'    ) loop',
'        has_row_selector := true;',
'    end loop;	',
'    return not has_row_selector',
'           and :FLOW_PAGE_ID     = 420',
'           and :P420_REGION_TYPE = wwv_flow_region_native.c_tabform;',
'end;'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(36704211967171442.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\5217\30EA\30F3\30AF\306E\8FFD\52A0')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_ADD_LINK'');'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':FLOW_PAGE_ID=420'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(36802112434805591.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\5C0E\51FA\5217\306E\8FFD\52A0')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_ADD_COLUMN'');'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':FLOW_PAGE_ID=420'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(205489829874815043.4009)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\30FB\30EC\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:173:&SESSION.::&DEBUG.::P173_SHOW:1:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4003'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(98663518101847762.4009)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\306E\5217\30D8\30C3\30C0\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:217:&SESSION.::&DEBUG.:RP,217:P217_PAGE:&FB_FLOW_PAGE_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'422'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(90724807717089029.4009)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\306E\7F6E\63DB')
,p_list_item_link_target=>'f?p=&APP_ID.:708:&SESSION.::&DEBUG.:708,711,713:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4003'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(95667030632845330.4009)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\306E\30B5\30D6\30B9\30AF\30E9\30A4\30D6\89E3\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:540:&SESSION.::&DEBUG.:540:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'4311'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(327359028639828493.4009)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\5217\306E\9806\5E8F\3068\30EA\30FC\30B8\30E7\30F3\30FB\30BD\30FC\30B9\306E\540C\671F\5316')
,p_list_item_link_target=>'f?p=&APP_ID.:276:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':FLOW_PAGE_ID=420'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/button_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(97266605334780088.4009)
,p_name=>'Button.Tasks'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_region
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(99487325551482211.4009)
,p_name=>'Wizard Create Region'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(99491916062486630.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8868\793A\5C5E\6027')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'474'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4016,91,2002,2003,799,313'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(99492810454489250.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_plugins',
' where flow_id = case',
'                   when :F4000_P4016_SOURCE_TYPE like ''NATIVE_%'' then 4411',
'                   else to_number(:FB_FLOW_ID)',
'                 end',
'   and plugin_type = ''REGION TYPE''',
'   and name        = substr(:F4000_P4016_SOURCE_TYPE, 8)',
'   and instr('':''||standard_attributes||'':'', '':SOURCE'') > 0',
'union all',
'select 1',
'  from dual',
' where substr(:F4000_P4016_SOURCE_TYPE, 1, 7) not in (''NATIVE_'', ''PLUGIN_'',''JSTREE'')',
'   and substr(:P4016_SOURCE_TYPE,1,7) not in (''JSTREE'')',
'   and :APP_PAGE_ID <> 7000'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4017,407,683'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33251100809321342.4009)
,p_list_item_display_sequence=>21
,p_list_item_link_text=>unistr('\8A2D\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:4475:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'substr(:F4000_P4016_SOURCE_TYPE, 1, 7) in (''NATIVE_'', ''PLUGIN_'') and v(''F4000_P4016_SOURCE_TYPE'') not in ( wwv_flow_region_native.c_sql_report, wwv_flow_region_native.c_ir )'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4475'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(467785503184960335.4009)
,p_list_item_display_sequence=>24
,p_list_item_link_text=>unistr('\8868/\30D3\30E5\30FC\306E\6240\6709\8005\3068\540D\524D')
,p_list_item_link_target=>'f?p=&APP_ID.:913:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P4016_SOURCE_TYPE'
,p_list_item_disp_condition2=>'JSTREE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'913'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(468007923718165656.4009)
,p_list_item_display_sequence=>26
,p_list_item_link_text=>unistr('\554F\5408\305B')
,p_list_item_link_target=>'f?p=&APP_ID.:916:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P4016_SOURCE_TYPE'
,p_list_item_disp_condition2=>'JSTREE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'916'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(468013031477253048.4009)
,p_list_item_display_sequence=>28
,p_list_item_link_text=>unistr('WHERE\304A\3088\3073ORDER BY')
,p_list_item_link_target=>'f?p=&APP_ID.:918:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P4016_SOURCE_TYPE'
,p_list_item_disp_condition2=>'JSTREE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'918'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(467781614210859444.4009)
,p_list_item_display_sequence=>29
,p_list_item_link_text=>unistr('\30C4\30EA\30FC\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:925:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P4016_SOURCE_TYPE'
,p_list_item_disp_condition2=>'JSTREE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'925'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(124579604486159014.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:831:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':APP_PAGE_ID not in (7000, 537) and',
'substr(:F4000_P4016_SOURCE_TYPE, 1, 7) not in (''PLUGIN_'',''JSTREE'',''STATIC_'',''NATIVE_'') or ',
'v(''F4000_P4016_SOURCE_TYPE'') in ( wwv_flow_region_native.c_sql_report )'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'831'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(99494305710491468.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\8868\793A')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'474'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4018:692'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_button
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(99644130313723164.4009)
,p_name=>'Wizard Create Button'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37299718588274733.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30DC\30BF\30F3\4F4D\7F6E')
,p_list_item_link_target=>'f?p=&FLOW_ID.:379:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'379'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(99645624706725694.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DC\30BF\30F3\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4731'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25085622684777401.4009)
,p_list_item_display_sequence=>17
,p_list_item_link_text=>unistr('\8868\793A\30D7\30ED\30D1\30C6\30A3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'190'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(99646320393727719.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30AF\30EA\30C3\30AF\3055\308C\305F\3068\304D\306E\30A2\30AF\30B7\30E7\30F3')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_list_item_disp_condition=>'F4000_P4731_BUTTON_NAME'
,p_list_item_disp_condition2=>'FLOW_RESET_BUTTON'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4732'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(99647016511729483.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\8868\793A')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4733'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_item
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(99795626246952886.4009)
,p_name=>'Wizard Create Item'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(99797121286955232.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8868\793A\4F4D\7F6E\304A\3088\3073\540D\524D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4717,690'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(99797817188957126.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A2\30A4\30C6\30E0\5C5E\6027')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_plugins',
' where flow_id = case',
'                   when :F4000_P4717_DISPLAY_AS like ''NATIVE_%'' then 4411',
'                   else to_number(:FB_FLOW_ID)',
'                 end',
'   and plugin_type = ''ITEM TYPE''',
'   and name        = substr(:F4000_P4717_DISPLAY_AS, 8)',
'   and instr('':''||standard_attributes||'':'', '':VISIBLE:'') > 0'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4721'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(99813700138980273.4009)
,p_list_item_display_sequence=>22
,p_list_item_link_text=>'LOV'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_plugin_dev.is_required (',
'    p_application_id => :FB_FLOW_ID,',
'    p_plugin_type    => ''ITEM TYPE'',',
'    p_plugin_name    => :F4000_P4717_DISPLAY_AS,',
'    p_feature        => ''LOV'' )',
'or (   :F4000_P4717_DISPLAY_AS = ''NATIVE_DISPLAY_ONLY''',
'   and :P4480_ATTRIBUTE_02     = ''LOV'' /* based on */',
'   )'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4719'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(99798513522958795.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'690'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4718,691'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_computation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(100146402180654207.4009)
,p_name=>'Wizard Create Computation'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_validation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(100288425710144762.4009)
,p_name=>'Wizard Create Validation'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_branches
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(100367812684257161.4009)
,p_name=>'Wizard Create Branches'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_process
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(100583211191032690.4009)
,p_name=>'Wizard Create Process'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_parent_tab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(100804924518345585.4009)
,p_name=>'Wizard Create Parent Tab'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(100806819126348134.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\89AA\30BF\30D6')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4725'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(100810614813350139.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30FC\30B2\30C3\30C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4726'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(100812510716351983.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\9806\5E8F\304A\3088\3073\8868\793A')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4727'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_standard_tab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(100922117111440207.4009)
,p_name=>'Wizard Create Standard Tab'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(101132401201918650.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\65B0\898F\307E\305F\306F\65E2\5B58\306E\30BF\30D6\30FB\30BB\30C3\30C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'90'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(101135523617923462.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30BF\30D6\30FB\30BB\30C3\30C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'93:94'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(101900810245789723.4009)
,p_list_item_display_sequence=>16
,p_list_item_link_text=>unistr('\89AA\30BF\30D6')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'95'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(101901507441790975.4009)
,p_list_item_display_sequence=>17
,p_list_item_link_text=>unistr('\30BF\30D6\540D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'96'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(100923610426443280.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30AB\30EC\30F3\30C8\30FB\30DA\30FC\30B8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4722'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(100924705466445586.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\9806\5E8F\304A\3088\3073\30A4\30E1\30FC\30B8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4723'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(100925402231447156.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\8868\793A\6761\4EF6')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4724'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(101374521774334568.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'92'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(103870209211856610.4009)
,p_name=>'Wizard Create Navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(196983008322003866.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30E1\30BD\30C3\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4023,4024,4025,392,497,392,22'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'22'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(196902902998292741.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30A4\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:392:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4023,4024,4025,392,497,22'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'392'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(103874127098863515.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C5E\6027')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4023,4024,4025,392,22'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4023'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(103875221491866142.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30BF\30FC\30B2\30C3\30C8')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4023,4024,4025,392,22'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4024'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(103876314806869217.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\8868\793A\6761\4EF6')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4023,4024,4025,392,22'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4025'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(196965009680777178.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF')
,p_list_item_link_target=>'f?p=&APP_ID.:497:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'497'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'497'
);
end;
/
prompt --application/shared_components/navigation/lists/create_theme_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(106473613360356705.4009)
,p_name=>'create.theme.progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(106476128944361283.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30E1\30BD\30C3\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:207:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'207'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(274111320953713585.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:1207:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(106477412106365802.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:208:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'208,267'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(106508026960460990.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:210:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1207,207,208,210'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'210'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_theme
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(106491204103410821.4009)
,p_name=>'copy.theme'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(106491709991412525.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\30B3\30D4\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:401:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'401'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(106495009083421774.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:410:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'410'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_region_template
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(106501409747300331.4009)
,p_name=>'Wizard - Create Region Template'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(17580228667075703.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30BF\30A4\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:162:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'162'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(106505327419307356.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\4F5C\6210\30E1\30BD\30C3\30C9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'901:920:931:941:951:238:211:348'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(106947820318367086.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\540D\524D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'902:924:935:945:955:240:225:652:349:350'
);
end;
/
prompt --application/shared_components/navigation/lists/theme_change_identification_number
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(106512001249472508.4009)
,p_name=>'theme.change.identification.number'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(106514712808485302.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\756A\53F7')
,p_list_item_link_target=>'f?p=&APP_ID.:397:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'397'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(106515019042487151.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:400:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'400'
);
end;
/
prompt --application/shared_components/navigation/lists/sssc
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(107370720292626153.4009)
,p_name=>'sssc'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(107372308995632305.4009)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:512:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/page_64.gif'
,p_list_item_icon_attributes=>'height="64" width="64" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(107373730120638467.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:513:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/edit_64.gif'
,p_list_item_icon_attributes=>'height="64" width="64" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(107789910275250763.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:518:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/prod_apex_64.gif'
,p_list_item_icon_attributes=>'height="64" width="64" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sss_standard
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(109521305294221172.4009)
,p_name=>'sss.standard'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(109521827242236960.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\4FDD\8B77\304C\7121\52B9\3067\3059\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(110690209142337959.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DA\30FC\30B8\306B\3001\30C1\30A7\30C3\30AF\30B5\30E0\306F\5FC5\8981\3042\308A\307E\305B\3093\3002')
,p_list_item_link_target=>'f?p=&APP_ID.:9008:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(109522205902240205.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0(\5236\9650\4ED8\304D\30A2\30A4\30C6\30E0\3092\9664\304F)\306F\3001URL\306B\6E21\3055\308C\308B\5F15\6570\3092\4F7F\7528\3057\3066\8A2D\5B9A\3067\304D\307E\3059\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(110689114205329908.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0(\5236\9650\4ED8\304D\30A2\30A4\30C6\30E0\3092\9664\304F)\306F\3001URL\306B\8A2D\5B9A\3055\308C\305F\5F15\6570\3092\4F7F\7528\3057\3066\8A2D\5B9A\3067\304D\307E\3059\3002')
,p_list_item_link_target=>'f?p=&APP_ID.:9008:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(110694132391373080.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\306E<i>\300CHTTP\5165\529B\3067\306E\30A8\30B9\30B1\30FC\30D7\300D</i>\5C5E\6027\306F\3001\7D99\7D9A\3057\3066\76E3\8996\3055\308C\307E\3059\3002')
,p_list_item_link_target=>'f?p=&APP_ID.:9008:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sss_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(109642120442735590.4009)
,p_name=>'sss.progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(109642530139738374.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\64CD\4F5C\306E\9078\629E')
,p_list_item_link_target=>'f?p=&APP_ID.:525:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'525'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114177918693680391.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\304A\3088\3073\30A2\30A4\30C6\30E0\306E\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:9006:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9006'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(109642810530742159.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9007,9008'
);
end;
/
prompt --application/shared_components/navigation/lists/authenitcation_create
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(109993128340686080.4009)
,p_name=>'authenitcation.create'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(109993532150687193.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30E1\30BD\30C3\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:815:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'815'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(109993802845688109.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B9\30AD\30FC\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:816:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'816,818'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_template
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(110615031296644849.4009)
,p_name=>'Copy Template'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(110663804762646615.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5225\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\306E\30C6\30F3\30D7\30EC\30FC\30C8\306E\30B3\30D4\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:162:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/view_templates_task
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(111435127334933550.4009)
,p_name=>'View Templates Task'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(111437316383939828.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\306E\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:4003:&SESSION.::&DEBUG.:4003,RIR:IR_THEME,P4003_THEME:&FB_THEME_ID.,&FB_THEME_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1218253654992416500.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\524A\9664')
,p_list_item_link_target=>'f?p=&FLOW_ID.:221:&SESSION.::&DEBUG.:221::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_breadcrumb_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(111619820846587947.4009)
,p_name=>'shared.components.breadcrumb.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(111620411281594656.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:546:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'546'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183472317966243127.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\968E\5C64')
,p_list_item_link_target=>'f?p=&APP_ID.:586:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'586'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183475506631296658.4009)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>unistr('\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185231613287431276.4009)
,p_list_item_display_sequence=>8
,p_list_item_link_text=>unistr('\4F8B\5916')
,p_list_item_link_target=>'f?p=&APP_ID.:545:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'545'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(111620004355592595.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:365:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'365'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(111620206086593181.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:369:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'369'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_sqlquery_on_ws_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(114018423833281484.4009)
,p_name=>'wizard_sqlquery_on_ws_page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(206858322178171502.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\304A\3088\3073\30EA\30FC\30B8\30E7\30F3\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'776'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523950895298145683.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(206858932567174539.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114018618816281486.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Web\53C2\7167\30BF\30A4\30D7')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'778'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114018928354281487.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Web\53C2\7167\60C5\5831')
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'779:781:859'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114019202992281488.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30D1\30E9\30E1\30FC\30BF\304A\3088\3073\30AA\30D7\30B7\30E7\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'782:783:860'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114162210486514180.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_for_pages=>'786'
);
end;
/
prompt --application/shared_components/navigation/lists/sss_extended
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(114371329791585494.4009)
,p_name=>'sss.extended'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114418321983210267.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8: &P9007_PAGE_LEVEL.')
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114418726485211591.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0: &P9007_APP_ITEM_LEVEL.')
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114420921767219662.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30FB\30A8\30F3\30C8\30EA\30FB\30A2\30A4\30C6\30E0: &P9007_DATA_ENTRY_ITEM_LEVEL.')
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114421526616221094.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\8868\793A\5C02\7528\30A2\30A4\30C6\30E0: &P9007_DISPLAY_ONLY_ITEM_LEVEL.')
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114422831464222441.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\306E\30AF\30ED\30B9\30B5\30A4\30C8\30FB\30B9\30AF\30EA\30D7\30C6\30A3\30F3\30B0\4FDD\8B77: &P9007_PAGE_ITEM_ESCAPE.')
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_theme_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(114829600122838504.4009)
,p_name=>'workspace theme progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114830714320842637.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:764:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'754'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'764'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114831221593844797.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\540D\524D\306E\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:789:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'754'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'789'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(114831926787846213.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:762:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'754'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'762'
);
end;
/
prompt --application/shared_components/navigation/lists/dependencies_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(117039522797176386.4009)
,p_name=>'Dependencies Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(117040128338177988.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('DDL\306E\751F\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:637:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_app_from_spreasheet_opt
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(118042377093675208.4009)
,p_name=>'create.app.from.spreasheet.opt'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(118042502492675209.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D5\30A1\30A4\30EB\306E\30A2\30C3\30D7\30ED\30FC\30C9')
,p_list_item_link_target=>'f?p=4500:3100:&SESSION.:::3100,3110,3120:P3100_SOURCE_TYPE:FILE'
,p_list_item_icon=>'a-Icon icon-region- icon-file-upload'
,p_list_text_01=>'Upload CSV, XLSX, XML, JSON data'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(118042942497675210.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\30FB\30A2\30F3\30C9\30FB\30DA\30FC\30B9\30C8')
,p_list_item_link_target=>'f?p=4500:3100:&SESSION.:::3100,3110,3120:P3100_SOURCE_TYPE:COPY_PASTE'
,p_list_item_icon=>'a-Icon icon-region- icon-clipboard'
,p_list_text_01=>'Copy and paste CSV data'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/comments
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(123545913988020430.4009)
,p_name=>'comments'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(123546321607022623.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:1234:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1234'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(123546700960026141.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:1235:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1235'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(123547007539028056.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:1236:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1236'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1236'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(125612105656334840.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:1237:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from WWV_FLOW_APP_COMMENTS',
'where flow_id = :fb_flow_id',
'and security_group_id = :flow_security_group_id'))
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1237,1238'
);
end;
/
prompt --application/shared_components/navigation/lists/create_application_image_nav
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(128724959151960807.4009)
,p_name=>'Create Application - Image Nav'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(128725983083960807.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\65B0\898F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=4020:1:&SESSION.:NEW:&DEBUG.:1,5,130,150,170,250:::'
,p_list_item_icon=>'gi-icon-app-builder'
,p_list_text_01=>unistr('\65E2\5B58\306E\30C7\30FC\30BF\306B\30DA\30FC\30B8\3092\8FFD\52A0\3057\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\6A5F\80FD\3092\9078\629E\3057\3001\30C6\30FC\30DE\3092\8A2D\5B9A\3057\3001\305D\306E\4ED6\306E\30AA\30D7\30B7\30E7\30F3\3092\69CB\6210\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(128728137528960809.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D5\30A1\30A4\30EB\304B\3089')
,p_list_item_link_target=>'f?p=4500:3100:&SESSION.:::3100,3110,3120,APEX$DATALOAD_COLUMNS:P3100_SOURCE_TYPE:FILE'
,p_list_item_icon=>'gi-icon-create-app-websheet'
,p_list_text_01=>unistr('CSV\3001XLSX\3001XML\307E\305F\306FJSON\30D5\30A1\30A4\30EB\3092\30A2\30C3\30D7\30ED\30FC\30C9\3059\308B\304B\3001\30C7\30FC\30BF\3092\30B3\30D4\30FC\3057\3066\8CBC\308A\4ED8\3051\3066\304B\3089\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F5C\6210\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(128728733474960809.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\751F\7523\6027\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:50:::'
,p_list_item_icon=>'gi-icon-create-app-pkg-apps'
,p_list_text_01=>unistr('\542B\307E\308C\3066\3044\308B\591A\304F\306E\30B5\30F3\30D7\30EB\304A\3088\3073\751F\7523\6027\5411\4E0A\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E1\3064\3092\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30AE\30E3\30E9\30EA\30FC\304B\3089\30A4\30F3\30B9\30C8\30FC\30EB\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_application_step_1
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(139866417493663090.4009)
,p_name=>'create application step 1'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(139870325374684265.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30E1\30BD\30C3\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:56:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'56'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(139870631607686094.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\9078\629E')
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'84,3009'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'887'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23857907389713612.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\306E\30BF\30FC\30B2\30C3\30C8\3092\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:3009:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'3009,84'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(139871004034687499.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'130,84'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_createwizard
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(147241516822234215.4009)
,p_name=>'Wizard_CreateWizard'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(147245007333238659.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'107'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149093831604062677.4009)
,p_list_item_display_sequence=>12
,p_list_item_link_text=>unistr('\30EA\30FC\30B8\30E7\30F3\5C5E\6027')
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'141'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523941800717896380.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149094527075064841.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                   p_application_id     => :FB_FLOW_ID, ',
'                   p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(147245704529239920.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'108'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_createtree
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(147901626307825228.4009)
,p_name=>'Wizard_CreateTree'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(147904320916827688.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'112'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523941400867890059.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(157593326518482453.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                   p_application_id     => :FB_FLOW_ID, ',
'                   p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(156039022711192668.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\8868/\30D3\30E5\30FC\306E\6240\6709\8005\3068\540D\524D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'114'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(156305124810057724.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\554F\5408\305B')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'116'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(157687416449669471.4009)
,p_list_item_display_sequence=>55
,p_list_item_link_text=>unistr('WHERE\304A\3088\3073ORDER BY')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'126'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12341809367052610.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30C4\30EA\30FC\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'68'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7244112889498460.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'284'
);
end;
/
prompt --application/shared_components/navigation/lists/confirm_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(148407226188594759.4009)
,p_name=>'confirm.page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(148409915022610438.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\5B9F\884C')
,p_list_item_link_target=>'f?p=&FB_FLOW_ID.:&F4000_RUN_EDIT_PAGE.:&SESSION.'
,p_list_item_icon=>'htmldb/builder/run_flow.gif'
,p_list_item_icon_attributes=>'width="100" height="75" alt="&F4000_RUN."'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(148417611521656692.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:4500:&SESSION.::&DEBUG.::FB_FLOW_ID,FB_FLOW_PAGE_ID,F4000_P1_FLOW,F4000_P4150_GOTO_PAGE,F4000_P1_PAGE:&FB_FLOW_ID.,&F4000_RUN_EDIT_PAGE.,&FB_FLOW_ID.,&F4000_RUN_EDIT_PAGE.:'
,p_list_item_icon=>'htmldb/builder/edit_page.gif'
,p_list_item_icon_attributes=>'width="100" height="75" alt="&EDIT."'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/p4651_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(153106004753776646.4009)
,p_name=>'p4651_tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(153106418259780522.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30BD\30FC\30B9\3092\5143\306B\623B\3059')
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.::P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_PAGE_PLUGS,PLUG_SOURCE,&F4000_P4651_ID.,F4000_P4651_PLUG_SOURCE,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(137083202078724995.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306B\79FB\884C')
,p_list_item_link_target=>'f?p=&APP_ID.:758:&SESSION.::&DEBUG.:758:P758_REGION_ID:&F4000_P4651_ID.:'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':F4000_P4651_PLUG_SOURCE_TYPE IN ( wwv_flow_region_native.c_sql_report, wwv_flow_region_native.c_tabform ) and',
'not wwv_flow_page_dev.is_jqm_ui (',
'    p_application_id => :FB_FLOW_ID,',
'    p_page_id        => :FB_FLOW_PAGE_ID )'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22605518586883916.4009)
,p_list_item_display_sequence=>46
,p_list_item_link_text=>unistr('HTML5\30C1\30E3\30FC\30C8\3078\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:280:&SESSION.::&DEBUG.::P280_REGION_ID:&F4000_P4651_ID.:'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':F4000_P4651_PLUG_SOURCE_TYPE = wwv_flow_region_native.c_legacy_simple_chart'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/p4307_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(153171308852373878.4009)
,p_name=>'P4307_TASKS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(153178223312397008.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30A2\30A4\30C6\30E0\306E\691C\7D22')
,p_list_item_link_target=>'javascript:popUp(''f?p=4000:273:&SESSION.::::F4000_P273_PAGE:&FB_FLOW_PAGE_ID.'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(153174705173382332.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D8\30C3\30C0\30FC\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3092\5143\306B\623B\3059')
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.:88:P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_TEMPLATES,HEADER_TEMPLATE,&F4000_P4307_ID.,F4000_P4307_HEADER_TEMPLATE,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(153175014524385009.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DC\30C7\30A3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3092\5143\306B\623B\3059')
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.:88:P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_TEMPLATES,BOX,&F4000_P4307_ID.,F4000_P4307_BOX,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(153175723181387558.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30D5\30C3\30BF\30FC\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3092\5143\306B\623B\3059')
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.::P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_TEMPLATES,FOOTER_TEMPLATE,&F4000_P4307_ID.,F4000_P4307_FOOTER_TEMPLATE,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(436861003623980561.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\306E\30D7\30EC\30D3\30E5\30FC')
,p_list_item_link_target=>'javascript:popUp(''f?p=4000:0:&SESSION.:APPLICATION_PROCESS=PAGE_TEMPLATE_PREVIEW:::F4000_P4029_TEMPLATE_ID:&F4000_P4307_ID.'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/p4653_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(153210815104527139.4009)
,p_name=>'P4653_TASKS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(153212128263530955.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30A4\30C6\30E0\306E\691C\7D22')
,p_list_item_link_target=>'javascript:popUp(''f?p=4000:273:&SESSION.::::F4000_P273_PAGE:&FB_FLOW_PAGE_ID.'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(153214009001534772.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30BD\30FC\30B9\3092\5143\306B\623B\3059')
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.:88:P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_PAGE_PLUG_TEMPLATES,TEMPLATE,&F4000_P4653_ID.,F4000_P4653_TEMPLATE,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/p4312_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(153243919053613380.4009)
,p_name=>'P4312_TASKS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(153244608795619959.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D7\30ED\30BB\30B9\30FB\30BD\30FC\30B9\3092\5143\306B\623B\3059')
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.:88:P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_STEP_PROCESSING,PROCESS_SQL_CLOB,&F4000_P4312_ID.,F4000_P4312_PROCESS_SQL2,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_remote_servers_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(154051976265844427.4009)
,p_name=>'shared.components.remote_servers.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(154052121551844430.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('REST\5BFE\5FDCSQL')
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1600'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(154052580732844434.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:1602:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1602'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(154052913913844434.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:1603:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1603'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_credential_stores_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(154583731613661573.4009)
,p_name=>'shared.components.credential_stores.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(154583988141661575.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Web\8CC7\683C\8A3C\660E')
,p_list_item_link_target=>'f?p=&APP_ID.:1620:&SESSION.::&DEBUG.:1620:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1620'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(154584303580661578.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:1622:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1622'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(154584705715661578.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:1623:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1623'
);
end;
/
prompt --application/shared_components/navigation/lists/export_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(158038003748775992.4009)
,p_name=>'Export Page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(158038407557777097.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:164:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25720216186980294.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(200682401972525159.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'FB_FLOW_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168868615219020507.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8\30FB\30EA\30DD\30B8\30C8\30EA\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_lov
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(161740513874429436.4009)
,p_name=>'Wizard Create LOV'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202904909845918905.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'137'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(161742306326432962.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\540D\524D\304A\3088\3073\30BF\30A4\30D7')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4004'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11540348458195148.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('LOV\30BD\30FC\30B9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4080'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(161745627233438452.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\9759\7684\5024')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'F4000_P4004_TYPE'
,p_list_item_disp_condition2=>'STATIC'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4014'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11542493794381119.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5217\30DE\30C3\30D4\30F3\30B0')
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'F4000_P4004_TYPE'
,p_list_item_disp_condition2=>'DYNAMIC'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4081'
);
end;
/
prompt --application/shared_components/navigation/lists/cross_application_reports_attributes
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(162360828277873558.4009)
,p_name=>'Cross Application Reports / Attributes'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(162361613863878819.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:9010:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-application-attributes'
,p_list_text_01=>unistr('\5404\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\30FB\30AB\30A6\30F3\30C8\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(205251931899374098.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\30FB\30B9\30C6\30FC\30BF\30B9\3068\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30BF\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:103:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-app-status'
,p_list_text_01=>unistr('\5404\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30B9\30C6\30FC\30BF\30B9\3092\78BA\8A8D\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(162362223560881642.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:9012:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-build-options'
,p_list_text_01=>unistr('\3059\3079\3066\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(131390824277396235.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\958B\767A\8005\306E\30B3\30E1\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:380:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-comments'
,p_list_text_01=>unistr('\3059\3079\3066\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\306E\30B3\30E1\30F3\30C8\3092\78BA\8A8D\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(217724513488899294.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\958B\767A\8005\30B3\30E1\30F3\30C8\306E\30AB\30EC\30F3\30C0')
,p_list_item_link_target=>'f?p=&APP_ID.:665:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-comments-calendar'
,p_list_text_01=>unistr('\3059\3079\3066\306E\30B3\30E1\30F3\30C8\304C\3044\3064\4F5C\6210\3055\308C\305F\304B\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/translation_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(165621520543370755.4009)
,p_name=>'translation.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(171880500668996222.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30AD\30B9\30C8\30FB\30E1\30C3\30BB\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:4006:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-create-manage-text'
,p_list_text_01=>unistr('\30C6\30AD\30B9\30C8\30FB\30E1\30C3\30BB\30FC\30B8\3092\4F5C\6210\304A\3088\3073\7BA1\7406\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165622300589374384.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\52D5\7684\7FFB\8A33')
,p_list_item_link_target=>'f?p=&APP_ID.:4756:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-manage-dynamic-translation'
,p_list_text_01=>unistr('\52D5\7684\7FFB\8A33\30EA\30DD\30B8\30C8\30EA\3092\7BA1\7406\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(28665818452018310.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\7FFB\8A33\30EA\30DD\30B8\30C8\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:702:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-manually-edit-translation'
,p_list_text_01=>unistr('\7FFB\8A33\30EA\30DD\30B8\30C8\30EA\306E\7FFB\8A33\6E08\30C6\30AD\30B9\30C8\3092\624B\52D5\3067\7DE8\96C6\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/parent_tab_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(165863110284077420.4009)
,p_name=>'parent.tab.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165865017557079566.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\89AA\30BF\30D6\30FB\30BB\30C3\30C8\540D\306E\5909\66F4')
,p_list_item_link_target=>'f?p=&FLOW_ID.:332:&SESSION.::&DEBUG.:332::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165865522059080812.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8868\793A\9806\5E8F\306E\5909\66F4')
,p_list_item_link_target=>'f?p=&FLOW_ID.:331:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165867932102083690.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\898F\89AA\30BF\30D6\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=&FLOW_ID.:4725:&SESSION.::&DEBUG.:4725,4726,4727::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/standard_tab_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(165876716780098264.4009)
,p_name=>'standard.tab.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165879130286102126.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\6A19\6E96\30BF\30D6\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:9000:&SESSION.::&DEBUG.::F4000_P9000_PAGE:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/parent_tab_tasks_p9000
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(165884427300110704.4009)
,p_name=>'parent_tab_tasks_p9000'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165885332495112173.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\89AA\30BF\30D6\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:398:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/use_first_available_free_page_p4701
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(165926019653231499.4009)
,p_name=>'use first available free page p4701'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165926526579233478.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\4F7F\7528\53EF\80FD\306A\6700\521D\306E\7A7A\304D\30DA\30FC\30B8\3092\4F7F\7528')
,p_list_item_link_target=>'f?p=&FLOW_ID.:4701:&SESSION.::&DEBUG.:4701::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/tasks_page_4714
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(165935217145249689.4009)
,p_name=>'tasks_page_4714'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165938632036253973.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30ED\30B0\30A4\30F3\30FB\30DA\30FC\30B8\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=4000:500:&SESSION.::NO'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/how_to_translate
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(165943028704262550.4009)
,p_name=>'how_to_translate'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165944104940265156.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A00\8A9E\306E\5B9A\7FA9')
,p_list_item_link_target=>'f?p=&APP_ID.:4751:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-map-primary-language'
,p_list_text_01=>unistr('\7FFB\8A33\3055\308C\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\30D7\30E9\30A4\30DE\30EA\8A00\8A9E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\30DE\30C3\30D7\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165945811520267011.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\7FFB\8A33\53EF\80FD\306A\30C6\30AD\30B9\30C8\306E\30B7\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:385:&SESSION.::&DEBUG.::P385_ACTION:SEED:'
,p_list_item_icon=>'icon-util-seed-translatable-text'
,p_list_text_01=>unistr('\30D7\30E9\30A4\30DE\30EA\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\7FFB\8A33\30EA\30DD\30B8\30C8\30EA\306B\7FFB\8A33\53EF\80FD\30C6\30AD\30B9\30C8\3092\30B3\30D4\30FC\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(162434002630201887.4009)
,p_list_item_display_sequence=>24
,p_list_item_link_text=>unistr('XLIFFF\7FFB\8A33\30D5\30A1\30A4\30EB\306E\30C0\30A6\30F3\30ED\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:4750:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-download-xlif-translation'
,p_list_text_01=>unistr('\7FFB\8A33\30EA\30DD\30B8\30C8\30EA\306E\7FFB\8A33\53EF\80FD\30C6\30AD\30B9\30C8\3092\4F7F\7528\3057\305F\30D5\30A1\30A4\30EB\3092\30C0\30A6\30F3\30ED\30FC\30C9\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165947319138269194.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30C6\30AD\30B9\30C8\306E\7FFB\8A33')
,p_list_item_link_target=>'f?p=&APP_ID.:306:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-translate-text'
,p_list_text_01=>unistr('\7FFB\8A33\7528\306EXLIFF\30D5\30A1\30A4\30EB\3092\9001\4FE1\3059\308B\304B\3001\7FFB\8A33\30EA\30DD\30B8\30C8\30EA\3092\624B\52D5\3067\7DE8\96C6\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165949127796271740.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('XLIFF\7FFB\8A33\30D5\30A1\30A4\30EB\306E\9069\7528')
,p_list_item_link_target=>'f?p=&APP_ID.:4758:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-upload-apply-xliff'
,p_list_text_01=>unistr('\7FFB\8A33\6E08\30C6\30AD\30B9\30C8\3092\4F7F\7528\3057\305FXLIFF\30D5\30A1\30A4\30EB\3092\30A2\30C3\30D7\30ED\30FC\30C9\3057\3066\3001\7FFB\8A33\3092\7FFB\8A33\30EA\30DD\30B8\30C8\30EA\306B\9069\7528\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(162434303453211574.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\7FFB\8A33\6E08\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30D1\30D6\30EA\30C3\30B7\30E5')
,p_list_item_link_target=>'f?p=&APP_ID.:385:&SESSION.::&DEBUG.::P385_ACTION:PUBLISH:'
,p_list_item_icon=>'icon-util-publish-translated-applications'
,p_list_text_01=>unistr('\30E6\30FC\30B6\30FC\304C\7FFB\8A33\3055\308C\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F7F\7528\3067\304D\308B\3088\3046\306B\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_nav_bar_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(166766500720858594.4009)
,p_name=>'shared.components.nav_bar.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(166769319685865035.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30AF\30E9\30B7\30C3\30AF\30FB\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\30FB\30A8\30F3\30C8\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:4005:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4005'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(166770609981869522.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:153:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_icon_bar where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'153'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(201265401410394101.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_icon_bar where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'54'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10056426696402671.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:394:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_icon_bar where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'394'
);
end;
/
prompt --application/shared_components/navigation/lists/list_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(167577629010196113.4009)
,p_name=>'list tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(167578526025204737.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\3053\306E\30EA\30B9\30C8\3092\30AB\30EC\30F3\30C8\30FB\30DA\30FC\30B8\306B\8FFD\52A0')
,p_list_item_link_target=>'f?p=&APP_ID.:4016:&SESSION.::&DEBUG.:181,4016,4017,4018,259,380:P4016_SOURCE_TYPE,P407_IDENTIFY_LIST,F4000_P4016_TITLE:LIST,&F4000_P4050_LIST_ID.,&P4050_LIST_NAME.:'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/replace_templates_train
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(168734227577365586.4009)
,p_name=>'replace templates train'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168734406930369089.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30BF\30A4\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:708:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'708'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168734718358372471.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\306E\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:711:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'711'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168734923899374008.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:713:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'713'
);
end;
/
prompt --application/shared_components/navigation/lists/create_list_train
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(169186610834587350.4009)
,p_name=>'create list train'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10678101114291405.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'105'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(169186923301591019.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\540D\524D\304A\3088\3073\30BF\30A4\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:427:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'427'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(169189328373658702.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\554F\5408\305B\307E\305F\306F\9759\7684\5024')
,p_list_item_link_target=>'f?p=&APP_ID.:440:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'440,464'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(169192814961711597.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:529:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'529,734'
);
end;
/
prompt --application/shared_components/navigation/lists/page_region_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(171723423034567648.4009)
,p_name=>'page.region.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6821101659113491.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30EA\30FC\30B8\30E7\30F3\30FB\30BF\30A4\30C8\30EB\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:438:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193870804947518508.4009)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('\30EA\30FC\30B8\30E7\30F3\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:249:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(171780931017721336.4009)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('PL/SQL\30EA\30FC\30B8\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:480:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11339330772242551.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30AB\30B9\30BF\30DE\30A4\30BA\30FB\30EA\30FC\30B8\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:70:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47911925376585041.4009)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\30EA\30FC\30B8\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:864:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_button_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(171743703949609405.4009)
,p_name=>'page.button.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(240733721440954144.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30DC\30BF\30F3\30FB\30E9\30D9\30EB\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:250:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193784520531105981.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5225\306E\30DC\30BF\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:548:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194556907147613285.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\30DC\30BF\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:878:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_item_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(171752432131627079.4009)
,p_name=>'page.item.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(233014630647109050.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30A2\30A4\30C6\30E0\30FB\30E9\30D9\30EB\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(233013122336106602.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30A2\30A4\30C6\30E0\30FB\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:408:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(251134632073178851.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30A2\30A4\30C6\30E0\30FB\30D8\30EB\30D7\306E\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:389:&SESSION.::&DEBUG.:RIR:IR_FLOW_STEP_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193917900275255057.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:547:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15591500615424210.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30D1\30B9\30EF\30FC\30C9\30FB\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:59:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194531425614476695.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:869:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_validation_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(171763620666671065.4009)
,p_name=>'page.validation.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(240772729414032103.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\691C\8A3C\30A8\30E9\30FC\30FB\30E1\30C3\30BB\30FC\30B8\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:214:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(242557604450198238.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5225\306E\691C\8A3C')
,p_list_item_link_target=>'f?p=&APP_ID.:501:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194198200000377701.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\691C\8A3C')
,p_list_item_link_target=>'f?p=&APP_ID.:883:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_computation_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(171769406383685886.4009)
,p_name=>'page.computation.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(240790724743068620.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\8A08\7B97\30A8\30E9\30FC\30FB\30E1\30C3\30BB\30FC\30B8\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:215:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(224269225570329050.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5225\306E\8A08\7B97')
,p_list_item_link_target=>'f?p=&APP_ID.:549:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194540617827512267.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\8A08\7B97')
,p_list_item_link_target=>'f?p=&APP_ID.:877:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_process_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(171773504090694644.4009)
,p_name=>'page.process.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(240759729367003715.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30D7\30ED\30BB\30B9\30FB\30E1\30C3\30BB\30FC\30B8\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:213:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(225375711989419725.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5225\306E\30D7\30ED\30BB\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:552:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194248225420820252.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\30D7\30ED\30BB\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:866:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/application_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(177830919883437702.4009)
,p_name=>'Application Utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177833406770462269.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30C0\30C3\30B7\30E5\30DC\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:71:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-app-dashboard'
,p_list_text_01=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30B5\30DE\30EA\30FC\3092\78BA\8A8D\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885595358268728653.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A2\30C9\30D0\30A4\30B6')
,p_list_item_link_target=>'javascript:apex.navigation.popup({ url: ''f?p=&APP_ID.:8101:&SESSION.::&DEBUG.:8101'', width: 1000, height: 800 }); void(0);'
,p_list_item_icon=>'icon-util-advisor'
,p_list_text_01=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\5BFE\3057\3066\30D7\30ED\30B0\30E9\30DF\30F3\30B0\30FB\30A8\30E9\30FC\3084\30D9\30B9\30C8\30FB\30D7\30E9\30AF\30C6\30A3\30B9\306A\3069\306E\69D8\3005\306A\30C1\30A7\30C3\30AF\3092\5B9F\884C\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1661255424982169004.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:89:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-upgrade-app'
,p_list_text_01=>unistr('\65B0\898F\30EA\30EA\30FC\30B9\3078\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9\5F8C\3001\30A2\30C3\30D7\30B0\30EC\30FC\30C9\5BFE\8C61\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306B\6700\65B0\306E\6A5F\80FD\304C\542B\307E\308C\3066\3044\308B\3053\3068\3092\78BA\8A8D\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(466865607820087113.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\6700\8FD1\66F4\65B0\3055\308C\305F\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:RIR:IR_UPDATED_BY:&APP_USER.:'
,p_list_item_icon=>'icon-util-recent-pages'
,p_list_text_01=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\884C\308F\308C\305F\30DA\30FC\30B8\306E\66F4\65B0\306E\5C65\6B74\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1160235601024416138.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:889:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-attribute-dictionary'
,p_list_text_01=>unistr('\9078\629E\3055\308C\305F\30DA\30FC\30B8\306E\30A2\30A4\30C6\30E0/\5217\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\30FB\30C7\30D5\30A9\30EB\30C8\3092\7BA1\7406\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177831203693437706.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\5909\66F4\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:358:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-change-history'
,p_list_text_01=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\884C\308F\308C\305F\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\66F4\65B0\306E\8A73\7D30\30EC\30DD\30FC\30C8\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1160225427040278954.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\306E\4F9D\5B58\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:425:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-object-dependencies'
,p_list_text_01=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3088\3063\3066\53C2\7167\3055\308C\305F\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\78BA\8A8D\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492241124877437516.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30C7\30D0\30C3\30B0\30FB\30E1\30C3\30BB\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:666:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-debug-messages'
,p_list_text_01=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3088\3063\3066\751F\6210\3055\308C\305F\30C7\30D0\30C3\30B0\30FB\30E1\30C3\30BB\30FC\30B8\3092\78BA\8A8D\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1173931504465813227.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('&PRODUCT_NAME.\30D3\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:714:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-apex-views'
,p_list_text_01=>unistr('&PRODUCT_NAME.\30E1\30BF\30C7\30FC\30BF\306B\5BFE\3059\308B\69D8\3005\306A\30D3\30E5\30FC\3092\554F\3044\5408\305B\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492240609162423534.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8\30FB\30EA\30DD\30B8\30C8\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-export-repository'
,p_list_text_01=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A8\30AF\30B9\30DD\30FC\30C8\306E\5C65\6B74\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_item
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(179572716597169307.4009)
,p_name=>'Wizard Copy Item'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(197073903769725734.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\65B0\898F\30DA\30FC\30B8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'171'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(179579323055181481.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\898F\30A2\30A4\30C6\30E0')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'172'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_authentication_scheme_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(180433926348108856.4009)
,p_name=>'shared.components.authentication_scheme.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180435618514116022.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:801:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'801'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180437106178121918.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:817:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'817'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192776728065739452.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:554:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'554'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_authorization_scheme_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(180462022520306486.4009)
,p_name=>'shared.components.authorization_scheme.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180462914339313581.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:4070:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4070'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180463224729316523.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:129:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'129'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47955811298564811.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\5225')
,p_list_item_link_target=>'f?p=&APP_ID.:340:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'340'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180463832347318756.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:4045:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4045'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192784124265814091.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:558:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'558'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_button
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(181185105878280365.4009)
,p_name=>'Wizard Copy Button'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15213429898992140.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\65B0\898F\30DA\30FC\30B8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'231'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181188725059286630.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\898F\30DC\30BF\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'191'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_dynamic_action
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(181501623296103719.4009)
,p_name=>'copy.dynamic_action'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181503411306109716.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\3059\308B\52D5\7684\30A2\30AF\30B7\30E7\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'728'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181503816154111137.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\5148\30DA\30FC\30B8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'796'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181504222388112936.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\898F\52D5\7684\30A2\30AF\30B7\30E7\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'797'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_map
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(183700922666750405.4009)
,p_name=>'Wizard Map'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183701218164750406.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DE\30C3\30D7')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'798'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183701622501750407.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30DE\30C3\30D7\30FB\30BD\30FC\30B9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'894'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183702018273750407.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'895'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523939647506761828.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183702427699750407.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                   p_application_id     => :FB_FLOW_ID, ',
'                   p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183703223516750408.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30DE\30C3\30D7\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'900'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183703610515750408.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\554F\5408\305B')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'833'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_map_region
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(185155905837041142.4009)
,p_name=>'Wizard Create Map Region'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185157403628041147.4009)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>unistr('\30DE\30C3\30D7\30FB\30BD\30FC\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:840:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':P181_REGION_TYPE = ''Map'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'840'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185157801641041147.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8868\793A\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4016,91,2002,2003,799,313'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185158611339041148.4009)
,p_list_item_display_sequence=>17
,p_list_item_link_text=>unistr('\8A2D\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:4475:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'substr(:F4000_P4016_SOURCE_TYPE, 1, 7) in (''NATIVE_'', ''PLUGIN_'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4475'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185159024483041149.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\554F\5408\305B')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4017,407,683,537'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185159826358041149.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\8868\793A')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4018:692'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_shortcut
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(185305822581982553.4009)
,p_name=>'Wizard Create Shortcut'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185307615464985837.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F5C\6210\30E1\30BD\30C3\30C9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'131'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185308412229987392.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B7\30E7\30FC\30C8\30AB\30C3\30C8\306E\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'174'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_pull_shortcuts
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(185309707700989517.4009)
,p_name=>'Wizard Pull Shortcuts'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185313922784997656.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F5C\6210\30E1\30BD\30C3\30C9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'131'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185314719980998966.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\5143')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'132'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(185315516746000474.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\898F\30B7\30E7\30FC\30C8\30AB\30C3\30C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'133'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_shortcut_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(186543329326722942.4009)
,p_name=>'shared.components.shortcut.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(186545123935725534.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B7\30E7\30FC\30C8\30AB\30C3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:4047:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4047'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(186545918543727968.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:175:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from WWV_FLOW_SHORTCUTS where flow_id = :FB_FLOW_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'175'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10983506807371682.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:41:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'41'
);
end;
/
prompt --application/shared_components/navigation/lists/page_item_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(186703109122914661.4009)
,p_name=>'page.item.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(186714413638927747.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=4000:4200:&SESSION.::NO:4200'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4200'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(28724428204475253.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30A2\30A4\30C6\30E0\306E\518D\5272\5F53\3066')
,p_list_item_link_target=>'f?p=&APP_ID.:706:&SESSION.::&DEBUG.:RP,706:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'706'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40289317195455624.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\8907\6570\306E\30A2\30A4\30C6\30E0\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'7'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47958103726591074.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:854:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'854:408:6:547:59:869:389'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11258131416157207.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:62:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'62'
);
end;
/
prompt --application/shared_components/navigation/lists/page_validation_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(186826132498329280.4009)
,p_name=>'page.validation.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(186832108129340579.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\691C\8A3C')
,p_list_item_link_target=>'f?p=&APP_ID.:4205:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4205'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(57912215798286576.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8907\6570\306E\691C\8A3C\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:743:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'743'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193767726569918515.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:851:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'851:214:501:883'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11340930817563888.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:66:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'66'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_pull_security_schemes
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(186904126354727159.4009)
,p_name=>'Wizard Pull Security Schemes'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(186905916218731926.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F5C\6210\30E1\30BD\30C3\30C9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'184'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(186906712336733691.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\5143')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'185'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(186907507376736030.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\540D\524D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'186'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_authorization_schemes
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(186911322244744240.4009)
,p_name=>'Wizard Create Authorization Schemes'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(186913114912747650.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F5C\6210\30E1\30BD\30C3\30C9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'184'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(186914408226750829.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8A73\7D30')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'188'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_plug_in_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(188993730020080349.4009)
,p_name=>'shared.components.plug-in.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(188994312836084773.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4400:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4400'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(188994619762086758.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:4420:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4420'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193358210391475853.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:841:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'841'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_report_query_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(193369209650497455.4009)
,p_name=>'shared.components.report_query.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193369600778504265.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\554F\5408\305B')
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1100'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193369910128507049.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:843:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'843'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_report_layout_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(193374517232546937.4009)
,p_name=>'shared.components.report_layout.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193374801581546942.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:1400:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1400'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193375221285546942.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:844:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'844'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_navbar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(193684503309130516.4009)
,p_name=>'Wizard Copy NavBar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193686328960133836.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F5C\6210\30E1\30BD\30C3\30C9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'22'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193687125078135642.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\5143')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'134'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193688421627137255.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\3057\3044\540D\524D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'135'
);
end;
/
prompt --application/shared_components/navigation/lists/page_dynamic_action_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(194153003566161205.4009)
,p_name=>'page.dynamic_action.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194154929885168734.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\52D5\7684\30A2\30AF\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:699:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_region_utilities_region_counts
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(194250609883844198.4009)
,p_name=>'page.region.utilities.region.counts'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194252923250844202.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30BF\30A4\30D7\5225\306E\30AB\30A6\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:128:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_region.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194253310565844203.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\8868\793A\30DD\30A4\30F3\30C8\5225\306E\30AB\30A6\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:459:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_region.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_branch_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(194565421168929524.4009)
,p_name=>'page.branch.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194566126273929526.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5225\306E\30D6\30E9\30F3\30C1')
,p_list_item_link_target=>'f?p=&APP_ID.:563:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194566502198929526.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\30D6\30E9\30F3\30C1')
,p_list_item_link_target=>'f?p=&APP_ID.:885:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_feedback_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(197011632441427104.4009)
,p_name=>'create feedback page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(197011929178427105.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF\30FB\30DA\30FC\30B8\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:849:&SESSION.::&DEBUG.:849:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'894'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_region
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(197233420990021629.4009)
,p_name=>'Wizard Copy Region'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(197241701365030751.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\5148\30DA\30FC\30B8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'194'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(197243528741033202.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\898F\30EA\30FC\30B8\30E7\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'195'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_views_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(200452609222306546.4009)
,p_name=>'APEX Views Navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(200453224460311015.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30D3\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:714:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'714'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(201268128688684688.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30C4\30EA\30FC\30FB\30D3\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:905:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'905'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(200453701734313844.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5217\306E\9078\629E')
,p_list_item_link_target=>'f?p=&APP_ID.:892:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P892_VIEW_NAME is not null or',
':APP_PAGE_ID = ''892'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'892'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(200454107275315499.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30D5\30A3\30EB\30BF')
,p_list_item_link_target=>'f?p=&APP_ID.:893:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P892_SELECTED_COLS'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'893'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(200454411431316639.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\7D50\679C')
,p_list_item_link_target=>'f?p=&APP_ID.:896:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P892_SELECTED_COLS'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'896'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_page_wiz_steps
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(202931703979545993.4009)
,p_name=>'copy_page_wiz_steps'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202933009304556968.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\30B3\30D4\30FC\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:618:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'618'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202934128351562472.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\3059\308B\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:621:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'621'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(204089926319940378.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_link_target=>'f?p=&APP_ID.:617:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_list_item_disp_condition=>'P621_NAVIGATION_TYPE'
,p_list_item_disp_condition2=>'L'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'671'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1556125534907719472.4009)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:617:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P621_NAVIGATION_TYPE'
,p_list_item_disp_condition2=>'L'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'671'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202934605626565380.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:622:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'622'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202935113937567735.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'LOV'
,p_list_item_link_target=>'f?p=&APP_ID.:623:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'623'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202935522249570117.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30EA\30B9\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:625:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'625'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202935827097571532.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:627:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'627'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(208023117796803899.4009)
,p_list_item_display_sequence=>75
,p_list_item_link_text=>unistr('\30D6\30E9\30F3\30C1')
,p_list_item_link_target=>'f?p=&APP_ID.:593:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'593'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202936132291573046.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:628:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'628'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_pull_lov
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(202952222735973765.4009)
,p_name=>'Wizard Pull LOV'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202954017990975969.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F5C\6210\30E1\30BD\30C3\30C9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'137'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202954813893977815.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\5143 ')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'138'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202955610442979398.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\898FLOV')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'139'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_lov_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(203029530177365353.4009)
,p_name=>'shared.components.lov.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203035015081372358.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'LOV'
,p_list_item_link_target=>'f?p=&APP_ID.:4110:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4110'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(184816719223361035.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('NULL\30C6\30AD\30B9\30C8\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:169:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'169'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(184821331999411979.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30ED\30FC\30AB\30EB\306B\5B9A\7FA9')
,p_list_item_link_target=>'f?p=&APP_ID.:419:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'419'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(184821605811413905.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:178:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'178'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(188105422784870512.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\6761\4EF6\4ED8\304D\30A8\30F3\30C8\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:556:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'556'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203035810552374398.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1  from WWV_FLOW_LISTS_OF_VALUES$ where flow_id = :FB_FLOW_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'142'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(631171523671392471.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:87:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1  from WWV_FLOW_LISTS_OF_VALUES$ where flow_id = :FB_FLOW_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'87'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(193350901986416680.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:686:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'686'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_page_wiz_step1
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(203583512908643146.4009)
,p_name=>'copy_page_wiz_step1'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203584617756644537.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\30B3\30D4\30FC\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:618:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'618'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203803214077652910.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:308:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'308'
);
end;
/
prompt --application/shared_components/navigation/lists/p224_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(205602222789276628.4009)
,p_name=>'p224 tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1036212995590553756.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:260:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/export_component_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(207503732215648915.4009)
,p_name=>'export component tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(207504110528652105.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.:AC:&DEBUG.::P688_MODE:AC:'
,p_list_item_current_type=>'PLSQL_EXPRESSION'
,p_list_item_current_for_pages=>'nvl(:P688_MODE,''AC'') = ''AC'''
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(207504421956655470.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5225\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.:PD:&DEBUG.::P688_MODE:PD:'
,p_list_item_current_type=>'PLSQL_EXPRESSION'
,p_list_item_current_for_pages=>'nvl(:P688_MODE,''PD'') = ''PD'''
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(228921921121485140.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3\306E\30B9\30C6\30FC\30BF\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.::P688_MODE:BO:'
,p_list_item_current_type=>'PLSQL_EXPRESSION'
,p_list_item_current_for_pages=>'nvl(:P688_MODE,''AC'') = ''BO'''
);
end;
/
prompt --application/shared_components/navigation/lists/install_preview
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(210424614987781460.4009)
,p_name=>'Install Preview'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(210426801959787134.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A4\30F3\30B9\30C8\30FC\30EB\30FB\30B9\30AF\30EA\30D7\30C8\306E\30D7\30EC\30D3\30E5\30FC')
,p_list_item_link_target=>'javascript:popupURL(''f?p=&APP_ID.:2109:&SESSION.::&DEBUG.::P2109_MODE:INSTALL'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/component_export_train
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(210787017222419064.4009)
,p_name=>'component export train'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(210787424148421054.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'688'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(210787931074423052.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:637:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'637'
);
end;
/
prompt --application/shared_components/navigation/lists/page_group_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(213192710092707758.4009)
,p_name=>'page.group.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(213193117365709843.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B0\30EB\30FC\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:520:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'520:521'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7889418131882539.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5272\5F53\3066')
,p_list_item_link_target=>'f?p=&APP_ID.:522:&SESSION.::&DEBUG.:RP,522:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'522'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(213326924824175665.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B0\30EB\30FC\30D7\3054\3068\306E\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:528:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'528'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_template
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(222829818333256486.4009)
,p_name=>'Wizard Copy Template'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(222830025179256507.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\3059\308B\30C6\30F3\30D7\30EC\30FC\30C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'584'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(222830500690256514.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\898F\30C6\30F3\30D7\30EC\30FC\30C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'538:568:569:571:564:573:574:636'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_web_source
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(226545212901831813.4009)
,p_name=>'Wizard Create Web Source'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(226545418188831828.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4E00\822C')
,p_list_item_link_target=>'f?p=&APP_ID.:1941:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(226545892098831833.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30EA\30E2\30FC\30C8\30FB\30B5\30FC\30D0\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:1942:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(226546270015831833.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\8A8D\8A3C')
,p_list_item_link_target=>'f?p=&APP_ID.:1943:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(226680867806416802.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30D1\30E9\30E1\30FC\30BF')
,p_list_item_link_target=>'f?p=&APP_ID.:1944:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'1944'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(226546658284831833.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30D7\30EC\30D3\30E5\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:1946:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/deinstall_preview
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(227753031474767408.4009)
,p_name=>'Deinstall Preview'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(227754420869773895.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\524A\9664\30B9\30AF\30EA\30D7\30C8\306E\30D7\30EC\30D3\30E5\30FC')
,p_list_item_link_target=>'javascript:popupURL(''f?p=&APP_ID.:2109:&SESSION.::&DEBUG.::P2109_MODE:DEINSTALL'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_process
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(227766223920945009.4009)
,p_name=>'Wizard Copy Process'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(227766422394945011.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\3059\308B\30D7\30ED\30BB\30B9')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'590'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(227766714836945011.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D7\30ED\30BB\30B9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'645'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_validation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(228167614670175482.4009)
,p_name=>'Wizard Copy Validation'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_branch
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(228256415837925869.4009)
,p_name=>'Wizard Copy Branch'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(228256632661925872.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\3059\308B\30D6\30E9\30F3\30C1')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'587'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(228256900182925873.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30D6\30E9\30F3\30C1\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'685'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_computation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(228264919955974373.4009)
,p_name=>'Wizard Copy Computation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(228266003117978994.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\3059\308B\8A08\7B97')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'592'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(228266412121981558.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8A08\7B97\30AA\30D7\30B7\30E7\30F3')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'597'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_list_train
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(231136205422723196.4009)
,p_name=>'copy list train'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(231137016157726205.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:658:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'658'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(231137725854729050.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30EA\30B9\30C8\3092\6307\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:602:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'602,663'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_tab_form
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(235134732046512759.4009)
,p_name=>'wizard_create_tab_form'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(235134961627512789.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'326,759'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(235135788187512791.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wizard_api.page_exists (',
'  p_flow_id => :fb_flow_id, ',
'  p_page_id => :F4000_P4701_FLOW_STEP_ID',
') = false',
'and',
'wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(235135346026512790.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wizard_api.page_exists (',
'  p_flow_id => :fb_flow_id, ',
'  p_page_id => :F4000_P4701_FLOW_STEP_ID',
') = false',
'and',
'not wwv_flow_user_interface_dev.supports_tabs (',
'          p_application_id     => :FB_FLOW_ID, ',
'          p_user_interface_id => :P259_USER_INTERFACE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(235136153806512791.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\8868\5F62\5F0F\30D5\30A9\30FC\30E0\30FB\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_NOT_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'P759_REPORT_TYPE'
,p_list_item_disp_condition2=>'WEBSERVICE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'245'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_web_sources_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(241353531173849237.4009)
,p_name=>'shared.components.web_sources.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(241353749272849252.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Web\30BD\30FC\30B9\30FB\30E2\30B8\30E5\30FC\30EB')
,p_list_item_link_target=>'f?p=&APP_ID.:1901:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(241354167823849253.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:1902:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(247801890036355717.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:1903:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/remoteserver_create
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(249337602894822823.4009)
,p_name=>'remoteserver.create'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/remoteserver_createnew
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(249355742923907578.4009)
,p_name=>'remoteserver.createnew'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(249355942729907578.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4E00\822C')
,p_list_item_link_target=>'f?p=&APP_ID.:1615:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(249356348643907578.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\8A8D\8A3C')
,p_list_item_link_target=>'f?p=&APP_ID.:1616:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/websrcmodule_create
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(249385562937130742.4009)
,p_name=>'websrcmodule.create'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(249385724604130742.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30E1\30BD\30C3\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:1905:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(249386134393130742.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\5143')
,p_list_item_link_target=>'f?p=&APP_ID.:1906:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P1905_ACTION'
,p_list_item_disp_condition2=>'COPY'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(249386558688130742.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:1907:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/application_attributes_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(274897624522614662.4009)
,p_name=>'application attributes tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(274898302490617757.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5B9A\7FA9')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_DEFN'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4001'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(274905604268646630.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BB\30AD\30E5\30EA\30C6\30A3')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_SEC'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'509'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33757928911956810.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30B0\30ED\30FC\30D0\30EA\30BC\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_GLOBAL'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'506'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(42233410928343483.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9')
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_USERINTERFACE'');'
,p_required_patch=>wwv_flow_api.id(235700916833599805.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'197, 677'
);
end;
/
prompt --application/shared_components/navigation/lists/p4775_view_ui_default
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(355041902343274398.4009)
,p_name=>'P4775_view.ui.default'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(355042125578274398.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\8868\306E\30C7\30D5\30A9\30EB\30C8\306E\8868\793A')
,p_list_item_link_target=>'javascript:popupURL(''f?p=4000:391:&SESSION.:::391,RP:P391_SCHEMA,P391_TABLE:&F4000_P4703_TABLE_OWNER.,&P4703_TABLE_NAME.'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'769,4795,4811,4017'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(355042426513274399.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8868\30C7\30A3\30AF\30B7\30E7\30CA\30EA\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=4500:802:&SESSION.::NO:RP,802:P800_SCHEMA,P802_TABLE_ID:&F4000_P4703_TABLE_OWNER.,&P4775_TABLE_ID.'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'769,4795,4811,4017'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(355042700306274399.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\306E\8868\793A')
,p_list_item_link_target=>'javascript:popupURL(''f?p=4000:579:&SESSION.:::RIR:'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(355043025721274399.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=4500:6:&SESSION.::NO:RIR:P800_SCHEMA:&F4000_P4703_TABLE_OWNER.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(384736293175059813.4009)
,p_name=>'APEX 5 - Administration'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(387750990921837996.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\7BA1\7406')
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(488619320836057116.4009)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(572044671779464700.4009)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('\30B5\30FC\30D3\30B9\306E\7BA1\7406')
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697357627145483514.4009)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\30B5\30FC\30D3\30B9\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(572044671779464700.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697357856198483516.4009)
,p_list_item_display_sequence=>215
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(572044671779464700.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(572699887011597076.4009)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('\30B5\30FC\30D3\30B9\30FB\30EA\30AF\30A8\30B9\30C8\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(572044671779464700.4009)
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697358175538483516.4009)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\8A2D\5B9A')
,p_list_item_link_target=>'f?p=4350:17:&SESSION.::NO:RP::'
,p_parent_list_item_id=>wwv_flow_api.id(572044671779464700.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697358473589483516.4009)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\304A\77E5\3089\305B\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(572044671779464700.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(572045479875476436.4009)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\30E6\30FC\30B6\30FC\3068\30B0\30EB\30FC\30D7\306E\7BA1\7406')
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(572046067324491819.4009)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('\30A2\30AF\30C6\30A3\30D3\30C6\30A3\306E\30E2\30CB\30BF\30FC')
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(10593027526205581)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1250496483207165958.4009)
,p_list_item_display_sequence=>600
,p_list_item_link_text=>unistr('\30D1\30B9\30EF\30FC\30C9\306E\5909\66F4')
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_security_scheme=>wwv_flow_api.id(10593027526205581)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(384991882401692897.4009)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:1500:&SESSION.::&DEBUG.::P1500_SHOW::'
,p_list_item_icon_alt_attribute=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC\306E\30C9\30EA\30EB\30C0\30A6\30F3')
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_api.id(178938910382761975)
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384997181185692900.4009)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:DATABASE:'
,p_parent_list_item_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384997442589692900.4009)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('Web\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:WEBSHEET:'
,p_parent_list_item_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697212495047631708.4009)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384998086804692900.4009)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:56:&SESSION.::&DEBUG.:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID::'
,p_parent_list_item_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384998642350692901.4009)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\30A4\30F3\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384998906454692901.4009)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697375495888714842.4009)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(385002826736692904.4009)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_parent_list_item_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(699060618186707760.4009)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(385002826736692904.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(699060810272707760.4009)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(385002826736692904.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697218772666647649.4009)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC\306E\30C7\30D5\30A9\30EB\30C8\5024')
,p_list_item_link_target=>'f?p=&APP_ID.:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(385002826736692904.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697219764020653222.4009)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30C6\30FC\30DE')
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(385002826736692904.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697219311840650861.4009)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B0\30EB\30FC\30D7')
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_api.id(385002826736692904.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697220796797659605.4009)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>unistr('Application Express\30D3\30E5\30FC')
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(385002826736692904.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697220390514657026.4009)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\9593\30EC\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(385002826736692904.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697375794010714843.4009)
,p_list_item_display_sequence=>169
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(385003150432692904.4009)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('\79FB\884C')
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(384992396663692898.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384992635866692898.4009)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('SQL\30EF\30FC\30AF\30B7\30E7\30C3\30D7')
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>unistr('SQL\30EF\30FC\30AF\30B7\30E7\30C3\30D7\306E\30C9\30EA\30EB\30C0\30A6\30F3')
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_api.id(178939331963761975)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384993534292692898.4009)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\30AA\30D6\30B8\30A7\30AF\30C8\30FB\30D6\30E9\30A6\30B6')
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(384992635866692898.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384993809500692899.4009)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('SQL\30B3\30DE\30F3\30C9')
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(384992635866692898.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697366669537617727.4009)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('SQL\30B9\30AF\30EA\30D7\30C8')
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(384992635866692898.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_parent_list_item_id=>wwv_flow_api.id(384992635866692898.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697367098027622850.4009)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697367200739625365.4009)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697367573471631495.4009)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30FB\30EF\30FC\30AF\30B7\30E7\30C3\30D7')
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697367739947635075.4009)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>unistr('\30AF\30A8\30EA\30FC\30FB\30D3\30EB\30C0\30FC')
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713688567094388045.4009)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>unistr('\30AF\30A4\30C3\30AFSQL')
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(670876181059880723.4009)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>unistr('\30B5\30F3\30D7\30EB\30FB\30C7\30FC\30BF\30BB\30C3\30C8')
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697367942849638524.4009)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>unistr('DDL\306E\751F\6210')
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697368124231641328.4009)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\30C7\30D5\30A9\30EB\30C8\5024')
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697369742087658694.4009)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>unistr('\30B9\30AD\30FC\30DE\306E\6BD4\8F03')
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697368385017644833.4009)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('\8868\306E\30E1\30BD\30C3\30C9')
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697370148167661241.4009)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>unistr('\3054\307F\7BB1')
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697369196932653004.4009)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>unistr('\30AA\30D6\30B8\30A7\30AF\30C8\30FB\30EC\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697368631376650206.4009)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\306B\3064\3044\3066')
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697369518797655840.4009)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30E2\30CB\30BF\30FC')
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(697366891742619697.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(385003728877692904.4009)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>unistr('RESTful\30B5\30FC\30D3\30B9')
,p_list_item_link_target=>'f?p=4850:500:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(384992635866692898.4009)
,p_security_scheme=>wwv_flow_api.id(802892920094782611)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384992969361692898.4009)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\30C1\30FC\30E0\958B\767A')
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>unistr('\30C1\30FC\30E0\958B\767A\306E\30C9\30EA\30EB\30C0\30A6\30F3')
,p_list_text_01=>'tab-team-dev'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384995344172692899.4009)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>unistr('\30E9\30D9\30EB')
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(384992969361692898.4009)
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384995062424692899.4009)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>unistr('\30DE\30A4\30EB\30B9\30C8\30F3')
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(384992969361692898.4009)
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384995637536692899.4009)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8')
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(384992969361692898.4009)
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384995957053692899.4009)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(384992969361692898.4009)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697376668510727547.4009)
,p_list_item_display_sequence=>355
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(384992969361692898.4009)
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697269568743762526.4009)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF')
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(384992969361692898.4009)
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(657003378451122018.4009)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30AE\30E3\30E9\30EA')
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_text_01=>'tab-apps'
,p_security_scheme=>wwv_flow_api.id(1697324305399287638)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697272719949805657.4009)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>unistr('\751F\7523\6027\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:PACKAGE'
,p_parent_list_item_id=>wwv_flow_api.id(657003378451122018.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(765895458897082014.4009)
,p_list_item_display_sequence=>415
,p_list_item_link_text=>unistr('\30B5\30F3\30D7\30EB\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:SAMPLE'
,p_parent_list_item_id=>wwv_flow_api.id(657003378451122018.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(765895759935083878.4009)
,p_list_item_display_sequence=>417
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(657003378451122018.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697275314204852736.4009)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>unistr('\7BA1\7406')
,p_list_item_link_target=>'f?p=4750:6:&SESSION.::&DEBUG.:6:'
,p_parent_list_item_id=>wwv_flow_api.id(657003378451122018.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/attribute_dictionary
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(445192614743849621.4009)
,p_name=>'Attribute Dictionary'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(445192924596849626.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\3078\306E\30A2\30AF\30BB\30B9')
,p_list_item_link_target=>'f?p=4500:6:&SESSION.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/p164_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(445352903500710112.4009)
,p_name=>'P164_TASKS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(445353209286710113.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:4900:&SESSION.:'
,p_list_item_current_for_pages=>'4900'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(445353627788710114.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.:'
,p_list_item_current_for_pages=>'688'
);
end;
/
prompt --application/shared_components/navigation/lists/standard_tab_display
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(454874132315440955.4009)
,p_name=>'Standard Tab Display'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(454874414531440958.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306F\3001<b>\6A19\6E96\30BF\30D6\30FB\30BB\30C3\30C8</b>\3092\6307\5B9A\3057\307E\3059\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(454881521635541944.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\300C<b>\30BF\30D6\30FB\30A8\30F3\30C8\30EA</b>\300D\306F\3001\30DA\30FC\30B8\3092\300C<b>\30BF\30D6\30FB\30DA\30FC\30B8</b>\300D\307E\305F\306F\300C<b>\3053\306E\30BF\30D6\3092\30AB\30EC\30F3\30C8\306B\6307\5B9A\3059\308B\30DA\30FC\30B8</b>\300D\3068\3057\3066\6307\5B9A\3057\307E\3059\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(454874801932440962.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\300C<b>\30DA\30FC\30B8\30FB\30C6\30F3\30D7\30EC\30FC\30C8</b>\300D\306F\3001\300C<b>\6A19\6E96\30BF\30D6</b>\300D\306E\8868\793A\304C\53EF\80FD\3067\3059\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(454875215155440962.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30BF\30D6\30FB\30A8\30F3\30C8\30EA\306E<b>\8868\793A\6761\4EF6</b>\3067\306F\3001\30BF\30D6\306E\8868\793A\306F\56DE\907F\3055\308C\307E\305B\3093')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(454920400070828946.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30BF\30D6\30FB\30A8\30F3\30C8\30EA\306E\300C<b>\8A8D\53EF\30B9\30AD\30FC\30E0</b>\300D\3067\306F\3001\30BF\30D6\306E\8868\793A\306F\56DE\907F\3055\308C\307E\305B\3093\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/parent_tab_display
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(455042113172478942.4009)
,p_name=>'Parent Tab Display'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(455042409640478944.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306B\6B63\5E38\306B\300C<b>\6A19\6E96\30BF\30D6</b>\300D\304C\8868\793A\3055\308C\307E\3059\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(455051127155492375.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\300C<b>\6A19\6E96\30BF\30D6</b>\300D\3067\306F\3001\6B63\3057\3044<b>\89AA\30BF\30D6\30FB\30BB\30C3\30C8</b>\304C\6307\5B9A\3055\308C\307E\3059\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(455060118431660179.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\300C<b>\89AA\30BF\30D6</b>\300D\306F\3001<b>\6A19\6E96\30BF\30D6\30FB\30BB\30C3\30C8\306E\30AB\30EC\30F3\30C8</b>\5C5E\6027\306E\6B63\3057\3044\30BF\30D6\30FB\30BB\30C3\30C8\3092\6307\5B9A\3057\307E\3059\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(455051817936499217.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\300C<b>\30DA\30FC\30B8\30FB\30C6\30F3\30D7\30EC\30FC\30C8</b>\300D\3067\306F\3001\300C<b>\6A19\6E96\30BF\30D6</b>\300D\3068\300C<b>\89AA\30BF\30D6</b>\300D\3092\8868\793A\3067\304D\307E\3059\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(455054405216552285.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\89AA\30BF\30D6\306E\300C<b>\8868\793A\6761\4EF6</b>\300D\3067\306F\3001\89AA\30BF\30D6\306E\8868\793A\306F\56DE\907F\3055\308C\307E\305B\3093\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(455055223701567123.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\89AA\30BF\30D6\306E\300C<b>\8A8D\53EF\30B9\30AD\30FC\30E0</b>\300D\3067\306F\3001\89AA\30BF\30D6\306E\8868\793A\306F\56DE\907F\3055\308C\307E\305B\3093\3002')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_advanced_migration
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(484017424976766961.4009)
,p_name=>'Wizard_Advanced_Migration'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(499114818402832919.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\9078\629E')
,p_list_item_link_target=>'f?p=&APP_ID.:911:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(484017612155766970.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30C3\30D7\30B0\30EC\30FC\30C9\3059\308B\691C\8A3C\306E\9078\629E')
,p_list_item_link_target=>'f?p=&APP_ID.:86:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'86'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(484017930508766978.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\691C\8A3C\3092\5B9F\884C\3057\306A\3044\30DC\30BF\30F3\306E\9078\629E')
,p_list_item_link_target=>'f?p=&APP_ID.:646:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'646'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(631593123192499955.4009)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\5E38\306B\5B9F\884C\3059\308B\691C\8A3C\306E\9078\629E')
,p_list_item_link_target=>'f?p=&APP_ID.:862:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'862'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492683002038349240.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30A2\30C3\30D7\30B0\30EC\30FC\30C9  ')
,p_list_item_link_target=>'f?p=&APP_ID.:383:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'383'
);
end;
/
prompt --application/shared_components/navigation/lists/export
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(486268530815434681.4009)
,p_name=>'Export'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486269231292444337.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-workspace'
,p_list_text_01=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\306F\306A\304F\30E6\30FC\30B6\30FC\30FB\30B0\30EB\30FC\30D7\3001\30E6\30FC\30B6\30FC\3001\30C1\30FC\30E0\958B\767A\30C7\30FC\30BF\3092\542B\3080\30EF\30FC\30AF\30B9\30DA\30FC\30B9\3092\30A8\30AF\30B9\30DD\30FC\30C8\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486268818479440607.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4900:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-app-database'
,p_list_text_01=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3001\500B\3005\306E\30DA\30FC\30B8\304A\3088\3073\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8\3092\30A8\30AF\30B9\30DD\30FC\30C8\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486269021250441433.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Web\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:441:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-app-websheet'
,p_list_text_01=>unistr('Web\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304A\3088\3073\95A2\9023\4ED8\3051\3089\308C\305F\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9(\30AA\30D7\30B7\30E7\30F3)\3092\30A8\30AF\30B9\30DD\30FC\30C8\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486271016233477824.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30C6\30FC\30DE')
,p_list_item_link_target=>'f?p=&APP_ID.:224:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-workspace-themes'
,p_list_text_01=>unistr('\7279\5B9A\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\30C6\30FC\30DE\3092\30A8\30AF\30B9\30DD\30FC\30C8\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486271223505479946.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4460:&SESSION.::&DEBUG.:4460:::'
,p_list_item_icon=>'icon-sc-plugin'
,p_list_text_01=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\4F7F\7528\3059\308B\30D7\30E9\30B0\30A4\30F3\3092\30A8\30AF\30B9\30DD\30FC\30C8\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486271911862486037.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\30C7\30D5\30A9\30EB\30C8\5024')
,p_list_item_link_target=>'f?p=&APP_ID.:479:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-ui-defaults'
,p_list_text_01=>unistr('\8868\307E\305F\306F\5C5E\6027\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\30C7\30D5\30A9\30EB\30C8\5024\304B\3089\30C7\30D5\30A9\30EB\30C8\306E\30EC\30A4\30A2\30A6\30C8\30FB\30D7\30ED\30D1\30C6\30A3\3092\30A8\30AF\30B9\30DD\30FC\30C8\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486272411647495352.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\30C1\30FC\30E0\958B\767A\306E\30D5\30A3\30FC\30C9\30D0\30C3\30AF')
,p_list_item_link_target=>'f?p=&APP_ID.:689:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-page-feedback'
,p_list_text_01=>unistr('\3053\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E6\30FC\30B6\30FC\304C\6307\5B9A\3057\305F\30D5\30A3\30FC\30C9\30D0\30C3\30AF\3092\30A8\30AF\30B9\30DD\30FC\30C8\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/export_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(486307715596288607.4009)
,p_name=>'export tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486307910526288621.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8\30FB\30EA\30DD\30B8\30C8\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.:'
,p_list_item_current_for_pages=>'73'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486308216101288623.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A4\30F3\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.:'
,p_list_item_current_for_pages=>'460'
);
end;
/
prompt --application/shared_components/navigation/lists/ui_def_export_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(486427731138207743.4009)
,p_name=>'ui def export tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486428118802213684.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8868\30C7\30A3\30AF\30B7\30E7\30CA\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:479:&SESSION.::&DEBUG.:479:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'479'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486428330923217163.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:541:&SESSION.::&DEBUG.:541:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'541'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(488490120498750288.4009)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(488490330263750290.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C9\30AD\30E5\30E1\30F3\30C8')
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2105950689804969205.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C7\30A3\30B9\30AB\30C3\30B7\30E7\30F3\30FB\30D5\30A9\30FC\30E9\30E0')
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2185440048625469825.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Oracle Technology Network'
,p_list_item_link_target=>'http://apex.oracle.com/otn'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1493545637548007510.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30C7\30B6\30A4\30CA\306E\30B9\30BF\30FC\30C8\30FB\30AC\30A4\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':APP_ID = 4000 and :APP_PAGE_ID = 4500'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(488495081334766183.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30B7\30E7\30FC\30C8\30AB\30C3\30C8')
,p_list_item_link_target=>'#'
,p_list_text_01=>'keyboardShortcuts'
,p_list_text_03=>'true'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(488616497367046354.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(488492468953750295.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\60C5\5831')
,p_list_item_link_target=>'f?p=4350:9:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/application_utilities_other
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(492631804585583697.4009)
,p_name=>'application.utilities.other'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492632127095590176.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30AF\30ED\30B9\30FB\30DA\30FC\30B8\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:553:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404527353730174909.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B0\30EB\30FC\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:520:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492632330558591213.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:853:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492632500560591999.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30DC\30BF\30F3\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:852:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492632703677592889.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30A2\30A4\30C6\30E0\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:854:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492632906448593646.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\8A08\7B97\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:847:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(821538007832540402.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\691C\8A3C\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:851:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492633108872594367.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30D7\30ED\30BB\30B9\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:482:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492633311642595224.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:699:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492633614413596002.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\30D6\30E9\30F3\30C1\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:881:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_utilities_cross_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(492636810051679904.4009)
,p_name=>'page.utilities.cross.page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492638225897703413.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30DA\30FC\30B8\306E\30B0\30EA\30C3\30C9\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:243:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492638629491713849.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\8907\6570\306E\30DA\30FC\30B8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:339:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492638421180711426.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:484:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492639008497717241.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30ED\30C3\30AF')
,p_list_item_link_target=>'f?p=&APP_ID.:291:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/advisor_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(504056409460898231.4009)
,p_name=>'Advisor Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(504056630453898233.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D7\30EA\30D5\30A1\30EC\30F3\30B9\3068\3057\3066\4FDD\5B58')
,p_list_item_link_target=>'javascript:apex.submit(''SAVE_PREF'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_workspace_objects
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(525226966024198272.4009)
,p_name=>'shared.components.workspace_objects'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(525227999285198277.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\9759\7684\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30D5\30A1\30A4\30EB')
,p_list_item_link_target=>'f?p=&APP_ID.:312:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(525227596268198277.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8CC7\683C\8A3C\660E')
,p_list_item_link_target=>'f?p=&APP_ID.:1620:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(525227186638198275.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('REST\5BFE\5FDCSQL')
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(533134053205118467.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30EA\30E2\30FC\30C8\30FB\30B5\30FC\30D0\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:1931:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_remote_servers
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(533145899605135270.4009)
,p_name=>'shared.components.remote_servers'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(533146052588135270.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30EA\30E2\30FC\30C8\30FB\30B5\30FC\30D0\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:1931:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(533146454181135274.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4F7F\7528\72B6\6CC1')
,p_list_item_link_target=>'f?p=&APP_ID.:1933:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(533187009031297607.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:1934:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/home_page_get_started_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(583541659513985598.4009)
,p_name=>'Home Page Get Started List'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(583609906498114141.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\65B0\898F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:56:&SESSION.::&DEBUG.:56:::'
,p_list_item_icon=>'icon-check-circle'
,p_list_text_01=>unistr('Application Express\3067\6700\521D\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\69CB\7BC9\3092\958B\59CB\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(583541885189985600.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\751F\7523\6027\307E\305F\306F\30B5\30F3\30D7\30EB\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A4\30F3\30B9\30C8\30FC\30EB')
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_item_icon=>'icon-util-install'
,p_list_text_01=>unistr('30\3092\8D85\3048\308B\30B5\30F3\30D7\30EB\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304A\3088\3073\751F\7523\6027\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\9078\629E\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/data_load_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(675812107017852883.4009)
,p_name=>'DATA_LOAD_TASKS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(675812305879852884.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30FB\30ED\30FC\30C9\30FB\30DA\30FC\30B8\306E\518D\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:1704:&SESSION.::&DEBUG.::F4000_P1700_NAME,P1700_EXISTS:&P1801_NAME.,yes:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_components
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(694733590452503217.4009)
,p_name=>'shared.components.components'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694734693779503223.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'LOV'
,p_list_item_link_target=>'f?p=&APP_ID.:4110:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694735222077503223.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4400:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694735518639503226.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\8A2D\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:4445:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697104363364517738.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30C4\30EA\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from   WWV_FLOW_TREES t',
'where  flow_id = :fb_flow_id ',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694734925778503223.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30B7\30E7\30FC\30C8\30AB\30C3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:4047:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(680965773582442489.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:4860:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_application_logic
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(694736922570524377.4009)
,p_name=>'shared.components.application_logic'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694739304257531368.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5B9A\7FA9\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:4001:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694737191989524378.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:4100:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694737422504524378.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:4207:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694737701535524378.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A08\7B97')
,p_list_item_link_target=>'f?p=&APP_ID.:4101:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(659490721011613496.4009)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:4850:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(154811378368453381.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:4910:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_references
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(694855238818571795.4009)
,p_name=>'shared.components.references'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694857216757571796.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30C7\30FC\30BF\30FB\30ED\30FC\30C9\5B9A\7FA9')
,p_list_item_link_target=>'f?p=&APP_ID.:1800:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(154069177738949720.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('REST\5BFE\5FDCSQL')
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_list_text_03=>'has-arrow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(226162637659581893.4009)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>unistr('Web\30BD\30FC\30B9\30FB\30E2\30B8\30E5\30FC\30EB')
,p_list_item_link_target=>'f?p=&APP_ID.:1901:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(694856635326571796.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30EC\30AC\30B7\30FCWeb\30B5\30FC\30D3\30B9\53C2\7167')
,p_list_item_link_target=>'f?p=&APP_ID.:170:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/cross_application_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(702923103587108064.4009)
,p_name=>'Cross Application Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702928892130158098.4009)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\3059\3079\3066\306E\30EC\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:9009:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'182'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702923320676108064.4009)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:9010:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-application-attributes'
,p_list_text_01=>unistr('\5404\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\30FB\30AB\30A6\30F3\30C8\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9010'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702923966900108065.4009)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\304A\3088\3073\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30BF\30B9')
,p_list_item_link_target=>'f?p=&APP_ID.:103:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-app-status'
,p_list_text_01=>unistr('\5404\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30B9\30C6\30FC\30BF\30B9\3092\78BA\8A8D\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'103'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702924515837108067.4009)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_list_item_link_target=>'f?p=&APP_ID.:9012:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-build-options'
,p_list_text_01=>unistr('\3059\3079\3066\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9012'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702923668978108065.4009)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\958B\767A\8005\306E\30B3\30E1\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:380:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-comments'
,p_list_text_01=>unistr('\3059\3079\3066\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\306E\30B3\30E1\30F3\30C8\3092\78BA\8A8D\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'380'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702924262274108066.4009)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\30AB\30EC\30F3\30C0')
,p_list_item_link_target=>'f?p=&APP_ID.:665:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-comments-calendar'
,p_list_text_01=>unistr('\3059\3079\3066\306E\30B3\30E1\30F3\30C8\304C\3044\3064\4F5C\6210\3055\308C\305F\304B\3092\8868\793A\3057\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'665'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702925980864149602.4009)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\6BD4\8F03')
,p_list_item_link_target=>'f?p=&APP_ID.:1300:&SESSION.:NORUN:&DEBUG.::::'
,p_list_text_01=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\540D\306E\5DEE\5206\3092\554F\3044\5408\305B\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_for_pages=>'1300'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702926244508149602.4009)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\6BD4\8F03')
,p_list_item_link_target=>'f?p=&APP_ID.:1301:&SESSION.:NORUN:&DEBUG.::::'
,p_list_text_01=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\30FB\30AB\30A6\30F3\30C8\306E\5DEE\5206\3092\554F\3044\5408\305B\307E\3059\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702926528050149602.4009)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>unistr('\30BB\30AD\30E5\30EA\30C6\30A3\30FB\30D7\30ED\30D5\30A1\30A4\30EB')
,p_list_item_link_target=>'f?p=&APP_ID.:9014:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'9014'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702926833196149603.4009)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:9015:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'9015'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702927168153149603.4009)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>unistr('\30D1\30B9\30EF\30FC\30C9\30FB\30A2\30A4\30C6\30E0')
,p_list_item_link_target=>'f?p=&APP_ID.:7777:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'7777'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702927429794149604.4009)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\30B5\30DE\30EA\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:737:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/developer_comments_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(784788000174894142.4009)
,p_name=>'developer.comments.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(784788282093894144.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\958B\767A\8005\306E\30B3\30E1\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:606:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'f?p=&APP_ID.:606:&SESSION.::&DEBUG.::::'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(784788561594894145.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\958B\767A\8005\30B3\30E1\30F3\30C8\306E\30AB\30EC\30F3\30C0')
,p_list_item_link_target=>'f?p=&APP_ID.:594:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'f?p=&APP_ID.:594:&SESSION.::&DEBUG.::::'
);
end;
/
prompt --application/shared_components/navigation/lists/developer_comments_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(786331487669013778.4009)
,p_name=>'developer.comments.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(786331600475013783.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:1237:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/app_builder_homepage_image_nav
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(787106333147859999.4009)
,p_name=>'App Builder Homepage - Image Nav'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(787106515252860000.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:56:&SESSION.::&DEBUG.:56,103,104,106,130,131,35,227,3020,3000,3001:::'
,p_list_item_icon=>'app-builder-create-app'
,p_security_scheme=>wwv_flow_api.id(12472323342703137)
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(787106820469860001.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30A4\30F3\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_list_item_icon=>'app-builder-import-app'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(787107719682860001.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30C0\30C3\30B7\30E5\30DC\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:160:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-dashboards'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(787107428027860001.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:182:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex-utilities'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_page_plugin
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(808644729415608533.4009)
,p_name=>'create_page_plugin'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(808899406699687141.4009)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\30BF\30A4\30D7')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4461'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(808644907636608535.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4462'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1523941050764866656.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30BF\30D6')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(808645227449608539.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P259_USER_INTERFACE_ID);'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(808645506170608540.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30BD\30FC\30B9')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P4462_REGION_TYPE is not null and (',
''':''||',
'wwv_flow_plugin_dev.get_standard_attributes (',
'    p_application_id => :FB_FLOW_ID,',
'    p_plugin_type    => ''REGION TYPE'',',
'    p_plugin_name    => :P4462_REGION_TYPE ) ||'':'' like ''%:SOURCE%:'')'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4464'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(808845305052667724.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\8A2D\5B9A')
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_plugins p,',
'       wwv_flow_plugin_attributes a',
' where p.flow_id         = case',
'                             when substr(:P4462_REGION_TYPE, 1, 7) = ''NATIVE_'' then 4411',
'                             else to_number(:FB_FLOW_ID)',
'                           end',
'   and p.plugin_type     = ''REGION TYPE''',
'   and p.name            = substr(:P4462_REGION_TYPE, 8) /* remove NATIVE_ */',
'   and a.plugin_id       = p.id',
'   and a.attribute_scope = ''COMPONENT''',
'   and a.show_in_wizard  = ''Y'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4465'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(936810670133035025.4009)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\4F5C\6210/\7DE8\96C6')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':P4462_REGION_TYPE = ''NATIVE_CSS_CALENDAR'' and :P4464_SOURCE_TYPE = ''TABLE'' and ( :P4465_CSS_CAL_EDIT_MOB = ''Y'' or (:P4465_CSS_CAL_NEW_PAGE = ''Y'' and :P4465_CSS_CAL_EDIT_PAGE = ''Y''))'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'234,274,53'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1858877314670538244.4009)
,p_list_item_display_sequence=>46
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\4F5C\6210')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':P4462_REGION_TYPE = ''NATIVE_CSS_CALENDAR'' and :P4464_SOURCE_TYPE = ''TABLE'' and :P4465_CSS_CAL_NEW_PAGE = ''Y'' and :P4465_CSS_CAL_EDIT_PAGE = ''N'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'234,274,53'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1858877642851542014.4009)
,p_list_item_display_sequence=>47
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\7DE8\96C6')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':P4462_REGION_TYPE = ''NATIVE_CSS_CALENDAR'' and :P4464_SOURCE_TYPE = ''TABLE'' and :P4465_CSS_CAL_NEW_PAGE = ''N'' and :P4465_CSS_CAL_EDIT_PAGE = ''Y'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'234,274,53'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1899432406275505294.4009)
,p_list_item_display_sequence=>48
,p_list_item_link_text=>unistr('\30C9\30E9\30C3\30B0\30FB\30A2\30F3\30C9\30FB\30C9\30ED\30C3\30D7')
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P4462_REGION_TYPE = ''NATIVE_CSS_CALENDAR'' and :P4464_SOURCE_TYPE = ''TABLE'' and :P4465_CSS_CAL_NEW_PAGE = ''N'' and :P4465_CSS_CAL_EDIT_PAGE = ''N'' and :P4465_CSS_CAL_DRAG_CODE = ''Y''',
''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'274'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(808645801337608540.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4466'
);
end;
/
prompt --application/shared_components/navigation/lists/p4150_create_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(929084475203099422.4009)
,p_name=>'P4150 Create Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929089127747099428.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:259:&SESSION.::&DEBUG.:181,259,380,311:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929090338243099428.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\3068\3057\3066\306E\30DA\30FC\30B8')
,p_list_item_link_target=>'f?p=&APP_ID.:618:&SESSION.::&DEBUG.:618,301,302,305,308,309,315:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_steps p,',
'       wwv_flow_user_interfaces ui',
' where p.flow_id = :FB_FLOW_ID',
'   and p.id      = :FB_FLOW_PAGE_ID',
'   and ui.id     = p.user_interface_id',
'   and ( ui.global_page_id  <> :FB_FLOW_PAGE_ID',
'       or ui.global_page_id is null',
'       )'))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557540475589995586.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929089764748099428.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:323:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929090008079099428.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:364:&SESSION.::&DEBUG.:4051:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557581203335310047.4009)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B0\30EB\30FC\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:521:&SESSION.::&DEBUG.:521:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557568307014002843.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929091277780099428.4009)
,p_list_item_display_sequence=>75
,p_list_item_link_text=>unistr('\958B\767A\8005\306E\30B3\30E1\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:1234:&SESSION.::&DEBUG.:1234:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557568545855005201.4009)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\30C1\30FC\30E0\958B\767A')
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557569523727025262.4009)
,p_list_item_display_sequence=>810
,p_list_item_link_text=>unistr('\6A5F\80FD')
,p_list_item_link_target=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.:143:P143_APPLICATION_ID,P143_PAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(1557568545855005201.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929090633419099428.4009)
,p_list_item_display_sequence=>820
,p_list_item_link_text=>unistr('\30D0\30B0')
,p_list_item_link_target=>'f?p=&APP_ID.:261:&SESSION.:SET_CURRENT_PAGE:&DEBUG.:RP,261:P261_FEEDBACK_TYPE:BUG:'
,p_parent_list_item_id=>wwv_flow_api.id(1557568545855005201.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929090998215099428.4009)
,p_list_item_display_sequence=>830
,p_list_item_link_text=>'To Do'
,p_list_item_link_target=>'f?p=&APP_ID.:261:&SESSION.:SET_CURRENT_PAGE:&DEBUG.:261:P261_FEEDBACK_TYPE:TODO:'
,p_parent_list_item_id=>wwv_flow_api.id(1557568545855005201.4009)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/p4150_utilities_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(929101979559120187.4009)
,p_name=>'P4150 Utilities Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929104587683120192.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:21:::'
,p_security_scheme=>wwv_flow_api.id(34674432490821717)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557580651948284073.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929103390587120187.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30A2\30C9\30D0\30A4\30B6')
,p_list_item_link_target=>'javascript:apex.navigation.popup({ url: ''f?p=&APP_ID.:8101:&SESSION.::&DEBUG.:8101:P8101_PAGE_ID:&FB_FLOW_PAGE_ID!JS.'', width: 1000, height: 800 }); void(0);'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929103639568120187.4009)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\518D\9806\5E8F\4ED8\3051')
,p_list_item_link_target=>'f?p=&APP_ID.:531:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(34674432490821717)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929103986835120192.4009)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\30ED\30C3\30AF')
,p_list_item_link_target=>'f?p=&APP_ID.:444:&SESSION.::&DEBUG.:444:FB_FLOW_ID,P444_LOCK_PAGES:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.:'
,p_list_item_disp_cond_type=>'NOT_EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_lock_page',
' where flow_id   = to_number(:FB_FLOW_ID)',
'   and object_id = to_number(:FB_FLOW_PAGE_ID)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929104269656120192.4009)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\30ED\30C3\30AF\89E3\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:4150:&SESSION.:BRANCH_TO_PAGE_ACCEPT|UNLOCK_PAGE:&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_lock_page',
' where flow_id   = to_number(:FB_FLOW_ID)',
'   and object_id = to_number(:FB_FLOW_PAGE_ID)',
'   and locked_by = :APP_USER'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557576189080170385.4009)
,p_list_item_display_sequence=>87
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929110537546120195.4009)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30A4\30D9\30F3\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:RP:P23_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929105498064120193.4009)
,p_list_item_display_sequence=>95
,p_list_item_link_text=>unistr('\30AD\30E3\30C3\30B7\30E5')
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_page_dev.is_global_page(:FB_FLOW_ID, :FB_FLOW_PAGE_ID) = false'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929105792287120193.4009)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA')
,p_list_item_link_target=>'f?p=&APP_ID.:912:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929104854155120193.4009)
,p_list_item_display_sequence=>105
,p_list_item_link_text=>unistr('\5C65\6B74')
,p_list_item_link_target=>'f?p=&APP_ID.:201:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'201'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929105109482120193.4009)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:164:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'164'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557579022095226335.4009)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929109398384120194.4009)
,p_list_item_display_sequence=>180
,p_list_item_link_text=>unistr('\30AF\30ED\30B9\30FB\30DA\30FC\30B8\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:553:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557576410500175525.4009)
,p_list_item_display_sequence=>190
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
,p_list_item_link_target=>'f?p=&APP_ID.:674:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929111191131120197.4009)
,p_list_item_display_sequence=>195
,p_list_item_link_text=>unistr('\30DA\30FC\30B8\30FB\30B0\30EB\30FC\30D7')
,p_list_item_link_target=>'f?p=&APP_ID.:520:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1564218351572091595.4009)
,p_list_item_display_sequence=>197
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1557576628542178324.4009)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:89:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/delete_theme
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1029750209782685847.4009)
,p_name=>'delete.theme'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1029750412409686103.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30FC\30DE\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:221:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1029750729764686109.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:229:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/replace_templates_from_different_application
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1127562677974975992.4009)
,p_name=>'Replace Templates From Different Application'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1127562895657976062.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\306E\30B3\30D4\30FC\5143')
,p_list_item_link_target=>'f?p=&APP_ID.:220:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1127563065821976070.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\69CB\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:222:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/new_comments
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1284942185735713564.4009)
,p_name=>'new comments'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1284942380291713565.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\4F5C\6210')
,p_list_item_link_target=>'f?p=&APP_ID.:261:&SESSION.::&DEBUG.:261:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'261'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1234'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1284942644091713566.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\8868\793A')
,p_list_item_link_target=>'f?p=&APP_ID.:1235:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1235'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1284942921905713567.4009)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\7DE8\96C6')
,p_list_item_link_target=>'f?p=&APP_ID.:1236:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1236'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1236'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1284943266884713568.4009)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30B3\30E1\30F3\30C8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:1237:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from WWV_FLOW_APP_COMMENTS',
'where flow_id = :fb_flow_id',
'and security_group_id = :flow_security_group_id'))
,p_security_scheme=>wwv_flow_api.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1237,1238'
);
end;
/
prompt --application/shared_components/navigation/lists/plugin_create
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1434105688733324411.4009)
,p_name=>'plugin.create'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1434105853379324421.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30E1\30BD\30C3\30C9')
,p_list_item_link_target=>'f?p=&APP_ID.:4402:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1435745785714405537.4009)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\30B3\30D4\30FC\5143')
,p_list_item_link_target=>'f?p=&APP_ID.:4404:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P4402_ACTION'
,p_list_item_disp_condition2=>'COPY'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1434106176547324425.4009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B3\30D4\30FC')
,p_list_item_link_target=>'f?p=&APP_ID.:4406:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/template_utilization_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1598999842830947024.4009)
,p_name=>'Template Utilization Tasks '
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1599000030969947024.4009)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\672A\4F7F\7528\306E\30C6\30F3\30D7\30EC\30FC\30C8\306E\524A\9664')
,p_list_item_link_target=>'f?p=&APP_ID.:46:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(233976658328238.4009)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(970498439392559.4009)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14848431076940926.4009)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(92010790354572457.4009)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(174677809582024970.4009)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.SPLITTER'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072046903712054.4009)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831722437189993876.4009)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917679704307940123.4009)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2010954470365119059.4009)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.FLOTLINECHART2'
,p_attribute_01=>'3'
,p_attribute_02=>'1.333'
);
end;
/
prompt --application/shared_components/security/authorizations/user_may_edit_current_application
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(317822338466.4009)
,p_name=>'User May Edit Current Application'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_security.user_is_internal then',
'   return true;',
'elsif wwv_flow_security.user_can_develop_flow(p_flow_id=>:FB_FLOW_ID) then',
'   return true;',
'else',
'   return false;',
'end if;'))
,p_error_message=>unistr('\30E6\30FC\30B6\30FC&USER.\306F\3001\8A72\5F53\3059\308B\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\7DE8\96C6\3059\308B\6A29\9650\304C\3042\308A\307E\305B\3093\3002')
,p_reference_id=>786944233424207200.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(10593027526205581.4009)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>unistr('\30C0\30C3\30B7\30E5\30DC\30FC\30C9\3068\300C\30A2\30AF\30C6\30A3\30D3\30C6\30A3\306E\30E2\30CB\30BF\30FC\300D\3078\306E\30A2\30AF\30BB\30B9\306F\8A31\53EF\3055\308C\3066\3044\307E\305B\3093\3002')
,p_reference_id=>786936829326142579.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_create
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12472323342703137.4009)
,p_name=>'Flow: CREATE'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'CREATE'
,p_error_message=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210\3084\524A\9664\306F\8A31\53EF\3055\308C\3066\3044\307E\305B\3093\3002')
,p_reference_id=>786942708067207200.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12510423405283164.4009)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\7DE8\96C6\306F\8A31\53EF\3055\308C\3066\3044\307E\305B\3093')
,p_reference_id=>12480509677812756.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12511519296310366.4009)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\7BA1\7406\306F\8A31\53EF\3055\308C\3066\3044\307E\305B\3093')
,p_reference_id=>12511219858301010.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/developer_may_edit_page
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(34674432490821717.4009)
,p_name=>'Developer may edit page'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_steps s',
' where flow_id = to_number(:FB_FLOW_ID)',
'   and id      = to_number(:FB_FLOW_PAGE_ID)',
'   and security_group_id = to_number(:WORKSPACE_ID)',
'   and not exists (',
'         select 1',
'           from wwv_flow_lock_page l',
'          where l.flow_id    = s.flow_id',
'            and l.object_id  = s.id',
'            and l.locked_by != :APP_USER )'))
,p_error_message=>unistr('\30DA\30FC\30B8\3092\958B\767A\8005\306F\7DE8\96C6\3067\304D\306A\3044\53EF\80FD\6027\304C\3042\308A\307E\3059')
,p_reference_id=>786942462038207200.4009
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/user_auth_to_access_schema
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(74725624313588476.4009)
,p_name=>'User_auth_to_access_schema'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from   wwv_flow_company_schemas c,',
'       wwv_flow_fnd_user u',
'where  c.security_group_id = :flow_security_group_id and',
'       u.security_group_id = :flow_security_group_id and',
'       u.user_name = :flow_user and',
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or',
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0) and',
'        c.schema = :P391_SCHEMA'))
,p_error_message=>unistr('\9078\629E\3057\305F\30B9\30AD\30FC\30DE\3078\306E\30A2\30AF\30BB\30B9\6A29\304C\3042\308A\307E\305B\3093\3002')
,p_reference_id=>786944588379207201.4009
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/user_has_edit_priv
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(74845831538733642.4009)
,p_name=>'USER_HAS_EDIT_PRIV'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_security.user_can_develop_any_flow;'
,p_error_message=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\7DE8\96C6\3059\308B\6A29\9650\304C\3042\308A\307E\305B\3093\3002')
,p_reference_id=>786943988629207200.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/is_real_application_security_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(125788121598195155.4009)
,p_name=>'Is Real Application Security enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_platform.get_preference(''ALLOW_RAS'')=''Y'';'
,p_error_message=>unistr('Real Application Security\306F\6709\52B9\306B\306A\3063\3066\3044\307E\305B\3093')
,p_reference_id=>786943379004207200.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178938910382761975.4009)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\8A66\884C\3057\305F\64CD\4F5C\306B\5BFE\3059\308B\6A29\9650\304C\3042\308A\307E\305B\3093')
,p_reference_id=>786516029127697713.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178939331963761975.4009)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('SQL\30EF\30FC\30AF\30B7\30E7\30C3\30D7\3092\4F7F\7528\3059\308B\6A29\9650\304C\3042\308A\307E\305B\3093\3002')
,p_reference_id=>786516265251697717.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178939812163761988.4009)
,p_name=>'APEX 5.0 Team Development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\3053\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\3067\306F\3001\30C1\30FC\30E0\958B\767A\306F\4F7F\7528\3067\304D\307E\305B\3093')
,p_reference_id=>786516861027697723.4009
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178940313582761989.4009)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\8A66\884C\3057\305F\64CD\4F5C\306B\5BFE\3059\308B\6A29\9650\304C\3042\308A\307E\305B\3093')
,p_reference_id=>786517166823697723.4009
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(331660423436603298.4009)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>unistr('\30D3\30EB\30C0\30FCSSO\304C\6709\52B9\306B\306A\3063\3066\3044\307E\305B\3093')
,p_reference_id=>6738410669854771.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/attribute_dictionary_columns_defined
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(499915500493760557.4009)
,p_name=>'Attribute Dictionary Columns Defined'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_hnt_column_dict',
' where security_group_id = :FLOW_SECURITY_GROUP_ID'))
,p_error_message=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\306B\5C5E\6027\304C\5B9A\7FA9\3055\308C\3066\3044\307E\305B\3093\3002')
,p_reference_id=>786942219366207200.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/team_dev_file_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(692489888034486589.4009)
,p_name=>'Team Dev File Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_team_file.team_dev_file_enabled then',
'   return true;',
'else',
'   return false;',
'end if;'))
,p_error_message=>unistr('\3053\306E\30DA\30FC\30B8\3078\306E\30A2\30AF\30BB\30B9\306B\306F\3001\30C1\30FC\30E0\958B\767A\30D5\30A1\30A4\30EB\3092\6709\52B9\306B\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
,p_reference_id=>786943600005207200.4009
,p_caching=>'NOCACHE'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(802892920094782611.4009)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>unistr('\8A66\884C\3057\305F\64CD\4F5C\306B\5BFE\3059\308B\6A29\9650\304C\3042\308A\307E\305B\3093')
,p_reference_id=>786519856057734816.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/developer_may_edit_supporting_object_script
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(857903402130335025.4009)
,p_name=>'Developer may edit supporting object script'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_lock.user_can_edit_script (',
'    p_flow_id   => :FB_FLOW_ID,',
'    p_script_id => :P865_SCRIPT_ID,',
'    p_override  => :P865_MODE = ''NEW'' -- allow viewing if create',
'    );'))
,p_error_message=>unistr('\30B9\30AF\30EA\30D7\30C8\3092\958B\767A\8005\306F\7DE8\96C6\3067\304D\306A\3044\53EF\80FD\6027\304C\3042\308A\307E\3059\3002')
,p_caching=>'NOCACHE'
);
end;
/
prompt --application/shared_components/security/authorizations/service_requests_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(917540220622028585.4009)
,p_name=>'Service Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'' then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>unistr('\8A66\884C\3057\305F\64CD\4F5C\306B\5BFE\3059\308B\6A29\9650\304C\3042\308A\307E\305B\3093\3002')
,p_reference_id=>786932326296107981.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_productivity_and_sample_apps_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(1697324305399287638.4009)
,p_name=>'APEX 5.0 Productivity and Sample Apps Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('\751F\7523\6027\307E\305F\306F\30B5\30F3\30D7\30EB\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\30A4\30F3\30B9\30C8\30FC\30EB\3059\308B\6A29\9650\304C\3042\308A\307E\305B\3093')
,p_reference_id=>786517456817697723.4009
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(1361802214166928.4009)
,p_icon_sequence=>10
,p_icon_subtext=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9&COMPANY.')
,p_icon_target=>'#'
,p_icon_image_alt=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9&COMPANY.')
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(331551200056558688.4009)
,p_icon_sequence=>40
,p_icon_subtext=>unistr('( <span style="text-decoration:underline;">\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\5207\66FF\3048</span> )')
,p_icon_target=>'f?p=4550:20'
,p_icon_image_alt=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\5207\66FF\3048')
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
,p_security_scheme=>wwv_flow_api.id(331660423436603298)
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(39804528545736393.4009)
,p_icon_sequence=>50
,p_icon_subtext=>unistr('( <span style="text-decoration:underline;">\30ED\30B0\30A2\30A6\30C8</span> )')
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>unistr('\30ED\30B0\30A2\30A6\30C8')
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(72335994471686592.4009)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT, SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/pg_5150_detail
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(6184522853212743.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'pg_5150_DETAIL'
,p_process_sql_clob=>'carl_test.show_layout_region (1,1,1);'
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/page_template_preview
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(13746503491403876.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'PAGE_TEMPLATE_PREVIEW'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name into :F4000_P4029_TEMPLATE_NAME from wwv_flow_templates where id = :F4000_P4029_TEMPLATE_ID;',
'wwv_flow_region_layout.show_page_template (',
'   p_page=>v(''FB_FLOW_PAGE_ID''),',
'   p_flow=>v(''FB_FLOW_ID''),',
'   p_template=>v(''F4000_P4029_TEMPLATE_NAME''),',
'   p_template_id=>v(''F4000_P4029_TEMPLATE_ID''));'))
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/returnnothing
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(26098116757095708.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'returnNothing'
,p_process_sql_clob=>'null;'
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
,p_process_comment=>'this is useful for setting item values where no return value is needed.'
);
end;
/
prompt --application/shared_components/logic/application_processes/p872_add_parameter
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(33555511200784610.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'P872_ADD_PARAMETER'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_collection.update_members(',
'  p_collection_name => wwv_flow.g_x01,',
'  p_seq => wwv_flow.g_f01,',
'  p_c001 => wwv_flow.g_f02,',
'  p_c002 => wwv_flow.g_f03,',
'  p_c003 => wwv_flow.g_f04,',
'  p_c004 => wwv_flow.g_f05,',
'  p_c005 => wwv_flow.g_f06 );',
'wwv_flow_collection.add_member(p_collection_name =>wwv_flow.g_x01, p_c004 =>''N'');'))
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/p875_test_rest
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(33809312666721107.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'P875_TEST_REST'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_response clob;',
'    l_url varchar2(4000);',
'    l_method varchar2(4000);',
'    l_proxy_override varchar2(4000);',
'    l_app_proxy varchar2(4000);',
'    l_wallet         wwv_flow_security.t_wallet;',
'    l_body           clob default empty_clob();',
'    l_items          clob;',
'    l_buffer         varchar2(32767);',
'    l_amount         number;',
'    l_offset         number;',
'    l_username       varchar2(4000);',
'    l_password       varchar2(4000);',
'begin',
'',
'    l_url := wwv_flow.g_x01;',
'    l_method := wwv_flow.g_x03;',
'    l_proxy_override := wwv_flow.g_x02;',
'    l_username := wwv_flow.g_x04;',
'    l_password := wwv_flow.g_x05;',
'',
'    if length(wwv_flow.g_x06) > 0 then',
'      l_body     := wwv_flow.g_x06;',
'      l_body := sys.utl_url.unescape(l_body);',
'    end if;',
'',
'    l_app_proxy := wwv_flow_web_services.find_proxy(:FB_FLOW_ID);',
'',
'    l_wallet := wwv_flow_security.get_wallet;',
'',
'    l_response := wwv_flow_web_services.make_rest_request(',
'                      p_url             => l_url,',
'                      p_http_method     => l_method,',
'                      p_username        => l_username,',
'                      p_password        => l_password,',
'                      p_proxy_override  => nvl(l_proxy_override,l_app_proxy),',
'                      p_body            => l_body,',
'                      p_parm_name       => wwv_flow.g_f01,',
'                      p_parm_value      => wwv_flow.g_f02,',
'                      p_http_headers    => wwv_flow.g_f03,',
'                      p_http_hdr_values => wwv_flow.g_f04,',
'                      p_wallet_path     => l_wallet.wallet_path,',
'                      p_wallet_pwd      => l_wallet.wallet_pwd);',
'',
'    l_amount := 32000;',
'    l_offset := 1;',
'    begin',
'        loop',
'            sys.dbms_lob.read( l_response, l_amount, l_offset, l_buffer );',
'            sys.htp.p(l_buffer);',
'            l_offset := l_offset + l_amount;',
'            l_amount := 32000;',
'        end loop;',
'    exception',
'        when no_data_found then',
'            null;',
'    end;',
'',
'exception when others then',
'',
'   sys.htp.p(wwv_flow_escape.html(sqlerrm));',
'',
'end;'))
,p_process_error_message=>'#SQLERRM#'
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/p872_remove_parameter
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(33980127084358949.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'P872_REMOVE_PARAMETER'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_collection.update_members(',
'  p_collection_name => wwv_flow.g_x01,',
'  p_seq => wwv_flow.g_f01,',
'  p_c001 => wwv_flow.g_f02,',
'  p_c002 => wwv_flow.g_f03,',
'  p_c003 => wwv_flow.g_f04,',
'  p_c004 => wwv_flow.g_f05,',
'  p_c005 => wwv_flow.g_f06 );',
'if nvl(wwv_flow.g_x03,''x'') != ''update'' then',
'  wwv_flow_collection.delete_member(wwv_flow.g_x01,wwv_flow.g_x02);',
'  wwv_flow_collection.resequence_collection(wwv_flow.g_x01);',
'else',
'  for c1 in (select c003',
'               from wwv_flow_collections',
'              where collection_name = wwv_flow.g_x01',
'                and seq_id = wwv_flow.g_x02 ) loop',
'    wwv_flow_collection.update_member(',
'      p_collection_name => wwv_flow.g_x01, ',
'      p_seq             => wwv_flow.g_x02,',
'      p_c001            => ''marked for delete'',',
'      p_c003            => c1.c003,',
'      p_c004            => ''D'' );',
'  end loop;',
'end if;'))
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/ajax_collect_clob
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(49827831510641638.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'AJAX_COLLECT_CLOB'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_code clob := empty_clob;',
'begin',
'   sys.dbms_lob.createtemporary( l_code, false, sys.dbms_lob.SESSION );',
'   for i in 1..wwv_flow.g_f01.count loop',
'        sys.dbms_lob.writeappend(l_code,length(wwv_flow.g_f01(i)),wwv_flow.g_f01(i));',
'    end loop;',
'apex_collection.create_or_truncate_collection(p_collection_name=>''CLOB_CONTENT'');',
'apex_collection.add_member(p_collection_name=>''CLOB_CONTENT'',p_clob001=>l_code);',
'sys.htp.prn(''SUCCESS'');',
'end;'))
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/parse_report_query
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(59589024396402332.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'PARSE_REPORT_QUERY'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_owner varchar2(4000)  := null;',
'  l_query varchar2(32767) := null;',
'  l_error varchar2(32767) := null;',
'begin',
'',
'  l_owner := wwv_flow_security.flow_owner ( ',
'     p_flow_id           =>:FB_FLOW_ID, ',
'     p_security_group_id =>:FLOW_SECURITY_GROUP_ID',
'  );',
'',
'  for c1 in (',
'    select clob001 ',
'    from wwv_flow_collections ',
'    where collection_name = ''REPORT_QUERY_TEMP''',
'  ) loop',
'    l_query := c1.clob001;',
'    l_error := wwv_flow_f4000_util.is_valid_report_query (',
'      p_plug_source      => l_query,',
'      p_plug_source_type => wwv_flow_region_native.c_sql_report,',
'      p_owner            => l_owner',
'    );',
'  end loop;',
'         ',
'  if l_error is null then',
'    sys.htp.p(''1''||wwv_flow_lang.system_message(''REPORT_QUERIES.VALID_QUERY''));',
'  else',
'    sys.htp.p(''0''||wwv_flow_utilities.striphtml(l_error));',
'  end if;',
'',
'end;'))
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/map_centre_select
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(187756309828455248.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'MAP_CENTRE_SELECT'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN',
'   sys.htp.init;',
'   OWA_UTIL.mime_header (''text/xml'', FALSE);',
'   HTP.p (''Cache-Control: no-cache'');',
'   HTP.p (''Pragma: no-cache'');',
'   OWA_UTIL.http_header_close;',
'   HTP.prn (''<select>'');',
'   HTP.prn (''<option value="'' || 1 || ''">'' || ''- Map Regions -''',
'            || ''</option>''',
'           );',
'',
'   FOR c IN (select region_id||'' - ''||region_name d,region_id',
'                      from wwv_flow_flash_map_regions',
'                      where file_id = :CASCADING_SELECTLIST_ITEM_1)',
'   LOOP',
'      HTP.prn (''<option value="'' || wwv_flow_escape.html(c.region_id) || ''">'' || wwv_flow_escape.html(c.region_name) || ''</option>'');',
'   END LOOP;',
'',
'   HTP.prn (''</select>'');',
'END;'))
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(233703836072822139.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'    p_app_id           => wwv_flow.g_x01,',
'    p_get_apps_list    => wwv_flow.g_x02,',
'    p_is_page_designer => true);'))
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_processes/developertoolbar
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(241203394876147425.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'developerToolbar'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    wwv_flow_developer_toolbar.ajax;',
'    commit;',
'end;'))
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_processes/get_plugin_sql_examples
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(468201615965604310.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'get_plugin_sql_examples'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    sys.htp.p (',
'        wwv_flow_plugin_dev.get_sql_examples (',
'            p_application_id => :FB_FLOW_ID,',
'            p_plugin_type    => wwv_flow.g_x01,',
'            p_plugin_name    => wwv_flow.g_x02 ) );',
'end;'))
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/theme_roller
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(1199152637279464946.4009)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'theme_roller'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    wwv_flow_theme_dev.theme_roller_ajax;',
'    commit;',
'end;'))
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/set_flow_page
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(72694123644888753.4009)
,p_process_sequence=>1
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set flow page'
,p_process_sql_clob=>'wwv_flow_f4000_util.set_flow_page;'
,p_process_error_message=>unistr('\30A8\30E9\30FC')
,p_process_when=>'1000,460,514,516,527,273,2100,2101,2102,2103,2104,2105,2106,2107,2108,2109,2111,2115,1500,163,56,176,189,433,447,448,451,454,458,494,495,496,3001,3002,3005,3020,49,57,8000,8101'
,p_process_when_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_security_scheme=>wwv_flow_api.id(12510423405283164)
,p_process_comment=>'Used to set env when two browsers are working on different apps in the same session.  Prevents a wizard from creating a component in the wrong application.'
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(6191718445268266.4009)
,p_name=>'AJAX_TEMPORARY_ITEM'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(187760430466726137.4009)
,p_name=>'CASCADING_SELECTLIST_ITEM_1'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(323366420862.4009)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
,p_item_comment=>'Prints workspace name referenced in page templates'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(137222915098326064.4009)
,p_name=>'F4000_CHECK'
,p_protection_level=>'N'
,p_item_comment=>'Used to display system message "Check".'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2461529447025552654.4009)
,p_name=>'F4000_COPY_TO_THEME'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(49554522682292670.4009)
,p_name=>'F4000_CUR_STD_TAB'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2573484773802618001.4009)
,p_name=>'F4000_FIND_LABEL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(201664305800188161.4009)
,p_name=>'F4000_LAST_PORTAL_VIEW'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(46180307972.4009)
,p_name=>'F4000_LAST_VIEW'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(174779207867417973.4009)
,p_name=>'F4000_P35_DEMO_FLOWS'
,p_protection_level=>'N'
,p_item_comment=>'an item used for demostrations'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(60363923165055254.4009)
,p_name=>'F4000_REGION_SELECTED'
,p_item_comment=>'Used to dynamically compute button postions for that region'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(137215819075289336.4009)
,p_name=>'F4000_RUN'
,p_protection_level=>'N'
,p_item_comment=>'Item used to display system message "Run".'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(148405327096585472.4009)
,p_name=>'F4000_RUN_EDIT_PAGE'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(40006855470898.4009)
,p_name=>'FB_FLOW_ID'
,p_data_type=>'NUMBER'
,p_item_comment=>'Identifies the flow.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(40006856470899.4009)
,p_name=>'FB_FLOW_NAME'
,p_item_comment=>'Y'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(40006857470899.4009)
,p_name=>'FB_FLOW_PAGE_ID'
,p_data_type=>'NUMBER'
,p_item_comment=>'Identifies the flow page.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(146658914296443870.4009)
,p_name=>'FB_THEME_ID'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(76847111472614227.4009)
,p_name=>'FP_MAX_ROWS_PER_PAGE'
,p_item_comment=>'obsolete this item when you get a chance'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(76852381884625214.4009)
,p_name=>'FP_PREF_SHOW_INFORMATION'
,p_item_comment=>'obosolete this item when you get a chance'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(61573406162429920.4009)
,p_name=>'FSP_AFTER_LOGIN_URL'
,p_item_comment=>'Used by Custom2 authentication for deep linking support'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(3692062815389.4009)
,p_name=>'G_PARSE_AS_SCHEMA_OVERRIDE'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(22788166245.4009)
,p_name=>'LAST_STEP'
,p_item_comment=>'Y'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(453606206.4009)
,p_name=>'MONITOR_USER'
,p_item_comment=>'Used by monitoring Utility'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(163678415474826275.4009)
,p_name=>'RECENT_PAGES'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(12973032052396511.4009)
,p_name=>'THEME_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(52224418686048921.4009)
,p_name=>'THEME_NEXT_PAGE'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(60734732002851561.4009)
,p_name=>'UI_SCHEMA'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(60735102005852345.4009)
,p_name=>'UI_TABLE'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(114948426092978491.4009)
,p_name=>'UI_TABLE_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(106733613326936844.4009)
,p_name=>'WIZARD_ENTRY_PAGE'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(323368422455.4009)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name;'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\540D\3092\8A08\7B97\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(40006858470900.4009)
,p_computation_sequence=>1
,p_computation_item=>'FB_FLOW_ID'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'SET_ITEM_EQUAL_THIS_PREFERENCE'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'FB_FLOW_ID'
,p_compute_when_type=>'NEVER'
,p_computation_error_message=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30D7\30EA\30D5\30A1\30EC\30F3\30B9\3092\53D6\5F97\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(40006860470902.4009)
,p_computation_sequence=>2
,p_computation_item=>'FB_FLOW_PAGE_ID'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'SET_ITEM_EQUAL_THIS_PREFERENCE'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'FB_FLOW_PAGE_ID'
,p_compute_when=>'FB_FLOW_PAGE_ID'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC\306E\30DA\30FC\30B8ID\306E\30D7\30EA\30D5\30A1\30EC\30F3\30B9\3092\53D6\5F97\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(40006859470901.4009)
,p_computation_sequence=>3
,p_computation_item=>'FB_FLOW_NAME'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'ON_NEW_INSTANCE'
,p_computation=>'wwv_flow_escape.html(v(''FB_FLOW_NAME''))'
,p_computation_error_message=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\3092\5224\5225\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(137218026825301058.4009)
,p_computation_sequence=>10
,p_computation_item=>'F4000_RUN'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_lang.system_message(''DEMO_APPLICATION.RUN'')'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(137224006571333058.4009)
,p_computation_sequence=>10
,p_computation_item=>'F4000_CHECK'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_lang.system_message(''F4500_CHECK'')'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(201669928216192952.4009)
,p_computation_sequence=>10
,p_computation_item=>'F4000_LAST_PORTAL_VIEW'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_processed=>'ON_NEW_INSTANCE'
,p_computation=>'page_definition'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(2573485187619621101.4009)
,p_computation_sequence=>10
,p_computation_item=>'F4000_FIND_LABEL'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_lang.system_message(''WWV_FLOW_UTILITIES.FIND'');'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/4150_create_page_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(5552423159788310.4009)
,p_lov_name=>'4150 CREATE PAGE OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(5552423159788310.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5552716168788316.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7A7A\767D\30DA\30FC\30B8')
,p_lov_return_value=>'PAGE'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4714:&SESSION.:::4714,4716,78,81,82,79,80,83"><img src="#IMAGE_PREFIX#htmldb/builder/blank_page_xl.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5555927446799005.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\3092\542B\3080\30DA\30FC\30B8')
,p_lov_return_value=>'COMPLETE_PAGE'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:259:&SESSION.:::181,259,380,311"><img src="#IMAGE_PREFIX#htmldb/builder/page_with_component_xl.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/4150_page_view_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(157910929450338648.4009)
,p_lov_name=>'4150 PAGE VIEW OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(157910929450338648.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157911100096338649.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5B9A\7FA9')
,p_lov_return_value=>'PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157911305474338650.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30A4\30D9\30F3\30C8')
,p_lov_return_value=>'EVENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157913829927348298.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30AA\30D6\30B8\30A7\30AF\30C8')
,p_lov_return_value=>'OBJECTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157914403393350022.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\5C65\6B74')
,p_lov_return_value=>'HISTORY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(158041017038789237.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(158172814399148020.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30B0\30EB\30FC\30D7')
,p_lov_return_value=>'GROUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(158211008446316671.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\53C2\7167')
,p_lov_return_value=>'RELATED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/4500_ui_def_alignment_l_c_r
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(200094129140149873.4009)
,p_lov_name=>'4500 UI DEF ALIGNMENT L.C.R'
,p_reference_id=>260501806598530292.4009
,p_lov_query=>'.'||wwv_flow_api.id(200094129140149873.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(441093505492065867.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\958B\59CB')
,p_lov_return_value=>'L'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(441093315770065865.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4E2D\592E')
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(441093715747065867.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\7D42\4E86')
,p_lov_return_value=>'R'
);
end;
/
prompt --application/shared_components/user_interface/lovs/4700_page_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(21175516989935412.4009)
,p_lov_name=>'4700 PAGE TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(21175516989935412.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27347459598934566.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'INTERACTIVE'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-IR'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    :P259_CHOOSE_PAGE_TYPE = ''REPORT''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''INTERACTIVE_REPORT'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(246582238858911524.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5BFE\8A71\30B0\30EA\30C3\30C9')
,p_lov_return_value=>'GRID'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-IR'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    :P259_CHOOSE_PAGE_TYPE = ''REPORT''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''INTERACTIVE_REPORT'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2493355178753248.4009)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('\30D5\30A1\30BB\30C3\30C8\691C\7D22')
,p_lov_return_value=>'FACETED_SEARCH'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-FS'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_CHOOSE_PAGE_TYPE = ''REPORT'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21176006373935415.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30AF\30E9\30B7\30C3\30AF\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'CLASSIC'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-SQL-REPORT'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    :P259_CHOOSE_PAGE_TYPE = ''REPORT''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''CLASSIC_REPORT'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(230450390826227467.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30D5\30A9\30FC\30E0\4ED8\304D\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'REPORTANDFORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-table-report'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    :P259_CHOOSE_PAGE_TYPE = ''REPORT''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''INTERACTIVE_REPORT'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(10795014720095875.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\30FB\30D3\30E5\30FC')
,p_lov_return_value=>'LISTVIEW'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-JQM-LIST-VIEW'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    :P259_CHOOSE_PAGE_TYPE = ''REPORT''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''JQM_LIST_VIEW'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(653851210587797943.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\5217\5207\66FF\3048\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'COLUMNTOGGLE'
,p_lov_template=>'#DISPLAY_VALUE#|native-jqm-column-toggle'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P259_CHOOSE_PAGE_TYPE = ''REPORT''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''JQM_COLUMN_TOGGLE'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(653851747288800529.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30EA\30D5\30ED\30FC\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'REFLOW'
,p_lov_template=>'#DISPLAY_VALUE#|native-jqm-reflow'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P259_CHOOSE_PAGE_TYPE = ''REPORT''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''JQM_REFLOW_TABLE'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21176218444935415.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\8868\306E\30D5\30A9\30FC\30E0\4ED8\304D\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'REPORT_WITH_FORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-table-report'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P259_CHOOSE_PAGE_TYPE'
,p_lov_disp_cond2=>'REPORT XX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21187613405000544.4009)
,p_lov_disp_sequence=>95
,p_lov_disp_value=>unistr('\30D5\30A9\30FC\30E0')
,p_lov_return_value=>'FORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-table'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P259_CHOOSE_PAGE_TYPE'
,p_lov_disp_cond2=>'FORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(714137469566757848.4009)
,p_lov_disp_sequence=>96
,p_lov_disp_value=>unistr('\7DE8\96C6\53EF\80FD\5BFE\8A71\30B0\30EA\30C3\30C9')
,p_lov_return_value=>'EDITABLE_GRID'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-IR'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P259_CHOOSE_PAGE_TYPE = ''FORM'' ',
'and ',
'wwv_flow_user_interface_dev.supports_feature ( ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID,',
'    p_name              => ''INTERACTIVE_GRID'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21189232105005988.4009)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\30D5\30A9\30FC\30E0\4ED8\304D\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'REPORTANDFORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-table-report'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    :P259_CHOOSE_PAGE_TYPE = ''FORM''',
'and (  wwv_flow_user_interface_dev.supports_feature ( ',
'           p_user_interface_id => :P259_USER_INTERFACE_ID,',
'           p_name              => ''CLASSIC_REPORT'' )',
'    or wwv_flow_user_interface_dev.supports_feature ( ',
'           p_user_interface_id => :P259_USER_INTERFACE_ID,',
'           p_name              => ''INTERACTIVE_REPORT'' )',
'    )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(236493430582249579.4009)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\30D5\30A9\30FC\30E0\4ED8\304D\30EA\30B9\30C8\30FB\30D3\30E5\30FC')
,p_lov_return_value=>'LISTVIEWFORM'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    :P259_CHOOSE_PAGE_TYPE = ''FORM''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''JQM_LIST_VIEW'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21187920677002697.4009)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>unistr('\30ED\30FC\30AB\30EB\30FB\30D7\30ED\30B7\30FC\30B8\30E3\306E\30D5\30A9\30FC\30E0')
,p_lov_return_value=>'FORMONPROC'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-procedure'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P259_CHOOSE_PAGE_TYPE'
,p_lov_disp_cond2=>'FORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21209407489121901.4009)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>unistr('\7C21\6613\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'EZCALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-CSS-CALENDAR'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(156093025691342628.4009)
,p_lov_disp_sequence=>210
,p_lov_disp_value=>unistr('\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'CSSCALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-CSS-CALENDAR'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P259_CHOOSE_PAGE_TYPE'
,p_lov_disp_cond2=>'CALENDAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21213125974136706.4009)
,p_lov_disp_sequence=>230
,p_lov_disp_value=>unistr('\5358\7D14\306A\30A6\30A3\30B6\30FC\30C9')
,p_lov_return_value=>'SIMPLE_WIZARD'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P259_CHOOSE_PAGE_TYPE'
,p_lov_disp_cond2=>'WIZARD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21219222212163984.4009)
,p_lov_disp_sequence=>240
,p_lov_disp_value=>unistr('\30C4\30EA\30FC')
,p_lov_return_value=>'TREE'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-JSTREE'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    :P259_CHOOSE_PAGE_TYPE = ''TREE''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''JSTREE'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(246500450369268408.4009)
,p_lov_disp_sequence=>250
,p_lov_disp_value=>'Oracle JET'
,p_lov_return_value=>'JET_CHART'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_CHOOSE_PAGE_TYPE = ''CHART'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21189807995008490.4009)
,p_lov_disp_sequence=>260
,p_lov_disp_value=>unistr('\8868\5F62\5F0F\30D5\30A9\30FC\30E0')
,p_lov_return_value=>'TABFORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-tabular'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    :P259_CHOOSE_PAGE_TYPE = ''LEGACY''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''TABULAR_FORM'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21190114574010376.4009)
,p_lov_disp_sequence=>270
,p_lov_disp_value=>unistr('\30EC\30AC\30B7\30FC\30FB\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB')
,p_lov_return_value=>'MDFORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-master-detail'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P259_CHOOSE_PAGE_TYPE = ''LEGACY'' ',
'and ',
'wwv_flow_user_interface_dev.supports_feature ( ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID,',
'    p_name              => ''MASTER_DETAIL'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(246500732334271276.4009)
,p_lov_disp_sequence=>280
,p_lov_disp_value=>unistr('AnyChart\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'FLASH_CHART5'
,p_lov_template=>'#DISPLAY_VALUE#|native-flash-chart5'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P259_CHOOSE_PAGE_TYPE'
,p_lov_disp_cond2=>'LEGACY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21189504185007384.4009)
,p_lov_disp_sequence=>290
,p_lov_disp_value=>unistr('\30B5\30DE\30EA\30FC\30FB\30DA\30FC\30B8')
,p_lov_return_value=>'SUMMARY'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-summary'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P259_CHOOSE_PAGE_TYPE'
,p_lov_disp_cond2=>'LEGACY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(114174512180561978.4009)
,p_lov_disp_sequence=>300
,p_lov_disp_value=>unistr('\30EC\30AC\30B7\30FCWeb\30B5\30FC\30D3\30B9\306E\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'WEBSERVICE'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-report-webservice'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P259_CHOOSE_PAGE_TYPE'
,p_lov_disp_cond2=>'LEGACY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21190519076011733.4009)
,p_lov_disp_sequence=>310
,p_lov_disp_value=>unistr('\30EC\30AC\30B7\30FCWeb\30B5\30FC\30D3\30B9\306E\30D5\30A9\30FC\30E0')
,p_lov_return_value=>'FORMWS'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-report-webservice'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P259_CHOOSE_PAGE_TYPE'
,p_lov_disp_cond2=>'LEGACY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30111210090697363.4009)
,p_lov_disp_sequence=>320
,p_lov_disp_value=>unistr('\30EC\30AC\30B7\30FCWeb\30B5\30FC\30D3\30B9\306E\30EC\30DD\30FC\30C8\3068\30D5\30A9\30FC\30E0')
,p_lov_return_value=>'REPORTANDFORMWS'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-report-webservice'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P259_CHOOSE_PAGE_TYPE'
,p_lov_disp_cond2=>'LEGACY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(203469713384401835.4009)
,p_lov_disp_sequence=>900
,p_lov_disp_value=>unistr('\30EC\30AC\30B7\30FC\30FB\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'CALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-CSS-CALENDAR'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21188626910004453.4009)
,p_lov_disp_sequence=>910
,p_lov_disp_value=>unistr('SQL\554F\5408\305B\306E\30D5\30A9\30FC\30E0')
,p_lov_return_value=>'FORMONSQL'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-sql'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/4791_url_or_page
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6718617245289867.4009)
,p_lov_name=>'4791_URL_OR_PAGE'
,p_lov_query=>'.'||wwv_flow_api.id(6718617245289867.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6718912393289869.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65B0\898F\7DE8\96C6\30DA\30FC\30B8\306E\4F5C\6210')
,p_lov_return_value=>'NEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6719410796297458.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DA\30FC\30B8')
,p_lov_return_value=>'FLOW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6719129689289872.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'URL'
,p_lov_return_value=>'URL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(598109125486803480.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30EA\30F3\30AF\30FB\30BF\30FC\30B2\30C3\30C8\306E\9664\5916')
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/9999_url_or_page
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(191802018719438597.4009)
,p_lov_name=>'9999_URL_OR_PAGE'
,p_lov_query=>'.'||wwv_flow_api.id(191802018719438597.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(191802221865438607.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DA\30FC\30B8')
,p_lov_return_value=>'FLOW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(191802417355438613.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'URL'
,p_lov_return_value=>'URL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(191803319328457621.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'JavaScript'
,p_lov_return_value=>'JAVASCRIPT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/advanced_upgrade_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(499502202331793325.4009)
,p_lov_name=>'ADVANCED_UPGRADE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(499502202331793325.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(499504213089793331.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30C6\30AD\30B9\30C8\30FB\30A2\30A4\30C6\30E0\306E\6570\5024\30D5\30A3\30FC\30EB\30C9\3078\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9')
,p_lov_return_value=>'NUMBER_FIELD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(499502630417793330.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\65E5\4ED8\30D4\30C3\30AB\30FC\306E\65B0\898F\65E5\4ED8\30D4\30C3\30AB\30FC\3078\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9')
,p_lov_return_value=>'DATE_PICKER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(499504425018793331.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\5FC5\9808\306E\5024\30A2\30A4\30C6\30E0\5C5E\6027\3092\300C\306F\3044\300D\306B\5909\66F4')
,p_lov_return_value=>'REQUIRED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/aggregate_by
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(167761011505168202.4009)
,p_lov_name=>'AGGREGATE BY'
,p_lov_query=>'.'||wwv_flow_api.id(167761011505168202.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167761226870168212.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'SUM'
,p_lov_return_value=>'SUM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167761407532168218.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'AVG'
,p_lov_return_value=>'AVG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167761632408168219.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'MIN'
,p_lov_return_value=>'MIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167761817557168219.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'MAX'
,p_lov_return_value=>'MAX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167776619311284077.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'COUNT'
,p_lov_return_value=>'COUNT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/aggregate_function
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(49455515219053317.4009)
,p_lov_name=>'AGGREGATE_FUNCTION'
,p_lov_query=>'.'||wwv_flow_api.id(49455515219053317.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49455814570053330.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5408\8A08')
,p_lov_return_value=>'SUM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49456006581053331.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5E73\5747')
,p_lov_return_value=>'AVG'
);
end;
/
prompt --application/shared_components/user_interface/lovs/aggregate_functions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(101016778607432389.4009)
,p_lov_name=>'AGGREGATE_FUNCTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(101016778607432389.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(101017392766432406.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4EF6\6570')
,p_lov_return_value=>'COUNT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(155331225296971782.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5225\3005\306B\30AB\30A6\30F3\30C8')
,p_lov_return_value=>'COUNT_DISTINCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(155331592721974019.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5225\3005\306B\30AB\30A6\30F3\30C8(\6982\6570)')
,p_lov_return_value=>'APPROX_COUNT_DISTINCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(155331898423975434.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\6700\5C0F')
,p_lov_return_value=>'MIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(155332158908977182.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\6700\5927')
,p_lov_return_value=>'MAX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(101017723584432406.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\5408\8A08')
,p_lov_return_value=>'SUM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(155335855601993887.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\5E73\5747')
,p_lov_return_value=>'AVG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166230555723037356.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\30E1\30B8\30A2\30F3')
,p_lov_return_value=>'MEDIAN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/alignment_l_c_r
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84702113000663314.4009)
,p_lov_name=>'ALIGNMENT_L_C_R'
,p_lov_query=>'.'||wwv_flow_api.id(84702113000663314.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84702319979663314.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\958B\59CB')
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84702526646663315.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4E2D\592E')
,p_lov_return_value=>'CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84702722814663315.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\7D42\4E86')
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/all_items_page_and_application
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(194317808992054940.4009)
,p_lov_name=>'ALL ITEMS (PAGE AND APPLICATION)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, name r',
'from wwv_flow_items',
'where security_group_id = :flow_security_group_id and',
'         flow_id = :fb_flow_id',
'union all',
'select name d, name r',
'from wwv_flow_step_items',
'where security_group_id = :flow_security_group_id and',
'         flow_id = :fb_flow_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/allow_page_repost
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84920132510743677.4009)
,p_lov_name=>'ALLOW PAGE REPOST'
,p_lov_query=>'.'||wwv_flow_api.id(84920132510743677.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84920305972743677.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\3044\3044\3048 - \30DA\30FC\30B8\306E\518D\30DD\30B9\30C8\3092\9632\6B62\3059\308B')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84920515901743678.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\306F\3044 - \30DA\30FC\30B8\306E\518D\30DD\30B9\30C8\3092\8A31\53EF\3059\308B')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/allowed_operations
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(86630311100418314.4009)
,p_lov_name=>'ALLOWED OPERATIONS'
,p_lov_query=>'.'||wwv_flow_api.id(86630311100418314.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88151603016962504.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\633F\5165')
,p_lov_return_value=>'I'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88151802892962505.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\66F4\65B0')
,p_lov_return_value=>'U'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(605643319539148456.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\524A\9664')
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_end_users
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1741323331892226882.4009)
,p_lov_name=>'APEX END USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select user_name d, user_name r',
'from wwv_flow_fnd_user u',
'where security_group_id = :flow_security_group_id',
'and not exists (select null',
'                from wwv_flow_developers d',
'                where d.security_group_id = u.security_group_id',
'                and d.userid            = u.user_name',
'                and (instr(d.developer_role,''ADMIN'') > 0',
'                     or instr(d.developer_role,''EDIT'') > 0))',
'and nvl(u.account_locked,''N'') = ''N''',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_views_filter_conditions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(200640422229340739.4009)
,p_lov_name=>'APEX Views Filter Conditions'
,p_lov_query=>'.'||wwv_flow_api.id(200640422229340739.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(200640620893340743.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'='
,p_lov_return_value=>'='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(200640809968340743.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'!='
,p_lov_return_value=>'!='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(200641025381340743.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'LIKE'
,p_lov_return_value=>'LIKE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(200641212319340743.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'NOT LIKE'
,p_lov_return_value=>'NOT LIKE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(200641411936340743.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'>'
,p_lov_return_value=>'>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(200641614080340743.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'<'
,p_lov_return_value=>'<'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(200641822670340743.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'BETWEEN'
,p_lov_return_value=>'BETWEEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(200642026032340743.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'IS'
,p_lov_return_value=>'IS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_computation_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84926512995804334.4009)
,p_lov_name=>'APP COMPUTATION TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(84926512995804334.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84926706354804335.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('PL/SQL\30D5\30A1\30F3\30AF\30B7\30E7\30F3\672C\4F53')
,p_lov_return_value=>'FUNCTION_BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84926905769804335.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30A2\30A4\30C6\30E0\5024')
,p_lov_return_value=>'ITEM_VALUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84927104623804335.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('PL/SQL\5F0F')
,p_lov_return_value=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84927328096804335.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('SQL\554F\5408\305B(\5358\4E00\306E\5024\3092\8FD4\3059)')
,p_lov_return_value=>'QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(484391218230836490.4009)
,p_lov_disp_sequence=>45
,p_lov_disp_value=>unistr('SQL\554F\5408\305B(\30B3\30ED\30F3\533A\5207\308A\306E\5024\3092\8FD4\3059)')
,p_lov_return_value=>'QUERY_COLON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84927527354804336.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30D7\30EA\30D5\30A1\30EC\30F3\30B9\3068\540C\3058\30A2\30A4\30C6\30E0\3092\8A2D\5B9A')
,p_lov_return_value=>'SET_ITEM_EQUAL_THIS_PREFERENCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84927909756804336.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('SQL\5F0F')
,p_lov_return_value=>'SQL_EXPRESSION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84928121322804336.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\9759\7684\5272\5F53\3066')
,p_lov_return_value=>'STATIC_ASSIGNMENT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_diff_components
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(15166510896787111.4009)
,p_lov_name=>'APP DIFF COMPONENTS'
,p_lov_query=>'.'||wwv_flow_api.id(15166510896787111.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15166729440787257.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8')
,p_lov_return_value=>'PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15166920981787257.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'PAGE.REGION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15167616090788599.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'PAGE.ITEM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15214625580576733.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30DC\30BF\30F3')
,p_lov_return_value=>'PAGE.BUTTON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15272703827450402.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
,p_lov_return_value=>'BREADCRUMB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15275406775489081.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'BREADCRUMB.ENTRY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15280612335642113.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'LOV'
,p_lov_return_value=>'LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15282816060662069.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('LOV\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'LOV.ENTRY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15286423211730438.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30D6\30E9\30F3\30C1')
,p_lov_return_value=>'PAGE.BRANCH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15289020964767588.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30D7\30ED\30BB\30B9')
,p_lov_return_value=>'PAGE.PROCESS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15405712412659795.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\30FB\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'NAVBAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15407718009765502.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\691C\8A3C')
,p_lov_return_value=>'PAGE.VALIDATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16035403732024287.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9')
,p_lov_return_value=>'APPLICATION.PROCESS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16049914242661216.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A08\7B97')
,p_lov_return_value=>'APPLICATION.COMPUTATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16051425979711899.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30BF\30D6')
,p_lov_return_value=>'TAB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16053917069766164.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\89AA\30BF\30D6')
,p_lov_return_value=>'PARENT.TAB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16055929929798216.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'APPLICATION.ITEM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16057603787828581.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_lov_return_value=>'BUILD.OPTION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16059007512848565.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30B9\30C8')
,p_lov_return_value=>'LIST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16061027392939460.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'LIST.ENTRY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16063928309005945.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30B7\30E7\30FC\30C8\30AB\30C3\30C8')
,p_lov_return_value=>'SHORTCUT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16064814158030207.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30C4\30EA\30FC')
,p_lov_return_value=>'TREE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16066121917117672.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
,p_lov_return_value=>'AUTHENTICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17120709519005837.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027')
,p_lov_return_value=>'APPLICATION.ATTRIBUTES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17177423445965489.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\5217')
,p_lov_return_value=>'REPORT.COLUMN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17180127956042460.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0')
,p_lov_return_value=>'AUTHORIZATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17181701739167324.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30C6\30FC\30DE')
,p_lov_return_value=>'THEME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17182812400265020.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'TEMPLATE.PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23040505396709149.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'TEMPLATE.REGION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23059602943831450.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'TEMPLATE.LIST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23060207099832682.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30E9\30D9\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'TEMPLATE.LABEL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23065614980853874.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'TEMPLATE.BREADCRUMB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23072813388938597.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'TEMPLATE.REPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23111731368066835.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30EC\30F3\30C0\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'TEMPLATE.CALENDAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23112607258069299.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DD\30C3\30D7\30A2\30C3\30D7LOV\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'TEMPLATE.POPUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23114220071073019.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DC\30BF\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'TEMPLATE.BUTTON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27856206573040810.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_lov_return_value=>'PLUGIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27856417308043979.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\306E\30ED\30FC\30C9')
,p_lov_return_value=>'DATA.LOADING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27863524730206971.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30C6\30AD\30B9\30C8\30FB\30E1\30C3\30BB\30FC\30B8')
,p_lov_return_value=>'TEXT.MESSAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30579828593361171.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Web\30B5\30FC\30D3\30B9')
,p_lov_return_value=>'WEB.SERVICE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(75139517313227717.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Flash\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'FLASH_CHART'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(75139828741231027.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Flash\30C1\30E3\30FC\30C8\30FB\30B7\30EA\30FC\30BA')
,p_lov_return_value=>'FLASH_CHART.SERIES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(101938626726557494.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\51FA\529B')
,p_lov_return_value=>'REGION PRINTING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(493071332668111886.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\8A08\7B97')
,p_lov_return_value=>'PAGE.COMPUTATION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_extend_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84881512912473090.4009)
,p_lov_name=>'APP EXTEND OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(84881512912473090.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84881732492473090.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\7A7A\767D\30DA\30FC\30B8')))
,p_lov_return_value=>'PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84881910860473091.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\30ED\30B0\30A4\30F3\30FB\30DA\30FC\30B8')))
,p_lov_return_value=>'LOGIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84882130890473091.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\30DA\30FC\30B8\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8\307E\305F\306F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8')))
,p_lov_return_value=>'WIZARD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_extend_options2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84884222524494810.4009)
,p_lov_name=>'APP EXTEND OPTIONS2'
,p_lov_query=>'.'||wwv_flow_api.id(84884222524494810.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84884418462494811.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\7A7A\767D\30DA\30FC\30B8')))
,p_lov_return_value=>'PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84884606421494811.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\30ED\30B0\30A4\30F3\30FB\30DA\30FC\30B8')))
,p_lov_return_value=>'LOGIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84884814299494811.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\30DA\30FC\30B8\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8\307E\305F\306F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8')))
,p_lov_return_value=>'WIZARD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_groups_assigned_unassigned
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(92271115231446627.4009)
,p_lov_name=>'APP GROUPS ASSIGNED UNASSIGNED'
,p_lov_query=>'.'||wwv_flow_api.id(92271115231446627.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(92271314455446628.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('- \3059\3079\3066 -')
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(92271714863446629.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5272\5F53\3066\6E08')
,p_lov_return_value=>'ASSIGNED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(92271520282446629.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\672A\5272\5F53\3066')
,p_lov_return_value=>'UNASSIGNED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_wizard_page_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(149548310855791684.4009)
,p_lov_name=>'APP WIZARD PAGE TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(149548310855791684.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149548517242791690.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7A7A\767D\30DA\30FC\30B8')
,p_lov_return_value=>'BLANK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149548725452791693.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8')
,p_lov_return_value=>'REPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149548909667791693.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('2\30DA\30FC\30B8\76EE\304C\7DE8\96C6\30D5\30A9\30FC\30E0\306E\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'REPORTANDFORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149549130170791694.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\7DE8\96C6\53EF\80FD\5BFE\8A71\30B0\30EA\30C3\30C9')
,p_lov_return_value=>'TABULARFORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149549303695791694.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\633F\5165\3001\66F4\65B0\304A\3088\3073\524A\9664\6A5F\80FD\4ED8\304D\30D5\30A9\30FC\30E0')
,p_lov_return_value=>'FORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(147022416546025322.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('1\30DA\30FC\30B8\306E\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB')
,p_lov_return_value=>'MASTERDETAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(618762604165647502.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30C1\30E3\30FC\30C8\30FB\30DA\30FC\30B8')
,p_lov_return_value=>'CHART'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(236361118648814472.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\30FB\30D3\30E5\30FC\30FB\30DA\30FC\30B8')
,p_lov_return_value=>'LISTVIEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(236361514982816147.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('2\30DA\30FC\30B8\76EE\304C\7DE8\96C6\30D5\30A9\30FC\30E0\306E\30EA\30B9\30C8\30FB\30D3\30E5\30FC')
,p_lov_return_value=>'LISTVIEWANDFORM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_groups_and_unassigned_groups
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(91658312614512198.4009)
,p_lov_name=>'APPLICATION GROUPS AND UNASSIGNED GROUPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select group_name, id',
'  from (',
'select group_name, id, 2 ob',
'  from wwv_flow_application_groups ',
' where security_group_id = :flow_security_group_id ',
'union all',
'select ''- ''||wwv_flow_lang.system_message(''Unassigned'')||'' -'' group_name, -1 id, 1 ob',
'  from dual',
')',
'order by ob, group_name'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_logo_image_or_text
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(210991102136588089.4009)
,p_lov_name=>'APPLICATION LOGO IMAGE OR TEXT'
,p_lov_query=>'.'||wwv_flow_api.id(210991102136588089.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(210991321100588090.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A4\30E1\30FC\30B8')
,p_lov_return_value=>'I'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(210991511506588095.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30C6\30AD\30B9\30C8')
,p_lov_return_value=>'T'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(238999874444009828.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30A4\30E1\30FC\30B8\3068\30C6\30AD\30B9\30C8')
,p_lov_return_value=>'IT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(239000212173009829.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E0')
,p_lov_return_value=>'C'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(461314228761951916.4009)
,p_lov_name=>'APPLICATION STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(461314228761951916.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461314410157951917.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4F7F\7528\53EF\80FD')
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461315009499955796.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4F7F\7528\4E0D\53EF')
,p_lov_return_value=>'UNAVAILABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_themes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(60317311466182536.4009)
,p_lov_name=>'APPLICATION THEMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select theme_id||''. '' ||wwv_flow_escape.html(theme_name) d, theme_id',
'  from wwv_flow_themes',
' where flow_id = nvl(:P224_A, :fb_flow_id)',
'   and security_group_id = :flow_security_group_id',
' order by theme_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_themes_active
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(8544631431632408.4009)
,p_lov_name=>'APPLICATION THEMES (ACTIVE)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select t.theme_id||''. '' ||t.theme_name as d,',
'       t.theme_id',
'  from wwv_flow_user_interfaces i,',
'       wwv_flow_themes t',
' where i.flow_id           = :FB_FLOW_ID',
'   and i.security_group_id = :WORKSPACE_ID',
'   and t.flow_id           = i.flow_id',
'   and t.theme_id          = i.theme_id',
'   and t.security_group_id = :WORKSPACE_ID',
' order by i.display_seq'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(183877501727908015.4009)
,p_lov_name=>'APPLICATION TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(183877501727908015.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183877711618908017.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\3059\3079\3066\8868\793A')
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183877900209908017.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Web\30B7\30FC\30C8')
,p_lov_return_value=>'WEBSHEET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183878115670908017.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9')
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_type_database_or_websheet
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(461305204810840905.4009)
,p_lov_name=>'APPLICATION TYPE DATABASE OR WEBSHEET'
,p_lov_query=>'.'||wwv_flow_api.id(461305204810840905.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461305420164840905.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9')
,p_lov_return_value=>'Database'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461305630940840907.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Web\30B7\30FC\30C8')
,p_lov_return_value=>'Websheet'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_compatibility_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(207464823363457503.4009)
,p_lov_name=>'APPLICATION.COMPATIBILITY_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(207464823363457503.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183105967630838029.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'19.2'
,p_lov_return_value=>'19.2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(218606250087580379.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'19.1'
,p_lov_return_value=>'19.1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(610184552140315733.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'5.1 / 18.1 / 18.2'
,p_lov_return_value=>'5.1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4967401114954788.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'5.0'
,p_lov_return_value=>'5.0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(207465025563457504.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'4.2'
,p_lov_return_value=>'4.2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(207465319619457504.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'4.1'
,p_lov_return_value=>'4.1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(207465627664457504.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('4.1\524D')
,p_lov_return_value=>'4.0'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_menus
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(149605524191093671.4009)
,p_lov_name=>'APPLICATION.MENUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) name,',
'       id',
'from   wwv_flow_menus',
'where  flow_id = :fb_flow_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/applications
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(15049727442569349.4009)
,p_lov_name=>'APPLICATIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'  from wwv_flow_visible_flows f',
' where f.build_status != ''RUN_AND_HIDDEN''',
' order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_templates
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(100224418521422119.4009)
,p_lov_name=>'APPLICATION_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'  from wwv_flows f',
' where security_group_id = 11 ',
'   and not exists ( select null',
'                      from wwv_flow_language_map',
'                     where translation_flow_id = f.id',
'                       and security_group_id = 11 )',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_view_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84241428998396992.4009)
,p_lov_name=>'APPLICATION_VIEW_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(84241428998396992.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84241625056396993.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8A73\7D30')
,p_lov_return_value=>'DETAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84241814483396993.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30EA\30B9\30C8')
,p_lov_return_value=>'LIST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_acl_groups
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(92479731157354006.4009)
,p_lov_name=>'APP_ACL_GROUPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select group_name d,',
'       id r',
'  from wwv_flow_fnd_user_groups',
' where security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and flow_id           = :FB_FLOW_ID',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_auth_option
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1814979507688651821.4009)
,p_lov_name=>'APP_AUTH_OPTION'
,p_lov_query=>'.'||wwv_flow_api.id(1814979507688651821.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1814979824886651823.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Application Express\30A2\30AB\30A6\30F3\30C8')
,p_lov_return_value=>'APEX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1814980014644651823.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Oracle Cloud Identity Management'
,p_lov_return_value=>'IDM'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(288183120240134690.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('HTTP\30D8\30C3\30C0\30FC\5909\6570')
,p_lov_return_value=>'HTTP_HEADER_VARIABLE'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>' wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_HHEAD'') = ''Y'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(288183408656134690.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('LDAP\30C7\30A3\30EC\30AF\30C8\30EA')
,p_lov_return_value=>'LDAP'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>' wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_LDAP'') = ''Y'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(288183730099134690.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Oracle Application Server Single Sign-On'
,p_lov_return_value=>'IAS_SSO'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>' wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_SSO'') = ''Y'''
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_char_set
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(86591912420238949.4009)
,p_lov_name=>'APP_CHAR_SET'
,p_lov_query=>'.'||wwv_flow_api.id(86591912420238949.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87520523148833682.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\8A9E(US-ASCII)')
,p_lov_return_value=>'US-ASCII'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87520707773833682.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Unicode(UTF8)'
,p_lov_return_value=>'UTF8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87520910595833682.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\897F\30E8\30FC\30ED\30C3\30D1\8A00\8A9E(Windows-1252)')
,p_lov_return_value=>'Windows-1252'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87521104177833683.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\897F\30E8\30FC\30ED\30C3\30D1\8A00\8A9E(ISO-8859-1)')
,p_lov_return_value=>'iso-8859-1'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_computation_points
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(48425308522403722.4009)
,p_lov_name=>'APP_COMPUTATION_POINTS'
,p_lov_query=>'.'||wwv_flow_api.id(48425308522403722.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48425626846403752.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\65B0\898F\30A4\30F3\30B9\30BF\30F3\30B9(\65B0\898F\30BB\30C3\30B7\30E7\30F3)\958B\59CB\6642')
,p_lov_return_value=>'ON_NEW_INSTANCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48425926823403752.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8A8D\8A3C\5F8C')
,p_lov_return_value=>'AFTER_LOGIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48426208730403756.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30D8\30C3\30C0\30FC\306E\524D')
,p_lov_return_value=>'BEFORE_HEADER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48426516073403756.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30D8\30C3\30C0\30FC\306E\5F8C')
,p_lov_return_value=>'AFTER_HEADER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48426820582403756.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\524D')
,p_lov_return_value=>'BEFORE_BOX_BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48427107076403756.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\5F8C')
,p_lov_return_value=>'AFTER_BOX_BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48427419682403756.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\30D5\30C3\30BF\30FC\306E\524D')
,p_lov_return_value=>'BEFORE_FOOTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48427721551403760.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\30D5\30C3\30BF\30FC\306E\5F8C')
,p_lov_return_value=>'AFTER_FOOTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48428021631403760.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\9001\4FE1\5F8C')
,p_lov_return_value=>'AFTER_SUBMIT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_copy_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84341526733632941.4009)
,p_lov_name=>'APP_COPY_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(84341526733632941.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(171495412485960439.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\30C6\30FC\30DE')
,p_lov_return_value=>'THEMES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84341707833632941.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'LOV'
,p_lov_return_value=>'LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1435744414125343373.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_lov_return_value=>'PLUGIN'
,p_required_patch=>wwv_flow_api.id(170786031904296885.4009)
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84341922244632941.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\30FB\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'NAVBAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84342129977632942.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0')
,p_lov_return_value=>'AUTHORIZATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(106274302385250184.4009)
,p_lov_disp_sequence=>1040
,p_lov_disp_value=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
,p_lov_return_value=>'AUTHENTICATION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_item_scope
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(211617631947367477.4009)
,p_lov_name=>'APP_ITEM_SCOPE'
,p_lov_query=>'.'||wwv_flow_api.id(211617631947367477.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(211617908937367477.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_lov_return_value=>'APP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(211618207033367479.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30B0\30ED\30FC\30D0\30EB')
,p_lov_return_value=>'GLOBAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_populate_roles
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177081808679947721.4009)
,p_lov_name=>'APP_POPULATE_ROLES'
,p_lov_query=>'.'||wwv_flow_api.id(177081808679947721.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177082156363947748.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30E6\30FC\30B6\30FC\30FB\30ED\30FC\30EB\306E\5272\5F53\3066')
,p_lov_return_value=>'R'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177082551234947749.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177082986222947749.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E0\30FB\30B3\30FC\30C9')
,p_lov_return_value=>'C'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(367839101511546508.4009)
,p_lov_name=>'APP_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(367839101511546508.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(367839421855546509.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6A19\6E96\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_lov_return_value=>'STANDARD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(367839606331546509.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(367839807571546510.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30B5\30F3\30D7\30EB\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_lov_return_value=>'SAMPLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_type_selection
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1427060334943927449.4009)
,p_lov_name=>'APP_TYPE_SELECTION'
,p_lov_query=>'.'||wwv_flow_api.id(1427060334943927449.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1427060547778927452.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\307F')
,p_lov_return_value=>'DATABASE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1427060827174927457.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30C7\30B9\30AF\30C8\30C3\30D7\304A\3088\3073Web\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1427061134601927458.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('Web\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\307F')
,p_lov_return_value=>'WEBSHEET'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_web_sources_for_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3852199756927887.4009)
,p_lov_name=>'APP_WEB_SOURCES_FOR_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'  from wwv_flow_web_src_modules m',
' where flow_id = :FB_FLOW_ID',
'   and exists ( select 1 ',
'                  from wwv_flow_web_src_operations',
'                 where web_src_module_id = m.id',
'                   and database_operation = ''FETCH_COLLECTION'' )',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_wiz_chart_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(161900516722838362.4009)
,p_lov_name=>'APP_WIZ_CHART_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(161900516722838362.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161900809488838368.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('3D\5217')
,p_lov_return_value=>'3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(618825618287796251.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('3D\7BC4\56F2\5217')
,p_lov_return_value=>'Range3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(617394520554093313.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\5217')
,p_lov_return_value=>'Stacked3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(617394723671094261.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\5217(%)')
,p_lov_return_value=>'3DSTACKED_PCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161901023475838370.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('2D\5217')
,p_lov_return_value=>'2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(618825824520798054.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('2D\7BC4\56F2\5217')
,p_lov_return_value=>'Range2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(617394927827095426.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('2D\7A4D\4E0A\3052\5217')
,p_lov_return_value=>'Stacked2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615715300950879723.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('3D\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'Horizontal3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(617395131982096613.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('2D\7A4D\4E0A\3052\5217(%)')
,p_lov_return_value=>'2DSTACKED_PCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(618826103873801635.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('3D\7BC4\56F2\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'HorizontalRange3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(617404612290119346.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'StackedHorizontal3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(617404817138120730.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\68D2\30B0\30E9\30D5(%)')
,p_lov_return_value=>'3DHSTACKED_PCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615715506838881495.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('2D\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'Horizontal2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(618826408029802793.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('2D\7BC4\56F2\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'HorizontalRange2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(617405825103123010.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('2D\7A4D\4E0A\3052\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'StackedHorizontal2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(617406029951124372.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('2D\7A4D\4E0A\3052\68D2\30B0\30E9\30D5(%)')
,p_lov_return_value=>'2DHSTACKED_PCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615716321729885785.4009)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\6298\308C\7DDA')
,p_lov_return_value=>'2DLine'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(618826615301804931.4009)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\6563\5E03/\30DE\30FC\30AB\30FC')
,p_lov_return_value=>'ScatterMarker'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615715710647882561.4009)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('3D\5186')
,p_lov_return_value=>'3DPie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615715914110883599.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('2D\5186')
,p_lov_return_value=>'2DPie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615716117573884523.4009)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('2D\30C9\30FC\30CA\30C4')
,p_lov_return_value=>'2DDoughnut'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615716629694888045.4009)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>unistr('\30C0\30A4\30E4\30EB')
,p_lov_return_value=>'GaugeChart'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(618827129500808965.4009)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>unistr('\30C0\30A4\30E4\30EB(%)')
,p_lov_return_value=>'DIAL_PCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(618826920842806469.4009)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>unistr('\30ED\30FC\30BD\30AF\8DB3')
,p_lov_return_value=>'Candlestick'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(618827332616809914.4009)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('\30D7\30ED\30B8\30A7\30AF\30C8\30FB\30AC\30F3\30C8')
,p_lov_return_value=>'ProjectGantt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(618827502965810767.4009)
,p_lov_disp_sequence=>26
,p_lov_disp_value=>unistr('\30EA\30BD\30FC\30B9\30FB\30AC\30F3\30C8')
,p_lov_return_value=>'ResourceGantt'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_wiz_create_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(161818726905576357.4009)
,p_lov_name=>'APP_WIZ_CREATE_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(161818726905576357.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161819017462576362.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8AAD\53D6\308A\5C02\7528')
,p_lov_return_value=>'R'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161819201423576364.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8AAD\307F\66F8\304D\4E21\7528')
,p_lov_return_value=>'RW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/audit_action
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(192763415498955359.4009)
,p_lov_name=>'AUDIT ACTION'
,p_lov_query=>'.'||wwv_flow_api.id(192763415498955359.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192763609015955370.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\633F\5165')
,p_lov_return_value=>'I'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192763829535955373.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\66F4\65B0')
,p_lov_return_value=>'U'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192764030537955373.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\524A\9664')
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/audit_naming
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(192773330531006109.4009)
,p_lov_name=>'AUDIT_NAMING'
,p_lov_query=>'.'||wwv_flow_api.id(192773330531006109.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192773504494006111.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027')
,p_lov_return_value=>'WWV_FLOWS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192773719028006113.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'WWV_FLOW_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192773912582006113.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC')
,p_lov_return_value=>'WWV_FLOW_ICON_BAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192774132498006113.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9')
,p_lov_return_value=>'WWV_FLOW_PROCESSING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192774324088006113.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'WWV_FLOW_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192774507402006114.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A08\7B97')
,p_lov_return_value=>'WWV_FLOW_COMPUTATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192774728974006114.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30BF\30D6')
,p_lov_return_value=>'WWV_FLOW_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192774924389006115.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\89AA\30BF\30D6')
,p_lov_return_value=>'WWV_FLOW_TOPLEVEL_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192775116232006115.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'LOV'
,p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES$'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192775308893006115.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('LOV\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES_DATA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192775506134006116.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\5C5E\6027')
,p_lov_return_value=>'WWV_FLOW_STEPS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192775729209006116.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30DC\30BF\30F3')
,p_lov_return_value=>'WWV_FLOW_STEP_BUTTONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192775914488006116.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30D6\30E9\30F3\30C1')
,p_lov_return_value=>'WWV_FLOW_STEP_BRANCHES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192776105194006116.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30D6\30E9\30F3\30C1\5F15\6570')
,p_lov_return_value=>'WWV_FLOW_STEP_BRANCH_ARGS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192776313341006117.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'WWV_FLOW_STEP_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192776518774006117.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\8A08\7B97')
,p_lov_return_value=>'WWV_FLOW_STEP_COMPUTATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192776728927006117.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\691C\8A3C')
,p_lov_return_value=>'WWV_FLOW_STEP_VALIDATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192776908821006117.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30D7\30ED\30BB\30B9')
,p_lov_return_value=>'WWV_FLOW_STEP_PROCESSING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192777132334006118.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'WWV_FLOW_PAGE_PLUG_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192777326352006118.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\884C\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'WWV_FLOW_ROW_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192777504961006118.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'WWV_FLOW_LIST_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192777704768006118.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\5C5E\6027')
,p_lov_return_value=>'WWV_FLOW_PAGE_PLUGS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192777913070006119.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30E1\30C3\30BB\30FC\30B8')
,p_lov_return_value=>'WWV_FLOW_MESSAGES$'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192778131775006119.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_lov_return_value=>'WWV_FLOW_PATCHES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192778311606006120.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\958B\767A\8005(\7BA1\7406)')
,p_lov_return_value=>'WWV_FLOW_DEVELOPERS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192778526631006120.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30EA\30B9\30C8')
,p_lov_return_value=>'WWV_FLOW_LISTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192778710948006120.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\30FB\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'WWV_FLOW_LIST_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192778903034006120.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6709\52B9\306A\30E6\30FC\30B6\30FCID(\7BA1\7406)')
,p_lov_return_value=>'WWV_FLOW_EFFECTIVE_USERID_MAP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192779106904006121.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30B7\30E7\30FC\30C8\30AB\30C3\30C8')
,p_lov_return_value=>'WWV_FLOW_SHORTCUTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192779305727006121.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\30FB\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8')
,p_lov_return_value=>'WWV_FLOW_STEP_ITEM_HELP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192779523562006121.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8A8D\8A3C\8A2D\5B9A')
,p_lov_return_value=>'WWV_FLOW_AUTHENTICATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192779703226006121.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A8\30F3\30C8\30EA\30FB\30DD\30A4\30F3\30C8')
,p_lov_return_value=>'WWV_FLOW_ENTRY_POINTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192779919153006122.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A8\30F3\30C8\30EA\30FB\30DD\30A4\30F3\30C8\5F15\6570')
,p_lov_return_value=>'WWV_FLOW_ENTRY_POINT_ARGS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192814127076119594.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'WWV_FLOW_MENU_OPTIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192918929997948694.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30C6\30FC\30DE')
,p_lov_return_value=>'WWV_FLOW_THEMES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/auth_scheme_component_list
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19565023708932258.4009)
,p_lov_name=>'AUTH SCHEME COMPONENT LIST'
,p_lov_query=>'.'||wwv_flow_api.id(19565023708932258.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14565005829208271.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30C1\30E3\30FC\30C8\30FB\30B7\30EA\30FC\30BA')
,p_lov_return_value=>'WWV_FLOW_FLASH_CHART5_SERIES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19565408576932259.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A08\7B97')
,p_lov_return_value=>'WWV_FLOW_COMPUTATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19565616823932259.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\30FB\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'WWV_FLOW_ICON_BAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19565811243932259.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'WWV_FLOW_LIST_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19566018968932260.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
,p_lov_return_value=>'WWV_FLOW_MENU_OPTIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19566229367932260.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9')
,p_lov_return_value=>'WWV_FLOW_PROCESSING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19566425485932260.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30D6\30E9\30F3\30C1')
,p_lov_return_value=>'WWV_FLOW_STEP_BRANCHES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19566609500932260.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30DC\30BF\30F3')
,p_lov_return_value=>'WWV_FLOW_STEP_BUTTONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19566827943932260.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\8A08\7B97')
,p_lov_return_value=>'WWV_FLOW_STEP_COMPUTATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19567024556932261.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'WWV_FLOW_STEP_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19567203422932261.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30D7\30ED\30BB\30B9')
,p_lov_return_value=>'WWV_FLOW_STEP_PROCESSING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19567427523932261.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\691C\8A3C')
,p_lov_return_value=>'WWV_FLOW_STEP_VALIDATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19567631501932261.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6A19\6E96\30BF\30D6')
,p_lov_return_value=>'WWV_FLOW_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19567802034932262.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\89AA\30BF\30D6')
,p_lov_return_value=>'WWV_FLOW_TOPLEVEL_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19568016566932263.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8')
,p_lov_return_value=>'WWV_FLOW_STEPS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19664501543326267.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\5217')
,p_lov_return_value=>'WWV_FLOW_REGION_REPORT_COLUMN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19664915179339682.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'WWV_FLOW_PAGE_PLUGS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authentication_methods2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(62983620392370890.4009)
,p_lov_name=>'AUTHENTICATION_METHODS2'
,p_lov_query=>'.'||wwv_flow_api.id(62983620392370890.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(124262609673589368.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('SCHEME(\4F5C\6210\6E08\307E\305F\306F\30E6\30FC\30B6\30FC\304C\72EC\81EA\306B\4F5C\6210)')
,p_lov_return_value=>'CUSTOM2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62984185221370917.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('INTERNAL (\30ED\30FC\30AB\30EB\30FB\30A2\30AB\30A6\30F3\30C8\30FB\30EA\30DD\30B8\30C8\30EA)')
,p_lov_return_value=>'COOKIE'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authentication_schemes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(166264006489001223.4009)
,p_lov_name=>'AUTHENTICATION_SCHEMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name as d,',
'       id   as r',
'  from wwv_flow_authentications',
' where flow_id           = :fb_flow_id',
'   and security_group_id = :WORKSPACE_ID',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authentication_scheme_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(346988529123216543.4009)
,p_lov_name=>'AUTHENTICATION_SCHEME_TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,',
'       r',
'  from (',
'        select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.''|| name_with_prefix) as d,',
'               name_with_prefix      as r',
'          from wwv_flow_native_plugins',
'         where plugin_type = ''AUTHENTICATION TYPE''',
'         union all',
'        select display_name || wwv_flow_lang.system_message(''PLUGIN.DISPLAY_NAME_POSTFIX'') as d,',
'               ''PLUGIN_'' || name     as r',
'          from wwv_flow_plugins',
'         where flow_id           = to_number(:FB_FLOW_ID)',
'           and security_group_id = to_number(:WORKSPACE_ID)',
'           and plugin_type       = ''AUTHENTICATION TYPE''',
'       )',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authorization_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(11239432234132441.4009)
,p_lov_name=>'AUTHORIZATION TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,',
'       r',
'  from (',
'        select wwv_flow_lang.system_message(''AUTHORIZATION_NAME.''|| name_with_prefix) as d,',
'               name_with_prefix      as r',
'          from wwv_flow_native_plugins',
'         where plugin_type = ''AUTHORIZATION TYPE''',
'         union all',
'        select display_name || wwv_flow_lang.system_message(''PLUGIN.DISPLAY_NAME_POSTFIX'') as d,',
'               ''PLUGIN_'' || name     as r',
'          from wwv_flow_plugins',
'         where flow_id           = to_number(:FB_FLOW_ID)',
'           and security_group_id = to_number(:WORKSPACE_ID)',
'           and plugin_type       = ''AUTHORIZATION TYPE''',
'       )',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authz_scheme_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84861720259380643.4009)
,p_lov_name=>'AUTHZ_SCHEME_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(84861720259380643.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84861902602380643.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('EXISTS SQL\554F\5408\305B')
,p_lov_return_value=>'EXISTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84862521867380644.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('NOT EXISTS SQL\554F\5408\305B')
,p_lov_return_value=>'NOT_EXISTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84862132654380644.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5F0F1\306E\30A2\30A4\30C6\30E0\304CNULL')
,p_lov_return_value=>'ITEM_IS_NULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84862305726380644.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\5F0F1\306E\30A2\30A4\30C6\30E0\304CNOT NULL')
,p_lov_return_value=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84862724485380644.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30D6\30FC\30EB\3092\623B\3059PL/SQL\30D5\30A1\30F3\30AF\30B7\30E7\30F3')
,p_lov_return_value=>'FUNCTION_RETURNING_BOOLEAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84862924429380645.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\5F0F1\306E\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\5024 = \5F0F2')
,p_lov_return_value=>'PREFERENCE_EQ_COND_TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84863130627380645.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\5F0F1\306E\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\5024 != \5F0F2')
,p_lov_return_value=>'PREFERENCE_NOT_EQ_COND_TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84863509444380645.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\5F0F1\306E\30A2\30A4\30C6\30E0\306E\5024 = \5F0F2')
,p_lov_return_value=>'VAL_OF_ITEM_IN_COND_EQ_COND_TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84863327213380645.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\5F0F1\306E\30A2\30A4\30C6\30E0\306E\5024 != \5F0F2')
,p_lov_return_value=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND_TEXT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/auth_scheme_caching
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84860700520374929.4009)
,p_lov_name=>'AUTH_SCHEME_CACHING'
,p_lov_query=>'.'||wwv_flow_api.id(84860700520374929.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84861103921374931.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30BB\30C3\30B7\30E7\30F3\3054\3068\306B1\56DE')
,p_lov_return_value=>'BY_USER_BY_SESSION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84860914895374930.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30D3\30E5\30FC\3054\3068\306B1\56DE')
,p_lov_return_value=>'BY_USER_BY_PAGE_VIEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(360366921153074028.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\3054\3068\306B1\56DE')
,p_lov_return_value=>'BY_COMPONENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(360367209904074033.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\5E38\6642(\30AD\30E3\30C3\30B7\30E5\306A\3057)')
,p_lov_return_value=>'NOCACHE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/auth_scheme_refresh
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(86574617605164667.4009)
,p_lov_name=>'AUTH_SCHEME_REFRESH'
,p_lov_query=>'select wwv_flow_lang.system_message(''INITCAP_REFRESH'')  a,''Y'' b from dual'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/auth_wiz_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84347110372647083.4009)
,p_lov_name=>'AUTH_WIZ_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(84347110372647083.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88152606479963512.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6700\521D\304B\3089')
,p_lov_return_value=>'BLANK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88152800735963512.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\65E2\5B58\306E\8A8D\53EF\30B9\30AD\30FC\30E0\306E\30B3\30D4\30FC\3068\3057\3066')
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/axis_interval
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84866925931391695.4009)
,p_lov_name=>'AXIS_INTERVAL'
,p_lov_query=>'.'||wwv_flow_api.id(84866925931391695.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84867111432391695.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8EF8\9593\9694\306E\5B9A\7FA9')
,p_lov_return_value=>'DEFINE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84867324796391696.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8EF8\9593\9694\3092\81EA\52D5\8868\793A')
,p_lov_return_value=>'AUTO'
);
end;
/
prompt --application/shared_components/user_interface/lovs/Begin_on_new_line
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(67832807038215585.4009)
,p_lov_name=>'BEGIN ON NEW LINE'
,p_lov_query=>'.'||wwv_flow_api.id(67832807038215585.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(67833101831215595.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\65B0\898F\884C\3067\958B\59CB')
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/Begin_on_new_field
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(86067527340770119.4009)
,p_lov_name=>'BEGIN_ON_NEW_FIELD'
,p_lov_query=>'.'||wwv_flow_api.id(86067527340770119.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88282922464772458.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65B0\898F\30D5\30A3\30FC\30EB\30C9\3067\958B\59CB')
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/blob_format_content_disposition_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(317509508537932808.4009)
,p_lov_name=>'BLOB_FORMAT_CONTENT_DISPOSITION_TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''BLOB_FORMAT_ATTACHMENT'') d, ''Attachment'' r',
'     from dual',
'union',
'select wwv_flow_lang.system_message(''BLOB_FORMAT_INLINE'') d, ''Inline'' r',
'     from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/blob_format_mask_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(317502218630715477.4009)
,p_lov_name=>'BLOB_FORMAT_MASK_TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''BLOB_FORMAT_DOWNLOAD'') d, ''DOWNLOAD'' r',
'     from dual',
'union',
'select wwv_flow_lang.system_message(''BLOB_FORMAT_IMAGE'') d, ''IMAGE'' r',
'     from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/branch_points_condensed
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(185544520425574805.4009)
,p_lov_name=>'BRANCH.POINTS.CONDENSED'
,p_lov_query=>'.'||wwv_flow_api.id(185544520425574805.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(185544824823574814.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8A08\7B97\306E\524D')
,p_lov_return_value=>'BEFORE_COMPUTATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(185545021461574815.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\691C\8A3C\306E\524D')
,p_lov_return_value=>'BEFORE_VALIDATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(185545229692574815.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30D7\30ED\30BB\30B9\306E\524D')
,p_lov_return_value=>'BEFORE_PROCESSING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(185545414740574816.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30D7\30ED\30BB\30B9\306E\5F8C')
,p_lov_return_value=>'AFTER_PROCESSING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(185545628448574816.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30D8\30C3\30C0\30FC\306E\524D')
,p_lov_return_value=>'BEFORE_HEADER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/breadcrumb_entry_or_container
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(205111517140679117.4009)
,p_lov_name=>'BREADCRUMB ENTRY OR CONTAINER'
,p_lov_query=>'.'||wwv_flow_api.id(205111517140679117.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(205111902995679137.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
,p_lov_return_value=>'BREADCRUMB'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(205345212580624072.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'REGION'
,p_lov_template=>'#DISPLAY_VALUE#'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flow_menus where flow_id = :fb_flow_id and security_group_id = :flow_security_group_id;'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_on_report_positions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(83332708448288963.4009)
,p_lov_name=>'BREAK.ON.REPORT.POSITIONS'
,p_lov_query=>'.'||wwv_flow_api.id(83332708448288963.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88283729044774273.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6700\521D\306E\5217')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88283921634774274.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6700\521D\30682\756A\76EE\306E\5217')
,p_lov_return_value=>'1:2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88284111739774274.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\6700\521D\30012\756A\76EE\304A\3088\30733\756A\76EE\306E\5217')
,p_lov_return_value=>'1:2:3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(86602811774267145.4009)
,p_lov_name=>'BREAK_COLUMNS'
,p_lov_query=>'.'||wwv_flow_api.id(86602811774267145.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88287205065786323.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\52171')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88287428523786324.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\52171\304A\3088\30732')
,p_lov_return_value=>'1:2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88287603244786324.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\52171\30012\304A\3088\30733')
,p_lov_return_value=>'1:2:3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_on_report_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84247004458418293.4009)
,p_lov_name=>'BREAK_ON_REPORT_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(84247004458418293.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84247211888418294.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6700\521D\306E\5217')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84247432172418294.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6700\521D\30682\756A\76EE\306E\5217')
,p_lov_return_value=>'12'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84247624024418294.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\6700\521D\30012\756A\76EE\304A\3088\30733\756A\76EE\306E\5217')
,p_lov_return_value=>'123'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_type_flag
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84369008472684429.4009)
,p_lov_name=>'BREAK_TYPE_FLAG'
,p_lov_query=>'.'||wwv_flow_api.id(84369008472684429.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84369227840684431.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D6\30EC\30FC\30AF\306E\7E70\8FD4\3057\30D8\30C3\30C0\30FC')
,p_lov_return_value=>'REPEAT_HEADINGS_ON_BREAK_1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84369407631684431.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30C7\30D5\30A9\30EB\30C8\30FB\30D6\30EC\30FC\30AF\66F8\5F0F')
,p_lov_return_value=>'DEFAULT_BREAK_FORMATTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/browser_cache
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(875788205897309215.4009)
,p_lov_name=>'BROWSER_CACHE'
,p_lov_query=>'.'||wwv_flow_api.id(875788205897309215.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(875788522508309218.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6709\52B9')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(875788730295309223.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\7121\52B9')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/browser_frame
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1098055005642193053.4009)
,p_lov_name=>'BROWSER_FRAME'
,p_lov_query=>'.'||wwv_flow_api.id(1098055005642193053.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1098055323316193055.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\62D2\5426')
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1098055511785193055.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\540C\3058\8D77\70B9\304B\3089\8A31\53EF')
,p_lov_return_value=>'S'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1098055725585193055.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\8A31\53EF')
,p_lov_return_value=>'A'
);
end;
/
prompt --application/shared_components/user_interface/lovs/build_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84305510710571518.4009)
,p_lov_name=>'BUILD_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(84305510710571518.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84305709177571518.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5B9F\884C\306E\307F')
,p_lov_return_value=>'RUN_ONLY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84305911098571518.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5B9F\884C\304A\3088\3073\69CB\7BC9')
,p_lov_return_value=>'RUN_AND_BUILD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_theme_class_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(43576623634636183.4009)
,p_lov_name=>'BUTTON THEME CLASS ID'
,p_lov_query=>'.'||wwv_flow_api.id(43576623634636183.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43576912701636189.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DC\30BF\30F3')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43584317316653265.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DC\30BF\30F3\3001\4EE3\66FF1')
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43584619394653936.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DC\30BF\30F3\3001\4EE3\66FF2')
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(44139910490884391.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DC\30BF\30F3\3001\4EE3\66FF3')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43588706496669090.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E01')
,p_lov_return_value=>'6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43592228791685003.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E02')
,p_lov_return_value=>'7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43592532254685982.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E03')
,p_lov_return_value=>'8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43592802256686769.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E04')
,p_lov_return_value=>'9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43593427883694186.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E05')
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43593729961694767.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E06')
,p_lov_return_value=>'11'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43594031692695331.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E07')
,p_lov_return_value=>'12'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43594301695696066.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E08')
,p_lov_return_value=>'13'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_attributes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(147003111936901406.4009)
,p_lov_name=>'BUTTON.ATTRIBUTES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct rtrim(BUTTON_CATTRIBUTES ) ba, rtrim(BUTTON_CATTRIBUTES ) r',
'from   wwv_flow_step_buttons',
'where  flow_id = :fb_flow_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_is_reset
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84945521447891923.4009)
,p_lov_name=>'BUTTON.IS.RESET'
,p_lov_query=>'.'||wwv_flow_api.id(84945521447891923.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84945714043891924.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DC\30BF\30F3\3092\30EA\30BB\30C3\30C8')
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/buttons_current_and_global_page
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6214918033450806.4009)
,p_lov_name=>'BUTTONS_CURRENT_AND_GLOBAL_PAGE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select button_name,',
'       id',
'  from (',
'        /* all region buttons from current page and global page */',
'        select case when b.flow_step_id = ui.global_page_id then',
'                   wwv_flow_lang.system_message(''LAYOUT.GLOBAL_PAGE_REGION_PREFIX'')',
'               end ||',
'               b.button_name ||',
'               '' ('' || b.button_image_alt || '')'' as button_name,',
'               b.id,',
'               b.button_name bn,',
'               case when b.flow_step_id = ui.global_page_id then 2 else 1 end x',
'          from wwv_flow_steps p,',
'               wwv_flow_user_interfaces ui,',
'               wwv_flow_step_buttons b',
'         where p.flow_id      = :FB_FLOW_ID',
'           and p.id           = :FB_FLOW_PAGE_ID',
'           and ui.id          = p.user_interface_id',
'           and b.flow_id      = ui.flow_id',
'           and b.flow_step_id in (:FB_FLOW_PAGE_ID, ui.global_page_id)',
'         order by x, bn ',
'       )'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_action
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(458463318087925002.4009)
,p_lov_name=>'BUTTON_ACTION'
,p_lov_query=>'.'||wwv_flow_api.id(458463318087925002.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(458465032417938534.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\306E\9001\4FE1')
,p_lov_return_value=>'SUBMIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(458463516386925008.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DA\30FC\30B8\306B\30EA\30C0\30A4\30EC\30AF\30C8')
,p_lov_return_value=>'REDIRECT_PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(393410308299183569.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\5225\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DA\30FC\30B8\306B\30EA\30C0\30A4\30EC\30AF\30C8')
,p_lov_return_value=>'REDIRECT_APP'
,p_lov_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_lov_disp_cond=>'4314'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(458463707481925009.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('URL\306B\30EA\30C0\30A4\30EC\30AF\30C8')
,p_lov_return_value=>'REDIRECT_URL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2217226943030013.4009)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3\3067\5B9A\7FA9')
,p_lov_return_value=>'DEFINED_BY_DA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(460984115025005702.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\51FA\529B\53EF\80FD\306A\30EC\30DD\30FC\30C8\554F\5408\305B\306E\30C0\30A6\30F3\30ED\30FC\30C9')
,p_lov_return_value=>'REPORT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_SHARED_QUERIES',
' where flow_id = :fb_flow_id ',
'   and security_group_id = :flow_security_group_id',
'   and :APP_PAGE_ID = 4732'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3791885581293.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\306E\30EA\30BB\30C3\30C8')
,p_lov_return_value=>'RESET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3791888582683.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\6B21\306E\30DA\30FC\30B8(\975E\63A8\5968)')
,p_lov_return_value=>'NEXT_PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3791891583799.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\524D\306E\30DA\30FC\30B8(\975E\63A8\5968)')
,p_lov_return_value=>'PREVIOUS_PAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_alignment_body
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1791921829301402873.4009)
,p_lov_name=>'BUTTON_ALIGNMENT_BODY'
,p_lov_query=>'.'||wwv_flow_api.id(1791921829301402873.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791928140531406086.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\592E')
,p_lov_return_value=>'CENTER'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791992121273442944.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4E2D\592E\4E0B\90E8')
,p_lov_return_value=>'CENTER-BOTTOM'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791992586609442944.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\4E2D\592E')
,p_lov_return_value=>'CENTER-CENTER'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791992941985442945.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\4E2D\592E\4E0A\90E8')
,p_lov_return_value=>'CENTER-TOP'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791922115849402875.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\958B\59CB')
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791994711029455023.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\958B\59CB\4E0B\90E8')
,p_lov_return_value=>'LEFT-BOTTOM'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791995189708455023.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\958B\59CB\4E2D\592E')
,p_lov_return_value=>'LEFT-CENTER'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791995570954455023.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\958B\59CB\4E0A\90E8')
,p_lov_return_value=>'LEFT-TOP'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791922578885402875.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\7D42\4E86')
,p_lov_return_value=>'RIGHT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791995970458455024.4009)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\7D42\4E86\4E0B\90E8')
,p_lov_return_value=>'RIGHT-BOTTOM'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791996381262455024.4009)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\7D42\4E86\4E2D\592E')
,p_lov_return_value=>'RIGHT-CENTER'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1791996791436455025.4009)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('\7D42\4E86\4E0A\90E8')
,p_lov_return_value=>'RIGHT-TOP'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_alignment_l_r
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84754827158805413.4009)
,p_lov_name=>'BUTTON_ALIGNMENT_L_R'
,p_lov_query=>'.'||wwv_flow_api.id(84754827158805413.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84755030664805414.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\958B\59CB')
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84755202951805414.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\7D42\4E86')
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_display_positions2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(62990572348595109.4009)
,p_lov_name=>'BUTTON_DISPLAY_POSITIONS2'
,p_lov_query=>'.'||wwv_flow_api.id(62990572348595109.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62990815665595115.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30BF\30A4\30C8\30EB\306E\524D')
,p_lov_return_value=>'LEFT_OF_TITLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62991037953595115.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30BF\30A4\30C8\30EB\306E\5F8C')
,p_lov_return_value=>'RIGHT_OF_TITLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62991212359595118.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\4E0A')
,p_lov_return_value=>'ABOVE_BOX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62991440121595118.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\4E0A\90E8')
,p_lov_return_value=>'TOP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62991617521595119.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\4E0B\90E8')
,p_lov_return_value=>'BOTTOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62991820415595119.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\4E0A\90E8\304A\3088\3073\4E0B\90E8')
,p_lov_return_value=>'TOP_AND_BOTTOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62992017822595122.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\4E0B')
,p_lov_return_value=>'BELOW_BOX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62992218359595123.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#DEFAULT#')
,p_lov_return_value=>'TEMPLATE_DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(92320911107933644.4009)
,p_lov_disp_sequence=>9.5
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#CHANGE#')
,p_lov_return_value=>'REGION_TEMPLATE_CHANGE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where (p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CHANGE#'') > 0',
'   and :F4000_REGION_SELECTED = p.id) '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62992810843595124.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#CLOSE#')
,p_lov_return_value=>'REGION_TEMPLATE_CLOSE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CLOSE#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93091020144798464.4009)
,p_lov_disp_sequence=>10.1
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#COPY#')
,p_lov_return_value=>'REGION_TEMPLATE_COPY'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#COPY#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62992615015595124.4009)
,p_lov_disp_sequence=>10.2
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#CREATE#')
,p_lov_return_value=>'REGION_TEMPLATE_CREATE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CREATE#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(94882719481696997.4009)
,p_lov_disp_sequence=>10.3
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#CREATE2#')
,p_lov_return_value=>'REGION_TEMPLATE_CREATE2'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CREATE2#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(92332909801949409.4009)
,p_lov_disp_sequence=>10.5
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#DELETE#')
,p_lov_return_value=>'REGION_TEMPLATE_DELETE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#DELETE#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62992414762595123.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#EDIT#')
,p_lov_return_value=>'REGION_TEMPLATE_EDIT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#EDIT#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62993052778595124.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#EXPAND#')
,p_lov_return_value=>'REGION_TEMPLATE_EXPAND'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#EXPAND#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62993213440595125.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#HELP#')
,p_lov_return_value=>'REGION_TEMPLATE_HELP'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#HELP#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(91088720180648151.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#NEXT#')
,p_lov_return_value=>'REGION_TEMPLATE_NEXT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#NEXT#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(91089316514649842.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#PREVIOUS#')
,p_lov_return_value=>'REGION_TEMPLATE_PREVIOUS'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#PREVIOUS#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(138976531453546871.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306E\691C\7D22\30D0\30FC\306E\53F3')
,p_lov_return_value=>'RIGHT_OF_IR_SEARCH_BAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(624319995418870652.4009)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\672C\4F53')
,p_lov_return_value=>'BODY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_display_positions_p4314
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1905973109443967318.4009)
,p_lov_name=>'BUTTON_DISPLAY_POSITIONS_P4314'
,p_lov_query=>'.'||wwv_flow_api.id(1905973109443967318.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905973494553967321.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30BF\30A4\30C8\30EB\306E\524D')
,p_lov_return_value=>'LEFT_OF_TITLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905973847440967326.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30BF\30A4\30C8\30EB\306E\5F8C')
,p_lov_return_value=>'RIGHT_OF_TITLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905974225968967326.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\4E0A')
,p_lov_return_value=>'ABOVE_BOX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905974643088967327.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\4E0A\90E8')
,p_lov_return_value=>'TOP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905975001534967328.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\4E0B\90E8')
,p_lov_return_value=>'BOTTOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905975451050967328.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\4E0A\90E8\304A\3088\3073\4E0B\90E8')
,p_lov_return_value=>'TOP_AND_BOTTOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905975896920967328.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\4E0B')
,p_lov_return_value=>'BELOW_BOX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905976264022967329.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#DEFAULT#')
,p_lov_return_value=>'TEMPLATE_DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905976604330967330.4009)
,p_lov_disp_sequence=>9.5
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#CHANGE#')
,p_lov_return_value=>'REGION_TEMPLATE_CHANGE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where (p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CHANGE#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id) '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905977013205967330.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#CLOSE#')
,p_lov_return_value=>'REGION_TEMPLATE_CLOSE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CLOSE#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905977454417967330.4009)
,p_lov_disp_sequence=>10.1
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#COPY#')
,p_lov_return_value=>'REGION_TEMPLATE_COPY'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#COPY#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905977884980967330.4009)
,p_lov_disp_sequence=>10.2
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#CREATE#')
,p_lov_return_value=>'REGION_TEMPLATE_CREATE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CREATE#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905978269729967331.4009)
,p_lov_disp_sequence=>10.3
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#CREATE2#')
,p_lov_return_value=>'REGION_TEMPLATE_CREATE2'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CREATE2#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905978605947967331.4009)
,p_lov_disp_sequence=>10.5
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#DELETE#')
,p_lov_return_value=>'REGION_TEMPLATE_DELETE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#DELETE#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905979000705967331.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#EDIT#')
,p_lov_return_value=>'REGION_TEMPLATE_EDIT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#EDIT#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905979400972967331.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#EXPAND#')
,p_lov_return_value=>'REGION_TEMPLATE_EXPAND'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#EXPAND#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905979808782967331.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#HELP#')
,p_lov_return_value=>'REGION_TEMPLATE_HELP'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#HELP#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905980225496967331.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#NEXT#')
,p_lov_return_value=>'REGION_TEMPLATE_NEXT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#NEXT#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905980687897967331.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F4D\7F6E\306E#PREVIOUS#')
,p_lov_return_value=>'REGION_TEMPLATE_PREVIOUS'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#PREVIOUS#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905981095145967332.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306E\691C\7D22\30D0\30FC\306E\53F3')
,p_lov_return_value=>'RIGHT_OF_IR_SEARCH_BAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1905981421062967332.4009)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\30DC\30C7\30A3')
,p_lov_return_value=>'BODY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_style
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(86073927602789091.4009)
,p_lov_name=>'BUTTON_STYLE'
,p_lov_query=>'.'||wwv_flow_api.id(86073927602789091.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88291012122797801.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('HTML\30DC\30BF\30F3')
,p_lov_return_value=>'HTML'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88291203722797802.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30D9\30FC\30B9\306E\30DC\30BF\30F3')
,p_lov_return_value=>'BUTTON_TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88291406025797802.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30A4\30E1\30FC\30B8')
,p_lov_return_value=>'IMAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_tag_attributes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(159064700887669967.4009)
,p_lov_name=>'BUTTON_TAG_ATTRIBUTES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct TAG_ATTRIBUTES d, tag_attributes r',
'from wwv_flow_step_items',
'where flow_id = :fb_flow_id and DISPLAY_AS = ''BUTTON''',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_template
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(86577503884170242.4009)
,p_lov_name=>'BUTTON_TEMPLATE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(template_name) d, id r',
'from   wwv_flow_button_templates',
'where  flow_id = :fb_flow_id and',
'       (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by upper(template_name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_template_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(287725102195676672.4009)
,p_lov_name=>'BUTTON_TEMPLATE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(287725102195676672.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(287725414983676674.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6A19\6E96')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(287725628953676674.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30DB\30C3\30C8')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(86072317559786247.4009)
,p_lov_name=>'BUTTON_TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''HTML_BUTTON'') d,''TEXT'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''TEMPLATE_DRIVEN'') d, ''TEMPLATE'' r from dual where exists (select 1 from wwv_flow_button_templates where flow_id = :FB_FLOW_ID) ',
'union all',
'select initcap(wwv_flow_lang.system_message(''IMAGE'')) d,''IMAGE'' r from dual order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/cache_mode_page_and_region
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(22602312173782467.4009)
,p_lov_name=>'CACHE_MODE (PAGE AND REGION)'
,p_lov_query=>'.'||wwv_flow_api.id(22602312173782467.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22602526326782467.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7121\52B9')
,p_lov_return_value=>'NOCACHE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22602720414782468.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6709\52B9')
,p_lov_return_value=>'CACHE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22602908361782468.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30E6\30FC\30B6\30FC\5225\306E\30AD\30E3\30C3\30B7\30E5')
,p_lov_return_value=>'USER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(672312620996057364.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30BB\30C3\30B7\30E7\30F3\5225\306E\30AD\30E3\30C3\30B7\30E5')
,p_lov_return_value=>'SESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/caching_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(225840272947805161.4009)
,p_lov_name=>'CACHING_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(225840272947805161.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225840584522805162.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\3059\3079\3066\306E\30E6\30FC\30B6\30FC')
,p_lov_return_value=>'ALL_USERS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225840998538805162.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30E6\30FC\30B6\30FC\5225')
,p_lov_return_value=>'USER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225841321120805163.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30BB\30C3\30B7\30E7\30F3\5225')
,p_lov_return_value=>'SESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/cal_display_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(37322928139444048.4009)
,p_lov_name=>'CAL.DISPLAY_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(37322928139444048.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(37323215840444057.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5217')
,p_lov_return_value=>'COL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(37323417633444059.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E0')
,p_lov_return_value=>'CUS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(37323623070444059.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\8868\793A\5024\306A\3057')
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/calendar_item_link_open_in
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(412002629772063159.4009)
,p_lov_name=>'CALENDAR ITEM LINK OPEN IN'
,p_lov_query=>'.'||wwv_flow_api.id(412002629772063159.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(412002801622063164.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\540C\3058\30A6\30A3\30F3\30C9\30A6')
,p_lov_return_value=>'W'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(412003126365063165.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30DD\30C3\30D7\30A2\30C3\30D7\30FB\30A6\30A3\30F3\30C9\30A6')
,p_lov_return_value=>'P'
);
end;
/
prompt --application/shared_components/user_interface/lovs/calendar_theme_class_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(43619531898960304.4009)
,p_lov_name=>'CALENDAR THEME CLASS ID'
,p_lov_query=>'.'||wwv_flow_api.id(43619531898960304.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43619801874960319.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43621609988960339.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30AB\30EC\30F3\30C0\3001\4EE3\66FF1')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(52331910898784713.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5C0F\3055\3044\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43620000338960319.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E01')
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43620205626960337.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E02')
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43620400113960337.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E03')
,p_lov_return_value=>'6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43620604334960337.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E04')
,p_lov_return_value=>'7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43620830451960338.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E05')
,p_lov_return_value=>'8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43621023248960338.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E06')
,p_lov_return_value=>'9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43621201713960338.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E07')
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43621428586960338.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E08')
,p_lov_return_value=>'11'
);
end;
/
prompt --application/shared_components/user_interface/lovs/calendar_date_format
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(597767214994667976.4009)
,p_lov_name=>'CALENDAR_DATE_FORMAT'
,p_lov_query=>'.'||wwv_flow_api.id(597767214994667976.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(597767532504667980.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\65E5\4ED8\306E\307F')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(597767714309667984.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\65E5\4ED8\3068\6642\9593')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/calendar_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(113156910229994686.4009)
,p_lov_name=>'CALENDAR_TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''CONFIRM.STANDARD_CALENDAR'') d, ''S'' r from dual union all',
'select wwv_flow_lang.system_message(''CONFIRM.PARTIAL_REFRESH_CALENDAR'') d, ''A'' r from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/case_sensitive
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(574890434307383427.4009)
,p_lov_name=>'CASE SENSITIVE'
,p_lov_query=>'.'||wwv_flow_api.id(574890434307383427.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(574890771059383430.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5927/\5C0F\6587\5B57\306E\533A\5225')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_bar_color
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84324431881606062.4009)
,p_lov_name=>'CHART_BAR_COLOR'
,p_lov_query=>'.'||wwv_flow_api.id(84324431881606062.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84324600310606063.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D6\30E9\30C3\30AF')
,p_lov_return_value=>'BLACK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84324819442606063.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30D6\30EB\30FC')
,p_lov_return_value=>'BLUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84325003884606064.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30D6\30E9\30A6\30F3')
,p_lov_return_value=>'BROWN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84325217038606064.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30B0\30EA\30FC\30F3')
,p_lov_return_value=>'GREEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84325407670606064.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30AA\30EC\30F3\30B8')
,p_lov_return_value=>'ORANGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84325609277606064.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30D1\30FC\30D7\30EB')
,p_lov_return_value=>'PURPLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84325828072606065.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30EC\30C3\30C9')
,p_lov_return_value=>'RED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84326022893606065.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\30A4\30A8\30ED\30FC')
,p_lov_return_value=>'YELLOW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_label_opts
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84785018266011049.4009)
,p_lov_name=>'CHART_LABEL_OPTS'
,p_lov_query=>'.'||wwv_flow_api.id(84785018266011049.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84785213250011049.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D0\30D6\30EB\306E\8868\793A')
,p_lov_return_value=>'BUBBLE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84785432162011050.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5024\306E\8868\793A')
,p_lov_return_value=>'VALUE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_link_column
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(193530927208786945.4009)
,p_lov_name=>'CHART_LINK_COLUMN'
,p_lov_query=>'.'||wwv_flow_api.id(193530927208786945.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(193531126012786958.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E0\30FB\30BF\30FC\30B2\30C3\30C8\3078\306E\30EA\30F3\30AF')
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(193531303307786960.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('LINK\5217\306E\5024\3092\4F7F\7528')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_query_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2944917074050416.4009)
,p_lov_name=>'CHART_QUERY_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(2944917074050416.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2945205253050420.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\554F\5408\305B\306E\691C\8A3C\3092\5B9F\884C')
,p_lov_return_value=>'PARSE_CHART_QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2945401126050421.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\691C\8A3C\305B\305A\306B\554F\5408\305B\3092\4FDD\5B58')
,p_lov_return_value=>'IGNORE_CHART_QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_rendering_pg3001
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(209201005699270674.4009)
,p_lov_name=>'CHART_RENDERING_PG3001'
,p_lov_query=>'.'||wwv_flow_api.id(209201005699270674.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(209201306481270675.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Flash\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'FLASH_PREFERRED'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P3000_UI_TYPE_ID'
,p_lov_disp_cond2=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(209201626374270677.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('HTML5\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'SVG_ONLY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_theme
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84770023535917923.4009)
,p_lov_name=>'CHART_THEME'
,p_lov_query=>'.'||wwv_flow_api.id(84770023535917923.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84770217422917924.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Look 1'
,p_lov_return_value=>'RED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84770421612917924.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Look 2'
,p_lov_return_value=>'ARG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84770630757917924.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Look 3'
,p_lov_return_value=>'LOOK_3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_wizard_dial_maxvalue
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(249428101086098299.4009)
,p_lov_name=>'CHART_WIZARD_DIAL_MAXVALUE'
,p_lov_query=>'.'||wwv_flow_api.id(249428101086098299.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(249428318833098301.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'100%'
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(249457015809140458.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'MAX'
,p_lov_return_value=>'MAX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(249457621350142006.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'SUM'
,p_lov_return_value=>'SUM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_show_page_components
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(145937328496747754.4009)
,p_lov_name=>'CHECKBOX SHOW PAGE COMPONENTS'
,p_lov_query=>'.'||wwv_flow_api.id(145937328496747754.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(145937826343747822.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_show_shared_components
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(144512500887046057.4009)
,p_lov_name=>'CHECKBOX SHOW SHARED COMPONENTS'
,p_lov_query=>'.'||wwv_flow_api.id(144512500887046057.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(144512826218046101.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_show_templates
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(152029513350781444.4009)
,p_lov_name=>'CHECKBOX SHOW TEMPLATES'
,p_lov_query=>'.'||wwv_flow_api.id(152029513350781444.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(152029929235781496.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_update_all_strings
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(149088633646846887.4009)
,p_lov_name=>'CHECKBOX_UPDATE_ALL_STRINGS'
,p_lov_query=>'.'||wwv_flow_api.id(149088633646846887.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149088975938846888.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\3053\306E\6587\5B57\5217\306E\3059\3079\3066\306E&P704_COUNT.\4EF6\306E\767A\751F\3092\66F4\65B0\3057\307E\3059')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_yes_noprompt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84718210763776190.4009)
,p_lov_name=>'CHECKBOX_YES_NOPROMPT'
,p_lov_query=>'.'||wwv_flow_api.id(84718210763776190.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84718405875776191.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'&nbsp;'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_y_noprompt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84715102189754797.4009)
,p_lov_name=>'CHECKBOX_Y_NOPROMPT'
,p_lov_query=>'.'||wwv_flow_api.id(84715102189754797.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84715319258754797.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'&nbsp;'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/check_all
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84334521061621823.4009)
,p_lov_name=>'CHECK_ALL'
,p_lov_query=>'.'||wwv_flow_api.id(84334521061621823.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84334731772621824.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'&nbsp;'
,p_lov_return_value=>'CHECK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/choose_chart_type_r
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(5807728495302209.4009)
,p_lov_name=>'CHOOSE_CHART_TYPE_R'
,p_lov_query=>'.'||wwv_flow_api.id(5807728495302209.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5808222675302210.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Flash\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'FLASH5'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:761:&SESSION.:::761,766,719,683,692,799,891:P4016_SOURCE_TYPE:FLASH_CHART5"><img src="#IMAGE_PREFIX#menu/wiz_flash_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5808006503302209.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('HTML\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'HTML'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:SIMPLE_CHART"><img src="#IMAGE_PREFIX#menu/wiz_html_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/choose_page_type_p259
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(21148926321786721.4009)
,p_lov_name=>'CHOOSE_PAGE_TYPE_P259'
,p_lov_query=>'.'||wwv_flow_api.id(21148926321786721.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15949709341550987.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7A7A\767D\30DA\30FC\30B8')
,p_lov_return_value=>'BLANK'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-blank'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''PAGE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21149204648786725.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'REPORT'
,p_lov_template=>'#DISPLAY_VALUE#|native-sql-report'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''PAGE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21149614655786727.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30D5\30A9\30FC\30E0')
,p_lov_return_value=>'FORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''PAGE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27291240406742869.4009)
,p_lov_disp_sequence=>42
,p_lov_disp_value=>unistr('\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB')
,p_lov_return_value=>'MD'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-master-detail'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P259_PAGE_TYPE = ''PAGE'' and',
'wwv_flow_user_interface_dev.supports_feature ( ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID,',
'    p_name              => ''MASTER_DETAIL'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(809524612783878190.4009)
,p_lov_disp_sequence=>45
,p_lov_disp_value=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_lov_return_value=>'PLUGIN'
,p_lov_template=>'#DISPLAY_VALUE#|plugin'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''PAGE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21149424262786726.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'CHART'
,p_lov_template=>'#DISPLAY_VALUE#|native-flash-chart5'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''PAGE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(33699164280412023.4009)
,p_lov_disp_sequence=>55
,p_lov_disp_value=>unistr('\30C0\30C3\30B7\30E5\30DC\30FC\30C9')
,p_lov_return_value=>'DASHBOARD'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-dashboard'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''PAGE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21150022003786727.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'CALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-CALENDAR'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''PAGE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21150200501786727.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30C4\30EA\30FC')
,p_lov_return_value=>'TREE'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-JSTREE'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P259_PAGE_TYPE = ''PAGE'' and (',
'wwv_flow_user_interface_dev.supports_feature ( ',
'       p_user_interface_id => :P259_USER_INTERFACE_ID,',
'       p_name              => ''JSTREE'' )',
'or :P259_SHOW_UNSUPPORTED = ''Y'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21149822778786727.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\30A6\30A3\30B6\30FC\30C9')
,p_lov_return_value=>'WIZARD'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-wizard'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''PAGE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20260312249878297.4009)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\306E\30ED\30FC\30C9')
,p_lov_return_value=>'DATALOAD'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-data-loading'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P259_PAGE_TYPE = ''PAGE'' and (',
'wwv_flow_user_interface_dev.supports_feature ( ',
'       p_user_interface_id => :P259_USER_INTERFACE_ID,',
'       p_name              => ''DATA_LOADING'' )',
'or :P259_SHOW_UNSUPPORTED = ''Y'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3240924233313161.4009)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>unistr('\30B0\30ED\30FC\30D0\30EB\30FB\30DA\30FC\30B8')
,p_lov_return_value=>'GLOBAL'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-global'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_user_interfaces',
' where id             = :P259_USER_INTERFACE_ID',
'   and flow_id        = :FB_FLOW_ID',
'   and global_page_id is null',
'   and :P259_PAGE_TYPE = ''PAGE'''))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(562132756869367211.4009)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>unistr('\30EC\30AC\30B7\30FC\30FB\30DA\30FC\30B8')
,p_lov_return_value=>'LEGACY'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''PAGE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8678021377313480.4009)
,p_lov_disp_sequence=>2000
,p_lov_disp_value=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1')
,p_lov_return_value=>'ACCESSCONTROL'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-access-control'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'nvl(:P259_PAGE_TYPE,''X'') = ''FEATURE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16040025645782722.4009)
,p_lov_disp_sequence=>2000
,p_lov_disp_value=>unistr('\30ED\30B0\30A4\30F3\30FB\30DA\30FC\30B8')
,p_lov_return_value=>'LOGIN'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-login'
,p_lov_disp_cond_type=>'NOT_EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_steps',
'  where page_component_map = 12',
'    and user_interface_id = :P259_USER_INTERFACE_ID',
'    and flow_id =  :FB_FLOW_ID',
'    and security_group_id = :WORKSPACE_ID',
'    and :P259_PAGE_TYPE = ''PAGE'''))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(96683075561618717.4009)
,p_lov_disp_sequence=>2000
,p_lov_disp_value=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'EMAILREPORTING'
,p_lov_template=>'#DISPLAY_VALUE#| icon-envelope'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''FEATURE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(96683337624618719.4009)
,p_lov_disp_sequence=>2000
,p_lov_disp_value=>unistr('\30B8\30E7\30D6\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'JOBREPORTING'
,p_lov_template=>'#DISPLAY_VALUE#| icon-database-object'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_jobs_dev',
' where owner = (select owner',
'                  from wwv_flows',
'                 where id = :FB_FLOW_ID',
'                   and security_group_id = :FLOW_SECURITY_GROUP_ID)',
'   and :P259_PAGE_TYPE = ''FEATURE'''))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(196186932485762243.4009)
,p_lov_disp_sequence=>2000
,p_lov_disp_value=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF')
,p_lov_return_value=>'FEEDBACK'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-feedback'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''FEATURE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(645390692062221400.4009)
,p_lov_disp_sequence=>2000
,p_lov_disp_value=>unistr('\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\9078\629E')
,p_lov_return_value=>'THEMESELECTION'
,p_lov_template=>'#DISPLAY_VALUE#| icon-sc-ui'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''FEATURE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(645391959842230222.4009)
,p_lov_disp_sequence=>2000
,p_lov_disp_value=>unistr('\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'ACTIVITYREPORTING'
,p_lov_template=>'#DISPLAY_VALUE#| icon-util-developer-activity'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''FEATURE'' '
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(662212992416408184.4009)
,p_lov_disp_sequence=>2000
,p_lov_disp_value=>unistr('\69CB\6210\30AA\30D7\30B7\30E7\30F3')
,p_lov_return_value=>'CONFIGOPTIONS'
,p_lov_template=>'#DISPLAY_VALUE#| icon-item-native-checkbox'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''FEATURE'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(662216621039470829.4009)
,p_lov_disp_sequence=>2000
,p_lov_disp_value=>unistr('\60C5\5831\30DA\30FC\30B8')
,p_lov_return_value=>'ABOUTAPP'
,p_lov_template=>'#DISPLAY_VALUE#| icon-region-native-help-text'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P259_PAGE_TYPE = ''FEATURE'''
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_heading_sort
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(113075615286820438.4009)
,p_lov_name=>'COLUMN_HEADING_SORT'
,p_lov_query=>'.'||wwv_flow_api.id(113075615286820438.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113075923766820443.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5217\30D8\30C3\30C0\30FC\30FB\30BD\30FC\30C8\3092\4F7F\7528')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_link_checksum_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(106733132624028207.4009)
,p_lov_name=>'COLUMN_LINK_CHECKSUM_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(106733132624028207.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(106733331539028208.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30EC\30D9\30EB - \3059\3079\3066\306E\30E6\30FC\30B6\30FC\304C\518D\5229\7528\53EF\80FD\306A\30EA\30F3\30AF')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(106733500292028209.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30E6\30FC\30B6\30FC\30FB\30EC\30D9\30EB - \73FE\884C\306E\30E6\30FC\30B6\30FC\304C\518D\5229\7528\53EF\80FD\306A\30EA\30F3\30AF')
,p_lov_return_value=>'2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84700223258656794.4009)
,p_lov_name=>'COLUMN_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(84700223258656794.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84700401229656794.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\554F\5408\305B\5217\304B\3089\5C0E\51FA')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84700609402656795.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6C4E\7528\5217')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_width_units
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(137868513981838198.4009)
,p_lov_name=>'COLUMN_WIDTH_UNITS'
,p_lov_query=>'.'||wwv_flow_api.id(137868513981838198.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(137868804503838258.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5272\5408')
,p_lov_return_value=>'PERCENTAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(137869020870838259.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30DD\30A4\30F3\30C8')
,p_lov_return_value=>'POINTS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/comment_mgt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(131122619933750813.4009)
,p_lov_name=>'COMMENT MGT'
,p_lov_query=>'.'||wwv_flow_api.id(131122619933750813.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131122805830750820.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\3059\3079\3066\306E\30B3\30E1\30F3\30C8\306E\524A\9664')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131123017423750828.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\958B\767A\8005\5225\306B\4F5C\6210\3055\308C\305F\30B3\30E1\30F3\30C8\306E\524A\9664')
,p_lov_return_value=>'DEVELOPER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131123206286750828.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\65E5\4ED8\5225\306E\30B3\30E1\30F3\30C8\306E\524A\9664')
,p_lov_return_value=>'DATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/component_export_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(377667910269420728.4009)
,p_lov_name=>'COMPONENT EXPORT TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select display_name, type_name',
'  from wwv_flow_appl_component_types',
' order by 1'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'TYPE_NAME'
,p_display_column_name=>'DISPLAY_NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'DISPLAY_NAME'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/component_export_types_no_app_attributes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(219174618713592113.4009)
,p_lov_name=>'COMPONENT EXPORT TYPES (NO APP ATTRIBUTES)'
,p_lov_query=>'.'||wwv_flow_api.id(219174618713592113.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27856632677057884.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_lov_return_value=>'PLUGIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27863315726204362.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30C6\30AD\30B9\30C8\30FB\30E1\30C3\30BB\30FC\30B8')
,p_lov_return_value=>'MESSAGES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42344010960230413.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\306E\30ED\30FC\30C9')
,p_lov_return_value=>'DATA LOADING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(68335292197942905.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30E2\30FC\30C8\30FB\30B5\30FC\30D0\30FC')
,p_lov_return_value=>'REMOTE SERVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(68335681892942906.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8CC7\683C\8A3C\660E')
,p_lov_return_value=>'CREDENTIAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88136025596580349.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\554F\5408\305B')
,p_lov_return_value=>'SHARED QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88136305988584229.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8')
,p_lov_return_value=>'REPORT LAYOUT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160795105281345158.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Web\30BD\30FC\30B9')
,p_lov_return_value=>'WEB SOURCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219174814389592127.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30B9\30C8')
,p_lov_return_value=>'LIST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219175013995592129.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
,p_lov_return_value=>'BREADCRUMB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219175232752592129.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DC\30BF\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'BUTTON TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219175403520592129.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'REGION TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219175624120592129.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'LIST TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219175816990592129.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'REPORT TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219176032395592130.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30E9\30D9\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'LABEL TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219176207318592130.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'BREADCRUMB TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219176423240592130.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DD\30C3\30D7\30A2\30C3\30D7LOV\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'POPUP LOV TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219176631734592130.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30AB\30EC\30F3\30C0\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'CALENDAR TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219176806484592131.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30B7\30E7\30FC\30C8\30AB\30C3\30C8')
,p_lov_return_value=>'SHORTCUTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219177013573592131.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'PAGE TEMPLATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219177221576592131.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8')
,p_lov_return_value=>'PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219177427540592131.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30BF\30D6')
,p_lov_return_value=>'TAB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219177604186592131.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'LOV'
,p_lov_return_value=>'LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219177807693592132.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\89AA\30BF\30D6')
,p_lov_return_value=>'PARENT TAB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219178031878592132.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\30FB\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'NAVBAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219178207428592132.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0')
,p_lov_return_value=>'SECURITY SCHEME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219178405025592132.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30C4\30EA\30FC')
,p_lov_return_value=>'TREE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219178614268592132.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9')
,p_lov_return_value=>'APP PROCESS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219178830557592133.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'APP ITEM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219179018777592133.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A08\7B97')
,p_lov_return_value=>'APP COMPUTATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219179226730592133.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30A8\30F3\30C8\30EA')
,p_lov_return_value=>'BREADCRUMB ENTRY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219179423538592133.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Web\30B5\30FC\30D3\30B9')
,p_lov_return_value=>'WEB SERVICE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219179610668592133.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
,p_lov_return_value=>'AUTH SETUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(219179805578592134.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
,p_lov_return_value=>'BUILD OPTION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(683805038458933638.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A')
,p_lov_return_value=>'APP SETTING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(727757877803458898.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30AF\30BB\30B9\5236\5FA1\30ED\30FC\30EB')
,p_lov_return_value=>'APP ACL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/computation_item
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(86610204202293298.4009)
,p_lov_name=>'COMPUTATION_ITEM'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''APPLICATION'')||'': ''||name d, name v',
'from wwv_flow_items',
'where flow_id = :FB_FLOW_ID',
'union all',
'select wwv_flow_lang.system_message(''PAGE'')||'': ''||flow_step_id||'' ''||name d, name v',
'from wwv_flow_step_items',
'where flow_id = :FB_FLOW_ID',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/condition_control_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(179476200494904933.4009)
,p_lov_name=>'CONDITION CONTROL TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(179476200494904933.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(179477608235904943.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30D6\30E9\30F3\30C1')
,p_lov_return_value=>'BRANCH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(179492924267978066.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30DC\30BF\30F3')
,p_lov_return_value=>'BUTTON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(179477001828904942.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\8A08\7B97')
,p_lov_return_value=>'COMPUTATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(179476801795904940.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'ITEM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(179477429719904942.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30D7\30ED\30BB\30B9')
,p_lov_return_value=>'PROCESS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(179476625958904939.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'REGION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(179477227849904942.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\691C\8A3C')
,p_lov_return_value=>'VALIDATION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/condition_check
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(435017812694464482.4009)
,p_lov_name=>'CONDITION_CHECK'
,p_lov_query=>'.'||wwv_flow_api.id(435017812694464482.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(435018014601464492.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30B3\30FC\30C9\3092\691C\8A3C\3057\306A\3044(\5B9F\884C\6642\306B\306E\307F\30B3\30FC\30C9\3092\89E3\6790)\3002')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/confirm_component_removal
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(54171005356999729.4009)
,p_lov_name=>'CONFIRM_COMPONENT_REMOVAL'
,p_lov_query=>'.'||wwv_flow_api.id(54171005356999729.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(54171311988999730.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306F\3044 - \30B3\30F3\30DD\30FC\30CD\30F3\30C8\3092\524A\9664\3057\307E\3059')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/consolidate_template_names_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(94009001670849130.4009)
,p_lov_name=>'CONSOLIDATE_TEMPLATE_NAMES RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select page_plug_template_name d, id',
'from wwv_flow_page_plug_templates',
'where flow_id = :FB_FLOW_ID and ',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''REGION''',
'union all',
'select name d, id ',
'from WWV_FLOW_TEMPLATES ',
'where flow_id = :FB_FLOW_ID and ',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''PAGE''',
'union all',
'select template_name d, id',
'from wwv_flow_field_templates f',
'where ',
'f.flow_id = :FB_FLOW_ID and ',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''LABEL''',
'union all',
'select ',
'l.list_template_name d, l.id',
'from ',
'wwv_flow_list_templates l',
'where ',
'l.flow_id = :FB_FLOW_ID and',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''LIST''',
'union all',
'select name d, id',
'from wwv_flow_cal_templates',
'where flow_id = :FB_FLOW_ID and',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''CALENDAR''',
'union all',
'select name d, id',
'from wwv_flow_menu_templates',
'where flow_id = :FB_FLOW_ID and',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''MENU''',
'union all',
'select template_name d, id',
'from WWV_FLOW_BUTTON_TEMPLATES',
'where flow_id = :FB_FLOW_ID and',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''BUTTON''',
'union all',
'select ''* ''||wwv_flow_lang.system_message(''HTML_BUTTON'') d, -1 id',
'from dual',
'where :P708_TEMPLATE_TYPE = ''BUTTON''',
'union all',
'select ROW_TEMPLATE_NAME d, id',
'from WWV_FLOW_ROW_TEMPLATES',
'where flow_id = :FB_FLOW_ID and',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''REPORT''',
'union all',
'select ''* ''||wwv_flow_lang.system_message(''REGION_TEMPLATES_NO_TEMPLATE'') d, -1 id',
'from dual',
'where :P708_TEMPLATE_TYPE in (''PAGE'',''REGION'')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/content_delivery_network
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(16362507680404890.4009)
,p_lov_name=>'CONTENT DELIVERY NETWORK'
,p_lov_query=>'.'||wwv_flow_api.id(16362507680404890.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16362719475404893.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Google'
,p_lov_return_value=>'GOOGLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16362912968404893.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Microsoft'
,p_lov_return_value=>'MICROSOFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16363119553404893.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'jQuery'
,p_lov_return_value=>'JQUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/content_disposition
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(137375920403903467.4009)
,p_lov_name=>'CONTENT_DISPOSITION'
,p_lov_query=>'.'||wwv_flow_api.id(137375920403903467.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(137376221863903468.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB')
,p_lov_return_value=>'ATTACHMENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(137376416435903468.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30A4\30F3\30E9\30A4\30F3')
,p_lov_return_value=>'INLINE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_list_option
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(231048823449529621.4009)
,p_lov_name=>'COPY LIST OPTION'
,p_lov_query=>'.'||wwv_flow_api.id(231048823449529621.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(231049006115529624.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30EA\30B9\30C8')
,p_lov_return_value=>'SAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(231049208911529628.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5225\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30EA\30B9\30C8')
,p_lov_return_value=>'DIFF'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_lists
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(10919919806296646.4009)
,p_lov_name=>'COPY LISTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id ',
'  from wwv_flow_lists ',
' where flow_id = v(''FB_FLOW_ID'') ',
'   and id <> :P477_COPY_LIST_FROM',
'   and nvl(list_type,''STATIC'') = ''STATIC''',
' order by 1',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_page_option
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(200992128346618114.4009)
,p_lov_name=>'COPY_PAGE_OPTION'
,p_lov_query=>'.'||wwv_flow_api.id(200992128346618114.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(200992325093618118.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DA\30FC\30B8')
,p_lov_return_value=>'SAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(200992505592618121.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5225\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DA\30FC\30B8')
,p_lov_return_value=>'DIFF'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_sc_option
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(201061511357162008.4009)
,p_lov_name=>'COPY_SC_OPTION'
,p_lov_query=>'.'||wwv_flow_api.id(201061511357162008.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201061731765162010.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30B3\30D4\30FC\3057\306A\3044')
,p_lov_return_value=>'NO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201061913763162012.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30B3\30D4\30FC')
,p_lov_return_value=>'COPY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201062131688162012.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\65E2\5B58\306E\3082\306E\3092\4F7F\7528')
,p_lov_return_value=>'EXISTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_application_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(59753909083040661.4009)
,p_lov_name=>'CREATE APPLICATION OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(59753909083040661.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40660315892684513.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65B0\898F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_lov_return_value=>'DBAPP'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-app-builder'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84640459791812785.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\30B9\30D7\30EC\30C3\30C9\30B7\30FC\30C8\304B\3089')
,p_lov_return_value=>'SPREADSHEET'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-create-app-websheet'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40660629052688301.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Web\30B7\30FC\30C8')
,p_lov_return_value=>'WEBSHEET'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-create-app-websheet'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40660901478689821.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\751F\7523\6027\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_lov_return_value=>'PKGAPP'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-create-app-pkg-apps'
,p_lov_disp_cond_type=>'FUNCTION_BODY'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'    for c1 in (select 1 from wwv_flow_companies w',
'                     where nvl(w.ALLOW_PACKAGED_APP_INS_YN,''Y'') = ''Y'' ',
'                         and w.PROVISIONING_COMPANY_ID = :flow_security_group_id) ',
'    loop',
'        return',
'            ( wwv_flow_authorization.is_authorized_developer(',
'                  p_developer_authorization => ''ADMIN''',
'            )',
'           or wwv_flow_authorization.is_authorized_developer(',
'                    p_developer_authorization => ''EDIT''',
'           ) and wwv_flow_platform.get_preference(''PKG_APP_ENABLED'') = ''Y'' );',
'',
'    end loop;',
'    return false;',
'end;'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_application_page_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(139812219112455338.4009)
,p_lov_name=>'CREATE APPLICATION PAGE TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(139812219112455338.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139812423391455342.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7A7A\767D\30DA\30FC\30B8\3092\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\8FFD\52A0')
,p_lov_return_value=>'BLANK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139813830194458580.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\306E\8FFD\52A0')
,p_lov_return_value=>'REPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(386128979761969541.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30D5\30ED\30FC\8868\30EC\30DD\30FC\30C8\306E\8FFD\52A0')
,p_lov_return_value=>'REFLOWTABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(386129452191973929.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5217\5207\66FF\3048\30EC\30DD\30FC\30C8\306E\8FFD\52A0')
,p_lov_return_value=>'COLUMNTOGGLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139812618398455343.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('2\30DA\30FC\30B8\76EE\304C\7DE8\96C6\30D5\30A9\30FC\30E0\306E\30EC\30DD\30FC\30C8\306E\8FFD\52A0')
,p_lov_return_value=>'REPORTANDFORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(228985906117785632.4009)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('2\30DA\30FC\30B8\76EE\304C\7DE8\96C6\30D5\30A9\30FC\30E0\306E\30EA\30B9\30C8\30FB\30D3\30E5\30FC\306E\8FFD\52A0')
,p_lov_return_value=>'LISTVIEWANDFORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139812820281455343.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\7DE8\96C6\53EF\80FD\5BFE\8A71\30B0\30EA\30C3\30C9\306E\8FFD\52A0')
,p_lov_return_value=>'TABULARFORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139813027803455343.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\633F\5165\3001\66F4\65B0\304A\3088\3073\524A\9664\6A5F\80FD\4ED8\304D\30D5\30A9\30FC\30E0\306E\8FFD\52A0')
,p_lov_return_value=>'FORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(111750431837325937.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('1\30DA\30FC\30B8\306E\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\306E\8FFD\52A0')
,p_lov_return_value=>'MASTERDETAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615632927102875004.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30C1\30E3\30FC\30C8\306E\8FFD\52A0')
,p_lov_return_value=>'CHART'
,p_lov_disp_cond=>'(:APP_USER = ''HILARY'')'
,p_lov_disp_cond2=>'HILARY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(236338032309717022.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\30FB\30D3\30E5\30FC\306E\8FFD\52A0')
,p_lov_return_value=>'LISTVIEW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_cal_type_page_wizard
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(202761521943494724.4009)
,p_lov_name=>'CREATE CAL TYPE PAGE WIZARD'
,p_lov_query=>'.'||wwv_flow_api.id(202761521943494724.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(202761815463494728.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7C21\6613\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'EASY_CALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4785:&SESSION.::::P4700_SELECT_REPORT_TYPE:EASY_CALENDAR"><img src="#IMAGE_PREFIX#htmldb/builder/calendar_easy_xl.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" /></a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(202762012277494728.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('SQL\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'CALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4785:&SESSION.::::P4700_SELECT_REPORT_TYPE:CALENDAR"><img src="#IMAGE_PREFIX#htmldb/builder/calendar_sql_xl.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_cal_type2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(637546843740095966.4009)
,p_lov_name=>'CREATE CAL TYPE2'
,p_lov_query=>'.'||wwv_flow_api.id(637546843740095966.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(637547104132095967.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30EC\30AC\30B7\30FC\30FB\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'CALENDAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(637547448261095970.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'CSSCALENDAR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_install_script_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4579300425024699.4009)
,p_lov_name=>'CREATE INSTALL SCRIPT OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(4579300425024699.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4579506061024700.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6700\521D\304B\3089\4F5C\6210')
,p_lov_return_value=>'SCRATCH'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-blank'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4579908206024701.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30D5\30A1\30A4\30EB\304B\3089\4F5C\6210')
,p_lov_return_value=>'FILE'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-blank'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(534084776604619224.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\304B\3089\4F5C\6210')
,p_lov_return_value=>'DB'
,p_lov_template=>'#DISPLAY_VALUE#| icon-database-object'
,p_lov_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_NOT_IN_COLON_DELIMITED_LIST'
,p_lov_disp_cond=>'P850_MODE'
,p_lov_disp_cond2=>'UPGRADE:DEINSTALL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_jstree_from_table_list
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(472039530345633735.4009)
,p_lov_name=>'CREATE JSTREE FROM TABLE LIST'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name_esc,',
'       object_name',
'  from wwv_flow_tables_views_dev',
' where owner = :P913_OWNER'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_multiple_items_p256
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(162048107844243840.4009)
,p_lov_name=>'CREATE MULTIPLE ITEMS P256'
,p_lov_query=>'.'||wwv_flow_api.id(162048107844243840.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162048426183243882.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30C6\30AD\30B9\30C8\30FB\30D5\30A3\30FC\30EB\30C9')
,p_lov_return_value=>'TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162048628552243882.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30C6\30AD\30B9\30C8\9818\57DF')
,p_lov_return_value=>'TEXTAREA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162048825522243882.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30C1\30A7\30C3\30AF\30DC\30C3\30AF\30B9')
,p_lov_return_value=>'CHECKBOX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162049013715243883.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30E9\30B8\30AA\30FB\30B0\30EB\30FC\30D7')
,p_lov_return_value=>'RADIOGROUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162049424562243883.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\975E\8868\793A')
,p_lov_return_value=>'HIDDEN_PROTECTED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_tree_from_table_list
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(94457102341894843.4009)
,p_lov_name=>'CREATE TREE FROM TABLE LIST'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name_esc,',
'       object_name',
'  from wwv_flow_tables_views_dev',
' where owner = :F4000_P112_OWNER'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_app_auth_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(175155625648607577.4009)
,p_lov_name=>'CREATE.APP.AUTH.OPTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, v from (',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.CLOUD_IDM'') d ,''CLOUD_IDM'' v from dual',
'where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'')d ,:PRODUCT_NAME v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.SSO'') d ,''SSO'' v from dual',
'where wwv_flow_authentication_dev.can_use_sso_yn = ''Y''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'') d,''DBACCOUNT'' v',
'from dual',
'where wwv_flow_authentication_dev.get_internal_authentication <> ''CLOUD_IDM''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.NO_AUTH'') d,''DATABASE'' v from dual',
'union all',
'select flow_id||'' - ''||wwv_flow_escape.html(name) d, wwv_flow_escape.html(name) as v',
'  from wwv_flow_authentications',
' where scheme_type not in ( ''NATIVE_APEX_ACCOUNTS'',',
'                            ''NATIVE_CLOUD_IDM'',',
'                            ''NATIVE_IAS_SSO'',',
'                            ''NATIVE_DAD'',',
'                            ''NATIVE_DB_ACCOUNTS''',
'                          )',
'   and flow_id = :P433_APPLICATION',
'   and instr(:P433_COPY_OPTIONS||''.'',''AUTHENTICATION'') > 0',
'   and :APP_PAGE_ID <> 800 /* don''t use this part if used on page 800 */',
')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_cal_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(16354319751573808.4009)
,p_lov_name=>'CREATE.CAL.TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(16354319751573808.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(389128299383656476.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'CSSCALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-CSS-CALENDAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16354825012573816.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EC\30AC\30B7\30FC\30FB\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'CALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-CALENDAR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_flow_auth_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(52256503410339865.4009)
,p_lov_name=>'CREATE.FLOW.AUTH.OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(52256503410339865.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(52257006525339871.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Application Express\8A8D\8A3C')
,p_lov_return_value=>'HTML DB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(52257200649339871.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\8A8D\8A3C\306A\3057')
,p_lov_return_value=>'DATABASE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_region_chart_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(59940502744006894.4009)
,p_lov_name=>'CREATE.REGION.CHART.TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(59940502744006894.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(59940825061006894.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('HTML\30C1\30E3\30FC\30C8<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:SIMPLE_CHART"><img src="#IMAGE_PREFIX#wwv_example_chart.gif" alt=HTML\30C1\30E3\30FC\30C8" height="115" width="140"></a>')
,p_lov_return_value=>'SIMPLE_CHART'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_region_report_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(59918611599848626.4009)
,p_lov_name=>'CREATE.REGION.REPORT.TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(59918611599848626.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(76763631583167906.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'IRR'
,p_lov_template=>'#DISPLAY_VALUE#|native-ir'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P181_REGION_TYPE = ''REPORT''',
'and wwv_flow_user_interface_dev.supports_feature ( ',
'        p_user_interface_id => :P259_USER_INTERFACE_ID,',
'        p_name              => ''INTERACTIVE_REPORT'' )',
''))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(59918906003848628.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\30AF\30E9\30B7\30C3\30AF\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'REPORT'
,p_lov_template=>'#DISPLAY_VALUE#|native-sql-report'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_user_interface_dev.supports_feature ( ',
'           p_user_interface_id => :P259_USER_INTERFACE_ID,',
'           p_name              => ''CLASSIC_REPORT'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(10802610245671765.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\30FB\30D3\30E5\30FC')
,p_lov_return_value=>'LISTVIEW'
,p_lov_template=>'#DISPLAY_VALUE#|native-jqm-list-view'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_user_interface_dev.supports_feature ( ',
'           p_user_interface_id => :P259_USER_INTERFACE_ID,',
'           p_name              => ''JQM_LIST_VIEW'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(653899240632953552.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\5217\5207\66FF\3048\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'COLUMNTOGGLE'
,p_lov_template=>'#DISPLAY_VALUE#|native-jqm-column-toggle'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_user_interface_dev.supports_feature ( ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID,',
'    p_name              => ''JQM_COLUMN_TOGGLE'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(360378100712086268.4009)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\30EA\30D5\30ED\30FC\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'REFLOW'
,p_lov_template=>'#DISPLAY_VALUE#|native-jqm-reflow'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_user_interface_dev.supports_feature ( ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID,',
'    p_name              => ''JQM_REFLOW_TABLE'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(32036408472068130.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Web\30B5\30FC\30D3\30B9\306E\7D50\679C')
,p_lov_return_value=>'WEBSERVICE'
,p_lov_template=>'#DISPLAY_VALUE#|native-sql-report'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_region_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(59797407819674174.4009)
,p_lov_name=>'CREATE.REGION.TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(59797407819674174.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(59797715581674175.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\9759\7684\30B3\30F3\30C6\30F3\30C4')
,p_lov_return_value=>'BLANK'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16128700870012129.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8907\6570\306E\9759\7684\30B3\30F3\30C6\30F3\30C4')
,p_lov_return_value=>'MULTIPLE'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(59798114152674175.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'REPORT'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-SQL-REPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25496822963244246.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30D5\30A9\30FC\30E0')
,p_lov_return_value=>'FORM'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(33173307277765071.4009)
,p_lov_disp_sequence=>45
,p_lov_disp_value=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_lov_return_value=>'PLUGIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(59798331043674176.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'CHART'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-FLASH-CHART5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184723416342451920.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30DE\30C3\30D7\30FB\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'MAP'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-FLASH-MAP'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_user_interface_dev.supports_feature ( ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID,',
'    p_name              => ''CHART_MAP'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5427307791424375.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30C4\30EA\30FC')
,p_lov_return_value=>'JSTREE'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-JSTREE'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_user_interface_dev.supports_feature ( ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID,',
'    p_name              => ''JSTREE'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16271616260345715.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'CALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-CALENDAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(59798531129674176.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\30EA\30B9\30C8')
,p_lov_return_value=>'LIST'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-LIST'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from WWV_FLOW_LISTS where flow_id = :fb_flow_id'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(59798712525674176.4009)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
,p_lov_return_value=>'MENU'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-BREADCRUMB'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from WWV_FLOW_MENUS where flow_id = :fb_flow_id and 1 = 2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16132517193045207.4009)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
,p_lov_return_value=>'MENUREGION'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-BREADCRUMB'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from WWV_FLOW_MENUS where flow_id = :fb_flow_id'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(59798906900674177.4009)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>unistr('PL/SQL\52D5\7684\30B3\30F3\30C6\30F3\30C4')
,p_lov_return_value=>'PLSQL_PROCEDURE'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-PLSQL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5429217488427188.4009)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>'URL'
,p_lov_return_value=>'URL'
,p_lov_template=>'#DISPLAY_VALUE#|native-url'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22347623933545778.4009)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\8868\793A\30BB\30EC\30AF\30BF')
,p_lov_return_value=>'RDS'
,p_lov_template=>'#DISPLAY_VALUE#|native-display-selector'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38870528920787636.4009)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>unistr('\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8')
,p_lov_return_value=>'HELP_TEXT'
,p_lov_template=>'#DISPLAY_VALUE#|native-help-text'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_tabs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84948109242907300.4009)
,p_lov_name=>'CREATE.TABS'
,p_lov_query=>'.'||wwv_flow_api.id(84948109242907300.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84948313600907300.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30BF\30D6\306A\3057')
,p_lov_return_value=>'NO_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84948509310907301.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('1\30EC\30D9\30EB\306E\30BF\30D6')
,p_lov_return_value=>'SINGLE_LEVEL_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84948706961907301.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('2\30EC\30D9\30EB\306E\30BF\30D6')
,p_lov_return_value=>'TWO_LEVEL_TABS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_template_opts
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88108326304250090.4009)
,p_lov_name=>'CREATE.TEMPLATE.OPTS'
,p_lov_query=>'.'||wwv_flow_api.id(88108326304250090.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88108531928250090.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('&PRODUCT_NAME.\30EA\30DD\30B8\30C8\30EA\304B\30891\3064\9078\629E')
,p_lov_return_value=>'DEFAULT'
,p_lov_disp_cond_type=>'NEVER'
,p_lov_disp_cond=>'161'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88108720351250091.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6700\521D\304B\3089')
,p_lov_return_value=>'BLANK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88108928823250091.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\65E2\5B58\306E\30C6\30F3\30D7\30EC\30FC\30C8\306E\30B3\30D4\30FC\3068\3057\3066')
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_app_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(238931611476537918.4009)
,p_lov_name=>'CREATE_APP_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(238931611476537918.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(238931830914537923.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6700\521D\304B\3089\958B\59CB')
,p_lov_return_value=>'SCRATCH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24117720307079483.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30DB\30FC\30E0\30DA\30FC\30B8\3092\542B\3081\308B')
,p_lov_return_value=>'INCLUDE_HOME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(238932009935537927.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\4EE5\524D\4F5C\6210\3057\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E2\30C7\30EB\3092\4F7F\7528')
,p_lov_return_value=>'MODEL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_button_loc
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84893616038549667.4009)
,p_lov_name=>'CREATE_BUTTON_LOC'
,p_lov_query=>'.'||wwv_flow_api.id(84893616038549667.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84894000323549667.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\4F4D\7F6E\306B\30DC\30BF\30F3\306E\4F5C\6210')
,p_lov_return_value=>'REGION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84893831137549667.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\3053\306E\30EA\30FC\30B8\30E7\30F3\30FB\30A2\30A4\30C6\30E0\3067\8868\793A\3055\308C\308B\30DC\30BF\30F3\306E\4F5C\6210')
,p_lov_return_value=>'ITEM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_edit_build_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84363508688675017.4009)
,p_lov_name=>'CREATE_EDIT_BUILD_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(84363508688675017.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84363715344675017.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\3059\3079\3066\306E\30AA\30D7\30B7\30E7\30F3')
,p_lov_return_value=>'ALL_OPTIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84363903362675018.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\9664\5916\3055\308C\308B\30AA\30D7\30B7\30E7\30F3')
,p_lov_return_value=>'EXCLUDED_OPTIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84364127083675018.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\542B\307E\308C\308B\30AA\30D7\30B7\30E7\30F3')
,p_lov_return_value=>'INCLUDED_OPTIONS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_page_wiz_report_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(229526604906633214.4009)
,p_lov_name=>'CREATE_PAGE_WIZ_REPORT_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(229526604906633214.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(229526903566633217.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'INTERACTIVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(229527314006633219.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30AF\30E9\30B7\30C3\30AF\30FB\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'CLASSIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(229527755815633220.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Web\30B5\30FC\30D3\30B9\306E\30EC\30DD\30FC\30C8')
,p_lov_return_value=>'WEBSERVICE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(246582799020000524.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5BFE\8A71\30B0\30EA\30C3\30C9')
,p_lov_return_value=>'GRID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2492748530737796.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30D5\30A1\30BB\30C3\30C8\691C\7D22')
,p_lov_return_value=>'FACETED_SEARCH'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_ws_auth_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(460639712672013129.4009)
,p_lov_name=>'CREATE_WS_AUTH_OPTIONS'
,p_reference_id=>174618728240220381.4009
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, v from (',
'select ',
'  :product_name||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/admin_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d ,''HTML DB'' v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.NO_AUTH'')||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/opendoor_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DATABASE'' v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'')||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/dbauth_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DBACCOUNT'' v from dual)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/credentials_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(154078822199034715.4009)
,p_lov_name=>'CREDENTIALS_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(154078822199034715.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(154079142215034718.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\57FA\672C\8A8D\8A3C')
,p_lov_return_value=>'BASIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(154079510909034719.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('OAuth2\30AF\30E9\30A4\30A2\30F3\30C8\8CC7\683C\8A3C\660E\30D5\30ED\30FC')
,p_lov_return_value=>'OAUTH2_CLIENT_CREDENTIALS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(549452051899386464.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('JSON Web\30C8\30FC\30AF\30F3')
,p_lov_return_value=>'JWT'
,p_required_patch=>wwv_flow_api.id(170786031904296885.4009)
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1341457865820980.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Oracle Cloud Infrastructure (OCI)'
,p_lov_return_value=>'OCI'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'sys.dbms_db_version.version >= 18'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1701546541659999.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\8A3C\660E\66F8/\79D8\5BC6\30AD\30FC\306E\30DA\30A2')
,p_lov_return_value=>'CERTIFICATE_PAIR'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_platform.get_preference(''SAML_ENABLED'')=''Y'''
);
end;
/
prompt --application/shared_components/user_interface/lovs/css_categories
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2672426264055159.4009)
,p_lov_name=>'CSS CATEGORIES'
,p_lov_query=>'.'||wwv_flow_api.id(2672426264055159.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2672601779055159.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7D76\5BFE\30B5\30A4\30BA')
,p_lov_return_value=>'ABSOLUTE SIZES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2672821707055159.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\76F8\5BFE\30B5\30A4\30BA')
,p_lov_return_value=>'RELATIVE SIZES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2686105588181625.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30F3\30AB\30FC\30FB\30BF\30B0')
,p_lov_return_value=>'ANCHOR TAGS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/current_page_only
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(574892035638384809.4009)
,p_lov_name=>'CURRENT PAGE ONLY'
,p_lov_query=>'.'||wwv_flow_api.id(574892035638384809.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(574892359277384813.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\73FE\5728\306E\30DA\30FC\30B8\306E\307F')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/customizable_opts
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84780904844988257.4009)
,p_lov_name=>'CUSTOMIZABLE_OPTS'
,p_lov_query=>'.'||wwv_flow_api.id(84780904844988257.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84781129653988258.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30C7\30D5\30A9\30EB\30C8\3067\30AB\30B9\30BF\30DE\30A4\30BA\53EF\80FD\304A\3088\3073\975E\8868\793A')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84781315535988258.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30C7\30D5\30A9\30EB\30C8\3067\30AB\30B9\30BF\30DE\30A4\30BA\53EF\80FD\304A\3088\3073\8868\793A')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84781523668988259.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30A8\30F3\30C9\30E6\30FC\30B6\30FC\3067\306F\30AB\30B9\30BF\30DE\30A4\30BA\4E0D\53EF')
,p_lov_return_value=>'0'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dashboard_chart_aggregate
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(657384343573981564.4009)
,p_lov_name=>'DASHBOARD_CHART_AGGREGATE'
,p_lov_query=>'.'||wwv_flow_api.id(657384343573981564.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(657384641982981565.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5217\5024')
,p_lov_return_value=>'COLVALUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(657385056655981565.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5408\8A08')
,p_lov_return_value=>'SUM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(657385482368981565.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\4EF6\6570')
,p_lov_return_value=>'COUNT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dashboard_chart_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(657346995959744232.4009)
,p_lov_name=>'DASHBOARD_CHART_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(657346995959744232.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(657347261583744232.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9762')
,p_lov_return_value=>'area'
,p_lov_template=>'<span class="a-Icon icon-region-chart-area" aria-hidden="true"></span><span class="u-VisuallyHidden">#DISPLAY_VALUE#</span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(657347677252744233.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\68D2')
,p_lov_return_value=>'bar'
,p_lov_template=>'<span class="a-Icon icon-region-chart-bar" aria-hidden="true"></span><span class="u-VisuallyHidden">#DISPLAY_VALUE#</span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(657350049661744234.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\6298\308C\7DDA')
,p_lov_return_value=>'line'
,p_lov_template=>'<span class="a-Icon icon-region-chart-line" aria-hidden="true"></span><span class="u-VisuallyHidden">#DISPLAY_VALUE#</span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(657350886473744235.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5186')
,p_lov_return_value=>'pie'
,p_lov_template=>'<span class="a-Icon icon-region-chart-pie" aria-hidden="true"></span><span class="u-VisuallyHidden">#DISPLAY_VALUE#</span>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_case_sensitivity_option
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(15543021487067885.4009)
,p_lov_name=>'DATA LOAD CASE SENSITIVITY OPTION'
,p_lov_query=>'.'||wwv_flow_api.id(15543021487067885.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15543516355067889.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\3044\3044\3048')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15543328204067888.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\306F\3044')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_skip_validation
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(380391855980609161.4009)
,p_lov_name=>'DATA LOAD SKIP VALIDATION'
,p_lov_query=>'.'||wwv_flow_api.id(380391855980609161.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(380392176743609168.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\3044\3044\3048')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(380392454037609170.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\306F\3044')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_table_names
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(371957315073004609.4009)
,p_lov_name=>'DATA LOAD TABLE NAMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select TABLE_NAME display_value, TABLE_NAME return_value ',
'from WWV_FLOW_LOAD_TABLES',
'where name = :P1801_NAME order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_loading_rules_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(141003727830690827.4009)
,p_lov_name=>'DATA LOADING RULES TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(141003727830690827.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(141004022216690828.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5927\6587\5B57\306B\3059\308B')
,p_lov_return_value=>'TO_UPPER_CASE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(141004200887690829.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5C0F\6587\5B57\306B\3059\308B')
,p_lov_return_value=>'TO_LOWER_CASE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(141004413247690829.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\7F6E\63DB')
,p_lov_return_value=>'REPLACE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(141004630986690829.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5207\6368\3066')
,p_lov_return_value=>'TRIM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(675452628395802315.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\5DE6\30B9\30DA\30FC\30B9\524A\9664')
,p_lov_return_value=>'LTRIM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(675463400475803720.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\53F3\30B9\30DA\30FC\30B9\524A\9664')
,p_lov_return_value=>'RTRIM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(141004815818690829.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\5358\4E00\306E\30B9\30DA\30FC\30B9')
,p_lov_return_value=>'SINGLE_WHITESPACES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(141005014039690829.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('PL/SQL\5F0F')
,p_lov_return_value=>'PLSQL_EXPRESSION'
,p_required_patch=>-wwv_flow_api.id(170786031904296885.4009)
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(141005230162690829.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\6B63\898F\8868\73FE')
,p_lov_return_value=>'REGULAR_EXPRESSION'
,p_required_patch=>wwv_flow_api.id(170786031904296885.4009)
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(13800125404733346.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('PL/SQL\30D5\30A1\30F3\30AF\30B7\30E7\30F3\672C\4F53')
,p_lov_return_value=>'PLSQL_FUNCTION_BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(13800313005733348.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('SQL\554F\5408\305B(\5358\4E00\306E\5024\3092\8FD4\3059)')
,p_lov_return_value=>'SQL_QUERY_SINGLE_VALUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(13800507980733349.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('SQL\554F\5408\305B(\30B3\30ED\30F3\533A\5207\308A\306E\5024\3092\8FD4\3059)')
,p_lov_return_value=>'SQL_QUERY_SEMI_COLON'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_loading_tables_list
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(15574010985556882.4009)
,p_lov_name=>'DATA LOADING TABLES LIST'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select TABLE_NAME display_value, ID return_value ',
'from WWV_FLOW_LOAD_TABLES',
'where flow_id = :fb_flow_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/database_action_button_lov
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(147433904650386326.4009)
,p_lov_name=>'DATABASE_ACTION BUTTON LOV'
,p_lov_query=>'.'||wwv_flow_api.id(147433904650386326.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(147434227021386334.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('SQL INSERT\64CD\4F5C')
,p_lov_return_value=>'INSERT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(147434419098386340.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('SQL UPDATE\64CD\4F5C')
,p_lov_return_value=>'UPDATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(147434607832386340.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('SQL DELETE\64CD\4F5C')
,p_lov_return_value=>'DELETE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_profile_col_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(242159593404725778.4009)
,p_lov_name=>'DATA_PROFILE_COL_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(242159593404725778.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(242159828107725785.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30C7\30FC\30BF')
,p_lov_return_value=>'DATA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(242160239919725788.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5C0E\51FA')
,p_lov_return_value=>'DERIVED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_profile_data_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(225929676126476839.4009)
,p_lov_name=>'DATA_PROFILE_DATA_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(225929676126476839.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225929903268476840.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Varchar2'
,p_lov_return_value=>'VARCHAR2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225930368549476840.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6570\5024')
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225930744436476841.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\65E5\4ED8')
,p_lov_return_value=>'DATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225931138522476841.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30BF\30A4\30E0\30B9\30BF\30F3\30D7')
,p_lov_return_value=>'TIMESTAMP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225931522008476841.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30ED\30FC\30AB\30EB\30FB\30BF\30A4\30E0\30BE\30FC\30F3\4ED8\304D\30BF\30A4\30E0\30B9\30BF\30F3\30D7')
,p_lov_return_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225931923485476841.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30BF\30A4\30E0\30BE\30FC\30F3\4ED8\304D\30BF\30A4\30E0\30B9\30BF\30F3\30D7')
,p_lov_return_value=>'TIMESTAMP WITH TIME ZONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(249232043458816550.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'CLOB'
,p_lov_return_value=>'CLOB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(263573975956906615.4009)
,p_lov_disp_sequence=>26
,p_lov_disp_value=>unistr('\30C9\30AD\30E5\30E1\30F3\30C8\30FB\30BB\30AF\30B7\30E7\30F3')
,p_lov_return_value=>'DOCUMENT_FRAGMENT'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_utilities.db_version_is_at_least(''12.1'')'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_profile_date_format_masks
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(225940310284555905.4009)
,p_lov_name=>'DATA_PROFILE_DATE_FORMAT_MASKS'
,p_lov_query=>'.'||wwv_flow_api.id(225940310284555905.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225940649643555906.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'2016-12-01'
,p_lov_return_value=>'YYYY-MM-DD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225941017139555907.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'2016-12-01T20:00:00'
,p_lov_return_value=>'YYYY-MM-DD"T"HH24:MI:SS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225941432549555907.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'2016-12-02T20:00:00.516'
,p_lov_return_value=>'YYYY-MM-DD"T"HH24:MI:SS.FF3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(225941811998555907.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'2016-12-02T20:00:00.516Z'
,p_lov_return_value=>'YYYY-MM-DD"T"HH24:MI:SS.FF3TZR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/date_format_lov
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(460719917105668922.4009)
,p_lov_name=>'DATE_FORMAT_LOV'
,p_reference_id=>460140315153255042.4009
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'  from wwv_flow_format_masks',
' where t=''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/days_of_the_week
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(185376216434149048.4009)
,p_lov_name=>'DAYS OF THE WEEK'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,r from (',
'   select to_char(to_date(''19721105'',''YYYYMMDD''),''Day'') d,19721105 r from dual',
'   union all',
'   select to_char(to_date(''19721106'',''YYYYMMDD''),''Day''),19721106 from dual',
'   union all',
'   select to_char(to_date(''19721107'',''YYYYMMDD''),''Day''),19721107 from dual',
'   union all',
'   select to_char(to_date(''19721108'',''YYYYMMDD''),''Day''),19721108 from dual',
'   union all',
'   select to_char(to_date(''19721109'',''YYYYMMDD''),''Day''),19721109 from dual',
'   union all',
'   select to_char(to_date(''19721110'',''YYYYMMDD''),''Day''),19721110 from dual',
'   union all',
'   select to_char(to_date(''19721111'',''YYYYMMDD''),''Day''),19721111 from dual',
')',
'order by 2 '))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/db_column_items
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(156839505926131127.4009)
,p_lov_name=>'DB.COLUMN.ITEMS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name a,name b',
'',
'from wwv_flow_step_items',
'',
'where flow_id = :fb_flow_id',
'',
'and flow_step_id = :FB_FLOW_PAGE_ID',
'',
'and security_group_id = :flow_security_group_id',
'',
'and source_type = ''DB_COLUMN'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/deep_linking
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(34319101845334424.4009)
,p_lov_name=>'DEEP_LINKING'
,p_lov_query=>'.'||wwv_flow_api.id(34319101845334424.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34319403683334426.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6709\52B9')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34319716050334427.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\7121\52B9')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/default_error_display_location
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(191207805708435328.4009)
,p_lov_name=>'DEFAULT_ERROR_DISPLAY_LOCATION'
,p_lov_query=>'.'||wwv_flow_api.id(191207805708435328.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(191208023843435360.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30D5\30A3\30FC\30EB\30C9\304A\3088\3073\901A\77E5\3067\30A4\30F3\30E9\30A4\30F3\8868\793A')
,p_lov_return_value=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(191208231710435370.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30D5\30A3\30FC\30EB\30C9\3067\30A4\30F3\30E9\30A4\30F3\8868\793A')
,p_lov_return_value=>'INLINE_WITH_FIELD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(191208402756435370.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\901A\77E5\3067\30A4\30F3\30E9\30A4\30F3\8868\793A')
,p_lov_return_value=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/deinstall_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(17717826931614902.4009)
,p_lov_name=>'DEINSTALL OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(17717826931614902.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17718426349614906.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5B9F\884C\3057\306A\3044')
,p_lov_return_value=>'NOT_ACCEPTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(37670813248983399.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5B9A\7FA9\306E\524A\9664')
,p_lov_return_value=>'DROP_APP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17718232517614906.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\306E\524A\9664')
,p_lov_return_value=>'DROP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17718011536614905.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\304A\3088\3073\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5B9A\7FA9\306E\524A\9664')
,p_lov_return_value=>'DROP_AND_DELETE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/delete_application_actions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(15857613201776764.4009)
,p_lov_name=>'DELETE APPLICATION ACTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(15857613201776764.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15857829844776765.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\524A\9664\30B9\30AF\30EA\30D7\30C8\306E\5B9F\884C(\63A8\5968)')
,p_lov_return_value=>'SCRIPT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15858025445776766.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5B9A\7FA9\306E\524A\9664')
,p_lov_return_value=>'DEL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/delete_corresponding_list_entries
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(139182915633902523.4009)
,p_lov_name=>'DELETE CORRESPONDING LIST ENTRIES'
,p_lov_query=>'.'||wwv_flow_api.id(139182915633902523.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139183129828902528.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\306F\3044 -- \5BFE\5FDC\3059\308B\30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA\306E\524A\9664')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139183303567902531.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\3044\3044\3048 - \5BFE\5FDC\3059\308B\30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA\3092\524A\9664\3057\306A\3044')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/delete_assoc_tabs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84243720472403985.4009)
,p_lov_name=>'DELETE_ASSOC_TABS'
,p_lov_query=>'.'||wwv_flow_api.id(84243720472403985.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84243909960403986.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\3044\3044\3048 - \5BFE\5FDC\3059\308B\30BF\30D6\3092\524A\9664\3057\306A\3044')
,p_lov_return_value=>'NO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84244120450403986.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\306F\3044 - \95A2\9023\3059\308B\30BF\30D6\3092\524A\9664\3059\308B')
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/deployment_build_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19372012243626156.4009)
,p_lov_name=>'DEPLOYMENT BUILD OPTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select patch_name||'' (''||wwv_flow_lang.system_message(patch_status)||'')'' d, id r ',
'  from wwv_flow_patches ',
' where flow_id = :FB_FLOW_ID'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/deployment_license_acceptance
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(110337521891120166.4009)
,p_lov_name=>'DEPLOYMENT LICENSE ACCEPTANCE'
,p_lov_query=>'.'||wwv_flow_api.id(110337521891120166.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110337709187120166.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\540C\610F\3057\307E\3059')
,p_lov_return_value=>'ACCEPTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110337913130120172.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\540C\610F\3057\307E\305B\3093')
,p_lov_return_value=>'NOT_ACCEPTED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/developers_with_comments
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(125707019629972839.4009)
,p_lov_name=>'DEVELOPERS WITH COMMENTS'
,p_lov_query=>'select distinct created_by d, created_by r from wwv_flow_app_comments where flow_id = :fb_flow_id order by upper(created_by)'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dialog_page_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(44400703264122475.4009)
,p_lov_name=>'DIALOG_PAGE_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(44400703264122475.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(44401020446122476.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6A19\6E96')
,p_lov_return_value=>'NORMAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(44401312153122478.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30E2\30FC\30C0\30EB\30FB\30C0\30A4\30A2\30ED\30B0')
,p_lov_return_value=>'MODAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(44401624389122478.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\975E\30E2\30FC\30C0\30EB\30FB\30C0\30A4\30A2\30ED\30B0')
,p_lov_return_value=>'NON_MODAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dialog_page_mode_create_wizard
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1497542689968615899.4009)
,p_lov_name=>'DIALOG_PAGE_MODE_CREATE_WIZARD'
,p_lov_query=>'.'||wwv_flow_api.id(1497542689968615899.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1497542930985615927.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6A19\6E96')
,p_lov_return_value=>'NORMAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1497543374287615927.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30E2\30FC\30C0\30EB\30FB\30C0\30A4\30A2\30ED\30B0')
,p_lov_return_value=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dialog_page_mode_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(887851591470130537.4009)
,p_lov_name=>'DIALOG_PAGE_MODE_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(887851591470130537.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(887851822217130538.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30E2\30FC\30C0\30EB\30FB\30C0\30A4\30A2\30ED\30B0')
,p_lov_return_value=>'MODAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(887852157397130546.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\975E\30E2\30FC\30C0\30EB\30FB\30C0\30A4\30A2\30ED\30B0')
,p_lov_return_value=>'NON_MODAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_3d_graph_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88110219855257765.4009)
,p_lov_name=>'DISPLAY.3D.GRAPH.Y'
,p_lov_query=>'.'||wwv_flow_api.id(88110219855257765.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88110415537257766.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('3D\30B0\30E9\30D5\306E\8868\793A')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_assign_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(90217012922049145.4009)
,p_lov_name=>'DQ_ASSIGN_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select display_value, return_value',
'from (',
'select wwv_flow_escape.html(column_label)||',
'       decode(group_id,',
'       null,',
'       '' (''||wwv_flow_lang.system_message(''UNASSIGNED'')||'')'',',
'       '' (''||(select name from wwv_flow_worksheet_col_groups where id = c.group_id)||'')'') display_value,',
'       id return_value ',
'from wwv_flow_worksheet_columns c',
'where worksheet_id = :P694_WORKSHEET_ID and',
'  (nvl(:P694_SHOW,''ALL'') = ''ALL'' ',
'   or ((:P694_SHOW = ''UNASSIGNED'' and group_id is null) or group_id = :P694_ID))',
'order by display_order, upper(column_label)',
') x'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_default_when
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(89803912916156290.4009)
,p_lov_name=>'DQ_COLUMN_DEFAULT_WHEN'
,p_lov_query=>'.'||wwv_flow_api.id(89803912916156290.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89804223419156291.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\884C\306E\4F5C\6210\4E2D\307E\305F\306F\66F4\65B0\4E2D\3067\5024\304C\6307\5B9A\3055\308C\3066\3044\306A\3044\3068\304D')
,p_lov_return_value=>'WHEN_NULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89804424514156291.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\65B0\898F\884C\306E\4F5C\6210\4E2D\306E\307F')
,p_lov_return_value=>'WHEN_INSERTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_functionality
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(135655901614273908.4009)
,p_lov_name=>'DQ_COLUMN_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_api.id(135655901614273908.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197867120372745037.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\975E\8868\793A')
,p_lov_return_value=>'HIDE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135656201051273908.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30BD\30FC\30C8')
,p_lov_return_value=>'SORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135656409479273908.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30D5\30A3\30EB\30BF')
,p_lov_return_value=>'FILTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(47292224899070718.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30CF\30A4\30E9\30A4\30C8')
,p_lov_return_value=>'HIGHLIGHT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135656630770273909.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF')
,p_lov_return_value=>'BREAK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135656816892273909.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\96C6\8A08')
,p_lov_return_value=>'AGGREGATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135657009007273909.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\8A08\7B97')
,p_lov_return_value=>'COMPUTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135657212463273909.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'CHART'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1542409404810451.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\30B0\30EB\30FC\30D7\5316')
,p_lov_return_value=>'GROUP_BY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(367035115416400374.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\30D4\30DC\30C3\30C8')
,p_lov_return_value=>'PIVOT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_groups
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(89653630129678764.4009)
,p_lov_name=>'DQ_COLUMN_GROUPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id r ',
'from wwv_flow_worksheet_col_groups',
'where worksheet_id = :P687_WORKSHEET_ID',
'order by upper(name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_group_show
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(90206330144997352.4009)
,p_lov_name=>'DQ_COLUMN_GROUP_SHOW'
,p_lov_query=>'.'||wwv_flow_api.id(90206330144997352.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(90206602571997357.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\3059\3079\3066\306E\5217')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(90206830794997359.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\672A\5272\5F53\3066\306E\5217')
,p_lov_return_value=>'UNASSIGNED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_lov_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(89795021349092520.4009)
,p_lov_name=>'DQ_COLUMN_LOV_FROM'
,p_lov_query=>'.'||wwv_flow_api.id(89795021349092520.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89795329939092520.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\56FA\6709\306E\5217\5024')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89795515067092520.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5024\306E\9759\7684\30C9\30E1\30A4\30F3')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(89661604165746991.4009)
,p_lov_name=>'DQ_COLUMN_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(89661604165746991.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89661921597746991.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6587\5B57\5217	')
,p_lov_return_value=>'STRING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89662130353746991.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6570\5024')
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89662330603746991.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\65E5\4ED8')
,p_lov_return_value=>'DATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89662503487746992.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30C9\30AD\30E5\30E1\30F3\30C8')
,p_lov_return_value=>'DOCUMENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89662722742746992.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\8A08\7B97')
,p_lov_return_value=>'COMPUTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(91733204209169832.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30C7\30A3\30C6\30FC\30EB\30FB\30EA\30F3\30AF')
,p_lov_return_value=>'DETAIL_LINK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_detail_page_functionality
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(93896321430905901.4009)
,p_lov_name=>'DQ_DETAIL_PAGE_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_api.id(93896321430905901.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93896600582905901.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('NULL\5024\306E\9664\5916\3092\8A31\53EF')
,p_lov_return_value=>'EXCLUDE_NULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93896828769905901.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8868\793A\5217\3092\8A31\53EF')
,p_lov_return_value=>'HIDE_EXTR_COL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_display_in_def_rpt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(94105402933265699.4009)
,p_lov_name=>'DQ_DISPLAY_IN_DEF_RPT'
,p_lov_query=>'.'||wwv_flow_api.id(94105402933265699.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(94105722376265699.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30C7\30D5\30A9\30EB\30C8\30FB\30EC\30DD\30FC\30C8\3067\8868\793A')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_display_text_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(113775430732356381.4009)
,p_lov_name=>'DQ_DISPLAY_TEXT_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(113775430732356381.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113775715473356384.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6A19\6E96\30EC\30DD\30FC\30C8\5217')
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113776305444356385.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30C6\30AD\30B9\30C8\3068\3057\3066\8868\793A(\7279\6B8A\6587\5B57\3092\30A8\30B9\30B1\30FC\30D7)')
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(450124406392222095.4009)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('\30C6\30AD\30B9\30C8\3068\3057\3066\8868\793A(LOV\306B\57FA\3065\304D\3001\7279\6B8A\6587\5B57\3092\30A8\30B9\30B1\30FC\30D7)')
,p_lov_return_value=>'LOV_ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(442890225057859433.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('HTML\306E\524A\9664\304A\3088\3073\7279\6B8A\6587\5B57\306E\30A8\30B9\30B1\30FC\30D7')
,p_lov_return_value=>'STRIP_HTML_ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135238030911430173.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\975E\8868\793A')
,p_lov_return_value=>'HIDDEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_download_format
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(91727320467023155.4009)
,p_lov_name=>'DQ_DOWNLOAD_FORMAT'
,p_lov_query=>'.'||wwv_flow_api.id(91727320467023155.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(91727602780023159.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CSV'
,p_lov_return_value=>'CSV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3830908039991257.4009)
,p_lov_disp_sequence=>1.5
,p_lov_disp_value=>'HTML'
,p_lov_return_value=>'HTML'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9204300405839444.4009)
,p_lov_disp_sequence=>1.7
,p_lov_disp_value=>unistr('\96FB\5B50\30E1\30FC\30EB *')
,p_lov_return_value=>'EMAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(91727810512023162.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'XLS'
,p_lov_return_value=>'XLS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(91728030204023162.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'PDF'
,p_lov_return_value=>'PDF'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(91728214017023162.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'RTF'
,p_lov_return_value=>'RTF'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_filter_date_range
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(113891626211903772.4009)
,p_lov_name=>'DQ_FILTER_DATE_RANGE'
,p_lov_query=>'.'||wwv_flow_api.id(113891626211903772.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113891914381903774.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\3059\3079\3066')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113892122745903775.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\904E\53BB')
,p_lov_return_value=>'PAST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113892318530903775.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5C06\6765')
,p_lov_return_value=>'FUTURE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_non_pub_rpt_functionality
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(480571702359614063.4009)
,p_lov_name=>'DQ_NON_PUB_RPT_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_api.id(480571702359614063.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(480574929174614071.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\306E\4FDD\5B58')
,p_lov_return_value=>'RPT_SAVING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(480575104904614071.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30D1\30D6\30EA\30C3\30AF\30FB\30EC\30DD\30FC\30C8\306E\4FDD\5B58')
,p_lov_return_value=>'SAVE_RPT_PUBLIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(480574106814614069.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_lov_return_value=>'NOTIFY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_rpt_functionality
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(93890902683872023.4009)
,p_lov_name=>'DQ_RPT_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_api.id(93890902683872023.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93891207939872035.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5217\306E\9078\629E')
,p_lov_return_value=>'SELECT_COLS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93891430852872035.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30D5\30A3\30EB\30BF')
,p_lov_return_value=>'FILTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(445491215210900584.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\3054\3068\306E\884C\6570')
,p_lov_return_value=>'ROWS_PER_PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93891616940872035.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30BD\30FC\30C8')
,p_lov_return_value=>'SORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(141674418886754015.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF')
,p_lov_return_value=>'BREAK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93891825853872035.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30CF\30A4\30E9\30A4\30C8')
,p_lov_return_value=>'HIGHLIGHT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93893009214872050.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\8A08\7B97')
,p_lov_return_value=>'COMPUTATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93892010217872035.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\96C6\8A08')
,p_lov_return_value=>'AGGREGATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(96144107239525391.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'CHART'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1541019690680918.4009)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\30B0\30EB\30FC\30D7\5316')
,p_lov_return_value=>'GROUP_BY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(367023902558041646.4009)
,p_lov_disp_sequence=>105
,p_lov_disp_value=>unistr('\30D4\30DC\30C3\30C8')
,p_lov_return_value=>'PIVOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93892230261872036.4009)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\30AB\30EC\30F3\30C0')
,p_lov_return_value=>'CALENDAR'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93892430175872036.4009)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF')
,p_lov_return_value=>'FLASHBACK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(480714630007218066.4009)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\306E\4FDD\5B58*')
,p_lov_return_value=>'RPT_SAVING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(480714802780219726.4009)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>unistr('\30D1\30D6\30EA\30C3\30AF\30FB\30EC\30DD\30FC\30C8\306E\4FDD\5B58*')
,p_lov_return_value=>'SAVE_RPT_PUBLIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93892610127872036.4009)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>unistr('\30EA\30BB\30C3\30C8')
,p_lov_return_value=>'RESET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135686220155392741.4009)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>unistr('\30D8\30EB\30D7')
,p_lov_return_value=>'HELP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93892800927872050.4009)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>unistr('\30C0\30A6\30F3\30ED\30FC\30C9')
,p_lov_return_value=>'DOWNLOAD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(480715008321221245.4009)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3*')
,p_lov_return_value=>'NOTIFY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93893414283872050.4009)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\30FB\30AB\30C6\30B4\30EA\3092\8A31\53EF')
,p_lov_return_value=>'RPT_CATEGORY'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_rpt_list_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(93938623554284943.4009)
,p_lov_name=>'DQ_RPT_LIST_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(93938623554284943.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(93938902214284943.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306F\3044')
,p_lov_return_value=>'TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131717516025931094.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\3044\3044\3048')
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_same_label_for_detail_view
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(96419205216695800.4009)
,p_lov_name=>'DQ_SAME_LABEL_FOR_DETAIL_VIEW'
,p_lov_query=>'.'||wwv_flow_api.id(96419205216695800.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(96419521321695807.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5358\4E00\884C\30D3\30E5\30FC\306B\540C\3058\30C6\30AD\30B9\30C8\3092\4F7F\7528')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_search_functionality
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(131635032236756030.4009)
,p_lov_name=>'DQ_SEARCH_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_api.id(131635032236756030.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131635314260756031.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\691C\7D22\30D5\30A3\30FC\30EB\30C9')
,p_lov_return_value=>'SEARCH_TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131635716026756031.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30D5\30A1\30A4\30F3\30C0\30FB\30C9\30ED\30C3\30D7\30FB\30C0\30A6\30F3')
,p_lov_return_value=>'FINDER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192533912617244035.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30EC\30DD\30FC\30C8\9078\629E\30EA\30B9\30C8')
,p_lov_return_value=>'REPORTS_SELECT_LIST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131635520752756031.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\3054\3068\306E\884C\6570\30BB\30EC\30AF\30BF')
,p_lov_return_value=>'ROW_CNT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135033300784021288.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30A2\30AF\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
,p_lov_return_value=>'ACTIONS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_worksheet_pagination
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(89240132490172141.4009)
,p_lov_name=>'DQ_WORKSHEET_PAGINATION'
,p_lov_query=>'.'||wwv_flow_api.id(89240132490172141.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89240414406172201.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Z\306EX\304B\3089Y\306E\7BC4\56F2\306E\884C')
,p_lov_return_value=>'ROWS_X_TO_Y_OF_Z'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89240620434172201.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('X\304B\3089Y\306E\7BC4\56F2\306E\884C')
,p_lov_return_value=>'ROWS_X_TO_Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_worksheet_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(89234523991056148.4009)
,p_lov_name=>'DQ_WORKSHEET_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(89234523991056148.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89234802427056220.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6240\6709\8005\304C\4F7F\7528\53EF\80FD')
,p_lov_return_value=>'AVAILABLE_FOR_OWNER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89235015173056220.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4F7F\7528\4E0D\53EF')
,p_lov_return_value=>'NOT_AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89235209196056220.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\4F7F\7528\53EF\80FD')
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89235410026056220.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8')
,p_lov_return_value=>'ACL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_action_aff_elem_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(42588011898494805.4009)
,p_lov_name=>'DYNAMIC ACTION AFF ELEM TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(42588011898494805.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42588307156494808.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'ITEM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(206201404272235955.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30DC\30BF\30F3')
,p_lov_return_value=>'BUTTON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42588501084494810.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'REGION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42588703168494810.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5217')
,p_lov_return_value=>'COLUMN'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42588930101494810.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('DOM\30AA\30D6\30B8\30A7\30AF\30C8[\975E\63A8\5968]')
,p_lov_return_value=>'DOM_OBJECT'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':APP_PAGE_ID <> 591',
'or ( :APP_PAGE_ID = 591 and :P591_AFFECTED_ELEMENTS_TYPE = ''DOM_OBJECT'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42589125805494810.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('jQuery\30BB\30EC\30AF\30BF')
,p_lov_return_value=>'JQUERY_SELECTOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(855875291459963705.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('JavaScript\5F0F')
,p_lov_return_value=>'JAVASCRIPT_EXPRESSION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(486612219500089929.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\30C8\30EA\30AC\30FC\8981\7D20')
,p_lov_return_value=>'TRIGGERING_ELEMENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(486612426080091815.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\30A4\30D9\30F3\30C8\30FB\30BD\30FC\30B9')
,p_lov_return_value=>'EVENT_SOURCE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_action_bind_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(34818831818567513.4009)
,p_lov_name=>'DYNAMIC ACTION BIND TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(34818831818567513.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34819108605567514.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9759\7684')
,p_lov_return_value=>'bind'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34819317513567514.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\52D5\7684')
,p_lov_return_value=>'live'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(47188804631100745.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('1\56DE')
,p_lov_return_value=>'one'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_action_condition
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4505805282372682.4009)
,p_lov_name=>'DYNAMIC ACTION CONDITION'
,p_lov_query=>'.'||wwv_flow_api.id(4505805282372682.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4506012984372684.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6B21\3068\7B49\3057\3044')
,p_lov_return_value=>'EQUALS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4506219163372689.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6B21\3068\7B49\3057\304F\306A\3044')
,p_lov_return_value=>'NOT_EQUALS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4506429627372689.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\6B21\3088\308A\5927\304D\3044')
,p_lov_return_value=>'GREATER_THAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(485047623220016520.4009)
,p_lov_disp_sequence=>35
,p_lov_disp_value=>unistr('\6B21\4EE5\4E0A')
,p_lov_return_value=>'GREATER_THAN_OR_EQUAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4506629608372689.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\6B21\3088\308A\5C0F\3055\3044')
,p_lov_return_value=>'LESS_THAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(485047828414018007.4009)
,p_lov_disp_sequence=>45
,p_lov_disp_value=>unistr('\6B21\4EE5\4E0B')
,p_lov_return_value=>'LESS_THAN_OR_EQUAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4506817808372689.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'NULL'
,p_lov_return_value=>'NULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4507030226372689.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('NULL\3067\306F\306A\3044')
,p_lov_return_value=>'NOT_NULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5702509159891012.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\306B\542B\307E\308C\308B')
,p_lov_return_value=>'IN_LIST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5703019894894122.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\30EA\30B9\30C8\306B\542B\307E\308C\306A\3044')
,p_lov_return_value=>'NOT_IN_LIST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(36337703765902045.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('JavaScript\5F0F')
,p_lov_return_value=>'JAVASCRIPT_EXPRESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_action_trigg_elem_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(34817614503562438.4009)
,p_lov_name=>'DYNAMIC ACTION TRIGG ELEM TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(34817614503562438.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34817919388562441.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'ITEM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34818325097562443.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30DC\30BF\30F3')
,p_lov_return_value=>'BUTTON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34818131975562443.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'REGION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34818512066562444.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('DOM\30AA\30D6\30B8\30A7\30AF\30C8[\975E\63A8\5968]')
,p_lov_return_value=>'DOM_OBJECT'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':APP_PAGE_ID not in ( 423, 793, 797 )',
'or ( :APP_PAGE_ID = 793 and :P793_TRIGGERING_ELEMENT_TYPE = ''DOM_OBJECT'' )',
'or ( :APP_PAGE_ID = 797 and :P797_TRIGGERING_ELEMENT_TYPE = ''DOM_OBJECT'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34818720680562446.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('jQuery\30BB\30EC\30AF\30BF')
,p_lov_return_value=>'JQUERY_SELECTOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(855887929978084842.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('JavaScript\5F0F')
,p_lov_return_value=>'JAVASCRIPT_EXPRESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_action_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(176908416123204266.4009)
,p_lov_name=>'DYNAMIC ACTION TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(176908416123204266.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(176908631630204301.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\8868\793A')
,p_lov_return_value=>'NATIVE_SHOW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181460730381992265.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\975E\8868\793A')
,p_lov_return_value=>'NATIVE_HIDE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(176908832156204306.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\6709\52B9\5316')
,p_lov_return_value=>'NATIVE_ENABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184818803817394386.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\7121\52B9\5316')
,p_lov_return_value=>'NATIVE_DISABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_actions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(34830410796693863.4009)
,p_lov_name=>'DYNAMIC ACTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''DA_NAME.''|| name_with_prefix) as d,',
'       name_with_prefix as r',
'  from wwv_flow_native_plugins',
' where plugin_type = ''DYNAMIC ACTION''',
' union all',
'select display_name || wwv_flow_lang.system_message(''PLUGIN.DISPLAY_NAME_POSTFIX'') as d,',
'       ''PLUGIN_'' || name as r',
'  from wwv_flow_plugins',
' where flow_id = to_number(:FB_FLOW_ID)',
'   and security_group_id = to_number(:WORKSPACE_ID)',
'   and plugin_type = ''DYNAMIC ACTION''',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_actions_old
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4507311169374329.4009)
,p_lov_name=>'DYNAMIC ACTIONS OLD'
,p_lov_query=>'.'||wwv_flow_api.id(4507311169374329.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4507509318374330.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8868\793A')
,p_lov_return_value=>'SHOW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4507707037374331.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\975E\8868\793A')
,p_lov_return_value=>'HIDE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25500603273005492.4009)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('\975E\8868\793A\304A\3088\3073\30AF\30EA\30A2')
,p_lov_return_value=>'HIDE_AND_CLEAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4507925307374331.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\6709\52B9\5316')
,p_lov_return_value=>'ENABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4508112618374331.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\7121\52B9\5316')
,p_lov_return_value=>'DISABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4508306180374331.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30A2\30A4\30C6\30E0\884C\306E\8868\793A')
,p_lov_return_value=>'SHOW_ITEM_ROW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4508511742374331.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30A2\30A4\30C6\30E0\884C\306E\975E\8868\793A')
,p_lov_return_value=>'HIDE_ITEM_ROW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_theme_list
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(317672930832099392.4009)
,p_lov_name=>'DYNAMIC_THEME_LIST'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''<br/><a href="f?p=4000:''||:THEME_NEXT_PAGE||'':''||:APP_SESSION||''::::THEME_ID:''||t.theme_id||''"><img src="#IMAGE_PREFIX#themes/theme_''||t.theme_id||''/themeshot.png" alt="''||wwv_flow_lang.'
||'system_message(''THEME'')||'' ''||t.theme_id||''" title="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" width="150" height="80" class="htmldbthemeshots" /></a>'' display_value, t.theme_id ',
'from (',
'    select substr(object_name,16) theme_id ',
'    from   user_objects ',
'    where  object_name like ''WWV_FLOW_THEME_%''',
'    and    object_type = ''PACKAGE''',
'    and    substr(object_name,16) in (',
'        ''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''10'',',
'        ''11'',''12'',''13'',''14'',''15'',''16'',''17'',''18'',''19'',''20'',',
'        ''21'',''22'',''23'',''24'',''25'',''26'',''27'',''28'',''29'',''30'',',
'        ''31'',''32'',''33'',''34'',''35'',''36'',''37'',''38'',''39'',''40'',',
'        ''41'',''42'',''43'',''44'',''45'',''46'',''47'',''48'',''49'',''50'',',
'        ''51'',''52'',''53'',''54'',''55'',''56'',''57'',''58'',''59'',''60'',',
'        ''61'',''62'',''63'',''64'',''65'',''66'',''67'',''68'',''69'',''70'',',
'        ''71'',''72'',''73'',''74'',''75'',''76'',''77'',''78'',''79'',''80'',',
'        ''81'',''82'',''83'',''84'',''85'',''86'',''87'',''88'',''89'',''90'',',
'        ''91'',''92'',''93'',''94'',''95'',''96'',''97'',''98'',''99'',''100''',
'    )',
') t',
'where t.theme_id not in (select theme_id from wwv_flow_themes where flow_id = :fb_flow_id) ',
'order by to_number(t.theme_id)',
'',
'',
'',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enabled_disabled_returns_y_or_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(91439803955181562.4009)
,p_lov_name=>'ENABLED_DISABLED_RETURNS_Y_OR_N'
,p_lov_query=>'.'||wwv_flow_api.id(91439803955181562.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(91440204684181564.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7121\52B9')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(91440020513181563.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6709\52B9')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enable_calendar_data_add
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7062800325985451.4009)
,p_lov_name=>'ENABLE_CALENDAR_DATA_ADD'
,p_lov_query=>'select wwv_flow_lang.system_message(''CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'') d, ''Y'' r from dual'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enable_calendar_drag_drop
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7041321387979610.4009)
,p_lov_name=>'ENABLE_CALENDAR_DRAG_DROP'
,p_lov_query=>'select wwv_flow_lang.system_message(''CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'') d, ''Y'' r from dual'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enable_csv_export
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(113206414430374390.4009)
,p_lov_name=>'ENABLE_CSV_EXPORT'
,p_lov_query=>'.'||wwv_flow_api.id(113206414430374390.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113206730666374392.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('CSV\51FA\529B\306E\6709\52B9\5316')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enable_disable
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84865108269386627.4009)
,p_lov_name=>'ENABLE_DISABLE'
,p_lov_query=>'.'||wwv_flow_api.id(84865108269386627.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84865322430386628.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7121\52B9\5316')
,p_lov_return_value=>'DISABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84865528406386628.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6709\52B9\5316')
,p_lov_return_value=>'ENABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/error_display_location
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(175855211406623797.4009)
,p_lov_name=>'ERROR_DISPLAY_LOCATION'
,p_lov_query=>'.'||wwv_flow_api.id(175855211406623797.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175855515052623815.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30D5\30A3\30FC\30EB\30C9\304A\3088\3073\901A\77E5\3067\30A4\30F3\30E9\30A4\30F3\8868\793A')
,p_lov_return_value=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175855711259623816.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30D5\30A3\30FC\30EB\30C9\3067\30A4\30F3\30E9\30A4\30F3\8868\793A')
,p_lov_return_value=>'INLINE_WITH_FIELD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175855923896623816.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\901A\77E5\3067\30A4\30F3\30E9\30A4\30F3\8868\793A')
,p_lov_return_value=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175856114844623817.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30A8\30E9\30FC\30FB\30DA\30FC\30B8')
,p_lov_return_value=>'ON_ERROR_PAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/exact_match
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(165376410332055484.4009)
,p_lov_name=>'EXACT_MATCH'
,p_lov_query=>'.'||wwv_flow_api.id(165376410332055484.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(165376716320055488.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5B8C\5168\4E00\81F4')
,p_lov_return_value=>'y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/exact_subs_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84908521896674445.4009)
,p_lov_name=>'EXACT_SUBS_Y_N'
,p_lov_query=>'.'||wwv_flow_api.id(84908521896674445.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84908724352674446.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\3044\3044\3048 - \975E\5B8C\5168\7F6E\63DB\3082\5B9F\884C\3059\308B')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84908932193674446.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\306F\3044 - \5B8C\5168\7F6E\63DB\306E\307F\5B9F\884C\3059\308B')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/exec_location
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3842073961668883.4009)
,p_lov_name=>'EXEC_LOCATION'
,p_lov_query=>'.'||wwv_flow_api.id(3842073961668883.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3842372126668884.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30ED\30FC\30AB\30EB\30FB\30C7\30FC\30BF\30D9\30FC\30B9')
,p_lov_return_value=>'LOCAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3842783209668886.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('REST\5BFE\5FDCSQL\30B5\30FC\30D3\30B9')
,p_lov_return_value=>'REMOTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3843166174668886.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Web\30BD\30FC\30B9')
,p_lov_return_value=>'WEB_SOURCE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_component_application_attributes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(201561021137913944.4009)
,p_lov_name=>'EXPORT COMPONENT APPLICATION ATTRIBUTES'
,p_lov_query=>'.'||wwv_flow_api.id(201561021137913944.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201561202964913947.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30C7\30D5\30A9\30EB\30C8\30FB\30DA\30FC\30B8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201561427317913952.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30ED\30B4')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201561612262913952.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30ED\30B0\30A2\30A6\30C8URL')
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201561802624913952.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30B0\30ED\30FC\30D0\30EB\901A\77E5')
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201562020313913952.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \8A8D\8A3C')
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201589706900307265.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30DB\30FC\30E0\30FB\30EA\30F3\30AF')
,p_lov_return_value=>'6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201590720753311215.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30A4\30E1\30FC\30B8\63A5\982D\8F9E')
,p_lov_return_value=>'7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201591029064313600.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30ED\30AE\30F3\30B0 (\306F\3044/\3044\3044\3048)')
,p_lov_return_value=>'8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201591602183315334.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\6240\6709\8005')
,p_lov_return_value=>'9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201592417767319814.4009)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \9759\7684\7F6E\63DB\6587\5B57\5217')
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201603224693321841.4009)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30BF\30B9\304A\3088\3073\30E1\30C3\30BB\30FC\30B8')
,p_lov_return_value=>'11'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(201604303007325019.4009)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30C7\30D0\30C3\30B0\306E\6709\52B9\5316 (\306F\3044/\3044\3044\3048)')
,p_lov_return_value=>'12'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(204137731018130907.4009)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D')
,p_lov_return_value=>'13'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(204138001713131913.4009)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5225\540D')
,p_lov_return_value=>'14'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(204138307946133739.4009)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \6B63\78BA\306A\7F6E\63DB\30E2\30FC\30C9')
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(204139019721137188.4009)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30BB\30AD\30E5\30EA\30C6\30A3\30FB\30B9\30AD\30FC\30E0')
,p_lov_return_value=>'16'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(204139423184138143.4009)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30D7\30ED\30AD\30B7\30FB\30B5\30FC\30D0\30FC')
,p_lov_return_value=>'17'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(204140027339139375.4009)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \30DA\30FC\30B8\4FDD\8B77')
,p_lov_return_value=>'18'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(204140631495140521.4009)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027: \4EEE\60F3\30D7\30E9\30A4\30D9\30FC\30C8\30FB\30C7\30FC\30BF\30D9\30FC\30B9')
,p_lov_return_value=>'19'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(45348605156549399.4009)
,p_lov_name=>'EXPORT.OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(45348605156549399.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(45349208290549436.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A4\30F3\30DD\30FC\30C8')
,p_lov_return_value=>'IMPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1846115445438584.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'EXPORT'
,p_lov_disp_cond_type=>'NOT_EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flows where security_group_id = :flow_security_group_id'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(45349021845549425.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'EXPORT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flows where security_group_id = :flow_security_group_id'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_options_with_icons
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(805553919796597674.4009)
,p_lov_name=>'EXPORT.OPTIONS WITH ICONS'
,p_lov_query=>'.'||wwv_flow_api.id(805553919796597674.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805554221842597674.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A4\30F3\30DD\30FC\30C8')
,p_lov_return_value=>'IMPORT'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-app-builder-import-app'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805554564333597675.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'EXPORT'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-app-builder-export-app'
,p_lov_disp_cond_type=>'NOT_EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flows where security_group_id = :flow_security_group_id'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805554842111597676.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'EXPORT'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-app-builder-export-app'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flows where security_group_id = :flow_security_group_id'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_targets_no_xml
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(43935029932609535.4009)
,p_lov_name=>'EXPORT.TARGETS.no.xml'
,p_lov_query=>'.'||wwv_flow_api.id(43935029932609535.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43935319566609536.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'UNIX'
,p_lov_return_value=>'UNIX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(43935500793609538.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'DOS'
,p_lov_return_value=>'DOS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(107236303690563927.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9')
,p_lov_return_value=>'DB'
,p_lov_disp_cond_type=>'FUNCTION_BODY'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_platform.get_preference(''APP_EXPORT_TO_DB_ENABLED''),''Y'') = ''Y'' and :APP_PAGE_ID = 4900 then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_feedback_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(472293315458205653.4009)
,p_lov_name=>'EXPORT_FEEDBACK_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(472293315458205653.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(472293519211205655.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\958B\767A\3078\306E\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'TO_DEVELOPMENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(472293702716205659.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30C7\30D7\30ED\30A4\3078\306E\30EC\30B9\30DD\30F3\30B9\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'TO_DEPLOYMENT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_file_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84829617133304005.4009)
,p_lov_name=>'EXPORT_FILE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(84829617133304005.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84829803958304006.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3001\30DA\30FC\30B8\307E\305F\306F\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'FLOW_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(503772918720743828.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('Web\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'WEBSHEET_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30414604424207501.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_lov_return_value=>'PLUGIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84830627988304007.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30B9\30AF\30EA\30D7\30C8\30FB\30D5\30A1\30A4\30EB\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'SCRIPT_FILE_EXPORT'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(141375217080001896.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30A8\30AF\30B9\30DD\30FC\30C8\6E08\306E\30C6\30FC\30DE')
,p_lov_return_value=>'THEME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(158557719334534776.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\30C7\30D5\30A9\30EB\30C8\5024')
,p_lov_return_value=>'UI_DEFAULTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(472592924227766354.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\30C1\30FC\30E0\958B\767A\306E\30D5\30A3\30FC\30C9\30D0\30C3\30AF')
,p_lov_return_value=>'FEEDBACK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84830010423304006.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('CSS\30A8\30AF\30B9\30DD\30FC\30C8[\975E\63A8\5968]')
,p_lov_return_value=>'CSS_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84830213403304006.4009)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\30A4\30E1\30FC\30B8\306E\30A8\30AF\30B9\30DD\30FC\30C8[\975E\63A8\5968]')
,p_lov_return_value=>'IMAGE_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84830422156304006.4009)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\30D5\30A1\30A4\30EB\306E\30A8\30AF\30B9\30DD\30FC\30C8[\975E\63A8\5968]')
,p_lov_return_value=>'FILE_EXPORT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_sup_obj_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(388231942990864305.4009)
,p_lov_name=>'EXPORT_SUP_OBJ_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(388231942990864305.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(388232203970864308.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306F\3044')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(388232554971864310.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\3044\3044\3048')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(388232860273864310.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30A4\30F3\30DD\30FC\30C8\6642\306B\81EA\52D5\7684\306B\30A4\30F3\30B9\30C8\30FC\30EB')
,p_lov_return_value=>'I'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84313028848586180.4009)
,p_lov_name=>'EXPORT_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(84313028848586180.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84313210243586181.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9')
,p_lov_return_value=>'COMPANY_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84313400691586181.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_lov_return_value=>'FLOW_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(504409922096580868.4009)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('Web\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
,p_lov_return_value=>'WEBSHEET_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84313629140586181.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30DA\30FC\30B8')
,p_lov_return_value=>'PAGE_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30460601502095997.4009)
,p_lov_disp_sequence=>35
,p_lov_disp_value=>unistr('\30D7\30E9\30B0\30A4\30F3')
,p_lov_return_value=>'PLUGIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84313822161586182.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'CSS'
,p_lov_return_value=>'CSS_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84314021666586182.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30A4\30E1\30FC\30B8')
,p_lov_return_value=>'IMAGE_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84314231797586182.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30D5\30A1\30A4\30EB')
,p_lov_return_value=>'FILE_EXPORT'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84314413534586182.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30B9\30AF\30EA\30D7\30C8')
,p_lov_return_value=>'SCRIPT_FILE_EXPORT'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(218848421565947069.4009)
,p_lov_disp_sequence=>75
,p_lov_disp_value=>unistr('\9759\7684\30D5\30A1\30A4\30EB\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_lov_return_value=>'FILE_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217881026720006951.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\30C6\30FC\30DE')
,p_lov_return_value=>'THEME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217881302263009316.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\30C7\30D5\30A9\30EB\30C8\5024')
,p_lov_return_value=>'UI_DEFAULTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(39083219682790387.4009)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\30C1\30FC\30E0\958B\767A\306E\30D5\30A3\30FC\30C9\30D0\30C3\30AF')
,p_lov_return_value=>'FEEDBACK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/f4000_p115_calendar_on_demand_process
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(26525820538413319.4009)
,p_lov_name=>'F4000_P115_CALENDAR_ON_DEMAND_PROCESS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(process_name) d, id r',
'  from wwv_flow_step_processing',
' where flow_id = :fb_flow_id ',
'   and flow_step_id = :FB_FLOW_PAGE_ID',
'   and process_point = ''ON_DEMAND''',
' order by process_name',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/f4000_pt0x
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(104345318793564176.4009)
,p_lov_name=>'F4000_PT0X'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select :F4000_PTN1 d, 1 r from dual ',
'where  :F4000_PTN1 is not null',
'union all',
'select :F4000_PTN2 d, 2 r from dual',
'where  :F4000_PTN2 is not null',
'union all',
'select :F4000_PTN3 d, 3 r from dual',
'where  :F4000_PTN3 is not null',
'union all',
'select :F4000_PTN4 d, 4 r from dual',
'where  :F4000_PTN4 is not null',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_desirability
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1498507020727379780.4009)
,p_lov_name=>'FEATURE DESIRABILITY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name d, id',
'from wwv_flow_feature_desirability',
'order by id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_focus_areas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1498507247370379782.4009)
,p_lov_name=>'FEATURE FOCUS AREAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct focus_area d, focus_area r',
'from wwv_flow_features ',
'where security_group_id = :flow_security_group_id',
'and focus_area is not null',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_priority
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1498507593211379782.4009)
,p_lov_name=>'FEATURE PRIORITY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name d, id',
'from   wwv_flow_feature_priorities',
'order by id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1498507788819379782.4009)
,p_lov_name=>'FEATURE STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select status_name ||'' - ''||pct_complete||''%'' d, pct_complete r',
'from wwv_flow_feature_def_st_codes',
'order by pct_complete'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/features_doc_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1498508302658379782.4009)
,p_lov_name=>'FEATURES, DOC STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name the_name, id ',
'from wwv_flow_feature_docstatus',
'order by id',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1498508547672379782.4009)
,p_lov_name=>'FEEDBACK STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name the_name, id ',
'from wwv_flow_feedback_status ',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(692564541295242869.4009)
,p_lov_name=>'FEEDBACK TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(692564541295242869.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(720957220062547736.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\958B\767A\8005\306E\30B3\30E1\30F3\30C8')
,p_lov_return_value=>'COMMENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(692565162163242874.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30D0\30B0')
,p_lov_return_value=>'BUG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(692564818123242871.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'To Do'
,p_lov_return_value=>'TODO'
);
end;
/
prompt --application/shared_components/user_interface/lovs/fieldtemplate
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(93450900806779850.4009)
,p_lov_name=>'FIELDTEMPLATE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(template_name) d, id',
'from   wwv_flow_field_templates',
'where  flow_id = :fb_flow_id and ',
'       (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/field_alignment
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84354125395660958.4009)
,p_lov_name=>'FIELD_ALIGNMENT'
,p_lov_query=>'.'||wwv_flow_api.id(84354125395660958.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84354312984660959.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\592E')
,p_lov_return_value=>'CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84354513344660959.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4E2D\592E\4E0B\90E8')
,p_lov_return_value=>'CENTER-BOTTOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84354712797660959.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\4E2D\592E')
,p_lov_return_value=>'CENTER-CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84354917729660959.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\4E2D\592E\4E0A\90E8')
,p_lov_return_value=>'CENTER-TOP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84355106101660960.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\958B\59CB')
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84355327264660960.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\958B\59CB\4E0B\90E8')
,p_lov_return_value=>'LEFT-BOTTOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84355517743660961.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\958B\59CB\4E2D\592E')
,p_lov_return_value=>'LEFT-CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84355723004660961.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\958B\59CB\4E0A\90E8')
,p_lov_return_value=>'LEFT-TOP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84355913470660961.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\7D42\4E86')
,p_lov_return_value=>'RIGHT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84356104865660961.4009)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\7D42\4E86\4E0B\90E8')
,p_lov_return_value=>'RIGHT-BOTTOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84356323660660962.4009)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\7D42\4E86\4E2D\592E')
,p_lov_return_value=>'RIGHT-CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84356511314660962.4009)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('\7D42\4E86\4E0A\90E8')
,p_lov_return_value=>'RIGHT-TOP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/file_extensions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(152392614641425297.4009)
,p_lov_name=>'FILE EXTENSIONS'
,p_lov_query=>'.'||wwv_flow_api.id(152392614641425297.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(152392917070425300.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'gif'
,p_lov_return_value=>'gif'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(152393102499425300.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'jpg'
,p_lov_return_value=>'jpg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(152393306933425300.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'png'
,p_lov_return_value=>'png'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(152393526593425301.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'js'
,p_lov_return_value=>'js'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(152393720879425301.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'ico'
,p_lov_return_value=>'ico'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(152393912392425301.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'swf'
,p_lov_return_value=>'swf'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(152561112881547769.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'CSS'
,p_lov_return_value=>'css'
);
end;
/
prompt --application/shared_components/user_interface/lovs/file_format
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(84322414566600975.4009)
,p_lov_name=>'FILE_FORMAT'
,p_lov_query=>'.'||wwv_flow_api.id(84322414566600975.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84322611093600976.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'DOS'
,p_lov_return_value=>'DOS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(84322801136600976.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'UNIX'
,p_lov_return_value=>'UNIX'
);
end;
/
prompt --application/shared_components/user_interface/lovs/find_files_report_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(152121930169975580.4009)
,p_lov_name=>'FIND FILES REPORT OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(152121930169975580.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(152122103854975582.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30B3\30F3\30C6\30AD\30B9\30C8\4ED8\304D')
,p_lov_return_value=>'CONTEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(152122325945975584.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30B3\30F3\30C6\30AD\30B9\30C8\306A\3057')
,p_lov_return_value=>'NO_CONTEXT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/first_item
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88125512675662566.4009)
,p_lov_name=>'FIRST.ITEM'
,p_lov_query=>'.'||wwv_flow_api.id(88125512675662566.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88125727281662567.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DA\30FC\30B8\306E\6700\521D\306E\30A2\30A4\30C6\30E0')
,p_lov_return_value=>'AUTO_FIRST_ITEM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88125912388662567.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30D5\30A9\30FC\30AB\30B9\306A\3057')
,p_lov_return_value=>'NO_FIRST_ITEM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/fixed_header_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1591954790699969778.4009)
,p_lov_name=>'FIXED_HEADER_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(1591954790699969778.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1591955066049969781.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306A\3057')
,p_lov_return_value=>'NONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1591955376065969785.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'REGION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1591955690098969785.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30DA\30FC\30B8')
,p_lov_return_value=>'PAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/fk_col_source_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(61279713459133078.4009)
,p_lov_name=>'FK_COL_SOURCE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(61279713459133078.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(61280232645133087.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30A4\30C6\30E0(\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\307E\305F\306F\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\540D)')
,p_lov_return_value=>'ITEM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(137617420490097969.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('PL/SQL\5F0F\307E\305F\306F\30D5\30A1\30F3\30AF\30B7\30E7\30F3')
,p_lov_return_value=>'FUNCTION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart5_map_grid
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187840110726070412.4009)
,p_lov_name=>'FLASH_CHART5_MAP_GRID'
,p_lov_query=>'.'||wwv_flow_api.id(187840110726070412.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187840317661070420.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306A\3057')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187840530764070422.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('X\8EF8')
,p_lov_return_value=>'X'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187840724674070422.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Y\8EF8')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187840902779070422.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\4E21\65B9')
,p_lov_return_value=>'B'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart5_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(358743631674618672.4009)
,p_lov_name=>'FLASH_CHART5_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(358743631674618672.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358743931679618673.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('3D\5217')
,p_lov_return_value=>'3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358744208924618674.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\5217')
,p_lov_return_value=>'Stacked3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358744528564618674.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\5217(%)')
,p_lov_return_value=>'3DSTACKED_PCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358744816963618674.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('2D\5217')
,p_lov_return_value=>'2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358745100378618674.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('2D\7A4D\4E0A\3052\5217')
,p_lov_return_value=>'Stacked2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358745403268618674.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('2D\7A4D\4E0A\3052\5217(%)')
,p_lov_return_value=>'2DSTACKED_PCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358745725630618674.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('3D\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'Horizontal3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358746015016618674.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'StackedHorizontal3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358746301506618674.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\68D2\30B0\30E9\30D5(%)')
,p_lov_return_value=>'3DHSTACKED_PCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358746616856618675.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('2D\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'Horizontal2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358746911977618675.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('2D\7A4D\4E0A\3052\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'StackedHorizontal2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358747204013618675.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('2D\7A4D\4E0A\3052\68D2\30B0\30E9\30D5(%)')
,p_lov_return_value=>'2DHSTACKED_PCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358747517635618678.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('3D\7BC4\56F2\5217')
,p_lov_return_value=>'Range3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358747823141618678.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('3D\7BC4\56F2\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'HorizontalRange3DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358748120880618678.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('2D\7BC4\56F2\5217')
,p_lov_return_value=>'Range2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358748411650618678.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('2D\7BC4\56F2\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'HorizontalRange2DColumn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358748728247618678.4009)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('3D\5186')
,p_lov_return_value=>'3DPie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358749021404618678.4009)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('2D\5186')
,p_lov_return_value=>'2DPie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358749305667618678.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('2D\30C9\30FC\30CA\30C4')
,p_lov_return_value=>'2DDoughnut'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358749600376618679.4009)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('2D\6298\308C\7DDA')
,p_lov_return_value=>'2DLine'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358749902085618679.4009)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>unistr('\30B9\30D7\30E9\30A4\30F3\66F2\7DDA')
,p_lov_return_value=>'2DSpline'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358750231069618679.4009)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>unistr('\30ED\30FC\30BD\30AF\8DB3')
,p_lov_return_value=>'Candlestick'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358750500941618679.4009)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('\6563\5E03/\30DE\30FC\30AB\30FC')
,p_lov_return_value=>'ScatterMarker'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358750804854618679.4009)
,p_lov_disp_sequence=>26
,p_lov_disp_value=>unistr('\30C0\30A4\30E4\30EB')
,p_lov_return_value=>'GaugeChart'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358751114508618679.4009)
,p_lov_disp_sequence=>27
,p_lov_disp_value=>unistr('\30C0\30A4\30E4\30EB(%)')
,p_lov_return_value=>'DIAL_PCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358751431569618679.4009)
,p_lov_disp_sequence=>28
,p_lov_disp_value=>unistr('\30DE\30C3\30D7')
,p_lov_return_value=>'Map'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358751726325618680.4009)
,p_lov_disp_sequence=>29
,p_lov_disp_value=>unistr('\30D7\30ED\30B8\30A7\30AF\30C8\30FB\30AC\30F3\30C8')
,p_lov_return_value=>'ProjectGantt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(358752027053618680.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30EA\30BD\30FC\30B9\30FB\30AC\30F3\30C8')
,p_lov_return_value=>'ResourceGantt'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_animation
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(27046124080991431.4009)
,p_lov_name=>'FLASH_CHART_5_ANIMATION'
,p_lov_query=>'.'||wwv_flow_api.id(27046124080991431.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27046404955991530.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5916\89B3')
,p_lov_return_value=>'Appear'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27046602368991530.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8868\793A')
,p_lov_return_value=>'show'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27046804318991530.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5DE6\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromLeft'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27047026909991530.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\4E0A\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromTop'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27047217966991530.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\53F3\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromRight'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27047428097991530.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\4E0B\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromBottom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27047615017991530.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\5DE6\4E0A\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromLeftTop'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27047815564991530.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\53F3\4E0A\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromRightTop'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27048018242991531.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\53F3\4E0B\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromRightBottom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27048228629991531.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5DE6\4E0B\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromLeftBottom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27048416610991531.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\5DE6\5074\4E2D\592E\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromLeftCenter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27048607873991531.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\4E0A\90E8\4E2D\592E\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromTopCenter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27048815325991531.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\53F3\5074\4E2D\592E\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromRightCenter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27049014906991531.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\4E0B\90E8\4E2D\592E\304B\3089\30B9\30E9\30A4\30C9')
,p_lov_return_value=>'SideFromBottomCenter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27049207874991531.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('X\4E2D\592E\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXCenter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27053916648102759.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('X\5DE6\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXLeft'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27054121496104144.4009)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('X\53F3\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXRight'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27054324267104919.4009)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('Y\4E2D\592E\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleYCenter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27054527037105754.4009)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('Y\4E0A\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleYTop'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27054729808106609.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Y\4E0B\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleYBottom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27054901195107724.4009)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('XY\4E2D\592E\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXYCenter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27055106044109144.4009)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>unistr('XY\5DE6\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXYLeft'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27055310546110438.4009)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>unistr('XY\4E0A\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXYTop'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27055514701111713.4009)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>unistr('XY\53F3\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXYRight'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27055718511112723.4009)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('XY\4E0B\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXYBottom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27055923836123761.4009)
,p_lov_disp_sequence=>26
,p_lov_disp_value=>unistr('XY\5DE6\4E0A\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXYLeftTop'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27056128338125081.4009)
,p_lov_disp_sequence=>27
,p_lov_disp_value=>unistr('XY\53F3\4E0A\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXYRightTop'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27056331801126086.4009)
,p_lov_disp_sequence=>28
,p_lov_disp_value=>unistr('XY\53F3\4E0B\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXYRightBottom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27056504921127751.4009)
,p_lov_disp_sequence=>29
,p_lov_disp_value=>unistr('XY\5DE6\4E0B\30B9\30B1\30FC\30EB')
,p_lov_return_value=>'ScaleXYLeftBottom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27056711500129646.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5916\5074')
,p_lov_return_value=>'Outside'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27056913578130231.4009)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>unistr('\306A\3057')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_background_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(27065211117176829.4009)
,p_lov_name=>'FLASH_CHART_5_BACKGROUND_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(27065211117176829.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(190891915128750491.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\900F\660E')
,p_lov_return_value=>'Trans'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27065530889176829.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30BD\30EA\30C3\30C9\30FB\30AB\30E9\30FC')
,p_lov_return_value=>'Solid'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27065713041176829.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30B0\30E9\30C7\30FC\30B7\30E7\30F3')
,p_lov_return_value=>'Gradient'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27065905189176829.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30A4\30E1\30FC\30B8')
,p_lov_return_value=>'Image'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_calendar
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(167751427396757234.4009)
,p_lov_name=>'FLASH_CHART_5_CALENDAR'
,p_lov_query=>'.'||wwv_flow_api.id(167751427396757234.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167751721461757249.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\65E5\66DC\65E5')
,p_lov_return_value=>'sunday'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167751900833757255.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6708\66DC\65E5')
,p_lov_return_value=>'monday'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167752111992757255.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\706B\66DC\65E5')
,p_lov_return_value=>'tuesday'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167752312095757255.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6C34\66DC\65E5')
,p_lov_return_value=>'wednesday'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167752531095757255.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\6728\66DC\65E5')
,p_lov_return_value=>'thursday'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167752706198757255.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\91D1\66DC\65E5')
,p_lov_return_value=>'friday'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167752920565757255.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\571F\66DC\65E5')
,p_lov_return_value=>'saturday'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_color_level
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(8942527167044496.4009)
,p_lov_name=>'FLASH_CHART_5_COLOR_LEVEL'
,p_lov_query=>'.'||wwv_flow_api.id(8942527167044496.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8942823974044500.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30B7\30EA\30FC\30BA')
,p_lov_return_value=>'S'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8943023534044502.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30DD\30A4\30F3\30C8')
,p_lov_return_value=>'P'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_datagrid_date
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(195059525909315642.4009)
,p_lov_name=>'FLASH_CHART_5_DATAGRID_DATE'
,p_lov_query=>'.'||wwv_flow_api.id(195059525909315642.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195059700304315735.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'12-JAN-04'
,p_lov_return_value=>'%dd-%MMM-%yy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195059917958315829.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'12-JAN-2004'
,p_lov_return_value=>'%dd-%MMM-%yyyy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195060111470315829.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'12-JAN'
,p_lov_return_value=>'%dd-%MMM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195060329829315829.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'04-JAN-12'
,p_lov_return_value=>'%yy-%MMM-%dd'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195060503814315829.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'2004-01-12'
,p_lov_return_value=>'%yyyy-%MM-%dd'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195060712087315829.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Monday, 12 January, 2004'
,p_lov_return_value=>'%dddd,%dd %MMMM,%yyyy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195060932146315829.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'12-JAN-2004 14:30'
,p_lov_return_value=>'%dd-%MMM-%yyyy %HH:%mm'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195061105731315829.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'12-JAN-2004 14:30:00'
,p_lov_return_value=>'%dd-%MMM-%yyyy %HH:%mm:%ss'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195061309822315830.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'12-JAN-2004 02:30PM'
,p_lov_return_value=>'%dd-%MMM-%yyyy %HH:%mm%tt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195061513238315830.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('1\6708')
,p_lov_return_value=>'%MMMM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_datagrid_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(194477523762842263.4009)
,p_lov_name=>'FLASH_CHART_5_DATAGRID_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(194477523762842263.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(194477703078842330.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'ID'
,p_lov_return_value=>'ID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(194477920571842332.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\540D\524D')
,p_lov_return_value=>'NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(194478120588842333.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\958B\59CB\65E5')
,p_lov_return_value=>'START'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(194478328809842333.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\7D42\4E86\65E5')
,p_lov_return_value=>'END'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_dateformats
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(195087727809628456.4009)
,p_lov_name=>'FLASH_CHART_5_DATEFORMATS'
,p_lov_query=>'.'||wwv_flow_api.id(195087727809628456.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195087913846628458.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'DD-MON-RR'
,p_lov_return_value=>'%dd-%MMM-%yy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195088114969628458.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'DD-MON-YYYY'
,p_lov_return_value=>'%dd-%MMM-%yyyy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195088303046628458.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'DD-MON'
,p_lov_return_value=>'%dd-%MMM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195088516755628458.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'RR-MON-DD'
,p_lov_return_value=>'%yy-%MMM-%dd'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195088726984628458.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'YYYY-MM-DD'
,p_lov_return_value=>'%yyyy-%MM-%dd'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195088919076628458.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'fmDay, fmDD fmMonth, YYYY'
,p_lov_return_value=>'%dddd,%dd %MMMM,%yyyy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195089123845628458.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'DD-MON-YYYY HH24:MI'
,p_lov_return_value=>'%dd-%MMM-%yyyy %HH:%mm'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195089314360628458.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'DD-MON-YYYY HH24:MI:SS'
,p_lov_return_value=>'%dd-%MMM-%yyyy %HH:%mm:%ss'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195089530214628462.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'DD-MON-YYYY HH:MIPM'
,p_lov_return_value=>'%dd-%MMM-%yyyy %HH:%mm%tt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(195089722291628462.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6708')
,p_lov_return_value=>'%MMMM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_date_masks
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(196277010994654797.4009)
,p_lov_name=>'FLASH_CHART_5_DATE_MASKS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'from   wwv_flow_chart_format_masks'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_display_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(40416213321432885.4009)
,p_lov_name=>'FLASH_CHART_5_DISPLAY_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(40416213321432885.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40416512504432895.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30D2\30F3\30C8')
,p_lov_return_value=>'HINTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40416724395432898.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5024')
,p_lov_return_value=>'VALUES'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40416904802432898.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30E9\30D9\30EB')
,p_lov_return_value=>'LABELS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40417106936432898.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30DE\30FC\30AB\30FC')
,p_lov_return_value=>'MARKER'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40417318283432898.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30B7\30EA\30FC\30BA\3054\3068\306B\30B0\30EB\30FC\30D7\5316')
,p_lov_return_value=>'GROUPSERIES'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40417514316432898.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\4E3B\8981\76EE\76DB')
,p_lov_return_value=>'MAJORTICKS'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40417727141432898.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\88DC\52A9\76EE\76DB')
,p_lov_return_value=>'MINORTICKS'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40417916559432898.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\76EE\76DB\306E\30E9\30D9\30EB')
,p_lov_return_value=>'TICKLABELS'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42282826981395415.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\8907\6570Y\8EF8')
,p_lov_return_value=>'MULTIY'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42284721711488468.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8907\6570X\8EF8')
,p_lov_return_value=>'MULTIX'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46877015989914423.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('X\8EF8\30B9\30B1\30FC\30EB\306E\53CD\8EE2')
,p_lov_return_value=>'INVERTX'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46877221877916051.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('Y\8EF8\30B9\30B1\30FC\30EB\306E\53CD\8EE2')
,p_lov_return_value=>'INVERTY'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46877430534918597.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\30B9\30B1\30FC\30EB\306E\53CD\8EE2')
,p_lov_return_value=>'INVERTS'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(185909817505656653.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\30BA\30FC\30E0\30FB\30D1\30CD\30EB')
,p_lov_return_value=>'ZOOM'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'754'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(185910022007657893.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D1\30CD\30EB')
,p_lov_return_value=>'NAV'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'754'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7255223306619066.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\30AA\30FC\30D0\30FC\30EC\30A4Y\8EF8')
,p_lov_return_value=>'OVERLAY'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7255402312622454.4009)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\30BD\30FC\30C8\6E08\30AA\30FC\30D0\30FC\30EC\30A4Y\8EF8')
,p_lov_return_value=>'SORTOVER'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244795630370035440.4009)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\30B9\30DE\30FC\30C8\81EA\52D5\8A08\7B97\30E2\30FC\30C9')
,p_lov_return_value=>'SMART'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'832'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_gallery
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(32898919014588430.4009)
,p_lov_name=>'FLASH_CHART_5_GALLERY'
,p_lov_query=>'.'||wwv_flow_api.id(32898919014588430.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(32899218341588433.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5217')
,p_lov_return_value=>'COLUMN'
,p_lov_template=>'#DISPLAY_VALUE#|chart-bar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(32899416393588433.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6A2A\68D2')
,p_lov_return_value=>'BAR'
,p_lov_template=>'#DISPLAY_VALUE#|chart-column'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(32899601111588433.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5186\304A\3088\3073\30C9\30FC\30CA\30C4')
,p_lov_return_value=>'PIE'
,p_lov_template=>'#DISPLAY_VALUE#|chart-pie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(32899815981588433.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6563\5E03')
,p_lov_return_value=>'DOT'
,p_lov_template=>'#DISPLAY_VALUE#|chart-scatter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(32900002645588433.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\6298\308C\7DDA')
,p_lov_return_value=>'LINE'
,p_lov_template=>'#DISPLAY_VALUE#|chart-line'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(33171805415755027.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\30ED\30FC\30BD\30AF\8DB3')
,p_lov_return_value=>'CANDLE'
,p_lov_template=>'#DISPLAY_VALUE#|chart-stock'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(32900401409588433.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\30B2\30FC\30B8')
,p_lov_return_value=>'GAUGE'
,p_lov_template=>'#DISPLAY_VALUE#|chart-dial'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(47491217400696746.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\30AC\30F3\30C8')
,p_lov_return_value=>'GANTT'
,p_lov_template=>'#DISPLAY_VALUE#|chart-gantt'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_user_interface_dev.supports_feature ( ',
'    p_user_interface_id => :P259_USER_INTERFACE_ID,',
'    p_name              => ''FLASH_CHART'' ) and :P751_CHART_RENDERING = ''FLASH_PREFERRED'''))
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_gallery_r
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(46367306318745314.4009)
,p_lov_name=>'FLASH_CHART_5_GALLERY_R'
,p_lov_query=>'.'||wwv_flow_api.id(46367306318745314.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46367616135745320.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5217')
,p_lov_return_value=>'COLUMN'
,p_lov_template=>'#DISPLAY_VALUE#|chart-bar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46367831108745322.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6A2A\68D2')
,p_lov_return_value=>'BAR'
,p_lov_template=>'#DISPLAY_VALUE#|chart-column'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46368027574745322.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5186\304A\3088\3073\30C9\30FC\30CA\30C4')
,p_lov_return_value=>'PIE'
,p_lov_template=>'#DISPLAY_VALUE#|chart-pie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46368229530745322.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6563\5E03')
,p_lov_return_value=>'DOT'
,p_lov_template=>'#DISPLAY_VALUE#|chart-scatter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46368400264745323.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\6298\308C\7DDA')
,p_lov_return_value=>'LINE'
,p_lov_template=>'#DISPLAY_VALUE#|chart-line'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46368810648745323.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\30ED\30FC\30BD\30AF\8DB3')
,p_lov_return_value=>'CANDLE'
,p_lov_template=>'#DISPLAY_VALUE#|chart-stock'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46369029646745323.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\30B2\30FC\30B8')
,p_lov_return_value=>'GAUGE'
,p_lov_template=>'#DISPLAY_VALUE#|chart-dial'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(47511030775041135.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\30AC\30F3\30C8')
,p_lov_return_value=>'GANTT'
,p_lov_template=>'#DISPLAY_VALUE#|chart-gantt'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P761_CHART_RENDERING'
,p_lov_disp_cond2=>'FLASH_PREFERRED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46369207145745323.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30DE\30C3\30D7')
,p_lov_return_value=>'Map'
,p_lov_template=>'#DISPLAY_VALUE#|native-flash-map'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_gantt_marker
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(170316517085437889.4009)
,p_lov_name=>'FLASH_CHART_5_GANTT_MARKER'
,p_lov_query=>'.'||wwv_flow_api.id(170316517085437889.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170630725822638863.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306A\3057')
,p_lov_return_value=>'None'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170316803718437945.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\77E2\5370')
,p_lov_return_value=>'Arrow'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170317012698437949.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5186')
,p_lov_return_value=>'Circle'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170317212370437949.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\4E0B\90E8\534A\5186')
,p_lov_return_value=>'HalfBottomCircle'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170317408014437949.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\4E2D\592E\534A\5186')
,p_lov_return_value=>'HalfCenterCircle'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170317608882437949.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\4E0A\90E8\534A\5186')
,p_lov_return_value=>'HalfTopCircle'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170317808789437950.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\3072\3057\5F62')
,p_lov_return_value=>'Rhomb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170318015444437950.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\4E0B\90E8\7D30\5186')
,p_lov_return_value=>'ThinBottomCircle'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170318217529437950.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\4E2D\592E\7D30\5186')
,p_lov_return_value=>'ThinCenterCircle'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170318407925437951.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E0A\90E8\7D30\5186')
,p_lov_return_value=>'ThinTopCircle'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_gantt_shape
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(170321313416521984.4009)
,p_lov_name=>'FLASH_CHART_5_GANTT_SHAPE'
,p_lov_query=>'.'||wwv_flow_api.id(170321313416521984.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170321618956521986.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5B8C\5168')
,p_lov_return_value=>'Full'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170321829619521987.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4E0B\90E8\534A')
,p_lov_return_value=>'HalfBottom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170322016474521987.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\4E2D\592E\534A')
,p_lov_return_value=>'HalfCenter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170322213728521987.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\4E0A\90E8\534A')
,p_lov_return_value=>'HalfTop'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170322425398521987.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\4E0B\90E8\7D30')
,p_lov_return_value=>'ThinBottom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170322606143521987.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\4E2D\592E\7D30')
,p_lov_return_value=>'ThinCenter'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170322817287521987.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\4E0A\90E8\7D30')
,p_lov_return_value=>'ThinTop'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_gauge_frame
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(40095410367765328.4009)
,p_lov_name=>'FLASH_CHART_5_GAUGE_FRAME'
,p_lov_query=>'.'||wwv_flow_api.id(40095410367765328.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40095700539765392.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\81EA\52D5')
,p_lov_return_value=>'Auto'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40095915029765396.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5186\5F62')
,p_lov_return_value=>'Circular'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40096106509765397.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\9577\65B9\5F62')
,p_lov_return_value=>'Rectangular'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40096304791765397.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\81EA\52D5\9577\65B9\5F62')
,p_lov_return_value=>'AutoRectangular'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_gauge_pointer
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(38964720861433672.4009)
,p_lov_name=>'FLASH_CHART_5_GAUGE_POINTER'
,p_lov_query=>'.'||wwv_flow_api.id(38964720861433672.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38965003943433704.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30D0\30FC')
,p_lov_return_value=>'bar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38965219428433705.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30CE\30D6')
,p_lov_return_value=>'knob'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38965402187433705.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30DE\30FC\30AB\30FC')
,p_lov_return_value=>'marker'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38965605310433705.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\91DD')
,p_lov_return_value=>'needle'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38965809802433705.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\7BC4\56F2\30D0\30FC')
,p_lov_return_value=>'rangeBar'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_grid
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(30413430612205603.4009)
,p_lov_name=>'FLASH_CHART_5_GRID'
,p_lov_query=>'.'||wwv_flow_api.id(30413430612205603.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30413707136205609.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306A\3057')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30413912841205612.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('X\8EF8')
,p_lov_return_value=>'X'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30414119346205612.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Y\8EF8')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30414322290205612.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\4E21\65B9')
,p_lov_return_value=>'B'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_label_position
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(40392521803647208.4009)
,p_lov_name=>'FLASH_CHART_5_LABEL_POSITION'
,p_lov_query=>'.'||wwv_flow_api.id(40392521803647208.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40392830124647218.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4E2D\592E')
,p_lov_return_value=>'Center'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P754_CHART_TYPE not in (''2DPie'',''3DPie'',''2DDoughnut'')'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40393010743647221.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5185\5074')
,p_lov_return_value=>'Inside'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40393209404647221.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5916\5074')
,p_lov_return_value=>'Outside'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_legend
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(27068118314273560.4009)
,p_lov_name=>'FLASH_CHART_5_LEGEND'
,p_lov_query=>'.'||wwv_flow_api.id(27068118314273560.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27068418954273563.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306A\3057')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27068621043273564.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5DE6')
,p_lov_return_value=>'Left'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27068808116273564.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\53F3')
,p_lov_return_value=>'Right'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27069024731273564.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30C8\30C3\30D7')
,p_lov_return_value=>'Top'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27069221060273564.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\4E0B')
,p_lov_return_value=>'Bottom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27069407333273564.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30D5\30ED\30FC\30C8')
,p_lov_return_value=>'Float'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_legend_items
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187421412858648000.4009)
,p_lov_name=>'FLASH_CHART_5_LEGEND_ITEMS'
,p_lov_query=>'.'||wwv_flow_api.id(187421412858648000.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187421626877648001.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30B7\30EA\30FC\30BA')
,p_lov_return_value=>'Series'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187421828017648001.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30DD\30A4\30F3\30C8')
,p_lov_return_value=>'Points'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_legend_layout
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(34920603745925251.4009)
,p_lov_name=>'FLASH_CHART_5_LEGEND_LAYOUT'
,p_lov_query=>'.'||wwv_flow_api.id(34920603745925251.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34920920104925264.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5782\76F4')
,p_lov_return_value=>'V'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(34921107457925269.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6C34\5E73')
,p_lov_return_value=>'H'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_map_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187603821884562133.4009)
,p_lov_name=>'FLASH_CHART_5_MAP_COLUMNS'
,p_lov_query=>'.'||wwv_flow_api.id(187603821884562133.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187604014790562145.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'ADM1_CODE'
,p_lov_return_value=>'ADM1_CODE'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'(:P832_MAP_SOURCE_ID in (2,14,23,29))'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187604231151562149.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'CENTROID_X'
,p_lov_return_value=>'CENTROID_X'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187604400104562149.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'CENTROID_Y'
,p_lov_return_value=>'CENTROID_Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187604603098562149.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'FIPS'
,p_lov_return_value=>'FIPS'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P832_MAP_SOURCE_ID in (154,155,187,188,189,190,191,192,193,194,195)'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187604830082562149.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'GMI_ADMIN'
,p_lov_return_value=>'GMI_ADMIN'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P832_MAP_SOURCE_ID in (156,157,158)'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187605013659562149.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'HSHOLD_1_M'
,p_lov_return_value=>'HSHOLD_1_M'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P832_MAP_SOURCE_ID = 160'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187605213907562149.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'MOBILEHOME'
,p_lov_return_value=>'MOBILEHOME'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P832_MAP_SOURCE_ID = 160'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187605408377562149.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'POP1990'
,p_lov_return_value=>'POP1990'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P832_MAP_SOURCE_ID = 160'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187605619980562149.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'POP90_SQMI'
,p_lov_return_value=>'POP90_SQMI'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P832_MAP_SOURCE_ID = 160'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187605817864562149.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'REGION_ID'
,p_lov_return_value=>'REGION_ID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187606014436562150.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'REGION_NAME'
,p_lov_return_value=>'REGION_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187606204387562150.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'STATE_FIPS'
,p_lov_return_value=>'STATE_FIPS'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P832_MAP_SOURCE_ID in (160,161,162,163,164,178,179,180,181,182,183,184,185,186,196,197,198,199)'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187606412875562150.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'SUB_REGION'
,p_lov_return_value=>'SUB_REGION'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P832_MAP_SOURCE_ID = 160'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187606629301562150.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'WHITE'
,p_lov_return_value=>'WHITE'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':P832_MAP_SOURCE_ID = 160'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_map_files
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(178653106720595398.4009)
,p_lov_name=>'FLASH_CHART_5_MAP_FILES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select map_file_path d, id r',
'from   wwv_flow_flash_map_files',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_map_grid
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187841324017083778.4009)
,p_lov_name=>'FLASH_CHART_5_MAP_GRID'
,p_lov_query=>'.'||wwv_flow_api.id(187841324017083778.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187841521746083780.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306A\3057')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(257100426532331835.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\7DDA\306A\3057')
,p_lov_return_value=>'G'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187841732271083780.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\7D4C\5EA6')
,p_lov_return_value=>'X'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187841919790083780.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\7DEF\5EA6')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187842131775083780.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\4E21\65B9')
,p_lov_return_value=>'B'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_map_labels
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(180103824898023047.4009)
,p_lov_name=>'FLASH_CHART_5_MAP_LABELS'
,p_lov_query=>'.'||wwv_flow_api.id(180103824898023047.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180104029265023056.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5E38\6642')
,p_lov_return_value=>'Always'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180104211236023057.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\91CD\8907\306A\3057')
,p_lov_return_value=>'NonOverlap'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180104415276023057.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\5883\754C')
,p_lov_return_value=>'RegionBounds'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180104623954023057.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3\5883\754C\306E\91CD\8907\306A\3057')
,p_lov_return_value=>'RegionBoundsNonOverlap'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_map_name
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6379612402602761.4009)
,p_lov_name=>'FLASH_CHART_5_MAP_NAME'
,p_lov_query=>'.'||wwv_flow_api.id(6379612402602761.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6379914797602762.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30EB\30D0\30CB\30A2')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6380119863602763.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30AA\30FC\30B9\30C8\30EA\30A2(\7B2C2\30EC\30D9\30EB)')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6380322565602764.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30AA\30FC\30B9\30C8\30EA\30A2')
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6380509931602764.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30D9\30EB\30AE\30FC')
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6380702049602764.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\30D9\30EB\30AE\30FC(\7B2C2\30EC\30D9\30EB)')
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6380918632602764.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30D6\30EB\30AC\30EA\30A2')
,p_lov_return_value=>'6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6381116795602764.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\30D9\30E9\30EB\30FC\30B7')
,p_lov_return_value=>'7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6381302846602764.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\30C1\30A7\30B3\5171\548C\56FD')
,p_lov_return_value=>'8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6381524076602764.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\30C7\30F3\30DE\30FC\30AF')
,p_lov_return_value=>'9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6381721412602764.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30D5\30A3\30F3\30E9\30F3\30C9')
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6381900034602764.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\30D5\30E9\30F3\30B9')
,p_lov_return_value=>'11'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6382129053602764.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\30D5\30E9\30F3\30B9(\7B2C2\30EC\30D9\30EB)')
,p_lov_return_value=>'12'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6382303124602765.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\30C9\30A4\30C4')
,p_lov_return_value=>'13'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6382506686602765.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\30C9\30A4\30C4(\7B2C2\30EC\30D9\30EB)')
,p_lov_return_value=>'14'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6382727097602765.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\30AE\30EA\30B7\30E3')
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6382921059605232.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\30CF\30F3\30AC\30EA\30FC')
,p_lov_return_value=>'16'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6383125215606457.4009)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\30A2\30A4\30B9\30E9\30F3\30C9')
,p_lov_return_value=>'17'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6383329024607529.4009)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\30A2\30A4\30EB\30E9\30F3\30C9')
,p_lov_return_value=>'18'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6383500066608631.4009)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('\30A4\30BF\30EA\30A2')
,p_lov_return_value=>'19'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6383703875609767.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\30A4\30BF\30EA\30A2(\7B2C2\30EC\30D9\30EB)')
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6383907684610831.4009)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('\30AA\30E9\30F3\30C0')
,p_lov_return_value=>'21'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6384110455611610.4009)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>unistr('\30CE\30EB\30A6\30A7\30FC')
,p_lov_return_value=>'22'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6384313918612646.4009)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>unistr('\30CE\30EB\30A6\30A7\30FC(\7B2C2\30EC\30D9\30EB)')
,p_lov_return_value=>'23'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6384517035613481.4009)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>unistr('\30DD\30FC\30E9\30F3\30C9')
,p_lov_return_value=>'24'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6384721537614834.4009)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('\30DD\30EB\30C8\30AC\30EB')
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6384927077616375.4009)
,p_lov_disp_sequence=>26
,p_lov_disp_value=>unistr('\30EB\30FC\30DE\30CB\30A2')
,p_lov_return_value=>'26'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6385129848617226.4009)
,p_lov_disp_sequence=>27
,p_lov_disp_value=>unistr('\30B9\30DA\30A4\30F3')
,p_lov_return_value=>'27'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6385332618618066.4009)
,p_lov_disp_sequence=>28
,p_lov_disp_value=>unistr('\30B9\30A6\30A7\30FC\30C7\30F3')
,p_lov_return_value=>'28'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6385505045619489.4009)
,p_lov_disp_sequence=>29
,p_lov_disp_value=>unistr('\30B9\30A6\30A7\30FC\30C7\30F3(\7B2C2\30EC\30D9\30EB)')
,p_lov_return_value=>'29'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6385710239621041.4009)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\30B9\30A4\30B9')
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6385913703621993.4009)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>unistr('UK - \30A4\30AE\30EA\30B9')
,p_lov_return_value=>'31'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6386116819622912.4009)
,p_lov_disp_sequence=>32
,p_lov_disp_value=>unistr('UK - \5317\30A2\30A4\30EB\30E9\30F3\30C9')
,p_lov_return_value=>'32'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6386319936623793.4009)
,p_lov_disp_sequence=>33
,p_lov_disp_value=>unistr('UK - \30B9\30B3\30C3\30C8\30E9\30F3\30C9')
,p_lov_return_value=>'33'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6386522706624599.4009)
,p_lov_disp_sequence=>34
,p_lov_disp_value=>unistr('UK - \30A6\30A7\30FC\30EB\30BA')
,p_lov_return_value=>'34'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6386726170625584.4009)
,p_lov_disp_sequence=>35
,p_lov_disp_value=>unistr('\30A6\30AF\30E9\30A4\30CA')
,p_lov_return_value=>'35'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6386929979626704.4009)
,p_lov_disp_sequence=>36
,p_lov_disp_value=>unistr('\30A4\30AE\30EA\30B9')
,p_lov_return_value=>'36'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6387100674627740.4009)
,p_lov_disp_sequence=>37
,p_lov_disp_value=>unistr('\30A2\30EB\30B8\30A7\30EA\30A2')
,p_lov_return_value=>'37'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6387304137628679.4009)
,p_lov_disp_sequence=>38
,p_lov_disp_value=>unistr('\30A2\30F3\30B4\30E9')
,p_lov_return_value=>'38'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6387507946629850.4009)
,p_lov_disp_sequence=>39
,p_lov_disp_value=>unistr('\30D9\30CA\30F3')
,p_lov_return_value=>'39'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6387711063630753.4009)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\30DC\30C4\30EF\30CA')
,p_lov_return_value=>'40'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6387926909654189.4009)
,p_lov_disp_sequence=>41
,p_lov_disp_value=>unistr('\30D6\30EB\30AD\30CA\30D5\30A1\30BD')
,p_lov_return_value=>'41'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6388129333654920.4009)
,p_lov_disp_sequence=>42
,p_lov_disp_value=>unistr('\30D6\30EB\30F3\30B8')
,p_lov_return_value=>'42'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6388332103655687.4009)
,p_lov_disp_sequence=>43
,p_lov_disp_value=>unistr('\30AB\30E1\30EB\30FC\30F3')
,p_lov_return_value=>'43'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6388502106656494.4009)
,p_lov_disp_sequence=>44
,p_lov_disp_value=>unistr('\4E2D\592E\30A2\30D5\30EA\30AB\5171\548C\56FD')
,p_lov_return_value=>'44'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6388704530657177.4009)
,p_lov_disp_sequence=>45
,p_lov_disp_value=>unistr('\30C1\30E3\30C9')
,p_lov_return_value=>'45'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6388908686658392.4009)
,p_lov_disp_sequence=>46
,p_lov_disp_value=>unistr('\30B3\30F3\30B4')
,p_lov_return_value=>'46'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6389111802659346.4009)
,p_lov_disp_sequence=>47
,p_lov_disp_value=>unistr('\30B8\30D6\30C1')
,p_lov_return_value=>'47'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6389314573660129.4009)
,p_lov_disp_sequence=>48
,p_lov_disp_value=>unistr('\30A8\30B8\30D7\30C8')
,p_lov_return_value=>'48'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6389517343660942.4009)
,p_lov_disp_sequence=>49
,p_lov_disp_value=>unistr('\8D64\9053\30AE\30CB\30A2')
,p_lov_return_value=>'49'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6389720806661909.4009)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\30A8\30EA\30C8\30EA\30A2')
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6389923577662723.4009)
,p_lov_disp_sequence=>51
,p_lov_disp_value=>unistr('\30A8\30C1\30AA\30D4\30A2')
,p_lov_return_value=>'51'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6390126694663619.4009)
,p_lov_disp_sequence=>52
,p_lov_disp_value=>unistr('\30AC\30DC\30F3')
,p_lov_return_value=>'52'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6390329810664494.4009)
,p_lov_disp_sequence=>53
,p_lov_disp_value=>unistr('\30AC\30F3\30D3\30A2')
,p_lov_return_value=>'53'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6390500159665413.4009)
,p_lov_disp_sequence=>54
,p_lov_disp_value=>unistr('\30AC\30FC\30CA')
,p_lov_return_value=>'54'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6390702930666237.4009)
,p_lov_disp_sequence=>55
,p_lov_disp_value=>unistr('\30AE\30CB\30A2')
,p_lov_return_value=>'55'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6390906009714444.4009)
,p_lov_disp_sequence=>56
,p_lov_disp_value=>unistr('\30AE\30CB\30A2\30D3\30B5\30A6')
,p_lov_return_value=>'56'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6391109472715419.4009)
,p_lov_disp_sequence=>57
,p_lov_disp_value=>unistr('\8C61\7259\6D77\5CB8')
,p_lov_return_value=>'57'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6391312242716192.4009)
,p_lov_disp_sequence=>58
,p_lov_disp_value=>unistr('\30B1\30CB\30A2')
,p_lov_return_value=>'58'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6391515013717040.4009)
,p_lov_disp_sequence=>59
,p_lov_disp_value=>unistr('\30EC\30BD\30C8')
,p_lov_return_value=>'59'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6391718129717880.4009)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\30EA\30D9\30EA\30A2')
,p_lov_return_value=>'60'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6391920554718620.4009)
,p_lov_disp_sequence=>61
,p_lov_disp_value=>unistr('\30DE\30C0\30AC\30B9\30AB\30EB')
,p_lov_return_value=>'61'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6392123324719361.4009)
,p_lov_disp_sequence=>62
,p_lov_disp_value=>unistr('\30DE\30E9\30A6\30A4')
,p_lov_return_value=>'62'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6392325748720057.4009)
,p_lov_disp_sequence=>63
,p_lov_disp_value=>unistr('\30DE\30EA')
,p_lov_return_value=>'63'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6392528172720785.4009)
,p_lov_disp_sequence=>64
,p_lov_disp_value=>unistr('\30E2\30FC\30EA\30BF\30CB\30A2')
,p_lov_return_value=>'64'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6392731289721703.4009)
,p_lov_disp_sequence=>65
,p_lov_disp_value=>unistr('\30E2\30ED\30C3\30B3')
,p_lov_return_value=>'65'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6392900945722431.4009)
,p_lov_disp_sequence=>66
,p_lov_disp_value=>unistr('\30E2\30B6\30F3\30D3\30FC\30AF')
,p_lov_return_value=>'66'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6393103716723203.4009)
,p_lov_disp_sequence=>67
,p_lov_disp_value=>unistr('\30CA\30DF\30D3\30A2')
,p_lov_return_value=>'67'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6393306140723950.4009)
,p_lov_disp_sequence=>68
,p_lov_disp_value=>unistr('\30CB\30B8\30A7\30FC\30EB')
,p_lov_return_value=>'68'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6393509257724799.4009)
,p_lov_disp_sequence=>69
,p_lov_disp_value=>unistr('\30CA\30A4\30B8\30A7\30EA\30A2')
,p_lov_return_value=>'69'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6393711681725524.4009)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\30EB\30EF\30F3\30C0')
,p_lov_return_value=>'70'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6393915144726534.4009)
,p_lov_disp_sequence=>71
,p_lov_disp_value=>unistr('\30BB\30CD\30AC\30EB')
,p_lov_return_value=>'71'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6394117914727321.4009)
,p_lov_disp_sequence=>72
,p_lov_disp_value=>unistr('\30B7\30A8\30E9\30EC\30AA\30CD')
,p_lov_return_value=>'72'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6394321377728320.4009)
,p_lov_disp_sequence=>73
,p_lov_disp_value=>unistr('\30BD\30DE\30EA\30A2')
,p_lov_return_value=>'73'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6394524148729090.4009)
,p_lov_disp_sequence=>74
,p_lov_disp_value=>unistr('\5357\30A2\30D5\30EA\30AB')
,p_lov_return_value=>'74'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6394726572729762.4009)
,p_lov_disp_sequence=>75
,p_lov_disp_value=>unistr('\30B9\30FC\30C0\30F3')
,p_lov_return_value=>'75'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6394928650730448.4009)
,p_lov_disp_sequence=>76
,p_lov_disp_value=>unistr('\30B9\30EF\30B8\30E9\30F3\30C9')
,p_lov_return_value=>'76'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6395132459731486.4009)
,p_lov_disp_sequence=>77
,p_lov_disp_value=>unistr('\30BF\30F3\30B6\30CB\30A2')
,p_lov_return_value=>'77'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6395302461732259.4009)
,p_lov_disp_sequence=>78
,p_lov_disp_value=>unistr('\30C8\30FC\30B4')
,p_lov_return_value=>'78'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6395509734734373.4009)
,p_lov_disp_sequence=>79
,p_lov_disp_value=>unistr('\30C1\30E5\30CB\30B8\30A2')
,p_lov_return_value=>'79'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6395712158735122.4009)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\30A6\30AC\30F3\30C0')
,p_lov_return_value=>'80'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6395914928735907.4009)
,p_lov_disp_sequence=>81
,p_lov_disp_value=>unistr('\30B6\30A4\30FC\30EB')
,p_lov_return_value=>'81'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6396117699736742.4009)
,p_lov_disp_sequence=>82
,p_lov_disp_value=>unistr('\30B6\30F3\30D3\30A2')
,p_lov_return_value=>'82'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6396322201738044.4009)
,p_lov_disp_sequence=>83
,p_lov_disp_value=>unistr('\30A2\30D5\30AC\30CB\30B9\30BF\30F3')
,p_lov_return_value=>'83'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6396525318738892.4009)
,p_lov_disp_sequence=>84
,p_lov_disp_value=>unistr('\30D0\30FC\30EC\30FC\30F3')
,p_lov_return_value=>'84'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6396728434739801.4009)
,p_lov_disp_sequence=>85
,p_lov_disp_value=>unistr('\30D0\30F3\30B0\30E9\30C7\30B7\30E5')
,p_lov_return_value=>'85'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6396930512740424.4009)
,p_lov_disp_sequence=>86
,p_lov_disp_value=>unistr('\30D6\30FC\30BF\30F3')
,p_lov_return_value=>'86'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6397112289744564.4009)
,p_lov_disp_sequence=>87
,p_lov_disp_value=>unistr('\30AB\30F3\30DC\30B8\30A2')
,p_lov_return_value=>'87'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6397314367745233.4009)
,p_lov_disp_sequence=>88
,p_lov_disp_value=>unistr('\4E2D\56FD')
,p_lov_return_value=>'88'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6397516791745906.4009)
,p_lov_disp_sequence=>89
,p_lov_disp_value=>unistr('\30AD\30D7\30ED\30B9')
,p_lov_return_value=>'89'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6397719561746717.4009)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\30A4\30F3\30C9')
,p_lov_return_value=>'90'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6397922678747596.4009)
,p_lov_disp_sequence=>91
,p_lov_disp_value=>unistr('\30A4\30F3\30C9\30CD\30B7\30A2')
,p_lov_return_value=>'91'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6398126141748627.4009)
,p_lov_disp_sequence=>92
,p_lov_disp_value=>unistr('\30A4\30E9\30F3')
,p_lov_return_value=>'92'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6398328912749363.4009)
,p_lov_disp_sequence=>93
,p_lov_disp_value=>unistr('\30A4\30E9\30AF')
,p_lov_return_value=>'93'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6398531682750178.4009)
,p_lov_disp_sequence=>94
,p_lov_disp_value=>unistr('\30A4\30B9\30E9\30A8\30EB')
,p_lov_return_value=>'94'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6398701685751000.4009)
,p_lov_disp_sequence=>95
,p_lov_disp_value=>unistr('\65E5\672C')
,p_lov_return_value=>'95'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6398905148752001.4009)
,p_lov_disp_sequence=>96
,p_lov_disp_value=>unistr('\65E5\672C(\7B2C2\30EC\30D9\30EB)')
,p_lov_return_value=>'96'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6399107572752709.4009)
,p_lov_disp_sequence=>97
,p_lov_disp_value=>unistr('\30E8\30EB\30C0\30F3')
,p_lov_return_value=>'97'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6399310342753518.4009)
,p_lov_disp_sequence=>98
,p_lov_disp_value=>unistr('\30AB\30B6\30D5\30B9\30BF\30F3')
,p_lov_return_value=>'98'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6399513459754359.4009)
,p_lov_disp_sequence=>99
,p_lov_disp_value=>unistr('\30AF\30A6\30A7\30FC\30C8')
,p_lov_return_value=>'99'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6399715883755132.4009)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\30E9\30AA\30B9')
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6399918654755940.4009)
,p_lov_disp_sequence=>101
,p_lov_disp_value=>unistr('\30EC\30D0\30CE\30F3')
,p_lov_return_value=>'101'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6400123502757329.4009)
,p_lov_disp_sequence=>102
,p_lov_disp_value=>unistr('\30DE\30EC\30FC\30B7\30A2')
,p_lov_return_value=>'102'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6400326619758153.4009)
,p_lov_disp_sequence=>103
,p_lov_disp_value=>unistr('\30E2\30EB\30B8\30D6')
,p_lov_return_value=>'103'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6400529389759041.4009)
,p_lov_disp_sequence=>104
,p_lov_disp_value=>unistr('\30E2\30F3\30B4\30EB')
,p_lov_return_value=>'104'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6400701469760409.4009)
,p_lov_disp_sequence=>105
,p_lov_disp_value=>unistr('\30DF\30E3\30F3\30DE\30FC')
,p_lov_return_value=>'105'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6400904586761290.4009)
,p_lov_disp_sequence=>106
,p_lov_disp_value=>unistr('\30CD\30D1\30FC\30EB')
,p_lov_return_value=>'106'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6401107703762181.4009)
,p_lov_disp_sequence=>107
,p_lov_disp_value=>unistr('\5317\671D\9BAE')
,p_lov_return_value=>'107'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6401310473762996.4009)
,p_lov_disp_sequence=>108
,p_lov_disp_value=>unistr('\30D1\30AD\30B9\30BF\30F3')
,p_lov_return_value=>'108'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6401514629764207.4009)
,p_lov_disp_sequence=>109
,p_lov_disp_value=>unistr('\30D5\30A3\30EA\30D4\30F3')
,p_lov_return_value=>'109'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6401717746765093.4009)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\30ED\30B7\30A2')
,p_lov_return_value=>'110'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6401920516765850.4009)
,p_lov_disp_sequence=>111
,p_lov_disp_value=>unistr('\30B5\30A6\30B8\30A2\30E9\30D3\30A2')
,p_lov_return_value=>'111'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6402122594766545.4009)
,p_lov_disp_sequence=>112
,p_lov_disp_value=>unistr('\97D3\56FD')
,p_lov_return_value=>'112'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6402325364767312.4009)
,p_lov_disp_sequence=>113
,p_lov_disp_value=>unistr('\30B7\30EA\30A2')
,p_lov_return_value=>'113'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6402527789767956.4009)
,p_lov_disp_sequence=>114
,p_lov_disp_value=>unistr('\53F0\6E7E')
,p_lov_return_value=>'114'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6402729866768616.4009)
,p_lov_disp_sequence=>115
,p_lov_disp_value=>unistr('\30BF\30A4')
,p_lov_return_value=>'115'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6402932291769309.4009)
,p_lov_disp_sequence=>116
,p_lov_disp_value=>unistr('\30C8\30EB\30B3')
,p_lov_return_value=>'116'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6403102986770249.4009)
,p_lov_disp_sequence=>117
,p_lov_disp_value=>unistr('\30A2\30E9\30D6\9996\9577\56FD\9023\90A6')
,p_lov_return_value=>'117'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6403306449771256.4009)
,p_lov_disp_sequence=>118
,p_lov_disp_value=>unistr('\30D9\30C8\30CA\30E0')
,p_lov_return_value=>'118'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6403615106773775.4009)
,p_lov_disp_sequence=>119
,p_lov_disp_value=>unistr('\30A4\30A8\30E1\30F3')
,p_lov_return_value=>'119'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6403832075778687.4009)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('\30D9\30EA\30FC\30BA')
,p_lov_return_value=>'120'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6404001731779423.4009)
,p_lov_disp_sequence=>121
,p_lov_disp_value=>unistr('\30AB\30CA\30C0')
,p_lov_return_value=>'121'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6404204156780141.4009)
,p_lov_disp_sequence=>122
,p_lov_disp_value=>unistr('\30B3\30B9\30BF\30EA\30AB')
,p_lov_return_value=>'122'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6404406580780820.4009)
,p_lov_disp_sequence=>123
,p_lov_disp_value=>unistr('\30AD\30E5\30FC\30D0')
,p_lov_return_value=>'123'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6404610735782031.4009)
,p_lov_disp_sequence=>124
,p_lov_disp_value=>unistr('\30A8\30EB\30B5\30EB\30D0\30C9\30EB')
,p_lov_return_value=>'124'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6404920086784697.4009)
,p_lov_disp_sequence=>125
,p_lov_disp_value=>unistr('\30B0\30EA\30FC\30F3\30E9\30F3\30C9')
,p_lov_return_value=>'125'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6405122510785431.4009)
,p_lov_disp_sequence=>126
,p_lov_disp_value=>unistr('\30B0\30A2\30C6\30DE\30E9')
,p_lov_return_value=>'126'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6405325280786163.4009)
,p_lov_disp_sequence=>127
,p_lov_disp_value=>unistr('\30CF\30A4\30C1')
,p_lov_return_value=>'127'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6405527704786896.4009)
,p_lov_disp_sequence=>128
,p_lov_disp_value=>unistr('\30DB\30F3\30B8\30E5\30E9\30B9')
,p_lov_return_value=>'128'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6405730821787832.4009)
,p_lov_disp_sequence=>129
,p_lov_disp_value=>unistr('\30B8\30E3\30DE\30A4\30AB')
,p_lov_return_value=>'129'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6406009135790965.4009)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>unistr('\30E1\30AD\30B7\30B3')
,p_lov_return_value=>'130'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6406212598792004.4009)
,p_lov_disp_sequence=>131
,p_lov_disp_value=>unistr('\30CB\30AB\30E9\30B0\30A2')
,p_lov_return_value=>'131'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6406415368792764.4009)
,p_lov_disp_sequence=>132
,p_lov_disp_value=>unistr('\30D1\30CA\30DE')
,p_lov_return_value=>'132'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6406617792793502.4009)
,p_lov_disp_sequence=>133
,p_lov_disp_value=>unistr('USA\3068\30AB\30CA\30C0')
,p_lov_return_value=>'133'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6406820909794375.4009)
,p_lov_disp_sequence=>134
,p_lov_disp_value=>unistr('USA\3001\30AB\30CA\30C0\304A\3088\3073\30E1\30AD\30B7\30B3')
,p_lov_return_value=>'134'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6407025065795595.4009)
,p_lov_disp_sequence=>135
,p_lov_disp_value=>unistr('\30A2\30EB\30BC\30F3\30C1\30F3')
,p_lov_return_value=>'135'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6407203725798854.4009)
,p_lov_disp_sequence=>136
,p_lov_disp_value=>unistr('\30DC\30EA\30D3\30A2')
,p_lov_return_value=>'136'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6407406495799654.4009)
,p_lov_disp_sequence=>137
,p_lov_disp_value=>unistr('\30D6\30E9\30B8\30EB')
,p_lov_return_value=>'137'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6407609612800619.4009)
,p_lov_disp_sequence=>138
,p_lov_disp_value=>unistr('\30C1\30EA')
,p_lov_return_value=>'138'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6407812383801401.4009)
,p_lov_disp_sequence=>139
,p_lov_disp_value=>unistr('\30B3\30ED\30F3\30D3\30A2')
,p_lov_return_value=>'139'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6408014807802126.4009)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>unistr('\30A8\30AF\30A2\30C9\30EB')
,p_lov_return_value=>'140'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6408216885802708.4009)
,p_lov_disp_sequence=>141
,p_lov_disp_value=>unistr('\30D5\30E9\30F3\30B9\9818\30AE\30A2\30CA')
,p_lov_return_value=>'141'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6408419309803371.4009)
,p_lov_disp_sequence=>142
,p_lov_disp_value=>unistr('\30AC\30A4\30A2\30CA')
,p_lov_return_value=>'142'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6408622079804235.4009)
,p_lov_disp_sequence=>143
,p_lov_disp_value=>unistr('\30D1\30E9\30B0\30A2\30A4')
,p_lov_return_value=>'143'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6408824503804846.4009)
,p_lov_disp_sequence=>144
,p_lov_disp_value=>unistr('\30DA\30EB\30FC')
,p_lov_return_value=>'144'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6409006626809211.4009)
,p_lov_disp_sequence=>145
,p_lov_disp_value=>unistr('\30B9\30EA\30CA\30E0')
,p_lov_return_value=>'145'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6409209397809995.4009)
,p_lov_disp_sequence=>146
,p_lov_disp_value=>unistr('\30A6\30EB\30B0\30A2\30A4')
,p_lov_return_value=>'146'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6409415284811704.4009)
,p_lov_disp_sequence=>147
,p_lov_disp_value=>unistr('\30D9\30CD\30BA\30A8\30E9')
,p_lov_return_value=>'147'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6409619224822254.4009)
,p_lov_disp_sequence=>148
,p_lov_disp_value=>unistr('\30A2\30D5\30EA\30AB')
,p_lov_return_value=>'148'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6409822687823338.4009)
,p_lov_disp_sequence=>149
,p_lov_disp_value=>unistr('\30A2\30E1\30EA\30AB\5927\9678')
,p_lov_return_value=>'149'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6410001001826500.4009)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>unistr('\30E8\30FC\30ED\30C3\30D1')
,p_lov_return_value=>'150'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6410204464827451.4009)
,p_lov_disp_sequence=>151
,p_lov_disp_value=>unistr('\30E8\30FC\30ED\30C3\30D1(\30ED\30B7\30A2\4EE5\5916)')
,p_lov_return_value=>'151'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6410501357902261.4009)
,p_lov_disp_sequence=>152
,p_lov_disp_value=>unistr('\5317\30A2\30E1\30EA\30AB')
,p_lov_return_value=>'152'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6410705512903497.4009)
,p_lov_disp_sequence=>153
,p_lov_disp_value=>unistr('\5357\30A2\30E1\30EA\30AB')
,p_lov_return_value=>'153'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6410909668904684.4009)
,p_lov_disp_sequence=>154
,p_lov_disp_value=>unistr('\4E16\754C')
,p_lov_return_value=>'154'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6411112439905512.4009)
,p_lov_disp_sequence=>155
,p_lov_disp_value=>unistr('\4E16\754C(\30B0\30EA\30FC\30F3\30E9\30F3\30C9\4EE5\5916)')
,p_lov_return_value=>'155'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6411316248906571.4009)
,p_lov_disp_sequence=>156
,p_lov_disp_value=>unistr('\30AA\30FC\30B9\30C8\30E9\30EA\30A2')
,p_lov_return_value=>'156'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6411521096907988.4009)
,p_lov_disp_sequence=>157
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30B8\30FC\30E9\30F3\30C9')
,p_lov_return_value=>'157'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6411725945909409.4009)
,p_lov_disp_sequence=>158
,p_lov_disp_value=>unistr('\30D1\30D7\30A2\30CB\30E5\30FC\30AE\30CB\30A2')
,p_lov_return_value=>'158'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6411931832911042.4009)
,p_lov_disp_sequence=>159
,p_lov_disp_value=>unistr('\30B7\30C9\30CB\30FC')
,p_lov_return_value=>'159'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6412103912912490.4009)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>unistr('USA(\5DDE)')
,p_lov_return_value=>'160'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6412307029913387.4009)
,p_lov_disp_sequence=>161
,p_lov_disp_value=>unistr('\4E2D\897F\90E8')
,p_lov_return_value=>'161'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6412510492914418.4009)
,p_lov_disp_sequence=>162
,p_lov_disp_value=>unistr('\5317\6771')
,p_lov_return_value=>'162'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6412713955915394.4009)
,p_lov_disp_sequence=>163
,p_lov_disp_value=>unistr('\5357')
,p_lov_return_value=>'163'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6412916725916222.4009)
,p_lov_disp_sequence=>164
,p_lov_disp_value=>unistr('\897F')
,p_lov_return_value=>'164'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6413121574917618.4009)
,p_lov_disp_sequence=>165
,p_lov_disp_value=>unistr('\4E2D\897F\90E8')
,p_lov_return_value=>'165'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6413324344918348.4009)
,p_lov_disp_sequence=>166
,p_lov_disp_value=>unistr('\5317\6771')
,p_lov_return_value=>'166'
);
end;
/
begin
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6413524044946694.4009)
,p_lov_disp_sequence=>167
,p_lov_disp_value=>unistr('\5357')
,p_lov_return_value=>'167'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6413727508947652.4009)
,p_lov_disp_sequence=>168
,p_lov_disp_value=>unistr('\897F')
,p_lov_return_value=>'168'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6413932009948947.4009)
,p_lov_disp_sequence=>169
,p_lov_disp_value=>unistr('\5317\4E2D\90E8\6771\5730\533A')
,p_lov_return_value=>'169'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6414102012949793.4009)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>unistr('\4E2D\5357\90E8\6771\5730\533A')
,p_lov_return_value=>'170'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6414312055952684.4009)
,p_lov_disp_sequence=>171
,p_lov_disp_value=>unistr('\4E2D\90E8\5927\897F\6D0B\6CBF\5CB8')
,p_lov_return_value=>'171'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6414515864953816.4009)
,p_lov_disp_sequence=>172
,p_lov_disp_value=>unistr('\5C71\5730')
,p_lov_return_value=>'172'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6414719327954727.4009)
,p_lov_disp_sequence=>173
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30A4\30F3\30B0\30E9\30F3\30C9')
,p_lov_return_value=>'173'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6414922790955735.4009)
,p_lov_disp_sequence=>174
,p_lov_disp_value=>unistr('\592A\5E73\6D0B')
,p_lov_return_value=>'174'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6415125214956520.4009)
,p_lov_disp_sequence=>175
,p_lov_disp_value=>unistr('\5357\90E8\5927\897F\6D0B\6CBF\5CB8')
,p_lov_return_value=>'175'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6415328331957399.4009)
,p_lov_disp_sequence=>176
,p_lov_disp_value=>unistr('\5317\4E2D\90E8\897F\5730\533A')
,p_lov_return_value=>'176'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6415530755958099.4009)
,p_lov_disp_sequence=>177
,p_lov_disp_value=>unistr('\4E2D\5357\90E8\897F\5730\533A')
,p_lov_return_value=>'177'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6415710108961562.4009)
,p_lov_disp_sequence=>178
,p_lov_disp_value=>unistr('\5317\4E2D\90E8\6771\5730\533A')
,p_lov_return_value=>'178'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6415927423966578.4009)
,p_lov_disp_sequence=>179
,p_lov_disp_value=>unistr('\4E2D\5357\90E8\6771\5730\533A')
,p_lov_return_value=>'179'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6416130886967573.4009)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>unistr('\4E2D\90E8\5927\897F\6D0B\6CBF\5CB8')
,p_lov_return_value=>'180'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6416300889968365.4009)
,p_lov_disp_sequence=>181
,p_lov_disp_value=>unistr('\5C71\5730')
,p_lov_return_value=>'181'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6416712663971785.4009)
,p_lov_disp_sequence=>182
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30A4\30F3\30B0\30E9\30F3\30C9')
,p_lov_return_value=>'182'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6416916126972759.4009)
,p_lov_disp_sequence=>183
,p_lov_disp_value=>unistr('\592A\5E73\6D0B')
,p_lov_return_value=>'183'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6417119243973633.4009)
,p_lov_disp_sequence=>184
,p_lov_disp_value=>unistr('\5357\90E8\5927\897F\6D0B\6CBF\5CB8')
,p_lov_return_value=>'184'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6417322013974419.4009)
,p_lov_disp_sequence=>185
,p_lov_disp_value=>unistr('\5317\4E2D\90E8\897F\5730\533A')
,p_lov_return_value=>'185'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6417524784975293.4009)
,p_lov_disp_sequence=>186
,p_lov_disp_value=>unistr('\4E2D\5357\90E8\897F\5730\533A')
,p_lov_return_value=>'186'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6417728247976282.4009)
,p_lov_disp_sequence=>187
,p_lov_disp_value=>unistr('\5317\4E2D\90E8\6771\5730\533A')
,p_lov_return_value=>'187'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6417900673977763.4009)
,p_lov_disp_sequence=>188
,p_lov_disp_value=>unistr('\4E2D\5357\90E8\6771\5730\533A')
,p_lov_return_value=>'188'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6418106561979433.4009)
,p_lov_disp_sequence=>189
,p_lov_disp_value=>unistr('\4E2D\90E8\5927\897F\6D0B\6CBF\5CB8')
,p_lov_return_value=>'189'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6418309331980281.4009)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>unistr('\5C71\5730')
,p_lov_return_value=>'190'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6446212465832689.4009)
,p_lov_disp_sequence=>191
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30A4\30F3\30B0\30E9\30F3\30C9')
,p_lov_return_value=>'191'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6418513833981550.4009)
,p_lov_disp_sequence=>192
,p_lov_disp_value=>unistr('\592A\5E73\6D0B')
,p_lov_return_value=>'192'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6418717642982659.4009)
,p_lov_disp_sequence=>193
,p_lov_disp_value=>unistr('\5357\90E8\5927\897F\6D0B\6CBF\5CB8')
,p_lov_return_value=>'193'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6418920759983524.4009)
,p_lov_disp_sequence=>194
,p_lov_disp_value=>unistr('\5317\4E2D\90E8\897F\5730\533A')
,p_lov_return_value=>'194'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6419123530984372.4009)
,p_lov_disp_sequence=>195
,p_lov_disp_value=>unistr('\4E2D\5357\90E8\897F\5730\533A')
,p_lov_return_value=>'195'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6419326993985404.4009)
,p_lov_disp_sequence=>196
,p_lov_disp_value=>unistr('\5DDE')
,p_lov_return_value=>'196'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6419531495986632.4009)
,p_lov_disp_sequence=>197
,p_lov_disp_value=>unistr('\30B5\30D6\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'197'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6419701843987581.4009)
,p_lov_disp_sequence=>198
,p_lov_disp_value=>unistr('\30A2\30E9\30B9\30AB\304A\3088\3073\30CF\30EF\30A4\4EE5\5916\306E\8AF8\5DDE')
,p_lov_return_value=>'198'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6419905306988549.4009)
,p_lov_disp_sequence=>199
,p_lov_disp_value=>unistr('\30A2\30E9\30B9\30AB')
,p_lov_return_value=>'199'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6420108077989359.4009)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>unistr('\30A2\30E9\30D0\30DE')
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6420311540990394.4009)
,p_lov_disp_sequence=>201
,p_lov_disp_value=>unistr('\30A2\30FC\30AB\30F3\30BD\30FC')
,p_lov_return_value=>'201'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6420518859020884.4009)
,p_lov_disp_sequence=>202
,p_lov_disp_value=>unistr('\30A2\30EA\30BE\30CA')
,p_lov_return_value=>'202'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6421825335590335.4009)
,p_lov_disp_sequence=>203
,p_lov_disp_value=>unistr('\30AB\30EA\30D5\30A9\30EB\30CB\30A2')
,p_lov_return_value=>'203'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6422031569592203.4009)
,p_lov_disp_sequence=>204
,p_lov_disp_value=>unistr('\30B3\30ED\30E9\30C9')
,p_lov_return_value=>'204'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6422202610593253.4009)
,p_lov_disp_sequence=>205
,p_lov_disp_value=>unistr('\30B3\30CD\30C1\30AB\30C3\30C8')
,p_lov_return_value=>'205'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6422405381594096.4009)
,p_lov_disp_sequence=>206
,p_lov_disp_value=>unistr('\30C7\30E9\30A6\30A7\30A2')
,p_lov_return_value=>'206'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6422608497594990.4009)
,p_lov_disp_sequence=>207
,p_lov_disp_value=>unistr('\30D5\30ED\30EA\30C0')
,p_lov_return_value=>'207'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6422811268595793.4009)
,p_lov_disp_sequence=>208
,p_lov_disp_value=>unistr('\30B8\30E7\30FC\30B8\30A2')
,p_lov_return_value=>'208'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6423015423596944.4009)
,p_lov_disp_sequence=>209
,p_lov_disp_value=>unistr('\30CF\30EF\30A4')
,p_lov_return_value=>'209'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6423218194597771.4009)
,p_lov_disp_sequence=>210
,p_lov_disp_value=>unistr('\30A2\30A4\30AA\30EF')
,p_lov_return_value=>'210'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6423421311598627.4009)
,p_lov_disp_sequence=>211
,p_lov_disp_value=>unistr('\30A2\30A4\30C0\30DB')
,p_lov_return_value=>'211'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6423624427599591.4009)
,p_lov_disp_sequence=>212
,p_lov_disp_value=>unistr('\30A4\30EA\30CE\30A4')
,p_lov_return_value=>'212'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6423828583600781.4009)
,p_lov_disp_sequence=>213
,p_lov_disp_value=>unistr('\30A4\30F3\30C7\30A3\30A2\30CA')
,p_lov_return_value=>'213'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6424031700601704.4009)
,p_lov_disp_sequence=>214
,p_lov_disp_value=>unistr('\30AB\30F3\30B6\30B9')
,p_lov_return_value=>'214'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6424202741602807.4009)
,p_lov_disp_sequence=>215
,p_lov_disp_value=>unistr('\30B1\30F3\30BF\30C3\30AD\30FC')
,p_lov_return_value=>'215'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6424405858603673.4009)
,p_lov_disp_sequence=>216
,p_lov_disp_value=>unistr('\30EB\30A4\30B8\30A2\30CA')
,p_lov_return_value=>'216'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6424609321604666.4009)
,p_lov_disp_sequence=>217
,p_lov_disp_value=>unistr('\30DE\30B5\30C1\30E5\30FC\30BB\30C3\30C4')
,p_lov_return_value=>'217'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6424812438605536.4009)
,p_lov_disp_sequence=>218
,p_lov_disp_value=>unistr('\30E1\30EA\30FC\30E9\30F3\30C9')
,p_lov_return_value=>'218'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6425014862606285.4009)
,p_lov_disp_sequence=>219
,p_lov_disp_value=>unistr('\30E1\30A4\30F3')
,p_lov_return_value=>'219'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6425217979607190.4009)
,p_lov_disp_sequence=>220
,p_lov_disp_value=>unistr('\30DF\30B7\30AC\30F3')
,p_lov_return_value=>'220'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6425421788608275.4009)
,p_lov_disp_sequence=>221
,p_lov_disp_value=>unistr('\30DF\30CD\30BD\30BF')
,p_lov_return_value=>'221'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6425624212608938.4009)
,p_lov_disp_sequence=>222
,p_lov_disp_value=>unistr('\30DF\30BA\30FC\30EA')
,p_lov_return_value=>'222'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6425826290609604.4009)
,p_lov_disp_sequence=>223
,p_lov_disp_value=>unistr('\30DF\30B7\30B7\30C3\30D4')
,p_lov_return_value=>'223'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6426030099610655.4009)
,p_lov_disp_sequence=>224
,p_lov_disp_value=>unistr('\30E2\30F3\30BF\30CA')
,p_lov_return_value=>'224'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6426232523611381.4009)
,p_lov_disp_sequence=>225
,p_lov_disp_value=>unistr('\30CE\30FC\30B9\30AB\30ED\30E9\30A4\30CA')
,p_lov_return_value=>'225'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6426402180612036.4009)
,p_lov_disp_sequence=>226
,p_lov_disp_value=>unistr('\30CE\30FC\30B9\30C0\30B3\30BF')
,p_lov_return_value=>'226'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6426604604612772.4009)
,p_lov_disp_sequence=>227
,p_lov_disp_value=>unistr('\30CD\30D6\30E9\30B9\30AB')
,p_lov_return_value=>'227'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6426808067613763.4009)
,p_lov_disp_sequence=>228
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30CF\30F3\30D7\30B7\30E3\30FC')
,p_lov_return_value=>'228'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6427011183614681.4009)
,p_lov_disp_sequence=>229
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30B8\30E3\30FC\30B8\30FC')
,p_lov_return_value=>'229'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6427213954615496.4009)
,p_lov_disp_sequence=>230
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30E1\30AD\30B7\30B3')
,p_lov_return_value=>'230'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6427416378616146.4009)
,p_lov_disp_sequence=>231
,p_lov_disp_value=>unistr('\30CD\30D0\30C0')
,p_lov_return_value=>'231'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6427620187617278.4009)
,p_lov_disp_sequence=>232
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30E8\30FC\30AF')
,p_lov_return_value=>'232'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6427822265617906.4009)
,p_lov_disp_sequence=>233
,p_lov_disp_value=>unistr('\30AA\30CF\30A4\30AA')
,p_lov_return_value=>'233'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6428025036618631.4009)
,p_lov_disp_sequence=>234
,p_lov_disp_value=>unistr('\30AA\30AF\30E9\30DB\30DE')
,p_lov_return_value=>'234'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6428228152619545.4009)
,p_lov_disp_sequence=>235
,p_lov_disp_value=>unistr('\30AA\30EC\30B4\30F3')
,p_lov_return_value=>'235'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6428431616620566.4009)
,p_lov_disp_sequence=>236
,p_lov_disp_value=>unistr('\30DA\30F3\30B7\30EB\30D0\30CB\30A2')
,p_lov_return_value=>'236'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6428601272621274.4009)
,p_lov_disp_sequence=>237
,p_lov_disp_value=>unistr('\30ED\30FC\30C9\30A2\30A4\30E9\30F3\30C9')
,p_lov_return_value=>'237'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6428804388622194.4009)
,p_lov_disp_sequence=>238
,p_lov_disp_value=>unistr('\30B5\30A6\30B9\30AB\30ED\30E9\30A4\30CA')
,p_lov_return_value=>'238'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6429007159622970.4009)
,p_lov_disp_sequence=>239
,p_lov_disp_value=>unistr('\30B5\30A6\30B9\30C0\30B3\30BF')
,p_lov_return_value=>'239'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6429210276623903.4009)
,p_lov_disp_sequence=>240
,p_lov_disp_value=>unistr('\30C6\30CD\30B7\30FC')
,p_lov_return_value=>'240'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6429413046624642.4009)
,p_lov_disp_sequence=>241
,p_lov_disp_value=>unistr('\30C6\30AD\30B5\30B9')
,p_lov_return_value=>'241'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6429615124625285.4009)
,p_lov_disp_sequence=>242
,p_lov_disp_value=>unistr('\30E6\30BF')
,p_lov_return_value=>'242'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6429817548625932.4009)
,p_lov_disp_sequence=>243
,p_lov_disp_value=>unistr('\30D0\30FC\30B8\30CB\30A2')
,p_lov_return_value=>'243'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6430020318626784.4009)
,p_lov_disp_sequence=>244
,p_lov_disp_value=>unistr('\30D0\30FC\30E2\30F3\30C8')
,p_lov_return_value=>'244'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6430223782627724.4009)
,p_lov_disp_sequence=>245
,p_lov_disp_value=>unistr('\30EF\30B7\30F3\30C8\30F3')
,p_lov_return_value=>'245'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6430426206628520.4009)
,p_lov_disp_sequence=>246
,p_lov_disp_value=>unistr('\30A6\30A3\30B9\30B3\30F3\30B7\30F3')
,p_lov_return_value=>'246'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6430628976629294.4009)
,p_lov_disp_sequence=>247
,p_lov_disp_value=>unistr('\30A6\30A7\30B9\30C8\30D0\30FC\30B8\30CB\30A2')
,p_lov_return_value=>'247'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6430831747630040.4009)
,p_lov_disp_sequence=>248
,p_lov_disp_value=>unistr('\30EF\30A4\30AA\30DF\30F3\30B0')
,p_lov_return_value=>'248'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6431002442631045.4009)
,p_lov_disp_sequence=>249
,p_lov_disp_value=>unistr('\30A2\30E9\30B9\30AB')
,p_lov_return_value=>'249'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6431205212631874.4009)
,p_lov_disp_sequence=>250
,p_lov_disp_value=>unistr('\30A2\30E9\30D0\30DE')
,p_lov_return_value=>'250'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6431407636632569.4009)
,p_lov_disp_sequence=>251
,p_lov_disp_value=>unistr('\30A2\30FC\30AB\30F3\30BD\30FC')
,p_lov_return_value=>'251'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6431610060633225.4009)
,p_lov_disp_sequence=>252
,p_lov_disp_value=>unistr('\30A2\30EA\30BE\30CA')
,p_lov_return_value=>'252'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6431812484633989.4009)
,p_lov_disp_sequence=>253
,p_lov_disp_value=>unistr('\30AB\30EA\30D5\30A9\30EB\30CB\30A2')
,p_lov_return_value=>'253'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6432014562634593.4009)
,p_lov_disp_sequence=>254
,p_lov_disp_value=>unistr('\30B3\30ED\30E9\30C9')
,p_lov_return_value=>'254'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6432216986635231.4009)
,p_lov_disp_sequence=>255
,p_lov_disp_value=>unistr('\30B3\30CD\30C1\30AB\30C3\30C8')
,p_lov_return_value=>'255'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6432419411636014.4009)
,p_lov_disp_sequence=>256
,p_lov_disp_value=>unistr('\30B3\30ED\30F3\30D3\30A2\7279\5225\533A')
,p_lov_return_value=>'256'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6432622181636763.4009)
,p_lov_disp_sequence=>257
,p_lov_disp_value=>unistr('\30C7\30E9\30A6\30A7\30A2')
,p_lov_return_value=>'257'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6432825298637626.4009)
,p_lov_disp_sequence=>258
,p_lov_disp_value=>unistr('\30D5\30ED\30EA\30C0')
,p_lov_return_value=>'258'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6433029107638725.4009)
,p_lov_disp_sequence=>259
,p_lov_disp_value=>unistr('\30B8\30E7\30FC\30B8\30A2')
,p_lov_return_value=>'259'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6433316771644712.4009)
,p_lov_disp_sequence=>260
,p_lov_disp_value=>unistr('\30CF\30EF\30A4')
,p_lov_return_value=>'260'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6433519888645598.4009)
,p_lov_disp_sequence=>261
,p_lov_disp_value=>unistr('\30A2\30A4\30AA\30EF')
,p_lov_return_value=>'261'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6433723005646491.4009)
,p_lov_disp_sequence=>262
,p_lov_disp_value=>unistr('\30A2\30A4\30C0\30DB')
,p_lov_return_value=>'262'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6433925775647270.4009)
,p_lov_disp_sequence=>263
,p_lov_disp_value=>unistr('\30A4\30EA\30CE\30A4')
,p_lov_return_value=>'263'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6434129238648240.4009)
,p_lov_disp_sequence=>264
,p_lov_disp_value=>unistr('\30A4\30F3\30C7\30A3\30A2\30CA')
,p_lov_return_value=>'264'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6434300626649506.4009)
,p_lov_disp_sequence=>265
,p_lov_disp_value=>unistr('\30AB\30F3\30B6\30B9')
,p_lov_return_value=>'265'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6434503396650271.4009)
,p_lov_disp_sequence=>266
,p_lov_disp_value=>unistr('\30B1\30F3\30BF\30C3\30AD\30FC')
,p_lov_return_value=>'266'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6434706167651109.4009)
,p_lov_disp_sequence=>267
,p_lov_disp_value=>unistr('\30EB\30A4\30B8\30A2\30CA')
,p_lov_return_value=>'267'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6434909630652089.4009)
,p_lov_disp_sequence=>268
,p_lov_disp_value=>unistr('\30DE\30B5\30C1\30E5\30FC\30BB\30C3\30C4')
,p_lov_return_value=>'268'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6435112400652881.4009)
,p_lov_disp_sequence=>269
,p_lov_disp_value=>unistr('\30E1\30EA\30FC\30E9\30F3\30C9')
,p_lov_return_value=>'269'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6435315517653815.4009)
,p_lov_disp_sequence=>270
,p_lov_disp_value=>unistr('\30E1\30A4\30F3')
,p_lov_return_value=>'270'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6435520712655265.4009)
,p_lov_disp_sequence=>271
,p_lov_disp_value=>unistr('\30DF\30B7\30AC\30F3')
,p_lov_return_value=>'271'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6435723482656115.4009)
,p_lov_disp_sequence=>272
,p_lov_disp_value=>unistr('\30DF\30CD\30BD\30BF')
,p_lov_return_value=>'272'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6435927291657182.4009)
,p_lov_disp_sequence=>273
,p_lov_disp_value=>unistr('\30DF\30BA\30FC\30EA')
,p_lov_return_value=>'273'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6436130408658089.4009)
,p_lov_disp_sequence=>274
,p_lov_disp_value=>unistr('\30DF\30B7\30B7\30C3\30D4')
,p_lov_return_value=>'274'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6436301103659095.4009)
,p_lov_disp_sequence=>275
,p_lov_disp_value=>unistr('\30E2\30F3\30BF\30CA')
,p_lov_return_value=>'275'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6436504912660121.4009)
,p_lov_disp_sequence=>276
,p_lov_disp_value=>unistr('\30CE\30FC\30B9\30AB\30ED\30E9\30A4\30CA')
,p_lov_return_value=>'276'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6436707683660966.4009)
,p_lov_disp_sequence=>277
,p_lov_disp_value=>unistr('\30CE\30FC\30B9\30C0\30B3\30BF')
,p_lov_return_value=>'277'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6436910800661847.4009)
,p_lov_disp_sequence=>278
,p_lov_disp_value=>unistr('\30CD\30D6\30E9\30B9\30AB')
,p_lov_return_value=>'278'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6437114609662940.4009)
,p_lov_disp_sequence=>279
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30CF\30F3\30D7\30B7\30E3\30FC')
,p_lov_return_value=>'279'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6437317379663805.4009)
,p_lov_disp_sequence=>280
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30B8\30E3\30FC\30B8\30FC')
,p_lov_return_value=>'280'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6437521535665016.4009)
,p_lov_disp_sequence=>281
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30E1\30AD\30B7\30B3')
,p_lov_return_value=>'281'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6437724998665960.4009)
,p_lov_disp_sequence=>282
,p_lov_disp_value=>unistr('\30CD\30D0\30C0')
,p_lov_return_value=>'282'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6437927769666769.4009)
,p_lov_disp_sequence=>283
,p_lov_disp_value=>unistr('\30CB\30E5\30FC\30E8\30FC\30AF')
,p_lov_return_value=>'283'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6438131578667883.4009)
,p_lov_disp_sequence=>284
,p_lov_disp_value=>unistr('\30AA\30CF\30A4\30AA')
,p_lov_return_value=>'284'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6438302273668870.4009)
,p_lov_disp_sequence=>285
,p_lov_disp_value=>unistr('\30AA\30AF\30E9\30DB\30DE')
,p_lov_return_value=>'285'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6438506429670091.4009)
,p_lov_disp_sequence=>286
,p_lov_disp_value=>unistr('\30AA\30EC\30B4\30F3')
,p_lov_return_value=>'286'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6438709199670851.4009)
,p_lov_disp_sequence=>287
,p_lov_disp_value=>unistr('\30DA\30F3\30B7\30EB\30D0\30CB\30A2')
,p_lov_return_value=>'287'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6438913355672026.4009)
,p_lov_disp_sequence=>288
,p_lov_disp_value=>unistr('\30D7\30A8\30EB\30C8\30EA\30B3')
,p_lov_return_value=>'288'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6439115779672813.4009)
,p_lov_disp_sequence=>289
,p_lov_disp_value=>unistr('\30ED\30FC\30C9\30A2\30A4\30E9\30F3\30C9')
,p_lov_return_value=>'289'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6439318896673632.4009)
,p_lov_disp_sequence=>290
,p_lov_disp_value=>unistr('\30B5\30A6\30B9\30AB\30ED\30E9\30A4\30CA')
,p_lov_return_value=>'290'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6439521666674490.4009)
,p_lov_disp_sequence=>291
,p_lov_disp_value=>unistr('\30B5\30A6\30B9\30C0\30B3\30BF')
,p_lov_return_value=>'291'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6439724090675188.4009)
,p_lov_disp_sequence=>292
,p_lov_disp_value=>unistr('\30C6\30CD\30B7\30FC')
,p_lov_return_value=>'292'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6439926514675912.4009)
,p_lov_disp_sequence=>293
,p_lov_disp_value=>unistr('\30C6\30AD\30B5\30B9')
,p_lov_return_value=>'293'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6440129631676744.4009)
,p_lov_disp_sequence=>294
,p_lov_disp_value=>unistr('\30E6\30BF')
,p_lov_return_value=>'294'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6440305175679169.4009)
,p_lov_disp_sequence=>295
,p_lov_disp_value=>unistr('\30D0\30FC\30B8\30CB\30A2')
,p_lov_return_value=>'295'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6440614871681927.4009)
,p_lov_disp_sequence=>296
,p_lov_disp_value=>unistr('\30D0\30FC\30E2\30F3\30C8')
,p_lov_return_value=>'296'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6440817642682738.4009)
,p_lov_disp_sequence=>297
,p_lov_disp_value=>unistr('\30EF\30B7\30F3\30C8\30F3')
,p_lov_return_value=>'297'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6441020758683673.4009)
,p_lov_disp_sequence=>298
,p_lov_disp_value=>unistr('\30A6\30A3\30B9\30B3\30F3\30B7\30F3')
,p_lov_return_value=>'298'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6441223875684583.4009)
,p_lov_disp_sequence=>299
,p_lov_disp_value=>unistr('\30A6\30A7\30B9\30C8\30D0\30FC\30B8\30CB\30A2')
,p_lov_return_value=>'299'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6441426992685416.4009)
,p_lov_disp_sequence=>300
,p_lov_disp_value=>unistr('\30EF\30A4\30AA\30DF\30F3\30B0')
,p_lov_return_value=>'300'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6441614309691244.4009)
,p_lov_disp_sequence=>301
,p_lov_disp_value=>unistr('\30E8\30FC\30ED\30C3\30D1')
,p_lov_return_value=>'301'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6441816734692002.4009)
,p_lov_disp_sequence=>302
,p_lov_disp_value=>unistr('\30A2\30D5\30EA\30AB')
,p_lov_return_value=>'302'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6442019158692665.4009)
,p_lov_disp_sequence=>303
,p_lov_disp_value=>unistr('\30A2\30B8\30A2')
,p_lov_return_value=>'303'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6442224352694209.4009)
,p_lov_disp_sequence=>304
,p_lov_disp_value=>unistr('\5317\30A2\30E1\30EA\30AB')
,p_lov_return_value=>'304'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6442428508695314.4009)
,p_lov_disp_sequence=>305
,p_lov_disp_value=>unistr('\5357\30A2\30E1\30EA\30AB')
,p_lov_return_value=>'305'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6442632664696558.4009)
,p_lov_disp_sequence=>306
,p_lov_disp_value=>unistr('\4E16\754C\304A\3088\3073\5927\9678\30DE\30C3\30D7')
,p_lov_return_value=>'306'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6442804051697763.4009)
,p_lov_disp_sequence=>307
,p_lov_disp_value=>unistr('\30AA\30BB\30A2\30CB\30A2')
,p_lov_return_value=>'307'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6443007514698778.4009)
,p_lov_disp_sequence=>308
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E0\30FB\30DE\30C3\30D7')
,p_lov_return_value=>'308'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6443210631699647.4009)
,p_lov_disp_sequence=>309
,p_lov_disp_value=>unistr('\30A2\30E1\30EA\30AB\5408\8846\56FD')
,p_lov_return_value=>'309'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6443417211701531.4009)
,p_lov_disp_sequence=>310
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'310'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6443619981702345.4009)
,p_lov_disp_sequence=>311
,p_lov_disp_value=>unistr('\5168\30EA\30FC\30B8\30E7\30F3\306E\5DDE\30DE\30C3\30D7')
,p_lov_return_value=>'311'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6443822059702995.4009)
,p_lov_disp_sequence=>312
,p_lov_disp_value=>unistr('\5168\30EA\30FC\30B8\30E7\30F3\306E3\6841\306E\90F5\4FBF\756A\53F7\30DE\30C3\30D7')
,p_lov_return_value=>'312'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6444025176703882.4009)
,p_lov_disp_sequence=>313
,p_lov_disp_value=>unistr('\30B5\30D6\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'313'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6444227600704593.4009)
,p_lov_disp_sequence=>314
,p_lov_disp_value=>unistr('\5168\30B5\30D6\30EA\30FC\30B8\30E7\30F3\306E3\6841\306E\90F5\4FBF\756A\53F7\30DE\30C3\30D7')
,p_lov_return_value=>'314'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6444430371705395.4009)
,p_lov_disp_sequence=>315
,p_lov_disp_value=>unistr('\5168\30B5\30D6\30EA\30FC\30B8\30E7\30F3\306E\5DDE\30DE\30C3\30D7')
,p_lov_return_value=>'315'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6444600373706122.4009)
,p_lov_disp_sequence=>316
,p_lov_disp_value=>unistr('\5168\30B5\30D6\30EA\30FC\30B8\30E7\30F3\306E\90E1\30DE\30C3\30D7')
,p_lov_return_value=>'316'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6444802797706866.4009)
,p_lov_disp_sequence=>317
,p_lov_disp_value=>unistr('\56FD\30DE\30C3\30D7')
,p_lov_return_value=>'317'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6445007645708234.4009)
,p_lov_disp_sequence=>318
,p_lov_disp_value=>unistr('\5DDE')
,p_lov_return_value=>'318'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6445210416709048.4009)
,p_lov_disp_sequence=>319
,p_lov_disp_value=>unistr('\516850\5DDE\306E\90E1\30DE\30C3\30D7')
,p_lov_return_value=>'319'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6445413186709854.4009)
,p_lov_disp_sequence=>320
,p_lov_disp_value=>unistr('\516850\5DDE\306E3\6841\306E\90F5\4FBF\756A\53F7\30DE\30C3\30D7')
,p_lov_return_value=>'320'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_map_projection
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(173646110768001330.4009)
,p_lov_name=>'FLASH_CHART_5_MAP_PROJECTION'
,p_lov_query=>'.'||wwv_flow_api.id(173646110768001330.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173646419248001338.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30DC\30F3\30CC\56F3\6CD5')
,p_lov_return_value=>'Bonne'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173646626183001338.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\30A8\30B1\30EB\30C8\7B2C1\56F3\6CD5')
,p_lov_return_value=>'Eckert1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173646820839001338.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30A8\30B1\30EB\30C8\7B2C3\56F3\6CD5')
,p_lov_return_value=>'Eckert3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173647021689001338.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\65B9\773C\56F3\6CD5')
,p_lov_return_value=>'Equirectangular'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173647200869001338.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('Fahey\56F3\6CD5')
,p_lov_return_value=>'Fahey'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173647409014001338.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30CF\30F3\30E1\30EB\30FB\30A8\30A4\30C8\30D5\56F3\6CD5')
,p_lov_return_value=>'HammerAitoff'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173647616657001338.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\30E1\30EB\30AB\30C8\30EB\56F3\6CD5')
,p_lov_return_value=>'Mercator'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173647829681001338.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\6B63\5C04\56F3\6CD5')
,p_lov_return_value=>'Orthographic'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173648019156001338.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\30ED\30D3\30F3\30BD\30F3\56F3\6CD5')
,p_lov_return_value=>'Robinson'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173648220809001338.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EF\30B0\30CD\30EB\7B2C3\56F3\6CD5')
,p_lov_return_value=>'Wagner3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_map_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(183728528001837088.4009)
,p_lov_name=>'FLASH_CHART_5_MAP_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(183728528001837088.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183833231996651873.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30E1\30EA\30AB\5408\8846\56FD')
,p_lov_return_value=>'usa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183728727795837088.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4E16\754C\304A\3088\3073\5927\9678\30DE\30C3\30D7')
,p_lov_return_value=>'world'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183728926659837088.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30E8\30FC\30ED\30C3\30D1')
,p_lov_return_value=>'europe'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183729127336837088.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5317\30A2\30E1\30EA\30AB')
,p_lov_return_value=>'north_america'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183729313212837088.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\5357\30A2\30E1\30EA\30AB')
,p_lov_return_value=>'south_america'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183729511737837088.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30A2\30B8\30A2')
,p_lov_return_value=>'asia'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183729731152837088.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\30A2\30D5\30EA\30AB')
,p_lov_return_value=>'africa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183729916585837088.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\30AA\30BB\30A2\30CB\30A2')
,p_lov_return_value=>'oceania'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183730113300837088.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E0\30FB\30DE\30C3\30D7')
,p_lov_return_value=>'custom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183730326994837089.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'regions'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183730502376837089.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\30B5\30D6\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'sub_regions'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183730706630837089.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\56FD\30DE\30C3\30D7')
,p_lov_return_value=>'country'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183730922870837089.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\5168\30EA\30FC\30B8\30E7\30F3\306E\5DDE\30DE\30C3\30D7')
,p_lov_return_value=>'states_r'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183731106630837089.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\5168\30EA\30FC\30B8\30E7\30F3\306E3\6841\306E\90F5\4FBF\756A\53F7\30DE\30C3\30D7')
,p_lov_return_value=>'zip_r'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183731304510837089.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\90E1')
,p_lov_return_value=>'counties'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183731528375837089.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\5DDE')
,p_lov_return_value=>'states'
,p_lov_disp_cond_type=>'CURRENT_LANG_EQ_COND1'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183733808393840897.4009)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\516850\5DDE\306E\90E1\30DE\30C3\30D7')
,p_lov_return_value=>'counties_s'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183734013587842335.4009)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\516850\5DDE\306E3\6841\306E\90F5\4FBF\756A\53F7\30DE\30C3\30D7')
,p_lov_return_value=>'zip_s'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183734418782843838.4009)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('\5168\30B5\30D6\30EA\30FC\30B8\30E7\30F3\306E\90E1\30DE\30C3\30D7')
,p_lov_return_value=>'counties_sr'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183734624323845479.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5168\30B5\30D6\30EA\30FC\30B8\30E7\30F3\306E3\6841\306E\90F5\4FBF\756A\53F7\30DE\30C3\30D7')
,p_lov_return_value=>'zip_sr'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'894'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183734928825846818.4009)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('\5168\30B5\30D6\30EA\30FC\30B8\30E7\30F3\306E\5DDE\30DE\30C3\30D7')
,p_lov_return_value=>'states_sr'
,p_lov_disp_cond_type=>'CURRENT_LANG_EQ_COND1'
,p_lov_disp_cond=>'894'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_map_types_r
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184781804501968890.4009)
,p_lov_name=>'FLASH_CHART_5_MAP_TYPES_R'
,p_lov_query=>'.'||wwv_flow_api.id(184781804501968890.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184782004967968893.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30A2\30E1\30EA\30AB\5408\8846\56FD')
,p_lov_return_value=>'usa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184782228592968893.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4E16\754C\304A\3088\3073\5927\9678\30DE\30C3\30D7')
,p_lov_return_value=>'world'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184782405525968893.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\30E8\30FC\30ED\30C3\30D1')
,p_lov_return_value=>'europe'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184782605292968893.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5317\30A2\30E1\30EA\30AB')
,p_lov_return_value=>'north_america'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184782801026968894.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\5357\30A2\30E1\30EA\30AB')
,p_lov_return_value=>'south_america'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184783010272968894.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\30A2\30B8\30A2')
,p_lov_return_value=>'asia'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184783230237968894.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\30A2\30D5\30EA\30AB')
,p_lov_return_value=>'africa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184783407832968894.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\30AA\30BB\30A2\30CB\30A2')
,p_lov_return_value=>'oceania'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184783604198968894.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\30AB\30B9\30BF\30E0\30FB\30DE\30C3\30D7')
,p_lov_return_value=>'custom'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184783832749968894.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'regions'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184784026901968894.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\30B5\30D6\30EA\30FC\30B8\30E7\30F3')
,p_lov_return_value=>'sub_regions'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184784212023968894.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\56FD\30DE\30C3\30D7')
,p_lov_return_value=>'country'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184784421035968900.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\5168\30EA\30FC\30B8\30E7\30F3\306E\5DDE\30DE\30C3\30D7')
,p_lov_return_value=>'states_r'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184784626321968900.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\5168\30EA\30FC\30B8\30E7\30F3\306E3\6841\306E\90F5\4FBF\756A\53F7\30DE\30C3\30D7')
,p_lov_return_value=>'zip_r'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184784826763968900.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\90E1')
,p_lov_return_value=>'counties'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184785002083968900.4009)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\5DDE')
,p_lov_return_value=>'states'
,p_lov_disp_cond_type=>'CURRENT_LANG_EQ_COND1'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184785229428968900.4009)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\516850\5DDE\306E\90E1\30DE\30C3\30D7')
,p_lov_return_value=>'counties_s'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184785417713968900.4009)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\516850\5DDE\306E3\6841\306E\90F5\4FBF\756A\53F7\30DE\30C3\30D7')
,p_lov_return_value=>'zip_s'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184785611491968900.4009)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('\5168\30B5\30D6\30EA\30FC\30B8\30E7\30F3\306E\90E1\30DE\30C3\30D7')
,p_lov_return_value=>'counties_sr'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184785819868968900.4009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5168\30B5\30D6\30EA\30FC\30B8\30E7\30F3\306E3\6841\306E\90F5\4FBF\756A\53F7\30DE\30C3\30D7')
,p_lov_return_value=>'zip_sr'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'840'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184786024785968901.4009)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('\5168\30B5\30D6\30EA\30FC\30B8\30E7\30F3\306E\5DDE\30DE\30C3\30D7')
,p_lov_return_value=>'states_sr'
,p_lov_disp_cond_type=>'CURRENT_LANG_EQ_COND1'
,p_lov_disp_cond=>'840'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_markers
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(168557017623843308.4009)
,p_lov_name=>'FLASH_CHART_5_MARKERS'
,p_lov_query=>'.'||wwv_flow_api.id(168557017623843308.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168557313745843321.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306A\3057')
,p_lov_return_value=>'None'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_lov_disp_cond=>'P754_CHART_TYPE'
,p_lov_disp_cond2=>'ScatterMarker'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168557515368843326.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5186')
,p_lov_return_value=>'Circle'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168558115888843326.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5341\5B57')
,p_lov_return_value=>'Cross'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6963919053500978.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\30C7\30D5\30A9\30EB\30C8')
,p_lov_return_value=>'Default'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168557921429843326.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\3072\3057\5F62')
,p_lov_return_value=>'Diamond'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168558329538843328.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\5BFE\89D2\7DDA')
,p_lov_return_value=>'DiagonalCross'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168558519354843329.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\6A2A\7DDA')
,p_lov_return_value=>'HLine'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168558930168843329.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\661F\5F624')
,p_lov_return_value=>'Star4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168559120337843329.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\661F\5F625')
,p_lov_return_value=>'Star5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168559332119843329.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\661F\5F626')
,p_lov_return_value=>'Star6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168559505665843329.4009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\661F\5F627')
,p_lov_return_value=>'Star7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168559727216843329.4009)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\661F\5F6210')
,p_lov_return_value=>'Star10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168557717753843326.4009)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\56DB\89D2\5F62')
,p_lov_return_value=>'Square'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168559901424843329.4009)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\4E0A\5411\304D\4E09\89D2\5F62')
,p_lov_return_value=>'TriangleUp'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168560125836843329.4009)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\4E0B\5411\304D\4E09\89D2\5F62')
,p_lov_return_value=>'TriangleDown'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168558706468843329.4009)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\7E26\7DDA')
,p_lov_return_value=>'VLine'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_rendering
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3911612876034462.4009)
,p_lov_name=>'FLASH_CHART_5_RENDERING'
,p_lov_query=>'.'||wwv_flow_api.id(3911612876034462.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3911900962034466.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Flash\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'FLASH_PREFERRED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3912115618034466.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('HTML5\30C1\30E3\30FC\30C8')
,p_lov_return_value=>'SVG_ONLY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_scrollbar
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(27137402271110925.4009)
,p_lov_name=>'FLASH_CHART_5_SCROLLBAR'
,p_lov_query=>'.'||wwv_flow_api.id(27137402271110925.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27137715039110926.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\306A\3057')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27137907049110926.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('X\8EF8')
,p_lov_return_value=>'H'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27138102155110926.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Y\8EF8')
,p_lov_return_value=>'V'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27138306982110926.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\4E21\65B9')
,p_lov_return_value=>'B'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_styles
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(492984915177018863.4009)
,p_lov_name=>'FLASH_CHART_5_STYLES'
,p_lov_query=>'.'||wwv_flow_api.id(492984915177018863.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492985110120018870.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\30C7\30D5\30A9\30EB\30C8')
,p_lov_return_value=>'Default'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492985509649018870.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\6FC3\3044\6C34\8272')
,p_lov_return_value=>'AquaDark'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492985711540018870.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\8584\3044\6C34\8272')
,p_lov_return_value=>'AquaLight'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492986123266018871.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\9280')
,p_lov_return_value=>'Silver'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_5_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(27752006296123428.4009)
,p_lov_name=>'FLASH_CHART_5_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(27752006296123428.4009)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27752304012123428.4009)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('3D\5217')
,p_lov_return_value=>'3DColumn'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P754_CHART_TYPE in (',
'  ''2DColumn'',',
'  ''2DLine'',',
'  ''2DSpline'',',
'  ''3DColumn'',',
'  ''Horizontal2DColumn'',',
'  ''Horizontal3DColumn'',',
'  ''Stacked2DColumn'',',
'  ''Stacked3DColumn'',',
'  ''StackedHorizontal2DColumn'',',
'  ''StackedHorizontal3DColumn'',',
'  ''2DSTACKED_PCT'',',
'  ''3DSTACKED_PCT'',',
'  ''2DHSTACKED_PCT'',',
'  ''3DHSTACKED_PCT'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27752508828123428.4009)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\5217')
,p_lov_return_value=>'Stacked3DColumn'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P754_CHART_TYPE in (',
'  ''2DColumn'',',
'  ''2DLine'',',
'  ''2DSpline'',',
'  ''3DColumn'',',
'  ''Horizontal2DColumn'',',
'  ''Horizontal3DColumn'',',
'  ''Stacked2DColumn'',',
'  ''Stacked3DColumn'',',
'  ''StackedHorizontal2DColumn'',',
'  ''StackedHorizontal3DColumn'',',
'  ''2DSTACKED_PCT'',',
'  ''3DSTACKED_PCT'',',
'  ''2DHSTACKED_PCT'',',
'  ''3DHSTACKED_PCT'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27752711624123428.4009)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\5217(%)')
,p_lov_return_value=>'3DSTACKED_PCT'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P754_CHART_TYPE in (',
'  ''2DColumn'',',
'  ''2DLine'',',
'  ''2DSpline'',',
'  ''3DColumn'',',
'  ''Horizontal2DColumn'',',
'  ''Horizontal3DColumn'',',
'  ''Stacked2DColumn'',',
'  ''Stacked3DColumn'',',
'  ''StackedHorizontal2DColumn'',',
'  ''StackedHorizontal3DColumn'',',
'  ''2DSTACKED_PCT'',',
'  ''3DSTACKED_PCT'',',
'  ''2DHSTACKED_PCT'',',
'  ''3DHSTACKED_PCT'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27752921274123428.4009)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('2D\5217')
,p_lov_return_value=>'2DColumn'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P754_CHART_TYPE in (',
'  ''2DColumn'',',
'  ''2DLine'',',
'  ''2DSpline'',',
'  ''3DColumn'',',
'  ''Horizontal2DColumn'',',
'  ''Horizontal3DColumn'',',
'  ''Stacked2DColumn'',',
'  ''Stacked3DColumn'',',
'  ''StackedHorizontal2DColumn'',',
'  ''StackedHorizontal3DColumn'',',
'  ''2DSTACKED_PCT'',',
'  ''3DSTACKED_PCT'',',
'  ''2DHSTACKED_PCT'',',
'  ''3DHSTACKED_PCT'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27753117248123429.4009)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('2D\7A4D\4E0A\3052\5217')
,p_lov_return_value=>'Stacked2DColumn'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P754_CHART_TYPE in (',
'  ''2DColumn'',',
'  ''2DLine'',',
'  ''2DSpline'',',
'  ''3DColumn'',',
'  ''Horizontal2DColumn'',',
'  ''Horizontal3DColumn'',',
'  ''Stacked2DColumn'',',
'  ''Stacked3DColumn'',',
'  ''StackedHorizontal2DColumn'',',
'  ''StackedHorizontal3DColumn'',',
'  ''2DSTACKED_PCT'',',
'  ''3DSTACKED_PCT'',',
'  ''2DHSTACKED_PCT'',',
'  ''3DHSTACKED_PCT'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27753304809123429.4009)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('2D\7A4D\4E0A\3052\5217(%)')
,p_lov_return_value=>'2DSTACKED_PCT'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P754_CHART_TYPE in (',
'  ''2DColumn'',',
'  ''2DLine'',',
'  ''2DSpline'',',
'  ''3DColumn'',',
'  ''Horizontal2DColumn'',',
'  ''Horizontal3DColumn'',',
'  ''Stacked2DColumn'',',
'  ''Stacked3DColumn'',',
'  ''StackedHorizontal2DColumn'',',
'  ''StackedHorizontal3DColumn'',',
'  ''2DSTACKED_PCT'',',
'  ''3DSTACKED_PCT'',',
'  ''2DHSTACKED_PCT'',',
'  ''3DHSTACKED_PCT'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27753516861123429.4009)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('3D\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'Horizontal3DColumn'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P754_CHART_TYPE in (',
'  ''2DColumn'',',
'  ''2DLine'',',
'  ''2DSpline'',',
'  ''3DColumn'',',
'  ''Horizontal2DColumn'',',
'  ''Horizontal3DColumn'',',
'  ''Stacked2DColumn'',',
'  ''Stacked3DColumn'',',
'  ''StackedHorizontal2DColumn'',',
'  ''StackedHorizontal3DColumn'',',
'  ''2DSTACKED_PCT'',',
'  ''3DSTACKED_PCT'',',
'  ''2DHSTACKED_PCT'',',
'  ''3DHSTACKED_PCT'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27753718452123429.4009)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\68D2\30B0\30E9\30D5')
,p_lov_return_value=>'StackedHorizontal3DColumn'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P754_CHART_TYPE in (',
'  ''2DColumn'',',
'  ''2DLine'',',
'  ''2DSpline'',',
'  ''3DColumn'',',
'  ''Horizontal2DColumn'',',
'  ''Horizontal3DColumn'',',
'  ''Stacked2DColumn'',',
'  ''Stacked3DColumn'',',
'  ''StackedHorizontal2DColumn'',',
'  ''StackedHorizontal3DColumn'',',
'  ''2DSTACKED_PCT'',',
'  ''3DSTACKED_PCT'',',
'  ''2DHSTACKED_PCT'',',
'  ''3DHSTACKED_PCT'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27753920476123429.4009)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('3D\7A4D\4E0A\3052\68D2\30B0\30E9\30D5(%)')
,p_lov_return_value=>'3DHSTACKED_PCT'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P754_CHART_TYPE in (',
'  ''2DColumn'',',
'  ''2DLine'',',
'  ''2DSpline'',',
'  ''3DColumn'',',
'  ''Horizontal2DCol