prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4420
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4420 - Oracle APEX  System Messages and Native Types
--
-- Application Export:
--   Application:     4420
--   Name:            Oracle APEX  System Messages and Native Types
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             124
--       Globalization:
--         Messages:          14,593
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX  System Messages and Native Types')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286626065217927188')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135328'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'ja'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(91645213681389498.442)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141230'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562090986404402217.442)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48650898565635010.442)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B5\30A4\30F3\30A2\30A6\30C8')
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>unistr('Application Express\306E\30B5\30A4\30F3\30A2\30A6\30C8')
,p_list_text_09=>unistr('\306F\3044')
,p_list_text_10=>'logout exit quit :q'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(281916990329150760.442)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\30B9\30D7\30EC\30C3\30C9\30B7\30FC\30C8\3067\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F5C\6210\3057\307E\3059')
,p_list_item_link_target=>'f?p=4000:447:&APP_SESSION.::NO:448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT::'
,p_list_text_01=>unistr('Excel\30D5\30A1\30A4\30EB\307E\305F\306FCSV\30D5\30A1\30A4\30EB\3092\30A4\30F3\30DD\30FC\30C8\3057\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F5C\6210\3057\307E\3059')
,p_list_text_09=>unistr('\306F\3044')
,p_list_text_10=>'excel csv xsl xslx spreadsheet data paste load import'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(282255839842182292.442)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Oracle APEX\30DB\30FC\30E0')
,p_list_item_link_target=>'f?p=4500:1000:&APP_SESSION.'
,p_list_text_10=>'homepage start '
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(296033420364984683.442)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\30D5\30A9\30F3\30C8APEX\30A2\30A4\30B3\30F3\3092\53C2\7167')
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>unistr('\30D5\30A9\30F3\30C8APEX\30A2\30A4\30B3\30F3\3092\53C2\7167\3057\3001\4FEE\98FE\5B50\3092\8FFD\52A0\3057\3066\3001\5FC5\8981\306ACSS\307E\305F\306FHTML\3092\30B3\30D4\30FC\3057\307E\3059\3002')
,p_list_text_09=>unistr('\306F\3044')
,p_list_text_10=>'icons font apex library graphics'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562091518091404815.442)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562091727563404815.442)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3{APP_ID}\3092SQL\30D5\30A1\30A4\30EB\3068\3057\3066\30A8\30AF\30B9\30DD\30FC\30C8')
,p_list_text_09=>unistr('\306F\3044')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562093357853428158.442)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\672A\4F7F\7528\306E\30EA\30B9\30C8')
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562092153904409717.442)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48392393581618193.442)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\30B3\30F3\30BD\30FC\30EB\30FB\30ED\30B0')
,p_list_item_link_target=>'javascript:console.log(''hello friend'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14843831009863117.442)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859012524941040.442)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(86380554411225400.442)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91997339122572414.442)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(460407779408652225.442)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(497671453666914719.442)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attribute_01=>'fa-star'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082458703597614427.442)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082517678315623391.442)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072678475712055.442)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831649180083980462.442)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780276458994154.442)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1832884277947217587.442)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1840861033969283097.442)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917665913120940054.442)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1990227023531717243.442)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626406749381989.442)
,p_theme_id=>1
,p_name=>'One Level Tabs.ja'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE# ',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626529080381989.442)
,p_theme_id=>1
,p_name=>'Printer Friendly.ja'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(91626823864381990.442)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(91632832228382001.442)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(91636711305382010.442)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(91638400927382012.442)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(91638400927382012.442)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(91641225667382016.442)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641730492382017.442)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641814330382017.442)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(91642503902382024.442)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>unistr('\691C\7D22\30C0\30A4\30A2\30ED\30B0\30FB\30DC\30C3\30AF\30B9')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>unistr('\691C\7D22')
,p_close_button_text=>unistr('\9589\3058\308B')
,p_next_button_text=>unistr('\6B21 >')
,p_prev_button_text=>unistr('< \524D')
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91641910982382018.442)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642102481382020.442)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642303533382020.442)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279253856115868822)
,p_name=>'2DCOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('2D\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279256189505868823)
,p_name=>'2DCOLUMN_LINE'
,p_message_language=>'ja'
,p_message_text=>unistr('2D\5217\4ED8\304D\6298\308C\7DDA')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279254091990868822)
,p_name=>'2DDOUGHNUT'
,p_message_language=>'ja'
,p_message_text=>unistr('2D\30C9\30FC\30CA\30C4')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279255900664868823)
,p_name=>'2DHSTACKED_PCT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A4D\4E0A\3052\6C34\5E732D\5217(%)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279254108759868822)
,p_name=>'2DLINE'
,p_message_language=>'ja'
,p_message_text=>unistr('2D\6298\308C\7DDA')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279254223491868822)
,p_name=>'2DPIE'
,p_message_language=>'ja'
,p_message_text=>unistr('2D\5186')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279255793486868823)
,p_name=>'2DSTACKED_PCT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A4D\4E0A\30522D\5217(%)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279254358151868822)
,p_name=>'3DCOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('3D\5217')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279256029022868823)
,p_name=>'3DHSTACKED_PCT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A4D\4E0A\3052\6C34\5E733D\5217(%)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279254469749868822)
,p_name=>'3DPIE'
,p_message_language=>'ja'
,p_message_text=>unistr('3D\5186')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279255893693868823)
,p_name=>'3DSTACKED_PCT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A4D\4E0A\30523D\5217(%)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280151792744869374)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\3078\306E\633F\5165\7528\306E0\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280151518276869374)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F4\65B0\7528\306E0\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280151964919869374)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\66F4\65B0\7528\306E0\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280152377098869374)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\3078\306E\633F\5165\7528\306E0\30EC\30DD\30FC\30C8\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280152579408869374)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\66F4\65B0\7528\306E0\30EC\30DD\30FC\30C8\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280151457252869374)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F4\65B0\7528\306E%0\30A2\30A4\30C6\30E0\306E\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280152101518869374)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F4\65B0\7528\306E0\30EC\30DD\30FC\30C8\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280151669384869374)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\3078\306E\633F\5165\7528\306E%0\30A2\30A4\30C6\30E0\306E\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280151857116869374)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\66F4\65B0\7528\306E%0\30A2\30A4\30C6\30E0\306E\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280152290244869374)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\3078\306E\633F\5165\7528\306E%0\30EC\30DD\30FC\30C8\5217\306E\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280152048641869374)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F4\65B0\7528\306E%0\30EC\30DD\30FC\30C8\5217\306E\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280152476220869374)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C5E\6027\30C7\30A3\30AF\30B7\30E7\30CA\30EA\66F4\65B0\7528\306E%0\30EC\30DD\30FC\30C8\5217\306E\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279842224070869183)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024\306F\6570\5024\3067\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279826707991869173)
,p_name=>'4000_639_SEQ_MESG'
,p_message_language=>'ja'
,p_message_text=>unistr('<span class="fielddata">\30EA\30FC\30B8\30E7\30F3\306E\9806\5E8F\304C\4E00\610F\3067\306A\3044\305F\3081\3001\9806\5E8F\5909\66F4\3067\304D\307E\305B\3093\3002</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279826813472869174)
,p_name=>'4000_641_SEQ_MESG'
,p_message_language=>'ja'
,p_message_text=>unistr('<span class="fielddata">\30DC\30BF\30F3\306E\9806\5E8F\304C\4E00\610F\3067\306A\3044\305F\3081\3001\9806\5E8F\5909\66F4\3067\304D\307E\305B\3093\3002</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279826925212869174)
,p_name=>'4000_646_SEQ_MESG'
,p_message_language=>'ja'
,p_message_text=>unistr('<span class="fielddata">\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\306E\9806\5E8F\304C\4E00\610F\3067\306A\3044\305F\3081\3001\9806\5E8F\5909\66F4\3067\304D\307E\305B\3093\3002</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279827056796869174)
,p_name=>'4000_749_SEQ_MESG'
,p_message_language=>'ja'
,p_message_text=>unistr('<span class="fielddata">\30EA\30FC\30B8\30E7\30F3\30FB\30A2\30A4\30C6\30E0\306E\9806\5E8F\304C\4E00\610F\3067\306A\3044\305F\3081\3001\9806\5E8F\5909\66F4\3067\304D\307E\305B\3093\3002</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279906649225869224)
,p_name=>'4000_APPLICATION_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279398318949868913)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\7DE8\96C6: %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279798304208869156)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6307\5B9A\3055\308C\305F\65E5\4ED8\66F8\5F0F\306F\7121\52B9\3067\3059\3002  \30AB\30EC\30F3\30C0\306B\306F\3001YYYYMMDD\3068\3044\3046\66F8\5F0F\306E\65E5\4ED8\304C\5FC5\8981\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279847498094869186)
,p_name=>'4000_TREE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C4\30EA\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279906728830869224)
,p_name=>'4000_WORKSPACE_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9ID')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279679465830869084)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4F5C\6210\3059\308B\65B0\3057\3044\30B9\30AD\30FC\30DE\306E\540D\524D\3092\5165\529B\3057\3066\304F\3060\3055\3044\3002\30B9\30AD\30FC\30DE\306E'),
unistr('\30D1\30B9\30EF\30FC\30C9\9078\629E\3057\3001\30C7\30D5\30A9\30EB\30C8\306E\8868\9818\57DF\304A\3088\3073\4E00\6642\8868\9818\57DF\3092'),
unistr('\9078\629E\3057\3066\304F\3060\3055\3044\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279679539755869084)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E2\5B58\306E\30B9\30AD\30FC\30DE\306E\540D\524D\3092\5165\529B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279679664136869084)
,p_name=>'4050_106_WHEN_DONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86\5F8C\3001\300C\6B21\3078 &gt;\300D\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279572693896869019)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\9818\57DF\304A\3088\3073\95A2\9023\30C7\30FC\30BF\30D5\30A1\30A4\30EB\306E\524A\9664: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279572500471869019)
,p_name=>'4050_110_DROP_USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30E6\30FC\30B6\30FC\306E\524A\9664: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280485211904869583)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B5\30FC\30D3\30B9\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30ED\30B0\30FB\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279672858802869080)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\767A\8005\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30ED\30B0\306E\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279291463708868846)
,p_name=>'4050_31_LOG_COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30B0\30A4\30F3\30FB\30A2\30AF\30BB\30B9\30FB\30ED\30B0\306E\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279672368190869080)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5909\66F4\30EA\30AF\30A8\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279672420574869080)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30F3\30BF\30A4\30E0\30FB\30EA\30AF\30A8\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279672116210869080)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30EA\30AF\30A8\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279674820710869081)
,p_name=>'4050_46_AD_HOC'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\30B3\30DE\30F3\30C9\30FB\30D7\30ED\30BB\30C3\30B5\306E\5C65\6B74\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279674762532869081)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5236\5FA1\30D5\30A1\30A4\30EB\306E\5B9F\884C\30ED\30B0\30FB\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279674615857869081)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30AF\30EA\30D7\30C8\30FB\30D5\30A1\30A4\30EB\306E\5B9F\884C\30ED\30B0\30FB\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279674910664869081)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\30A2\30FC\30AB\30A4\30D6\30FB\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279676990180869083)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30C6\30A3\30D6\30FB\30ED\30B0\60C5\5831')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279677020931869083)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30EC\30F3\30C8\30FB\30ED\30B0\756A\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279677153798869083)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30EC\30F3\30C8\30FB\30ED\30B0\306E\30BF\30A4\30E0\30B9\30BF\30F3\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279677795403869083)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\30ED\30B0\30FB\30B9\30A4\30C3\30C1\307E\3067\306E\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279677325219869083)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5\6570\3067\306E\9593\9694(\5B9A\6570)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279677623404869083)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30B1\30B8\30E5\30FC\30EB\3055\308C\305F\6B21\306E\30ED\30B0\30FB\30B9\30A4\30C3\30C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279678025304869083)
,p_name=>'4050_70_DEV_ACT'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\767A\8005\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30ED\30B0\306E\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279678215635869083)
,p_name=>'4050_71_CLICK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30EA\30C3\30AF\30B9\30EB\30FC\30FB\30ED\30B0\306E\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279679023419869084)
,p_name=>'4050_75_AD_HOC'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\30B3\30DE\30F3\30C9\30FB\30D7\30ED\30BB\30C3\30B5\306E\5C65\6B74\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279678977131869084)
,p_name=>'4050_75_CTRL_FILE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5236\5FA1\30D5\30A1\30A4\30EB\306E\5B9F\884C\30ED\30B0\30FB\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279678750228869084)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30AF\30EA\30D7\30C8\30FB\30D5\30A1\30A4\30EB\306E\5B9F\884C\30ED\30B0\30FB\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279679102816869084)
,p_name=>'4050_75_SQL_ARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\30A2\30FC\30AB\30A4\30D6\30FB\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279679203859869084)
,p_name=>'4050_82_WORKSPACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9%1\306B\306F\3001%2\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3068%3\30E6\30FC\30B6\30FC\304C\5B58\5728\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279679390707869084)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30EA\30C3\30AF\30FB\30AB\30A6\30F3\30C8\30FB\30ED\30B0\306E\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279877433060869205)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\751F\7523\6027\304A\3088\3073\30B5\30F3\30D7\30EB\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279877533167869205)
,p_name=>'4050_PACKAGED_WEBSHEETS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30F3\30D7\30EBWeb\30B7\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279876752333869204)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\6570')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279417081785868925)
,p_name=>'4150_COLUMN_NUMBER'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217%0')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279600776769869036)
,p_name=>'4350_APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279600840281869036)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\7DE8\96C6')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279306537242868855)
,p_name=>'4500 800 HD DBA'
,p_message_language=>'ja'
,p_message_text=>unistr('\300EOracle Database Express Edition 2 Day DBA\300F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279306690430868855)
,p_name=>'4500 800 HD DEV'
,p_message_language=>'ja'
,p_message_text=>unistr('\300EOracle Database Express Edition 2 Day Developer Guide\300F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279306423677868855)
,p_name=>'4500 800 HD HTMLDB'
,p_message_language=>'ja'
,p_message_text=>unistr('\300EOracle Application Express 2 Day Plus Developer Guide\300F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279306766164868855)
,p_name=>'4500 800 HD JAVA'
,p_message_language=>'ja'
,p_message_text=>unistr('\300EOracle Database Express Edition 2 Day Plus Java Developer Guide\300F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279306819246868855)
,p_name=>'4500 800 HD NET'
,p_message_language=>'ja'
,p_message_text=>unistr('\300EOracle Database Express Edition 2 Day Plus .NET Developer Guide\300F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279306992973868855)
,p_name=>'4500 800 HD PHP'
,p_message_language=>'ja'
,p_message_text=>unistr('\300EOracle Database Express Edition 2 Day Plus PHP Developer\300F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279307052157868855)
,p_name=>'4500 800 MSG DBA'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5\5E38\306E\7BA1\7406\30BF\30B9\30AF\306B\3064\3044\3066\8AAC\660E\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279307155322868855)
,p_name=>'4500 800 MSG DEV'
,p_message_language=>'ja'
,p_message_text=>unistr('Oracle Database Express Edition\958B\767A\74B0\5883\306E\4F7F\7528\65B9\6CD5\306B\3064\3044\3066\8AAC\660E\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279307275576868856)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\96C6\4E2D\578B\306EWeb\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\69CB\7BC9\65B9\6CD5\3092\8AAC\660E\3059\308B\4E00\9023\306E\30C1\30E5\30FC\30C8\30EA\30A2\30EB\3092\63D0\4F9B\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279307418544868856)
,p_name=>'4500 800 MSG JAVA'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30C9\30AD\30E5\30E1\30F3\30C8\3067\306F\3001Java\304A\3088\3073JDBC\3092\4F7F\7528\3057\305FOracle Database XE\3078\306E\63A5\7D9A\65B9\6CD5\3092\793A\3059\30C1\30E5\30FC\30C8\30EA\30A2\30EB\3092\63D0\4F9B\3057\307E\3059\3002\307E\305F\3001\30C7\30FC\30BF\306B\5BFE\3059\308B\30A2\30AF\30BB\30B9\3068\5909\66F4\3092\884C\3046\7C21\5358\306AJava\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\958B\767A\65B9\6CD5\306B\3064\3044\3066\3082\8AAC\660E\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279307508362868856)
,p_name=>'4500 800 MSG NET'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30C9\30AD\30E5\30E1\30F3\30C8\3067\306F\3001Oracle Data Provider for .NET\304A\3088\3073Oracle Developer Tools for Visual Studio .NET\306E\4E3B\306A\6A5F\80FD\306B\3064\3044\3066\8AAC\660E\3057\307E\3059\3002\30A4\30F3\30B9\30C8\30FC\30EB\304A\3088\3073\69CB\6210\3001Oracle Data Provider for .NET\304A\3088\3073Oracle Developer Tools for Visual Studio .NET\3092\4F7F\7528\3057\305F\57FA\672C\7684\306A\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\69CB\7BC9\65B9\6CD5\3001PL/SQL\304A\3088\3073.NET\30B9\30C8\30A2\30C9\30FB\30D7\30ED\30B7\30FC\30B8\30E3\306E\4F5C\6210\304A\3088\3073\4F7F\7528\65B9\6CD5\306B')
||unistr('\3064\3044\3066\8AAC\660E\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279307397937868856)
,p_name=>'4500 800 MSG PHP'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30C9\30AD\30E5\30E1\30F3\30C8\3067\306F\3001Apache\304A\3088\3073Zend Core PHP\30C9\30E9\30A4\30D0\306E\30C0\30A6\30F3\30ED\30FC\30C9\304A\3088\3073\30A4\30F3\30B9\30C8\30FC\30EB\65B9\6CD5\3068\3001PHP\3092\4F7F\7528\3057\305FOracle Database XE\3078\306E\63A5\7D9A\65B9\6CD5\3092\793A\3059\30C1\30E5\30FC\30C8\30EA\30A2\30EB\3092\63D0\4F9B\3057\307E\3059\3002PHP\3092\4F7F\7528\3057\3066\3001\30C7\30FC\30BF\306B\5BFE\3059\308B\30A2\30AF\30BB\30B9\3068\5909\66F4\3092\884C\3046\7C21\5358\306A\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\958B\767A\3059\308B\65B9\6CD5\306B\3064\3044\3066\3082\8AAC\660E\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279277282926868836)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279277105921868836)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279277469697868837)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_language=>'ja'
,p_message_text=>unistr('\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279736195672869118)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279277854956868837)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30F3\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279277961641868837)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279277354318868837)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30D6\30B8\30A7\30AF\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279277773768868837)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279277537422868837)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8\30FB\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279277698709868837)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279281030125868839)
,p_name=>'4500_1002_QB_JOIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D50\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279274547436868835)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D50\5408\3059\308B\5217\3092\9078\629E\3059\308B\306B\306F\3001\3053\3053\3092\30AF\30EA\30C3\30AF\3057\3066\304F\3060\3055\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279281495116868839)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\592760\5217\3092\9078\629E\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279274409967868835)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279274395607868835)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\306E\8868\793A/\975E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279281146410868839)
,p_name=>'4500_1002_QB_TO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9B\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279272756171868834)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\7D50\679C(%1\3092\5B9F\884C)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279572862891869019)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\5408\305B\3092\5143\306B\623B\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279288777186868844)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\521D\306E%0\5217\304C\8868\793A\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279765807016869136)
,p_name=>'4500_SESS_EVENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279765707576869136)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_language=>'ja'
,p_message_text=>'KB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279765644970869136)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_language=>'ja'
,p_message_text=>'MB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279310454724868858)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\30C7\30D5\30A9\30EB\30C8\5024\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC\3067\4F7F\7528\3055\308C\3001\30EA\30FC\30B8\30E7\30F3\304A\3088\3073\30A2\30A4\30C6\30E0\306E\30D7\30ED\30D1\30C6\30A3\306E\521D\671F\5024\306B\79FB\5165\3055\308C\3066\30011\3064\307E\305F\306F\8907\6570\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\306E\8907\6570\306E\30DA\30FC\30B8\9593\3067\306E\4E00\8CAB\6027\3092\5B9F\73FE\3059\308B\305F\3081\306B\4F7F\7528\3055\308C\307E\3059\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279354834058868886)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\306F\3001Cookie\304C\6709\52B9\306B\306A\3063\3066\3044\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279354740352868886)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\306F\3001JavaScript\304C\6709\52B9\306B\306A\3063\3066\3044\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279546403609869003)
,p_name=>'4800_9015_UPDATE_OVERDUE_FEATURES'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\671F\9650\3092\8D85\904E\3057\305F\6A5F\80FD\304C\9078\629E\3055\308C\305F\65B0\3057\3044\30DE\30A4\30EB\30B9\30C8\30F3\306B\66F4\65B0\3055\308C\307E\3059\3002')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279796615035869155)
,p_name=>'ABOUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\60C5\5831')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280557408389869627)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0\30E6\30FC\30B6\30FC\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\3078\306E\8FFD\52A0\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279809016008869163)
,p_name=>'ACCEPTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\627F\8A8D\6E08')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279775493389869142)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\5272\5F53\3066\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279773567198869141)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\306E\5F71\97FF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279775980839869143)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\30FB\30B9\30C6\30FC\30BF\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280636562296869676)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\306E\30C6\30B9\30C8\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279287518897868843)
,p_name=>'ACCESS_CONTROL_ADMIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279446914804868943)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\6A29\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279286065852868842)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\7BA1\7406\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279724666051869111)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279835740283869179)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\306B\5272\308A\5F53\3066\3089\308C\305F\30ED\30FC\30EB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279286290529868842)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279286882170868843)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E2\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279286741921868843)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3078\306E\30A2\30AF\30BB\30B9\306E\5236\5FA1\65B9\6CD5\3092\6307\5B9A\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279288003935868843)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E2\30FC\30C9\306E\8A2D\5B9A\30EA\30AF\30A8\30B9\30C8\3092\51E6\7406\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279288159111868844)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E2\30FC\30C9\304C\8A2D\5B9A\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279447855556868944)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\81EA\5206\81EA\8EAB\306F\524A\9664\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279447930188868944)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\81EA\5206\81EA\8EAB\306E\7BA1\7406\8005\6A29\9650\306F\524A\9664\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279286118560868842)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279724571050869111)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30B7\30E7\30F3\6A29\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279724786470869111)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279835842174869179)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF\306B\5272\308A\5F53\3066\3089\308C\305F\30ED\30FC\30EB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279768273006869138)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A\304C\4F5C\6210\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279724855225869111)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30AF\30BB\30B9\30FB\30ED\30FC\30EB\304C\4F5C\6210\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279303620955868853)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\8A8D\53EF\30B9\30AD\30FC\30E0\304C\4F5C\6210\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279377365073868900)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30DA\30FC\30B8\3092\4F5C\6210\3067\304D\307E\305B\3093\3002%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279377287464868900)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\8868\3092\4F5C\6210\3067\304D\307E\305B\3093\3002%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279450494057868945)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8907\3057\305F\30E6\30FC\30B6\30FC\540D\306F\5165\529B\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279447029531868943)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1 - \7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279287767615868843)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\5927/\5C0F\6587\5B57\3092\533A\5225\3057\306A\3044\554F\5408\305B\57FA\6E96\3092\5165\529B\3057\3001\300C<b>\5B9F\884C</b>\300D\30DC\30BF\30F3\3092\62BC\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279287883982868843)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\7BA1\7406\30E2\30FC\30C9\3092\53D6\5F97\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279287691087868843)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\7D42\5909\66F4\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279287148812868843)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279286333638868842)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\5BFE\8C61\3078\306E\5B8C\5168\306A\30A2\30AF\30BB\30B9\6A29\3002\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306F\4F7F\7528\3055\308C\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279286449040868842)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_language=>'ja'
,p_message_text=>unistr('\5236\9650\4ED8\304D\30A2\30AF\30BB\30B9\6A29\3002\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306B\5B9A\7FA9\3055\308C\305F\30E6\30FC\30B6\30FC\306E\307F\304C\8A31\53EF\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279286571047868843)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30D6\30EA\30C3\30AF\8AAD\53D6\308A\5C02\7528\3002\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306B\3088\3063\3066\5236\5FA1\3055\308C\308B\7DE8\96C6\304A\3088\3073\7BA1\7406\306E\6A29\9650\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279286688631868843)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\30A2\30AF\30BB\30B9\5C02\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279287919769868843)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A66\884C\3057\305F\30A2\30AF\30B7\30E7\30F3\306E\6A29\9650\304C\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279287455803868843)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A29\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279768101347869138)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30C0\30FC\6A29\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279768010217869138)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30C0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279835927026869179)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30EA\30FC\30C0\30FC\306B\5272\308A\5F53\3066\3089\308C\305F\30ED\30FC\30EB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279304426702868854)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A8D\8A3C\30B9\30AD\30FC\30E0\306B\5BFE\5FDC\3059\308B\30E6\30FC\30B6\30FC\540D\3092\6307\5B9A\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279286974796868843)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E2\30FC\30C9\306E\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279405447411868918)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30DA\30FC\30B8\304C\6B63\5E38\306B\4F5C\6210\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279287348532868843)
,p_name=>'ACCESS_CONTROL_USERNAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279724954658869112)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E2\5B58\306E\30A2\30AF\30BB\30B9\5236\5FA1\30ED\30FC\30EB\3092\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279304320595868854)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E2\5B58\306E\8A8D\53EF\30B9\30AD\30FC\30E0\306E\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279303562723868853)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E2\5B58\306E\8868\306E\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279447156036868943)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1 - \8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279736890372869119)
,p_name=>'ACCESS_DENIED_SIMPLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\62D2\5426\3055\308C\305F\30A2\30AF\30BB\30B9')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279307804292868856)
,p_name=>'ACCOUNT_CREATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AB\30A6\30F3\30C8\304C\4F5C\6210\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279430735721868933)
,p_name=>'ACCOUNT_HAS_BEEN_CREATED'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\30A2\30AB\30A6\30F3\30C8\304C\4F5C\6210\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279305214336868854)
,p_name=>'ACCOUNT_LOCKED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AB\30A6\30F3\30C8\304C\30ED\30C3\30AF\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280097817376869341)
,p_name=>'ACCOUNT_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AB\30A6\30F3\30C8\30FB\30E1\30CB\30E5\30FC')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279755335897869130)
,p_name=>'ACKNOWLEDGED'
,p_message_language=>'ja'
,p_message_text=>unistr('\78BA\8A8D\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279755521637869130)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\78BA\8A8D\6E08\3001\30A2\30AF\30B7\30E7\30F3\306A\3057')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279819458435869169)
,p_name=>'ACL_ADD_USER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280488043884869585)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\30FB\30C0\30C3\30B7\30E5\30DC\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280488168974869585)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\30FB\30E2\30CB\30BF\30FC\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280487272805869584)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0/\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280487924957869585)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5B9F\884C\6642\306E\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280486411952869584)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC\5185\304B\3089\306E\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280487101129869584)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6CE8\91C8(\30D5\30A1\30A4\30EB\3001\30BF\30B0\3001\30CE\30FC\30C8)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280486149198869584)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\3092\4F7F\7528\3057\306A\3044Application Express\30A2\30AB\30A6\30F3\30C8\8A8D\8A3C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280486048028869584)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306B\3088\308B\8A8D\8A3C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280486882112869584)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\30A2\30AF\30BB\30B9\304A\3088\3073\63A8\5968\30AA\30D6\30B8\30A7\30AF\30C8\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280491101884869587)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3078\306E\8A8D\8A3C\304C\7D42\308F\308B\3068\3001\30A2\30AF\30BB\30B9\5236\5FA1\3067\306F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\3067\30E6\30FC\30B6\30FC\304C\5B9F\884C\3067\304D\308B\64CD\4F5C\304C\6307\5B9A\3055\308C\307E\3059\3002\4E0B\306E\8868\306F\3001\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\3067\4F7F\7528\4E2D\306E\8A8D\8A3C\306B\57FA\3065\3044\3066\5404\7A2E\306E\30E6\30FC\30B6\30FC\306B\4ED8\4E0E\3055\308C\308B\6A29\9650\3092\793A\3057\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280488274938869585)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306E\4FDD\6301')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280486990586869584)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9F\884C\304A\3088\3073\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280486630247869584)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30D1\30C6\30A3\306E\66F4\65B0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280146325979869371)
,p_name=>'ACTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280485587277869583)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306E\8A2D\5B9A')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279318989740868863)
,p_name=>'ACTIVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30C6\30A3\30D6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279732441095869116)
,p_name=>'ACTIVITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30C6\30A3\30D3\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279776902977869143)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30B5\30DE\30EA\30FC')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280012469081869289)
,p_name=>'ADDED_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0\5143')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280483075081869582)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30FC\30B8\30FB\30EA\30B9\30C8\306B\8FFD\52A0\6E08')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280132022589869362)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30AF\30A8\30B9\30C8\3055\308C\305F\8FFD\52A0\60C5\5831')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279686610917869088)
,p_name=>'ADD_ARGUEMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F15\6570\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279676790380869082)
,p_name=>'ADD_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279892914897869215)
,p_name=>'ADD_COLUMN_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217%0\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279534749478868996)
,p_name=>'ADD_CONSTRAINT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5236\7D04\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279674525241869081)
,p_name=>'ADD_MORE...'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279747325001869125)
,p_name=>'ADD_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279900448492869220)
,p_name=>'ADD_USER_INTERFACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\8FFD\52A0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279904061842869222)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30D3\30B8\30E7\30CB\30F3\30B0\6E08\9818\57DF\3092%0MB\3054\3068\306B\8ABF\6574')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279673034298869080)
,p_name=>'ADMIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279299259847868851)
,p_name=>'ADMINISTRATOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\7BA1\7406\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279776770988869143)
,p_name=>'ADMINISTRATORS'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279680319586869085)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\8005\306E\96FB\5B50\30E1\30FC\30EB\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279844494088869184)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279334819509868873)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279335171473868873)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30D5\30A9\30FC\30DE\30F3\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279335298735868873)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_language=>'ja'
,p_message_text=>unistr('\54C1\8CEA\4FDD\8A3C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279334974160868873)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30AD\30E5\30EA\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279335344917868873)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\7528\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279335001713868873)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_language=>'ja'
,p_message_text=>unistr('\8B66\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279977755742869267)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0"%1"\304C\4FDD\8B77\3055\308C\3001Ajax\30B3\30FC\30EB\3092\4ECB\3057\3066\8A2D\5B9A\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279977885664869267)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0"%1"\304C\4FDD\8B77\3055\308C\3001Ajax\30B3\30FC\30EB\3092\4ECB\3057\3066\8A2D\5B9A\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280009716048869287)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0"%1"\304C\4FDD\8B77\3055\308C\3001Ajax\30B3\30FC\30EB\3092\4ECB\3057\3066\8A2D\5B9A\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279365687940868892)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_language=>'ja'
,p_message_text=>unistr('SYS\30B9\30AD\30FC\30DE\63A5\982D\8F9E\304C\3042\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280187668416869396)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_language=>'ja'
,p_message_text=>unistr('WWV_FLOW API\306E\4F7F\7528\72B6\6CC1(\304B\308F\308A\306BAPEX API\3092\4F7F\7528)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280127756212869359)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217%0\306F\30EA\30FC\30B8\30E7\30F3\30FB\30BD\30FC\30B9\306ESQL\6587\306B\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279345101394868880)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306E\5217%0\306F\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279342821759868878)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279311241037868858)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217%0\306F\30EA\30FC\30B8\30E7\30F3\30FB\30BD\30FC\30B9\306ESQL\6587\306B\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280222288157869418)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\5F62\5F0F\306E\5217%0\306F\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279342995992868878)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\307E\305F\306F\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\540D\3068\3057\3066\53C2\7167\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280563445145869631)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_language=>'ja'
,p_message_text=>unistr('Ajax\30B3\30FC\30EB\30D0\30C3\30AF\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9\306F\3001\8A8D\53EF\30B9\30AD\30FC\30E0\306B\3088\3063\3066\4FDD\8B77\3055\308C\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280563021523869631)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306F\3001\8A8D\53EF\30B9\30AD\30FC\30E0\306B\3088\3063\3066\4FDD\8B77\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279343882488868879)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30FC\30B2\30C3\30C8\30FB\30DA\30FC\30B8%1(\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3%0\5185)\306B\8A8D\53EF\30B9\30AD\30FC\30E0\304C\5B9A\7FA9\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280565168438869632)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30DA\30FC\30B8\306E\8A8D\53EF\306F\3001\89AA\30DA\30FC\30B8%0\306E\8A8D\53EF"%1"\3068\7570\306A\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279343969338868879)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30FC\30B2\30C3\30C8\30FB\30DA\30FC\30B8\306E\8A8D\53EF"%0"\306F\3001"%1"\3068\7570\306A\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279342422299868878)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279342351556868878)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30A4\30F3\30C9\5909\6570\69CB\6587\306E\30C1\30A7\30C3\30AF\3092\5B9F\884C\3067\304D\307E\305B\3093\3067\3057\305F\3002\30A8\30E9\30FC: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279342538959868878)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\30D0\30A4\30F3\30C9\5909\6570\69CB\6587\3067\53C2\7167\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279344560213868879)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\4ED6\306E\30D6\30E9\30F3\30C1\306E\524D\306E\6761\4EF6\306A\3057\30D6\30E9\30F3\30C1\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280562873828869631)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9\30FB\30A2\30A4\30C6\30E0\3092\542B\3080\30DA\30FC\30B8\306F\3001\30AA\30FC\30C8\30B3\30F3\30D7\30EA\30FC\30C8\304C\300C\30AA\30F3\300D\306B\8A2D\5B9A\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280562984219869631)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\30AD\30E3\30C3\30B7\30E5\300D\306B\3088\3063\3066\30D6\30E9\30A6\30B6\3067\306E\6A5F\5BC6\30C7\30FC\30BF\306E\30AD\30E3\30C3\30B7\30E5\304C\53EF\80FD\306B\306A\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280447806242869560)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\30D5\30EC\30FC\30E0\3078\306E\57CB\8FBC\307F\300D\306B\3088\3063\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306F\30AF\30EA\30C3\30AF\30B8\30E3\30C3\30AF\653B\6483\3092\53D7\3051\3084\3059\304F\306A\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280447953297869560)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\300CHTML\30A8\30B9\30B1\30FC\30D7\30FB\30E2\30FC\30C9\300D\3067\306F\3001\9650\3089\308C\305F\6587\5B57\306E\30BB\30C3\30C8\306E\307F\3092\30A8\30B9\30B1\30FC\30D7\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279269038931868831)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3(%0)\3067\53C2\7167\3055\308C\3066\3044\308B\30DC\30BF\30F3\306E\30DC\30BF\30F3\5C5E\6027\306BID\304C\691C\51FA\3055\308C\307E\3057\305F\3002 '),
'',
unistr('\30DC\30BF\30F3\5C5E\6027\3067ID\304C\5B9A\7FA9\3055\308C\3066\3044\308B\3068\3001\30DC\30BF\30F3\3092\53C2\7167\3059\308B\52D5\7684\30A2\30AF\30B7\30E7\30F3\304C\52D5\4F5C\3057\307E\305B\3093\3002\30DC\30BF\30F3\306F\30C7\30D5\30A9\30EB\30C8\3067ID\3092\751F\6210\3059\308B\305F\3081\3001\3053\306EID\3092\524A\9664\3057\3066\304F\3060\3055\3044\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279269163821868831)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3(%0)\3067\53C2\7167\3055\308C\3066\3044\308B\30DC\30BF\30F3\304C\4F7F\7528\3059\308B\30DC\30BF\30F3\30C6\30F3\30D7\30EC\30FC\30C8\306B\3001#BUTTON_ID#\7F6E\63DB\6587\5B57\5217\304C\542B\307E\308C\3066\3044\307E\305B\3093\3002'),
'',
unistr('\30C6\30F3\30D7\30EC\30FC\30C8:'),
'%1',
'',
unistr('\3053\306E\30C6\30F3\30D7\30EC\30FC\30C8\306B#BUTTON_ID#\7F6E\63DB\6587\5B57\5217\3092\8FFD\52A0\3059\308B\304B\3001\307E\305F\306F\30DC\30BF\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3092#BUTTON_ID#\7F6E\63DB\6587\5B57\5217\304C\542B\307E\308C\3066\3044\308B\3082\306E\306B\5909\66F4\3057\3066\304F\3060\3055\3044\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279271708684868833)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_language=>'ja'
,p_message_text=>unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3(%0)\3067\53C2\7167\3055\308C\3066\3044\308B\30DC\30BF\30F3\306E\300C\30A2\30AF\30B7\30E7\30F3\300D\304C\300C\52D5\7684\30A2\30AF\30B7\30E7\30F3\306B\3088\308B\5B9A\7FA9\300D\3067\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279278434138868837)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3(%0)\306E\300C\30A2\30AF\30B7\30E7\30F3\300D\304C\300C\52D5\7684\30A2\30AF\30B7\30E7\30F3\306B\3088\308B\5B9A\7FA9\300D\3067\3059\304C\3001\3053\306E\30DC\30BF\30F3\3092\53C2\7167\3059\308B\3001\5BFE\5FDC\3059\308B\52D5\7684\30A2\30AF\30B7\30E7\30F3\304C\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279845997077869185)
,p_name=>'ADVISOR.CHECK.CHART_TYPE_IS_ACCESSIBLE.MSG_ANYCHART_CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\308C\306F\53E4\3044AnyChart\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7\3067\3059\3002\30E6\30FC\30B6\30D3\30EA\30C6\30A3\3068\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\3092\5927\5E45\306B\5411\4E0A\3055\305B\308B\305F\3081\306B\3001\300C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9\300D\6A5F\80FD\3092\4F7F\7528\3057\3066\3053\306E\30C1\30E3\30FC\30C8\3092\79FB\884C\3057\3001\65B0\3057\3044Oracle JET\30D9\30FC\30B9\30FB\30C1\30E3\30FC\30C8\3092\4F7F\7528\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279343520580868879)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AD\30E3\30C3\30B7\30E5\3092\30AF\30EA\30A2\3059\308B\30DA\30FC\30B8%0\306F\3001\30AB\30EC\30F3\30C8\307E\305F\306F\30BF\30FC\30B2\30C3\30C8\30FB\30DA\30FC\30B8%1\3067\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279342248100868878)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280535015212869614)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\5C5E\6027\5024\306F\975E\63A8\5968\306B\306A\308A\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280536517548869615)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\30FB\30BF\30A4\30D7\306F\975E\63A8\5968\306B\306A\308A\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279977982183869267)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_language=>'ja'
,p_message_text=>unistr('Ajax\30B3\30FC\30EB\306E\4FDD\8B77\3055\308C\305F\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279365522459868892)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30FC\30C9\30FB\30B9\30E1\30EB(APEX\5185\90E8)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279340326339868876)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0\3001\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\3001\5217\3084\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306E\30D5\30A3\30EB\30BF\306E\5BA3\8A00\7684\53C2\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280562761962869630)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279340042531868876)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30A4\30F3\30C9\5909\6570\69CB\6587\3067\306E\53C2\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279341497114868877)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4ED6\306E\30D6\30E9\30F3\30C1\306E\524D\306E\6761\4EF6\306A\3057\30D6\30E9\30F3\30C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280563200503869631)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30E9\30A6\30B6\30FB\30BB\30AD\30E5\30EA\30C6\30A3\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279268934579868831)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3\306F\52D5\7684\30A2\30AF\30B7\30E7\30F3\3068\4E92\63DB\6027\304C\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279278245728868837)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_language=>'ja'
,p_message_text=>unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3\3068\30DC\30BF\30F3\9593\306E\53C2\7167\306B\4E00\8CAB\6027\304C\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279845773683869185)
,p_name=>'ADVISOR.CHECK.DESC_CHART_TYPE_IS_ACCESSIBLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7\3067\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\304C\30B5\30DD\30FC\30C8\3055\308C\3066\3044\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279340648103868877)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AD\30E3\30C3\30B7\30E5\3092\30AF\30EA\30A2\3059\308B\30DA\30FC\30B8\756A\53F7\3068\30BF\30FC\30B2\30C3\30C8\307E\305F\306F\73FE\5728\306E\30DA\30FC\30B8\304C\4E00\81F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279339930562868876)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\69CB\6587\3067\306E\53C2\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280534951424869614)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('\975E\63A8\5968\306E\5C5E\6027\5024')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279340923514868877)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A7\30C3\30C1\3001DML\3001MR*\30D7\30ED\30BB\30B9\304C\6709\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279341347697868877)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30FC\30C9\30B3\30FC\30C9\3055\308C\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279751919416869128)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\306B\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8\304C\3042\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279844217500869184)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306B\30DA\30FC\30B8\30FB\30BF\30A4\30C8\30EB\304C\3042\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279870391411869200)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\30A4\30E1\30FC\30B8\306E\8868\793A\300D\30A2\30A4\30C6\30E0\306B\306F\30A4\30E1\30FC\30B8ALT\30C6\30AD\30B9\30C8\304C\5B9A\7FA9\6E08\307F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280447604642869560)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30C3\30AF\30FB\30C0\30A6\30F3\53EF\80FD\306A\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279340148351868876)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\53C2\7167\30A2\30A4\30C6\30E0\306F\73FE\5728\306E\30DA\30FC\30B8\306B\3042\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279340233033868876)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\53C2\7167\30A2\30A4\30C6\30E0\306F\3001\30BF\30FC\30B2\30C3\30C8\30FB\30DA\30FC\30B8\306E\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279844950430869185)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\3067\4E88\671F\3057\306A\3044\30B3\30F3\30C6\30AD\30B9\30C8\5909\66F4\304C\767A\751F\3057\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279846168600869185)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\306B\30E9\30D9\30EB\304C\3042\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279341667735868877)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0\307E\305F\306F\8868\5F62\5F0F\30D5\30A9\30FC\30E0\306E\5217\540D\306E\9577\3055')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279340444648868877)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_language=>'ja'
,p_message_text=>unistr('\6587\5B57\5217\5185\306E\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\306E\53C2\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279340526809868877)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\53C2\7167\30DA\30FC\30B8\756A\53F7\304C\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279844585157869184)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3\306B\884C\30D8\30C3\30C0\30FC\304C\3042\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279341804872868877)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306B\30C7\30D5\30A9\30EB\30C8\306E\9806\5E8F\304C\3042\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280563362238869631)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\4FDD\8B77')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279341004196868877)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\7F6E\63DB\69CB\6587\306E\4F7F\7528\304C\4E0D\9069\5207')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279339819715868876)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_language=>'ja'
,p_message_text=>unistr('\7F6E\63DB\69CB\6587\3067\306E\53C2\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279340806405868877)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30FC\30B2\30C3\30C8\30FB\30DA\30FC\30B8\306E\8A8D\53EF\304C\73FE\5728\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306B\3082\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279844773507869184)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\306E\30C6\30B9\30C8\6E08\307F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279966609647869261)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306B\4E92\63DB\6027JavaScript\304C\542B\307E\308C\3066\3044\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279341557571868877)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\8A3C\306E\95A2\9023\4ED8\3051\3089\308C\305F\30A2\30A4\30C6\30E0\307E\305F\306F\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279340744300868877)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\307E\305F\306FPL/SQL\30B3\30FC\30C9\304C\6709\52B9\304B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279341248430868877)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_language=>'ja'
,p_message_text=>unistr('Clob\30D7\30ED\30D1\30C6\30A3\306E\691C\8A3C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279341132885868877)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\6587\3067\4F7F\7528\3055\308C\308BV\30D5\30A1\30F3\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279341789890868877)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\30DC\30BF\30F3\62BC\4E0B\6642\300D\5185\306E\300C\53C2\7167\30DC\30BF\30F3\300D\304C\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279344131374868879)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30D1\30A4\30EB\30FB\30A8\30E9\30FC - %0\6587: %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279344450037868879)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30F3\30AF\306B\3001\73FE\5728\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3ID\304C\30CF\30FC\30C9\30B3\30FC\30C9\5024\3068\3057\3066\542B\307E\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279751886084869128)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8\304C\5B9A\7FA9\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279844302711869184)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30DA\30FC\30B8\306B\306F\30DA\30FC\30B8\30FB\30BF\30A4\30C8\30EB\304C\3042\308A\307E\305B\3093\3002\30E6\30FC\30B6\30FC\304C\73FE\5728\306E\30DA\30FC\30B8\306E\5185\5BB9\3084\76EE\7684\3092\7406\89E3\3057\3084\3059\3044\3088\3046\306A\610F\5473\306E\3042\308B\30DA\30FC\30B8\30FB\30BF\30A4\30C8\30EB\3092\4ED8\3051\308B\3053\3068\304C\3001\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\306E\305F\3081\306B\91CD\8981\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279870483689869200)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30A4\30C6\30E0\306B\306F\3001\30A4\30E1\30FC\30B8\306B\5FC5\8981\306A\4EE3\66FF\30C6\30AD\30B9\30C8\304C\3042\308A\307E\305B\3093\3002\3053\308C\306B\4F7F\7528\3059\308B\30C6\30AD\30B9\30C8\306F\3001\30A4\30E1\30FC\30B8\306E\5185\5BB9\3092\9069\5207\306B\8868\3057\3066\3044\308B\3082\306E\306B\3057\3001\307E\305F\30A4\30E1\30FC\30B8\306E\30B3\30F3\30C6\30AD\30B9\30C8\3067\8868\793A\3055\308C\308B\30DA\30FC\30B8\306B\8868\793A\53EF\80FD\306A\3044\305A\308C\306E\60C5\5831\3068\3082\91CD\8907\3057\306A\3044\3082\306E\306B\3059\308B\5FC5\8981\304C\3042\308A\307E\3059(\91CD\8907\56DE\907F\306E\305F\3081)\3002\6CE8\610F: \30A4\30E1\30FC\30B8\3092\30E6\30FC\30B6\30FC\304C\63D0\4F9B\3059\308B\5834\5408\306F\3001\30A4\30E1\30FC\30B8\4EE3\66FF\30C6\30AD\30B9\30C8\3082\30E6\30FC\30B6\30FC\304C\63D0\4F9B\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002\305D\306E\969B\306F\3001\30E6\30FC\30B6\30FC\304C\9AD8\54C1\8CEA\306A\30C6\30AD\30B9\30C8\3092\63D0\4F9B\3067\304D\308B\3088\3046\306B\9069\5207\306A\30AC\30A4\30C0\30F3\30B9\304C\5FC5\8981\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280447774121869560)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\30E9\30F3\30BF\30A4\30E0API\306E\4F7F\7528\72B6\6CC1\300D\3067\306F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3068\30EF\30FC\30AF\30B9\30DA\30FC\30B9\3092\5909\66F4\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279342620875868878)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\3001\30DA\30FC\30B8%1\306E\30A2\30A4\30C6\30E0\3067\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279342705888868878)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\3001\30BF\30FC\30B2\30C3\30C8\30FB\30DA\30FC\30B8%1\306E\30A2\30A4\30C6\30E0\3067\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279845099283869185)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\306E\8A2D\5B9A\300C\9078\629E\6642\306E\30DA\30FC\30B8\30FB\30A2\30AF\30B7\30E7\30F3\300D\3067\306F\3001\30E6\30FC\30B6\30FC\306E\30B3\30F3\30C6\30AD\30B9\30C8\304C\4E88\671F\305B\305A\5909\66F4\3055\308C\308B\53EF\80FD\6027\304C\3042\308A\307E\3059\3002\30B3\30F3\30C6\30AD\30B9\30C8\304C\5909\66F4\3055\308C\308B\3053\3068\304C\306A\3044\3088\3046\306B\300C\306A\3057\300D\306B\5207\308A\66FF\3048\3001\3053\306E\6A5F\80FD\3092\52D5\7684\30A2\30AF\30B7\30E7\30F3\3084\30AB\30B9\30B1\30FC\30C9LOV\3067\7F6E\304D\63DB\3048\308B(\540C\3058\30DA\30FC\30B8\306B\7559\307E\308B\5FC5\8981\304C\3042\308B\5834\5408)\3053\3068\3092\691C\8A0E\3057\3066\304F\3060\3055\3044\3002\3042\308B\3044\306F\3001\5909\66F4\3055\308C\308B\3053\3068\304C\4E8B\524D\306B\30E6\30FC\30B6\30FC\306B\308F\304B\308B\3088\3046\306B\3001\30E6\30FC\30B6\30FC\306B\60C5\5831\3092\63D0\4F9B\3059\308B(\305F\3068\3048\3070\3001\30E9\30D9\30EB\306B\300C\65B0\3057\3044\30DA\30FC\30B8\304C\958B\304B\308C\308B\300D\3068\8FFD\52A0\3059\308B)\3053\3068\3092\691C\8A0E\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279870204146869200)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0\306E\30E9\30D9\30EB\3092\5B9A\7FA9\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002\8868\793A\53EF\80FD\306A\30E9\30D9\30EB\3092\975E\8868\793A\306B\3059\308B\5834\5408\3067\3082\3001\30E9\30D9\30EB\3092\5B9A\7FA9\3057\3066\304B\3089\3001\300C\975E\8868\793A\300D\30E9\30D9\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3092\9078\629E\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279846264191869185)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30A4\30C6\30E0\306F\300CValue Placeholder\300D\3068\3044\3046\5024\3092\5B9A\7FA9\3057\3066\3044\307E\3059\304C\3001\30E9\30D9\30EB\3092\5B9A\7FA9\3057\3066\3044\307E\305B\3093\3002\30D7\30EC\30FC\30B9\30DB\30EB\30C0\30FB\30C6\30AD\30B9\30C8\306F\3001\30A2\30A4\30C6\30E0\306E\30E9\30D9\30EB\4ED8\3051\306E\307F\3092\76EE\7684\3068\3057\3066\4F7F\7528\3057\306A\3044\3067\304F\3060\3055\3044\3002\3053\308C\306F\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\306E\554F\984C\306E\539F\56E0\3068\306A\308A\307E\3059\3002\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\3092\5411\4E0A\3055\305B\308B\305F\3081\306B\3001\30A2\30A4\30C6\30E0\30FB\30E9\30D9\30EB\3092\5B9A\7FA9\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002\8868\793A\53EF\80FD\306A\30E9\30D9\30EB\3092\975E\8868\793A\306B\3059\308B\5834\5408\3067\3082\3001\30E9\30D9\30EB\3092\5B9A\7FA9\3057\3066\304B\3089\3001\300C\975E\8868\793A\300D\30E9\30D9\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3092\9078\629E\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279344842833868879)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_language=>'ja'
,p_message_text=>unistr('\540D\524D\306F%0\6587\5B57\306E\9577\3055\304C\3042\308A\307E\3059\304C\3001\6700\5927\9577\306F30\6587\5B57\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279343015605868878)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\5B58\5728\3057\306A\3044\53EF\80FD\6027\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279343152202868878)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\3001\30DA\30FC\30B8\307E\305F\306F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0\3067\306A\3044\53EF\80FD\6027\304C\3042\308A\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279343486344868878)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AD\30E3\30C3\30B7\30E5\3092\30AF\30EA\30A2\3059\308B\30DA\30FC\30B8%1(\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3%0\5185)\306F\5B58\5728\3057\307E\305B\3093\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279343245923868878)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8%0\306F\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279343313153868878)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30FC\30B2\30C3\30C8\30FB\30DA\30FC\30B8%1(\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3%0\5185)\306F\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279768332130869138)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\300C\5217\5207\66FF\3048\300D\30EA\30FC\30B8\30E7\30F3\306B\306F\3001\300C\884C\30D8\30C3\30C0\30FC\3068\3057\3066\4F7F\7528\300D\304C\300C\306F\3044\300D\306B\8A2D\5B9A\3055\308C\305F\5217\304C\3042\308A\307E\305B\3093\3002\884C\30D8\30C3\30C0\30FC\5217\306F\3001\73FE\5728\306E\884C\3092\6700\3082\6B63\78BA\306B\8B58\5225\3059\308B\5217\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059(\9867\5BA2\60C5\5831\306E\30EC\30DD\30FC\30C8\306E\9867\5BA2\540D\306A\3069)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279768455098869138)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\300C\30EA\30D5\30ED\30FC\300D\30EA\30FC\30B8\30E7\30F3\306B\306F\3001\300C\884C\30D8\30C3\30C0\30FC\3068\3057\3066\4F7F\7528\300D\304C\300C\306F\3044\300D\306B\8A2D\5B9A\3055\308C\305F\5217\304C\3042\308A\307E\305B\3093\3002\884C\30D8\30C3\30C0\30FC\5217\306F\3001\73FE\5728\306E\884C\3092\6700\3082\6B63\78BA\306B\8B58\5225\3059\308B\5217\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059(\9867\5BA2\60C5\5831\306E\30EC\30DD\30FC\30C8\306E\9867\5BA2\540D\306A\3069)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279844689667869184)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\300C\8868\5F62\5F0F\30D5\30A9\30FC\30E0\300D\30EA\30FC\30B8\30E7\30F3\306B\306F\3001\300C\884C\30D8\30C3\30C0\30FC\3068\3057\3066\4F7F\7528\300D\304C\300C\306F\3044\300D\306B\8A2D\5B9A\3055\308C\305F\5217\304C\3042\308A\307E\305B\3093\3002\884C\30D8\30C3\30C0\30FC\5217\306F\3001\73FE\5728\306E\884C\3092\6700\3082\6B63\78BA\306B\8B58\5225\3059\308B\5217\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059(\9867\5BA2\60C5\5831\306E\8868\306E\9867\5BA2\540D\306A\3069)\3002\3053\306E\60C5\5831\306F\3001\8868\5F62\5F0F\30D5\30A9\30FC\30E0\306E\30EC\30F3\30C0\30EA\30F3\30B0\6642\306B\3001\5404\884C\306E\30D5\30A9\30FC\30E0\30FB\30D5\30A3\30FC\30EB\30C9\306B\4E00\610F\306E\30E9\30D9\30EB\3092\63D0\4F9B\3059\308B\305F\3081\306B\4F7F\7528\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279345064767868879)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306B\30C7\30D5\30A9\30EB\30C8\306E\9806\5E8F\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280448055197869560)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\30D6\30C3\30AF\30DE\30FC\30AF\30FB\30CF\30C3\30B7\30E5\95A2\6570\300D\306F\30EC\30AC\30B7\30FC\30FB\30A2\30EB\30B4\30EA\30BA\30E0\306B\8A2D\5B9A\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280448115411869560)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\4FDD\8B77\300D\304C\7121\52B9\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280563172742869631)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A7\30C3\30C1\30FB\30D7\30ED\30BB\30B9\3092\4F7F\7528\3057\305F\30DA\30FC\30B8\306E\5834\5408\3001\30DA\30FC\30B8\30FB\30A2\30AF\30BB\30B9\4FDD\8B77\3092\4F7F\7528\3057\3066\3001URL\3092\4ECB\3057\3066\6E21\3059\30A2\30A4\30C6\30E0\306E\4FDD\8B77\3092\6709\52B9\306B\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279301737673868852)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3\306B\3001APEX_UTIL.PREPARE_URL\3092\4ECB\3057\3066\6E21\3055\308C\306A\3044"f?p" URL\304C\542B\307E\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279344231520868879)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\53EF\80FD\6027\306E\3042\308BSQL\30A4\30F3\30B8\30A7\30AF\30B7\30E7\30F3\304C\691C\51FA\3055\308C\307E\3057\305F\3002SQL\3001PL/SQL\30B3\30FC\30C9\306E\7F6E\63DB\69CB\6587\307E\305F\306F\30D7\30ED\30BB\30B9\8868\540D\306B%0\304C\4F7F\7528\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279342088206868878)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279342107089868878)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\7F6E\63DB\69CB\6587\3067\53C2\7167\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279344067334868879)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30FC\30B2\30C3\30C8\30FB\30DA\30FC\30B8%1(\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3%0\5185)\306B\8A8D\53EF\30B9\30AD\30FC\30E0\304C\5B9A\7FA9\3055\308C\3066\3044\307E\3059\304C\3001\73FE\5728\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306B\306F\5B9A\7FA9\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279844881700869185)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\73FE\5728\306E\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306F\3001\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\306B\3064\3044\3066\30C6\30B9\30C8\3055\308C\3066\3044\307E\305B\3093\3002\300C\30C6\30B9\30C8\3055\308C\305F\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\300D\304C\300C\306F\3044\300D\306B\8A2D\5B9A\3055\308C\3066\3044\308B\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306B\5207\308A\66FF\3048\308B\304B\3001\73FE\5728\306E\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\304C\30C6\30B9\30C8\3055\308C\3066\3044\308B\5834\5408\306F\300C\30C6\30FC\30DE\300D\8A2D\5B9A\3067\300C\30C6\30B9\30C8\3055\308C\305F\30A2\30AF\30BB\30B7\30D3\30EA\30C6\30A3\300D\5C5E\6027\3092\300C\306F\3044\300D\306B\8A2D\5B9A\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279966839348869261)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306BjQuery Migrate\304C\542B\307E\308C\3066\3044\307E\3059\3002jQuery Migrate\3067\306F\3001\524A\9664\6E08\306EAPI\3092\30EA\30B9\30C8\30A2\3059\308B\3053\3068\306B\3088\3063\3066\65B0\3057\3044\30D0\30FC\30B8\30E7\30F3\306EjQuery\3078\306E\79FB\884C\304C\5BB9\6613\306B\306A\308A\3001\524A\9664\6E08\306EAPI\3084\975E\63A8\5968API\3092\4F7F\7528\3059\308B\3068\3001\30D6\30E9\30A6\30B6\30FB\30B3\30F3\30BD\30FC\30EB\306B\8B66\544A\304C\8868\793A\3055\308C\307E\3059\3002\3053\308C\306B\3088\308A\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\3059\3079\3066\306E\30DA\30FC\30B8\306B\8FFD\52A0\306EJavaScript\30D5\30A1\30A4\30EB\304C\7D44\307F\8FBC\307E\308C\307E\3059\3002\3053\308C\3092\524A\9664\3059\308B\305F\3081\306B\3001jQuery Migrate\306E\30A2\30C3\30D7\30B0\30EC\30FC\30C9\30FB\30AC\30A4\30C9\3067\3001\5909\66F4\304C\5FC5\8981\306AAPI\306E\8A73\7D30\3092\53C2\7167\3057\3066\304F\3060\3055\3044')
||unistr('\3002\3053\306E\3088\3046\306AAPI\3078\306E\4F9D\5B58\6027\304C\3059\3079\3066\306A\304F\306A\3063\305F\3089\3001\300CjQuery Migrate\3092\542B\3081\308B\300D\3092\300C\3044\3044\3048\300D\306B\8A2D\5B9A\3057\307E\3059\3002'),
'',
'https://github.com/jquery/jquery-migrate'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279966766263869261)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306B\975E\63A8\5968\307E\305F\306F\30B5\30DD\30FC\30C8\5BFE\8C61\5916\306EJavaScript\95A2\6570\304C\542B\307E\308C\3066\3044\307E\3059\3002\3053\308C\306B\3088\308A\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\3059\3079\3066\306E\30DA\30FC\30B8\306B\8FFD\52A0\306EJavaScript\30D5\30A1\30A4\30EB\304C\7D44\307F\8FBC\307E\308C\307E\3059\3002\3053\308C\3092\524A\9664\3059\308B\305F\3081\306B\3001\30EA\30EA\30FC\30B9\30FB\30CE\30FC\30C8\306E\975E\63A8\5968\6A5F\80FD\306B\95A2\3059\308B\9805\3092\53C2\7167\3057\3066\304F\3060\3055\3044\3002\3053\306E\9805\306B\306F\3001\975E\63A8\5968\307E\305F\306F\30B5\30DD\30FC\30C8\5BFE\8C61\5916\95A2\6570\3078\306E\4F9D\5B58\6027\3092\30C1\30A7\30C3\30AF\3057\3001\3053\308C\3092\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\7070\4E0A\3057\3066\3044\304F\65B9\6CD5\306B\95A2\3059\308B\624B\9806\304C\8A18\8F09\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279344712639868879)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\95A2\9023\4ED8\3051\3089\308C\305F\30A2\30A4\30C6\30E0\3084\5217\304C\5B9A\7FA9\3055\308C\3066\3044\307E\305B\3093\304C\3001\300C\30A8\30E9\30FC\30FB\30E1\30C3\30BB\30FC\30B8\8868\793A\4F4D\7F6E\300D\306B\3053\308C\304C\5FC5\8981\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279344655240868879)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\95A2\9023\4ED8\3051\3089\308C\3066\3044\308B\30A2\30A4\30C6\30E0\3084\5217\304C\3001\691C\8A3C\5F0F1\306B\6307\5B9A\3055\308C\3066\3044\308B"%0"\3068\7B49\3057\304F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279343670327868879)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30D1\30A4\30EB\30FB\30A8\30E9\30FC - %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279343777882868879)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\307E\305F\306FPL/SQL\30B3\30FC\30C9\304C\5B9A\7FA9\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279341915808868878)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_language=>'ja'
,p_message_text=>unistr('32767\3088\308A\9577\3044\304B\3002\6700\521D\306E32767\306E\307F\304C\30C1\30A7\30C3\30AF\3055\308C\307E\3059\3002\9577\3055: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279344392614868879)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\6587\306BV/NV/DV\30D5\30A1\30F3\30AF\30B7\30E7\30F3\30FB\30B3\30FC\30EB\304C\542B\307E\308C\3066\3044\307E\3059(\30D1\30D5\30A9\30FC\30DE\30F3\30B9\4E0A\306E\554F\984C\3068\306A\308B\53EF\80FD\6027\304C\3042\308A\307E\3059)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279344969377868879)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\53C2\7167\3055\308C\305F\30DC\30BF\30F3\306F\3059\3067\306B\5B58\5728\3057\307E\305B\3093\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279738433888869120)
,p_name=>'AFTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F8C')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279679740074869084)
,p_name=>'AGREEMENT_MISSING'
,p_message_language=>'ja'
,p_message_text=>unistr('\540C\610F\66F8\306E\6B20\843D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279484611523868966)
,p_name=>'ALIAS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\540D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280190806465869398)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\69CB\7BC9\3092\8A31\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280107616077869347)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\751F\7523\6027\304A\3088\3073\30B5\30F3\30D7\30EB\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A4\30F3\30B9\30C8\30FC\30EB\3092\8A31\53EF\3057\307E\3059\3002'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279942934009869246)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_language=>'ja'
,p_message_text=>unistr('RESTful\30B5\30FC\30D3\30B9\306E\4F7F\7528\306E\8A31\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280190991290869398)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\30EF\30FC\30AF\30B7\30E7\30C3\30D7\306E\4F7F\7528\3092\8A31\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280191162758869398)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30FC\30E0\958B\767A\306E\4F7F\7528\3092\8A31\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280190762368869398)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\30D1\30FC\30B8\3092\8A31\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280191059817869398)
,p_name=>'ALLOW_WEBSHEET_DEV'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B7\30FC\30C8\958B\767A\3092\8A31\53EF')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279503950518868978)
,p_name=>'ALL_APPLICATIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279289796461868845)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_language=>'ja'
,p_message_text=>unistr('- \3059\3079\3066 - ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279289529228868844)
,p_name=>'ALL_CATEGORIES'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30AB\30C6\30B4\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279289848118868845)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_language=>'ja'
,p_message_text=>unistr('- \3059\3079\3066\306E\30AB\30C6\30B4\30EA -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280193852160869400)
,p_name=>'ALL_MILESTONES'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30DE\30A4\30EB\30B9\30C8\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279871842887869201)
,p_name=>'ALL_RELEASES'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30EA\30EA\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279509889094868981)
,p_name=>'ALL_STATIC_FILES'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\9759\7684\30D5\30A1\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279508418667868980)
,p_name=>'ALL_THEMES'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30C6\30FC\30DE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280215532125869414)
,p_name=>'ALL_TYPES'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280215963349869414)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_language=>'ja'
,p_message_text=>unistr('- \3059\3079\3066\306E\30BF\30A4\30D7 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279505066835868978)
,p_name=>'ALL_USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30E6\30FC\30B6\30FC')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280557600987869627)
,p_name=>'ALREADY_IN_ACL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306F\3059\3067\306BAPEX\30A2\30AB\30A6\30F3\30C8\3092\6301\3063\3066\3044\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280547510027869621)
,p_name=>'ALREADY_IN_WS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306F\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306B\3059\3067\306B\5B58\5728\3057\307E\3059')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280508292570869597)
,p_name=>'ALWAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E38\6642')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279261226954868826)
,p_name=>'AM_PM'
,p_message_language=>'ja'
,p_message_text=>'AM / PM'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279755140326869130)
,p_name=>'ANALYSIS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\5206\6790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279755274948869130)
,p_name=>'ANALYZE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306B\3088\308B\5206\6790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279894113832869216)
,p_name=>'ANALYZE_TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\30E1\30BD\30C3\30C9\3092\4F7F\7528\3057\305F\89E3\6790')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279362841199868891)
,p_name=>'ANCHOR.SHOW_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\8868\793A')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279507308568868980)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\540D\30D6\30ED\30C3\30AF')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279349725854868882)
,p_name=>'ANSWERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\56DE\7B54')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279301471645868852)
,p_name=>'ANY_DEVELOPER'
,p_message_language=>'ja'
,p_message_text=>unistr('(\4EFB\610F\306E\958B\767A\8005)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280523348886869607)
,p_name=>'APEX.ACTIONS.TOGGLE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\5207\66FF\3048')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280562565825869630)
,p_name=>'APEX.ACTIVE_STATE'
,p_message_language=>'ja'
,p_message_text=>unistr('(\30A2\30AF\30C6\30A3\30D6)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280626198763869669)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5909\66F4:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280626030358869669)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6642\9593:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280630854684869672)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_language=>'ja'
,p_message_text=>'%0 K'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280626241878869669)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30D3\30E5\30FC: ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280148233341869372)
,p_name=>'APEX.AJAX_SERVER_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('Ajax\30B3\30FC\30EB\3067%1\306E\30B5\30FC\30D0\30FC\30FB\30A8\30E9\30FC%0\304C\8FD4\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280445606623869558)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('API\30B3\30FC\30EB\306F\7981\6B62\3055\308C\3066\3044\307E\3059\3002'),
unistr('\7BA1\7406\8005\306B\9023\7D61\3057\3066\304F\3060\3055\3044\3002'),
unistr('\3053\306E\30A4\30F3\30B7\30C7\30F3\30C8\306E\8A73\7D30\306F\3001\30C7\30D0\30C3\30B0ID "%0"\3088\308A\53C2\7167\3067\304D\307E\3059\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279552349036869007)
,p_name=>'APEX.APPLICATION.ALIAS.NON_UNIQUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5225\540D\300C%0\300D\306F\3001\4E00\610F\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3ID\306B\5909\63DB\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279552489109869007)
,p_name=>'APEX.APPLICATION.ALIAS.NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\540D"%0"\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304C\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279510074100868981)
,p_name=>'APEX.APPLICATION.ALIAS.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('ERR-1816 \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5225\540Dp_flow_alias_or_id(%0)\306E\5909\63DB\4E2D\306B\4E88\671F\3057\306A\3044\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279378831194868901)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_language=>'ja'
,p_message_text=>unistr('API\30B3\30FC\30EB"%0"\306F\3001Application Express\30D0\30FC\30B8\30E7\30F3%1\3067\306F\30C7\30B5\30DD\30FC\30C8\3055\308C\307E\3057\305F\3002\3053\306E\30A4\30F3\30B7\30C7\30F3\30C8\306E\8A73\7D30\306F\3001\30C7\30D0\30C3\30B0ID "%2"\3088\308A\53C2\7167\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279385541221868905)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNC.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\30D5\30A1\30F3\30AF\30B7\30E7\30F3\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279273101264868834)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\30D5\30A1\30F3\30AF\30B7\30E7\30F3\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280640945812869678)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.HOST_PREFIX_MISMATCH'
,p_message_language=>'ja'
,p_message_text=>unistr('Oracle Cloud Identity Management\306B\3088\3063\3066\8FD4\3055\308C\305F\30C6\30CA\30F3\30C8\540D%0\304C\3001\30C9\30E1\30A4\30F3%1\306B\306F\8A31\53EF\3055\308C\3066\3044\307E\305B\3093\3002<br/><a href="&LOGOUT_URL.">\518D\30ED\30B0\30A4\30F3</a>\3057\3001\8A31\53EF\3055\308C\305F\30C6\30CA\30F3\30C8\540D\3092\6307\5B9A\3059\308B\304BURL\3092\5909\66F4\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279266234410868830)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.USER_IS_NOT_DEVELOPER'
,p_message_language=>'ja'
,p_message_text=>unistr('\3054\4F7F\7528\306E\30A2\30AB\30A6\30F3\30C8"%0"\306B\306F\3001\30EF\30FC\30AF\30B9\30DA\30FC\30B9"%1"\306B\5FC5\8981\306A\958B\767A\6A29\9650(DB_DEVELOPER\307E\305F\306FDB_ADMINISTRATOR)<br/>\304C\3042\308A\307E\305B\3093\3002\6A29\9650\3092\4ED8\4E0E\3057\3066\304B\3089<a href="&LOGOUT_URL.">\518D\30ED\30B0\30A4\30F3</a>\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279261696366868827)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.WRONG_GROUP_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('Oracle Cloud Identity Management\306B\3088\3063\3066\8FD4\3055\308C\305F\30C6\30CA\30F3\30C8\540D\304C\3001\73FE\5728\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306B\306F\8A31\53EF\3055\308C\3066\3044\307E\305B\3093\3002<br/><a href="&LOGOUT_URL.">\518D\30ED\30B0\30A4\30F3</a>\3057\3001\8A31\53EF\3055\308C\305F\30C6\30CA\30F3\30C8\540D\3092\6307\5B9A\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279399825679868914)
,p_name=>'APEX.AUTHENTICATION.HEADER.DUPLICATE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('HTTP\30D8\30C3\30C0\30FC%0\304C2\56DE\9001\4FE1\3055\308C\307E\3057\305F\3002\653B\6483\3067\3042\308B\53EF\80FD\6027\304C\3042\308A\307E\3059\3002'),
'<ul>',
unistr('<li>1\756A\76EE\306E\5024: "%1"</li>'),
unistr('<li>2\756A\76EE\306E\5024: "%2"</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279266446187868830)
,p_name=>'APEX.AUTHENTICATION.HOST_PREFIX_MISMATCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30AD\30E5\30EA\30C6\30A3\4E0A\306E\7406\7531\3067\3001URL\306E\30C9\30E1\30A4\30F3\3092\4ECB\3057\3066\3053\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\5B9F\884C\3059\308B\3053\3068\306F\8A31\53EF\3055\308C\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279385262631868905)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.ASK_FOR_INSTALLATION'
,p_message_language=>'ja'
,p_message_text=>unistr('DBA\306B$ORACLE_HOME/rdbms/admin/catldap.sql\306E\5B9F\884C\3092\4F9D\983C\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279385150218868905)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.MISSING'
,p_message_language=>'ja'
,p_message_text=>unistr('SYS.DBMS_LDAP\30D1\30C3\30B1\30FC\30B8\304C\5B58\5728\3057\306A\3044\304B\7121\52B9\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279385043270868905)
,p_name=>'APEX.AUTHENTICATION.LDAP.EDIT_USER_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('LDAP\30E6\30FC\30B6\30FC\95A2\6570\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279385306301868905)
,p_name=>'APEX.AUTHENTICATION.LDAP.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('LDAP\8A8D\8A3C\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279386527770868906)
,p_name=>'APEX.AUTHENTICATION.LOGIN.ILLEGAL_PAGE_ARG'
,p_message_language=>'ja'
,p_message_text=>unistr('login_page\30D7\30ED\30B7\30FC\30B8\30E3\306B\5BFE\3059\308Bp_flow_page\5F15\6570\3067\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279386060888868905)
,p_name=>'APEX.AUTHENTICATION.LOGIN.INVALID_ARG'
,p_message_language=>'ja'
,p_message_text=>unistr('wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1\3067\306E\7121\52B9\306Ap_session\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279385835008868905)
,p_name=>'APEX.AUTHENTICATION.LOGIN.MALFORMED_ARGS'
,p_message_language=>'ja'
,p_message_text=>unistr('wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2\306B\5BFE\3059\308B\8AA4\3063\305F\5F15\6570\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279386211764868906)
,p_name=>'APEX.AUTHENTICATION.LOGIN.NULL_USER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30B0\30A4\30F3\30FB\30D7\30ED\30B7\30FC\30B8\30E3\306B\6E21\3055\308C\305F\30E6\30FC\30B6\30FC\540D\304CNULL\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279285908710868842)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.COUNTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\518D\30ED\30B0\30A4\30F3\307E\3067<span id="apex_login_throttle_sec">%0</span>\79D2\304A\5F85\3061\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279290922290868845)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30B0\30A4\30F3\8A66\884C\304C\30D6\30ED\30C3\30AF\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279726295653869112)
,p_name=>'APEX.AUTHENTICATION.NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C"%0"\304C\898B\3064\304B\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279299508558868851)
,p_name=>'APEX.AUTHENTICATION.NO_SECURITY_GROUP_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30AD\30E5\30EA\30C6\30A3\30FB\30B0\30EB\30FC\30D7ID\304CNULL\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279385718641868905)
,p_name=>'APEX.AUTHENTICATION.POST_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\5F8C\51E6\7406\306E\5B9F\884C\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279385474116868905)
,p_name=>'APEX.AUTHENTICATION.PRE_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\524D\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279404909228868917)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD.INSTRUCTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9\306E\518D\8A2D\5B9A\30EA\30AF\30A8\30B9\30C8\3092\958B\59CB\3057\305F\30D6\30E9\30A6\30B6\3067URL\3092\958B\3044\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280625338291869669)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD_URL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9\518D\8A2D\5B9A\306EURL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279266622001868830)
,p_name=>'APEX.AUTHENTICATION.RM_GROUP_NOT_GRANTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30BD\30FC\30B9\30FB\30DE\30CD\30FC\30B8\30E3\30FB\30B3\30F3\30B7\30E5\30FC\30DE\30FB\30B0\30EB\30FC\30D7%0\306B\306F%1\304C\4ED8\4E0E\3055\308C\3066\3044\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279266750680868830)
,p_name=>'APEX.AUTHENTICATION.RM_INFO_TO_GRANT'
,p_message_language=>'ja'
,p_message_text=>unistr('DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP\3092\4F7F\7528\3057\3066\3001\6B20\843D\3057\3066\3044\308B\6A29\9650\3092\4ED8\4E0E\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279462788847868953)
,p_name=>'APEX.AUTHENTICATION.SESSION_SENTRY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3\76E3\8996\30D5\30A1\30F3\30AF\30B7\30E7\30F3\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279462820833868953)
,p_name=>'APEX.AUTHENTICATION.SESSION_VERIFY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3\691C\8A3C\30D5\30A1\30F3\30AF\30B7\30E7\30F3\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279463050899868953)
,p_name=>'APEX.AUTHENTICATION.SSO.ASK_FOR_INSTALLATION'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\7BA1\7406\8005\306BOracle Application Server Single Sign-On\306E\30A8\30F3\30B8\30F3\306E\69CB\6210\3092\4F9D\983C\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279539161444868999)
,p_name=>'APEX.AUTHENTICATION.SSO.BAD_URLC'
,p_message_language=>'ja'
,p_message_text=>unistr('SSO\306B\3088\3063\3066\3001%1\30C8\30FC\30AF\30F3\306E\7121\52B9\306A%0\304C\623B\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279386473013868906)
,p_name=>'APEX.AUTHENTICATION.SSO.FIX_PARTNER_APP'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0\3092\7DE8\96C6\3057\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\3092\8FFD\52A0\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279538747713868998)
,p_name=>'APEX.AUTHENTICATION.SSO.ILLEGAL_CALLER'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\30D7\30ED\30B7\30FC\30B8\30E3\306E\7121\52B9\306A\30B3\30FC\30EB\5143:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279538987741868999)
,p_name=>'APEX.AUTHENTICATION.SSO.INVALID_APP_SESSION'
,p_message_language=>'ja'
,p_message_text=>unistr('urlc\30C8\30FC\30AF\30F3\3067\306E\7121\52B9\306A\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30BB\30C3\30B7\30E7\30F3: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279538508361868998)
,p_name=>'APEX.AUTHENTICATION.SSO.MISSING_APP_REGISTRATION'
,p_message_language=>'ja'
,p_message_text=>unistr('portal_sso_redirect\3067\306E\30A8\30E9\30FC: \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\767B\9332\60C5\5831\306E\6B20\843D: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279462930726868953)
,p_name=>'APEX.AUTHENTICATION.SSO.PACKAGE_MISSING'
,p_message_language=>'ja'
,p_message_text=>unistr('WWSEC_SSO_ENABLER_PRIVATE\30D1\30C3\30B1\30FC\30B8\304C\3001\5B58\5728\3057\306A\3044\304B\7121\52B9\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279386312887868906)
,p_name=>'APEX.AUTHENTICATION.SSO.PARTNER_APP_IS_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0\3067\767B\9332\6E08\30D1\30FC\30C8\30CA\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\304C\898B\3064\304B\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279538670300868998)
,p_name=>'APEX.AUTHENTICATION.SSO.REGISTER_APP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30F3\30B9\30C8\30EC\30FC\30B7\30E7\30F3\30FB\30AC\30A4\30C9\3067\8AAC\660E\3055\308C\3066\3044\308B\3068\304A\308A\3001\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\767B\9332\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279463165898868953)
,p_name=>'APEX.AUTHENTICATION.SSO.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('SSO\8A8D\8A3C\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280542154008869618)
,p_name=>'APEX.AUTHENTICATION.UNAUTHORIZED_URL'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\53EF\3055\308C\3066\3044\306A\3044URL: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279462514722868953)
,p_name=>'APEX.AUTHENTICATION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279266599254868830)
,p_name=>'APEX.AUTHENTICATION.WORKSPACE_NOT_ASSIGNED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9"%0"\304C\975E\30A2\30AF\30C6\30A3\30D6\3067\3059\3002\7BA1\7406\8005\306B\9023\7D61\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279267757031868830)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED'
,p_message_language=>'ja'
,p_message_text=>'%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279288496732868844)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30BB\30AD\30E5\30EA\30C6\30A3\30FB\30C1\30A7\30C3\30AF\306B\3088\3063\3066\62D2\5426\3055\308C\305F\30A2\30AF\30BB\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279288547885868844)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306E\30BB\30AD\30E5\30EA\30C6\30A3\30FB\30C1\30A7\30C3\30AF\306B\3088\3063\3066\62D2\5426\3055\308C\305F\30A2\30AF\30BB\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279288647987868844)
,p_name=>'APEX.AUTHORIZATION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\53EF\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279765439247869136)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\306F\30EA\30B9\30C8\306B\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280147884087869371)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\5C02\7528\30D6\30E9\30F3\30C1\306F\3001\30DA\30FC\30B8\5C5E\6027\306E\300C\9001\4FE1\6642\306B\30EA\30ED\30FC\30C9\300D\304C\300C\6210\529F\306E\307F\300D\306B\8A2D\5B9A\3055\308C\3066\3044\308B\5834\5408\3001\30B5\30DD\30FC\30C8\3055\308C\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279512807088868983)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30E9\30F3\30C1\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279833361375869177)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX'
,p_message_language=>'ja'
,p_message_text=>'Built with %0 using %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279833474986869177)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX.ACCESSIBLE.LOVE'
,p_message_language=>'ja'
,p_message_text=>'love'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279870042310869200)
,p_name=>'APEX.CALCULATOR.ICON_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DD\30C3\30D7\30A2\30C3\30D7\8A08\7B97\6A5F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280498121603869591)
,p_name=>'APEX.CALENDAR.EVENT_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8\306E\8AAC\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280497987989869591)
,p_name=>'APEX.CALENDAR.EVENT_END'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86\65E5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280498283387869591)
,p_name=>'APEX.CALENDAR.EVENT_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8ID')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280497820229869591)
,p_name=>'APEX.CALENDAR.EVENT_START'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\59CB\65E5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280498068634869591)
,p_name=>'APEX.CALENDAR.EVENT_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8\30FB\30BF\30A4\30C8\30EB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279966124492869260)
,p_name=>'APEX.CLIPBOARD.COPIED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30EA\30C3\30D7\30DC\30FC\30C9\306B\30B3\30D4\30FC\3055\308C\307E\3057\305F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279959102158869256)
,p_name=>'APEX.CLIPBOARD.NOTSUP'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30D6\30E9\30A6\30B6\3067\306F\3001\30DC\30BF\30F3\307E\305F\306F\30E1\30CB\30E5\30FC\304B\3089\306E\30B3\30D4\30FC\304C\30B5\30DD\30FC\30C8\3055\308C\3066\3044\307E\305B\3093\3002[Ctrl]\3092\62BC\3057\306A\304C\3089[C]\3092\62BC\3059\304B\3001[Command]\3092\62BC\3057\306A\304C\3089[C]\3092\62BC\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279835409775869179)
,p_name=>'APEX.CLOSE_NOTIFICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\901A\77E5\3092\9589\3058\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279257273716868824)
,p_name=>'APEX.COLOR_PICKER.ICON_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DD\30C3\30D7\30A2\30C3\30D7\30FB\30AB\30E9\30FC\30FB\30D4\30C3\30AB\30FC: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280611347992869660)
,p_name=>'APEX.COMBOBOX.LIST_OF_VALUES'
,p_message_language=>'ja'
,p_message_text=>'LOV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280611456241869660)
,p_name=>'APEX.COMBOBOX.SHOW_ALL_VALUES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30B9\30C8\306E\30AA\30FC\30D7\30F3: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280562684638869630)
,p_name=>'APEX.COMPLETED_STATE'
,p_message_language=>'ja'
,p_message_text=>unistr('(\5B8C\4E86)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279267984575868831)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279490202748868969)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6761\4EF6\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279552921121869007)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0D\660E\306E\6761\4EF6\30BF\30A4\30D7"%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279518178283868986)
,p_name=>'APEX.CONTACT_ADMIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\306B\9023\7D61\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279600444630869036)
,p_name=>'APEX.CONTACT_ADMIN.DEBUG'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\306B\9023\7D61\3057\3066\304F\3060\3055\3044\3002'),
unistr('\3053\306E\30A4\30F3\30B7\30C7\30F3\30C8\306E\8A73\7D30\306F\3001\30C7\30D0\30C3\30B0ID "%0"\3088\308A\53C2\7167\3067\304D\307E\3059\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280485181080869583)
,p_name=>'APEX.CORRECT_ERRORS'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58\3059\308B\524D\306B\30A8\30E9\30FC\3092\4FEE\6B63\3057\3066\304F\3060\3055\3044\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280566892597869633)
,p_name=>'APEX.CURRENT_PROGRESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\5728\306E\9032\884C\72B6\6CC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280186174895869395)
,p_name=>'APEX.DATA_HAS_CHANGED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\304C\66F4\65B0\51E6\7406\3092\958B\59CB\3057\3066\304B\3089\3001\30C7\30FC\30BF\30D9\30FC\30B9\5185\306E\73FE\884C\30D0\30FC\30B8\30E7\30F3\306E\30C7\30FC\30BF\304C\5909\66F4\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279869962926869200)
,p_name=>'APEX.DATEPICKER.ICON_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DD\30C3\30D7\30A2\30C3\30D7\30FB\30AB\30EC\30F3\30C0: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279879015364869206)
,p_name=>'APEX.DATEPICKER_VALUE_GREATER_MAX_DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C\3001\6307\5B9A\3057\305F\6700\5927\65E5\4ED8%0\3088\308A\5927\304D\3044\5024\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279884318023869209)
,p_name=>'APEX.DATEPICKER_VALUE_INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C\3001\5F62\5F0F%0\3068\4E00\81F4\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279878991498869206)
,p_name=>'APEX.DATEPICKER_VALUE_LESS_MIN_DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C\3001\6307\5B9A\3057\305F\6700\5C0F\65E5\4ED8%0\3088\308A\5C0F\3055\3044\5024\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279879174677869206)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C\3001\6709\52B9\306A%0\3068%1\306E\7BC4\56F2\5185\306B\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279882651434869208)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_IN_YEAR_RANGE'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C\3001\6709\52B9\306A%0\3068%1\306E\5E74\306E\7BC4\56F2\5185\306B\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280485836167869583)
,p_name=>'APEX.DIALOG.CANCEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\53D6\6D88')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280591556176869648)
,p_name=>'APEX.DIALOG.CLOSE'
,p_message_language=>'ja'
,p_message_text=>unistr('\9589\3058\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280596557521869651)
,p_name=>'APEX.DIALOG.HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280485692924869583)
,p_name=>'APEX.DIALOG.OK'
,p_message_language=>'ja'
,p_message_text=>'OK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279697063178869095)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3%0\306E\30C0\30A4\30A2\30ED\30B0\30FB\30DA\30FC\30B8%1\3092\6B63\5E38\306B\30EC\30F3\30C0\30EA\30F3\30B0\3067\304D\307E\305B\3093\3002\30DA\30FC\30B8%1\3067\4F7F\7528\3055\308C\3066\3044\308B\30DA\30FC\30B8\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30BF\30A4\30D7\304C\30C0\30A4\30A2\30ED\30B0\30FB\30DA\30FC\30B8\3067\3001\9069\5207\306AJavaScript\30C0\30A4\30A2\30ED\30B0\521D\671F\5316\3001\30C0\30A4\30A2\30ED\30B0\30FB\30AF\30ED\30FC\30BA\304A\3088\3073\30C0\30A4\30A2\30ED\30B0\53D6\6D88\306E\30B3\30FC\30C9\304C\5B9A\7FA9\3055\308C\3066\3044\308B\3053\3068\3092\78BA\8A8D\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280485740766869583)
,p_name=>'APEX.DIALOG.SAVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280613297597869661)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_language=>'ja'
,p_message_text=>'Copyright &copy; %0, All rights reserved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280614055127869662)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280613174985869661)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\308C\306F\30B7\30B9\30C6\30E0\751F\6210\306E\30E1\30C3\30BB\30FC\30B8\3067\3059\3002\3053\306E\30E1\30C3\30BB\30FC\30B8\306B\8FD4\4FE1\3057\306A\3044\3067\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280622936479869667)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\74B0\5883')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280635524127869675)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_language=>'ja'
,p_message_text=>unistr('Oracle Application Express\30E6\30FC\30B6\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280614626131869662)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\306F\3058\3081\306B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280613393351869661)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_language=>'ja'
,p_message_text=>unistr('\3088\3046\3053\305D\3001%0\3055\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280614380093869662)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280623086916869667)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\30D1\30FC\30B8\306E\9632\6B62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280614589717869662)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\753B\9762\4E0A\306E\6307\793A\306B\5F93\3046\3053\3068\3067\3001\30EF\30FC\30AF\30B9\30DA\30FC\30B9\304C\30D1\30FC\30B8\3055\308C\308B\3053\3068\3092\56DE\907F\3067\304D\307E\3059\3002%0\65E5\9593\64CD\4F5C\3092\884C\308F\306A\3044\3068\3001\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306F\81EA\52D5\7684\306B\524A\9664\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280622768796869667)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\304C\5FC5\8981\306A\304F\306A\3063\305F\5834\5408\3001\30A2\30AF\30B7\30E7\30F3\306F\4E0D\8981\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280623218802869668)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\3092\30D1\30FC\30B8\3057\3088\3046\3068\3057\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280622598918869667)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9%0\306F\3001\6700\8FD1\306E\30A2\30AF\30C6\30A3\30D3\30C6\30A3\3092\8868\793A\3057\3066\304A\3089\305A\3001\307E\3082\306A\304F\30D1\30FC\30B8\3055\308C\308B\4E88\5B9A\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280622454275869667)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_language=>'ja'
,p_message_text=>unistr('\8B66\544A\3002\30EF\30FC\30AF\30B9\30DA\30FC\30B9"%0"\3092\30D1\30FC\30B8\3057\3088\3046\3068\3057\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280622805497869667)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30FC\30B8\65E5\4ED8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280623531198869668)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30EA\30AF\30A8\30B9\30C8\3092\5B8C\4E86\3057\3066\304F\3060\3055\3044\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280623311736869668)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9"%0"\306E\6E96\5099\304C\5B8C\4E86\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280623680529869668)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9"%0"\306F\627F\8A8D\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280623450273869668)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30EA\30AF\30A8\30B9\30C8\306F\62D2\5426\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280613991083869662)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280623124550869667)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_language=>'ja'
,p_message_text=>unistr('\8B66\544A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280613876790869662)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280613424675869661)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30EA\30AF\30A8\30B9\30C8\306F\627F\8A8D\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280614180147869662)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\627F\8A8D\30D7\30ED\30BB\30B9\3092\5B9F\884C\3057\3066\30D1\30B9\30EF\30FC\30C9\3092\8A2D\5B9A\3059\308B\306B\306F\3001\6B21\306E\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280613676058869662)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30EA\30AF\30A8\30B9\30C8\306F\627F\8A8D\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280614225989869662)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\59CB\3059\308B\306B\306F\3001\6B21\306E\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280614480882869662)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\6E96\5099\304C\5B8C\4E86\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280613560889869662)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30EA\30AF\30A8\30B9\30C8\306F\62D2\5426\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280613702497869662)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30EA\30AF\30A8\30B9\30C8\306F\62D2\5426\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279513108191868983)
,p_name=>'APEX.ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279263426997868828)
,p_name=>'APEX.ERROR.CALLBACK_FAILED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC\51E6\7406\30B3\30FC\30EB\30D0\30C3\30AF\306E\5B9F\884C\4E2D\306B\6B21\306E\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279304577061868854)
,p_name=>'APEX.ERROR.ERROR_PAGE.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC\30FB\30DA\30FC\30B8\306E\30DA\30A4\30F3\30C8\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279267265512868830)
,p_name=>'APEX.ERROR.INTERNAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5185\90E8\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280555612975869626)
,p_name=>'APEX.ERROR.INTERNAL.CONTACT_ADMINISTRATOR'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7BA1\7406\8005\306B\9023\7D61\3057\3066\304F\3060\3055\3044\3002'),
unistr('\3053\306E\30A4\30F3\30B7\30C7\30F3\30C8\306E\8A73\7D30\306F\3001\30C7\30D0\30C3\30B0ID "%0"\3088\308A\53C2\7167\3067\304D\307E\3059\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280636438488869676)
,p_name=>'APEX.ERROR.ORA-28353'
,p_message_language=>'ja'
,p_message_text=>unistr('ORA-28353: \30A6\30A9\30EC\30C3\30C8\306E\30AA\30FC\30D7\30F3\306B\5931\6557\3057\307E\3057\305F\3002\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30C7\30FC\30BF\306B\306F\73FE\5728\30A2\30AF\30BB\30B9\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280537851154869615)
,p_name=>'APEX.ERROR.PAGE_NOT_AVAILABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30DA\30FC\30B8\306F\4F7F\7528\3067\304D\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279273038401868834)
,p_name=>'APEX.ERROR.TECHNICAL_INFO'
,p_message_language=>'ja'
,p_message_text=>unistr('\6280\8853\60C5\5831(\958B\767A\8005\306E\307F\306B\8868\793A)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280100816133869343)
,p_name=>'APEX.ERROR_MESSAGE_HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC\30FB\30E1\30C3\30BB\30FC\30B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280174765505869388)
,p_name=>'APEX.EXPECTED_FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5FC5\8981\306A\66F8\5F0F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279898319651869218)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.ALREADY_IN_ACL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306F\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306B\3059\3067\306B\5B58\5728\3057\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279898259657869218)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.CREATE_CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0 <strong>%1</strong>\30E6\30FC\30B6\30FC\306E\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\3078\306E\8FFD\52A0\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279898780685869219)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.DUPLICATE_USE'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8907\3059\308B\30E6\30FC\30B6\30FC\304C\5B58\5728\3057\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279898453406869219)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_AT_SIGN'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\306B\30A2\30C3\30C8\30DE\30FC\30AF(@)\304C\3042\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279898556842869219)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_DO'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\306B\30D4\30EA\30AA\30C9(.)\304C\3042\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279898612619869219)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.USERNAME_TOO_LONG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D\304C\9577\3059\304E\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279898953513869219)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_ONLY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306B\5B9A\7FA9\3055\308C\305F\30E6\30FC\30B6\30FC\306E\307F\304C\3001\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\30A2\30AF\30BB\30B9\3067\304D\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279899058575869219)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_VALUE_INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E88\671F\3057\306A\3044\30A2\30AF\30BB\30B9\5236\5FA1\8A2D\5B9A\5024: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279898826402869219)
,p_name=>'APEX.FEATURE.ACL.INFO.ALL_USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\8A8D\8A3C\6E08\30E6\30FC\30B6\30FC\304C\3001\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\30A2\30AF\30BB\30B9\3067\304D\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280444427592869558)
,p_name=>'APEX.FEATURE.CONFIG.DISABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280444346964869558)
,p_name=>'APEX.FEATURE.CONFIG.ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280445432991869558)
,p_name=>'APEX.FEATURE.CONFIG.IS_DISABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('%0: \7121\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280444515238869558)
,p_name=>'APEX.FEATURE.CONFIG.IS_ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('%0: \6709\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279834103047869178)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AD\30E5\30FC\5F85\6A5F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279834207118869178)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280444269626869558)
,p_name=>'APEX.FEATURE.TOP_USERS.USERNAME.NOT_IDENTIFIED'
,p_message_language=>'ja'
,p_message_text=>unistr('\6307\5B9A\3055\308C\3066\3044\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279297878883868850)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF\30FB\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279297972116868850)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30FC\30D7\30F3\30FB\30D5\30A3\30FC\30C9\30D0\30C3\30AF\30FB\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279298050013868850)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280187863593869396)
,p_name=>'APEX.FILE_BROWSE.DOWNLOAD_LINK_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A6\30F3\30ED\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280181048787869392)
,p_name=>'APEX.FS.BATCH_APPLY'
,p_message_language=>'ja'
,p_message_text=>unistr('\9069\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280181557183869392)
,p_name=>'APEX.FS.CLEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30EA\30A2')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280181667239869392)
,p_name=>'APEX.FS.CLEAR_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\30AF\30EA\30A2')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280181744484869392)
,p_name=>'APEX.FS.CLEAR_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\30AF\30EA\30A2')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280512362461869600)
,p_name=>'APEX.FS.COLUMN_UNAUTHORIZED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217%1\306F\3001\30D5\30A1\30BB\30C3\30C8%0\306B\53C2\7167\3055\308C\3066\3044\307E\3059\304C\3001\4F7F\7528\3067\304D\306A\3044\304B\8A8D\53EF\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280504715509869595)
,p_name=>'APEX.FS.FACET_VALUE_LIMIT_EXCEEDED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30BB\30C3\30C8%1\3067\500B\5225\5024\306E\5236\9650(%0)\3092\8D85\3048\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280183224489869393)
,p_name=>'APEX.FS.FC_TYPE_UNSUPPORTED_FOR_DATE_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30BB\30C3\30C8%0\306F\3001DATE\307E\305F\306FTIMESTAMP\5217\3067\306F\30B5\30DD\30FC\30C8\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280181110982869392)
,p_name=>'APEX.FS.FILTER'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\30D5\30A3\30EB\30BF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280181248235869392)
,p_name=>'APEX.FS.GO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9F\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280182891612869393)
,p_name=>'APEX.FS.INPUT_CURRENT_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306B\7B49\3057\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280183031547869393)
,p_name=>'APEX.FS.NO_SEARCH_COLUMNS_PROVIDED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30BB\30C3\30C8%0\306B\5BFE\3057\3066\691C\7D22\5217\304C\63D0\4F9B\3055\308C\3066\3044\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280182558098869393)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304B\3089%1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280182638618869393)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_HI'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\3092\4E0A\56DE\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280182753682869393)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_LO'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\3092\4E0B\56DE\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280523182768869606)
,p_name=>'APEX.FS.RANGE_LOV_ITEM_INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BC4\56F2\30D5\30A1\30BB\30C3\30C8%0\306ELOV\30A2\30A4\30C6\30E0#%2 ("%1")\304C\7121\52B9\3067\3059("|"\30BB\30D1\30EC\30FC\30BF\304C\3042\308A\307E\305B\3093)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280182908156869393)
,p_name=>'APEX.FS.RANGE_MANUAL_NOT_SUPPORTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BC4\56F2\30D5\30A1\30BB\30C3\30C8%0\306E\624B\52D5\5165\529B\306F\3001\5217\304CDATE\307E\305F\306FTIMESTAMP\3067\3042\308B\305F\3081\73FE\5728\30B5\30DD\30FC\30C8\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280182164866869392)
,p_name=>'APEX.FS.RANGE_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9B\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280181457062869392)
,p_name=>'APEX.FS.SEARCH_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280181353067869392)
,p_name=>'APEX.FS.SEARCH_PLACEHOLDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280182391447869393)
,p_name=>'APEX.FS.SELECT_PLACEHOLDER'
,p_message_language=>'ja'
,p_message_text=>unistr('- \9078\629E -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280181955867869392)
,p_name=>'APEX.FS.SHOW_LESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C11\306A\304F\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280182009630869392)
,p_name=>'APEX.FS.SHOW_MORE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3055\3089\306B\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280182254923869393)
,p_name=>'APEX.FS.STAR_RATING_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\661F\4EE5\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280183196594869393)
,p_name=>'APEX.FS.TEXT_FIELD_ONLY_FOR_NUMBER_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30AD\30B9\30C8\30FB\30D5\30A3\30FC\30EB\30C9\30FB\30D5\30A1\30BB\30C3\30C8%0\306F\3001\73FE\5728NUMBER\5217\3067\306E\307F\30B5\30DD\30FC\30C8\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280512595764869600)
,p_name=>'APEX.FS.UNSUPPORTED_DATA_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\30C7\30FC\30BF\578B(%1)\306F\3001\30D5\30A1\30BB\30C3\30C8\691C\7D22\3067\30B5\30DD\30FC\30C8\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280446007150869559)
,p_name=>'APEX.GO_TO_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC\306B\79FB\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279658958633869072)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7"%0"\304C\898B\3064\304B\308A\307E\305B\3093\3067\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279904869201869223)
,p_name=>'APEX.GV.AGG_CONTEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\96C6\8A08\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280013424319869289)
,p_name=>'APEX.GV.BREAK_COLLAPSE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\3092\9589\3058\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279904905608869223)
,p_name=>'APEX.GV.BREAK_CONTEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280013351584869289)
,p_name=>'APEX.GV.BREAK_EXPAND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\3092\958B\304F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280642683516869680)
,p_name=>'APEX.GV.COLUMN_CONTEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217%0\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280013154528869289)
,p_name=>'APEX.GV.DELETED_COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\884C\524A\9664\3055\308C\307E\3057\305F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280602107167869655)
,p_name=>'APEX.GV.DUP_REC_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8907\30A2\30A4\30C7\30F3\30C6\30A3\30C6\30A3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279891808869869214)
,p_name=>'APEX.GV.FIRST_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\521D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279905105433869223)
,p_name=>'APEX.GV.GROUP_CONTEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\30FB\30D8\30C3\30C0\30FC\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279905012025869223)
,p_name=>'APEX.GV.HEADER_CONTEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D8\30C3\30C0\30FC\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279891989603869214)
,p_name=>'APEX.GV.LAST_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5F8C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280053780404869314)
,p_name=>'APEX.GV.LOAD_MORE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3055\3089\306B\884C\3092\30ED\30FC\30C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279891639837869214)
,p_name=>'APEX.GV.NEXT_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279905200552869223)
,p_name=>'APEX.GV.PAGE_RANGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279892010817869215)
,p_name=>'APEX.GV.PAGE_RANGE_XY'
,p_message_language=>'ja'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279892143079869215)
,p_name=>'APEX.GV.PAGE_RANGE_XYZ'
,p_message_language=>'ja'
,p_message_text=>unistr('%2\4EF6\4E2D%0-%1\4EF6\76EE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279891798391869214)
,p_name=>'APEX.GV.PREV_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280601986876869654)
,p_name=>'APEX.GV.ROW_ADDED'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0\6E08')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280602074684869655)
,p_name=>'APEX.GV.ROW_CHANGED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5909\66F4\6E08')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280642483728869679)
,p_name=>'APEX.GV.ROW_COLUMN_CONTEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C%0\3001\5217%1\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280642599385869679)
,p_name=>'APEX.GV.ROW_CONTEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C%0\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280601882974869654)
,p_name=>'APEX.GV.ROW_DELETED'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664\6E08')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279934044805869241)
,p_name=>'APEX.GV.ROW_HEADER'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\30D8\30C3\30C0\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279890905927869214)
,p_name=>'APEX.GV.SELECTION_CELL_COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\30BB\30EB\304C\9078\629E\3055\308C\307E\3057\305F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279892232988869215)
,p_name=>'APEX.GV.SELECTION_COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\884C\304C\9078\629E\3055\308C\307E\3057\305F\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280237687849869428)
,p_name=>'APEX.GV.SELECT_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\9078\629E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280013280030869289)
,p_name=>'APEX.GV.SELECT_PAGE_N'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8%0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279933962616869241)
,p_name=>'APEX.GV.SELECT_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\9078\629E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279936544056869242)
,p_name=>'APEX.GV.SORTED_ASCENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\6607\9806\30BD\30FC\30C8\6E08%0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279936650240869242)
,p_name=>'APEX.GV.SORTED_DESCENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\964D\9806\30BD\30FC\30C8\6E08%0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279891110376869214)
,p_name=>'APEX.GV.SORT_ASCENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\6607\9806\30BD\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279891421033869214)
,p_name=>'APEX.GV.SORT_ASCENDING_ORDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\6607\9806\30BD\30FC\30C8 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279891261673869214)
,p_name=>'APEX.GV.SORT_DESCENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\964D\9806\30BD\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279891594533869214)
,p_name=>'APEX.GV.SORT_DESCENDING_ORDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\964D\9806\30BD\30FC\30C8 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279891335939869214)
,p_name=>'APEX.GV.SORT_OFF'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8\3057\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280013015244869289)
,p_name=>'APEX.GV.TOTAL_PAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5408\8A08 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280576353325869639)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C9\30AD\30E5\30E1\30F3\30C8\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280595870426869651)
,p_name=>'APEX.ICON_LIST.GRID_DIM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EA\30C3\30C9\9078\629E\30EA\30B9\30C8%0\5217\306E%1\884C\3002\77E2\5370\30AD\30FC\3092\4F7F\7528\3057\307E\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280012118319869289)
,p_name=>'APEX.ICON_LIST.LIST_DIM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30B9\30C8%0\884C\3092\9078\629E\3057\307E\3059\3002\77E2\5370\30AD\30FC\3092\4F7F\7528\3057\3066\304F\3060\3055\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280642261010869679)
,p_name=>'APEX.IG.ACC_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30B0\30EA\30C3\30C9%0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279874351269869203)
,p_name=>'APEX.IG.ACTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279875312203869203)
,p_name=>'APEX.IG.ADD'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279875239499869203)
,p_name=>'APEX.IG.ADD_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\8FFD\52A0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280609948586869659)
,p_name=>'APEX.IG.AGGREGATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\96C6\8A08')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280572882530869637)
,p_name=>'APEX.IG.AGGREGATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\96C6\8A08')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280575860254869638)
,p_name=>'APEX.IG.ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280133035830869362)
,p_name=>'APEX.IG.ALL_TEXT_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30C6\30AD\30B9\30C8\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280134229851869363)
,p_name=>'APEX.IG.ALTERNATIVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4EE3\66FF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280135313518869364)
,p_name=>'APEX.IG.AND'
,p_message_language=>'ja'
,p_message_text=>unistr('\304B\3089')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280481312393869581)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\3005\306B\30AB\30A6\30F3\30C8(\6982\6570)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280610996028869660)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT_OVERALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\3005\306B\30AB\30A6\30F3\30C8(\5168\4F53\306E\6982\6570)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280568906605869634)
,p_name=>'APEX.IG.AREA'
,p_message_language=>'ja'
,p_message_text=>unistr('\9762')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280574452498869638)
,p_name=>'APEX.IG.ASCENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\6607\9806')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280134302177869363)
,p_name=>'APEX.IG.AUTHORIZATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\53EF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280610007425869659)
,p_name=>'APEX.IG.AUTO'
,p_message_language=>'ja'
,p_message_text=>unistr('\81EA\52D5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280481791094869581)
,p_name=>'APEX.IG.AVG'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E73\5747')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280610650328869660)
,p_name=>'APEX.IG.AVG_OVERALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5168\4F53\306E\5E73\5747')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280568489319869634)
,p_name=>'APEX.IG.AXIS_LABEL_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB\306E\8EF8\30BF\30A4\30C8\30EB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280568669016869634)
,p_name=>'APEX.IG.AXIS_VALUE_DECIMAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C0F\6570\70B9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280568550848869634)
,p_name=>'APEX.IG.AXIS_VALUE_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024\306E\8EF8\30BF\30A4\30C8\30EB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280582624188869643)
,p_name=>'APEX.IG.BACKGROUND_COLOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30C3\30AF\30B0\30E9\30A6\30F3\30C9\30FB\30AB\30E9\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280569043954869634)
,p_name=>'APEX.IG.BAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\68D2')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280116799742869352)
,p_name=>'APEX.IG.BETWEEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\6B21\306E\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280584370535869644)
,p_name=>'APEX.IG.BOTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E21\65B9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280569176401869634)
,p_name=>'APEX.IG.BUBBLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30D6\30EB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279875599812869203)
,p_name=>'APEX.IG.CANCEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\53D6\6D88')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280135223778869364)
,p_name=>'APEX.IG.CASE_SENSITIVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5927/\5C0F\6587\5B57\533A\5225')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280611545658869660)
,p_name=>'APEX.IG.CASE_SENSITIVE_WITH_BRACKETS'
,p_message_language=>'ja'
,p_message_text=>unistr('(\5927/\5C0F\6587\5B57\533A\5225)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280521064288869605)
,p_name=>'APEX.IG.CHANGES_SAVED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5909\66F4\304C\4FDD\5B58\3055\308C\307E\3057\305F')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279875904244869204)
,p_name=>'APEX.IG.CHANGE_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\306E\5909\66F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280136338698869364)
,p_name=>'APEX.IG.CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280131719071869362)
,p_name=>'APEX.IG.CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\5408\305B\306F\30011\30C1\30E3\30FC\30C8\5F53\305F\308A\306E\6700\5927\30C7\30FC\30BF\30FB\30DD\30A4\30F3\30C8\6570\3067\3042\308B%0\3092\8D85\3048\3066\3044\307E\3059\3002\30D5\30A3\30EB\30BF\3092\9069\7528\3057\3066\3001\30D9\30FC\30B9\554F\5408\305B\306E\30EC\30B3\30FC\30C9\6570\3092\524A\6E1B\3057\3066\304F\3060\3055\3044\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279874253935869203)
,p_name=>'APEX.IG.CHART_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30D3\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279937565940869243)
,p_name=>'APEX.IG.CLEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30EA\30A2')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280567958282869634)
,p_name=>'APEX.IG.CLOSE_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\9589\3058\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280583340431869643)
,p_name=>'APEX.IG.COLORS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30E9\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280583234981869643)
,p_name=>'APEX.IG.COLOR_BLUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EB\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280583102021869643)
,p_name=>'APEX.IG.COLOR_GREEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EA\30FC\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280582945512869643)
,p_name=>'APEX.IG.COLOR_ORANGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30EC\30F3\30B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280583092274869643)
,p_name=>'APEX.IG.COLOR_RED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30C3\30C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280582800125869643)
,p_name=>'APEX.IG.COLOR_YELLOW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30A8\30ED\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280134658656869363)
,p_name=>'APEX.IG.COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279874483516869203)
,p_name=>'APEX.IG.COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280588167742869646)
,p_name=>'APEX.IG.COLUMN_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\306E\76EE\7684')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280134746242869363)
,p_name=>'APEX.IG.COMPLEX'
,p_message_language=>'ja'
,p_message_text=>unistr('\8907\5408')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279874601687869203)
,p_name=>'APEX.IG.COMPUTE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280117398495869353)
,p_name=>'APEX.IG.CONTAINS'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\6B21\3092\542B\3080')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280140620454869367)
,p_name=>'APEX.IG.CONTROL_BREAK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279937305325869243)
,p_name=>'APEX.IG.COPY_CB'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30EA\30C3\30D7\30DC\30FC\30C9\306B\30B3\30D4\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279937433579869243)
,p_name=>'APEX.IG.COPY_DOWN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30D4\30FC\30FB\30C0\30A6\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280481136850869581)
,p_name=>'APEX.IG.COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4EF6\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280481284132869581)
,p_name=>'APEX.IG.COUNT_DISTINCT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\3005\306B\30AB\30A6\30F3\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280610858372869660)
,p_name=>'APEX.IG.COUNT_DISTINCT_OVERALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\3005\306B\30AB\30A6\30F3\30C8(\5168\4F53)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280610715593869660)
,p_name=>'APEX.IG.COUNT_OVERALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5168\4EF6\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280602228174869655)
,p_name=>'APEX.IG.CREATE_X'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\4F5C\6210')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280133250262869363)
,p_name=>'APEX.IG.DATA'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280585521939869644)
,p_name=>'APEX.IG.DATA_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280584569433869644)
,p_name=>'APEX.IG.DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5\4ED8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280520892353869605)
,p_name=>'APEX.IG.DATE_INVALID_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5\4ED8\5024\304C\7121\52B9\3067\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280118285035869353)
,p_name=>'APEX.IG.DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280133947027869363)
,p_name=>'APEX.IG.DEFAULT_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280133759879869363)
,p_name=>'APEX.IG.DEFAULT_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\30FB\30BF\30A4\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279875468643869203)
,p_name=>'APEX.IG.DELETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280589159123869647)
,p_name=>'APEX.IG.DELETE_REPORT_CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30EC\30DD\30FC\30C8\3092\524A\9664\3057\3066\3082\3088\3044\3067\3059\304B\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280142496621869368)
,p_name=>'APEX.IG.DELETE_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280141260818869367)
,p_name=>'APEX.IG.DELETE_ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280574553249869638)
,p_name=>'APEX.IG.DESCENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\964D\9806')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280136002286869364)
,p_name=>'APEX.IG.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30A3\30C6\30FC\30EB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279873980913869202)
,p_name=>'APEX.IG.DETAIL_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\30D3\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280536771506869615)
,p_name=>'APEX.IG.DIRECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\65B9\5411')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280135773371869364)
,p_name=>'APEX.IG.DISABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280117490404869353)
,p_name=>'APEX.IG.DOES_NOT_CONTAIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\6B21\3092\542B\307E\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280117678826869353)
,p_name=>'APEX.IG.DOES_NOT_START_WITH'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3067\59CB\307E\3089\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280569211705869634)
,p_name=>'APEX.IG.DONUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C9\30FC\30CA\30C4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280140884139869367)
,p_name=>'APEX.IG.DOWNLOAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A6\30F3\30ED\30FC\30C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280590131307869647)
,p_name=>'APEX.IG.DOWNLOAD_FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F8\5F0F\306E\9078\629E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280575409520869638)
,p_name=>'APEX.IG.DUPLICATE_AGGREGATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8907\96C6\8A08')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280575510183869638)
,p_name=>'APEX.IG.DUPLICATE_CONTROLBREAK'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8907\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280142363509869368)
,p_name=>'APEX.IG.DUPLICATE_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8907\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280141156454869367)
,p_name=>'APEX.IG.DUPLICATE_ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8907\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279875079745869203)
,p_name=>'APEX.IG.EDIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7DE8\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280573984319869637)
,p_name=>'APEX.IG.EDIT_CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\306E\7DE8\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280597987333869652)
,p_name=>'APEX.IG.EDIT_GROUP_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316\306E\7DE8\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280589788729869647)
,p_name=>'APEX.IG.EMAIL_BCC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30E9\30A4\30F3\30C9\30FB\30B3\30D4\30FC(bcc)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280589977605869647)
,p_name=>'APEX.IG.EMAIL_BODY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E1\30C3\30BB\30FC\30B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280589675464869647)
,p_name=>'APEX.IG.EMAIL_CC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30D4\30FC(cc)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280589304832869647)
,p_name=>'APEX.IG.EMAIL_SENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\304C\9001\4FE1\3055\308C\307E\3057\305F\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280589832690869647)
,p_name=>'APEX.IG.EMAIL_SUBJECT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4EF6\540D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280589592850869647)
,p_name=>'APEX.IG.EMAIL_TO'
,p_message_language=>'ja'
,p_message_text=>unistr('\53D7\4FE1\8005(to)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280135407852869364)
,p_name=>'APEX.IG.ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280115758438869352)
,p_name=>'APEX.IG.EQUALS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3068\7B49\3057\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280588701182869646)
,p_name=>'APEX.IG.EXAMPLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F8B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280135568640869364)
,p_name=>'APEX.IG.EXPRESSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280588623906869646)
,p_name=>'APEX.IG.FD_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280237511359869428)
,p_name=>'APEX.IG.FILE_PREPARED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30A4\30EB\304C\6E96\5099\3055\308C\307E\3057\305F\3002\30C0\30A6\30F3\30ED\30FC\30C9\3092\958B\59CB\3057\3066\3044\307E\3059\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279937606628869243)
,p_name=>'APEX.IG.FILL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5165\529B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279959096353869256)
,p_name=>'APEX.IG.FILL_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\306E\9078\629E\306B\4F7F\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279958966288869256)
,p_name=>'APEX.IG.FILL_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\306E\9078\629E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279874533507869203)
,p_name=>'APEX.IG.FILTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280134887131869363)
,p_name=>'APEX.IG.FILTERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280610300011869660)
,p_name=>'APEX.IG.FILTER_WITH_DOTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280574770923869638)
,p_name=>'APEX.IG.FIRST'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\521D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279874730855869203)
,p_name=>'APEX.IG.FLASHBACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280133365793869363)
,p_name=>'APEX.IG.FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F8\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280584223127869644)
,p_name=>'APEX.IG.FORMATMASK'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F8\5F0F\30DE\30B9\30AF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280589085381869647)
,p_name=>'APEX.IG.FORMAT_CSV'
,p_message_language=>'ja'
,p_message_text=>'CSV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280588905695869647)
,p_name=>'APEX.IG.FORMAT_HTML'
,p_message_language=>'ja'
,p_message_text=>'HTML'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280142046223869368)
,p_name=>'APEX.IG.FREEZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\51CD\7D50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280135673029869364)
,p_name=>'APEX.IG.FUNCTIONS_AND_OPERATORS'
,p_message_language=>'ja'
,p_message_text=>unistr('\95A2\6570\3068\6F14\7B97\5B50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280569337088869635)
,p_name=>'APEX.IG.FUNNEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30F3\30CD\30EB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280481080137869580)
,p_name=>'APEX.IG.GO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9F\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280116328768869352)
,p_name=>'APEX.IG.GREATER_THAN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3088\308A\5927\304D\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280116492407869352)
,p_name=>'APEX.IG.GREATER_THAN_OR_EQUALS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\4EE5\4E0A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280135962170869364)
,p_name=>'APEX.IG.GRID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EA\30C3\30C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279873749737869202)
,p_name=>'APEX.IG.GRID_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EA\30C3\30C9\30FB\30D3\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280575713699869638)
,p_name=>'APEX.IG.GROUP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280136162605869364)
,p_name=>'APEX.IG.GROUP_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279874021024869202)
,p_name=>'APEX.IG.GROUP_BY_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316\30D3\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280584830881869644)
,p_name=>'APEX.IG.HD_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6761\4EF6\30BF\30A4\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280583744293869643)
,p_name=>'APEX.IG.HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D8\30C3\30C0\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280583920854869643)
,p_name=>'APEX.IG.HEADING_ALIGN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D8\30C3\30C0\30FC\306E\4F4D\7F6E\5408\305B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280610207630869660)
,p_name=>'APEX.IG.HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280596093855869651)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\5BFE\8A71\30B0\30EA\30C3\30C9\5185\3067\30C7\30FC\30BF\3092\76F4\63A5\633F\5165\3001\66F4\65B0\304A\3088\3073\524A\9664\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\65B0\3057\3044\884C\3092\633F\5165\3059\308B\306B\306F\3001\300C\884C\306E\8FFD\52A0\300D\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</p>'),
'',
unistr('<p>\65E2\5B58\306E\30C7\30FC\30BF\3092\7DE8\96C6\3059\308B\306B\306F\3001\7279\5B9A\306E\30BB\30EB\3092\30C0\30D6\30EB\30AF\30EA\30C3\30AF\3057\307E\3059\3002\7DE8\96C6\4F5C\696D\306E\7BC4\56F2\304C\5E83\3044\5834\5408\3001\300C\7DE8\96C6\300D\3092\30AF\30EA\30C3\30AF\3057\3066\7DE8\96C6\30E2\30FC\30C9\306B\5165\308A\307E\3059\3002\7DE8\96C6\30E2\30FC\30C9\3067\306F\30011\56DE\30AF\30EA\30C3\30AF\3059\308B\304B\30AD\30FC\30DC\30FC\30C9\3092\4F7F\7528\3059\308B\3053\3068\3067\3001\7279\5B9A\306E\30BB\30EB\3092\7DE8\96C6\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\300C\5909\66F4\300D\30E1\30CB\30E5\30FC\3092\4F7F\7528\3059\308B\3068\3001\884C\3092\8907\88FD\304A\3088\3073\524A\9664\3067\304D\307E\3059\3002\300C\5909\66F4\300D\30E1\30CB\30E5\30FC\3092\6709\52B9\306B\3059\308B\306B\306F\3001\30C1\30A7\30C3\30AF\30FB\30DC\30C3\30AF\30B9\3092\4F7F\7528\3057\30661\3064\4EE5\4E0A\306E\884C\3092\9078\629E\3057\307E\3059\3002</p>'),
'',
unistr('<p>\9078\629E\3057\305F\884C\3092\8907\88FD\3059\308B\306B\306F\3001\300C\5909\66F4\300D\30E1\30CB\30E5\30FC\3092\30AF\30EA\30C3\30AF\3057\3066\300C\884C\306E\8907\88FD\300D\3092\9078\629E\3057\307E\3059\3002\9078\629E\3057\305F\884C\3092\524A\9664\3059\308B\306B\306F\3001\300C\5909\66F4\300D\30E1\30CB\30E5\30FC\3092\30AF\30EA\30C3\30AF\3057\3066\300C\884C\306E\524A\9664\300D\3092\9078\629E\3057\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280598400826869652)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING_HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\7DE8\96C6\6A5F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280598584880869652)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5BFE\8A71\30B0\30EA\30C3\30C9\306B\306F\3001\691C\7D22\304A\3088\3073\30AB\30B9\30BF\30DE\30A4\30BA\53EF\80FD\306A\30EC\30DD\30FC\30C8\306E\30C7\30FC\30BF\306E\30BB\30C3\30C8\304C\8868\793A\3055\308C\307E\3059\3002\8FD4\3055\308C\308B\30EC\30B3\30FC\30C9\3092\5236\9650\3059\308B\69D8\3005\306A\64CD\4F5C\3092\5B9F\884C\3057\3001\30C7\30FC\30BF\306E\8868\793A\65B9\6CD5\3092\5909\66F4\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\300C\691C\7D22\300D\30D5\30A3\30FC\30EB\30C9\3092\4F7F\7528\3057\3066\3001\8FD4\3055\308C\308B\30EC\30B3\30FC\30C9\3092\30D5\30A3\30EB\30BF\3057\307E\3059\3002\300C\30A2\30AF\30B7\30E7\30F3\300D\3092\30AF\30EA\30C3\30AF\3057\3066\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8\3092\5909\66F4\3059\308B\305F\3081\306E\69D8\3005\306A\30AA\30D7\30B7\30E7\30F3\306B\30A2\30AF\30BB\30B9\3057\305F\308A\3001\8868\793A\5217\306E\5217\30D8\30C3\30C0\30FC\30FB\30E1\30CB\30E5\30FC\3092\4F7F\7528\3057\307E\3059\3002</p>'),
'',
unistr('<p>\300C\30EC\30DD\30FC\30C8\8A2D\5B9A\300D\3092\4F7F\7528\3057\3066\3001\30EC\30DD\30FC\30C8\306B\5BFE\3059\308B\30AB\30B9\30BF\30DE\30A4\30BA\3092\4FDD\5B58\3057\307E\3059\3002\30EC\30DD\30FC\30C8\304B\3089\5916\90E8\30D5\30A1\30A4\30EB\306B\30C7\30FC\30BF\3092\30C0\30A6\30F3\30ED\30FC\30C9\3057\305F\308A\3001\81EA\5206\3084\4ED6\306E\30E6\30FC\30B6\30FC\306B\30C7\30FC\30BF\3092\96FB\5B50\30E1\30FC\30EB\3067\9001\4FE1\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\8A73\7D30\306F\3001<em>\300EOracle Application Express\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\30FB\30AC\30A4\30C9\300F</em>\306E\5BFE\8A71\30B0\30EA\30C3\30C9\306E\4F7F\7528\306B\95A2\3059\308B\9805\3092\53C2\7167\3057\3066\304F\3060\3055\3044\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280598295996869652)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO_HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\6982\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280595946139869651)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7D44\8FBC\307F\6A5F\80FD\3092\4F7F\7528\3057\3066\3001\30C7\30FC\30BF\3092\69D8\3005\306A\65B9\6CD5\3067\8868\793A\3059\308B\3088\3046\306B\5BFE\8A71\30B0\30EA\30C3\30C9\3092\30AB\30B9\30BF\30DE\30A4\30BA\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\5217\30D8\30C3\30C0\30FC\30FB\30E1\30CB\30E5\30FC\307E\305F\306F\300C\30A2\30AF\30B7\30E7\30F3\300D\30E1\30CB\30E5\30FC\3092\4F7F\7528\3057\3066\3001\8868\793A\3059\308B\5217\3001\305D\306E\9806\5E8F\304A\3088\3073\56FA\5B9A\5217\3092\6307\5B9A\3057\307E\3059\3002\69D8\3005\306A\30C7\30FC\30BF\30FB\30D5\30A3\30EB\30BF\3092\5B9A\7FA9\3057\3066\3001\8FD4\3055\308C\308B\30C7\30FC\30BF\3092\30BD\30FC\30C8\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\300C\691C\7D22\300D\30D5\30A3\30FC\30EB\30C9\306E\6A2A\306B\3042\308B\300C\8868\793A\300D\30DC\30BF\30F3\3092\4F7F\7528\3059\308B\3068\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\958B\767A\8005\304C\5B9A\7FA9\3057\305F\4ED6\306E\30C7\30FC\30BF\30FB\30D3\30E5\30FC\306B\30A2\30AF\30BB\30B9\3067\304D\307E\3059\3002\30C1\30E3\30FC\30C8\3092\4F5C\6210\3057\305F\308A\3001\65E2\5B58\306E\30C1\30E3\30FC\30C8\3092\8868\793A\3059\308B\3053\3068\3082\53EF\80FD\3067\3059\3002</p>  '),
'',
unistr('<p><em>\6CE8\610F: \5BFE\8A71\30B0\30EA\30C3\30C9\30FB\30C0\30A4\30A2\30ED\30B0\306E<strong>\300C\30D8\30EB\30D7\300D</strong>\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\9078\629E\3057\305F\6A5F\80FD\306B\95A2\3059\308B\8A73\7D30\60C5\5831\3092\5165\624B\3067\304D\307E\3059\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280598371947869652)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING_HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\6A5F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280141052434869367)
,p_name=>'APEX.IG.HELP.ACTIONS_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30B0\30EA\30C3\30C9\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280592961106869649)
,p_name=>'APEX.IG.HELP.AGGREGATE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\3001\5217\3092\96C6\8A08\3057\307E\3059\3002\96C6\8A08\3055\308C\305F\5024\306F\3001\30C7\30FC\30BF\306E\4E00\756A\4E0B\306B(\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\304C\5B9A\7FA9\3055\308C\3066\3044\308B\5834\5408\306F\5404\30D6\30EC\30FC\30AF\306E\4E00\756A\4E0B\306B)\8868\793A\3055\308C\307E\3059\3002</p>'),
'',
unistr('<p><strong>\96C6\8A08\30EA\30B9\30C8</strong><br>'),
unistr('\300C\96C6\8A08\30EA\30B9\30C8\300D\306B\306F\3001\5B9A\7FA9\6E08\306E\96C6\8A08\304C\8868\793A\3055\308C\307E\3059\3002\65E2\5B58\306E\96C6\8A08\3092\7121\52B9\5316\3059\308B\306B\306F\3001\305D\308C\3092\9078\629E\89E3\9664\3057\307E\3059\3002<br>'),
unistr('\300C\8FFD\52A0\300D( &plus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\65B0\3057\3044\96C6\8A08\304C\4F5C\6210\3055\308C\3001\300C\524A\9664\300D( &minus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\65E2\5B58\306E\96C6\8A08\304C\524A\9664\3055\308C\307E\3059\3002</p>'),
'',
unistr('<p><strong>\96C6\8A08\8A2D\5B9A</strong><br>'),
unistr('\53F3\5074\306E\30D5\30A9\30FC\30E0\3092\4F7F\7528\3057\3066\96C6\8A08\3092\5B9A\7FA9\3057\307E\3059\3002<br>'),
unistr('\5217\540D\3068\96C6\8A08\30BF\30A4\30D7\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('\30AA\30D7\30B7\30E7\30F3\3067\3001\96C6\8A08\306E\30C4\30FC\30EB\30C1\30C3\30D7\3092\5165\529B\3057\307E\3059\3002<br>'),
unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\3092\5B9A\7FA9\3057\3066\3044\308B\5834\5408\3001<strong>\300C\5168\4F53\306E\5024\306E\8868\793A\300D</strong>\3092\9078\629E\3059\308B\3068\3001\5168\4F53\306E\5E73\5747\3001\5408\8A08\307E\305F\306F\985E\4F3C\5024\304C\30C7\30FC\30BF\306E\4E00\756A\4E0B\306B\8868\793A\3055\308C\307E\3059\3002</p>'),
'',
unistr('<p><em>\6CE8\610F: \300C\96C6\8A08\300D\30C0\30A4\30A2\30ED\30B0\306B\306F\3001\300C\30A2\30AF\30B7\30E7\30F3\300D\30E1\30CB\30E5\30FC\3067\30A2\30AF\30BB\30B9\3059\308B\304B\3001\5217\30D8\30C3\30C0\30FC\3068\5408\8A08( &sum; )\3092\30AF\30EA\30C3\30AF\3057\3066\30A2\30AF\30BB\30B9\3057\307E\3059\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280597323077869652)
,p_name=>'APEX.IG.HELP.AGGREGATE_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\96C6\8A08\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280593667055869649)
,p_name=>'APEX.IG.HELP.CHART'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\3001\500B\5225\306E\30C7\30FC\30BF\30FB\30D3\30E5\30FC\3068\3057\3066\8868\793A\3055\308C\308B\30C1\30E3\30FC\30C8\3092\5B9A\7FA9\3057\307E\3059\3002<br> '),
unistr('\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7\3092\9078\629E\3057\3001\30C1\30E3\30FC\30C8\8A2D\5B9A\3092\69CB\6210\3057\3066\3001<strong>\300C\4FDD\5B58\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\30C1\30E3\30FC\30C8\8A2D\5B9A</strong></br>'),
unistr('\8868\793A\3055\308C\308B\30C1\30E3\30FC\30C8\5C5E\6027\306F\3001\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7\306B\5FDC\3058\3066\7570\306A\308A\307E\3059\3002\30C1\30E3\30FC\30C8\3092\5B9A\7FA9\3059\308B\305F\3081\306B\8907\6570\306E\5C5E\6027\3092\5165\529B\3067\304D\307E\3059\3002\8D64\3044\30A2\30B9\30BF\30EA\30B9\30AF\3067\30DE\30FC\30AF\3055\308C\305F\5C5E\6027\306F\3001\5FC5\9808\3067\3059\3002</p>'),
'',
unistr('<p>\6B21\306B\3001\7570\306A\308B\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7\9593\3067\4F7F\7528\3067\304D\308B\3059\3079\3066\306E\5C5E\6027\3092\793A\3057\307E\3059(\30A2\30EB\30D5\30A1\30D9\30C3\30C8\9806)\3002'),
'<ul>',
unistr('  <li>\96C6\8A08 - \95A2\9023\3059\308B\30C1\30E3\30FC\30C8\5024\3092\96C6\8A08\3059\308B\65B9\6CD5\3092\9078\629E\3057\307E\3059\3002</li> '),
unistr('  <li>\7D42\5024 - \6BCE\65E5\306E\682A\4FA1\306E\7D42\5024\3092\542B\3080\5217\3092\9078\629E\3057\307E\3059(\682A\4FA1\30C1\30E3\30FC\30C8\306E\307F)\3002</li> '),
unistr('  <li>\5C0F\6570\70B9 - \5024\3092\4E38\3081\308B\57FA\6E96\3068\306A\308B\5C0F\6570\70B9\306E\4F4D\7F6E\306E\6570\5024\3092\5165\529B\3057\307E\3059\3002</li> '),
unistr('  <li>\65B9\5411 - \300C\30BD\30FC\30C8\57FA\6E96\300D\5C5E\6027\306B\95A2\3057\3066\3001\6607\9806\3068\964D\9806\306E\3069\3061\3089\306E\5024\3067\30C7\30FC\30BF\3092\30BD\30FC\30C8\3059\308B\304B\3092\6307\5B9A\3057\307E\3059\3002</li> '),
unistr('  <li>\4E0A\9650 - \4E0A\9650\5024\3092\542B\3080\5217\3092\9078\629E\3057\307E\3059(\30EC\30F3\30B8\30FB\30C1\30E3\30FC\30C8\304A\3088\3073\682A\4FA1\30C1\30E3\30FC\30C8\306E\307F)\3002</li> '),
unistr('  <li>\30E9\30D9\30EB - \5404\30C7\30FC\30BF\30FB\30DD\30A4\30F3\30C8\306E\30C6\30AD\30B9\30C8\3092\542B\3080\5217\3092\9078\629E\3057\307E\3059\3002</li> '),
unistr('  <li>\30E9\30D9\30EB\306E\8EF8\30BF\30A4\30C8\30EB - \30E9\30D9\30EB\306E\8EF8\306B\8868\793A\3055\308C\308B\30BF\30A4\30C8\30EB\3092\5165\529B\3057\307E\3059\3002</li> '),
unistr('  <li>\4E0B\9650 - \4E0B\9650\5024\3092\542B\3080\5217\3092\9078\629E\3057\307E\3059(\30EC\30F3\30B8\30FB\30C1\30E3\30FC\30C8\304A\3088\3073\682A\4FA1\30C1\30E3\30FC\30C8\306E\307F)\3002</li> '),
unistr('  <li>NULL - \300C\30BD\30FC\30C8\57FA\6E96\300D\5C5E\6027\306B\95A2\3057\3066\3001null\5024\3092\6301\3064\30EC\30B3\30FC\30C9\3092\3001null\4EE5\5916\306E\5024\3092\6301\3064\30EC\30B3\30FC\30C9\3068\6BD4\8F03\3057\3066\3069\306E\3088\3046\306B\30BD\30FC\30C8\3059\308B\304B\3092\6307\5B9A\3057\307E\3059\3002</li> '),
unistr('  <li>\59CB\5024 - \6BCE\65E5\306E\682A\4FA1\306E\59CB\5024\3092\542B\3080\5217\3092\9078\629E\3057\307E\3059(\682A\4FA1\30C1\30E3\30FC\30C8\306E\307F)\3002</li> '),
unistr('  <li>\5411\304D - \68D2\306A\3069\306E\30C1\30E3\30FC\30C8\8981\7D20\3092\5782\76F4\3068\6C34\5E73\306E\3069\3061\3089\3067\8868\793A\3059\308B\304B\3092\9078\629E\3057\307E\3059\3002</li> '),
unistr('  <li>\30B7\30EA\30FC\30BA - \30DE\30EB\30C1\30B7\30EA\30FC\30BA\52D5\7684\554F\5408\305B\3092\5B9A\7FA9\3059\308B\305F\3081\306B\4F7F\7528\3059\308B\5217\3092\9078\629E\3057\307E\3059\3002</li> '),
unistr('  <li>\7A4D\4E0A\3052 - \30C7\30FC\30BF\30FB\30A2\30A4\30C6\30E0\3092\7A4D\4E0A\3052\306B\3059\308B\304B\3069\3046\304B\3092\6307\5B9A\3057\307E\3059\3002</li> '),
unistr('  <li>\30BD\30FC\30C8\57FA\6E96 - \30E9\30D9\30EB\3068\5024\306E\3069\3061\3089\3067\30C1\30E3\30FC\30C8\3092\30BD\30FC\30C8\3059\308B\304B\3092\9078\629E\3057\307E\3059\3002</li> '),
unistr('  <li>\30BF\30FC\30B2\30C3\30C8 - \3053\306E\30C1\30E3\30FC\30C8\306E\30BF\30FC\30B2\30C3\30C8\5024\3092\5B9A\7FA9\3059\308B\305F\3081\306B\4F7F\7528\3059\308B\5217\3092\9078\629E\3057\307E\3059\3002\8A2D\5B9A\3059\308B\3068\3001\300C\5024\300D\5C5E\6027\306B\3088\3063\3066\30B9\30E9\30A4\30B9\5185\306E\5857\308A\3064\3076\3057\9818\57DF\304C\5B9A\7FA9\3055\308C\3001\300C\30BF\30FC\30B2\30C3\30C8\300D\306B\30B9\30E9\30A4\30B9\5168\4F53\306E\5024\304C\793A\3055\308C\307E\3059(\30D5\30A1\30F3\30CD\30EB\30FB\30C1\30E3\30FC\30C8\306E\307F)\3002</li> '),
unistr('  <li>\5024 - \30D7\30ED\30C3\30C8\3055\308C\308B\30C7\30FC\30BF\3092\542B\3080\5217\3092\9078\629E\3057\307E\3059\3002</li> '),
unistr('  <li>\5024\306E\8EF8\30BF\30A4\30C8\30EB - \5024\306E\8EF8\306B\8868\793A\3055\308C\308B\30BF\30A4\30C8\30EB\3092\5165\529B\3057\307E\3059\3002</li> '),
unistr('  <li>\51FA\6765\9AD8 - \6BCE\65E5\306E\682A\306E\51FA\6765\9AD8\3092\542B\3080\5217\3092\9078\629E\3057\307E\3059(\682A\4FA1\30C1\30E3\30FC\30C8\306E\307F)\3002</li> '),
unistr('  <li>X - \3053\306E\30C1\30E3\30FC\30C8\306EX\8EF8\306E\5024\3092\542B\3080\5217\3092\9078\629E\3057\307E\3059(\30D0\30D6\30EB\30FB\30C1\30E3\30FC\30C8\304A\3088\3073\6563\5E03\56F3\306E\307F)\3002</li> '),
unistr('  <li>Y - \3053\306E\30C1\30E3\30FC\30C8\306EY\8EF8\306E\5024\3092\542B\3080\5217\3092\9078\629E\3057\307E\3059(\30D0\30D6\30EB\30FB\30C1\30E3\30FC\30C8\304A\3088\3073\6563\5E03\56F3\306E\307F)\3002</li> '),
unistr('  <li>Z - \68D2\306E\5E45\307E\305F\306F\30D0\30D6\30EB\306E\534A\5F84\3092\542B\3080\5217\3092\9078\629E\3057\307E\3059(\68D2\30B0\30E9\30D5\3001\30D0\30D6\30EB\30FB\30C1\30E3\30FC\30C8\304A\3088\3073\30EC\30F3\30B8\30FB\30C1\30E3\30FC\30C8\306E\307F)\3002</li> '),
'</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280597788298869652)
,p_name=>'APEX.IG.HELP.CHART_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280592647954869649)
,p_name=>'APEX.IG.HELP.COLUMNS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\3001\3069\306E\5217\3092\3069\306E\9806\5E8F\3067\8868\793A\3059\308B\304B\3092\9078\629E\3057\307E\3059\3002</p>'),
'',
unistr('<p>\5217\3092\9078\629E\89E3\9664\3059\308B\3068\975E\8868\793A\306B\306A\308A\307E\3059\3002<br>'),
unistr('\5217\3092\4E26\3079\66FF\3048\308B\306B\306F\3001\300C\4E0A\3078\300D( &uarr; )\307E\305F\306F\300C\4E0B\3078\300D( &darr; )\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002<br>'),
unistr('\30C9\30ED\30C3\30D7\30C0\30A6\30F3\30FB\30BB\30EC\30AF\30BF\3092\4F7F\7528\3059\308B\3068\3001\3059\3079\3066\306E\5217\3001\8868\793A\5217\307E\305F\306F\975E\8868\793A\5217\3092\30EA\30B9\30C8\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\30AA\30D7\30B7\30E7\30F3\3067\3001\30D5\30A9\30FC\30E0\3092\4F7F\7528\3057\3066\5217\306E\6700\5C0F\5E45\3092\30D4\30AF\30BB\30EB\5358\4F4D\3067\6307\5B9A\3057\307E\3059\3002</p>'),
'',
unistr('<p><em>\6CE8\610F: \8868\793A\5217\306F\3001\30C9\30E9\30C3\30B0\30FB\30CF\30F3\30C9\30EB(\5217\30D8\30C3\30C0\30FC\306E\958B\59CB\90E8\5206)\3092\30AF\30EA\30C3\30AF\3057\3001\5217\3092\5DE6\53F3\306B\30C9\30E9\30C3\30B0\3059\308B\3053\3068\3067\3082\4E26\3079\66FF\3048\308B\3053\3068\304C\3067\304D\307E\3059\3002\8868\793A\5217\306E\5217\5E45\306F\3001\30D8\30C3\30C0\30FC\9593\306E\5217\30BB\30D1\30EC\30FC\30BF\3092\9078\629E\3057\3066\5DE6\53F3\306B\79FB\52D5\3059\308B\3053\3068\3067\3082\5909\66F4\3067\304D\307E\3059\3002</em</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280597607206869652)
,p_name=>'APEX.IG.HELP.COLUMNS_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280593075792869649)
,p_name=>'APEX.IG.HELP.COMPUTE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\3001\65E2\5B58\306E\5217\306B\5BFE\3057\3066\5B9F\884C\3055\308C\305F\6570\5B66\7684\304A\3088\3073\95A2\6570\7684\8A08\7B97\306B\57FA\3065\3044\3066\8FFD\52A0\306E\5217\3092\5B9A\7FA9\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\8A08\7B97\30EA\30B9\30C8</strong><br>'),
unistr('\300C\8A08\7B97\30EA\30B9\30C8\300D\306B\306F\3001\5B9A\7FA9\6E08\306E\8A08\7B97\304C\8868\793A\3055\308C\307E\3059\3002\65E2\5B58\306E\8A08\7B97\3092\7121\52B9\5316\3059\308B\306B\306F\3001\305D\308C\3092\9078\629E\89E3\9664\3057\307E\3059\3002<br>'),
unistr('\300C\8FFD\52A0\300D( &plus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\65B0\3057\3044\8A08\7B97\304C\8FFD\52A0\3055\308C\3001\300C\524A\9664\300D( &minus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\65E2\5B58\306E\8A08\7B97\304C\524A\9664\3055\308C\307E\3059\3002</p>'),
'',
unistr('<p><strong>\8A08\7B97\8A2D\5B9A</strong><br>'),
unistr('\30D5\30A9\30FC\30E0\3092\4F7F\7528\3057\3066\8A08\7B97\3092\5B9A\7FA9\3057\307E\3059\3002<br>'),
unistr('\30D8\30C3\30C0\30FC\3084\30E9\30D9\30EB\306A\3069\306E\5217\306E\8A73\7D30\3092\5165\529B\3057\3001\4F4D\7F6E\5408\305B\8A2D\5B9A\3092\9078\629E\3057\307E\3059\3002<br> '),
unistr('\300C\5F0F\300D\30C6\30AD\30B9\30C8\9818\57DF\3092\4F7F\7528\3057\3066\3001\8A08\7B97\306E\5217\304A\3088\3073\95A2\9023\30D5\30A1\30F3\30AF\30B7\30E7\30F3\3092\5165\529B\3057\307E\3059\3002<br>'),
unistr('\65B0\3057\3044\5217\306E\9069\5207\306A\30C7\30FC\30BF\578B(\304A\3088\3073\30AA\30D7\30B7\30E7\30F3\306E\66F8\5F0F\30DE\30B9\30AF)\3092\9078\629E\3057\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280597259883869652)
,p_name=>'APEX.IG.HELP.COMPUTE_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280593335157869649)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\30011\3064\4EE5\4E0A\306E\5217\306B\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\3092\5B9A\7FA9\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\30FB\30EA\30B9\30C8</strong><br>'),
unistr('\300C\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\30FB\30EA\30B9\30C8\300D\306B\306F\3001\5B9A\7FA9\6E08\306E\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\304C\8868\793A\3055\308C\307E\3059\3002\65E2\5B58\306E\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\5217\3092\7121\52B9\5316\3059\308B\306B\306F\3001\305D\308C\3092\9078\629E\89E3\9664\3057\307E\3059\3002<br>'),
unistr('\300C\8FFD\52A0\300D( &plus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\65B0\3057\3044\5217\304C\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\306B\542B\307E\308C\3001\300C\524A\9664\300D( &minus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\65E2\5B58\306E\5217\304C\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\304B\3089\524A\9664\3055\308C\307E\3059\3002<br>'),
unistr('\5217\3092\4E26\3079\66FF\3048\308B\306B\306F\3001\300C\4E0A\3078\300D( &uarr; )\307E\305F\306F\300C\4E0B\3078\300D( &darr; )\3092\30AF\30EA\30C3\30AF\3057\3066\3001\9078\629E\3057\305F\5217\3092\4ED6\306E\5217\3092\57FA\6E96\3068\3057\3066\4E0A\4E0B\306B\79FB\52D5\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\8A2D\5B9A</strong><br>'),
unistr('\30D5\30A9\30FC\30E0\3092\4F7F\7528\3057\3066\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\5217\3092\5B9A\7FA9\3057\307E\3059\3002<br>'),
unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\5217\3001\30BD\30FC\30C8\65B9\5411\3001\304A\3088\3073NULL\5217(\5024\306E\306A\3044\5217)\306E\4E26\66FF\3048\65B9\6CD5\3092\9078\629E\3057\307E\3059\3002</p>'),
'',
unistr('<p><em>\6CE8\610F: \5BFE\8A71\30B0\30EA\30C3\30C9\3092\8868\793A\3059\308B\5834\5408\3001\5217\30D8\30C3\30C0\30FC\3092\30AF\30EA\30C3\30AF\3057\3066\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\30FB\30A2\30A4\30B3\30F3\3092\9078\629E\3059\308B\3053\3068\3067\3001\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\3092\5B9A\7FA9\3067\304D\307E\3059\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280596994255869651)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280593549922869649)
,p_name=>'APEX.IG.HELP.DOWNLOAD'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\3001\5916\90E8\30D5\30A1\30A4\30EB\306B\73FE\5728\306E\3059\3079\3066\306E\884C\3092\30C0\30A6\30F3\30ED\30FC\30C9\3057\307E\3059\3002\30D5\30A1\30A4\30EB\306B\306F\3001\30C7\30FC\30BF\306B\9069\7528\3055\308C\305F\4EFB\610F\306E\30D5\30A3\30EB\30BF\3084\30BD\30FC\30C8\3092\4F7F\7528\3057\3066\3001\73FE\5728\8868\793A\3055\308C\3066\3044\308B\5217\306E\307F\304C\542B\307E\308C\307E\3059\3002</p>'),
'',
unistr('<p>\30D5\30A1\30A4\30EB\5F62\5F0F\3092\9078\629E\3057\3066\300C\30C0\30A6\30F3\30ED\30FC\30C9\300D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002<br>'),
unistr('\6CE8\610F: CSV\306B\306F\3001\96C6\8A08\3084\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\306A\3069\306E\30C6\30AD\30B9\30C8\5F62\5F0F\306F\542B\307E\308C\307E\305B\3093\3002</p>'),
'',
unistr('<p>\30D5\30A1\30A4\30EB\3092\96FB\5B50\30E1\30FC\30EB\3067\9001\4FE1\3059\308B\306B\306F\3001\300C\96FB\5B50\30E1\30FC\30EB\3067\9001\4FE1\300D\3092\9078\629E\3057\3001\96FB\5B50\30E1\30FC\30EB\306E\8A73\7D30(\53D7\4FE1\8005\3001\4EF6\540D\304A\3088\3073\30E1\30C3\30BB\30FC\30B8)\3092\5165\529B\3057\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280596736188869651)
,p_name=>'APEX.IG.HELP.DOWNLOAD_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A6\30F3\30ED\30FC\30C9\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280592750901869649)
,p_name=>'APEX.IG.HELP.FILTER'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\3001\8FD4\3055\308C\308B\884C\3092\5236\9650\3059\308B\30C7\30FC\30BF\30FB\30D5\30A3\30EB\30BF\3092\69CB\6210\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\30D5\30A3\30EB\30BF\30FB\30EA\30B9\30C8</strong><br>'),
unistr('\300C\30D5\30A3\30EB\30BF\30FB\30EA\30B9\30C8\300D\306B\306F\3001\5B9A\7FA9\6E08\306E\30D5\30A3\30EB\30BF\304C\8868\793A\3055\308C\307E\3059\3002\65E2\5B58\306E\30D5\30A3\30EB\30BF\3092\7121\52B9\5316\3059\308B\306B\306F\3001\305D\308C\3092\9078\629E\89E3\9664\3057\307E\3059\3002<br>'),
unistr('\300C\8FFD\52A0\300D( &plus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\65B0\3057\3044\30D5\30A3\30EB\30BF\304C\4F5C\6210\3055\308C\3001\300C\524A\9664\300D( &minus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\65E2\5B58\306E\30D5\30A3\30EB\30BF\304C\524A\9664\3055\308C\307E\3059\3002</p>'),
'',
unistr('<p><strong>\30D5\30A3\30EB\30BF\8A2D\5B9A</strong><br>'),
unistr('\30D5\30A9\30FC\30E0\3092\4F7F\7528\3057\3066\30D5\30A3\30EB\30BF\30FB\30D7\30ED\30D1\30C6\30A3\3092\5B9A\7FA9\3057\307E\3059\3002<br>'),
unistr('\9069\5207\306A\30D5\30A3\30EB\30BF\30FB\30BF\30A4\30D7\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('&nbsp;&nbsp;&nbsp;\884C - \30D5\30A3\30EB\30BF\53EF\80FD\306A\4EFB\610F\306E\5217\306E\8A9E\53E5\3092\30D5\30A3\30EB\30BF\3057\307E\3059\3002<br>'),
unistr('&nbsp;&nbsp;&nbsp;\5217 - \6307\5B9A\3057\305F\6F14\7B97\5B50\3068\5024\3067\7279\5B9A\306E\5217\3092\30D5\30A3\30EB\30BF\3057\307E\3059\3002</p>'),
'',
unistr('<p><em>\6CE8\610F: \5BFE\8A71\30B0\30EA\30C3\30C9\3092\8868\793A\3059\308B\5834\5408\3001\300C\691C\7D22\300D\30D5\30A3\30FC\30EB\30C9\306B\76F4\63A5\5165\529B\3059\308B\3053\3068\3067\3001\884C\30D5\30A3\30EB\30BF\3092\5B9A\7FA9\3067\304D\307E\3059\3002\300C\691C\7D22\5217\306E\9078\629E\300D\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\691C\7D22\3092\7279\5B9A\306E\5217\306B\5236\9650\3067\304D\307E\3059\3002\307E\305F\306F\3001\5217\30D8\30C3\30C0\30FC\30FB\30E1\30CB\30E5\30FC\3092\958B\304D\3001\5024\3092\9078\629E\3057\3066\5217\30D5\30A3\30EB\30BF\3092\4F5C\6210\3067\304D\307E\3059\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280597586791869652)
,p_name=>'APEX.IG.HELP.FILTER_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280593106331869649)
,p_name=>'APEX.IG.HELP.FLASHBACK'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\3001\904E\53BB\306E\3042\308B\6642\70B9\306B\5B58\5728\3057\3066\3044\305F\30C7\30FC\30BF\3092\8868\793A\3057\307E\3059\3002</p>'),
unistr('<p>\904E\53BB\306E\5206\6570\3092\5165\529B\3057\3066\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF\554F\5408\305B\3092\5B9F\884C\3057\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280597120724869652)
,p_name=>'APEX.IG.HELP.FLASHBACK_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280597826009869652)
,p_name=>'APEX.IG.HELP.GROUP_BY_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280593292268869649)
,p_name=>'APEX.IG.HELP.HIGHLIGHT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\3001\5165\529B\3057\305F\6761\4EF6\306B\57FA\3065\3044\3066\30C7\30FC\30BF\306E\884C\307E\305F\306F\5217\3092\30CF\30A4\30E9\30A4\30C8\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\30CF\30A4\30E9\30A4\30C8\30FB\30EA\30B9\30C8</strong><br>'),
unistr('\300C\30CF\30A4\30E9\30A4\30C8\30FB\30EA\30B9\30C8\300D\306B\306F\3001\5B9A\7FA9\6E08\306E\30CF\30A4\30E9\30A4\30C8\304C\8868\793A\3055\308C\307E\3059\3002\65E2\5B58\306E\30CF\30A4\30E9\30A4\30C8\3092\7121\52B9\5316\3059\308B\306B\306F\3001\305D\308C\3092\9078\629E\89E3\9664\3057\307E\3059\3002<br>'),
unistr('\300C\8FFD\52A0\300D( &plus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\65B0\3057\3044\30CF\30A4\30E9\30A4\30C8\304C\4F5C\6210\3055\308C\3001\300C\524A\9664\300D( &minus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\65E2\5B58\306E\30CF\30A4\30E9\30A4\30C8\304C\524A\9664\3055\308C\307E\3059\3002</p>'),
'',
unistr('<p><strong>\30CF\30A4\30E9\30A4\30C8\8A2D\5B9A</strong><br>'),
unistr('\30D5\30A9\30FC\30E0\3092\4F7F\7528\3057\3066\30CF\30A4\30E9\30A4\30C8\30FB\30D7\30ED\30D1\30C6\30A3\3092\5B9A\7FA9\3057\307E\3059\3002<br>'),
unistr('\540D\524D\3092\5165\529B\3057\3001\300C\884C\300D\307E\305F\306F\300C\5217\300D\3092\9078\629E\3057\3066\3001\30D0\30C3\30AF\30B0\30E9\30A6\30F3\30C9\304A\3088\3073\30C6\30AD\30B9\30C8\306EHTML\30AB\30E9\30FC\30FB\30B3\30FC\30C9\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('\9069\5207\306A<strong>\300C\6761\4EF6\30BF\30A4\30D7\300D</strong>\3092\9078\629E\3057\3066\7279\5B9A\306E\30C7\30FC\30BF\3092\30CF\30A4\30E9\30A4\30C8\3057\307E\3059\3002<br>'),
unistr('&nbsp;&nbsp;&nbsp;\884C - \4EFB\610F\306E\5217\306E\8A9E\53E5\3092\30CF\30A4\30E9\30A4\30C8\3057\307E\3059\3002<br>'),
unistr('&nbsp;&nbsp;&nbsp;\5217 - \6307\5B9A\3057\305F\6F14\7B97\5B50\3068\5024\306B\57FA\3065\3044\3066\7279\5B9A\306E\5217\5185\3092\30CF\30A4\30E9\30A4\30C8\3057\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280597084347869652)
,p_name=>'APEX.IG.HELP.HIGHLIGHT_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280593454031869649)
,p_name=>'APEX.IG.HELP.REPORT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\3001\73FE\5728\306E\30B0\30EA\30C3\30C9\30FB\30EC\30A4\30A2\30A6\30C8\304A\3088\3073\69CB\6210\306B\52A0\3048\305F\5909\66F4\3092\4FDD\5B58\3057\307E\3059\3002<br>'),
unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\958B\767A\8005\306F\3001\8907\6570\306E\4EE3\66FF\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8\3092\5B9A\7FA9\3067\304D\307E\3059\3002\8A31\5BB9\3055\308C\308B\5834\5408\3001\81EA\5206\3068\4ED6\306E\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306F\3001\300C\30D1\30D6\30EA\30C3\30AF\300D\3068\3057\3066\30EC\30DD\30FC\30C8\3092\4FDD\5B58\3057\3001\30B0\30EA\30C3\30C9\306E\4ED6\306E\3059\3079\3066\306E\30E6\30FC\30B6\30FC\304C\30EC\30DD\30FC\30C8\3092\4F7F\7528\3067\304D\308B\3088\3046\306B\8A2D\5B9A\3067\304D\307E\3059\3002\307E\305F\3001\81EA\5206\306E\307F\304C\53C2\7167\3067\304D\308B\30D7\30E9\30A4\30D9\30FC\30C8\30FB\30EC\30DD\30FC\30C8\3068\3057\3066\30EC\30DD\30FC\30C8\3092\4FDD\5B58\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002</p>'),
unistr('<p>\4F7F\7528\53EF\80FD\306A\30BF\30A4\30D7\304B\3089\9078\629E\3057\3066\3001\4FDD\5B58\3059\308B\30EC\30DD\30FC\30C8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280596883467869651)
,p_name=>'APEX.IG.HELP.REPORT_TITLE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\30EC\30DD\30FC\30C8\306E\30D8\30EB\30D7'),
''))
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280592897043869649)
,p_name=>'APEX.IG.HELP.SORT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\4F7F\7528\3057\3066\3001\8868\793A\9806\5E8F\3092\8A2D\5B9A\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\30BD\30FC\30C8\30FB\30EA\30B9\30C8</strong><br>'),
unistr('\300C\30BD\30FC\30C8\300D\30C0\30A4\30A2\30ED\30B0\306B\306F\3001\69CB\6210\6E08\306E\30BD\30FC\30C8\30FB\30EB\30FC\30EB\306E\30EA\30B9\30C8\304C\8868\793A\3055\308C\307E\3059\3002<br>'),
unistr('\300C\8FFD\52A0\300D( &plus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\30BD\30FC\30C8\5217\304C\4F5C\6210\3055\308C\3001\300C\524A\9664\300D( &minus; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\30BD\30FC\30C8\5217\304C\524A\9664\3055\308C\307E\3059\3002<br>'),
unistr('\300C\4E0A\3078\300D( &uarr; )\304A\3088\3073\300C\4E0B\3078\300D( &darr; )\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\9078\629E\3057\305F\30BD\30FC\30C8\5217\3092\3001\4ED6\306E\30BD\30FC\30C8\5217\3092\57FA\6E96\3068\3057\3066\4E0A\4E0B\306B\79FB\52D5\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p><strong>\30BD\30FC\30C8\8A2D\5B9A</strong><br>'),
unistr('\30BD\30FC\30C8\5217\3001\30BD\30FC\30C8\65B9\5411\3001\304A\3088\3073NULL\5217(\5024\306E\306A\3044\5217)\306E\4E26\66FF\3048\65B9\6CD5\3092\9078\629E\3057\307E\3059\3002</p>'),
'',
unistr('<p><em>\6CE8\610F: \30C7\30FC\30BF\306F\975E\8868\793A\306E\5217\306B\3088\3063\3066\30BD\30FC\30C8\3067\304D\307E\3059\304C\3001\3059\3079\3066\306E\5217\304C\30BD\30FC\30C8\53EF\80FD\306A\308F\3051\3067\306F\3042\308A\307E\305B\3093\3002</em><br>'),
unistr('<em>\8868\793A\5217\306F\3001\5217\30D8\30C3\30C0\30FC\306E\672B\5C3E\306B\3042\308B\4E0A\77E2\5370(\6607\9806)\307E\305F\306F\4E0B\77E2\5370(\964D\9806)\3092\62BC\3059\3053\3068\3067\30BD\30FC\30C8\3067\304D\307E\3059\3002\65E2\5B58\306E\30BD\30FC\30C8\306B\5F8C\7D9A\306E\5217\3092\8FFD\52A0\3059\308B\306B\306F\3001[Shift]\30AD\30FC\3092\62BC\3057\306A\304C\3089\4E0A\77E2\5370\307E\305F\306F\4E0B\77E2\5370\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280597415061869652)
,p_name=>'APEX.IG.HELP.SORT_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280596641959869651)
,p_name=>'APEX.IG.HELP.SUBSCRIPTION_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3\306E\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280141968432869368)
,p_name=>'APEX.IG.HIDE'
,p_message_language=>'ja'
,p_message_text=>unistr('\975E\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279874924023869203)
,p_name=>'APEX.IG.HIGHLIGHT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280568096084869634)
,p_name=>'APEX.IG.HIGH_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\9AD8\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280568815804869634)
,p_name=>'APEX.IG.HORIZONTAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A2A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280118115458869353)
,p_name=>'APEX.IG.HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6642\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280135803177869364)
,p_name=>'APEX.IG.ICON'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30B3\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279873848498869202)
,p_name=>'APEX.IG.ICON_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30B3\30F3\30FB\30D3\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280116155610869352)
,p_name=>'APEX.IG.IN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306B\542B\307E\308C\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280141511052869368)
,p_name=>'APEX.IG.INACTIVE_SETTING'
,p_message_language=>'ja'
,p_message_text=>unistr('\975E\30A2\30AF\30C6\30A3\30D6\306A\8A2D\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280141619305869368)
,p_name=>'APEX.IG.INACTIVE_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\975E\30A2\30AF\30C6\30A3\30D6\306A\8A2D\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280188990241869397)
,p_name=>'APEX.IG.INTERNAL_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30B0\30EA\30C3\30C9\30FB\30EA\30AF\30A8\30B9\30C8\306E\51E6\7406\4E2D\306B\5185\90E8\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280596144507869651)
,p_name=>'APEX.IG.INVALID_DATE_FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\65E5\4ED8\66F8\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280606774785869657)
,p_name=>'APEX.IG.INVALID_SETTING'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\8A2D\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280606859982869657)
,p_name=>'APEX.IG.INVALID_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\8A2D\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280582593977869643)
,p_name=>'APEX.IG.INVALID_SORT_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\30BD\30FC\30C8\57FA\6E96\300D\304C%0\306B\8A2D\5B9A\3055\308C\3066\3044\307E\3059\304C\3001%0\306B\5BFE\3057\3066\5217\304C\9078\629E\3055\308C\3066\3044\307E\305B\3093\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280575642466869638)
,p_name=>'APEX.IG.INVALID_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\5024')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280563836862869631)
,p_name=>'APEX.IG.INVISIBLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\975E\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280116915348869353)
,p_name=>'APEX.IG.IN_THE_LAST'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280117106919869353)
,p_name=>'APEX.IG.IN_THE_NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\5728\3088\308A\5F8C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280116008613869352)
,p_name=>'APEX.IG.IS_NOT_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A7A\3067\306F\3042\308A\307E\305B\3093')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280115970883869352)
,p_name=>'APEX.IG.IS_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A7A\3067\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280583884005869643)
,p_name=>'APEX.IG.LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280567351652869633)
,p_name=>'APEX.IG.LABEL_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280574897539869638)
,p_name=>'APEX.IG.LAST'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5F8C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280014857542869290)
,p_name=>'APEX.IG.LAST.DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB1\65E5\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280015020410869290)
,p_name=>'APEX.IG.LAST.HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB1\6642\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280015589752869291)
,p_name=>'APEX.IG.LAST.MINUTE'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB1\5206')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280014581469869290)
,p_name=>'APEX.IG.LAST.MONTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\5148\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280014699726869290)
,p_name=>'APEX.IG.LAST.WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('\5148\9031')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280014710071869290)
,p_name=>'APEX.IG.LAST.X_DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB%0\65E5\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280014931044869290)
,p_name=>'APEX.IG.LAST.X_HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB%0\6642\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280015654803869291)
,p_name=>'APEX.IG.LAST.X_MINUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB%0\5206')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280015420212869291)
,p_name=>'APEX.IG.LAST.X_MONTHS'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB%0\304B\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280015309550869291)
,p_name=>'APEX.IG.LAST.X_WEEKS'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB%0\9031\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280014345902869290)
,p_name=>'APEX.IG.LAST.X_YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB%0\5E74\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280014407581869290)
,p_name=>'APEX.IG.LAST.YEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6628\5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280584068478869644)
,p_name=>'APEX.IG.LAYOUT_ALIGN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30EB\306E\4F4D\7F6E\5408\305B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280584119144869644)
,p_name=>'APEX.IG.LAYOUT_USEGROUPFOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\306E\4F7F\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280116531402869352)
,p_name=>'APEX.IG.LESS_THAN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3088\308A\5C0F\3055\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280116611484869352)
,p_name=>'APEX.IG.LESS_THAN_OR_EQUALS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\4EE5\4E0B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280569467776869635)
,p_name=>'APEX.IG.LINE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6298\308C\7DDA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280569532547869635)
,p_name=>'APEX.IG.LINE_WITH_AREA'
,p_message_language=>'ja'
,p_message_text=>unistr('\9762\4ED8\304D\6298\308C\7DDA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280584460273869644)
,p_name=>'APEX.IG.LISTAGG'
,p_message_language=>'ja'
,p_message_text=>'Listagg'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280568109547869634)
,p_name=>'APEX.IG.LOW_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F4E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280590082012869647)
,p_name=>'APEX.IG.MAILADDRESSES_COMMASEP'
,p_message_language=>'ja'
,p_message_text=>unistr('\8907\6570\306E\30A2\30C9\30EC\30B9\306F\30AB\30F3\30DE\3067\533A\5207\308A\307E\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280117702111869353)
,p_name=>'APEX.IG.MATCHES_REGULAR_EXPRESSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\6B21\306E\6B63\898F\8868\73FE\3068\4E00\81F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280481608258869581)
,p_name=>'APEX.IG.MAX'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5927')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280611177355869660)
,p_name=>'APEX.IG.MAX_OVERALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5168\4F53\306E\6700\5927')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280481803710869581)
,p_name=>'APEX.IG.MEDIAN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E1\30B8\30A2\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280611255447869660)
,p_name=>'APEX.IG.MEDIAN_OVERALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5168\4F53\306E\4E2D\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280481558447869581)
,p_name=>'APEX.IG.MIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5C0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280118099999869353)
,p_name=>'APEX.IG.MINUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5206')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280483383907869582)
,p_name=>'APEX.IG.MINUTES_AGO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5206\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280611091815869660)
,p_name=>'APEX.IG.MIN_OVERALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5168\4F53\306E\6700\5C0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280118693393869354)
,p_name=>'APEX.IG.MONTHS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280141885204869368)
,p_name=>'APEX.IG.MORE_DATA_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\306B\6700\5927\8A31\5BB9\6570\3088\308A\591A\3044%0\3092\8D85\3048\308B\884C\304C\542B\307E\308C\307E\3059\3002\7D50\679C\3092\8868\793A\3059\308B\306B\306F\8FFD\52A0\306E\30D5\30A3\30EB\30BF\3092\9069\7528\3057\3066\304F\3060\3055\3044\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280133828628869363)
,p_name=>'APEX.IG.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\540D\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280134011991869363)
,p_name=>'APEX.IG.NAMED_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\540D\524D\4ED8\304D\30EC\30DD\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280013778649869290)
,p_name=>'APEX.IG.NEXT.DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E1\65E5\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280013544291869289)
,p_name=>'APEX.IG.NEXT.HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\6642\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280015735951869291)
,p_name=>'APEX.IG.NEXT.MINUTE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5206')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280014044335869290)
,p_name=>'APEX.IG.NEXT.MONTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\6708')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280013964811869290)
,p_name=>'APEX.IG.NEXT.WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\9031')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280013858272869290)
,p_name=>'APEX.IG.NEXT.X_DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0\65E5\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280013672202869289)
,p_name=>'APEX.IG.NEXT.X_HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0\6642\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280015893828869291)
,p_name=>'APEX.IG.NEXT.X_MINUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0\5206')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280015195423869290)
,p_name=>'APEX.IG.NEXT.X_MONTHS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0\304B\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280015200539869290)
,p_name=>'APEX.IG.NEXT.X_WEEKS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0\9031\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280014287260869290)
,p_name=>'APEX.IG.NEXT.X_YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0\5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280014168593869290)
,p_name=>'APEX.IG.NEXT.YEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280116858048869352)
,p_name=>'APEX.IG.NOT_BETWEEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\9593\306B\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280115807483869352)
,p_name=>'APEX.IG.NOT_EQUALS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3068\7B49\3057\304F\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280636203837869676)
,p_name=>'APEX.IG.NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('ID %0\306E\30EA\30FC\30B8\30E7\30F3\306F\5BFE\8A71\30B0\30EA\30C3\30C9\30FB\30EA\30FC\30B8\30E7\30F3\3067\306F\306A\3044\304B\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3%1\306B\5B58\5728\3057\307E\305B\3093\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280116211499869352)
,p_name=>'APEX.IG.NOT_IN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306B\542B\307E\308C\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280117060476869353)
,p_name=>'APEX.IG.NOT_IN_THE_LAST'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5F8C\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280117257475869353)
,p_name=>'APEX.IG.NOT_IN_THE_NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280141771329869368)
,p_name=>'APEX.IG.NO_DATA_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\304C\898B\3064\304B\308A\307E\305B\3093\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280574695949869638)
,p_name=>'APEX.IG.NULLS'
,p_message_language=>'ja'
,p_message_text=>'NULL'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280584619397869644)
,p_name=>'APEX.IG.NUMBER'
,p_message_language=>'ja'
,p_message_text=>unistr('\6570\5024')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280575153056869638)
,p_name=>'APEX.IG.OFF'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30D5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280575200043869638)
,p_name=>'APEX.IG.ON'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280099265689869342)
,p_name=>'APEX.IG.ONE_MINUTE_AGO'
,p_message_language=>'ja'
,p_message_text=>unistr('1\5206\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280592392332869649)
,p_name=>'APEX.IG.OPEN_COLORPICKER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30E9\30FC\30FB\30D4\30C3\30AB\30FC\3092\958B\304F: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280567885192869634)
,p_name=>'APEX.IG.OPEN_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30FC\30D7\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280134986573869364)
,p_name=>'APEX.IG.OPERATOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6F14\7B97\5B50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280567256928869633)
,p_name=>'APEX.IG.ORIENTATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\5411\304D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280569649146869635)
,p_name=>'APEX.IG.PIE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5186')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280136237275869364)
,p_name=>'APEX.IG.PIVOT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279874105942869203)
,p_name=>'APEX.IG.PIVOT_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\30FB\30D3\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280592242267869649)
,p_name=>'APEX.IG.PLACEHOLDER_INVALUES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024\306F"%0"\3067\533A\5207\308A\307E\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280569727789869635)
,p_name=>'APEX.IG.POLAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6975')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280583532406869643)
,p_name=>'APEX.IG.POSITION_CENTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E2D\592E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280583661007869643)
,p_name=>'APEX.IG.POSITION_END'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280583491522869643)
,p_name=>'APEX.IG.POSITION_START'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\59CB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280134177080869363)
,p_name=>'APEX.IG.PRIMARY'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E3B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280134482085869363)
,p_name=>'APEX.IG.PRIMARY_DEFAULT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30A4\30DE\30EA\30FB\30C7\30D5\30A9\30EB\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280429423545869548)
,p_name=>'APEX.IG.PRIMARY_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30A4\30DE\30EA\30FB\30EC\30DD\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280569852650869635)
,p_name=>'APEX.IG.RADAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30FC\30C0\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280569992247869635)
,p_name=>'APEX.IG.RANGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BC4\56F2')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280593756962869649)
,p_name=>'APEX.IG.REFRESH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30D5\30EC\30C3\30B7\30E5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280142515107869368)
,p_name=>'APEX.IG.REFRESH_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\30EA\30D5\30EC\30C3\30B7\30E5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280141368532869367)
,p_name=>'APEX.IG.REFRESH_ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\30EA\30D5\30EC\30C3\30B7\30E5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279875697820869203)
,p_name=>'APEX.IG.REMOVE_CONTROL'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280133578691869363)
,p_name=>'APEX.IG.REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280626932423869670)
,p_name=>'APEX.IG.REPORT.DELETED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\304C\524A\9664\3055\308C\307E\3057\305F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280626698671869670)
,p_name=>'APEX.IG.REPORT.SAVED.ALTERNATIVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30E6\30FC\30B6\30FC\306B\5BFE\3059\308B\4EE3\66FF\30EC\30DD\30FC\30C8\304C\4FDD\5B58\3055\308C\307E\3057\305F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280626520966869670)
,p_name=>'APEX.IG.REPORT.SAVED.DEFAULT'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30E6\30FC\30B6\30FC\306B\5BFE\3059\308B\30C7\30D5\30A9\30EB\30C8\306E\30EC\30DD\30FC\30C8\304C\4FDD\5B58\3055\308C\307E\3057\305F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280626861697869670)
,p_name=>'APEX.IG.REPORT.SAVED.PRIVATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30A4\30D9\30FC\30C8\30FB\30EC\30DD\30FC\30C8\304C\4FDD\5B58\3055\308C\307E\3057\305F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280626737737869670)
,p_name=>'APEX.IG.REPORT.SAVED.PUBLIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30E6\30FC\30B6\30FC\306B\5BFE\3059\308B\30D1\30D6\30EA\30C3\30AF\30FB\30EC\30DD\30FC\30C8\304C\4FDD\5B58\3055\308C\307E\3057\305F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280099126954869342)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF.X.MINUTES_AGO'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\5206\524D\306E\30C7\30FC\30BF\3092\30EC\30DD\30FC\30C8\3057\307E\3059\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280099072210869342)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF_ONE_MINUTE_AGO'
,p_message_language=>'ja'
,p_message_text=>unistr('1\5206\524D\306E\30C7\30FC\30BF\3092\30EC\30DD\30FC\30C8\3057\307E\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280598140318869652)
,p_name=>'APEX.IG.REPORT_EDIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8 - \7DE8\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280598055501869652)
,p_name=>'APEX.IG.REPORT_SAVE_AS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8 - \540D\524D\3092\4ED8\3051\3066\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279875782497869204)
,p_name=>'APEX.IG.REPORT_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\8A2D\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280636351539869676)
,p_name=>'APEX.IG.REPORT_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\9759\7684ID %0\3067\4FDD\5B58\3055\308C\305F\5BFE\8A71\30B0\30EA\30C3\30C9\304C\5B58\5728\3057\307E\305B\3093\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280610467317869660)
,p_name=>'APEX.IG.REPORT_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30D3\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279874836154869203)
,p_name=>'APEX.IG.RESET'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30BB\30C3\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280142690580869368)
,p_name=>'APEX.IG.REVERT_CHANGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5909\66F4\306E\56DE\5FA9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280141421941869368)
,p_name=>'APEX.IG.REVERT_ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\56DE\5FA9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280134597732869363)
,p_name=>'APEX.IG.ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280133411943869363)
,p_name=>'APEX.IG.ROWS_PER_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\3054\3068\306E\884C\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280634939766869675)
,p_name=>'APEX.IG.ROW_ACTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\30A2\30AF\30B7\30E7\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280642172465869679)
,p_name=>'APEX.IG.ROW_ACTIONS_FOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C%0\306E\30A2\30AF\30B7\30E7\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279875180191869203)
,p_name=>'APEX.IG.SAVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280217511413869415)
,p_name=>'APEX.IG.SAVED'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58\6E08')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279873316763869202)
,p_name=>'APEX.IG.SAVED_REPORTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58\3055\308C\305F\30EC\30DD\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279873495887869202)
,p_name=>'APEX.IG.SAVED_REPORT_DEFAULT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279873529475869202)
,p_name=>'APEX.IG.SAVED_REPORT_PRIVATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30A4\30D9\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279873605140869202)
,p_name=>'APEX.IG.SAVED_REPORT_PUBLIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30D6\30EA\30C3\30AF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280610107116869659)
,p_name=>'APEX.IG.SAVE_AS'
,p_message_language=>'ja'
,p_message_text=>unistr('\540D\524D\3092\4ED8\3051\3066\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280140776678869367)
,p_name=>'APEX.IG.SAVE_REPORT_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\8A2D\5B9A\306E\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280570019162869635)
,p_name=>'APEX.IG.SCATTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\6563\5E03')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279873264229869202)
,p_name=>'APEX.IG.SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280588834101869646)
,p_name=>'APEX.IG.SEARCH.ALL_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22: \3059\3079\3066\306E\30C6\30AD\30B9\30C8\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279873193835869202)
,p_name=>'APEX.IG.SEARCH.COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280587626222869646)
,p_name=>'APEX.IG.SEARCH.ORACLE_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22: \5168\6587')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280098993371869342)
,p_name=>'APEX.IG.SEARCH_FOR.X'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\5BFE\8C61''%0''')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280563535934869631)
,p_name=>'APEX.IG.SELECT'
,p_message_language=>'ja'
,p_message_text=>unistr('- \9078\629E -')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279937727673869243)
,p_name=>'APEX.IG.SELECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280536333752869614)
,p_name=>'APEX.IG.SELECT_1_ROW_IN_MASTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30EA\30FC\30B8\30E7\30F3\30671\884C\3092\9078\629E\3057\307E\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279873055509869202)
,p_name=>'APEX.IG.SELECT_COLUMNS_TO_SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\5217\306E\9078\629E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280633947428869674)
,p_name=>'APEX.IG.SEL_ACTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\30A2\30AF\30B7\30E7\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279937965960869243)
,p_name=>'APEX.IG.SEL_MODE_CELL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30EB\306E\9078\629E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279937898280869243)
,p_name=>'APEX.IG.SEL_MODE_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\9078\629E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280589483699869647)
,p_name=>'APEX.IG.SEND_AS_EMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\3067\9001\4FE1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280572944548869637)
,p_name=>'APEX.IG.SERIES_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B7\30EA\30FC\30BA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279833998113869178)
,p_name=>'APEX.IG.SHOW'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280448816862869561)
,p_name=>'APEX.IG.SHOW_OVERALL_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5168\4F53\306E\5024\306E\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280142252911869368)
,p_name=>'APEX.IG.SINGLE_ROW_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\5358\4E00\884C\30D3\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280136442418869364)
,p_name=>'APEX.IG.SORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280573060368869637)
,p_name=>'APEX.IG.SORT_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8\57FA\6E96')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280635041009869675)
,p_name=>'APEX.IG.SORT_ONLY_ONE_PER_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\3054\3068\306B\30BD\30FC\30C8\30921\3064\306E\307F\5B9A\7FA9\3067\304D\307E\3059\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280634137097869674)
,p_name=>'APEX.IG.SRV_CHANGE_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E1\30CB\30E5\30FC\306E\5909\66F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280575346418869638)
,p_name=>'APEX.IG.STACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A4D\4E0A\3052')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280117547477869353)
,p_name=>'APEX.IG.STARTS_WITH'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3067\59CB\307E\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280570139679869635)
,p_name=>'APEX.IG.STOCK'
,p_message_language=>'ja'
,p_message_text=>unistr('\682A\4FA1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279762615241869134)
,p_name=>'APEX.IG.STRETCH_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\5E45\306E\62E1\5F35')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280140900572869367)
,p_name=>'APEX.IG.SUBSCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280481412264869581)
,p_name=>'APEX.IG.SUM'
,p_message_language=>'ja'
,p_message_text=>unistr('\5408\8A08')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280642333847869679)
,p_name=>'APEX.IG.SUMMARY'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30B0\30EA\30C3\30C9\3002\30EC\30DD\30FC\30C8: %0\3001\30D3\30E5\30FC: %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280610524047869660)
,p_name=>'APEX.IG.SUM_OVERALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5168\4F53\306E\5408\8A08')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280568391381869634)
,p_name=>'APEX.IG.TARGET_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30FC\30B2\30C3\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280582754846869643)
,p_name=>'APEX.IG.TEXT_COLOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30AD\30B9\30C8\30FB\30AB\30E9\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279875872502869204)
,p_name=>'APEX.IG.TOGGLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5207\66FF\3048')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280448704045869560)
,p_name=>'APEX.IG.TOOLTIP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C4\30FC\30EB\30C1\30C3\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280133667728869363)
,p_name=>'APEX.IG.TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280142167872869368)
,p_name=>'APEX.IG.UNFREEZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\51CD\7D50\89E3\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280135149968869364)
,p_name=>'APEX.IG.UNIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5358\4F4D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280589253266869647)
,p_name=>'APEX.IG.UNSAVED_CHANGES_CONTINUE_CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58\3057\3066\3044\306A\3044\5909\66F4\304C\3042\308A\307E\3059\3002\7D9A\884C\3057\307E\3059\304B\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280135015515869364)
,p_name=>'APEX.IG.VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280567438201869633)
,p_name=>'APEX.IG.VALUE_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280576413963869639)
,p_name=>'APEX.IG.VALUE_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024\304C\5FC5\8981\3067\3059\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280520964505869605)
,p_name=>'APEX.IG.VALUE_TIMESTAMP_TZ'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024(\30BF\30A4\30E0\30BE\30FC\30F3\306F\5909\66F4\3067\304D\307E\305B\3093)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280584754420869644)
,p_name=>'APEX.IG.VARCHAR2'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30AD\30B9\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280568755033869634)
,p_name=>'APEX.IG.VERTICAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\7E26')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280133156838869362)
,p_name=>'APEX.IG.VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D3\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280563684282869631)
,p_name=>'APEX.IG.VISIBLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280568270229869634)
,p_name=>'APEX.IG.VOLUME_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\51FA\6765\9AD8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280118549998869354)
,p_name=>'APEX.IG.WEEKS'
,p_message_language=>'ja'
,p_message_text=>unistr('\9031')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280563752516869631)
,p_name=>'APEX.IG.WIDTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5C0F\5217\5E45(\30D4\30AF\30BB\30EB)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280048787167869311)
,p_name=>'APEX.IG.X.BETWEEN.Y.AND.Z'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\3068%2\306E\9593\306B\3042\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280048479413869311)
,p_name=>'APEX.IG.X.CONTAINS.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306B\306F%1\304C\542B\307E\308C\3066\3044\307E\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280048570838869311)
,p_name=>'APEX.IG.X.DOES_NOT_CONTAIN.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306B\306F%1\304C\542B\307E\308C\3066\3044\307E\305B\3093\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279830160691869176)
,p_name=>'APEX.IG.X.DOES_NOT_START_WITH.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\3067\958B\59CB\3055\308C\3066\3044\307E\305B\3093')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280047209441869310)
,p_name=>'APEX.IG.X.EQUALS.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\3068\7B49\3057\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280047477351869310)
,p_name=>'APEX.IG.X.GREATER_THAN.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\3088\308A\5927\304D\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280047500811869310)
,p_name=>'APEX.IG.X.GREATER_THAN_OR_EQUALS.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\4EE5\4E0A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280048252666869311)
,p_name=>'APEX.IG.X.IN.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\306B\542B\307E\308C\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280049439992869311)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\65E5\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280049227682869311)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\6642\9593\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280049022459869311)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MINUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\5206\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280049865375869312)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MONTHS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\304B\6708\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280049624614869311)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.WEEKS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\9031\9593\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280050040991869312)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\5E74\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280049345299869311)
,p_name=>'APEX.IG.X.IN_THE_LAST_DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\65E5\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280049133198869311)
,p_name=>'APEX.IG.X.IN_THE_LAST_HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\6642\9593\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280048908261869311)
,p_name=>'APEX.IG.X.IN_THE_LAST_MINUTE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\5206\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280049702648869312)
,p_name=>'APEX.IG.X.IN_THE_LAST_MONTH'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\304B\6708\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280049553662869311)
,p_name=>'APEX.IG.X.IN_THE_LAST_WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\9031\9593\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280049909651869312)
,p_name=>'APEX.IG.X.IN_THE_LAST_YEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\5E74\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280051842050869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\65E5\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280051614707869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\6642\9593\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280051468225869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\5206\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280052288999869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\304B\6708\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280052074558869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\9031\9593\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280052421927869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\5E74\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280051734581869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT_DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\65E5\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280051583682869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT_HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\6642\9593\4EE5\5185')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280051387921869312)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MINUTE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\5206\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280052181489869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MONTH'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\304B\6708\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280051924173869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT_WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\9031\9593\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280052374296869313)
,p_name=>'APEX.IG.X.IN_THE_NEXT_YEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\5E74\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280047996289869310)
,p_name=>'APEX.IG.X.IS_NOT_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\7A7A\3067\306F\3042\308A\307E\305B\3093')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280047862662869310)
,p_name=>'APEX.IG.X.IS_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C\7A7A\3067\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280047631867869310)
,p_name=>'APEX.IG.X.LESS_THAN.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\3088\308A\5C0F\3055\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280047720674869310)
,p_name=>'APEX.IG.X.LESS_THAN_OR_EQUALS.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\4EE5\4E0B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280048004310869311)
,p_name=>'APEX.IG.X.LIKE.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\3068\985E\4F3C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280048623414869311)
,p_name=>'APEX.IG.X.MATCHES_REGULAR_EXPRESSION.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B63\898F\8868\73FE%1\3068\4E00\81F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280099337045869342)
,p_name=>'APEX.IG.X.MINUTES_AGO'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\5206\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280048878870869311)
,p_name=>'APEX.IG.X.NOT_BETWEEN.Y.AND.Z'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\3068%2\306E\9593\306B\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280047385413869310)
,p_name=>'APEX.IG.X.NOT_EQUALS.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\3068\7B49\3057\304F\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280048309659869311)
,p_name=>'APEX.IG.X.NOT_IN.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\306B\542B\307E\308C\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280050630412869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\65E5\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280050419214869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\6642\9593\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280050280564869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MINUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\5206\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280051090616869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MONTHS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\304B\6708\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280050882302869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.WEEKS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\9031\9593\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280051282669869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB%1\5E74\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280050598906869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\65E5\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280050359137869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\6642\9593\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280050151044869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MINUTE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\5206\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280050975169869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MONTH'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\304B\6708\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280050728304869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\9031\9593\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280051127201869312)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_YEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\904E\53BB1\5E74\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280053091281869314)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\65E5\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280052881272869313)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\6642\9593\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280052696566869313)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\5206\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280053452723869314)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\304B\6708\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280053216717869314)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\9031\9593\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280053611816869314)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E%1\5E74\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280052992152869313)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\65E5\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280052751607869313)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\6642\9593\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280052565988869313)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MINUTE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\5206\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280053340892869314)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MONTH'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\304B\6708\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280053176265869314)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\9031\9593\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280053515869869314)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_YEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6B21\306E1\5E74\4EE5\5185\3067\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280048173586869311)
,p_name=>'APEX.IG.X.NOT_LIKE.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\3068\985E\4F3C\3057\3066\3044\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280109288057869348)
,p_name=>'APEX.IG.X.STARTS_WITH.Y'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F%1\3067\59CB\307E\308A\307E\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280567556767869633)
,p_name=>'APEX.IG.X_COLUMN'
,p_message_language=>'ja'
,p_message_text=>'X'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280118751948869354)
,p_name=>'APEX.IG.YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280567621799869634)
,p_name=>'APEX.IG.Y_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\306F\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280567767328869634)
,p_name=>'APEX.IG.Z_COLUMN'
,p_message_language=>'ja'
,p_message_text=>'Z'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280588257693869646)
,p_name=>'APEX.IG_FORMAT_SAMPLE_1'
,p_message_language=>'ja'
,p_message_text=>unistr('2016\5E741\670812\65E5(\6708\66DC\65E5)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280588380786869646)
,p_name=>'APEX.IG_FORMAT_SAMPLE_2'
,p_message_language=>'ja'
,p_message_text=>unistr('1\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280588485542869646)
,p_name=>'APEX.IG_FORMAT_SAMPLE_3'
,p_message_language=>'ja'
,p_message_text=>unistr('16\6642\9593\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280588572767869646)
,p_name=>'APEX.IG_FORMAT_SAMPLE_4'
,p_message_language=>'ja'
,p_message_text=>unistr('16\6642\9593\4EE5\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279444370886868942)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\51FA\529B\306E\30B5\30DD\30FC\30C8\306F\300C\6A19\6E96\300D\304B\300C\8A73\7D30\300D\306E\3044\305A\308C\304B\3067\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279444492218868942)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\521D\306B\30D7\30ED\30D3\30B8\30E7\30CB\30F3\30B0\3055\308C\305F\30B9\30AD\30FC\30DE\3092\524A\9664\3067\304D\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279333272994868872)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3ID\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279871265964869201)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279314300991868860)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024\306F\30BC\30ED\304B\6B63\306E\6574\6570\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279444569892868942)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DD\30FC\30C8\756A\53F7\304C\7121\52B9\3067\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279907038154869224)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3ID\304C\7121\52B9\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279444636922868942)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A6\30A9\30EC\30C3\30C8\30FB\30D1\30B9\306Ffile:<filesystempath>\306E\66F8\5F0F\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279536099789868997)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\304C\898B\3064\304B\308A\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279535964805868997)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\30EF\30FC\30AF\30B9\30DA\30FC\30B9ID\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279463500128868953)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30F3\30B9\30BF\30F3\30B9\30FB\30D1\30E9\30E1\30FC\30BF"%0"\306E\5024"%1"\304C\3001\6B63\898F\8868\73FE"%2"\306B\4E00\81F4\3057\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279463440389868953)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30F3\30B9\30BF\30F3\30B9\30FB\30D1\30E9\30E1\30FC\30BF"%0"\306B\306F\5024\304C\5FC5\8981\3067\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279444746570868942)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30F3\30B9\30BF\30F3\30B9\30FB\30D1\30E9\30E1\30FC\30BF\304C\898B\3064\304B\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279902624701869221)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279268081764868831)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9(\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30E6\30FC\30B6\30FC\30FB\30A2\30AB\30A6\30F3\30C8\30FB\30EA\30DD\30B8\30C8\30EA\306B\5BFE\3057\3066\306E\307F\306E\8A8D\8A3C\7528)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280188154652869396)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9(\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30E6\30FC\30B6\30FC\30FB\30A2\30AB\30A6\30F3\30C8\30FB\30EA\30DD\30B8\30C8\30EA\306B\5BFE\3057\3066\306E\307F\306E\8A8D\8A3C\7528)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280009614948869287)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9(\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30E6\30FC\30B6\30FC\30FB\30A2\30AB\30A6\30F3\30C8\30FB\30EA\30DD\30B8\30C8\30EA\306B\5BFE\3057\3066\306E\307F\306E\8A8D\8A3C\7528)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279589899709869030)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9(\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30E6\30FC\30B6\30FC\30FB\30A2\30AB\30A6\30F3\30C8\30FB\30EA\30DD\30B8\30C8\30EA\306B\5BFE\3057\3066\306E\307F\306E\8A8D\8A3C\7528)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279902519439869221)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9(\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30E6\30FC\30B6\30FC\30FB\30A2\30AB\30A6\30F3\30C8\30FB\30EA\30DD\30B8\30C8\30EA\306B\5BFE\3057\3066\306E\307F\306E\8A8D\8A3C\7528)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279446639120868943)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30EA\30F3\30C8\30FB\30B5\30FC\30D0\30FC\306E\30D7\30ED\30C8\30B3\30EB\306F\3001HTTP\304BHTTPS\306E\3044\305A\308C\304B\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279446798711868943)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30AD\30FC\30DE\304C\5B58\5728\3057\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279446823158868943)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30AD\30FC\30DE\306F\5236\9650\3055\308C\3066\3044\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279292949578868847)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279292799328868846)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306F\3059\3067\306B\5B58\5728\3057\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280237350421869428)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5272\5F53\3066')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280517618931869603)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30FC\30C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279294898440868848)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30E1\30F3\30C8\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279294768367868848)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30E1\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279269582944868832)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279269327998868832)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30B3\30E1\30F3\30C8\3092\524A\9664\3057\307E\3059\304B\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280221784670869418)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\984C\306E\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279279155717868838)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\554F\984C\3092\524A\9664\3057\307E\3059\304B\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279296493838868849)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C9\30AD\30E5\30E1\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279295337280868848)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C9\30AD\30E5\30E1\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279269459885868832)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7DE8\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280445283960869558)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30E1\30F3\30C8\306E\7DE8\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280445392606869558)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\984C\306E\7DE8\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279293505170868847)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\6307\5B9A\3055\308C\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306F\3053\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306B\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279293928175868847)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30E1\30F3\30C8\306E\524A\9664\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279293815901868847)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30E1\30F3\30C8\304C\898B\3064\304B\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279294174019868847)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\984C\304C\898B\3064\304B\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279294235106868847)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664\5BFE\8C61\306E\554F\984C\306E\30DE\30FC\30AF\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279293697205868847)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\6307\5B9A\3055\308C\305F\30DA\30FC\30B8\306F\3053\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\307E\305F\306F\4ED8\5C5E\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279294006338868847)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306F\3001\3053\306E\30B3\30E1\30F3\30C8\3092\524A\9664\3059\308B\6A29\9650\3092\6301\3063\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279294328197868847)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306F\3001\3053\306E\554F\984C\3092\524A\9664\3059\308B\6A29\9650\3092\6301\3063\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279293729548868847)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306F\3001\3053\306E\30B3\30E1\30F3\30C8\3092\8868\793A\3059\308B\304B\3069\3046\304B\3092\5909\66F4\3059\308B\6A29\9650\3092\6301\3063\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280454184678869564)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30A4\30EB\30FB\30B5\30A4\30BA\306E\30C1\30A7\30C3\30AF\4E2D\306B\554F\984C\304C\767A\751F\3057\307E\3057\305F\3002\30B7\30B9\30C6\30E0\7BA1\7406\8005\306B\9023\7D61\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280454003571869564)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\308C\3089\306E\3044\305A\308C\304B\306E\30D5\30A1\30A4\30EB\306E\5927\304D\3055\304C\3001\6700\5927\30D5\30A1\30A4\30EB\30FB\30B5\30A4\30BA\306E%0\30D0\30A4\30C8\3092\8D85\3048\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280453961754869564)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30D5\30A1\30A4\30EB\306E\5927\304D\3055\306F\3001\6700\5927\30D5\30A1\30A4\30EB\30FB\30B5\30A4\30BA\306E%0\30D0\30A4\30C8\3092\8D85\3048\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279269689078868832)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_language=>'ja'
,p_message_text=>unistr('\975E\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279296273048868849)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30E1\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279295106353868848)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30E1\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279292554748868846)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B7\30B9\30C6\30E0\3067\898B\3064\304B\3089\306A\304B\3063\305F\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279253251438868821)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306E\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\8FFD\52A0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279294996242868848)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279294690778868848)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30ED\30FC\30BA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280523284869869607)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D8\30C3\30C0\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279295968831868848)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A7A\3067\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279295752370868848)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\308C\3089\306E\30D5\30A1\30A4\30EB\306E1\3064\306F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279294515787868848)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30FC\30D7\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279297026423868849)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\9805\76EE\3092\5B8C\5168\306B\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280222643069869419)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\30D1\30FC\30B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279296917030868849)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\9805\76EE\306E\56DE\5FA9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279295005186868848)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30B9\30DD\30F3\30B9\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279295801140868848)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5927\304D\3059\304E\3066\30A2\30C3\30D7\30ED\30FC\30C9\3067\304D\307E\305B\3093\3002<br>\30D5\30A1\30A4\30EB\306F\6B21\3088\308A\5C0F\3055\3044\30B5\30A4\30BA\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279296191507868849)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30DD\30FC\30C8\3055\308C\308B\30D5\30A1\30A4\30EB\30FB\30BF\30A4\30D7\306F\6B21\306E\3068\304A\308A\3067\3059: ')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280449130026869561)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30B9\30DD\30F3\30B9\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\9078\629E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279295692244868848)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30D5\30A1\30A4\30EB\306F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279296072386868848)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30DD\30FC\30C8\3055\308C\308B\30D5\30A1\30A4\30EB\30FB\30BF\30A4\30D7\3067\306F\3042\308A\307E\305B\3093\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280161487964869380)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280162077313869380)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C9\30AD\30E5\30E1\30F3\30C8\306E\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280161559044869380)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_language=>'ja'
,p_message_text=>unistr('\62E1\5F35\30EA\30AF\30A8\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280161683064869380)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD\30EA\30AF\30A8\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280161921394869380)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30F3\30B9\30C8\30FC\30EB\306E\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280161810657869380)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30D5\30A9\30FC\30DE\30F3\30B9\306E\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280161762092869380)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30AD\30E5\30EA\30C6\30A3\306E\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280162152158869380)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C8\30EC\30FC\30CB\30F3\30B0\306E\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280162822389869381)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280162509364869381)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_language=>'ja'
,p_message_text=>'CSS / HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280162626715869381)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_language=>'ja'
,p_message_text=>unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3 / JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280162302010869380)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280162971963869381)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\5916\90E8\30B7\30B9\30C6\30E0\7D71\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280162445494869380)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_language=>'ja'
,p_message_text=>unistr('REST\7D71\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280162764896869381)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30AD\30E5\30EA\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280162272248869380)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_language=>'ja'
,p_message_text=>'UI / UX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280161339256869380)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\984C\306B\5272\308A\5F53\3066\3089\308C\305F\30AB\30C6\30B4\30EA\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280160441767869379)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30C6\30B4\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280161279975869380)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\984C\306B\3088\3063\3066\5F71\97FF\3092\53D7\3051\308B\6A5F\80FD\9818\57DF\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280160594430869379)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD\9818\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280161105637869380)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\984C\306B\5272\308A\5F53\3066\3089\308C\305F\91CD\8981\5EA6\306E\30EC\30D9\30EB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280160698875869379)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8981\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280161067376869380)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\984C\306B\5BFE\51E6\3059\308B\4F5C\696D\306E\30EC\30D9\30EB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280160795641869379)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F5C\696D\306E\30EC\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280160994989869380)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\984C\306B\5BFE\3059\308B\9032\6357\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280160837048869379)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\9032\6357')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280163364110869381)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30C3\30AF\30ED\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280163014008869381)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30EA\30C6\30A3\30AB\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280163101986869381)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280163210086869381)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A19\6E96')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280163476296869381)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\51E6\3057\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280163543412869381)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_language=>'ja'
,p_message_text=>unistr('\7C21\5358\306A\4FEE\6B63')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280163733253869381)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5927\898F\6A21\958B\767A\306E\4F5C\696D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280163682428869381)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E2D\7A0B\5EA6\306E\4F5C\696D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280164197730869382)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FEE\6B63\4E0D\53EF\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280164280246869382)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B8C\4E86')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280163909015869381)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\60C5\5831\304C\5FC5\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280164057174869381)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30FC\30C9\30D1\30FC\30C6\30A3\3067\5F85\6A5F\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280163803489869381)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F5C\696D\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280174520462869388)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30E9\30D9\30EB\30FB\30B0\30EB\30FC\30D7\306F\3001\305D\306E1\3064\4EE5\4E0A\306E\30E1\30F3\30D0\30FC\304C\554F\984C\306B\5272\308A\5F53\3066\3089\308C\3066\3044\308B\305F\3081\3001\524A\9664\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279294408773868847)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\91CD\8907\3068\3057\3066\30DE\30FC\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280222103891869418)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5272\5F53\3066\5148')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280222091143869418)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280222518937869419)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30A4\30EB\30B9\30C8\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280221974546869418)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30C6\30FC\30BF\30B9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279292318527868846)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30A4\30EB\30B9\30C8\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280164847708869382)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30FC\30C9\30FB\30D5\30EA\30FC\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280165083611869382)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\7D42\30EA\30EA\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280164940753869382)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_language=>'ja'
,p_message_text=>unistr('UI\30D5\30EA\30FC\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279296881448868849)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C%1 %2\306B\30B3\30E1\30F3\30C8\3092\8FFD\52A0\3057\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279252919814868821)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5909\66F4\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280178765637869390)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9%1\306E\554F\984C\756A\53F7%0\304C\5909\66F4\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280453864120869564)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB\304C\5B9A\7FA9\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279295533783868848)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_language=>'ja'
,p_message_text=>unistr('\305D\306E\4ED6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279293010286868847)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279292879695868846)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306F\3059\3067\306B\5B58\5728\3057\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280515100680869602)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\30D1\30FC\30B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280237480143869428)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279292693569868846)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3068\30DA\30FC\30B8\306E\95A2\9023\4ED8\3051\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279293371451868847)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280488981799869585)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\5728\306E\30B3\30E1\30F3\30C8\3092\3053\306E\30C6\30F3\30D7\30EC\30FC\30C8\306B\7F6E\304D\63DB\3048\307E\3059\304B\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280490903913869587)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\3088\3046\3053\305D\3002'),
'',
unistr('\3053\308C\306F\3042\306A\305F\306B\3068\3063\3066\4E00\756A\6700\521D\306E\554F\984C\3067\3059\3002\554F\984C\3092\4F5C\6210\3059\308B\3068\3001\3059\3079\3066\306EAPEX\30D7\30ED\30B8\30A7\30AF\30C8\306E\30BF\30B9\30AF\3001\6A5F\80FD\3001\30D0\30B0\304A\3088\3073\30D5\30A3\30FC\30C9\30D0\30C3\30AF\3092\30C8\30E9\30C3\30AD\30F3\30B0\3067\304D\307E\3059\3002\554F\984C\3078\306E\30E9\30D9\30EB\306E\8FFD\52A0\3001\5272\5F53\3066\5148\306E\8FFD\52A0\3001\30DE\30A4\30EB\30B9\30C8\30F3\306E\8A2D\5B9A\306B\52A0\3048\3001Markdown\8A18\6CD5\3092\4F7F\7528\3057\305F\66F8\5F0F\8A2D\5B9A\306E\9069\7528\307E\3067\884C\3046\3053\3068\304C\3067\304D\307E\3059\3002'),
'',
unistr('\6B21\306B\3001Markdown\3067\5B9F\884C\3067\304D\308B\3053\3068\306E\7C21\5358\306A\30B5\30F3\30D7\30EB\3092\793A\3057\307E\3059\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280490840592869587)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('Oracle APEX\306E\30C1\30FC\30E0\958B\767A\3078\3088\3046\3053\305D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280237787299869428)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_language=>'ja'
,p_message_text=>unistr('- \9078\629E -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279293415688868847)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30C6\30FC\30BF\30B9\306E\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279269882319868832)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280490784415869587)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3055\3089\306B\8868\793A...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279293195346868847)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30D6\30B9\30AF\30E9\30A4\30D6\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280454263512869564)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9%1\306E%0\306B%2\306E\65B0\3057\3044\901A\77E5\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280157956172869378)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30B0\3092\8A18\9332\3059\308B\305F\3081\306B\4F7F\7528\3059\308B\30C6\30F3\30D7\30EC\30FC\30C8\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280157899031869378)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30B0\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280157727780869378)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\4E88\671F\3055\308C\308B\52D5\4F5C**'),
unistr('- \901A\5E38\767A\751F\3059\308B\3068\8003\3048\3089\308C\308B\52D5\4F5C\3092\6559\3048\3066\304F\3060\3055\3044\3002'),
'',
'',
unistr('**\73FE\5728\306E\52D5\4F5C**'),
unistr('- \73FE\5728\306E\52D5\4F5C\3092\6559\3048\3066\304F\3060\3055\3044\3002'),
'',
'',
unistr('**\5F71\97FF\3092\53D7\3051\308B\30E6\30FC\30B6\30FC**'),
unistr('- \8AB0\304C/\4F55\304C\5F71\97FF\3092\53D7\3051\308B\304B\3092\6559\3048\3066\304F\3060\3055\3044\3002'),
'',
unistr('**\53EF\80FD\306A\89E3\6C7A\7B56**'),
unistr('- \53EF\80FD\3067\3042\308C\3070\3001\3053\306E\30D0\30B0\3092\4FEE\6B63\3059\308B\65B9\6CD5\3092\793A\3057\3066\304F\3060\3055\3044\3002'),
'',
unistr('**\518D\73FE\3059\308B\624B\9806**'),
unistr('- \5FC5\8981\306B\5FDC\3058\3066\30B9\30AF\30EA\30FC\30F3\30B7\30E7\30C3\30C8\3084\30B3\30FC\30C9\30FB\30B9\30CB\30DA\30C3\30C8\3092\542B\3081\306A\304C\3089\3001\73FE\8C61\3092\518D\73FE\3059\308B\660E\78BA\306A\624B\9806\306E\30BB\30C3\30C8\3092\793A\3057\3066\304F\3060\3055\3044\3002'),
'1.',
'2.',
'3.',
'',
unistr('**\30B3\30F3\30C6\30AD\30B9\30C8**'),
unistr('- \30D0\30B0\306E\767A\751F\6642\306B\5B9F\884C\3057\3088\3046\3068\3057\3066\3044\305F\3053\3068\306F\4F55\3067\3059\304B\3002\305D\306E\30D0\30B0\306F\3001\4E00\5B9A\306E\6761\4EF6\4E0B\3067\306E\307F\767A\751F\3057\307E\3059\304B\3001\307E\305F\306F\7279\5B9A\306E\6642\9593\5E2F\306A\3069\306B\767A\751F\3057\307E\3059\304B\3002'),
'',
unistr('**\74B0\5883**'),
'',
unistr('- \30D0\30FC\30B8\30E7\30F3: '),
unistr('- \30D7\30E9\30C3\30C8\30D5\30A9\30FC\30E0: '),
unistr('- \30B5\30D6\30B7\30B9\30C6\30E0:'),
'',
'______',
'',
unistr('_**\6CE8\610F:** \554F\984C\3092\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\307E\305F\306F\30DA\30FC\30B8(\3042\308B\3044\306F\305D\306E\4E21\65B9)\306B\95A2\9023\4ED8\3051\308B\306B\306F\3001\6700\521D\306B\554F\984C\3092\30ED\30B0\306B\8A18\9332\3057\3001\6B21\306B\300C**\30A2\30AF\30B7\30E7\30F3**\300D\30C9\30ED\30C3\30D7\30C0\30A6\30F3\3092\4F7F\7528\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304A\3088\3073\30DA\30FC\30B8\3092\95A2\9023\4ED8\3051\307E\3059\3002_')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280159071010869378)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30B0\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280158959255869378)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30B0\306E\767A\751F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280159199374869378)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\9069\5207\306A\5916\90E8\30B7\30B9\30C6\30E0\306B**\30D0\30B0**\304C\63D0\51FA\3055\308C\307E\3057\305F\3002'),
'',
unistr('- \30D0\30B0\30FB\30C8\30E9\30C3\30AD\30F3\30B0\30FB\30B7\30B9\30C6\30E0: '),
unistr('- \30D0\30B0ID: '),
unistr('- \30D0\30B0\306EURL: '),
'',
unistr('\30B3\30E1\30F3\30C8:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280158125737869378)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD\30EA\30AF\30A8\30B9\30C8\3092\8A18\9332\3059\308B\305F\3081\306B\4F7F\7528\3059\308B\30C6\30F3\30D7\30EC\30FC\30C8\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280158021391869378)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD\30EA\30AF\30A8\30B9\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280158221494869378)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\6A5F\80FD\30B5\30DE\30EA\30FC**'),
unistr(' - \6A5F\80FD\30EA\30AF\30A8\30B9\30C8\306E1\6BB5\843D\7A0B\5EA6\306E\6982\8981\3092\63D0\4F9B\3057\3066\304F\3060\3055\3044\3002'),
'',
'',
unistr('**\30B3\30F3\30C6\30AD\30B9\30C8**'),
unistr(' - \3053\306E\30EA\30AF\30A8\30B9\30C8\306F\7279\5B9A\306E\72B6\6CC1\307E\305F\306F\30D7\30ED\30BB\30B9\306B\95A2\9023\3057\3066\3044\307E\3059\304B\3002\305F\3068\3048\3070\3001\300C\79C1\306F\3044\3064\3082[...]\306E\3068\304D\306B\4E0D\6E80\3092\611F\3058\307E\3059\300D\306A\3069'),
'',
'',
unistr(' - \30B9\30AF\30EA\30FC\30F3\30B7\30E7\30C3\30C8\3084\4F7F\7528\4E8B\4F8B\306A\3069\306E\4ED8\968F\60C5\5831\3092\63D0\4F9B\3057\3066\304F\3060\3055\3044\3002'),
'',
'',
unistr('**\512A\5148\3055\308C\308B\89E3\6C7A\7B56**'),
unistr('- \5E0C\671B\3059\308B\5B9F\88C5\5185\5BB9\306E\660E\78BA\306A\8AAC\660E\3092\63D0\4F9B\3057\3066\304F\3060\3055\3044\3002'),
'',
'',
unistr('**\4EE3\66FF\53EF\80FD\306A\89E3\6C7A\7B56**'),
unistr('- \8003\3048\3089\308C\308B\4EE3\66FF\53EF\80FD\306A\89E3\6C7A\7B56\307E\305F\306F\6A5F\80FD(\3042\308B\3044\306F\4F7F\7528\3059\308B\56DE\907F\7B56)\306E\8AAC\660E\3092\63D0\4F9B\3057\3066\304F\3060\3055\3044\3002'),
'',
'',
'______',
unistr('_**\6CE8\610F:** \554F\984C\3092\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\307E\305F\306F\30DA\30FC\30B8(\3042\308B\3044\306F\305D\306E\4E21\65B9)\306B\95A2\9023\4ED8\3051\308B\306B\306F\3001\6700\521D\306B\554F\984C\3092\30ED\30B0\306B\8A18\9332\3057\3001\6B21\306B\300C**\30A2\30AF\30B7\30E7\30F3**\300D\30C9\30ED\30C3\30D7\30C0\30A6\30F3\3092\4F7F\7528\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304A\3088\3073\30DA\30FC\30B8\3092\95A2\9023\4ED8\3051\307E\3059\3002_')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280159320967869379)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD\30EA\30AF\30A8\30B9\30C8\304C\63D0\51FA\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280159234860869379)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD\30EA\30AF\30A8\30B9\30C8\306E\63D0\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280159440435869379)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\9069\5207\306A\5916\90E8\30B7\30B9\30C6\30E0\306B**\6A5F\80FD\30EA\30AF\30A8\30B9\30C8**\304C\63D0\51FA\3055\308C\307E\3057\305F\3002'),
'',
unistr('- \6A5F\80FD\30C8\30E9\30C3\30AD\30F3\30B0\30FB\30B7\30B9\30C6\30E0: '),
unistr('- \6A5F\80FDID: '),
unistr('- \6A5F\80FD\5B9A\7FA9\306EURL: '),
'',
unistr('\30B3\30E1\30F3\30C8:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280160247848869379)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30ED\30FC\30A2\30C3\30D7\30FB\30A2\30AF\30B7\30E7\30F3\304C\5FC5\8981\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280160192391869379)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30ED\30FC\30A2\30C3\30D7\30FB\30A2\30AF\30B7\30E7\30F3\304C\5FC5\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280160373864869379)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6B21\306E\30A2\30AF\30B7\30E7\30F3\3092\5B9F\884C\3057\3066\304F\3060\3055\3044: '),
'',
'1.',
'2.',
'3.',
'4.',
'',
unistr('\30B3\30E1\30F3\30C8: ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280158430064869378)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\624B\9806\306E\8CEA\554F\3092\5C0B\306D\308B\305F\3081\306B\4F7F\7528\3059\308B\30C6\30F3\30D7\30EC\30FC\30C8\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280158367483869378)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F7F\7528\65B9\6CD5 ...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280158552948869378)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\8CEA\554F**'),
unistr('- \3067\304D\308B\304B\304E\308A\7C21\6F54\306B\8CEA\554F\307E\305F\306F\30EA\30AF\30A8\30B9\30C8\3092\8A18\8F09\3057\3066\304F\3060\3055\3044\3002'),
'',
unistr('**\4E00\822C\30B3\30F3\30C6\30AD\30B9\30C8**'),
unistr('- \4F55\3092\3057\3088\3046\3068\3057\3066\3044\307E\3059\304B\3002'),
'',
'',
unistr('- \56DE\7B54\3092\898B\3064\3051\308B\305F\3081\306B\3069\3053\304B\5225\306E\5834\6240\3092\63A2\3057\305F\308A\3001\8AB0\304B\5225\306E\4EBA\7269\306B\9023\7D61\3057\305F\3053\3068\306F\3042\308A\307E\3059\304B\3002'),
'',
'',
unistr('**\74B0\5883** '),
unistr('\3053\306E\8CEA\554F\306F\3001\74B0\5883\3001\30D7\30ED\30B0\30E9\30DF\30F3\30B0\8A00\8A9E\307E\305F\306F\4ED6\306E\5206\91CE\306B\56FA\6709\3067\3059\304B\3002'),
'',
'______',
unistr('_**\6CE8\610F:** \554F\984C\3092\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\307E\305F\306F\30DA\30FC\30B8(\3042\308B\3044\306F\305D\306E\4E21\65B9)\306B\95A2\9023\4ED8\3051\308B\306B\306F\3001\6700\521D\306B\554F\984C\3092\30ED\30B0\306B\8A18\9332\3057\3001\6B21\306B\300C**\30A2\30AF\30B7\30E7\30F3**\300D\30C9\30ED\30C3\30D7\30C0\30A6\30F3\3092\4F7F\7528\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304A\3088\3073\30DA\30FC\30B8\3092\95A2\9023\4ED8\3051\307E\3059\3002_')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280159985198869379)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E2\77E5\306E\554F\984C\3092\53C2\7167\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280159863359869379)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E2\77E5\306E\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280160076101869379)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\78BA\8A8D\3057\305F\3068\3053\308D\3001\3053\308C\306F\65E2\77E5\306E\554F\984C\3067\3042\308B\3068\78BA\5B9A\3057\307E\3057\305F\3002\6B21\306E\8A73\7D30\3092\53C2\7167\3057\3066\304F\3060\3055\3044\3002'),
'',
unistr('- \30D0\30B0\30FB\30C8\30E9\30C3\30AD\30F3\30B0\30FB\30B7\30B9\30C6\30E0: '),
unistr('- \30D0\30B0ID: '),
unistr('- \30D0\30B0\306EURL: '),
'',
unistr('\30B3\30E1\30F3\30C8: ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280159660321869379)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\60C5\5831\306E\30EA\30AF\30A8\30B9\30C8\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280159578522869379)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\60C5\5831\304C\5FC5\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280159745777869379)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\3053\306E\554F\984C\306E\8A73\7D30\60C5\5831\304C\5FC5\8981\3067\3059:**'),
'',
unistr('\6B21\306B\30EA\30AF\30A8\30B9\30C8\3055\308C\3066\3044\308B\60C5\5831\3092\63D0\4F9B\3057\3066\304F\3060\3055\3044\3002\3053\306E\60C5\5831\304C\306A\3044\3068\3001\3053\308C\4EE5\4E0A\3053\306E\554F\984C\3092\9078\5225\3057\3066\5BFE\51E6\3059\308B\3053\3068\304C\96E3\3057\304F\306A\308A\307E\3059\3002'),
'',
'',
unistr('\30B3\30E1\30F3\30C8:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280158769729869378)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\554F\984C\306B\5BFE\3057\3066\30A2\30AF\30B7\30E7\30F3\306F\884C\308F\308C\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280158600085869378)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\5BFE\8C61\5916')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280158891210869378)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\614E\91CD\306B\691C\8A0E\3057\307E\3057\305F\304C\3001**\3053\306E\554F\984C\306B\5BFE\3057\3066\3053\308C\4EE5\4E0A\306E\30A2\30AF\30B7\30E7\30F3\306F\884C\308F\308C\307E\305B\3093**\3002'),
'',
unistr('\30B3\30E1\30F3\30C8:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279296578895868849)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30AD\30B9\30C8\30FB\30D5\30A1\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279295454182868848)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30AD\30B9\30C8\30FB\30D5\30A1\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279292269831868846)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280179863270869391)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB%0\304C%1 %2\306B\8FFD\52A0\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280178878993869390)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C%1 %2\306B\8FFD\52A0\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280180442340869391)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C%1 %2\306B\8FFD\52A0\3055\308C\307E\3057\305F				')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280179005981869391)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C%1 %2\306B\5272\308A\5F53\3066\3089\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280179401531869391)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C%1 %2\306B\95A2\9023\4ED8\3051\3089\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279296793734868849)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_language=>'ja'
,p_message_text=>unistr('%0	%1\306E\30B3\30E1\30F3\30C8\3092\7DE8\96C6\3057\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280180353710869391)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\554F\984C\306F\975E\8868\793A\306B\306A\308A\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280179230810869391)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C%1 %2\306E\91CD\8907\3068\3057\3066\30DE\30FC\30AF\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280180255239869391)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306B\3088\3063\3066%0\304C\958B\304B\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280179981158869391)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB%0\304C%1 %2\304B\3089\524A\9664\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280178943136869390)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C%1 %2\304B\3089\524A\9664\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280180566782869391)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C%1 %2\304B\3089\524A\9664\3055\308C\307E\3057\305F 			')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280180015075869391)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\30B9\30C6\30FC\30BF\30B9\304C%1 %2\306B\8A2D\5B9A\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280179660518869391)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_language=>'ja'
,p_message_text=>unistr('%0 %1\306B\30B5\30D6\30B9\30AF\30E9\30A4\30D6\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280179110382869391)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C%1 %2\304B\3089\5272\5F53\3066\89E3\9664\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280179536330869391)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3068\30DA\30FC\30B8\306E\95A2\9023\4ED8\3051\304C%0 %1\304B\3089\524A\9664\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280179345534869391)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8907%1\3068\3057\3066\306E%0\304C\30DE\30FC\30AF\89E3\9664\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280179742739869391)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_language=>'ja'
,p_message_text=>unistr('%0 %1\304B\3089\30B5\30D6\30B9\30AF\30E9\30A4\30D6\89E3\9664\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280180132933869391)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_language=>'ja'
,p_message_text=>unistr('%0 %1\306E\91CD\8907\304C%2\306B\3088\3063\3066\30DE\30FC\30AF\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279292466737868846)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_language=>'ja'
,p_message_text=>unistr('\672A\5272\5F53\3066')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279269706462868832)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279293293170868847)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30D6\30B9\30AF\30E9\30A4\30D6\89E3\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280221889784869418)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F4\65B0...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279296333189868849)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_language=>'ja'
,p_message_text=>unistr('ZIP\30D5\30A1\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279295205484868848)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_language=>'ja'
,p_message_text=>unistr('ZIP\30D5\30A1\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280528138657869609)
,p_name=>'APEX.ITEM.FILE.BROWSE'
,p_message_language=>'ja'
,p_message_text=>unistr('\53C2\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280526034548869608)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30A4\30EB\306E\9078\629E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280526160095869608)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30A4\30EB\306E\9078\629E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280631039369869672)
,p_name=>'APEX.ITEM.HELP_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280484181778869582)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0%0\304C\898B\3064\304B\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279279880474868838)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C\3001\6709\52B9\306A%0\3068%1\306E\7BC4\56F2\5185\306B\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279279929393868838)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_MULTIPLE_OF_STEP'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C%0\306E\500D\6570\3067\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279279299607868838)
,p_name=>'APEX.ITEM_TYPE.YES_NO.INVALID_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\306F\5024%0\304A\3088\3073%1\306B\4E00\81F4\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279279456281868838)
,p_name=>'APEX.ITEM_TYPE.YES_NO.NO_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3044\3044\3048')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279939059694869244)
,p_name=>'APEX.ITEM_TYPE.YES_NO.OFF_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279939159127869244)
,p_name=>'APEX.ITEM_TYPE.YES_NO.ON_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279279343280868838)
,p_name=>'APEX.ITEM_TYPE.YES_NO.YES_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\306F\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279250475608868819)
,p_name=>'APEX.LIST_MANAGER.ADD_ENTRY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30F3\30C8\30EA\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280195960851869401)
,p_name=>'APEX.LIST_MANAGER.BUTTON_ADD'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280196064703869401)
,p_name=>'APEX.LIST_MANAGER.BUTTON_REMOVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279250580822868820)
,p_name=>'APEX.LIST_MANAGER.SELECTED_ENTRY'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\3055\308C\305F\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280427795654869547)
,p_name=>'APEX.LTO.ADVANCED'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280428067302869548)
,p_name=>'APEX.LTO.CANCEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280427850889869547)
,p_name=>'APEX.LTO.COMMON'
,p_message_language=>'ja'
,p_message_text=>unistr('\5171\901A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280428191284869548)
,p_name=>'APEX.LTO.LIVE_TEMPLATE_OPTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30A4\30D6\30FB\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30AA\30D7\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280429313038869548)
,p_name=>'APEX.LTO.NOT_APPLICABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306F\30DA\30FC\30B8\306B\30EC\30F3\30C0\30EA\30F3\30B0\3055\308C\306A\3044\305F\3081\3001\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30AA\30D7\30B7\30E7\30F3\306F\4F7F\7528\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280427642746869547)
,p_name=>'APEX.LTO.NO_OPTIONS_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30AA\30D7\30B7\30E7\30F3\304C\898B\3064\304B\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280427918562869548)
,p_name=>'APEX.LTO.SAVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280425484971869546)
,p_name=>'APEX.MARKDOWN.BOLD'
,p_message_language=>'ja'
,p_message_text=>unistr('\592A\5B57')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280426771574869547)
,p_name=>'APEX.MARKDOWN.IMAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30E1\30FC\30B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280426394011869547)
,p_name=>'APEX.MARKDOWN.INLINE_CODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30F3\30E9\30A4\30F3\30FB\30B3\30FC\30C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280521258170869605)
,p_name=>'APEX.MARKDOWN.INSERT_IMAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30E1\30FC\30B8\306E\633F\5165')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280521338000869605)
,p_name=>'APEX.MARKDOWN.INSERT_LINK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30F3\30AF\306E\633F\5165')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280425520827869546)
,p_name=>'APEX.MARKDOWN.ITALIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30BF\30EA\30C3\30AF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280523097742869606)
,p_name=>'APEX.MARKDOWN.LINK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30F3\30AF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280426614924869547)
,p_name=>'APEX.MARKDOWN.LIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30B9\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280426544089869547)
,p_name=>'APEX.MARKDOWN.ORDERED_LIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\9806\5E8F\4ED8\3051\3055\308C\305F\30EA\30B9\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280425691049869546)
,p_name=>'APEX.MARKDOWN.PREVIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30EC\30D3\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280426127340869546)
,p_name=>'APEX.MARKDOWN.PREVIEW_EMPTY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30EC\30D3\30E5\30FC\5BFE\8C61\306A\3057')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280426282539869546)
,p_name=>'APEX.MARKDOWN.STRIKETHROUGH'
,p_message_language=>'ja'
,p_message_text=>unistr('\53D6\6D88\7DDA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280426469859869547)
,p_name=>'APEX.MARKDOWN.UNORDERED_LIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\9806\5E8F\4ED8\3051\3055\308C\3066\3044\306A\3044\30EA\30B9\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280054108035869314)
,p_name=>'APEX.MENU.CURRENT_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30EC\30F3\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280594383722869650)
,p_name=>'APEX.MENU.OVERFLOW_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280054065658869314)
,p_name=>'APEX.MENU.PROCESSING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30FC\30C9\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280504930319869595)
,p_name=>'APEX.NOTIFICATION_MESSAGE_HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\901A\77E5\30E1\30C3\30BB\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279416226462868925)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\901A\77E5\30E1\30C3\30BB\30FC\30B8\306E\30C1\30A7\30C3\30AF\30B5\30E0\30FB\30B3\30F3\30C6\30F3\30C4\30FB\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279416193913868925)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\901A\77E5\30E1\30C3\30BB\30FC\30B8\306E\30C1\30A7\30C3\30AF\30B5\30E0\5F62\5F0F\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280129628501869360)
,p_name=>'APEX.NUMBER_FIELD.VALUE_GREATER_MAX_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C\6307\5B9A\3055\308C\305F\6700\5927\306E%0\3088\308A\5927\304D\3044\5024\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280129719428869360)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\306F\6570\5024\3067\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280129888011869360)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID2'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C\6570\5024\66F8\5F0F%0\3068\4E00\81F4\3057\307E\305B\3093(\4F8B: %1)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280129510002869360)
,p_name=>'APEX.NUMBER_FIELD.VALUE_LESS_MIN_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C\3001\6307\5B9A\3057\305F\6700\5C0F\5024%0\3088\308A\5C0F\3055\3044\5024\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280129460223869360)
,p_name=>'APEX.NUMBER_FIELD.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\304C\3001\6709\52B9\306A%0\3068%1\306E\7BC4\56F2\5185\306B\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279655255365869070)
,p_name=>'APEX.PAGE.DUPLICATE_SUBMIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30DA\30FC\30B8\306F\3059\3067\306B\9001\4FE1\3055\308C\3066\3044\308B\305F\3081\3001\518D\9001\4FE1\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279517948414868986)
,p_name=>'APEX.PAGE.NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\300C%0\300D\306E\30DA\30FC\30B8\300C%1\300D\304C\898B\3064\304B\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279798881274869156)
,p_name=>'APEX.PAGE_ITEM_IS_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\306B\5024\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280534577677869613)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3064\3044\3066')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280534308002869613)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\69CB\6210\30AA\30D7\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280534449181869613)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\9078\629E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280196324214869402)
,p_name=>'APEX.POPUP_LOV.BUTTON_CLOSE'
,p_message_language=>'ja'
,p_message_text=>unistr('\9589\3058\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280196237935869401)
,p_name=>'APEX.POPUP_LOV.BUTTON_FIND'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\3092\691C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280196569422869402)
,p_name=>'APEX.POPUP_LOV.BUTTON_NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280196431549869402)
,p_name=>'APEX.POPUP_LOV.BUTTON_PREV'
,p_message_language=>'ja'
,p_message_text=>unistr('\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279273846066868834)
,p_name=>'APEX.POPUP_LOV.FILTER_REQ'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\6587\5B57\5217\3092%0\6587\5B57\4EE5\4E0A\3067\5165\529B\3057\3066\304F\3060\3055\3044\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279848148663869187)
,p_name=>'APEX.POPUP_LOV.ICON_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DD\30C3\30D7\30A2\30C3\30D7LOV: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279273973682868834)
,p_name=>'APEX.POPUP_LOV.INITIAL_FILTER_REQ'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\8A9E\3092\5165\529B\3057\3066\304F\3060\3055\3044\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279273794688868834)
,p_name=>'APEX.POPUP_LOV.NO_RESULTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D50\679C\304C\898B\3064\304B\308A\307E\305B\3093\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279273617663868834)
,p_name=>'APEX.POPUP_LOV.REMOVE_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280016398094869291)
,p_name=>'APEX.POPUP_LOV.SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\6587\5B57\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280196158061869401)
,p_name=>'APEX.POPUP_LOV.TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\30C0\30A4\30A2\30ED\30B0\30FB\30DC\30C3\30AF\30B9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279276422965868836)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\4E3B\30AD\30FC\5024\307E\305F\306F\524D\306E\4E3B\30AD\30FC\5024\3092\53D6\5F97\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280009320045869287)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B5\30FC\30D3\30B9\304C\898B\3064\304B\308A\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279519457435868987)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30BB\30B9\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280488567162869585)
,p_name=>'APEX.PROCESSING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30BB\30B9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279303189237868853)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30BB\30C3\30B7\30E7\30F3\306E\30EA\30BD\30FC\30B9\5236\9650\306E\305F\3081\3001Application Express\3067\30EA\30AF\30A8\30B9\30C8\3092\51E6\7406\3067\304D\307E\305B\3093\3067\3057\305F\3002\5F8C\3067\518D\8A66\884C\3057\3066\304F\3060\3055\3044\3002'),
'<p/>',
unistr('\3053\306E\30A4\30F3\30B7\30C7\30F3\30C8\306E\8A73\7D30\306F\3001\30C7\30D0\30C3\30B0ID "%0"\3088\308A\53C2\7167\3067\304D\307E\3059\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280545526533869620)
,p_name=>'APEX.REGION.CSSCALENDAR.ADD'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279967790452869261)
,p_name=>'APEX.REGION.CSSCALENDAR.ALL_DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280617871290869664)
,p_name=>'APEX.REGION.CSSCALENDAR.BUTTON.SENDEMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\62DB\5F85\306E\9001\4FE1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280617586768869664)
,p_name=>'APEX.REGION.CSSCALENDAR.CHOOSE_ACTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30D7\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279982836668869270)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_ALLDAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\65E5\306E\65E5\3054\3068\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279982675673869270)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_TIME_SPECIFIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\6642\9593\4ED8\304D\306E\30C7\30FC\30BF\306E\65E5\3054\3068\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280507468917869597)
,p_name=>'APEX.REGION.CSSCALENDAR.DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280454353671869564)
,p_name=>'APEX.REGION.CSSCALENDAR.DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8AAC\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279365438470868892)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.CSV'
,p_message_language=>'ja'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279365216023868892)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.ICALENDAR'
,p_message_language=>'ja'
,p_message_text=>'iCal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279365162255868892)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.PDF'
,p_message_language=>'ja'
,p_message_text=>'PDF'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279365330079868892)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.XML'
,p_message_language=>'ja'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279364839654868892)
,p_name=>'APEX.REGION.CSSCALENDAR.ENDDATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279365071892868892)
,p_name=>'APEX.REGION.CSSCALENDAR.EVENTNAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280617660031869664)
,p_name=>'APEX.REGION.CSSCALENDAR.INVITATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\62DB\5F85')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280507510899869597)
,p_name=>'APEX.REGION.CSSCALENDAR.LIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280507215825869597)
,p_name=>'APEX.REGION.CSSCALENDAR.MONTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280522270619869606)
,p_name=>'APEX.REGION.CSSCALENDAR.NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280575923342869639)
,p_name=>'APEX.REGION.CSSCALENDAR.NOEVENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8\306A\3057')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280618208837869664)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.FORM'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E2\5B58\306E\30A4\30D9\30F3\30C8\3092\7DE8\96C6\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280618144940869664)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.SEND'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\3067\62DB\5F85\3092\9001\4FE1\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280522374800869606)
,p_name=>'APEX.REGION.CSSCALENDAR.PREVIOUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280561605474869630)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280561214321869630)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.BUTTON'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280625276038869669)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30D5\30A3\30FC\30EB\30C9\304C\5FC5\9808\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280625184709869669)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\62DB\5F85\306E\9001\4FE1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280617212953869664)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.SUBJECT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4EF6\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280561513656869630)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.TO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9B\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279364976194868892)
,p_name=>'APEX.REGION.CSSCALENDAR.STARTDATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\59CB\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280542222120869618)
,p_name=>'APEX.REGION.CSSCALENDAR.TABLEFORM'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\30D5\30A9\30FC\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279982491519869270)
,p_name=>'APEX.REGION.CSSCALENDAR.TIME'
,p_message_language=>'ja'
,p_message_text=>unistr('\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280522937670869606)
,p_name=>'APEX.REGION.CSSCALENDAR.TODAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\4ECA\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280508331147869597)
,p_name=>'APEX.REGION.CSSCALENDAR.VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D3\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280507303451869597)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279982734157869270)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_ALLDAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\65E5\306E\9031\3054\3068\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279982541143869270)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_TIME_SPECIFIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\6642\9593\4ED8\304D\306E\30C7\30FC\30BF\306E\9031\3054\3068\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280507979560869597)
,p_name=>'APEX.REGION.CSSCALENDAR.YEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279276762718868836)
,p_name=>'APEX.REGION.FLASH_CHART.INITIALIZING'
,p_message_language=>'ja'
,p_message_text=>unistr('\521D\671F\5316\4E2D...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279536117849868997)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_DATA'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\306E\30ED\30FC\30C9\4E2D...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280547018364869621)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_RESOURCES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30BD\30FC\30B9\3092\30ED\30FC\30C9\3057\3066\3044\307E\3059...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280547147175869621)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_TEMPLATES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\3092\30ED\30FC\30C9\3057\3066\3044\307E\3059...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279276829004868836)
,p_name=>'APEX.REGION.FLASH_CHART.NO_DATA_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\304C\898B\3064\304B\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279441630085868940)
,p_name=>'APEX.REGION.FLASH_CHART.SHOW_XML'
,p_message_language=>'ja'
,p_message_text=>unistr('XML\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279536297870868997)
,p_name=>'APEX.REGION.FLASH_CHART.WAITING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\3092\30ED\30FC\30C9\4E2D\3067\3059\3002\3057\3070\3089\304F\304A\5F85\3061\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280507683034869597)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280507792142869597)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.LOAD_MORE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3055\3089\306B\30ED\30FC\30C9...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279708573030869102)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.BACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\623B\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279304655927868854)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.LOAD_MORE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3055\3089\306B\30ED\30FC\30C9...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279329610002868870)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280507840873869597)
,p_name=>'APEX.REGION.JQM_REFLOW.LOAD_MORE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3055\3089\306B\30ED\30FC\30C9...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280521571002869605)
,p_name=>'APEX.REGION.NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3ID %0\304C\898B\3064\304B\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279315810668868861)
,p_name=>'APEX.REGION.NO_DATA_FOUND_MESSAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\304C\898B\3064\304B\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279523820243868990)
,p_name=>'APEX.REGION.PAGINATION.RESET_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\30DA\30FC\30B8\533A\5207\308A\3092\30EA\30BB\30C3\30C8\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279276600451868836)
,p_name=>'APEX.REGION.PAGINATION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\30DA\30FC\30B8\533A\5207\308A\306E\8A2D\5B9A\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280449028615869561)
,p_name=>'APEX.REGION.RESPONSIVE_TABLE.COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280521475098869605)
,p_name=>'APEX.REGION.TYPE_NOT_SUPPORTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3\30FB\30BF\30A4\30D7%0\306F\30B5\30DD\30FC\30C8\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279276534954868836)
,p_name=>'APEX.REGION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3"#COMPONENT_NAME#"\306E\30EC\30F3\30C0\30EA\30F3\30B0\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279798965583869156)
,p_name=>'APEX.REGION_COLUMN_IS_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('#COLUMN_HEADER#\306B\5024\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279979085026869268)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_language=>'ja'
,p_message_text=>unistr('REST\5BFE\5FDCSQL\30B5\30FC\30D3\30B9\306E\8A8D\8A3C\306B\5931\6557\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279303457650868853)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\306B\5931\6557\3057\307E\3057\305F\3002\7121\52B9\306AWeb\8CC7\683C\8A3C\660E\3092\53C2\7167\3057\3066\3044\308BREST\5BFE\5FDCSQL\30C7\30FC\30BF\30FB\30BD\30FC\30B9\304CLOV\3067\4F7F\7528\3055\308C\3066\3044\308B\305F\3081\3001\3053\306ELOV\306E\5217\60C5\5831\306F\7DE8\96C6\3067\304D\307E\305B\3093\3002\8A8D\8A3C\8CC7\683C\8A3C\660E\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280517326302869603)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_language=>'ja'
,p_message_text=>unistr('\901A\4FE1\969C\5BB3\3002LOV\3067\53C2\7167\3055\308C\3066\3044\308BREST\5BFE\5FDCSQL\30C7\30FC\30BF\30FB\30BD\30FC\30B9\306E\8D77\52D5\4E2D\306B\554F\984C\304C\767A\751F\3057\305F\305F\3081\3001LOV\306E\5217\60C5\5831\3092\7DE8\96C6\3067\304D\307E\305B\3093\3002REST\5BFE\5FDCSQL\30C7\30FC\30BF\30FB\30BD\30FC\30B9\304C\6B63\5E38\306B\52D5\4F5C\3057\3066\3044\308B\3053\3068\3068\3001\5BFE\5FDC\3059\308B\8A8D\8A3C\8CC7\683C\8A3C\660E\304C\6B63\3057\3044\3053\3068\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280046715426869310)
,p_name=>'APEX.REMOTESQL.OAUTH_IS_RECOMMENDED'
,p_message_language=>'ja'
,p_message_text=>unistr('\8B66\544A: REST\5BFE\5FDCSQL\3067\306E\8A8D\8A3C\306B\306FOAuth\30AF\30E9\30A4\30A2\30F3\30C8\8CC7\683C\8A3C\660E\306E\4F7F\7528\3092\304A\85A6\3081\3057\307E\3059\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279980426710869269)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30E2\30FC\30C8\30FB\30B5\30FC\30D0\30FC\3067\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279937224414869243)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\6307\5B9A\3057\305FORDS REST\5BFE\5FDCSQL\30A4\30F3\30B9\30BF\30F3\30B9\304C\898B\3064\304B\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279538418673868998)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30FC\30D0\30FC\306F\30EA\30C0\30A4\30EC\30AF\30B7\30E7\30F3\3092\9001\4FE1\3057\307E\3057\305F: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279826467962869173)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\6587\304C32.767\30D0\30A4\30C8\3092\8D85\3048\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279846361545869185)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Hello, Application Express! \3042\306A\305F\306F#USER#\3068\3057\3066\63A5\7D9A\3057\3066\3044\307E\3059\3002'),
unistr('\30ED\30FC\30AB\30EB\30FB\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30BF\30A4\30E0\30B9\30BF\30F3\30D7\306F\3001#SYSDATE#\3067\3059\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280174453511869388)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\30C7\30D5\30A9\30EB\30C8\30FB\30B9\30AD\30FC\30DE\306E\5225\540D\3092\7DE8\96C6\3057\3088\3046\3068\3057\3066\3044\307E\3059\3002\3053\306E\5225\540D\3092\8A2D\5B9A\3059\308B\3068\3001\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30EC\30D9\30EB\306E\30D1\30B9\63A5\982D\8F9E\3082\5909\66F4\3055\308C\307E\3059\3002\3053\308C\306B\3088\308A\3001\5B9A\7FA9\3055\308C\3066\3044\308B\53EF\80FD\6027\306E\3042\308BAPEX\30D9\30FC\30B9\306ERESTful\30B5\30FC\30D3\30B9\306EURL\304C\5F71\97FF\3092\53D7\3051\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279833682915869178)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ORDS'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\5728\306EORDS\30D0\30FC\30B8\30E7\30F3\3067\306F\3001REST\7BA1\7406\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306F\30B5\30DD\30FC\30C8\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279833708931869178)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ROLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6307\5B9A\3055\308C\305F\30AF\30E9\30A4\30A2\30F3\30C8\30FB\30ED\30FC\30EB\306F\3001REST\7BA1\7406\30A4\30F3\30BF\30D5\30A7\30FC\30B9\3067\30B5\30DD\30FC\30C8\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280613054920869661)
,p_name=>'APEX.RICH_TEXT_EDITOR.ACCESSIBLE_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\3001\30EA\30C3\30C1\30FB\30C6\30AD\30B9\30C8\30FB\30A8\30C7\30A3\30BF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279824088055869172)
,p_name=>'APEX.RICH_TEXT_EDITOR.MAXIMUM_LENGTH_EXCEEDED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30C3\30C1\30FB\30C6\30AD\30B9\30C8HTML\30DE\30FC\30AF\30A2\30C3\30D7\304C\30A2\30A4\30C6\30E0\306E\6700\5927\9577\3092\8D85\3048\3066\3044\307E\3059(\5B9F\969B\306F%0\6587\5B57\3067\3001%1\6587\5B57\304C\8A31\53EF\3055\308C\3066\3044\307E\3059)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280506201067869596)
,p_name=>'APEX.RV.DELETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280432088696869550)
,p_name=>'APEX.RV.DUPLICATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\8907')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280427285631869547)
,p_name=>'APEX.RV.EXCLUDE_HIDDEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280427192816869547)
,p_name=>'APEX.RV.EXCLUDE_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('NULL\5024\306E\9664\5916')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280506322682869596)
,p_name=>'APEX.RV.INSERT'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279966455247869260)
,p_name=>'APEX.RV.MOVE_DOWN'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0B\306B\79FB\52D5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279966510904869260)
,p_name=>'APEX.RV.MOVE_UP'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0A\306B\79FB\52D5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280426965149869547)
,p_name=>'APEX.RV.NEXT_RECORD'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280427513219869547)
,p_name=>'APEX.RV.NOT_GROUPED_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\305D\306E\4ED6\306E\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280427018188869547)
,p_name=>'APEX.RV.PREV_RECORD'
,p_message_language=>'ja'
,p_message_text=>unistr('\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280427316997869547)
,p_name=>'APEX.RV.REC_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C%0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280427429509869547)
,p_name=>'APEX.RV.REC_XY'
,p_message_language=>'ja'
,p_message_text=>unistr('%1\884C\4E2D%0\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280432115570869550)
,p_name=>'APEX.RV.REFRESH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30D5\30EC\30C3\30B7\30E5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280432251243869550)
,p_name=>'APEX.RV.REVERT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5909\66F4\306E\56DE\5FA9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280426807534869547)
,p_name=>'APEX.RV.SETTINGS_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\8A2D\5B9A\300D\30E1\30CB\30E5\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279901217285869220)
,p_name=>'APEX.SAMPLE_FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F8B: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279824186876869172)
,p_name=>'APEX.SC.REFERENCES'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\53C2\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280165737544869383)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30C6\30A3\30EA\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280165899515869383)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E6\30FC\30C6\30A3\30EA\30C6\30A3 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280173225514869387)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306B\79FB\52D5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280173146265869387)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306B\79FB\52D5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280165960106869383)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280166066342869383)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC\30FB\30BF\30B9\30AF > ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280166186586869383)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280166247718869383)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280166351296869383)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30ED\30B8\30C3\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280166412694869383)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280166589235869383)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30BB\30AD\30E5\30EA\30C6\30A3\8A8D\8A3C\30B9\30AD\30FC\30E0 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280166636072869383)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280166776860869383)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30BB\30AD\30E5\30EA\30C6\30A3\8A8D\53EF\30B9\30AD\30FC\30E0 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280166820391869383)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280166900377869383)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30D6\30EC\30C3\30C9\30AF\30E9\30E0 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280167083141869383)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280167171649869383)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280167249095869383)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280167323505869383)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30B3\30F3\30DD\30FC\30CD\30F3\30C8\8A2D\5B9A \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280167494326869384)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280167572443869384)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A08\7B97 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280167628754869384)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280167715123869384)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280167875524869384)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280167948864869384)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A08\7B97\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280168020395869384)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280168169178869384)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30B0\30A4\30F3\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280168294799869384)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30FC\30DE\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280168394046869384)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\8CC7\683C\8A3C\660E\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280168451341869384)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30FB\30ED\30FC\30C9\5B9A\7FA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280168510496869384)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30C7\30FC\30BF\30FB\30ED\30FC\30C9\5B9A\7FA9 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280168629042869384)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30FB\30BD\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280168732833869384)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9A\7FA9\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280168863570869384)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280168956055869384)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280169054587869385)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280169147819869385)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30AC\30B7\30FCWeb\30B5\30FC\30D3\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280169266779869385)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30EC\30AC\30B7\30FCWeb\30B5\30FC\30D3\30B9 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280169359142869385)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30EA\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280169490211869385)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30AF\30E9\30B7\30C3\30AF\30FB\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30EA\30B9\30C8 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280169519334869385)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_language=>'ja'
,p_message_text=>'LOV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280169670009869385)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C LOV \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280169769965869385)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280169817014869385)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\4ED6\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280169971377869385)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30B0\30A4\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280170080110869385)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30D7\30E9\30B0\30A4\30F3 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280170197437869385)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30BB\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280170201715869385)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280170399282869385)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\554F\5408\305B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280170439856869385)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30EC\30DD\30FC\30C8\554F\5408\305B \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280170549378869385)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280170608989869386)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_language=>'ja'
,p_message_text=>unistr('REST\5BFE\5FDCSQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280170700352869386)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C REST\5BFE\5FDCSQL \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280170803987869386)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30AD\30E5\30EA\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280170988835869386)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\4FDD\8B77')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280171058055869386)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\72B6\614B\4FDD\8B77\306E\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280171260932869386)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280171336920869386)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280171421550869386)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B7\30E7\30FC\30C8\30AB\30C3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280171535644869386)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30B7\30E7\30FC\30C8\30AB\30C3\30C8 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280171699426869386)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30D6(\30EC\30AC\30B7\30FC)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280171757661869386)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280171814223869386)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C UI\30C6\30F3\30D7\30EC\30FC\30C8 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280171921850869386)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30FC\30DE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280172004326869386)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C UI\30C6\30FC\30DE \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280172149086869386)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280172298010869387)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\8CC7\683C\8A3C\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280172344640869387)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C \30BB\30AD\30E5\30EA\30C6\30A3Web\8CC7\683C\8A3C\660E \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280172430409869387)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30BD\30FC\30B9\30FB\30E2\30B8\30E5\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280172557449869387)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5\5148: \5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8 \005C Web\30BD\30FC\30B9\30FB\30E2\30B8\30E5\30FC\30EB \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280172689409869387)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\30EF\30FC\30AF\30B7\30E7\30C3\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280172701246869387)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30D6\30B8\30A7\30AF\30C8\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280172831950869387)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\30EF\30FC\30AF\30B7\30E7\30C3\30D7\3067\306E%LIST_ITEM_NAME%\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280172911783869387)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30AF\30EA\30D7\30C8\30FB\30A8\30C7\30A3\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280173068907869387)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_language=>'ja'
,p_message_text=>unistr('SQL\30EF\30FC\30AF\30B7\30E7\30C3\30D7\30FB\30BF\30B9\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280555539014869626)
,p_name=>'APEX.SESSION.DB_SESSION_CLEANUP.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30BB\30C3\30B7\30E7\30F3\306E\30AF\30EA\30FC\30F3\30A2\30C3\30D7\30FB\30B3\30FC\30C9\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279517462998868986)
,p_name=>'APEX.SESSION.DB_SESSION_INIT.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30BB\30C3\30B7\30E7\30F3\306E\8A2D\5B9A\30B3\30FC\30C9\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279291108615868845)
,p_name=>'APEX.SESSION.EXPIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3\304C\671F\9650\5207\308C\3067\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280547224780869621)
,p_name=>'APEX.SESSION.EXPIRED.CLOSE_DIALOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30C0\30A4\30A2\30ED\30B0\3092\9589\3058\3001\30D6\30E9\30A6\30B6\306E\300C\30EA\30ED\30FC\30C9\300D\30DC\30BF\30F3\3092\62BC\3057\3066\65B0\3057\3044\30BB\30C3\30B7\30E7\30F3\3092\53D6\5F97\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280607435034869658)
,p_name=>'APEX.SESSION.EXPIRED.NEW_SESSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\65B0\898F\30BB\30C3\30B7\30E7\30F3\3092\4F5C\6210\3059\308B\306B\306F\3001<a href="%0">\3053\3053</a>\3092\30AF\30EA\30C3\30AF\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279970594749869263)
,p_name=>'APEX.SESSION.RAS.NO_DYNAMIC_ROLES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC"%0"\306EReal Application Security\30BB\30C3\30B7\30E7\30F3\3067\52D5\7684\30ED\30FC\30EB\3092\6709\52B9\306B\3067\304D\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279510394561868981)
,p_name=>'APEX.SESSION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('ERR-99900 \4E00\610F\306E\30BB\30C3\30B7\30E7\30F3ID\3092\4F5C\6210\3067\304D\307E\305B\3093\3067\3057\305F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280618507998869665)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0%0\306F\30C7\30FC\30BF\30D9\30FC\30B9\5217\306B\57FA\3065\3044\3066\3044\307E\3059\304C\3001\5C5E\6027\300C\4F7F\7528\3055\308C\308B\30BD\30FC\30B9\300D\304C\300C\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\306E\5024\304CNULL\306E\5834\5408\306E\307F\300D\306B\8A2D\5B9A\3055\308C\3066\3044\307E\3059\3002\8907\6570\306E\30EC\30B3\30FC\30C9\3092\8868\793A\304A\3088\3073\4FDD\5B58\3059\308B\5834\5408\3001\3053\308C\306F\975E\5E38\306B\5371\967A\3067\3042\308A\3001\8AA4\3063\3066\30C7\30FC\30BF\3092\4E0A\66F8\304D\3059\308B\53EF\80FD\6027\304C\3042\308A\307E\3059\3002\5E38\306B\300C\4F7F\7528\3055\308C\308B\30BD\30FC\30B9\300D\3092\300C\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\306E\65E2\5B58\306E\5024\3092\5E38\306B\7F6E\63DB\300D\306B\8A2D\5B9A\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280528070373869609)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\3078\306E\30A2\30AF\30BB\30B9\306F\7121\52B9\3067\3059\3002\8AAD\53D6\308A/\66F8\8FBC\307F\306E\8A66\884C\306F\30D6\30ED\30C3\30AF\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279328759088868869)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\51E6\7406\4E2D\306B\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\306E\30A2\30A4\30C6\30E0%0\3092\4FDD\5B58\3057\3088\3046\3068\3057\307E\3057\305F\3002\30A2\30A4\30C6\30E0\306F\5185\90E8\306E\307F\306E\4FDD\8B77\304C\8A2D\5B9A\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279310115168868857)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_language=>'ja'
,p_message_text=>unistr('\53D7\5165\308C\51E6\7406\4E2D\306B\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\306E\30A2\30A4\30C6\30E0%0\3092\4FDD\5B58\3057\3088\3046\3068\3057\307E\3057\305F\3002\30A2\30A4\30C6\30E0\306F\5185\90E8\306E\307F\306E\4FDD\8B77\304C\8A2D\5B9A\3055\308C\3066\3044\308B\304B\3001\30DD\30B9\30C8\3067\304D\308B\30D5\30A9\30FC\30E0\30FB\30A2\30A4\30C6\30E0\3067\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279584659875869027)
,p_name=>'APEX.SESSION_STATE.ITEM_VALUE_PROTECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\306E\4FDD\8B77\9055\53CD: \3053\308C\306F\3001\4FDD\8B77\3055\308C\305F\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0%0\306E\624B\52D5\5909\66F4\304C\539F\56E0\3067\767A\751F\3057\305F\53EF\80FD\6027\304C\3042\308A\307E\3059\3002\3053\306E\30A8\30E9\30FC\306E\539F\56E0\304C\4E0D\660E\306A\5834\5408\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\306B\9023\7D61\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280643577517869680)
,p_name=>'APEX.SESSION_STATE.PAGE_PROTECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\4FDD\8B77\9055\53CD: \3053\308C\306F\3001\307E\3060\30ED\30FC\30C9\304C\5B8C\4E86\3057\3066\3044\306A\3044\30DA\30FC\30B8\3092\767A\884C\3057\305F\3001\307E\305F\306F\4FDD\8B77\3055\308C\3066\3044\308B\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\3092\624B\52D5\3067\5909\66F4\3057\305F\3053\3068\304C\539F\56E0\3067\767A\751F\3057\305F\53EF\80FD\6027\304C\3042\308A\307E\3059\3002\8A73\7D30\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\306B\554F\3044\5408\305B\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280640443216869678)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306B\306F\3001&<>"/;,*|=% or --\306E\3044\305A\308C\304B\306E\7121\52B9\306A\6587\5B57\304C\542B\307E\308C\3066\3044\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280640515296869678)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR_NL'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306B\306F\3001&<>"/;,*|=% or --\3001\307E\305F\306F\6539\884C\306E\3044\305A\308C\304B\306E\7121\52B9\306A\6587\5B57\304C\542B\307E\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280640273217869678)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.US_ONLY'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306B\7279\6B8A\6587\5B57\304C\542B\307E\308C\3066\3044\307E\3059\3002\4ED5\69D8\3067\304D\308B\306E\306Fa-Z\30010-9\304A\3088\3073\7A7A\767D\306E\307F\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280640346845869678)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306B\306F\3001\7121\52B9\306A\6587\5B57<\3001>\307E\305F\306F"\304C\542B\307E\308C\3066\3044\307E\3059\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279309753846868857)
,p_name=>'APEX.SESSION_STATE.SSP_CHECKSUM_MISSING'
,p_message_language=>'ja'
,p_message_text=>unistr('1\3064\4EE5\4E0A\306E\30EA\30AF\30A8\30B9\30C8\3001\30AD\30E3\30C3\30B7\30E5\306E\30AF\30EA\30A2\307E\305F\306F\5F15\6570\5024\304C\30D1\30E9\30E1\30FC\30BF\3068\3057\3066\6E21\3055\308C\308B\5834\5408\306B\30C1\30A7\30C3\30AF\30B5\30E0\3092\5FC5\8981\3068\3059\308B\30DA\30FC\30B8\306E\8868\793A\51E6\7406\306B\5BFE\3057\30C1\30A7\30C3\30AF\30B5\30E0\304C\63D0\4F9B\3055\308C\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279571683349869019)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\306E\4FDD\8B77\9055\53CD: \3053\308C\306F\3001\30C1\30A7\30C3\30AF\30B5\30E0\3092\542B\3080URL\306E\624B\52D5\5909\66F4\3001\3042\308B\3044\306F\4E0D\9069\5207\307E\305F\306F\6B20\843D\3057\305F\30C1\30A7\30C3\30AF\30B5\30E0\3092\542B\3080\30EA\30F3\30AF\306E\4F7F\7528\304C\539F\56E0\3067\767A\751F\3057\305F\53EF\80FD\6027\304C\3042\308A\307E\3059\3002\3053\306E\30A8\30E9\30FC\306E\539F\56E0\304C\4E0D\660E\306A\5834\5408\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\306B\9023\7D61\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279309829036868857)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\30EA\30AF\30A8\30B9\30C8\3001\30AD\30E3\30C3\30B7\30E5\306E\30AF\30EA\30A2\3001\5F15\6570\540D\304A\3088\3073\5F15\6570\5024(%0)\3067\8A08\7B97\3055\308C\305F\30C1\30A7\30C3\30AF\30B5\30E0\306F\3001\8868\793A\30D7\30ED\30B7\30FC\30B8\30E3(%1)\306B\6E21\3055\308C\305F\30C1\30A7\30C3\30AF\30B5\30E0\3068\4E00\81F4\3057\307E\305B\3093\3067\3057\305F\3002'),
'',
unistr('\6CE8\610F: \30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\306F\7570\306A\308B\30A8\30E9\30FC\30FB\30E1\30C3\30BB\30FC\30B8\304C\8868\793A\3055\308C\307E\3059\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279308792915868856)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8868\793A\51E6\7406\4E2D\306B\3001\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\306E\30A2\30A4\30C6\30E0%0\3092\4FDD\5B58\3057\3088\3046\3068\3057\307E\3057\305F\3002\30A2\30A4\30C6\30E0\4FDD\8B77\30EC\30D9\30EB:'),
'  %1',
'',
unistr('\30C1\30A7\30C3\30AF\30B5\30E0\304C\6E21\3055\308C\3066\3044\306A\3044\304B\3001\307E\305F\306F\6E21\3055\308C\305F\30C1\30A7\30C3\30AF\30B5\30E0\306F\4FDD\8B77\30EC\30D9\30EB%2\306E\30A2\30A4\30C6\30E0\306B\9069\3057\3066\3044\307E\3059\3002'),
'',
unistr('\6CE8\610F: \30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\306F\7570\306A\308B\30A8\30E9\30FC\30FB\30E1\30C3\30BB\30FC\30B8\304C\8868\793A\3055\308C\307E\3059\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279519210862868987)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('ERR-1022 \5C5E\6027\3092\4FDD\5B58\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280428261608869548)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_OFF'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30FB\30B3\30F3\30C8\30E9\30B9\30C8\30FB\30E2\30FC\30C9\3092\30AA\30D5\306B\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280428309850869548)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_ON'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30FB\30B3\30F3\30C8\30E9\30B9\30C8\30FB\30E2\30FC\30C9\3092\30AA\30F3\306B\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279544019609869002)
,p_name=>'APEX.SHUTTLE.CONTROL_BOTTOM'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279544293029869002)
,p_name=>'APEX.SHUTTLE.CONTROL_DOWN'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0B\3078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279544355442869002)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279544482607869002)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\79FB\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279544519994869002)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279544658067869002)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279544769869869002)
,p_name=>'APEX.SHUTTLE.CONTROL_RESET'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30BB\30C3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279543992985869002)
,p_name=>'APEX.SHUTTLE.CONTROL_TOP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C8\30C3\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279544109575869002)
,p_name=>'APEX.SHUTTLE.CONTROL_UP'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0A\3078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280581441858869642)
,p_name=>'APEX.SINCE.SHORT.DAYS_AGO'
,p_message_language=>'ja'
,p_message_text=>'%0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280582142784869642)
,p_name=>'APEX.SINCE.SHORT.DAYS_FROM_NOW'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\65E5\4EE5\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280581364947869642)
,p_name=>'APEX.SINCE.SHORT.HOURS_AGO'
,p_message_language=>'ja'
,p_message_text=>'%0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280582222301869642)
,p_name=>'APEX.SINCE.SHORT.HOURS_FROM_NOW'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\6642\9593\4EE5\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280581114505869642)
,p_name=>'APEX.SINCE.SHORT.MINUTES_AGO'
,p_message_language=>'ja'
,p_message_text=>'%0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280582329783869642)
,p_name=>'APEX.SINCE.SHORT.MINUTES_FROM_NOW'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\5206\4EE5\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280581787609869642)
,p_name=>'APEX.SINCE.SHORT.MONTHS_AGO'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304B\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280581901309869642)
,p_name=>'APEX.SINCE.SHORT.MONTHS_FROM_NOW'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304B\6708\4EE5\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280581299975869642)
,p_name=>'APEX.SINCE.SHORT.SECONDS_AGO'
,p_message_language=>'ja'
,p_message_text=>'%0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280582011546869642)
,p_name=>'APEX.SINCE.SHORT.SECONDS_FROM_NOW'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\79D2\4EE5\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280581545328869642)
,p_name=>'APEX.SINCE.SHORT.WEEKS_AGO'
,p_message_language=>'ja'
,p_message_text=>'%0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280582449196869643)
,p_name=>'APEX.SINCE.SHORT.WEEKS_FROM_NOW'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\9031\9593\4EE5\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280581628863869642)
,p_name=>'APEX.SINCE.SHORT.YEARS_AGO'
,p_message_language=>'ja'
,p_message_text=>'%0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280581820242869642)
,p_name=>'APEX.SINCE.SHORT.YEARS_FROM_NOW'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\5E74\4EE5\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279757802517869132)
,p_name=>'APEX.SPLITTER.COLLAPSE_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\9589\3058\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279757796548869131)
,p_name=>'APEX.SPLITTER.RESTORE_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30B9\30C8\30A2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280164784858869382)
,p_name=>'APEX.STAR_RATING.CLEAR_RATING'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A55\4FA1\306E\30AF\30EA\30A2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280128743078869360)
,p_name=>'APEX.STAR_RATING.INVALID_RATING_RANGE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F1\304B\3089%1\307E\3067\306E\6709\52B9\306A\8A55\4FA1\7BC4\56F2\5185\306B\3042\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280128849441869360)
,p_name=>'APEX.STAR_RATING.IS_NOT_NUMERIC'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306F\6570\5024\3067\306F\3042\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280100701945869343)
,p_name=>'APEX.SUCCESS_MESSAGE_HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\6210\529F\30E1\30C3\30BB\30FC\30B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279416413681868925)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6210\529F\30E1\30C3\30BB\30FC\30B8\306E\30C1\30A7\30C3\30AF\30B5\30E0\30FB\30B3\30F3\30C6\30F3\30C4\30FB\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279416303322868925)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6210\529F\30E1\30C3\30BB\30FC\30B8\306E\30C1\30A7\30C3\30AF\30B5\30E0\5F62\5F0F\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280612631028869661)
,p_name=>'APEX.TABS.NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280612539690869661)
,p_name=>'APEX.TABS.PREVIOUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279267896330868831)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217#COMPONENT_NAME#\306E\30C7\30D5\30A9\30EB\30C8\5024\3092\8A08\7B97\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279268406871868831)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\8907\6570\884C\306E\524A\9664\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279553472535869007)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30A7\30C3\30AF\30B5\30E0\5217(\300CFCS\300D)\304C\5FC5\8981\3067\3059\304C\3001\6307\5B9A\3055\308C\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279553609580869008)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E3B\30AD\30FC\5024\304C\6307\5B9A\3055\308C\307E\305B\3093\3067\3057\305F\3002\66F4\65B0\3092\884C\3046\306B\306F\30011\884C\4EE5\4E0A\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279554435537869008)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6307\5B9A\3055\308C\305F2\6B21\30AD\30FC\5217\306B2\6B21\5024\304C\6307\5B9A\3055\308C\3066\3044\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279671378162869079)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\5F62\5F0F\306E\30C7\30FC\30BF\304C\898B\3064\304B\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279553380184869007)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E3B\30AD\30FC\5217\304C\6307\5B9A\3055\308C\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279554323026869008)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\6307\5B9A\3055\308C\305F2\6B21\30AD\30FC\5217\304C\3001\554F\5408\305B\306ESELECT\69CB\6587\306E\30EA\30B9\30C8\306B\898B\3064\304B\308A\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279553249195869007)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\540D\304C\6307\5B9A\3055\308C\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279553158105869007)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\306E\6240\6709\8005\304C\6307\5B9A\3055\308C\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279575494498869021)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\8907\6570\884C\306E\66F4\65B0\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280576004812869639)
,p_name=>'APEX.TB.TOOLBAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C4\30FC\30EB\30D0\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279436779261868937)
,p_name=>'APEX.TEAM.COMMITTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30DF\30C3\30C8\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279436565073868937)
,p_name=>'APEX.TEAM.CONTRIBUTOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279438484995868938)
,p_name=>'APEX.TEAM.CREATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD%0\304C\8FFD\52A0\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279438562214868938)
,p_name=>'APEX.TEAM.DELETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD%0\304C\524A\9664\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279258879213868825)
,p_name=>'APEX.TEAM.DEPRECATED'
,p_message_language=>'ja'
,p_message_text=>unistr('APEX\30C1\30FC\30E0\958B\767A\306F\3001\30D0\30FC\30B8\30E7\30F319.2\4EE5\964D\306F\975E\63A8\5968\3068\306A\3063\3066\304A\308A\3001\5C06\6765\306E\30EA\30EA\30FC\30B9\304B\3089\306F\524A\9664\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279436829705868937)
,p_name=>'APEX.TEAM.ESTIMATED_EFFORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\63A8\5B9A\4F5C\696D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279437190650868937)
,p_name=>'APEX.TEAM.FEATURE_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8AAC\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279436318252868937)
,p_name=>'APEX.TEAM.FEATURE_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279436915145868937)
,p_name=>'APEX.TEAM.FEATURE_STATUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD\30B9\30C6\30FC\30BF\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279437008814868937)
,p_name=>'APEX.TEAM.MILESTONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30A4\30EB\30B9\30C8\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279437399756868937)
,p_name=>'APEX.TEAM.NO'
,p_message_language=>'ja'
,p_message_text=>unistr('\3044\3044\3048')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279436461077868937)
,p_name=>'APEX.TEAM.OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279436660728868937)
,p_name=>'APEX.TEAM.RELEASE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30EA\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279435456543868936)
,p_name=>'APEX.TEAM.SAVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD%0\304C\66F4\65B0\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279437226253868937)
,p_name=>'APEX.TEAM.YES'
,p_message_language=>'ja'
,p_message_text=>unistr('\306F\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280615410339869663)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_NAV_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\306E\62E1\5F35/\7E2E\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280615589166869663)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_SIDE_COL_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A2A\306E\5217\306E\62E1\5F35/\7E2E\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279291515761868846)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3"%1"\3067\30C6\30FC\30DE"%0"\3092\30B3\30D4\30FC\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280607931744869658)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\30A4\30F3\30DD\30FC\30C8\3057\305F\30C6\30FC\30DE\306F\73FE\5728\306E\30C6\30FC\30DE\3068\4E92\63DB\6027\304C\3042\308A\307E\305B\3093\3002'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280573780629869637)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30FC\30DE\756A\53F7\304C\7121\52B9\3067\3042\308B\304B\3001\30C6\30FC\30DE\304C\73FE\5728\306EUI\30C6\30FC\30DE\3067\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279897682586869218)
,p_name=>'APEX.TIME.DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('1\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279897425334869218)
,p_name=>'APEX.TIME.HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('1\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279897754246869218)
,p_name=>'APEX.TIME.N_DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279897537378869218)
,p_name=>'APEX.TIME.N_HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279897358738869218)
,p_name=>'APEX.TIME.N_MINUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\5206')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279897919353869218)
,p_name=>'APEX.TIME.N_WEEKS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\9031\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279897832949869218)
,p_name=>'APEX.TIME.WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('1\9031\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280527111784869609)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\968E\5C64\306E\8A08\7B97\306B\5FC5\8981\306A\4E3B\30AD\30FC\5217\304A\3088\3073\89AA\30AD\30FC\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280527201338869609)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\968E\5C64\304C\8A08\7B97\3055\308C\306A\3044\5834\5408\306B\5FC5\8981\306A\30CE\30FC\30C9\30FB\30EC\30D9\30EB\5217\304A\3088\3073\30CE\30FC\30C9\30FB\30B9\30C6\30FC\30BF\30B9\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280635174391869675)
,p_name=>'APEX.UI.BACK_TO_TOP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306E\958B\59CB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279452897505868947)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30FC\30AF\30FB\30E2\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279453076288868947)
,p_name=>'APEX.UI.DISABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279452978548868947)
,p_name=>'APEX.UI.ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279892501446869215)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306B\793A\3059\30EA\30B9\30C8\304B\3089\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\3092\9078\629E\3057\3066\304F\3060\3055\3044:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279895029255869216)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0 - \30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\9078\629E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279268154131868831)
,p_name=>'APEX.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30AF\30A8\30B9\30C8\306E\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279413041969868923)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0D\5F53\306A\30A2\30AF\30BB\30B9\3067\3059(\30BB\30AD\30E5\30EA\30C6\30A3\30FB\30B0\30EB\30FC\30D7\30FB\30D1\30C3\30B1\30FC\30B8\5909\6570\304C\8A2D\5B9A\3055\308C\3066\3044\307E\305B\3093)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279413650383868923)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\691C\7D22\60C5\5831\3092\30D5\30A7\30C3\30C1\3067\304D\307E\305B\3093\3002 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279400833701868915)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC%0\306B\306F\3001\3053\306E\64CD\4F5C\3092\5B9F\884C\3059\308BADMIN\6A29\9650\304C\5FC5\8981\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279413548578868923)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC%0\306F\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3092\6307\5B9A\3057\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279369071248868895)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0D\5F53\306A\30A2\30AF\30BB\30B9\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279413491787868923)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC%0\306F\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279519320307868987)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\8A3C\51E6\7406\4E2D\306B\30A8\30E9\30FC\304C\767A\751F\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279901531810869221)
,p_name=>'APEX.VALUE_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5FC5\9808\306E\5024')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280624790190869668)
,p_name=>'APEX.WAIT_UNTIL_PAGE_LOADED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\304C\5B8C\5168\306B\30ED\30FC\30C9\3055\308C\308B\307E\3067\5F85\6A5F\3057\3066\304B\3089\518D\8A66\884C\3057\3066\304F\3060\3055\3044\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280448690858869560)
,p_name=>'APEX.WARN_ON_UNSAVED_CHANGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30DA\30FC\30B8\306B\306F\4FDD\5B58\3055\308C\3066\3044\306A\3044\5909\66F4\304C\3042\308A\307E\3059\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280528506334869610)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_language=>'ja'
,p_message_text=>unistr('Application Express\306F\30BF\30A4\30D7: %0\306E\30EC\30B9\30DD\30F3\30B9\30FB\30C7\30FC\30BF\304B\3089\30C7\30FC\30BF\30FB\30D7\30ED\30D5\30A1\30A4\30EB\3092\8A08\7B97\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279959395029869256)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279959234429869256)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280512447909869600)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\5F0F\306F\6709\52B9\306AJSON\3067\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280504196560869595)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\306F\3001Oracle REST Data Services\3067\306F\30B5\30DD\30FC\30C8\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279845896624869185)
,p_name=>'APEX.WEBSRC.HIDE_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\3057\305F\5217\3092\8868\793A\3057\306A\3044')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279938705296869244)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 200: \6210\529F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279938821477869244)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 201: \4F5C\6210\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279938278597869243)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 400: \4E0D\6B63\306A\30EA\30AF\30A8\30B9\30C8\3067\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279938049759869243)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 401: \8A8D\8A3C\306B\5931\6557\3057\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279938353434869243)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 403: \8A31\53EF\3055\308C\3066\3044\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279938104420869243)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 404: \898B\3064\304B\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279938405804869243)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 405: \30E1\30BD\30C3\30C9\306F\8A31\53EF\3055\308C\3066\3044\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279258051024868824)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 407: \30D7\30ED\30AD\30B7\8A8D\8A3C\304C\5FC5\8981\3067\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279258372523868825)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 409: \7AF6\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279258108437868824)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 412: \524D\63D0\6761\4EF6\3067\5931\6557\3057\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279258273506868824)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 428: \524D\63D0\6761\4EF6\304C\5FC5\8981\3067\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279938542516869243)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 500: \5185\90E8\30B5\30FC\30D0\30FC\30FB\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279938617321869243)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 502: \4E0D\6B63\306A\30B2\30FC\30C8\30A6\30A7\30A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280528935171869610)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 503: \30B5\30FC\30D3\30B9\4F7F\7528\4E0D\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280529088599869610)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP 504: \30B2\30FC\30C8\30A6\30A7\30A4\30FB\30BF\30A4\30E0\30A2\30A6\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280448538132869560)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30BD\30FC\30B9\306FHTTP\30A8\30E9\30FC\3092\623B\3057\307E\3057\305F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279937172094869243)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30BD\30FC\30B9\30FB\30E2\30B8\30E5\30FC\30EB\304C\898B\3064\304B\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279481478525868964)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\30BB\30EC\30AF\30BF"%0"\306F\3001\30AA\30D6\30B8\30A7\30AF\30C8\306E\914D\5217\3092\8868\3068\3057\3066\51E6\7406\3059\308B\3088\3046\306B\9078\629E\3057\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279481585446868964)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\30BB\30EC\30AF\30BF"%0"\306F\3001\30AA\30D6\30B8\30A7\30AF\30C8\3092\5358\4E00\884C\3068\3057\3066\51E6\7406\3059\308B\3088\3046\306B\9078\629E\3057\307E\305B\3093\3067\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280448485870869560)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30D7"%1"\306E\5FC5\9808Web\30BD\30FC\30B9IN\30D1\30E9\30E1\30FC\30BF"%0"\306B\5024\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280431086566869549)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30B9\30DD\30F3\30B9\672C\6587\304C\5927\304D\3059\304E\308B\305F\3081\3001\8868\793A\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279846025434869185)
,p_name=>'APEX.WEBSRC.SHOW_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\3057\305F\5217\3092\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279901418479869220)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30AC\30B7\30FCORDS REST\30B5\30FC\30D3\30B9\3067\306F\3001\5C0F\3055\3044\56FA\5B9A\30DA\30FC\30B8\30FB\30B5\30A4\30BA\3092\4F7F\7528\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279846447210869185)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306EWeb\30BD\30FC\30B9\30FB\30C7\30FC\30BF\306E\30D5\30A7\30C3\30C1\4E2D\306B\30BF\30A4\30E0\30A2\30A6\30C8\3092\8D85\3048\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279821192016869170)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\5728\306E\30ED\30FC\30AB\30EBSQL\30D5\30A3\30EB\30BF\304CREST\30B5\30FC\30D3\30B9\306B\5BFE\3057\3066\8981\6C42\3059\308B\300C\6B21\306E\30DA\30FC\30B8\300D\30EA\30AF\30A8\30B9\30C8\304C\591A\3059\304E\307E\3059\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279901368770869220)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30AC\30B7\30FCORDS REST\30B5\30FC\30D3\30B9\306E\56FA\5B9A\30DA\30FC\30B8\30FB\30B5\30A4\30BA\304C\4E0D\660E\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280552983041869625)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3''#COMPONENT_NAME#''\306B\5BFE\3057\3066\6307\5B9A\3055\308C\305F\5BFE\8A71\30B0\30EA\30C3\30C9\5217''%0''\304C\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280553134986869625)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\30ED\30C3\30AF\306E\5B9F\884C\4E2D\306B\30D7\30ED\30BB\30B9''%0''\3067''%1''\304C\767A\751F\3057\307E\3057\305F\3002\3053\306E\30A8\30E9\30FC\306F\3001\30D7\30ED\30BB\30B9\3067instead-of\30C8\30EA\30AC\30FC\3092\4F7F\7528\3057\3066\8907\5408\30D3\30E5\30FC\306BSELECT FOR UPDATE\3092\767A\884C\3057\3001\884C\3092\30ED\30C3\30AF\3059\308B\5834\5408\306B\767A\751F\3059\308B\3053\3068\304C\3042\308A\307E\3059\3002\30D7\30ED\30BB\30B9\5C5E\6027\306E\300C\884C\306E\30ED\30C3\30AF\300D\3092\300C\3044\3044\3048\300D\307E\305F\306F\300CPL/SQL\30B3\30FC\30C9\300D\306B\8A2D\5B9A\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280553068161869625)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('DML\30B3\30DE\30F3\30C9\306E\5B9F\884C\4E2D\306B\30D7\30ED\30BB\30B9''%0''\3067''%1''\304C\767A\751F\3057\307E\3057\305F\3002\3053\306E\30A8\30E9\30FC\306F\3001\5217\304C\96C6\8A08\307E\305F\306FSQL\5F0F\306B\57FA\3065\3044\3066\3044\308B\5834\5408\306B\767A\751F\3059\308B\3053\3068\304C\3042\308A\307E\3059\3002\5217\5C5E\6027\306E\300C\554F\5408\305B\306E\307F\300D\3092\300C\306F\3044\300D\306B\8A2D\5B9A\3057\3066\3001INSERT\304A\3088\3073UPDATE\6587\304B\3089\5217\3092\9664\5916\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280217156278869415)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\5217''%0''\306B\5024\304C\542B\307E\308C\3066\3044\307E\305B\3093\3002\30D7\30ED\30BB\30B9''%1''\304C\30DE\30B9\30BF\30FC\30FB\30EA\30FC\30B8\30E7\30F3\306E\5BFE\5FDC\3059\308B\30D7\30ED\30BB\30B9\306E\5F8C\306B\5B9F\884C\3055\308C\3066\3044\308B\3053\3068\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280534786704869613)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30B0\30EA\30C3\30C9''%0''\306B\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\95A2\4FC2\306B\5FC5\8981\306A\5B9A\7FA9\3055\308C\305F\30DE\30B9\30BF\30FC\5217\304C\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279890888245869214)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30B0\30EA\30C3\30C9''%0''\306B\7DE8\96C6\307E\305F\306F\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\95A2\4FC2\306B\5FC5\8981\306A\5B9A\7FA9\3055\308C\305F\4E3B\30AD\30FC\5217\304C\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280506404129869596)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7DE8\96C6\53EF\80FD\5BFE\8A71\30B0\30EA\30C3\30C9\306E\5834\5408\3001\30DA\30FC\30B8\5C5E\6027\306E\300C\9001\4FE1\6642\306B\30EA\30ED\30FC\30C9\300D\3092\300C\6210\529F\306E\307F\300D\306B\8A2D\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280506558654869596)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\5F62\5F0F\30D5\30A9\30FC\30E0\306E\5834\5408\3001\30DA\30FC\30B8\5C5E\6027\306E\300C\9001\4FE1\6642\306B\30EA\30ED\30FC\30C9\300D\3092\300C\5E38\6642\300D\306B\8A2D\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279448514563868944)
,p_name=>'APEXIR_3D'
,p_message_language=>'ja'
,p_message_text=>'3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280541888005869618)
,p_name=>'APEXIR_ACTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279669246559869078)
,p_name=>'APEXIR_ACTIONS_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279574100958869020)
,p_name=>'APEXIR_ADD'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279658845271869072)
,p_name=>'APEXIR_ADD_FUNCTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30F3\30AF\30B7\30E7\30F3\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279658786076869072)
,p_name=>'APEXIR_ADD_GROUP_BY_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\5225\306E\30B0\30EB\30FC\30D7\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279983203325869271)
,p_name=>'APEXIR_ADD_PIVOT_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\5217\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279983392112869271)
,p_name=>'APEXIR_ADD_ROW_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\5217\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280147060964869371)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279448765283868944)
,p_name=>'APEXIR_AGGREGATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\96C6\8A08')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279693219342869092)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\96C6\8A08\306F\3001\5404\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\306E\5F8C\3068\30EC\30DD\30FC\30C8\306E\6700\5F8C\306B\8868\793A\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279696348191869094)
,p_name=>'APEXIR_AGGREGATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\96C6\8A08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279574611752869020)
,p_name=>'APEXIR_AGG_AVG'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E73\5747')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279583594221869026)
,p_name=>'APEXIR_AGG_COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4EF6\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279600583749869036)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\3005\306B\30AB\30A6\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279574786059869021)
,p_name=>'APEXIR_AGG_MAX'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5927')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279574904936869021)
,p_name=>'APEXIR_AGG_MEDIAN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E1\30B8\30A2\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279574870273869021)
,p_name=>'APEXIR_AGG_MIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279575092606869021)
,p_name=>'APEXIR_AGG_MODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E2\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279574598128869020)
,p_name=>'APEXIR_AGG_SUM'
,p_message_language=>'ja'
,p_message_text=>unistr('\5408\8A08%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279576341195869022)
,p_name=>'APEXIR_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279447774322868944)
,p_name=>'APEXIR_ALL_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279298505830868850)
,p_name=>'APEXIR_ALL_ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280538361213869616)
,p_name=>'APEXIR_ALTERNATIVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4EE3\66FF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280540433933869617)
,p_name=>'APEXIR_ALTERNATIVE_DEFAULT_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\4EE3\66FF\30C7\30D5\30A9\30EB\30C8: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279534424353868996)
,p_name=>'APEXIR_AND'
,p_message_language=>'ja'
,p_message_text=>unistr('\304B\3089')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279455281926868948)
,p_name=>'APEXIR_APPLY'
,p_message_language=>'ja'
,p_message_text=>unistr('\9069\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280504312512869595)
,p_name=>'APEXIR_AREA'
,p_message_language=>'ja'
,p_message_text=>unistr('\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279419159781868926)
,p_name=>'APEXIR_ASCENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\6607\9806')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279546989008869003)
,p_name=>'APEXIR_AS_OF'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\5728\304B\3089%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280541046611869617)
,p_name=>'APEXIR_AVERAGE_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E73\5747%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280504200018869595)
,p_name=>'APEXIR_BAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\68D2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279451656839868946)
,p_name=>'APEXIR_BETWEEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\6B21\306E\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279417868782868926)
,p_name=>'APEXIR_BGCOLOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30C3\30AF\30B0\30E9\30A6\30F3\30C9\30FB\30AB\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280144007360869369)
,p_name=>'APEXIR_BLACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30E9\30C3\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279419963233868927)
,p_name=>'APEXIR_BLUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EB\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279661630310869073)
,p_name=>'APEXIR_BOTTOM'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279575996402869021)
,p_name=>'APEXIR_CALENDAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30EC\30F3\30C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279420526099868927)
,p_name=>'APEXIR_CANCEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\53D6\6D88')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279460688335868952)
,p_name=>'APEXIR_CATEGORY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30C6\30B4\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279417738014868926)
,p_name=>'APEXIR_CELL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279575836367869021)
,p_name=>'APEXIR_CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279664864870869075)
,p_name=>'APEXIR_CHART_INITIALIZING'
,p_message_language=>'ja'
,p_message_text=>unistr('\521D\671F\5316\4E2D...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280019169843869293)
,p_name=>'APEXIR_CHART_LABEL_NOT_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30E9\30D9\30EB\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280131601088869362)
,p_name=>'APEXIR_CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\5408\305B\306F\30011\30C1\30E3\30FC\30C8\5F53\305F\308A\306E\6700\5927\30C7\30FC\30BF\30FB\30DD\30A4\30F3\30C8\6570\3067\3042\308B%0\3092\8D85\3048\3066\3044\307E\3059\3002\30D5\30A3\30EB\30BF\3092\9069\7528\3057\3066\3001\30D9\30FC\30B9\554F\5408\305B\306E\30EC\30B3\30FC\30C9\6570\3092\524A\6E1B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280125683993869358)
,p_name=>'APEXIR_CHART_MAX_ROW_CNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\554F\5408\305B\306E\884C\30AB\30A6\30F3\30C8\6700\5927\5024\306F\3001\8868\793A\3055\308C\308B\884C\6570\3067\306F\306A\304F\30D9\30FC\30B9\554F\5408\305B\306E\884C\6570\3092\5236\9650\3057\307E\3059\3002\30D9\30FC\30B9\554F\5408\305B\304C\884C\30AB\30A6\30F3\30C8\6700\5927\5024%0\3092\8D85\3048\3066\3044\307E\3059\3002\30D5\30A3\30EB\30BF\3092\9069\7528\3057\3066\3001\30D9\30FC\30B9\554F\5408\305B\306E\30EC\30B3\30FC\30C9\6570\3092\524A\6E1B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279448059660868944)
,p_name=>'APEXIR_CHART_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280101467657869343)
,p_name=>'APEXIR_CHECK_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\3092\30C1\30A7\30C3\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279547339165869004)
,p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306E\30C0\30A6\30F3\30ED\30FC\30C9\5F62\5F0F\306E\9078\629E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279650013737869066)
,p_name=>'APEXIR_CLEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30EA\30A2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279420480101868927)
,p_name=>'APEXIR_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279693386254869092)
,p_name=>'APEXIR_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280520562910869605)
,p_name=>'APEXIR_COLUMN_FILTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279659785118869072)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\30D8\30C3\30C0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279653731139869069)
,p_name=>'APEXIR_COLUMN_HEADING_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\30D8\30C3\30C0\30FC\30FB\30E1\30CB\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279664689780869075)
,p_name=>'APEXIR_COLUMN_INFO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\60C5\5831')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280530701766869611)
,p_name=>'APEXIR_COLUMN_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\30E9\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279659465501869072)
,p_name=>'APEXIR_COLUMN_N'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279528724123868993)
,p_name=>'APEXIR_COMPARISON_CONTAINS'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\6B21\3092\542B\3080')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279533478389868995)
,p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\6B21\3092\542B\307E\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279418877497868926)
,p_name=>'APEXIR_COMPARISON_IN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306B\542B\307E\308C\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279533644381868995)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\904E\53BB\306E\6B21\306E\671F\9593\5916')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279579019656869023)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\4ECA\5F8C\306E\6B21\306E\671F\9593\5916')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279533506177868995)
,p_name=>'APEXIR_COMPARISON_IS_IN_LAST'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\904E\53BB\306E\6B21\306E\671F\9593\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279578925241869023)
,p_name=>'APEXIR_COMPARISON_IS_IN_NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\4ECA\5F8C\306E\6B21\306E\671F\9593\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279418757682868926)
,p_name=>'APEXIR_COMPARISON_IS_NOT_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('NULL\3067\306F\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279418639473868926)
,p_name=>'APEXIR_COMPARISON_IS_NULL'
,p_message_language=>'ja'
,p_message_text=>'NULL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279418453694868926)
,p_name=>'APEXIR_COMPARISON_LIKE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3068\985E\4F3C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279418921303868926)
,p_name=>'APEXIR_COMPARISON_NOT_IN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306B\542B\307E\308C\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279418551853868926)
,p_name=>'APEXIR_COMPARISON_NOT_LIKE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3068\985E\4F3C\3067\306F\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279529466672868993)
,p_name=>'APEXIR_COMPARISON_REGEXP_LIKE'
,p_message_language=>'ja'
,p_message_text=>unistr('\304C\6B21\306E\6B63\898F\8868\73FE\3068\4E00\81F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279547226986869004)
,p_name=>'APEXIR_COMPUTATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280125207744869358)
,p_name=>'APEXIR_COMPUTATION_EXPRESSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279693648911869093)
,p_name=>'APEXIR_COMPUTATION_FOOTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\306E\5225\540D\3092\4F7F\7528\3057\3066\8A08\7B97\3092\4F5C\6210\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279693794673869093)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E1'
,p_message_language=>'ja'
,p_message_text=>'(B+C)*100'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279693807431869093)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E2'
,p_message_language=>'ja'
,p_message_text=>'INITCAP(B)||'', ''||INITCAP(C)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279693939318869093)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E3'
,p_message_language=>'ja'
,p_message_text=>'CASE WHEN A = 10 THEN B + C ELSE B END'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279285868242868842)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E4'
,p_message_language=>'ja'
,p_message_text=>'ROUND(C / 1000000)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279577089787869022)
,p_name=>'APEXIR_COMPUTE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279660484925869073)
,p_name=>'APEXIR_CONTROL_BREAK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279668617296869078)
,p_name=>'APEXIR_CONTROL_BREAKS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280549185532869622)
,p_name=>'APEXIR_CONTROL_BREAK_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30FC\30AF\5217\306E\5236\5FA1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279278034450868837)
,p_name=>'APEXIR_COUNT_DISTINCT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\3005\306B\30AB\30A6\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280541533736869618)
,p_name=>'APEXIR_COUNT_DISTINCT_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\3005\306B\30AB\30A6\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280541467220869618)
,p_name=>'APEXIR_COUNT_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30A6\30F3\30C8%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280144593121869369)
,p_name=>'APEXIR_DAILY'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280634045647869674)
,p_name=>'APEXIR_DATA'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279664789528869075)
,p_name=>'APEXIR_DATA_AS_OF'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\5206\524D\306E\30C7\30FC\30BF\3092\30EC\30DD\30FC\30C8\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280495867114869590)
,p_name=>'APEXIR_DATA_GRID_HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\30FB\30D8\30EB\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279448914733868944)
,p_name=>'APEXIR_DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5\4ED8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280540023683869617)
,p_name=>'APEXIR_DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279690933025869091)
,p_name=>'APEXIR_DEFAULT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280538110681869616)
,p_name=>'APEXIR_DEFAULT_REPORT_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\306E\30EC\30DD\30FC\30C8\30FB\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279420620457868927)
,p_name=>'APEXIR_DELETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279577856448869022)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30A7\30C3\30AF\3057\305F\9805\76EE\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279449833320868945)
,p_name=>'APEXIR_DELETE_CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\308C\3089\306E\30EC\30DD\30FC\30C8\8A2D\5B9A\3092\524A\9664\3057\307E\3059\304B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279695192164869094)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\524A\9664\64CD\4F5C\3092\5B9F\884C\3057\307E\3059\304B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280428829363869548)
,p_name=>'APEXIR_DELETE_DEFAULT_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\30FB\30EC\30DD\30FC\30C8\306E\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279660164256869072)
,p_name=>'APEXIR_DELETE_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306E\524A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279419284240868926)
,p_name=>'APEXIR_DESCENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\964D\9806')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279460773718868952)
,p_name=>'APEXIR_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8AAC\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279653614788869069)
,p_name=>'APEXIR_DETAIL_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\5358\4E00\884C\30D3\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279691906042869092)
,p_name=>'APEXIR_DIRECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\65B9\5411%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279669156887869078)
,p_name=>'APEXIR_DISABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279693107314869092)
,p_name=>'APEXIR_DISABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279449058005868944)
,p_name=>'APEXIR_DISPLAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279420127345868927)
,p_name=>'APEXIR_DISPLAYED'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279447655716868944)
,p_name=>'APEXIR_DISPLAYED_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279691850454869092)
,p_name=>'APEXIR_DISPLAY_IN_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306B\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279420861755868927)
,p_name=>'APEXIR_DONUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C9\30FC\30CA\30C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279661592239869073)
,p_name=>'APEXIR_DOWN'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0B\3078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279577184687869022)
,p_name=>'APEXIR_DOWNLOAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A6\30F3\30ED\30FC\30C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279448859320868944)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_language=>'ja'
,p_message_text=>unistr('- \96C6\8A08\3057\306A\3044 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279691746425869091)
,p_name=>'APEXIR_DO_NOT_DISPLAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\3057\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280549321941869622)
,p_name=>'APEXIR_DUPLICATE_PIVOT_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\5217\304C\91CD\8907\3057\3066\3044\307E\3059\3002\30D4\30DC\30C3\30C8\5217\30EA\30B9\30C8\306F\4E00\610F\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280549775717869623)
,p_name=>'APEXIR_EDIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280488412042869585)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4EE3\66FF\30C7\30D5\30A9\30EB\30C8\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279664930951869075)
,p_name=>'APEXIR_EDIT_CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\8A2D\5B9A\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279694951283869093)
,p_name=>'APEXIR_EDIT_CHART2'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279695402262869094)
,p_name=>'APEXIR_EDIT_FILTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280191307936869398)
,p_name=>'APEXIR_EDIT_GROUP_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279695388461869094)
,p_name=>'APEXIR_EDIT_HIGHLIGHT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280008014954869286)
,p_name=>'APEXIR_EDIT_PIVOT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280538462081869616)
,p_name=>'APEXIR_EMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279363727783868891)
,p_name=>'APEXIR_EMAIL_ADDRESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280538703680869616)
,p_name=>'APEXIR_EMAIL_BCC'
,p_message_language=>'ja'
,p_message_text=>'BCC'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280538968116869616)
,p_name=>'APEXIR_EMAIL_BODY'
,p_message_language=>'ja'
,p_message_text=>unistr('\672C\6587')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280538602968869616)
,p_name=>'APEXIR_EMAIL_CC'
,p_message_language=>'ja'
,p_message_text=>'CC'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280539607799869616)
,p_name=>'APEXIR_EMAIL_FREQUENCY'
,p_message_language=>'ja'
,p_message_text=>unistr('\983B\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279398536368868913)
,p_name=>'APEXIR_EMAIL_NOT_CONFIGURED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\306F\96FB\5B50\30E1\30FC\30EB\304C\69CB\6210\3055\308C\3066\3044\307E\305B\3093\3002\7BA1\7406\8005\306B\9023\7D61\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280143688052869369)
,p_name=>'APEXIR_EMAIL_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\300D\306B\5024\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280539083256869616)
,p_name=>'APEXIR_EMAIL_SEE_ATTACHED'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\3092\53C2\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280538802001869616)
,p_name=>'APEXIR_EMAIL_SUBJECT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4EF6\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280145591175869370)
,p_name=>'APEXIR_EMAIL_SUBJECT_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\96FB\5B50\30E1\30FC\30EB\306E\4EF6\540D\300D\306B\5024\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280538541408869616)
,p_name=>'APEXIR_EMAIL_TO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9B\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279669034350869078)
,p_name=>'APEXIR_ENABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279417559695868925)
,p_name=>'APEXIR_ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279695273664869094)
,p_name=>'APEXIR_ENABLE_DISABLE_ALT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9/\7121\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279694606015869093)
,p_name=>'APEXIR_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279694084080869093)
,p_name=>'APEXIR_EXAMPLES'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F8B')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279695080642869093)
,p_name=>'APEXIR_EXAMPLES_WITH_COLON'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F8B:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279447576980868943)
,p_name=>'APEXIR_EXCLUDE_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('NULL\5024\306E\9664\5916')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279695917597869094)
,p_name=>'APEXIR_EXPAND_COLLAPSE_ALT'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\304F/\9589\3058\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279692807524869092)
,p_name=>'APEXIR_EXPRESSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279576644236869022)
,p_name=>'APEXIR_FILTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279668549353869077)
,p_name=>'APEXIR_FILTERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279753004318869129)
,p_name=>'APEXIR_FILTER_EXPRESSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280615955505869663)
,p_name=>'APEXIR_FILTER_EXPR_TOO_LONG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\5F0F\304C\9577\3059\304E\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279752916690869129)
,p_name=>'APEXIR_FILTER_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\30FB\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279696121837869094)
,p_name=>'APEXIR_FINDER_ALT'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\5217\306E\9078\629E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279576965269869022)
,p_name=>'APEXIR_FLASHBACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279692549874869092)
,p_name=>'APEXIR_FLASHBACK_DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF\554F\5408\305B\3092\4F7F\7528\3059\308B\3068\3001\3042\308B\6642\70B9\3067\5B58\5728\3057\3066\3044\305F\30C7\30FC\30BF\3092\8868\793A\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279694451521869093)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF\30FB\30EA\30AF\30A8\30B9\30C8\3092\5B9F\884C\3067\304D\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280144253490869369)
,p_name=>'APEXIR_FLASHBACK_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280152879027869375)
,p_name=>'APEXIR_FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F8\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279547110752869004)
,p_name=>'APEXIR_FORMAT_MASK'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F8\5F0F\30DE\30B9\30AF%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279659880976869072)
,p_name=>'APEXIR_FUNCTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30F3\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279693572140869093)
,p_name=>'APEXIR_FUNCTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30F3\30AF\30B7\30E7\30F3%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280538026867869615)
,p_name=>'APEXIR_FUNCTIONS_OPERATORS'
,p_message_language=>'ja'
,p_message_text=>unistr('\95A2\6570/\6F14\7B97\5B50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280125769570869358)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30F3\30AF\30B7\30E7\30F3\5217%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279659324719869072)
,p_name=>'APEXIR_FUNCTION_N'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30F3\30AF\30B7\30E7\30F3%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279576434885869022)
,p_name=>'APEXIR_GO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9F\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280144167265869369)
,p_name=>'APEXIR_GRAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EC\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279418049653868926)
,p_name=>'APEXIR_GREEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EA\30FC\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279278184292868837)
,p_name=>'APEXIR_GROUP_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280539196377869616)
,p_name=>'APEXIR_GROUP_BY_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('GROUP BY\5217%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280019205395869293)
,p_name=>'APEXIR_GROUP_BY_COL_NOT_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316\5217\304C\6307\5B9A\3055\308C\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280125597401869358)
,p_name=>'APEXIR_GROUP_BY_MAX_ROW_CNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316\554F\5408\305B\306E\884C\30AB\30A6\30F3\30C8\6700\5927\5024\306F\3001\8868\793A\3055\308C\308B\884C\6570\3067\306F\306A\304F\30D9\30FC\30B9\554F\5408\305B\306E\884C\6570\3092\5236\9650\3057\307E\3059\3002\30D9\30FC\30B9\554F\5408\305B\304C\884C\30AB\30A6\30F3\30C8\6700\5927\5024%0\3092\8D85\3048\3066\3044\307E\3059\3002\30D5\30A3\30EB\30BF\3092\9069\7528\3057\3066\3001\30D9\30FC\30B9\554F\5408\305B\306E\30EC\30B3\30FC\30C9\6570\3092\524A\6E1B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279939674403869244)
,p_name=>'APEXIR_GROUP_BY_SORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8\5225\306E\30B0\30EB\30FC\30D7\5316')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280549295977869622)
,p_name=>'APEXIR_GROUP_BY_SORT_ORDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8\9806\306B\3088\308B\30B0\30EB\30FC\30D7\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279448137666868944)
,p_name=>'APEXIR_HCOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6C34\5E73\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279686321283869088)
,p_name=>'APEXIR_HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D8\30EB\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279651987130869068)
,p_name=>'APEXIR_HELP_01'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306F\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\4F7F\7528\3057\3066\3001\30EC\30DD\30FC\30C8\3092\30AB\30B9\30BF\30DE\30A4\30BA\3067\304D\307E\3059\3002\30E6\30FC\30B6\30FC\306F\3001\5217\306E\9078\629E\3001\30D5\30A3\30EB\30BF\306E\9069\7528\3001\30CF\30A4\30E9\30A4\30C8\307E\305F\306F\30BD\30FC\30C8\3092\884C\3063\3066\3001\30EC\30DD\30FC\30C8\30FB\30C7\30FC\30BF\306E\30EC\30A4\30A2\30A6\30C8\3092\5909\66F4\3067\304D\307E\3059\3002\307E\305F\3001\30D6\30EC\30FC\30AF\3001\96C6\8A08\3001\30C1\30E3\30FC\30C8\3001\30B0\30EB\30FC\30D7\5316\3092\5B9A\7FA9\3057\3001\72EC\81EA\306E\8A08\7B97\3092\8FFD\52A0\3067\304D\307E\3059\3002\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3\3092\8A2D\5B9A\3057\3066\3001HTML\30D0\30FC\30B8\30E7\30F3\306E\30EC\30DD\30FC\30C8\3092\6307\5B9A\3057\305F\9593\9694\3067\96FB\5B50\30E1\30FC\30EB\9001\4FE1\3059\308B\3088\3046\306B\3082\8A2D\5B9A\3067\304D\307E\3059\3002\30E6\30FC\30B6\30FC\306F\30EC\30DD\30FC\30C8\306E\8907\6570\306E\30D0\30EA\30A8\30FC\30B7\30E7\30F3\3092\4F5C\6210\3057\3001\30D1\30D6\30EA\30C3\30AF\307E\305F\306F\30D7\30E9\30A4\30D9\30FC\30C8\306E\53C2\7167\7528\306B\540D\524D\4ED8\304D\30EC\30DD\30FC\30C8\3068\3057\3066')
||unistr('\4FDD\5B58\3067\304D\307E\3059\3002'),
'<p/>',
unistr('\4EE5\964D\306E\9805\306B\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306E\30AB\30B9\30BF\30DE\30A4\30BA\65B9\6CD5\3092\8981\7D04\3057\307E\3059\3002\8A73\7D30\306F\3001<i>\300EOracle Application Express\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\30FB\30AC\30A4\30C9\300F</i></a>\306E\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306E\4F7F\7528\306B\95A2\3059\308B\9805\3092\53C2\7167\3057\3066\304F\3060\3055\3044\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279669391858869078)
,p_name=>'APEXIR_HELP_ACTIONS_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306F\691C\7D22\30D0\30FC\306E\300C\5B9F\884C\300D\30DC\30BF\30F3\306E\53F3\5074\306B\8868\793A\3055\308C\307E\3059\3002\3053\306E\30E1\30CB\30E5\30FC\3092\4F7F\7528\3057\3066\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\30AB\30B9\30BF\30DE\30A4\30BA\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279652946596869068)
,p_name=>'APEXIR_HELP_AGGREGATE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\96C6\8A08\306F\30011\3064\306E\4F8B\306B\5BFE\3057\3066\5B9F\884C\3055\308C\308B\6570\5B66\7684\8A08\7B97\3067\3059\3002\96C6\8A08\306F\3001\5404\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\306E\5F8C\3068\30EC\30DD\30FC\30C8\306E\6700\5F8C\306B\3001\96C6\8A08\3092\5B9A\7FA9\3057\305F\5217\5185\3067\8868\793A\3055\308C\307E\3059\3002\30AA\30D7\30B7\30E7\30F3\306F\6B21\306E\3068\304A\308A\3067\3059\3002'),
'<p>',
'</p><ul>',
unistr('<li><b>\300C\96C6\8A08\300D</b>\3067\306F\3001\4EE5\524D\306B\5B9A\7FA9\3057\305F\96C6\8A08\3092\9078\629E\3057\3066\7DE8\96C6\3067\304D\307E\3059\3002</li>'),
unistr('<li><b>\300C\30D5\30A1\30F3\30AF\30B7\30E7\30F3\300D</b>\306F\3001\5B9F\884C\3055\308C\308B\95A2\6570(SUM\3001MIN\306A\3069)\3067\3059\3002</li>'),
unistr('<li><b>\300C\5217\300D</b>\3092\4F7F\7528\3057\3066\3001\6570\5B66\95A2\6570\3092\9069\7528\3059\308B\5BFE\8C61\306E\5217\3092\9078\629E\3057\307E\3059\3002\6570\5024\306E\5217\306E\307F\304C\8868\793A\3055\308C\307E\3059\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279653038270869068)
,p_name=>'APEXIR_HELP_CHART'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4FDD\5B58\3057\305F\30EC\30DD\30FC\30C8\3054\3068\306B\30011\3064\306E\30C1\30E3\30FC\30C8\3092\5B9A\7FA9\3067\304D\307E\3059\3002'),
unistr('\30C1\30E3\30FC\30C8\3092\5B9A\7FA9\3059\308B\3068\3001\691C\7D22\30D0\30FC\306E\30D3\30E5\30FC\30FB\30A2\30A4\30B3\30F3\3092\4F7F\7528\3057\3066\30C1\30E3\30FC\30C8\3068\30EC\30DD\30FC\30C8\306E\8868\793A\3092\5207\308A\66FF\3048\308B\3053\3068\304C\3067\304D\307E\3059\3002'),
unistr('\30AA\30D7\30B7\30E7\30F3\306F\6B21\306E\3068\304A\308A\3067\3059\3002'),
'<p>',
'</p><ul>',
unistr('<li><b>\300C\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7\300D</b>\3067\3001\542B\3081\308B\30C1\30E3\30FC\30C8\306E\30BF\30A4\30D7\3092\6307\5B9A\3057\307E\3059\3002'),
unistr('\6A2A\68D2\3001\7E26\68D2\3001\5186\3001\6298\308C\7DDA\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
unistr('<li><b>\300C\30E9\30D9\30EB\300D</b>\3067\3001\30E9\30D9\30EB\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\9078\629E\3067\304D\307E\3059\3002</li>'),
unistr('<li><b>\300C\30E9\30D9\30EB\306E\8EF8\30BF\30A4\30C8\30EB\300D</b>\306F\3001\300C\30E9\30D9\30EB\300D\3067\9078\629E\3057\305F\5217\306B\5BFE\5FDC\3059\308B\8EF8\4E0A\306B\8868\793A\3055\308C\308B\30BF\30A4\30C8\30EB\3067\3059\3002'),
unistr('\5186\30B0\30E9\30D5\3067\306F\4F7F\7528\3067\304D\307E\305B\3093\3002</li>'),
unistr('<li><b>\300C\5024\300D</b>\3067\3001\5024\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\9078\629E\3067\304D\307E\3059\3002COUNT\95A2\6570\3092'),
unistr('\4F7F\7528\3059\308B\5834\5408\3001\300C\5024\300D\3092\9078\629E\3059\308B\5FC5\8981\306F\3042\308A\307E\305B\3093\3002</li>'),
unistr('<li><b>\300C\5024\306E\8EF8\30BF\30A4\30C8\30EB\300D</b>\306F\3001\300C\5024\300D\3067\9078\629E\3057\305F\5217\306B\5BFE\5FDC\3059\308B\8EF8\4E0A\306B\8868\793A\3055\308C\308B\30BF\30A4\30C8\30EB\3067\3059\3002'),
unistr('\5186\30B0\30E9\30D5\3067\306F\4F7F\7528\3067\304D\307E\305B\3093\3002</li>'),
unistr('<li><b>\300C\30D5\30A1\30F3\30AF\30B7\30E7\30F3\300D</b>\306F\3001\300C\5024\300D\3067\9078\629E\3057\305F\5217\306B\5BFE\3057\3066\5B9F\884C\3055\308C\308B\30AA\30D7\30B7\30E7\30F3\306E\95A2\6570\3067\3059\3002</li>'),
unistr('<li><b>\300C\30BD\30FC\30C8\300D</b>\3067\3001\7D50\679C\30BB\30C3\30C8\3092\30BD\30FC\30C8\3067\304D\307E\3059\3002</li></ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279652365862869068)
,p_name=>'APEXIR_HELP_COLUMN_HEADING_MENU'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4EFB\610F\306E\5217\30D8\30C3\30C0\30FC\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5217\30D8\30C3\30C0\30FC\30FB\30E1\30CB\30E5\30FC\304C\958B\304D\307E\3059\3002'),
unistr('\30AA\30D7\30B7\30E7\30F3\306F\6B21\306E\3068\304A\308A\3067\3059\3002<p></p>'),
unistr('<ul><li><b>\300C\6607\9806\30BD\30FC\30C8\300D\30A2\30A4\30B3\30F3</b>\3067\3001\5217\3092\57FA\6E96\306B\3057\3066\30EC\30DD\30FC\30C8\3092\6607\9806\306B\30BD\30FC\30C8\3057\307E\3059\3002</li>'),
unistr('<li><b>\300C\964D\9806\30BD\30FC\30C8\300D\30A2\30A4\30B3\30F3</b>\3067\3001\5217\3092\57FA\6E96\306B\3057\3066\30EC\30DD\30FC\30C8\3092\964D\9806\306B\30BD\30FC\30C8\3057\307E\3059\3002</li>'),
unistr('<li><b>\300C\5217\306E\975E\8868\793A\300D</b>\3067\3001\5217\3092\975E\8868\793A\306B\3057\307E\3059\3002\3059\3079\3066\306E\5217\3092\975E\8868\793A\306B\3067\304D\308B\3068\306F\304B\304E\308A\307E\305B\3093\3002\5217\3092\975E\8868\793A\306B\3067\304D\306A\3044\5834\5408\3001\300C\5217\306E\975E\8868\793A\300D\30A2\30A4\30B3\30F3\306F\8868\793A\3055\308C\307E\305B\3093\3002</li>'),
unistr('<li><b>\300C\30D6\30EC\30FC\30AF\5217\300D</b>\3067\3001\5217\306B\30D6\30EC\30FC\30AF\30FB\30B0\30EB\30FC\30D7\3092\4F5C\6210\3057\307E\3059\3002\30EC\30DD\30FC\30C8\304B\3089\3001\5217\304C\30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9\3068\3057\3066\62BD\51FA\3055\308C\307E\3059\3002</li>'),
unistr('<li><b>\300C\5217\60C5\5831\300D</b>\3067\3001\5217\306B\95A2\3059\308B\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8(\5229\7528\53EF\80FD\306A\5834\5408)\3092\8868\793A\3057\307E\3059\3002</li>'),
unistr('<li><b>\30C6\30AD\30B9\30C8\30FB\30A8\30EA\30A2</b>\3067\306F\3001\5927/\5C0F\6587\5B57\3092\533A\5225\3057\306A\3044\691C\7D22\57FA\6E96\3092\5165\529B\3057\307E\3059(\30EF\30A4\30EB\30C9\30AB\30FC\30C9\306F\4E0D\8981)\3002\5024\3092\5165\529B\3059\308B\3068\3001\30E1\30CB\30E5\30FC\4E0B\90E8\306ELOV\304C\7E2E\5C0F\3055\308C\307E\3059\3002\4E0B\90E8\304B\3089\5024\3092\9078\629E\3059\308B\3068\3001\9078\629E\3057\305F\5024\304C\300C=\300D\3092\4F7F\7528\3057\3066\30D5\30A3\30EB\30BF\3068\3057\3066\4F5C\6210\3055\308C\307E\3059(\4F8B: <code>column = ''ABC''</code>)\3002\3042\308B\3044\306F\3001\61D0\4E2D\96FB\706F\30A2\30A4\30B3\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5165\529B\3057\305F\5024\304C\300CLIKE\300D\4FEE\98FE\5B50\3092\4F7F\7528\3057\3066\30D5\30A3\30EB\30BF\3068\3057\3066\4F5C\6210\3055\308C\307E\3059(\4F8B: <code>column LIKE ''%ABC%''</code>)\3002</l')
||'i>',
unistr('<li><b>\4E00\610F\306ELOV</b>\306B\306F\3001\30D5\30A3\30EB\30BF\306B\4E00\81F4\3059\308B\4E00\610F\306E\5024\306E\3046\3061\6700\521D\306E500\4EF6\304C\8868\793A\3055\308C\307E\3059\3002\5217\304C\65E5\4ED8\306E\5834\5408\306F\3001\304B\308F\308A\306B\65E5\4ED8\7BC4\56F2\306E\30EA\30B9\30C8\304C\8868\793A\3055\308C\307E\3059\3002\5024\3092\9078\629E\3059\308B\3068\3001\300C=\300D\3092\4F7F\7528\3057\3066\30D5\30A3\30EB\30BF\304C\4F5C\6210\3055\308C\307E\3059(\4F8B: <code>column = ''ABC''</code>)\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279652847486869068)
,p_name=>'APEXIR_HELP_COMPUTE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\30EC\30DD\30FC\30C8\306B\8A08\7B97\7D50\679C\306E\5217\3092\8FFD\52A0\3067\304D\307E\3059\3002\6570\5B66\7684\8A08\7B97(\4F8B: <code>NBR_HOURS/24</code>)\3084\3001\65E2\5B58\306E\5217\306B\9069\7528\3055\308C\308BOracle\6A19\6E96\306E\95A2\6570\3092\4F7F\7528\3067\304D\307E\3059\3002\4E00\90E8\306F\4F8B\304A\3088\3073\305D\306E\4ED6\3068\3057\3066\8868\793A\3055\308C\3066\3044\307E\3059(<code>TO_DATE</code>\306A\3069\3082\4F7F\7528\3067\304D\307E\3059)\3002\30AA\30D7\30B7\30E7\30F3\306F\6B21\306E\3068\304A\308A\3067\3059\3002'),
'<p></p>',
'<ul>',
unistr('<li><b>\300C\8A08\7B97\300D</b>\3067\306F\3001\4EE5\524D\306B\5B9A\7FA9\3057\305F\8A08\7B97\3092\9078\629E\3057\3066\7DE8\96C6\3067\304D\307E\3059\3002</li>'),
unistr('<li><b>\300C\5217\30D8\30C3\30C0\30FC\300D</b>\306F\3001\65B0\3057\3044\5217\306E\5217\30D8\30C3\30C0\30FC\3067\3059\3002</li>'),
unistr('<li><b>\300C\66F8\5F0F\30DE\30B9\30AF\300D</b>\306F\3001\5217\306B\9069\7528\3059\308BOracle\66F8\5F0F\30DE\30B9\30AF(\4F8B: S9999)\3067\3059\3002</li>'),
unistr('<li><b>\300C\8A08\7B97\300D</b>\306F\3001\5B9F\884C\3055\308C\308B\8A08\7B97\3067\3059\3002\8A08\7B97\306E\969B\3001\5217\306F\8868\793A\3055\308C\3066\3044\308B\5225\540D\3067\53C2\7167\3055\308C\307E\3059\3002</li>'),
'</ul>',
unistr('<p>\8A08\7B97\306E\4E0B\306B\306F\3001\554F\5408\305B\306E\5217\3068\305D\308C\306B\5BFE\5FDC\3059\308B\5225\540D\304C\8868\793A\3055\308C\307E\3059\3002\5217\540D\307E\305F\306F\5225\540D\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\300C\8A08\7B97\300D\306B\66F8\304D\8FBC\307E\308C\307E\3059\3002\5217\306E\3068\306A\308A\306B\30AD\30FC\30D1\30C3\30C9\304C\3042\308A\307E\3059\3002\3053\308C\306F\3001\983B\7E41\306B\4F7F\7528\3055\308C\308B\30AD\30FC\306E\30B7\30E7\30FC\30C8\30AB\30C3\30C8\3067\3059\3002\53F3\7AEF\306B\95A2\6570\304C\3042\308A\307E\3059\3002</p>'),
unistr('<p>\7D66\4E0E\5408\8A08\3092\8868\793A\3059\308B\8A08\7B97\306E\4F8B\306F\3001\6B21\306E\3088\3046\306B\306A\308A\307E\3059\3002</p>'),
'<pre>CASE WHEN A = ''SALES'' THEN B + C ELSE B END</pre>',
unistr('(A\306FORGANIZATION\3001B\306FSALARY\3001C\306FCOMMISSION)</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279669408581869078)
,p_name=>'APEXIR_HELP_CONTROL_BREAK'
,p_message_language=>'ja'
,p_message_text=>unistr('1\3064\307E\305F\306F\8907\6570\306E\5217\306B\30D6\30EC\30FC\30AF\30FB\30B0\30EB\30FC\30D7\3092\4F5C\6210\3057\307E\3059\3002\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\304B\3089\5217\304C\62BD\51FA\3055\308C\3001\30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9\3068\3057\3066\8868\793A\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279653503122869068)
,p_name=>'APEXIR_HELP_DETAIL_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\5358\4E00\884C\30D3\30E5\30FC\306E\8A73\7D30\3092\4E00\5EA6\306B\8868\793A\3059\308B\306B\306F\3001\8868\793A\3057\305F\3044\884C\3067\5358\4E00\884C\30D3\30E5\30FC\306E\8868\793A\30A2\30A4\30B3\30F3\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002\4F7F\7528\53EF\80FD\306A\5834\5408\3001\5358\4E00\884C\30D3\30E5\30FC\306F\5E38\306B\6700\521D\306E\5217\306B\306A\308A\307E\3059\3002\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306E\30AB\30B9\30BF\30DE\30A4\30BA\5185\5BB9\306B\3088\3063\3066\3001\5358\4E00\884C\30D3\30E5\30FC\306F\6A19\6E96\30D3\30E5\30FC\3067\3042\308B\5834\5408\3082\3001\66F4\65B0\53EF\80FD\306A\30AB\30B9\30BF\30E0\30FB\30DA\30FC\30B8\3067\3042\308B\5834\5408\3082\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279653405162869068)
,p_name=>'APEXIR_HELP_DOWNLOAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\5728\306E\7D50\679C\30BB\30C3\30C8\306E\30C0\30A6\30F3\30ED\30FC\30C9\3092\8A31\53EF\3057\307E\3059\3002\30C0\30A6\30F3\30ED\30FC\30C9\5F62\5F0F\306F\3001\30A4\30F3\30B9\30C8\30FC\30EB\74B0\5883\3068\30EC\30DD\30FC\30C8\5B9A\7FA9\306B\3088\3063\3066\7570\306A\308A\307E\3059\304C\3001CSV\3001HTML\3001\96FB\5B50\30E1\30FC\30EB\3001XLS\3001PDF\307E\305F\306FRTF\304C\4F7F\7528\53EF\80FD\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279652581020869068)
,p_name=>'APEXIR_HELP_FILTER'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\554F\5408\305B\3067<code>WHERE</code>\53E5\306E\8FFD\52A0\307E\305F\306F\5909\66F4\306B\3088\3063\3066\30EC\30DD\30FC\30C8\3092\30D5\30A9\30FC\30AB\30B9\3057\307E\3059\3002\5217\307E\305F\306F\884C\3067\30D5\30A3\30EB\30BF\3067\304D\307E\3059\3002'),
unistr('<p>\5217\3067\30D5\30A3\30EB\30BF\3059\308B\5834\5408\3001\307E\305A\5217\3092\9078\629E\3057(\8868\793A\3055\308C\3066\3044\308B\5217\3067\306A\304F\3068\3082\3088\3044)\3001Oracle\6A19\6E96\306E\6F14\7B97\5B50(=\3001!=\3001not in\3001between)\3092\9078\629E\3057\3066\3001\6BD4\8F03\5BFE\8C61\306E\5F0F\3092\5165\529B\3057\307E\3059\3002\5F0F\3067\306F\5927/\5C0F\6587\5B57\304C\533A\5225\3055\308C\3001\30EF\30A4\30EB\30C9\30AB\30FC\30C9\3068\3057\3066%\3092\4F7F\7528\3067\304D\307E\3059(\4F8B: <code>STATE_NAME like A%)</code>\3002</p>'),
unistr('<p>\884C\3067\30D5\30A3\30EB\30BF\3059\308B\5834\5408\3001\5217\5225\540D\304A\3088\3073\4EFB\610F\306EOracle\95A2\6570\3084\6F14\7B97\5B50(<code>G = ''VA''\307E\305F\306FG = ''CT''</code>\306A\3069\3002<code>G</code>\306F<code>CUSTOMER_STATE</code>\306E\5225\540D)\3092\4F7F\7528\3057\3066\3001\8907\96D1\306A<code>WHERE</code>\53E5\3092\4F5C\6210\3067\304D\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279653136629869068)
,p_name=>'APEXIR_HELP_FLASHBACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF\554F\5408\305B\306B\3088\3063\3066\3001\3042\308B\6642\70B9\3067\5B58\5728\3057\3066\3044\305F\30C7\30FC\30BF\3092\8868\793A\3067\304D\307E\3059\3002\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF\53EF\80FD\306A\6642\9593\306E\30C7\30D5\30A9\30EB\30C8\306F3\6642\9593(180\5206)\3067\3059\304C\3001\5B9F\969B\306E\6642\9593\306F\30C7\30FC\30BF\30D9\30FC\30B9\3054\3068\306B\7570\306A\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280152702437869374)
,p_name=>'APEXIR_HELP_FORMAT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\300C\66F8\5F0F\300D\3092\4F7F\7528\3059\308B\3068\30EC\30DD\30FC\30C8\306E\8868\793A\3092\30AB\30B9\30BF\30DE\30A4\30BA\3067\304D\307E\3059\3002'),
unistr('\300C\66F8\5F0F\300D\306B\306F\6B21\306E\30B5\30D6\30E1\30CB\30E5\30FC\304C\3042\308A\307E\3059\3002</p>'),
unistr('<ul><li>\30BD\30FC\30C8</li>'),
unistr('<li>\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF</li>'),
unistr('<li>\30CF\30A4\30E9\30A4\30C8</li>'),
unistr('<li>\8A08\7B97</li>'),
unistr('<li>\96C6\8A08</li>'),
unistr('<li>\30C1\30E3\30FC\30C8</li>'),
unistr('<li>\30B0\30EB\30FC\30D7\5316</li>'),
unistr('<li>\30D4\30DC\30C3\30C8</li>'),
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280143496706869369)
,p_name=>'APEXIR_HELP_GROUP_BY'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4FDD\5B58\3057\305F\30EC\30DD\30FC\30C8\3054\3068\306B1\3064\306E\30B0\30EB\30FC\30D7\5316\30D3\30E5\30FC\3092\5B9A\7FA9\3067\304D\307E\3059\3002'),
unistr('\5B9A\7FA9\3059\308B\3068\3001\691C\7D22\30D0\30FC\306E\30D3\30E5\30FC\30FB\30A2\30A4\30B3\30F3\3092\4F7F\7528\3057\3066\3001\30B0\30EB\30FC\30D7\5316\30D3\30E5\30FC\3068'),
unistr('\30EC\30DD\30FC\30C8\30FB\30D3\30E5\30FC\3092\5207\308A\66FF\3048\3067\304D\307E\3059\3002\30B0\30EB\30FC\30D7\5316\30D3\30E5\30FC\3092\4F5C\6210\3059\308B\306B\306F\3001'),
unistr('\6B21\306E\9078\629E\3092\3057\307E\3059\3002'),
'<p></p><ul>',
unistr('<li>\30B0\30EB\30FC\30D7\5316\3059\308B\5217</li>'),
unistr('<li>\96C6\8A08\3059\308B\5217\3068\5B9F\884C\3059\308B\95A2\6570(average\3001sum\3001count\306A\3069)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279652797043869068)
,p_name=>'APEXIR_HELP_HIGHLIGHT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30D5\30A3\30EB\30BF\3092\5B9A\7FA9\3067\304D\307E\3059\3002\30D5\30A3\30EB\30BF\57FA\6E96\306B\4E00\81F4\3057\305F\884C\306F\3001\30D5\30A3\30EB\30BF\306B\95A2\9023\4ED8\3051\3089\308C\3066\3044\308B\7279\6027\3092\4F7F\7528\3057\3066\30CF\30A4\30E9\30A4\30C8\8868\793A\3055\308C\307E\3059\3002'),
unistr('\30AA\30D7\30B7\30E7\30F3\306F\6B21\306E\3068\304A\308A\3067\3059\3002</p>'),
unistr('<ul><li><b>\300C\540D\524D\300D</b>\306F\3001\8868\793A\7528\306E\307F\306B\4F7F\7528\3055\308C\307E\3059\3002</li>'),
unistr('<li><b>\300C\9806\5E8F\300D</b>\3067\3001\898F\5247\304C\8A55\4FA1\3055\308C\308B\9806\5E8F\3092\6307\5B9A\3057\307E\3059\3002</li>'),
unistr('<li><b>\300C\6709\52B9\300D</b>\3067\3001\898F\5247\304C\6709\52B9\304B\7121\52B9\304B\3092\6307\5B9A\3057\307E\3059\3002</li>'),
unistr('<li><b>\300C\30CF\30A4\30E9\30A4\30C8\30FB\30BF\30A4\30D7\300D</b>\3067\3001\30CF\30A4\30E9\30A4\30C8\3059\308B\5BFE\8C61\3092\300C\884C\300D\3068\300C\30BB\30EB\300D\306E\3069\3061\3089\304B\306B\6307\5B9A\3057\307E\3059\3002\300C\30BB\30EB\300D\3092\9078\629E\3057\305F\5834\5408\3001\300C\30CF\30A4\30E9\30A4\30C8\6761\4EF6\300D\3067\53C2\7167\3055\308C\308B\5217\304C\30CF\30A4\30E9\30A4\30C8\3055\308C\307E\3059\3002</li>'),
unistr('<li><b>\300C\30D0\30C3\30AF\30B0\30E9\30A6\30F3\30C9\30FB\30AB\30E9\30FC\300D</b>\306F\3001\30CF\30A4\30E9\30A4\30C8\3055\308C\308B\7BC4\56F2\306E\30D0\30C3\30AF\30B0\30E9\30A6\30F3\30C9\306E\65B0\3057\3044\8272\3067\3059\3002</li>'),
unistr('<li><b>\300C\30C6\30AD\30B9\30C8\30FB\30AB\30E9\30FC\300D</b>\306F\3001\30CF\30A4\30E9\30A4\30C8\3055\308C\308B\7BC4\56F2\306B\3042\308B\30C6\30AD\30B9\30C8\306E\65B0\3057\3044\8272\3067\3059\3002</li>'),
unistr('<li><b>\300C\30CF\30A4\30E9\30A4\30C8\6761\4EF6\300D</b>\3067\3001\30D5\30A3\30EB\30BF\6761\4EF6\3092\5B9A\7FA9\3057\307E\3059\3002</li></ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279249448169868819)
,p_name=>'APEXIR_HELP_PIVOT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4FDD\5B58\3057\305F\30EC\30DD\30FC\30C8\3054\3068\306B1\3064\306E\30D4\30DC\30C3\30C8\30FB\30D3\30E5\30FC\3092\5B9A\7FA9\3067\304D\307E\3059\3002\5B9A\7FA9\3059\308B\3068\3001\691C\7D22\30D0\30FC\306E\30D3\30E5\30FC\30FB\30A2\30A4\30B3\30F3\3092\4F7F\7528\3057\3066\3001\30D4\30DC\30C3\30C8\30FB\30D3\30E5\30FC\3068\30EC\30DD\30FC\30C8\30FB\30D3\30E5\30FC\3092\5207\308A\66FF\3048\308B\3053\3068\304C\3067\304D\307E\3059\3002\30D4\30DC\30C3\30C8\30FB\30D3\30E5\30FC\3092\4F5C\6210\3059\308B\306B\306F\6B21\3092\9078\629E\3057\307E\3059\3002'),
'<p></p>',
'<ul>',
unistr('<li>\30D4\30DC\30C3\30C8\5BFE\8C61\306E\5217</li>'),
unistr('<li>\884C\3068\3057\3066\8868\793A\3059\308B\5217</li>'),
unistr('<li>\5B9F\884C\3059\308B\95A2\6570(average\3001sum\3001count\306A\3069)\3092\4F7F\7528\3057\3066\96C6\8A08\3059\308B\5217</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279694259449869093)
,p_name=>'APEXIR_HELP_REPORT_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\30AB\30B9\30BF\30DE\30A4\30BA\3057\3066\3044\308B\5834\5408\306F\3001\691C\7D22\30D0\30FC\306E\4E0B\3001\30EC\30DD\30FC\30C8\306E\4E0A\90E8\306B\30EC\30DD\30FC\30C8\8A2D\5B9A\304C\8868\793A\3055\308C\307E\3059\3002\3053\306E\30A8\30EA\30A2\306F\3001\5DE6\306B\3042\308B\30A2\30A4\30B3\30F3\3092\4F7F\7528\3057\3066\958B\9589\3067\304D\307E\3059\3002'),
'<p>',
unistr('\5404\30EC\30DD\30FC\30C8\8A2D\5B9A\306B\3064\3044\3066\3001\6B21\306E\64CD\4F5C\304C\53EF\80FD\3067\3059\3002'),
'</p><ul>',
unistr('<li>\8A2D\5B9A\3092\7DE8\96C6\3059\308B\306B\306F\540D\524D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</li>'),
unistr('<li>\8A2D\5B9A\3092\6709\52B9\5316/\7121\52B9\5316\3059\308B\306B\306F\3001\300C\6709\52B9/\7121\52B9\300D\30C1\30A7\30C3\30AF\30FB\30DC\30C3\30AF\30B9\3092\9078\629E\307E\305F\306F\9078\629E\89E3\9664\3057\307E\3059\3002\3053\306E\30B3\30F3\30C8\30ED\30FC\30EB\306F\8A2D\5B9A\306E\30AA\30F3/\30AA\30D5\3092\4E00\6642\7684\306B\5207\308A\66FF\3048\308B\3068\304D\4F7F\7528\3057\307E\3059\3002</li>'),
unistr('<li>\8A2D\5B9A\3092\524A\9664\3059\308B\306B\306F\300C\524A\9664\300D\30A2\30A4\30B3\30F3\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</li>'),
'</ul>',
unistr('<p>\30C1\30E3\30FC\30C8\3001\30B0\30EB\30FC\30D7\5316\307E\305F\306F\30D4\30DC\30C3\30C8\3092\4F5C\6210\3057\3066\3044\308B\5834\5408\306F\3001\53F3\306B\8868\793A\3055\308C\3066\3044\308B\30EC\30DD\30FC\30C8\30FB\30D3\30E5\30FC\3001\30C1\30E3\30FC\30C8\30FB\30D3\30E5\30FC\3001\30B0\30EB\30FC\30D7\5316\30D3\30E5\30FC\304A\3088\3073\30D4\30DC\30C3\30C8\30FB\30D3\30E5\30FC\306E\30EA\30F3\30AF\3092\4F7F\7528\3057\3066\3001\30C1\30E3\30FC\30C8\3001\30B0\30EB\30FC\30D7\5316\307E\305F\306F\30D4\30DC\30C3\30C8\3068\30D9\30FC\30B9\30FB\30EC\30DD\30FC\30C8\3092\5207\308A\66FF\3048\308B\3053\3068\304C\3067\304D\307E\3059\3002\30C1\30E3\30FC\30C8\3001\30B0\30EB\30FC\30D7\5316\307E\305F\306F\30D4\30DC\30C3\30C8\3092\8868\793A\3057\3066\3044\308B\5834\5408\306F\3001\300C\7DE8\96C6\300D\30EA\30F3\30AF\3092\4F7F\7528\3057\3066\3082\8A2D\5B9A\3092\7DE8\96C6\3067\304D\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279653382141869068)
,p_name=>'APEXIR_HELP_RESET'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30B9\30BF\30DE\30A4\30BA\3057\305F\5185\5BB9\3092\7834\68C4\3057\3066\3001\30EC\30DD\30FC\30C8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\623B\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280153005720869375)
,p_name=>'APEXIR_HELP_ROWS_PER_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\3054\3068\306B\8868\793A\3059\308B\30EC\30B3\30FC\30C9\6570\3092\8A2D\5B9A\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279653214462869068)
,p_name=>'APEXIR_HELP_SAVE_REPORT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30AB\30B9\30BF\30DE\30A4\30BA\3057\305F\30EC\30DD\30FC\30C8\3092\4ECA\5F8C\306E\4F7F\7528\306E\305F\3081\306B\4FDD\5B58\3057\307E\3059\3002\540D\524D\3068\8AAC\660E(\4EFB\610F)\3092\5165\529B\3057\3001\30EC\30DD\30FC\30C8\3092\30D1\30D6\30EA\30C3\30AF\306B\30A2\30AF\30BB\30B9\53EF\80FD\306B\3059\308B\3053\3068\304C\3067\304D\307E\3059(\3064\307E\308A\3001\3059\3079\3066\306E\30E6\30FC\30B6\30FC\304C\30D7\30E9\30A4\30DE\30EA\30FB\30C7\30D5\30A9\30EB\30C8\30FB\30EC\30DD\30FC\30C8\306B\30A2\30AF\30BB\30B9\3067\304D\307E\3059)\3002\6B21\306E4\7A2E\985E\306E\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\4FDD\5B58\3067\304D\307E\3059\3002</p>'),
'<ul>',
unistr('<li><strong>\300C\30D7\30E9\30A4\30DE\30EA\30FB\30C7\30D5\30A9\30EB\30C8\300D</strong>(\958B\767A\8005\306E\307F)\3002\30D7\30E9\30A4\30DE\30EA\30FB\30C7\30D5\30A9\30EB\30C8\306F\6700\521D\306B\8868\793A\3055\308C\308B\30EC\30DD\30FC\30C8\3067\3059\3002\30D7\30E9\30A4\30DE\30EA\30FB\30C7\30D5\30A9\30EB\30C8\30FB\30EC\30DD\30FC\30C8\306E\540D\524D\306E\5909\66F4\3084\524A\9664\306F\3067\304D\307E\305B\3093\3002</li>'),
unistr('<li><strong>\300C\4EE3\66FF\30EC\30DD\30FC\30C8\300D</strong>(\958B\767A\8005\306E\307F)\3002\3053\306E\30EC\30DD\30FC\30C8\3092\4F7F\7528\3059\308B\3068\3001\958B\767A\8005\306F\8907\6570\306E\30EC\30DD\30FC\30C8\306E\30EC\30A4\30A2\30A6\30C8\3092\4F5C\6210\3067\304D\307E\3059\3002\4EE3\66FF\30EC\30DD\30FC\30C8\306E\4FDD\5B58\3001\540D\524D\306E\5909\66F4\3001\307E\305F\306F\524A\9664\304C\3067\304D\308B\306E\306F\958B\767A\8005\3060\3051\3067\3059\3002</li>'),
unistr('<li><strong>\300C\30D1\30D6\30EA\30C3\30AF\30FB\30EC\30DD\30FC\30C8\300D</strong>(\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC)\3002\3053\306E\30EC\30DD\30FC\30C8\3092\4F5C\6210\3057\305F\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\4FDD\5B58\3001\540D\524D\306E\5909\66F4\3001\307E\305F\306F\524A\9664\3092\5B9F\884C\3067\304D\307E\3059\3002\4ED6\306E\30E6\30FC\30B6\30FC\306F\5225\306E\30EC\30DD\30FC\30C8\3068\3057\3066\30EC\30A4\30A2\30A6\30C8\3092\8868\793A\304A\3088\3073\4FDD\5B58\3067\304D\307E\3059\3002</li>'),
unistr('<li><strong>\300C\30D7\30E9\30A4\30D9\30FC\30C8\30FB\30EC\30DD\30FC\30C8\300D</strong>(\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC)\3002\3053\306E\30EC\30DD\30FC\30C8\3092\4F5C\6210\3057\305F\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306E\307F\304C\30EC\30DD\30FC\30C8\306E\8868\793A\3001\4FDD\5B58\3001\540D\524D\306E\5909\66F4\3001\307E\305F\306F\524A\9664\3092\5B9F\884C\3067\304D\307E\3059\3002</li>'),
'</ul>',
unistr('<p>\30AB\30B9\30BF\30DE\30A4\30BA\3057\305F\30EC\30DD\30FC\30C8\3092\4FDD\5B58\3059\308B\3068\3001\884C\30BB\30EC\30AF\30BF\306E\5DE6\5074\306B\3042\308B\691C\7D22\30D0\30FC\306B\30EC\30DD\30FC\30C8\30FB\30BB\30EC\30AF\30BF\304C\8868\793A\3055\308C\307E\3059(\3053\306E\6A5F\80FD\304C\6709\52B9\306A\5834\5408)\3002</p>'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279652219764869068)
,p_name=>'APEXIR_HELP_SEARCH_BAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\5404\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\306E\6700\4E0A\90E8\306B\306F\691C\7D22\30EA\30FC\30B8\30E7\30F3\304C\3042\308A\307E\3059\3002\3053\306E\30EA\30FC\30B8\30E7\30F3(\307E\305F\306F\691C\7D22\30D0\30FC)\306B\306F\6B21\306E\6A5F\80FD\304C\3042\308A\307E\3059:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280153634693869375)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ACTIONS_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('<li><b>\300C\30A2\30AF\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\300D</b>\3067\306F\30EC\30DD\30FC\30C8\3092\30AB\30B9\30BF\30DE\30A4\30BA\3067\304D\307E\3059\3002\6B21\306B\7D9A\304F\30BB\30AF\30B7\30E7\30F3\3092\53C2\7167\3057\3066\304F\3060\3055\3044\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280153153399869375)
,p_name=>'APEXIR_HELP_SEARCH_BAR_FINDER'
,p_message_language=>'ja'
,p_message_text=>unistr('<li><b>\300C\5217\306E\9078\629E\300D\30A2\30A4\30B3\30F3</b>\3092\4F7F\7528\3057\3066\3001\691C\7D22\3059\308B(\307E\305F\306F\3059\3079\3066\306E)\5217\3092\6307\5B9A\3067\304D\307E\3059\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280153460393869375)
,p_name=>'APEXIR_HELP_SEARCH_BAR_REPORTS'
,p_message_language=>'ja'
,p_message_text=>unistr('<li><b>\300C\30EC\30DD\30FC\30C8\300D</b>\306B\306F\3001\4EE3\66FF\306E\30C7\30D5\30A9\30EB\30C8\3001\304A\3088\3073\4FDD\5B58\3055\308C\305F\30D7\30E9\30A4\30D9\30FC\30C8\307E\305F\306F\30D1\30D6\30EA\30C3\30AF\306E\30EC\30DD\30FC\30C8\304C\8868\793A\3055\308C\307E\3059\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280153380437869375)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('<li><b>\300C\884C\300D</b>\3067\306F\3001\30DA\30FC\30B8\3054\3068\306B\8868\793A\3055\308C\308B\30EC\30B3\30FC\30C9\6570\3092\8A2D\5B9A\3057\307E\3059\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280153215878869375)
,p_name=>'APEXIR_HELP_SEARCH_BAR_TEXTBOX'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li><b>\300C\30C6\30AD\30B9\30C8\9818\57DF\300D</b>\3067\306F\3001\5927/\5C0F\6587\5B57\3092\533A\5225\3057\306A\3044\691C\7D22\57FA\6E96(\30EF\30A4\30EB\30C9\30AB\30FC\30C9\6587\5B57\3092\542B\3080)\3092\5165\529B\3067\304D\307E\3059\3002</li>'),
unistr('<li><b>\300C\5B9F\884C\300D\30DC\30BF\30F3</b>\3092\62BC\3059\3068\691C\7D22\304C\5B9F\884C\3055\308C\307E\3059\3002\30AB\30FC\30BD\30EB\304C\691C\7D22\30C6\30AD\30B9\30C8\9818\57DF\306B\3042\308B\5834\5408\3001[Enter]\30AD\30FC\3092\62BC\3057\3066\3082\691C\7D22\304C\5B9F\884C\3055\308C\307E\3059\3002</li>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280153504219869375)
,p_name=>'APEXIR_HELP_SEARCH_BAR_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('<li><b>\300C\30D3\30E5\30FC\300D\30A2\30A4\30B3\30F3</b>\306F\3001\5B9A\7FA9\3055\308C\3066\3044\308B\5834\5408\306B\30EC\30DD\30FC\30C8\306E\30A2\30A4\30B3\30F3\3001\30EC\30DD\30FC\30C8\3001\8A73\7D30\3001\30C1\30E3\30FC\30C8\3001\30B0\30EB\30FC\30D7\5316\304A\3088\3073\30D4\30DC\30C3\30C8\30FB\30D3\30E5\30FC\3092\5207\308A\66FF\3048\307E\3059\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280495982074869590)
,p_name=>'APEXIR_HELP_SEARCH_BAR_WS_MANAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('<li><b>\300C\7BA1\7406\300D</b>\3092\4F7F\7528\3059\308B\3068\3001\30EC\30DD\30FC\30C8\307E\305F\306F\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\306E\30D7\30ED\30D1\30C6\30A3\3001\5217\3001\884C\304A\3088\3073\8868\793A\5C65\6B74\3092\7BA1\7406\3067\304D\307E\3059\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279652447759869068)
,p_name=>'APEXIR_HELP_SELECT_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\3055\308C\308B\5217\3092\5909\66F4\3057\307E\3059\3002\53F3\5074\306E\5217\304C\8868\793A\3055\308C\3001\5DE6\5074\306E\5217\306F\975E\8868\793A\306B\306A\308A\307E\3059\3002\53F3\7AEF\306B\3042\308B\77E2\5370\3092\4F7F\7528\3057\3066\3001\8868\793A\3055\308C\308B\5217\3092\4E26\3079\66FF\3048\308B\3053\3068\304C\3067\304D\307E\3059\3002\8A08\7B97\7D50\679C\306E\5217\306F\3001\5148\982D\306B<b>**</b>\304C\4ED8\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279652693292869068)
,p_name=>'APEXIR_HELP_SORT'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30BD\30FC\30C8\5BFE\8C61\306E\5217\3068\3001\6607\9806/\964D\9806\3092\5909\66F4\3057\307E\3059\3002<code>NULLs</code>\306E\51E6\7406\65B9\6CD5\3082\6307\5B9A\3067\304D\307E\3059\3002\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306F<code>NULLs</code>\3092\5E38\306B\6700\5F8C\306B\8868\793A\3059\308B\304B\3001\5E38\306B\6700\521D\306B\8868\793A\3059\308B\304B\3067\3059\3002\30BD\30FC\30C8\7D50\679C\306F\3001\30EC\30DD\30FC\30C8\306E\5217\30D8\30C3\30C0\30FC\306E\53F3\306B\8868\793A\3055\308C\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280143015321869368)
,p_name=>'APEXIR_HELP_SUBSCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3\3092\8FFD\52A0\3059\308B\969B\3001\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9(\307E\305F\306F\8907\6570\306E\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3092\30AB\30F3\30DE\3067\533A\5207\3063\305F\3082\306E)\3001\96FB\5B50\30E1\30FC\30EB\306E\4EF6\540D\3001\983B\5EA6\304A\3088\3073\958B\59CB\65E5\3068\7D42\4E86\65E5\3092\6307\5B9A\3057\307E\3059\3002\7D50\679C\306E\96FB\5B50\30E1\30FC\30EB\306F\3001\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3\8FFD\52A0\6642\306E\30EC\30DD\30FC\30C8\8A2D\5B9A\3092\4F7F\7528\3057\305F\73FE\5728\306E\30C7\30FC\30BF\3092\542B\3080\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306EHTML\30D0\30FC\30B8\30E7\30F3\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280495412613869589)
,p_name=>'APEXIR_HELP_WS_01'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\306F\3001\9AD8\5EA6\306A\30AB\30B9\30BF\30DE\30A4\30BA\304C\53EF\80FD\306A\3001\57FA\672C\7684\306B\7DE8\96C6\53EF\80FD\306A\30EC\30DD\30FC\30C8\3067\3059\3002\30E6\30FC\30B6\30FC\306F\3001\5217\306E\9078\629E\3001\30D5\30A3\30EB\30BF\306E\9069\7528\3001\30CF\30A4\30E9\30A4\30C8\307E\305F\306F\30BD\30FC\30C8\3092\884C\3063\3066\3001\30EC\30DD\30FC\30C8\30FB\30C7\30FC\30BF\306E\30EC\30A4\30A2\30A6\30C8\3092\5909\66F4\3067\304D\307E\3059\3002\307E\305F\3001\30D6\30EC\30FC\30AF\3001\96C6\8A08\3001\30C1\30E3\30FC\30C8\3001\30B0\30EB\30FC\30D7\5316\306E\5B9A\7FA9\3084\3001\72EC\81EA\306E\8A08\7B97\306E\8FFD\52A0\3082\53EF\80FD\3067\3059\3002\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3\3092\8A2D\5B9A\3057\3066\3001\30EC\30DD\30FC\30C8\3092\6307\5B9A\3057\305F\9593\9694\3067\96FB\5B50\30E1\30FC\30EB\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002\30E6\30FC\30B6\30FC\306F\30EC\30DD\30FC\30C8\306E\8907\6570\306E\30D0\30EA\30A8\30FC\30B7\30E7\30F3\3092\4F5C\6210\3057\3001\30D7\30E9\30A4\30D9\30FC\30C8\306E\53C2\7167\7528\306B\540D\524D\4ED8\304D\30EC\30DD\30FC\30C8\3068\3057\3066\4FDD\5B58\3067\304D\307E\3059\3002'),
'<p/>',
unistr('\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\306F\3001\691C\7D22\30D0\30FC\3001\30A2\30AF\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\3001\7BA1\7406\30E1\30CB\30E5\30FC\307E\305F\306F\5217\30D8\30C3\30C0\30FC\30FB\30E1\30CB\30E5\30FC\3092\4F7F\7528\3057\3066\30AB\30B9\30BF\30DE\30A4\30BA\3067\304D\307E\3059\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280547825377869621)
,p_name=>'APEXIR_HELP_WS_ACTIONS_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306F\691C\7D22\30D0\30FC\306E\300C\5B9F\884C\300D\30DC\30BF\30F3\306E\53F3\5074\306B\8868\793A\3055\308C\307E\3059\3002\3053\306E\30E1\30CB\30E5\30FC\3092\4F7F\7528\3057\3066\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\30FB\30EC\30DD\30FC\30C8\3092\30AB\30B9\30BF\30DE\30A4\30BA\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280496208393869590)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\884C\306E\8FFD\52A0/\7DE8\96C6\300D\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280496304320869590)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT_ROW'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\306B\884C\3092\8FFD\52A0\3059\308B\306B\306F\3001\300C\884C\306E\8FFD\52A0\300D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002\884C\306E\8A73\7D30\3092\7DE8\96C6\3059\308B\306B\306F\3001\7DE8\96C6\3059\308B\884C\3067\884C\7DE8\96C6\30A2\30A4\30B3\30F3(\6700\521D\306E\5217)\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\306E\5217\3092\793A\3059\300C\884C\306E\8FFD\52A0/\7DE8\96C6\300D\30DA\30FC\30B8\304C\8868\793A\3055\308C\307E\3059\3002</p>'),
'',
unistr('<p>\884C\306E\7DE8\96C6\3067\306F\6B21\306E\64CD\4F5C\304C\53EF\80FD\3067\3059:</p>'),
'',
'<p><ul>',
unistr('<li>\884C\3092<b>\300C\524A\9664\300D</b>\3057\307E\3059\3002</li>'),
unistr('<li><b>\300C\5909\66F4\306E\9069\7528\300D</b>\3067\3001\884C\306B\5BFE\3059\308B\5909\66F4\3092\4FDD\5B58\3057\307E\3059\3002</li>'),
unistr('<li><b>\300C\30A2\30AF\30B7\30E7\30F3\300D</b>\5185\3067\3001\884C\306E\8FFD\52A0\3001\30D5\30A1\30A4\30EB\3001\30CE\30FC\30C8\3001\30EA\30F3\30AF\307E\305F\306F\30BF\30B0\306E\8FFD\52A0\3001\5C65\6B74\306E\8868\793A\306A\3069\3092\884C\3044\307E\3059\3002</li>'),
unistr('<li><b>\300C\6B21\3078\300D\304A\3088\3073\300C\623B\308B\300D</b>\884C\306B\30CA\30D3\30B2\30FC\30C8\3057\307E\3059\3002</li>'),
unistr('<li><b>\300C\7BA1\7406\300D</b>\5185\3067\3001\5217\30D7\30ED\30D1\30C6\30A3\3001\5217\30B0\30EB\30FC\30D7\3001\691C\8A3C\304A\3088\3073LOV\306E\8A2D\5B9A\3092\884C\3044\307E\3059\3002</li>'),
'</ul></p>',
'',
unistr('<p>\30DA\30FC\30B8\4E0B\90E8\306B\3042\308B\300C\6CE8\91C8\300D\30EA\30FC\30B8\30E7\30F3\306B\306F\3001\73FE\5728\306E\884C\306B\95A2\9023\4ED8\3051\3089\308C\3066\3044\308B\30D5\30A1\30A4\30EB\3001\30CE\30FC\30C8\3001\30EA\30F3\30AF\307E\305F\306F\30BF\30B0\304C\3042\308C\3070\8868\793A\3055\308C\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280547990922869621)
,p_name=>'APEXIR_HELP_WS_CONTROL_BREAK'
,p_message_language=>'ja'
,p_message_text=>unistr('1\3064\307E\305F\306F\8907\6570\306E\5217\306B\30D6\30EC\30FC\30AF\30FB\30B0\30EB\30FC\30D7\3092\4F5C\6210\3057\307E\3059\3002\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\30FB\30EC\30DD\30FC\30C8\304B\3089\5217\304C\62BD\51FA\3055\308C\3001\30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9\3068\3057\3066\8868\793A\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280496143279869590)
,p_name=>'APEXIR_HELP_WS_DOWNLOAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\5728\306E\7D50\679C\30BB\30C3\30C8\306E\30C0\30A6\30F3\30ED\30FC\30C9\3092\6709\52B9\306B\3057\307E\3059\3002\30C0\30A6\30F3\30ED\30FC\30C9\5F62\5F0F\306B\306FCSV\3001HTML\307E\305F\306F\96FB\5B50\30E1\30FC\30EB\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280548073617869622)
,p_name=>'APEXIR_HELP_WS_REPORT_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\30FB\30EC\30DD\30FC\30C8\3092\30AB\30B9\30BF\30DE\30A4\30BA\3057\3066\3044\308B\5834\5408\306F\3001\691C\7D22\30D0\30FC\306E\4E0B\3001\30EC\30DD\30FC\30C8\306E\4E0A\90E8\306B\30EC\30DD\30FC\30C8\8A2D\5B9A\304C\8868\793A\3055\308C\307E\3059\3002\3053\306E\30A8\30EA\30A2\306F\3001\5DE6\306B\3042\308B\30A2\30A4\30B3\30F3\3092\4F7F\7528\3057\3066\958B\9589\3067\304D\307E\3059\3002'),
'<p>',
unistr('\5404\30EC\30DD\30FC\30C8\8A2D\5B9A\306B\3064\3044\3066\3001\6B21\306E\64CD\4F5C\304C\53EF\80FD\3067\3059\3002'),
'</p><ul>',
unistr('<li>\8A2D\5B9A\3092\7DE8\96C6\3059\308B\306B\306F\540D\524D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</li>'),
unistr('<li>\8A2D\5B9A\3092\6709\52B9\5316/\7121\52B9\5316\3059\308B\306B\306F\3001\300C\6709\52B9/\7121\52B9\300D\30C1\30A7\30C3\30AF\30FB\30DC\30C3\30AF\30B9\3092\9078\629E\307E\305F\306F\9078\629E\89E3\9664\3057\307E\3059\3002\3053\306E\30B3\30F3\30C8\30ED\30FC\30EB\306F\8A2D\5B9A\306E\30AA\30F3/\30AA\30D5\3092\4E00\6642\7684\306B\5207\308A\66FF\3048\308B\3068\304D\4F7F\7528\3057\307E\3059\3002</li>'),
unistr('<li>\8A2D\5B9A\3092\524A\9664\3059\308B\306B\306F\300C\524A\9664\300D\30A2\30A4\30B3\30F3\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</li>'),
'</ul>',
unistr('<p>\30C1\30E3\30FC\30C8\3084\30B0\30EB\30FC\30D7\5316\3092\4F5C\6210\3057\3066\3044\308B\5834\5408\306F\3001\53F3\306B\8868\793A\3055\308C\3066\3044\308B\30EC\30DD\30FC\30C8\30FB\30D3\30E5\30FC\3001\30C1\30E3\30FC\30C8\30FB\30D3\30E5\30FC\304A\3088\3073\30B0\30EB\30FC\30D7\5316\30D3\30E5\30FC\306E\30EA\30F3\30AF\3092\4F7F\7528\3057\3066\3001\30C1\30E3\30FC\30C8\3084\30B0\30EB\30FC\30D7\5316\3068\30D9\30FC\30B9\30FB\30EC\30DD\30FC\30C8\3092\5207\308A\66FF\3048\308B\3053\3068\304C\3067\304D\307E\3059\3002\30C1\30E3\30FC\30C8\3084\30B0\30EB\30FC\30D7\5316\3092\8868\793A\3057\3066\3044\308B\5834\5408\306F\3001\300C\7DE8\96C6\300D\30EA\30F3\30AF\3092\4F7F\7528\3057\3066\3082\8A2D\5B9A\3092\7DE8\96C6\3067\304D\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280496049190869590)
,p_name=>'APEXIR_HELP_WS_SAVE_REPORT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30AB\30B9\30BF\30DE\30A4\30BA\3057\305F\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\30FB\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8\3092\4ECA\5F8C\306E\4F7F\7528\306E\305F\3081\306B\4FDD\5B58\3057\307E\3059\3002\540D\524D\3068\8AAC\660E(\4EFB\610F)\3092\5165\529B\3057\307E\3059\3002\6B21\306E3\7A2E\985E\306E\30C7\30FC\30BF\30FB\30B0\30EA\30C3\30C9\30FB\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8\3092\4FDD\5B58\3067\304D\307E\3059\3002</p>'),
'<ul>',
unistr('<li><strong>\300C\30D7\30E9\30A4\30DE\30EA\30FB\30C7\30D5\30A9\30EB\30C8\300D</strong>(\7BA1\7406\8005\306E\307F)\3002\30D7\30E9\30A4\30DE\30EA\30FB\30C7\30D5\30A9\30EB\30C8\306F\6700\521D\306B\8868\793A\3055\308C\308B\30EC\30A4\30A2\30A6\30C8\3067\3059\3002\30D7\30E9\30A4\30DE\30EA\30FB\30C7\30D5\30A9\30EB\30C8\30FB\30EC\30DD\30FC\30C8\306E\540D\524D\306E\5909\66F4\3084\524A\9664\306F\3067\304D\307E\305B\3093\3002</li>'),
unistr('<li><strong>\300C\4EE3\66FF\30EC\30DD\30FC\30C8\300D</strong>(\7BA1\7406\8005\306E\307F)\3002\3053\306E\30EC\30DD\30FC\30C8\3092\4F7F\7528\3059\308B\3068\3001\7BA1\7406\8005\306F\8907\6570\306E\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8\3092\4F5C\6210\3067\304D\307E\3059\3002\4EE3\66FF\30EC\30DD\30FC\30C8\306E\4FDD\5B58\3001\540D\524D\306E\5909\66F4\3001\307E\305F\306F\524A\9664\304C\3067\304D\308B\306E\306F\7BA1\7406\8005\3060\3051\3067\3059\3002</li>'),
unistr('<li><strong>\300C\30D7\30E9\30A4\30D9\30FC\30C8\30FB\30EC\30DD\30FC\30C8\300D</strong>(\5168\30E6\30FC\30B6\30FC)\3002\3053\306E\30EC\30DD\30FC\30C8\30FB\30EC\30A4\30A2\30A6\30C8\3092\4F5C\6210\3057\305F\30E6\30FC\30B6\30FC\304C\30EC\30DD\30FC\30C8\306E\8868\793A\3001\4FDD\5B58\3001\540D\524D\306E\5909\66F4\3001\307E\305F\306F\524A\9664\3092\5B9F\884C\3067\304D\307E\3059\3002</li>'),
'</ul>',
unistr('<p>\30AB\30B9\30BF\30DE\30A4\30BA\3057\305F\30EC\30DD\30FC\30C8\3092\4FDD\5B58\3059\308B\3068\3001\884C\30BB\30EC\30AF\30BF\306E\5DE6\5074\306B\3042\308B\691C\7D22\30D0\30FC\306B\30EC\30DD\30FC\30C8\30FB\30BB\30EC\30AF\30BF\304C\8868\793A\3055\308C\307E\3059(\3053\306E\6A5F\80FD\304C\6709\52B9\306A\5834\5408)\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279664554520869075)
,p_name=>'APEXIR_HIDE_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\306E\975E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279576874075869022)
,p_name=>'APEXIR_HIGHLIGHT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279668793631869078)
,p_name=>'APEXIR_HIGHLIGHTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279694395479869093)
,p_name=>'APEXIR_HIGHLIGHT_CONDITION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280143927347869369)
,p_name=>'APEXIR_HIGHLIGHT_STYLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8\30FB\30B9\30BF\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279417620961868925)
,p_name=>'APEXIR_HIGHLIGHT_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8\30FB\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279418378493868926)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280504530764869595)
,p_name=>'APEXIR_HORIZONTAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A2A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280608056629869658)
,p_name=>'APEXIR_INACTIVE_SETTING'
,p_message_language=>'ja'
,p_message_text=>unistr('1\3064\306E\975E\30A2\30AF\30C6\30A3\30D6\306A\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280608125895869658)
,p_name=>'APEXIR_INACTIVE_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\975E\30A2\30AF\30C6\30A3\30D6\306A\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279653966063869069)
,p_name=>'APEXIR_INTERACTIVE_REPORT_HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\306E\30D8\30EB\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279695682189869094)
,p_name=>'APEXIR_INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279667214607869077)
,p_name=>'APEXIR_INVALID_COMPUTATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97\306E\5F0F\304C\7121\52B9\3067\3059\3002%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279364793746868892)
,p_name=>'APEXIR_INVALID_END_DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86\65E5\306F\958B\59CB\65E5\3088\308A\3082\5F8C\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279814017036869166)
,p_name=>'APEXIR_INVALID_FILTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\30D5\30A3\30EB\30BF\5F0F\3067\3059\3002%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280540608810869617)
,p_name=>'APEXIR_INVALID_FILTER_QUERY'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\30D5\30A3\30EB\30BF\554F\5408\305B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280608208112869658)
,p_name=>'APEXIR_INVALID_SETTING'
,p_message_language=>'ja'
,p_message_text=>unistr('1\3064\306E\7121\52B9\306A\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280608357859869658)
,p_name=>'APEXIR_INVALID_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\7121\52B9\306A\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280144353696869369)
,p_name=>'APEXIR_IN_MINUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('(\5206\5358\4F4D)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280487411815869584)
,p_name=>'APEXIR_IS_IN_THE_LAST'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C\904E\53BB\306E%1\5185\306B\3042\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280487755594869585)
,p_name=>'APEXIR_IS_IN_THE_NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C\4ECA\5F8C\306E%1\5185\306B\3042\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280487630281869585)
,p_name=>'APEXIR_IS_NOT_IN_THE_LAST'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C\904E\53BB\306E%1\5185\306B\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280487848277869585)
,p_name=>'APEXIR_IS_NOT_IN_THE_NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304C\4ECA\5F8C\306E%1\5185\306B\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279693495770869092)
,p_name=>'APEXIR_KEYPAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AD\30FC\30D1\30C3\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279448643490868944)
,p_name=>'APEXIR_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279662165125869074)
,p_name=>'APEXIR_LABEL_AXIS_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB\306E\8EF8\30BF\30A4\30C8\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280009463769869287)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB\306E\63A5\982D\8F9E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279581051586869024)
,p_name=>'APEXIR_LAST_DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB1\65E5\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279581284046869024)
,p_name=>'APEXIR_LAST_HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB1\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279580733253869024)
,p_name=>'APEXIR_LAST_MONTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\5148\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279580809427869024)
,p_name=>'APEXIR_LAST_WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('\5148\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279580931944869024)
,p_name=>'APEXIR_LAST_X_DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB%0\65E5\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279581109449869024)
,p_name=>'APEXIR_LAST_X_HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB%0\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279580502980869024)
,p_name=>'APEXIR_LAST_X_YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB%0\5E74\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279580635499869024)
,p_name=>'APEXIR_LAST_YEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6628\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279448454829868944)
,p_name=>'APEXIR_LINE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6298\308C\7DDA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279420722876868927)
,p_name=>'APEXIR_LINE_WITH_AREA'
,p_message_language=>'ja'
,p_message_text=>unistr('\9762\4ED8\304D\6298\308C\7DDA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280127667250869359)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3\3092\7BA1\7406\3059\308B\306B\306F<a href=''%0''>\3053\3053\3092</a>\30AF\30EA\30C3\30AF\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280540586365869617)
,p_name=>'APEXIR_MAP_IT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30C3\30D7\3059\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279665142127869075)
,p_name=>'APEXIR_MAX_QUERY_COST'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\5408\305B\304C\3001\6700\5927\8A31\5BB9\30EA\30BD\30FC\30B9\3092\8D85\3048\308B\3068\63A8\5B9A\3055\308C\307E\3059\3002\30EC\30DD\30FC\30C8\8A2D\5B9A\3092\5909\66F4\3057\3066\304B\3089\518D\8A66\884C\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279533312251868995)
,p_name=>'APEXIR_MAX_ROW_CNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30EC\30DD\30FC\30C8\306E\6700\5927\884C\6570\306F%0\884C\3067\3059\3002\30D5\30A3\30EB\30BF\3092\9069\7528\3057\3066\3001\554F\5408\305B\306E\30EC\30B3\30FC\30C9\6570\3092\524A\6E1B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280541180720869617)
,p_name=>'APEXIR_MAX_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5927%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280541390252869617)
,p_name=>'APEXIR_MEDIAN_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E2D\9593%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279547066990869003)
,p_name=>'APEXIR_MIN_AGO'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\5206\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280541242385869617)
,p_name=>'APEXIR_MIN_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5C0F%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280540163008869617)
,p_name=>'APEXIR_MONTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280144738490869369)
,p_name=>'APEXIR_MONTHLY'
,p_message_language=>'ja'
,p_message_text=>unistr('\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279695835486869094)
,p_name=>'APEXIR_MORE_DATA'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\30C7\30FC\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279661069974869073)
,p_name=>'APEXIR_MOVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\79FB\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279660941894869073)
,p_name=>'APEXIR_MOVE_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\79FB\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280626494637869669)
,p_name=>'APEXIR_MULTIIR_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306B\306F\8907\6570\306E\5BFE\8A71\30EC\30DD\30FC\30C8\304C\542B\307E\308C\3066\3044\308B\305F\3081\3001\30EA\30FC\30B8\30E7\30F3\306E\9759\7684ID\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279419401592868927)
,p_name=>'APEXIR_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\540D\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279650398584869067)
,p_name=>'APEXIR_NEW_AGGREGATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\65B0\898F\96C6\8A08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279442660718868940)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_language=>'ja'
,p_message_text=>unistr('- \65B0\898F\30AB\30C6\30B4\30EA -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280609784854869659)
,p_name=>'APEXIR_NEW_CATEGORY_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\65B0\898F\30AB\30C6\30B4\30EA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279650405083869067)
,p_name=>'APEXIR_NEW_COMPUTATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\65B0\898F\8A08\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279575159053869021)
,p_name=>'APEXIR_NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279581613606869025)
,p_name=>'APEXIR_NEXT_DAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E1\65E5\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279581457560869025)
,p_name=>'APEXIR_NEXT_HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279581912724869025)
,p_name=>'APEXIR_NEXT_MONTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279581859103869025)
,p_name=>'APEXIR_NEXT_WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279581717342869025)
,p_name=>'APEXIR_NEXT_X_DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0\65E5\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279581548614869025)
,p_name=>'APEXIR_NEXT_X_HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279582151597869025)
,p_name=>'APEXIR_NEXT_X_YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E%0\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279582039715869025)
,p_name=>'APEXIR_NEXT_YEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279419722279868927)
,p_name=>'APEXIR_NO'
,p_message_language=>'ja'
,p_message_text=>unistr('\3044\3044\3048')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279696046059869094)
,p_name=>'APEXIR_NONE'
,p_message_language=>'ja'
,p_message_text=>unistr('- \306A\3057 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280143707045869369)
,p_name=>'APEXIR_NOT_VALID_EMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279577944371869023)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\96C6\8A08\304C\5B9A\7FA9\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279532116360868994)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\60C5\5831\304C\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279578037438869023)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97\304C\5B9A\7FA9\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280539950365869617)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('- \7D42\4E86\65E5\306A\3057 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279691133839869091)
,p_name=>'APEXIR_NULLS_ALWAYS_FIRST'
,p_message_language=>'ja'
,p_message_text=>unistr('NULL\3092\5E38\306B\6700\521D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279691021223869091)
,p_name=>'APEXIR_NULLS_ALWAYS_LAST'
,p_message_language=>'ja'
,p_message_text=>unistr('NULL\3092\5E38\306B\6700\5F8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279692018475869092)
,p_name=>'APEXIR_NULL_SORTING'
,p_message_language=>'ja'
,p_message_text=>unistr('NULL\30BD\30FC\30C8%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279667397760869077)
,p_name=>'APEXIR_NUMERIC_FLASHBACK_TIME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF\6642\9593\306F\6570\5024\3067\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279666899954869076)
,p_name=>'APEXIR_NUMERIC_SEQUENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\9806\5E8F\306F\6570\5024\3067\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279692755073869092)
,p_name=>'APEXIR_OPERATOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6F14\7B97\5B50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279418109255868926)
,p_name=>'APEXIR_ORANGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30EC\30F3\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280504448788869595)
,p_name=>'APEXIR_ORIENTATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\5411\304D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279420235431868927)
,p_name=>'APEXIR_OTHER'
,p_message_language=>'ja'
,p_message_text=>unistr('\305D\306E\4ED6')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280541607848869618)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_COUNT_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\5408\8A08\30AB\30A6\30F3\30C8%0\306B\5BFE\3059\308B\5272\5408(%)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280540872058869617)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_SUM_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\7DCF\5408\8A08%0\306B\5BFE\3059\308B\5272\5408(%)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280539362758869616)
,p_name=>'APEXIR_PERCENT_TOTAL_COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5408\8A08\30AB\30A6\30F3\30C8\306B\5BFE\3059\308B\5272\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280539210550869616)
,p_name=>'APEXIR_PERCENT_TOTAL_SUM'
,p_message_language=>'ja'
,p_message_text=>unistr('\7DCF\5408\8A08\306B\5BFE\3059\308B\5272\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279448307525868944)
,p_name=>'APEXIR_PIE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5186')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279983178315869271)
,p_name=>'APEXIR_PIVOT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280010785872869288)
,p_name=>'APEXIR_PIVOT_AGG_NOT_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\96C6\8A08\304C\6307\5B9A\3055\308C\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280011050930869288)
,p_name=>'APEXIR_PIVOT_AGG_NOT_ON_ROW_COL'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\5217\3068\3057\3066\9078\629E\3055\308C\305F\5217\3067\96C6\8A08\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280008551315869286)
,p_name=>'APEXIR_PIVOT_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280008388632869286)
,p_name=>'APEXIR_PIVOT_COLUMN_N'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\5217%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280010520416869288)
,p_name=>'APEXIR_PIVOT_COLUMN_NOT_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\5217\304C\6307\5B9A\3055\308C\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279249397823868819)
,p_name=>'APEXIR_PIVOT_MAX_ROW_CNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\554F\5408\305B\306E\884C\30AB\30A6\30F3\30C8\6700\5927\5024\306F\3001\8868\793A\3055\308C\308B\884C\6570\3067\306F\306A\304F\30D9\30FC\30B9\554F\5408\305B\306E\884C\6570\3092\5236\9650\3057\307E\3059\3002\30D9\30FC\30B9\554F\5408\305B\304C\884C\30AB\30A6\30F3\30C8\6700\5927\5024%0\3092\8D85\3048\3066\3044\307E\3059\3002\30D5\30A3\30EB\30BF\3092\9069\7528\3057\3066\3001\30D9\30FC\30B9\554F\5408\305B\306E\30EC\30B3\30FC\30C9\6570\3092\524A\6E1B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280622321935869667)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\306E\884C\5217\3092\9078\629E\3057\3066\304F\3060\3055\3044\3002\884C\5217\306EHTML\5F0F\307E\305F\306F\30EA\30F3\30AF\306B\306F\3001\30D4\30DC\30C3\30C8\5217\307E\305F\306F\96C6\8A08\5217\3068\3057\3066\5B9A\7FA9\3055\308C\305F\5217\304C\542B\307E\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280009503362869287)
,p_name=>'APEXIR_PIVOT_SORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\30FB\30BD\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280143836842869369)
,p_name=>'APEXIR_PREVIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30EC\30D3\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279575226763869021)
,p_name=>'APEXIR_PREVIOUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280538252561869616)
,p_name=>'APEXIR_PRIMARY'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E3B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280147594133869371)
,p_name=>'APEXIR_PRIMARY_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30A4\30DE\30EA\30FB\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279808062408869162)
,p_name=>'APEXIR_PRIVATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30A4\30D9\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279449790672868945)
,p_name=>'APEXIR_PUBLIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30D6\30EA\30C3\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279420089431868927)
,p_name=>'APEXIR_RED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30C3\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280626337032869669)
,p_name=>'APEXIR_REGION_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3\306E\9759\7684ID %0\306F\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279661120171869073)
,p_name=>'APEXIR_REMOVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279574204727869020)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\96C6\8A08\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279661265978869073)
,p_name=>'APEXIR_REMOVE_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280608401778869658)
,p_name=>'APEXIR_REMOVE_CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30E9\30D5\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279660511986869073)
,p_name=>'APEXIR_REMOVE_CONTROL_BREAK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30ED\30FC\30EB\30FB\30D6\30EC\30FC\30AF\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279660274921869073)
,p_name=>'APEXIR_REMOVE_FILTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279660393778869073)
,p_name=>'APEXIR_REMOVE_FLASHBACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30E9\30C3\30B7\30E5\30D0\30C3\30AF\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280608569956869659)
,p_name=>'APEXIR_REMOVE_GROUP_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279660628523869073)
,p_name=>'APEXIR_REMOVE_HIGHLIGHT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280608697791869659)
,p_name=>'APEXIR_REMOVE_PIVOT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280549810748869623)
,p_name=>'APEXIR_REMOVE_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280428738401869548)
,p_name=>'APEXIR_RENAME_DEFAULT_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\30FB\30EC\30DD\30FC\30C8\540D\306E\5909\66F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279696464366869094)
,p_name=>'APEXIR_RENAME_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306E\540D\524D\5909\66F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279575768404869021)
,p_name=>'APEXIR_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280541715895869618)
,p_name=>'APEXIR_REPORTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279409254501868920)
,p_name=>'APEXIR_REPORT_ALIAS_DOES_NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\540D%0\3067\4FDD\5B58\3055\308C\305F\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\304C\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279958651419869256)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306E\8868\793A\5217\306E\6570\304C\5236\9650\306B\9054\3057\307E\3057\305F\3002\300C\30A2\30AF\30B7\30E7\30F3\300D\30E1\30CB\30E5\30FC\3067\300C\5217\306E\9078\629E\300D\3092\30AF\30EA\30C3\30AF\3057\3001\30EC\30DD\30FC\30C8\8868\793A\5217\306E\30EA\30B9\30C8\3092\6700\5C0F\9650\306B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279811322249869164)
,p_name=>'APEXIR_REPORT_DOES_NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\304C\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279409330818868920)
,p_name=>'APEXIR_REPORT_ID_DOES_NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58\3055\308C\305F\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8ID %0\304C\5B58\5728\3057\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279694130367869093)
,p_name=>'APEXIR_REPORT_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279547509922869004)
,p_name=>'APEXIR_REPORT_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30D3\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279577313765869022)
,p_name=>'APEXIR_RESET'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30BB\30C3\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279449943316868945)
,p_name=>'APEXIR_RESET_CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\623B\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279419808303868927)
,p_name=>'APEXIR_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280534021135869613)
,p_name=>'APEXIR_ROWID_NOT_SUPPORTED_FOR_WEBSOURCE'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30BD\30FC\30B9\306E\4E3B\30AD\30FC\5217\3068\3057\3066ROWID\3092\4F7F\7528\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279659246918869072)
,p_name=>'APEXIR_ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280152971165869375)
,p_name=>'APEXIR_ROWS_PER_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\3054\3068\306E\884C\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280008674266869286)
,p_name=>'APEXIR_ROW_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280008443717869286)
,p_name=>'APEXIR_ROW_COLUMN_N'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\5217%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280010676966869288)
,p_name=>'APEXIR_ROW_COLUMN_NOT_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\5217\304C\6307\5B9A\3055\308C\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280010813505869288)
,p_name=>'APEXIR_ROW_COL_DIFF_FROM_PIVOT_COL'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\5217\30BF\30A4\30D7\306F\30D4\30DC\30C3\30C8\5217\3068\7570\306A\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279755923057869130)
,p_name=>'APEXIR_ROW_FILTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\30D5\30A3\30EB\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279547683366869004)
,p_name=>'APEXIR_ROW_OF'
,p_message_language=>'ja'
,p_message_text=>unistr('%1\884C\4E2D%0\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279546880290869003)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279578800136869023)
,p_name=>'APEXIR_ROW_TEXT_CONTAINS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3092\542B\3080\884C\30C6\30AD\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279269241463868831)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306E\8868\793A\5217\306E\6570\304C\5236\9650\306B\9054\3057\307E\3057\305F\3002\300C\30A2\30AF\30B7\30E7\30F3\300D\30E1\30CB\30E5\30FC\3067\300C\5217\306E\9078\629E\300D\3092\30AF\30EA\30C3\30AF\3057\3001\30EC\30DD\30FC\30C8\8868\793A\5217\306E\30EA\30B9\30C8\3092\6700\5C0F\9650\306B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279419053137868926)
,p_name=>'APEXIR_SAVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279668955677869078)
,p_name=>'APEXIR_SAVED_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58\3055\308C\305F\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279668872003869078)
,p_name=>'APEXIR_SAVED_REPORT_MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\4FDD\5B58\3055\308C\305F\30EC\30DD\30FC\30C8 = "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279577737900869022)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\3068\3057\3066\4FDD\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279690357769869091)
,p_name=>'APEXIR_SAVE_DEFAULT_CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\5728\306E\30EC\30DD\30FC\30C8\8A2D\5B9A\304C\3001\3059\3079\3066\306E\30E6\30FC\30B6\30FC\3067\30C7\30D5\30A9\30EB\30C8\3068\3057\3066\4F7F\7528\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280428652891869548)
,p_name=>'APEXIR_SAVE_DEFAULT_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\30FB\30EC\30DD\30FC\30C8\306E\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279577267053869022)
,p_name=>'APEXIR_SAVE_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306E\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280609681819869659)
,p_name=>'APEXIR_SAVE_REPORT_DEFAULT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306E\4FDD\5B58*')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280164595135869382)
,p_name=>'APEXIR_SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279653862788869069)
,p_name=>'APEXIR_SEARCH_BAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\30D0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280609521021869659)
,p_name=>'APEXIR_SEARCH_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280213824980869413)
,p_name=>'APEXIR_SEARCH_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280125460226869358)
,p_name=>'APEXIR_SELECTED_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279419380740868927)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_language=>'ja'
,p_message_text=>unistr('- \30AB\30C6\30B4\30EA\306E\9078\629E -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279420900155868927)
,p_name=>'APEXIR_SELECT_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('- \5217\306E\9078\629E -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279576559126869022)
,p_name=>'APEXIR_SELECT_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\306E\9078\629E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279696233331869094)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97\7D50\679C\306E\5217\306F\3001\5148\982D\306B**\304C\4ED8\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279449198782868945)
,p_name=>'APEXIR_SELECT_FUNCTION'
,p_message_language=>'ja'
,p_message_text=>unistr('- \30D5\30A1\30F3\30AF\30B7\30E7\30F3\306E\9078\629E -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279658676998869072)
,p_name=>'APEXIR_SELECT_GROUP_BY_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('- \5217\5225\306E\30B0\30EB\30FC\30D7\306E\9078\629E -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280008140524869286)
,p_name=>'APEXIR_SELECT_PIVOT_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('- \30D4\30DC\30C3\30C8\5217\306E\9078\629E -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280540754407869617)
,p_name=>'APEXIR_SELECT_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\9078\629E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280008239224869286)
,p_name=>'APEXIR_SELECT_ROW_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('- \884C\5217\306E\9078\629E -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280539571391869616)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('- \30BD\30FC\30C8\5217\306E\9078\629E -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279695706846869094)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024\306E\9078\629E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279259057111868825)
,p_name=>'APEXIR_SEND'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279419534987868927)
,p_name=>'APEXIR_SEQUENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279576776720869022)
,p_name=>'APEXIR_SORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279664382204869075)
,p_name=>'APEXIR_SORT_ASCENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\6607\9806\30BD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280539477830869616)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8\5217%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279664445670869075)
,p_name=>'APEXIR_SORT_DESCENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\964D\9806\30BD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280549017229869622)
,p_name=>'APEXIR_SORT_ORDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30C8\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279649994808869066)
,p_name=>'APEXIR_SPACE_AS_IN_ONE_EMPTY_STRING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30DA\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279693082256869092)
,p_name=>'APEXIR_STATUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30C6\30FC\30BF\30B9%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280144438795869369)
,p_name=>'APEXIR_SUBSCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280539814560869617)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280125330012869358)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86\5358\4F4D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280539783934869617)
,p_name=>'APEXIR_SUBSCRIPTION_STARTING_FROM'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\59CB\4F4D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280540930380869617)
,p_name=>'APEXIR_SUM_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\5408\8A08%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280490244653869586)
,p_name=>'APEXIR_TABLE_SUMMARY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3 = %0\3001\30EC\30DD\30FC\30C8 = %1\3001\30D3\30E5\30FC = %2\3001\8868\793A\884C\306E\958B\59CB = %3\3001\8868\793A\884C\306E\7D42\4E86 = %4\3001\884C\5408\8A08 = %5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279600331167869036)
,p_name=>'APEXIR_TABLE_SUMMARY_NO_TOTAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3 = %0\3001\30EC\30DD\30FC\30C8 = %1\3001\30D3\30E5\30FC = %2\3001\8868\793A\884C\306E\958B\59CB = %3\3001\8868\793A\884C\306E\7D42\4E86 = %4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279418213186868926)
,p_name=>'APEXIR_TEXT_COLOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30AD\30B9\30C8\30FB\30AB\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279533964288868996)
,p_name=>'APEXIR_TIME_DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279533834870868995)
,p_name=>'APEXIR_TIME_HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279533754633868995)
,p_name=>'APEXIR_TIME_MINS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5206')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279534107526868996)
,p_name=>'APEXIR_TIME_MONTHS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279534020897868996)
,p_name=>'APEXIR_TIME_WEEKS'
,p_message_language=>'ja'
,p_message_text=>unistr('\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279534236201868996)
,p_name=>'APEXIR_TIME_YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280549665959869622)
,p_name=>'APEXIR_TOGGLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5207\66FF\3048')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279661338181869073)
,p_name=>'APEXIR_TOP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C8\30C3\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279694509646869093)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\53EF\3055\308C\3066\3044\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280523449236869607)
,p_name=>'APEXIR_UNGROUPED_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316\3055\308C\3066\3044\306A\3044\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279667027546869077)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\30D8\30C3\30C0\30FC\306F\4E00\610F\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279666758058869076)
,p_name=>'APEXIR_UNIQUE_HIGHLIGHT_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CF\30A4\30E9\30A4\30C8\540D\306F\4E00\610F\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279447463657868943)
,p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30DD\30FC\30C8\3055\308C\3066\3044\306A\3044\30C7\30FC\30BF\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279661497676869073)
,p_name=>'APEXIR_UP'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0A\3078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279666966412869076)
,p_name=>'APEXIR_VALID_COLOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9\306A\8272\3092\5165\529B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279667120575869077)
,p_name=>'APEXIR_VALID_FORMAT_MASK'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9\306A\66F8\5F0F\30DE\30B9\30AF\3092\5165\529B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279420331325868927)
,p_name=>'APEXIR_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279662298515869074)
,p_name=>'APEXIR_VALUE_AXIS_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024\306E\8EF8\30BF\30A4\30C8\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279695502489869094)
,p_name=>'APEXIR_VALUE_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5FC5\9808\306E\5024')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279448281753868944)
,p_name=>'APEXIR_VCOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5782\76F4\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280504692514869595)
,p_name=>'APEXIR_VERTICAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\7E26')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279694770625869093)
,p_name=>'APEXIR_VIEW_CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280193693086869400)
,p_name=>'APEXIR_VIEW_DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280612762038869661)
,p_name=>'APEXIR_VIEW_DOES_NOT_EXIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306B\5B9A\7FA9\3055\308C\305F%0\30D3\30E5\30FC\304C\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280193715977869400)
,p_name=>'APEXIR_VIEW_GROUP_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30EB\30FC\30D7\5316\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280193579818869400)
,p_name=>'APEXIR_VIEW_ICONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30B3\30F3\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280007918778869286)
,p_name=>'APEXIR_VIEW_PIVOT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30DC\30C3\30C8\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279694833284869093)
,p_name=>'APEXIR_VIEW_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280540331157869617)
,p_name=>'APEXIR_WEEK'
,p_message_language=>'ja'
,p_message_text=>unistr('\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280144657847869369)
,p_name=>'APEXIR_WEEKLY'
,p_message_language=>'ja'
,p_message_text=>unistr('\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279575687123869021)
,p_name=>'APEXIR_WORKING_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F5C\696D\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280542565043869618)
,p_name=>'APEXIR_X_DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280542452471869618)
,p_name=>'APEXIR_X_HOURS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280542339900869618)
,p_name=>'APEXIR_X_MINS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\5206')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280542798254869618)
,p_name=>'APEXIR_X_MONTHS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\304B\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280542679563869618)
,p_name=>'APEXIR_X_WEEKS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\9031\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280542822737869618)
,p_name=>'APEXIR_X_YEARS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280540247102869617)
,p_name=>'APEXIR_YEAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279417923850868926)
,p_name=>'APEXIR_YELLOW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30A8\30ED\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279419630652868927)
,p_name=>'APEXIR_YES'
,p_message_language=>'ja'
,p_message_text=>unistr('\306F\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279266386139868830)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_language=>'ja'
,p_message_text=>unistr('Application Express\7BA1\7406\30B5\30FC\30D3\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280488803310869585)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\306F\8A8D\8A3C\304C\69CB\6210\3055\308C\3066\3044\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279662046792869074)
,p_name=>'APEX_GROUP.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306B\3001\7121\52B9\306A\6587\5B57\3067\3042\308B<\307E\305F\306F>\304C\542B\307E\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279879253841869206)
,p_name=>'APEX_REGION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279735941846869118)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\306F\3001\9078\629E\3057\305F\30B9\30AD\30FC\30DE\306B%0\3055\308C\307E\3059:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279736011914869118)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\306F\6B63\5E38\306B%0\3055\308C\307E\3057\305F:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280223940465869419)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0B\3078\30B9\30AF\30ED\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280224086577869420)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_language=>'ja'
,p_message_text=>unistr('\5148\982D\306B\30B9\30AF\30ED\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279271901605868833)
,p_name=>'APEX_WIZARD_FORM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D5\30A9\30FC\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280488399104869585)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279906809200869224)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\30AA\30D6\30B8\30A7\30AF\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280546704511869621)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D4\30A2\30FB\30DA\30FC\30B8\304C\5B58\5728\3057\307E\305B\3093')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280491667561869587)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F5C\6210\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280491802392869587)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\304B\3089\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280492096268869587)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30D6\30B8\30A7\30AF\30C8\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280154756952869376)
,p_name=>'APEX_WS_SETUP_DROP_TABLES'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280154041433869375)
,p_name=>'APEX_WS_SETUP_MSG1'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\308C\3089\306E\30AA\30D6\30B8\30A7\30AF\30C8\306F<b>%0</b>\30B9\30AD\30FC\30DE\3067\4F5C\6210\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280492188580869587)
,p_name=>'APEX_WS_SETUP_MSG10'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\308C\3089\306E\30AA\30D6\30B8\30A7\30AF\30C8\306F\3059\3067\306B<b>%0</b>\30B9\30AD\30FC\30DE\306B\5B58\5728\3057\3001\4ED6\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\3067\4F7F\7528\3055\308C\3066\3044\307E\3059\3002\51E6\7406\3092\7D9A\3051\308B\3068\3001<b>%0</b>\3067\4FDD\6709\3055\308C\3066\3044\308B\65E2\5B58\306EWeb\30B7\30FC\30C8\30FB\30AA\30D6\30B8\30A7\30AF\30C8\304C\3053\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306B\3082\95A2\9023\4ED8\3051\3089\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280492228646869587)
,p_name=>'APEX_WS_SETUP_MSG11'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\308C\3089\306E\30AA\30D6\30B8\30A7\30AF\30C8\306B\4F7F\7528\3059\308B\30B9\30AD\30FC\30DE\3092\9078\629E\3057\3066\304F\3060\3055\3044:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280492349696869588)
,p_name=>'APEX_WS_SETUP_MSG12'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F7F\7528\4E88\5B9A\306E\65E2\5B58\306E\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280493282260869588)
,p_name=>'APEX_WS_SETUP_MSG13'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B7\30FC\30C8\30FB\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\306F\6B21\306E\60C5\5831\3092\4F7F\7528\3057\3066\518D\5229\7528\3055\308C\307E\3059\3002\30EA\30AF\30A8\30B9\30C8\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280154194448869375)
,p_name=>'APEX_WS_SETUP_MSG2'
,p_message_language=>'ja'
,p_message_text=>unistr('\65B0\898F\30B9\30AD\30FC\30DE\3067Web\30B7\30FC\30C8\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\4F5C\6210\3059\308B\5834\5408\306F\3001<a href=%0>\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30B9\30AD\30FC\30DE\306E\30EA\30AF\30A8\30B9\30C8</a>\30FB\30A6\30A3\30B6\30FC\30C9\3092\4F7F\7528\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280154274788869375)
,p_name=>'APEX_WS_SETUP_MSG3'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B7\30FC\30C8\3092\5B9F\884C\3059\308B\306B\306F\3001\6B21\306E\30AA\30D6\30B8\30A7\30AF\30C8\304C\5FC5\8981\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280154345265869375)
,p_name=>'APEX_WS_SETUP_MSG5'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B7\30FC\30C8\30FB\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\306F\6B21\306E\60C5\5831\3092\4F7F\7528\3057\3066\4F5C\6210\3055\308C\307E\3059\3002\30EA\30AF\30A8\30B9\30C8\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280154454098869376)
,p_name=>'APEX_WS_SETUP_MSG6'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F5C\6210\3059\308B\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280154503751869376)
,p_name=>'APEX_WS_SETUP_MSG7'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B7\30FC\30C8\30FB\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\524A\9664\3057\3088\3046\3068\3057\3066\3044\307E\3059\3002\3053\308C\306B\3088\308A\3001\30EF\30FC\30AF\30B9\30DA\30FC\30B9\5185\306EWeb\30B7\30FC\30C8\30FB\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3068\3001Web\30B7\30FC\30C8\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8\3092\542B\3080\5185\90E8\30C7\30FC\30BF\304C\524A\9664\3055\308C\307E\3059\3002\7D9A\884C\3057\307E\3059\304B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280154816094869376)
,p_name=>'APEX_WS_SETUP_MSG8'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B7\30FC\30C8\3092\6B63\3057\304F\5B9F\884C\3059\308B\306B\306F\3001\6B21\306E\7121\52B9\306A\30AA\30D6\30B8\30A7\30AF\30C8\3092\4FEE\6B63\3059\308B\5FC5\8981\304C\3042\308A\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280491707238869587)
,p_name=>'APEX_WS_SETUP_MSG9'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306B\5BFE\3059\308BWeb\30B7\30FC\30C8\5B9A\7FA9\3092\524A\9664\3057\3088\3046\3068\3057\3066\3044\307E\3059\3002Web\30B7\30FC\30C8\30FB\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\306F\4ED6\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\3067\3082\4F7F\7528\3055\308C\3066\3044\308B\305F\3081\3001\524A\9664\3055\308C\307E\305B\3093\3002\3053\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306B\95A2\9023\4ED8\3051\3089\308C\305F\30EC\30B3\30FC\30C9\306F\524A\9664\3055\308C\307E\3059\3002\7D9A\884C\3057\307E\3059\304B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280154949500869376)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30D6\30B8\30A7\30AF\30C8\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280155044048869376)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30D6\30B8\30A7\30AF\30C8\30FB\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280154632713869376)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30AD\30FC\30DE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280491577370869587)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F7F\7528\3055\308C\308B\65E2\5B58\306E\30AA\30D6\30B8\30A7\30AF\30C8')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279283235849868840)
,p_name=>'API_PRECONDITION_VIOLATED'
,p_message_language=>'ja'
,p_message_text=>unistr('API\306E\524D\63D0\6761\4EF6\9055\53CD')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279441570994868940)
,p_name=>'APP.SETTING.CANNOT.GET'
,p_message_language=>'ja'
,p_message_text=>unistr('\95A2\9023\4ED8\3051\3089\308C\305F\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3\304C\7121\52B9\306B\306A\3063\3066\3044\308B\3068\304D\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A%0\306E\5024\3092\53D6\5F97\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279441472867868940)
,p_name=>'APP.SETTING.CANNOT.SET'
,p_message_language=>'ja'
,p_message_text=>unistr('\95A2\9023\4ED8\3051\3089\308C\305F\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3\304C\7121\52B9\306B\306A\3063\3066\3044\308B\3068\304D\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A%0\306E\5024\3092\8A2D\5B9A\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280518283885869603)
,p_name=>'APP.SETTING.INVALID.VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A%0\306E\5024\304C\7121\52B9\3067\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280518125444869603)
,p_name=>'APP.SETTING.NOT.DEFINED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30AF\30A8\30B9\30C8\3057\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A%0\306F\5B9A\7FA9\3055\308C\3066\3044\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280518316918869604)
,p_name=>'APP.SETTING.VALUE.NOT.NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A%0\306Fnull\5024\306B\8A2D\5B9A\3067\304D\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279334629194868873)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A08\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279334594792868873)
,p_name=>'APPLICACTION_PROCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279899852024869219)
,p_name=>'APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279980056854869269)
,p_name=>'APPLICATION BUILDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279804563524869160)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A08\7B97\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279807239433869162)
,p_name=>'APPLICATION IMAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A4\30E1\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279804605500869160)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279731351465869115)
,p_name=>'APPLICATIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279877006990869204)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279777398727869143)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279817879459869168)
,p_name=>'APPLICATION_ALIAS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5225\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279815891271869167)
,p_name=>'APPLICATION_DELETED'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664\3055\308C\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279266073417868829)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\958B\767A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279816844784869167)
,p_name=>'APPLICATION_HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\793A\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279773944589869141)
,p_name=>'APPLICATION_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\756A\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279663298657869074)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3ID\306F\4E88\7D04\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279663110211869074)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3ID\300D\306F\6B63\306E\6574\6570\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280195301955869401)
,p_name=>'APPLICATION_IMAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A4\30E1\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279847183966869186)
,p_name=>'APPLICATION_ITEM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279363630655868891)
,p_name=>'APPLICATION_ITEMS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279329044760868869)
,p_name=>'APPLICATION_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279817773004869168)
,p_name=>'APPLICATION_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280546331118869620)
,p_name=>'APPLICATION_NAMES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279940128459869244)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30AA\30FC\30D0\30FC\30E9\30A4\30C9ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279815392530869167)
,p_name=>'APPLICATION_OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280546239034869620)
,p_name=>'APPLICATION_PAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279451776234868946)
,p_name=>'APPLICATION_SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279815533317869167)
,p_name=>'APPLICATION_STATUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30B9\30C6\30FC\30BF\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279901893381869221)
,p_name=>'APPLICATION_VERSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30D0\30FC\30B8\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279281630015868839)
,p_name=>'APPLICATION_X'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279761135007869134)
,p_name=>'APPROVED'
,p_message_language=>'ja'
,p_message_text=>unistr('\627F\8A8D\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279822013239869171)
,p_name=>'APP_SUCCESS_MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304C\6B63\5E38\306B\4F5C\6210\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280548975946869622)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279316080146868861)
,p_name=>'APP_TYPE_DATABASE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279316101518868861)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_language=>'ja'
,p_message_text=>unistr('\751F\7523\6027\307E\305F\306F\30B5\30F3\30D7\30EB\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279843512693869184)
,p_name=>'APP_TYPE_PACKAGED_WS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30F3\30D7\30EBWeb\30B7\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279315908782868861)
,p_name=>'APP_TYPE_WEBSHEET'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279760627988869133)
,p_name=>'ARCHIVED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30FC\30AB\30A4\30D6\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279329341268868870)
,p_name=>'ARCHIVELOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30B0\30FB\30A2\30FC\30AB\30A4\30D6: \30AA\30F3')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279580256124869024)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F15\6570\306B\30C1\30A7\30C3\30AF\30B5\30E0\304C\5FC5\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279676038860869082)
,p_name=>'ARGUMENT_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F15\6570\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279676299542869082)
,p_name=>'ARGUMENT_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F15\6570\306E\30BF\30A4\30D7')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279754585573869130)
,p_name=>'ASAP'
,p_message_language=>'ja'
,p_message_text=>unistr('\3067\304D\308B\3060\3051\65E9\304F')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279751111896869127)
,p_name=>'ASSIGNED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5272\5F53\3066\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279449346789868945)
,p_name=>'ASSIGNEE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5272\5F53\3066\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280573814991869637)
,p_name=>'ASSIGN_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5272\5F53\3066%0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279509972217868981)
,p_name=>'ASSOCIATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\95A2\9023\4ED8\3051')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279451248238868946)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_language=>'ja'
,p_message_text=>unistr('\95A2\9023\4ED8\3051\3089\308C\305F\6A5F\80FD')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279782502495869147)
,p_name=>'ATTACHMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280590270098869647)
,p_name=>'AT_RISK_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\984C\3092\5F15\304D\8D77\3053\3059\53EF\80FD\6027')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279479825488868963)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30AB\30B9\30BF\30E0\8A8D\8A3C\30AA\30D7\30B7\30E7\30F3\3092\8A8D\8A3C\30B9\30AD\30FC\30E0\306B\79FB\884C\3057\3088\3046\3068\3057\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279479321719868963)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\884C\306E\8A8D\8A3C\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279479719042868963)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30B9\30BF\30E0\8A8D\8A3C\30D5\30A1\30F3\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279479481556868963)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30B0\30A4\30F3\30FB\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279479644512868963)
,p_name=>'AUTH.LOGIN_URL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30B0\30A4\30F3URL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279479598597868963)
,p_name=>'AUTH.NONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\306A\3057')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279484953262868966)
,p_name=>'AUTHENTICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279805589076869161)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\30D5\30A1\30F3\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279805234479869160)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279500043024868975)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3%0\304B\3089\8A8D\8A3C\30B9\30AD\30FC\30E0\3092\524A\9664\3057\3088\3046\3068\3057\3066\3044\307E\3059\3002 \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304C\73FE\5728SCHEME\8A8D\8A3C\3092\4F7F\7528\3057\3066\3044\306A\3044\304B\3001\307E\305F\306F\30B9\30AD\30FC\30E0\304C\73FE\884C\306E\8A8D\8A3C\30B9\30AD\30FC\30E0\3067\306A\3044\5834\5408\306F\3001\30B9\30AD\30FC\30E0\3092\524A\9664\3057\3066\3082\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\64CD\4F5C\306B\5F71\97FF\306F\3042\308A\307E\305B\3093\3002\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304CSCHEME\8A8D\8A3C\3092\4F7F\7528\3057\3066\304A\308A\3001\305D\308C\304C\73FE\884C\306E\8A8D\8A3C\30B9\30AD\30FC\30E0\3067\3042\308B\5834\5408\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306F\30C7\30D5\30A9\30EB\30C8\306E\8A8D\8A3C\30B9\30AD\30FC\30E0\3092\4F7F\7528\3057\3066\5B9F\884C\3092\7D99\7D9A\3057\307E\3059\3002\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306F\3001\300C\516C\958B\300D\8CC7\683C\8A3C\660E\691C\8A3C\3092\884C\3046\7D44\8FBC\307F\30ED\30B0\30A4\30F3\30FB\30DA\30FC\30B8\3092\4F7F\7528\3057\307E\3059(\3059\3079\3066\306E\30E6\30FC\30B6\30FC\304C\30A2\30D7\30EA\30B1')
||unistr('\30FC\30B7\30E7\30F3\3092\5B9F\884C\3067\304D\307E\3059)\3002 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279501972696868976)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\3053\306E\8A8D\8A3C\30B9\30AD\30FC\30E0\3092\4F7F\7528\3059\308B\306B\306F\3001\300C\30AB\30EC\30F3\30C8\5316\300D\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280009889706869287)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_language=>'ja'
,p_message_text=>unistr('Application Express\30A2\30AB\30A6\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279262626554868827)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'ja'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280009979386869287)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30B9\30BF\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280010236349869287)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\306A\3057')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280010069764869287)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30AB\30A6\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280443230123869557)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('HTTP\30D8\30C3\30C0\30FC\5909\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280010488306869288)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_language=>'ja'
,p_message_text=>'Oracle Application Server Single Sign-On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280010139109869287)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_language=>'ja'
,p_message_text=>unistr('LDAP\30C7\30A3\30EC\30AF\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280010393845869287)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\516C\958B\8CC7\683C\8A3C\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279252892613868821)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_language=>'ja'
,p_message_text=>unistr('SAML\30B5\30A4\30F3\30A4\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279291307684868846)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30B7\30E3\30EB\30FB\30B5\30A4\30F3\30A4\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279848250483869187)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\30B9\30AD\30FC\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279805145020869160)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279262735664868827)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'ja'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279281860266868839)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('EXISTS SQL\554F\5408\305B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279281947846868840)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30FC\30EB\3092\623B\3059PL/SQL\30D5\30A1\30F3\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279659005079869072)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30FC\30EB\307E\305F\306F\30B0\30EB\30FC\30D7\5185\306B\3042\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279659158286869072)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30FC\30EB\307E\305F\306F\30B0\30EB\30FC\30D7\5185\306B\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279282019151868840)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F0F1\306E\30A2\30A4\30C6\30E0\306E\5024 = \5F0F2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279282108743868840)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F0F1\306E\30A2\30A4\30C6\30E0\304CNOT NULL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279282293941868840)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F0F1\306E\30A2\30A4\30C6\30E0\304CNULL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279282337457868840)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F0F1\306E\30A2\30A4\30C6\30E0\306E\5024 != \5F0F2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279282480091868840)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('NOT EXISTS SQL\554F\5408\305B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279282555837868840)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F0F1\306E\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\5024 = \5F0F2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279282649602868840)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F0F1\306E\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\5024 != \5F0F2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279347653658868881)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30DA\30FC\30B8\30FB\30D3\30E5\30FC\3092\8A55\4FA1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279347760727868881)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3\3054\3068\306B1\56DE\8A55\4FA1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279285035591868842)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AB\30A6\30F3\30C8\306E\671F\9650\5207\308C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279284973974868841)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AB\30A6\30F3\30C8\304C\30ED\30C3\30AF\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279285355880868842)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30B0\30A4\30F3\8A66\884C\306E\6700\5927\56DE\6570\3092\8D85\3048\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279285408695868842)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0D\660E\306A\5185\90E8\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279285207017868842)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30B9\30EF\30FC\30C9\306E\521D\56DE\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279285176780868842)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7121\52B9\306A\30D1\30B9\30EF\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279284789926868841)
,p_name=>'AUTH_SUCCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\6210\529F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279284812319868841)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0D\660E\306A\30E6\30FC\30B6\30FC\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279399629892868914)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0D\660E\306A\30EF\30FC\30AF\30B9\30DA\30FC\30B9\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279410184404868921)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0D\660E\306A\30EF\30FC\30AF\30B9\30DA\30FC\30B9\540D: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279553924417869008)
,p_name=>'AUTOCOMMIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30DF\30C3\30C8\6587\306F\9069\7528\3055\308C\307E\305B\3093\3002\3059\3079\3066\306E\6587\306F\81EA\52D5\7684\306B\30B3\30DF\30C3\30C8\3055\308C\307E\3059\3002')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279877630203869205)
,p_name=>'AUTOPROVISION_MODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30D3\30B8\30E7\30CB\30F3\30B0\30FB\30E2\30FC\30C9')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279260366266868826)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\521D\306E\30A2\30A4\30C6\30E0')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279903585890869222)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_language=>'ja'
,p_message_text=>unistr('\53EF\7528\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279289909094868845)
,p_name=>'AVAILABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F7F\7528\53EF\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280107201866869347)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\767A\8005\306E\307F\4F7F\7528\53EF\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280107178155869347)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\767A\8005\30C4\30FC\30EB\30D0\30FC\3067\4F7F\7528\53EF\80FD')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279778153526869144)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E73\5747\30EC\30F3\30C0\30EA\30F3\30B0\6642\9593(\79D2)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279348424215868882)
,p_name=>'BACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\623B\308B')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279759095128869132)
,p_name=>'BAR_CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\68D2\30B0\30E9\30D5')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280180748992869392)
,p_name=>'BASIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\57FA\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279303754195868853)
,p_name=>'BASIC_DEVELOPER'
,p_message_language=>'ja'
,p_message_text=>unistr('\57FA\672C\958B\767A\8005')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279738345030869120)
,p_name=>'BEFORE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280551639685869624)
,p_name=>'BEFORE LIST ENTRY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30B9\30C8\524D\306E\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280572574167869636)
,p_name=>'BEFORE_FIRST'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\521D\306E\524D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279808424621869162)
,p_name=>'BIND_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB\306E\30D0\30A4\30F3\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279807783675869162)
,p_name=>'BIND_VARIABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30A4\30F3\30C9\5909\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279807872131869162)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30A4\30F3\30C9\5909\6570\30E9\30D9\30EB')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279823623704869172)
,p_name=>'BLACK_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\9ED2\8272\306E\30C6\30AD\30B9\30C8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279267188194868830)
,p_name=>'BLANK'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A7A\767D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279781754156869146)
,p_name=>'BLOB_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('BLOB\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279941845309869245)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A6\30F3\30ED\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279318894976868863)
,p_name=>'BLOB_FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('BLOB\30D5\30A9\30FC\30DE\30C3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279942250302869246)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279941978417869245)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_language=>'ja'
,p_message_text=>'DOWNLOAD'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279942009078869246)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_language=>'ja'
,p_message_text=>'IMAGE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279942154726869246)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30F3\30E9\30A4\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279782728724869147)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_language=>'ja'
,p_message_text=>unistr('BLOB\30D5\30A9\30FC\30DE\30C3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279782218589869146)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('BLOB\6700\7D42\66F4\65B0\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279781629482869146)
,p_name=>'BLOB_TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('BLOB\8868')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279823589297869172)
,p_name=>'BLUE_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\9752\8272\306E\30C6\30AD\30B9\30C8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279798796065869156)
,p_name=>'BRANCH CONDITION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30E9\30F3\30C1\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279352080453868884)
,p_name=>'BRANCHES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30E9\30F3\30C1')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279576111210869021)
,p_name=>'BREADCRUMB'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279739046294869120)
,p_name=>'BREADCRUMB LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30E9\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279739143726869120)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\306E\8A73\7D30\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279576235278869021)
,p_name=>'BREADCRUMBS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279832185394869177)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30A8\30F3\30C8\30EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279847366372869186)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30A8\30F3\30C8\30EA: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279663461012869074)
,p_name=>'BREADCRUMB_PAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279747270010869125)
,p_name=>'BREADCRUMB_REGION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30EA\30FC\30B8\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279412405724868922)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\304C\6B63\5E38\306B\4F5C\6210\3055\308C\307E\3057\305F\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279741672214869122)
,p_name=>'BROWSE_ICON'
,p_message_language=>'ja'
,p_message_text=>unistr('\53C2\7167\30A2\30A4\30B3\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279741490673869122)
,p_name=>'BROWSE_PACKAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D1\30C3\30B1\30FC\30B8\3092\53C2\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279675743951869082)
,p_name=>'BROWSE_TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\3092\53C2\7167')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279270420364868832)
,p_name=>'BUFFER CACHE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30C3\30D5\30A1\30FB\30AD\30E3\30C3\30B7\30E5')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279755029880869130)
,p_name=>'BUG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279779289480869145)
,p_name=>'BUGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279801738851869158)
,p_name=>'BUGS_ASSIGNED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5272\5F53\3066\6E08\306E\30D0\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279840915585869182)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5272\5F53\3066\6E08\306E\30D0\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279299099247868850)
,p_name=>'BUGS_CLOSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30ED\30FC\30BA\3057\305F\30D0\30B0(%0 / %1):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280216486765869415)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30B0\306E\30AF\30ED\30FC\30BA\7387(%0/%1):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279841085396869182)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\672A\5272\5F53\3066\306E\30D0\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279841198262869182)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5\4ED8\5225\306E\4FEE\6B63\304C\3042\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280216827804869415)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30B0: %1/%0\304C\30AF\30ED\30FC\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280580798009869642)
,p_name=>'BUG_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30B0: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279795068583869154)
,p_name=>'BUILD QUERY'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\5408\305B\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279262238361868827)
,p_name=>'BUILDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D3\30EB\30C0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279901010408869220)
,p_name=>'BUILDER.PLUGINS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30B0\30A4\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279896536898869217)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_language=>'ja'
,p_message_text=>unistr('[\975E\30B5\30DD\30FC\30C8]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280191293699869398)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30E1\30C3\30BB\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279492283752868971)
,p_name=>'BUILD_OPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279965474167869260)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280579462958869641)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D3\30EB\30C9\30FB\30B9\30C6\30FC\30BF\30B9: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279966306924869260)
,p_name=>'BUILD_VERSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D3\30EB\30C9\30FB\30D0\30FC\30B8\30E7\30F3')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279834578544869178)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D44\8FBC\307F\30EC\30DD\30FC\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279737500314869119)
,p_name=>'BUTTON'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279738249478869120)
,p_name=>'BUTTON LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3\30FB\30E9\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279943533391869246)
,p_name=>'BUTTON.ADD'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279278808340868838)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\3057\305F\30DC\30BF\30F3\306E\30DC\30BF\30F3\5C5E\6027\306BID\3092\542B\3081\308B\3053\3068\306F\3067\304D\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279278733193868837)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\3057\305F\30DC\30BF\30F3\306F\3001\30A2\30AF\30B7\30E7\30F3\304C\300C\52D5\7684\30A2\30AF\30B7\30E7\30F3\306B\3088\308B\5B9A\7FA9\300D\306B\8A2D\5B9A\3055\308C\3066\3044\308B\30DC\30BF\30F3\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279279090953868838)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\3057\305F\30DC\30BF\30F3\306F#BUTTON_ID#\7F6E\63DB\6587\5B57\5217\304C\542B\307E\308C\3066\3044\306A\3044\300C\30DC\30BF\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\300D\3092\4F7F\7528\3057\3066\3044\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279943377585869246)
,p_name=>'BUTTON.DELETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279352399526868884)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279328596060868869)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\554F\5408\305B\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279315726087868861)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3\30FB\30EA\30AF\30A8\30B9\30C8\306E\30BD\30FC\30B9\30FB\30BF\30A4\30D7\304C\300C\5E38\306BNULL\300D\3067\306A\3044\5834\5408\3001\30DC\30BF\30F3\30FB\30EA\30AF\30A8\30B9\30C8\306F\3059\3079\3066\306E\30DC\30BF\30F3\30FB\30EA\30AF\30A8\30B9\30C8\306E\30BD\30FC\30B9\30FB\30BF\30A4\30D7\306B\6307\5B9A\3055\308C\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279316468357868861)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\30DC\30BF\30F3\30FB\30EA\30AF\30A8\30B9\30C8\306E\30BD\30FC\30B9\30FB\30BF\30A4\30D7\300D\306B\5024\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279352418390868884)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_language=>'ja'
,p_message_text=>unistr('\300CURL\30BF\30FC\30B2\30C3\30C8\300D\306B\5024\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279281386395868839)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\304C\300C\52D5\7684\30A2\30AF\30B7\30E7\30F3\306B\3088\308B\5B9A\7FA9\300D\306E\5834\5408\3001\30DC\30BF\30F3\5C5E\6027\306BID\3092\542B\3081\308B\3053\3068\306F\3067\304D\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279354042990868885)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30E1\30FC\30B8\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279354189490868885)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30BF\30A4\30EB\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279353955503868885)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279281212226868839)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3\30FB\30B9\30BF\30A4\30EB\304C\300C\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30D9\30FC\30B9\306E\30DC\30BF\30F3\300D\3067\30A2\30AF\30B7\30E7\30F3\304C\300C\52D5\7684\30A2\30AF\30B7\30E7\30F3\306B\3088\308B\5B9A\7FA9\300D\306E\5834\5408\3001\9078\629E\3057\305F\30DC\30BF\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306B#BUTTON_ID#\7F6E\63DB\6587\5B57\5217\304C\542B\307E\308C\3066\3044\308B\5FC5\8981\304C\3042\308A\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279268834908868831)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3(\30DA\30FC\30B8: %0\3001\52D5\7684\30A2\30AF\30B7\30E7\30F3: ''%1''\3001\30A2\30AF\30B7\30E7\30F3: ''%2\3001\5C5E\6027: ''\5F71\97FF\3092\53D7\3051\308B\8981\7D20'')\3067\53C2\7167\3055\308C\3066\3044\308B\305F\3081\3001\30DC\30BF\30F3\3092\524A\9664\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279268718264868831)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\52D5\7684\30A2\30AF\30B7\30E7\30F3(\30DA\30FC\30B8: %0\3001\52D5\7684\30A2\30AF\30B7\30E7\30F3: ''%1''\3001\5C5E\6027: ''\30BF\30A4\30DF\30F3\30B0'')\3067\53C2\7167\3055\308C\3066\3044\308B\305F\3081\3001\30DC\30BF\30F3\3092\524A\9664\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279943439911869246)
,p_name=>'BUTTON.SUBMIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279939319114869244)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_language=>'ja'
,p_message_text=>unistr('"onclick"\5C5E\6027\3067\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279942842343869246)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_language=>'ja'
,p_message_text=>unistr('"href"\5C5E\6027\3067\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279352247555868884)
,p_name=>'BUTTONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279808961979869163)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279261147242868826)
,p_name=>'BUTTON_CSS_CLASSES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3\306ECSS\30AF\30E9\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279459644291868951)
,p_name=>'BUTTON_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\751F\6210\3055\308C\305F\30DC\30BF\30F3\306EID\306F\3001\5B9A\7FA9\3055\308C\3066\3044\308B\5834\5408\306F\30DC\30BF\30F3\306E\9759\7684ID\3001\305D\3046\3067\306A\3051\308C\3070''B'' || [\5185\90E8\30DC\30BF\30F3ID]\306E\5F62\5F0F\306E\5185\90E8\751F\6210\3055\308C\305FID\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280579204934869641)
,p_name=>'BUTTON_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279814165307869166)
,p_name=>'BUTTON_TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279349190168868882)
,p_name=>'BYTES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D0\30A4\30C8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279754677288869130)
,p_name=>'BY_NEXT_PATCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\30D1\30C3\30C1\307E\3067')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279754792903869130)
,p_name=>'BY_NEXT_RELEASE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\30EA\30EA\30FC\30B9\307E\3067')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280678687454869702)
,p_name=>'CA.ABOUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\60C5\5831')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280644964393869681)
,p_name=>'CA.ABOUT.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\60C5\5831\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280644827563869681)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8AAC\660E\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30D0\30FC\30B8\30E7\30F3\3001\304A\3088\3073\30DA\30FC\30B8\6570\304C\8A18\8F09\3055\308C\305F\300C\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3064\3044\3066\300D\30DA\30FC\30B8\3092\542B\3081\307E\3059\3002'),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279469724476868957)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C6\30F3\30C4\30FB\30B3\30F3\30C6\30CA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280678823295869702)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\60C5\5831\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280678946315869702)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\95A2\3059\308B\30C6\30AD\30B9\30C8\306F\3001\3053\3053\306B\914D\7F6E\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280678504008869702)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30DA\30FC\30B8\306B\3064\3044\3066')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280690827483869709)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30D7\30EC\30D3\30E5\30FC\30FB\30EA\30EA\30FC\30B9\306B\3064\3044\3066')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280645285890869681)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280681185052869703)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30A2\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280670632056869697)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\69CB\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280643626853869680)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30FC\30EB\30FB\30D9\30FC\30B9\30FB\30E6\30FC\30B6\30FC\8A8D\53EF\306E\6709\52B9\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280645334697869681)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30ED\30FC\30EB\30FB\30D9\30FC\30B9\30FB\30E6\30FC\30B6\30FC\8A8D\8A3C\3092\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\7D44\307F\8FBC\307F\307E\3059\3002'),
unistr('\30E6\30FC\30B6\30FC\306F\3001\7BA1\7406\8005\3001\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF\307E\305F\306F\30EA\30FC\30C0\30FC\3068\3057\3066\5B9A\7FA9\3067\304D\307E\3059\3002'),
unistr('\305D\306E\5F8C\3001\30DA\30FC\30B8\3001\30E1\30CB\30E5\30FC\30FB\30A8\30F3\30C8\30EA\3001\30EA\30FC\30B8\30E7\30F3\3001\5217\3001\30A2\30A4\30C6\30E0\3001\30DC\30BF\30F3\306A\3069\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5168\4F53\306B\308F\305F\308B\69D8\3005\306A\30B3\30F3\30DD\30FC\30CD\30F3\30C8\3092\5BFE\8C61\3068\3057\3066\3001\7570\306A\308B\30ED\30FC\30EB\306B\7570\306A\308B\30A2\30AF\30BB\30B9\6A29\3092\7C21\5358\306B\5B9A\7FA9\3067\304D\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\542B\307E\308C\307E\3059:'),
'<ul>',
unistr('<li>\30A2\30AF\30BB\30B9\5236\5FA1\6A5F\80FD\3078\306E\30EA\30F3\30AF\304C\542B\307E\308C\308B\7BA1\7406\30DA\30FC\30B8\30FB\30EA\30FC\30B8\30E7\30F3</li>'),
unistr('<li>\30A2\30AF\30BB\30B9\5236\5FA1\3092\7BA1\7406\3059\308B\305F\3081\306E\30E6\30FC\30B6\30FC\8868</li>'),
unistr('<li>\8A8D\8A3C\3055\308C\305F\30E6\30FC\30B6\30FC\306E\30A2\30AF\30BB\30B9\30FB\30EC\30D9\30EB\3092\8A2D\5B9A\3059\308B\305F\3081\306E\69CB\6210\30DA\30FC\30B8</li>'),
unistr('<li>\30E6\30FC\30B6\30FC\540D\304C\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3067\3042\308B\304B\3069\3046\304B\3092\6307\5B9A\3059\308B\305F\3081\306E\69CB\6210\30DA\30FC\30B8</li>'),
unistr('<li>\30E6\30FC\30B6\30FC\30FB\30A2\30AF\30BB\30B9\3092\30EC\30DD\30FC\30C8\304A\3088\3073\7DE8\96C6\3059\308B\305F\3081\306E\30E6\30FC\30B6\30FC\30FB\30A2\30AF\30BB\30B9\30FB\30DA\30FC\30B8\306E\7BA1\7406</li>'),
unistr('<li>\5358\4E00\306E\30E6\30FC\30B6\30FC\3092\8FFD\52A0\3067\304D\308B\30E6\30FC\30B6\30FC\30FB\30DA\30FC\30B8\306E\8FFD\52A0</li>'),
unistr('<li>\8907\6570\306E\30E6\30FC\30B6\30FC\3092\8FFD\52A0\3067\304D\308B\8907\6570\30E6\30FC\30B6\30FC\30FB\30DA\30FC\30B8\306E\8FFD\52A0(\96FB\5B50\30E1\30FC\30EB\30FB\30E6\30FC\30B6\30FC\540D\306E\307F)</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280669541198869696)
,p_name=>'CA.ACCESS.ROLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280670290676869697)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\30FB\30ED\30FC\30EBID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279389128827868907)
,p_name=>'CA.ACCESS.ROLES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280669683172869696)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AB\30A6\30F3\30C8\304C\30ED\30C3\30AF\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279416901928868925)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_language=>'ja'
,p_message_text=>unistr('\78BA\8A8D\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280680918597869703)
,p_name=>'CA.ACL.INFORMATION'
,p_message_language=>'ja'
,p_message_text=>unistr('ACL\60C5\5831')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280681638107869704)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A29\9650\304C\4E0D\5341\5206\3067\3059\3002\30E6\30FC\30B6\30FC\306F\7BA1\7406\8005\3067\306F\3042\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280681776649869704)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\6A29\3092\4ED8\4E0E\3055\308C\3066\3044\306A\3044\304B\3001\30A2\30AB\30A6\30F3\30C8\304C\30ED\30C3\30AF\3055\308C\3066\3044\308B\305F\3081\3001\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8868\793A\306F\8A31\53EF\3055\308C\307E\305B\3093\3002\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\306B\9023\7D61\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280681817738869704)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A29\9650\304C\4E0D\5341\5206\3067\3059\3002\30E6\30FC\30B6\30FC\306F\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF\3067\306F\3042\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280671322401869697)
,p_name=>'CA.ACL.SAVED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\306E\8A2D\5B9A\304C\4FDD\5B58\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280676009278869700)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\30FB\30DC\30BF\30F3HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280674998017869700)
,p_name=>'CA.ACTION.LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\30FB\30E9\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280675063025869700)
,p_name=>'CA.ACTION.LINK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\30FB\30EA\30F3\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280677624132869701)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\30FB\30EA\30F3\30AFHTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280663195058869692)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\304C\51E6\7406\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280668645636869696)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6642\9593\3054\3068\306E\30A2\30AF\30C6\30A3\30D3\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280702943478869717)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30C0\30C3\30B7\30E5\30DC\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280645488305869681)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280644644118869681)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3\304A\3088\3073\30A8\30E9\30FC\30FB\30EC\30DD\30FC\30C8\3092\542B\3081\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280645529390869681)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3\306B\95A2\3059\308B\591A\6570\306E\30EC\30DD\30FC\30C8\3092\542B\3081\307E\3059\3002\6700\3082\30A2\30AF\30C6\30A3\30D6\306A\30E6\30FC\30B6\30FC\3001\6700\3082\4F7F\7528\3055\308C\3066\3044\308B\30DA\30FC\30B8\3001\5404\30DA\30FC\30B8\306E\30D1\30D5\30A9\30FC\30DE\30F3\30B9\3001\304A\3088\3073\767A\751F\3057\305F\30A8\30E9\30FC\304C\7279\5B9A\3055\308C\308B\305F\3081\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5229\7528\72B6\6CC1\3068\6539\5584\3059\308B\9818\57DF\306E\628A\63E1\306B\5F79\7ACB\3061\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\3082\306E\304C\542B\307E\308C\307E\3059\3002'),
'<ul>',
unistr('<li>\4E0A\4F4D\30E6\30FC\30B6\30FC\30FB\30EC\30DD\30FC\30C8</li>'),
unistr('<li>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A8\30E9\30FC\30FB\30ED\30B0\30FB\30EC\30DD\30FC\30C8</li>'),
unistr('<li>\30DA\30FC\30B8\30FB\30D1\30D5\30A9\30FC\30DE\30F3\30B9\3001\30DA\30FC\30B8\5225\306E\30A2\30AF\30C6\30A3\30D3\30C6\30A3\3068\30D1\30D5\30A9\30FC\30DE\30F3\30B9</li>'),
unistr('<li>\30DA\30FC\30B8\5225\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30EC\30DD\30FC\30C8</li>'),
unistr('<li>\30DA\30FC\30B8\30FB\30D3\30E5\30FC\306E\8A73\7D30\30EC\30DD\30FC\30C8</li>'),
'',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279791332296869152)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9F\969B\306E\958B\59CB\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280680876567869703)
,p_name=>'CA.ADD'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280676210110869700)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280693830085869711)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_language=>'ja'
,p_message_text=>unistr('\8907\6570\30E6\30FC\30B6\30FC\306E\8FFD\52A0 - \30B9\30C6\30C3\30D72')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280679108681869702)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_language=>'ja'
,p_message_text=>unistr('\65B0\898F%0\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280662131369869692)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\901A\77E5\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280534652222869613)
,p_name=>'CA.ADD.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280670301228869697)
,p_name=>'CA.ADD.USER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280694244370869711)
,p_name=>'CA.ADD.USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280647014313869682)
,p_name=>'CA.ADDING.PAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280647575133869683)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('<p><strong>\300C\30DA\30FC\30B8\306E\8FFD\52A0\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\30DA\30FC\30B8\3092\8FFD\52A0\3057\307E\3059\3002\6B21\306B\3001\30DA\30FC\30B8\30FB\30BF\30A4\30D7(\7A7A\767D\3001\30C1\30E3\30FC\30C8\3001\30D5\30A9\30FC\30E0\3001\30EC\30DD\30FC\30C8\306A\3069)\3092\9078\629E\3057\3066\305D\306E\5C5E\6027\3092\5B9A\7FA9\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002\5834\5408\306B\3088\3063\3066\306F\3001\6709\52B9\306A\8868\307E\305F\306F\30D3\30E5\30FC\3092\6307\5B9A\3057\305F\308A\3001SQL\30EF\30FC\30AF\30B7\30E7\30C3\30D7\3092\4F7F\7528\3057\3066\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306B\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\6E96\5099\3057\305F\308A\3059\308B\5FC5\8981\3082\3042\308A\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280677071142869701)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279790659200869151)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0\60C5\5831')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280670097994869696)
,p_name=>'CA.ADDRESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F4F\6240')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280650258388869684)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280650863160869685)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A8D\8A3C\3055\308C\305F\30E6\30FC\30B6\30FC\306E\30A2\30AF\30BB\30B9\30FB\30EC\30D9\30EB\306E\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280649310507869684)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280650315948869684)
,p_name=>'CA.ADMIN.ADD'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280652061479869685)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280650777259869684)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279826336385869173)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\69CB\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279937073777869243)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280685634805869706)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280685776501869706)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280648963124869683)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\9078\629E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280649091030869683)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30EB\30C3\30AF\30FB\30A2\30F3\30C9\30FB\30D5\30A3\30FC\30EB\306E\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280648652083869683)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\69CB\6210\30AA\30D7\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280648576209869683)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\6A5F\80FD\306E\6709\52B9\5316\307E\305F\306F\7121\52B9\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280649610562869684)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A8\30E9\30FC\30FB\30ED\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280649791390869684)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3088\3063\3066\30ED\30B0\306B\8A18\9332\3055\308C\308B\30A8\30E9\30FC\306E\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280649160313869684)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280649208358869684)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\3068\77ED\3044\8AAC\660E\306E\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280648757185869683)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280648825428869683)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\66F4\65B0\306E\30EA\30B9\30C8\306E\4FDD\6301')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280648255333869683)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\69CB\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280650639789869684)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280701724784869716)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30C3\30B7\30E5\30DC\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280701696035869716)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3\30FB\30E1\30C8\30EA\30C3\30AF\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280653781650869686)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\306E\30BF\30A4\30E0\30BE\30FC\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280653851217869686)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30C7\30D5\30A9\30EB\30C8\30FB\30BF\30A4\30E0\30BE\30FC\30F3\306E\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280651505107869685)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280653939281869686)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280654043207869687)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\3092\9001\4FE1\3059\308B\304B\3069\3046\304B\3068\3001\9001\4FE1\3059\308B\5834\5408\306F\305D\306E\8FD4\4FE1\5148\306E\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280651081632869685)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280651300057869685)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280651427232869685)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB\3092\8A31\53EF\3059\308B\304B\3069\3046\304B\3092\7BA1\7406\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280651118827869685)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30D5\30A3\30FC\30C9\30D0\30C3\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280651255746869685)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E6\30FC\30B6\30FC\306B\3088\3063\3066\9001\4FE1\3055\308C\305F\3059\3079\3066\306E\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306E\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280651607116869685)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280651762308869685)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3088\3063\3066\4F7F\7528\3055\308C\308B\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306EHTML\3068CSS\306E\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280648394969869683)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280648456447869683)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DB\30FC\30E0\30DA\30FC\30B8\306B\901A\77E5\3092\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280686377295869707)
,p_name=>'CA.ADMIN.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280649811075869684)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30D1\30D5\30A9\30FC\30DE\30F3\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280649940338869684)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30DA\30FC\30B8\5225\306E\30A2\30AF\30C6\30A3\30D3\30C6\30A3\3068\30D1\30D5\30A9\30FC\30DE\30F3\30B9\306E\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280650097628869684)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30D3\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280650108817869684)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\65E5\3068\7D4C\904E\6642\9593\3092\542B\3080\30E6\30FC\30B6\30FC\5225\306E\5404\30DA\30FC\30B8\30FB\30D3\30E5\30FC\306E\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280650529917869684)
,p_name=>'CA.ADMIN.READERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30C0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280694909697869712)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280695032103869712)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30D9\30FC\30B9\306E\96FB\5B50\30E1\30FC\30EB\3092\9001\4FE1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280649450133869684)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C8\30C3\30D7\30FB\30E6\30FC\30B6\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280649590375869684)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\3054\3068\306B\96C6\8A08\3055\308C\305F\30DA\30FC\30B8\30FB\30D3\30E5\30FC\306E\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280650451020869684)
,p_name=>'CA.ADMIN.USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280650999283869685)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\8A2D\5B9A\306E\5909\66F4\3068\30A2\30AF\30BB\30B9\5236\5FA1\306E\7121\52B9\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280651887016869685)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30ED\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280651944290869685)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3088\3063\3066\9001\4FE1\3055\308C\305F\96FB\5B50\30E1\30FC\30EB\306E\30ED\30B0\3092\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279572971046869019)
,p_name=>'CA.ADVANCED'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\8A73\7D30</strong> - \5C55\958B\3057\3066\8A73\7D30\30AA\30D7\30B7\30E7\30F3\3092\8868\793A\3057\307E\3059\3002'),
'    <ul>',
unistr('      <li><strong>\30DB\30FC\30E0\30DA\30FC\30B8\3068\3057\3066\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\3092\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DB\30FC\30E0\30DA\30FC\30B8\306B\3057\307E\3059\3002<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\4EE5\524D\306B\30DB\30FC\30E0\30DA\30FC\30B8\3068\3057\3066\5B9A\7FA9\3055\308C\305F\30DA\30FC\30B8\306F\3001\3059\3079\3066\66F4\65B0\3055\308C\307E\3059\3002</li>'),
unistr('      <li><strong>\7BA1\7406\30DA\30FC\30B8\3068\3057\3066\8A2D\5B9A</strong> - \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\901A\5E38\306E\30DA\30FC\30B8\3067\306F\306A\304F\300C\7BA1\7406\300D\306E\4E0B\306B\3053\306E\30DA\30FC\30B8\3092\8FFD\52A0\3057\307E\3059\3002\30E1\30A4\30F3\30FB\30E1\30CB\30E5\30FC\3067\300C\7BA1\7406\300D\3092\30AF\30EA\30C3\30AF\3057\3001\300C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\300D\30EA\30B9\30C8\3067\9078\629E\3059\308B\3053\3068\3067\30A2\30AF\30BB\30B9\3057\307E\3059\3002<br>'),
unistr('        <em><strong>\6CE8\610F:</strong> \30DA\30FC\30B8\3092\30DB\30FC\30E0\30DA\30FC\30B8\3068\300C\7BA1\7406\300D\306E\4E0B\306E\30DA\30FC\30B8\306E\4E21\65B9\306B\3059\308B\3053\3068\306F\3067\304D\307E\305B\3093\3002</em></li>'),
'      &nbsp;<br>',
unistr('      <li><strong>\30DA\30FC\30B8\306E\30D8\30EB\30D7</strong> - \30DA\30FC\30B8\306E\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8\306B\8FFD\52A0\3059\308B\30C6\30AD\30B9\30C8\3092\5165\529B\3057\307E\3059\3002</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279443214322868941)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\8A73\7D30</strong> - \5C55\958B\3057\3066\8A73\7D30\30AA\30D7\30B7\30E7\30F3\3092\8868\793A\3057\307E\3059\3002'),
'    <ul>',
unistr('      <li><strong>\30DA\30FC\30B8\306E\30D8\30EB\30D7</strong> - \30DA\30FC\30B8\306E\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8\306B\8FFD\52A0\3055\308C\308B\30C6\30AD\30B9\30C8\3092\5165\529B\3057\307E\3059\3002</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280686721003869707)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280686848171869707)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\8FFD\52A0\306E\5B9A\7FA9\3001\30BB\30AD\30E5\30EA\30C6\30A3\304A\3088\3073\30B0\30ED\30FC\30D0\30EB\5316\8A2D\5B9A\3092\8A2D\5B9A\3057\307E\3059\3002\3053\308C\3089\306E\8A2D\5B9A\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210\6642\306B\9069\7528\3067\304D\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210\5F8C\306B\7DE8\96C6\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280689824733869709)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\5404\8A2D\5B9A\306E\8A73\7D30\306F\3001\9805\76EE\30D8\30EB\30D7(<span class="fa fa-question-circle" aria-hidden="true"></span>)\3092\53C2\7167\3057\3066\304F\3060\3055\3044\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280695683502869712)
,p_name=>'CA.AFTER.ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\5F8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280675908244869700)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\5F8CHTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280679043298869702)
,p_name=>'CA.ALL.COLS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280675141599869700)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30D7\30C8\30FB\30A2\30A6\30C8\3092\8A31\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279784253280869148)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5236\9650\30E2\30FC\30C9\3067\306E\5B9F\884C\3092\8A31\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280668535850869696)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A8\30E9\30FC\30FB\30ED\30B0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280664422985869693)
,p_name=>'CA.APP.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279837256591869180)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\3092\6709\52B9\306B\3059\308B\304B\3069\3046\304B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279837339510869180)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306B\5B58\5728\3057\306A\3044\8A8D\8A3C\3055\308C\305F\30E6\30FC\30B6\30FC\306B\63D0\4F9B\3055\308C\305F\30C7\30D5\30A9\30EB\30C8\306E\30A2\30AF\30BB\30B9\30FB\30EC\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280664852376869693)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A\304C\66F4\65B0\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280664698077869693)
,p_name=>'CA.APP.SUBTITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\77ED\3044\8AAC\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280664794816869693)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\3053\3067\5165\529B\3057\305F\30C6\30AD\30B9\30C8\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DB\30FC\30E0\30DA\30FC\30B8\306B\3042\308B\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\306E\4E0B\306B\8868\793A\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280654152279869687)
,p_name=>'CA.APPEARANCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5916\89B3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280654238643869687)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30C7\30D5\30A9\30EB\30C8\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30AB\30E9\30FC\30FB\30B9\30AD\30FC\30E0(\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB)\3001\30CA\30D3\30B2\30FC\30B7\30E7\30F3\306E\914D\7F6E\5834\6240\3001\304A\3088\3073\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\4F7F\7528\3055\308C\308B\30A2\30A4\30B3\30F3\3092\5B9A\7FA9\3057\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280673650497869699)
,p_name=>'CA.APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280660720889869691)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5916\89B3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280654701632869687)
,p_name=>'CA.APPLICATION.ICON'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30B3\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280654850885869687)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('<p><strong>\300C\65B0\898F\30A2\30A4\30B3\30F3\306E\9078\629E\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3066\3001\30A2\30A4\30B3\30F3\306E\8272\3068\4F7F\7528\53EF\80FD\306A\30A2\30A4\30B3\30F3\306E1\3064\3092\9078\629E\3057\307E\3059\3002\9078\629E\5185\5BB9\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DB\30FC\30E0\30DA\30FC\30B8\306B\8868\793A\3055\308C\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280655173730869687)
,p_name=>'CA.APPLICATION.ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280655251703869687)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4E00\610F\306E\6570\5024\8B58\5225\5B50\3092\5165\529B\3057\307E\3059\3002\3053\306E\30D5\30A3\30FC\30EB\30C9\306B\306F\3001\30C7\30D5\30A9\30EB\30C8\3067\81EA\52D5\7684\306B\751F\6210\3055\308C\305F\8B58\5225\5B50\304C\542B\307E\308C\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280674280943869699)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280666480788869694)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30BB\30C3\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280645025712869681)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280643964407869680)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\3068\77ED\3044\8AAC\660E\306E\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280645114866869681)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\304C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\540D\524D\3084\8AAC\660E\3001\30C7\30D5\30A9\30EB\30C8\30FB\30BF\30A4\30E0\30BE\30FC\30F3\306A\3069\306E\69D8\3005\306A\8A2D\5B9A\3092\66F4\65B0\3067\304D\308B\3088\3046\306B\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\542B\307E\308C\307E\3059:'),
'<ul>',
unistr('<li>\7BA1\7406\30DA\30FC\30B8\306E\30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA\304A\3088\3073\30D5\30A9\30FC\30E0</li>'),
unistr('<li>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\3092\8A2D\5B9A\3059\308B\6A5F\80FD</li>'),
unistr('<li>\30DB\30FC\30E0\30DA\30FC\30B8\306E\30D2\30FC\30ED\30FC\30FB\30EA\30FC\30B8\30E7\30F3\30FB\30B5\30D6\30BF\30A4\30C8\30EB\3092\8A2D\5B9A\3059\308B\6A5F\80FD</li>'),
unistr('<li>\30D5\30A3\30FC\30C9\30D0\30C3\30AF\3092\4F7F\7528\3059\308B\5834\5408\306B\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306E\53D7\4FE1\8005\3092\8A2D\5B9A\3059\308B\6A5F\80FD</li>'),
unistr('<li>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30C7\30D5\30A9\30EB\30C8\30FB\30BF\30A4\30E0\30BE\30FC\30F3\3092\8A2D\5B9A\3059\308B\6A5F\80FD</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280700738505869715)
,p_name=>'CA.APPLICATIONITEM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280702546664869717)
,p_name=>'CA.APPLY'
,p_message_language=>'ja'
,p_message_text=>unistr('\9069\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280704395988869718)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30C7\30D5\30A9\30EB\30C8\306E\9069\7528\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280659914936869690)
,p_name=>'CA.APPLY.CHANGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5909\66F4\306E\9069\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280702342457869716)
,p_name=>'CA.APPLY.FILTERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\306E\9069\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279934926881869241)
,p_name=>'CA.APP_BANNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210\30A6\30A3\30B6\30FC\30C9%0\304B\3089\4F5C\6210\3055\308C\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279936284669869242)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A2D\5B9A\306E\4FDD\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280706543749869719)
,p_name=>'CA.ATTACHMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279650601462869067)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280706624241869719)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279650556804869067)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\30D5\30A1\30A4\30EB\30FB\30B5\30A4\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280702680640869717)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E%0\306B\306F\5C5E\6027\30C7\30D5\30A9\30EB\30C8\304C\3059\3067\306B\5B9A\7FA9\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280670702762869697)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\3055\308C\305F\30E6\30FC\30B6\30FC\306F\3001\8AB0\3067\3082\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\30A2\30AF\30BB\30B9\3067\304D\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280655930996869688)
,p_name=>'CA.AUTHENTICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280656082453869688)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\5BFE\3059\308B\30E6\30FC\30B6\30FC\306E\8A8D\8A3C\65B9\6CD5\3092\9078\629E\3057\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279786976185869149)
,p_name=>'CA.AUTO.DROP'
,p_message_language=>'ja'
,p_message_text=>unistr('\81EA\52D5\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280667197007869695)
,p_name=>'CA.AVG.ELAPSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E73\5747\7D4C\904E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279834336907869178)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\30FB\30EC\30DD\30FC\30C8\306B\623B\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279651379589869067)
,p_name=>'CA.BCC'
,p_message_language=>'ja'
,p_message_text=>'BCC'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280695556703869712)
,p_name=>'CA.BEFORE.ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280675836683869700)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\524DHTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280677340412869701)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\524D\30B3\30F3\30C6\30F3\30C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280652636923869686)
,p_name=>'CA.BLANK'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A7A\767D\30DA\30FC\30B8\306E\8FFD\52A0 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280652771552869686)
,p_name=>'CA.BLANK.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30D7\30EC\30FC\30B9\30DB\30EB\30C0\3068\3057\3066\7A7A\767D\30DA\30FC\30B8\3092\4F5C\6210\3057\307E\3059\3002\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F5C\6210\3057\305F\5F8C\3001\30DA\30FC\30B8\30FB\30C7\30B6\30A4\30CA\304B\3089\30DA\30FC\30B8\306B\30EA\30FC\30B8\30E7\30F3\3092\7C21\5358\306B\4F5C\6210\3067\304D\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30DA\30FC\30B8\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('<!--  <li><strong>\30DA\30FC\30B8\30FB\30CA\30D3\30B2\30FC\30B7\30E7\30F3\3092\542B\3081\308B</strong> - \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\5B9A\7FA9\3055\308C\3066\3044\308B\4ED6\306E\3059\3079\3066\306E\30DA\30FC\30B8\306E\30AB\30FC\30C9\30FB\30EA\30B9\30C8\3092\8868\793A\3059\308B\5834\5408\3001\3053\306E\30AA\30D7\30B7\30E7\30F3\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\3053\306E\30AA\30D7\30B7\30E7\30F3\306F\3001\901A\5E38\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DB\30FC\30E0\30DA\30FC\30B8\3067\4F7F\7528\3055\308C\307E\3059\3002</li>'),
'-->',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280686091898869706)
,p_name=>'CA.BLUEPRINT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D6\30EB\30FC\30D7\30EA\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280686156150869706)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30D6\30EB\30FC\30D7\30EA\30F3\30C8\306B\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5B9A\7FA9\304CJSON\5F62\5F0F\3067\30EA\30B9\30C8\3055\308C\307E\3059\3002</p>'),
unistr('<p>\3053\306E\753B\9762\306B\6700\521D\306B\5165\529B\3059\308B\3068\304D\306B\3001\73FE\5728\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5B9A\7FA9\304CJSON\30C9\30AD\30E5\30E1\30F3\30C8\306B\5909\63DB\3055\308C\3066\8868\793A\3055\308C\307E\3059\3002\30C9\30AD\30E5\30E1\30F3\30C8\3092\7DE8\96C6\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30D7\30ED\30D1\30C6\30A3\3092\66F4\65B0\3057\3001<strong>\300C\30D6\30EB\30FC\30D7\30EA\30F3\30C8\306E\9069\7528\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3066\73FE\5728\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A73\7D30\3092\5909\66F4\3067\304D\307E\3059\3002</p>'),
'<p>&nbsp;</p>',
unistr('<p>\985E\4F3C\30DA\30FC\30B8\3092\5927\91CF\306B\4F5C\6210\3059\308B\5FC5\8981\304C\3042\308B\5834\5408\306F\3001\3042\308B\30DA\30FC\30B8\306B\95A2\9023\3059\308BJSON\30B3\30FC\30C9\3092\30B3\30D4\30FC\3057\3001\8907\6570\56DE\8CBC\308A\4ED8\3051\3001JSON\3092\5C11\3057\8ABF\6574\3059\308B\65B9\304C\3001\30DA\30FC\30B8\3054\3068\306B<strong>\300C\30DA\30FC\30B8\306E\8FFD\52A0\300D</strong>\3092\624B\52D5\3067\4F7F\7528\3059\308B\3088\308A\3082\306F\308B\304B\306B\8FC5\901F\3067\3059\3002</p>'),
unistr('<p><strong>\300C\524D\306E\30D6\30EB\30FC\30D7\30EA\30F3\30C8\306E\30ED\30FC\30C9\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3066\3001\524D\306B\751F\6210\3057\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5B9A\7FA9\3067\30D6\30EB\30FC\30D7\30EA\30F3\30C8\3092\7F6E\63DB\3057\307E\3059\3002\3053\3046\3059\308B\3068\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\518D\5EA6\751F\6210\3059\308B\524D\306B\3001\30DA\30FC\30B8\306E\8FFD\52A0\3001\6A5F\80FD\306E\5909\66F4\307E\305F\306F\8A2D\5B9A\306E\5FAE\8ABF\6574\306B\3088\3063\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\8A08\3092\975E\5E38\306B\7C21\5358\306B\53CD\5FA9\3067\304D\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280674717766869699)
,p_name=>'CA.BODY1.TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\672C\65871\306E\30C6\30AD\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280674809977869699)
,p_name=>'CA.BODY2.TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\672C\65872\306E\30C6\30AD\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280695933683869712)
,p_name=>'CA.BOTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E21\65B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280661189195869691)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\30DA\30FC\30B8\306B\30D6\30E9\30F3\30C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279571826193869019)
,p_name=>'CA.BUTTON.BAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3\30FB\30D0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280660853616869691)
,p_name=>'CA.BUTTONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280653388175869686)
,p_name=>'CA.CALENDAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30EC\30F3\30C0\30FB\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280653464862869686)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30AB\30EC\30F3\30C0\3092\8868\793A\3059\308B\30DA\30FC\30B8\3092\4F5C\6210\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30DA\30FC\30B8\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\8868\307E\305F\306F\30D3\30E5\30FC</strong>(\5FC5\9808) - \30AB\30EC\30F3\30C0\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\8868\793A\5217</strong>(\5FC5\9808) - \30AB\30EC\30F3\30C0\30FB\30A4\30D9\30F3\30C8\306B\8868\793A\3059\308B\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\958B\59CB\65E5\5217</strong>(\5FC5\9808) - \30AB\30EC\30F3\30C0\30FB\30A4\30D9\30F3\30C8\306E\958B\59CB\65E5\3068\3057\3066\4F7F\7528\3059\308B\65E5\4ED8\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\7D42\4E86\65E5\5217</strong> - \30AB\30EC\30F3\30C0\30FB\30A4\30D9\30F3\30C8\306E\7D42\4E86\65E5\3068\3057\3066\4F7F\7528\3059\308B\65E5\4ED8\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\7D42\4E86\65E5\3092\6307\5B9A\3059\308B\3068\3001\671F\9593\30D9\30FC\30B9\306E\30A4\30D9\30F3\30C8\304C\8868\793A\3055\308C\307E\3059\3002 </li>'),
unistr('  <li><strong>\6642\9593\306E\8868\793A</strong> - <strong>\300C\306F\3044\300D</strong>\3092\9078\629E\3059\308B\3068\3001\30A4\30D9\30F3\30C8\306E\6642\9593\90E8\5206\304C\8868\793A\3055\308C\3001\300C\9031\300D\304A\3088\3073\300C\65E5\300D\306E\30AB\30EC\30F3\30C0\30FB\30D3\30E5\30FC\304C\6709\52B9\5316\3055\308C\307E\3059\3002<strong>\300C\3044\3044\3048\300D</strong>\3092\9078\629E\3059\308B\3068\3001\30A4\30D9\30F3\30C8\306E\65E5\4ED8\306E\307F\304C\8868\793A\3055\308C\307E\3059\3002</li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280659800821869690)
,p_name=>'CA.CANCEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280661788165869691)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A4\30A2\30ED\30B0\3092\53D6\308A\6D88\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279551930782869006)
,p_name=>'CA.CANCEL.MODAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E2\30FC\30C0\30EB\306E\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280671601292869697)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\72EC\81EA\306E\30EC\30B3\30FC\30C9\304B\3089\7BA1\7406\6A29\9650\3092\524A\9664\3059\308B\3053\3068\306F\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280703501638869717)
,p_name=>'CA.CARD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30FC\30C9\30FB\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280703405010869717)
,p_name=>'CA.CARD.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30AB\30FC\30C9\3092\8868\793A\3059\308B\30DA\30FC\30B8\3092\4F5C\6210\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30DA\30FC\30B8\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\8868\307E\305F\306F\30D3\30E5\30FC</strong>(\5FC5\9808) - \30AB\30FC\30C9\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30AB\30FC\30C9\30FB\30BF\30A4\30C8\30EB</strong>(\5FC5\9808) - \30AB\30FC\30C9\306E\30BF\30A4\30C8\30EB\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\8AAC\660E\5217</strong>(\5FC5\9808) - \30AB\30FC\30C9\306E\8AAC\660E\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\8FFD\52A0\306E\30C6\30AD\30B9\30C8\5217</strong> - \30AB\30FC\30C9\306E\30BB\30AB\30F3\30C0\30EA\8AAC\660E\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280702026143869716)
,p_name=>'CA.CARDS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280702155051869716)
,p_name=>'CA.CARDS.VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30FC\30C9\30FB\30D3\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279651442738869067)
,p_name=>'CA.CC'
,p_message_language=>'ja'
,p_message_text=>'CC'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279935641207869242)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\306E\5909\66F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280652434562869686)
,p_name=>'CA.CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280652598929869686)
,p_name=>'CA.CHART.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9762\3001\68D2\3001\6298\308C\7DDA\307E\305F\306F\5186\30B0\30E9\30D5\3092\8868\793A\3059\308B\30DA\30FC\30B8\3092\4F5C\6210\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30DA\30FC\30B8\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7</strong> - \8868\793A\3059\308B\30C1\30E3\30FC\30C8\306E\30BF\30A4\30D7[<strong>\9762</strong>\3001<strong>\68D2</strong>\3001<strong>\6298\308C\7DDA</strong>\3001<strong>\5186</strong>]\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\8868\307E\305F\306F\30D3\30E5\30FC</strong>(\5FC5\9808) - \30C1\30E3\30FC\30C8\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30E9\30D9\30EB\5217</strong>(\5FC5\9808) - \30C1\30E3\30FC\30C8\306E\30E9\30D9\30EB\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\5024\96C6\8A08</strong> - \5024\5217\306E\8868\793A\65B9\6CD5\307E\305F\306F\96C6\8A08\65B9\6CD5\3092\9078\629E\3057\307E\3059<br>'),
unistr('      &nbsp;&nbsp;&nbsp;[\5217\5024\3001\5408\8A08\3001\4EF6\6570]\3002</li>'),
unistr('  <li><strong>\5024\5217</strong>(\5FC5\9808) - \8868\793A\3055\308C\308B\30C1\30E3\30FC\30C8\5024\306E\8A08\7B97\306B\4F7F\7528\3059\308B\6570\5024\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280652874617869686)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<h3>\4F8B</h3>'),
unistr('<p><strong>\300C\30B5\30DE\30EA\30FC\300D</strong>\306E\7570\306A\308B\30BF\30A4\30D7\3092\4F7F\7528\3059\308B\65B9\6CD5\306E\4F8B\3092\78BA\8A8D\3057\307E\3059\3002</p>'),
unistr('<p><strong>\4F8B1:</strong> \5F93\696D\54E1\3054\3068\306B\3001\30DE\30CD\30FC\30B8\30E3\306E\5F93\696D\54E1\756A\53F7\3092\542B\3080Employees\306E\30C1\30E3\30FC\30C8\3092\8868\793A\3057\307E\3059\3002'),
'<code><ul>',
unistr('  <li>\8868\307E\305F\306F\30D3\30E5\30FC - EMP\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li>\30E9\30D9\30EB\5217 - ENAME\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li>\30B5\30DE\30EA\30FC - <u><strong>\300C\5217\5024\300D</strong></u>\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li>\5024\5217 - MGR\3092\9078\629E\3057\307E\3059\3002</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>\4F8B2:</strong> \8077\7A2E\3054\3068\306E\5408\8A08\7D66\4E0E\3092\542B\3080Employees\306E\30C1\30E3\30FC\30C8\3092\8868\793A\3057\307E\3059\3002'),
'<code><ul>',
unistr('  <li>\8868\307E\305F\306F\30D3\30E5\30FC - EMP\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li>\30E9\30D9\30EB\5217 - JOB\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li>\30B5\30DE\30EA\30FC - <u><strong>\300C\5408\8A08\300D</strong></u>\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li>\5024\5217 - SAL\3092\9078\629E\3057\307E\3059\3002</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>\4F8B3:</strong> \90E8\9580\3054\3068\306E\5F93\696D\54E1\306E\6570\3092\542B\3080Employees\306E\30C1\30E3\30FC\30C8\3092\8868\793A\3057\307E\3059\3002'),
'<code><ul>',
unistr('  <li>\8868\307E\305F\306F\30D3\30E5\30FC - EMP\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li>\30E9\30D9\30EB\5217 - DEPTNO\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li>\30B5\30DE\30EA\30FC - <u><strong>\300C\4EF6\6570\300D</strong></u>\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li>\5024\5217 - EMPNO\3092\9078\629E\3057\307E\3059\3002</li>'),
'</ul></code>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279788959057869150)
,p_name=>'CA.CLIENT.ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30E9\30A4\30A2\30F3\30C8ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280706762814869719)
,p_name=>'CA.CLOSE'
,p_message_language=>'ja'
,p_message_text=>unistr('\9589\3058\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279416838635868925)
,p_name=>'CA.CLOSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30ED\30FC\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280704733506869718)
,p_name=>'CA.COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280680618673869703)
,p_name=>'CA.COLUMN.1'
,p_message_language=>'ja'
,p_message_text=>unistr('\52171')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280680754669869703)
,p_name=>'CA.COLUMN.2'
,p_message_language=>'ja'
,p_message_text=>unistr('\52172')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280668060111869695)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\306E\5225\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280700550417869715)
,p_name=>'CA.COMMENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30E1\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280665787564869694)
,p_name=>'CA.COMPONENT.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280670588168869697)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\306E\69CB\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280660927945869691)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5916\89B3\306E\69CB\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280661022717869691)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5916\89B3\306F\3001\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306B\3088\3063\3066\5B9A\7FA9\3055\308C\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280664349437869693)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\69CB\6210\30AA\30D7\30B7\30E7\30F3\304C\66F4\65B0\3055\308C\307E\3057\305F\3002 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280646287932869682)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\69CB\6210\30AA\30D7\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280644592577869681)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\6A5F\80FD\306E\6709\52B9\5316\307E\305F\306F\7121\52B9\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280646365036869682)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\304C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\306E\7279\5B9A\306E\6A5F\80FD\3092\6709\52B9\5316\307E\305F\306F\7121\52B9\5316\3067\304D\308B\3088\3046\306B\3057\307E\3059\3002\3053\306E\6A5F\80FD\306F\3001\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\4F7F\7528\3059\308B\524D\306B\8FFD\52A0\306E\958B\767A\4F5C\696D\3092\5FC5\8981\3068\3059\308B\6A5F\80FD\3092\9078\629E\3057\3066\3044\308B\5834\5408\306B\975E\5E38\306B\4FBF\5229\3067\3059\3002<br>'),
unistr('\3053\306E\6A5F\80FD\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\56FA\6709\306E\6A5F\80FD\306B\62E1\5F35\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002\958B\767A\8005\304C\8FFD\52A0\306E\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3\3092\5B9A\7FA9\3057\3066\305D\308C\3089\3092\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5168\4F53\306B\308F\305F\308B\7279\5B9A\306E\6A5F\80FD\306B\95A2\9023\4ED8\3051\308B\5834\5408\3001\305D\308C\3089\306F\7BA1\7406\8005\7528\306E\69CB\6210\8A2D\5B9A\306B\8FFD\52A0\3067\304D\307E\3059\3002\305F\3068\3048\3070\3001\9867\5BA2\30C8\30E9\30C3\30AB\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\3067\3001\7BA1\7406\8005\306F\3001\9023\7D61\5148\3001\30C7\30FC\30BF\30FB\30ED\30FC\30C9\3001\5730\7406\306A\3069\306E\6A5F\80FD\306E\6709\52B9\5316\3068\7121\52B9\5316\3092\5207\308A\66FF\3048\308B\3053\3068\304C\3067\304D\307E\3059\3002'),
'</p>',
unistr('<p>\6B21\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\542B\307E\308C\307E\3059\3002'),
'<ul>',
unistr('<li>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\6A5F\80FD\306E\6709\52B9\5316\3068\7121\52B9\5316\306E\5207\66FF\3048</li>'),
unistr('<li>\30C7\30D7\30ED\30A4\30E1\30F3\30C8\5358\4F4D\3067\306E\6A5F\80FD\9078\629E\3092\53EF\80FD\306B\3059\308B\6A5F\80FD\306E\4F7F\7528</li>'),
unistr('<li>\95A2\9023\3059\308B\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A\306E\30B0\30EB\30FC\30D7\5316\306E\30B5\30DD\30FC\30C8</li>'),
unistr('<li>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\958B\767A\8005\306B\3088\308B\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3\3092\4F7F\7528\3057\305F\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\5236\5FA1\306E\8A31\53EF</li>'),
unistr('<li>\7BA1\7406\30DA\30FC\30B8\304B\3089\306E\4F7F\7528</li>'),
'</ul>',
'</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279783810308869147)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\63A5\7D9A\306E\8CC7\683C\8A3C\660E\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279783989197869147)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\63A5\7D9A\306E\8CC7\683C\8A3C\660E\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280513800958869601)
,p_name=>'CA.CONTEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C6\30AD\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280671037446869697)
,p_name=>'CA.CONTRIBUTOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279790881403869152)
,p_name=>'CA.CPU.USED'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F7F\7528\4E2D\306ECPU')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280679552029869702)
,p_name=>'CA.CREATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280684671327869705)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280682227800869704)
,p_name=>'CA.CREATE.APP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280683309398869705)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8A08\7B97\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280682656665869704)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30B3\30F3\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280683250791869705)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30A2\30A4\30C6\30E0\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280683413749869705)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30ED\30BB\30B9\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280524851524869607)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8A2D\5B9A\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280690689003869709)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279835661143869179)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30ED\30FC\30EB\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280682869501869704)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\53EF\30B9\30AD\30FC\30E0\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280683647130869705)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7A7A\767D\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280682789149869704)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D3\30EB\30C9\30FB\30AA\30D7\30B7\30E7\30F3\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280684022873869705)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30EC\30F3\30C0\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280696973113869713)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30FC\30C9\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280683891907869705)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280684372679869705)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30E9\30B7\30C3\30AF\30FB\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280683940536869705)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30C3\30B7\30E5\30DC\30FC\30C9\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280682103166869704)
,p_name=>'CA.CREATE.END'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280704218574869718)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30BB\30C3\30C8\691C\7D22\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280684938215869706)
,p_name=>'CA.CREATE.FEATURES'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280701569260869716)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\3055\308C\305F\30B3\30F3\30C6\30F3\30C4\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280683792731869705)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280682342270869704)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30ED\30FC\30D0\30EB\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280684550923869705)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DB\30FC\30E0\30DA\30FC\30B8\30FB\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30EA\30B9\30C8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280684403400869705)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30B0\30EA\30C3\30C9\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280684276705869705)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280690376826869709)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\30FB\30DA\30FC\30B8\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280683006410869704)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280686220935869706)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30B0\30EB\30FC\30D7\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280684823721869706)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\7FFB\8A33\306E\5B9F\884C\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280684725102869706)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\7FFB\8A33\3092\5B9F\884C\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280684196235869705)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\304A\3088\3073\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280690505598869709)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EB\30FC\30D7\30EA\30F3\30C8\306E\4FDD\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280683121461869705)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B7\30E7\30FC\30C8\30AB\30C3\30C8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280683573260869705)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30A4\30F3\30A4\30F3\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280682040267869704)
,p_name=>'CA.CREATE.START'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\59CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280682448120869704)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\30B9\30AF\30EA\30D7\30C8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280682924330869704)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30AD\30B9\30C8\30FB\30E1\30C3\30BB\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280697014537869713)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30E0\30E9\30A4\30F3\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280704441572869718)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A6\30A3\30B6\30FC\30C9\30FB\30DA\30FC\30B8\306E\4F5C\6210\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280663604241869692)
,p_name=>'CA.CREATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280663797055869693)
,p_name=>'CA.CREATED.BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F5C\6210\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280652178506869685)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F5C\6210\4E2D\3067\3059 ...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279784572037869148)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\8CC7\683C\8A3C\660E\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279790717059869151)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\8CC7\683C\8A3C\660E\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280664267522869693)
,p_name=>'CA.CURRENT.STATUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\884C\306E\30B9\30C6\30FC\30BF\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280685229278869706)
,p_name=>'CA.CUSTOM.QRY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30B9\30BF\30E0\554F\5408\305B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279882446192869208)
,p_name=>'CA.CUSTOM.THEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30B9\30BF\30E0\30FB\30C6\30FC\30DE\306E\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279882536693869208)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30E6\30CB\30D0\30FC\30B5\30EB\30FB\30C6\30FC\30DE\3067\306F\306A\304F\30AB\30B9\30BF\30E0\30FB\30C6\30FC\30DE\3092\4F7F\7528\3059\308B\3088\3046\306B\30A6\30A3\30B6\30FC\30C9\3092\5207\308A\66FF\3048\307E\3059\3002</p>'),
'',
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\30FB\30C6\30FC\30DE\3092\9078\629E\3057\307E\3059\3002\30C6\30FC\30DE\304C\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\3092\30B5\30DD\30FC\30C8\3057\3066\3044\308B\5834\5408\306F\3001\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\3082\9078\629E\3067\304D\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279551638711869006)
,p_name=>'CA.CUSTOM_THEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30B9\30BF\30E0\30FB\30C6\30FC\30DE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280685890324869706)
,p_name=>'CA.DASHBOARD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30C3\30B7\30E5\30DC\30FC\30C9\30FB\30DA\30FC\30B8\3092\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280512298316869600)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280685910625869706)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8907\6570\306E\30C1\30E3\30FC\30C8\304C\3042\308B\30C0\30C3\30B7\30E5\30DC\30FC\30C9\30FB\30DA\30FC\30B8\3092\4F5C\6210\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30DA\30FC\30B8\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
'  </ul>',
'</ul>',
'&nbsp;<br>',
unistr('<p>\5404\30C1\30E3\30FC\30C8(\30C1\30E3\30FC\30C81\3001\30C1\30E3\30FC\30C82\3001\30C1\30E3\30FC\30C83\304A\3088\3073\30C1\30E3\30FC\30C84)\306F\30C7\30D5\30A9\30EB\30C8\3067\7570\306A\308B\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7\306B\306A\308A\3001<em>\30B5\30F3\30D7\30EB\30FB\30C7\30FC\30BF</em>\306B\57FA\3065\304D\307E\3059\3002 '),
unistr('  \305D\306E\305F\3081\3001\3053\306E\30DA\30FC\30B8\3092\8FFD\52A0\3059\308B\305F\3081\306B\8A73\7D30\3092\5165\529B\3059\308B\5FC5\8981\306F\3042\308A\307E\305B\3093\3002'),
unistr('  \305F\3060\3057\3001\5404\30C1\30E3\30FC\30C8\3092\30AB\30B9\30BF\30DE\30A4\30BA\3057\3066\3001\72EC\81EA\306E\9078\629E\3067\30C7\30D5\30A9\30EB\30C8\5024\3092\7F6E\63DB\3067\304D\307E\3059\3002<br>'),
unistr('  \30C1\30E3\30FC\30C8\3092\30AB\30B9\30BF\30DE\30A4\30BA\3059\308B\306B\306F\3001\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30C1\30E3\30FC\30C8\540D</strong>(\5FC5\9808) - \30C1\30E3\30FC\30C8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7</strong> - \8868\793A\3059\308B\30C1\30E3\30FC\30C8\306E\30BF\30A4\30D7[<strong>\9762</strong>\3001<strong>\68D2</strong>\3001<strong>\6298\308C\7DDA</strong>\3001<strong>\5186</strong>]\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\8868\307E\305F\306F\30D3\30E5\30FC</strong>(\5FC5\9808) - \30C1\30E3\30FC\30C8\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30E9\30D9\30EB\5217</strong>(\5FC5\9808) - \30C1\30E3\30FC\30C8\306E\30E9\30D9\30EB\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\5024\96C6\8A08</strong> - \5024\5217\306E\8868\793A\65B9\6CD5\307E\305F\306F\96C6\8A08\65B9\6CD5\3092\9078\629E\3057\307E\3059<br>'),
unistr('      &nbsp;&nbsp;&nbsp;[\5217\5024\3001\5408\8A08\3001\4EF6\6570]\3002</li>'),
unistr('  <li><strong>\5024\5217</strong>(\5FC5\9808) - \8868\793A\3055\308C\308B\30C1\30E3\30FC\30C8\5024\306E\8A08\7B97\306B\4F7F\7528\3059\308B\6570\5024\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280697653237869713)
,p_name=>'CA.DATATYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280698786817869714)
,p_name=>'CA.DATEFORMATMASK'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5\4ED8\66F8\5F0F\30DE\30B9\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280664958199869693)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\306E\30BF\30A4\30E0\30BE\30FC\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280665032192869693)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\30FB\30BF\30A4\30E0\30BE\30FC\30F3\304C\66F4\65B0\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280686685366869707)
,p_name=>'CA.DEFAULTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5C5E\6027\306E\30C7\30D5\30A9\30EB\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280686996043869707)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306EJSON\30C9\30AD\30E5\30E1\30F3\30C8\3067\306F\3001\30EC\30DD\30FC\30C8\3068\30D5\30A9\30FC\30E0\306E\5217\540D\306E\751F\6210\3001\30D5\30A9\30FC\30DE\30C3\30C8\30FB\30DE\30B9\30AF\306A\3069\3092\304D\3081\7D30\304B\304F\5236\5FA1\3067\304D\307E\3059\3002\5024\304A\3088\3073\305D\306E\4ED6\306E\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\30EA\30B9\30C8\3092\5B9A\7FA9\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280704065066869717)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024\30EA\30B9\30C8\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280704148534869718)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5024\30EA\30B9\30C8(LOV)\5C5E\6027\3092\8FFD\52A0\3057\307E\3059\3002LOV\306F\8868\5217\5B9A\7FA9\3067\4F7F\7528\3067\304D\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002'),
'  <ul>',
unistr('    <li><strong>\540D\524D</strong>(\5FC5\9808) - \5024\30EA\30B9\30C8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30BF\30A4\30D7</strong> - \5024\30EA\30B9\30C8\30FB\30BF\30A4\30D7[\300C\69CB\9020\5316\300D\3001\300C\52D5\7684\300D\3001\300C\9759\7684\300D]\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('      \300C\30BF\30A4\30D7\300D\304C<u>\300C\69CB\9020\5316\300D</u>\306E\5834\5408 - '),
'      <ul>',
unistr('          <li><strong>\8868</strong>(\5FC5\9808) - \5024\30EA\30B9\30C8\306E\57FA\306B\306A\308B\8868\307E\305F\306F\30D3\30E5\30FC\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('          <li><strong>\8868\793A\5217</strong>(\5FC5\9808) - \30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\8868\793A\3055\308C\308B\5217\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('          <li><strong>\30AD\30FC\5217</strong>(\5FC5\9808) - \8FD4\3055\308C\308B\5217\5024\3092\9078\629E\3057\307E\3059\3002\3053\308C\306F\4E00\822C\306B\3001\8868\306E\4E3B\30AD\30FC\3067\3059\3002</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      \300C\30BF\30A4\30D7\300D\304C<u>\300C\52D5\7684\300D</u>\306E\5834\5408 -'),
'      <ul>',
unistr('          <li><strong>SQL\554F\5408\305B</strong>(\5FC5\9808) - 2\3064\306E\5024(\8868\793A\5024\3068\623B\308A\5024)\3092\8FD4\3059\6709\52B9\306ASQL select\6587\3092\5165\529B\3057\307E\3059\3002</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      \300C\30BF\30A4\30D7\300D\304C<u>\300C\9759\7684\300D</u>\306E\5834\5408 -'),
'      <ul>',
unistr('          <li><strong>\9759\7684\5024\30EA\30B9\30C8</strong>(\5FC5\9808) - \30D5\30A9\30FC\30E0\306E\6709\52B9\306A\9759\7684\30EA\30B9\30C8\3092\5165\529B\3057\307E\3059\3002'),
'          <ul>',
unistr('            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>\5165\529B\3057\305F\9806\5E8F\3067\8868\793A\3055\308C\308B\30EA\30B9\30C8</li>'),
unistr('            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>\82F1\5B57\9806\306E\30EA\30B9\30C8</li>'),
unistr('            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>\8868\793A\5024\3068\623B\308A\5024\306F\540C\3058\3067\3059</li>'),
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280705251220869718)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280705305463869718)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3059\3079\3066\306E\30EC\30DD\30FC\30C8\306E\5C5E\6027\3092\7DE8\96C6\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002'),
'  <ul>',
unistr('    <li><strong>\30DA\30FC\30B8\3054\3068\306E\884C\6570</strong> - \30C7\30D5\30A9\30EB\30C8\3067\8868\793A\3059\308B\30EC\30DD\30FC\30C8\884C\6570\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30DA\30FC\30B8\533A\5207\308A\30E1\30BD\30C3\30C9</strong> - \30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\533A\5207\308A\306E\8868\793A\30E1\30BD\30C3\30C9\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\6570\5024\66F8\5F0F\30DE\30B9\30AF</strong> - \6570\5024\306E\5217\304A\3088\3073\30A2\30A4\30C6\30E0\306B\9069\7528\3059\308B\66F8\5F0F\30DE\30B9\30AF\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\65E5\4ED8\66F8\5F0F\30DE\30B9\30AF</strong> - \65E5\4ED8\306E\5217\304A\3088\3073\30A2\30A4\30C6\30E0\306B\9069\7528\3059\308B\66F8\5F0F\30DE\30B9\30AF\3092\5165\529B\3057\307E\3059\3002</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280705089571869718)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\306E\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280704825525869718)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\5217\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280704930400869718)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9078\629E\3057\305F\8868\5217\306E\5C5E\6027\3092\7DE8\96C6\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002'),
'  <ul>',
unistr('    <li><strong>\8868</strong>(\8868\793A\5C02\7528) - \95A2\9023\4ED8\3051\3089\308C\305F\8868\3002</li>'),
unistr('    <li><strong>\5217</strong>(\8868\793A\5C02\7528) - \5C5E\6027\306E\5B9A\7FA9\306B\4F7F\7528\3055\308C\308B\5217\3002</li>'),
unistr('    <li><strong>\30E9\30D9\30EB</strong> - \30EC\30DD\30FC\30C8\30FB\30D8\30C3\30C0\30FC\304A\3088\3073\30D5\30A9\30FC\30E0\30FB\30E9\30D9\30EB\3067\4F7F\7528\3059\308B\30E9\30D9\30EB\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30D5\30A9\30FC\30E0\30FB\30B3\30F3\30C8\30ED\30FC\30EB</strong> - \30D5\30A9\30FC\30E0\3067\4F7F\7528\3059\308B\30A2\30A4\30C6\30E0\30FB\30BF\30A4\30D7\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\5024\30EA\30B9\30C8</strong> - \9069\5B9C\308F\304B\308A\3084\3059\3044\540D\524D\3092\8868\793A\3059\308B\305F\3081\306B\4F7F\7528\3059\308B\65E2\5B58\306E\5024\30EA\30B9\30C8\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\66F8\5F0F\30DE\30B9\30AF</strong> - \5217\30BF\30A4\30D7(\30C6\30AD\30B9\30C8\3001\6570\5024\3001\65E5\4ED8\306A\3069)\306B\57FA\3065\3044\3066\9069\5207\306A\66F8\5F0F\30DE\30B9\30AF\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\9759\7684\30C7\30D5\30A9\30EB\30C8\5024</strong> - \5217\306E\30C6\30AD\30B9\30C8\30FB\30C7\30D5\30A9\30EB\30C8\5024\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30D5\30A9\30FC\30E0\306B\542B\3081\308B</strong> - \5217\3092\30D5\30A9\30FC\30E0\306B\542B\3081\308B\5834\5408\306F\3001\300C\306F\3044\300D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30EC\30DD\30FC\30C8\306B\542B\3081\308B</strong> - \5217\3092\30EC\30DD\30FC\30C8\306B\542B\3081\308B\5834\5408\306F\3001\300C\306F\3044\300D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\5FC5\9808</strong> - \30D5\30A9\30FC\30E0\3067\3053\306E\5217\3078\306E\30C7\30FC\30BF\306E\5165\529B\3092\5FC5\9808\306B\3059\308B\5834\5408\306F\3001\300C\306F\3044\300D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30D8\30EB\30D7</strong> - \9805\76EE\30D8\30EB\30D7\5C5E\6027\306B\8FFD\52A0\3059\308B\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8\3092\5165\529B\3057\307E\3059\3002</li>'),
'  </ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280705184147869718)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9078\629E\3057\305F\8868\306E\5C5E\6027\3092\7DE8\96C6\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002'),
'  <ul>',
unistr('    <li><strong>\8868</strong>(\8868\793A\5C02\7528) - \95A2\9023\4ED8\3051\3089\308C\305F\8868\3002</li>'),
unistr('    <li><strong>\30E9\30D9\30EB\3001\5358\4E00</strong>(\5FC5\9808) - \30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\3067\4F7F\7528\3059\308B\30E9\30D9\30EB\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30E9\30D9\30EB\3001\8907\6570</strong>(\5FC5\9808) - \30EA\30FC\30B8\30E7\30F3\30FB\30D8\30C3\30C0\30FC\304A\3088\3073\30DA\30FC\30B8\540D\3067\4F7F\7528\3059\308B\30E9\30D9\30EB\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30D7\30E9\30A4\30DE\30EA\8868\793A\5217</strong> - \30AB\30FC\30C9\30FB\30EA\30FC\30B8\30E7\30F3\306A\3069\306B\8868\793A\3059\308B\6700\521D\306E\5217\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30BB\30AB\30F3\30C0\30EA\8868\793A\5217</strong> - \30AB\30FC\30C9\30FB\30EA\30FC\30B8\30E7\30F3\306A\3069\306B\8868\793A\3059\308B2\756A\76EE\306E\5217\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\4E3B\30AD\30FC\5217</strong> - \8868\306E\4E00\610F\306E\4E3B\30AD\30FC\5217\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\8AAC\660E</strong> - \8868\306E\8AAC\660E\3092\5165\529B\3057\307E\3059\3002</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279784301957869148)
,p_name=>'CA.DEFERRED.DROP'
,p_message_language=>'ja'
,p_message_text=>unistr('\9045\5EF6\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280699359426869715)
,p_name=>'CA.DEFINITION'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9A\7FA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280681903988869704)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664\306F\5B8C\4E86\3057\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280662249582869692)
,p_name=>'CA.DELETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280681506253869704)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\524A\9664\64CD\4F5C\3092\5B9F\884C\3057\307E\3059\304B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280647850169869683)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30DA\30FC\30B8\3092\524A\9664\3057\307E\3059\304B\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280672073237869698)
,p_name=>'CA.DELETE.PHOTO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5199\771F\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280662958030869692)
,p_name=>'CA.DESCRIPTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8AAC\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280680106318869703)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30B9\30AF\30C8\30C3\30D7\30FB\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280680087290869703)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30B9\30AF\30C8\30C3\30D7\30FB\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280661228909869691)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30B9\30AF\30C8\30C3\30D7\30FB\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280661317806869691)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\306E\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306F\3059\3079\3066\306E\30E6\30FC\30B6\30FC\306B\9069\7528\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279784763669869148)
,p_name=>'CA.DESTINATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9B\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279784814586869148)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9B\5148\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279551788529869006)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A4\30A2\30ED\30B0\30FB\30DC\30BF\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280676576970869701)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\306E\30C7\30A3\30B9\30D1\30C3\30C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280696182583869713)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\3092\96FB\5B50\30E1\30FC\30EB\30FB\30D5\30EC\30FC\30E0\30EF\30FC\30AF\304B\3089\9001\4FE1\3059\308B\5FC5\8981\304C\3042\308B\304B\3069\3046\304B\3092\6C7A\5B9A\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280662768379869692)
,p_name=>'CA.DISPLAY.FROM'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\958B\59CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280662634505869692)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280662892874869692)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\7D42\4E86')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280697808919869714)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280666398568869694)
,p_name=>'CA.DISTINCT .USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\500B\5225\30E6\30FC\30B6\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280679615572869702)
,p_name=>'CA.DOWNLOAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A6\30F3\30ED\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280686557459869707)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C9\30E9\30C3\30B0\3057\3066\30DA\30FC\30B8\306E\4E26\66FF\3048')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279573071932869019)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr('  <li><strong>\30C9\30EA\30EB\30C0\30A6\30F3\30FB\30EA\30F3\30AF</strong> - \5C55\958B\3057\3066\3001\30C9\30EA\30EB\30C0\30A6\30F3\30FB\30EA\30F3\30AF\3092\5B9A\7FA9\3059\308B\305F\3081\306E\5C5E\6027\3092\8868\793A\3057\307E\3059\3002'),
'&nbsp;<br>',
unistr('    <em><strong>\6CE8\610F:</strong> \300C\30C9\30EA\30EB\30C0\30A6\30F3\30FB\30EA\30F3\30AF\300D\304C\8868\793A\3055\308C\308B\306E\306F\3001\73FE\5728\306E\30DA\30FC\30B8\304C\8868\307E\305F\306F\30D3\30E5\30FC\306B\57FA\3065\3044\3066\304A\308A\3001\30EC\30DD\30FC\30C8\30FB\30BF\30A4\30D7\304C\300C\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\300D\3067\3042\308A\3001\304B\3064\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8(\300C\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\300D)\307E\305F\306F\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\30FB\30DA\30FC\30B8(\300C\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\300D)\3092\5B9A\7FA9\3057\305F\5834\5408\306E\307F\3067\3059\3002</em>'),
'  <ul>',
unistr('    <li><strong>\30EA\30F3\30AF\5217</strong> - \30EC\30DD\30FC\30C8\306E\30EA\30F3\30AF\5217\306B\5909\66F4\3059\308B\5217\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30EA\30F3\30AF\30FB\30AD\30FC</strong> - \30EA\30F3\30AF\5148\306E\30DA\30FC\30B8\306E\7279\5B9A\306E\30EC\30B3\30FC\30C9\3092\8B58\5225\3059\308B\305F\3081\306B\4F7F\7528\3059\308B\30EA\30F3\30AF\30FB\30AD\30FC(\5916\90E8\30AD\30FC)\5217\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30DA\30FC\30B8\3078\306E\30EA\30F3\30AF</strong> - \30EA\30F3\30AF\306E\79FB\52D5\5148\306E\30EC\30DD\30FC\30C8\307E\305F\306F\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\30BF\30FC\30B2\30C3\30C8\30FB\30AD\30FC</strong> - \30EA\30F3\30AF\306E\79FB\52D5\5148\306E\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\306E\57FA\306B\306A\308B\8868\304B\3089\3001\30BF\30FC\30B2\30C3\30C8\30FB\30AD\30FC(\4E3B\30AD\30FC)\5217\3092\9078\629E\3057\307E\3059\3002'),
'  </ul>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280665453605869694)
,p_name=>'CA.ELAPSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D4C\904E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280648026705869683)
,p_name=>'CA.EMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30D5\30EC\30FC\30E0\30EF\30FC\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280695704645869712)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280705773801869718)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280647989555869683)
,p_name=>'CA.EMAIL.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\3092\69CB\6210\3057\3066\9001\4FE1\3059\308B\6A5F\80FD\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280648111246869683)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\96FB\5B50\30E1\30FC\30EB\3092\9001\4FE1\3059\308B\6A5F\80FD\3092\542B\3081\307E\3059\3002\30B5\30F3\30D7\30EB\306E\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3092\4F7F\7528\3057\3066\3001\672C\683C\4ED5\69D8\306E\96FB\5B50\30E1\30FC\30EB\3092\30E6\30FC\30B6\30FC\306B\9001\4FE1\3057\307E\3059\3002\9001\4FE1\3055\308C\305F\96FB\5B50\30E1\30FC\30EB\306F\3001\7BA1\7406\8005\304C\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3\3092\628A\63E1\3067\304D\308B\3088\3046\306B\30ED\30B0\306B\8A18\9332\3055\308C\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\542B\307E\308C\307E\3059:'),
'<ul>',
unistr('<li>\62E1\5F35\53EF\80FD\306AHTML\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\30FB\30B7\30B9\30C6\30E0</li>'),
unistr('<li>APEX\30D1\30C3\30B1\30FC\30B8\3092\901A\3058\305F\30E1\30FC\30EB\9001\4FE1\306E\305F\3081\306EPL/SQL\30D1\30C3\30B1\30FC\30B8</li>'),
unistr('<li>\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30AF\30C6\30A3\30D3\30C6\30A3\304A\3088\3073\30B9\30C6\30FC\30BF\30B9\306E\30ED\30AE\30F3\30B0</li>'),
unistr('<li>\30C6\30F3\30D7\30EC\30FC\30C8\3092\7BA1\7406\3059\308B\305F\3081\306E\7BA1\7406UI</li>'),
unistr('<li>\96FB\5B50\30E1\30FC\30EB\30FB\30ED\30B0\3092\8868\793A\3059\308B\305F\3081\306E\7BA1\7406UI</li>'),
unistr('<li>\96FB\5B50\30E1\30FC\30EB\3092\9001\4FE1\3059\308B\305F\3081\306E\7BA1\7406UI</li>'),
'</ul>',
'</p>',
unistr('<p><em>\6CE8\610F: \3053\306E\6A5F\80FD\306F\3001\300C\30D5\30A3\30FC\30C9\30D0\30C3\30AF\300D\304C\9078\629E\3055\308C\308B\3068\6709\52B9\306B\306A\308A\307E\3059</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280701463194869716)
,p_name=>'CA.EMAIL.FROM'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\5DEE\51FA\4EBA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280675540980869700)
,p_name=>'CA.EMAIL.LOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30ED\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280706356936869719)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\8A2D\5B9A\306E\8A73\7D30\304C\5FC5\8981\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280705877254869719)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\5143\30A2\30C9\30EC\30B9\304C\6709\52B9\306A\96FB\5B50\30E1\30FC\30EB\3067\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280697358836869713)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\5143\30A2\30C9\30EC\30B9\304C\6709\52B9\306A\96FB\5B50\30E1\30FC\30EB\3067\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280696573679869713)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\304C\51E6\7406\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279651700202869067)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279837579957869180)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\30AD\30E5\30FC\306B\5165\3063\3066\3044\308B\3059\3079\3066\306E\96FB\5B50\30E1\30FC\30EB\304A\3088\3073\3059\3067\306B\9001\4FE1\3055\308C\305F\3059\3079\3066\306E\96FB\5B50\30E1\30FC\30EB\306E\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280676455836869700)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280676849111869701)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\8A2D\5B9A\304C\66F4\65B0\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280701890509869716)
,p_name=>'CA.EMAIL.STATUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30B9\30C6\30FC\30BF\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280676994450869701)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\8A73\7D30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280188605200869396)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_language=>'ja'
,p_message_text=>unistr('#SERVICE_NAME#\306E\30B9\30B1\30B8\30E5\30FC\30EB\6E08\505C\6B62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279890067857869213)
,p_name=>'CA.EMAIL2'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280675446159869700)
,p_name=>'CA.EMAILS.SENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\6E08\96FB\5B50\30E1\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280705940972869719)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6DFB\4ED8\6709\52B9\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279789819310869151)
,p_name=>'CA.ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279787079286869149)
,p_name=>'CA.END.DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280677519592869701)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\5F8C\30B3\30F3\30C6\30F3\30C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280693647057869711)
,p_name=>'CA.ENTER.USERNAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D\3092\3053\3053\306B\5165\529B\3057\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280666051555869694)
,p_name=>'CA.ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280668341896869695)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC\30FB\30D0\30C3\30AF\30C8\30EC\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280668290407869695)
,p_name=>'CA.ERROR.CODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC\30FB\30B3\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280667575493869695)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC\30FB\30E1\30C3\30BB\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279791538461869152)
,p_name=>'CA.ERROR.NUMBER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC\756A\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279790524261869151)
,p_name=>'CA.ERRORS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279787442701869150)
,p_name=>'CA.EVENT.CONDITION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279787538968869150)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8\30FB\30AD\30E5\30FC\30FB\30A8\30FC\30B8\30A7\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279787659202869150)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8\30FB\30AD\30E5\30FC\306E\540D\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279787755986869150)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8\30FB\30AD\30E5\30FC\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279787376171869149)
,p_name=>'CA.EVENT.RULE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8\30FB\30EB\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280693945419869711)
,p_name=>'CA.EXCEPTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F8B\5916')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280706803997869719)
,p_name=>'CA.EXPERIENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30AF\30B9\30DA\30EA\30A8\30F3\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279789531969869151)
,p_name=>'CA.FAILURE.COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5931\6557\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280664047373869693)
,p_name=>'CA.FEATURE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280444028898869557)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30D0\30FC\30B8\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280444187331869558)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279936014329869242)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\3078\306E\30E6\30FC\30B6\30FC\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279935859685869242)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\30B9\30C6\30C3\30D7\306B\9032\3080')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279935900187869242)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30EC\30AF\30B7\30E7\30F3\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279935787433869242)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\7D42\7BA1\7406\8005\306F\5909\66F4\3067\304D\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280443784345869557)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5F8C\306E\30A2\30AF\30C6\30A3\30D3\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279935594940869242)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30C6\30A3\30D3\30C6\30A3\304C\898B\3064\304B\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280443964234869557)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_language=>'ja'
,p_message_text=>unistr('\7406\7531')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279936162362869242)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5C11\306A\304F\3068\30821\3064\306E\30D5\30A3\30FC\30C9\30D0\30C3\30AF\304C\5FC5\8981\3067\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279936403670869242)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30A4\30EBID\306E\53D6\5F97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279935047994869241)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\4FDD\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279935173239869241)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306E\30B9\30BF\30A4\30EB\30FB\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\4FDD\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280443831500869557)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280652236989869685)
,p_name=>'CA.FEATURES'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280652373202869685)
,p_name=>'CA.FEATURES.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A5F\80FD\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30EC\30D9\30EB\306E\6A5F\80FD\3092\63D0\4F9B\3057\3001\901A\5E38\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3054\3068\306B1\56DE\8FFD\52A0\3055\308C\307E\3059\3002\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\542B\3081\308B\6A5F\80FD\3092\9078\629E\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280646138741869682)
,p_name=>'CA.FEEDBACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280644183742869680)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306B\3088\308B\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306E\63D0\4F9B\3092\8A31\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280646098605869682)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\304A\3088\3073\958B\767A\8005\306B\4E00\822C\7684\306A\30B3\30E1\30F3\30C8\3092\6295\7A3F\3059\308B\30E1\30AB\30CB\30BA\30E0\3092\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\63D0\4F9B\3057\307E\3059\3002\6295\7A3F\306B\306F\3001\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\3069\3053\304B\3089\30D5\30A3\30FC\30C9\30D0\30C3\30AF\3092\9001\4FE1\3057\305F\304B\3092\5224\65AD\3059\308B\305F\3081\306B\5F79\7ACB\3064\6709\76CA\306A\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\60C5\5831\304C\542B\307E\308C\307E\3059\3002\3053\306E\3088\3046\306B\7C21\5358\306A\30D5\30A3\30FC\30C9\30D0\30C3\30AF\30FB\30EB\30FC\30D7\3092\63D0\4F9B\3059\308B\3053\3068\3067\3001\30E6\30FC\30B6\30FC\30FB\30B3\30DF\30E5\30CB\30C6\30A3\3068\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\6240\6709\8005\306E\9593\306E\30B3\30DF\30E5\30CB\30B1\30FC\30B7\30E7\30F3\304C\62E1\5927\3057\3001\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306E\6E80\8DB3\5EA6\304C\5927\5E45\306B\5411\4E0A\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\542B\307E\308C\307E\3059:'),
'<ul>',
unistr('<li>\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\30FB\30A2\30A4\30B3\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\30D5\30A3\30FC\30C9\30D0\30C3\30AF\3092\6B8B\3059\3053\3068\304C\3067\304D\308B\6A5F\80FD</li>'),
unistr('<li>\30D5\30A3\30FC\30C9\30D0\30C3\30AF\3092\8868\793A\304A\3088\3073\66F4\65B0\3059\308B\305F\3081\306E\7BA1\7406\30EC\30DD\30FC\30C8</li>'),
unistr('<li>\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306B\3088\308B\30E6\30FC\30B6\30FC\3001\65E5\6642\304A\3088\3073\30E6\30FC\30B6\30FC\30FB\30A8\30FC\30B8\30A7\30F3\30C8\60C5\5831\306E\53D6\5F97</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280707201050869719)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF\307E\305F\306F\30A8\30AF\30B9\30DA\30EA\30A8\30F3\30B9\3092\63D0\4F9B\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280706216003869719)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280705671577869718)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280673549136869699)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF\8A2D\5B9A\304C\66F4\65B0\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280706455190869719)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF\304C\767A\884C\3055\308C\307E\3057\305F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279787106838869149)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30A4\30EB\30FB\30A6\30A9\30C3\30C1\30E3\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279787274326869149)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30A4\30EB\30FB\30A6\30A9\30C3\30C1\30E3\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279442396562868940)
,p_name=>'CA.FILED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30A4\30EB\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279442416804868940)
,p_name=>'CA.FILED.BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30A4\30E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280701951839869716)
,p_name=>'CA.FILTER.REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\30FB\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280677902603869701)
,p_name=>'CA.FILTERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280704615011869718)
,p_name=>'CA.FINISH'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280672244341869698)
,p_name=>'CA.FIRST.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279784136676869148)
,p_name=>'CA.FLAGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30E9\30B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280653691706869686)
,p_name=>'CA.FORM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280653545849869686)
,p_name=>'CA.FORM.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\30C7\30FC\30BF\3092\30E1\30F3\30C6\30CA\30F3\30B9\3067\304D\308B\3088\3046\306B\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\3092\8868\793A\3059\308B\30DA\30FC\30B8\3092\4F5C\6210\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30DA\30FC\30B8\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\8868</strong>(\5FC5\9808) - \30D5\30A9\30FC\30E0\306E\8868\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('<li><strong>\30EC\30DD\30FC\30C8\3092\542B\3081\308B</strong>(\5FC5\9808) - \30EC\30DD\30FC\30C8\304A\3088\3073\30D5\30A9\30FC\30E0\3092\4F5C\6210\3059\308B\306B\306F\3001\3053\306E\30AA\30D7\30B7\30E7\30F3\3092\9078\629E\3057\307E\3059\3002\6700\521D\306E\30DA\30FC\30B8\306F\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3067\3059\3002\5404\884C\3067\306F\3001\30E6\30FC\30B6\30FC\304C\30EC\30B3\30FC\30C9\3092\66F4\65B0\3067\304D\308B\30D5\30A9\30FC\30E0\3078\306E\30EA\30F3\30AF\304C\63D0\4F9B\3055\308C\307E\3059\3002 </li>'),
'  &nbsp;<br>',
unistr('<li><strong>\8A73\7D30</strong> - \5C55\958B\3057\3066\8A73\7D30\30AA\30D7\30B7\30E7\30F3\3092\8868\793A\3057\307E\3059\3002'),
'     <ul>',
unistr('      <li><strong>\30DA\30FC\30B8\306E\30D8\30EB\30D7</strong> - \30DA\30FC\30B8\306E\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8\306B\8FFD\52A0\3059\308B\30C6\30AD\30B9\30C8\3092\5165\529B\3057\307E\3059\3002</li>'),
'      </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279572007041869019)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30A2\30A4\30C6\30E0\30FB\30EA\30FC\30B8\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280679859570869703)
,p_name=>'CA.FORM.ON'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\30D5\30A9\30FC\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280693407872869711)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\306E\30BF\30A4\30D7\304C\6709\52B9\306A\30BF\30A4\30D7\3067\306F\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280699817284869715)
,p_name=>'CA.FORMATMASK'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F8\5F0F\30DE\30B9\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280698888507869714)
,p_name=>'CA.FORMCONTROL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30B3\30F3\30C8\30ED\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280663461115869692)
,p_name=>'CA.FROM'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\59CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280676631658869701)
,p_name=>'CA.FROM.ADDRESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\5143\30A2\30C9\30EC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280701340719869716)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\9001\4FE1\5143\30A2\30C9\30EC\30B9\300D\96FB\5B50\30E1\30FC\30EB\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280697235532869713)
,p_name=>'CA.FROM.EMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\5143\96FB\5B50\30E1\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280697129883869713)
,p_name=>'CA.FROM.WHO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5DEE\51FA\4EBA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280445943412869559)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\691C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280666999932869695)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5168\4F53\30DA\30FC\30B8\30FB\30D3\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280675614556869700)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B8C\5168\30C6\30F3\30D7\30EC\30FC\30C8HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280698340567869714)
,p_name=>'CA.FUNCTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A1\30F3\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280646551973869682)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30ED\30FC\30D0\30EB\691C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280644314967869681)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\691C\7D22\6A5F\80FD\306E\63D0\4F9B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280646440869869682)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\306E\4E3B\8981\306A\8868\307E\305F\306F\30D3\30E5\30FC\5168\4F53\3067\30C6\30AD\30B9\30C8\3092\691C\7D22\3067\304D\308B\3088\3046\306B\3057\307E\3059\3002\62E1\5F35\691C\7D22\30DA\30FC\30B8\306B\306F\3001\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\7D50\679C\3092\7C21\5358\306B\7D5E\308A\8FBC\3081\308B\3088\3046\306B\3059\308B\30D5\30A3\30EB\30BF\304C\542B\307E\308C\307E\3059\3002<br>'),
unistr('\3053\306E\975E\5E38\306B\5F37\529B\306A\6A5F\80FD\3092\4F7F\7528\3059\308B\306B\306F\3001(\63D0\4F9B\3055\308C\3066\3044\308B\4F8B\306B\57FA\3065\3044\3066) SQL\3092\5B9A\7FA9\3059\308B\305F\3081\306E\958B\767A\4F5C\696D\304C\5FC5\8981\3067\3059\3002</p>'),
unistr('<p>\6B21\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\542B\307E\308C\307E\3059:'),
'<ul>',
unistr('<li>\30D8\30C3\30C0\30FC\30FB\30D0\30FC\306E\691C\7D22\30A2\30A4\30B3\30F3\306E\8868\793A</li>'),
unistr('<li>\30B5\30A4\30C9\30FB\30D0\30FC\30FB\30D5\30A3\30EB\30BF\4ED8\304D\306E\8A73\7D30\691C\7D22\7D50\679C\30DA\30FC\30B8\306E\7D44\8FBC\307F</li>'),
unistr('<li>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\691C\7D22\3092\5B9A\7FA9\3059\308B\305F\3081\306E\958B\767A\8005\306B\3088\308BSQL\306E\5B9F\88C5\304C\5FC5\8981</li>'),
unistr('<li>\5B9F\4F8B\306E\305F\3081\306E\30B5\30F3\30D7\30EB\30FB\30C7\30FC\30BF\306E\7D44\8FBC\307F</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279788856872869150)
,p_name=>'CA.GLOBAL.UID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30ED\30FC\30D0\30EB\4E00\610FID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279934640054869241)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B0\30ED\30FC\30D0\30EB\30FB\30DA\30FC\30B8 - \30C7\30B9\30AF\30C8\30C3\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279551879307869006)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\30DA\30FC\30B8\306B\79FB\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280653196050869686)
,p_name=>'CA.GRID'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30B0\30EA\30C3\30C9\30FB\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280653298135869686)
,p_name=>'CA.GRID.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30B9\30D7\30EC\30C3\30C9\30B7\30FC\30C8\306B\4F3C\305F\5BFE\8A71\30B0\30EA\30C3\30C9\3068\3057\3066\8868\793A\3059\308B\30DA\30FC\30B8\3092\4F5C\6210\3057\307E\3059\3002\7DE8\96C6\53EF\80FD\306A\5834\5408\3001\30E6\30FC\30B6\30FC\306F\30DA\30FC\30B8\4E0A\3067\76F4\63A5\8907\6570\306E\884C\3092\7DE8\96C6\3067\304D\307E\3059(\3064\307E\308A\300C\7DE8\96C6\306E\8A31\53EF\300D\304C\6709\52B9\306A\5834\5408)\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30DA\30FC\30B8\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\554F\5408\305B\30BF\30A4\30D7</strong> - \30EC\30DD\30FC\30C8\306E\30BD\30FC\30B9[<strong>\8868\307E\305F\306F\30D3\30E5\30FC</strong>\307E\305F\306F<strong>SQL\554F\5408\305B</strong>]\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('    <strong>\8868\307E\305F\306F\30D3\30E5\30FC</strong>:'),
'    <ul>',
unistr('      <li><strong>\8868\307E\305F\306F\30D3\30E5\30FC</strong>(\5FC5\9808) - \30B0\30EA\30C3\30C9\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\9078\629E\3057\307E\3059\3002</li>'),
'    </ul>',
unistr('    <strong>SQL\554F\5408\305B</strong>:'),
'    <ul>',
unistr('      <li><strong>SQL\554F\5408\305B</strong>(\5FC5\9808) - \56FA\6709\306E\5217\3092\623B\3059\6709\52B9\306ASQL\6587\3092\5165\529B\3057\307E\3059\3002</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>\30B0\30EA\30C3\30C9\30FB\30BF\30A4\30D7</strong> - \30E6\30FC\30B6\30FC\306B\30B0\30EA\30C3\30C9\5185\306E\884C\306E\7DE8\96C6\3092\8A31\53EF\3059\308B\304B\3069\3046\304B\3092\9078\629E\3057\307E\3059[<strong>\7DE8\96C6\306E\8A31\53EF</strong>\307E\305F\306F<strong>\8AAD\53D6\308A\5C02\7528</strong>]\3002\7DE8\96C6\3092\6709\52B9\306B\3059\308B\306B\306F\3001<strong>\300C\7DE8\96C6\306E\8A31\53EF\300D</strong>\3092\9078\629E\3057\307E\3059\3002</li>'),
'  &nbsp;<br>',
unistr('  <em><strong>\8B66\544A:</strong> \300C\554F\5408\305B\30BF\30A4\30D7\300D\306B<strong>\300CSQL\554F\5408\305B\300D</strong>\3092\3001\300C\30B0\30EA\30C3\30C9\30FB\30BF\30A4\30D7\300D\306B<strong>\300C\7DE8\96C6\306E\8A31\53EF\300D</strong>\3092\9078\629E\3057\3001\554F\5408\305B\30672\3064\4EE5\4E0A\306E\8868\3092\7D50\5408\3059\308B\3068\3001\30E6\30FC\30B6\30FC\304C\30EC\30B3\30FC\30C9\3092\66F4\65B0\3057\3088\3046\3068\3057\305F\3068\304D\306B\3001\751F\6210\3055\308C\305F\5BFE\8A71\30B0\30EA\30C3\30C9\306B\969C\5BB3\304C\767A\751F\3057\307E\3059\3002'),
unistr('\307E\305F\3001\300C\30B0\30EA\30C3\30C9\30FB\30BF\30A4\30D7\300D\306B<strong>\300C\7DE8\96C6\306E\8A31\53EF\300D</strong>\3092\9078\629E\3057\3001\554F\5408\305B(\307E\305F\306F\9078\629E\3057\305F\8868\307E\305F\306F\30D3\30E5\30FC)\3067\66F4\65B0\4E0D\53EF\80FD\306A\30D3\30E5\30FC\3092\4F7F\7528\3059\308B\3068\3001\30E6\30FC\30B6\30FC\304C\30EC\30B3\30FC\30C9\3092\66F4\65B0\3057\3088\3046\3068\3057\305F\3068\304D\306B\3001\751F\6210\3055\308C\305F\5BFE\8A71\30B0\30EA\30C3\30C9\306B\969C\5BB3\304C\767A\751F\3057\307E\3059\3002</em><br>'),
'  </li>',
'</ul>',
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280678433676869702)
,p_name=>'CA.HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D8\30EB\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280670888946869697)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\30E6\30FC\30B6\30FC\304C\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306B\5B9A\7FA9\3055\308C\3066\3044\308B\5834\5408\3001<strong>\300C\3044\3044\3048\300D</strong>\3092\9078\629E\3057\307E\3059\3002\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306B\5B58\5728\3057\306A\3044\8A8D\8A3C\3055\308C\305F\30E6\30FC\30B6\30FC\3082\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F7F\7528\3059\308B\5834\5408\3001<strong>\300C\306F\3044\300D</strong>\3092\9078\629E\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280664580043869693)
,p_name=>'CA.HELP.APP.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\3053\3067\5165\529B\3057\305F\30C6\30AD\30B9\30C8\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5168\4F53(\7279\306B\3001\3059\3079\3066\306E\30DA\30FC\30B8\306E\5DE6\4E0A\9685)\3067\4F7F\7528\3055\308C\307E\3059\3002\5909\66F4\306F\3001\5909\66F4\3092\884C\3063\305F\7BA1\7406\8005\306B\5BFE\3057\3066\306F\5373\5EA7\306B\6709\52B9\306B\306A\308A\307E\3059\304C\3001\4ED6\306E\30E6\30FC\30B6\30FC\306F\3001\65B0\3057\3044\30BB\30C3\30B7\30E7\30F3\3092\958B\59CB\3057\305F\3068\304D(\6B21\56DE\30ED\30B0\30A4\30F3\6642\306A\3069)\306B\306E\307F\305D\306E\5909\66F4\3092\78BA\8A8D\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280659109296869690)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\3069\306E\30DA\30FC\30B8\304B\3089\3067\3082\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\306E\30D5\30A3\30FC\30C9\30D0\30C3\30AF\30FB\30A2\30A4\30B3\30F3( <span class="fa fa-comment-o" aria-hidden="true"></span> )\3092\30AF\30EA\30C3\30AF\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\306B\30D5\30A3\30FC\30C9\30D0\30C3\30AF\3092\6B8B\3059\3053\3068\304C\3067\304D\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280658807625869690)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\3053\308C\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DB\30FC\30E0\30DA\30FC\30B8\3067\3059\3002\30AB\30FC\30C9\3092\30AF\30EA\30C3\30AF\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\306E\7570\306A\308B\30DA\30FC\30B8\306B\30A2\30AF\30BB\30B9\3059\308B\304B\3001\30DA\30FC\30B8\306E\6A2A\5074\306B\3042\308B\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\3092\4F7F\7528\3057\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280659055306869690)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\3053\308C\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DB\30FC\30E0\30DA\30FC\30B8\3067\3059\3002\30AB\30FC\30C9\3092\30AF\30EA\30C3\30AF\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\306E\7570\306A\308B\30DA\30FC\30B8\306B\30A2\30AF\30BB\30B9\3059\308B\304B\3001\30DA\30FC\30B8\306E\4E00\756A\4E0A\306B\3042\308B\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\3092\4F7F\7528\3057\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280659264867869690)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\3053\306E\30DA\30FC\30B8\306E<strong>\300C\691C\7D22\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\300D</strong>\30D5\30A3\30FC\30EB\30C9\306B\691C\7D22\6587\5B57\5217\3092\5165\529B\3059\308B\304B\3001\4EFB\610F\306E\30DA\30FC\30B8\304B\3089\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\306E\691C\7D22\30A2\30A4\30B3\30F3( <span class="fa fa-search" aria-hidden="true"></span> )\3092\30AF\30EA\30C3\30AF\3057\3066\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\3067\8A9E\53E5\3092\691C\7D22\3057\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280659545616869690)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\306E\81EA\5206\306E\540D\524D\306E\30C9\30ED\30C3\30D7\30C0\30A6\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\30B5\30A4\30F3\30A2\30A6\30C8\3057\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280659475686869690)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\306E\30E6\30FC\30B6\30FC\30FB\30E1\30CB\30E5\30FC( <span class="fa fa-user" aria-hidden="true"></span> )\3092\30AF\30EA\30C3\30AF\3057\3066\3001\30BF\30A4\30E0\30BE\30FC\30F3\30FB\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\66F4\65B0\3068\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\306E\30B5\30A4\30F3\30A2\30A6\30C8\3092\884C\3044\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280658938860869690)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DB\30FC\30E0\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280659675421869690)
,p_name=>'CA.HELP.HOME.USER'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC(\30DA\30FC\30B8\306E\53F3\4E0A)\306E\30E6\30FC\30B6\30FC\30FB\30E1\30CB\30E5\30FC( <span class="fa fa-user" aria-hidden="true"></span> )\3092\30AF\30EA\30C3\30AF\3057\3066\3001\30E6\30FC\30B6\30FC\30FB\30D7\30ED\30D5\30A1\30A4\30EB\3078\306E\30A2\30AF\30BB\30B9\3068\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\306E\30B5\30A4\30F3\30A2\30A6\30C8\3092\884C\3044\307E\3059\3002<br>'),
unistr('<strong>\300C\30D7\30ED\30D5\30A1\30A4\30EB\306E\8868\793A\300D</strong>\3092\30AF\30EA\30C3\30AF\3059\308B\5834\5408\3001<strong>\300C\30D7\30ED\30D5\30A1\30A4\30EB\306E\66F4\65B0\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3001\500B\4EBA\60C5\5831\306E\8A73\7D30\3092\5165\529B\3057\3066\5199\771F\3084\30A2\30D0\30BF\30FC\3092\30A2\30C3\30D7\30ED\30FC\30C9\3067\304D\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280659307078869690)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30D0\30FC\306E\30E6\30FC\30B6\30FC\30FB\30E1\30CB\30E5\30FC( <span class="fa fa-user" aria-hidden="true"></span> )\3092\30AF\30EA\30C3\30AF\3057\3066\3001\30E6\30FC\30B6\30FC\30FB\30D7\30ED\30D5\30A1\30A4\30EB\3078\306E\30A2\30AF\30BB\30B9\3001\30BF\30A4\30E0\30BE\30FC\30F3\30FB\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\66F4\65B0\3001\304A\3088\3073\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\306E\30B5\30A4\30F3\30A2\30A6\30C8\3092\884C\3044\307E\3059\3002<br>'),
unistr('<strong>\300C\30D7\30ED\30D5\30A1\30A4\30EB\306E\8868\793A\300D</strong>\3092\30AF\30EA\30C3\30AF\3059\308B\5834\5408\3001<strong>\300C\30D7\30ED\30D5\30A1\30A4\30EB\306E\66F4\65B0\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3001\500B\4EBA\60C5\5831\306E\8A73\7D30\3092\5165\529B\3057\3066\5199\771F\3084\30A2\30D0\30BF\30FC\3092\30A2\30C3\30D7\30ED\30FC\30C9\3067\304D\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280685482813869706)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30C7\30FC\30BF\3092\898B\3064\3051\308B\306B\306F\3001\691C\7D22\30C0\30A4\30A2\30ED\30B0\306B\691C\7D22\6587\5B57\5217\3092\5165\529B\3059\308B\304B\3001\5217\30D8\30C3\30C0\30FC\3092\30AF\30EA\30C3\30AF\3057\3066\623B\3055\308C\308B\30EC\30B3\30FC\30C9\3092\5236\9650\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\300C\30A2\30AF\30B7\30E7\30F3\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\591A\304F\306E\6A5F\80FD\3092\5B9F\884C\3067\304D\307E\3059\3002\3053\308C\306B\306F\3001\8868\793A\5217\307E\305F\306F\975E\8868\793A\5217\306E\9078\629E\3068\305D\306E\8868\793A\9806\5E8F\306B\52A0\3048\3001\591A\304F\306E\30C7\30FC\30BF\304A\3088\3073\66F8\5F0F\8A2D\5B9A\6A5F\80FD\304C\542B\307E\308C\307E\3059\3002\30C1\30E3\30FC\30C8\30FB\30AA\30D7\30B7\30E7\30F3\3092\4F7F\7528\3057\3066\3001\30C7\30FC\30BF\306E\8FFD\52A0\30D3\30E5\30FC\3092\5B9A\7FA9\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\72EC\81EA\306E\30AB\30B9\30BF\30DE\30A4\30BA\5185\5BB9\3092\4FDD\5B58\3059\308B\5834\5408\3001\30EC\30DD\30FC\30C8\3092\9078\629E\3059\308B\304B\3001\300C\30C0\30A6\30F3\30ED\30FC\30C9\300D\3092\30AF\30EA\30C3\30AF\3057\3066\30C7\30FC\30BF\3092\30A2\30F3\30ED\30FC\30C9\3057\307E\3059\3002<p>'),
'<br>',
unistr('<p>\8FFD\52A0\60C5\5831\3092\5165\624B\3059\308B\306B\306F\3001\300C\30A2\30AF\30B7\30E7\30F3\300D\30E1\30CB\30E5\30FC\306E\4E00\756A\4E0B\306E\300C\30D8\30EB\30D7\300D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\300C\30EA\30BB\30C3\30C8\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\623B\3059\3053\3068\304C\3067\304D\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280685320994869706)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\5BFE\8A71\30B0\30EA\30C3\30C9\5185\3067\30C7\30FC\30BF\3092\76F4\63A5\633F\5165\3001\66F4\65B0\304A\3088\3073\524A\9664\3067\304D\307E\3059\3002<br>'),
unistr('  \300C\884C\306E\8FFD\52A0\300D\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\65B0\3057\3044\884C\3092\633F\5165\3067\304D\307E\3059\3002<br>'),
unistr('  \30BB\30EB\5185\3092\30C0\30D6\30EB\30AF\30EA\30C3\30AF\3059\308B\304B\3001<strong>\300C\7DE8\96C6\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\30B9\30D7\30EC\30C3\30C9\30B7\30FC\30C8\3067\30C7\30FC\30BF\3092\7DE8\96C6\3059\308B\5834\5408\3068\540C\3058\3088\3046\306B\30C7\30FC\30BF\5024\3092\66F4\65B0\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\30EC\30DD\30FC\30C8\306E\4E00\756A\4E0A\306B\3042\308B\300C\884C\30A2\30AF\30B7\30E7\30F3\300D\30E1\30CB\30E5\30FC(<span class="fa fa-bars" aria-hidden="true"></span>)\3092\4F7F\7528\3057\3066\3001\9078\629E\3057\305F\884C\3092\8907\88FD\3001\524A\9664\3001\30EA\30D5\30EC\30C3\30B7\30E5\307E\305F\306F\56DE\5FA9\3057\307E\3059\3002<br>'),
unistr('  \500B\3005\306E\884C\306E\300C\884C\30A2\30AF\30B7\30E7\30F3\300D\30E1\30CB\30E5\30FC\3092\4F7F\7528\3057\3066\3001\5358\4E00\884C\30D3\30E5\30FC\306B\30A2\30AF\30BB\30B9\3057\305F\308A\3001\65B0\3057\3044\884C\3092\8FFD\52A0\3057\305F\308A\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\30C7\30FC\30BF\3092\898B\3064\3051\308B\306B\306F\3001\691C\7D22\30C0\30A4\30A2\30ED\30B0\306B\691C\7D22\6587\5B57\5217\3092\5165\529B\3059\308B\304B\3001\5217\30D8\30C3\30C0\30FC\3092\30AF\30EA\30C3\30AF\3057\3066\623B\3055\308C\308B\30EC\30B3\30FC\30C9\3092\5236\9650\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\300C\30A2\30AF\30B7\30E7\30F3\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\591A\304F\306E\6A5F\80FD\3092\5B9F\884C\3067\304D\307E\3059\3002\3053\308C\306B\306F\3001\8868\793A\5217\307E\305F\306F\975E\8868\793A\5217\306E\9078\629E\3068\305D\306E\8868\793A\9806\5E8F\306B\52A0\3048\3001\591A\304F\306E\30C7\30FC\30BF\304A\3088\3073\66F8\5F0F\8A2D\5B9A\6A5F\80FD\304C\542B\307E\308C\307E\3059\3002\30C1\30E3\30FC\30C8\30FB\30AA\30D7\30B7\30E7\30F3\3092\4F7F\7528\3057\3066\3001\30C7\30FC\30BF\306E\8FFD\52A0\30D3\30E5\30FC\3092\5B9A\7FA9\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\72EC\81EA\306E\30AB\30B9\30BF\30DE\30A4\30BA\5185\5BB9\3092\4FDD\5B58\3059\308B\5834\5408\3001\30EC\30DD\30FC\30C8\3092\9078\629E\3059\308B\304B\3001\300C\30C0\30A6\30F3\30ED\30FC\30C9\300D\3092\30AF\30EA\30C3\30AF\3057\3066\30C7\30FC\30BF\3092\30A2\30F3\30ED\30FC\30C9\3057\307E\3059\3002<p>'),
'',
unistr('<p>\8FFD\52A0\60C5\5831\3092\5165\624B\3059\308B\306B\306F\3001\300C\30A2\30AF\30B7\30E7\30F3\300D\30E1\30CB\30E5\30FC\306E\4E00\756A\4E0B\306E\300C\30D8\30EB\30D7\300D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\300C\30EA\30BB\30C3\30C8\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\623B\3059\3053\3068\304C\3067\304D\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280658792940869689)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30C7\30FC\30BF\3092\898B\3064\3051\308B\306B\306F\3001\691C\7D22\30C0\30A4\30A2\30ED\30B0\306B\691C\7D22\6587\5B57\5217\3092\5165\529B\3059\308B\304B\3001\5217\30D8\30C3\30C0\30FC\3092\30AF\30EA\30C3\30AF\3057\3066\623B\3055\308C\308B\30EC\30B3\30FC\30C9\3092\5236\9650\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\300C\30A2\30AF\30B7\30E7\30F3\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\591A\304F\306E\6A5F\80FD\3092\5B9F\884C\3067\304D\307E\3059\3002\3053\308C\306B\306F\3001\8868\793A\5217\307E\305F\306F\975E\8868\793A\5217\306E\9078\629E\3068\305D\306E\8868\793A\9806\5E8F\306B\52A0\3048\3001\591A\304F\306E\30C7\30FC\30BF\304A\3088\3073\66F8\5F0F\8A2D\5B9A\6A5F\80FD\304C\542B\307E\308C\307E\3059\3002\30C1\30E3\30FC\30C8\3001\30B0\30EB\30FC\30D7\5316\304A\3088\3073\30D4\30DC\30C3\30C8\30FB\30AA\30D7\30B7\30E7\30F3\3092\4F7F\7528\3057\3066\3001\30C7\30FC\30BF\306E\8FFD\52A0\30D3\30E5\30FC\3092\5B9A\7FA9\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002</p>'),
'',
unistr('<p>\72EC\81EA\306E\30AB\30B9\30BF\30DE\30A4\30BA\5185\5BB9\3092\4FDD\5B58\3059\308B\5834\5408\3001\30EC\30DD\30FC\30C8\3092\9078\629E\3059\308B\304B\3001\300C\30C0\30A6\30F3\30ED\30FC\30C9\300D\3092\30AF\30EA\30C3\30AF\3057\3066\30C7\30FC\30BF\3092\30A2\30F3\30ED\30FC\30C9\3057\307E\3059\3002\5B9A\671F\7684\306B\30C7\30FC\30BF\3092\9001\4FE1\3059\308B\30B5\30D6\30B9\30AF\30EA\30D7\30B7\30E7\30F3\3067\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3068\6642\9593\67A0\3092\5165\529B\3057\307E\3059\3002<p>'),
'',
unistr('<p>\8FFD\52A0\60C5\5831\3092\5165\624B\3059\308B\306B\306F\3001\300C\30A2\30AF\30B7\30E7\30F3\300D\30E1\30CB\30E5\30FC\306E\4E00\756A\4E0B\306E\300C\30D8\30EB\30D7\300D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</p>'),
'',
unistr('<p><strong>\300C\30EA\30BB\30C3\30C8\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\623B\3059\3053\3068\304C\3067\304D\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280694412493869712)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\3067\306F\3001\30DA\30FC\30B8\306E\7AEF\306B\3042\308B\30BB\30EC\30AF\30BF\306B\30D7\30E9\30A4\30DE\30EA\30FB\30EC\30B3\30FC\30C9\304C\8868\793A\3055\308C\307E\3059\3002'),
unistr('  \30EC\30B3\30FC\30C9\3092\9078\629E\3057\3066\3001\30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9\304A\3088\3073\5B9A\7FA9\3055\308C\3066\3044\308B\30C7\30A3\30C6\30FC\30EB\30FB\30EC\30B3\30FC\30C9\3092\8868\793A\3057\307E\3059\3002<br> '),
unistr('  \7DE8\96C6\30A2\30A4\30B3\30F3(<span class="fa fa-pencil-square-o" aria-hidden="true"></span>)\3092\30AF\30EA\30C3\30AF\3057\3066\30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9\3092\7DE8\96C6\3057\307E\3059\3002'),
unistr('  \30C7\30A3\30C6\30FC\30EB\30FB\30EC\30B3\30FC\30C9\306E\5834\5408\306F\3001\5404\884C\306E\5148\982D\306B\3042\308B\925B\7B46\3092\30AF\30EA\30C3\30AF\3057\3066\3001\305D\306E\30EC\30B3\30FC\30C9\3092\7DE8\96C6\3057\307E\3059\3002</p>'),
unistr('<p>\30BB\30EC\30AF\30BF\306B\8868\793A\3055\308C\308B\30C7\30FC\30BF\3092\5236\9650\3059\308B\306B\306F\3001\691C\7D22\30C0\30A4\30A2\30ED\30B0\306B\691C\7D22\8A9E\3092\5165\529B\3057\307E\3059\3002</p>'),
'',
unistr('<p>\65B0\3057\3044\30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9\3092\8FFD\52A0\3059\308B\306B\306F\3001\30DA\30FC\30B8\306E\4E0A\90E8\306B\3042\308B<strong>\300C\4F5C\6210\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002'),
unistr('  \30C7\30A3\30C6\30FC\30EB\30FB\30EC\30B3\30FC\30C9\306E\5834\5408\306F\3001\30C7\30A3\30C6\30FC\30EB\30FB\30EA\30FC\30B8\30E7\30F3\306E\4E0A\90E8\306B\3042\308B\30D7\30E9\30B9\30FB\30A2\30A4\30B3\30F3(+)\3092\30AF\30EA\30C3\30AF\3057\3066\3001\30C7\30A3\30C6\30FC\30EB\30FB\30EC\30B3\30FC\30C9\3092\8FFD\52A0\3057\307E\3059\3002</p>'),
'',
unistr('<p>\30DA\30FC\30B8\306E\4E0A\90E8\306B\3042\308B<strong>\300C\30EA\30BB\30C3\30C8\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3066\3001\30DA\30FC\30B8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\30EA\30BB\30C3\30C8\3057\3001\524D\306B\5B9A\7FA9\3057\305F\691C\7D22\8A9E\3092\524A\9664\3057\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280656739878869688)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7BA1\7406\30DA\30FC\30B8\3067\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\6240\6709\8005(\7BA1\7406\8005)\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\69CB\6210\3057\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5168\4F53\3067\4F7F\7528\3055\308C\308B\5171\901A\30C7\30FC\30BF\3092\7BA1\7406\3067\304D\307E\3059\3002'),
unistr('\7BA1\7406\8005\306F\3001\4F7F\7528\53EF\80FD\306A\8A2D\5B9A\306E\3044\305A\308C\304B\3092\9078\629E\3057\3066\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8868\793A\65B9\6CD5\307E\305F\306F\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\4F7F\7528\53EF\80FD\306A\6A5F\80FD(\3042\308B\3044\306F\305D\306E\4E21\65B9)\3092\5FC5\8981\306B\5FDC\3058\3066\5909\66F4\3067\304D\307E\3059\3002</p>'),
unistr('<p>\3053\306E\30DA\30FC\30B8\3078\306E\30A2\30AF\30BB\30B9\306F\3001\7BA1\7406\8005\306E\307F\306B\5236\9650\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280657931639869689)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8A8D\8A3C\3055\308C\305F\30E6\30FC\30B6\30FC\306E\9069\5207\306A\9078\629E\9805\76EE\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('<strong>\300C\3044\3044\3048\300D</strong>\3092\9078\629E\3059\308B\3068\3001\6307\5B9A\3057\305F\30E6\30FC\30B6\30FC\306E\307F\304C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\30A2\30AF\30BB\30B9\3067\304D\308B\3053\3068\306B\306A\308B\305F\3081\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30BB\30AD\30E5\30EA\30C6\30A3\304C\5411\4E0A\3057\307E\3059\3002'),
unistr('\305F\3060\3057\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304C\5927\898F\6A21\306A\30E6\30FC\30B6\30FC\30FB\30B3\30DF\30E5\30CB\30C6\30A3\3092\6301\3063\3066\3044\308B\5834\5408\306F\3001\30E6\30FC\30B6\30FC\306E\7BA1\7406\304C\8CA0\62C5\306B\306A\308B\53EF\80FD\6027\304C\3042\308B\305F\3081\3001<strong>\300C\306F\3044\300D</strong>\3092\512A\5148\7684\306B\9078\629E\3057\3066\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\7BA1\7406\8005\3068\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF\306E\307F\3092\5165\529B\3067\304D\307E\3059\3002<br>'),
unistr('<strong>\300C\306F\3044\300D</strong>\3092\9078\629E\3059\308B\5834\5408\3001\30E6\30FC\30B6\30FC\30FB\30EA\30B9\30C8\306B\542B\3081\306A\3044\30E6\30FC\30B6\30FC\306E\51E6\7406\65B9\6CD5\3082\9078\629E\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002</p>'),
unistr('<p>\30E6\30FC\30B6\30FC\540D\306B\5BFE\3057\3066\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3092\8981\6C42\3059\308B\304B\3001\4EFB\610F\306E\82F1\6570\5B57\5024\3092\4F7F\7528\53EF\80FD\306B\3059\308B\304B\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('\901A\5E38\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067Oracle Access Manager\3084SSO\306A\3069\306E\4E2D\592E\7BA1\7406\8A8D\8A3C\30B9\30AD\30FC\30E0\3092\4F7F\7528\3057\3066\3044\308B(\307E\305F\306F\5C06\6765\4F7F\7528\3059\308B\3088\3046\306B\69CB\6210\3059\308B)\5834\5408\3001\3053\306E\8A2D\5B9A\306F<strong>\300C\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\300D</strong>\306B\8A2D\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002</p>'),
unistr('<p><em><strong>\6CE8\610F:</strong> \3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\306F\3001\30EA\30FC\30C0\30FC\3001\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF\304A\3088\3073\7BA1\7406\8005\3068\3044\30463\3064\306E\30A2\30AF\30BB\30B9\30FB\30EC\30D9\30EB\304C\30B5\30DD\30FC\30C8\3055\308C\307E\3059\3002'),
'<ul>',
unistr('  <li><strong>\30EA\30FC\30C0\30FC</strong>\306F\3001\3059\3079\3066\306E\60C5\5831\306B\5BFE\3059\308B\8AAD\53D6\308A\5C02\7528\30A2\30AF\30BB\30B9\6A29\3092\6301\3061\3001\30EC\30DD\30FC\30C8\3092\53C2\7167\3067\304D\307E\3059\3002</li>'),
unistr('  <li><strong>\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF</strong>\306F\3001\60C5\5831\306E\4F5C\6210\3001\7DE8\96C6\304A\3088\3073\524A\9664\304C\53EF\80FD\3067\3001\30EC\30DD\30FC\30C8\3092\53C2\7167\3067\304D\307E\3059\3002</li>'),
unistr('  <li><strong>\7BA1\7406\8005</strong>\306F\3001\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF\306E\6A5F\80FD\306B\52A0\3048\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\300C\7BA1\7406\300D\30BB\30AF\30B7\30E7\30F3\306B\30A2\30AF\30BB\30B9\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\69CB\6210\3092\5B9F\884C\3067\304D\307E\3059\3002</li>'),
'</ul>',
'</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280658105119869689)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30D5\30A9\30FC\30E0\3092\4F7F\7528\3057\3066\3001\30E6\30FC\30B6\30FC\3068\305D\306E\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3092\5165\529B\3057\3001\30A2\30AF\30BB\30B9\30FB\30EC\30D9\30EB\3092\8A2D\5B9A\3057\307E\3059\3002'),
unistr('<em>\300C\30A2\30AF\30BB\30B9\5236\5FA1\306E\69CB\6210\300D</em>\3067\5B9A\7FA9\3057\305F\8A2D\5B9A\306B\3088\3063\3066\3001\30E6\30FC\30B6\30FC\540D\3092\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\306B\3059\308B\5FC5\8981\304C\3042\308B\304B\3001\4EFB\610F\306E\82F1\6570\5B57\5165\529B\3092\53EF\80FD\306B\3059\308B\304B\304C\6C7A\5B9A\3055\308C\307E\3059\3002</p>'),
unistr('<p>\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\306F\3001\30EA\30FC\30C0\30FC\3001\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF\304A\3088\3073\7BA1\7406\8005\3068\3044\30463\3064\306E\30A2\30AF\30BB\30B9\30FB\30EC\30D9\30EB\304C\30B5\30DD\30FC\30C8\3055\308C\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30EA\30FC\30C0\30FC</strong>\306F\3001\3059\3079\3066\306E\60C5\5831\306B\5BFE\3059\308B\8AAD\53D6\308A\5C02\7528\30A2\30AF\30BB\30B9\6A29\3092\6301\3061\3001\30EC\30DD\30FC\30C8\3092\53C2\7167\3067\304D\307E\3059\3002</li>'),
unistr('  <li><strong>\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF</strong>\306F\3001\60C5\5831\306E\4F5C\6210\3001\7DE8\96C6\304A\3088\3073\524A\9664\304C\53EF\80FD\3067\3001\30EC\30DD\30FC\30C8\3092\53C2\7167\3067\304D\307E\3059\3002</li>'),
unistr('  <li><strong>\7BA1\7406\8005</strong>\306F\3001\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF\306E\6A5F\80FD\306B\52A0\3048\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\300C\7BA1\7406\300D\30BB\30AF\30B7\30E7\30F3\306B\30A2\30AF\30BB\30B9\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\69CB\6210\3092\5B9F\884C\3067\304D\307E\3059\3002</li>'),
'</ul>',
unistr('<p>\65E2\5B58\306E\30E6\30FC\30B6\30FC\3092\7DE8\96C6\3059\308B\5834\5408\3001\305D\306E\30A2\30AB\30A6\30F3\30C8\304C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\30A2\30AF\30BB\30B9\3057\306A\3044\3088\3046\306B\30ED\30C3\30AF\3067\304D\307E\3059\3002</p>'),
unistr('<p><em><strong>\6CE8\610F:</strong> Oracle Application Express\30A2\30AB\30A6\30F3\30C8\3092\4F7F\7528\3059\308B\5834\5408\3001\3053\3053\3067\5165\529B\3059\308B\30E6\30FC\30B6\30FC\306F\3001\305D\306E\30D1\30B9\30EF\30FC\30C9\3082\8A2D\5B9A\3067\304D\308B\30EF\30FC\30AF\30B9\30DA\30FC\30B9\7BA1\7406\8005\306B\3088\3063\3066\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\3068\3057\3066\5B9A\7FA9\3055\308C\3066\3044\308B\5FC5\8981\304C\3042\308A\307E\3059\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280658089763869689)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30DA\30FC\30B8\306B\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30E6\30FC\30B6\30FC\3068\4ED8\4E0E\3055\308C\3066\3044\308B\30A2\30AF\30BB\30B9\30FB\30EC\30D9\30EB\306E\30EC\30DD\30FC\30C8\304C\8868\793A\3055\308C\307E\3059\3002</p>'),
unistr('<p>\5217\30D8\30C3\30C0\30FC\3092\30AF\30EA\30C3\30AF\3057\3066\30C7\30FC\30BF\3092\30BD\30FC\30C8\304A\3088\3073\30D5\30A3\30EB\30BF\3059\308B\304B\3001<strong>\300C\30A2\30AF\30B7\30E7\30F3\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\5217\8868\793A\3068\591A\304F\306E\8FFD\52A0\306E\62E1\5F35\6A5F\80FD\3092\30AB\30B9\30BF\30DE\30A4\30BA\3057\307E\3059\3002<br>'),
unistr('<strong>\300C\30EA\30BB\30C3\30C8\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\623B\3059\3053\3068\304C\3067\304D\307E\3059\3002</p>'),
unistr('<p>\7DE8\96C6\30A2\30A4\30B3\30F3(\9EC4\8272\306E\925B\7B46)\3092\30AF\30EA\30C3\30AF\3057\3066\30E6\30FC\30B6\30FC\306E\8A73\7D30\3068\30A2\30AF\30BB\30B9\30FB\30EC\30D9\30EB\3092\7DE8\96C6\3059\308B\304B\3001\30E6\30FC\30B6\30FC\3092\524A\9664\3057\307E\3059\3002</p>'),
unistr('<p>\30EC\30DD\30FC\30C8\306E\4E00\756A\4E0A\306B\3042\308B<strong>\300C\30E6\30FC\30B6\30FC\306E\8FFD\52A0\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3066\3001\65B0\3057\3044\30E6\30FC\30B6\30FC\3068\305D\306E\30A2\30AF\30BB\30B9\30FB\30EC\30D9\30EB\3092\8FFD\52A0\3057\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280671596830869697)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30AF\30BB\30B9\5236\5FA1\304C\6709\52B9\306A\5834\5408\3001\7BA1\7406\8005\306F\3001\7279\5B9A\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\6A5F\80FD\3078\306E\30A2\30AF\30BB\30B9\3092\8A8D\8A3C\3055\308C\305F\30E6\30FC\30B6\30FC\306B\5236\9650\3067\304D\307E\3059\3002\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\306F\3001\30EA\30FC\30C0\30FC\3001\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF\304A\3088\3073\7BA1\7406\8005\3068\3044\30463\3064\306E\30ED\30FC\30EB\304C\30B5\30DD\30FC\30C8\3055\308C\307E\3059\3002<p>'),
'<ul>',
unistr('  <li><strong>\30EA\30FC\30C0\30FC</strong>\306F\3001\3059\3079\3066\306E\60C5\5831\306B\5BFE\3059\308B\8AAD\53D6\308A\5C02\7528\30A2\30AF\30BB\30B9\6A29\3092\6301\3061\3001\30EC\30DD\30FC\30C8\3092\53C2\7167\3067\304D\307E\3059\3002</li>'),
unistr('  <li><strong>\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF</strong>\306F\3001\60C5\5831\306E\4F5C\6210\3001\7DE8\96C6\304A\3088\3073\524A\9664\304C\53EF\80FD\3067\3001\30EC\30DD\30FC\30C8\3092\53C2\7167\3067\304D\307E\3059\3002</li>'),
unistr('  <li><strong>\7BA1\7406\8005</strong>\306F\3001\30B3\30F3\30C8\30EA\30D3\30E5\30FC\30BF\306E\6A5F\80FD\306B\52A0\3048\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\69CB\6210\3092\5B9F\884C\3067\304D\307E\3059\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280693528537869711)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30F3\30DE\3001\30BB\30DF\30B3\30ED\30F3\307E\305F\306F\7A7A\767D\3067\533A\5207\3063\305F\30E6\30FC\30B6\30FC\540D\3092\5165\529B\3057\307E\3059\3002\65E2\5B58\307E\305F\306F\91CD\8907\3059\308B\30E6\30FC\30B6\30FC\540D\306F\81EA\52D5\7684\306B\7121\8996\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280656975735869688)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\69CB\6210\8A2D\5B9A\306B\3088\3063\3066\3001\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\5BFE\3057\3066\7279\5B9A\306E\6A5F\80FD\3092\4F7F\7528\53EF\80FD(\6709\52B9)\306B\3059\308B\304B\3001\4F7F\7528\4E0D\53EF(\7121\52B9)\306B\3059\308B\3053\3068\304C\3067\304D\307E\3059\3002</p>'),
unistr('<p>\7279\5B9A\306E\6A5F\80FD\3092100%\6E96\5099\3067\304D\3066\3044\306A\3044\5834\5408\3001\307E\305F\306F\4E00\6642\7684\306B\524A\9664\3059\308B\5FC5\8981\304C\3042\308B\5834\5408\3001<strong>\300C\7121\52B9\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002'),
unistr('\4F7F\7528\53EF\80FD\306B\306A\3063\305F\3089\3001<strong>\300C\6709\52B9\300D</strong>\3092\30AF\30EA\30C3\30AF\3059\308B\3060\3051\3067\3059\3002</p>'),
unistr('<p><em><strong>\6CE8\610F:</strong> \3053\3053\3067\884C\3063\305F\5909\66F4\306F\3001\73FE\5728\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\5B9F\884C\4E2D\306E\500B\5225\306E\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\306F\53CD\6620\3055\308C\307E\305B\3093\3002\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\30B5\30A4\30F3\30A2\30A6\30C8\3057\3066\304B\3089\518D\5EA6\30B5\30A4\30F3\30A4\30F3\3059\308B\3068\3001\5909\66F4\3055\308C\305F\6A5F\80FD\8A2D\5B9A\304C\9069\7528\3055\308C\307E\3059\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280657055089869688)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8868\793A\306B\4F7F\7528\3059\308B\30C7\30D5\30A9\30EB\30C8\306E\30AB\30E9\30FC\30FB\30B9\30AD\30FC\30E0\3092\9078\629E\3057\307E\3059\3002</p>'),
unistr('<p><strong>\300C\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\9078\629E\3092\8A31\53EF\300D</strong>\304C\9078\629E\3055\308C\3066\3044\308B\5834\5408\3001\5404\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306F\3001\30DB\30FC\30E0\30DA\30FC\30B8\306E\5DE6\4E0B\9685\306B\3042\308B<em>\300C\30AB\30B9\30BF\30DE\30A4\30BA\300D</em>\30EA\30F3\30AF\3092\30AF\30EA\30C3\30AF\3057\3066\3001\4F7F\7528\53EF\80FD\306A\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\304B\3089\9078\629E\3067\304D\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280657671201869689)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30DA\30FC\30B8\3067\306F\3001\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3088\3063\3066\8A18\9332\3055\308C\305F\3059\3079\3066\306E\4E88\671F\3057\306A\3044\30A8\30E9\30FC\306E\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\304C\63D0\4F9B\3055\308C\307E\3059\3002</p>'),
unistr('<p>\5217\30D8\30C3\30C0\30FC\3092\30AF\30EA\30C3\30AF\3057\3066\30C7\30FC\30BF\3092\30BD\30FC\30C8\304A\3088\3073\30D5\30A3\30EB\30BF\3059\308B\304B\3001<strong>\300C\30A2\30AF\30B7\30E7\30F3\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\5217\8868\793A\3068\591A\304F\306E\8FFD\52A0\306E\62E1\5F35\6A5F\80FD\3092\30AB\30B9\30BF\30DE\30A4\30BA\3057\307E\3059\3002<strong>\300C\30EA\30BB\30C3\30C8\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\623B\3059\3053\3068\304C\3067\304D\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280657540386869689)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30EC\30DD\30FC\30C8\3068\30C1\30E3\30FC\30C8\3092\4F7F\7528\3057\3066\3001\6307\5B9A\3057\305F\6642\9593\67A0\3067\6700\5927\306E\30DA\30FC\30B8\30FB\30D3\30E5\30FC\3092\8A18\9332\3057\305F\30E6\30FC\30B6\30FC\3092\53C2\7167\3057\307E\3059\3002</p>'),
unistr('<p>\30EC\30DD\30FC\30C8\6642\9593\67A0(\30C7\30D5\30A9\30EB\30C8 = 1\65E5)\3092\9078\629E\3057\3001\30DA\30FC\30B8\306E\4E00\756A\4E0A\306B\3042\308B\30EC\30DD\30FC\30C8\30FB\30A2\30A4\30B3\30F3\3068\30C1\30E3\30FC\30C8\30FB\30A2\30A4\30B3\30F3\304B\3089\9078\629E\3057\307E\3059\3002</p>'),
unistr('<p>\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3067\306F\3001\691C\7D22\30D5\30A3\30FC\30EB\30C9\3092\4F7F\7528\3059\308B\304B\3001<strong>\300C\30E6\30FC\30B6\30FC\300D</strong>\5217\30D8\30C3\30C0\30FC\3092\9078\629E\3057\3066\7279\5B9A\306E\30E6\30FC\30B6\30FC\3092\9078\629E\3057\307E\3059\3002<strong>\300C\30A2\30AF\30B7\30E7\30F3\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5217\306E\8868\793A/\975E\8868\793A\3001\30DA\30FC\30B8\3054\3068\306E\884C\6570\3001\30D5\30A3\30EB\30BF\306A\3069\306E\591A\304F\306E\6A5F\80FD\3092\5B9F\884C\3067\304D\307E\3059\3002<strong>\300C\30EA\30BB\30C3\30C8\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\623B\3059\3053\3068\304C\3067\304D\307E\3059\3002</p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280657789830869689)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30DA\30FC\30B8\3067\306F\3001\30DA\30FC\30B8\30FB\30D1\30D5\30A9\30FC\30DE\30F3\30B9\3068\4EBA\6C17\5EA6\306E\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\304C\63D0\4F9B\3055\308C\307E\3059\3002\30EC\30DD\30FC\30C8\306F\3001\4E2D\9593\7D4C\904E\6642\9593\3068\30DA\30FC\30B8\30FB\30D3\30E5\30FC\306E\6570\3092\639B\3051\308B\3053\3068\3067\8A08\7B97\3055\308C\308B<strong>\300C\91CD\307F\4ED8\3051\30D1\30D5\30A9\30FC\30DE\30F3\30B9\300D</strong>\3067\9806\5E8F\4ED8\3051\3055\308C\307E\3059\3002</p>'),
unistr('<p>\5FC5\8981\306B\5FDC\3058\3066\3001\30DA\30FC\30B8\306E\4E00\756A\4E0A\306B\3042\308B\30EC\30DD\30FC\30C8\6642\9593\67A0(\30C7\30D5\30A9\30EB\30C8 = 1\65E5)\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('\5217\30D8\30C3\30C0\30FC\3092\30AF\30EA\30C3\30AF\3057\3066\30C7\30FC\30BF\3092\30BD\30FC\30C8\304A\3088\3073\30D5\30A3\30EB\30BF\3059\308B\304B\3001<strong>\300C\30A2\30AF\30B7\30E7\30F3\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\5217\8868\793A\3068\591A\304F\306E\8FFD\52A0\306E\62E1\5F35\6A5F\80FD\3092\30AB\30B9\30BF\30DE\30A4\30BA\3057\307E\3059\3002<strong>\300C\30EA\30BB\30C3\30C8\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\623B\3059\3053\3068\304C\3067\304D\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280657852040869689)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30DA\30FC\30B8\3067\306F\3001\6700\65B0\306E\30DA\30FC\30B8\30FB\30D3\30E5\30FC\306E\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\304C\63D0\4F9B\3055\308C\307E\3059\3002</p>'),
unistr('<p>\5FC5\8981\306B\5FDC\3058\3066\3001\30DA\30FC\30B8\306E\4E00\756A\4E0A\306B\3042\308B\30EC\30DD\30FC\30C8\6642\9593\67A0(\30C7\30D5\30A9\30EB\30C8 = 1\65E5)\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('\5217\30D8\30C3\30C0\30FC\3092\30AF\30EA\30C3\30AF\3057\3066\30C7\30FC\30BF\3092\30BD\30FC\30C8\304A\3088\3073\30D5\30A3\30EB\30BF\3059\308B\304B\3001<strong>\300C\30A2\30AF\30B7\30E7\30F3\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\5217\8868\793A\3068\591A\304F\306E\8FFD\52A0\306E\62E1\5F35\6A5F\80FD\3092\30AB\30B9\30BF\30DE\30A4\30BA\3057\307E\3059\3002<strong>\300C\30EA\30BB\30C3\30C8\300D</strong>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\30C7\30D5\30A9\30EB\30C8\8A2D\5B9A\306B\623B\3059\3053\3068\304C\3067\304D\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280656850714869688)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\901A\77E5\306F\3001\30A2\30AF\30C6\30A3\30D6\306A\5834\5408\306B\30DB\30FC\30E0\30DA\30FC\30B8\306B\8868\793A\3055\308C\307E\3059\3002</p>'),
unistr('<p>\3053\306E\30EC\30DD\30FC\30C8\306B\306F\3001\5B9A\7FA9\3055\308C\3066\3044\308B\901A\77E5\3068\3001\305D\306E\901A\77E5\306E\8868\793A\671F\9593\304C\793A\3055\308C\307E\3059\3002</p>'),
unistr('<p>\7DE8\96C6\30A2\30A4\30B3\30F3(\9EC4\8272\306E\925B\7B46)\3092\30AF\30EA\30C3\30AF\3057\3066\65E2\5B58\306E\901A\77E5\3092\7DE8\96C6\3059\308B\304B\3001<strong>\300C\901A\77E5\306E\8FFD\52A0\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3066\65B0\3057\3044\901A\77E5\3092\633F\5165\3057\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280657120876869688)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\3068\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\7C21\5358\306A\8AAC\660E\3092\5165\529B\3057\307E\3059\3002</p>'),
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\306F\30DB\30FC\30E0\30DA\30FC\30B8\306B\8868\793A\3055\308C\307E\3059\3002\7C21\5358\306A\8AAC\660E\306F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\306E\4E0B\306B\8868\793A\3055\308C\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280657378807869689)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\306E\901A\5E38\306E\30DA\30FC\30B8\304B\3089\30D5\30A3\30FC\30C9\30D0\30C3\30AF\3092\5165\529B\3067\304D\307E\3059\3002</p>'),
unistr('<p>\3053\306E\30EC\30DD\30FC\30C8\306B\306F\3001\5165\529B\3055\308C\305F\30D5\30A3\30FC\30C9\30D0\30C3\30AF\3001\7BA1\7406\8005\306B\3088\308A\5165\529B\3055\308C\305F\30EC\30B9\30DD\30F3\30B9\3001\304A\3088\3073\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306E\30B9\30C6\30FC\30BF\30B9\304C\8868\793A\3055\308C\307E\3059\3002</p>'),
unistr('<p>\7DE8\96C6\30A2\30A4\30B3\30F3(\9EC4\8272\306E\925B\7B46)\3092\30AF\30EA\30C3\30AF\3057\3066\30EC\30B9\30DD\30F3\30B9\3092\5165\529B\3059\308B\304B\3001\30D5\30A3\30FC\30C9\30D0\30C3\30AF\30FB\30B9\30C6\30FC\30BF\30B9\3092\66F4\65B0\3057\307E\3059\3002</p>'),
unistr('<p><em><strong>\6CE8\610F:</strong> \30D5\30A3\30FC\30C9\30D0\30C3\30AF\306E\53D7\4FE1\8005\304C\5B9A\7FA9\3055\308C\3066\3044\308B\5834\5408\3001\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306F\3001\30D5\30A3\30FC\30C9\30D0\30C3\30AF\53D7\4FE1\8005\30EA\30B9\30C8\306E\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\306B\3082\9001\4FE1\3055\308C\307E\3059\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280673493855869699)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\306E\30AB\30F3\30DE\533A\5207\308A\306E\30EA\30B9\30C8\3092\6307\5B9A\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280657410346869689)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('<p><strong>\6DFB\4ED8\6709\52B9\5316</strong> - \300C\306F\3044\300D\306B\3057\305F\5834\5408\3001\30E6\30FC\30B6\30FC\306F\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306B\4F7F\7528\3059\308B\6DFB\4ED8\30D5\30A1\30A4\30EB\3092\30A2\30C3\30D7\30ED\30FC\30C9\3067\304D\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280658400912869689)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30DA\30FC\30B8\306B\306F\3001\5B9A\7FA9\3055\308C\3066\3044\308B\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3068\3001\9001\4FE1\3055\308C\305F\96FB\5B50\30E1\30FC\30EB\3067\30C6\30F3\30D7\30EC\30FC\30C8\304C\53C2\7167\3055\308C\305F\56DE\6570\304C\30EA\30B9\30C8\3055\308C\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280658250798869689)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30DA\30FC\30B8\306B\306F\3001\9001\4FE1\3055\308C\305F\96FB\5B50\30E1\30FC\30EB\304C\30EA\30B9\30C8\3055\308C\307E\3059\3002</p>'),
unistr('<p>\62E1\5927\93E1\30A2\30A4\30B3\30F3\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\9001\4FE1\3055\308C\305F\96FB\5B50\30E1\30FC\30EB\306E\8A73\7D30\3092\8868\793A\3067\304D\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280658342986869689)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3092\5B9A\7FA9\3059\308B\6B21\306E\30D5\30A3\30FC\30EB\30C9\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30C6\30F3\30D7\30EC\30FC\30C8\540D</strong>(\5FC5\9808) - \30C6\30F3\30D7\30EC\30FC\30C8\306E\308F\304B\308A\3084\3059\3044\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>HTML\30C6\30F3\30D7\30EC\30FC\30C8</strong>(\5FC5\9808) - HTML\30D9\30FC\30B9\306E\96FB\5B50\30E1\30FC\30EB\306E\914D\4FE1\3092\8A31\53EF\3059\308B\53D7\4FE1\8005\306B\9001\4FE1\3059\308B\96FB\5B50\30E1\30FC\30EB\3092\4F5C\6210\3059\308B\305F\3081\306EHTML\30B3\30FC\30C9\3092\5165\529B\3057\307E\3059\3002'),
unistr('    \7F6E\63DB\5024\306F\6B21\306E\3068\304A\308A\3067\3059\3002'),
'    <ul>',
unistr('        <li><strong>#APP_NAME#</strong> - \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\540D\524D\3067\7F6E\63DB\3055\308C\307E\3059\3002</li>'),
unistr('        <li><strong>#BODY1#</strong> - p_body1_text\3068\3057\3066\6E21\3055\308C\305F\5024\3067\7F6E\63DB\3055\308C\307E\3059</li> '),
unistr('        <li><strong>#TABLE#</strong> - \8868\306E\958B\59CBHTML\3001\8868\306E\884CHTML\304A\3088\3073\8868\306E\7D42\4E86HTML\3092\4F7F\7528\3057\3066p_table_content\3068\3057\3066\6E21\3055\308C\305F\5024\3067\7F6E\63DB\3055\308C\307E\3059\3002</li> '),
unistr('        <li><strong>#BODY2#</strong> - p_body2_text\3068\3057\3066\6E21\3055\308C\305F\5024\3067\7F6E\63DB\3055\308C\307E\3059</li> '),
unistr('        <li><strong>#ACTION#</strong> - \300C\30A2\30AF\30B7\30E7\30F3\30FB\30EA\30F3\30AF\300D\30C6\30F3\30D7\30EC\30FC\30C8\3092\4F7F\7528\3057\3066p_action_label\304A\3088\3073p_action_link\3068\3057\3066\6E21\3055\308C\305F\5024\3067\7F6E\63DB\3055\308C\307E\3059\3002</li>'),
'     </ul></li>',
unistr('  <li><strong>\30D7\30EC\30FC\30F3\30FB\30C6\30AD\30B9\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8</strong>(\5FC5\9808) - HTML\30D9\30FC\30B9\306E\96FB\5B50\30E1\30FC\30EB\3092\53D7\3051\53D6\3089\306A\3044\53D7\4FE1\8005\306B\9001\4FE1\3059\308B\96FB\5B50\30E1\30FC\30EB\3092\4F5C\6210\3059\308B\305F\3081\306E\30D7\30EC\30FC\30F3\30FB\30C6\30AD\30B9\30C8\3092\5165\529B\3057\307E\3059\3002\3053\308C\306F\3001#TABLE#\304A\3088\3073#ACTION#\304C\30D7\30EC\30FC\30F3\30FB\30C6\30AD\30B9\30C8\3068\3057\3066\30EC\30F3\30C0\30EA\30F3\30B0\3055\308C\308B\3053\3068\3092\9664\3044\3066\3001HTML\30C6\30F3\30D7\30EC\30FC\30C8\3068\540C\3058\7F6E\63DB\3092\4F7F\7528\3057\307E\3059\3002</li>'),
'<ul>',
unistr('<p>\8FFD\52A0\306EHTML\30C6\30F3\30D7\30EC\30FC\30C8\306F\4ED6\306E\62E1\5F35\96FB\5B50\30E1\30FC\30EB\306B\5BFE\5FDC\3057\307E\3059\3002\3053\308C\3089\306E\30A2\30A4\30C6\30E0\306F\6B21\306E\3068\304A\308A\3067\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\884C\306E\524D</strong> - HTML\30C6\30F3\30D7\30EC\30FC\30C8\306E#TABLE#\3092\7F6E\63DB\3059\308BHTML\3092\5165\529B\3057\307E\3059\3002p_table_content\304C\6E21\3055\308C\308B\5834\5408\306B\306E\307F\4F7F\7528\3055\308C\307E\3059\3002</li>'),
unistr('  <li><strong>\884C\30C6\30F3\30D7\30EC\30FC\30C8</strong> - \8868\306E\5404\884C\3092\30EC\30F3\30C0\30EA\30F3\30B0\3059\308BHTML\3092\5165\529B\3057\307E\3059\3002\3053\308C\306B\306F\3001#LABEL#\304A\3088\3073#VALUE#\7F6E\63DB\3092\4F7F\7528\3057\305F\884C\306E\958B\59CB/\7D42\4E86\3068\30C7\30FC\30BF\306E\958B\59CB/\7D42\4E86\304C\542B\307E\308C\307E\3059\3002p_table_content\304C\6E21\3055\308C\308B\5834\5408\306B\306E\307F\4F7F\7528\3055\308C\307E\3059\3002</li>'),
unistr('  <li><strong>\884C\306E\5F8C</strong> - \8868\307E\305F\306Fdiv\3092\7D42\4E86\3059\308BHTML\3092\5165\529B\3057\307E\3059\3002p_table_content\304C\6E21\3055\308C\308B\5834\5408\306B\306E\307F\4F7F\7528\3055\308C\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30AF\30B7\30E7\30F3\30FB\30EA\30F3\30AFHTML</strong> - HTML\30C6\30F3\30D7\30EC\30FC\30C8\306E#ACTION#\3092\7F6E\63DB\3059\308BHTML\3092\5165\529B\3057\307E\3059\3002#ACTION_LINK#\304A\3088\3073#ACTION_TEXT#\304C\542B\307E\308C\3066\3044\308B\5FC5\8981\304C\3042\308A\307E\3059\3002p_action_label\3068p_action_link\304C\6E21\3055\308C\308B\5834\5408\306B\306E\307F\4F7F\7528\3055\308C\307E\3059\3002</li>'),
'</ul>',
unistr('<p><em><strong>\6CE8\610F:</strong> \72EC\81EA\306E\30C6\30F3\30D7\30EC\30FC\30C8\3092\958B\767A\3059\308B\5834\5408\3001<strong>\30C7\30D5\30A9\30EB\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8</strong>\5185\306E\30A8\30F3\30C8\30EA\3092\4F8B\3068\3057\3066\4F7F\7528\3057\3066\304F\3060\3055\3044\3002\30C7\30D5\30A9\30EB\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3067\306F\3001\72EC\81EA\306E\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\5185\306B\542B\3081\308B\3053\3068\304C\3067\304D\308B\3001\307E\305F\306F\3067\304D\306A\3044\3059\3079\3066\306E\7F6E\63DB\5909\6570\3092\4F7F\7528\3057\3066\3044\307E\3059\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280658579426869689)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p><strong>\300C\96FB\5B50\30E1\30FC\30EB\306E\30C7\30A3\30B9\30D1\30C3\30C1\300D</strong>\30AA\30D7\30B7\30E7\30F3\306E\3044\305A\308C\304B\3092\9078\629E\3057\3066\3001\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1\3092\6709\52B9\5316\307E\305F\306F\7121\52B9\5316\3057\307E\3059\3002</p>'),
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\554F\984C\306E\30D7\30E9\30A4\30DE\30EA\9023\7D61\5148\306E\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3092\4F7F\7528\3057\3066<strong>\300C\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1\5143\300D</strong>\3092\5165\529B\3057\307E\3059\3002\3053\306E\5024\306F\96FB\5B50\30E1\30FC\30EB\6A5F\80FD\3092\4F7F\7528\3059\308B\3068\304D\306B\4F7F\7528\307E\305F\306F\4E0A\66F8\304D\3067\304D\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280676790153869701)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\308C\306F\3001\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1\306B\4F7F\7528\3055\308C\308B\9001\4FE1\5143\30A2\30C9\30EC\30B9\3067\3059\3002\96FB\5B50\30E1\30FC\30EB\6A5F\80FD\3092\4F7F\7528\3057\3066\4E0A\66F8\304D\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280695182567869712)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B21\306E\9805\76EE\3092\79FB\5165\3057\3001\300C\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1\300D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002\9001\4FE1\3055\308C\305F\3059\3079\3066\306E\96FB\5B50\30E1\30FC\30EB\304C\96FB\5B50\30E1\30FC\30EB\30FB\30ED\30B0\306B\8A18\9332\3055\308C\307E\3059\3002'),
'    <ul>',
unistr('        <li><strong>\9001\4FE1\8005</strong> - \300C\96FB\5B50\30E1\30FC\30EB\8A2D\5B9A\300D\3067\300C\9001\4FE1\5143\30A2\30C9\30EC\30B9\300D\304C\8A2D\5B9A\3055\308C\3066\3044\308B\5834\5408\3001\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\306F\9001\4FE1\5143\30AA\30D7\30B7\30E7\30F3\306B\306A\308A\307E\3059\3002\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3092\30E6\30FC\30B6\30FC\540D\3068\3057\3066\4F7F\7528\3059\308B\5834\5408\306F\3001\96FB\5B50\30E1\30FC\30EB\3092\81EA\5206\306E\96FB\5B50\30E1\30FC\30EB\304B\3089\9001\4FE1\3059\308B\3053\3068\3092\9078\629E\3067\304D\307E\3059\3002\6700\5F8C\306B\3001\300C\9001\4FE1\5143\300D\3092\5E38\306B\300C\9001\4FE1\5148\300D\3068\540C\3058\306B\3059\308B\3053\3068\304C\3067\304D\307E\3059\3002</li>'),
unistr('        <li><strong>\9001\4FE1\5148</strong> - \3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304C\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3092\30E6\30FC\30B6\30FC\540D\3068\3057\3066\4F7F\7528\3059\308B\5834\5408\306F\3001\96FB\5B50\30E1\30FC\30EB\3092\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\307E\305F\306F\30E6\30FC\30B6\30FC\3001\3042\308B\3044\306F\305D\306E\4E21\65B9\306B\9001\4FE1\3059\308B\3053\3068\3092\9078\629E\3067\304D\307E\3059\3002</li>'),
unistr('        <li><strong>\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9</strong> - \96FB\5B50\30E1\30FC\30EB\3092\53D7\4FE1\3059\308B\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\306E\30AB\30F3\30DE\533A\5207\308A\30EA\30B9\30C8\3002\7121\52B9\306A\3082\306E\304C\691C\51FA\3055\308C\305F\5834\5408\3001\305D\308C\306F\542B\3081\3089\308C\307E\305B\3093\3002</li>'),
unistr('        <li><strong>\30ED\30FC\30EB</strong> - \9078\629E\3057\305F\30ED\30FC\30EB\306E\3059\3079\3066\306E\30E6\30FC\30B6\30FC\307E\305F\306F\3059\3079\3066\306E\5B9A\7FA9\3055\308C\305F\30E6\30FC\30B6\30FC\306B\96FB\5B50\30E1\30FC\30EB\3092\9001\4FE1\3057\307E\3059\3002\9078\629E\30EA\30B9\30C8\306B\306F\3001\30ED\30FC\30EB\306E\30EA\30B9\30C8\3068\305D\306E\30ED\30FC\30EB\5185\306E\30E6\30FC\30B6\30FC\6570\304C\542B\307E\308C\307E\3059\3002</li>'),
unistr('        <li><strong>\30C6\30F3\30D7\30EC\30FC\30C8</strong> - \96FB\5B50\30E1\30FC\30EB\306E\672C\6587\306E\4F5C\6210\306B\4F7F\7528\3059\308B\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('        <li><strong>\4EF6\540D</strong> - \96FB\5B50\30E1\30FC\30EB\306E\4EF6\540D\3002</li>'),
unistr('        <li><strong>\96FB\5B50\30E1\30FC\30EB\672C\6587</strong> - \96FB\5B50\30E1\30FC\30EB\306E\672C\6587\3068\3057\3066\542B\3081\308B\30C6\30AD\30B9\30C8\3002</li>'),
unistr('        <li><strong>\30AA\30D7\30C8\30FB\30A2\30A6\30C8\3092\8A31\53EF</strong> - \4E00\90E8\306E\96FB\5B50\30E1\30FC\30EB\306F\3001\30E6\30FC\30B6\30FC\304C\53D7\4FE1\96FB\5B50\30E1\30FC\30EB\3092\30AA\30D7\30C8\30FB\30A2\30A6\30C8\3057\3066\3044\308B\304B\3069\3046\304B\306B\95A2\4FC2\306A\304F\9001\4FE1\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002\3053\308C\3089\306B\306F\3001\30B7\30B9\30C6\30E0\505C\6B62\30E1\30C3\30BB\30FC\30B8\306A\3069\304C\542B\307E\308C\307E\3059\3002\3053\306E\30D5\30E9\30B0\306F\3001\3053\306E\96FB\5B50\30E1\30FC\30EB\306E\30AA\30D7\30C8\30FB\30A2\30A6\30C8\3092\8A31\53EF\3059\308B\304B\3069\3046\304B\3001\307E\305F\306F\30E6\30FC\30B6\30FC\306E\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306B\95A2\4FC2\306A\304F\9001\4FE1\3059\308B\304B\3069\3046\304B\3092\793A\3057\307E\3059\3002</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280696873726869713)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B21\306E\9805\76EE\3092\79FB\5165\3057\3001[\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1]\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002\9001\4FE1\3055\308C\305F\3059\3079\3066\306E\96FB\5B50\30E1\30FC\30EB\304C\96FB\5B50\30E1\30FC\30EB\30FB\30ED\30B0\306B\8A18\9332\3055\308C\307E\3059\3002'),
'    <ul>',
unistr('        <li><strong>\9001\4FE1\8005</strong> - \300C\96FB\5B50\30E1\30FC\30EB\8A2D\5B9A\300D\3067\300C\9001\4FE1\5143\30A2\30C9\30EC\30B9\300D\304C\8A2D\5B9A\3055\308C\3066\3044\308B\5834\5408\3001\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\306F\9001\4FE1\5143\30AA\30D7\30B7\30E7\30F3\306B\306A\308A\307E\3059\3002\307E\305F\306F\3001\300C\9001\4FE1\5143\300D\3092\5E38\306B\300C\9001\4FE1\5148\300D\3068\540C\3058\306B\3059\308B\3053\3068\304C\3067\304D\307E\3059\3002</li>'),
unistr('        <li><strong>\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9</strong> - \96FB\5B50\30E1\30FC\30EB\3092\53D7\4FE1\3059\308B\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\306E\30AB\30F3\30DE\533A\5207\308A\30EA\30B9\30C8\3002\7121\52B9\306A\3082\306E\304C\691C\51FA\3055\308C\305F\5834\5408\3001\305D\308C\306F\542B\3081\3089\308C\307E\305B\3093\3002</li>'),
unistr('        <li><strong>\30C6\30F3\30D7\30EC\30FC\30C8</strong> - \96FB\5B50\30E1\30FC\30EB\306E\672C\6587\306E\4F5C\6210\306B\4F7F\7528\3059\308B\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('        <li><strong>\4EF6\540D</strong> - \96FB\5B50\30E1\30FC\30EB\306E\4EF6\540D\3002</li>'),
unistr('        <li><strong>\96FB\5B50\30E1\30FC\30EB\672C\6587</strong> - \96FB\5B50\30E1\30FC\30EB\306E\672C\6587\3068\3057\3066\542B\3081\308B\30C6\30AD\30B9\30C8\3002</li>'),
unistr('        <li><strong>\30AA\30D7\30C8\30FB\30A2\30A6\30C8\3092\8A31\53EF</strong> - \4E00\90E8\306E\96FB\5B50\30E1\30FC\30EB\306F\3001\30E6\30FC\30B6\30FC\304C\53D7\4FE1\96FB\5B50\30E1\30FC\30EB\3092\30AA\30D7\30C8\30FB\30A2\30A6\30C8\3057\3066\3044\308B\304B\3069\3046\304B\306B\95A2\4FC2\306A\304F\9001\4FE1\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002\3053\308C\3089\306B\306F\3001\30B7\30B9\30C6\30E0\505C\6B62\30E1\30C3\30BB\30FC\30B8\306A\3069\304C\542B\307E\308C\307E\3059\3002\3053\306E\30D5\30E9\30B0\306F\3001\3053\306E\96FB\5B50\30E1\30FC\30EB\306E\30AA\30D7\30C8\30FB\30A2\30A6\30C8\3092\8A31\53EF\3059\308B\304B\3069\3046\304B\3001\307E\305F\306F\30E6\30FC\30B6\30FC\306E\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306B\95A2\4FC2\306A\304F\9001\4FE1\3059\308B\304B\3069\3046\304B\3092\793A\3057\307E\3059\3002</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280657249287869688)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\3059\3079\3066\306E\30E6\30FC\30B6\30FC\306B\5BFE\5FDC\3059\308B\30C7\30D5\30A9\30EB\30C8\30FB\30BF\30A4\30E0\30BE\30FC\30F3\3092\9078\629E\3057\307E\3059\3002</p>'),
unistr('<p>\500B\3005\306E\30E6\30FC\30B6\30FC\306F\3001\30E6\30FC\30B6\30FC\540D(\53F3\4E0A)\3092\30AF\30EA\30C3\30AF\3057\3066<strong>\300C\30D7\30EA\30D5\30A1\30EC\30F3\30B9\300D</strong>\3092\9078\629E\3057\3001\3053\306E\8A2D\5B9A\3092\30AA\30FC\30D0\30FC\30E9\30A4\30C9\3067\304D\307E\3059\3002\307E\305F\306F\3001\30DB\30FC\30E0\30DA\30FC\30B8\306E\4E00\756A\4E0B\306B\8868\793A\3055\308C\3066\3044\308B\30BF\30A4\30E0\30BE\30FC\30F3\30FB\30EA\30F3\30AF\3092\30AF\30EA\30C3\30AF\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280673158093869698)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'ja'
,p_message_text=>unistr('UI\3092\901A\3058\3066\3053\306E\30DA\30FC\30B8\306B\76F4\63A5\30A2\30AF\30BB\30B9\3059\308B\3053\3068\306F\3067\304D\307E\305B\3093\3002\3053\308C\306F\3001\30D7\30ED\30D5\30A1\30A4\30EB\5199\771F\3092\7C21\5358\306B\30C0\30A6\30F3\30ED\30FC\30C9\3059\308B\305F\3081\306B\4F7F\7528\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280672876547869698)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30D7\30ED\30D5\30A1\30A4\30EB\30FB\30DA\30FC\30B8\3067\306F\3001\4F7F\3044\3084\3059\30441\3064\306E\753B\9762\3067\30E6\30FC\30B6\30FC\306B\95A2\9023\3059\308B\60C5\5831\3092\53C2\7167\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280672581972869698)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B63\65B9\5F62\306E\7E26\6A2A\6BD4\3092\6301\3064\5199\771F\3092\30A2\30C3\30D7\30ED\30FC\30C9\3057\306A\3044\3068\3001\6B6A\307F\304C\751F\3058\308B\53EF\80FD\6027\304C\3042\308A\307E\3059\3002\63A8\5968\3055\308C\308B\30A4\30E1\30FC\30B8\30FB\30B5\30A4\30BA\306F\3001250x250\30D4\30AF\30BB\30EB\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280658623786869689)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3053\306E\30D5\30A9\30FC\30E0\3067\306F\3001\500B\4EBA\60C5\5831\306E\8A73\7D30\3092\66F4\65B0\3057\3066\5199\771F\3084\30A2\30D0\30BF\30FC\3092\30A2\30C3\30D7\30ED\30FC\30C9\3067\304D\307E\3059\3002</p>'),
unistr('<p>\30A4\30E1\30FC\30B8\3092\30A2\30C3\30D7\30ED\30FC\30C9\3059\308B\306B\306F\3001<strong>\300C\53C2\7167\300D</strong>\3092\30AF\30EA\30C3\30AF\3059\308B\304B\3001\30A4\30E1\30FC\30B8\3092\30DC\30BF\30F3\4E0A\306B\30C9\30E9\30C3\30B0\30FB\30A2\30F3\30C9\30FB\30C9\30ED\30C3\30D7\3057\307E\3059\3002<br>'),
unistr('\6B63\65B9\5F62\306E\7E26\6A2A\6BD4\3092\6301\3064\5199\771F\3092\30A2\30C3\30D7\30ED\30FC\30C9\3057\306A\3044\3068\3001\6B6A\307F\304C\751F\3058\308B\53EF\80FD\6027\304C\3042\308A\307E\3059\3002\63A8\5968\3055\308C\308B\30A4\30E1\30FC\30B8\30FB\30B5\30A4\30BA\306F\3001250x250\30D4\30AF\30BB\30EB\3067\3059\3002</p>'),
unistr('<p><strong>\300C\5199\771F\306E\524A\9664\300D</strong>\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\30A4\30E1\30FC\30B8\3092\524A\9664\3067\304D\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280678782981869702)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30DA\30FC\30B8\304B\3089\3059\3079\3066\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D8\30EB\30D7\30FB\30C6\30AD\30B9\30C8\306B\30A2\30AF\30BB\30B9\3067\304D\307E\3059\3002\300C\30C9\30AD\30E5\30E1\30F3\30C8\300D\30EA\30FC\30B8\30E7\30F3\306E\30EA\30F3\30AF\3092\4F7F\7528\3059\308B\3068\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\6A5F\80FD\3068\7279\5FB4\306E\3088\308A\8A73\7D30\306A\8AAC\660E\3092\53C2\7167\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280659753543869690)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30DA\30FC\30B8\3067\30A2\30AB\30A6\30F3\30C8\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D7\30EA\30D5\30A1\30EC\30F3\30B9\3092\8A2D\5B9A\3067\304D\307E\3059\3002\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8907\6570\306E\6A5F\80FD(\30BF\30A4\30E0\30BE\30FC\30F3\306A\3069)\306B\5F71\97FF\3059\308B\53EF\80FD\6027\304C\3042\308A\307E\3059\3002\30A2\30A4\30C6\30E0\30FB\30EC\30D9\30EB\306E\30D8\30EB\30D7\30FB\30A2\30A4\30B3\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\3001\5404\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\52D5\4F5C\3092\7406\89E3\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279651830092869067)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\3053\306E\30EC\30DD\30FC\30C8\306B\306F\3001\9001\4FE1\30AD\30E5\30FC\306B\5165\3063\3066\3044\308B\96FB\5B50\30E1\30FC\30EB\304A\3088\3073\3059\3067\306B\9001\4FE1\3055\308C\305F\96FB\5B50\30E1\30FC\30EB\306E\3059\3079\3066\304C\8868\793A\3055\308C\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279783727502869147)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\3053\306E\30EC\30DD\30FC\30C8\306B\306F\3001\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3088\3063\3066\30E2\30CB\30BF\30FC\3055\308C\308B\3088\3046\306B\9078\629E\3055\308C\305F\3059\3079\3066\306E\30B8\30E7\30D6\304C\542B\307E\308C\307E\3059\3002\5404\30B8\30E7\30D6\306E\8A73\7D30\306F\3001\30B8\30E7\30D6\540D\3092\30AF\30EA\30C3\30AF\3059\308B\3068\8868\793A\3067\304D\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279790323327869151)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\3053\306E\30EC\30DD\30FC\30C8\306B\306F\3001\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3088\3063\3066\30E2\30CB\30BF\30FC\3055\308C\308B\3088\3046\306B\9078\629E\3055\308C\305F\30B8\30E7\30D6\306E\5B9F\884C\306E\8A73\7D30\304C\542B\307E\308C\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280644037675869680)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\3064\3044\3066\300D\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280660492101869690)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\96FB\5B50\30E1\30FC\30EB\3092\53D7\4FE1\3057\306A\3044\5834\5408\3001\3053\306E\30AA\30D7\30B7\30E7\30F3\3092\300C\3044\3044\3048\300D\306B\8A2D\5B9A\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280694669909869712)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\691C\7D22\8A9E\3092\691C\7D22\30C0\30A4\30A2\30ED\30B0\306B\5165\529B\3057\3001<strong>\300C\691C\7D22\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002<br>'),
unistr('\3044\305A\308C\304B\306E\7D50\679C\898B\51FA\3057\3092\30AF\30EA\30C3\30AF\3059\308B\3068\3001\305D\306E\30EC\30B3\30FC\30C9\306B\79FB\52D5\3057\307E\3059\3002</p>'),
unistr('<p>\691C\7D22\3092\5236\9650\3059\308B\306B\306F\30011\3064\4EE5\4E0A\306E\30BD\30FC\30B9\306E\9078\629E\3092\89E3\9664\3059\308B\3068\3001\691C\7D22\7D50\679C\304B\3089\305D\306E\30EC\30DD\30FC\30C8\304C\524A\9664\3055\308C\307E\3059\3002</p>'),
unistr('<p>\73FE\5728\306E\691C\7D22\8A9E\3092\524A\9664\3057\3001\3059\3079\3066\306E\30BD\30FC\30B9\3092\9078\629E\3059\308B\306B\306F\3001<strong>\300C\30EA\30BB\30C3\30C8\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</p> ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280660268743869690)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5168\4F53\3067\4F7F\7528\3059\308B\512A\5148\30BF\30A4\30E0\30BE\30FC\30F3\3092\8A2D\5B9A\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279572379149869019)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_language=>'ja'
,p_message_text=>unistr('\975E\8868\793A\306E\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280680344688869703)
,p_name=>'CA.HOME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DB\30FC\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280686425483869707)
,p_name=>'CA.HOME.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DB\30FC\30E0\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280702851363869717)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('1\6642\9593\5F53\305F\308A\306E\30DA\30FC\30B8\30FB\30A4\30D9\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279650985731869067)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_language=>'ja'
,p_message_text=>unistr('HTML\30DC\30C7\30A3\30FB\30B5\30A4\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280677106199869701)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('HTML\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280673843467869699)
,p_name=>'CA.IN.PROGRESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\9032\884C\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280699025678869714)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\306B\542B\3081\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280698992546869714)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306B\542B\3081\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280682509170869704)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\306E\30B9\30AF\30EA\30D7\30C8\306E\30A4\30F3\30B9\30C8\30FC\30EB\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279784422823869148)
,p_name=>'CA.INSTANCE.ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30F3\30B9\30BF\30F3\30B9ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279785618291869148)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30F3\30B9\30BF\30F3\30B9\306E\632F\5206\3051')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280656251133869688)
,p_name=>'CA.INTRO.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\3088\308A\6A5F\80FD\8C4A\5BCC\306A\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F5C\6210\3059\308B\305F\3081\306B\6539\5584\3055\308C\305F\65B0\3057\3044\65B9\6CD5\3092\63D0\4F9B\3059\308B\3053\306E\30AF\30E9\30A6\30C9\5C02\7528\30D7\30EC\30D3\30E5\30FC\306B\3088\3046\3053\305D\3002\6A19\6E96\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210\30A6\30A3\30B6\30FC\30C9\3067\306F\751F\6210\3059\308B\30DA\30FC\30B8\3092\9078\629E\3067\304D\308B\306E\307F\3067\3059\304C\3001\3053\306E\30A6\30A3\30B6\30FC\30C9\3067\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\8907\6570\306E\8FFD\52A0\6A5F\80FD\3092\8FC5\901F\306B\4E8B\524D\30ED\30FC\30C9\3059\308B\3053\3068\304C\3067\304D\307E\3059\3002</p>'),
unistr('<p>\3053\306E\30A6\30A3\30B6\30FC\30C9\3092\4F7F\7528\3057\3066\751F\6210\3055\308C\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306F\3001\5B8C\5168\306B\30B5\30DD\30FC\30C8\3055\308C\308B\3068\3068\3082\306B\3001\30A2\30AF\30BB\30B9\5236\5FA1\3001\96FB\5B50\30E1\30FC\30EB\30FB\30D5\30EC\30FC\30E0\30EF\30FC\30AF\3001\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306A\3069\3001\9078\629E\3057\305F\6A5F\80FD\3092\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\3092\542B\3081\308B\3053\3068\3082\3067\304D\307E\3059\3002</p>'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280656422387869688)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6700\521D\306B\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\3092\5165\529B\3057\307E\3059\3002\6B21\306B\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B1\3064\4EE5\4E0A\306E\30DA\30FC\30B8\3092\8FFD\52A0\3057\307E\3059\3002\542B\3081\308B\6A5F\80FD\3092\9078\629E\3057\307E\3059\3002\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5916\89B3\306B\95A2\3059\308B\9078\629E\3092\884C\3044\3001\8A2D\5B9A\3092\30EC\30D3\30E5\30FC\3057\307E\3059\3002<br>'),
unistr('\3053\308C\3060\3051\3067\7D42\4E86\3067\3059\3002<strong>\300C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210\300D</strong>\3092\30AF\30EA\30C3\30AF\3059\308C\3070\81EA\52D5\3067\4F5C\696D\304C\9032\307F\307E\3059\3002</p>'),
unistr('<p><strong>\300C\30D6\30EB\30FC\30D7\30EA\30F3\30C8\306E\8868\793A\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3066\3001\524D\306B\751F\6210\3057\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30E2\30C7\30EB\3092\518D\5229\7528\3059\308B\304B\3001\30DA\30FC\30B8\3092\3059\3070\3084\304F\30EC\30D7\30EA\30B1\30FC\30C8\3057\307E\3059\3002</p>'),
unistr('<p><em><strong>\6CE8\610F:</strong> \5404\30BB\30AF\30B7\30E7\30F3\3068\5404\300C\30DA\30FC\30B8\306E\8FFD\52A0\300D\306B\3001\4F5C\696D\306B\5F79\7ACB\3064\8A73\7D30\306A\30D8\30EB\30D7\304C\542B\307E\308C\307E\3059\3002</em></p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280656332512869688)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A6\30A3\30B6\30FC\30C9\306E\4F7F\7528\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280691073264869709)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30EA\30EA\30FC\30B9\6642\306E\91CD\5927\306A\554F\984C\3092\6B21\306B\793A\3057\307E\3059\3002'),
'<ol>',
unistr('  <li>\30D6\30EB\30FC\30D7\30EA\30F3\30C8\304B\3089\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210\30A6\30A3\30B6\30FC\30C9\304C\7FFB\8A33\3055\308C\3066\3044\307E\305B\3093\3002</li>'),
unistr('  <li>\3053\306E\30A6\30A3\30B6\30FC\30C9\3067\751F\6210\3055\308C\305F\7FFB\8A33\6E08\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306F\4E00\90E8\306E\307F\7FFB\8A33\3055\308C\3066\3044\307E\3059\3002</li>'),
unistr('  <li>\300C\30EC\30DD\30FC\30C8\300D\30C9\30EA\30EB\30C0\30A6\30F3\3067\306F1\3064\306E\30C9\30EA\30EB\30C0\30A6\30F3\5217\306E\307F\4F7F\7528\3067\304D\307E\3059\3002</li>'),
unistr('  <li>\30D5\30A3\30EB\30BF\30FB\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\3092\751F\6210\3067\304D\307E\305B\3093\3002</li>'),
unistr('  <li>\96FB\5B50\30E1\30FC\30EB\6A5F\80FD\306F\4F4E\30EC\30D9\30EB\306EAPI\3092\63D0\4F9B\3057\307E\3059\304C\3001\9AD8\30EC\30D9\30EB\306E\96FB\5B50\30E1\30FC\30EB\6A5F\80FD\306F\307E\3060\542B\307E\308C\3066\3044\307E\305B\3093\3002</li>'),
unistr('  <li>\6B20\843D\3057\3066\3044\308B\8868\3092\53C2\7167\3059\308B\30D6\30EB\30FC\30D7\30EA\30F3\30C8\304B\3089\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\751F\6210\306F\5931\6557\3057\307E\3059\3002</li>'),
unistr('  <li>\8A73\7D30\8A2D\5B9A - \751F\6210\3055\308C\305F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\65E5\4ED8\5F62\5F0F\304C\9069\7528\3055\308C\307E\305B\3093\3002</li>'),
'</ol>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280690984233869709)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E2\77E5\306E\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280656612518869688)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>%0\3092\30EA\30EA\30FC\30B9\3057\307E\3057\305F\3002</p>'),
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280656586734869688)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30EA\30FC\30B9\8A73\7D30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280656159694869688)
,p_name=>'CA.INTRO.TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EB\30FC\30D7\30EA\30F3\30C8\30FB\30A6\30A3\30B6\30FC\30C9\304B\3089\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210{\30AF\30E9\30A6\30C9\306E\307F\306E\30D7\30EC\30D3\30E5\30FC}')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280667746087869695)
,p_name=>'CA.IP.ADDRESS'
,p_message_language=>'ja'
,p_message_text=>unistr('IP\30A2\30C9\30EC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280665982139869694)
,p_name=>'CA.IR.SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('IR\691C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280668941035869696)
,p_name=>'CA.IR.SEARCHES'
,p_message_language=>'ja'
,p_message_text=>unistr('IR\691C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280697448632869713)
,p_name=>'CA.ITEMNAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279788494693869150)
,p_name=>'CA.JOB.ACTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\30FB\30A2\30AF\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279789986482869151)
,p_name=>'CA.JOB.CLASS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\30FB\30AF\30E9\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279789002568869150)
,p_name=>'CA.JOB.CREATOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\4F5C\6210\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279790169491869151)
,p_name=>'CA.JOB.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279786677331869149)
,p_name=>'CA.JOB.PRIORITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\306E\512A\5148\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279783667810869147)
,p_name=>'CA.JOB.REPORTING'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\30FB\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279826216041869173)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\30B5\30DD\30FC\30C8\3059\308B\30B8\30E7\30D6\306E\30B9\30C6\30FC\30BF\30B9\304A\3088\3073\5B9F\884C\8A73\7D30\3092\8868\793A\3057\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279790243615869151)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\5B9F\884C\306E\8A73\7D30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279789150653869151)
,p_name=>'CA.JOB.STYLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\30FB\30B9\30BF\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279789263773869151)
,p_name=>'CA.JOB.SUBNAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\306E\30B5\30D6\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279788504918869150)
,p_name=>'CA.JOB.TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\30FB\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279785249235869148)
,p_name=>'CA.JOB.WEIGHT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B8\30E7\30D6\306E\91CD\307F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280697932142869714)
,p_name=>'CA.KEYCOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AD\30FC\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280699764481869715)
,p_name=>'CA.LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280698208685869714)
,p_name=>'CA.LABELCOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280699983723869715)
,p_name=>'CA.LABELPLURAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB\8907\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280699612882869715)
,p_name=>'CA.LABELSINGULAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\5358\4E00\30E9\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280655393274869687)
,p_name=>'CA.LANGUAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A00\8A9E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280655499082869687)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30D7\30E9\30A4\30DE\30EA\8A00\8A9E\3092\9078\629E\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280690434232869709)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30D7\30E9\30A4\30DE\30EA\8A00\8A9E\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC\3067\751F\6210\3055\308C\305F\30DA\30FC\30B8\304A\3088\3073\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\8868\793A\306B\4F7F\7528\3055\308C\308B\8A00\8A9E\3092\793A\3057\307E\3059\3002\8907\6570\306E\7FFB\8A33\3092\9078\629E\3059\308B\3068\3001\30E9\30F3\30BF\30A4\30E0\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30EC\30F3\30C0\30EA\30F3\30B0\306B\4F7F\7528\3055\308C\308B\8A00\8A9E\3092\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\9078\629E\3067\304D\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279934871161869241)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A00\8A9E\30BB\30EC\30AF\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280672323422869698)
,p_name=>'CA.LAST.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\59D3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279789371118869151)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\7D42\5B9F\884C\671F\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279789470323869151)
,p_name=>'CA.LAST.START.DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\7D42\958B\59CB\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280703255111869717)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\65B0\306E\30A2\30AF\30C6\30A3\30D3\30C6\30A3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280699130155869714)
,p_name=>'CA.LISTOFVALUES'
,p_message_language=>'ja'
,p_message_text=>'LOV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280694555046869712)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EB\30FC\30D7\30EA\30F3\30C8\306E\30ED\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279791794399869152)
,p_name=>'CA.LOG.DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30B0\65E5\4ED8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279791921061869152)
,p_name=>'CA.LOG.ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30B0ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279785932976869149)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30B0\30FB\30EC\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279573113207869019)
,p_name=>'CA.LOOKUP.COLUMNS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\30EB\30C3\30AF\30A2\30C3\30D7\5217</strong> - \5C55\958B\3057\3066\3001\5225\306E\8868\3078\306E\30EB\30C3\30AF\30A2\30C3\30D7\3092\5B9A\7FA9\3059\308B\305F\3081\306E\5C5E\6027\3092\8868\793A\3057\307E\3059\3002\30EB\30C3\30AF\30A2\30C3\30D7\5217\3092\4F7F\7528\3057\3066\3001\90E8\9580\756A\53F7\306E\304B\308F\308A\306B\90E8\9580\540D\3067\8868\793A\3059\308B\306A\3069\3001\8B58\5225\5B50\3092\8868\793A\5217\3067\7F6E\63DB\3057\307E\3059\3002<br>'),
unistr('<em><strong>\6CE8\610F:</strong> \300C\30EB\30C3\30AF\30A2\30C3\30D7\5217\300D\304C\8868\793A\3055\308C\308B\306E\306F\3001\73FE\5728\306E\30DA\30FC\30B8\304C\8868\307E\305F\306F\30D3\30E5\30FC\306B\57FA\3065\3044\3066\304A\308A\3001\73FE\5728\306E\30DA\30FC\30B8\306B\5225\306E\8868\3078\306E\5916\90E8\30AD\30FC\5236\7D04\304C\3042\308B\5834\5408\306E\307F\3067\3059\3002'),
'  <ul>',
unistr('    <li><strong>\30EB\30C3\30AF\30A2\30C3\30D7\30FB\30AD\30FC</strong> - \8868\793A\5217\3092\51FA\529B\3059\308B\305F\3081\306B\5909\66F4\3059\308B\5217\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('    <li><strong>\8868\793A\5217</strong> - \8868\793A\3059\308B\5217\3092(\30EB\30C3\30AF\30A2\30C3\30D7\8868\304B\3089)\9078\629E\3057\307E\3059\3002</li>'),
'    &nbsp;<br>',
unistr('    <em><strong>\6CE8\610F:</strong> \9078\629E\3067\304D\308B\5217\306F\3001(\5916\90E8\30AD\30FC\3092\4F7F\7528\3057\3066)\5225\306E\8868\3078\306E\53C2\7167\3092\6301\3064\5217\306E\307F\3067\3059\3002</em></li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280676318171869700)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30C6\30F3\30D7\30EC\30FC\30C8\306E\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280674338819869699)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306E\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280670477043869697)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A2\30AF\30BB\30B9\306E\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280703878247869717)
,p_name=>'CA.MASTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\30FB\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280703924868869717)
,p_name=>'CA.MASTER.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\30C7\30FC\30BF\3092\8868\793A\304A\3088\3073\30E1\30F3\30C6\30CA\30F3\30B9\3067\304D\308B\3088\3046\306B\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\30FB\30DA\30FC\30B8\3092\8868\793A\3059\308B\30DA\30FC\30B8\3092\4F5C\6210\3057\307E\3059\3002<br>'),
'&nbsp;</p>',
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30DA\30FC\30B8\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30DA\30FC\30B8\30FB\30BF\30A4\30D7</strong> - \30DA\30FC\30B8\306E\30BF\30A4\30D7[\5DE6\53F3\3001\7A4D\4E0A\3052]\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('    <strong>\5DE6\53F3</strong>:<br>'),
unistr('<em>\5DE6\53F3\30EC\30A4\30A2\30A6\30C8\304A\3088\3073\30E2\30FC\30C0\30EB\7DE8\96C6\30A6\30A3\30F3\30C9\30A6\306B\3088\308B\30EC\30DD\30FC\30C8\30FB\30EA\30FC\30B8\30E7\30F3\3092\4F7F\7528\3059\308B\5358\4E00\30DA\30FC\30B8\30FB\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\3002</em>'),
'    <ul>',
unistr('      <li><strong>\8868</strong>(\5FC5\9808) - \30DA\30FC\30B8\306E\30DE\30B9\30BF\30FC\8868\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('      <li><strong>\30D7\30E9\30A4\30DE\30EA\8868\793A\5217</strong>(\5FC5\9808) - \30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9\306E\30EA\30B9\30C8\306B\8868\793A\3059\308B\5217\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('      <li><strong>\30BB\30AB\30F3\30C0\30EA\8868\793A\5217</strong>(\5FC5\9808) - \30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9\306E\30EA\30B9\30C8\306E\30D7\30E9\30A4\30DE\30EA\8868\793A\5217\306E\4E0B\306B\8868\793A\3059\308B\8AAC\660E\5217\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('      <li><strong>\30C7\30A3\30C6\30FC\30EB\88681</strong>(\5FC5\9808) - \30DA\30FC\30B8\306E\6700\521D\306E\30C7\30A3\30C6\30FC\30EB\8868\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('      <li><strong>\30C7\30A3\30C6\30FC\30EB\88682</strong> - \30DA\30FC\30B8\306E2\756A\76EE\306E\30C7\30A3\30C6\30FC\30EB\8868\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('      <li><strong>\30C7\30A3\30C6\30FC\30EB\88683</strong> - \30DA\30FC\30B8\306E3\756A\76EE\306E\30C7\30A3\30C6\30FC\30EB\8868\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('      <li><strong>\30C7\30A3\30C6\30FC\30EB\88684</strong> - \30DA\30FC\30B8\306E4\756A\76EE\306E\30C7\30A3\30C6\30FC\30EB\8868\3092\9078\629E\3057\307E\3059\3002</li>'),
'    </ul>',
unistr('   <strong>\7A4D\4E0A\3052</strong>:<br>'),
unistr('<em>\7DE8\96C6\53EF\80FD\5BFE\8A71\30B0\30EA\30C3\30C9\3092\4F7F\7528\3059\308B\3001\5358\4E00\30DA\30FC\30B8\30FB\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\3002</em>'),
'    <ul>',
unistr('      <li><strong>\8868</strong>(\5FC5\9808) - \7DE8\96C6\53EF\80FD\5BFE\8A71\30B0\30EA\30C3\30C9\306E\30DE\30B9\30BF\30FC\8868\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('      <li><strong>\30C7\30A3\30C6\30FC\30EB\8868</strong>(\5FC5\9808) - \30DA\30FC\30B8\306E\30C7\30A3\30C6\30FC\30EB\8868\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('      <em><strong>\6CE8\610F:</strong> \30A6\30A3\30B6\30FC\30C9\3092\4F7F\7528\3057\3066\8FFD\52A0\3067\304D\308B\306E\306F\30011\3064\306E\307F\306E\30C7\30A3\30C6\30FC\30EB\8868(\7DE8\96C6\53EF\80FD\5BFE\8A71\30B0\30EA\30C3\30C9)\3067\3059\3002\8FFD\52A0\306E\30C7\30A3\30C6\30FC\30EB\8868\306F\3001\751F\6210\5F8C\306B\7C21\5358\306B\8FFD\52A0\3067\304D\307E\3059\3002</em>'),
'    </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279934733852869241)
,p_name=>'CA.MASTER_RECORDS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280666600335869694)
,p_name=>'CA.MAX.ELAPSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5927\7D4C\904E\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279786426528869149)
,p_name=>'CA.MAX.FAILURES'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5927\969C\5BB3\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279786069616869149)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5927\5B9F\884C\671F\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279786502009869149)
,p_name=>'CA.MAX.RUNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5927\5B9F\884C\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280698127090869714)
,p_name=>'CA.MAXIMUMROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5927\884C\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280701148625869716)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5927\5E45')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280691728135869710)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280692171294869710)
,p_name=>'CA.MD.ADD.ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280691694238869710)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\306E\9069\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280692521643869710)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5\4ED8\5024')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280692661684869710)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5\4ED8\5024 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280691804264869710)
,p_name=>'CA.MD.EDIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280691278947869710)
,p_name=>'CA.MD.FILTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280691103950869710)
,p_name=>'CA.MD.FILTERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280692265977869710)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30EB\30BF\306A\3057')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280691597376869710)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30B3\30FC\30C9\304C\9078\629E\3055\308C\3066\3044\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280691483847869710)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30B3\30FC\30C9\304C\898B\3064\304B\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280692024704869710)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\524A\9664\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280691919809869710)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\66F4\65B0\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280691361941869710)
,p_name=>'CA.MD.SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280692377464869710)
,p_name=>'CA.MD.VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280692412720869710)
,p_name=>'CA.MD.VALUE.2'
,p_message_language=>'ja'
,p_message_text=>unistr('\50242')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280666124079869694)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E2D\9593\7D4C\904E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280675294089869700)
,p_name=>'CA.MESSAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E1\30C3\30BB\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280700677506869715)
,p_name=>'CA.METRIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E1\30C8\30EA\30C3\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280667092548869695)
,p_name=>'CA.MIN.ELAPSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5C0F\7D4C\904E\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280669897223869696)
,p_name=>'CA.MOBILE.PHONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\643A\5E2F\96FB\8A71')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280665608820869694)
,p_name=>'CA.MODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E2\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280679401104869702)
,p_name=>'CA.MORE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280669041889869696)
,p_name=>'CA.MOST RECENT'
,p_message_language=>'ja'
,p_message_text=>'Most_Recent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280703073523869717)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\3082\30A2\30AF\30C6\30A3\30D6\306A\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279573240939869020)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8907\6570\306E\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279573320714869020)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>1\3064\4EE5\4E0A\306E\8868\540D\307E\305F\306F\30D3\30E5\30FC\540D\3092\9078\629E\3057\307E\3059\3002\307E\305F\306F\3001\30D8\30C3\30C0\30FC\306E\30C1\30A7\30C3\30AF\30FB\30DC\30C3\30AF\30B9\3092\30AF\30EA\30C3\30AF\3057\3066\3001\30EA\30B9\30C8\3055\308C\305F\3059\3079\3066\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\9078\629E\307E\305F\306F\9078\629E\89E3\9664\3057\307E\3059\3002</p>'),
unistr('<p>\9078\629E\3055\308C\305F\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3054\3068\306B\3001\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\542B\3080\30DA\30FC\30B8\304C\8FFD\52A0\3055\308C\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280663091270869692)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_language=>'ja'
,p_message_text=>unistr('#LABEL#\306F\6709\52B9\306A\30BF\30A4\30E0\30B9\30BF\30F3\30D7\3067\3042\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280700421937869715)
,p_name=>'CA.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\540D\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280654509351869687)
,p_name=>'CA.NAVIGATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CA\30D3\30B2\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280654647638869687)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30E1\30CB\30E5\30FC\3092\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\6A2A\5074\306B\8868\793A\3059\308B\304B\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4E0A\90E8\306B\8868\793A\3059\308B\304B\3092\9078\629E\3057\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280707114379869719)
,p_name=>'CA.NEGATIVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\60AA\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280707028421869719)
,p_name=>'CA.NEUTRAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3069\3061\3089\3068\3082\3044\3048\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280693114536869711)
,p_name=>'CA.NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279786231463869149)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\56DE\5B9F\884C\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279785173270869148)
,p_name=>'CA.NLS.ENV'
,p_message_language=>'ja'
,p_message_text=>unistr('NLS\74B0\5883')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279882903231869208)
,p_name=>'CA.NO'
,p_message_language=>'ja'
,p_message_text=>unistr('\3044\3044\3048')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280673937867869699)
,p_name=>'CA.NO.ACTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30B7\30E7\30F3\306A\3057')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280685500648869706)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30DA\30FC\30B8\3067\4F7F\7528\53EF\80FD\306A\30D8\30EB\30D7\306F\3042\308A\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279572477389869019)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9\306A\30E6\30FC\30B6\30FC\304C\5B58\5728\3057\307E\305B\3093 - \30DA\30FC\30B8\60C5\5831')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280694184159869711)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9\306A\65B0\898F\30E6\30FC\30B6\30FC\304C\898B\3064\304B\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280690296209869709)
,p_name=>'CA.NONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\306A\3057')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280670126345869696)
,p_name=>'CA.NOTE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30CE\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280645619719869681)
,p_name=>'CA.NOTIFICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280644494572869681)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DB\30FC\30E0\30DA\30FC\30B8\306B\901A\77E5\3092\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280645726285869681)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DB\30FC\30E0\30DA\30FC\30B8\4E0A\3067\3059\3079\3066\306E\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\8868\793A\3059\308B\30A2\30E9\30FC\30C8(\9EC4)\307E\305F\306F\30A8\30E9\30FC(\8D64)\3092\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\8005\304C\6307\5B9A\3067\304D\308B\3088\3046\306B\3057\307E\3059\3002\3053\306E\6A5F\80FD\306F\3001\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\30FB\30B3\30DF\30E5\30CB\30C6\30A3\306B\91CD\8981\306A\60C5\5831\3092\4E2D\7D99\3059\308B\5834\5408\306B\4FBF\5229\3067\3059\3002</p>'),
unistr('<p>\6B21\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\542B\307E\308C\307E\3059\3002<ul>'),
unistr('<li>\901A\77E5\3092\5B9A\7FA9\3059\308B\6A5F\80FD</li>'),
unistr('<li>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30DB\30FC\30E0\30DA\30FC\30B8\4E0A\3067\306E\901A\77E5\306E\8868\793A</li>'),
unistr('<li>\901A\77E5\8868\793A\306E\6642\9593\30A6\30A3\30F3\30C9\30A6\3092\5236\5FA1\3059\308B\6A5F\80FD</li>'),
unistr('<li>\30BF\30A4\30D7\5225\306E\901A\77E5\306E\8272\5206\3051\306E\30B5\30DD\30FC\30C8</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280662375590869692)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\540D\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280665831366869694)
,p_name=>'CA.NUM.ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279788376164869150)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5F15\6570\306E\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279784935015869148)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9B\5148\306E\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280698623776869714)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_language=>'ja'
,p_message_text=>unistr('\6570\5024\66F8\5F0F\30DE\30B9\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280667368405869695)
,p_name=>'CA.OCCURRENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\767A\751F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280707380847869719)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\306E\7BA1\7406\8005\304C\3044\306A\3044\5834\5408\3001\3053\306E\51E6\7406\3092\5B9F\884C\3067\304D\307E\305B\3093\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280674163083869699)
,p_name=>'CA.OPEN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30FC\30D7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280647188045869682)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306E\7DE8\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280647456264869682)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\8868\793A\3059\308B\76EE\7684\3067\30DA\30FC\30B8\306E\9806\5E8F\3092\5909\66F4\3057\307E\3059\3002 <br>'),
unistr('\30EA\30B9\30C8\5185\306E\30DA\30FC\30B8\306E\9806\5E8F\3092\5909\66F4\3059\308B\306B\306F\3001\5404\30DA\30FC\30B8\306E\30EA\30B9\30C8\306E\6700\5F8C\306B\3042\308B<em>\300C\30C9\30E9\30C3\30B0\3057\3066\30DA\30FC\30B8\306E\4E26\66FF\3048\300D</em>\30A2\30A4\30B3\30F3( <span class="fa fa-bars" aria-hidden="true"></span> )\3092\30AF\30EA\30C3\30AF\3057\3066\4FDD\6301\3057\3001\305D\306E\30DA\30FC\30B8\3092\4E0A\4E0B\306B\30C9\30E9\30C3\30B0\30FB\30A2\30F3\30C9\30FB\30C9\30ED\30C3\30D7\3057\307E\3059\3002</p>'),
unistr('<p>\30DB\30FC\30E0\30DA\30FC\30B8\306F\3001\5E38\306B\6700\521D\306B\8868\793A\3055\308C\308B\305F\3081\3001\9806\5E8F\3092\5909\66F4\3059\308B\3053\3068\306F\3067\304D\307E\305B\3093\3002<br>'),
unistr('\7BA1\7406\30DA\30FC\30B8\306F\5E38\306B\30EA\30B9\30C8\306E\4E0B\90E8\306B\8868\793A\3055\308C\3001\305D\306E\9806\5E8F\306F\300C\7BA1\7406\300D\30DA\30FC\30B8\306E\300C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\7BA1\7406\300D\30EA\30B9\30C8\306B\8868\793A\3055\308C\308B\9806\5E8F\3092\793A\3057\307E\3059\3002</p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279790466883869151)
,p_name=>'CA.OUTPUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\51FA\529B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279791666306869152)
,p_name=>'CA.OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280665562286869694)
,p_name=>'CA.PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280668733397869696)
,p_name=>'CA.PAGE.EVENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30A4\30D9\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280681289296869703)
,p_name=>'CA.PAGE.HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306E\30D8\30EB\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280667857732869695)
,p_name=>'CA.PAGE.ITEM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279936711904869242)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279936933103869242)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\306E\5B9F\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280665153153869693)
,p_name=>'CA.PAGE.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280680506861869703)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30CA\30D3\30B2\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280667240741869695)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30D1\30D5\30A9\30FC\30DE\30F3\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280693229259869711)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30BF\30A4\30D7"%0"\306F\6709\52B9\306A\30BF\30A4\30D7\3067\306F\3042\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280666597089869694)
,p_name=>'CA.PAGE.VIEWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\30FB\30D3\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280647629169869683)
,p_name=>'CA.PAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280647760329869683)
,p_name=>'CA.PAGES.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521D\671F\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\542B\3081\308B1\3064\4EE5\4E0A\306E\30DA\30FC\30B8\3092\5B9A\7FA9\3057\307E\3059\3002\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F5C\6210\3059\308B\306B\306F\3001\5C11\306A\304F\3068\30821\3064\306E\30DA\30FC\30B8\3092\5B9A\7FA9\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002</p>'),
unistr('<p>\3053\306E\30A6\30A3\30B6\30FC\30C9\3092\4F7F\7528\3057\3066\4EFB\610F\306E\6570\306E\30DA\30FC\30B8\3092\4F5C\6210\3057\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\30B9\30BF\30D6\3067\7F6E\63DB\3067\304D\307E\3059\3002\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210\5F8C\3001\30DA\30FC\30B8\306E\4F5C\6210\30A6\30A3\30B6\30FC\30C9\3092\4F7F\7528\3057\3066\5225\306E\30DA\30FC\30B8\3092\8FFD\52A0\3057\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280698577611869714)
,p_name=>'CA.PAGINATIONMETHOD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\533A\5207\308A\30E1\30BD\30C3\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280666817027869694)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\90E8\5206\30DA\30FC\30B8\30FB\30D3\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280672696348869698)
,p_name=>'CA.PHOTO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5199\771F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280673291918869698)
,p_name=>'CA.PHOTO.DELETED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5199\771F\304C\524A\9664\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280672783296869698)
,p_name=>'CA.PHOTO.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\5199\771F\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280672438135869698)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\5199\771F\306E\30A2\30C3\30D7\30ED\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280677223829869701)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30EC\30FC\30F3\30FB\30C6\30AD\30B9\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280706982869869719)
,p_name=>'CA.POSITIVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\826F\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280660049201869690)
,p_name=>'CA.PREFERENCES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30EA\30D5\30A1\30EC\30F3\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280704577135869718)
,p_name=>'CA.PREVIOUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280699277218869714)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30A4\30DE\30EA\8868\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280700100902869715)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E3B\30AD\30FC\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280700201412869715)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30E9\30A4\30DE\30EA\89AA\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280667450192869695)
,p_name=>'CA.PROCEDURE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30B7\30FC\30B8\30E3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280660677717869691)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30D7\30EA\30D5\30A1\30EC\30F3\30B9\304C\66F4\65B0\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279936359482869242)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\306E\30D5\30A7\30C3\30C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280661883316869691)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5916\89B3\306E\8A2D\5B9A\304C\4FDD\5B58\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280660540628869691)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30E0\30BE\30FC\30F3\30FB\30D7\30EA\30D5\30A1\30EC\30F3\30B9\304C\66F4\65B0\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280673014232869698)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30D5\30A1\30A4\30EB\5199\771F\306E\30C0\30A6\30F3\30ED\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279788601016869150)
,p_name=>'CA.PROGRAM.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30B0\30E9\30E0\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279788766286869150)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30B0\30E9\30E0\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280699595503869715)
,p_name=>'CA.QUERY'
,p_message_language=>'ja'
,p_message_text=>unistr('\554F\5408\305B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279785473203869148)
,p_name=>'CA.RAISE.EVENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30D9\30F3\30C8\306E\751F\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279417251706868925)
,p_name=>'CA.RATING'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A55\4FA1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280670911342869697)
,p_name=>'CA.READERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30C0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280660376078869690)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\306E\53D7\4FE1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280703184470869717)
,p_name=>'CA.RECENT.ERRORS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\65B0\306E\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280443545859869557)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280443666355869557)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5024')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280662536127869692)
,p_name=>'CA.RED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30C3\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280676184689869700)
,p_name=>'CA.REFERENCED'
,p_message_language=>'ja'
,p_message_text=>unistr('\53C2\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279935465865869242)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7BA1\7406\30DA\30FC\30B8\306E\30EA\30D5\30EC\30C3\30B7\30E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279552843780869007)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A4\30A2\30ED\30B0\306E\30AF\30ED\30FC\30BA\6642\306B\30EA\30D5\30EC\30C3\30B7\30E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279936850704869242)
,p_name=>'CA.REFRESH_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\306E\30EA\30D5\30EC\30C3\30B7\30E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280662035788869691)
,p_name=>'CA.REGION.BUTTONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DC\30BF\30F3\30FB\30EA\30FC\30B8\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280661930473869691)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30A2\30A4\30C6\30E0\30FB\30EA\30FC\30B8\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280667974432869695)
,p_name=>'CA.REGION.ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280679969837869703)
,p_name=>'CA.RELEASE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30EA\30FC\30B9%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280647294862869682)
,p_name=>'CA.REMOVING.PAGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306E\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280647363115869682)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('<p><strong>\300C\7DE8\96C6\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3066\30DA\30FC\30B8\3092\9078\629E\3057\3001<strong>\300C\30DA\30FC\30B8\306E\524A\9664\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\3066\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304B\3089\30DA\30FC\30B8\3092\524A\9664\3057\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279790092316869151)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\7E70\8FD4\3057\9593\9694')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279651551307869067)
,p_name=>'CA.REPLY.TO'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FD4\4FE1\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280653069779869686)
,p_name=>'CA.REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280652969365869686)
,p_name=>'CA.REPORT.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\307E\305F\306F\30AF\30E9\30B7\30C3\30AF\30FB\30EC\30DD\30FC\30C8\3068\3057\3066\8868\793A\3059\308B\30DA\30FC\30B8\3092\4F5C\6210\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30DA\30FC\30B8\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\554F\5408\305B\30BF\30A4\30D7</strong> - \30EC\30DD\30FC\30C8\306E\30BD\30FC\30B9[<strong>\8868\307E\305F\306F\30D3\30E5\30FC</strong>\307E\305F\306F<strong>SQL\554F\5408\305B</strong>]\3092\9078\629E\3057\307E\3059\3002<br>'),
unistr('    <strong>\8868\307E\305F\306F\30D3\30E5\30FC</strong>:'),
'    <ul>',
unistr('      <li>\8868\307E\305F\306F\30D3\30E5\30FC(\5FC5\9808) - \30EC\30DD\30FC\30C8\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('      <li>\30D5\30A9\30FC\30E0\3092\542B\3081\308B - \30E6\30FC\30B6\30FC\304C\8868\306E\5024\3092\7BA1\7406\3067\304D\308B\3088\3046\306B\3001\30EA\30F3\30AF\3055\308C\305F\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\3092\542B\3081\308B\5834\5408\306B\9078\629E\3057\307E\3059\3002</li>'),
'    </ul>',
unistr('    <strong>SQL\554F\5408\305B</strong>:'),
'    <ul>',
unistr('      <li>SQL\554F\5408\305B(\5FC5\9808) - \56FA\6709\306E\5217\3092\623B\3059\6709\52B9\306ASQL\6587\3092\5165\529B\3057\307E\3059\3002</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>\30EC\30DD\30FC\30C8\30FB\30BF\30A4\30D7</strong> - \30EC\30DD\30FC\30C8\306E\30BF\30A4\30D7(<strong>\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8</strong>\307E\305F\306F<strong>\30AF\30E9\30B7\30C3\30AF\30FB\30EC\30DD\30FC\30C8</strong>)\3092\9078\629E\3057\307E\3059\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280644735189869681)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\4ED8\304D\306E%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280489545728869586)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280702285377869716)
,p_name=>'CA.REPORT.VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\30FB\30D3\30E5\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280700841428869715)
,p_name=>'CA.REPORTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279791492429869152)
,p_name=>'CA.REQ.START.DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30AF\30A8\30B9\30C8\3055\308C\305F\958B\59CB\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280701029821869716)
,p_name=>'CA.REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5FC5\9808')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280678029115869701)
,p_name=>'CA.RESET'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30BB\30C3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280674010300869699)
,p_name=>'CA.RESOLVED'
,p_message_language=>'ja'
,p_message_text=>unistr('\89E3\6C7A\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280673711081869699)
,p_name=>'CA.RESPONSE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30B9\30DD\30F3\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279786707367869149)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5931\6557\6642\306B\518D\8D77\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279786822326869149)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30AB\30D0\30EA\6642\306B\518D\8D77\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279784022267869147)
,p_name=>'CA.RESTARTABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\518D\8D77\52D5\53EF\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279786321788869149)
,p_name=>'CA.RETRY.COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\518D\8A66\884C\56DE\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280696021851869713)
,p_name=>'CA.ROLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280668102005869695)
,p_name=>'CA.ROW.NUMBER'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\756A\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280677401993869701)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280695488804869712)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\30C6\30F3\30D7\30EC\30FC\30C8HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280696700702869713)
,p_name=>'CA.ROWS.CONTENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\30B3\30F3\30C6\30F3\30C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280668805424869696)
,p_name=>'CA.ROWS.FETCHED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A7\30C3\30C1\3055\308C\305F\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280698481778869714)
,p_name=>'CA.ROWSPERPAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\3054\3068\306E\884C\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279789665497869151)
,p_name=>'CA.RUN.COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9F\884C\56DE\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279791249931869152)
,p_name=>'CA.RUN.DURATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9F\884C\671F\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279786178576869149)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30B1\30B8\30E5\30FC\30EB\5236\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279788103371869150)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30B1\30B8\30E5\30FC\30EB\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279788285159869150)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30B1\30B8\30E5\30FC\30EB\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279788096607869150)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30B1\30B8\30E5\30FC\30EB\30FB\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280655558201869687)
,p_name=>'CA.SCHEMA'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30AD\30FC\30DE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280655643048869688)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\4F7F\7528\3059\308B\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\683C\7D0D\3059\308B\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30B9\30AD\30FC\30DE\3092\9078\629E\3057\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280697503381869713)
,p_name=>'CA.SCOPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9\7BC4\56F2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280678128844869702)
,p_name=>'CA.SEARCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280678214585869702)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280678380066869702)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\30C0\30A4\30A2\30ED\30B0\30FB\30DC\30C3\30AF\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280702419853869716)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\30D5\30A3\30EB\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280685080341869706)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\3053\306E\30DA\30FC\30B8\306F\3001\691C\7D22\6E08\306E\8868\3068\3044\3046\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8\30FB\30EA\30B9\30C8\304B\3089\5C0E\51FA\3055\308C\307E\3059\3002'),
'',
unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\4F5C\6210\30A6\30A3\30B6\30FC\30C9\304B\3089\6700\521D\306B\751F\6210\3055\308C\305F\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\306F\30EA\30B9\30C8\306B\81EA\52D5\7684\306B\8FFD\52A0\3055\308C\307E\3059\3002 '),
unistr('\72EC\81EA\306E\8868\3092\30EA\30B9\30C8\306B\8FFD\52A0\3059\308B\306B\306F\3001\300C\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8\300D\306B\79FB\52D5\3057\3001\300C\30EA\30B9\30C8\300D\3092\9078\629E\3057\3066\300C\691C\7D22\6E08\306E\8868\300D\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002'),
unistr('  \6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002'),
unistr('    \30A8\30F3\30C8\30EA: \30EA\30B9\30C8\30FB\30A8\30F3\30C8\30EA\30FB\30E9\30D9\30EB - \8868\306E\8868\793A\540D\3092\5165\529B\3057\307E\3059\3002'),
unistr('    \30BF\30FC\30B2\30C3\30C8: \30DA\30FC\30B8 - \30CA\30D3\30B2\30FC\30C8\5148\306E\9069\5207\306A\30DA\30FC\30B8\3092\9078\629E\3057\307E\3059(\304A\305D\3089\304F\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8)'),
unistr('    \30BF\30FC\30B2\30C3\30C8: \30AD\30E3\30C3\30B7\30E5\306E\30AF\30EA\30A2 - \30AF\30EA\30A2\3059\308B\5FC5\8981\306E\3042\308B\30DA\30FC\30B8\3092\5165\529B\3057\307E\3059(\4E00\822C\306B\306F\3001\30DA\30FC\30B8\3067\5165\529B\3057\305F\306E\3068\540C\3058\756A\53F7)\3002'),
unistr('       \5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\306B\30CA\30D3\30B2\30FC\30C8\3059\308B\5834\5408\306F\3001\305F\3068\3048\3070CIR,RIR\3092\8FFD\52A0\3057\3066\65E2\5B58\306E\30D5\30A3\30EB\30BF\3092\30AF\30EA\30A2\3057\307E\3059\3002'),
unistr('    \30BF\30FC\30B2\30C3\30C8: \3053\308C\3089\306E\30A2\30A4\30C6\30E0\3092\8A2D\5B9A - \79FB\5165\3059\308B\9069\5207\306A\30DA\30FC\30B8\30FB\30A2\30A4\30C6\30E0\3092\9078\629E(\307E\305F\306F\5165\529B)\3057\307E\3059\3002'),
unistr('       \5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\306B\30CA\30D3\30B2\30FC\30C8\3059\308B\5834\5408\306F\3001IR_[COLUMN_NAME]\3068\5165\529B\3057\307E\3059\3002'),
unistr('    \30BF\30FC\30B2\30C3\30C8: \3053\308C\3089\306E\5024\3092\4F7F\7528\3057\307E\3059 - =PK=\3068\5165\529B\3057\307E\3059'),
unistr('    \30E6\30FC\30B6\30FC\5B9A\7FA9\5C5E\6027: 1 - \691C\7D22\3059\308B\8868\540D\3092\5927\6587\5B57\3067\5165\529B\3057\307E\3059\3002'),
unistr('    \30E6\30FC\30B6\30FC\5B9A\7FA9\5C5E\6027: 2 - \30D7\30E9\30A4\30DE\30EA\5217\540D\3092\5927\6587\5B57\3067\5165\529B\3057\307E\3059\3002'),
unistr('    \30E6\30FC\30B6\30FC\5B9A\7FA9\5C5E\6027: 3 (\30AA\30D7\30B7\30E7\30F3) -  \691C\7D22\3059\308B\5217\306E\30AB\30F3\30DE\533A\5207\308A\30EA\30B9\30C8\3002'),
unistr('       \5217\304C\6307\5B9A\3055\308C\3066\3044\306A\3044\5834\5408\306F\3001\3059\3079\3066\306E\30C6\30AD\30B9\30C8(varchar2)\304A\3088\3073\30AD\30E3\30E9\30AF\30BF\30FB\30E9\30FC\30B8\30FB\30AA\30D6\30B8\30A7\30AF\30C8(clob)\5217\304C\691C\7D22\3055\308C\307E\3059\3002'),
'',
unistr('\6CE8\610F: \8907\6570\306E\8868\304C\30EA\30B9\30C8\3055\308C\3066\3044\308B\5834\5408\306F\3001\691C\7D22\53EF\80FD\306A\8868\306E\30EA\30B9\30C8\306E\307F\30E6\30FC\30B6\30FC\306B\8868\793A\3055\308C\307E\3059\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280677800734869701)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22\7D50\679C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280700069449869715)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30AB\30F3\30C0\30EA\8868\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280674475683869699)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\3057\305F\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279650841658869067)
,p_name=>'CA.SEND.BEGIN'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\958B\59CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279651293751869067)
,p_name=>'CA.SEND.COUNT'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279650773053869067)
,p_name=>'CA.SEND.END'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\7D42\4E86')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279651147889869067)
,p_name=>'CA.SEND.ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\30A8\30E9\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280706051121869719)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280706136691869719)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\65B0\3057\3044\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306E\53D7\4FE1\6642\306B\96FB\5B50\30E1\30FC\30EB\3092\9001\4FE1\3059\308B\304B\3069\3046\304B\3092\6C7A\5B9A\3057\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280702793255869717)
,p_name=>'CA.SEND.FROM'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\5143')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280695224074869712)
,p_name=>'CA.SEND.TO'
,p_message_language=>'ja'
,p_message_text=>unistr('\9001\4FE1\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280679766642869702)
,p_name=>'CA.SERIES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B7\30EA\30FC\30BA%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279791137844869152)
,p_name=>'CA.SESSION.ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280697770668869714)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BB\30C3\30B7\30E7\30F3\30FB\30B9\30C6\30FC\30C8\4FDD\8B77')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280654999528869687)
,p_name=>'CA.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280655081311869687)
,p_name=>'CA.SETTINGS.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\751F\6210\306B\4F7F\7528\3055\308C\308B\8A2D\5B9A\3092\6307\5B9A\3057\307E\3059\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280679302510869702)
,p_name=>'CA.SHOW.ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279552043093869007)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9\7BC4\56F2\306E\8868\793A/\975E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280680412212869703)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30E0\30BE\30FC\30F3\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280680203488869703)
,p_name=>'CA.SIGN.IN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30A4\30F3\30A4\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280681492937869704)
,p_name=>'CA.SIGN.OUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30A4\30F3\30A2\30A6\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279791017231869152)
,p_name=>'CA.SLAVE.PID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30EC\30FC\30D6PID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279785032163869148)
,p_name=>'CA.SOURCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280693343705869711)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30B9\30FB\30BF\30A4\30D7\304C\6709\52B9\306A\30BF\30A4\30D7\3067\306F\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280685127203869706)
,p_name=>'CA.SOURCES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BD\30FC\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279787989908869150)
,p_name=>'CA.START.DATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\958B\59CB\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279789780005869151)
,p_name=>'CA.STATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\72B6\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280700923874869716)
,p_name=>'CA.STATICDEFAULT'
,p_message_language=>'ja'
,p_message_text=>unistr('\9759\7684\30C7\30D5\30A9\30EB\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280664117787869693)
,p_name=>'CA.STATUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30C6\30FC\30BF\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279785753494869148)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A6\30A3\30F3\30C9\30A6\3092\9589\3058\308B\969B\306E\505C\6B62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279785879266869149)
,p_name=>'CA.STORE.OUTPUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\51FA\529B\306E\683C\7D0D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280674659935869699)
,p_name=>'CA.SUBJECT'
,p_message_language=>'ja'
,p_message_text=>unistr('\4EF6\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280673389261869699)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A3\30FC\30C9\30D0\30C3\30AF\306E\9001\4FE1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280698071269869714)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\63A8\5968\3055\308C\308B\8996\899A\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280689915272869709)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280690096062869709)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('<p>\30A4\30F3\30B9\30C8\30FC\30EB\30FB\30B9\30AF\30EA\30D7\30C8\306B\306F\3001\4E00\822C\306B\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\306E\4F5C\6210\3084\64CD\4F5C\3001\307E\305F\306F\65E2\5B58\306E\30EC\30B3\30FC\30C9\306B\5BFE\3059\308B\633F\5165/\66F4\65B0/\524A\9664\306E\5B9F\884C\306E\305F\3081\306E\30B3\30FC\30C9\3092\5165\529B\3057\307E\3059\3002\524A\9664\30B9\30AF\30EA\30D7\30C8\306B\306F\3001\4E00\822C\306B\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\524A\9664\3059\308B\305F\3081\306E\30B3\30FC\30C9\3092\5165\529B\3057\307E\3059\3002\3053\308C\3089\306E\30B9\30AF\30EA\30D7\30C8\306F\300C\30B5\30DD\30FC\30C8\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\300D\306B\7D44\307F\8FBC\307E\308C\308B\305F\3081\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A8\30AF\30B9\30DD\30FC\30C8\6642\306B\3001\30C6\30B9\30C8\304A\3088\3073\672C\756A\74B0\5883\3067\3053\308C\3089\306E\540C\3058\66F4\65B0\304C\5B9F\884C\3055\308C\307E\3059\3002</p>')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280690193266869709)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A4\30F3\30DD\30FC\30C8\6642\306B\5B9F\884C\3055\308C\308B\30A4\30F3\30B9\30C8\30FC\30EB\30FB\30B9\30AF\30EA\30D7\30C8\306B\6709\52B9\306ASQL\307E\305F\306FPL/SQL\6587\3001\3042\308B\3044\306F\305D\306E\4E21\65B9\3092\5165\529B\3057\307E\3059\3002</p>'),
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304C\5225\306E\74B0\5883\306B\30A4\30F3\30DD\30FC\30C8\3055\308C\305F\3068\304D\3060\3051\3067\306A\304F\73FE\5728\306E\74B0\5883\3067\3082\3053\308C\3089\306E\6587\3092\5B9F\884C\3059\308B\5834\5408\306F\3001<strong>\300C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\4F5C\6210\6642\306B\5B9F\884C\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</p>'),
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30D3\30EB\30C0\30FC\304B\3089\524A\9664\3055\308C\305F\3068\304D\306B\5B9F\884C\3055\308C\308B\524A\9664\30B9\30AF\30EA\30D7\30C8\306B\6709\52B9\306ASQL\307E\305F\306FPL/SQL\6587\3001\3042\308B\3044\306F\305D\306E\4E21\65B9\3092\5165\529B\3057\307E\3059\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279785333228869148)
,p_name=>'CA.SYSTEM'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B7\30B9\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280699425839869715)
,p_name=>'CA.TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280655706484869688)
,p_name=>'CA.TABLE.PREFIX'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30EC\30FC\30E0\30EF\30FC\30AF\30FB\30AA\30D6\30B8\30A7\30AF\30C8\63A5\982D\8F9E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280655874290869688)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\4F7F\7528\3059\308B\30AA\30D6\30B8\30A7\30AF\30C8\63A5\982D\8F9E\3092\5165\529B\3057\307E\3059\3002\4E00\90E8\306E\6A5F\80FD\306F\3001\4F5C\6210\3059\308B\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8(\30D1\30C3\30B1\30FC\30B8\3084\8868\3092\542B\3080)\306B\3053\306E\63A5\982D\8F9E\3092\8FFD\52A0\3057\307E\3059\3002</p>'),
unistr('<p>\8B66\544A: \5FC5\305A\4ED6\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\4F7F\7528\3055\308C\3066\3044\306A\3044\4E00\610F\306E\63A5\982D\8F9E\3092\5165\529B\3057\3066\304F\3060\3055\3044\3002\4E00\610F\3067\306F\306A\3044\5834\5408\3001\4F5C\6210\6642\306B\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\30A8\30E9\30FC\304C\767A\751F\3057\3001\6B63\3057\304F\52D5\4F5C\3057\306A\3044\53EF\80FD\6027\304C\3042\308A\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280700383355869715)
,p_name=>'CA.TABLECOLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\306E\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280695306966869712)
,p_name=>'CA.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280677713109869701)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30C6\30F3\30D7\30EC\30FC\30C8\540D\306F\3059\3067\306B\4F7F\7528\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280674557094869699)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30F3\30D7\30EC\30FC\30C8\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280663254485869692)
,p_name=>'CA.TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30AD\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279651016959869067)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30AD\30B9\30C8\30FB\30DC\30C7\30A3\30FB\30B5\30A4\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280675732435869700)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30AD\30B9\30C8\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280661489062869691)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306E\30C6\30FC\30DE\30FB\30D7\30EA\30D5\30A1\30EC\30F3\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280661674341869691)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_language=>'ja'
,p_message_text=>unistr('\9078\629E\3059\308B\3068\3001\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306F\3001\300C\30AB\30B9\30BF\30DE\30A4\30BA\300D\30EA\30F3\30AF\3092\4F7F\7528\3057\3066\72EC\81EA\306E\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\3092\9078\629E\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280661535712869691)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\3088\308B\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\9078\629E\3092\8A31\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280645870788869681)
,p_name=>'CA.THEME.SELECTOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\9078\629E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280644271656869680)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30EB\30C3\30AF\30FB\30A2\30F3\30C9\30FB\30D5\30A3\30FC\30EB\306E\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280645915926869682)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7BA1\7406\8005\304C\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30C7\30D5\30A9\30EB\30C8\306E\30AB\30E9\30FC\30FB\30B9\30AD\30FC\30E0(\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB)\3092\9078\629E\3067\304D\308B\3088\3046\306B\3057\307E\3059\3002\7BA1\7406\8005\306F\3001\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\305D\306E\72EC\81EA\306E\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\9078\629E\3092\8A31\53EF\3059\308B\3053\3068\3082\3067\304D\307E\3059\3002\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306F\3001\30DB\30FC\30E0\30DA\30FC\30B8\306E\4E00\756A\4E0B\306B\3042\308B<em>\300C\30AB\30B9\30BF\30DE\30A4\30BA\300D</em>\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\3001\4F7F\7528\53EF\80FD\306A\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\304B\3089\9078\629E\3059\308B\3060\3051\3067\3059\3002\305F\3068\3048\3070\3001\8996\529B\306B\969C\5BB3\306E\3042\308B\30E6\30FC\30B6\30FC\306F\3001\30AB\30E9\30FC\30FB\30B3\30F3\30C8\30E9\30B9\30C8\304C\975E\5E38\306B\9AD8\3044<em>\300CVista\300D</em>\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\3092\512A\5148\7684\306B\4F7F\7528\3067\304D\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\542B\307E\308C\307E\3059\3002'),
'<ul>',
unistr('<li>\7BA1\7406\8005\306B\3088\308B\30C7\30D5\30A9\30EB\30C8\30FB\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\5B9A\7FA9\306E\8A31\53EF</li>'),
unistr('<li>\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\3088\308B\69D8\3005\306A\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\306E\9078\629E\306E\8A31\53EF</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280654307210869687)
,p_name=>'CA.THEME.STYLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280654408184869687)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\8868\793A\306B\4F7F\7528\3059\308B\30C7\30D5\30A9\30EB\30C8\306E\30C6\30FC\30DE\30FB\30B9\30BF\30A4\30EB\3092\9078\629E\3057\307E\3059\3002</p>'),
unistr('<p>\30B9\30BF\30A4\30EB\306F\3001\4E8B\524D\5B9A\7FA9\3055\308C\305F\5225\306E\30B9\30BF\30A4\30EB\306B\7C21\5358\306B\5909\66F4\3057\305F\308A\3001\751F\6210\5F8C\306B\5909\66F4\3057\305F\308A\3067\304D\307E\3059\3002\30B9\30BF\30A4\30EB\3092\5909\66F4\3059\308B\306B\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\5B9F\884C\3057\3066\300C\958B\767A\8005\300D\30C4\30FC\30EB\30D0\30FC\306E<strong>\300C\30C6\30FC\30DE\30FB\30ED\30FC\30E9\30FC\300D</strong>\3092\30AF\30EA\30C3\30AF\3057\307E\3059\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280668481280869695)
,p_name=>'CA.TIME'
,p_message_language=>'ja'
,p_message_text=>unistr('\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280660128441869690)
,p_name=>'CA.TIME.ZONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30E0\30BE\30FC\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280646915355869682)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30E0\30BE\30FC\30F3\30FB\30B5\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280643881432869680)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\304A\3088\3073\30E6\30FC\30B6\30FC\30FB\30BF\30A4\30E0\30BE\30FC\30F3\306E\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280646678478869682)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\30ED\30FC\30AB\30EB\30FB\30BF\30A4\30E0\30BE\30FC\30F3\3092\8A2D\5B9A\3067\304D\308B\3088\3046\306B\3057\307E\3059\3002\3053\308C\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\8868\3067\30BF\30A4\30E0\30BE\30FC\30F3\5BFE\5FDC\306E\65E5\4ED8\30BF\30A4\30D7(Timestamp with Local Time Zone\306A\3069)\3092\4F7F\7528\3057\3066\304A\308A\3001\30EC\30DD\30FC\30C8\3084\30C7\30FC\30BF\5165\529B\3067\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306E\6240\5728\5834\6240\3092\53CD\6620\3059\308B\5834\5408\306B\91CD\8981\3067\3059\3002</p>'),
unistr('<p>\6B21\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\542B\307E\308C\307E\3059:'),
'<ul>',
unistr('<li>\7BA1\7406\8005\306B\3088\308B\30C7\30D5\30A9\30EB\30C8\30FB\30BF\30A4\30E0\30BE\30FC\30F3\306E\8A2D\5B9A\306E\8A31\53EF</li>'),
unistr('<li>\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\306B\3088\308B\5404\81EA\306E\30BF\30A4\30E0\30BE\30FC\30F3\30FB\30D7\30EA\30D5\30A1\30EC\30F3\30B9\306E\9078\629E\306E\8A31\53EF</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280703390517869717)
,p_name=>'CA.TIMEFRAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\6642\9593\67A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280703672981869717)
,p_name=>'CA.TIMELINE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30E0\30E9\30A4\30F3\30FB\30DA\30FC\30B8\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280703764470869717)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7279\306B\66F4\65B0\3092\8868\793A\3059\308B\5834\5408\306B\5F79\7ACB\3064\30BF\30A4\30E0\30E9\30A4\30F3\3092\8868\793A\3059\308B\30DA\30FC\30B8\3092\4F5C\6210\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30DA\30FC\30B8\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\8868\307E\305F\306F\30D3\30E5\30FC</strong>(\5FC5\9808) - \30BF\30A4\30E0\30E9\30A4\30F3\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30E6\30FC\30B6\30FC\540D</strong>(\5FC5\9808) - \30BF\30A4\30E0\30E9\30A4\30F3\30FB\30A8\30F3\30C8\30EA\306B\8868\793A\3055\308C\308B\30E6\30FC\30B6\30FC\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\65E5\4ED8</strong>(\5FC5\9808) - \30BF\30A4\30E0\30E9\30A4\30F3\30FB\30A8\30F3\30C8\30EA\306E\65E5\4ED8\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A4\30D9\30F3\30C8\540D</strong>(\5FC5\9808) - \30BF\30A4\30E0\30E9\30A4\30F3\30FB\30A8\30F3\30C8\30EA\306E\30BF\30A4\30C8\30EB\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\8AAC\660E</strong> - \30BF\30A4\30E0\30E9\30A4\30F3\30FB\30A8\30F3\30C8\30EA\306E\8AAC\660E\3068\3057\3066\4F7F\7528\3059\308B\5217\3092\8868\307E\305F\306F\30D3\30E5\30FC\304B\3089\9078\629E\3057\307E\3059\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280665306615869694)
,p_name=>'CA.TIMESTAMP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30E0\30B9\30BF\30F3\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280669986838869696)
,p_name=>'CA.TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30C8\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279651691411869067)
,p_name=>'CA.TO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9B\5148')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280669122947869696)
,p_name=>'CA.TOP.USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C8\30C3\30D7\30FB\30E6\30FC\30B6\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280669254554869696)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E0A\4F4D\30E6\30FC\30B6\30FC\30FB\30C1\30E3\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280666734687869694)
,p_name=>'CA.TOTAL.ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\5408\8A08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280671194275869697)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306B\5B58\5728\3057\306A\3044\30E6\30FC\30B6\30FC\306E\30C7\30D5\30A9\30EB\30C8\306E\30ED\30FC\30EB:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280663382965869692)
,p_name=>'CA.TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279882243400869208)
,p_name=>'CA.UI.DEFAULTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\306E\30C7\30D5\30A9\30EB\30C8\5024')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279882367700869208)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\3054\3068\306E\884C\6570\306A\3069\306E\30E6\30FC\30B6\30FC\30FB\30A4\30F3\30BF\30D5\30A7\30FC\30B9\8A2D\5B9A\306E\30C7\30D5\30A9\30EB\30C8\3092\8A2D\5B9A\3057\3001LOV\306E\5B9A\7FA9\3092\8FFD\52A0\3057\307E\3059\3002\3053\308C\3089\306E\8A2D\5B9A\306F\3001\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\5185\3067\30B3\30F3\30DD\30FC\30CD\30F3\30C8\3092\751F\6210\3059\308B\969B\306B\4F7F\7528\3055\308C\307E\3059\3002 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280663569444869692)
,p_name=>'CA.UNTIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\7D42\4E86')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279935277339869241)
,p_name=>'CA.UPDATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280672953193869698)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30D5\30A1\30A4\30EB\306E\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280663875143869693)
,p_name=>'CA.UPDATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280663938997869693)
,p_name=>'CA.UPDATED.BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\66F4\65B0\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280665215369869693)
,p_name=>'CA.USER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280692809944869711)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_language=>'ja'
,p_message_text=>unistr('\8907\6570\30E6\30FC\30B6\30FC\306E\8FFD\52A0 - \30B9\30C6\30C3\30D71')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280692920477869711)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_language=>'ja'
,p_message_text=>unistr('\8907\6570\30E6\30FC\30B6\30FC\306E\8FFD\52A0 - \30B9\30C6\30C3\30D72')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280693028402869711)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8907\6570\30E6\30FC\30B6\30FC\306E\8FFD\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280667626075869695)
,p_name=>'CA.USER.AGENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30A8\30FC\30B8\30A7\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280681086609869703)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\6570\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280669401291869696)
,p_name=>'CA.USER.NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280671933078869698)
,p_name=>'CA.USER.PROFILE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30D7\30ED\30D5\30A1\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280646849565869682)
,p_name=>'CA.USER.PROFILES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\30FB\30D7\30ED\30D5\30A1\30A4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280643770512869680)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\306B\3088\308B\30D7\30ED\30D5\30A1\30A4\30EB\306E\66F4\65B0\3092\8A31\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280646789194869682)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\753B\50CF\3084\30A2\30D0\30BF\30FC\306A\3069\81EA\8EAB\306B\95A2\3059\308B\8FFD\52A0\60C5\5831\3092\5165\529B\3057\3066\81EA\5206\306E\30A2\30AB\30A6\30F3\30C8\3092\30D1\30FC\30BD\30CA\30E9\30A4\30BA\3067\304D\308B\3088\3046\306B\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\542B\307E\308C\307E\3059:'),
'<ul>',
unistr('<li>\30A8\30F3\30C9\30FB\30E6\30FC\30B6\30FC\304C\81EA\5206\306E\30D7\30ED\30D5\30A1\30A4\30EB\3092\8A2D\5B9A\3059\308B\305F\3081\306E\30DA\30FC\30B8\306E\8A2D\5B9A</li>'),
unistr('<li>\5199\771F/\30A2\30D0\30BF\30FC\3092\30A2\30C3\30D7\30ED\30FC\30C9\3059\308B\6A5F\80FD</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280672120410869698)
,p_name=>'CA.USERNAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280671230263869697)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D\306E\5F62\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280693744256869711)
,p_name=>'CA.USERNAMES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279889902816869213)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D\306E\5F62\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280694333060869712)
,p_name=>'CA.USERS.ADDED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\304C\8FFD\52A0\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280695897128869712)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30FC\30EB\5225\30E6\30FC\30B6\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280675308690869700)
,p_name=>'CA.USERS.INCLUDED'
,p_message_language=>'ja'
,p_message_text=>unistr('\542B\307E\308C\308B\30E6\30FC\30B6\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280694004974869711)
,p_name=>'CA.USERS.TO.ADD'
,p_message_language=>'ja'
,p_message_text=>unistr('\8FFD\52A0\3059\308B\30E6\30FC\30B6\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280671423644869697)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D\306E\5F62\5F0F\304C\66F4\65B0\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279572217928869019)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'ja'
,p_message_text=>unistr('\6709\52B9\306A\30E6\30FC\30B6\30FC\304C\5B58\5728\3057\307E\3059 - \30DA\30FC\30B8\60C5\5831')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280687003504869707)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3ID\306F\3059\3067\306B\5B58\5728\3059\308B\304B\3001\5225\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3067\4E88\7D04\3055\308C\3066\3044\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279830591950869176)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\540D\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280696476614869713)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1\5148\306E\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3092\6307\5B9A\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280696245776869713)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\3092\6307\5B9A\3059\308B\304B\3001\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1\5148\30E6\30FC\30B6\30FC\306E\30BB\30C3\30C8\3092\9078\629E\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280696324887869713)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\306E\9001\4FE1\5148\30E6\30FC\30B6\30FC\306E\30BB\30C3\30C8\3092\9078\629E\3059\308B\5FC5\8981\304C\3042\308A\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280687124679869707)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\63A5\982D\8F9E\306F\30016\6587\5B57\4EE5\4E0B\3067\3001\6587\5B57\304B\3089\59CB\3081\308B\5FC5\8981\304C\3042\308A\3001\6587\5B57\3001\6570\5B57\304A\3088\3073\30A2\30F3\30C0\30FC\30B9\30B3\30A2\306E\307F\542B\3081\308B\3053\3068\304C\3067\304D\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280687290514869707)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\306E\8868\63A5\982D\8F9E\3092\5165\529B\3057\3066\304F\3060\3055\3044\3002\6B21\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30AA\30D6\30B8\30A7\30AF\30C8\306F\3059\3067\306B\5B58\5728\3057\307E\3059: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280671829469869698)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E6\30FC\30B6\30FC\540D\304C\6709\52B9\306A\96FB\5B50\30E1\30FC\30EB\30FB\30A2\30C9\30EC\30B9\5F62\5F0F\3067\306F\3042\308A\307E\305B\3093\3002\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\6B21\306E\30E6\30FC\30B6\30FC\540D\306E\5F62\5F0F\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280671764156869697)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\5F62\5F0F\306E\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280669346495869696)
,p_name=>'CA.VIEW.AS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\5F62\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280690703044869709)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EB\30FC\30D7\30EA\30F3\30C8\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280679257998869702)
,p_name=>'CA.VIEW.DETAILS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280696611473869713)
,p_name=>'CA.VIEW.EMAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\96FB\5B50\30E1\30FC\30EB\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280681373222869703)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30ED\30D5\30A1\30A4\30EB\306E\8868\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280666232132869694)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_language=>'ja'
,p_message_text=>unistr('\91CD\307F\4ED8\3051\30D1\30D5\30A9\30FC\30DE\30F3\30B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280701213090869716)
,p_name=>'CA.WIDTH'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E45')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280705415481869718)
,p_name=>'CA.WIZARD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A6\30A3\30B6\30FC\30C9\30FB\30DA\30FC\30B8\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279572111500869019)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A6\30A3\30B6\30FC\30C9\30FB\30B3\30F3\30C6\30CA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280705553244869718)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\30A6\30A3\30B6\30FC\30C9\3068\3057\3066\4F7F\7528\3059\308B\30DA\30FC\30B8\306E\30B3\30EC\30AF\30B7\30E7\30F3\3092\4F5C\6210\3057\307E\3059\3002\4E00\822C\306B\3001\30A6\30A3\30B6\30FC\30C9\306F\3001\8907\6570\306E\30B9\30C6\30C3\30D7\3067\30C7\30FC\30BF\3092\5165\529B\3059\308B\5834\5408\306B\4F7F\7528\3057\307E\3059\3002</p>'),
unistr('<p>\6B21\306E\5C5E\6027\3092\5165\529B\3057\307E\3059\3002</p>'),
'<ul>',
unistr('  <li><strong>\30A6\30A3\30B6\30FC\30C9\540D</strong>(\5FC5\9808) - \3053\306E\30DA\30FC\30B8\306E\540D\524D\3092\5165\529B\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30A2\30A4\30B3\30F3\306E\8A2D\5B9A</strong> - \3053\306E\30DA\30FC\30B8\306E\30CA\30D3\30B2\30FC\30B7\30E7\30F3\30FB\30E1\30CB\30E5\30FC\306B\8868\793A\3059\308B\30A2\30A4\30B3\30F3\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30DA\30FC\30B8\30FB\30E2\30FC\30C9</strong>(\5FC5\9808) - \30A6\30A3\30B6\30FC\30C9\306E\30B9\30C6\30C3\30D7\3092\30E2\30FC\30C0\30EB\30FB\30DA\30FC\30B8\304B\901A\5E38\306E\30DA\30FC\30B8\306E\3069\3061\3089\3067\8868\793A\3059\308B\304B\3092\9078\629E\3057\307E\3059\3002<strong>\30E2\30FC\30C0\30EB\30FB\30DA\30FC\30B8</strong>\307E\305F\306F<strong>\30D5\30EB\30FB\30DA\30FC\30B8</strong>\306E\3044\305A\308C\304B\3092\9078\629E\3057\307E\3059\3002</li>'),
unistr('  <li><strong>\30B9\30C6\30C3\30D71 ... 8</strong> - \30A6\30A3\30B6\30FC\30C9\306E\30B9\30C6\30C3\30D7\306E\30DA\30FC\30B8\540D\3092\5165\529B\3057\307E\3059\3002<br><em><strong>\6CE8\610F:</strong> \30B9\30C6\30C3\30D75\304B\30898\307E\3067\306F\3001\305D\306E\524D\306E\30B9\30C6\30C3\30D7\3067\540D\524D\304C\5165\529B\3055\308C\308B\3068\8868\793A\3055\308C\307E\3059\3002</em></li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280669760520869696)
,p_name=>'CA.WORK.PHONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\52E4\52D9\5148\96FB\8A71')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280662451407869692)
,p_name=>'CA.YELLOW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30A8\30ED\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279882842858869208)
,p_name=>'CA.YES'
,p_message_language=>'ja'
,p_message_text=>unistr('\306F\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279417164238868925)
,p_name=>'CACHED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AD\30E3\30C3\30B7\30E5\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279300863521868852)
,p_name=>'CACHE_CREATED'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F5C\6210\6E08\306E\30AD\30E3\30C3\30B7\30E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279288301033868844)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\306E\524A\9664\6A5F\80FD\304C\7121\52B9\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279272892437868834)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\306E\8FFD\52A0\6A5F\80FD\304C\7121\52B9\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279272923164868834)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\306E\66F4\65B0\6A5F\80FD\304C\7121\52B9\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279456164826868949)
,p_name=>'CALENDAR.NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279456020763868949)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_language=>'ja'
,p_message_text=>unistr('\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279313795786868860)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7C21\6613\30AB\30EC\30F3\30C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280477292635869578)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30EC\30F3\30C0\30FB\30A8\30F3\30C8\30EA\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279261486712868827)
,p_name=>'CALENDAR_POPUP'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\30AB\30EC\30F3\30C0\30FB\30DD\30C3\30D7\30A2\30C3\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279411912585868922)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30EC\30F3\30C0\304C\6B63\5E38\306B\4F5C\6210\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279814724854869166)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30AC\30B7\30FC\30FB\30AB\30EC\30F3\30C0\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279313642523868860)
,p_name=>'CALENDAR_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30EC\30F3\30C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279665249453869075)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3%0\3068\30C6\30F3\30D7\30EC\30FC\30C8ID %1\304B\3089\30B3\30D4\30FC\3092\8A66\884C\3057\307E\3057\305F\304C\3001\30AB\30EC\30F3\30C0\30FB\30C6\30F3\30D7\30EC\30FC\30C8\304C\898B\3064\304B\308A\307E\305B\3093')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279816140777869167)
,p_name=>'CANCEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279254593350868822)
,p_name=>'CANDLESTICK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30ED\30FC\30BD\30AF\8DB3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280150832001869373)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30B9\30B1\30FC\30C9\30FB\30B9\30BF\30A4\30EB\30B7\30FC\30C8')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279872229678869201)
,p_name=>'CENTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E2D\592E')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279906397099869224)
,p_name=>'CHANGES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5909\66F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280536494978869615)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C\306E\5909\66F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279810568973869164)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30B5\30A4\30BA\306E\5909\66F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279428707341868932)
,p_name=>'CHANGE_PW_REQUEST'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\30EA\30AF\30A8\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279810335573869163)
,p_name=>'CHANGE_REQUEST'
,p_message_language=>'ja'
,p_message_text=>unistr('\5909\66F4\30EA\30AF\30A8\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280098061331869341)
,p_name=>'CHANGE_WORKSPACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\5909\66F4')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279782325166869146)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6587\5B57\30BB\30C3\30C8\5217')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279507622091868980)
,p_name=>'CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279259887200868825)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7121\52B9\306A\30C1\30E3\30FC\30C8\554F\5408\305B: %0<br><br>'),
unistr('\6B21\306E\69CB\6587\3092\4F7F\7528:'),
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
unistr('<tr><td>LABEL</td><td>\30D0\30FC\306B\5C5E\3059\308B\30C6\30AD\30B9\30C8</td></tr>'),
unistr('<tr><td>VALUE</td><td>\30D0\30FC\30FB\30B5\30A4\30BA\3092\5B9A\7FA9\3059\308B\6570\5024\5217</td></tr>'),
'</table>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279450934309868946)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7121\52B9\306A\30C1\30E3\30FC\30C8\554F\5408\305B\3002<br /><br /> \6B21\306E\69CB\6587\3092\4F7F\7528: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'),
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
unistr('<td>\30C0\30A4\30E4\30EB\5024\3092\5B9A\7FA9\3059\308B\6570\5024\5217\3002</td>'),
'</tr>',
'<tr>',
'<td>MAX</td>',
unistr('<td>\6700\5927\30C0\30A4\30E4\30EB\5024\3092\5B9A\7FA9\3059\308B\6570\5024\5217\3002</td>'),
'</tr>',
'<tr>',
unistr('<td>LOW (\30AA\30D7\30B7\30E7\30F3)</td>'),
unistr('<td>\524D\306E\6700\5C0F\30C0\30A4\30E4\30EB\5024\3092\5B9A\7FA9\3059\308B\6570\5024\5217\3002</td>'),
'</tr>',
'<tr>',
unistr('<td>HIGH (\30AA\30D7\30B7\30E7\30F3)</td>'),
unistr('<td>\524D\306E\6700\5927\30C0\30A4\30E4\30EB\5024\3092\5B9A\7FA9\3059\308B\6570\5024\5217\3002</td>'),
'</tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279525827984868991)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7\304C\7121\52B9\3067\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279259725686868825)
,p_name=>'CHART.INVALID_QUERY'
,p_message_language=>'ja'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('SQL\554F\5408\305B\306E\89E3\6790\306B\5931\6557\3002'),
'<p>%0</p>',
unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\5B9F\884C\6642\306B\7279\5B9A\306E\554F\5408\305B\306E\307F\304C\5B9F\884C\3055\308C\3001\554F\5408\305B\306E\69CB\6587\304C\6B63\3057\3044\5834\5408\306F\3001\691C\8A3C\3092\884C\308F\306A\304F\3066\3082\305D\306E\554F\5408\305B\3092\4FDD\5B58\3067\304D\307E\3059(\6B21\306E\554F\5408\305B\30BD\30FC\30B9\306E\30AA\30D7\30B7\30E7\30F3\3092\53C2\7167)\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280591614474869648)
,p_name=>'CHART_DEGREES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279759248134869132)
,p_name=>'CHART_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\306E\30C1\30E3\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279289147075868844)
,p_name=>'CHART_SERIES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30B7\30EA\30FC\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279806809546869161)
,p_name=>'CHART_SERIES_ERROR'
,p_message_language=>'ja'
,p_message_text=>unistr('%1\306E\30C1\30E3\30FC\30C8\30FB\30B7\30EA\30FC\30BA\30FB\30A8\30E9\30FC%0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279405165327868918)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\304C\6B63\5E38\306B\4F5C\6210\3055\308C\307E\3057\305F\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279364468419868892)
,p_name=>'CHECK$'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\30BB\30EC\30AF\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280524142938869607)
,p_name=>'CHECKED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30A7\30C3\30AF\6E08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279763169402869135)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30A7\30C3\30AF\30B5\30E0\304C\5FC5\8981 - \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30EC\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279579682353869024)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30A7\30C3\30AF\30B5\30E0\304C\5FC5\8981 - \30BB\30C3\30B7\30E7\30F3\30FB\30EC\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279579533699869023)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30A7\30C3\30AF\30B5\30E0\304C\5FC5\8981 - \30E6\30FC\30B6\30FC\30FB\30EC\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279579440613869023)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30A7\30C3\30AF\30B5\30E0\304C\5FC5\8981 - \30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30EC\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280594068568869650)
,p_name=>'CHECK_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\3092\30C1\30A7\30C3\30AF')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279747107181869125)
,p_name=>'CLASSIC_CALENDAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30E9\30B7\30C3\30AF\30FB\30AB\30EC\30F3\30C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279750185066869127)
,p_name=>'CLASSIC_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30E9\30B7\30C3\30AF\30FB\30EC\30DD\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279449417169868945)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30E9\30B7\30C3\30AF\30FB\30EC\30DD\30FC\30C8\306E\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279747710254869125)
,p_name=>'CLASSIC_TREE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30E9\30B7\30C3\30AF\30FB\30C4\30EA\30FC')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279745986613869124)
,p_name=>'CLEAN_UP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306E\30AF\30EA\30FC\30F3\30A2\30C3\30D7')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279283397314868840)
,p_name=>'CLEAR_COMMAND'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30DE\30F3\30C9\306E\30AF\30EA\30A2')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279755800677869130)
,p_name=>'CLOSED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30ED\30FC\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279803465182869159)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\904E\53BB7\65E5\9593\306B\30AF\30ED\30FC\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279569155007869017)
,p_name=>'CLOSE_WINDOW'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A6\30A3\30F3\30C9\30A6\3092\9589\3058\308B')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280687606351869707)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'ja'
,p_message_text=>unistr('\9589\3058\308B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280689342612869708)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280687532622869707)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\7D22')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280689273113869708)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\3092\691C\7D22')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280689107553869708)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'ja'
,p_message_text=>unistr('\524D\3092\691C\7D22')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280688930053869708)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AA\30FC\30C8\30B3\30F3\30D7\30EA\30FC\30C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280688202954869708)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A4\30F3\30C7\30F3\30C8\30FB\30B5\30A4\30BA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280688435697869708)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30D6\633F\5165\9818\57DF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280687820038869707)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5927/\5C0F\6587\5B57\306E\533A\5225')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280687789718869707)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B63\898F\8868\73FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280692725862869711)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AF\30A8\30EA\30FC\30FB\30D3\30EB\30C0\30FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280689425507869708)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'ja'
,p_message_text=>unistr('\3084\308A\76F4\3057')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280689046619869708)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'ja'
,p_message_text=>unistr('\7F6E\63DB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280687357025869707)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\7F6E\63DB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280687458642869707)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\7F6E\63DB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280689791831869709)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30AD\30C3\30D7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280688705647869708)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A2D\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280688071860869708)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'ja'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280688582919869708)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\884C\756A\53F7\306E\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280687909266869708)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EB\30FC\30E9\30FC\306E\8868\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280688393954869708)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30BF\30D6\30FB\30B5\30A4\30BA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280688145048869708)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30FC\30DE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280689595993869709)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'ja'
,p_message_text=>unistr('\5143\306B\623B\3059')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280688616021869708)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30EC\30FC\30F3\30FB\30C6\30AD\30B9\30C8\30FB\30A8\30C7\30A3\30BF\306E\4F7F\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280688807612869708)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\8A3C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280689689537869709)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\691C\8A3C\6210\529F')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279686013235869088)
,p_name=>'COLLAPSE'
,p_message_language=>'ja'
,p_message_text=>unistr('\9589\3058\308B')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279296608981868849)
,p_name=>'COLOR_PALETTE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30E9\30FC\30FB\30D1\30EC\30C3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279522421035868989)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30CA\30ED\30B8\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279522030987868988)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_language=>'ja'
,p_message_text=>unistr('\88DC\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279522666576868989)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_language=>'ja'
,p_message_text=>unistr('\88DC\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279522576669868989)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E2\30CE\30C8\30FC\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279522171609868989)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_language=>'ja'
,p_message_text=>unistr('\96A3\63A5\88DC\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279522316256868989)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C6\30C8\30E9\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279522236405868989)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C8\30E9\30A4\30A2\30FC\30C9')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280142913780869368)
,p_name=>'COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280579076210869641)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\540D: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279678319393869083)
,p_name=>'COLUMN_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\540D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279884019235869209)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3059\3079\3066\306E\8A8D\8A3C\6E08\30E6\30FC\30B6\30FC\304C\3001\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\30A2\30AF\30BB\30B9\3067\304D\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279884100608869209)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306E\30A2\30AF\30BB\30B9\5236\5FA1\30EA\30B9\30C8\306B\5B9A\7FA9\3055\308C\305F\30E6\30FC\30B6\30FC\306E\307F\304C\3001\3053\306E\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\30A2\30AF\30BB\30B9\3067\304D\307E\3059')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279884211361869209)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E88\671F\3057\306A\3044\30A2\30AF\30BB\30B9\5236\5FA1\8A2D\5B9A\5024: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279290066357868845)
,p_name=>'COMING_SOON'
,p_message_language=>'ja'
,p_message_text=>unistr('\3057\3070\3089\304F\304A\5F85\3061\304F\3060\3055\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279678851596869084)
,p_name=>'COMMENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30E1\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279816378571869167)
,p_name=>'COMMENTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30E1\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279570388264869018)
,p_name=>'COMPILE_FAILURE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30D1\30A4\30EB\306F\5931\6557\3057\307E\3057\305F\3002\884C<a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279900330799869220)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30D1\30A4\30EB\306F\5931\6557\3057\307E\3057\305F\3002\884C%0 (%2) \30B3\30F3\30D1\30A4\30EB\30FB\30A8\30E9\30FC\306B\95A2\9023\4ED8\3051\3089\308C\305F\884C\756A\53F7\306F\3001\6700\521D\306EBEGIN\6587\306B\5BFE\3059\308B\756A\53F7\3067\3059\3002\3053\308C\306F\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30C8\30EA\30AC\30FC\306E\30B3\30F3\30D1\30A4\30EB\306B\306E\307F\5F71\97FF\3057\307E\3059\3002<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279570267534869018)
,p_name=>'COMPILE_SUCCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('PL/SQL\30B3\30FC\30C9\306F\6B63\5E38\306B\30B3\30F3\30D1\30A4\30EB\3055\308C\307E\3057\305F(%0)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279753134986869129)
,p_name=>'COMPLETE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B8C\4E86')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279760559471869133)
,p_name=>'COMPLETED'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B8C\4E86')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279767568917869137)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B8C\4E86/\554F\984C\306A\3057')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279804056153869160)
,p_name=>'COMPONENT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279960825059869257)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\540D: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280232101712869425)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\6709\52B9\3067\306F\3042\308A\307E\305B\3093')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279408661410868920)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306F\6B63\5E38\306B\4F5C\6210\3055\308C\307E\3057\305F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280574302710869638)
,p_name=>'COMPONENT_SUMMARY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B3\30F3\30DD\30FC\30CD\30F3\30C8\30FB\30B5\30DE\30EA\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279351800310868884)
,p_name=>'COMPUTATIONS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A08\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279827524889869174)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\30FB\30B3\30F3\30DD\30FC\30CD\30F3\30C8\304C\6B63\5E38\306B\30A4\30F3\30B9\30C8\30FC\30EB\3055\308C\307E\3057\305F\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279570915494869018)
,p_name=>'CONDITIONAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\6761\4EF6\4ED8\304D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279660886051869073)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DD\30C3\30D7\30A2\30C3\30D7LOV')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279744671387869123)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5E38\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279480603736868964)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279480157885868963)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0/\5217=\5024')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279480286882868963)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0/\5217\306FNULL\3067\306F\306A\3044')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280446207708869559)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0/\5217\306FNULL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279480707134868964)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_language=>'ja'
,p_message_text=>unistr('\306A\3057')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279480859641868964)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_language=>'ja'
,p_message_text=>unistr('\306A\3057')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279480483446868963)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B58\5728\3059\308B\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279480538230868963)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B58\5728\3057\306A\3044\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279480098370868963)
,p_name=>'CONDITIONS_SHORTCUT_PLSQL'
,p_message_language=>'ja'
,p_message_text=>'PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279480341088868963)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30AF\30A8\30B9\30C8=\5F0F1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279491903596868970)
,p_name=>'CONDITION_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6761\4EF6\30BF\30A4\30D7')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279706032150869100)
,p_name=>'CONFIRM'
,p_message_language=>'ja'
,p_message_text=>unistr('\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279256346355868823)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('2\30DA\30FC\30B8\306E\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279256281605868823)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('3\30DA\30FC\30B8\306E\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279466683804868955)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\5B9F\969B\306E\540D\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279752309455869128)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\5225\306E\96C6\8A08')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279752494890869128)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F7F\7528\3059\308B\96C6\8A08\95A2\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279464033050868954)
,p_name=>'CONFIRM.APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279477476600868962)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5225\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279477580425868962)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\8A00\8A9E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279477354419868962)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\540D\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279358507910868888)
,p_name=>'CONFIRM.ARRAY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\5BFE\8C61\306E\7D50\679C\30C4\30EA\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279358677190868888)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EC\30DD\30FC\30C8\5BFE\8C61\306E\7D50\679C\30D1\30E9\30E1\30FC\30BF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279477660199868962)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A8D\8A3C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279944033541869247)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306B\30D6\30E9\30F3\30C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279668286763869077)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30FC\30AF\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279466434895868955)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\30DC\30BF\30F3\30FB\30D6\30E9\30F3\30C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279466310422868955)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\30DC\30BF\30F3\8868\793A\30C6\30AD\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279270006382868832)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\306E\8FFD\52A0\3092\6709\52B9\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279269921719868832)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C9\30E9\30C3\30B0\30FB\30A2\30F3\30C9\30FB\30C9\30ED\30C3\30D7\306E\6709\52B9\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279886459824869211)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30E9\30F3\30C1\306E\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279943804221869247)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\300C\53D6\6D88\300D\30DC\30BF\30F3\30FB\30E9\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279934322237869241)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5927/\5C0F\6587\5B57\533A\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279568641537869017)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_language=>'ja'
,p_message_text=>unistr('\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\554F\5408\305B\306E\5909\66F4\3092\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\554F\5408\305B\304B\3089\5217\3092\524A\9664\3057\305F\5834\5408\3001\65E2\5B58\306E\30D5\30A3\30EB\30BF\3001\30CF\30A4\30E9\30A4\30C8\898F\5247\3001\304A\3088\3073\305D\306E\5217\3092\53C2\7167\3059\308B\4ED6\306E\30EC\30DD\30FC\30C8\8A2D\5B9A\306F\7121\52B9\306B\306A\308A\307E\3059\3002\30EA\30AF\30A8\30B9\30C8\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279467524862868956)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\8EF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279816659209869167)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A4\30E4\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279816765867869167)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C0\30A4\30E4\30EB(\30B9\30A4\30FC\30D7)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279468266669868956)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6A2A\68D2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279468403901868956)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6298\308C\7DDA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279467779685868956)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_language=>'ja'
,p_message_text=>unistr('\6570\5024\30DE\30B9\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279468347944868956)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_language=>'ja'
,p_message_text=>unistr('\5186')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279467426062868956)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\554F\5408\305B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279467645309868956)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30B9\30B1\30FC\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279468506754868956)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_language=>'ja'
,p_message_text=>unistr('\6563\5E03')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279468001530868956)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30B5\30A4\30BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279467919211868956)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30C8\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279467832447868956)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C1\30E3\30FC\30C8\30FB\30BF\30A4\30D7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279468113266868956)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\7E26\68D2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279358778448868888)
,p_name=>'CONFIRM.COLLECTION'
,p_message_language=>'ja'
,p_message_text=>unistr('\4E00\6642\7D50\679C\30BB\30C3\30C8\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279464873938868954)
,p_name=>'CONFIRM.COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279668009984869077)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\30D8\30C3\30C0\30FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279843952874869184)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279886656619869211)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279477103708868961)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\30D8\30C3\30C0\30FC\30FB\30BD\30FC\30C8\3092\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279583867464869026)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\30B3\30D4\30FC\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279475729364868961)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30DA\30FC\30B8\3092\30B3\30D4\30FC\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279465372344868954)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_language=>'ja'
,p_message_text=>unistr('\65B0\898F\30BF\30D6\30FB\30BB\30C3\30C8\300C%0\300D\304C\3053\306E\30DA\30FC\30B8\3067\4F5C\6210\304A\3088\3073\4F7F\7528\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279477246945868961)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279469805230868957)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30AB\30EC\30F3\30C0\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279473034538868959)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30C9\30EA\30EB\30C0\30A6\30F3\30FB\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279532772323868995)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\5BFE\8A71\30E2\30FC\30C9\30FB\30EC\30DD\30FC\30C8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279476093116868961)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279263637268868828)
,p_name=>'CONFIRM.CREATE_FLASH_CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064Flash\30C1\30E3\30FC\30C8\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280549933498869623)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\884C\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\65E2\5B58\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3068\540C\3058ID\3092\4F7F\7528\3057\3066\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\65E2\5B58\306E\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304C\524A\9664\3055\308C\305F\5F8C\3001\65B0\3057\3044\30C7\30FC\30BF\30D9\30FC\30B9\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\7F6E\304D\63DB\3048\3089\308C\307E\3059\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279840794495869182)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30D5\30A9\30FC\30E0\3068\30EA\30B9\30C8\30FB\30D3\30E5\30FC\306E\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279752016388869128)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_language=>'ja'
,p_message_text=>unistr('\5206\6790\30DA\30FC\30B8\3092\6301\3064\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\304A\3088\3073\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279469458817868957)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064SQL\554F\5408\305B\306E\30D5\30A9\30FC\30E0\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279469337045868957)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30B9\30C8\30A2\30C9\30FB\30D7\30ED\30B7\30FC\30B8\30E3\306E\30D5\30A9\30FC\30E0\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279469290334868957)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\8868\30DA\30FC\30B8\306E\30D5\30A9\30FC\30E0\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279314741324868860)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B5\30FC\30D3\30B9\53C2\7167\30DA\30FC\30B8\3067\6B21\306E\5C5E\6027\3092\6301\3064\30D5\30A9\30FC\30E0\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002   \9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279371571825868896)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_language=>'ja'
,p_message_text=>unistr('Web\30B5\30FC\30D3\30B9\53C2\7167\30DA\30FC\30B8\3067\6B21\306E\5C5E\6027\3092\6301\3064\30D5\30A9\30FC\30E0\304A\3088\3073\30EC\30DD\30FC\30C8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002   \9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279781321687869146)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30DE\30C3\30D7\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279253727772868822)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002 \9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279471088738868958)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30EA\30FC\30B8\30E7\30F3\304A\3088\3073\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30AA\30D7\30B7\30E7\30F3\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279759302458869132)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_language=>'ja'
,p_message_text=>unistr('\4F5C\6210\30E2\30FC\30C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279469022009868957)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280625450859869669)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280625549862869669)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\540D\306E\4F5C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279471831428868958)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30D5\30A9\30FC\30E0\3068\30EC\30DD\30FC\30C8\306E\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280545822646869620)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279475842215868961)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30EC\30DD\30FC\30C8\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279469566033868957)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064HTML\68D2\30B0\30E9\30D5\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279475481764868960)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30B5\30DE\30EA\30FC\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\4ED6\306E\30DA\30FC\30B8\307E\305F\306F\30EA\30FC\30B8\30E7\30F3(\3042\308B\3044\306F\305D\306E\4E21\65B9)\304B\3089\30A2\30A4\30C6\30E0\3092\8FFD\52A0\3059\308B\306B\306F\3001\300C\8FFD\52A0\300D\30DC\30BF\30F3\3092\30AF\30EA\30C3\30AF\3057\3066\304F\3060\3055\3044\3002\30B5\30DE\30EA\30FC\30FB\30A2\30A4\30C6\30E0\3092\4F5C\6210\3059\308B\306B\306F\3001\300C\7D42\4E86\300D\3092\30AF\30EA\30C3\30AF\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279469607977868957)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064SVG\30C1\30E3\30FC\30C8\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279468963178868957)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\8868\5F62\5F0F\306E\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279470184734868957)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30C4\30EA\30FC\30FB\30DA\30FC\30B8\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279469189712868957)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_language=>'ja'
,p_message_text=>unistr('\6B21\306E\5C5E\6027\3092\6301\3064\30A6\30A3\30B6\30FC\30C9\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280549574656869622)
,p_name=>'CONFIRM.CREATE_WS_APP_TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\73FE\884C\306E\30EF\30FC\30AF\30B9\30DA\30FC\30B9\306E\65E2\5B58\306EWeb\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3068\540C\3058ID\3092\4F7F\7528\3057\3066Web\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\3092\4F5C\6210\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\65E2\5B58\306EWeb\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\304C\524A\9664\3055\308C\305F\5F8C\3001\65B0\3057\3044Web\30B7\30FC\30C8\30FB\30A2\30D7\30EA\30B1\30FC\30B7\30E7\30F3\306B\7F6E\304D\63DB\3048\3089\308C\307E\3059\3002\9078\629E\5185\5BB9\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279663829783869075)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30F3\30AF\30FB\30E9\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280482544371869581)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30FC\30BF\30FB\30ED\30FC\30C9\5B9A\7FA9\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280557197353869627)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_language=>'ja'
,p_message_text=>unistr('\3053\306E\30C7\30FC\30BF\30FB\30ED\30FC\30C9\5B9A\7FA9\306F\3001\65E2\5B58\306E\8868\53C2\7167\3068\30C8\30E9\30F3\30B9\30D5\30A9\30FC\30E1\30FC\30B7\30E7\30F3\30FB\30EB\30FC\30EB\3092\4F7F\7528\3057\3066\4F5C\6210\3055\308C\307E\3059\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279934420758869241)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\756A\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279469919861868957)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\65E5\4ED8\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279759487550869133)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30D5\30A9\30EB\30C8\306E\8A8D\8A3C\30B9\30AD\30FC\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279468811191868956)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\524A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279473770356868959)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_language=>'ja'
,p_message_text=>unistr('%0\8868\793A\5217\306E\8A73\7D30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279256705800868824)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30A3\30C6\30FC\30EB\8868\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279475342287868960)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\30D6\30EC\30C3\30C9\30AF\30E9\30E0\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279474580293868960)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30A3\30C6\30FC\30EB\8868%0\306E\4E26\66FF\3048\57FA\6E96')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279473213808868959)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\30DA\30FC\30B8%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279256663226868823)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30C7\30A3\30C6\30FC\30EB\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279473566029868959)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\8868\540D%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279473317908868959)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\8A73\7D30\30BF\30D6\30FB\30E9\30D9\30EB%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279886918276869211)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30C3\30D7\30ED\30FC\30C9\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279466926247868955)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279843632545869184)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30C3\30D7\30ED\30FC\30C9\52172')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279843778251869184)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30C3\30D7\30ED\30FC\30C9\52173')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279471239869868958)
,p_name=>'CONFIRM.DISPLAY_POINT'
,p_message_language=>'ja'
,p_message_text=>unistr('\8868\793A\30DD\30A4\30F3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280634352069869674)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280634408400869674)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\540D\306E\7DE8\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279656728759869070)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_language=>'ja'
,p_message_text=>unistr('CSV\51FA\529B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279657425893869071)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D7\30EA\30F3\30C8\51FA\529B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279658015258869071)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_language=>'ja'
,p_message_text=>unistr('\5217\30D8\30C3\30C0\30FC\30FB\30BD\30FC\30C8\306E\6709\52B9\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279707903009869101)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30EA\30FC\30B8\30E7\30F3\304C\65E2\5B58\306E\7BA1\7406\30DA\30FC\30B8\306B\8FFD\52A0\3055\308C\307E\3059:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279886566321869211)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30E9\30F3\30C1\306E\5B8C\4E86')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279472381731868959)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279472498829868959)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279472659333868959)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\306E\30BF\30D6\30FB\30E9\30D9\30EB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279472500358868959)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30DA\30FC\30B8\306E\30BF\30D6\30FB\30BB\30C3\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279759567755869133)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_language=>'ja'
,p_message_text=>unistr('\5171\6709\30B3\30F3\30DD\30FC\30CD\30F3\30C8\306E\30A4\30F3\30DD\30FC\30C8\5143')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280217022151869415)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30B9\30BF\30E0\30FB\30AB\30EC\30F3\30C0\3092\542B\3081\308B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279256940090868824)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30EC\30DD\30FC\30C8\3092\542B\3081\307E\3059\304B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279475097181868960)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\3092\542B\3080')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279466100733868955)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\60C5\5831\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279466205945868955)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\60C5\5831\306E\30C7\30D5\30A9\30EB\30C8\30FB\30C6\30AD\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279314952420868860)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279358912272868888)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30EA\30FC\30B8\30E7\30F3\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279358836708868888)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D5\30A9\30FC\30E0\30FB\30EA\30FC\30B8\30E7\30F3\30FB\30BF\30A4\30C8\30EB')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279468669307868956)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_language=>'ja'
,p_message_text=>unistr('\633F\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279465951688868955)
,p_name=>'CONFIRM.ITEMS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30A2\30A4\30C6\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279886816147869211)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\623B\308A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279885732580869211)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_language=>'ja'
,p_message_text=>unistr('\53C2\7167\30AD\30FC\52171')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279885866582869211)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AD\30FC\52172')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279885988125869211)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AD\30FC\52173')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279470090067868957)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_language=>'ja'
,p_message_text=>unistr('\30E9\30D9\30EB\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279843865253869184)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_language=>'ja'
,p_message_text=>unistr('\53C2\7167\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279886778687869211)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\53C2\7167\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279257045182868824)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30C7\30A3\30C6\30FC\30EB\30FB\30EC\30A4\30A2\30A6\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279256558913868823)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\8868\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279256878946868824)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\30FB\30EC\30B3\30FC\30C9\306E\30CA\30D3\30B2\30FC\30C8\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279256453704868823)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DE\30B9\30BF\30FC\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279668193458869077)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_language=>'ja'
,p_message_text=>unistr('\6700\5927\5217\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279663635086869075)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_language=>'ja'
,p_message_text=>unistr('\30DA\30FC\30B8\3054\3068\306E\884C\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279541487357869000)
,p_name=>'CONFIRM.MENU'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279471531976868958)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30EA\30F3\30AF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279475165938868960)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30EB\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279471316332868958)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30C6\30F3\30D7\30EC\30FC\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279471695453868958)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_language=>'ja'
,p_message_text=>unistr('\30D6\30EC\30C3\30C9\30AF\30E9\30E0\30FB\30C6\30AD\30B9\30C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279389268977868907)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6'
,p_message_language=>'ja'
,p_message_text=>unistr('Flash\30C1\30E3\30FC\30C8\3092\65B0\3057\3044Flash\30C1\30E3\30FC\30C8\306B\30A2\30C3\30D7\30B0\30EC\30FC\30C9\3059\308B\3088\3046\306B\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\30EA\30AF\30A8\30B9\30C8\3092\78BA\8A8D\3057\3066\304F\3060\3055\3044\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279753268828869129)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6_XML'
,p_message_language=>'ja'
,p_message_text=>unistr('\30AB\30B9\30BF\30E0XML\306B\57FA\3065\3044\3066Flash\30C1\30E3\30FC\30C8\3092\65B0\3057\3044Flash6\30C1\30E3\30FC\30C8\306B\30A2\30C3\30D7\30B0\30EC\30FC\30C9\3059\308B\3088\3046\30EA\30AF\30A8\30B9\30C8\3057\307E\3057\305F\3002\73FE\5728\306EFlash\30C1\30E3\30FC\30C8\3068Flash6\30C1\30E3\30FC\30C8\306E\9593\3067XML\69CB\9020\306B\76F8\9055\304C\3042\308B\305F\3081\3001\30A2\30C3\30D7\30B0\30EC\30FC\30C9\3057\305F\30C1\3