prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4419
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4419 - Oracle APEX  System Messages and Native Types
--
-- Application Export:
--   Application:     4419
--   Name:            Oracle APEX  System Messages and Native Types
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             124
--       Globalization:
--         Messages:          14,593
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX  System Messages and Native Types')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286626296430927252')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135328'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'ko'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(91645213681389498.4419)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141230'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562090986404402217.4419)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48650898565635010.4419)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AC\C778\C544\C6C3')
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>unistr('Application Express\C5D0\C11C \C0AC\C778\C544\C6C3')
,p_list_text_09=>'Y'
,p_list_text_10=>unistr('\B85C\ADF8\C544\C6C3 \C885\B8CC \B05D\B0B4\AE30 :q')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(281916990329150760.4419)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C2A4\D504\B808\B4DC\C2DC\D2B8\C5D0\C11C \C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131')
,p_list_item_link_target=>'f?p=4000:447:&APP_SESSION.::NO:448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT::'
,p_list_text_01=>unistr('Excel \B610\B294 CSV \D30C\C77C \C784\D3EC\D2B8 \BC0F \C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131')
,p_list_text_09=>'Y'
,p_list_text_10=>unistr('Excel CSV XSL XSLS \C2A4\D504\B808\B4DC\C2DC\D2B8 \B370\C774\D130 \BD99\C5EC\B123\AE30 \B85C\B4DC \C784\D3EC\D2B8')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(282255839842182292.4419)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Oracle APEX \D648')
,p_list_item_link_target=>'f?p=4500:1000:&APP_SESSION.'
,p_list_text_10=>unistr('\D648 \D398\C774\C9C0 \C2DC\C791 ')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(296033420364984683.4419)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\AE00\AF34 APEX \C544\C774\CF58 \CC3E\C544\BCF4\AE30')
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>unistr('\AE00\AF34 APEX \C544\C774\CF58\C744 \CC3E\C544\BCF4\ACE0, \C218\C815\C790\B97C \CD94\AC00\D558\ACE0, \D544\C694\D55C CSS \B610\B294 HTML\C744 \BCF5\C0AC\D569\B2C8\B2E4.')
,p_list_text_09=>'Y'
,p_list_text_10=>unistr('\C544\C774\CF58 \AE00\AF34 APEX \B77C\C774\BE0C\B7EC\B9AC \ADF8\B798\D53D')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562091518091404815.4419)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562091727563404815.4419)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C775\C2A4\D3EC\D2B8')
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>unistr('{APP_ID} \C560\D50C\B9AC\CF00\C774\C158\C744 SQL \D30C\C77C\B85C \C775\C2A4\D3EC\D2B8')
,p_list_text_09=>'Y'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562093357853428158.4419)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C0AC\C6A9\B418\C9C0 \C54A\C740 \BAA9\B85D')
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562092153904409717.4419)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48392393581618193.4419)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\CF58\C194 \B85C\ADF8')
,p_list_item_link_target=>'javascript:console.log(''hello friend'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14843831009863117.4419)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859012524941040.4419)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(86380554411225400.4419)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91997339122572414.4419)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(460407779408652225.4419)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(497671453666914719.4419)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attribute_01=>'fa-star'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082458703597614427.4419)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082517678315623391.4419)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072678475712055.4419)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831649180083980462.4419)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780276458994154.4419)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1832884277947217587.4419)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1840861033969283097.4419)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917665913120940054.4419)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1990227023531717243.4419)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626406749381989.4419)
,p_theme_id=>1
,p_name=>'One Level Tabs.ko'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE# ',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626529080381989.4419)
,p_theme_id=>1
,p_name=>'Printer Friendly.ko'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(91626823864381990.4419)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(91632832228382001.4419)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(91636711305382010.4419)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(91638400927382012.4419)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(91638400927382012.4419)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(91641225667382016.4419)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641730492382017.4419)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641814330382017.4419)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(91642503902382024.4419)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>unistr('\AC80\C0C9 \B300\D654\C0C1\C790')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>unistr('\AC80\C0C9')
,p_close_button_text=>unistr('\B2EB\AE30')
,p_next_button_text=>unistr('\B2E4\C74C >')
,p_prev_button_text=>unistr('< \C774\C804')
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>unistr('<br /><div style="padding:2px; font-size:8pt;">#FIRST_ROW# - #LAST_ROW# \D589</div>')
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91641910982382018.4419)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642102481382020.4419)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642303533382020.4419)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280713007752869864)
,p_name=>'2DCOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('2D \C138\B85C \B9C9\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280715397972869865)
,p_name=>'2DCOLUMN_LINE'
,p_message_language=>'ko'
,p_message_text=>unistr('2D \C138\B85C \B9C9\B300 \C120')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280713213974869864)
,p_name=>'2DDOUGHNUT'
,p_message_language=>'ko'
,p_message_text=>unistr('2D \B3C4\B11B')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280715190380869865)
,p_name=>'2DHSTACKED_PCT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B204\C801 \C218\D3C9 2D \C138\B85C \B9C9\B300(\D37C\C13C\D2B8)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280713327360869864)
,p_name=>'2DLINE'
,p_message_language=>'ko'
,p_message_text=>unistr('2D \C120')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280713468410869864)
,p_name=>'2DPIE'
,p_message_language=>'ko'
,p_message_text=>unistr('2D \D30C\C774')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280714998004869865)
,p_name=>'2DSTACKED_PCT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B204\C801 2D \C138\B85C \B9C9\B300(\D37C\C13C\D2B8)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280713504470869864)
,p_name=>'3DCOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('3D \C138\B85C \B9C9\B300')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280715240110869865)
,p_name=>'3DHSTACKED_PCT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B204\C801 \C218\D3C9 3D \C138\B85C \B9C9\B300(\D37C\C13C\D2B8)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280713635042869864)
,p_name=>'3DPIE'
,p_message_language=>'ko'
,p_message_text=>unistr('3D \D30C\C774')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280715048017869865)
,p_name=>'3DSTACKED_PCT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B204\C801 3D \C138\B85C \B9C9\B300(\D37C\C13C\D2B8)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281610937479870447)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC\C5D0 \C0BD\C785\D560 0\AC1C \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281610774498870446)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B370\C774\D2B8\D560 0\AC1C \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281611152941870447)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC\C758 \C5C5\B370\C774\D2B8\B97C \C704\D55C 0\AC1C \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281611599490870447)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC\C5D0 \C0BD\C785\D560 0\AC1C \BCF4\ACE0\C11C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281611769050870447)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC\C758 \C5C5\B370\C774\D2B8\B97C \C704\D55C 0\AC1C \BCF4\ACE0\C11C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281610609742870446)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B370\C774\D2B8\D560 %0\AC1C \D56D\BAA9 \AC80\D1A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281611342549870447)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B370\C774\D2B8\D560 0\AC1C \BCF4\ACE0\C11C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281610873330870446)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC\C5D0 \C0BD\C785\D560 %0\AC1C \D56D\BAA9 \AC80\D1A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281611099426870447)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC\C758 \C5C5\B370\C774\D2B8\B97C \C704\D55C %0\AC1C \D56D\BAA9 \AC80\D1A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281611429827870447)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC\C5D0 \C0BD\C785\D560 %0\AC1C \BCF4\ACE0\C11C \C5F4 \AC80\D1A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281611209490870447)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B370\C774\D2B8\D560 %0\AC1C \BCF4\ACE0\C11C \C5F4 \AC80\D1A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281611612583870447)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC\C758 \C5C5\B370\C774\D2B8\B97C \C704\D55C %0\AC1C \BCF4\ACE0\C11C \C5F4 \AC80\D1A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281301456724870244)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12\C740 \C22B\C790\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281285934571870234)
,p_name=>'4000_639_SEQ_MESG'
,p_message_language=>'ko'
,p_message_text=>unistr('<span class="fielddata"> \C601\C5ED \C21C\C11C\AC00 \ACE0\C720\D558\C9C0 \C54A\C544 \C7AC\C815\B82C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281286045716870234)
,p_name=>'4000_641_SEQ_MESG'
,p_message_language=>'ko'
,p_message_text=>unistr('<span class="fielddata">\B2E8\CD94 \C21C\C11C\AC00 \ACE0\C720\D558\C9C0 \C54A\C544 \C7AC\C815\B82C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281286174963870234)
,p_name=>'4000_646_SEQ_MESG'
,p_message_language=>'ko'
,p_message_text=>unistr('<span class="fielddata">\D0D0\C0C9\D45C\C2DC\C904 \C21C\C11C\AC00 \ACE0\C720\D558\C9C0 \C54A\C544 \C7AC\C815\B82C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281286288440870234)
,p_name=>'4000_749_SEQ_MESG'
,p_message_language=>'ko'
,p_message_text=>unistr('<span class="fielddata">\C601\C5ED \D56D\BAA9 \C21C\C11C\AC00 \ACE0\C720\D558\C9C0 \C54A\C544 \C7AC\C815\B82C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281365825161870287)
,p_name=>'4000_APPLICATION_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280857583251869951)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D3B8\C9D1: %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281257560585870215)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\B41C \B0A0\C9DC \D615\C2DD\C774 \BD80\C801\D569\D569\B2C8\B2E4. \B2EC\B825\C5D0\B294 YYYYMMDD \D615\C2DD\C758 \B0A0\C9DC\AC00 \D544\C694\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281306620217870247)
,p_name=>'4000_TREE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D2B8\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281365991635870287)
,p_name=>'4000_WORKSPACE_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED ID')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281138604225870138)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C0DD\C131\D560 \C0C8 \C2A4\D0A4\B9C8 \C774\B984\C744 \C785\B825\D558\C2ED\C2DC\C624. '),
unistr('         \C2A4\D0A4\B9C8 \BE44\BC00\BC88\D638\B97C \C120\D0DD\D558\ACE0, \AE30\BCF8 \D14C\C774\BE14\C2A4\D398\C774\C2A4'),
unistr('         \BC0F \C784\C2DC \D14C\C774\BE14\C2A4\D398\C774\C2A4\B97C \C120\D0DD\D558\C2ED\C2DC\C624.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281138724497870138)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\C874 \C2A4\D0A4\B9C8 \C774\B984\C744 \C785\B825\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281138821955870138)
,p_name=>'4050_106_WHEN_DONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C644\B8CC\B418\BA74 "\B2E4\C74C &gt;" \B2E8\CD94\B97C \B204\B974\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281031865085870064)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14\C2A4\D398\C774\C2A4 \BC0F \C5F0\AD00\B41C \B370\C774\D130 \D30C\C77C \C0AD\C81C: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281031771586870064)
,p_name=>'4050_110_DROP_USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C0AC\C6A9\C790 \C0AD\C81C: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281944436517870649)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C11C\BE44\C2A4 \C791\C5C5 \B85C\ADF8 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281132077452870134)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\BC1C\C790 \C791\C5C5 \B85C\ADF8 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280750694297869887)
,p_name=>'4050_31_LOG_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\ADF8\C778 \C561\C138\C2A4 \B85C\ADF8 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281131590368870133)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\ACBD \C694\CCAD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281131632731870133)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D589 \C694\CCAD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281131389457870133)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \C694\CCAD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281134025120870135)
,p_name=>'4050_46_AD_HOC'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \BA85\B839 \CC98\B9AC\AE30 \B0B4\C5ED \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281133962466870135)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \D30C\C77C \C2E4\D589 \B85C\ADF8 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281133836232870135)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\D06C\B9BD\D2B8 \D30C\C77C \C2E4\D589 \B85C\ADF8 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281134136584870135)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C544\CE74\C774\BE0C \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281136126834870136)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\D65C\C131 \B85C\ADF8 \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281136251634870137)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \B85C\ADF8 \BC88\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281136378056870137)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \B85C\ADF8 \C2DC\AC04\AE30\B85D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281136954330870137)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \B85C\ADF8 \C804\D658 \AC04\ACA9(\C2DC)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281136574019870137)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0A0\C9DC \AC04\ACA9(\C0C1\C218)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281136870678870137)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C73C\B85C \C77C\C815\C774 \C7A1\D78C \B85C\ADF8 \C804\D658')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281137220360870137)
,p_name=>'4050_70_DEV_ACT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\BC1C\C790 \C791\C5C5 \B85C\ADF8 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281137450005870137)
,p_name=>'4050_71_CLICK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \D074\B9AD \B85C\ADF8 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281138290459870138)
,p_name=>'4050_75_AD_HOC'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \BA85\B839 \CC98\B9AC\AE30 \B0B4\C5ED \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281138176117870138)
,p_name=>'4050_75_CTRL_FILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \D30C\C77C \C2E4\D589 \B85C\ADF8 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281137983167870138)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\D06C\B9BD\D2B8 \D30C\C77C \C2E4\D589 \B85C\ADF8 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281138371764870138)
,p_name=>'4050_75_SQL_ARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C544\CE74\C774\BE0C \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281138457525870138)
,p_name=>'4050_82_WORKSPACE'
,p_message_language=>'ko'
,p_message_text=>unistr('%1 \C791\C5C5\C601\C5ED\C5D0 %2\AC1C\C758 \C560\D50C\B9AC\CF00\C774\C158\ACFC %3\BA85\C758 \C0AC\C6A9\C790\AC00 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281138561332870138)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D074\B9AD \C218 \B85C\ADF8 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281336675219870266)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C0B0\C131 \BC0F \C0D8\D50C \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281336784391870266)
,p_name=>'4050_PACKAGED_WEBSHEETS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0D8\D50C \C6F9 \C2DC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281335950635870266)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \C218')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280876226689869962)
,p_name=>'4150_COLUMN_NUMBER'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C5F4')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281059993141870084)
,p_name=>'4350_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281060099039870084)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D3B8\C9D1')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280765773763869896)
,p_name=>'4500 800 HD DBA'
,p_message_language=>'ko'
,p_message_text=>'Oracle Database Express Edition 2 Day DBA'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280765834545869896)
,p_name=>'4500 800 HD DEV'
,p_message_language=>'ko'
,p_message_text=>'Oracle Database Express Edition 2 Day Developer Guide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280765685157869896)
,p_name=>'4500 800 HD HTMLDB'
,p_message_language=>'ko'
,p_message_text=>'Oracle Application Express 2 Day Plus Developer Guide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280765941539869896)
,p_name=>'4500 800 HD JAVA'
,p_message_language=>'ko'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus Java Developer Guide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280766029250869896)
,p_name=>'4500 800 HD NET'
,p_message_language=>'ko'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus .NET Developer Guide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280766171102869896)
,p_name=>'4500 800 HD PHP'
,p_message_language=>'ko'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus PHP Developer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280766272331869896)
,p_name=>'4500 800 MSG DBA'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\BC18\C801\C778 \C77C\C77C \AD00\B9AC \C791\C5C5\C5D0 \B300\D574 \C124\BA85\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280766336774869896)
,p_name=>'4500 800 MSG DEV'
,p_message_language=>'ko'
,p_message_text=>unistr('Oracle Database Express Edition \AC1C\BC1C \D658\ACBD\C744 \D65C\C6A9\D558\B294 \BC29\BC95\C5D0 \B300\D574 \C124\BA85\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280766495047869896)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C911\C2EC\C758 \C6F9 \C560\D50C\B9AC\CF00\C774\C158\C744 \C0DD\C131\D558\B294 \BC29\BC95\C5D0 \B300\D574 \C124\BA85\D558\B294 \C790\C2B5\C11C \ACC4\C5F4\C744 \C81C\ACF5\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280766637871869896)
,p_name=>'4500 800 MSG JAVA'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BB38\C11C\B294 Java \BC0F JDBC\B97C \C0AC\C6A9\D558\C5EC Oracle Database XE\C5D0 \C811\C18D\D558\B294 \BC29\BC95, \AC04\B2E8\D55C Java \C560\D50C\B9AC\CF00\C774\C158\C744 \AC1C\BC1C\D558\C5EC \B370\C774\D130\C5D0 \C561\C138\C2A4\D558\ACE0 \C218\C815\D558\B294  \BC29\BC95\C744 \BCF4\C5EC\C8FC\B294 \C790\C2B5\C11C\B97C \C81C\ACF5\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280766712601869896)
,p_name=>'4500 800 MSG NET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BB38\C11C\B294 Oracle Data Provider for .NET \BC0F Oracle Developer Tools for Visual Studio .NET\C758 \C8FC\C694 \AE30\B2A5\C744 \C124\BA85\D569\B2C8\B2E4. \B2E8\ACC4\BCC4\B85C \C124\CE58 \BC0F \AD6C\C131 \ACFC\C815\C744 \C548\B0B4\D558\ACE0, Oracle Data Provider for .NET \BC0F Oracle Developer Tools for Visual Studio .NET\C744 \C0AC\C6A9\D558\C5EC \AE30\BCF8 \C560\D50C\B9AC\CF00\C774\C158\C744 \C0DD\C131\D558\B294 \BC29\BC95, PL/SQL \BC0F .NET \B0B4\C7A5 \D504\B85C\C2DC\C800\B97C \C791')
||unistr('\C131\D558\ACE0 \C0AC\C6A9\D558\B294 \BC29\BC95\C744 \BCF4\C5EC\C90D\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280766584255869896)
,p_name=>'4500 800 MSG PHP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BB38\C11C\B294 Apache \BC0F Zend Core PHP \B4DC\B77C\C774\BC84\B97C \B2E4\C6B4\B85C\B4DC\D558\ACE0 \C124\CE58\D558\B294 \BC29\BC95, \C124\CE58\D55C PHP\B97C \C0AC\C6A9\D558\C5EC Oracle Database XE\C5D0 \C811\C18D\D558\B294 \BC29\BC95, PHP\B85C \AC04\B2E8\D55C \C560\D50C\B9AC\CF00\C774\C158\C744 \AC1C\BC1C\D558\C5EC \B370\C774\D130\C5D0 \C561\C138\C2A4\D558\ACE0 \C218\C815\D558\B294 \BC29\BC95\C744 \BCF4\C5EC\C8FC\B294 \C790\C2B5\C11C\B97C \C81C\ACF5\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280736486739869878)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC4\CE6D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280736358520869878)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280736662212869878)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\AC74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281195336802870176)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280737020738869879)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D568\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280737186589869879)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280736579945869878)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1D\CCB4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280736918315869878)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280736784897869878)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280736853770869878)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C \C21C\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280740271254869880)
,p_name=>'4500_1002_QB_JOIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\C778')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280733744339869877)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\C778\D560 \C5F4\C744 \C120\D0DD\D558\B824\BA74 \C5EC\AE30\B97C \B204\B974\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280740632753869881)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300 60\AC1C\C758 \C5F4\C744 \C120\D0DD\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280733668133869876)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280733535679869876)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \D45C\C2DC/\C228\AE30\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280740365268869880)
,p_name=>'4500_1002_QB_TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280731996148869875)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_language=>'ko'
,p_message_text=>unistr('%1\C5D0 \C2E4\D589\B41C %0\C758 \ACB0\ACFC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281032078174870065)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6D0\B798 \C9C8\C758\B85C \B3CC\C544\AC00\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280747952703869885)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC98\C74C %0\AC1C\C758 \C5F4\C774 \D45C\C2DC\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281225064919870195)
,p_name=>'4500_SESS_EVENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281224900626870195)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_language=>'ko'
,p_message_text=>'KB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281224899101870195)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_language=>'ko'
,p_message_text=>'MB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280769657527869898)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30\C5D0\C11C \C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \AE30\BCF8\AC12\C744 \C0AC\C6A9\D558\C5EC \B2E8\C77C \C560\D50C\B9AC\CF00\C774\C158\C774\B098 \B2E4\C911 \C560\D50C\B9AC\CF00\C774\C158\C758 \B2E4\C911 \D398\C774\C9C0 \AC04\C5D0 \C77C\AD00\C131\C744 \C81C\ACF5\D558\B294 \C601\C5ED \BC0F \D56D\BAA9 \C18D\C131\C5D0 \B300\D55C \CD08\AE30\AC12\C744 \CC44\C6C1\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280814084684869925)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C744 \C0AC\C6A9\D558\B824\BA74 \CFE0\D0A4\AC00 \C0AC\C6A9\C73C\B85C \C124\C815\B418\C5B4 \C788\C5B4\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280813984558869925)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C744 \C0AC\C6A9\D558\B824\BA74 JavaScript\AC00 \C0AC\C6A9\C73C\B85C \C124\C815\B418\C5B4 \C788\C5B4\C57C \D569\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281005664596870046)
,p_name=>'4800_9015_UPDATE_OVERDUE_FEATURES'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \AE30\D55C\C774 \C9C0\B09C \AE30\B2A5\C774 \C120\D0DD\D55C \C0C8\B85C\C6B4 \B9C8\C77C\C2A4\D1A4\C73C\B85C \C5C5\B370\C774\D2B8\B429\B2C8\B2E4.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281255801249870214)
,p_name=>'ABOUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282016663931870693)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\BA85\C758 \C0AC\C6A9\C790\B97C \C791\C5C5\C601\C5ED\C5D0 \CD94\AC00\D560\C9C0 \D655\C778\D558\C2ED\C2DC\C624.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281268260444870222)
,p_name=>'ACCEPTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2B9\C778\B428')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281234689773870201)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C811\ADFC\C131 \D53C\C9C0\C815\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281232716297870200)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C811\ADFC\C131 \C601\D5A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281235111912870201)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C811\ADFC\C131 \C0C1\D0DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282095769554870741)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C811\ADFC\C131 \D14C\C2A4\D2B8\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280746707869869884)
,p_name=>'ACCESS_CONTROL_ADMIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280906115494869980)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC \AD8C\D55C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280745281035869883)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \AD00\B9AC \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281183844901870168)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281294925387870239)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\C5D0\AC8C \C9C0\C815\B41C \B864\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280745476934869884)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280746080296869884)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BAA8\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280745983758869884)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \C561\C138\C2A4 \C81C\C5B4 \BC29\C2DD\C744 \C9C0\C815\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280747265942869885)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BAA8\B4DC \C124\C815 \C694\CCAD\C744 \CC98\B9AC\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280747310669869885)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BAA8\B4DC \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280907054583869981)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF8\C778\C740 \C2A4\C2A4\B85C \C0AD\C81C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280907101837869981)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\C2A4\B85C \AD00\B9AC\C790 \AD8C\D55C\C744 \C81C\AC70\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280745386333869883)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281183773406870168)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\ACF5 \AD8C\D55C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281183930156870169)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\ACF5\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281295048233870239)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C81C\ACF5\C790\C5D0\AC8C \C9C0\C815\B41C \B864\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281227456575870196)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C560\D50C\B9AC\CF00\C774\C158 \C124\C815\C774 \C0DD\C131\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281184023642870169)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C560\D50C\B9AC\CF00\C774\C158 \C561\C138\C2A4 \B864\C774 \C0DD\C131\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280762846549869894)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \AD8C\D55C \BD80\C5EC \CCB4\ACC4\AC00 \C0DD\C131\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280836591733869938)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \D398\C774\C9C0\B97C \C791\C131\D560 \C218 \C5C6\C2B5\B2C8\B2E4. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280836478198869938)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \D14C\C774\BE14\C744 \C0DD\C131\D560 \C218 \C5C6\C2B5\B2C8\B2E4. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280909602152869982)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\BCF5\B41C \C0AC\C6A9\C790 \C774\B984\C744 \C785\B825\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280906296574869980)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 - \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280746950177869884)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C8\C758 \C870\AC74(\B300\C18C\BB38\C790 \AD6C\BD84 \C548\D568)\C744 \C785\B825\D55C \B2E4\C74C <b>\C2E4\D589</b> \B2E8\CD94\B97C \B204\B974\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280747030079869884)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC \BAA8\B4DC\B97C \AC00\C838\C62C \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280746845862869884)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C9C0\B9C9\C73C\B85C \BCC0\ACBD\D55C \C0AC\B78C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280746355668869884)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280745527910869884)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450\C5D0\AC8C \C804\CCB4 \C561\C138\C2A4. \C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C774 \C0AC\C6A9\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280745651971869884)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\D55C\B41C \C561\C138\C2A4. \C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0\C11C \C815\C758\B41C \C0AC\C6A9\C790\B9CC \D5C8\C6A9\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280745760693869884)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACF5\C6A9 \C77D\AE30 \C804\C6A9. \C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0 \C758\D574 \D3B8\C9D1 \BC0F \AD00\B9AC \AD8C\D55C\C774 \C81C\C5B4\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280745859682869884)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC \C561\C138\C2A4 \C804\C6A9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280747103848869885)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\B3C4\D55C \C791\C5C5\C5D0 \B300\D55C \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280746626583869884)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD8C\D55C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281227318074870196)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\D68C\C790 \AD8C\D55C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281227203072870196)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\D68C\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281295199759870240)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C870\D68C\C790\C5D0\AC8C \C9C0\C815\B41C \B864\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280763665888869894)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C758 \C778\C99D \CCB4\ACC4\C5D0 \D574\B2F9\D558\B294 \C0AC\C6A9\C790 \C774\B984\C744 \C9C0\C815\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280746187793869884)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BAA8\B4DC \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280864651626869955)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \D398\C774\C9C0\AC00 \C131\ACF5\C801\C73C\B85C \C791\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280746529524869884)
,p_name=>'ACCESS_CONTROL_USERNAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281184116582870169)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\C874 \C561\C138\C2A4 \C81C\C5B4 \B864 \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280763539162869894)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\C874 \AD8C\D55C \BD80\C5EC \CCB4\ACC4 \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280762713360869894)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\C874 \D14C\C774\BE14 \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280906377310869980)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 - \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281196085848870176)
,p_name=>'ACCESS_DENIED_SIMPLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4\AC00 \AC70\BD80\B418\C5C8\C2B5\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280767024098869896)
,p_name=>'ACCOUNT_CREATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C815\C774 \C0DD\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280889912540869970)
,p_name=>'ACCOUNT_HAS_BEEN_CREATED'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \ACC4\C815\C774 \C0DD\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280764498967869895)
,p_name=>'ACCOUNT_LOCKED'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C815\C774 \C7A0\ACBC\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281557045755870414)
,p_name=>'ACCOUNT_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C815 \BA54\B274')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281214590618870188)
,p_name=>'ACKNOWLEDGED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D655\C778\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281214762051870188)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C2DD\B428, \C791\C5C5 \C5C6\C74C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281278698849870229)
,p_name=>'ACL_ADD_USER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281947203496870651)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C2DC\BCF4\B4DC \C561\C138\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281947315107870651)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B2C8\D130 \C791\C5C5 \C561\C138\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281946486067870650)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00/\C218\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281947151535870651)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C2E4\D589 \C2DC \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281945623245870650)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30 \B0B4\C5D0\C11C \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281946305993870650)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC\C11D(\D30C\C77C, \D0DC\ADF8, \BA54\BAA8)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281945396813870650)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C744 \C0AC\C6A9\D558\C9C0 \C54A\B294 Application Express \ACC4\C815 \C778\C99D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281945271357870650)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C744 \C0AC\C6A9\D55C \C778\C99D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281946097349870650)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C561\C138\C2A4 \BC0F \AD8C\C7A5 \AC1D\CCB4 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281950309175870653)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C5D0 \C778\C99D\B41C \B2E4\C74C\C5D0\B294 \C561\C138\C2A4 \C81C\C5B4\C5D0 \B530\B77C \C0AC\C6A9\C790\AC00 \C560\D50C\B9AC\CF00\C774\C158 \B0B4\C5D0\C11C \C218\D589\D560 \C218 \C788\B294 \C791\C5C5\C774 \C9C0\C815\B429\B2C8\B2E4. \C544\B798 \D45C\C5D0\C11C\B294 \C774 \C560\D50C\B9AC\CF00\C774\C158 \B0B4\C5D0\C11C \C0AC\C6A9\B418\B294 \C778\C99D\C744 \AE30\BC18\C73C\B85C \C11C\B85C \B2E4\B978 \C0AC\C6A9\C790 \C720\D615\C5D0 \B530\B77C \C9C0\C815\B420 \AE30\B2A5\C744 \C2DD\BCC4\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281947477433870651)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D \C720\C9C0 \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281946153956870650)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D589 \BC0F \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281945895309870650)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C18D\C131 \C5C5\B370\C774\D2B8')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281605504522870443)
,p_name=>'ACTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281944749657870649)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \BA54\B274 \C124\C815')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280778156052869903)
,p_name=>'ACTIVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D65C\C131:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281191680936870173)
,p_name=>'ACTIVITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281236158752870202)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \C694\C57D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281471656790870361)
,p_name=>'ADDED_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281942275163870648)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\C6B0\AE30 \BAA9\B85D\C5D0 \CD94\AC00\B428')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281591272478870435)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00 \C815\BCF4\AC00 \C694\CCAD\B428')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281145854366870143)
,p_name=>'ADD_ARGUEMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C218 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281135926280870136)
,p_name=>'ADD_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281352170251870277)
,p_name=>'ADD_COLUMN_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C5F4 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280993913187870038)
,p_name=>'ADD_CONSTRAINT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C57D \C870\AC74 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281133753235870135)
,p_name=>'ADD_MORE...'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281206568372870183)
,p_name=>'ADD_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281359698397870282)
,p_name=>'ADD_USER_INTERFACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \CD94\AC00')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281363225753870284)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0MB\C529 \B4F1\B85D\B41C \ACF5\AC04 \C870\C815')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281132252355870134)
,p_name=>'ADMIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280758421195869891)
,p_name=>'ADMINISTRATOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \AD00\B9AC\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281235919987870202)
,p_name=>'ADMINISTRATORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281139524780870139)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC\C790 \C804\C790\BA54\C77C\C744 \C81C\ACF5\D574\C57C \D569\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281303656218870245)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C811\ADFC\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280794097927869913)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280794359385869913)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C131\B2A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280794436922869913)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_language=>'ko'
,p_message_text=>unistr('\D488\C9C8 \BCF4\C99D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280794120258869913)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\C548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280794564276869913)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9 \AC00\B2A5 \C5EC\BD80')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280794270176869913)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACBD\ACE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281436995100870338)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_language=>'ko'
,p_message_text=>unistr('"%1" \D56D\BAA9\C774 \BCF4\D638\B418\C5B4 \C788\C5B4\C11C Ajax \D638\CD9C\C744 \D1B5\D574 \C124\C815\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281437029423870338)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('"%1" \D56D\BAA9\C774 \BCF4\D638\B418\C5B4 \C788\C5B4\C11C Ajax \D638\CD9C\C744 \D1B5\D574 \C124\C815\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281468939262870359)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_language=>'ko'
,p_message_text=>unistr('"%1" \D56D\BAA9\C774 \BCF4\D638\B418\C5B4 \C788\C5B4\C11C Ajax \D638\CD9C\C744 \D1B5\D574 \C124\C815\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280824860365869931)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_language=>'ko'
,p_message_text=>unistr('\B204\B77D\B41C SYS \C2A4\D0A4\B9C8 \C811\B450\C5B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281646846113870468)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_language=>'ko'
,p_message_text=>unistr('WWV_FLOW API \C0AC\C6A9\BC95(\B300\C2E0 APEX API \C0AC\C6A9)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281586952051870432)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED \C18C\C2A4 SQL \BB38\C5D0 %0 \C5F4\C774 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280804344598869919)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \BCF4\ACE0\C11C \C5F4 %0\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280802066940869917)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280770409508869898)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED \C18C\C2A4 SQL \BB38\C5D0 %0 \C5F4\C774 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281681420355870489)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C \D615\C2DD \D3EC\B7FC \C5F4 %0\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280802137620869917)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C740(\B294) \C560\D50C\B9AC\CF00\C774\C158 \B610\B294 \D398\C774\C9C0 \D56D\BAA9 \C774\B984\C73C\B85C \CC38\C870\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282022693701870697)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_language=>'ko'
,p_message_text=>unistr('Ajax \CF5C\BC31 \C560\D50C\B9AC\CF00\C774\C158 \D504\B85C\C138\C2A4\B294 \AD8C\D55C \BD80\C5EC \CCB4\ACC4\C5D0 \C758\D574 \BCF4\D638\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282022286890870696)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\AC00 \AD8C\D55C \BD80\C5EC \CCB4\ACC4\C5D0 \C758\D574 \BCF4\D638\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280803005889869918)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1 \D398\C774\C9C0 %1(\C560\D50C\B9AC\CF00\C774\C158 %0 \B0B4\BD80)\C5D0 \C815\C758\B41C \AD8C\D55C \BD80\C5EC \CCB4\ACC4\AC00 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282024363038870698)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0\C758 \AD8C\D55C \BD80\C5EC\AC00 \C0C1\C704 \D398\C774\C9C0 %0\C758 \AD8C\D55C \BD80\C5EC "%1"\ACFC(\C640) \B2E4\B985\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280803166732869918)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1 \D398\C774\C9C0\C758 \AD8C\D55C \BD80\C5EC "%0"\C774(\AC00) "%1"\ACFC(\C640) \B2E4\B985\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280801677811869917)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280801576008869917)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\C778\B4DC \BCC0\C218 \AD6C\BB38 \AC80\C0AC\B97C \C218\D589\D560 \C218 \C5C6\C2B5\B2C8\B2E4. \C624\B958: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280801778052869917)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C740(\B294) \BC14\C778\B4DC \BCC0\C218 \AD6C\BB38\C73C\B85C \CC38\C870\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280803702353869918)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\B978 \BD84\AE30 \C774\C804\C758 \BB34\C870\AC74 \BD84\AE30\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282022099806870696)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C790\B3D9 \C644\C131\C740 \BE44\BC00\BC88\D638 \D56D\BAA9\C744 \D3EC\D568\D558\B294 \D398\C774\C9C0\C5D0 \B300\D574 "\C124\C815"\C73C\B85C \C124\C815\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282022167383870696)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_language=>'ko'
,p_message_text=>unistr('"\CE90\C2DC"\B97C \C0AC\C6A9\D558\BA74 \BE0C\B77C\C6B0\C800\AC00 \BBFC\AC10\D55C \B370\C774\D130\B97C \CE90\C2DC\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281907006084870627)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_language=>'ko'
,p_message_text=>unistr('"\D504\B808\C784\C5D0 \D3EC\D568"\C744 \C0AC\C6A9\D558\BA74 \C560\D50C\B9AC\CF00\C774\C158\C774 \D074\B9AD \AC00\B85C\CC44\AE30(clickjacking) \ACF5\ACA9\C5D0 \CDE8\C57D\D574\C9D1\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281907190589870627)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_language=>'ko'
,p_message_text=>unistr('"HTML \C774\C2A4\CF00\C774\D504 \BAA8\B4DC"\C5D0\C11C\B294 \C81C\D55C\B41C \BB38\C790\C138\D2B8\B9CC \C774\C2A4\CF00\C774\D504 \CC98\B9AC\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280728298308869873)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\B3D9\C801 \C791\C5C5(%0)\C5D0 \CC38\C870\B41C \B2E8\CD94\C5D0 \B300\D55C \B2E8\CD94 \C18D\C131\C5D0\C11C ID\AC00 \BC1C\ACAC\B418\C5C8\C2B5\B2C8\B2E4. '),
'',
unistr('\B2E8\CD94 \C18D\C131\C5D0 ID\AC00 \C815\C758\B41C \ACBD\C6B0, \C774 \B2E8\CD94\B97C \CC38\C870\D558\B294 \B3D9\C801 \C791\C5C5\C774 \C791\B3D9\D558\C9C0 \C54A\AC8C \B429\B2C8\B2E4. \B2E8\CD94\B294 \AE30\BCF8\C801\C73C\B85C ID\B97C \C0DD\C131\D558\BBC0\B85C \C774 ID\B97C \C81C\AC70\D558\C2ED\C2DC\C624.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280728328454869873)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\B2E8\CD94\C5D0 \C0AC\C6A9\B418\BA70 \B3D9\C791 \C791\C5C5(%0)\C5D0 \CC38\C870\B418\B294 \B2E8\CD94 \D15C\D50C\B9AC\D2B8\C5D0 #BUTTON_ID# \B300\CCB4 \BB38\C790\C5F4\C774 \D3EC\D568\B418\C5B4 \C788\C9C0 \C54A\C2B5\B2C8\B2E4.'),
'',
unistr('\D15C\D50C\B9AC\D2B8:'),
'%1',
'',
unistr('#BUTTON_ID# \B300\CCB4 \BB38\C790\C5F4\C744 \C774 \D15C\D50C\B9AC\D2B8\C5D0 \CD94\AC00\D558\AC70\B098, \B2E8\CD94 \D15C\D50C\B9AC\D2B8\B97C #BUTTON_ID# \B300\CCB4 \BB38\C790\C5F4\C744 \D3EC\D568\D558\B294 \D15C\D50C\B9AC\D2B8\B85C \BCC0\ACBD\D558\C2ED\C2DC\C624.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280730937586869875)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3D9\C801 \C791\C5C5(%0)\C5D0 \CC38\C870\B41C \B2E8\CD94\C5D0 \B300\D55C \B2E8\CD94 ''\C791\C5C5''\C774 ''\B3D9\C801 \C791\C5C5\C5D0 \C758\D574 \C815\C758\B428''\C774 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280737617012869879)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94(%0) ''\C791\C5C5''\C774 ''\B3D9\C801 \C791\C5C5\C5D0 \C758\D574 \C815\C758\B428''\C73C\B85C \C124\C815\B418\C5C8\C9C0\B9CC \C774 \B2E8\CD94\B97C \CC38\C870\D558\B294 \D574\B2F9''\B3D9\C801 \C791\C5C5\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281305118587870246)
,p_name=>'ADVISOR.CHECK.CHART_TYPE_IS_ACCESSIBLE.MSG_ANYCHART_CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804 AnyChart \CC28\D2B8 \C720\D615\C785\B2C8\B2E4. \AC00\C6A9\C131 \BC0F \C811\ADFC\C131 \D5A5\C0C1\C744 \C704\D574\C11C\B294 ''\C560\D50C\B9AC\CF00\C774\C158 \C5C5\ADF8\B808\C774\B4DC'' \AE30\B2A5\C744 \D1B5\D574 \C774 \CC28\D2B8\B97C \C774\C804\D558\C5EC \C0C8 Oracle JET \AE30\BC18 \CC28\D2B8\B97C \C0AC\C6A9\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280802726371869918)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE90\C2DC \BE44\C6B0\AE30 \D398\C774\C9C0 %0\C774(\AC00) \D604\C7AC \B610\B294 \B300\C0C1 \D398\C774\C9C0 %1\C774(\AC00) \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280801452386869917)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281994206149870680)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C18D\C131\AC12\C740 \B354 \C774\C0C1 \C0AC\C6A9\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281995763654870680)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \AD6C\C131\C694\C18C \C720\D615\C740 \B354 \C774\C0C1 \C0AC\C6A9\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281437187492870338)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_language=>'ko'
,p_message_text=>unistr('Ajax \D638\CD9C\C5D0\C11C \BCF4\D638\B41C \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280824718271869931)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_language=>'ko'
,p_message_text=>unistr('Code Smell(APEX \B0B4\BD80)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280799535662869916)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D56D\BAA9, \D398\C774\C9C0 \D56D\BAA9, \C5F4 \B610\B294 \B300\D654\C2DD \BCF4\ACE0\C11C \D544\D130\C758 \C120\C5B8\C801 \CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282021947903870696)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD8C\D55C \BD80\C5EC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280799233697869916)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\C778\B4DC \BCC0\C218 \AD6C\BB38\C73C\B85C \CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280800626739869917)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\B978 \BD84\AE30 \C774\C804\C758 \BB34\C870\AC74 \BD84\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282022463159870697)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE0C\B77C\C6B0\C800 \BCF4\C548 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280728115690869873)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3D9\C791 \C791\C5C5\ACFC \D638\D658\B418\C9C0 \C54A\B294 \B2E8\CD94\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280737429920869879)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3D9\C791 \C791\C5C5\ACFC \B2E8\CD94 \AC04\C758 \CC38\C870\AC00 \C77C\CE58\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281304971014870246)
,p_name=>'ADVISOR.CHECK.DESC_CHART_TYPE_IS_ACCESSIBLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \C720\D615\C5D0\C11C \C811\ADFC\C131 \C9C0\C6D0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280799834890869916)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE90\C2DC \BE44\C6B0\AE30 \D398\C774\C9C0 \BC88\D638\AC00 \B300\C0C1 \B610\B294 \D604\C7AC \D398\C774\C9C0\C640 \B3D9\C77C\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280799189151869916)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \AD6C\BB38\C73C\B85C \CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281994150237870679)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\B418\C9C0 \C54A\B294 \C18D\C131\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280800127313869916)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\CD9C, DML, MR* \D504\B85C\C138\C2A4\AC00 \C801\D569\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280800564497869917)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\D558\B4DC \CF54\B529\B41C \C560\D50C\B9AC\CF00\C774\C158 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281211169294870186)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D56D\BAA9\C5D0 \B3C4\C6C0\B9D0 \D14D\C2A4\D2B8\AC00 \C788\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281303446004870245)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\C5D0 \D398\C774\C9C0 \C81C\BAA9 \D3EC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281329586441870262)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BBF8\C9C0 \D45C\C2DC \D56D\BAA9\C5D0 \C774\BBF8\C9C0 ALT \D14D\C2A4\D2B8\AC00 \C815\C758\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281906809526870626)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C7A0\AE00 \C218 \C788\B294 \C560\D50C\B9AC\CF00\C774\C158 \C18D\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280799391016869916)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC38\C870\B41C \D56D\BAA9\C774 \D604\C7AC \D398\C774\C9C0\C5D0 \C788\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280799415271869916)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC38\C870\B41C \D56D\BAA9\C774 \B300\C0C1 \D398\C774\C9C0\C758 \D398\C774\C9C0 \D56D\BAA9\C784')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281304194644870245)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D56D\BAA9\C73C\B85C \C778\D574 \C608\C0C1\CE58 \C54A\C740 \CEE8\D14D\C2A4\D2B8 \BCC0\ACBD\C0AC\D56D\C774 \BC1C\C0DD\D558\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281305304947870246)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D56D\BAA9\C5D0 \B808\C774\BE14 \D3EC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280800852982869917)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\BAA9 \B610\B294 \D45C \D615\C2DD \D3FC \C5F4 \C774\B984\C758 \AE38\C774')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280799672610869916)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C790\C5F4\C758 \D398\C774\C9C0 \D56D\BAA9 \CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280799759511869916)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC38\C870\B41C \D398\C774\C9C0 \BC88\D638\AC00 \C874\C7AC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281303712186870245)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED\C5D0 \D589 \BA38\B9AC\AE00 \D3EC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280801033740869917)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\C5D0 \AE30\BCF8 \C21C\C11C\AC00 \C801\C6A9\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282022565603870697)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158 \C0C1\D0DC \BCF4\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280800275203869916)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\CCB4 \AD6C\BB38\C758 \BD80\C801\D569\D55C \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280799001518869916)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\CCB4 \AD6C\BB38\C73C\B85C \CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280800087524869916)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1 \D398\C774\C9C0 \AD8C\D55C \BD80\C5EC\AC00 \D604\C7AC \AD6C\C131\C694\C18C\C5D0 \B300\D574\C11C\B3C4 \C124\C815\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281303947474870245)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8 \C2A4\D0C0\C77C\C758 \C811\ADFC\C131 \D14C\C2A4\D2B8\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281425828087870330)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4\C5D0 \D638\D658\C131 JavaScript\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280800734216869917)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C99D\C758 \C5F0\AD00\B41C \D56D\BAA9 \B610\B294 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280799959624869916)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\D569\D55C SQL \B610\B294 PL/SQL \CF54\B4DC\C784')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280800421614869916)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_language=>'ko'
,p_message_text=>unistr('CLOB \C18D\C131 \D655\C778')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280800395796869916)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \BB38\C5D0 \C0AC\C6A9\B41C V \D568\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280800933281869917)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_language=>'ko'
,p_message_text=>unistr('[\B2E8\CD94\B97C \B204\B97C \B54C]\C5D0 \CC38\C870\B41C \B2E8\CD94\AC00 \C874\C7AC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280803366965869918)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\CEF4\D30C\C77C \C624\B958 - %0 \BB38: %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280803643482869918)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C1\D06C\C5D0 \D604\C7AC \C560\D50C\B9AC\CF00\C774\C158 ID\AC00 \D558\B4DC \CF54\B529\B41C \AC12\C73C\B85C \D3EC\D568\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281211073649870186)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\C758\B41C \B3C4\C6C0\B9D0 \D14D\C2A4\D2B8\AC00 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281303531970870245)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0\C5D0\B294 \D398\C774\C9C0 \C81C\BAA9\C774 \C5C6\C2B5\B2C8\B2E4. \C758\BBF8 \C788\B294 \D398\C774\C9C0 \C81C\BAA9\C740 \C811\ADFC\C131\C5D0 \C911\C694\D558\BA70, \C0AC\C6A9\C790\B294 \D398\C774\C9C0 \C81C\BAA9\C744 \D1B5\D574 \D604\C7AC \D398\C774\C9C0\C758 \CF58\D150\CE20\C640 \C6A9\B3C4\B97C \C27D\AC8C \D30C\C545\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281329657346870262)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BBF8\C9C0\C5D0 \D544\C694\D55C \B300\CCB4 \D14D\C2A4\D2B8\AC00 \D56D\BAA9\C5D0\C11C \B204\B77D\B418\C5C8\C2B5\B2C8\B2E4. \B300\CCB4 \D14D\C2A4\D2B8\C6A9\C73C\B85C \C801\D569\D55C \D14D\C2A4\D2B8\B294 \C774\BBF8\C9C0\C758 \CF58\D150\CE20\B97C \C81C\B300\B85C \C124\BA85\D574\C57C \D558\BA70, \C911\BCF5\C774 \BC1C\C0DD\D558\C9C0 \C54A\B3C4\B85D \C774\BBF8\C9C0 \CEE8\D14D\C2A4\D2B8\C5D0\C11C \D45C\C2DC\B418\B294 \D398\C774\C9C0\C5D0 \BCF4\C774\B294 \C815\BCF4\B97C \BCF5\C81C\D558\C9C0 \C54A\C544\C57C \D569\B2C8\B2E4. \CC38\ACE0: \C0AC\C6A9\C790\AC00 \C774\BBF8\C9C0\B97C \C81C\ACF5\D558\B294 \ACBD\C6B0 \ACE0\D488\C9C8 \D14D\C2A4\D2B8\B97C \C81C\ACF5\D560 \C218 \C788\B3C4\B85D \C801\D569\D55C \C9C0\CE68\ACFC \D568\AED8 \C774\BBF8\C9C0 \B300\CCB4 \D14D\C2A4\D2B8\B3C4 \C81C\ACF5\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281906947542870627)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('"\B7F0\D0C0\C784 API \C0AC\C6A9"\C740 \C560\D50C\B9AC\CF00\C774\C158 \BC0F \C791\C5C5\C601\C5ED \C218\C815\C744 \D5C8\C6A9\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280801865313869917)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C740(\B294) %1 \D398\C774\C9C0\C5D0 \C788\B294 \D56D\BAA9\C774 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280801987176869917)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C740(\B294) \B300\C0C1 \D398\C774\C9C0 %1\C5D0 \C788\B294 \D56D\BAA9\C774 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281304258553870245)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D56D\BAA9\C5D0 \B300\D55C ''\C120\D0DD \C2DC \D398\C774\C9C0 \C791\C5C5'' \C124\C815\C73C\B85C \C778\D574 \C0AC\C6A9\C790\C5D0 \B300\D574 \C608\C0C1\CE58 \C54A\C740 \CEE8\D14D\C2A4\D2B8 \BCC0\ACBD\C0AC\D56D\C774 \BC1C\C0DD\D560 \C218 \C788\C2B5\B2C8\B2E4. \CEE8\D14D\C2A4\D2B8 \BCC0\ACBD\C0AC\D56D\C774 \BC1C\C0DD\D558\C9C0 \C54A\B3C4\B85D \AC12\C744 ''\C5C6\C74C''\C73C\B85C \C804\D658\D558\ACE0 \AE30\B2A5\C744 \B3D9\C801 \C791\C5C5 \B610\B294 \C885\C18D LOV\B85C \BC14\AFB8\B294 \AC83\C774 \C88B\C2B5\B2C8\B2E4(\B3D9\C77C\D55C \D398\C774\C9C0\C5D0 \B0A8\C544 \C788\C5B4\C57C \D558\B294 \ACBD\C6B0). \B610\B294 \C0AC\C6A9\C790\AC00 \BC1C\C0DD\D560 \B3D9\C791\C744 \C778\C2DD\D560 \C218 \C788\B3C4\B85D \C0AC\C6A9\C790\C5D0\AC8C \C815\BCF4\B97C \C81C\ACF5\D558\B294 \AC83\C774 \C88B\C2B5\B2C8\B2E4(\C608: \B808\C774\BE14\C5D0 ''\C0C8 \D398\C774\C9C0 \C2E4\D589'' \CD94\AC00). ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281329484783870262)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\BAA9\C744 \C815\C758\D574\C57C \D560 \B808\C774\BE14\C785\B2C8\B2E4. \D45C\C2DC \AC00\B2A5\D55C \B808\C774\BE14\C774 \B098\D0C0\B098\C9C0 \C54A\B3C4\B85D \D558\B824\B294 \ACBD\C6B0\C5D0\B3C4 \B808\C774\BE14\C744 \C815\C758\D55C \D6C4 \B808\C774\BE14 \D15C\D50C\B9AC\D2B8 ''\C228\AE40''\C744 \C120\D0DD\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281305489054870246)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\BAA9\C774 ''\AC12 \C704\CE58 \D45C\C2DC\C790'' \AC12\C744 \C815\C758\D558\C9C0\B9CC \B808\C774\BE14\C774 \C5C6\C2B5\B2C8\B2E4. \D56D\BAA9 \B808\C774\BE14\C744 \C9C0\C815\D560 \B54C \C704\CE58 \D45C\C2DC\C790 \D14D\C2A4\D2B8\B9CC \C0AC\C6A9\D558\BA74 \C811\ADFC\C131 \BB38\C81C\AC00 \BC1C\C0DD\D558\BBC0\B85C, \C811\ADFC\C131\C744 \D5A5\C0C1\C2DC\D0A4\B824\BA74 \D56D\BAA9 \B808\C774\BE14\C744 \C815\C758\D574\C57C \D569\B2C8\B2E4. \D45C\C2DC \AC00\B2A5\D55C \B808\C774\BE14\C774 \B098\D0C0\B098\C9C0 \C54A\B3C4\B85D \D558\B824\B294 \ACBD\C6B0\C5D0\B3C4 \B808\C774\BE14\C744 \C815\C758\D55C \D6C4 \B808\C774\BE14 \D15C\D50C\B9AC\D2B8 ''\C228\AE40''\C744 \C120\D0DD\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280804050088869919)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B984 \AE38\C774\AC00 %0\C790\C774\C9C0\B9CC \CD5C\B300 30\C790\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280802272493869918)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280802397706869918)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C740(\B294) \D398\C774\C9C0 \B610\B294 \C560\D50C\B9AC\CF00\C774\C158 \D56D\BAA9\C774 \C544\B2D0 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280802616446869918)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE90\C2DC \BE44\C6B0\AE30 \D398\C774\C9C0 %1(\C560\D50C\B9AC\CF00\C774\C158 %0 \B0B4\BD80)\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280802493222869918)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D398\C774\C9C0\AC00 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280802530571869918)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1 \D398\C774\C9C0 %1(\C560\D50C\B9AC\CF00\C774\C158 %0 \B0B4\BD80)\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281227594588870196)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C5F4 \D1A0\AE00 \C601\C5ED\C5D0\B294 ''\D589 \BA38\B9AC\AE00\B85C \C0AC\C6A9''\C774 ''\C608''\B85C \C124\C815\B41C \C5F4\C774 \C5C6\C2B5\B2C8\B2E4. \D589 \BA38\B9AC\AE00 \C5F4\C740 \D604\C7AC \D589\C744 \AC00\C7A5 \C798 \C2DD\BCC4\D558\B294 \C5F4(\C608: \ACE0\AC1D \C815\BCF4 \BCF4\ACE0\C11C\C758 \ACE0\AC1D \C774\B984)\C774\C5B4\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281227644905870196)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C7AC\BC30\CE58 \C601\C5ED\C5D0\B294 ''\D589 \BA38\B9AC\AE00\B85C \C0AC\C6A9''\C774 ''\C608''\B85C \C124\C815\B41C \C5F4\C774 \C5C6\C2B5\B2C8\B2E4. \D589 \BA38\B9AC\AE00 \C5F4\C740 \D604\C7AC \D589\C744 \AC00\C7A5 \C798 \C2DD\BCC4\D558\B294 \C5F4(\C608: \ACE0\AC1D \C815\BCF4 \BCF4\ACE0\C11C\C758 \ACE0\AC1D \C774\B984)\C774\C5B4\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281303845919870245)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D45C \D615\C2DD \D3FC \C601\C5ED\C5D0\B294 "\D589 \BA38\B9AC\AE00\B85C \C0AC\C6A9"\C774 [\C608]\B85C \C124\C815\B41C \C5F4\C774 \C5C6\C2B5\B2C8\B2E4. \D589 \BA38\B9AC\AE00 \C5F4\C740 \D604\C7AC \D589\C744 \AC00\C7A5 \C798 \C2DD\BCC4\D558\B294 \C5F4(\C608: \ACE0\AC1D \C815\BCF4 \D14C\C774\BE14\C758 \ACE0\AC1D \C774\B984)\C774\C5B4\C57C \D569\B2C8\B2E4. \C774 \C815\BCF4\B294 \D45C \D615\C2DD \D3FC\C744 \B80C\B354\B9C1\D560 \B54C \AC01 \D589\C758 \D3FC \D544\B4DC\C5D0 \B300\D55C \ACE0\C720 \B808\C774\BE14\C744 \C81C\ACF5\D558\B294 \B370 \C0AC\C6A9\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280804241793869919)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\C5D0 \AE30\BCF8 \C21C\C11C\AC00 \C5C6\C2B5\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281907232782870627)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_language=>'ko'
,p_message_text=>unistr('"\CC45\AC08\D53C \D574\C2DC \D568\C218"\AC00 \B808\AC70\C2DC \C54C\ACE0\B9AC\C998\C73C\B85C \C124\C815\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281907352858870627)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('"\C138\C158 \C0C1\D0DC \BCF4\D638"\AC00 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282022328328870697)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\CD9C \D504\B85C\C138\C2A4\AC00 \D3EC\D568\B41C \D398\C774\C9C0\C5D0\C11C\B294 \D398\C774\C9C0 \C561\C138\C2A4 \BCF4\D638\B97C \C0AC\C6A9\D558\ACE0 URL\C744 \D1B5\D574 \C804\B2EC\D558\B294 \D56D\BAA9\C5D0 \B300\D574 \BCF4\D638\B97C \C0AC\C6A9\C73C\B85C \C124\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280760994972869893)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED\C5D0 APEX_UTIL.PREPARE_URL\C744 \D1B5\D574 \C804\B2EC\B418\C9C0 \C54A\C740 "f?p" URL\C774 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280803467514869918)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\B2A5\D55C SQL \C0BD\C785\C774 \AC80\C0C9\B418\C5C8\C2B5\B2C8\B2E4. %0\C774(\AC00) SQL, PL/SQL \CF54\B4DC \B610\B294 \D504\B85C\C138\C2A4 \D14C\C774\BE14 \C774\B984\C5D0\C11C \B300\CCB4 \AD6C\BB38\C73C\B85C \C0AC\C6A9\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280801266604869917)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280801321867869917)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C740(\B294) \B300\CCB4 \AD6C\BB38\C73C\B85C \CC38\C870\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280803276802869918)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1 \D398\C774\C9C0 %1(\C560\D50C\B9AC\CF00\C774\C158 %0 \B0B4\BD80)\C5D0 \C815\C758\B41C \AD8C\D55C \BD80\C5EC \CCB4\ACC4\AC00 \C788\C9C0\B9CC \D604\C7AC \AD6C\C131\C694\C18C\C5D0\B294 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281304047027870245)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \D604\C7AC \D14C\B9C8 \C2A4\D0C0\C77C\C758 \C811\ADFC\C131\C774 \D14C\C2A4\D2B8\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4. [\C811\ADFC\C131 \D14C\C2A4\D2B8\B428]\C774 [\C608]\B85C \C124\C815\B41C \D14C\B9C8 \C2A4\D0C0\C77C\B85C \C804\D658\D558\AC70\B098, \D604\C7AC \D14C\B9C8 \C2A4\D0C0\C77C\C774 \D14C\C2A4\D2B8\B41C \ACBD\C6B0 \D14C\B9C8 \C124\C815\C5D0\C11C [\C811\ADFC\C131 \D14C\C2A4\D2B8\B428] \C18D\C131\C744 [\C608]\B85C \C124\C815\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281426095589870330)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4\C5D0 jQuery Migrate\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4. jQuery Migrate\B294 \C81C\AC70\B41C API\B97C \BCF5\C6D0\D558\C5EC \CD5C\C2E0 \BC84\C804\C758 jQuery\B85C \C774\C804\D560 \B54C \C774 \C791\C5C5\C744 \C9C0\C6D0\D558\BA70 \C81C\AC70\B418\AC70\B098 \C0AC\C6A9\B418\C9C0 \C54A\B294 API\AC00 \C0AC\C6A9\B420 \B54C \BE0C\B77C\C6B0\C800 \CF58\C194\C5D0 \ACBD\ACE0\B97C \D45C\C2DC\D569\B2C8\B2E4. \C774\B85C \C778\D574 \C571\C758 \BAA8\B4E0 \D398\C774\C9C0\C5D0 \CD94\AC00 JavaScript \D30C\C77C\C774 \D3EC\D568\B429\B2C8\B2E4. \C774 \AE30\B2A5\C744 \C27D\AC8C \C81C\AC70\D558\B824\BA74 jQuery Migrate \C5C5\ADF8\B808\C774\B4DC \C124\BA85\C11C\C5D0\C11C \BCC0\ACBD\B418\C5B4\C57C \D560 API\C758 \C138\BD80\C815\BCF4\B97C \AC80\D1A0')
||unistr('\D55C \D6C4 \B354 \C774\C0C1 \D574\B2F9 API\B97C \C0AC\C6A9\D560 \D544\C694\AC00 \C5C6\B294 \AC83\C774 \D655\C2E4\D560 \B54C [jQuery Migrate \D3EC\D568]\C744 [\C544\B2C8\C624]\B85C \C124\C815\D558\C2ED\C2DC\C624.'),
'',
'https://github.com/jquery/jquery-migrate'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281425982450870330)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4\C5D0 \C0AC\C6A9\B418\C9C0 \C54A\AC70\B098 \C9C0\C6D0\C774 \C911\B2E8\B41C JavaScript \D568\C218\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4. \C774\B85C \C778\D574 \C571\C758 \BAA8\B4E0 \D398\C774\C9C0\C5D0 \CD94\AC00 JavaScript \D30C\C77C\C774 \D3EC\D568\B429\B2C8\B2E4. \C774 \AE30\B2A5\C744 \C27D\AC8C \C81C\AC70\D558\B824\BA74 \B9B4\B9AC\C2A4 \B178\D2B8\C758 ''\C0AC\C6A9\B418\C9C0 \C54A\B294 \AE30\B2A5'' \C139\C158\C744 \AC80\D1A0\D558\C2ED\C2DC\C624. \C5EC\AE30\C11C \C0AC\C6A9\B418\C9C0 \C54A\AC70\B098 \C9C0\C6D0\C774 \C911\B2E8\B41C \D568\C218\C5D0 \B300\D55C \C885\C18D\C131\C744 \D655\C778\D558\ACE0 \B354 \C774\C0C1 \C571\C5D0 \C774 \D568\C218\B97C \D3EC\D568\D558\C9C0 \C54A\B294 \BC29\BC95\ACFC \AD00\B828\B41C \C9C0\CE68\C744 \D655\C778\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280803969687869919)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F0\AD00\B41C \D56D\BAA9 \B610\B294 \C5F4\C774 \C815\C758\B418\C9C0 \C54A\C558\C9C0\B9CC "\C624\B958 \BA54\C2DC\C9C0 \D45C\C2DC \C704\CE58"\B97C \C0AC\C6A9\D558\B824\BA74 \D544\C694\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280803823602869919)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F0\AD00\B41C \D56D\BAA9 \B610\B294 \C5F4\C774 \AC80\C99D \D45C\D604\C2DD 1\C5D0 \C9C0\C815\B41C "%0"\ACFC(\C640) \B3D9\C77C\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280802868153869918)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\CEF4\D30C\C77C \C624\B958 - %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280802951264869918)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \B610\B294 PL/SQL \CF54\B4DC\AC00 \C815\C758\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280801152475869917)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_language=>'ko'
,p_message_text=>unistr('32767\BCF4\B2E4 \AE41\B2C8\B2E4. \CC98\C74C 32767\AE4C\C9C0\B9CC \D655\C778\B429\B2C8\B2E4. \AE38\C774: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280803532251869918)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \BB38\C5D0 V/NV/DV \D568\C218 \D638\CD9C\C774 \D3EC\D568\B429\B2C8\B2E4(\C131\B2A5 \BB38\C81C\AC00 \B420 \C218 \C788\C74C).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280804127461869919)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC38\C870\B41C \B2E8\CD94\AC00 \B354 \C774\C0C1 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281197685034870177)
,p_name=>'AFTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\D6C4')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281138933106870138)
,p_name=>'AGREEMENT_MISSING'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C57D \B204\B77D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280943808189870003)
,p_name=>'ALIAS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC4\CE6D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281650098718870470)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131 \D5C8\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281566813139870420)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C0DD\C0B0\C131 \BC0F \C0D8\D50C \C560\D50C\B9AC\CF00\C774\C158\C758 \C124\CE58\B97C \D5C8\C6A9\D569\B2C8\B2E4.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281402168677870313)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_language=>'ko'
,p_message_text=>unistr('RESTful \C11C\BE44\C2A4 \C0AC\C6A9 \D5C8\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281650187927870470)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C6CC\D06C\C20D \C0AC\C6A9 \D5C8\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281650361533870470)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D300 \AC1C\BC1C \C0AC\C6A9 \D5C8\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281649937070870470)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \BE44\C6B0\AE30 \D5C8\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281650283096870470)
,p_name=>'ALLOW_WEBSHEET_DEV'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C2DC\D2B8 \AC1C\BC1C \D5C8\C6A9')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280963189001870017)
,p_name=>'ALL_APPLICATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280748901059869886)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_language=>'ko'
,p_message_text=>unistr('- \BAA8\B450 - ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280748704533869885)
,p_name=>'ALL_CATEGORIES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \BC94\C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280749081728869886)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_language=>'ko'
,p_message_text=>unistr('- \BAA8\B4E0 \BC94\C8FC -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281653011021870472)
,p_name=>'ALL_MILESTONES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \B9C8\C77C\C2A4\D1A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281331019473870263)
,p_name=>'ALL_RELEASES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \B9B4\B9AC\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280969065777870021)
,p_name=>'ALL_STATIC_FILES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C815\C801 \D30C\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280967668837870020)
,p_name=>'ALL_THEMES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \D14C\B9C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281674787739870485)
,p_name=>'ALL_TYPES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281675125996870486)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_language=>'ko'
,p_message_text=>unistr('- \BAA8\B4E0 \C720\D615 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280964210401870017)
,p_name=>'ALL_USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C0AC\C6A9\C790')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282016857344870693)
,p_name=>'ALREADY_IN_ACL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\AC00 \C774\BBF8 APEX \ACC4\C815\C744 \AC00\C9C0\ACE0 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282006778445870687)
,p_name=>'ALREADY_IN_WS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\AC00 \C791\C5C5\C601\C5ED\C5D0 \C874\C7AC\D569\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281967441939870663)
,p_name=>'ALWAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\C0C1')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280720421879869868)
,p_name=>'AM_PM'
,p_message_language=>'ko'
,p_message_text=>'AM / PM'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281214328196870188)
,p_name=>'ANALYSIS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \BD84\C11D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281214473885870188)
,p_name=>'ANALYZE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\BCC4 \BD84\C11D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281353365832870277)
,p_name=>'ANALYZE_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \BA54\C18C\B4DC\B97C \C0AC\C6A9\D558\C5EC \BD84\C11D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280822039048869930)
,p_name=>'ANCHOR.SHOW_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \D45C\C2DC')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280966515676870019)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C775\BA85 \BE14\B85D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280808917104869922)
,p_name=>'ANSWERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2F5\BCC0')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280760683015869893)
,p_name=>'ANY_DEVELOPER'
,p_message_language=>'ko'
,p_message_text=>unistr('(\C784\C758\C758 \AC1C\BC1C\C790)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281982579925870672)
,p_name=>'APEX.ACTIONS.TOGGLE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D1A0\AE00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282021770827870696)
,p_name=>'APEX.ACTIVE_STATE'
,p_message_language=>'ko'
,p_message_text=>unistr('(\D65C\C131)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282085308093870735)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BCC0\ACBD\C0AC\D56D:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282085285235870735)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282090092523870738)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_language=>'ko'
,p_message_text=>'%0 K'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282085409746870735)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \BCF4\AE30: ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281607489007870444)
,p_name=>'APEX.AJAX_SERVER_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('Ajax \D638\CD9C\C774 %1\C5D0 \B300\D574 \C11C\BC84 \C624\B958 %0\C744(\B97C) \BC18\D658\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281904806175870625)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('API \D638\CD9C\C774 \AE08\C9C0\B418\C5C8\C2B5\B2C8\B2E4.'),
unistr('\AD00\B9AC\C790\C5D0\AC8C \BB38\C758\D558\C2ED\C2DC\C624.'),
unistr('\C774 \C7A5\C560\C5D0 \B300\D55C \C138\BD80\C815\BCF4\B294 \B514\BC84\ADF8 ID "%0"\C744(\B97C) \D1B5\D574 \D655\C778\D560 \C218 \C788\C2B5\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281011561589870050)
,p_name=>'APEX.APPLICATION.ALIAS.NON_UNIQUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BCC4\CE6D "%0"\C744(\B97C) \ACE0\C720 \C560\D50C\B9AC\CF00\C774\C158 ID\B85C \BCC0\D658\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281011609132870050)
,p_name=>'APEX.APPLICATION.ALIAS.NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC4\CE6D\C774 "%0"\C778 \C560\D50C\B9AC\CF00\C774\C158\C774 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280969293366870021)
,p_name=>'APEX.APPLICATION.ALIAS.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('ERR-1816 \C560\D50C\B9AC\CF00\C774\C158 \BCC4\CE6D p_flow_alias_or_id(%0)\B97C \BCC0\D658\D558\B294 \C911 \C608\C0C1\CE58 \C54A\C740 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280838071722869939)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_language=>'ko'
,p_message_text=>unistr('API \D638\CD9C "%0"\C740(\B294) Application Express \BC84\C804 %1\C5D0\C11C \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4. \C774 \C7A5\C560\C5D0 \B300\D55C \C138\BD80\C815\BCF4\B294 \B514\BC84\ADF8 ID "%2"\C744(\B97C) \D1B5\D574 \C81C\ACF5\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280844760466869943)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNC.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \D568\C218\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280732354118869876)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \D568\C218\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282100169364870744)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.HOST_PREFIX_MISMATCH'
,p_message_language=>'ko'
,p_message_text=>unistr('Oracle Cloud ID \AD00\B9AC\C5D0\C11C \BC18\D658\B41C \D14C\B10C\D2B8 \C774\B984 %0\C5D0 %1 \B3C4\BA54\C778\C5D0 \B300\D55C \AD8C\D55C\C774 \BD80\C5EC\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4.<br/><a href="&LOGOUT_URL.">\B2E4\C2DC \B85C\ADF8\C778</a>\D558\ACE0 \C778\C99D\B41C \D14C\B10C\D2B8 \C774\B984\C744 \C9C0\C815\D558\AC70\B098 URL\C744 \BCC0\ACBD\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280725443468869871)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.USER_IS_NOT_DEVELOPER'
,p_message_language=>'ko'
,p_message_text=>unistr('"%0" \ACC4\C815\C5D0 "%1" \C791\C5C5\C601\C5ED\C5D0 \D544\C694\D55C \AC1C\BC1C \AD8C\D55C(DB_DEVELOPER \B610\B294 DB_ADMINISTRATOR)\C774 \C5C6\C2B5\B2C8\B2E4.<br/> \AD8C\D55C\C774 \C81C\ACF5\B41C \D6C4\C5D0 <a href="&LOGOUT_URL.">\B2E4\C2DC \B85C\ADF8\C778</a>\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280720853776869869)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.WRONG_GROUP_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('Oracle Cloud ID \AD00\B9AC\C5D0\C11C \BC18\D658\B41C \D14C\B10C\D2B8 \C774\B984\C5D0 \D604\C7AC \C791\C5C5\C601\C5ED\C5D0 \B300\D574 \AD8C\D55C\C774 \BD80\C5EC\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4.<br/><a href="&LOGOUT_URL.">\B2E4\C2DC \B85C\ADF8\C778</a>\D558\ACE0 \C778\C99D\B41C \D14C\B10C\D2B8 \C774\B984\C744 \C9C0\C815\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280859018147869952)
,p_name=>'APEX.AUTHENTICATION.HEADER.DUPLICATE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('HTTP \D5E4\B354 %0\C774(\AC00) \B450 \BC88 \C804\C1A1\B418\C5C8\C2B5\B2C8\B2E4. \C774\B294 \ACF5\ACA9\C77C \C218 \C788\C2B5\B2C8\B2E4.'),
'<ul>',
unistr('<li>\CCAB\BC88\C9F8 \AC12: "%1"</li>'),
unistr('<li>\B450\BC88\C9F8 \AC12: "%2"</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280725630569869872)
,p_name=>'APEX.AUTHENTICATION.HOST_PREFIX_MISMATCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\C548\C0C1\C758 \C774\C720\B85C \C774 \C791\C5C5\C601\C5ED\C758 \C560\D50C\B9AC\CF00\C774\C158\C744 URL\C758 \B3C4\BA54\C778\C744 \D1B5\D574 \C2E4\D589\D558\B294 \AC83\C740 \D5C8\C6A9\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280844403798869943)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.ASK_FOR_INSTALLATION'
,p_message_language=>'ko'
,p_message_text=>unistr('DBA\C5D0\AC8C $OH/rdbms/admin/catldap.sql \C2E4\D589\C744 \C694\CCAD\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280844330816869943)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.MISSING'
,p_message_language=>'ko'
,p_message_text=>unistr('SYS.DBMS_LDAP \D328\D0A4\C9C0\AC00 \C874\C7AC\D558\C9C0 \C54A\AC70\B098 \BD80\C801\D569\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280844206805869943)
,p_name=>'APEX.AUTHENTICATION.LDAP.EDIT_USER_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('LDAP \C0AC\C6A9\C790 \D3B8\C9D1 \D568\C218\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280844522458869943)
,p_name=>'APEX.AUTHENTICATION.LDAP.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('LDAP \C778\C99D\C744 \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280845718576869944)
,p_name=>'APEX.AUTHENTICATION.LOGIN.ILLEGAL_PAGE_ARG'
,p_message_language=>'ko'
,p_message_text=>unistr('login_page \D504\B85C\C2DC\C800\C5D0 \B300\D55C p_flow_page \C778\C218\C5D0 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280845234853869943)
,p_name=>'APEX.AUTHENTICATION.LOGIN.INVALID_ARG'
,p_message_language=>'ko'
,p_message_text=>unistr('wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1\C758 p_session\C774 \BD80\C801\D569\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280845084863869943)
,p_name=>'APEX.AUTHENTICATION.LOGIN.MALFORMED_ARGS'
,p_message_language=>'ko'
,p_message_text=>unistr('wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2\C5D0 \B300\D55C \C778\C218 \D615\C2DD\C774 \C798\BABB\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280845436894869944)
,p_name=>'APEX.AUTHENTICATION.LOGIN.NULL_USER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\ADF8\C778 \D504\B85C\C2DC\C800\C5D0 \B110 \C0AC\C6A9\C790 \C774\B984\C774 \C804\B2EC\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280745101093869883)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.COUNTER'
,p_message_language=>'ko'
,p_message_text=>unistr('<span id="apex_login_throttle_sec">%0</span>\CD08 \AE30\B2E4\B838\B2E4\AC00 \B2E4\C2DC \B85C\ADF8\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280750177780869886)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\ADF8\C778 \C2DC\B3C4\AC00 \CC28\B2E8\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281185492741870169)
,p_name=>'APEX.AUTHENTICATION.NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('"%0" \C778\C99D\C744 \CC3E\C744 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280758750072869891)
,p_name=>'APEX.AUTHENTICATION.NO_SECURITY_GROUP_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\C548 \ADF8\B8F9 ID\AC00 \B110\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280844939002869943)
,p_name=>'APEX.AUTHENTICATION.POST_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\D6C4 \C778\C99D \D504\B85C\C138\C2A4\B97C \C2E4\D589\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280844682019869943)
,p_name=>'APEX.AUTHENTICATION.PRE_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C804 \C778\C99D \D504\B85C\C138\C2A4\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280864151908869955)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD.INSTRUCTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\BC00\BC88\D638 \C7AC\C124\C815 \C694\CCAD\C744 \C2DC\C791\D55C \B3D9\C77C \BE0C\B77C\C6B0\C800\C5D0\C11C URL\C744 \C5EC\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282084537984870734)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD_URL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\BC00\BC88\D638 \C7AC\C124\C815 URL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280725809459869872)
,p_name=>'APEX.AUTHENTICATION.RM_GROUP_NOT_GRANTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9AC\C18C\C2A4 \AD00\B9AC\C790 \C18C\BE44\C790 \ADF8\B8F9 %0\C5D0\AC8C %1\C774(\AC00) \BD80\C5EC\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280725913869869872)
,p_name=>'APEX.AUTHENTICATION.RM_INFO_TO_GRANT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B204\B77D\B41C \AD8C\D55C\C744 \BD80\C5EC\D558\B824\BA74 DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP\C744 \C0AC\C6A9\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280921937987869990)
,p_name=>'APEX.AUTHENTICATION.SESSION_SENTRY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158 \AC10\C2DC \D568\C218\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280922001719869990)
,p_name=>'APEX.AUTHENTICATION.SESSION_VERIFY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158 \D655\C778 \D568\C218\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280922227635869990)
,p_name=>'APEX.AUTHENTICATION.SSO.ASK_FOR_INSTALLATION'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \AD00\B9AC\C790\C5D0\AC8C Oracle Application Server Single Sign-On \C5D4\C9C4 \AD6C\C131\C744 \C694\CCAD\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280998375538870041)
,p_name=>'APEX.AUTHENTICATION.SSO.BAD_URLC'
,p_message_language=>'ko'
,p_message_text=>unistr('%1 \D1A0\D070\C758 \C798\BABB\B41C %0\C774(\AC00) SSO\C5D0 \C758\D574 \BC18\D658\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280845621085869944)
,p_name=>'APEX.AUTHENTICATION.SSO.FIX_PARTNER_APP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \CCB4\ACC4\B97C \D3B8\C9D1\D558\ACE0 \C560\D50C\B9AC\CF00\C774\C158 \C774\B984\C744 \CD94\AC00\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280997906581870041)
,p_name=>'APEX.AUTHENTICATION.SSO.ILLEGAL_CALLER'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D504\B85C\C2DC\C800\C758 \C798\BABB\B41C \D638\CD9C\C790:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280998110498870041)
,p_name=>'APEX.AUTHENTICATION.SSO.INVALID_APP_SESSION'
,p_message_language=>'ko'
,p_message_text=>unistr('URLC \D1A0\D070\C5D0 \BD80\C801\D569\D55C \C560\D50C\B9AC\CF00\C774\C158 \C138\C158\C774 \C788\C74C: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280997798983870041)
,p_name=>'APEX.AUTHENTICATION.SSO.MISSING_APP_REGISTRATION'
,p_message_language=>'ko'
,p_message_text=>unistr('portal_sso_redirect\C5D0\C11C \C624\B958 \BC1C\C0DD: \C560\D50C\B9AC\CF00\C774\C158 \B4F1\B85D \C815\BCF4 \B204\B77D: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280922130496869990)
,p_name=>'APEX.AUTHENTICATION.SSO.PACKAGE_MISSING'
,p_message_language=>'ko'
,p_message_text=>unistr('WWSEC_SSO_ENABLER_PRIVATE \D328\D0A4\C9C0\AC00 \C874\C7AC\D558\C9C0 \C54A\AC70\B098 \BD80\C801\D569\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280845593371869944)
,p_name=>'APEX.AUTHENTICATION.SSO.PARTNER_APP_IS_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \CCB4\ACC4\C5D0\C11C \B4F1\B85D\B41C \D611\B825 \C560\D50C\B9AC\CF00\C774\C158 \C774\B984\C744 \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280997856338870041)
,p_name=>'APEX.AUTHENTICATION.SSO.REGISTER_APP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\CE58 \C124\BA85\C11C\C5D0 \C124\BA85\B41C \B300\B85C \C774 \C560\D50C\B9AC\CF00\C774\C158\C744 \B4F1\B85D\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280922367139869990)
,p_name=>'APEX.AUTHENTICATION.SSO.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('SSO \C778\C99D\C744 \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282001389674870684)
,p_name=>'APEX.AUTHENTICATION.UNAUTHORIZED_URL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\B418\C9C0 \C54A\C740 URL: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280921755474869989)
,p_name=>'APEX.AUTHENTICATION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\C744 \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280725729460869872)
,p_name=>'APEX.AUTHENTICATION.WORKSPACE_NOT_ASSIGNED'
,p_message_language=>'ko'
,p_message_text=>unistr('"%0" \C791\C5C5\C601\C5ED\C774 \BE44\D65C\C131 \C0C1\D0DC\C785\B2C8\B2E4. \AD00\B9AC\C790\C5D0\AC8C \BB38\C758\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280726981068869872)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED'
,p_message_language=>'ko'
,p_message_text=>'%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280747662852869885)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BCF4\C548 \AC80\C0AC\C5D0 \C758\D574 \C561\C138\C2A4\AC00 \AC70\BD80\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280747767466869885)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \BCF4\C548 \AC80\C0AC\C5D0 \C758\D574 \C561\C138\C2A4\AC00 \AC70\BD80\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280747853776869885)
,p_name=>'APEX.AUTHORIZATION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD8C\D55C \BD80\C5EC\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281224617353870195)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 \BAA9\B85D\C5D0 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281607097853870444)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84\AE30\B9CC \D45C\C2DC\B294 \D398\C774\C9C0 \C18D\C131 "\C81C\CD9C \C2DC \B2E4\C2DC \B85C\B4DC"\AC00 "\C131\ACF5 \C2DC\C5D0\B9CC"\C73C\B85C \C124\C815\B41C \ACBD\C6B0 \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280972038144870023)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84\AE30\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281292595835870238)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX'
,p_message_language=>'ko'
,p_message_text=>unistr('%1\C744(\B97C) \C0AC\C6A9\D558\C5EC %0(\C73C)\B85C \AD6C\CD95\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281292606104870238)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX.ACCESSIBLE.LOVE'
,p_message_language=>'ko'
,p_message_text=>'love'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281329258788870261)
,p_name=>'APEX.CALCULATOR.ICON_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D31D\C5C5 \ACC4\C0B0\AE30: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281957332851870657)
,p_name=>'APEX.CALENDAR.EVENT_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 \C124\BA85')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281957156180870657)
,p_name=>'APEX.CALENDAR.EVENT_END'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\B8CC \B0A0\C9DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281957410730870657)
,p_name=>'APEX.CALENDAR.EVENT_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 ID')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281957028387870657)
,p_name=>'APEX.CALENDAR.EVENT_START'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C791 \B0A0\C9DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281957212894870657)
,p_name=>'APEX.CALENDAR.EVENT_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 \C81C\BAA9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281425302185870330)
,p_name=>'APEX.CLIPBOARD.COPIED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D074\B9BD\BCF4\B4DC\C5D0 \BCF5\C0AC\B428.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281418316410870325)
,p_name=>'APEX.CLIPBOARD.NOTSUP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BE0C\B77C\C6B0\C800\B294 \B2E8\CD94 \B610\B294 \BA54\B274\B97C \D1B5\D55C \BCF5\C0AC\B97C \C9C0\C6D0\D558\C9C0 \C54A\C2B5\B2C8\B2E4. Ctrl+C \B610\B294 Command+C\B97C \C0AC\C6A9\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281294657394870239)
,p_name=>'APEX.CLOSE_NOTIFICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1B5\C9C0 \B2EB\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280716407186869866)
,p_name=>'APEX.COLOR_PICKER.ICON_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D31D\C5C5 \C0C9\C0C1 \C120\D0DD\AE30: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282070549751870726)
,p_name=>'APEX.COMBOBOX.LIST_OF_VALUES'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12 \BAA9\B85D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282070637642870726)
,p_name=>'APEX.COMBOBOX.SHOW_ALL_VALUES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \BAA9\B85D \C5F4\AE30: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282021891278870696)
,p_name=>'APEX.COMPLETED_STATE'
,p_message_language=>'ko'
,p_message_text=>unistr('(\C644\B8CC\B428)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280727142913869873)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C0B0\C744 \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280949434743870007)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\AC74\C744 \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281012135933870051)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C54C \C218 \C5C6\B294 \C870\AC74 \C720\D615: "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280977353257870026)
,p_name=>'APEX.CONTACT_ADMIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\C5D0\AC8C \BB38\C758\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281059614135870083)
,p_name=>'APEX.CONTACT_ADMIN.DEBUG'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\C5D0\AC8C \C5F0\B77D\D558\C2ED\C2DC\C624.'),
unistr('\C774 \C7A5\C560\C5D0 \B300\D55C \C138\BD80\C815\BCF4\B294 \B514\BC84\ADF8 ID "%0"\C744(\B97C) \D1B5\D574 \C81C\ACF5\B429\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281944373820870649)
,p_name=>'APEX.CORRECT_ERRORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5\D558\AE30 \C804\C5D0 \C624\B958\B97C \C218\C815\D558\C2ED\C2DC\C624.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282026040380870699)
,p_name=>'APEX.CURRENT_PROGRESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \C9C4\D589\B960')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281645305618870467)
,p_name=>'APEX.DATA_HAS_CHANGED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\AC00 \C5C5\B370\C774\D2B8 \D504\B85C\C138\C2A4\B97C \C2DC\C791\D588\C73C\BBC0\B85C \B370\C774\D130\BCA0\C774\C2A4\C5D0 \C788\B294 \B370\C774\D130\C758 \D604\C7AC \BC84\C804\C774 \BCC0\ACBD\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281329115361870261)
,p_name=>'APEX.DATEPICKER.ICON_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D31D\C5C5 \B2EC\B825: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281338224304870267)
,p_name=>'APEX.DATEPICKER_VALUE_GREATER_MAX_DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 \C9C0\C815\B41C \CD5C\B300 \B0A0\C9DC %0\BCF4\B2E4 \C774\D6C4\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281343539209870271)
,p_name=>'APEX.DATEPICKER_VALUE_INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 \D615\C2DD %0\ACFC(\C640) \C77C\CE58\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281338162506870267)
,p_name=>'APEX.DATEPICKER_VALUE_LESS_MIN_DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 \C9C0\C815\B41C \CD5C\C18C \B0A0\C9DC %0\BCF4\B2E4 \C774\C804\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281338300750870267)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 %0\ACFC(\C640) %1 \C0AC\C774\C758 \C801\D569\D55C \BC94\C704\C5D0 \C18D\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281341897892870270)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_IN_YEAR_RANGE'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 %0\ACFC(\C640) %1 \C0AC\C774\C758 \C801\D569\D55C \C5F0\B3C4 \BC94\C704\C5D0 \C18D\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281945010804870649)
,p_name=>'APEX.DIALOG.CANCEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CDE8\C18C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282050755317870714)
,p_name=>'APEX.DIALOG.CLOSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EB\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282055720106870717)
,p_name=>'APEX.DIALOG.HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281944821463870649)
,p_name=>'APEX.DIALOG.OK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D655\C778')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281156245971870150)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 %0 \B300\D654\C0C1\C790 \D398\C774\C9C0 %1\C744(\B97C) \C131\ACF5\C801\C73C\B85C \B80C\B354\B9C1\D560 \C218 \C5C6\C2B5\B2C8\B2E4. \D398\C774\C9C0 %1\C5D0\C11C \C0AC\C6A9 \C911\C778 \D398\C774\C9C0 \D15C\D50C\B9AC\D2B8\AC00 \C801\D569\D55C JavaScript \B300\D654\C0C1\C790 \CD08\AE30\D654, \B300\D654\C0C1\C790 \B2EB\AE30 \BC0F \B300\D654\C0C1\C790 \CDE8\C18C \CF54\B4DC\AC00 \C815\C758\B41C \D15C\D50C\B9AC\D2B8 \C720\D615 "\B300\D654\C0C1\C790 \D398\C774\C9C0"\C778\C9C0 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281944916936870649)
,p_name=>'APEX.DIALOG.SAVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282072426153870727)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_language=>'ko'
,p_message_text=>'Copyright &copy; %0, All rights reserved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282073267299870728)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282072384501870727)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BA54\C2DC\C9C0\B294 \C2DC\C2A4\D15C\C5D0\C11C \C0DD\C131\B41C \BA54\C2DC\C9C0\C785\B2C8\B2E4. \C774 \BA54\C2DC\C9C0\C5D0 \D68C\C2E0\D558\C9C0 \B9C8\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282082115963870733)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D658\ACBD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282094709306870741)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_language=>'ko'
,p_message_text=>unistr('Oracle Application Express \C0AC\C6A9\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282073857919870728)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C791\D558\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282072510559870727)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\B2D8 \C548\B155\D558\C138\C694.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282073558899870728)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\BC00\BC88\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282082260665870733)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \BE44\C6B0\AE30 \AE08\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282073738330870728)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B798 \B2E8\CD94\B97C \B204\B974\ACE0 \D654\BA74\C758 \C9C0\CE68\C5D0 \B530\B77C \C791\C5C5\C601\C5ED\C744 \BE44\C6B0\C9C0 \BABB\D558\B3C4\B85D \CC28\B2E8\D560 \C218 \C788\C2B5\B2C8\B2E4. %0\C77C \C774\B0B4\C5D0 \C870\CE58\D558\C9C0 \C54A\C744 \ACBD\C6B0 \C791\C5C5\C601\C5ED\C774 \C790\B3D9\C73C\B85C \C81C\AC70\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282081981686870733)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED\C774 \B354 \C774\C0C1 \D544\C694\D558\C9C0 \C54A\C740 \ACBD\C6B0 \BCC4\B3C4\C758 \C791\C5C5\C774 \D544\C694\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282082499327870733)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED\C744 \BE44\C6B0\B824\ACE0 \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282081788888870733)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C791\C5C5\C601\C5ED\C740 \CD5C\ADFC \D65C\B3D9\C744 \D45C\C2DC\D558\C9C0 \C54A\C73C\BBC0\B85C \ACE7 \BE44\C6B8 \C608\C815\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282081647717870733)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACBD\ACE0! "%0" \C791\C5C5\C601\C5ED\C744 \BE44\C6B0\B824\ACE0 \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282082006544870733)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\C6B0\AE30 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282082725268870733)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \C694\CCAD\C744 \C644\B8CC\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282082532392870733)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_language=>'ko'
,p_message_text=>unistr('"%0" \C791\C5C5\C601\C5ED\C774 \C900\BE44\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282082808808870733)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_language=>'ko'
,p_message_text=>unistr('"%0" \C791\C5C5\C601\C5ED\C774 \C2B9\C778\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282082658519870733)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \C694\CCAD\C774 \AC70\C808\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282073181439870728)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282082326964870733)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACBD\ACE0!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282073077862870727)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282072615343870727)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \C694\CCAD\C774 \C2B9\C778\B428')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282073381776870728)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B798 \B2E8\CD94\B97C \B20C\B7EC \C2B9\C778 \D504\B85C\C138\C2A4\B97C \C644\B8CC\D558\ACE0 \BE44\BC00\BC88\D638\B97C \C124\C815\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282072887782870727)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \C694\CCAD\C774 \C2B9\C778\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282073426148870728)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C791\D558\B824\BA74 \C544\B798 \B2E8\CD94\B97C \B204\B974\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282073606816870728)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED\C774 \C900\BE44\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282072738101870727)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \C694\CCAD\C774 \AC70\C808\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282072957786870727)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8C4\C1A1\D569\B2C8\B2E4. \C791\C5C5\C601\C5ED \C694\CCAD\C774 \AC70\C808\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280972340317870023)
,p_name=>'APEX.ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280722608651869870)
,p_name=>'APEX.ERROR.CALLBACK_FAILED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958 \CC98\B9AC \CF5C\BC31\C744 \C2E4\D589\D558\B294 \C911 \B2E4\C74C \C624\B958 \BC1C\C0DD: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280763730008869894)
,p_name=>'APEX.ERROR.ERROR_PAGE.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958 \D398\C774\C9C0\B97C \C791\C131\D558\B294 \C911 \C624\B958 \BC1C\C0DD: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280726499016869872)
,p_name=>'APEX.ERROR.INTERNAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4\BD80 \C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282014804357870692)
,p_name=>'APEX.ERROR.INTERNAL.CONTACT_ADMINISTRATOR'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\AD00\B9AC\C790\C5D0\AC8C \C5F0\B77D\D558\C2ED\C2DC\C624.'),
unistr('\C774 \C7A5\C560\C5D0 \B300\D55C \C138\BD80\C815\BCF4\B294 \B514\BC84\ADF8 ID "%0"\C744(\B97C) \D1B5\D574 \C81C\ACF5\B429\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282095659162870741)
,p_name=>'APEX.ERROR.ORA-28353'
,p_message_language=>'ko'
,p_message_text=>unistr('ORA-28353: \C804\C790 \C9C0\AC11 \C5F4\AE30\B97C \C2E4\D328\D588\C2B5\B2C8\B2E4. \C560\D50C\B9AC\CF00\C774\C158 \B370\C774\D130\C5D0 \D604\C7AC \C561\C138\C2A4\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281997059864870681)
,p_name=>'APEX.ERROR.PAGE_NOT_AVAILABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8C4\C1A1\D569\B2C8\B2E4. \C774 \D398\C774\C9C0\B97C \C0AC\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280732291127869876)
,p_name=>'APEX.ERROR.TECHNICAL_INFO'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\C220 \C815\BCF4(\AC1C\BC1C\C790\C5D0\AC8C\B9CC \D45C\C2DC\B428)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281560060151870416)
,p_name=>'APEX.ERROR_MESSAGE_HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958 \BA54\C2DC\C9C0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281633924359870461)
,p_name=>'APEX.EXPECTED_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\C694\D55C \D615\C2DD: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281357538066870280)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.ALREADY_IN_ACL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\AC00 \C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0 \C774\BBF8 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281357416432870280)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.CREATE_CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\BA85\C758 <strong>%1</strong> \C0AC\C6A9\C790\B97C \C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0 \CD94\AC00\D560\C9C0 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281357905147870281)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.DUPLICATE_USE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\BCF5 \C0AC\C6A9\C790\AC00 \C874\C7AC\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281357674812870280)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_AT_SIGN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C8FC\C18C\C5D0 at \AE30\D638(@)\AC00 \B204\B77D\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281357706940870281)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_DO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C8FC\C18C\C5D0 \B9C8\CE68\D45C(.)\AC00 \B204\B77D\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281357835213870281)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.USERNAME_TOO_LONG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984\C774 \B108\BB34 \AE41\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281358177261870281)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_ONLY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0 \C815\C758\B41C \C0AC\C6A9\C790\B9CC \C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C561\C138\C2A4\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281358296881870281)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_VALUE_INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608\C0C1\CE58 \C54A\C740 \C561\C138\C2A4 \C81C\C5B4 \C124\C815 \AC12: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281358026864870281)
,p_name=>'APEX.FEATURE.ACL.INFO.ALL_USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\B41C \BAA8\B4E0 \C0AC\C6A9\C790\AC00 \C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C561\C138\C2A4\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281903628020870624)
,p_name=>'APEX.FEATURE.CONFIG.DISABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9 \C548\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281903516428870624)
,p_name=>'APEX.FEATURE.CONFIG.ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C73C\B85C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281904637864870625)
,p_name=>'APEX.FEATURE.CONFIG.IS_DISABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('%0: \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281903739024870625)
,p_name=>'APEX.FEATURE.CONFIG.IS_ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('%0: \C0AC\C6A9\C73C\B85C \C124\C815\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281293301689870238)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\AE30\C5F4\C5D0 \C788\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281293417829870238)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C1A1\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281903481514870624)
,p_name=>'APEX.FEATURE.TOP_USERS.USERNAME.NOT_IDENTIFIED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\D558\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280757013737869890)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\B4DC\BC31 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280757134195869890)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BBF8\ACB0 \D53C\B4DC\BC31 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280757279552869890)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281647063759870468)
,p_name=>'APEX.FILE_BROWSE.DOWNLOAD_LINK_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C6B4\B85C\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281640276297870464)
,p_name=>'APEX.FS.BATCH_APPLY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\C6A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281640751767870465)
,p_name=>'APEX.FS.CLEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C6B0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281640866653870465)
,p_name=>'APEX.FS.CLEAR_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \C9C0\C6B0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281640986774870465)
,p_name=>'APEX.FS.CLEAR_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C9C0\C6B0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281971525593870666)
,p_name=>'APEX.FS.COLUMN_UNAUTHORIZED'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D328\C2EF\C774 \CC38\C870\D558\B294 %1 \C5F4\C744 \C0AC\C6A9\D560 \C218 \C5C6\AC70\B098 \D574\B2F9 \C5F4\C5D0 \B300\D55C \AD8C\D55C\C774 \BD80\C5EC\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281963910541870661)
,p_name=>'APEX.FS.FACET_VALUE_LIMIT_EXCEEDED'
,p_message_language=>'ko'
,p_message_text=>unistr('%1 \D328\C2EF\C5D0 \B300\D55C \ACE0\C720 \AC12 \C81C\D55C(%0)\C774 \CD08\ACFC\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281642447546870466)
,p_name=>'APEX.FS.FC_TYPE_UNSUPPORTED_FOR_DATE_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D328\C2EF\C740 DATE \B610\B294 TIMESTAMP \C5F4\C5D0 \B300\D574 \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281640397150870464)
,p_name=>'APEX.FS.FILTER'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D544\D130\B9C1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281640454441870464)
,p_name=>'APEX.FS.GO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281642042668870465)
,p_name=>'APEX.FS.INPUT_CURRENT_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\ACFC(\C640) \AC19\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281642240166870466)
,p_name=>'APEX.FS.NO_SEARCH_COLUMNS_PROVIDED'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D328\C2EF\C5D0 \B300\D574 \C81C\ACF5\B41C \AC80\C0C9 \C5F4\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281641796290870465)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL'
,p_message_language=>'ko'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281641830896870465)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_HI'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C774\C0C1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281641992521870465)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_LO'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C774\D558')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281982394825870672)
,p_name=>'APEX.FS.RANGE_LOV_ITEM_INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC94\C704 \D328\C2EF %0\C5D0 \B300\D55C LOV \D56D\BAA9 #%2("%1")\C774(\AC00) \BD80\C801\D569\D569\B2C8\B2E4("|" \AD6C\BD84 \AE30\D638 \B204\B77D).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281642125552870466)
,p_name=>'APEX.FS.RANGE_MANUAL_NOT_SUPPORTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4\C774 DATE \B610\B294 TIMESTAMP\C774\BBC0\B85C \BC94\C704 \D328\C2EF %0\C5D0 \B300\D55C \C218\B3D9 \C785\B825\C740 \D604\C7AC \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281641370866870465)
,p_name=>'APEX.FS.RANGE_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281640658071870465)
,p_name=>'APEX.FS.SEARCH_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281640586910870465)
,p_name=>'APEX.FS.SEARCH_PLACEHOLDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281641583218870465)
,p_name=>'APEX.FS.SELECT_PLACEHOLDER'
,p_message_language=>'ko'
,p_message_text=>unistr('- \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281641127738870465)
,p_name=>'APEX.FS.SHOW_LESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC04\B2E8\D788 \D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281641235145870465)
,p_name=>'APEX.FS.SHOW_MORE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B354 \BCF4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281641490779870465)
,p_name=>'APEX.FS.STAR_RATING_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC4 %0\AC1C \C774\C0C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281642368637870466)
,p_name=>'APEX.FS.TEXT_FIELD_ONLY_FOR_NUMBER_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14D\C2A4\D2B8 \D544\B4DC \D328\C2EF %0\C740(\B294) \D604\C7AC NUMBER \C5F4\C5D0 \B300\D574\C11C\B9CC \C9C0\C6D0\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281971707965870666)
,p_name=>'APEX.FS.UNSUPPORTED_DATA_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \B370\C774\D130 \C720\D615(%1)\C740 \D328\C2EF\C774 \C9C0\C815\B41C \AC80\C0C9\C5D0 \B300\D574 \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281905266785870626)
,p_name=>'APEX.GO_TO_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958\B85C \C774\B3D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281118199296870124)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('"%0" \ADF8\B8F9\C744 \CC3E\C744 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281364014531870285)
,p_name=>'APEX.GV.AGG_CONTEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9D1\ACC4\C785\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281472630248870361)
,p_name=>'APEX.GV.BREAK_COLLAPSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \CC28\B2E8 \CD95\C18C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281364102201870285)
,p_name=>'APEX.GV.BREAK_CONTEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \CC28\B2E8\C785\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281472571843870361)
,p_name=>'APEX.GV.BREAK_EXPAND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \CC28\B2E8 \D655\C7A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282101810056870745)
,p_name=>'APEX.GV.COLUMN_CONTEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C5F4\C785\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281472321432870361)
,p_name=>'APEX.GV.DELETED_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\AC1C\C758 \D589\C774 \C0AD\C81C\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282061316313870720)
,p_name=>'APEX.GV.DUP_REC_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\BCF5 ID')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281351060527870276)
,p_name=>'APEX.GV.FIRST_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCAB\BC88\C9F8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281364363359870285)
,p_name=>'APEX.GV.GROUP_CONTEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \BA38\B9AC\AE00\C785\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281364258406870285)
,p_name=>'APEX.GV.HEADER_CONTEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BA38\B9AC\AE00\C785\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281351171775870276)
,p_name=>'APEX.GV.LAST_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C9C0\B9C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281512933626870387)
,p_name=>'APEX.GV.LOAD_MORE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00 \D589 \B85C\B4DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281350855225870276)
,p_name=>'APEX.GV.NEXT_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281364416038870286)
,p_name=>'APEX.GV.PAGE_RANGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281351219486870276)
,p_name=>'APEX.GV.PAGE_RANGE_XY'
,p_message_language=>'ko'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281351320826870276)
,p_name=>'APEX.GV.PAGE_RANGE_XYZ'
,p_message_language=>'ko'
,p_message_text=>'%0-%1/%2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281350950922870276)
,p_name=>'APEX.GV.PREV_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282061108938870720)
,p_name=>'APEX.GV.ROW_ADDED'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282061284419870720)
,p_name=>'APEX.GV.ROW_CHANGED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\ACBD\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282101622965870745)
,p_name=>'APEX.GV.ROW_COLUMN_CONTEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 %0, \C5F4 %1.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282101785643870745)
,p_name=>'APEX.GV.ROW_CONTEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D589\C785\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282061060365870720)
,p_name=>'APEX.GV.ROW_DELETED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AD\C81C\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281393243441870306)
,p_name=>'APEX.GV.ROW_HEADER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \BA38\B9AC\AE00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281350149185870275)
,p_name=>'APEX.GV.SELECTION_CELL_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\AC1C \C140\C774 \C120\D0DD\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281351420880870276)
,p_name=>'APEX.GV.SELECTION_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\AC1C\C758 \D589\C774 \C120\D0DD\B418\C5C8\C2B5\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281696810605870499)
,p_name=>'APEX.GV.SELECT_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \C120\D0DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281472463824870361)
,p_name=>'APEX.GV.SELECT_PAGE_N'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D398\C774\C9C0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281393128274870306)
,p_name=>'APEX.GV.SELECT_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C120\D0DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281395775234870308)
,p_name=>'APEX.GV.SORTED_ASCENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B984\CC28\C21C\C73C\B85C \C815\B82C\B428 - %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281395808559870308)
,p_name=>'APEX.GV.SORTED_DESCENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4\B9BC\CC28\C21C\C73C\B85C \C815\B82C\B428 - %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281350301455870275)
,p_name=>'APEX.GV.SORT_ASCENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B984\CC28\C21C \C815\B82C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281350698379870276)
,p_name=>'APEX.GV.SORT_ASCENDING_ORDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B984\CC28\C21C \C815\B82C %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281350458517870275)
,p_name=>'APEX.GV.SORT_DESCENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4\B9BC\CC28\C21C \C815\B82C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281350754085870276)
,p_name=>'APEX.GV.SORT_DESCENDING_ORDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4\B9BC\CC28\C21C \C815\B82C %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281350535000870276)
,p_name=>'APEX.GV.SORT_OFF'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C \C548\D568')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281472216220870361)
,p_name=>'APEX.GV.TOTAL_PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD1D %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282035561736870705)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85\C11C \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282055089440870716)
,p_name=>'APEX.ICON_LIST.GRID_DIM'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B9AC\B4DC \C120\D0DD \BAA9\B85D %0 \C5F4 %1 \D589. \D654\C0B4\D45C \D0A4 \C0AC\C6A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281471386031870360)
,p_name=>'APEX.ICON_LIST.LIST_DIM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD \BAA9\B85D %0 \D589. \D654\C0B4\D45C \D0A4 \C0AC\C6A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282101438730870745)
,p_name=>'APEX.IG.ACC_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \ADF8\B9AC\B4DC %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281333513000870264)
,p_name=>'APEX.IG.ACTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281334555578870265)
,p_name=>'APEX.IG.ADD'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281334497752870265)
,p_name=>'APEX.IG.ADD_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \CD94\AC00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282069158326870725)
,p_name=>'APEX.IG.AGGREGATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9D1\ACC4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282032097623870702)
,p_name=>'APEX.IG.AGGREGATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9D1\ACC4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282035061623870704)
,p_name=>'APEX.IG.ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281592281718870435)
,p_name=>'APEX.IG.ALL_TEXT_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \D14D\C2A4\D2B8 \C5F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281593448078870436)
,p_name=>'APEX.IG.ALTERNATIVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\CCB4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281594513537870437)
,p_name=>'APEX.IG.AND'
,p_message_language=>'ko'
,p_message_text=>'~'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281940579983870647)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\B7B5\C801 \ACE0\C720 \AC1C\C218')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282070157408870726)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT_OVERALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \B300\B7B5\C801 \ACE0\C720 \AC1C\C218')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282028157959870700)
,p_name=>'APEX.IG.AREA'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282033697933870703)
,p_name=>'APEX.IG.ASCENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B984\CC28\C21C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281593552711870436)
,p_name=>'APEX.IG.AUTHORIZATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD8C\D55C \BD80\C5EC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282069287594870725)
,p_name=>'APEX.IG.AUTO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C790\B3D9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281940977955870647)
,p_name=>'APEX.IG.AVG'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3C9\ADE0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282069867065870725)
,p_name=>'APEX.IG.AVG_OVERALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \D3C9\ADE0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282027626769870700)
,p_name=>'APEX.IG.AXIS_LABEL_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14 \CD95 \C81C\BAA9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282027811697870700)
,p_name=>'APEX.IG.AXIS_VALUE_DECIMAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18C\C218\C810 \C790\B9AC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282027724449870700)
,p_name=>'APEX.IG.AXIS_VALUE_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12 \CD95 \C81C\BAA9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282041843444870708)
,p_name=>'APEX.IG.BACKGROUND_COLOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC30\ACBD\C0C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282028240528870700)
,p_name=>'APEX.IG.BAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C9\B300')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281575973470870425)
,p_name=>'APEX.IG.BETWEEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C0AC\C774')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282043566035870709)
,p_name=>'APEX.IG.BOTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282028336074870700)
,p_name=>'APEX.IG.BUBBLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\BE14')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281334723406870265)
,p_name=>'APEX.IG.CANCEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CDE8\C18C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281594463279870437)
,p_name=>'APEX.IG.CASE_SENSITIVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C18C\BB38\C790 \AD6C\BD84')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282070742529870726)
,p_name=>'APEX.IG.CASE_SENSITIVE_WITH_BRACKETS'
,p_message_language=>'ko'
,p_message_text=>unistr('(\B300\C18C\BB38\C790 \AD6C\BD84)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281980222273870671)
,p_name=>'APEX.IG.CHANGES_SAVED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\ACBD\C0AC\D56D \C800\C7A5\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281335191216870265)
,p_name=>'APEX.IG.CHANGE_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\AE30 \BCC0\ACBD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281595554104870437)
,p_name=>'APEX.IG.CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281590983886870434)
,p_name=>'APEX.IG.CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\B2F9 \C9C8\C758\B294 \CC28\D2B8\B2F9 \CD5C\B300 \B370\C774\D130 \D3EC\C778\D2B8 \C218 %0\AC1C\B97C \CD08\ACFC\D569\B2C8\B2E4. \AE30\BCF8 \C9C8\C758\C758 \B808\CF54\B4DC \C218\B97C \C904\C774\B824\BA74 \D544\D130\B97C \C801\C6A9\D558\C2ED\C2DC\C624.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281333427499870264)
,p_name=>'APEX.IG.CHART_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \BCF4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281396768999870309)
,p_name=>'APEX.IG.CLEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C6B0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282027172008870699)
,p_name=>'APEX.IG.CLOSE_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EB\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282042536284870709)
,p_name=>'APEX.IG.COLORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C9\C0C1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282042445037870709)
,p_name=>'APEX.IG.COLOR_BLUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\B780\C0C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282042365565870709)
,p_name=>'APEX.IG.COLOR_GREEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B179\C0C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282042132522870709)
,p_name=>'APEX.IG.COLOR_ORANGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC\D669\C0C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282042267747870709)
,p_name=>'APEX.IG.COLOR_RED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE68\AC04\C0C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282042047325870708)
,p_name=>'APEX.IG.COLOR_YELLOW'
,p_message_language=>'ko'
,p_message_text=>unistr('\B178\B780\C0C9')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281593867308870436)
,p_name=>'APEX.IG.COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281333680841870264)
,p_name=>'APEX.IG.COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282047318176870712)
,p_name=>'APEX.IG.COLUMN_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \C6A9\B3C4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281593961444870436)
,p_name=>'APEX.IG.COMPLEX'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF5\D569')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281333850198870264)
,p_name=>'APEX.IG.COMPUTE'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C0B0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281576510384870426)
,p_name=>'APEX.IG.CONTAINS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C744 \D3EC\D568')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281599802214870440)
,p_name=>'APEX.IG.CONTROL_BREAK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \CC28\B2E8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281396558994870308)
,p_name=>'APEX.IG.COPY_CB'
,p_message_language=>'ko'
,p_message_text=>unistr('\D074\B9BD\BCF4\B4DC\B85C \BCF5\C0AC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281396603078870309)
,p_name=>'APEX.IG.COPY_DOWN'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF5\C0AC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281940366151870647)
,p_name=>'APEX.IG.COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\C218')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281940403750870647)
,p_name=>'APEX.IG.COUNT_DISTINCT'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\C720 \AC1C\C218')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282070021323870726)
,p_name=>'APEX.IG.COUNT_DISTINCT_OVERALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \ACE0\C720 \AC1C\C218')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282069991953870726)
,p_name=>'APEX.IG.COUNT_OVERALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \AC1C\C218')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282061460422870720)
,p_name=>'APEX.IG.CREATE_X'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C0DD\C131')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281592474673870435)
,p_name=>'APEX.IG.DATA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282044750315870710)
,p_name=>'APEX.IG.DATA_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \C720\D615')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282043711622870709)
,p_name=>'APEX.IG.DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0A0\C9DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281980072359870671)
,p_name=>'APEX.IG.DATE_INVALID_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \B0A0\C9DC \AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281577408718870426)
,p_name=>'APEX.IG.DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281593131550870436)
,p_name=>'APEX.IG.DEFAULT_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281592935822870436)
,p_name=>'APEX.IG.DEFAULT_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \C720\D615')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281334637007870265)
,p_name=>'APEX.IG.DELETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AD\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282048326015870712)
,p_name=>'APEX.IG.DELETE_REPORT_CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BCF4\ACE0\C11C\B97C \C0AD\C81C\D558\ACA0\C2B5\B2C8\AE4C?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281601629949870441)
,p_name=>'APEX.IG.DELETE_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C0AD\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281600482910870440)
,p_name=>'APEX.IG.DELETE_ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C0AD\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282033700555870703)
,p_name=>'APEX.IG.DESCENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4\B9BC\CC28\C21C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281595277155870437)
,p_name=>'APEX.IG.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B514\D14C\C77C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281333171562870264)
,p_name=>'APEX.IG.DETAIL_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\BD80\C815\BCF4 \BCF4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281995957520870681)
,p_name=>'APEX.IG.DIRECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC29\D5A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281594949572870437)
,p_name=>'APEX.IG.DISABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9 \C548\D568')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281576601638870426)
,p_name=>'APEX.IG.DOES_NOT_CONTAIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C744 \D3EC\D568\D558\C9C0 \C54A\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281576847176870426)
,p_name=>'APEX.IG.DOES_NOT_START_WITH'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C73C\B85C \C2DC\C791\D558\C9C0 \C54A\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282028481534870700)
,p_name=>'APEX.IG.DONUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3C4\B11B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281600048137870440)
,p_name=>'APEX.IG.DOWNLOAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C6B4\B85C\B4DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282049311817870713)
,p_name=>'APEX.IG.DOWNLOAD_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D615\C2DD \C120\D0DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282034620436870704)
,p_name=>'APEX.IG.DUPLICATE_AGGREGATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\BCF5 \C9D1\ACC4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282034743011870704)
,p_name=>'APEX.IG.DUPLICATE_CONTROLBREAK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\BCF5 \C81C\C5B4 \CC28\B2E8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281601579981870441)
,p_name=>'APEX.IG.DUPLICATE_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \BCF5\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281600300690870440)
,p_name=>'APEX.IG.DUPLICATE_ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\BCF5 \D589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281334261095870265)
,p_name=>'APEX.IG.EDIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3B8\C9D1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282033123549870703)
,p_name=>'APEX.IG.EDIT_CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \D3B8\C9D1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282057184199870718)
,p_name=>'APEX.IG.EDIT_GROUP_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900 \D3B8\C9D1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282048994495870713)
,p_name=>'APEX.IG.EMAIL_BCC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C228\C740 \CC38\C870(bcc)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282049194536870713)
,p_name=>'APEX.IG.EMAIL_BODY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BA54\C2DC\C9C0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282048822252870713)
,p_name=>'APEX.IG.EMAIL_CC'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC38\C870(cc)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282048508597870712)
,p_name=>'APEX.IG.EMAIL_SENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C\C774 \C804\C1A1\B418\C5C8\C2B5\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282049079450870713)
,p_name=>'APEX.IG.EMAIL_SUBJECT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\BAA9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282048734042870713)
,p_name=>'APEX.IG.EMAIL_TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\C2E0\C790(\BC1B\B294 \C0AC\B78C)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281594602586870437)
,p_name=>'APEX.IG.ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C73C\B85C \C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281574930140870425)
,p_name=>'APEX.IG.EQUALS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC19\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282047975907870712)
,p_name=>'APEX.IG.EXAMPLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281594731656870437)
,p_name=>'APEX.IG.EXPRESSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\D604\C2DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282047888686870712)
,p_name=>'APEX.IG.FD_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C720\D615')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281696762485870499)
,p_name=>'APEX.IG.FILE_PREPARED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C77C\C774 \C900\BE44\B418\C5C8\C2B5\B2C8\B2E4. \B2E4\C6B4\B85C\B4DC\B97C \C2DC\C791\D558\B294 \C911\C785\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281396881583870309)
,p_name=>'APEX.IG.FILL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC44\C6B0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281418260920870324)
,p_name=>'APEX.IG.FILL_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C73C\B85C \C120\D0DD \CC44\C6B0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281418158398870324)
,p_name=>'APEX.IG.FILL_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD \CC44\C6B0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281333748585870264)
,p_name=>'APEX.IG.FILTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281594033317870436)
,p_name=>'APEX.IG.FILTERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282069532741870725)
,p_name=>'APEX.IG.FILTER_WITH_DOTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282033939364870704)
,p_name=>'APEX.IG.FIRST'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCAB\BC88\C9F8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281333993692870264)
,p_name=>'APEX.IG.FLASHBACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\C2DC\BC31')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281592536406870435)
,p_name=>'APEX.IG.FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D615\C2DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282043483657870709)
,p_name=>'APEX.IG.FORMATMASK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D615\C2DD \B9C8\C2A4\D06C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282048206647870712)
,p_name=>'APEX.IG.FORMAT_CSV'
,p_message_language=>'ko'
,p_message_text=>'CSV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282048180578870712)
,p_name=>'APEX.IG.FORMAT_HTML'
,p_message_language=>'ko'
,p_message_text=>'HTML'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281601297819870441)
,p_name=>'APEX.IG.FREEZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281594877786870437)
,p_name=>'APEX.IG.FUNCTIONS_AND_OPERATORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D568\C218 \BC0F \C5F0\C0B0\C790')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282028533737870700)
,p_name=>'APEX.IG.FUNNEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D37C\B110')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281940258874870647)
,p_name=>'APEX.IG.GO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281575522013870425)
,p_name=>'APEX.IG.GREATER_THAN'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\B2E4 \D07C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281575666185870425)
,p_name=>'APEX.IG.GREATER_THAN_OR_EQUALS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\B2E4 \D06C\AC70\B098 \AC19\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281595168998870437)
,p_name=>'APEX.IG.GRID'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B9AC\B4DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281332988020870264)
,p_name=>'APEX.IG.GRID_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B9AC\B4DC \BDF0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282034983765870704)
,p_name=>'APEX.IG.GROUP'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281595373472870437)
,p_name=>'APEX.IG.GROUP_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281333267912870264)
,p_name=>'APEX.IG.GROUP_BY_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900 \BCF4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282044012271870710)
,p_name=>'APEX.IG.HD_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\AC74 \C720\D615')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282042909637870709)
,p_name=>'APEX.IG.HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\BA38\B9AC\AE00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282043116549870709)
,p_name=>'APEX.IG.HEADING_ALIGN'
,p_message_language=>'ko'
,p_message_text=>unistr('\BA38\B9AC\AE00 \B9DE\CDA4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282069421533870725)
,p_name=>'APEX.IG.HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282055265543870716)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C2DD \ADF8\B9AC\B4DC\C5D0\C11C \B370\C774\D130\B97C \C9C1\C811 \C0BD\C785, \C5C5\B370\C774\D2B8 \BC0F \C0AD\C81C\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\D589 \CD94\AC00 \B2E8\CD94\B97C \B20C\B7EC\C11C \C0C8 \D589\C744 \C0BD\C785\D569\B2C8\B2E4.</p>'),
'',
unistr('<p>\D2B9\C815 \C140\C744 \B450 \BC88 \B20C\B7EC\C11C \AE30\C874 \B370\C774\D130\B97C \D3B8\C9D1\D569\B2C8\B2E4. \B300\ADDC\BAA8 \D3B8\C9D1 \C791\C5C5\C758 \ACBD\C6B0 \D3B8\C9D1\C744 \B20C\B7EC\C11C \D3B8\C9D1 \BAA8\B4DC\B85C \C804\D658\D569\B2C8\B2E4. \D3B8\C9D1 \BAA8\B4DC\C5D0\C11C \C140\C744 \D55C \BC88 \B204\B974\AC70\B098 \D0A4\BCF4\B4DC\B97C \C0AC\C6A9\D558\C5EC \D2B9\C815 \C140\C744 \D3B8\C9D1\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\BCC0\ACBD \BA54\B274\B97C \C0AC\C6A9\D558\C5EC \D589\C744 \BCF5\C81C\D558\AC70\B098 \C0AD\C81C\D569\B2C8\B2E4. \BCC0\ACBD \BA54\B274\B97C \C0AC\C6A9\C73C\B85C \C124\C815\D558\B824\BA74 \CCB4\D06C\BC15\C2A4\B97C \C120\D0DD\D558\C5EC \D558\B098 \C774\C0C1\C758 \D589\C744 \C120\D0DD\D569\B2C8\B2E4.</p>'),
'',
unistr('<p>\BCC0\ACBD \BA54\B274\B97C \B204\B974\ACE0 \D589 \BCF5\C81C\B97C \C120\D0DD\D558\C5EC \C120\D0DD\D55C \D589\C744 \BCF5\C81C\D569\B2C8\B2E4. \BCC0\ACBD \BA54\B274\B97C \B204\B974\ACE0 \D589 \C0AD\C81C\B97C \C120\D0DD\D558\C5EC \C120\D0DD\D55C \D589\C744 \C0AD\C81C\D569\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282057640416870718)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING_HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282057714563870718)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B300\D654\C2DD \ADF8\B9AC\B4DC\C5D0\B294 \B370\C774\D130 \C138\D2B8\AC00 \AC80\C0C9 \AC00\B2A5\D55C \C0AC\C6A9\C790\C815\C758 \BCF4\ACE0\C11C\B85C \D45C\C2DC\B429\B2C8\B2E4. \BC18\D658\B418\B294 \B808\CF54\B4DC\B97C \C81C\D55C\D558\ACE0 \B370\C774\D130 \D45C\C2DC \BC29\BC95\C744 \BCC0\ACBD\D558\B294 \B2E4\C591\D55C \C791\C5C5\C744 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\AC80\C0C9 \D544\B4DC\B97C \C0AC\C6A9\D558\C5EC \BC18\D658\B418\B294 \B808\CF54\B4DC\B97C \D544\D130\B9C1\D569\B2C8\B2E4. \C791\C5C5\C744 \B20C\B7EC\C11C \BCF4\ACE0\C11C \B808\C774\C544\C6C3\C744 \C218\C815\D560 \C218 \C788\B294 \B2E4\C591\D55C \C635\C158\C5D0 \C561\C138\C2A4\D558\AC70\B098, \D45C\C2DC\B41C \C5F4\C5D0\C11C \C5F4 \BA38\B9AC\AE00 \BA54\B274\B97C \C0AC\C6A9\D569\B2C8\B2E4.</p>'),
'',
unistr('<p>\BCF4\ACE0\C11C \C124\C815\C744 \C0AC\C6A9\D558\C5EC \C0AC\C6A9\C790\C815\C758\B97C \BCF4\ACE0\C11C\C5D0 \C800\C7A5\D569\B2C8\B2E4. \BCF4\ACE0\C11C\C758 \B370\C774\D130\B97C \C678\BD80 \D30C\C77C\B85C \B2E4\C6B4\B85C\B4DC\D558\AC70\B098 \B370\C774\D130\B97C \B098 \C790\C2E0\C774\B098 \B2E4\B978 \C0AC\C6A9\C790\C5D0\AC8C \C804\C790\BA54\C77C\B85C \BCF4\B0BC \C218 \C788\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\C790\C138\D55C \B0B4\C6A9\C740 <em>Oracle Application Express End User''s Guide</em>\C758 "Using Interactive Grids"\B97C \CC38\C870\D558\C2ED\C2DC\C624.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282057419241870718)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO_HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\C694')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282055195146870716)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B0B4\C7A5 \AE30\B2A5\C744 \C0AC\C6A9\D558\C5EC \B370\C774\D130\B97C \B2E4\C591\D55C \BC29\C2DD\C73C\B85C \D45C\C2DC\D558\B3C4\B85D \B300\D654\C2DD \ADF8\B9AC\B4DC\B97C \C0AC\C6A9\C790\AC00 \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\C5F4 \BA38\B9AC\AE00 \BA54\B274 \B610\B294 \C791\C5C5 \BA54\B274\B97C \C0AC\C6A9\D558\C5EC \D45C\C2DC\D560 \C5F4 \BC0F \C21C\C11C\B97C \ACB0\C815\D558\ACE0 \C5F4\C744 \ACE0\C815\D569\B2C8\B2E4. \B2E4\C591\D55C \B370\C774\D130 \D544\D130\B97C \C815\C758\D558\ACE0 \BC18\D658\B418\B294 \B370\C774\D130\B97C \C815\B82C\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\AC80\C0C9 \D544\B4DC \C606\C5D0 \C788\B294 \BCF4\AE30 \B2E8\CD94\B97C \C0AC\C6A9\D558\C5EC \C560\D50C\B9AC\CF00\C774\C158 \AC1C\BC1C\C790\AC00 \C815\C758\D55C \B2E4\B978 \B370\C774\D130 \BCF4\AE30\C5D0 \C561\C138\C2A4\D560 \C218 \C788\C2B5\B2C8\B2E4. \CC28\D2B8\B97C \C0DD\C131\D558\AC70\B098 \AE30\C874 \CC28\D2B8\B97C \C870\D68C\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</p>  '),
'',
unistr('<p><em>\CC38\ACE0: \B300\D654\C2DD \ADF8\B9AC\B4DC \B300\D654\C0C1\C790\C5D0\C11C <strong>\B3C4\C6C0\B9D0</strong>\C744 \B20C\B7EC\C11C \C120\D0DD\D55C \D568\C218\C5D0 \B300\D55C \C138\BD80\C815\BCF4\B97C \D655\C778\D560 \C218 \C788\C2B5\B2C8\B2E4.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282057572758870718)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING_HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5 \BCF4\ACE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281600207357870440)
,p_name=>'APEX.IG.HELP.ACTIONS_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \ADF8\B9AC\B4DC \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282052175786870715)
,p_name=>'APEX.IG.HELP.AGGREGATE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \C5F4\C744 \C9D1\ACC4\D569\B2C8\B2E4. \C9D1\ACC4\B41C \AC12\C740 \B370\C774\D130 \D558\B2E8 \B610\B294 \AC01 \AD6C\BD84\C120 \D558\B2E8(\C81C\C5B4 \CC28\B2E8\C774 \C815\C758\B418\C5B4 \C788\B294 \ACBD\C6B0)\C5D0 \D45C\C2DC\B429\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\C9D1\ACC4 \BAA9\B85D</strong><br>'),
unistr('\C9D1\ACC4 \BAA9\B85D\C5D0\B294 \C815\C758\B41C \C9D1\ACC4\AC00 \D45C\C2DC\B429\B2C8\B2E4. \C9D1\ACC4\B97C \C120\D0DD \D574\C81C\D558\C5EC \AE30\C874 \C9D1\ACC4\B97C \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\D569\B2C8\B2E4.<br>'),
unistr('\C0C8 \C9D1\ACC4\B97C \C0DD\C131\D558\B824\BA74 \CD94\AC00( &plus; )\B97C \B204\B974\ACE0 \AE30\C874 \C9D1\ACC4\B97C \C81C\AC70\D558\B824\BA74 \C0AD\C81C( &minus; )\B97C \B204\B985\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\C9D1\ACC4 \C124\C815</strong><br>'),
unistr('\C624\B978\CABD\C5D0 \C788\B294 \D3FC\C744 \C0AC\C6A9\D558\C5EC \C9D1\ACC4\B97C \C815\C758\D569\B2C8\B2E4.<br>'),
unistr('\C5F4 \C774\B984\ACFC \C9D1\ACC4 \C720\D615\C744 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('\C9D1\ACC4\C5D0 \B300\D55C \B3C4\AD6C \C124\BA85\C744 \C785\B825\D569\B2C8\B2E4(\C120\D0DD\C0AC\D56D).<br>'),
unistr('\C81C\C5B4 \CC28\B2E8\C744 \C815\C758\D55C \ACBD\C6B0 <strong>\C804\CCB4 \AC12 \D45C\C2DC</strong>\B97C \C120\D0DD\D558\BA74 \B370\C774\D130 \D558\B2E8\C5D0 \C804\CCB4 \D3C9\ADE0, \CD1D\ACC4 \B610\B294 \C774\C640 \C720\C0AC\D55C \AC12\C774 \D45C\C2DC\B429\B2C8\B2E4.</p>'),
'',
unistr('<p><em>\CC38\ACE0: \C5F4 \BA38\B9AC\AE00 \BC0F \D569\ACC4( &sum; )\B97C \B204\B974\AC70\B098 \C791\C5C5 \BA54\B274\C5D0\C11C \C9D1\ACC4 \B300\D654\C0C1\C790\C5D0 \C561\C138\C2A4\D569\B2C8\B2E4.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282056580147870717)
,p_name=>'APEX.IG.HELP.AGGREGATE_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9D1\ACC4 \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282052863172870715)
,p_name=>'APEX.IG.HELP.CHART'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \BCC4\B3C4\C758 \B370\C774\D130 \BCF4\AE30\B85C \D45C\C2DC\B418\B294 \CC28\D2B8\B97C \C815\C758\D569\B2C8\B2E4.<br> '),
unistr('\CC28\D2B8 \C720\D615\C744 \C120\D0DD\D558\ACE0 \CC28\D2B8 \C124\C815\C744 \AD6C\C131\D558\ACE0 <strong>\C800\C7A5</strong>\C744 \B204\B985\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\CC28\D2B8 \C124\C815</strong></br>'),
unistr('\D45C\C2DC\B418\B294 \CC28\D2B8 \C18D\C131\C740 \CC28\D2B8 \C720\D615\C5D0 \B530\B77C \B2E4\B985\B2C8\B2E4. \B2E4\C591\D55C \C18D\C131\C744 \C785\B825\D558\C5EC \CC28\D2B8\B97C \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4. \BE68\AC04\C0C9 \BCC4\D45C\AC00 \D45C\C2DC\B41C \C18D\C131\C740 \D544\C218\C785\B2C8\B2E4.</p>'),
'',
unistr('<p>\CC28\D2B8 \C720\D615 \AC04\C5D0 \C0AC\C6A9 \AC00\B2A5\D55C \BAA8\B4E0 \C18D\C131\C740 \C544\B798\C640 \AC19\C2B5\B2C8\B2E4(\C54C\D30C\BCB3\C21C).'),
'<ul>',
unistr('  <li>\C9D1\ACC4 - \C5F0\ACB0\B41C \CC28\D2B8 \AC12\C744 \C9D1\ACC4\D558\B294 \BC29\BC95\C744 \C120\D0DD\D569\B2C8\B2E4.</li> '),
unistr('  <li>\B9C8\AC10 - \C77C\BCC4 \C8FC\C2DD \B9C8\AC10 \AC00\ACA9\C744 \D3EC\D568\D558\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4(\C8FC\C2DD \CC28\D2B8 \C804\C6A9).</li> '),
unistr('  <li>\C18C\C218\C810 \C790\B9AC - \AC12\C744 \BC18\C62C\B9BC\D560 \C18C\C218\C810 \C790\B9BF\C218\B97C \C785\B825\D569\B2C8\B2E4.</li> '),
unistr('  <li>\BC29\D5A5 -  \C815\B82C \AE30\C900 \C18D\C131 \C774\C678\C5D0 \B370\C774\D130\B97C \C624\B984\CC28\C21C\C73C\B85C \C815\B82C\D560\C9C0 \B0B4\B9BC\CC28\C21C\C73C\B85C \C815\B82C\D560\C9C0 \C5EC\BD80\B97C \C9C0\C815\D569\B2C8\B2E4.</li> '),
unistr('  <li>\C0C1\C704 - \C0C1\C704 \AC12\C744 \D3EC\D568\D558\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4(\BC94\C704 \BC0F \C8FC\C2DD \CC28\D2B8 \C804\C6A9).</li> '),
unistr('  <li>\B808\C774\BE14 - \AC01 \B370\C774\D130 \D3EC\C778\D2B8\C5D0 \B300\D55C \D14D\C2A4\D2B8\B97C \D3EC\D568\D558\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li> '),
unistr('  <li>\B808\C774\BE14 \CD95 \C81C\BAA9 - \B808\C774\BE14 \CD95\C5D0 \D45C\C2DC\B418\B294 \C81C\BAA9\C744 \C785\B825\D569\B2C8\B2E4.</li> '),
unistr('  <li>\D558\C704 - \D558\C704 \AC12\C744 \D3EC\D568\D558\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4(\BC94\C704 \BC0F \C8FC\C2DD \CC28\D2B8 \C804\C6A9).</li> '),
unistr('  <li>\B110 - \C815\B82C \AE30\C900 \C18D\C131\ACFC \AD00\B828\D558\C5EC \B110\C774 \C544\B2CC \AC12\C744 \AC00\C9C4 \B808\CF54\B4DC\B97C \AE30\C900\C73C\B85C \B110 \AC12\C744 \AC00\C9C4 \B808\CF54\B4DC\B97C \C815\B82C\D560 \BC29\BC95\C744 \C9C0\C815\D569\B2C8\B2E4.</li> '),
unistr('  <li>\C624\D508 - \C77C\BCC4 \C8FC\C2DD \C2DC\AC00\B97C \D3EC\D568\D558\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4(\C8FC\C2DD \CC28\D2B8 \C804\C6A9).</li> '),
unistr('  <li>\BC29\D5A5 - \CC28\D2B8 \C694\C18C(\C608: \B9C9\B300)\B97C \C138\B85C\B85C \D45C\C2DC\D560\C9C0 \AC00\B85C\B85C \D45C\C2DC\D560\C9C0 \C5EC\BD80\B97C \C120\D0DD\D569\B2C8\B2E4.</li> '),
unistr('  <li>\ACC4\C5F4 - \B2E4\C911 \ACC4\C5F4 \B3D9\C801 \C9C8\C758\B97C \C815\C758\D558\B294 \B370 \C0AC\C6A9\B418\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li> '),
unistr('  <li>\C2A4\D0DD - \B370\C774\D130 \D56D\BAA9\C774 \B204\C801\B418\B294\C9C0 \C5EC\BD80\B97C \C9C0\C815\D569\B2C8\B2E4.</li> '),
unistr('  <li>\C815\B82C \AE30\C900 - \CC28\D2B8\B97C \B808\C774\BE14\C744 \AE30\C900\C73C\B85C \C815\B82C\D560\C9C0 \AC12\C744 \AE30\C900\C73C\B85C \C815\B82C\D560\C9C0 \C5EC\BD80\B97C \C120\D0DD\D569\B2C8\B2E4.</li> '),
unistr('  <li>\BAA9\D45C - \C774 \CC28\D2B8\C758 \BAA9\D45C \AC12\C744 \C815\C758\D558\B294 \B370 \C0AC\C6A9\D560 \C5F4 \C774\B984\C744 \C120\D0DD\D569\B2C8\B2E4. \C124\C815\B418\BA74 \AC12 \C18D\C131\C740 \C870\AC01 \B0B4\C5D0\C11C \CC44\C6CC\C9C4 \C601\C5ED\C744 \C815\C758\D558\ACE0 \C774\AC83\C740 \C804\CCB4 \C870\AC01\C758 \AC12\C744 \B098\D0C0\B0C5\B2C8\B2E4(\D37C\B110 \CC28\D2B8 \C804\C6A9).</li> '),
unistr('  <li>\AC12 - \D50C\B85C\D305\D560 \B370\C774\D130\B97C \D3EC\D568\D558\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li> '),
unistr('  <li>\AC12 \CD95 \C81C\BAA9 - \AC12 \CD95\C5D0 \D45C\C2DC\B418\B294 \C81C\BAA9\C744 \C785\B825\D569\B2C8\B2E4.</li> '),
unistr('  <li>\AC70\B798\B7C9 - \C77C\BCC4 \C8FC\C2DD \AC70\B798\B7C9\C744 \D3EC\D568\D558\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4(\C8FC\C2DD \CC28\D2B8 \C804\C6A9).</li> '),
unistr('  <li>X - \C774 \CC28\D2B8\C5D0 \B300\D55C X\CD95 \AC12\C744 \D3EC\D568\D558\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4(\BC84\BE14 \BC0F \C0B0\D3EC \CC28\D2B8 \C804\C6A9).</li> '),
unistr('  <li>Y - \C774 \CC28\D2B8\C5D0 \B300\D55C Y\CD95 \AC12\C744 \D3EC\D568\D558\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4(\BC84\BE14 \BC0F \C0B0\D3EC \CC28\D2B8 \C804\C6A9).</li> '),
unistr('  <li>Z - \B9C9\B300 \B108\BE44 \B610\B294 \BC84\BE14 \BC18\C9C0\B984\C744 \D3EC\D568\D558\B294 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4(\B9C9\B300, \BC84\BE14 \BC0F \BC94\C704 \CC28\D2B8 \C804\C6A9).</li> '),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282056998017870718)
,p_name=>'APEX.IG.HELP.CHART_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282051893530870714)
,p_name=>'APEX.IG.HELP.COLUMNS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \D45C\C2DC\B418\B294 \C5F4 \BC0F \C21C\C11C\B97C \C120\D0DD\D569\B2C8\B2E4.</p>'),
'',
unistr('<p>\C5F4\C744 \C120\D0DD \D574\C81C\D558\C5EC \C228\AE41\B2C8\B2E4.<br>'),
unistr('\C704\B85C \C774\B3D9( &uarr; ) \B610\B294 \C544\B798\B85C \C774\B3D9( &darr; )\C744 \B20C\B7EC\C11C \C5F4\C744 \C7AC\C815\B82C\D569\B2C8\B2E4.<br>'),
unistr('\B4DC\B86D\B2E4\C6B4 \C120\D0DD\AE30\B97C \C0AC\C6A9\D558\C5EC \BAA8\B4E0 \C5F4, \D45C\C2DC\B41C \C5F4 \B610\B294 \D45C\C2DC\B418\C9C0 \C54A\C740 \C5F4\C744 \B098\C5F4\D569\B2C8\B2E4.</p>'),
'',
unistr('<p>\D3FC\C744 \C0AC\C6A9\D558\C5EC \C5F4\C758 \CD5C\C18C \B108\BE44(\D53D\C140)\B97C \C9C0\C815\D569\B2C8\B2E4(\C120\D0DD\C0AC\D56D).</p>'),
'',
unistr('<p><em>\CC38\ACE0: \C5F4 \BA38\B9AC\AE00\C758 \B9E8 \C55E\C5D0 \C788\B294 \B04C\AE30 \D578\B4E4\C744 \B204\B974\ACE0 \C5F4\C744 \C67C\CABD \B610\B294 \C624\B978\CABD\C73C\B85C \B04C\C5B4\C11C \D45C\C2DC\B41C \C5F4\C744 \C7AC\C815\B82C\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4. \BA38\B9AC\AE00 \C0AC\C774\C758 \C5F4 \AD6C\BD84 \AE30\D638\B97C \C120\D0DD\D558\ACE0 \C67C\CABD \B610\B294 \C624\B978\CABD\C73C\B85C \C774\B3D9\D558\C5EC \D45C\C2DC\B41C \C5F4\C758 \B108\BE44\B97C \BCC0\ACBD\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</em</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282056896662870717)
,p_name=>'APEX.IG.HELP.COLUMNS_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282052260077870715)
,p_name=>'APEX.IG.HELP.COMPUTE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \AE30\C874 \C5F4\C5D0 \B300\D574 \C218\D589\B41C \C218\D559 \BC0F \D568\C218 \ACC4\C0B0\C744 \AE30\C900\C73C\B85C \CD94\AC00 \C5F4\C744 \C815\C758\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\ACC4\C0B0 \BAA9\B85D</strong><br>'),
unistr('\ACC4\C0B0 \BAA9\B85D\C5D0\B294 \C815\C758\B41C \ACC4\C0B0\C774 \D45C\C2DC\B429\B2C8\B2E4. \ACC4\C0B0\C744 \C120\D0DD \D574\C81C\D558\C5EC \AE30\C874 \ACC4\C0B0\C744 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\D569\B2C8\B2E4.<br>'),
unistr('\C0C8 \ACC4\C0B0\C744 \CD94\AC00\D558\B824\BA74 \CD94\AC00( &plus; )\B97C \B204\B974\ACE0, \AE30\C874 \ACC4\C0B0\C744 \C81C\AC70\D558\B824\BA74 \C0AD\C81C( &minus; )\B97C \B204\B985\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\ACC4\C0B0 \C124\C815</strong><br>'),
unistr('\D3FC\C744 \C0AC\C6A9\D558\C5EC \ACC4\C0B0\C744 \C815\C758\D569\B2C8\B2E4.<br>'),
unistr('\C5F4 \C138\BD80\C815\BCF4(\C608: \BA38\B9AC\AE00, \B808\C774\BE14)\B97C \C785\B825\D558\ACE0 \C815\B82C \C124\C815\C744 \C120\D0DD\D569\B2C8\B2E4.<br> '),
unistr('\D45C\D604\C2DD \D14D\C2A4\D2B8 \C601\C5ED\C744 \C0AC\C6A9\D558\C5EC \ACC4\C0B0\C744 \C704\D55C \C5F4 \BC0F \C5F0\ACB0\B41C \D568\C218\B97C \C785\B825\D569\B2C8\B2E4.<br>'),
unistr('\C0C8 \C5F4\C5D0 \B300\D574 \C801\D569\D55C \B370\C774\D130 \C720\D615 \BC0F \D615\C2DD \B9C8\C2A4\D06C(\C120\D0DD\C0AC\D56D)\B97C \C120\D0DD\D569\B2C8\B2E4.</p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282056428803870717)
,p_name=>'APEX.IG.HELP.COMPUTE_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C0B0 \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282052508706870715)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \D558\B098 \C774\C0C1\C758 \C5F4\C5D0 \B300\D55C \C81C\C5B4 \CC28\B2E8\C744 \C815\C758\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\C81C\C5B4 \CC28\B2E8 \BAA9\B85D</strong><br>'),
unistr('\C81C\C5B4 \CC28\B2E8 \BAA9\B85D\C5D0\B294 \C815\C758\B41C \C81C\C5B4 \CC28\B2E8\C774 \D45C\C2DC\B429\B2C8\B2E4. \C81C\C5B4 \CC28\B2E8 \C5F4\C744 \C120\D0DD \D574\C81C\D558\C5EC \AE30\C874 \C81C\C5B4 \CC28\B2E8 \C5F4\C744 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\D569\B2C8\B2E4.<br>'),
unistr('\C81C\C5B4 \CC28\B2E8\C5D0 \C0C8 \C5F4\C744 \D3EC\D568\D558\B824\BA74 \CD94\AC00( &plus; )\B97C \B204\B974\ACE0, \C81C\C5B4 \CC28\B2E8\C5D0\C11C \AE30\C874 \C5F4\C744 \C81C\AC70\D558\B824\BA74 \C0AD\C81C( &minus; )\B97C \B204\B985\B2C8\B2E4.<br>'),
unistr('\C5F4\C744 \C7AC\C815\B82C\D558\B824\BA74 \C704\B85C \C774\B3D9( &uarr; ) \B610\B294 \C544\B798\B85C \C774\B3D9( &darr; )\C744 \B20C\B7EC\C11C \B2E4\B978 \C5F4\C744 \AE30\C900\C73C\B85C \C120\D0DD\B41C \C5F4\C744 \C704 \B610\B294 \C544\B798\B85C \C774\B3D9\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\C81C\C5B4 \CC28\B2E8 \C124\C815</strong><br>'),
unistr('\D3FC\C744 \C0AC\C6A9\D558\C5EC \C81C\C5B4 \CC28\B2E8 \C5F4\C744 \C815\C758\D569\B2C8\B2E4.<br>'),
unistr('\C81C\C5B4 \CC28\B2E8 \C5F4, \C815\B82C \BC29\D5A5 \BC0F \B110 \C5F4(\AC12\C774 \C5C6\B294 \C5F4) \C815\B82C \BC29\BC95\C744 \C120\D0DD\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><em>\CC38\ACE0: \B300\D654\C2DD \ADF8\B9AC\B4DC\B97C \C870\D68C\D560 \B54C \C5F4 \BA38\B9AC\AE00\C744 \B204\B974\ACE0 \C81C\C5B4 \CC28\B2E8 \C544\C774\CF58\C744 \C120\D0DD\D558\C5EC \C81C\C5B4 \CC28\B2E8\C744 \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282056115819870717)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \CC28\B2E8 \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282052758233870715)
,p_name=>'APEX.IG.HELP.DOWNLOAD'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \BAA8\B4E0 \D604\C7AC \D589\C744 \C678\BD80 \D30C\C77C\B85C \B2E4\C6B4\B85C\B4DC\D569\B2C8\B2E4. \B370\C774\D130\C5D0 \C801\C6A9\B41C \D544\D130\C640 \C815\B82C\C744 \C0AC\C6A9\D558\C5EC \D30C\C77C\C5D0\B294 \D604\C7AC \D45C\C2DC\B41C \C5F4\B9CC \D3EC\D568\B429\B2C8\B2E4.</p>'),
'',
unistr('<p>\D30C\C77C \D615\C2DD\C744 \C120\D0DD\D558\ACE0 \B2E4\C6B4\B85C\B4DC\B97C \B204\B985\B2C8\B2E4.<br>'),
unistr('\CC38\ACE0: CSV\C5D0\B294 \D14D\C2A4\D2B8 \D615\C2DD(\C608: \C9D1\ACC4 \BC0F \C81C\C5B4 \CC28\B2E8)\C740 \D3EC\D568\B418\C9C0 \C54A\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\D30C\C77C\C744 \C804\C790\BA54\C77C\B85C \BCF4\B0B4\B824\BA74 \C804\C790\BA54\C77C\B85C \C804\C1A1\C744 \C120\D0DD\D558\ACE0 \C804\C790\BA54\C77C \C138\BD80\C815\BCF4(\C218\C2E0\C790, \C81C\BAA9, \BA54\C2DC\C9C0)\B97C \C785\B825\D569\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282055950614870717)
,p_name=>'APEX.IG.HELP.DOWNLOAD_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C6B4\B85C\B4DC \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282051991568870714)
,p_name=>'APEX.IG.HELP.FILTER'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \BC18\D658\B418\B294 \D589\C744 \C81C\D55C\D558\B294 \B370\C774\D130 \D544\D130\B97C \AD6C\C131\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\D544\D130 \BAA9\B85D</strong><br>'),
unistr('\D544\D130 \BAA9\B85D\C740 \C815\C758\B41C \D544\D130\B97C \D45C\C2DC\D569\B2C8\B2E4. \D544\D130\B97C \C120\D0DD \D574\C81C\D558\C5EC \AE30\C874 \D544\D130\B97C \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\D569\B2C8\B2E4.<br>'),
unistr('\C0C8 \D544\D130\B97C \C0DD\C131\D558\B824\BA74 \CD94\AC00( &plus; )\B97C \B204\B974\ACE0, \AE30\C874 \D544\D130\B97C \C81C\AC70\D558\B824\BA74 \C0AD\C81C( &minus; )\B97C \B204\B985\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\D544\D130 \C124\C815</strong><br>'),
unistr('\D3FC\C744 \C0AC\C6A9\D558\C5EC \D544\D130 \C18D\C131\C744 \C815\C758\D569\B2C8\B2E4.<br>'),
unistr('\C801\D569\D55C \D544\D130 \C720\D615\C744 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('&nbsp;&nbsp;&nbsp;\D589 - \D544\D130\B9C1 \AC00\B2A5\D55C \C5F4\C758 \C6A9\C5B4\C5D0 \B300\D574 \D544\D130\B9C1\D569\B2C8\B2E4.<br>'),
unistr('&nbsp;&nbsp;&nbsp;\C5F4 - \C9C0\C815\B41C \C5F0\C0B0\C790\C640 \AC12\C744 \C0AC\C6A9\D558\C5EC \D2B9\C815 \C5F4\C744 \D544\D130\B9C1\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><em>\CC38\ACE0: \B300\D654\C2DD \ADF8\B9AC\B4DC\B97C \C870\D68C\D560 \B54C \AC80\C0C9 \D544\B4DC\C5D0 \C9C1\C811 \C785\B825\D558\C5EC \D589 \D544\D130\B97C \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4. [\AC80\C0C9\D560 \C5F4 \C120\D0DD]\C744 \B20C\B7EC\C11C \AC80\C0C9\C744 \D2B9\C815 \C5F4\B85C \C81C\D55C\D560 \C218 \C788\C2B5\B2C8\B2E4. \B610\B294 \C5F4 \BA38\B9AC\AE00 \BA54\B274\B97C \C5F4\ACE0 \C5F4 \D544\D130\B97C \C0DD\C131\D560 \AC12\C744 \C120\D0DD\D569\B2C8\B2E4.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282056743812870717)
,p_name=>'APEX.IG.HELP.FILTER_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282052313493870715)
,p_name=>'APEX.IG.HELP.FLASHBACK'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \B370\C774\D130\B97C \C774\C804 \C2DC\C810\C5D0 \C874\C7AC\D55C \ADF8\B300\B85C \BCFC \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\C774\C804 \C2DC\AC04(\BD84)\C744 \C785\B825\D558\C5EC \D50C\B798\C2DC\BC31 \C9C8\C758\B97C \C2E4\D589\D569\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282056300931870717)
,p_name=>'APEX.IG.HELP.FLASHBACK_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\C2DC\BC31 \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282057046159870718)
,p_name=>'APEX.IG.HELP.GROUP_BY_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900 \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282052401056870715)
,p_name=>'APEX.IG.HELP.HIGHLIGHT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \C785\B825\B41C \C870\AC74\C744 \AE30\C900\C73C\B85C \B370\C774\D130 \D589 \B610\B294 \C5F4\C744 \AC15\C870 \D45C\C2DC\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\AC15\C870 \D45C\C2DC \BAA9\B85D</strong><br>'),
unistr('\AC15\C870 \D45C\C2DC \BAA9\B85D\C5D0\B294 \C815\C758\B41C \AC15\C870 \D45C\C2DC\AC00 \D45C\C2DC\B429\B2C8\B2E4. \AC15\C870 \D45C\C2DC\B97C \C120\D0DD \D574\C81C\D558\C5EC \AE30\C874 \AC15\C870 \D45C\C2DC\B97C \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\D569\B2C8\B2E4.<br>'),
unistr('\C0C8 \AC15\C870 \D45C\C2DC\B97C \C0DD\C131\D558\B824\BA74 \CD94\AC00( &plus; )\B97C \B204\B974\ACE0 \AE30\C874 \AC15\C870 \D45C\C2DC\B97C \C81C\AC70\D558\B824\BA74 \C0AD\C81C( &minus; )\B97C \B204\B985\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\AC15\C870 \D45C\C2DC \C124\C815</strong><br>'),
unistr('\D3FC\C744 \C0AC\C6A9\D558\C5EC \AC15\C870 \D45C\C2DC \C18D\C131\C744 \C815\C758\D569\B2C8\B2E4.<br>'),
unistr('\C774\B984\C744 \C785\B825\D558\ACE0, \D589 \B610\B294 \C5F4\C744 \C120\D0DD\D558\ACE0, \BC30\ACBD \BC0F \D14D\C2A4\D2B8\C5D0 \B300\D55C HTML \C0C9\C0C1 \CF54\B4DC\B97C \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('\D2B9\C815 \B370\C774\D130\B97C \AC15\C870 \D45C\C2DC\D558\B294 \B370 \C801\D569\D55C <strong>\C870\AC74 \C720\D615</strong>\C744 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('&nbsp;&nbsp;&nbsp;\D589 - \C5F4\C5D0\C11C \C6A9\C5B4\B97C \AC15\C870 \D45C\C2DC\D569\B2C8\B2E4.<br>'),
unistr('&nbsp;&nbsp;&nbsp;\C5F4 - \C9C0\C815\B41C \C5F0\C0B0\C790 \BC0F \AC12\C744 \AE30\C900\C73C\B85C \D2B9\C815 \C5F4\C758 \B0B4\BD80\B97C \AC15\C870 \D45C\C2DC\D569\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282056244374870717)
,p_name=>'APEX.IG.HELP.HIGHLIGHT_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282052606203870715)
,p_name=>'APEX.IG.HELP.REPORT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \D604\C7AC \ADF8\B9AC\B4DC \B808\C774\C544\C6C3 \BC0F \AD6C\C131\C5D0 \B300\D55C \BCC0\ACBD\C0AC\D56D\C744 \C800\C7A5\D569\B2C8\B2E4.<br>'),
unistr('\C560\D50C\B9AC\CF00\C774\C158 \AC1C\BC1C\C790\B294 \C5EC\B7EC \B300\CCB4 \BCF4\ACE0\C11C \B808\C774\C544\C6C3\C744 \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4. \D5C8\C6A9\B418\B294 \ACBD\C6B0 \C0AC\C6A9\C790\C640 \B2E4\B978 \C77C\BC18 \C0AC\C6A9\C790\AC00 \BCF4\ACE0\C11C\B97C \ACF5\C6A9\C73C\B85C \C800\C7A5\D560 \C218 \C788\C2B5\B2C8\B2E4. \ADF8\B7EC\BA74 \BAA8\B4E0 \ADF8\B9AC\B4DC \C0AC\C6A9\C790\AC00 \BCF4\ACE0\C11C\B97C \C0AC\C6A9\D560 \C218 \C788\C2B5\B2C8\B2E4. \BCF4\ACE0\C11C\B97C \BCF8\C778\B9CC \BCFC \C218 \C788\B3C4\B85D \C804\C6A9 \BCF4\ACE0\C11C\B85C \C800\C7A5\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\C0AC\C6A9 \AC00\B2A5\D55C \C720\D615\C744 \C120\D0DD\D558\ACE0 \C800\C7A5\B41C \BCF4\ACE0\C11C\C5D0 \B300\D55C \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282056065306870717)
,p_name=>'APEX.IG.HELP.REPORT_TITLE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\BCF4\ACE0\C11C \B3C4\C6C0\B9D0'),
''))
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282052057328870715)
,p_name=>'APEX.IG.HELP.SORT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C0C1\C790\B97C \C0AC\C6A9\D558\C5EC \D45C\C2DC \C21C\C11C\B97C \C124\C815\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\BAA9\B85D \C815\B82C</strong><br>'),
unistr('\C815\B82C \B300\D654\C0C1\C790\C5D0\B294 \AD6C\C131\B41C \C815\B82C \ADDC\CE59 \BAA9\B85D\C774 \D45C\C2DC\B429\B2C8\B2E4.<br>'),
unistr('\C815\B82C \C5F4\C744 \C0DD\C131\D558\B824\BA74 \CD94\AC00( &plus; )\B97C \B204\B974\ACE0 \C815\B82C \C5F4\C744 \C81C\AC70\D558\B824\BA74 \C0AD\C81C( &minus; )\B97C \B204\B985\B2C8\B2E4.<br>'),
unistr('\C704\B85C \C774\B3D9( &uarr; ) \BC0F \C544\B798\B85C \C774\B3D9( &darr; )\C744 \B20C\B7EC\C11C \B2E4\B978 \C815\B82C \C5F4\C744 \AE30\C900\C73C\B85C \C120\D0DD\D55C \C5F4\C744 \C704 \B610\B294 \C544\B798\B85C \C774\B3D9\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\C815\B82C \C124\C815</strong><br>'),
unistr('\C815\B82C \C5F4, \C815\B82C \BC29\D5A5 \BC0F \B110 \C5F4(\AC12\C774 \C5C6\B294 \C5F4) \C815\B82C \BC29\BC95\C744 \C120\D0DD\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><em>\CC38\ACE0: \D45C\C2DC\B418\C9C0 \C54A\C740 \C5F4\C744 \AE30\C900\C73C\B85C \B370\C774\D130\B97C \C815\B82C\D560 \C218 \C788\C9C0\B9CC, \C774 \ACBD\C6B0 \C77C\BD80 \C5F4\C774 \C815\B82C\B418\C9C0 \C54A\C744 \C218 \C788\C2B5\B2C8\B2E4.</em><br>'),
unistr('<em>\C5F4 \BA38\B9AC\AE00\C758 \B9E8 \B05D\C5D0 \C788\B294 \C704\CABD(\C624\B984\CC28\C21C) \B610\B294 \C544\B798\CABD(\B0B4\B9BC\CC28\C21C) \D654\C0B4\D45C\B97C \B20C\B7EC\C11C \D45C\C2DC\B41C \C5F4\C744 \C815\B82C\D560 \C218 \C788\C2B5\B2C8\B2E4. \AE30\C874 \C815\B82C\C5D0 \D6C4\C18D \C5F4\C744 \CD94\AC00\D558\B824\BA74 Shift \D0A4\B97C \B204\B974\ACE0 \C704\CABD \B610\B294 \C544\B798\CABD \D654\C0B4\D45C\B97C \B204\B985\B2C8\B2E4.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282056689219870717)
,p_name=>'APEX.IG.HELP.SORT_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282055899450870717)
,p_name=>'APEX.IG.HELP.SUBSCRIPTION_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\C6A9 \B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281601115951870441)
,p_name=>'APEX.IG.HIDE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C228\AE30\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281334157916870265)
,p_name=>'APEX.IG.HIGHLIGHT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282027219236870700)
,p_name=>'APEX.IG.HIGH_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\C704')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282028082380870700)
,p_name=>'APEX.IG.HORIZONTAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\D3C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281577302831870426)
,p_name=>'APEX.IG.HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281595001504870437)
,p_name=>'APEX.IG.ICON'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\C774\CF58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281333087198870264)
,p_name=>'APEX.IG.ICON_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\C774\CF58 \BCF4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281575339136870425)
,p_name=>'APEX.IG.IN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C5D0 \C18D\D568')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281600794336870440)
,p_name=>'APEX.IG.INACTIVE_SETTING'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\D65C\C131 \C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281600817710870440)
,p_name=>'APEX.IG.INACTIVE_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\D65C\C131 \C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281648102340870469)
,p_name=>'APEX.IG.INTERNAL_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \ADF8\B9AC\B4DC \C694\CCAD\C744 \CC98\B9AC\D558\B294 \C911 \B0B4\BD80 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282055358289870717)
,p_name=>'APEX.IG.INVALID_DATE_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \B0A0\C9DC \D615\C2DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282065931706870723)
,p_name=>'APEX.IG.INVALID_SETTING'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282066010151870723)
,p_name=>'APEX.IG.INVALID_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282041737191870708)
,p_name=>'APEX.IG.INVALID_SORT_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C \AE30\C900\C774 %0(\C73C)\B85C \C124\C815\B418\C5B4 \C788\C9C0\B9CC %0\C5D0 \B300\D574 \C120\D0DD\B41C \C5F4\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282034831355870704)
,p_name=>'APEX.IG.INVALID_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282023010548870697)
,p_name=>'APEX.IG.INVISIBLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC\B418\C9C0 \C54A\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281576133007870425)
,p_name=>'APEX.IG.IN_THE_LAST'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\ADFC \AE30\AC04\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281576318945870425)
,p_name=>'APEX.IG.IN_THE_NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C5D0\C11C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281575246656870425)
,p_name=>'APEX.IG.IS_NOT_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\C5B4 \C788\C9C0 \C54A\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281575130840870425)
,p_name=>'APEX.IG.IS_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\C5B4 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282043001527870709)
,p_name=>'APEX.IG.LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282026515766870699)
,p_name=>'APEX.IG.LABEL_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282034045242870704)
,p_name=>'APEX.IG.LAST'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C9C0\B9C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281474082078870362)
,p_name=>'APEX.IG.LAST.DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C \C77C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281474283319870362)
,p_name=>'APEX.IG.LAST.HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C \C2DC\AC04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281474794727870362)
,p_name=>'APEX.IG.LAST.MINUTE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C 1\BD84')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281473708371870362)
,p_name=>'APEX.IG.LAST.MONTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C \C6D4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281473888916870362)
,p_name=>'APEX.IG.LAST.WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C \C8FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281473912285870362)
,p_name=>'APEX.IG.LAST.X_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C %0\C77C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281474182367870362)
,p_name=>'APEX.IG.LAST.X_HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C %0\C2DC\AC04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281474886231870362)
,p_name=>'APEX.IG.LAST.X_MINUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C %0\BD84')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281474683518870362)
,p_name=>'APEX.IG.LAST.X_MONTHS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C %0\AC1C\C6D4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281474582131870362)
,p_name=>'APEX.IG.LAST.X_WEEKS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C %0\C8FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281473596555870362)
,p_name=>'APEX.IG.LAST.X_YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C %0\B144')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281473699587870362)
,p_name=>'APEX.IG.LAST.YEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C \C5F0\B3C4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282043227799870709)
,p_name=>'APEX.IG.LAYOUT_ALIGN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C140 \B9DE\CDA4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282043344138870709)
,p_name=>'APEX.IG.LAYOUT_USEGROUPFOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \C6A9\B3C4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281575755102870425)
,p_name=>'APEX.IG.LESS_THAN'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\B2E4 \C791\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281575813893870425)
,p_name=>'APEX.IG.LESS_THAN_OR_EQUALS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\B2E4 \C791\AC70\B098 \AC19\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282028674539870700)
,p_name=>'APEX.IG.LINE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282028799334870700)
,p_name=>'APEX.IG.LINE_WITH_AREA'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\ACFC \C601\C5ED')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282043679431870709)
,p_name=>'APEX.IG.LISTAGG'
,p_message_language=>'ko'
,p_message_text=>'Listagg'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282027380440870700)
,p_name=>'APEX.IG.LOW_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D558\D55C\AC00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282049284542870713)
,p_name=>'APEX.IG.MAILADDRESSES_COMMASEP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC\C18C\AC00 \C5EC\B7EC \AC1C\C77C \ACBD\C6B0 \CF64\B9C8\B85C \AD6C\BD84\D558\C2ED\C2DC\C624')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281576939325870426)
,p_name=>'APEX.IG.MATCHES_REGULAR_EXPRESSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\ADDC \D45C\D604\C2DD \C77C\CE58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281940815119870647)
,p_name=>'APEX.IG.MAX'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300\AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282070369909870726)
,p_name=>'APEX.IG.MAX_OVERALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \CD5C\B300\AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281941011794870647)
,p_name=>'APEX.IG.MEDIAN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\AC04\AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282070409252870726)
,p_name=>'APEX.IG.MEDIAN_OVERALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \C911\AC04\AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281940795471870647)
,p_name=>'APEX.IG.MIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C18C\AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281577229748870426)
,p_name=>'APEX.IG.MINUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281942595462870648)
,p_name=>'APEX.IG.MINUTES_AGO'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84 \C804')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282070202142870726)
,p_name=>'APEX.IG.MIN_OVERALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \CD5C\C18C\AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281577868239870426)
,p_name=>'APEX.IG.MONTHS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6D4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281601005233870441)
,p_name=>'APEX.IG.MORE_DATA_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\B294 \D5C8\C6A9\B418\B294 \CD5C\B300\AC12\C744 \CD08\ACFC\D558\B294 %0 \C774\C0C1\C758 \D589\C744 \D3EC\D568\D569\B2C8\B2E4. \ACB0\ACFC\B97C \BCF4\B824\BA74 \CD94\AC00 \D544\D130\B97C \C801\C6A9\D558\C2ED\C2DC\C624.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281593003049870436)
,p_name=>'APEX.IG.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B984')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281593240829870436)
,p_name=>'APEX.IG.NAMED_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B984\C774 \C9C0\C815\B41C \BCF4\ACE0\C11C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281472990517870361)
,p_name=>'APEX.IG.NEXT.DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C77C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281472758124870361)
,p_name=>'APEX.IG.NEXT.HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C2DC\AC04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281474956947870363)
,p_name=>'APEX.IG.NEXT.MINUTE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C 1\BD84')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281473216549870362)
,p_name=>'APEX.IG.NEXT.MONTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C6D4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281473137006870361)
,p_name=>'APEX.IG.NEXT.WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C8FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281473087889870361)
,p_name=>'APEX.IG.NEXT.X_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\C77C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281472869672870361)
,p_name=>'APEX.IG.NEXT.X_HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\C2DC\AC04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281475074055870363)
,p_name=>'APEX.IG.NEXT.X_MINUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\BD84')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281474378177870362)
,p_name=>'APEX.IG.NEXT.X_MONTHS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\AC1C\C6D4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281474449147870362)
,p_name=>'APEX.IG.NEXT.X_WEEKS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\C8FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281473446111870362)
,p_name=>'APEX.IG.NEXT.X_YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\B144')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281473321704870362)
,p_name=>'APEX.IG.NEXT.YEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C5F0\B3C4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281576064372870425)
,p_name=>'APEX.IG.NOT_BETWEEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C0AC\C774\AC00 \C544\B2D8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281575098219870425)
,p_name=>'APEX.IG.NOT_EQUALS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC19\C9C0 \C54A\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282095446167870741)
,p_name=>'APEX.IG.NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('ID %0\C758 \C601\C5ED\C740 \B300\D654\C2DD \ADF8\B9AC\B4DC \C601\C5ED\C774 \C544\B2C8\AC70\B098 %1 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281575415775870425)
,p_name=>'APEX.IG.NOT_IN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C5D0 \C18D\D558\C9C0 \C54A\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281576282573870425)
,p_name=>'APEX.IG.NOT_IN_THE_LAST'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\ADFC \AE30\AC04\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281576490947870426)
,p_name=>'APEX.IG.NOT_IN_THE_NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \AE30\AC04\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281600922476870440)
,p_name=>'APEX.IG.NO_DATA_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282033894731870704)
,p_name=>'APEX.IG.NULLS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B110')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282043892929870710)
,p_name=>'APEX.IG.NUMBER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C22B\C790')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282034350014870704)
,p_name=>'APEX.IG.OFF'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282034433805870704)
,p_name=>'APEX.IG.ON'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281558424456870415)
,p_name=>'APEX.IG.ONE_MINUTE_AGO'
,p_message_language=>'ko'
,p_message_text=>unistr('1\BD84 \C804')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282051522522870714)
,p_name=>'APEX.IG.OPEN_COLORPICKER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4\B9B0 \C0C9\C0C1 \C120\D0DD\AE30: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282027096353870699)
,p_name=>'APEX.IG.OPEN_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281594175729870436)
,p_name=>'APEX.IG.OPERATOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F0\C0B0\C790')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282026422819870699)
,p_name=>'APEX.IG.ORIENTATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC29\D5A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282028875055870700)
,p_name=>'APEX.IG.PIE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C774')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281595444925870437)
,p_name=>'APEX.IG.PIVOT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281333374356870264)
,p_name=>'APEX.IG.PIVOT_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97 \BCF4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282051464813870714)
,p_name=>'APEX.IG.PLACEHOLDER_INVALUES'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12\C744 "%0"(\C73C)\B85C \AD6C\BD84')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282028946485870701)
,p_name=>'APEX.IG.POLAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF9\C120')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282042784541870709)
,p_name=>'APEX.IG.POSITION_CENTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\C6B4\B370')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282042855560870709)
,p_name=>'APEX.IG.POSITION_END'
,p_message_language=>'ko'
,p_message_text=>unistr('\B05D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282042639693870709)
,p_name=>'APEX.IG.POSITION_START'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C791')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281593327426870436)
,p_name=>'APEX.IG.PRIMARY'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281593687173870436)
,p_name=>'APEX.IG.PRIMARY_DEFAULT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \AE30\BCF8\AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281888686550870615)
,p_name=>'APEX.IG.PRIMARY_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \BCF4\ACE0\C11C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282029019487870701)
,p_name=>'APEX.IG.RADAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC29\C0AC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282029111514870701)
,p_name=>'APEX.IG.RANGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC94\C704')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282052906736870715)
,p_name=>'APEX.IG.REFRESH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8\B85C\ACE0\CE68')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281601753025870441)
,p_name=>'APEX.IG.REFRESH_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C0C8\B85C\ACE0\CE68')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281600589474870440)
,p_name=>'APEX.IG.REFRESH_ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C0C8\B85C\ACE0\CE68')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281334893220870265)
,p_name=>'APEX.IG.REMOVE_CONTROL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\AC70 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281592787224870436)
,p_name=>'APEX.IG.REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282086105298870735)
,p_name=>'APEX.IG.REPORT.DELETED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\AC00 \C0AD\C81C\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282085860640870735)
,p_name=>'APEX.IG.REPORT.SAVED.ALTERNATIVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C0AC\C6A9\C790\C5D0 \B300\D55C \B300\CCB4 \BCF4\ACE0\C11C\AC00 \C800\C7A5\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282085735507870735)
,p_name=>'APEX.IG.REPORT.SAVED.DEFAULT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C0AC\C6A9\C790\C5D0 \B300\D55C \AE30\BCF8 \BCF4\ACE0\C11C\AC00 \C800\C7A5\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282086078525870735)
,p_name=>'APEX.IG.REPORT.SAVED.PRIVATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C6A9 \BCF4\ACE0\C11C\AC00 \C800\C7A5\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282085961780870735)
,p_name=>'APEX.IG.REPORT.SAVED.PUBLIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C0AC\C6A9\C790\C5D0 \B300\D55C \ACF5\C6A9 \BCF4\ACE0\C11C\AC00 \C800\C7A5\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281558334424870415)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF.X.MINUTES_AGO'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\BD84 \C804\C758 \BCF4\ACE0\C11C \B370\C774\D130\C785\B2C8\B2E4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281558275955870414)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF_ONE_MINUTE_AGO'
,p_message_language=>'ko'
,p_message_text=>unistr('1\BD84 \C804\C758 \BCF4\ACE0\C11C \B370\C774\D130')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282057305039870718)
,p_name=>'APEX.IG.REPORT_EDIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C - \D3B8\C9D1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282057214465870718)
,p_name=>'APEX.IG.REPORT_SAVE_AS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C - \B2E4\B978 \C774\B984\C73C\B85C \C800\C7A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281334904917870265)
,p_name=>'APEX.IG.REPORT_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282095500652870741)
,p_name=>'APEX.IG.REPORT_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\C801 ID %0(\C73C)\B85C \C800\C7A5\B41C \B300\D654\C2DD \ADF8\B9AC\B4DC\AC00 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282069694894870725)
,p_name=>'APEX.IG.REPORT_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \BCF4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281334006572870265)
,p_name=>'APEX.IG.RESET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C7AC\C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281601845199870441)
,p_name=>'APEX.IG.REVERT_CHANGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\ACBD\C0AC\D56D \BCF5\C6D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281600668644870440)
,p_name=>'APEX.IG.REVERT_ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \BCF5\C6D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281593744664870436)
,p_name=>'APEX.IG.ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281592646161870435)
,p_name=>'APEX.IG.ROWS_PER_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\B2F9 \D589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282094134254870740)
,p_name=>'APEX.IG.ROW_ACTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C791\C5C5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282101341876870745)
,p_name=>'APEX.IG.ROW_ACTIONS_FOR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D589\C5D0 \B300\D55C \C791\C5C5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281334380660870265)
,p_name=>'APEX.IG.SAVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281676761890870486)
,p_name=>'APEX.IG.SAVED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281332560755870264)
,p_name=>'APEX.IG.SAVED_REPORTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5\B41C \BCF4\ACE0\C11C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281332609228870264)
,p_name=>'APEX.IG.SAVED_REPORT_DEFAULT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281332723988870264)
,p_name=>'APEX.IG.SAVED_REPORT_PRIVATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C6A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281332811823870264)
,p_name=>'APEX.IG.SAVED_REPORT_PUBLIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACF5\C6A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282069360163870725)
,p_name=>'APEX.IG.SAVE_AS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\B978 \C774\B984\C73C\B85C \C800\C7A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281599947710870440)
,p_name=>'APEX.IG.SAVE_REPORT_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C124\C815 \C800\C7A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282029211162870701)
,p_name=>'APEX.IG.SCATTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0B0\D3EC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281332419118870264)
,p_name=>'APEX.IG.SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282048019325870712)
,p_name=>'APEX.IG.SEARCH.ALL_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9: \BAA8\B4E0 \D14D\C2A4\D2B8 \C5F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281332338882870263)
,p_name=>'APEX.IG.SEARCH.COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282046846338870711)
,p_name=>'APEX.IG.SEARCH.ORACLE_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9: \C804\CCB4 \D14D\C2A4\D2B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281558140152870414)
,p_name=>'APEX.IG.SEARCH_FOR.X'
,p_message_language=>'ko'
,p_message_text=>unistr('''%0'' \AC80\C0C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282022719238870697)
,p_name=>'APEX.IG.SELECT'
,p_message_language=>'ko'
,p_message_text=>unistr('- \C120\D0DD -')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281396905208870309)
,p_name=>'APEX.IG.SELECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281995576891870680)
,p_name=>'APEX.IG.SELECT_1_ROW_IN_MASTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \C601\C5ED\C5D0\C11C 1\AC1C\C758 \D589 \C120\D0DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281332205350870263)
,p_name=>'APEX.IG.SELECT_COLUMNS_TO_SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9\D560 \C5F4\C744 \C120\D0DD\D558\C2ED\C2DC\C624.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282093170912870740)
,p_name=>'APEX.IG.SEL_ACTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD \C791\C5C5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281397124407870309)
,p_name=>'APEX.IG.SEL_MODE_CELL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C140 \C120\D0DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281397003243870309)
,p_name=>'APEX.IG.SEL_MODE_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C120\D0DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282048631197870712)
,p_name=>'APEX.IG.SEND_AS_EMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C\B85C \C804\C1A1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282032102084870702)
,p_name=>'APEX.IG.SERIES_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C5F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281293156121870238)
,p_name=>'APEX.IG.SHOW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281908088321870627)
,p_name=>'APEX.IG.SHOW_OVERALL_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \AC12 \D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281601476472870441)
,p_name=>'APEX.IG.SINGLE_ROW_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\C77C \D589 \BCF4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281595672989870437)
,p_name=>'APEX.IG.SORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282032291140870703)
,p_name=>'APEX.IG.SORT_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C \AE30\C900')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282094229682870740)
,p_name=>'APEX.IG.SORT_ONLY_ONE_PER_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4\B2F9 \D558\B098\C758 \C815\B82C\B9CC \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282093379158870740)
,p_name=>'APEX.IG.SRV_CHANGE_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\BA54\B274 \BCC0\ACBD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282034517768870704)
,p_name=>'APEX.IG.STACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\B204\C801')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281576750385870426)
,p_name=>'APEX.IG.STARTS_WITH'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C73C\B85C \C2DC\C791')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282029345782870701)
,p_name=>'APEX.IG.STOCK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC\C2DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281221844513870193)
,p_name=>'APEX.IG.STRETCH_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \B108\BE44 \B298\C774\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281600149641870440)
,p_name=>'APEX.IG.SUBSCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\C785')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281940663911870647)
,p_name=>'APEX.IG.SUM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D569\ACC4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282101551488870745)
,p_name=>'APEX.IG.SUMMARY'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \ADF8\B9AC\B4DC\C785\B2C8\B2E4. \BCF4\ACE0\C11C: %0, \BDF0: %1.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282069759034870725)
,p_name=>'APEX.IG.SUM_OVERALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \D569\ACC4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282027527320870700)
,p_name=>'APEX.IG.TARGET_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282041909052870708)
,p_name=>'APEX.IG.TEXT_COLOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14D\C2A4\D2B8 \C0C9\C0C1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281335099758870265)
,p_name=>'APEX.IG.TOGGLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1A0\AE00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281907902969870627)
,p_name=>'APEX.IG.TOOLTIP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3C4\AD6C \C124\BA85')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281592894070870436)
,p_name=>'APEX.IG.TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C720\D615')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281601316607870441)
,p_name=>'APEX.IG.UNFREEZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\C815 \D574\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281594377817870436)
,p_name=>'APEX.IG.UNIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\C704')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282048439681870712)
,p_name=>'APEX.IG.UNSAVED_CHANGES_CONTINUE_CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5\B418\C9C0 \C54A\C740 \BCC0\ACBD\C0AC\D56D\C774 \C788\C2B5\B2C8\B2E4. \ACC4\C18D\D558\ACA0\C2B5\B2C8\AE4C?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281594209024870436)
,p_name=>'APEX.IG.VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282026643708870699)
,p_name=>'APEX.IG.VALUE_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282035648975870705)
,p_name=>'APEX.IG.VALUE_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12\C774 \D544\C694\D569\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281980191739870671)
,p_name=>'APEX.IG.VALUE_TIMESTAMP_TZ'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12(\C2DC\AC04\B300\B97C \BCC0\ACBD\D560 \C218 \C5C6\C74C)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282043960117870710)
,p_name=>'APEX.IG.VARCHAR2'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14D\C2A4\D2B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282027915193870700)
,p_name=>'APEX.IG.VERTICAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\C9C1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281592334126870435)
,p_name=>'APEX.IG.VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282022855674870697)
,p_name=>'APEX.IG.VISIBLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282027461372870700)
,p_name=>'APEX.IG.VOLUME_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC70\B798\B7C9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281577753788870426)
,p_name=>'APEX.IG.WEEKS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282022994287870697)
,p_name=>'APEX.IG.WIDTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C18C \C5F4 \B108\BE44(\D53D\C140)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281507966078870383)
,p_name=>'APEX.IG.X.BETWEEN.Y.AND.Z'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) %1 \BC0F %2 \C0AC\C774')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281507646204870383)
,p_name=>'APEX.IG.X.CONTAINS.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\C744 \D3EC\D568\D568 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281507781628870383)
,p_name=>'APEX.IG.X.DOES_NOT_CONTAIN.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\C744 \D3EC\D568\D558\C9C0 \C54A\C74C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281289332040870236)
,p_name=>'APEX.IG.X.DOES_NOT_START_WITH.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) %1(\C73C)\B85C \C2DC\C791\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281506453442870382)
,p_name=>'APEX.IG.X.EQUALS.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\ACFC \AC19\C74C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281506631615870382)
,p_name=>'APEX.IG.X.GREATER_THAN.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\BCF4\B2E4 \D07C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281506724217870382)
,p_name=>'APEX.IG.X.GREATER_THAN_OR_EQUALS.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\BCF4\B2E4 \D06C\AC70\B098 \AC19\C74C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281507409166870383)
,p_name=>'APEX.IG.X.IN.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\C5D0 \C18D\D568 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281508630827870383)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\C77C \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281508403863870383)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\C2DC\AC04 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281508214449870383)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MINUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\BD84 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281509060351870384)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MONTHS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\AC1C\C6D4 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281508869107870383)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.WEEKS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\C8FC \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281509218883870384)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\B144 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281508597270870383)
,p_name=>'APEX.IG.X.IN_THE_LAST_DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\C77C \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281508356811870383)
,p_name=>'APEX.IG.X.IN_THE_LAST_HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\C2DC\AC04 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281508145766870383)
,p_name=>'APEX.IG.X.IN_THE_LAST_MINUTE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\BD84 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281508992478870384)
,p_name=>'APEX.IG.X.IN_THE_LAST_MONTH'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\AC1C\C6D4 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281508744484870383)
,p_name=>'APEX.IG.X.IN_THE_LAST_WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\C8FC \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281509144328870384)
,p_name=>'APEX.IG.X.IN_THE_LAST_YEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\B144 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281511075922870385)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\C77C \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281510817328870385)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\C2DC\AC04 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281510655623870385)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\BD84 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281511400326870385)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\AC1C\C6D4 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281511221630870385)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\C8FC \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281511601262870386)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\B144 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281510971679870385)
,p_name=>'APEX.IG.X.IN_THE_NEXT_DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\C77C \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281510751243870385)
,p_name=>'APEX.IG.X.IN_THE_NEXT_HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\C2DC\AC04 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281510514101870385)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MINUTE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\BD84 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281511388777870385)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MONTH'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\AC1C\C6D4 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281511118487870385)
,p_name=>'APEX.IG.X.IN_THE_NEXT_WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\C8FC \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281511566641870386)
,p_name=>'APEX.IG.X.IN_THE_NEXT_YEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\B144 \C774\B0B4\C5D0 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281507138860870382)
,p_name=>'APEX.IG.X.IS_NOT_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \BE44\C5B4 \C788\C9C0 \C54A\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281507072442870382)
,p_name=>'APEX.IG.X.IS_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \BE44\C5B4 \C788\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281506874681870382)
,p_name=>'APEX.IG.X.LESS_THAN.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\BCF4\B2E4 \C791\C74C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281506948930870382)
,p_name=>'APEX.IG.X.LESS_THAN_OR_EQUALS.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\BCF4\B2E4 \C791\AC70\B098 \AC19\C74C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281507293422870382)
,p_name=>'APEX.IG.X.LIKE.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\ACFC \C720\C0AC\D568 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281507857564870383)
,p_name=>'APEX.IG.X.MATCHES_REGULAR_EXPRESSION.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C \C815\ADDC \D45C\D604\C2DD\ACFC \C77C\CE58\D568 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281558596759870415)
,p_name=>'APEX.IG.X.MINUTES_AGO'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\BD84 \C804')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281508047670870383)
,p_name=>'APEX.IG.X.NOT_BETWEEN.Y.AND.Z'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) %1 \BC0F %2 \C0AC\C774 \C544\B2D8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281506588365870382)
,p_name=>'APEX.IG.X.NOT_EQUALS.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\ACFC \AC19\C9C0 \C54A\C74C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281507590879870383)
,p_name=>'APEX.IG.X.NOT_IN.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\C5D0 \C18D\D558\C9C0 \C54A\C74C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281509887816870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\C77C \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281509660238870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\C2DC\AC04 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281509456918870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MINUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\BD84 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281510250042870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MONTHS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\AC1C\C6D4 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281510003340870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.WEEKS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\C8FC \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281510481404870385)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC %1\B144 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281509712849870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\C77C \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281509579823870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\C2DC\AC04 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281509364427870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MINUTE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\BD84 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281510159285870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MONTH'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\AC1C\C6D4 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281509942673870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\C8FC \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281510304978870384)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_YEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \CD5C\ADFC 1\B144 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281512292255870386)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\C77C \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281512025693870386)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\C2DC\AC04 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281511811677870386)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\BD84 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281512623663870387)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\AC1C\C6D4 \C774\B0B4\C5D0 \C5C6\C74C ')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281512459380870386)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\C8FC \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281512867668870387)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1\B144 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281512152561870386)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\C77C \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281511981241870386)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\C2DC\AC04 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281511768768870386)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MINUTE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\BD84 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281512513777870386)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MONTH'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\AC1C\C6D4 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281512321681870386)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\C8FC \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281512774606870387)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_YEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C 1\B144 \C774\B0B4\C5D0 \C5C6\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281507369883870383)
,p_name=>'APEX.IG.X.NOT_LIKE.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C\ACFC \C720\C0AC\D558\C9C0 \C54A\C74C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281568466233870421)
,p_name=>'APEX.IG.X.STARTS_WITH.Y'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \B2E4\C74C\C73C\B85C \C2DC\C791 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282026777670870699)
,p_name=>'APEX.IG.X_COLUMN'
,p_message_language=>'ko'
,p_message_text=>'X'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281577956523870426)
,p_name=>'APEX.IG.YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B144')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282026833589870699)
,p_name=>'APEX.IG.Y_COLUMN'
,p_message_language=>'ko'
,p_message_text=>'Y'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282026939065870699)
,p_name=>'APEX.IG.Z_COLUMN'
,p_message_language=>'ko'
,p_message_text=>'Z'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282047448132870712)
,p_name=>'APEX.IG_FORMAT_SAMPLE_1'
,p_message_language=>'ko'
,p_message_text=>unistr('2016\B144 1\C6D4 12\C77C \C6D4\C694\C77C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282047508141870712)
,p_name=>'APEX.IG_FORMAT_SAMPLE_2'
,p_message_language=>'ko'
,p_message_text=>unistr('1\C6D4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282047686837870712)
,p_name=>'APEX.IG_FORMAT_SAMPLE_3'
,p_message_language=>'ko'
,p_message_text=>unistr('16\C2DC\AC04 \C804')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282047781670870712)
,p_name=>'APEX.IG_FORMAT_SAMPLE_4'
,p_message_language=>'ko'
,p_message_text=>unistr('16\C2DC\AC04 \B0B4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280903524853869978)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C1C4 \C9C0\C6D0\C740 STANDARD \B610\B294 ADVANCED\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280903607014869979)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B4F1\B85D\B41C \CCAB\BC88\C9F8 \C2A4\D0A4\B9C8\B97C \C81C\AC70\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280792473757869912)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 ID\AC00 \BD80\C801\D569\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281330402110870262)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \C804\C790\BA54\C77C \C8FC\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280773542241869900)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12\C740 0 \B610\B294 \C591\C758 \C815\C218\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280903787336869979)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \D3EC\D2B8 \BC88\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281366256486870287)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \AC00\C785 ID\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280903835256869979)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790 \C9C0\AC11 \ACBD\B85C\B294 file:<filesystempath> \D615\C2DD\C774\C5B4\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280995286068870039)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED\C744 \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280995171016870039)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \C791\C5C5\C601\C5ED ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280922765412869990)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C2A4\D134\C2A4 \B9E4\AC1C\BCC0\C218 "%0"\C758 "%1" \AC12\C774 \C815\ADDC \D45C\D604\C2DD "%2"\ACFC(\C640) \C77C\CE58\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280922638096869990)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C2A4\D134\C2A4 \B9E4\AC1C\BCC0\C218 "%0"\C5D0 \AC12\C774 \C788\C5B4\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280903951661869979)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C2A4\D134\C2A4 \B9E4\AC1C\BCC0\C218\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281361811178870283)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\BC00\BC88\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280727231187869873)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\BC00\BC88\D638(\C791\C5C5\C601\C5ED \C0AC\C6A9\C790 \ACC4\C815 \C800\C7A5\C18C\C5D0 \B300\D55C \C778\C99D\C6A9)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281647315369870469)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\BC00\BC88\D638(\C791\C5C5\C601\C5ED \C0AC\C6A9\C790 \ACC4\C815 \C800\C7A5\C18C\C5D0 \B300\D55C \C778\C99D\C6A9)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281468804622870359)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\BC00\BC88\D638(\C791\C5C5\C601\C5ED \C0AC\C6A9\C790 \ACC4\C815 \C800\C7A5\C18C\C5D0 \B300\D55C \C778\C99D\C6A9)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281049006461870076)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\BC00\BC88\D638(\C791\C5C5\C601\C5ED \C0AC\C6A9\C790 \ACC4\C815 \C800\C7A5\C18C\C5D0 \B300\D55C \C778\C99D\C6A9)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281361777775870283)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\BC00\BC88\D638(\C791\C5C5\C601\C5ED \C0AC\C6A9\C790 \ACC4\C815 \C800\C7A5\C18C\C5D0 \B300\D55C \C778\C99D\C6A9)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280905832174869980)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C1C4 \C11C\BC84 \D504\B85C\D1A0\CF5C\C740 http \B610\B294 https\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280905968914869980)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\D0A4\B9C8\AC00 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280906068489869980)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\D55C\B41C \C2A4\D0A4\B9C8\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280752199438869888)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280751925362869887)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C774 \B354 \C774\C0C1 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281696599240870499)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281976805813870669)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE74\B4DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280754099911869889)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85\C774 \C791\C131\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280753987871869889)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280728746163869874)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AD\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280728538549869873)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C758\ACAC\C744 \C0AD\C81C\D558\ACA0\C2B5\B2C8\AE4C?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281680966459870489)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C81C \C0AD\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280738318318869879)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BB38\C81C\B97C \C0AD\C81C\D558\ACA0\C2B5\B2C8\AE4C?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280755673280869890)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280754507512869889)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280728633255869873)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3B8\C9D1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281904488425870625)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85 \D3B8\C9D1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281904513442870625)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C81C \D3B8\C9D1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280752738347869888)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\B41C \C560\D50C\B9AC\CF00\C774\C158\C774 \C774 \C791\C5C5\C601\C5ED\C5D0 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280753141762869888)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85\C744 \C0AD\C81C\D558\B824\ACE0 \C2DC\B3C4\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280753080298869888)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85\C744 \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280753374876869888)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C81C\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280753438590869888)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C81C\B97C \C0AD\C81C \B300\C0C1\C73C\B85C \D45C\C2DC\D558\B824\ACE0 \C2DC\B3C4\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280752802244869888)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\B41C \D398\C774\C9C0\AC00 \C774 \C791\C5C5\C601\C5ED \B610\B294 \C81C\ACF5\B41C \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280753244198869888)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C5D0\AC8C \C774 \C124\BA85\C744 \C0AD\C81C\D560 \C218 \C788\B294 \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280753599955869888)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C5D0\AC8C \C774 \BB38\C81C\B97C \C0AD\C81C\D560 \C218 \C788\B294 \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280752906011869888)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C5D0\AC8C \C774 \C124\BA85 \D45C\C2DC \C5EC\BD80\B97C \BCC0\ACBD\D560 \C218 \C788\B294 \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281913305267870630)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C77C \D06C\AE30\B97C \D655\C778\D558\B294 \C911 \BB38\C81C\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4. \C2DC\C2A4\D15C \AD00\B9AC\C790\C5D0\AC8C \BB38\C758\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281913258942870630)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\B2F9 \D30C\C77C \C911 \D558\B098\B294 \CD5C\B300 \D30C\C77C \D06C\AE30\C778 %0\BC14\C774\D2B8\BCF4\B2E4 \D07D\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281913142149870630)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D30C\C77C\C740 \CD5C\B300 \D30C\C77C \D06C\AE30\C778 %0\BC14\C774\D2B8\BCF4\B2E4 \D07D\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280728877672869874)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C228\AE30\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280755453796869889)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BBF8\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280754374288869889)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BBF8\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280751736033869887)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C2A4\D15C\C5D0\C11C \CC3E\C744 \C218 \C5C6\B294 \BB38\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280712421758869864)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C5D0 \B300\D55C \D658\ACBD\C124\C815 \CD94\AC00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280754151159869889)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C77C \CCA8\BD80')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280753823223869889)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\ACB0\B428')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281982443159870672)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\BA38\B9AC\AE00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280755170399869889)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\C5B4 \C788\C74C.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280754920865869889)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\B2F9 \D30C\C77C \C911 \D558\B098\AC00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280753750821869888)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280756253641869890)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\D55C \D56D\BAA9 \C601\AD6C \C0AD\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281681870662870490)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \BE44\C6B0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280756191386869890)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\D55C \D56D\BAA9 \BCF5\C6D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280754233852869889)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C751\B2F5 \D15C\D50C\B9AC\D2B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280755004879869889)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B108\BB34 \CEE4\C11C \C5C5\B85C\B4DC\D560 \C218 \C5C6\C2B5\B2C8\B2E4. <br>\D30C\C77C\C758 \CD5C\B300 \D06C\AE30:')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280755333645869889)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C6D0\B418\B294 \D30C\C77C \C720\D615: ')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281908312233870627)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C751\B2F5 \D15C\D50C\B9AC\D2B8 \C120\D0DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280754893590869889)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\B2F9 \D30C\C77C\C774')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280755259879869889)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C6D0\B418\B294 \D30C\C77C \C720\D615\C774 \C544\B2D9\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281620664186870453)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281621215056870453)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85\C11C \BB38\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281620755967870453)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\C120 \C694\CCAD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281620816560870453)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5 \C694\CCAD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281621162592870453)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\CE58 \BB38\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281621036903870453)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C131\B2A5 \BB38\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281620934624870453)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\C548 \BB38\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281621355781870453)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD50\C721 \BB38\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281622047864870453)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281621756601870453)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_language=>'ko'
,p_message_text=>'CSS / HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281621815747870453)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3D9\C801 \C791\C5C5/JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281621574186870453)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281622115274870453)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C678\BD80 \C2DC\C2A4\D15C \D1B5\D569')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281621664310870453)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_language=>'ko'
,p_message_text=>unistr('REST \D1B5\D569')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281621972322870453)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\C548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281621461561870453)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_language=>'ko'
,p_message_text=>'UI / UX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281620539074870452)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C81C\C5D0 \C9C0\C815\B41C \BC94\C8FC\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281619640059870452)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC94\C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281620450781870452)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C81C\B85C \C778\D574 \C601\D5A5\C744 \BC1B\B294 \AE30\B2A5 \C601\C5ED\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281619743858870452)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5 \C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281620390744870452)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C81C\C5D0 \C9C0\C815\B41C \C911\C694\B3C4 \B808\BCA8\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281619814246870452)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\C694\B3C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281620286172870452)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C81C \D574\ACB0\C744 \C704\D55C \D22C\C785 \B808\BCA8\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281619960683870452)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D22C\C785 \B808\BCA8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281620106325870452)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C81C\C5D0 \B300\D55C \C9C4\D589\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281620043026870452)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C4\D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281622527057870454)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC31\B85C\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281622218132870453)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C704\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281622326273870454)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\C694')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281622488102870454)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\BC18')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281622621748870454)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\ACB0 \C548\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281622738075870454)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC04\D3B8\D55C \C218\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281622919529870454)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\ADDC\BAA8 \AC1C\BC1C \D22C\C785')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281622838857870454)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\D1B5 \D22C\C785')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281623366884870454)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\C815 \BD88\AC00\B2A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281623434400870454)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C644\B8CC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281623140130870454)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00 \C815\BCF4 \D544\C694')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281623215093870454)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C3\C790 \B300\AE30 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281623003019870454)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281633767876870460)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_language=>'ko'
,p_message_text=>unistr('\D558\B098 \C774\C0C1\C758 \BA64\BC84\AC00 \BB38\C81C\C5D0 \C9C0\C815\B418\C5B4 \C788\C73C\BBC0\B85C \C774 \B808\C774\BE14 \ADF8\B8F9\C744 \C0AD\C81C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280753611449869888)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\BCF5 \D45C\C2DC\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281681332215870489)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\C9C0\C815\C790')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281681294680870489)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281681740960870490)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C77C\C2A4\D1A4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281681108476870489)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\D0DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280751507838869887)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C77C\C2A4\D1A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281624020048870455)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CF54\B4DC \ACE0\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281624245886870455)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C885 \B9B4\B9AC\C2A4')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281624137612870455)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_language=>'ko'
,p_message_text=>unistr('UI \ACE0\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280756085063869890)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) %1 %2\C5D0 \C124\BA85\C744 \CD94\AC00\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280712169070869863)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\ACBD\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281637926969870463)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_language=>'ko'
,p_message_text=>unistr('%1 \C791\C5C5\C601\C5ED\C758 \BB38\C81C \BC88\D638 %0\C774(\AC00) \BCC0\ACBD\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281913075298870630)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\C758\B41C \B808\C774\BE14\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280754788822869889)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\D0C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280752211666869888)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280752025739869887)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\AC00 \B354 \C774\C0C1 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281974311946870667)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \BE44\C6B0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281696614245870499)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280751818786869887)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C5D0\C11C \C560\D50C\B9AC\CF00\C774\C158\ACFC \D398\C774\C9C0 \C5F0\AD00\C744 \C81C\AC70\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280752573255869888)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCA8\BD80\B97C \C81C\AC70\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281948147080870651)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \C124\BA85\C744 \C774 \D15C\D50C\B9AC\D2B8\B85C \BC14\AFB8\ACA0\C2B5\B2C8\AE4C?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281950110277870653)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C548\B155\D558\C138\C694! '),
'',
unistr('\CCAB\BC88\C9F8 \BB38\C81C\C785\B2C8\B2E4! \BB38\C81C\B97C \C0DD\C131\D558\C5EC \BAA8\B4E0 APEX \D504\B85C\C81D\D2B8\C5D0 \B300\D55C \C791\C5C5, \AE30\B2A5, \BC84\ADF8 \BC0F \D53C\B4DC\BC31\C744 \CD94\C801\D560 \C218 \C788\C2B5\B2C8\B2E4. \BB38\C81C\C5D0 \B808\C774\BE14\C744 \CD94\AC00\D558\ACE0 \D53C\C9C0\C815\C790\B97C \CD94\AC00\D558\BA70 \B9C8\C77C\C2A4\D1A4\C744 \C124\C815\D558\ACE0 \B9C8\D06C\B2E4\C6B4 \C18D\AE30\B97C \C0AC\C6A9\D558\C5EC \D615\C2DD \C9C0\C815\B3C4 \C801\C6A9\D560 \C218 \C788\C2B5\B2C8\B2E4.  '),
'',
unistr('\B9C8\D06C\B2E4\C6B4\C73C\B85C \C218\D589\D560 \C218 \C788\B294 \C791\C5C5\C758 \BE60\B978 \C0D8\D50C\C740 \B2E4\C74C\ACFC \AC19\C2B5\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281950060355870653)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('Oracle APEX\C5D0\C11C \D300 \AC1C\BC1C \C2DC\C791!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281696936599870499)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_language=>'ko'
,p_message_text=>unistr('- \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280752681885869888)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\D0DC \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280729026632869874)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281949988452870652)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00 \C815\BCF4 \D45C\C2DC...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280752353598869888)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\C6A9\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281913461668870630)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_language=>'ko'
,p_message_text=>unistr('%1 \C791\C5C5\C601\C5ED\C758 %0\C5D0 %2\AC1C\C758 \C0C8 \D1B5\C9C0\AC00 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281617192975870450)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\ADF8 \AE30\B85D\C5D0 \C0AC\C6A9\B418\B294 \D15C\D50C\B9AC\D2B8\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281617083241870450)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\ADF8 \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281616975024870450)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\C608\C0C1 \B3D9\C791**'),
unistr('- \BC1C\C0DD\D560 \AC83\C73C\B85C \C608\C0C1\B418\B294 \B3D9\C791\C744 \C54C\B824\C8FC\C2ED\C2DC\C624.'),
'',
'',
unistr('**\D604\C7AC \B3D9\C791**'),
unistr('- \BC1C\C0DD\D558\ACE0 \C788\B294 \B3D9\C791\C744 \C54C\B824\C8FC\C2ED\C2DC\C624.'),
'',
'',
unistr('**\C601\D5A5\C744 \BC1B\B294 \C0AC\B78C**'),
unistr('- \C601\D5A5\C744 \BC1B\B294 \C0AC\B78C/\AC1D\CCB4\B97C \C54C\B824\C8FC\C2ED\C2DC\C624. '),
'',
unistr('**\AC00\B2A5\D55C \D574\ACB0 \BC29\BC95**'),
unistr('- \AC00\B2A5\D55C \ACBD\C6B0 \C774 \BC84\ADF8\B97C \C218\C815\D560 \BC29\BC95\C744 \C81C\C548\D558\C2ED\C2DC\C624.'),
'',
unistr('**\C7AC\D604 \B2E8\ACC4**'),
unistr('- \C2A4\D06C\B9B0\C0F7 \BC0F \CF54\B4DC \C870\AC01(\D574\B2F9\D558\B294 \ACBD\C6B0)\C744 \BE44\B86F\D558\C5EC \D655\C2E4\D55C \C7AC\D604 \B2E8\ACC4\B97C \C81C\ACF5\D558\C2ED\C2DC\C624.'),
'1.',
'2.',
'3.',
'',
unistr('**\CEE8\D14D\C2A4\D2B8**'),
unistr('- \BC84\ADF8\AC00 \BC1C\C0DD\D560 \B54C \C218\D589\D558\B824\ACE0 \C2DC\B3C4 \C911\C774\B358 \C791\C5C5\C740 \BB34\C5C7\C785\B2C8\AE4C? \BC84\ADF8\AC00 \D2B9\C815 \C870\AC74 \B610\B294 \D2B9\C815 \C2DC\AC04 \B4F1\C5D0\B9CC \BC1C\C0DD\D569\B2C8\AE4C?'),
'',
unistr('**\D658\ACBD**'),
'',
unistr('- \BC84\C804: '),
unistr('- \D50C\B7AB\D3FC: '),
unistr('- \D558\C704 \C2DC\C2A4\D15C:'),
'',
'______',
'',
unistr('_**\CC38\ACE0:** \BB38\C81C\B97C \C560\D50C\B9AC\CF00\C774\C158 \BC0F/\B610\B294 \D398\C774\C9C0\C640 \C5F0\AD00\D558\B824\BA74 \BA3C\C800 \BB38\C81C\B97C \AE30\B85D\D55C \B2E4\C74C **\C791\C5C5** \B4DC\B86D\B2E4\C6B4\C5D0\C11C \C571 \BC0F \D398\C774\C9C0\B97C \C5F0\AD00\D558\C2ED\C2DC\C624._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281618287339870451)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\ADF8\AC00 \C81C\AE30\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281618129320870451)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\ADF8\AC00 \C81C\AE30\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281618370095870451)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\BC84\ADF8**\AC00 \C801\C808\D55C \C678\BD80 \C2DC\C2A4\D15C\C5D0 \C81C\CD9C\B418\C5C8\C2B5\B2C8\B2E4.'),
'',
unistr('- \BC84\ADF8 \CD94\C801 \C2DC\C2A4\D15C: '),
unistr('- \BC84\ADF8 ID: '),
unistr('- \BC84\ADF8 URL: '),
'',
unistr('\C124\BA85:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281617318453870450)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5 \C694\CCAD \AE30\B85D\C5D0 \C0AC\C6A9\B418\B294 \D15C\D50C\B9AC\D2B8\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281617218902870450)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5 \C694\CCAD \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281617499871870451)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\AE30\B2A5 \C694\C57D**'),
unistr(' - \AE30\B2A5 \C694\CCAD\C758 \C77C\BC18\C801\C778 \AC1C\C694\B97C \D55C \B2E8\B77D\C73C\B85C \C81C\ACF5\D558\C2ED\C2DC\C624.'),
'',
'',
unistr('**\CEE8\D14D\C2A4\D2B8**'),
unistr(' - \C774 \C694\CCAD\C774 \D2B9\C815 \C0C1\D669\C774\B098 \D504\B85C\C138\C2A4(\C608: "[...]\D560 \B54C \D56D\C0C1 \BB38\C81C \BC1C\C0DD")\C640 \AD00\B828\C774 \C788\C2B5\B2C8\AE4C?'),
'',
'',
unistr(' - \C2A4\D06C\B9B0\C0F7, \C0AC\B840 \B4F1 \C9C0\C6D0 \C815\BCF4\B97C \C81C\ACF5\D558\C2ED\C2DC\C624.'),
'',
'',
unistr('**\C120\D638 \D574\ACB0 \BC29\BC95**'),
unistr('- \AD6C\D604\D558\B824\B294 \BC29\BC95\C5D0 \B300\D55C \BA85\D655\D55C \C124\BA85\C744 \C81C\ACF5\D558\C2ED\C2DC\C624.'),
'',
'',
unistr('**\B300\CCB4 \D574\ACB0 \BC29\BC95**'),
unistr('- \ACE0\B824\D55C \B300\CCB4 \D574\ACB0 \BC29\BC95\C774\B098 \AE30\B2A5 \B610\B294 \C0AC\C6A9\D55C \C784\C2DC\D574\ACB0\CC45\C5D0 \B300\D55C \C124\BA85\C744 \C81C\ACF5\D558\C2ED\C2DC\C624.'),
'',
'',
'______',
unistr('_**\CC38\ACE0:** \BB38\C81C\B97C \C560\D50C\B9AC\CF00\C774\C158 \BC0F/\B610\B294 \D398\C774\C9C0\C640 \C5F0\AD00\D558\B824\BA74 \BA3C\C800 \BB38\C81C\B97C \AE30\B85D\D55C \B2E4\C74C **\C791\C5C5** \B4DC\B86D\B2E4\C6B4\C5D0\C11C \C571 \BC0F \D398\C774\C9C0\B97C \C5F0\AD00\D558\C2ED\C2DC\C624._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281618523590870451)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5 \C694\CCAD\C774 \C81C\CD9C\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281618411818870451)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5 \C694\CCAD\C774 \C81C\CD9C\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281618642830870451)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\AE30\B2A5 \C694\CCAD**\C774 \C801\C808\D55C \C678\BD80 \C2DC\C2A4\D15C\C5D0 \C81C\CD9C\B418\C5C8\C2B5\B2C8\B2E4.'),
'',
unistr('- \AE30\B2A5 \CD94\C801 \C2DC\C2A4\D15C: '),
unistr('- \AE30\B2A5 ID: '),
unistr('- \AE30\B2A5 \C815\C758 URL: '),
'',
unistr('\C124\BA85:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281619481034870452)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\D6C4\C18D \C791\C5C5\C774 \D544\C694\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281619360136870452)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D6C4\C18D \C791\C5C5 \D544\C694')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281619567574870452)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\B2E4\C74C \C791\C5C5\C744 \C218\D589\D558\C2ED\C2DC\C624. '),
'',
'1.',
'2.',
'3.',
'4.',
'',
unistr('\C124\BA85: ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281617600882870451)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C808\CC28\C5D0 \B300\D55C \C9C8\BB38\C5D0 \C0AC\C6A9\B418\B294 \D15C\D50C\B9AC\D2B8\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281617540456870451)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5B4\B5BB\AC8C \D560\AE4C\C694? ...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281617719378870451)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\C9C8\BB38**'),
unistr('- \C9C8\BB38 \B610\B294 \C694\CCAD\C744 \CD5C\B300\D55C \AC04\B7B5\D558\AC8C \AE30\C220\D558\C2ED\C2DC\C624.'),
'',
unistr('**\C77C\BC18\C801\C778 \CEE8\D14D\C2A4\D2B8**'),
unistr('- \C2DC\B3C4 \C911\C778 \C791\C5C5\C740 \BB34\C5C7\C785\B2C8\AE4C? '),
'',
'',
unistr('- \D574\ACB0\C744 \C704\D574 \B2E4\B978 \ACF3\C744 \D655\C778\D558\AC70\B098 \B2E4\B978 \C0AC\B78C\C5D0\AC8C \C5F0\B77D\D588\C2B5\B2C8\AE4C?'),
'',
'',
unistr('**\D658\ACBD** '),
unistr('\C774 \C9C8\BB38\C740 \D658\ACBD\ACFC \AD00\B828\B41C \AC83\C785\B2C8\AE4C, \D504\B85C\ADF8\B798\BC0D \C5B8\C5B4\C640 \AD00\B828\B41C \AC83\C785\B2C8\AE4C \C544\B2C8\BA74 \B2E4\B978 \C601\C5ED\ACFC \AD00\B828\B41C \AC83\C785\B2C8\AE4C?'),
'',
'______',
unistr('_**\CC38\ACE0:** \BB38\C81C\B97C \C560\D50C\B9AC\CF00\C774\C158 \BC0F/\B610\B294 \D398\C774\C9C0\C640 \C5F0\AD00\D558\B824\BA74 \BA3C\C800 \BB38\C81C\B97C \AE30\B85D\D55C \B2E4\C74C **\C791\C5C5** \B4DC\B86D\B2E4\C6B4\C5D0\C11C \C571 \BC0F \D398\C774\C9C0\B97C \C5F0\AD00\D558\C2ED\C2DC\C624._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281619140300870452)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C54C\B824\C9C4 \BB38\C81C\B97C \CC38\C870\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281619024370870451)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C54C\B824\C9C4 \BB38\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281619264601870452)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\AC80\D1A0 \D6C4 \C774 \BB38\C81C\AC00 \C54C\B824\C9C4 \BB38\C81C\C778\C9C0 \D655\C778\D558\ACE0 \C544\B798 \C138\BD80\C815\BCF4\B97C \CC38\C870\D558\C2ED\C2DC\C624.'),
'',
unistr('- \BC84\ADF8 \CD94\C801 \C2DC\C2A4\D15C: '),
unistr('- \BC84\ADF8 ID: '),
unistr('- \BC84\ADF8 URL: '),
'',
unistr('\C124\BA85: ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281618827511870451)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00 \C815\BCF4\C5D0 \B300\D55C \C694\CCAD\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281618750492870451)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00 \C815\BCF4 \D544\C694')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281618940116870451)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\C774 \BB38\C81C\C5D0 \B300\D574 \CD94\AC00 \C815\BCF4\AC00 \D544\C694\D569\B2C8\B2E4.**'),
'',
unistr('\C544\B798\C5D0 \C694\CCAD\B41C \C815\BCF4\B97C \C81C\ACF5\D558\C2ED\C2DC\C624. \C774 \C815\BCF4\B97C \C81C\ACF5\D558\C9C0 \C54A\C744 \ACBD\C6B0 \BD84\B958\AC00 \C5B4\B824\C6B0\BA70 \B354 \C774\C0C1 \BB38\C81C\B97C \D574\ACB0\D558\C9C0 \BABB\D569\B2C8\B2E4.'),
'',
'',
unistr('\C124\BA85:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281617947673870451)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BB38\C81C\C5D0 \B300\D55C \C870\CE58\AC00 \C218\D589\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281617898980870451)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\CE58 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281618059526870451)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C2E0\C911\D788 \ACE0\B824\D55C \D6C4 **\C774 \BB38\C81C\C5D0 \B300\D574 \B354 \C774\C0C1 \C870\CE58\B97C \C218\D589\D558\C9C0 \C54A\AE30\B85C \ACB0\C815\D588\C2B5\B2C8\B2E4**. '),
'',
unistr('\C124\BA85:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280755753449869890)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14D\C2A4\D2B8 \D30C\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280754664164869889)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14D\C2A4\D2B8 \D30C\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280751490978869887)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BB38\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281639031558870464)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0 \CCA8\BD80\B97C %1\C5D0 \CD94\AC00\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281638077090870463)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0\C744(\B97C) %1\C5D0 \CD94\AC00\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281639628765870464)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0\C744(\B97C) %1\C5D0 \CD94\AC00\D588\C2B5\B2C8\B2E4.				')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281638248335870463)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0\C744(\B97C) %1\C5D0 \C9C0\C815\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281638651992870463)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0\C744(\B97C) %1\C5D0 \C5F0\AD00\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280755909198869890)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0	%1\C5D0 \B300\D55C \C124\BA85\C744 \D3B8\C9D1\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281639519643870464)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BB38\C81C\AC00 \C228\ACA8\C84C\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281638477155870463)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0\C744(\B97C) %1\C758 \C911\BCF5\C73C\B85C \D45C\C2DC\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281639451417870464)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C744(\B97C) \C5F4\C5B4\BCF8 \C0AC\B78C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281639148197870464)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0 \CCA8\BD80\B97C %1\C5D0\C11C \C81C\AC70\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281638113501870463)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0\C744(\B97C) %1\C5D0\C11C \C81C\AC70\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281639734849870464)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0\C744(\B97C) %1\C5D0\C11C \C81C\AC70\D588\C2B5\B2C8\B2E4. 			')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281639284418870464)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0\C5D0 \B300\D55C \C0C1\D0DC\B97C %1(\C73C)\B85C \C124\C815\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281638839529870463)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %1\C5D0 %0\C744(\B97C) \AD6C\B3C5\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281638377738870463)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %2\C5D0 %0\C744(\B97C) %1\C5D0\C11C \C9C0\C815 \CDE8\C18C\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281638711956870463)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %1\C5D0 %0\C5D0\C11C \C560\D50C\B9AC\CF00\C774\C158\ACFC \D398\C774\C9C0 \C5F0\AD00\C744 \C81C\AC70\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281638571418870463)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %0\C758 %1 \C911\BCF5 \D45C\C2DC\B97C \CDE8\C18C\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281638917872870464)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774(\AC00) %1\C5D0 %0\C758 \AD6C\B3C5\C744 \D574\C81C\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281639361365870464)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_language=>'ko'
,p_message_text=>unistr('%2\C774(\AC00) %0 %1\C758 \C911\BCF5\C744 \D45C\C2DC\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280751649963869887)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280728967929869874)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C228\AE40 \D574\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280752420211869888)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\C6A9 \D574\C81C\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281681082019870489)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B370\C774\D2B8...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280755575148869889)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_language=>'ko'
,p_message_text=>unistr('Zip \D30C\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280754490309869889)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_language=>'ko'
,p_message_text=>unistr('Zip \D30C\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281987311691870675)
,p_name=>'APEX.ITEM.FILE.BROWSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC3E\C544\BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281985299595870674)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C77C \C120\D0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281985380388870674)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C77C \C120\D0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282090203398870738)
,p_name=>'APEX.ITEM.HELP_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3C4\C6C0\B9D0 \D14D\C2A4\D2B8: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281943395872870648)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D56D\BAA9\C744 \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280739071575869880)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 %0\ACFC(\C640) %1 \C0AC\C774\C758 \C801\D569\D55C \BC94\C704\C5D0 \C18D\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280739110863869880)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_MULTIPLE_OF_STEP'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 %0\C758 \BC30\C218\AC00 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280738475107869879)
,p_name=>'APEX.ITEM_TYPE.YES_NO.INVALID_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 \AC12 %0 \BC0F %1\ACFC(\C640) \C77C\CE58\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280738676926869879)
,p_name=>'APEX.ITEM_TYPE.YES_NO.NO_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B2C8\C624')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281398270263870310)
,p_name=>'APEX.ITEM_TYPE.YES_NO.OFF_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281398342953870310)
,p_name=>'APEX.ITEM_TYPE.YES_NO.ON_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280738510332869879)
,p_name=>'APEX.ITEM_TYPE.YES_NO.YES_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280709660132869862)
,p_name=>'APEX.LIST_MANAGER.ADD_ENTRY'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\BAA9 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281655116253870473)
,p_name=>'APEX.LIST_MANAGER.BUTTON_ADD'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281655282900870473)
,p_name=>'APEX.LIST_MANAGER.BUTTON_REMOVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280709745511869862)
,p_name=>'APEX.LIST_MANAGER.SELECTED_ENTRY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\B41C \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281886911263870614)
,p_name=>'APEX.LTO.ADVANCED'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\AE09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281887200220870615)
,p_name=>'APEX.LTO.CANCEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CDE8\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281887024190870614)
,p_name=>'APEX.LTO.COMMON'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACF5\D1B5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281887346044870615)
,p_name=>'APEX.LTO.LIVE_TEMPLATE_OPTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B77C\C774\BE0C \D15C\D50C\B9AC\D2B8 \C635\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281888562631870615)
,p_name=>'APEX.LTO.NOT_APPLICABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \AD6C\C131\C694\C18C\B294 \D398\C774\C9C0\C5D0\C11C \B80C\B354\B9C1\B418\C9C0 \C54A\C73C\BBC0\B85C \D15C\D50C\B9AC\D2B8 \C635\C158\C744 \C0AC\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281886869606870614)
,p_name=>'APEX.LTO.NO_OPTIONS_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\D15C\D50C\B9AC\D2B8 \C635\C158\C744 \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281887172244870614)
,p_name=>'APEX.LTO.SAVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281884689837870613)
,p_name=>'APEX.MARKDOWN.BOLD'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD75\C740\CCB4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281885958540870614)
,p_name=>'APEX.MARKDOWN.IMAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BBF8\C9C0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281885506056870614)
,p_name=>'APEX.MARKDOWN.INLINE_CODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\B77C\C778 \CF54\B4DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281980494905870671)
,p_name=>'APEX.MARKDOWN.INSERT_IMAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BBF8\C9C0 \C0BD\C785')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281980547713870671)
,p_name=>'APEX.MARKDOWN.INSERT_LINK'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C1\D06C \C0BD\C785')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281884781798870613)
,p_name=>'APEX.MARKDOWN.ITALIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\C6B8\C784\AF34')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281982205679870672)
,p_name=>'APEX.MARKDOWN.LINK'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C1\D06C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281885809629870614)
,p_name=>'APEX.MARKDOWN.LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA9\B85D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281885707950870614)
,p_name=>'APEX.MARKDOWN.ORDERED_LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C21C\CC28 \BAA9\B85D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281884802370870613)
,p_name=>'APEX.MARKDOWN.PREVIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\BBF8\B9AC\BCF4\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281885361124870613)
,p_name=>'APEX.MARKDOWN.PREVIEW_EMPTY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BBF8\B9AC \BCFC \D56D\BAA9 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281885460196870613)
,p_name=>'APEX.MARKDOWN.STRIKETHROUGH'
,p_message_language=>'ko'
,p_message_text=>unistr('\CDE8\C18C\C120')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281885696659870614)
,p_name=>'APEX.MARKDOWN.UNORDERED_LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\C21C\CC28 \BAA9\B85D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281513385038870387)
,p_name=>'APEX.MENU.CURRENT_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282053576236870716)
,p_name=>'APEX.MENU.OVERFLOW_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B354 \BCF4\AE30...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281513238117870387)
,p_name=>'APEX.MENU.PROCESSING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\B4DC \C911')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281964127078870661)
,p_name=>'APEX.NOTIFICATION_MESSAGE_HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1B5\C9C0 \BA54\C2DC\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280875472167869962)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1B5\C9C0 \BA54\C2DC\C9C0 \CCB4\D06C\C12C \CF58\D150\CE20 \C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280875386927869962)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1B5\C9C0 \BA54\C2DC\C9C0 \CCB4\D06C\C12C \D615\C2DD \C624\B958')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281588880782870433)
,p_name=>'APEX.NUMBER_FIELD.VALUE_GREATER_MAX_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 \C9C0\C815\B41C \CD5C\B300\AC12 %0\BCF4\B2E4 \D07D\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281588981788870433)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C740 \C22B\C790\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281589014471870433)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID2'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 \C22B\C790 \D615\C2DD %0\ACFC(\C640) \C77C\CE58\D558\C9C0 \C54A\C2B5\B2C8\B2E4(\C608: %1).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281588768626870433)
,p_name=>'APEX.NUMBER_FIELD.VALUE_LESS_MIN_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 \C9C0\C815\B41C \CD5C\C18C\AC12 %0\BCF4\B2E4 \C791\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281588673582870433)
,p_name=>'APEX.NUMBER_FIELD.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C774 %0\ACFC(\C640) %1 \C0AC\C774\C758 \C801\D569\D55C \BC94\C704\C5D0 \C18D\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281114402022870122)
,p_name=>'APEX.PAGE.DUPLICATE_SUBMIT'
,p_message_language=>'ko'
,p_message_text=>unistr(' \C774 \D398\C774\C9C0\B294 \C774\BBF8 \C81C\CD9C\B418\C5C8\C73C\BA70 \B2E4\C2DC \C81C\CD9C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280977125173870026)
,p_name=>'APEX.PAGE.NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('"%0" \C560\D50C\B9AC\CF00\C774\C158 "%1" \D398\C774\C9C0\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281258048084870216)
,p_name=>'APEX.PAGE_ITEM_IS_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL# \AC12\C744 \C785\B825\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281993773505870679)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158 \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281993565895870679)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131 \C635\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281993615027870679)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8 \C2A4\D0C0\C77C \C120\D0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281655554182870474)
,p_name=>'APEX.POPUP_LOV.BUTTON_CLOSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EB\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281655433640870474)
,p_name=>'APEX.POPUP_LOV.BUTTON_FIND'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \CC3E\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281655724817870474)
,p_name=>'APEX.POPUP_LOV.BUTTON_NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281655604309870474)
,p_name=>'APEX.POPUP_LOV.BUTTON_PREV'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280733032302869876)
,p_name=>'APEX.POPUP_LOV.FILTER_REQ'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9\C5B4\B97C %0\C790 \C774\C0C1 \C785\B825\D569\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281307353605870247)
,p_name=>'APEX.POPUP_LOV.ICON_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D31D\C5C5 \AC12 \BAA9\B85D: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280733138933869876)
,p_name=>'APEX.POPUP_LOV.INITIAL_FILTER_REQ'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9\C5B4\B97C \C785\B825\D558\C2ED\C2DC\C624.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280732936799869876)
,p_name=>'APEX.POPUP_LOV.NO_RESULTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACB0\ACFC\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280732875668869876)
,p_name=>'APEX.POPUP_LOV.REMOVE_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\AC70 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281475527495870363)
,p_name=>'APEX.POPUP_LOV.SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9\C5B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281655349963870473)
,p_name=>'APEX.POPUP_LOV.TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9 \B300\D654\C0C1\C790')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280735686397869878)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \B610\B294 \C774\C804 \AE30\BCF8 \D0A4 \AC12\C744 \AC00\C838\C62C \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281468567691870359)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C11C\BE44\C2A4\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280978680996870027)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B85C\C138\C2A4\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281947755390870651)
,p_name=>'APEX.PROCESSING'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B85C\C138\C2F1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280762348021869894)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\B370\C774\D130\BCA0\C774\C2A4 \C138\C158 \B9AC\C18C\C2A4 \C81C\D55C\C73C\B85C \C778\D574 Application Express\AC00 \C694\CCAD\C744 \CC98\B9AC\D560 \C218 \C5C6\C2B5\B2C8\B2E4. \B098\C911\C5D0 \B2E4\C2DC \C2DC\B3C4\D558\C2ED\C2DC\C624.'),
'<p/>',
unistr('\C774 \C7A5\C560\C5D0 \B300\D55C \C138\BD80\C815\BCF4\B294 \B514\BC84\ADF8 ID "%0"\C744(\B97C) \D1B5\D574 \C81C\ACF5\B429\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282004738045870686)
,p_name=>'APEX.REGION.CSSCALENDAR.ADD'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281426998831870331)
,p_name=>'APEX.REGION.CSSCALENDAR.ALL_DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\D558\B8E8 \C885\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282077081029870730)
,p_name=>'APEX.REGION.CSSCALENDAR.BUTTON.SENDEMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD08\B300 \C804\C1A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282076788841870730)
,p_name=>'APEX.REGION.CSSCALENDAR.CHOOSE_ACTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C635\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281442058513870342)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_ALLDAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\C77C \C77C\AC04 \BCF4\AE30 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281441850045870342)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_TIME_SPECIFIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04 \D3EC\D568 \C77C\AC04 \B370\C774\D130 \BCF4\AE30 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281966627240870663)
,p_name=>'APEX.REGION.CSSCALENDAR.DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281913542528870631)
,p_name=>'APEX.REGION.CSSCALENDAR.DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280824621225869931)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.CSV'
,p_message_language=>'ko'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280824478336869931)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.ICALENDAR'
,p_message_language=>'ko'
,p_message_text=>'iCal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280824315210869931)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.PDF'
,p_message_language=>'ko'
,p_message_text=>'PDF'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280824501479869931)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.XML'
,p_message_language=>'ko'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280824062198869931)
,p_name=>'APEX.REGION.CSSCALENDAR.ENDDATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\B8CC \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280824255001869931)
,p_name=>'APEX.REGION.CSSCALENDAR.EVENTNAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282076882519870730)
,p_name=>'APEX.REGION.CSSCALENDAR.INVITATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD08\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281966761781870663)
,p_name=>'APEX.REGION.CSSCALENDAR.LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA9\B85D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281966493173870662)
,p_name=>'APEX.REGION.CSSCALENDAR.MONTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6D4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281981459909870672)
,p_name=>'APEX.REGION.CSSCALENDAR.NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282035169102870704)
,p_name=>'APEX.REGION.CSSCALENDAR.NOEVENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282077424513870730)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.FORM'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\C874 \C774\BCA4\D2B8\B97C \D3B8\C9D1\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282077382437870730)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.SEND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C\C744 \D1B5\D574 \CD08\B300\B97C \C804\C1A1\D558\B294 \C911\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281981577145870672)
,p_name=>'APEX.REGION.CSSCALENDAR.PREVIOUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282020839597870696)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C804\C1A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282020438573870695)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.BUTTON'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C804\C1A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282084470867870734)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \D544\B4DC\B294 \D544\C218\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282084335436870734)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD08\B300 \C804\C1A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282076481017870730)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.SUBJECT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282020707012870696)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC1B\B294 \C0AC\B78C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280824166845869931)
,p_name=>'APEX.REGION.CSSCALENDAR.STARTDATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C791 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282001464495870684)
,p_name=>'APEX.REGION.CSSCALENDAR.TABLEFORM'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \B300\D55C \D3FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281441615798870342)
,p_name=>'APEX.REGION.CSSCALENDAR.TIME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281982136727870672)
,p_name=>'APEX.REGION.CSSCALENDAR.TODAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B298')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281967509117870663)
,p_name=>'APEX.REGION.CSSCALENDAR.VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281966522985870663)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281441996662870342)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_ALLDAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\C77C \C8FC\AC04 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281441744985870342)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_TIME_SPECIFIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04 \D3EC\D568 \C8FC\AC04 \B370\C774\D130 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281967172237870663)
,p_name=>'APEX.REGION.CSSCALENDAR.YEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B144')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280735922211869878)
,p_name=>'APEX.REGION.FLASH_CHART.INITIALIZING'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD08\AE30\D654 \C911...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280995334992870039)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_DATA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \B85C\B4DC \C911...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282006243523870687)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_RESOURCES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9AC\C18C\C2A4\B97C \B85C\B4DC\D558\B294 \C911...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282006335346870687)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_TEMPLATES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D15C\D50C\B9AC\D2B8\B97C \B85C\B4DC\D558\B294 \C911...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280736062523869878)
,p_name=>'APEX.REGION.FLASH_CHART.NO_DATA_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280900802383869977)
,p_name=>'APEX.REGION.FLASH_CHART.SHOW_XML'
,p_message_language=>'ko'
,p_message_text=>unistr('XML \D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280995433790870039)
,p_name=>'APEX.REGION.FLASH_CHART.WAITING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\B97C \B85C\B4DC\D558\B294 \C911\C785\B2C8\B2E4. \AE30\B2E4\B9AC\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281966896463870663)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281966955068870663)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.LOAD_MORE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00 \B85C\B4DC...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281167701623870158)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.BACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\B4A4\B85C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280763861036869895)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.LOAD_MORE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00 \B85C\B4DC...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280788815617869910)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281967002262870663)
,p_name=>'APEX.REGION.JQM_REFLOW.LOAD_MORE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00 \B85C\B4DC...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281980730512870671)
,p_name=>'APEX.REGION.NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED ID %0\C744(\B97C) \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280775036220869901)
,p_name=>'APEX.REGION.NO_DATA_FOUND_MESSAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\B97C \CC3E\C744 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280983099035870030)
,p_name=>'APEX.REGION.PAGINATION.RESET_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED \D398\C774\C9C0 \BC88\D638 \B9E4\AE40\C744 \C7AC\C124\C815\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280735826139869878)
,p_name=>'APEX.REGION.PAGINATION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED \D398\C774\C9C0 \BC88\D638 \B9E4\AE40\C744 \C124\C815\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281908293404870627)
,p_name=>'APEX.REGION.RESPONSIVE_TABLE.COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281980609713870671)
,p_name=>'APEX.REGION.TYPE_NOT_SUPPORTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED \C720\D615 %0\C740(\B294) \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280735785034869878)
,p_name=>'APEX.REGION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('"#COMPONENT_NAME#" \C601\C5ED\C744 \B80C\B354\B9C1\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281258182743870216)
,p_name=>'APEX.REGION_COLUMN_IS_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('#COLUMN_HEADER# \AC12\C744 \C785\B825\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281438212052870339)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_language=>'ko'
,p_message_text=>unistr('REST \C0AC\C6A9 SQL \C11C\BE44\C2A4\C5D0 \B300\D55C \C778\C99D\C744 \C2E4\D328\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280762655792869894)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\C744 \C2E4\D328\D588\C2B5\B2C8\B2E4. \AC12 \BAA9\B85D\C740 \BD80\C801\D569\D55C \C6F9 \C778\C99D\C11C(\C774 LOV\C5D0 \B300\D55C \C5F4 \C815\BCF4\B97C \D3B8\C9D1\D560 \C218 \C5C6\AC8C \D568)\B97C \CC38\C870\D558\B294 REST \C0AC\C6A9 SQL \B370\C774\D130 \C18C\C2A4\B97C \C0AC\C6A9\D569\B2C8\B2E4. \C778\C99D\C744 \C704\D55C \C778\C99D\C11C\B97C \D655\C778\D558\C2ED\C2DC\C624. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281976502732870669)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1B5\C2E0 \C624\B958\C785\B2C8\B2E4. \AC12 \BAA9\B85D\C5D0\C11C \CC38\C870\D558\B294 REST \C0AC\C6A9 SQL \B370\C774\D130 \C18C\C2A4\B97C \D638\CD9C\D558\B294 \C911 \BB38\C81C\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4. \C774\B85C \C778\D574 LOV\C5D0 \B300\D55C \C5F4 \C815\BCF4\B97C \D3B8\C9D1\D558\C9C0 \BABB\D558\AC8C \B429\B2C8\B2E4. REST \C0AC\C6A9 SQL \B370\C774\D130 \C18C\C2A4\AC00 \C62C\BC14\B974\AC8C \C791\B3D9 \C911\C774\BA70 \D574\B2F9\D558\B294 \C778\C99D \C778\C99D\C11C\AC00 \C62C\BC14\B978\C9C0 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281505964802870382)
,p_name=>'APEX.REMOTESQL.OAUTH_IS_RECOMMENDED'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACBD\ACE0: Oracle\C740 REST \C0AC\C6A9 SQL\C744 \D1B5\D55C \C778\C99D\C5D0 OAuth \D074\B77C\C774\C5B8\D2B8 \C778\C99D\C11C\B97C \C0AC\C6A9\D560 \AC83\C744 \AD8C\C7A5\D569\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281439668084870340)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6D0\ACA9 \C11C\BC84\C5D0\C11C \C624\B958 \BC1C\C0DD: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281396409281870308)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\B41C ORDS REST \C0AC\C6A9 SQL \C778\C2A4\D134\C2A4\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280997696061870041)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C11C\BC84\AC00 %0(\C73C)\B85C \C7AC\C9C0\C815\C744 \C804\C1A1\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281285685991870233)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \BB38\C774 32.767\BC14\C774\D2B8\BCF4\B2E4 \AE41\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281305514001870246)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Application Express\B97C \C2DC\C791\D569\B2C8\B2E4! #USER#(\C73C)\B85C \C811\C18D\B418\C5C8\C2B5\B2C8\B2E4.'),
unistr('\B85C\CEEC \B370\C774\D130\BCA0\C774\C2A4 \C2DC\AC04\AE30\B85D\C740 #SYSDATE#\C785\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281633644048870460)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED\C758 \AE30\BCF8 \C2A4\D0A4\B9C8\C5D0 \B300\D55C \BCC4\CE6D\C744 \D3B8\C9D1\D558\ACE0 \C788\C2B5\B2C8\B2E4. \C774 \BCC4\CE6D\C744 \C124\C815\D558\BA74 \C791\C5C5\C601\C5ED \B808\BCA8\C5D0\C11C \ACBD\B85C \C811\B450\C5B4\AC00 \BCC0\ACBD\B429\B2C8\B2E4. \ADF8\B7EC\BA74 \C815\C758\D55C \BAA8\B4E0 APEX \AE30\BC18 RESTful \C11C\BE44\C2A4\C5D0 \B300\D55C URL\C774 \C601\D5A5\C744 \BC1B\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281292867427870238)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ORDS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC ORDS \BC84\C804\C740 REST \AD00\B9AC \C778\D130\D398\C774\C2A4\B97C \C9C0\C6D0\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281292947721870238)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ROLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\ACF5\B41C \D074\B77C\C774\C5B8\D2B8 \B864\C740 REST \AD00\B9AC \C778\D130\D398\C774\C2A4\C5D0\C11C \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282072229823870727)
,p_name=>'APEX.RICH_TEXT_EDITOR.ACCESSIBLE_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('%0, \C11C\C2DD \C788\B294 \D14D\C2A4\D2B8 \D3B8\C9D1\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281283246656870232)
,p_name=>'APEX.RICH_TEXT_EDITOR.MAXIMUM_LENGTH_EXCEEDED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C11C\C2DD \C788\B294 \D14D\C2A4\D2B8 HTML \B9C8\D06C\C5C5\C774 \D56D\BAA9\C758 \CD5C\B300 \AE38\C774\B97C \CD08\ACFC\D568(\C2E4\C81C %0\C790, \D5C8\C6A9\B41C %1\C790)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281965412646870662)
,p_name=>'APEX.RV.DELETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AD\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281891276222870617)
,p_name=>'APEX.RV.DUPLICATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\BCF5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281886478132870614)
,p_name=>'APEX.RV.EXCLUDE_HIDDEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC\B41C \C5F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281886347250870614)
,p_name=>'APEX.RV.EXCLUDE_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B110 \AC12 \C81C\C678')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281965514095870662)
,p_name=>'APEX.RV.INSERT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281425645137870330)
,p_name=>'APEX.RV.MOVE_DOWN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B798\B85C \C774\B3D9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281425700855870330)
,p_name=>'APEX.RV.MOVE_UP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C704\B85C \C774\B3D9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281886110136870614)
,p_name=>'APEX.RV.NEXT_RECORD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281886706353870614)
,p_name=>'APEX.RV.NOT_GROUPED_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\D0C0 \C5F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281886271718870614)
,p_name=>'APEX.RV.PREV_RECORD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281886538572870614)
,p_name=>'APEX.RV.REC_X'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281886679988870614)
,p_name=>'APEX.RV.REC_XY'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 %0/%1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281891353975870617)
,p_name=>'APEX.RV.REFRESH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8\B85C\ACE0\CE68')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281891426222870617)
,p_name=>'APEX.RV.REVERT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\ACBD\C0AC\D56D \BCF5\C6D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281886000837870614)
,p_name=>'APEX.RV.SETTINGS_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\C815 \BA54\B274')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281360478322870282)
,p_name=>'APEX.SAMPLE_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281283322261870232)
,p_name=>'APEX.SC.REFERENCES'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281624969459870455)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C720\D2F8\B9AC\D2F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281625052060870455)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \C560\D50C\B9AC\CF00\C774\C158 \C720\D2F8\B9AC\D2F0 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281632423523870460)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C774\B3D9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281632397579870460)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACF5\C720 \AD6C\C131\C694\C18C\B85C \C774\B3D9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281625142244870455)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281625207726870455)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30 \C791\C5C5 > ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281625386161870455)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281625453495870455)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \C560\D50C\B9AC\CF00\C774\C158 \D56D\BAA9 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281625547835870455)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \B17C\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281625641792870456)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \CCB4\ACC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281625720965870456)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \BCF4\C548 \C778\C99D \CCB4\ACC4 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281625811213870456)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD8C\D55C \BD80\C5EC \CCB4\ACC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281625996534870456)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \BCF4\C548 \AD8C\D55C \BD80\C5EC \CCB4\ACC4 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281626000218870456)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281626125430870456)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \C774\B3D9 \ACBD\B85C \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281626265732870456)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE4C\B4DC \C635\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281626341281870456)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \BE4C\B4DC \C635\C158 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281626432686870456)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131\C694\C18C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281626515683870456)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \AD6C\C131\C694\C18C \C124\C815 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281626645073870456)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C0B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281626704197870456)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \C560\D50C\B9AC\CF00\C774\C158 \ACC4\C0B0 \005C %LIST_ITEM_NAME%')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281626822383870456)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D56D\BAA9 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281626913672870456)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \CCB4\ACC4 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281627053428870456)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE4C\B4DC \C635\C158 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281627121418870456)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \ACC4\C0B0 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281627200514870457)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281627357435870457)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B7EC\ADF8\C778 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281627474853870457)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281627532979870457)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C778\C99D\C11C \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281627628101870457)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \B85C\B4DC \C815\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281627779266870457)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \B370\C774\D130 \B85C\B4DC \C815\C758 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281627834627870457)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \C18C\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281627944363870457)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\C758 \C18D\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281628021093870457)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281628153722870457)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \B808\C774\C544\C6C3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281628278113870457)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \BCF4\ACE0\C11C \B808\C774\C544\C6C3 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281628305314870457)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\AC70\C2DC \C6F9 \C11C\BE44\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281628440414870457)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \B808\AC70\C2DC \C6F9 \C11C\BE44\C2A4 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281628545727870457)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0D0\C0C9 \BAA9\B85D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281628652902870457)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \D074\B798\C2DD \D0D0\C0C9 \BAA9\B85D \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281628798326870457)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12 \BAA9\B85D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281628826578870457)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \AC12 \BAA9\B85D \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281628996967870458)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0D0\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281629081709870458)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\D0C0 \AD6C\C131\C694\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281629134045870458)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B7EC\ADF8\C778')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281629272260870458)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \D50C\B7EC\ADF8\C778 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281629355792870458)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B85C\C138\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281629457772870458)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \C560\D50C\B9AC\CF00\C774\C158 \D504\B85C\C138\C2A4 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281629579647870458)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C9C8\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281629674659870458)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \BCF4\ACE0\C11C \C9C8\C758 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281629799074870458)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281629882295870458)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_language=>'ko'
,p_message_text=>unistr('REST \C0AC\C6A9 SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281629998303870458)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C REST \C0AC\C6A9 SQL \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281630033053870458)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\C548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281630172138870458)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158 \C0C1\D0DC \BCF4\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281630238407870458)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C0C1\D0DC \BCF4\D638 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281630456963870458)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACF5\C720 \AD6C\C131\C694\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281630545871870459)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281630674208870459)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD95\D0A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281630715547870459)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \B2E8\CD95\D0A4 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281630895367870459)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0ED(\B808\AC70\C2DC)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281630986175870459)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281631079304870459)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C UI \D15C\D50C\B9AC\D2B8 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281631111517870459)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281631284196870459)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C UI \D14C\B9C8 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281631336881870459)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281631476671870459)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C778\C99D\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281631575498870459)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \BCF4\C548 \C6F9 \C778\C99D\C11C \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281631661502870459)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C18C\C2A4 \BAA8\B4C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281631760554870459)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9: \ACF5\C720 \AD6C\C131\C694\C18C \005C \C6F9 \C18C\C2A4 \BAA8\B4C8 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281631825327870459)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C6CC\D06C\C20D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281631982661870459)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1D\CCB4 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281632051046870459)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C6CC\D06C\C20D\C5D0\C11C %LIST_ITEM_NAME% \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281632161183870459)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\D06C\B9BD\D2B8 \D3B8\C9D1\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281632273919870460)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C6CC\D06C\C20D \C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282014764872870692)
,p_name=>'APEX.SESSION.DB_SESSION_CLEANUP.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C138\C158 \C815\B9AC \CF54\B4DC\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280976651989870026)
,p_name=>'APEX.SESSION.DB_SESSION_INIT.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C138\C158 \C124\C815 \CF54\B4DC\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280750338696869886)
,p_name=>'APEX.SESSION.EXPIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158\C774 \B9CC\B8CC\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282006418629870687)
,p_name=>'APEX.SESSION.EXPIRED.CLOSE_DIALOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \B300\D654\C0C1\C790\B97C \B2EB\ACE0 \BE0C\B77C\C6B0\C800\C758 \B2E4\C2DC \B85C\B4DC \B2E8\CD94\B97C \B20C\B7EC\C11C \C0C8 \C138\C158\C744 \AC00\C838\C624\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282066650963870723)
,p_name=>'APEX.SESSION.EXPIRED.NEW_SESSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \C138\C158\C744 \C0DD\C131\D558\B824\BA74 <a href="%0">\C5EC\AE30</a>\B97C \B204\B985\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281429712169870333)
,p_name=>'APEX.SESSION.RAS.NO_DYNAMIC_ROLES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 "%0"\C5D0 \B300\D574 Real Application Security \C138\C158\C5D0\C11C \B3D9\C801 \B864\C744 \C0AC\C6A9\C73C\B85C \C124\C815\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280969597558870021)
,p_name=>'APEX.SESSION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('ERR-99900 \ACE0\C720 \C138\C158 ID\B97C \C0DD\C131\D560 \C218 \C5C6\C74C: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282077705510870730)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D56D\BAA9 %0\C774(\AC00) \B370\C774\D130\BCA0\C774\C2A4 \C5F4\C744 \AE30\C900\C73C\B85C \D558\C9C0\B9CC, ''\C0AC\C6A9\B41C \C18C\C2A4'' \C18D\C131\C774 ''\C138\C158 \C0C1\D0DC\C5D0\C11C \D604\C7AC \AC12\C774 \B110\C77C \B54C\B9CC''\C73C\B85C \C124\C815\B418\C5C8\C2B5\B2C8\B2E4. \C774 \BC29\C2DD\C740 \B9E4\C6B0 \C704\D5D8\D558\BA70 \C5EC\B7EC \B808\CF54\B4DC\B97C \BCF4\ACE0 \C800\C7A5\D560 \B54C \B370\C774\D130\B97C \C6B0\C5F0\D788 \ACB9\CCD0\C4F8 \C218 \C788\C2B5\B2C8\B2E4. \D56D\C0C1 ''\C0AC\C6A9\B41C \C18C\C2A4''\B97C ''\C138\C158 \C0C1\D0DC\C5D0\C11C \D56D\C0C1 \C784\C758\C758 \AE30\C874 \AC12 \BC14\AFB8\AE30''\B85C \C124\C815\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281987283166870675)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158 \C0C1\D0DC\C5D0 \B300\D55C \C561\C138\C2A4\AC00 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\B418\ACE0 \C77D\AE30/\C4F0\AE30 \C2DC\B3C4\AC00 \CC28\B2E8\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280787915722869909)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC \D504\B85C\C138\C2F1 \C911 \C138\C158 \C0C1\D0DC\C5D0 %0 \D56D\BAA9\C744 \C800\C7A5\D558\B824\ACE0 \D588\C2B5\B2C8\B2E4. \D56D\BAA9\C5D0 \B0B4\BD80 \C804\C6A9 \BCF4\D638\AC00 \C124\C815\B418\C5B4 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280769301783869898)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_language=>'ko'
,p_message_text=>unistr('\D5C8\C6A9 \D504\B85C\C138\C2F1 \C911 \C138\C158 \C0C1\D0DC\C5D0 %0 \D56D\BAA9\C744 \C800\C7A5\D558\B824\ACE0 \D588\C2B5\B2C8\B2E4. \D56D\BAA9\C5D0 \B0B4\BD80 \C804\C6A9 \BCF4\D638\AC00 \C124\C815\B418\C5B4 \C788\AC70\B098 \D56D\BAA9\C774 \AC8C\C2DC\B420 \C218 \C788\B294 \D3FC \D56D\BAA9\C774 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281043877333870073)
,p_name=>'APEX.SESSION_STATE.ITEM_VALUE_PROTECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158 \C0C1\D0DC \BCF4\D638 \C704\BC18: \BCF4\D638\B41C \D398\C774\C9C0 \D56D\BAA9 %0\C744(\B97C) \C218\B3D9\C73C\B85C \BCC0\ACBD\D588\AE30 \B54C\BB38\C77C \C218 \C788\C2B5\B2C8\B2E4. \C774 \C624\B958\C758 \C6D0\C778\C744 \C54C \C218 \C5C6\B294 \ACBD\C6B0\C5D0\B294 \C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\C5D0\AC8C \B3C4\C6C0\C744 \C694\CCAD\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282102763099870745)
,p_name=>'APEX.SESSION_STATE.PAGE_PROTECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \BCF4\D638 \C704\BC18: \B85C\B4DC\AC00 \C644\B8CC\B418\C9C0 \C54A\C740 \D398\C774\C9C0\B97C \C81C\CD9C\D558\AC70\B098 \BCF4\D638\B41C \D398\C774\C9C0 \D56D\BAA9\C744 \C218\B3D9\C73C\B85C \BCC0\ACBD\D588\AE30 \B54C\BB38\C77C \C218 \C788\C2B5\B2C8\B2E4. \CD94\AC00 \B3C4\C6C0\C774 \D544\C694\D558\BA74 \C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\C5D0\AC8C \BB38\C758\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282099655346870744)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \BD80\C801\D569\D55C \BB38\C790\C778 &<>"/;,*|=% \B610\B294 -- \BB38\C790 \C911 \D558\B098\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282099726155870744)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR_NL'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \BD80\C801\D569\D55C \BB38\C790\C778 &<>"/;,*|=% or -- \B610\B294 \C0C8 \D589 \C911 \D558\B098\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282099483854870743)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.US_ONLY'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \D2B9\C218 \BB38\C790\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4. \BB38\C790 a-Z, 0-9 \BC0F \ACF5\BC31\B9CC \D5C8\C6A9\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282099564257870743)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \BD80\C801\D569\D55C \BB38\C790\C778 <, > \B610\B294 "\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280768984086869898)
,p_name=>'APEX.SESSION_STATE.SSP_CHECKSUM_MISSING'
,p_message_language=>'ko'
,p_message_text=>unistr('\D558\B098 \C774\C0C1\C758 \C694\CCAD, \CE90\C2DC \BE44\C6B0\AE30 \B610\B294 \C778\C218 \AC12\C774 \B9E4\AC1C\BCC0\C218\B85C \C804\B2EC\B420 \B54C \CCB4\D06C\C12C\C774 \D544\C694\D55C \D398\C774\C9C0\C5D0 \B300\D55C \D45C\C2DC \D504\B85C\C138\C2F1\C5D0 \CCB4\D06C\C12C\C774 \C81C\ACF5\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281030803680870064)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158 \C0C1\D0DC \BCF4\D638 \C704\BC18: \CCB4\D06C\C12C\C774 \D3EC\D568\B41C URL\C744 \C218\B3D9\C73C\B85C \BCC0\ACBD\D558\AC70\B098, \CCB4\D06C\C12C\C774 \C798\BABB\B418\C5C8\AC70\B098 \B204\B77D\B41C \B9C1\D06C\B97C \C0AC\C6A9\D588\AE30 \B54C\BB38\C77C \C218 \C788\C2B5\B2C8\B2E4. \C774 \C624\B958\C758 \C6D0\C778\C744 \C54C \C218 \C5C6\B294 \ACBD\C6B0\C5D0\B294 \C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\C5D0\AC8C \B3C4\C6C0\C744 \C694\CCAD\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280769044595869898)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C694\CCAD, \CE90\C2DC \BE44\C6B0\AE30, \C778\C218 \C774\B984 \BC0F \C778\C218 \AC12(%0)\C5D0 \B300\D574 \ACC4\C0B0\B41C \CCB4\D06C\C12C\C774 \D45C\C2DC \D504\B85C\C2DC\C800(%1)\C5D0 \C804\B2EC\B41C \CCB4\D06C\C12C\ACFC \C77C\CE58\D558\C9C0 \C54A\C2B5\B2C8\B2E4.'),
'',
unistr('\CC38\ACE0: \C77C\BC18 \C0AC\C6A9\C790\C5D0\AC8C\B294 \B2E4\B978 \C624\B958 \BA54\C2DC\C9C0\AC00 \D45C\C2DC\B420 \C218 \C788\C2B5\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280767994046869897)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\D45C\C2DC \CC98\B9AC \C911 %0 \D56D\BAA9\C744 \C138\C158 \C0C1\D0DC\C5D0 \C800\C7A5\D558\B3C4\B85D \C2DC\B3C4\D569\B2C8\B2E4. \D56D\BAA9 \BCF4\D638 \B808\BCA8\C740 \B2E4\C74C\ACFC \AC19\C2B5\B2C8\B2E4.'),
'  %1',
'',
unistr('\CCB4\D06C\C12C\C774 \C804\B2EC\B418\C9C0 \C54A\C558\AC70\B098 \C804\B2EC\B41C \CCB4\D06C\C12C\C774 \BCF4\D638 \B808\BCA8 "%2"\C758 \D56D\BAA9\C5D0 \C801\D569\D569\B2C8\B2E4.'),
'',
unistr('\CC38\ACE0: \C77C\BC18 \C0AC\C6A9\C790\C5D0\AC8C \B2E4\B978 \C624\B958 \BA54\C2DC\C9C0\AC00 \D45C\C2DC\B429\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280978411737870027)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('ERR-1022 \C18D\C131\C744 \C800\C7A5\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281887472887870615)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_OFF'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\B300\BE44 \BAA8\B4DC \D574\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281887517105870615)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_ON'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\B300\BE44 \BAA8\B4DC \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281003235344870044)
,p_name=>'APEX.SHUTTLE.CONTROL_BOTTOM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B798\CABD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281003434582870045)
,p_name=>'APEX.SHUTTLE.CONTROL_DOWN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B798\B85C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281003524558870045)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281003630770870045)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \C774\B3D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281003726573870045)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281003821563870045)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281003969064870045)
,p_name=>'APEX.SHUTTLE.CONTROL_RESET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C7AC\C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281003185132870044)
,p_name=>'APEX.SHUTTLE.CONTROL_TOP'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C0C1\C704')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281003355386870045)
,p_name=>'APEX.SHUTTLE.CONTROL_UP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\B3D9 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282040600590870708)
,p_name=>'APEX.SINCE.SHORT.DAYS_AGO'
,p_message_language=>'ko'
,p_message_text=>'%0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282041384927870708)
,p_name=>'APEX.SINCE.SHORT.DAYS_FROM_NOW'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C77C \B0B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282040590277870708)
,p_name=>'APEX.SINCE.SHORT.HOURS_AGO'
,p_message_language=>'ko'
,p_message_text=>'%0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282041407623870708)
,p_name=>'APEX.SINCE.SHORT.HOURS_FROM_NOW'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C2DC\AC04 \B0B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282040374151870707)
,p_name=>'APEX.SINCE.SHORT.MINUTES_AGO'
,p_message_language=>'ko'
,p_message_text=>'%0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282041519727870708)
,p_name=>'APEX.SINCE.SHORT.MINUTES_FROM_NOW'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\BD84 \B0B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282040950349870708)
,p_name=>'APEX.SINCE.SHORT.MONTHS_AGO'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\AC1C\C6D4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282041120234870708)
,p_name=>'APEX.SINCE.SHORT.MONTHS_FROM_NOW'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\AC1C\C6D4 \B0B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282040410515870707)
,p_name=>'APEX.SINCE.SHORT.SECONDS_AGO'
,p_message_language=>'ko'
,p_message_text=>'%0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282041200158870708)
,p_name=>'APEX.SINCE.SHORT.SECONDS_FROM_NOW'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\CD08 \B0B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282040779669870708)
,p_name=>'APEX.SINCE.SHORT.WEEKS_AGO'
,p_message_language=>'ko'
,p_message_text=>'%0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282041685267870708)
,p_name=>'APEX.SINCE.SHORT.WEEKS_FROM_NOW'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C8FC \B0B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282040854855870708)
,p_name=>'APEX.SINCE.SHORT.YEARS_AGO'
,p_message_language=>'ko'
,p_message_text=>'%0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282041091094870708)
,p_name=>'APEX.SINCE.SHORT.YEARS_FROM_NOW'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\B144 \B0B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281217009872870190)
,p_name=>'APEX.SPLITTER.COLLAPSE_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD95\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281216976195870190)
,p_name=>'APEX.SPLITTER.RESTORE_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF5\C6D0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281623968306870455)
,p_name=>'APEX.STAR_RATING.CLEAR_RATING'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3C9\AC00 \C9C0\C6B0\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281587981271870433)
,p_name=>'APEX.STAR_RATING.INVALID_RATING_RANGE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C740(\B294) \C801\D569\D55C \B4F1\AE09 \BC94\C704 1 - %1\C5D0 \C18D\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281588008818870433)
,p_name=>'APEX.STAR_RATING.IS_NOT_NUMERIC'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C740(\B294) \C22B\C790\AC00 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281559985915870415)
,p_name=>'APEX.SUCCESS_MESSAGE_HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C131\ACF5 \BA54\C2DC\C9C0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280875651794869962)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C131\ACF5 \BA54\C2DC\C9C0 \CCB4\D06C\C12C \CF58\D150\CE20 \C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280875530794869962)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C131\ACF5 \BA54\C2DC\C9C0 \CCB4\D06C\C12C \D615\C2DD \C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282071870649870727)
,p_name=>'APEX.TABS.NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282071745155870727)
,p_name=>'APEX.TABS.PREVIOUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280727005617869872)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_language=>'ko'
,p_message_text=>unistr('#COMPONENT_NAME# \C5F4\C758 \AE30\BCF8\AC12\C744 \ACC4\C0B0\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280727613667869873)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C911 \D589 \C0AD\C81C \D504\B85C\C138\C2A4\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281012639604870051)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCB4\D06C\C12C \C5F4("FCS")\C774 \D544\C694\D55C\B370 \C81C\ACF5\B418\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281012861001870051)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\ACF5\B41C \AE30\BCF8 \D0A4 \AC12\C774 \C5C6\C2B5\B2C8\B2E4. \C5C5\B370\C774\D2B8\B97C \C218\D589\D558\B824\BA74 \C801\C5B4\B3C4 \D55C \AC1C\C758 \D589\C744 \C81C\ACF5\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281013648231870052)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DD\BCC4\B41C \BCF4\C870 \D0A4 \C5F4\C5D0 \B300\D574 \C81C\ACF5\B41C \BCF4\C870 \AC12 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281130502949870133)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C \D615\C2DD \D3FC\C5D0\C11C \B370\C774\D130\B97C \CC3E\C744 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281012534646870051)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \D0A4 \C5F4\C774 \C9C0\C815\B418\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281013553800870052)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C8\C758 \C120\D0DD \BAA9\B85D\C5D0\C11C \C9C0\C815\B41C \BCF4\C870 \D0A4 \C5F4\C744 \CC3E\C744 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281012400514870051)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C774\B984\C774 \C9C0\C815\B418\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281012370327870051)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C18C\C720\C790\AC00 \C9C0\C815\B418\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281034636838870066)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C911 \D589 \C5C5\B370\C774\D2B8 \D504\B85C\C138\C2A4\B97C \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282035221420870704)
,p_name=>'APEX.TB.TOOLBAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3C4\AD6C \BAA8\C74C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280895916106869974)
,p_name=>'APEX.TEAM.COMMITTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\CEE4\BC0B\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280895711127869974)
,p_name=>'APEX.TEAM.CONTRIBUTOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\ACF5\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280897616383869975)
,p_name=>'APEX.TEAM.CREATE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \AE30\B2A5\C774 \CD94\AC00\B418\C5C8\C2B5\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280897735528869975)
,p_name=>'APEX.TEAM.DELETE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \AE30\B2A5\C774 \C0AD\C81C\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280718088478869867)
,p_name=>'APEX.TEAM.DEPRECATED'
,p_message_language=>'ko'
,p_message_text=>unistr('APEX \D300 \AC1C\BC1C\C740 \BC84\C804 19.2\BD80\D130 \C0AC\C6A9\B418\C9C0 \C54A\C73C\BA70 \C774\D6C4 \B9B4\B9AC\C2A4\C5D0\C11C \C81C\AC70\B420 \C608\C815\C785\B2C8\B2E4. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280896042202869974)
,p_name=>'APEX.TEAM.ESTIMATED_EFFORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608\C0C1 \C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280896318763869974)
,p_name=>'APEX.TEAM.FEATURE_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280895500227869974)
,p_name=>'APEX.TEAM.FEATURE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280896135801869974)
,p_name=>'APEX.TEAM.FEATURE_STATUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5 \C0C1\D0DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280896297282869974)
,p_name=>'APEX.TEAM.MILESTONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C77C\C2A4\D1A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280896595511869974)
,p_name=>'APEX.TEAM.NO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B2C8\C624')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280895647458869974)
,p_name=>'APEX.TEAM.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280895815014869974)
,p_name=>'APEX.TEAM.RELEASE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9B4\B9AC\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280894663543869973)
,p_name=>'APEX.TEAM.SAVE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \AE30\B2A5\C774 \C5C5\B370\C774\D2B8\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280896442363869974)
,p_name=>'APEX.TEAM.YES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282074623598870728)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_NAV_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0D0\C0C9 \D655\C7A5/\CD95\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282074707882870728)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_SIDE_COL_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE21\BA74 \C5F4 \D655\C7A5/\CD95\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280750787980869887)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('"%1" \C560\D50C\B9AC\CF00\C774\C158\C758 "%0" \D14C\B9C8\B97C \BCF5\C0AC\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282067106285870724)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C784\D3EC\D2B8\B41C \D14C\B9C8\B294 \D604\C7AC \D14C\B9C8\C640 \D638\D658\B418\C9C0 \C54A\C2B5\B2C8\B2E4.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282032991013870703)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8 \BC88\D638\AC00 \BD80\C801\D569\D558\AC70\B098 \D14C\B9C8\AC00 \D604\C7AC UI \D14C\B9C8\AC00 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281356830020870280)
,p_name=>'APEX.TIME.DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('1\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281356672880870280)
,p_name=>'APEX.TIME.HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('1\C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281356947066870280)
,p_name=>'APEX.TIME.N_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281356745914870280)
,p_name=>'APEX.TIME.N_HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281356584944870280)
,p_name=>'APEX.TIME.N_MINUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\BD84')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281357126167870280)
,p_name=>'APEX.TIME.N_WEEKS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281357064642870280)
,p_name=>'APEX.TIME.WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('1\C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281986366084870675)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\CE35 \ACC4\C0B0\C5D0 \D544\C694\D55C \AE30\BCF8 \D0A4 \BC0F \C0C1\C704 \D0A4 \C5F4\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281986455225870675)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\CE35\C774 \ACC4\C0B0\B418\C9C0 \C54A\C740 \ACBD\C6B0 \D544\C694\D55C \B178\B4DC \B808\BCA8 \BC0F \B178\B4DC \C0C1\D0DC \C5F4\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282094359880870740)
,p_name=>'APEX.UI.BACK_TO_TOP'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C2DC\C791')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280912073693869984)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5B4\B461\AC8C \BAA8\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280912290695869984)
,p_name=>'APEX.UI.DISABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9 \C548\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280912101464869984)
,p_name=>'APEX.UI.ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C73C\B85C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281351781790870276)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B798 \BAA9\B85D\C5D0\C11C \C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4\B97C \C120\D0DD\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281354262767870278)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 - \C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \C120\D0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280727315508869873)
,p_name=>'APEX.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C694\CCAD\C744 \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280872298453869960)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\B418\C9C0 \C54A\C740 \C561\C138\C2A4(\BCF4\C548 \ADF8\B8F9 \D328\D0A4\C9C0 \BCC0\C218\AC00 \C124\C815\B418\C9C0 \C54A\C74C)\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280872871353869960)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \CC3E\AE30 \C815\BCF4\B97C \C778\CD9C\D560 \C218 \C5C6\C2B5\B2C8\B2E4. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280860057841869952)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C0AC\C6A9\C790\AC00 \C774 \C791\C5C5\C744 \C218\D589\D558\B824\BA74 \AD00\B9AC\C790 \AD8C\D55C\C774 \D544\C694\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280872799675869960)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C0AC\C6A9\C790\AC00 \C804\C790\BA54\C77C \C8FC\C18C\B97C \C81C\ACF5\D558\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280828285211869933)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\B418\C9C0 \C54A\C740 \C561\C138\C2A4\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280872626699869960)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C0AC\C6A9\C790\B294 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280978559929870027)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C99D\C744 \CC98\B9AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281360714884870283)
,p_name=>'APEX.VALUE_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\C218 \AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282083901522870734)
,p_name=>'APEX.WAIT_UNTIL_PAGE_LOADED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\AC00 \C644\C804\D788 \B85C\B4DC\B420 \B54C\AE4C\C9C0 \AE30\B2E4\B9B0 \D6C4 \B2E4\C2DC \C2DC\B3C4\D558\C2ED\C2DC\C624.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281907865086870627)
,p_name=>'APEX.WARN_ON_UNSAVED_CHANGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0\C5D0 \C800\C7A5\B418\C9C0 \C54A\C740 \BCC0\ACBD\C0AC\D56D\C774 \C788\C2B5\B2C8\B2E4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281987759356870676)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_language=>'ko'
,p_message_text=>unistr('Application Express\B294 %0 \C720\D615\C758 \C751\B2F5 \B370\C774\D130\C5D0\C11C \B370\C774\D130 \D504\B85C\D30C\C77C\C744 \ACC4\C0B0\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281418537278870325)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281418477330870325)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281971610615870666)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \D45C\D604\C2DD\C774 \C801\D569\D55C JSON\C774 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281963337764870661)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_language=>'ko'
,p_message_text=>unistr('Oracle REST Data Services\B294 \D544\D130\B97C \C9C0\C6D0\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281305099777870246)
,p_name=>'APEX.WEBSRC.HIDE_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\B41C \C5F4 \C228\AE30\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281397989383870309)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 200: \C131\ACF5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281398067152870310)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 201: \C0DD\C131\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281397437037870309)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 400: \C798\BABB\B41C \C694\CCAD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281397236171870309)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 401: \AD8C\D55C\C774 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281397525104870309)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 403: \C0AC\C6A9\D560 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281397355610870309)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 404: \CC3E\C744 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281397627922870309)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 405: \BA54\C18C\B4DC\B97C \C0AC\C6A9\D560 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280717235324869867)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 407: \D504\B85D\C2DC \C778\C99D \D544\C694')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280717517086869867)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 409: \CDA9\B3CC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280717356244869867)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 412: \C0AC\C804 \C870\AC74 \C2E4\D328')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280717432393869867)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 428: \C0AC\C804 \C870\AC74 \D544\C694')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281397730149870309)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 500: \B0B4\BD80 \C11C\BC84 \C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281397815384870309)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 502: \C798\BABB\B41C \AC8C\C774\D2B8\C6E8\C774')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281988171798870676)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 503: \C11C\BE44\C2A4\B97C \C0AC\C6A9\D560 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281988248119870676)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP 504: \AC8C\C774\D2B8\C6E8\C774 \C2DC\AC04 \CD08\ACFC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281907711953870627)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C18C\C2A4\C5D0\C11C HTTP \C624\B958 \BC18\D658: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281396371531870308)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C18C\C2A4 \BAA8\B4C8\C744 \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280940636601870001)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C120\D0DD\AE30 "%0"\C774(\AC00) \D14C\C774\BE14\B85C \CC98\B9AC\B420 \AC1D\CCB4 \BC30\C5F4\C744 \C120\D0DD\D558\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280940715397870001)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C120\D0DD\AE30 "%0"\C774(\AC00) \B2E8\C77C \D589\C73C\B85C \CC98\B9AC\B420 \AC1D\CCB4\B97C \C120\D0DD\D558\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281907685372870627)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_language=>'ko'
,p_message_text=>unistr('"%1" \C720\D615\C758 \D544\C218 \C6F9 \C18C\C2A4 IN \B9E4\AC1C\BCC0\C218 "%0"\C5D0\B294 \AC12\C774 \C788\C5B4\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281890274997870616)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C751\B2F5 \BCF8\BB38\C774 \B108\BB34 \CEE4\C11C \D45C\C2DC\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281305269832870246)
,p_name=>'APEX.WEBSRC.SHOW_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\B41C \C5F4 \D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281360643037870283)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\AC70\C2DC ORDS REST \C11C\BE44\C2A4\C5D0 \C791\C740 \ACE0\C815 \D398\C774\C9C0 \D06C\AE30\AC00 \C0AC\C6A9\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281305618580870246)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C6F9 \C18C\C2A4 \B370\C774\D130\B97C \C778\CD9C\D558\B294 \C911 \C2DC\AC04 \CD08\ACFC \AC12\C774 \CD08\ACFC\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281280342319870230)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \B85C\CEEC SQL \D544\D130\C758 \ACBD\C6B0 REST \C11C\BE44\C2A4\C5D0 \B300\D574 \B108\BB34 \B9CE\C740 "\B2E4\C74C \D398\C774\C9C0" \C694\CCAD\C774 \D544\C694\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281360554295870282)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\AC70\C2DC ORDS REST \C11C\BE44\C2A4\C5D0 \B300\D55C \ACE0\C815 \D398\C774\C9C0 \D06C\AE30\B97C \C54C \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282012146904870690)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3D9\C801 \C791\C5C5 ''#COMPONENT_NAME#''\C5D0 \B300\D574 \C9C0\C815\B41C \B300\D654\C2DD \ADF8\B9AC\B4DC \C5F4 ''%0''\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282012334317870690)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C7A0\AE08\C744 \C218\D589\D558\B294 \C911 ''%0'' \D504\B85C\C138\C2A4\C5D0\C11C ''%1''\C774(\AC00) \BC1C\C0DD\D588\C2B5\B2C8\B2E4. \D504\B85C\C138\C2A4 \C911\C5D0 \D589\C744 \C7A0\ADF8\AE30 \C704\D574 \C778\C2A4\D134\C2A4 \D2B8\B9AC\AC70\B97C \C0AC\C6A9\D558\C5EC \BCF5\C7A1\D55C \BCF4\AE30\C5D0\C11C SELECT FOR UPDATE\B97C \C2E4\D589\D558\B294 \ACBD\C6B0\C5D0 \C774 \C624\B958\AC00 \BC1C\C0DD\D560 \C218 \C788\C2B5\B2C8\B2E4. ''\D589 \C7A0\ADF8\AE30'' \D504\B85C\C138\C2A4 \C18D\C131\C744 \C544\B2C8\C624 \B610\B294 PL/SQL \CF54\B4DC\B85C \C124\C815\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282012291290870690)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('DML \BA85\B839\C744 \C2E4\D589\D558\B294 \C911 ''%0'' \D504\B85C\C138\C2A4\C5D0\C11C ''%1''\C774(\AC00) \BC1C\C0DD\D588\C2B5\B2C8\B2E4. \C774 \C624\B958\B294 \C5F4\C774 \C9D1\ACC4 \B610\B294 SQL \D45C\D604\C2DD\C744 \AE30\BC18\C73C\B85C \D558\B294 \ACBD\C6B0\C5D0 \BC1C\C0DD\D560 \C218 \C788\C2B5\B2C8\B2E4. INSERT \BC0F UPDATE \BB38\C5D0\C11C \C5F4\C744 \C81C\C678\D558\B824\BA74 ''\C9C8\C758 \C804\C6A9'' \C5F4 \C18D\C131\C744 \C608\B85C \C124\C815\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281676371967870486)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \B514\D14C\C77C \C5F4 ''%0''\C5D0 \AC12\C774 \D3EC\D568\B418\C5B4 \C788\C9C0 \C54A\C2B5\B2C8\B2E4. ''%1'' \D504\B85C\C138\C2A4\AC00 \B9C8\C2A4\D130 \C601\C5ED\C758 \D574\B2F9\D558\B294 \D504\B85C\C138\C2A4 \C774\D6C4 \C2E4\D589\B418\C5C8\B294\C9C0 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281993982180870679)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \ADF8\B9AC\B4DC ''%0''\C5D0 \B9C8\C2A4\D130 \B514\D14C\C77C \AD00\ACC4\B97C \C704\D574 \D544\C694\D55C \B9C8\C2A4\D130 \C5F4\C774 \C815\C758\B418\C5B4 \C788\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281350090775870275)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \ADF8\B9AC\B4DC ''%0''\C5D0 \D3B8\C9D1\C744 \C704\D574 \B610\B294 \B9C8\C2A4\D130 \B514\D14C\C77C \AD00\ACC4\C5D0\C11C \D544\C694\D55C \AE30\BCF8 \D0A4 \C5F4\C774 \C815\C758\B418\C5B4 \C788\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281965688794870662)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3B8\C9D1 \AC00\B2A5\D55C \B300\D654\C2DD \ADF8\B9AC\B4DC\C758 \ACBD\C6B0, \D398\C774\C9C0 \C18D\C131 ''\C81C\CD9C \C2DC \B2E4\C2DC \B85C\B4DC''\AC00 ''\C131\ACF5 \C2DC\C5D0\B9CC''\C73C\B85C \C124\C815\B418\C5B4\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281965736166870662)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C \D615\C2DD \D3FC\C758 \ACBD\C6B0, \D398\C774\C9C0 \C18D\C131 ''\C81C\CD9C \C2DC \B2E4\C2DC \B85C\B4DC''\AC00 ''\D56D\C0C1''\C73C\B85C \C124\C815\B418\C5B4\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280907785925869981)
,p_name=>'APEXIR_3D'
,p_message_language=>'ko'
,p_message_text=>'3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282001051681870684)
,p_name=>'APEXIR_ACTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281128463640870131)
,p_name=>'APEXIR_ACTIONS_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \BA54\B274')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281033341991870065)
,p_name=>'APEXIR_ADD'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281118033465870124)
,p_name=>'APEXIR_ADD_FUNCTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D568\C218 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281117945356870124)
,p_name=>'APEXIR_ADD_GROUP_BY_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900 \C5F4 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281442486218870342)
,p_name=>'APEXIR_ADD_PIVOT_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97 \C5F4 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281442527273870342)
,p_name=>'APEXIR_ADD_ROW_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C5F4 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281606271760870444)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\C785 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280907959385869981)
,p_name=>'APEXIR_AGGREGATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9D1\ACC4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281152485736870148)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9D1\ACC4\B294 \AC01 \C81C\C5B4 \CC28\B2E8 \B4A4\C640 \BCF4\ACE0\C11C \B05D\C5D0 \D45C\C2DC\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281155531333870150)
,p_name=>'APEXIR_AGGREGATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9D1\ACC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281033896380870066)
,p_name=>'APEXIR_AGG_AVG'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3C9\ADE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281042719921870072)
,p_name=>'APEXIR_AGG_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281059743526870084)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\C720 \AC1C\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281033994160870066)
,p_name=>'APEXIR_AGG_MAX'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281034133103870066)
,p_name=>'APEXIR_AGG_MEDIAN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\AC04\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281034053491870066)
,p_name=>'APEXIR_AGG_MIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C18C\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281034264456870066)
,p_name=>'APEXIR_AGG_MODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281033780394870066)
,p_name=>'APEXIR_AGG_SUM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D569\ACC4 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281035594287870067)
,p_name=>'APEXIR_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280906974728869981)
,p_name=>'APEXIR_ALL_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280757749159869891)
,p_name=>'APEXIR_ALL_ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281997529921870681)
,p_name=>'APEXIR_ALTERNATIVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\CCB4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281999677617870683)
,p_name=>'APEXIR_ALTERNATIVE_DEFAULT_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\CCB4 \AE30\BCF8\AC12: %0 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280993667726870038)
,p_name=>'APEXIR_AND'
,p_message_language=>'ko'
,p_message_text=>'~'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280914472254869985)
,p_name=>'APEXIR_APPLY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\C6A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281963546190870661)
,p_name=>'APEXIR_AREA'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280878364480869963)
,p_name=>'APEXIR_ASCENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B984\CC28\C21C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281006140705870046)
,p_name=>'APEXIR_AS_OF'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C810: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282000243672870683)
,p_name=>'APEXIR_AVERAGE_X'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3C9\ADE0 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281963408739870661)
,p_name=>'APEXIR_BAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C9\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280910843587869983)
,p_name=>'APEXIR_BETWEEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C0AC\C774')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280877080668869963)
,p_name=>'APEXIR_BGCOLOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC30\ACBD\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281603265986870442)
,p_name=>'APEXIR_BLACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C815\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280879123491869964)
,p_name=>'APEXIR_BLUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\B780\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281120832665870126)
,p_name=>'APEXIR_BOTTOM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B798\CABD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281035180836870067)
,p_name=>'APEXIR_CALENDAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EC\B825')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280879792215869964)
,p_name=>'APEXIR_CANCEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CDE8\C18C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280919893875869988)
,p_name=>'APEXIR_CATEGORY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC94\C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280876990957869963)
,p_name=>'APEXIR_CELL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C140')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281035063933870067)
,p_name=>'APEXIR_CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281124096686870128)
,p_name=>'APEXIR_CHART_INITIALIZING'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD08\AE30\D654 \C911...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281478322738870365)
,p_name=>'APEXIR_CHART_LABEL_NOT_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \B808\C774\BE14\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281590842479870434)
,p_name=>'APEXIR_CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\B2F9 \C9C8\C758\B294 \CC28\D2B8\B2F9 \CD5C\B300 \B370\C774\D130 \D3EC\C778\D2B8 \C218 %0\AC1C\B97C \CD08\ACFC\D569\B2C8\B2E4. \AE30\BCF8 \C9C8\C758\C758 \B808\CF54\B4DC \C218\B97C \C904\C774\B824\BA74 \D544\D130\B97C \C801\C6A9\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281584879611870431)
,p_name=>'APEXIR_CHART_MAX_ROW_CNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \C9C8\C758\C5D0 \B300\D55C \CD5C\B300 \D589 \C218\B294 \D45C\C2DC\B418\B294 \D589 \C218\AC00 \C544\B2CC \AE30\BCF8 \C9C8\C758\C758 \D589 \C218\B97C \C81C\D55C\D569\B2C8\B2E4. \AE30\BCF8 \C9C8\C758\AC00 \CD5C\B300 \D589 \C218 %0\AC1C\B97C \CD08\ACFC\D569\B2C8\B2E4. \AE30\BCF8 \C9C8\C758\C758 \B808\CF54\B4DC \C218\B97C \C904\C774\B824\BA74 \D544\D130\B97C \C801\C6A9\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280907244798869981)
,p_name=>'APEXIR_CHART_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281560640697870416)
,p_name=>'APEXIR_CHECK_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \C120\D0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281006544277870047)
,p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \B2E4\C6B4\B85C\B4DC \D615\C2DD \C120\D0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281109265385870118)
,p_name=>'APEXIR_CLEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C6B0\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280879614836869964)
,p_name=>'APEXIR_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281152517953870148)
,p_name=>'APEXIR_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281979780342870671)
,p_name=>'APEXIR_COLUMN_FILTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281118999497870125)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \BA38\B9AC\AE00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281112999313870121)
,p_name=>'APEXIR_COLUMN_HEADING_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \BA38\B9AC\AE00 \BA54\B274')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281123871020870128)
,p_name=>'APEXIR_COLUMN_INFO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281989902178870677)
,p_name=>'APEXIR_COLUMN_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281118662228870124)
,p_name=>'APEXIR_COLUMN_N'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280987906775870034)
,p_name=>'APEXIR_COMPARISON_CONTAINS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C744 \D3EC\D568')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280992671384870037)
,p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C744 \D3EC\D568\D558\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280878070038869963)
,p_name=>'APEXIR_COMPARISON_IN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C5D0 \C18D\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280992893297870037)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C774 \B9C8\C9C0\B9C9\C774 \C544\B2D8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281038247169870069)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C774 \CC28\AE30\AC00 \C544\B2D8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280992770758870037)
,p_name=>'APEXIR_COMPARISON_IS_IN_LAST'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C774 \B9C8\C9C0\B9C9\C784')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281038166094870069)
,p_name=>'APEXIR_COMPARISON_IS_IN_NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C774 \CC28\AE30\C784')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280877940588869963)
,p_name=>'APEXIR_COMPARISON_IS_NOT_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C774 \B110\C774 \C544\B2D8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280877830775869963)
,p_name=>'APEXIR_COMPARISON_IS_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C774 \B110\C784')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280877644374869963)
,p_name=>'APEXIR_COMPARISON_LIKE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\ACFC \C720\C0AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280878170553869963)
,p_name=>'APEXIR_COMPARISON_NOT_IN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C5D0 \C18D\D558\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280877771507869963)
,p_name=>'APEXIR_COMPARISON_NOT_LIKE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\ACFC \C720\C0AC\D558\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280988624052870034)
,p_name=>'APEXIR_COMPARISON_REGEXP_LIKE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\ADDC \D45C\D604\C2DD \C77C\CE58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281006440026870047)
,p_name=>'APEXIR_COMPUTATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C0B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281584463558870430)
,p_name=>'APEXIR_COMPUTATION_EXPRESSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C0B0 \D45C\D604\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281152845729870148)
,p_name=>'APEXIR_COMPUTATION_FOOTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \BCC4\CE6D\C744 \C0AC\C6A9\D558\C5EC \ACC4\C0B0\C744 \C0DD\C131\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281152954447870148)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E1'
,p_message_language=>'ko'
,p_message_text=>'(B+C)*100'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281153017351870148)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E2'
,p_message_language=>'ko'
,p_message_text=>'INITCAP(B)||'', ''||INITCAP(C)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281153164302870148)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E3'
,p_message_language=>'ko'
,p_message_text=>'CASE WHEN A = 10 THEN B + C ELSE B END'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280745014820869883)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E4'
,p_message_language=>'ko'
,p_message_text=>'ROUND(C / 1000000)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281036267102870067)
,p_name=>'APEXIR_COMPUTE'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C0B0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281119660191870125)
,p_name=>'APEXIR_CONTROL_BREAK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \CC28\B2E8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281127894335870131)
,p_name=>'APEXIR_CONTROL_BREAKS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \CC28\B2E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282008389927870688)
,p_name=>'APEXIR_CONTROL_BREAK_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \CC28\B2E8 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280737216800869879)
,p_name=>'APEXIR_COUNT_DISTINCT'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\C720 \AC1C\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282000779108870683)
,p_name=>'APEXIR_COUNT_DISTINCT_X'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\C720 \AC1C\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282000678360870683)
,p_name=>'APEXIR_COUNT_X'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\C218 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281603732691870442)
,p_name=>'APEXIR_DAILY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\BCC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282093230897870740)
,p_name=>'APEXIR_DATA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281123955432870128)
,p_name=>'APEXIR_DATA_AS_OF'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\BD84 \C804\C758 \BCF4\ACE0\C11C \B370\C774\D130\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281955052167870656)
,p_name=>'APEXIR_DATA_GRID_HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \ADF8\B9AC\B4DC \B3C4\C6C0\B9D0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280908174583869981)
,p_name=>'APEXIR_DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281999298213870682)
,p_name=>'APEXIR_DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281150160581870146)
,p_name=>'APEXIR_DEFAULT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281997325443870681)
,p_name=>'APEXIR_DEFAULT_REPORT_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \BCF4\ACE0\C11C \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280879830711869964)
,p_name=>'APEXIR_DELETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AD\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281037077686870068)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\B41C \D56D\BAA9 \C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280909082535869982)
,p_name=>'APEXIR_DELETE_CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BCF4\ACE0\C11C \C124\C815\C744 \C0AD\C81C\D558\ACA0\C2B5\B2C8\AE4C?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281154390220870149)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C0AD\C81C \C791\C5C5\C744 \C218\D589\D558\ACA0\C2B5\B2C8\AE4C?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281888044946870615)
,p_name=>'APEXIR_DELETE_DEFAULT_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \BCF4\ACE0\C11C \C0AD\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281119381142870125)
,p_name=>'APEXIR_DELETE_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C0AD\C81C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280878438688869963)
,p_name=>'APEXIR_DESCENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4\B9BC\CC28\C21C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280919968488869988)
,p_name=>'APEXIR_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281112822690870121)
,p_name=>'APEXIR_DETAIL_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\C77C \D589 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281151144506870147)
,p_name=>'APEXIR_DIRECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC29\D5A5: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281128353261870131)
,p_name=>'APEXIR_DISABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9 \C548\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281152310615870148)
,p_name=>'APEXIR_DISABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9 \C548\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280908282180869981)
,p_name=>'APEXIR_DISPLAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280879332576869964)
,p_name=>'APEXIR_DISPLAYED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280906808587869981)
,p_name=>'APEXIR_DISPLAYED_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC\B41C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281151052937870147)
,p_name=>'APEXIR_DISPLAY_IN_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\C5D0 \D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280880024817869964)
,p_name=>'APEXIR_DONUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3C4\B11B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281120703428870126)
,p_name=>'APEXIR_DOWN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B798\B85C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281036301876870068)
,p_name=>'APEXIR_DOWNLOAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C6B4\B85C\B4DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280908074506869981)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_language=>'ko'
,p_message_text=>unistr('- \C9D1\ACC4 \C548\D568 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281150948055870147)
,p_name=>'APEXIR_DO_NOT_DISPLAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC \C548\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282008527417870688)
,p_name=>'APEXIR_DUPLICATE_PIVOT_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\BCF5\B41C \D53C\BC97 \C5F4\C774 \C788\C2B5\B2C8\B2E4. \D53C\BC97 \C5F4 \BAA9\B85D\C740 \ACE0\C720\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282008942370870688)
,p_name=>'APEXIR_EDIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281947605675870651)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\CCB4 \AE30\BCF8\AC12 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281124137163870128)
,p_name=>'APEXIR_EDIT_CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \C124\C815 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281154113889870149)
,p_name=>'APEXIR_EDIT_CHART2'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281154631417870149)
,p_name=>'APEXIR_EDIT_FILTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281650584921870471)
,p_name=>'APEXIR_EDIT_GROUP_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281154504501870149)
,p_name=>'APEXIR_EDIT_HIGHLIGHT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281467240019870358)
,p_name=>'APEXIR_EDIT_PIVOT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281997641213870682)
,p_name=>'APEXIR_EMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280822958594869930)
,p_name=>'APEXIR_EMAIL_ADDRESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C8FC\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281997960716870682)
,p_name=>'APEXIR_EMAIL_BCC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C228\C740 \CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281998120552870682)
,p_name=>'APEXIR_EMAIL_BODY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF8\BB38')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281997889759870682)
,p_name=>'APEXIR_EMAIL_CC'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281998800229870682)
,p_name=>'APEXIR_EMAIL_FREQUENCY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE48\B3C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280857766201869951)
,p_name=>'APEXIR_EMAIL_NOT_CONFIGURED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C\C774 \C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D574 \AD6C\C131\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4. \AD00\B9AC\C790\C5D0\AC8C \BB38\C758\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281602819342870442)
,p_name=>'APEXIR_EMAIL_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C8FC\C18C\B97C \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281998244340870682)
,p_name=>'APEXIR_EMAIL_SEE_ATTACHED'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCA8\BD80 \CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281998061894870682)
,p_name=>'APEXIR_EMAIL_SUBJECT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281604792993870443)
,p_name=>'APEXIR_EMAIL_SUBJECT_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C81C\BAA9\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281997771610870682)
,p_name=>'APEXIR_EMAIL_TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC1B\B294 \C0AC\B78C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281128229212870131)
,p_name=>'APEXIR_ENABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280876768080869962)
,p_name=>'APEXIR_ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C73C\B85C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281154417349870149)
,p_name=>'APEXIR_ENABLE_DISABLE_ALT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9/\C0AC\C6A9 \C548\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281153832108870149)
,p_name=>'APEXIR_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281153202336870148)
,p_name=>'APEXIR_EXAMPLES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281154276105870149)
,p_name=>'APEXIR_EXAMPLES_WITH_COLON'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608\C81C:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280906701095869980)
,p_name=>'APEXIR_EXCLUDE_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B110 \AC12 \C81C\C678')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281155167152870150)
,p_name=>'APEXIR_EXPAND_COLLAPSE_ALT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D655\C7A5/\CD95\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281152021282870148)
,p_name=>'APEXIR_EXPRESSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\D604\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281035826192870067)
,p_name=>'APEXIR_FILTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281127753796870131)
,p_name=>'APEXIR_FILTERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281212293350870187)
,p_name=>'APEXIR_FILTER_EXPRESSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \D45C\D604\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282075118954870729)
,p_name=>'APEXIR_FILTER_EXPR_TOO_LONG'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \D45C\D604\C2DD\C774 \B108\BB34 \AE41\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281212110818870187)
,p_name=>'APEXIR_FILTER_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281155321379870150)
,p_name=>'APEXIR_FINDER_ALT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9\D560 \C5F4\C744 \C120\D0DD\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281036149482870067)
,p_name=>'APEXIR_FLASHBACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\C2DC\BC31')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281151744089870147)
,p_name=>'APEXIR_FLASHBACK_DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\C2DC\BC31 \C9C8\C758\B97C \C0AC\C6A9\D558\BA74 \C774\C804 \C2DC\C810\C5D0 \C874\C7AC\D55C \ADF8\B300\B85C \B370\C774\D130\B97C \BCFC \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281153611253870149)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\C2DC\BC31 \C694\CCAD\C744 \C218\D589\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281603428353870442)
,p_name=>'APEXIR_FLASHBACK_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\C2DC\BC31 \AE30\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281612052523870447)
,p_name=>'APEXIR_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D615\C2DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281006302299870047)
,p_name=>'APEXIR_FORMAT_MASK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D615\C2DD \B9C8\C2A4\D06C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281119036640870125)
,p_name=>'APEXIR_FUNCTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D568\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281152785521870148)
,p_name=>'APEXIR_FUNCTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D568\C218: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281997283392870681)
,p_name=>'APEXIR_FUNCTIONS_OPERATORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D568\C218/\C5F0\C0B0\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281584969752870431)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D568\C218 \C5F4 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281118531752870124)
,p_name=>'APEXIR_FUNCTION_N'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D568\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281035694615870067)
,p_name=>'APEXIR_GO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281603345649870442)
,p_name=>'APEXIR_GRAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\D68C\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280877261246869963)
,p_name=>'APEXIR_GREEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B179\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280737359642869879)
,p_name=>'APEXIR_GROUP_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281998344909870682)
,p_name=>'APEXIR_GROUP_BY_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900 \C5F4 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281478405952870365)
,p_name=>'APEXIR_GROUP_BY_COL_NOT_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900 \C5F4\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281584797437870431)
,p_name=>'APEXIR_GROUP_BY_MAX_ROW_CNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C8\C758\BCC4 \ADF8\B8F9\C758 \CD5C\B300 \D589 \C218\B294 \D45C\C2DC\B418\B294 \D589 \C218\AC00 \C544\B2CC \AE30\BCF8 \C9C8\C758\C758 \D589 \C218\B97C \C81C\D55C\D569\B2C8\B2E4. \AE30\BCF8 \C9C8\C758\AC00 \CD5C\B300 \D589 \C218 %0\AC1C\B97C \CD08\ACFC\D569\B2C8\B2E4. \AE30\BCF8 \C9C8\C758\C758 \B808\CF54\B4DC \C218\B97C \C904\C774\B824\BA74 \D544\D130\B97C \C801\C6A9\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281398853916870310)
,p_name=>'APEXIR_GROUP_BY_SORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C\BCC4 \ADF8\B8F9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282008456331870688)
,p_name=>'APEXIR_GROUP_BY_SORT_ORDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900 \C815\B82C \C21C\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280907365920869981)
,p_name=>'APEXIR_HCOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\D3C9 \B9C9\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281145583695870143)
,p_name=>'APEXIR_HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3C4\C6C0\B9D0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281111167590870119)
,p_name=>'APEXIR_HELP_01'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\B300\D654\C2DD \BCF4\ACE0\C11C\C5D0\C11C\B294 \C77C\BC18 \C0AC\C6A9\C790\AC00 \BCF4\ACE0\C11C\B97C \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4. \C0AC\C6A9\C790\B294 \C5F4\C744 \C120\D0DD\D558\ACE0, \D544\D130\B97C \C801\C6A9\D558\ACE0, \AC15\C870 \D45C\C2DC \BC0F \C815\B82C\C744 \C218\D589\D558\C5EC \BCF4\ACE0\C11C \B370\C774\D130\C758 \B808\C774\C544\C6C3\C744 \BCC0\ACBD\D560 \C218 \C788\C2B5\B2C8\B2E4. \C0AC\C6A9\C790\B294 \B610\D55C \C911\B2E8\C810, \C9D1\ACC4, \CC28\D2B8, \ADF8\B8F9 \AE30\C900\C744 \C815\C758\D558\ACE0 \ACE0\C720 \ACC4\C0B0\C744 \CD94\AC00\D560 \C218 \C788\C2B5\B2C8\B2E4. \C0AC\C6A9\C790\B294 \C9C0\C815\B41C \AC04\ACA9\C5D0 \B530\B77C \BCF4\ACE0\C11C\C758 HTML \BC84\C804\C744 \C804\C790\BA54\C77C\B85C \BCF4\B0B4\B3C4\B85D \AC00\C785\C744 \C124\C815\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4. \C0AC\C6A9\C790\B294 \BCF4\ACE0\C11C\B97C \C5EC\B7EC \AC00\C9C0 \D615\D0DC\B85C \C0DD\C131\D558\ACE0 \ACF5\C6A9 \B610\B294 \C804\C6A9 \BCF4\AE30')
||unistr('\B97C \C704\D574 \C774\B984\C774 \C9C0\C815\B41C \BCF4\ACE0\C11C\B85C \C800\C7A5\D560 \C218 \C788\C2B5\B2C8\B2E4. '),
'<p/>',
unistr('\C774\D6C4 \C139\C158\C5D0\C11C\B294 \B300\D654\C2DD \BCF4\ACE0\C11C\B97C \C0AC\C6A9\C790\AC00 \C815\C758\D560 \C218 \C788\B294 \BC29\BC95\C744 \C694\C57D\D574\C11C \BCF4\C5EC\C90D\B2C8\B2E4. \C790\C138\D55C \B0B4\C6A9\C740 <i>Oracle Application Express End User''s Guide</i></a>\C5D0\C11C "Using Interactive Reports"\B97C \CC38\C870\D558\C2ED\C2DC\C624.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281128560403870131)
,p_name=>'APEXIR_HELP_ACTIONS_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \BA54\B274\B294 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C\C758 [\C2E4\D589] \B2E8\CD94 \C624\B978\CABD\C5D0 \D45C\C2DC\B429\B2C8\B2E4. \C774 \BA54\B274\B97C \C0AC\C6A9\D558\C5EC \B300\D654\C2DD \BCF4\ACE0\C11C\B97C \C0AC\C6A9\C790\C815\C758\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281112123230870120)
,p_name=>'APEXIR_HELP_AGGREGATE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C9D1\ACC4\B294 \C5F4\C5D0 \B300\D574 \C218\D589\B418\B294 \C218\D559 \ACC4\C0B0\C785\B2C8\B2E4. \C9D1\ACC4\B294 \C815\C758\B41C \C5F4 \B0B4\C5D0\C11C \AC01 \C81C\C5B4 \CC28\B2E8 \B4A4\C640 \BCF4\ACE0\C11C \B05D\C5D0 \D45C\C2DC\B429\B2C8\B2E4. \C635\C158\C740 \B2E4\C74C\ACFC \AC19\C2B5\B2C8\B2E4.'),
'<p>',
'</p><ul>',
unistr('<li><b>\C9D1\ACC4</b>\B97C \C0AC\C6A9\D558\BA74 \C774\C804\C5D0 \C815\C758\B41C \C9D1\ACC4\B97C '),
unistr('\C120\D0DD\D558\C5EC \D3B8\C9D1\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('<li><b>\D568\C218</b>\B294 \C218\D589\D560 \D568\C218(\C608: SUM, MIN)\C785\B2C8\B2E4.</li>'),
unistr('<li><b>\C5F4</b>\C740 \C218\D559 \D568\C218\B97C \C801\C6A9\D560 \C5F4\C744 \C120\D0DD\D558\B294 \B370 \C0AC\C6A9\B429\B2C8\B2E4. '),
unistr('\C22B\C790 \C5F4\B9CC \D45C\C2DC\B429\B2C8\B2E4.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281112277179870120)
,p_name=>'APEXIR_HELP_CHART'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C800\C7A5\B41C \BCF4\ACE0\C11C\B2F9 \D558\B098\C758 \CC28\D2B8\B97C \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4. \CC28\D2B8\AC00'),
unistr('\C815\C758\B418\BA74 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C\C5D0 \C788\B294 \BCF4\AE30 \C544\C774\CF58\C744 \C0AC\C6A9\D574\C11C \CC28\D2B8 \BCF4\AE30 \B610\B294 \BCF4\ACE0\C11C \BCF4\AE30\B85C \C804\D658\D560 \C218 \C788\C2B5\B2C8\B2E4.'),
unistr('\C635\C158\C740 \B2E4\C74C\ACFC \AC19\C2B5\B2C8\B2E4.  '),
'<p>',
'</p><ul>',
unistr('<li><b>\CC28\D2B8 \C720\D615</b>\C740 \D3EC\D568\C2DC\D0AC \CC28\D2B8 \C720\D615\C744 \C2DD\BCC4\D569\B2C8\B2E4. '),
unistr('\AC00\B85C \B9C9\B300, \C138\B85C \B9C9\B300, \D30C\C774 \B610\B294 \C120 \C911\C5D0\C11C \C120\D0DD\D558\C2ED\C2DC\C624.</li>'),
unistr('<li><b>\B808\C774\BE14</b>\C744 \C0AC\C6A9\D558\BA74 \B808\C774\BE14\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('<li><b>\B808\C774\BE14\C5D0 \B300\D55C \CD95 \C81C\BAA9</b>\C740 \B808\C774\BE14\C5D0 \B300\D574 \C120\D0DD\D55C \C5F4\ACFC \C5F0\AD00\B41C \CD95\C5D0 \D45C\C2DC\B420 \C81C\BAA9\C785\B2C8\B2E4. '),
unistr('\D30C\C774 \CC28\D2B8\C5D0 \B300\D574\C11C\B294 \C0AC\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</li>'),
unistr('<li><b>\AC12</b>\C744 \C0AC\C6A9\D558\BA74 \AC12\C73C\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D560 \C218 \C788\C2B5\B2C8\B2E4. \D568\C218\AC00 COUNT\C778 \ACBD\C6B0 \AC12\C744 '),
unistr('\C120\D0DD\D558\C9C0 \C54A\C544\B3C4 \B429\B2C8\B2E4.</li>'),
unistr('<li><b>\AC12\C5D0 \B300\D55C \CD95 \C81C\BAA9</b>\C740 \AC12\C5D0 \B300\D574 \C120\D0DD\B41C \C5F4\ACFC \C5F0\AD00\B41C \CD95\C5D0 \D45C\C2DC\B420 \C81C\BAA9\C785\B2C8\B2E4. \D30C\C774 \CC28\D2B8\C5D0 '),
unistr('\B300\D574\C11C\B294 \C0AC\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</li>'),
unistr('<li><b>\D568\C218</b>\B294 \AC12\C5D0 \B300\D574 \C120\D0DD\B41C \C5F4\C5D0\C11C \C218\D589\D560 \C120\D0DD\C801 \D568\C218\C785\B2C8\B2E4.</li>'),
unistr('<li><b>\C815\B82C</b>\C744 \C0AC\C6A9\D558\BA74 \ACB0\ACFC \C9D1\D569\C744 \C815\B82C\D560 \C218 \C788\C2B5\B2C8\B2E4.</li></ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281111528233870120)
,p_name=>'APEXIR_HELP_COLUMN_HEADING_MENU'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C784\C758\C758 \C5F4 \BA38\B9AC\AE00\C744 \B204\B974\BA74 \C5F4 \BA38\B9AC\AE00 \BA54\B274\AC00 \D45C\C2DC\B429\B2C8\B2E4. \C635\C158\C740 \B2E4\C74C\ACFC \AC19\C2B5\B2C8\B2E4.'),
'<p></p>',
'<ul>',
unistr('<li><b>\C624\B984\CC28\C21C \C815\B82C \C544\C774\CF58</b>\C744 \B204\B974\BA74 \BCF4\ACE0\C11C\AC00 \C5F4\C744 \AE30\C900\C73C\B85C \C624\B984\CC28\C21C\C73C\B85C \C815\B82C\B429\B2C8\B2E4.</li>'),
unistr('<li><b>\B0B4\B9BC\CC28\C21C \C815\B82C \C544\C774\CF58</b>\C744 \B204\B974\BA74 \BCF4\ACE0\C11C\AC00 \C5F4\C744 \AE30\C900\C73C\B85C \B0B4\B9BC\CC28\C21C\C73C\B85C \C815\B82C\B429\B2C8\B2E4.</li>'),
unistr('<li><b>\C5F4 \C228\AE30\AE30</b>\B97C \B204\B974\BA74 \C5F4\C774 \C228\ACA8\C9D1\B2C8\B2E4. \C77C\BD80 \C5F4\C740 \C228\AE38 \C218 \C5C6\C2B5\B2C8\B2E4. \C5F4\C744 \C228\AE38 \C218 \C5C6\B294 \ACBD\C6B0 \C5F4 \C228\AE30\AE30 \C544\C774\CF58\C774 \D45C\C2DC\B418\C9C0 \C54A\C2B5\B2C8\B2E4.</li>'),
unistr('<li><b>\AD6C\BD84 \C5F4</b>\C744 \B204\B974\BA74 \C5F4\C5D0 \AD6C\BD84 \ADF8\B8F9\C774 \C0DD\C131\B429\B2C8\B2E4. \C774\B294 \BCF4\ACE0\C11C\C758 \C5F4\C744 \B9C8\C2A4\D130 \B808\CF54\B4DC\B85C \AC00\C838\C635\B2C8\B2E4.</li>'),
unistr('<li><b>\C5F4 \C815\BCF4</b>\B97C \B204\B974\BA74 \C5F4\C5D0 \B300\D55C \B3C4\C6C0\B9D0 \D14D\C2A4\D2B8(\C0AC\C6A9 \AC00\B2A5\D55C \ACBD\C6B0)\AC00 \D45C\C2DC\B429\B2C8\B2E4.</li>'),
unistr('<li><b>\D14D\C2A4\D2B8 \C601\C5ED</b>\C740 \B300\C18C\BB38\C790 \AD6C\BD84 \C5C6\C774 \AC80\C0C9 \C870\AC74(\C640\C77C\B4DC \CE74\B4DC \BB38\C790 \D544\C694 \C5C6\C74C)\C744 '),
unistr('\C785\B825\D558\B294 \B370 \C0AC\C6A9\B429\B2C8\B2E4. \AC12\C744 \C785\B825\D558\BA74 \BA54\B274 \D558\B2E8\C758 \AC12 \BAA9\B85D\C774 \C904\C5B4\B4ED\B2C8\B2E4. '),
unistr('\ADF8\B7F0 \B2E4\C74C \D558\B2E8\C5D0\C11C \AC12\C744 \C120\D0DD\D560 \C218 \C788\C73C\BA70 \C120\D0DD\D55C \AC12\C740 ''=''\B97C \C0AC\C6A9\D558\B294 '),
unistr('\D544\D130(\C608: <code>column = ''ABC''</code>)\B85C \C0DD\C131\B429\B2C8\B2E4. \B610\B294 \D45C\C2DC\B4F1 \C544\C774\CF58\C744 \B204\B97C \C218 \C788\B294\B370, \C774 \ACBD\C6B0 \C785\B825\D55C \AC12\C740 ''LIKE'' \C218\C815\C790\AC00 \C788\B294 '),
unistr('\D544\D130(\C608: <code>column LIKE ''%ABC%''</code>)\B85C \C0DD\C131\B429\B2C8\B2E4.</li>'),
unistr('<li><b>\ACE0\C720 \AC12 \BAA9\B85D</b>\C5D0\B294 \D544\D130\B97C \CDA9\C871\D558\B294 \CC98\C74C 500\AC1C\C758 \ACE0\C720 \AC12\C774 \D3EC\D568\B429\B2C8\B2E4. '),
unistr('\B0A0\C9DC \C5F4\C778 \ACBD\C6B0\C5D0\B294 \B0A0\C9DC \BC94\C704 \BAA9\B85D\C774 \B300\C2E0 \D45C\C2DC\B429\B2C8\B2E4. \AC12\C744 \C120\D0DD\D558\BA74 ''=''\B97C '),
unistr('\C0AC\C6A9\D558\B294 \D544\D130(\C608: <code>column = ''ABC''</code>)\AC00 \C0DD\C131\B429\B2C8\B2E4.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281112051936870120)
,p_name=>'APEXIR_HELP_COMPUTE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\BCF4\ACE0\C11C\C5D0 \ACC4\C0B0\B41C \C5F4\C744 \CD94\AC00\D560 \C218 \C788\C2B5\B2C8\B2E4. \C774\B7EC\D55C \C5F4\C740 \C0B0\C220 \ACC4\C0B0(\C608: <code>NBR_HOURS/24</code>)\C774\AC70\B098 \AE30\C874 \C5F4\C5D0 \C801\C6A9\B41C \D45C\C900 Oracle \D568\C218\C77C'),
unistr('\C218 \C788\C2B5\B2C8\B2E4. \C77C\BD80\B294 \C608\C81C \BC0F \AE30\D0C0 \D56D\BAA9(\C608: <code>TO_DATE</code>\B97C \C0AC\C6A9\D560 \C218 \C788\C74C)\C73C\B85C \D45C\C2DC\B420 \C218 \C788\C2B5\B2C8\B2E4. \C635\C158\C740 \B2E4\C74C\ACFC \AC19\C2B5\B2C8\B2E4.'),
'<p></p>',
'<ul>',
unistr('<li><b>\ACC4\C0B0</b> - \C774\C804\C5D0 \C815\C758\B41C \ACC4\C0B0\C744 \C120\D0DD\D558\C5EC \D3B8\C9D1\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('<li><b>\C5F4 \C81C\BAA9</b> - \C0C8 \C5F4\C5D0 \B300\D55C \C5F4 \C81C\BAA9\C785\B2C8\B2E4.</li>'),
unistr('<li><b>\D615\C2DD \B9C8\C2A4\D06C</b> - \C5F4\C5D0 \B300\D574 \C801\C6A9\D560 Oracle \D615\C2DD \B9C8\C2A4\D06C\C785\B2C8\B2E4(\C608: S9999).</li>'),
unistr('<li><b>\ACC4\C0B0</b> - \C218\D589\D560 \ACC4\C0B0\C785\B2C8\B2E4. \ACC4\C0B0 \B0B4\C5D0\C11C \C5F4\C740 \D45C\C2DC\B41C \BCC4\CE6D\C744 \C0AC\C6A9\D558\C5EC \CC38\C870\B429\B2C8\B2E4.</li>'),
'</ul>',
unistr('<p>\ACC4\C0B0 \C544\B798\C5D0\C11C \C9C8\C758\C5D0 \C788\B294 \C5F4\C740 \D574\B2F9 \C5F0\AD00\B41C \BCC4\CE6D\ACFC \D568\AED8'),
unistr('\D45C\C2DC\B429\B2C8\B2E4. \C5F4 \C774\B984 \B610\B294 \BCC4\CE6D\C744 \B204\B974\BA74 \D574\B2F9 \D56D\BAA9\C774'),
unistr('\ACC4\C0B0\C5D0 \D3EC\D568\B429\B2C8\B2E4. \C5F4 \C606\C5D0\B294 \D0A4\D328\B4DC\AC00 \C788\C2B5\B2C8\B2E4. \C774 \D0A4\D328\B4DC\B294 \C77C\BC18\C801\C73C\B85C'),
unistr('\C0AC\C6A9\B418\B294 \D0A4\C5D0 \B300\D55C \B2E8\CD95\D0A4 \AE30\B2A5\C744 \C218\D589\D569\B2C8\B2E4. \C624\B978\CABD \B05D\C5D0\B294 \D568\C218\AC00 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C608\C81C \ACC4\C0B0\C5D0\C11C\B294 \CD1D \BCF4\C0C1\C744 \D45C\C2DC\D558\B294 \BC29\BC95\C744 \BCF4\C5EC \C90D\B2C8\B2E4.</p>'),
'<pre>CASE WHEN A = ''SALES'' THEN B + C ELSE B END</pre>',
unistr('(\C5EC\AE30\C11C A\B294 ORGANIZATION, B\B294 SALARY, C\B294 COMMISSION\C785\B2C8\B2E4.)</p>'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281128660964870131)
,p_name=>'APEXIR_HELP_CONTROL_BREAK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D558\B098 \C774\C0C1\C758 \C5F4\C5D0 \AD6C\BD84 \ADF8\B8F9\C744 \C0DD\C131\D558\B294 \B370 \C0AC\C6A9\B429\B2C8\B2E4. \C774\B294 \B300\D654\C2DD \BCF4\ACE0\C11C\C758 \C5F4\C744 \AC00\C838\C640\C11C \B9C8\C2A4\D130 \B808\CF54\B4DC\B85C \D45C\C2DC\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281112702604870120)
,p_name=>'APEXIR_HELP_DETAIL_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D55C \BC88\C5D0 \B2E8\C77C \D589\C758 \C138\BD80\C815\BCF4\B97C \BCF4\B824\BA74 \D655\C778\D558\B824\B294 \D589\C5D0\C11C \B2E8\C77C \D589 \BCF4\AE30 \C544\C774\CF58\C744 \B204\B974\C2ED\C2DC\C624. \C0AC\C6A9 \AC00\B2A5\D55C \ACBD\C6B0 \B2E8\C77C \D589 \BCF4\AE30\B294 \D56D\C0C1 \CCAB\BC88\C9F8 \C5F4\C785\B2C8\B2E4. \B300\D654\C2DD \BCF4\ACE0\C11C\C758 \C0AC\C6A9\C790\C815\C758\C5D0 \B530\B77C \B2E8\C77C \D589 \BCF4\AE30\B294 \D45C\C900 \BCF4\AE30\AC00 \B418\AC70\B098 \C5C5\B370\C774\D2B8\B97C \D5C8\C6A9\D558\B294 \C0AC\C6A9\C790\C815\C758 \D398\C774\C9C0\AC00 \B420 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281112608443870120)
,p_name=>'APEXIR_HELP_DOWNLOAD'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\D604\C7AC \ACB0\ACFC \C9D1\D569\C744 \B2E4\C6B4\B85C\B4DC\D560 \C218 \C788\C2B5\B2C8\B2E4. \B2E4\C6B4\B85C\B4DC \D615\C2DD\C740 \C124\CE58 \BC0F '),
unistr('\BCF4\ACE0\C11C \C815\C758\C5D0 \B530\B77C \B2E4\B974\C9C0\B9CC CSV, HTML, Email, XLS, PDF \B610\B294 RTF '),
unistr('\B4F1\C77C \C218 \C788\C2B5\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281111748701870120)
,p_name=>'APEXIR_HELP_FILTER'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C9C8\C758\C5D0 <code>WHERE</code> \C808\C744 \CD94\AC00\D558\AC70\B098 \C218\C815\D558\C5EC \BCF4\ACE0\C11C\C5D0 \D3EC\CEE4\C2A4\B97C \C124\C815\D569\B2C8\B2E4. \D55C \C5F4\C5D0\C11C \B610\B294 \D589\C744 \AE30\C900\C73C\B85C \D544\D130\B9C1\D560 \C218 \C788\C2B5\B2C8\B2E4.  '),
unistr('<p>\C5F4\C744 \AE30\C900\C73C\B85C \D544\D130\B9C1\D560 \ACBD\C6B0\C5D0\B294 \C5F4(\D45C\C2DC\B41C \C5F4\C77C \D544\C694\B294'),
unistr('\C5C6\C74C)\C744 \C120\D0DD\D558\ACE0, \D45C\C900 Oracle \C5F0\C0B0\C790(=, !=, \B2E4\C74C\C5D0 \C18D\D558\C9C0 \C54A\C74C, \B2E4\C74C \C0AC\C774)\B97C \C120\D0DD\D558\ACE0 \BE44\AD50\D560 \D45C\D604\C2DD\C744 \C785\B825\D558\C2ED\C2DC\C624. \D45C\D604\C2DD\C740 \B300\C18C\BB38\C790\B97C \AD6C\BD84\D569\B2C8\B2E4. %\B97C \C640\C77C\B4DC \CE74\B4DC \BB38\C790\B85C \C0AC\C6A9\D558\C2ED\C2DC\C624(\C608: <code>STATE_NAME'),
'like A%)</code>.</p>',
unistr('<p>\D589\C744 \AE30\C900\C73C\B85C \D544\D130\B9C1\D560 \ACBD\C6B0\C5D0\B294 \C5F4 \BCC4\CE6D \BC0F \C784\C758\C758 Oracle \D568\C218 \B610\B294 \C5F0\C0B0\C790\B97C'),
unistr('\C0AC\C6A9\D558\C5EC \BCF5\C7A1\D55C <code>WHERE</code> \C808\C744 \C0DD\C131\D560 \C218 \C788\C2B5\B2C8\B2E4(\C608: <code>G = ''VA'' or G = ''CT''</code>, \C5EC\AE30\C11C'),
unistr('<code>G</code>\B294 <code>CUSTOMER_STATE</code>\C5D0 \B300\D55C \BCC4\CE6D).</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281112392393870120)
,p_name=>'APEXIR_HELP_FLASHBACK'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\D50C\B798\C2DC\BC31 \C9C8\C758\B97C \C0AC\C6A9\D558\BA74 \C774\C804 \C2DC\C810\C5D0 \C874\C7AC\D55C \ADF8\B300\B85C \B370\C774\D130\B97C \BCFC \C218 \C788\C2B5\B2C8\B2E4. '),
unistr('\D50C\B798\C2DC\BC31\D560 \C218 \C788\B294 \C2DC\AC04\C758 \AE30\BCF8 \C591\C740 3\C2DC\AC04(\B610\B294 180\BD84)\C774\C9C0\B9CC \C2E4\C81C \C591\C740 \AC01 '),
unistr('\B370\C774\D130\BCA0\C774\C2A4\C5D0 \B530\B77C \B2E4\B985\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281611925014870447)
,p_name=>'APEXIR_HELP_FORMAT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\D615\C2DD\C744 \C0AC\C6A9\D558\BA74 \BCF4\ACE0\C11C\C758 \D45C\C2DC\B97C \C0AC\C6A9\C790\AC00 \C0AC\C6A9\C790\AC00 \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4.'),
unistr('\D615\C2DD\C5D0\B294 \B2E4\C74C\ACFC \AC19\C740 \D558\C704 \BA54\B274\AC00 \D3EC\D568\B429\B2C8\B2E4.</p>'),
unistr('<ul><li>\C815\B82C</li>'),
unistr('<li>\C81C\C5B4 \CC28\B2E8</li>'),
unistr('<li>\AC15\C870 \D45C\C2DC</li>'),
unistr('<li>\ACC4\C0B0</li>'),
unistr('<li>\C9D1\ACC4</li>'),
unistr('<li>\CC28\D2B8</li>'),
unistr('<li>\ADF8\B8F9 \AE30\C900</li>'),
unistr('<li>\D53C\BC97</li>'),
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281602665449870442)
,p_name=>'APEXIR_HELP_GROUP_BY'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C800\C7A5\B41C \BCF4\ACE0\C11C\B2F9 \D558\B098\C758 \ADF8\B8F9 \AE30\C900 \BCF4\AE30\B97C \C815\C758\D560 \C218'),
unistr('\C788\C2B5\B2C8\B2E4. \C815\C758\D55C \B2E4\C74C\C5D0\B294 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C\C5D0\C11C \BCF4\AE30 \C544\C774\CF58\C744 \C0AC\C6A9\D558\C5EC'),
unistr('\ADF8\B8F9 \AE30\C900 \B610\B294 \BCF4\ACE0\C11C \BCF4\AE30\B85C \C804\D658\D560 \C218 \C788\C2B5\B2C8\B2E4. \ADF8\B8F9 \AE30\C900 \BCF4\AE30\B97C \C0DD\C131\D558\B824\BA74'),
unistr('\B2E4\C74C\C744 \C120\D0DD\D569\B2C8\B2E4.'),
'<p></p><ul>',
unistr('<li>\ADF8\B8F9\D654\D560 \C5F4</li>'),
unistr('<li>\C218\D589\D560 \D568\C218\C640 \D568\AED8 \C9D1\ACC4\D560 \C5F4(\D3C9\ADE0, \D569\ACC4, \AC1C\C218 \B4F1)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281111936030870120)
,p_name=>'APEXIR_HELP_HIGHLIGHT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\D544\D130\B97C \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4. \D544\D130 \C870\AC74 \D45C\C2DC\B97C \CDA9\C871\D558\B294 \D589\C740 \D544\D130\C640 \C5F0\AD00\B41C \D2B9\C131\C744 \C0AC\C6A9\D558\C5EC \AC15\C870 \D45C\C2DC\B429\B2C8\B2E4. \C635\C158\C740 \B2E4\C74C\ACFC \AC19\C2B5\B2C8\B2E4.</p>'),
'<ul>',
unistr('<li><b>\C774\B984</b>\C740 \D45C\C2DC\C5D0\B9CC \C0AC\C6A9\B429\B2C8\B2E4.</li>'),
unistr('<li><b>\C2DC\D000\C2A4</b>\B294 \ADDC\CE59 \D3C9\AC00 \C21C\C11C\B97C \C2DD\BCC4\D569\B2C8\B2E4.</li>'),
unistr('<li><b>\C0AC\C6A9\C73C\B85C \C124\C815\B428</b>\C740 \ADDC\CE59\C774 \C0AC\C6A9\C73C\B85C \C124\C815\B418\C5C8\B294\C9C0 \B610\B294 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\B418\C5C8\B294\C9C0 \C2DD\BCC4\D569\B2C8\B2E4.</li>'),
unistr('<li><b>\AC15\C870 \D45C\C2DC \C720\D615</b>\C740 \D589 \B610\B294 \C140\C774 \AC15\C870 \D45C\C2DC\B418\B294\C9C0 \C5EC\BD80\B97C '),
unistr('\C2DD\BCC4\D569\B2C8\B2E4. \C140\C774 \C120\D0DD\B41C \ACBD\C6B0 \AC15\C870 \D45C\C2DC \C870\AC74\C5D0\C11C \CC38\C870\B41C '),
unistr('\C5F4\C774 \AC15\C870 \D45C\C2DC\B429\B2C8\B2E4.</li>'),
unistr('<li><b>\BC30\ACBD\C0C9</b>\C740 \AC15\C870 \D45C\C2DC\B41C \C601\C5ED\C758 \C0C8 \BC30\ACBD\C0C9\C785\B2C8\B2E4.</li>'),
unistr('<li><b>\D14D\C2A4\D2B8 \C0C9\C0C1</b>\C740 \AC15\C870 \D45C\C2DC\B41C \C601\C5ED\C758 \C0C8 \D14D\C2A4\D2B8 \C0C9\C0C1\C785\B2C8\B2E4.</li>'),
unistr('<li><b>\AC15\C870 \D45C\C2DC \C870\AC74</b>\C740 \D544\D130 \C870\AC74\C744 \C815\C758\D569\B2C8\B2E4.</li>'),
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280708619708869861)
,p_name=>'APEXIR_HELP_PIVOT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C800\C7A5\B41C \BCF4\ACE0\C11C\B2F9 \D558\B098\C758 \D53C\BC97 \BCF4\AE30\B97C \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4. \C815\C758\B41C \D6C4\C5D0\B294 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C\C5D0 \C788\B294 \BCF4\AE30 \C544\C774\CF58\C744 \C0AC\C6A9\D574\C11C \D53C\BC97 \BCF4\AE30 \B610\B294 \BCF4\ACE0\C11C \BCF4\AE30\B85C \C804\D658\D560 \C218 \C788\C2B5\B2C8\B2E4. \D53C\BC97 \BCF4\AE30\B97C \C0DD\C131\D558\B824\BA74 \B2E4\C74C\C744 \C120\D0DD\D569\B2C8\B2E4. '),
'<p></p>',
'<ul>',
unistr('<li>\D53C\BC97\D560 \C5F4</li>'),
unistr('<li>\D589\C73C\B85C \D45C\C2DC\D560 \C5F4</li>'),
unistr('<li>\C218\D589\D560 \D568\C218\C640 \D568\AED8 \C9D1\ACC4\D560 \C5F4(\D3C9\ADE0, \D569\ACC4, \AC1C\C218 \B4F1)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281153447620870149)
,p_name=>'APEXIR_HELP_REPORT_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\B300\D654\C2DD \BCF4\ACE0\C11C\B97C \C0AC\C6A9\C790\AC00 \C815\C758\D560 \ACBD\C6B0 \BCF4\ACE0\C11C \C124\C815\C774 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C'),
unistr('\C544\B798 \BC0F \BCF4\ACE0\C11C \C704\C5D0 \D45C\C2DC\B429\B2C8\B2E4. \C774 \C601\C5ED\C740 \C67C\CABD\C5D0 \C788\B294 \C544\C774\CF58\C744 \C0AC\C6A9\D558\C5EC \CD95\C18C \BC0F \D655\C7A5\D560 \C218 \C788\C2B5\B2C8\B2E4.'),
'<p>',
unistr('\AC01 \BCF4\ACE0\C11C \C124\C815\C5D0\C11C\B294 \B2E4\C74C\C744 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4.'),
'</p><ul>',
unistr('<li>\C774\B984\C744 \B20C\B7EC \C124\C815\C744 \D3B8\C9D1\D569\B2C8\B2E4.</li>'),
unistr('<li>[\C0AC\C6A9/\C0AC\C6A9 \C548\D568] \CCB4\D06C\BC15\C2A4\B97C \C120\D0DD\D558\AC70\B098 \C120\D0DD\C744 \CDE8\C18C\D558\C5EC \C124\C815\C744 \C0AC\C6A9/\C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\D569\B2C8\B2E4. \C774 \CF58\D2B8\B864\C744 \C0AC\C6A9\D558\C5EC \C124\C815\C744 \C77C\C2DC\C801\C73C\B85C \C124\C815\D558\AC70\B098 \D574\C81C\D569\B2C8\B2E4.</li>'),
unistr('<li>[\C81C\AC70] \C544\C774\CF58\C744 \B20C\B7EC \C124\C815\C744 \C81C\AC70\D569\B2C8\B2E4.</li>'),
'</ul>',
unistr('<p>\CC28\D2B8, \ADF8\B8F9 \AE30\C900 \B610\B294 \D53C\BC97\C744 \C0DD\C131\D55C \ACBD\C6B0 \C624\B978\CABD\C5D0 \D45C\C2DC\B41C [\BCF4\ACE0\C11C \BCF4\AE30],'),
unistr('[\CC28\D2B8 \BCF4\AE30], [\ADF8\B8F9 \AE30\C900 \BCF4\AE30] \BC0F [\D53C\BC97 \BCF4\AE30]\B97C \C0AC\C6A9\D558\C5EC \C774\B7EC\D55C \D56D\BAA9\ACFC \AE30\C900 \BCF4\ACE0\C11C'),
unistr('\C0AC\C774\B97C \D1A0\AE00\D560 \C218 \C788\C2B5\B2C8\B2E4. \CC28\D2B8, \ADF8\B8F9 \AE30\C900 \B610\B294 \D53C\BC97\C774 \D45C\C2DC\B41C \C0C1\D0DC\C5D0\C11C [\D3B8\C9D1]'),
unistr('\B9C1\D06C\B97C \C0AC\C6A9\D558\C5EC \C124\C815\C744 \D3B8\C9D1\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281112567663870120)
,p_name=>'APEXIR_HELP_RESET'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\B97C \AE30\BCF8 \C124\C815\C73C\B85C \B2E4\C2DC \C7AC\C124\C815\D558\C5EC \C0AC\C6A9\C790\AC00 \C815\C758\D55C \C0AC\D56D\C744 \BAA8\B450 \C81C\AC70\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281612241067870447)
,p_name=>'APEXIR_HELP_ROWS_PER_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\BCC4\B85C \D45C\C2DC\D560 \B808\CF54\B4DC \C218\B97C \C124\C815\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281112410711870120)
,p_name=>'APEXIR_HELP_SAVE_REPORT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774\D6C4 \C0AC\C6A9\C744 \C704\D574 \C0AC\C6A9\C790\C815\C758\B41C \BCF4\ACE0\C11C\B97C \C800\C7A5\D569\B2C8\B2E4. \C774\B984 \BC0F \C120\D0DD\C801\C778 \C124\BA85\C744 \C81C\ACF5\D558\ACE0 \BCF4\ACE0\C11C\B97C \C77C\BC18\C5D0 \C561\C138\C2A4\D560 \C218 \C788\B3C4\B85D \C124\C815\D560 \C218 \C788\C2B5\B2C8\B2E4. \C989, \BAA8\B4E0 \C0AC\C6A9\C790\AC00 \AE30\BCF8 \BCF4\ACE0\C11C\C5D0 \C561\C138\C2A4\D560 \C218 \C788\C2B5\B2C8\B2E4. \B2E4\C74C \B124 \AC00\C9C0 \C720\D615\C758 \B300\D654\C2DD \BCF4\ACE0\C11C\B97C \C800\C7A5\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
'<ul>',
unistr('<li><strong>\AE30\BCF8</strong>(\AC1C\BC1C\C790 \C804\C6A9). \AE30\BCF8\C740 \CC98\C74C\C5D0 \D45C\C2DC\B418\B294 \BCF4\ACE0\C11C\C785\B2C8\B2E4. \AE30\BCF8 \BCF4\ACE0\C11C\B294 \C774\B984\C744 \BC14\AFB8\AC70\B098 \C0AD\C81C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</li>'),
unistr('<li><strong>\B300\CCB4 \BCF4\ACE0\C11C</strong>(\AC1C\BC1C\C790 \C804\C6A9). \AC1C\BC1C\C790\AC00 \C5EC\B7EC \BCF4\ACE0\C11C \B808\C774\C544\C6C3\C744 \C0DD\C131\D560 \C218 \C788\C2B5\B2C8\B2E4. \AC1C\BC1C\C790\B9CC \B300\CCB4 \BCF4\ACE0\C11C\B97C \C800\C7A5, \C774\B984 \BC14\AFB8\AE30 \B610\B294 \C0AD\C81C\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('<li><strong>\ACF5\C6A9 \BCF4\ACE0\C11C</strong>(\C77C\BC18 \C0AC\C6A9\C790). \BCF4\ACE0\C11C\B97C \C0DD\C131\D55C \C77C\BC18 \C0AC\C6A9\C790\AC00 \C800\C7A5, \C774\B984 \BC14\AFB8\AE30 \B610\B294 \C0AD\C81C\D560 \C218 \C788\C2B5\B2C8\B2E4. \B2E4\B978 \C0AC\C6A9\C790\B294 \B808\C774\C544\C6C3\C744 \BCF4\ACE0 \B2E4\B978 \BCF4\ACE0\C11C\B85C \C800\C7A5\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('<li><strong>\C804\C6A9 \BCF4\ACE0\C11C</strong>(\C77C\BC18 \C0AC\C6A9\C790). \BCF4\ACE0\C11C\B97C \C0DD\C131\D55C \C77C\BC18 \C0AC\C6A9\C790\B9CC \BCF4\ACE0\C11C\B97C \BCF4\ACE0, \C800\C7A5, \C774\B984 \BC14\AFB8\AE30 \B610\B294 \C0AD\C81C\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
'</ul>',
unistr('<p>\C0AC\C6A9\C790\C815\C758\B41C \BCF4\ACE0\C11C\B97C \C800\C7A5\D55C \ACBD\C6B0 \BCF4\ACE0\C11C \C120\D0DD\AE30\B294 \D589 \C120\D0DD\AE30(\C774 \AE30\B2A5\C774 \C0AC\C6A9\C73C\B85C \C124\C815\B41C \ACBD\C6B0) \D589 \C120\D0DD\AE30\C758 \C67C\CABD\C5D0 \C788\B294 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C\C5D0 \D45C\C2DC\B429\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281111476251870120)
,p_name=>'APEXIR_HELP_SEARCH_BAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC01 \BCF4\ACE0\C11C \D398\C774\C9C0\C758 \C0C1\B2E8\C5D0\B294 \AC80\C0C9 \C601\C5ED\C774 \C788\C2B5\B2C8\B2E4. \C774 \C601\C5ED(\B610\B294 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C)\C5D0\C11C\B294 \B2E4\C74C\ACFC \AC19\C740 \AE30\B2A5\C774 \C81C\ACF5\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281612895828870448)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ACTIONS_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('<li><b>\C791\C5C5 \BA54\B274</b>\B97C \C0AC\C6A9\D558\BA74 \BCF4\ACE0\C11C\B97C \C0AC\C6A9\C790\AC00 \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4. \C774\D6C4 \D45C\C2DC\B418\B294 \C139\C158\C744 \CC38\C870\D558\C2ED\C2DC\C624.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281612362701870447)
,p_name=>'APEXIR_HELP_SEARCH_BAR_FINDER'
,p_message_language=>'ko'
,p_message_text=>unistr('<li><b>\C5F4 \C120\D0DD \C544\C774\CF58</b>\C744 \C0AC\C6A9\D558\BA74 \AC80\C0C9\D560 \C5F4 \B610\B294 \BAA8\B4E0 \C5F4\C744 \C2DD\BCC4\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281612605057870448)
,p_name=>'APEXIR_HELP_SEARCH_BAR_REPORTS'
,p_message_language=>'ko'
,p_message_text=>unistr('<li><b>\BCF4\ACE0\C11C</b>\B294 \B300\CCB4 \AE30\BCF8\AC12 \BC0F \C800\C7A5\B41C \C804\C6A9 \B610\B294 \ACF5\C6A9 \BCF4\ACE0\C11C\B97C \D45C\C2DC\D569\B2C8\B2E4.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281612599658870448)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('<li><b>\D589</b>\C740 \D398\C774\C9C0\B2F9 \D45C\C2DC\D560 \B808\CF54\B4DC \C218\B97C \C124\C815\D569\B2C8\B2E4.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281612473276870447)
,p_name=>'APEXIR_HELP_SEARCH_BAR_TEXTBOX'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li><b>\D14D\C2A4\D2B8 \C601\C5ED</b>\C744 \C0AC\C6A9\D558\BA74 \B300\C18C\BB38\C790\B97C \AD6C\BD84\D558\C9C0 \C54A\B294 \AC80\C0C9 \C870\AC74(\C640\C77C\B4DC \CE74\B4DC \BB38\C790 \C0AC\C6A9)\C744 \C785\B825\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('<li><b>\C2E4\D589 \B2E8\CD94</b> - \AC80\C0C9\C744 \C2E4\D589\D569\B2C8\B2E4. Enter \D0A4\B97C \B204\B974\BA74 \CEE4\C11C\AC00 \AC80\C0C9 \D14C\C2A4\D2B8 \C601\C5ED \C548\C5D0 \C788\C744 \ACBD\C6B0 \AC80\C0C9\C774 \C2E4\D589\B429\B2C8\B2E4.</li>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281612714982870448)
,p_name=>'APEXIR_HELP_SEARCH_BAR_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('<li><b>\BCF4\AE30 \C544\C774\CF58</b>\C740 \C544\C774\CF58, \BCF4\ACE0\C11C, \C138\BD80\C815\BCF4, \CC28\D2B8, \ADF8\B8F9 \AE30\C900 \BC0F \BCF4\ACE0\C11C\C758 \D53C\BC97 \BCF4\AE30(\C815\C758\B41C \ACBD\C6B0)\B85C \C804\D658\B429\B2C8\B2E4.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281955188496870656)
,p_name=>'APEXIR_HELP_SEARCH_BAR_WS_MANAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('<li><b>\AD00\B9AC</b>\C5D0\C11C\B294 \C18D\C131, \C5F4, \D589\C744 \AD00\B9AC\D558\ACE0 \BCF4\ACE0\C11C \B610\B294 \B370\C774\D130 \ADF8\B9AC\B4DC\C5D0 \B300\D55C \B0B4\C5ED\C744 \BCFC \C218 \C788\C2B5\B2C8\B2E4.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281111693897870120)
,p_name=>'APEXIR_HELP_SELECT_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC\B41C \C5F4\C744 \C218\C815\D558\B294 \B370 \C0AC\C6A9\B429\B2C8\B2E4. \C624\B978\CABD\C5D0 \C788\B294 \C5F4\C740 \D45C\C2DC\B429\B2C8\B2E4. \C67C\CABD\C5D0 \C788\B294 \C5F4\C740 \C228\ACA8\C9D1\B2C8\B2E4. \B9E8 \C624\B978\CABD\C5D0 \C788\B294 \D654\C0B4\D45C\B97C \C0AC\C6A9\D558\C5EC \D45C\C2DC\B41C \C5F4\C744 \C7AC\C815\B82C\D560 \C218 \C788\C2B5\B2C8\B2E4. \ACC4\C0B0\B41C \C5F4 \C55E\C5D0\B294 <b>**</b>\AC00 \BD99\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281111880809870120)
,p_name=>'APEXIR_HELP_SORT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C815\B82C\D560 \C5F4\C744 \BCC0\ACBD\D558\B294 \B370 \C0AC\C6A9\B418\BA70, \C624\B984\CC28\C21C \B610\B294 \B0B4\B9BC\CC28\C21C\C73C\B85C'),
unistr('\C815\B82C\D560\C9C0\B97C \ACB0\C815\D569\B2C8\B2E4. \B610\D55C <code>NULL</code>\C758 \CC98\B9AC \BC29\BC95\B3C4'),
unistr('\C9C0\C815\D560 \C218 \C788\C2B5\B2C8\B2E4. \AE30\BCF8 \C124\C815\C740 \D56D\C0C1 <code>NULL</code>\C744 \B9C8\C9C0\B9C9\C73C\B85C \D45C\C2DC\D558\AC70\B098 \BA3C\C800 \D45C\C2DC\D569\B2C8\B2E4. \ACB0\ACFC \C815\B82C\C740 \BCF4\ACE0\C11C\C5D0\C11C \C5F4 \C81C\BAA9 \C624\B978\CABD\C5D0'),
unistr('\D45C\C2DC\B429\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281602264204870441)
,p_name=>'APEXIR_HELP_SUBSCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\C785\C744 \CD94\AC00\D560 \ACBD\C6B0 \C804\C790\BA54\C77C \C8FC\C18C(\B610\B294 \CF64\B9C8\B85C \AD6C\BD84\B41C \C5EC\B7EC \C804\C790\BA54\C77C \C8FC\C18C), \C804\C790\BA54\C77C \C81C\BAA9, \BE48\B3C4 \BC0F \C2DC\C791/\C885\B8CC \B0A0\C9DC\B97C \C81C\ACF5\D558\C2ED\C2DC\C624. \ACB0\ACFC \C804\C790\BA54\C77C\C740 \AC00\C785\C744 \CD94\AC00\D560 \B54C \C81C\ACF5\B41C \BCF4\ACE0\C11C \C124\C815\C744 \C0AC\C6A9\D558\C5EC \D604\C7AC \B370\C774\D130\B97C \D3EC\D568\D558\B294 \B300\D654\C2DD \BCF4\ACE0\C11C\C758 HTML \BC84\C804\C744 \D3EC\D568\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281954697019870655)
,p_name=>'APEXIR_HELP_WS_01'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\B370\C774\D130 \ADF8\B9AC\B4DC\B294 \AE30\BCF8\C801\C73C\B85C \D3B8\C9D1 \AC00\B2A5\D55C \BCF4\ACE0\C11C\B85C \C0AC\C6A9\C790\C815\C758 \C131\B2A5\C774 \B6F0\C5B4\B0A9\B2C8\B2E4. \C0AC\C6A9\C790\B294 \C5F4\C744 \C120\D0DD\D558\ACE0, \D544\D130\B97C \C801\C6A9\D558\ACE0, \AC15\C870 \D45C\C2DC \BC0F \C815\B82C\D558\C5EC \BCF4\ACE0\C11C \B370\C774\D130\C758 \B808\C774\C544\C6C3\C744 \BCC0\ACBD\D560 \C218 \C788\C2B5\B2C8\B2E4. \C0AC\C6A9\C790\B294 \B610\D55C \C911\B2E8\C810, \C9D1\ACC4, \CC28\D2B8, \ADF8\B8F9 \AE30\C900\C744 \C815\C758\D558\ACE0 \ACE0\C720 \ACC4\C0B0\C744 \CD94\AC00\D560 \C218 \C788\C2B5\B2C8\B2E4. \C0AC\C6A9\C790\B294 \BCF4\ACE0\C11C\C758 \C5EC\B7EC \AC00\C9C0 \D615\D0DC\B85C \C0DD\C131\D558\ACE0 \C804\C6A9 \BCF4\AE30\B97C \C704\D574 \C774\B984\C774 \C9C0\C815\B41C \BCF4\ACE0\C11C\B85C \C800\C7A5\D560 \C218 \C788\C2B5\B2C8\B2E4. '),
'<p/>',
unistr('\B370\C774\D130 \ADF8\B9AC\B4DC\B294 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C, \C791\C5C5 \BA54\B274, \AD00\B9AC \BA54\B274 \B610\B294 \C5F4 \C81C\BAA9 \BA54\B274\B97C \C0AC\C6A9\D558\C5EC \C0AC\C6A9\C790\AC00 \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282007076201870687)
,p_name=>'APEXIR_HELP_WS_ACTIONS_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \BA54\B274\B294 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C\C758 [\C2E4\D589] \B2E8\CD94 \C624\B978\CABD\C5D0 \D45C\C2DC\B429\B2C8\B2E4. \C774 \BA54\B274\B97C \C0AC\C6A9\D558\C5EC \B370\C774\D130 \ADF8\B9AC\B4DC \BCF4\ACE0\C11C\B97C \C0AC\C6A9\C790\C815\C758\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281955498279870656)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \D398\C774\C9C0 \CD94\AC00/\D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281955504698870656)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT_ROW'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B370\C774\D130 \ADF8\B9AC\B4DC\C5D0 \D589\C744 \CD94\AC00\D558\B824\BA74 [\D589 \CD94\AC00]\B97C \B204\B974\C2ED\C2DC\C624. \D589\C758 \C138\BD80\C815\BCF4\B97C \D3B8\C9D1\D558\B824\BA74 \D3B8\C9D1\D558\B824\B294 \D589\C5D0\C11C \D589 \D3B8\C9D1 \C544\C774\CF58(\CCAB\BC88\C9F8 \C5F4)\C744 \B204\B974\C2ED\C2DC\C624. \B370\C774\D130 \ADF8\B9AC\B4DC\C758 \C5F4\C774 \D45C\C2DC\B41C [\D589 \CD94\AC00/\D3B8\C9D1] \D398\C774\C9C0\AC00 \D45C\C2DC\B429\B2C8\B2E4. </p>'),
'',
unistr('<p>\D589\C744 \D3B8\C9D1\D560 \B54C\B294 \B2E4\C74C\C744 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
'',
'<p><ul>',
unistr('<li>\D589\C744 <b>\C0AD\C81C</b>\D569\B2C8\B2E4.</li>'),
unistr('<li>\D589\C5D0\C11C \C218\D589\D55C \BCC0\ACBD\C0AC\D56D\C744 \C800\C7A5\D558\B3C4\B85D <b>\BCC0\ACBD\C0AC\D56D\C744 \C801\C6A9</b>\D569\B2C8\B2E4.</li>'),
unistr('<li><b>\C791\C5C5</b> \B0B4\C5D0\C11C \D589 \CD94\AC00, \D30C\C77C, \BA54\BAA8, \B9C1\D06C \B610\B294 \D0DC\ADF8 \CD94\AC00 \BC0F \B0B4\C5ED \AC80\D1A0\B97C \C218\D589\D569\B2C8\B2E4.</li>'),
unistr('<li><b>\B2E4\C74C \BC0F \C774\C804</b> \D589\C73C\B85C \C774\B3D9\D569\B2C8\B2E4.</li>'),
unistr('<li><b>\AD00\B9AC</b> \B0B4\C5D0\C11C \C5F4 \C18D\C131, \C5F4 \ADF8\B8F9, \AC80\C99D \BC0F \AC12 \BAA9\B85D\C744 \C124\C815\D569\B2C8\B2E4.</li>'),
'</ul></p>',
'',
unistr('<p>\D398\C774\C9C0 \C544\B798\C5D0 \C8FC\C11D \C601\C5ED\C5D0\B294 \D604\C7AC \D589\ACFC \C5F0\AD00\B41C \BAA8\B4E0 \D30C\C77C, \BA54\BAA8, \B9C1\D06C \B610\B294 \D0DC\ADF8\AC00 \D45C\C2DC\B429\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282007115210870687)
,p_name=>'APEXIR_HELP_WS_CONTROL_BREAK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D558\B098 \C774\C0C1\C758 \C5F4\C5D0 \AD6C\BD84 \ADF8\B8F9\C744 \C0DD\C131\D558\B294 \B370 \C0AC\C6A9\B429\B2C8\B2E4. \C774\B294 \B370\C774\D130 \ADF8\B9AC\B4DC\C758 \C5F4\C744 \AC00\C838\C640\C11C \B9C8\C2A4\D130 \B808\CF54\B4DC\B85C \D45C\C2DC\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281955300518870656)
,p_name=>'APEXIR_HELP_WS_DOWNLOAD'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\D604\C7AC \ACB0\ACFC \C9D1\D569\C744 \B2E4\C6B4\B85C\B4DC\D560 \C218 \C788\C2B5\B2C8\B2E4. \B2E4\C6B4\B85C\B4DC \D615\C2DD\C5D0\B294'),
unistr('CSV, HTML \B610\B294 \C804\C790\BA54\C77C\C774 \D3EC\D568\B429\B2C8\B2E4.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282007261401870687)
,p_name=>'APEXIR_HELP_WS_REPORT_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\B370\C774\D130 \ADF8\B9AC\B4DC \BCF4\ACE0\C11C\B97C \C0AC\C6A9\C790\AC00 \C815\C758\D560 \ACBD\C6B0 \BCF4\ACE0\C11C \C124\C815\C774 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C'),
unistr('\C544\B798 \BC0F \BCF4\ACE0\C11C \C704\C5D0 \D45C\C2DC\B429\B2C8\B2E4. \C774 \C601\C5ED\C740 \C67C\CABD\C5D0 \C788\B294 \C544\C774\CF58\C744 \C0AC\C6A9\D558\C5EC \CD95\C18C \BC0F \D655\C7A5\D560 \C218 \C788\C2B5\B2C8\B2E4.'),
'<p>',
unistr('\AC01 \BCF4\ACE0\C11C \C124\C815\C5D0\C11C\B294 \B2E4\C74C\C744 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4.'),
'</p><ul>',
unistr('<li>\C774\B984\C744 \B20C\B7EC \C124\C815\C744 \D3B8\C9D1\D569\B2C8\B2E4.</li>'),
unistr('<li>[\C0AC\C6A9/\C0AC\C6A9 \C548\D568] \D655\C778\B780\C744 \C120\D0DD\D558\AC70\B098 \C120\D0DD\C744 \CDE8\C18C\D558\C5EC \C124\C815\C744 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815/\C0AC\C6A9\C73C\B85C \C124\C815\D569\B2C8\B2E4. \C774 \CF58\D2B8\B864\C744 \C0AC\C6A9\D558\C5EC \C124\C815\C744 \C77C\C2DC\C801\C73C\B85C \C124\C815\D558\AC70\B098 \D574\C81C\D569\B2C8\B2E4.</li>'),
unistr('<li>[\C81C\AC70] \C544\C774\CF58\C744 \B20C\B7EC \C124\C815\C744 \C81C\AC70\D569\B2C8\B2E4.</li>'),
'</ul>',
unistr('<p>\CC28\D2B8 \B610\B294 \ADF8\B8F9 \AE30\C900\C744 \C0DD\C131\D55C \ACBD\C6B0 \C624\B978\CABD\C5D0 \D45C\C2DC\B41C [\BCF4\ACE0\C11C \BCF4\AE30],'),
unistr('[\CC28\D2B8 \BCF4\AE30], [\ADF8\B8F9 \AE30\C900 \BCF4\AE30] \B9C1\D06C\B97C \C0AC\C6A9\D558\C5EC \CC28\D2B8 \B610\B294 \ADF8\B8F9 \AE30\C900\ACFC \AE30\C900 \BCF4\ACE0\C11C'),
unistr('\C0AC\C774\B97C \D1A0\AE00\D560 \C218 \C788\C2B5\B2C8\B2E4. \CC28\D2B8 \B610\B294 \ADF8\B8F9 \AE30\C900\C774 \D45C\C2DC\B41C \C0C1\D0DC\C5D0\C11C [\D3B8\C9D1]'),
unistr('\B9C1\D06C\B97C \C0AC\C6A9\D558\C5EC \C124\C815\C744 \D3B8\C9D1\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281955279724870656)
,p_name=>'APEXIR_HELP_WS_SAVE_REPORT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774\D6C4 \C0AC\C6A9\C744 \C704\D574 \C0AC\C6A9\C790\C815\C758\B41C \B370\C774\D130 \ADF8\B9AC\B4DC \BCF4\ACE0\C11C\B97C \C800\C7A5\D569\B2C8\B2E4. \C774\B984 \BC0F \C120\D0DD\C801 \C124\BA85\C744 \C81C\ACF5\D569\B2C8\B2E4. \B2E4\C74C \C138 \AC00\C9C0 \C720\D615\C758 \B370\C774\D130 \ADF8\B9AC\B4DC \BCF4\ACE0\C11C \B808\C774\C544\C6C3\C744 \C800\C7A5\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
'<ul>',
unistr('<li><strong>\AE30\BCF8</strong>(\AD00\B9AC\C790 \C804\C6A9). \AE30\BCF8\C740 \CC98\C74C\C5D0 \D45C\C2DC\B418\B294 \B808\C774\C544\C6C3\C785\B2C8\B2E4. \AE30\BCF8 \BCF4\ACE0\C11C\B294 \C774\B984\C744 \BC14\AFB8\AC70\B098 \C0AD\C81C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</li>'),
unistr('<li><strong>\B300\CCB4 \BCF4\ACE0\C11C</strong>(\AD00\B9AC\C790 \C804\C6A9). \AD00\B9AC\C790\AC00 \C5EC\B7EC \BCF4\ACE0\C11C \B808\C774\C544\C6C3\C744 \C0DD\C131\D560 \C218 \C788\C2B5\B2C8\B2E4. \AD00\B9AC\C790\B9CC \B300\CCB4 \BCF4\ACE0\C11C\B97C \C800\C7A5, \C774\B984 \BC14\AFB8\AE30 \B610\B294 \C0AD\C81C\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('<li><strong>\C804\C6A9 \BCF4\ACE0\C11C</strong>(\BAA8\B4E0 \C0AC\C6A9\C790). \BCF4\ACE0\C11C\B97C \C0DD\C131\D55C \C0AC\C6A9\C790\AC00 \BCF4\ACE0\C11C\B97C \BCF4\ACE0, \C800\C7A5, \C774\B984 \BC14\AFB8\AE30 \B610\B294 \C0AD\C81C\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
'</ul>',
unistr('<p>\C0AC\C6A9\C790\C815\C758\B41C \BCF4\ACE0\C11C\B97C \C800\C7A5\D55C \ACBD\C6B0 \BCF4\ACE0\C11C \C120\D0DD\AE30\B294 \D589 \C120\D0DD\AE30(\C774 \AE30\B2A5\C774 \C0AC\C6A9\C73C\B85C \C124\C815\B41C \ACBD\C6B0) \D589 \C120\D0DD\AE30\C758 \C67C\CABD\C5D0 \C788\B294 \AC80\C0C9 \B3C4\AD6C \BAA8\C74C\C5D0 \D45C\C2DC\B429\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281123717800870128)
,p_name=>'APEXIR_HIDE_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \C228\AE30\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281036001154870067)
,p_name=>'APEXIR_HIGHLIGHT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281127989722870131)
,p_name=>'APEXIR_HIGHLIGHTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281153563925870149)
,p_name=>'APEXIR_HIGHLIGHT_CONDITION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC \C870\AC74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281603108045870442)
,p_name=>'APEXIR_HIGHLIGHT_STYLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC \C2A4\D0C0\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280876837382869962)
,p_name=>'APEXIR_HIGHLIGHT_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280877502653869963)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC \C2DC\C810')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281963747401870661)
,p_name=>'APEXIR_HORIZONTAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\D3C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282067205350870724)
,p_name=>'APEXIR_INACTIVE_SETTING'
,p_message_language=>'ko'
,p_message_text=>unistr('1\AC1C \BE44\D65C\C131 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282067335725870724)
,p_name=>'APEXIR_INACTIVE_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\AC1C \BE44\D65C\C131 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281113152045870121)
,p_name=>'APEXIR_INTERACTIVE_REPORT_HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \BCF4\ACE0\C11C \B3C4\C6C0\B9D0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281154877512870149)
,p_name=>'APEXIR_INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281126444761870130)
,p_name=>'APEXIR_INVALID_COMPUTATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C0B0 \D45C\D604\C2DD\C774 \BD80\C801\D569\D569\B2C8\B2E4. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280823952640869931)
,p_name=>'APEXIR_INVALID_END_DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\B8CC \B0A0\C9DC\B294 \C2DC\C791 \B0A0\C9DC \C774\D6C4\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281273274607870225)
,p_name=>'APEXIR_INVALID_FILTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \D544\D130 \D45C\D604\C2DD\C785\B2C8\B2E4. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281999844581870683)
,p_name=>'APEXIR_INVALID_FILTER_QUERY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \D544\D130 \C9C8\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282067440504870724)
,p_name=>'APEXIR_INVALID_SETTING'
,p_message_language=>'ko'
,p_message_text=>unistr('1\AC1C \BD80\C801\D569\D55C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282067559781870724)
,p_name=>'APEXIR_INVALID_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\AC1C \BD80\C801\D569\D55C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281603546803870442)
,p_name=>'APEXIR_IN_MINUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('(\BD84)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281946658647870650)
,p_name=>'APEXIR_IS_IN_THE_LAST'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B9C8\C9C0\B9C9 %1 \C774\B0B4\C5D0 \C788\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281946963337870651)
,p_name=>'APEXIR_IS_IN_THE_NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1 \C774\B0B4\C5D0 \C788\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281946866724870651)
,p_name=>'APEXIR_IS_NOT_IN_THE_LAST'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B9C8\C9C0\B9C9 %1 \C774\B0B4\C5D0 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281947040704870651)
,p_name=>'APEXIR_IS_NOT_IN_THE_NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C774(\AC00) \B2E4\C74C %1 \C774\B0B4\C5D0 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281152699107870148)
,p_name=>'APEXIR_KEYPAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0A4\D328\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280907895471869981)
,p_name=>'APEXIR_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \B808\C774\BE14')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281121361229870126)
,p_name=>'APEXIR_LABEL_AXIS_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14\C5D0 \B300\D55C \CD95 \C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281468632247870359)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14 \C811\B450\C5B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281040214500870070)
,p_name=>'APEXIR_LAST_DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C \C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281040445613870070)
,p_name=>'APEXIR_LAST_HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C \C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281039938819870070)
,p_name=>'APEXIR_LAST_MONTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C \C6D4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281040058317870070)
,p_name=>'APEXIR_LAST_WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C \C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281040198310870070)
,p_name=>'APEXIR_LAST_X_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C %0\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281040396588870070)
,p_name=>'APEXIR_LAST_X_HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C %0\C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281039779108870070)
,p_name=>'APEXIR_LAST_X_YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C %0\B144')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281039821993870070)
,p_name=>'APEXIR_LAST_YEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\B09C \C5F0\B3C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280907617526869981)
,p_name=>'APEXIR_LINE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280879934546869964)
,p_name=>'APEXIR_LINE_WITH_AREA'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\ACFC \C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281586826244870432)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\C785\C744 \AD00\B9AC\D558\B824\BA74 <a href=''%0''>\C5EC\AE30</a>\B97C \B204\B974\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281999785479870683)
,p_name=>'APEXIR_MAP_IT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9E4\D551')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281124311202870128)
,p_name=>'APEXIR_MAX_QUERY_COST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C8\C758\AC00 \D5C8\C6A9\B41C \CD5C\B300 \B9AC\C18C\C2A4\B97C \CD08\ACFC\D560 \AC83\C73C\B85C \C608\C0C1\B429\B2C8\B2E4. \BCF4\ACE0\C11C \C124\C815\C744 \C218\C815\D558\ACE0 \B2E4\C2DC \C2DC\B3C4\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280992516150870037)
,p_name=>'APEXIR_MAX_ROW_CNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BCF4\ACE0\C11C\C758 \CD5C\B300 \D589 \C218\B294 %0\AC1C \D589\C785\B2C8\B2E4. \C9C8\C758 \B808\CF54\B4DC \C218\B97C \C904\C774\B824\BA74 \D544\D130\B97C \C801\C6A9\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282000365127870683)
,p_name=>'APEXIR_MAX_X'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300\AC12 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282000576931870683)
,p_name=>'APEXIR_MEDIAN_X'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\AC04\AC12 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281006236724870047)
,p_name=>'APEXIR_MIN_AGO'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\BD84 \C804')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282000433807870683)
,p_name=>'APEXIR_MIN_X'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C18C\AC12 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281999350492870683)
,p_name=>'APEXIR_MONTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6D4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281603963227870442)
,p_name=>'APEXIR_MONTHLY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6D4\BCC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281155096708870150)
,p_name=>'APEXIR_MORE_DATA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281120271009870126)
,p_name=>'APEXIR_MOVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281120119379870125)
,p_name=>'APEXIR_MOVE_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \C774\B3D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282085676594870735)
,p_name=>'APEXIR_MULTIIR_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\C5D0 \C5EC\B7EC \B300\D654\C2DD \BCF4\ACE0\C11C\AC00 \C788\C73C\BBC0\B85C \C601\C5ED \C815\C801 ID\B97C \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280878676168869964)
,p_name=>'APEXIR_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281109576120870118)
,p_name=>'APEXIR_NEW_AGGREGATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \C9D1\ACC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280901846848869977)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_language=>'ko'
,p_message_text=>unistr('- \C0C8 \BC94\C8FC -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282068903325870725)
,p_name=>'APEXIR_NEW_CATEGORY_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \BC94\C8FC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281109657135870118)
,p_name=>'APEXIR_NEW_COMPUTATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \ACC4\C0B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281034331120870066)
,p_name=>'APEXIR_NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281040873613870071)
,p_name=>'APEXIR_NEXT_DAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281040638987870070)
,p_name=>'APEXIR_NEXT_HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281041155373870071)
,p_name=>'APEXIR_NEXT_MONTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C6D4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281041005437870071)
,p_name=>'APEXIR_NEXT_WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281040926118870071)
,p_name=>'APEXIR_NEXT_X_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281040792252870070)
,p_name=>'APEXIR_NEXT_X_HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281041325934870071)
,p_name=>'APEXIR_NEXT_X_YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C %0\B144')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281041200274870071)
,p_name=>'APEXIR_NEXT_YEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C5F0\B3C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280878980519869964)
,p_name=>'APEXIR_NO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B2C8\C624')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281155234226870150)
,p_name=>'APEXIR_NONE'
,p_message_language=>'ko'
,p_message_text=>unistr('- \C5C6\C74C -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281602969278870442)
,p_name=>'APEXIR_NOT_VALID_EMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\D569\D55C \C804\C790\BA54\C77C \C8FC\C18C\AC00 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281037199752870068)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\C758\B41C \C9D1\ACC4\AC00 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280991335530870036)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\D560 \C218 \C788\B294 \C5F4 \C815\BCF4\AC00 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281037280005870068)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\C758\B41C \ACC4\C0B0\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281999192603870682)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('- \C885\B8CC \B0A0\C9DC \C5C6\C74C -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281150382826870146)
,p_name=>'APEXIR_NULLS_ALWAYS_FIRST'
,p_message_language=>'ko'
,p_message_text=>unistr('\B110\C774 \D56D\C0C1 \CC98\C74C\C5D0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281150233452870146)
,p_name=>'APEXIR_NULLS_ALWAYS_LAST'
,p_message_language=>'ko'
,p_message_text=>unistr('\B110\C774 \D56D\C0C1 \B9C8\C9C0\B9C9\C5D0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281151205313870147)
,p_name=>'APEXIR_NULL_SORTING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B110 \C815\B82C: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281126555014870130)
,p_name=>'APEXIR_NUMERIC_FLASHBACK_TIME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\C2DC\BC31 \C2DC\AC04\C740 \C22B\C790\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281126013102870130)
,p_name=>'APEXIR_NUMERIC_SEQUENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\D000\C2A4\B294 \C22B\C790\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281151989806870147)
,p_name=>'APEXIR_OPERATOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F0\C0B0\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280877354627869963)
,p_name=>'APEXIR_ORANGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC\D669\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281963620800870661)
,p_name=>'APEXIR_ORIENTATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC29\D5A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280879469825869964)
,p_name=>'APEXIR_OTHER'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\D0C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282000875889870683)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_COUNT_X'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \B300\D55C \CD1D \AC1C\C218 \BE44\C728(%)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282000044534870683)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_SUM_X'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \B300\D55C \CD1D\ACC4 \BE44\C728(%)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281998532853870682)
,p_name=>'APEXIR_PERCENT_TOTAL_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD1D \AC1C\C218 \BE44\C728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281998488679870682)
,p_name=>'APEXIR_PERCENT_TOTAL_SUM'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD1D\ACC4 \BE44\C728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280907527871869981)
,p_name=>'APEXIR_PIE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C774')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281442355235870342)
,p_name=>'APEXIR_PIVOT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281469948675870359)
,p_name=>'APEXIR_PIVOT_AGG_NOT_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9D1\ACC4\B97C \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281470226851870360)
,p_name=>'APEXIR_PIVOT_AGG_NOT_ON_ROW_COL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C5F4\B85C \C120\D0DD\B41C \C5F4\C5D0\C11C\B294 \C9D1\ACC4\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281467776622870358)
,p_name=>'APEXIR_PIVOT_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281467585327870358)
,p_name=>'APEXIR_PIVOT_COLUMN_N'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97 \C5F4 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281469746121870359)
,p_name=>'APEXIR_PIVOT_COLUMN_NOT_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97 \C5F4\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280708520916869861)
,p_name=>'APEXIR_PIVOT_MAX_ROW_CNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97 \C9C8\C758\C5D0 \B300\D55C \CD5C\B300 \D589 \C218\B294 \D45C\C2DC\B418\B294 \D589 \C218\AC00 \C544\B2CC \AE30\BCF8 \C9C8\C758\C758 \D589 \C218\B97C \C81C\D55C\D569\B2C8\B2E4. \AE30\BCF8 \C9C8\C758\AC00 \CD5C\B300 \D589 \C218 %0\AC1C\B97C \CD08\ACFC\D569\B2C8\B2E4. \AE30\BCF8 \C9C8\C758\C758 \B808\CF54\B4DC \C218\B97C \C904\C774\B824\BA74 \D544\D130\B97C \C801\C6A9\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282081533769870733)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\B978 \D589 \C5F4\C744 \C120\D0DD\D558\C2ED\C2DC\C624. \D589 \C5F4\C758 HTML \D45C\D604\C2DD \B610\B294 \B9C1\D06C\C5D0 \D53C\BC97 \B610\B294 \C9D1\ACC4 \C5F4\B85C \C815\C758\B41C \C5F4\C774 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281468791995870359)
,p_name=>'APEXIR_PIVOT_SORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97 \C815\B82C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281603022771870442)
,p_name=>'APEXIR_PREVIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\BBF8\B9AC\BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281034404108870066)
,p_name=>'APEXIR_PREVIOUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281997407450870681)
,p_name=>'APEXIR_PRIMARY'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281606727304870444)
,p_name=>'APEXIR_PRIMARY_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281267298736870222)
,p_name=>'APEXIR_PRIVATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280908979511869982)
,p_name=>'APEXIR_PUBLIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACF5\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280879222788869964)
,p_name=>'APEXIR_RED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE68\AC04\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282085573828870735)
,p_name=>'APEXIR_REGION_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED \C815\C801 ID %0\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281120324732870126)
,p_name=>'APEXIR_REMOVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281033491984870066)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9D1\ACC4 \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281120430296870126)
,p_name=>'APEXIR_REMOVE_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282067634510870724)
,p_name=>'APEXIR_REMOVE_CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281119705498870125)
,p_name=>'APEXIR_REMOVE_CONTROL_BREAK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C5B4 \CC28\B2E8 \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281119434273870125)
,p_name=>'APEXIR_REMOVE_FILTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281119589596870125)
,p_name=>'APEXIR_REMOVE_FLASHBACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\C2DC\BC31 \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282067728913870724)
,p_name=>'APEXIR_REMOVE_GROUP_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900 \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281119806948870125)
,p_name=>'APEXIR_REMOVE_HIGHLIGHT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282067831385870724)
,p_name=>'APEXIR_REMOVE_PIVOT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97 \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282009030324870688)
,p_name=>'APEXIR_REMOVE_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281887902660870615)
,p_name=>'APEXIR_RENAME_DEFAULT_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \BCF4\ACE0\C11C \C774\B984 \BC14\AFB8\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281155690147870150)
,p_name=>'APEXIR_RENAME_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C774\B984 \BC14\AFB8\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281034977817870067)
,p_name=>'APEXIR_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282000905311870684)
,p_name=>'APEXIR_REPORTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280868480674869957)
,p_name=>'APEXIR_REPORT_ALIAS_DOES_NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \BCC4\CE6D\ACFC \D568\AED8 \C800\C7A5\B41C \B300\D654\C2DD \BCF4\ACE0\C11C\AC00 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281417830771870324)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\C758 \D45C\C2DC \C5F4 \C218\AC00 \D55C\B3C4\C5D0 \B3C4\B2EC\D588\C2B5\B2C8\B2E4. [\C791\C5C5] \BA54\B274 \C544\B798\C5D0\C11C [\C5F4 \C120\D0DD]\C744 \B20C\B7EC \BCF4\ACE0\C11C \D45C\C2DC \C5F4 \BAA9\B85D\C744 \CD5C\C18C\D654\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281270562324870224)
,p_name=>'APEXIR_REPORT_DOES_NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\AC00 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280868511429869957)
,p_name=>'APEXIR_REPORT_ID_DOES_NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5\B41C \B300\D654\C2DD \BCF4\ACE0\C11C ID %0\C774(\AC00) \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281153353809870148)
,p_name=>'APEXIR_REPORT_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281006703584870047)
,p_name=>'APEXIR_REPORT_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281036573930870068)
,p_name=>'APEXIR_RESET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C7AC\C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280909143164869982)
,p_name=>'APEXIR_RESET_CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\B97C \AE30\BCF8 \C124\C815\C73C\B85C \BCF5\C6D0\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280879017063869964)
,p_name=>'APEXIR_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281993206830870679)
,p_name=>'APEXIR_ROWID_NOT_SUPPORTED_FOR_WEBSOURCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C18C\C2A4\C5D0 \B300\D55C \AE30\BCF8 \D0A4 \C5F4\B85C ROWID\B97C \C0AC\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281118404471870124)
,p_name=>'APEXIR_ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281612193607870447)
,p_name=>'APEXIR_ROWS_PER_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\B2F9 \D589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281467895268870358)
,p_name=>'APEXIR_ROW_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281467621735870358)
,p_name=>'APEXIR_ROW_COLUMN_N'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C5F4%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281469873657870359)
,p_name=>'APEXIR_ROW_COLUMN_NOT_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C5F4\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281470057221870360)
,p_name=>'APEXIR_ROW_COL_DIFF_FROM_PIVOT_COL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C5F4\C740 \D53C\BC97 \C5F4\ACFC \B2EC\B77C\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281215187434870188)
,p_name=>'APEXIR_ROW_FILTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \D544\D130')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281006891165870047)
,p_name=>'APEXIR_ROW_OF'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 %0/%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281006027243870046)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C21C\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281038079167870069)
,p_name=>'APEXIR_ROW_TEXT_CONTAINS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \D14D\C2A4\D2B8\AC00 \B2E4\C74C\C744 \D3EC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280728457615869873)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\C758 \D45C\C2DC \C5F4 \C218\AC00 \D55C\B3C4\C5D0 \B3C4\B2EC\D588\C2B5\B2C8\B2E4. [\C791\C5C5] \BA54\B274 \C544\B798\C5D0\C11C [\C5F4 \C120\D0DD]\C744 \B20C\B7EC \BCF4\ACE0\C11C \D45C\C2DC \C5F4 \BAA9\B85D\C744 \CD5C\C18C\D654\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280878203669869963)
,p_name=>'APEXIR_SAVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281128131903870131)
,p_name=>'APEXIR_SAVED_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5\B41C \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281128086750870131)
,p_name=>'APEXIR_SAVED_REPORT_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C800\C7A5\B41C \BCF4\ACE0\C11C = "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281036935607870068)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12\C73C\B85C \C800\C7A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281149580035870146)
,p_name=>'APEXIR_SAVE_DEFAULT_CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \BCF4\ACE0\C11C \C124\C815\C774 \BAA8\B4E0 \C0AC\C6A9\C790\C5D0 \B300\D55C \AE30\BCF8\AC12\C73C\B85C \C0AC\C6A9\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281887819555870615)
,p_name=>'APEXIR_SAVE_DEFAULT_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \BCF4\ACE0\C11C \C800\C7A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281036470015870068)
,p_name=>'APEXIR_SAVE_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C800\C7A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282068839489870725)
,p_name=>'APEXIR_SAVE_REPORT_DEFAULT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C800\C7A5 *')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281623756625870454)
,p_name=>'APEXIR_SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281113099074870121)
,p_name=>'APEXIR_SEARCH_BAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9 \B3C4\AD6C \BAA8\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282068735659870725)
,p_name=>'APEXIR_SEARCH_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281673087495870484)
,p_name=>'APEXIR_SEARCH_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9 \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281584682621870431)
,p_name=>'APEXIR_SELECTED_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\D55C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280878543537869964)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_language=>'ko'
,p_message_text=>unistr('- \BC94\C8FC \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280880166291869965)
,p_name=>'APEXIR_SELECT_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('- \C5F4 \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281035741090870067)
,p_name=>'APEXIR_SELECT_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \C120\D0DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281155446906870150)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C0B0\B41C \C5F4 \C55E\C5D0\B294 **\AC00 \BD99\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280908397007869981)
,p_name=>'APEXIR_SELECT_FUNCTION'
,p_message_language=>'ko'
,p_message_text=>unistr('- \D568\C218 \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281117899221870124)
,p_name=>'APEXIR_SELECT_GROUP_BY_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('- \ADF8\B8F9 \AE30\C900 \C5F4 \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281467352776870358)
,p_name=>'APEXIR_SELECT_PIVOT_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('- \D53C\BC97 \C5F4 \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281999972803870683)
,p_name=>'APEXIR_SELECT_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C120\D0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281467485032870358)
,p_name=>'APEXIR_SELECT_ROW_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('- \D53C\BC97 \D589 \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281998754331870682)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('- \C815\B82C \C5F4 \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281154982942870150)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12 \C120\D0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280718281668869867)
,p_name=>'APEXIR_SEND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C1A1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280878768916869964)
,p_name=>'APEXIR_SEQUENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\D000\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281035935040870067)
,p_name=>'APEXIR_SORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281123510152870128)
,p_name=>'APEXIR_SORT_ASCENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B984\CC28\C21C \C815\B82C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281998610591870682)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C \C5F4 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281123677539870128)
,p_name=>'APEXIR_SORT_DESCENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4\B9BC\CC28\C21C \C815\B82C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282008255966870688)
,p_name=>'APEXIR_SORT_ORDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C \C21C\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281109131792870118)
,p_name=>'APEXIR_SPACE_AS_IN_ONE_EMPTY_STRING'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACF5\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281152232869870148)
,p_name=>'APEXIR_STATUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\D0DC: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281603607157870442)
,p_name=>'APEXIR_SUBSCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\C785')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281999066393870682)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\B8CC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281584501140870430)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\B8CC \B2E8\C704')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281998947550870682)
,p_name=>'APEXIR_SUBSCRIPTION_STARTING_FROM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C791:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282000134432870683)
,p_name=>'APEXIR_SUM_X'
,p_message_language=>'ko'
,p_message_text=>unistr('\D569\ACC4 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281949477707870652)
,p_name=>'APEXIR_TABLE_SUMMARY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED = %0, \BCF4\ACE0\C11C = %1, \BCF4\AE30 = %2, \D45C\C2DC\B41C \D589 \C2DC\C791 = %3, \D45C\C2DC\B41C \D589 \C885\B8CC = %4, \CD1D \D589 \C218 = %5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281059586858870083)
,p_name=>'APEXIR_TABLE_SUMMARY_NO_TOTAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED = %0, \BCF4\ACE0\C11C = %1, \BDF0 = %2, \D45C\C2DC\B41C \D589 \C2DC\C791 = %3, \D45C\C2DC\B41C \D589 \C885\B8CC = %4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280877445661869963)
,p_name=>'APEXIR_TEXT_COLOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14D\C2A4\D2B8 \C0C9\C0C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280993112241870037)
,p_name=>'APEXIR_TIME_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280993050223870037)
,p_name=>'APEXIR_TIME_HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280992974326870037)
,p_name=>'APEXIR_TIME_MINS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280993304493870038)
,p_name=>'APEXIR_TIME_MONTHS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6D4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280993217827870037)
,p_name=>'APEXIR_TIME_WEEKS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280993436187870038)
,p_name=>'APEXIR_TIME_YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B144')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282008877403870688)
,p_name=>'APEXIR_TOGGLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1A0\AE00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281120599095870126)
,p_name=>'APEXIR_TOP'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C0C1\C704')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281153760003870149)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281982636957870672)
,p_name=>'APEXIR_UNGROUPED_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9\D654\B418\C9C0 \C54A\C740 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281126224798870130)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \BA38\B9AC\AE00\C740 \ACE0\C720\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281125951310870130)
,p_name=>'APEXIR_UNIQUE_HIGHLIGHT_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC15\C870 \D45C\C2DC \C774\B984\C740 \ACE0\C720\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280906614320869980)
,p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C6D0\B418\C9C0 \C54A\B294 \B370\C774\D130 \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281120620124870126)
,p_name=>'APEXIR_UP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\B3D9 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281126175028870130)
,p_name=>'APEXIR_VALID_COLOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\D569\D55C \C0C9\C0C1\C744 \C785\B825\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281126359691870130)
,p_name=>'APEXIR_VALID_FORMAT_MASK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\D569\D55C \D615\C2DD \B9C8\C2A4\D06C\B97C \C785\B825\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280879515374869964)
,p_name=>'APEXIR_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281121457881870126)
,p_name=>'APEXIR_VALUE_AXIS_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12\C5D0 \B300\D55C \CD95 \C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281154729742870149)
,p_name=>'APEXIR_VALUE_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\C218 \AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280907444232869981)
,p_name=>'APEXIR_VCOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\C9C1 \B9C9\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281963884846870661)
,p_name=>'APEXIR_VERTICAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\C9C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281153923316870149)
,p_name=>'APEXIR_VIEW_CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281652852908870472)
,p_name=>'APEXIR_VIEW_DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\BD80\C815\BCF4 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282071903178870727)
,p_name=>'APEXIR_VIEW_DOES_NOT_EXIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\C5D0 %0 \BCF4\AE30\AC00 \C815\C758\B418\C5B4 \C788\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281652917766870472)
,p_name=>'APEXIR_VIEW_GROUP_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADF8\B8F9 \AE30\C900 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281652721361870472)
,p_name=>'APEXIR_VIEW_ICONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\C774\CF58 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281467179141870358)
,p_name=>'APEXIR_VIEW_PIVOT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\BC97 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281154049099870149)
,p_name=>'APEXIR_VIEW_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281999562112870683)
,p_name=>'APEXIR_WEEK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281603836625870442)
,p_name=>'APEXIR_WEEKLY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC\BCC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281034899174870066)
,p_name=>'APEXIR_WORKING_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282001708714870684)
,p_name=>'APEXIR_X_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282001677190870684)
,p_name=>'APEXIR_X_HOURS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282001509059870684)
,p_name=>'APEXIR_X_MINS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\BD84')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282001953959870684)
,p_name=>'APEXIR_X_MONTHS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\AC1C\C6D4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282001835550870684)
,p_name=>'APEXIR_X_WEEKS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C8FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282002097315870684)
,p_name=>'APEXIR_X_YEARS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\B144')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281999439017870683)
,p_name=>'APEXIR_YEAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B144')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280877136869869963)
,p_name=>'APEXIR_YELLOW'
,p_message_language=>'ko'
,p_message_text=>unistr('\B178\B780\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280878874300869964)
,p_name=>'APEXIR_YES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280725533056869872)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_language=>'ko'
,p_message_text=>unistr('Application Express \AD00\B9AC \C11C\BE44\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281948021979870651)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D574 \AD6C\C131\B41C \C778\C99D\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281121282879870126)
,p_name=>'APEX_GROUP.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \BD80\C801\D569\D55C \BB38\C790\C778 < \B610\B294 >\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281338407663870267)
,p_name=>'APEX_REGION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281195135863870176)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\AC00 \C120\D0DD\B41C \C2A4\D0A4\B9C8\C5D0 %0\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281195279287870176)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\AC00 \C131\ACF5\C801\C73C\B85C %0\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281683175362870490)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B798\B85C \C774\B3D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281683221079870490)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9E8 \C704\B85C \C774\B3D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280731155179869875)
,p_name=>'APEX_WIZARD_FORM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0D0\C0C9 \D3FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281947553720870651)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281366033827870287)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \AC1D\CCB4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282005905691870687)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\C5B4 \D398\C774\C9C0\AC00 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281950830302870653)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131\D560 \AC1D\CCB4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281951059721870653)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14\C5D0\C11C \C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281951285178870653)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1D\CCB4 \C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281613906957870448)
,p_name=>'APEX_WS_SETUP_DROP_TABLES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281613269861870448)
,p_name=>'APEX_WS_SETUP_MSG1'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \AC1D\CCB4\B294 <b>%0</b> \C2A4\D0A4\B9C8\C5D0 \C0DD\C131\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281951369418870653)
,p_name=>'APEX_WS_SETUP_MSG10'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B7EC\D55C \AC1D\CCB4\B294 <b>%0</b> \C2A4\D0A4\B9C8 \B0B4\C5D0 \C874\C7AC\D558\BA70 \B2E4\B978 \C791\C5C5\C601\C5ED\C5D0\C11C \C0AC\C6A9\B429\B2C8\B2E4. \ACC4\C18D\D558\BA74 <b>%0</b>\C5D0\C11C \C18C\C720\D558\ACE0 \C788\B294 \AE30\C874 \C6F9 \C2DC\D2B8 \AC1D\CCB4\AC00 \C774 \C791\C5C5\C601\C5ED\ACFC\B3C4 \C5F0\AD00\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281951451061870653)
,p_name=>'APEX_WS_SETUP_MSG11'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \AC1D\CCB4\C5D0 \C0AC\C6A9\D560 \C2A4\D0A4\B9C8\B97C \C120\D0DD\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281951577971870653)
,p_name=>'APEX_WS_SETUP_MSG12'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\D560 \AE30\C874 \D14C\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281952494998870654)
,p_name=>'APEX_WS_SETUP_MSG13'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C815\BCF4\B97C \C0AC\C6A9\D558\C5EC Websheet \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\AC00 \C7AC\C0AC\C6A9\B429\B2C8\B2E4. \C694\CCAD \B0B4\C6A9\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281613345652870448)
,p_name=>'APEX_WS_SETUP_MSG2'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \C2A4\D0A4\B9C8\C5D0\C11C \C6F9 \C2DC\D2B8 \AC1D\CCB4\B97C \C0DD\C131\D558\B824\B294 \ACBD\C6B0\C5D0\B294 <a href=%0>\B370\C774\D130\BCA0\C774\C2A4 \C2A4\D0A4\B9C8 \C694\CCAD</a> \B9C8\BC95\C0AC\B97C \C0AC\C6A9\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281613420258870448)
,p_name=>'APEX_WS_SETUP_MSG3'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C2DC\D2B8\B97C \C2E4\D589\D558\B824\BA74 \B2E4\C74C \AC1D\CCB4\AC00 \D544\C694\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281613508905870448)
,p_name=>'APEX_WS_SETUP_MSG5'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C815\BCF4\B97C \C0AC\C6A9\D558\C5EC Websheet \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\AC00 \C0DD\C131\B429\B2C8\B2E4. \C694\CCAD \B0B4\C6A9\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281613647859870448)
,p_name=>'APEX_WS_SETUP_MSG6'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131\D560 \D14C\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281613760115870448)
,p_name=>'APEX_WS_SETUP_MSG7'
,p_message_language=>'ko'
,p_message_text=>unistr('Websheet \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C81C\AC70\D558\B824\ACE0 \D569\B2C8\B2E4. \C774 \C791\C5C5\C744 \C218\D589\D558\BA74 \C6F9 \C2DC\D2B8 \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\BFD0\B9CC \C544\B2C8\B77C \C791\C5C5\C601\C5ED\C758 \C6F9 \C2DC\D2B8 \AD6C\C131\C694\C18C\B97C \D3EC\D568\D558\B294 \B0B4\BD80 \B370\C774\D130\B3C4 \C0AD\C81C\B429\B2C8\B2E4. \ACC4\C18D\D558\ACA0\C2B5\B2C8\AE4C?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281614063976870448)
,p_name=>'APEX_WS_SETUP_MSG8'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C2DC\D2B8\B97C \C62C\BC14\B974\AC8C \C2E4\D589\D558\B824\BA74 \B2E4\C74C\ACFC \AC19\C740 \BD80\C801\D569\D55C \AC1D\CCB4\B97C \C218\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281950995615870653)
,p_name=>'APEX_WS_SETUP_MSG9'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C791\C5C5\C601\C5ED\C5D0 \B300\D55C \C6F9 \C2DC\D2B8 \C815\C758\B97C \C81C\AC70\D558\B824\ACE0 \D569\B2C8\B2E4. \C6F9 \C2DC\D2B8 \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B294 \B2E4\B978 \C791\C5C5\C601\C5ED\C5D0\C11C\B3C4 \C0AC\C6A9\B418\BBC0\B85C \C0AD\C81C\B418\C9C0 \C54A\C2B5\B2C8\B2E4. \C774 \C791\C5C5\C601\C5ED\ACFC \C5F0\AD00\B41C \B808\CF54\B4DC\B294 \C0AD\C81C\B429\B2C8\B2E4. \ACC4\C18D\D558\ACA0\C2B5\B2C8\AE4C?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281614135272870448)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1D\CCB4 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281614216232870449)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1D\CCB4 \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281613853769870448)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\D0A4\B9C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281950730194870653)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\D560 \AE30\C874 \AC1D\CCB4')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280742494088869882)
,p_name=>'API_PRECONDITION_VIOLATED'
,p_message_language=>'ko'
,p_message_text=>unistr('API \C0AC\C804 \C870\AC74 \C704\BC18')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280900762951869977)
,p_name=>'APP.SETTING.CANNOT.GET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F0\AD00\B41C \BE4C\B4DC \C635\C158\C774 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\B418\C5C8\C73C\BBC0\B85C \C560\D50C\B9AC\CF00\C774\C158 \C124\C815 %0\C5D0 \B300\D55C \AC12\C744 \AC00\C838\C62C \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280900665865869977)
,p_name=>'APP.SETTING.CANNOT.SET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F0\AD00\B41C \BE4C\B4DC \C635\C158\C774 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\B418\C5C8\C73C\BBC0\B85C \C560\D50C\B9AC\CF00\C774\C158 \C124\C815 %0\C5D0 \B300\D55C \AC12\C744 \C124\C815\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281977401381870669)
,p_name=>'APP.SETTING.INVALID.VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C124\C815 %0 \AC12\C774 \BD80\C801\D569\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281977368006870669)
,p_name=>'APP.SETTING.NOT.DEFINED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C694\CCAD\B41C \C560\D50C\B9AC\CF00\C774\C158 \C124\C815 %0\C774(\AC00) \C815\C758\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281977588803870669)
,p_name=>'APP.SETTING.VALUE.NOT.NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C124\C815 %0\C744(\B97C) \B110 \AC12\C73C\B85C \C124\C815\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280793809798869912)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \ACC4\C0B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280793728550869912)
,p_name=>'APPLICACTION_PROCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D504\B85C\C138\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281359047830870281)
,p_name=>'APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281439242970870340)
,p_name=>'APPLICATION BUILDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281263734136870219)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \ACC4\C0B0 \C870\AC74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281266407530870221)
,p_name=>'APPLICATION IMAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C774\BBF8\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281263871742870219)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D504\B85C\C138\C2A4 \C870\AC74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281190532657870173)
,p_name=>'APPLICATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281336234802870266)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281236599043870202)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281277048272870228)
,p_name=>'APPLICATION_ALIAS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BCC4\CE6D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281275067579870227)
,p_name=>'APPLICATION_DELETED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C774 \C0AD\C81C\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280725269140869871)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AC1C\BC1C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281276093305870227)
,p_name=>'APPLICATION_HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C744 \C2DD\BCC4\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281233118248870200)
,p_name=>'APPLICATION_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BC88\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281122468306870127)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 ID\B294 \C608\C57D\B418\C5B4 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281122337813870127)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 ID\B294 \C591\C758 \C815\C218\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281654558049870473)
,p_name=>'APPLICATION_IMAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C774\BBF8\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281306318106870247)
,p_name=>'APPLICATION_ITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280822802286869930)
,p_name=>'APPLICATION_ITEMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280788213587869909)
,p_name=>'APPLICATION_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281276954417870228)
,p_name=>'APPLICATION_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282005528914870686)
,p_name=>'APPLICATION_NAMES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281399355665870310)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BB34\D6A8\D654 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281274573007870226)
,p_name=>'APPLICATION_OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282005490227870686)
,p_name=>'APPLICATION_PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280910990023869983)
,p_name=>'APPLICATION_SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281274772930870226)
,p_name=>'APPLICATION_STATUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C0C1\D0DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281361000474870283)
,p_name=>'APPLICATION_VERSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BC84\C804')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280740838550869881)
,p_name=>'APPLICATION_X'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281220350401870192)
,p_name=>'APPROVED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2B9\C778\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281281215231870230)
,p_name=>'APP_SUCCESS_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C774 \C131\ACF5\C801\C73C\B85C \C0DD\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282008191830870688)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D15C\D50C\B9AC\D2B8 \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280775201772869901)
,p_name=>'APP_TYPE_DATABASE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280775395965869901)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C0B0\C131 \B610\B294 \C0D8\D50C \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281302748606870244)
,p_name=>'APP_TYPE_PACKAGED_WS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0D8\D50C \C6F9 \C2DC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280775174071869901)
,p_name=>'APP_TYPE_WEBSHEET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C2DC\D2B8 \C560\D50C\B9AC\CF00\C774\C158')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281219808054870191)
,p_name=>'ARCHIVED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\CE74\C774\BE0C\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280788589082869909)
,p_name=>'ARCHIVELOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\ADF8 \C544\CE74\C774\BE0C: \C124\C815')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281039496474870070)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C218\C5D0 \CCB4\D06C\C12C\C774 \C788\C5B4\C57C \D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281135261170870136)
,p_name=>'ARGUMENT_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C218 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281135495343870136)
,p_name=>'ARGUMENT_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C218 \C720\D615')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281213755700870188)
,p_name=>'ASAP'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\B2A5\D55C \BE68\B9AC')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281210358593870185)
,p_name=>'ASSIGNED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280908583401869982)
,p_name=>'ASSIGNEE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\C9C0\C815\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282033098559870703)
,p_name=>'ASSIGN_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C9C0\C815')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280969128376870021)
,p_name=>'ASSOCIATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F0\AD00\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280910416086869983)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F0\AD00\B41C \AE30\B2A5')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281241797308870206)
,p_name=>'ATTACHMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCA8\BD80 \D30C\C77C')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282049438629870713)
,p_name=>'AT_RISK_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C704\D5D8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280939081375870000)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C758 \C0AC\C6A9\C790\C815\C758 \C778\C99D \C635\C158\C744 \C778\C99D \CCB4\ACC4\B85C \C774\C804\D558\B824\ACE0 \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280938505140870000)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \C778\C99D \BC29\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280938995185870000)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758 \C778\C99D \D568\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280938648733870000)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\ADF8\C778 \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280938855937870000)
,p_name=>'AUTH.LOGIN_URL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\ADF8\C778 URL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280938729991870000)
,p_name=>'AUTH.NONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280944151229870003)
,p_name=>'AUTHENTICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281264785800870220)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \D568\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281264445832870220)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \CCB4\ACC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280959269154870014)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C778\C99D \CCB4\ACC4\B97C \C0AD\C81C\D558\B824\ACE0 \D569\B2C8\B2E4. \C560\D50C\B9AC\CF00\C774\C158\C774 \D604\C7AC "\CCB4\ACC4" \C778\C99D\C744 \C0AC\C6A9\D558\ACE0 \C788\C9C0 \C54A\AC70\B098 \D574\B2F9 \CCB4\ACC4\AC00 \D604\C7AC \C778\C99D \CCB4\ACC4\AC00 \C544\B2CC \ACBD\C6B0, \CCB4\ACC4\B97C \C0AD\C81C\D574\B3C4 \C560\D50C\B9AC\CF00\C774\C158 \C791\C5C5\C774 \C601\D5A5\C744 \BC1B\C9C0 \C54A\C2B5\B2C8\B2E4. \C560\D50C\B9AC\CF00\C774\C158\C774 "\CCB4\ACC4" \C778\C99D\C744 \C0AC\C6A9\D558\ACE0 \C788\ACE0 \C774 \CCB4\ACC4\AC00 \D604\C7AC \C778\C99D \CCB4\ACC4\C778 \ACBD\C6B0, \C560\D50C\B9AC\CF00\C774\C158\C740 "\CCB4\ACC4" \C778\C99D\C744 \C0AC\C6A9\D558\C5EC \ACC4\C18D \C2E4\D589\B418\C9C0\B9CC \AE30\BCF8 \C778\C99D \CCB4\ACC4\B3C4 \C0AC\C6A9\D569\B2C8\B2E4. \B530\B77C\C11C "\ACF5\AC1C" \C99D\BA85\C11C \D655\C778\C744 \C0AC\C6A9\D558\B294 \B0B4\C7A5 \B85C\ADF8\C778 \D398\C774\C9C0\B97C \C0AC\C6A9\D569\B2C8')
||unistr('\B2E4. \C989, \B204\AD6C\B4E0\C9C0 \C560\D50C\B9AC\CF00\C774\C158\C744 \C2E4\D589\D560 \C218 \C788\C2B5\B2C8\B2E4. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280961113619870015)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C774 \C774 \C778\C99D \CCB4\ACC4\B97C \C0AC\C6A9\D558\B3C4\B85D \D558\B824\BA74 <b>\D604\C7AC\B85C \C124\C815</b> \B2E8\CD94\B97C \B204\B974\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281469040650870359)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_language=>'ko'
,p_message_text=>unistr('Application Express \ACC4\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280721876460869869)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'ko'
,p_message_text=>unistr('Oracle Cloud ID \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281469108916870359)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281469408369870359)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281469247369870359)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \ACC4\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281902403158870624)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('HTTP \BA38\B9AC\AE00 \BCC0\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281469638948870359)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_language=>'ko'
,p_message_text=>'Oracle Application Server Single Sign-On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281469312817870359)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_language=>'ko'
,p_message_text=>unistr('LDAP \B514\B809\D1A0\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281469506454870359)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACF5\AC1C \C99D\BA85\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280712060423869863)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_language=>'ko'
,p_message_text=>unistr('SAML \C0AC\C778\C778')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280750595896869887)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18C\C15C \C0AC\C778\C778')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281307400514870248)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \CCB4\ACC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281264322134870220)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD8C\D55C \BD80\C5EC \CCB4\ACC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280721969094869869)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'ko'
,p_message_text=>unistr('Oracle Cloud ID \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280741099754869881)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('Exists SQL \C9C8\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280741168965869881)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C6B8 \BC18\D658 PL/SQL \D568\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281118269761870124)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B864 \B610\B294 \ADF8\B8F9\C5D0 \D3EC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281118352041870124)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B864 \B610\B294 \ADF8\B8F9\C5D0 \D3EC\D568 \C548\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280741293560869881)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\D604\C2DD 1\C758 \D56D\BAA9 \AC12\C774 \D45C\D604\C2DD 2\C640 \AC19\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280741321274869881)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\D604\C2DD 1\C5D0 \C788\B294 \D56D\BAA9\C740 \B110\C774 \C544\B2D8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280741442412869881)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\D604\C2DD 1\C5D0 \C788\B294 \D56D\BAA9\C740 \B110\C784')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280741531799869881)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\D604\C2DD 1\C758 \D56D\BAA9 \AC12\C740 \D45C\D604\C2DD 2\C640 \AC19\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280741649245869881)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('Not Exists SQL \C9C8\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280741786871869881)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\D604\C2DD 1\C5D0 \C788\B294 \D658\ACBD\C124\C815\C758 \AC12\C740 \D45C\D604\C2DD 2\C640 \AC19\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280741840662869881)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\D604\C2DD 1\C5D0 \C788\B294 \D658\ACBD\C124\C815\C758 \AC12\C740 \D45C\D604\C2DD 2\C640 \AC19\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280806845555869920)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \BCF4\AE30\B9C8\B2E4 \D3C9\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280806949100869920)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158\B2F9 \D55C \BC88 \D3C9\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280744290988869883)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C815\C774 \B9CC\AE30\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280744108852869883)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C815\C774 \C7A0\AE40')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280744516463869883)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300 \B85C\ADF8\C778 \C2DC\B3C4 \D69F\C218\AC00 \CD08\ACFC\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280744698076869883)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C54C \C218 \C5C6\B294 \B0B4\BD80 \C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280744454210869883)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE44\BC00\BC88\D638 \CC98\C74C \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280744350342869883)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C815\D655\D55C \BE44\BC00\BC88\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280743958005869883)
,p_name=>'AUTH_SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\C0C1, \C778\C99D \C131\ACF5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280744069544869883)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C54C \C218 \C5C6\B294 \C0AC\C6A9\C790 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280858891854869952)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C54C \C218 \C5C6\B294 \C791\C5C5\C601\C5ED \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280869391013869958)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_language=>'ko'
,p_message_text=>unistr('\C54C \C218 \C5C6\B294 \C791\C5C5\C601\C5ED \C774\B984: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281013140692870052)
,p_name=>'AUTOCOMMIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CEE4\BC0B \BA85\B839\BB38\C744 \C801\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4. \BAA8\B4E0 \BA85\B839\BB38\C774 \C790\B3D9\C73C\B85C \CEE4\BC0B\B418\C5C8\C2B5\B2C8\B2E4.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281336892016870266)
,p_name=>'AUTOPROVISION_MODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B4F1\B85D \BAA8\B4DC')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280719572514869868)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCAB\BC88\C9F8 \D56D\BAA9')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281362765951870284)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\C6A9\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280749165342869886)
,p_name=>'AVAILABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9 \AC00\B2A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281566459950870419)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\BC1C\C790\B9CC \C0AC\C6A9\D560 \C218 \C788\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281566365324870419)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\BC1C\C790 \B3C4\AD6C \BAA8\C74C\C5D0\C11C \C0AC\C6A9 \AC00\B2A5')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281237302739870203)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3C9\ADE0 \B80C\B354\B9C1 \C2DC\AC04(\CD08)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280807603224869921)
,p_name=>'BACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\B4A4\B85C')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281218225665870190)
,p_name=>'BAR_CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C9\B300 \CC28\D2B8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281639992982870464)
,p_name=>'BASIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280762928150869894)
,p_name=>'BASIC_DEVELOPER'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \AC1C\BC1C\C790')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281197536300870177)
,p_name=>'BEFORE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C55E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282010829526870690)
,p_name=>'BEFORE LIST ENTRY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA9\B85D \D56D\BAA9 \C55E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282031778901870702)
,p_name=>'BEFORE_FIRST'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C791 \C804')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281267647903870222)
,p_name=>'BIND_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\C778\B4DC \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281266959982870221)
,p_name=>'BIND_VARIABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\C778\B4DC \BCC0\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281267095667870221)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\C778\B4DC \BCC0\C218 \B808\C774\BE14')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281282868229870232)
,p_name=>'BLACK_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C815\C0C9 \D14D\C2A4\D2B8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280726391293869872)
,p_name=>'BLANK'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACF5\BC31')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281240905432870205)
,p_name=>'BLOB_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('BLOB \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281401078100870312)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C6B4\B85C\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280778023810869903)
,p_name=>'BLOB_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('Blob \D615\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281401488126870312)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCA8\BD80 \D30C\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281401167746870312)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_language=>'ko'
,p_message_text=>'DOWNLOAD'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281401256581870312)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_language=>'ko'
,p_message_text=>'IMAGE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281401384930870312)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\B77C\C778')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281241961751870206)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_language=>'ko'
,p_message_text=>unistr('BLOB \D615\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281241419403870205)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('BLOB \CD5C\C885 \C5C5\B370\C774\D2B8 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281240887559870205)
,p_name=>'BLOB_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('BLOB \D14C\C774\BE14')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281282751275870232)
,p_name=>'BLUE_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\B780\C0C9 \D14D\C2A4\D2B8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281257917447870216)
,p_name=>'BRANCH CONDITION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84\AE30 \C870\AC74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280811204348869923)
,p_name=>'BRANCHES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84\AE30')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281035360909870067)
,p_name=>'BREADCRUMB'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281198281892870177)
,p_name=>'BREADCRUMB LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281198365804870178)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C\C758 \AE34 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281035476705870067)
,p_name=>'BREADCRUMBS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281291383041870237)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281306524291870247)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C \D56D\BAA9: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281122684595870127)
,p_name=>'BREADCRUMB_PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281206464971870183)
,p_name=>'BREADCRUMB_REGION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C \C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280871685430869959)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C\AC00 \C131\ACF5\C801\C73C\B85C \C0DD\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281200864355870179)
,p_name=>'BROWSE_ICON'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC3E\C544\BCF4\AE30 \C544\C774\CF58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281200671989870179)
,p_name=>'BROWSE_PACKAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D328\D0A4\C9C0 \CC3E\C544\BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281134955437870136)
,p_name=>'BROWSE_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \CC3E\C544\BCF4\AE30')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280729649414869874)
,p_name=>'BUFFER CACHE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\D37C \CE90\C2DC')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281214295519870188)
,p_name=>'BUG'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281238434005870203)
,p_name=>'BUGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281260978498870218)
,p_name=>'BUGS_ASSIGNED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\B41C \BC84\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281300151216870243)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\B41C \BC84\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280758231681869891)
,p_name=>'BUGS_CLOSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\ACB0\B41C \BC84\ADF8(%0/%1):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281675660141870486)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\ADF8 \C885\ACB0\C728(%0/%1):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281300212541870243)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\B418\C9C0 \C54A\C740 \BC84\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281300309427870243)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0A0\C9DC\BCC4 \C218\C815 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281676050147870486)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\ADF8: %1/%0 \C885\ACB0\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282039916114870707)
,p_name=>'BUG_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC84\ADF8: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281254260048870213)
,p_name=>'BUILD QUERY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C8\C758 \C791\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280721458578869869)
,p_name=>'BUILDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281360245020870282)
,p_name=>'BUILDER.PLUGINS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B7EC\ADF8\C778')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281355763695870279)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_language=>'ko'
,p_message_text=>unistr('[\C9C0\C6D0\B418\C9C0 \C54A\B294 \D56D\BAA9]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281650413030870471)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \BA54\C2DC\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280951468604870008)
,p_name=>'BUILD_OPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE4C\B4DC \C635\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281424638680870329)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE4C\B4DC \C635\C158: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282038650818870706)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE4C\B4DC \C0C1\D0DC: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281425594320870330)
,p_name=>'BUILD_VERSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE4C\B4DC \BC84\C804')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281293712317870239)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4\C7A5 \BCF4\ACE0\C11C \D15C\D50C\B9AC\D2B8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281196788966870177)
,p_name=>'BUTTON'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281197495966870177)
,p_name=>'BUTTON LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94 \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281402718630870313)
,p_name=>'BUTTON.ADD'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280738061317869879)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\D55C \B2E8\CD94\C758 \B2E8\CD94 \C18D\C131\C5D0\B294 ID\AC00 \D3EC\D568\B420 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280737956909869879)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\D55C \B2E8\CD94\B294 \C791\C5C5\C774 ''\B3D9\C801 \C791\C5C5\C5D0 \C758\D574 \C815\C758\B428''\C73C\B85C \C124\C815\B41C \B2E8\CD94\C5EC\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280738287926869879)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\D55C \B2E8\CD94\AC00 #BUTTON_ID# \B300\CCB4 \BB38\C790\C5F4\C744 \D3EC\D568\D558\C9C0 \C54A\C740 ''\B2E8\CD94 \D15C\D50C\B9AC\D2B8''\B97C \C0AC\C6A9\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281402524510870313)
,p_name=>'BUTTON.DELETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280811521008869923)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\B97C \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280787780346869909)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C9C8\C758\B97C \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280774913820869901)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94 \C694\CCAD \C18C\C2A4 \C720\D615\C774 "\D56D\C0C1 \B110"\C774 \C544\B2D0 \ACBD\C6B0 \BAA8\B4E0 \B2E8\CD94 \C694\CCAD \C18C\C2A4 \C720\D615\C5D0 \B300\D574 \B2E8\CD94 \C694\CCAD\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280775623068869902)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94 \C694\CCAD \C18C\C2A4 \C720\D615\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280811651825869923)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_language=>'ko'
,p_message_text=>unistr('URL \B300\C0C1\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280740572013869881)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C774 ''\B3D9\C801 \C791\C5C5\C5D0 \C758\D574 \C815\C758\B428''\C778 \ACBD\C6B0 \B2E8\CD94 \C18D\C131\C5D0\B294 ID\AC00 \D3EC\D568\B420 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280813253495869924)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BBF8\C9C0\B97C \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280813303833869924)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\D0C0\C77C\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280813102688869924)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D15C\D50C\B9AC\D2B8\B97C \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280740410069869880)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94 \C2A4\D0C0\C77C\C774 ''\D15C\D50C\B9AC\D2B8 \AE30\BC18 \B2E8\CD94''\C774\ACE0 \C791\C5C5\C774 ''\B3D9\C801 \C791\C5C5\C5D0 \C758\D574 \C815\C758\B428''\C778 \ACBD\C6B0 \C120\D0DD\D55C \B2E8\CD94 \D15C\D50C\B9AC\D2B8\C5D0\B294 #BUTTON_ID# \B300\CCB4 \BB38\C790\C5F4\C774 \D3EC\D568\B418\C5B4\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280728097546869873)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94\AC00 \B3D9\C801 \C791\C5C5(\D398\C774\C9C0: %0, \B3D9\C801 \C791\C5C5: ''%1'', \C791\C5C5: ''%2'', \C18D\C131: ''\C601\D5A5\C744 \BC1B\B294 \C694\C18C'')\C5D0\C11C \CC38\C870\B418\BBC0\B85C \B2E8\CD94\B97C \C0AD\C81C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280727967144869873)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94\AC00 \B3D9\C801 \C791\C5C5(\D398\C774\C9C0: %0, \B3D9\C801 \C791\C5C5: ''%1'', \C18D\C131: ''\C2DC\AE30'')\C5D0\C11C \CC38\C870\B418\BBC0\B85C \B2E8\CD94\B97C \C0AD\C81C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281402672694870313)
,p_name=>'BUTTON.SUBMIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\CD9C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281398567591870310)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_language=>'ko'
,p_message_text=>unistr('"onclick" \C18D\C131\C5D0 \C0AC\C6A9\B420 \C608\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281402046848870313)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_language=>'ko'
,p_message_text=>unistr('"href" \C18D\C131\C5D0 \C0AC\C6A9\B420 \C608\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280811451652869923)
,p_name=>'BUTTONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281268199894870222)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94 \C18D\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280720342598869868)
,p_name=>'BUTTON_CSS_CLASSES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94 CSS \D074\B798\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280918801234869988)
,p_name=>'BUTTON_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131\B41C \B2E8\CD94 ID\B294 \C815\C758\B41C \ACBD\C6B0 \B2E8\CD94\C758 \C815\C801 ID\AC00 \B418\BA70, \C815\C758\B418\C9C0 \C54A\C740 \ACBD\C6B0 ''B'' || [Internal Button ID] \D615\C2DD\C758 \B0B4\BD80\C801\C73C\B85C \C0DD\C131\B41C ID\AC00 \B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282038400718870706)
,p_name=>'BUTTON_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281273359418870225)
,p_name=>'BUTTON_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94 \D15C\D50C\B9AC\D2B8')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280808367990869921)
,p_name=>'BYTES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\C774\D2B8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281213837381870188)
,p_name=>'BY_NEXT_PATCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \D328\CE58\B85C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281213919374870188)
,p_name=>'BY_NEXT_RELEASE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \B9B4\B9AC\C2A4\B85C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282137876855870767)
,p_name=>'CA.ABOUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282104109400870746)
,p_name=>'CA.ABOUT.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282104045805870746)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \C124\BA85, \C560\D50C\B9AC\CF00\C774\C158 \BC84\C804 \BC0F \D398\C774\C9C0 \C218\B97C \B098\D0C0\B0B4\B294 \C774 \C560\D50C\B9AC\CF00\C774\C158 \C815\BCF4 \D398\C774\C9C0\B97C \D3EC\D568\D569\B2C8\B2E4.'),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280928966948869994)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_language=>'ko'
,p_message_text=>unistr('\CF58\D150\CE20 \CEE8\D14C\C774\B108')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282138013867870767)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282138135778870767)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \D14D\C2A4\D2B8\B97C \C5EC\AE30\C5D0 \C785\B825\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282137751776870767)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0 \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282150016685870774)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \BBF8\B9AC\BCF4\AE30 \B9B4\B9AC\C2A4 \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282104444865870746)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282140343059870768)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282129843469870762)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \AD6C\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282102855908870746)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\B864 \AE30\BC18 \C0AC\C6A9\C790 \AD8C\D55C \BD80\C5EC \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282104547927870747)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158 \B0B4\C5D0\C11C \B864 \AE30\BC18 \C0AC\C6A9\C790 \C778\C99D\C744 \D1B5\D569\D569\B2C8\B2E4.'),
unistr('\C0AC\C6A9\C790\B294 \AD00\B9AC\C790, \C81C\ACF5\C790 \B610\B294 \C870\D68C\C790\B85C \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4.'),
unistr('\ADF8\B7EC\BA74 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \D398\C774\C9C0, \BA54\B274 \D56D\BAA9, \C601\C5ED, \C5F4, \D56D\BAA9, \B2E8\CD94 \B4F1\ACFC \AC19\C740 \B2E4\C591\D55C \AD6C\C131\C694\C18C\C5D0 \B300\D55C \C11C\B85C \B2E4\B978 \B864\C5D0 \B300\D574 \B2E4\B978 \C561\C138\C2A4 \AD8C\D55C\C744 \C190\C27D\AC8C \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.'),
'<ul>',
unistr('<li>\C81C\C5B4 \AE30\B2A5\C5D0 \C561\C138\C2A4\D560 \C218 \C788\B294 \B9C1\D06C\AC00 \C81C\ACF5\B418\B294 \AD00\B9AC \D398\C774\C9C0 \C601\C5ED</li>'),
unistr('<li>\C561\C138\C2A4 \C81C\C5B4\B97C \AD00\B9AC\D560 \C218 \C788\B294 \C0AC\C6A9\C790 \D14C\C774\BE14</li>'),
unistr('<li>\C778\C99D\B41C \C0AC\C6A9\C790\C758 \C561\C138\C2A4 \B808\BCA8\C744 \C124\C815\D560 \C218 \C788\B294 \AD6C\C131 \D398\C774\C9C0</li>'),
unistr('<li>\C0AC\C6A9\C790 \C774\B984\C774 \C804\C790\BA54\C77C \C8FC\C18C\C778\C9C0 \C5EC\BD80\B97C \C9C0\C815\D560 \C218 \C788\B294 \AD6C\C131 \D398\C774\C9C0</li>'),
unistr('<li>\C0AC\C6A9\C790 \C561\C138\C2A4\B97C \BCF4\ACE0\D558\ACE0 \D3B8\C9D1\D560 \C218 \C788\B294 \C0AC\C6A9\C790 \C561\C138\C2A4 \D398\C774\C9C0 \AD00\B9AC</li>'),
unistr('<li>\B2E8\C77C \C0AC\C6A9\C790\B97C \CD94\AC00\D560 \C218 \C788\B294 \AE30\B2A5\C744 \C0AC\C6A9\D558\C5EC \C0AC\C6A9\C790 \D398\C774\C9C0 \CD94\AC00</li>'),
unistr('<li>\C5EC\B7EC \C0AC\C6A9\C790(\C804\C790\BA54\C77C \C0AC\C6A9\C790 \C774\B984\B9CC \D574\B2F9)\B97C \CD94\AC00\D560 \C218 \C788\B294 \AE30\B2A5\C744 \C0AC\C6A9\D558\C5EC \C5EC\B7EC \C0AC\C6A9\C790 \D398\C774\C9C0 \CD94\AC00</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282128704953870761)
,p_name=>'CA.ACCESS.ROLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B864')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282129434892870762)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \B864 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280848314604869945)
,p_name=>'CA.ACCESS.ROLES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B864')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282128822787870761)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C815\C774 \C7A0\AE40')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280876195799869962)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D655\C778\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282140130819870768)
,p_name=>'CA.ACL.INFORMATION'
,p_message_language=>'ko'
,p_message_text=>unistr('ACL \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282140805451870769)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD8C\D55C\C774 \CDA9\BD84\D558\C9C0 \C54A\C2B5\B2C8\B2E4. \C0AC\C6A9\C790\AC00 \AD00\B9AC\C790\AC00 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282140949895870769)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C744 \BCFC \C218 \C788\B294 \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4. \C561\C138\C2A4\AC00 \BD80\C5EC\B418\C9C0 \C54A\C558\AC70\B098 \ACC4\C815\C774 \C7A0\ACA8 \C788\C2B5\B2C8\B2E4. \C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\C5D0\AC8C \BB38\C758\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282141096921870769)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD8C\D55C\C774 \CDA9\BD84\D558\C9C0 \C54A\C2B5\B2C8\B2E4. \C0AC\C6A9\C790\AC00 \C81C\ACF5\C790\AC00 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282130532761870762)
,p_name=>'CA.ACL.SAVED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \C124\C815\C744 \C800\C7A5\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282135228349870765)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \B2E8\CD94 HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282134180720870765)
,p_name=>'CA.ACTION.LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282134267048870765)
,p_name=>'CA.ACTION.LINK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \B9C1\D06C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282136851718870766)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \B9C1\D06C HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282122304755870757)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C774 \CC98\B9AC\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282127831771870761)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04\BCC4 \C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282162179438870782)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \B300\C2DC\BCF4\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282104660073870747)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \BCF4\ACE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282103809470870746)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C791\C5C5 \BC0F \C624\B958 \BCF4\ACE0\C11C \D3EC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282104789534870747)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C758 \C77C\BC18 \C0AC\C6A9\C790 \C791\C5C5\C5D0 \B300\D55C \B2E4\C591\D55C \BCF4\ACE0\C11C\B97C \D3EC\D568\D569\B2C8\B2E4. \AC00\C7A5 \D65C\BC1C\D55C \C0AC\C6A9\C790, \AC00\C7A5 \B9CE\C774 \C0AC\C6A9\B41C \D398\C774\C9C0, \D398\C774\C9C0\C758 \C131\ACFC \BC0F \BC1C\C0DD\D55C \C624\B958\B97C \D655\C778\D558\C5EC \C560\D50C\B9AC\CF00\C774\C158\C774 \C5B4\B5BB\AC8C \D65C\C6A9\B418\ACE0 \C788\B294\C9C0 \BC0F \AC1C\C120 \C601\C5ED\C744 \B354 \D6A8\C728\C801\C73C\B85C \D30C\C545\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.'),
'<ul>',
unistr('<li>\C0C1\C704 \C0AC\C6A9\C790 \BCF4\ACE0\C11C</li>'),
unistr('<li>\C560\D50C\B9AC\CF00\C774\C158 \C624\B958 \B85C\ADF8 \BCF4\ACE0\C11C</li>'),
unistr('<li>\D398\C774\C9C0\BCC4 \D398\C774\C9C0 \C131\ACFC, \C791\C5C5 \BC0F \C131\B2A5</li>'),
unistr('<li>\D398\C774\C9C0\BCC4 \C560\D50C\B9AC\CF00\C774\C158 \C791\C5C5 \BCF4\ACE0\C11C</li>'),
unistr('<li>\D398\C774\C9C0 \BDF0 \C138\BD80\C815\BCF4 \BCF4\ACE0\C11C</li>'),
'',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281250587214870211)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\C81C \C2DC\C791 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282140039928870768)
,p_name=>'CA.ADD'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282135471612870765)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282153056231870776)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C911 \C0AC\C6A9\C790 \CD94\AC00 - \B2E8\ACC4 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282138300028870767)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 %0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282121334288870757)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1B5\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281993828079870679)
,p_name=>'CA.ADD.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282129529098870762)
,p_name=>'CA.ADD.USER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282153413388870776)
,p_name=>'CA.ADD.USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282106230499870748)
,p_name=>'CA.ADDING.PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282106714064870748)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('<p><strong>\D398\C774\C9C0 \CD94\AC00</strong>\B97C \B20C\B7EC \C560\D50C\B9AC\CF00\C774\C158\C5D0 \D398\C774\C9C0\B97C \CD94\AC00\D569\B2C8\B2E4. \ADF8\B7F0 \B2E4\C74C \D398\C774\C9C0 \C720\D615(\C608: \BE44\C5B4 \C788\C74C, \CC28\D2B8, \D3FC, \BCF4\ACE0\C11C \B4F1)\C744 \C120\D0DD\D558\ACE0 \D574\B2F9 \C18D\C131\C744 \C815\C758\D569\B2C8\B2E4. \C801\D569\D55C \D14C\C774\BE14 \B610\B294 \BDF0\B97C \C9C0\C815\D558\AC70\B098 SQL \C6CC\D06C\C20D\C744 \C0AC\C6A9\D558\C5EC \C791\C5C5\C601\C5ED\C5D0\C11C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C900\BE44\D574\C57C \D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282136293138870766)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\AE09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281249864571870211)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00 \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282129208943870762)
,p_name=>'CA.ADDRESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C8FC\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282109486834870750)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282110032085870750)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C758 \C778\C99D\B41C \C0AC\C6A9\C790\C5D0 \B300\D55C \C561\C138\C2A4 \B808\BCA8 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282108572805870749)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282109599005870750)
,p_name=>'CA.ADMIN.ADD'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282111204936870751)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282109939930870750)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281285559793870233)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AD6C\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281396244393870308)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282144895938870771)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282144980686870771)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131\C694\C18C \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282108189107870749)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8 \C2A4\D0C0\C77C \C120\D0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282108260709870749)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \C560\D50C\B9AC\CF00\C774\C158 \BAA8\C591 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282107885673870749)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131 \C635\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282107737736870749)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AE30\B2A5 \C0AC\C6A9 \B610\B294 \C0AC\C6A9 \C548\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282108838308870749)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C624\B958 \B85C\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282108942801870749)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C774 \B85C\AE45\D55C \C624\B958 \BCF4\ACE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282108378698870749)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282108430489870749)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C774\B984 \BC0F \AC04\B2E8\D55C \C124\BA85 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282107990626870749)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C5C5\B370\C774\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282108081945870749)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C5C5\B370\C774\D2B8 \BAA9\B85D \C720\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282107447131870748)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282109886781870750)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\ACF5\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282160938217870781)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C2DC\BCF4\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282160886721870781)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C5C5 \CE21\C815\D56D\BAA9 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282112983322870752)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \C2DC\AC04\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282113077693870752)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \AE30\BCF8 \C2DC\AC04\B300 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282110765174870750)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282113139283870752)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282113281716870752)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C\C744 \C804\C1A1\D574\C57C \D558\B294\C9C0 \C5EC\BD80\B97C \C124\C815\D558\ACE0 \C804\C1A1\D560 \ACBD\C6B0 \D68C\C2E0 \B300\C0C1 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282110296033870750)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\B4DC\BC31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282110517689870750)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\B4DC\BC31 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282110604452870750)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCA8\BD80\B97C \D5C8\C6A9\D574\C57C \D560\C9C0 \C5EC\BD80\B97C \AD00\B9AC\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282110385373870750)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \D53C\B4DC\BC31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282110443863870750)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C0AC\C6A9\C790\AC00 \C81C\CD9C\D55C \BAA8\B4E0 \D53C\B4DC\BC31 \BCF4\ACE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282110833422870750)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282110960304870750)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C0AC\C6A9\D558\B294 \C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8 HTML \BC0F CSS \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282107579571870748)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1B5\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282107657877870748)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\D648 \D398\C774\C9C0\C5D0 \D1B5\C9C0 \D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282145508010870772)
,p_name=>'CA.ADMIN.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282109070517870749)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C131\B2A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282109161148870749)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D398\C774\C9C0\BCC4 \C791\C5C5 \BC0F \C131\B2A5 \BCF4\ACE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282109256923870749)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282109310116870749)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \B0A0\C9DC \BC0F \ACBD\ACFC \C2DC\AC04\C744 \D3EC\D568\D558\C5EC \C0AC\C6A9\C790\BCC4 \AC01 \D398\C774\C9C0 \BDF0 \BCF4\ACE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282109742734870750)
,p_name=>'CA.ADMIN.READERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\D68C\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282154194734870777)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C804\C1A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282154212629870777)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \D15C\D50C\B9AC\D2B8 \AE30\BC18 \C804\C790\BA54\C77C \C804\C1A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282108613183870749)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C0C1\C704 \C0AC\C6A9\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282108796708870749)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\BCC4\B85C \C9D1\ACC4\B41C \D398\C774\C9C0 \BDF0 \BCF4\ACE0\C11C\C785\B2C8\B2E4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282109684595870750)
,p_name=>'CA.ADMIN.USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282110199504870750)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \C124\C815 \BCC0\ACBD \BC0F \C561\C138\C2A4 \C81C\C5B4 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282111038240870751)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \B85C\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282111164429870751)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C774 \BCF4\B0B8 \C804\C790\BA54\C77C\C5D0 \B300\D55C \B85C\ADF8 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281032188172870065)
,p_name=>'CA.ADVANCED'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\ACE0\AE09</strong> - \ACE0\AE09 \C635\C158\C744 \D45C\C2DC\D558\B824\BA74 \D655\C7A5\D569\B2C8\B2E4.'),
'    <ul>',
unistr('      <li><strong>\D648 \D398\C774\C9C0\B85C \C124\C815</strong> - \C774 \D398\C774\C9C0\B97C \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \D648 \D398\C774\C9C0\B85C \B9CC\B4E4\B824\BA74 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\C774\C804\C5D0 \D648 \D398\C774\C9C0\B85C \C815\C758\B41C \BAA8\B4E0 \D398\C774\C9C0\B294 \C5C5\B370\C774\D2B8\B429\B2C8\B2E4.</li>'),
unistr('      <li><strong>\AD00\B9AC \D398\C774\C9C0\B85C \C124\C815</strong> - \C774 \D398\C774\C9C0\B97C \C560\D50C\B9AC\CF00\C774\C158\C758 \C77C\BC18 \D398\C774\C9C0\AC00 \C544\B2CC \AD00\B9AC \D398\C774\C9C0\B85C \CD94\AC00\D569\B2C8\B2E4. \AE30\BCF8 \BA54\B274\C5D0\C11C [\AD00\B9AC]\B97C \B204\B978 \B2E4\C74C [\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC] \BAA9\B85D\C5D0\C11C \C120\D0DD\D558\C5EC \C561\C138\C2A4\D569\B2C8\B2E4.<br>'),
unistr('        <em><strong>\CC38\ACE0:</strong> \D55C \D398\C774\C9C0\B97C \D648 \D398\C774\C9C0\C640 \AD00\B9AC \D398\C774\C9C0\B85C \C124\C815\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</em></li>'),
'      &nbsp;<br>',
unistr('      <li><strong>\D398\C774\C9C0 \B3C4\C6C0\B9D0</strong> - \D398\C774\C9C0\C5D0 \B300\D55C \B3C4\C6C0\B9D0 \D14D\C2A4\D2B8\C5D0 \CD94\AC00\D560 \D14D\C2A4\D2B8\B97C \C785\B825\D569\B2C8\B2E4.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280902481511869978)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\ACE0\AE09</strong> - \ACE0\AE09 \C635\C158\C744 \BCF4\B824\BA74 \D655\C7A5\D569\B2C8\B2E4.'),
'    <ul>',
unistr('      <li><strong>\D398\C774\C9C0 \B3C4\C6C0\B9D0</strong> - \D398\C774\C9C0\C758 \B3C4\C6C0\B9D0 \D14D\C2A4\D2B8\C5D0 \CD94\AC00\D560 \D14D\C2A4\D2B8\B97C \C785\B825\D569\B2C8\B2E4.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282145918175870772)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE0\AE09 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282146035951870772)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\CD94\AC00 \C815\C758, \BCF4\C548 \BC0F \C804\C5ED\D654 \C124\C815\C744 \AD6C\C131\D569\B2C8\B2E4. \D574\B2F9 \C124\C815\C740 \C560\D50C\B9AC\CF00\C774\C158\C744 \C0DD\C131\D560 \B54C \C801\C6A9\D560 \C218 \C788\C73C\BA70 \C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131 \D6C4\C5D0\B3C4 \D3B8\C9D1\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282149023406870774)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C790\C138\D55C \B0B4\C6A9\C740 \AC01 \C124\C815\C5D0 \B300\D55C \D56D\BAA9 \B3C4\C6C0\B9D0(<span class="fa fa-question-circle" aria-hidden="true"></span>)\C744 \D655\C778\D558\C2ED\C2DC\C624.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282154848771870777)
,p_name=>'CA.AFTER.ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \B4A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282135176036870765)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \B4A4 HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282138297653870767)
,p_name=>'CA.ALL.COLS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282134326762870765)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\C2E0 \AC70\BD80 \D5C8\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281243497706870207)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\D55C \BAA8\B4DC\B85C \C2E4\D589 \D5C8\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282127729554870761)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C624\B958 \B85C\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282123656039870758)
,p_name=>'CA.APP.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281296448224870240)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4\AC00 \C124\C815\B418\C5B4 \C788\B294\C9C0 \C5EC\BD80')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281296575842870240)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0 \C5C6\B294 \C778\C99D\B41C \C0AC\C6A9\C790\C5D0\AC8C \C81C\ACF5\B418\B294 \AE30\BCF8 \C561\C138\C2A4 \B808\BCA8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282124063615870759)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C124\C815\C744 \C5C5\B370\C774\D2B8\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282123832477870758)
,p_name=>'CA.APP.SUBTITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC04\B2E8\D55C \C124\BA85')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282123918835870758)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5EC\AE30\C5D0 \C785\B825\D55C \D14D\C2A4\D2B8\B294 \C560\D50C\B9AC\CF00\C774\C158\C758 \D648 \D398\C774\C9C0\C5D0 \C788\B294 \C560\D50C\B9AC\CF00\C774\C158 \C774\B984 \C544\B798\C5D0 \D45C\C2DC\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282113355567870752)
,p_name=>'CA.APPEARANCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\C591')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282113452385870752)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\AE30\BCF8 \C560\D50C\B9AC\CF00\C774\C158 \C0C9\C0C1 \CCB4\ACC4(\D14C\B9C8 \C2A4\D0C0\C77C), \D0D0\C0C9\C774 \C788\B294 \C704\CE58 \BC0F \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C0AC\C6A9\B41C \C544\C774\CF58\C744 \C815\C758\D569\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282132888767870764)
,p_name=>'CA.APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282119986744870756)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BAA8\C591')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282113939629870752)
,p_name=>'CA.APPLICATION.ICON'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C544\C774\CF58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282114007508870752)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('<p><strong>\C0C8 \C544\C774\CF58 \C120\D0DD</strong>\C744 \B20C\B7EC \C544\C774\CF58 \C0C9\C0C1 \BC0F \C0AC\C6A9 \AC00\B2A5\D55C \C544\C774\CF58 \C911 \D558\B098\B97C \C120\D0DD\D569\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C740 \C560\D50C\B9AC\CF00\C774\C158\C758 \D648 \D398\C774\C9C0\C5D0 \D45C\C2DC\B429\B2C8\B2E4.</p>')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282114371645870753)
,p_name=>'CA.APPLICATION.ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282114442750870753)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \ACE0\C720\D55C \C22B\C790 \C2DD\BCC4\C790\B97C \C785\B825\D569\B2C8\B2E4. \C774 \D544\B4DC\C5D0\B294 \AE30\BCF8\C801\C73C\B85C \C790\B3D9\C73C\B85C \C0DD\C131\B41C \C2DD\BCC4\C790\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282133486507870764)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282125692459870760)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C138\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282104292690870746)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282103140752870746)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C774\B984 \BC0F \AC04\B2E8\D55C \C124\BA85 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282104343581870746)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\AC00 \C560\D50C\B9AC\CF00\C774\C158 \C774\B984 \BC0F \C124\BA85, \AE30\BCF8 \C2DC\AC04\B300 \B4F1\ACFC \AC19\C740 \B2E4\C591\D55C \C124\C815\C744 \C5C5\B370\C774\D2B8\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.'),
'<ul>',
unistr('<li>\AD00\B9AC \D398\C774\C9C0 \BAA9\B85D \D56D\BAA9 \BC0F \D3FC</li>'),
unistr('<li>\C560\D50C\B9AC\CF00\C774\C158 \C774\B984 \C124\C815 \AE30\B2A5</li>'),
unistr('<li>\D648 \D398\C774\C9C0 \C8FC \C601\C5ED \BD80\C81C \C124\C815 \AE30\B2A5</li>'),
unistr('<li>\D53C\B4DC\BC31\C744 \C0AC\C6A9\D558\B294 \ACBD\C6B0 \D53C\B4DC\BC31 \C218\C2E0\C790 \C124\C815 \AE30\B2A5</li>'),
unistr('<li>\C560\D50C\B9AC\CF00\C774\C158 \AE30\BCF8 \C2DC\AC04\B300 \C124\C815 \AE30\B2A5</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282159980602870780)
,p_name=>'CA.APPLICATIONITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282161768589870781)
,p_name=>'CA.APPLY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282163594454870783)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AE30\BCF8\AC12 \C801\C6A9 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282119169433870756)
,p_name=>'CA.APPLY.CHANGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\ACBD\C0AC\D56D \C801\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282161540064870781)
,p_name=>'CA.APPLY.FILTERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \C801\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281394147673870307)
,p_name=>'CA.APP_BANNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131 \B9C8\BC95\C0AC %0\C5D0\C11C \C0DD\C131\B41C \C560\D50C\B9AC\CF00\C774\C158\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281395436991870308)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\C815 \C800\C7A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282165730754870784)
,p_name=>'CA.ATTACHMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCA8\BD80 \D30C\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281109875250870118)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCA8\BD80 \D30C\C77C \C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282165838790870784)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCA8\BD80 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281109783825870118)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCA8\BD80 \D30C\C77C \D06C\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282161829092870782)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 %0\C5D0 \B300\D55C \C18D\C131 \AE30\BCF8\AC12\C774 \C774\BBF8 \C815\C758\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282129972707870762)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\B41C \BAA8\B4E0 \C0AC\C6A9\C790\B294 \C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C561\C138\C2A4\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282115194551870753)
,p_name=>'CA.AUTHENTICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282115202464870753)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C0AC\C6A9\C790\AC00 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D574 \C778\C99D\D558\B294 \BC29\BC95\C744 \C120\D0DD\D569\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281246199248870208)
,p_name=>'CA.AUTO.DROP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C790\B3D9 \C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282126367058870760)
,p_name=>'CA.AVG.ELAPSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3C9\ADE0 \ACBD\ACFC \C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281293557508870239)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \BCF4\ACE0\C11C\B85C \B3CC\C544\AC00\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281110529870870119)
,p_name=>'CA.BCC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C228\C740 \CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282154766795870777)
,p_name=>'CA.BEFORE.ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C55E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282135078647870765)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C55E HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282136569029870766)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C55E \CF58\D150\CE20')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282111830690870751)
,p_name=>'CA.BLANK'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE48 \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282111946241870751)
,p_name=>'CA.BLANK.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\BE48 \D398\C774\C9C0\B97C \C704\CE58 \D45C\C2DC\C790\B85C \C0DD\C131\D569\B2C8\B2E4. \C560\D50C\B9AC\CF00\C774\C158\C744 \C0DD\C131\D55C \D6C4\C5D0\B294 \D398\C774\C9C0 \B514\C790\C774\B108\C5D0\C11C \AC04\D3B8\D558\AC8C \D398\C774\C9C0\C5D0 \C601\C5ED\C744 \C0DD\C131\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D398\C774\C9C0 \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C758 \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('<!--  <li><strong>\D398\C774\C9C0 \D0D0\C0C9 \D3EC\D568</strong> - \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C815\C758\B41C \AE30\D0C0 \BAA8\B4E0 \D398\C774\C9C0\C758 \CE74\B4DC \BAA9\B85D\C744 \D45C\C2DC\D558\B824\BA74 \C774 \C635\C158\C744 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\C774 \C635\C158\C740 \C560\D50C\B9AC\CF00\C774\C158 \D648 \D398\C774\C9C0\C5D0 \C77C\BC18\C801\C73C\B85C \C0AC\C6A9\B429\B2C8\B2E4.</li>'),
'-->',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282145263690870771)
,p_name=>'CA.BLUEPRINT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \CCAD\C0AC\C9C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282145303237870771)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\CCAD\C0AC\C9C4\C5D0\B294 JSON \D615\C2DD\C758 \C560\D50C\B9AC\CF00\C774\C158 \C815\C758\AC00 \B098\C5F4\B429\B2C8\B2E4.</p>'),
unistr('<p>\C774 \D654\BA74\C744 \CC98\C74C \C2DC\C791\D558\B294 \ACBD\C6B0 \D604\C7AC \C560\D50C\B9AC\CF00\C774\C158 \C815\C758\AC00 JSON \BB38\C11C\B85C \BCC0\D658\B418\C5B4 \D45C\C2DC\B429\B2C8\B2E4. \BB38\C11C\B97C \D3B8\C9D1\D558\C5EC \C560\D50C\B9AC\CF00\C774\C158 \C18D\C131\C744 \C5C5\B370\C774\D2B8\D558\ACE0 <strong>\CCAD\C0AC\C9C4 \C801\C6A9</strong>\C744 \B20C\B7EC \D604\C7AC \C560\D50C\B9AC\CF00\C774\C158 \C138\BD80\C815\BCF4\B97C \BCC0\ACBD\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
'<p>&nbsp;</p>',
unistr('<p>\C720\C0AC\D55C \D398\C774\C9C0\B97C \B9CE\C774 \C0DD\C131\D574\C57C \D558\B294 \ACBD\C6B0 \D55C \D398\C774\C9C0\C5D0 \B300\D574 \C801\C808\D55C JSON \CF54\B4DC\B97C \BCF5\C0AC\D558\C5EC \C5EC\B7EC \BC88 \BD99\C5EC\B123\ACE0 JSON\C744 \C870\AE08\C529 \C870\C815\D558\B294 \AC83\C774 \AC01 \D398\C774\C9C0\C5D0 \B300\D574 <strong>\D398\C774\C9C0 \CD94\AC00</strong>\B97C \C0AC\C6A9\D558\C5EC \C218\B3D9\C73C\B85C \C791\C5C5\D558\B294 \AC83\BCF4\B2E4 \BE60\B985\B2C8\B2E4.</p>'),
unistr('<p>\CCAD\C0AC\C9C4\C744 \C774\C804\C5D0 \C0DD\C131\B41C \C560\D50C\B9AC\CF00\C774\C158\C758 \C815\C758\B85C \BC14\AFB8\B824\BA74 <strong>\C774\C804 \CCAD\C0AC\C9C4 \B85C\B4DC</strong>\B97C \B204\B985\B2C8\B2E4. \ADF8\B7EC\BA74 \C560\D50C\B9AC\CF00\C774\C158\C744 \B2E4\C2DC \C0DD\C131\D558\AE30 \C804\C5D0 \B2E4\B978 \D398\C774\C9C0\B97C \CD94\AC00\D558\AC70\B098 \AE30\B2A5\C744 \BCC0\ACBD\D558\AC70\B098 \C124\C815\C744 \C870\C815\D558\C5EC \B9E4\C6B0 \AC04\D3B8\D558\AC8C \C560\D50C\B9AC\CF00\C774\C158 \C124\ACC4\B97C \BC18\BCF5\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282133965766870765)
,p_name=>'CA.BODY1.TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF8\BB381 \D14D\C2A4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282134053573870765)
,p_name=>'CA.BODY2.TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF8\BB382 \D14D\C2A4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282155193031870777)
,p_name=>'CA.BOTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282120381854870756)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC\C790 \D398\C774\C9C0\C5D0 \B300\D55C \BD84\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281031029210870064)
,p_name=>'CA.BUTTON.BAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94 \BAA8\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282120040363870756)
,p_name=>'CA.BUTTONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282112537587870751)
,p_name=>'CA.CALENDAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EC\B825 \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282112648270870752)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B2EC\B825\C744 \D45C\C2DC\D558\B294 \D398\C774\C9C0\B97C \C0DD\C131\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D398\C774\C9C0 \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C5D0 \B300\D55C \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D14C\C774\BE14 \B610\B294 \BDF0</strong>(\D544\C218) - \B2EC\B825\C5D0 \B300\D55C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D45C\C2DC \C5F4</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \B2EC\B825 \C774\BCA4\D2B8\C5D0 \D45C\C2DC\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C2DC\C791 \B0A0\C9DC \C5F4</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \B2EC\B825 \C774\BCA4\D2B8\C5D0 \B300\D55C \C2DC\C791 \B0A0\C9DC\B85C \C0AC\C6A9\D560 \B0A0\C9DC \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C885\B8CC \B0A0\C9DC \C5F4</strong> - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \B2EC\B825 \C774\BCA4\D2B8\C5D0 \B300\D55C \C885\B8CC \B0A0\C9DC\B85C \C0AC\C6A9\D560 \B0A0\C9DC \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\C885\B8CC \B0A0\C9DC\AC00 \C9C0\C815\B41C \ACBD\C6B0 \AE30\AC04\C744 \AE30\BC18\C73C\B85C \D558\B294 \C774\BCA4\D2B8\AC00 \D45C\C2DC\B429\B2C8\B2E4. </li>'),
unistr('  <li><strong>\C2DC\AC04 \D45C\C2DC</strong> - \C774\BCA4\D2B8\C758 \C2DC\AC04 \BD80\BD84\C744 \D45C\C2DC\D558\ACE0 \C8FC \B2E8\C704 \BC0F \C77C \B2E8\C704 \B2EC\B825 \BDF0\B3C4 \C0AC\C6A9\C73C\B85C \C124\C815\D558\B824\BA74 <strong>\C608</strong>\B97C \C120\D0DD\D569\B2C8\B2E4. \C774\BCA4\D2B8\C5D0 \B300\D55C \B0A0\C9DC\B9CC \D45C\C2DC\D558\B824\BA74 <strong>\C544\B2C8\C624</strong>\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282119082968870755)
,p_name=>'CA.CANCEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CDE8\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282120912271870757)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C0C1\C790 \CDE8\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281011149902870050)
,p_name=>'CA.CANCEL.MODAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B2EC \CDE8\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282130810011870763)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \ACE0\C720 \B808\CF54\B4DC\C5D0\C11C \AD00\B9AC\C790 \AD8C\D55C\C744 \C81C\AC70\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282162748038870782)
,p_name=>'CA.CARD'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE74\B4DC \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282162682083870782)
,p_name=>'CA.CARD.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\CE74\B4DC\B97C \D45C\C2DC\D558\B294 \D398\C774\C9C0\B97C \C0DD\C131\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D398\C774\C9C0 \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C758 \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D14C\C774\BE14 \B610\B294 \BDF0</strong>(\D544\C218) - \CE74\B4DC\C5D0 \B300\D55C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\CE74\B4DC \C81C\BAA9</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \CE74\B4DC\C5D0 \B300\D55C \C81C\BAA9\C73C\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C124\BA85 \C5F4</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \CE74\B4DC\C5D0 \B300\D55C \C124\BA85\C73C\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\CD94\AC00 \D14D\C2A4\D2B8 \C5F4</strong> - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \CE74\B4DC\C5D0 \B300\D55C \BCF4\C870 \C124\BA85\C73C\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282161253620870781)
,p_name=>'CA.CARDS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE74\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282161336481870781)
,p_name=>'CA.CARDS.VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE74\B4DC \BDF0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281110661364870119)
,p_name=>'CA.CC'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC38\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281394836934870307)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \BCC0\ACBD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282111682311870751)
,p_name=>'CA.CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282111787950870751)
,p_name=>'CA.CHART.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C601\C5ED, \B9C9\B300, \AEBE\C740\C120\D615 \B610\B294 \D30C\C774 \CC28\D2B8\B97C \D45C\C2DC\D558\B294 \D398\C774\C9C0\B97C \C0DD\C131\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D398\C774\C9C0 \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C758 \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\CC28\D2B8 \C720\D615</strong> - \D45C\C2DC\D560 \CC28\D2B8 \C720\D615[<strong>\C601\C5ED</strong>, <strong>\B9C9\B300</strong>, <strong>\AEBE\C740\C120\D615</strong>, <strong>\D30C\C774</strong>]\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D14C\C774\BE14 \B610\B294 \BDF0</strong>(\D544\C218) - \CC28\D2B8\C5D0 \B300\D55C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\B808\C774\BE14 \C5F4</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \CC28\D2B8\C5D0 \B300\D55C \B808\C774\BE14\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\AC12 \C9D1\ACC4</strong> - \AC12 \C5F4\C744 \D45C\C2DC\D558\AC70\B098 \C9D1\ACC4\D558\B294 \BC29\BC95<br>'),
unistr('      &nbsp;&nbsp;&nbsp;[\C5F4 \AC12, \D569\ACC4, \AC1C\C218]\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\AC12 \C5F4</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \D45C\C2DC\B41C \CC28\D2B8 \AC12\C744 \ACC4\C0B0\D558\B294 \B370 \C0AC\C6A9\D560 \C22B\C790 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282112095944870751)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<h3>\C608\C81C</h3>'),
unistr('<p>\B2E4\C591\D55C <strong>\C694\C57D</strong> \C720\D615\C744 \D65C\C6A9\D558\B294 \BC29\BC95\C5D0 \B300\D55C \C608\C81C\B97C \AC80\D1A0\D569\B2C8\B2E4.</p>'),
unistr('<p><strong>\C608\C81C 1:</strong> \AC01 \C0AC\C6D0\C5D0 \B300\D55C \AD00\B9AC\C790\C758 \C0AC\C6D0 \BC88\D638\AC00 \B098\C640 \C788\B294 \C0AC\C6D0\C5D0 \B300\D55C \CC28\D2B8\B97C \D45C\C2DC\D569\B2C8\B2E4.'),
'<code><ul>',
unistr('  <li>\D14C\C774\BE14 \B610\B294 \BDF0 - EMP\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li>\B808\C774\BE14 \C5F4 - ENAME\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li>\C694\C57D - <u><strong>\C5F4 \AC12</strong></u>\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li>\AC12 \C5F4 - MGR\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>\C608\C81C 2:</strong> \AC01 \C9C1\BB34\C5D0 \B300\D55C \CD1D \C6D4\AE09\C774 \B098\C640 \C788\B294 \C9C1\C6D0\C5D0 \B300\D55C \CC28\D2B8\B97C \D45C\C2DC\D569\B2C8\B2E4.'),
'<code><ul>',
unistr('  <li>\D14C\C774\BE14 \B610\B294 \BDF0 - EMP\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li>\B808\C774\BE14 \C5F4 - JOB\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li>\C694\C57D - <u><strong>\D569\ACC4</strong></u>\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li>\AC12 \C5F4 - SAL\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>\C608\C81C 3:</strong> \AC01 \BD80\C11C\C758 \C9C1\C6D0 \C218\AC00 \B098\C640 \C788\B294 \C9C1\C6D0\C5D0 \B300\D55C \CC28\D2B8\B97C \D45C\C2DC\D569\B2C8\B2E4.'),
'<code><ul>',
unistr('  <li>\D14C\C774\BE14 \B610\B294 \BDF0 - EMP\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li>\B808\C774\BE14 \C5F4 - DEPTNO\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li>\C694\C57D - <u><strong>\AC1C\C218</strong></u>\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li>\AC12 \C5F4 - EMPNO\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
'</ul></code>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281248166994870210)
,p_name=>'CA.CLIENT.ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\D074\B77C\C774\C5B8\D2B8 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282165919056870784)
,p_name=>'CA.CLOSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EB\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280876095122869962)
,p_name=>'CA.CLOSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\ACB0\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282163997101870783)
,p_name=>'CA.COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282139810941870768)
,p_name=>'CA.COLUMN.1'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282139914960870768)
,p_name=>'CA.COLUMN.2'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282127288572870760)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \BCC4\CE6D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282159763485870780)
,p_name=>'CA.COMMENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282124914482870759)
,p_name=>'CA.COMPONENT.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131\C694\C18C \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282129787673870762)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \AD6C\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282120160606870756)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\C591 \AD6C\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282120290530870756)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C758 \BAA8\C591\C740 \D14C\B9C8 \C2A4\D0C0\C77C\C5D0\C11C \C815\C758\B429\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282123535603870758)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131 \C635\C158\C744 \C5C5\B370\C774\D2B8\D588\C2B5\B2C8\B2E4. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282105418726870747)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131 \C635\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282103796062870746)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AE30\B2A5 \C0AC\C6A9 \B610\B294 \C0AC\C6A9 \C548\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282105538384870747)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\AC00 \C560\D50C\B9AC\CF00\C774\C158 \B0B4 \D2B9\C815 \AE30\B2A5\C744 \C0AC\C6A9 \B610\B294 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\D560 \C218 \C788\B3C4\B85D \D569\B2C8\B2E4. \C774 \AE30\B2A5\C740 \C77C\BC18 \C0AC\C6A9\C790\AC00 \C0AC\C6A9\D558\AE30 \C804 \CD94\AC00 \AC1C\BC1C \C791\C5C5\C774 \D544\C694\D55C \AE30\B2A5\C744 \C120\D0DD\D558\B294 \ACBD\C6B0 \C720\C6A9\D569\B2C8\B2E4.<br>'),
unistr('\C774 \AE30\B2A5\C740 \C560\D50C\B9AC\CF00\C774\C158 \D2B9\C815 \AE30\B2A5\C73C\B85C \D655\C7A5\B420 \C218\B3C4 \C788\C2B5\B2C8\B2E4. \AC1C\BC1C\C790\AC00 \CD94\AC00 \BE4C\B4DC \C635\C158\C744 \C815\C758\D558\C5EC \C560\D50C\B9AC\CF00\C774\C158 \C804\CCB4\C5D0\C11C \D2B9\C815 \AE30\B2A5\ACFC \C5F0\AD00\C2DC\D0A4\B294 \ACBD\C6B0 \AD00\B9AC\C790\C6A9 \AD6C\C131 \C124\C815\C5D0 \CD94\AC00\D560 \C218 \C788\C2B5\B2C8\B2E4. \C608\B97C \B4E4\C5B4, Customer Tracker App \B0B4\C5D0\C11C \AD00\B9AC\C790\B294 \C5F0\B77D\CC98, \B370\C774\D130 \B85C\B529, \C9C0\C5ED \B4F1\ACFC \AC19\C740 \AE30\B2A5\C744 \C124\C815\D558\AC70\B098 \D574\C81C\D560 \C218 \C788\C2B5\B2C8\B2E4.'),
'</p>',
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.'),
'<ul>',
unistr('<li>\C560\D50C\B9AC\CF00\C774\C158 \AE30\B2A5\C744 \C0AC\C6A9 \BC0F \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\D560 \C218 \C788\B3C4\B85D \D5C8\C6A9</li>'),
unistr('<li>\AC1C\BC1C\B9C8\B2E4 \C120\D0DD\C801\C778 \AE30\B2A5\C744 \D5C8\C6A9\D560 \C218 \C788\B294 \AE30\B2A5 \C0AC\C6A9</li>'),
unistr('<li>\AD00\B828 \C560\D50C\B9AC\CF00\C774\C158 \C124\C815\C758 \ADF8\B8F9\D654 \C9C0\C6D0</li>'),
unistr('<li>\C560\D50C\B9AC\CF00\C774\C158 \AC1C\BC1C\C790\AC00 \BE4C\B4DC \C635\C158\C744 \C0AC\C6A9\D558\C5EC \AD6C\C131\C694\C18C\B97C \C81C\C5B4\D560 \C218 \C788\B3C4\B85D \D568</li>'),
unistr('<li>\AD00\B9AC \D398\C774\C9C0\C5D0\C11C \C0AC\C6A9 \AC00\B2A5</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281243029221870206)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\C11C \C774\B984 \C811\C18D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281243177438870206)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C811\C18D \C778\C99D\C11C \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281973044328870667)
,p_name=>'CA.CONTEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CEE8\D14D\C2A4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282130212966870762)
,p_name=>'CA.CONTRIBUTOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\ACF5\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281250097298870211)
,p_name=>'CA.CPU.USED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\B41C CPU')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282138755364870767)
,p_name=>'CA.CREATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282143816874870771)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282141406873870769)
,p_name=>'CA.CREATE.APP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282142535273870770)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \ACC4\C0B0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282141870817870769)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C544\C774\CF58 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282142426067870770)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D56D\BAA9 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282142603861870770)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D504\B85C\C138\C2A4 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281984097922870673)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C124\C815 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282149896538870774)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281294839867870239)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \B864 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282142086597870769)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD8C\D55C \BD80\C5EC \CCB4\ACC4 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282142863365870770)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE48 \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282141937306870769)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE4C\B4DC \C635\C158 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282143236133870770)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EC\B825 \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282156120119870778)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE74\B4DC \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282143038853870770)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282143546074870770)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D074\B798\C2DD \BCF4\ACE0\C11C \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282143104537870770)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C2DC\BCF4\B4DC \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282141383334870769)
,p_name=>'CA.CREATE.END'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\BB34\B9AC \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282163427883870783)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D328\C2EF\C774 \C9C0\C815\B41C \AC80\C0C9 \D398\C774\C9C0\B97C \C0DD\C131\D558\B294 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282144165044870771)
,p_name=>'CA.CREATE.FEATURES'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5 \C0DD\C131 \C911')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282160767906870781)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130\B9C1\B41C \CF58\D150\CE20 \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282142985518870770)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282141545882870769)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C5ED \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282143723297870770)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\D648 \D398\C774\C9C0 \D0D0\C0C9 \BAA9\B85D \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282143629115870770)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \ADF8\B9AC\B4DC \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282143405409870770)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \BCF4\ACE0\C11C \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282149550290870774)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \B514\D14C\C77C \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282142294050870770)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0D0\C0C9 \D45C\C2DC\C904 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282145421614870771)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \ADF8\B8F9 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282144015214870771)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\D658 \C218\D589 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282143967773870771)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \B300\D55C \BCC0\D658 \C218\D589 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282143318118870770)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \BC0F \D3FC \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282149723261870774)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCAD\C0AC\C9C4 \C800\C7A5 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282142360558870770)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\B85C\AC00\AE30 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282142735952870770)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C778\C778 \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282141277971870769)
,p_name=>'CA.CREATE.START'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C791')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282141621612870769)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C6D0 \AC1D\CCB4 \C2A4\D06C\B9BD\D2B8 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282142114059870770)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14D\C2A4\D2B8 \BA54\C2DC\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282156267210870778)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0C0\C784\B77C\C778 \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282163699344870783)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\BC95\C0AC \D398\C774\C9C0 \C0DD\C131 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282122877425870758)
,p_name=>'CA.CREATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282122906667870758)
,p_name=>'CA.CREATED.BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282111303718870751)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131 \C911 ...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281243732699870207)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\C11C \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281249979301870211)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\C11C \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282123490910870758)
,p_name=>'CA.CURRENT.STATUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \C0C1\D0DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282144454991870771)
,p_name=>'CA.CUSTOM.QRY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758 \C9C8\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281341619771870269)
,p_name=>'CA.CUSTOM.THEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758 \D14C\B9C8 \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281341751037870270)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\BC94\C6A9 \D14C\B9C8 \B300\C2E0 \C0AC\C6A9\C790\C815\C758 \D14C\B9C8\B97C \C0AC\C6A9\D558\B3C4\B85D \B9C8\BC95\C0AC\B97C \C804\D658\D569\B2C8\B2E4.</p>'),
'',
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \C791\C5C5\C601\C5ED \D14C\B9C8\B97C \C120\D0DD\D569\B2C8\B2E4. \D14C\B9C8\AC00 \D14C\B9C8 \C2A4\D0C0\C77C\C744 \C9C0\C6D0\D558\B294 \ACBD\C6B0 \C2A4\D0C0\C77C\B3C4 \C120\D0DD\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281010845206870050)
,p_name=>'CA.CUSTOM_THEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758 \D14C\B9C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282145030673870771)
,p_name=>'CA.DASHBOARD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C2DC\BCF4\B4DC \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281971455907870666)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282145103408870771)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C5EC\B7EC \AC1C\C758 \CC28\D2B8\B85C \AD6C\C131\B41C \B300\C2DC\BCF4\B4DC \D398\C774\C9C0\B97C \C0DD\C131\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D398\C774\C9C0 \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C758 \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'  </ul>',
'</ul>',
'&nbsp;<br>',
unistr('<p>\AC01 \CC28\D2B8(\CC28\D2B8 1, \CC28\D2B8 2, \CC28\D2B8 3 \BC0F \CC28\D2B8 4)\B294 \CC28\D2B8 \C720\D615 \AE30\BCF8\AC12\C774 \B2E4\B974\AC8C \C124\C815\B418\BA70 <em>\C0D8\D50C \B370\C774\D130</em>\B97C \AE30\BC18\C73C\B85C \D569\B2C8\B2E4. '),
unistr('  \B530\B77C\C11C \C774 \D398\C774\C9C0\B97C \CD94\AC00\D558\AE30 \C704\D574 \B2E4\B978 \C138\BD80\C815\BCF4\B97C \C785\B825\D560 \D544\C694\AC00 \C5C6\C2B5\B2C8\B2E4.'),
unistr('  \D558\C9C0\B9CC \ACE0\C720 \AC12\C744 \C120\D0DD\D558\C5EC \AE30\BCF8\AC12\C744 \BC14\AFB8\B294 \BC29\C2DD\C73C\B85C \AC01 \CC28\D2B8\B97C \C0AC\C6A9\C790\AC00 \C815\C758\D560 \C218 \C788\C2B5\B2C8\B2E4.<br>'),
unistr('  \CC28\D2B8\B97C \C0AC\C6A9\C790\C815\C758\D558\B824\BA74 \B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\CC28\D2B8 \C774\B984</strong>(\D544\C218) - \CC28\D2B8\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\CC28\D2B8 \C720\D615</strong> - \D45C\C2DC\D560 \CC28\D2B8 \C720\D615[<strong>\C601\C5ED</strong>, <strong>\B9C9\B300</strong>, <strong>\AEBE\C740\C120\D615</strong>, <strong>\D30C\C774</strong>]\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D14C\C774\BE14 \B610\B294 \BDF0</strong>(\D544\C218) - \CC28\D2B8\C5D0 \B300\D55C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\B808\C774\BE14 \C5F4</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \CC28\D2B8\C5D0 \B300\D55C \B808\C774\BE14\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\AC12 \C9D1\ACC4</strong> - \AC12 \C5F4\C744 \D45C\C2DC\D558\AC70\B098 \C9D1\ACC4\D558\B294 \BC29\BC95<br>'),
unistr('      &nbsp;&nbsp;&nbsp;[\C5F4 \AC12, \D569\ACC4, \AC1C\C218]\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\AC12 \C5F4</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \D45C\C2DC\B41C \CC28\D2B8 \AC12\C744 \ACC4\C0B0\D558\B294 \B370 \C0AC\C6A9\D560 \C22B\C790 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282156883284870778)
,p_name=>'CA.DATATYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282157928595870779)
,p_name=>'CA.DATEFORMATMASK'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0A0\C9DC \D615\C2DD \B9C8\C2A4\D06C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282124155250870759)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \C2DC\AC04\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282124221036870759)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \C2DC\AC04\B300\B97C \C5C5\B370\C774\D2B8\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282145829826870772)
,p_name=>'CA.DEFAULTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C18D\C131 \AE30\BCF8\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282146175609870772)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 JSON \BB38\C11C\B294 \BCF4\ACE0\C11C \BC0F \D3FC \C5F4 \C774\B984 \C0DD\C131, \D615\C2DD \B9C8\C2A4\D06C \B4F1\C5D0 \B300\D574 \C138\BD84\D654\B41C \C81C\C5B4\B97C \D5C8\C6A9\D569\B2C8\B2E4. \AC12 \BAA9\B85D \BC0F \AE30\D0C0 \ACF5\C720 \AD6C\C131\C694\C18C\B97C \C815\C758\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282163200195870782)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12 \BAA9\B85D \C18D\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282163356204870782)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>LOV(\AC12 \BAA9\B85D) \C18D\C131\C744 \CD94\AC00\D569\B2C8\B2E4. LOV\B294 \D14C\C774\BE14 \C5F4 \C815\C758\C5D0 \C0AC\C6A9\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.'),
'  <ul>',
unistr('    <li><strong>\C774\B984</strong>(\D544\C218) - \AC12 \BAA9\B85D\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\C720\D615</strong> - \AC12 \BAA9\B85D \C720\D615[\AD6C\C870\D654\B428, \B3D9\C801, \C815\C801]\C744 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('      \C720\D615\C774 <u>\AD6C\C870\D654\B428</u>\C778 \ACBD\C6B0 - '),
'      <ul>',
unistr('          <li><strong>\D14C\C774\BE14</strong>(\D544\C218) - \AC12 \BAA9\B85D\C758 \AE30\BC18\C73C\B85C \C0AC\C6A9\D560 \D14C\C774\BE14 \B610\B294 \BDF0\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('          <li><strong>\D45C\C2DC \C5F4</strong>(\D544\C218) - \C77C\BC18 \C0AC\C6A9\C790\C5D0\AC8C \D45C\C2DC\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('          <li><strong>\D0A4 \C5F4</strong>(\D544\C218) - \BC18\D658\D560 \C5F4 \AC12\C744 \C120\D0DD\D569\B2C8\B2E4. \C77C\BC18\C801\C73C\B85C \D14C\C774\BE14\C5D0 \B300\D55C \AE30\BCF8 \D0A4\C785\B2C8\B2E4.</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      \C720\D615\C774 <u>\B3D9\C801</u>\C778 \ACBD\C6B0 -'),
'      <ul>',
unistr('          <li><strong>SQL \C9C8\C758</strong>(\D544\C218) - \B450 \AC1C\C758 \AC12(\D45C\C2DC \AC12\ACFC \BC18\D658 \AC12)\C744 \BC18\D658\D558\B294 \C801\D569\D55C SQL Select \BB38\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      \C720\D615\C774 <u>\C815\C801</u>\C778 \ACBD\C6B0 -'),
'      <ul>',
unistr('          <li><strong>\C815\C801 \AC12 \BAA9\B85D</strong>(\D544\C218) - \B2E4\C74C \D615\C2DD\C758 \C801\D569\D55C \C815\C801 \BAA9\B85D\C744 \C785\B825\D569\B2C8\B2E4.'),
'          <ul>',
unistr('            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>\C785\B825\B41C \C21C\C11C\B300\B85C \BAA9\B85D\C774 \D45C\C2DC\B429\B2C8\B2E4.</li>'),
unistr('            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>\BB38\C790\C21C\C73C\B85C \BAA9\B85D\C774 \C815\B82C\B429\B2C8\B2E4.</li>'),
unistr('            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>\D45C\C2DC \AC12\ACFC \BC18\D658 \AC12\C774 \B3D9\C77C\D569\B2C8\B2E4.</li>'),
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282164494930870783)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C18D\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282164588845870783)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\BAA8\B4E0 \BCF4\ACE0\C11C\C5D0 \B300\D55C \C18D\C131\C744 \D3B8\C9D1\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.'),
'  <ul>',
unistr('    <li><strong>\D398\C774\C9C0\B2F9 \D589</strong> - \AE30\BCF8\C801\C73C\B85C \D45C\C2DC\D560 \BCF4\ACE0\C11C \D589 \C218\B97C \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\D398\C774\C9C0 \B9E4\AE40 \BC29\BC95</strong> - \BCF4\ACE0\C11C \D398\C774\C9C0 \B9E4\AE40 \D45C\C2DC \BC29\BC95\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\C22B\C790 \D615\C2DD \B9C8\C2A4\D06C</strong> - \C22B\C790 \C5F4 \BC0F \D56D\BAA9\C5D0 \C801\C6A9\D560 \D615\C2DD \B9C8\C2A4\D06C\B97C \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\B0A0\C9DC \D615\C2DD \B9C8\C2A4\D06C</strong> - \B0A0\C9DC \C5F4 \BC0F \D56D\BAA9\C5D0 \C801\C6A9\D560 \D615\C2DD \B9C8\C2A4\D06C\B97C \C785\B825\D569\B2C8\B2E4.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282164233932870783)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C18D\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282164015105870783)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C5F4 \C18D\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282164111838870783)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C120\D0DD\B41C \D14C\C774\BE14 \C5F4\C5D0 \B300\D55C \C18D\C131\C744 \D3B8\C9D1\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.'),
'  <ul>',
unistr('    <li><strong>\D14C\C774\BE14</strong>(\D45C\C2DC \C804\C6A9) - \C5F0\AD00\B41C \D14C\C774\BE14\C785\B2C8\B2E4.</li>'),
unistr('    <li><strong>\C5F4</strong>(\D45C\C2DC \C804\C6A9) - \C18D\C131\C774 \C815\C758\B41C \C5F4\C785\B2C8\B2E4.</li>'),
unistr('    <li><strong>\B808\C774\BE14</strong> - \BCF4\ACE0\C11C \BA38\B9AC\AE00 \BC0F \D3FC \B808\C774\BE14\C5D0 \C0AC\C6A9\D560 \B808\C774\BE14\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\D3FC \CF58\D2B8\B864</strong> - \D3FC\C5D0 \C0AC\C6A9\D560 \D56D\BAA9 \C720\D615\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\AC12 \BAA9\B85D</strong> - \C801\C808\D55C \ACBD\C6B0 \C0AC\C6A9\C790\C5D0\AC8C \CE5C\C219\D55C \C774\B984\C744 \D45C\C2DC\D558\B294 \B370 \C0AC\C6A9\D560 \AE30\C874 \AC12 \BAA9\B85D\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\D615\C2DD \B9C8\C2A4\D06C</strong> - \C5F4 \C720\D615(\D14D\C2A4\D2B8, \C22B\C790, \B0A0\C9DC \B4F1)\C744 \AE30\BC18\C73C\B85C \C801\C808\D55C \D615\C2DD \B9C8\C2A4\D06C\B97C \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\C815\C801 \AE30\BCF8\AC12</strong> - \C5F4\C5D0 \B300\D55C \D14D\C2A4\D2B8 \AE30\BCF8\AC12\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\D3FC\C5D0 \D3EC\D568</strong> - \D3FC\C5D0 \C5F4\C744 \D3EC\D568\D574\C57C \D558\B294 \ACBD\C6B0 [\C608]\B97C \B204\B985\B2C8\B2E4.</li>'),
unistr('    <li><strong>\BCF4\ACE0\C11C\C5D0 \D3EC\D568</strong> - \BCF4\ACE0\C11C\C5D0 \C5F4\C744 \D3EC\D568\D574\C57C \D558\B294 \ACBD\C6B0 [\C608]\B97C \B204\B985\B2C8\B2E4.</li>'),
unistr('    <li><strong>\D544\C218</strong> - \D3FC\C758 \C774 \C5F4\C5D0 \B370\C774\D130\B97C \C785\B825\D574\C57C \D558\B294 \ACBD\C6B0 [\C608]\B97C \B204\B985\B2C8\B2E4.</li>'),
unistr('    <li><strong>\B3C4\C6C0\B9D0</strong> - \D56D\BAA9 \B3C4\C6C0\B9D0 \C18D\C131\C5D0 \CD94\AC00\B418\B294 \B3C4\C6C0\B9D0 \D14D\C2A4\D2B8\B97C \C785\B825\D569\B2C8\B2E4.</li>'),
'  </ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282164319969870783)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C120\D0DD\B41C \D14C\C774\BE14\C5D0 \B300\D55C \C18D\C131\C744 \D3B8\C9D1\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.'),
'  <ul>',
unistr('    <li><strong>\D14C\C774\BE14</strong>(\D45C\C2DC \C804\C6A9) - \C5F0\AD00\B41C \D14C\C774\BE14\C785\B2C8\B2E4.</li>'),
unistr('    <li><strong>\B808\C774\BE14, \B2E8\C218</strong>(\D544\C218) - \D3FC \D398\C774\C9C0\C5D0 \C0AC\C6A9\D560 \B808\C774\BE14\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\B808\C774\BE14, \BCF5\C218</strong>(\D544\C218) - \BCF4\ACE0\C11C \BA38\B9AC\AE00 \BC0F \D398\C774\C9C0 \C774\B984\C5D0 \C0AC\C6A9\D560 \B808\C774\BE14\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\AE30\BCF8 \D45C\C2DC \C5F4</strong> - \CE74\B4DC \C601\C5ED \B4F1\C5D0 \D45C\C2DC\D560 \CCAB\BC88\C9F8 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\BCF4\C870 \D45C\C2DC \C5F4</strong> - \CE74\B4DC \C601\C5ED \B4F1\C5D0 \D45C\C2DC\D560 \B450\BC88\C9F8 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\AE30\BCF8 \D0A4 \C5F4</strong> - \D14C\C774\BE14\C5D0 \B300\D55C \ACE0\C720 \AE30\BCF8 \D0A4 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\C124\BA85</strong> - \D14C\C774\BE14\C5D0 \B300\D55C \C124\BA85\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281243553195870207)
,p_name=>'CA.DEFERRED.DROP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C5F0\B41C \C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282158570624870780)
,p_name=>'CA.DEFINITION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282141199166870769)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\CE58 \C81C\AC70\AC00 \C644\B8CC\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282121428011870757)
,p_name=>'CA.DELETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282140785282870769)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C0AD\C81C \C791\C5C5\C744 \C218\D589\D558\ACA0\C2B5\B2C8\AE4C?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282107023311870748)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0\B97C \C0AD\C81C\D558\ACA0\C2B5\B2C8\AE4C?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282131254448870763)
,p_name=>'CA.DELETE.PHOTO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C9C4 \C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282122168969870757)
,p_name=>'CA.DESCRIPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282139345092870768)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C2A4\D06C\D1B1 \D0D0\C0C9 \D45C\C2DC\C904')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282139238988870768)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C2A4\D06C\D1B1 \D0D0\C0C9 \BA54\B274')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282120473567870756)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C2A4\D06C\D1B1 \D14C\B9C8 \C2A4\D0C0\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282120563368870756)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \D14C\B9C8 \C2A4\D0C0\C77C\C740 \BAA8\B4E0 \C0AC\C6A9\C790\C5D0\AC8C \C801\C6A9\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281243914827870207)
,p_name=>'CA.DESTINATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281244046817870207)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1 \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281010978964870050)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C0C1\C790 \B2E8\CD94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282135775775870766)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C791\C5C5 \D560\B2F9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282155385772870778)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \D504\B808\C784\C6CC\D06C\C5D0\C11C \C804\C790\BA54\C77C\C744 \C804\C1A1\D574\C57C \D560\C9C0 \C5EC\BD80\B97C \ACB0\C815\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282121901447870757)
,p_name=>'CA.DISPLAY.FROM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC \C2DC\C791')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282121898334870757)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC \C21C\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282122087887870757)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC \C885\B8CC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282157087656870779)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282125552285870759)
,p_name=>'CA.DISTINCT .USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\BCC4 \C0AC\C6A9\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282138802538870767)
,p_name=>'CA.DOWNLOAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C6B4\B85C\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282145727400870772)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B04C\C5B4\C11C \D398\C774\C9C0 \C7AC\C815\B82C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281032291689870065)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr('  <li><strong>\B4DC\B9B4\B2E4\C6B4 \B9C1\D06C</strong> - \B4DC\B9B4\B2E4\C6B4 \B9C1\D06C \C815\C758 \C18D\C131\C744 \D45C\C2DC\D558\B824\BA74 \D655\C7A5\D569\B2C8\B2E4.'),
'&nbsp;<br>',
unistr('    <em><strong>\CC38\ACE0:</strong> \B4DC\B9B4\B2E4\C6B4 \B9C1\D06C\B294 \D604\C7AC \D398\C774\C9C0\AC00 \D14C\C774\BE14 \B610\B294 \BDF0\B97C \AE30\BC18\C73C\B85C \D558\BA70 \D604\C7AC \D398\C774\C9C0\C758 \BCF4\ACE0\C11C \C720\D615\C774 \B300\D654\C2DD \BCF4\ACE0\C11C\C774\ACE0 \C0AC\C6A9\C790\AC00 \B300\D654\C2DD \BCF4\ACE0\C11C \B610\B294 \B9C8\C2A4\D130 \B514\D14C\C77C \D398\C774\C9C0\B97C \C815\C758\D55C \ACBD\C6B0\C5D0\B9CC \D45C\C2DC\B429\B2C8\B2E4.</em>'),
'  <ul>',
unistr('    <li><strong>\B9C1\D06C \C5F4</strong> - \BCF4\ACE0\C11C\C5D0\C11C \B9C1\D06C \C5F4\B85C \BCC0\ACBD\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\B9C1\D06C \D0A4</strong> - \B9C1\D06C\D558\B824\B294 \D398\C774\C9C0\C5D0\C11C \D2B9\C815 \B808\CF54\B4DC\B97C \C2DD\BCC4\D558\B294 \B370 \C0AC\C6A9\B418\B294 \B9C1\D06C \D0A4(\C678\B798 \D0A4) \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\B9C1\D06C \B300\C0C1 \D398\C774\C9C0</strong> - \B9C1\D06C\AC00 \C774\B3D9\D560 \BCF4\ACE0\C11C \B610\B294 \D3FC \D398\C774\C9C0\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\B300\C0C1 \D0A4</strong> - \B9C1\D06C\AC00 \C774\B3D9\D560 \BCF4\ACE0\C11C \D398\C774\C9C0\AC00 \AE30\BC18\C73C\B85C \D558\B294 \D14C\C774\BE14\C5D0\C11C \B300\C0C1 \D0A4(\AE30\BCF8 \D0A4) \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.'),
'  </ul>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282124643946870759)
,p_name=>'CA.ELAPSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACBD\ACFC \C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282107294794870748)
,p_name=>'CA.EMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \D504\B808\C784\C6CC\D06C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282154958249870777)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C8FC\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282164986259870783)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282107159058870748)
,p_name=>'CA.EMAIL.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C\C744 \AD6C\C131\D558\ACE0 \BCF4\B0BC \C218 \C788\B294 \AE30\B2A5 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282107381562870748)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C804\C790\BA54\C77C\C744 \C804\C1A1\D560 \C218 \C788\B294 \AE30\B2A5\C744 \D3EC\D568\D569\B2C8\B2E4. \C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8 \C608\C81C\B97C \C0AC\C6A9\D558\C5EC \C804\BB38\AC00 \C218\C900\C758 \C804\C790\BA54\C77C\C744 \C0AC\C6A9\C790\C5D0\AC8C \C804\C1A1\D560 \C218 \C788\C2B5\B2C8\B2E4. \C804\C1A1\B41C \C804\C790\BA54\C77C\C740 \B85C\AE45\B418\BBC0\B85C \AD00\B9AC\C790\AC00 \C804\C790\BA54\C77C \C791\C5C5\C744 \CD94\C801\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.'),
'<ul>',
unistr('<li>\D655\C7A5 \AC00\B2A5\D55C HTML \C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8 \C2DC\C2A4\D15C</li>'),
unistr('<li>APEX \D328\D0A4\C9C0\B97C \D1B5\D574 \BA54\C77C\C744 \C804\C1A1\D558\AE30 \C704\D55C PL/SQL \D328\D0A4\C9C0</li>'),
unistr('<li>\C804\C790\BA54\C77C \C791\C5C5 \BC0F \C0C1\D0DC \B85C\AE45</li>'),
unistr('<li>\D15C\D50C\B9AC\D2B8 \AD00\B9AC\B97C \C704\D55C \AD00\B9AC UI</li>'),
unistr('<li>\C804\C790\BA54\C77C \B85C\ADF8 \D655\C778\C744 \C704\D55C \AD00\B9AC UI</li>'),
unistr('<li>\C804\C790\BA54\C77C \C804\C1A1\C744 \C704\D55C \AD00\B9AC UI</li>'),
'</ul>',
'</p>',
unistr('<p><em>\CC38\ACE0: \C774 \AE30\B2A5\C740 \D53C\B4DC\BC31\C774 \C120\D0DD\B41C \ACBD\C6B0 \C0AC\C6A9\C73C\B85C \C124\C815\B429\B2C8\B2E4.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282160600881870781)
,p_name=>'CA.EMAIL.FROM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \BCF4\B0B8 \C0AC\B78C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282134720593870765)
,p_name=>'CA.EMAIL.LOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \B85C\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282165590442870784)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C124\C815 \C138\BD80\C815\BCF4\AC00 \D544\C694\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282165094356870784)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\B2F9 \BCF4\B0B8 \C0AC\B78C \C8FC\C18C\B294 \C801\D569\D55C \C804\C790\BA54\C77C\C774 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282156558229870778)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\B2F9 \BCF4\B0B8 \C0AC\B78C \C8FC\C18C\B294 \C801\D569\D55C \C804\C790\BA54\C77C\C774 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282155741056870778)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C\C774 \CC98\B9AC\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281110974180870119)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \BCF4\ACE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281296785316870241)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\AE30\C5F4\C5D0 \C788\B294 \C804\C1A1 \C608\C815 \C804\C790\BA54\C77C\ACFC \C774\BBF8 \C804\C1A1\B41C \C804\C790\BA54\C77C\C5D0 \B300\D55C \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282135692114870766)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282136093146870766)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C124\C815\C744 \C5C5\B370\C774\D2B8\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282161067432870781)
,p_name=>'CA.EMAIL.STATUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C0C1\D0DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282136194715870766)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8 \C138\BD80\C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281647867740870469)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_language=>'ko'
,p_message_text=>unistr('#SERVICE_NAME#\C5D0 \B300\D55C \C77C\C815\C774 \C7A1\D78C \C6B4\C6A9\C911\B2E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281349212545870275)
,p_name=>'CA.EMAIL2'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282134633899870765)
,p_name=>'CA.EMAILS.SENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C1A1\B41C \C804\C790\BA54\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282165120883870784)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCA8\BD80 \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281249047652870210)
,p_name=>'CA.ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C73C\B85C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281246240340870208)
,p_name=>'CA.END.DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\B8CC \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282136713205870766)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \B4A4 \CF58\D150\CE20')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282152882023870776)
,p_name=>'CA.ENTER.USERNAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5EC\AE30\C5D0 \C0AC\C6A9\C790 \C774\B984 \C785\B825')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282125220948870759)
,p_name=>'CA.ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282127523751870761)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958 \C5ED\CD94\C801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282127461686870761)
,p_name=>'CA.ERROR.CODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958 \CF54\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282126760033870760)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958 \BA54\C2DC\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281250743915870211)
,p_name=>'CA.ERROR.NUMBER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958 \BC88\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281249709161870210)
,p_name=>'CA.ERRORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281246655180870209)
,p_name=>'CA.EVENT.CONDITION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 \C870\AC74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281246783104870209)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 \B300\AE30\C5F4 \C5D0\C774\C804\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281246857491870209)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 \B300\AE30\C5F4 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281246999591870209)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 \B300\AE30\C5F4 \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281246549678870208)
,p_name=>'CA.EVENT.RULE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 \ADDC\CE59')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282153102992870776)
,p_name=>'CA.EXCEPTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608\C678\C0AC\D56D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282166088638870784)
,p_name=>'CA.EXPERIENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACBD\D5D8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281248722789870210)
,p_name=>'CA.FAILURE.COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D328 \D69F\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282123290428870758)
,p_name=>'CA.FEATURE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281903219218870624)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BC84\C804')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281903373502870624)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281395222494870308)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0 \C0AC\C6A9\C790 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281395082430870307)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \B2E8\ACC4\B85C \C774\B3D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281395180584870307)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\C74C \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281394913791870307)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C9C0\B9C9 \AD00\B9AC\C790\B97C \BCC0\ACBD\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281902988680870624)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C9C0\B9C9 \C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281394747967870307)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C744 \CC3E\C744 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281903189660870624)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C720')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281395344590870308)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D558\B098 \C774\C0C1\C758 \D53C\B4DC\BC31 \D544\C694')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281395672444870308)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C77C ID \AC00\C838\C624\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281394277314870307)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8 \C2A4\D0C0\C77C \C800\C7A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281394335804870307)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\BC18 \C0AC\C6A9\C790 \C2A4\D0C0\C77C \D658\ACBD\C124\C815 \C800\C7A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281903073267870624)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282111404301870751)
,p_name=>'CA.FEATURES'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282111512336870751)
,p_name=>'CA.FEATURES.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\B2A5\C740 \C560\D50C\B9AC\CF00\C774\C158 \B808\BCA8 \AE30\B2A5\C744 \C81C\ACF5\D558\BA70 \C77C\BC18\C801\C73C\B85C \C560\D50C\B9AC\CF00\C774\C158\B2F9 \D55C \BC88 \CD94\AC00\B429\B2C8\B2E4. \C560\D50C\B9AC\CF00\C774\C158\ACFC \D568\AED8 \D3EC\D568\D560 \AE30\B2A5\C744 \C120\D0DD\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282105324304870747)
,p_name=>'CA.FEEDBACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\B4DC\BC31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282103358174870746)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\AC00 \D53C\B4DC\BC31\C744 \C81C\ACF5\D558\B3C4\B85D \D5C8\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282105292836870747)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C77C\BC18 \C0AC\C6A9\C790\AC00 \C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790 \BC0F \AC1C\BC1C\C790\C5D0\AC8C \C77C\BC18 \C758\ACAC\C744 \AC8C\C2DC\D560 \C218 \C788\B294 \BC29\C2DD\C744 \C81C\ACF5\D569\B2C8\B2E4. \C774\B7EC\D55C \AC8C\C2DC\BB3C\C5D0\B294 \C77C\BC18 \C0AC\C6A9\C790\AC00 \D53C\B4DC\BC31\C744 \BCF4\B0B8 \C704\CE58\B97C \D655\C778\D558\B294 \B370 \B3C4\C6C0\C774 \B418\B294 \C720\C6A9\D55C \C138\C158 \C0C1\D0DC \C815\BCF4\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4. \C774\C640 \AC19\C740 \C190\C26C\C6B4 \D53C\B4DC\BC31 \B8E8\D504\B97C \C81C\ACF5\D558\BA74 \C0AC\C6A9\C790 \CEE4\BBA4\B2C8\D2F0\C640 \C560\D50C\B9AC\CF00\C774\C158 \C18C\C720\C790 \AC04 \D1B5\C2E0\C744 \D5A5\C0C1\C2DC\CF1C \C77C\BC18 \C0AC\C6A9\C790 \B9CC\C871\B3C4\B97C \D06C\AC8C \AC1C\C120\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.'),
'<ul>',
unistr('<li>\C77C\BC18 \C0AC\C6A9\C790\AC00 \D0D0\C0C9 \D45C\C2DC\C904 \C544\C774\CF58\C744 \B20C\B7EC \D53C\B4DC\BC31\C744 \B0A8\AE38 \C218 \C788\B294 \AE30\B2A5</li>'),
unistr('<li>\D53C\B4DC\BC31\C744 \BCF4\ACE0 \C5C5\B370\C774\D2B8\D558\AE30 \C704\D55C \AD00\B9AC \BCF4\ACE0\C11C</li>'),
unistr('<li>\D53C\B4DC\BC31\C740 \C0AC\C6A9\C790, \B0A0\C9DC \BC0F \C2DC\AC04, \C0AC\C6A9\C790 \C5D0\C774\C804\D2B8 \C815\BCF4\B97C \CEA1\CC98\D569\B2C8\B2E4.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282166435240870784)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\B4DC\BC31 \B610\B294 \ACBD\D5D8\C744 \C81C\ACF5\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282165484836870784)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC1B\B294 \C0AC\B78C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282164864113870783)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\B4DC\BC31 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282132721564870764)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\B4DC\BC31 \C124\C815\C774 \C5C5\B370\C774\D2B8\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282165639509870784)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\B4DC\BC31 \C81C\CD9C\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281246302043870208)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C77C \AC10\C2DC \D504\B85C\ADF8\B7A8 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281246420542870208)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C77C \AC10\C2DC \D504\B85C\ADF8\B7A8 \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280901553506869977)
,p_name=>'CA.FILED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\CD9C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280901669589869977)
,p_name=>'CA.FILED.BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\CD9C\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282161197565870781)
,p_name=>'CA.FILTER.REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \D544\D130\B9C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282137100932870767)
,p_name=>'CA.FILTERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282163891088870783)
,p_name=>'CA.FINISH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C644\B8CC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282131430543870763)
,p_name=>'CA.FIRST.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281243321085870207)
,p_name=>'CA.FLAGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282112875094870752)
,p_name=>'CA.FORM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282112740849870752)
,p_name=>'CA.FORM.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C77C\BC18 \C0AC\C6A9\C790\AC00 \B370\C774\D130 \C720\C9C0\BCF4\C218\C5D0 \C0AC\C6A9\D560 \D3FC \D398\C774\C9C0\B97C \D45C\C2DC\D558\B294 \D398\C774\C9C0\B97C \C0DD\C131\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D398\C774\C9C0 \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C758 \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D14C\C774\BE14</strong>(\D544\C218) - \D3FC\C5D0 \B300\D55C \D14C\C774\BE14\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('<li><strong>\BCF4\ACE0\C11C \D3EC\D568</strong>(\D544\C218) - \BCF4\ACE0\C11C \BC0F \D3FC\C744 \C0DD\C131\D558\B824\BA74 \C774 \C635\C158\C744 \C120\D0DD\D569\B2C8\B2E4. \CCAB\BC88\C9F8 \D398\C774\C9C0\B294 \B300\D654\C2DD \BCF4\ACE0\C11C\C785\B2C8\B2E4. \AC01 \D589\C740 \C0AC\C6A9\C790\AC00 \B808\CF54\B4DC\B97C \C5C5\B370\C774\D2B8\D560 \C218 \C788\B294 \D3FC\C5D0 \B300\D55C \B9C1\D06C\B97C \C81C\ACF5\D569\B2C8\B2E4. </li>'),
'  &nbsp;<br>',
unistr('<li><strong>\ACE0\AE09</strong> - \ACE0\AE09 \C635\C158\C744 \D45C\C2DC\D558\B824\BA74 \D655\C7A5\D569\B2C8\B2E4.'),
'     <ul>',
unistr('      <li><strong>\D398\C774\C9C0 \B3C4\C6C0\B9D0</strong> - \D398\C774\C9C0\C5D0 \B300\D55C \B3C4\C6C0\B9D0 \D14D\C2A4\D2B8\C5D0 \CD94\AC00\D560 \D14D\C2A4\D2B8\B97C \C785\B825\D569\B2C8\B2E4.</li>'),
'      </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281031262168870064)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \D56D\BAA9 \C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282139057091870768)
,p_name=>'CA.FORM.ON'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \B300\D55C \D3FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282152697554870776)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\B2F9 \D3FC \C720\D615\C740 \C801\D569\D55C \C720\D615\C774 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282159007951870780)
,p_name=>'CA.FORMATMASK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D615\C2DD \B9C8\C2A4\D06C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282158028684870779)
,p_name=>'CA.FORMCONTROL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \CF58\D2B8\B864')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282122692313870758)
,p_name=>'CA.FROM'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD9C\CC98')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282135894809870766)
,p_name=>'CA.FROM.ADDRESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\B0B8 \C0AC\B78C \C8FC\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282160507804870781)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_language=>'ko'
,p_message_text=>unistr('"\BCF4\B0B8 \C0AC\B78C \C8FC\C18C" \C804\C790\BA54\C77C \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282156406418870778)
,p_name=>'CA.FROM.EMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\B0B8 \C0AC\B78C \C804\C790\BA54\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282156348839870778)
,p_name=>'CA.FROM.WHO'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\B0B8 \C0AC\B78C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281905105792870625)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \AC80\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282126182347870760)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \D398\C774\C9C0 \BDF0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282134836378870765)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\CCB4 \D15C\D50C\B9AC\D2B8 HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282157532294870779)
,p_name=>'CA.FUNCTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D568\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282105712405870747)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C5ED \AC80\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282103542213870746)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AC80\C0C9 \AE30\B2A5 \C81C\ACF5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282105679458870747)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C77C\BC18 \C0AC\C6A9\C790\AC00 \C560\D50C\B9AC\CF00\C774\C158 \B0B4 \D0A4 \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \D14D\C2A4\D2B8\B97C \AC80\C0C9\D560 \C218 \C788\C2B5\B2C8\B2E4. \ACE0\AE09 \AC80\C0C9 \D398\C774\C9C0\C5D0\B294 \C77C\BC18 \C0AC\C6A9\C790\AC00 \ACB0\ACFC\B97C \AC04\B2E8\D788 \C881\D790 \C218 \C788\B294 \D544\D130\AC00 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4.<br>'),
unistr('\C774\C640 \AC19\C740 \AC15\B825\D55C \AE30\B2A5\C744 \C0AC\C6A9\D558\B824\BA74 \C81C\ACF5\B41C \C608\C81C\B97C \AE30\BC18\C73C\B85C SQL\C744 \C815\C758\D558\B824\B294 \AC1C\BC1C \B178\B825\C774 \D544\C694\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.'),
'<ul>',
unistr('<li>\BA38\B9AC\AE00 \D45C\C2DC\C904\C5D0 \AC80\C0C9 \C544\C774\CF58 \D45C\C2DC</li>'),
unistr('<li>\CE21\BA74 \B9C9\B300 \D544\D130\AC00 \C788\B294 \C138\BD80\C815\BCF4 \AC80\C0C9 \ACB0\ACFC \D398\C774\C9C0 \D3EC\D568</li>'),
unistr('<li>\AC1C\BC1C\C790\AC00 \C571 \AC80\C0C9\C744 \C815\C758\D558\B3C4\B85D SQL\C744 \AD6C\D604\D574\C57C \D568</li>'),
unistr('<li>\ADF8\B9BC\C5D0 \B300\D55C \C0D8\D50C \B370\C774\D130 \D3EC\D568</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281248099801870209)
,p_name=>'CA.GLOBAL.UID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C5ED \ACE0\C720 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281393813490870307)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C5ED \D398\C774\C9C0 - \B370\C2A4\D06C\D1B1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281011089664870050)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC \D398\C774\C9C0\B85C \C774\B3D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282112365589870751)
,p_name=>'CA.GRID'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \ADF8\B9AC\B4DC \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282112452629870751)
,p_name=>'CA.GRID.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C2A4\D504\B808\B4DC\C2DC\D2B8\C640 \C720\C0AC\D55C \B300\D654\C2DD \ADF8\B9AC\B4DC\B85C \D45C\C2DC\B418\B294 \D398\C774\C9C0\B97C \C0DD\C131\D569\B2C8\B2E4. \D3B8\C9D1 \AC00\B2A5\D55C \ACBD\C6B0([\D3B8\C9D1 \D5C8\C6A9]\C774 \C0AC\C6A9\C73C\B85C \C124\C815\B41C \ACBD\C6B0) \C0AC\C6A9\C790\B294 \D398\C774\C9C0\C5D0\C11C \C9C1\C811 \B2E4\C911 \D589\C744 \D3B8\C9D1\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D398\C774\C9C0 \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C758 \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C9C8\C758 \C720\D615</strong> - \BCF4\ACE0\C11C \C18C\C2A4[<strong>\D14C\C774\BE14 \B610\B294 \BDF0</strong>, <strong>SQL \C9C8\C758</strong>]\B97C \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('    <strong>\D14C\C774\BE14 \B610\B294 \BDF0</strong>:'),
'    <ul>',
unistr('      <li><strong>\D14C\C774\BE14 \B610\B294 \BDF0</strong>(\D544\C218) - \ADF8\B9AC\B4DC\C5D0 \B300\D55C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
'    </ul>',
unistr('    <strong>SQL \C9C8\C758</strong>:'),
'    <ul>',
unistr('      <li><strong>SQL \C9C8\C758</strong>(\D544\C218) - \ACE0\C720 \C5F4\C744 \BC18\D658\D558\B294 \C801\D569\D55C SQL \BB38\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>\ADF8\B9AC\B4DC \C720\D615</strong> - \C0AC\C6A9\C790\AC00 \ADF8\B9AC\B4DC\C5D0\C11C \D589\C744 \D3B8\C9D1\D560 \C218 \C788\B294\C9C0 \C5EC\BD80[<strong>\D3B8\C9D1 \D5C8\C6A9</strong> \B610\B294 <strong>\C77D\AE30 \C804\C6A9</strong>]\B97C \C120\D0DD\D569\B2C8\B2E4. \D3B8\C9D1\C744 \C0AC\C6A9\C73C\B85C \C124\C815\D558\B824\BA74 <strong>\D3B8\C9D1 \D5C8\C6A9</strong>\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'  &nbsp;<br>',
unistr('  <em><strong>\ACBD\ACE0:</strong> \C9C8\C758 \C720\D615\C73C\B85C <strong>SQL \C9C8\C758</strong>, \ADF8\B9AC\B4DC \C720\D615\C73C\B85C <strong>\D3B8\C9D1 \D5C8\C6A9</strong>\C744 \C120\D0DD\D55C \C0C1\D0DC\C5D0\C11C \C9C8\C758\AC00 \D14C\C774\BE14 \B450 \AC1C \C774\C0C1\C744 \C870\C778\D558\B294 \ACBD\C6B0 \C0AC\C6A9\C790\AC00 \B808\CF54\B4DC\B97C \C5C5\B370\C774\D2B8\D558\B824\ACE0 \C2DC\B3C4\D558\BA74 \C0DD\C131\B41C \B300\D654\C2DD \ADF8\B9AC\B4DC\AC00 \C2E4\D328\D569\B2C8\B2E4.'),
unistr('\B610\D55C \ADF8\B9AC\B4DC \C720\D615\C73C\B85C <strong>\D3B8\C9D1 \D5C8\C6A9</strong>\C744 \C120\D0DD\D55C \C0C1\D0DC\C5D0\C11C \C9C8\C758(\B610\B294 \C120\D0DD\D55C \D14C\C774\BE14 \B610\B294 \BDF0)\AC00 \C5C5\B370\C774\D2B8\D560 \C218 \C5C6\B294 \BDF0\B97C \C0AC\C6A9\D558\B294 \ACBD\C6B0 \C0AC\C6A9\C790\AC00 \B808\CF54\B4DC\B97C \C5C5\B370\C774\D2B8\D558\B824\ACE0 \C2DC\B3C4\D558\BA74 \C0DD\C131\B41C \B300\D654\C2DD \ADF8\B9AC\B4DC\AC00 \C2E4\D328\D569\B2C8\B2E4.</em><br>'),
'  </li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282137664930870767)
,p_name=>'CA.HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3C4\C6C0\B9D0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282130022511870762)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 \C0AC\C6A9\C790\AC00 \C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0 \C815\C758\B41C \ACBD\C6B0 <strong>\C544\B2C8\C624</strong>\B97C \C120\D0DD\D569\B2C8\B2E4. \C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0 \C5C6\B294 \C778\C99D\B41C \C0AC\C6A9\C790\B3C4 <strong>\C608</strong>\B97C \C120\D0DD\D558\BA74 \C774 \C560\D50C\B9AC\CF00\C774\C158\C744 \C0AC\C6A9\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282123714284870758)
,p_name=>'CA.HELP.APP.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5EC\AE30\C5D0 \C785\B825\D55C \D14D\C2A4\D2B8\B294 \C560\D50C\B9AC\CF00\C774\C158 \C804\CCB4\C5D0\C11C \C0AC\C6A9\B418\BA70 \BAA8\B4E0 \D398\C774\C9C0\C5D0\C11C \C67C\CABD \C704\C5D0 \D45C\C2DC\B418\B294 \ACBD\C6B0\AC00 \AC00\C7A5 \B208\C5D0 \B755\B2C8\B2E4. \BCC0\ACBD\C0AC\D56D\C740 \AD00\B9AC\C790\AC00 \BCC0\ACBD\C744 \C218\D589\D55C \C989\C2DC \C801\C6A9\B418\C9C0\B9CC \B2E4\B978 \C0AC\C6A9\C790\B294 \C0C8 \C138\C158(\C608: \B2E4\C74C \B85C\ADF8\C778 \C2DC)\C744 \C5BB\AC8C \B418\B294 \ACBD\C6B0\C5D0\B9CC \D574\B2F9 \BCC0\ACBD\C0AC\D56D\C744 \D655\C778\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282118303911870755)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C758 \BAA8\B4E0 \D398\C774\C9C0\C5D0\C11C \D0D0\C0C9 \D45C\C2DC\C904\C5D0 \C788\B294 \D53C\B4DC\BC31 \C544\C774\CF58( <span class="fa fa-comment-o" aria-hidden="true"></span> )\C744 \B20C\B7EC \C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\C5D0 \B300\D55C \D53C\B4DC\BC31\C744 \B0A8\AE38 \C218 \C788\C2B5\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282118041204870755)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C758 \D648 \D398\C774\C9C0\C785\B2C8\B2E4. \CE74\B4DC\B97C \B20C\B7EC \C560\D50C\B9AC\CF00\C774\C158\C758 \B2E4\B978 \D398\C774\C9C0\C5D0 \C561\C138\C2A4\D558\AC70\B098 \D398\C774\C9C0 \CE21\BA74\C5D0 \C788\B294 \D0D0\C0C9 \BA54\B274\B97C \C0AC\C6A9\D558\C2ED\C2DC\C624.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282118204435870755)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C758 \D648 \D398\C774\C9C0\C785\B2C8\B2E4. \CE74\B4DC\B97C \B20C\B7EC \C560\D50C\B9AC\CF00\C774\C158\C758 \B2E4\B978 \D398\C774\C9C0\C5D0 \C561\C138\C2A4\D558\AC70\B098 \D398\C774\C9C0 \B9E8 \C704\C5D0 \C788\B294 \D0D0\C0C9 \BA54\B274\B97C \C0AC\C6A9\D558\C2ED\C2DC\C624.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282118435877870755)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C774 \D398\C774\C9C0\C758 <strong>\C560\D50C\B9AC\CF00\C774\C158 \AC80\C0C9</strong> \D544\B4DC\C5D0 \AC80\C0C9\C5B4\B97C \C785\B825\D558\AC70\B098 \BAA8\B4E0 \D398\C774\C9C0\C5D0\C11C \D0D0\C0C9 \D45C\C2DC\C904\C758 \AC80\C0C9 \C544\C774\CF58( <span class="fa fa-search" aria-hidden="true"></span> )\C744 \B20C\B7EC \C560\D50C\B9AC\CF00\C774\C158 \B0B4\C5D0\C11C \D574\B2F9 \C6A9\C5B4\B97C \AC80\C0C9\D569\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282118790025870755)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\D0D0\C0C9 \D45C\C2DC\C904\C5D0\C11C \C774\B984 \B4DC\B86D\B2E4\C6B4\C744 \B20C\B7EC \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C0AC\C778\C544\C6C3\D569\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282118620256870755)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\D0D0\C0C9 \D45C\C2DC\C904\C758 \C0AC\C6A9\C790 \BA54\B274( <span class="fa fa-user" aria-hidden="true"></span> )\B97C \B20C\B7EC \C2DC\AC04\B300 \D658\ACBD\C124\C815\C744 \C5C5\B370\C774\D2B8\D558\ACE0 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C0AC\C778\C544\C6C3\D569\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282118190836870755)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D648 \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282118861130870755)
,p_name=>'CA.HELP.HOME.USER'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\D398\C774\C9C0 \C624\B978\CABD \C704\C5D0 \C788\B294 \D0D0\C0C9 \D45C\C2DC\C904\C758 \C0AC\C6A9\C790 \BA54\B274( <span class="fa fa-user" aria-hidden="true"></span> )\B97C \B20C\B7EC \C0AC\C6A9\C790 \D504\B85C\D30C\C77C\C5D0 \C561\C138\C2A4\D558\ACE0 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C0AC\C778\C544\C6C3\D569\B2C8\B2E4.<br>'),
unistr('<strong>\B0B4 \D504\B85C\D30C\C77C \BCF4\AE30</strong>\B97C \B204\B974\BA74 <strong>\D504\B85C\D30C\C77C \C5C5\B370\C774\D2B8</strong>\B97C \B20C\B7EC \AC1C\C778 \C138\BD80\C815\BCF4\B97C \C785\B825\D558\ACE0 \C0AC\C9C4\C774\B098 \C544\BC14\D0C0\B97C \C5C5\B85C\B4DC\D560 \C218 \C788\AC8C \B429\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282118500432870755)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\D0D0\C0C9 \D45C\C2DC\C904\C5D0\C11C \C0AC\C6A9\C790 \BA54\B274( <span class="fa fa-user" aria-hidden="true"></span> )\B97C \B20C\B7EC \C0AC\C6A9\C790 \D504\B85C\D30C\C77C\C5D0 \C561\C138\C2A4\D558\ACE0, \C2DC\AC04\B300 \D658\ACBD\C124\C815\C744 \C5C5\B370\C774\D2B8\D558\ACE0, \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C0AC\C778\C544\C6C3\D569\B2C8\B2E4.<br>'),
unistr('<strong>\B0B4 \D504\B85C\D30C\C77C \BCF4\AE30</strong>\B97C \B204\B974\BA74 <strong>\D504\B85C\D30C\C77C \C5C5\B370\C774\D2B8</strong>\B97C \B20C\B7EC \AC1C\C778 \C138\BD80\C815\BCF4\B97C \C785\B825\D558\ACE0 \C0AC\C9C4\C774\B098 \C544\BC14\D0C0\B97C \C5C5\B85C\B4DC\D560 \C218 \C788\AC8C \B429\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282144697106870771)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B370\C774\D130\B97C \AC80\C0C9\D558\B824\BA74 \AC80\C0C9 \B300\D654\C0C1\C790\C5D0 \AC80\C0C9\C5B4\B97C \C785\B825\D558\AC70\B098 \C5F4 \C81C\BAA9\C744 \B20C\B7EC \BC18\D658\B418\B294 \B808\CF54\B4DC\B97C \C81C\D55C\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\C791\C5C5</strong> \B2E8\CD94\B97C \B20C\B7EC \B2E4\C591\D55C \AE30\B2A5\C744 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4. \C5EC\AE30\C5D0\B294 \D45C\C2DC\B418\AC70\B098 \C228\ACA8\C9C4 \C5F4 \C120\D0DD, \D45C\C2DC \C2DC\D000\C2A4, \B2E4\C591\D55C \B370\C774\D130 \BC0F \D615\C2DD \C9C0\C815 \AE30\B2A5\C774 \D3EC\D568\B429\B2C8\B2E4. \CC28\D2B8 \C635\C158\C744 \C0AC\C6A9\D558\C5EC \B370\C774\D130\C5D0 \B300\D55C \BDF0\B97C \CD94\AC00\B85C \C815\C758\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\C0AC\C6A9\C790\C815\C758 \B0B4\C6A9\C744 \C800\C7A5\D558\B824\BA74 \BCF4\ACE0\C11C\B97C \C120\D0DD\D558\AC70\B098 \B2E4\C6B4\B85C\B4DC\B97C \B20C\B7EC \B370\C774\D130\B97C \C5B8\B85C\B4DC\D569\B2C8\B2E4.<p>'),
'<br>',
unistr('<p>\CD94\AC00 \C815\BCF4\B97C \BCF4\B824\BA74 [\C791\C5C5] \BA54\B274 \C544\B798\C5D0 \C788\B294 [\B3C4\C6C0\B9D0]\C744 \B204\B974\C2ED\C2DC\C624.</p>'),
'',
unistr('<p>\B300\D654\C2DD \BCF4\ACE0\C11C\B97C \AE30\BCF8 \C124\C815\C73C\B85C \C7AC\C124\C815\D558\B824\BA74 <strong>\C7AC\C124\C815</strong> \B2E8\CD94\B97C \B204\B985\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282144588195870771)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \B300\D654\C2DD \ADF8\B9AC\B4DC \B0B4\C5D0\C11C \B370\C774\D130\B97C \C9C1\C811 \C0BD\C785, \C5C5\B370\C774\D2B8 \BC0F \C0AD\C81C\D560 \C218 \C788\C2B5\B2C8\B2E4.<br>'),
unistr('  [\D589 \CD94\AC00] \B2E8\CD94\B97C \B20C\B7EC \C0C8 \D589\C744 \C0BD\C785\D569\B2C8\B2E4.<br>'),
unistr('  \C140\C744 \B450 \BC88 \B204\B974\AC70\B098 <strong>\D3B8\C9D1</strong> \B2E8\CD94\B97C \B20C\B7EC \C2A4\D504\B808\B4DC\C2DC\D2B8\C5D0\C11C \B370\C774\D130\B97C \D3B8\C9D1\D560 \B54C\C640 \BE44\C2B7\D558\AC8C \B370\C774\D130 \AC12\C744 \C5C5\B370\C774\D2B8\D569\B2C8\B2E4.</p>'),
'',
unistr('<p>\BCF4\ACE0\C11C \B9E8 \C704\C5D0 \C788\B294 [\D589 \C791\C5C5] \BA54\B274(<span class="fa fa-bars" aria-hidden="true"></span>)\B97C \C0AC\C6A9\D558\C5EC \C120\D0DD\D55C \D589\C744 \BCF5\C81C, \C0AD\C81C, \C0C8\B85C\ACE0\CE68 \B610\B294 \CDE8\C18C\D560 \C218 \C788\C2B5\B2C8\B2E4.<br> '),
unistr('  \AC1C\BCC4 \D589\C5D0\C11C [\D589 \C791\C5C5] \BA54\B274\B97C \C0AC\C6A9\D558\C5EC \B2E8\C77C \D589 \BDF0\C5D0 \C561\C138\C2A4\D558\AC70\B098 \C0C8 \D589\C744 \CD94\AC00\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\B370\C774\D130\B97C \CC3E\C73C\B824\BA74 \AC80\C0C9 \B300\D654\C0C1\C790\C5D0 \AC80\C0C9\C5B4\B97C \C785\B825\D558\AC70\B098 \C5F4 \C81C\BAA9\C744 \B20C\B7EC \BC18\D658\B418\B294 \B808\CF54\B4DC\B97C \C81C\D55C\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\C791\C5C5</strong> \B2E8\CD94\B97C \B20C\B7EC \B2E4\C591\D55C \AE30\B2A5\C744 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4. \C5EC\AE30\C5D0\B294 \C5F4 \D45C\C2DC/\C228\AE30\AE30 \BC0F \C5F4 \D45C\C2DC \C21C\C11C \C120\D0DD\ACFC \B2E4\C591\D55C \B370\C774\D130 \BC0F \D615\C2DD \C9C0\C815 \AE30\B2A5\C774 \D3EC\D568\B429\B2C8\B2E4. \CC28\D2B8 \C635\C158\C744 \C0AC\C6A9\D558\C5EC \B370\C774\D130\C5D0 \B300\D55C \BDF0\B97C \CD94\AC00\B85C \C815\C758\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\C0AC\C6A9\C790\C815\C758\B97C \C800\C7A5\D558\B824\BA74 \BCF4\ACE0\C11C\B97C \C120\D0DD\D558\AC70\B098 \B2E4\C6B4\B85C\B4DC\B97C \B20C\B7EC \B370\C774\D130\B97C \C5B8\B85C\B4DC\D569\B2C8\B2E4.<p>'),
'',
unistr('<p>\CD94\AC00 \C815\BCF4\B97C \BCF4\B824\BA74 [\C791\C5C5] \BA54\B274 \C544\B798\C5D0 \C788\B294 [\B3C4\C6C0\B9D0]\C744 \B204\B985\B2C8\B2E4.</p> '),
'',
unistr('<p>\B300\D654\C2DD \BCF4\ACE0\C11C\B97C \AE30\BCF8 \C124\C815\C73C\B85C \C7AC\C124\C815\D558\B824\BA74 <strong>\C7AC\C124\C815</strong> \B2E8\CD94\B97C \B204\B985\B2C8\B2E4.</p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282117928453870755)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B370\C774\D130\B97C \AC80\C0C9\D558\B824\BA74 \AC80\C0C9 \B300\D654\C0C1\C790\C5D0 \AC80\C0C9\C5B4\B97C \C785\B825\D558\AC70\B098 \C5F4 \C81C\BAA9\C744 \B20C\B7EC \BC18\D658\B418\B294 \B808\CF54\B4DC\B97C \C81C\D55C\D569\B2C8\B2E4.</p>'),
'',
unistr('<p><strong>\C791\C5C5</strong> \B2E8\CD94\B97C \B20C\B7EC \B2E4\C591\D55C \AE30\B2A5\C744 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4. \C5EC\AE30\C5D0\B294 \D45C\C2DC\B418\AC70\B098 \C228\ACA8\C9C4 \C5F4 \C120\D0DD, \D45C\C2DC \C2DC\D000\C2A4\C640 \B2E4\C591\D55C \B370\C774\D130 \BC0F \D615\C2DD \C9C0\C815 \AE30\B2A5\C774 \D3EC\D568\B429\B2C8\B2E4. \CC28\D2B8, \ADF8\B8F9 \AE30\C900, \D53C\BC97 \C635\C158\C744 \C0AC\C6A9\D558\C5EC \B370\C774\D130 \BDF0\B97C \CD94\AC00\B85C \C815\C758\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</p>'),
'',
unistr('<p>\C0AC\C6A9\C790\C815\C758 \B0B4\C6A9\C744 \C800\C7A5\D558\B824\BA74 \BCF4\ACE0\C11C\B97C \C120\D0DD\D558\AC70\B098 \B2E4\C6B4\B85C\B4DC\B97C \B20C\B7EC \B370\C774\D130\B97C \C5B8\B85C\B4DC\D569\B2C8\B2E4. \AC00\C785 \C2DC \C815\AE30\C801\C73C\B85C \B370\C774\D130\B97C \C804\C1A1\D560 \C804\C790\BA54\C77C \C8FC\C18C\C640 \C2DC\AC04\BC94\C704\B97C \C785\B825\D569\B2C8\B2E4.<p>'),
'',
unistr('<p>\CD94\AC00 \C815\BCF4\B97C \BCF4\B824\BA74 [\C791\C5C5] \BA54\B274\C758 \C544\B798\CABD\C5D0 \C788\B294 [\B3C4\C6C0\B9D0]\C744 \B204\B974\C2ED\C2DC\C624.</p>'),
'',
unistr('<p>\B300\D654\C2DD \BCF4\ACE0\C11C\B97C \AE30\BCF8 \C124\C815\C73C\B85C \C7AC\C124\C815\D558\B824\BA74 <strong>\C7AC\C124\C815</strong> \B2E8\CD94\B97C \B204\B985\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282153633052870776)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \BCF4\ACE0\C11C \D398\C774\C9C0\C5D0\B294 \D398\C774\C9C0 \CE21\BA74 \C120\D0DD\AE30\C758 \AE30\BCF8 \B808\CF54\B4DC\AC00 \D45C\C2DC\B429\B2C8\B2E4. '),
unistr('  \C815\C758\B41C \B9C8\C2A4\D130 \B808\CF54\B4DC \BC0F \B514\D14C\C77C \B808\CF54\B4DC\B97C \D655\C778\D558\B824\BA74 \B808\CF54\B4DC\B97C \C120\D0DD\D569\B2C8\B2E4.<br> '),
unistr('  \B9C8\C2A4\D130 \B808\CF54\B4DC\B97C \D3B8\C9D1\D558\B824\BA74 \D3B8\C9D1 \C544\C774\CF58(<span class="fa fa-pencil-square-o" aria-hidden="true"></span>)\C744 \B204\B985\B2C8\B2E4.'),
unistr('  \B514\D14C\C77C \B808\CF54\B4DC\B97C \D3B8\C9D1\D558\B824\BA74 \AC01 \D589\C758 \B9E8 \C55E\C5D0 \C788\B294 \C5F0\D544\C744 \B204\B985\B2C8\B2E4.</p>'),
unistr('<p>\C120\D0DD\AE30\C5D0 \D45C\C2DC\B418\B294 \B370\C774\D130\B97C \C81C\D55C\D558\B824\BA74 \AC80\C0C9 \B300\D654\C0C1\C790\C5D0 \AC80\C0C9\C5B4\B97C \C785\B825\D569\B2C8\B2E4.</p>'),
'',
unistr('<p>\C0C8 \B9C8\C2A4\D130 \B808\CF54\B4DC\B97C \CD94\AC00\D558\B824\BA74 \D398\C774\C9C0 \C0C1\B2E8\C758 <strong>\C0DD\C131</strong>\C744 \B204\B985\B2C8\B2E4.'),
unistr('  \B514\D14C\C77C \B808\CF54\B4DC\B97C \CD94\AC00\D558\B824\BA74 \B514\D14C\C77C \C601\C5ED \C0C1\B2E8\C758 \B354\D558\AE30 \C544\C774\CF58(+)\C744 \B204\B985\B2C8\B2E4.</p>'),
'',
unistr('<p>\C774\C804\C5D0 \C815\C758\B41C \AC80\C0C9\C5B4\B97C \C81C\AC70\D558\C5EC \D398\C774\C9C0\B97C \AE30\BCF8 \C124\C815\C73C\B85C \C7AC\C124\C815\D558\B824\BA74 \D398\C774\C9C0 \C0C1\B2E8\C758 <strong>\C7AC\C124\C815</strong>\C744 \B204\B985\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282115927491870754)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\AD00\B9AC \D398\C774\C9C0\C5D0\C11C\B294 \C560\D50C\B9AC\CF00\C774\C158 \C18C\C720\C790(\AD00\B9AC\C790)\AC00 \C560\D50C\B9AC\CF00\C774\C158\C744 \AD6C\C131\D558\ACE0 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C0AC\C6A9\B418\B294 \C77C\BC18 \B370\C774\D130\B97C \C720\C9C0\BCF4\C218\D560 \C218 \C788\C2B5\B2C8\B2E4.'),
unistr('\C0AC\C6A9 \AC00\B2A5\D55C \C124\C815 \C911 \D558\B098\B97C \C120\D0DD\D558\BA74 \AD00\B9AC\C790\B294 \C560\D50C\B9AC\CF00\C774\C158\C774 \D45C\C2DC\B41C \BC29\BC95 \BC0F/\B610\B294 \C77C\BC18 \C0AC\C6A9\C790\AC00 \C0AC\C6A9 \AC00\B2A5\D55C \AE30\B2A5\C744 \BCC0\ACBD\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\C774 \D398\C774\C9C0\B294 \AD00\B9AC\C790\B9CC \C561\C138\C2A4\D558\B3C4\B85D \C81C\D55C\B418\C5B4\C57C \D569\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282117158494870754)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C778\C99D\B41C \BAA8\B4E0 \C0AC\C6A9\C790\C5D0 \B300\D574 \C801\D569\D55C \C120\D0DD\C0AC\D56D\C744 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('<strong>\C544\B2C8\C624</strong>\B97C \C120\D0DD\D558\BA74 \C560\D50C\B9AC\CF00\C774\C158\C774 \B354 \C548\C804\D574\C9C0\AE30 \B54C\BB38\C5D0 \C9C0\C815\B41C \C0AC\C6A9\C790\B9CC \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C561\C138\C2A4\D560 \C218 \C788\C2B5\B2C8\B2E4.'),
unistr('\D558\C9C0\B9CC \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\ADDC\BAA8 \C0AC\C6A9\C790 \CEE4\BBA4\B2C8\D2F0\AC00 \C788\C5B4\C11C \C0AC\C6A9\C790\B97C \C720\C9C0\D558\B294 \AC83\C774 \BD80\B2F4\C2A4\B7EC\C6B4 \ACBD\C6B0 <strong>\C608</strong>\B97C \B20C\B7EC \C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\C640 \C81C\ACF5\C790\B9CC \B4E4\C5B4\C62C \C218 \C788\AC8C \D560 \C218 \C788\C2B5\B2C8\B2E4.<br>'),
unistr('<strong>\C608</strong>\B97C \C120\D0DD\D558\B294 \ACBD\C6B0 \C0AC\C6A9\C790 \BAA9\B85D\C5D0 \D3EC\D568\B418\C9C0 \C54A\C740 \C0AC\C6A9\C790\B97C \C5B4\B5BB\AC8C \CC98\B9AC\D560\C9C0\B3C4 \C120\D0DD\D574\C57C \D569\B2C8\B2E4.</p>'),
unistr('<p>\C0AC\C6A9\C790 \C774\B984\C5D0 \C804\C790\BA54\C77C \C8FC\C18C \B610\B294 \C601\C22B\C790 \AC12\C744 \C0AC\C6A9\D558\B3C4\B85D \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('\C77C\BC18\C801\C73C\B85C \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C Oracle Access Manager \B610\B294 SSO\C640 \AC19\C740 \C911\C559\D654\B41C \C778\C99D \CCB4\ACC4\B97C \C0AC\C6A9\D558\B294 \ACBD\C6B0 \B610\B294 \C774\B97C \C0AC\C6A9\D558\B3C4\B85D \AD6C\C131\B41C \ACBD\C6B0 \C774 \C124\C815\C744 <strong>\C804\C790\BA54\C77C \C8FC\C18C</strong>\B85C \C124\C815\D574\C57C \D569\B2C8\B2E4.</p>'),
unistr('<p><em><strong>\CC38\ACE0:</strong> \C774 \C560\D50C\B9AC\CF00\C774\C158\C740 \C870\D68C\C790, \C81C\ACF5\C790, \AD00\B9AC\C790\B85C \AD6C\C131\B41C \C138 \AC00\C9C0 \C561\C138\C2A4 \B808\BCA8\C744 \C9C0\C6D0\D569\B2C8\B2E4.'),
'<ul>',
unistr('  <li><strong>\C870\D68C\C790</strong> - \BAA8\B4E0 \C815\BCF4\C5D0 \B300\D55C \C77D\AE30 \C804\C6A9 \C561\C138\C2A4 \AD8C\D55C\C774 \C788\C73C\BA70 \BCF4\ACE0\C11C\B3C4 \BCFC \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C81C\ACF5\C790</strong> - \C815\BCF4\B97C \C0DD\C131, \D3B8\C9D1, \C0AD\C81C\D560 \C218 \C788\ACE0 \BCF4\ACE0\C11C\B97C \BCFC \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('  <li><strong>\AD00\B9AC\C790</strong>- \C81C\ACF5\C790 \AE30\B2A5 \C774\C678\C5D0\B3C4 \C560\D50C\B9AC\CF00\C774\C158\C758 [\AD00\B9AC] \C139\C158\C5D0 \C561\C138\C2A4\D558\C5EC \C560\D50C\B9AC\CF00\C774\C158 \AD6C\C131\C744 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
'</ul>',
'</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282117347259870754)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \D3FC\C744 \C0AC\C6A9\D558\C5EC \C0AC\C6A9\C790, \C0AC\C6A9\C790\C758 \C804\C790\BA54\C77C \C8FC\C18C\B97C \C785\B825\D558\ACE0 \C561\C138\C2A4 \B808\BCA8\C744 \C124\C815\D569\B2C8\B2E4.'),
unistr('<em>\C561\C138\C2A4 \C81C\C5B4 \AD6C\C131</em> \C544\B798\C5D0\C11C \C815\C758\B41C \C774 \C124\C815\C740 \C0AC\C6A9\C790 \C774\B984\C774 \C804\C790\BA54\C77C \C8FC\C18C\C5EC\C57C \D558\B294\C9C0 \B610\B294 \C601\C22B\C790 \D56D\BAA9\C77C \C218 \C788\B294\C9C0\B97C \ACB0\C815\D569\B2C8\B2E4.</p>'),
unistr('<p>\C774 \C560\D50C\B9AC\CF00\C774\C158\C740 \C870\D68C\C790, \C81C\ACF5\C790, \AD00\B9AC\C790\B85C \AD6C\C131\B41C \C138 \AC00\C9C0 \C561\C138\C2A4 \B808\BCA8\C744 \C9C0\C6D0\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\C870\D68C\C790</strong> - \BAA8\B4E0 \C815\BCF4\C5D0 \B300\D55C \C77D\AE30 \C804\C6A9 \C561\C138\C2A4 \AD8C\D55C\C774 \C788\C73C\BA70 \BCF4\ACE0\C11C\B3C4 \BCFC \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C81C\ACF5\C790</strong> - \C815\BCF4\B97C \C0DD\C131, \D3B8\C9D1, \C0AD\C81C\D560 \C218 \C788\ACE0 \BCF4\ACE0\C11C\B97C \BCFC \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('  <li><strong>\AD00\B9AC\C790</strong> - \C81C\ACF5\C790 \AE30\B2A5 \C774\C678\C5D0\B3C4 \C560\D50C\B9AC\CF00\C774\C158\C758 [\AD00\B9AC] \C139\C158\C5D0 \C561\C138\C2A4\D558\C5EC \C560\D50C\B9AC\CF00\C774\C158 \AD6C\C131\C744 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
'</ul>',
unistr('<p>\AE30\C874 \C0AC\C6A9\C790\B97C \D3B8\C9D1\D558\B294 \ACBD\C6B0 \C0AC\C6A9\C790 \ACC4\C815\C744 \C7A0\AC00 \C774\B4E4\C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C561\C138\C2A4\D558\C9C0 \BABB\D558\B3C4\B85D \D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p><em><strong>\CC38\ACE0:</strong>   Oracle Application Express \ACC4\C815\C744 \C0AC\C6A9\D558\B294 \ACBD\C6B0 \C791\C5C5\C601\C5ED \AD00\B9AC\C790\B294 \C5EC\AE30\C5D0 \C785\B825\B41C \C0AC\C6A9\C790\B3C4 \BE44\BC00\BC88\D638\B97C \C124\C815\D560 \C218 \C788\B294 \C77C\BC18 \C0AC\C6A9\C790\B85C \C815\C758\D574\C57C \D569\B2C8\B2E4.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282117275553870754)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \D398\C774\C9C0\B294 \C560\D50C\B9AC\CF00\C774\C158 \C0AC\C6A9\C790 \BC0F \BD80\C5EC\B41C \C561\C138\C2A4 \B808\BCA8\C5D0 \B300\D55C \BCF4\ACE0\C11C\B97C \BCF4\C5EC\C90D\B2C8\B2E4.</p>'),
unistr('<p>\C5F4 \C81C\BAA9\C744 \B20C\B7EC \B370\C774\D130\B97C \C815\B82C \BC0F \D544\D130\B9C1\D558\AC70\B098 <strong>\C791\C5C5</strong> \B2E8\CD94\B97C \B20C\B7EC \C5F4 \D45C\C2DC \BC0F \B2E4\C591\D55C \CD94\AC00 \ACE0\AE09 \AE30\B2A5\C744 \C0AC\C6A9\C790\C815\C758\D569\B2C8\B2E4.<br>'),
unistr('\B300\D654\C2DD \BCF4\ACE0\C11C\B97C \AE30\BCF8 \C124\C815\C73C\B85C \C7AC\C124\C815\D558\B824\BA74 <strong>\C7AC\C124\C815</strong> \B2E8\CD94\B97C \B204\B985\B2C8\B2E4.</p>'),
unistr('<p>\C0AC\C6A9\C790 \C138\BD80\C815\BCF4 \BC0F \C561\C138\C2A4 \B808\BCA8\C744 \D3B8\C9D1\D558\AC70\B098 \C0AC\C6A9\C790\B97C \C0AD\C81C\D558\B824\BA74 \D3B8\C9D1 \C544\C774\CF58(\B178\B780\C0C9 \C5F0\D544)\C744 \B204\B985\B2C8\B2E4.</p>'),
unistr('<p>\C0C8 \C0AC\C6A9\C790 \BC0F \C774\B4E4\C758 \C561\C138\C2A4 \B808\BCA8\C744 \CD94\AC00\D558\B824\BA74 \BCF4\ACE0\C11C \B9E8 \C704\C5D0\C11C <strong>\C0AC\C6A9\C790 \CD94\AC00</strong>\B97C \B204\B985\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282130702039870763)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C561\C138\C2A4 \C81C\C5B4\AC00 \C0AC\C6A9\C73C\B85C \C124\C815\B41C \ACBD\C6B0 \AD00\B9AC\C790\B294 \C778\C99D\B41C \C0AC\C6A9\C790\AC00 \D2B9\C815 \C560\D50C\B9AC\CF00\C774\C158 \AE30\B2A5\C5D0 \C561\C138\C2A4\D558\C9C0 \BABB\D558\B3C4\B85D \C81C\D55C\D560 \C218 \C788\C2B5\B2C8\B2E4. \C774 \C560\D50C\B9AC\CF00\C774\C158\C740 \C138 \AC00\C9C0 \B864(\C870\D68C\C790, \C81C\ACF5\C790 \BC0F \AD00\B9AC\C790)\C744 \C9C0\C6D0\D569\B2C8\B2E4.<p>'),
'<ul>',
unistr('  <li><strong>\C870\D68C\C790</strong> - \BAA8\B4E0 \C815\BCF4\C5D0 \B300\D55C \C77D\AE30 \C804\C6A9 \C561\C138\C2A4 \AD8C\D55C\C744 \AC00\C9C0\BA70 \BCF4\ACE0\C11C\B3C4 \BCFC \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C81C\ACF5\C790</strong> - \C815\BCF4\B97C \C0DD\C131, \D3B8\C9D1 \BC0F \C0AD\C81C\D560 \C218 \C788\C73C\BA70 \BCF4\ACE0\C11C\B97C \BCFC \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('  <li><strong>\AD00\B9AC\C790</strong> - \C81C\ACF5\C790 \AD8C\D55C \C774\C678\C5D0 \C560\D50C\B9AC\CF00\C774\C158 \AD6C\C131\B3C4 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282152776495870776)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CF64\B9C8, \C138\BBF8\CF5C\B860 \B610\B294 \ACF5\BC31\C73C\B85C \AD6C\BD84\B418\B294 \C0AC\C6A9\C790 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4. \AE30\C874 \B610\B294 \C911\BCF5 \C0AC\C6A9\C790 \C774\B984\C740 \C790\B3D9\C73C\B85C \BB34\C2DC\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282116111362870754)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\AD6C\C131 \C124\C815\C744 \C0AC\C6A9\D558\BA74 \C77C\BC18 \C0AC\C6A9\C790\AC00 \D2B9\C815 \AE30\B2A5\C744 \C0AC\C6A9\D560 \C218 \C788\AC8C(\C0AC\C6A9) \D558\AC70\B098 \C0AC\C6A9\D560 \C218 \C5C6\AC8C(\C0AC\C6A9 \C548\D568) \D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\D2B9\C815 \AE30\B2A5\C774 \C644\C804\D788 \C900\BE44\B418\C9C0 \C54A\C740 \ACBD\C6B0 \B610\B294 \C77C\C2DC\C801\C73C\B85C \C81C\AC70\D574\C57C \D558\B294 \ACBD\C6B0 <strong>\C0AC\C6A9 \C548\D568</strong>\C744 \B204\B985\B2C8\B2E4.'),
unistr('\C0AC\C6A9\D560 \C218 \C788\AC8C \C124\C815\D574\C57C \D558\B294 \ACBD\C6B0 <strong>\C0AC\C6A9</strong>\C744 \D074\B9AD\B9CC \D558\BA74 \B429\B2C8\B2E4.</p>'),
unistr('<p><em><strong>\CC38\ACE0:</strong> \C5EC\AE30\C5D0\C11C \BCC0\ACBD\D55C \B0B4\C6A9\C740 \D604\C7AC \C560\D50C\B9AC\CF00\C774\C158\C744 \C2E4\D589 \C911\C778 \AC1C\BCC4 \C77C\BC18 \C0AC\C6A9\C790\C5D0\AC8C \BC18\C601\B418\C9C0 \C54A\C2B5\B2C8\B2E4. \C77C\BC18 \C0AC\C6A9\C790\AC00 \C0AC\C778\C544\C6C3\D558\ACE0 \B2E4\C2DC \C0AC\C778\C778\D558\BA74 \C218\C815\B41C \AE30\B2A5 \C124\C815\C774 \D638\CD9C\B429\B2C8\B2E4.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282116256784870754)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C744 \D45C\C2DC\D558\B294 \B370 \C0AC\C6A9\B418\B294 \AE30\BCF8 \C0C9\C0C1 \CCB4\ACC4\B97C \C120\D0DD\D569\B2C8\B2E4.</p>'),
unistr('<p><strong>\C77C\BC18 \C0AC\C6A9\C790\AC00 \D14C\B9C8 \C2A4\D0C0\C77C\C744 \C120\D0DD\D558\B3C4\B85D \D5C8\C6A9</strong>\C744 \C120\D0DD\D55C \ACBD\C6B0 \AC01 \C77C\BC18 \C0AC\C6A9\C790\B294 \D648 \D398\C774\C9C0\C758 \C67C\CABD \C544\B798\C5D0 \C788\B294 <em>\C0AC\C6A9\C790\C815\C758</em> \B9C1\D06C\B97C \B20C\B7EC \C0AC\C6A9 \AC00\B2A5\D55C \D14C\B9C8 \C2A4\D0C0\C77C \C911\C5D0\C11C \C120\D0DD\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282116886448870754)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \D398\C774\C9C0\B294 \C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \B85C\AE45\D55C \C608\C0C1\CE58 \C54A\C740 \BAA8\B4E0 \C624\B958\C5D0 \B300\D55C \B300\D654\C2DD \BCF4\ACE0\C11C\B97C \C81C\ACF5\D569\B2C8\B2E4.</p>'),
unistr('<p>\C5F4 \C81C\BAA9\C744 \B20C\B7EC \B370\C774\D130\B97C \C815\B82C\D558\ACE0 \D544\D130\B9C1\D558\AC70\B098 <strong>\C791\C5C5</strong> \B2E8\CD94\B97C \B20C\B7EC \C5F4 \D45C\C2DC \BC0F \B2E4\C591\D55C \CD94\AC00 \ACE0\AE09 \AE30\B2A5\C744 \C0AC\C6A9\C790\C815\C758\D569\B2C8\B2E4. \B300\D654\C2DD \BCF4\ACE0\C11C\B97C \AE30\BCF8 \C124\C815\C73C\B85C \C7AC\C124\C815\D558\B824\BA74 <strong>\C7AC\C124\C815</strong> \B2E8\CD94\B97C \B204\B985\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282116703406870754)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \BCF4\ACE0\C11C \BC0F \CC28\D2B8\B97C \C0AC\C6A9\D558\C5EC \C9C0\C815\B41C \C2DC\AC04\BC94\C704 \B3D9\C548 \D398\C774\C9C0 \BDF0\AC00 \AC00\C7A5 \B9CE\C740 \C0AC\C6A9\C790\B97C \D655\C778\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\BCF4\ACE0 \C2DC\AC04\BC94\C704(\AE30\BCF8\AC12=1\C77C)\C744 \C120\D0DD\D558\ACE0 \D398\C774\C9C0 \B9E8 \C704\C758 \BCF4\ACE0\C11C \BC0F \CC28\D2B8 \C544\C774\CF58 \C911\C5D0\C11C \C120\D0DD\D569\B2C8\B2E4.</p>'),
unistr('<p>\B300\D654\C2DD \BCF4\ACE0\C11C\C758 \ACBD\C6B0 \AC80\C0C9 \D544\B4DC\B97C \C0AC\C6A9\D558\AC70\B098 <strong>\C0AC\C6A9\C790</strong> \C5F4 \C81C\BAA9\C744 \C120\D0DD\D558\C5EC \D2B9\C815 \C0AC\C6A9\C790\B97C \C120\D0DD\D569\B2C8\B2E4. \D45C\C2DC\B418\AC70\B098 \C228\ACA8\C9C4 \C5F4, \D398\C774\C9C0\BCC4 \D589, \D544\D130 \B4F1\ACFC \AC19\C740 <strong>\C791\C5C5</strong> \B2E8\CD94\B97C \B20C\B7EC \B2E4\C591\D55C \AE30\B2A5\C744 \C218\D589\D560 \C218 \C788\C2B5\B2C8\B2E4. \B300\D654\C2DD \BCF4\ACE0\C11C\B97C \AE30\BCF8 \C124\C815\C73C\B85C \C7AC\C124\C815\D558\B824\BA74 <strong>\C7AC\C124\C815</strong> \B2E8\CD94\B97C \B204\B985\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282116979265870754)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \D398\C774\C9C0\B294 \D398\C774\C9C0 \C131\B2A5 \BC0F \C778\AE30\C5D0 \B300\D55C \B300\D654\C2DD \BCF4\ACE0\C11C\B97C \C81C\ACF5\D569\B2C8\B2E4. \C774 \BCF4\ACE0\C11C\B294 \C911\AC04 \ACBD\ACFC \C2DC\AC04\ACFC \D398\C774\C9C0 \BDF0 \C218\B97C \ACF1\D558\C5EC \ACC4\C0B0\B41C <strong>\AC00\C911 \C131\B2A5</strong>\BCC4\B85C \C815\B82C\B429\B2C8\B2E4.</p>'),
unistr('<p>\D544\C694\C5D0 \B530\B77C \D398\C774\C9C0 \B9E8 \C704\C5D0\C11C \BCF4\ACE0 \C2DC\AC04\BC94\C704(\AE30\BCF8\AC12=1\C77C)\C744 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('\C5F4 \C81C\BAA9\C744 \B20C\B7EC \B370\C774\D130\B97C \C815\B82C\D558\ACE0 \D544\D130\B9C1\D558\AC70\B098 <strong>\C791\C5C5</strong> \B2E8\CD94\B97C \B20C\B7EC \C5F4 \D45C\C2DC \BC0F \B2E4\C591\D55C \CD94\AC00 \ACE0\AE09 \AE30\B2A5\C744 \C0AC\C6A9\C790\C815\C758\D569\B2C8\B2E4. \B300\D654\C2DD \BCF4\ACE0\C11C\B97C \AE30\BCF8 \C124\C815\C73C\B85C \C7AC\C124\C815\D558\B824\BA74 <strong>\C7AC\C124\C815</strong> \B2E8\CD94\B97C \B204\B985\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282117055118870754)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \D398\C774\C9C0\B294 \AC00\C7A5 \B9CE\C740 \CD5C\ADFC \D398\C774\C9C0 \BDF0\C5D0 \B300\D55C \B300\D654\C2DD \BCF4\ACE0\C11C\B97C \C81C\ACF5\D569\B2C8\B2E4.</p>'),
unistr('<p>\D544\C694\C5D0 \B530\B77C \D398\C774\C9C0 \B9E8 \C704\C5D0\C11C \BCF4\ACE0 \C2DC\AC04\BC94\C704(\AE30\BCF8\AC12=1\C77C)\C744 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('\C5F4 \C81C\BAA9\C744 \B20C\B7EC \B370\C774\D130\B97C \C815\B82C \BC0F \D544\D130\B9C1\D558\AC70\B098 <strong>\C791\C5C5</strong> \B2E8\CD94\B97C \B20C\B7EC \C5F4 \D45C\C2DC \BC0F \B2E4\C591\D55C \CD94\AC00 \ACE0\AE09 \AE30\B2A5\C744 \C0AC\C6A9\C790\C815\C758\D569\B2C8\B2E4. \B300\D654\C2DD \BCF4\ACE0\C11C\B97C \AE30\BCF8 \C124\C815\C73C\B85C \C7AC\C124\C815\D558\B824\BA74 <strong>\C7AC\C124\C815</strong> \B2E8\CD94\B97C \B204\B985\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282116054189870754)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\D1B5\C9C0\AC00 \D65C\C131 \C0C1\D0DC\C774\BA74 \D648 \D398\C774\C9C0\C5D0 \D45C\C2DC\B429\B2C8\B2E4.</p>'),
unistr('<p>\C774 \BCF4\ACE0\C11C\B294 \C815\C758\B41C \D1B5\C9C0\C640 \D1B5\C9C0\AC00 \D45C\C2DC\B418\B294 \AE30\AC04\C744 \BCF4\C5EC\C90D\B2C8\B2E4.</p>'),
unistr('<p>\D3B8\C9D1 \C544\C774\CF58(\B178\B780\C0C9 \C5F0\D544)\C744 \B20C\B7EC \AE30\C874 \D1B5\C9C0\B97C \D3B8\C9D1\D558\AC70\B098 <strong>\D1B5\C9C0 \CD94\AC00</strong>\B97C \B20C\B7EC \C0C8 \D1B5\C9C0\B97C \C0BD\C785\D569\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282116367021870754)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \C560\D50C\B9AC\CF00\C774\C158 \C774\B984 \BC0F \AC04\B2E8\D55C \C124\BA85\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158 \C774\B984\C740 \D648 \D398\C774\C9C0\C5D0 \D45C\C2DC\B418\BA70, \AC04\B2E8\D55C \C124\BA85\C740 \C560\D50C\B9AC\CF00\C774\C158 \C774\B984 \C544\B798\C5D0 \D45C\C2DC\B429\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282116571450870754)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C77C\BC18 \C0AC\C6A9\C790\B294 \C560\D50C\B9AC\CF00\C774\C158 \B0B4 \BAA8\B4E0 \C77C\BC18 \D398\C774\C9C0\C5D0\C11C \D53C\B4DC\BC31\C744 \C785\B825\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\C774 \BCF4\ACE0\C11C\B294 \C785\B825\D55C \D53C\B4DC\BC31\ACFC \AD00\B9AC\C790\AC00 \C785\B825\D55C \C751\B2F5 \BC0F \D53C\B4DC\BC31 \C0C1\D0DC\B97C \BCF4\C5EC\C90D\B2C8\B2E4.</p>'),
unistr('<p>\D3B8\C9D1 \C544\C774\CF58(\B178\B780\C0C9 \C5F0\D544)\C744 \B20C\B7EC \C751\B2F5\C744 \C785\B825\D558\AC70\B098 \D53C\B4DC\BC31 \C0C1\D0DC\B97C \C5C5\B370\C774\D2B8\D569\B2C8\B2E4.</p>'),
unistr('<p><em><strong>\CC38\ACE0:</strong> \D53C\B4DC\BC31 \C218\C2E0\C790\AC00 \C815\C758\B418\C5B4 \C788\C73C\BA74 \D53C\B4DC\BC31 \C81C\CD9C \B0B4\C6A9\B3C4 \C804\C790\BA54\C77C\C744 \D1B5\D574 \D53C\B4DC\BC31 \C218\C2E0\C790 \BAA9\B85D\C758 \C804\C790\BA54\C77C \C8FC\C18C\B85C \C804\C1A1\B429\B2C8\B2E4.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282132617374870764)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CF64\B9C8\B85C \AD6C\BD84\B41C \C804\C790\BA54\C77C \C8FC\C18C \BAA9\B85D\C744 \C81C\ACF5\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282116645276870754)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('<p><strong>\CCA8\BD80 \C0AC\C6A9</strong> - [\C608]\C778 \ACBD\C6B0 \C0AC\C6A9\C790\AC00 \D53C\B4DC\BC31\C744 \C704\D574 \CCA8\BD80\B97C \C5C5\B85C\B4DC\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282117632603870755)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \D398\C774\C9C0\C5D0\B294 \C815\C758\B41C \C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8 \BC0F \C804\C1A1\B41C \C804\C790\BA54\C77C\C5D0\C11C \D15C\D50C\B9AC\D2B8\AC00 \CC38\C870\B41C \D69F\C218\AC00 \B098\C5F4\B429\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282117433545870754)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \D398\C774\C9C0\C5D0\B294 \C804\C1A1\B41C \C804\C790\BA54\C77C\C774 \B098\C5F4\B429\B2C8\B2E4.</p>'),
unistr('<p>\C804\C1A1\B41C \C804\C790\BA54\C77C\C5D0 \B300\D55C \C138\BD80\C815\BCF4\B97C \BCF4\B824\BA74 \B3CB\BCF4\AE30 \C544\C774\CF58\C744 \B204\B985\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282117538262870755)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8\B97C \C815\C758\D558\B824\BA74 \B2E4\C74C \D544\B4DC\B97C \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D15C\D50C\B9AC\D2B8 \C774\B984</strong>(\D544\C218) - \D15C\D50C\B9AC\D2B8\C5D0 \B300\D55C \C758\BBF8 \C788\B294 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>HTML \D15C\D50C\B9AC\D2B8</strong>(\D544\C218) - HTML \AE30\BC18 \C804\C790\BA54\C77C \C804\B2EC\C744 \D5C8\C6A9\D558\B294 \C218\C2E0\C790\C5D0\AC8C \C804\C1A1\D560 \C804\C790\BA54\C77C\C744 \AD6C\C131\D558\B294 \B370 \C0AC\C6A9\B418\B294 HTML \CF54\B4DC\B97C \C785\B825\D569\B2C8\B2E4.'),
unistr('    \B300\CCB4 \AC12\C740 \B2E4\C74C\ACFC \AC19\C2B5\B2C8\B2E4.'),
'    <ul>',
unistr('        <li><strong>#APP_NAME#</strong> - \C560\D50C\B9AC\CF00\C774\C158 \C774\B984\C73C\B85C \BC14\B01D\B2C8\B2E4.</li>'),
unistr('        <li><strong>#BODY1#</strong> - p_body1_text\B85C \C804\B2EC\B41C \AC12\C73C\B85C \BC14\B01D\B2C8\B2E4.</li> '),
unistr('        <li><strong>#TABLE#</strong> - \D14C\C774\BE14 \C5F4\AE30 HTML, \D14C\C774\BE14 \D589 HTML \BC0F \D14C\C774\BE14 \B2EB\AE30 HTML\C744 \C0AC\C6A9\D558\C5EC p_table_content\B85C \C804\B2EC\B41C \AC12\C73C\B85C \BC14\B01D\B2C8\B2E4.</li> '),
unistr('        <li><strong>#BODY2#</strong> - p_body2_text\B85C \C804\B2EC\B41C \AC12\C73C\B85C \BC14\B01D\B2C8\B2E4.</li> '),
unistr('        <li><strong>#ACTION#</strong> - \C791\C5C5 \B9C1\D06C \D15C\D50C\B9AC\D2B8\B97C \C0AC\C6A9\D558\C5EC p_action_label \BC0F p_action_link\B85C \C804\B2EC\B41C \AC12\C73C\B85C \BC14\B01D\B2C8\B2E4.</li>'),
'     </ul></li>',
unistr('  <li><strong>\C77C\BC18 \D14D\C2A4\D2B8 \D15C\D50C\B9AC\D2B8</strong>(\D544\C218) - HTML \AE30\BC18 \C804\C790\BA54\C77C\C744 \D5C8\C6A9\D558\C9C0 \C54A\B294 \C218\C2E0\C790\C5D0\AC8C \C804\C1A1\D560 \C804\C790\BA54\C77C\C744 \AD6C\C131\D558\B294 \B370 \C0AC\C6A9\B418\B294 \C77C\BC18 \D14D\C2A4\D2B8\B97C \C785\B825\D569\B2C8\B2E4. HTML \D15C\D50C\B9AC\D2B8\C640 \B3D9\C77C\D55C \B300\CCB4 \AC12\C774 \C0AC\C6A9\B429\B2C8\B2E4. \B2E8, #TABLE# \BC0F #ACTION#\C740 \C77C\BC18 \D14D\C2A4\D2B8\B85C \B80C\B354\B9C1\B429\B2C8\B2E4.</li>'),
'<ul>',
unistr('<p>\ACE0\AE09 \C804\C790\BA54\C77C\C758 \ACBD\C6B0 \CD94\AC00 HTML \D15C\D50C\B9AC\D2B8\AC00 \D5C8\C6A9\B429\B2C8\B2E4. \D574\B2F9 \D56D\BAA9\C740 \B2E4\C74C\ACFC \AC19\C2B5\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D589 \C55E</strong> - HTML \D15C\D50C\B9AC\D2B8\C5D0\C11C #TABLE#\C744 \BC14\AFC0 HTML\C744 \C785\B825\D569\B2C8\B2E4. p_table_content\AC00 \C804\B2EC\B41C \ACBD\C6B0\C5D0\B9CC \C0AC\C6A9\B429\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D589 \D15C\D50C\B9AC\D2B8</strong> - \D14C\C774\BE14\C758 \AC01 \D589\C744 \B80C\B354\B9C1\D560 HTML\C744 \C785\B825\D569\B2C8\B2E4. #LABEL# \BC0F #VALUE# \B300\CCB4 \AC12\C744 \C0AC\C6A9\D558\B294 \D589 \C5F4\AE30/\B2EB\AE30 \BC0F \B370\C774\D130 \C5F4\AE30/\B2EB\AE30\AC00 \D3EC\D568\B429\B2C8\B2E4. p_table_content\AC00 \C804\B2EC\B41C \ACBD\C6B0\C5D0\B9CC \C0AC\C6A9\B429\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D589 \B4A4</strong> - \D14C\C774\BE14 \B610\B294 div\B97C \B2EB\C744 HTML\C744 \C785\B825\D569\B2C8\B2E4. p_table_content\AC00 \C804\B2EC\B41C \ACBD\C6B0\C5D0\B9CC \C0AC\C6A9\B429\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C791\C5C5 \B9C1\D06C HTML</strong> - HTML \D15C\D50C\B9AC\D2B8\C5D0\C11C #ACTION#\C744 \BC14\AFC0 HTML\C744 \C785\B825\D569\B2C8\B2E4. #ACTION_LINK# \BC0F #ACTION_TEXT#\AC00 \D3EC\D568\B418\C5B4\C57C \D569\B2C8\B2E4. p_action_label \BC0F p_action_link\AC00 \C804\B2EC\B41C \ACBD\C6B0\C5D0\B9CC \C0AC\C6A9\B429\B2C8\B2E4.</li>'),
'</ul>',
unistr('<p><em><strong>\CC38\ACE0:</strong> <strong>\AE30\BCF8 \D15C\D50C\B9AC\D2B8</strong> \B0B4\C5D0 \C788\B294 \D56D\BAA9\C744 \C608\C81C\B85C \C0AC\C6A9\D558\C5EC \ACE0\C720 \D15C\D50C\B9AC\D2B8\B97C \AC1C\BC1C\D558\C2ED\C2DC\C624. \AE30\BCF8 \D15C\D50C\B9AC\D2B8\C5D0 \C0AC\C6A9\B418\B294 \BAA8\B4E0 \B300\CCB4 \BCC0\C218\B294 \ACE0\C720 \C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8 \B0B4\C5D0 \D3EC\D568\D560 \C218\B3C4 \C788\ACE0 \D3EC\D568\D558\C9C0 \C54A\C744 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282117766250870755)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p><strong>\C804\C790\BA54\C77C \C791\C5C5 \D560\B2F9</strong> \C635\C158 \C911 \D558\B098\B97C \C120\D0DD\D558\C5EC \C804\C790\BA54\C77C \C804\C1A1\C744 \C0AC\C6A9 \B610\B294 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\D569\B2C8\B2E4.</p>'),
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158 \BB38\C81C\B97C \BB38\C758\D560 \C218 \C788\B294 \AE30\BCF8 \C5F0\B77D\CC98\C758 \C804\C790\BA54\C77C \C8FC\C18C\B97C \C0AC\C6A9\D558\C5EC <strong>\B2E4\C74C\C5D0\C11C \C804\C1A1\B41C \C804\C790\BA54\C77C</strong>\C744 \C785\B825\D569\B2C8\B2E4. \C804\C790\BA54\C77C \AE30\B2A5\C744 \C0AC\C6A9\D560 \B54C \C774 \AC12\C744 \C0AC\C6A9\D558\AC70\B098 \ACB9\CCD0\C4F8 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282135962431870766)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C804\C1A1\C5D0 \C0AC\C6A9\B420 \BCF4\B0B8 \C0AC\B78C \C8FC\C18C\C785\B2C8\B2E4. \C804\C790\BA54\C77C \AE30\B2A5\C744 \C0AC\C6A9\D560 \B54C \C774 \AC12\C744 \ACB9\CCD0\C4F8 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282154300201870777)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B2E4\C74C \D56D\BAA9\C744 \CC44\C6B0\ACE0 [\C804\C790\BA54\C77C \C804\C1A1]\C744 \B204\B985\B2C8\B2E4. \C804\C1A1\B41C \BAA8\B4E0 \C804\C790\BA54\C77C\C740 \C804\C790\BA54\C77C \B85C\ADF8\C5D0 \B85C\AE45\B429\B2C8\B2E4.'),
'    <ul>',
unistr('        <li><strong>\BCF4\B0B8 \C0AC\B78C</strong> - [\C804\C790\BA54\C77C \C124\C815]\C5D0\C11C "\BCF4\B0B8 \C0AC\B78C \C8FC\C18C"\B97C \C124\C815\D558\BA74 \D574\B2F9 \C804\C790\BA54\C77C \C8FC\C18C\AC00 \BCF4\B0B8 \C0AC\B78C \C635\C158\C73C\B85C \C81C\ACF5\B429\B2C8\B2E4. \C774 \C560\D50C\B9AC\CF00\C774\C158\C774 \C804\C790\BA54\C77C \C8FC\C18C\B97C \C0AC\C6A9\C790 \C774\B984\C73C\B85C \C0AC\C6A9\D558\B294 \ACBD\C6B0 \C804\C790\BA54\C77C \C804\C1A1 \C2DC \BCF4\B0B8 \C0AC\B78C\C744 \C804\C790\BA54\C77C \C8FC\C18C\B85C \C120\D0DD\D560 \C218 \C788\C2B5\B2C8\B2E4. \D56D\C0C1 \BCF4\B0B8 \C0AC\B78C\C774 \BC1B\B294 \C0AC\B78C\ACFC \B3D9\C77C\D558\B3C4\B85D \C124\C815\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('        <li><strong>\BC1B\B294 \C0AC\B78C</strong> - \C774 \C560\D50C\B9AC\CF00\C774\C158\C774 \C804\C790\BA54\C77C \C8FC\C18C\B97C \C0AC\C6A9\C790 \C774\B984\C73C\B85C \C0AC\C6A9\D558\B294 \ACBD\C6B0 \C804\C790\BA54\C77C \C804\C1A1 \C2DC \BC1B\B294 \C0AC\B78C\C744 \C804\C790\BA54\C77C \C8FC\C18C \BC0F/\B610\B294 \C0AC\C6A9\C790\B85C \C120\D0DD\D560 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('        <li><strong>\C804\C790\BA54\C77C \C8FC\C18C</strong> - \C804\C790\BA54\C77C\C744 \BC1B\C744 \CF64\B9C8\B85C \AD6C\BD84\B41C \C804\C790\BA54\C77C \C8FC\C18C \BAA9\B85D\C785\B2C8\B2E4. \BD80\C801\D569\D55C \AC83\C73C\B85C \D655\C778\B41C \C804\C790\BA54\C77C \C8FC\C18C\B294 \D3EC\D568\B418\C9C0 \C54A\C2B5\B2C8\B2E4.</li>'),
unistr('        <li><strong>\B864</strong> - \C120\D0DD\B41C \B864\C758 \BAA8\B4E0 \C0AC\C6A9\C790 \B610\B294 \C815\C758\B41C \BAA8\B4E0 \C0AC\C6A9\C790\C5D0\AC8C \C804\C790\BA54\C77C\C744 \C804\C1A1\D569\B2C8\B2E4. \C120\D0DD \BAA9\B85D\C5D0\B294 \B864 \BAA9\B85D \BC0F \D574\B2F9 \B864\C758 \C0AC\C6A9\C790 \C218\AC00 \D3EC\D568\B429\B2C8\B2E4.</li>'),
unistr('        <li><strong>\D15C\D50C\B9AC\D2B8</strong> - \C804\C790\BA54\C77C \BCF8\BB38 \C0DD\C131\C5D0 \C0AC\C6A9\D560 \C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('        <li><strong>\C81C\BAA9</strong> - \C804\C790\BA54\C77C \C81C\BAA9\C785\B2C8\B2E4.</li>'),
unistr('        <li><strong>\C804\C790\BA54\C77C \BCF8\BB38</strong> - \C804\C790\BA54\C77C \BCF8\BB38\C73C\B85C \D3EC\D568\D560 \D14D\C2A4\D2B8\C785\B2C8\B2E4.</li>'),
unistr('        <li><strong>\C218\C2E0 \AC70\BD80 \D5C8\C6A9</strong> - \C77C\BD80 \C804\C790\BA54\C77C\C740 \C0AC\C6A9\C790\C758 \C804\C790\BA54\C77C \C218\C2E0 \AC70\BD80\C5D0 \AD00\ACC4\C5C6\C774 \C804\C1A1\B418\C5B4\C57C \D569\B2C8\B2E4. \C7A5\C560 \BA54\C2DC\C9C0 \B4F1\C774 \C774\C5D0 \D574\B2F9\D569\B2C8\B2E4. \C774 \D50C\B798\ADF8\B294 \D574\B2F9 \C804\C790\BA54\C77C\C758 \C218\C2E0 \AC70\BD80\AC00 \D5C8\C6A9\B418\C5B4\C57C \D558\B294\C9C0 \C5EC\BD80 \B610\B294 \C804\C790\BA54\C77C\C774 \C0AC\C6A9\C790 \D658\ACBD\C124\C815\C5D0 \AD00\ACC4\C5C6\C774 \C804\C1A1\B418\C5B4\C57C \D558\B294\C9C0 \C5EC\BD80\B97C \C2DD\BCC4\D569\B2C8\B2E4.</li>'),
'</ul>',
'</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282156016352870778)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B2E4\C74C \D56D\BAA9\C744 \CC44\C6B0\ACE0 [\C804\C790\BA54\C77C \C804\C1A1]\C744 \B204\B985\B2C8\B2E4. \C804\C1A1\B41C \BAA8\B4E0 \C804\C790\BA54\C77C\C740 \C804\C790\BA54\C77C \B85C\ADF8\C5D0 \B85C\AE45\B429\B2C8\B2E4.'),
'    <ul>',
unistr('        <li><strong>\BCF4\B0B8 \C0AC\B78C</strong> - [\C804\C790\BA54\C77C \C124\C815]\C5D0\C11C "\BCF4\B0B8 \C0AC\B78C \C8FC\C18C"\B97C \C124\C815\D558\BA74 \D574\B2F9 \C804\C790\BA54\C77C \C8FC\C18C\AC00 \BCF4\B0B8 \C0AC\B78C \C635\C158\C73C\B85C \C81C\ACF5\B429\B2C8\B2E4. \B610\B294 \D56D\C0C1 \BCF4\B0B8 \C0AC\B78C\C774 \BC1B\B294 \C0AC\B78C\ACFC \B3D9\C77C\D558\B3C4\B85D \C124\C815\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('        <li><strong>\C804\C790\BA54\C77C \C8FC\C18C</strong> - \C804\C790\BA54\C77C\C744 \BC1B\C744 \CF64\B9C8\B85C \AD6C\BD84\B41C \C804\C790\BA54\C77C \C8FC\C18C \BAA9\B85D\C785\B2C8\B2E4. \BD80\C801\D569\D55C \AC83\C73C\B85C \D655\C778\B41C \C804\C790\BA54\C77C \C8FC\C18C\B294 \D3EC\D568\B418\C9C0 \C54A\C2B5\B2C8\B2E4.</li>'),
unistr('        <li><strong>\D15C\D50C\B9AC\D2B8</strong> - \C804\C790\BA54\C77C \BCF8\BB38 \C0DD\C131\C5D0 \C0AC\C6A9\D560 \C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('        <li><strong>\C81C\BAA9</strong> - \C804\C790\BA54\C77C \C81C\BAA9\C785\B2C8\B2E4.</li>'),
unistr('        <li><strong>\C804\C790\BA54\C77C \BCF8\BB38</strong> - \C804\C790\BA54\C77C \BCF8\BB38\C73C\B85C \D3EC\D568\D560 \D14D\C2A4\D2B8\C785\B2C8\B2E4.</li>'),
unistr('        <li><strong>\C218\C2E0 \AC70\BD80 \D5C8\C6A9</strong> - \C77C\BD80 \C804\C790\BA54\C77C\C740 \C0AC\C6A9\C790\C758 \C804\C790\BA54\C77C \C218\C2E0 \AC70\BD80\C5D0 \AD00\ACC4\C5C6\C774 \C804\C1A1\B418\C5B4\C57C \D569\B2C8\B2E4. \C7A5\C560 \BA54\C2DC\C9C0 \B4F1\C774 \C774\C5D0 \D574\B2F9\D569\B2C8\B2E4. \C774 \D50C\B798\ADF8\B294 \D574\B2F9 \C804\C790\BA54\C77C\C758 \C218\C2E0 \AC70\BD80\AC00 \D5C8\C6A9\B418\C5B4\C57C \D558\B294\C9C0 \C5EC\BD80 \B610\B294 \C804\C790\BA54\C77C\C774 \C0AC\C6A9\C790 \D658\ACBD\C124\C815\C5D0 \AD00\ACC4\C5C6\C774 \C804\C1A1\B418\C5B4\C57C \D558\B294\C9C0 \C5EC\BD80\B97C \C2DD\BCC4\D569\B2C8\B2E4.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282116429451870754)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \C560\D50C\B9AC\CF00\C774\C158\C758 \BAA8\B4E0 \C0AC\C6A9\C790\C5D0 \B300\D55C \AE30\BCF8 \C2DC\AC04\B300\B97C \C120\D0DD\D569\B2C8\B2E4.</p>'),
unistr('<p>\AC1C\BCC4 \C0AC\C6A9\C790\B294 \C0AC\C6A9\C790 \C774\B984(\C624\B978\CABD \B9E8 \C704)\C744 \B204\B974\ACE0 <strong>\D658\ACBD\C124\C815</strong>\C744 \C120\D0DD\D558\C5EC \C774 \C124\C815\C744 \BB34\D6A8\D654\D560 \C218 \C788\C2B5\B2C8\B2E4. \B610\B294 \D648 \D398\C774\C9C0 \C544\B798\CABD\C5D0 \D45C\C2DC\B418\B294 \C2DC\AC04\B300 \B9C1\D06C\B97C \B204\B97C \C218 \C788\C2B5\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282132340947870764)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0\B294 UI\B97C \D1B5\D574 \C9C1\C811 \C561\C138\C2A4\D560 \C218 \C5C6\C2B5\B2C8\B2E4. \C774 \D398\C774\C9C0\B294 \D504\B85C\D30C\C77C \C0AC\C9C4 \B2E4\C6B4\B85C\B4DC\C5D0 \C0AC\C6A9\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282132061257870763)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_language=>'ko'
,p_message_text=>unistr('[\C0AC\C6A9\C790 \D504\B85C\D30C\C77C \D398\C774\C9C0]\C5D0\C11C\B294 \C0AC\C6A9\D558\AE30 \C26C\C6B4 \D654\BA74 \D558\B098\C5D0\C11C \C0AC\C6A9\C790\C5D0 \B300\D55C \AD00\B828 \C815\BCF4\B97C \D655\C778\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282131792424870763)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\AC01\D615 \AC00\B85C \C138\B85C \BE44\C728\B85C \B41C \C0AC\C9C4\C744 \C5C5\B85C\B4DC\D558\C2ED\C2DC\C624. \ADF8\B807\C9C0 \C54A\C740 \ACBD\C6B0 \C0AC\C9C4\C774 \C65C\ACE1\B420 \C218 \C788\C2B5\B2C8\B2E4. \C120\D638 \C774\BBF8\C9C0 \D06C\AE30\B294 250x250\D53D\C140\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282117863863870755)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C774 \D3FC\C744 \C0AC\C6A9\D558\BA74 \AC1C\C778 \C138\BD80\C815\BCF4\B97C \C5C5\B370\C774\D2B8\D558\ACE0 \C0AC\C9C4 \B610\B294 \C544\BC14\D0C0\B97C \C5C5\B85C\B4DC\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\C774\BBF8\C9C0\B97C \C5C5\B85C\B4DC\D558\B824\BA74 <strong>\CC3E\C544\BCF4\AE30</strong>\B97C \B204\B974\AC70\B098 \C774\BBF8\C9C0\B97C \B2E8\CD94 \C704\B85C \B04C\C5B4 \B193\C2B5\B2C8\B2E4.<br>'),
unistr('\C0AC\AC01\D615 \AC00\B85C \C138\B85C \BE44\C728\B85C \B41C \C0AC\C9C4\C744 \C5C5\B85C\B4DC\D558\C2ED\C2DC\C624. \ADF8\B807\C9C0 \C54A\C740 \ACBD\C6B0 \C0AC\C9C4\C774 \C65C\ACE1\B420 \C218 \C788\C2B5\B2C8\B2E4. \C120\D638 \C774\BBF8\C9C0 \D06C\AE30\B294 250x250\D53D\C140\C785\B2C8\B2E4.</p>'),
unistr('<p><strong>\C0AC\C9C4 \C0AD\C81C</strong>\B97C \B20C\B7EC \C774\BBF8\C9C0\B97C \C81C\AC70\D569\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282137926624870767)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0\C5D0\C11C \BAA8\B4E0 \C560\D50C\B9AC\CF00\C774\C158 \B3C4\C6C0\B9D0 \D14D\C2A4\D2B8\C5D0 \C561\C138\C2A4\D560 \C218 \C788\C2B5\B2C8\B2E4. "\C124\BA85\C11C" \C601\C5ED\C758 \B9C1\D06C\B294 \C560\D50C\B9AC\CF00\C774\C158\C758 \AE30\B2A5\C5D0 \B300\D55C \AE4A\C774 \C788\B294 \C124\BA85\C744 \C81C\ACF5\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282118970569870755)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0\C5D0\C11C \C0AC\C6A9\C790 \ACC4\C815\C5D0 \B300\D55C \C560\D50C\B9AC\CF00\C774\C158 \D658\ACBD\C124\C815\C744 \C9C0\C815\D560 \C218 \C788\C2B5\B2C8\B2E4. \D658\ACBD\C124\C815\C740 \C2DC\AC04\B300\C640 \AC19\C740 \C560\D50C\B9AC\CF00\C774\C158\C758 \C5EC\B7EC \CE21\BA74\C5D0 \C601\D5A5\C744 \C904 \C218 \C788\C2B5\B2C8\B2E4. \D56D\BAA9 \B808\BCA8 \B3C4\C6C0\B9D0 \C544\C774\CF58\C744 \B20C\B7EC \AC01 \D658\ACBD\C124\C815\C774 \C5B4\B5A4 \C791\C5C5\C744 \C218\D589\D558\B294\C9C0 \C54C\C544\BD05\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281111041079870119)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C774 \BCF4\ACE0\C11C\B294 \B300\AE30\C5F4\C5D0 \C788\B294 \C804\C1A1 \C608\C815 \C804\C790\BA54\C77C\ACFC \C774\BBF8 \C804\C1A1\B41C \C804\C790\BA54\C77C\C744 \BCF4\C5EC\C90D\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281242944299870206)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C774 \BCF4\ACE0\C11C\C5D0\B294 \D574\B2F9 \C560\D50C\B9AC\CF00\C774\C158\C774 \BAA8\B2C8\D130\D558\B3C4\B85D \C120\D0DD\B41C \BAA8\B4E0 \C791\C5C5\C774 \D3EC\D568\B429\B2C8\B2E4. \C791\C5C5 \C774\B984\C744 \B20C\B7EC \AC01 \C791\C5C5\C5D0 \B300\D55C \CD94\AC00 \C138\BD80\C815\BCF4\B97C \BCFC \C218 \C788\C2B5\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281249577671870210)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C774 \BCF4\ACE0\C11C\C5D0\B294 \D574\B2F9 \C560\D50C\B9AC\CF00\C774\C158\C774 \BAA8\B2C8\D130\D558\B3C4\B85D \C120\D0DD\B41C \C791\C5C5\C5D0 \B300\D55C \C2E4\D589 \C138\BD80\C815\BCF4\AC00 \D3EC\D568\B429\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282103293230870746)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158 \C815\BCF4 \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282119610491870756)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C804\C790\BA54\C77C\C744 \BC1B\C9C0 \C54A\C73C\B824\BA74 \C774 \C635\C158\C744 [\C544\B2C8\C624]\B85C \C124\C815\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282153896782870777)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\AC80\C0C9 \B300\D654\C0C1\C790\C5D0 \AC80\C0C9\C5B4\B97C \C785\B825\D558\ACE0 <strong>\AC80\C0C9</strong>\C744 \B204\B985\B2C8\B2E4.<br>'),
unistr('\ACB0\ACFC \C81C\BAA9\C744 \B204\B974\BA74 \D574\B2F9\D558\B294 \D2B9\C815 \B808\CF54\B4DC\B85C \C774\B3D9\B429\B2C8\B2E4.</p>'),
unistr('<p>\AC80\C0C9\C744 \C81C\D55C\D558\B824\BA74 \D558\B098 \C774\C0C1\C758 \C18C\C2A4\B97C \C120\D0DD \CDE8\C18C\D569\B2C8\B2E4. \ADF8\B7EC\BA74 \AC80\C0C9 \ACB0\ACFC\C5D0\C11C \D574\B2F9 \BCF4\ACE0\C11C\AC00 \C81C\AC70\B429\B2C8\B2E4.</p>'),
unistr('<p>\D604\C7AC \AC80\C0C9\C5B4\B97C \C81C\AC70\D558\ACE0 \BAA8\B4E0 \C18C\C2A4\B97C \C120\D0DD\D558\B824\BA74 <strong>\C7AC\C124\C815</strong>\C744 \B204\B985\B2C8\B2E4.</p> ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282119494280870756)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C0AC\C6A9\D560 \C120\D638 \C2DC\AC04\B300\B97C \C124\C815\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281031599973870064)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C228\ACA8\C9C4 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282139599134870768)
,p_name=>'CA.HOME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D648')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282145622717870772)
,p_name=>'CA.HOME.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D648 \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282162039740870782)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04\BCC4 \D398\C774\C9C0 \C774\BCA4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281110190431870119)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('HTML \BCF8\BB38 \D06C\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282136308080870766)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('HTML \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282133027929870764)
,p_name=>'CA.IN.PROGRESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C4\D589 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282158234468870779)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC\C5D0 \D3EC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282158170768870779)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C\C5D0 \D3EC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282141711950870769)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C6D0 \AC1D\CCB4 \C2A4\D06C\B9BD\D2B8 \C124\CE58 \C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281243660547870207)
,p_name=>'CA.INSTANCE.ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C2A4\D134\C2A4 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281244825744870207)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C2A4\D134\C2A4 \ACE0\C815\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282115494470870753)
,p_name=>'CA.INTRO.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\BCF4\B2E4 \C644\BCBD\D55C \AE30\B2A5\C774 \C81C\ACF5\B418\B294 \C560\D50C\B9AC\CF00\C774\C158\C744 \C0DD\C131\D560 \C218 \C788\B294 \C0C8\B86D\ACE0 \AC1C\C120\B41C \BC29\C2DD\C744 \C81C\ACF5\D558\B294 \D074\B77C\C6B0\B4DC \C804\C6A9 \BBF8\B9AC\BCF4\AE30\B97C \C2DC\C791\D569\B2C8\B2E4. \D45C\C900 \C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131 \B9C8\BC95\C0AC\B97C \C0AC\C6A9\D558\BA74 \C0DD\C131\D560 \D398\C774\C9C0\B9CC \C120\D0DD\D560 \C218 \C788\C5C8\C9C0\B9CC \C774 \B9C8\BC95\C0AC\B294 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C218\B9CE\C740 \CD94\AC00 \AE30\B2A5\C744 \BE60\B974\AC8C \BBF8\B9AC \B85C\B4DC\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\C774 \B9C8\BC95\C0AC\B97C \C0AC\C6A9\D558\C5EC \C0DD\C131\B41C \C560\D50C\B9AC\CF00\C774\C158\C740 \C644\C804\D788 \C9C0\C6D0\B418\BA70 \C561\C138\C2A4 \C81C\C5B4, \C804\C790\BA54\C77C \D504\B808\C784\C6CC\D06C, \D53C\B4DC\BC31 \B4F1\ACFC \AC19\C740 \C120\D0DD\D55C \AE30\B2A5\C5D0 \B300\D55C \C9C0\C6D0 \AC1D\CCB4\B3C4 \D3EC\D568\B420 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282115679955870753)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158 \C774\B984 \C785\B825\BD80\D130 \C2DC\C791\D569\B2C8\B2E4. \ADF8\B7F0 \B2E4\C74C \C560\D50C\B9AC\CF00\C774\C158\C5D0 \D398\C774\C9C0\B97C \D558\B098 \C774\C0C1 \CD94\AC00\D569\B2C8\B2E4. \C6D0\D558\B294 \AE30\B2A5\C774 \D3EC\D568\B418\C5C8\B294\C9C0 \D655\C778\D569\B2C8\B2E4. \C560\D50C\B9AC\CF00\C774\C158 \BAA8\C591\C744 \C120\D0DD\D55C \B2E4\C74C \C124\C815\C744 \AC80\D1A0\D569\B2C8\B2E4.<br>'),
unistr('<strong>\C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131</strong>\C744 \B204\B974\BA74 \B05D\C785\B2C8\B2E4!</p>'),
unistr('<p>\C774\C804\C5D0 \C0DD\C131\D55C \C560\D50C\B9AC\CF00\C774\C158\C758 \BAA8\B378\C744 \C7AC\C0AC\C6A9\D558\AC70\B098 \D398\C774\C9C0\B97C \BE60\B974\AC8C \BCF5\C81C\D558\B824\BA74 <strong>\CCAD\C0AC\C9C4 \BCF4\AE30</strong>\B97C \B204\B985\B2C8\B2E4.</p>'),
unistr('<p><em><strong>\CC38\ACE0:</strong> \AC01 \C139\C158\ACFC \AC01 ''\D398\C774\C9C0 \CD94\AC00''\C5D0\B294 \B3C4\C6C0\C774 \B420 \B9CC\D55C \C790\C138\D55C \B3C4\C6C0\B9D0\C774 \D3EC\D568\B418\C5B4 \C788\C2B5\B2C8\B2E4.</em></p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282115510711870753)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \B9C8\BC95\C0AC\B97C \C0AC\C6A9\D558\B294 \BC29\BC95')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282150207640870774)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B9B4\B9AC\C2A4 \C2DC \D655\C778\B41C \C911\C694\D55C \BB38\C81C\AC00 \C544\B798\C5D0 \B098\C5F4\B429\B2C8\B2E4.'),
'<ol>',
unistr('  <li>\CCAD\C0AC\C9C4 \B9C8\BC95\C0AC\C758 \C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131\C774 \BC88\C5ED\B418\C9C0 \C54A\C2B5\B2C8\B2E4.</li>'),
unistr('  <li>\C774 \B9C8\BC95\C0AC\B85C \C0DD\C131\B418\C5B4 \BC88\C5ED\B41C \C560\D50C\B9AC\CF00\C774\C158\C774 \BD80\BD84\C801\C73C\B85C\B9CC \BC88\C5ED\B429\B2C8\B2E4.</li>'),
unistr('  <li>\BCF4\ACE0\C11C \B4DC\B9B4 \B2E4\C6B4\C5D0\C11C \D558\B098\C758 \B4DC\B9B4 \B2E4\C6B4 \C5F4\B9CC \D5C8\C6A9\B429\B2C8\B2E4.</li>'),
unistr('  <li>\BCF4\ACE0\C11C \D544\D130\B9C1 \D398\C774\C9C0\B97C \C0DD\C131\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</li>'),
unistr('  <li>\C804\C790\BA54\C77C \AE30\B2A5\C774 \B0AE\C740 \B808\BCA8\C758 API\B97C \C81C\ACF5\D558\C9C0\B9CC \BCF4\B2E4 \B192\C740 \B808\BCA8\C758 \C804\C790\BA54\C77C \AE30\B2A5\C744 \D3EC\D568\D558\C9C0 \C54A\C2B5\B2C8\B2E4.</li>'),
unistr('  <li>\B204\B77D\B41C \D14C\C774\BE14\C744 \CC38\C870\D558\B294 \CCAD\C0AC\C9C4\C5D0 \AE30\BC18\D55C \C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131\C744 \C2E4\D328\D569\B2C8\B2E4.</li>'),
unistr('  <li>\ACE0\AE09 \C124\C815 - \C0DD\C131\B41C \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B0A0\C9DC \D615\C2DD\C774 \C801\C6A9\B418\C9C0 \C54A\C2B5\B2C8\B2E4.</li>'),
'</ol>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282150152236870774)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C54C\B824\C9C4 \BB38\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282115860846870753)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B9B4\B9AC\C2A4: %0.</p>'),
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282115752626870753)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9B4\B9AC\C2A4 \C138\BD80\C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282115367558870753)
,p_name=>'CA.INTRO.TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCAD\C0AC\C9C4\C5D0\C11C \C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131 \B9C8\BC95\C0AC {\D074\B77C\C6B0\B4DC \C804\C6A9 \BBF8\B9AC\BCF4\AE30}')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282126912049870760)
,p_name=>'CA.IP.ADDRESS'
,p_message_language=>'ko'
,p_message_text=>unistr('IP \C8FC\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282125130239870759)
,p_name=>'CA.IR.SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('IR \AC80\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282128164907870761)
,p_name=>'CA.IR.SEARCHES'
,p_message_language=>'ko'
,p_message_text=>unistr('IR \AC80\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282156629681870778)
,p_name=>'CA.ITEMNAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\BAA9 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281247626223870209)
,p_name=>'CA.JOB.ACTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \C870\CE58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281249191386870210)
,p_name=>'CA.JOB.CLASS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \D074\B798\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281248232354870210)
,p_name=>'CA.JOB.CREATOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \C0DD\C131\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281249374583870210)
,p_name=>'CA.JOB.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281245856627870208)
,p_name=>'CA.JOB.PRIORITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \C6B0\C120\C21C\C704')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281242800755870206)
,p_name=>'CA.JOB.REPORTING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \BCF4\ACE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281285425733870233)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C744 \C9C0\C6D0\D558\B294 \C791\C5C5\C758 \C0C1\D0DC \BC0F \C2E4\D589 \C138\BD80\C815\BCF4 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281249416497870210)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \C2E4\D589 \C138\BD80\C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281248327339870210)
,p_name=>'CA.JOB.STYLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \C2A4\D0C0\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281248450488870210)
,p_name=>'CA.JOB.SUBNAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \D558\C704 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281247781071870209)
,p_name=>'CA.JOB.TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281244456779870207)
,p_name=>'CA.JOB.WEIGHT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \AC00\C911\CE58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282157139769870779)
,p_name=>'CA.KEYCOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0A4 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282158931409870780)
,p_name=>'CA.LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282157485751870779)
,p_name=>'CA.LABELCOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282159122681870780)
,p_name=>'CA.LABELPLURAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14 \BCF5\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282158846729870780)
,p_name=>'CA.LABELSINGULAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14 \B2E8\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282114586386870753)
,p_name=>'CA.LANGUAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5B8\C5B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282114692650870753)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \AE30\BCF8 \C5B8\C5B4\B97C \C120\D0DD\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282149612471870774)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\AE30\BCF8 \C5B8\C5B4\C5D0 \B530\B77C \C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30\C5D0\C11C \C0DD\C131\B41C \D398\C774\C9C0 \BC0F \AD6C\C131\C694\C18C\B97C \D45C\C2DC\D560 \B54C \C0AC\C6A9\B418\B294 \C5B8\C5B4\AC00 \ACB0\C815\B429\B2C8\B2E4. \B2E4\AD6D\C5B4 \BC88\C5ED\C744 \C120\D0DD\D558\BA74 \C77C\BC18 \C0AC\C6A9\C790\B294 \B7F0\D0C0\C784 \C560\D50C\B9AC\CF00\C774\C158\C774 \B80C\B354\B9C1\B420 \B54C \C0AC\C6A9\D560 \C5B8\C5B4\B97C \C120\D0DD\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281394042422870307)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5B8\C5B4 \C120\D0DD\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282131546422870763)
,p_name=>'CA.LAST.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281248514905870210)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C9C0\B9C9 \C2E4\D589 \AE30\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281248682564870210)
,p_name=>'CA.LAST.START.DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C9C0\B9C9 \C2DC\C791 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282162477968870782)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C2E0 \C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282158309888870779)
,p_name=>'CA.LISTOFVALUES'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12 \BAA9\B85D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282153700102870777)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCAD\C0AC\C9C4 \B85C\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281250989154870211)
,p_name=>'CA.LOG.DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\ADF8 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281251175710870211)
,p_name=>'CA.LOG.ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\ADF8 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281245149207870208)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\AE45 \B808\BCA8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281032309826870065)
,p_name=>'CA.LOOKUP.COLUMNS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\C870\D68C \C5F4</strong> - \B2E4\B978 \D14C\C774\BE14\C5D0 \B300\D55C \C870\D68C \C815\C758 \C18D\C131\C744 \D45C\C2DC\D558\B824\BA74 \D655\C7A5\D569\B2C8\B2E4. \C870\D68C \C5F4\C744 \C0AC\C6A9\D558\C5EC \C2DD\BCC4\C790\B97C \D45C\C2DC \C5F4\B85C \BC14\AFC0 \C218 \C788\C2B5\B2C8\B2E4. \C608\B97C \B4E4\C5B4, \BD80\C11C \BC88\D638 \B300\C2E0 \BD80\C11C \C774\B984\C744 \D45C\C2DC\D569\B2C8\B2E4.<br>'),
unistr('<em><strong>\CC38\ACE0:</strong> \C870\D68C \C5F4\C740 \D604\C7AC \D398\C774\C9C0\AC00 \D14C\C774\BE14 \B610\B294 \BDF0\B97C \AE30\BC18\C73C\B85C \D558\BA70 \B2E4\B978 \D14C\C774\BE14\C5D0 \B300\D55C \C678\B798 \D0A4 \C81C\C57D \C870\AC74\C744 \AC00\C9C0\B294 \ACBD\C6B0\C5D0\B9CC \D45C\C2DC\B429\B2C8\B2E4.'),
'  <ul>',
unistr('    <li><strong>\C870\D68C \D0A4</strong> - \D45C\C2DC \C5F4\C744 \CD9C\B825\D558\B3C4\B85D \BCC0\ACBD\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('    <li><strong>\D45C\C2DC \C5F4</strong> - \C870\D68C \D14C\C774\BE14\C5D0\C11C \D45C\C2DC\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'    &nbsp;<br>',
unistr('    <em><strong>\CC38\ACE0:</strong> \C678\B798 \D0A4\B97C \C0AC\C6A9\D558\C5EC \B2E4\B978 \D14C\C774\BE14\C744 \CC38\C870\D558\B294 \C5F4\B9CC \C120\D0DD\D558\C2ED\C2DC\C624.</em></li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282135551957870766)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \D15C\D50C\B9AC\D2B8 \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282133555751870764)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\B4DC\BC31 \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282129659717870762)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C561\C138\C2A4 \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282163085395870782)
,p_name=>'CA.MASTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \B514\D14C\C77C \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282163167004870782)
,p_name=>'CA.MASTER.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C77C\BC18 \C0AC\C6A9\C790\AC00 \B370\C774\D130 \D655\C778 \BC0F \C720\C9C0\BCF4\C218\C5D0 \C0AC\C6A9\D560 \B9C8\C2A4\D130-\B514\D14C\C77C \D398\C774\C9C0\B97C \D45C\C2DC\D558\B294 \D398\C774\C9C0\B97C \C0DD\C131\D569\B2C8\B2E4.<br>'),
'&nbsp;</p>',
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D398\C774\C9C0 \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C758 \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D398\C774\C9C0 \C720\D615</strong> - \D398\C774\C9C0 \C720\D615 [\C138\B85C \C815\B82C, \B204\C801]\C744 \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('    <strong>\C138\B85C \C815\B82C</strong>: <br>'),
unistr('<em>\BAA8\B2EC \D3B8\C9D1 \CC3D\C774 \D3EC\D568\B41C \BCF4\ACE0\C11C \C601\C5ED\ACFC \C138\B85C \C815\B82C \B808\C774\C544\C6C3\C744 \C0AC\C6A9\D558\B294 \B2E8\C77C \D398\C774\C9C0 \B9C8\C2A4\D130-\B514\D14C\C77C\C785\B2C8\B2E4.</em>'),
'    <ul>',
unistr('      <li><strong>\D14C\C774\BE14</strong>(\D544\C218) - \D398\C774\C9C0\C758 \B9C8\C2A4\D130 \D14C\C774\BE14\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('      <li><strong>\AE30\BCF8 \D45C\C2DC \C5F4</strong>(\D544\C218) - \B9C8\C2A4\D130 \B808\CF54\B4DC \BAA9\B85D\C5D0 \D45C\C2DC\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('      <li><strong>\BCF4\C870 \D45C\C2DC \C5F4</strong>(\D544\C218) - \B9C8\C2A4\D130 \B808\CF54\B4DC \BAA9\B85D\C758 [\AE30\BCF8 \D45C\C2DC \C5F4] \C544\B798\C5D0 \D45C\C2DC\D560 \BCF4\C870 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('      <li><strong>\B514\D14C\C77C \D14C\C774\BE14 1</strong>(\D544\C218) - \D398\C774\C9C0\C758 \CCAB\BC88\C9F8 \B514\D14C\C77C \D14C\C774\BE14\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('      <li><strong>\B514\D14C\C77C \D14C\C774\BE14 2</strong> - \D398\C774\C9C0\C758 \B450\BC88\C9F8 \B514\D14C\C77C \D14C\C774\BE14\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('      <li><strong>\B514\D14C\C77C \D14C\C774\BE14 3</strong> - \D398\C774\C9C0\C758 \C138\BC88\C9F8 \B514\D14C\C77C \D14C\C774\BE14\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('      <li><strong>\B514\D14C\C77C \D14C\C774\BE14 4</strong> - \D398\C774\C9C0\C758 \B124\BC88\C9F8 \B514\D14C\C77C \D14C\C774\BE14\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'    </ul>',
unistr('   <strong>\B204\C801</strong>: <br>'),
unistr('<em>\D3B8\C9D1 \AC00\B2A5 \B300\D654\C2DD \ADF8\B9AC\B4DC\B97C \C0AC\C6A9\D558\B294 \B2E8\C77C \D398\C774\C9C0 \B9C8\C2A4\D130-\B514\D14C\C77C\C785\B2C8\B2E4.</em>'),
'    <ul>',
unistr('      <li><strong>\D14C\C774\BE14</strong>(\D544\C218) - \D3B8\C9D1 \AC00\B2A5 \B300\D654\C2DD \ADF8\B9AC\B4DC\C758 \B9C8\C2A4\D130 \D14C\C774\BE14\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('      <li><strong>\B514\D14C\C77C \D14C\C774\BE14</strong>(\D544\C218) - \D398\C774\C9C0\C758 \B514\D14C\C77C \D14C\C774\BE14\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('      <em><strong>\CC38\ACE0:</strong> \B9C8\BC95\C0AC\B97C \D1B5\D574\C11C\B294 \B514\D14C\C77C \D14C\C774\BE14(\D3B8\C9D1 \AC00\B2A5 \B300\D654\C2DD \ADF8\B9AC\B4DC)\C744 \D558\B098\B9CC \CD94\AC00\D560 \C218 \C788\C2B5\B2C8\B2E4. \C0DD\C131 \D6C4 \AC04\D3B8\D558\AC8C \B2E4\B978 \B514\D14C\C77C \D14C\C774\BE14\C744 \CD94\AC00\D560 \C218 \C788\C2B5\B2C8\B2E4.</em>'),
'    </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281393995761870307)
,p_name=>'CA.MASTER_RECORDS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \B808\CF54\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282125817422870760)
,p_name=>'CA.MAX.ELAPSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300 \ACBD\ACFC \C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281245689096870208)
,p_name=>'CA.MAX.FAILURES'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300 \C2E4\D328')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281245215415870208)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300 \C2E4\D589 \AE30\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281245791323870208)
,p_name=>'CA.MAX.RUNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300 \C2E4\D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282157397918870779)
,p_name=>'CA.MAXIMUMROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300 \D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282160349029870781)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300 \B108\BE44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282150967671870775)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282151383515870775)
,p_name=>'CA.MD.ADD.ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282150819752870775)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \C801\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282151767128870775)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0A0\C9DC \AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282151870807870775)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0A0\C9DC \AC12 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282151019197870775)
,p_name=>'CA.MD.EDIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3B8\C9D1')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282150421256870775)
,p_name=>'CA.MD.FILTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282150357664870774)
,p_name=>'CA.MD.FILTERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282151458192870775)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\D130 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282150746139870775)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\B41C \B808\CF54\B4DC \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282150612957870775)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\CF54\B4DC\B97C \CC3E\C744 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282151287436870775)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C0AD\C81C\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282151117911870775)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C5C5\B370\C774\D2B8\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282150505700870775)
,p_name=>'CA.MD.SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282151578032870775)
,p_name=>'CA.MD.VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282151690015870775)
,p_name=>'CA.MD.VALUE.2'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282125364834870759)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\AC04 \ACBD\ACFC \C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282134468788870765)
,p_name=>'CA.MESSAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BA54\C2DC\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282159805586870780)
,p_name=>'CA.METRIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE21\C815\D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282126263698870760)
,p_name=>'CA.MIN.ELAPSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C18C \ACBD\ACFC \C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282129000901870762)
,p_name=>'CA.MOBILE.PHONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \C804\D654')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282124893592870759)
,p_name=>'CA.MODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282138626327870767)
,p_name=>'CA.MORE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B354 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282128259955870761)
,p_name=>'CA.MOST RECENT'
,p_message_language=>'ko'
,p_message_text=>'Most_Recent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282162275050870782)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\C7A5 \D65C\C131\D654\B41C \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281032483285870065)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C911 \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281032563064870065)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\D558\B098 \C774\C0C1\C758 \D14C\C774\BE14 \B610\B294 \BDF0 \C774\B984\C744 \C120\D0DD\D569\B2C8\B2E4. \B610\B294 \BA38\B9AC\AE00\C758 \CCB4\D06C\BC15\C2A4\B97C \B20C\B7EC \B098\C5F4\B41C \BAA8\B4E0 \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C120\D0DD \B610\B294 \C120\D0DD \D574\C81C\D569\B2C8\B2E4.</p>'),
unistr('<p>\C120\D0DD\B41C \AC01 \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\C5D0 \B300\D574 \B300\D654\C2DD \BCF4\ACE0\C11C\AC00 \D3EC\D568\B41C \D398\C774\C9C0\AC00 \CD94\AC00\B429\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282122274235870757)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_language=>'ko'
,p_message_text=>unistr('#LABEL#\C740 \C801\D569\D55C \C2DC\AC04\AE30\B85D\C774\C5B4\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282159643520870780)
,p_name=>'CA.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282113781840870752)
,p_name=>'CA.NAVIGATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0D0\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282113806151870752)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\BA54\B274\B97C \C560\D50C\B9AC\CF00\C774\C158 \CE21\BA74\C5D0 \D45C\C2DC\D560\C9C0 \C544\B2C8\BA74 \C560\D50C\B9AC\CF00\C774\C158 \C0C1\B2E8\C5D0 \AC00\B85C\B85C \D45C\C2DC\D560\C9C0 \C120\D0DD\D569\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282166357190870784)
,p_name=>'CA.NEGATIVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C815\C801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282166222597870784)
,p_name=>'CA.NEUTRAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C911\B9BD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282152322263870776)
,p_name=>'CA.NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281245407114870208)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C2E4\D589 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281244317083870207)
,p_name=>'CA.NLS.ENV'
,p_message_language=>'ko'
,p_message_text=>unistr('NLS \D658\ACBD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281342132500870270)
,p_name=>'CA.NO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B2C8\C624')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282133181565870764)
,p_name=>'CA.NO.ACTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282144733824870771)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0\C5D0 \B300\D55C \B3C4\C6C0\B9D0\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281031618610870064)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\D569\D55C \C0AC\C6A9\C790\AC00 \C874\C7AC\D558\C9C0 \C54A\C74C - \D398\C774\C9C0 \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282153388416870776)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\D569\D55C \C0C8 \C0AC\C6A9\C790\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282149412500870774)
,p_name=>'CA.NONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282129338846870762)
,p_name=>'CA.NOTE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC38\ACE0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282104884575870747)
,p_name=>'CA.NOTIFICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1B5\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282103678932870746)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\D648 \D398\C774\C9C0\C5D0 \D1B5\C9C0 \D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282104938855870747)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC\C790\AC00 \C560\D50C\B9AC\CF00\C774\C158 \D648 \D398\C774\C9C0\C5D0\C11C \BAA8\B4E0 \C77C\BC18 \C0AC\C6A9\C790\C5D0\AC8C \D45C\C2DC\B418\B294 \ACBD\BCF4(\B178\B780\C0C9) \B610\B294 \C624\B958(\BE68\AC04\C0C9)\B97C \C9C0\C815\D560 \C218 \C788\B3C4\B85D \D569\B2C8\B2E4. \C774 \AE30\B2A5\C740 \C77C\BC18 \C0AC\C6A9\C790 \CEE4\BBA4\B2C8\D2F0\C5D0 \C911\C694\D55C \C815\BCF4\B97C \B9B4\B808\C774\D558\B294 \B370 \C720\C6A9\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.<ul>'),
unistr('<li>\D1B5\C9C0 \C815\C758 \AE30\B2A5</li>'),
unistr('<li>\C560\D50C\B9AC\CF00\C774\C158 \D648 \D398\C774\C9C0\C5D0 \D1B5\C9C0 \D45C\C2DC</li>'),
unistr('<li>\D1B5\C9C0 \D45C\C2DC\C758 \C2DC\AC04 \BC94\C704 \C81C\C5B4 \AE30\B2A5</li>'),
unistr('<li>\C720\D615\BCC4 \D1B5\C9C0\C5D0 \B300\D55C \C0C9\C0C1 \AD6C\BD84 \C9C0\C6D0</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282121578232870757)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282125064890870759)
,p_name=>'CA.NUM.ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281247585563870209)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C218 \C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281244111490870207)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1 \C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282157890874870779)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C22B\C790 \D615\C2DD \B9C8\C2A4\D06C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282126518916870760)
,p_name=>'CA.OCCURRENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC1C\C0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282166584535870784)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\B978 \AD00\B9AC\C790\AC00 \C5C6\C744 \ACBD\C6B0 \C774 \C791\C5C5\C744 \C218\D589\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282133385490870764)
,p_name=>'CA.OPEN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282106374503870748)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \AD6C\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282106673326870748)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \D398\C774\C9C0\B97C \D45C\C2DC\D560 \C21C\C11C\B300\B85C \D398\C774\C9C0\B97C \C815\B82C\D569\B2C8\B2E4. <br>'),
unistr('\BAA9\B85D\C5D0\C11C \D398\C774\C9C0\B97C \C7AC\C815\B82C\D558\B824\BA74 \AC01 \D398\C774\C9C0 \BAA9\B85D \B05D\C5D0 \C788\B294 <em>\B04C\C5B4\C11C \D398\C774\C9C0 \C7AC\C815\B82C</em> \C544\C774\CF58(<span class="fa fa-bars" aria-hidden="true"></span>)\C744 \B204\B978 \C0C1\D0DC\C5D0\C11C \D574\B2F9 \D398\C774\C9C0\B97C \C704\CABD\C774\B098 \C544\B798\CABD\C73C\B85C \B04C\C5B4 \B193\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\D648 \D398\C774\C9C0\B294 \D56D\C0C1 \BA3C\C800 \D45C\C2DC\B418\BA70 \C7AC\C815\B82C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.<br>'),
unistr('\AD00\B9AC \D398\C774\C9C0\B294 \D56D\C0C1 \BAA9\B85D \C544\B798\CABD\C5D0 \D45C\C2DC\B418\BA70, \C774 \C21C\C11C\C5D0 \B530\B77C [\AD00\B9AC] \D398\C774\C9C0\C758 [\C560\D50C\B9AC\CF00\C774\C158 \AD00\B9AC] \BAA9\B85D\C5D0 \D45C\C2DC\B418\B294 \C21C\C11C\AC00 \ACB0\C815\B429\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281249661611870210)
,p_name=>'CA.OUTPUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD9C\B825')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281250864419870211)
,p_name=>'CA.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282124774632870759)
,p_name=>'CA.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282127955619870761)
,p_name=>'CA.PAGE.EVENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C774\BCA4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282140435724870768)
,p_name=>'CA.PAGE.HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \B3C4\C6C0\B9D0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282127059095870760)
,p_name=>'CA.PAGE.ITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281395927982870308)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \B808\CF54\B4DC \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281396129998870308)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9 \C218\D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282124386315870759)
,p_name=>'CA.PAGE.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282139722760870768)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D0D0\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282126465940870760)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C131\B2A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282152447318870776)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_language=>'ko'
,p_message_text=>'`'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282125746804870760)
,p_name=>'CA.PAGE.VIEWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282106875471870748)
,p_name=>'CA.PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282106950253870748)
,p_name=>'CA.PAGES.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\CD08\AE30 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \D3EC\D568\D560 \D398\C774\C9C0\B97C \C815\C758\D569\B2C8\B2E4. \C560\D50C\B9AC\CF00\C774\C158\C744 \C0DD\C131\D558\AE30 \C804\C5D0 \D398\C774\C9C0\B97C \D558\B098 \C774\C0C1 \C815\C758\D574\C57C \D569\B2C8\B2E4.</p>'),
unistr('<p>\C774 \B9C8\BC95\C0AC\B97C \D1B5\D574 \C6D0\D558\B294 \C218\C758 \D398\C774\C9C0\B97C \C0DD\C131\D558\C5EC \C560\D50C\B9AC\CF00\C774\C158\C758 \C2DC\C791\D2C0\C744 \B9CC\B4E4 \C218 \C788\C2B5\B2C8\B2E4. \C560\D50C\B9AC\CF00\C774\C158\C744 \C0DD\C131\D55C \D6C4 \D398\C774\C9C0 \C0DD\C131 \B9C8\BC95\C0AC\B97C \C0AC\C6A9\D558\C5EC \B354 \B9CE\C740 \D398\C774\C9C0\B97C \CD94\AC00\D569\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282157732666870779)
,p_name=>'CA.PAGINATIONMETHOD'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \B9E4\AE40 \BC29\BC95')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282126053950870760)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\BD84 \D398\C774\C9C0 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282131800410870763)
,p_name=>'CA.PHOTO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C9C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282132425016870764)
,p_name=>'CA.PHOTO.DELETED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C9C4\C774 \C0AD\C81C\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282131938918870763)
,p_name=>'CA.PHOTO.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C9C4 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282131635604870763)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C9C4 \C5C5\B85C\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282136494906870766)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\BC18 \D14D\C2A4\D2B8 \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282166184286870784)
,p_name=>'CA.POSITIVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE0D\C815\C801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282119226239870756)
,p_name=>'CA.PREFERENCES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D658\ACBD\C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282163724668870783)
,p_name=>'CA.PREVIOUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282158463547870779)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \D45C\C2DC \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282159330469870780)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \D0A4 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282159458881870780)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \C0C1\C704 \D14C\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282126600461870760)
,p_name=>'CA.PROCEDURE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B85C\C2DC\C800')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282119868011870756)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \D658\ACBD\C124\C815\C744 \C5C5\B370\C774\D2B8\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281395514930870308)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C778\CD9C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282121010921870757)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BAA8\C591 \C124\C815\C744 \C800\C7A5\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282119722305870756)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04\B300 \D658\ACBD\C124\C815\C744 \C5C5\B370\C774\D2B8\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282132250810870764)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B85C\D30C\C77C \C0AC\C9C4 \B2E4\C6B4\B85C\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281247814283870209)
,p_name=>'CA.PROGRAM.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B85C\ADF8\B7A8 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281247969070870209)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B85C\ADF8\B7A8 \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282158741757870780)
,p_name=>'CA.QUERY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C8\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281244620446870207)
,p_name=>'CA.RAISE.EVENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\BCA4\D2B8 \BC1C\C0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280876499063869962)
,p_name=>'CA.RATING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B4F1\AE09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282130147803870762)
,p_name=>'CA.READERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\D68C\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282119558621870756)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C218\C2E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282162319622870782)
,p_name=>'CA.RECENT.ERRORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\ADFC \C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281902705735870624)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281902811358870624)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282121717111870757)
,p_name=>'CA.RED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE68\AC04\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282135380278870765)
,p_name=>'CA.REFERENCED'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC38\C870\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281394641296870307)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD00\B9AC \D398\C774\C9C0 \C0C8\B85C\ACE0\CE68')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281012055859870051)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C0C1\C790\B97C \B2EB\C744 \B54C \C0C8\B85C\ACE0\CE68')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281396064457870308)
,p_name=>'CA.REFRESH_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C0C8\B85C\ACE0\CE68')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282121291161870757)
,p_name=>'CA.REGION.BUTTONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94 \C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282121183631870757)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \D56D\BAA9 \C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282127103047870760)
,p_name=>'CA.REGION.ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282139113446870768)
,p_name=>'CA.RELEASE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9B4\B9AC\C2A4 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282106470083870748)
,p_name=>'CA.REMOVING.PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C81C\AC70')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282106568598870748)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('<p><strong>\D3B8\C9D1</strong>\C744 \B20C\B7EC \D398\C774\C9C0\B97C \C120\D0DD\D55C \B2E4\C74C <strong>\D398\C774\C9C0 \C0AD\C81C</strong>\B97C \B20C\B7EC \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \D398\C774\C9C0\B97C \C81C\AC70\D569\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281249284609870210)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC18\BCF5 \AC04\ACA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281110737636870119)
,p_name=>'CA.REPLY.TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\D68C\C2E0 \B300\C0C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282112221371870751)
,p_name=>'CA.REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282112158571870751)
,p_name=>'CA.REPORT.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B300\D654\C2DD \BCF4\ACE0\C11C \B610\B294 \D074\B798\C2DD \BCF4\ACE0\C11C\B85C \D45C\C2DC\B418\B294 \D398\C774\C9C0\B97C \C0DD\C131\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D398\C774\C9C0 \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C758 \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C9C8\C758 \C720\D615</strong> - \BCF4\ACE0\C11C \C18C\C2A4[<strong>\D14C\C774\BE14 \B610\B294 \BDF0</strong>, <strong>SQL \C9C8\C758</strong>]\B97C \C120\D0DD\D569\B2C8\B2E4.<br>'),
unistr('    <strong>\D14C\C774\BE14 \B610\B294 \BDF0</strong>:'),
'    <ul>',
unistr('      <li>\D14C\C774\BE14 \B610\B294 \BDF0(\D544\C218) - \BCF4\ACE0\C11C\C5D0 \B300\D55C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('      <li>\D3FC \D3EC\D568 - \C0AC\C6A9\C790\AC00 \D14C\C774\BE14 \AC12 \C720\C9C0\BCF4\C218\C5D0 \C0AC\C6A9\D560 \B9C1\D06C\B41C \D3FC \D398\C774\C9C0\B97C \D3EC\D568\D558\B824\BA74 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'    </ul>',
unistr('    <strong>SQL \C9C8\C758</strong>:'),
'    <ul>',
unistr('      <li>SQL \C9C8\C758(\D544\C218) - \ACE0\C720 \C5F4\C744 \BC18\D658\D558\B294 \C801\D569\D55C SQL \BB38\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>\BCF4\ACE0\C11C \C720\D615</strong> - \BCF4\ACE0\C11C \C720\D615(<strong>\B300\D654\C2DD \BCF4\ACE0\C11C</strong> \B610\B294 <strong>\D074\B798\C2DD \BCF4\ACE0\C11C</strong>)\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282103972137870746)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC\C774 \C788\B294 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281948718254870652)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282161434211870781)
,p_name=>'CA.REPORT.VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282160048996870780)
,p_name=>'CA.REPORTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281250693036870211)
,p_name=>'CA.REQ.START.DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C694\CCAD\B41C \C2DC\C791 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282160267955870781)
,p_name=>'CA.REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D544\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282137219866870767)
,p_name=>'CA.RESET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C7AC\C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282133268730870764)
,p_name=>'CA.RESOLVED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\ACB0\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282132906101870764)
,p_name=>'CA.RESPONSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C751\B2F5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281245921391870208)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D328 \C2DC \C7AC\C2DC\C791')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281246041698870208)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF5\AD6C \C2DC \C7AC\C2DC\C791')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281243298732870206)
,p_name=>'CA.RESTARTABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C7AC\C2DC\C791 \AC00\B2A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281245585477870208)
,p_name=>'CA.RETRY.COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C7AC\C2DC\B3C4 \C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282155291304870777)
,p_name=>'CA.ROLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B864')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282127381262870761)
,p_name=>'CA.ROW.NUMBER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \BC88\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282136696995870766)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282154633854870777)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \D15C\D50C\B9AC\D2B8 HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282155919497870778)
,p_name=>'CA.ROWS.CONTENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \CF58\D150\CE20')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282128025337870761)
,p_name=>'CA.ROWS.FETCHED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\CD9C\B41C \D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282157634515870779)
,p_name=>'CA.ROWSPERPAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\B2F9 \D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281248854021870210)
,p_name=>'CA.RUN.COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D589 \D69F\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281250497187870211)
,p_name=>'CA.RUN.DURATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D589 \AE30\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281245383009870208)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\C815 \C81C\D55C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281247316033870209)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\C815 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281247483852870209)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\C815 \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281247231200870209)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\C815 \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282114714085870753)
,p_name=>'CA.SCHEMA'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\D0A4\B9C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282114815469870753)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C0AC\C6A9\D560 \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C800\C7A5\D558\B294 \B370\C774\D130\BCA0\C774\C2A4 \C2A4\D0A4\B9C8\B97C \C120\D0DD\D569\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282156752018870778)
,p_name=>'CA.SCOPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC94\C704')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282137306844870767)
,p_name=>'CA.SEARCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282137471387870767)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AC80\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282137521118870767)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9 \B300\D654\C0C1\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282161696087870781)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9 \D544\D130')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282144248952870771)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\C774 \D398\C774\C9C0\B294 \AC80\C0C9\B41C \D14C\C774\BE14\C774\B77C\B294 \ACF5\C720 \AD6C\C131\C694\C18C \BAA9\B85D\C5D0\C11C \D30C\C0DD\B429\B2C8\B2E4.'),
'',
unistr('\CC98\C74C\C5D0 \C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131 \B9C8\BC95\C0AC\C5D0\C11C \C0DD\C131\B41C \BAA8\B4E0 \B300\D654\C2DD \BCF4\ACE0\C11C \D398\C774\C9C0\AC00 \C790\B3D9\C73C\B85C \BAA9\B85D\C5D0 \CD94\AC00\B429\B2C8\B2E4. '),
unistr('\BAA9\B85D\C5D0 \ACE0\C720 \D14C\C774\BE14\C744 \CD94\AC00\D55C \B2E4\C74C [\ACF5\C720 \AD6C\C131\C694\C18C]\B85C \C774\B3D9\D558\B824\BA74 [\BAA9\B85D]\C744 \C120\D0DD\D558\ACE0 [\AC80\C0C9\B41C \D14C\C774\BE14]\C744 \B204\B985\B2C8\B2E4.'),
unistr('  \B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.'),
unistr('    \D56D\BAA9: \BAA9\B85D \D56D\BAA9 \B808\C774\BE14 - \D14C\C774\BE14\C5D0 \B300\D55C \D45C\C2DC \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.'),
unistr('    \B300\C0C1: \D398\C774\C9C0 - \B300\D654\C2DD \BCF4\ACE0\C11C \B4F1\C73C\B85C \C774\B3D9\D558\B824\BA74 \C801\C808\D55C \D398\C774\C9C0\B97C \C120\D0DD\D569\B2C8\B2E4.'),
unistr('    \B300\C0C1: \CE90\C2DC \C9C0\C6B0\AE30 - \C9C0\C6CC\C57C \D560 \D398\C774\C9C0(\C77C\BC18\C801\C73C\B85C \D398\C774\C9C0 \C544\B798\C5D0 \C785\B825\B41C \BC88\D638\C640 \B3D9\C77C\D55C \BC88\D638)\B97C \C785\B825\D569\B2C8\B2E4.'),
unistr('       \B300\D654\C2DD \BCF4\ACE0\C11C \D398\C774\C9C0\B85C \C774\B3D9\D558\B824\BA74 CIR,RIR\C744 \CD94\AC00\D558\C5EC \AE30\C874 \D544\D130 \B4F1\C744 \C9C0\C6C1\B2C8\B2E4.'),
unistr('    \B300\C0C1: \D56D\BAA9 \C774\B984 - \CC44\C6B0\B824\B294 \C801\C808\D55C \D398\C774\C9C0 \D56D\BAA9\C744 \C120\D0DD(\B610\B294 \C785\B825)\D569\B2C8\B2E4.'),
unistr('       \B300\D654\C2DD \BCF4\ACE0\C11C \D398\C774\C9C0\B85C \C774\B3D9\D558\B824\BA74 IR_[COLUMN_NAME]\C744(\B97C) \C785\B825\D569\B2C8\B2E4.'),
unistr('    \B300\C0C1: \D56D\BAA9 \AC12 - =PK=\B97C \C785\B825\D569\B2C8\B2E4.'),
unistr('    \C0AC\C6A9\C790\C815\C758 \C18D\C131: 1 - \AC80\C0C9\D560 \D14C\C774\BE14 \C774\B984\C744 \B300\BB38\C790\B85C \C785\B825\D569\B2C8\B2E4.'),
unistr('    \C0AC\C6A9\C790\C815\C758 \C18D\C131: 2 - \AE30\BCF8 \C5F4 \C774\B984\C744 \B300\BB38\C790\B85C \C785\B825\D569\B2C8\B2E4.'),
unistr('    \C0AC\C6A9\C790\C815\C758 \C18D\C131: 3(\C120\D0DD\C0AC\D56D) - \AC80\C0C9\D560 \CF64\B9C8\B85C \AD6C\BD84\B41C \C5F4 \BAA9\B85D\C785\B2C8\B2E4.'),
unistr('       \C9C0\C815\B41C \C5F4\C774 \C5C6\C744 \ACBD\C6B0 \BAA8\B4E0 \D14D\C2A4\D2B8(varchar2) \BC0F clob(character large object) \C5F4\C774 \AC80\C0C9\B429\B2C8\B2E4.'),
'',
unistr('\CC38\ACE0: \D14C\C774\BE14\C774 \B450 \AC1C \C774\C0C1 \B098\C5F4\B418\B294 \ACBD\C6B0\C5D0\B9CC \AC80\C0C9\C5D0 \C0AC\C6A9 \AC00\B2A5\D55C \D14C\C774\BE14 \BAA9\B85D\C774 \C0AC\C6A9\C790\C5D0\AC8C \D45C\C2DC\B429\B2C8\B2E4.')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282137073570870766)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C0C9 \ACB0\ACFC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282159255411870780)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\C870 \D45C\C2DC \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282133643441870764)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\D55C \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281110055800870119)
,p_name=>'CA.SEND.BEGIN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C1A1 \C2DC\C791')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281110493845870119)
,p_name=>'CA.SEND.COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C1A1 \D69F\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281109914392870118)
,p_name=>'CA.SEND.END'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C1A1 \C885\B8CC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281110307387870119)
,p_name=>'CA.SEND.ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C1A1 \C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282165274273870784)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C804\C1A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282165353472870784)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \D53C\B4DC\BC31\C774 \C218\C2E0\B420 \B54C \C804\C790\BA54\C77C\C744 \C804\C1A1\D574\C57C \D560\C9C0 \C5EC\BD80\B97C \ACB0\C815\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282161919140870782)
,p_name=>'CA.SEND.FROM'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\B0B8 \C0AC\B78C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282154431667870777)
,p_name=>'CA.SEND.TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC1B\B294 \C0AC\B78C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282138972313870768)
,p_name=>'CA.SERIES'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \ACC4\C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281250307703870211)
,p_name=>'CA.SESSION.ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282156903938870779)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\C158 \C0C1\D0DC \BCF4\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282114150311870752)
,p_name=>'CA.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282114247433870752)
,p_name=>'CA.SETTINGS.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131\C5D0 \C0AC\C6A9\B418\B294 \C124\C815\C744 \C9C0\C815\D569\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282138562138870767)
,p_name=>'CA.SHOW.ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281011292091870050)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC94\C704 \D45C\C2DC/\C228\AE30\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282139699779870768)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04\B300 \D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282139437841870768)
,p_name=>'CA.SIGN.IN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C778\C778')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282140642593870769)
,p_name=>'CA.SIGN.OUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C778\C544\C6C3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281250280446870211)
,p_name=>'CA.SLAVE.PID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2AC\B808\C774\BE0C PID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281244234391870207)
,p_name=>'CA.SOURCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18C\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282152575515870776)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\D574\B2F9 \C18C\C2A4 \C720\D615\C740 \C801\D569\D55C \C720\D615\C774 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282144336747870771)
,p_name=>'CA.SOURCES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18C\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281247112333870209)
,p_name=>'CA.START.DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C791 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281248956960870210)
,p_name=>'CA.STATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\D0DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282160147532870780)
,p_name=>'CA.STATICDEFAULT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\C801 \AE30\BCF8\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282123366239870758)
,p_name=>'CA.STATUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\D0DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281244956719870208)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC3D \B2EB\C744 \B54C \C815\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281245014413870208)
,p_name=>'CA.STORE.OUTPUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD9C\B825 \C800\C7A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282133895995870765)
,p_name=>'CA.SUBJECT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282132583447870764)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D53C\B4DC\BC31 \C81C\CD9C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282157286141870779)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\C548\B41C \C2DC\AC01\D654')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282149198452870774)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C6D0 \AC1D\CCB4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282149207577870774)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('<p>\C124\CE58 \C2A4\D06C\B9BD\D2B8\C5D0 \C785\B825\D558\B294 \CF54\B4DC\B294 \C77C\BC18\C801\C73C\B85C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C0DD\C131 \B610\B294 \C870\C791\D558\AC70\B098 \AE30\C874 \B808\CF54\B4DC\C5D0 \B300\D574 \C0BD\C785/\C5C5\B370\C774\D2B8/\C0AD\C81C\B97C \C218\D589\D558\B294 \B370 \C0AC\C6A9\B429\B2C8\B2E4. \C124\CE58 \C81C\AC70 \C2A4\D06C\B9BD\D2B8\C5D0 \C785\B825\D558\B294 \CF54\B4DC\B294 \C77C\BC18\C801\C73C\B85C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C81C\AC70(\C0AD\C81C)\D558\B294 \B370 \C0AC\C6A9\B429\B2C8\B2E4. \C774\B7EC\D55C \C2A4\D06C\B9BD\D2B8\B294 \C9C0\C6D0 \AC1D\CCB4\C5D0 \D1B5\D569\B418\BBC0\B85C \C560\D50C\B9AC\CF00\C774\C158\C744 \C775\C2A4\D3EC\D2B8\D560 \B54C \D14C\C2A4\D2B8 \BC0F \C6B4\C6A9 \D658\ACBD\C5D0\C11C \C774\C640 \AC19\C740 \B3D9\C77C\D55C \C5C5\B370\C774\D2B8\AC00 \C218\D589\B429\B2C8\B2E4.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282149311227870774)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C774 \C784\D3EC\D2B8\B420 \B54C \C2E4\D589\B418\B294 \C801\D569\D55C SQL \BC0F/\B610\B294 PL/SQL \BB38\C744 \C124\CE58 \C2A4\D06C\B9BD\D2B8\C5D0 \C785\B825\D569\B2C8\B2E4.</p>'),
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C774 \B2E4\B978 \D658\ACBD\C5D0 \C784\D3EC\D2B8\B420 \B54C\BFD0\B9CC \C544\B2C8\B77C \D604\C7AC \D658\ACBD\C5D0\C11C\B3C4 \D574\B2F9 \BA85\B839\BB38\C774 \C2E4\D589\B418\B3C4\B85D \D558\B824\BA74 <strong>\C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131 \C2DC \C2E4\D589</strong>\C744 \B204\B985\B2C8\B2E4.</p>'),
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C774 \C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30\C5D0\C11C \C0AD\C81C\B420 \B54C \C2E4\D589\B418\B294 \C801\D569\D55C SQL \BC0F/\B610\B294 PL/SQL \BB38\C744 \C124\CE58 \C81C\AC70 \C2A4\D06C\B9BD\D2B8\C5D0 \C785\B825\D569\B2C8\B2E4.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281244582474870207)
,p_name=>'CA.SYSTEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C2A4\D15C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282158662476870780)
,p_name=>'CA.TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282114989291870753)
,p_name=>'CA.TABLE.PREFIX'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B808\C784\C6CC\D06C \AC1D\CCB4 \C811\B450\C5B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282115058453870753)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C6A9 \AC1D\CCB4 \C811\B450\C5B4\B97C \C785\B825\D569\B2C8\B2E4. \C77C\BD80 \AE30\B2A5\C740 \C0DD\C131\D558\B294 \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4(\D328\D0A4\C9C0 \BC0F \D14C\C774\BE14 \D3EC\D568)\C5D0 \C774 \C811\B450\C5B4\B97C \CD94\AC00\D569\B2C8\B2E4.</p>'),
unistr('<p>\ACBD\ACE0: \B2E4\B978 \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \C0AC\C6A9\B418\C9C0 \C54A\C740 \ACE0\C720 \C811\B450\C5B4\B97C \C785\B825\D574\C57C \D569\B2C8\B2E4. \ACE0\C720\D558\C9C0 \C54A\C744 \ACBD\C6B0 \C560\D50C\B9AC\CF00\C774\C158\C774 \C0DD\C131\B420 \B54C \C624\B958\AC00 \BC1C\C0DD\D558\ACE0 \C81C\B300\B85C \C791\B3D9\D558\C9C0 \C54A\C744 \C218 \C788\C2B5\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282159568287870780)
,p_name=>'CA.TABLECOLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282154584579870777)
,p_name=>'CA.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282136952199870766)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D15C\D50C\B9AC\D2B8 \C774\B984\C740 \C0AC\C6A9 \C911\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282133726252870764)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D15C\D50C\B9AC\D2B8 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282122441466870758)
,p_name=>'CA.TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14D\C2A4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281110287100870119)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14D\C2A4\D2B8 \BCF8\BB38 \D06C\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282134941730870765)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14D\C2A4\D2B8 \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282120617961870756)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\BC18 \C0AC\C6A9\C790 \D14C\B9C8 \D658\ACBD\C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282120826508870757)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\D55C \ACBD\C6B0 \C77C\BC18 \C0AC\C6A9\C790\AC00 [\C0AC\C6A9\C790\C815\C758] \B9C1\D06C\B97C \C0AC\C6A9\D558\C5EC \C790\C2E0\B9CC\C758 \D14C\B9C8 \C2A4\D0C0\C77C\C744 \C120\D0DD\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282120704597870757)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\BC18 \C0AC\C6A9\C790\AC00 \D14C\B9C8 \C2A4\D0C0\C77C\C744 \C120\D0DD\D558\B3C4\B85D \D5C8\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282105022437870747)
,p_name=>'CA.THEME.SELECTOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8 \C2A4\D0C0\C77C \C120\D0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282103401773870746)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \C560\D50C\B9AC\CF00\C774\C158 \BAA8\C591 \C5C5\B370\C774\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282105145542870747)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\AD00\B9AC\C790\AC00 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \B300\D55C \AE30\BCF8 \C0C9\C0C1\D45C(\D14C\B9C8 \C2A4\D0C0\C77C)\B97C \C120\D0DD\D560 \C218 \C788\B3C4\B85D \D569\B2C8\B2E4. \AD00\B9AC\C790\B294 \C77C\BC18 \C0AC\C6A9\C790\C758 \ACE0\C720 \D14C\B9C8 \C2A4\D0C0\C77C \C120\D0DD\C744 \D5C8\C6A9\D558\B3C4\B85D \C120\D0DD\D560 \C218\B3C4 \C788\C2B5\B2C8\B2E4. \C77C\BC18 \C0AC\C6A9\C790\B294 \D648 \D398\C774\C9C0 \D558\B2E8\C5D0 \C788\B294 <em>\C0AC\C6A9\C790\C815\C758</em> \B2E8\CD94\B97C \B204\B974\ACE0 \C0AC\C6A9 \AC00\B2A5\D55C \D14C\B9C8 \C2A4\D0C0\C77C \C911\C5D0\C11C \C120\D0DD\D558\AE30\B9CC \D558\BA74 \B429\B2C8\B2E4. \C608\B97C \B4E4\C5B4, \C2DC\AC01 \C7A5\C560\AC00 \C788\B294 \C0AC\C6A9\C790\B294 \B354 \B192\C740 \C0C9\C0C1 \B300\BE44\AC00 \C81C\ACF5\B418\B294 <em>Vista</em> \D14C\B9C8 \C2A4\D0C0\C77C\C744 \C0AC\C6A9\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.'),
'<ul>',
unistr('<li>\AD00\B9AC\C790\AC00 \AE30\BCF8 \D14C\B9C8 \C2A4\D0C0\C77C\C744 \C815\C758\D560 \C218 \C788\B3C4\B85D \D5C8\C6A9</li>'),
unistr('<li>\C77C\BC18 \C0AC\C6A9\C790\AC00 \B2E4\C591\D55C \D14C\B9C8 \C2A4\D0C0\C77C\C744 \C120\D0DD\D560 \C218 \C788\B3C4\B85D \D568</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282113500877870752)
,p_name=>'CA.THEME.STYLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8 \C2A4\D0C0\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282113612193870752)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C560\D50C\B9AC\CF00\C774\C158\C744 \D45C\C2DC\D558\B294 \B370 \C0AC\C6A9\B418\B294 \AE30\BCF8 \D14C\B9C8 \C2A4\D0C0\C77C\C744 \C120\D0DD\D569\B2C8\B2E4.</p>'),
unistr('<p>\C2A4\D0C0\C77C\C740 \BBF8\B9AC \C815\C758\B41C \B2E4\B978 \C2A4\D0C0\C77C\B85C \C190\C27D\AC8C \BCC0\ACBD\D558\AC70\B098 \C0DD\C131 \D6C4 \C218\C815\D560 \C218 \C788\C2B5\B2C8\B2E4. \C2A4\D0C0\C77C\C744 \BCC0\ACBD\D558\B824\BA74 \C560\D50C\B9AC\CF00\C774\C158\C744 \C2E4\D589\D55C \B2E4\C74C \AC1C\BC1C\C790 \B3C4\AD6C \BAA8\C74C\C5D0\C11C <strong>\D14C\B9C8 \B864\B7EC</strong>\B97C \B204\B985\B2C8\B2E4.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282127641514870761)
,p_name=>'CA.TIME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282119368993870756)
,p_name=>'CA.TIME.ZONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282106149695870748)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04\B300 \C9C0\C6D0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282103070472870746)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12 \BC0F \C0AC\C6A9\C790 \C2DC\AC04\B300 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282105844951870747)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C77C\BC18 \C0AC\C6A9\C790\AC00 \B85C\CEEC \C2DC\AC04\B300\B97C \C124\C815\D560 \C218 \C788\C2B5\B2C8\B2E4. \C560\D50C\B9AC\CF00\C774\C158 \D14C\C774\BE14\C5D0 \C2DC\AC04\B300\B97C \C778\C2DD\D558\B294 \B370\C774\D130 \C720\D615(\C608: \B85C\CEEC \C2DC\AC04\B300\B97C \C0AC\C6A9\D558\B294 \C2DC\AC04\AE30\B85D)\C744 \D65C\C6A9\D558\B294 \ACBD\C6B0 \BCF4\ACE0\C11C \BC0F \B370\C774\D130 \D56D\BAA9\C774 \C77C\BC18 \C0AC\C6A9\C790\AC00 \C788\B294 \C704\CE58\B97C \BC18\C601\D558\BBC0\B85C \C911\C694\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.'),
'<ul>',
unistr('<li>\AD00\B9AC\C790\AC00 \AE30\BCF8 \C2DC\AC04\B300\B97C \C124\C815\D560 \C218 \C788\B3C4\B85D \D5C8\C6A9</li>'),
unistr('<li>\C77C\BC18 \C0AC\C6A9\C790\AC00 \C2DC\AC04\B300 \D658\ACBD\C124\C815\C744 \C120\D0DD\D560 \C218 \C788\B3C4\B85D \D5C8\C6A9</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282162573612870782)
,p_name=>'CA.TIMEFRAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\AC04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282162884179870782)
,p_name=>'CA.TIMELINE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0C0\C784\B77C\C778 \D398\C774\C9C0 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282162954175870782)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C2DC\AC04 \D45C\C2DC\B97C \D45C\C2DC\D558\B294 \D398\C774\C9C0\B97C \C0DD\C131\D569\B2C8\B2E4. \C774 \D398\C774\C9C0\B294 \C5C5\B370\C774\D2B8 \D45C\C2DC\C5D0 \D2B9\D788 \C720\C6A9\D569\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\D398\C774\C9C0 \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C758 \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D14C\C774\BE14 \B610\B294 \BDF0</strong>(\D544\C218) - \C2DC\AC04 \D45C\C2DC\C5D0 \B300\D55C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C0AC\C6A9\C790 \C774\B984</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \C2DC\AC04 \D45C\C2DC \D56D\BAA9\C5D0 \B300\D574 \D45C\C2DC\B418\B294 \C0AC\C6A9\C790\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\B0A0\C9DC</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \C2DC\AC04 \D45C\C2DC \D56D\BAA9\C5D0 \B300\D55C \B0A0\C9DC\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C774\BCA4\D2B8 \C774\B984</strong>(\D544\C218) - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \C2DC\AC04 \D45C\C2DC \D56D\BAA9\C5D0 \B300\D55C \C81C\BAA9\C73C\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C124\BA85</strong> - \D14C\C774\BE14 \B610\B294 \BDF0\C5D0\C11C \C2DC\AC04 \D45C\C2DC \D56D\BAA9\C5D0 \B300\D55C \C124\BA85\C73C\B85C \C0AC\C6A9\D560 \C5F4\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282124515924870759)
,p_name=>'CA.TIMESTAMP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\AC04\AE30\B85D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282129153721870762)
,p_name=>'CA.TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281110848357870119)
,p_name=>'CA.TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC1B\B294 \C0AC\B78C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282128323568870761)
,p_name=>'CA.TOP.USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C0C1\C704 \C0AC\C6A9\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282128497491870761)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\C0C1\C704 \C0AC\C6A9\C790 \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282125921218870760)
,p_name=>'CA.TOTAL.ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD1D \D589 \C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282130369481870762)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0 \C5C6\B294 \C0AC\C6A9\C790\C758 \AE30\BCF8 \B864:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282122510615870758)
,p_name=>'CA.TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281341460696870269)
,p_name=>'CA.UI.DEFAULTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \AE30\BCF8\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281341556525870269)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \C124\C815(\C608: \D398\C774\C9C0\B2F9 \D589)\C5D0 \B300\D55C \AE30\BCF8\AC12\C744 \C124\C815\D558\ACE0 \AC12 \BAA9\B85D \C815\C758\B97C \CD94\AC00\D569\B2C8\B2E4. \D574\B2F9 \C124\C815\C740 \C560\D50C\B9AC\CF00\C774\C158 \B0B4\C5D0\C11C \AD6C\C131\C694\C18C\B97C \C0DD\C131\D560 \B54C \C0AC\C6A9\B429\B2C8\B2E4. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282122769282870758)
,p_name=>'CA.UNTIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\B8CC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281394405063870307)
,p_name=>'CA.UPDATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B370\C774\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282132116859870763)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B85C\D30C\C77C \C5C5\B370\C774\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282123024463870758)
,p_name=>'CA.UPDATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B370\C774\D2B8 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282123128549870758)
,p_name=>'CA.UPDATED.BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B370\C774\D2B8 \C218\D589\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282124410014870759)
,p_name=>'CA.USER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282152031087870775)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C911 \C0AC\C6A9\C790 \CD94\AC00 - \B2E8\ACC4 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282152150087870776)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C911 \C0AC\C6A9\C790 \CD94\AC00 - \B2E8\ACC4 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282152204192870776)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C911 \C0AC\C6A9\C790 \CD94\AC00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282126833782870760)
,p_name=>'CA.USER.AGENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C5D0\C774\C804\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282140292209870768)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C218 \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282128611467870761)
,p_name=>'CA.USER.NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282131101395870763)
,p_name=>'CA.USER.PROFILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \D504\B85C\D30C\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282106015005870747)
,p_name=>'CA.USER.PROFILES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \D504\B85C\D30C\C77C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282102987506870746)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\AC00 \D504\B85C\D30C\C77C\C744 \C5C5\B370\C774\D2B8\D560 \C218 \C788\B3C4\B85D \D5C8\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282105977958870747)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C77C\BC18 \C0AC\C6A9\C790\AC00 \C790\C2E0\C758 \ACC4\C815\C744 \AC1C\BCC4\D654\D558\AE30 \C704\D574 \ADF8\B9BC \B610\B294 \C544\BC14\D0C0\B97C \BE44\B86F\D55C \C790\C2E0\C5D0 \B300\D55C \CD94\AC00 \C815\BCF4\B97C \C785\B825\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \AD6C\C131\C694\C18C\AC00 \D3EC\D568\B429\B2C8\B2E4.'),
'<ul>',
unistr('<li>\C77C\BC18 \C0AC\C6A9\C790\AC00 \D504\B85C\D30C\C77C\C744 \C124\C815\D558\AE30 \C704\D574 \D398\C774\C9C0 \C124\C815</li>'),
unistr('<li>\C0AC\C9C4/\C544\BC14\D0C0\B97C \C5C5\B85C\B4DC\D558\B294 \AE30\B2A5</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282131354796870763)
,p_name=>'CA.USERNAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282130444103870762)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984 \D615\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282152908014870776)
,p_name=>'CA.USERNAMES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281349146572870275)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984 \D615\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282153504293870776)
,p_name=>'CA.USERS.ADDED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\AC00 \CD94\AC00\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282155062885870777)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B864\BCC4 \C0AC\C6A9\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282134574449870765)
,p_name=>'CA.USERS.INCLUDED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3EC\D568\B41C \C0AC\C6A9\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282153286528870776)
,p_name=>'CA.USERS.TO.ADD'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD94\AC00\D560 \C0AC\C6A9\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282130663906870763)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984 \D615\C2DD\C744 \C5C5\B370\C774\D2B8\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281031486890870064)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\D569\D55C \C0AC\C6A9\C790\AC00 \C874\C7AC\D568 - \D398\C774\C9C0 \C815\BCF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282146276548870772)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 ID\AC00 \C874\C7AC\D558\AC70\B098 \B2E4\B978 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C608\C57D\B418\C5B4 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281289715571870236)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C774\B984\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282155632904870778)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C\C744 \BC1B\C744 \C804\C790\BA54\C77C \C8FC\C18C\B97C \C81C\ACF5\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282155480595870778)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \C8FC\C18C\B97C \C81C\ACF5\D558\AC70\B098 \C804\C790\BA54\C77C\C744 \BC1B\C744 \C77C\B828\C758 \C0AC\C6A9\C790\B97C \C120\D0DD\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282155513803870778)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C\C744 \BC1B\C744 \C77C\B828\C758 \C0AC\C6A9\C790\B97C \C120\D0DD\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282146373909870772)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C811\B450\C5B4\B294 6\C790\B97C \CD08\ACFC\D558\C9C0 \C54A\C544\C57C \D558\BA70 \BB38\C790\B85C \C2DC\C791\D558\ACE0 \BB38\C790, \C22B\C790 \BC0F \BC11\C904\B9CC \D3EC\D568\D574\C57C \D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282146409610870772)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\B978 \D14C\C774\BE14 \C811\B450\C5B4\B97C \C785\B825\D558\C2ED\C2DC\C624. \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4 %0\C774(\AC00) \C874\C7AC\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282131001209870763)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790 \C774\B984\C774 \BD80\C801\D569\D55C \C804\C790\BA54\C77C \C8FC\C18C \D615\C2DD\C73C\B85C \B418\C5B4 \C788\C2B5\B2C8\B2E4. \C544\B798 \C560\D50C\B9AC\CF00\C774\C158 \C0AC\C6A9\C790 \C774\B984 \D615\C2DD\C744 \CC38\C870\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282130908310870763)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \D615\C2DD \D655\C778')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282128520189870761)
,p_name=>'CA.VIEW.AS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\AE30 \D615\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282149927664870774)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCAD\C0AC\C9C4 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282138452945870767)
,p_name=>'CA.VIEW.DETAILS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\BD80\C815\BCF4 \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282155862459870778)
,p_name=>'CA.VIEW.EMAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C790\BA54\C77C \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282140563767870769)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4 \D504\B85C\D30C\C77C \BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282125408462870759)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\C911\CE58 \C131\B2A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282160485589870781)
,p_name=>'CA.WIDTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\B108\BE44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282164642522870783)
,p_name=>'CA.WIZARD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\BC95\C0AC \D398\C774\C9C0 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281031323701870064)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\BC95\C0AC \CEE8\D14C\C774\B108')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282164731849870783)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B9C8\BC95\C0AC\B85C \C0AC\C6A9\D560 \D398\C774\C9C0 \BAA8\C74C\C744 \C0DD\C131\D569\B2C8\B2E4. \C77C\BC18\C801\C73C\B85C \B9C8\BC95\C0AC\B294 \C5EC\B7EC \B2E8\ACC4\C5D0\C11C \B370\C774\D130\B97C \C785\B825\D558\B294 \B370 \C0AC\C6A9\B429\B2C8\B2E4.</p>'),
unistr('<p>\B2E4\C74C \C18D\C131\C744 \C785\B825\D569\B2C8\B2E4.</p>'),
'<ul>',
unistr('  <li><strong>\B9C8\BC95\C0AC \C774\B984</strong>(\D544\C218) - \C774 \D398\C774\C9C0\C758 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\C544\C774\CF58 \C124\C815</strong> - \C774 \D398\C774\C9C0\C758 \D0D0\C0C9 \BA54\B274\C5D0 \D45C\C2DC\D560 \C544\C774\CF58\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\D398\C774\C9C0 \BAA8\B4DC</strong>(\D544\C218) - \B9C8\BC95\C0AC \B2E8\ACC4\B97C \BAA8\B2EC \D398\C774\C9C0\B85C \D45C\C2DC\D560\C9C0 \C544\B2C8\BA74 \C77C\BC18 \D398\C774\C9C0\B85C \D45C\C2DC\D560\C9C0 \C120\D0DD\D569\B2C8\B2E4. <strong>\BAA8\B2EC \D398\C774\C9C0</strong> \B610\B294 <strong>\C804\CCB4 \D398\C774\C9C0</strong>\B97C \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('  <li><strong>\B2E8\ACC4 1 ... 8</strong> - \B9C8\BC95\C0AC \B2E8\ACC4\C758 \D398\C774\C9C0 \C774\B984\C744 \C785\B825\D569\B2C8\B2E4.<br><em><strong>\CC38\ACE0:</strong> \B2E8\ACC4 5 - 8\C740 \AC01 \C774\C804 \B2E8\ACC4\C5D0 \B300\D55C \C774\B984\C774 \C785\B825\B420 \B54C \D45C\C2DC\B429\B2C8\B2E4.</em></li>'),
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282128967964870761)
,p_name=>'CA.WORK.PHONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C1\C7A5 \C804\D654')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282121650432870757)
,p_name=>'CA.YELLOW'
,p_message_language=>'ko'
,p_message_text=>unistr('\B178\B780\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281342022431870270)
,p_name=>'CA.YES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280876347599869962)
,p_name=>'CACHED'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE90\C2DC\C5D0 \C800\C7A5\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280760099324869892)
,p_name=>'CACHE_CREATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\CE90\C2DC \C0DD\C131\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280747546998869885)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \C0AD\C81C \AE30\B2A5\C744 \C0AC\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280732081659869875)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \CD94\AC00 \AE30\B2A5\C744 \C0AC\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280732195030869876)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \C5C5\B370\C774\D2B8 \AE30\B2A5\C744 \C0AC\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280915378168869986)
,p_name=>'CALENDAR.NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280915253396869986)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280772942194869900)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC04\B2E8\D55C \B2EC\B825')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281936451384870644)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EC\B825 \D56D\BAA9 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280720662826869869)
,p_name=>'CALENDAR_POPUP'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \B300\D55C \B2EC\B825 \D31D\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280871162685869959)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EC\B825\C774 \C131\ACF5\C801\C73C\B85C \C0DD\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281273927481870226)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\AC70\C2DC \B2EC\B825 \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280772818792869900)
,p_name=>'CALENDAR_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EC\B825')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281124446397870128)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C560\D50C\B9AC\CF00\C774\C158\ACFC \D15C\D50C\B9AC\D2B8 ID %1\C5D0\C11C \BCF5\C0AC\D558\B824\ACE0 \C2DC\B3C4\D560 \B54C \B2EC\B825 \D15C\D50C\B9AC\D2B8\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281275307904870227)
,p_name=>'CANCEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CDE8\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280713794375869864)
,p_name=>'CANDLESTICK'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD1B\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281610052619870446)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\C18D\D615 \C2DC\D2B8')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281331419086870263)
,p_name=>'CENTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC00\C6B4\B370')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281365522218870287)
,p_name=>'CHANGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\ACBD\C0AC\D56D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281995689599870680)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \BCC0\ACBD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281269713145870223)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \D06C\AE30 \BCC0\ACBD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280887913402869969)
,p_name=>'CHANGE_PW_REQUEST'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C694\CCAD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281269562498870223)
,p_name=>'CHANGE_REQUEST'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\ACBD \C694\CCAD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281557270944870414)
,p_name=>'CHANGE_WORKSPACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C791\C5C5\C601\C5ED \BCC0\ACBD')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281241509627870205)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB38\C790\C138\D2B8 \C5F4')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280966846830870019)
,p_name=>'CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280719001736869868)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\BD80\C801\D569\D55C \CC28\D2B8 \C9C8\C758: %0<br><br>'),
unistr('\B2E4\C74C \AD6C\BB38\C744 \C0AC\C6A9\D558\C2ED\C2DC\C624.'),
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
unistr('<tr><td>LABEL</td><td>\B9C9\B300\C5D0 \D45C\C2DC\D560 \D14D\C2A4\D2B8</td></tr>'),
unistr('<tr><td>VALUE</td><td>\B9C9\B300 \D06C\AE30\B97C \C815\C758\D558\B294 \C22B\C790 \C5F4</td></tr>'),
'</table>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280910193908869982)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\BD80\C801\D569\D55C \CC28\D2B8 \C9C8\C758\C785\B2C8\B2E4.<br /><br /> \B2E4\C74C \AD6C\BB38\C744 \C0AC\C6A9\D558\C2ED\C2DC\C624. <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'),
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
unistr('<td>\B2E4\C774\C5BC \AC12\C744 \C815\C758\D558\B294 \C22B\C790 \C5F4\C785\B2C8\B2E4.</td>'),
'</tr>',
'<tr>',
'<td>MAX</td>',
unistr('<td>\CD5C\B300 \B2E4\C774\C5BC \AC12\C744 \C815\C758\D558\B294 \C22B\C790 \C5F4\C785\B2C8\B2E4.</td>'),
'</tr>',
'<tr>',
unistr('<td>LOW(\C120\D0DD\C0AC\D56D)</td>'),
unistr('<td>\C774\C804 \CD5C\C18C \B2E4\C774\C5BC \AC12\C744 \C815\C758\D558\B294 \C22B\C790 \C5F4\C785\B2C8\B2E4.</td>'),
'</tr>',
'<tr>',
unistr('<td>HIGH(\C120\D0DD\C0AC\D56D)</td>'),
unistr('<td>\C774\C804 \CD5C\B300 \B2E4\C774\C5BC \AC12\C744 \C815\C758\D558\B294 \C22B\C790 \C5F4\C785\B2C8\B2E4.</td>'),
'</tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280985067796870032)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C \CC28\D2B8 \C720\D615\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280718950901869868)
,p_name=>'CHART.INVALID_QUERY'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('SQL \C9C8\C758 \AD6C\BB38 \BD84\C11D \C2E4\D328!'),
'<p>%0</p>',
unistr('\D2B9\C815 \C9C8\C758\B294 \C560\D50C\B9AC\CF00\C774\C158\C744 \C2E4\D589\D560 \B54C\B9CC \C2E4\D589\B420 \C218 \C788\C2B5\B2C8\B2E4. \C9C8\C758 \AD6C\BB38\C774 \C815\D655\D55C \ACBD\C6B0 \AC80\C99D \C5C6\C774 \C9C8\C758\B97C \C800\C7A5\D560 \C218 \C788\C2B5\B2C8\B2E4(\C9C8\C758 \C18C\C2A4 \C544\B798\C758 \C635\C158 \CC38\C870).')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282050854345870714)
,p_name=>'CHART_DEGREES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281218499622870191)
,p_name=>'CHART_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280748331299869885)
,p_name=>'CHART_SERIES'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \ACC4\C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281266026394870221)
,p_name=>'CHART_SERIES_ERROR'
,p_message_language=>'ko'
,p_message_text=>unistr('%1\C5D0 \B300\D55C \CC28\D2B8 \ACC4\C5F4 \C624\B958 %0\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280864308463869955)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8\AC00 \C131\ACF5\C801\C73C\B85C \C0DD\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280823672436869931)
,p_name=>'CHECK$'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \C120\D0DD\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281983339653870673)
,p_name=>'CHECKED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D0DD\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281222396710870193)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCB4\D06C\C12C \D544\C694 - \C560\D50C\B9AC\CF00\C774\C158 \B808\BCA8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281038828192870069)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCB4\D06C\C12C \D544\C694 - \C138\C158 \B808\BCA8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281038779623870069)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCB4\D06C\C12C \D544\C694 - \C0AC\C6A9\C790 \B808\BCA8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281038609502870069)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCB4\D06C\C12C \D544\C694 - \C560\D50C\B9AC\CF00\C774\C158 \B808\BCA8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282053230928870715)
,p_name=>'CHECK_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \C120\D0DD')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281206381365870183)
,p_name=>'CLASSIC_CALENDAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D074\B798\C2DD \B2EC\B825')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281209307428870185)
,p_name=>'CLASSIC_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D074\B798\C2DD \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280908618702869982)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D074\B798\C2DD \BCF4\ACE0\C11C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281206975034870183)
,p_name=>'CLASSIC_TREE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D074\B798\C2DD \D2B8\B9AC')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281205132163870182)
,p_name=>'CLEAN_UP'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C9C0\C6B0\AE30')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280742513970869882)
,p_name=>'CLEAR_COMMAND'
,p_message_language=>'ko'
,p_message_text=>unistr('\BA85\B839 \C9C0\C6B0\AE30')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281215030751870188)
,p_name=>'CLOSED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\ACB0\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281262699319870219)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\ADFC 7\C77C\AC04 \C885\ACB0\B41C \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281028349704870062)
,p_name=>'CLOSE_WINDOW'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC3D \B2EB\AE30')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282146858339870772)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EB\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282148512287870773)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC3E\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282146706171870772)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC3E\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282148462723870773)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \CC3E\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282148300852870773)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804 \CC3E\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282148183199870773)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C790\B3D9 \C644\C131')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282147429575870773)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B4E4\C5EC\C4F0\AE30 \D06C\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282147659299870773)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0ED\C744 \ACF5\BC31\C73C\B85C \C785\B825')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282147063988870772)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C18C\BB38\C790 \AD6C\BD84')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282146946901870772)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\ADDC \D45C\D604\C2DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282151939860870775)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C8\C758 \C791\C131\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282148666840870773)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C7AC\C2E4\D589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282148240908870773)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\AFB8\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282146512099870772)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \BC14\AFB8\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282146604475870772)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\AFB8\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282148902828870774)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC74\B108\B6F0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282147973051870773)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282147282531870773)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'ko'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282147789442870773)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \BC88\D638 \D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282147134694870772)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B208\AE08\C790 \D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282147524172870773)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0ED \D06C\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282147367236870773)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282148721501870773)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D589 \CDE8\C18C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282147838735870773)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\BC18 \D14D\C2A4\D2B8 \D3B8\C9D1\AE30 \C0AC\C6A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282148080255870773)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C99D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282148871151870774)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C99D \C131\ACF5')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281145230360870143)
,p_name=>'COLLAPSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD95\C18C ')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280755892062869890)
,p_name=>'COLOR_PALETTE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C9\C0C1 \D314\B808\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280981686703870029)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B0A0\B85C\ADF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280981290729870029)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\C870')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280981892854870029)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280981754828870029)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B178\D1A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280981320016870029)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\C870 \BD84\D560')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280981543893870029)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_language=>'ko'
,p_message_text=>unistr('4\C911')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280981475476870029)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_language=>'ko'
,p_message_text=>unistr('3\C911')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281602117713870441)
,p_name=>'COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282038254724870706)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC \C774\B984: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281137545274870137)
,p_name=>'COLUMN_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \C774\B984')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281343228066870270)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\B41C \BAA8\B4E0 \C0AC\C6A9\C790\AC00 \C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C561\C138\C2A4\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281343368037870271)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C561\C138\C2A4 \C81C\C5B4 \BAA9\B85D\C5D0 \C815\C758\B41C \C0AC\C6A9\C790\B9CC \C774 \C560\D50C\B9AC\CF00\C774\C158\C5D0 \C561\C138\C2A4\D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281343472914870271)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C608\C0C1\CE58 \C54A\C740 \C561\C138\C2A4 \C81C\C5B4 \C124\C815 \AC12: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280749205115869886)
,p_name=>'COMING_SOON'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACE7 \CD9C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281138008186870138)
,p_name=>'COMMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281275540720870227)
,p_name=>'COMMENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\BA85')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281029588018870063)
,p_name=>'COMPILE_FAILURE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CEF4\D30C\C77C \C2E4\D328, <a href="javascript:goToLine(''%0'')">%0</a> \D589(%2)<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281359515874870282)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_language=>'ko'
,p_message_text=>unistr('\CEF4\D30C\C77C \C2E4\D328, %0 \D589(%2). \CEF4\D30C\C77C \C624\B958\C640 \C5F0\AD00\B41C \D589\C758 \C22B\C790\B294 \CCAB\BC88\C9F8 BEGIN \BB38\ACFC \AD00\B828\B429\B2C8\B2E4. \C774\B294 \B370\C774\D130\BCA0\C774\C2A4 \D2B8\B9AC\AC70 \CEF4\D30C\C77C\C5D0\B9CC \C601\D5A5\C744 \B07C\CE69\B2C8\B2E4.<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281029406315870063)
,p_name=>'COMPILE_SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('PL/SQL \CF54\B4DC\AC00 \C131\ACF5\C801\C73C\B85C \CEF4\D30C\C77C\B418\C5C8\C2B5\B2C8\B2E4(%0).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281212347416870187)
,p_name=>'COMPLETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C644\B8CC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281219706002870191)
,p_name=>'COMPLETED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C644\B8CC\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281226707550870196)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C644\B8CC/\BB38\C81C \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281263266934870219)
,p_name=>'COMPONENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131\C694\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281420045451870326)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131\C694\C18C \C774\B984: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281691322341870495)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131\C694\C18C\AC00 \C0AC\C6A9\C73C\B85C \C124\C815\B418\C9C0 \C54A\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280867888432869957)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131\C694\C18C\AC00 \C131\ACF5\C801\C73C\B85C \C0DD\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282033540497870703)
,p_name=>'COMPONENT_SUMMARY'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131\C694\C18C \C694\C57D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280811034165869923)
,p_name=>'COMPUTATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C0B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281286775303870234)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AD6C\C131\C694\C18C\AC00 \C131\ACF5\C801\C73C\B85C \C124\CE58\B418\C5C8\C2B5\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281030113818870063)
,p_name=>'CONDITIONAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\AC74\BD80')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281120090272870125)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_language=>'ko'
,p_message_text=>unistr('\D31D\C5C5 \AC12 \BAA9\B85D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281203850379870181)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\C0C1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280939825826870000)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C874\C7AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280939307430870000)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\BAA9/\C5F4=\AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280939466957870000)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\BAA9/\C5F4\C774 \B110\C774 \C544\B2D8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281905478632870626)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\BAA9/\C5F4 \B110')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280939951386870001)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_language=>'ko'
,p_message_text=>unistr('\BB34\C870\AC74 \BD80\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280940014852870001)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280939645944870000)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C5D0 \C874\C7AC\D558\B294 \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280939792350870000)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C5D0 \C874\C7AC\D558\C9C0 \C54A\B294 \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280939226835870000)
,p_name=>'CONDITIONS_SHORTCUT_PLSQL'
,p_message_language=>'ko'
,p_message_text=>'PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280939523361870000)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_language=>'ko'
,p_message_text=>unistr('\C694\CCAD=e1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280951119821870008)
,p_name=>'CONDITION_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\AC74 \C720\D615')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281165265520870157)
,p_name=>'CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D655\C778')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280715550072869866)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \B9C8\C2A4\D130 \B514\D14C\C77C 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280715432738869865)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \B9C8\C2A4\D130 \B514\D14C\C77C 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280925827142869992)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\C81C \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281211567257870186)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4\BCC4 \C9D1\ACC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281211675524870186)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\D560 \C9D1\ACC4 \D568\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280923298497869990)
,p_name=>'CONFIRM.APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280936657476869998)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC4\CE6D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280936724781869998)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \C5B8\C5B4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280936525840869998)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280817763936869927)
,p_name=>'CONFIRM.ARRAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \ACB0\ACFC \D2B8\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280817853028869927)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \ACB0\ACFC \B9E4\AC1C\BCC0\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280936814362869998)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281403200360870313)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \BD84\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281127456447870131)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\BD84 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280925649989869992)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \B2E8\CD94 \BD84\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280925533224869992)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \B2E8\CD94 \D45C\C2DC \D14D\C2A4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280729270573869874)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \CD94\AC00 \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280729176715869874)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B04C\C5B4 \B193\AE30 \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281345605808870272)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84\AE30 \CDE8\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281403002533870313)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CDE8\C18C \B2E8\CD94 \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281393532502870306)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C18C\BB38\C790 \AD6C\BD84')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281027879508870062)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\D654\C2DD \BCF4\ACE0\C11C \C9C8\C758\B97C \BCC0\ACBD\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C9C8\C758\C5D0\C11C \C5F4\C744 \C81C\AC70\D55C \ACBD\C6B0 \AE30\C874 \D544\D130, \AC15\C870 \D45C\C2DC \ADDC\CE59 \BC0F \D574\B2F9 \C5F4\C744 \CC38\C870\D558\B294 \AE30\D0C0 \BCF4\ACE0\C11C \C124\C815\C774 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\B429\B2C8\B2E4. \C694\CCAD\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280926716841869992)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \CD95')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281275808699870227)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C774\C5BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281275997219870227)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C774\C5BC(Sweep)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280927482630869993)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\D3C9 \B9C9\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280927663386869993)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280926934056869992)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C22B\C790 \B9C8\C2A4\D06C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280927599677869993)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C774')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280926628951869992)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \C9C8\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280926861277869992)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18C\C218\C810 \C774\D558 \C790\B9BF\C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280927726563869993)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0B0\D3EC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280927296942869993)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \D06C\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280927123550869993)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280927057130869992)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC28\D2B8 \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280927358585869993)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C218\C9C1 \B9C9\B300')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280817918997869927)
,p_name=>'CONFIRM.COLLECTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C784\C2DC \ACB0\ACFC \C9D1\D569 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280924053551869991)
,p_name=>'CONFIRM.COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281127286278870130)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \BA38\B9AC\AE00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281303119304870245)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281345847031870272)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280936367094869998)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \BA38\B9AC\AE00 \C815\B82C \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281043099894870072)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \C560\D50C\B9AC\CF00\C774\C158\C744 \BCF5\C0AC\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280934933220869997)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D398\C774\C9C0\B97C \BCF5\C0AC\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280924594911869991)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \D0ED \C9D1\D569 "%0"\C774(\AC00) \C0DD\C131\B418\C5B4 \C774 \D398\C774\C9C0\C5D0 \C758\D574 \C0AC\C6A9\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280936465108869998)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \C560\D50C\B9AC\CF00\C774\C158\C744 \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280929005229869994)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \B2EC\B825 \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280932208448869995)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \B4DC\B9B4 \B2E4\C6B4 \BCF4\ACE0\C11C \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280991972939870036)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \B300\D654\C2DD \BCF4\ACE0\C11C \D398\C774\C9C0\B97C \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280935230453869997)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \BCF4\ACE0\C11C \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280722862830869870)
,p_name=>'CONFIRM.CREATE_FLASH_CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D50C\B798\C2DC \CC28\D2B8 \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282009137931870688)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \C791\C5C5\C601\C5ED\C5D0\C11C \AE30\C874 \B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158\ACFC \B3D9\C77C\D55C ID\B97C \C0AC\C6A9\D558\B294 \B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158\C744 \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \AE30\C874 \B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158\C774 \C0AD\C81C\B418\ACE0 \C0C8 \B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158\C73C\B85C \BC14\B01D\B2C8\B2E4. \C120\D0DD \D56D\BAA9\C744 \D655\C778\D558\C2ED\C2DC\C624. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281299981143870243)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D3FC \BC0F \BAA9\B85D \BCF4\AE30 \D398\C774\C9C0\B97C \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281211220446870186)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84\C11D \D398\C774\C9C0\B97C \C0AC\C6A9\D558\C5EC \D3FC \BC0F \BCF4\ACE0\C11C \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280928632097869993)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC SQL \C9C8\C758\C5D0 \D3FC\C744 \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280928528992869993)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \B0B4\C7A5 \D504\B85C\C2DC\C800\C5D0 \D3FC\C744 \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280928447355869993)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D14C\C774\BE14 \D398\C774\C9C0\C5D0 \D3FC\C744 \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280773953300869901)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \C6F9 \C11C\BE44\C2A4 \CC38\C870 \D398\C774\C9C0\C5D0 \D3FC\C744 \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280830775406869935)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D3FC\C744 \C0DD\C131\D558\ACE0 \C6F9 \C11C\BE44\C2A4 \CC38\C870 \D398\C774\C9C0\C5D0 \B300\D574 \BCF4\ACE0\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281240540672870205)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \B9F5 \D398\C774\C9C0\B97C \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280712910387869864)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \B9C8\C2A4\D130 \B514\D14C\C77C \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280930286835869994)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \C774\B3D9 \ACBD\B85C \C601\C5ED \BC0F \C774\B3D9 \ACBD\B85C \C635\C158\C744 \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281218583363870191)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131 \BAA8\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280928201345869993)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282084660010870734)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282084779388870735)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C774\B984 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280931033397869995)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D3FC \BC0F \BCF4\ACE0\C11C \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282005066332870686)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280935074346869997)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \BCF4\ACE0\C11C \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280928791472869993)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC HTML \B9C9\B300 \CC28\D2B8 \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280934682260869997)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \C694\C57D \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \B2E4\B978 \D398\C774\C9C0 \BC0F/\B610\B294 \C601\C5ED\C5D0\C11C \CD94\AC00 \D56D\BAA9\C744 \CD94\AC00\D558\B824\BA74 "\CD94\AC00" \B2E8\CD94\B97C \B204\B974\ACE0, \C694\C57D \D56D\BAA9\C744 \C0DD\C131\D558\B824\BA74 "\C644\B8CC"\B97C \B204\B974\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280928827832869994)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC SVG \CC28\D2B8 \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280928155485869993)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D45C \D615\C2DD \D3FC \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280929352330869994)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D2B8\B9AC \D398\C774\C9C0\B97C \C791\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280928392645869993)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \B9C8\BC95\C0AC\B97C \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C120\D0DD\C0AC\D56D\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282008727626870688)
,p_name=>'CONFIRM.CREATE_WS_APP_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \C791\C5C5\C601\C5ED\C5D0\C11C \AE30\C874 \C6F9 \C2DC\D2B8 \C560\D50C\B9AC\CF00\C774\C158\ACFC \B3D9\C77C\D55C ID\B97C \C0AC\C6A9\D558\B294 \C6F9 \C2DC\D2B8 \C560\D50C\B9AC\CF00\C774\C158\C744 \C0DD\C131\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \AE30\C874 \C6F9 \C2DC\D2B8 \C560\D50C\B9AC\CF00\C774\C158\C774 \C0AD\C81C\B418\ACE0 \C0C8 \C6F9 \C2DC\D2B8 \C560\D50C\B9AC\CF00\C774\C158\C73C\B85C \BC14\B01D\B2C8\B2E4. \C120\D0DD \D56D\BAA9\C744 \D655\C778\D558\C2ED\C2DC\C624. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281123050733870128)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C1\D06C \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281941790334870647)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \B85C\B4DC \C815\C758 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282016384390870693)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \B370\C774\D130 \B85C\B4DC \C815\C758\B294 \AE30\C874 \D14C\C774\BE14 \C870\D68C \BC0F \BCC0\D658 \ADDC\CE59\C744 \C0AC\C6A9\D558\C5EC \C7AC\C0DD\C131\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281393641861870306)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \BC88\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280929166669869994)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0A0\C9DC \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281218651672870191)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \C778\C99D \CCB4\ACC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280928054076869993)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AD\C81C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280932932080869996)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\BD80 %0 \D45C\C2DC \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280715945195869866)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B514\D14C\C77C \D45C\C2DC \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280934556924869997)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\BD80 \C774\B3D9 \ACBD\B85C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280933778683869996)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\BD80\C815\BCF4 \D14C\C774\BE14 %0 \C815\B82C \AE30\C900')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280932469475869996)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\BD80\C815\BCF4 \D398\C774\C9C0 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280715821857869866)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B514\D14C\C77C \D14C\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280932738849869996)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\BD80\C815\BCF4 \D14C\C774\BE14 \C774\B984 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280932570240869996)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C138\BD80 \D0ED \B808\C774\BE14 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281346126036870272)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B85C\B4DC \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280926149931869992)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281302851626870244)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B85C\B4DC \C5F4 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281302951506870245)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B85C\B4DC \C5F4 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280930494164869994)
,p_name=>'CONFIRM.DISPLAY_POINT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC \C9C0\C810')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282093560511870740)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282093631899870740)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C774\B984 \D3B8\C9D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281115998421870123)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_language=>'ko'
,p_message_text=>unistr('CSV \CD9C\B825')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281116672891870123)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD9C\B825 \C778\C1C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281117257322870124)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \BA38\B9AC\AE00 \C815\B82C \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281167140251870158)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\C874 \AD00\B9AC \D398\C774\C9C0\C5D0 \C601\C5ED\C774 \CD94\AC00\B429\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281345756688870272)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84\AE30 \C644\B8CC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280931557324869995)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280931685684869995)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \D398\C774\C9C0 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280931803806869995)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \D398\C774\C9C0 \D0ED \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280931792218869995)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \D398\C774\C9C0 \D0ED \C9D1\D569')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281218750232870191)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C\C5D0\C11C \ACF5\C720 \AD6C\C131\C694\C18C \C784\D3EC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281676227038870486)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758 \B2EC\B825 \D3EC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280716109374869866)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \BCF4\ACE0\C11C\B97C \D3EC\D568\C2DC\D0A4\ACA0\C2B5\B2C8\AE4C?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280934239372869997)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C \D3EC\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280925383167869991)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\BCF4 \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280925478027869992)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\BCF4 \AE30\BCF8 \D14D\C2A4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280774190373869901)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280818176732869927)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \C601\C5ED \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280818046446869927)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D3FC \C601\C5ED \C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280927807804869993)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0BD\C785')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280925111340869991)
,p_name=>'CONFIRM.ITEMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281346044177870272)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC18\D658 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281344916073870272)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\D68C \D0A4 \C5F4 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281345041691870272)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0A4 \C5F4 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281345171755870272)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0A4 \C5F4 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280929247954869994)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\B808\C774\BE14 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281303034600870245)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\D68C \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281345977390870272)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\D68C \D14C\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280716225527869866)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \B514\D14C\C77C \B808\C774\C544\C6C3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280715767584869866)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \D45C\C2DC \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280716052754869866)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \B808\CF54\B4DC \C774\B3D9 \AE30\C900')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280715685062869866)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9C8\C2A4\D130 \D14C\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281127398183870130)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300 \C5F4 \C218')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281122825002870127)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\B2F9 \D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281000605568870043)
,p_name=>'CONFIRM.MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280930711520869995)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C \B9C1\D06C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280934335496869997)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C \B8E8\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280930537727869994)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280930821420869995)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B3D9 \ACBD\B85C \D14D\C2A4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280848484055869945)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\C2DC \CC28\D2B8\B97C \C0C8 \D50C\B798\C2DC 6 \CC28\D2B8\B85C \C5C5\ADF8\B808\C774\B4DC\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C694\CCAD\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281212445129870187)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6_XML'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758 XML\C744 \AE30\C900\C73C\B85C \D50C\B798\C2DC \CC28\D2B8\B97C \C0C8 \D50C\B798\C2DC 6 \CC28\D2B8\B85C \C774\C804\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \D604\C7AC \D50C\B798\C2DC \CC28\D2B8\C640 \D50C\B798\C2DC 6 \CC28\D2B8 \C0AC\C774\C758 XML \AD6C\C870\AC00 \B2E4\B974\AE30 \B54C\BB38\C5D0 \C5C5\ADF8\B808\C774\B4DC\B41C \CC28\D2B8\AC00 \D45C\C2DC\B418\C9C0 \C54A\C2B5\B2C8\B2E4. \C0C8 XML \AD6C\C870\B97C \C0AC\C6A9\D558\B824\BA74 \C5C5\ADF8\B808\C774\B4DC\B41C \CC28\D2B8\C758 \C0AC\C6A9\C790\C815\C758 XML\C744 \C218\C815\D574\C57C \D569\B2C8\B2E4. \C694\CCAD \B0B4\C6A9\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280786787257869908)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5'
,p_message_language=>'ko'
,p_message_text=>unistr('\D50C\B798\C2DC \CC28\D2B8\B97C \C0C8 HTML5 \CC28\D2B8\B85C \C5C5\ADF8\B808\C774\B4DC\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C694\CCAD\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280786877148869908)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5_XML'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758 XML\C744 \AE30\C900\C73C\B85C \D50C\B798\C2DC \CC28\D2B8\B97C \C0C8 HTML5 \CC28\D2B8\B85C \C5C5\ADF8\B808\C774\B4DC\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \D604\C7AC \CC28\D2B8\C640 HTML5 \CC28\D2B8 \C0AC\C774\C758 XML \AD6C\C870\AC00 \B2E4\B974\AE30 \B54C\BB38\C5D0 \C5C5\ADF8\B808\C774\B4DC\B41C \CC28\D2B8\AC00 \D45C\C2DC\B418\C9C0 \C54A\C2B5\B2C8\B2E4. \C0C8 XML \AD6C\C870\B97C \C0AC\C6A9\D558\B824\BA74 \C5C5\ADF8\B808\C774\B4DC\B41C \CC28\D2B8\C758 \C0AC\C6A9\C790\C815\C758 XML\C744 \C218\C815\D574\C57C \D569\B2C8\B2E4. \C694\CCAD \B0B4\C6A9\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280786638258869908)
,p_name=>'CONFIRM.MIGRATE_HTML_TO_HTML5'
,p_message_language=>'ko'
,p_message_text=>unistr('HTML \CC28\D2B8\B97C \C0C8 HTML5 \CC28\D2B8\B97C \C5C5\ADF8\B808\C774\B4DC\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C694\CCAD\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282029586537870701)
,p_name=>'CONFIRM.MIGRATE_JSTREE_TO_APEXTREE'
,p_message_language=>'ko'
,p_message_text=>unistr('jsTree\B97C \C0C8 \D2B8\B9AC\B85C \C5C5\ADF8\B808\C774\B4DC\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C694\CCAD\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280914573341869985)
,p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('SVG \CC28\D2B8\B97C \C5C5\ADF8\B808\C774\B4DC\D560 \B54C\B294 \B2E4\C74C\ACFC \AC19\C740 \C81C\D55C \C0AC\D56D\C774 \C788\C2B5\B2C8\B2E4.  '),
'<ul>',
'<li>',
unistr('\CD95 \D615\C2DD \BB38\C790\C5F4\C5D0 \C815\C758\B41C \C22B\C790 \D615\C2DD\B9CC \C774\C804\B429\B2C8\B2E4. \B0A0\C9DC \BC0F \C2DC\AC04 \D615\C2DD\C740 \BB34\C2DC\B429\B2C8\B2E4.'),
'</li>',
'<li>',
unistr('\B2E4\C74C\C744 \D3EC\D568\D558\B294 \C22B\C790 \D615\C2DD \C694\C18C\B9CC \C774\C804\B429\B2C8\B2E4.'),
'<br />',
unistr('0,9,D,G,,(\CF64\B9C8),.(\B9C8\CE68\D45C),$,C,L,FM'),
'</li>',
'<li>',
unistr('\D50C\B798\C2DC \CC28\D2B8\C758 \AC01 \ACC4\C5F4\C5D0 \B300\D55C \B808\C774\BE14\C740 \AC01 \ACC4\C5F4\C758 \C5F4 \BCC4\CE6D\C5D0\C11C \D30C\C0DD\B429\B2C8\B2E4.  '),
unistr('\C774\B294 \AC01 \ACC4\C5F4\C758 \B808\C774\BE14\C774 \ACC4\C5F4 \C774\B984 \C18D\C131\C5D0\C11C \D30C\C0DD\B418\B294 SVG \CC28\D2B8\C640 \B2E4\B985\B2C8\B2E4.'),
'</li>',
'<li>',
unistr('\D50C\B798\C2DC \B2E4\C774\C5BC \CC28\D2B8\B294 \BC31\BD84\C728 \B300\C2E0 \C2E4\C81C \AC12\C744 \D45C\C2DC\D569\B2C8\B2E4.'),
'</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280869669139869958)
,p_name=>'CONFIRM.MIGRATE_SVG_TO_HTML5'
,p_message_language=>'ko'
,p_message_text=>unistr('SVG \CC28\D2B8\B97C HTML5 \CC28\D2B8\B85C \C5C5\ADF8\B808\C774\B4DC\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C694\CCAD\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282004874091870686)
,p_name=>'CONFIRM.NAVIGATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0D0\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280937102847869999)
,p_name=>'CONFIRM.NAV_BAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0D0\C0C9\D45C\C2DC\C904')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281655089243870473)
,p_name=>'CONFIRM.NAV_LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0D0\C0C9 \BA54\B274 \BAA9\B85D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281230341646870198)
,p_name=>'CONFIRM.NEW_ADMIN_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \AD00\B9AC \D398\C774\C9C0\AC00 \CD94\AC00\B429\B2C8\B2E4. \D398\C774\C9C0:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281028043323870062)
,p_name=>'CONFIRM.NEW_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280925943733869992)
,p_name=>'CONFIRM.NEW_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281402871770870313)
,p_name=>'CONFIRM.NEXT_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \B2E8\CD94 \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280924487804869991)
,p_name=>'CONFIRM.NO.TABSET.SELECTED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0\C5D0 \B300\D574 \C120\D0DD\B41C \D0ED \C9D1\D569\C774 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280925077099869991)
,p_name=>'CONFIRM.NO_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D15C\D50C\B9AC\D2B8 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280774226383869901)
,p_name=>'CONFIRM.OUTPUT_ITEMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD9C\B825 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280926367171869992)
,p_name=>'CONFIRM.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280923310137869990)
,p_name=>'CONFIRM.PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280936979729869998)
,p_name=>'CONFIRM.PAGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280923410407869990)
,p_name=>'CONFIRM.PAGE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280924399226869991)
,p_name=>'CONFIRM.PAGE_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280932866811869996)
,p_name=>'CONFIRM.PARENT_DISPLAY_COLS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\C704 \D45C\C2DC \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280930930708869995)
,p_name=>'CONFIRM.PARENT_MENU'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\C704 \C774\B3D9 \ACBD\B85C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280934457957869997)
,p_name=>'CONFIRM.PARENT_MENU_COL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\C704 \C774\B3D9 \ACBD\B85C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280933081987869996)
,p_name=>'CONFIRM.PARENT_ORDER_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\C704 \D14C\C774\BE14 \C815\B82C \AE30\C900')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280932395977869996)
,p_name=>'CONFIRM.PARENT_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\C704 \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280932658326869996)
,p_name=>'CONFIRM.PARENT_TABLE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\C704 \D14C\C774\BE14 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280924939720869991)
,p_name=>'CONFIRM.PARENT_TAB_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\C704 \D0ED \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280924899140869991)
,p_name=>'CONFIRM.PARENT_TAB_SET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C1\C704 \D0ED \C9D1\D569')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281027793744870062)
,p_name=>'CONFIRM.PARSING_SCHEMA'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\BB38\BD84\C11D \C2A4\D0A4\B9C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281036788471870068)
,p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\BD84 \D398\C774\C9C0 \C0C8\B85C\ACE0\CE68')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281402920212870313)
,p_name=>'CONFIRM.PREVIOUS_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804 \B2E8\CD94 \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280924262720869991)
,p_name=>'CONFIRM.PRIMARY_KEY'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \D0A4 \C5F4 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280931995275869995)
,p_name=>'CONFIRM.PRIMARY_KEY_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8 \D0A4 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281123133318870128)
,p_name=>'CONFIRM.PRINT_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD9C\B825 \D615\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281127586855870131)
,p_name=>'CONFIRM.PRINT_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C1C4 \B9C1\D06C \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281123201823870128)
,p_name=>'CONFIRM.PRINT_OUTPUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C778\C1C4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280926241593869992)
,p_name=>'CONFIRM.PROCESS_OPTIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B85C\C138\C2A4 \C635\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281122981894870127)
,p_name=>'CONFIRM.REGION_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280925229279869991)
,p_name=>'CONFIRM.REGION_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280923574165869990)
,p_name=>'CONFIRM.REGION_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED \C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280930314451869994)
,p_name=>'CONFIRM.REGION_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281027928038870062)
,p_name=>'CONFIRM.REMOVED_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\AC70\B41C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280932046944869995)
,p_name=>'CONFIRM.REPORT_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281145301530870143)
,p_name=>'CONFIRM.REPORT_IMPLEMENTATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \AD6C\D604')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280931155879869995)
,p_name=>'CONFIRM.REPORT_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280931280257869995)
,p_name=>'CONFIRM.REPORT_PAGE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \D398\C774\C9C0 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280931456315869995)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \D398\C774\C9C0 \D0ED \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280931306498869995)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_SET'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \D398\C774\C9C0 \D0ED \C9D1\D569')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280818306155869927)
,p_name=>'CONFIRM.REPORT_REGION_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C601\C5ED \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280818203403869927)
,p_name=>'CONFIRM.REPORT_REGION_TITLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \C601\C5ED \C81C\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280935340023869997)
,p_name=>'CONFIRM.REPORT_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF4\ACE0\C11C \D15C\D50C\B9AC\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280820863529869929)
,p_name=>'CONFIRM.ROW_VERSION_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \BC84\C804 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280935509888869998)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME1'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12: HTML(\D45C\C900)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280935837387869998)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME11'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12: \BAA8\C591 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280935919759869998)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME12'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12: \BAA8\C591 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281027544486870061)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME13'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12: \BAA8\C591 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281027680924870062)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME14'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12: \BAA8\C591 4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280818854440869928)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME15'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12: \BAA8\C591 5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280935619849869998)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME2'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12: \C138\B85C\D615 \BCF4\ACE0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280936066497869998)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME21'
,p_message_language=>'ko'
,p_message_text=>unistr('\C775\C2A4\D3EC\D2B8: CSV')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280936160973869998)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME22'
,p_message_language=>'ko'
,p_message_text=>unistr('\C775\C2A4\D3EC\D2B8: XML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280935712795869998)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME3'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12: \C138\B85C\D615 \BCF4\ACE0\C11C, \BAA8\C591 1(\B110 \C5F4 \D3EC\D568)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281027388395870061)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME4'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12: \C138\B85C\D615 \BCF4\ACE0\C11C, \BAA8\C591 2(\B110 \C5F4 \C81C\C678)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281027439243870061)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME5'
,p_message_language=>'ko'
,p_message_text=>unistr('\AE30\BCF8\AC12: \C138\B85C\D615 \BCF4\ACE0\C11C, \BAA8\C591 2(\B110 \C5F4 \D3EC\D568)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281346222540870272)
,p_name=>'CONFIRM.RULE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADDC\CE59 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281346404097870273)
,p_name=>'CONFIRM.RULE_SEQUENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\D000\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281346572970870273)
,p_name=>'CONFIRM.RULE_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\ADDC\CE59 \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280748077700869885)
,p_name=>'CONFIRM.RUN_SCRIPT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \C2A4\D06C\B9BD\D2B8\B97C \C2E4\D589\D558\B3C4\B85D \C694\CCAD\D588\C2B5\B2C8\B2E4. \C694\CCAD \B0B4\C6A9\C744 \D655\C778\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280930621890869995)
,p_name=>'CONFIRM.SEQUENCE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\D000\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280935462349869997)
,p_name=>'CONFIRM.SORT_OPTION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\B82C \C635\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280926549432869992)
,p_name=>'CONFIRM.SQL_QUERY'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C9C8\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281036676070870068)
,p_name=>'CONFIRM.STANDARD_CALENDAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C900')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281164844882870156)
,p_name=>'CONFIRM.STARTING_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C911 \D398\C774\C9C0\AC00 \C0DD\C131\B429\B2C8\B2E4. \C2DC\C791 \D398\C774\C9C0:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280926478174869992)
,p_name=>'CONFIRM.STORED_PROCEDURE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4\C7A5 \D504\B85C\C2DC\C800 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281029308601870063)
,p_name=>'CONFIRM.STORED_PROCEDURE_OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0B4\C7A5 \D504\B85C\C2DC\C800 \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281403101586870313)
,p_name=>'CONFIRM.SUBMIT_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\C644\B8CC \B2E8\CD94 \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282020355362870695)
,p_name=>'CONFIRM.SUBSCRIBE_THEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8 \C801\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280925749621869992)
,p_name=>'CONFIRM.SUGGESTED_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD8C\C7A5 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281211302339870186)
,p_name=>'CONFIRM.TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14/\BDF0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281211496885870186)
,p_name=>'CONFIRM.TABLE_COLS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4\BCC4 \C694\C57D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281430372277870333)
,p_name=>'CONFIRM.TABLE_LOOKUPS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C870\D68C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280923932432869991)
,p_name=>'CONFIRM.TABLE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280923821238869991)
,p_name=>'CONFIRM.TABLE_OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281602465657870441)
,p_name=>'CONFIRM.TABLE_RULE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\D658 \ADDC\CE59')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281346614400870273)
,p_name=>'CONFIRM.TABLE_RULES'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\D658 \ADDC\CE59')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281028251066870062)
,p_name=>'CONFIRM.TABLE_VIEW_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14/\BDF0 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281028173146870062)
,p_name=>'CONFIRM.TABLE_VIEW_OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14/\BDF0 \C18C\C720\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280937094753869999)
,p_name=>'CONFIRM.TABS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280924788049869991)
,p_name=>'CONFIRM.TABSET.INCOMPLETE'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACBD\ACE0: \D0ED \C9D1\D569 \C815\BCF4\AC00 \BD88\C644\C804\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280923789858869991)
,p_name=>'CONFIRM.TAB_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0ED \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280935117464869997)
,p_name=>'CONFIRM.TAB_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0ED \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280923650212869991)
,p_name=>'CONFIRM.TAB_SET'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0ED \C9D1\D569')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280936250938869998)
,p_name=>'CONFIRM.TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D15C\D50C\B9AC\D2B8:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280929966681869994)
,p_name=>'CONFIRM.TREE_LOV'
,p_message_language=>'ko'
,p_message_text=>unistr('\D31D\C5C5 \AC12 \BAA9\B85D\C744 \C0AC\C6A9\D558\B294 \C0C8 \D56D\BAA9\C744 \AE30\C900\C73C\B85C \D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280929644541869994)
,p_name=>'CONFIRM.TREE_MAX_LEVEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\B300 \B808\BCA8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280929478811869994)
,p_name=>'CONFIRM.TREE_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D2B8\B9AC \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280929819978869994)
,p_name=>'CONFIRM.TREE_QUERY'
,p_message_language=>'ko'
,p_message_text=>unistr('\D2B8\B9AC \C9C8\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280930046236869994)
,p_name=>'CONFIRM.TREE_SQL'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C9C8\C758 \AE30\BC18')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280929713751869994)
,p_name=>'CONFIRM.TREE_START'
,p_message_language=>'ko'
,p_message_text=>unistr('\D2B8\B9AC \C2DC\C791')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280930197423869994)
,p_name=>'CONFIRM.TREE_STATIC'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\C801 \AC12')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280929522636869994)
,p_name=>'CONFIRM.TREE_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D2B8\B9AC \C720\D615')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280937245821869999)
,p_name=>'CONFIRM.UI_THEME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280937366491869999)
,p_name=>'CONFIRM.UI_THEME1'
,p_message_language=>'ko'
,p_message_text=>unistr('\CCAD\AC08\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280937400220869999)
,p_name=>'CONFIRM.UI_THEME2'
,p_message_language=>'ko'
,p_message_text=>unistr('\BE68\AC04\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280937558874869999)
,p_name=>'CONFIRM.UI_THEME4'
,p_message_language=>'ko'
,p_message_text=>unistr('\B0A8\D68C\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280937631164869999)
,p_name=>'CONFIRM.UI_THEME5'
,p_message_language=>'ko'
,p_message_text=>unistr('\C62C\B9AC\BE0C\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280937793710869999)
,p_name=>'CONFIRM.UI_THEME6'
,p_message_language=>'ko'
,p_message_text=>unistr('\C801\AC08\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280937844773869999)
,p_name=>'CONFIRM.UI_THEME7'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\C21C \CCAD\AC08\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280937994225869999)
,p_name=>'CONFIRM.UI_THEME8'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\B780\C0C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280938083592869999)
,p_name=>'CONFIRM.UI_THEME_NONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280924174017869991)
,p_name=>'CONFIRM.UPDATEABLE_COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B370\C774\D2B8 \AC00\B2A5\D55C \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280927928822869993)
,p_name=>'CONFIRM.UPDATE_PROCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B370\C774\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280924687290869991)
,p_name=>'CONFIRM.USE.EXISTING.TABSET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \D398\C774\C9C0\B294 \AE30\C874 \D0ED \C9D1\D569 "%0"\C744(\B97C) \C0AC\C6A9\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280774070410869901)
,p_name=>'CONFIRM.WEB_SERVICE_REF'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C11C\BE44\C2A4 \CC38\C870, \C791\C5C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280932154939869995)
,p_name=>'CONFIRM.WHERE_CLAUSE'
,p_message_language=>'ko'
,p_message_text=>unistr('Where \C808')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281200789724870179)
,p_name=>'CONFIRMATION_ICON'
,p_message_language=>'ko'
,p_message_text=>unistr('\D655\C778 \C544\C774\CF58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281212888095870187)
,p_name=>'CONFIRMED'
,p_message_language=>'ko'
,p_message_text=>unistr('\D655\C778\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281213138190870187)
,p_name=>'CONFIRMED_BY_QA'
,p_message_language=>'ko'
,p_message_text=>unistr('QA \D655\C778\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281123444128870128)
,p_name=>'CONFIRM_BREAK_COLUMN'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\BD84 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281123348981870128)
,p_name=>'CONFIRM_PRINT_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C1C4 \D615\C2DD')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281241698173870205)
,p_name=>'CONTENT_DISPOSITION'
,p_message_language=>'ko'
,p_message_text=>unistr('\CF58\D150\CE20 \CC98\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281276836414870228)
,p_name=>'CONTENT_SERVED_IN_KBYTES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\ACF5\B41C \CF58\D150\CE20')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281114390366870122)
,p_name=>'CONTINUE'
,p_message_language=>'ko'
,p_message_text=>unistr('\ACC4\C18D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282153986233870777)
,p_name=>'CONTRIBUTORS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C81C\ACF5\C790')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282046549052870711)
,p_name=>'COPY.PAGE.NEW_STATIC_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \C815\C801 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280810741816869923)
,p_name=>'COPYRIGHT'
,p_message_language=>'ko'
,p_message_text=>'Copyright &copy; %0, All rights reserved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280869194486869958)
,p_name=>'COPY_APP_SUCCESS_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C774 \BCF5\C0AC\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281004742954870045)
,p_name=>'COPY_BUTTON.EXECUTION_ERR'
,p_message_language=>'ko'
,p_message_text=>unistr('copy_button\C744 \C2E4\D589\D558\B294 \C911 \C624\B958 \BC1C\C0DD: %0 >> %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281043615112870073)
,p_name=>'COPY_DEPLOYMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1D\CCB4 \C815\C758 \C18D\C131 \BCF5\C0AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280842472754869942)
,p_name=>'COPY_EXISTING_APP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \BCF5\C0AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281300752398870243)
,p_name=>'COPY_FEATURE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF5\C0AC \AE30\B2A5: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281043298213870072)
,p_name=>'COPY_FROM_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \BCF5\C0AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281477439678870364)
,p_name=>'COPY_FROM_APP_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D15C\D50C\B9AC\D2B8 \C560\D50C\B9AC\CF00\C774\C158 \AE30\BC18')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281043367338870072)
,p_name=>'COPY_FROM_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B984\C5D0\C11C \BCF5\C0AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280871315564869959)
,p_name=>'COPY_LIST_ENTRY'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA9\B85D \D56D\BAA9 \BCF5\C0AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281005118963870046)
,p_name=>'COPY_NAMED_LOV.EXECUTION_ERR'
,p_message_language=>'ko'
,p_message_text=>unistr('copy_named_lov\B97C \C2E4\D589\D558\B294 \C911 \C624\B958 \BC1C\C0DD: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281005067888870046)
,p_name=>'COPY_NAMED_LOV.NOT_FOUND_ERR'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12 \BAA9\B85D ID "%0"\C744(\B97C) \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281004911954870046)
,p_name=>'COPY_NAMED_LOV.NUMERIC_ERR'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC12 \BAA9\B85D ID "%0"\C740(\B294) \C22B\C790\AC00 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281281760105870231)
,p_name=>'COPY_PAGE.COPY_FROM_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\C5D0\C11C \BCF5\C0AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281281890863870231)
,p_name=>'COPY_PAGE.COPY_TO_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0\B85C \BCF5\C0AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281280736058870230)
,p_name=>'COPY_PAGE.SELECT_AUTHORIZATION'
,p_message_language=>'ko'
,p_message_text=>unistr('- \AD8C\D55C \BD80\C5EC \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281280613531870230)
,p_name=>'COPY_PAGE.SELECT_LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('- \BAA9\B85D \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281280518932870230)
,p_name=>'COPY_PAGE.SELECT_NAMED_LOV'
,p_message_language=>'ko'
,p_message_text=>unistr('- \AC12 \BAA9\B85D \C120\D0DD -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281352686518870277)
,p_name=>'COPY_TABLE'
,p_message_language=>'ko'
,p_message_text=>unistr('%1 \D14C\C774\BE14\C5D0 %0 \BCF5\C0AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281043436998870072)
,p_name=>'COPY_TO_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C73C\B85C \BCF5\C0AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281043510584870072)
,p_name=>'COPY_TO_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\B984\C73C\B85C \BCF5\C0AC')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280968909005870021)
,p_name=>'CORE'
,p_message_language=>'ko'
,p_message_text=>unistr('\CF54\C5B4')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281135851209870136)
,p_name=>'COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\C218')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281193654970870175)
,p_name=>'CREATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281439833264870340)
,p_name=>'CREATE APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281439948899870340)
,p_name=>'CREATE OBJECT'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1D\CCB4 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281649577698870470)
,p_name=>'CREATED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281649633409870470)
,p_name=>'CREATED_BY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281300453587870243)
,p_name=>'CREATED_LAST_7_DAYS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD5C\ADFC 7\C77C\AC04 \C0DD\C131\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281005889944870046)
,p_name=>'CREATED_ON'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0DD\C131 \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280842506552869942)
,p_name=>'CREATE_APP_FROM_TEMPLATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D15C\D50C\B9AC\D2B8\C5D0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281943724048870649)
,p_name=>'CREATE_APP_WIZ.CANDLE_CHARTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\CD1B\B300 \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281943597849870649)
,p_name=>'CREATE_APP_WIZ.COL_CHARTS'
,p_message_language=>'ko'
,p_message_text=>unistr('2D \BC0F 3D \C5F4, \B9C9\B300 \BC0F \B204\C801 \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281944233792870649)
,p_name=>'CREATE_APP_WIZ.GAUGE_CHARTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C774\C5BC \BC0F \B2E4\C774\C5BC(\D37C\C13C\D2B8) \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281943666437870649)
,p_name=>'CREATE_APP_WIZ.PIE_CHARTS'
,p_message_language=>'ko'
,p_message_text=>unistr('2D \BC0F 3D \D30C\C774 \BC0F \B3C4\B11B \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281943985909870649)
,p_name=>'CREATE_APP_WIZ.PROJECTGANTT_CHARTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B85C\C81D\D2B8 \AC04\D2B8 \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281944135853870649)
,p_name=>'CREATE_APP_WIZ.RANGE_CHARTS'
,p_message_language=>'ko'
,p_message_text=>unistr('2D \BC0F 3D \BC94\C704 \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281944002392870649)
,p_name=>'CREATE_APP_WIZ.RESOURCEGANTT_CHARTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B9AC\C18C\C2A4 \AC04\D2B8 \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281943862226870649)
,p_name=>'CREATE_APP_WIZ.SCATTER_CHARTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD84\C0B0 \D45C\C2DC\C790 \CC28\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280960849892870015)
,p_name=>'CREATE_CONDITION.AND'
,p_message_language=>'ko'
,p_message_text=>'AND'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280960655804870015)
,p_name=>'CREATE_CONDITION.ARROW_DOWN'
,p_message_language=>'ko'
,p_message_text=>unistr('\C544\B798\CABD \D654\C0B4\D45C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280960754778870015)
,p_name=>'CREATE_CONDITION.ARROW_RIGHT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C624\B978\CABD \D654\C0B4\D45C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280960445551870015)
,p_name=>'CREATE_CONDITION.COLUMNS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280960542366870015)
,p_name=>'CREATE_CONDITION.CONDITIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\AC74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280960990429870015)
,p_name=>'CREATE_CONDITION.OR'
,p_message_language=>'ko'
,p_message_text=>'OR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280961093919870015)
,p_name=>'CREATE_CONDITION.PREVIEW'
,p_message_language=>'ko'
,p_message_text=>unistr('\C870\AC74 \BBF8\B9AC\BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281301245241870243)
,p_name=>'CREATE_DEMO_APP.GRANT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\AE08 %0\C5D0\AC8C \D574\B2F9 \AD8C\D55C\C744 \BD80\C5EC\D558\B824\BA74 \C544\B798 <b>\AD8C\D55C \BD80\C5EC</b> \B2E8\CD94\B97C \B204\B974\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281301094968870243)
,p_name=>'CREATE_DEMO_APP.NO_CREATE_PRIV'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C740(\B294) CREATE TABLE, CREATE VIEW, CREATE TRIGGER, CREATE SEQUENCE \B610\B294 CREATE PROCEDURE \AD8C\D55C\C774 \C5C6\ACE0 \B370\BAA8 \C560\D50C\B9AC\CF00\C774\C158\C744 \C124\CE58\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281301145552870243)
,p_name=>'CREATE_DEMO_APP.NO_EXEC_PRIV'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('%0\C740(\B294) CTX_DOC \BC0F CTX_DDL\C5D0 \B300\D55C \C2E4\D589 \AD8C\D55C\C774 \C5C6\ACE0 \B300\D1B5\B839 \CDE8\C784 \C5F0\C124 \B370\BAA8\B97C \C124\CE58\D560 \C218 \C5C6\C2B5\B2C8\B2E4. \AD8C\D55C\C744 \AC00\C9C4 \C0AC\C6A9\C790\B85C \B2E4\C74C \AD8C\D55C \BD80\C5EC\B97C \C218\D589\D558\C2ED\C2DC\C624.'),
'<pre>',
'GRANT EXECUTE ON CTXSYS.CTX_DDL TO %0; ',
'GRANT EXECUTE ON CTXSYS.CTX_DOC TO %0;',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281647657581870469)
,p_name=>'CREATE_DIALOG_CLOSED_DA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E8\CD94 \C0DD\C131 - \B300\D654\C0C1\C790 \B2EB\D798')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280744980402869883)
,p_name=>'CREATE_DYNAMIC_LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3D9\C801 \BAA9\B85D \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281029028535870062)
,p_name=>'CREATE_DYNAMIC_LOV'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3D9\C801 \AC12 \BAA9\B85D \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280722942483869870)
,p_name=>'CREATE_FLOW.CLOUD_IDM'
,p_message_language=>'ko'
,p_message_text=>unistr('Oracle Cloud ID \AD00\B9AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280762452455869894)
,p_name=>'CREATE_FLOW.DBACCOUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \ACC4\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281466058012870357)
,p_name=>'CREATE_FLOW.HTMLDB_AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('Application Express \C778\C99D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281301632659870244)
,p_name=>'CREATE_FLOW.LDAP'
,p_message_language=>'ko'
,p_message_text=>'LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282004974719870686)
,p_name=>'CREATE_FLOW.NAVIGATION_LIST'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0D0\C0C9 \BA54\B274 \BAA9\B85D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281466104934870357)
,p_name=>'CREATE_FLOW.NO_AUTH'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281465701910870357)
,p_name=>'CREATE_FLOW.NO_TABS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0ED \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281465800184870357)
,p_name=>'CREATE_FLOW.ONE_LEVEL_TABS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D55C \B808\BCA8\C758 \D0ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281301719831870244)
,p_name=>'CREATE_FLOW.SSO'
,p_message_language=>'ko'
,p_message_text=>'SSO(Single Sign On)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281465909570870357)
,p_name=>'CREATE_FLOW.TWO_LEVEL_TABS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B450 \B808\BCA8\C758 \D0ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280842344351869942)
,p_name=>'CREATE_FROM_SPREADSHEET'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\D504\B808\B4DC\C2DC\D2B8\C5D0\C11C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280719301500869868)
,p_name=>'CREATE_GLOBAL_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C804\C5ED \D398\C774\C9C0 \AD6C\C131\C694\C18C\B294 \D574\B2F9 \C601\C5ED\C758 \D45C\C2DC \C9C0\C810\C774 \C120\D0DD\D55C \D398\C774\C9C0 \D15C\D50C\B9AC\D2B8 \B0B4\C5D0 \D3EC\D568\B418\B294 \ACBD\C6B0 \BAA8\B4E0 \D398\C774\C9C0\C5D0 \D45C\C2DC\B429\B2C8\B2E4. \C870\AC74\BD80 \D45C\C2DC \C18D\C131\C744 \C0AC\C6A9\D558\C5EC \D45C\C2DC\B418\C9C0 \C54A\B3C4\B85D \D560 \C218 \C788\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280994091300870038)
,p_name=>'CREATE_INDEX'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\B371\C2A4 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281149644585870146)
,p_name=>'CREATE_ITEM_WIZ.NO_REGION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F0\AD00\B41C \C601\C5ED \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280968661497870020)
,p_name=>'CREATE_NEW_LOGIN_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0C8 \B85C\ADF8\C778 \D398\C774\C9C0 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280962578538870016)
,p_name=>'CREATE_PACKAGE.BACK'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \C0DD\C131 \B9C8\BC95\C0AC\B85C \B3CC\C544\AC00\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280962026529870016)
,p_name=>'CREATE_PACKAGE.BROWSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D328\D0A4\C9C0 \CC3E\C544\BCF4\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280961912726870016)
,p_name=>'CREATE_PACKAGE.CREATED'
,p_message_language=>'ko'
,p_message_text=>unistr('"%1" \C2A4\D0A4\B9C8\C5D0 "%0" \D328\D0A4\C9C0\AC00 \C0DD\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280962639321870016)
,p_name=>'CREATE_PACKAGE.FAILED'
,p_message_language=>'ko'
,p_message_text=>unistr('"%0" \D14C\C774\BE14 \C0DD\C131\C744 \C2E4\D328\D588\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280962405718870016)
,p_name=>'CREATE_PACKAGE.HOME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D648')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280962298621870016)
,p_name=>'CREATE_PACKAGE.RETURN_TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3CC\C544\AC00\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280962382551870016)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL&nbsp;\C6CC\D06C\C20D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280962143852870016)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C6CC\D06C\C20D \D648')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280957870726870013)
,p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND'
,p_message_language=>'ko'
,p_message_text=>unistr('\D56D\BAA9\C744 \CC3E\C744 \C218 \C5C6\C74C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280957483580870013)
,p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280957706232870013)
,p_name=>'CREATE_PAGE_ITEM.PROMPT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D504\B86C\D504\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280957560789870013)
,p_name=>'CREATE_PAGE_ITEM.REGION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280957657515870013)
,p_name=>'CREATE_PAGE_ITEM.SET_REGION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED\C744 \C124\C815\D558\B824\BA74 \B204\B974\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280955576595870011)
,p_name=>'CREATE_PROCESS.PAGE_ITEMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D398\C774\C9C0 \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280955600787870011)
,p_name=>'CREATE_PROCESS.REGION'
,p_message_language=>'ko'
,p_message_text=>unistr('\C601\C5ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280961842440870016)
,p_name=>'CREATE_TABLE.HOME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D648')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280961629944870016)
,p_name=>'CREATE_TABLE.RETURN_TO'
,p_message_language=>'ko'
,p_message_text=>unistr('\B3CC\C544\AC00\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280961500382870015)
,p_name=>'CREATE_TABLE.RUN_SCRIPT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\D06C\B9BD\D2B8 \C2E4\D589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280961290919870015)
,p_name=>'CREATE_TABLE.SCRIPT_CREATED'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D14C\C774\BE14\C5D0 \B300\D55C \D14C\C774\BE14 \C0DD\C131 \C2A4\D06C\B9BD\D2B8\AC00 SQL \C2A4\D06C\B9BD\D2B8 \C800\C7A5\C18C\C5D0 \C0DD\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280961344119870015)
,p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2A4\D06C\B9BD\D2B8 \C800\C7A5\C18C\B85C \C774\B3D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280961774605870016)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL&nbsp;\C6CC\D06C\C20D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280961478039870015)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME'
,p_message_language=>'ko'
,p_message_text=>unistr('SQL \C6CC\D06C\C20D \D648')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281418698905870325)
,p_name=>'CREATE_TABULAR_FORM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C \D615\C2DD \D3FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282024234205870698)
,p_name=>'CREATE_TO_DO'
,p_message_language=>'ko'
,p_message_text=>unistr('\D560 \C77C \C0DD\C131')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281353422666870278)
,p_name=>'CREATE_TRIGGER'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \D2B8\B9AC\AC70 \C0DD\C131')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281291696937870237)
,p_name=>'CREATE_WS_OBJ_SUCCESS_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('\C6F9 \C2DC\D2B8 \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\AC00 \C0DD\C131\B418\C5C8\C2B5\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281243839270870207)
,p_name=>'CREDENTIAL.OWNER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C778\C99D\C11C \C18C\C720\C790')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281206250948870183)
,p_name=>'CSS_CALENDAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EC\B825')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281119182969870125)
,p_name=>'CURRENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281198004874870177)
,p_name=>'CURRENT ENTRY'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \D56D\BAA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281197719558870177)
,p_name=>'CURRENT FORM ELEMENT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \D3FC \C694\C18C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280981962421870030)
,p_name=>'CURRENT ITEM HELP TEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \D56D\BAA9 \B3C4\C6C0\B9D0 \D14D\C2A4\D2B8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281197803497870177)
,p_name=>'CURRENT ITEM IDENTIFICATION NUMBER'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \D56D\BAA9 \C2DD\BCC4 \BC88\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281197968423870177)
,p_name=>'CURRENT ITEM LABEL NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \D56D\BAA9 \B808\C774\BE14 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281256954932870215)
,p_name=>'CURRENT TAB'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \D0ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280943727915870003)
,p_name=>'CURRENT_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280950731725870008)
,p_name=>'CURRENT_IMAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \C774\BBF8\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281557492134870414)
,p_name=>'CURRENT_ITEM_CONTAINER_ID'
,p_message_language=>'ko'
,p_message_text=>unistr('[\B808\C774\BE14 \BC0F \D56D\BAA9 \C55E] \C18D\C131\C5D0\C11C \D604\C7AC \D544\B4DC\B97C \B458\B7EC\C2F8\B294 \CEE8\D14C\C774\B108 \C694\C18C\C5D0 \C0AC\C6A9\D560 \C218 \C788\B294 ID\C785\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282032744236870703)
,p_name=>'CURRENT_ITEM_HELP_LABEL'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \D56D\BAA9 \B3C4\C6C0\B9D0 \B808\C774\BE14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280909586295869982)
,p_name=>'CURRENT_MILESTONE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \B9C8\C77C\C2A4\D1A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280949887454870007)
,p_name=>'CURRENT_PAGE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \D398\C774\C9C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281224516255870194)
,p_name=>'CURRENT_PAGE_CONTAINS_NO_ITEMS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D604\C7AC \D398\C774\C9C0\C5D0 \D3EC\D568\B41C \D56D\BAA9\C774 \C5C6\C2B5\B2C8\B2E4.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281114964914870122)
,p_name=>'CUSTOM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281157639442870151)
,p_name=>'CUSTOMIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281193501612870175)
,p_name=>'CUSTOMIZE LINK'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758 \B9C1\D06C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281203173905870181)
,p_name=>'CUSTOMIZE.USER_PAGE_PREFS_RESET'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C0AC\C6A9\C790\C5D0 \B300\D574 \D398\C774\C9C0 \D658\ACBD\C124\C815\C774 \C7AC\C124\C815\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281203295398870181)
,p_name=>'CUSTOMIZE.USER_PREFS_CHANGED'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C0AC\C6A9\C790\C5D0 \B300\D574 \D658\ACBD\C124\C815\C774 \BCC0\ACBD\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281203095395870181)
,p_name=>'CUSTOMIZE.USER_PREFS_RESET'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C0AC\C6A9\C790\C5D0 \B300\D574 \D398\C774\C9C0 \D658\ACBD\C124\C815\C774 \C7AC\C124\C815\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281907431885870627)
,p_name=>'CUSTOM_APPLICATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758 \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280743843904869883)
,p_name=>'CUSTOM_AUTH_SCHEME_DESC'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1C\BC1C\C790\AC00 \C815\C758\B428')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280998288537870041)
,p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR'
,p_message_language=>'ko'
,p_message_text=>unistr('%0\C5D0 \C624\B958 \BC1C\C0DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280909781817869982)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \C138\C158 \B3D9\C548 \C0AC\C6A9\C790 \C2DD\BCC4\C790\B85C \C0AC\C6A9\D560 \BB38\C790\C5F4\C744 \C785\B825\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280909843921869982)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2'
,p_message_language=>'ko'
,p_message_text=>unistr('%0 \C0AC\C6A9\C790 \C774\B984 \BC0F \BE44\BC00\BC88\D638\B97C \C785\B825\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280909943167869982)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3'
,p_message_language=>'ko'
,p_message_text=>unistr('LDAP \D638\C2A4\D2B8\C5D0\C11C \D655\C778\C744 \C704\D55C \C0AC\C6A9\C790 \C774\B984 \BC0F \BE44\BC00\BC88\D638 \C785\B825: %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280910000494869982)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C2A4\D0A4\B9C8 \C0AC\C6A9\C790 \C774\B984 \BC0F \BE44\BC00\BC88\D638\B97C \C785\B825\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281676544093870486)
,p_name=>'CUSTOM_CALENDAR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C7AC\B85C\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281681658221870489)
,p_name=>'CUSTOM_CALENDAR.END_DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C885\B8CC \B0A0\C9DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281681515184870489)
,p_name=>'CUSTOM_CALENDAR.START_DATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2DC\C791 \B0A0\C9DC')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281354379250870278)
,p_name=>'DA.SET_VALUE.SQL.HELP_MSG'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>True \C791\C5C5\C774 SQL \BB38\C758 \C124\C815 \C720\D615\C774 \D3EC\D568\B41C \AC12 \C124\C815\C778 \ACBD\C6B0 SQL \BB38\C758 \C5F4 \C21C\C11C\C640 \B3D9\C77C\D55C \C21C\C11C\B85C \C601\D5A5\C744 \BC1B\B294 \C694\C18C\B97C \C815\C758\D574\C57C \D569\B2C8\B2E4. \C815\C758\D55C SQL \BB38\C740 \B2E4\C74C\ACFC \AC19\C2B5\B2C8\B2E4.</p>'),
'<pre>%0</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280915101744869985)
,p_name=>'DAILY'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\BCC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281132329713870134)
,p_name=>'DATA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281439407317870340)
,p_name=>'DATA WORKSHOP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \C6CC\D06C\C20D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281009813176870049)
,p_name=>'DATA.LOAD.ALL_COL_MAPPED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B4E0 %0\AC1C \C5F4\C774 \C790\B3D9\C73C\B85C %1 \D14C\C774\BE14\C5D0 \B9E4\D551\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281010664168870050)
,p_name=>'DATA.LOAD.APPEND_INCOMPLETE'
,p_message_language=>'ko'
,p_message_text=>unistr('<code>%0</code> \D14C\C774\BE14\C758 \B370\C774\D130\C5D0 <b id="incompl_success_row_count"></b>\AC1C\C758 \C0C8 \D589\C774 \CD94\AC00\B418\C5C8\C2B5\B2C8\B2E4. <b class="u-danger-text" id="incompl_fail_row_count"></b>\AC1C \D589\C774 \AC70\BD80\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281010259679870049)
,p_name=>'DATA.LOAD.APPEND_SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('<code>%0</code> \D14C\C774\BE14\C758 \B370\C774\D130\C5D0 <b id="success_row_count"></b>\AC1C\C758 \C0C8 \D589\C774 \CD94\AC00\B418\C5C8\C2B5\B2C8\B2E4!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281010445986870050)
,p_name=>'DATA.LOAD.APPEND_WARNING'
,p_message_language=>'ko'
,p_message_text=>unistr('<code>%0</code> \D14C\C774\BE14\C758 \B370\C774\D130\C5D0 <b id="err_success_row_count"></b>\AC1C\C758 \C0C8 \D589\C774 \CD94\AC00\B418\C5C8\C2B5\B2C8\B2E4. <b class="u-danger-text" id="err_fail_row_count"></b>\AC1C \D589\C774 \AC70\BD80\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280719864921869868)
,p_name=>'DATA.LOAD.CHOOSE_FILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C77C \C120\D0DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280757452362869891)
,p_name=>'DATA.LOAD.CONFIGURATION_SAVED'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\C131\C774 \C800\C7A5\B418\C5C8\C2B5\B2C8\B2E4!')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281009944385870049)
,p_name=>'DATA.LOAD.DEFINE_COL_MAPPING'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774 \B370\C774\D130\B97C %0 \D14C\C774\BE14\B85C \B85C\B4DC\D558\B824\BA74 \C5F4 \B9E4\D551\C744 \C815\C758\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280719753414869868)
,p_name=>'DATA.LOAD.DRAG_DROP_FILE_HERE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5EC\AE30\B85C \D30C\C77C \B04C\C5B4 \B193\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280719665555869868)
,p_name=>'DATA.LOAD.FILE_FORMATS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C6D0\B418\B294 \D615\C2DD CSV, XLSX, TXT, XML, JSON')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280720735534869869)
,p_name=>'DATA.LOAD.INVALID_FILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B85C\B4DC\B41C \D30C\C77C\C774 \BD80\C801\D569\D558\AC70\B098 \C798\BABB\B41C \D655\C7A5\C790\B97C \AC00\C9D1\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280889095708869970)
,p_name=>'DATA.LOAD.INVALID_SELECTOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD80\C801\D569\D55C XML \B610\B294 JSON \C120\D0DD\AE30\AC00 \C0AC\C6A9\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281437353649870339)
,p_name=>'DATA.LOAD.JOB_INTERMITTENTLY_FAILED'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \B85C\B4DC \C791\C5C5 \C2E4\D589\C774 \C608\AE30\CE58 \C54A\AC8C \C815\C9C0\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281361509795870283)
,p_name=>'DATA.LOAD.JOB_NAME'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \B85C\B4DC \C791\C5C5, \C791\C5C5\C601\C5ED %0: \D14C\C774\BE14 %1\C5D0 \B85C\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281010033892870049)
,p_name=>'DATA.LOAD.MAP_REMAINING_COLS'
,p_message_language=>'ko'
,p_message_text=>unistr('%0/%1\AC1C \C5F4\C774 \C790\B3D9\C73C\B85C %2 \D14C\C774\BE14\C5D0 \B9E4\D551\B418\C5C8\C2B5\B2C8\B2E4. \B0A8\C740 %3\AC1C \C5F4\C744 \AD6C\C131\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281355155563870279)
,p_name=>'DATA.LOAD.NO_FILE_CONTENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B85C\B4DC\B41C \D30C\C77C\C5D0\C11C \B370\C774\D130\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281355257668870279)
,p_name=>'DATA.LOAD.NO_WORKSHEET_CONTENTS'
,p_message_language=>'ko'
,p_message_text=>unistr('"%0" \C6CC\D06C\C2DC\D2B8\C5D0\C11C \B370\C774\D130\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280720126111869868)
,p_name=>'DATA.LOAD.NO_XLSX_FILE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C0\C815\B41C \D30C\C77C\C740 XLSX \D30C\C77C\C774 \C544\B2D9\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281401917310870312)
,p_name=>'DATA.LOAD.PASTED_DATA'
,p_message_language=>'ko'
,p_message_text=>unistr('\BD99\C5EC\B123\C740 \B370\C774\D130')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281010788213870050)
,p_name=>'DATA.LOAD.REPLACE_INCOMPLETE'
,p_message_language=>'ko'
,p_message_text=>unistr('<code>%0</code> \D14C\C774\BE14\C758 \B370\C774\D130\AC00 <b id="incompl_success_row_count"></b>\AC1C\C758 \C0C8 \D589\C73C\B85C \BC14\B00C\C5C8\C2B5\B2C8\B2E4. <b class="u-danger-text" id="incompl_fail_row_count"></b>\AC1C \D589\C774 \AC70\BD80\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281010308952870050)
,p_name=>'DATA.LOAD.REPLACE_SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('<code>%0</code> \D14C\C774\BE14\C758 \B370\C774\D130\AC00 <b id="success_row_count"></b>\AC1C\C758 \C0C8 \D589\C73C\B85C \BC14\B00C\C5C8\C2B5\B2C8\B2E4!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281010564801870050)
,p_name=>'DATA.LOAD.REPLACE_WARNING'
,p_message_language=>'ko'
,p_message_text=>unistr('<code>%0</code> \D14C\C774\BE14\C758 \B370\C774\D130\AC00 <b id="err_success_row_count"></b>\AC1C\C758 \C0C8 \D589\C73C\B85C \BC14\B00C\C5C8\C2B5\B2C8\B2E4. <b class="u-danger-text" id="err_fail_row_count"></b>\AC1C \D589\C774 \AC70\BD80\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281010173570870049)
,p_name=>'DATA.LOAD.SELECT_COLS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\B4DC\D560 \C5F4\C744 \C120\D0DD\D558\C2ED\C2DC\C624.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282017099048870693)
,p_name=>'DATABASE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281440031193870341)
,p_name=>'DATABASE BROWSER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \BE0C\B77C\C6B0\C800')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281955678997870656)
,p_name=>'DATABASE.DEMO.SAMPLE.APP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0D8\D50C \B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282017161559870693)
,p_name=>'DATABASE_APPLICATION'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280764142756869895)
,p_name=>'DATABASE_APPLICATIONS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280791951304869911)
,p_name=>'DATABASE_APPS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281286555780870234)
,p_name=>'DATABASE_APP_SUCCESS_MSG'
,p_message_language=>'ko'
,p_message_text=>unistr('<strong>%0</strong> \C560\D50C\B9AC\CF00\C774\C158\C774 \C131\ACF5\C801\C73C\B85C \C124\CE58\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281183497058870168)
,p_name=>'DATABASE_LINK'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B9C1\D06C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281236242054870202)
,p_name=>'DATABASE_OBJECT_COUNTS_BY_TYPE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC1D\CCB4 \C720\D615\BCC4 \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4 \C218')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281239467017870204)
,p_name=>'DATABASE_ROLE_PRIVILEGES'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B864 \AD8C\D55C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280786455053869908)
,p_name=>'DATABASE_USERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281347105844870273)
,p_name=>'DATA_GRID'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \ADF8\B9AC\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281946262795870650)
,p_name=>'DATA_GRIDS'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \ADF8\B9AC\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281946798618870651)
,p_name=>'DATA_GRID_DATA'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \ADF8\B9AC\B4DC \B370\C774\D130')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281936797159870645)
,p_name=>'DATA_LOAD.ADVANCED_SETTINGS_REGION'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \B85C\B4DC \ACE0\AE09 \C124\C815')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280873333809869960)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\D560 \B0A0\C9DC/\C22B\C790 \D615\C2DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280873480874869960)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT_HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C0AC\C6A9\C790\C815\C758 \D615\C2DD \B9C8\C2A4\D06C\B97C \C81C\ACF5\D560\C9C0 \B610\B294 \D45C\C900 \D615\C2DD \B9C8\C2A4\D06C\B97C \C0AC\C6A9\D560\C9C0 \C120\D0DD\D569\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280787827069869909)
,p_name=>'DATA_LOAD.CHARSET'
,p_message_language=>'ko'
,p_message_text=>unistr('\D30C\C77C \BB38\C790\C138\D2B8 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281428040584870332)
,p_name=>'DATA_LOAD.COLUMN_NAMES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281426569237870331)
,p_name=>'DATA_LOAD.COLUMN_NAMES_MAPPING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C0C1 \C5F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281284686779870233)
,p_name=>'DATA_LOAD.COLUMN_NAME_ALIASES'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5F4 \C774\B984 \BCC4\CE6D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281641001869870465)
,p_name=>'DATA_LOAD.CONFIRM'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\AC00 \D14C\C774\BE14\C5D0 \C131\ACF5\C801\C73C\B85C \C5C5\B85C\B4DC\B418\C5C8\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281648390929870469)
,p_name=>'DATA_LOAD.COPY_PASTE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCF5\C0AC \BC0F \BD99\C5EC\B123\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281634697666870461)
,p_name=>'DATA_LOAD.COPY_PASTE_TEXTAREA'
,p_message_language=>'ko'
,p_message_text=>unistr('\AD6C\BD84 \B370\C774\D130 \BCF5\C0AC \BC0F \BD99\C5EC\B123\AE30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281977015381870669)
,p_name=>'DATA_LOAD.CURRENCY_ITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\D1B5\D654 \AE30\D638')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281977160998870669)
,p_name=>'DATA_LOAD.CURRENCY_ITEM_HELP'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130\AC00 \AD6D\C81C \D1B5\D654 \AE30\D638\B97C \D3EC\D568\D558\B294 \ACBD\C6B0 \C5EC\AE30\C5D0 \D574\B2F9 \AE30\D638\B97C \C785\B825\D558\C2ED\C2DC\C624. \C608\B97C \B4E4\C5B4, \B370\C774\D130\AC00 "&euro;1,234.56" \B610\B294 "&yen;1,234.56"\C744 \D3EC\D568\D558\B294 \ACBD\C6B0 "&euro;" \B610\B294 "&yen;"\C744 \C785\B825\D558\C2ED\C2DC\C624. \ADF8\B807\C9C0 \C54A\C73C\BA74 \B370\C774\D130\AC00 \C81C\B300\B85C \B85C\B4DC\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280792848899869912)
,p_name=>'DATA_LOAD.DATA_LOADING'
,p_message_language=>'ko'
,p_message_text=>unistr('\B370\C774\D130 \B85C\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281936861965870645)
,p_name=>'DATA_LOAD.DATE_FORMAT_APP'
,p_message_language=>'ko'
,p_message_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \D45C\C900 \D615\C2DD \B9C8\C2A4\D06C \C0AC\C6A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281936910866870645)
,p_name=>'DATA_LOAD.DATE_FORMAT_CUSTOM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B85C\B4DC\B41C \C5F4\C5D0 \B300\D55C \C0AC\C6A9\C790\C815\C758 \D615\C2DD \C81C\ACF5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281978695740870670)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_HELP'
,p_message_language=>'ko'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C18C\C218\C810 \BB38\C790\B294 \C22B\C790\C758 \C815\C218 \BD80\BD84\ACFC \C18C\C218 \BD80\BD84\C744 \AD6C\BD84\D569\B2C8\B2E4.</p>'),
unistr('<p> \C18C\C218\C810 \BB38\C790\B85C \C5B4\B5A4 \BB38\C790\B4E0 \C0AC\C6A9\D560 \C218 \C788\C2B5\B2C8\B2E4. \C18C\C218\C810 \BB38\C790\B294 \B2E8\C77C \BC14\C774\D2B8\B85C \C9C0\C815\D574\C57C \D558\ACE0 \ADF8\B8F9 \AD6C\BD84 \AE30\D638\C640 \B2EC\B77C\C57C \D569\B2C8\B2E4. \ACF5\BC31\C740 \BB38\C790\B85C \AC04\C8FC\D558\C9C0\B9CC \C22B\C790\B098 \B2E4\C74C \BB38\C790\B294 \C0AC\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4.</p>'),
'<ul class="noIndent">',
unistr('<li>\D50C\B7EC\C2A4 \AE30\D638(+)</li>'),
unistr('<li>\D558\C774\D508(-)</li> '),
unistr('<li>\C5EC\B294 \AEBE\C1E0 \AE30\D638(<)</li>'),
unistr('<li>\B2EB\B294 \AEBE\C1E0 \AE30\D638(>)</li> '),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281977704710870669)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_ITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C18C\C218\C810 \BB38\C790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281284820659870233)
,p_name=>'DATA_LOAD.DISPLAY'
,p_message_language=>'ko'
,p_message_text=>unistr('\D45C\C2DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281427915038870332)
,p_name=>'DATA_LOAD.DO_NOT_LOAD'
,p_message_language=>'ko'
,p_message_text=>unistr('\B85C\B4DC \C548\D568')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281972658389870666)
,p_name=>'DATA_LOAD.FAILED'
,p_message_language=>'ko'
,p_message_text=>unistr('\C120\D589 \CC98\B9AC \C624\B958')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281885144045870613)
,p_name=>'DATA_LOAD.FAILED_COUNT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D328\D55C \D589:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281956661402870657)
,p_name=>'DATA_LOAD.FAILED_RECORD'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D328\D55C \B808\CF54\B4DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(281976622542870669)
,p_name=>'DATA_LOAD.FILE_NAME_ITEM'
,p_message_language=>'ko'
,p_message_text=>unistr('\C5C5\B85C\B4DC\D560 \D30C\C77C\C758 \C774\B984')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id