prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4508
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4508 - Oracle APEX SQL Workshop
--
-- Application Export:
--   Application:     4508
--   Name:            Oracle APEX SQL Workshop
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                    274
--       Items:                  987
--       Computations:           198
--       Validations:            213
--       Processes:              414
--       Regions:                994
--       Buttons:                490
--       Dynamic Actions:        131
--     Shared Components:
--       Logic:
--         Items:                 19
--         Processes:             34
--         Computations:           2
--         Build Options:          8
--       Navigation:
--         Lists:                 73
--         Breadcrumbs:            2
--           Entries:            162
--         NavBar Entries:         3
--       Security:
--         Authentication:         1
--         Authorization:         19
--       User Interface:
--         Templates:
--           Page:                22
--           Region:              45
--           Label:               13
--           List:                25
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           2
--           Button:               8
--           Report:              22
--         LOVs:                 174
--         Shortcuts:              8
--         Plug-ins:              15
--       Globalization:
--         Messages:              28
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX SQL Workshop')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286627592118930677')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20191024135342'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'ko'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&G_USER_DEFAULT_DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(539837904309662819.4508)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'S'
,p_runtime_api_usage=>'O:W'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'PRODUCT_NAME'
,p_substitution_value_01=>'Application Express'
,p_substitution_string_02=>'LOGOUT'
,p_substitution_value_02=>unistr('\B85C\ADF8\C544\C6C3')
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>unistr('\C791\C5C5\C601\C5ED: &COMPANY.')
,p_substitution_string_04=>'MSG_LANGUAGE'
,p_substitution_value_04=>unistr('\C5B8\C5B4')
,p_substitution_string_05=>'MSG_COPYRIGHT'
,p_substitution_value_05=>'Copyright &copy; 1999, 2019, Oracle. All rights reserved.'
,p_substitution_string_06=>'MSG_USER'
,p_substitution_value_06=>unistr('\C0AC\C6A9\C790')
,p_substitution_string_07=>'MSG_JSCRIPT'
,p_substitution_value_07=>unistr('\C774 \C81C\D488\C740 JavaScript\AC00 \C0AC\C6A9\C73C\B85C \C124\C815\B41C \C0C1\D0DC\C5D0\C11C \C2E4\D589\D574\C57C \D569\B2C8\B2E4.')
,p_substitution_string_08=>'MSG_TBL_SUMMARY'
,p_substitution_value_08=>unistr('\D398\C774\C9C0 \B808\C774\C544\C6C3 \D14C\C774\BE14')
,p_substitution_string_09=>'EDIT'
,p_substitution_value_09=>unistr('\D3B8\C9D1')
,p_substitution_string_10=>'DONE'
,p_substitution_value_10=>unistr('\C644\B8CC')
,p_substitution_string_11=>'TOP'
,p_substitution_value_11=>unistr('\CD5C\C0C1\C704')
,p_substitution_string_12=>'CLOSE'
,p_substitution_value_12=>unistr('\B2EB\AE30')
,p_substitution_string_13=>'DATE_FORMAT'
,p_substitution_value_13=>'rr/mm/dd'
,p_substitution_string_14=>'LONG_DATE_FORMAT'
,p_substitution_value_14=>unistr('fmDay yyyy"\B144"mm"\C6D4"dd"\C77C"')
,p_substitution_string_15=>'TIME_FORMAT'
,p_substitution_value_15=>'AM hh:mi:ss'
,p_substitution_string_16=>'DATE_TIME_FORMAT'
,p_substitution_value_16=>'rr/mm/dd AM hh:mi:ss'
,p_substitution_string_17=>'RETURN_TO_APPLICATION'
,p_substitution_value_17=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C73C\B85C \B3CC\C544\AC00\AE30')
,p_substitution_string_18=>'HELP'
,p_substitution_value_18=>unistr('\B3C4\C6C0\B9D0')
,p_substitution_string_19=>'MSG_WORKSPACE'
,p_substitution_value_19=>unistr('\C791\C5C5\C601\C5ED')
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141304'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/sql_command_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(996508348031635.4508)
,p_name=>'SQL Command Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(996930166037917.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\ACB0\ACFC')
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="result_tab" onclick="html_TabClick(this,''resultsHolder'');return false;"'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(997202592039442.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C124\BA85')
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="explain_tab" onclick="sc_getPlan();html_TabClick(this,''explainHolder'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22157207203570630.4508)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\C790\C138\D788 \C54C\C544\BCF4\AE30')
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="describe_tab" onclick="sc_getDesc();html_TabClick(this,''describeHolder'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'139'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(997509865041519.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C800\C7A5\B41C SQL')
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="savedsql_tab" onclick="sc_getSavedSQL();html_TabClick(this,''SavedSQLHolder'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23661510949786902.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\B0B4\C5ED')
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="history_tab" onclick="sc_DisplayHist();html_TabClick(this,''historyHolder'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/qb_sub_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1390719147195878.4508)
,p_name=>'QB_SUB_TABS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1391928151198404.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C870\AC74')
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="cond_tab" onclick="html_TabClick(this,''conditionsHolder'');return false;"'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1395101055209596.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="sql_tab" onclick="qb_postState();qb_genSql();html_TabClick(this,''queryText_table'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1395705903210915.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\ACB0\ACFC')
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="result_tab" onclick="qb_genSql();html_TabClick(this,''queryResults_table'');qb_checkQuery();return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(159965504417193520.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C800\C7A5\B41C SQL')
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="SavedSql_tab" onclick="qb_getSavedSQL();html_TabClick(this,''SavedSQLHolder'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/query_builder_link_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1993413324492056.4508)
,p_name=>'Query_Builder_Link_Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1994823151504371.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C624\B978\CABD \D3EC\AD04 \C870\C778 \C124\C815')
,p_list_item_link_target=>'javascript:qb_outer(''R'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1994516571502453.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C67C\CABD \D3EC\AD04 \C870\C778 \C124\C815')
,p_list_item_link_target=>'javascript:qb_outer(''L'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1994208260500093.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C870\C778 \C0AD\C81C')
,p_list_item_link_target=>'javascript:qb_delLinkClick();'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1993900988497974.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\D3EC\AD04 \C870\C778 \C124\C815 \D574\C81C')
,p_list_item_link_target=>'javascript:qb_outer(''E'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/qb_query_quick_results_pg_111
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(3531801850564253.4508)
,p_name=>'QB Query Quick Results (pg 111)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3532824014570648.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'#'
,p_list_text_01=>'id="sql_tab" onclick="html_TabClick(this,''QuerySQL'');return false;"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_table_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6375626175414380.4508)
,p_name=>'OB_TABLE_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14784603224538632.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\C5F4 \CD94\AC00')
,p_list_item_link_target=>'f?p=&APP_ID.:66:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,ADD_COLUMN:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6380827392452521.4508)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\C5F4 \C218\C815')
,p_list_item_link_target=>'f?p=&APP_ID.:71:&SESSION.::&DEBUG.:79,66,71:F4500_LAST_VIEW,OB_OBJECT_NAME,P67_ACTION:2100,&OB_OBJECT_NAME.,MODIFY_COLUMN:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14815409906673027.4508)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('\C5F4 \C774\B984 \BC14\AFB8\AE30')
,p_list_item_link_target=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.:76,79,66:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,RENAME_COLUMN:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14813828822669058.4508)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\C5F4 \C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:72:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,DROP_COLUMN:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15094617459545746.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C774\B984 \BC14\AFB8\AE30')
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.:73,79,66:F4500_LAST_VIEW:&APP_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14866912181862952.4508)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>unistr('\BCF5\C0AC')
,p_list_item_link_target=>'f?p=&APP_ID.:93:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW:&APP_PAGE_ID.:'
,p_list_text_01=>'DEBUG.:79,66:F4500_LAST_VIEW,P70_ACTION:&APP_PAGE_ID.,RENAME_COLUMN:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6381509169456787.4508)
,p_list_item_display_sequence=>12
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::P102_OWNER,P102_ON,P102_ot:&OB_SCHEMA.,&OBJECT_NAME.,&OBJECT_TYPE.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10493511347365375.4508)
,p_list_item_display_sequence=>13
,p_list_item_link_text=>unistr('\C790\B974\AE30')
,p_list_item_link_target=>'f?p=&APP_ID.:67:&SESSION.::&DEBUG.::F4500_LAST_VIEW,P102_OWNER,P102_ON,P102_ot,P67_ACTION:&APP_PAGE_ID.,&OB_SCHEMA.,&OBJECT_NAME.,&OBJECT_TYPE.,TRUNCATE:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(106666107378742202.4508)
,p_list_item_display_sequence=>104
,p_list_item_link_text=>unistr('\C870\D68C \D14C\C774\BE14 \C0DD\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:RP,101,103:F4500_LAST_VIEW:&APP_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(581934538126106898.4508)
,p_list_item_display_sequence=>114
,p_list_item_link_text=>unistr('\C571 \C0DD\C131')
,p_list_item_link_target=>'#'');apex.util.getTopApex().navigation.redirect(''f?p=4500:50:&APP_SESSION.::&DEBUG.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_index_subtab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(7770017698212372.4508)
,p_name=>'OB_INDEX_SUBTAB'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7771200298226202.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AC1D\CCB4 \C138\BD80\C815\BCF4')
,p_list_item_link_target=>'f?p=&APP_ID.:INDEX_DETAIL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2200'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15785230925715068.4508)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\D1B5\ACC4')
,p_list_item_link_target=>'f?p=&APP_ID.:159:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NOT_EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from ',
' sys.dba_indexes',
'where owner = :OB_SCHEMA',
'and  index_name = :OBJECT_NAME',
'and ITYP_NAME = ''CONTEXT'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'159'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7771509648228988.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:INDEX_DDL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2201'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_database_link_subtab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(7818718708685757.4508)
,p_name=>'OB_DATABASE_LINK_SUBTAB'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7819707196701396.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AC1D\CCB4 \C138\BD80\C815\BCF4')
,p_list_item_link_target=>'f?p=&APP_ID.:DATABASE_LINK_DETAIL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2600:2602'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15731419001550744.4508)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\C885\C18D\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:108:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'108'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7824710153815728.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:DATABASE_LINK_DDL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2601'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_plsql_object_subtab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(8047123559654396.4508)
,p_name=>'OB_PLSQL_OBJECT_SUBTAB'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(111089013465719206.4508)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\C0AC\C591')
,p_list_item_link_target=>'f?p=&APP_ID.:2250:&SESSION.::&DEBUG.::OBJECT_TYPE:PACKAGE:'
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'OBJECT_TYPE'
,p_list_item_disp_condition2=>'PACKAGE:PACKAGE BODY'
,p_list_item_current_type=>'PLSQL_EXPRESSION'
,p_list_item_current_for_pages=>':OBJECT_TYPE=''PACKAGE'' and :FLOW_PAGE_ID = 2250'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(111089623161722027.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\BCF8\BB38')
,p_list_item_link_target=>'f?p=&APP_ID.:2250:&SESSION.::&DEBUG.::OBJECT_TYPE:PACKAGE BODY:'
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'OBJECT_TYPE'
,p_list_item_disp_condition2=>'PACKAGE:PACKAGE BODY'
,p_list_item_current_type=>'PLSQL_EXPRESSION'
,p_list_item_current_for_pages=>':OBJECT_TYPE=''PACKAGE BODY'' and :FLOW_PAGE_ID = 2250'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(8047607413659153.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\CF54\B4DC')
,p_list_item_link_target=>'f?p=&APP_ID.:FUNCTION_DETAIL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_NOT_IN_COLON_DELIMITED_LIST'
,p_list_item_disp_condition=>'OBJECT_TYPE'
,p_list_item_disp_condition2=>'PACKAGE:PACKAGE BODY'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2250'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(8047915378661444.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C885\C18D\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:FUNCTION_DEPENDENCIES:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2251'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(8048710923688553.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C624\B958')
,p_list_item_link_target=>'f?p=&APP_ID.:FUNCTION_ERRORS:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_for_pages=>'2252'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(8049120273691243.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\AD8C\D55C \BD80\C5EC')
,p_list_item_link_target=>'f?p=&APP_ID.:FUNCTION_GRANTS:&SESSION.::&DEBUG.:RP:::'
,p_security_scheme=>wwv_flow_api.id(7676404413799609)
,p_list_item_current_for_pages=>'2253'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(256800835086660869.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'REST'
,p_list_item_link_target=>'f?p=&APP_ID.:OBJECT_REST:&SESSION.::&DEBUG.:2111:::'
,p_required_patch=>wwv_flow_api.id(256109433659228165.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_types_subtab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(9111807762217267.4508)
,p_name=>'OB_TYPES_SUBTAB'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9191504112452724.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AC1D\CCB4 \C138\BD80\C815\BCF4')
,p_list_item_link_target=>'f?p=&APP_ID.:TYPE_DETAIL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2550'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9191907921453811.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\B3D9\C758\C5B4')
,p_list_item_link_target=>'f?p=&APP_ID.:TYPE_SYNONYM:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2551'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9192311731454913.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\AD8C\D55C \BD80\C5EC')
,p_list_item_link_target=>'f?p=&APP_ID.:TYPE_GRANTS:&SESSION.::&DEBUG.:RP:::'
,p_security_scheme=>wwv_flow_api.id(7676404413799609)
,p_list_item_current_for_pages=>'2552'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9193216925456442.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:TYPE_SQL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_trigger_subtab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(9213221268571230.4508)
,p_name=>'OB_TRIGGER_SUBTAB'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9214015512579070.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\AC1D\CCB4 \C138\BD80\C815\BCF4')
,p_list_item_link_target=>'f?p=&APP_ID.:TRIGGER_DETAIL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2500'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(275740605529762351.4508)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\CF54\B4DC')
,p_list_item_link_target=>'f?p=&APP_ID.:2250:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2250'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(276042225267818298.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'DO NOT TRANSLATE: Dummy Child'
,p_parent_list_item_id=>wwv_flow_api.id(275740605529762351.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9214705946585712.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C624\B958')
,p_list_item_link_target=>'f?p=&APP_ID.:TRIGGER_ERRORS:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_for_pages=>'2501'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9213709971577495.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:TRIGGER_SQL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2503'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_synonym_subtab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(9225416906655157.4508)
,p_name=>'OB_SYNONYM_SUBTAB'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9225829027658622.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AC1D\CCB4 \C138\BD80\C815\BCF4')
,p_list_item_link_target=>'f?p=&APP_ID.:SYNONYM_DETAIL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2450'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_procedure_subtab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(9233300162716512.4508)
,p_name=>'OB_PROCEDURE_SUBTAB'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9233824403723509.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\CF54\B4DC')
,p_list_item_link_target=>'f?p=&APP_ID.:PROCEDURE_DETAIL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2350'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_sequence_subtab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(9285616718241773.4508)
,p_name=>'OB_SEQUENCE_SUBTAB'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9296219694507531.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AC1D\CCB4 \C138\BD80\C815\BCF4')
,p_list_item_link_target=>'f?p=&APP_ID.:SEQUENCE_DETAIL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2400'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9301004681569422.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\AD8C\D55C \BD80\C5EC')
,p_list_item_link_target=>'f?p=&APP_ID.:SEQUENCE_GRANTS:&SESSION.::&DEBUG.:RP:::'
,p_security_scheme=>wwv_flow_api.id(7676404413799609)
,p_list_item_current_for_pages=>'2401'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9303226152575623.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C885\C18D\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:SEQUENCE_USED:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2403'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9303503081578415.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:SEQUENCE_SQL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_view_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10264324489517545.4508)
,p_name=>'OB_VIEW_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10266511460523224.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::P102_OWNER,P102_ON,P102_OT:&OB_SCHEMA.,&OBJECT_NAME.,&OBJECT_TYPE.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10265705919521633.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\CEF4\D30C\C77C')
,p_list_item_link_target=>'f?p=&APP_ID.:VIEW_DETAIL:&SESSION.:COMPILE:&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_plsql_object_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10281517394553333.4508)
,p_name=>'OB_PLSQL_OBJECT_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10282722935554923.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\C800\C7A5 \BC0F \CEF4\D30C\C77C')
,p_list_item_link_target=>'javascript:doCompile();'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_sw_util.show_plsql_edit(:flow_security_group_id)'
,p_list_item_current_type=>'NEVER'
,p_list_item_current_for_pages=>'2250'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10284704365559051.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\C18C\C2A4 \B2E4\C6B4\B85C\B4DC')
,p_list_item_link_target=>'javascript:downloadCode();'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10283527783556343.4508)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=4500:102:&SESSION.::NO::P102_OWNER,P102_ON,P102_OT,F4500_LAST_VIEW:&OB_SCHEMA.,&OBJECT_NAME.,&OBJECT_TYPE.,&APP_PAGE_ID.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_sw_util.show_plsql_edit(:flow_security_group_id)'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_index_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10296931855576458.4508)
,p_name=>'OB_INDEX_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10631027987221732.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815')
,p_list_item_link_target=>'f?p=&APP_ID.:INDEX_DETAIL:&SESSION.:DISABLE:&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10299413631580642.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::P102_OWNER,P102_ON,P102_OT:&OB_SCHEMA.,&OBJECT_NAME.,&OBJECT_TYPE.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10298910168579638.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C7AC\C0DD\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:INDEX_DETAIL:&SESSION.:REBUILD:&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_sequence_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10306018611591561.4508)
,p_name=>'OB_SEQUENCE_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10633408987244636.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\BCC0\ACBD')
,p_list_item_link_target=>'f?p=&APP_ID.:179:&SESSION.:ALTER:&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10307324498593269.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::P102_OWNER,P102_ON,P102_OT:&OB_SCHEMA.,&OBJECT_NAME.,&OBJECT_TYPE.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_synonym_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10312125668603017.4508)
,p_name=>'OB_SYNONYM_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10312730862604563.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::P102_OWNER,P102_ON,P102_OT:&OB_SCHEMA.,&OBJECT_NAME.,&OBJECT_TYPE.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_trigger_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10314911600608476.4508)
,p_name=>'OB_TRIGGER_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10634920546257449.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\B2E4\C6B4\B85C\B4DC')
,p_list_item_link_target=>'f?p=&APP_ID.:147:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10317125453612414.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::P102_OWNER,P102_ON,P102_OT:&OB_SCHEMA.,&OBJECT_NAME.,&OBJECT_TYPE.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10316220604611044.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\CEF4\D30C\C77C')
,p_list_item_link_target=>'f?p=&APP_ID.:2500:&SESSION.:COMPILE:&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10319109307617252.4508)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815')
,p_list_item_link_target=>'f?p=&APP_ID.:2500:&SESSION.:DISABLE:&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P2500_STATUS'
,p_list_item_disp_condition2=>'ENABLED'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10318130301613878.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C0AC\C6A9\C73C\B85C \C124\C815')
,p_list_item_link_target=>'f?p=&APP_ID.:2500:&SESSION.:ENABLE:&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P2500_STATUS'
,p_list_item_disp_condition2=>'DISABLED'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_types_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10323630778623422.4508)
,p_name=>'OB_TYPES_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10325006668625992.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::P102_OWNER,P102_ON,P102_OT:&OB_SCHEMA.,&OBJECT_NAME.,&OBJECT_TYPE.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_database_link_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10360630703718055.4508)
,p_name=>'OB_DATABASE_LINK_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10362319060724124.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::P102_OWNER,P102_ON,P102_OT:&OB_SCHEMA.,&OBJECT_NAME.,DATABASE LINK:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10362014558722877.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\D14C\C2A4\D2B8')
,p_list_item_link_target=>'f?p=&APP_ID.:2602:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/table_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11239830706238313.4508)
,p_name=>'Table Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11129306899761893.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\D14C\C774\BE14 \C5F4')
,p_list_item_link_target=>'f?p=&APP_ID.:1047:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11252702534296443.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\D14C\C774\BE14 \C124\BA85')
,p_list_item_link_target=>'f?p=&APP_ID.:701:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11253122273302192.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\D14C\C774\BE14 \C81C\C57D \C870\AC74')
,p_list_item_link_target=>'f?p=&APP_ID.:706:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11286227355445574.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\D14C\C774\BE14 \D1B5\ACC4')
,p_list_item_link_target=>'f?p=&APP_ID.:1052:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11215531943727735.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\D14C\C774\BE14 \C800\C7A5 \C601\C5ED \D06C\AE30')
,p_list_item_link_target=>'f?p=&APP_ID.:1048:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/exception_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11254208206307506.4508)
,p_name=>'Exception Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11247001795267858.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\AE30\BCF8 \D0A4\AC00 \C5C6\B294 \D14C\C774\BE14')
,p_list_item_link_target=>'f?p=&APP_ID.:702:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11257003273325012.4508)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\C778\B371\C2A4\AC00 \C5C6\B294 \D14C\C774\BE14')
,p_list_item_link_target=>'f?p=&APP_ID.:707:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11247315993271938.4508)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('\C778\B371\C2A4\D654\B418\C9C0 \C54A\C740 \C678\B798 \D0A4')
,p_list_item_link_target=>'f?p=&APP_ID.:704:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(69176903649450759.4508)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\D2B8\B9AC\AC70\AC00 \C5C6\B294 \D14C\C774\BE14')
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/security_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11271128516379623.4508)
,p_name=>'Security Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11122717588736506.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AC1D\CCB4 \AD8C\D55C \BD80\C5EC')
,p_list_item_link_target=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_security.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(8953808698289635.4508)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\C5F4 \AD8C\D55C')
,p_list_item_link_target=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_security.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(240016507458722563.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\B864 \AD8C\D55C')
,p_list_item_link_target=>'f?p=&APP_ID.:1502:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_security.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(240018327890728456.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C2DC\C2A4\D15C \AD8C\D55C')
,p_list_item_link_target=>'f?p=&APP_ID.:1404:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_security.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/pl_sql_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11319530060616601.4508)
,p_name=>'PL/SQL Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11134009370790923.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\D504\B85C\ADF8\B7A8 \B2E8\C704 \C778\C218')
,p_list_item_link_target=>'f?p=&APP_ID.:1046:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11323926167634444.4508)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\B2E8\C704 \D589 \C218')
,p_list_item_link_target=>'f?p=&APP_ID.:1054:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(163506601642923359.4508)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('PL/SQL \C18C\C2A4 \CF54\B4DC \AC80\C0C9')
,p_list_item_link_target=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/recycle_bin
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11401232423499912.4508)
,p_name=>'Recycle Bin'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11401613160503840.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\C0AD\C81C\B41C \AC1D\CCB4')
,p_list_item_link_target=>'f?p=&APP_ID.:400:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_page.png'
,p_list_item_icon_attributes=>'height="20" width="20"  alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11404101994519551.4508)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\D734\C9C0\D1B5 \BE44\C6B0\AE30')
,p_list_item_link_target=>'f?p=&APP_ID.:403:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_process.png'
,p_list_item_icon_attributes=>'height="20" width="20"  alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_table_subtab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11739111107829730.4508)
,p_name=>'OB_TABLE_SUBTAB'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11740501541836476.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\D14C\C774\BE14')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_DETAIL:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2100'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11744500680874063.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\B370\C774\D130')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_DATA:&SESSION.:T:&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2101:42:46:47'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11742226953853220.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C778\B371\C2A4')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_INDEXES:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_for_pages=>'2102'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11742502842855728.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\BAA8\B378')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_MODEL:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'2103'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11743118772860341.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\C81C\C57D \C870\AC74')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_CONSTRAINTS:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2104'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11743631586864077.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\AD8C\D55C \BD80\C5EC')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_GRANTS:&SESSION.::&DEBUG.:RP:::'
,p_security_scheme=>wwv_flow_api.id(7676404413799609)
,p_list_item_current_for_pages=>'2105'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11744024098871375.4508)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\D1B5\ACC4')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_STATISTICS:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_for_pages=>'2106'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11746129077882210.4508)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('UI \AE30\BCF8\AC12')
,p_list_item_link_target=>'f?p=&APP_ID.:OB_UI_DEFAULTS:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2155'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11746506352885196.4508)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\D2B8\B9AC\AC70')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_TRIGGERS:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_for_pages=>'2108'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11746906137894555.4508)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\C885\C18D\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_DEPENDENCIES:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_for_pages=>'2109'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11747316180897446.4508)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_DDL:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(243327690322706018.4508)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'REST'
,p_list_item_link_target=>'f?p=&APP_ID.:OBJECT_REST:&SESSION.::&DEBUG.:2111:::'
,p_security_scheme=>wwv_flow_api.id(802775228359756685)
,p_required_patch=>wwv_flow_api.id(256109433659228165.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(565810533598211906.4508)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\C0D8\D50C \C9C8\C758')
,p_list_item_link_target=>'f?p=&APP_ID.:OBJECT_SAMPLE_QUERIES:&SESSION.::&DEBUG.:2112:::'
,p_security_scheme=>wwv_flow_api.id(802775228359756685)
,p_required_patch=>wwv_flow_api.id(256109433659228165.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_view_subtab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11795609889491706.4508)
,p_name=>'OB_VIEW_SUBTAB'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11796215907502913.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\BDF0')
,p_list_item_link_target=>'f?p=&APP_ID.:VIEW_DETAIL:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2150'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(275770510302858374.4508)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('\CF54\B4DC')
,p_list_item_link_target=>'f?p=&APP_ID.:2250:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2250'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(275954917228560573.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'DO NOT TRANSLATE: Dummy Child'
,p_parent_list_item_id=>wwv_flow_api.id(275770510302858374.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11796923526505149.4508)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\B370\C774\D130')
,p_list_item_link_target=>'f?p=&APP_ID.:VIEW_DATA:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2156:42:46'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11796620409504293.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AD8C\D55C \BD80\C5EC')
,p_list_item_link_target=>'f?p=&APP_ID.:VIEW_GRANTS:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(7676404413799609)
,p_list_item_current_for_pages=>'2151'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15460922082198559.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('UI \AE30\BCF8\AC12')
,p_list_item_link_target=>'f?p=&APP_ID.:OB_UI_DEFAULTS:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2155'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11797231837507563.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C885\C18D\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:VIEW_DEPENDENCIES:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'2153'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11798011536511170.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:VIEW_DDL:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(256799136537648764.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'REST'
,p_list_item_link_target=>'f?p=&APP_ID.:OBJECT_REST:&SESSION.::&DEBUG.:2111:::'
,p_required_patch=>wwv_flow_api.id(256109433659228165.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_table_data_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(14089426771868187.4508)
,p_name=>'OB_TABLE_DATA_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14092422184885755.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\C9C8\C758')
,p_list_item_link_target=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.::F4500_LAST_VIEW:&APP_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149453228384232993.4508)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\D589 \AC1C\C218')
,p_list_item_link_target=>'f?p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:COUNT:&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(141149820477003321.4508)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\D589 \C0BD\C785')
,p_list_item_link_target=>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.:SW_QBE_SAVE:F4500_LAST_VIEW:&APP_PAGE_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'163'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_table_index_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(14921315593135016.4508)
,p_name=>'OB_TABLE_INDEX_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25220114374714654.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0DD\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:95:&SESSION.:TABLE:&DEBUG.:95,106,130:F4500_LAST_VIEW,P67_ACTION,P95_FROM:&APP_PAGE_ID.,CREATE_INDEX,TABLE:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25221222339716916.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\D14D\C2A4\D2B8 \C0DD\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:94:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,CREATE_TEXT_INDEX:'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25220617837715658.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:78:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,DROP_INDEX:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_table_contraint_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(14992414558348243.4508)
,p_name=>'OB_TABLE_CONTRAINT_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40212436008062897.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0DD\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:79:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW:&APP_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40212939471063901.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:83:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW:&APP_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40213543973065159.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C0AC\C6A9\C73C\B85C \C124\C815')
,p_list_item_link_target=>'f?p=&APP_ID.:82:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW:&APP_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14997910121363886.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815')
,p_list_item_link_target=>'f?p=&APP_ID.:80:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW:&APP_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_table_stats_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15123613473622266.4508)
,p_name=>'OB_TABLE_STATS_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30219451896172097.4508)
,p_list_item_display_sequence=>8
,p_list_item_link_text=>unistr('\BD84\C11D')
,p_list_item_link_target=>'f?p=&APP_ID.:90:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,ANALYZE:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(556017951625246222.4508)
,p_list_item_display_sequence=>18
,p_list_item_link_text=>unistr('\D14C\C774\BE14 \D1B5\ACC4 \C218\C9D1')
,p_list_item_link_target=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.:RP,49,50:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,GATHER_TABLE_STATS:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_table_trigger_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15140917230304234.4508)
,p_name=>'OB_TABLE_TRIGGER_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40360937121018888.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:87:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,DROP_TRIGGER:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40362045086021150.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0DD\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:79,66,22:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,CREATE_TRIGGER:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40361440584019892.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C0AC\C6A9\C73C\B85C \C124\C815')
,p_list_item_link_target=>'f?p=&APP_ID.:86:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,ENABLE_TRIGGER:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15143911364329301.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815')
,p_list_item_link_target=>'f?p=&APP_ID.:85:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,DISABLE_TRIGGER:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_table_grant_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15238925543915636.4508)
,p_name=>'OB_TABLE_GRANT_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40458915675630290.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AD8C\D55C \BD80\C5EC')
,p_list_item_link_target=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.::F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,GRANT:'
,p_security_scheme=>wwv_flow_api.id(7676404413799609)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40460023640632552.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AD8C\D55C \CDE8\C18C')
,p_list_item_link_target=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.:79,66:F4500_LAST_VIEW,P67_ACTION:&APP_PAGE_ID.,REVOKE_GRANT:'
,p_security_scheme=>wwv_flow_api.id(7676404413799609)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_index_stats_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15790302694745667.4508)
,p_name=>'OB_INDEX_STATS_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46009657719917764.4508)
,p_list_item_display_sequence=>8
,p_list_item_link_text=>unistr('\BD84\C11D')
,p_list_item_link_target=>'f?p=&APP_ID.:160:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_mat_view_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15852414527126687.4508)
,p_name=>'OB_MAT_VIEW_TABS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15853027686130448.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AD6C\CCB4\D654\B41C \BDF0')
,p_list_item_link_target=>'f?p=&APP_ID.:MATERIALIZED_VIEW_DETAIL:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'161'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15864022454176282.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\B370\C774\D130')
,p_list_item_link_target=>'f?p=&APP_ID.:MATERIALIZED_VIEW_DATA:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'163:42'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15865505270180732.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C138\BD80\C815\BCF4')
,p_list_item_link_target=>'f?p=&APP_ID.:MATERIALIZED_VIEW_DETAILS:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'166'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15920609491361728.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\AD8C\D55C \BD80\C5EC')
,p_list_item_link_target=>'f?p=&APP_ID.:MATERIALIZED_VIEW_GRANTS:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(7676404413799609)
,p_list_item_current_for_pages=>'173'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15926013001391100.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\C885\C18D\C131	')
,p_list_item_link_target=>'f?p=&APP_ID.:MATERIALIZED_VIEW_SYNONYMS:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'174'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15859119422156428.4508)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:MATERIALIZED_VIEW_SQL:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_create_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(18696924586125446.4508)
,p_name=>'OB_CREATE_LIST'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527967216283926194.4508)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\D14C\C774\BE14')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527967527216926195.4508)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\BDF0')
,p_list_item_link_target=>'f?p=&APP_ID.:VIEW_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527967836705926196.4508)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\C778\B371\C2A4')
,p_list_item_link_target=>'f?p=&APP_ID.:INDEX_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527968148814926196.4508)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\C2DC\D000\C2A4')
,p_list_item_link_target=>'f?p=&APP_ID.:SEQUENCE_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527968411767926196.4508)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>unistr('\C720\D615')
,p_list_item_link_target=>'f?p=&APP_ID.:TYPE_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527968775862926196.4508)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('\D328\D0A4\C9C0')
,p_list_item_link_target=>'f?p=&APP_ID.:PACKAGE_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527969041327926196.4508)
,p_list_item_display_sequence=>180
,p_list_item_link_text=>unistr('\D504\B85C\C2DC\C800')
,p_list_item_link_target=>'f?p=&APP_ID.:PROCEDURE_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527969301551926196.4508)
,p_list_item_display_sequence=>190
,p_list_item_link_text=>unistr('\D568\C218')
,p_list_item_link_target=>'f?p=&APP_ID.:FUNCTION_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527969688406926196.4508)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('\D2B8\B9AC\AC70')
,p_list_item_link_target=>'f?p=&APP_ID.:TRIGGER_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527969899542926199.4508)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B9C1\D06C')
,p_list_item_link_target=>'f?p=&APP_ID.:DATABASE_LINK_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1527970208830926199.4508)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('\AD6C\CCB4\D654\B41C \BDF0')
,p_list_item_link_target=>'f?p=&APP_ID.:MATERIALIZED_VIEW_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_required_patch=>wwv_flow_api.id(240247031763163202.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(960228917980286937.4508)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('\B3D9\C758\C5B4')
,p_list_item_link_target=>'f?p=&APP_ID.:SYNONYM_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_required_patch=>wwv_flow_api.id(240237502901130926.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_mat_view_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(19933910744920832.4508)
,p_name=>'OB_MAT_VIEW_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30258824127546824.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C0AD\C81C')
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::P102_OWNER,P102_ON,P102_OT:&OB_SCHEMA.,&OBJECT_NAME.,MATERIALIZED VIEW:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_ui_default_action
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(20344107517818485.4508)
,p_name=>'OB_UI_DEFAULT_ACTION'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20348102631864356.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\D3B8\C9D1')
,p_list_item_link_target=>'javascript:top.redirect(&quot;f?p=4500:802:&SESSION.:::802,RP:P800_SCHEMA,P802_TABLE_ID:&OBJECT_OWNER.,&P2155_UI_DEF_TABLE_ID.&quot;)'
,p_security_scheme=>wwv_flow_api.id(20416908986150096)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20376629156136971.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\AE30\BCF8\AC12 \C0DD\C131')
,p_list_item_link_target=>'javascript:top.redirect(&quot;f?p=4500:801:&SESSION.::&DEBUG.:RP,801,802:P800_SCHEMA,P801_TABLE_ID,P802_TABLE_ID:&OBJECT_OWNER.,&OBJECT_ID.,&quot;)'
,p_security_scheme=>'!'||wwv_flow_api.id(20416908986150096)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ob_object_types
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(23674222199102465.4508)
,p_name=>'OB_OBJECT_TYPES'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23674801898106075.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\D14C\C774\BE14')
,p_list_item_icon=>'table_s.gif'
,p_list_text_01=>'TABLE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1001'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23675208132107838.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\BDF0')
,p_list_item_icon=>'view_s.gif'
,p_list_text_01=>'VIEW'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23676115750110093.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C778\B371\C2A4')
,p_list_item_icon=>'index_s.gif'
,p_list_text_01=>'INDEX'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23677731334114549.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C2DC\D000\C2A4')
,p_list_item_icon=>'sequence_s.gif'
,p_list_text_01=>'SEQUENCE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23678808609117400.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\C720\D615')
,p_list_item_icon=>'type_s.gif'
,p_list_text_01=>'TYPE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23676924062112497.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\D328\D0A4\C9C0')
,p_list_item_icon=>'package_s.gif'
,p_list_text_01=>'PACKAGE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23677327871113573.4508)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\D504\B85C\C2DC\C800')
,p_list_item_icon=>'procedure_s.gif'
,p_list_text_01=>'PROCEDURE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23675611595108895.4508)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\D568\C218')
,p_list_item_icon=>'function_s.gif'
,p_list_text_01=>'FUNCTION'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23678405146116460.4508)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\D2B8\B9AC\AC70')
,p_list_item_icon=>'trigger_s.gif'
,p_list_text_01=>'TRIGGER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23679113457118846.4508)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B9C1\D06C')
,p_list_item_icon=>'dblink_s.gif'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_list_text_01=>'DATABASE_LINK'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23676520945111591.4508)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\AD6C\CCB4\D654\B41C \BDF0')
,p_list_item_icon=>'materialized_view_s.gif'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_list_text_01=>'MATERIALIZED_VIEW'
,p_required_patch=>wwv_flow_api.id(240247031763163202.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23678002029115528.4508)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\B3D9\C758\C5B4')
,p_list_item_icon=>'synonym_s.gif'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_list_text_01=>'SYNONYM'
,p_required_patch=>wwv_flow_api.id(240237502901130926.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/table_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(35404206746396755.4508)
,p_name=>'table.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35408016920409156.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('QBE(\C608\C81C\BCC4 \C9C8\C758)')
,p_list_item_link_target=>'f?p=&FLOW_ID.:42:&SESSION.:qbe:&DEBUG.:42:P42_OBJECT_ID:&P502_OBJECT_ID.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow.g_flow_step_id not in (69,96,110) and',
':F4500_P500_OBJECT_TYPE not in (''FUNCTION'',''PROCEDURE'',''PACKAGE'',''PACKAGE BODY'')'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'42'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37849213608894974.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('SQL \BA85\B839 \CC98\B9AC\AE30')
,p_list_item_link_target=>'f?p=&FLOW_ID.:3:&SESSION.::&DEBUG.:3::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ui_default_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(40650212014681045.4508)
,p_name=>'ui default tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40758212349422677.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\C5F4 \ADF8\B8F9 \C0DD\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:804:&SESSION.::&DEBUG.:804:P804_TABLE_ID:&P802_TABLE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40841914817552027.4508)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\C5F4 \ADF8\B8F9 \AD00\B9AC')
,p_list_item_link_target=>'f?p=&APP_ID.:805:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(429084627870179449.4508)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4\C640 \B3D9\AE30\D654')
,p_list_item_link_target=>'f?p=&APP_ID.:807:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(201476126054569515.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC\B85C \C774\C804')
,p_list_item_link_target=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.::P32_SCHEMA,P33_TABLE_ID:&P800_SCHEMA.,&P802_TABLE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40819416727890341.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\D14C\C774\BE14 \B515\C154\B108\B9AC\C5D0\C11C \C81C\AC70')
,p_list_item_link_target=>'f?p=&APP_ID.:830:&SESSION.::&DEBUG.::P830_TABLE_ID:&P802_TABLE_ID.:'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P802_TABLE_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/table_dictionary_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(40848526002687735.4508)
,p_name=>'table dictionary tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(201458325044096158.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC \C774\C804')
,p_list_item_link_target=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.::P32_SCHEMA:&P800_SCHEMA.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40876113946214023.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C775\C2A4\D3EC\D2B8')
,p_list_item_link_target=>'f?p=&APP_ID.:841:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40876316370214768.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C784\D3EC\D2B8')
,p_list_item_link_target=>'f?p=&APP_ID.:842:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sql_workshop_home_list_apex_4_0
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(46900227098494683.4508)
,p_name=>'SQL Workshop Home List - APEX 4.0'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46900407490498504.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AC1D\CCB4 \BE0C\B77C\C6B0\C800')
,p_list_item_link_target=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'sql-workshop-object-browser'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46900613377500241.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('SQL \BA85\B839')
,p_list_item_link_target=>'f?p=&APP_ID.:1003:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'sql-workshop-commands'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46900819264501864.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('SQL \C2A4\D06C\B9BD\D2B8')
,p_list_item_link_target=>'f?p=&APP_ID.:1004:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex-sql-script'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46901026191503941.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C9C8\C758 \C791\C131\AE30')
,p_list_item_link_target=>'f?p=&APP_ID.:1002:&SESSION.::&DEBUG.:1002:::'
,p_list_item_icon=>'qb'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47583907412198107.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\C720\D2F8\B9AC\D2F0')
,p_list_item_link_target=>'f?p=&APP_ID.:1005:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex-utilities'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(325069319924256588.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('RESTful \C11C\BE44\C2A4')
,p_list_item_link_target=>'f?p=4850:500:&SESSION.'
,p_list_item_icon=>'sql-workshop-rest'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_security_scheme=>wwv_flow_api.id(802775228359756685)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_0_homepage_large_icons
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(46901918965530186.4508)
,p_name=>'APEX 5.0 - Homepage Large Icons'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46902304205535426.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.:::'
,p_list_item_icon=>'app-builder'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''x''',
'from WWV_FLOW_COMPANIES',
'where provisioning_company_id = :flow_security_group_id',
'and   NVL(allow_app_building_yn,''Y'') = ''Y'''))
,p_list_text_01=>'app-builder'
,p_security_scheme=>wwv_flow_api.id(12506407035221692)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46902518057539426.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('SQL \C6CC\D06C\C20D')
,p_list_item_link_target=>'f?p=&APP_ID.:3002:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'sql-workshop'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''x''',
'from WWV_FLOW_COMPANIES',
'where provisioning_company_id = :flow_security_group_id',
'and   NVL(allow_sql_workshop_yn,''Y'') = ''Y'''))
,p_list_text_01=>'sql-workshop'
,p_security_scheme=>wwv_flow_api.id(178925305824656679)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(171304512978435723.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\D300 \AC1C\BC1C')
,p_list_item_link_target=>'f?p=4600:1:&SESSION.:::'
,p_list_item_icon=>'issues'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_text_01=>'issues'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46902925329541524.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\AD00\B9AC')
,p_list_item_link_target=>'f?p=4350:1:&SESSION.'
,p_list_item_icon=>'administration'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_text_01=>'workspace-admin'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(402682359167084178.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AC24\B7EC\B9AC')
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.:::50'
,p_list_item_icon=>'pkg-apps'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_text_01=>'pkg-apps'
,p_security_scheme=>wwv_flow_api.id(763683890571534371)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ddl_wizard
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(87134126220568115.4508)
,p_name=>'DDL Wizard'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(87135922338569906.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C2A4\D0A4\B9C8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'18'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(87136718887571537.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\AC1D\CCB4 \C720\D615')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'43'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(87137516731572565.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\AC1D\CCB4 \C774\B984')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'44'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(87138313496573982.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C2A4\D06C\B9BD\D2B8')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'29:45'
);
end;
/
prompt --application/shared_components/navigation/lists/4500_24_tablescolums
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(98332317887807047.4508)
,p_name=>'4500_24_TablesColums'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(98332922735808489.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\D14C\C774\BE14')
,p_list_item_link_target=>'javascript:void($d_TabClick(''tabletab'',''tablereport'',''tabcurrent'',p24Tabs))'||wwv_flow.LF||
''
,p_list_text_01=>'id="tabletab"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(98333326198809479.4508)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\C5F4')
,p_list_item_link_target=>'javascript:void($d_TabClick(''columntab'',''columnreport'',''tabcurrent'',p24Tabs))'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P24_TABLE_NAME'
,p_list_text_01=>'id="columntab"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/database_monitor
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(133792932105421631.4508)
,p_name=>'database monitor'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(133794915960426480.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C138\C158')
,p_list_item_link_target=>'f?p=&APP_ID.:540:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(173640005872718109.4508)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>unistr('\C2DC\C2A4\D15C \D1B5\ACC4')
,p_list_item_link_target=>'f?p=&APP_ID.:560:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(134580728113951404.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\CD5C\C0C1\C704 SQL')
,p_list_item_link_target=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(137498619860396665.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\AE34 \C791\C5C5')
,p_list_item_link_target=>'f?p=&APP_ID.:34:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_database_objects
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(149627725126847053.4508)
,p_name=>'Create Database Objects'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(279673154414663323.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\D14C\C774\BE14')
,p_list_item_link_target=>'f?p=&APP_ID.:TABLE_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_table.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(279679031390694460.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\BDF0')
,p_list_item_link_target=>'f?p=&APP_ID.:VIEW_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_view.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(279681428404703059.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C778\B371\C2A4')
,p_list_item_link_target=>'f?p=&APP_ID.:INDEX_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_index.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(279685138578715449.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C2DC\D000\C2A4')
,p_list_item_link_target=>'f?p=&APP_ID.:SEQUENCE_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_sequence.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(279688529705722382.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\C720\D615')
,p_list_item_link_target=>'f?p=&APP_ID.:TYPE_CREATE:&SESSION.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/ob_type.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(451099159181446421.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\D328\D0A4\C9C0')
,p_list_item_link_target=>'f?p=&APP_ID.:PACKAGE_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_package_body.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(451100168185449035.4508)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\D504\B85C\C2DC\C800')
,p_list_item_link_target=>'f?p=&APP_ID.:PROCEDURE_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_procedure.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(451097460089437295.4508)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\D568\C218')
,p_list_item_link_target=>'f?p=&APP_ID.:FUNCTION_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_function.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(451103965199457646.4508)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\D2B8\B9AC\AC70')
,p_list_item_link_target=>'f?p=&APP_ID.:TRIGGER_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_trigger.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(108262713773954997.4508)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B9C1\D06C')
,p_list_item_link_target=>'f?p=&APP_ID.:DATABASE_LINK_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_dblink.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(108264314597964669.4508)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\AD6C\CCB4\D654\B41C \BDF0')
,p_list_item_link_target=>'f?p=&APP_ID.:MATERIALIZED_VIEW_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_materialized_view.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_required_patch=>wwv_flow_api.id(240247031763163202.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(108268718537975278.4508)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\B3D9\C758\C5B4')
,p_list_item_link_target=>'f?p=&APP_ID.:SYNONYM_CREATE:&SESSION.::&DEBUG.:602,604,145,149,48,98,107,100,57,77,94,135,117,118,131,186,187,120,124,125,121,122,123,97,99,3,84,182,183,91,TBL_WIZ_COLUMNS,TBL_WIZ_FKS,TBL_WIZ_CONS:::'
,p_list_item_icon=>'htmldb/icons/ob_synonym.gif'
,p_list_item_icon_attributes=>'width="32" height="24" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_required_patch=>wwv_flow_api.id(240237502901130926.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_table_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(149747621878186797.4508)
,p_name=>'create table progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149749617853195058.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C5F4')
,p_list_item_link_target=>'javascript:doSubmit(''COL'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'602'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149750402747200116.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\AE30\BCF8 \D0A4')
,p_list_item_link_target=>'javascript:doSubmit(''PK'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'604'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149751026296206923.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C678\B798 \D0A4')
,p_list_item_link_target=>'javascript:doSubmit(''FK'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'145'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(167420128965767313.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\C81C\C57D \C870\AC74')
,p_list_item_link_target=>'javascript:doSubmit(''CONS'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'149'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149751512574212399.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_link_target=>'javascript:doSubmit(''CONF'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'612:614'
);
end;
/
prompt --application/shared_components/navigation/lists/create_view_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(149867603205408487.4508)
,p_name=>'create view progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149868411863410941.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C815\C758')
,p_list_item_link_target=>'f?p=&APP_ID.:48:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'48,602'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149869323637414393.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_link_target=>'f?p=&APP_ID.:52:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'52:54'
);
end;
/
prompt --application/shared_components/navigation/lists/create_database_link_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(149896424470499729.4508)
,p_name=>'create database link progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149897204169503329.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C815\C758')
,p_list_item_link_target=>'f?p=&APP_ID.:91:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'91'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149898018021507393.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_link_target=>'f?p=&APP_ID.:92:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'92:58'
);
end;
/
prompt --application/shared_components/navigation/lists/create_function_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(149902807201523152.4508)
,p_name=>'create function progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149906007679532742.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C774\B984')
,p_list_item_link_target=>'f?p=&APP_ID.:98:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'98'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149907524994537698.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C778\C218')
,p_list_item_link_target=>'f?p=&APP_ID.:107:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'107'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149908003654541084.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\D568\C218 \BCF8\BB38')
,p_list_item_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'100'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149910419238545537.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_link_target=>'f?p=&APP_ID.:109:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'109'
);
end;
/
prompt --application/shared_components/navigation/lists/create_index_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(149926526903576167.4508)
,p_name=>'create index progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149927600023577803.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\D14C\C774\BE14 \C774\B984')
,p_list_item_link_target=>'f?p=&APP_ID.:57:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'57'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149930021494584052.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C778\B371\C2A4 \C815\C758')
,p_list_item_current_for_pages=>'77,94'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149930625649585213.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5:4'
);
end;
/
prompt --application/shared_components/navigation/lists/create_materialized_view_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(149951426304632759.4508)
,p_name=>'create materialized view progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149952408774637135.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C815\C758')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'135'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149954100593644272.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'136:141'
);
end;
/
prompt --application/shared_components/navigation/lists/create_package_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(149957726913651895.4508)
,p_name=>'create package progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(171534808786575314.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C720\D615 \C120\D0DD')
,p_list_item_link_target=>'f?p=&APP_ID.:117:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'117'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(149958822888660101.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C774\B984')
,p_list_item_link_target=>'f?p=&APP_ID.:118:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'118,120,186'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(722930026779822542.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C815\C758')
,p_list_item_link_target=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'131,124,187'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1080739923278204088.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_link_target=>'f?p=&APP_ID.:125:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P117_CREATE_PACKAGE'
,p_list_item_disp_condition2=>'TABLE'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/create_procedure_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(150037318536819700.4508)
,p_name=>'create procedure progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150045702783853023.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C774\B984')
,p_list_item_current_for_pages=>'121'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150053317852895220.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C778\C218')
,p_list_item_current_for_pages=>'122'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150840511032292788.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C815\C758')
,p_list_item_current_for_pages=>'123'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150841506661300917.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_current_for_pages=>'114'
);
end;
/
prompt --application/shared_components/navigation/lists/create_sequence_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(150794104668931302.4508)
,p_name=>'create sequence progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150795517266944463.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C815\C758')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'97'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150796123500946231.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'116:129'
);
end;
/
prompt --application/shared_components/navigation/lists/create_synonym_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(150805024941050729.4508)
,p_name=>'create synonym progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150805906025054758.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C815\C758')
,p_list_item_current_for_pages=>'99'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150807117238067458.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'127'
);
end;
/
prompt --application/shared_components/navigation/lists/create_trigger_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(150811814776114073.4508)
,p_name=>'create trigger progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150812319971115562.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C774\B984')
,p_list_item_current_for_pages=>'3'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150813302094119896.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C815\C758')
,p_list_item_current_for_pages=>'84'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150815310536131761.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9:16'
);
end;
/
prompt --application/shared_components/navigation/lists/create_type_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(150827529723222442.4508)
,p_name=>'create type progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150828211154226585.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C774\B984')
,p_list_item_current_for_pages=>'182'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150828619465228988.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C815\C758')
,p_list_item_current_for_pages=>'183'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150829232279232684.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\D655\C778')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'184:185'
);
end;
/
prompt --application/shared_components/navigation/lists/recyclebin
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(151000331198918456.4508)
,p_name=>'recyclebin'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(151001418516924257.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\D734\C9C0\D1B5 \BE44\C6B0\AE30')
,p_list_item_link_target=>'f?p=&FLOW_ID.:403:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/session_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(159562414490322899.4508)
,p_name=>'session tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(159564908042330521.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\C138\C158')
,p_list_item_link_target=>'f?p=&APP_ID.:540:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'540'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(159565421201334330.4508)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\C7A0\AE08')
,p_list_item_link_target=>'f?p=&APP_ID.:541:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'541'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(162017426458197138.4508)
,p_list_item_display_sequence=>2.1
,p_list_item_link_text=>unistr('\B300\AE30')
,p_list_item_link_target=>'f?p=&APP_ID.:548:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'548'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(159588009305397176.4508)
,p_list_item_display_sequence=>2.2
,p_list_item_link_text=>'I/O'
,p_list_item_link_target=>'f?p=&APP_ID.:545:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'545'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(159566527088336046.4508)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:542:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'542'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(159567803324338684.4508)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\C5F4\B9B0 \CEE4\C11C')
,p_list_item_link_target=>'f?p=&APP_ID.:543:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'543,546'
);
end;
/
prompt --application/shared_components/navigation/lists/script_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(163470423703447178.4508)
,p_name=>'Script Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(164091703714775079.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\ACB0\ACFC \AD00\B9AC')
,p_list_item_link_target=>'f?p=&APP_ID.:1220:&SESSION.::&DEBUG.:1220:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(150027319743782244.4508)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\D560\B2F9\B7C9 \D45C\C2DC')
,p_list_item_link_target=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(221300505462590355.4508)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('\C775\C2A4\D3EC\D2B8')
,p_list_item_link_target=>'f?p=&APP_ID.:65:&SESSION.::&DEBUG.:SCRIPTS_TO_EXPORT:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(221300908233591110.4508)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\C784\D3EC\D2B8')
,p_list_item_link_target=>'f?p=&APP_ID.:112:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/utilities_line_1
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(169562905299954428.4508)
,p_name=>'Utilities line 1'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(169563123101954428.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\B370\C774\D130 \C6CC\D06C\C20D')
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_list_item_icon=>'icon-utilities-data-workshop'
,p_list_text_01=>unistr('CSV, XLSX, XML \B610\B294 JSON \D30C\C77C\C744 \C0AC\C6A9\D558\C5EC \B370\C774\D130\B97C \B85C\B4DC \BC0F \B85C\B4DC \CDE8\C18C\D569\B2C8\B2E4.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(686840721222033340.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C9C8\C758 \C791\C131\AE30')
,p_list_item_link_target=>'f?p=&APP_ID.:1002:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-query-builder'
,p_list_text_01=>unistr('\D14C\C774\BE14\C744 \D328\B110\C5D0 \CD94\AC00\D558\ACE0 \BC18\D658\D560 \C5F4\C744 \C120\D0DD\D558\C5EC \C9C8\C758\B97C \ADF8\B798\D53D\C73C\B85C \C791\C131\D569\B2C8\B2E4.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713107322646978455.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Quick SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.:RP,1100:::'
,p_list_item_icon=>'a-Icon icon-utilities-query-builder'
,p_list_text_01=>'Generate SQL using shorthand syntax'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(165295291982048923.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C0D8\D50C \B370\C774\D130\C138\D2B8')
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_list_item_icon=>'icon-sc-files'
,p_list_text_01=>'Install, refresh, or remove sample datasets.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(621480553521527744.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('DDL \C0DD\C131')
,p_list_item_link_target=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-generate-ddl'
,p_list_text_01=>unistr('\C2A4\D0A4\B9C8 \B0B4\C758 \BAA8\B4E0 \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4 \B610\B294 \C120\D0DD\B41C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\C5D0 \B300\D55C \C2A4\D06C\B9BD\D2B8\B97C \C0DD\C131\D569\B2C8\B2E4.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(169564017816954429.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \AE30\BCF8\AC12')
,p_list_item_link_target=>'f?p=&APP_ID.:813:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-ui-defaults'
,p_list_text_01=>unistr('\C5EC\B7EC \D398\C774\C9C0 \BC0F \C560\D50C\B9AC\CF00\C774\C158\C5D0\C11C \D56D\BAA9/\C5F4\C744 \C77C\AD00\C131 \C788\AC8C \C0DD\C131\D558\AE30 \C704\D55C \B808\C774\C544\C6C3 \C18D\C131\C744 \C9C0\C815\D569\B2C8\B2E4.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(862293371954895810.4508)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\C2A4\D0A4\B9C8 \BE44\AD50')
,p_list_item_link_target=>'f?p=&APP_ID.:1350:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilites-schema-comparison'
,p_list_text_01=>unistr('\C11C\B85C \B2E4\B978 \B450 \C2A4\D0A4\B9C8\C758 \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4 \AC04 \CC28\C774\B97C \D45C\C2DC\D569\B2C8\B2E4.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(169563411461954429.4508)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\D14C\C774\BE14\C758 \BA54\C18C\B4DC')
,p_list_item_link_target=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:120,124,125:::'
,p_list_item_icon=>'icon-utilities-methods-tables'
,p_list_text_01=>unistr('\C9C0\C815\B41C \D14C\C774\BE14\C758 DML \C791\C5C5\C5D0 \B300\D55C API \C2A4\D06C\B9BD\D2B8\B97C \C0DD\C131\D569\B2C8\B2E4.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(862292771917895809.4508)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\D734\C9C0\D1B5')
,p_list_item_link_target=>'f?p=&APP_ID.:1070:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilites-recycle-bin'
,p_list_text_01=>unistr('\C0AD\C81C\B41C \B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4\B97C \BCF5\C6D0\D569\B2C8\B2E4.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1379793096144889954.4508)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\AC1D\CCB4 \BCF4\ACE0\C11C')
,p_list_item_link_target=>'f?p=&APP_ID.:1042:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-object-reports'
,p_list_text_01=>unistr('\D14C\C774\BE14, \C608\C678\C0AC\D56D, \BCF4\C548, \AC1D\CCB4 \BC0F PL/SQL \CF54\B4DC\C5D0 \B300\D55C \B2E4\C591\D55C \BCF4\ACE0\C11C\C5D0 \C561\C138\C2A4\D569\B2C8\B2E4.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(862293694522895810.4508)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C815\BCF4')
,p_list_item_link_target=>'f?p=&APP_ID.:36:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-about-database'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_list_text_01=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C138\BD80\C815\BCF4\B97C \AC80\D1A0\D569\B2C8\B2E4. \CC38\ACE0: DBA \B864\C774 \BD80\C5EC\B41C \B370\C774\D130\BCA0\C774\C2A4 \ACC4\C815\C774 \D544\C694\D569\B2C8\B2E4.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1144637580332327672.4508)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \BAA8\B2C8\D130')
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-database-monitor'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_list_text_01=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C791\C5C5 \BCF4\ACE0\C11C\B97C \C2E4\D589\D569\B2C8\B2E4. \CC38\ACE0: DBA \B864\C774 \BD80\C5EC\B41C \B370\C774\D130\BCA0\C774\C2A4 \ACC4\C815\C774 \D544\C694\D569\B2C8\B2E4.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sql_workshop_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(170601318269466378.4508)
,p_name=>'sql workshop navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(170601510360466387.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AC1D\CCB4 \BE0C\B77C\C6B0\C800')
,p_list_item_link_target=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/ob_browser.gif'
,p_list_text_01=>'browser'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(170601819280466388.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('SQL \BA85\B839')
,p_list_item_link_target=>'f?p=&APP_ID.:1003:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/sqlcmd.gif'
,p_list_text_01=>'commandLine'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(170602114146466388.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('SQL \C2A4\D06C\B9BD\D2B8')
,p_list_item_link_target=>'f?p=&APP_ID.:1004:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/sqlscrpt.gif'
,p_list_text_01=>'file'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(170602413280466389.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C9C8\C758 \C791\C131\AE30')
,p_list_item_link_target=>'f?p=&APP_ID.:1002:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/qbuilder.gif'
,p_list_text_01=>'queryBuilder'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(170628208161633707.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\C720\D2F8\B9AC\D2F0')
,p_list_item_link_target=>'f?p=&APP_ID.:1005:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/shared_comp_small.gif'
,p_list_text_01=>'utilities'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(872825001018813755.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('RESTful \C11C\BE44\C2A4')
,p_list_item_link_target=>'f?p=4850:1:&SESSION.'
,p_list_item_icon=>'htmldb/icons/dbservice.png'
,p_list_text_01=>'restfulServices'
,p_security_scheme=>wwv_flow_api.id(802775228359756685)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ui_defaults_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(194504915759237345.4508)
,p_name=>'UI Defaults Navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(421011030860726171.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\B300\C2DC\BCF4\B4DC')
,p_list_item_link_target=>'f?p=&APP_ID.:813:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'813'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194505202972237349.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\D14C\C774\BE14 \B515\C154\B108\B9AC')
,p_list_item_link_target=>'f?p=&APP_ID.:800:&SESSION.::&DEBUG.::P800_SCHEMA:&P813_SCHEMA.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'800'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(194505603010237353.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C18D\C131 \B515\C154\B108\B9AC')
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6:17'
);
end;
/
prompt --application/shared_components/navigation/lists/all_object_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(276235426866859669.4508)
,p_name=>'All Object Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(276237431846870512.4508)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\BAA8\B4E0 \AC1D\CCB4')
,p_list_item_link_target=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.:500:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(276237707735873072.4508)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\BD80\C801\D569\D55C \AC1D\CCB4')
,p_list_item_link_target=>'f?p=&APP_ID.:1040:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(276238015700875357.4508)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>unistr('\AC1D\CCB4 \C0DD\C131 \B2EC\B825')
,p_list_item_link_target=>'f?p=&APP_ID.:1055:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_session.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(276238320549876791.4508)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\C720\D615\BCC4 \AC1D\CCB4 \C218')
,p_list_item_link_target=>'f?p=&APP_ID.:1059:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(65214035632967721.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\B370\C774\D130 \B514\B809\D1A0\B9AC')
,p_list_item_link_target=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_global.g_cloud'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/attribute_dictionary_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(442022106915434689.4508)
,p_name=>'attribute dictionary tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(442022828528434694.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C775\C2A4\D3EC\D2B8')
,p_list_item_link_target=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(442023208094434695.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\C784\D3EC\D2B8')
,p_list_item_link_target=>'f?p=&APP_ID.:41:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/home_resources_links
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(454525848376819263.4508)
,p_name=>'HOME RESOURCES LINKS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(454526082518819264.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\CEE4\BBA4\B2C8\D2F0 \C0AC\C774\D2B8')
,p_list_item_link_target=>'https://apex.oracle.com/community'
,p_list_text_02=>'target="_blank"'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(454526454015819266.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'apex.world'
,p_list_item_link_target=>'https://apex.world/'
,p_list_text_02=>'target="_blank"'
,p_list_text_03=>'is-external-link'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(454526878748819266.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\BE14\B85C\ADF8')
,p_list_item_link_target=>'https://apex.oracle.com/blog'
,p_list_text_02=>'target="_blank"'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(454527233209819267.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\C2E4\BB34 \B7A9')
,p_list_item_link_target=>'https://apex.oracle.com/hols'
,p_list_text_02=>'target="_blank"'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(454527671515819267.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\AD50\C721')
,p_list_item_link_target=>'https://apex.oracle.com/education'
,p_list_text_02=>'target="_blank"'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697546799309390664.4508)
,p_name=>'APEX 5 - Administration'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697546976894390664.4508)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\AD00\B9AC')
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697547235161390665.4508)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697547501968390665.4508)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('\C11C\BE44\C2A4 \AD00\B9AC')
,p_security_scheme=>wwv_flow_api.id(12520119493499631)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697547855490390665.4508)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\C11C\BE44\C2A4 \AD00\B9AC')
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697547501968390665.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697548157703390665.4508)
,p_list_item_display_sequence=>215
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(697547501968390665.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697548721548390666.4508)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('\C791\C5C5\C601\C5ED \D658\ACBD\C124\C815 \C124\C815')
,p_list_item_link_target=>'f?p=4350:17:&SESSION.::NO:RP::'
,p_parent_list_item_id=>wwv_flow_api.id(697547501968390665.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697549084529390666.4508)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\ACF5\ACE0 \D3B8\C9D1')
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697547501968390665.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697549313943390666.4508)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('\C791\C5C5\C601\C5ED \D65C\C6A9\B3C4')
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697547501968390665.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697549654493390666.4508)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\C0AC\C6A9\C790 \BC0F \ADF8\B8F9 \AD00\B9AC')
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(12520119493499631)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697549971815390666.4508)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('\C791\C5C5 \BAA8\B2C8\D130')
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(10590808779171805)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697550297696390667.4508)
,p_list_item_display_sequence=>500
,p_list_item_link_text=>unistr('\B300\C2DC\BCF4\B4DC')
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(10590808779171805)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1250750521916198591.4508)
,p_list_item_display_sequence=>600
,p_list_item_link_text=>unistr('\B0B4 \BE44\BC00\BC88\D638 \BCC0\ACBD')
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_security_scheme=>wwv_flow_api.id(10590808779171805)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697551745129395610.4508)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(315961750369926048.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Quick SQL \C124\BA85\C11C')
,p_list_item_link_target=>'&SYSTEM_HELP_URL./aeutl/using-quick-SQL.html'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'1100'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1815073082808606504.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('SQL \BA85\B839 \C124\BA85\C11C')
,p_list_item_link_target=>'&SYSTEM_HELP_URL./aeutl/using-SQL-commands.html'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'1003'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1815073545088614954.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('SQL \C2A4\D06C\B9BD\D2B8 \C124\BA85\C11C')
,p_list_item_link_target=>'&SYSTEM_HELP_URL./aeutl/using-SQL-scripts.html#AEUTL190'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'1004'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1815064344998576882.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\AC1D\CCB4 \BE0C\B77C\C6B0\C800 \C124\BA85\C11C')
,p_list_item_link_target=>'&SYSTEM_HELP_URL./aeutl/managing-db-objects-with-object-browser.html'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'1001'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1815073871384621185.4508)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\C720\D2F8\B9AC\D2F0 \C124\BA85\C11C')
,p_list_item_link_target=>'&SYSTEM_HELP_URL./aeutl/using-Oracle-application-express-utilities.html'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'1005'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697551976020395610.4508)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\C124\BA85\C11C')
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkDocLib'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2105955016147042297.4508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\D1A0\B860 \D3EC\B7FC')
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2185349560170378007.4508)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Oracle Technology Network'
,p_list_item_link_target=>'http://apex.oracle.com/otn'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697552813369395610.4508)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697553124884395611.4508)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\C815\BCF4')
,p_list_item_link_target=>'f?p=4350:9:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(718942723406995455.4508)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW::'
,p_list_item_icon_alt_attribute=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30 \B4DC\B9B4 \B2E4\C6B4')
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_api.id(178922732459641711)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718943273407995467.4508)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:DATABASE:'
,p_parent_list_item_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718943557851995467.4508)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\C6F9 \C2DC\D2B8 \C560\D50C\B9AC\CF00\C774\C158')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:WEBSHEET:'
,p_parent_list_item_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718943883204995467.4508)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718944189936995467.4508)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\C0DD\C131')
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID:'
,p_parent_list_item_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718944432315995467.4508)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\C784\D3EC\D2B8')
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718944721611995468.4508)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\C775\C2A4\D3EC\D2B8')
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718945016998995468.4508)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718945356605995468.4508)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>unistr('\C791\C5C5\C601\C5ED \C720\D2F8\B9AC\D2F0')
,p_parent_list_item_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718945606934995468.4508)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>unistr('\BAA8\B4E0 \C791\C5C5\C601\C5ED \C720\D2F8\B9AC\D2F0')
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(718945356605995468.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718945931869995468.4508)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(718945356605995468.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718946275988995468.4508)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C791\C131\AE30 \AE30\BCF8\AC12')
,p_list_item_link_target=>'f?p=4000:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(718945356605995468.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718946880982995469.4508)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>unistr('\C791\C5C5\C601\C5ED \D14C\B9C8')
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(718945356605995468.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718947172203995469.4508)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \ADF8\B8F9')
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_api.id(718945356605995468.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718947405431995469.4508)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>unistr('Application Express \BDF0')
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(718945356605995468.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718947797973995469.4508)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158\AC04 \BCF4\ACE0\C11C')
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(718945356605995468.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718948053893995469.4508)
,p_list_item_display_sequence=>169
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718948352228995469.4508)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('\C774\C804')
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718942975810995460.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718948661756995469.4508)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('SQL \C6CC\D06C\C20D')
,p_list_item_link_target=>'f?p=&APP_ID.:3002:&SESSION.::&DEBUG.::::'
,p_list_item_icon_alt_attribute=>unistr('SQL \C6CC\D06C\C20D \B4DC\B9B4 \B2E4\C6B4')
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_api.id(178925305824656679)
,p_list_item_current_type=>'PLSQL_EXPRESSION'
,p_list_item_current_for_pages=>':APP_PAGE_ID not in (''1000'',''8000'',''35'', ''900'')'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718948931578995473.4508)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\AC1D\CCB4 \BE0C\B77C\C6B0\C800')
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718948661756995469.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718949244351995473.4508)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('SQL \BA85\B839')
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718948661756995469.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718949564220995473.4508)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('SQL \C2A4\D06C\B9BD\D2B8')
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718948661756995469.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\C720\D2F8\B9AC\D2F0')
,p_parent_list_item_id=>wwv_flow_api.id(718948661756995469.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718950193664995473.4508)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>unistr('\BAA8\B4E0 \C720\D2F8\B9AC\D2F0')
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718950494237995474.4508)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718950770765995474.4508)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>unistr('\B370\C774\D130 \C6CC\D06C\C20D')
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718951036197995474.4508)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>unistr('\C9C8\C758 \C791\C131\AE30')
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713689787906400408.4508)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>'Quick SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(671093275370024819.4508)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>unistr('\C0D8\D50C \B370\C774\D130\C138\D2B8')
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718951379214995474.4508)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>unistr('DDL \C0DD\C131')
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718951612512995475.4508)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \AE30\BCF8\AC12')
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718953111014995475.4508)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>unistr('\C2A4\D0A4\B9C8 \BE44\AD50')
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718951913502995475.4508)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('\D14C\C774\BE14\C758 \BA54\C18C\B4DC')
,p_list_item_link_target=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:120,124,125:::'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718953475468995475.4508)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>unistr('\D734\C9C0\D1B5')
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718952543303995475.4508)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>unistr('\AC1D\CCB4 \BCF4\ACE0\C11C')
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718952200472995475.4508)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C815\BCF4')
,p_list_item_link_target=>'f?p=&APP_ID.:36:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718952838487995475.4508)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \BAA8\B2C8\D130')
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(718949806921995473.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718953707380995475.4508)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>unistr('RESTful \C11C\BE44\C2A4')
,p_list_item_link_target=>'f?p=4850:500:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(718948661756995469.4508)
,p_security_scheme=>wwv_flow_api.id(802775228359756685)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718954076139995475.4508)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\D300 \AC1C\BC1C')
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>unistr('\D300 \AC1C\BC1C \B4DC\B9B4 \B2E4\C6B4')
,p_list_text_01=>'tab-team-dev'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718954361259995476.4508)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>unistr('\B808\C774\BE14')
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(718954076139995475.4508)
,p_security_scheme=>wwv_flow_api.id(12506407035221692)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718954622790995476.4508)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>unistr('\B9C8\C77C\C2A4\D1A4')
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(718954076139995475.4508)
,p_security_scheme=>wwv_flow_api.id(12506407035221692)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718954973671995476.4508)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>unistr('\D15C\D50C\B9AC\D2B8')
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(718954076139995475.4508)
,p_security_scheme=>wwv_flow_api.id(12506407035221692)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718955247249995476.4508)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>unistr('\C720\D2F8\B9AC\D2F0')
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(718954076139995475.4508)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718955815286995476.4508)
,p_list_item_display_sequence=>355
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(718954076139995475.4508)
,p_security_scheme=>wwv_flow_api.id(12506407035221692)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718956179077995477.4508)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>unistr('\D53C\B4DC\BC31')
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(718954076139995475.4508)
,p_security_scheme=>wwv_flow_api.id(12506407035221692)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718960334577995481.4508)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \AC24\B7EC\B9AC')
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_text_01=>'tab-apps'
,p_security_scheme=>wwv_flow_api.id(763683890571534371)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2076259871303887209.4508)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>unistr('\C0DD\C0B0\C131 \C560\D50C\B9AC\CF00\C774\C158')
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:PACKAGE'
,p_parent_list_item_id=>wwv_flow_api.id(718960334577995481.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718960948137995481.4508)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>unistr('\C0D8\D50C \C560\D50C\B9AC\CF00\C774\C158')
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:SAMPLE'
,p_parent_list_item_id=>wwv_flow_api.id(718960334577995481.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(780159501628357083.4508)
,p_list_item_display_sequence=>425
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(718960334577995481.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(718961213846995481.4508)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>unistr('\AD00\B9AC')
,p_list_item_link_target=>'f?p=4750:6:&SESSION.::&DEBUG.:6:'
,p_parent_list_item_id=>wwv_flow_api.id(718960334577995481.4508)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(940310462341300.4508)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1810634689405953.4508)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14848715049940930.4508)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(92000308707572422.4508)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1272782587538879395.4508)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.SPLITTER'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072762112712055.4508)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831722742580993878.4508)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917693824782940193.4508)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_sql_and_not_cloudy
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(7676404413799609.4508)
,p_name=>'Flow: SQL and not cloudy'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_authorization.is_authorized_developer (',
'           p_developer_authorization => ''SQL'' ) ',
'       and not wwv_flow_global.g_cloud;',
''))
,p_error_message=>unistr('\C774 \AE30\B2A5\C740 \C0AC\C6A9\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>786930698123107979.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(10590808779171805.4508)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>unistr('\B300\C2DC\BCF4\B4DC \BC0F \BAA8\B2C8\D130 \C791\C5C5\C5D0 \C561\C138\C2A4\D560 \C218 \C788\B294 \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>786936829326142579.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(11007909946539925.4508)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>unistr('\C0DD\C131\AE30 SSO\AC00 \C0AC\C6A9\C73C\B85C \C124\C815\B418\C9C0 \C54A\C558\C2B5\B2C8\B2E4.')
,p_reference_id=>6738410669854771.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sql_scripts_supported
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(11650706329157488.4508)
,p_name=>'SQL_SCRIPTS Supported'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return true;'
,p_error_message=>unistr('SQL \C2A4\D06C\B9BD\D2B8 \AE30\B2A5\C740 \C774 \AD6C\C131\C5D0\C11C \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
,p_reference_id=>786931734190107980.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sql_scripts_not_supported
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(11800412655616562.4508)
,p_name=>'SQL_SCRIPTS NOT Supported'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return false;'
,p_error_message=>unistr('\C778\B77C\C778 DDL \BCF4\AE30\B294 \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
,p_reference_id=>786931461585107980.4508
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12506407035221692.4508)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C744 \D3B8\C9D1\D560 \C218 \C788\B294 \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>12480509677812756.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12520119493499631.4508)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>unistr('\C560\D50C\B9AC\CF00\C774\C158\C744 \AD00\B9AC\D560 \C218 \C788\B294 \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>12511219858301010.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_sql
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12524102140541924.4508)
,p_name=>'Flow: SQL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('SQL \C6CC\D06C\C20D\C744 \C0AC\C6A9\D560 \C218 \C788\B294 \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>12523823826538734.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/ui_def_exists_for_object
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(20416908986150096.4508)
,p_name=>'UI_DEF_EXISTS_FOR_OBJECT'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select table_id',
'  from wwv_flow_hnt_table_info',
' where schema     = :OBJECT_OWNER',
'   and table_name = :OBJECT_NAME'))
,p_error_message=>unistr('\C624\B958\C785\B2C8\B2E4.')
,p_reference_id=>786932671432107981.4508
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(173297929258927869.4508)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\C774 \C791\C5C5\C601\C5ED\C5D0\C11C\B294 \D300 \AC1C\BC1C\C774 \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4.')
,p_reference_id=>786516861027697723.4508
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178913128250981971.4508)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\C2DC\B3C4\D55C \C791\C5C5\C5D0 \B300\D55C \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>786517166823697723.4508
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178922732459641711.4508)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\C2DC\B3C4\D55C \C791\C5C5\C5D0 \B300\D55C \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>786516029127697713.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178925305824656679.4508)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('SQL \C6CC\D06C\C20D\C744 \C0AC\C6A9\D560 \C218 \C788\B294 \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>786516265251697717.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/registered_dba_login_and_db_monitor_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(206059717799303330.4508)
,p_name=>'REGISTERED_DBA_LOGIN and DB Monitor Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR''), ''N'') = ''N'' then',
'    wwv_flow_debug.trace(''ALLOW_DB_MONITOR disabled'');',
'    return false;',
'elsif :APP_PAGE_ALIAS=''DBA_LOGIN'' then',
'    if not wwv_flow_authorization.is_authorized_developer(''SQL'') then',
'        wwv_flow_debug.trace(''must have SQL privs on DBA_LOGIN page'');',
'        return false;',
'    else',
'        return true;',
'    end if;',
'end if;',
'',
'for c1 in (select 1',
'             from sys.dba_role_privs',
'            where grantee      = :DBA_USERNAME',
'              and granted_role = ''DBA'')',
'loop',
'    return true;',
'end loop;',
'',
':F4500_DBA_LOGIN := ''N'';',
'',
'wwv_flow_utilities.redirect_url (',
'    p_url => ''f?p=''||:APP_ID||'':DBA_LOGIN:''||:SESSION||'':''||:APP_ID||'',''||:APP_PAGE_ID||'':''||:DEBUG);',
'',
'return true;'))
,p_error_message=>unistr('DBA \D398\C774\C9C0\AC00 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\B418\C5C8\C2B5\B2C8\B2E4.')
,p_reference_id=>.4508
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/db_10_2_or_higher
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(239225402734254498.4508)
,p_name=>'db 10.2 or higher'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'   from sys.dba_objects',
' where object_name = ''SYS_PLSQL_SQL_INJECT_TAB''',
' and owner = ''SYS'''))
,p_error_message=>unistr('SQL \C0BD\C785 \BD84\C11D\C740 \C0AC\C6A9\C790\C758 \D604\C7AC \B370\C774\D130\BCA0\C774\C2A4 \BC84\C804 \B610\B294 \AD6C\C131\C5D0\C11C \C9C0\C6D0\B418\C9C0 \C54A\C2B5\B2C8\B2E4. SQL \C0BD\C785 \D328\D0A4\C9C0\AC00 \C124\CE58\B41C Oracle \B9B4\B9AC\C2A4 10.2 \B610\B294 \C774\D6C4 \BC84\C804\C758 \ACBD\C6B0\C5D0\B9CC \AC00\B2A5\D569\B2C8\B2E4.')
,p_reference_id=>786933222298107982.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/db_10_1_or_higher
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(240648913515910366.4508)
,p_name=>'db 10.1 or higher'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>'select 1 from dual'
,p_error_message=>unistr('\C774 \AE30\B2A5\C744 \C9C0\C6D0\D558\B824\BA74 \B370\C774\D130\BCA0\C774\C2A4\AC00 \B9B4\B9AC\C2A4 10.1\C774\C5B4\C57C \D569\B2C8\B2E4.')
,p_reference_id=>786932968525107981.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_productivity_and_sample_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(763683890571534371.4508)
,p_name=>'APEX 5.0 Productivity and Sample App Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('\C0DD\C0B0\C131 \B610\B294 \C0D8\D50C \C560\D50C\B9AC\CF00\C774\C158\C744 \C124\CE58\D560 \C218 \C788\B294 \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>786517456817697723.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(802775228359756685.4508)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>unistr('\C2DC\B3C4\D55C \C791\C5C5\C5D0 \B300\D55C \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>786519856057734816.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/service_requests_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(916236223411830688.4508)
,p_name=>'Service Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'' then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>unistr('\C2DC\B3C4\D55C \C791\C5C5\C5D0 \B300\D55C \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_reference_id=>786932326296107981.4508
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(767165102345220885.4508)
,p_icon_sequence=>10
,p_icon_subtext=>unistr('\C791\C5C5\C601\C5ED &COMPANY.')
,p_icon_target=>'#'
,p_icon_image_alt=>unistr('\C791\C5C5\C601\C5ED &COMPANY.')
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(331786907421617643.4508)
,p_icon_sequence=>20
,p_icon_subtext=>unistr('( <span style="text-decoration:underline;">\C791\C5C5\C601\C5ED \C804\D658</span> )')
,p_icon_target=>'f?p=4550:20'
,p_icon_image_alt=>unistr('\C791\C5C5\C601\C5ED \C804\D658')
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
,p_security_scheme=>wwv_flow_api.id(11007909946539925)
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(160707630779049420.4508)
,p_icon_sequence=>30
,p_icon_image=>'Logout'
,p_icon_subtext=>unistr('( <span style="text-decoration:underline;">\B85C\ADF8\C544\C6C3</span> )')
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>unistr('\B85C\ADF8\C544\C6C3')
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(110414375697158885.4508)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/qb_poststate
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(1504518033640244.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'qb_postState'
,p_process_sql_clob=>':P1002_OWNER := :APP_USER;'
,p_process_error_message=>'DO_NOT_TRANSLATE'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 10-JAN-2005 17:03:31'
);
end;
/
prompt --application/shared_components/logic/application_processes/qb_rendertable
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(1916013849479713.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'qb_renderTable'
,p_process_sql_clob=>'wwv_flow_query_builder.renderTableV2(:P1002_ID,:P1002_COUNT);'
,p_process_error_message=>'DO_NOT_TRANSLATE'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 11-JAN-2005 09:16:46'
);
end;
/
prompt --application/shared_components/logic/application_processes/qb_object_feed
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(3934212967688584.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'qb_object_feed'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_object_feed.getmoreObjects(',
'p_type    =>'';TABLE;VIEW'',',
'p_owner   =>:P1002_SCHEMA,',
'p_display =>''DIV'',',
'p_session   =>:SESSION,',
'p_onclick =>:P1002_ONCLICK,',
'p_Start   =>1,',
'p_stop    =>50000,',
'p_class   =>''ob_Object'');',
'wwv_flow.debug(''End'');'))
,p_process_error_message=>'DO_NOT_TRANSLATE'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 13-JAN-2005 19:11:46'
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_posthistory
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(6231903825594156.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_posthistory'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_buffer varchar2(32767) := null;',
'  l_amount number;',
'  l_offset number;',
'begin',
'  for c1 in (select command',
'             from wwv_flow_sw_sql_cmds',
'             where id = :P1201_HISTORY_ID',
'             and security_group_id = :flow_security_group_id)',
'  loop',
'      if c1.command is not null and sys.dbms_lob.getlength( c1.command ) > 0 then',
'          l_amount := 8000;',
'          l_offset := 1;',
'          begin',
'              loop',
'                  sys.dbms_lob.read( c1.command, l_amount, l_offset, l_buffer );',
'                  sys.htp.prn( l_buffer );',
'                  l_offset := l_offset + l_amount;',
'                  l_amount := 8000;',
'              end loop;',
'          exception',
'              when others then',
'                  null;',
'          end;',
'      end if;    ',
'      exit;',
'  end loop;',
'end;'))
,p_process_error_message=>'Unable to get history.'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 18-JAN-2005 12:49:22'
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_postsavedsql
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(7139200190149482.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_postSavedSQL'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_buffer varchar2(32767) := null;',
'  l_amount number;',
'  l_offset number;',
'begin',
'  for c1 in (select qb_sql, id, title, description',
'               from wwv_flow_qb_saved_query',
'              where id = :P1003_QUERY_ID',
'                and security_group_id = :flow_security_group_id)',
'',
'  loop',
'      :P1003_QUERY_ID := c1.id;',
'      :P1003_SAVE_NAME := c1.title;',
'      :P1003_SAVE_DESC := c1.description;',
'      if c1.qb_sql is not null and sys.dbms_lob.getlength( c1.qb_sql ) > 0 then',
'          l_amount := 8000;',
'          l_offset := 1;',
'          begin',
'              loop',
'                  sys.dbms_lob.read( c1.qb_sql, l_amount, l_offset, l_buffer );',
'                  sys.htp.prn( l_buffer );',
'                  l_offset := l_offset + l_amount;',
'                  l_amount := 8000;',
'              end loop;',
'          exception',
'              when others then',
'                  null;',
'          end;',
'      end if;    ',
'      exit;',
'  end loop;',
'end;'))
,p_process_error_message=>'Unable to get saved SQL.'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 19-JAN-2005 12:35:15'
);
end;
/
prompt --application/shared_components/logic/application_processes/qb_get_saved_query
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(7276531262852173.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'qb_get_saved_query'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.owa_util.mime_header(''text/javascript'', FALSE );',
'sys.htp.p(''Cache-Control: no-cache'');',
'sys.htp.p(''Pragma: no-cache'');',
'sys.owa_util.http_header_close;',
'sys.htp.p(''var fUser ="''||:APP_USER||''";'');',
'wwv_flow_query_builder.loadQuery;'))
,p_process_error_message=>'#SQLERRM#'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 19-JAN-2005 17:19:02'
);
end;
/
prompt --application/shared_components/logic/application_processes/ob_get_object_feed
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(11551302098165190.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'OB_GET_OBJECT_FEED'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_object_feed.getmoreObjects(',
'p_type    =>:P2001_FEED_TYPE,',
'p_owner   =>:P2001_FEED_OWNER,',
'p_Start   =>:P2001_FEED_START,',
'p_stop    =>:P2001_FEED_STOP,',
'p_display =>:P2001_FEED_DISPLAY,',
'p_session   =>:SESSION,',
'p_include =>:P2001_FEED_INCLUDE,',
'p_onclick =>:P2001_FEED_ONCLICK,',
'p_class  =>:P2001_FEED_CLASS);'))
,p_process_error_message=>'DO_NOT_TRANSLATE'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'This is for the Object Browser please do not change'
);
end;
/
prompt --application/shared_components/logic/application_processes/compile_plsql_code
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(12649800434223403.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'compile_plsql_code'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_status varchar2(32767);',
'',
'begin',
'',
'   for c1 in (',
'       select clob001 from htmldb_collections',
'       where collection_name = ''PLSQL_OBJECT_SOURCE''',
'   ) loop',
'       l_status := wwv_flow_plsql_editor.compile(',
'           wwv_flow_sw_api.valid_workspace_schema(:OBJECT_OWNER),',
'           :OBJECT_NAME, ',
'           :OBJECT_TYPE, ',
'           c1.clob001',
'       );',
'       sys.htp.p(l_status);',
'   end loop;',
'',
'   htmldb_collection.truncate_collection(',
'      p_collection_name => ''PLSQL_OBJECT_SOURCE'' ',
'   );',
'',
'exception',
'   when others then',
'      sys.htp.p(sqlerrm);',
'end;'))
,p_process_error_message=>'#SQLERRM#'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 31-JAN-2005 16:01:43'
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_getbind
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(21627908860597925.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_getBind'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'l_new_binds varchar2(32700);',
'l_old_binds varchar2(32700);',
'begin',
'  l_new_binds := wwv_flow_sw_api.get_binds(:P1003_SQL_COMMAND2);',
'  l_old_binds := v(''P1200_BINDS''); ',
'',
'  if (l_new_binds is null) then',
'    return;',
'  else',
'    sys.htp.p(''l_new_binds ''||l_new_binds);',
'  end if;',
'  if l_new_binds = l_old_binds then ',
'    return;',
'  else',
'    wwv_flow.update_cache_with_write (',
'      p_name   => ''P1200_BINDS'',',
'      p_value  => l_new_binds );',
'    wwv_flow.update_cache_with_write (',
'      p_name   => ''P1200_BIND_VALS'',',
'      p_value  => '''');',
'  end if;',
'end;'))
,p_process_error_message=>'Unable to get binds'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 14-FEB-2005 19:57:28'
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_buildsql
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(22896611795429544.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_buildSql'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- used by sc_core.js/sc_getSQL',
'declare ',
'  i number := 0;',
'  l_owner  varchar2(128) := wwv_flow_sw_api.valid_workspace_schema(v(''P139_OWNER''));',
'  l_object varchar2(128) := v(''P139_OBJECT'');',
'begin',
'  sys.htp.p(l_owner||''.''||l_object||'' ('');',
'  for c in ( select argument_name',
'               from sys.dba_arguments',
'              where owner = l_owner',
'                and (package_name||''.''||object_name = l_object',
'                     or object_name = l_object)',
'                and argument_name is not null',
'                and data_level = 0',
'                and nvl(overload,1) = 1',
'              order by position )',
'  loop',
'    if (i < 1) then',
'      sys.htp.p(c.argument_name ||'' => '');',
'      i := i+1;',
'    else',
'      sys.htp.p('',''||c.argument_name ||'' => '');',
'    end if;',
'  end loop;',
'  sys.htp.p('')'');',
'end;'))
,p_process_error_message=>'Error'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 15-FEB-2005 20:29:24'
);
end;
/
prompt --application/shared_components/logic/application_processes/sr_parsing
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(28056921387126354.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sr_parsing'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_status varchar2(255) := null;',
'begin',
'  wwv_flow_sw_parser.parse_file(p_file_id => :P1023_FILE_ID);',
'  if wwv_flow_sw_script.invalid_script(p_file_id => :P1023_FILE_ID) = 1 then',
'    l_status := ''FAILURE'';',
'  else',
'    l_status := ''SUCCESS'';',
'  end if;',
'  sys.htp.p(l_status);',
'end;'))
,p_process_error_message=>'Unable to parse the script.'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 21-FEB-2005 15:36:28'
);
end;
/
prompt --application/shared_components/logic/application_processes/ob_fk_get_columns
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(29884608907915599.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ob_fk_get_columns'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
' l_cols varchar(2000) := null;',
' counter number := 0;',
' l_upper varchar2(2000) := null;',
' l_owner wwv_flow_global.t_dbms_id := wwv_flow_sw_api.valid_workspace_schema(:OB_SCHEMA);',
'begin',
'  ',
'  select count(column_name) into counter',
'           from sys.dba_tab_columns',
'           where owner = upper(l_owner)',
'           and table_name  = :P145_FK_REF_TABLE;',
'  if (counter = 0)  then ',
'     :P145_FK_REF_TABLE := upper(:P145_FK_REF_TABLE);',
'     select count(column_name) into counter',
'     from sys.dba_tab_columns',
'     where owner = upper(l_owner)',
'     and table_name  = :P145_FK_REF_TABLE;',
'  end if;',
'     l_upper := :P145_FK_REF_TABLE;',
'',
'     for c1 in (select column_name  ',
'           from sys.dba_tab_columns',
'           where owner = upper(l_owner)',
'           and table_name  = :P145_FK_REF_TABLE) loop',
'        l_cols := l_cols||c1.column_name;',
'        l_cols := l_cols||'';'';',
'     end loop;',
'',
'if (counter = 0) then',
'  sys.htp.prn(''NONE'');',
'else',
'  sys.htp.prn(wwv_flow_escape.html(l_upper||'';''||l_cols));',
'end if;',
'end;'))
,p_process_error_message=>'DO_NOT_TRANSLATE'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 22-FEB-2005 16:01:20'
);
end;
/
prompt --application/shared_components/logic/application_processes/returnnothing
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(77984007292719402.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ReturnNothing'
,p_process_sql_clob=>'null;'
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_processes/sr_save_script
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(106683007949808585.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sr_save_script'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select clob001 script, c001 file_id, c002 name                   ',
'           from htmldb_collections',
'           where collection_name = ''SR_SCRIPT_SOURCE'') loop',
'    wwv_flow_sw_script.update_script_file (',
'     p_file_id     => c1.file_id,',
'     p_script_name => c1.name,',
'     p_script      => c1.script);',
'end loop;'))
,p_process_error_message=>'Unable to update script.'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 23-FEB-2005 15:37:51'
);
end;
/
prompt --application/shared_components/logic/application_processes/sr_create_script
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(108492501270666096.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sr_create_script'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select clob001 script, c001 file_id, c002 name                   ',
'             from htmldb_collections',
'             where collection_name = ''SR_SCRIPT_SOURCE'') loop',
'    wwv_flow_sw_script.create_script_from_clob (        ',
'     p_script_name => c1.name,',
'     p_script      => c1.script);   ',
'end loop;'))
,p_process_error_message=>'Unable to create script.'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 25-FEB-2005 10:54:13'
);
end;
/
prompt --application/shared_components/logic/application_processes/sr_dup_name
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(112585108113201529.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sr_dup_name'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_cnt          number := 0;  ',
'  l_current_id   number := null;',
'  l_new_filename varchar2(4000) := null;',
'  l_old_filename varchar2(4000) := null;',
'  l_existing_id  number := null;',
'  l_created_by   varchar2(255) := null;',
'  ',
'  l_flag         varchar2(255) := null;',
'begin',
'  l_new_filename := lower(v(''P60_SCRIPT_NAME''));',
'  l_old_filename := lower(v(''P60_OLD_SCRIPT_NAME''));',
'  l_current_id := v(''P60_FILE_ID'');',
'	',
'  if l_new_filename = nvl(l_old_filename,'''') then',
'     l_flag := ''SUCCESS'';	   ',
'  else',
'     for c1 in (select id, created_by',
'                from wwv_flow_files',
'                where lower(filename) = l_new_filename)',
'     loop',
'       l_cnt := l_cnt + 1;    ',
'       l_existing_id := c1.id;',
'       l_created_by := c1.created_by;',
'       exit;    ',
'     end loop;',
'     if l_cnt > 0 then',
'       if l_existing_id = nvl(l_current_id,0) then',
'         l_flag := ''SAVE_NEW'';',
'       else       	 ',
'         l_flag := ''FAIL'';',
'       end if;',
'       if upper(l_created_by) != upper(v(''APP_USER'')) then    	 ',
'           l_flag := ''FAIL_RENAME'';         ',
'       end if;       ',
'     else',
'     	l_flag := ''SAVE_NEW'';',
'     end if;',
'  end if;',
'  sys.htp.p(l_flag);',
'end;'))
,p_process_error_message=>'Unable to get duplicate script name.'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 03-MAR-2005 22:12:36'
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_create_job
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(136604317027747819.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_create_job'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P1003_JOBID := wwv_flow_sc_transactions.sc_create_job(:P1003_LANGUAGE);',
':P1003_AUTOCOMMIT := ''Y'';'))
,p_process_error_message=>'Unable to create job '
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 15-MAR-2005 19:03:39'
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_remove_job
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(136605514734756665.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_remove_job'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'l_tid number ;',
'begin',
'  l_tid := wwv_flow_sc_transactions.add_trans(:SESSION, :FLOW_USER, ',
'                :P1003_SCHEMA,''STOP'', 0, '''', ''exit'');',
'  :P1003_JOBID := '''';',
' :P1003_AUTOCOMMIT := '''';',
'end;'))
,p_process_error_message=>'Unable to remove job'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 15-MAR-2005 19:05:07'
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_read_out
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(137030824141880927.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_read_out'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_out   clob;',
'  l_tid   number;',
'  lob_length     integer;',
'  read_amount    integer;',
'  read_offset    integer := 1;',
'  buffer         varchar2(32700);',
'begin',
'   l_tid := v(''P1200_STMT'');',
'   select transaction_result into l_out ',
'    from wwv_flow_sc_trans ',
'    where session_id = (select nv(''SESSION'') x from dual)',
'    and transaction_id = l_tid;',
'   if (length(l_out) > 0) then',
'     lob_length := length(l_out);',
'     while (lob_length > 0) loop',
'       if (lob_length > 32000) then',
'         read_amount := 32000;',
'       else ',
'         read_amount := lob_length;',
'       end if;',
'       sys.dbms_lob.read(l_out,read_amount,read_offset,buffer);',
'       sys.htp.p(wwv_flow_escape.noop(buffer));',
'       read_offset := read_offset+read_amount;',
'       lob_length := lob_length-read_amount;',
'     end loop;',
'   else',
'     sys.htp.p(''HTMLDB:NONE'');',
'   end if;',
'',
'exception when others then',
' sys.htp.p(''HTMLDB:NONE ERROR ''||wwv_flow_escape.html(SQLERRM));',
' sys.htp.p(''HTMLDB:NONE ERROR ''||wwv_flow_escape.html(SQLERRM));',
'end;'))
,p_process_error_message=>'Unable to read output'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 16-MAR-2005 09:19:10'
);
end;
/
prompt --application/shared_components/logic/application_processes/sr_replace_script
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(138449522524133557.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sr_replace_script'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_file_id number := null;',
'begin',
'  for c1 in (select clob001 script, c001 file_id, c002 name                   ',
'             from htmldb_collections',
'             where collection_name = ''SR_SCRIPT_SOURCE'') loop',
'      for c2 in (select id',
'                 from wwv_flow_files',
'                 where lower(filename) = lower(c1.name)',
'                 and file_type = ''SCRIPT'')',
'      loop',
'          l_file_id := c2.id;',
'          exit;',
'      end loop; ',
'      if l_file_id is not null then          	',
'        wwv_flow_sw_script.update_script_file (',
'         p_file_id     => l_file_id,',
'         p_script_name => c1.name,',
'         p_script      => c1.script);',
'      end if;',
'  end loop;',
'end;  '))
,p_process_error_message=>'Unable to replace script.'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 17-MAR-2005 16:34:36'
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_read_dbms
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(140873708217846868.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_read_dbms'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_out   clob;',
'  l_tid   number;',
'begin',
'   l_tid := v(''P1200_STMT'');',
'   select transaction_output into l_out from wwv_flow_sc_trans ',
'   where session_id = :SESSION and transaction_id = l_tid;',
'   if length(l_out) > 0 then',
'     sys.htp.p(wwv_flow_escape.noop(l_out));',
'   else',
'     sys.htp.p(''HTMLDB:NONE'');',
'   end if;',
'exception when others then',
' sys.htp.p(''HTMLDB:NONE'');',
'end;'))
,p_process_error_message=>'Unable to read output'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 21-MAR-2005 17:00:09'
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_sql_trans
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(141051327945527301.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_sql_trans'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_tid number;',
'begin',
'l_tid := wwv_flow_sc_transactions.add_trans(:SESSION, :FLOW_USER, wwv_flow_sw_api.valid_workspace_schema(:P1003_SCHEMA), :P1200_TYPE, :P1003_ROWS, :P1200_BIND_VALS, :P1003_SQL_COMMAND2);',
'sys.htp.prn(l_tid);',
'end;'))
,p_process_error_message=>'Unable to load SQL trans'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 21-MAR-2005 21:40:14'
);
end;
/
prompt --application/shared_components/logic/application_processes/sc_savequery
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(158194723674245313.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sc_saveQuery'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_counter number;',
'  l_id      number;',
'  l_error   number := 0;',
'  l_err_txt varchar2(2000) := ''<!-- HTMLDB:ERROR --><div class="htmldbNotification"><ul>'';',
'  l_id2     number;',
'  l_o_name  varchar2(2000);',
'  l_sql_command2 varchar2(32767) := v(''P1003_SQL_COMMAND2'');',
'begin',
'  ',
'  if v(''P1003_SAVE_NAME'') is null or v(''P1003_SAVE_NAME'') = '''' then',
'    l_err_txt := l_err_txt||''<li>'';',
'    l_err_txt := l_err_txt||wwv_flow_lang.system_message(''SC_NAME_NN'');',
'    l_err_txt := l_err_txt||''</li>'';',
'    l_error := 1;',
'  end if;',
'',
'  if v(''P1003_SQL_COMMAND2'') is null or v(''P1003_SQL_COMMAND2'') = '''' then',
'    l_err_txt := l_err_txt||''<li>'';',
'    l_err_txt := l_err_txt||wwv_flow_lang.system_message(''QB_NOTHING_TO_SAVE'');',
'    l_err_txt := l_err_txt||''</li>'';',
'    l_error := 1;',
'  end if;',
'',
'  if nvl(v(''P1003_QUERY_ID''),''-99'') = -99 then',
'    begin',
'      select count(*) into l_counter ',
'      from wwv_flow_qb_saved_query ',
'      where title = v(''P1003_SAVE_NAME'') ',
'       and created_by = v(''FLOW_USER'')',
'       and security_group_id = wwv_flow_security.g_security_group_id;',
'      if l_counter > 0 then ',
'        l_err_txt := l_err_txt||''<li>'';',
'        l_err_txt := l_err_txt||wwv_flow_lang.system_message(''QB_DUPLICATE_QUERY'');',
'        l_err_txt := l_err_txt||''</li>'';',
'        l_error := 1;',
'      end if;',
'    end;',
'  end if;',
'  ',
'  l_err_txt := l_err_txt||''</ul></div>'';',
'  if l_error = 1 then ',
'      sys.htp.p(l_err_txt);',
'  else',
'      l_id2 := nvl(v(''P1003_QUERY_ID''),''-99'');',
'      if l_id2 = ''-99'' then',
'          l_id := wwv_flow_id.next_val;',
'          insert into wwv_flow_qb_saved_query(id,title,query_type,description,qb_sql,query_owner,created_by) ',
'          values (l_id,v(''P1003_SAVE_NAME''),''R'',v(''P1003_SAVE_DESC''), l_sql_command2,',
'                  v(''P1003_SCHEMA''),v(''FLOW_USER''));',
'          sys.htp.prn(l_id);',
'      else',
'        begin',
'          select title into l_o_name from wwv_flow_qb_saved_query where id = l_id2;',
'        exception when no_data_found then ',
'          l_o_name := '''';',
'        end;',
'          if l_o_name = v(''P1003_SAVE_NAME'') then',
'              for c1 in (select * from wwv_flow_qb_saved_query where id = v(''P1003_QUERY_ID'')) loop',
'                  delete from wwv_flow_qb_saved_query where id = l_id2;',
'                  insert into wwv_flow_qb_saved_query ',
'                   (id, title, query_type, description, qb_sql, query_owner, created_by, created_on, last_updated_by) ',
'                   values ',
'                   (l_id2, v(''P1003_SAVE_NAME'') , ''R'', v(''P1003_SAVE_DESC'') , l_sql_command2, c1.query_owner, c1.created_by, c1.created_on, c1.last_updated_by);',
'                   l_id := v(''P1003_QUERY_ID'');',
'              end loop;',
'              sys.htp.prn(l_id2);',
'          else',
'              l_id := wwv_flow_id.next_val;',
'              insert into wwv_flow_qb_saved_query(id,title,query_type,description,qb_sql,query_owner,created_by) ',
'              values (l_id,v(''P1003_SAVE_NAME''),''R'',v(''P1003_SAVE_DESC''), l_sql_command2,',
'                      v(''P1003_SCHEMA''),v(''FLOW_USER''));',
'              sys.htp.prn(l_id);',
'         end if;',
'      end if;   ',
'  end if;',
'end;'))
,p_process_error_message=>'Unable to save Query'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 04-APR-2005 16:26:34'
);
end;
/
prompt --application/shared_components/logic/application_processes/ob_postid
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(171513520394208759.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ob_postId'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_num number;',
'  l_hash boolean := false;',
'begin',
'wwv_flow_sw_api.check_priv(:OB_SCHEMA);',
':OBJECT_ID :=  :OB_OBJECT_ID;',
':OB_OBJECT_NAME := :OBJECT_ID;',
'',
'  begin',
'   l_num := :OBJECT_ID;',
'        wwv_flow.debug(''ID value:''||:OBJECT_ID);',
'   exception when others then',
'     l_hash := true;',
'     wwv_flow.debug(''Hashed value:''||:OBJECT_ID);',
'  end;',
'',
'if ( l_hash ) then',
'   for r in ( select object_name,owner,object_type',
'               from  sys.dba_objects ',
'               where object_id is null',
'               and  ''DBASE''||ltrim( to_char( ora_hash( upper(owner || ''.'' || object_name),1000000000, power(2,30) ), rpad( ''X'',29,''X'')||''X'' )) ',
'                = :OBJECT_ID and owner = :OB_SCHEMA) loop',
'      :OBJECT_NAME  := r.object_name;',
'      :OBJECT_OWNER := r.owner;',
'      :OBJECT_TYPE  := ''DATABASE_LINK'';',
'   end loop;',
'else',
'   for r2 in ( select object_name,owner,object_type',
'               from  sys.dba_objects ',
'               where object_id = :OBJECT_ID and owner = :OB_SCHEMA ) loop',
'      :OBJECT_NAME  := r2.object_name;',
'      :OBJECT_OWNER := r2.owner;',
'      if(r2.object_type = ''PACKAGE BODY'') then ',
'        :OBJECT_TYPE  := ''PACKAGE'';',
'      else',
'        :OBJECT_TYPE  := r2.object_type;',
'      end if;',
'   end loop;',
'   if ( :REQUEST = ''GETOBJECT_SPEC'' ) then',
'       for r2 in ( select object_name,owner,object_type',
'                   from  sys.dba_objects ',
'                   where object_NAME =  :OBJECT_NAME',
'                   and   OWNER = :OBJECT_OWNER',
'                   and   OBJECT_TYPE = ''PACKAGE'' ) loop',
'          :OBJECT_NAME  := r2.object_name;',
'          :OBJECT_OWNER := r2.owner;',
'          :OBJECT_TYPE  := r2.object_type;',
'       end loop;',
'',
'    elsif ( :REQUEST = ''GETOBJECT_BODY'' ) then',
'',
'       for r2 in ( select object_name,owner,object_type',
'                   from  sys.dba_objects ',
'                   where object_name = :OBJECT_NAME',
'                   and   OWNER = :OBJECT_OWNER',
'                   and   OBJECT_TYPE = ''PACKAGE BODY'' ) loop',
'          :OBJECT_NAME  := r2.object_NAME;',
'          :OBJECT_OWNER := r2.owner;',
'          :OBJECT_TYPE  := r2.object_type;',
'       end loop;',
'    end if;',
'end if;',
'/* print for JS to change schema select list */',
'',
'',
'    ',
'if ( :APP_PAGE_ID  not in  ( 0 ) ) then ',
'/* if the page is not zero refresh/highlight the left bar */',
'sys.htp.prn(''',
'<script type="text/javascript">',
'gTempType=''||wwv_flow_escape.js_literal(:OBJECT_TYPE)||'';',
'gTempId=''||wwv_flow_escape.js_literal(:OBJECT_ID)||'';',
'setTimeout(refocusTemp,1);',
'',
'function refocusTemp(){',
'top.gSideBar.reload(gTempType,gTempId,false,false);',
'}',
'</script>'');',
'else',
'/* else return the owner to change the selector */',
'sys.htp.prn(:OBJECT_OWNER); ',
'end if;',
'end;'))
,p_process_error_message=>'DO_NOT_TRANSLATE'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
);
end;
/
prompt --application/shared_components/logic/application_processes/ob_add_fk
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(172369000165936003.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ob_add_fk'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_counter number;',
'  l_id      number;',
'  l_error   number := 0;',
'  l_name  varchar2(255);',
'  l_schema varchar2(255);',
'  l_c001  varchar2(255);',
'  l_err_txt varchar2(2000) := ''<!-- HTMLDB:ERROR --><div class="htmldbNotification"><ul>'';',
'begin',
' if v(''P145_FK_NAME'') is null then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_NAME_NOT_NULL'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
' if v(''P145_FROM_COLS'') is null then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_SEL_COLS'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
' if v(''P145_FK_REF_TABLE'') is null then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_REF_TAB'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
' if v(''P145_TO_COLS'') is null then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_REF_COLS'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
'',
'l_c001 := upper(v(''P145_FK_NAME''));',
'',
' select count(*) into l_counter    ',
' from wwv_flow_collections        ',
' where collection_name = ''TBL_WIZ_FKS''',
'  and c001 = l_c001;',
' if l_counter > 0 then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_NAME_USED'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
'',
'l_name := upper(v(''P145_FK_NAME''));',
'l_schema := v(''P145_SCHEMA'');',
'',
' select count(*) into l_counter    ',
' from sys.dba_objects',
' where object_name = l_name and owner = l_schema;',
'',
' if l_counter > 0 then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_NAME_USED'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
'',
' l_err_txt := l_err_txt||''</ul></div>'';',
'',
' if l_error = 1 then ',
'   sys.htp.p(l_err_txt);',
' else',
'   begin',
'     wwv_flow_collection.create_collection(''TBL_WIZ_FKS'');',
'   exception ',
'     when others then null;',
'   end;',
'   l_id := wwv_flow_collection.add_member(',
'            p_collection_name => ''TBL_WIZ_FKS'',',
'            p_c001          => upper(v(''P145_FK_NAME'')),',
'            p_c002          => v(''P145_FROM_COLS''),',
'            p_c003          => v(''P145_FK_REF_TABLE''),',
'            p_c004          => v(''P145_TO_COLS''),',
'            p_c005          => v(''P145_FK_ACTION''));',
'',
'    sys.htp.prn(''<table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" role="presentation" id="htmldbNewTable"><tbody>'');',
'    sys.htp.prn(''<tr><th class="tableheader2">''||    ',
'     wwv_flow_lang.system_message(''OB_FK_NAME'')||''</th>'');',
'    sys.htp.prn(''<th class="tableheader2">''||',
'     wwv_flow_lang.system_message(''CREATE_CONDITION.COLUMNS'')||''</th>'');',
'    sys.htp.prn(''<th class="tableheader2">''||',
'     wwv_flow_lang.system_message(''OB_FK_REFERENCED'')||''</th>'');',
'    sys.htp.prn(''<th class="tableheader2">''||',
'     wwv_flow_lang.system_message(''OB_FK_REFERENCED_TAB'')||''</th>'');',
'    sys.htp.prn(''<th class="tableheader2">''||',
'     wwv_flow_lang.system_message(''DEMO_APPLICATION.ACTION'')||''</th>'');',
'    sys.htp.prn(''<th class="tableheader2">''||''&nbsp;''||''</th>'');',
'    sys.htp.p(''</tr>'');',
'',
'for c1 in (select seq_id,c001, c002, c003,c004,c005',
'                 from wwv_flow_collections        ',
'                where collection_name = ''TBL_WIZ_FKS''',
'                order by seq_id) loop',
'    sys.htp.prn(''<tr id="fkTab_''||c1.seq_id||''">'');',
'    sys.htp.prn(''<td>''||c1.c001||''</td>'');',
'    sys.htp.prn(''<td>''||c1.c002||''</td>'');',
'    sys.htp.prn(''<td>''||c1.c003||''</td>'');',
'    sys.htp.prn(''<td>''||c1.c004||''</td>'');',
'    sys.htp.prn(''<td>'');',
'    if c1.c005 = ''C'' then',
'      sys.htp.prn(wwv_flow_lang.system_message(''OB_CASCADE_DELETE'')||''</td>'');',
'    elsif c1.c005 = ''N'' then',
'      sys.htp.prn(wwv_flow_lang.system_message(''OB_SET_NULL'')||''</td>'');',
'    else',
'      sys.htp.prn(wwv_flow_lang.system_message(''SQL_REPORT_WIZ.DEFAULT'')||''</td>'');',
'    end if;',
'    sys.htp.prn(''<td style="text-align: center;" class="htmldbPseudoButton">'');',
'    sys.htp.prn(''<img src="#IMAGE_PREFIX#delete.gif" onclick="ob_rmFkRow('');',
'    sys.htp.prn(c1.seq_id||'')" /></td>'');',
'    sys.htp.p(''</tr>'');',
'end loop;',
'',
'    sys.htp.p(''</tbody></table>'');',
'end if;',
'end;'))
,p_process_error_message=>'Unable to Process'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 21-APR-2005 15:55:00'
);
end;
/
prompt --application/shared_components/logic/application_processes/ob_rm_fk_row
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(172867829404455433.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ob_rm_fk_row'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  HTMLDB_COLLECTION.DELETE_MEMBER(',
'    p_collection_name => ''TBL_WIZ_FKS'' ,',
'    p_seq             => :P145_FK_SEQ );',
'end;'))
,p_process_error_message=>'Unable to process'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 21-APR-2005 17:21:35'
);
end;
/
prompt --application/shared_components/logic/application_processes/ob_add_cons
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(176127519858657209.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ob_add_cons'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_counter number;',
'  l_id      number;',
'  l_error   number := 0;',
'  l_err_txt varchar2(2000) := ''<!-- HTMLDB:ERROR --><div class="htmldbNotification"><ul>'';',
'  l_name    varchar2(2000) := upper(V(''P149_NAME''));',
'begin',
' if v(''P149_NAME'') is null then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_CONS_NAME_NN'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
' if (v(''P149_CONST_TYPE'') = ''U'' and v(''P149_SEL_COLS'') is null) then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_UK_COLS'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
' if (v(''P149_CONST_TYPE'') = ''C'' and v(''P149_CHECK'') is null) then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_CHECK_CON_NN'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
'',
' select count(*) into l_counter    ',
' from wwv_flow_collections        ',
' where collection_name = ''TBL_WIZ_CONS''',
'  and c001 = l_name;',
' if l_counter > 0 then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_CONS_NAME_USED'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
'',
' select count(*) into l_counter    ',
' from sys.dba_objects',
' where object_name = l_name;',
' if l_counter > 0 then',
'  l_err_txt := l_err_txt||''<li>'';',
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_CONS_NAME_USED'');',
'  l_err_txt := l_err_txt||''</li>'';',
'  l_error := 1;',
' end if;',
'',
' l_err_txt := l_err_txt||''</ul></div>'';',
'',
' if l_error = 1 then ',
'   sys.htp.p(l_err_txt);',
' else',
'   begin',
'     wwv_flow_collection.create_collection(''TBL_WIZ_CONS'');',
'   exception ',
'     when others then null;',
'   end;',
'   l_id := wwv_flow_collection.add_member(',
'                    p_collection_name => ''TBL_WIZ_CONS'',',
'                    p_c001          => upper(v(''P149_NAME'')),',
'                    p_c002          => v(''P149_CONST_TYPE''),',
'                    p_c003          => v(''P149_SEL_COLS''),',
'                    p_c004          => v(''P149_CHECK'') );',
'',
'',
'    sys.htp.prn(''<table cellpadding="0" cellspacing="0" class="htmldbStandard3"                ',
'      border="0" role="presentation" id="htmldbNewTable"><tbody>'');',
'    sys.htp.prn(''<tr><th class="tableheader2">''||',
'     wwv_flow_lang.system_message(''OB_CONSTRAINT_NAME'')||''</th>'');',
'    sys.htp.prn(''<th class="tableheader2">''||',
'     wwv_flow_lang.system_message(''PAGE_REGION.TREE_TYPE'')||''</th>'');',
'    sys.htp.prn(''<th class="tableheader2">''||',
'     wwv_flow_lang.system_message(''OB_CONS_INFO'')||''</th>'');',
'    sys.htp.prn(''<th class="tableheader2">''||''&nbsp;''||''</th>'');',
'    sys.htp.p(''</tr>'');',
'',
'  for c1 in (select seq_id,c001, c002, c003, c004',
'                 from wwv_flow_collections        ',
'                where collection_name = ''TBL_WIZ_CONS''',
'                and c001 is not null',
'                order by seq_id ) loop',
'    sys.htp.prn(''<tr id="consTab_''||c1.seq_id||''">'');',
'    sys.htp.prn(''<td>''||c1.c001||''</td>'');',
'    if c1.c002 = ''C'' then',
'      sys.htp.prn(''<td>''||wwv_flow_lang.system_message(''F4500_CHECK'')||''</td>'');',
'      sys.htp.prn(''<td>''||c1.c004||''</td>'');',
'    else',
'      sys.htp.prn(''<td>''||wwv_flow_lang.system_message(''F4500_UNIQUE'')||''</td>'');',
'      sys.htp.prn(''<td>''||c1.c003||''</td>'');',
'    end if;',
'    sys.htp.prn(''<td style="text-align: center;" class="htmldbPseudoButton">'');',
'    sys.htp.prn(''<img src="#IMAGE_PREFIX#delete.gif" onclick="ob_rmConsRow('');',
'    sys.htp.prn(c1.seq_id||'')" /></td>'');',
'    sys.htp.p(''</tr>'');',
'  end loop;',
'',
'    sys.htp.p(''</table>'');',
' end if;',
'end;'))
,p_process_error_message=>'Unable to process'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 26-APR-2005 14:35:13'
);
end;
/
prompt --application/shared_components/logic/application_processes/ob_rm_cons_row
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(176138206577719675.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ob_rm_cons_row'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  HTMLDB_COLLECTION.DELETE_MEMBER(',
'    p_collection_name => ''TBL_WIZ_CONS'' ,',
'    p_seq             => :P149_CONS_SEQ',
'  );',
'end;'))
,p_process_error_message=>'Unable to process'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 26-APR-2005 14:45:37'
);
end;
/
prompt --application/shared_components/logic/application_processes/check_avail_jobs
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(192446004690296352.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'check_avail_jobs'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_jobs number;',
'begin',
'  select value-(select count(*) from sys.dba_jobs) into l_jobs  ',
'  from v$parameter ',
'  where name = ''job_queue_processes'';',
'  sys.htp.prn(l_jobs);',
'end;'))
,p_process_error_message=>'Unable to get job status'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 10-MAY-2005 16:28:24'
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(233722337928545821.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'    p_app_id           => wwv_flow.g_x01,',
'    p_get_apps_list    => wwv_flow.g_x02);'))
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_processes/check_job_queue
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(251183224917806135.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'check_job_queue'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_jobs number;',
'begin',
'  select value into l_jobs  ',
'  from v$parameter ',
'  where name = ''job_queue_processes'';',
'  sys.htp.prn(l_jobs);',
'end;'))
,p_process_error_message=>'Unable to check jobs'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 23-MAY-2005 11:26:42'
);
end;
/
prompt --application/shared_components/logic/application_processes/get_message
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(251509908846066406.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'get_message'
,p_process_sql_clob=>'sys.htp.p(wwv_flow_lang.system_message(:SYSTEM_MESSAGE));'
,p_process_error_message=>'Unable to get message.'
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
,p_process_comment=>'created 23-MAY-2005 12:10:05'
);
end;
/
prompt --application/shared_components/logic/application_processes/qb_check_unique
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(266120031373725934.4508)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'qb_check_unique'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_counter number;',
'begin',
'',
'  select count(*) into l_counter ',
'  from wwv_flow_qb_saved_query ',
'  where title = v(''P1002_QUERY_NAME'') ',
'   and created_by = v(''FLOW_USER'')',
'   and security_group_id = wwv_flow_security.g_security_group_id;',
'',
'  if (l_counter > 0) then',
'   sys.htp.p(''<div class="htmldbNotification"><ul><li>'');',
'   sys.htp.p(wwv_flow_lang.system_message(''QB_DUPLICATE_QUERY''));',
'   sys.htp.p(''</li></ul></div>'');',
'  else',
'    sys.htp.prn(''0'');',
'  end if;',
'',
'end;'))
,p_process_error_message=>'Unable to validate save'
,p_security_scheme=>wwv_flow_api.id(12524102140541924)
,p_process_comment=>'created 20-JUN-2005 14:13:20'
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(5086354147.4508)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(63888631031213062.4508)
,p_name=>'CURRENT_OBJECT_ID'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(25966015567654518.4508)
,p_name=>'DBA_USERNAME'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(206052124417257915.4508)
,p_name=>'F4500_DBA_LOGIN'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(48602367732370754.4508)
,p_name=>'F4500_LAST_VIEW'
,p_data_type=>'NUMBER'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(240551529397730482.4508)
,p_name=>'F4500_P502_OBJECT_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(22437001853024837.4508)
,p_name=>'FSP_AFTER_LOGIN_URL'
,p_item_comment=>'Used by Custom2 authentication for deep linking support'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(34319320571482284.4508)
,p_name=>'G_CTRL_FILE_ID'
,p_data_type=>'NUMBER'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(367331519540068469.4508)
,p_name=>'G_USER_DEFAULT_DATE_FORMAT'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(101416805412462518.4508)
,p_name=>'LAST_SELECTED_PARSE_AS'
,p_item_comment=>'This is used to support public synonyms.  Supporting public synonym is on hold until R2.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(48607820040821755.4508)
,p_name=>'LAST_STEP'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(12255104688621266.4508)
,p_name=>'OBJECT_ID'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(12255530314628639.4508)
,p_name=>'OBJECT_LOCKER'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(12255902395630078.4508)
,p_name=>'OBJECT_NAME'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(12256308628631835.4508)
,p_name=>'OBJECT_OWNER'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(12258200626676850.4508)
,p_name=>'OBJECT_TYPE'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(171514813299244598.4508)
,p_name=>'OB_OBJECT_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(106656207167489750.4508)
,p_name=>'SUCCESS_MSG'
,p_item_comment=>'This application item is used to display success message for certain SQL Workshop regions. (Used from SQL Command Processor page 3 and page 1)'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(251508117719059591.4508)
,p_name=>'SYSTEM_MESSAGE'
,p_protection_level=>'N'
,p_item_comment=>'Message displayed while running commands in SQL Commands. Message is retrieved using on-demand process "get_message".'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(5088358914.4508)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>unistr('\C791\C5C5\C601\C5ED \C774\B984\C744 \ACC4\C0B0\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(367332002718076269.4508)
,p_computation_sequence=>10
,p_computation_item=>'G_USER_DEFAULT_DATE_FORMAT'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_date_format varchar2(255);',
'begin',
'    for c1 in (select default_date_format',
'                 from wwv_flow_fnd_user',
'                where user_name = :APP_USER',
'                  and security_group_id = :flow_security_group_id',
'                  and trim(default_date_format) is not null) loop',
'        return c1.default_date_format;',
'        exit;',
'    end loop;',
'    --',
'    return :DATE_FORMAT;',
'end;'))
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/accessibility_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(582053521006435152.4508)
,p_lov_name=>'ACCESSIBILITY_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(582053521006435152.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(582053811202435157.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C2A4\D06C\B9B0 \B9AC\B354')
,p_lov_return_value=>'SCREEN_READER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/access_restrictions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(21837016666086569.4508)
,p_lov_name=>'ACCESS_RESTRICTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(21837016666086569.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21837217288086572.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B85C\CEEC \C11C\BC84\C5D0\C11C\B9CC \C0AC\C6A9\D560 \C218 \C788\C74C')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21837410790086575.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\B85C\CEEC \C11C\BC84\C640 \C6D0\ACA9 \D074\B77C\C774\C5B8\D2B8\C5D0\C11C \C0AC\C6A9\D560 \C218 \C788\C74C')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/active_inactive
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(133833120564560201.4508)
,p_lov_name=>'ACTIVE INACTIVE'
,p_lov_query=>'.'||wwv_flow_api.id(133833120564560201.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(133833301814560204.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D65C\C131')
,p_lov_return_value=>'ACTIVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(133833501889560209.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\BE44\D65C\C131')
,p_lov_return_value=>'INACTIVE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/alignment_left_right
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(40606619495197864.4508)
,p_lov_name=>'ALIGNMENT LEFT RIGHT'
,p_lov_query=>'.'||wwv_flow_api.id(40606619495197864.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40606830354197883.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C67C\CABD')
,p_lov_return_value=>'L'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40607009987197887.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C624\B978\CABD')
,p_lov_return_value=>'R'
);
end;
/
prompt --application/shared_components/user_interface/lovs/all_or_varchar2_column_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88068725864843110.4508)
,p_lov_name=>'ALL.OR.VARCHAR2.COLUMN.TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(88068725864843110.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88068924929843115.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\BAA8\B4E0 \C5F4 \C720\D615')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88069124491843115.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('VARCHAR \C5F4 \C720\D615')
,p_lov_return_value=>'0'
);
end;
/
prompt --application/shared_components/user_interface/lovs/all_selected_cols
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88062000322816814.4508)
,p_lov_name=>'ALL.SELECTED.COLS'
,p_lov_query=>'.'||wwv_flow_api.id(88062000322816814.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88062216112816814.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\BAA8\B4E0 \C5F4')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88062421264816815.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C120\D0DD\D55C \C5F4')
,p_lov_return_value=>'SELECTED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/analyze_opts
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88060821315813411.4508)
,p_lov_name=>'ANALYZE.OPTS'
,p_lov_query=>'.'||wwv_flow_api.id(88060821315813411.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88061023444813411.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D1B5\ACC4 \ACC4\C0B0')
,p_lov_return_value=>'COMPUTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88061212749813412.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\D1B5\ACC4 \C608\CE21')
,p_lov_return_value=>'ESTIMATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88061405135813412.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\AD6C\C870 \AC80\C99D')
,p_lov_return_value=>'VALIDATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_dictionary_query_conditions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(14480503854514923.4508)
,p_lov_name=>'APEX DICTIONARY QUERY CONDITIONS'
,p_lov_query=>'.'||wwv_flow_api.id(14480503854514923.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14480728931514923.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'='
,p_lov_return_value=>'='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14480909767514923.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'!='
,p_lov_return_value=>'!='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14481110010514923.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'LIKE'
,p_lov_return_value=>'LIKE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14493818099547338.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'NOT LIKE'
,p_lov_return_value=>'NOT LIKE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14482210780516882.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'>'
,p_lov_return_value=>'>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14482613551517732.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'<'
,p_lov_return_value=>'<'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14608723770258677.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'BETWEEN'
,p_lov_return_value=>'BETWEEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14609025848259268.4508)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'IS'
,p_lov_return_value=>'IS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_dictionary_view_modes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(14392800214125907.4508)
,p_lov_name=>'APEX DICTIONARY VIEW MODES'
,p_lov_query=>'.'||wwv_flow_api.id(14392800214125907.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14393015881125907.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C544\C774\CF58')
,p_lov_return_value=>'ICONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14393201164125907.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\D2B8\B9AC')
,p_lov_return_value=>'TREE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14393419313125907.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\BCF4\ACE0\C11C')
,p_lov_return_value=>'REPORT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_view_names
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(14454808001440421.4508)
,p_lov_name=>'APEX VIEW NAMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct apex_view_name d,',
'       apex_view_name r',
' from apex_dictionary ',
'where column_id=0',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/asc_desc_returns_asc_desc
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88023114905423598.4508)
,p_lov_name=>'ASC.DESC.RETURNS.ASC.DESC'
,p_lov_query=>'.'||wwv_flow_api.id(88023114905423598.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88023312120423599.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C624\B984\CC28\C21C')
,p_lov_return_value=>'ASC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88023515635423599.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\B0B4\B9BC\CC28\C21C')
,p_lov_return_value=>'DESC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ascdesc
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(23484408692637977.4508)
,p_lov_name=>'ASCDESC'
,p_lov_query=>'.'||wwv_flow_api.id(23484408692637977.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23484707046637977.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C624\B984\CC28\C21C')
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23484911662637978.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\B0B4\B9BC\CC28\C21C')
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/autocommit
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(136789232141518670.4508)
,p_lov_name=>'AUTOCOMMIT'
,p_lov_query=>'.'||wwv_flow_api.id(136789232141518670.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(136789414003518672.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C790\B3D9 \CEE4\BC0B')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/cascade_checkbox
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6527926084636289.4508)
,p_lov_name=>'CASCADE CHECKBOX'
,p_lov_query=>'.'||wwv_flow_api.id(6527926084636289.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6528129949636292.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'&nbsp'
,p_lov_return_value=>'CASCADE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/cascade_constraints
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88063516252821367.4508)
,p_lov_name=>'CASCADE.CONSTRAINTS'
,p_lov_query=>'.'||wwv_flow_api.id(88063516252821367.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88063706191821368.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\ACC4\B2E8\C2DD \C81C\C57D \C870\AC74?')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/case_sensitive_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88013722767293437.4508)
,p_lov_name=>'CASE.SENSITIVE.Y'
,p_lov_query=>'.'||wwv_flow_api.id(88013722767293437.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88013930765293438.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\B300\C18C\BB38\C790 \AD6C\BD84')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_for_views
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12319218872723617.4508)
,p_lov_name=>'CHECKBOX FOR VIEWS'
,p_lov_query=>'.'||wwv_flow_api.id(12319218872723617.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12319426920723618.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\BDF0')
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/constraint_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(8657002398372817.4508)
,p_lov_name=>'CONSTRAINT TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(8657002398372817.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8657206568372817.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\AC80\C0AC')
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8657415834372818.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\AE30\BCF8 \D0A4')
,p_lov_return_value=>'P'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8657606976372818.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\ACE0\C720')
,p_lov_return_value=>'U'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8657818917372818.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\CC38\C870')
,p_lov_return_value=>'R'
);
end;
/
prompt --application/shared_components/user_interface/lovs/constraint_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(11518010813871302.4508)
,p_lov_name=>'CONSTRAINT.STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(11518010813871302.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(11518205871871344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C0AC\C6A9\C73C\B85C \C124\C815\B428')
,p_lov_return_value=>'ENABLED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(11518415817871364.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\B428')
,p_lov_return_value=>'DISABLED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(11518621543871364.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\BAA8\B450')
,p_lov_return_value=>'ALL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/constraint_types_002
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88046920202557653.4508)
,p_lov_name=>'CONSTRAINT.TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(88046920202557653.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88047118047557654.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\AC80\C0AC')
,p_lov_return_value=>'CHECK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88047308153557654.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C678\B798 \D0A4')
,p_lov_return_value=>'FK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88047511353557655.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\AE30\BCF8 \D0A4')
,p_lov_return_value=>'PK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88047724693557655.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\ACE0\C720')
,p_lov_return_value=>'UNIQUE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/contraint_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(270341627024745223.4508)
,p_lov_name=>'CONTRAINT TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(270341627024745223.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(270341802062745225.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\AC80\C0AC')
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(270342021056745226.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\ACE0\C720')
,p_lov_return_value=>'U'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_index_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(16028009107759017.4508)
,p_lov_name=>'CREATE INDEX TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(16028009107759017.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16028212649759018.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C77C\BC18')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16028407362759020.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8')
,p_lov_return_value=>'T'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_package_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(14616623348446893.4508)
,p_lov_name=>'CREATE PACKAGE OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(14616623348446893.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14616819122446896.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C0AC\C591')
,p_lov_return_value=>'SPEC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14617002053446897.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\BCF8\BB38')
,p_lov_return_value=>'BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16842100401146005.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \D14C\C774\BE14\C758 \BA54\C18C\B4DC\B97C \C0AC\C6A9\D558\B294 \D328\D0A4\C9C0')
,p_lov_return_value=>'TABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_user_privileges
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(164684400772980444.4508)
,p_lov_name=>'CREATE USER PRIVILEGES'
,p_lov_query=>'.'||wwv_flow_api.id(164684400772980444.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164684601746980447.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'CONNECT'
,p_lov_return_value=>'CONNECT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164684816646980450.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'RESOURCE'
,p_lov_return_value=>'RESOURCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164685019181980451.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'DBA'
,p_lov_return_value=>'DBA'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_wizard_p200
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(30039215638453183.4508)
,p_lov_name=>'CREATE WIZARD P200'
,p_lov_query=>'.'||wwv_flow_api.id(30039215638453183.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30039406403453188.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C6F9 \C2DC\D2B8 \C560\D50C\B9AC\CF00\C774\C158')
,p_lov_return_value=>'WEBSHEET'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4900:205:&SESSION.::NO:200,205:P2_ID:"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30039600349453191.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790\C815\C758 \B370\C774\D130\BCA0\C774\C2A4 \C560\D50C\B9AC\CF00\C774\C158')
,p_lov_return_value=>'APPLICATION'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID:%2C"><img src="#IMAGE_PREFIX#menu/wiz_blank_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIc'
||'ons" /></a><br /><br />'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(30040019895453191.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \AC1D\CCB4')
,p_lov_return_value=>'DATABASE_OBJECT'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4500:1001:&SESSION."><img src="#IMAGE_PREFIX#menu/wiz_blank_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_package_how
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88084232331986937.4508)
,p_lov_name=>'CREATE.PACKAGE.HOW'
,p_lov_query=>'.'||wwv_flow_api.id(88084232331986937.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88084409721986937.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C0C8 \D328\D0A4\C9C0 \C791\C131')
,p_lov_return_value=>'SCRATCH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88084631917986937.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \D14C\C774\BE14\C758 \BA54\C18C\B4DC\B97C \C0AC\C6A9\D558\C5EC \D328\D0A4\C9C0 \C791\C131')
,p_lov_return_value=>'TABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_table_how
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88092414548047979.4508)
,p_lov_name=>'CREATE.TABLE.HOW'
,p_lov_query=>'.'||wwv_flow_api.id(88092414548047979.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88092609025047979.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C0C8\B85C \B9CC\B4E4\AE30')
,p_lov_return_value=>'SCRATCH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88092810507047980.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C2A4\D504\B808\B4DC\C2DC\D2B8\C5D0\C11C \BCF5\C0AC\D558\C5EC \BD99\C5EC\B123\AE30(\B370\C774\D130 \C6CC\D06C\C20D\C73C\B85C \C774\B3D9)')
,p_lov_return_value=>'SPREADSHEET'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_table_now_script
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88093424937050988.4508)
,p_lov_name=>'CREATE.TABLE.NOW.SCRIPT'
,p_lov_query=>'.'||wwv_flow_api.id(88093424937050988.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88093602555050989.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C9C0\AE08 \D14C\C774\BE14 \C0DD\C131')
,p_lov_return_value=>'RUN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88093808384050989.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('SQL \D3B8\C9D1\C744 \C704\D55C \C2A4\D06C\B9BD\D2B8 \C791\C131')
,p_lov_return_value=>'EDIT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_table_fk_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(111182618715174982.4508)
,p_lov_name=>'CREATE_TABLE_FK_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(111182618715174982.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(245703827624645868.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C0AD\C81C \D5C8\C6A9 \C548\D568')
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(111183005880174986.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\ACC4\B2E8\C2DD \C0AD\C81C')
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(111182804604174985.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\C0AD\C81C \C2DC \B110 \C124\C815')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_csv_col_delimiter
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3927422505659936.4508)
,p_lov_name=>'DATA.LOAD.CSV_COL_DELIMITER'
,p_lov_query=>'.'||wwv_flow_api.id(3927422505659936.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3927758348659940.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>','
,p_lov_return_value=>','
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3928144847659940.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>';'
,p_lov_return_value=>';'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3928530804659940.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'|'
,p_lov_return_value=>'|'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4182031389753526.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'#'
,p_lov_return_value=>'#'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3928907085659940.4508)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\D0ED')
,p_lov_return_value=>'tab'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_csv_enclosed_by
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3931221323686172.4508)
,p_lov_name=>'DATA.LOAD.CSV_ENCLOSED_BY'
,p_lov_query=>'.'||wwv_flow_api.id(3931221323686172.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4083926401630096.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C5C6\C74C')
,p_lov_return_value=>'None'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3931589877686177.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'"'
,p_lov_return_value=>'"'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3931843915686177.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>''''
,p_lov_return_value=>''''
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_first_line
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3934090607812623.4508)
,p_lov_name=>'DATA.LOAD.FIRST_LINE'
,p_lov_query=>'.'||wwv_flow_api.id(3934090607812623.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3934379444812623.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\CCAB\BC88\C9F8 \D589\C5D0 \BA38\B9AC\AE00 \D3EC\D568')
,p_lov_return_value=>'HEADERS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_force_sysguid
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(325824092198610958.4508)
,p_lov_name=>'DATA.LOAD.FORCE_SYSGUID'
,p_lov_query=>'.'||wwv_flow_api.id(325824092198610958.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(325824367791610958.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SYS_GUID'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(325824735376610959.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('ID \C5F4')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_max_row_range
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3867907456164412.4508)
,p_lov_name=>'DATA.LOAD.MAX_ROW_RANGE'
,p_lov_query=>'.'||wwv_flow_api.id(3867907456164412.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3868668632164428.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3870258934164431.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3870691602164431.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3925900413184232.4508)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\BAA8\B4E0 \D589')
,p_lov_return_value=>'0'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_source_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(212732804335774230.4508)
,p_lov_name=>'DATA.LOAD.SOURCE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(212732804335774230.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(212733137832774240.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D30C\C77C \C5C5\B85C\B4DC')
,p_lov_return_value=>'FILE'
,p_lov_template=>'<span class="a-Icon icon-file-upload" aria-hidden="true"></span> #DISPLAY_VALUE#'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(212733551391774249.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\BCF5\C0AC \BC0F \BD99\C5EC\B123\AE30')
,p_lov_return_value=>'COPY_PASTE'
,p_lov_template=>'<span class="a-Icon icon-clipboard" aria-hidden="true"></span> #DISPLAY_VALUE#'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3891423527523942.4508)
,p_lov_name=>'DATA.LOAD.STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(3891423527523942.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3891740585523942.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C2E4\D589 \C911')
,p_lov_return_value=>'RUNNING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3892162613523943.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C644\B8CC\B428')
,p_lov_return_value=>'FINISHED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3924280979996980.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\C2E4\D328')
,p_lov_return_value=>'FAILED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_use_data_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2791739671154769.4508)
,p_lov_name=>'DATA.LOAD.USE_DATA_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(2791739671154769.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2792061691154772.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C5F4 \B370\C774\D130 \C720\D615 \C0AC\C6A9')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_upload_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1643936135665207.4508)
,p_lov_name=>'DATA.UPLOAD.TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(1643936135665207.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1644247579665210.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D30C\C77C \C5C5\B85C\B4DC')
,p_lov_return_value=>'FILE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1644613825665214.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\BCF5\C0AC \BC0F \BD99\C5EC\B123\AE30')
,p_lov_return_value=>'COPY_PASTE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(21015224563508746.4508)
,p_lov_name=>'DATA_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(21015224563508746.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21015508059508749.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'NUMBER'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21015722350508750.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'VARCHAR2'
,p_lov_return_value=>'VARCHAR2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21015902475508751.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'DATE'
,p_lov_return_value=>'DATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21016106513508751.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'TIMESTAMP'
,p_lov_return_value=>'TIMESTAMP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21016525754508751.4508)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'CLOB'
,p_lov_return_value=>'CLOB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21016725005508751.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'BLOB'
,p_lov_return_value=>'BLOB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24123119765584645.4508)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'BFILE'
,p_lov_return_value=>'BFILE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21016327140508751.4508)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'CHAR'
,p_lov_return_value=>'CHAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24128605267608850.4508)
,p_lov_disp_sequence=>85
,p_lov_disp_value=>'FLOAT'
,p_lov_return_value=>'FLOAT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24122330370578271.4508)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'INTERVAL YEAR TO MONTH'
,p_lov_return_value=>'INTERVAL YEAR TO MONTH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24122503489579932.4508)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'INTERVAL DAY TO SECOND'
,p_lov_return_value=>'INTERVAL DAY TO SECOND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24121914440573626.4508)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'TIMESTAMP WITH TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH TIME ZONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24122121020575524.4508)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21019413051524343.4508)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'BINARY_FLOAT'
,p_lov_return_value=>'BINARY_FLOAT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21019722401527136.4508)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>'BINARY_DOUBLE'
,p_lov_return_value=>'BINARY_DOUBLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24122707991581257.4508)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>'RAW'
,p_lov_return_value=>'RAW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24122911108582116.4508)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>'LONG RAW'
,p_lov_return_value=>'LONG RAW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24128400765607550.4508)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>'NCHAR'
,p_lov_return_value=>'NCHAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21016914224508752.4508)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>'NVARCHAR2'
,p_lov_return_value=>'NVARCHAR2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24138600492263086.4508)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>'NCLOB'
,p_lov_return_value=>'NCLOB'
);
end;
/
prompt --application/shared_components/user_interface/lovs/db_session_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1225013363619314377.4508)
,p_lov_name=>'DB SESSION STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(1225013363619314377.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1225013668008314381.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D604\C7AC \C138\C158')
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1225013946804314386.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\AE34 \D2B8\B79C\C7AD\C158')
,p_lov_return_value=>'L'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1225014259544314386.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\D65C\C131 \C138\C158')
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1225014590119314386.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\C720\D734 \C138\C158')
,p_lov_return_value=>'I'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1225014814217314386.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\CC28\B2E8 \C911\C778 \C138\C158')
,p_lov_return_value=>'B'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1225015134770314386.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\CC28\B2E8\B41C \C138\C158')
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/db_parm_non_default
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(244335514951659559.4508)
,p_lov_name=>'DB_PARM_NON_DEFAULT'
,p_lov_query=>'.'||wwv_flow_api.id(244335514951659559.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244335715591659561.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\BAA8\B450')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244335932066659565.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\BE44\AE30\BCF8\AC12')
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ddl_actions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88039608166535203.4508)
,p_lov_name=>'DDL.ACTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(88039608166535203.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88039800819535204.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C5F4 \CD94\AC00')
,p_lov_return_value=>'ADD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88040002165535204.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C81C\C57D \C870\AC74 \CD94\AC00')
,p_lov_return_value=>'ADD_CONSTRAINT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88040231651535205.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\BD84\C11D')
,p_lov_return_value=>'ANALYZE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88040417249535205.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\BCF5\C0AC')
,p_lov_return_value=>'COPY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88040624827535205.4508)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\C778\B371\C2A4 \C0DD\C131')
,p_lov_return_value=>'INDEX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88040822124535205.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8 \C778\B371\C2A4 \C0DD\C131')
,p_lov_return_value=>'TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88041012331535206.4508)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70 \C0DD\C131')
,p_lov_return_value=>'CREATE_TRIGGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88041229308535206.4508)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\C81C\C57D \C870\AC74\C744 \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815')
,p_lov_return_value=>'DISABLE_CONSTRAINT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88041400926535206.4508)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70\B97C \C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815')
,p_lov_return_value=>'DISABLE_TRIGGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88041603607535208.4508)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\C5F4 \C0AD\C81C')
,p_lov_return_value=>'REMOVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88041815176535208.4508)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\C81C\C57D \C870\AC74 \C0AD\C81C')
,p_lov_return_value=>'DROP_CONSTRAINT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88042009088535208.4508)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('\C778\B371\C2A4 \C0AD\C81C')
,p_lov_return_value=>'DROP_INDEX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88042226760535209.4508)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>unistr('\D14C\C774\BE14 \C0AD\C81C')
,p_lov_return_value=>'DROP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88042406323535209.4508)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70 \C0AD\C81C')
,p_lov_return_value=>'DROP_TRIGGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88042607701535209.4508)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>unistr('\C81C\C57D \C870\AC74\C744 \C0AC\C6A9\C73C\B85C \C124\C815')
,p_lov_return_value=>'ENABLE_CONSTRAINT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88042803313535209.4508)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70\B97C \C0AC\C6A9\C73C\B85C \C124\C815')
,p_lov_return_value=>'ENABLE_TRIGGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88043019072535210.4508)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>unistr('\C5F4 \C218\C815')
,p_lov_return_value=>'MODIFY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88043204776535210.4508)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>unistr('\C5F4 \C774\B984 \BC14\AFB8\AE30')
,p_lov_return_value=>'RENAME_COLUMN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88043422512535210.4508)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>unistr('\D14C\C774\BE14 \C774\B984 \BC14\AFB8\AE30')
,p_lov_return_value=>'RENAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88043603529535211.4508)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>unistr('\C790\B974\AE30')
,p_lov_return_value=>'TRUNCATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/describe_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(22153924949556802.4508)
,p_lov_name=>'DESCRIBE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(22153924949556802.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22154111837556805.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'TABLE'
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22517827091787523.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'VIEW'
,p_lov_return_value=>'VIEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22518130554788590.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'PROCEDURE'
,p_lov_return_value=>'PROCEDURE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22518404019790369.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'FUNCTION'
,p_lov_return_value=>'FUNCTION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22518909907792079.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'PACKAGE'
,p_lov_return_value=>'PACKAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_inline
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88029914736461415.4508)
,p_lov_name=>'DISPLAY.INLINE'
,p_lov_query=>'.'||wwv_flow_api.id(88029914736461415.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88030128904461415.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C778\B77C\C778\C73C\B85C \D45C\C2DC')
,p_lov_return_value=>'DISPLAY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_as_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(285136607862263925.4508)
,p_lov_name=>'DISPLAY_AS_REPORTS'
,p_reference_id=>285506029323635827.4508
,p_lov_query=>'.'||wwv_flow_api.id(285136607862263925.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108084526445030643.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D45C\C900 \BCF4\ACE0\C11C \C5F4(\D45C\C2DC \C804\C6A9, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108084705562030643.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(LOV \AE30\BC18, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'TEXT_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108084932477030643.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(\C0C1\D0DC \C800\C7A5)')
,p_lov_return_value=>'DISPLAY_AND_SAVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108085112395030643.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(\C774\C2A4\CF00\C774\D504 \D2B9\C218 \BB38\C790, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108085330405030643.4508)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\C228\AE40 ')
,p_lov_return_value=>'HIDDEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_as_tabular_forms
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(173321532130152965.4508)
,p_lov_name=>'DISPLAY_AS_TABULAR_FORMS'
,p_lov_query=>'.'||wwv_flow_api.id(173321532130152965.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108070909691016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D45C\C900 \BCF4\ACE0\C11C \C5F4(\D45C\C2DC \C804\C6A9, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108071103633016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(LOV \AE30\BC18, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'TEXT_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108071320755016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(\C0C1\D0DC \C800\C7A5)')
,p_lov_return_value=>'DISPLAY_AND_SAVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108071517893016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(\C774\C2A4\CF00\C774\D504 \D2B9\C218 \BB38\C790, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108071726823016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8 \D544\B4DC')
,p_lov_return_value=>'TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108071926389016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8 \C601\C5ED')
,p_lov_return_value=>'TEXTAREA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108072101156016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C120\D0DD \BAA9\B85D')
,p_lov_return_value=>'SELECT_LIST_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108072319348016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C228\AE40 ')
,p_lov_return_value=>'HIDDEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108072523666016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D31D\C5C5 LOV')
,p_lov_return_value=>'POPUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108072726301016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30')
,p_lov_return_value=>'DATE_POPUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108072902041016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(\C560\D50C\B9AC\CF00\C774\C158 \D615\C2DD \B9C8\C2A4\D06C \C0AC\C6A9)')
,p_lov_return_value=>'PICK_DATE_USING_APP_FORMAT_MASK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108073114807016343.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-RR)')
,p_lov_return_value=>'PICK_DATE_DD_MON_RR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108073320317016344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-RR HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108073505124016344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-RR HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108073706032016344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH24_MI'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108073911349016344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YY HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH_MI'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108074115783016344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YYYY)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108074322493016344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YYYY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108074521430016344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YYYY HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108074730419016344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YY)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YY'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108074911008016344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD/MM/YYYY)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108075100812016344.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD/MM/YYYY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108075332696016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD/MM/YYYY HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108075516430016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(MM/DD/YYYY)')
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108075700209016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(MM/DD/YYYY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108075913799016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(MM/DD/YYYY HH:MI)')
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108076125223016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(RR-MON-DD)')
,p_lov_return_value=>'PICK_DATE_RR_MON_DD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108076313464016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(RR-MON-DD HH24:MI)')
,p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108076515529016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(RR-MON-DD HH:MI)')
,p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108076725453016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY-MM-DD)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108076913772016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY-MM-DD HH24:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108077111031016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY-MM-DD HH:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108077331467016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MM-YYYY)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108077528710016345.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MM-YYYY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108077720268016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MM-YYYY HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108077923098016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD.MM.YYYY)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108078110678016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD.MM.YYYY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108078309308016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD.MM.YYYY HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108078528637016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY.DD.MM)')
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108078730750016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY.DD.MM HH24:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108078928693016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY.DD.MM HH:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH_MI_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108079128762016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY/MM/DD)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_SLASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108079326218016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY/MM/DD HH24:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108079524994016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY/MM/DD HH:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(108079705480016346.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(\C560\D50C\B9AC\CF00\C774\C158 \B0A0\C9DC \D615\C2DD \C0AC\C6A9)')
,p_lov_return_value=>'PICK_DATE_USING_APP_DATE_FORMAT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_or_save
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88028228457455927.4508)
,p_lov_name=>'DISPLAY_OR_SAVE'
,p_lov_query=>'.'||wwv_flow_api.id(88028228457455927.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88028407997455927.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C778\B77C\C778\C73C\B85C \D45C\C2DC')
,p_lov_return_value=>'DISPLAY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88028614614455928.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C2A4\D06C\B9BD\D2B8 \D30C\C77C\B85C \C800\C7A5')
,p_lov_return_value=>'SCRIPT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/distinct_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(102422424410025075.4508)
,p_lov_name=>'DISTINCT_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct :column_name',
'',
'from   :table_name',
'',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_object_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(167453708814513863.4508)
,p_lov_name=>'DYNAMIC OBJECT TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct',
'       object_type d,',
'       object_type r',
' from sys.dba_objects where owner = :F4500_P500_SCHEMA',
'union  select ''DATABASE LINK'' d,''DATABASE LINK'' r from dual',
'union  select ''TABLE'' d,''TABLE'' r from dual',
'union  select ''TRIGGER'' d,''TRIGGER'' r from dual',
'union  select ''JAVA CLASS'' d,''JAVA CLASS'' r from dual',
'union  select ''JAVA SOURCE'' d,''JAVA SOURCE'' r from dual',
'union  select ''INDEX'' d,''INDEX'' r from dual',
'union  select ''SEQUENCE'' d,''SEQUENCE'' r from dual',
'union  select ''FUNCTION'' d,''FUNCTION'' r from dual',
'union  select ''PROCEDURE'' d,''PROCEDURE'' r from dual',
'union  select ''PACKAGE'' d,''PACKAGE'' r from dual',
'union  select ''PACKAGE BODY'' d,''PACKAGE BODY'' r from dual',
'union  select ''XML SCHEMA'' d,''XML SCHEMA'' r from dual',
'union  select ''TYPE'' d,''TYPE'' r from dual',
'union  select ''VIEW'' d,''VIEW'' r from dual',
'union  select ''MATERIALIZED VIEW'' d,''MATERIALIZED VIEW'' r from dual',
'union  select ''SYNONYM'' d,''SYNONYM'' r from dual',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/expire_password
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7461015136055036.4508)
,p_lov_name=>'EXPIRE PASSWORD'
,p_lov_query=>'.'||wwv_flow_api.id(7461015136055036.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7461210075055051.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'&nbsp;'
,p_lov_return_value=>'EXPIRE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/f4500_p93_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(166001030922348323.4508)
,p_lov_name=>'F4500_P93_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(COLUMN_NAME)||'' (''||data_type||'')'' d,  column_name r',
'from sys.dba_tab_columns',
'where owner =  upper(:OB_SCHEMA) and',
'table_name= :OBJECT_NAME and column_id is not null',
'order by column_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/for_each_row
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88058923955804681.4508)
,p_lov_name=>'FOR.EACH.ROW'
,p_lov_query=>'.'||wwv_flow_api.id(88058923955804681.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88059109438804682.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\AC01 \D589\C5D0 \B300\D574')
,p_lov_return_value=>'for each row'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_from_4000
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(197481124765787930.4508)
,p_lov_name=>'FORMAT_MASK_DYNAMIC (FROM 4000)'
,p_reference_id=>44798420131812391.4508
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_no_since_from_4000
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(460129911419159358.4508)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_NO_SINCE (FROM 4000)'
,p_reference_id=>170713321121898589.4508
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_number_from_4000
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(460130116613160765.4508)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_NUMBER (FROM 4000)'
,p_reference_id=>441970320516445261.4508
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''N''',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/form_validation_data_type_from_4000
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(197595525878393704.4508)
,p_lov_name=>'FORM_VALIDATION_DATA_TYPE (FROM 4000)'
,p_reference_id=>197490902498999083.4508
,p_lov_query=>'.'||wwv_flow_api.id(197595525878393704.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197596203845396779.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'NUMBER'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197596425687396780.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'VARCHAR'
,p_lov_return_value=>'VARCHAR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/grant_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(270678820518416779.4508)
,p_lov_name=>'GRANT_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(270678820518416779.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(270679015580416783.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BAA8\B450')
,p_lov_return_value=>'All'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(270679225991416783.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\D2B9\C815 \AD8C\D55C')
,p_lov_return_value=>'Specific'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_iana_charset
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(143356515285702408.4508)
,p_lov_name=>'I18N_IANA_CHARSET'
,p_reference_id=>144796827445692396.4508
,p_lov_query=>'.'||wwv_flow_api.id(143356515285702408.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9229220048925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C544\B78D\C5B4 ISO-8859-6')
,p_lov_return_value=>'iso-8859-6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9229405581925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C544\B78D\C5B4 Windows 1256')
,p_lov_return_value=>'windows-1256'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9229628588925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C911\AD6D\C5B4 Big5')
,p_lov_return_value=>'big5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9229827838925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C911\AD6D\C5B4 GBK')
,p_lov_return_value=>'gbk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9230014665925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D0A4\B9B4\C5B4 ISO-8859-5')
,p_lov_return_value=>'iso-8859-5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9230231223925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D0A4\B9B4\C5B4 KOI8-R')
,p_lov_return_value=>'koi8-r'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9230421211925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D0A4\B9B4\C5B4 KOI8-U')
,p_lov_return_value=>'koi8-u'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9230611952925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D0A4\B9B4\C5B4 Windows 1251')
,p_lov_return_value=>'windows-1251'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9230825878925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B3D9\C720\B7FD\C5B4 ISO-8859-2')
,p_lov_return_value=>'iso-8859-2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9231020628925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B3D9\C720\B7FD\C5B4 Windows 1250')
,p_lov_return_value=>'windows-1250'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9231210284925457.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\ADF8\B9AC\C2A4\C5B4 ISO-8859-7')
,p_lov_return_value=>'iso-8859-7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9231417884925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\ADF8\B9AC\C2A4\C5B4 Windows 1253')
,p_lov_return_value=>'windows-1253'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9231628287925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D788\BE0C\B9AC\C5B4 ISO-8859-8-i')
,p_lov_return_value=>'iso-8859-8-i'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9231830514925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D788\BE0C\B9AC\C5B4 Windows 1255')
,p_lov_return_value=>'windows-1255'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9232010444925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C77C\BCF8\C5B4 EUC')
,p_lov_return_value=>'euc-jp'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9232217412925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C77C\BCF8\C5B4 Shift JIS')
,p_lov_return_value=>'shift_jis'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9232432569925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D55C\AD6D\C5B4 EUC-KR')
,p_lov_return_value=>'euc-kr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9232618695925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BD81\C720\B7FD\C5B4 ISO-8859-4')
,p_lov_return_value=>'iso-8859-4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9232801800925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BD81\C720\B7FD\C5B4 Windows 1257')
,p_lov_return_value=>'windows-1257'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9233008729925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A8\C720\B7FD\C5B4 ISO-8859-3')
,p_lov_return_value=>'iso-8859-3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9233226333925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D0DC\AD6D\C5B4 TIS-620')
,p_lov_return_value=>'tis-620'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9233412235925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D130\D0A4\C5B4 ISO-8859-9')
,p_lov_return_value=>'iso-8859-9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9233629658925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D130\D0A4\C5B4 Windows 1254')
,p_lov_return_value=>'windows-1254'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9233803634925458.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C720\B2C8\CF54\B4DC UTF-8')
,p_lov_return_value=>'utf-8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9234002057925459.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C720\B2C8\CF54\B4DC UTF-16 \BE45 \C5D4\B514\C5B8')
,p_lov_return_value=>'utf-16be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9234209685925459.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C720\B2C8\CF54\B4DC UTF-16 \B9AC\D2C0 \C5D4\B514\C5B8')
,p_lov_return_value=>'utf-16le'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9234405813925459.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'US-ASCII'
,p_lov_return_value=>'us-ascii'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9234624781925459.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BCA0\D2B8\B0A8\C5B4 Windows 1258')
,p_lov_return_value=>'windows-1258'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9234826068925459.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C11C\C720\B7FD\C5B4 ISO-8859-1')
,p_lov_return_value=>'iso-8859-1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9235025977925459.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C11C\C720\B7FD\C5B4 Windows 1252')
,p_lov_return_value=>'windows-1252'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_iana_db_charset
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(143362112016702427.4508)
,p_lov_name=>'I18N_IANA_DB_CHARSET'
,p_reference_id=>144802427115692411.4508
,p_lov_query=>'.'||wwv_flow_api.id(143362112016702427.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9197525868826969.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C544\B78D\C5B4 ISO-8859-6')
,p_lov_return_value=>'AR8ISO8859P6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9197719499826969.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C544\B78D\C5B4 Windows 1256')
,p_lov_return_value=>'AR8MSWIN1256'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9197926602826969.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\C911\AD6D\C5B4 Big5')
,p_lov_return_value=>'ZHT16MSWIN950'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9198108871826969.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\C911\AD6D\C5B4 GBK')
,p_lov_return_value=>'ZHS16GBK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9198314327826969.4508)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\D0A4\B9B4\C5B4 ISO-8859-5')
,p_lov_return_value=>'CL8ISO8859P5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9198509701826969.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\D0A4\B9B4\C5B4 KOI8-R')
,p_lov_return_value=>'CL8KOI8R'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9198725529826969.4508)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\D0A4\B9B4\C5B4 KOI8-U')
,p_lov_return_value=>'CL8KOI8U'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9198913491826970.4508)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\D0A4\B9B4\C5B4 Windows 1251')
,p_lov_return_value=>'CL8MSWIN1251'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9199128797826970.4508)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\B3D9\C720\B7FD\C5B4 ISO-8859-2')
,p_lov_return_value=>'EE8ISO8859P2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9199323295826970.4508)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\B3D9\C720\B7FD\C5B4 Windows 1250')
,p_lov_return_value=>'EE8MSWIN1250'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9199525603826970.4508)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>unistr('\ADF8\B9AC\C2A4\C5B4 ISO-8859-7')
,p_lov_return_value=>'EL8ISO8859P7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9199710618826970.4508)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('\ADF8\B9AC\C2A4\C5B4 Windows 1253')
,p_lov_return_value=>'EL8MSWIN1253'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9199917873826970.4508)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>unistr('\D788\BE0C\B9AC\C5B4 ISO-8859-8-i')
,p_lov_return_value=>'IW8ISO8859P8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9200124476826971.4508)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>unistr('\D788\BE0C\B9AC\C5B4 Windows 1255')
,p_lov_return_value=>'IW8MSWIN1255'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9200304639826971.4508)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>unistr('\C77C\BCF8\C5B4 EUC')
,p_lov_return_value=>'JA16EUC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9200514410826971.4508)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>unistr('\C77C\BCF8\C5B4 Shift JIS')
,p_lov_return_value=>'JA16SJIS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9200704239826971.4508)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>unistr('\D55C\AD6D\C5B4 EUC-KR')
,p_lov_return_value=>'KO16MSWIN949'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9200903786826971.4508)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>unistr('\BD81\C720\B7FD\C5B4 ISO-8859-4')
,p_lov_return_value=>'NEE8ISO8859P4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9201130515826971.4508)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>unistr('\BD81\C720\B7FD\C5B4 Windows 1257')
,p_lov_return_value=>'BLT8MSWIN1257'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9201303279826971.4508)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>unistr('\B0A8\C720\B7FD\C5B4 ISO-8859-3')
,p_lov_return_value=>'SE8ISO8859P3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9201518062826971.4508)
,p_lov_disp_sequence=>210
,p_lov_disp_value=>unistr('\D0DC\AD6D\C5B4 TIS-620')
,p_lov_return_value=>'TH8TISASCII'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9201729626826971.4508)
,p_lov_disp_sequence=>220
,p_lov_disp_value=>unistr('\D130\D0A4\C5B4 ISO-8859-9')
,p_lov_return_value=>'WE8ISO8859P9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9201928057826971.4508)
,p_lov_disp_sequence=>230
,p_lov_disp_value=>unistr('\D130\D0A4\C5B4 Windows 1254')
,p_lov_return_value=>'TR8MSWIN1254'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9202110863826971.4508)
,p_lov_disp_sequence=>240
,p_lov_disp_value=>unistr('\C720\B2C8\CF54\B4DC UTF-8')
,p_lov_return_value=>'AL32UTF8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9202305353826971.4508)
,p_lov_disp_sequence=>242
,p_lov_disp_value=>unistr('\C720\B2C8\CF54\B4DC UTF-16 \BE45 \C5D4\B514\C5B8')
,p_lov_return_value=>'AL16UTF16'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9202522080826972.4508)
,p_lov_disp_sequence=>244
,p_lov_disp_value=>unistr('\C720\B2C8\CF54\B4DC UTF-16 \B9AC\D2C0 \C5D4\B514\C5B8')
,p_lov_return_value=>'AL16UTF16LE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9202732398826972.4508)
,p_lov_disp_sequence=>248
,p_lov_disp_value=>'US-ASCII'
,p_lov_return_value=>'US7ASCII'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9202914568826972.4508)
,p_lov_disp_sequence=>250
,p_lov_disp_value=>unistr('\BCA0\D2B8\B0A8\C5B4 Windows 1258')
,p_lov_return_value=>'VN8MSWIN1258'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9203117480826972.4508)
,p_lov_disp_sequence=>260
,p_lov_disp_value=>unistr('\C11C\C720\B7FD\C5B4 ISO-8859-1')
,p_lov_return_value=>'WE8ISO8859P1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9203309867826972.4508)
,p_lov_disp_sequence=>270
,p_lov_disp_value=>unistr('\C11C\C720\B7FD\C5B4 Windows 1252')
,p_lov_return_value=>'WE8MSWIN1252'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_detail_view_modes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(144167830179232748.4508)
,p_lov_name=>'ICON DETAIL VIEW MODES'
,p_reference_id=>116048926655714272.4508
,p_lov_query=>'.'||wwv_flow_api.id(144167830179232748.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(240823626953628604.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C544\C774\CF58')
,p_lov_return_value=>'ICON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(240823804523628605.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\C138\BD80\C815\BCF4')
,p_lov_return_value=>'DETAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/identity_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(254185527365105468.4508)
,p_lov_name=>'IDENTITY_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(254185527365105468.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(254185828755105469.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D56D\C0C1')
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(254186111548105469.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\AE30\BCF8\AC12')
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(254186405911105469.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\B110\C5D0 \B300\D55C \AE30\BCF8\AC12')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_args_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88064701145826564.4508)
,p_lov_name=>'INCLUDE.ARGS.Y'
,p_lov_query=>'.'||wwv_flow_api.id(88064701145826564.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88064927960826565.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C778\C218 \D3EC\D568')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/intra_component_navigator
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1457916849659682.4508)
,p_lov_name=>'INTRA COMPONENT NAVIGATOR'
,p_lov_query=>'.'||wwv_flow_api.id(1457916849659682.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1458119331659683.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\AC1D\CCB4 \BE0C\B77C\C6B0\C800')
,p_lov_return_value=>'1001'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1458304212659683.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('SQL \BA85\B839')
,p_lov_return_value=>'1003'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1458524645659683.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('SQL \C2A4\D06C\B9BD\D2B8')
,p_lov_return_value=>'1004'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1458701375659683.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\C9C8\C758 \C791\C131\AE30')
,p_lov_return_value=>'1002'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_types_without_plugins
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(29577622544843540.4508)
,p_lov_name=>'ITEM_TYPES (WITHOUT PLUGINS)'
,p_reference_id=>29544521926748713.4508
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_native_plugins varchar2(255);',
'begin',
'    l_native_plugins := '' union all select display_name as d, name_with_prefix as r from wwv_flow_native_plugins where plugin_type = ''''ITEM TYPE'''' order by 1'';',
'',
'    if lower(wwv_flow.g_flow_language) = ''en'' then',
'        return ''select display_name as d, name as r from wwv_flow_standard_item_types''||l_native_plugins;',
'    else',
'        return ''select wwv_flow_lang.system_message(''''ITEM_TYPE.''''||name) as d, name as r from wwv_flow_standard_item_types''||l_native_plugins;',
'    end if;',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/language_selector
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(111525828615050878.4508)
,p_lov_name=>'LANGUAGE_SELECTOR'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''en'' d, ''en'' r',
'  from dual',
'union ',
'select flow_language d, flow_language r',
'  from wwv_flows',
' where id in ',
' (select translation_flow_id',
'    from wwv_flow_language_map',
'   where primary_language_flow_id = v(''APP_ID''))',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_all_schemas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(26396713461308449.4508)
,p_lov_name=>'LIST_ALL_SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select username d, username v',
'from sys.dba_users ',
'where wwv_flow_provisioning.restricted_schema_i(username,:APP_USER) = 0',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_all_schemas_wo_ob_schema
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(26377214558019246.4508)
,p_lov_name=>'LIST_ALL_SCHEMAS_WO_OB_SCHEMA'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select username d, username v',
'from sys.dba_users',
'where wwv_flow_provisioning.restricted_schema_i(username,:APP_USER) = 0  ',
'and username !=  :OB_SCHEMA   ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(64015215313088942.4508)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  q      varchar2(32767) := null;',
'begin  ',
'  q:=''select wwv_flow_escape.html(upper(c.schema)) d, upper(c.schema) v '';',
'  q:=q||''from   wwv_flow_company_schemas c, '';',
'  q:=q||''       wwv_flow_fnd_user u '';',
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.user_name = :flow_user and '';',
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';',
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';',
'  q:=q||''order by 1'';  ',
'  return q;',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas_qb
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(14016705748242026.4508)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS-QB'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  q      varchar2(32767) := null;',
'begin',
'  q:=''select wwv_flow_escape.html(upper(c.schema)) d, upper(c.schema) v '';',
'  q:=q||''from   wwv_flow_company_schemas c, ''; ',
'  q:=q||''       wwv_flow_fnd_user u ''; ',
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.user_name = :flow_user and '';',
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';',
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';',
'  q:=q||''  and  nvl(:P1002_POPUP,0) <> 1 '';',
'  q:=q||''union all '';',
'  q:=q||''select wwv_flow_escape.html(:P1002_SCHEMA) a,:P1002_SCHEMA b from dual '';',
'  q:=q||''where  :P1002_POPUP = 1 '';',
'  q:=q||''order by 1'';',
'  return q;',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas_sc
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(23001304041139468.4508)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS-SC'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  q      varchar2(32767) := null;',
'begin  ',
'  q:=''select /* APEX4500L1 */ wwv_flow_escape.html(upper(c.schema)) d, upper(c.schema) v '';',
'  q:=q||''from   wwv_flow_company_schemas c, '';',
'  q:=q||''       wwv_flow_fnd_user u '';',
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.user_name = :flow_user and '';',
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';',
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';',
'  q:=q||''  and  nvl(:P1003_POPUP,0) <> 1 '';',
'  q:=q||''union all '';',
'  q:=q||''select wwv_flow_escape.html(:P1003_SCHEMA) a,:P1003_SCHEMA b from dual '';',
'  q:=q||''where  :P1003_POPUP = 1 '';',
'  q:=q||''order by 1'';  ',
'  return q;',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_sequences
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(20606105200562019.4508)
,p_lov_name=>'LIST_SEQUENCES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(sequence_name) a, sequence_name b from sys.dba_sequences ',
'where sequence_owner = :OB_SCHEMA',
'order by sequence_name',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_users
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(96930227515507687.4508)
,p_lov_name=>'LIST_USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- '' || wwv_flow_lang.system_message(''ALL_USERS'') || '' -'' d, ''0'' r',
'  from dual',
' where exists (',
'    select null',
'      from  wwv_flow_developers ',
'     where security_group_id = :flow_security_group_id ',
'       and userid = :flow_user ',
'       and instr(developer_role||'':'',''ADMIN:'') > 0)',
'union all',
'select user_name d, user_name r',
'  from wwv_flow_fnd_user',
' where security_group_id = :flow_security_group_id',
'   and (user_name = :flow_user or exists',
'        (select null from wwv_flow_developers',
'          where security_group_id = :flow_security_group_id',
'            and userid = :flow_user',
'            and instr(developer_role||'':'',''ADMIN:'') > 0))',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/login_message
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(21459801069722432.4508)
,p_lov_name=>'LOGIN_MESSAGE'
,p_lov_query=>'.'||wwv_flow_api.id(21459801069722432.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21460014390722445.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BA54\C2DC\C9C0 \C5C6\C74C')
,p_lov_return_value=>'NONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(21460423875722448.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790\C815\C758 \BA54\C2DC\C9C0')
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/manage_table_constraints
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(165911414842182864.4508)
,p_lov_name=>'MANAGE.TABLE.CONSTRAINTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(c.constraint_name) d,  c.constraint_name r',
'from sys.dba_constraints c, sys.dba_cons_columns l',
'where c.table_name = :OBJECT_NAME',
'and c.owner = :OBJECT_OWNER',
'and c.constraint_type in (''P'',''U'',''C'',''R'')',
'and c.constraint_name = l.constraint_name ',
'and l.owner = :OBJECT_OWNER',
'and l.table_name = :OBJECT_NAME',
'and (l.position = 1 or l.position is null)',
'and c.status = ''ENABLED''',
'order by c.constraint_name, c.constraint_type, l.position'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_a
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88005728392276151.4508)
,p_lov_name=>'MAX_ROWS_A'
,p_lov_query=>'.'||wwv_flow_api.id(88005728392276151.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88005902539276153.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88006132674276154.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88006303849276154.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88006502528276154.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88006721789276154.4508)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88006905692276155.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88007113392276155.4508)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88007318997276155.4508)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88007513744276155.4508)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(182328908607767113.4508)
,p_lov_disp_sequence=>5000
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(260332524931295254.4508)
,p_lov_disp_sequence=>10000
,p_lov_disp_value=>'10000'
,p_lov_return_value=>'10000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(260332828394296254.4508)
,p_lov_disp_sequence=>100000
,p_lov_disp_value=>'100000'
,p_lov_return_value=>'100000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_b
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88008910861280555.4508)
,p_lov_name=>'MAX_ROWS_B'
,p_lov_query=>'.'||wwv_flow_api.id(88008910861280555.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183741320426917019.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88009125818280556.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88009318636280556.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88009527364280557.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88009708671280557.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88009918679280557.4508)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88010107969280558.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88010312982280558.4508)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88010525571280558.4508)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88010713109280558.4508)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88010919618280559.4508)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88011124222280559.4508)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'10000'
,p_lov_return_value=>'10000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88011310169280559.4508)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'50000'
,p_lov_return_value=>'50000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/more_less_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(161595731562973452.4508)
,p_lov_name=>'MORE_LESS_COLUMNS'
,p_lov_query=>'.'||wwv_flow_api.id(161595731562973452.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161595917373973455.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C5F4 \CD94\AC00')
,p_lov_return_value=>'MORE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161596108445973460.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C5F4 \C81C\AC70')
,p_lov_return_value=>'LESS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/my_job
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88020412686337805.4508)
,p_lov_name=>'MY.JOB'
,p_lov_query=>'.'||wwv_flow_api.id(88020412686337805.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88020600548337806.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\B0B4 \C791\C5C5')
,p_lov_return_value=>'my_job'
);
end;
/
prompt --application/shared_components/user_interface/lovs/null_notnull
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88038204225524574.4508)
,p_lov_name=>'NULL.NOTNULL'
,p_lov_query=>'.'||wwv_flow_api.id(88038204225524574.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88038423679524575.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('NOT NULL(\AC12 \D544\C694)')
,p_lov_return_value=>'NOT NULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88038631515524575.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('NULL(\AC12\C774 \D544\C694\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'NULL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/object_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88081132547977521.4508)
,p_lov_name=>'OBJECT.TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select initcap(wwv_flow_lang.system_message(''FUNCTION'')) d, ''98'' r from dual union all',
'select initcap(wwv_flow_lang.system_message(''INDEX'')) d, ''INDEX'' r from dual union all     ',
'select initcap(wwv_flow_lang.system_message(''PACKAGE'')) d, ''117'' r from dual union all     ',
'select initcap(wwv_flow_lang.system_message(''PROCEDURE'')) d, ''121'' r from dual union all     ',
'select initcap(wwv_flow_lang.system_message(''SEQUENCE'')) d, ''97'' r from dual union all     ',
'select initcap(wwv_flow_lang.system_message(''SYNONYM'')) d, ''99'' r from dual union all     ',
'select initcap(wwv_flow_lang.system_message(''TABLE'')) d, ''600'' r from dual union all     ',
'select initcap(wwv_flow_lang.system_message(''TRIGGER'')) d, ''TRIGGER'' r from dual union all     ',
'select initcap(wwv_flow_lang.system_message(''VIEW'')) d, ''48'' r from dual',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/object_types_with_images2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(161349613017569311.4508)
,p_lov_name=>'OBJECT.TYPES.WITH.IMAGES2'
,p_lov_query=>'.'||wwv_flow_api.id(161349613017569311.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161349926473569318.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D568\C218')
,p_lov_return_value=>'98'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:98:&SESSION.::NO:98,107,100:P81_CREATE_OBJECT_TYPE:98"><img src="#IMAGE_PREFIX#htmldb/builder/function.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE" /></a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161350104339569322.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C778\B371\C2A4')
,p_lov_return_value=>'INDEX'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:56:&SESSION.:index:NO:57:P70_ACTION,P81_CREATE_OBJECT_TYPE:INDEX,INDEX"><img src="#IMAGE_PREFIX#htmldb/builder/index.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_V'
||'ALUE#" /></a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161350313495569322.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\D328\D0A4\C9C0')
,p_lov_return_value=>'117'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:117:&SESSION.::NO:117,118,120:P81_CREATE_OBJECT_TYPE:117"><img src="#IMAGE_PREFIX#htmldb/builder/package.gif" width="58" height="38" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a'
||'>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161350510273569323.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\D504\B85C\C2DC\C800')
,p_lov_return_value=>'121'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:121:&SESSION.::NO:121,122,123:P81_CREATE_OBJECT_TYPE:121"><img src="#IMAGE_PREFIX#htmldb/builder/procedure.gif" width="58" height="38" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /><'
||'/a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161350704929569323.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\C2DC\D000\C2A4')
,p_lov_return_value=>'97'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:97:&SESSION.::NO:97:P81_CREATE_OBJECT_TYPE:97"><img src="#IMAGE_PREFIX#htmldb/builder/sequence.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161350927921569323.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\B3D9\C758\C5B4')
,p_lov_return_value=>'99'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:99:&SESSION.::NO:99:P81_CREATE_OBJECT_TYPE:99"><img src="#IMAGE_PREFIX#htmldb/builder/synonym.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161351109256569323.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\D14C\C774\BE14')
,p_lov_return_value=>'TABLE_CREATE'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:TABLE_CREATE:&SESSION.::NO:602,604,612:P81_CREATE_OBJECT_TYPE:600"><img src="#IMAGE_PREFIX#htmldb/builder/table.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#'
||'" /></a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161351331481569324.4508)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70')
,p_lov_return_value=>'TRIGGER'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:3:&SESSION.:triger:NO:3::"><img src="#IMAGE_PREFIX#htmldb/builder/trigger.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161351517964569324.4508)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\BDF0')
,p_lov_return_value=>'48'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:48:&SESSION.::NO:48:P81_CREATE_OBJECT_TYPE:48"><img src="#IMAGE_PREFIX#htmldb/builder/view.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161351731977569324.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B9C1\D06C')
,p_lov_return_value=>'91'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:91:&SESSION.::NO:91:P81_CREATE_OBJECT_TYPE:91"><img src="#IMAGE_PREFIX#htmldb/builder/dblink.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/object_types2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88087713200000281.4508)
,p_lov_name=>'OBJECT.TYPES2'
,p_lov_query=>'.'||wwv_flow_api.id(88087713200000281.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88087913591000281.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C5F4')
,p_lov_return_value=>'Columns'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88088111508000282.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\D328\D0A4\C9C0')
,p_lov_return_value=>'Packages'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88088331361000282.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\D504\B85C\C2DC\C800/\D568\C218')
,p_lov_return_value=>'Procedures/Functions'
);
end;
/
prompt --application/shared_components/user_interface/lovs/object_types3
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(149192410304386529.4508)
,p_lov_name=>'OBJECT.TYPES3'
,p_lov_query=>'.'||wwv_flow_api.id(149192410304386529.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149192703287386532.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D568\C218')
,p_lov_return_value=>'FUNCTION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149192916678386534.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C778\B371\C2A4')
,p_lov_return_value=>'INDEX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149193104939386534.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\D328\D0A4\C9C0')
,p_lov_return_value=>'PACKAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149193312103386534.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\D504\B85C\C2DC\C800')
,p_lov_return_value=>'PROCEDURE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149193514215386535.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\C2DC\D000\C2A4')
,p_lov_return_value=>'SEQUENCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149193711471386535.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\B3D9\C758\C5B4')
,p_lov_return_value=>'SYNONYM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149193923583386535.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\D14C\C774\BE14')
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149194128979386535.4508)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70')
,p_lov_return_value=>'TRIGGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(149194306560386535.4508)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\BDF0')
,p_lov_return_value=>'VIEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(106105223193950457.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B9C1\D06C')
,p_lov_return_value=>'DATABASE LINK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(109308316213864971.4508)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\C720\D615')
,p_lov_return_value=>'TYPE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(109321428942887516.4508)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\AD6C\CCB4\D654\B41C \BDF0')
,p_lov_return_value=>'MATERIALIZED VIEW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ob_create_table_handler
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(17956529721028277.4508)
,p_lov_name=>'OB_CREATE_TABLE_HANDLER'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, object_name r',
'from sys.dba_objects',
'where owner = :OB_SCHEMA ',
'and object_type in (''TABLE'')',
'and object_name not like ''BIN$%'' ',
'and object_name not like ''DR$%'' ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ob_cycle
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(276749314239737540.4508)
,p_lov_name=>'OB_CYCLE'
,p_lov_query=>'.'||wwv_flow_api.id(276749314239737540.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(276749519233737542.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C21C\D658')
,p_lov_return_value=>'CYCLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ob_grant_privs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(15818831028847554.4508)
,p_lov_name=>'OB_GRANT_PRIVS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select privilege_name a, privilege_name b',
'  from sys.v_$object_privilege',
' where object_type_name = case :OBJECT_TYPE',
'                          when ''MATERIALIZED VIEW'' then ''TABLE''',
'                          when ''PACKAGE BODY'' then ''PACKAGE''',
'                          else :OBJECT_TYPE',
'                          end'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ob_order
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(276750123935740352.4508)
,p_lov_name=>'OB_ORDER'
,p_lov_query=>'.'||wwv_flow_api.id(276750123935740352.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(276750313195740352.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C21C\C11C')
,p_lov_return_value=>'ORDER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/on_delete_cascade_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88046110159554703.4508)
,p_lov_name=>'ON.DELETE.CASCADE.Y'
,p_lov_query=>'.'||wwv_flow_api.id(88046110159554703.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88046324301554704.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\ACC4\B2E8\C2DD \C0AD\C81C')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/order_by
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88015211732318611.4508)
,p_lov_name=>'ORDER.BY'
,p_lov_query=>'.'||wwv_flow_api.id(88015211732318611.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88015409187318612.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C81C\BAA9')
,p_lov_return_value=>'title'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88015624432318612.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\D30C\C77C \C774\B984')))
,p_lov_return_value=>'filename'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88015826924318612.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\C0DD\C131 \B0A0\C9DC(\C624\B984\CC28\C21C)')))
,p_lov_return_value=>'created_on'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88016003779318613.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\C0DD\C131 \B0A0\C9DC(\B0B4\B9BC\CC28\C21C)')))
,p_lov_return_value=>'created_on desc'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88016226006318613.4508)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\C0DD\C131\C790')))
,p_lov_return_value=>'created_by'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88016402368318613.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\D06C\AE30(\C624\B984\CC28\C21C)')))
,p_lov_return_value=>'doc_size'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88016613155318613.4508)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\D06C\AE30(\B0B4\B9BC\CC28\C21C)')))
,p_lov_return_value=>'doc_size desc'
);
end;
/
prompt --application/shared_components/user_interface/lovs/output_format
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88012712031290348.4508)
,p_lov_name=>'OUTPUT.FORMAT'
,p_lov_query=>'.'||wwv_flow_api.id(88012712031290348.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88012904683290349.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'HTML'
,p_lov_return_value=>'HTML'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88013100776290349.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Excel'
,p_lov_return_value=>'EXCEL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1000_release
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(251169207119420476.4508)
,p_lov_name=>'P1000 RELEASE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct d, r ',
'from (',
'select distinct release d, release r from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null',
'union all',
'select distinct release d, release r from wwv_flow_tasks',
'where security_group_id = :flow_security_group_id and release is not null',
'union all',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null',
'union all',
'select distinct release d, release r from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null',
'union all',
'select wwv_flow_lang.system_message(''ALL_RELEASES'') d, ''0'' r from dual',
') v '))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1000_show
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184589019269022599.4508)
,p_lov_name=>'P1000 SHOW'
,p_lov_query=>'.'||wwv_flow_api.id(184589019269022599.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184589207940022600.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\BAA8\B450')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184589426163022602.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\B0B4 \C9C0\C815')
,p_lov_return_value=>'MINE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184593723631288771.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\B0B4 \BBF8\ACB0')
,p_lov_return_value=>'MY_OPEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184593319129287486.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\BAA8\B4E0 \BBF8\ACB0')
,p_lov_return_value=>'ALL_OPEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1004_show_results
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(179031515879675216.4508)
,p_lov_name=>'P1004_SHOW_RESULTS'
,p_lov_query=>'.'||wwv_flow_api.id(179031515879675216.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(179031709094675217.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\ACB0\ACFC \D45C\C2DC')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p101_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(150992731358804903.4508)
,p_lov_name=>'P101_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(t.column_name)||'' - ''||lower(t.data_type) d, ',
'       t.column_name r',
'from   sys.dba_tab_columns t',
'where              ',
'      t.table_name = :P101_TABLE_NAME',
'  and t.owner = :P101_TABLE_OWNER and',
'      (nvl(:P101_SHOW,''1'') = ''1'' or t.data_type in (''VARCHAR'',''VARCHAR2'')) and column_id is not null',
'order by t.column_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_audit_col_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(561151526618018480.4508)
,p_lov_name=>'P1101_AUDIT_COL_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(561151526618018480.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561151855252018480.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\AC10\C0AC \C5F4')
,p_lov_return_value=>'AUDIT_COLS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561152288785018481.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\D589 \BC84\C804 \BC88\D638')
,p_lov_return_value=>'ROW_VERSION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561152614552018481.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\D589 \D0A4')
,p_lov_return_value=>'ROW_KEY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561153026518018481.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\BCF4\C548 \ADF8\B8F9 ID')
,p_lov_return_value=>'SGID'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_date_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(561155009716075756.4508)
,p_lov_name=>'P1101_DATE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(561155009716075756.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561155337871075756.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'DATE'
,p_lov_return_value=>'DATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561155720392075757.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'TIMESTAMP'
,p_lov_return_value=>'TIMESTAMP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561156148788075757.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'TIMESTAMP WITH TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH TIME ZONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561156516823075757.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_db_version
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(561159215572120923.4508)
,p_lov_name=>'P1101_DB_VERSION'
,p_lov_query=>'.'||wwv_flow_api.id(561159215572120923.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561159550831120924.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'18c'
,p_lov_return_value=>'18c'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561159941578120924.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'12c'
,p_lov_return_value=>'12c'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561160307536120924.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'11g'
,p_lov_return_value=>'11g'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_length_semantics
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(561157497023099105.4508)
,p_lov_name=>'P1101_LENGTH_SEMANTICS'
,p_lov_query=>'.'||wwv_flow_api.id(561157497023099105.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561157786208099106.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\AE30\BCF8\AC12')
,p_lov_return_value=>'DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561158130042099106.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'BYTE'
,p_lov_return_value=>'BYTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561158557818099106.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'CHAR'
,p_lov_return_value=>'CHAR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_on_delete
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(561149224457990543.4508)
,p_lov_name=>'P1101_ON_DELETE'
,p_lov_query=>'.'||wwv_flow_api.id(561149224457990543.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561149574178990543.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\ACC4\B2E8\C2DD')
,p_lov_return_value=>'CASCADE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561149925686990545.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C81C\D55C')
,p_lov_return_value=>'RESTRICT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561150376364990545.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\B110 \C124\C815')
,p_lov_return_value=>'SET NULL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1101_trigger_method
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(561153525630044678.4508)
,p_lov_name=>'P1101_TRIGGER_METHOD'
,p_lov_query=>'.'||wwv_flow_api.id(561153525630044678.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561153872500044678.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70 \BC0F GUID\B97C \D1B5\D574')
,p_lov_return_value=>'GUID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244368349049855044.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70 \BC0F \C2DC\D000\C2A4\B97C \D1B5\D574')
,p_lov_return_value=>'SEQ'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(561154212975044678.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('12c ID \B370\C774\D130 \C720\D615')
,p_lov_return_value=>'IDENTITY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1220_script_files
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12563519145254272.4508)
,p_lov_name=>'P1220_SCRIPT_FILES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct f.filename, f.id',
'from wwv_flow_files f, wwv_flow_sw_results r',
'where f.id = r.file_id ',
'and f.file_type = ''SCRIPT''',
'and (nvl(:P1220_SHOW,''0'') = ''0'' or run_by = :P1220_SHOW)',
'order by f.filename'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1301_session_opts
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(26561807054435939.4508)
,p_lov_name=>'P1301_SESSION_OPTS'
,p_lov_query=>'.'||wwv_flow_api.id(26561807054435939.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(26562005235435939.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BAA8\B450')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(26562200440435942.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C131\ACF5\D55C \C138\C158')
,p_lov_return_value=>'SUC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(26562427473435942.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\C2E4\D328\D55C \C138\C158')
,p_lov_return_value=>'FAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1302_sesopt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(26247521414208435.4508)
,p_lov_name=>'P1302_SESOPT'
,p_lov_query=>'.'||wwv_flow_api.id(26247521414208435.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(26247711140208437.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BAA8\B450')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(26247917746208441.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C131\ACF5\D55C \B85C\ADF8\C778')
,p_lov_return_value=>'SUC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(26248104479208441.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\C2E4\D328\D55C \B85C\ADF8\C778')
,p_lov_return_value=>'FAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2610_users
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(20110029824731114.4508)
,p_lov_name=>'P2610_USERS'
,p_lov_query=>'.'||wwv_flow_api.id(20110029824731114.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20110203670731120.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BAA8\B4E0 \C2A4\D0A4\B9C8')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20110423350731122.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\B0B4\BD80 \C2A4\D0A4\B9C8')
,p_lov_return_value=>'INTERNAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20110606356731122.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C2A4\D0A4\B9C8')
,p_lov_return_value=>'USER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2613_locked_unlocked
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1493723866781789.4508)
,p_lov_name=>'P2613_LOCKED_UNLOCKED'
,p_lov_query=>'.'||wwv_flow_api.id(1493723866781789.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1493913666781840.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C7A0\AE40')
,p_lov_return_value=>'LOCK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1494107328781852.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C7A0\AE08 \D574\C81C\B428')
,p_lov_return_value=>'UNLOCK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p3100_load_to
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(60089930390905970.4508)
,p_lov_name=>'P3100_LOAD_TO'
,p_lov_query=>'.'||wwv_flow_api.id(60089930390905970.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(60090216213905982.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C0C8 \D14C\C774\BE14')
,p_lov_return_value=>'NEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(60090671533905996.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\AE30\C874 \D14C\C774\BE14')
,p_lov_return_value=>'EXISTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p3100_update_method
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(60103143434104047.4508)
,p_lov_name=>'P3100_UPDATE_METHOD'
,p_lov_query=>'.'||wwv_flow_api.id(60103143434104047.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(60103430659104047.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\CD94\AC00')
,p_lov_return_value=>'APPEND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(60103886752104048.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\BC14\AFB8\AE30')
,p_lov_return_value=>'REPLACE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p3120_table_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(60123851090684199.4508)
,p_lov_name=>'P3120_TABLE_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_name||'' (''|| initcap(data_type) ||'')'' as d,',
'       column_name as r',
'from sys.dba_tab_columns',
'where owner = :P3100_TABLE_OWNER',
'and table_name = :P3100_EXISTING_TABLE',
'order by column_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p36_display_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(998111353442494.4508)
,p_lov_name=>'P36_DISPLAY_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(998111353442494.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(998325750442498.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BC84\C804')
,p_lov_return_value=>'VERSION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(998523049442499.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C124\C815')
,p_lov_return_value=>'DATABASE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(998704170442500.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\C635\C158')
,p_lov_return_value=>'OPTIONS'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(999130596442500.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\AD6D\AC00\BCC4 \C5B8\C5B4 \C9C0\C6D0')
,p_lov_return_value=>'NLS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(999327277442500.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('CGI \D658\ACBD')
,p_lov_return_value=>'CGI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5615222230694443.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\B9E4\AC1C\BCC0\C218')
,p_lov_return_value=>'PARAMETER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p40_interval
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174631600082053227.4508)
,p_lov_name=>'P40_INTERVAL'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' ''   ||initcap(wwv_flow_lang.system_message(''YEAR'')) d, 365 r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 31 ''||initcap(wwv_flow_lang.system_message(''DAYS'')) d, 31 r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 48 ''||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 2 r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 24 ''||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 1 r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 8 '' ||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 8/24 r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 6 '' ||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 6/24 r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 4 '' ||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 4/24 r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 2 '' ||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 2/24 r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' ''   ||initcap(wwv_flow_lang.system_message(''HOUR'')) d, 1/24 r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 30 ''||initcap(wwv_flow_lang.system_message(''MINUTES'')) d, 30/(24*60) r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 10 ''||initcap(wwv_flow_lang.system_message(''MINUTES'')) d, 10/(24*60) r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 5 '' ||initcap(wwv_flow_lang.system_message(''MINUTES'')) d, 5/(24*60) r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' ''   ||initcap(wwv_flow_lang.system_message(''MINUTE'')) d, 1/(24*60) r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 10 ''||initcap(wwv_flow_lang.system_message(''SECONDS'')) d, 10* (1/(24*60*60)) r from dual union all',
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 5 '' ||initcap(wwv_flow_lang.system_message(''SECONDS'')) d, 5* (1/(24*60*60)) r from dual',
'order by 2 desc'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p42_order_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(148760022603009971.4508)
,p_lov_name=>'P42.ORDER.COLUMNS'
,p_lov_query=>'select wwv_flow_escape.html(column_name) d, column_name v from sys.dba_tab_columns where owner = :F4500_P42_OBJECT_OWNER and table_name = :F4500_P42_OBJECT_NAME order by column_id'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p64_obj_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(27925820885518618.4508)
,p_lov_name=>'P64_OBJ_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(27925820885518618.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27926020563518626.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C560\D50C\B9AC\CF00\C774\C158')
,p_lov_return_value=>'APPLICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27926230018518634.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('CSS \C775\C2A4\D3EC\D2B8')
,p_lov_return_value=>'CSS_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27926402670518634.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C775\C2A4\D3EC\D2B8')
,p_lov_return_value=>'FLOW_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27926614786518636.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\C2A4\D06C\B9BD\D2B8')
,p_lov_return_value=>'SCRIPT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27926803274518636.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\C2A4\D06C\B9BD\D2B8 \D30C\C77C \C775\C2A4\D3EC\D2B8')
,p_lov_return_value=>'SCRIPT_FILE_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27927031603518636.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\D14C\B9C8')
,p_lov_return_value=>'THEME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27927219004518642.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\C815\C801 \D30C\C77C')
,p_lov_return_value=>'STATIC FILE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p71_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174553601832855016.4508)
,p_lov_name=>'P71_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(COLUMN_NAME)||'' (''||data_type||'')'' d,  column_name r',
'from sys.dba_tab_columns',
'where owner =  :OBJECT_OWNER',
' and table_name= :OBJECT_NAME and column_id is not null',
'order by column_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p76_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174520707223695721.4508)
,p_lov_name=>'P76_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(COLUMN_NAME)||'' (''||data_type||'')'' d,  column_name r',
'from sys.dba_tab_columns',
'where owner =  :OBJECT_OWNER and',
'table_name= :OBJECT_NAME and column_id is not null',
'order by column_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p82_constraints
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174431027591821617.4508)
,p_lov_name=>'P82_CONSTRAINTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(c.constraint_name) d,  c.constraint_name r',
'from sys.dba_constraints c, sys.dba_cons_columns l',
'where c.table_name = :OBJECT_NAME',
'and c.owner = :OBJECT_OWNER',
'and c.constraint_type in (''P'',''U'',''C'',''R'')',
'and c.constraint_name = l.constraint_name ',
'and l.owner = :OBJECT_OWNER',
'and l.table_name = :OBJECT_NAME',
'and c.status = ''DISABLED''',
'order by c.constraint_name, c.constraint_type, l.position'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p86_triggers
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174475310182109956.4508)
,p_lov_name=>'P86_TRIGGERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(t.trigger_name)||'' (''||t.status||'')'' d, t.trigger_name r',
'from sys.dba_triggers t',
'where t.table_name = :OBJECT_NAME ',
'and t.table_owner = :OBJECT_OWNER',
'order by t.trigger_name'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pk_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(20561306137429854.4508)
,p_lov_name=>'PK_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(20561306137429854.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(29761700718146891.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\AE30\BCF8 \D0A4 \C5C6\C74C')
,p_lov_return_value=>'NONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20561825857429898.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C0C8 \C2DC\D000\C2A4\C5D0\C11C \CC44\C6CC\C9D0')
,p_lov_return_value=>'NEW_SEQUENCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20562003984429898.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\AE30\C874 \C2DC\D000\C2A4\C5D0\C11C \CC44\C6CC\C9D0')
,p_lov_return_value=>'EXISTING_SEQUENCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20561603688429893.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\CC44\C6CC\C9C0\C9C0 \C54A\C74C')
,p_lov_return_value=>'NOT_GENERATED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(276470910158447556.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('ID \C5F4\C5D0\C11C \CC44\C6CC\C9D0')
,p_lov_return_value=>'IDENTITY'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_global.g_12c'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pl_sql_object_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(9486017492391468.4508)
,p_lov_name=>'PL/SQL OBJECT TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(9486017492391468.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9486202458391470.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D504\B85C\C2DC\C800')
,p_lov_return_value=>'PROCEDURE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9486430806391474.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\D568\C218')
,p_lov_return_value=>'FUNCTION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9486609421391475.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\D328\D0A4\C9C0')
,p_lov_return_value=>'PACKAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9486818320391475.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\D328\D0A4\C9C0 \BCF8\BB38')
,p_lov_return_value=>'PACKAGE BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9487009618391475.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70')
,p_lov_return_value=>'TRIGGER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/preserve_case_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88034811582507798.4508)
,p_lov_name=>'PRESERVE.CASE.Y'
,p_lov_query=>'.'||wwv_flow_api.id(88034811582507798.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88035027142507799.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\B300\C18C\BB38\C790 \C720\C9C0')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/privileges_table_show
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(8935311761146039.4508)
,p_lov_name=>'PRIVILEGES.TABLE.SHOW'
,p_lov_query=>'.'||wwv_flow_api.id(8935311761146039.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8935521709146041.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C120\D0DD\D55C \C2A4\D0A4\B9C8\C5D0 \AD8C\D55C \BD80\C5EC')
,p_lov_return_value=>'TO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8935711543146043.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C120\D0DD\D55C \C2A4\D0A4\B9C8\C5D0\C11C \AD8C\D55C \BD80\C5EC')
,p_lov_return_value=>'FROM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8935913844146043.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\BAA8\B450')
,p_lov_return_value=>'ALL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/public_private
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88067712358839197.4508)
,p_lov_name=>'PUBLIC.PRIVATE'
,p_lov_query=>'.'||wwv_flow_api.id(88067712358839197.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88067900572839197.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C804\C6A9')
,p_lov_return_value=>'PRIVATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88068127252839198.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\ACF5\C6A9')
,p_lov_return_value=>'PUBLIC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/query_builder_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2308814912225605.4508)
,p_lov_name=>'QUERY_BUILDER_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(2308814912225605.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2309026164225610.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C804\C6A9')
,p_lov_return_value=>'P'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2309221064225612.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\ACF5\C6A9')
,p_lov_return_value=>'R'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2309411169225612.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\ACF5\C6A9 \C77D\AE30/\C4F0\AE30')
,p_lov_return_value=>'W'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/query_owners
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3358317445244033.4508)
,p_lov_name=>'QUERY_OWNERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r from (',
'select wwv_flow_escape.html(created_by) d, created_by r ',
'  from wwv_flow_qb_saved_query',
'where security_group_id = :flow_security_group_id',
'and exists (     ',
'select 1 ',
'from  wwv_flow_developers ',
'where security_group_id = :flow_security_group_id and ',
'      userid = :flow_user and ',
'      instr(developer_role||'':'',''ADMIN:'') > 0 ',
'union ',
'select 1 ',
'from wwv_flow_fnd_user ',
'where security_group_id = :flow_security_group_id ',
'and user_name = :flow_user ',
'and attribute_01 in (''ORACLE_ADMIN'',''SCHOOL_ADMIN'',''TEACHER'')) ',
'union all  ',
'select v(''APP_USER'') d, v(''APP_USER'') r',
'FROM DUAL) ',
'group by d,r',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/quicksql_data_lang
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(397206437082468486.4508)
,p_lov_name=>'QUICKSQL_DATA_LANG'
,p_lov_query=>'.'||wwv_flow_api.id(397206437082468486.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(397206751492468497.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C601\C5B4')
,p_lov_return_value=>'EN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(397207144316468498.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\B3C5\C77C\C5B4')
,p_lov_return_value=>'DE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(397207548117468498.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\D55C\AD6D\C5B4')
,p_lov_return_value=>'KO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(397207927574468498.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\C77C\BCF8\C5B4')
,p_lov_return_value=>'JA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(397208363097468498.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\C2A4\D398\C778\C5B4')
,p_lov_return_value=>'ES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/quota_size
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1589203900827893.4508)
,p_lov_name=>'QUOTA SIZE'
,p_lov_query=>'.'||wwv_flow_api.id(1589203900827893.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1589405753827932.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'0'
,p_lov_return_value=>'NONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1589832194827937.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\AC12(MB)')
,p_lov_return_value=>'VALUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1589631060827937.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\BB34\C81C\D55C')
,p_lov_return_value=>'UNLIMITED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/recycle_bin_object_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(165057106281786448.4508)
,p_lov_name=>'RECYCLE BIN OBJECT TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(165057106281786448.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(165057400753786453.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C778\B371\C2A4')
,p_lov_return_value=>'INDEX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(165057605335786456.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\D14C\C774\BE14')
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(165057800969786457.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70')
,p_lov_return_value=>'TRIGGER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/redaction_enabled
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7500901536272987.4508)
,p_lov_name=>'REDACTION_ENABLED'
,p_lov_query=>'.'||wwv_flow_api.id(7500901536272987.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7501216647272994.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C0AC\C6A9\C73C\B85C \C124\C815\B428')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7501515266272994.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C0AC\C6A9 \C548\D568\C73C\B85C \C124\C815\B428')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/redact_expressions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7516909805609852.4508)
,p_lov_name=>'REDACT_EXPRESSIONS'
,p_lov_query=>'.'||wwv_flow_api.id(7516909805609852.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7517226584609865.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D56D\C0C1')
,p_lov_return_value=>'1=1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7517506593609865.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Application Express \C0AC\C6A9\C790\AC00 \B9DE\C74C')
,p_lov_return_value=>'v(''APP_USER'') = '''' or v(''APP_USER'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7517804068609865.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Application Express \C0AC\C6A9\C790\AC00 \C544\B2D8')
,p_lov_return_value=>'v(''APP_USER'') != '''' or v(''APP_USER'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7518128701609866.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \C138\C158 \C0AC\C6A9\C790\AC00 \B9DE\C74C')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''SESSION_USER'') = '''' or SYS_CONTEXT(''USERENV'',''SESSION_USER'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7518404287609866.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \C138\C158 \C0AC\C6A9\C790\AC00 \C544\B2D8')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''SESSION_USER'') != '''' or SYS_CONTEXT(''USERENV'',''SESSION_USER'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7518717668609866.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \C138\C158 \B864\C774 \B9DE\C74C')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''SESSION_ROLE'') = '''' or SYS_CONTEXT(''USERENV'',''SESSION_ROLE'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7519030231609866.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \C138\C158 \B864\C774 \C544\B2D8')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''SESSION_ROLE'') != '''' or SYS_CONTEXT(''USERENV'',''SESSION_ROLE'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7519316622609867.4508)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \C560\D50C\B9AC\CF00\C774\C158 \BAA8\B4C8\C774 \B9DE\C74C')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''APPLICATION_MODULE'') = '''' or SYS_CONTEXT(''USERENV'',''APPLICATION_MODULE'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7519610265609867.4508)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \C560\D50C\B9AC\CF00\C774\C158 \BAA8\B4C8\C774 \C544\B2D8')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''APPLICATION_MODULE'') != '''' or SYS_CONTEXT(''USERENV'',''APPLICATION_MODULE'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7519923103609867.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \D074\B77C\C774\C5B8\D2B8 \C2DD\BCC4\C790\AC00 \B9DE\C74C')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_IDENTIFIER'') = '''' or SYS_CONTEXT(''USERENV'',''CLIENT_IDENTIFIER'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7520222645609867.4508)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \D074\B77C\C774\C5B8\D2B8 \C2DD\BCC4\C790\AC00 \C544\B2D8')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_IDENTIFIER'') != '''' or SYS_CONTEXT(''USERENV'',''CLIENT_IDENTIFIER'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7520505568609926.4508)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \D074\B77C\C774\C5B8\D2B8 \C815\BCF4\AC00 \B9DE\C74C')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_INFORMATION'') = '''' or SYS_CONTEXT(''USERENV'',''CLIENT_INFORMATION'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7520806771609926.4508)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \D074\B77C\C774\C5B8\D2B8 \C815\BCF4\AC00 \C544\B2D8')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_INFORMATION'') != '''' or SYS_CONTEXT(''USERENV'',''CLIENT_INFORMATION'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7521121453609926.4508)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \D074\B77C\C774\C5B8\D2B8 IP \C8FC\C18C\AC00 \B9DE\C74C')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_IP_ADDRESS'') = '''' or SYS_CONTEXT(''USERENV'',''CLIENT_IP_ADDRESS'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7521408264609926.4508)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \D074\B77C\C774\C5B8\D2B8 IP \C8FC\C18C\AC00 \C544\B2D8')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_IP_ADDRESS'') != '''' or SYS_CONTEXT(''USERENV'',''CLIENT_IP_ADDRESS'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7521704157619850.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \D074\B77C\C774\C5B8\D2B8 \C2DC\C2A4\D15C \C774\B984\C774 \B9DE\C74C')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_MACHINE_NAME'') = '''' or SYS_CONTEXT(''USERENV'',''CLIENT_MACHINE_NAME'') is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7522029162623362.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \D658\ACBD \D074\B77C\C774\C5B8\D2B8 \C2DC\C2A4\D15C \C774\B984\C774 \C544\B2D8')
,p_lov_return_value=>'SYS_CONTEXT(''USERENV'',''CLIENT_MACHINE_NAME'') != '''' or SYS_CONTEXT(''USERENV'',''CLIENT_MACHINE_NAME'') is null'
);
end;
/
prompt --application/shared_components/user_interface/lovs/redact_func_parms
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7469301964208818.4508)
,p_lov_name=>'REDACT_FUNC_PARMS'
,p_lov_query=>'.'||wwv_flow_api.id(7469301964208818.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7469607797208922.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\CC98\C74C 5\C790\B9AC US SSN \AC1C\C815')
,p_lov_return_value=>'VVVFVVFVVVV,VVV-VV-VVVV,X,1,5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7469909319209004.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\B9C8\C9C0\B9C9 4\C790\B9AC US SSN \AC1C\C815')
,p_lov_return_value=>'VVVFVVFVVVV,VVV-VV-VVVV,X,6,9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7470220279209004.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\C804\CCB4 US SSN \AC1C\C815')
,p_lov_return_value=>'VVVFVVFVVVV,VVV-VV-VVVV,X,1,9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7470527551209004.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\CC98\C74C 5\C790\B9AC \C22B\C790 US SSN \AC1C\C815')
,p_lov_return_value=>'9,1,5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7470809785209004.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\B9C8\C9C0\B9C9 4\C790\B9AC \C22B\C790 US SSN \AC1C\C815')
,p_lov_return_value=>'9,6,9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7471105134209004.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\C804\CCB4 \C22B\C790 US SSN \AC1C\C815')
,p_lov_return_value=>'9,1,9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7471430655209004.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\C22B\C790 US \C6B0\D3B8 \BC88\D638 \AC1C\C815')
,p_lov_return_value=>'9,1,5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7471711236209005.4508)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\CC98\C74C 12\C790\B9AC \C2E0\C6A9 \CE74\B4DC \BC88\D638 \AC1C\C815')
,p_lov_return_value=>'VVVVFVVVVFVVVVFVVVV,VVVV-VVVV-VVVV-VVVV,*,1,12'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7472009351209006.4508)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\B0A0\C9DC \BC00\B808\B2C8\C5C4 \AC1C\C815')
,p_lov_return_value=>'m1d1y2000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7472316128209006.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\B0A0\C9DC \C2DC\B300 \AC1C\C815')
,p_lov_return_value=>'m1d1y1970'
);
end;
/
prompt --application/shared_components/user_interface/lovs/redact_regexp_pattern
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7472906353351996.4508)
,p_lov_name=>'REDACT_REGEXP_PATTERN'
,p_lov_query=>'.'||wwv_flow_api.id(7472906353351996.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7473231345352007.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('US \C0AC\D68C \BCF4\C7A5 \BC88\D638')
,p_lov_return_value=>'(\d\d\d)-(\d\d)-(\d\d\d\d)'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7473505981352008.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C2E0\C6A9 \CE74\B4DC\C758 \C120\D589 6\C790\B9AC\C640 \D6C4\D589 4\C790\B9AC \C22B\C790\C758 \AC00\C6B4\B370')
,p_lov_return_value=>'(\d\d\d\d\d\d)(\d\d\d*)(\d\d\d\d)'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7473832380352008.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\BAA8\B4E0 \C22B\C790')
,p_lov_return_value=>'\d'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7474122208352008.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('US \C804\D654\BC88\D638')
,p_lov_return_value=>'(\(\d\d\d\)|\d\d\d)-(\d\d\d)-(\d\d\d\d)'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7474420613352009.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\C804\C790\BA54\C77C \C8FC\C18C')
,p_lov_return_value=>'([A-Za-z0-9._%+-]+)@([A-Za-z0-9.-]+\.[A-Za-z]{2,4})'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7474702702352009.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('IP \C8FC\C18C')
,p_lov_return_value=>'(\d{1,3}\.\d{1,3}\.\d{1,3})\.\d{1,3}'
);
end;
/
prompt --application/shared_components/user_interface/lovs/redact_regexp_repl_str
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7474914908572203.4508)
,p_lov_name=>'REDACT_REGEXP_REPL_STR'
,p_lov_query=>'.'||wwv_flow_api.id(7474914908572203.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7475217540572261.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\AC00\C6B4\B370 \C2E0\C6A9 \CE74\B4DC \C22B\C790 \AC1C\C815')
,p_lov_return_value=>'\1XXXXXX\3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7475532017572262.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\B2E8\C77C X\B85C \AC1C\C815')
,p_lov_return_value=>'X'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7475808807572262.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\B2E8\C77C 1\B85C \AC1C\C815')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7476121686572262.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('US \C804\D654\BC88\D638 \AC1C\C815')
,p_lov_return_value=>'\1-XXX-XXXX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7476430001572262.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\C804\C790\BA54\C77C \C774\B984 \AC1C\C815')
,p_lov_return_value=>'xxxx@\2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7476702761572263.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\C804\C790\BA54\C77C \B3C4\BA54\C778 \AC1C\C815')
,p_lov_return_value=>'\1 (at) xxxxx.com'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7477004982572263.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\C804\CCB4 \C804\C790\BA54\C77C \AC1C\C815')
,p_lov_return_value=>'xxxx (at) xxxxx.com'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7477316416572263.4508)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('IP \C8FC\C18C \AC1C\C815')
,p_lov_return_value=>'\1.999'
);
end;
/
prompt --application/shared_components/user_interface/lovs/regexp_match_param
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7477530753595662.4508)
,p_lov_name=>'REGEXP_MATCH_PARAM'
,p_lov_query=>'.'||wwv_flow_api.id(7477530753595662.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7477819505595662.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B300\C18C\BB38\C790 \AD6C\BD84')
,p_lov_return_value=>'c'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7478103965595662.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\B300\C18C\BB38\C790 \BB34\C2DC')
,p_lov_return_value=>'i'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7478429992595663.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\B2E4\C911 \D589')
,p_lov_return_value=>'m'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7478728314595663.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\C904\BC14\AFC8 \C640\C77C\B4DC \CE74\B4DC \BB38\C790')
,p_lov_return_value=>'n'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7479001778595663.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\ACF5\BC31 \BB34\C2DC')
,p_lov_return_value=>'x'
);
end;
/
prompt --application/shared_components/user_interface/lovs/row_select
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88095631994062466.4508)
,p_lov_name=>'ROW.SELECT'
,p_lov_query=>'.'||wwv_flow_api.id(88095631994062466.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88095810522062467.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\BAA8\B4E0 \D589')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88096011165062467.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C120\D0DD\B41C \D589')
,p_lov_return_value=>'SELECTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88096206304062468.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\D589 \C5C6\C74C')
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/rows_percent
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88059704693808617.4508)
,p_lov_name=>'ROWS.PERCENT'
,p_lov_query=>'.'||wwv_flow_api.id(88059704693808617.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88059901028808618.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D37C\C13C\D2B8')
,p_lov_return_value=>'percent'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88060116147808618.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\D589')
,p_lov_return_value=>'rows'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sample_data_spreadsheets
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(217855733246275209.4508)
,p_lov_name=>'SAMPLE.DATA.SPREADSHEETS'
,p_lov_query=>'.'||wwv_flow_api.id(217855733246275209.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217856069642275210.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Academic'
,p_lov_return_value=>'ACADEMIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217856445509275213.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D074\B798\C2DD \BD80\C11C \BC0F \C0AC\C6D0')
,p_lov_return_value=>'DEPT_EMP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217856856420275213.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\D3EC\BBAC\B7EC \C6D0')
,p_lov_return_value=>'F1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217857246380275213.4508)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>unistr('JSON \BC0F \AD6C\C870\D654\B41C \D14C\C2A4\D2B8 \B370\C774\D130')
,p_lov_return_value=>'JSON_TEST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217857693606275213.4508)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>unistr('JSON \C804\C6A9 \D14C\C2A4\D2B8 \B370\C774\D130')
,p_lov_return_value=>'JSON'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217858097098275213.4508)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('\B3D9\C601\C0C1')
,p_lov_return_value=>'MOVIE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217858447167275214.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\D504\B85C\C81D\D2B8 \BC0F \C791\C5C5')
,p_lov_return_value=>'PROJECTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217858839052275214.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\D310\B9E4')
,p_lov_return_value=>'SALES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217859293900275214.4508)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\D14C\B2C8\C2A4')
,p_lov_return_value=>'TENNIS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217859626213275214.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\CC28\B7C9 \C18D\B3C4')
,p_lov_return_value=>'SPEED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217860008215275214.4508)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\C6D4\B4DC\CEF5')
,p_lov_return_value=>'WORLDCUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217860462659275215.4508)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\C138\ACC4 \C778\AD6C')
,p_lov_return_value=>'WORLD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/schema_compare_categories
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(14728126072025797.4508)
,p_lov_name=>'SCHEMA COMPARE CATEGORIES'
,p_lov_query=>'.'||wwv_flow_api.id(14728126072025797.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14728314552025797.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C5F4 \C774\B984')
,p_lov_return_value=>'COLUMN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14728532416025797.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D14C\C774\BE14')
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14728710300025797.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C5F4 \B370\C774\D130 \C720\D615')
,p_lov_return_value=>'DATATYPE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14839906156999563.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C778\B371\C2A4')
,p_lov_return_value=>'INDEX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14877305584283250.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D568\C218')
,p_lov_return_value=>'FUNCTION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14929828730535894.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C2DC\D000\C2A4')
,p_lov_return_value=>'SEQUENCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14932013409550455.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D2B8\B9AC\AC70')
,p_lov_return_value=>'TRIGGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16908630581731543.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D328\D0A4\C9C0')
,p_lov_return_value=>'PACKAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16908901622732667.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D328\D0A4\C9C0 \BCF8\BB38')
,p_lov_return_value=>'PACKAGE BODY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16909205432733687.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D504\B85C\C2DC\C800')
,p_lov_return_value=>'PROCEDURE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16909507509734338.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C720\D615')
,p_lov_return_value=>'TYPE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(77467331623506913.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\BDF0')
,p_lov_return_value=>'VIEW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/script_output_view_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(11936228645031897.4508)
,p_lov_name=>'SCRIPT_OUTPUT_VIEW_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(11936228645031897.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(11936413744031900.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BA85\B839\BB38')
,p_lov_return_value=>'STMT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12078021672086769.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\ACB0\ACFC')
,p_lov_return_value=>'RESULTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(11936610007031901.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\D53C\B4DC\BC31')
,p_lov_return_value=>'MSG'
);
end;
/
prompt --application/shared_components/user_interface/lovs/script_result_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(16851103836270043.4508)
,p_lov_name=>'SCRIPT_RESULT_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(16851103836270043.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16851311853270045.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C81C\CD9C \B0A0\C9DC')
,p_lov_return_value=>'SUBMITTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16851527617270045.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C2E4\D589 \C911')
,p_lov_return_value=>'EXECUTING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16851718446270046.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\C644\B8CC')
,p_lov_return_value=>'COMPLETE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16851904138270047.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\CDE8\C18C\B428')
,p_lov_return_value=>'CANCELED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/search_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(246393217654948737.4508)
,p_lov_name=>'SEARCH_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(246393217654948737.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(246393407696948737.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B300\C18C\BB38\C790 \AD6C\BD84')
,p_lov_return_value=>'CASE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/session_monitoring_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(159923116388036162.4508)
,p_lov_name=>'SESSION MONITORING STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(159923116388036162.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159923408566036193.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\BAA8\B450')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159923619966036211.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\D65C\C131')
,p_lov_return_value=>'ACTIVE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sga_target_lov
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1417526170798303.4508)
,p_lov_name=>'SGA_TARGET_LOV'
,p_lov_query=>'.'||wwv_flow_api.id(1417526170798303.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1417704549798326.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'64'
,p_lov_return_value=>'64M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1417915382798336.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'128'
,p_lov_return_value=>'128M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1418109764798336.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'192'
,p_lov_return_value=>'192M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1418312463798336.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'256'
,p_lov_return_value=>'256M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1418503267798338.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'320'
,p_lov_return_value=>'320M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1418716837798338.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'384'
,p_lov_return_value=>'384M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1418915626798339.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'448'
,p_lov_return_value=>'448M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1419122341798339.4508)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'512'
,p_lov_return_value=>'512M'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_details_checkbox
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(20435801528491678.4508)
,p_lov_name=>'SHOW DETAILS CHECKBOX'
,p_lov_query=>'.'||wwv_flow_api.id(20435801528491678.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20436019847491679.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C138\BD80\C815\BCF4 \D45C\C2DC')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_difference_only_checkbox
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(14974704196733524.4508)
,p_lov_name=>'SHOW DIFFERENCE ONLY CHECKBOX'
,p_lov_query=>'.'||wwv_flow_api.id(14974704196733524.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14974921191733525.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\CC28\C774\B9CC \D45C\C2DC')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_tables_with_and_without_comments
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(8639918272273372.4508)
,p_lov_name=>'SHOW TABLES WITH AND WITHOUT COMMENTS'
,p_lov_query=>'.'||wwv_flow_api.id(8639918272273372.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8640124542273376.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C124\BA85\C774 \C788\B294 \D14C\C774\BE14')
,p_lov_return_value=>'WITH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8640331660273378.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C124\BA85\C774 \C5C6\B294 \D14C\C774\BE14')
,p_lov_return_value=>'WITHOUT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8640518874273378.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\BAA8\B4E0 \D14C\C774\BE14')
,p_lov_return_value=>'ALL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_hide_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88026529019446655.4508)
,p_lov_name=>'SHOW.HIDE.Y.N'
,p_lov_query=>'.'||wwv_flow_api.id(88026529019446655.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88026728054446655.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D45C\C2DC')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88026921198446656.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C228\AE30\AE30')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sid_service
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(270736905720819349.4508)
,p_lov_name=>'SID_SERVICE'
,p_lov_query=>'.'||wwv_flow_api.id(270736905720819349.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(270737132068819350.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C11C\BE44\C2A4 \C774\B984')
,p_lov_return_value=>'SERVICE_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(270737303121819350.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SID'
,p_lov_return_value=>'SID'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sql_script_result_view_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(164092723800780852.4508)
,p_lov_name=>'SQL SCRIPT RESULT VIEW MODE'
,p_lov_query=>'.'||wwv_flow_api.id(164092723800780852.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164092906932780860.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C694\C57D')
,p_lov_return_value=>'SUMMARY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164093123083780865.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C138\BD80\C815\BCF4')
,p_lov_return_value=>'DETAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sql_filetype
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88033203570477156.4508)
,p_lov_name=>'SQL.FILETYPE'
,p_lov_query=>'.'||wwv_flow_api.id(88033203570477156.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88033427813477157.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C2A4\D06C\B9BD\D2B8 \D30C\C77C(*.sql)')
,p_lov_return_value=>'sql'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sql_txt_filetype
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88078901941959255.4508)
,p_lov_name=>'SQL.TXT.FILETYPE'
,p_lov_query=>'.'||wwv_flow_api.id(88078901941959255.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88079103923959257.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8 \D30C\C77C(*.txt)')
,p_lov_return_value=>'txt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88079307836959257.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C2A4\D06C\B9BD\D2B8 \D30C\C77C(*.sql)')
,p_lov_return_value=>'sql'
);
end;
/
prompt --application/shared_components/user_interface/lovs/synchronize_defaults_p809
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(42723506268079541.4508)
,p_lov_name=>'SYNCHRONIZE DEFAULTS P809'
,p_lov_query=>'.'||wwv_flow_api.id(42723506268079541.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42723726496079548.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \AE30\BCF8\AC12\C5D0 \B300\D55C \C560\D50C\B9AC\CF00\C774\C158 \C18D\C131')
,p_lov_return_value=>'FROM_APP'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#DISPLAY_VALUE#<br />',
'<span style="margin-left:20px;"><img src="#IMAGE_PREFIX#menu/info_64.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" /></span>'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42723917981079550.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C560\D50C\B9AC\CF00\C774\C158 \C18D\C131\C5D0 \B300\D55C \C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \AE30\BCF8\AC12')
,p_lov_return_value=>'FROM_DEF'
,p_lov_template=>'#DISPLAY_VALUE#<br /><span style="margin-left:20px;"><img src="#IMAGE_PREFIX#menu/client_64.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" /></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42726531464105754.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \AE30\BCF8\AC12\C5D0 \B300\D55C \B370\C774\D130\BCA0\C774\C2A4')
,p_lov_return_value=>'FROM_DB'
,p_lov_template=>'#DISPLAY_VALUE#<br /><span style="margin-left:20px;"><img src="#IMAGE_PREFIX#menu/db_64.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" /></span>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/system_privileges
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(25560713417668203.4508)
,p_lov_name=>'SYSTEM PRIVILEGES'
,p_lov_query=>'.'||wwv_flow_api.id(25560713417668203.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25560932733668206.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE VIEW'
,p_lov_return_value=>'CREATE VIEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25561118325668208.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE PROCEDURE'
,p_lov_return_value=>'CREATE PROCEDURE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25561329462668208.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE SYNONYM'
,p_lov_return_value=>'CREATE SYNONYM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25561509484668208.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE TABLE'
,p_lov_return_value=>'CREATE TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25561703573668209.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE INDEXTYPE'
,p_lov_return_value=>'CREATE INDEXTYPE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25561918387668209.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE SEQUENCE'
,p_lov_return_value=>'CREATE SEQUENCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25562101316668209.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE DATABASE LINK'
,p_lov_return_value=>'CREATE DATABASE LINK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25562309219668209.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE TYPE'
,p_lov_return_value=>'CREATE TYPE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25562510373668210.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE MATERIALIZED VIEW'
,p_lov_return_value=>'CREATE MATERIALIZED VIEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25562725532668210.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE CLUSTER'
,p_lov_return_value=>'CREATE CLUSTER'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25562915030668210.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE TRIGGER'
,p_lov_return_value=>'CREATE TRIGGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25563105054668210.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE OPERATOR'
,p_lov_return_value=>'CREATE OPERATOR'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25563322062668210.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE LIBRARY'
,p_lov_return_value=>'CREATE LIBRARY'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25563526933668211.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE DIMENSION'
,p_lov_return_value=>'CREATE DIMENSION'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25563701512668211.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE JOB'
,p_lov_return_value=>'CREATE JOB'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25563918014668211.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE PROFILE'
,p_lov_return_value=>'CREATE PROFILE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25564128815668211.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE PUBLIC DATABASE LINK'
,p_lov_return_value=>'CREATE PUBLIC DATABASE LINK'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25564332270668211.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE PUBLIC SYNONYM'
,p_lov_return_value=>'CREATE PUBLIC SYNONYM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25564509385668212.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE ROLE'
,p_lov_return_value=>'CREATE ROLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25564707743668213.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE ROLLBACK SEGMENT'
,p_lov_return_value=>'CREATE ROLLBACK SEGMENT'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25564902366668213.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE RULE'
,p_lov_return_value=>'CREATE RULE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25565120530668213.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE RULE SET'
,p_lov_return_value=>'CREATE RULE SET'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25565300473668214.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE SESSION'
,p_lov_return_value=>'CREATE SESSION'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25565512486668214.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE TABLESPACE'
,p_lov_return_value=>'CREATE TABLESPACE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25565717929668214.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CREATE USER'
,p_lov_return_value=>'CREATE USER'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/table_children
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3694131248687844.4508)
,p_lov_name=>'TABLE_CHILDREN'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''4500_1002_QB_JOIN'')||',
'       '' ''||wwv_flow_escape.html(p.column_name)||',
'       '' ''||wwv_flow_lang.system_message(''4500_1002_QB_TO'')||',
'       '' ''||wwv_flow_escape.html(c.table_name)||''.''||wwv_flow_escape.html(c.column_name) d , t.cid||''|''||c.column_name||''|''||p.column_name r',
'  from sys.dba_cons_columns c,',
'       sys.dba_cons_columns p,',
'       sys.dba_objects o,',
'       ( select c.r_constraint_name pc, ',
'                c.table_name cn, ',
'                c.constraint_name cc,',
'                oo.object_id cid, ',
'                rownum',
'           from sys.dba_constraints c,',
'                sys.dba_objects oo',
'          where c.constraint_type = ''R''',
'            and c.owner = :P59_SCHEMA',
'            and oo.object_name = c.table_name',
'            and oo.owner = c.owner ) t',
' where t.cc             = c.constraint_name',
'   and c.owner          = :P59_SCHEMA',
'   and t.pc             = p.constraint_name',
'   and p.owner          = :P59_SCHEMA',
'   and p.table_name     = :P59_TNAME ',
'   and o.object_name    = p.table_name',
'   and o.owner          = c.owner'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/table_parents
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3693427654677337.4508)
,p_lov_name=>'TABLE_PARENTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
' select wwv_flow_lang.system_message(''4500_1002_QB_JOIN'')||',
' '' ''||wwv_flow_escape.html(c.column_name)||'' ''||wwv_flow_lang.system_message(''4500_1002_QB_TO'')||',
' '' ''||wwv_flow_escape.html(p.table_name)||''.''||wwv_flow_escape.html(p.column_name) d , o.object_id||''|''||p.column_name||''|''||c.column_name r ',
'from',
'       sys.dba_cons_columns c,',
'       sys.dba_cons_columns p,',
'        sys.dba_objects o,',
'      ( SELECT c.r_constraint_name pc, c.table_name cn , c.constraint_name cc, rownum',
'        FROM sys.dba_constraints c ',
'        WHERE  c.constraint_type = ''R''',
'        AND c.table_name = :P59_TNAME',
'        and c.owner = :P59_SCHEMA ) t',
'where  t.cc = c.constraint_name',
'and c.owner = :P59_SCHEMA',
'and t.pc = p.constraint_name',
'and p.owner = :P59_SCHEMA',
'and o.object_name = p.table_name',
'and o.owner = c.owner'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/tabular_form_display_types_from_4000
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(197598824193421582.4508)
,p_lov_name=>'TABULAR_FORM_DISPLAY_TYPES (FROM 4000)'
,p_reference_id=>41868019518520883.4508
,p_lov_query=>'.'||wwv_flow_api.id(197598824193421582.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197599231811423843.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D45C\C900 \BCF4\ACE0\C11C \C5F4')
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197599400226423843.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(LOV \AE30\BC18, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'TEXT_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197599610663423843.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(\C0C1\D0DC \C800\C7A5)')
,p_lov_return_value=>'DISPLAY_AND_SAVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197599819865423845.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(\C774\C2A4\CF00\C774\D504 \D2B9\C218 \BB38\C790, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197600018265423845.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30')
,p_lov_return_value=>'DATE_POPUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197600224897423845.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8 \D544\B4DC')
,p_lov_return_value=>'TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197600423450423845.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8 \C601\C5ED')
,p_lov_return_value=>'TEXTAREA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197600606669423845.4508)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\C120\D0DD \BAA9\B85D(\C815\C801 LOV)')
,p_lov_return_value=>'SELECT_LIST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197600805803423845.4508)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\C120\D0DD \BAA9\B85D(\C774\B984\C774 \C9C0\C815\B41C LOV)')
,p_lov_return_value=>'SELECT_LIST_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197601002403423845.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C120\D0DD \BAA9\B85D(\C9C8\C758 \AE30\BC18 LOV)')
,p_lov_return_value=>'SELECT_LIST_FROM_QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197601201540423846.4508)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\B77C\B514\C624 \ADF8\B8F9(\C815\C801 LOV)')
,p_lov_return_value=>'RADIOGROUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197601419878423846.4508)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\B77C\B514\C624 \ADF8\B8F9(\C774\B984\C774 \C9C0\C815\B41C LOV)')
,p_lov_return_value=>'RADIOGROUP_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197601630729423846.4508)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\B77C\B514\C624 \ADF8\B8F9(\C9C8\C758 \AE30\BC18 LOV)	')
,p_lov_return_value=>'RADIOGROUP_FROM_QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197601813915423846.4508)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\C228\AE40 ')
,p_lov_return_value=>'HIDDEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197602006927423846.4508)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\D31D\C5C5 LOV(\C774\B984\C774 \C9C0\C815\B41C LOV)')
,p_lov_return_value=>'POPUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197602231429423846.4508)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\D31D\C5C5 LOV(\C9C8\C758 \AE30\BC18 LOV)')
,p_lov_return_value=>'POPUP_QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197602405258423846.4508)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\D31D\C5C5 \D0A4 LOV(\C774\B984\C774 \C9C0\C815\B41C LOV)')
,p_lov_return_value=>'POPUPKEY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(197602612872423846.4508)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('\D31D\C5C5 \D0A4 LOV(\C9C8\C758 \AE30\BC18 LOV)	')
,p_lov_return_value=>'POPUPKEY_QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/timeframe
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(30574425871912860.4508)
,p_lov_name=>'TIMEFRAME'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, to_char(t) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5*60 t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15*60 t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 3600 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 2*3600  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3*3600  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4*3600  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6*3600 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8*3600 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12*3600 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 18*3600 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1*24*60*60 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2*24*60*60 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3*24*60*60 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4*24*60*60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5*24*60*60 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 6*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7*24*60*60 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14*24*60*60 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365*24*60*60 t from dual order by 2',
') q'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/top_sql_by
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(236910808625037522.4508)
,p_lov_name=>'TOP_SQL_BY'
,p_lov_query=>'.'||wwv_flow_api.id(236910808625037522.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(236911029447037524.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('CPU \C2DC\AC04')
,p_lov_return_value=>'CPU_TIME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(236911210865037524.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\B514\C2A4\D06C \C77D\AE30')
,p_lov_return_value=>'DISK_READS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(236911407417037525.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\C2E4\D589')
,p_lov_return_value=>'EXECUTIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(236911618778037525.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\BC84\D37C \AC00\C838\C624\AE30')
,p_lov_return_value=>'BUFFER_GETS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(236911815989037525.4508)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\BC84\D37C \AC00\C838\C624\AE30/\CC98\B9AC\B41C \D589')
,p_lov_return_value=>'EFFICIENCY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(236912011147037525.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\BC84\D37C \AC00\C838\C624\AE30/\C2E4\D589')
,p_lov_return_value=>'EFFICIENCY2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/type_available
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(16945125859541385.4508)
,p_lov_name=>'TYPE_AVAILABLE'
,p_lov_query=>'select wwv_flow_escape.html(type_name) d, type_name r from sys.dba_types where owner = :OB_SCHEMA'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/type_collection_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(16529130513602905.4508)
,p_lov_name=>'TYPE_COLLECTION_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(16529130513602905.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16529302646602905.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'VArray'
,p_lov_return_value=>'V'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16529528167602906.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C911\CCA9 \D14C\C774\BE14')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/type_data_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(16534820904659665.4508)
,p_lov_name=>'TYPE_DATA_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(16534820904659665.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16535002611659667.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'BFILE'
,p_lov_return_value=>'BFILE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16535213310659667.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'BLOB'
,p_lov_return_value=>'BLOB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16535418281659667.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'CHAR'
,p_lov_return_value=>'CHAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16535626402659668.4508)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'CLOB'
,p_lov_return_value=>'CLOB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16535817963659668.4508)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'DATE'
,p_lov_return_value=>'DATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16536022932659668.4508)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'DECIMAL'
,p_lov_return_value=>'DECIMAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16536213254659668.4508)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'DOUBLE PRECISION'
,p_lov_return_value=>'DOUBLE PRECISION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16536400283659668.4508)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'FLOAT'
,p_lov_return_value=>'FLOAT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16536606880659669.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'INTEGER'
,p_lov_return_value=>'INTEGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16536824560659669.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'NUMBER'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16547232731688790.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'REAL'
,p_lov_return_value=>'REAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16547507582690914.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'SMALLINT'
,p_lov_return_value=>'SMALLINT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16547811738692161.4508)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'RAW'
,p_lov_return_value=>'RAW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16548116240693431.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'VARCHAR2'
,p_lov_return_value=>'VARCHAR2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16548420395694645.4508)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'REF'
,p_lov_return_value=>'REF'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16548730785697678.4508)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('< \C911\CCA9\B41C \AC1D\CCB4 >')
,p_lov_return_value=>'NEST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/type_of_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(16521502229452853.4508)
,p_lov_name=>'TYPE_OF_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(16521502229452853.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16521731440452856.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\BAA8\C74C \C720\D615')
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(16521925201452858.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\AC1D\CCB4 \C720\D615')
,p_lov_return_value=>'O'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_default_exp_imp_formats
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(40883415986261937.4508)
,p_lov_name=>'UI DEFAULT EXP IMP FORMATS'
,p_lov_query=>'.'||wwv_flow_api.id(40883415986261937.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40883610383262047.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Unix'
,p_lov_return_value=>'UNIX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40883829969262053.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'DOS'
,p_lov_return_value=>'DOS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40884027551262053.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\B370\C774\D130\BCA0\C774\C2A4')
,p_lov_return_value=>'DB'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_def_alignment_left_center_right
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(251500722928507973.4508)
,p_lov_name=>'UI_DEF_ALIGNMENT_LEFT_CENTER_RIGHT'
,p_lov_query=>'.'||wwv_flow_api.id(251500722928507973.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251500919515507973.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C67C\CABD')
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251501105156507973.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\AC00\C6B4\B370')
,p_lov_return_value=>'CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251501300215507973.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\C624\B978\CABD')
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_def_alignment_l_c_r
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(260501806598530292.4508)
,p_lov_name=>'UI_DEF_ALIGNMENT_L_C_R'
,p_lov_query=>'.'||wwv_flow_api.id(260501806598530292.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(260502019605530294.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C67C\CABD')
,p_lov_return_value=>'L'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(260502229771530295.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\AC00\C6B4\B370')
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(260502407085530295.4508)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\C624\B978\CABD')
,p_lov_return_value=>'R'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_def_display_as_tabular_forms
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(251435312257287190.4508)
,p_lov_name=>'UI_DEF_DISPLAY_AS_TABULAR_FORMS'
,p_lov_query=>'.'||wwv_flow_api.id(251435312257287190.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17234522425911770.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B77C\B514\C624 \ADF8\B8F9(\C774\B984\C774 \C9C0\C815\B41C LOV)')
,p_lov_return_value=>'RADIOGROUP_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251435518816287190.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D45C\C900 \BCF4\ACE0\C11C \C5F4(\D45C\C2DC \C804\C6A9, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251435707171287190.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(LOV \AE30\BC18, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'TEXT_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251435904461287190.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(\C0C1\D0DC \C800\C7A5)')
,p_lov_return_value=>'DISPLAY_AND_SAVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251436131397287190.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8\B85C \D45C\C2DC(\C774\C2A4\CF00\C774\D504 \D2B9\C218 \BB38\C790, \C0C1\D0DC\B97C \C800\C7A5\D558\C9C0 \C54A\C74C)')
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251436331018287190.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8 \D544\B4DC')
,p_lov_return_value=>'TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251436513801287190.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D14D\C2A4\D2B8 \C601\C5ED')
,p_lov_return_value=>'TEXTAREA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251436712096287191.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C120\D0DD \BAA9\B85D')
,p_lov_return_value=>'SELECT_LIST_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251436921215287191.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C228\AE40 ')
,p_lov_return_value=>'HIDDEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251437110722287191.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\D31D\C5C5 LOV')
,p_lov_return_value=>'POPUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251437316775287191.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(\D074\B798\C2DD)')
,p_lov_return_value=>'DATE_POPUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251437506052287191.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(\C560\D50C\B9AC\CF00\C774\C158 \D615\C2DD \B9C8\C2A4\D06C \C0AC\C6A9)')
,p_lov_return_value=>'PICK_DATE_USING_APP_FORMAT_MASK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251437713738287195.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-RR)')
,p_lov_return_value=>'PICK_DATE_DD_MON_RR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251437928196287195.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-RR HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251438122869287195.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-RR HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251438327137287195.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH24_MI'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251438527222287195.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YY HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH_MI'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251438708379287195.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YYYY)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251438921019287195.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YYYY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251439126695287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YYYY HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251439305041287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MON-YY)')
,p_lov_return_value=>'PICK_DATE_DD_MON_YY'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251439508577287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD/MM/YYYY)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251439705601287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD/MM/YYYY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251439912743287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD/MM/YYYY HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251440126520287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(MM/DD/YYYY)')
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251440332088287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(MM/DD/YYYY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251440513083287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(MM/DD/YYYY HH:MI)')
,p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251440720307287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(RR-MON-DD)')
,p_lov_return_value=>'PICK_DATE_RR_MON_DD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251440914527287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(RR-MON-DD HH24:MI)')
,p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251441107529287196.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(RR-MON-DD HH:MI)')
,p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251441327665287197.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY-MM-DD)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251441519610287197.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY-MM-DD HH24:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251441716061287197.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY-MM-DD HH:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251441922940287197.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MM-YYYY)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251442121133287197.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MM-YYYY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251442323229287197.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD-MM-YYYY HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251442518523287197.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD.MM.YYYY)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251442702648287197.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD.MM.YYYY HH24:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251442915305287199.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(DD.MM.YYYY HH:MI)')
,p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251443114390287199.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY.DD.MM)')
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251443317438287199.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY.DD.MM HH24:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251443530076287199.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY.DD.MM HH:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH_MI_DOT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251443706296287199.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY/MM/DD)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_SLASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251443923019287199.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY/MM/DD HH24:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251444119218287199.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(YYYY/MM/DD HH:MI)')
,p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251444312958287199.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30(\C560\D50C\B9AC\CF00\C774\C158 \B0A0\C9DC \D615\C2DD \C0AC\C6A9)')
,p_lov_return_value=>'PICK_DATE_USING_APP_DATE_FORMAT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(619426426716882935.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\B0A0\C9DC \C120\D0DD\AE30')
,p_lov_return_value=>'DATE_PICKER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17235123595921491.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\D31D\C5C5 \D0A4 LOV(\C774\B984\C774 \C9C0\C815\B41C LOV)')
,p_lov_return_value=>'POPUPKEY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17235632599924147.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\B2E8\C21C \CCB4\D06C\BC15\C2A4')
,p_lov_return_value=>'SIMPLE_CHECKBOX'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_def_static_dynamic
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(251523907288749450.4508)
,p_lov_name=>'UI_DEF_STATIC_DYNAMIC'
,p_lov_query=>'.'||wwv_flow_api.id(251523907288749450.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251524122983749452.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C815\C801')
,p_lov_return_value=>'S'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251524330798749453.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\B3D9\C801')
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/unique
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88045300809552005.4508)
,p_lov_name=>'UNIQUE'
,p_lov_query=>'.'||wwv_flow_api.id(88045300809552005.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88045530124552006.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\ACE0\C720')
,p_lov_return_value=>'UNIQUE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/unix_dos
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88081812938981328.4508)
,p_lov_name=>'UNIX.DOS'
,p_lov_query=>'.'||wwv_flow_api.id(88081812938981328.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88082021798981329.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'DOS'
,p_lov_return_value=>'DOS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88082214036981329.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'UNIX'
,p_lov_return_value=>'UNIX'
);
end;
/
prompt --application/shared_components/user_interface/lovs/user_interface_form_defaults_sync_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(40766106443619635.4508)
,p_lov_name=>'USER INTERFACE FORM DEFAULTS SYNC OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(40766106443619635.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40766308005619649.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\B808\C774\BE14')
,p_lov_return_value=>'LABEL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40766500283619653.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\D45C\C2DC \D615\C2DD')
,p_lov_return_value=>'DISPLAY_AS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40766713910619654.4508)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\D3FC \D45C\C2DC \C21C\C11C')
,p_lov_return_value=>'FORM_DISPLAY_SEQUENCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40766902092619654.4508)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\C694\C18C \B108\BE44')
,p_lov_return_value=>'ELEMENT_WIDTH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40767122890619654.4508)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\C694\C18C \CD5C\B300 \B108\BE44')
,p_lov_return_value=>'ELEMENT_MAX_WIDTH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40767319691619654.4508)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\C694\C18C \B192\C774')
,p_lov_return_value=>'ELEMENT_HEIGHT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40767510229619654.4508)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\B9DE\CDA4')
,p_lov_return_value=>'ITEM_ALIGNMENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40767731122619654.4508)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\B3C4\C6C0\B9D0 \D14D\C2A4\D2B8')
,p_lov_return_value=>'HELP_TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(40767913178619654.4508)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\C5F4 \ADF8\B8F9')
,p_lov_return_value=>'COLUMN_GROUP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/view_detail_summary
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(183733207435875441.4508)
,p_lov_name=>'VIEW_DETAIL_SUMMARY'
,p_lov_query=>'.'||wwv_flow_api.id(183733207435875441.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183733411221875446.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C138\BD80\C815\BCF4')
,p_lov_return_value=>'DETAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183733609162875449.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C694\C57D')
,p_lov_return_value=>'SUMMARY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/y_n_returns_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88037119678519608.4508)
,p_lov_name=>'Y.N.RETURNS.Y.N'
,p_lov_query=>'.'||wwv_flow_api.id(88037119678519608.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88037301694519609.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\C608')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88037513209519609.4508)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\C544\B2C8\C624')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_true_false
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(550748599416480697.4508)
,p_lov_name=>'YES NO TRUE FALSE'
,p_lov_query=>'.'||wwv_flow_api.id(550748599416480697.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(550748896421480698.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C608')
,p_lov_return_value=>'TRUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(550749224337480699.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C544\B2C8\C624')
,p_lov_return_value=>'FALSE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(23482928300634173.4508)
,p_lov_name=>'YES.NO.RETURNS.Y.N'
,p_lov_query=>'.'||wwv_flow_api.id(23482928300634173.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23483215241634177.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C608')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23483425275634179.4508)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\C544\B2C8\C624')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_checkbox
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(270681628960428645.4508)
,p_lov_name=>'YES_CHECKBOX'
,p_lov_query=>'.'||wwv_flow_api.id(270681628960428645.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(270681822685428648.4508)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\C608')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/y_noprompt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88018003898325845.4508)
,p_lov_name=>'Y_NOPROMPT'
,p_lov_query=>'.'||wwv_flow_api.id(88018003898325845.4508)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88018226427325846.4508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;',
'',
''))
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/sql_workshop_breadcrumb
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(6696510824685479.4508)
,p_name=>'sql.workshop.breadcrumb'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(772329493998247.4508)
,p_parent_id=>wwv_flow_api.id(.4508)
,p_short_name=>unistr('<span class="u-VisuallyHidden">SQL \C6CC\D06C\C20D</span><span class="a-Icon icon-breadcrumb-previous" title="SQL Workshop"></span>')
,p_link=>'f?p=&APP_ID.:3002:&SESSION.::&DEBUG.:::'
,p_page_id=>3002
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6705201527713238.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\B370\C774\D130 \B514\B809\D1A0\B9AC')
,p_link=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
,p_page_id=>13
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6706426100716981.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\BAA8\B4E0 \AC1D\CCB4')
,p_link=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.:::'
,p_page_id=>500
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6811015570619086.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('DDL \C0DD\C131')
,p_link=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:::'
,p_page_id=>18
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6812109315622008.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('DDL \C0DD\C131')
,p_link=>'f?p=&APP_ID.:43:&SESSION.::&DEBUG.:::'
,p_page_id=>43
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6813302846625021.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('DDL \C0DD\C131')
,p_link=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.:::'
,p_page_id=>44
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6814424184630342.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('DDL \C0DD\C131')
,p_link=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:::'
,p_page_id=>29
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(8926117673071967.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\AC1D\CCB4 \AD8C\D55C \BD80\C5EC')
,p_link=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.:::'
,p_page_id=>1401
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(8952218341276601.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\C5F4 \AD8C\D55C')
,p_link=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.:::'
,p_page_id=>1402
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(8971325993409812.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\B864 \AD8C\D55C')
,p_link=>'f?p=&APP_ID.:1502:&SESSION.::&DEBUG.:::'
,p_page_id=>1502
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10124106014708590.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('\C2A4\D06C\B9BD\D2B8 \ACB0\ACFC \AD00\B9AC')
,p_link=>'f?p=&APP_ID.:1220:&SESSION.::&DEBUG.:1220::'
,p_page_id=>1220
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10588828468855036.4508)
,p_parent_id=>wwv_flow_api.id(.4508)
,p_short_name=>unistr('<span class="u-VisuallyHidden">\D648</span><span class="a-Icon icon-breadcrumb-previous" title="Home"></span>')
,p_link=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:::'
,p_page_id=>1000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10589915313861129.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\AC1D\CCB4 \BE0C\B77C\C6B0\C800')
,p_link=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.:::'
,p_page_id=>1001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10592208399879519.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('SQL \BA85\B839')
,p_link=>'f?p=&APP_ID.:1003:&SESSION.::&DEBUG.:::'
,p_page_id=>1003
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10593427149886024.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('SQL \C2A4\D06C\B9BD\D2B8')
,p_link=>'f?p=&APP_ID.:1004:&SESSION.::&DEBUG.:::'
,p_page_id=>1004
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10594829078900305.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\C720\D2F8\B9AC\D2F0')
,p_link=>'f?p=&APP_ID.:1005:&SESSION.::&DEBUG.:::'
,p_page_id=>1005
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10596216354906213.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('\C9C8\C758 \C791\C131\AE30')
,p_link=>'f?p=&APP_ID.:1002:&SESSION.::&DEBUG.:::'
,p_page_id=>1002
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10992323079081645.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('\C2A4\D06C\B9BD\D2B8 \C5C5\B85C\B4DC')
,p_link=>'f?p=&FLOW_ID.:1017:&SESSION.'
,p_page_id=>1017
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11068702995513360.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\BD80\C801\D569\D55C \AC1D\CCB4')
,p_link=>'f?p=&APP_ID.:1040:&SESSION.::&DEBUG.:::'
,p_page_id=>1040
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11085502299574373.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('\AC1D\CCB4 \BCF4\ACE0\C11C')
,p_link=>'f?p=&APP_ID.:1042:&SESSION.::&DEBUG.:::'
,p_page_id=>1042
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11149705248454307.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('PL/SQL \D504\B85C\ADF8\B7A8 \B2E8\C704 \C778\C218')
,p_link=>'f?p=&APP_ID.:1046:&SESSION.::&DEBUG.:::'
,p_page_id=>1046
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11153616234464356.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \C5F4')
,p_link=>'f?p=&APP_ID.:1047:&SESSION.::&DEBUG.:::'
,p_page_id=>1047
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11217630077734286.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \C800\C7A5 \C601\C5ED \D06C\AE30')
,p_link=>'f?p=&APP_ID.:1048:&SESSION.::&DEBUG.:::'
,p_page_id=>1048
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11288509439457981.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \D1B5\ACC4')
,p_link=>'f?p=&APP_ID.:1052:&SESSION.::&DEBUG.:::'
,p_page_id=>1052
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11326702174643629.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('PL/SQL \B2E8\C704 \D589 \C218')
,p_link=>'f?p=&APP_ID.:1054:&SESSION.::&DEBUG.:::'
,p_page_id=>1054
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11338430795706423.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\AC1D\CCB4 \C0DD\C131 \B2EC\B825')
,p_link=>'f?p=&APP_ID.:1055:&SESSION.::&DEBUG.:::'
,p_page_id=>1055
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11357823604800886.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\C720\D615\BCC4 \AC1D\CCB4 \C218')
,p_link=>'f?p=&APP_ID.:1059:&SESSION.::&DEBUG.:::'
,p_page_id=>1059
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11399029987478216.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('\D734\C9C0\D1B5')
,p_link=>'f?p=&APP_ID.:1070:&SESSION.::&DEBUG.:::'
,p_page_id=>1070
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11862912827302953.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('\ACB0\ACFC')
,p_link=>'f?p=&APP_ID.:1225:&SESSION.::&DEBUG.:::'
,p_page_id=>1225
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(14636719155541383.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('\C2A4\D0A4\B9C8 \BE44\AD50')
,p_link=>'f?p=&FLOW_ID.:1350:&SESSION.'
,p_page_id=>1350
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(17981116039285577.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \C124\BA85')
,p_link=>'f?p=&APP_ID.:701:&SESSION.::&DEBUG.:::'
,p_page_id=>701
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(18641121311026961.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\AE30\BCF8 \D0A4\AC00 \C5C6\B294 \D14C\C774\BE14')
,p_link=>'f?p=&APP_ID.:702:&SESSION.::&DEBUG.:::'
,p_page_id=>702
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(18645002872040514.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\C778\B371\C2A4\D654\B418\C9C0 \C54A\C740 \C678\B798 \D0A4')
,p_link=>'f?p=&APP_ID.:704:&SESSION.::&DEBUG.:::'
,p_page_id=>704
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(20466103415554205.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \AD00\B9AC\C790 \B85C\ADF8\C778')
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(21105931218170005.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \C81C\C57D \C870\AC74')
,p_link=>'f?p=&APP_ID.:706:&SESSION.::&DEBUG.:::'
,p_page_id=>706
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(21759901986574992.4508)
,p_parent_id=>wwv_flow_api.id(6706426100716981.4508)
,p_short_name=>unistr('\D589 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:51:&SESSION.'
,p_page_id=>51
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(22279723159373331.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('\C2A4\D06C\B9BD\D2B8 \C2E4\D589')
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(22285026166387102.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('\C2A4\D06C\B9BD\D2B8 \D3B8\C9D1\AE30')
,p_link=>'f?p=&APP_ID.:60:&SESSION.::&DEBUG.:::'
,p_page_id=>60
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(22511901715091409.4508)
,p_parent_id=>wwv_flow_api.id(6705201527713238.4508)
,p_short_name=>unistr('\B370\C774\D130 \B515\C154\B108\B9AC \BE0C\B77C\C6B0\C800')
,p_link=>'f?p=&FLOW_ID.:14:&SESSION.'
,p_page_id=>14
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(22513030170093436.4508)
,p_parent_id=>wwv_flow_api.id(6705201527713238.4508)
,p_short_name=>unistr('\B370\C774\D130 \B515\C154\B108\B9AC \BE0C\B77C\C6B0\C800')
,p_link=>'f?p=&FLOW_ID.:15:&SESSION.'
,p_page_id=>15
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(27996403095868309.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('\BD80\C801\D569\D55C \C2A4\D06C\B9BD\D2B8')
,p_link=>'f?p=&APP_ID.:1022:&SESSION.::&DEBUG.:::'
,p_page_id=>1022
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(28034702528035781.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('\C2A4\D06C\B9BD\D2B8 \AD6C\BB38\BD84\C11D')
,p_link=>'f?p=&FLOW_ID.:1023:&SESSION.'
,p_page_id=>1023
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(28148306201885508.4508)
,p_parent_id=>wwv_flow_api.id(10588828468855036.4508)
,p_short_name=>unistr('\AC80\C0C9')
,p_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:::'
,p_page_id=>8000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(29042426642278445.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\C778\B371\C2A4\AC00 \C5C6\B294 \D14C\C774\BE14')
,p_link=>'f?p=&APP_ID.:707:&SESSION.::&DEBUG.:::'
,p_page_id=>707
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40285323892651842.4508)
,p_parent_id=>wwv_flow_api.id(421010727467722425.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \B515\C154\B108\B9AC')
,p_link=>'f?p=&APP_ID.:800:&SESSION.::&DEBUG.:::'
,p_page_id=>800
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40292805535877838.4508)
,p_parent_id=>wwv_flow_api.id(40285323892651842.4508)
,p_short_name=>unistr('\AE30\BCF8\AC12 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:801:&SESSION.::&DEBUG.:::'
,p_page_id=>801
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40299503213041788.4508)
,p_parent_id=>wwv_flow_api.id(40285323892651842.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \BC0F \C5F4 \C18D\C131')
,p_link=>'f?p=&APP_ID.:802:&SESSION.::&DEBUG.:::'
,p_page_id=>802
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40567512492661701.4508)
,p_parent_id=>wwv_flow_api.id(40299503213041788.4508)
,p_short_name=>unistr('\C5F4 \AE30\BCF8\AC12')
,p_link=>'f?p=&APP_ID.:803:&SESSION.::&DEBUG.:::'
,p_page_id=>803
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40643306074424515.4508)
,p_parent_id=>wwv_flow_api.id(40299503213041788.4508)
,p_short_name=>unistr('\C138\BD80\C815\BCF4')
,p_link=>'f?p=&APP_ID.:804:&SESSION.::&DEBUG.:::'
,p_page_id=>804
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40820227368905885.4508)
,p_parent_id=>wwv_flow_api.id(40299503213041788.4508)
,p_short_name=>unistr('\C81C\AC70')
,p_link=>'f?p=&APP_ID.:830:&SESSION.::&DEBUG.:::'
,p_page_id=>830
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40837720793349176.4508)
,p_parent_id=>wwv_flow_api.id(40299503213041788.4508)
,p_short_name=>unistr('\C5F4 \ADF8\B8F9')
,p_link=>'f?p=&FLOW_ID.:805:&SESSION.'
,p_page_id=>805
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40849914508722527.4508)
,p_parent_id=>wwv_flow_api.id(40285323892651842.4508)
,p_short_name=>unistr('\AE30\BCF8\AC12 \B3D9\AE30\D654')
,p_link=>'f?p=&APP_ID.:840:&SESSION.::&DEBUG.:::'
,p_page_id=>840
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40878107658219856.4508)
,p_parent_id=>wwv_flow_api.id(40285323892651842.4508)
,p_short_name=>unistr('\C775\C2A4\D3EC\D2B8')
,p_link=>'f?p=&APP_ID.:841:&SESSION.::&DEBUG.:::'
,p_page_id=>841
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40882008035232666.4508)
,p_parent_id=>wwv_flow_api.id(40285323892651842.4508)
,p_short_name=>unistr('\C784\D3EC\D2B8')
,p_link=>'f?p=&APP_ID.:842:&SESSION.::&DEBUG.:::'
,p_page_id=>842
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40886501144281716.4508)
,p_parent_id=>wwv_flow_api.id(40285323892651842.4508)
,p_short_name=>unistr('\C784\D3EC\D2B8')
,p_link=>'f?p=&APP_ID.:843:&SESSION.::&DEBUG.:::'
,p_page_id=>843
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(69179911399462494.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\D2B8\B9AC\AC70\AC00 \C5C6\B294 \D14C\C774\BE14')
,p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP::'
,p_page_id=>2
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(72162217233653931.4508)
,p_parent_id=>wwv_flow_api.id(11399029987478216.4508)
,p_short_name=>unistr('\C0AD\C81C\B41C \AC1D\CCB4')
,p_link=>'f?p=&APP_ID.:400:&SESSION.::&DEBUG.:::'
,p_page_id=>400
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(75123728807801147.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('DDL \C0DD\C131')
,p_link=>'f?p=&APP_ID.:45:&SESSION.::&DEBUG.:::'
,p_page_id=>45
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(111995318366763047.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('DDL \C0DD\C131')
,p_link=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::'
,p_page_id=>12
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(133761526646244887.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \BAA8\B2C8\D130')
,p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(134582607728955084.4508)
,p_parent_id=>wwv_flow_api.id(133761526646244887.4508)
,p_short_name=>unistr('\CD5C\C0C1\C704 SQL')
,p_link=>'f?p=&FLOW_ID.:21:&SESSION.'
,p_page_id=>21
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(137474117958285727.4508)
,p_parent_id=>wwv_flow_api.id(133761526646244887.4508)
,p_short_name=>unistr('\AE34 \C791\C5C5')
,p_link=>'f?p=&FLOW_ID.:34:&SESSION.'
,p_page_id=>34
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(143179626108764932.4508)
,p_parent_id=>wwv_flow_api.id(72162217233653931.4508)
,p_short_name=>unistr('\AC1D\CCB4 \C138\BD80\C815\BCF4')
,p_link=>'f?p=&APP_ID.:401:&SESSION.::&DEBUG.:::'
,p_page_id=>401
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(143180608231769218.4508)
,p_parent_id=>wwv_flow_api.id(11399029987478216.4508)
,p_short_name=>unistr('\D734\C9C0\D1B5 \BE44\C6B0\AE30')
,p_link=>'f?p=&APP_ID.:403:&SESSION.::&DEBUG.:::'
,p_page_id=>403
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(150053105689895122.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('\C2A4\D06C\B9BD\D2B8 \D560\B2F9\B7C9')
,p_link=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.:::'
,p_page_id=>31
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(159591503203412870.4508)
,p_parent_id=>wwv_flow_api.id(133761526646244887.4508)
,p_short_name=>unistr('\C138\C158')
,p_link=>'f?p=&FLOW_ID.:540:&SESSION.'
,p_page_id=>540
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(159755809418519186.4508)
,p_parent_id=>wwv_flow_api.id(159591503203412870.4508)
,p_short_name=>unistr('\C138\C158 \C138\BD80\C815\BCF4')
,p_link=>'f?p=&APP_ID.:550:&SESSION.::&DEBUG.:::'
,p_page_id=>550
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(159933105269080223.4508)
,p_parent_id=>wwv_flow_api.id(159591503203412870.4508)
,p_short_name=>unistr('\C138\C158 \C885\B8CC')
,p_link=>'f?p=&APP_ID.:549:&SESSION.::&DEBUG.:::'
,p_page_id=>549
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(160130313889480180.4508)
,p_parent_id=>wwv_flow_api.id(159591503203412870.4508)
,p_short_name=>'SQL'
,p_link=>'f?p=&APP_ID.:542:&SESSION.::&DEBUG.:::'
,p_page_id=>542
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(160176710875611770.4508)
,p_parent_id=>wwv_flow_api.id(159591503203412870.4508)
,p_short_name=>'I/O'
,p_link=>'f?p=&APP_ID.:545:&SESSION.::&DEBUG.:::'
,p_page_id=>545
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(160179326112616109.4508)
,p_parent_id=>wwv_flow_api.id(159591503203412870.4508)
,p_short_name=>unistr('\C7A0\AE08')
,p_link=>'f?p=&APP_ID.:541:&SESSION.::&DEBUG.:::'
,p_page_id=>541
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(160301306026960460.4508)
,p_parent_id=>wwv_flow_api.id(159591503203412870.4508)
,p_short_name=>unistr('\C5F4\B9B0 \CEE4\C11C')
,p_link=>'f?p=&APP_ID.:543:&SESSION.::&DEBUG.:::'
,p_page_id=>543
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(160475100044505141.4508)
,p_parent_id=>wwv_flow_api.id(160130313889480180.4508)
,p_short_name=>unistr('SQL \ACC4\D68D')
,p_link=>'f?p=&FLOW_ID.:551:&SESSION.'
,p_page_id=>551
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(160542529171631000.4508)
,p_parent_id=>wwv_flow_api.id(160301306026960460.4508)
,p_short_name=>unistr('\CEE4\C11C \C138\BD80\C815\BCF4')
,p_link=>'f?p=&APP_ID.:546:&SESSION.::&DEBUG.:::'
,p_page_id=>546
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(163508316960932084.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('PL/SQL \C18C\C2A4 \CF54\B4DC \AC80\C0C9')
,p_link=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:::'
,p_page_id=>27
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(164008763793256066.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('\C0D8\D50C \B370\C774\D130 \AD00\B9AC')
,p_link=>'f?p=&APP_ID.:200:&SESSION.'
,p_page_id=>200
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(164035265026435705.4508)
,p_parent_id=>wwv_flow_api.id(164008763793256066.4508)
,p_short_name=>unistr('\B370\C774\D130\C138\D2B8 \AD00\B9AC')
,p_link=>'f?p=&APP_ID.:201:&SESSION.'
,p_page_id=>201
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(168883113098410783.4508)
,p_parent_id=>wwv_flow_api.id(159591503203412870.4508)
,p_short_name=>unistr('\B300\AE30')
,p_link=>'f?p=&APP_ID.:548:&SESSION.::&DEBUG.:::'
,p_page_id=>548
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171425301256234951.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:602:&SESSION.::&DEBUG.:::'
,p_page_id=>602
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171432228380283077.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:604:&SESSION.'
,p_page_id=>604
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171436029446297824.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:145:&SESSION.'
,p_page_id=>145
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171436513056305383.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:149:&SESSION.'
,p_page_id=>149
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171439824030330759.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:612:&SESSION.'
,p_page_id=>612
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171447012119396992.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\BDF0 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:48:&SESSION.'
,p_page_id=>48
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171448512957426996.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\BDF0 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:52:&SESSION.'
,p_page_id=>52
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171451019402454341.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\C778\B371\C2A4 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:57:&SESSION.::&DEBUG.:::'
,p_page_id=>57
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171451828016465595.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\C778\B371\C2A4 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:77:&SESSION.'
,p_page_id=>77
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171454530592479551.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\C778\B371\C2A4 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:5:&SESSION.'
,p_page_id=>5
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171458922803513607.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D14D\C2A4\D2B8 \C778\B371\C2A4 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:94:&SESSION.'
,p_page_id=>94
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171460222144529128.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\C2DC\D000\C2A4 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:97:&SESSION.'
,p_page_id=>97
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171460904244537406.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\C2DC\D000\C2A4 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:116:&SESSION.'
,p_page_id=>116
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171482002943811468.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D328\D0A4\C9C0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:::'
,p_page_id=>120
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171486607219855054.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D328\D0A4\C9C0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:124:&SESSION.::&DEBUG.:::'
,p_page_id=>124
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171488126185861375.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D328\D0A4\C9C0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:125:&SESSION.::&DEBUG.:::'
,p_page_id=>125
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171490019475894957.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\C720\D615 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:182:&SESSION.::&DEBUG.:::'
,p_page_id=>182
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171491323548923460.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\BAA8\C74C \C720\D615 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:183:&SESSION.'
,p_page_id=>183
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171493008870945443.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\BAA8\C74C \C720\D615 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:184:&SESSION.::&DEBUG.:::'
,p_page_id=>184
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171494726973952173.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D504\B85C\C2DC\C800 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:121:&SESSION.'
,p_page_id=>121
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171495932353964930.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D504\B85C\C2DC\C800 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:122:&SESSION.'
,p_page_id=>122
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171496821570969952.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D504\B85C\C2DC\C800 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:123:&SESSION.'
,p_page_id=>123
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171497832340980133.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D504\B85C\C2DC\C800 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:114:&SESSION.'
,p_page_id=>114
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171499512487004501.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D568\C218 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:98:&SESSION.'
,p_page_id=>98
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171500106017007485.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D568\C218 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:107:&SESSION.'
,p_page_id=>107
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171500730159011487.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D568\C218 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:100:&SESSION.'
,p_page_id=>100
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171501317866017225.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D504\B85C\C2DC\C800 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:::'
,p_page_id=>110
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171504210725050867.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D568\C218 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:109:&SESSION.'
,p_page_id=>109
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171505125809059139.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D2B8\B9AC\AC70 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171507121649137024.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D2B8\B9AC\AC70 \C0AC\C6A9 \C548\D568')
,p_link=>'f?p=&FLOW_ID.:85:&SESSION.'
,p_page_id=>85
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171510925088150539.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D2B8\B9AC\AC70 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:84:&SESSION.'
,p_page_id=>84
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171512816233169881.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B9C1\D06C \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:91:&SESSION.'
,p_page_id=>91
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171513601137176883.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B9C1\D06C \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:92:&SESSION.'
,p_page_id=>92
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171516113201186517.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\AD6C\CCB4\D654\B41C \BDF0 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:135:&SESSION.'
,p_page_id=>135
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171517422678197296.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\AD6C\CCB4\D654\B41C \BDF0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:136:&SESSION.::&DEBUG.:::'
,p_page_id=>136
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171518216424200174.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\B3D9\C758\C5B4 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:99:&SESSION.'
,p_page_id=>99
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171522218137214533.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\B3D9\C758\C5B4 \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:127:&SESSION.'
,p_page_id=>127
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(172518105625045296.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C815\BCF4')
,p_link=>'f?p=&APP_ID.:36:&SESSION.::&DEBUG.:::'
,p_page_id=>36
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(182583013828345804.4508)
,p_parent_id=>wwv_flow_api.id(133761526646244887.4508)
,p_short_name=>unistr('\C2DC\C2A4\D15C \D1B5\ACC4')
,p_link=>'f?p=&APP_ID.:560:&SESSION.::&DEBUG.:::'
,p_page_id=>560
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(196241518637196386.4508)
,p_parent_id=>wwv_flow_api.id(421010727467722425.4508)
,p_short_name=>unistr('\C18D\C131 \B515\C154\B108\B9AC')
,p_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
,p_page_id=>6
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(197565613605290234.4508)
,p_parent_id=>wwv_flow_api.id(196241518637196386.4508)
,p_short_name=>unistr('\C5F4 \C138\BD80\C815\BCF4')
,p_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::'
,p_page_id=>17
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(200281305325646013.4508)
,p_parent_id=>wwv_flow_api.id(197565613605290234.4508)
,p_short_name=>unistr('\B3D9\C758\C5B4')
,p_link=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:::'
,p_page_id=>30
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(201423513077254455.4508)
,p_parent_id=>wwv_flow_api.id(40299503213041788.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \AE30\BCF8\AC12')
,p_link=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.:::'
,p_page_id=>19
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(201465410091357808.4508)
,p_parent_id=>wwv_flow_api.id(40285323892651842.4508)
,p_short_name=>unistr('\C774\C804')
,p_link=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:::'
,p_page_id=>32
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(201468702160374868.4508)
,p_parent_id=>wwv_flow_api.id(201465410091357808.4508)
,p_short_name=>unistr('\D655\C778')
,p_link=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:::'
,p_page_id=>33
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(203665020594989187.4508)
,p_parent_id=>wwv_flow_api.id(10588828468855036.4508)
,p_short_name=>unistr('\D648 \D398\C774\C9C0 \BCF4\ACE0 \C2DC\AC04\BC94\C704 \C124\C815')
,p_link=>'f?p=&APP_ID.:35:&SESSION.::&DEBUG.:::'
,p_page_id=>35
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(221315102551645720.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('SQL \C2A4\D06C\B9BD\D2B8 \C775\C2A4\D3EC\D2B8')
,p_link=>'f?p=&FLOW_ID.:65:&SESSION.'
,p_page_id=>65
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(221325920426667820.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('\C2A4\D06C\B9BD\D2B8 \C784\D3EC\D2B8')
,p_link=>'f?p=&APP_ID.:112:&SESSION.::&DEBUG.:::'
,p_page_id=>112
);
end;
/
begin
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(222573212803039290.4508)
,p_parent_id=>wwv_flow_api.id(10593427149886024.4508)
,p_short_name=>unistr('\C2A4\D06C\B9BD\D2B8 \C784\D3EC\D2B8')
,p_link=>'f?p=&APP_ID.:115:&SESSION.::&DEBUG.:::'
,p_page_id=>115
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(239008520667654108.4508)
,p_parent_id=>wwv_flow_api.id(11085502299574373.4508)
,p_short_name=>unistr('\C2DC\C2A4\D15C \AD8C\D55C')
,p_link=>'f?p=&APP_ID.:1404:&SESSION.::&DEBUG.:::'
,p_page_id=>1404
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(262136511357898947.4508)
,p_parent_id=>wwv_flow_api.id(196241518637196386.4508)
,p_short_name=>unistr('\ADF8\B9AC\B4DC \D3B8\C9D1')
,p_link=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:::'
,p_page_id=>28
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(293412507991016597.4508)
,p_parent_id=>wwv_flow_api.id(40567512492661701.4508)
,p_short_name=>unistr('\C815\C801 \AC12 \BAA9\B85D')
,p_link=>'f?p=&FLOW_ID.:37:&SESSION.'
,p_page_id=>37
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(421010727467722425.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>unistr('\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \AE30\BCF8\AC12')
,p_link=>'f?p=&APP_ID.:813:&SESSION.::&DEBUG.:::'
,p_page_id=>813
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(428883026446520866.4508)
,p_parent_id=>wwv_flow_api.id(40567512492661701.4508)
,p_short_name=>unistr('\C815\C801 \AC12 \BAA9\B85D \C0DD\C131')
,p_link=>'f?p=&FLOW_ID.:40:&SESSION.'
,p_page_id=>40
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(429083825310173254.4508)
,p_parent_id=>wwv_flow_api.id(40299503213041788.4508)
,p_short_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4\C640 \B3D9\AE30\D654')
,p_link=>'f?p=&APP_ID.:807:&SESSION.::&DEBUG.:::'
,p_page_id=>807
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(442018226743378979.4508)
,p_parent_id=>wwv_flow_api.id(196241518637196386.4508)
,p_short_name=>unistr('\C775\C2A4\D3EC\D2B8')
,p_link=>'f?p=&FLOW_ID.:39:&SESSION.'
,p_page_id=>39
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(442035418735604919.4508)
,p_parent_id=>wwv_flow_api.id(196241518637196386.4508)
,p_short_name=>unistr('\C784\D3EC\D2B8')
,p_link=>'f?p=&FLOW_ID.:41:&SESSION.'
,p_page_id=>41
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(442061305390114586.4508)
,p_parent_id=>wwv_flow_api.id(196241518637196386.4508)
,p_short_name=>unistr('\C784\D3EC\D2B8')
,p_link=>'f?p=&FLOW_ID.:56:&SESSION.'
,p_page_id=>56
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(460475029741643216.4508)
,p_parent_id=>wwv_flow_api.id(17981116039285577.4508)
,p_short_name=>unistr('\D3B8\C9D1')
,p_link=>'f?p=&FLOW_ID.:70:&SESSION.'
,p_page_id=>70
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(479591118396883844.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B9C1\D06C \C0DD\C131')
,p_link=>'f?p=&APP_ID.:58:&SESSION.::&DEBUG.:::'
,p_page_id=>58
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(480554732367338960.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D14C\C774\BE14 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:614:&SESSION.::&DEBUG.:::'
,p_page_id=>614
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(480558704933425630.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\BDF0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.:::'
,p_page_id=>54
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(480564400225509403.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\C778\B371\C2A4 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::'
,p_page_id=>4
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(480645807666823734.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\C2DC\D000\C2A4 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:129:&SESSION.::&DEBUG.:::'
,p_page_id=>129
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(480707610492928646.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\BAA8\C74C \C720\D615 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:185:&SESSION.::&DEBUG.:::'
,p_page_id=>185
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(480709530381095227.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D2B8\B9AC\AC70 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(480710828828132548.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D2B8\B9AC\AC70 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:::'
,p_page_id=>16
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(481056418596783126.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\AD6C\CCB4\D654\B41C \BDF0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.:::'
,p_page_id=>141
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(481059006270864712.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\B3D9\C758\C5B4 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:::'
,p_page_id=>8
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(492587017575861321.4508)
,p_parent_id=>wwv_flow_api.id(10588828468855036.4508)
,p_short_name=>unistr('\C0AC\C6A9 \AC00\B2A5\D55C \C5C5\B370\C774\D2B8 \D655\C778')
,p_link=>'f?p=&APP_ID.:61:&SESSION.::&DEBUG.:::'
,p_page_id=>61
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1081401622843630208.4508)
,p_parent_id=>wwv_flow_api.id(10588828468855036.4508)
,p_short_name=>unistr('\D568\C218 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:62:&SESSION.'
,p_page_id=>62
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1082294870183550455.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D328\D0A4\C9C0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:117:&SESSION.::&DEBUG.:::'
,p_page_id=>117
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1082295312410555994.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D328\D0A4\C9C0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:118:&SESSION.::&DEBUG.:::'
,p_page_id=>118
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1082295582684558595.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D328\D0A4\C9C0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.:::'
,p_page_id=>131
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1082296216976562127.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D328\D0A4\C9C0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:186:&SESSION.::&DEBUG.:::'
,p_page_id=>186
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1082296445019564164.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D328\D0A4\C9C0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:187:&SESSION.::&DEBUG.:::'
,p_page_id=>187
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1104480510265001727.4508)
,p_parent_id=>wwv_flow_api.id(772329493998247.4508)
,p_short_name=>unistr('\D328\D0A4\C9C0 \C0DD\C131')
,p_link=>'f?p=&APP_ID.:126:&SESSION.::&DEBUG.:::'
,p_page_id=>126
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4213233088501710020.4508)
,p_parent_id=>wwv_flow_api.id(10594829078900305.4508)
,p_short_name=>'Quick SQL'
,p_link=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.:::'
,p_page_id=>1100
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/alternative_sql_plan
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(238735327519050534.4508)
,p_name=>'Alternative SQL Plan'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(238744703025100258.4508)
,p_parent_id=>wwv_flow_api.id(239011303829658740.4508)
,p_short_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \BAA8\B2C8\D130')
,p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(238747600732109040.4508)
,p_parent_id=>wwv_flow_api.id(238744703025100258.4508)
,p_short_name=>unistr('\CD5C\C0C1\C704 SQL')
,p_link=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::'
,p_page_id=>21
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(238748709736111653.4508)
,p_parent_id=>wwv_flow_api.id(238747600732109040.4508)
,p_short_name=>unistr('SQL \ACC4\D68D')
,p_link=>'f?p=&APP_ID.:551:&SESSION.::&DEBUG.:::'
,p_page_id=>551
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(239011303829658740.4508)
,p_parent_id=>wwv_flow_api.id(467828023586139366.4508)
,p_short_name=>unistr('\C720\D2F8\B9AC\D2F0')
,p_link=>'f?p=&APP_ID.:1005:&SESSION.::&DEBUG.:::'
,p_page_id=>1005
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(467828023586139366.4508)
,p_parent_id=>wwv_flow_api.id(238741426181078594.4508)
,p_short_name=>unistr('SQL \C6CC\D06C\C20D')
,p_link=>'f?p=&APP_ID.:3002:&SESSION.::&DEBUG.:::'
,p_page_id=>3002
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(851340608959428999.4508)
,p_parent_id=>wwv_flow_api.id(.4508)
,p_short_name=>unistr('\C2A4\D06C\B9BD\D2B8 \C784\D3EC\D2B8')
,p_link=>'f?p=&FLOW_ID.:115:&SESSION.'
,p_page_id=>115
);
end;
/
prompt --application/shared_components/user_interface/templates/page/columbus_page_with_schema_jog_from_4999
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3490920094618697.4508)
,p_theme_id=>3
,p_name=>'(Columbus) Page With Schema Jog from 4999.ko'
,p_internal_name=>'COLUMBUS_PAGE_WITH_SCHEMA_JOG_FROM_4999'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-two-col">',
'      <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>29839111526369755.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_query_builder_pop_up_to_be_deleted
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(13310402196993814.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Query Builder Pop Up (to be deleted).ko'
,p_internal_name=>'APEX_5.0_QUERY_BUILDER_POP_UP_TO_BE_DELETED'
,p_is_popup=>false
,p_inline_css=>'.a-Header, #R387929284740561918 {display: none;}'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <script src="#IMAGE_PREFIX#sw/minified/htmldb_data.min.js" type="text/javascript" defer="defer"></script>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>787614155243007050.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/columbus_minimal_for_ppr_only_pulls_from_4999
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(14599108081253832.4508)
,p_theme_id=>3
,p_name=>'(Columbus) Minimal For PPR only Pulls From 4999.ko'
,p_internal_name=>'COLUMBUS_MINIMAL_FOR_PPR_ONLY_PULLS_FROM_4999'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'',
'<head>',
'',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<title>#TITLE#</title>',
'</head>',
'<body onload="parent.htmldb_PageLoaded(this)">#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<htmldb:SUCCESS_MESSAGE><div id="SUCCESS_MESSAGE">#SUCCESS_MESSAGE#</div></htmldb:SUCCESS_MESSAGE>',
'<htmldb:NOTIFICATION_MESSAGE><div id="NOTIFICATION_MESSAGE">#NOTIFICATION_MESSAGE#</div></htmldb:NOTIFICATION_MESSAGE>',
'<htmldb:GLOBAL_NOTIFICATION><div id="GLOBAL_NOTIFICATION">#GLOBAL_NOTIFICATION#</div></htmldb:GLOBAL_NOTIFICATION>',
'<htmldb:REGION_POSITION_01><div id="REGION_POSITION_01">#REGION_POSITION_01#</div></htmldb:REGION_POSITION_01>',
'<htmldb:REGION_POSITION_02><div id="REGION_POSITION_02">#REGION_POSITION_02#</div></htmldb:REGION_POSITION_02>',
'<htmldb:REGION_POSITION_03><div id="REGION_POSITION_03">#REGION_POSITION_03#</div></htmldb:REGION_POSITION_03>',
'<htmldb:REGION_POSITION_04><div id="REGION_POSITION_04">#REGION_POSITION_04#</div></htmldb:REGION_POSITION_04>',
'<htmldb:REGION_POSITION_05><div id="REGION_POSITION_05">#REGION_POSITION_05#</div></htmldb:REGION_POSITION_05>',
'<htmldb:REGION_POSITION_06><div id="REGION_POSITION_06">#REGION_POSITION_06#</div></htmldb:REGION_POSITION_06>',
'<htmldb:REGION_POSITION_08><div id="REGION_POSITION_08">#REGION_POSITION_08#</div></htmldb:REGION_POSITION_08>',
'<htmldb:BOX_BODY><div id="BOX_BODY">#BODY#</div></htmldb:BOX_BODY>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>14502301802938058.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/iframe_for_object_browser_editor
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(18791925748855161.4508)
,p_theme_id=>3
,p_name=>'Iframe for Object Browser (Editor).ko'
,p_internal_name=>'IFRAME_FOR_OBJECT_BROWSER_EDITOR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'<title>#TITLE#</title><link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#</head><body class="#PAGE_CSS_CLASSES#" #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <table id="apex-page-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'      <tbody>',
'        <tr>',
'          <td class="apex-page-content" width="100%">',
'            #REGION_POSITION_02#',
'            <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>	    ',
'	      </td>',
'          <td class="apex-page-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</td>     ',
'        </tr>',
'      </tbody>',
'    </table>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#<a name="END"></a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>7803400276444840.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sql_commands_popup_to_be_deleted
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(22971005484952607.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - SQL Commands Popup (to be deleted).ko'
,p_internal_name=>'APEX_5.0_SQL_COMMANDS_POPUP_TO_BE_DELETED'
,p_is_popup=>false
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#sc/sc_slider.js',
'#IMAGE_PREFIX#sc/sc_core.js'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.jQuery(''#P1003_SQL_COMMAND1'').bind(''keydown'', function(e){',
'  sc_quickKeys(e);',
'});'))
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-Header{',
'    display: none !important;',
'}',
'.a-Breadcrumb {',
'    display: none !important;',
'}',
'',
'.a-ControlBar .a-Form-inputContainer {',
'    float: left;',
'}'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Body">',
'    <main class="a-Main">     ',
'      <table border="0" cellspacing="0"  cellpadding="0" align="center" summary="" id="SqlAndResults" width="100%">',
'        <tr>',
'          <td valign="top"><div id="scRightHeader">#REGION_POSITION_01#</div>',
'            <div id="scCommandHolder" class="d1">#REGION_POSITION_03#</div>',
'            <div id="h_slide"><br />',
'            </div>',
'            <div id="scBottomHolder">#REGION_POSITION_04#',
'              <div id="htmlTabHolder" >#REGION_POSITION_05#</div>',
'            </div></td>',
'        </tr>',
'      </table>',
'        #BODY##REGION_POSITION_02#   ',
'    </main>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>797494421544604240.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_0_left_and_right_sidebar_builder
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(30058704563508114.4508)
,p_theme_id=>3
,p_name=>'APEX 4.0 - Left And Right SideBar (Builder).ko'
,p_internal_name=>'APEX_4.0_LEFT_AND_RIGHT_SIDEBAR_BUILDER'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div id="apex-main">',
'    <div id="ContentBody">',
'      <div id="apex-two-col">',
'        <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'        <div id="apex-content">#REGION_POSITION_02#',
'          <div id="apex-splash">',
'            <div id="RP4">#REGION_POSITION_04#</div>',
'            <div id="BB">#BODY#</div>',
'          </div>',
'        </div>',
'      </div>',
'    </div>',
'    <div id="apex-left-sidebar">#REGION_POSITION_01#</div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>16
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>33514229015310264.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/done_popup
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(102479827851590823.4508)
,p_theme_id=>3
,p_name=>'(Done) Popup.ko'
,p_internal_name=>'DONE_POPUP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'    <title>#TITLE#</title>',
'    <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'    ',
'    #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="aPopupPage">',
'    <noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>#REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##BODY#</div>',
'<div style="text-align:middle;">#REGION_POSITION_08#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>19940022257958945.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/columbus_iframe_for_object_browser_editor
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(111249502165581395.4508)
,p_theme_id=>3
,p_name=>'(Columbus) Iframe for Object Browser / Editor.ko'
,p_internal_name=>'COLUMBUS_IFRAME_FOR_OBJECT_BROWSER_/_EDITOR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<title>#TITLE#</title>',
'</head>',
'<body class="apex-iframe" #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <table id="apex-page-body" width="100%" cellspacing="0" cellpadding="0" border="0" summary="">',
'      <tbody>',
'        <tr>',
'          <td class="apex-page-content" width="100%">',
'            #REGION_POSITION_02#',
'            <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>	    ',
'	      </td>',
'          <td class="apex-page-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</td>     ',
'        </tr>',
'      </tbody>',
'    </table>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#<a name="END"></a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>111241219607547888.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_popup
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(203703017586195109.4508)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Popup.ko'
,p_internal_name=>'APEX_4.2_POPUP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title><link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head><body #ONLOAD# style="padding:5px;min-width:380px;"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>',
'  <div id="RP2">#REGION_POSITION_02#</div>',
'  <div id="RP3">#REGION_POSITION_03#</div>',
'  <div id="RP4">#REGION_POSITION_04#</div>',
'  <div id="RP5">#REGION_POSITION_05#</div>',
'  <div class="popupContent" id="ContentArea">#BODY#</div>',
'</div>',
'<div id="RP8" style="text-align:middle;">#REGION_POSITION_08#</div>',
'<br />',
'<br />',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>36144306570651063.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(385762900697898960.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Right Side Bar.ko'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222.4508
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159327410235427630.4508)
,p_page_template_id=>wwv_flow_api.id(385762900697898960.4508)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159327911378427631.4508)
,p_page_template_id=>wwv_flow_api.id(385762900697898960.4508)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159328419806427631.4508)
,p_page_template_id=>wwv_flow_api.id(385762900697898960.4508)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159328980519427631.4508)
,p_page_template_id=>wwv_flow_api.id(385762900697898960.4508)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159329412517427632.4508)
,p_page_template_id=>wwv_flow_api.id(385762900697898960.4508)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159329905425427632.4508)
,p_page_template_id=>wwv_flow_api.id(385762900697898960.4508)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159330456883427632.4508)
,p_page_template_id=>wwv_flow_api.id(385762900697898960.4508)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(690782249755803171.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog.ko'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog_grid_layout
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(690782638016803186.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog (Grid Layout).ko'
,p_internal_name=>'APEX_5.0_DIALOG_GRID_LAYOUT'
,p_is_popup=>true
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE#',
'#NOTIFICATION_MESSAGE#',
'#GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'#BODY#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'#REGION_POSITION_04#',
'#REGION_POSITION_05#',
'#REGION_POSITION_06#',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'400'
,p_dialog_width=>'600'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>561572340071582364.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(690783120585803188.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Edit Screen.ko'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4508
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159332394079427634.4508)
,p_page_template_id=>wwv_flow_api.id(690783120585803188.4508)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159332873065427635.4508)
,p_page_template_id=>wwv_flow_api.id(690783120585803188.4508)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(690783685471803190.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - No Side Bar.ko'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(690784265136803192.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Dialog.ko'
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.builder.initWizardModal();',
'apex.builder.initWizardProgressBar();'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="utf-8">  ',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--wizard'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689061037088924910.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(703368619593851824.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Page.ko'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sql_workshop_iframe_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(740688669716062470.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - SQL Workshop iFrame Page.ko'
,p_internal_name=>'APEX_5.0_SQL_WORKSHOP_IFRAME_PAGE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="sql-workshop-iframe-page a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>751105067571616073.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sql_command_to_be_deleted
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(755489372405029415.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - SQL Command (to be deleted).ko'
,p_internal_name=>'APEX_5.0_SQL_COMMAND_TO_BE_DELETED'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Body">',
'    <main class="a-Main">     ',
'      <table border="0" cellspacing="0"  cellpadding="0" align="center" summary="" id="SqlAndResults" width="100%">',
'        <tr>',
'          <td valign="top"><div id="scRightHeader">#REGION_POSITION_01#</div>',
'            <div id="scCommandHolder" class="d1">#REGION_POSITION_03#</div>',
'            <div id="h_slide"><br />',
'            </div>',
'            <div id="scBottomHolder">#REGION_POSITION_04#',
'              <div id="htmlTabHolder" >#REGION_POSITION_05#</div>',
'            </div></td>',
'        </tr>',
'      </table>',
'        #BODY##REGION_POSITION_02#   ',
'    </main>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>755495306770115352.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_object_browser_to_be_deleted
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(755497120063121833.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Object Browser (to be deleted).ko'
,p_internal_name=>'APEX_5.0_OBJECT_BROWSER_TO_BE_DELETED'
,p_is_popup=>false
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.jQuery(''#P1003_SQL_COMMAND1'').bind(''keydown'', function(e){',
'  sc_quickKeys(e);',
'});'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <script src="#IMAGE_PREFIX#sw/minified/htmldb_data.min.js" type="text/javascript" defer="defer"></script>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Body">',
'    <main class="a-Main">     ',
'    <table summary="" cellpadding="0" cellspacing="0" border="0" id="obTable" style="margin:5px;">',
'      <tr>',
'        <td width="200" id="obLeftColumn" valign="top"><div id="obLeftHeader" style="border-left:none;">#REGION_POSITION_01#</div>',
'          <div id="ob_ObjectsSlider">#REGION_POSITION_03#<br />',
'          </div></td>',
'        <td id="v_slide" class="obSlideBar" valign="middle" width="2px"><span id="qbSideBartoggle" onclick="html_ToggleElement(''obLeftColumn'')"><img id="qbSideBar_toggle" src="#IMAGE_PREFIX#qb/close.png" class="htmldbPseudoButton" /></span></td>',
'        <td valign="top" class="dbaseFrameHolder" width="100%" id="dbaseFrameHolder"><table id="obRightHeader" width="100%" summary="" cellpadding="0" border="0" cellspacing="0">',
'            <tr>',
'              <td id="ob_ObjectsDetail" width="100%"><br /></td>',
'              <td>#REGION_POSITION_02#</td>',
'            </tr>',
'          </table>',
'          #REGION_POSITION_04#</td>',
'      </tr>',
'    </table>',
'        #BODY#  ',
'    </main>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>755501609832139762.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_query_builder_to_be_deleted
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(755509294845301750.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Query Builder (to be deleted).ko'
,p_internal_name=>'APEX_5.0_QUERY_BUILDER_TO_BE_DELETED'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <script src="#IMAGE_PREFIX#sw/minified/htmldb_data.min.js" type="text/javascript" defer="defer"></script>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Body">',
'    <main class="a-Main">     ',
'    <table summary="" cellpadding="0" cellspacing="0" border="0" id="qbTable" width="98%" height="70%">',
'      <tr>',
'        <td id="qbSideBar" valign="top" width="200" style="width:200px;"><div id="qbLeftHeader">#REGION_POSITION_02#</div>',
'          <div id="dbaseObjectsSlider"><br />',
'          </div></td>',
'        <td id="v_slide" class="obSlideBar" valign="middle" width="5" style="width:5px;"><span id="qbSideBartoggle" onclick="qb_toggleSideBar();"><img id="qbSideBar_toggle" src="#IMAGE_PREFIX#qb/close.png" alt="" class="htmldbPseudoButton" /></span><'
||'/td>',
'        <td valign="top" class="qbFrameHolder" id="qbFrameHolder"><div id="qbRightHeader">#REGION_POSITION_03#</div>',
'          <div id="qbTableHolder" class="d1">',
'            <div align="right">',
'              <div id="qbLinkHolder"></div>',
'            </div>',
'          </div>',
'          <div id="h_slide" onmousedown="qb_hPosition(this);">&nbsp;</div>',
'          <div id="qbBottomHolder" class="d2">#REGION_POSITION_04#',
'            <div id="htmlTabHolder" class="qbTabHolder">#REGION_POSITION_05#</div>',
'          </div></td>',
'      </tr>',
'    </table>',
'        #REGION_POSITION_01##BODY#  ',
'    </main>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_query_builder_popup_legacy_to_be_deleted
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(787616727240016897.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Query Builder Popup (Legacy to be deleted).ko'
,p_internal_name=>'APEX_5.0_QUERY_BUILDER_POPUP_LEGACY_TO_BE_DELETED'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'<script src="#IMAGE_PREFIX#sw/minified/htmldb_data.min.js" type="text/javascript"></script>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# xmlns:htmldb="http://htmldb.oracle.com"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbBreadcrumbTop"><br /></div>',
'<table class="htmldbLayout" cellpadding="0" cellspacing="0" border="0" summary="">',
'<tr>',
'<td class="htmldbBreadcrumbRegion"><br /></td>',
'<td rowspan="2" class="htmldbRunEditRegion">#REGION_POSITION_06#</td></tr>',
'<tr>',
'<td id="htmldbRunEditZag"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" width="1" height="6" /></td>',
'</tr>',
'</table>',
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<table summary="" cellpadding="0" cellspacing="0" border="0" id="qbTable" width="98%" height="70%">',
'<tr>',
'<td id="qbSideBar" valign="top" width="200" style="width:200px;"><div id="qbLeftHeader">#REGION_POSITION_02#</div><div id="dbaseObjectsSlider"><br /></div></td>',
'<td id="v_slide" class="obSlideBar" valign="middle" width="5" style="width:5px;"><span id="qbSideBartoggle" onclick="qb_toggleSideBar();"><img id="qbSideBar_toggle" src="#IMAGE_PREFIX#qb/close.png" alt="" class="htmldbPseudoButton" /></span></td>',
'<td valign="top" class="qbFrameHolder" id="qbFrameHolder"><div id="qbRightHeader">#REGION_POSITION_03#</div>',
'<div id="qbTableHolder" class="d1"><div align="right"><div id="qbLinkHolder"></div></div></div>',
'<div id="h_slide" onmousedown="qb_hPosition(this);">&nbsp;</div>',
'<div id="qbBottomHolder" class="d2">#REGION_POSITION_04#<div id="htmlTabHolder" class="qbTabHolder">#REGION_POSITION_05#</div><br /><br /></div></td>',
'</tr>',
'</table><div class="htmldbBodyMargin">#REGION_POSITION_01##BODY#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'<a name="END"><br /></a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_top_non_curr_tab_font_attr=>'class="parenttabtextoff"'
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>16
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'no longer used'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sql_commands_popup_legacy
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(797492749231600530.4508)
,p_theme_id=>3
,p_name=>'APEX 5.0 - SQL Commands Popup (Legacy).ko'
,p_internal_name=>'APEX_5.0_SQL_COMMANDS_POPUP_LEGACY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<script src="#IMAGE_PREFIX#sc/sc_slider.js" type="text/javascript"></script>',
'<script src="#IMAGE_PREFIX#sc/sc_core.js" type="text/javascript"></script>',
'<script type="text/javascript">',
'document.onkeypress  = sc_quickKeys;',
'</script>',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbBreadcrumbTop"><br /></div>',
'<table class="htmldbLayout" cellpadding="0" cellspacing="0" border="0" summary="">',
'<tr>',
'<td class="htmldbBreadcrumbRegion"><div class="htmldbBreadcrumbs"><br /></td>',
'<td rowspan="2" class="htmldbRunEditRegion">#REGION_POSITION_06#</td></tr>',
'<tr>',
'<td id="htmldbRunEditZag"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" width="1" height="6" /></td>',
'</tr>',
'</table><a name="SkipRepNav"></a><div id="htmldbMessageHolder" style="padding:0px;margin:0px;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<table border="0" cellspacing="0"  cellpadding="0" align="center" summary="" id="SqlAndResults" width="100%">',
'<tr>',
'<td valign="top">',
'<div id="scRightHeader">#REGION_POSITION_01#</div>',
'<div id="scCommandHolder" class="d1">#REGION_POSITION_03#</div>',
'<div id="h_slide"><br /></div>',
'<div id="scBottomHolder">#REGION_POSITION_04#<div id="htmlTabHolder" >#REGION_POSITION_05#</div></div>  ',
'</td>',
'</tr>',
'</table>',
'#BODY##REGION_POSITION_02#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'<a name="END"><br /></a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>13
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>23028517589370116.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_button_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(3791826543328.4508)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_BUTTON_LEGACY_APEX_5_MIGRATION'
,p_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_1_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(300313006293429763.4508)
,p_template_name=>'APEX 4.1 - Button'
,p_internal_name=>'APEX_4.1_BUTTON'
,p_template=>'<button class="aButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_hot_template=>'<button class="aButton hotButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_reference_id=>275775519061831382.4508
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="button-gray" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> ',
'',
'',
'<a href="#LINK#" class="button-orange" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> '))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(385765234519963355.4508)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4508
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(385765690470963369.4508)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4508
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(385765860428963371.4508)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4508
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(690706750701136097.4508)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233.4508
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(717395744009796543.4508)
,p_template_name=>'APEX 5.0 - Icon Badge Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><span class="a-But'
||'ton-badge"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><spa'
||'n class="a-Button-badge"></span></button>'
,p_reference_id=>631020282344854024.4508
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(717395999962796580.4508)
,p_template_name=>'APEX 5.0 - Icon Badge Menu Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_reference_id=>631020159860848910.4508
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/results_region_template
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(4569137138.4508)
,p_layout=>'TABLE'
,p_template=>'<table cellspacing="2" cellpadding="2" border="0" width="100%" bgcolor="#C5D5C5" summary="" id="#REGION_STATIC_ID#"><tr><td align=left bgcolor="#C5D5C5"><font class="regionheader" face=aria color=white>&nbsp;<h2>#TITLE#</h2></font></td><td width="1%"'
||' align="right"  bgcolor="#C5D5C5">#EXPAND#</td><td width="1%" align="right"  bgcolor="#C5D5C5">#CLOSE#</td></tr></table>#BODY#<p/>'
,p_page_plug_template_name=>'results_region_template'
,p_internal_name=>'RESULTS_REGION_TEMPLATE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>354972725853931304.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/gray_box_c_htmldbgbr_100_from_4999
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(99113673096289.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading editRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'      <a href="#" class="aIconButton" onclick="uF();return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" class="upIcon" alt="&TOP." /></a>',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Gray Box (c:htmldbGBR) (100%)  From 4999'
,p_internal_name=>'GRAY_BOX_C:HTMLDBGBR_100%_FROM_4999'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17353903289599940.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/popup_dialog
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2315729644343442.4508)
,p_layout=>'TABLE'
,p_template=>'<table style="display:none;position:absolute;background-color:#EEEEEE;border:#000000 solid 1px;padding:0px;text-align:center;font-size:12px;color:#000000;" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><tr><td class="h'
||'tmldbWizardHeader"><h2>#TITLE#</h2></td><td class="htmldbWizardHeader" align="right"><span onClick="dhtml_CloseDialog(this);"><img src="#IMAGE_PREFIX#qb/vertical_close.png" /></span></td></tr><tr><td colspan="2" class="htmldbWizardBody">#BODY#</td></'
||'tr><tr><td colspan="2" align="right">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</td></tr></table>'
,p_page_plug_template_name=>'Popup Dialog'
,p_internal_name=>'POPUP_DIALOG'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>140626130059891289.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2976007666683831.4508)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - DIV with ID and Region Attributes'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>2974803291668087.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/ppr_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(12270828624874231.4508)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#" style="clear:both;"><htmldb:PPR_#REGION_ID#>#BODY#</htmldb:PPR_#REGION_ID#></div>'
,p_page_plug_template_name=>'PPR Region'
,p_internal_name=>'PPR_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/dhtml_hidden_with_id_c_htmldbhid_from_4999
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(18711815569354247.4508)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" style="display:none;">#BODY#</div>'
,p_page_plug_template_name=>'(DHTML) Hidden with ID (c:htmldbHID) From 4999'
,p_internal_name=>'DHTML_HIDDEN_WITH_ID_C:HTMLDBHID_FROM_4999'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>18544000951303738.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/sub_tab_region_marc
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(20150627851144569.4508)
,p_layout=>'TABLE'
,p_template=>'<table width="400" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><tr><td>#BODY#</td></tr></table>'
,p_page_plug_template_name=>'sub tab region (Marc)'
,p_internal_name=>'SUB_TAB_REGION_MARC'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>354972912039931307.4508
,p_translate_this_template=>'N'
,p_template_comment=>'No region formatting'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/top_bar_white_collapsed
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(22867306215341549.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" class="top-bar" #REGION_ATTRIBUTES#><div style="float: left">#BODY#</div><div style="float: left">#CLOSE##EDIT##DELETE##CREATE##CREATE2##PREVIOUS##NEXT#</div></div>',
''))
,p_page_plug_template_name=>'Top Bar (white) (collapsed)'
,p_internal_name=>'TOP_BAR_WHITE_COLLAPSED'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>21
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>17586323272111445.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/show_hide_minimal
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(35638231141594602.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title"><h3>',
'      <a href="#" onclick="htmldb_ToggleTableBody(''i#REGION_STATIC_ID#'',''body#REGION_STATIC_ID#''); return false;">',
'        <img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" class="pseudoButtonActive" id="i#REGION_STATIC_ID#" alt="" />',
'        #TITLE#',
'      </a></h3>    ',
'    </div>',
'  </div>',
'  <div class="hide-show-body" style="display:none;" id="body#REGION_STATIC_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Show / Hide - minimal'
,p_internal_name=>'SHOW_/_HIDE_MINIMAL'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>106535103160611208.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(40570329559709427.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar '
,p_internal_name=>'APEX_4.0_TOP_BAR_'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17357218626599946.4508
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_float_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(42819301025617014.4508)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# style="float:left;clear:both;">#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div (Float Left)'
,p_internal_name=>'APEX_4.0_DIV_FLOAT_LEFT'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>35964702876463547.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(61427413413570608.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" style="width:100%">',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title"><h2>#TITLE#</h2></div>',
'    <div class="rc-buttons">#EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Report Region'
,p_internal_name=>'REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>17354512447599941.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/info_c_htmldbinfo_from_4999
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(81906901123495005.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Info (c:htmldbInfo)  From 4999'
,p_internal_name=>'INFO_C:HTMLDBINFO_FROM_4999'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/blank_wizard_region_c_htmldbbwr
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(106819925599248236.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbBWR" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_ID#">',
'<thead>',
'<tr>',
'<th class="T"><br /></th>',
'<th class="BT" valign="bottom">#CLOSE#&nbsp;&nbsp;#EDIT##DELETE#<img src="#IMAGE_PREFIX#htmldb/builder/1px_trans.gif" alt="" height="1" width="5" />#PREVIOUS##NEXT##CREATE##CREATE2#</th>',
'</tr>',
'</thead>',
'<tbody>',
'<tr>',
'<td colspan="2" class="B">#BODY#</td>',
'</tr>',
'</tbody>',
'</table>'))
,p_page_plug_template_name=>'Blank Wizard Region (c:htmldbBWR)'
,p_internal_name=>'BLANK_WIZARD_REGION_C:HTMLDBBWR'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(140310301493602560.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box'
,p_internal_name=>'WIZARD_BOX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box_success
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(156913627709610019.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion successRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box (Success)'
,p_internal_name=>'WIZARD_BOX_SUCCESS'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>149030901078827666.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box_confirm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(162408401422136243.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box (Confirm)'
,p_internal_name=>'WIZARD_BOX_CONFIRM'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(197664431770780199.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar (Gray Header)'
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(201494524216316816.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box'
,p_internal_name=>'APEX_4.0_WIZARD_BOX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(208285310117555084.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body'
,p_internal_name=>'APEX_4.2_WIZARD_BODY'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209615589242480.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body_divider
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(208285802016555084.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion dividerTop" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'<div class="wizardRegionHeading">',
'  <h1>#TITLE#</h1>',
'  <div class="buttonContainer">',
'#EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'  </div>',
'</div>',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body (Divider)'
,p_internal_name=>'APEX_4.2_WIZARD_BODY_DIVIDER'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209811475242480.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/body_and_button_positions
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(267352014896608032.4508)
,p_layout=>'TABLE'
,p_template=>'<table  cellpadding="0" cellspacing="0" border="0" summary="" class="htmldbButtonPositionsOnly" id="#REGION_STATIC_ID#"><tbody><tr><td>#BODY#</td><td style="padding-right:25px;">#CLOSE#</td><td>#PREVIOUS#</td><td>#NEXT#</td><td>#DELETE#</td><td>#CHAN'
||'GE##EDIT#</td><td>#CREATE#</td><td>#CREATE2#</td><td>#HELP#</td></tr></tbody></table>'
,p_page_plug_template_name=>'Body and Button Positions'
,p_internal_name=>'BODY_AND_BUTTON_POSITIONS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>149939626832608434.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(380771699411878611.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174748721787471587.4508
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(385770331595976651.4508)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>716895227337398760.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_hidden_heading
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(385893260111566687.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region (Hidden Heading)'
,p_internal_name=>'APEX_5.0_REGION_HIDDEN_HEADING'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>717832816842067694.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_layout_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(386079172240342588.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="u-Table #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'#BODY#',
'#SUB_REGIONS#',
'</div>'))
,p_sub_plug_template=>'<div class="u-Table-fill">#SUB_REGION#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Layout Container'
,p_internal_name=>'APEX_5.0_LAYOUT_CONTAINER'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(690697788869123307.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>687153470345619376.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(690714020036152159.4508)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(703386252988943977.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>698829239393878937.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_accordion
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717402913540820747.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUBREGIONS#',
'</div>',
'<script type="text/javascript">',
'  apex.jQuery( "#accordion" ).accordion({',
'    icons: false,',
'    header: ".a-Region-header",',
'    heightStyle: ''content'',',
'    collapsible: true',
'  });',
'</script>'))
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion-item">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Accordion'
,p_internal_name=>'APEX_5.0_ACCORDION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174746301430371105.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717403738062820750.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'      <button class="a-Button a-Button--icon a-Button--hideShow" type="button"></button>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>689955986849128825.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717413953976820775.4508)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #COMPONENT_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Page Anchors'
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17354206769599941.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717414629694820775.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-PageColumn-header">',
'    <h2 class="a-PageColumn-heading">#TITLE#</h2>',
'  </div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613223222362440.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717415310646820776.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn-body #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column (Body)'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN_BODY'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174630015632506596.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717416284652820776.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUB_REGION_HEADERS#',
'  #SUB_REGIONS#',
'</div>',
'<script type="text/javascript">',
'    $("##REGION_STATIC_ID#").tabs({',
'      create: function() {',
'        $(this).addClass(''ui-tabs--simpleInset'')',
'      }',
'    });',
'</script>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#">#SUB_REGION_TITLE#</a></li>'
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer-item" id="#SUB_REGION_ID#">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Tabs'
,p_internal_name=>'APEX_5.0_TABS'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>183211208341566300.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717416953442820777.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Toolbar-items a-Toolbar-items--left">#PREVIOUS#</div>',
'  <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar'
,p_internal_name=>'APEX_5.0_TOOLBAR'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613705533399534.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717417607324820781.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--left #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Left)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_LEFT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174628415239478085.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_right
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717418310522820781.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--right #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Right)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_RIGHT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174629130392501406.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717419046555820782.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717419707883820782.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Wizard-region a-Form #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Wizard-regionHeader">#REGION_HEADER#</div>',
'  <div class="a-Wizard-regionBody">#BODY#</div>',
'  <div class="a-Wizard-regionFooter">#REGION_FOOTER#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Region'
,p_internal_name=>'APEX_5.0_WIZARD_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>702777601713950915.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_title_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717420493098820783.4508)
,p_layout=>'TABLE'
,p_template=>'<div class="#REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#><h1 class="a-Wizard-title">#TITLE#</h1></div>'
,p_page_plug_template_name=>'APEX 5.0 - Wizard Title Region'
,p_internal_name=>'APEX_5.0_WIZARD_TITLE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>703469000349150769.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_iframe_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(737759501522573640.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--iframe #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'  <div class="a-Region-iframeButtons">',
'    <div class="a-ButtonRegion">',
'      <div class="a-ButtonRegion-wrap">',
'        <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'        <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'          <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'        </div>',
'        <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - iFrame Region'
,p_internal_name=>'APEX_5.0_IFRAME_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--paddedBody'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>737749193541531906.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(746376253838324384.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>746362351042209764.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_dialog
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1131993087623131882.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#"  class="a-DialogRegion js-regionDialog #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# style="display:none" title="#TITLE#">',
'  <div class="a-DialogRegion-body">',
'#BODY#',
'  </div>',
'  <div class="a-DialogRegion-buttons">',
'     <div class="a-ButtonRegion a-ButtonRegion--dialogRegion">',
'       <div class="a-ButtonRegion-wrap">',
'         <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'         <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'       </div>',
'     </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region Dialog'
,p_internal_name=>'APEX_5.0_REGION_DIALOG'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'js-draggable:js-modal:js-resizable'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>428597701677720079.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_nested_splitter
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1225836530715180993.4508)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="resize #REGION_CSS_CLASSES#"> ',
'#BODY#',
'<div id="#REGION_STATIC_ID#_content" class="resize">',
'#SUB_REGIONS#',
'</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Nested Splitter'
,p_internal_name=>'APEX_5.0_NESTED_SPLITTER'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>177373906751600776.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist_from_4999
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1216501287578773.4508)
,p_list_template_current=>'<div class="dhtmlMenuItem"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#htmldb/builder/menu_pulldown.png" width="32" height="84" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBott'
||'om(this,''#LIST_ITEM_ID#'',false)" alt=""/><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_list_template_noncurrent=>'<div class="dhtmlMenuItem"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#htmldb/builder/menu_pulldown.png" width="32" height="84" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBott'
||'om(this,''#LIST_ITEM_ID#'',false)" alt="" /><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_list_template_name=>'DHTML List (Image) with Sublist from 4999'
,p_internal_name=>'DHTML_LIST_IMAGE_WITH_SUBLIST_FROM_4999'
,p_theme_id=>3
,p_theme_class_id=>10
,p_list_template_before_rows=>'<div class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">',
'<li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>'))
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_reference_id=>6245728734686542.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_tabbed_navigation_list_ppr
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(11751121765920036.4508)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="javascript:ob_PPR_TAB(''#LINK#'')" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="javascript:ob_PPR_TAB(''#LINK#'')" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
'',
''))
,p_list_template_name=>'Simple Tabbed Navigation List (PPR)'
,p_internal_name=>'SIMPLE_TABBED_NAVIGATION_LIST_PPR'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbTabbedNavigationList" border="0" cellpadding="0" cellspacing="0" summary=""><tr>',
'',
''))
,p_list_template_after_rows=>'<td width="100%"><br /></td></tr></table>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_reference_id=>108849122001556988.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/dhtml_list_button_with_sublist
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(18702621564272688.4508)
,p_list_template_current=>'<li>#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" class="dList" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_list_template_name=>'DHTML List Button with Sublist'
,p_internal_name=>'DHTML_LIST_BUTTON_WITH_SUBLIST'
,p_theme_id=>3
,p_theme_class_id=>10
,p_list_template_before_rows=>'<ul class="dList">'
,p_list_template_after_rows=>'</ul>'
,p_item_templ_curr_w_child=>'<li>#TEXT#</li>'
,p_item_templ_noncurr_w_child=>'<li><a href="#LINK#" class="dList" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_reference_id=>18183125227392377.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_c_htmldbul
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(20507805987268923.4508)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'Unordered List (c:htmldbUl)'
,p_internal_name=>'UNORDERED_LIST_C:HTMLDBUL'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/flowwizard
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(23328315128356826.4508)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-wiz-current"><span>#TEXT#</span></div>',
''))
,p_list_template_noncurrent=>'<div class="apex-wiz-non"><span>#TEXT#</span></div>'
,p_list_template_name=>'FlowWizard'
,p_internal_name=>'FLOWWIZARD'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="apex-wiz-bar">'
,p_list_template_after_rows=>'</div>'
,p_between_items=>'<div class="apex-wiz-arrow"></div>'
,p_reference_id=>60218330803141060.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/columbus_object_browser_object_types
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(23673306353078906.4508)
,p_list_template_current=>'<option htmldb:type="#A01#" id="#A01#" value="#A01#" selected="selected"">#TEXT#</option>'
,p_list_template_noncurrent=>'<option htmldb:type="#A01#" id="#A01#" value="#A01#">#TEXT#</option>'
,p_list_template_name=>'(Columbus) Object Browser Object Types'
,p_internal_name=>'COLUMBUS_OBJECT_BROWSER_OBJECT_TYPES'
,p_theme_id=>3
,p_theme_class_id=>16
,p_list_template_before_rows=>'<label for="obObjectSelect" class="hideMeButHearMe">Object Type</label><select onchange="gLastTab=false;gSideBar.onchange(true);"  id="obObjectSelect" class="a-Form-select">'
,p_list_template_after_rows=>'</select>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_image_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(32427114807996970.4508)
,p_list_template_current=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_name=>'Simple Image List'
,p_internal_name=>'SIMPLE_IMAGE_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="listwithicon">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>32421627622986728.4508
,p_list_template_comment=>'<img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_omit_current
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(35432701931461853.4508)
,p_list_template_current=>' '
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_list_template_name=>'Unordered List (omit current)'
,p_internal_name=>'UNORDERED_LIST_OMIT_CURRENT'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="noIndent">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>354043718465235283.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_tabbed_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(108863608130594810.4508)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
'',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_list_template_name=>'Simple Tabbed Navigation List'
,p_internal_name=>'SIMPLE_TABBED_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbTabbedNavigationList" border="0" cellpadding="0" cellspacing="0"><tr>',
'',
''))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td width="100%"><br /></td></tr></table>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
'',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_reference_id=>108854228567566739.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/image_list_legend
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(175500817357553766.4508)
,p_list_template_current=>'<li><img src="#IMAGE_PREFIX##IMAGE#" style="margin-right:10px;" alt="" />#TEXT#</li>'
,p_list_template_noncurrent=>'<li><img src="#IMAGE_PREFIX##IMAGE#" style="margin-right:10px;" alt="" />#TEXT#</li>'
,p_list_template_name=>'Image List (Legend)'
,p_internal_name=>'IMAGE_LIST_LEGEND'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="htmldbSessionLegend">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>237858014773116158.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_region_tab_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(196867506292090262.4508)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 4.0 - Region Tab List'
,p_internal_name=>'APEX_4.0_REGION_TAB_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4508
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_pull_down_button_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(208299907447573159.4508)
,p_list_template_current=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton" type="button"><span>#TEXT#</span></button> '
,p_list_template_noncurrent=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton" type="button"><span>#TEXT#</span></button> '
,p_list_template_name=>'APEX 4.2 - Pull Down Button List'
,p_internal_name=>'APEX_4.2_PULL_DOWN_BUTTON_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<div class="rButtonContainer dhtmlMenuLGButton">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton" type="button"><span>#TEXT#</span></button> '
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" class="dhtmlMenu" type="button"><span>#TEXT#<img src="#IMAGE_PREFIX#f_spacer.gif" alt="" /></span></button> ',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
,p_reference_id=>253872418832604079.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_run_edit_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(212033724996722960.4508)
,p_list_template_current=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_noncurrent=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_name=>'APEX 4.2 - Run / Edit Bar'
,p_internal_name=>'APEX_4.2_RUN_/_EDIT_BAR'
,p_theme_id=>3
,p_theme_class_id=>3
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="aRunEditBar">',
'  <li><span class="currentPage">&PAGE. &FB_FLOW_PAGE_ID.</span></li>'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>210390516819756900.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/done_wizard_progress_sidebar_clickable
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(240152923292316768.4508)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-wiz-current">',
'  <div class="apex-wiz-top"></div>',
'  <div class="apex-wiz-body">#TEXT#</div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-wiz-non">',
'  <div class="apex-wiz-top"></div>',
'  <div class="apex-wiz-body"><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'(Done) Wizard Progress Sidebar (Clickable)'
,p_internal_name=>'DONE_WIZARD_PROGRESS_SIDEBAR_CLICKABLE'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="apex-wiz-bar">'
,p_list_template_after_rows=>'</div>'
,p_between_items=>'<div class="apex-wiz-arrow-small"></div>'
,p_reference_id=>240146817030288131.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/button_list_horizontal_c_htmldbbuttonlist
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(292458412644987596.4508)
,p_list_template_current=>'<td><a href="#LINK#" class="htmldbButtonListCurrent">#TEXT#</a></td>'
,p_list_template_noncurrent=>'<td><a href="#LINK#" class="htmldbButtonList">#TEXT#</a></td>'
,p_list_template_name=>'Button List Horizontal (c:htmldbButtonList)'
,p_internal_name=>'BUTTON_LIST_HORIZONTAL_C:HTMLDBBUTTONLIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table class="htmldbButtonList" summary="" border="0" cellpadding="0" cellspacing="3"><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_item_templ_curr_w_child=>'<td><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" width="20" height="1" /></td>'
,p_item_templ_noncurr_w_child=>'<td><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" width="20" height="1" /></td>'
,p_reference_id=>21059717155998569.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(385776082908002390.4508)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(385776364537002403.4508)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(385894774262579225.4508)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508.4508
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_pull_down_button_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(436814111820869843.4508)
,p_list_template_current=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton" type="button"><span>#TEXT#</span></button> '
,p_list_template_noncurrent=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton" type="button"><span>#TEXT#</span></button> '
,p_list_template_name=>'APEX 4.0 - Pull Down Button List'
,p_internal_name=>'APEX_4.0_PULL_DOWN_BUTTON_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<div class="rButtonContainer dhtmlMenuLGButton">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton" type="button"><span>#TEXT#</span></button> '
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" class="dhtmlMenu" type="button"><span>#TEXT#<img src="#IMAGE_PREFIX#f_spacer.gif" alt="" /></span></button> ',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
,p_reference_id=>253872418832604079.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_ob_button_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(461032606198391037.4508)
,p_list_template_current=>'<div class="list-button-c"><button onclick="#LINK#" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_list_template_noncurrent=>'<div class="list-button-nc"><button onclick="#LINK#" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_list_template_name=>'APEX 4.0 - OB Button List'
,p_internal_name=>'APEX_4.0_OB_BUTTON_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<div class="dhtmlMenuLGButton">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<div class="list-button-c-sub"><button onclick="#LINK#" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_item_templ_noncurr_w_child=>'<div class="list-button-nc-sub"><button onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
,p_reference_id=>461050507240493294.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(692727073209839891.4508)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(703372217110859571.4508)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(704358525679957526.4508)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sub_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(764029929273005392.4508)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Sub Tabs'
,p_internal_name=>'APEX_5.0_SUB_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4508
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sql_workshop_buttons_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1241653799958177324.4508)
,p_list_template_current=>'<button type="button" onclick="apex.navigation.redirect(''#LINK#'')" class="a-Button">#TEXT#</button>'
,p_list_template_noncurrent=>'<button type="button" onclick="apex.navigation.redirect(''#LINK#'')" class="a-Button">#TEXT#</button>'
,p_list_template_name=>'APEX 5.0 - SQL Workshop Buttons List'
,p_internal_name=>'APEX_5.0_SQL_WORKSHOP_BUTTONS_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-Button-list">'
,p_list_template_after_rows=>'</div>'
,p_reference_id=>1241650007443166178.4508
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard_new_ajax
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2251716882439710.4508)
,p_row_template_name=>'Standard (New Ajax)'
,p_internal_name=>'STANDARD_NEW_AJAX'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(2251716882439710.4508)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999_3
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(7082409118250737.4508)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report From 4999 (3)'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999_3'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(7082409118250737.4508)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(11028007180514315.4508)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report from 4999'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(11028007180514315.4508)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999_2
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(22095907193828478.4508)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report From 4999 (2)'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999_2'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(22095907193828478.4508)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/database_browser_trigger_body
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(33210746522512634.4508)
,p_row_template_name=>'Database Browser Trigger Body'
,p_internal_name=>'DATABASE_BROWSER_TRIGGER_BODY'
,p_row_template1=>'<pre>#TRIGGER_BODY#</pre>'
,p_row_template_before_rows=>'<table><tr><td>'
,p_row_template_after_rows=>'</td></tr></table>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>354957901800346152.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/quick_pick_list_items
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(38811532466194226.4508)
,p_row_template_name=>'quick_pick_list_items'
,p_internal_name=>'QUICK_PICK_LIST_ITEMS'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(38811532466194226.4508)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(46912117501975223.4508)
,p_row_template_name=>'APEX 4.0 - Portlet Row Template'
,p_internal_name=>'APEX_4.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/icon_report_from_4999
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(134307417931747174.4508)
,p_row_template_name=>'Icon Report From 4999'
,p_internal_name=>'ICON_REPORT_FROM_4999'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100" style="float:left;margin:10px;">',
'<tr><td align="center"><a href="#3#"><img src="#IMAGE_PREFIX##1#" title="#2#" alt="#2#" style="display:block;"/></a></td></tr>',
'<tr><td align="center"><a href="#3#" class="htmldbIconName">#4#</a></td></tr>',
'</table>',
'<br style="clear:both;" />'))
,p_row_template_condition1=>'mod (#ROWNUM#, 5) = 0'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100" style="float:left;margin:10px;">',
'<tr><td align="center"><a href="#3#"><img src="#IMAGE_PREFIX##1#" title="#2#" alt="#2#" style="display:block;"/></a></td></tr>',
'<tr><td align="center"><a href="#3#" class="htmldbIconName">#4#</a></td></tr>',
'</table>'))
,p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table class="htmldbListIconHolder" border="0" cellpadding="0" cellpadding="0" summary="">#TOP_PAGINATION#<tr><td>'
,p_row_template_after_rows=>'</td></tr>#PAGINATION#</table></htmldb:#REGION_ID#></div>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>134516716361378454.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/vertical_no_background
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(161923301611160944.4508)
,p_row_template_name=>'Vertical - No Background'
,p_internal_name=>'VERTICAL_NO_BACKGROUND'
,p_row_template1=>'<tr><th scope="row" align="right">#COLUMN_HEADER#</th><td>#COLUMN_VALUE#</td></tr>'
,p_row_template_before_rows=>'#CSV_LINK#<table class="htmldbVerticalRptPlain" summary="#REGION_TITLE#" cellpadding="0" cellspacing="0" border="0">'
,p_row_template_after_rows=>'</table>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>172647727246303349.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(161923301611160944.4508)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/no_background
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(165449703104678078.4508)
,p_row_template_name=>'No Background'
,p_internal_name=>'NO_BACKGROUND'
,p_row_template1=>'<td#ALIGNMENT# id="td#ROWNUM#_#COLNUM#" headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" class="htmldbRptNoBackground" summary="#REGION_TITLE#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>237868603542157245.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(165449703104678078.4508)
,p_row_template_before_first=>'<tr id="row#ROWNUM#">'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(171907206171165798.4508)
,p_row_template_name=>'APEX 4.0 - Portlet Column Template'
,p_internal_name=>'APEX_4.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/automatic_ppr_no_background
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(172773906323382535.4508)
,p_row_template_name=>'Automatic PPR - No Background'
,p_internal_name=>'AUTOMATIC_PPR_NO_BACKGROUND'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="htmldbRptNoBackHoriz"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>172923115706660192.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(172773906323382535.4508)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(385896719135645040.4508)
,p_row_template_name=>'APEX 5.0 - Badge List'
,p_internal_name=>'APEX_5.0_BADGE_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_date_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(386075171368129866.4508)
,p_row_template_name=>'APEX 5.0 - Date List'
,p_internal_name=>'APEX_5.0_DATE_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="a-DateList-item">',
'    <div class="a-MediaBlock">',
'      <div class="a-MediaBlock-graphic">',
'        <span class="a-DateList-date">',
'          <span class="a-DateList-day">#DAY#</span>',
'          <span class="a-DateList-month">#MONTH#</span>',
'        </span>',
'      </div>',
'      <div class="a-MediaBlock-content">',
'        <span class="a-DateList-desc">#TEXT#</span>',
'        <span class="a-DateList-attribute">#CREATED_BY#</span>',
'        <span class="a-DateList-attribute">#CREATED_ON#</span>',
'      </div>',
'    </div>',
'  </li>'))
,p_row_template_before_rows=>'<ul class="a-DateList">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(617728329737082310.4508)
,p_row_template_name=>'APEX 4.0 - Standard Report'
,p_internal_name=>'APEX_4.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(617728329737082310.4508)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_named_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(717423775712828084.4508)
,p_row_template_name=>'APEX 5.0 - Badge List (Named Column)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_NAMED_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(717432943772828094.4508)
,p_row_template_name=>'APEX 5.0 - Badge List (Row)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
'  <span class="t-BadgeList-label">#1#</span>',
'  <span class="t-BadgeList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>6
,p_reference_id=>689060248369886348.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(717433602632828095.4508)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(717433602632828095.4508)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(717436155076828097.4508)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(717436155076828097.4508)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_vertical_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1127586271702515372.4508)
,p_row_template_name=>'APEX 5.0 - Vertical Report'
,p_internal_name=>'APEX_5.0_VERTICAL_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr>',
'  <td class="a-Report-cell a-Report-cell--header" scope="row">#COLUMN_HEADER#</td>',
'  <td class="a-Report-cell">#COLUMN_VALUE#</td>',
'</tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report a-Report--vertical a-Report--staticRowColors #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" summary="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>1126924627125205941.4508
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1127586271702515372.4508)
,p_row_template_before_first=>' '
,p_row_template_after_last=>' '
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1340556612002171029.4508)
,p_row_template_name=>'APEX 5.0 - Portlet Column Template'
,p_internal_name=>'APEX_5.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1340557295961171098.4508)
,p_row_template_name=>'APEX 5.0 - Portlet Row Template'
,p_internal_name=>'APEX_5.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(3301520602864636.4508)
,p_template_name=>'FormField_Optional'
,p_internal_name=>'FORMFIELD_OPTIONAL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17388415351892041.4508
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_required
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(3301625476864638.4508)
,p_template_name=>'FormField_Required'
,p_internal_name=>'FORMFIELD_REQUIRED'
,p_template_body1=>'<em>*</em><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aRequired"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>' <span class="hideMeButHearMe">(#VALUE_REQUIRED#)</span></a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>2
,p_reference_id=>17388508175892042.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/label_tag_only
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(4904018598976684.4508)
,p_template_name=>'LABEL Tag Only'
,p_internal_name=>'LABEL_TAG_ONLY'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(6693608793786901.4508)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional_w_o_popup
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(12399821819620115.4508)
,p_template_name=>'FormField_Optional w/o popup'
,p_internal_name=>'FORMFIELD_OPTIONAL_W/O_POPUP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><span class="htmldbLabelOptional">'
,p_template_body2=>'</span></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>238114715839717766.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/htmldb_greenarealabel_c_htmldbgalabel
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(187652405321922937.4508)
,p_template_name=>'htmldb_GreenAreaLabel (c:htmldbGALabel)'
,p_internal_name=>'HTMLDB_GREENAREALABEL_C:HTMLDBGALABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_4_0_top_bar_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(197619827652543551.4508)
,p_template_name=>'APEX 4.0 - Top Bar Label'
,p_internal_name=>'APEX_4.0_TOP_BAR_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(488671029226029669.4508)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487444299516703815.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(488671190365029680.4508)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487443659585685414.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(492677255463052067.4508)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492676964457041934.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(492677350674053149.4508)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492677038682043223.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_dynamic_attribute
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(717397080423801376.4508)
,p_template_name=>'APEX 5.0 - Dynamic Attribute'
,p_internal_name=>'APEX_5.0_DYNAMIC_ATTRIBUTE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-dynamicItemHelp" data-itemname="#CURRENT_ITEM_NAME#" data-appid="&FB_FLOW_ID." title="" aria-label="" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span>'
||'</button>#ERROR_TEMPLATE#</div>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>692681574974429799.4508
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(717397144393801382.4508)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>687907221148719616.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(6698104029693013.4508)
,p_name=>'breadcrumbs'
,p_internal_name=>'BREADCRUMBS'
,p_current_page_option=>'<span class="htmldbBreadcrumb">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#" class="htmldbBreadcrumb" title="#NAME#">#NAME#</a>'
,p_between_levels=>'<span class="htmldbBreadcrumbSep"><img alt="" src="#IMAGE_PREFIX#apex/apex_top_sep.gif"></span>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>60115300853820165.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(387975456606606350.4508)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>689285808648404711.4508
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(12797101143975616.4508)
,p_page_name=>'winlov'
,p_page_title=>unistr('\AC80\C0C9 \B300\D654\C0C1\C790')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>unistr('\AC80\C0C9')
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>unistr('\B2EB\AE30')
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>unistr('\B2E4\C74C &gt;')
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>unistr('&lt; \C774\C804')
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>unistr('<div class="a-PopupLOV-pagination">\D589 #FIRST_ROW# - #LAST_ROW#</div>')
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17343114994581872.4508
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/basic_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(11334530416692434.4508)
,p_cal_template_name=>'Basic Calendar'
,p_internal_name=>'BASIC_CALENDAR'
,p_day_of_week_format=>'<th scope="col">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation">',
' <tr>',
'   <td align="center" style="font-weight:bold;">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="1" cellpadding="1" cellspacing="1" summary="0">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div>#DD#</div><br />'
,p_day_open_format=>'<td valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" bgcolor="#d3d3d3">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div>#DD#</div>'
,p_weekend_open_format=>'<td valign="top">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div>#DD#</div>'
,p_nonday_open_format=>'<td valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(72332249557526712.4508)
,p_theme_id=>3
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(204023927913767476.4508)
,p_theme_id=>3
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689635167517993971.4508)
,p_theme_id=>3
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689636107671993973.4508)
,p_theme_id=>3
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689636807321993973.4508)
,p_theme_id=>3
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689638757932993974.4508)
,p_theme_id=>3
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(692727409810839893.4508)
,p_theme_id=>3
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(696624360683145458.4508)
,p_theme_id=>3
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697239665711708855.4508)
,p_theme_id=>3
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698688432545187815.4508)
,p_theme_id=>3
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698689189405187817.4508)
,p_theme_id=>3
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698689890777187817.4508)
,p_theme_id=>3
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698691450870187818.4508)
,p_theme_id=>3
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717406084452820762.4508)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717424165974828087.4508)
,p_theme_id=>3
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717426618396828089.4508)
,p_theme_id=>3
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746376625117324389.4508)
,p_theme_id=>3
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746420691677405750.4508)
,p_theme_id=>3
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746421932096405751.4508)
,p_theme_id=>3
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746422298476405751.4508)
,p_theme_id=>3
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746422550773405751.4508)
,p_theme_id=>3
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746423628537405752.4508)
,p_theme_id=>3
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746423916240405752.4508)
,p_theme_id=>3
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746424218274405754.4508)
,p_theme_id=>3
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746424531468405755.4508)
,p_theme_id=>3
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746424813431405755.4508)
,p_theme_id=>3
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746425349736405755.4508)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746425674061405755.4508)
,p_theme_id=>3
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1141459524801402371.4508)
,p_theme_id=>3
,p_name=>'DIALOG_SIZE'
,p_display_name=>'Dialog Size'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Predefined dialog sizes'
,p_null_text=>'Default Size'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755319348318018349.4508)
,p_theme_id=>3
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746376253838324384.4508)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755319458208018350.4508)
,p_theme_id=>3
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746376253838324384.4508)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755319634177018356.4508)
,p_theme_id=>3
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746376253838324384.4508)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_api.id(746376625117324389)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755319862500018356.4508)
,p_theme_id=>3
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746376253838324384.4508)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_api.id(746376625117324389)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755320072547018357.4508)
,p_theme_id=>3
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746376253838324384.4508)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_api.id(746376625117324389)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755320288486018357.4508)
,p_theme_id=>3
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746376253838324384.4508)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(717406084452820762)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755320416910018357.4508)
,p_theme_id=>3
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746376253838324384.4508)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_api.id(717406084452820762)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755320549428018357.4508)
,p_theme_id=>3
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746376253838324384.4508)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755320725444018357.4508)
,p_theme_id=>3
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746376253838324384.4508)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_api.id(746376625117324389)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755321011331018360.4508)
,p_theme_id=>3
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690697788869123307.4508)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755321262415018361.4508)
,p_theme_id=>3
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690697788869123307.4508)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(689636807321993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755321430113018361.4508)
,p_theme_id=>3
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690697788869123307.4508)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(689636807321993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755321650581018361.4508)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690697788869123307.4508)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755321826695018361.4508)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690697788869123307.4508)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755321997452018361.4508)
,p_theme_id=>3
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690697788869123307.4508)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755322169222018361.4508)
,p_theme_id=>3
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690697788869123307.4508)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_api.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755322393600018361.4508)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690697788869123307.4508)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_api.id(696624360683145458)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755334063275018373.4508)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(737759501522573640.4508)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755334236254018373.4508)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(737759501522573640.4508)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755334469839018373.4508)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(737759501522573640.4508)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755334699540018373.4508)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(737759501522573640.4508)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755334871937018373.4508)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(737759501522573640.4508)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755335024214018375.4508)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(737759501522573640.4508)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755335244855018375.4508)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(737759501522573640.4508)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755343697621018390.4508)
,p_theme_id=>3
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755343852274018390.4508)
,p_theme_id=>3
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755344085264018390.4508)
,p_theme_id=>3
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755344293879018390.4508)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_api.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755344447099018391.4508)
,p_theme_id=>3
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755344602370018391.4508)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_api.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755344861153018391.4508)
,p_theme_id=>3
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755345020387018391.4508)
,p_theme_id=>3
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755345249021018391.4508)
,p_theme_id=>3
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755345413694018391.4508)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755345686664018391.4508)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755345836994018391.4508)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755346057787018391.4508)
,p_theme_id=>3
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(385896719135645040.4508)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755346536605018392.4508)
,p_theme_id=>3
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755346771517018392.4508)
,p_theme_id=>3
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755346908516018392.4508)
,p_theme_id=>3
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755347127238018393.4508)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_api.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755347387178018393.4508)
,p_theme_id=>3
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755347523204018393.4508)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_api.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755347707352018393.4508)
,p_theme_id=>3
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755347942333018393.4508)
,p_theme_id=>3
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(717426618396828089)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755348111386018393.4508)
,p_theme_id=>3
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755348302485018394.4508)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755348557394018394.4508)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755348717973018394.4508)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755348979659018394.4508)
,p_theme_id=>3
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717423775712828084.4508)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(717424165974828087)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755359739129018410.4508)
,p_theme_id=>3
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692727073209839891.4508)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(692727409810839893)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755359935524018410.4508)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692727073209839891.4508)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(692727409810839893)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755360139586018410.4508)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692727073209839891.4508)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(692727409810839893)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755360307757018410.4508)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692727073209839891.4508)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(692727409810839893)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755360503097018411.4508)
,p_theme_id=>3
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692727073209839891.4508)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(692727409810839893)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755360682997018411.4508)
,p_theme_id=>3
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692727073209839891.4508)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755360717790018411.4508)
,p_theme_id=>3
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692727073209839891.4508)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755360835509018411.4508)
,p_theme_id=>3
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692727073209839891.4508)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755360943590018411.4508)
,p_theme_id=>3
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692727073209839891.4508)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755361040145018411.4508)
,p_theme_id=>3
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692727073209839891.4508)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755367926644019886.4508)
,p_theme_id=>3
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(746424531468405755)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755368131371019886.4508)
,p_theme_id=>3
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_api.id(746424813431405755)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755368316248019887.4508)
,p_theme_id=>3
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746425349736405755)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755368553370019887.4508)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_api.id(746424218274405754)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755368735312019887.4508)
,p_theme_id=>3
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_api.id(746424531468405755)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755368927938019887.4508)
,p_theme_id=>3
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_api.id(746424813431405755)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755369189057019887.4508)
,p_theme_id=>3
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_api.id(746422550773405751)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755369395951019887.4508)
,p_theme_id=>3
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(746422550773405751)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755369570087019887.4508)
,p_theme_id=>3
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_api.id(746422550773405751)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755369737564019889.4508)
,p_theme_id=>3
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_api.id(746425674061405755)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755369838791019889.4508)
,p_theme_id=>3
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755370076039019889.4508)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_api.id(746424218274405754)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755370120514019889.4508)
,p_theme_id=>3
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755370393151019889.4508)
,p_theme_id=>3
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_api.id(746422298476405751)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755370562593019889.4508)
,p_theme_id=>3
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_api.id(746422298476405751)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755370786398019889.4508)
,p_theme_id=>3
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(746423916240405752)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755370945815019890.4508)
,p_theme_id=>3
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(746421932096405751)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755371117542019890.4508)
,p_theme_id=>3
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_api.id(746423628537405752)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755371211932019890.4508)
,p_theme_id=>3
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755371447167019890.4508)
,p_theme_id=>3
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_api.id(746422298476405751)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755371663537019890.4508)
,p_theme_id=>3
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_api.id(746422298476405751)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755371848184019890.4508)
,p_theme_id=>3
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_api.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755372020903019890.4508)
,p_theme_id=>3
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_api.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755372233442019890.4508)
,p_theme_id=>3
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_api.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755372416975019890.4508)
,p_theme_id=>3
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_api.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755372687978019890.4508)
,p_theme_id=>3
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_api.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(755372807853019891.4508)
,p_theme_id=>3
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_api.id(746420691677405750)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787117311043949716.4508)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2251716882439710.4508)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(698688432545187815)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787117583690949716.4508)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2251716882439710.4508)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(698689189405187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787117782882949716.4508)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2251716882439710.4508)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787117993065949716.4508)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2251716882439710.4508)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787118109139949716.4508)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2251716882439710.4508)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787118210367949716.4508)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2251716882439710.4508)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787118446447949717.4508)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2251716882439710.4508)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(698691450870187818)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787118999001949718.4508)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(617728329737082310.4508)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(698688432545187815)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787119198364949718.4508)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(617728329737082310.4508)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(698689189405187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787119375234949718.4508)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(617728329737082310.4508)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787119542567949718.4508)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(617728329737082310.4508)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787119713399949718.4508)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(617728329737082310.4508)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787119853489949718.4508)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(617728329737082310.4508)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787120018395949718.4508)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(617728329737082310.4508)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(698691450870187818)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787133502775949747.4508)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717436155076828097.4508)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(698688432545187815)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787133742911949747.4508)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717436155076828097.4508)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(698689189405187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787133937296949747.4508)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717436155076828097.4508)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787134188912949747.4508)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717436155076828097.4508)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787134324612949747.4508)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717436155076828097.4508)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787134433950949747.4508)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717436155076828097.4508)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787134647594949747.4508)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717436155076828097.4508)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(698691450870187818)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926399273702707533.4508)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(385776364537002403.4508)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926399333093707533.4508)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(385776364537002403.4508)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(940697553666341585.4508)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(703372217110859571.4508)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1131768309924193980.4508)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1127586271702515372.4508)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(698689189405187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1131768523123193980.4508)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1127586271702515372.4508)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1131768627575193980.4508)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1127586271702515372.4508)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1131768874640193981.4508)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1127586271702515372.4508)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1131769045921193981.4508)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1127586271702515372.4508)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(698691450870187818)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1131769275377193981.4508)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1127586271702515372.4508)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(698689890777187817)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1199561355394032423.4508)
,p_theme_id=>3
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(690706750701136097.4508)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746425349736405755)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1445975050737085430.4508)
,p_theme_id=>3
,p_name=>'RESIZABLE'
,p_display_name=>'Resizable'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(1131993087623131882.4508)
,p_css_classes=>'js-resizable'
,p_template_types=>'REGION'
,p_help_text=>'Allow dialog to be resized.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1445975135241085430.4508)
,p_theme_id=>3
,p_name=>'DRAGGABLE'
,p_display_name=>'Draggable'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1131993087623131882.4508)
,p_css_classes=>'js-draggable'
,p_template_types=>'REGION'
,p_help_text=>'Allow dialog to be moved.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1445975358746085430.4508)
,p_theme_id=>3
,p_name=>'SMALL_480X320'
,p_display_name=>'Small (480x320)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1131993087623131882.4508)
,p_css_classes=>'js-dialog-size480x320'
,p_group_id=>wwv_flow_api.id(1141459524801402371)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1445975518111085431.4508)
,p_theme_id=>3
,p_name=>'LARGE_720X480'
,p_display_name=>'Large (720x480)'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_api.id(1131993087623131882.4508)
,p_css_classes=>'js-dialog-size720x480'
,p_group_id=>wwv_flow_api.id(1141459524801402371)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1445975704313085431.4508)
,p_theme_id=>3
,p_name=>'MEDIUM_600X400'
,p_display_name=>'Medium (600x400)'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(1131993087623131882.4508)
,p_css_classes=>'js-dialog-size600x400'
,p_group_id=>wwv_flow_api.id(1141459524801402371)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1445975835000085431.4508)
,p_theme_id=>3
,p_name=>'MODAL'
,p_display_name=>'Modal'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_api.id(1131993087623131882.4508)
,p_css_classes=>'js-modal'
,p_template_types=>'REGION'
,p_help_text=>'Display as modal.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525655309965182076.4508)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(20507805987268923.4508)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525655479052182076.4508)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(20507805987268923.4508)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525655500963182076.4508)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(20507805987268923.4508)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525655616409182076.4508)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(20507805987268923.4508)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525655890890182076.4508)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(20507805987268923.4508)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(697239665711708855)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525656046318182076.4508)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(20507805987268923.4508)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(697239665711708855)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525667568855182133.4508)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(704358525679957526.4508)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525667694538182133.4508)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(704358525679957526.4508)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525667713426182133.4508)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(704358525679957526.4508)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525667858315182133.4508)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(704358525679957526.4508)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525668042336182133.4508)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(704358525679957526.4508)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(697239665711708855)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525668231424182134.4508)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(704358525679957526.4508)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(697239665711708855)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544815603312477990.4508)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(38811532466194226.4508)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544815753448477990.4508)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(38811532466194226.4508)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544815884959477990.4508)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(38811532466194226.4508)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544818837483478024.4508)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717433602632828095.4508)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544818973917478024.4508)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717433602632828095.4508)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544819035865478024.4508)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717433602632828095.4508)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554812770773408377.4508)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554812985067408377.4508)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554813151047408377.4508)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554813301944408378.4508)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554813525412408378.4508)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(689636107671993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554813730587408378.4508)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(689636807321993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554813933522408378.4508)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554814137047408378.4508)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554814391152408378.4508)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554814467842408378.4508)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554814632627408378.4508)
,p_theme_id=>3
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(380771699411878611.4508)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(689636807321993973)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554831633096526796.4508)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(690714020036152159.4508)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554831701564526797.4508)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690714020036152159.4508)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554831806774526797.4508)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690714020036152159.4508)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554846967207542276.4508)
,p_theme_id=>3
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717403738062820750.4508)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554847055162542276.4508)
,p_theme_id=>3
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717403738062820750.4508)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554847272590542276.4508)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717403738062820750.4508)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554847450067542276.4508)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717403738062820750.4508)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554847672581542276.4508)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717403738062820750.4508)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(689636107671993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554847887758542276.4508)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717403738062820750.4508)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(689636807321993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554848073675542277.4508)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717403738062820750.4508)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554848294732542277.4508)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717403738062820750.4508)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554848424496542277.4508)
,p_theme_id=>3
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_api.id(717403738062820750.4508)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(717406084452820762)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554848666729542278.4508)
,p_theme_id=>3
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717403738062820750.4508)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(717406084452820762)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554862320208550802.4508)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(703386252988943977.4508)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554862544640550802.4508)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(703386252988943977.4508)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554862741972550802.4508)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(703386252988943977.4508)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554862983266550802.4508)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(703386252988943977.4508)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(689636807321993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554863120634550802.4508)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(703386252988943977.4508)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554863336092550802.4508)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(703386252988943977.4508)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(696624360683145458)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554863545945550802.4508)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(703386252988943977.4508)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554863760759550802.4508)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(703386252988943977.4508)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689638757932993974)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554863920638550802.4508)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(703386252988943977.4508)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(689636107671993973)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554864134947550802.4508)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(703386252988943977.4508)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(689635167517993971)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(140211619632429750.4508)
,p_build_option_name=>'SQL Command Processor Transactions'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'within the SQL command processor; ability to run in a transactional mode. ',
'',
'Uses DBMS_JOBS to maintain session state over multiple pages views / statements within a transaction.'))
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(140265918963157648.4508)
,p_build_option_name=>'Database Monitoring'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'monitor sessions',
'view SQL',
'view tablespace information',
'view data files',
'trace sessions',
''))
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(240237502901130926.4508)
,p_build_option_name=>'Create Synonym Wizard'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>'Show or suppress the create synonym wizard'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(240247031763163202.4508)
,p_build_option_name=>'Create MView Wizard'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>'Show or suppress create materialized view wizard'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(256109433659228165.4508)
,p_build_option_name=>'Object REST Enablement'
,p_build_option_status=>'INCLUDE'
,p_default_on_export=>'INCLUDE'
,p_build_option_comment=>'This is being used to hide REST Enablement features in the Object Browser.'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(693462110571635991.4508)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(1080926199001296276.4508)
,p_build_option_name=>'Commented Out'
,p_build_option_status=>'EXCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(1694682434415493288.4508)
,p_build_option_name=>'BUILDER_AUTH_SSO'
,p_build_option_status=>'INCLUDE'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286560300200876959)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2EB\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286558805732876957)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC3E\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286560451616876959)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\CC3E\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286558716859876957)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'ko'
,p_message_text=>unistr('\B2E4\C74C \CC3E\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286558686643876957)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'ko'
,p_message_text=>unistr('\C774\C804 \CC3E\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286559921581876958)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'ko'
,p_message_text=>unistr('\C790\B3D9 \C644\C131')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286559542368876958)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B4E4\C5EC\C4F0\AE30 \D06C\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286559308525876958)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0ED\C744 \ACF5\BC31\C73C\B85C \C785\B825')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286560104817876958)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'ko'
,p_message_text=>unistr('\B300\C18C\BB38\C790 \AD6C\BD84')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286560203219876958)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'ko'
,p_message_text=>unistr('\C815\ADDC \D45C\D604\C2DD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286560941135876959)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_language=>'ko'
,p_message_text=>unistr('\C9C8\C758 \C791\C131\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286558452225876957)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C7AC\C2E4\D589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286558516890876957)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\AFB8\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286560684949876959)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'ko'
,p_message_text=>unistr('\BAA8\B450 \BC14\AFB8\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286560570244876959)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'ko'
,p_message_text=>unistr('\BC14\AFB8\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286560711235876959)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC74\B108\B6F0\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286559047724876958)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'ko'
,p_message_text=>unistr('\C124\C815')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286558958718876958)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'ko'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286559210981876958)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D589 \BC88\D638 \D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286560097919876958)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'ko'
,p_message_text=>unistr('\B208\AE08\C790 \D45C\C2DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286559437601876958)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'ko'
,p_message_text=>unistr('\D0ED \D06C\AE30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286559679343876958)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\B9C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286558346038876957)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'ko'
,p_message_text=>unistr('\C2E4\D589 \CDE8\C18C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286559173083876958)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'ko'
,p_message_text=>unistr('\C77C\BC18 \D14D\C2A4\D2B8 \D3B8\C9D1\AE30 \C0AC\C6A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286559836413876958)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C99D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286559755924876958)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'ko'
,p_message_text=>unistr('\AC80\C99D \C131\ACF5')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286558262820876957)
,p_name=>'GATHER_TABLE_STATS'
,p_message_language=>'ko'
,p_message_text=>unistr('\D14C\C774\BE14 \D1B5\ACC4 \C218\C9D1')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286560875779876959)
,p_name=>'SCRIPTS.CHANGES_SAVED'
,p_message_language=>'ko'
,p_message_text=>unistr('\BCC0\ACBD\C0AC\D56D \C800\C7A5\B428')
,p_is_js_message=>true
);
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/rename_script_name
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(32179615812392135.4508)
,p_shortcut_name=>'RENAME_SCRIPT_NAME'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\C774 \C2A4\D06C\B9BD\D2B8 \C774\B984\C740 \C791\C5C5\C601\C5ED\C5D0 \C874\C7AC\D558\BA70 \B2E4\B978 \C0AC\C6A9\C790\AC00 \C18C\C720\D558\ACE0 \C788\C2B5\B2C8\B2E4. \B2E4\B978 \C2A4\D06C\B9BD\D2B8 \C774\B984\C744 \C785\B825\D558\C2ED\C2DC\C624.')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/invalid_script_name
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(110796504497651817.4508)
,p_shortcut_name=>'INVALID_SCRIPT_NAME'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\C2A4\D06C\B9BD\D2B8 \C774\B984\C5D0\B294 \C608\C57D\B41C \BB38\C790\AC00 \D3EC\D568\B420 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/null_script_name
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(110802131425678586.4508)
,p_shortcut_name=>'NULL_SCRIPT_NAME'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\C2A4\D06C\B9BD\D2B8 \C774\B984\C744 \C9C0\C815\D574\C57C \D569\B2C8\B2E4.')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/null_script
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(110803013894682985.4508)
,p_shortcut_name=>'NULL_SCRIPT'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\C2A4\D06C\B9BD\D2B8\B97C \C785\B825\D574\C57C \D569\B2C8\B2E4.')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/dup_script_name
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(111043910462526159.4508)
,p_shortcut_name=>'DUP_SCRIPT_NAME'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\C774 \C2A4\D06C\B9BD\D2B8 \C774\B984\C740 \C791\C5C5\C601\C5ED\C5D0 \C874\C7AC\D569\B2C8\B2E4.')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/max_script_size
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(133393615560571789.4508)
,p_shortcut_name=>'MAX_SCRIPT_SIZE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\C2A4\D06C\B9BD\D2B8\AC00 \D5C8\C6A9\B418\B294 \CD5C\B300 \D06C\AE30\B97C \CD08\ACFC\D569\B2C8\B2E4.')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(165162327257300666.4508)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\C774 \C0AD\C81C \C791\C5C5\C744 \C218\D589\D558\ACA0\C2B5\B2C8\AE4C?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(180175522684124268.4508)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\C774 \D398\C774\C9C0\B97C \C800\C7A5\D558\C9C0 \C54A\C740 \CC44 \C885\B8CC\D558\ACA0\C2B5\B2C8\AE4C?')
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(539837904309662819.4508)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040.4508
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(12506617921221692.4508)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>unistr('\AC1C\BC1C\C790 \AD8C\D55C \BD80\C5EC')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494.4508
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(786875795663512856.4508)
,p_plugin_id=>wwv_flow_api.id(12506617921221692.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786876196431512856.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786876649672512856.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786877151940512857.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786877643691512861.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786878110632512861.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786878657028512862.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786879162813512862.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786879626998512862.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786880113383512862.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786880600303512863.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786881171862512863.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786881666110512863.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(786875795663512856.4508)
,p_display_sequence=>120
,p_display_value=>'PKG_APPS: Ability to install packaged applications'
,p_return_value=>'PKG_APPS'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_plugin_dynamic_attribute
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(12964533458812939.4508)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_display_name=>unistr('\D50C\B7EC\ADF8\C778 \B3D9\C801 \C18D\C131')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_plugin_attribute'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_plugin_attribute'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:SOURCE'
,p_substitute_attributes=>true
,p_reference_id=>6480508142096556.4508
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_searchbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(61354658999430857.4508)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.SEARCHBOX'
,p_display_name=>unistr('\AC80\C0C9 \C0C1\C790')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.SEARCHBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_searchbox'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT'
,p_substitute_attributes=>true
,p_reference_id=>42609120788689442.4508
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513166384709230023.4508)
,p_plugin_id=>wwv_flow_api.id(61354658999430857.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Redirect URL'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:<target page>:&SESSION.::&DEBUG.::<target item>:'
,p_display_length=>80
,p_max_length=>4000
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513166776921230023.4508)
,p_plugin_id=>wwv_flow_api.id(61354658999430857.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Search Text'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Search'
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
''))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(113746032581665431.4508)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>unistr('Apex \C778\C99D')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425.4508
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(118578616481923799.4508)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>unistr('INTERNAL \C18C\C15C \C0AC\C778\C778')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086.4508
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118578892816923800.4508)
,p_plugin_id=>wwv_flow_api.id(118578616481923799.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118580745188923801.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(118578892816923800.4508)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118579262332923800.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(118578892816923800.4508)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118579782328923800.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(118578892816923800.4508)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118580293505923800.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(118578892816923800.4508)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118581273501923801.4508)
,p_plugin_id=>wwv_flow_api.id(118578616481923799.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118578892816923800.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118581674336923801.4508)
,p_plugin_id=>wwv_flow_api.id(118578616481923799.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118578892816923800.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118582080353923801.4508)
,p_plugin_id=>wwv_flow_api.id(118578616481923799.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118578892816923800.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118582487799923801.4508)
,p_plugin_id=>wwv_flow_api.id(118578616481923799.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118578892816923800.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118582869337923802.4508)
,p_plugin_id=>wwv_flow_api.id(118578616481923799.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Application Express automatically adds the "openid" scope. The authent'
||'ication provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118583272574923802.4508)
,p_plugin_id=>wwv_flow_api.id(118578616481923799.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118583617472923803.4508)
,p_plugin_id=>wwv_flow_api.id(118578616481923799.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118584024098923804.4508)
,p_plugin_id=>wwv_flow_api.id(118578616481923799.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_wizard_selection
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(217679430964254738.4508)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.WIZARD_SELECTION'
,p_display_name=>unistr('\B9C8\BC95\C0AC \C120\D0DD')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.WIZARD_SELECTION'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_wizard_selection'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_wizard_selection'
,p_standard_attributes=>'VISIBLE:SESSION_STATE:SOURCE:ELEMENT:LOV:CASCADING_LOV'
,p_substitute_attributes=>true
,p_reference_id=>3260301366184169092.4508
,p_subscribe_plugin_settings=>true
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(217679670985254744.4508)
,p_plugin_id=>wwv_flow_api.id(217679430964254738.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Icon Size'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'S'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(217680058170254749.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(217679670985254744.4508)
,p_display_sequence=>10
,p_display_value=>'Small'
,p_return_value=>'S'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(217680572057254752.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(217679670985254744.4508)
,p_display_sequence=>20
,p_display_value=>'Medium'
,p_return_value=>'M'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(217681055305254752.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(217679670985254744.4508)
,p_display_sequence=>30
,p_display_value=>'Large'
,p_return_value=>'L'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(217681523143254753.4508)
,p_plugin_id=>wwv_flow_api.id(217679430964254738.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Submit Page'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
,p_help_text=>'Select whether or not to submit the page when making a selection'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(217681920100254757.4508)
,p_plugin_id=>wwv_flow_api.id(217679430964254738.4508)
,p_name=>'LOV'
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356673325634447685.4508)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>unistr('INTERNAL Oracle Cloud ID \AD00\B9AC')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749806821809026.4508
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356675826982447689.4508)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>unistr('INTERNAL \B370\C774\D130\BCA0\C774\C2A4 \ACC4\C815')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749511183746276.4508
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356690631776447712.4508)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>unistr('INTERNAL HTTP \D5E4\B354 \BCC0\C218')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>708795120396802284.4508
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356690821640447712.4508)
,p_plugin_id=>wwv_flow_api.id(356690631776447712.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356691223596447712.4508)
,p_plugin_id=>wwv_flow_api.id(356690631776447712.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356691607645447712.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356691223596447712.4508)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356692129296447713.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356691223596447712.4508)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356692605304447713.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356691223596447712.4508)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356693129128447713.4508)
,p_plugin_id=>wwv_flow_api.id(356690631776447712.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356691223596447712.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>',
'<p>',
'<h3>Example:</h3>',
'<pre>http://sso.mycompany.com/?success=#CALLBACK#</pre>',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356693511794447713.4508)
,p_plugin_id=>wwv_flow_api.id(356690631776447712.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(356691223596447712.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356693911830447713.4508)
,p_plugin_id=>wwv_flow_api.id(356690631776447712.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356691223596447712.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'BUILTIN_URL,URL'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356694327564447713.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356693911830447713.4508)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356694806723447714.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356693911830447713.4508)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356695301839447714.4508)
,p_plugin_id=>wwv_flow_api.id(356690631776447712.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356758608092447765.4508)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>unistr('INTERNAL LDAP \B514\B809\D1A0\B9AC')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>863910941135523528.4508
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\B85C\ADF8\C778 \D398\C774\C9C0\C5D0\C11C \C2DD\BCC4\B41C LDAP \B514\B809\D1A0\B9AC \C778\C99D\C744 \C704\D55C \C0AC\C6A9\C790 \C774\B984 \BC0F \BE44\BC00\BC88\D638\B97C \C785\B825\D558\C2ED\C2DC\C624. \BE44\BC00\BC88\D638\B294 \B300\C18C\BB38\C790\B97C \AD6C\BD84\D558\C5EC \C785\B825\D558\C2ED\C2DC\C624.</p>'),
''))
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356758914849447766.4508)
,p_plugin_id=>wwv_flow_api.id(356758608092447765.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356759306041447766.4508)
,p_plugin_id=>wwv_flow_api.id(356758608092447765.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356759710067447766.4508)
,p_plugin_id=>wwv_flow_api.id(356758608092447765.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356760114899447766.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356759710067447766.4508)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356760629181447767.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356759710067447766.4508)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356761131992447767.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356759710067447766.4508)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356761615461447767.4508)
,p_plugin_id=>wwv_flow_api.id(356758608092447765.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356762006427447767.4508)
,p_plugin_id=>wwv_flow_api.id(356758608092447765.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356762419044447767.4508)
,p_plugin_id=>wwv_flow_api.id(356758608092447765.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356762006427447767.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356762813227447768.4508)
,p_plugin_id=>wwv_flow_api.id(356758608092447765.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356763212988447768.4508)
,p_plugin_id=>wwv_flow_api.id(356758608092447765.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356763608991447768.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356763212988447768.4508)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356764121289447769.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356763212988447768.4508)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356764608128447769.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(356763212988447768.4508)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356819907237447808.4508)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'INTERNAL Oracle Application Server Single Sign-On'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113750429890071859.4508
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_clob_code_editor
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(690797475249954954.4508)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.CLOB_CODE_EDITOR'
,p_display_name=>unistr('CLOB \CF54\B4DC \D3B8\C9D1\AE30')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.CLOB_CODE_EDITOR'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_clob_code_editor'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_clob_code_editor'
,p_standard_attributes=>'SOURCE_SQL:NO_DATA_FOUND_MESSAGE'
,p_substitute_attributes=>true
,p_reference_id=>1523790298062276372.4508
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359532944903121959.4508)
,p_plugin_id=>wwv_flow_api.id(690797475249954954.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'SQL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359533323568121961.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359532944903121959.4508)
,p_display_sequence=>10
,p_display_value=>'SQL'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359533873017121961.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359532944903121959.4508)
,p_display_sequence=>20
,p_display_value=>'HTML'
,p_return_value=>'HTMLMIXED'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359534396345121962.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359532944903121959.4508)
,p_display_sequence=>30
,p_display_value=>'CSS'
,p_return_value=>'CSS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359534816057121964.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359532944903121959.4508)
,p_display_sequence=>40
,p_display_value=>'JavaScript'
,p_return_value=>'JAVASCRIPT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359535342171121964.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359532944903121959.4508)
,p_display_sequence=>45
,p_display_value=>'DDL'
,p_return_value=>'DDL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359535863445121965.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359532944903121959.4508)
,p_display_sequence=>50
,p_display_value=>'PL/SQL Block'
,p_return_value=>'PLSQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359536354393121965.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359532944903121959.4508)
,p_display_sequence=>70
,p_display_value=>'PL/SQL Expression'
,p_return_value=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359536857083121965.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359532944903121959.4508)
,p_display_sequence=>80
,p_display_value=>'PL/SQL Function Body'
,p_return_value=>'PL/SQL_FUNCTION_BODY'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359537345196121966.4508)
,p_plugin_id=>wwv_flow_api.id(690797475249954954.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Height'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359537705305121966.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359537345196121966.4508)
,p_display_sequence=>1
,p_display_value=>'5'
,p_return_value=>'5'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359538290387121966.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359537345196121966.4508)
,p_display_sequence=>2
,p_display_value=>'10'
,p_return_value=>'10'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359538798307121966.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359537345196121966.4508)
,p_display_sequence=>3
,p_display_value=>'20'
,p_return_value=>'20'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359539235755121967.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359537345196121966.4508)
,p_display_sequence=>10
,p_display_value=>'30'
,p_return_value=>'30'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359539759332121967.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359537345196121966.4508)
,p_display_sequence=>20
,p_display_value=>'60'
,p_return_value=>'60'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359540292436121967.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359537345196121966.4508)
,p_display_sequence=>25
,p_display_value=>'80'
,p_return_value=>'80'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359540739213121967.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359537345196121966.4508)
,p_display_sequence=>30
,p_display_value=>'Automatic'
,p_return_value=>'AUTO'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359541248578121967.4508)
,p_plugin_id=>wwv_flow_api.id(690797475249954954.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Read Only'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359541656097121968.4508)
,p_plugin_id=>wwv_flow_api.id(690797475249954954.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>15
,p_prompt=>'Return Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(359532944903121959.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'PLSQL_EXPRESSION,PLSQL_FUNCTION_BODY'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359542031693121968.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359541656097121968.4508)
,p_display_sequence=>10
,p_display_value=>'VARCHAR2'
,p_return_value=>'VARCHAR2'
,p_help_text=>'VARCHAR2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359542519385121968.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359541656097121968.4508)
,p_display_sequence=>20
,p_display_value=>'BOOLEAN'
,p_return_value=>'BOOLEAN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359543082050121969.4508)
,p_plugin_id=>wwv_flow_api.id(690797475249954954.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Remote Database ID item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>false
,p_is_common=>false
,p_is_translatable=>false
,p_help_text=>'Specify the an item containing the ID of the remote database to use for code validation.'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(359544502528122002.4508)
,p_plugin_id=>wwv_flow_api.id(690797475249954954.4508)
,p_name=>'SOURCE_SQL'
,p_is_required=>false
,p_sql_min_column_count=>1
,p_sql_max_column_count=>1
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select clob_content',
'from demo_scripts'))
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_splitter
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.SPLITTER'
,p_display_name=>unistr('\BD84\D560\C120')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.SPLITTER'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_splitter'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_splitter'
,p_substitute_attributes=>true
,p_reference_id=>330671351658403453.4508
,p_subscribe_plugin_settings=>true
,p_help_text=>unistr('<p>\BD84\D560\C120\C740 \B450 \D558\C704 \C601\C5ED\C5D0 \C0AC\C6A9 \AC00\B2A5\D55C \ACF5\AC04\C744 \C218\D3C9 \B610\B294 \C218\C9C1\C73C\B85C \B3D9\C801 \BD84\D560\D569\B2C8\B2E4. \BD84\D560\C120 \C601\C5ED\C5D0\B294 \C815\D655\D788 \B450 \AC1C\C758 \D558\C704 \C601\C5ED\C774 \C788\C5B4\C57C \D569\B2C8\B2E4. ID \C18D\C131\B9CC \C788\C73C\BA74 \C5B4\B5A4 \C601\C5ED \D15C\D50C\B9AC\D2B8\B4E0 \C0AC\C6A9\D560 \C218 \C788\C9C0\B9CC, \C6A9\B3C4\C5D0 \B9DE\AC8C \C798 \ACE8\B77C\C57C \D569\B2C8\B2E4. \C5EC\BC31\C774\B098 \CC44\C6CC \B123\AE30\AC00 \C788\B294 \C601\C5ED \D15C\D50C\B9AC\D2B8\B294 \C0AC\C6A9\C744 \D53C\D558\C2ED\C2DC\C624. \C601\C5ED \D15C\D50C\B9AC\D2B8\C5D0 \D558\C704 \C601\C5ED\C744 \B798\D551\D558\B294 \C694\C18C\AC00 \C788\B294 \ACBD\C6B0, \B798\D551 \C694\C18C\B97C \C120\D0DD\D558\B294 CSS \C120\D0DD\AE30\B97C \C120\D0DD\AE30 \C18D\C131\C5D0 \C785\B825\D574\C57C \D569\B2C8\B2E4.</p>')
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272772239348879385.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Splitter Keyboard Navigation'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'If yes a global keyboard handler will be added to support using Ctrl-F6 to navigate to the next splitter and Shift-Ctrl-F6 to navigate to the previous splitter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272772670124879385.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Selector'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>80
,p_max_length=>400
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'An optional CSS selector that identifies the element that contains the two sub regions. The selector should start with the the static region id. If omitted the region id or static id will be used. ',
'<p>',
'Example:<br>',
'#regonStaticId > .container',
'<p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272773089811879385.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Orientation'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'horizontal'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'A horizontal splitter has the two sub regions side by side. A vertical splitter has the two sub regions one on top of the other. The first sub region is always on the left or top.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1272773436103879385.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(1272773089811879385.4508)
,p_display_sequence=>10
,p_display_value=>'Horizontal'
,p_return_value=>'horizontal'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1272773955437879386.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(1272773089811879385.4508)
,p_display_sequence=>20
,p_display_value=>'Vertical'
,p_return_value=>'vertical'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272774486513879386.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Positioned From'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'begin'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'This determines from which side the position of the splitter is measured and to which side the splitter will collapse. Choose Begin to collapse to the left (right if direction is RTL) or top. Choose End to collapse to the right (left if direction is '
||'RTL) or bottom.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1272774832182879388.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(1272774486513879386.4508)
,p_display_sequence=>10
,p_display_value=>'Begin (left/top)'
,p_return_value=>'begin'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1272775310859879389.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(1272774486513879386.4508)
,p_display_sequence=>20
,p_display_value=>'End (right/bottom)'
,p_return_value=>'end'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272775861831879390.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Position'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_default_value=>'100'
,p_display_length=>5
,p_max_length=>5
,p_is_translatable=>false
,p_help_text=>'This is the initial position in pixels of the splitter bar. If the splitter is initially collapsed this is the position used when the splitter is first expanded. If Persist State is Yes then if there is a saved position it overrides this value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272776298415879390.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Collapsed'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1272779866076879391.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'If Yes the splitter is initially collapsed. If Persist State is Yes then if there is a saved collapsed state it overrides this value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272776622800879390.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Snap'
,p_attribute_type=>'NUMBER'
,p_is_required=>false
,p_display_length=>5
,p_max_length=>5
,p_is_translatable=>false
,p_help_text=>'Optional. The number of pixels the splitter moves in each increment when dragging or with the arrow keys. If not specified the splitter can be dragged with single pixel precision.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272777035399879390.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Keyboard Increment'
,p_attribute_type=>'NUMBER'
,p_is_required=>false
,p_display_length=>5
,p_max_length=>5
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1272776622800879390.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
,p_help_text=>'Optional. The number of pixels to move the splitter for each arrow key press. If not specified the default is 10.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272777443759879390.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Minimum Size'
,p_attribute_type=>'NUMBER'
,p_is_required=>false
,p_display_length=>5
,p_max_length=>5
,p_is_translatable=>false
,p_help_text=>'The minimum position of the splitter before it automatically collapses. If not specified the default of 60 is used.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272777835460879390.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Continuous Resize'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_help_text=>'If Yes the two sub regions are sized on each movement of the splitter while dragging or moving with the arrow keys. Otherwise the sub regions are sized only when the splitter stops moving. This should be set to No if the sub regions are computational'
||'ly expensive to resize.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272778274734879391.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Restore Text'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>80
,p_max_length=>120
,p_is_translatable=>true
,p_help_text=>'This is the title (tooltip) text for the splitter handle when the splitter is collapsed. If not specified a default is provided.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272778621295879391.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Collapse Text'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>80
,p_max_length=>120
,p_is_translatable=>true
,p_help_text=>'This is the title (tooltip) text for the splitter handle when the splitter is expanded. If not specified a default is provided.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272779063732879391.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Title'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>80
,p_max_length=>120
,p_is_translatable=>true
,p_help_text=>'This is the title (tooltip) text for the splitter bar. Providing a title for each splitter is helpful for accessibility especially when there are multiple splitters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272779463251879391.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>12
,p_prompt=>'Persist State'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'If Yes the state of the splitter is persisted as a user preference.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272779866076879391.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>45
,p_prompt=>'Can Collapse '
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_show_in_wizard=>false
,p_default_value=>'Y'
,p_supported_ui_types=>'DESKTOP'
,p_is_translatable=>false
,p_help_text=>'When set to Yes the splitter can collapse or expand by clicking on the handle or pressing Enter or Space. When set to No the splitter can only be moved to its minimum size.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272780235601879392.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>150
,p_prompt=>'Sub Region Contains iframe'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'N'
,p_supported_ui_types=>'DESKTOP'
,p_is_translatable=>false
,p_help_text=>'Only set to Yes if either sub region of the splitter contains an iframe.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1272780635681879392.4508)
,p_plugin_id=>wwv_flow_api.id(1223659655805557097.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>160
,p_prompt=>'Drag To Collapse'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'Y'
,p_supported_ui_types=>'DESKTOP'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1272779866076879391.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'If Yes the splitter can be collapsed by dragging past the minimum size. If No the splitter can only be dragged to the minimum size.'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_code_editor
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1510820626581865225.4508)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.CODE_EDITOR'
,p_display_name=>unistr('\CF54\B4DC \D3B8\C9D1\AE30')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.CODE_EDITOR'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_code_editor'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_code_editor'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:READONLY:SOURCE:ELEMENT:WIDTH:HEIGHT:ENCRYPT'
,p_substitute_attributes=>true
,p_reference_id=>1510773430399830292.4508
,p_subscribe_plugin_settings=>true
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359421593070120032.4508)
,p_plugin_id=>wwv_flow_api.id(1510820626581865225.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'SQL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359421996246120033.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_display_sequence=>10
,p_display_value=>'SQL'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359422404011120038.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_display_sequence=>20
,p_display_value=>'HTML'
,p_return_value=>'HTMLMIXED'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359422979413120039.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_display_sequence=>30
,p_display_value=>'CSS'
,p_return_value=>'CSS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359423436093120039.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_display_sequence=>40
,p_display_value=>'JavaScript'
,p_return_value=>'JAVASCRIPT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359423999821120040.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_display_sequence=>45
,p_display_value=>'DDL'
,p_return_value=>'DDL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359424470853120040.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_display_sequence=>50
,p_display_value=>'PL/SQL Block'
,p_return_value=>'PLSQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359424980664120041.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_display_sequence=>60
,p_display_value=>'PL/SQL Functions/Procedures'
,p_return_value=>'PLSQL_FUNCTIONS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359425438332120041.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_display_sequence=>70
,p_display_value=>'PL/SQL Expression'
,p_return_value=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359425928124120042.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_display_sequence=>80
,p_display_value=>'PL/SQL Function Body'
,p_return_value=>'PLSQL_FUNCTION_BODY'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359426498669120043.4508)
,p_plugin_id=>wwv_flow_api.id(1510820626581865225.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Return Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'PLSQL_EXPRESSION,PLSQL_FUNCTION_BODY'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359426827112120044.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359426498669120043.4508)
,p_display_sequence=>10
,p_display_value=>'VARCHAR2'
,p_return_value=>'VARCHAR2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359427332075120045.4508)
,p_plugin_attribute_id=>wwv_flow_api.id(359426498669120043.4508)
,p_display_sequence=>20
,p_display_value=>'BOOLEAN'
,p_return_value=>'BOOLEAN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359427840175120045.4508)
,p_plugin_id=>wwv_flow_api.id(1510820626581865225.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Show Query Builder'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(359421593070120032.4508)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'SQL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359428224810120046.4508)
,p_plugin_id=>wwv_flow_api.id(1510820626581865225.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Adjustable Height'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_supported_ui_types=>'DESKTOP'
,p_is_translatable=>false
,p_help_text=>'If Yes the user can adjust the height of the code editor.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359428686319120046.4508)
,p_plugin_id=>wwv_flow_api.id(1510820626581865225.4508)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Remote  Database ID item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_is_translatable=>false
,p_help_text=>'Specify a page item containing the remote database ID to use for code validation.'
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2448181332878348304.4508)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>unistr('\BAA8\B450 \C120\D0DD \CCB4\D06C\BC15\C2A4 \CD94\AC00')
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512.4508
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>"\BAA8\B450 \C120\D0DD \CCB4\D06C\BC15\C2A4 \CD94\AC00" \B3D9\C801 \C791\C5C5\C740#CHECK_ALL_CHECKBOX# \BB38\C790\C5F4\C774 \D3EC\D568\B41C \C5F4 \C81C\BAA9\C744 \C561\C138\C2A4 \AC00\B2A5\D55C \BAA8\B4E0 \C2A4\D0C0\C77C \C120\D0DD \CCB4\D06C\BC15\C2A4\B85C \BCC0\D658\D569\B2C8\B2E4. \C774 \CCB4\D06C\BC15\C2A4\B97C \C0AC\C6A9\D558\BA74 \D574\B2F9 \C5F4\C5D0 \C788\B294 \BAA8\B4E0 \CCB4\D06C\BC15\C2A4\B97C \C120\D0DD \BC0F \C120\D0DD \CDE8\C18C\D560 \C218 \C788\C2B5\B2C8\B2E4.<p>'),
'<p>',
unistr('\C774 \D50C\B7EC\ADF8\C778\C744 \C0AC\C6A9\D558\B824\BA74 \B2E4\C74C \C18D\C131\C774 \C124\C815\B418\C5C8\B294\C9C0 \D655\C778\D558\C2ED\C2DC\C624.'),
'<ol>',
unistr('<li>\BCF4\ACE0\C11C \C5F4\C5D0\C11C ''#CHECK_ALL_CHECKBOX#''\B97C \C81C\BAA9 \AC12\C73C\B85C \C815\C758\D569\B2C8\B2E4.</li>'),
unistr('<li>\B3D9\C801 \C791\C5C5 \C2DC\AC04 \C18D\C131\C758 \ACBD\C6B0 \D574\B2F9 \C5F4\C774 \D3EC\D568\B41C \BCF4\ACE0\C11C \C601\C5ED\C744 \C120\D0DD\D569\B2C8\B2E4.</li>'),
unistr('<li>''\C0C8\B85C\ACE0\CE68 \C774\D6C4''\C5D0 \C2E4\D589\B418\B294 \B3D9\C801 \C791\C5C5 \BC0F ''\D398\C774\C9C0 \B85C\B4DC \C2DC \C2E4\D589'' \C791\C5C5\C744 \C815\C758\D569\B2C8\B2E4. \D398\C774\C9C0 \B514\C790\C774\B108\C758 ''\B80C\B354\B9C1'' \C139\C158\C5D0\C11C \C601\C5ED\C744 \C120\D0DD\D558\ACE0 \C5EC\AE30\C5D0\C11C \B3D9\C801 \C791\C5C5\C744 \C0DD\C131\D558\B294 \BC29\C2DD\C73C\B85C \B3D9\C801 \C791\C5C5\C774 \C0DD\C131\B41C \ACBD\C6B0 \B450 \C791\C5C5 \BAA8\B450 \AE30\BCF8\AC12\C73C\B85C \C62C\BC14\B974\AC8C \C9C0\C815\B420 \C218 \C788\C2B5\B2C8\B2E4.</li>'),
unistr('<li>\C774 \C791\C5C5\C740 \AC01 \D589\C5D0\C11C \B80C\B354\B9C1\B418\B294 \CCB4\D06C\BC15\C2A4\C758 \C811\ADFC\C131\C744 \CC98\B9AC\D558\C9C0 \C54A\C73C\BA70, \C601\C5ED \C18C\C2A4\C5D0\C11C \AC1C\BCC4\C801\C73C\B85C \C218\D589\B418\C5B4\C57C \D569\B2C8\B2E4. (\C608\B97C \B4E4\C5B4, 4000:656 ''Regions'' \C601\C5ED\C744 \CC38\C870\D558\C2ED\C2DC\C624).</li>'),
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(4969205754302342.4508)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>unistr('\B370\C2A4\D06C\D1B1')
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>3
,p_home_url=>'f?p=4500:1000:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4508
,p_nav_list_template_options=>'#DEFAULT#'
,p_css_file_urls=>'#IMAGE_PREFIX#css/apex_builder#MIN#.css'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>'0'
,p_step_title=>'0'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11140505307196687.4508)
,p_plug_name=>'Global Items For Object Browser'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'23'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(386906063356677524.4508)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-sql-workshop'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(386906446198682887.4508)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(386906063356677524.4508)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(385795398770024112.4508)
,p_plug_name=>'APEX 5 - Tabs'
,p_region_name=>'a_Header_menu'
,p_parent_plug_id=>wwv_flow_api.id(386906446198682887.4508)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(718942723406995455.4508)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(385776082908002390.4508)
,p_translate_title=>'N'
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'not wwv_flow.apps_only_workspace'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(386906842726682887.4508)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(386906446198682887.4508)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"><span class="u-VisuallyHidden">''||wwv_flow_lang.system_message(''HOME_'
||'NAV'')||''</span></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(386906639708682887.4508)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(386906063356677524.4508)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(385807144565239746.4508)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_api.id(386906639708682887.4508)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(385814960550248814.4508)
,p_plug_name=>'Administration Menu'
,p_region_name=>'adminMenu'
,p_parent_plug_id=>wwv_flow_api.id(385807144565239746.4508)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697546799309390664.4508)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(385776364537002403.4508)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(486772007528301730.4508)
,p_plug_name=>'Help Menu'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_api.id(385807144565239746.4508)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697551745129395610.4508)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(385776364537002403.4508)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(385816859034290012.4508)
,p_plug_name=>'Header Account'
,p_parent_plug_id=>wwv_flow_api.id(386906639708682887.4508)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388720726124473736.4508)
,p_plug_name=>'APEX 5 - Search'
,p_parent_plug_id=>wwv_flow_api.id(386906639708682887.4508)
,p_region_css_classes=>'a-Header-search'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-SearchBox a-SearchBox--noGoButton a-SearchBox--autoExpand a-SearchBox--fill">'');',
'sys.htp.p(''  <div class="a-SearchBox-field">'');',
'sys.htp.p(''    <span class="a-SearchBox-icon"><span class="a-Icon icon-search"></span></span>'');',
'sys.htp.p(''    <label for="P0_SEARCH" class="visuallyhidden">''||wwv_flow_lang.system_message(''SEARCH'')||''</label>'');',
'sys.htp.p(''    <input type="text" class="a-SearchBox-input" id="P0_SEARCH" placeholder="''||wwv_flow_lang.system_message(''SEARCH'')||''">'');',
'sys.htp.p(''  </div>'');',
'sys.htp.p(''</div>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'CURRENT_PAGE_IN_CONDITION'
,p_plug_display_when_condition=>'1000'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_required_patch=>wwv_flow_api.id(1080926199001296276.4508)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(387929033434561917.4508)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-sql-workshop'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'1000,3002'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(387929284740561918.4508)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_api.id(387929033434561917.4508)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>10
,p_plug_new_grid=>true
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(384688805135932803.4508)
,p_plug_name=>'APEX 5 - Breadcrumb'
,p_parent_plug_id=>wwv_flow_api.id(387929284740561918.4508)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_menu_id=>wwv_flow_api.id(6696510824685479.4508)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(387975456606606350.4508)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(387929403973561918.4508)
,p_plug_name=>'APEX 5 - Control Bar Right'
,p_parent_plug_id=>wwv_flow_api.id(387929033434561917.4508)
,p_region_css_classes=>'a-ControlBar-col'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(387994680244652086.4508)
,p_plug_name=>'Schema'
,p_region_name=>'apex-control-icons'
,p_parent_plug_id=>wwv_flow_api.id(387929403973561918.4508)
,p_region_css_classes=>'a-Form a-Form--small a-Form--schemaSelect'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(161345724959782337.4508)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(385807144565239746.4508)
,p_button_name=>'SPOTLIGHT'
,p_button_static_id=>'header-spotlightSearch'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765860428963371.4508)
,p_button_image_alt=>unistr('\C2A4\D3EC\D2B8\B77C\C774\D2B8 \AC80\C0C9')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-actionButton a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-search'
,p_button_cattributes=>'data-action="spotlight-search"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(385815804801264383.4508)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(385807144565239746.4508)
,p_button_name=>'HEADER_ADMINISTRATION'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765690470963369.4508)
,p_button_image_alt=>unistr('\AD00\B9AC')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(385816282863272115.4508)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(385807144565239746.4508)
,p_button_name=>'HEADER_FEEDBACK'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765860428963371.4508)
,p_button_image_alt=>unistr('\D53C\B4DC\BC31')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
,p_required_patch=>wwv_flow_api.id(693462110571635991.4508)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(385816622634278210.4508)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(385807144565239746.4508)
,p_button_name=>'HEADER_HELP'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765690470963369.4508)
,p_button_image_alt=>unistr('\B3C4\C6C0\B9D0')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(11141129549203626.4508)
,p_name=>'OB_OBJECT_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(11140505307196687.4508)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(11143605700225196.4508)
,p_name=>'P0_PPRTIMESTAMP'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(11140505307196687.4508)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(387994857980652090.4508)
,p_name=>'P0_SCHEMA'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(387994680244652086.4508)
,p_prompt=>unistr('\C2A4\D0A4\B9C8')
,p_source=>'wwv_flow_user_api.get_default_schema'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LIST_AVAILABLE_SCHEMAS-QB'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  q      varchar2(32767) := null;',
'begin',
'  q:=''select wwv_flow_escape.html(upper(c.schema)) d, upper(c.schema) v '';',
'  q:=q||''from   wwv_flow_company_schemas c, ''; ',
'  q:=q||''       wwv_flow_fnd_user u ''; ',
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.user_name = :flow_user and '';',
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';',
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';',
'  q:=q||''  and  nvl(:P1002_POPUP,0) <> 1 '';',
'  q:=q||''union all '';',
'  q:=q||''select wwv_flow_escape.html(:P1002_SCHEMA) a,:P1002_SCHEMA b from dual '';',
'  q:=q||''where  :P1002_POPUP = 1 '';',
'  q:=q||''order by 1'';',
'  return q;',
'end;'))
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_css_classes=>'a-Form-select'
,p_label_alignment=>'RIGHT'
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C2A4\D0A4\B9C8 \C18C\C720\C790\C758 \C774\B984')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \AD00\B9AC\C790 \B85C\ADF8\C778')
,p_alias=>'DBA_LOGIN'
,p_step_title=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \AD00\B9AC\C790 \B85C\ADF8\C778')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(206250111084432914)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'#P1_USERNAME ,#P1_PASSWORD{width:200px;}',
'</style>'))
,p_step_template=>wwv_flow_api.id(703368619593851824.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(206059717799303330)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEUTL/dbadm_montitor.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1043922209309492.4508)
,p_plug_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \AD00\B9AC\C790 \B85C\ADF8\C778')
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(746376253838324384.4508)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'valign="top"'
,p_plug_header=>unistr('<p>\D2B9\C815 \B370\C774\D130\BCA0\C774\C2A4 \AD8C\D55C\C774 \D544\C694\D55C \D398\C774\C9C0\C5D0 \B300\D574 \C561\C138\C2A4\B97C \C694\CCAD\D588\C2B5\B2C8\B2E4. DBA \B864\C774 \BD80\C5EC\B41C \B370\C774\D130\BCA0\C774\C2A4 \ACC4\C815\C758 \C99D\BA85\C11C\B97C \C785\B825\D558\C2ED\C2DC\C624.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1019666021060320819.4508)
,p_plug_name=>'button region'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--wizard'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(690697788869123307.4508)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1020222865942116889.4508)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(1019666021060320819.4508)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_image_alt=>unistr('\CDE8\C18C')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4500_LAST_VIEW.:&SESSION.::&DEBUG.:::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(359654713065770667.4508)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1019666021060320819.4508)
,p_button_name=>'P1_LOGIN'
,p_button_static_id=>'P1_LOGIN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\B85C\ADF8\C778')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_request_source=>'LOGIN_BUTTON'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(155129504944225119.4508)
,p_branch_action=>'return ''f?p=''||:P1_APP||'':''||:P1_PAGE||'':''||:SESSION;'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_FUNCTION_RETURNING_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1046305318309560.4508)
,p_name=>'P1_USERNAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1043922209309492.4508)
,p_prompt=>unistr('\C0AC\C6A9\C790 \C774\B984')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>25
,p_cMaxlength=>2000
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\C774 \B370\C774\D130\BCA0\C774\C2A4\C5D0\C11C DBA \AD8C\D55C\C744 \AC00\C9C4 \B370\C774\D130\BCA0\C774\C2A4 \ACC4\C815\C5D0 \B300\D55C \C0AC\C6A9\C790 \C774\B984\ACFC \BE44\BC00\BC88\D638\B97C \C785\B825\D558\C2ED\C2DC\C624.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1046904764309562.4508)
,p_name=>'P1_PASSWORD'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1043922209309492.4508)
,p_prompt=>unistr('\BE44\BC00\BC88\D638')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>25
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\BE44\BC00\BC88\D638\B97C \C785\B825\D558\C2ED\C2DC\C624.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(206105727449627884.4508)
,p_name=>'P1_APP'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(1043922209309492.4508)
,p_item_default=>'&APP_ID.'
,p_source=>'substr(:REQUEST,1,instr(:REQUEST,'','')-1)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(206106408533631817.4508)
,p_name=>'P1_PAGE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(1043922209309492.4508)
,p_item_default=>'1'
,p_source=>'substr(:REQUEST,instr(:REQUEST,'','')+1)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(206083700119496957.4508)
,p_validation_name=>'check dba password'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_auth boolean := false;',
'begin',
'    l_auth := sys.wwv_flow_val.verify_user (',
'                  username => :P1_USERNAME,',
'                  password => :P1_PASSWORD ) = sys.wwv_flow_val.valid_user;',
'',
'    if    l_auth',
'      and wwv_flow_security.user_is_dba (',
'              p_username => :P1_USERNAME )',
'    then',
'        :F4500_DBA_LOGIN := ''Y'';',
'        :DBA_USERNAME := upper(:P1_USERNAME);',
'        return true;',
'    end if;',
'',
'    :F4500_DBA_LOGIN := ''N'';',
'    return false;',
'exception when others then',
'    return false;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\BE44\BC00\BC88\D638\AC00 \C62C\BC14\B974\C9C0 \C54A\AC70\B098 \C0AC\C6A9\C790\C5D0\AC8C \D544\C218 \B864\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_associated_item=>wwv_flow_api.id(.4508)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(155252725985250123.4508)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear sensitive items'
,p_attribute_01=>'CLEAR_CACHE_FOR_ITEMS'
,p_attribute_03=>'P1_USERNAME,P1_PASSWORD'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_api.create_page(
 p_id=>2.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\D2B8\B9AC\AC70\AC00 \C5C6\B294 \D14C\C774\BE14')
,p_step_title=>unistr('\D2B8\B9AC\AC70\AC00 \C5C6\B294 \D14C\C774\BE14')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(276037127560809519)
,p_step_template=>wwv_flow_api.id(385762900697898960.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEUTL/sql_utl_excp_rpt.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(34148419202124380.4508)
,p_plug_name=>unistr('\D2B8\B9AC\AC70\AC00 \C5C6\B294 \D14C\C774\BE14')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690714020036152159.4508)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select table_name',
'  from sys.user_tables a',
' where table_name not like ''BIN$%''',
'   and not exists ( select 1',
'                     from sys.user_triggers',
'                    where table_name = a.table_name )'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_plug_query_parse_override=>'P2_OWNER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(34148531542124380.4508)
,p_name=>'Tables without Triggers'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\C774 \C9C8\C758\B294 10,000\AC1C \C774\C0C1\C758 \D589\C744 \BC18\D658\D569\B2C8\B2E4. \BCF4\B2E4 \C815\D655\D55C \ACB0\ACFC\B97C \C5BB\C73C\B824\BA74 \B370\C774\D130\B97C \D544\D130\B9C1\D558\C2ED\C2DC\C624.')
,p_no_data_found_message=>unistr('\B370\C774\D130\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(34148708061124427.4508)
,p_db_column_name=>'TABLE_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\D14C\C774\BE14 \C774\B984')
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(69172413159446494.4508)
,p_plug_name=>unistr('\D2B8\B9AC\AC70\AC00 \C5C6\B294 \D14C\C774\BE14')
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(380771699411878611.4508)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('\C774 \BCF4\ACE0\C11C\C5D0\B294 \D2B8\B9AC\AC70\AC00 \C5C6\B294 \D14C\C774\BE14\C774 \D45C\C2DC\B429\B2C8\B2E4.')
,p_plug_column_width=>'valign="top" align="right"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(69173409024446500.4508)
,p_plug_name=>'schema'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690697788869123307.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(722738457991798612.4508)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(34148419202124380.4508)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_image_alt=>unistr('\C7AC\C124\C815')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP,RIR,2:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(69175712074446516.4508)
,p_branch_action=>'2'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(69174122456446507.4508)
,p_name=>'P2_OWNER'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(69173409024446500.4508)
,p_prompt=>unistr('\C2A4\D0A4\B9C8')
,p_source=>'wwv_flow_user_api.get_default_schema'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LIST_AVAILABLE_SCHEMAS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  q      varchar2(32767) := null;',
'begin  ',
'  q:=''select wwv_flow_escape.html(upper(c.schema)) d, upper(c.schema) v '';',
'  q:=q||''from   wwv_flow_company_schemas c, '';',
'  q:=q||''       wwv_flow_fnd_user u '';',
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.user_name = :flow_user and '';',
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';',
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';',
'  q:=q||''order by 1'';  ',
'  return q;',
'end;'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \C2A4\D0A4\B9C8 \C120\D0DD - ')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \C2A4\D0A4\B9C8 \C18C\C720\C790\C758 \C774\B984')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(69175301137446513.4508)
,p_computation_sequence=>10
,p_computation_item=>'P2_OWNER'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'upper(wwv_flow_user_api.get_default_schema)'
,p_compute_when=>'P2_OWNER'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(69192210847547410.4508)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'validate schema'
,p_process_sql_clob=>'wwv_flow_sw_api.check_priv(:P2_OWNER);'
,p_process_error_message=>unistr('\BD80\C801\D569\D55C \C2A4\D0A4\B9C8')
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_api.create_page(
 p_id=>3.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\D14C\C774\BE14 \C0DD\C131 \D2B8\B9AC\AC70 \C120\D0DD')
,p_alias=>'TRIGGER_CREATE'
,p_step_title=>unistr('\D14C\C774\BE14 \C120\D0DD')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(11540120040990569)
,p_step_template=>wwv_flow_api.id(703368619593851824.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(106724407422013886.4508)
,p_plug_name=>unistr('\D2B8\B9AC\AC70 \C0DD\C131')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717419707883820782.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'Region generated 07-FEB-2003 18:17:26'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(150817615862142740.4508)
,p_plug_name=>'Progress Indicator'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(150811814776114073.4508)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(703372217110859571.4508)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(240050607367537341.4508)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(690697788869123307.4508)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752117455494695886.4508)
,p_plug_name=>unistr('\D2B8\B9AC\AC70 \C0DD\C131')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_plug_template=>wwv_flow_api.id(717420493098820783.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(106724801560013890.4508)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(240050607367537341.4508)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(690706750701136097.4508)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\B2E4\C74C')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(106724622614013889.4508)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(240050607367537341.4508)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_image_alt=>unistr('\CDE8\C18C')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4500_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(106728014234013914.4508)
,p_branch_action=>'f?p=&APP_ID.:84:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(106725016917013892.4508)
,p_name=>'P3_TABLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(106724407422013886.4508)
,p_prompt=>unistr('\D14C\C774\BE14 \C774\B984')
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'OB_CREATE_TABLE_HANDLER'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, object_name r',
'from sys.dba_objects',
'where owner = :OB_SCHEMA ',
'and object_type in (''TABLE'')',
'and object_name not like ''BIN$%'' ',
'and object_name not like ''DR$%'' ',
'order by 1'))
,p_cSize=>40
,p_cMaxlength=>2000
,p_cHeight=>1
,p_display_when=>'P3_FROM'
,p_display_when_type=>'ITEM_IS_NULL'
,p_field_template=>wwv_flow_api.id(488671190365029680.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\C774 \D2B8\B9AC\AC70\C640 \C5F0\AD00\B41C \D14C\C774\BE14\C744 \C120\D0DD\D558\C2ED\C2DC\C624.')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'Y'
,p_item_comment=>'Generated 07-FEB-2003 18:17:26'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(106725532339013897.4508)
,p_name=>'P3_SCHEMA'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(106724407422013886.4508)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\C2A4\D0A4\B9C8:')
,p_source=>'OB_SCHEMA'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>unistr('\C120\D0DD\D55C \D14C\C774\BE14\C744 \C18C\C720\D558\B294 \B370\C774\D130\BCA0\C774\C2A4 \C2A4\D0A4\B9C8\B97C \C2DD\BCC4\D569\B2C8\B2E4.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(273749223696559998.4508)
,p_computation_sequence=>10
,p_computation_item=>'P3_TABLE'
,p_computation_type=>'QUERY'
,p_computation=>'select table_name from sys.dba_tables where upper(table_name) = upper(:p3_table);'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(274022614606626627.4508)
,p_validation_name=>'table exists'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from sys.dba_objects where upper(object_name) = upper(:P3_TABLE) and owner = :OB_SCHEMA and object_type =',
'''TABLE'''))
,p_validation_type=>'EXISTS'
,p_error_message=>unistr('\D14C\C774\BE14\C774 \C874\C7AC\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
,p_associated_item=>wwv_flow_api.id(.4508)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00004
begin
wwv_flow_api.create_page(
 p_id=>4.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\C778\B371\C2A4\B97C \C0DD\C131\D560 \C218 \C5C6\C74C')
,p_step_title=>unistr('\C778\B371\C2A4\B97C \C0DD\C131\D560 \C218 \C5C6\C74C')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(11093307704620192)
,p_step_template=>wwv_flow_api.id(703368619593851824.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_help_text=>'AEUTL/obj_index.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(107474329693138421.4508)
,p_plug_name=>unistr('\C778\B371\C2A4\B97C \C0DD\C131\D560 \C218 \C5C6\C74C')
,p_region_template_options=>'#DEFAULT#:a-Alert--danger:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(746376253838324384.4508)
,p_plug_display_sequence=>31
,p_plug_display_point=>'BODY'
,p_plug_source=>'&P4_MSG.'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_plug_display_when_condition=>'P4_MSG'
,p_plug_display_when_cond2=>'SUCCESS'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(208343830183777608.4508)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(690697788869123307.4508)
,p_plug_display_sequence=>81
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(107475119034138424.4508)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(208343830183777608.4508)
,p_button_name=>'PREVIOUS'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765860428963371.4508)
,p_button_image_alt=>unistr('\C774\C804')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(270764810820114173.4508)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(208343830183777608.4508)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_image_alt=>unistr('\CDE8\C18C')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4500_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(107476418042138429.4508)
,p_branch_action=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(107475119034138424.4508)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(107475508914138426.4508)
,p_name=>'P4_MSG'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(107474329693138421.4508)
,p_prompt=>unistr('\BA54\C2DC\C9C0')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\B3C4\C6C0\B9D0 \D14D\C2A4\D2B8\AC00 \D544\C694\D558\C9C0 \C54A\C2B5\B2C8\B2E4.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(107476032550138427.4508)
,p_name=>'P4_OBJECT_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(107474329693138421.4508)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(182459028608141946.4508)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load new Object'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- SR: JAS 01/26/09 - could not determine how to exercise page, did not change',
'declare',
' l_name varchar2(2000);',
'begin',
' if :P5_PREVIOUS = 94 then',
'   l_name := :P94_INDEX_NAME;',
' else',
'   l_name := :P77_INDEX_NAME;',
' end if;',
' if ( :P5_ACTION = ''CREATE_INDEX'') then ',
'  for r in ( select object_id,object_name,owner,object_type',
'   from sys.dba_objects',
'   where owner = :OB_SCHEMA',
'   and object_name = l_name',
'   and object_type = ''INDEX'' ) loop',
'     :OBJECT_ID    := r.object_id;',
'     :OBJECT_NAME  := r.object_name;',
'     :OBJECT_OWNER := r.owner;',
'     :OBJECT_TYPE  := r.object_type;',
'  end loop;',
' end if; /* end create_index */',
'',
'sys.owa_util.redirect_url(''f?p=''||:APP_ID||'':1001:''||:SESSION||'':FOCUS:::OB_CURRENT_TYPE,OB_OBJECT_ID:''||:OBJECT_TYPE||'',''||:OBJECT_ID);',
'wwv_flow.g_unrecoverable_error := true;',
'end;'))
,p_process_when=>'P4_MSG'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'SUCCESS'
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\C778\B371\C2A4 \C0DD\C131 \D655\C778')
,p_step_title=>unistr('\C778\B371\C2A4 \C0DD\C131 \D655\C778')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215538527409730225)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'    function showDDL(){',
'        theDDL = document.getElementById(''P67_SQL'');',
'        showDiv = document.getElementById(''ddlShow'');',
'        hideDiv = document.getElementById(''ddlHide'');',
'        hideDiv.style.display = ''inline'';',
'        theDDL.style.display = ''inline'';',
'        showDiv.style.display = ''none'';',
'        }',
'        ',
'    function hideDDL(){',
'        theDDL = document.getElementById(''P67_SQL'');',
'        showDiv = document.getElementById(''ddlShow'');',
'        hideDiv = document.getElementById(''ddlHide'');',
'        hideDiv.style.display = ''none'';',
'        theDDL.style.display = ''none'';',
'        showDiv.style.display = ''inline'';',
'        }',
'</script>'))
,p_step_template=>wwv_flow_api.id(703368619593851824.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_help_text=>'AEUTL/obj_index.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(107489816716162291.4508)
,p_plug_name=>unistr('\C694\CCAD \B0B4\C6A9\C744 \D655\C778\D558\C2ED\C2DC\C624. ')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717419707883820782.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'valign="top"'
,p_plug_header=>unistr('<p>\C694\CCAD \B0B4\C6A9\C744 \D655\C778\D558\C2ED\C2DC\C624.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'Region generated 07-FEB-2003 18:17:26'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(107490015850162292.4508)
,p_plug_name=>'SQL'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717419046555820782.4508)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(149949010721628282.4508)
,p_plug_name=>'Progress Indicator'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(149926526903576167.4508)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(703372217110859571.4508)
,p_translate_title=>'N'
,p_plug_display_condition_type=>'VALUE_OF_ITEM_IN_CONDITION_NOT_IN_COLON_DELIMITED_LIST'
,p_plug_display_when_condition=>'F4500_LAST_VIEW'
,p_plug_display_when_cond2=>'2102'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(208342000270759522.4508)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(690697788869123307.4508)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752117609914695886.4508)
,p_plug_name=>unistr('\C778\B371\C2A4 \C0DD\C131')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_plug_template=>wwv_flow_api.id(717420493098820783.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(107490423349162293.4508)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(208342000270759522.4508)
,p_button_name=>'FINISH'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\C778\B371\C2A4 \C0DD\C131')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(107490616048162293.4508)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(208342000270759522.4508)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765860428963371.4508)
,p_button_image_alt=>unistr('\C774\C804')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:&P5_PREVIOUS.:&SESSION.::&DEBUG.:::'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(107490221219162293.4508)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(208342000270759522.4508)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_image_alt=>unistr('\CDE8\C18C')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4500_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(107534407216303661.4508)
,p_branch_action=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.::P4_OBJECT_ID:&P5_NEW_OBJECT_ID.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(107490423349162293.4508)
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(107490830150162294.4508)
,p_name=>'P5_SCHEMA'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(107489816716162291.4508)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\C2A4\D0A4\B9C8:')
,p_source=>'OBJECT_OWNER'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>unistr('\C120\D0DD\D55C \D14C\C774\BE14\C744 \C18C\C720\D558\B294 \B370\C774\D130\BCA0\C774\C2A4 \C2A4\D0A4\B9C8\B97C \C2DD\BCC4\D569\B2C8\B2E4.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(107491320593162295.4508)
,p_name=>'P5_TABLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(107489816716162291.4508)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\AC1D\CCB4:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :p5_PREVIOUS = ''77'' then ',
' return :P77_INDEX_NAME;',
'else',
' return :P94_INDEX_NAME;',
'end if;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_protection_level=>'I'
,p_escape_on_http_input=>'N'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\C120\D0DD\B41C \D14C\C774\BE14\C758 \C774\B984\C744 \C2DD\BCC4\D569\B2C8\B2E4.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(107491812633162296.4508)
,p_name=>'P5_ACTION'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(107489816716162291.4508)
,p_prompt=>unistr('\C791\C5C5:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\D14C\C774\BE14\C5D0\C11C \C218\D589\B420 \C791\C5C5 \C720\D615\C744 \C2DD\BCC4\D569\B2C8\B2E4.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(107492322417162297.4508)
,p_name=>'P5_SQL'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(107490015850162292.4508)
,p_prompt=>'SQL'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>70
,p_cMaxlength=>32767
,p_cHeight=>15
,p_tag_css_classes=>'a-Form-textarea--code'
,p_tag_attributes=>'readonly="readonly"'
,p_field_template=>wwv_flow_api.id(717397144393801382.4508)
,p_item_css_classes=>'a-Form-fieldContainer--fieldsetBlock'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
,p_item_comment=>'Generated 07-FEB-2003 18:17:26'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(107492522422162297.4508)
,p_name=>'P5_PREVIOUS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(107489816716162291.4508)
,p_prompt=>'Previous'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(107492718130162298.4508)
,p_name=>'P5_NEW_OBJECT_ID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(107489816716162291.4508)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(107492916493162298.4508)
,p_computation_sequence=>10
,p_computation_item=>'P57_TABLE'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'P73_NEW_TABLE_NAME'
,p_compute_when=>':P70_ACTION = ''RENAME'' and :REQUEST = ''FINISH'''
,p_compute_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(107493718722162300.4508)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check privs'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_api.check_priv (',
'    p_schema => upper(:OB_SCHEMA)',
'    );'))
,p_process_error_message=>unistr('&OB_SCHEMA.\C5D0 \B300\D55C \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_process_when_button_id=>wwv_flow_api.id(107490423349162293.4508)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(107493904672162301.4508)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'run DDL'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P4_MSG := wwv_flow_sw_util.run_other_sql(',
'              p_schema     => upper(:OB_SCHEMA),',
'              p_sql        => :P5_SQL );',
'if :p5_PREVIOUS = ''94'' then',
'for c in (select object_id ',
'          from sys.dba_objects ',
'          where object_name = :p94_index_name ',
'          and owner = :OB_SCHEMA ',
'          and object_type = ''INDEX'') loop',
'  :P5_NEW_OBJECT_ID := c.object_id;',
'end loop;',
'else',
'for c in (select object_id ',
'          from sys.dba_objects ',
'          where object_name = :p77_index_name ',
'          and owner = :OB_SCHEMA ',
'          and object_type = ''INDEX'') loop',
'  :P5_NEW_OBJECT_ID := c.object_id;',
'end loop;',
'end if;'))
,p_process_when_button_id=>wwv_flow_api.id(107490423349162293.4508)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(107494126732162301.4508)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save History'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_api.save_history (',
'    p_security_group_id => :flow_security_group_id ,',
'    p_user              => :flow_user,',
'    p_sql_cmd           => :P5_SQL,',
'    p_schema            => upper(:OB_SCHEMA)',
'    );'))
,p_process_when_button_id=>wwv_flow_api.id(107490423349162293.4508)
);
end;
/
prompt --application/pages/page_00006
begin
wwv_flow_api.create_page(
 p_id=>6.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\C18D\C131 \B515\C154\B108\B9AC')
,p_step_title=>unistr('\C18D\C131 \B515\C154\B108\B9AC')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(201270629259751113)
,p_step_template=>wwv_flow_api.id(385762900697898960.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEUTL/sql_utl_user_def.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(196872320678099165.4508)
,p_plug_name=>'Navigation'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(385770331595976651.4508)
,p_plug_display_sequence=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(194504915759237345.4508)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(196867506292090262.4508)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(197497415607067300.4508)
,p_plug_name=>unistr('\C5F4 \C18D\C131')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690714020036152159.4508)
,p_plug_display_sequence=>15
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    c.column_id,',
'    s.syn_name column_name,',
'    case when c.column_name != s.syn_name',
'         then c.column_name',
'         end base_record,',
'    --',
'    c.label,',
'    c.help_text,',
'    c.format_mask,',
'    c.default_value,',
'    --',
'    c.form_format_mask,',
'    c.form_display_width,',
'    c.form_display_height,',
'    c.form_data_type,',
'    --',
'    c.report_format_mask,',
'    decode(c.report_col_alignment,',
'           ''LEFT'',l.m,''CENTER'',ctr.m,''RIGHT'',r.m,null) report_col_alignment,',
'    --',
'    c.created_by,',
'    c.created_on,',
'    c.last_updated_by,',
'    c.last_updated_on',
'  from WWV_FLOW_HNT_COLUMN_DICT c,',
'       wwv_flow_hnt_col_dict_syn s,',
'       (select wwv_flow_lang.system_message(''LEFT'') m from dual) l,',
'       (select wwv_flow_lang.system_message(''CENTER'') m from dual) ctr,',
'       (select wwv_flow_lang.system_message(''RIGHT'') m from dual) r',
' where c.security_group_id = :flow_security_group_id',
'   and c.column_id = s.column_id',
'   and s.security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(197497511891067300.4508)
,p_name=>'column attributes'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\C774 \C9C8\C758\B294 10,000\AC1C \C774\C0C1\C758 \D589\C744 \BC18\D658\D569\B2C8\B2E4. \BCF4\B2E4 \C815\D655\D55C \ACB0\ACFC\B97C \C5BB\C73C\B824\BA74 \B370\C774\D130\B97C \D544\D130\B9C1\D558\C2ED\C2DC\C624.')
,p_no_data_found_message=>unistr('\B370\C774\D130\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_col_group(
 p_id=>wwv_flow_api.id(197503401945084100.4508)
,p_name=>unistr('\C77C\BC18 \C18D\C131')
,p_display_sequence=>10
);
wwv_flow_api.create_worksheet_col_group(
 p_id=>wwv_flow_api.id(197503509910086389.4508)
,p_name=>unistr('\D3FC \D2B9\C815 \C18D\C131')
,p_display_sequence=>20
);
wwv_flow_api.create_worksheet_col_group(
 p_id=>wwv_flow_api.id(197503615105087841.4508)
,p_name=>unistr('\BCF4\ACE0\C11C \D2B9\C815 \C18D\C131')
,p_display_sequence=>30
);
wwv_flow_api.create_worksheet_col_group(
 p_id=>wwv_flow_api.id(197503919607089151.4508)
,p_name=>unistr('\D45C \D615\C2DD \D3FC \D2B9\C815 \C18D\C131')
,p_display_sequence=>40
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197497702734067305.4508)
,p_db_column_name=>'COLUMN_ID'
,p_display_order=>1
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'A'
,p_column_label=>unistr('\C5F4 ID')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197497823803067306.4508)
,p_db_column_name=>'COLUMN_NAME'
,p_display_order=>2
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'B'
,p_column_label=>unistr('\C5F4 \C774\B984')
,p_column_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:RP:P17_COLUMN_ID,F4500_LAST_VIEW:#COLUMN_ID#,6:'
,p_column_linktext=>'#COLUMN_NAME#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(198209126276365169.4508)
,p_db_column_name=>'BASE_RECORD'
,p_display_order=>3
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'AZ'
,p_column_label=>unistr('\B3D9\C758\C5B4')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197497923751067307.4508)
,p_db_column_name=>'LABEL'
,p_display_order=>4
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'C'
,p_column_label=>unistr('\B808\C774\BE14')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197498014645067307.4508)
,p_db_column_name=>'HELP_TEXT'
,p_display_order=>5
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'D'
,p_column_label=>unistr('\B3C4\C6C0\B9D0 \D14D\C2A4\D2B8')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197498129478067308.4508)
,p_db_column_name=>'FORMAT_MASK'
,p_display_order=>6
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'E'
,p_column_label=>unistr('\D615\C2DD \B9C8\C2A4\D06C')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197498230034067309.4508)
,p_db_column_name=>'DEFAULT_VALUE'
,p_display_order=>7
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'F'
,p_column_label=>unistr('\AE30\BCF8\AC12')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197498415272067310.4508)
,p_db_column_name=>'FORM_FORMAT_MASK'
,p_display_order=>9
,p_group_id=>wwv_flow_api.id(197503509910086389.4508)
,p_column_identifier=>'H'
,p_column_label=>unistr('\D3FC \D615\C2DD \B9C8\C2A4\D06C')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197498505217067311.4508)
,p_db_column_name=>'FORM_DISPLAY_WIDTH'
,p_display_order=>10
,p_group_id=>wwv_flow_api.id(197503509910086389.4508)
,p_column_identifier=>'I'
,p_column_label=>unistr('\D3FC \D45C\C2DC \B108\BE44')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197498621334067312.4508)
,p_db_column_name=>'FORM_DISPLAY_HEIGHT'
,p_display_order=>11
,p_group_id=>wwv_flow_api.id(197503509910086389.4508)
,p_column_identifier=>'J'
,p_column_label=>unistr('\D3FC \D45C\C2DC \B192\C774')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197498705818067313.4508)
,p_db_column_name=>'FORM_DATA_TYPE'
,p_display_order=>12
,p_group_id=>wwv_flow_api.id(197503509910086389.4508)
,p_column_identifier=>'K'
,p_column_label=>unistr('\D3FC \B370\C774\D130 \C720\D615')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197499906035067322.4508)
,p_db_column_name=>'REPORT_FORMAT_MASK'
,p_display_order=>13
,p_group_id=>wwv_flow_api.id(197503615105087841.4508)
,p_column_identifier=>'W'
,p_column_label=>unistr('\BCF4\ACE0\C11C \D615\C2DD \B9C8\C2A4\D06C')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197500006990067324.4508)
,p_db_column_name=>'REPORT_COL_ALIGNMENT'
,p_display_order=>14
,p_group_id=>wwv_flow_api.id(197503615105087841.4508)
,p_column_identifier=>'X'
,p_column_label=>unistr('\BCF4\ACE0\C11C \C5F4 \B9DE\CDA4')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197502421219067350.4508)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>18
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'AV'
,p_column_label=>unistr('\C0DD\C131\C790')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197502514016067351.4508)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>19
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'AW'
,p_column_label=>unistr('\C0DD\C131 \B0A0\C9DC')
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197502620316067351.4508)
,p_db_column_name=>'LAST_UPDATED_BY'
,p_display_order=>20
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'AX'
,p_column_label=>unistr('\C5C5\B370\C774\D2B8 \C218\D589\C790')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197502708086067352.4508)
,p_db_column_name=>'LAST_UPDATED_ON'
,p_display_order=>21
,p_group_id=>wwv_flow_api.id(197503401945084100.4508)
,p_column_identifier=>'AY'
,p_column_label=>unistr('\C5C5\B370\C774\D2B8 \B0A0\C9DC')
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(197652104930775557.4508)
,p_plug_name=>unistr('\C18D\C131 \B515\C154\B108\B9AC')
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(380771699411878611.4508)
,p_plug_display_sequence=>25
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\C0AC\C6A9\C790 \C778\D130\D398\C774\C2A4 \AE30\BCF8\AC12\C740 \D55C \C560\D50C\B9AC\CF00\C774\C158 \B610\B294 \C5EC\B7EC \C560\D50C\B9AC\CF00\C774\C158\C758 \C5EC\B7EC \D398\C774\C9C0 \AC04\C5D0 \C77C\AD00\C131\C744 \C81C\ACF5\D558\B294 \C601\C5ED \BC0F \D56D\BAA9 \C18D\C131\C5D0 \B300\D55C \CD08\AE30 \AC12\C744 \CC44\C6B0\B294 \B370 \C0AC\C6A9\B429\B2C8\B2E4.</p>'),
'',
unistr('<p>\C18D\C131 \B515\C154\B108\B9AC\B294 \D3FC\ACFC \BCF4\ACE0\C11C\B97C \C0DD\C131\D558\B294\B370 \C0AC\C6A9\B418\B294 \C5F4\C5D0 \B300\D55C \C18D\C131 \C9D1\D569\C744 \D3EC\D568\D569\B2C8\B2E4. \C815\C758\B294 \C5F4 \C774\B984\ACFC \C77C\CE58\D558\BA70 \D2B9\C815 \C815\C758\B294 \B3D9\C758\C5B4\B97C \C0AC\C6A9\D558\C5EC \C5EC\B7EC \C5F4\C5D0\C11C \ACF5\C720\D560 \C218 \C788\C2B5\B2C8\B2E4.</p>')))
,p_plug_column_width=>'valign=top'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(442023927001440467.4508)
,p_plug_name=>unistr('\C791\C5C5')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(380771699411878611.4508)
,p_plug_display_sequence=>90
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(442022106915434689.4508)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20507805987268923.4508)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(196941919040505465.4508)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(197497415607067300.4508)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_image_alt=>unistr('\C7AC\C124\C815')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:6,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(262152709439070830.4508)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(197497415607067300.4508)
,p_button_name=>'GRID_EDIT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(690706750701136097.4508)
,p_button_image_alt=>unistr('\ADF8\B9AC\B4DC \D3B8\C9D1')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(196240900601196384.4508)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(197497415607067300.4508)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(690706750701136097.4508)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\C0DD\C131')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:17:F4500_LAST_VIEW:6'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1019663455307233863.4508)
,p_name=>'RENDERING: Page - Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(442023927001440467.4508)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1019663721484233884.4508)
,p_event_id=>wwv_flow_api.id(1019663455307233863.4508)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var lSuccessMsg = this.data.APEX_SUCCESS_MESSAGE,',
'      lUrl = ''f?p=&APP_ID.:6:&SESSION.::'',',
'      lVal = this.data[ ''REQUEST'' ]; ',
'',
'if ( lSuccessMsg ) {',
'   lUrl += ''&success_msg='' + lSuccessMsg;',
'}',
'setTimeout(function() {',
'    apex.navigation.redirect(lUrl);',
'}, 0);'))
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\C870\D68C \D14C\C774\BE14 \C0DD\C131 \C644\B8CC')
,p_step_title=>unistr('\D14C\C774\BE14 \C0DD\C131')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215538527409730225)
,p_step_template=>wwv_flow_api.id(740688669716062470.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEUTL/obj_table.htm'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(126728219494826365.4508)
,p_computation_sequence=>20
,p_computation_item=>'P57_TABLE'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'&P602_NAME.'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(126728409921826371.4508)
,p_computation_sequence=>30
,p_computation_item=>'P42_OBJECT_ID'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_id',
'from sys.dba_objects',
'where owner = :P56_SCHEMA',
'and object_name = :P57_TABLE',
'and object_type = ''TABLE'''))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(126729024635826377.4508)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load new Object_name/type/id'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
' for r in ( select object_id,object_name,owner,object_type',
'from sys.dba_objects',
'where owner = :OB_SCHEMA',
'and object_name = :P105_NEW_TABLE_TO_BE_CREATED',
'and object_type = ''TABLE'' ) loop',
' :OBJECT_ID    := r.object_id;',
' :OBJECT_NAME  := r.object_name;',
' :OBJECT_OWNER := r.owner;',
' :OBJECT_TYPE  := r.object_type;',
'',
'end loop;',
'',
'sys.htp.p(''<script type="text/javascript">top.gSideBar.reload("TABLE",''||',
'          wwv_flow_escape.js_literal(:OBJECT_ID)||',
'          '',true);</script>'');'))
);
end;
/
prompt --application/pages/page_00008
begin
wwv_flow_api.create_page(
 p_id=>8.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\B3D9\C758\C5B4\B97C \C0DD\C131\D560 \C218 \C5C6\C74C')
,p_step_title=>unistr('\B3D9\C758\C5B4\B97C \C0DD\C131\D560 \C218 \C5C6\C74C')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(703368619593851824.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_help_text=>'AEUTL/obj_syn.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(107691211986788096.4508)
,p_plug_name=>unistr('\B3D9\C758\C5B4\B97C \C0DD\C131\D560 \C218 \C5C6\C74C')
,p_region_template_options=>'#DEFAULT#:a-Alert--danger:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(746376253838324384.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>'&P8_MSG.'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_plug_display_when_condition=>'P8_MSG'
,p_plug_display_when_cond2=>'SUCCESS'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(242968731284108170.4508)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(690697788869123307.4508)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(107691627841788100.4508)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(242968731284108170.4508)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_image_alt=>unistr('\CDE8\C18C')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4500_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(107691416204788097.4508)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(242968731284108170.4508)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(385765860428963371.4508)
,p_button_image_alt=>unistr('\C774\C804')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:127:&SESSION.::&DEBUG.:::'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(107692206615788105.4508)
,p_name=>'P8_MSG'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(107691211986788096.4508)
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'N'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(182563319407300115.4508)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load new Object'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for r in ( select object_id,object_name,owner,object_type',
' from sys.dba_objects',
' where owner = :OB_SCHEMA',
' and object_name = :P99_NAME',
' and object_type = ''SYNONYM'' ) loop',
' :OBJECT_ID    := r.object_id;',
' :OBJECT_NAME  := r.object_name;',
' :OBJECT_OWNER := r.owner;',
' :OBJECT_TYPE  := r.object_type;',
'',
'end loop;',
'sys.owa_util.redirect_url(''f?p=''||:APP_ID||'':1001:''||:SESSION||'':FOCUS:::OB_CURRENT_TYPE,OB_OBJECT_ID:''||:OBJECT_TYPE||'',''||:OBJECT_ID);',
'wwv_flow.g_unrecoverable_error := true;'))
,p_process_when=>'P8_MSG'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'SUCCESS'
);
end;
/
prompt --application/pages/page_00009
begin
wwv_flow_api.create_page(
 p_id=>9.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\D2B8\B9AC\AC70 \C0DD\C131 \D655\C778')
,p_step_title=>unistr('\D2B8\B9AC\AC70 \C0DD\C131 \D655\C778')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215538527409730225)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'    function showDDL(){',
'        theDDL = document.getElementById(''P67_SQL'');',
'        showDiv = document.getElementById(''ddlShow'');',
'        hideDiv = document.getElementById(''ddlHide'');',
'        hideDiv.style.display = ''inline'';',
'        theDDL.style.display = ''inline'';',
'        showDiv.style.display = ''none'';',
'        }',
'        ',
'    function hideDDL(){',
'        theDDL = document.getElementById(''P67_SQL'');',
'        showDiv = document.getElementById(''ddlShow'');',
'        hideDiv = document.getElementById(''ddlHide'');',
'        hideDiv.style.display = ''none'';',
'        theDDL.style.display = ''none'';',
'        showDiv.style.display = ''inline'';',
'        }',
'</script>'))
,p_step_template=>wwv_flow_api.id(703368619593851824.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_help_text=>'AEUTL/obj_trig.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(108192008291627341.4508)
,p_plug_name=>unistr('\C694\CCAD \B0B4\C6A9\C744 \D655\C778\D558\C2ED\C2DC\C624. ')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717419707883820782.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'Region generated 07-FEB-2003 18:17:26'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(108192200834627347.4508)
,p_plug_name=>'SQL'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717419046555820782.4508)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(150816405819139865.4508)
,p_plug_name=>'Progress Indicator'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(150811814776114073.4508)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(703372217110859571.4508)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(240130501844037227.4508)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(690697788869123307.4508)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752117899743695887.4508)
,p_plug_name=>unistr('\D2B8\B9AC\AC70 \C0DD\C131')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_plug_template=>wwv_flow_api.id(717420493098820783.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(108192601224627348.4508)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(240130501844037227.4508)
,p_button_name=>'FINISH'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\D2B8\B9AC\AC70 \C0DD\C131')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(108192830309627349.4508)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(240130501844037227.4508)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765860428963371.4508)
,p_button_image_alt=>unistr('\C774\C804')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:84:&SESSION.::&DEBUG.:::'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(108192406052627348.4508)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(240130501844037227.4508)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_image_alt=>unistr('\CDE8\C18C')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4500_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(108215531314676142.4508)
,p_branch_action=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(108192601224627348.4508)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(108193005205627351.4508)
,p_name=>'P9_SCHEMA'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(108192008291627341.4508)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\C2A4\D0A4\B9C8:')
,p_source=>'OB_SCHEMA'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>unistr('\C120\D0DD\D55C \D14C\C774\BE14\C744 \C18C\C720\D558\B294 \B370\C774\D130\BCA0\C774\C2A4 \C2A4\D0A4\B9C8\B97C \C2DD\BCC4\D569\B2C8\B2E4.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(108193517080627355.4508)
,p_name=>'P9_TABLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(108192008291627341.4508)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\AC1D\CCB4:')
,p_source=>'P3_TABLE'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\C120\D0DD\B41C \D14C\C774\BE14\C758 \C774\B984\C744 \C2DD\BCC4\D569\B2C8\B2E4.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(108194026282627356.4508)
,p_name=>'P9_ACTION'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(108192008291627341.4508)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\C791\C5C5:')
,p_source=>'wwv_flow_lang.system_message(''CREATE_TRIGGER'',:P84_TRIGGER_NAME);'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_protection_level=>'I'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\D14C\C774\BE14\C5D0\C11C \C218\D589\B420 \C791\C5C5 \C720\D615\C744 \C2DD\BCC4\D569\B2C8\B2E4.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(108194505205627357.4508)
,p_name=>'P9_SQL'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(108192200834627347.4508)
,p_prompt=>'SQL'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>70
,p_cMaxlength=>32767
,p_cHeight=>15
,p_tag_css_classes=>'a-Form-textarea--code'
,p_tag_attributes=>'readonly="readonly"'
,p_field_template=>wwv_flow_api.id(717397144393801382.4508)
,p_item_css_classes=>'a-Form-fieldContainer--fieldsetBlock'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
,p_item_comment=>'Generated 07-FEB-2003 18:17:26'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(108195917976627367.4508)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check privs'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_api.check_priv (',
'    p_schema => upper(:OB_SCHEMA)',
'    );'))
,p_process_error_message=>unistr('&P56_SCHEMA.\C5D0 \B300\D55C \AD8C\D55C\C774 \C5C6\C2B5\B2C8\B2E4.')
,p_process_when_button_id=>wwv_flow_api.id(108192601224627348.4508)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(108196125269627368.4508)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'run DDL'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P16_MSG := wwv_flow_sw_util.run_other_sql(',
'              p_schema     => upper(:OB_SCHEMA),',
'              p_sql        => :P9_SQL );',
'',
'for c in (select object_id from sys.dba_objects where object_name = :P84_TRIGGER_NAME and owner = :OB_SCHEMA and',
'          object_type = ''TRIGGER'') loop',
'  :object_id := c.object_id;',
'  :object_type := ''TRIGGER'';',
'end loop;'))
,p_process_when_button_id=>wwv_flow_api.id(108192601224627348.4508)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(108196325839627370.4508)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save History'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_api.save_history (',
'    p_security_group_id => :flow_security_group_id ,',
'    p_user              => :flow_user,',
'    p_sql_cmd           => :P9_SQL,',
'    p_schema            => upper(:OB_SCHEMA)',
'    );'))
,p_process_when_button_id=>wwv_flow_api.id(108192601224627348.4508)
);
end;
/
prompt --application/pages/page_00010
begin
wwv_flow_api.create_page(
 p_id=>10.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\C2A4\D06C\B9BD\D2B8 - \C2E4\D589')
,p_step_title=>unistr('\C2A4\D06C\B9BD\D2B8 \C2E4\D589')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(213236600761856491)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'//-->',
'</script>'))
,p_step_template=>wwv_flow_api.id(703368619593851824.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEUTL/sql_rep_run_script.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10048401428195635.4508)
,p_plug_name=>'Schema'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717419707883820782.4508)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(42832115592689804.4508)
,p_plug_name=>unistr('\C2A4\D06C\B9BD\D2B8 \C2E4\D589')
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(746376253838324384.4508)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_script.display_run_confirm(',
'    p_file_id => :F4500_P10_FILE_ID,',
'    p_date_time_format => ''&DATE_TIME_FORMAT.'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(722740577464798633.4508)
,p_plug_name=>unistr('\B2E8\CD94')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_plug_template=>wwv_flow_api.id(690697788869123307.4508)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(372022143187.4508)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(722740577464798633.4508)
,p_button_name=>'Cancel'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_image_alt=>unistr('\CDE8\C18C')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:1004:&SESSION.::&DEBUG.:RP:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(372007991036.4508)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(722740577464798633.4508)
,p_button_name=>'RUN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\C9C0\AE08 \C2E4\D589')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(109787703963442985.4508)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(722740577464798633.4508)
,p_button_name=>'EDIT_SCRIPT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(385765234519963355.4508)
,p_button_image_alt=>unistr('\C2A4\D06C\B9BD\D2B8 \D3B8\C9D1')
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:60:&SESSION.::&DEBUG.::P60_FILE_ID:&F4500_P10_FILE_ID.'
,p_button_condition=>'wwv_flow_sw_script.script_w_warning(p_file_id => :F4500_P10_FILE_ID)'
,p_button_condition_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(471472722487546596.4508)
,p_branch_name=>'Go To Page 1225'
,p_branch_action=>'f?p=&APP_ID.:1225:&SESSION.::&DEBUG.:RP,1225:P1224_RESULT_ID:&P10_RESULT_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(29063885017.4508)
,p_name=>'P10_RUN_AS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(387994680244652086.4508)
,p_prompt=>unistr('\C2A4\D0A4\B9C8')
,p_source=>'wwv_flow_user_api.get_default_schema'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LIST_AVAILABLE_SCHEMAS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  q      varchar2(32767) := null;',
'begin  ',
'  q:=''select wwv_flow_escape.html(upper(c.schema)) d, upper(c.schema) v '';',
'  q:=q||''from   wwv_flow_company_schemas c, '';',
'  q:=q||''       wwv_flow_fnd_user u '';',
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';',
'  q:=q||''       u.user_name = :flow_user and '';',
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';',
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';',
'  q:=q||''order by 1'';  ',
'  return q;',
'end;'))
,p_cHeight=>1
,p_tag_attributes=>'class="a-Form-select"'
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(488671029226029669.4508)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>unistr('\C774 \C2A4\D06C\B9BD\D2B8\B97C \C2E4\D589\D560 \B370\C774\D130\BCA0\C774\C2A4 \C2A4\D0A4\B9C8(\B610\B294 \C0AC\C6A9\C790 \C774\B984)\B97C \C120\D0DD\D558\C2ED\C2DC\C624.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(29128987183.4508)
,p_name=>'F4500_P10_FILE_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(42832115592689804.4508)
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(16826800561032587.4508)
,p_name=>'P10_RESULT_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(10048401428195635.4508)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(145945111357011245.4508)
,p_name=>'P10_SCRIPT_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(42832115592689804.4508)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select filename',
'from wwv_flow_files',
'where id = :F4500_P10_FILE_ID',
'and file_type = ''SCRIPT'''))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(18056327424.4508)
,p_validation_name=>'Must Select Run As'
,p_validation_sequence=>10
,p_validation=>'P10_RUN_AS'
,p_validation_type=>'ITEM_NOT_ZERO'
,p_error_message=>unistr('\C774 \C2A4\D06C\B9BD\D2B8\B97C \C2E4\D589\D558\B824\BA74 Oracle Schema(\C0AC\C6A9\C790 \C774\B984)\B97C \C9C0\C815\D574\C57C \D569\B2C8\B2E4.  ')
,p_validation_condition=>'RUN,RUN_IN_BACKGROUND'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(29063885017.4508)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(128081917428230107.4508)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'check priv'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_api.check_priv (',
'    p_schema => :P10_RUN_AS',
'    );'))
,p_process_error_message=>unistr('\AD8C\D55C\C744 \AC80\C0AC\D558\B294 \C911 \C624\B958\AC00 \BC1C\C0DD\D588\C2B5\B2C8\B2E4.')
,p_process_when_button_id=>wwv_flow_api.id(372007991036.4508)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(19995201456899729.4508)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set sort preference'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_preferences.set_preference(',
'p_preference=>''FSP4500_P1220_R11177418830226625_SORT'',',
'p_value => ''fsp_sort_8'',',
'p_user => v(''USER''));'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(210368638674469028.4508)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'submit script'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P10_RESULT_ID := wwv_flow_sw_script.submit_to_run (',
'                   p_file_id  => :F4500_P10_FILE_ID,',
'                   p_run_by   => :APP_USER,',
'                   p_run_as   => :P10_RUN_AS',
'                   );'))
,p_process_error_message=>unistr('\C2E4\D589\D560 \C2A4\D06C\B9BD\D2B8\B97C \C81C\CD9C\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(9321931833012508.4508)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'run script'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_script.run_file',
'      (p_result_id => :P10_RESULT_ID,',
'       p_file_id => :F4500_P10_FILE_ID,       ',
'       p_schema    => :P10_RUN_AS,',
'       p_run_by  => :APP_USER);'))
,p_process_error_message=>unistr('\C2A4\D06C\B9BD\D2B8\B97C \C2E4\D589\D560 \C218 \C5C6\C2B5\B2C8\B2E4.')
,p_process_when_button_id=>wwv_flow_api.id(372007991036.4508)
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_api.create_page(
 p_id=>11.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \BAA8\B2C8\D130')
,p_step_title=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \BAA8\B2C8\D130')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(206250111084432914)
,p_step_template=>wwv_flow_api.id(385762900697898960.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(206059717799303330)
,p_help_text=>'AEUTL/dbadm_montitor.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(133796225310429187.4508)
,p_plug_name=>unistr('\C791\C5C5')
,p_icon_css_classes=>'icon-region-native-flash-chart5'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(703386252988943977.4508)
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(133792932105421631.4508)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(704358525679957526.4508)
);
end;
/
prompt --application/pages/page_00012
begin
wwv_flow_api.create_page(
 p_id=>12.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('DDL \C0DD\C131')
,p_step_title=>unistr('DDL \C0DD\C131')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(690783685471803190.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEUTL/sql_utl_ddl.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1486819378945387.4508)
,p_plug_name=>unistr('\C2A4\D0A4\B9C8 \AC1D\CCB4')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690714020036152159.4508)
,p_plug_display_sequence=>11
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select owner schema_owner, ',
'       sum(decode(object_type,''TABLE'',1,0)) tables,',
'       sum(decode(object_type,''VIEW'',1,0)) views,',
'       sum(decode(object_type,''PACKAGE'',1,0)) packages,',
'       sum(decode(object_type,''PROCEDURE'',1,0)) procedures,',
'       sum(decode(object_type,''FUNCTION'',1,0)) functions,',
'       sum(decode(object_type,''TRIGGER'',1,0)) triggers,',
'       sum(decode(object_type,''SYNONYM'',1,0)) synonyms,',
'       sum(decode(object_type,''TYPE'',1,0)) types,',
'       sum(decode(object_type,''SEQUENCE'',1,0)) sequences,',
'       sum(decode(object_type,''INDEX'',1,0)) indexes,',
'       sum(decode(object_type,''DATABASE LINK'',1,0)) database_links,',
'       sum(decode(object_type,''MATERIALIZED VIEW'',1,0)) materialized_views',
'from (',
'select owner, object_type, object_name',
'from sys.dba_objects where owner in (',
'select c.schema',
'from   wwv_flow_company_schemas c,',
'       wwv_flow_fnd_user u',
'where  c.security_group_id = :flow_security_group_id and',
'       u.security_group_id = :flow_security_group_id and',
'       u.user_name = :flow_user and',
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or',
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0))',
') x',
'group by owner'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1486931056945387.4508)
,p_name=>'Schema Objects'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\C774 \C9C8\C758\B294 10,000\AC1C \C774\C0C1\C758 \D589\C744 \BC18\D658\D569\B2C8\B2E4. \BCF4\B2E4 \C815\D655\D55C \ACB0\ACFC\B97C \C5BB\C73C\B824\BA74 \B370\C774\D130\B97C \D544\D130\B9C1\D558\C2ED\C2DC\C624.')
,p_no_data_found_message=>unistr('\B370\C774\D130\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1487112568945421.4508)
,p_db_column_name=>'SCHEMA_OWNER'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\C2A4\D0A4\B9C8')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1487206500945426.4508)
,p_db_column_name=>'TABLES'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\D14C\C774\BE14')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1487310320945426.4508)
,p_db_column_name=>'VIEWS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\BDF0')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1487409322945426.4508)
,p_db_column_name=>'PACKAGES'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\D328\D0A4\C9C0')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1487510143945426.4508)
,p_db_column_name=>'PROCEDURES'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\D504\B85C\C2DC\C800')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1487601504945427.4508)
,p_db_column_name=>'FUNCTIONS'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('\D568\C218')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1487703932945427.4508)
,p_db_column_name=>'TRIGGERS'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\D2B8\B9AC\AC70')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1487827146945427.4508)
,p_db_column_name=>'SYNONYMS'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('\B3D9\C758\C5B4')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1487904312945427.4508)
,p_db_column_name=>'TYPES'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('\C720\D615')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1488006466945427.4508)
,p_db_column_name=>'SEQUENCES'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('\C2DC\D000\C2A4')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1488122175945427.4508)
,p_db_column_name=>'INDEXES'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>unistr('\C778\B371\C2A4')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1488212701945428.4508)
,p_db_column_name=>'DATABASE_LINKS'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>unistr('\B370\C774\D130\BCA0\C774\C2A4 \B9C1\D06C')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1488332313945428.4508)
,p_db_column_name=>'MATERIALIZED_VIEWS'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>unistr('\AD6C\CCB4\D654\B41C \BDF0')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(112022311206824401.4508)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1486819378945387.4508)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(690706750701136097.4508)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\C2A4\D06C\B9BD\D2B8 \C791\C131')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(698586606001530549.4508)
,p_name=>'On Close Modal'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(112022311206824401.4508)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(698586727765530550.4508)
,p_event_id=>wwv_flow_api.id(698586606001530549.4508)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(1486819378945387.4508)
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var lSuccessMsg = this.data.APEX_SUCCESS_MESSAGE,',
'    lUrl        = ''f?p=4500:1004:&SESSION.::&DEBUG.:'';',
'',
'if ( lSuccessMsg ) {',
'   lUrl += ''&success_msg='' + lSuccessMsg;',
'}',
' setTimeout(function() {',
'    apex.navigation.redirect(lUrl);',
'}, 0);'))
);
end;
/
prompt --application/pages/page_00013
begin
wwv_flow_api.create_page(
 p_id=>13.4508
,p_user_interface_id=>wwv_flow_api.id(4969205754302342.4508)
,p_name=>unistr('\B370\C774\D130 \B514\B809\D1A0\B9AC')
,p_step_title=>unistr('\B370\C774\D130 \B514\B809\D1A0\B9AC')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(11093307704620192)
,p_step_template=>wwv_flow_api.id(690783685471803190.4508)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12524102140541924)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEUTL/sql_utl_objs.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11600917523650714.4508)
,p_plug_name=>'schema owner'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690697788869123307.4508)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(441230013633249819.4508)
,p_plug_name=>unistr('\BAA8\B4E0 \AC1D\CCB4')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(690714020036152159.4508)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select DISTINCT o.object_name, c.comments',
'  from sys.all_objects o, sys.all_tab_comments c',
'  where o.owner = c.owner',
'    and o.object_name = c.table_name',
'    and o.object_type = ''VIEW'' ',
'    and (o.owner = ''SYS'' or ',
'         o.owner like ''FLOWS_%'' or',
'         o.owner like ''APEX_%'')',
'    and (o.object_name like ''USER%'' or',
'         o.object_name like ''ALL%'' or',
'         o.object_name like ''APEX_%'')'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_plug_query_parse_override=>'P13_SCHEMA'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(441230131418249819.4508)
,p_name=>'All Objects'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\C774 \C9C8\C758\B294 10,000\AC1C \C774\C0C1\C758 \D589\C744 \BC18\D658\D569\B2C8\B2E4. \BCF4\B2E4 \C815\D655\D55C \ACB0\ACFC\B97C \C5BB\C73C\B824\BA74 \B370\C774\D130\B97C \D544\D130\B9C1\D558\C2ED\C2DC\C624.')
,p_no_data_found_message=>unistr('\B370\C774\D130\B97C \CC3E\C744 \C218 \C5C6\C2B5\B2C8\B2E4.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(441230306780249821.4508)
,p_db_column_name=>'OBJECT_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\AC1D\CCB4 \C774\B984')
,p_column_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.::F4500_P14_OBJECT_NAME,F4500_P15_PARSE_STMT_AS:#OBJECT_NAME#,&P13_SCHEMA.'
,p_column_linktext=>'#OBJECT_NAME#'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(441230423945249822.4508)
,p_db_column_name=>'COMMENTS'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\C124\BA85')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(72492410848555529.4508)
,p_branch_action=>'13'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(465515900436190.4508)
,p_name=>'P13_SCHEMA'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(11600917523650714.4508)
,p_item_default=>'wwv_flow_user_api.get_default_schema'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('\C2A4\D0A4\B9C8')
,p_source=>'wwv_flow_user_api.get_default_schema'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LIST_AVAILABL