prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4355
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4355 - Oracle APEX Workspace Administration
--
-- Application Export:
--   Application:     4355
--   Name:            Oracle APEX Workspace Administration
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                    126
--       Items:                  257
--       Computations:            29
--       Validations:             88
--       Processes:              101
--       Regions:                402
--       Buttons:                226
--       Dynamic Actions:         36
--     Shared Components:
--       Logic:
--         Items:                  8
--         Processes:              2
--         Computations:           4
--         Build Options:          3
--       Navigation:
--         Lists:                 34
--         Breadcrumbs:            1
--           Entries:            120
--         NavBar Entries:         4
--       Security:
--         Authentication:         1
--         Authorization:         12
--       User Interface:
--         Templates:
--           Page:                 9
--           Region:              41
--           Label:               12
--           List:                14
--           Popup LOV:            1
--           Calendar:             2
--           Breadcrumb:           2
--           Button:              13
--           Report:               9
--         LOVs:                  59
--         Shortcuts:              3
--         Plug-ins:              12
--       Globalization:
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Workspace Administration')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286624071627923061')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt=>'59558075A3FE81DB011B5D7DBE6C1948FC163FC46B10F1DAAA23B861B1AB4902'
,p_checksum_salt_last_reset=>'20141222083238'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'pt-br'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(539691214090646644.4355)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_runtime_api_usage=>'W'
,p_security_scheme=>wwv_flow_api.id(1367105411776376234)
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'LOGOUT'
,p_substitution_value_01=>'Log-out'
,p_substitution_string_02=>'PRODUCT_NAME'
,p_substitution_value_02=>'Application Express'
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>unistr('Espa\00E7o de Trabalho: &COMPANY.')
,p_substitution_string_04=>'MSG_LANGUAGE'
,p_substitution_value_04=>'Idioma'
,p_substitution_string_05=>'MSG_COPYRIGHT'
,p_substitution_value_05=>'Copyright &copy; 1999, 2019, Oracle. Todos os direitos reservados.'
,p_substitution_string_06=>'MSG_USER'
,p_substitution_value_06=>unistr('Usu\00E1rio')
,p_substitution_string_07=>'MSG_JSCRIPT'
,p_substitution_value_07=>unistr('Voc\00EA deve executar este produto com o JavaScript ativado.')
,p_substitution_string_08=>'MSG_TBL_SUMMARY'
,p_substitution_value_08=>unistr('Tabela de Layout de P\00E1gina')
,p_substitution_string_09=>'DONE'
,p_substitution_value_09=>unistr('Conclu\00EDdo')
,p_substitution_string_10=>'TOP'
,p_substitution_value_10=>'Superior'
,p_substitution_string_11=>'CLOSE'
,p_substitution_value_11=>'Fechar'
,p_substitution_string_12=>'EDIT'
,p_substitution_value_12=>'Editar'
,p_substitution_string_13=>'DATE_FORMAT'
,p_substitution_value_13=>'dd/mm/rr'
,p_substitution_string_14=>'LONG_DATE_FORMAT'
,p_substitution_value_14=>'fmDay dd "de" Month "de" yyyy'
,p_substitution_string_15=>'TIME_FORMAT'
,p_substitution_value_15=>'hh24:mi:ss'
,p_substitution_string_16=>'DATE_TIME_FORMAT'
,p_substitution_value_16=>'dd/mm/rr hh24:mi:ss'
,p_substitution_string_17=>'DELETE_MSG'
,p_substitution_value_17=>unistr('Gostaria de executar esta a\00E7\00E3o de exclus\00E3o?')
,p_substitution_string_18=>'HELP'
,p_substitution_value_18=>'Ajuda'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141148'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(882616872498402.4355)
,p_name=>'monitor.reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(883603843504111.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('P\00E1ginas mais Exibidas em Todos os Aplicativos')
,p_list_item_link_target=>'f?p=&APP_ID.:190:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(886617134517436.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Calend\00E1rio Mensal de Views de P\00E1gina por Dia')
,p_list_item_link_target=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_calendar.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9402215610184148.4355)
,p_list_item_display_sequence=>33
,p_list_item_link_text=>unistr('Gr\00E1fico de Linhas do Uso por Dia')
,p_list_item_link_target=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1027331717491838.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Por Desempenho Ponderado de P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(231672816230382135.4355)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('Desempenho do Armazenamento da P\00E1gina no Cache por Aplicativo')
,p_list_item_link_target=>'f?p=&APP_ID.:67:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_required_patch=>wwv_flow_api.id(231647503239340557.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(231673121771383712.4355)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('Desempenho do Armazenamento da P\00E1gina no Cache por P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:61:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_required_patch=>wwv_flow_api.id(231647503239340557.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(486724123619155183.4355)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('Views de P\00E1gina da Websheet')
,p_list_item_link_target=>'f?p=&APP_ID.:94:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/user_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(4869427763068324.4355)
,p_name=>'user reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(182264209824455263.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Utiliza\00E7\00E3o do Tablespace de Esquema')
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(67222825207706896.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Privil\00E9gios de Banco de Dados por Esquema')
,p_list_item_link_target=>'f?p=&APP_ID.:86:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4936425863455707.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Esquemas do Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=&APP_ID.:72:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47074825204475016.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Utiliza\00E7\00E3o de Tablespaces do Relat\00F3rio (popup)')
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(199868595682626900.4355)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Log da Atividade do Servi\00E7o Web')
,p_list_item_link_target=>'f?p=&APP_ID.:77:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/task_request_storage
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6621926453040443.4355)
,p_name=>'task.request.storage'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6623112732045993.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Solicitar Armazenamento'
,p_list_item_link_target=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/error_reporting
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(9787313686564805.4355)
,p_name=>'Error Reporting'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9787701696570857.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Erros do Aplicativo'
,p_list_item_link_target=>'f?p=&APP_ID.:62:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/p22_application_changes
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(22853420277011168.4355)
,p_name=>'p22 Application Changes'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20238719980680877.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Por Desenvolvedor'
,p_list_item_link_target=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9828203951309455.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Por Gr\00E1fico de Barras do Desenvolvedor')
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_piechart.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1760803479628418008.4355)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Por Desenvolvedor por Hora'
,p_list_item_link_target=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6684624783765017.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Por Dia'
,p_list_item_link_target=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1175007942169208.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Por Aplicativo'
,p_list_item_link_target=>'f?p=&APP_ID.:38:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(58181920001360047.4355)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Altera\00E7\00F5es no Aplicativo, detalhadas')
,p_list_item_link_target=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(42038019608233730.4355)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Por Dia, View Mensal'
,p_list_item_link_target=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_calendar.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(166218023992861164.4355)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('Gr\00E1fico de Utiliza\00E7\00E3o de Componentes')
,p_list_item_link_target=>'f?p=&APP_ID.:97:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_login_access
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(26405214790138770.4355)
,p_name=>'monitor.login_access'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(26405620677140498.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Tentativas de Log-in'
,p_list_item_link_target=>'f?p=&APP_ID.:70:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(42725912639812593.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Tentativas de Log-in pelo Resultado da Autentica\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10275514161901974.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Resumo de Log-in do Desenvolvedor'
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_websheet_database_objects
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(26634012226707545.4355)
,p_name=>'manage websheet database objects'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(26634606470715299.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Remover Objetos do Banco de Dados da Websheet'
,p_list_item_link_target=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_setup.setup_exists then',
'  return true;',
'else',
'  return false;',
'end if;'))
,p_list_text_01=>'Eliminar objetos do banco de dados do Websheet e dados do seu esquema.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(26634814089717510.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Validar Objetos do Banco de Dados da Websheet'
,p_list_item_link_target=>'f?p=&APP_ID.:2020:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-validate-websheet-database'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_setup.setup_exists then',
'  return true;',
'else',
'  return false;',
'end if;'))
,p_list_text_01=>'Validar a integridade dos objetos de banco de dados do Websheet e problemas corretos identificados.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(32740318925964227.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Criar Objetos do Banco de Dados da Websheet'
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if not wwv_flow_ws_setup.setup_exists then',
'  return true;',
'else',
'  return false;',
'end if;'))
,p_list_text_01=>unistr('Criar objetos do banco de dados necess\00E1rios para armazenar dados do Websheet.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_websheet_database_object_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(33675020974963348.4355)
,p_name=>'create websheet database object progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33675402058967381.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Esquema e Objetos'
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33675605522968427.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Confirmar'
,p_list_item_link_target=>'f?p=&APP_ID.:1020:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1020'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_caching
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(41424809053067534.4355)
,p_name=>'Manage Caching'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(41425317018069852.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Expurgar Regi\00F5es Armazenadas no Cache por Regi\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:301:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>unistr('Expurgue o cache de uma regi\00E3o, selecionando uma ou mais regi\00F5es.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10313118719357406.4355)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>unistr('Expurgar Regi\00F5es Armazenadas no Cache por Aplicativo')
,p_list_item_link_target=>'f?p=&APP_ID.:303:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>unistr('Expurgar todas as regi\00F5es armazenadas no cache do aplicativo especificado.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10314514001365509.4355)
,p_list_item_display_sequence=>12
,p_list_item_link_text=>unistr('Expurgar Regi\00F5es Armazenadas no Cache por Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>unistr('Expurgar todas as regi\00F5es armazenadas no cache do espa\00E7o de trabalho atual.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(41425624290071958.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Expurgar P\00E1ginas Armazenadas no Cache por P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:302:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>unistr('Expurgue todas as regi\00F5es armazenadas em uma p\00E1gina, selecionando uma ou mais p\00E1ginas.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10316706991382400.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Expurgar P\00E1ginas Armazenadas no Cache por Aplicativo')
,p_list_item_link_target=>'f?p=&APP_ID.:304:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>unistr('Expurgar todas as p\00E1ginas armazenadas no cache do aplicativo especificado.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10318214741394151.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Expurgar P\00E1ginas Armazenadas no Cache Expiradas por Aplicativo')
,p_list_item_link_target=>'f?p=&APP_ID.:90:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>unistr('Expurgar somente p\00E1ginas armazenadas no cache que expiraram no aplicativo especificado.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_workspace
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(41758527939236654.4355)
,p_name=>'Manage Workspace'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(41759000215236656.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Fazer uma Solicita\00E7\00E3o de Servi\00E7o')
,p_list_item_link_target=>'f?p=&APP_ID.:96:&SESSION.::&DEBUG.:49:::'
,p_list_item_icon=>'icon-admin-service-request'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_list_text_01=>unistr('Solicitar acesso a um esquema do banco de dados, armazenamento adicional ou encerrar o espa\00E7o de trabalho.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47234208185608874.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Definir Prefer\00EAncias do Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-admin-workspace-preferences'
,p_list_text_01=>unistr('Configurar a funcionalidade dispon\00EDvel para desenvolvedores dentro deste espa\00E7o de trabalho.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(173249312901228720.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Editar Mensagem'
,p_list_item_link_target=>'f?p=&APP_ID.:35:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-admin-edit-announcement'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_text_01=>unistr('Edite a Mensagem do Espa\00E7o de Trabalho.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168269607070943956.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Utiliza\00E7\00E3o do Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-admin-workspace-utilization'
,p_list_text_01=>unistr('Exibir o relat\00F3rio de resumo do espa\00E7o de trabalho, incluindo esquema e detalhes da atividade.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'101'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_logs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(41778218420271753.4355)
,p_name=>'Manage Logs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(41778402469271753.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Gerenciar Log de Atividades do Desenvolvedor'
,p_list_item_link_target=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:RP,30:::'
,p_list_item_icon=>'htmldb/icons/pt_process.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'30'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(42463902076904417.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Gerenciar Log de Contagem de Cliques'
,p_list_item_link_target=>'f?p=&APP_ID.:84:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_process.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'84'
);
end;
/
prompt --application/shared_components/navigation/lists/page_21_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(41809121808367332.4355)
,p_name=>'Page 21 Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492151931609850014.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Relat\00F3rios Salvos')
,p_list_item_link_target=>'f?p=&APP_ID.:98:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-download-xlif-translation '
,p_list_text_01=>unistr('Avalie relat\00F3rios salvos de aplicativos da \00C1rea de Trabalho e de Websheets. Os relat\00F3rios, diferente do Padr\00E3o Principal, tamb\00E9m podem ser exclu\00EDdos.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48515414990925228.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Inscri\00E7\00F5es')
,p_list_item_link_target=>'f?p=&APP_ID.:92:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-subscriptions'
,p_list_text_01=>unistr('Avalie inscri\00E7\00F5es de aplicativos da \00C1rea de Trabalho. Qualquer inscri\00E7\00E3o tamb\00E9m pode ser exclu\00EDda.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/administration_home
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(46082227723554970.4355)
,p_name=>'Administration - Home'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46083626824639868.4355)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('Gerenciar Servi\00E7o')
,p_list_item_link_target=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-manage-service'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46082624737563617.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Gerenciar Usu\00E1rios e Grupos')
,p_list_item_link_target=>'f?p=&APP_ID.:55:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-manage-users'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46083204567576672.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Monitorar Atividade'
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-monitor-activity'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_security_scheme=>wwv_flow_api.id(47302021031728224)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47341025593948125.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Pain\00E9is de Controle')
,p_list_item_link_target=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-dashboards'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_security_scheme=>wwv_flow_api.id(47302021031728224)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20635613776358966.4355)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Relat\00F3rio de Utiliza\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'admin-utilization-report'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/dashboards
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(46989621592546067.4355)
,p_name=>'Dashboards'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47002219860895685.4355)
,p_list_item_display_sequence=>8
,p_list_item_link_text=>unistr('Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'33'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46989826094547451.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Usu\00E1rios')
,p_list_item_link_target=>'f?p=&APP_ID.:60:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'60'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46991211942571754.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Atividade'
,p_list_item_link_target=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'13'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47333325078635734.4355)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Atividade do Desenvolvedor'
,p_list_item_link_target=>'f?p=&APP_ID.:71:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'71'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47357220547457512.4355)
,p_list_item_display_sequence=>27
,p_list_item_link_text=>'Desempenho'
,p_list_item_link_target=>'f?p=&APP_ID.:78:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'78'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47440329895210523.4355)
,p_list_item_display_sequence=>28
,p_list_item_link_text=>'Websheets'
,p_list_item_link_target=>'f?p=&APP_ID.:81:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'81'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47998210717122914.4355)
,p_list_item_display_sequence=>29
,p_list_item_link_text=>'Aplicativos'
,p_list_item_link_target=>'f?p=&APP_ID.:91:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'91'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47392009342570705.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Banco de Dados'
,p_list_item_link_target=>'f?p=&APP_ID.:79:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'79'
);
end;
/
prompt --application/shared_components/navigation/lists/users_and_groups_apex_4_0
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47054717520943020.4355)
,p_name=>'users and groups APEX 4.0'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47055126870945672.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Usu\00E1rios')
,p_list_item_link_target=>'f?p=&APP_ID.:55:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'55'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47055330333946679.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Grupos'
,p_list_item_link_target=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'53'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(132385410060946836.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Designa\00E7\00F5es de Grupos')
,p_list_item_link_target=>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.:RP,51:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_service_manage_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47244730835700645.4355)
,p_name=>'manage service / manage tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(563487671205228278.4355)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('Cache do Dicion\00E1rio de Dados')
,p_list_item_link_target=>'f?p=&APP_ID.:800:&SESSION.::&DEBUG.:RP,800:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47245532136719927.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Logs de Atividade do Desenvolvedor e de Contagem de Cliques'
,p_list_item_link_target=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_process.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47246012527723718.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Estado da Sess\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:36:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_process.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47246916814734445.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Cache do Aplicativo'
,p_list_item_link_target=>'f?p=&APP_ID.:47:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_process.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47247422140745413.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Gerenciar Objetos do Banco de Dados da Websheet'
,p_list_item_link_target=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_process.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47252112237827709.4355)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Status do Build do Aplicativo'
,p_list_item_link_target=>'f?p=&APP_ID.:41:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_process.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168483331958366150.4355)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('Utiliza\00E7\00E3o do Arquivo')
,p_list_item_link_target=>'f?p=&APP_ID.:85:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(493060207510038405.4355)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('Defini\00E7\00F5es do Relat\00F3rio Interativo')
,p_list_item_link_target=>'f?p=&APP_ID.:104:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_49_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47296115483238304.4355)
,p_name=>'page 49 tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47296330028242448.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Relat\00F3rio Detalhado de Utiliza\00E7\00E3o de Tablespaces')
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177278408603201894.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Cadastrar-se em outro espa\00E7o de trabalho')
,p_list_item_link_target=>'f?p=4700:1:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference( p_preference_name => ''SERVICE_REQUEST_FLOW'' ) <> ''MANUAL'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/request_train
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47297014014256767.4355)
,p_name=>'request train'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168280130450988464.4355)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('Identificar Solicita\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:96:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'96'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47297223018259334.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Definir Solicita\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'49,48,50'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47297426827260442.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Confirmar'
,p_list_item_link_target=>'f?p=&APP_ID.:69:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'69,510,66'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_activity_calendar_views
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47721323591663284.4355)
,p_name=>'monitor activity / calendar views'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47721606407667742.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Altera\00E7\00F5es por Desenvolvedor')
,p_list_item_link_target=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'20'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47721810909669094.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Novas P\00E1ginas Criadas pelo Desenvolvedor')
,p_list_item_link_target=>'f?p=&APP_ID.:82:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'82'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47768504965263316.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Altera\00E7\00F5es de P\00E1gina por Dia')
,p_list_item_link_target=>'f?p=&APP_ID.:89:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'89'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_session_state_2
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(49193021558761543.4355)
,p_name=>'Manage Session State 2'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(49193803030761544.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Sess\00F5es Recentes')
,p_list_item_link_target=>'f?p=&APP_ID.:43:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-recent-sessions'
,p_list_text_01=>unistr('Avalie sess\00F5es recentes, com a possibilidade de detalhar uma sess\00E3o individual e exibir os itens armazenados no estado dessa sess\00E3o.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(49233018235845734.4355)
,p_list_item_display_sequence=>21
,p_list_item_link_text=>unistr('Estado da Sess\00E3o da Sess\00E3o Atual')
,p_list_item_link_target=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-report-session-state'
,p_list_text_01=>unistr('Exiba um relat\00F3rio de todos os itens armazenados no estado da sua sess\00E3o atual.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(49194117294761544.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Expurgar Sess\00F5es por idade')
,p_list_item_link_target=>'f?p=&APP_ID.:45:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>unistr('Expurgue as informa\00E7\00F5es salvas do estado da sess\00E3o mais antigas que o per\00EDodo especificado.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(49193217092761543.4355)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('Expurgar Estado da Sess\00E3o para a Sess\00E3o Atual')
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>unistr('Expurgue as informa\00E7\00F5es do estado da sess\00E3o armazenadas para sua sess\00E3o atual.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_preferences_home
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(49208419658798799.4355)
,p_name=>'Manage Preferences Home'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(49209216188798800.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Prefer\00EAncias por Usu\00E1rio')
,p_list_item_link_target=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-preferences-by-user'
,p_list_text_01=>unistr('Analise as prefer\00EAncias salvas por usu\00E1rios individuais.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(49237210055852837.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Prefer\00EAncias do Usu\00E1rio Atual')
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-report-session-state'
,p_list_text_01=>unistr('Exiba as prefer\00EAncias que foram salvas.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(49209526179798800.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Prefer\00EAncias de Expurga\00E7\00E3o por Usu\00E1rio')
,p_list_item_link_target=>'f?p=&APP_ID.:46:&SESSION.::&DEBUG.:46:::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>unistr('Expurgue prefer\00EAncias salvas de um usu\00E1rio espec\00EDfico.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(49208912194798800.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Prefer\00EAncias de Expurga\00E7\00E3o do Usu\00E1rio Atual')
,p_list_item_link_target=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>unistr('Expurgue as prefer\00EAncias que foram salvas.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/environment_monitoring_options
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(56633624548029155.4355)
,p_name=>'environment monitoring options'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(56635027334029158.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Por Agente de Usu\00E1rio')
,p_list_item_link_target=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(56635314999029158.4355)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Por Browser'
,p_list_item_link_target=>'f?p=&APP_ID.:64:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(56635603329029158.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Por Clique Externo'
,p_list_item_link_target=>'f?p=&APP_ID.:34:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(56635916722029158.4355)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Por Sistema Operacional'
,p_list_item_link_target=>'f?p=&APP_ID.:63:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_charts
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(61339238287578026.4355)
,p_name=>'monitor.charts'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(26641602494492148.4355)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Por View'
,p_list_item_link_target=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15610782962052240.4355)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('Por Usu\00E1rio')
,p_list_item_link_target=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1760816402430436488.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Por Usu\00E1rio e Hora')
,p_list_item_link_target=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(26157704446429203.4355)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Por Aplicativo'
,p_list_item_link_target=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30526206851676352.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Por Aplicativo e P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:75:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9443402534511474.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Por Dia'
,p_list_item_link_target=>'f?p=&APP_ID.:74:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47745331041053325.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Por Hora'
,p_list_item_link_target=>'f?p=&APP_ID.:87:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(196265008149398549.4355)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Por Relat\00F3rio Interativo')
,p_list_item_link_target=>'f?p=&APP_ID.:93:&SESSION.::&DEBUG.:RIR:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_apex_demo_objects
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(161065115373372140.4355)
,p_name=>'Manage APEX$DEMO Objects'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/create_apex_demo_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(161192747617951712.4355)
,p_name=>'Create APEX$Demo progress'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/activity_log_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(162250901435797798.4355)
,p_name=>'Activity Log List'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(162251210785800461.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Atividade em Tempo Real'
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'22'
);
end;
/
prompt --application/shared_components/navigation/lists/summary_log_pages
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(162256322822822923.4355)
,p_name=>'summary log pages'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(162256503352822924.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Por Aplicativo, por Dia'
,p_list_item_link_target=>'f?p=&APP_ID.:352:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(219127363831431945.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Hash no Aplicativo por Dia'
,p_list_item_link_target=>'f?p=&APP_ID.:103:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(162257102425822925.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Por Aplicativo'
,p_list_item_link_target=>'f?p=&APP_ID.:354:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880569998372629663.4355)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Gr\00E1fico da Atividade do Espa\00E7o de Trabalho por Dia')
,p_list_item_link_target=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/component_utilization
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(166186215913459085.4355)
,p_name=>'Component Utilization'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(166186401888459086.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Relat\00F3rio de Utiliza\00E7\00E3o de Componente Nativo')
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(166186830094459086.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Gr\00E1fico de Utiliza\00E7\00E3o de Componente Nativo')
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/admin_tasks_page_3
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(166211911060758908.4355)
,p_name=>'admin_tasks_page_3'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16347303877035542.4355)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Alterar Minha Senha'
,p_list_item_link_target=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:3::#pwd'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_security_scheme=>wwv_flow_api.id(1309004604808814)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(139295512478299018.4355)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Sobre o &PRODUCT_NAME.'
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30385011201348523.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Monitorar Atividade'
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'1'
,p_security_scheme=>wwv_flow_api.id(178931223495737450)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(30385223668352082.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Gerenciar Servi\00E7o')
,p_list_item_link_target=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'1'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46969711288174181.4355)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Gerenciar Grupos de Usu\00E1rios')
,p_list_item_link_target=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46981012486411024.4355)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('Criar Usu\00E1rio')
,p_list_item_link_target=>'f?p=&APP_ID.:52:&SESSION.::&DEBUG.:52,EDIT_USER_PRIVS:::'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46981208807419423.4355)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('Criar V\00E1rios Usu\00E1rios')
,p_list_item_link_target=>'f?p=&APP_ID.:99:&SESSION.::&DEBUG.:99:::'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(487230503095185923.4355)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('Excluir V\00E1rios Usu\00E1rios')
,p_list_item_link_target=>'f?p=&APP_ID.:57:&SESSION.::&DEBUG.:RIR:::'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492151212216844406.4355)
,p_list_item_display_sequence=>104
,p_list_item_link_text=>unistr('Gerenciar Defini\00E7\00F5es do Relat\00F3rio Interativo')
,p_list_item_link_target=>'f?p=&APP_ID.:104:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168469522898909489.4355)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('Gerenciar Reposit\00F3rio de Exporta\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:150:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>'return not wwv_flow.apps_only_workspace;'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168861426713853535.4355)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Gerenciar Objetos do Banco de Dados da Websheet'
,p_list_item_link_target=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(47302021031728224)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(621160827306560828.4355)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('Solicitar um Novo Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=4700:1:&APP_SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_sessions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(167617332155424156.4355)
,p_name=>'monitor.sessions'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(167617812546427943.4355)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('Sess\00F5es Ativas')
,p_list_item_link_target=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(9410309863267579.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Gr\00E1fico de Barras de Sess\00F5es Ativas por Hora')
,p_list_item_link_target=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_barchart.png'
,p_list_item_icon_attributes=>'alt="" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/saved_ir_view_mode
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(492707417463467235.4355)
,p_name=>'saved_ir_view_mode'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492708632354471515.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Relat\00F3rios de Aplicativo de Banco de Dados')
,p_list_item_link_target=>'f?p=&APP_ID.:98:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'98'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492708806512473583.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Relat\00F3rios de Aplicativos de Websheet')
,p_list_item_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'100'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697508149859311566.4355)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697508379122311567.4355)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('Administra\00E7\00E3o')
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697508646749311568.4355)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697508954423311568.4355)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('Gerenciar Servi\00E7o')
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697509272437311568.4355)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('Gerenciar Servi\00E7o')
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697508954423311568.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697509589201311568.4355)
,p_list_item_display_sequence=>215
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(697508954423311568.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697509890224311568.4355)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('Fazer uma Solicita\00E7\00E3o de Servi\00E7o')
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(697508954423311568.4355)
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697510102039311568.4355)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('Definir Prefer\00EAncias do Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(697508954423311568.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697510424442311568.4355)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('Editar An\00FAncio')
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697508954423311568.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697510729732311568.4355)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('Utiliza\00E7\00E3o do Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697508954423311568.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697511092305311569.4355)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('Gerenciar Usu\00E1rios e Grupos')
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697511311568311569.4355)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Monitorar Atividade'
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(47302021031728224)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697511632930311569.4355)
,p_list_item_display_sequence=>500
,p_list_item_link_text=>unistr('Pain\00E9is de Controle')
,p_list_item_link_target=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(47302021031728224)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1253566117341334456.4355)
,p_list_item_display_sequence=>510
,p_list_item_link_text=>'Alterar Minha Senha'
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697513111062314247.4355)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697513395064314247.4355)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Documenta\00E7\00E3o')
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2105953653789032029.4355)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('F\00F3rum de Discuss\00E3o')
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2185497476192539882.4355)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Oracle Technology Network'
,p_list_item_link_target=>'http://otn.oracle.com/apex'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697514231251314249.4355)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697514582567314249.4355)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Sobre'
,p_list_item_link_target=>'f?p=4350:9:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(719024906222154750.4355)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'App Builder'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW::'
,p_list_item_icon_alt_attribute=>'Drill-down do Application Builder'
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_api.id(178931223495737450)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719025442346154751.4355)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Aplicativos de Banco de Dados'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:DATABASE:'
,p_parent_list_item_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719025792086154751.4355)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Aplicativos de Websheet'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:WEBSHEET:'
,p_parent_list_item_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719026009370154751.4355)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719026385964154751.4355)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Criar'
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID:'
,p_parent_list_item_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719026624198154752.4355)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Importar'
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719026946930154752.4355)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Exportar'
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719027247767154752.4355)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719027511617154752.4355)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>unistr('Utilit\00E1rios de Espa\00E7o de Trabalho')
,p_parent_list_item_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719027815679154753.4355)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>unistr('Todos os Utilit\00E1rios de Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719027511617154752.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719028109015154753.4355)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719027511617154752.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719028431141154754.4355)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>unistr('Padr\00F5es do App Builder')
,p_list_item_link_target=>'f?p=4000:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719027511617154752.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719029022709154754.4355)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>unistr('Temas de Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719027511617154752.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719029300308154755.4355)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>'Grupos de Aplicativos'
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_api.id(719027511617154752.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719029687746154755.4355)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>'Views do Application Express'
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719027511617154752.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719029978772154755.4355)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>unistr('Relat\00F3rios entre Aplicativos')
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719027511617154752.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719030232218154755.4355)
,p_list_item_display_sequence=>169
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719030504194154756.4355)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('Migra\00E7\00F5es')
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719025111754154750.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719030888019154756.4355)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'SQL Workshop'
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>'Drill-down do SQL Workshop'
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_api.id(178931519479737472)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719031124656154756.4355)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Browser de Objetos'
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719030888019154756.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719031458397154756.4355)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'Comandos SQL'
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719030888019154756.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719031703587154756.4355)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Scripts SQL'
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719030888019154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('Utilit\00E1rios')
,p_parent_list_item_id=>wwv_flow_api.id(719030888019154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719032382647154757.4355)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>unistr('Todos os Utilit\00E1rios')
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719032635816154757.4355)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719032955597154757.4355)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>'Data Workshop'
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719033222480154757.4355)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>'Construtor de Consultas'
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713697277248449084.4355)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>unistr('SQL R\00E1pida')
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(670887786645958062.4355)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>'Conjuntos de Dados de Amostra'
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719033598800154757.4355)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>'Gerar DDL'
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719033825052154757.4355)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>unistr('Padr\00F5es da Interface do Usu\00E1rio')
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719035308907154759.4355)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>unistr('Compara\00E7\00E3o de Esquemas')
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719034150049154757.4355)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('M\00E9todos em Tabelas')
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719035619948154759.4355)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>'Lixeira'
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719034768041154757.4355)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>unistr('Relat\00F3rios de Objetos')
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719034459353154757.4355)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>'Sobre o BD'
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719035054803154758.4355)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>'Monitor de Banco de Dados'
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(719032044422154756.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719035949725154759.4355)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>unistr('Servi\00E7os RESTful')
,p_list_item_link_target=>'f?p=4850:500:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719030888019154756.4355)
,p_security_scheme=>wwv_flow_api.id(802975422996792935)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719036265816154759.4355)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Team Development'
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>'Drill-down do Team Development'
,p_list_text_01=>'tab-team-dev'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719036528727154759.4355)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>'Labels'
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719036265816154759.4355)
,p_security_scheme=>wwv_flow_api.id(438804333233472199)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719036845294154759.4355)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'Marcos'
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719036265816154759.4355)
,p_security_scheme=>wwv_flow_api.id(438804333233472199)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719037185918154759.4355)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>'Modelos'
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719036265816154759.4355)
,p_security_scheme=>wwv_flow_api.id(438804333233472199)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719037431531154759.4355)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>unistr('Utilit\00E1rios')
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719036265816154759.4355)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719038069849154760.4355)
,p_list_item_display_sequence=>355
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719036265816154759.4355)
,p_security_scheme=>wwv_flow_api.id(438804333233472199)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719038374173154760.4355)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>'Feedback'
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719036265816154759.4355)
,p_security_scheme=>wwv_flow_api.id(438804333233472199)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719042571176154767.4355)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Galeria de Aplicativos'
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_text_01=>'tab-apps'
,p_security_scheme=>wwv_flow_api.id(21341101987393942)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719042821520154768.4355)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>'Aplicativos de Produtividade'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:PACKAGE'
,p_parent_list_item_id=>wwv_flow_api.id(719042571176154767.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719043175953154768.4355)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>'Aplicativos de Amostra'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:SAMPLE'
,p_parent_list_item_id=>wwv_flow_api.id(719042571176154767.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(780157233170335847.4355)
,p_list_item_display_sequence=>425
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719042571176154767.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719043463859154768.4355)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>unistr('Administra\00E7\00E3o')
,p_list_item_link_target=>'f?p=4750:6:&SESSION.::&DEBUG.:6:'
,p_parent_list_item_id=>wwv_flow_api.id(719042571176154767.4355)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(812154592337870.4355)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1658706047402744.4355)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14858900882941039.4355)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91990218532572393.4355)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072435389712055.4355)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780149340994154.4355)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917632266890939884.4355)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_builder_workspace_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(1309004604808814.4355)
,p_name=>'APEX Builder Workspace Authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication = ''APEX'';'
,p_error_message=>unistr('O Ambiente de Desenvolvimento est\00E1 usando Autentica\00E7\00E3o externa')
,p_reference_id=>786940505486177571.4355
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(6738625560859071.4355)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>unistr('O SSO do Builder n\00E3o est\00E1 ativado')
,p_reference_id=>6738410669854771.4355
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12518728403445471.4355)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a administrar aplicativos')
,p_reference_id=>12511219858301010.4355
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_packaged_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(21341101987393942.4355)
,p_name=>'APEX 5.0 Packaged App Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a instalar Aplicativos de Produtividade ou de Amostra')
,p_reference_id=>786517456817697723.4355
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/user_is_a_developer
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(47302021031728224.4355)
,p_name=>'user is a developer'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_security.user_can_develop_any_flow;'
,p_error_message=>unistr('n\00E3o \00E9 poss\00EDvel determinar se o usu\00E1rio \00E9 um desenvolvedor (f4350)')
,p_reference_id=>786938431231163276.4355
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178931223495737450.4355)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('N\00E3o h\00E1 privil\00E9gios para a opera\00E7\00E3o em quest\00E3o')
,p_reference_id=>786516029127697713.4355
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178931519479737472.4355)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a usar o SQL Workshop')
,p_reference_id=>786516265251697717.4355
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178932029578737472.4355)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('O Team Development n\00E3o est\00E1 ativado para este espa\00E7o de trabalho')
,p_reference_id=>786516861027697723.4355
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(438804333233472199.4355)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a administrar aplicativos')
,p_reference_id=>12511219858301010.4355
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(802975422996792935.4355)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>unistr('N\00E3o h\00E1 privil\00E9gios para a opera\00E7\00E3o em quest\00E3o')
,p_reference_id=>786519856057734816.4355
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/service_requests_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(916538108136873611.4355)
,p_name=>'Service Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'' then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>unistr('N\00E3o h\00E1 privil\00E9gios para a opera\00E7\00E3o em quest\00E3o.')
,p_reference_id=>786932326296107981.4355
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_administration_app_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(1367105411776376234.4355)
,p_name=>'APEX 5.0 Administration App Access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  if wwv_flow.apps_only_workspace then',
'      --',
'      -- restricted set of pages for apps only workspace',
'      -- - 0 ....... global page',
'      -- - 1 ....... start page',
'      -- - 3 ....... Edit Profile',
'      -- - 9 ....... about page',
'      -- - 58/68 ... change password',
'      -- - 102 ..... preferences',
'      --',
'      return :APP_PAGE_ID in (0, 1, 3, 9, 58, 68, 102);',
'',
'  elsif :APP_PAGE_ID in (0, 1, 3, 9, 11, 28, 58, 68, 102, 577) then',
'      --',
'      -- approved unrestricted pages for development environment',
'      -- - 0 ....... global page',
'      -- - 1 ....... start page',
'      -- - 3 ....... Edit Profile',
'      -- - 9 ....... about page',
'      -- - 11 ...... current user preferences',
'      -- - 28 ...... purge preferences',
'      -- - 58/68 ... change password',
'      -- - 102 ..... preferences',
'      -- - 577 ..... help',
'      --',
'      return true;',
'',
'  else',
'      --',
'      -- developer or admin',
'      --',
'      return    wwv_flow_authorization.is_authorized_developer (',
'                    p_developer_authorization => ''EDIT'' )',
'             or wwv_flow_authorization.is_authorized_developer (',
'                    p_developer_authorization => ''ADMIN'' );',
'  end if;'))
,p_error_message=>unistr('N\00E3o h\00E1 privil\00E9gios para a opera\00E7\00E3o em quest\00E3o.')
,p_reference_id=>1367104867544331898.4355
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(1364606893206165.4355)
,p_icon_sequence=>10
,p_icon_subtext=>unistr('Espa\00E7o de Trabalho &COMPANY.')
,p_icon_target=>'f?p=4500:1000:&SESSION.'
,p_icon_image_alt=>unistr('Espa\00E7o de Trabalho &COMPANY.')
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(334060323997944127.4355)
,p_icon_sequence=>20
,p_icon_subtext=>unistr('( <span style="text-decoration:underline;">Alternar Espa\00E7o de Trabalho</span> )')
,p_icon_target=>'f?p=4550:20'
,p_icon_image_alt=>unistr('Alternar Espa\00E7o de Trabalho')
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond=>'73'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
,p_security_scheme=>wwv_flow_api.id(6738625560859071)
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(39960115843641093.4355)
,p_icon_sequence=>30
,p_icon_subtext=>'( <span style="text-decoration:underline;">Fazer Log-out</span> )'
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>'Log-out'
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond=>'73'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(203635014114430938.4355)
,p_icon_sequence=>40
,p_icon_subtext=>'Feedback'
,p_icon_target=>'javascript:popupURL(''f?p=4350:102:&SESSION.:::102:P102_APPLICATION_ID,P102_PAGE_ID:&APP_ID.,&APP_PAGE_ID.'');'
,p_nav_entry_is_feedback_yn=>'Y'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(110413960444139070.4355)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(234080313327980030.4355)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'    p_app_id           => wwv_flow.g_x01,',
'    p_get_apps_list    => wwv_flow.g_x02);'))
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(344359629554721697.4355)
,p_name=>'AUTH_TYPE'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(47267012470443025.4355)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(288025200211732904.4355)
,p_name=>'F4350_PASSWORD_REGION_TITLE'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(61498215760312449.4355)
,p_name=>'FB_FLOW_ID'
,p_data_type=>'NUMBER'
,p_item_comment=>'same as flow 4000 fb_flow_id'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(61665618599751270.4355)
,p_name=>'FB_FLOW_PAGE_ID'
,p_data_type=>'NUMBER'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(72751304929301595.4355)
,p_name=>'FSP_AFTER_LOGIN_URL'
,p_item_comment=>'Used by Custom2 authentication for deep linking support'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(367481423382175901.4355)
,p_name=>'G_USER_DEFAULT_DATE_FORMAT'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
,p_item_comment=>'This global item is included here, in case the user edits themselves on 4350:56, or via the Preferences dialog in the account mega menu.  For now, though, this item value is really only used in 4500 - to set the default date format for a user in SQL '
||'Workshop.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(48609214118039317.4355)
,p_name=>'LAST_VIEW'
,p_data_type=>'NUMBER'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(47267211793445016.4355)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>unistr('N\00E3o \00E9 poss\00EDvel calcular o nome do espa\00E7o de trabalho.')
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(288081418528785501.4355)
,p_computation_sequence=>10
,p_computation_item=>'F4350_PASSWORD_REGION_TITLE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_lang.system_message(''APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.''||replace(wwv_flow_authentication_dev.get_internal_authentication,''DB'',''LDAP'')||''-AUTH'')'
,p_compute_when=>'F4350_PASSWORD_REGION_TITLE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(344361727169737998.4355)
,p_computation_sequence=>10
,p_computation_item=>'AUTH_TYPE'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_authentication_dev.get_internal_authentication'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(486954604915667072.4355)
,p_computation_sequence=>10
,p_computation_item=>'LAST_VIEW'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'1'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/account_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2740022841418968.4355)
,p_lov_name=>'ACCOUNT STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(2740022841418968.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2740201351418968.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Contas Bloqueadas'
,p_lov_return_value=>'LOCKED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2741315831435879.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Conta Encerrada'
,p_lov_return_value=>'EXPIRED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2740411765418968.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Contas Desbloqueadas'
,p_lov_return_value=>'UNLOCKED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2740609662418968.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Minha Conta'
,p_lov_return_value=>'MY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12456720246979195.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Contas do Desenvolvedor'
,p_lov_return_value=>'DEV'
);
end;
/
prompt --application/shared_components/user_interface/lovs/account_lock_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6949526744661130.4355)
,p_lov_name=>'ACCOUNT_LOCK_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(6949526744661130.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6949718368661130.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bloqueado'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6949911078661130.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Desbloqueado'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/activity_log_request_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1569139039593351202.4355)
,p_lov_name=>'ACTIVITY_LOG.REQUEST_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(1569139039593351202.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1569139334794351203.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Outro'
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1569139617444351205.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Processamento'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1569139936155351205.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Renderiza\00E7\00E3o')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1569140273759351210.4355)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'AJAX'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1570578733042936737.4355)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Log-out'
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1570579027818937857.4355)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>unistr('Callback de Autentica\00E7\00E3o')
,p_lov_return_value=>'5'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_opt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87986129403049299.4355)
,p_lov_name=>'APPLICATION.OPT'
,p_lov_query=>'.'||wwv_flow_api.id(87986129403049299.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87986300136049300.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Todos os Aplicativos'
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87986529393049300.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Agrupar Por Aplicativo'
,p_lov_return_value=>'F'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_build_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(128034726363912582.4355)
,p_lov_name=>'APPLICATION_BUILD_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(128034726363912582.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(128035028761912584.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Somente Executar Aplicativo'
,p_lov_return_value=>'RUN_ONLY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(128035201383912585.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Executar e Construir Aplicativo'
,p_lov_return_value=>'RUN_AND_BUILD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/audit_naming
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(27067106427412398.4355)
,p_lov_name=>'AUDIT_NAMING'
,p_lov_query=>'.'||wwv_flow_api.id(27067106427412398.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27067418961412413.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Atributos do Aplicativo'
,p_lov_return_value=>'WWV_FLOWS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27067615785412414.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Modelo de P\00E1gina')
,p_lov_return_value=>'WWV_FLOW_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27067821285412414.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Barra de Navega\00E7\00E3o')
,p_lov_return_value=>'WWV_FLOW_ICON_BAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27068018297412414.4355)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Processo de Aplicativo'
,p_lov_return_value=>'WWV_FLOW_PROCESSING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27068231633412415.4355)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Item de Aplicativo'
,p_lov_return_value=>'WWV_FLOW_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27068428780412415.4355)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('C\00E1lculo de Aplicativo')
,p_lov_return_value=>'WWV_FLOW_COMPUTATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27068600233412415.4355)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Guias'
,p_lov_return_value=>'WWV_FLOW_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27068829004412415.4355)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('Guia M\00E3e')
,p_lov_return_value=>'WWV_FLOW_TOPLEVEL_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27069029470412416.4355)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Lista de Valores'
,p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES$'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27069224657412416.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Valores de LOV Est\00E1tica')
,p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES_DATA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192815107467123331.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Entrada de Breadcrumb'
,p_lov_return_value=>'WWV_FLOW_MENU_OPTIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192920211428952731.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Temas'
,p_lov_return_value=>'WWV_FLOW_THEMES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27069403307412416.4355)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('Atributos de P\00E1gina')
,p_lov_return_value=>'WWV_FLOW_STEPS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27069616679412416.4355)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('Bot\00E3o de P\00E1gina')
,p_lov_return_value=>'WWV_FLOW_STEP_BUTTONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27069821202412416.4355)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('Ramifica\00E7\00E3o de P\00E1gina')
,p_lov_return_value=>'WWV_FLOW_STEP_BRANCHES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27070027988412417.4355)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('Argumentos de Ramifica\00E7\00E3o de P\00E1gina')
,p_lov_return_value=>'WWV_FLOW_STEP_BRANCH_ARGS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27070221339412417.4355)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('Item de P\00E1gina')
,p_lov_return_value=>'WWV_FLOW_STEP_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27071724781417713.4355)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('C\00E1lculo de P\00E1gina')
,p_lov_return_value=>'WWV_FLOW_STEP_COMPUTATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27072029975419290.4355)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('Valida\00E7\00E3o da P\00E1gina')
,p_lov_return_value=>'WWV_FLOW_STEP_VALIDATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27072303095420909.4355)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('Processo de P\00E1gina')
,p_lov_return_value=>'WWV_FLOW_STEP_PROCESSING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27072608636422556.4355)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('Modelo de Regi\00E3o')
,p_lov_return_value=>'WWV_FLOW_PAGE_PLUG_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27072914523424290.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Modelo de Linha'
,p_lov_return_value=>'WWV_FLOW_ROW_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27073219717425765.4355)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'Modelo de Lista'
,p_lov_return_value=>'WWV_FLOW_LIST_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27073525951427595.4355)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>unistr('Atributos de Regi\00E3o')
,p_lov_return_value=>'WWV_FLOW_PAGE_PLUGS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27073802879430378.4355)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>'Mensagens'
,p_lov_return_value=>'WWV_FLOW_MESSAGES$'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27074108074431803.4355)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>unistr('Op\00E7\00F5es de Build')
,p_lov_return_value=>'WWV_FLOW_PATCHES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27074413269433395.4355)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('Desenvolvedores de Aplicativos (Administra\00E7\00E3o)')
,p_lov_return_value=>'WWV_FLOW_DEVELOPERS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27074718809434925.4355)
,p_lov_disp_sequence=>26
,p_lov_disp_value=>'Listas'
,p_lov_return_value=>'WWV_FLOW_LISTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27075025043436756.4355)
,p_lov_disp_sequence=>27
,p_lov_disp_value=>'Item de Lista'
,p_lov_return_value=>'WWV_FLOW_LIST_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27075332315438853.4355)
,p_lov_disp_sequence=>28
,p_lov_disp_value=>unistr('ID do Usu\00E1rio Efetivo (Administra\00E7\00E3o)')
,p_lov_return_value=>'WWV_FLOW_EFFECTIVE_USERID_MAP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27075705781440636.4355)
,p_lov_disp_sequence=>29
,p_lov_disp_value=>'Atalhos'
,p_lov_return_value=>'WWV_FLOW_SHORTCUTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27076012361442576.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('Texto de Ajuda do Item de P\00E1gina')
,p_lov_return_value=>'WWV_FLOW_STEP_ITEM_HELP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27076318248444200.4355)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>unistr('Esquemas de Autentica\00E7\00E3o')
,p_lov_return_value=>'WWV_FLOW_AUTHENTICATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27076624481446067.4355)
,p_lov_disp_sequence=>32
,p_lov_disp_value=>'Pontos de Entrada'
,p_lov_return_value=>'WWV_FLOW_ENTRY_POINTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27076929330447428.4355)
,p_lov_disp_sequence=>33
,p_lov_disp_value=>'Argumentos do Ponto de Entrada'
,p_lov_return_value=>'WWV_FLOW_ENTRY_POINT_ARGS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/available_applications
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(249067832108758740.4355)
,p_lov_name=>'AVAILABLE.APPLICATIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from wwv_flow_visible_flows f',
' order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/build_option_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(140229800819566260.4355)
,p_lov_name=>'BUILD OPTION STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(140229800819566260.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(140230006090566264.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Excluir'
,p_lov_return_value=>'EXCLUDE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(140230221897566265.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Incluir'
,p_lov_return_value=>'INCLUDE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/cache_mode_page_and_region
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(672366941474304666.4355)
,p_lov_name=>'CACHE_MODE (PAGE AND REGION)'
,p_lov_query=>'.'||wwv_flow_api.id(672366941474304666.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(672367283233304668.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Desativado'
,p_lov_return_value=>'NOCACHE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(672367558201304670.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Ativado'
,p_lov_return_value=>'CACHE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(672367830895304670.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('Cache por Usu\00E1rio')
,p_lov_return_value=>'USER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(672368194869304670.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('Cache por Sess\00E3o')
,p_lov_return_value=>'SESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_selector
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(46971429951226857.4355)
,p_lov_name=>'CHART SELECTOR'
,p_lov_query=>'.'||wwv_flow_api.id(46971429951226857.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46971618940226861.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Eventos de P\00E1gina por Dia')
,p_lov_return_value=>'DAY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46971819569226863.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Eventos de P\00E1gina por Hora')
,p_lov_return_value=>'HOUR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_mult_user_strip_domain
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(486946000320608950.4355)
,p_lov_name=>'CREATE.MULT.USER.STRIP.DOMAIN'
,p_lov_query=>'.'||wwv_flow_api.id(486946000320608950.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(486946203862608959.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Definir nome do usu\00E1rio para endere\00E7o de e-mail completo')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(486946418606608967.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Excluir @ dom\00EDnio como parte do nome do usu\00E1rio')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/debug_level
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(370258657315557256.4355)
,p_lov_name=>'DEBUG_LEVEL'
,p_lov_query=>'.'||wwv_flow_api.id(370258657315557256.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(370258984893557257.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Erro'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(370259375821557258.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Advert\00EAncia')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(370260147407557258.4355)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('Informa\00E7\00F5es')
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(370260586898557259.4355)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('Inser\00E7\00E3o de Aplicativo')
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(370260960387557259.4355)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Rastreamento de Aplicativo'
,p_lov_return_value=>'6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(370261795886557259.4355)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'APEX Enter'
,p_lov_return_value=>'8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(370262151966557260.4355)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'APEX Trace'
,p_lov_return_value=>'9'
);
end;
/
prompt --application/shared_components/user_interface/lovs/developer_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19716823057593749.4355)
,p_lov_name=>'DEVELOPER TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(19716823057593749.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19717103805593761.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Sim'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19717515342593765.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('N\00E3o')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/error_components
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(213967127754264881.4355)
,p_lov_name=>'ERROR COMPONENTS'
,p_lov_query=>'.'||wwv_flow_api.id(213967127754264881.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213967320847264904.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Item Num\00E9rico')
,p_lov_return_value=>'numeric_item'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213967522885264905.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Link Profundo'
,p_lov_return_value=>'deep_link'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213967714663264905.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Definir Processo do Item'
,p_lov_return_value=>'set_item_process'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213967927620264905.4355)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('Processo de Adi\00E7\00E3o do Form Tabular')
,p_lov_return_value=>'add_rows_to_tabular_form'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213968132430264906.4355)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('Processo de Atualiza\00E7\00E3o do Form Tabular')
,p_lov_return_value=>'multi_row_update_process'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213968319995264906.4355)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('Processo de Exclus\00E3o do Form Tabular')
,p_lov_return_value=>'multi_row_delete_process'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213968503762264906.4355)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('Processo de Extra\00E7\00E3o de Linha')
,p_lov_return_value=>'dml_fetch_row_process'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213968724423264906.4355)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Processo do Web Service'
,p_lov_return_value=>'web_service_process'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213968927764264907.4355)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Processar Processo de Linha'
,p_lov_return_value=>'dml_process_row_process'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6204524790478230.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Relat\00F3rio')
,p_lov_return_value=>'report'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213969130796264907.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Processo Ajax Callback'
,p_lov_return_value=>'on_demand_process'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213991320267272102.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Definir Item para C\00E1lculo de Prefer\00EAncia')
,p_lov_return_value=>'set_item_eq_preference_computation'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217558320349371396.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Condi\00E7\00E3o PL/SQL')
,p_lov_return_value=>'plsql_condition'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217562125113391685.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Condi\00E7\00E3o SQL')
,p_lov_return_value=>'sql_condition'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217566117626398980.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Condi\00E7\00E3o Existente ou N\00E3o Existente')
,p_lov_return_value=>'exists_condition'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213969326112264907.4355)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('Obter Pr\00F3ximo Processo ou Processo Anterior de Chave Prim\00E1ria')
,p_lov_return_value=>'get_next_or_prev_pk_process'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213969502182264907.4355)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('Definir Processo de Prefer\00EAncia')
,p_lov_return_value=>'set_preference_process'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213970706415268145.4355)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('C\00E1lculo da Consulta')
,p_lov_return_value=>'query_computation'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213991925115273511.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('C\00E1lculo de SQL ou PL/SQL')
,p_lov_return_value=>'sql_or_plsql_computation'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(217558927275373351.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Condi\00E7\00E3o de Corpo da Fun\00E7\00E3o PL/SQL')
,p_lov_return_value=>'plsql_function_body_condition'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213992700658275906.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('C\00E1lculo do Corpo da Fun\00E7\00E3o PL/SQL')
,p_lov_return_value=>'plsql_function_body_computation'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213993708970278348.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('Valida\00E7\00E3o de SQL Existente ou Inexistente')
,p_lov_return_value=>'exists_noexists_validation'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213994314164279816.4355)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('Valida\00E7\00E3o de Erro PL/SQL')
,p_lov_return_value=>'plsql_error_validation'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213995019705281413.4355)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('Valida\00E7\00E3o de Corpo da Fun\00E7\00E3o')
,p_lov_return_value=>'function_body_validation'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213997002867286002.4355)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('Corpo da Fun\00E7\00E3o PL/SQL que Retorna uma Valida\00E7\00E3o Booleana')
,p_lov_return_value=>'function_body_returning_boolean_validation'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213998211525288587.4355)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('Ramifica\00E7\00E3o')
,p_lov_return_value=>'branch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213999116719290082.4355)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Definir Item'
,p_lov_return_value=>'set_page_item_source'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(213999821568291451.4355)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Definir VPD'
,p_lov_return_value=>'set_vpd'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214000123646292003.4355)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'Limpar Cache'
,p_lov_return_value=>'clear_cache'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214000527455293116.4355)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('Salvar Estado da Sess\00E3o')
,p_lov_return_value=>'save_session_state'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214000932650294668.4355)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>unistr('Valida\00E7\00E3o')
,p_lov_return_value=>'error_performing_validations'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214001904037295831.4355)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>unistr('Valida\00E7\00E3o')
,p_lov_return_value=>'error_performing_after_submit_processes'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214002814080298744.4355)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>unistr('Condi\00E7\00E3o de express\00E3o PL/SQL')
,p_lov_return_value=>'check_cond_plsql_expresion'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214003320660300665.4355)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>unistr('Fun\00E7\00E3o Que Retorna Consulta HTML')
,p_lov_return_value=>'function_returning_sql_query'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214004324469301777.4355)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>'Atalho'
,p_lov_return_value=>'shortcut'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214004928625302922.4355)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>unistr('Gr\00E1fico SVG')
,p_lov_return_value=>'svg_chart'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214005332434304022.4355)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>unistr('Servi\00E7o Web')
,p_lov_return_value=>'web_service'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214005802437304830.4355)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>unistr('Gr\00E1fico')
,p_lov_return_value=>'chart'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214007008324306555.4355)
,p_lov_disp_sequence=>210
,p_lov_disp_value=>'Processo PL/SQL'
,p_lov_return_value=>'plsql_procedure'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214007511094307342.4355)
,p_lov_disp_sequence=>220
,p_lov_disp_value=>unistr('Calend\00E1rio')
,p_lov_return_value=>'calendar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214007915250308517.4355)
,p_lov_disp_sequence=>230
,p_lov_disp_value=>'Processo de Ajuda'
,p_lov_return_value=>'help'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214008318713309562.4355)
,p_lov_disp_sequence=>240
,p_lov_disp_value=>unistr('Regi\00E3o URL')
,p_lov_return_value=>'url_region'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214009321483310394.4355)
,p_lov_disp_sequence=>250
,p_lov_disp_value=>'Lista'
,p_lov_return_value=>'list'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214009624600311246.4355)
,p_lov_disp_sequence=>260
,p_lov_disp_value=>'Entrada da Lista'
,p_lov_return_value=>'list_entry'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(214010231180313173.4355)
,p_lov_disp_sequence=>270
,p_lov_disp_value=>unistr('Fun\00E7\00E3o PL/SQL que retorna Consulta SQL')
,p_lov_return_value=>'function_returning_sql_query'
);
end;
/
prompt --application/shared_components/user_interface/lovs/expire_user_accounts
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4834509455047185.4355)
,p_lov_name=>'EXPIRE USER ACCOUNTS'
,p_lov_query=>'.'||wwv_flow_api.id(4834509455047185.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4834812383047193.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ativar'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4835016591047194.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Desativar'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/f4350_fnd_group_ids
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(226642419934369326.4355)
,p_lov_name=>'F4350_FND_GROUP_IDS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select group_name d, id r',
'  from wwv_flow_fnd_user_groups_noapp',
' where security_group_id in (:flow_security_group_id,10)',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/f4350_p54_fnd_group_ids
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(132393417969824419.4355)
,p_lov_name=>'F4350_P54_FND_GROUP_IDS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(group_name) d, id r',
'  from wwv_flow_fnd_user_groups_noapp',
' where security_group_id in (:flow_security_group_id,10)',
'   and (:F4350_P54_ID is null or id <> :F4350_P54_ID)',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_developers
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(17062423464336902.4355)
,p_lov_name=>'FLOW_DEVELOPERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(USERID) d, USERID r',
'from  WWV_FLOW_developers',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/fnd_users
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(17066627882357077.4355)
,p_lov_name=>'FND USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(user_name) d, user_name r',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/fnd_user_ids
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(132392525949820706.4355)
,p_lov_name=>'FND_USER_IDS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(user_name) d, user_id r',
'  from wwv_flow_fnd_user',
' where security_group_id = :flow_security_group_id',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_no_since
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(488871706659155481.4355)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_NO_SINCE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/group_grantee_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(132386709008105935.4355)
,p_lov_name=>'GROUP_GRANTEE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(132386709008105935.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(132387009720105943.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Usu\00E1rio')
,p_lov_return_value=>'U'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(132387327177105947.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Grupo'
,p_lov_return_value=>'G'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_or_detail
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(135219829572410772.4355)
,p_lov_name=>'ICON OR DETAIL'
,p_lov_query=>'.'||wwv_flow_api.id(135219829572410772.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135220002122410781.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00CDcones')
,p_lov_return_value=>'ICON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(135220205520410794.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Detalhes'
,p_lov_return_value=>'DETAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_notify_interval
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(48455120589630644.4355)
,p_lov_name=>'IR_NOTIFY_INTERVAL'
,p_lov_query=>'.'||wwv_flow_api.id(48455120589630644.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48455420960630650.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Diariamente'
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48455617407630651.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Semanalmente'
,p_lov_return_value=>'W'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(48455822694630651.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Mensalmente'
,p_lov_return_value=>'M'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_notify_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(619315906303328344.4355)
,p_lov_name=>'IR_NOTIFY_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(619315906303328344.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(619316124110328372.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Submetido'
,p_lov_return_value=>'SUBMITTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(619316313660328373.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Enviado'
,p_lov_return_value=>'SENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(619316501456328373.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Erro'
,p_lov_return_value=>'ERROR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/issues_fs_limit
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(567784794163789852.4355)
,p_lov_name=>'ISSUES_FS_LIMIT'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 5       as dv,',
'       5242880 as rv',
' from dual',
'where 5242880 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)',
'union all',
'select 10       as dv,',
'       10485760 as rv',
' from dual',
'where 10485760 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)',
'union all',
'select 15       as dv,',
'       15728640 as rv',
' from dual',
'where 15728640 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)',
'union all',
'select 20       as dv,',
'       20971520 as rv',
' from dual',
'where 20971520 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)',
'union all',
'select 25       as dv,',
'       26214400 as rv',
' from dual',
'where 26214400 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)',
' order by 1'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'RV'
,p_display_column_name=>'DV'
);
end;
/
prompt --application/shared_components/user_interface/lovs/license_terms
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87991106556118398.4355)
,p_lov_name=>'LICENSE.TERMS'
,p_lov_query=>'.'||wwv_flow_api.id(87991106556118398.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87991314955118399.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('N\00E3o sou cidad\00E3o ou residente nem estou sob o controle do governo de: Cuba, Ir\00E3, Sud\00E3o, Iraque, L\00EDbia, Coreia do Norte, S\00EDria nem de qualquer outro pa\00EDs para o qual os Estados Unidos proibiram exporta\00E7\00E3o.')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87991524166118399.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('N\00E3o farei download nem exportarei ou reexportarei os Programas, direta ou indiretamente, para os pa\00EDses ou cidad\00E3os mencionados acima nem para residentes desses pa\00EDses.')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87991705582118400.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('N\00E3o fa\00E7o parte das listas do Departamento do Tesouro Nacional dos Estados Unidos de Cidad\00E3os com Designa\00E7\00F5es Especiais, Terroristas com Designa\00E7\00F5es Especiais e de Traficantes de Narc\00F3ticos com Designa\00E7\00F5es Especiais e tamb\00E9m n\00E3o estou listado na Tabel')
||unistr('a de Ordens de Proibi\00E7\00E3o e Recusa do Departamento de Com\00E9rcio dos Estados Unidos.')
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87991919165118400.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('N\00E3o farei download nem exportarei ou reexportarei os Programas, direta ou indiretamente, para as pessoas nas listas mencionadas acima.')
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87992103676118400.4355)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('N\00E3o utilizarei os Programas, e n\00E3o permitirei que eles sejam usados, para quaisquer finalidades proibidas pela lei dos Estados Unidos, incluindo, sem limita\00E7\00E3o, o desenvolvimento, o projeto, a fabrica\00E7\00E3o ou a produ\00E7\00E3o de armas nucleares, qu\00EDmicas ou ')
||unistr('biol\00F3gicas de destrui\00E7\00E3o em massa.')
,p_lov_return_value=>'5'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_schemas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(47395026667651380.4355)
,p_lov_name=>'LIST SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(upper(c.schema)) d, ',
'       upper(c.schema) v',
'from   wwv_flow_company_schemas c,',
'       wwv_flow_fnd_user u ',
'where  c.security_group_id = :flow_security_group_id and ',
'       u.security_group_id = :flow_security_group_id and',
'       u.user_name = :app_user and ',
'       (',
'           u.ALLOW_ACCESS_TO_SCHEMAS is null or ',
'           instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0',
'       )'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(75646032643247381.4355)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(schema) d, schema r',
'',
'from   wwv_flow_company_schemas',
'',
'where  security_group_id = :flow_security_group_id',
'',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_database_websheet_app
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(492205918121347540.4355)
,p_lov_name=>'LIST_DATABASE_WEBSHEET_APP'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id d, id r',
'from wwv_flows',
'where security_group_id = :flow_security_group_id',
'union all',
'select id d, id r',
'from wwv_flow_ws_applications',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_flow_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(473904019503385140.4355)
,p_lov_name=>'LIST_FLOW_STATUS'
,p_reference_id=>634347472712995.4355
,p_lov_query=>'.'||wwv_flow_api.id(473904019503385140.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741165654528290723.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Dispon\00EDvel')
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741165942786290723.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Dispon\00EDvel com a Barra de Ferramentas do Desenvolvedor')
,p_lov_return_value=>'AVAILABLE_W_EDIT_LINK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741166239367290723.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('Dispon\00EDvel Apenas para Desenvolvedores')
,p_lov_return_value=>'DEVELOPERS_ONLY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741166576972290723.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Acesso Restrito'
,p_lov_return_value=>'RESTRICTED_ACCESS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741166880777290723.4355)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('N\00E3o dispon\00EDvel')
,p_lov_return_value=>'UNAVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741167165338290723.4355)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('N\00E3o Dispon\00EDvel (Status Mostrado com PL/SQL)')
,p_lov_return_value=>'UNAVAILABLE_PLSQL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741167446373290724.4355)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('N\00E3o Dispon\00EDvel (Redirecionar para URL)')
,p_lov_return_value=>'UNAVAILABLE_URL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/login_status_codes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(42705425134693211.4355)
,p_lov_name=>'LOGIN STATUS CODES'
,p_lov_query=>'.'||wwv_flow_api.id(42705425134693211.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42705704364693212.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Normal, autentica\00E7\00E3o bem-sucedida')
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42705921465693213.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Nome do usu\00E1rio Desconhecido')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42706121390693213.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Conta Bloqueada'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42706310776693213.4355)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Conta Expirada'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42706524529693213.4355)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Senha Incorreta'
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42706719666693213.4355)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Primeiro Uso da Senha'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42706921482693213.4355)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('N\00FAmero M\00E1ximo de Tentativas de Log-in Excedido')
,p_lov_return_value=>'6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42707119263693213.4355)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Erro Interno Desconhecido'
,p_lov_return_value=>'7'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_a
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87960028308944903.4355)
,p_lov_name=>'MAX_ROWS_A'
,p_lov_query=>'.'||wwv_flow_api.id(87960028308944903.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87960228677944903.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87960404998944904.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87960630117944904.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87960804805944904.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87961014605944904.4355)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87961204075944904.4355)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87961414470944905.4355)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87961615644944905.4355)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87961828775944905.4355)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1.000'
,p_lov_return_value=>'1000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_b
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87962402466946929.4355)
,p_lov_name=>'MAX_ROWS_B'
,p_lov_query=>'.'||wwv_flow_api.id(87962402466946929.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87962624364946930.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87962825427946930.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87963028889946930.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87963219513946930.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87963422128946931.4355)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87963617026946932.4355)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87963820242946932.4355)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87964018632946932.4355)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87964228487946933.4355)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1.000'
,p_lov_return_value=>'1000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_c
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87964809046948816.4355)
,p_lov_name=>'MAX_ROWS_C'
,p_lov_query=>'.'||wwv_flow_api.id(87964809046948816.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87965020267948816.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87965202237948817.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87965404786948817.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87965623655948817.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87965801422948818.4355)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'40'
,p_lov_return_value=>'40'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87966019499948818.4355)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87966204425948818.4355)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87966405087948818.4355)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87966620020948818.4355)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87966830048948820.4355)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'1.000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87967016319948821.4355)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'5.000'
,p_lov_return_value=>'5000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87967217418948821.4355)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'10.000'
,p_lov_return_value=>'10000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87967415888948821.4355)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'50.000'
,p_lov_return_value=>'50000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_d
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87968118050951423.4355)
,p_lov_name=>'MAX_ROWS_D'
,p_lov_query=>'.'||wwv_flow_api.id(87968118050951423.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87968314659951424.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87968522241951424.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87968709744951424.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87968903454951425.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87969114479951425.4355)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87969329781951426.4355)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87969508652951427.4355)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87969708972951427.4355)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'1.000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87969903261951427.4355)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'10.000'
,p_lov_return_value=>'10000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/new_or_existing_schema
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(245496725063109254.4355)
,p_lov_name=>'NEW_OR_EXISTING_SCHEMA'
,p_lov_query=>'.'||wwv_flow_api.id(245496725063109254.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(245497113141109261.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Solicitar um novo esquema'
,p_lov_return_value=>'YES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(245496930435109257.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Usar um esquema existente'
,p_lov_return_value=>'NO'
);
end;
/
prompt --application/shared_components/user_interface/lovs/operating_systems
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87980828664020704.4355)
,p_lov_name=>'OPERATING.SYSTEMS'
,p_lov_query=>'.'||wwv_flow_api.id(87980828664020704.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87981029047020705.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'HP-Tru64Unix'
,p_lov_return_value=>'HP-Tru64Unix'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87981205950020705.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'HP-UX'
,p_lov_return_value=>'HP-UX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87981403269020706.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'IBM-AIX'
,p_lov_return_value=>'IBM-AIX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87981618293020706.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Linux'
,p_lov_return_value=>'Linux'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87981814646020706.4355)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'MS-NT'
,p_lov_return_value=>'MS-NT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87982016496020707.4355)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'MS-WIN2000'
,p_lov_return_value=>'MS-WIN2000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87982226769020707.4355)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'MS-XP'
,p_lov_return_value=>'MS-XP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87982430599020707.4355)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Outro'
,p_lov_return_value=>'Other'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87982601452020707.4355)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Outro - Unix'
,p_lov_return_value=>'OtherUnix'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87982816960020707.4355)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Sun-Solaris'
,p_lov_return_value=>'Sun-Solaris'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2020_ws_obj_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(628838348305108438.4355)
,p_lov_name=>'P2020_WS_OBJ_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(628838348305108438.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(628838684612108439.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('V\00E1lido')
,p_lov_return_value=>'VALID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(628838943749108440.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Inv\00E1lido')
,p_lov_return_value=>'INVALID'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p2020_ws_obj_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(628812792905024497.4355)
,p_lov_name=>'P2020_WS_OBJ_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(628812792905024497.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(628813001940024498.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Tabela'
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(628813323857024500.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Sequ\00EAncia')
,p_lov_return_value=>'SEQUENCE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p216_monitor
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(22415219367679656.4355)
,p_lov_name=>'P216_MONITOR'
,p_lov_query=>'.'||wwv_flow_api.id(22415219367679656.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22415404656679665.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Views de P\00E1gina')
,p_lov_return_value=>'PV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22416003914684720.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Informa\00E7\00F5es sobre o browser')
,p_lov_return_value=>'BI'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22416612918687252.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Valores de Estado da Sess\00E3o')
,p_lov_return_value=>'SS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(228539708561074614.4355)
,p_lov_name=>'PAGE MODE'
,p_lov_query=>'.'||wwv_flow_api.id(228539708561074614.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(228539924927074625.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Din\00E2mico')
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(228540132030074635.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Cache Criado'
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(228540313915074635.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'No Cache'
,p_lov_return_value=>'R'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(130988608718459028.4355)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('Processamento de P\00E1gina')
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131016603205684510.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('P\00E1gina Parcial')
,p_lov_return_value=>'P'
);
end;
/
prompt --application/shared_components/user_interface/lovs/person_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87979323684009856.4355)
,p_lov_name=>'PERSON.TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(87979323684009856.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87979519786009857.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Funcion\00E1rio')
,p_lov_return_value=>'E'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87979702743009857.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Contratado'
,p_lov_return_value=>'C'
);
end;
/
prompt --application/shared_components/user_interface/lovs/plsql_editing_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(113937100137241641.4355)
,p_lov_name=>'PLSQL EDITING STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(113937100137241641.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113937313482241642.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Permitir edi\00E7\00E3o da unidade programa PL/SQL')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113937510829241642.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('N\00E3o permitir edi\00E7\00E3o de unidade de programa PL/SQL')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/preference_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(42506917060665623.4355)
,p_lov_name=>'PREFERENCE TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(42506917060665623.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42507201651665624.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Classifica\00E7\00E3o de P\00E1ginas')
,p_lov_return_value=>'SORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42507416214665624.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Outro'
,p_lov_return_value=>'OTHER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42507628021665624.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Valor do Item entre Sess\00F5es')
,p_lov_return_value=>'ITEM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/preference_window_mgmt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(698047789180011733.4355)
,p_lov_name=>'PREFERENCE_WINDOW_MGMT'
,p_lov_query=>'.'||wwv_flow_api.id(698047789180011733.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698048021582011735.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Abrir em nova janela, se for necess\00E1rio for\00E7ar o foco')
,p_lov_return_value=>'FOCUS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698048351664011737.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Janela \00DAnica para todos os aplicativos')
,p_lov_return_value=>'ONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/privileges
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87973907708976827.4355)
,p_lov_name=>'PRIVILEGES'
,p_lov_query=>'.'||wwv_flow_api.id(87973907708976827.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87974125418976828.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Administra\00E7\00E3o')
,p_lov_return_value=>'ADMIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87974326105976828.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Procurar'
,p_lov_return_value=>'BROWSE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87974520374976829.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Criar'
,p_lov_return_value=>'CREATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87974700192976829.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Carregador de Dados'
,p_lov_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87974908440976829.4355)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Monitor de BD'
,p_lov_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87975104201976829.4355)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Editar'
,p_lov_return_value=>'EDIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87975319689976830.4355)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Ajuda'
,p_lov_return_value=>'HELP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87975514156976830.4355)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Monitorar'
,p_lov_return_value=>'MONITOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87975715979976830.4355)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'SQL'
,p_lov_return_value=>'SQL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87975929098976830.4355)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('Gerenciador de Usu\00E1rios')
,p_lov_return_value=>'USER_MANAGER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/recent_time
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(876530482469714.4355)
,p_lov_name=>'RECENT TIME'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/recent_time_archive
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(880120182357116546.4355)
,p_lov_name=>'RECENT_TIME_ARCHIVE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MONTH'')) d, 31 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''MONTHS'')) d, 62 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''MONTHS'')) d, 93 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''YEARS'')) d, 730 t from dual  union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''YEARS'')) d, 1095 t from dual  union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''YEARS'')) d, 1460 t from dual  union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''YEARS'')) d, 1825 t from dual  union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''YEARS'')) d, 3650 t from dual ',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/region_caching_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(42414417202633712.4355)
,p_lov_name=>'REGION CACHING OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(42414417202633712.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42414713865633714.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'No Cache'
,p_lov_return_value=>'CACHED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42414915904633714.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('No Cache Por Usu\00E1rio')
,p_lov_return_value=>'CACHED_BY_USER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42415123252633714.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('N\00E3o Armazenado no Cache')
,p_lov_return_value=>'NOT_CACHED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/reporting_period
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(180662003103161233.4355)
,p_lov_name=>'REPORTING PERIOD'
,p_lov_query=>'.'||wwv_flow_api.id(180662003103161233.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180662201590161236.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'1 Dia'
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180662407591161239.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'1 Semana'
,p_lov_return_value=>'W'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180663409336163078.4355)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>'2 Semanas'
,p_lov_return_value=>'2W'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180662601241161239.4355)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('1 M\00EAs')
,p_lov_return_value=>'M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180708018527279245.4355)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>'2 Meses'
,p_lov_return_value=>'2M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180713228570282104.4355)
,p_lov_disp_sequence=>31.5
,p_lov_disp_value=>'3 Meses'
,p_lov_return_value=>'3M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180713023722280779.4355)
,p_lov_disp_sequence=>32
,p_lov_disp_value=>'6 Meses'
,p_lov_return_value=>'6M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180662822420161239.4355)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'1 Ano'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180714418789298237.4355)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'2 Anos'
,p_lov_return_value=>'2Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180714621214298964.4355)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'5 Anos'
,p_lov_return_value=>'5Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/reqeuest_service
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(168289505113227142.4355)
,p_lov_name=>'REQEUEST SERVICE'
,p_lov_query=>'.'||wwv_flow_api.id(168289505113227142.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168289817280227144.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Esquema da Solicita\00E7\00E3o')
,p_lov_return_value=>'SCHEMA'
,p_lov_template=>'#DISPLAY_VALUE#| icon-request-schema'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168290023589227145.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Solicitar Armazenamento'
,p_lov_return_value=>'STORAGE'
,p_lov_template=>'#DISPLAY_VALUE#| icon-request-storage'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168290203148227145.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Solicitar Encerramento'
,p_lov_return_value=>'TERMINATION'
,p_lov_template=>'#DISPLAY_VALUE#| icon-request-termination'
);
end;
/
prompt --application/shared_components/user_interface/lovs/request_statuses
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(378143515851142224.4355)
,p_lov_name=>'REQUEST_STATUSES'
,p_lov_query=>'.'||wwv_flow_api.id(378143515851142224.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378143812022142228.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Em Andamento'
,p_lov_return_value=>'IN_PROGRESS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378144114463142229.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Solicitado'
,p_lov_return_value=>'REQUESTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378144422710142229.4355)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Aceito'
,p_lov_return_value=>'ACCEPTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378144722168142229.4355)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Recusado'
,p_lov_return_value=>'DECLINED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378145031757142229.4355)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Aprovado'
,p_lov_return_value=>'APPROVED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378145330379142229.4355)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Encerramento em Andamento'
,p_lov_return_value=>'TERMINATION_IN_PROGRESS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378145610822142229.4355)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Encerramento em Andamento'
,p_lov_return_value=>'TERMINATION_IN_PROGRESS2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378145905326142229.4355)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Encerramento em Andamento'
,p_lov_return_value=>'TERMINATION_IN_PROGRESS3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378146205625142229.4355)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Encerramento em Andamento'
,p_lov_return_value=>'TERMINATION_IN_PROGRESS4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378146515175142230.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Encerramento em Andamento'
,p_lov_return_value=>'TERMINATION_IN_PROGRESS5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378146800022142230.4355)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Encerramento em Andamento'
,p_lov_return_value=>'TERMINATION_IN_PROGRESS6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(378147120846142230.4355)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Encerrado'
,p_lov_return_value=>'TERMINATED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/session_trace_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(370223717115128950.4355)
,p_lov_name=>'SESSION_TRACE_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(370223717115128950.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(370224060587128958.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Rastreamento SQL'
,p_lov_return_value=>'1'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_all_or_cached_pages
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(42450922059777772.4355)
,p_lov_name=>'SHOW ALL OR CACHED PAGES'
,p_lov_query=>'.'||wwv_flow_api.id(42450922059777772.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42451116170777773.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Todas as P\00E1ginas')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(42451322267777773.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('P\00E1ginas Armazenadas no Cache')
,p_lov_return_value=>'CACHED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_more_columns_checkbox
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(17777219154823135.4355)
,p_lov_name=>'SHOW MORE COLUMNS CHECKBOX'
,p_lov_query=>'.'||wwv_flow_api.id(17777219154823135.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17777414218823135.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Mostrar Colunas Adicionais do Relat\00F3rio')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/team_dev_fs_limit
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2541925202710283317.4355)
,p_lov_name=>'TEAM_DEV_FS_LIMIT'
,p_reference_id=>2541932940202319161.4355
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 5       as dv,',
'       5242880 as rv',
' from dual',
'where 5242880 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)',
'union all',
'select 10       as dv,',
'       10485760 as rv',
' from dual',
'where 10485760 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)',
'union all',
'select 15       as dv,',
'       15728640 as rv',
' from dual',
'where 15728640 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)',
'union all',
'select 20       as dv,',
'       20971520 as rv',
' from dual',
'where 20971520 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)',
'union all',
'select 25       as dv,',
'       26214400 as rv',
' from dual',
'where 26214400 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ts_schema_option
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(25622114385279132.4355)
,p_lov_name=>'TS_SCHEMA_OPTION'
,p_lov_query=>'.'||wwv_flow_api.id(25622114385279132.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25622422573279176.4355)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esquema Existente'
,p_lov_return_value=>'EXISTING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25622617415279177.4355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Novo Esquema'
,p_lov_return_value=>'NEW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_or_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(157815226475866526.4355)
,p_lov_name=>'YES_NO_RETURNS_Y_OR_N'
,p_lov_query=>'.'||wwv_flow_api.id(157815226475866526.4355)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157815523644866535.4355)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Sim'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157815717308866538.4355)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('N\00E3o')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/administration
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(4090422833267509.4355)
,p_name=>'administration'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2469622445716674.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina Por Sistema Operacional')
,p_link=>'f?p=&APP_ID.:63:&SESSION.::&DEBUG.:::'
,p_page_id=>63
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2474403886740449.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Sess\00F5es por Browser')
,p_link=>'f?p=&APP_ID.:64:&SESSION.::&DEBUG.:::'
,p_page_id=>64
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4092600585280040.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>'Monitorar Atividade'
,p_link=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::'
,p_page_id=>22
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4107331322307772.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina por Usu\00E1rio')
,p_link=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::'
,p_page_id=>25
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4148213370406694.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>'Cliques Externos'
,p_link=>'f?p=&APP_ID.:34:&SESSION.::&DEBUG.:::'
,p_page_id=>34
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4151832202421647.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina por Agente de Usu\00E1rio')
,p_link=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.:::'
,p_page_id=>37
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4190227850581237.4355)
,p_parent_id=>wwv_flow_api.id(47260107410925385.4355)
,p_short_name=>unistr('Expurgar Estado de Sess\00E3o')
,p_link=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::'
,p_page_id=>5
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4195726034599646.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Altera\00E7\00F5es em Aplicativos por Aplicativo')
,p_link=>'f?p=&FLOW_ID.:38:&SESSION.::&DEBUG.:::'
,p_page_id=>38
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4206226857609277.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Gerenciar Usu\00E1rios e Grupos')
,p_link=>'f?p=&APP_ID.:55:&SESSION.::&DEBUG.:::'
,p_page_id=>55
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4209018677616407.4355)
,p_parent_id=>wwv_flow_api.id(4206226857609277.4355)
,p_short_name=>unistr('Criar Usu\00E1rio')
,p_link=>'f?p=&APP_ID.:52:&SESSION.::&DEBUG.:::'
,p_page_id=>52
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4271821999882293.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina por Aplicativo')
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>26
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4281101764933173.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina Recentes')
,p_link=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:::'
,p_page_id=>29
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4283911241944016.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina por Desempenho Ponderado de P\00E1gina')
,p_link=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.:::'
,p_page_id=>31
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4318016496108751.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Calend\00E1rio Mensal de Views de P\00E1gina por Dia')
,p_link=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:::'
,p_page_id=>27
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4323002682130309.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>'Log de Atividades do Desenvolvedor'
,p_link=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:::'
,p_page_id=>30
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4325919922137501.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Gerenciar Servi\00E7o')
,p_link=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::'
,p_page_id=>21
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4361400414268083.4355)
,p_parent_id=>wwv_flow_api.id(47260107410925385.4355)
,p_short_name=>unistr('Expurgar Sess\00F5es')
,p_link=>'f?p=&APP_ID.:45:&SESSION.::&DEBUG.:::'
,p_page_id=>45
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4363126928271060.4355)
,p_parent_id=>wwv_flow_api.id(47260107410925385.4355)
,p_short_name=>unistr('Sess\00F5es Recentes')
,p_link=>'f?p=&APP_ID.:43:&SESSION.::&DEBUG.:::'
,p_page_id=>43
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4364521967273337.4355)
,p_parent_id=>wwv_flow_api.id(47260107410925385.4355)
,p_short_name=>unistr('Expurgar Prefer\00EAncias')
,p_link=>'f?p=&APP_ID.:46:&SESSION.::&DEBUG.:::'
,p_page_id=>46
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4365816792275696.4355)
,p_parent_id=>wwv_flow_api.id(47260107410925385.4355)
,p_short_name=>unistr('Prefer\00EAncias por Usu\00E1rio')
,p_link=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.:::'
,p_page_id=>44
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4375107937294978.4355)
,p_parent_id=>wwv_flow_api.id(4380108356309988.4355)
,p_short_name=>unistr('Grupo de Usu\00E1rios')
,p_link=>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.:::'
,p_page_id=>54
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4380108356309988.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Gerenciar Usu\00E1rios e Grupos')
,p_link=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.:::'
,p_page_id=>53
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4381802749312589.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Gerenciar Usu\00E1rios e Grupos')
,p_link=>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.:::'
,p_page_id=>51
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4383226459316770.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>'Solicitar Armazenamento'
,p_link=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.:::'
,p_page_id=>49
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4384618480320519.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>unistr('Solicitar Encerramento do Servi\00E7o')
,p_link=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:::'
,p_page_id=>50
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4393511782338849.4355)
,p_parent_id=>wwv_flow_api.id(4206226857609277.4355)
,p_short_name=>unistr('Editar Usu\00E1rio')
,p_link=>'f?p=&FLOW_ID.:56:&SESSION.'
,p_page_id=>56
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4933731196448238.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Esquemas do Espa\00E7o de Trabalho')
,p_link=>'f?p=&APP_ID.:72:&SESSION.::&DEBUG.:::'
,p_page_id=>72
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5909921448840002.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Utiliza\00E7\00E3o do Tablespace de Esquema')
,p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
,p_page_id=>2
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(7257808624858752.4355)
,p_parent_id=>wwv_flow_api.id(47260107410925385.4355)
,p_short_name=>unistr('Detalhes do Estado de Sess\00E3o')
,p_link=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:::'
,p_page_id=>16
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(7259930824863624.4355)
,p_parent_id=>wwv_flow_api.id(47260107410925385.4355)
,p_short_name=>unistr('Prefer\00EAncias do Usu\00E1rio Atual')
,p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(7453117390591593.4355)
,p_parent_id=>wwv_flow_api.id(4283911241944016.4355)
,p_short_name=>unistr('Desempenho da P\00E1gina')
,p_link=>'f?p=&APP_ID.:65:&SESSION.::&DEBUG.:::'
,p_page_id=>65
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(9016821830861763.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>'Sobre o &PRODUCT_NAME.'
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(9408012888223819.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Atividade da Sess\00E3o por Hora')
,p_link=>'f?p=&FLOW_ID.:15:&SESSION.'
,p_page_id=>15
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(9446414777586270.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>unistr('Definir Prefer\00EAncias do Espa\00E7o de Trabalho')
,p_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::'
,p_page_id=>17
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10268429641818276.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>'Resumo de Log-in do Desenvolvedor'
,p_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
,p_page_id=>6
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10585025472876168.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>unistr('Provisionamento: Solicitar T\00E9rmino do Servi\00E7o')
,p_link=>'f?p=&FLOW_ID.:510:&SESSION.'
,p_page_id=>510
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11927127220739284.4355)
,p_parent_id=>wwv_flow_api.id(4363126928271060.4355)
,p_short_name=>unistr('Detalhes da Sess\00E3o')
,p_link=>'f?p=&APP_ID.:40:&SESSION.::&DEBUG.:::'
,p_page_id=>40
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(17101518098296684.4355)
,p_parent_id=>wwv_flow_api.id(.4355)
,p_short_name=>unistr('Views por P\00E1gina')
,p_link=>'f?p=&FLOW_ID.:32:&SESSION.'
,p_page_id=>32
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(17191212558696158.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Altera\00E7\00F5es no Aplicativo, detalhadas')
,p_link=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.:::'
,p_page_id=>42
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(20246528779701431.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor')
,p_link=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:::'
,p_page_id=>8
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(20253824023718817.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor')
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(20590301090617183.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina por Dia')
,p_link=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::'
,p_page_id=>12
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(20693525446844867.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina por Hora')
,p_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
,p_page_id=>14
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(22594908160282978.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Altera\00E7\00F5es no Aplicativo por Dia')
,p_link=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:::'
,p_page_id=>18
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(22818825242809738.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Altera\00E7\00F5es no Aplicativo por Dia')
,p_link=>'f?p=&FLOW_ID.:20:&SESSION.::&DEBUG.:::'
,p_page_id=>20
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(25558521888584227.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina por Aplicativo e P\00E1gina')
,p_link=>'f?p=&APP_ID.:75:&SESSION.::&DEBUG.:::'
,p_page_id=>75
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(25619701716212765.4355)
,p_parent_id=>wwv_flow_api.id(26633620827671901.4355)
,p_short_name=>'Criar'
,p_link=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:::'
,p_page_id=>1000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(25638421686309874.4355)
,p_parent_id=>wwv_flow_api.id(26633620827671901.4355)
,p_short_name=>'Criar'
,p_link=>'f?p=&APP_ID.:1020:&SESSION.::&DEBUG.:::'
,p_page_id=>1020
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(26445104999779395.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>'Tentativas de Log-in'
,p_link=>'f?p=&APP_ID.:70:&SESSION.::&DEBUG.:RP::'
,p_page_id=>70
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(26633620827671901.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>'Objetos do Banco de Dados da Websheet'
,p_link=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.:::'
,p_page_id=>2000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(26636125294745766.4355)
,p_parent_id=>wwv_flow_api.id(26633620827671901.4355)
,p_short_name=>'Remover'
,p_link=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.:::'
,p_page_id=>2010
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(27257108953740456.4355)
,p_parent_id=>wwv_flow_api.id(.4355)
,p_short_name=>unistr('<span class="u-VisuallyHidden">Administra\00E7\00E3o</span><span class="a-Icon icon-breadcrumb-previous" title="Administra\00E7\00E3o"></span>')
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(30025321432264022.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Pain\00E9is de Controle')
,p_link=>'f?p=&APP_ID.:60:&SESSION.::&DEBUG.:::'
,p_page_id=>60
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(30327713625356854.4355)
,p_parent_id=>wwv_flow_api.id(30025321432264022.4355)
,p_short_name=>unistr('Criar V\00E1rios Usu\00E1rios')
,p_link=>'f?p=&APP_ID.:99:&SESSION.::&DEBUG.:::'
,p_page_id=>99
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(30343815513719877.4355)
,p_parent_id=>wwv_flow_api.id(4206226857609277.4355)
,p_short_name=>unistr('Pesquisar Usu\00E1rios')
,p_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:::'
,p_page_id=>8000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(34516114490236116.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('P\00E1ginas mais Exibidas em Todos os Aplicativos')
,p_link=>'f?p=&APP_ID.:190:&SESSION.::&DEBUG.:::'
,p_page_id=>190
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(34710616986796822.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>'Solicitar Esquema de Banco de Dados'
,p_link=>'f?p=&FLOW_ID.:48:&SESSION.'
,p_page_id=>48
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(41507328141454714.4355)
,p_parent_id=>wwv_flow_api.id(47295000777189375.4355)
,p_short_name=>unistr('Expurgar Regi\00F5es Armazenadas no Cache por Regi\00E3o')
,p_link=>'f?p=&APP_ID.:301:&SESSION.::&DEBUG.:::'
,p_page_id=>301
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(41692321367095915.4355)
,p_parent_id=>wwv_flow_api.id(47295000777189375.4355)
,p_short_name=>unistr('Expurgar Regi\00F5es Armazenadas no Cache por Aplicativo')
,p_link=>'f?p=&APP_ID.:303:&SESSION.::&DEBUG.:::'
,p_page_id=>303
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(41861202885553198.4355)
,p_parent_id=>wwv_flow_api.id(47295000777189375.4355)
,p_short_name=>unistr('Expurgar Regi\00F5es Armazenadas no Cache por Espa\00E7o de Trabalho')
,p_link=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:::'
,p_page_id=>300
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(42341004664643420.4355)
,p_parent_id=>wwv_flow_api.id(47295000777189375.4355)
,p_short_name=>unistr('Expurgar P\00E1ginas Armazenadas no Cache por Aplicativo')
,p_link=>'f?p=&APP_ID.:304:&SESSION.::&DEBUG.:::'
,p_page_id=>304
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(42426220372298687.4355)
,p_parent_id=>wwv_flow_api.id(47295000777189375.4355)
,p_short_name=>unistr('Expurgar P\00E1ginas Armazenadas no Cache por P\00E1gina')
,p_link=>'f?p=&APP_ID.:302:&SESSION.::&DEBUG.:::'
,p_page_id=>302
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(42468214129256219.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>'Log de Contagem de Cliques'
,p_link=>'f?p=&APP_ID.:84:&SESSION.::&DEBUG.:::'
,p_page_id=>84
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(42714907058726008.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Tentativas de Log-in pelo Resultado da Autentica\00E7\00E3o')
,p_link=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::'
,p_page_id=>4
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(46991002925568555.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Pain\00E9is de Controle')
,p_link=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
,p_page_id=>13
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47001932630888950.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Pain\00E9is de Controle')
,p_link=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:::'
,p_page_id=>33
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47260107410925385.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>unistr('Estado da Sess\00E3o')
,p_link=>'f?p=&FLOW_ID.:36:&SESSION.'
,p_page_id=>36
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47295000777189375.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>'Cache do Aplicativo'
,p_link=>'f?p=&APP_ID.:47:&SESSION.::&DEBUG.:::'
,p_page_id=>47
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47308310413778595.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>'Solicitar Armazenamento'
,p_link=>'f?p=&FLOW_ID.:69:&SESSION.'
,p_page_id=>69
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47332515905632680.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Pain\00E9is de Controle')
,p_link=>'f?p=&APP_ID.:71:&SESSION.::&DEBUG.:::'
,p_page_id=>71
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47356100656454148.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Pain\00E9is de Controle')
,p_link=>'f?p=&APP_ID.:78:&SESSION.::&DEBUG.:::'
,p_page_id=>78
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47393027682585246.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Pain\00E9is de Controle')
,p_link=>'f?p=&APP_ID.:79:&SESSION.::&DEBUG.:::'
,p_page_id=>79
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47440031058206587.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Pain\00E9is de Controle')
,p_link=>'f?p=&APP_ID.:81:&SESSION.::&DEBUG.:::'
,p_page_id=>81
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47723114753679446.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('P\00E1ginas Rec\00E9m-criadas')
,p_link=>'f?p=&FLOW_ID.:82:&SESSION.'
,p_page_id=>82
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47745822639055625.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina por Hora')
,p_link=>'f?p=&APP_ID.:87:&SESSION.::&DEBUG.:::'
,p_page_id=>87
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47768305657260927.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Altera\00E7\00F5es de P\00E1gina por Dia')
,p_link=>'f?p=&FLOW_ID.:89:&SESSION.'
,p_page_id=>89
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(48002713439212955.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Pain\00E9is de Controle')
,p_link=>'f?p=&APP_ID.:91:&SESSION.::&DEBUG.:::'
,p_page_id=>91
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(48516105867959355.4355)
,p_parent_id=>wwv_flow_api.id(493061632558056672.4355)
,p_short_name=>unistr('Inscri\00E7\00F5es')
,p_link=>'f?p=&APP_ID.:92:&SESSION.::&DEBUG.:::'
,p_page_id=>92
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(49167127607716830.4355)
,p_parent_id=>wwv_flow_api.id(47260107410925385.4355)
,p_short_name=>unistr('Redefinir Prefer\00EAncias')
,p_link=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:::'
,p_page_id=>28
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(51200624276230133.4355)
,p_parent_id=>wwv_flow_api.id(47295000777189375.4355)
,p_short_name=>unistr('Expurgar P\00E1ginas Armazenadas no Cache Expiradas por Aplicativo')
,p_link=>'f?p=&APP_ID.:90:&SESSION.::&DEBUG.:::'
,p_page_id=>90
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(65419012862652752.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Relat\00F3rio de Views de P\00E1gina Por Dia')
,p_link=>'f?p=&APP_ID.:74:&SESSION.::&DEBUG.:::'
,p_page_id=>74
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(67231725243730948.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Privil\00E9gios de Banco de Dados')
,p_link=>'f?p=&APP_ID.:86:&SESSION.::&DEBUG.:::'
,p_page_id=>86
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(127643119606506595.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>'Status do Build do Aplicativo'
,p_link=>'f?p=&APP_ID.:41:&SESSION.::&DEBUG.:::'
,p_page_id=>41
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(162263605460882715.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>'Resumo do Log de Atividades'
,p_link=>'f?p=&APP_ID.:352:&SESSION.::&DEBUG.:::'
,p_page_id=>352
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(162267111917894830.4355)
,p_parent_id=>wwv_flow_api.id(.4355)
,p_short_name=>'Resumo do Log de Atividades'
,p_link=>'f?p=&FLOW_ID.:353:&SESSION.'
,p_page_id=>353
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(162270607148927500.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>'Resumo do Log de Atividades por Aplicativo'
,p_link=>'f?p=&APP_ID.:354:&SESSION.::&DEBUG.:::'
,p_page_id=>354
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(166213224187830380.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Gr\00E1fico de Utiliza\00E7\00E3o de Componente Nativo')
,p_link=>'f?p=&APP_ID.:97:&SESSION.'
,p_page_id=>97
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(167555425410082684.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Sess\00F5es Ativas')
,p_link=>'f?p=&FLOW_ID.:7:&SESSION.'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(167633330874520798.4355)
,p_parent_id=>wwv_flow_api.id(167555425410082684.4355)
,p_short_name=>unistr('Detalhe da Sess\00E3o')
,p_link=>'f?p=&FLOW_ID.:19:&SESSION.'
,p_page_id=>19
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(168316116904810067.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>unistr('Solicitar Servi\00E7o')
,p_link=>'f?p=&FLOW_ID.:96:&SESSION.'
,p_page_id=>96
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(168433621304028939.4355)
,p_parent_id=>wwv_flow_api.id(26633620827671901.4355)
,p_short_name=>'Validar'
,p_link=>'f?p=&FLOW_ID.:2020:&SESSION.'
,p_page_id=>2020
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(168440510037690155.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>unistr('Utiliza\00E7\00E3o do Espa\00E7o de Trabalho')
,p_link=>'f?p=&FLOW_ID.:101:&SESSION.'
,p_page_id=>101
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(168471800193925286.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Gerenciar Reposit\00F3rio de Exporta\00E7\00E3o')
,p_link=>'f?p=&APP_ID.:150:&SESSION.::&DEBUG.:::'
,p_page_id=>150
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(169504715330846340.4355)
,p_parent_id=>wwv_flow_api.id(168433621304028939.4355)
,p_short_name=>unistr('Corrigir Objetos Inv\00E1lidos')
,p_link=>'f?p=&APP_ID.:2030:&SESSION.::&DEBUG.:::'
,p_page_id=>2030
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(173260815365250672.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>unistr('An\00FAncio do Espa\00E7o de Trabalho')
,p_link=>'f?p=&APP_ID.:35:&SESSION.::&DEBUG.:::'
,p_page_id=>35
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180929821403245891.4355)
,p_parent_id=>wwv_flow_api.id(168440510037690155.4355)
,p_short_name=>'E-mail'
,p_link=>'f?p=&APP_ID.:83:&SESSION.::&DEBUG.:::'
,p_page_id=>83
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(196301728610881937.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina por Relat\00F3rio Interativo')
,p_link=>'f?p=&FLOW_ID.:93:&SESSION.'
,p_page_id=>93
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(199842555555432288.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Log da Atividade do Servi\00E7o Web')
,p_link=>'f?p=&APP_ID.:77:&SESSION.'
,p_page_id=>77
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(211677204186361292.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>'Erros do Aplicativo'
,p_link=>'f?p=&FLOW_ID.:62:&SESSION.'
,p_page_id=>62
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(219108507235410015.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>'Hash no Aplicativo por Dia'
,p_link=>'f?p=&APP_ID.:103:&SESSION.'
,p_page_id=>103
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(227883632574956797.4355)
,p_parent_id=>wwv_flow_api.id(168433621304028939.4355)
,p_short_name=>unistr('Corrigir Objetos Inv\00E1lidos')
,p_link=>'f?p=&FLOW_ID.:2040:&SESSION.'
,p_page_id=>2040
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(227921003048164942.4355)
,p_parent_id=>wwv_flow_api.id(26633620827671901.4355)
,p_short_name=>'Criar'
,p_link=>'f?p=&APP_ID.:1030:&SESSION.'
,p_page_id=>1030
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(231647913974343694.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Desempenho do Armazenamento da P\00E1gina no Cache por P\00E1gina')
,p_link=>'f?p=&APP_ID.:61:&SESSION.::&DEBUG.:::'
,p_page_id=>61
,p_required_patch=>wwv_flow_api.id(231647503239340557.4355)
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(231670515622363077.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Desempenho do Armazenamento da P\00E1gina no Cache por Aplicativo')
,p_link=>'f?p=&APP_ID.:67:&SESSION.::&DEBUG.:::'
,p_page_id=>67
,p_required_patch=>wwv_flow_api.id(231647503239340557.4355)
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(246324709362747681.4355)
,p_parent_id=>wwv_flow_api.id(34710616986796822.4355)
,p_short_name=>unistr('Confirmar Solicita\00E7\00E3o de Esquema')
,p_link=>'f?p=&APP_ID.:66:&SESSION.::&DEBUG.:::'
,p_page_id=>66
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(370346095636891220.4355)
,p_parent_id=>wwv_flow_api.id(4281101764933173.4355)
,p_short_name=>unistr('Mensagens de Depura\00E7\00E3o')
,p_link=>'f?p=&APP_ID.:24:&SESSION.'
,p_page_id=>24
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(388567689401599597.4355)
,p_parent_id=>wwv_flow_api.id(.4355)
,p_short_name=>unistr('P\00E1gina Zero')
,p_link=>'f?p=&FLOW_ID.:0:&SESSION.'
,p_page_id=>0
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(435132825806181421.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Definir Per\00EDodo de Relat\00F3rios')
,p_link=>'f?p=&FLOW_ID.:59:&SESSION.'
,p_page_id=>59
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(452547101449603350.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>unistr('Utiliza\00E7\00E3o do Arquivo')
,p_link=>'f?p=&APP_ID.:85:&SESSION.::&DEBUG.:::'
,p_page_id=>85
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(486717514398109366.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>'Views Recentes da Websheet'
,p_link=>'f?p=&FLOW_ID.:94:&SESSION.'
,p_page_id=>94
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(486997905678291815.4355)
,p_parent_id=>wwv_flow_api.id(30025321432264022.4355)
,p_short_name=>unistr('Criar V\00E1rios Usu\00E1rios')
,p_link=>'f?p=&APP_ID.:95:&SESSION.::&DEBUG.:::'
,p_page_id=>95
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(487218900991020779.4355)
,p_parent_id=>wwv_flow_api.id(27257108953740456.4355)
,p_short_name=>unistr('Excluir V\00E1rios Usu\00E1rios')
,p_link=>'f?p=&APP_ID.:57:&SESSION.::&DEBUG.:::'
,p_page_id=>57
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(492154414688867777.4355)
,p_parent_id=>wwv_flow_api.id(493061632558056672.4355)
,p_short_name=>unistr('Relat\00F3rios Salvos')
,p_link=>'f?p=&APP_ID.:98:&SESSION.::&DEBUG.:::'
,p_page_id=>98
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(492713621337622804.4355)
,p_parent_id=>wwv_flow_api.id(493061632558056672.4355)
,p_short_name=>unistr('Relat\00F3rios Salvos')
,p_link=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:::'
,p_page_id=>100
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(493061632558056672.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>unistr('Gerenciar Defini\00E7\00F5es do Relat\00F3rio Interativo')
,p_link=>'f?p=&APP_ID.:104:&SESSION.::&DEBUG.:::'
,p_page_id=>104
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(563547281943439302.4355)
,p_parent_id=>wwv_flow_api.id(563644659835658277.4355)
,p_short_name=>'Cache da Coluna da Tabela'
,p_link=>'f?p=&APP_ID.:801:&SESSION.::&DEBUG.:::'
,p_page_id=>801
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(563644659835658277.4355)
,p_parent_id=>wwv_flow_api.id(4325919922137501.4355)
,p_short_name=>unistr('Cache do Dicion\00E1rio de Dados')
,p_link=>'f?p=&APP_ID.:800:&SESSION.::&DEBUG.:::'
,p_page_id=>800
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(880570494862638647.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Atividade do Espa\00E7o de Trabalho por Dia')
,p_link=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.:RP::'
,p_page_id=>76
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1760797156082373066.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor por Hora')
,p_link=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:::'
,p_page_id=>23
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1760815418654431335.4355)
,p_parent_id=>wwv_flow_api.id(4092600585280040.4355)
,p_short_name=>unistr('Views de P\00E1gina por Usu\00E1rio por Hora')
,p_link=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.:::'
,p_page_id=>39
);
end;
/
prompt --application/shared_components/user_interface/templates/page/done_popup
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(80887301212076531.4355)
,p_theme_id=>3
,p_name=>'(Done) Popup.pt-br'
,p_internal_name=>'DONE_POPUP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'    <title>#TITLE#</title>',
'    <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'    ',
'    #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="aPopupPage">',
'    <noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>#REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##BODY#</div>',
'<div style="text-align:middle;">#REGION_POSITION_08#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>19940022257958945.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(485889499804058937.4355)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog.pt-br'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog_with_right_sidebar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(492730147881440540.4355)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog with Right Sidebar.pt-br'
,p_internal_name=>'APEX_5.0_DIALOG_WITH_RIGHT_SIDEBAR'
,p_is_popup=>true
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody" class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'    <div id="apex-two-col">',
'      <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-splash"><div id="BB">#BODY#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'  <div>#REGION_POSITION_04#</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>18525411970780075.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(692762523503114201.4355)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Edit Screen.pt-br'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4355
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159337545580470361.4355)
,p_page_template_id=>wwv_flow_api.id(692762523503114201.4355)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159338037318470361.4355)
,p_page_template_id=>wwv_flow_api.id(692762523503114201.4355)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(692762974728114205.4355)
,p_theme_id=>3
,p_name=>'APEX 5.0 - No Side Bar.pt-br'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(692763410753114205.4355)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Right Side Bar.pt-br'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222.4355
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159341999297470365.4355)
,p_page_template_id=>wwv_flow_api.id(692763410753114205.4355)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159342405358470365.4355)
,p_page_template_id=>wwv_flow_api.id(692763410753114205.4355)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159342929042470365.4355)
,p_page_template_id=>wwv_flow_api.id(692763410753114205.4355)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159343432428470366.4355)
,p_page_template_id=>wwv_flow_api.id(692763410753114205.4355)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159343967801470366.4355)
,p_page_template_id=>wwv_flow_api.id(692763410753114205.4355)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159344416583470366.4355)
,p_page_template_id=>wwv_flow_api.id(692763410753114205.4355)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159344975950470367.4355)
,p_page_template_id=>wwv_flow_api.id(692763410753114205.4355)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(718401914085176458.4355)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Page.pt-br'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_workspace_login
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(797610818331805206.4355)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Workspace Login.pt-br'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN'
,p_is_popup=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$(function() {',
'  $(''a[href*="#"]:not([href="#"])'').click(function() {',
'    if (location.pathname.replace(/^\//,'''') == this.pathname.replace(/^\//,'''') && location.hostname == this.hostname) {',
'      var target = $(this.hash);',
'      target = target.length ? target : $(''[name='' + this.hash.slice(1) +'']'');',
'      if (target.length) {',
'        $(''html,body'').animate({',
'          scrollTop: target.offset().top',
'        }, 500);',
'        return false;',
'      }',
'    }',
'  });',
'});'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--login #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'<div class="u-Layout u-Layout--centerVertically a-Login-slide" id="top">',
'  #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Login-container">',
'  #BODY#',
'  </div>',
'  <div class="a-Login-slideNav a-Login-slideNav--down">',
'    <a href="#info" class="a-Login-slideNavLink"><span class="a-Icon icon-shuttle-down"></span></a>',
'  </div>',
'</div>',
'<div class="u-Layout u-Layout--centerVertically a-Login-slide a-Login-slide--secondary" id="info">',
'  <div class="a-Login-secondaryContent">',
'  #REGION_POSITION_03#',
'  </div>',
'  <div class="a-Login-slideNav  a-Login-slideNav--up">',
'    <a href="#top" class="a-Login-slideNavLink"><span class="a-Icon icon-shuttle-up"></span></a>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>781632627194221102.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_workspace_login_secondary_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(797616476051845768.4355)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Workspace Login Secondary Page.pt-br'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_SECONDARY_PAGE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--login #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'<div class="u-Layout u-Layout--centerVertically a-Login-slide" id="top">',
'  #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Login-container">',
'  #BODY#',
'  </div>',
'</div>',
'#REGION_POSITION_03#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_image_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(3791829543328.4355)
,p_template_name=>'HTML image (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_IMAGE_LEGACY_APEX_5_MIGRATION'
,p_template=>'<a href="#LINK#" id="#BUTTON_ID#" title="#LABEL!ATTR#"><img src="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" border="#" #BUTTON_ATTRIBUTES# /></a>'
,p_hot_template=>'<a href="#LINK#" id="#BUTTON_ID#" title="#LABEL!ATTR#"><img src="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" border="#" #BUTTON_ATTRIBUTES# /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_next_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(208548517895320411.4355)
,p_template_name=>'APEX 4.2 - Next Button'
,p_internal_name=>'APEX_4.2_NEXT_BUTTON'
,p_template=>'<button class="aButton nextButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" class="nextBlack" alt=""/></span></button>'
,p_hot_template=>'<button class="aButton hotButton nextButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" class="nextWhite" alt=""/></span></button>'
,p_reference_id=>40780910892272674.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_previous_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(208548713965320411.4355)
,p_template_name=>'APEX 4.2 - Previous Button'
,p_internal_name=>'APEX_4.2_PREVIOUS_BUTTON'
,p_template=>'<button title="#LABEL!ATTR#" class="aButton prevButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevBlack" alt="#LABEL!ATTR#" /></span></button>'
,p_hot_template=>'<button title="#LABEL!ATTR#" class="aButton hotButton prevButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevWhite" alt="#LABEL!ATTR#" /></span></button>'
,p_reference_id=>40781222929295107.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_icon_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(258479618231884825.4355)
,p_template_name=>'APEX 4.2 - Icon Button'
,p_internal_name=>'APEX_4.2_ICON_BUTTON'
,p_template=>'<a href="#LINK#" class="aIconButton" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES# role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" /></a>'
,p_hot_template=>'<a href="#LINK#" class="aIconButton" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES# role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" /></a>'
,p_reference_id=>46198532248154431.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>0
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="xpbutton" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tbody class="FFFFFF">',
'<tr>',
'<td class="L" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'<td class="C"><a href="#LINK#">#LABEL#</a></td>',
'<td class="R" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'</tr>',
'</tbody>',
'</table>'))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_1_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(297663202145957383.4355)
,p_template_name=>'APEX 4.1 - Button'
,p_internal_name=>'APEX_4.1_BUTTON'
,p_template=>'<button class="aButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_hot_template=>'<button class="aButton hotButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_reference_id=>275775519061831382.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="button-gray" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> ',
'',
'',
'<a href="#LINK#" class="button-orange" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> '))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(388537948307476852.4355)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(388538190684476853.4355)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_button_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(485869694622026879.4355)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_BUTTON_LEGACY_APEX_5_MIGRATION'
,p_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(486003960305193183.4355)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_large
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(486004148112193187.4355)
,p_template_name=>'APEX 5.0 - Button (Large)'
,p_internal_name=>'APEX_5.0_BUTTON_LARGE'
,p_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--large #BUTTON_CSS_CLASSES#" type="button" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--large a-Button--hot #BUTTON_CSS_CLASSES#" type="button" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174756119980565636.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_small
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(486004439750193187.4355)
,p_template_name=>'APEX 5.0 - Button (Small)'
,p_internal_name=>'APEX_5.0_BUTTON_SMALL'
,p_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--small #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--small a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174755910284562884.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(486004758462193187.4355)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/dialog_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(486005281398193188.4355)
,p_template_name=>'Dialog Button'
,p_internal_name=>'DIALOG_BUTTON'
,p_template=>'"#LABEL!ATTR#":#BUTTON_ATTRIBUTES#'
,p_reference_id=>428602020814722967.4355
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/no_buttons_no_title
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(18911811464281343.4355)
,p_layout=>'TABLE'
,p_template=>'<table class="htmldbRR" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#"><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>'
,p_page_plug_template_name=>'No Buttons No Title'
,p_internal_name=>'NO_BUTTONS_NO_TITLE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>90546300508951267.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_message_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(29439604845311434.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-SystemMessage #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Message Region'
,p_internal_name=>'APEX_5.0_MESSAGE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>29333927116050844.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_large
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(30016706698215740.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Large'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_LARGE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>27763613494297374.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_small_blue_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(30017504140215775.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Small (Blue Top)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_SMALL_BLUE_TOP'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>26881811222918187.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/div_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(30347228019736370.4355)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'Div  with ID (c:htmldbHID)'
,p_internal_name=>'DIV_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>245224629509817478.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_small_gray_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(32633710970357971.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Small (Gray Top)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_SMALL_GRAY_TOP'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>32612420016685806.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar_100
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(34074202387975945.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar (100%)'
,p_internal_name=>'APEX_4.0_TOP_BAR_100%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17357218626599946.4355
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(40275409253350646.4355)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #COMPONENT_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Page Anchors'
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17354206769599941.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/gray_box_c_htmldbgbr_100_from_4999
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(47252630300569314.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading editRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'      <a href="#" class="aIconButton" onclick="uF();return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" class="upIcon" alt="&TOP." /></a>',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Gray Box (c:htmldbGBR) (100%)  From 4999'
,p_internal_name=>'GRAY_BOX_C:HTMLDBGBR_100%_FROM_4999'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17353903289599940.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(48533119259303364.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar (Gray Header)'
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/report_region_c_htmldbreportregion_from_4999
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(60932116232746047.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" style="width:100%">',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title"><h2>#TITLE#</h2></div>',
'    <div class="rc-buttons">#EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Report Region (c:htmldbReportRegion)  From 4999'
,p_internal_name=>'REPORT_REGION_C:HTMLDBREPORTREGION_FROM_4999'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>17354512447599941.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/info_c_htmldbinfo_from_4999
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(79598426990781464.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Info (c:htmldbInfo) from 4999'
,p_internal_name=>'INFO_C:HTMLDBINFO_FROM_4999'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(106671321669750604.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box'
,p_internal_name=>'WIZARD_BOX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar_99
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(169070213366124294.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="topbar" style="width:99%;clear:both;" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="topbar-top"><div class="topbar-top-r"></div></div>',
'  <div class="topbar-body"><div class="topbar-body-r"><div class="topbar-content">',
'      <div style="float:left">#BODY#</div>',
'      <div style="float:right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</div>',
'   </div></div></div>',
'  <div class="topbar-bottom"><div class="topbar-bottom-r"></div></div>',
'</div>',
'<br />'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar (99%)'
,p_internal_name=>'APEX_4.0_TOP_BAR_99%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>169048010062038708.4355
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box_confirm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(202306221419259440.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box (Confirm)'
,p_internal_name=>'APEX_4.0_WIZARD_BOX_CONFIRM'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(208383713787306085.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body'
,p_internal_name=>'APEX_4.2_WIZARD_BODY'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209615589242480.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body_divider
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(208384206154306085.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion dividerTop" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'<div class="wizardRegionHeading">',
'  <h1>#TITLE#</h1>',
'  <div class="buttonContainer">',
'#EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'  </div>',
'</div>',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body (Divider)'
,p_internal_name=>'APEX_4.2_WIZARD_BODY_DIVIDER'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209811475242480.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(208384700309306086.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion dividerTop" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_4.2_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210116661242480.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_buttons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(208385230078306087.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardButtonsContainer" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="leftButtons">',
'    #PREVIOUS##DELETE##CHANGE##CLOSE#',
'  </div>',
'  <div class="rightButtons">',
'    #EDIT##CREATE##NEXT#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Buttons'
,p_internal_name=>'APEX_4.2_WIZARD_BUTTONS'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210411889242480.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(388531674152470979.4355)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box_warning
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(451939821989914545.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion warningRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box (Warning)'
,p_internal_name=>'WIZARD_BOX_WARNING'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>162320107014603380.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_navigation
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(466721715306301967.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion sideNavRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar Navigation'
,p_internal_name=>'APEX_4.0_SIDEBAR_NAVIGATION'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>456726627253419549.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(486010891028205826.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174748721787471587.4355
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_top_buttons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(486011409944205836.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--left">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--right">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region (Top Buttons)'
,p_internal_name=>'APEX_5.0_REGION_TOP_BUTTONS'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174747104640428780.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(486012234812205837.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Toolbar-items a-Toolbar-items--left">#PREVIOUS#</div>',
'  <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar'
,p_internal_name=>'APEX_5.0_TOOLBAR'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613705533399534.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(486012902426205838.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--left #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Left)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_LEFT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174628415239478085.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_right
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(486013619316205838.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--right #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Right)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_RIGHT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174629130392501406.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(486014333429205839.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_hidden_heading
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717841909277073684.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region (Hidden Heading)'
,p_internal_name=>'APEX_5.0_REGION_HIDDEN_HEADING'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>717832816842067694.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(720158679964358138.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Wizard-region a-Form #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Wizard-regionHeader">#REGION_HEADER#</div>',
'  <div class="a-Wizard-regionBody">#BODY#</div>',
'  <div class="a-Wizard-regionFooter">#REGION_FOOTER#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Region'
,p_internal_name=>'APEX_5.0_WIZARD_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>702777601713950915.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_title_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(720159283194358177.4355)
,p_layout=>'TABLE'
,p_template=>'<div class="#REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#><h1 class="a-Wizard-title">#TITLE#</h1></div>'
,p_page_plug_template_name=>'APEX 5.0 - Wizard Title Region'
,p_internal_name=>'APEX_5.0_WIZARD_TITLE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>703469000349150769.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(720165508600362771.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_preset_template_options=>'a-ButtonRegion--noUI'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>687153470345619376.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(720186138525572350.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardHeader" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Header'
,p_internal_name=>'APEX_5.0_WIZARD_HEADER'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210710875242480.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(797568474776479154.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>746362351042209764.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_workspace_login_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(797573769515479165.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Login-region a-Form--stretchInputs #REGION_CSS_CLASSES#" id="#REGION_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Login-header">',
'    <span class="a-Login-logo gi-icon-apex-logo-icon"></span>',
'    <h1 class="a-Login-title">#TITLE#</h1>',
'  </div>',
'  <div class="a-Login-body">',
'    #BODY#',
'  </div>',
'  <div class="a-Login-buttons">',
'    #NEXT#',
'  </div>',
'  <div class="a-Login-links">',
'    #EDIT##CREATE#',
'  </div>',
'  #SUB_REGIONS#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Workspace Login Region'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>781637364422290692.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(829445215771671657.4355)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_accordion_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(829454386558680645.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Accordion Region'
,p_internal_name=>'APEX_5.0_ACCORDION_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>747596346966613593.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(829458533922680656.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'      <button class="a-Button a-Button--icon a-Button--hideShow" type="button"></button>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>689955986849128825.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(829463798599680667.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUB_REGION_HEADERS#',
'  #SUB_REGIONS#',
'</div>',
'<script type="text/javascript">',
'    $("##REGION_STATIC_ID#").tabs({',
'      create: function() {',
'        $(this).addClass(''ui-tabs--simpleInset'')',
'      }',
'    });',
'</script>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#">#SUB_REGION_TITLE#</a></li>'
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer-item" id="#SUB_REGION_ID#">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Tabs'
,p_internal_name=>'APEX_5.0_TABS'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>183211208341566300.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_subregion
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(854957815491167190.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="subRegion">',
'<h2>#TITLE#</h2>',
'#BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 4.0 - Sub-Region'
,p_internal_name=>'APEX_4.0_SUBREGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>698829239393878937.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_image_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(17819003571010282.4355)
,p_list_template_current=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_name=>'Simple Image List'
,p_internal_name=>'SIMPLE_IMAGE_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="listwithicon">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>32421627622986728.4355
,p_list_template_comment=>'<img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_large_icons_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(20165427056621106.4355)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX#f_spacer.gif" #IMAGE_ATTR# class="gi-Icon-#IMAGE#" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX#f_spacer.gif" #IMAGE_ATTR# class="gi-Icon-#IMAGE#" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_name=>'[EBA] Large Icons List'
,p_internal_name=>'[EBA]_LARGE_ICONS_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table class="ebaLargeIcons" width="100%" cellspacing="0" cellpadding="0" border="0" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_reference_id=>20148806760577112.4355
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_c_htmldbul_from_4999
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(38499417503989888.4355)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'Unordered List (c:htmldbUl) From 4999'
,p_internal_name=>'UNORDERED_LIST_C:HTMLDBUL_FROM_4999'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_horizontal_list_with_images
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(77000120193659142.4355)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="current">',
'  <div class="image">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" /></a>',
'  </div>',
'  <div class="label">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'  </div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="noncurrent">',
'  <div class="image">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" /></a>',
'  </div>',
'  <div class="label">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'  </div>',
'</div>'))
,p_list_template_name=>'APEX 4.0 - Horizontal List with Images'
,p_internal_name=>'APEX_4.0_HORIZONTAL_LIST_WITH_IMAGES'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="apex-list-horizontal">'
,p_list_template_after_rows=>'</div>'
,p_reference_id=>17386714276888490.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/list/copy_of_apex_4_0_mike_region_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(168717528748286543.4355)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'Copy of APEX 4.0 MIKE Region Navigation'
,p_internal_name=>'COPY_OF_APEX_4.0_MIKE_REGION_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4355
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_pull_down_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(187163514263710745.4355)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_name=>'APEX 4.0 - Pull Down Tabs'
,p_internal_name=>'APEX_4.0_PULL_DOWN_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div id="tabs" class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul id="S#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="aTabs dhtmlSubMenu pulldown-tabs" style="display:none;">',
''))
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_reference_id=>9651611091899590.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_wizard_progress_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(208376827287299755.4355)
,p_list_template_current=>'<li class="#LIST_STATUS#"><span>#TEXT#</span></li>'
,p_list_template_noncurrent=>'<li class="#LIST_STATUS#"><span>#TEXT#</span></li>'
,p_list_template_name=>'APEX 4.2 - Wizard Progress Bar'
,p_internal_name=>'APEX_4.2_WIZARD_PROGRESS_BAR'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardProgress">',
'<ul>'))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'</div>'))
,p_reference_id=>42216127932260877.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(388535020971474291.4355)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(388535333575474292.4355)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(692750374873071023.4355)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(717846892308122004.4355)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508.4355
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(720190141563578035.4355)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sub_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(829468732055693490.4355)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Sub Tabs'
,p_internal_name=>'APEX_5.0_SUB_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4355
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(829471944455703874.4355)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(6659715068668103.4355)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report from 4999'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003.4355
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(6659715068668103.4355)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/quick_pick_list_items
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(11670410466357416.4355)
,p_row_template_name=>'quick_pick_list_items'
,p_internal_name=>'QUICK_PICK_LIST_ITEMS'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4355
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(11670410466357416.4355)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(43021310970202834.4355)
,p_row_template_name=>'APEX 5.0 - Portlet  Column Template'
,p_internal_name=>'APEX_5.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(46765105410141325.4355)
,p_row_template_name=>'APEX 5.0 - Portlet Row Template'
,p_internal_name=>'APEX_5.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_row_template_one_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(47025022336023416.4355)
,p_row_template_name=>'APEX 4.0 - Portlet Row Template (one column)'
,p_internal_name=>'APEX_4.0_PORTLET_ROW_TEMPLATE_ONE_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="report-row">',
'  <div class="report-col-hdr">#1#</div>',
'</div>',
''))
,p_row_template_before_rows=>'<div class="report-portlet" #REPORT_ATTRIBUTES# id="#REGION_ID#"><div class="report-record">'
,p_row_template_after_rows=>'</div></div>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46783029065220201.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_named_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(770822958504300751.4355)
,p_row_template_name=>'APEX 5.0 - Badge List (Named Column)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_NAMED_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(770827785027300814.4355)
,p_row_template_name=>'APEX 5.0 - Badge List (Row)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
'  <span class="t-BadgeList-label">#1#</span>',
'  <span class="t-BadgeList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>6
,p_reference_id=>689060248369886348.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(770828451758300816.4355)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4355
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(770828451758300816.4355)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(770829717235300818.4355)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4355
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(770829717235300818.4355)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/label_tag_only
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(4927331448760529.4355)
,p_template_name=>'LABEL Tag Only'
,p_internal_name=>'LABEL_TAG_ONLY'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(7301320786376802.4355)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(107534131274292840.4355)
,p_template_name=>'FormField_Optional'
,p_internal_name=>'FORMFIELD_OPTIONAL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17388415351892041.4355
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_required
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(107535006471295136.4355)
,p_template_name=>'FormField_Required'
,p_internal_name=>'FORMFIELD_REQUIRED'
,p_template_body1=>'<em>*</em><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aRequired"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>' <span class="hideMeButHearMe">(#VALUE_REQUIRED#)</span></a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>2
,p_reference_id=>17388508175892042.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/htmldb_greenarealabel_c_htmldbgalabel
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(355525708739902293.4355)
,p_template_name=>'htmldb_GreenAreaLabel (c:htmldbGALabel)'
,p_internal_name=>'HTMLDB_GREENAREALABEL_C:HTMLDBGALABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_4_0_top_bar_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(450569121489682306.4355)
,p_template_name=>'APEX 4.0 - Top Bar Label'
,p_internal_name=>'APEX_4.0_TOP_BAR_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(489153051785943514.4355)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487444299516703815.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(489153170799943531.4355)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487443659585685414.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_workspace_login_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(797617751200847238.4355)
,p_template_name=>'APEX 5.0 - Workspace Login Label'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Icon a-Login-iconLabel">'
,p_template_body2=>'</label>'
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#"><div class="a-Form-inputContainer">'
,p_after_item=>'</div></div>'
,p_after_element=>'<span class="a-Login-iconValidation a-Icon icon-check"></span>#ERROR_TEMPLATE#'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help"></span><span class="u-VisuallyHidden">#CURRENT_ITE'
||'M_HELP_LABEL#</span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>781637020106265852.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(805713983989099558.4355)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>687907221148719616.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(829426714251135780.4355)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492676964457041934.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(829426906030135803.4355)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492677038682043223.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(4094616517288262.4355)
,p_name=>'breadcrumbs'
,p_internal_name=>'BREADCRUMBS'
,p_current_page_option=>'<span class="htmldbBreadcrumb">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#" class="htmldbBreadcrumb" title="#NAME#">#NAME#</a>'
,p_between_levels=>'<span class="htmldbBreadcrumbSep"><img alt="" src="#IMAGE_PREFIX#apex/apex_top_sep.gif"></span>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>60115300853820165.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(388538606549481005.4355)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>689285808648404711.4355
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(13478004473367504.4355)
,p_page_name=>'winlov'
,p_page_title=>unistr('Caixa de Di\00E1logo Pesquisar')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>'Pesquisar'
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>'Fechar'
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>unistr('Pr\00F3ximo &gt;')
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>'&lt; Anterior'
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>'<div class="a-PopupLOV-pagination">Linha(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17343114994581872.4355
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/htmldb_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(50595123809626578.4355)
,p_cal_template_name=>'HTMLDB Calendar'
,p_internal_name=>'HTMLDB_CALENDAR'
,p_day_of_week_format=>'<th scope="col" width="14%" class="htmldbDayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbCalendarHolder" cellpadding="0" cellspacing="0" border="0" width="100%" summary="" role="presentation"><tr>',
'<td class="htmldbMonthTitle">#IMONTH# #YYYY#</td>',
'</tr>',
'<tr><td>'))
,p_month_open_format=>'<table class="htmldbCalendar" cellpadding="0" cellspacing="3" border="0" width="100%" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td></tr></table>',
'',
''))
,p_day_title_format=>'<div class="htmldbDayTitle">#DD#</div>'
,p_day_open_format=>'<td class="htmldbDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="htmldbToday">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="htmldbWeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td class="htmldbWeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="htmldbNonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="htmldbNonDay">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>353925314576528967.4355
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/apex_4_0_default_calander
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(429989326510150689.4355)
,p_cal_template_name=>'APEX 4.0 Default Calander'
,p_internal_name=>'APEX_4.0_DEFAULT_CALANDER'
,p_day_of_week_format=>'<th scope="col" width="14%" class="htmldbDayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbCalendarHolder" cellpadding="0" cellspacing="0" border="0" width="100%" summary="" role="presentation"><tr>',
'<td class="htmldbMonthTitle">#IMONTH# #YYYY#</td>',
'</tr>',
'<tr><td>'))
,p_month_open_format=>'<table class="htmldbCalendar" cellpadding="0" cellspacing="3" border="0" width="100%" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td></tr></table>',
'',
''))
,p_day_title_format=>'<div class="htmldbDayTitle">#DD#</div>'
,p_day_open_format=>'<td class="htmldbDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="htmldbToday">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="htmldbWeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td class="htmldbWeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="htmldbNonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="htmldbNonDay">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(72331295244515034.4355)
,p_theme_id=>3
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(204023711571766699.4355)
,p_theme_id=>3
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689640285334993975.4355)
,p_theme_id=>3
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689641104387993975.4355)
,p_theme_id=>3
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689641890550993975.4355)
,p_theme_id=>3
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689643729287993977.4355)
,p_theme_id=>3
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(692750780606071026.4355)
,p_theme_id=>3
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697086486123403004.4355)
,p_theme_id=>3
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697256069906708874.4355)
,p_theme_id=>3
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746393654795391886.4355)
,p_theme_id=>3
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746394927367391887.4355)
,p_theme_id=>3
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746395298555391888.4355)
,p_theme_id=>3
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746395536106391888.4355)
,p_theme_id=>3
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746396667408391888.4355)
,p_theme_id=>3
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746396989722391888.4355)
,p_theme_id=>3
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746397289357391888.4355)
,p_theme_id=>3
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746397595401391891.4355)
,p_theme_id=>3
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746397833448391891.4355)
,p_theme_id=>3
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746398369579391892.4355)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746398688326391894.4355)
,p_theme_id=>3
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(770823390186300758.4355)
,p_theme_id=>3
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(770823825914300766.4355)
,p_theme_id=>3
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(770830294703300821.4355)
,p_theme_id=>3
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(770830568775300821.4355)
,p_theme_id=>3
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(770830880737300822.4355)
,p_theme_id=>3
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(770831461915300822.4355)
,p_theme_id=>3
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(797568847627479160.4355)
,p_theme_id=>3
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(797569107979479163.4355)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(697205003669627560.4355)
,p_theme_id=>3
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(692750780606071026)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(697205322334627560.4355)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(692750780606071026)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(697205656478627560.4355)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(692750780606071026)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(697205962987627560.4355)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(692750780606071026)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(697206272842627560.4355)
,p_theme_id=>3
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(692750780606071026)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(697206541642627561.4355)
,p_theme_id=>3
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(697206893304627561.4355)
,p_theme_id=>3
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(697207116811627561.4355)
,p_theme_id=>3
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(697207482365627561.4355)
,p_theme_id=>3
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(697207795800627561.4355)
,p_theme_id=>3
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720168495179362789.4355)
,p_theme_id=>3
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(720165508600362771.4355)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720168737661362789.4355)
,p_theme_id=>3
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(720165508600362771.4355)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(689641890550993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720169093834362789.4355)
,p_theme_id=>3
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(720165508600362771.4355)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(689641890550993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720169320057362789.4355)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(720165508600362771.4355)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720169612442362790.4355)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(720165508600362771.4355)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720169962201362790.4355)
,p_theme_id=>3
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(720165508600362771.4355)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720170263853362790.4355)
,p_theme_id=>3
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(720165508600362771.4355)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_api.id(697086486123403004)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720170590608362790.4355)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(720165508600362771.4355)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_api.id(697086486123403004)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746393738081391886.4355)
,p_theme_id=>3
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_api.id(746393654795391886)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746393946513391887.4355)
,p_theme_id=>3
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_api.id(746393654795391886)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746394166942391887.4355)
,p_theme_id=>3
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_api.id(746393654795391886)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746394309853391887.4355)
,p_theme_id=>3
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_api.id(746393654795391886)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746394522694391887.4355)
,p_theme_id=>3
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_api.id(746393654795391886)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746394779452391887.4355)
,p_theme_id=>3
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_api.id(746393654795391886)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746395019878391887.4355)
,p_theme_id=>3
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(746394927367391887)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746395380241391888.4355)
,p_theme_id=>3
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_api.id(746395298555391888)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746395600089391888.4355)
,p_theme_id=>3
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_api.id(746395536106391888)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746395886384391888.4355)
,p_theme_id=>3
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_api.id(746395298555391888)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746396068348391888.4355)
,p_theme_id=>3
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_api.id(746395298555391888)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746396210061391888.4355)
,p_theme_id=>3
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_api.id(746395298555391888)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746396402377391888.4355)
,p_theme_id=>3
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_api.id(746395536106391888)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746396798561391888.4355)
,p_theme_id=>3
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_api.id(746396667408391888)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746397056950391888.4355)
,p_theme_id=>3
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(746396989722391888)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746397329794391888.4355)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_api.id(746397289357391888)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746397664395391891.4355)
,p_theme_id=>3
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(746397595401391891)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746397991614391892.4355)
,p_theme_id=>3
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_api.id(746397833448391891)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746398179522391892.4355)
,p_theme_id=>3
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(746395536106391888)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746398463551391892.4355)
,p_theme_id=>3
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746398369579391892)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746398734776391894.4355)
,p_theme_id=>3
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_api.id(746398688326391894)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746398858248391894.4355)
,p_theme_id=>3
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746399096840391894.4355)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_api.id(746397289357391888)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746399252498391894.4355)
,p_theme_id=>3
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_api.id(746397595401391891)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746399411992391894.4355)
,p_theme_id=>3
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_api.id(746397833448391891)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746399588502391894.4355)
,p_theme_id=>3
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746399637338391898.4355)
,p_theme_id=>3
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770825244829300814.4355)
,p_theme_id=>3
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_api.id(770823390186300758)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770825494601300814.4355)
,p_theme_id=>3
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(770823390186300758)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770825628874300814.4355)
,p_theme_id=>3
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(770823390186300758)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770825870229300814.4355)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_api.id(770823825914300766)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770826028180300814.4355)
,p_theme_id=>3
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(770823825914300766)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770826263361300814.4355)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_api.id(770823825914300766)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770826410150300814.4355)
,p_theme_id=>3
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(770823825914300766)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770826644429300814.4355)
,p_theme_id=>3
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(770823825914300766)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770826826983300814.4355)
,p_theme_id=>3
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(770823390186300758)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770827012098300814.4355)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(770823390186300758)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770827235754300814.4355)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(770823390186300758)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770827447408300814.4355)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(770823390186300758)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(770827697507300814.4355)
,p_theme_id=>3
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770822958504300751.4355)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(770823390186300758)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787128846439949734.4355)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770829717235300818.4355)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(770830294703300821)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787129076990949734.4355)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770829717235300818.4355)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(770830568775300821)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787129211664949734.4355)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770829717235300818.4355)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(770830880737300822)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787129478553949735.4355)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770829717235300818.4355)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(770830880737300822)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787129664604949735.4355)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770829717235300818.4355)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(770830880737300822)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787129797417949735.4355)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770829717235300818.4355)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787129942802949735.4355)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770829717235300818.4355)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(770831461915300822)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797570360313479164.4355)
,p_theme_id=>3
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(797568474776479154.4355)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797570478965479164.4355)
,p_theme_id=>3
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(797568474776479154.4355)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797570646853479165.4355)
,p_theme_id=>3
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(797568474776479154.4355)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_api.id(797568847627479160)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797570895501479165.4355)
,p_theme_id=>3
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(797568474776479154.4355)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_api.id(797568847627479160)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797571042081479165.4355)
,p_theme_id=>3
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(797568474776479154.4355)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_api.id(797568847627479160)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797571272421479165.4355)
,p_theme_id=>3
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(797568474776479154.4355)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(797569107979479163)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797571447867479165.4355)
,p_theme_id=>3
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(797568474776479154.4355)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_api.id(797569107979479163)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797571501534479165.4355)
,p_theme_id=>3
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(797568474776479154.4355)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797571791611479165.4355)
,p_theme_id=>3
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(797568474776479154.4355)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_api.id(797568847627479160)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829456396120680656.4355)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(697086486123403004)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829456489387680656.4355)
,p_theme_id=>3
,p_name=>'ADDBOTTOMBORDER'
,p_display_name=>'Add Bottom Border'
,p_display_sequence=>13
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--bottomBorder'
,p_template_types=>'REGION'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829456523812680656.4355)
,p_theme_id=>3
,p_name=>'ADDLEFTBORDER'
,p_display_name=>'Add Left Border'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--borderLeft'
,p_template_types=>'REGION'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829456697529680656.4355)
,p_theme_id=>3
,p_name=>'ADDRIGHTBORDER'
,p_display_name=>'Add Right Border'
,p_display_sequence=>11
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--rightBorder'
,p_template_types=>'REGION'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829456721655680656.4355)
,p_theme_id=>3
,p_name=>'ADDTOPBORDER'
,p_display_name=>'Add Top Border'
,p_display_sequence=>12
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--borderTop'
,p_template_types=>'REGION'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829456928276680656.4355)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689643729287993977)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829457167899680656.4355)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(689641890550993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829457377910680656.4355)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829457428483680656.4355)
,p_theme_id=>3
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829457686604680656.4355)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(697086486123403004)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829457873432680656.4355)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829458099623680656.4355)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689643729287993977)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(829458157107680656.4355)
,p_theme_id=>3
,p_name=>'SHOWTOPBUTTON'
,p_display_name=>'Show Top Button'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829454386558680645.4355)
,p_css_classes=>'a-Region--showTopButton'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926399656957707535.4355)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(388535333575474292.4355)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926399745454707535.4355)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(388535333575474292.4355)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(940696690156341580.4355)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(720190141563578035.4355)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1199561127830032419.4355)
,p_theme_id=>3
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(486004758462193187.4355)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746398369579391892)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525661359651182107.4355)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525661463198182107.4355)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525661538921182107.4355)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525661634515182108.4355)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525661803623182108.4355)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(697256069906708874)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525662055051182108.4355)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(697256069906708874)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525664505544182122.4355)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525664603775182122.4355)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525664790107182122.4355)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525664816420182122.4355)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525665087495182122.4355)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(697256069906708874)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525665273167182122.4355)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(697256069906708874)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544816639795478003.4355)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770828451758300816.4355)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544816735968478004.4355)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770828451758300816.4355)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544816822442478004.4355)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(770828451758300816.4355)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544817297983478008.4355)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(11670410466357416.4355)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544817313883478008.4355)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(11670410466357416.4355)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544817462934478008.4355)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(11670410466357416.4355)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554821911032408403.4355)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(697086486123403004)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554822194319408403.4355)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(697086486123403004)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554822304112408403.4355)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554822529201408404.4355)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554822705386408404.4355)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(689641104387993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554822968912408404.4355)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(689641890550993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554823153887408404.4355)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689643729287993977)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554823379060408404.4355)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689643729287993977)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554823546082408404.4355)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554823609760408404.4355)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554823847364408404.4355)
,p_theme_id=>3
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(486010891028205826.4355)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(689641890550993975)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554834147729526820.4355)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(829445215771671657.4355)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554834211041526820.4355)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829445215771671657.4355)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554834394928526820.4355)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829445215771671657.4355)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554850993386542287.4355)
,p_theme_id=>3
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829458533922680656.4355)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554851087148542287.4355)
,p_theme_id=>3
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829458533922680656.4355)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554851242750542287.4355)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829458533922680656.4355)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554851473200542287.4355)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829458533922680656.4355)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554851654292542287.4355)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829458533922680656.4355)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(689641104387993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554851832381542288.4355)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829458533922680656.4355)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(689641890550993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554852037917542288.4355)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829458533922680656.4355)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689643729287993977)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554852288217542288.4355)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829458533922680656.4355)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689643729287993977)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554852446766542288.4355)
,p_theme_id=>3
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_api.id(829458533922680656.4355)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(797569107979479163)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554852695350542289.4355)
,p_theme_id=>3
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829458533922680656.4355)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(797569107979479163)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554864460392550809.4355)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554864671291550809.4355)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(697086486123403004)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554864855569550809.4355)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689643729287993977)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554865036396550809.4355)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(689641890550993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554865266775550809.4355)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554865459115550809.4355)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(697086486123403004)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554865662563550810.4355)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554865849887550810.4355)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689643729287993977)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554866021273550810.4355)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(689641104387993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554866292270550810.4355)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1029955071738136284.4355)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(689640285334993975)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(140268206065172819.4355)
,p_build_option_name=>'Database Monitoring'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(231647503239340557.4355)
,p_build_option_name=>'Page Caching'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(693461267865622287.4355)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/item_help
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(2123222599612374.4355)
,p_shortcut_name=>'ITEM_HELP'
,p_shortcut_type=>'HTML_TEXT'
,p_error_text=>unistr('N\00E3o \00E9 poss\00EDvel mostrar a ajuda.')
,p_shortcut=>'<a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999"><img src="#IMAGE_PREFIX#infoicon_status_gray.gif" width=16 height=16 border=0></a>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/admin_home
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(75628231717105217.4355)
,p_shortcut_name=>'ADMIN_HOME'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<table><tr><td>&nbsp;</td><td><table bgcolor="#ffffff" cellspacing=0 cellpadding=0 border="1"><tr><td><a href="f?p=4350:3:&SESSION."><img src="#IMAGE_PREFIX#people2.gif" width="100" height="75" border="0"></a><br><font size="-2" face="arial">Home de&'
||'nbsp;Admin...</font></td></tr></table></td></tr></table>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(116152925483353324.4355)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('Gostaria de executar esta a\00E7\00E3o de exclus\00E3o?')
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(539691214090646644.4355)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040.4355
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(12505007847150358.4355)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>unistr('Autoriza\00E7\00E3o do Desenvolvedor')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494.4355
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(786909370267512885.4355)
,p_plugin_id=>wwv_flow_api.id(12505007847150358.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786909756053512885.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786910213163512885.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786910731868512885.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786911258467512885.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786911762751512885.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786912298705512886.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786912758734512886.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786913288853512886.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786913734493512886.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786914212305512887.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786914767611512887.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786915213191512892.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(786909370267512885.4355)
,p_display_sequence=>120
,p_display_value=>'PKG_APPS: Ability to install packaged applications'
,p_return_value=>'PKG_APPS'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_searchbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(61354352634419491.4355)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.SEARCHBOX'
,p_display_name=>'Caixa de Pesquisa'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.SEARCHBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_searchbox'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT'
,p_substitute_attributes=>true
,p_reference_id=>42609120788689442.4355
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513169841697230028.4355)
,p_plugin_id=>wwv_flow_api.id(61354352634419491.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Redirect URL'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:<target page>:&SESSION.::&DEBUG.::<target item>:'
,p_display_length=>80
,p_max_length=>4000
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513170249930230028.4355)
,p_plugin_id=>wwv_flow_api.id(61354352634419491.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Search Text'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Search'
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
''))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(113748807145665438.4355)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>unistr('Autentica\00E7\00E3o Apex')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425.4355
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(118564054404916668.4355)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>'INTERNAL Acesso Social'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086.4355
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118564280148916669.4355)
,p_plugin_id=>wwv_flow_api.id(118564054404916668.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118566110971916670.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(118564280148916669.4355)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118564690097916670.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(118564280148916669.4355)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118565185802916670.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(118564280148916669.4355)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118565699125916670.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(118564280148916669.4355)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118566688681916671.4355)
,p_plugin_id=>wwv_flow_api.id(118564054404916668.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118564280148916669.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118567022911916671.4355)
,p_plugin_id=>wwv_flow_api.id(118564054404916668.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118564280148916669.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118567481530916671.4355)
,p_plugin_id=>wwv_flow_api.id(118564054404916668.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118564280148916669.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118567880175916671.4355)
,p_plugin_id=>wwv_flow_api.id(118564054404916668.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118564280148916669.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118568213608916671.4355)
,p_plugin_id=>wwv_flow_api.id(118564054404916668.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Application Express automatically adds the "openid" scope. The authent'
||'ication provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118568630278916672.4355)
,p_plugin_id=>wwv_flow_api.id(118564054404916668.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118569040838916675.4355)
,p_plugin_id=>wwv_flow_api.id(118564054404916668.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118569442257916675.4355)
,p_plugin_id=>wwv_flow_api.id(118564054404916668.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356675029883447688.4355)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>'INTERNAL Oracle Cloud Identity Management'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749806821809026.4355
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356678220661447691.4355)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>'INTERNAL Contas de Banco de Dados'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749511183746276.4355
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356739011564447745.4355)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>unistr('INTERNAL Vari\00E1vel de Cabe\00E7alho HTTP')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>708795120396802284.4355
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356739230427447745.4355)
,p_plugin_id=>wwv_flow_api.id(356739011564447745.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356739613372447745.4355)
,p_plugin_id=>wwv_flow_api.id(356739011564447745.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356740025319447745.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356739613372447745.4355)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356740521160447746.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356739613372447745.4355)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356741018786447746.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356739613372447745.4355)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356741523788447749.4355)
,p_plugin_id=>wwv_flow_api.id(356739011564447745.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356739613372447745.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>',
'<p>',
'<h3>Example:</h3>',
'<pre>http://sso.mycompany.com/?success=#CALLBACK#</pre>',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356741917758447749.4355)
,p_plugin_id=>wwv_flow_api.id(356739011564447745.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(356739613372447745.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356742306094447749.4355)
,p_plugin_id=>wwv_flow_api.id(356739011564447745.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356739613372447745.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'BUILTIN_URL,URL'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356742730617447750.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356742306094447749.4355)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356743207080447750.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356742306094447749.4355)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356743714847447750.4355)
,p_plugin_id=>wwv_flow_api.id(356739011564447745.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356812805052447803.4355)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>unistr('INTERNAL Diret\00F3rio LDAP')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>863910941135523528.4355
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Informe o nome de usu\00E1rio e a senha para autentica\00E7\00E3o no diret\00F3rio LDAP identificado na p\00E1gina de log-in. Lembre-se de que as senhas podem fazer distin\00E7\00E3o entre mai\00FAsculas e min\00FAsculas.</p>'),
''))
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356813001684447803.4355)
,p_plugin_id=>wwv_flow_api.id(356812805052447803.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356813412150447803.4355)
,p_plugin_id=>wwv_flow_api.id(356812805052447803.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356813831745447803.4355)
,p_plugin_id=>wwv_flow_api.id(356812805052447803.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356814217919447803.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356813831745447803.4355)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356814706404447803.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356813831745447803.4355)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356815206641447804.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356813831745447803.4355)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356815700428447804.4355)
,p_plugin_id=>wwv_flow_api.id(356812805052447803.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356816131324447804.4355)
,p_plugin_id=>wwv_flow_api.id(356812805052447803.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356816504735447804.4355)
,p_plugin_id=>wwv_flow_api.id(356812805052447803.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356816131324447804.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356816917591447805.4355)
,p_plugin_id=>wwv_flow_api.id(356812805052447803.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356817328277447805.4355)
,p_plugin_id=>wwv_flow_api.id(356812805052447803.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356817719903447805.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356817328277447805.4355)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356818206709447805.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356817328277447805.4355)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356818717907447807.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(356817328277447805.4355)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356821829039447810.4355)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'INTERNAL SSO do Oracle Application Server'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113750429890071859.4355
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_html5_bar_chart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_display_name=>unistr('Gr\00E1fico de Barras HTML 5 ***')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.HTML5_BAR_CHART'),'#IMAGE_PREFIX#plugins/com.oracle.apex.html5_bar_chart/1.0/')
,p_javascript_file_urls=>'#PLUGIN_FILES#com_oracle_apex_html5_bar_chart.js'
,p_css_file_urls=>'#PLUGIN_FILES#com_oracle_apex_html5_bar_chart.css'
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'FUNCTION RENDER (',
'    P_REGION IN APEX_PLUGIN.T_REGION,',
'    P_PLUGIN IN APEX_PLUGIN.T_PLUGIN,',
'    P_IS_PRINTER_FRIENDLY IN BOOLEAN',
') RETURN APEX_PLUGIN.T_REGION_RENDER_RESULT IS',
'BEGIN',
'    sys.HTP.PRN(''<div id="''||APEX_ESCAPE.HTML_ATTRIBUTE(P_REGION.STATIC_ID)||''_chart" class="hbc">'');',
'    sys.HTP.PRN(''</div>'');',
'    ',
'    APEX_JAVASCRIPT.ADD_ONLOAD_CODE (',
'        P_CODE => ''com_oracle_apex_html5_bar_chart(''||',
'            APEX_JAVASCRIPT.ADD_VALUE(P_REGION.STATIC_ID)||',
'            ''{''||',
'                -- Why is this attribute needed if is not used?',
'                APEX_JAVASCRIPT.ADD_ATTRIBUTE(',
'                    ''pageItems'', ',
'                    APEX_PLUGIN_UTIL.PAGE_ITEM_NAMES_TO_JQUERY(P_REGION.AJAX_ITEMS_TO_SUBMIT)',
'                )||',
'                APEX_JAVASCRIPT.ADD_ATTRIBUTE(',
'                    ''ajaxIdentifier'', ',
'                    APEX_PLUGIN.GET_AJAX_IDENTIFIER, ',
'                    FALSE, ',
'                    FALSE',
'                )||',
'            ''}''||',
'        '');''',
'    );',
'    ',
'    RETURN NULL;',
'END RENDER;',
'',
'FUNCTION AJAX (',
'    P_REGION IN APEX_PLUGIN.T_REGION,',
'    P_PLUGIN IN APEX_PLUGIN.T_PLUGIN',
') RETURN APEX_PLUGIN.T_REGION_AJAX_RESULT IS',
'    -- Map region attributes to function constants',
'    -- MODERN, CLASSIC',
'    C_CHART_TYPE CONSTANT VARCHAR2(7) := P_REGION.ATTRIBUTE_15;',
'    -- MODERN, MODERN_2, SOLAR, METRO, CUSTOM, COLUMN',
'    C_COLOR_SCHEME CONSTANT VARCHAR2(8) := P_REGION.ATTRIBUTE_17;',
'    C_CUSTOM_CHART_COLORS CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_10;',
'    C_COLOR_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_19;',
'    -- NONE, IMAGE, ICON, INITIALS',
'    C_ICON_TYPE CONSTANT VARCHAR2(8) := case when C_CHART_TYPE = ''ICON'' then P_REGION.ATTRIBUTE_01 end;',
'    C_LABEL_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_02;',
'    C_LABEL_LINK CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_03;',
'    C_VALUE_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_04;',
'    C_VALUE_LINK CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_05;',
'    -- ABOVE, AROUND',
'    C_TEXT_POSITION VARCHAR2(6) := P_REGION.ATTRIBUTE_18;',
'    C_CHART_CSS_CLASSES CONSTANT VARCHAR2(32767) := P_REGION.ATTRIBUTE_06;',
'    C_IMAGE_URL CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_07;',
'    C_CSS_ICON_CLASS_NAME CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_08;',
'    C_INITIALS_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_09;',
'    -- ABSOLUTE, RELATIVE',
'    C_BAR_WIDTH_CALCULATION CONSTANT VARCHAR2(8) := P_REGION.ATTRIBUTE_16;',
'    C_DISPLAY CONSTANT VARCHAR2(19) := P_REGION.ATTRIBUTE_11;',
'    C_PREFIX_FOR_VALUE CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_12;',
'    C_POSTFIX_FOR_VALUE CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_13;',
'    C_MAXIMUM_ROWS CONSTANT NUMBER := P_REGION.ATTRIBUTE_14;',
'    C_MESSAGE_WHEN_NO_DATA_FOUND CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_20;',
'    ',
'    L_COLOR_COLUMN_NUMBER PLS_INTEGER;',
'    L_LABEL_COLUMN_NUMBER PLS_INTEGER;',
'    L_VALUE_COLUMN_NUMBER PLS_INTEGER;',
'    L_INITIALS_COLUMN_NUMBER PLS_INTEGER;',
'    ',
'    L_COLUMN_VALUE_LIST APEX_PLUGIN_UTIL.T_COLUMN_VALUE_LIST2;',
'    ',
'    L_COLOR VARCHAR2(4000) := NULL;',
'    L_LABEL VARCHAR2(4000) := NULL;',
'    L_LABEL_LINK VARCHAR2(4000) := NULL;',
'    L_VALUE VARCHAR2(4000) := NULL;',
'    L_VALUE_LINK VARCHAR2(4000) := NULL;',
'    L_IMAGE_URL VARCHAR2(4000) := NULL;',
'    L_CSS_ICON_CLASS_NAME VARCHAR2(4000) := NULL;',
'    L_INITIALS VARCHAR2(4000) := NULL;',
'    L_MESSAGE_WHEN_NO_DATA_FOUND VARCHAR2(4000) := NULL;',
'',
'    L_CUSTOM_CHART_COLORS_TABLE APEX_APPLICATION_GLOBAL.VC_ARR2;',
'    L_CUSTOM_CHART_COLORS VARCHAR2(32767) := NULL;',
'BEGIN',
'    L_COLUMN_VALUE_LIST := APEX_PLUGIN_UTIL.GET_DATA2(',
'        P_SQL_STATEMENT  => P_REGION.SOURCE,',
'        P_MIN_COLUMNS    => 1,',
'        P_MAX_COLUMNS    => NULL,',
'        P_COMPONENT_NAME => P_REGION.NAME,',
'        P_MAX_ROWS => C_MAXIMUM_ROWS',
'    );',
'',
'    L_COLOR_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Color Column'',',
'        P_COLUMN_ALIAS      => C_COLOR_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => C_COLOR_SCHEME = ''COLUMN'',',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    L_LABEL_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Label Column'',',
'        P_COLUMN_ALIAS      => C_LABEL_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => TRUE,',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    L_VALUE_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Value Column'',',
'        P_COLUMN_ALIAS      => C_VALUE_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => TRUE,',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    if C_ICON_TYPE = ''INITIALS'' then',
'        L_INITIALS_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'            P_ATTRIBUTE_LABEL   => ''Initials Column'',',
'            P_COLUMN_ALIAS      => C_INITIALS_COLUMN,',
'            P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'            P_IS_REQUIRED       => true,',
'            P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'        );',
'    end if;',
'    -- Begin output as JSON',
'    sys.OWA_UTIL.MIME_HEADER(''application/json'', FALSE);',
'    sys.HTP.P(''Cache-Control: no-cache'');',
'    sys.HTP.P(''Pragma: no-cache'');',
'    sys.OWA_UTIL.HTTP_HEADER_CLOSE;',
'    ',
'    IF C_COLOR_SCHEME = ''CUSTOM'' THEN',
'        L_CUSTOM_CHART_COLORS_TABLE := APEX_UTIL.STRING_TO_TABLE(CASE WHEN C_CUSTOM_CHART_COLORS IS NOT NULL THEN TRIM(BOTH '''''''' FROM APEX_ESCAPE.JS_LITERAL(C_CUSTOM_CHART_COLORS)) END, '':'');',
'        L_CUSTOM_CHART_COLORS := ''"color_scheme":['';',
'        FOR I IN L_CUSTOM_CHART_COLORS_TABLE.FIRST .. L_CUSTOM_CHART_COLORS_TABLE.LAST LOOP',
'            IF I > 1 THEN',
'                L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||'','';',
'            END IF;',
'            L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||''"''||L_CUSTOM_CHART_COLORS_TABLE(I)||''"'';',
'        END LOOP;',
'        L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||''],'';',
'    END IF;',
'',
'    L_MESSAGE_WHEN_NO_DATA_FOUND := APEX_ESCAPE.HTML_WHITELIST(',
'        APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                P_VALUE  => C_MESSAGE_WHEN_NO_DATA_FOUND,',
'                P_ESCAPE => FALSE',
'            )',
'        );',
'',
'    sys.HTP.PRN(',
'        ''{''||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''chart_type'',',
'                C_CHART_TYPE,',
'                FALSE,',
'                TRUE',
'            )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''message_when_no_data_found'',',
'            L_MESSAGE_WHEN_NO_DATA_FOUND,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''chart_css_class_names'',',
'            C_CHART_CSS_CLASSES,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''icon_type'',',
'            C_ICON_TYPE,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    IF C_COLOR_SCHEME = ''CUSTOM'' THEN',
'        sys.HTP.PRN(',
'            L_CUSTOM_CHART_COLORS',
'        );',
'    ELSE',
'        sys.HTP.PRN(',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''color_scheme'',',
'                C_COLOR_SCHEME,',
'                TRUE,',
'                TRUE',
'            )',
'        );',
'    END IF;',
'    sys.HTP.PRN(',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''text_position'',',
'                C_TEXT_POSITION,',
'                FALSE,',
'                TRUE',
'            )||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''bar_width_calculation'',',
'                C_BAR_WIDTH_CALCULATION,',
'                FALSE,',
'                TRUE',
'            )||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''display'',',
'                C_DISPLAY,',
'                FALSE,',
'                TRUE',
'            )||',
'            CASE ',
'            	WHEN C_DISPLAY IN (''VALUE'') THEN',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''prefix_for_value'',',
'						C_PREFIX_FOR_VALUE,',
'						TRUE,',
'						TRUE',
'					)||',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''postfix_for_value'',',
'						C_POSTFIX_FOR_VALUE,',
'						TRUE,',
'						TRUE',
'					)',
'			END||',
'            ''"items":[''',
'    );',
'    ',
'    --FOR L_ROW_NUMBER IN L_COLUMN_VALUE_LIST(1).VALUE_LIST.FIRST .. L_COLUMN_VALUE_LIST(1).VALUE_LIST.LAST LOOP',
'    FOR L_ROW_NUMBER IN 1 .. L_COLUMN_VALUE_LIST(1).VALUE_LIST.COUNT LOOP',
'        BEGIN',
'            APEX_PLUGIN_UTIL.SET_COMPONENT_VALUES (',
'                P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'                P_ROW_NUM => L_ROW_NUMBER ',
'            );',
'            ',
'            IF L_ROW_NUMBER > 1 THEN',
'            	sys.HTP.PRN('', '');',
'            END IF;',
'            ',
'            sys.HTP.PRN(''{'');',
'            ',
'            L_LABEL := APEX_PLUGIN_UTIL.ESCAPE (',
'                APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                    P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_LABEL_COLUMN_NUMBER).DATA_TYPE,',
'                    P_VALUE => L_COLUMN_VALUE_LIST(L_LABEL_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'                ),',
'                P_REGION.ESCAPE_OUTPUT',
'            );',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''label'',',
'                    L_LABEL,',
'                    FALSE',
'            	)',
'            );',
'            L_LABEL_LINK := ',
'                CASE ',
'                    WHEN C_LABEL_LINK IS NOT NULL THEN ',
'                        APEX_UTIL.PREPARE_URL (',
'                            APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                P_VALUE  => C_LABEL_LINK,',
'                                P_ESCAPE => FALSE',
'                            )',
'                        )',
'                END;',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''label_link'',',
'                    L_LABEL_LINK',
'                )',
'            );',
'            L_VALUE := APEX_PLUGIN_UTIL.ESCAPE (',
'               APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                   P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_VALUE_COLUMN_NUMBER).DATA_TYPE,',
'                   P_VALUE => L_COLUMN_VALUE_LIST(L_VALUE_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'               ),',
'               P_REGION.ESCAPE_OUTPUT',
'            );',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''value'',',
'                    L_VALUE,',
'                    FALSE,',
'                    C_VALUE_LINK IS NOT NULL OR L_COLOR_COLUMN_NUMBER IS NOT NULL OR C_CHART_TYPE = ''ICON''',
'                )',
'            );',
'            L_VALUE_LINK := ',
'                CASE ',
'                    WHEN C_VALUE_LINK IS NOT NULL THEN ',
'                        APEX_UTIL.PREPARE_URL (',
'                            APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                P_VALUE  => C_VALUE_LINK,',
'                                P_ESCAPE => FALSE',
'                            )',
'                        )',
'                END;',
'             sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''value_link'',',
'                    L_VALUE_LINK,',
'                    TRUE,',
'                    L_COLOR_COLUMN_NUMBER IS NOT NULL OR C_CHART_TYPE = ''ICON''',
'                )',
'            );',
'            IF L_COLOR_COLUMN_NUMBER IS NOT NULL THEN',
'                L_COLOR := APEX_PLUGIN_UTIL.ESCAPE (',
'                   APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                       P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_COLOR_COLUMN_NUMBER).DATA_TYPE,',
'                       P_VALUE => L_COLUMN_VALUE_LIST(L_COLOR_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'                   ),',
'                   P_REGION.ESCAPE_OUTPUT',
'                );',
'                sys.HTP.PRN(',
'                    APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                        ''color'',',
'                        L_COLOR,',
'                        FALSE,',
'                        C_CHART_TYPE = ''ICON''',
'                    )',
'                );',
'            END IF;',
'            IF C_ICON_TYPE = ''IMAGE'' THEN',
'				L_IMAGE_URL := ',
'                    CASE ',
'                        WHEN C_IMAGE_URL IS NOT NULL THEN ',
'                            APEX_UTIL.PREPARE_URL (',
'                                APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                    P_VALUE  => C_IMAGE_URL,',
'                                    P_ESCAPE => FALSE',
'                                )',
'                            )',
'                    END;',
'				sys.HTP.PRN(',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''image_url'',',
'						L_IMAGE_URL,',
'						FALSE,',
'						FALSE',
'					)',
'				);',
'			ELSIF C_ICON_TYPE = ''ICON'' THEN',
'				L_CSS_ICON_CLASS_NAME := APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                    P_VALUE  => C_CSS_ICON_CLASS_NAME,',
'                    P_ESCAPE => TRUE',
'                );',
'				sys.HTP.PRN(',
'                	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''icon_css_class_name'',',
'						L_CSS_ICON_CLASS_NAME,',
'						FALSE,',
'						FALSE',
'					)',
'				);',
'			ELSIF C_ICON_TYPE = ''INITIALS'' THEN',
'				L_INITIALS := APEX_PLUGIN_UTIL.ESCAPE (',
'					APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'						P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_INITIALS_COLUMN_NUMBER).DATA_TYPE,',
'						P_VALUE => L_COLUMN_VALUE_LIST(L_INITIALS_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'					),',
'					P_REGION.ESCAPE_OUTPUT',
'				);',
'				sys.HTP.PRN(',
'                	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    	''initials'',',
'	                    L_INITIALS,',
'	                    FALSE,',
'	                    FALSE',
'    	            )',
'    	        );',
'            END IF;',
'            ',
'			sys.HTP.PRN(''}'');',
'            ',
'            APEX_PLUGIN_UTIL.CLEAR_COMPONENT_VALUES;',
'        EXCEPTION',
'            WHEN OTHERS THEN',
'                APEX_PLUGIN_UTIL.CLEAR_COMPONENT_VALUES;',
'                RAISE;',
'        END;',
'    END LOOP;',
'    sys.HTP.PRN(',
'            '']''||',
'        ''}''',
'    );',
'    ',
'    RETURN NULL;',
'END AJAX;'))
,p_api_version=>1
,p_render_function=>'RENDER'
,p_ajax_function=>'AJAX'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT:ESCAPE_OUTPUT'
,p_substitute_attributes=>false
,p_reference_id=>5610141522737396215.4355
,p_subscribe_plugin_settings=>true
,p_help_text=>unistr('<p>Este plug-in desenha gr\00E1ficos de barras horizontais que cont\00EAm labels, valores e at\00E9 mesmo \00EDcones</p>')
,p_version_identifier=>'1.0'
,p_files_version=>16
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702334718872248058.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Icon Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'INITIALS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702342810423248065.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ICON'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'    <li><strong>Image</strong>: Adds an image HTML element on the left side of the chart.</li>',
'    <li><strong>CSS Icon</strong>: Unlike the &quot;Image&quot; icon, instead of displaying an image HTML element, it displays an icon with the given CSS class.</li>',
'    <li><strong>Initials</strong>: Opposed to both, the &quot;Image&quot; and &quot;CSS Icon&quot; icons, this one displays a colored circle containing the given initials.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702335171470248059.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702334718872248058.4355)
,p_display_sequence=>10
,p_display_value=>'Image'
,p_return_value=>'IMAGE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702335675058248060.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702334718872248058.4355)
,p_display_sequence=>20
,p_display_value=>'CSS Icon'
,p_return_value=>'ICON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702336137978248060.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702334718872248058.4355)
,p_display_sequence=>30
,p_display_value=>'Initials'
,p_return_value=>'INITIALS'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702336688801248060.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Label Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'<p>A query column from which the label to be displayed is given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702337000944248061.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Label Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
,p_help_text=>'<p>A URL to be opened whenever the label is clicked. This attribute supports substitution strings.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702337476819248061.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'<p>A query column from which the label to be displayed is given. Notice that this value is not displayed on the chart items when the chart has been configured to display the bar width percentage instead.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702337891068248061.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Value Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
,p_help_text=>'<p>A URL to be opened whenever the displayed value is clicked. This attribute supports substitution strings.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702338214151248062.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>5
,p_prompt=>'Chart CSS Class Names'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'<p>CSS class names to be added to the root element of the chart separated with spaces.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702338638281248062.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>13
,p_prompt=>'Image URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702334718872248058.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'IMAGE'
,p_help_text=>'<p>The Image URL to be displayed as the chart icon. This attribute supports Substitution strings referring to som query column like in <strong>&amp;IMAGE_URL.</strong> which would reference the <strong>IMAGE_URL</strong> column value for each of the '
||'bars presented on the char. Notice that substitutions with no value will be replaced with an empty string.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702339094280248062.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>12
,p_prompt=>'CSS Icon Class Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702334718872248058.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ICON'
,p_help_text=>'<p>The Icon CSS Class Name.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702339499744248062.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>14
,p_prompt=>'Initials Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702334718872248058.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'INITIALS'
,p_help_text=>'<p>A query column from which initials to be displayed as an icon are given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702339807094248063.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>7
,p_prompt=>'Custom Chart Colors'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702345651994248067.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'<p>A list of CSS supported colors separated by colons.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702340226884248063.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Display'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VALUE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'<p>Displays either the item value or the calculated bar width on the right most text in the chart item.</p>'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702340619514248063.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702340226884248063.4355)
,p_display_sequence=>10
,p_display_value=>'Value'
,p_return_value=>'VALUE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702341146963248064.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702340226884248063.4355)
,p_display_sequence=>20
,p_display_value=>'Bar Width'
,p_return_value=>'BAR_WIDTH'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702341650689248064.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Prefix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1702340226884248063.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE'
,p_help_text=>'<p>When the value is displayed on the right most side of the chart item. The value of this attribute is prepended to it.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702342001349248064.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Postfix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1702340226884248063.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE'
,p_help_text=>'<p>When the value is displayed on the right most side of the chart item. The value of this attribute is appended to it.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702342462654248065.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Maximum Rows'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'5'
,p_is_translatable=>false
,p_help_text=>'<p>The maximum number of items to be displayed inside the region. Notice bar width calculations are made based on the number of items displayed.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702342810423248065.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>4
,p_prompt=>'Chart Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'TEXT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Defines how the chart will be displayed. There are two types of chart: </p>',
'<ul>',
'    <li><strong>Icon Chart</strong>: Displays bars with the label and value above and add an icon on the left.</li>',
'    <li><strong>Text Chart</strong>: Displays bars with the label and value either above or inline with the bar.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702343211589248065.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702342810423248065.4355)
,p_display_sequence=>10
,p_display_value=>'Icon Chart'
,p_return_value=>'ICON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702343724597248066.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702342810423248065.4355)
,p_display_sequence=>20
,p_display_value=>'Text Chart'
,p_return_value=>'TEXT'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702344281829248066.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>105
,p_prompt=>'Bar Width Calculation'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ABSOLUTE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Bar widths for each one of the chart items can be calculated in two ways:</p>',
'<ul>',
'    <li><strong>Absolute</strong>: 100% bar width is represented by the maximum value on the displayed chart items.</li>',
'    <li><strong>Relative</strong>: 100% bar width is represented by the sum of the values of all the displayed chart items.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702344685135248067.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702344281829248066.4355)
,p_display_sequence=>10
,p_display_value=>'Absolute'
,p_return_value=>'ABSOLUTE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702345182204248067.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702344281829248066.4355)
,p_display_sequence=>20
,p_display_value=>'Relative'
,p_return_value=>'RELATIVE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702345651994248067.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>6
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'MODERN'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The colors to be used in the chart bars. There are two special types of configuration: </p>',
'<ul>',
'    <li><strong>Custom</strong>: Provides a text box to receive a colon separated list of css supported colors.</li>',
'</ul>',
'<ul>',
'    <li><strong>Query Column</strong>: Provides a select list with the query columns which expects a css valid color.</li>',
'</ul>',
''))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702346097919248068.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702345651994248067.4355)
,p_display_sequence=>5
,p_display_value=>'Default'
,p_return_value=>'DEFAULT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702346538929248068.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702345651994248067.4355)
,p_display_sequence=>10
,p_display_value=>'Modern'
,p_return_value=>'MODERN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702347083560248069.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702345651994248067.4355)
,p_display_sequence=>20
,p_display_value=>'Modern 2'
,p_return_value=>'MODERN_2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702347505297248069.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702345651994248067.4355)
,p_display_sequence=>30
,p_display_value=>'Solar'
,p_return_value=>'SOLAR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702348056927248069.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702345651994248067.4355)
,p_display_sequence=>40
,p_display_value=>'Metro'
,p_return_value=>'METRO'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702348548765248070.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702345651994248067.4355)
,p_display_sequence=>50
,p_display_value=>'Custom'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702349044832248070.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702345651994248067.4355)
,p_display_sequence=>60
,p_display_value=>'Query Column'
,p_return_value=>'COLUMN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702349545275248070.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>55
,p_prompt=>'Text Position'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'AROUND'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702342810423248065.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'TEXT'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When displaying a text chart, two options are available for displaying the label and value texts:</p>',
'<ul>',
'    <li><strong>Above the bar</strong>: The label and value texts are displayed above the bar at the left and right most sides of it respectively.</li>',
'    <li><strong>Inline with the bar</strong>: The label, the bar and the value are displayed in one line on that order.</li>',
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702349966426248071.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702349545275248070.4355)
,p_display_sequence=>10
,p_display_value=>'Above the bar'
,p_return_value=>'ABOVE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702350427006248071.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(1702349545275248070.4355)
,p_display_sequence=>20
,p_display_value=>'Inline with the bar'
,p_return_value=>'AROUND'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702350916802248071.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>8
,p_prompt=>'Chart Colors Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702345651994248067.4355)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'COLUMN'
,p_help_text=>'<p>A query column from which CSS supported colors are given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702351321939248072.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>200
,p_prompt=>'Message When No Data Found'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_default_value=>'No data found.'
,p_is_translatable=>true
,p_help_text=>'<p>Message to be displayed when no data was found.</p>'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(1702355088636248078.4355)
,p_plugin_id=>wwv_flow_api.id(1591049479124636231.4355)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>1
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_wizard_selection
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2180265113361711031.4355)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.WIZARD_SELECTION'
,p_display_name=>unistr('Sele\00E7\00E3o de Assistente')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.WIZARD_SELECTION'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_wizard_selection'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_wizard_selection'
,p_standard_attributes=>'VISIBLE:SESSION_STATE:SOURCE:ELEMENT:LOV:CASCADING_LOV'
,p_substitute_attributes=>true
,p_reference_id=>3260301366184169092.4355
,p_subscribe_plugin_settings=>true
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2180265308752711037.4355)
,p_plugin_id=>wwv_flow_api.id(2180265113361711031.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Icon Size'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'S'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2180265799725711042.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(2180265308752711037.4355)
,p_display_sequence=>10
,p_display_value=>'Small'
,p_return_value=>'S'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2180266212595711047.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(2180265308752711037.4355)
,p_display_sequence=>20
,p_display_value=>'Medium'
,p_return_value=>'M'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2180266731458711048.4355)
,p_plugin_attribute_id=>wwv_flow_api.id(2180265308752711037.4355)
,p_display_sequence=>30
,p_display_value=>'Large'
,p_return_value=>'L'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2180267217007711048.4355)
,p_plugin_id=>wwv_flow_api.id(2180265113361711031.4355)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Submit Page'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
,p_help_text=>'Select whether or not to submit the page when making a selection'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(845155782990834528.4355)
,p_plugin_id=>wwv_flow_api.id(2180265113361711031.4355)
,p_name=>'LOV'
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2448108135531494687.4355)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>unistr('Adicionar caixa de sele\00E7\00E3o Marcar todas')
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512.4355
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>A a\00E7\00E3o din\00E2mica "Adicionar caixa de sele\00E7\00E3o Marcar todas" transforma um cabe\00E7alho de coluna que cont\00E9m a string #CHECK_ALL_CHECKBOX# em uma caixa de sele\00E7\00E3o Marcar todas acess\00EDvel, que marcar\00E1 ou desmarcar\00E1 todas as caixas de sele\00E7\00E3o na sua coluna')
||' correspondente.<p>',
'<p>',
unistr('Para usar este plug-in, verifique se os atributos a seguir est\00E3o definidos:'),
'<ol>',
unistr('<li>Na coluna de relat\00F3rios, defina ''#CHECK_ALL_CHECKBOX#'' como o valor do Cabe\00E7alho.</li>'),
unistr('<li>Para o atributo When da A\00E7\00E3o Din\00E2mica, selecione a regi\00E3o do relat\00F3rio que cont\00E9m a coluna.</li>'),
unistr('<li>Defina a A\00E7\00E3o Din\00E2mica para acionar ''Ap\00F3s Atualiza\00E7\00E3o'', e a A\00E7\00E3o para ''Carga de Acionamento da P\00E1gina''. (Ambas ser\00E3o definidas como padr\00E3o apropriadamente se a A\00E7\00E3o Din\00E2mica for criada selecionando a regi\00E3o na se\00E7\00E3o ''Renderiza\00E7\00E3o'' do Designer de ')
||unistr('p\00E1ginas e criando a A\00E7\00E3o Din\00E2mica nela.</li>'),
unistr('<li>Isso n\00E3o tratar\00E1 a acessibilidade das caixas de sele\00E7\00E3o renderizadas em cada linha. Isso deve ser feito separadamente na origem da regi\00E3o. (Consulte a regi\00E3o 4000:656 ''Regions'' para ver um exemplo).</li>'),
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(4969311180302342.4355)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>unistr('\00C1rea de Trabalho')
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>3
,p_home_url=>'f?p=4500:1000:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4355
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('P\00E1gina Zero')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215451130329541858)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30352322089771992.4355)
,p_plug_name=>'JS'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>4
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script type="text/javascript">',
'<!--',
'    function submitenter(myfield,e)',
'    {',
'        var keycode;',
'        if (window.event) keycode = window.event.keyCode;',
'        else if (e) keycode = e.which;',
'        else return true;',
'',
'        if (keycode == 13)',
'        {',
'            redirect(''f?p=&APP_ID.:8000:&SESSION.:::RIR:IR_ROWFILTER:''+$v(''P0_SEARCH''));',
'            return false;',
'        }',
'        else',
'            return true;',
'    }',
'    ',
'    function initSearch(searchField) ',
'    {',
'        searchField.value = "";',
'        searchField.style.color = "#000000";',
'    }',
'//-->',
'</script>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388539809791523187.4355)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-workspace-admin'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'68'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388540086737523188.4355)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(388539809791523187.4355)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1582031051259050.4355)
,p_plug_name=>'Application Tabs'
,p_region_name=>'a_Header_menu'
,p_parent_plug_id=>wwv_flow_api.id(388540086737523188.4355)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(719024906222154750.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388535020971474291.4355)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'not wwv_flow.apps_only_workspace'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388540217286523188.4355)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(388540086737523188.4355)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388540417683523188.4355)
,p_plug_name=>'APEX 5 - Home Link'
,p_parent_plug_id=>wwv_flow_api.id(388540086737523188.4355)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388540652992523188.4355)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(388539809791523187.4355)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388540854983523188.4355)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_api.id(388540652992523188.4355)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388566674203594195.4355)
,p_plug_name=>'APEX 5 - Header Administration Menu'
,p_region_name=>'adminMenu'
,p_parent_plug_id=>wwv_flow_api.id(388540854983523188.4355)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>110
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697508149859311566.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388535333575474292.4355)
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(486772128588301731.4355)
,p_plug_name=>'APEX 5 - Header Help Menu'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_api.id(388540854983523188.4355)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>120
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697513111062314247.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388535333575474292.4355)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388541051943523188.4355)
,p_plug_name=>'APEX 5 - Header Account'
,p_parent_plug_id=>wwv_flow_api.id(388540652992523188.4355)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(642566440163156401.4355)
,p_plug_name=>'APEX 5 - Search'
,p_parent_plug_id=>wwv_flow_api.id(388540652992523188.4355)
,p_region_css_classes=>'a-Header-search'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-SearchBox a-SearchBox--noGoButton a-SearchBox--autoExpand a-SearchBox--fill">'');',
'sys.htp.p(''  <div class="a-SearchBox-field">'');',
'sys.htp.p(''    <span class="a-SearchBox-icon"><span class="a-Icon icon-search"></span></span>'');',
'sys.htp.p(''    <label for="P0_SEARCH" class="visuallyhidden">''||wwv_flow_lang.system_message(''WWV_FLOW_QUICK_FLOW.SEARCH'')||''</label>'');',
'sys.htp.p(''    <input type="text" class="a-SearchBox-input" id="P0_SEARCH" placeholder="''||wwv_flow_lang.system_message(''WWV_FLOW_QUICK_FLOW.SEARCH.USERS'')||''">'');',
'sys.htp.p(''  </div>'');',
'sys.htp.p(''</div>'');',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388541233076523188.4355)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-workspace-admin'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>80
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'1,68'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388541479862523188.4355)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_api.id(388541233076523188.4355)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>90
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388567311021599596.4355)
,p_plug_name=>'APEX 5 - Breadcrumb'
,p_parent_plug_id=>wwv_flow_api.id(388541479862523188.4355)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_display_point=>'BODY'
,p_menu_id=>wwv_flow_api.id(4090422833267509.4355)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(388538606549481005.4355)
,p_translate_title=>'N'
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'1'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388541658700523189.4355)
,p_plug_name=>'APEX 5 - Control Bar Right'
,p_parent_plug_id=>wwv_flow_api.id(388541233076523188.4355)
,p_region_css_classes=>'a-ControlBar-col'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>100
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(233600835088079607.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(388540854983523188.4355)
,p_button_name=>'SPOTLIGHT'
,p_button_static_id=>'header-spotlightSearch'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388538190684476853.4355)
,p_button_image_alt=>'Destacar Pesquisa'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-actionButton a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-search'
,p_button_cattributes=>'data-action="spotlight-search"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388546581076568901.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(388540417683523188.4355)
,p_button_name=>'Home'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388538190684476853.4355)
,p_button_image_alt=>unistr('In\00EDcio')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4500:1000:&APP_SESSION.'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-home'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388546746057568903.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(388540854983523188.4355)
,p_button_name=>'Administration'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388537948307476852.4355)
,p_button_image_alt=>unistr('Administra\00E7\00E3o')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink a-Button--activeTab tab-admin'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388546906930568903.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(388540854983523188.4355)
,p_button_name=>'Feedback'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388538190684476853.4355)
,p_button_image_alt=>'Feedback'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
,p_required_patch=>wwv_flow_api.id(693461267865622287.4355)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388547181746568903.4355)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(388540854983523188.4355)
,p_button_name=>'Help'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388537948307476852.4355)
,p_button_image_alt=>'Ajuda'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Administra\00E7\00E3o')
,p_step_title=>unistr('Administra\00E7\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(692763410753114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_hm.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(27257417764751845.4355)
,p_plug_name=>'Tarefas'
,p_region_css_classes=>'a-Region--stacked a-Region--flush a-Region--sideRegion'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(166211911060758908.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
,p_plug_column_width=>'valign="top"'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29223409612811479.4355)
,p_plug_name=>unistr('Mensagem do Espa\00E7o de Trabalho')
,p_region_css_classes=>'a-Alert--inline'
,p_region_template_options=>'#DEFAULT#:a-Alert--noIcon:a-Alert--colorBG:a-Alert--warning:a-Alert--horizontal'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(797568474776479154.4355)
,p_plug_display_sequence=>30
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<p>'');',
'wwv_flow_4000_ui.show_workspace_notification (',
'   p_workspace_id       => :flow_security_group_id,',
'   p_session            => :app_session);',
'sys.htp.p(''</p>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- Admins always see the region so they can edit the announcement, while',
'-- Developers see the region only when announcement has been defined.',
'wwv_flow_4000_ui.workspace_notification_exists(',
'    p_workspace_id => :flow_security_group_id',
')',
'or apex_util.public_check_authorization(''Flow: ADMIN'')'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29444404444314439.4355)
,p_plug_name=>'System Message'
,p_region_css_classes=>'a-SystemMessage'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>'wwv_flow_4050_ui.show_system_message(p_app_session => :APP_SESSION);'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'wwv_flow_4050_ui.system_message_exists()'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30612511381129844.4355)
,p_plug_name=>unistr('Prefer\00EAncias de P\00E1gina')
,p_region_css_classes=>'a-Region--stacked a-Region--padded a-Region--flush a-Region--sideRegion'
,p_region_template_options=>'#DEFAULT#:a-Region--sideRegion:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_required_role=>wwv_flow_api.id(12518728403445471)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(42997223242377527.4355)
,p_name=>unistr('Usu\00E1rios')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>50
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--noPadding:h540'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P1b */',
'   count(*) user_count,',
'   sum(decode(developer_type,null,1,0)) end_user_count,',
'   sum(decode(is_developer,''Y'',1,0)) developer_count,',
'   sum(decode(developer_type,''ADMIN'',1,0)) workspace_admin_count,',
'   sum(decode(greatest(u.CREATION_DATE,sysdate - 1),sysdate -1,0,1)) created_last_24_hours,',
'   sum(decode(greatest(u.CREATION_DATE,sysdate - 7),sysdate -7,0,1)) created_last_week',
'from  WWV_FLOW_FND_USER u,',
'   (select USERID,',
'           decode(instr(DEVELOPER_ROLE,''ADMIN''),0,''N'',''Y'') is_admin,',
'           ''Y'' is_developer,',
'           case ',
'           when instr(DEVELOPER_ROLE,''BASIC_DEV'') > 0 then',
'              ''BASIC_DEV''',
'           when instr(DEVELOPER_ROLE,''ADMIN'') > 0 then',
'              ''ADMIN''',
'           when instr(DEVELOPER_ROLE,''CREATE'') > 0 then',
'              ''DEVELOPER''',
'           else',
'              ''UNKNOWN'' ',
'           end developer_type',
'    from WWV_FLOW_DEVELOPERS',
'    where security_group_id = :flow_security_group_id) d',
'where ',
'     u.user_name = d.userid(+) and',
'     u.security_group_id = :flow_security_group_id'))
,p_required_role=>wwv_flow_api.id(12518728403445471)
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(43021310970202834.4355)
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('dados n\00E3o encontrados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(42997223242377527.4355)
,p_plug_column_width=>'apex-col--bottomBorder apex-col--leftBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(42997508990377534.4355)
,p_query_column_id=>1
,p_column_alias=>'USER_COUNT'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Usu\00E1rios')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(42997608538377535.4355)
,p_query_column_id=>2
,p_column_alias=>'END_USER_COUNT'
,p_column_display_sequence=>4
,p_column_heading=>unistr('Usu\00E1rios Finais')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(42997711215377535.4355)
,p_query_column_id=>3
,p_column_alias=>'DEVELOPER_COUNT'
,p_column_display_sequence=>3
,p_column_heading=>'Desenvolvedores de Aplicativos'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(42997926989377535.4355)
,p_query_column_id=>4
,p_column_alias=>'WORKSPACE_ADMIN_COUNT'
,p_column_display_sequence=>2
,p_column_heading=>unistr('Administradores de Espa\00E7os de Trabalho')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46347512034168203.4355)
,p_query_column_id=>5
,p_column_alias=>'CREATED_LAST_24_HOURS'
,p_column_display_sequence=>5
,p_column_heading=>unistr('Criado nas \00DAltimas 24 Horas')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46347722423171255.4355)
,p_query_column_id=>6
,p_column_alias=>'CREATED_LAST_WEEK'
,p_column_display_sequence=>6
,p_column_heading=>unistr('Criado na \00DAltima Semana')
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(43023106337252491.4355)
,p_name=>'Atividade'
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>60
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--noPadding:h540'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P1c */ ',
'  page_events,',
'  median_elap,',
'  distinct_users,',
'  distinct_sessions,',
'  errors_raised,',
'  distinct_applications,',
'  wwv_flow_4000_ui.get_timeframe(:P1_TIME) reporting_timeframe',
'from',
'(',
'select ',
'    count(*) page_events,',
'    median(elap) median_elap,',
'    count(distinct(userid)) distinct_users,',
'    count(distinct(flow_id)) distinct_applications,',
'    count(distinct(session_id)) distinct_sessions,',
'    sum(decode(sqlerrm,null,0,1)) errors_raised',
'from (',
'select /*+ INDEX(wwv_flow_activity_log1$ WWV_FLOW_ACTIVITY_LOG1$_IDX1) */',
'    elap, userid, flow_id, session_id, sqlerrm',
'  from wwv_flow_activity_log1$',
'where security_group_id = :flow_security_group_id and',
'time_stamp > sysdate - :P1_TIME',
'union all',
'select /*+ INDEX(wwv_flow_activity_log2$ WWV_FLOW_ACTIVITY_LOG2$_IDX1) */',
'    elap, userid, flow_id, session_id, sqlerrm',
'  from wwv_flow_activity_log2$',
'where security_group_id = :flow_security_group_id and',
'time_stamp > sysdate - :P1_TIME',
')',
') r'))
,p_required_role=>wwv_flow_api.id(12518728403445471)
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(43021310970202834.4355)
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('dados n\00E3o encontrados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(43023106337252491.4355)
,p_plug_column_width=>'apex-col--bottomBorder apex-col--leftBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(43024030925259558.4355)
,p_query_column_id=>1
,p_column_alias=>'PAGE_EVENTS'
,p_column_display_sequence=>2
,p_column_heading=>unistr('Eventos de P\00E1gina')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(43024106979259558.4355)
,p_query_column_id=>2
,p_column_alias=>'MEDIAN_ELAP'
,p_column_display_sequence=>3
,p_column_heading=>unistr('Tempo Mediano de P\00E1gina')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G990D00'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(43024307318259558.4355)
,p_query_column_id=>3
,p_column_alias=>'DISTINCT_USERS'
,p_column_display_sequence=>5
,p_column_heading=>unistr('Usu\00E1rios Distintos')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(43024526001259558.4355)
,p_query_column_id=>4
,p_column_alias=>'DISTINCT_SESSIONS'
,p_column_display_sequence=>6
,p_column_heading=>unistr('Sess\00F5es Distintas')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(43024622128259559.4355)
,p_query_column_id=>5
,p_column_alias=>'ERRORS_RAISED'
,p_column_display_sequence=>7
,p_column_heading=>'Erros'
,p_column_link=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:RP,RIR:IRNN_SQLERRM:'
,p_column_linktext=>'#ERRORS_RAISED#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(435137310696295572.4355)
,p_query_column_id=>6
,p_column_alias=>'DISTINCT_APPLICATIONS'
,p_column_display_sequence=>4
,p_column_heading=>'Aplicativos Distintos'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(435137129565263152.4355)
,p_query_column_id=>7
,p_column_alias=>'REPORTING_TIMEFRAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Per\00EDodo de Relat\00F3rios')
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=&APP_ID.:59:&SESSION.::&DEBUG.:59::'
,p_column_linktext=>'#REPORTING_TIMEFRAME#'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(46082728200564532.4355)
,p_plug_name=>unistr('Gerenciar Espa\00E7o de Trabalho &COMPANY.')
,p_region_sub_css_classes=>'workspace-admin'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody:a-Region--hideHeader'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(46082227723554970.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(717846892308122004.4355)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(46088231420697995.4355)
,p_name=>unistr('Servi\00E7o')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>40
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--noPadding:h540'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P1a */',
'    :company workspace_name,',
'(',
'select count(*)',
'  from wwv_flow_visible_flows f',
' where f.build_status != ''RUN_AND_HIDDEN''',
') as applications,',
'(',
'select count(*)',
'  from wwv_flows f,',
'       wwv_flow_pkg_app_map m',
' where f.id = m.installed_app_id',
'   and f.security_group_id = m.security_group_id',
'   and f.security_group_id = :flow_security_group_id',
') as pkg_applications,',
'(',
'select count(*)',
'  from wwv_flow_files f, wwv_flow_fnd_user u',
' where u.security_group_id = :flow_security_group_id',
'   and u.user_name = :APP_USER',
'   and f.file_type = ''SCRIPT''',
') as sql_scripts,',
'(',
'select count(*)',
'  from wwv_flow_ws_applications ws',
' where ws.security_group_id = :flow_security_group_id',
') as websheets,',
'(',
'select count(*)',
'  from wwv_flow_company_schemas',
' where security_group_id = :flow_security_group_id',
') as schemas,',
'--',
'(select sum(open_requests) open_reqests',
'from',
'(',
'select count(*) open_requests',
'from WWV_FLOW_PROVISION_COMPANY',
'where ',
'      SECURITY_GROUP_ID = :flow_security_group_id and',
'      project_status = ''REQUESTED''',
'union all',
'select count(*) open_requests',
'from wwv_flow_provision_serice_mod m, ',
'     wwv_flow_companies c',
'where m.security_group_id = c.provisioning_company_id and',
'      c.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      m.request_status = ''REQUESTED''',
') q ) open_requests',
'from dual'))
,p_required_role=>wwv_flow_api.id(12518728403445471)
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(43021310970202834.4355)
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(46088231420697995.4355)
,p_plug_column_width=>'apex-col--bottomBorder apex-col--leftBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46089516576722100.4355)
,p_query_column_id=>1
,p_column_alias=>'WORKSPACE_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Nome do Espa\00E7o de Trabalho')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46345109003448326.4355)
,p_query_column_id=>2
,p_column_alias=>'APPLICATIONS'
,p_column_display_sequence=>2
,p_column_heading=>'Aplicativos de Banco de Dados'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(21340609119310837.4355)
,p_query_column_id=>3
,p_column_alias=>'PKG_APPLICATIONS'
,p_column_display_sequence=>4
,p_column_heading=>'Aplicativos de Produtividade'
,p_use_as_row_header=>'N'
,p_report_column_required_role=>wwv_flow_api.id(21341101987393942)
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47468531354816438.4355)
,p_query_column_id=>4
,p_column_alias=>'SQL_SCRIPTS'
,p_column_display_sequence=>5
,p_column_heading=>'Scripts SQL'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47468207459809511.4355)
,p_query_column_id=>5
,p_column_alias=>'WEBSHEETS'
,p_column_display_sequence=>3
,p_column_heading=>'Aplicativos de Websheet'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47468626466816438.4355)
,p_query_column_id=>6
,p_column_alias=>'SCHEMAS'
,p_column_display_sequence=>6
,p_column_heading=>'Esquemas'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47469028977844130.4355)
,p_query_column_id=>7
,p_column_alias=>'OPEN_REQUESTS'
,p_column_display_sequence=>7
,p_column_heading=>unistr('Solicita\00E7\00F5es Abertas')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(48537315419306557.4355)
,p_plug_name=>'Sobre'
,p_region_css_classes=>'a-Region--stacked a-Region--padded a-Region--flush a-Region--sideRegion'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>A Administra\00E7\00E3o de Espa\00E7o de Trabalho permite que voc\00EA gerencie sua conta. Dependendo dos seus privil\00E9gios, voc\00EA poder\00E1 monitorar e administrar esse espa\00E7o de trabalho.</p>'),
'<p><a target="_blank" href="&SYSTEM_HELP_URL./aeadm/understanding-workspace-administration.html#GUID-466C6E65-B159-4826-A5CC-AC0EBF4F449C">Saiba Mais...</a></p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(168483501399376268.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(46082728200564532.4355)
,p_button_name=>'CHANGE_PW'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(297663202145957383.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Alterar Minha Senha'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:58:&SESSION.::&DEBUG.:RP,58:::'
,p_button_condition_type=>'NEVER'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(32641004454198704.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(29223409612811479.4355)
,p_button_name=>'EDIT_ANNOUNCEMENT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388538190684476853.4355)
,p_button_image_alt=>'Editar Mensagem'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:35:&SESSION.::&DEBUG.:35::'
,p_icon_css_classes=>'icon-edit'
,p_button_cattributes=>'alt="&EDIT." title="&EDIT." height="16" width="16"'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30527919163801184.4355)
,p_name=>'P1_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(30612511381129844.4355)
,p_source=>'select to_number(''0.125'',''9.999'',''NLS_NUMERIC_CHARACTERS='''',.'''''') from dual'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('Exibir estat\00EDsticas em tempo real para este per\00EDodo de tempo.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(30192404188098919.4355)
,p_computation_sequence=>10
,p_computation_item=>'LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'1'
,p_compute_when_type=>'%null%'
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_api.create_page(
 p_id=>2.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Utiliza\00E7\00E3o do Tablespace de Esquema')
,p_step_title=>unistr('Utiliza\00E7\00E3o do Tablespace de Esquema')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215667724760013351)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5783706478780036.4355)
,p_name=>'Mapeamentos de Esquema para Tablespace'
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>54
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:h240'
,p_component_template_options=>'#DEFAULT#'
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P2a */ a.schema, u.default_tablespace',
'  from wwv_flow_company_schemas a, sys.dba_users u',
' where a.schema            = u.username',
'   and a.schema            = :p2_schema',
'   and a.security_group_id = wwv_flow.get_sgid',
'order by 1'))
,p_display_when_condition=>'P2_SCHEMA'
,p_display_condition_type=>'ITEM_NOT_NULL_OR_ZERO'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46765105410141325.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(5783706478780036.4355)
,p_plug_column_width=>'apex-col--bottomBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5784013471780043.4355)
,p_query_column_id=>1
,p_column_alias=>'SCHEMA'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1475461198068625316.4355)
,p_query_column_id=>2
,p_column_alias=>'DEFAULT_TABLESPACE'
,p_column_display_sequence=>2
,p_column_heading=>unistr('Tablespace Padr\00E3o')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5784712365781713.4355)
,p_name=>unistr('Espa\00E7o Livre por Tablespace (MB)')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>64
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:h240'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with ts as (',
'    select distinct tablespace_name',
'      from sys.dba_segments',
'     where owner = :P2_SCHEMA ),',
'ddf as (',
'    select f.file_id,',
'           f.tablespace_name,',
'           f.file_name,',
'           decode (f.autoextensible,',
'            ''YES'', greatest (f.bytes, f.maxbytes), f.bytes) df_size,',
'           decode (f.autoextensible,',
'            ''YES'', case',
'                       when (f.maxbytes > f.bytes)',
'                       then (f.maxbytes - f.bytes)',
'                       else 0',
'                   end, 0 ) growth',
'      from sys.dba_data_files f,',
'           ts',
'     where f.tablespace_name = ts.tablespace_name )',
'select ddf.tablespace_name name,',
'       round ((sum (nvl (freebytes, 0)) + sum (growth))/1024/1024 ) free',
'  from ddf,',
'       (select d.file_id, sum (d.bytes) freebytes',
'          from sys.dba_free_space d,',
'               ts',
'         where d.tablespace_name = ts.tablespace_name',
'         group by file_id) dfs',
' where ddf.file_id = dfs.file_id(+)',
' group by ddf.tablespace_name        '))
,p_display_when_condition=>'P2_SCHEMA'
,p_display_condition_type=>'ITEM_NOT_NULL_OR_ZERO'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46765105410141325.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'1'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(5784712365781713.4355)
,p_plug_column_width=>'apex-col--leftBorder apex-col--bottomBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5904028247808259.4355)
,p_query_column_id=>1
,p_column_alias=>'NAME'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5904325214808260.4355)
,p_query_column_id=>2
,p_column_alias=>'FREE'
,p_column_display_sequence=>2
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5871829174600336.4355)
,p_plug_name=>'Detalhes do Esquema'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('Cada espa\00E7o de trabalho tem acesso a um ou mais esquemas de banco de dados. Esta p\00E1gina lista detalhes sobre cada esquema.')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5873031776638945.4355)
,p_name=>unistr('Esquemas do Espa\00E7o de Trabalho')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>20
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_point=>'REGION_POSITION_03'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P2c */ schema',
'from   wwv_flow_company_schemas',
'where  security_group_id = :flow_security_group_id',
'order by 1'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(11670410466357416.4355)
,p_query_num_rows=>500
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('Dados n\00E3o encontrados.')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>5000
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
,p_comment=>'generated 07-APR-2004 15:37:37'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5873328941638951.4355)
,p_query_column_id=>1
,p_column_alias=>'SCHEMA'
,p_column_display_sequence=>1
,p_column_heading=>'SCHEMA'
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::P2_SCHEMA:#SCHEMA#'
,p_column_linktext=>'#SCHEMA#'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6624822428048770.4355)
,p_plug_name=>'Tarefas'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(6621926453040443.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'wwv_flow_platform.get_preference( ''SERVICE_REQUESTS_ENABLED'' ) = ''Y'''
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(182271012856475081.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>44
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(182440902719115584.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(182271012856475081.4355)
,p_button_name=>'P2_GO'
,p_button_static_id=>'P2_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(182441124506115587.4355)
,p_branch_action=>'f?p=&FLOW_ID.:2:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5875420478645168.4355)
,p_name=>'P2_SCHEMA'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(182271012856475081.4355)
,p_prompt=>'Esquema'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(a.schema) d, a.schema r',
'  from wwv_flow_company_schemas a',
' where a.security_group_id = (select wwv_flow.get_sgid from dual)',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Selecionar Esquema -'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>'Identifique um esquema.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(432753604790034958.4355)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'validate schema'
,p_process_sql_clob=>'wwv_flow_sw_api.check_priv(:P2_SCHEMA);'
,p_process_error_message=>'Erro'
,p_process_when=>'P2_SCHEMA'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_api.create_page(
 p_id=>3.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>'Editar Perfil'
,p_page_mode=>'MODAL'
,p_step_title=>'Editar Perfil'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(215450104703534414)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'550'
,p_dialog_width=>'600'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'AEADM/aadm_users.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(485918486401411525.4355)
,p_plug_name=>'Detalhes do Perfil'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding:a-Region--simple'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_row_template=>wwv_flow_api.id(1939532588110833.4355)
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'generated 19-FEB-2000 22:09:25'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1142730838556397048.4355)
,p_plug_name=>'Foto de perfil'
,p_parent_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--simple'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_header=>unistr('A foto do seu perfil personaliza sua atividade aparecendo na lista Principais Usu\00E1rios. Adicione, altere ou remova sua foto.')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1142730993807397049.4355)
,p_plug_name=>'<a name="pwd"></a>&F4350_PASSWORD_REGION_TITLE.'
,p_region_name=>'PWD'
,p_parent_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--simple'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_header=>unistr('Se voc\00EA deseja alterar sua senha, digite uma nova. Caso contr\00E1rio, deixe as colunas de senha nulas e a senha atual n\00E3o ser\00E1 alterada.')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(485930812856411538.4355)
,p_plug_name=>'reset'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
':F4350_P3_WEB_PASSWORD := null;',
':F4350_P3_USER_PASSWORD := null;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(485932134912411539.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(534309773003323583.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1142730838556397048.4355)
,p_button_name=>'P3_DELETE'
,p_button_static_id=>'P3_DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Remover Foto Atual'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_execute_validations=>'N'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_fnd_user',
' where user_id = :F4350_P3_USER_ID',
'   and sys.dbms_lob.getlength( profile_image ) > 0'))
,p_button_condition_type=>'EXISTS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(485932789329411544.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(485932134912411539.4355)
,p_button_name=>'ApplyChanges'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'F4350_P3_USER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_button_css_classes=>'a-Button--large'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(485932354419411539.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(485932134912411539.4355)
,p_button_name=>'Cancel'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_css_classes=>'a-Button--large'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485918673324411527.4355)
,p_name=>'F4350_P3_USER_ID'
,p_data_type=>'NUMBER'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_use_cache_before_default=>'NO'
,p_source=>'USER_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485918831775411527.4355)
,p_name=>'F4350_P3_COMPANY'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_prompt=>unistr('Espa\00E7o de Trabalho')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'a-Form-field a-Form-field--readOnly'
,p_tag_attributes=>' '
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica o espa\00E7o de trabalho ao qual este usu\00E1rio pertence.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485919355052411527.4355)
,p_name=>'F4350_P3_USER_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Nome do Usu\00E1rio')
,p_source=>'USER_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'a-Form-field a-Form-field--readOnly'
,p_tag_attributes=>' '
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Especifica o nome do usu\00E1rio utilizado para fazer log-in no sistema. Os nomes de usu\00E1rio t\00EAm estas restri\00E7\00F5es:</p>'),
'<ul>',
unistr('    <li>tamanho m\00E1ximo de 100 caracteres</li>'),
unistr('    <li>sem espa\00E7o</li>'),
unistr('    <li>apenas estes caracteres especiais s\00E3o permitidos: @ e pontos finais (.)</li>'),
'</ul>',
unistr('<p>O nome do usu\00E1rio tamb\00E9m pode ser utilizado para referenciar a atividade do usu\00E1rio, usando os aplicativos de monitoramento. A vari\00E1vel de bind <code>:APP_USER</code> retorna o valor do usu\00E1rio atual ao criar aplicativos.</p>')))
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485919804537411527.4355)
,p_name=>'F4350_P3_EMAIL_ADDRESS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Endere\00E7o de E-mail')
,p_source=>'EMAIL_ADDRESS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(489153170799943531.4355)
,p_item_template_options=>'#DEFAULT#'
,p_security_scheme=>'!'||wwv_flow_api.id(6738625560859071)
,p_help_text=>unistr('Especifica o endere\00E7o de e-mail para ser usado com correspond\00EAncias gerais e notifica\00E7\00F5es sobre redefini\00E7\00E3o de senhas, etc.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'EMAIL'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485920363918411527.4355)
,p_name=>'F4350_P3_ORG_EMAIL_ADDRESS'
,p_item_sequence=>45
,p_item_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_use_cache_before_default=>'NO'
,p_source=>'&F4350_P3_EMAIL_ADDRESS.'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485921331431411529.4355)
,p_name=>'F4350_P3_FIRST_NAME'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nome'
,p_source=>'FIRST_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Especifique o nome do usu\00E1rio para identific\00E1-lo ainda mais. Esse campo opcional \00E9 usado somente para fins de informa\00E7\00E3o.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485921884101411529.4355)
,p_name=>'F4350_P3_LAST_NAME'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Sobrenome'
,p_source=>'LAST_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Especifique o sobrenome do usu\00E1rio para identific\00E1-lo ainda mais. Esse campo opcional \00E9 usado somente para fins de informa\00E7\00E3o.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485933179379411545.4355)
,p_name=>'F4350_P3_WEB_PASSWORD'
,p_item_sequence=>96
,p_item_plug_id=>wwv_flow_api.id(1142730993807397049.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Informar Nova Senha'
,p_placeholder=>'nova senha'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>unistr('A senha usada para fazer log-in no sistema. N\00E3o informe uma senha, a menos que voc\00EA queira alterar a senha atual.')
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485933686391411545.4355)
,p_name=>'F4350_P3_USER_PASSWORD'
,p_item_sequence=>106
,p_item_plug_id=>wwv_flow_api.id(1142730993807397049.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Confirmar Senha'
,p_placeholder=>'confirmar senha'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>unistr('Informe a senha novamente. N\00E3o informe uma senha, a menos que voc\00EA queira alterar a senha atual.')
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485934109258411546.4355)
,p_name=>'P3_UPDATE_PW'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(485934575979411546.4355)
,p_name=>'P3_FIRST_PWD_USE_OCCURRED'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(485918486401411525.4355)
,p_use_cache_before_default=>'NO'
,p_source=>'FIRST_PASSWORD_USE_OCCURRED'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(486809306138103564.4355)
,p_name=>'P3_PROFILE_IMAGE'
,p_item_sequence=>86
,p_item_plug_id=>wwv_flow_api.id(1142730838556397048.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Foto'
,p_source=>'PROFILE_IMAGE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_FILE'
,p_cSize=>32
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Selecione uma foto para identificar ainda mais o usu\00E1rio. Este campo opcional \00E9 usado apenas para fins informativos. Para mostrar uma imagem sem qualquer distor\00E7\00E3o, o ideal \00E9 que o tamanho da imagem tenha 32x32. Voc\00EA pode substituir a foto existente ')
||unistr('fazendo o upload de uma nova foto ou clicando no bot\00E3o <b>Excluir Foto Atual</b>. Clique no bot\00E3o do browse para fazer upload de uma foto do disco r\00EDgido. ')
,p_attribute_01=>'DB_COLUMN'
,p_attribute_02=>'PROFILE_MIMETYPE'
,p_attribute_03=>'PROFILE_FILENAME'
,p_attribute_04=>'PROFILE_CHARSET'
,p_attribute_05=>'PROFILE_LAST_UPDATE'
,p_attribute_06=>'N'
,p_attribute_11=>'image/*'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(538621678004238307.4355)
,p_name=>'P3_CURRENT_PHOTO'
,p_item_sequence=>75
,p_item_plug_id=>wwv_flow_api.id(1142730838556397048.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Foto Atual'
,p_source=>'PROFILE_IMAGE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_IMAGE'
,p_tag_css_classes=>'u-circlePhoto'
,p_tag_attributes=>'height="64" width="64" alt="Profile image for &F4350_P3_USER_NAME."'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_fnd_user',
' where user_id = :F4350_P3_USER_ID',
'   and sys.dbms_lob.getlength( profile_image ) > 0'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Exibe a foto atualmente usada para identificar o usu\00E1rio. Voc\00EA pode substituir a foto existente fazendo o upload de uma nova foto ou clicando no bot\00E3o <b>Remover Foto Atual</b>.')
,p_attribute_01=>'DB_COLUMN'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1000725807551503640.4355)
,p_name=>'F4350_P3_CURRENT_PASSWORD'
,p_item_sequence=>86
,p_item_plug_id=>wwv_flow_api.id(1142730993807397049.4355)
,p_prompt=>'Informar Senha Atual'
,p_placeholder=>'senha atual'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>32
,p_cMaxlength=>4000
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/*',
' * require current password if',
' * - builder requires password (e.g. APEX auth - not SSO auth)',
' * - user password has already been changed',
' */',
' ',
'not wwv_flow_authentication_dev.is_builder_password_required (',
'        p_developer_yn => ''N'' )',
' or :P3_FIRST_PWD_USE_OCCURRED=''Y'''))
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>unistr('Digite a senha atual. N\00E3o digite uma senha, a menos que voc\00EA queira alterar a senha atual.')
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1252825859703086130.4355)
,p_name=>'P3_CURRENT_PHOTO_ALT'
,p_item_sequence=>96
,p_item_plug_id=>wwv_flow_api.id(1142730838556397048.4355)
,p_source=>'wwv_flow_lang.system_message(''USER_PROFILE_IMAGE'',:F4350_P3_USER_NAME)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(485937869389411549.4355)
,p_computation_sequence=>40
,p_computation_item=>'P3_UPDATE_PW'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'length(:F4350_P3_USER_PASSWORD)'
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(528338806493397505.4355)
,p_computation_sequence=>50
,p_computation_item=>'F4350_P3_COMPANY'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>'return wwv_flow_security.find_company_name ( p_security_group_id => wwv_flow_security.g_security_group_id );'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(485938428402411550.4355)
,p_validation_name=>'validate email'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_at  number;',
'    l_dot number;',
'begin',
'    l_at  := instr(nvl(:F4350_P3_EMAIL_ADDRESS,''x''),''@'');',
'    l_dot := instr(nvl(:F4350_P3_EMAIL_ADDRESS,''x''),''.'',l_at);',
'',
'    return l_at > 1 and l_dot > 1 and (l_dot - l_at) > 1;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Endere\00E7o de e-mail inv\00E1lido.')
,p_when_button_pressed=>wwv_flow_api.id(485932789329411544.4355)
,p_associated_item=>wwv_flow_api.id(485919804537411527.4355)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
,p_security_scheme=>'!'||wwv_flow_api.id(6738625560859071)
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(485939238468411551.4355)
,p_validation_name=>'if change username, must reset password'
,p_validation_sequence=>105
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'   select user_name',
'     from wwv_flow_fnd_user',
'    where user_id = :F4350_P3_USER_ID',
'      and security_group_id = :flow_security_group_id )',
'loop',
'   if c1.user_name != :F4350_P3_USER_NAME and',
'      :F4350_P3_WEB_PASSWORD is null then',
'   return false;',
'   else return true;',
'   end if;',
'end loop;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Se voc\00EA atualizar o Nome do usu\00E1rio, forne\00E7a uma nova senha.')
,p_when_button_pressed=>wwv_flow_api.id(485932789329411544.4355)
,p_associated_item=>wwv_flow_api.id(485933179379411545.4355)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1223161803819919527.4355)
,p_validation_name=>'Validate Current Password'
,p_validation_sequence=>115
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_api.is_login_password_valid(',
'  p_username=>:APP_USER,',
'  p_password=>:F4350_P3_CURRENT_PASSWORD);'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Senha Atual Inv\00E1lida')
,p_validation_condition=>'F4350_P3_CURRENT_PASSWORD'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(485932789329411544.4355)
,p_associated_item=>wwv_flow_api.id(1000725807551503640.4355)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1000725983139503641.4355)
,p_validation_name=>'Current Password Must Be Defined'
,p_validation_sequence=>125
,p_validation=>'F4350_P3_CURRENT_PASSWORD'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'A senha atual deve ser especificada.'
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/*',
' * require current password if new password given and either',
' * - builder requires password (e.g. APEX auth - not SSO auth)',
' * - user password has already been changed',
' */',
' ',
':F4350_P3_WEB_PASSWORD is not null',
'and (not wwv_flow_authentication_dev.is_builder_password_required (',
'             p_developer_yn => ''N'' )',
'     or :P3_FIRST_PWD_USE_OCCURRED=''Y'')'))
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(485932789329411544.4355)
,p_associated_item=>wwv_flow_api.id(1000725807551503640.4355)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(485939464738411551.4355)
,p_validation_name=>'match password'
,p_validation_sequence=>135
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :F4350_P3_WEB_PASSWORD != :F4350_P3_USER_PASSWORD then',
'  :F4350_P3_WEB_PASSWORD  := null;',
'  :F4350_P3_USER_PASSWORD := null;',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('A senha de confirma\00E7\00E3o n\00E3o corresponde \00E0 nova senha.')
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':F4350_P3_WEB_PASSWORD is not null or',
':F4350_P3_USER_PASSWORD is not null'))
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(485932789329411544.4355)
,p_associated_item=>wwv_flow_api.id(485933686391411545.4355)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(485939677017411551.4355)
,p_validation_name=>'strong password verification'
,p_validation_sequence=>145
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_security.strong_password_validation(',
'      p_username       => :F4350_P3_USER_NAME,',
'      p_password       => :F4350_P3_WEB_PASSWORD,',
'      p_old_password   => :F4350_P3_CURRENT_PASSWORD,',
'      p_workspace_name => wwv_flow_security.find_company_name(:WORKSPACE_ID));'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>'Erro'
,p_when_button_pressed=>wwv_flow_api.id(485932789329411544.4355)
,p_associated_item=>wwv_flow_api.id(485933179379411545.4355)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
,p_validation_comment=>'do not run for non-developers in SSO authentication mode'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(485957776630485888.4355)
,p_name=>'Cancel Dialog'
,p_event_sequence=>70
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(485932354419411539.4355)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(485958052927485889.4355)
,p_event_id=>wwv_flow_api.id(485957776630485888.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1223302827707202942.4355)
,p_name=>'Go to Current Password'
,p_event_sequence=>80
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'self.location.hash === "#pwd"'
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1223303044233202944.4355)
,p_event_id=>wwv_flow_api.id(1223302827707202942.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_FOCUS'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'F4350_P3_CURRENT_PASSWORD'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1253547838832954903.4355)
,p_event_id=>wwv_flow_api.id(1223302827707202942.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// Because of the hash tag in the URL, the parent window will also scroll.',
'// Let''s put it back where it was',
'setTimeout( function(){',
'    if ( parent.window.scrollY !== 0 ) {',
'        parent.window.scrollTo( 0, 0 );',
'    }',
'}, 1 );'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(485940145256411552.4355)
,p_process_sequence=>20
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set values'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
':F4350_P3_ORG_EMAIL_ADDRESS := :F4350_P3_EMAIL_ADDRESS;',
'end;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(528326649481046882.4355)
,p_process_sequence=>5
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Delete Current Image'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'update wwv_flow_fnd_user',
'   set profile_image = EMPTY_BLOB(),',
'       profile_image_name = null,',
'       profile_mimetype = null,',
'       profile_filename = null,',
'       profile_last_update = null,',
'       profile_charset = null',
' where user_id = :F4350_P3_USER_ID',
'   and security_group_id =  wwv_flow_security.g_security_group_id;',
' commit;'))
,p_process_error_message=>'Ocorreram problemas ao remover a imagem do Perfil atual.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(534309773003323583.4355)
,p_process_when=>'F4350_P3_USER_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
,p_process_success_message=>'A imagem de perfil foi removida com sucesso.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(485940378778411553.4355)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Edit User'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'  l_p1                        varchar2(256)               := v(''F4350_P3_WEB_PASSWORD'');',
'  l_p2                        varchar2(256)               := v(''F4350_P3_USER_PASSWORD'');',
'  l_profile_image             blob default empty_blob();',
'begin',
'',
'  -- Retrieve Profile Image Content from Temporary table wwv_flow_files, used by File Browse item',
'  if :P3_PROFILE_IMAGE is not null then',
'      -- Get the uploaded file from the common wwv_flow_files table.',
'      select blob_content',
'        into l_profile_image',
'        from wwv_flow_files',
'       where name = :P3_PROFILE_IMAGE; ',
'  end if;',
'',
'  wwv_flow_fnd_user_api.edit_fnd_user (',
'      p_user_id                      => :F4350_P3_USER_ID,       ',
'      p_first_name                   => :F4350_P3_FIRST_NAME,          ',
'      p_last_name                    => :F4350_P3_LAST_NAME,',
'      p_web_password                 => l_p1,    ',
'      p_new_password                 => l_p2,                     ',
'      p_email_address                => nvl(:F4350_P3_EMAIL_ADDRESS, :F4350_P3_ORG_EMAIL_ADDRESS),',
'      p_first_password_use_occurred  => case when l_p1 is not null then ''Y'' else :P3_FIRST_PWD_USE_OCCURRED end,',
'      p_profile_image                => l_profile_image);',
'     ',
'',
'end;'))
,p_process_error_message=>unistr('Erro ao atualizar usu\00E1rio.')
,p_process_when_button_id=>wwv_flow_api.id(485932789329411544.4355)
,p_process_when=>'F4350_P3_USER_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
,p_process_success_message=>unistr('Usu\00E1rio "&F4350_P3_USER_NAME." atualizado.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(487249722605107455.4355)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Email Address updated'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_product_name  varchar2(500);',
'  l_msg           varchar2(4000);',
'  l_body_html     varchar2(32767) := null;',
'begin',
'',
'  --',
'  -- Mail the change of Email address',
'  --',
'  if :F4350_P3_ORG_EMAIL_ADDRESS <> :F4350_P3_EMAIL_ADDRESS then',
'    l_msg := l_msg || wwv_flow_lang.system_message(''NEW_EMAIL_ADDRESS'') || chr(10) || :F4350_P3_EMAIL_ADDRESS || chr(10) || chr(10) || chr(10);',
'    l_msg := l_msg || wwv_flow_utilities.host_url(''SCRIPT'') || chr(10);',
'   ',
'    l_body_html := wwv_flow_mail.convert_txt_to_html (',
'                       p_txt_message       => l_msg,',
'                       p_security_group_id => :flow_security_group_id );',
'                       ',
'    l_product_name := nvl(v(''PRODUCT_NAME''),''Oracle Application Express'');',
'',
'    wwv_flow_mail.send ( ',
'        p_to        => :F4350_P3_ORG_EMAIL_ADDRESS,',
'        p_from      => nvl(wwv_flow_platform.get_preference(''SMTP_FROM''),:F4350_P3_ORG_EMAIL_ADDRESS),',
'        p_body      => l_msg,',
'        p_body_html => l_body_html,',
'        p_subj      => wwv_flow_lang.system_message(''CHANGE_PW_REQUEST'',l_product_name) );',
'        ',
'  end if;',
'',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(485932789329411544.4355)
,p_security_scheme=>'!'||wwv_flow_api.id(6738625560859071)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(485957562238481403.4355)
,p_process_sequence=>70
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(485932789329411544.4355)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(528328136769125728.4355)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set User ID'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'--',
'-- fetch id of current user',
'--',
'select user_id',
'  into :F4350_P3_USER_ID',
'  from wwv_flow_fnd_user',
' where user_name         = wwv_flow_security.g_user',
'   and security_group_id = wwv_flow_security.g_security_group_id;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(528291553770752921.4355)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch User Information DML'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_FND_USER'
,p_attribute_03=>'F4350_P3_USER_ID'
,p_attribute_04=>'USER_ID'
,p_attribute_08=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    user_name         = v(''APP_USER'')',
'and security_group_id = v(''WORKSPACE_ID'')'))
);
end;
/
prompt --application/pages/page_00004
begin
wwv_flow_api.create_page(
 p_id=>4.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Tentativas de Log-in pelo Resultado da Autentica\00E7\00E3o')
,p_step_title=>unistr('Tentativas de Log-in pelo Resultado da Autentica\00E7\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(42713916288726001.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47363926027704900.4355)
,p_plug_name=>'Tentativas de Log-in'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P4a */',
'  l.attempts,',
'  l.login_name,',
'  l.application,',
'  l.owner,',
'  l.authentication_method,',
'  l.access_date,',
'  l.ip_address,',
'  decode(nvl(l.authentication_result,0),',
'     0,m.AUTH_SUCCESS,',
'     1,m.AUTH_UNKNOWN_USER,',
'     2,m.AUTH_ACCOUNT_LOCKED,',
'     3,m.AUTH_ACCOUNT_EXPIRED,',
'     4,m.AUTH_PASSWORD_INCORRECT,',
'     5,m.AUTH_PASSWORD_FIRST_USE,',
'     6,m.AUTH_ATTEMPTS_EXCEEDED,',
'     7,m.AUTH_INTERNAL_ERROR,',
'     l.authentication_result) authentication_result,',
'     l.authentication_result authentication_result_code',
'from',
'(',
'select ',
'  count(*) attempts,',
'  count(distinct upper(login_name)) login_name,',
'  count(distinct application) application,',
'  count(distinct owner) owner,',
'  count (distinct authentication_method) authentication_method,',
'  count( distinct to_char(access_date,''YYYY.MM.DD'')) access_date,',
'  count( distinct ip_address) ip_address,',
'  nvl(authentication_result,0) authentication_result',
'from   wwv_flow_user_access_log_v l',
'where  security_group_id = :flow_security_group_id',
'and access_date >= sysdate - nvl(:p4_time,1)',
' and ( :P4_APPLICATION is null or application like ''%''||:P4_APPLICATION||''%'')',
'and (:P4_USER is null or lower(login_name) like ''%''||lower(:P4_USER)||''%'')',
'group by nvl(authentication_result,0)',
') l,',
'(select',
'wwv_flow_lang.system_message(''AUTH_SUCCESS'') auth_success,',
'wwv_flow_lang.system_message(''AUTH_UNKNOWN_USER'') auth_unknown_user,',
'wwv_flow_lang.system_message(''AUTH_ACCOUNT_LOCKED'') auth_account_locked,',
'wwv_flow_lang.system_message(''AUTH_ACCOUNT_EXPIRED'') auth_account_expired,',
'wwv_flow_lang.system_message(''AUTH_PASSWORD_INCORRECT'') auth_password_incorrect,',
'wwv_flow_lang.system_message(''AUTH_PASSWORD_FIRST_USE'') auth_password_first_use,',
'wwv_flow_lang.system_message(''AUTH_ATTEMPTS_EXCEEDED'') auth_attempts_exceeded,',
'wwv_flow_lang.system_message(''AUTH_INTERNAL_ERROR'') auth_internal_error',
'from dual) m'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(47364014627704900.4355)
,p_name=>'Login Attempts'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(47364232661704916.4355)
,p_db_column_name=>'ATTEMPTS'
,p_display_order=>2
,p_column_identifier=>'A'
,p_column_label=>'Tentativas'
,p_column_link=>'f?p=&APP_ID.:70:&SESSION.::&DEBUG.:RIR,70:IR_AUTHENTICATION_RESULT_CODE,P70_TIME:#AUTHENTICATION_RESULT_CODE#,&P4_TIME.'
,p_column_linktext=>'#ATTEMPTS#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(47364309638704923.4355)
,p_db_column_name=>'LOGIN_NAME'
,p_display_order=>3
,p_column_identifier=>'B'
,p_column_label=>'Nomes de Log-in'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(47364405831704923.4355)
,p_db_column_name=>'APPLICATION'
,p_display_order=>4
,p_column_identifier=>'C'
,p_column_label=>'Aplicativos'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(47364505224704924.4355)
,p_db_column_name=>'OWNER'
,p_display_order=>5
,p_column_identifier=>'D'
,p_column_label=>unistr('Propriet\00E1rios dos Aplicativos')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(47364601629704924.4355)
,p_db_column_name=>'AUTHENTICATION_METHOD'
,p_display_order=>6
,p_column_identifier=>'E'
,p_column_label=>unistr('M\00E9todos de Autentica\00E7\00E3o')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(47364714754704925.4355)
,p_db_column_name=>'ACCESS_DATE'
,p_display_order=>7
,p_column_identifier=>'F'
,p_column_label=>'Dias do Log-in'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(47364805925704925.4355)
,p_db_column_name=>'IP_ADDRESS'
,p_display_order=>8
,p_column_identifier=>'G'
,p_column_label=>unistr('Endere\00E7os IP')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(450633625112963474.4355)
,p_db_column_name=>'AUTHENTICATION_RESULT'
,p_display_order=>9
,p_column_identifier=>'H'
,p_column_label=>unistr('Resultado da Autentica\00E7\00E3o')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1340579706612701073.4355)
,p_db_column_name=>'AUTHENTICATION_RESULT_CODE'
,p_display_order=>10
,p_column_identifier=>'I'
,p_column_label=>unistr('C\00F3digo do Resultado de Autentica\00E7\00E3o')
,p_display_in_default_rpt=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(42715026364726009.4355)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(42713916288726001.4355)
,p_button_name=>'P4_GO'
,p_button_static_id=>'P4_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'GO'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(450597432759842665.4355)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(42713916288726001.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(42717220135726012.4355)
,p_branch_action=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:RP::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(42715026364726009.4355)
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(42717409726726015.4355)
,p_branch_action=>'70'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>20
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(42715711720726010.4355)
,p_name=>'P4_APPLICATION'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(42713916288726001.4355)
,p_prompt=>'Aplicativo'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>5
,p_cMaxlength=>2000
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Para filtrar por aplicativo, informe um ID de aplicativo e clique em <b>Ir</b>.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(42716223347726010.4355)
,p_name=>'P4_USER'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(42713916288726001.4355)
,p_prompt=>'Nome para Log-in'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>15
,p_cMaxlength=>2000
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Para filtrar por Nome de Log-in, insira um nome de Log-in e clique em <b>Ir</b>.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(42736507800886950.4355)
,p_name=>'P4_TIME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(42713916288726001.4355)
,p_prompt=>'Desde'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico. Identifique o per\00EDodo a ser inclu\00EDdo no relat\00F3rio e clique em <b>Ir</b>.<p />'),
unistr('Se voc\00EA selecionar 1 dia, apenas as 24 \00FAltimas horas ser\00E3o exibidas.  ')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Expurgar Estado de Sess\00E3o')
,p_step_title=>unistr('Expurgar Estado de Sess\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215469304188572178)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12518728403445471)
,p_help_text=>'AEADM/aadm_purge_session.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(41820802378409076.4355)
,p_plug_name=>unistr('Estado da Sess\00E3o')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>O estado da sess\00E3o fornece persist\00EAncia para itens. &PRODUCT_NAME. usa uma arquitetura stateless para armazenar o estado da sess\00E3o no banco de dados.</p>')
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(48658815589767957.4355)
,p_plug_name=>unistr('Estado da Sess\00E3o')
,p_region_template_options=>'#DEFAULT#:a-Alert--noIcon:a-Alert--warning:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(797568474776479154.4355)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select count(*) c from wwv_flow_data where flow_instance = :flow_session) loop',
'sys.htp.p(''<span class="instructiontext">''||wwv_flow_lang.system_message(''F4350_SESSION_STATE'',:flow_session,c1.c) );',
'end loop;',
'sys.htp.p(wwv_flow_lang.system_message(''F4350_RESET_SESSION'') || ''</span>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_column_width=>'valign="top"'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(48661616984968577.4355)
,p_plug_name=>'button box'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(174256217975087222.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(48658815589767957.4355)
,p_button_name=>'SessionDetails'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>unistr('Exibir Estado de Sess\00E3o')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(48658988453771579.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(48658815589767957.4355)
,p_button_name=>'ResetCache'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Expurgar Estado de Sess\00E3o')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(48659251907771584.4355)
,p_branch_action=>'5'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_when_button_id=>wwv_flow_api.id(48658988453771579.4355)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(48659428631783734.4355)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset-sessionstate'
,p_attribute_01=>'RESET_SESSION_STATE'
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel expurgar o estado da sess\00E3o.')
,p_process_when_button_id=>wwv_flow_api.id(48658988453771579.4355)
,p_process_success_message=>unistr('Estado da sess\00E3o expurgado.')
);
end;
/
prompt --application/pages/page_00006
begin
wwv_flow_api.create_page(
 p_id=>6.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>'Resumo de Log-in do Desenvolvedor'
,p_step_title=>'Resumo de Log-in do Desenvolvedor'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10264909617798279.4355)
,p_plug_name=>'Logins do Desenvolvedor'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P6a */',
'      u.user_id,',
'      u.user_name,',
'      u.email_address "eMail",',
'      u.first_name,',
'      u.last_name,',
'      replace(u.default_schema,''%''||''null%'',null) default_schema,',
'u.DESCRIPTION,',
'u.LAST_AGENT,',
'u.LAST_IP,',
'u.FAILED_ACCESS_ATTEMPTS,',
'decode(nvl(d.is_admin,''N''),''Y'',',
'  m.admin,decode(nvl(d.is_developer,''N''),',
'  ''Y'',m.dev,m.end_user)) dev_type,',
'decode (nvl(d.is_developer,''N''),''Y'',last_login,null) last_login,',
'decode (nvl(d.is_developer,''N''),''Y'',',
'          nvl(builder_login_count,0),null) builder_login_count,',
'(select group_id from WWV_FLOW_FND_GROUP_USERS where user_id = u.user_id) group_id,',
'(select GROUP_NAME from WWV_FLOW_FND_USER_GROUPS where id = (select group_id from WWV_FLOW_FND_GROUP_USERS where user_id = u.user_id)) group_name',
'from  WWV_FLOW_FND_USER u,',
'   (select USERID,',
'           decode(instr(DEVELOPER_ROLE,''ADMIN''),0,''N'',''Y'') is_admin,',
'           ''Y'' is_developer',
'    from WWV_FLOW_DEVELOPERS',
'    where security_group_id = :flow_security_group_id) d,',
'    (select wwv_flow_lang.system_message(''F4000.NO'') n,',
'            wwv_flow_lang.system_message(''F4000.YES'') yes,',
'            wwv_flow_lang.system_message(''PASSWORD_VALID'') password_valid,',
'            wwv_flow_lang.system_message(''PASSWORD_EXPIRED'') password_expired,',
'            wwv_flow_lang.system_message(''NO_DEVELOPER_PRIV'') no_developer_priv,',
'            wwv_flow_lang.system_message(''DEVELOPER'') dev,',
'wwv_flow_lang.system_message(''ADMINISTRATOR'') admin,',
'wwv_flow_lang.system_message(''END_USER'') end_user',
'     from dual) m',
'where ',
'     u.user_name = d.userid(+) and',
'     u.security_group_id = :flow_security_group_id and',
'     d.is_developer = ''Y'''))
,p_plug_source_type=>'NATIVE_IR'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(10265008216798279.4355)
,p_name=>'Developer Logins'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_base_pk1=>'USER_ID'
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#ws/small_page.gif" alt="" />'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10265215153798286.4355)
,p_db_column_name=>'USER_ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('Id do Usu\00E1rio')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10265331595798286.4355)
,p_db_column_name=>'USER_NAME'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Nome do Usu\00E1rio')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10265415681798287.4355)
,p_db_column_name=>'eMail'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'E-mail'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10265526984798287.4355)
,p_db_column_name=>'FIRST_NAME'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Nome'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10265626077798287.4355)
,p_db_column_name=>'LAST_NAME'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Sobrenome'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10265728301798287.4355)
,p_db_column_name=>'DEFAULT_SCHEMA'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('Esquema Padr\00E3o')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10265811005798287.4355)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('Descri\00E7\00E3o')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10265910207798287.4355)
,p_db_column_name=>'LAST_AGENT'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('\00DAltimo Agente')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10266007407798288.4355)
,p_db_column_name=>'LAST_IP'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('Endere\00E7o IP')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10266219176798288.4355)
,p_db_column_name=>'FAILED_ACCESS_ATTEMPTS'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'Tentativas de Acesso com Falha'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10266319338798288.4355)
,p_db_column_name=>'DEV_TYPE'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>'Tipo de Desenvolvedor'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10266403152798288.4355)
,p_db_column_name=>'GROUP_ID'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>'ID do Grupo'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10266518425798288.4355)
,p_db_column_name=>'GROUP_NAME'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>'Nome do Grupo'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10270413936835709.4355)
,p_db_column_name=>'LAST_LOGIN'
,p_display_order=>15
,p_column_identifier=>'O'
,p_column_label=>unistr('\00DAltimo Log-in')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10270524884835710.4355)
,p_db_column_name=>'BUILDER_LOGIN_COUNT'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>'Contagem de Log-in do Builder'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(450634229745974263.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(10264909617798279.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:RIR::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Sess\00F5es Ativas')
,p_step_title=>unistr('Sess\00F5es Ativas')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9412131855285339.4355)
,p_plug_name=>unistr('Sess\00F5es Ativas')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with sd as (',
'    select	s.ID as "ID",',
'           s.security_group_id,',
'           s.username session_owner,',
'           s.created_on,',
'           count(*) item_cache_count,',
'           count(distinct(d.flow_id)) distinct_applications,',
'           s.remote_addr ip_address,',
'           s.idle_timeout_on,',
'           s.life_timeout_on,',
'           s.session_lang,',
'           s.session_territory,',
'           s.session_time_zone,',
'           s.debug_level,',
'           s.trace_mode',
' from	 WWV_FLOW_DATA d,',
'	     WWV_FLOW_SESSIONS$ s',
' where   d.FLOW_INSTANCE(+)=s.ID',
'   and   (   :P7_OWNER is null',
'          or instr(upper(s.username),upper(:P7_OWNER))>0)',
'   and   s.security_group_id = :flow_security_group_id',
'group by s.ID,',
'         s.security_group_id,',
'         s.username,',
'         s.created_on,',
'         s.remote_addr,',
'         s.idle_timeout_on,',
'         s.life_timeout_on,',
'         s.session_lang,',
'         s.session_territory,',
'         s.session_time_zone,',
'         s.debug_level,',
'         s.trace_mode),',
'     mt as (select l.session_id, max(l.time_stamp) most_recent_view',
'        from WWV_FLOW_ACTIVITY_LOG l',
'       where l.security_group_id = :flow_security_group_id',
'       group by l.session_id)',
'select /* APEX4350P7a */ /*+ FIRST_ROWS(21) */',
'        sd.id,',
'        sd.session_owner,',
'        sd.created_on,',
'        sd.item_cache_count,',
'        sd.ip_address,',
'        mt.most_recent_view,',
'        sd.distinct_applications,',
'        sd.idle_timeout_on,',
'        sd.life_timeout_on,',
'        sd.session_lang,',
'        sd.session_territory,',
'        sd.session_time_zone,',
'        sd.debug_level,',
'        sd.trace_mode',
'  from sd, mt',
' where sd.id = mt.session_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(9412205627285339.4355)
,p_name=>'Active Sessions'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9412428176285340.4355)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('Sess\00E3o Ativa')
,p_column_link=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.:RP,:P19_ID:#ID#'
,p_column_linktext=>'#ID#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9412501728285340.4355)
,p_db_column_name=>'SESSION_OWNER'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Propriet\00E1rio')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9412608456285340.4355)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Criado'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9412708051285340.4355)
,p_db_column_name=>'ITEM_CACHE_COUNT'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('Itens da Sess\00E3o')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9412818327285341.4355)
,p_db_column_name=>'IP_ADDRESS'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('Endere\00E7o IP')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(22432609427809248.4355)
,p_db_column_name=>'MOST_RECENT_VIEW'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'View Mais Recente'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(22435506226827241.4355)
,p_db_column_name=>'DISTINCT_APPLICATIONS'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Aplicativos Distintos'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(265416632100318130.4355)
,p_db_column_name=>'IDLE_TIMEOUT_ON'
,p_display_order=>17
,p_column_identifier=>'H'
,p_column_label=>'Timeout Inativo'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(265416784868318131.4355)
,p_db_column_name=>'LIFE_TIMEOUT_ON'
,p_display_order=>27
,p_column_identifier=>'I'
,p_column_label=>unistr('Time-out de Vida \00DAtil')
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(265416893890318132.4355)
,p_db_column_name=>'SESSION_LANG'
,p_display_order=>37
,p_column_identifier=>'J'
,p_column_label=>'Idioma'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(265416996345318133.4355)
,p_db_column_name=>'SESSION_TERRITORY'
,p_display_order=>47
,p_column_identifier=>'K'
,p_column_label=>unistr('Territ\00F3rio')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(265417082583318134.4355)
,p_db_column_name=>'SESSION_TIME_ZONE'
,p_display_order=>57
,p_column_identifier=>'L'
,p_column_label=>unistr('Fuso Hor\00E1rio')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(265417123142318135.4355)
,p_db_column_name=>'DEBUG_LEVEL'
,p_display_order=>67
,p_column_identifier=>'M'
,p_column_label=>unistr('N\00EDvel de Depura\00E7\00E3o')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(265417254052318136.4355)
,p_db_column_name=>'TRACE_MODE'
,p_display_order=>77
,p_column_identifier=>'N'
,p_column_label=>'Modo de Rastreamento'
,p_column_type=>'NUMBER'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_column_alignment=>'RIGHT'
,p_rpt_named_lov=>wwv_flow_api.id(370223717115128950)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(200809731468694255.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(9412131855285339.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:7,RIR::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(167564317393131991.4355)
,p_branch_action=>'f?p=&FLOW_ID.:7:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
end;
/
prompt --application/pages/page_00008
begin
wwv_flow_api.create_page(
 p_id=>8.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor')
,p_step_title=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6115202769688783.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9830103673330851.4355)
,p_plug_name=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with total_page_views as',
'(',
'select /* APEX4350P8a */ count(*) tpv',
'from   ',
'  wwv_flow_builder_audit_trail',
'where  ',
'  audit_date > sysdate - nvl(:p8_time,1) and ',
'  security_group_id = :flow_security_group_id and',
'  (:P8_APPLICATION = 0 or flow_id = :P8_APPLICATION)',
')',
'select the_link, developer, page_views, 100*page_views/tpv pct, round(100*page_views/tpv) graph,',
'pages_visited,',
'distinct_applications,',
'''<div class="hour-graph">''||',
'''<span title="''||m.hour_label||''  0, ''||m.message_label||'' ''||ltrim(to_char(h00,''999G999G999''))||''" class="hour''|| case when h00 = 0 then '' is-null'' when h00 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 0</span> <span class="hour-value"'
||'>''|| case when h00 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h00/1000),''99999999D0'')) else to_char(h00) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  1, ''||m.message_label||'' ''||ltrim(to_char(h01,''999G999G999''))||''" class="hour''|| case when h01 = 0 then '' is-null'' when h01 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 1</span> <span class="hour-value"'
||'>''|| case when h01 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h01/1000),''99999999D0'')) else to_char(h01) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  2, ''||m.message_label||'' ''||ltrim(to_char(h02,''999G999G999''))||''" class="hour''|| case when h02 = 0 then '' is-null'' when h02 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 2</span> <span class="hour-value"'
||'>''|| case when h02 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h02/1000),''99999999D0'')) else to_char(h02) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  3, ''||m.message_label||'' ''||ltrim(to_char(h03,''999G999G999''))||''" class="hour''|| case when h03 = 0 then '' is-null'' when h03 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 3</span> <span class="hour-value"'
||'>''|| case when h03 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h03/1000),''99999999D0'')) else to_char(h03) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  4, ''||m.message_label||'' ''||ltrim(to_char(h04,''999G999G999''))||''" class="hour''|| case when h04 = 0 then '' is-null'' when h04 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 4</span> <span class="hour-value"'
||'>''|| case when h04 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h04/1000),''99999999D0'')) else to_char(h04) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  5, ''||m.message_label||'' ''||ltrim(to_char(h05,''999G999G999''))||''" class="hour''|| case when h05 = 0 then '' is-null'' when h05 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 5</span> <span class="hour-value"'
||'>''|| case when h05 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h05/1000),''99999999D0'')) else to_char(h05) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  6, ''||m.message_label||'' ''||ltrim(to_char(h06,''999G999G999''))||''" class="hour''|| case when h06 = 0 then '' is-null'' when h06 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 6</span> <span class="hour-value"'
||'>''|| case when h06 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h06/1000),''99999999D0'')) else to_char(h06) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  7, ''||m.message_label||'' ''||ltrim(to_char(h07,''999G999G999''))||''" class="hour''|| case when h07 = 0 then '' is-null'' when h07 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 7</span> <span class="hour-value"'
||'>''|| case when h07 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h07/1000),''99999999D0'')) else to_char(h07) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  8, ''||m.message_label||'' ''||ltrim(to_char(h08,''999G999G999''))||''" class="hour''|| case when h08 = 0 then '' is-null'' when h08 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 8</span> <span class="hour-value"'
||'>''|| case when h08 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h08/1000),''99999999D0'')) else to_char(h08) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  9, ''||m.message_label||'' ''||ltrim(to_char(h09,''999G999G999''))||''" class="hour''|| case when h09 = 0 then '' is-null'' when h09 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 9</span> <span class="hour-value"'
||'>''|| case when h09 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h09/1000),''99999999D0'')) else to_char(h09) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 10, ''||m.message_label||'' ''||ltrim(to_char(h10,''999G999G999''))||''" class="hour''|| case when h10 = 0 then '' is-null'' when h10 > 999 then '' is-over1k'' end ||''"><span class="hour-label">10</span> <span class="hour-value"'
||'>''|| case when h10 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h10/1000),''99999999D0'')) else to_char(h10) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 11, ''||m.message_label||'' ''||ltrim(to_char(h11,''999G999G999''))||''" class="hour''|| case when h11 = 0 then '' is-null'' when h11 > 999 then '' is-over1k'' end ||''"><span class="hour-label">11</span> <span class="hour-value"'
||'>''|| case when h11 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h11/1000),''99999999D0'')) else to_char(h11) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 12, ''||m.message_label||'' ''||ltrim(to_char(h12,''999G999G999''))||''" class="hour''|| case when h12 = 0 then '' is-null'' when h12 > 999 then '' is-over1k'' end ||''"><span class="hour-label">12</span> <span class="hour-value"'
||'>''|| case when h12 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h12/1000),''99999999D0'')) else to_char(h12) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 13, ''||m.message_label||'' ''||ltrim(to_char(h13,''999G999G999''))||''" class="hour''|| case when h13 = 0 then '' is-null'' when h13 > 999 then '' is-over1k'' end ||''"><span class="hour-label">13</span> <span class="hour-value"'
||'>''|| case when h13 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h13/1000),''99999999D0'')) else to_char(h13) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 14, ''||m.message_label||'' ''||ltrim(to_char(h14,''999G999G999''))||''" class="hour''|| case when h14 = 0 then '' is-null'' when h14 > 999 then '' is-over1k'' end ||''"><span class="hour-label">14</span> <span class="hour-value"'
||'>''|| case when h14 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h14/1000),''99999999D0'')) else to_char(h14) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 15, ''||m.message_label||'' ''||ltrim(to_char(h15,''999G999G999''))||''" class="hour''|| case when h15 = 0 then '' is-null'' when h15 > 999 then '' is-over1k'' end ||''"><span class="hour-label">15</span> <span class="hour-value"'
||'>''|| case when h15 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h15/1000),''99999999D0'')) else to_char(h15) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 16, ''||m.message_label||'' ''||ltrim(to_char(h16,''999G999G999''))||''" class="hour''|| case when h16 = 0 then '' is-null'' when h16 > 999 then '' is-over1k'' end ||''"><span class="hour-label">16</span> <span class="hour-value"'
||'>''|| case when h16 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h16/1000),''99999999D0'')) else to_char(h16) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 17, ''||m.message_label||'' ''||ltrim(to_char(h17,''999G999G999''))||''" class="hour''|| case when h17 = 0 then '' is-null'' when h17 > 999 then '' is-over1k'' end ||''"><span class="hour-label">17</span> <span class="hour-value"'
||'>''|| case when h17 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h17/1000),''99999999D0'')) else to_char(h17) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 18, ''||m.message_label||'' ''||ltrim(to_char(h18,''999G999G999''))||''" class="hour''|| case when h18 = 0 then '' is-null'' when h18 > 999 then '' is-over1k'' end ||''"><span class="hour-label">18</span> <span class="hour-value"'
||'>''|| case when h18 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h18/1000),''99999999D0'')) else to_char(h18) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 19, ''||m.message_label||'' ''||ltrim(to_char(h19,''999G999G999''))||''" class="hour''|| case when h19 = 0 then '' is-null'' when h19 > 999 then '' is-over1k'' end ||''"><span class="hour-label">19</span> <span class="hour-value"'
||'>''|| case when h19 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h19/1000),''99999999D0'')) else to_char(h19) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 20, ''||m.message_label||'' ''||ltrim(to_char(h20,''999G999G999''))||''" class="hour''|| case when h20 = 0 then '' is-null'' when h20 > 999 then '' is-over1k'' end ||''"><span class="hour-label">20</span> <span class="hour-value"'
||'>''|| case when h20 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h20/1000),''99999999D0'')) else to_char(h20) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 21, ''||m.message_label||'' ''||ltrim(to_char(h21,''999G999G999''))||''" class="hour''|| case when h21 = 0 then '' is-null'' when h21 > 999 then '' is-over1k'' end ||''"><span class="hour-label">21</span> <span class="hour-value"'
||'>''|| case when h21 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h21/1000),''99999999D0'')) else to_char(h21) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 22, ''||m.message_label||'' ''||ltrim(to_char(h22,''999G999G999''))||''" class="hour''|| case when h22 = 0 then '' is-null'' when h22 > 999 then '' is-over1k'' end ||''"><span class="hour-label">22</span> <span class="hour-value"'
||'>''|| case when h22 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h22/1000),''99999999D0'')) else to_char(h22) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 23, ''||m.message_label||'' ''||ltrim(to_char(h23,''999G999G999''))||''" class="hour''|| case when h23 = 0 then '' is-null'' when h23 > 999 then '' is-over1k'' end ||''"><span class="hour-label">23</span> <span class="hour-value"'
||'>''|| case when h23 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h23/1000),''99999999D0'')) else to_char(h23) end ||''</span></span>''||',
'''</div>'' hours',
'from',
'(',
'select ',
'''f?p=4350:42:''||:app_session||'':::RP:P42_USER,P42_TIME:''||flow_user||'',''||:p8_time the_link,',
'  flow_user developer,',
'  count(*) page_views,',
'  count(distinct(page_id)) pages_visited,',
'  count(distinct(flow_id)) distinct_applications,',
'  sum(decode(to_char(audit_date,''HH24''),0,1,0)) h00,',
'  sum(decode(to_char(audit_date,''HH24''),1,1,0)) h01,',
'  sum(decode(to_char(audit_date,''HH24''),2,1,0)) h02,',
'  sum(decode(to_char(audit_date,''HH24''),3,1,0)) h03,',
'  sum(decode(to_char(audit_date,''HH24''),4,1,0)) h04,',
'  sum(decode(to_char(audit_date,''HH24''),5,1,0)) h05,',
'  sum(decode(to_char(audit_date,''HH24''),6,1,0)) h06,',
'  sum(decode(to_char(audit_date,''HH24''),7,1,0)) h07,',
'  sum(decode(to_char(audit_date,''HH24''),8,1,0)) h08,',
'  sum(decode(to_char(audit_date,''HH24''),9,1,0)) h09,',
'  sum(decode(to_char(audit_date,''HH24''),10,1,0)) h10,',
'  sum(decode(to_char(audit_date,''HH24''),11,1,0)) h11,',
'  sum(decode(to_char(audit_date,''HH24''),12,1,0)) h12,',
'  sum(decode(to_char(audit_date,''HH24''),13,1,0)) h13,',
'  sum(decode(to_char(audit_date,''HH24''),14,1,0)) h14,',
'  sum(decode(to_char(audit_date,''HH24''),15,1,0)) h15,',
'  sum(decode(to_char(audit_date,''HH24''),16,1,0)) h16,',
'  sum(decode(to_char(audit_date,''HH24''),17,1,0)) h17,',
'  sum(decode(to_char(audit_date,''HH24''),18,1,0)) h18,',
'  sum(decode(to_char(audit_date,''HH24''),19,1,0)) h19,',
'  sum(decode(to_char(audit_date,''HH24''),20,1,0)) h20,',
'  sum(decode(to_char(audit_date,''HH24''),21,1,0)) h21,',
'  sum(decode(to_char(audit_date,''HH24''),22,1,0)) h22,',
'  sum(decode(to_char(audit_date,''HH24''),23,1,0)) h23',
'from   ',
'  wwv_flow_builder_audit_trail',
'where  ',
'  audit_date > sysdate - nvl(:p8_time,1) and ',
'  security_group_id = :flow_security_group_id and',
'  (:P8_APPLICATION = 0 or flow_id = :P8_APPLICATION)',
'group by ',
'  flow_user) d, total_page_views,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.HOUR'') hour_label from dual) m,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.APPCHANGES'') message_label from dual) m,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.K'',''~'') activity_by_hour_message_k from dual ) m'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(9830202023330851.4355)
,p_name=>'Application Changes by Developer'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9830429030330852.4355)
,p_db_column_name=>'THE_LINK'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'&nbsp;'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9830502357330852.4355)
,p_db_column_name=>'DEVELOPER'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Desenvolvedor'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9830612188330852.4355)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('Altera\00E7\00F5es do Componente')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9830716530330853.4355)
,p_db_column_name=>'PCT'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Percentual'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D00'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9830808496330853.4355)
,p_db_column_name=>'GRAPH'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('Gr\00E1fico')
,p_column_type=>'NUMBER'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_format_mask=>'PCT_GRAPH:cccccc:777777:200'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9830926209330853.4355)
,p_db_column_name=>'PAGES_VISITED'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('P\00E1ginas Distintas')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9932001315661346.4355)
,p_db_column_name=>'DISTINCT_APPLICATIONS'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Aplicativos Distintos'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1760555872015323225.4355)
,p_db_column_name=>'HOURS'
,p_display_order=>17
,p_column_identifier=>'H'
,p_column_label=>'Atividade por hora'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(200631711636281729.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(6115202769688783.4355)
,p_button_name=>'P8_SET'
,p_button_static_id=>'P8_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--padRight'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'Set'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(200631503324279375.4355)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(6115202769688783.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:8,RIR::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(20242415263688933.4355)
,p_branch_action=>'f?p=&FLOW_ID.:8:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(20239730370683894.4355)
,p_name=>'P8_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(6115202769688783.4355)
,p_item_default=>'to_number(.25)'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Desde'
,p_source=>'to_number(.25)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cSize=>30
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico.')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(47682732034325129.4355)
,p_name=>'P8_APPLICATION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(6115202769688783.4355)
,p_item_default=>'0'
,p_prompt=>'Aplicativo'
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AVAILABLE.APPLICATIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from wwv_flow_visible_flows f',
' order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Todos os Aplicativos -'
,p_lov_null_value=>'0'
,p_cSize=>30
,p_cHeight=>1
,p_tag_attributes=>'style="max-width:200px"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Filtrar sa\00EDda do relat\00F3rio para incluir todos os aplicativos ou um aplicativo espec\00EDfico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00009
begin
wwv_flow_api.create_page(
 p_id=>9.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>'Sobre o &PRODUCT_NAME.'
,p_page_mode=>'MODAL'
,p_step_title=>'Sobre o &PRODUCT_NAME.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215451130329541858)
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'div.subRegion h2 {',
'	font: bold 13px/20px Arial, sans-serif;',
'	color: #333;',
'}',
'table.aboutReportTop {',
'	padding: 0 0 10px 0;',
'}',
'table.aboutReportTop tr:first-child th,',
'table.aboutReportTop tr:first-child td {',
'border-top: none;',
'}',
'table.aboutReportTop td {',
'padding: 5px;',
'text-align: left;',
'font: normal 12px/16px Arial, sans-serif;',
'color: #333;',
'border-top: 1px solid #DDD;',
'}',
'table.aboutReportTop td.textHere {',
'font-weight: bold;',
'}'))
,p_step_template=>wwv_flow_api.id(485889499804058937.4355)
,p_page_css_classes=>'about-page'
,p_dialog_height=>'500'
,p_dialog_width=>'490'
,p_dialog_attributes=>'scroll:''auto'''
,p_help_text=>'AEADM/aadm_htmldb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(77811317279722052.4355)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-Dialog-about">',
'              <span class="a-Dialog-icon gi-icon-apex-logo-icon"></span>',
'              <span class="a-Dialog-aboutTitle">''||:PRODUCT_NAME||''</span>',
'          </div>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_column_width=>'valign="top"'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(20123129051163000.4355)
,p_name=>unistr('Vers\00E3o do Banco de Dados')
,p_parent_plug_id=>wwv_flow_api.id(77811317279722052.4355)
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>30
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--staticRowColors:a-Report--stretch'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select banner',
'  from sys.v_$version',
' order by case when banner like ''Oracle%'' then 1 else 2 end, upper(banner)'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(770829717235300818.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_no_data_found=>unistr('N\00E3o h\00E1 informa\00E7\00F5es sobre a vers\00E3o do banco de dados.')
,p_query_row_count_max=>7
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(20123710246163013.4355)
,p_query_column_id=>1
,p_column_alias=>'BANNER'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(186769128691535740.4355)
,p_plug_name=>'Ambiente CGI'
,p_parent_plug_id=>wwv_flow_api.id(77811317279722052.4355)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.print_cgi_env',
' (p_html_table_attr=>''class="u-Report u-Report--stretch u-Report--staticBG u-Report--inline u-Report--firstColLabel" role="presentation" cellpadding="0" cellspacing="0" border="0"'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(198701826510091307.4355)
,p_plug_name=>'Conjunto de Caracteres'
,p_parent_plug_id=>wwv_flow_api.id(77811317279722052.4355)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<table role="presentation" class="u-Report u-Report--staticBG u-Report--stretch u-Report--inline  u-Report--firstColLabel">'');',
'for c1 in (',
'select ''NLS_CHARACTERSET:'' n, value v ',
'from nls_database_parameters ',
'where upper(parameter)= ''NLS_CHARACTERSET'') loop',
'sys.htp.p(''<tr>'');',
'wwv_htp.tableData(c1.n);',
'sys.htp.prn(''<td class="textHere">''||wwv_flow_escape.html(c1.v)||''</td>'');',
'sys.htp.p(''</tr>'');',
'end loop;',
'',
'',
'sys.htp.p(''<tr>'');',
'wwv_htp.tableData(''DAD CHARACTERSET:'');',
'sys.htp.prn(''<td class="textHere">''||',
'   wwv_flow_escape.html(sys.owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))||''</td>'');',
'sys.htp.p(''</tr>'');',
'',
'',
'for c1 in (',
'select ''JOB_QUEUE_PROCESSES:''n, value v',
'from v$parameter where lower(name) = ''job_queue_processes'') loop',
'sys.htp.p(''<tr>'');',
'wwv_htp.tableData(c1.n);',
'sys.htp.prn(''<td class="textHere">''||',
'   wwv_flow_escape.html(c1.v)||''</td>'');',
'sys.htp.p(''</tr>'');',
'end loop;',
'',
'',
'sys.htp.p(''</table>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1093539312009113721.4355)
,p_plug_name=>'Detalhes'
,p_parent_plug_id=>wwv_flow_api.id(77811317279722052.4355)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<table class="u-Report u-Report--stretch u-Report--staticBG u-Report--inline u-Report--firstColLabel" role="presentation">'');',
'',
'sys.htp.p(''<tr>'');',
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.PRODUCT_BUILD''));',
'sys.htp.prn(''<td>''||wwv_flow_escape.html(wwv_flows_release)||''</td>'');',
'sys.htp.p(''</tr>'');',
'',
'sys.htp.p(''<tr>'');',
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.SCHEMA_COMPATIBILITY''));',
'sys.htp.prn(''<td>''||wwv_flow_escape.html(wwv_flows_version)||''</td>'');',
'sys.htp.p(''</tr>'');',
'',
'for c1 in (select to_char(last_ddl_time,''&DATE_TIME_FORMAT.'') as lddt',
'             from sys.dba_objects',
'            where owner = wwv_flow.g_flow_schema_owner',
'              and object_name = ''WWV_FLOW''',
'              and object_type = ''PACKAGE BODY'' ) loop',
'    sys.htp.p(''<tr>'');',
'    wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.LAST_DDL_TIME''));',
'    sys.htp.prn(''<td>''||wwv_flow_escape.html(c1.lddt)||''</td>'');',
'    sys.htp.p(''</tr>'');',
'end loop;',
'',
'for c1 in (select user as u from sys.dual) loop',
'    sys.htp.p(''<tr>'');',
'    wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.HOST_SCHEMA''));',
'    sys.htp.prn(''<td>''||wwv_flow_escape.html(c1.u)||''</td>'');',
'    sys.htp.p(''</tr>'');',
'end loop;',
'',
'sys.htp.tableRowOpen;',
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.APPLICATION_OWNER''));',
'sys.htp.prn(''<td>''||wwv_flow_escape.html(''#FLOW_OWNER#'')||''</td>'');',
'sys.htp.p(''</tr>'');',
'',
'sys.htp.p(''<tr>'');',
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.WORKSPACE_ID''));',
'sys.htp.prn(''<td>''||wwv_flow_security.g_security_group_id||''</td>'');',
'sys.htp.p(''</tr>'');',
'',
'sys.htp.p(''<tr>'');',
'-- wwv_flow.get_company_name returns already escaped output',
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.WORKSPACE_NAME''));',
'sys.htp.prn(''<td>''||wwv_flow.get_company_name||''</td>'');',
'sys.htp.p(''</tr>'');',
'',
'sys.htp.p(''<tr>'');',
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.CURRENT_USER''));',
'sys.htp.prn(''<td>''||wwv_flow_escape.html(v(''USER''))||''</td>'');',
'sys.htp.p(''</tr>'');',
'',
'sys.htp.p(''<tr>'');',
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.LANGUAGE_PREFERENCE''));',
'sys.htp.prn(''<td>''||wwv_flow_escape.html(wwv_flow.g_browser_language)||''</td>'');',
'wwv_htp.tableRowClose;',
'',
'sys.htp.p(''<tr>'');',
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.CURRENT_TIME_ON_SERVER''));',
'sys.htp.prn(''<td>''||to_char(systimestamp,''&DATE_TIME_FORMAT. TZH:TZM'')||''</td>'');',
'sys.htp.p(''</tr>'');',
'',
'wwv_htp.tableClose;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
end;
/
prompt --application/pages/page_00010
begin
wwv_flow_api.create_page(
 p_id=>10.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor')
,p_step_title=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(131241908734176090.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>2
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1591303603291709019.4355)
,p_plug_name=>'Atividade do desenvolvedor por desenvolvedor'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P10a */',
'  null l,',
'  flow_user,',
'  count(*) c',
'from   ',
'  wwv_flow_builder_audit_trail',
'where  ',
'  audit_date > sysdate - nvl(:p10_time,1) and ',
'  security_group_id = :flow_security_group_id and',
'  (nvl(:p10_application,0) = 0 or flow_id = :p10_application)',
'group by ',
'  flow_user',
'order by 3 desc'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_plug_query_num_rows=>15
,p_attribute_01=>'INITIALS'
,p_attribute_02=>'FLOW_USER'
,p_attribute_04=>'C'
,p_attribute_11=>'VALUE'
,p_attribute_14=>'500'
,p_attribute_15=>'TEXT'
,p_attribute_16=>'ABSOLUTE'
,p_attribute_17=>'MODERN'
,p_attribute_18=>'AROUND'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(450735531935533076.4355)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(131241908734176090.4355)
,p_button_name=>'P10_SET'
,p_button_static_id=>'P10_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'SET'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(20263732195741193.4355)
,p_branch_action=>'f?p=&FLOW_ID.:10:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(20260920074737670.4355)
,p_name=>'P10_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(131241908734176090.4355)
,p_item_default=>'.25'
,p_prompt=>'Desde'
,p_source=>'.25'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Restrinja o relat\00F3rio para um hor\00E1rio espec\00EDfico. Identifique o per\00EDodo para '),
unistr('incluir no relat\00F3rio e clique em <b>Ir</b>.<p />'),
unistr('Se voc\00EA selecionar 1 dia, ent\00E3o apenas as \00FAltimas 24 horas ser\00E3o exibidas.  ')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(47683931950344036.4355)
,p_name=>'P10_APPLICATION'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(131241908734176090.4355)
,p_item_default=>'0'
,p_prompt=>'Aplicativo'
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AVAILABLE.APPLICATIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from wwv_flow_visible_flows f',
' order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Todos os Aplicativos -'
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Filtrar sa\00EDda do relat\00F3rio para incluir todos os aplicativos ou um aplicativo espec\00EDfico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_api.create_page(
 p_id=>11.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Prefer\00EAncias do Usu\00E1rio Atual')
,p_alias=>'PREF'
,p_step_title=>unistr('Prefer\00EAncias do Usu\00E1rio Atual')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450104703534414)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_user_pref.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(46076724243052275.4355)
,p_plug_name=>unistr('Prefer\00EAncias')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    user_id,',
'    preference_name,',
'    attribute_value',
'from WWV_FLOW_PREFERENCES$',
'where user_id = :flow_user',
'and security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(46076811301052275.4355)
,p_name=>'Preferences'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(46077020433052289.4355)
,p_db_column_name=>'USER_ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('Usu\00E1rio')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(46077103585052295.4355)
,p_db_column_name=>'PREFERENCE_NAME'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Prefer\00EAncia')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(46077204057052295.4355)
,p_db_column_name=>'ATTRIBUTE_VALUE'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Valor'
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(174210501299954701.4355)
,p_plug_name=>unistr('Prefer\00EAncias do Usu\00E1rio')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('Este relat\00F3rio mostra as prefer\00EAncias definidas para o usu\00E1rio atual. Esses valores de estado de sess\00E3o s\00E3o mantidos entre conex\00F5es.')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(452413709019800121.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(46076724243052275.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(122221606249170943.4355)
,p_branch_action=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
end;
/
prompt --application/pages/page_00012
begin
wwv_flow_api.create_page(
 p_id=>12.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Views de P\00E1gina por Dia')
,p_step_title=>unistr('Views de P\00E1gina por Dia')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(46757621766940957.4355)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(692991422006464140.4355)
,p_plug_name=>unistr('Eventos de P\00E1gina por Dia')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--accessibleHeader'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'NATIVE_JET_CHART'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_jet_chart(
 p_id=>wwv_flow_api.id(692991541290464141.4355)
,p_region_id=>wwv_flow_api.id(692991422006464140.4355)
,p_chart_type=>'line'
,p_height=>'450'
,p_animation_on_display=>'none'
,p_animation_on_data_change=>'none'
,p_orientation=>'vertical'
,p_data_cursor=>'auto'
,p_data_cursor_behavior=>'auto'
,p_hover_behavior=>'none'
,p_stack=>'off'
,p_stack_label=>'off'
,p_spark_chart=>'N'
,p_connect_nulls=>'Y'
,p_value_position=>'auto'
,p_sorting=>'label-asc'
,p_fill_multi_series_gaps=>true
,p_zoom_and_scroll=>'off'
,p_tooltip_rendered=>'Y'
,p_show_series_name=>false
,p_show_group_name=>true
,p_show_value=>true
,p_show_label=>true
,p_show_row=>true
,p_show_start=>true
,p_show_end=>true
,p_show_progress=>true
,p_show_baseline=>true
,p_legend_rendered=>'off'
,p_legend_position=>'auto'
,p_overview_rendered=>'off'
,p_horizontal_grid=>'auto'
,p_vertical_grid=>'auto'
,p_gauge_orientation=>'circular'
,p_gauge_plot_area=>'on'
,p_show_gauge_value=>true
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(692991695243464142.4355)
,p_chart_id=>wwv_flow_api.id(692991541290464141.4355)
,p_seq=>10
,p_name=>'Mostrar'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select trunc(TIME_STAMP) day, to_char(TIME_STAMP,''mm/dd/yyyy'') day_format,',
'       count(*) views',
'from   WWV_FLOW_ACTIVITY_LOG',
'where  security_group_id = :flow_security_group_id and page_mode != ''A''',
'group by trunc(time_stamp),to_char(TIME_STAMP,''mm/dd/yyyy'')',
'order by trunc(time_stamp) desc'))
,p_items_value_column_name=>'VIEWS'
,p_items_label_column_name=>'DAY_FORMAT'
,p_line_style=>'solid'
,p_line_type=>'auto'
,p_marker_rendered=>'auto'
,p_marker_shape=>'auto'
,p_assigned_to_y2=>'off'
,p_items_label_rendered=>true
,p_items_label_position=>'afterMarker'
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(692991991244464145.4355)
,p_chart_id=>wwv_flow_api.id(692991541290464141.4355)
,p_seq=>20
,p_name=>'Aceitar'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select trunc(TIME_STAMP) day, to_char(TIME_STAMP,''dd/mm/yyyy'') day_format,',
'       count(*) views',
'from   WWV_FLOW_ACTIVITY_LOG',
'where  security_group_id = :flow_security_group_id and page_mode = ''A''',
'group by trunc(time_stamp),to_char(TIME_STAMP,''dd/mm/yyyy'')',
'order by trunc(time_stamp) desc'))
,p_items_value_column_name=>'VIEWS'
,p_items_label_column_name=>'DAY_FORMAT'
,p_line_style=>'solid'
,p_line_type=>'auto'
,p_marker_rendered=>'auto'
,p_marker_shape=>'auto'
,p_assigned_to_y2=>'off'
,p_items_label_rendered=>true
,p_items_label_position=>'aboveMarker'
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
);
wwv_flow_api.create_jet_chart_axis(
 p_id=>wwv_flow_api.id(692991712252464143.4355)
,p_chart_id=>wwv_flow_api.id(692991541290464141.4355)
,p_axis=>'x'
,p_is_rendered=>'on'
,p_format_scaling=>'auto'
,p_scaling=>'linear'
,p_baseline_scaling=>'zero'
,p_major_tick_rendered=>'on'
,p_minor_tick_rendered=>'off'
,p_tick_label_rendered=>'on'
,p_tick_label_rotation=>'auto'
,p_tick_label_position=>'outside'
,p_zoom_order_seconds=>false
,p_zoom_order_minutes=>false
,p_zoom_order_hours=>false
,p_zoom_order_days=>false
,p_zoom_order_weeks=>false
,p_zoom_order_months=>false
,p_zoom_order_quarters=>false
,p_zoom_order_years=>false
);
wwv_flow_api.create_jet_chart_axis(
 p_id=>wwv_flow_api.id(692991826812464144.4355)
,p_chart_id=>wwv_flow_api.id(692991541290464141.4355)
,p_axis=>'y'
,p_is_rendered=>'on'
,p_format_type=>'decimal'
,p_decimal_places=>0
,p_format_scaling=>'none'
,p_scaling=>'linear'
,p_baseline_scaling=>'zero'
,p_position=>'auto'
,p_major_tick_rendered=>'off'
,p_minor_tick_rendered=>'off'
,p_tick_label_rendered=>'on'
,p_zoom_order_seconds=>false
,p_zoom_order_minutes=>false
,p_zoom_order_hours=>false
,p_zoom_order_days=>false
,p_zoom_order_weeks=>false
,p_zoom_order_months=>false
,p_zoom_order_quarters=>false
,p_zoom_order_years=>false
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(46757903889945188.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(46757621766940957.4355)
,p_button_name=>'REFRESH'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Atualizar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(46972209650230505.4355)
,p_branch_action=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P12_VIEW'
,p_branch_condition_text=>'DAY'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(46972816707241959.4355)
,p_branch_action=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P12_VIEW'
,p_branch_condition_text=>'HOUR'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(46971321293224408.4355)
,p_name=>'P12_VIEW'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(46757621766940957.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'DAY'
,p_prompt=>'Exibir'
,p_source=>'DAY'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'CHART SELECTOR'
,p_lov=>'.'||wwv_flow_api.id(46971429951226857.4355)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
end;
/
prompt --application/pages/page_00013
begin
wwv_flow_api.create_page(
 p_id=>13.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Painel de Controle da Atividade do Espa\00E7o de Trabalho')
,p_step_title=>unistr('Painel de Controle da Atividade do Espa\00E7o de Trabalho')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(5108313447012897)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(46992417268582735.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<h1>'
,p_plug_footer=>'</h1>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(46994113983619638.4355)
,p_plug_name=>unistr('Pain\00E9is de Controle')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(46989621592546067.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(168717528748286543.4355)
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(46994605803626706.4355)
,p_name=>'Principais Aplicativos'
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>40
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P13b */ substr(',
'       (select name from wwv_flows where id = application),1,25) application_name,',
'       page_events,',
'       application',
'from (',
'select ',
'    flow_id application,',
'    count(*) page_events',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'(flow_id not between 4000 and 4999 or :flow_security_group_id = 10) and',
'time_stamp > sysdate - :P13_TIME',
'group by flow_id',
'order by 2 desc',
') q',
'where rownum < 8'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46765105410141325.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(46994605803626706.4355)
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47022315799968072.4355)
,p_query_column_id=>1
,p_column_alias=>'APPLICATION_NAME'
,p_column_display_sequence=>3
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46998018981781834.4355)
,p_query_column_id=>2
,p_column_alias=>'PAGE_EVENTS'
,p_column_display_sequence=>2
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46996430446737873.4355)
,p_query_column_id=>3
,p_column_alias=>'APPLICATION'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(46996702442758171.4355)
,p_name=>unistr('Principais Usu\00E1rios')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>30
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  /* APEX4350P13a */ lower(substr(top_user,1,50)) top_user,',
'        event_count,',
'        top_user full_username',
'from (',
'select ',
'    userid top_user,',
'    count(*) event_count',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'       time_stamp > sysdate - :P13_TIME and',
'(flow_id not between 4000 and 4999 or :flow_security_group_id = 10) and',
'     userid is not null',
'group by userid',
') order by 2 desc'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46765105410141325.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46997232225766749.4355)
,p_query_column_id=>1
,p_column_alias=>'TOP_USER'
,p_column_display_sequence=>1
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46997301255766749.4355)
,p_query_column_id=>2
,p_column_alias=>'EVENT_COUNT'
,p_column_display_sequence=>2
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46997430501766749.4355)
,p_query_column_id=>3
,p_column_alias=>'FULL_USERNAME'
,p_column_display_sequence=>3
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(46998326861803030.4355)
,p_name=>'Log-ins Recentes'
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>60
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P13d */ ',
'  lower(login_name)||'' ''||application login_attempt,',
'  access_date',
'from   wwv_flow_user_access_log_v l',
'where  security_group_id = :flow_security_group_id',
'and access_date >= sysdate - nvl(:P13_TIME,1)',
'order by access_date desc'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46765105410141325.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(46998326861803030.4355)
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46998916257809499.4355)
,p_query_column_id=>1
,p_column_alias=>'LOGIN_ATTEMPT'
,p_column_display_sequence=>1
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46999007472809499.4355)
,p_query_column_id=>2
,p_column_alias=>'ACCESS_DATE'
,p_column_display_sequence=>2
,p_column_format=>'SINCE'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(46999814572837357.4355)
,p_name=>'Erros Recentes'
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>70
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P13e */ ',
'   substr(	',
'   flow_id||'':''||step_id||'' - ''||',
'     substr((substr(sys.utl_i18n.unescape_reference(SQLERRM),1,30)||'' ''||',
'     substr(sys.utl_i18n.unescape_reference(USERID),1,20)),1,35),',
'     1,35) error_and_user,',
'   TIME_STAMP',
'from WWV_FLOW_ACTIVITY_LOG',
'where   security_group_id = :flow_security_group_id and',
'  sqlerrm is not null and',
'  TIME_STAMP >= sysdate - nvl(:P13_TIME,1)',
'order by TIME_STAMP desc'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46765105410141325.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(46999814572837357.4355)
,p_plug_column_width=>'apex-col--bottomBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47000330633851422.4355)
,p_query_column_id=>1
,p_column_alias=>'ERROR_AND_USER'
,p_column_display_sequence=>1
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47000415198851422.4355)
,p_query_column_id=>2
,p_column_alias=>'TIME_STAMP'
,p_column_display_sequence=>2
,p_column_format=>'SINCE'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(47007806364967405.4355)
,p_name=>unistr('Principais P\00E1ginas')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>50
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P13c */ substr(',
'        application_id||'':''||page_id ||'' ''||',
'        substr((select name ',
'        from wwv_flow_steps ',
'        where id=page_id and flow_id=application_id),1,20),',
'        1,25)',
'       application_page,',
'       page_events',
'from',
'(',
'select ',
'    flow_id application_id,',
'    step_id page_id,',
'    count(*) page_events',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'(flow_id not between 4000 and 4999 or :flow_security_group_id = 10) and',
'time_stamp > sysdate - :P13_TIME',
'group by flow_id, step_id',
'order by 3 desc',
')',
'where rownum < 8'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46765105410141325.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47522024859162462.4355)
,p_query_column_id=>1
,p_column_alias=>'APPLICATION_PAGE'
,p_column_display_sequence=>1
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47008119491967405.4355)
,p_query_column_id=>2
,p_column_alias=>'PAGE_EVENTS'
,p_column_display_sequence=>2
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47029628200141872.4355)
,p_plug_name=>'Tarefas'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(166211911060758908.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
,p_plug_column_width=>'valign="top"'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47344306471037176.4355)
,p_plug_name=>unistr('Atividade do Usu\00E1rio')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:99%;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Veja um resumo de atividades do usu\00E1rio do espa\00E7o de trabalho no per\00EDodo selecionado.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(955889255851997303.4355)
,p_plug_name=>'Marcador'
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--hideHeader'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'apex-col--bottomBorder apex-col--leftBorder '
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(168425924484598602.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(46992417268582735.4355)
,p_button_name=>'MONITOR_ACTIVITY'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Monitorar Atividade'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(258482011097943097.4355)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(46998326861803030.4355)
,p_button_name=>'MONITOR_LOGINS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388538190684476853.4355)
,p_button_image_alt=>'Monitorar Log-ins'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:70:&SESSION.::&DEBUG.:RP::'
,p_button_css_classes=>'gotoIcon'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(46992700430587274.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(46992417268582735.4355)
,p_button_name=>'REFRESH'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Atualizar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(258480610204905780.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(46999814572837357.4355)
,p_button_name=>'VIEW'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388538190684476853.4355)
,p_button_image_alt=>'Exibir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:62:&SESSION.::&DEBUG.:RP::'
,p_button_css_classes=>'gotoIcon'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(258481411636934581.4355)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(46994605803626706.4355)
,p_button_name=>'VIEW_APPLICATIONS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388538190684476853.4355)
,p_button_image_alt=>'Exibir Aplicativos'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:RP::'
,p_button_css_classes=>'gotoIcon'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(46993519262602210.4355)
,p_branch_action=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(46993309565599388.4355)
,p_name=>'P13_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(46992417268582735.4355)
,p_prompt=>'Mostrar'
,p_source=>'select  3/24  from dual'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Identifique o per\00EDodo de relat\00F3rios. Per\00EDodos mais longos podem demorar mais para serem exibidos.')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
end;
/
prompt --application/pages/page_00014
begin
wwv_flow_api.create_page(
 p_id=>14.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Views de P\00E1gina por Hora')
,p_step_title=>unistr('Views de P\00E1gina por Hora')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(46754721279855631.4355)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(692992000648464146.4355)
,p_plug_name=>unistr('Eventos de P\00E1gina por Hora')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'NATIVE_JET_CHART'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_jet_chart(
 p_id=>wwv_flow_api.id(692992186674464147.4355)
,p_region_id=>wwv_flow_api.id(692992000648464146.4355)
,p_chart_type=>'line'
,p_height=>'450'
,p_animation_on_display=>'none'
,p_animation_on_data_change=>'none'
,p_orientation=>'vertical'
,p_data_cursor=>'auto'
,p_data_cursor_behavior=>'auto'
,p_hover_behavior=>'none'
,p_stack=>'off'
,p_stack_label=>'off'
,p_spark_chart=>'N'
,p_connect_nulls=>'Y'
,p_value_position=>'auto'
,p_sorting=>'label-asc'
,p_fill_multi_series_gaps=>true
,p_zoom_and_scroll=>'delayed'
,p_tooltip_rendered=>'Y'
,p_show_series_name=>true
,p_show_group_name=>true
,p_show_value=>true
,p_show_label=>true
,p_show_row=>true
,p_show_start=>true
,p_show_end=>true
,p_show_progress=>true
,p_show_baseline=>true
,p_legend_rendered=>'off'
,p_legend_position=>'auto'
,p_overview_rendered=>'off'
,p_horizontal_grid=>'auto'
,p_vertical_grid=>'auto'
,p_gauge_orientation=>'circular'
,p_gauge_plot_area=>'on'
,p_show_gauge_value=>true
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(692992209787464148.4355)
,p_chart_id=>wwv_flow_api.id(692992186674464147.4355)
,p_seq=>10
,p_name=>'Mostrar'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select short_date||'' - ''||substr(long_date,9)||'':00'' date_tooltip, short_date||'' ''||substr(long_date,9)||'':00'' short_date_format, nvl(events,0) events from (',
'     select ',
'       count(*) events,',
'       to_char(time_stamp,''YYYYMMDDHH24'') long_date,',
'       to_char(time_stamp,''mm/dd/yyyy'') short_date',
'     from   ',
'       WWV_FLOW_ACTIVITY_LOG l',
'     where',
'       security_group_id = :flow_security_group_id and',
'       page_mode != ''A'' and',
'       time_stamp >= sysdate - 2',
'     group by to_char(time_stamp,''YYYYMMDDHH24''),to_char(time_stamp,''mm/dd/yyyy'')',
'     order by 2 desc)'))
,p_items_value_column_name=>'EVENTS'
,p_items_label_column_name=>'SHORT_DATE_FORMAT'
,p_items_short_desc_column_name=>'DATE_TOOLTIP'
,p_line_style=>'solid'
,p_line_type=>'auto'
,p_marker_rendered=>'auto'
,p_marker_shape=>'auto'
,p_assigned_to_y2=>'off'
,p_items_label_rendered=>true
,p_items_label_position=>'auto'
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(713094373045315401.4355)
,p_chart_id=>wwv_flow_api.id(692992186674464147.4355)
,p_seq=>20
,p_name=>'Aceitar'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select short_date||'' - ''||substr(long_date,9)||'':00'' date_tooltip, short_date||'' ''||substr(long_date,9)||'':00'' short_date_format, nvl(events,0) events from (',
'     select ',
'       count(*) events,',
'       to_char(time_stamp,''YYYYMMDDHH24'') long_date,',
'       to_char(time_stamp,''mm/dd/yyyy'') short_date',
'     from   ',
'       WWV_FLOW_ACTIVITY_LOG l',
'     where',
'       security_group_id = :flow_security_group_id and',
'       page_mode = ''A'' and',
'       time_stamp >= sysdate - 2',
'     group by to_char(time_stamp,''YYYYMMDDHH24''),to_char(time_stamp,''mm/dd/yyyy'')',
'     order by 2 desc)'))
,p_items_value_column_name=>'EVENTS'
,p_items_label_column_name=>'SHORT_DATE_FORMAT'
,p_items_short_desc_column_name=>'DATE_TOOLTIP'
,p_line_style=>'solid'
,p_line_type=>'auto'
,p_marker_rendered=>'auto'
,p_marker_shape=>'auto'
,p_assigned_to_y2=>'off'
,p_items_label_rendered=>true
,p_items_label_position=>'auto'
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
);
wwv_flow_api.create_jet_chart_axis(
 p_id=>wwv_flow_api.id(692992358838464149.4355)
,p_chart_id=>wwv_flow_api.id(692992186674464147.4355)
,p_axis=>'x'
,p_is_rendered=>'on'
,p_format_type=>'time-short'
,p_format_scaling=>'auto'
,p_scaling=>'linear'
,p_baseline_scaling=>'zero'
,p_major_tick_rendered=>'on'
,p_minor_tick_rendered=>'off'
,p_tick_label_rendered=>'on'
,p_tick_label_rotation=>'auto'
,p_tick_label_position=>'outside'
,p_zoom_order_seconds=>false
,p_zoom_order_minutes=>false
,p_zoom_order_hours=>false
,p_zoom_order_days=>false
,p_zoom_order_weeks=>false
,p_zoom_order_months=>false
,p_zoom_order_quarters=>false
,p_zoom_order_years=>false
);
wwv_flow_api.create_jet_chart_axis(
 p_id=>wwv_flow_api.id(692992481730464150.4355)
,p_chart_id=>wwv_flow_api.id(692992186674464147.4355)
,p_axis=>'y'
,p_is_rendered=>'on'
,p_format_scaling=>'auto'
,p_scaling=>'linear'
,p_baseline_scaling=>'zero'
,p_step=>100
,p_position=>'auto'
,p_major_tick_rendered=>'off'
,p_minor_tick_rendered=>'on'
,p_tick_label_rendered=>'on'
,p_zoom_order_seconds=>false
,p_zoom_order_minutes=>false
,p_zoom_order_hours=>false
,p_zoom_order_days=>false
,p_zoom_order_weeks=>false
,p_zoom_order_months=>false
,p_zoom_order_quarters=>false
,p_zoom_order_years=>false
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(46754900978859248.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(46754721279855631.4355)
,p_button_name=>'REFRESH'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(297663202145957383.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Atualizar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(46973210258249523.4355)
,p_branch_action=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P14_VIEW'
,p_branch_condition_text=>'DAY'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(21106400138500046.4355)
,p_branch_action=>'f?p=&FLOW_ID.:14:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(46754325341800080.4355)
,p_name=>'P14_CURRENT_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(46754721279855631.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Hor\00E1rio Atual:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''DL FMTS'') d',
'from dual'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_attributes=>'class="fieldtitlebold"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(46972609781239990.4355)
,p_name=>'P14_VIEW'
,p_item_sequence=>2
,p_item_plug_id=>wwv_flow_api.id(46754721279855631.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'HOUR'
,p_prompt=>'Exibir'
,p_source=>'HOUR'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'CHART SELECTOR'
,p_lov=>'.'||wwv_flow_api.id(46971429951226857.4355)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
end;
/
prompt --application/pages/page_00015
begin
wwv_flow_api.create_page(
 p_id=>15.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Atividade da Sess\00E3o por Hora')
,p_step_title=>unistr('Atividade da Sess\00E3o por Hora')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(692990466454464130.4355)
,p_plug_name=>unistr('Views de p\00E1gina por hora nas \00FAltimas 48 horas')
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'NATIVE_JET_CHART'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_footer=>unistr('<p>Contagem de sess\00F5es distintas com views de p\00E1gina nas \00FAltimas 48 horas. As horas exibidas s\00E3o baseadas no hor\00E1rio do servidor.</p>')
);
wwv_flow_api.create_jet_chart(
 p_id=>wwv_flow_api.id(692990595257464131.4355)
,p_region_id=>wwv_flow_api.id(692990466454464130.4355)
,p_chart_type=>'bar'
,p_height=>'400'
,p_animation_on_display=>'none'
,p_animation_on_data_change=>'none'
,p_orientation=>'vertical'
,p_data_cursor=>'auto'
,p_data_cursor_behavior=>'auto'
,p_hover_behavior=>'none'
,p_stack=>'off'
,p_stack_label=>'off'
,p_spark_chart=>'N'
,p_connect_nulls=>'Y'
,p_value_position=>'auto'
,p_sorting=>'label-asc'
,p_fill_multi_series_gaps=>true
,p_zoom_and_scroll=>'delayed'
,p_tooltip_rendered=>'Y'
,p_show_series_name=>false
,p_show_group_name=>true
,p_show_value=>true
,p_show_label=>true
,p_show_row=>true
,p_show_start=>true
,p_show_end=>true
,p_show_progress=>true
,p_show_baseline=>true
,p_legend_rendered=>'off'
,p_legend_position=>'auto'
,p_overview_rendered=>'off'
,p_time_axis_type=>'enabled'
,p_horizontal_grid=>'auto'
,p_vertical_grid=>'auto'
,p_gauge_orientation=>'circular'
,p_gauge_plot_area=>'on'
,p_show_gauge_value=>true
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(692990638467464132.4355)
,p_chart_id=>wwv_flow_api.id(692990595257464131.4355)
,p_seq=>10
,p_name=>unistr('Views de P\00E1gina')
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select to_timestamp(r.long_date||'':00'',''YYYYMMDDHH24:MI'') long_date,',
'       r.short_date short_date,',
'       nvl(l.views,0) views',
'from   ',
'    (',
'    select ',
'       count(distinct session_id) views,',
'       to_char(time_stamp,''YYYYMMDDHH24'') long_date',
'     from   ',
'       WWV_FLOW_ACTIVITY_LOG l',
'     where',
'       security_group_id = :flow_security_group_id and',
'       page_mode != ''A'' and',
'       time_stamp >= sysdate - 2',
'     group by to_char(time_stamp,''YYYYMMDDHH24'')) l,',
'     (select to_char((select (sysdate-1)+((rnum)/24) from dual),''HH24'') hr,',
'     				 to_char((select (sysdate-2)+((rnum)/24) from dual),''YYYYMMDDHH24'') long_date,',
'                     to_char((select (sysdate-2)+((rnum)/24) from dual),''mm/dd/yyyy'') short_date,',
'     				 rnum',
'				from',
'				(select rownum rnum ',
'				   from sys.dba_objects ',
'				  where rownum < 49)) r',
' where l.long_date(+) = r.long_date',
' order by r.rnum'))
,p_max_row_count=>250
,p_items_value_column_name=>'VIEWS'
,p_items_label_column_name=>'LONG_DATE'
,p_items_short_desc_column_name=>'SHORT_DATE'
,p_assigned_to_y2=>'off'
,p_items_label_rendered=>true
,p_items_label_position=>'outsideBarEdge'
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
);
wwv_flow_api.create_jet_chart_axis(
 p_id=>wwv_flow_api.id(692990756467464133.4355)
,p_chart_id=>wwv_flow_api.id(692990595257464131.4355)
,p_axis=>'x'
,p_is_rendered=>'on'
,p_format_type=>'time-short'
,p_format_scaling=>'auto'
,p_scaling=>'linear'
,p_baseline_scaling=>'zero'
,p_major_tick_rendered=>'on'
,p_minor_tick_rendered=>'on'
,p_tick_label_rendered=>'on'
,p_tick_label_rotation=>'auto'
,p_tick_label_position=>'outside'
,p_zoom_order_seconds=>false
,p_zoom_order_minutes=>false
,p_zoom_order_hours=>false
,p_zoom_order_days=>false
,p_zoom_order_weeks=>false
,p_zoom_order_months=>false
,p_zoom_order_quarters=>false
,p_zoom_order_years=>false
);
wwv_flow_api.create_jet_chart_axis(
 p_id=>wwv_flow_api.id(692990871921464134.4355)
,p_chart_id=>wwv_flow_api.id(692990595257464131.4355)
,p_axis=>'y'
,p_is_rendered=>'on'
,p_format_type=>'decimal'
,p_decimal_places=>0
,p_format_scaling=>'auto'
,p_scaling=>'linear'
,p_baseline_scaling=>'zero'
,p_position=>'auto'
,p_major_tick_rendered=>'off'
,p_minor_tick_rendered=>'off'
,p_tick_label_rendered=>'on'
,p_zoom_order_seconds=>false
,p_zoom_order_minutes=>false
,p_zoom_order_hours=>false
,p_zoom_order_days=>false
,p_zoom_order_weeks=>false
,p_zoom_order_months=>false
,p_zoom_order_quarters=>false
,p_zoom_order_years=>false
);
end;
/
prompt --application/pages/page_00016
begin
wwv_flow_api.create_page(
 p_id=>16.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Detalhes do Estado de Sess\00E3o')
,p_step_title=>unistr('Detalhes do Estado de Sess\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215469304188572178)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12518728403445471)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_purge_session.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10298124982245880.4355)
,p_plug_name=>unistr('Estado da Sess\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'       session_id flow_instance,',
'       item_name  i,',
'       item_value,',
'       session_state_status,',
'       application_id flow_id,',
'       application_name,',
'       page_id,',
'       page_name',
'  from wwv_flow_data_view',
' where session_id = :FLOW_SESSION'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(10298231278245880.4355)
,p_name=>'Session State'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10298425155245907.4355)
,p_db_column_name=>'FLOW_INSTANCE'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('Sess\00E3o')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10298501271245908.4355)
,p_db_column_name=>'I'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Item'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10298701631245908.4355)
,p_db_column_name=>'SESSION_STATE_STATUS'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Status'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10298809834245908.4355)
,p_db_column_name=>'FLOW_ID'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Aplicativo'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10300416585252734.4355)
,p_db_column_name=>'APPLICATION_NAME'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Nome do Aplicativo'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10302523080273547.4355)
,p_db_column_name=>'PAGE_ID'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10303115939280913.4355)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('Nome da P\00E1gina')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(22411130140635457.4355)
,p_db_column_name=>'ITEM_VALUE'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Valor do Item'
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(452409822478775583.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(10298124982245880.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(174246003001070427.4355)
,p_branch_action=>'16'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>99
);
end;
/
prompt --application/pages/page_00017
begin
wwv_flow_api.create_page(
 p_id=>17.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Definir Prefer\00EAncias do Espa\00E7o de Trabalho')
,p_step_title=>unistr('Definir Prefer\00EAncias do Espa\00E7o de Trabalho')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_html_page_onload=>'onload="p17_checkdisable()"'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215469304188572178)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script type="text/javascript">',
'<!--',
'',
'function p17_checkdisable(){ ',
'var ltext_0 = $x(''P17_EXPIRE_FND_USER_ACCOUNTS_0''); ',
'var ltext_1 = $x(''P17_EXPIRE_FND_USER_ACCOUNTS_1''); ',
'var ltext; ',
'if(ltext_0.checked == true){ltext = ltext_0}else{ltext = ltext_1} ',
'html_DisableOnValue(ltext,''N'',''P17_ACCOUNT_LIFETIME_DAYS'',''P17_USER_MAX_LOGIN_FAILURES'') ',
'} ',
'',
'//-->',
'</script>'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/*apex.jQuery(''#P17_WORKSPACE_IMAGE ~ a'').each(function() {',
'    if (this.href.match(/apex_util.get_blob_file/)) {',
'        $x("public_workspace_img").src = this.href;',
'    }',
'});*/'))
,p_step_template=>wwv_flow_api.id(692762523503114201.4355)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12518728403445471)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_prefs.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1221407852620126.4355)
,p_plug_name=>'Team Development'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>100
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>'return not wwv_flow.apps_only_workspace;'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5171608747872545.4355)
,p_plug_name=>'Controle do Log-in da Conta'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5181326820057615.4355)
,p_plug_name=>unistr('Definir Prefer\00EAncias')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('As prefer\00EAncias controlam a funcionalidade do espa\00E7o de trabalho.')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(46267907729679029.4355)
,p_plug_name=>unistr('Seletor de Exibi\00E7\00E3o de Regi\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(40275409253350646.4355)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(113858225820003007.4355)
,p_plug_name=>unistr('Definir Prefer\00EAncias do Espa\00E7o de Trabalho')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--wizard:a-ButtonRegion--noUI:a-ButtonRegion--showTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173246109288066858.4355)
,p_plug_name=>'SQL Workshop'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>'return not wwv_flow.apps_only_workspace;'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173247328728100853.4355)
,p_plug_name=>'Websheets'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173247501155102363.4355)
,p_plug_name=>'Team Development Legado (Obsoleto)'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>110
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>'return not wwv_flow.apps_only_workspace;'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173247816392106815.4355)
,p_plug_name=>'App Builder'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>'return not wwv_flow.apps_only_workspace;'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(327482312829627868.4355)
,p_plug_name=>'Team Development'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>100
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>unistr('<p>Ativar o upload do arquivo no Desenvolvimento da Equipe criar\00E1 uma tabela de APEX$.</p>')
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>'return not wwv_flow.apps_only_workspace;'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(113887204096053504.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(113858225820003007.4355)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(113889631108061313.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(113858225820003007.4355)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(113889809101061315.4355)
,p_branch_action=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(113889631108061313.4355)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1221686539620128.4355)
,p_name=>'P17_ALLOW_ISSUE_FILES_YN'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1221407852620126.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('Ativar Reposit\00F3rio de Arquivos de Problemas')
,p_source=>'ALLOW_ISSUE_FILES_YN'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'case wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FILES_YN'')',
'    when ''Y'' then :P17_ALLOW_ISSUE_FILES_YN',
'    else ''N''',
'end;'))
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157815226475866526.4355)||'.'
,p_cHeight=>1
,p_read_only_when=>'nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FILES_YN''), ''N'') = ''N'''
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione <strong>Sim</strong> para permitir o upload dos arquivos para o reposit\00F3rio central de arquivos do Team Development. Selecione <strong>N\00E3o</strong> para n\00E3o permitir o upload dos arquivos para o reposit\00F3rio central. ')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1221742845620129.4355)
,p_name=>'P17_ISSUE_FS_LIMIT'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1221407852620126.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('Tamanho M\00E1ximo do Arquivo (em MB)')
,p_source=>'ISSUE_FS_LIMIT'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ISSUES_FS_LIMIT'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 5       as dv,',
'       5242880 as rv',
' from dual',
'where 5242880 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)',
'union all',
'select 10       as dv,',
'       10485760 as rv',
' from dual',
'where 10485760 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)',
'union all',
'select 15       as dv,',
'       15728640 as rv',
' from dual',
'where 15728640 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)',
'union all',
'select 20       as dv,',
'       20971520 as rv',
' from dual',
'where 20971520 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)',
'union all',
'select 25       as dv,',
'       26214400 as rv',
' from dual',
'where 26214400 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_ISSUE_FS_LIMIT''),15728640)',
' order by 1'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione o tamanho m\00E1ximo do arquivo para qualquer arquivo submetido a upload no reposit\00F3rio central de arquivos do Team Development.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4828217458002138.4355)
,p_name=>'P17_EXPIRE_FND_USER_ACCOUNTS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5171608747872545.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Expira\00E7\00E3o e Bloqueio da Conta:')
,p_source=>'EXPIRE_FND_USER_ACCOUNTS'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'case',
'  when wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS'')=''Y'' then ''Y''',
'  else nvl(:P17_EXPIRE_FND_USER_ACCOUNTS,''N'')',
'end'))
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'EXPIRE USER ACCOUNTS'
,p_lov=>'.'||wwv_flow_api.id(4834509455047185.4355)||'.'
,p_tag_attributes=>'onchange="p17_checkdisable()"'
,p_read_only_when=>'nvl(wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS''),''N'') = ''Y'''
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Selecione para determinar se contas de usu\00E1rio final do &PRODUCT_NAME. podem ser encerradas ou bloqueadas. Esse recurso se aplica apenas a contas de'),
unistr('usu\00E1rio final criadas usando-se a interface de gerenciamento de usu\00E1rio do &PRODUCT_NAME..'),
unistr(' As op\00E7\00F5es dispon\00EDveis incluem:'),
'<ul>',
'<li>Ativar</li>',
'<li>Desativar</li>',
'</ul>',
unistr('O recurso oferece seguran\00E7a adicional de autentica\00E7\00E3o para aplicativos.'),
unistr('Se voc\00EA selecionar<b>Ativar</b>, as senhas da conta do usu\00E1rio ser\00E1 encerrada ap\00F3s per\00EDodo configur\00E1vel de tempo,'),
unistr('contas ser\00E3o bloqueadas depois um n\00FAmero configur\00E1vel de falhas de autentica\00E7\00E3o e senhas de contas poder\00E3o ser definidas para serem encerradas ap\00F3s o primeiro uso.'),
'<p>',
unistr('Se o administrador da instala\00E7\00E3o do &PRODUCT_NAME. tiver especificado a Defini\00E7\00E3o de Ambiente <b>Exigir Encerramento e Bloqueio de Conta de Usu\00E1rio </b> como Sim, significa que o recurso deve ser ativado em todos os espa\00E7os de trabalho e o item exibi')
||unistr('r\00E1 <b>Ativado</b> e n\00E3o poder\00E1 ser alterado pelo administrador do espa\00E7o de trabalho.')))
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4829116550011426.4355)
,p_name=>'P17_USER_MAX_LOGIN_FAILURES'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5171608747872545.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'nvl (',
'    wwv_flow_platform.get_preference(''MAX_LOGIN_FAILURES''),',
'    4 )'))
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('N\00FAmero M\00E1ximo de Falhas de Log-in Permitidas:')
,p_source=>'FND_USER_MAX_LOGIN_FAILURES'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>3
,p_cMaxlength=>5
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Informe um n\00FAmero inteiro positivo a ser usado como o n\00FAmero m\00E1ximo permitido de tentativas de autentica\00E7\00E3o sem sucesso antes de uma conta de usu\00E1rio final ser bloqueada.'),
unistr('Se voc\00EA n\00E3o especificar um valor neste campo, ser\00E1 usada a Defini\00E7\00E3o de Ambiente <b>N\00FAmero M\00E1ximo de Falhas de Log-in Permitidas</b> no n\00EDvel do site.')))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5483624971767521.4355)
,p_name=>'P17_ACCOUNT_LIFETIME_DAYS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(5171608747872545.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'nvl (',
'    wwv_flow_platform.get_preference(''ACCOUNT_LIFETIME_DAYS''),',
'    45 )'))
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('Vida \00DAtil da Conta do Usu\00E1rio Final (dias):')
,p_source=>'ACCOUNT_LIFETIME_DAYS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>3
,p_cMaxlength=>10
,p_field_template=>wwv_flow_api.id(489153170799943531.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Informe um n\00FAmero inteiro positivo a ser usado como o n\00FAmero m\00E1ximo de dias em que uma senha de conta de usu\00E1rio pode ser usada antes de a conta expirar. Se voc\00EA n\00E3o especificar um valor neste campo, ser\00E1 usada a Defini\00E7\00E3o de Ambiente <b>Vida \00DAtil da')
||unistr(' Senha da  Conta</b> no n\00EDvel do site.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(8483028405465485.4355)
,p_name=>'P17_PROVISIONING_COMPANY_ID'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(113858225820003007.4355)
,p_use_cache_before_default=>'NO'
,p_source=>'PROVISIONING_COMPANY_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(113919310002206635.4355)
,p_name=>'P17_PLSQL_EDITING'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(173246109288066858.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Edi\00E7\00E3o de PL/SQL:')
,p_source=>'ALLOW_PLSQL_EDITING'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'case',
'  when wwv_flow_platform.get_preference(''PLSQL_EDITING'')=''N'' then ''N''',
'  else nvl(:P17_PLSQL_EDITING,''Y'')',
'end'))
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'PLSQL EDITING STATUS'
,p_lov=>'.'||wwv_flow_api.id(113937100137241641.4355)||'.'
,p_read_only_when=>'nvl(wwv_flow_platform.get_preference(''PLSQL_EDITING''),''Y'') = ''N'''
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_escape_on_http_output=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Fa\00E7a uma sele\00E7\00E3o para determinar se os desenvolvedores poder\00E3o editar e compilar unidades de programa PL/SQL no Browser de Objetos. As op\00E7\00F5es dispon\00EDveis incluem:'),
'<ul>',
unistr('<li>Permitir edi\00E7\00E3o de unidade de programa PL/SQL</li>'),
unistr('<li>N\00E3o permitir edi\00E7\00E3o de unidade de programa PL/SQL</li>'),
'</ul>',
unistr('Este recurso se destina a incentivar os programadores a n\00E3o alterar c\00F3digo PL/SQL diretamente no Dicion\00E1rio de Dados. Se voc\00EA selecionar <b>N\00E3o permitir edi\00E7\00E3o de unidade de programa PL/SQL</b>, os desenvolvedores ainda poder\00E3o criar e substituir uni')
||'dades de programa PL/SQL usando scripts ou o Processador de Comandos SQL.'))
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(173267514604352193.4355)
,p_name=>'P17_ALLOW_APP_BUILDING_YN'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(173247816392106815.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>'Ativar App Builder'
,p_source=>'ALLOW_APP_BUILDING_YN'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157815226475866526.4355)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Especifique se o uso e o desenvolvimento do Application Builder do espa\00E7o de trabalho atual ser\00E3o ou n\00E3o ativados. Selecione <b>Sim</b> ou <b>N\00E3o</b>.<br><br>'),
unistr('Esta defini\00E7\00E3o tamb\00E9m controla a disponibilidade de Aplicativos de Produtividade e Amostra para o espa\00E7o de trabalho atual.'),
unistr('Use o Application Builder para montar um aplicativo em objetos de banco de dados existentes, como tabelas e procedimentos. Os aplicativos de Produtividade s\00E3o suportados pela Oracle.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(173268016167390540.4355)
,p_name=>'P17_ALLOW_SQL_WORKSHOP_YN'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(173246109288066858.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>'Ativar SQL Workshop'
,p_source=>'ALLOW_SQL_WORKSHOP_YN'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157815226475866526.4355)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Especifica se ativar o SQL Workshop no espa\00E7o de trabalho atual. Selecione <b>Sim</b> ou <b>N\00E3o</b>.<br>'),
unistr('Use o SQL Workshop para acessar ferramentas para exibi\00E7\00E3o e gerenciamento de objetos de banco de dados. ')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(173268306602397209.4355)
,p_name=>'P17_ALLOW_WEBSHEET_DEV_YN'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(173247328728100853.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>'Ativar Uso e Desenvolvimento da Websheet'
,p_source=>'ALLOW_WEBSHEET_DEV_YN'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157815226475866526.4355)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Especifica se o uso e o desenvolvimento da Websheet para o espa\00E7o de trabalho atual ser\00E3o ou n\00E3o ativados. Selecione <b>Sim</b> ou <b>N\00E3o</b>.<br>'),
unistr('As Websheets oferecem uma abordagem f\00E1cil e declarativa para o layout de relat\00F3rio e form pois a cria\00E7\00E3o de tabelas, triggers e sequ\00EAncias \00E9 tratada automaticamente. ')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(173268926472412387.4355)
,p_name=>'P17_ALLOW_TEAM_DEVELOPMENT_YN'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(173247501155102363.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>'Ativar o Team Development'
,p_source=>'ALLOW_TEAM_DEVELOPMENT_YN'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157815226475866526.4355)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Especifica se o Team Development Legado ser\00E1 ativado no espa\00E7o de trabalho atual. Selecione <b>Sim</b> ou <b>N\00E3o</b>.<br>'),
unistr('Use este aplicativo para rastrear e gerenciar o processo de desenvolvimento. A p\00E1gina Team Development Legado apresenta ferramentas dedicadas para permitir que voc\00EA defina e rastreie aprimoramentos de recursos, tarefas, marcos, bugs e feedback.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(314428629679648088.4355)
,p_name=>'P17_ALLOW_TEAM_DEV_FILES_YN'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(173247501155102363.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('Ativar Reposit\00F3rio de Arquivos do Team Development')
,p_source=>'ALLOW_TEAM_DEV_FILES_YN'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'case wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FILES_YN'')',
'    when ''Y'' then :P17_ALLOW_TEAM_DEV_FILES_YN',
'    else ''N''',
'end;'))
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157815226475866526.4355)||'.'
,p_cHeight=>1
,p_read_only_when=>'nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FILES_YN''), ''N'') = ''N'''
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
unistr('    Especifique se deseja ativar o upload do arquivo no Team Development Legado. Selecionar <b>Sim</b> criar\00E1 uma tabela APEX$ local para armazenar os arquivos.'),
'</p>',
'<p>',
unistr('    Este atributo s\00F3 poder\00E1 ser modificado se a configura\00E7\00E3o da funcionalidade "Ativar Reposit\00F3rio de Arquivos do Team Development Legado" na administra\00E7\00E3o interna do &PRODUCT_NAME. estiver definida como "Sim".'),
'</p>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(319101421909723145.4355)
,p_name=>'P17_ALLOW_RESTFUL_SERVICES_YN'
,p_item_sequence=>75
,p_item_plug_id=>wwv_flow_api.id(173246109288066858.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>unistr('Ativar Servi\00E7os RESTful')
,p_source=>'ALLOW_RESTFUL_SERVICES_YN'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157815226475866526.4355)||'.'
,p_cHeight=>1
,p_display_when=>'wwv_flow_platform.get_preference(''RESTFUL_SERVICES_ENABLED'') = ''Y'''
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Especifique se os Servi\00E7os RESTful devem ser ativados no espa\00E7o de trabalho atual.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(319102415427741291.4355)
,p_name=>'P17_PATH_PREFIX'
,p_item_sequence=>95
,p_item_plug_id=>wwv_flow_api.id(173246109288066858.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Prefixo de Caminho'
,p_source=>'PATH_PREFIX'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>255
,p_display_when=>'not wwv_flow_global.g_cloud'
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(489153170799943531.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Especifique o prefixo do caminho do URI a ser usado para acessar Servi\00E7os RESTful no espa\00E7o de trabalho atual. O valor do prefixo do caminho padr\00E3o \00E9 o nome do espa\00E7o de trabalho.</p>'),
'',
unistr('<p>Por exemplo, um espa\00E7o de trabalho chamado <b>QA_1</b> pode ter um prefixo de caminho definido como <b>QA</b>. Nesse caso, a amostra de servi\00E7o RESTful estar\00E1 dispon\00EDvel em:</p>'),
'',
'<p><code>http://www.example.com/apex<b>/qa/</b>hr/employees/</code></p>'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(529293356266976427.4355)
,p_name=>'P17_MANUAL_PATH_PREFIX'
,p_item_sequence=>85
,p_item_plug_id=>wwv_flow_api.id(173246109288066858.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Substituir Alias de Esquema ORDS'
,p_source=>'N'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_YES_NO'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_pattern varchar2(255);',
'begin',
'    if wwv_flow_global.g_cloud then',
'        return false;',
'    end if;',
'    ',
'    begin',
'        l_pattern := wwv_flow_dynamic_exec.get_first_row_result_varchar2(',
'            p_sql_statement => ''select pattern',
'                                  from user_ords_schemas',
'                                 where upper(pattern) = upper(:P17_PATH_PREFIX)'',',
'            p_parse_as_schema => wwv_flow_user_api.get_default_schema );',
'            ',
'        if l_pattern is not null then ',
'            return true; ',
'        else',
'            return false;',
'        end if;',
'    exception',
'        when others then return false;',
'    end;',
'exception',
'    when others then return false;',
'end;'))
,p_display_when_type=>'FUNCTION_BODY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
unistr('    O esquema padr\00E3o para esse espa\00E7o de trabalho \00E9 ativado para Servi\00E7os REST com base no Reposit\00F3rio do ORDS (Oracle REST Data Services). Um Alias de Esquema \00E9 configurado nos metadados do ORDS e s\00F3 deve ser alterado dentro dos <strong>Servi\00E7os RES')
||'T</strong> no SQL Workshop. ',
'</p>',
'<p>',
unistr('    A defini\00E7\00E3o dessa op\00E7\00E3o como <b>Ativado</b> s\00F3 permite que voc\00EA substitua o Prefixo de Caminho REST para o Reposit\00F3rio do Application Express. A Oracle <em>n\00E3o</em> recomenda ter valores diferentes para o Alias do Esquema do ORDS e o Prefixo de C')
||unistr('aminho de Espa\00E7o de Trabalho do Application Express.'),
'</p>',
'<p>',
unistr('  A menos que seja recomendado em contr\00E1rio, mantenha essa op\00E7\00E3o definida como <b>Desativado</b>.'),
'</p>'))
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(655281725315073604.4355)
,p_name=>'P17_TEAM_DEV_FS_LIMIT'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(173247501155102363.4355)
,p_use_cache_before_default=>'NO'
,p_item_default=>'nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('Tamanho M\00E1ximo do Arquivo (em MB)')
,p_source=>'TEAM_DEV_FS_LIMIT'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TEAM_DEV_FS_LIMIT'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 5       as dv,',
'       5242880 as rv',
' from dual',
'where 5242880 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)',
'union all',
'select 10       as dv,',
'       10485760 as rv',
' from dual',
'where 10485760 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)',
'union all',
'select 15       as dv,',
'       15728640 as rv',
' from dual',
'where 15728640 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)',
'union all',
'select 20       as dv,',
'       20971520 as rv',
' from dual',
'where 20971520 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)',
'union all',
'select 25       as dv,',
'       26214400 as rv',
' from dual',
'where 26214400 <= nvl(wwv_flow_platform.get_preference(''WORKSPACE_TEAM_DEV_FS_LIMIT''),15728640)',
' order by 1'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione o tamanho m\00E1ximo do arquivo para qualquer arquivo submetido a upload no reposit\00F3rio de arquivos do Team Development Legado. O valor padr\00E3o \00E9 15 MB.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(755295374237836819.4355)
,p_name=>'P17_ALLOW_PACKAGED_APP_INS_YN'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(173247816392106815.4355)
,p_use_cache_before_default=>'NO'
,p_source=>'ALLOW_PACKAGED_APP_INS_YN'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cHeight=>1
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
end;
/
begin
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(5488712607896482.4355)
,p_computation_sequence=>10
,p_computation_item=>'P17_EXPIRE_FND_USER_ACCOUNTS'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS''),''N'') = ''Y''',
'  then return ''Y'';',
'else',
'  return v(''P17_EXPIRE_FND_USER_ACCOUNTS'');',
'end if;'))
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(620836494241373127.4355)
,p_computation_sequence=>10
,p_computation_item=>'P17_PATH_PREFIX'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'upper(:P17_PATH_PREFIX)'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(5225431816970359.4355)
,p_validation_name=>'Expire FND User Accounts in Y/N or null'
,p_validation_sequence=>10
,p_validation=>'nvl(:P17_EXPIRE_FND_USER_ACCOUNTS,''N'') in (''Y'',''N'')'
,p_validation_type=>'PLSQL_EXPRESSION'
,p_error_message=>'Valor fora da faixa.'
,p_when_button_pressed=>wwv_flow_api.id(113889631108061313.4355)
,p_associated_item=>wwv_flow_api.id(4828217458002138.4355)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(5500703800083172.4355)
,p_validation_name=>'max login failures positive'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_number number;',
'begin',
'    l_number := to_number( :P17_USER_MAX_LOGIN_FAILURES );',
'    if l_number = abs(trunc(l_number)) then',
'        return TRUE;',
'    else ',
'        return FALSE;',
'    end if;',
'exception',
'    when others then',
'        return FALSE;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'O valor deve ser um inteiro positivo.'
,p_validation_condition=>'P17_USER_MAX_LOGIN_FAILURES'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(113889631108061313.4355)
,p_associated_item=>wwv_flow_api.id(4829116550011426.4355)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(5501825617089452.4355)
,p_validation_name=>'account lifetime positive'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_number number;',
'begin',
'    l_number := to_number( :P17_ACCOUNT_LIFETIME_DAYS );',
'    if l_number = abs(trunc(l_number)) then',
'        return TRUE;',
'    else ',
'        return FALSE;',
'    end if;',
'exception',
'    when others then',
'        return FALSE;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'O valor deve ser um inteiro positivo.'
,p_validation_condition=>'P17_ACCOUNT_LIFETIME_DAYS'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(113889631108061313.4355)
,p_associated_item=>wwv_flow_api.id(5483624971767521.4355)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(319144900453128092.4355)
,p_validation_name=>'Path Prefix Must Have Value'
,p_validation_sequence=>40
,p_validation=>'P17_PATH_PREFIX'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#LABEL# deve ter algum valor.'
,p_validation_condition=>':P17_ALLOW_SQL_WORKSHOP_YN = ''Y'' and :P17_ALLOW_RESTFUL_SERVICES_YN = ''Y'' and not wwv_flow_global.g_cloud'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(113889631108061313.4355)
,p_associated_item=>wwv_flow_api.id(319102415427741291.4355)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(320869816918414854.4355)
,p_validation_name=>'Path Prefix Already Exists'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select 1',
'             from wwv_flow_companies',
'            where path_prefix = upper(:P17_PATH_PREFIX)',
'             and provisioning_company_id <> :flow_security_group_id ) loop',
'   return false;',
'   exit;',
'end loop;',
'',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('#LABEL# j\00E1 existe.')
,p_validation_condition=>':P17_ALLOW_SQL_WORKSHOP_YN = ''Y'' and :P17_ALLOW_RESTFUL_SERVICES_YN = ''Y'' and not wwv_flow_global.g_cloud'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(113889631108061313.4355)
,p_associated_item=>wwv_flow_api.id(319102415427741291.4355)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(620836305429373126.4355)
,p_validation_name=>'Restricted Path Prefix Characters'
,p_validation_sequence=>60
,p_validation=>'P17_PATH_PREFIX'
,p_validation2=>'^[ABCDEFGHIJKLMNOPQRSTUVWXYZ[:digit:]_-]+$'
,p_validation_type=>'REGULAR_EXPRESSION'
,p_error_message=>unistr('#LABEL# deve conter s\00F3 caracteres alfanum\00E9ricos, ou "-" ou "_".')
,p_validation_condition=>':P17_ALLOW_SQL_WORKSHOP_YN = ''Y'' and :P17_ALLOW_RESTFUL_SERVICES_YN = ''Y'' and not wwv_flow_global.g_cloud'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(319102415427741291.4355)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(504160631041512755.4355)
,p_name=>'Set PL/SQL Editing'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P17_ALLOW_SQL_WORKSHOP_YN'
,p_condition_element=>'P17_ALLOW_SQL_WORKSHOP_YN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(504160921379512755.4355)
,p_event_id=>wwv_flow_api.id(504160631041512755.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_PLSQL_EDITING'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(319137025988009917.4355)
,p_event_id=>wwv_flow_api.id(504160631041512755.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_ALLOW_RESTFUL_SERVICES_YN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(504161117126512756.4355)
,p_event_id=>wwv_flow_api.id(504160631041512755.4355)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_PLSQL_EDITING'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(319137222968011341.4355)
,p_event_id=>wwv_flow_api.id(504160631041512755.4355)
,p_event_result=>'FALSE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_ALLOW_RESTFUL_SERVICES_YN,P17_PATH_PREFIX'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(321989200019520191.4355)
,p_event_id=>wwv_flow_api.id(504160631041512755.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_ALLOW_RESTFUL_SERVICES_YN'
,p_attribute_01=>'FUNCTION_BODY'
,p_attribute_06=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P17_ALLOW_RESTFUL_SERVICES_YN = ''N'' then',
'  return ''Y'';',
'end if;'))
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(321953223841387573.4355)
,p_event_id=>wwv_flow_api.id(504160631041512755.4355)
,p_event_result=>'FALSE'
,p_action_sequence=>40
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_ALLOW_RESTFUL_SERVICES_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(319105500624780088.4355)
,p_name=>'REST = Yes'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P17_ALLOW_RESTFUL_SERVICES_YN'
,p_condition_element=>'P17_ALLOW_RESTFUL_SERVICES_YN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(319147932500219616.4355)
,p_event_id=>wwv_flow_api.id(319105500624780088.4355)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_PATH_PREFIX'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(319106230675780091.4355)
,p_event_id=>wwv_flow_api.id(319105500624780088.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_PATH_PREFIX'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(655281866528073605.4355)
,p_name=>'Show/Hide P17_TEAM_DEV_FS_LIMIT'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P17_ALLOW_TEAM_DEV_FILES_YN'
,p_condition_element=>'P17_ALLOW_TEAM_DEV_FILES_YN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'N'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(655281943393073606.4355)
,p_event_id=>wwv_flow_api.id(655281866528073605.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_TEAM_DEV_FS_LIMIT'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(655282003570073607.4355)
,p_event_id=>wwv_flow_api.id(655281866528073605.4355)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_TEAM_DEV_FS_LIMIT'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(763672849397287394.4355)
,p_name=>'App Builder Setting Updates Prod and Sample Apps setting'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P17_ALLOW_APP_BUILDING_YN'
,p_condition_element=>'P17_ALLOW_APP_BUILDING_YN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'N'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(763673102850287396.4355)
,p_event_id=>wwv_flow_api.id(763672849397287394.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_ALLOW_PACKAGED_APP_INS_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(763673738110292514.4355)
,p_event_id=>wwv_flow_api.id(763672849397287394.4355)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_ALLOW_PACKAGED_APP_INS_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(529293549089976429.4355)
,p_name=>'Show Hide Path Prefix'
,p_event_sequence=>50
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P17_MANUAL_PATH_PREFIX'
,p_condition_element=>'P17_MANUAL_PATH_PREFIX'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(529293648787976430.4355)
,p_event_id=>wwv_flow_api.id(529293549089976429.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_PATH_PREFIX'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(529293824678976432.4355)
,p_event_id=>wwv_flow_api.id(529293549089976429.4355)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_PATH_PREFIX'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1221801671620130.4355)
,p_name=>'Hide/Show Issue File Size'
,p_event_sequence=>60
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P17_ALLOW_ISSUE_FILES_YN'
,p_condition_element=>'P17_ALLOW_ISSUE_FILES_YN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1221961000620131.4355)
,p_event_id=>wwv_flow_api.id(1221801671620130.4355)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_ISSUE_FS_LIMIT'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1222032644620132.4355)
,p_event_id=>wwv_flow_api.id(1221801671620130.4355)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P17_ISSUE_FS_LIMIT'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(113888522450058819.4355)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'override with instance settings'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS'')=''Y'' then',
'    :P17_EXPIRE_FND_USER_ACCOUNTS := ''Y'';',
'end if;',
'',
'if wwv_flow_platform.get_preference(''PLSQL_EDITING'') = ''N'' then',
'    :P17_PLSQL_EDITING := ''N'';',
'end if;',
'',
'if wwv_flow_platform.get_preference(''RESTFUL_SERVICES_ENABLED'') = ''N'' then',
'    :P17_ALLOW_RESTFUL_SERVICES_YN := ''N'';',
'end if;'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel aplicar prefer\00EAncias do espa\00E7o de trabalho.')
,p_process_when_button_id=>wwv_flow_api.id(113889631108061313.4355)
,p_process_success_message=>unistr('Prefer\00EAncias de Espa\00E7o de Trabalho aplicadas')
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(8487030576522859.4355)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Save WWV_FLOW_COMPANIES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_COMPANIES'
,p_attribute_03=>'P17_PROVISIONING_COMPANY_ID'
,p_attribute_04=>'PROVISIONING_COMPANY_ID'
,p_attribute_11=>'U'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(113889631108061313.4355)
,p_process_when=>':P17_PROVISIONING_COMPANY_ID = wwv_flow_security.g_security_group_id'
,p_process_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(317482715965499118.4355)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create team dev file table'
,p_process_sql_clob=>'wwv_flow_team_file.install(p_filesize_quota => :P17_TEAM_DEV_FS_LIMIT);'
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar a tabela APEX$TEAM_DEV_FILE')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(113889631108061313.4355)
,p_process_when=>'P17_ALLOW_TEAM_DEV_FILES_YN'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(8492310799564500.4355)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set provisioning_company_id'
,p_process_sql_clob=>':P17_PROVISIONING_COMPANY_ID := wwv_flow_security.g_security_group_id;'
,p_process_error_message=>'#SQLERRM#'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(9046701053701699.4355)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'fetch wwv_flow_companies'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_COMPANIES'
,p_attribute_03=>'P17_PROVISIONING_COMPANY_ID'
,p_attribute_04=>'PROVISIONING_COMPANY_ID'
,p_attribute_14=>'N'
);
end;
/
prompt --application/pages/page_00018
begin
wwv_flow_api.create_page(
 p_id=>18.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Altera\00E7\00F5es no Aplicativo por Dia')
,p_step_title=>unistr('Altera\00E7\00F5es no Aplicativo por Dia')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9837022786686597.4355)
,p_plug_name=>'Atividade do desenvolvedor por dia'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P18a */',
'         day, to_char(day,''Day'') day_of_week, to_char(day,''Month'') month_of_year, sum(application_changes) application_changes, count(distinct flow_user) developers,',
'100 * (sum(application_changes) / nvl(max(c.total_views),1)) pct,',
'round(100 * (sum(application_changes) / nvl(max(c.total_views),1)))  graph',
'from',
'(',
'select trunc(audit_date) day, flow_user, count(*) application_changes',
'          from wwv_flow_builder_audit_trail',
'         where security_group_id = :flow_security_group_id and',
'     audit_date >= sysdate - :P18_SINCE',
'         group by trunc(audit_date), flow_user',
'         ) x,',
'(select count(*) total_views ',
' from wwv_flow_builder_audit_trail',
' where security_group_id = :flow_security_group_id and',
'     audit_date >= sysdate - :P18_SINCE and',
'     (nvl(:P18_APPLICATION,0) = 0 or flow_id = :P18_APPLICATION)',
') c',
'group by day'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(9837112284686597.4355)
,p_name=>'Developer activity by day'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9837326990686601.4355)
,p_db_column_name=>'DAY'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Data'
,p_column_type=>'DATE'
,p_format_mask=>'&DATE_FORMAT.'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9837516879686602.4355)
,p_db_column_name=>'DEVELOPERS'
,p_display_order=>2
,p_column_identifier=>'C'
,p_column_label=>'Desenvolvedores'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9837410597686601.4355)
,p_db_column_name=>'APPLICATION_CHANGES'
,p_display_order=>3
,p_column_identifier=>'B'
,p_column_label=>unistr('Altera\00E7\00F5es do Componente')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9837607047686602.4355)
,p_db_column_name=>'PCT'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Percentual'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D00'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9837709593686602.4355)
,p_db_column_name=>'GRAPH'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('Gr\00E1fico')
,p_column_type=>'NUMBER'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_format_mask=>'PCT_GRAPH:cccccc:777777:150'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9840017550720187.4355)
,p_db_column_name=>'DAY_OF_WEEK'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Dia'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9840115860720188.4355)
,p_db_column_name=>'MONTH_OF_YEAR'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('M\00EAs')
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47680424022294433.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(201288915809201314.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(47680424022294433.4355)
,p_button_name=>'P18_SET'
,p_button_static_id=>'P18_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'APPLY_CHANGES'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(201288706805198715.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(47680424022294433.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:18,RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(22676605669426783.4355)
,p_branch_action=>'f?p=&FLOW_ID.:18:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(9845330691922599.4355)
,p_name=>'P18_SINCE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(47680424022294433.4355)
,p_item_default=>'7'
,p_prompt=>'Desde'
,p_source=>'7'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'U'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico.')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(47687424293389127.4355)
,p_name=>'P18_APPLICATION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(47680424022294433.4355)
,p_item_default=>'0'
,p_prompt=>'Aplicativo'
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AVAILABLE.APPLICATIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from wwv_flow_visible_flows f',
' order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Todos os Aplicativos -'
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Filtrar sa\00EDda do relat\00F3rio para incluir todos os aplicativos ou um aplicativo espec\00EDfico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00019
begin
wwv_flow_api.create_page(
 p_id=>19.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Detalhe da Sess\00E3o')
,p_step_title=>unistr('Detalhe da Sess\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762523503114201.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_mg_sessions.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22420117774719228.4355)
,p_plug_name=>unistr('Valores de Item de Estado de Sess\00E3o')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>54
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select session_id,',
'       item_name,',
'       item_value,',
'       session_state_status,',
'       application_id application',
'  from wwv_flow_data_view',
' where session_id        = :P19_ID',
'   and security_group_id = :FLOW_SECURITY_GROUP_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(22420231632719228.4355)
,p_name=>'Session State Item Values'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(22420407165719244.4355)
,p_db_column_name=>'SESSION_ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('Sess\00E3o')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(22420517867719244.4355)
,p_db_column_name=>'ITEM_NAME'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Nome do Item'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(22420626985719244.4355)
,p_db_column_name=>'ITEM_VALUE'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Valor do Item'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(22420714744719244.4355)
,p_db_column_name=>'SESSION_STATE_STATUS'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Status'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(22420820054719244.4355)
,p_db_column_name=>'APPLICATION'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Aplicativo'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(167635406631549268.4355)
,p_plug_name=>unistr('Atributos de Sess\00E3o')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>34
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(167911012318802431.4355)
,p_plug_name=>unistr('Views de P\00E1gina')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>44
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  l.TIME_STAMP,  ',
'        l.ELAP,  ',
'        l.FLOW_ID application,',
'        (select name from wwv_flows where id = l.flow_id) application_Name,  ',
'        l.STEP_ID page, p.name page_name,',
'        num_rows rows_processed,',
'        l.page_view_type,',
'        l.request_value,',
'        l.debug_page_view_id,',
'        l.sqlerrm',
'from    WWV_FLOW_ACTIVITY_LOG l,',
'        wwv_flow_steps p',
'where   l.security_group_id = :flow_security_group_id and',
'        p.id = l.step_id and',
'        p.flow_id = l.flow_id and l.session_id = :p19_id',
'order by l.time_stamp desc'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
,p_plug_customized=>'1'
,p_plug_customized_name=>unistr('Mostrar Relat\00F3rio de Views de P\00E1gina')
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(370270886963630406.4355)
,p_max_row_count=>'1000000'
,p_max_rows_per_page=>'15'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_owner=>'CHRISTIAN'
,p_internal_uid=>370270886963630406
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370270968790630407.4355)
,p_db_column_name=>'TIME_STAMP'
,p_display_order=>10
,p_column_identifier=>'A'
,p_column_label=>unistr('View de P\00E1gina')
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370271085137630408.4355)
,p_db_column_name=>'ELAP'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>'Decorrido'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370271113707630409.4355)
,p_db_column_name=>'APPLICATION'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>'Aplicativo'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370271243588630410.4355)
,p_db_column_name=>'APPLICATION_NAME'
,p_display_order=>40
,p_column_identifier=>'D'
,p_column_label=>'Nome do aplicativo'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370271325538630411.4355)
,p_db_column_name=>'PAGE'
,p_display_order=>50
,p_column_identifier=>'E'
,p_column_label=>unistr('P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370271444106630412.4355)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>60
,p_column_identifier=>'F'
,p_column_label=>unistr('Nome da p\00E1gina')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370271557928630413.4355)
,p_db_column_name=>'ROWS_PROCESSED'
,p_display_order=>70
,p_column_identifier=>'G'
,p_column_label=>'Linhas Processadas'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370271636847630414.4355)
,p_db_column_name=>'PAGE_VIEW_TYPE'
,p_display_order=>80
,p_column_identifier=>'H'
,p_column_label=>unistr('Tipo de Exibi\00E7\00E3o de P\00E1gina')
,p_column_type=>'NUMBER'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_column_alignment=>'RIGHT'
,p_rpt_named_lov=>wwv_flow_api.id(1569139039593351202)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370271796589630415.4355)
,p_db_column_name=>'REQUEST_VALUE'
,p_display_order=>90
,p_column_identifier=>'I'
,p_column_label=>unistr('Valor de Solicita\00E7\00E3o')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370271871497630416.4355)
,p_db_column_name=>'DEBUG_PAGE_VIEW_ID'
,p_display_order=>100
,p_column_identifier=>'J'
,p_column_label=>unistr('ID de Depura\00E7\00E3o')
,p_column_link=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:RP,24:P24_PAGE_VIEW_ID:#DEBUG_PAGE_VIEW_ID#'
,p_column_linktext=>'#DEBUG_PAGE_VIEW_ID#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370271955763630417.4355)
,p_db_column_name=>'SQLERRM'
,p_display_order=>110
,p_column_identifier=>'K'
,p_column_label=>'Mensagem de Erro'
,p_column_type=>'STRING'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(173534120886956086.4355)
,p_name=>unistr('Informa\00E7\00F5es sobre o browser')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>64
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select	 min(user_agent) user_agent',
' from	 WWV_FLOW_ACTIVITY_LOG',
'where SESSION_ID = :P19_ID and user_agent is not null'))
,p_customized=>'1'
,p_customized_name=>unistr('Informa\00E7\00F5es sobre o browser')
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(6659715068668103.4355)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('N\00E3o foram encontradas Informa\00E7\00F5es sobre o Browser.')
,p_query_num_rows_item=>'P19_ROWS'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>150000
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(173534427356956091.4355)
,p_query_column_id=>1
,p_column_alias=>'USER_AGENT'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Agente do Usu\00E1rio')
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(370270399737630401.4355)
,p_plug_name=>unistr('Seletor de Exibi\00E7\00E3o de Regi\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(40275409253350646.4355)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(370270418652630402.4355)
,p_plug_name=>unistr('Detalhe da Sess\00E3o')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noUI:a-ButtonRegion--showTitle'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(370270758542630405.4355)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>90
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>unistr('Use esta p\00E1gina para inspecionar informa\00E7\00F5es de sess\00E3o e definir detalhes de sess\00E3o.')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(370270600890630404.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(370270418652630402.4355)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:RP,7,19::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(370270504762630403.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(370270418652630402.4355)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(167636715289551739.4355)
,p_name=>'P19_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(167635406631549268.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('ID da Sess\00E3o')
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(265417466045318138.4355)
,p_name=>'P19_CREATED_ON'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(167635406631549268.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Criado'
,p_format_mask=>'SINCE'
,p_source=>'CREATED_ON'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(265417543246318139.4355)
,p_name=>'P19_USERNAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(167635406631549268.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Nome do Usu\00E1rio do Aplicativo')
,p_source=>'USERNAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(265417990532318143.4355)
,p_name=>'P19_SESSION_TIME_ZONE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(167635406631549268.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Fuso Hor\00E1rio')
,p_source=>'SESSION_TIME_ZONE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(265418061774318144.4355)
,p_name=>'P19_SESSION_LANG'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(167635406631549268.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Idioma'
,p_source=>'SESSION_LANG'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(265418121288318145.4355)
,p_name=>'P19_SESSION_TERRITORY'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(167635406631549268.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Territ\00F3rio')
,p_source=>'SESSION_TERRITORY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(265418292059318146.4355)
,p_name=>'P19_DEBUG_LEVEL'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(167635406631549268.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('N\00EDvel de Depura\00E7\00E3o')
,p_source=>'DEBUG_LEVEL'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'DEBUG_LEVEL'
,p_lov=>'.'||wwv_flow_api.id(370258657315557256.4355)||'.'
,p_lov_display_null=>'YES'
,p_lov_null_text=>'Desativado'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(265418369440318147.4355)
,p_name=>'P19_TRACE_MODE'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(167635406631549268.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Modo de Rastreamento'
,p_source=>'TRACE_MODE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'SESSION_TRACE_MODE'
,p_lov=>'.'||wwv_flow_api.id(370223717115128950.4355)||'.'
,p_lov_display_null=>'YES'
,p_lov_null_text=>'Desativado'
,p_cHeight=>1
,p_display_when=>'nvl(wwv_flow_platform.get_preference(''TRACING_ENABLED''),''Y'') = ''Y'''
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(370272835189630426.4355)
,p_name=>'P19_LIFE_TIMEOUT_ON'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(167635406631549268.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Time-out de Vida \00DAtil')
,p_format_mask=>'SINCE'
,p_source=>'LIFE_TIMEOUT_ON'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(370272953055630427.4355)
,p_name=>'P19_IDLE_TIMEOUT_ON'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(167635406631549268.4355)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Timeout Inativo'
,p_format_mask=>'SINCE'
,p_source=>'IDLE_TIMEOUT_ON'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(265418580158318149.4355)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Update Session'
,p_attribute_02=>'WWV_FLOW_SESSIONS$'
,p_attribute_03=>'P19_ID'
,p_attribute_04=>'ID'
,p_attribute_08=>'security_group_id = :FLOW_SECURITY_GROUP_ID'
,p_attribute_11=>'U'
,p_attribute_12=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(370270504762630403.4355)
,p_process_success_message=>unistr('Sess\00E3o Atualizada.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(265418480221318148.4355)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Session'
,p_attribute_02=>'WWV_FLOW_SESSIONS$'
,p_attribute_03=>'P19_ID'
,p_attribute_04=>'ID'
,p_attribute_08=>'security_group_id = :FLOW_SECURITY_GROUP_ID'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00020
begin
wwv_flow_api.create_page(
 p_id=>20.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Altera\00E7\00F5es no Aplicativo por Dia')
,p_step_title=>unistr('Altera\00E7\00F5es no Aplicativo por Dia')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47681802813307159.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47721915411670378.4355)
,p_plug_name=>unistr('monitorar atividades / views de calend\00E1rio')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(47721323591663284.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(168717528748286543.4355)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1119155357036390616.4355)
,p_plug_name=>unistr('Altera\00E7\00F5es por Desenvolvedor')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_region_attributes=>'style="width:100%;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P20a */',
'  trunc(audit_date) audit_date,',
'  lower(flow_user) || '' ('' || to_char(count(*),''FM999G999G999G999G990'') || '')'' as display_title',
'from wwv_flow_builder_audit_trail',
'where security_group_id = :flow_security_group_id and',
'   (nvl(:P20_APPLICATION,0) = 0 or flow_id = :P20_APPLICATION) and',
'   audit_date > sysdate - nvl(:P20_SINCE,45)',
'group by trunc(audit_date), flow_user',
'order by 1, 2'))
,p_plug_source_type=>'NATIVE_CSS_CALENDAR'
,p_attribute_01=>'AUDIT_DATE'
,p_attribute_03=>'DISPLAY_TITLE'
,p_attribute_07=>'N'
,p_attribute_09=>'navigation'
,p_attribute_13=>'N'
,p_attribute_17=>'Y'
,p_attribute_19=>'N'
,p_attribute_22=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(450754120469577083.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(47681802813307159.4355)
,p_button_name=>'P20_GO'
,p_button_static_id=>'P20_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(47707423582587524.4355)
,p_branch_action=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(47705414400547071.4355)
,p_name=>'P20_SINCE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(47681802813307159.4355)
,p_item_default=>'to_number(.25)'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Desde'
,p_source=>'45'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(47706119595548538.4355)
,p_name=>'P20_APPLICATION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(47681802813307159.4355)
,p_item_default=>'0'
,p_prompt=>'Aplicativo'
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AVAILABLE.APPLICATIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from wwv_flow_visible_flows f',
' order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Todos os Aplicativos -'
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Filtrar sa\00EDda do relat\00F3rio para incluir todos os aplicativos ou um aplicativo espec\00EDfico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00021
begin
wwv_flow_api.create_page(
 p_id=>21.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Gerenciar Servi\00E7o')
,p_step_title=>unistr('Gerenciar Servi\00E7o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215667724760013351)
,p_step_template=>wwv_flow_api.id(692763410753114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12518728403445471)
,p_nav_list_template_options=>'#DEFAULT#'
,p_deep_linking=>'Y'
,p_help_text=>'AEADM/aadm_mg_service.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10332709377780494.4355)
,p_plug_name=>'Gerenciar Metadados'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>80
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(47244730835700645.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(41760803829239203.4355)
,p_plug_name=>unistr('Gerenciar Servi\00E7o')
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-MediaList--noBadge:a-MediaList--cols a-MediaList--2cols'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(41758527939236654.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(692750374873071023.4355)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(42491430107461218.4355)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>60
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use a p\00E1gina Gerenciar Servi\00E7o para gerenciar solicita\00E7\00F5es de servi\00E7o, configurar prefer\00EAncias de espa\00E7o de trabalho, editar an\00FAncios, exibir relat\00F3rios, limpar arquivos de log e conte\00FAdo armazenado no cache, gerenciar metadados de espa\00E7o de traba')
||'lho.</p>',
'<p><a target="_blank" href="&SYSTEM_HELP_URL./aeadm/using-the-manage-service-page.html">Saiba Mais...</a></p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(42494607906502196.4355)
,p_name=>unistr('Esquemas do Espa\00E7o de Trabalho')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>40
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select schema',
'from   wwv_flow_company_schemas',
'where  security_group_id = :flow_security_group_id',
'order by 1'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(47025022336023416.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(42494607906502196.4355)
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(42494926575502200.4355)
,p_query_column_id=>1
,p_column_alias=>'SCHEMA'
,p_column_display_sequence=>1
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47052711371922266.4355)
,p_plug_name=>unistr('Pain\00E9is de Controle')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>70
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(46989621592546067.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(47255117001847942.4355)
,p_name=>unistr('Servi\00E7o')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>30
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'    :company workspace_name,',
'(',
'select trim(to_char(count(*),''999G999G999G999G990'')) c',
'  from wwv_flow_visible_flows f',
' where f.build_status != ''RUN_AND_HIDDEN''',
') as applications,',
'(',
'select count(*)',
'  from wwv_flows f,',
'       wwv_flow_pkg_app_map m',
' where f.id = m.installed_app_id',
'   and f.security_group_id = m.security_group_id',
'   and f.security_group_id = :flow_security_group_id',
') as pkg_applications,',
'(',
'select count(*)',
'  from wwv_flow_files f, wwv_flow_fnd_user u',
' where u.security_group_id = :flow_security_group_id',
'   and u.user_name = :APP_USER',
'   and f.file_type = ''SCRIPT''',
') as sql_scripts,',
'(',
'select count(*)',
'  from wwv_flow_ws_applications ws',
' where ws.security_group_id = :flow_security_group_id',
') as websheets,',
'(',
'select count(*)',
'  from wwv_flow_company_schemas',
' where security_group_id = :flow_security_group_id',
') as schemas,',
'--',
'(select sum(open_requests)',
'from',
'(',
'select count(*) open_requests',
'from WWV_FLOW_PROVISION_COMPANY',
'where ',
'      SECURITY_GROUP_ID = :flow_security_group_id and',
'      project_status = ''REQUESTED''',
'union all',
'select count(*) open_requests',
'from wwv_flow_provision_serice_mod m, ',
'     wwv_flow_companies c',
'where m.security_group_id = c.provisioning_company_id and',
'      c.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      m.request_status = ''REQUESTED''',
') q ) open_requests',
'from dual'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(43021310970202834.4355)
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('dados n\00E3o encontrados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47255310491847944.4355)
,p_query_column_id=>1
,p_column_alias=>'WORKSPACE_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Nome do Espa\00E7o de Trabalho')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47255925410847950.4355)
,p_query_column_id=>2
,p_column_alias=>'APPLICATIONS'
,p_column_display_sequence=>2
,p_column_heading=>'Aplicativos de Banco de Dados'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(21341410177462557.4355)
,p_query_column_id=>3
,p_column_alias=>'PKG_APPLICATIONS'
,p_column_display_sequence=>4
,p_column_heading=>'Aplicativos Empacotados'
,p_use_as_row_header=>'N'
,p_report_column_required_role=>wwv_flow_api.id(21341101987393942)
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47463231074646060.4355)
,p_query_column_id=>4
,p_column_alias=>'SQL_SCRIPTS'
,p_column_display_sequence=>5
,p_column_heading=>'Scripts SQL'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47462810726621215.4355)
,p_query_column_id=>5
,p_column_alias=>'WEBSHEETS'
,p_column_display_sequence=>3
,p_column_heading=>'Aplicativos de Websheet'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47463017568642176.4355)
,p_query_column_id=>6
,p_column_alias=>'SCHEMAS'
,p_column_display_sequence=>6
,p_column_heading=>'Esquemas'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47470904838902402.4355)
,p_query_column_id=>7
,p_column_alias=>'OPEN_REQUESTS'
,p_column_display_sequence=>7
,p_column_heading=>unistr('Solicita\00E7\00F5es Abertas')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(47470232749892527.4355)
,p_name=>unistr('Solicita\00E7\00F5es de Servi\00E7o Recentes')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>50
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    wwv_flow_lang.system_message(''WORKSPACE_REQUEST'') ||'' - ''|| wwv_flow_item.text_from_lov(project_status,''REQUEST_STATUSES'') || '' - '' ||',
'    DATABASE_SIZE||''MB'' the_request,',
'    request_date',
'from WWV_FLOW_PROVISION_COMPANY',
'where ',
'      SECURITY_GROUP_ID = :flow_security_group_id',
'union all',
'select wwv_flow_lang.system_message(''CHANGE_REQUEST'')||'' ''||m.service_name ||'' - ''||wwv_flow_item.text_from_lov(m.request_status,''REQUEST_STATUSES'')||'' - ''||',
'       m.service_attribute_1 the_request,',
'       m.requested_on',
'from wwv_flow_provision_serice_mod m, ',
'     wwv_flow_companies c',
'where m.security_group_id = c.provisioning_company_id and',
'      c.PROVISIONING_COMPANY_ID = :flow_security_group_id',
'order by 2 desc '))
,p_display_when_condition=>'not wwv_flow_global.g_cloud'
,p_display_condition_type=>'PLSQL_EXPRESSION'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46765105410141325.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47470426188892527.4355)
,p_query_column_id=>1
,p_column_alias=>'THE_REQUEST'
,p_column_display_sequence=>1
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47470505834892527.4355)
,p_query_column_id=>2
,p_column_alias=>'REQUEST_DATE'
,p_column_display_sequence=>2
,p_column_format=>'SINCE'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(168449430106381735.4355)
,p_computation_sequence=>10
,p_computation_item=>'LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'21'
,p_compute_when_type=>'%null%'
);
end;
/
prompt --application/pages/page_00022
begin
wwv_flow_api.create_page(
 p_id=>22.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>'Monitorar Atividade'
,p_step_title=>'Monitorar Atividade'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692763410753114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(868317340432334.4355)
,p_plug_name=>unistr('Views de P\00E1gina')
,p_icon_css_classes=>'icon-util-page-views'
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--paddedBody:h320'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1029955071738136284.4355)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(61339238287578026.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_plug_column_width=>'apex-col--rightBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(882110638496600.4355)
,p_plug_name=>unistr('An\00E1lise da View de P\00E1gina')
,p_icon_css_classes=>'icon-database-object'
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--paddedBody:h240'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1029955071738136284.4355)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(882616872498402.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_plug_column_width=>'apex-col--rightBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9786901912561394.4355)
,p_plug_name=>'Erros do Aplicativo'
,p_icon_css_classes=>'icon-util-bugs'
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--paddedBody:h240'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1029955071738136284.4355)
,p_plug_display_sequence=>90
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(9787313686564805.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_plug_column_width=>'apex-col--rightBorder apex-col--bottomBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22852102269006022.4355)
,p_plug_name=>'Atividade do Desenvolvedor'
,p_icon_css_classes=>'icon-util-developer-activity'
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--paddedBody:h320'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1029955071738136284.4355)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(22853420277011168.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_plug_column_width=>'apex-col--rightBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(26365204158918140.4355)
,p_plug_name=>'Tentativas de Log-in'
,p_icon_css_classes=>'icon-util-login-attempts'
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--paddedBody:h240'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1029955071738136284.4355)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(26405214790138770.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(46999427470822221.4355)
,p_plug_name=>unistr('Pain\00E9is de Controle')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>120
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(46989621592546067.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(38499417503989888.4355)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(56636630435030858.4355)
,p_plug_name=>'Ambiente'
,p_icon_css_classes=>'icon-util-attribute-dictionary'
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--paddedBody:h240'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1029955071738136284.4355)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(56633624548029155.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_plug_column_width=>'apex-col--rightBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(162250516888792819.4355)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(167618427091432137.4355)
,p_plug_name=>unistr('Sess\00F5es')
,p_icon_css_classes=>'icon-util-recent-sessions'
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--paddedBody:h320'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1029955071738136284.4355)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(167617332155424156.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168441310760704445.4355)
,p_plug_name=>unistr('Esquema e outros Relat\00F3rios do Espa\00E7o de Trabalho')
,p_icon_css_classes=>'icon-util-attribute-dictionary'
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--paddedBody:h240'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1029955071738136284.4355)
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(4869427763068324.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--bottomBorder apex-col--rightBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466730619047324921.4355)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta p\00E1gina cont\00E9m links para relat\00F3rios e gr\00E1ficos que permitem a voc\00EA monitorar a atividade do usu\00E1rio e do desenvolvedor.</p>'),
'<p><a target="_blank" href="&SYSTEM_HELP_URL./aeadm/monitoring-activity-within-a-workspace.html">Saiba Mais...</a></p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1042393970073998159.4355)
,p_plug_name=>unistr('Relat\00F3rios de Atividades Arquivados')
,p_icon_css_classes=>'icon-database-object'
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--paddedBody:h240'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1029955071738136284.4355)
,p_plug_display_sequence=>130
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(162256322822822923.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(829471944455703874.4355)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--bottomBorder'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(167828924727656009.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(162250516888792819.4355)
,p_button_name=>'VIEW_DASHBOARD'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Exibir Painel de Controle'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(47753609495141634.4355)
,p_branch_action=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
end;
/
prompt --application/pages/page_00023
begin
wwv_flow_api.create_page(
 p_id=>23.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor por Hora')
,p_step_title=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor por Hora')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1766905126878061686.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1770620027781703754.4355)
,p_plug_name=>unistr('Altera\00E7\00F5es no Aplicativo por Desenvolvedor por Hora')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with total_page_views as',
'(',
'select /* APEX4350P23a */ count(*) tpv',
'from   ',
'  wwv_flow_builder_audit_trail',
'where  ',
'  audit_date > sysdate - nvl(:p23_time,1) and ',
'  security_group_id = :flow_security_group_id and',
'  (:P23_APPLICATION = 0 or flow_id = :P23_APPLICATION)',
')',
'select the_date,',
'       developer, ',
'       page_views,',
'pages_visited,',
'distinct_applications,',
'''<div class="hour-graph">''||',
'''<span title="''||m.hour_label||''  0, ''||m.message_label||'' ''||ltrim(to_char(h00,''999G999G999''))||''" class="hour''|| case when h00 = 0 then '' is-null'' when h00 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 0</span> <span class="hour-value"'
||'>''|| case when h00 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h00/1000),''99999999D0'')) else to_char(h00) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  1, ''||m.message_label||'' ''||ltrim(to_char(h01,''999G999G999''))||''" class="hour''|| case when h01 = 0 then '' is-null'' when h01 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 1</span> <span class="hour-value"'
||'>''|| case when h01 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h01/1000),''99999999D0'')) else to_char(h01) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  2, ''||m.message_label||'' ''||ltrim(to_char(h02,''999G999G999''))||''" class="hour''|| case when h02 = 0 then '' is-null'' when h02 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 2</span> <span class="hour-value"'
||'>''|| case when h02 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h02/1000),''99999999D0'')) else to_char(h02) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  3, ''||m.message_label||'' ''||ltrim(to_char(h03,''999G999G999''))||''" class="hour''|| case when h03 = 0 then '' is-null'' when h03 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 3</span> <span class="hour-value"'
||'>''|| case when h03 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h03/1000),''99999999D0'')) else to_char(h03) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  4, ''||m.message_label||'' ''||ltrim(to_char(h04,''999G999G999''))||''" class="hour''|| case when h04 = 0 then '' is-null'' when h04 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 4</span> <span class="hour-value"'
||'>''|| case when h04 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h04/1000),''99999999D0'')) else to_char(h04) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  5, ''||m.message_label||'' ''||ltrim(to_char(h05,''999G999G999''))||''" class="hour''|| case when h05 = 0 then '' is-null'' when h05 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 5</span> <span class="hour-value"'
||'>''|| case when h05 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h05/1000),''99999999D0'')) else to_char(h05) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  6, ''||m.message_label||'' ''||ltrim(to_char(h06,''999G999G999''))||''" class="hour''|| case when h06 = 0 then '' is-null'' when h06 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 6</span> <span class="hour-value"'
||'>''|| case when h06 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h06/1000),''99999999D0'')) else to_char(h06) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  7, ''||m.message_label||'' ''||ltrim(to_char(h07,''999G999G999''))||''" class="hour''|| case when h07 = 0 then '' is-null'' when h07 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 7</span> <span class="hour-value"'
||'>''|| case when h07 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h07/1000),''99999999D0'')) else to_char(h07) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  8, ''||m.message_label||'' ''||ltrim(to_char(h08,''999G999G999''))||''" class="hour''|| case when h08 = 0 then '' is-null'' when h08 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 8</span> <span class="hour-value"'
||'>''|| case when h08 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h08/1000),''99999999D0'')) else to_char(h08) end ||''</span></span>''||',
'''<span title="''||m.hour_label||''  9, ''||m.message_label||'' ''||ltrim(to_char(h09,''999G999G999''))||''" class="hour''|| case when h09 = 0 then '' is-null'' when h09 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 9</span> <span class="hour-value"'
||'>''|| case when h09 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h09/1000),''99999999D0'')) else to_char(h09) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 10, ''||m.message_label||'' ''||ltrim(to_char(h10,''999G999G999''))||''" class="hour''|| case when h10 = 0 then '' is-null'' when h10 > 999 then '' is-over1k'' end ||''"><span class="hour-label">10</span> <span class="hour-value"'
||'>''|| case when h10 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h10/1000),''99999999D0'')) else to_char(h10) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 11, ''||m.message_label||'' ''||ltrim(to_char(h11,''999G999G999''))||''" class="hour''|| case when h11 = 0 then '' is-null'' when h11 > 999 then '' is-over1k'' end ||''"><span class="hour-label">11</span> <span class="hour-value"'
||'>''|| case when h11 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h11/1000),''99999999D0'')) else to_char(h11) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 12, ''||m.message_label||'' ''||ltrim(to_char(h12,''999G999G999''))||''" class="hour''|| case when h12 = 0 then '' is-null'' when h12 > 999 then '' is-over1k'' end ||''"><span class="hour-label">12</span> <span class="hour-value"'
||'>''|| case when h12 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h12/1000),''99999999D0'')) else to_char(h12) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 13, ''||m.message_label||'' ''||ltrim(to_char(h13,''999G999G999''))||''" class="hour''|| case when h13 = 0 then '' is-null'' when h13 > 999 then '' is-over1k'' end ||''"><span class="hour-label">13</span> <span class="hour-value"'
||'>''|| case when h13 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h13/1000),''99999999D0'')) else to_char(h13) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 14, ''||m.message_label||'' ''||ltrim(to_char(h14,''999G999G999''))||''" class="hour''|| case when h14 = 0 then '' is-null'' when h14 > 999 then '' is-over1k'' end ||''"><span class="hour-label">14</span> <span class="hour-value"'
||'>''|| case when h14 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h14/1000),''99999999D0'')) else to_char(h14) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 15, ''||m.message_label||'' ''||ltrim(to_char(h15,''999G999G999''))||''" class="hour''|| case when h15 = 0 then '' is-null'' when h15 > 999 then '' is-over1k'' end ||''"><span class="hour-label">15</span> <span class="hour-value"'
||'>''|| case when h15 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h15/1000),''99999999D0'')) else to_char(h15) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 16, ''||m.message_label||'' ''||ltrim(to_char(h16,''999G999G999''))||''" class="hour''|| case when h16 = 0 then '' is-null'' when h16 > 999 then '' is-over1k'' end ||''"><span class="hour-label">16</span> <span class="hour-value"'
||'>''|| case when h16 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h16/1000),''99999999D0'')) else to_char(h16) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 17, ''||m.message_label||'' ''||ltrim(to_char(h17,''999G999G999''))||''" class="hour''|| case when h17 = 0 then '' is-null'' when h17 > 999 then '' is-over1k'' end ||''"><span class="hour-label">17</span> <span class="hour-value"'
||'>''|| case when h17 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h17/1000),''99999999D0'')) else to_char(h17) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 18, ''||m.message_label||'' ''||ltrim(to_char(h18,''999G999G999''))||''" class="hour''|| case when h18 = 0 then '' is-null'' when h18 > 999 then '' is-over1k'' end ||''"><span class="hour-label">18</span> <span class="hour-value"'
||'>''|| case when h18 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h18/1000),''99999999D0'')) else to_char(h18) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 19, ''||m.message_label||'' ''||ltrim(to_char(h19,''999G999G999''))||''" class="hour''|| case when h19 = 0 then '' is-null'' when h19 > 999 then '' is-over1k'' end ||''"><span class="hour-label">19</span> <span class="hour-value"'
||'>''|| case when h19 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h19/1000),''99999999D0'')) else to_char(h19) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 20, ''||m.message_label||'' ''||ltrim(to_char(h20,''999G999G999''))||''" class="hour''|| case when h20 = 0 then '' is-null'' when h20 > 999 then '' is-over1k'' end ||''"><span class="hour-label">20</span> <span class="hour-value"'
||'>''|| case when h20 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h20/1000),''99999999D0'')) else to_char(h20) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 21, ''||m.message_label||'' ''||ltrim(to_char(h21,''999G999G999''))||''" class="hour''|| case when h21 = 0 then '' is-null'' when h21 > 999 then '' is-over1k'' end ||''"><span class="hour-label">21</span> <span class="hour-value"'
||'>''|| case when h21 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h21/1000),''99999999D0'')) else to_char(h21) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 22, ''||m.message_label||'' ''||ltrim(to_char(h22,''999G999G999''))||''" class="hour''|| case when h22 = 0 then '' is-null'' when h22 > 999 then '' is-over1k'' end ||''"><span class="hour-label">22</span> <span class="hour-value"'
||'>''|| case when h22 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h22/1000),''99999999D0'')) else to_char(h22) end ||''</span></span>''||',
'''<span title="''||m.hour_label||'' 23, ''||m.message_label||'' ''||ltrim(to_char(h23,''999G999G999''))||''" class="hour''|| case when h23 = 0 then '' is-null'' when h23 > 999 then '' is-over1k'' end ||''"><span class="hour-label">23</span> <span class="hour-value"'
||'>''|| case when h23 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h23/1000),''99999999D0'')) else to_char(h23) end ||''</span></span>''||',
'''</div>'' hours',
'from',
'(',
'select ',
'    trunc(audit_date) the_date,',
'  flow_user developer,',
'  count(*) page_views,',
'  count(distinct(page_id)) pages_visited,',
'  count(distinct(flow_id)) distinct_applications,',
'  sum(decode(to_char(audit_date,''HH24''),0,1,0)) h00,',
'  sum(decode(to_char(audit_date,''HH24''),1,1,0)) h01,',
'  sum(decode(to_char(audit_date,''HH24''),2,1,0)) h02,',
'  sum(decode(to_char(audit_date,''HH24''),3,1,0)) h03,',
'  sum(decode(to_char(audit_date,''HH24''),4,1,0)) h04,',
'  sum(decode(to_char(audit_date,''HH24''),5,1,0)) h05,',
'  sum(decode(to_char(audit_date,''HH24''),6,1,0)) h06,',
'  sum(decode(to_char(audit_date,''HH24''),7,1,0)) h07,',
'  sum(decode(to_char(audit_date,''HH24''),8,1,0)) h08,',
'  sum(decode(to_char(audit_date,''HH24''),9,1,0)) h09,',
'  sum(decode(to_char(audit_date,''HH24''),10,1,0)) h10,',
'  sum(decode(to_char(audit_date,''HH24''),11,1,0)) h11,',
'  sum(decode(to_char(audit_date,''HH24''),12,1,0)) h12,',
'  sum(decode(to_char(audit_date,''HH24''),13,1,0)) h13,',
'  sum(decode(to_char(audit_date,''HH24''),14,1,0)) h14,',
'  sum(decode(to_char(audit_date,''HH24''),15,1,0)) h15,',
'  sum(decode(to_char(audit_date,''HH24''),16,1,0)) h16,',
'  sum(decode(to_char(audit_date,''HH24''),17,1,0)) h17,',
'  sum(decode(to_char(audit_date,''HH24''),18,1,0)) h18,',
'  sum(decode(to_char(audit_date,''HH24''),19,1,0)) h19,',
'  sum(decode(to_char(audit_date,''HH24''),20,1,0)) h20,',
'  sum(decode(to_char(audit_date,''HH24''),21,1,0)) h21,',
'  sum(decode(to_char(audit_date,''HH24''),22,1,0)) h22,',
'  sum(decode(to_char(audit_date,''HH24''),23,1,0)) h23',
'from   ',
'  wwv_flow_builder_audit_trail',
'where  ',
'  audit_date > sysdate - nvl(:p23_time,1) and ',
'  security_group_id = :flow_security_group_id and',
'  (:P23_APPLICATION = 0 or flow_id = :P23_APPLICATION)',
'group by ',
'  flow_user, trunc(audit_date)',
') d, ',
'  total_page_views,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.HOUR'') hour_label from dual) m,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.APPCHANGES'') message_label from dual) m,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.K'',''~'') activity_by_hour_message_k from dual ) m',
'  '))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1770620126131703754.4355)
,p_name=>'Application Changes by Developer'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1770620126131703754
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(756684373254357823.4355)
,p_db_column_name=>'THE_DATE'
,p_display_order=>10
,p_column_identifier=>'I'
,p_column_label=>'Dia'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1760793840281373040.4355)
,p_db_column_name=>'DEVELOPER'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>'Desenvolvedor'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1760794295093373041.4355)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>unistr('Altera\00E7\00F5es do Componente')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1760795409411373043.4355)
,p_db_column_name=>'PAGES_VISITED'
,p_display_order=>40
,p_column_identifier=>'F'
,p_column_label=>unistr('P\00E1ginas Distintas')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1760795833804373043.4355)
,p_db_column_name=>'DISTINCT_APPLICATIONS'
,p_display_order=>50
,p_column_identifier=>'G'
,p_column_label=>'Aplicativos Distintos'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1760796276224373044.4355)
,p_db_column_name=>'HOURS'
,p_display_order=>60
,p_column_identifier=>'H'
,p_column_label=>'Atividade por hora'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1760790628228372995.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1766905126878061686.4355)
,p_button_name=>'P23_SET'
,p_button_static_id=>'P8_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--padRight'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'Set'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1760791063081373001.4355)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(1766905126878061686.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:8,RIR::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1760797413294373078.4355)
,p_branch_action=>'f?p=&FLOW_ID.:23:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1760791473437373006.4355)
,p_name=>'P23_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1766905126878061686.4355)
,p_item_default=>'to_number(.25)'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Desde'
,p_source=>'to_number(.25)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cSize=>30
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico.')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1760792302886373021.4355)
,p_name=>'P23_APPLICATION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1766905126878061686.4355)
,p_item_default=>'0'
,p_prompt=>'Aplicativo'
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AVAILABLE.APPLICATIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from wwv_flow_visible_flows f',
' order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Todos os Aplicativos -'
,p_lov_null_value=>'0'
,p_cSize=>30
,p_cHeight=>1
,p_tag_attributes=>'style="max-width:200px"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Filtrar sa\00EDda do relat\00F3rio para incluir todos os aplicativos ou um aplicativo espec\00EDfico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00024
begin
wwv_flow_api.create_page(
 p_id=>24.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Mensagens de Depura\00E7\00E3o')
,p_step_title=>unistr('Mensagens de Depura\00E7\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-IRR-table td {',
'    padding: 4px 8px;',
'}',
'.a-IRR-table td[headers=pct] {',
'    max-width: 120px;',
'}',
'.a-IRR-table td[headers=message] {',
'    max-width: 600px;',
'    overflow-x: auto;',
'}',
'pre {',
'    font-size: 11px;',
'    line-height: 14px;',
'    margin: 0;',
'}',
'.l1, .l2 {',
'    font-weight: bold;',
'    color: red;',
'}',
'.l3 {',
'    font-weight: bold;',
'}'))
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(370273743162630435.4355)
,p_plug_name=>unistr('Mensagens de Depura\00E7\00E3o para o ID de View de P\00E1gina ID &P24_PAGE_VIEW_ID.')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>14
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(370331955215891191.4355)
,p_plug_name=>unistr('Mensagens de Depura\00E7\00E3o')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>24
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select elapsed_seconds,',
'       execution_time,',
'       message,',
'       message_level,',
'       percent_of_max,',
'       call_stack,',
'       session_id,',
'       flow_id,',
'       page_id,',
'       apex_user',
'  from wwv_flow_debug_messages_v',
' where page_view_id      = :P24_PAGE_VIEW_ID',
'   and security_group_id = :FLOW_SECURITY_GROUP_ID',
' order by id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_footer=>unistr('<p>As colunas do tempo decorrido s\00E3o registradas em segundos.</p>')
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(370332345019891192.4355)
,p_name=>'Recent Page Views'
,p_max_row_count=>'100000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_download_filename=>'pagelog'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>370332345019891192
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370334083525891194.4355)
,p_db_column_name=>'FLOW_ID'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Aplicativo'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370334833824891195.4355)
,p_db_column_name=>'SESSION_ID'
,p_display_order=>8
,p_column_identifier=>'G'
,p_column_label=>unistr('Sess\00E3o')
,p_column_link=>'f?p=&FLOW_ID.:19:&SESSION.::&DEBUG.:RP,:P19_ID:#SESSION_ID#'
,p_column_linktext=>'#SESSION_ID#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370272278628630420.4355)
,p_db_column_name=>'MESSAGE_LEVEL'
,p_display_order=>38
,p_column_identifier=>'AG'
,p_column_label=>unistr('N\00EDvel')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370272332017630421.4355)
,p_db_column_name=>'MESSAGE'
,p_display_order=>48
,p_column_identifier=>'AH'
,p_column_label=>'Mensagem'
,p_column_html_expression=>'<pre class="l#MESSAGE_LEVEL#">#MESSAGE#</pre>'
,p_column_type=>'STRING'
,p_static_id=>'message'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370272477626630422.4355)
,p_db_column_name=>'CALL_STACK'
,p_display_order=>58
,p_column_identifier=>'AI'
,p_column_label=>'Pilha de Chamada'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370272585833630423.4355)
,p_db_column_name=>'PAGE_ID'
,p_display_order=>68
,p_column_identifier=>'AJ'
,p_column_label=>unistr('P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370273362565630431.4355)
,p_db_column_name=>'ELAPSED_SECONDS'
,p_display_order=>78
,p_column_identifier=>'AL'
,p_column_label=>'Decorrido'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G990D99999'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370273442678630432.4355)
,p_db_column_name=>'EXECUTION_TIME'
,p_display_order=>88
,p_column_identifier=>'AM'
,p_column_label=>unistr('Execu\00E7\00E3o')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G990D99999'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370273549836630433.4355)
,p_db_column_name=>'PERCENT_OF_MAX'
,p_display_order=>98
,p_column_identifier=>'AN'
,p_column_label=>unistr('Gr\00E1fico')
,p_column_type=>'NUMBER'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'PCT_GRAPH:::'
,p_static_id=>'pct'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(370273643623630434.4355)
,p_db_column_name=>'APEX_USER'
,p_display_order=>108
,p_column_identifier=>'AO'
,p_column_label=>unistr('Usu\00E1rio')
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(370347559432891227.4355)
,p_branch_action=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(370272753381630425.4355)
,p_name=>'P24_PAGE_VIEW_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(370331955215891191.4355)
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'S'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(370274575345630443.4355)
,p_name=>'P24_APPLICATION'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(370273743162630435.4355)
,p_prompt=>'Aplicativo'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(370274696671630444.4355)
,p_name=>'P24_PAGE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(370273743162630435.4355)
,p_prompt=>unistr('P\00E1gina')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(370274705241630445.4355)
,p_name=>'P24_SESSION'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(370273743162630435.4355)
,p_prompt=>unistr('Sess\00E3o')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(370274820535630446.4355)
,p_name=>'P24_USER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(370273743162630435.4355)
,p_prompt=>unistr('Usu\00E1rio')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(370274976895630447.4355)
,p_name=>'P24_START_TIMESTAMP'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(370273743162630435.4355)
,p_prompt=>'Iniciado'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(370275085933630448.4355)
,p_name=>'P24_ELAPSED'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(370273743162630435.4355)
,p_prompt=>'Decorrido'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(370346386219891224.4355)
,p_validation_name=>'flows is numeric'
,p_validation_sequence=>10
,p_validation=>'P24_FLOW'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('O valor deve ser num\00E9rico.')
,p_associated_item=>wwv_flow_api.id(.4355)
,p_error_display_location=>'INLINE_WITH_FIELD'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(370346714321891226.4355)
,p_validation_name=>'page is numeric'
,p_validation_sequence=>20
,p_validation=>'P24_PAGE'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('O valor deve ser num\00E9rico.')
,p_associated_item=>wwv_flow_api.id(.4355)
,p_error_display_location=>'INLINE_WITH_FIELD'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(370347056258891226.4355)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_RESET_PAGINATION'
,p_process_name=>'reset pagination'
,p_attribute_01=>'THIS_PAGE'
,p_process_when=>'GO'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(370274433756630442.4355)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fetch page view info'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select min(flow_id)||case when min(flow_id) <> max(flow_id) then ''->''||max(flow_id) end application,',
'       min(page_id)||case when min(page_id) <> max(page_id) then ''->''||max(page_id) end page,',
'       min(session_id)||case when min(session_id) <> max(session_id) then ''->''||max(session_id) end session_id,',
'       min(apex_user)||case when min(apex_user) <> max(apex_user) then ''->''||max(apex_user) end apex_user,',
'       htmldb_util.get_since_tswtz(min(message_timestamp)) start_timestamp,',
'       to_char(max(elapsed_seconds), ''999G990D9999'') elapsed_seconds',
'  into :P24_APPLICATION,',
'       :P24_PAGE,',
'       :P24_SESSION,',
'       :P24_USER,',
'       :P24_START_TIMESTAMP,',
'       :P24_ELAPSED',
'  from wwv_flow_debug_messages_v',
' where page_view_id      = :P24_PAGE_VIEW_ID',
'   and security_group_id = :WORKSPACE_ID;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00025
begin
wwv_flow_api.create_page(
 p_id=>25.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Views de P\00E1gina por Usu\00E1rio')
,p_step_title=>unistr('Views de P\00E1gina por Usu\00E1rio')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5180512459865310.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9307603421462905.4355)
,p_plug_name=>unistr('Views de P\00E1gina por Usu\00E1rio')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with total_views as',
'(select /* APEX4350P25a */ count(*) tpv ',
'from  WWV_FLOW_ACTIVITY_LOG',
'where time_stamp >= sysdate - :P25_DATE',
'and   security_group_id = :flow_security_group_id)',
'select developer, ',
'       page_views, ',
'       page_events,',
'       page_processing,',
'       100* page_events/tpv pct,',
'       round(100* page_events/tpv) graph , ',
'       report_rows, ',
'       CONTENT_LENGTH,',
'       pages distinct_pages,',
'       applications,elapsed_time,',
'       distinct_hours,',
'       distinct_days, ',
'       last_view, ',
'       first_view, ',
'       nvl(cached_pages,0) cached_pages, ',
'       nvl(cached_regions,0) cached_regions, ',
'       average_elapsed_time, partial_page_views,',
'      ''<div class="hour-graph">''||',
'      ''<span title="''||m.hour_label||''  0, ''||m.message_label||'' ''||ltrim(to_char(h00,''999G999G999''))||''" class="hour''|| case when h00 = 0 then '' is-null'' when h00 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 0</span> <span class="hour-'
||'value">''|| case when h00 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h00/1000),''99999999D0'')) else to_char(h00) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  1, ''||m.message_label||'' ''||ltrim(to_char(h01,''999G999G999''))||''" class="hour''|| case when h01 = 0 then '' is-null'' when h01 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 1</span> <span class="hour-'
||'value">''|| case when h01 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h01/1000),''99999999D0'')) else to_char(h01) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  2, ''||m.message_label||'' ''||ltrim(to_char(h02,''999G999G999''))||''" class="hour''|| case when h02 = 0 then '' is-null'' when h02 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 2</span> <span class="hour-'
||'value">''|| case when h02 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h02/1000),''99999999D0'')) else to_char(h02) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  3, ''||m.message_label||'' ''||ltrim(to_char(h03,''999G999G999''))||''" class="hour''|| case when h03 = 0 then '' is-null'' when h03 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 3</span> <span class="hour-'
||'value">''|| case when h03 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h03/1000),''99999999D0'')) else to_char(h03) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  4, ''||m.message_label||'' ''||ltrim(to_char(h04,''999G999G999''))||''" class="hour''|| case when h04 = 0 then '' is-null'' when h04 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 4</span> <span class="hour-'
||'value">''|| case when h04 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h04/1000),''99999999D0'')) else to_char(h04) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  5, ''||m.message_label||'' ''||ltrim(to_char(h05,''999G999G999''))||''" class="hour''|| case when h05 = 0 then '' is-null'' when h05 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 5</span> <span class="hour-'
||'value">''|| case when h05 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h05/1000),''99999999D0'')) else to_char(h05) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  6, ''||m.message_label||'' ''||ltrim(to_char(h06,''999G999G999''))||''" class="hour''|| case when h06 = 0 then '' is-null'' when h06 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 6</span> <span class="hour-'
||'value">''|| case when h06 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h06/1000),''99999999D0'')) else to_char(h06) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  7, ''||m.message_label||'' ''||ltrim(to_char(h07,''999G999G999''))||''" class="hour''|| case when h07 = 0 then '' is-null'' when h07 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 7</span> <span class="hour-'
||'value">''|| case when h07 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h07/1000),''99999999D0'')) else to_char(h07) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  8, ''||m.message_label||'' ''||ltrim(to_char(h08,''999G999G999''))||''" class="hour''|| case when h08 = 0 then '' is-null'' when h08 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 8</span> <span class="hour-'
||'value">''|| case when h08 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h08/1000),''99999999D0'')) else to_char(h08) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  9, ''||m.message_label||'' ''||ltrim(to_char(h09,''999G999G999''))||''" class="hour''|| case when h09 = 0 then '' is-null'' when h09 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 9</span> <span class="hour-'
||'value">''|| case when h09 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h09/1000),''99999999D0'')) else to_char(h09) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 10, ''||m.message_label||'' ''||ltrim(to_char(h10,''999G999G999''))||''" class="hour''|| case when h10 = 0 then '' is-null'' when h10 > 999 then '' is-over1k'' end ||''"><span class="hour-label">10</span> <span class="hour-'
||'value">''|| case when h10 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h10/1000),''99999999D0'')) else to_char(h10) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 11, ''||m.message_label||'' ''||ltrim(to_char(h11,''999G999G999''))||''" class="hour''|| case when h11 = 0 then '' is-null'' when h11 > 999 then '' is-over1k'' end ||''"><span class="hour-label">11</span> <span class="hour-'
||'value">''|| case when h11 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h11/1000),''99999999D0'')) else to_char(h11) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 12, ''||m.message_label||'' ''||ltrim(to_char(h12,''999G999G999''))||''" class="hour''|| case when h12 = 0 then '' is-null'' when h12 > 999 then '' is-over1k'' end ||''"><span class="hour-label">12</span> <span class="hour-'
||'value">''|| case when h12 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h12/1000),''99999999D0'')) else to_char(h12) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 13, ''||m.message_label||'' ''||ltrim(to_char(h13,''999G999G999''))||''" class="hour''|| case when h13 = 0 then '' is-null'' when h13 > 999 then '' is-over1k'' end ||''"><span class="hour-label">13</span> <span class="hour-'
||'value">''|| case when h13 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h13/1000),''99999999D0'')) else to_char(h13) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 14, ''||m.message_label||'' ''||ltrim(to_char(h14,''999G999G999''))||''" class="hour''|| case when h14 = 0 then '' is-null'' when h14 > 999 then '' is-over1k'' end ||''"><span class="hour-label">14</span> <span class="hour-'
||'value">''|| case when h14 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h14/1000),''99999999D0'')) else to_char(h14) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 15, ''||m.message_label||'' ''||ltrim(to_char(h15,''999G999G999''))||''" class="hour''|| case when h15 = 0 then '' is-null'' when h15 > 999 then '' is-over1k'' end ||''"><span class="hour-label">15</span> <span class="hour-'
||'value">''|| case when h15 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h15/1000),''99999999D0'')) else to_char(h15) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 16, ''||m.message_label||'' ''||ltrim(to_char(h16,''999G999G999''))||''" class="hour''|| case when h16 = 0 then '' is-null'' when h16 > 999 then '' is-over1k'' end ||''"><span class="hour-label">16</span> <span class="hour-'
||'value">''|| case when h16 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h16/1000),''99999999D0'')) else to_char(h16) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 17, ''||m.message_label||'' ''||ltrim(to_char(h17,''999G999G999''))||''" class="hour''|| case when h17 = 0 then '' is-null'' when h17 > 999 then '' is-over1k'' end ||''"><span class="hour-label">17</span> <span class="hour-'
||'value">''|| case when h17 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h17/1000),''99999999D0'')) else to_char(h17) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 18, ''||m.message_label||'' ''||ltrim(to_char(h18,''999G999G999''))||''" class="hour''|| case when h18 = 0 then '' is-null'' when h18 > 999 then '' is-over1k'' end ||''"><span class="hour-label">18</span> <span class="hour-'
||'value">''|| case when h18 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h18/1000),''99999999D0'')) else to_char(h18) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 19, ''||m.message_label||'' ''||ltrim(to_char(h19,''999G999G999''))||''" class="hour''|| case when h19 = 0 then '' is-null'' when h19 > 999 then '' is-over1k'' end ||''"><span class="hour-label">19</span> <span class="hour-'
||'value">''|| case when h19 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h19/1000),''99999999D0'')) else to_char(h19) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 20, ''||m.message_label||'' ''||ltrim(to_char(h20,''999G999G999''))||''" class="hour''|| case when h20 = 0 then '' is-null'' when h20 > 999 then '' is-over1k'' end ||''"><span class="hour-label">20</span> <span class="hour-'
||'value">''|| case when h20 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h20/1000),''99999999D0'')) else to_char(h20) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 21, ''||m.message_label||'' ''||ltrim(to_char(h21,''999G999G999''))||''" class="hour''|| case when h21 = 0 then '' is-null'' when h21 > 999 then '' is-over1k'' end ||''"><span class="hour-label">21</span> <span class="hour-'
||'value">''|| case when h21 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h21/1000),''99999999D0'')) else to_char(h21) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 22, ''||m.message_label||'' ''||ltrim(to_char(h22,''999G999G999''))||''" class="hour''|| case when h22 = 0 then '' is-null'' when h22 > 999 then '' is-over1k'' end ||''"><span class="hour-label">22</span> <span class="hour-'
||'value">''|| case when h22 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h22/1000),''99999999D0'')) else to_char(h22) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 23, ''||m.message_label||'' ''||ltrim(to_char(h23,''999G999G999''))||''" class="hour''|| case when h23 = 0 then '' is-null'' when h23 > 999 then '' is-over1k'' end ||''"><span class="hour-label">23</span> <span class="hour-'
||'value">''|| case when h23 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h23/1000),''99999999D0'')) else to_char(h23) end ||''</span></span>''||',
'      ''</div>'' hours',
'from',
'(',
'select upper(USERID) developer, ',
'       count(*) page_events,',
'       sum(decode(page_mode,''A'',0,1)) page_views,',
'       sum(decode(page_mode,''A'',1,0)) page_processing,',
'       sum(num_rows) report_rows,',
'       count(distinct(flow_id||''.''||step_id)) pages,',
'       count(distinct(flow_id)) applications,',
'      sum(elap) elapsed_time,',
'      avg(elap) average_elapsed_time,',
'      count(distinct to_char(time_stamp,''YYYY.MM.DD.HH24'')) distinct_hours,',
'      count(distinct to_char(time_stamp,''YYYY.MM.DD'')) distinct_days,',
'      max(time_stamp) last_view,',
'      min(time_stamp) first_view,',
'      sum(decode(page_mode,''R'',1,0)) cached_pages,',
'      sum(cached_regions) cached_regions,',
'      sum(decode(page_mode,''P'',1,0)) partial_page_views,',
'      sum(nvl(CONTENT_LENGTH,0)) content_length,',
'      sum(decode(to_char(time_stamp,''HH24''),0,1,0)) h00,',
'      sum(decode(to_char(time_stamp,''HH24''),1,1,0)) h01,',
'      sum(decode(to_char(time_stamp,''HH24''),2,1,0)) h02,',
'      sum(decode(to_char(time_stamp,''HH24''),3,1,0)) h03,',
'      sum(decode(to_char(time_stamp,''HH24''),4,1,0)) h04,',
'      sum(decode(to_char(time_stamp,''HH24''),5,1,0)) h05,',
'      sum(decode(to_char(time_stamp,''HH24''),6,1,0)) h06,',
'      sum(decode(to_char(time_stamp,''HH24''),7,1,0)) h07,',
'      sum(decode(to_char(time_stamp,''HH24''),8,1,0)) h08,',
'      sum(decode(to_char(time_stamp,''HH24''),9,1,0)) h09,',
'      sum(decode(to_char(time_stamp,''HH24''),10,1,0)) h10,',
'      sum(decode(to_char(time_stamp,''HH24''),11,1,0)) h11,',
'      sum(decode(to_char(time_stamp,''HH24''),12,1,0)) h12,',
'      sum(decode(to_char(time_stamp,''HH24''),13,1,0)) h13,',
'      sum(decode(to_char(time_stamp,''HH24''),14,1,0)) h14,',
'      sum(decode(to_char(time_stamp,''HH24''),15,1,0)) h15,',
'      sum(decode(to_char(time_stamp,''HH24''),16,1,0)) h16,',
'      sum(decode(to_char(time_stamp,''HH24''),17,1,0)) h17,',
'      sum(decode(to_char(time_stamp,''HH24''),18,1,0)) h18,',
'      sum(decode(to_char(time_stamp,''HH24''),19,1,0)) h19,',
'      sum(decode(to_char(time_stamp,''HH24''),20,1,0)) h20,',
'      sum(decode(to_char(time_stamp,''HH24''),21,1,0)) h21,',
'      sum(decode(to_char(time_stamp,''HH24''),22,1,0)) h22,',
'      sum(decode(to_char(time_stamp,''HH24''),23,1,0)) h23',
'from  WWV_FLOW_ACTIVITY_LOG',
'where time_stamp >= sysdate - :P25_DATE and',
'      security_group_id = :flow_security_group_id',
'group by upper(USERID) ',
') pv, total_views,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.HOUR'') hour_label from dual) m,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'') message_label from dual) m,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.K'',''~'') activity_by_hour_message_k from dual ) m'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_footer=>unistr('<p>As colunas do tempo decorrido s\00E3o registradas em segundos.</p>')
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(9307709001462905.4355)
,p_name=>'Page Views by User'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9308031484462911.4355)
,p_db_column_name=>'DEVELOPER'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Usu\00E1rio')
,p_column_link=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:RIR:IR_USERID:#DEVELOPER#'
,p_column_linktext=>'#DEVELOPER#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9308206855462912.4355)
,p_db_column_name=>'PAGE_EVENTS'
,p_display_order=>3
,p_column_identifier=>'D'
,p_column_label=>unistr('Eventos de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9308119375462912.4355)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>4
,p_column_identifier=>'C'
,p_column_label=>unistr('Views de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9308328702462912.4355)
,p_db_column_name=>'PAGE_PROCESSING'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('Processamento de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9308415410462912.4355)
,p_db_column_name=>'PCT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Percentual do Total'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D00'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9308515590462912.4355)
,p_db_column_name=>'GRAPH'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Percentual do Total'
,p_column_type=>'NUMBER'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_format_mask=>'PCT_GRAPH:cccccc:777777:150'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9308600863462913.4355)
,p_db_column_name=>'REPORT_ROWS'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('Linhas do Relat\00F3rio')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9308713826462913.4355)
,p_db_column_name=>'DISTINCT_PAGES'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('P\00E1ginas')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9308817645462913.4355)
,p_db_column_name=>'APPLICATIONS'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Aplicativos'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9309624075462914.4355)
,p_db_column_name=>'AVERAGE_ELAPSED_TIME'
,p_display_order=>11
,p_column_identifier=>'R'
,p_column_label=>unistr('M\00E9dia Decorrida')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9308910611462913.4355)
,p_db_column_name=>'ELAPSED_TIME'
,p_display_order=>12
,p_column_identifier=>'K'
,p_column_label=>'Decorrido'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D00'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9309004373462913.4355)
,p_db_column_name=>'DISTINCT_HOURS'
,p_display_order=>13
,p_column_identifier=>'L'
,p_column_label=>'Horas Distintas'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9309116716462913.4355)
,p_db_column_name=>'DISTINCT_DAYS'
,p_display_order=>14
,p_column_identifier=>'M'
,p_column_label=>'Dias Distintos'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9309204584462914.4355)
,p_db_column_name=>'LAST_VIEW'
,p_display_order=>15
,p_column_identifier=>'N'
,p_column_label=>unistr('\00DAltima View')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9309326606462914.4355)
,p_db_column_name=>'FIRST_VIEW'
,p_display_order=>16
,p_column_identifier=>'O'
,p_column_label=>'Primeira View'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9309703372462914.4355)
,p_db_column_name=>'PARTIAL_PAGE_VIEWS'
,p_display_order=>17
,p_column_identifier=>'S'
,p_column_label=>unistr('Views Parciais da P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9309408920462914.4355)
,p_db_column_name=>'CACHED_PAGES'
,p_display_order=>18
,p_column_identifier=>'P'
,p_column_label=>unistr('P\00E1ginas Armazenadas no Cache')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9309514341462914.4355)
,p_db_column_name=>'CACHED_REGIONS'
,p_display_order=>19
,p_column_identifier=>'Q'
,p_column_label=>unistr('Regi\00F5es Armazenadas no Cache')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(200270403673529201.4355)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>20
,p_column_identifier=>'T'
,p_column_label=>unistr('Conte\00FAdo')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1760555663993323223.4355)
,p_db_column_name=>'HOURS'
,p_display_order=>30
,p_column_identifier=>'U'
,p_column_label=>'Atividade por hora'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(200574906058977363.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(5180512459865310.4355)
,p_button_name=>'P25_SET'
,p_button_static_id=>'P25_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'SET'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(200270517871533277.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5180512459865310.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:25,RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(131170811232636848.4355)
,p_branch_action=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(874931239464688.4355)
,p_name=>'P25_DATE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5180512459865310.4355)
,p_item_default=>'to_number(.125)'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Desde'
,p_source=>'to_number(.125)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'U'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico. Identifique o per\00EDodo a ser '),
'',
unistr('inclu\00EDdo no relat\00F3rio e clique em <b>Ir</b>.<p />'),
unistr('Se voc\00EA selecionar 1 dia, apenas as 24 \00FAltimas horas ser\00E3o exibidas.  ')))
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
end;
/
prompt --application/pages/page_00026
begin
wwv_flow_api.create_page(
 p_id=>26.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Views de P\00E1gina por Aplicativo')
,p_step_title=>unistr('Views de P\00E1gina por Aplicativo')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9290610815383521.4355)
,p_plug_name=>'Atividade Por Aplicativo'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P26a */',
'       flow_id application, ',
'       page_events, v, page_processing, u, p, v/u v_per_user, ',
'       decode(v,0,0,v/(:P26_SINCE*24*60*60)) vs, ',
'       e,',
'       m,',
'       min,',
'       mints, ',
'       maxts,',
'       rr report_rows,',
'       sqlerrm errors,',
'       dynamic_views,',
'       cached_views,',
'       cached_regions,',
'       CONTENT_LENGTH,',
'      ''<div class="hour-graph">''||',
'      ''<span title="''||m.hour_label||''  0, ''||m.message_label||'' ''||ltrim(to_char(h00,''999G999G999''))||''" class="hour''|| case when h00 = 0 then '' is-null'' when h00 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 0</span> <span class="hour-'
||'value">''|| case when h00 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h00/1000),''99999999D0'')) else to_char(h00) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  1, ''||m.message_label||'' ''||ltrim(to_char(h01,''999G999G999''))||''" class="hour''|| case when h01 = 0 then '' is-null'' when h01 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 1</span> <span class="hour-'
||'value">''|| case when h01 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h01/1000),''99999999D0'')) else to_char(h01) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  2, ''||m.message_label||'' ''||ltrim(to_char(h02,''999G999G999''))||''" class="hour''|| case when h02 = 0 then '' is-null'' when h02 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 2</span> <span class="hour-'
||'value">''|| case when h02 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h02/1000),''99999999D0'')) else to_char(h02) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  3, ''||m.message_label||'' ''||ltrim(to_char(h03,''999G999G999''))||''" class="hour''|| case when h03 = 0 then '' is-null'' when h03 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 3</span> <span class="hour-'
||'value">''|| case when h03 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h03/1000),''99999999D0'')) else to_char(h03) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  4, ''||m.message_label||'' ''||ltrim(to_char(h04,''999G999G999''))||''" class="hour''|| case when h04 = 0 then '' is-null'' when h04 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 4</span> <span class="hour-'
||'value">''|| case when h04 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h04/1000),''99999999D0'')) else to_char(h04) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  5, ''||m.message_label||'' ''||ltrim(to_char(h05,''999G999G999''))||''" class="hour''|| case when h05 = 0 then '' is-null'' when h05 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 5</span> <span class="hour-'
||'value">''|| case when h05 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h05/1000),''99999999D0'')) else to_char(h05) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  6, ''||m.message_label||'' ''||ltrim(to_char(h06,''999G999G999''))||''" class="hour''|| case when h06 = 0 then '' is-null'' when h06 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 6</span> <span class="hour-'
||'value">''|| case when h06 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h06/1000),''99999999D0'')) else to_char(h06) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  7, ''||m.message_label||'' ''||ltrim(to_char(h07,''999G999G999''))||''" class="hour''|| case when h07 = 0 then '' is-null'' when h07 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 7</span> <span class="hour-'
||'value">''|| case when h07 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h07/1000),''99999999D0'')) else to_char(h07) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  8, ''||m.message_label||'' ''||ltrim(to_char(h08,''999G999G999''))||''" class="hour''|| case when h08 = 0 then '' is-null'' when h08 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 8</span> <span class="hour-'
||'value">''|| case when h08 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h08/1000),''99999999D0'')) else to_char(h08) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||''  9, ''||m.message_label||'' ''||ltrim(to_char(h09,''999G999G999''))||''" class="hour''|| case when h09 = 0 then '' is-null'' when h09 > 999 then '' is-over1k'' end ||''"><span class="hour-label"> 9</span> <span class="hour-'
||'value">''|| case when h09 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h09/1000),''99999999D0'')) else to_char(h09) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 10, ''||m.message_label||'' ''||ltrim(to_char(h10,''999G999G999''))||''" class="hour''|| case when h10 = 0 then '' is-null'' when h10 > 999 then '' is-over1k'' end ||''"><span class="hour-label">10</span> <span class="hour-'
||'value">''|| case when h10 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h10/1000),''99999999D0'')) else to_char(h10) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 11, ''||m.message_label||'' ''||ltrim(to_char(h11,''999G999G999''))||''" class="hour''|| case when h11 = 0 then '' is-null'' when h11 > 999 then '' is-over1k'' end ||''"><span class="hour-label">11</span> <span class="hour-'
||'value">''|| case when h11 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h11/1000),''99999999D0'')) else to_char(h11) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 12, ''||m.message_label||'' ''||ltrim(to_char(h12,''999G999G999''))||''" class="hour''|| case when h12 = 0 then '' is-null'' when h12 > 999 then '' is-over1k'' end ||''"><span class="hour-label">12</span> <span class="hour-'
||'value">''|| case when h12 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h12/1000),''99999999D0'')) else to_char(h12) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 13, ''||m.message_label||'' ''||ltrim(to_char(h13,''999G999G999''))||''" class="hour''|| case when h13 = 0 then '' is-null'' when h13 > 999 then '' is-over1k'' end ||''"><span class="hour-label">13</span> <span class="hour-'
||'value">''|| case when h13 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h13/1000),''99999999D0'')) else to_char(h13) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 14, ''||m.message_label||'' ''||ltrim(to_char(h14,''999G999G999''))||''" class="hour''|| case when h14 = 0 then '' is-null'' when h14 > 999 then '' is-over1k'' end ||''"><span class="hour-label">14</span> <span class="hour-'
||'value">''|| case when h14 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h14/1000),''99999999D0'')) else to_char(h14) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 15, ''||m.message_label||'' ''||ltrim(to_char(h15,''999G999G999''))||''" class="hour''|| case when h15 = 0 then '' is-null'' when h15 > 999 then '' is-over1k'' end ||''"><span class="hour-label">15</span> <span class="hour-'
||'value">''|| case when h15 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h15/1000),''99999999D0'')) else to_char(h15) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 16, ''||m.message_label||'' ''||ltrim(to_char(h16,''999G999G999''))||''" class="hour''|| case when h16 = 0 then '' is-null'' when h16 > 999 then '' is-over1k'' end ||''"><span class="hour-label">16</span> <span class="hour-'
||'value">''|| case when h16 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h16/1000),''99999999D0'')) else to_char(h16) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 17, ''||m.message_label||'' ''||ltrim(to_char(h17,''999G999G999''))||''" class="hour''|| case when h17 = 0 then '' is-null'' when h17 > 999 then '' is-over1k'' end ||''"><span class="hour-label">17</span> <span class="hour-'
||'value">''|| case when h17 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h17/1000),''99999999D0'')) else to_char(h17) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 18, ''||m.message_label||'' ''||ltrim(to_char(h18,''999G999G999''))||''" class="hour''|| case when h18 = 0 then '' is-null'' when h18 > 999 then '' is-over1k'' end ||''"><span class="hour-label">18</span> <span class="hour-'
||'value">''|| case when h18 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h18/1000),''99999999D0'')) else to_char(h18) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 19, ''||m.message_label||'' ''||ltrim(to_char(h19,''999G999G999''))||''" class="hour''|| case when h19 = 0 then '' is-null'' when h19 > 999 then '' is-over1k'' end ||''"><span class="hour-label">19</span> <span class="hour-'
||'value">''|| case when h19 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h19/1000),''99999999D0'')) else to_char(h19) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 20, ''||m.message_label||'' ''||ltrim(to_char(h20,''999G999G999''))||''" class="hour''|| case when h20 = 0 then '' is-null'' when h20 > 999 then '' is-over1k'' end ||''"><span class="hour-label">20</span> <span class="hour-'
||'value">''|| case when h20 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h20/1000),''99999999D0'')) else to_char(h20) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 21, ''||m.message_label||'' ''||ltrim(to_char(h21,''999G999G999''))||''" class="hour''|| case when h21 = 0 then '' is-null'' when h21 > 999 then '' is-over1k'' end ||''"><span class="hour-label">21</span> <span class="hour-'
||'value">''|| case when h21 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h21/1000),''99999999D0'')) else to_char(h21) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 22, ''||m.message_label||'' ''||ltrim(to_char(h22,''999G999G999''))||''" class="hour''|| case when h22 = 0 then '' is-null'' when h22 > 999 then '' is-over1k'' end ||''"><span class="hour-label">22</span> <span class="hour-'
||'value">''|| case when h22 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h22/1000),''99999999D0'')) else to_char(h22) end ||''</span></span>''||',
'      ''<span title="''||m.hour_label||'' 23, ''||m.message_label||'' ''||ltrim(to_char(h23,''999G999G999''))||''" class="hour''|| case when h23 = 0 then '' is-null'' when h23 > 999 then '' is-over1k'' end ||''"><span class="hour-label">23</span> <span class="hour-'
||'value">''|| case when h23 > 999 then replace(m.activity_by_hour_message_k,''~'',to_char((h23/1000),''99999999D0'')) else to_char(h23) end ||''</span></span>''||',
'      ''</div>'' hours',
'from (',
'select flow_id, ',
'       count(*) page_events,',
'       sum(decode(page_mode,''A'',0,1)) v, ',
'       sum(decode(page_mode,''A'',1,0)) page_processing,',
'       count(distinct userid) u,',
'       avg(elap) e, max(elap) m, min(elap) min,',
'       min(time_stamp) mints, max(time_stamp) maxts,',
'       count(distinct(step_id)) p,',
'       sum(num_rows) rr,',
'       sum(decode(sqlerrm,null,0,1)) sqlerrm,',
'    sum(decode(page_mode,''D'',1,''C'',1,0)) dynamic_views,',
'    sum(decode(page_mode,''D'',0,''C'',0,''A'',0,''P'',1)) cached_views,',
'    sum(cached_regions) cached_regions,',
'    sum(nvl(CONTENT_LENGTH,0)) CONTENT_LENGTH,',
'    sum(decode(to_char(time_stamp,''HH24''),0,1,0)) h00,',
'    sum(decode(to_char(time_stamp,''HH24''),1,1,0)) h01,',
'    sum(decode(to_char(time_stamp,''HH24''),2,1,0)) h02,',
'    sum(decode(to_char(time_stamp,''HH24''),3,1,0)) h03,',
'    sum(decode(to_char(time_stamp,''HH24''),4,1,0)) h04,',
'    sum(decode(to_char(time_stamp,''HH24''),5,1,0)) h05,',
'    sum(decode(to_char(time_stamp,''HH24''),6,1,0)) h06,',
'    sum(decode(to_char(time_stamp,''HH24''),7,1,0)) h07,',
'    sum(decode(to_char(time_stamp,''HH24''),8,1,0)) h08,',
'    sum(decode(to_char(time_stamp,''HH24''),9,1,0)) h09,',
'    sum(decode(to_char(time_stamp,''HH24''),10,1,0)) h10,',
'    sum(decode(to_char(time_stamp,''HH24''),11,1,0)) h11,',
'    sum(decode(to_char(time_stamp,''HH24''),12,1,0)) h12,',
'    sum(decode(to_char(time_stamp,''HH24''),13,1,0)) h13,',
'    sum(decode(to_char(time_stamp,''HH24''),14,1,0)) h14,',
'    sum(decode(to_char(time_stamp,''HH24''),15,1,0)) h15,',
'    sum(decode(to_char(time_stamp,''HH24''),16,1,0)) h16,',
'    sum(decode(to_char(time_stamp,''HH24''),17,1,0)) h17,',
'    sum(decode(to_char(time_stamp,''HH24''),18,1,0)) h18,',
'    sum(decode(to_char(time_stamp,''HH24''),19,1,0)) h19,',
'    sum(decode(to_char(time_stamp,''HH24''),20,1,0)) h20,',
'    sum(decode(to_char(time_stamp,''HH24''),21,1,0)) h21,',
'    sum(decode(to_char(time_stamp,''HH24''),22,1,0)) h22,',
'    sum(decode(to_char(time_stamp,''HH24''),23,1,0)) h23',
'from wwv_flow_activity_log',
'where time_stamp >= sysdate - :P26_SINCE and',
'      security_group_id = :flow_security_group_id ',
'group by flow_id) r,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.HOUR'') hour_label from dual) m,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'') message_label from dual) m,',
'  (select wwv_flow_lang.system_message(''APEX.ACTIVITY_BY_HOUR.K'',''~'') activity_by_hour_message_k from dual ) m',
'where u > 0'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_footer=>unistr('<p>As colunas do tempo decorrido s\00E3o registradas em segundos.</p>')
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(9290710598383521.4355)
,p_name=>'Activity By Application'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9290914669383534.4355)
,p_db_column_name=>'APPLICATION'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Aplicativo'
,p_column_link=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:RIR:IR_FLOW_ID:#APPLICATION#'
,p_column_linktext=>'#APPLICATION#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9291325676383538.4355)
,p_db_column_name=>'U'
,p_display_order=>2
,p_column_identifier=>'E'
,p_column_label=>unistr('Usu\00E1rios')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9291427844383538.4355)
,p_db_column_name=>'P'
,p_display_order=>3
,p_column_identifier=>'F'
,p_column_label=>unistr('P\00E1ginas')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9291030843383537.4355)
,p_db_column_name=>'PAGE_EVENTS'
,p_display_order=>4
,p_column_identifier=>'B'
,p_column_label=>unistr('Eventos de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9291118900383537.4355)
,p_db_column_name=>'V'
,p_display_order=>5
,p_column_identifier=>'C'
,p_column_label=>unistr('Views de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9291210445383538.4355)
,p_db_column_name=>'PAGE_PROCESSING'
,p_display_order=>6
,p_column_identifier=>'D'
,p_column_label=>unistr('Processamento de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9291510665383538.4355)
,p_db_column_name=>'V_PER_USER'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('Views de P\00E1gina por Usu\00E1rio')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9291601918383538.4355)
,p_db_column_name=>'VS'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Views por Segundo'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G990D00000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9291727414383538.4355)
,p_db_column_name=>'E'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('M\00E9dia Decorrida')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'99G999G990D00'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9291825367383539.4355)
,p_db_column_name=>'M'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('Tempo M\00E1ximo Decorrido')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G990D00'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9291915185383540.4355)
,p_db_column_name=>'MIN'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>unistr('Tempo M\00EDnimo Decorrido')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'9G999G999G990D00'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9292014541383540.4355)
,p_db_column_name=>'MINTS'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>'Primeira View'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9292120461383541.4355)
,p_db_column_name=>'MAXTS'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>unistr('\00DAltima View')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9292231539383541.4355)
,p_db_column_name=>'REPORT_ROWS'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>unistr('Linhas do Relat\00F3rio')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9292315896383541.4355)
,p_db_column_name=>'ERRORS'
,p_display_order=>15
,p_column_identifier=>'O'
,p_column_label=>'Erros'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9292414571383541.4355)
,p_db_column_name=>'DYNAMIC_VIEWS'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>unistr('Views Din\00E2micas')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9292527076383541.4355)
,p_db_column_name=>'CACHED_VIEWS'
,p_display_order=>17
,p_column_identifier=>'Q'
,p_column_label=>'Views Armazenadas no Cache'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9292617059383541.4355)
,p_db_column_name=>'CACHED_REGIONS'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>unistr('Regi\00F5es Armazenadas no Cache')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(200271025621544978.4355)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>unistr('Conte\00FAdo')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1760555766693323224.4355)
,p_db_column_name=>'HOURS'
,p_display_order=>29
,p_column_identifier=>'T'
,p_column_label=>'Atividade por hora'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(200477803138815713.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(200580507536034608.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(200477803138815713.4355)
,p_button_name=>'P26_SET'
,p_button_static_id=>'P26_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'SET'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(200580824505039429.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(200477803138815713.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:26,RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(131128420332626091.4355)
,p_branch_action=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(200579710522025924.4355)
,p_name=>'P26_SINCE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(200477803138815713.4355)
,p_item_default=>'to_number(.125)'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Desde'
,p_source=>'to_number(.125)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'U'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico. Identifique o per\00EDodo a ser '),
'',
unistr('inclu\00EDdo no relat\00F3rio e clique em <b>Ir</b>.<p />'),
unistr('Se voc\00EA selecionar 1 dia, apenas as 24 \00FAltimas horas ser\00E3o exibidas.  ')))
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(9906602353212915.4355)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_RESET_PAGINATION'
,p_process_name=>'reset pagination'
,p_attribute_01=>'THIS_PAGE'
,p_process_when=>'GO'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00027
begin
wwv_flow_api.create_page(
 p_id=>27.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Calend\00E1rio Mensal de Views de P\00E1gina por Dia')
,p_step_title=>unistr('Calend\00E1rio Mensal de Views de P\00E1gina por Dia')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47775113894360528.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(233523126780054135.4355)
,p_plug_name=>unistr('Views de P\00E1gina por Dia')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_region_attributes=>'style="width:100%;"'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P27a */',
'       trunc(TIME_STAMP) ts,',
'       t.v||'': ''||to_char(count(*),''999G999G999G990'') || chr(10) ||',
'       t.u||'': ''||to_char(count(distinct upper(USERID)),''999G999G999G990'')|| chr(10) ||',
'       t.a||'': ''||to_char(count(distinct flow_id),''999G999G999G990'')|| chr(10) ||',
'       t.p||'': ''||to_char(count(distinct step_id),''999G999G999G990'') as display',
'    from   WWV_FLOW_ACTIVITY_LOG,',
'(select wwv_flow_lang.system_message(''views'') v,',
'        wwv_flow_lang.system_message(''users'') u,',
'        wwv_flow_lang.system_message(''applications'') a,',
'        wwv_flow_lang.system_message(''pages'') p',
' from dual) t',
'    where  security_group_id = :flow_security_group_id and page_mode != ''A'' and',
'    (nvl(:P27_APPLICATION,0) = 0 or flow_id = :P27_APPLICATION) and',
'    TIME_STAMP > sysdate - nvl(:P27_TIME,7) ',
'group by trunc(time_stamp), t.v, t.u, t.a, t.p'))
,p_plug_source_type=>'NATIVE_CSS_CALENDAR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'TS'
,p_attribute_03=>'DISPLAY'
,p_attribute_07=>'N'
,p_attribute_09=>'navigation'
,p_attribute_13=>'N'
,p_attribute_17=>'Y'
,p_attribute_19=>'N'
,p_attribute_21=>'10'
,p_attribute_22=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(429994131751180568.4355)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(47775113894360528.4355)
,p_button_name=>'P27_SET'
,p_button_static_id=>'P27_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'APPLY_CHANGES'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(233186907690029293.4355)
,p_branch_action=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(47775420235360528.4355)
,p_name=>'P27_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(47775113894360528.4355)
,p_item_default=>'to_number(.25)'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Desde'
,p_source=>'to_number(7)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico.')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(47775926911360530.4355)
,p_name=>'P27_APPLICATION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(47775113894360528.4355)
,p_item_default=>'0'
,p_prompt=>'Aplicativo'
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AVAILABLE.APPLICATIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from wwv_flow_visible_flows f',
' order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Todos os Aplicativos -'
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Filtrar sa\00EDda do relat\00F3rio para incluir todos os aplicativos ou um aplicativo espec\00EDfico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00028
begin
wwv_flow_api.create_page(
 p_id=>28.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Expurgar Prefer\00EAncias')
,p_step_title=>unistr('Expurgar Prefer\00EAncias')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215469304188572178)
,p_step_template=>wwv_flow_api.id(692763410753114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_user_pref.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(49166307683716829.4355)
,p_plug_name=>unistr('Redefinir Prefer\00EAncias do Usu\00E1rio')
,p_region_template_options=>'#DEFAULT#:a-Alert--noIcon:a-Alert--warning:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(797568474776479154.4355)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<span class="instructiontext">'');',
'for c1 in (select count(*) c from wwv_flow_preferences$ where user_id = :flow_user and security_group_id = :flow_security_group_id) loop',
'sys.htp.p( wwv_flow_lang.system_message(''F4350_USER_PREFS'',:flow_user,c1.c));',
'end loop;',
'sys.htp.p(wwv_flow_lang.system_message(''F4350_RESET_PREFS'')||''</span>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_column_width=>'valign="top"'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(49186429261744804.4355)
,p_plug_name=>unistr('Prefer\00EAncias')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('Este relat\00F3rio mostra as prefer\00EAncias definidas para o usu\00E1rio atual. Esses valores de estado de sess\00E3o s\00E3o mantidos entre conex\00F5es.')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(49167831098716830.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(49166307683716829.4355)
,p_button_name=>'ViewPreferences'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>unistr('Exibir Prefer\00EAncias')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:pref:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(49167427147716830.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(49166307683716829.4355)
,p_button_name=>'ResetPref'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Redefinir Prefer\00EAncias')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(49179822550733432.4355)
,p_branch_action=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(49168016057716831.4355)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_USER_PREFERENCES'
,p_process_name=>'reset user preferences'
,p_attribute_01=>'RESET_USER_PREFERENCES'
,p_process_error_message=>unistr('N\00E3o foi poss\00EDvel redefinir as prefer\00EAncias do usu\00E1rio.')
,p_process_when_button_id=>wwv_flow_api.id(49167427147716830.4355)
,p_process_success_message=>unistr('As prefer\00EAncias do usu\00E1rio foram redefinidas (removidas).')
);
end;
/
prompt --application/pages/page_00029
begin
wwv_flow_api.create_page(
 p_id=>29.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Views de P\00E1gina Recentes')
,p_step_title=>unistr('Views de P\00E1gina Recentes')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9294728475405715.4355)
,p_plug_name=>unistr('Views de P\00E1gina Recentes')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  /*+ FIRST_ROWS(21) */',
'    time_stamp,',
'    elap,',
'    num_rows query_rows,',
'    userid userid, ',
'    flow_id,',
'    (select name from wwv_flows where id = l.flow_id) application_name,',
'    (select name from wwv_flow_steps where id = l.step_id and flow_id = l.flow_id) page_name,',
'    step_id,',
'    session_id,',
'    substr(user_agent,1,100) user_agent,',
'    86400 * (time_stamp - lag(time_stamp) over (order by userid, time_stamp)) thinktime,',
'    sqlerrm,',
'    page_mode page_mode_code,',
'    cached_regions,',
'    decode(page_mode,',
'        ''A'',m.m_PAGE_PROCESSING,',
'        ''C'',m.m_CACHE_CREATED,',
'        ''D'',m.m_DYNAMIC,',
'        ''P'',m.m_PARTIAL_PAGE, ',
'        ''R'',m.m_CACHED,',
'        page_mode) page_mode,',
'   to_char(time_stamp,''YYYYMMDD'') day,',
'   websheet_id,',
'   decode(l.flow_id,4900,(select name from wwv_flow_ws_applications where id = l.websheet_id),null) websheet_name,',
'   worksheet_id,',
'   ir_search,',
'   CONTENT_LENGTH,',
'   page_view_type,',
'   request_value,',
'   debug_page_view_id,',
'   ecid',
'from WWV_FLOW_ACTIVITY_LOG l,',
'   (select wwv_flow_lang.system_message(''PAGE_PROCESSING'') m_PAGE_PROCESSING,',
'           wwv_flow_lang.system_message(''CACHE_CREATED'') m_CACHE_CREATED,',
'           wwv_flow_lang.system_message(''F4000.DYNAMIC'') m_DYNAMIC,',
'           wwv_flow_lang.system_message(''PARTIAL_PAGE'') m_PARTIAL_PAGE,',
'           wwv_flow_lang.system_message(''CACHED'') m_CACHED',
'    from dual) m',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - nvl(:P29_TIME,1)) and',
'    (nvl(:P29_APPLICATION,0)=0 or :P29_APPLICATION = flow_id)'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_footer=>unistr('<p>As colunas do tempo decorrido s\00E3o registradas em segundos.</p>')
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(9294827650405715.4355)
,p_name=>'Recent Page Views'
,p_max_row_count=>'100000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_download_filename=>'pagelog'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9295014155405725.4355)
,p_db_column_name=>'TIME_STAMP'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Data'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9295117155405725.4355)
,p_db_column_name=>'ELAP'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Decorrido'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9295310019405725.4355)
,p_db_column_name=>'USERID'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('Usu\00E1rio')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9295401265405725.4355)
,p_db_column_name=>'FLOW_ID'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Aplicativo'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9295528247405726.4355)
,p_db_column_name=>'STEP_ID'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9295815278405726.4355)
,p_db_column_name=>'THINKTIME'
,p_display_order=>7
,p_column_identifier=>'I'
,p_column_label=>'Tempo de Inatividade'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9295623845405726.4355)
,p_db_column_name=>'SESSION_ID'
,p_display_order=>8
,p_column_identifier=>'G'
,p_column_label=>unistr('Sess\00E3o')
,p_column_link=>'f?p=&FLOW_ID.:19:&SESSION.::&DEBUG.:RP,:P19_ID:#SESSION_ID#'
,p_column_linktext=>'#SESSION_ID#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9295706080405726.4355)
,p_db_column_name=>'USER_AGENT'
,p_display_order=>9
,p_column_identifier=>'H'
,p_column_label=>unistr('Agente do Usu\00E1rio')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9295910992405726.4355)
,p_db_column_name=>'SQLERRM'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Mensagem de Erro'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9296009036405726.4355)
,p_db_column_name=>'PAGE_MODE'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>unistr('Modo de P\00E1gina')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9296123584405727.4355)
,p_db_column_name=>'CACHED_REGIONS'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>unistr('Regi\00F5es Armazenadas no Cache ')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9298118980428251.4355)
,p_db_column_name=>'PAGE_MODE_CODE'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>unistr('C\00F3digo de Modo de P\00E1gina')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9388006803020796.4355)
,p_db_column_name=>'APPLICATION_NAME'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>'Nome do Aplicativo'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9388218924024234.4355)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>15
,p_column_identifier=>'O'
,p_column_label=>unistr('Nome da P\00E1gina')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9916615317476149.4355)
,p_db_column_name=>'DAY'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>'Dia'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30837825687419856.4355)
,p_db_column_name=>'WEBSHEET_ID'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>'Websheet Selecionada'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30837931182419860.4355)
,p_db_column_name=>'WORKSHEET_ID'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>unistr('Relat\00F3rio Selecionado')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30838006696419860.4355)
,p_db_column_name=>'IR_SEARCH'
,p_display_order=>20
,p_column_identifier=>'T'
,p_column_label=>unistr('Pesquisa de Relat\00F3rio Interativo')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(200269825228516466.4355)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('Conte\00FAdo')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(486710304301055040.4355)
,p_db_column_name=>'WEBSHEET_NAME'
,p_display_order=>22
,p_column_identifier=>'V'
,p_column_label=>'Websheet'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36918123274457464.4355)
,p_db_column_name=>'QUERY_ROWS'
,p_display_order=>23
,p_column_identifier=>'W'
,p_column_label=>'Linhas da Consulta'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1475460529806625310.4355)
,p_db_column_name=>'PAGE_VIEW_TYPE'
,p_display_order=>33
,p_column_identifier=>'AD'
,p_column_label=>unistr('Tipo de Exibi\00E7\00E3o de P\00E1gina')
,p_column_type=>'NUMBER'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(1569139039593351202)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1569135249109283180.4355)
,p_db_column_name=>'REQUEST_VALUE'
,p_display_order=>43
,p_column_identifier=>'Y'
,p_column_label=>unistr('Valor de Solicita\00E7\00E3o')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1569135368749283180.4355)
,p_db_column_name=>'DEBUG_PAGE_VIEW_ID'
,p_display_order=>53
,p_column_identifier=>'Z'
,p_column_label=>unistr('ID de Depura\00E7\00E3o')
,p_column_link=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:RP,24:P24_PAGE_VIEW_ID:#DEBUG_PAGE_VIEW_ID#'
,p_column_linktext=>'#DEBUG_PAGE_VIEW_ID#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(342360591742652522.4355)
,p_db_column_name=>'ECID'
,p_display_order=>63
,p_column_identifier=>'AE'
,p_column_label=>'ECID'
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47755428326156622.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(200579121127019533.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(47755428326156622.4355)
,p_button_name=>'P29_SET'
,p_button_static_id=>'P29_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'SET'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(196197132719904196.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(47755428326156622.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:29,RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(130990623956463449.4355)
,p_branch_action=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(47755701430156625.4355)
,p_name=>'P29_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(47755428326156622.4355)
,p_item_default=>'to_number(.25)'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Desde'
,p_source=>'to_number(.125)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico.')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(47756221007156625.4355)
,p_name=>'P29_APPLICATION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(47755428326156622.4355)
,p_item_default=>'0'
,p_prompt=>'Aplicativo'
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AVAILABLE.APPLICATIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from wwv_flow_visible_flows f',
' order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Todos os Aplicativos -'
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Filtrar sa\00EDda do relat\00F3rio para incluir todos os aplicativos ou um aplicativo espec\00EDfico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(158494820430118826.4355)
,p_validation_name=>'flows is numeric'
,p_validation_sequence=>10
,p_validation=>'P29_FLOW'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('O valor deve ser num\00E9rico.')
,p_associated_item=>wwv_flow_api.id(22676108663323154.4355)
,p_error_display_location=>'INLINE_WITH_FIELD'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(158497003245123320.4355)
,p_validation_name=>'page is numeric'
,p_validation_sequence=>20
,p_validation=>'P29_PAGE'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('O valor deve ser num\00E9rico.')
,p_associated_item=>wwv_flow_api.id(22676713857324576.4355)
,p_error_display_location=>'INLINE_WITH_FIELD'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(961201412394966.4355)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_RESET_PAGINATION'
,p_process_name=>'reset pagination'
,p_attribute_01=>'THIS_PAGE'
,p_process_when=>'GO'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00030
begin
wwv_flow_api.create_page(
 p_id=>30.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>'Log de Atividades do Desenvolvedor'
,p_step_title=>'Log de Atividades do Desenvolvedor'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215462122626558552)
,p_step_template=>wwv_flow_api.id(692763410753114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12518728403445471)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_mg_logs.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1004413391363499.4355)
,p_plug_name=>'Gerenciar Log de Atividades do Desenvolvedor'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   c_dev pls_integer := 0;',
'   c_click pls_integer := 0;',
'begin',
'   sys.htp.p(''<table class="instructiontext" role="presentation" cellspacing="0" cellpadding="0">'');',
'   -- wwv_flow_builder_audit_trail ',
'   select count(*) into c_dev from wwv_flow_builder_audit_trail ',
'   where security_group_id = :flow_security_group_id;',
'   sys.htp.prn(''<tr><td>''||wwv_flow_lang.system_message(''F4350_DEV_LOG_ENTRIES'')||''</td><td align="right" class="fielddatabold">&nbsp;'');',
'   sys.htp.prn(to_char(c_dev,''999,999,999,999,999,990''));',
'   sys.htp.prn(''</td></tr></table><p />'');',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'valign="top"'
,p_plug_header=>unistr('A atividade do desenvolvedor \00E9 um log de altera\00E7\00F5es do desenvolvedor no aplicativo deste espa\00E7o de trabalho. O log monitora o desenvolvedor, o aplicativo, o componente alterado e a data.  As informa\00E7\00F5es do log do desenvolvedor s\00E3o mantidas por um m\00EAs')
||unistr('. Use esta p\00E1gina para expurgar entradas no log de atividades do desenvolvedor.')
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47260804113938827.4355)
,p_plug_name=>'Manage Logs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:50%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(41778218420271753.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(168717528748286543.4355)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6889902515000422.4355)
,p_button_sequence=>15
,p_button_plug_id=>wwv_flow_api.id(1004413391363499.4355)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2554514135549743.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1004413391363499.4355)
,p_button_name=>'PURGE_DEVELOPER_LOG'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Expurgar Log do Desenvolvedor'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1119314682357438.4355)
,p_branch_action=>'30'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1115827233342122.4355)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'purge builder audit'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'delete from wwv_flow_builder_audit_trail ',
'where security_group_id = :flow_security_group_id;'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel expurgar o log.')
,p_process_when_button_id=>wwv_flow_api.id(2554514135549743.4355)
,p_process_success_message=>'Log de Atividade do Desenvolvedor Expurgado'
);
end;
/
prompt --application/pages/page_00031
begin
wwv_flow_api.create_page(
 p_id=>31.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Views de P\00E1gina por Desempenho Ponderado de P\00E1gina')
,p_step_title=>unistr('Views de P\00E1gina por Desempenho Ponderado de P\00E1gina')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9772622807334494.4355)
,p_plug_name=>unistr('Desempenho Ponderado de P\00E1gina')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P31a */',
'       flow_id                  application_id, ',
'       step_id                  page_id, ',
'       (select name from wwv_flows where id = l.flow_id) application_name,',
'       (select name from wwv_flow_steps where id = l.step_id and flow_id = l.flow_id) page_name,',
'       count (*)                page_events,',
'       avg(elap)                average_elapsed_time, ',
'       avg(elap)*count(*)       weighted_average,',
'       median(elap)             median_elapsed_time,',
'       median(elap)*count(*)    weighted_median,',
'       (median(elap)*count(*)) - (avg(elap)*count(*)) median_to_avg_delta,',
'       max(elap)                maximum_elapsed_time,',
'       min(elap)                minimum_elapsed_time,',
'       max(elap) - min(elap)    maximum_minimum_delta,',
'       median(content_length)  median_content_length',
'from wwv_flow_activity_log l',
'where security_group_id = :flow_security_group_id and ',
'    (:app_security_group_id = 10 or flow_id not between 4000 and 4999) and',
'    time_stamp >= (sysdate - nvl(:P31_TIME,1)) and',
'    (nvl(:P31_APPLICATION,0) = 0 or flow_id = :P31_APPLICATION)',
'group by flow_id, step_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_footer=>unistr('<br /><p>As colunas de tempo decorrido s\00E3o reportadas em segundos. A M\00E9dia Ponderada \00E9 calculada multiplicando-se eventos da p\00E1gina pelo tempo m\00E9dio de renderiza\00E7\00E3o da p\00E1gina em segundos. A M\00E9dia Mediana \00E9 calculada multiplicando-se eventos da p\00E1gina')
||unistr(' pelo tempo mediano de renderiza\00E7\00E3o da p\00E1gina em segundos. Os eventos da p\00E1gina incluem renderiza\00E7\00E3o e eventos de processamento da p\00E1gina.</p>')
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(9772730274334494.4355)
,p_name=>'Weighted Page Performance'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9772901477334499.4355)
,p_db_column_name=>'APPLICATION_ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Aplicativo'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9773030460334504.4355)
,p_db_column_name=>'PAGE_ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('P\00E1gina')
,p_column_link=>'f?p=&APP_ID.:65:&SESSION.::&DEBUG.:65:P65_APPLICATION,P65_PAGE:#APPLICATION_ID#,#PAGE_ID#'
,p_column_linktext=>'#PAGE_ID#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9773123964334504.4355)
,p_db_column_name=>'PAGE_EVENTS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('Eventos de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9773202731334504.4355)
,p_db_column_name=>'AVERAGE_ELAPSED_TIME'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('M\00E9dia Decorrida')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9773308278334504.4355)
,p_db_column_name=>'WEIGHTED_AVERAGE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('M\00E9dia Ponderada')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9773428200334504.4355)
,p_db_column_name=>'MEDIAN_ELAPSED_TIME'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Mediano Decorrido'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9773513323334505.4355)
,p_db_column_name=>'WEIGHTED_MEDIAN'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Mediano Ponderado'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9775813452422841.4355)
,p_db_column_name=>'APPLICATION_NAME'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Nome do Aplicativo'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9776320294443708.4355)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('Nome da P\00E1gina')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9779126574473944.4355)
,p_db_column_name=>'MEDIAN_TO_AVG_DELTA'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('Delta M\00E9dia Mediana')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9779729822484382.4355)
,p_db_column_name=>'MAXIMUM_ELAPSED_TIME'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>unistr('Tempo M\00E1ximo Decorrido')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9779827213484382.4355)
,p_db_column_name=>'MINIMUM_ELAPSED_TIME'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>unistr('Tempo M\00EDnimo Decorrido')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(9780325105492393.4355)
,p_db_column_name=>'MAXIMUM_MINIMUM_DELTA'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>unistr('Delta M\00E1ximo e M\00EDnimo')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(201290225421223045.4355)
,p_db_column_name=>'MEDIAN_CONTENT_LENGTH'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>unistr('Conte\00FAdo Mediano')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(107716719694045280.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(450602812552903078.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(107716719694045280.4355)
,p_button_name=>'P31_SET'
,p_button_static_id=>'P31_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(201290305120226615.4355)
,p_button_sequence=>5
,p_button_plug_id=>wwv_flow_api.id(107716719694045280.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.:31,RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1022424529470850.4355)
,p_branch_action=>'31'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1016914440439483.4355)
,p_name=>'P31_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(107716719694045280.4355)
,p_prompt=>'Desde'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico. ')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(47771328953327091.4355)
,p_name=>'P31_APPLICATION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(107716719694045280.4355)
,p_item_default=>'0'
,p_prompt=>'Aplicativo'
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AVAILABLE.APPLICATIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from wwv_flow_visible_flows f',
' order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Todos os Aplicativos -'
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Filtrar sa\00EDda do relat\00F3rio para incluir todos os aplicativos ou um aplicativo espec\00EDfico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00032
begin
wwv_flow_api.create_page(
 p_id=>32.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Views por P\00E1gina')
,p_step_title=>unistr('Views por P\00E1gina')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215450408166535437)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5470717896084547.4355)
,p_name=>unistr('Views por P\00E1gina')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>21
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with total_page_views as ',
'(',
'select count(*) tpv ',
'from  WWV_FLOW_ACTIVITY_LOG',
'where time_stamp >= sysdate - :P32_TIME',
'and   security_group_id = :flow_security_group_id and',
'(userid = :p32_user or nvl(:p32_user,''0'') = ''0'') and',
'flow_id = :p32_flow',
')',
'select page_id, ',
'       (select name from wwv_flow_steps where flow_id = :p32_flow and id = page_id) page_name,',
'       page_views,',
'       100*page_views/tpv pct, ',
'       round(300*page_views/tpv) graph,',
'      report_rows,',
'      elapsed_time',
'from',
'(',
'select step_id page_id, count(*) page_views , sum(num_rows) report_rows, sum(elap) elapsed_time',
'from  WWV_FLOW_ACTIVITY_LOG',
'where time_stamp >= sysdate - :P32_TIME',
'and   security_group_id = :flow_security_group_id and',
'(userid = :p32_user or nvl(:p32_user,''0'') = ''0'') and',
'flow_id = :p32_flow',
'group by step_id',
') d, total_page_views'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(6659715068668103.4355)
,p_query_num_rows=>500
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('Dados n\00E3o encontrados.')
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>50000
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5471007240084565.4355)
,p_query_column_id=>1
,p_column_alias=>'PAGE_ID'
,p_column_display_sequence=>1
,p_column_heading=>unistr('P\00E1gina')
,p_default_sort_column_sequence=>1
,p_disable_sort_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5479500806145870.4355)
,p_query_column_id=>2
,p_column_alias=>'PAGE_NAME'
,p_column_display_sequence=>2
,p_column_heading=>unistr('Nome da P\00E1gina')
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5471131441084565.4355)
,p_query_column_id=>3
,p_column_alias=>'PAGE_VIEWS'
,p_column_display_sequence=>3
,p_column_heading=>unistr('Views de P\00E1gina')
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5472106945090809.4355)
,p_query_column_id=>4
,p_column_alias=>'PCT'
,p_column_display_sequence=>4
,p_column_heading=>'Percentual'
,p_column_format=>'999G999G999G999G990D00'
,p_column_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5472226421090810.4355)
,p_query_column_id=>5
,p_column_alias=>'GRAPH'
,p_column_display_sequence=>5
,p_column_heading=>'&nbsp;'
,p_column_html_expression=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">',
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>'))
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(7706002830600313.4355)
,p_query_column_id=>6
,p_column_alias=>'REPORT_ROWS'
,p_column_display_sequence=>6
,p_column_heading=>unistr('Linhas do Relat\00F3rio')
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(7706104497600318.4355)
,p_query_column_id=>7
,p_column_alias=>'ELAPSED_TIME'
,p_column_display_sequence=>7
,p_column_heading=>'Tempo Decorrido'
,p_column_format=>'999G999G999G999G990D00'
,p_column_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5476109416119971.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(17104217220309693.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(5476109416119971.4355)
,p_button_name=>'P32_GO'
,p_button_static_id=>'P32_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'GO'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(17109729518351162.4355)
,p_branch_action=>'32'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(17103004407306062.4355)
,p_name=>'P32_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5476109416119971.4355)
,p_prompt=>'Desde'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Selecione o prazo da pesquisa.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(17103612025308220.4355)
,p_name=>'P32_FLOW'
,p_data_type=>'NUMBER'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5476109416119971.4355)
,p_item_default=>'0'
,p_prompt=>'Aplicativo:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Identifica o aplicativo selecionado.'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(17106013195318054.4355)
,p_name=>'P32_USER'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(5476109416119971.4355)
,p_prompt=>unistr('Usu\00E1rio')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FND USERS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(user_name) d, user_name r',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Todos os Usu\00E1rios -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('Especifique um nome de usu\00E1rio para restringir o relat\00F3rio')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00033
begin
wwv_flow_api.create_page(
 p_id=>33.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Painel de Controle do Espa\00E7o de Trabalho')
,p_step_title=>unistr('Painel de Controle do Espa\00E7o de Trabalho')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(5108313447012897)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47002328518898200.4355)
,p_plug_name=>unistr('Pain\00E9is de Controle')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388531674152470979.4355)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(46989621592546067.4355)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(168717528748286543.4355)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47002505100900835.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(47003323454906127.4355)
,p_name=>unistr('Servi\00E7o')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>30
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P33a */',
'    :company workspace_name,',
'(',
'select count(*)',
'  from wwv_flow_visible_flows f',
' where f.build_status != ''RUN_AND_HIDDEN''',
') as applications,',
'(',
'select count(*)',
'  from wwv_flows f,',
'       wwv_flow_pkg_app_map m',
' where f.id = m.installed_app_id',
'   and f.security_group_id = m.security_group_id',
'   and f.security_group_id = :flow_security_group_id',
') as pkg_applications,',
'(',
'select count(*)',
'  from wwv_flow_files f, wwv_flow_fnd_user u',
' where u.security_group_id = :flow_security_group_id',
'   and u.user_name = :APP_USER',
'   and f.file_type = ''SCRIPT''',
') as sql_scripts,',
'(',
'select count(*)',
'  from wwv_flow_ws_applications ws',
' where ws.security_group_id = :flow_security_group_id',
') as websheets,',
'(',
'select count(*)',
'  from wwv_flow_company_schemas',
' where security_group_id = :flow_security_group_id',
') as schemas,',
'--',
'(select sum(open_requests)',
'from',
'(',
'select count(*) open_requests',
'from WWV_FLOW_PROVISION_COMPANY',
'where ',
'      SECURITY_GROUP_ID = :flow_security_group_id and',
'      project_status = ''REQUESTED''',
'union all',
'select count(*) open_requests',
'from wwv_flow_provision_serice_mod m, ',
'     wwv_flow_companies c',
'where m.security_group_id = c.provisioning_company_id and',
'      c.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      m.request_status = ''REQUESTED''',
') q ) open_requests',
'from dual',
'order by 1'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(43021310970202834.4355)
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47003528304906129.4355)
,p_query_column_id=>1
,p_column_alias=>'WORKSPACE_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Nome do Espa\00E7o de Trabalho')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47004106466906132.4355)
,p_query_column_id=>2
,p_column_alias=>'APPLICATIONS'
,p_column_display_sequence=>2
,p_column_heading=>'Aplicativos de Banco de Dados'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(21341929616496598.4355)
,p_query_column_id=>3
,p_column_alias=>'PKG_APPLICATIONS'
,p_column_display_sequence=>4
,p_column_heading=>'Aplicativos de Produtividade'
,p_use_as_row_header=>'N'
,p_report_column_required_role=>wwv_flow_api.id(21341101987393942)
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47031110155184041.4355)
,p_query_column_id=>4
,p_column_alias=>'SQL_SCRIPTS'
,p_column_display_sequence=>5
,p_column_heading=>'Scripts SQL'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47433727639171977.4355)
,p_query_column_id=>5
,p_column_alias=>'WEBSHEETS'
,p_column_display_sequence=>3
,p_column_heading=>'Aplicativos de Websheet'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47434208162185271.4355)
,p_query_column_id=>6
,p_column_alias=>'SCHEMAS'
,p_column_display_sequence=>6
,p_column_heading=>'Esquemas'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47469209715848022.4355)
,p_query_column_id=>7
,p_column_alias=>'OPEN_REQUESTS'
,p_column_display_sequence=>7
,p_column_heading=>unistr('Solicita\00E7\00F5es Abertas')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(47023120479007239.4355)
,p_name=>unistr('Esquemas Dispon\00EDveis')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>40
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P33b */ schema',
'from   wwv_flow_company_schemas',
'where  security_group_id = :flow_security_group_id',
'order by 1'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46765105410141325.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(47023120479007239.4355)
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47024118532016069.4355)
,p_query_column_id=>1
,p_column_alias=>'SCHEMA'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(47031617128214415.4355)
,p_name=>'Arquivos'
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>50
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select coalesce (',
'           c.max_file_bytes,',
'           to_number(wwv_flow_platform.get_preference(''WORKSPACE_MAX_FILE_BYTES'')) ) max_s,',
'       f.file_types,',
'       f.s,',
'       f.c',
'  from ( select max_file_bytes',
'           from wwv_flow_companies c',
'          where c.provisioning_company_id = :flow_security_group_id ) c,',
'       ( select count(distinct f.file_type) file_types,',
'                sum(f.file_bytes) s,',
'                sum(f.file_count) c',
'           from wwv_flow_company_filestats f',
'          where f.security_group_id=:flow_security_group_id ) f',
''))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(43021310970202834.4355)
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(47031617128214415.4355)
,p_plug_column_width=>'apex-col--bottomBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(620835445096373117.4355)
,p_query_column_id=>1
,p_column_alias=>'MAX_S'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Tamanho M\00E1ximo do Arquivo')
,p_use_as_row_header=>'N'
,p_column_format=>'FILESIZE'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(191599015501538189.4355)
,p_query_column_id=>2
,p_column_alias=>'FILE_TYPES'
,p_column_display_sequence=>4
,p_column_heading=>'Tipos de Arquivo'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(168480132258259834.4355)
,p_query_column_id=>3
,p_column_alias=>'S'
,p_column_display_sequence=>2
,p_column_heading=>'Tamanho Total do Arquivo'
,p_use_as_row_header=>'N'
,p_column_format=>'FILESIZE'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(168480211187259834.4355)
,p_query_column_id=>4
,p_column_alias=>'C'
,p_column_display_sequence=>3
,p_column_heading=>'Contagem de Arquivos'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(47409020218009023.4355)
,p_name=>unistr('Solicita\00E7\00F5es de Servi\00E7o Recentes')
,p_template=>wwv_flow_api.id(486010891028205826.4355)
,p_display_sequence=>60
,p_region_css_classes=>'h320'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P33d */',
'    wwv_flow_lang.system_message(''WORKSPACE_REQUEST'') ||'' - ''|| wwv_flow_item.text_from_lov(project_status,''REQUEST_STATUSES'') || '' - ''||',
'    DATABASE_SIZE||''MB'' the_request,',
'    request_date',
'from WWV_FLOW_PROVISION_COMPANY',
'where ',
'      SECURITY_GROUP_ID = :flow_security_group_id',
'union all',
'select wwv_flow_lang.system_message(''CHANGE_REQUEST'')||'' ''||m.service_name ||'' - ''||wwv_flow_item.text_from_lov(m.request_status,''REQUEST_STATUSES'')||'' - ''||',
'       m.service_attribute_1 the_request,',
'       m.requested_on',
'from wwv_flow_provision_serice_mod m, ',
'     wwv_flow_companies c',
'where m.security_group_id = c.provisioning_company_id and',
'      c.PROVISIONING_COMPANY_ID = :flow_security_group_id',
'order by 2 desc '))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46765105410141325.4355)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(47409020218009023.4355)
,p_plug_column_width=>'apex-col--leftBorder apex-col--bottomBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47411608321071843.4355)
,p_query_column_id=>1
,p_column_alias=>'THE_REQUEST'
,p_column_display_sequence=>1
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47411726856071844.4355)
,p_query_column_id=>2
,p_column_alias=>'REQUEST_DATE'
,p_column_display_sequence=>2
,p_column_format=>'SINCE'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(445571526299029605.4355)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:99%;"'
,p_plug_template=>wwv_flow_api.id(486010891028205826.4355)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use a p\00E1gina Painel de Controle para exibir detalhes sobre o espa\00E7o de trabalho atual e monitorar a atividade geral do espa\00E7o de trabalho.</p>'),
'<p><a target="_blank" href="&SYSTEM_HELP_URL./aeadm/viewing-workspace-dashboards.html">Saiba Mais...</a></p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(47073006110441131.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(47002505100900835.4355)
,p_button_name=>'MANAGE_SERVICES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>unistr('Gerenciar Servi\00E7o')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(168467711714773751.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(47002505100900835.4355)
,p_button_name=>'REPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>unistr('Utiliza\00E7\00E3o do Relat\00F3rio')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:::'
,p_security_scheme=>wwv_flow_api.id(12518728403445471)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(47003001103900837.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(47002505100900835.4355)
,p_button_name=>'REFRESH'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Atualizar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(47004305924910594.4355)
,p_branch_action=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
end;
/
prompt --application/pages/page_00034
begin
wwv_flow_api.create_page(
 p_id=>34.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>'Cliques Externos'
,p_step_title=>'Cliques Externos'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215673320866031164)
,p_step_template=>wwv_flow_api.id(692762974728114205.4355)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/wrkspc_activity.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(108236726284086228.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(450803907194232568.4355)
,p_plug_name=>'Cliques Externos'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829445215771671657.4355)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P34a */ trunc(CLICKDATE) CLICKDATE,category, count(*) c, FLOW_USER',
'from wwv_flow_clickthru_log',
'where clickdate >= (sysdate - :p34_time)',
'group by trunc(CLICKDATE), category, flow_user'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_footer=>unistr('Voc\00EA pode contar cliques de um aplicativo &PRODUCT_NAME. para um site externo usando o procedimento APEX_UTIL.COUNT_CLICK ou a vers\00E3o resumida do procedimento Z.')
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(450804016593232568.4355)
,p_name=>'External Clicks'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(450804304300232575.4355)
,p_db_column_name=>'CATEGORY'
,p_display_order=>1
,p_column_identifier=>'B'
,p_column_label=>'Categoria'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(450804530803232577.4355)
,p_db_column_name=>'FLOW_USER'
,p_display_order=>2
,p_column_identifier=>'D'
,p_column_label=>unistr('Usu\00E1rio')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(450804221494232574.4355)
,p_db_column_name=>'CLICKDATE'
,p_display_order=>3
,p_column_identifier=>'A'
,p_column_label=>'Data'
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(450804405100232576.4355)
,p_db_column_name=>'C'
,p_display_order=>4
,p_column_identifier=>'C'
,p_column_label=>'Contagem'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1107911902280875.4355)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(108236726284086228.4355)
,p_button_name=>'P34_GO'
,p_button_static_id=>'P34_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_request_source=>'GO'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(450806006223244673.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(108236726284086228.4355)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:34:&SESSION.::&DEBUG.:RIR::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1104019911256897.4355)
,p_branch_action=>'34'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>10
,p_branch_comment=>'Generated 29-NOV-2002 15:17:50'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1106521121274075.4355)
,p_name=>'P34_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(108236726284086228.4355)
,p_prompt=>'Desde'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''90 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 90/(24*60) t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 21 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 45 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 70 t from dual union all',
'select ''20 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 140 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(489153051785943514.4355)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Restrinja o relat\00F3rio a um hor\00E1rio espec\00EDfico. Identifique o per\00EDodo a ser '),
'',
unistr('inclu\00EDdo no relat\00F3rio e clique em <b>Ir</b>.<p />'),
unistr('Se voc\00EA selecionar 1 dia, apenas as 24 \00FAltimas horas ser\00E3o exibidas.  ')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00035
begin
wwv_flow_api.create_page(
 p_id=>35.4355
,p_user_interface_id=>wwv_flow_api.id(4969311180302342.4355)
,p_name=>unistr('Mensagem do Espa\00E7o de Trabalho')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('Mensagem do Espa\00E7o de Trabalho')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_html_page_onload=>'onload="p17_checkdisable()"'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215469304188572178)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script type="text/javascript">',
'<!--',
'',
'function p17_checkdisable(){ ',
'var ltext_0 = $x(''P17_EXPIRE_FND_USER_ACCOUNTS_0''); ',
'var ltext_1 = $x(''P17_EXPIRE_FND_USER_ACCOUNTS_1''); ',
'var ltext; ',
'if(ltext_0.checked == true){ltext = ltext_0}else{ltext = ltext_1} ',
'html_DisableOnValue(ltext,''N'',''P17_ACCOUNT_LIFETIME_DAYS'',''P17_USER_MAX_LOGIN_FAILURES'') ',
'} ',
'',
'//-->',
'</script>'))
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12518728403445471)
,p_dialog_height=>'400'
,p_dialog_width=>'500'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'AEADM/aadmin_wrksp_mess.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173255013158240412.4355)
,p_plug_name=>unistr('Mensagem do Espa\00E7o de Trabalho')
,p_region_template_options=>'#DEFAULT#:a-Form--labelsAbove'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720158679964358138.4355)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173255902160240415.4355)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(720165508600362771.4355)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(173256329637240416.4355)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(173255902160240415.4355)
,p_button_name=>'CANCEL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(173256126055240416.4355)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(173255902160240415.4355)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(486003960305193183.4355)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(173258603234240426.4355)
,p_branch_name=>'Go To Page &LAST_VIEW.'
,p_branch_act