prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4416
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4416 - Oracle APEX  System Messages and Native Types
--
-- Application Export:
--   Application:     4416
--   Name:            Oracle APEX  System Messages and Native Types
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             124
--       Globalization:
--         Messages:          14,593
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX  System Messages and Native Types')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286626400201927316')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135328'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'pt-br'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(91645213681389498.4416)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141231'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562090986404402217.4416)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48650898565635010.4416)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Sair'
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>'Sair do Application Express'
,p_list_text_09=>'Y'
,p_list_text_10=>'logout exit quit :q'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(281916990329150760.4416)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Criar um aplicativo em uma planilha'
,p_list_item_link_target=>'f?p=4000:447:&APP_SESSION.::NO:448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT::'
,p_list_text_01=>'Importar seus arquivos Excel ou csv e criar um aplicativo'
,p_list_text_09=>'Y'
,p_list_text_10=>'excel csv xsl xslx spreadsheet data paste load import'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(282255839842182292.4416)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Home Page do Oracle APEX'
,p_list_item_link_target=>'f?p=4500:1000:&APP_SESSION.'
,p_list_text_10=>unistr('in\00EDcio da homepage ')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(296033420364984683.4416)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Procurar \00CDcones de Fonte APEX')
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>unistr('Procure \00EDcones de Fonte APEX, adicione modificadores e copie CSS ou HTML que voc\00EA precisa.')
,p_list_text_09=>'Y'
,p_list_text_10=>unistr('gr\00E1ficos da biblioteca de \00EDcones de fonte apex')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562091518091404815.4416)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562091727563404815.4416)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Exportar Aplicativo'
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>'Exportar Aplicativo {APP_ID} como Arquivo SQL'
,p_list_text_09=>'Y'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562093357853428158.4416)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Listas N\00E3o Utilizadas')
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562092153904409717.4416)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48392393581618193.4416)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Log da Console'
,p_list_item_link_target=>'javascript:console.log(''hello friend'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14843831009863117.4416)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859012524941040.4416)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(86380554411225400.4416)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91997339122572414.4416)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(460407779408652225.4416)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(497671453666914719.4416)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attribute_01=>'fa-star'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082458703597614427.4416)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082517678315623391.4416)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072678475712055.4416)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831649180083980462.4416)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780276458994154.4416)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1832884277947217587.4416)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1840861033969283097.4416)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917665913120940054.4416)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1990227023531717243.4416)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626406749381989.4416)
,p_theme_id=>1
,p_name=>'One Level Tabs.pt-br'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE# ',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626529080381989.4416)
,p_theme_id=>1
,p_name=>'Printer Friendly.pt-br'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(91626823864381990.4416)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(91632832228382001.4416)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(91636711305382010.4416)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(91638400927382012.4416)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(91638400927382012.4416)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(91641225667382016.4416)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641730492382017.4416)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641814330382017.4416)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(91642503902382024.4416)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>unistr('Caixa de Di\00E1logo Pesquisar')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Pesquisar'
,p_close_button_text=>'Fechar'
,p_next_button_text=>unistr('Pr\00F3ximo >')
,p_prev_button_text=>'< Anterior'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91641910982382018.4416)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642102481382020.4416)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642303533382020.4416)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282172278859870938)
,p_name=>'2DCOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna em 2D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282174553287870940)
,p_name=>'2DCOLUMN_LINE'
,p_message_language=>'pt-br'
,p_message_text=>'Linha de Coluna em 2D'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282172409071870938)
,p_name=>'2DDOUGHNUT'
,p_message_language=>'pt-br'
,p_message_text=>'Anel em 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282174352220870939)
,p_name=>'2DHSTACKED_PCT'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna em 2D Horizontal Sobreposta (Percentual)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282172569974870938)
,p_name=>'2DLINE'
,p_message_language=>'pt-br'
,p_message_text=>'Linha em 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282172694820870938)
,p_name=>'2DPIE'
,p_message_language=>'pt-br'
,p_message_text=>'Pizza em 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282174143459870939)
,p_name=>'2DSTACKED_PCT'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna em 2D Sobreposta (Percentual)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282172790643870939)
,p_name=>'3DCOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna em 3D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282174445570870940)
,p_name=>'3DHSTACKED_PCT'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna em 3D Horizontal Sobreposta (Percentual)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282172827864870939)
,p_name=>'3DPIE'
,p_message_language=>'pt-br'
,p_message_text=>'Pizza em 3D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282174248907870939)
,p_name=>'3DSTACKED_PCT'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna em 3D Sobreposta (Percentual)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283070107334871517)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('0 Item para inser\00E7\00E3o no Dicion\00E1rio de Atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283069902666871517)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('0 Item para atualiza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283070327579871517)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('0 Item para atualiza\00E7\00E3o do Dicion\00E1rio de Atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283070754190871517)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('0 Coluna do Relat\00F3rio para inser\00E7\00E3o no Dicion\00E1rio de Atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283070950642871517)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('0 Coluna do Relat\00F3rio para atualiza\00E7\00E3o do Dicion\00E1rio de Atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283069804521871517)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Revisar %0 Itens para atualiza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283070516888871517)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('0 Coluna do Relat\00F3rio para atualiza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283070027921871517)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Revisar %0 Itens para inser\00E7\00E3o no Dicion\00E1rio de Atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283070271226871517)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Revisar %0 Itens para atualiza\00E7\00E3o do Dicion\00E1rio de Atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283070646552871517)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Revisar %0 Colunas do Relat\00F3rio para inser\00E7\00E3o no Dicion\00E1rio de Atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283070490328871517)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Revisar %0 Colunas do Relat\00F3rio para atualiza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283070840453871517)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Revisar %0 Colunas do Relat\00F3rio para atualiza\00E7\00E3o do Dicion\00E1rio de Atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282760611922871318)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O valor deve ser num\00E9rico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282745194669871308)
,p_name=>'4000_639_SEQ_MESG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<span class="fielddata"> N\00E3o \00E9 poss\00EDvel reordenar porque as sequ\00EAncias da Regi\00E3o n\00E3o s\00E3o \00FAnicas.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282745276359871308)
,p_name=>'4000_641_SEQ_MESG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<span class="fielddata">N\00E3o \00E9 poss\00EDvel reordenar porque as sequ\00EAncias do Bot\00E3o n\00E3o s\00E3o \00FAnicas.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282745375724871308)
,p_name=>'4000_646_SEQ_MESG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<span class="fielddata">N\00E3o \00E9 poss\00EDvel reordenar porque as sequ\00EAncias da Barra de Navega\00E7\00E3o n\00E3o s\00E3o \00FAnicas.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282745451233871308)
,p_name=>'4000_749_SEQ_MESG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<span class="fielddata">N\00E3o \00E9 poss\00EDvel reordenar porque as sequ\00EAncias do Item da Regi\00E3o n\00E3o s\00E3o \00FAnicas.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282825099492871359)
,p_name=>'4000_APPLICATION_ID'
,p_message_language=>'pt-br'
,p_message_text=>'ID do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282316775095871031)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Aplicativo: %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282716770333871287)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O formato de data especificado \00E9 inv\00E1lido. O calend\00E1rio requer uma data no formato AAAAMMDD.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282765859532871321)
,p_name=>'4000_TREE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rvore')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282825166106871359)
,p_name=>'4000_WORKSPACE_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ID do Espa\00E7o de Trabalho')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282597804411871212)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Informe o nome do novo esquema a ser criado.  Escolha',
unistr('         uma senha para o esquema e tamb\00E9m o padr\00E3o tablespace'),
unistr('         e o tablespace tempor\00E1rio.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282597979432871212)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_language=>'pt-br'
,p_message_text=>'Informe o nome do esquema existente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282598018056871212)
,p_name=>'4050_106_WHEN_DONE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Quando tiver terminado, clique no bot\00E3o "Pr\00F3ximo &gt;"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282491062569871142)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_language=>'pt-br'
,p_message_text=>'Eliminar tablespaces e arquivos de dados associados: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282490917671871142)
,p_name=>'4050_110_DROP_USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Eliminar usu\00E1rios do banco de dados: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283403621692871742)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Entradas de Log da Atividade do Servi\00E7o Web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282591280254871207)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas de log de atividade do desenvolvedor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282209803612870962)
,p_name=>'4050_31_LOG_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas do Log de Acesso ao Log-in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282590786477871207)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00F5es de Altera\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282590880826871207)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00F5es de Runtime')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282590508176871207)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00F5es de Espa\00E7o de Trabalho')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282593262320871209)
,p_name=>'4050_46_AD_HOC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Entradas de hist\00F3rico no Processador do Comando SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282593129448871209)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Entradas de log de execu\00E7\00E3o de Arquivo de Controle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282593064305871209)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Entradas de log de execu\00E7\00E3o de Arquivo de Script')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282593370846871209)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas de Arquivos SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282595324090871210)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informa\00E7\00F5es sobre Log Ativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282595407867871210)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero de Log Atual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282595569840871210)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_language=>'pt-br'
,p_message_text=>'Timestamp do Log Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282596174857871210)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Horas at\00E9 a pr\00F3xima altern\00E2ncia de log')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282595729512871210)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>'Intervalo em dias (constante)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282596005956871210)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3xima altern\00E2ncia de log programada para')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282596445916871211)
,p_name=>'4050_70_DEV_ACT'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas de log de atividade do desenvolvedor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282596625964871211)
,p_name=>'4050_71_CLICK'
,p_message_language=>'pt-br'
,p_message_text=>'Clique nas entradas de log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282597450171871211)
,p_name=>'4050_75_AD_HOC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Entradas de hist\00F3rico no Processador do Comando SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282597334742871211)
,p_name=>'4050_75_CTRL_FILE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Entradas de log de execu\00E7\00E3o de Arquivo de Controle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282597154477871211)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Entradas de log de execu\00E7\00E3o de Arquivo de Script')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282597524199871211)
,p_name=>'4050_75_SQL_ARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas de Arquivos SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282597648496871211)
,p_name=>'4050_82_WORKSPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Espa\00E7o de Trabalho %1 tem %2 aplicativos e %3 usu\00E1rio(s).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282597790561871211)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas do log de Contagem de Cliques'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282795847363871340)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativos de Produtividade e Amostra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282795942675871340)
,p_name=>'4050_PACKAGED_WEBSHEETS'
,p_message_language=>'pt-br'
,p_message_text=>'Websheets de Amostra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282795194666871340)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Contagem do Espa\00E7o de Trabalho')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282335433158871043)
,p_name=>'4150_COLUMN_NUMBER'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna %0'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282519197704871161)
,p_name=>'4350_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282519265429871161)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Aplicativo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282224912472870972)
,p_name=>'4500 800 HD DBA'
,p_message_language=>'pt-br'
,p_message_text=>'Oracle Database Express Edition 2 Day DBA.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282225004481870972)
,p_name=>'4500 800 HD DEV'
,p_message_language=>'pt-br'
,p_message_text=>'Oracle Database Express Edition 2 Day Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282224897966870972)
,p_name=>'4500 800 HD HTMLDB'
,p_message_language=>'pt-br'
,p_message_text=>'Oracle Application Express 2 Day Plus Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282225109201870972)
,p_name=>'4500 800 HD JAVA'
,p_message_language=>'pt-br'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus Java Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282225290609870972)
,p_name=>'4500 800 HD NET'
,p_message_language=>'pt-br'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus .NET Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282225366681870972)
,p_name=>'4500 800 HD PHP'
,p_message_language=>'pt-br'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus PHP Developer.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282225471398870972)
,p_name=>'4500 800 MSG DBA'
,p_message_language=>'pt-br'
,p_message_text=>'Trata de tarefas administrativas rotineiras.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282225525611870972)
,p_name=>'4500 800 MSG DEV'
,p_message_language=>'pt-br'
,p_message_text=>'Explica como tirar proveito do ambiente de desenvolvimento Oracle Database Express Edition.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282225640090870972)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Oferece uma s\00E9rie de tutoriais que descrevem como criar aplicativos Web centrados no banco de dados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282225895226870972)
,p_name=>'4500 800 MSG JAVA'
,p_message_language=>'pt-br'
,p_message_text=>'Este documento fornece um tutorial que mostra como usar Java e JDBC para conectar o Oracle Database XE, e demonstra como desenvolver um aplicativo Java simples que acessa e modifica dados.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282225937818870972)
,p_name=>'4500 800 MSG NET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este documento descreve os principais recursos do Oracle Data Provider for .NET e do Oracle Developer Tools for Visual Studio .NET. Ele conduz o usu\00E1rio durante a instala\00E7\00E3o e a configura\00E7\00E3o, mostra como criar aplicativos b\00E1sicos usando o Oracle Data')
||' Provider for .NET e o Oracle Developer Tools for Visual Studio .NET, e mostra como usar procedimentos PL/SQL e procedimentos armazenados .NET.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282225714507870972)
,p_name=>'4500 800 MSG PHP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este documento fornece um tutorial que mostra como fazer download e instalar drivers Apache e Zend Core PHP, e como usar PHP para conectar o Oracle Database XE. Tamb\00E9m mostra como usar PHP para desenvolver um aplicativo simples que acessa e modifica ')
||'dados.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282195616459870953)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_language=>'pt-br'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282195503190870953)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282195860431870953)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Condi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282654582477871248)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282196224963870953)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282196325644870953)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_language=>'pt-br'
,p_message_text=>'Agrupar por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282195705973870953)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_language=>'pt-br'
,p_message_text=>'Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282196101743870953)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282195978019870953)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de Classifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282196045299870953)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ordem de Classifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282199429798870955)
,p_name=>'4500_1002_QB_JOIN'
,p_message_language=>'pt-br'
,p_message_text=>'Join'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282192938668870951)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_language=>'pt-br'
,p_message_text=>'Clique aqui para selecionar uma coluna para join.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282199833719870956)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 poss\00EDvel selecionar no m\00E1ximo 60 colunas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282192808380870951)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Remover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282192795296870951)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar/Ocultar Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282199531509870956)
,p_name=>'4500_1002_QB_TO'
,p_message_language=>'pt-br'
,p_message_text=>'para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282191169908870950)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_language=>'pt-br'
,p_message_text=>'Resultados de %0, executar %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282491279973871142)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>'Retornar para Consulta Original'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282207179182870960)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 primeiras colunas exibidas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282684295524871267)
,p_name=>'4500_SESS_EVENT'
,p_message_language=>'pt-br'
,p_message_text=>'Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282684105977871267)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_language=>'pt-br'
,p_message_text=>'Kilobytes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282684053508871266)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_language=>'pt-br'
,p_message_text=>'Megabytes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282228809506870974)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os Padr\00F5es da Interface do Usu\00E1rio s\00E3o usados pelo Application Builder para preencher os valores iniciais das propriedades de item e de regi\00E3o, proporcionando consist\00EAncia entre v\00E1rias p\00E1ginas de um ou de v\00E1rios aplicativos.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282273201703871002)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Este aplicativo requer que os cookies estejam ativados.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282273197165871002)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Este aplicativo requer que o JavaScript esteja ativado.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282464819686871125)
,p_name=>'4800_9015_UPDATE_OVERDUE_FEATURES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 recurso(s) vencido(s) ser\00E1(\00E3o) atualizado(s) para o novo marco selecionado.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282715069064871286)
,p_name=>'ABOUT'
,p_message_language=>'pt-br'
,p_message_text=>'Sobre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283475858275871792)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Confirme a adi\00E7\00E3o dos seguintes %0 usu\00E1rios ao seu espa\00E7o de trabalho.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282727436153871294)
,p_name=>'ACCEPTED'
,p_message_language=>'pt-br'
,p_message_text=>'Aceito'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282693878461871273)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_language=>'pt-br'
,p_message_text=>'Favorecido de Acessibilidade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282691951444871271)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_language=>'pt-br'
,p_message_text=>'Impacto de Acessibilidade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282694391332871273)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_language=>'pt-br'
,p_message_text=>'Status de Acessibilidade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283554974217871846)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_language=>'pt-br'
,p_message_text=>'Acessibilidade Testada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282205967256870960)
,p_name=>'ACCESS_CONTROL_ADMIN'
,p_message_language=>'pt-br'
,p_message_text=>'Administrador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282365387216871062)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Direitos de Administra\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282204465389870959)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina de Administra\00E7\00E3o de Controle de Acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282643047555871240)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_language=>'pt-br'
,p_message_text=>'Administrador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282754168273871313)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atribui\00E7\00E3o designada a administradores de aplicativos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282204684794870959)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Administra\00E7\00E3o de Aplicativos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282205210453870959)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_language=>'pt-br'
,p_message_text=>'Modo de Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282205139832870959)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Identifique como o acesso a este aplicativo ser\00E1 controlado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282206456805870960)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel processar solicita\00E7\00E3o de defini\00E7\00E3o de modo de aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282206522866870960)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Modo de Aplicativo Definido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282366225319871062)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA n\00E3o pode excluir voc\00EA mesmo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282366321537871062)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA n\00E3o pode remover privil\00E9gio de administrador de si mesmo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282204544943870959)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282642980992871240)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Direitos de Contribui\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282643111221871240)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_language=>'pt-br'
,p_message_text=>'Colaborador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282754276674871314)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atribui\00E7\00E3o designada a colaboradores de aplicativos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282686671424871268)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A(s) seguinte(s) Defini\00E7\00E3o(\00F5es) do Aplicativo ser\00E1(\00E3o) criada(s):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282643224273871240)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('As seguintes Atribui\00E7\00F5es de Acesso de Aplicativo ser\00E3o criadas:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282222081744870970)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O(s) seguinte(s) Esquema(s) de Autoriza\00E7\00E3o ser\00E3(\00E3o) criado(s):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282295796832871017)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel criar a p\00E1gina de controle de acesso. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282295684565871017)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel criar tabelas de controle de acesso. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282368828529871064)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel informar um nome do usu\00E1rio duplicado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282365419207871062)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_language=>'pt-br'
,p_message_text=>'controle de acesso - editar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282206145957870960)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informe crit\00E9rios de consulta sem distin\00E7\00E3o entre mai\00FAsculas e min\00FAsculas e pressione o bot\00E3o <b>Ir</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282206230733870960)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel obter o modo de administra\00E7\00E3o do aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282206041368870960)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltima Modifica\00E7\00E3o por')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282205585642870959)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_language=>'pt-br'
,p_message_text=>'Lista de Controle de Acesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282204734138870959)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Acesso total a todos, lista de controle de acesso n\00E3o utilizada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282204855231870959)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Acesso restrito. Somente usu\00E1rios definidos na lista de controle de acesso t\00EAm permiss\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282204965847870959)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Somente leitura p\00FAblica. Privil\00E9gios de edi\00E7\00E3o e administra\00E7\00E3o controlados por lista de controle de acesso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282205059204870959)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_language=>'pt-br'
,p_message_text=>'Somente acesso administrativo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282206376421870960)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o h\00E1 privil\00E9gio na tentativa de executar a\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282205870210870960)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Privil\00E9gio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282686551095871268)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_language=>'pt-br'
,p_message_text=>'Direitos do Leitor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282686446498871268)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_language=>'pt-br'
,p_message_text=>'Leitor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282754378954871314)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atribui\00E7\00E3o designada a leitores de aplicativos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282222881559870970)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Identifica nomes de usu\00E1rios que correspondam ao esquema de autentica\00E7\00E3o deste aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282205314992870959)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_language=>'pt-br'
,p_message_text=>'Definir Modo de Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282323858640871035)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('As p\00E1ginas de controle de acesso foram criadas com sucesso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282205711759870960)
,p_name=>'ACCESS_CONTROL_USERNAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282643345066871240)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usar Atribui\00E7\00E3o de Controle de Acesso Existente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282222742143870970)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usar Esquema de Autoriza\00E7\00E3o Existente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282221999021870970)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Usar Tabela Existente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282365525905871062)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_language=>'pt-br'
,p_message_text=>'controle de acesso - exibir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282655217049871248)
,p_name=>'ACCESS_DENIED_SIMPLE'
,p_message_language=>'pt-br'
,p_message_text=>'Acesso Negado'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282226275521870973)
,p_name=>'ACCOUNT_CREATED'
,p_message_language=>'pt-br'
,p_message_text=>'Conta Criada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282349164088871051)
,p_name=>'ACCOUNT_HAS_BEEN_CREATED'
,p_message_language=>'pt-br'
,p_message_text=>'Sua conta %0 foi criada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282223671106870971)
,p_name=>'ACCOUNT_LOCKED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A conta est\00E1 bloqueada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283016273994871482)
,p_name=>'ACCOUNT_MENU'
,p_message_language=>'pt-br'
,p_message_text=>'Menu da Conta'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282673727946871260)
,p_name=>'ACKNOWLEDGED'
,p_message_language=>'pt-br'
,p_message_text=>'Confirmado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282673937739871260)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Confirmado, nenhuma a\00E7\00E3o')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282737813488871301)
,p_name=>'ACL_ADD_USER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283406445087871744)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_language=>'pt-br'
,p_message_text=>'Painel de Acesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283406509181871744)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_language=>'pt-br'
,p_message_text=>'Atividade do Monitor de Acesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283405664878871744)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar/Modificar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283406371666871744)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Administra\00E7\00E3o ao Executar o Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283404879207871743)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Administra\00E7\00E3o no Application Builder')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283405585557871744)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Anota\00E7\00F5es (arquivos, tags, observa\00E7\00F5es)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283404568190871743)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_language=>'pt-br'
,p_message_text=>unistr(' Autentica\00E7\00E3o da Conta do Application Express sem Lista de Controle de Acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283404427377871743)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Autentica\00E7\00E3o com Lista de Controle de Acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283405238603871743)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Acesso de SQL e Objetos Sugeridos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283409548518871746)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Depois de autenticado em um aplicativo, o controle de acesso especifica o que os usu\00E1rios podem fazer no aplicativo. A tabela abaixo identifica quais tipos de recursos diferentes os usu\00E1rios ter\00E3o com base na autentica\00E7\00E3o que est\00E1 sendo usada no apli')
||'cativo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283406600654871744)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_language=>'pt-br'
,p_message_text=>'Manter Lista de Controle de Acesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283405335838871743)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>'Executar e Exibir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283405079471871743)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar Propriedades do Aplicativo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283064747523871513)
,p_name=>'ACTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283403935490871743)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es do Menu A\00E7\00E3o')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282237365766870980)
,p_name=>'ACTIVE'
,p_message_language=>'pt-br'
,p_message_text=>'Ativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282650898131871245)
,p_name=>'ACTIVITY'
,p_message_language=>'pt-br'
,p_message_text=>'Atividade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282695374537871274)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Resumo da Atividade',
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282930831993871427)
,p_name=>'ADDED_BY'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionado Por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283401418627871741)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionado \00E0 Lista de Expurga\00E7\00E3o')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283050413577871504)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informa\00E7\00F5es adicionais solicitadas')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282605015165871216)
,p_name=>'ADD_ARGUEMENT'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Argumento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282595187831871210)
,p_name=>'ADD_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282811388531871350)
,p_name=>'ADD_COLUMN_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Coluna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282453125069871118)
,p_name=>'ADD_CONSTRAINT'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Constraint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282592929320871208)
,p_name=>'ADD_MORE...'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Mais...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282665785054871255)
,p_name=>'ADD_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282818827086871355)
,p_name=>'ADD_USER_INTERFACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Interface do Usu\00E1rio')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282822472826871357)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ajuste o espa\00E7o provisionado em %0 megabytes')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282591472835871208)
,p_name=>'ADMIN'
,p_message_language=>'pt-br'
,p_message_text=>'Admin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282217689909870967)
,p_name=>'ADMINISTRATOR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Administrador de Espa\00E7os de Trabalho')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282695121653871273)
,p_name=>'ADMINISTRATORS'
,p_message_language=>'pt-br'
,p_message_text=>'Administradores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282598787983871212)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_language=>'pt-br'
,p_message_text=>'O e-mail dos administradores deve ser fornecido'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282762870677871319)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_language=>'pt-br'
,p_message_text=>'Acessibilidade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282253261692870990)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282253528761870990)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_language=>'pt-br'
,p_message_text=>'Desempenho'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282253637434870990)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_language=>'pt-br'
,p_message_text=>'Controle de Qualidade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282253373649870990)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Seguran\00E7a')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282253716977870990)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_language=>'pt-br'
,p_message_text=>'Usabilidade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282253435111870990)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Advert\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282896194224871404)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Item "%1" est\00E1 protegido e n\00E3o pode ser definido por uma chamada Ajax.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282896218498871405)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Item "%1" est\00E1 protegido e n\00E3o pode ser definido por uma chamada Ajax.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282928175711871425)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Item "%1" est\00E1 protegido e n\00E3o pode ser definido por uma chamada Ajax.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282284031578871010)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prefixo do esquema SYS n\00E3o encontrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283106074966871540)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_language=>'pt-br'
,p_message_text=>'Uso de APIs WWV_FLOW (use APIs APEX em seu lugar)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283046140019871501)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A coluna %0 n\00E3o existe na Instru\00E7\00E3o SQL de Origem da Regi\00E3o!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282263541880870996)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A coluna do Relat\00F3rio Interativo %0 n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282261276112870995)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282229695138870975)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A coluna %0 n\00E3o existe na Instru\00E7\00E3o SQL de Origem da Regi\00E3o!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283140671392871563)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A coluna %0 do Form Tabular n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282261368023870995)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o pode ser referenciado como nome do item do aplicativo ou p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283481899365871796)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O processo do aplicativo Ajax Callback n\00E3o \00E9 protegido por um esquema de autoriza\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283481453828871796)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A p\00E1gina n\00E3o \00E9 protegida por um esquema de autoriza\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282262258168870995)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A p\00E1gina de destino %1 (no aplicativo %0) possui um esquema de autoriza\00E7\00E3o definido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283483512390871797)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A autoriza\00E7\00E3o desta p\00E1gina \00E9 diferente da autoriza\00E7\00E3o "%1" da p\00E1gina pai %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282262316948870996)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A autoriza\00E7\00E3o "%0" na p\00E1gina de destino \00E9 diferente de "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282260856809870995)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282260733773870995)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o foi poss\00EDvel executar a verifica\00E7\00E3o de sintaxe da vari\00E1vel de bind. Erro: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282260986088870995)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o pode ser referenciado com a sintaxe da vari\00E1vel de bind.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282262914071870996)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ramifica\00E7\00E3o incondicional antes de outras ramifica\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283481216191871795)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O recurso de preenchimento autom\00E1tico \00E9 definido para "Ativado" em uma p\00E1gina que cont\00E9m itens de senha.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283481393389871795)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_language=>'pt-br'
,p_message_text=>'O "Cache" permite que o browser armazene dados confidenciais no cache.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283366295581871717)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('"Incorporar em Quadros" deixa o aplicativo vulner\00E1vel a ataques de "clickjacking".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283366359117871717)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O "Modo de Escape HTML" s\00F3 cria escape em um conjunto limitado de caracteres.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282187449871870948)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('ID encontrado nos Atributos do Bot\00E3o, para um bot\00E3o referenciado em uma A\00E7\00E3o Din\00E2mica (%0). '),
'',
unistr('Quando um ID for definido nos Atributos do Bot\00E3o, isso far\00E1 com que as A\00E7\00F5es Din\00E2micas que referenciam o bot\00E3o n\00E3o funcionem. Tente remover esse ID, pois o bot\00E3o gerar\00E1 um ID por padr\00E3o.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282187599173870948)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('O Modelo usado por um bot\00E3o, que ele pr\00F3prio \00E9 referenciado em uma A\00E7\00E3o Din\00E2mica (%0) n\00E3o cont\00E9m a string de substitui\00E7\00E3o #BUTTON_ID#.'),
'',
'Modelo:',
'%1',
'',
unistr('Recomenda-se adicionar a string de substitui\00E7\00E3o #BUTTON_ID# a esse modelo ou alterar o modelo de bot\00E3o para um que inclua a string de substitui\00E7\00E3o #BUTTON_ID#.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282190144265870950)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A ''A\00E7\00E3o'' do bot\00E3o n\00E3o \00E9 ''Definido por A\00E7\00E3o Din\00E2mica'', para um bot\00E3o referenciado em uma A\00E7\00E3o Din\00E2mica (%0).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282196871057870954)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O bot\00E3o (%0) tem uma a\00E7\00E3o ''A\00E7\00E3o'' igual a ''Definido por A\00E7\00E3o Din\00E2mica'', mas n\00E3o h\00E1 A\00E7\00E3o Din\00E2mica correspondente que fa\00E7a refer\00EAncia a esse bot\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282764307169871320)
,p_name=>'ADVISOR.CHECK.CHART_TYPE_IS_ACCESSIBLE.MSG_ANYCHART_CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este \00E9 um tipo de gr\00E1fico AnyChart antigo. Use o recurso ''Upgrade de Aplicativo'' para migrar esse gr\00E1fico para o uso dos novos gr\00E1ficos baseados no Oracle JET, obtendo assim uma utiliza\00E7\00E3o e acessibilidade muito melhor.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282261960017870995)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A P\00E1gina Limpar Cache %0 n\00E3o \00E9 a p\00E1gina atual ou de destino %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282260673563870994)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283453418700871776)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_language=>'pt-br'
,p_message_text=>'Este valor de atributo tornou-se obsoleto.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283454937612871777)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Este tipo de componente tornou-se obsoleto.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282896302851871405)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_language=>'pt-br'
,p_message_text=>'Itens protegidos nas chamadas Ajax'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282283979304871010)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_language=>'pt-br'
,p_message_text=>'Code Smell (interno ao APEX)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282258750828870993)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Refer\00EAncias Declarativas de Itens do Aplicativo, Itens de P\00E1gina, Colunas ou Filtros de Relat\00F3rio Interativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283481129199871795)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Autoriza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282258456356870993)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Refer\00EAncias com Sintaxe da Vari\00E1vel de Bind')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282259827188870994)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ramifica\00E7\00E3o Incondicional antes de outras Ramifica\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283481621811871796)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de Seguran\00E7a do Browser')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282187381788870948)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O bot\00E3o n\00E3o \00E9 compat\00EDvel com A\00E7\00F5es Din\00E2micas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282196642835870954)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Refer\00EAncias inconsistentes entre A\00E7\00F5es Din\00E2micas e Bot\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282764122426871320)
,p_name=>'ADVISOR.CHECK.DESC_CHART_TYPE_IS_ACCESSIBLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O tipo de gr\00E1fico suporta acessibilidade')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282259067713870993)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O N\00FAmero da P\00E1gina Limpar Cache \00E9 igual \00E0 P\00E1gina de Destino ou Atual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282258329217870993)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Refer\00EAncias com Sintaxe da Coluna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283453387289871776)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_language=>'pt-br'
,p_message_text=>'Valores de atributos obsoletos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282259323031870994)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os Processos de Extra\00E7\00E3o, DML, MR* s\00E3o V\00E1lidos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282259760270870994)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_language=>'pt-br'
,p_message_text=>'ID do Aplicativo com Hardcode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282670376879871258)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Item de P\00E1gina tem Texto de Ajuda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282762682228871319)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A p\00E1gina tem t\00EDtulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282788789874871336)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_language=>'pt-br'
,p_message_text=>'O item Exibir Imagem tem o texto de imagem ALT definido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283366025171871717)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_language=>'pt-br'
,p_message_text=>'Os atributos do aplicativo que podem ser bloqueados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282258512968870993)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Item Referenciado est\00E1 na P\00E1gina Atual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282258615096870993)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Item Referenciado \00E9 o Item de P\00E1gina da P\00E1gina de Destino')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282763392070871319)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O item da p\00E1gina n\00E3o causa uma altera\00E7\00E3o de contexto inesperada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282764504299871320)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O item da p\00E1gina tem label')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282260055400870994)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_language=>'pt-br'
,p_message_text=>'Tamanho do Item ou do Nome da Coluna do Form Tabular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282258880147870993)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Refer\00EAncias de Item de P\00E1gina em uma String')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282258986154870993)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O N\00FAmero de P\00E1gina Referenciado Existe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282762943929871319)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A regi\00E3o tem Cabe\00E7alho de Linha')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282260248135870994)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Relat\00F3rio tem Ordem Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283481718801871796)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prote\00E7\00E3o de Estado de Sess\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282259433231870994)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Uso inapropriado da Sintaxe de Substitui\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282258263244870993)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Refer\00EAncias com Sintaxe de Substitui\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282259230754870994)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Autoriza\00E7\00E3o da P\00E1gina de Destino tamb\00E9m \00E9 definida para o Componente Atual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282763122208871319)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_language=>'pt-br'
,p_message_text=>'Estilo de Tema testado para verificar acessibilidade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282885029352871397)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Interface do Usu\00E1rio inclui JavaScript de compatibilidade')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282259945870870994)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Item ou Coluna de Valida\00E7\00F5es Associado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282259150542870994)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00F3digo SQL ou PL/SQL V\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282259614408870994)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_language=>'pt-br'
,p_message_text=>'Verificar Propriedade Clob'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282259527836870994)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00E3o V usada em Instru\00E7\00F5es SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282260105509870994)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bot\00E3o Referenciado em Quando o Bot\00E3o For Pressionado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282262572067870996)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro de compila\00E7\00E3o - %0 Instru\00E7\00E3o: %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282262841424870996)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O link cont\00E9m o ID do Aplicativo atual como um valor em hardcode.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282670259994871258)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum texto de ajuda definido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282762778130871319)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Essa p\00E1gina n\00E3o tem t\00EDtulo. T\00EDtulos significativos s\00E3o importantes para acessibilidade, ajudando os usu\00E1rios a entender o conte\00FAdo e o prop\00F3sito da p\00E1gina atual.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282788821027871336)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O item n\00E3o tem o texto alternativo obrigat\00F3rio para a imagem. Um bom texto deve descrever adequadamente o conte\00FAdo da imagem e n\00E3o deve duplicar qualquer informa\00E7\00E3o vis\00EDvel na p\00E1gina exibida no contexto da imagem (para evitar poss\00EDvel duplica\00E7\00E3o). Ob')
||unistr('serva\00E7\00E3o: se a imagem for fornecida pelos usu\00E1rios, tamb\00E9m dever\00E1 ter o texto alternativo, com a orienta\00E7\00E3o apropriada para ajudar os usu\00E1rios a fornecer um texto de alta qualidade.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283366137209871717)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O "Uso da API de Runtime" permite modifica\00E7\00E3o do aplicativo e do espa\00E7o de trabalho.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282261034401870995)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o \00E9 um item da p\00E1gina %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282261126010870995)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o \00E9 um item na p\00E1gina de destino %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282763400432871319)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A defini\00E7\00E3o ''A\00E7\00E3o da P\00E1gina na Sele\00E7\00E3o'' do item da p\00E1gina pode causar uma altera\00E7\00E3o inesperada de contexto para o usu\00E1rio. Tente alternar para ''Nenhum'' para que n\00E3o haja altera\00E7\00E3o de contexto e substitui\00E7\00E3o da funcionalidade por A\00E7\00F5es Din\00E2micas ou LO')
||unistr('Vs em Cascata (se voc\00EA precisar permanecer na mesma p\00E1gina). Se preferir, tente informar o usu\00E1rio para que ele saiba o que acontecer\00E1, por exemplo, adicionar ''Inicia uma nova p\00E1gina'' no label. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282788691344871336)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Um label para o item deve ser definido. Se voc\00EA preferir n\00E3o exibir um label vis\00EDvel, ainda assim defina um e depois selecione o modelo de label ''Oculto''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282764650458871320)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O item define um valor ''Marcador de Espa\00E7o de Valor'', mas nenhum label. O texto do marcador de espa\00E7o n\00E3o deve ser usado unicamente para identificar o item, j\00E1 que isso causa problemas de acessibilidade. Para melhor acessibilidade, um label do item d')
||unistr('eve ser definido. Se voc\00EA preferir n\00E3o exibir um label vis\00EDvel, ainda assim defina um label e depois selecione o modelo de label ''Oculto''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282263267139870996)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O nome tem %0 caracteres, mas deve ter no m\00E1ximo 30.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282261480229870995)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 pode n\00E3o existir')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282261514500870995)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 pode n\00E3o ser um item de p\00E1gina ou aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282261844407870995)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A P\00E1gina Limpar Cache %1 (no aplicativo %0) n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282261693374870995)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A p\00E1gina %0 n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282261756424870995)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A P\00E1gina de Destino %1 (no aplicativo %0) n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282686714237871268)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esta regi\00E3o de Altern\00E2ncia de Coluna n\00E3o tem uma coluna com a op\00E7\00E3o ''Usar como Cabe\00E7alho de Linha'' definida como ''Sim''. A coluna Cabe\00E7alho de Linha deve ser a coluna que melhor identifica a linha atual (por exemplo, o nome do cliente em um relat\00F3rio ')
||unistr('de informa\00E7\00F5es do cliente).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282686848508871268)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esta regi\00E3o de Reflow n\00E3o tem uma coluna com a op\00E7\00E3o ''Usar como Cabe\00E7alho de Linha'' definida como ''Sim''. A coluna Cabe\00E7alho de Linha deve ser a coluna que melhor identifica a linha atual (por exemplo, o nome do cliente em um relat\00F3rio de informa\00E7\00F5es ')
||'do cliente).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282763031544871319)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Essa regi\00E3o de Formato Tabular n\00E3o tem uma coluna com "Usar como Cabe\00E7alho de Linha" definido como Sim. A coluna Cabe\00E7alho de Linha deve ser aquela que melhor identifique a linha atual (por exemplo, um nome de cliente em uma tabela de informa\00E7\00F5es de ')
||unistr('clientes). Essas informa\00E7\00F5es ent\00E3o s\00E3o usadas ao renderizar o Formato Tabular para fornecer labels exclusivos para os campos de formato de cada linha.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282263490610870996)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O relat\00F3rio n\00E3o tem uma ordem padr\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283366446138871717)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A "Fun\00E7\00E3o Hash de Marcador" \00E9 definida como algoritmo legado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283366584261871717)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A "Prote\00E7\00E3o de Estado de Sess\00E3o" foi desativada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283481585700871796)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Em uma p\00E1gina com processo de extra\00E7\00E3o, voc\00EA deve usar a Prote\00E7\00E3o de Acesso \00E0 P\00E1gina e habilitar a prote\00E7\00E3o para os itens que voc\00EA passar por meio do URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282220138259870969)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A regi\00E3o cont\00E9m o URL "f?p" que n\00E3o passou pelo APEX_UTIL.PREPARE_URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282262692549870996)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Poss\00EDvel Inje\00E7\00E3o SQL detectada. %0 \00E9 usado com a sintaxe de substitui\00E7\00E3o em c\00F3digo SQL, PL/SQL ou nome da tabela de processos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282260474647870994)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282260591383870994)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o pode ser referenciado com a sintaxe de substitui\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282262435734870996)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A p\00E1gina de destino %1 (no aplicativo %0) tem um esquema de autoriza\00E7\00E3o definido, mas o componente atual n\00E3o est\00E1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282763213139871319)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Estilo de Tema atual do aplicativo n\00E3o foi testado quanto \00E0 acessibilidade. Mude para um estilo que tenha a op\00E7\00E3o Acessibilidade Testada definida como Sim, ou se seu Estilo de Tema atual tiver sido testado, defina seu atributo Acessibilidade Testad')
||unistr('a como Sim nas defini\00E7\00F5es do Tema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282885272361871397)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('A Interface do Usu\00E1rio inclui o jQuery Migrate. Ele ajuda na migra\00E7\00E3o para uma vers\00E3o mais nova do jQuery restaurando APIs removidas e mostra advert\00EAncias na console do browser quando s\00E3o utilizadas APIs removidas ou obsoletas. Isso inclui um arquivo')
||unistr(' JavaScript extra em cada p\00E1gina de seu aplicativo. Para ajudar a remover isso, revise o guia de upgrade do jQuery Migrate para obter detalhes das APIs que devem ser alteradas; depois, quando voc\00EA tiver certeza de que n\00E3o depende mais de nenhuma dess')
||unistr('as APIs, defina Incluir jQuery Migrate como N\00E3o.'),
'',
'https://github.com/jquery/jquery-migrate'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282885103740871397)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Interface do Usu\00E1rio inclui fun\00E7\00F5es JavaScript Obsoletas ou N\00E3o Suportadas. Isso inclui um arquivo JavaScript extra em cada p\00E1gina de seu aplicativo. Para ajudar a remover isso, revise a se\00E7\00E3o ''Funcionalidades Obsoletas'' das Notas da Release, onde ')
||unistr('voc\00EA encontrar\00E1 instru\00E7\00F5es sobre como verificar depend\00EAncias para fun\00E7\00F5es obsoletas ou n\00E3o suportadas e providenciar para n\00E3o mais incluir isso em seu aplicativo.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282263125602870996)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Item ou Coluna Associado n\00E3o est\00E1 definido, mas seria exigido pela "Mensagem de Erro Local de Exibi\00E7\00E3o".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282263006753870996)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Item ou Coluna Associado n\00E3o \00E9 igual ao "%0" especificado na Express\00E3o de Valida\00E7\00E3o 1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282262074740870995)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro de compila\00E7\00E3o - %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282262158122870995)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nenhum c\00F3digo SQL ou PL/SQL definido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282260334906870994)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tem mais que 32767. Apenas os primeiros 32767 ser\00E3o verificados. Tamanho: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282262707961870996)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cont\00E9m a chamada de fun\00E7\00E3o V/NV/DV na instru\00E7\00E3o SQL (pode ser um problema de desempenho).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282263338731870996)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O bot\00E3o mencionado n\00E3o existe mais.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282656850117871249)
,p_name=>'AFTER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ap\00F3s')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282598171358871212)
,p_name=>'AGREEMENT_MISSING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Est\00E1 faltando o acordo')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282403095159871086)
,p_name=>'ALIAS'
,p_message_language=>'pt-br'
,p_message_text=>'Alias'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283109257621871542)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Permitir cria\00E7\00E3o do aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283026022570871488)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Permita a instala\00E7\00E3o de aplicativos de produtividade e amostra.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282861389947871382)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Permitir Uso de Servi\00E7os RESTful')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283109343137871542)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_language=>'pt-br'
,p_message_text=>'Permitir Uso do SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283109518881871542)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_language=>'pt-br'
,p_message_text=>'Permitir Uso do Team Development'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283109167518871542)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Permitir que o espa\00E7o de trabalho seja expurgado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283109466283871542)
,p_name=>'ALLOW_WEBSHEET_DEV'
,p_message_language=>'pt-br'
,p_message_text=>'Permitir Websheet Development'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282422330571871098)
,p_name=>'ALL_APPLICATIONS'
,p_message_language=>'pt-br'
,p_message_text=>'Todos os Aplicativos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282208127368870961)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_language=>'pt-br'
,p_message_text=>'- Tudo - '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282207909970870961)
,p_name=>'ALL_CATEGORIES'
,p_message_language=>'pt-br'
,p_message_text=>'Todas as Categorias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282208259522870961)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_language=>'pt-br'
,p_message_text=>'- Todas as Categorias -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283112209779871544)
,p_name=>'ALL_MILESTONES'
,p_message_language=>'pt-br'
,p_message_text=>'Todos os Marcos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282790220213871337)
,p_name=>'ALL_RELEASES'
,p_message_language=>'pt-br'
,p_message_text=>'Todas as Releases'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282428291561871102)
,p_name=>'ALL_STATIC_FILES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('todos os arquivos est\00E1ticos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282426805635871101)
,p_name=>'ALL_THEMES'
,p_message_language=>'pt-br'
,p_message_text=>'todos os temas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283133937990871558)
,p_name=>'ALL_TYPES'
,p_message_language=>'pt-br'
,p_message_text=>'Todos os Tipos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283134306017871559)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_language=>'pt-br'
,p_message_text=>'- Todos os Tipos -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282423447525871099)
,p_name=>'ALL_USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Todos os Usu\00E1rios')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283476097286871792)
,p_name=>'ALREADY_IN_ACL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O usu\00E1rio j\00E1 tem uma conta APEX')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283465906403871785)
,p_name=>'ALREADY_IN_WS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O usu\00E1rio j\00E1 existe no espa\00E7o de trabalho')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283426609434871758)
,p_name=>'ALWAYS'
,p_message_language=>'pt-br'
,p_message_text=>'Sempre'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282179675519870943)
,p_name=>'AM_PM'
,p_message_language=>'pt-br'
,p_message_text=>'AM / PM'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282673546641871260)
,p_name=>'ANALYSIS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 An\00E1lise')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282673669520871260)
,p_name=>'ANALYZE'
,p_message_language=>'pt-br'
,p_message_text=>'Analisar %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282812512709871351)
,p_name=>'ANALYZE_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Analisar usando o m\00E9todo %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282281230632871008)
,p_name=>'ANCHOR.SHOW_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar Tudo'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282425753711871100)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('bloco an\00F4nimo')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282268151370870999)
,p_name=>'ANSWERS'
,p_message_language=>'pt-br'
,p_message_text=>'Respostas'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282219834677870968)
,p_name=>'ANY_DEVELOPER'
,p_message_language=>'pt-br'
,p_message_text=>'(Qualquer Desenvolvedor)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283441735777871768)
,p_name=>'APEX.ACTIONS.TOGGLE'
,p_message_language=>'pt-br'
,p_message_text=>'Alternar %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283480917915871795)
,p_name=>'APEX.ACTIVE_STATE'
,p_message_language=>'pt-br'
,p_message_text=>'(Ativo)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283544533394871839)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Altera\00E7\00F5es no Aplicativo:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283544473351871839)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_language=>'pt-br'
,p_message_text=>'Hora:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283549241315871842)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_language=>'pt-br'
,p_message_text=>'%0 K'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283544656469871839)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Views de P\00E1gina: ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283066626292871515)
,p_name=>'APEX.AJAX_SERVER_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'A chamada do Ajax retornou o erro de servidor %0 para %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283364069055871716)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Uma chamada de API foi proibida.',
'Entre em contato com o administrador.',
unistr('Detalhes sobre este incidente est\00E3o dispon\00EDveis por meio do id de depura\00E7\00E3o "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282470700549871129)
,p_name=>'APEX.APPLICATION.ALIAS.NON_UNIQUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O alias do aplicativo "%0" n\00E3o pode ser convertido em um ID de aplicativo \00FAnico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282470837457871129)
,p_name=>'APEX.APPLICATION.ALIAS.NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O aplicativo com o alias "%0" n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282428493075871102)
,p_name=>'APEX.APPLICATION.ALIAS.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'ERR-1816 Erro inesperado ao converter o alias de aplicativo p_flow_alias_or_id (%0).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282297246001871018)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A chamada API "%0" n\00E3o \00E9 suportada na vers\00E3o %1 do Application Express. Detalhes sobre este incidente est\00E3o dispon\00EDveis por meio do id de depura\00E7\00E3o "%2".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282303951726871022)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNC.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar fun\00E7\00E3o de autentica\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282191521180870950)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar fun\00E7\00E3o de autentica\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283559344203871849)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.HOST_PREFIX_MISMATCH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Nome do Tenant %0 retornado pelo Oracle Cloud Identity Management n\00E3o foi autorizado pelo dom\00EDnio %1!<br/><a href="&LOGOUT_URL.">Fa\00E7a log-in novamente</a> e especifique um nome de tenant autorizado ou altere seu URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282184643528870946)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.USER_IS_NOT_DEVELOPER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sua conta "%0" n\00E3o tem os privil\00E9gios de desenvolvimento necess\00E1rios (DB_DEVELOPER ou DB_ADMINISTRATOR)<br/> para o espa\00E7o de trabalho "%1"! <a href="&LOGOUT_URL.">Fa\00E7a log-in novamente</a> ap\00F3s os privil\00E9gios serem fornecidos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282180055228870943)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.WRONG_GROUP_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Nome do Tenant retornado pelo Oracle Cloud Identity Management n\00E3o foi autorizado pelo espa\00E7o de trabalho atual! <br/><a href="&LOGOUT_URL.">re-login</a> e especifique um nome de tenant autorizado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282318227049871032)
,p_name=>'APEX.AUTHENTICATION.HEADER.DUPLICATE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('O cabe\00E7alho HTTP %0 foi enviado duas vezes. Isso pode ser um ataque.'),
'<ul>',
'<li>1o. valor: "%1"</li>',
'<li>2o. valor: "%2"</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282184849720870946)
,p_name=>'APEX.AUTHENTICATION.HOST_PREFIX_MISMATCH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Por motivos de seguran\00E7a, n\00E3o s\00E3o permitidos aplicativos em execu\00E7\00E3o deste espa\00E7o de trabalho por meio do dom\00EDnio do URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282303644176871022)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.ASK_FOR_INSTALLATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pe\00E7a ao DBA que execute $OH/rdbms/admin/catldap.sql.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282303501863871022)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.MISSING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O pacote SYS.DBMS_LDAP n\00E3o existe ou \00E9 inv\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282303424210871022)
,p_name=>'APEX.AUTHENTICATION.LDAP.EDIT_USER_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar fun\00E7\00E3o de edi\00E7\00E3o do usu\00E1rio LDAP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282303741422871022)
,p_name=>'APEX.AUTHENTICATION.LDAP.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar autentica\00E7\00E3o LDAP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282304908554871023)
,p_name=>'APEX.AUTHENTICATION.LOGIN.ILLEGAL_PAGE_ARG'
,p_message_language=>'pt-br'
,p_message_text=>'Erro no argumento p_flow_page para o procedimento log-in_page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282304448595871023)
,p_name=>'APEX.AUTHENTICATION.LOGIN.INVALID_ARG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('p_session inv\00E1lido em wwv_flow_custom_auth_std.log-in--p_flow_page:%0 p_session_id:%1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282304203840871023)
,p_name=>'APEX.AUTHENTICATION.LOGIN.MALFORMED_ARGS'
,p_message_language=>'pt-br'
,p_message_text=>'Argumento incorreto para wwv_flow_custom_auth_std.log-in--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282304664767871023)
,p_name=>'APEX.AUTHENTICATION.LOGIN.NULL_USER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome de usu\00E1rio nulo passado para o procedimento de log-in.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282204308924870959)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.COUNTER'
,p_message_language=>'pt-br'
,p_message_text=>'Aguarde <span id="apex_login_throttle_sec">%0</span> segundos para fazer log-in novamente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282209310492870962)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'A tentativa de log-in foi bloqueada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282644617709871241)
,p_name=>'APEX.AUTHENTICATION.NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Autentica\00E7\00E3o "%0" n\00E3o encontrada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282217905754870967)
,p_name=>'APEX.AUTHENTICATION.NO_SECURITY_GROUP_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O ID do grupo se seguran\00E7a \00E9 nulo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282304125431871022)
,p_name=>'APEX.AUTHENTICATION.POST_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao executar o processo de p\00F3s-autentica\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282303893243871022)
,p_name=>'APEX.AUTHENTICATION.PRE_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao executar o processo de pr\00E9-autentica\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282323302832871035)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD.INSTRUCTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Abra o URL no mesmo browser em que voc\00EA iniciou a solicita\00E7\00E3o Redefinir Senha.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283543783393871838)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD_URL'
,p_message_language=>'pt-br'
,p_message_text=>'Redefinir URL da Senha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282185066842870946)
,p_name=>'APEX.AUTHENTICATION.RM_GROUP_NOT_GRANTED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O grupo de consumidores do Resource Manager %0 n\00E3o foi concedido para %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282185191532870946)
,p_name=>'APEX.AUTHENTICATION.RM_INFO_TO_GRANT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Use DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP para conceder o privil\00E9gio n\00E3o encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282381183818871072)
,p_name=>'APEX.AUTHENTICATION.SESSION_SENTRY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar fun\00E7\00E3o de sentinela da sess\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282381220794871072)
,p_name=>'APEX.AUTHENTICATION.SESSION_VERIFY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar fun\00E7\00E3o de verifica\00E7\00E3o da sess\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282381472348871072)
,p_name=>'APEX.AUTHENTICATION.SSO.ASK_FOR_INSTALLATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pe\00E7a ao administrador do %0 que configure o mecanismo para o SSO do Oracle Application Server.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282457539775871120)
,p_name=>'APEX.AUTHENTICATION.SSO.BAD_URLC'
,p_message_language=>'pt-br'
,p_message_text=>'%0 ilegal no token %1 retornado por sso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282304803582871023)
,p_name=>'APEX.AUTHENTICATION.SSO.FIX_PARTNER_APP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Edite o esquema de autentica\00E7\00E3o e adicione o nome do aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282457185162871120)
,p_name=>'APEX.AUTHENTICATION.SSO.ILLEGAL_CALLER'
,p_message_language=>'pt-br'
,p_message_text=>'Chamador ilegal do procedimento %0:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282457382225871120)
,p_name=>'APEX.AUTHENTICATION.SSO.INVALID_APP_SESSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sess\00E3o de aplicativo inv\00E1lida em token de urlc: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282456964272871120)
,p_name=>'APEX.AUTHENTICATION.SSO.MISSING_APP_REGISTRATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro em portal_sso_redirect: faltando informa\00E7\00F5es de registro do aplicativo: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282381392054871072)
,p_name=>'APEX.AUTHENTICATION.SSO.PACKAGE_MISSING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O pacote WWSEC_SSO_ENABLER_PRIVATE n\00E3o existe ou \00E9 inv\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282304748418871023)
,p_name=>'APEX.AUTHENTICATION.SSO.PARTNER_APP_IS_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o foi poss\00EDvel localizar no esquema de autentica\00E7\00E3o o nome do aplicativo parceiro registrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282457017710871120)
,p_name=>'APEX.AUTHENTICATION.SSO.REGISTER_APP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Registre este aplicativo conforme descrito no guia de instala\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282381521939871072)
,p_name=>'APEX.AUTHENTICATION.SSO.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar autentica\00E7\00E3o SSO.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283460586625871781)
,p_name=>'APEX.AUTHENTICATION.UNAUTHORIZED_URL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('URL N\00E3o Autorizado:  %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282380930235871072)
,p_name=>'APEX.AUTHENTICATION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar autentica\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282184910876870946)
,p_name=>'APEX.AUTHENTICATION.WORKSPACE_NOT_ASSIGNED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Espa\00E7o de Trabalho "%0" est\00E1 inativo. Entre em contato com o administrador.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282186155859870947)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED'
,p_message_language=>'pt-br'
,p_message_text=>'%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282206832103870960)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Acesso negado pela verifica\00E7\00E3o de seguran\00E7a do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282206950638870960)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Acesso negado pela verifica\00E7\00E3o de seguran\00E7a da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282207019284870960)
,p_name=>'APEX.AUTHORIZATION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar autoriza\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282683840632871266)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# n\00E3o existe na lista.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283066216922871514)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('As ramifica\00E7\00F5es Somente para Exibi\00E7\00E3o n\00E3o ser\00E3o suportadas se o atributo de p\00E1gina "Recarregar ao Submeter" estiver definido como "Somente para \00CAxito".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282431201085871104)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar ramifica\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282751766241871312)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX'
,p_message_language=>'pt-br'
,p_message_text=>'Criado com %0 usando %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282751890334871312)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX.ACCESSIBLE.LOVE'
,p_message_language=>'pt-br'
,p_message_text=>'amor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282788416593871336)
,p_name=>'APEX.CALCULATOR.ICON_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Calculador de Popup: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283416570078871751)
,p_name=>'APEX.CALENDAR.EVENT_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Descri\00E7\00E3o do Evento')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283416365138871751)
,p_name=>'APEX.CALENDAR.EVENT_END'
,p_message_language=>'pt-br'
,p_message_text=>'Data Final'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283416607365871751)
,p_name=>'APEX.CALENDAR.EVENT_ID'
,p_message_language=>'pt-br'
,p_message_text=>'ID do Evento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283416244344871751)
,p_name=>'APEX.CALENDAR.EVENT_START'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Data de In\00EDcio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283416473492871751)
,p_name=>'APEX.CALENDAR.EVENT_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo do Evento')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282884591791871397)
,p_name=>'APEX.CLIPBOARD.COPIED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Copiado para a \00E1rea de transfer\00EAncia.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282877529361871392)
,p_name=>'APEX.CLIPBOARD.NOTSUP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este browser n\00E3o suporta c\00F3pia de um bot\00E3o ou menu. Tente Ctrl+C ou Comando+C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282753841829871313)
,p_name=>'APEX.CLOSE_NOTIFICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fechar Notifica\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282175653723870940)
,p_name=>'APEX.COLOR_PICKER.ICON_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Seletor Popup de Cores: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283529751573871829)
,p_name=>'APEX.COMBOBOX.LIST_OF_VALUES'
,p_message_language=>'pt-br'
,p_message_text=>'Lista de Valores'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283529846593871829)
,p_name=>'APEX.COMBOBOX.SHOW_ALL_VALUES'
,p_message_language=>'pt-br'
,p_message_text=>'Lista de abertura para: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283481018559871795)
,p_name=>'APEX.COMPLETED_STATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('(Conclu\00EDdo)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282186391286870947)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar c\00E1lculo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282408698009871089)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar condi\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282471377115871129)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de condi\00E7\00E3o desconhecido "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282436508132871107)
,p_name=>'APEX.CONTACT_ADMIN'
,p_message_language=>'pt-br'
,p_message_text=>'Entre em contato com o administrador do seu aplicativo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282518804150871160)
,p_name=>'APEX.CONTACT_ADMIN.DEBUG'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Entre em contato com o administrador do seu aplicativo.',
unistr('Os detalhes sobre este incidente est\00E3o dispon\00EDveis via id de depura\00E7\00E3o "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283403524403871742)
,p_name=>'APEX.CORRECT_ERRORS'
,p_message_language=>'pt-br'
,p_message_text=>'Corrija os erros antes de salvar.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283485235317871798)
,p_name=>'APEX.CURRENT_PROGRESS'
,p_message_language=>'pt-br'
,p_message_text=>'Andamento Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283104567357871539)
,p_name=>'APEX.DATA_HAS_CHANGED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A vers\00E3o atual dos dados contidos no banco de dados foi alterada desde que o usu\00E1rio iniciou o processo de atualiza\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282788381622871335)
,p_name=>'APEX.DATEPICKER.ICON_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Calend\00E1rio de Popup: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282797469038871341)
,p_name=>'APEX.DATEPICKER_VALUE_GREATER_MAX_DATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# \00E9 posterior \00E0 data m\00E1xima especificada %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282802747677871345)
,p_name=>'APEX.DATEPICKER_VALUE_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# n\00E3o corresponde ao formato %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282797396497871341)
,p_name=>'APEX.DATEPICKER_VALUE_LESS_MIN_DATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# \00E9 anterior \00E0 data m\00EDnima especificada %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282797575345871341)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# n\00E3o est\00E1 entre o intervalo v\00E1lido de %0 e %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282801094791871344)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_IN_YEAR_RANGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# n\00E3o est\00E1 dentro da faixa de anos v\00E1lida de %0 e %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283404215046871743)
,p_name=>'APEX.DIALOG.CANCEL'
,p_message_language=>'pt-br'
,p_message_text=>'Cancelar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283509948946871815)
,p_name=>'APEX.DIALOG.CLOSE'
,p_message_language=>'pt-br'
,p_message_text=>'Fechar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283514978659871818)
,p_name=>'APEX.DIALOG.HELP'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283404048066871743)
,p_name=>'APEX.DIALOG.OK'
,p_message_language=>'pt-br'
,p_message_text=>'OK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282615409344871223)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel renderizar a p\00E1gina da caixa de di\00E1logo %1 do aplicativo %0 com sucesso. Verifique se o modelo da p\00E1gina em uso na p\00E1gina %1 \00E9 do tipo "P\00E1gina da Caixa de Di\00E1logo", com inicializa\00E7\00E3o da caixa de di\00E1logo JavaScript apropriada, fechament')
||unistr('o de caixa de di\00E1logo e c\00F3digo de cancelamento de caixa de di\00E1logo definidos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283404130672871743)
,p_name=>'APEX.DIALOG.SAVE'
,p_message_language=>'pt-br'
,p_message_text=>'Salvar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283531693646871830)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Copyright \00A9 %0, Oracle. Todos os direitos reservados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283532428433871830)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar Espa\00E7o de Trabalho')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283531564078871830)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esta \00E9 uma mensagem gerada pelo sistema. N\00E3o responda.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283541344019871836)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_language=>'pt-br'
,p_message_text=>'Ambiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283553999436871845)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rio do Oracle Application Express')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283533097140871831)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conceitos B\00E1sicos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283531744131871830)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ol\00E1, %0,')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283532726614871831)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_language=>'pt-br'
,p_message_text=>'Senha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283541440731871837)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Impedir Expurga\00E7\00E3o do Espa\00E7o de Trabalho')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283532944584871831)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA pode impedir seu espa\00E7o de trabalho de ser expurgado, clicando no bot\00E3o abaixo e seguindo as instru\00E7\00F5es na tela. Se voc\00EA n\00E3o agir em %0 dia(s), seu espa\00E7o de trabalho ser\00E1 automaticamente removido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283541169755871836)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nenhuma a\00E7\00E3o ser\00E1 necess\00E1ria caso voc\00EA n\00E3o precise mais do seu espa\00E7o de trabalho.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283541652128871837)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Seu espa\00E7o de trabalho est\00E1 prestes a ser expurgado!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283540999577871836)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Seu espa\00E7o de trabalho %0 n\00E3o mostrou nenhuma atividade recente e est\00E1 programado para ser expurgado em breve.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283540855233871836)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Aviso! Seu espa\00E7o de trabalho "%0" est\00E1 prestes a ser expurgado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283541293562871836)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Data de Expurga\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283541962639871837)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conclua sua solicita\00E7\00E3o de espa\00E7o de trabalho.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283541746661871837)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Seu espa\00E7o de trabalho "%0" est\00E1 pronto!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283542000033871837)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Seu espa\00E7o de trabalho "%0" foi aprovado!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283541873720871837)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sua solicita\00E7\00E3o de espa\00E7o de trabalho foi recusada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283532313170871830)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283541589596871837)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Advert\00EAncia!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283532227183871830)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Espa\00E7o de Trabalho')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283531804510871830)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00E3o do Espa\00E7o de Trabalho Aprovada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283532511373871830)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Clique no bot\00E3o abaixo para concluir o processo de aprova\00E7\00E3o e definir sua senha.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283532095839871830)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sua solicita\00E7\00E3o do espa\00E7o de trabalho foi aprovada!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283532697530871831)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Clique no bot\00E3o abaixo para come\00E7ar.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283532873255871831)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Seu espa\00E7o de trabalho est\00E1 pronto!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283531960353871830)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00E3o do Espa\00E7o de Trabalho Recusada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283532144549871830)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Desculpe, sua solicita\00E7\00E3o do espa\00E7o de trabalho foi recusada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282431542743871104)
,p_name=>'APEX.ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282181817369870944)
,p_name=>'APEX.ERROR.CALLBACK_FAILED'
,p_message_language=>'pt-br'
,p_message_text=>'Ocorreu o seguinte erro ao executar o callback de tratamento de erro: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282222978750870970)
,p_name=>'APEX.ERROR.ERROR_PAGE.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ocorreu erro durante a pintura da p\00E1gina de erro: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282185608459870947)
,p_name=>'APEX.ERROR.INTERNAL'
,p_message_language=>'pt-br'
,p_message_text=>'Erro Interno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283474056346871790)
,p_name=>'APEX.ERROR.INTERNAL.CONTACT_ADMINISTRATOR'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Entre em contato com o administrador.',
unistr('Os detalhes sobre este incidente est\00E3o dispon\00EDveis via id de depura\00E7\00E3o "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283554804514871846)
,p_name=>'APEX.ERROR.ORA-28353'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ORA-28353: Falha ao abrir a wallet. Dados do aplicativo n\00E3o acess\00EDveis atualmente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283456279017871778)
,p_name=>'APEX.ERROR.PAGE_NOT_AVAILABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Desculpe, esta p\00E1gina n\00E3o est\00E1 dispon\00EDvel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282191464027870950)
,p_name=>'APEX.ERROR.TECHNICAL_INFO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informa\00E7\00F5es T\00E9cnicas (vis\00EDvel somente para desenvolvedores)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283019212086871484)
,p_name=>'APEX.ERROR_MESSAGE_HEADING'
,p_message_language=>'pt-br'
,p_message_text=>'Mensagem de Erro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283093199145871532)
,p_name=>'APEX.EXPECTED_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>'Formato esperado: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282816732489871354)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.ALREADY_IN_ACL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O usu\00E1rio j\00E1 est\00E1 na Lista de Controle de Acesso')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282816610646871354)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.CREATE_CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Confirme a adi\00E7\00E3o dos seguintes %0 usu\00E1rios <strong>%1</strong> \00E0 sua lista de controle de acesso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282817158488871354)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.DUPLICATE_USE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rio duplicado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282816871613871354)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_AT_SIGN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Falta uma arroba (@) no Endere\00E7o de e-mail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282816973300871354)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_DO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Falta um ponto (.) no Endere\00E7o de e-mail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282817018300871354)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.USERNAME_TOO_LONG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome do usu\00E1rio muito longo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282817331685871354)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_ONLY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Somente usu\00E1rios definidos na lista de controle de acesso do aplicativo podem acessar este aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282817473532871354)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_VALUE_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor de Defini\00E7\00E3o de Controle de Acesso Inesperado: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282817218606871354)
,p_name=>'APEX.FEATURE.ACL.INFO.ALL_USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Todos os usu\00E1rios autenticados podem acessar este aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283362831957871715)
,p_name=>'APEX.FEATURE.CONFIG.DISABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Desativado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283362714469871715)
,p_name=>'APEX.FEATURE.CONFIG.ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Ativado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283363803896871715)
,p_name=>'APEX.FEATURE.CONFIG.IS_DISABLED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0: Est\00E1 Desativado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283362945951871715)
,p_name=>'APEX.FEATURE.CONFIG.IS_ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0: Est\00E1 Ativado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282752536541871312)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_language=>'pt-br'
,p_message_text=>'Enfileirado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282752693665871312)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_language=>'pt-br'
,p_message_text=>'Enviado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283362605213871715)
,p_name=>'APEX.FEATURE.TOP_USERS.USERNAME.NOT_IDENTIFIED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o identificado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282216217938870966)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas de Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282216383490870966)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_language=>'pt-br'
,p_message_text=>'Abrir Entradas de Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282216449943870966)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283106288730871540)
,p_name=>'APEX.FILE_BROWSE.DOWNLOAD_LINK_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Fazer Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283099496233871536)
,p_name=>'APEX.FS.BATCH_APPLY'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283099998351871536)
,p_name=>'APEX.FS.CLEAR'
,p_message_language=>'pt-br'
,p_message_text=>'Limpar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283100087679871536)
,p_name=>'APEX.FS.CLEAR_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Limpar Tudo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283100164564871536)
,p_name=>'APEX.FS.CLEAR_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Limpar %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283430760988871761)
,p_name=>'APEX.FS.COLUMN_UNAUTHORIZED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A coluna %1, referenciada pela faceta %0, est\00E1 indispon\00EDvel ou n\00E3o est\00E1 autorizada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283423148322871755)
,p_name=>'APEX.FS.FACET_VALUE_LIMIT_EXCEEDED'
,p_message_language=>'pt-br'
,p_message_text=>'Limite de valor distinto (%0) excedido para a faceta %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283101689154871537)
,p_name=>'APEX.FS.FC_TYPE_UNSUPPORTED_FOR_DATE_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o h\00E1 suporte para a faceta %0 em colunas DATE ou TIMESTAMP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283099599175871536)
,p_name=>'APEX.FS.FILTER'
,p_message_language=>'pt-br'
,p_message_text=>'Filtrar %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283099611597871536)
,p_name=>'APEX.FS.GO'
,p_message_language=>'pt-br'
,p_message_text=>'Ir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283101201667871537)
,p_name=>'APEX.FS.INPUT_CURRENT_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'igual a %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283101463987871537)
,p_name=>'APEX.FS.NO_SEARCH_COLUMNS_PROVIDED'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhuma coluna de pesquisa foi fornecida para a faceta %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283100936707871537)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'%0 a %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283101012466871537)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_HI'
,p_message_language=>'pt-br'
,p_message_text=>'Acima de %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283101172272871537)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_LO'
,p_message_language=>'pt-br'
,p_message_text=>'Abaixo de %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283441587063871768)
,p_name=>'APEX.FS.RANGE_LOV_ITEM_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O item #%2 ("%1") da LOV para a faceta de intervalo %0 \00E9 inv\00E1lido (falta o separador "|").')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283101354524871537)
,p_name=>'APEX.FS.RANGE_MANUAL_NOT_SUPPORTED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('No momento n\00E3o h\00E1 suporte para Entrada Manual para a faceta de Faixa %0, pois a coluna \00E9 DATE ou TIMESTAMP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283100501044871537)
,p_name=>'APEX.FS.RANGE_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283099851925871536)
,p_name=>'APEX.FS.SEARCH_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283099706299871536)
,p_name=>'APEX.FS.SEARCH_PLACEHOLDER'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283100757236871537)
,p_name=>'APEX.FS.SELECT_PLACEHOLDER'
,p_message_language=>'pt-br'
,p_message_text=>'- Selecionar -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283100339064871536)
,p_name=>'APEX.FS.SHOW_LESS'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar Menos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283100471907871537)
,p_name=>'APEX.FS.SHOW_MORE'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar Mais'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283100642225871537)
,p_name=>'APEX.FS.STAR_RATING_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'%0 estrelas ou mais'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283101501514871537)
,p_name=>'APEX.FS.TEXT_FIELD_ONLY_FOR_NUMBER_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('No momento, s\00F3 h\00E1 suporte para a faceta %0 em colunas NUMBER.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283430956721871761)
,p_name=>'APEX.FS.UNSUPPORTED_DATA_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o h\00E1 suporte para o tipo de dados %0 (%1) na pesquisa facetada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283364411765871716)
,p_name=>'APEX.GO_TO_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Ir para o erro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282577354147871199)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O grupo "%0" n\00E3o foi encontrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282823221693871358)
,p_name=>'APEX.GV.AGG_CONTEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Agregar.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282931804011871427)
,p_name=>'APEX.GV.BREAK_COLLAPSE'
,p_message_language=>'pt-br'
,p_message_text=>'Contrair controle de quebra'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282823317960871358)
,p_name=>'APEX.GV.BREAK_CONTEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Quebra de controle.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282931738579871427)
,p_name=>'APEX.GV.BREAK_EXPAND'
,p_message_language=>'pt-br'
,p_message_text=>'Expandir controle de quebra'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283561072254871850)
,p_name=>'APEX.GV.COLUMN_CONTEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282931542560871427)
,p_name=>'APEX.GV.DELETED_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 linhas exclu\00EDdas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283520502244871822)
,p_name=>'APEX.GV.DUP_REC_ID'
,p_message_language=>'pt-br'
,p_message_text=>'Identidade duplicada'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282810209301871349)
,p_name=>'APEX.GV.FIRST_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Primeiro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282823515192871358)
,p_name=>'APEX.GV.GROUP_CONTEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cabe\00E7alho do grupo.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282823458606871358)
,p_name=>'APEX.GV.HEADER_CONTEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cabe\00E7alho.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282810357380871350)
,p_name=>'APEX.GV.LAST_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282972159358871453)
,p_name=>'APEX.GV.LOAD_MORE'
,p_message_language=>'pt-br'
,p_message_text=>'Carregar Mais Linhas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282810052736871349)
,p_name=>'APEX.GV.NEXT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282823634686871358)
,p_name=>'APEX.GV.PAGE_RANGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Linhas da p\00E1gina')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282810432722871350)
,p_name=>'APEX.GV.PAGE_RANGE_XY'
,p_message_language=>'pt-br'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282810517091871350)
,p_name=>'APEX.GV.PAGE_RANGE_XYZ'
,p_message_language=>'pt-br'
,p_message_text=>'%0 - %1 de %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282810134448871349)
,p_name=>'APEX.GV.PREV_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Anterior'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283520394157871822)
,p_name=>'APEX.GV.ROW_ADDED'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283520421258871822)
,p_name=>'APEX.GV.ROW_CHANGED'
,p_message_language=>'pt-br'
,p_message_text=>'Alterado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283560886085871850)
,p_name=>'APEX.GV.ROW_COLUMN_CONTEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Linha %0, Coluna %1.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283560967060871850)
,p_name=>'APEX.GV.ROW_CONTEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Linha %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283520251650871822)
,p_name=>'APEX.GV.ROW_DELETED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exclu\00EDdo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282852410604871376)
,p_name=>'APEX.GV.ROW_HEADER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cabe\00E7alho de linha')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282809359512871349)
,p_name=>'APEX.GV.SELECTION_CELL_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 c\00E9lulas selecionadas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282810666622871350)
,p_name=>'APEX.GV.SELECTION_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'%0 linhas selecionadas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283156097424871573)
,p_name=>'APEX.GV.SELECT_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Selecionar Tudo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282931699375871427)
,p_name=>'APEX.GV.SELECT_PAGE_N'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282852367636871376)
,p_name=>'APEX.GV.SELECT_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Selecionar Linha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282854951984871378)
,p_name=>'APEX.GV.SORTED_ASCENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Classificado em Ordem Crescente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282855079149871378)
,p_name=>'APEX.GV.SORTED_DESCENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Classificado em Ordem Decrescente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282809574836871349)
,p_name=>'APEX.GV.SORT_ASCENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Classificar por Ordem Crescente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282809855075871349)
,p_name=>'APEX.GV.SORT_ASCENDING_ORDER'
,p_message_language=>'pt-br'
,p_message_text=>'Classificar em Ordem Crescente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282809678348871349)
,p_name=>'APEX.GV.SORT_DESCENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Classificar por Ordem Decrescente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282809925235871349)
,p_name=>'APEX.GV.SORT_DESCENDING_ORDER'
,p_message_language=>'pt-br'
,p_message_text=>'Classificar em Ordem Decrescente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282809733847871349)
,p_name=>'APEX.GV.SORT_OFF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o Classificar')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282931422194871427)
,p_name=>'APEX.GV.TOTAL_PAGES'
,p_message_language=>'pt-br'
,p_message_text=>'%0 Total'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283494703964871805)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir Documenta\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283514234428871818)
,p_name=>'APEX.ICON_LIST.GRID_DIM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Lista de Sele\00E7\00E3o de Grade %0 colunas %1 linhas. Use as teclas de seta')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282930556789871427)
,p_name=>'APEX.ICON_LIST.LIST_DIM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Lista de Sele\00E7\00E3o %0 linhas. Use as teclas de seta.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283560633140871850)
,p_name=>'APEX.IG.ACC_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Grade Interativa %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282792799335871338)
,p_name=>'APEX.IG.ACTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00F5es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282793748614871339)
,p_name=>'APEX.IG.ADD'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282793691069871339)
,p_name=>'APEX.IG.ADD_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Linha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283528350998871828)
,p_name=>'APEX.IG.AGGREGATE'
,p_message_language=>'pt-br'
,p_message_text=>'Agregar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283491210214871802)
,p_name=>'APEX.IG.AGGREGATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Agrega\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283494281739871804)
,p_name=>'APEX.IG.ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Tudo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283051476729871505)
,p_name=>'APEX.IG.ALL_TEXT_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Todas as Colunas de Texto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283052665425871506)
,p_name=>'APEX.IG.ALTERNATIVE'
,p_message_language=>'pt-br'
,p_message_text=>'Alternativo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283053703518871506)
,p_name=>'APEX.IG.AND'
,p_message_language=>'pt-br'
,p_message_text=>'e'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283399772431871740)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem Aproximada de Itens Diferentes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283529325279871828)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT_OVERALL'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem Geral Aproximada de Itens Distintos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283487364762871800)
,p_name=>'APEX.IG.AREA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rea')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283492887015871803)
,p_name=>'APEX.IG.ASCENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Crescente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283052765369871506)
,p_name=>'APEX.IG.AUTHORIZATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Autoriza\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283528456801871828)
,p_name=>'APEX.IG.AUTO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Autom\00E1tico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283400108558871740)
,p_name=>'APEX.IG.AVG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9dia')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283529009774871828)
,p_name=>'APEX.IG.AVG_OVERALL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9dia Geral')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283486841918871799)
,p_name=>'APEX.IG.AXIS_LABEL_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo do Eixo de Label')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283487006671871799)
,p_name=>'APEX.IG.AXIS_VALUE_DECIMAL'
,p_message_language=>'pt-br'
,p_message_text=>'Casas Decimais'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283486960809871799)
,p_name=>'APEX.IG.AXIS_VALUE_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo do Eixo de Valor')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283501022845871809)
,p_name=>'APEX.IG.BACKGROUND_COLOR'
,p_message_language=>'pt-br'
,p_message_text=>'Cor de Fundo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283487486434871800)
,p_name=>'APEX.IG.BAR'
,p_message_language=>'pt-br'
,p_message_text=>'Barras'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283035187619871494)
,p_name=>'APEX.IG.BETWEEN'
,p_message_language=>'pt-br'
,p_message_text=>'entre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283502704846871810)
,p_name=>'APEX.IG.BOTH'
,p_message_language=>'pt-br'
,p_message_text=>'Ambos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283487502774871800)
,p_name=>'APEX.IG.BUBBLE'
,p_message_language=>'pt-br'
,p_message_text=>'Bolha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282793963122871339)
,p_name=>'APEX.IG.CANCEL'
,p_message_language=>'pt-br'
,p_message_text=>'Cancelar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283053601915871506)
,p_name=>'APEX.IG.CASE_SENSITIVE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Distin\00E7\00E3o entre Mai\00FAsculas e Min\00FAsculas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283529920906871829)
,p_name=>'APEX.IG.CASE_SENSITIVE_WITH_BRACKETS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('(Distin\00E7\00E3o entre Mai\00FAsculas e Min\00FAsculas)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283439405278871767)
,p_name=>'APEX.IG.CHANGES_SAVED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Altera\00E7\00F5es salvas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282794358531871339)
,p_name=>'APEX.IG.CHANGE_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>'Alterar View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283054720660871507)
,p_name=>'APEX.IG.CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1fico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283050161130871504)
,p_name=>'APEX.IG.CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sua consulta ultrapassa o n\00FAmero m\00E1ximo de %0 pontos de dados por gr\00E1fico. Aplique um filtro para reduzir o n\00FAmero de registros de sua consulta base.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282792647153871338)
,p_name=>'APEX.IG.CHART_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('View de Gr\00E1fico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282855991952871379)
,p_name=>'APEX.IG.CLEAR'
,p_message_language=>'pt-br'
,p_message_text=>'Limpar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283486395880871799)
,p_name=>'APEX.IG.CLOSE_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Fechar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283501747673871809)
,p_name=>'APEX.IG.COLORS'
,p_message_language=>'pt-br'
,p_message_text=>'Cores'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283501654934871809)
,p_name=>'APEX.IG.COLOR_BLUE'
,p_message_language=>'pt-br'
,p_message_text=>'Azul'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283501543181871809)
,p_name=>'APEX.IG.COLOR_GREEN'
,p_message_language=>'pt-br'
,p_message_text=>'Verde'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283501349970871809)
,p_name=>'APEX.IG.COLOR_ORANGE'
,p_message_language=>'pt-br'
,p_message_text=>'Laranja'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283501477759871809)
,p_name=>'APEX.IG.COLOR_RED'
,p_message_language=>'pt-br'
,p_message_text=>'Vermelho'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283501261999871809)
,p_name=>'APEX.IG.COLOR_YELLOW'
,p_message_language=>'pt-br'
,p_message_text=>'Amarelo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283053036459871506)
,p_name=>'APEX.IG.COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282792877054871338)
,p_name=>'APEX.IG.COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283506554247871813)
,p_name=>'APEX.IG.COLUMN_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Finalidade da Coluna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283053193844871506)
,p_name=>'APEX.IG.COMPLEX'
,p_message_language=>'pt-br'
,p_message_text=>'Complexo(a)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282793031073871338)
,p_name=>'APEX.IG.COMPUTE'
,p_message_language=>'pt-br'
,p_message_text=>'Calcular'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283035750653871494)
,p_name=>'APEX.IG.CONTAINS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('cont\00E9m')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283059091747871510)
,p_name=>'APEX.IG.CONTROL_BREAK'
,p_message_language=>'pt-br'
,p_message_text=>'Quebra de Controle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282855745963871379)
,p_name=>'APEX.IG.COPY_CB'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Copiar para \00C1rea de Transfer\00EAncia')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282855847361871379)
,p_name=>'APEX.IG.COPY_DOWN'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283399509039871740)
,p_name=>'APEX.IG.COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283399628239871740)
,p_name=>'APEX.IG.COUNT_DISTINCT'
,p_message_language=>'pt-br'
,p_message_text=>'Contar Diferentes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283529283245871828)
,p_name=>'APEX.IG.COUNT_DISTINCT_OVERALL'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem Geral de Itens Distintos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283529185321871828)
,p_name=>'APEX.IG.COUNT_OVERALL'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem Global'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283520630638871822)
,p_name=>'APEX.IG.CREATE_X'
,p_message_language=>'pt-br'
,p_message_text=>'Criar %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283051649048871505)
,p_name=>'APEX.IG.DATA'
,p_message_language=>'pt-br'
,p_message_text=>'Dados'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283503964593871811)
,p_name=>'APEX.IG.DATA_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Dados'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283502940535871810)
,p_name=>'APEX.IG.DATE'
,p_message_language=>'pt-br'
,p_message_text=>'Data'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283439299896871766)
,p_name=>'APEX.IG.DATE_INVALID_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor de Data Inv\00E1lido')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283036690078871495)
,p_name=>'APEX.IG.DAYS'
,p_message_language=>'pt-br'
,p_message_text=>'dias'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283052384009871505)
,p_name=>'APEX.IG.DEFAULT_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es Padr\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283052163743871505)
,p_name=>'APEX.IG.DEFAULT_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo Padr\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282793866128871339)
,p_name=>'APEX.IG.DELETE'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283507591187871813)
,p_name=>'APEX.IG.DELETE_REPORT_CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tem certeza de que deseja excluir este relat\00F3rio?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283060826532871511)
,p_name=>'APEX.IG.DELETE_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Linha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283059660774871510)
,p_name=>'APEX.IG.DELETE_ROWS'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Linhas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283492923399871803)
,p_name=>'APEX.IG.DESCENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Decrescente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283054461130871507)
,p_name=>'APEX.IG.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>'Detalhe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282792370930871338)
,p_name=>'APEX.IG.DETAIL_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>'View Detalhada'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283455196637871777)
,p_name=>'APEX.IG.DIRECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dire\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283054152221871507)
,p_name=>'APEX.IG.DISABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Desativado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283035810758871495)
,p_name=>'APEX.IG.DOES_NOT_CONTAIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o cont\00E9m')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283036082750871495)
,p_name=>'APEX.IG.DOES_NOT_START_WITH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o come\00E7a com')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283487663296871800)
,p_name=>'APEX.IG.DONUT'
,p_message_language=>'pt-br'
,p_message_text=>'Rosca'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283059253812871510)
,p_name=>'APEX.IG.DOWNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>'Fazer Download'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283508555804871814)
,p_name=>'APEX.IG.DOWNLOAD_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>'Escolher Formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283493827796871804)
,p_name=>'APEX.IG.DUPLICATE_AGGREGATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Agrega\00E7\00E3o Duplicada')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283493951389871804)
,p_name=>'APEX.IG.DUPLICATE_CONTROLBREAK'
,p_message_language=>'pt-br'
,p_message_text=>'Quebra de Controle Duplicada'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283060716593871511)
,p_name=>'APEX.IG.DUPLICATE_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Linha Duplicada'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283059592800871510)
,p_name=>'APEX.IG.DUPLICATE_ROWS'
,p_message_language=>'pt-br'
,p_message_text=>'Linhas Duplicadas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282793401362871339)
,p_name=>'APEX.IG.EDIT'
,p_message_language=>'pt-br'
,p_message_text=>'Editar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283492380106871803)
,p_name=>'APEX.IG.EDIT_CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Gr\00E1fico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283516341927871819)
,p_name=>'APEX.IG.EDIT_GROUP_BY'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Grupo Por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283508174457871814)
,p_name=>'APEX.IG.EMAIL_BCC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00F3pia Oculta (bcc)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283508336230871814)
,p_name=>'APEX.IG.EMAIL_BODY'
,p_message_language=>'pt-br'
,p_message_text=>'Mensagem'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283508075627871814)
,p_name=>'APEX.IG.EMAIL_CC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00F3pia (cc)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283507775566871813)
,p_name=>'APEX.IG.EMAIL_SENT'
,p_message_language=>'pt-br'
,p_message_text=>'E-mail enviado.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283508267450871814)
,p_name=>'APEX.IG.EMAIL_SUBJECT'
,p_message_language=>'pt-br'
,p_message_text=>'Assunto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283507913834871814)
,p_name=>'APEX.IG.EMAIL_TO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Destinat\00E1rio (para)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283053825902871506)
,p_name=>'APEX.IG.ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Ativado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283034164854871493)
,p_name=>'APEX.IG.EQUALS'
,p_message_language=>'pt-br'
,p_message_text=>'igual a'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283507191550871813)
,p_name=>'APEX.IG.EXAMPLE'
,p_message_language=>'pt-br'
,p_message_text=>'Exemplo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283053931522871506)
,p_name=>'APEX.IG.EXPRESSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Express\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283507083326871813)
,p_name=>'APEX.IG.FD_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283155998986871573)
,p_name=>'APEX.IG.FILE_PREPARED'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivo preparado. Iniciando o download.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282856054154871379)
,p_name=>'APEX.IG.FILL'
,p_message_language=>'pt-br'
,p_message_text=>'Preencher'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282877442250871392)
,p_name=>'APEX.IG.FILL_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sele\00E7\00E3o de preenchimento com')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282877326018871392)
,p_name=>'APEX.IG.FILL_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sele\00E7\00E3o de Preenchimento')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282792900918871338)
,p_name=>'APEX.IG.FILTER'
,p_message_language=>'pt-br'
,p_message_text=>'Filtro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283053209655871506)
,p_name=>'APEX.IG.FILTERS'
,p_message_language=>'pt-br'
,p_message_text=>'Filtros'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283528761081871828)
,p_name=>'APEX.IG.FILTER_WITH_DOTS'
,p_message_language=>'pt-br'
,p_message_text=>'Filtrar...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283493162367871803)
,p_name=>'APEX.IG.FIRST'
,p_message_language=>'pt-br'
,p_message_text=>'Primeiro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282793191852871338)
,p_name=>'APEX.IG.FLASHBACK'
,p_message_language=>'pt-br'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283051726380871505)
,p_name=>'APEX.IG.FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>'Formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283502626625871810)
,p_name=>'APEX.IG.FORMATMASK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1scara de Formato')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283507483403871813)
,p_name=>'APEX.IG.FORMAT_CSV'
,p_message_language=>'pt-br'
,p_message_text=>'CSV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283507394426871813)
,p_name=>'APEX.IG.FORMAT_HTML'
,p_message_language=>'pt-br'
,p_message_text=>'HTML'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283060424097871511)
,p_name=>'APEX.IG.FREEZE'
,p_message_language=>'pt-br'
,p_message_text=>'Congelar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283054045388871506)
,p_name=>'APEX.IG.FUNCTIONS_AND_OPERATORS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00F5es e Operadores')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283487789864871800)
,p_name=>'APEX.IG.FUNNEL'
,p_message_language=>'pt-br'
,p_message_text=>'Funil'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283399483185871739)
,p_name=>'APEX.IG.GO'
,p_message_language=>'pt-br'
,p_message_text=>'Ir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283034720804871494)
,p_name=>'APEX.IG.GREATER_THAN'
,p_message_language=>'pt-br'
,p_message_text=>'maior que'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283034832004871494)
,p_name=>'APEX.IG.GREATER_THAN_OR_EQUALS'
,p_message_language=>'pt-br'
,p_message_text=>'Maior ou igual a'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283054307593871507)
,p_name=>'APEX.IG.GRID'
,p_message_language=>'pt-br'
,p_message_text=>'Grade'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282792134167871338)
,p_name=>'APEX.IG.GRID_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>'View de Grade'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283494180221871804)
,p_name=>'APEX.IG.GROUP'
,p_message_language=>'pt-br'
,p_message_text=>'Grupo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283054516027871507)
,p_name=>'APEX.IG.GROUP_BY'
,p_message_language=>'pt-br'
,p_message_text=>'Agrupar por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282792489586871338)
,p_name=>'APEX.IG.GROUP_BY_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>'View Agrupar Por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283503241642871810)
,p_name=>'APEX.IG.HD_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de Condi\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283502156898871810)
,p_name=>'APEX.IG.HEADING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cabe\00E7alho')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283502327777871810)
,p_name=>'APEX.IG.HEADING_ALIGN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Alinhamento do Cabe\00E7alho')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283528679740871828)
,p_name=>'APEX.IG.HELP'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283514486614871818)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Voc\00EA pode inserir, atualizar e excluir dados diretamente dentro desta grade interativa.</p>'),
'',
unistr('<p>Insira uma nova linha clicando no bot\00E3o Adicionar Linha.</p>'),
'',
unistr('<p>Edite dados existentes clicando duas vezes em uma c\00E9lula espec\00EDfica. Para um trabalho de edi\00E7\00E3o de maior porte, clique em Editar para entrar no modo de edi\00E7\00E3o. No modo de edi\00E7\00E3o, voc\00EA pode clicar uma vez ou usar o teclado para editar c\00E9lulas espec')
||unistr('\00EDficas.</p>'),
'',
unistr('<p>Use o menu Alterar para duplicar e excluir linhas. Para ativar o menu Alterar, use as caixas de sele\00E7\00E3o para selecionar uma ou mais linhas.</p>'),
'',
'<p>Duplique uma linha selecionada clicando no menu Alterar e selecionando Duplicar Linhas. Exclua uma linha selecionada clicando no menu Alterar e selecionando Excluir Linha.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283516896249871820)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING_HEADING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Recursos de Edi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283516958996871820)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Uma grade interativa apresenta um conjunto de dados em um relat\00F3rio personaliz\00E1vel que pode ser pesquisado. Voc\00EA pode executar v\00E1rias opera\00E7\00F5es para limitar os registros retornados, e alterar a forma de exibi\00E7\00E3o dos dados.</p>'),
'',
unistr('<p>Use o campo Pesquisar para filtrar os registros retornados. Clique em A\00E7\00F5es para acessar v\00E1rias op\00E7\00F5es de modifica\00E7\00E3o do layout do relat\00F3rio, ou use os menus Cabe\00E7alho de Coluna nas colunas exibidas.</p>'),
'',
unistr('<p>Use Defini\00E7\00F5es de Relat\00F3rio para salvar suas personaliza\00E7\00F5es em um relat\00F3rio. Voc\00EA tamb\00E9m pode fazer download dos dados do relat\00F3rio para um arquivo externo ou enviar os dados por e-mail para voc\00EA mesmo ou outras pessoas.</p>'),
'',
'<p>Para saber mais, consulte "Using Interactive Grids" no <em>Oracle Application Express End User''s Guide</em>.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283516616700871819)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO_HEADING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Vis\00E3o Geral')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283514327031871818)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Voc\00EA pode personalizar a grade interativa para exibir dados de v\00E1rias formas diferentes, usando os recursos incorporados.</p>'),
'',
unistr('<p>Use os menus de Cabe\00E7alho de Coluna ou o menu A\00E7\00F5es para determinar quais colunas ser\00E3o exibidas, em que sequ\00EAncia e as que ser\00E3o congeladas. Voc\00EA tamb\00E9m pode definir v\00E1rios filtros de dados e classificar os dados retornados.</p>'),
'',
unistr('<p>Use o bot\00E3o Exibir (adjacente ao campo Pesquisar) para acessar outras views de dados que podem ter sido definidas pelo desenvolvedor do aplicativo. Voc\00EA tamb\00E9m pode criar um gr\00E1fico ou ver um existente.</p>  '),
'',
unistr('<p><em>Observa\00E7\00E3o: Clique em <strong>Ajuda</strong> nas caixas de di\00E1logo da grade interativa para obter mais informa\00E7\00F5es detalhadas sobre a fun\00E7\00E3o selecionada.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283516758844871820)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING_HEADING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Recursos de Gera\00E7\00E3o de Relat\00F3rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283059491275871510)
,p_name=>'APEX.IG.HELP.ACTIONS_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda da Grade Interativa'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283511395285871816)
,p_name=>'APEX.IG.HELP.AGGREGATE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use essa caixa de di\00E1logo para agregar colunas. Os valores agregados aparecem na parte inferior dos dados, ou ent\00E3o, caso as Quebras de Controle estejam definidas, na parte de baixo de cada quebra.</p>'),
'',
unistr('<p><strong>Lista de Agrega\00E7\00E3o</strong><br>'),
unistr('A lista de Agrega\00E7\00E3o exibe as agrega\00E7\00F5es definidas. Desative uma agrega\00E7\00E3o existente desmarcando-a.<br>'),
unistr('Clique em Adicionar ( &plus; ) para criar uma nova agrega\00E7\00E3o, ou em Excluir ( &minus; ) para remover uma agrega\00E7\00E3o existente.</p>'),
'',
unistr('<p><strong>Defini\00E7\00F5es de Agrega\00E7\00E3o</strong><br>'),
unistr('Use o form \00E0 direita para definir a agrega\00E7\00E3o.<br>'),
unistr('Selecione o nome da Coluna e o tipo de Agrega\00E7\00E3o.<br>'),
unistr('Opcionalmente, digite uma dica de ferramenta para a agrega\00E7\00E3o.<br>'),
unistr('Caso voc\00EA tenha definido uma Interrup\00E7\00E3o de Controle, a sele\00E7\00E3o de <strong>Mostrar Valor Geral</strong> exibir\00E1 o valor m\00E9dio, total ou similar geral, na parte de baixo dos dados.</p>'),
'',
unistr('<p><em>Observa\00E7\00E3o: Acesse a caixa de di\00E1logo Agrega\00E7\00E3o no menu A\00E7\00F5es ou clicando no cabe\00E7alho e na soma da coluna ( &sum; ).</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283515754792871819)
,p_name=>'APEX.IG.HELP.AGGREGATE_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ajuda de Agrega\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283512065672871816)
,p_name=>'APEX.IG.HELP.CHART'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use essa caixa de di\00E1logo para definir um gr\00E1fico exibido na forma de view de dados separada.<br> '),
unistr('Selecione um Tipo de gr\00E1fico, configure as defini\00E7\00F5es do gr\00E1fico e clique em <strong>Salvar.</strong></p>'),
'',
unistr('<p><strong>Defini\00E7\00F5es do Gr\00E1fico</strong></br>'),
unistr('Os atributos do gr\00E1fico que s\00E3o exibidos variam de acordo com o tipo de gr\00E1fico. V\00E1rios atributos podem ser inseridos para definir o gr\00E1fico. Os atributos marcados com um asterisco vermelho s\00E3o obrigat\00F3rios.</p>'),
'',
unistr('<p>Abaixo est\00E3o todos os atributos dispon\00EDveis nos diversos tipos de gr\00E1ficos (em ordem alfab\00E9tica):'),
'<ul>',
unistr('  <li>Agrega\00E7\00E3o - Selecione como agregar os valores de gr\00E1fico associados.</li> '),
unistr('  <li>Fechamento - Selecione a coluna que cont\00E9m o pre\00E7o de fechamento di\00E1rio da a\00E7\00E3o (Somente gr\00E1fico de a\00E7\00F5es).</li> '),
unistr('  <li>Casas Decimais - Insira o n\00FAmero de casas decimais para o qual os valores ser\00E3o arredondados.</li> '),
unistr('  <li>Dire\00E7\00E3o - Em rela\00E7\00E3o ao atributo Classificar por, especifique se os dados s\00E3o classificados em ordem crescente ou decrescente de valores.</li> '),
unistr('  <li>Alto - Selecione a coluna que cont\00E9m o valor alto (Somente gr\00E1ficos de Faixas e A\00E7\00F5es).</li> '),
unistr('  <li>Label - Selecione a coluna que cont\00E9m o texto para cada ponto de dados.</li> '),
unistr('  <li>T\00EDtulo do Eixo do Label - Digite o t\00EDtulo que aparecer\00E1 no eixo do label.</li> '),
unistr('  <li>Baixo - Selecione a coluna que cont\00E9m o valor baixo (Somente gr\00E1ficos de Faixas e A\00E7\00F5es).</li> '),
unistr('  <li>Nulos - Em rela\00E7\00E3o ao atributo Classificar por, especifique como voc\00EA deseja que os registros com valores nulos sejam classificados em rela\00E7\00E3o a registros com valores n\00E3o nulos.</li> '),
unistr('  <li>Abertura - Selecione a coluna que cont\00E9m o pre\00E7o de abertura di\00E1rio da a\00E7\00E3o (Somente gr\00E1fico de A\00E7\00F5es).</li> '),
unistr('  <li>Orienta\00E7\00E3o - Selecione se os elementos do gr\00E1fico, como barras, aparecer\00E3o verticalmente ou horizontalmente.</li> '),
unistr('  <li>S\00E9rie - Selecione a coluna usada para definir sua consulta din\00E2mica de v\00E1rias s\00E9ries.</li> '),
unistr('  <li>Pilhas - Especifique se os itens de dados s\00E3o empilhados.</li> '),
unistr('  <li>Classificar por - Selecione se o gr\00E1fico ser\00E1 classificado pelo label ou pelo(s) valor(es).</li> '),
unistr('  <li>Alvo - Selecione a coluna a ser usada para definir o valor do alvo nesse gr\00E1fico. Quando definido, o atributo de Valor define a \00E1rea preenchida dentro da fatia e o Alvo representa o valor da fatia inteira (Somente gr\00E1ficos de Funil).</li> '),
unistr('  <li>Valor - Selecione a coluna que cont\00E9m os dados a serem plotados.</li> '),
unistr('  <li>T\00EDtulo do Eixo de Valor - Digite o t\00EDtulo que ser\00E1 exibido no eixo de valor.</li> '),
unistr('  <li>Volume - Selecione a coluna que cont\00E9m o volume di\00E1rio de a\00E7\00F5es (Somente gr\00E1fico de a\00E7\00F5es).</li> '),
unistr('  <li>X - Selecione a coluna que cont\00E9m o valor do eixo x desse gr\00E1fico (Somente gr\00E1ficos de Bolha e Dispers\00E3o).</li> '),
unistr('  <li>Y - Selecione a coluna que cont\00E9m o valor do eixo y desse gr\00E1fico (Somente gr\00E1ficos de Bolha e Dispers\00E3o).</li> '),
unistr('  <li>Z - Selecione a coluna que cont\00E9m a largura da barra ou o raio da bolha (Somente gr\00E1ficos de Barras, Bolhas e Faixas)</li> '),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283516171675871819)
,p_name=>'APEX.IG.HELP.CHART_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ajuda de Gr\00E1ficos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283511065934871816)
,p_name=>'APEX.IG.HELP.COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use essa caixa de di\00E1logo para escolher quais colunas aparecer\00E3o e em que ordem.</p>'),
'',
'<p>Oculte uma coluna cancelando desmarcando-a.<br>',
'Reordene colunas clicando em Mover para Cima ( &uarr; ) ou Mover para Baixo ( &darr; ).<br>',
unistr('Use o seletor drop down para listar Todas as colunas, Colunas exibidas ou Colunas n\00E3o exibidas.</p>'),
'',
unistr('<p>Opcionalmente, use o form para especificar a largura m\00EDnima de uma coluna em pixels.</p>'),
'',
unistr('<p><em>Observa\00E7\00E3o: Voc\00EA tamb\00E9m pode reordenar colunas exibidas, clicando na al\00E7a de arrastar (no in\00EDcio do t\00EDtulo da coluna) e arrastando a coluna para a esquerda ou para a direita. Tamb\00E9m \00E9 poss\00EDvel alterar a largura de colunas exibidas, selecionand')
||unistr('o o separador de coluna, entre os t\00EDtulos, e movendo-o para a esquerda ou para a direita.</em</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283516046576871819)
,p_name=>'APEX.IG.HELP.COLUMNS_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda de Colunas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283511465627871816)
,p_name=>'APEX.IG.HELP.COMPUTE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use essa caixa de di\00E1logo para definir colunas adicionais com base em c\00E1lculos matem\00E1ticos e funcionais executados com colunas existentes.</p>'),
'',
unistr('<p><strong>Lista de C\00E1lculos</strong><br>'),
unistr('A lista de C\00E1lculos exibe c\00E1lculos definidos. Desative um c\00E1lculo existente desmarcando-o.<br>'),
unistr('Clique em Adicionar ( &plus; ) para adicionar um novo c\00E1lculo ou em Excluir ( &minus; ) para remover um c\00E1lculo existente.</p>'),
'',
unistr('<p><strong>Defini\00E7\00F5es de C\00E1lculo</strong><br>'),
unistr('Use o form para definir o c\00E1lculo.<br>'),
unistr('Informe os detalhes da coluna, como cabe\00E7alho e label, e selecione as defini\00E7\00F5es de alinhamento.<br> '),
unistr('Use a \00E1rea de texto Express\00E3o para inserir a(s) coluna(s) e fun\00E7\00F5es associadas para o c\00E1lculo.<br>'),
unistr('Selecione o tipo de dados apropriado e, opcionalmente, uma m\00E1scara de formato, para a nova coluna.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283515645928871819)
,p_name=>'APEX.IG.HELP.COMPUTE_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ajuda de C\00E1lculo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283511710787871816)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use esta caixa de di\00E1logo para definir uma quebra de controle em uma ou mais colunas.</p>'),
'',
'<p><strong>Lista de Quebras de Controle</strong><br>',
'A lista de Quebras de Controle exibe as quebras de controle definidas. Desative uma coluna de quebra de controle existente desmarcando-a.<br>',
'Clique em Adicionar ( &plus; ) para incluir uma nova coluna na quebra de controle ou em Excluir ( &minus; ) para remover uma coluna existente da quebra de controle.<br>',
unistr('Para reordenar colunas, clique em Mover para Cima ( &uarr; ) ou Mover para Baixo ( &darr; ) para mover a coluna selecionada para cima e para baixo em rela\00E7\00E3o \00E0s outras colunas.</p>'),
'',
unistr('<p><strong>Defini\00E7\00F5es da Quebra de Controle</strong><br>'),
'Use o form para definir a coluna de quebra de controle.<br>',
unistr('Selecione uma coluna de quebra de controle, a dire\00E7\00E3o de classifica\00E7\00E3o e como ordenar colunas nulas (colunas sem valor).</p>'),
'',
unistr('<p><em>Observa\00E7\00E3o: Ao visualizar a grade interativa, voc\00EA pode definir uma quebra de controle clicando em um Cabe\00E7alho de Coluna e selecionando o \00EDcone de quebra de controle.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283515380998871819)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda de Quebra de Controle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283511935373871816)
,p_name=>'APEX.IG.HELP.DOWNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use essa caixa de di\00E1logo para fazer download de todas as linhas atuais para um arquivo externo. O arquivo s\00F3 conter\00E1 as colunas exibidas no momento, usando quaisquer filtros e classifica\00E7\00F5es aplicados aos dados.</p>'),
'',
'<p>Selecione o formato do arquivo e clique em Fazer Download.<br>',
unistr('Observa\00E7\00E3o: O arquivo CSV n\00E3o inclui formata\00E7\00E3o de texto como agregados e quebras de controle.</p>'),
'',
unistr('<p>Para enviar o arquivo por e-mail, selecione Enviar como E-mail e digite os detalhes do e-mail (Destinat\00E1rio, Assunto e Mensagem).</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283515101781871818)
,p_name=>'APEX.IG.HELP.DOWNLOAD_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda de Download'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283511192072871816)
,p_name=>'APEX.IG.HELP.FILTER'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use essa caixa de di\00E1logo para configurar filtros de dados que limitem as linhas retornadas.</p>'),
'',
'<p><strong>Lista de Filtros</strong><br>',
'A lista de Filtros exibe os filtros definidos. Desative um filtro existente desmarcando-o.<br>',
'Clique em Adicionar ( &plus; ) para criar um novo filtro, ou em Excluir ( &minus; ) para remover um filtro existente.</p>',
'',
unistr('<p><strong>Defini\00E7\00F5es de Filtro</strong><br>'),
'Use o form para definir as propriedades do filtro.<br>',
'Selecione o tipo de filtro apropriado:<br>',
unistr('&nbsp;&nbsp;&nbsp;Linha - filtra um termo em qualquer coluna filtr\00E1vel.<br>'),
'&nbsp;&nbsp;&nbsp;Coluna - filtra uma determinada coluna com um operador e valor especificados.<br>',
'',
unistr('<p><em>Observa\00E7\00E3o: ao exibir a grade interativa, voc\00EA pode definir filtros de linha digitando diretamente no campo Pesquisar. Clique em Selecionar Colunas a Serem Pesquisadas para limitar a pesquisa a uma coluna espec\00EDfica. Como alternativa, abra um ')
||unistr('menu Cabe\00E7alho da Coluna e selecione um valor para criar um filtro de coluna.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283515994856871819)
,p_name=>'APEX.IG.HELP.FILTER_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda de Filtros'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283511528732871816)
,p_name=>'APEX.IG.HELP.FLASHBACK'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use essa caixa de di\00E1logo para ver os dados conforme existiam em um momento passado.</p>'),
unistr('<p>Insira o n\00FAmero de minutos no passado para executar a consulta de flashback.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283515528921871819)
,p_name=>'APEX.IG.HELP.FLASHBACK_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda de Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283516260392871819)
,p_name=>'APEX.IG.HELP.GROUP_BY_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda de Grupamento por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283511678409871816)
,p_name=>'APEX.IG.HELP.HIGHLIGHT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use essa caixa de di\00E1logo para destacar linhas ou colunas de dados com base na condi\00E7\00E3o informada.</p>'),
'',
'<p><strong>Lista de Destaque</strong><br>',
'A lista de Destaque exibe destaques definidos. Desative um destaque existente desmarcando-o.<br>',
'Clique em Adicionar ( &plus; ) para criar um novo destaque ou em Excluir ( &minus; ) para remover um destaque existente.</p>',
'',
unistr('<p><strong>Defini\00E7\00F5es de Destaque</strong><br>'),
'Use o form para definir as propriedades de destaque.<br>',
unistr('Informe o nome, selecione Linha ou Coluna e selecione os c\00F3digos de cor HTML para o plano de fundo e o texto.<br>'),
unistr('Selecione o <strong>Tipo de Condi\00E7\00E3o</strong> apropriado para destacar dados espec\00EDficos:<br>'),
'&nbsp;&nbsp;&nbsp;Linha - destaca o termo em qualquer coluna.<br>',
unistr('&nbsp;&nbsp;&nbsp;Coluna - destaca dentro de uma coluna espec\00EDfica com base no operador e valor especificados.<br>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283515497837871819)
,p_name=>'APEX.IG.HELP.HIGHLIGHT_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda de Destaque'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283511813862871816)
,p_name=>'APEX.IG.HELP.REPORT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use essa caixa de di\00E1logo para salvar altera\00E7\00F5es feitas no layout e na configura\00E7\00E3o da grade atual.<br>'),
unistr('Os desenvolvedores de aplicativos podem definir v\00E1rios layouts de relat\00F3rio alternativos. Onde for permitido, voc\00EA e outros usu\00E1rios finais podem salvar um relat\00F3rio como P\00FAblico, o que o disponibiliza para todos os outros usu\00E1rios da grade. Voc\00EA tam')
||unistr('b\00E9m pode salvar um relat\00F3rio como Privado, o qual somente voc\00EA possa ver.</p>'),
unistr('<p>Selecione entre os tipos dispon\00EDveis e digite um nome para o relat\00F3rio salvo.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283515281156871819)
,p_name=>'APEX.IG.HELP.REPORT_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ajuda de Relat\00F3rio'),
''))
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283511205889871816)
,p_name=>'APEX.IG.HELP.SORT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use essa caixa de di\00E1logo para definir a ordem de exibi\00E7\00E3o.</p>'),
'',
unistr('<p><strong>Lista de Classifica\00E7\00E3o</strong><br>'),
unistr('A caixa de di\00E1logo Classificar exibe uma lista de regras de classifica\00E7\00E3o configuradas.<br>'),
unistr('Clique em Adicionar ( &plus; ) para criar uma coluna de classifica\00E7\00E3o ou em Excluir ( &minus; ) para remover uma coluna de classifica\00E7\00E3o.<br>'),
unistr('Clique em Mover para Cima ( &uarr; ) e Mover para Baixo ( &darr; ) para mover a coluna de classifica\00E7\00E3o selecionada para cima e para baixo em rela\00E7\00E3o \00E0s outras colunas de classifica\00E7\00E3o.</p>'),
'',
unistr('<p><strong>Defini\00E7\00F5es de Classifica\00E7\00E3o</strong><br>'),
unistr('Selecione uma coluna de classifica\00E7\00E3o, a dire\00E7\00E3o de classifica\00E7\00E3o e como ordenar as colunas nulas (colunas sem valor).</p>'),
'',
unistr('<p><em>Observa\00E7\00E3o: Os dados podem ser classificados por colunas que n\00E3o s\00E3o exibidas; todavia, nem todas as colunas podem ser classific\00E1veis.</em><br>'),
unistr('<em>As colunas exibidas podem ser classificadas pressionando as setas para cima (crescente) ou para baixo (decrescente) no final dos cabe\00E7alhos de coluna. Para adicionar uma coluna subsequente a uma classifica\00E7\00E3o existente, mantenha a tecla Shift pre')
||'ssionada e clique na seta para cima ou para baixo.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283515885709871819)
,p_name=>'APEX.IG.HELP.SORT_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ajuda de Classifica\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283515029621871818)
,p_name=>'APEX.IG.HELP.SUBSCRIPTION_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ajuda de Inscri\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283060392759871511)
,p_name=>'APEX.IG.HIDE'
,p_message_language=>'pt-br'
,p_message_text=>'Ocultar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282793373449871339)
,p_name=>'APEX.IG.HIGHLIGHT'
,p_message_language=>'pt-br'
,p_message_text=>'Destacar'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283486400767871799)
,p_name=>'APEX.IG.HIGH_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Alto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283487219989871799)
,p_name=>'APEX.IG.HORIZONTAL'
,p_message_language=>'pt-br'
,p_message_text=>'Horizontal'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283036594202871495)
,p_name=>'APEX.IG.HOURS'
,p_message_language=>'pt-br'
,p_message_text=>'horas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283054259541871507)
,p_name=>'APEX.IG.ICON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00CDcone')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282792200203871338)
,p_name=>'APEX.IG.ICON_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('View do \00CDcone')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283034592726871494)
,p_name=>'APEX.IG.IN'
,p_message_language=>'pt-br'
,p_message_text=>'em'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283059949068871510)
,p_name=>'APEX.IG.INACTIVE_SETTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00E3o Inativa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283060062693871510)
,p_name=>'APEX.IG.INACTIVE_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es Inativas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283107383052871541)
,p_name=>'APEX.IG.INTERNAL_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro interno durante o processamento da solicita\00E7\00E3o da Grade Interativa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283514510488871818)
,p_name=>'APEX.IG.INVALID_DATE_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Formato de Data Inv\00E1lido')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283525172469871825)
,p_name=>'APEX.IG.INVALID_SETTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00E3o Inv\00E1lida')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283525243468871825)
,p_name=>'APEX.IG.INVALID_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es Inv\00E1lidas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283500987221871809)
,p_name=>'APEX.IG.INVALID_SORT_BY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A op\00E7\00E3o Classificar por foi definida como %0, mas nenhuma coluna foi selecionada para %0.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283494002528871804)
,p_name=>'APEX.IG.INVALID_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor Inv\00E1lido')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283482234053871796)
,p_name=>'APEX.IG.INVISIBLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o Exibido')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283035309727871494)
,p_name=>'APEX.IG.IN_THE_LAST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('no(s) \00FAltimo(s)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283035540060871494)
,p_name=>'APEX.IG.IN_THE_NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('no(s) pr\00F3ximo(s)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283034477172871494)
,p_name=>'APEX.IG.IS_NOT_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o est\00E1 vazio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283034372737871494)
,p_name=>'APEX.IG.IS_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('est\00E1 vazio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283502246891871810)
,p_name=>'APEX.IG.LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Label'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283485782105871798)
,p_name=>'APEX.IG.LABEL_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Label'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283493210771871804)
,p_name=>'APEX.IG.LAST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282933208617871428)
,p_name=>'APEX.IG.LAST.DAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimo Dia')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282933438795871428)
,p_name=>'APEX.IG.LAST.HOUR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltima Hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282933963815871429)
,p_name=>'APEX.IG.LAST.MINUTE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimo Minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282932922737871428)
,p_name=>'APEX.IG.LAST.MONTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00EAs Passado')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282933047117871428)
,p_name=>'APEX.IG.LAST.WEEK'
,p_message_language=>'pt-br'
,p_message_text=>'Semana Passada'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282933180089871428)
,p_name=>'APEX.IG.LAST.X_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimos %0 Dias')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282933396951871428)
,p_name=>'APEX.IG.LAST.X_HOURS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimas %0 Horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282934087761871429)
,p_name=>'APEX.IG.LAST.X_MINUTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 \00DAltimos Minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282933807021871429)
,p_name=>'APEX.IG.LAST.X_MONTHS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 \00DAltimos Meses')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282933763053871429)
,p_name=>'APEX.IG.LAST.X_WEEKS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 \00DAltimas Semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282932791896871428)
,p_name=>'APEX.IG.LAST.X_YEARS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimos %0 Anos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282932873512871428)
,p_name=>'APEX.IG.LAST.YEAR'
,p_message_language=>'pt-br'
,p_message_text=>'Ano Passado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283502419630871810)
,p_name=>'APEX.IG.LAYOUT_ALIGN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Alinhamento de C\00E9lulas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283502596054871810)
,p_name=>'APEX.IG.LAYOUT_USEGROUPFOR'
,p_message_language=>'pt-br'
,p_message_text=>'Usar Grupo para'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283034928410871494)
,p_name=>'APEX.IG.LESS_THAN'
,p_message_language=>'pt-br'
,p_message_text=>'menor que'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283035012615871494)
,p_name=>'APEX.IG.LESS_THAN_OR_EQUALS'
,p_message_language=>'pt-br'
,p_message_text=>'Menor ou igual a'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283487848239871800)
,p_name=>'APEX.IG.LINE'
,p_message_language=>'pt-br'
,p_message_text=>'Linha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283487936069871800)
,p_name=>'APEX.IG.LINE_WITH_AREA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Linha com \00C1rea')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283502862571871810)
,p_name=>'APEX.IG.LISTAGG'
,p_message_language=>'pt-br'
,p_message_text=>'Listagg'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283486546391871799)
,p_name=>'APEX.IG.LOW_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00EDnimo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283508494198871814)
,p_name=>'APEX.IG.MAILADDRESSES_COMMASEP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Separe v\00E1rios endere\00E7os com v\00EDrgulas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283036158397871495)
,p_name=>'APEX.IG.MATCHES_REGULAR_EXPRESSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('corresponde \00E0 express\00E3o regular')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283400036187871740)
,p_name=>'APEX.IG.MAX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1ximo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283529559256871828)
,p_name=>'APEX.IG.MAX_OVERALL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1ximo Geral')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283400235343871740)
,p_name=>'APEX.IG.MEDIAN'
,p_message_language=>'pt-br'
,p_message_text=>'Mediano'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283529675265871828)
,p_name=>'APEX.IG.MEDIAN_OVERALL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9dio Geral')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283399953926871740)
,p_name=>'APEX.IG.MIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00EDnimo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283036471517871495)
,p_name=>'APEX.IG.MINUTES'
,p_message_language=>'pt-br'
,p_message_text=>'minutos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283401778740871741)
,p_name=>'APEX.IG.MINUTES_AGO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Minutos atr\00E1s')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283529491296871828)
,p_name=>'APEX.IG.MIN_OVERALL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00EDnimo Geral')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283037042932871495)
,p_name=>'APEX.IG.MONTHS'
,p_message_language=>'pt-br'
,p_message_text=>'meses'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283060205430871510)
,p_name=>'APEX.IG.MORE_DATA_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os dados cont\00EAm mais de %0 linhas, o que ultrapassa o m\00E1ximo permitido. Aplique filtros adicionais para ver os resultados.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283052210256871505)
,p_name=>'APEX.IG.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283052470631871505)
,p_name=>'APEX.IG.NAMED_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio Nomeado')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282932107068871428)
,p_name=>'APEX.IG.NEXT.DAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo Dia')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282931903837871428)
,p_name=>'APEX.IG.NEXT.HOUR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3xima Hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282934112898871429)
,p_name=>'APEX.IG.NEXT.MINUTE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo Minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282932476459871428)
,p_name=>'APEX.IG.NEXT.MONTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo M\00EAs')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282932320206871428)
,p_name=>'APEX.IG.NEXT.WEEK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3xima Semana')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282932276028871428)
,p_name=>'APEX.IG.NEXT.X_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximos %0 Dias')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282932021586871428)
,p_name=>'APEX.IG.NEXT.X_HOURS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximas %0 Horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282934236980871429)
,p_name=>'APEX.IG.NEXT.X_MINUTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 Pr\00F3ximos Minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282933510938871429)
,p_name=>'APEX.IG.NEXT.X_MONTHS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 Pr\00F3ximos Meses')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282933683480871429)
,p_name=>'APEX.IG.NEXT.X_WEEKS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 Pr\00F3ximas Semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282932693195871428)
,p_name=>'APEX.IG.NEXT.X_YEARS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximos %0 Anos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282932577820871428)
,p_name=>'APEX.IG.NEXT.YEAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo Ano')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283035279933871494)
,p_name=>'APEX.IG.NOT_BETWEEN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o est\00E1 entre')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283034291287871493)
,p_name=>'APEX.IG.NOT_EQUALS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o igual a')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283554670020871845)
,p_name=>'APEX.IG.NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A regi\00E3o com o ID %0 n\00E3o \00E9 uma regi\00E3o de Grade Interativa ou n\00E3o existe no aplicativo %1.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283034678079871494)
,p_name=>'APEX.IG.NOT_IN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o contido em')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283035438855871494)
,p_name=>'APEX.IG.NOT_IN_THE_LAST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o est\00E1 no(s) \00FAltimo(s)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283035683388871494)
,p_name=>'APEX.IG.NOT_IN_THE_NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o est\00E1 no(s) pr\00F3ximo(s)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283060115267871510)
,p_name=>'APEX.IG.NO_DATA_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dados n\00E3o encontrados')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283493000040871803)
,p_name=>'APEX.IG.NULLS'
,p_message_language=>'pt-br'
,p_message_text=>'Nulos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283503015764871810)
,p_name=>'APEX.IG.NUMBER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Num\00E9rico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283493560149871804)
,p_name=>'APEX.IG.OFF'
,p_message_language=>'pt-br'
,p_message_text=>'Desativado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283493676165871804)
,p_name=>'APEX.IG.ON'
,p_message_language=>'pt-br'
,p_message_text=>'Ativado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283017605893871483)
,p_name=>'APEX.IG.ONE_MINUTE_AGO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('h\00E1 1 minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283510711143871815)
,p_name=>'APEX.IG.OPEN_COLORPICKER'
,p_message_language=>'pt-br'
,p_message_text=>'Abrir Seletor de Cores: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283486207635871799)
,p_name=>'APEX.IG.OPEN_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Abrir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283053370864871506)
,p_name=>'APEX.IG.OPERATOR'
,p_message_language=>'pt-br'
,p_message_text=>'Operador'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283485679818871798)
,p_name=>'APEX.IG.ORIENTATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Orienta\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283488077329871800)
,p_name=>'APEX.IG.PIE'
,p_message_language=>'pt-br'
,p_message_text=>'Pizza'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283054643515871507)
,p_name=>'APEX.IG.PIVOT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Piv\00F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282792500466871338)
,p_name=>'APEX.IG.PIVOT_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('View de Tabela Din\00E2mica')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283510681653871815)
,p_name=>'APEX.IG.PLACEHOLDER_INVALUES'
,p_message_language=>'pt-br'
,p_message_text=>'Separe os valores com por "%0"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283488108281871800)
,p_name=>'APEX.IG.POLAR'
,p_message_language=>'pt-br'
,p_message_text=>'Polar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283501930089871809)
,p_name=>'APEX.IG.POSITION_CENTER'
,p_message_language=>'pt-br'
,p_message_text=>'Centralizado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283502099256871810)
,p_name=>'APEX.IG.POSITION_END'
,p_message_language=>'pt-br'
,p_message_text=>'Fim'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283501815231871809)
,p_name=>'APEX.IG.POSITION_START'
,p_message_language=>'pt-br'
,p_message_text=>unistr('In\00EDcio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283052576486871505)
,p_name=>'APEX.IG.PRIMARY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prim\00E1ria')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283052864008871506)
,p_name=>'APEX.IG.PRIMARY_DEFAULT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00E3o Prim\00E1rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283347851632871705)
,p_name=>'APEX.IG.PRIMARY_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio Prim\00E1rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283488296833871800)
,p_name=>'APEX.IG.RADAR'
,p_message_language=>'pt-br'
,p_message_text=>'Radar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283488352250871800)
,p_name=>'APEX.IG.RANGE'
,p_message_language=>'pt-br'
,p_message_text=>'Intervalo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283512161007871816)
,p_name=>'APEX.IG.REFRESH'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283060975673871511)
,p_name=>'APEX.IG.REFRESH_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar Linhas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283059726450871510)
,p_name=>'APEX.IG.REFRESH_ROWS'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar Linhas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282794078006871339)
,p_name=>'APEX.IG.REMOVE_CONTROL'
,p_message_language=>'pt-br'
,p_message_text=>'Remover %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283051931532871505)
,p_name=>'APEX.IG.REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283545357295871839)
,p_name=>'APEX.IG.REPORT.DELETED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio exclu\00EDdo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283545084635871839)
,p_name=>'APEX.IG.REPORT.SAVED.ALTERNATIVE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio alternativo salvo para todos os usu\00E1rios')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283544958468871839)
,p_name=>'APEX.IG.REPORT.SAVED.DEFAULT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio padr\00E3o salvo para todos os usu\00E1rios')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283545248987871839)
,p_name=>'APEX.IG.REPORT.SAVED.PRIVATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio privado salvo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283545138976871839)
,p_name=>'APEX.IG.REPORT.SAVED.PUBLIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio p\00FAblico salvo para todos os usu\00E1rios')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283017507759871483)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF.X.MINUTES_AGO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dados do relat\00F3rio %0 minutos atr\00E1s')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283017407540871483)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF_ONE_MINUTE_AGO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dados do relat\00F3rio h\00E1 1 minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283516573767871819)
,p_name=>'APEX.IG.REPORT_EDIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio - Editar')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283516459945871819)
,p_name=>'APEX.IG.REPORT_SAVE_AS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio - Salvar como')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282794146863871339)
,p_name=>'APEX.IG.REPORT_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Configura\00E7\00F5es do Relat\00F3rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283554737153871845)
,p_name=>'APEX.IG.REPORT_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Grade Interativa salva com o ID est\00E1tico %0 n\00E3o existe.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283528828346871828)
,p_name=>'APEX.IG.REPORT_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('View de Relat\00F3rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282793227429871339)
,p_name=>'APEX.IG.RESET'
,p_message_language=>'pt-br'
,p_message_text=>'Redefinir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283061034200871511)
,p_name=>'APEX.IG.REVERT_CHANGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Reverter Altera\00E7\00F5es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283059820792871510)
,p_name=>'APEX.IG.REVERT_ROWS'
,p_message_language=>'pt-br'
,p_message_text=>'Reverter Linhas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283052931058871506)
,p_name=>'APEX.IG.ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Linha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283051880879871505)
,p_name=>'APEX.IG.ROWS_PER_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Linhas Por P\00E1gina')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283553343441871845)
,p_name=>'APEX.IG.ROW_ACTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00F5es de Linha')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283560568313871850)
,p_name=>'APEX.IG.ROW_ACTIONS_FOR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00F5es da linha %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282793538679871339)
,p_name=>'APEX.IG.SAVE'
,p_message_language=>'pt-br'
,p_message_text=>'Salvar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283135992390871560)
,p_name=>'APEX.IG.SAVED'
,p_message_language=>'pt-br'
,p_message_text=>'salvo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282791767743871338)
,p_name=>'APEX.IG.SAVED_REPORTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rios Salvos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282791800564871338)
,p_name=>'APEX.IG.SAVED_REPORT_DEFAULT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282791989666871338)
,p_name=>'APEX.IG.SAVED_REPORT_PRIVATE'
,p_message_language=>'pt-br'
,p_message_text=>'Particular'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282792006391871338)
,p_name=>'APEX.IG.SAVED_REPORT_PUBLIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00FAblico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283528570008871828)
,p_name=>'APEX.IG.SAVE_AS'
,p_message_language=>'pt-br'
,p_message_text=>'Salvar como'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283059116105871510)
,p_name=>'APEX.IG.SAVE_REPORT_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Salvar Defini\00E7\00F5es do Relat\00F3rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283488485497871800)
,p_name=>'APEX.IG.SCATTER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dispers\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282791610469871338)
,p_name=>'APEX.IG.SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283507275358871813)
,p_name=>'APEX.IG.SEARCH.ALL_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisa: Todas as Colunas de Texto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282791510668871337)
,p_name=>'APEX.IG.SEARCH.COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283506000201871812)
,p_name=>'APEX.IG.SEARCH.ORACLE_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisa: Texto Completo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283017396055871483)
,p_name=>'APEX.IG.SEARCH_FOR.X'
,p_message_language=>'pt-br'
,p_message_text=>'Procurar ''%0'''
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283481980376871796)
,p_name=>'APEX.IG.SELECT'
,p_message_language=>'pt-br'
,p_message_text=>'- Selecionar -'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282856186398871379)
,p_name=>'APEX.IG.SELECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sele\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283454781299871777)
,p_name=>'APEX.IG.SELECT_1_ROW_IN_MASTER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Selecione 1 linha na regi\00E3o mestra')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282791468139871337)
,p_name=>'APEX.IG.SELECT_COLUMNS_TO_SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Selecionar colunas para pesquisa'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283552368270871844)
,p_name=>'APEX.IG.SEL_ACTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00F5es de Sele\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282856336368871379)
,p_name=>'APEX.IG.SEL_MODE_CELL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sele\00E7\00E3o de C\00E9lula')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282856261398871379)
,p_name=>'APEX.IG.SEL_MODE_ROW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sele\00E7\00E3o de Linhas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283507802142871814)
,p_name=>'APEX.IG.SEND_AS_EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar como E-mail'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283491328137871802)
,p_name=>'APEX.IG.SERIES_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('S\00E9rie')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282752356004871312)
,p_name=>'APEX.IG.SHOW'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283367240995871718)
,p_name=>'APEX.IG.SHOW_OVERALL_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar Valor Geral'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283060645966871511)
,p_name=>'APEX.IG.SINGLE_ROW_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>'View de Uma Linha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283054868085871507)
,p_name=>'APEX.IG.SORT'
,p_message_language=>'pt-br'
,p_message_text=>'Classificar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283491474642871802)
,p_name=>'APEX.IG.SORT_BY'
,p_message_language=>'pt-br'
,p_message_text=>'Classificar Por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283553403086871845)
,p_name=>'APEX.IG.SORT_ONLY_ONE_PER_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA s\00F3 pode definir uma classifica\00E7\00E3o por coluna.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283552578311871844)
,p_name=>'APEX.IG.SRV_CHANGE_MENU'
,p_message_language=>'pt-br'
,p_message_text=>'Alterar Menu'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283493712615871804)
,p_name=>'APEX.IG.STACK'
,p_message_language=>'pt-br'
,p_message_text=>'Pilha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283035979182871495)
,p_name=>'APEX.IG.STARTS_WITH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('come\00E7a com')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283488533872871800)
,p_name=>'APEX.IG.STOCK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282681045682871265)
,p_name=>'APEX.IG.STRETCH_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Estender Largura de Colunas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283059319603871510)
,p_name=>'APEX.IG.SUBSCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Inscri\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283399886000871740)
,p_name=>'APEX.IG.SUM'
,p_message_language=>'pt-br'
,p_message_text=>'Soma'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283560772841871850)
,p_name=>'APEX.IG.SUMMARY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Grade Interativa. Relat\00F3rio: %0, View: %1.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283528920407871828)
,p_name=>'APEX.IG.SUM_OVERALL'
,p_message_language=>'pt-br'
,p_message_text=>'Soma Geral'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283486745117871799)
,p_name=>'APEX.IG.TARGET_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Destino'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283501110189871809)
,p_name=>'APEX.IG.TEXT_COLOR'
,p_message_language=>'pt-br'
,p_message_text=>'Cor do Texto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282794286699871339)
,p_name=>'APEX.IG.TOGGLE'
,p_message_language=>'pt-br'
,p_message_text=>'Alternar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283367193757871718)
,p_name=>'APEX.IG.TOOLTIP'
,p_message_language=>'pt-br'
,p_message_text=>'Dica de ferramenta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283052069565871505)
,p_name=>'APEX.IG.TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283060536690871511)
,p_name=>'APEX.IG.UNFREEZE'
,p_message_language=>'pt-br'
,p_message_text=>'Descongelar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283053559062871506)
,p_name=>'APEX.IG.UNIT'
,p_message_language=>'pt-br'
,p_message_text=>'Unidade'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283507699935871813)
,p_name=>'APEX.IG.UNSAVED_CHANGES_CONTINUE_CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Existem altera\00E7\00F5es n\00E3o salvas. Deseja continuar?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283053471160871506)
,p_name=>'APEX.IG.VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Valor'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283485822552871798)
,p_name=>'APEX.IG.VALUE_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Valor'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283494874349871805)
,p_name=>'APEX.IG.VALUE_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 necess\00E1rio um valor.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283439353014871766)
,p_name=>'APEX.IG.VALUE_TIMESTAMP_TZ'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor (o fuso hor\00E1rio n\00E3o pode ser alterado)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283503194655871810)
,p_name=>'APEX.IG.VARCHAR2'
,p_message_language=>'pt-br'
,p_message_text=>'Texto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283487188004871799)
,p_name=>'APEX.IG.VERTICAL'
,p_message_language=>'pt-br'
,p_message_text=>'Vertical'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283051570099871505)
,p_name=>'APEX.IG.VIEW'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283482068542871796)
,p_name=>'APEX.IG.VISIBLE'
,p_message_language=>'pt-br'
,p_message_text=>'Exibido'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283486600337871799)
,p_name=>'APEX.IG.VOLUME_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Volume'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283036931213871495)
,p_name=>'APEX.IG.WEEKS'
,p_message_language=>'pt-br'
,p_message_text=>'semanas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283482145571871796)
,p_name=>'APEX.IG.WIDTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Largura M\00EDnima da Coluna (Pixel)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282967126191871450)
,p_name=>'APEX.IG.X.BETWEEN.Y.AND.Z'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 est\00E1 entre %1 e %2')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282966899450871450)
,p_name=>'APEX.IG.X.CONTAINS.Y'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 cont\00E9m %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282966981417871450)
,p_name=>'APEX.IG.X.DOES_NOT_CONTAIN.Y'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o cont\00E9m %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282748526663871310)
,p_name=>'APEX.IG.X.DOES_NOT_START_WITH.Y'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o come\00E7a com %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282965676205871449)
,p_name=>'APEX.IG.X.EQUALS.Y'
,p_message_language=>'pt-br'
,p_message_text=>'%0 igual a %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282965869861871449)
,p_name=>'APEX.IG.X.GREATER_THAN.Y'
,p_message_language=>'pt-br'
,p_message_text=>'%0 maior que %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282965925727871449)
,p_name=>'APEX.IG.X.GREATER_THAN_OR_EQUALS.Y'
,p_message_language=>'pt-br'
,p_message_text=>'%0 maior que ou igual a %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282966635322871450)
,p_name=>'APEX.IG.X.IN.Y'
,p_message_language=>'pt-br'
,p_message_text=>'%0 em %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282967890021871451)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nos %1 \00FAltimos dias')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282967690514871451)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.HOURS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nas %1 \00FAltimas horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282967459279871450)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MINUTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nos %1 \00FAltimos minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282968265711871451)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MONTHS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nos %1 \00FAltimos meses')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282968072170871451)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.WEEKS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nas %1 \00FAltimas semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282968481391871451)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.YEARS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nos %1 \00FAltimos anos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282967774638871451)
,p_name=>'APEX.IG.X.IN_THE_LAST_DAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 no \00FAltimo dia')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282967508460871450)
,p_name=>'APEX.IG.X.IN_THE_LAST_HOUR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 na \00FAltima hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282967327738871450)
,p_name=>'APEX.IG.X.IN_THE_LAST_MINUTE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 no \00FAltimo minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282968180294871451)
,p_name=>'APEX.IG.X.IN_THE_LAST_MONTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 no \00FAltimo m\00EAs')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282967978576871451)
,p_name=>'APEX.IG.X.IN_THE_LAST_WEEK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 na \00FAltima semana')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282968396206871451)
,p_name=>'APEX.IG.X.IN_THE_LAST_YEAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 no \00FAltimo ano')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282970276012871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nos %1 pr\00F3ximos dias')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282970072047871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.HOURS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nas %1 pr\00F3ximas horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282969834022871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nos %1 pr\00F3ximos minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282970692191871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nos %1 pr\00F3ximos meses')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282970444918871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nas %1 pr\00F3ximas semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282970872323871453)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.YEARS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 nos %1 pr\00F3ximos anos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282970167079871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT_DAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 no pr\00F3ximo dia')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282969926810871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT_HOUR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 na pr\00F3xima hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282969766479871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MINUTE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 no pr\00F3ximo minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282970591608871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MONTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 no pr\00F3ximo m\00EAs')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282970369461871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT_WEEK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 na pr\00F3xima semana')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282970731015871452)
,p_name=>'APEX.IG.X.IN_THE_NEXT_YEAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 no pr\00F3ximo ano')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282966340557871450)
,p_name=>'APEX.IG.X.IS_NOT_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 vazio(a)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282966245743871450)
,p_name=>'APEX.IG.X.IS_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 est\00E1 vazio(a)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282966022692871449)
,p_name=>'APEX.IG.X.LESS_THAN.Y'
,p_message_language=>'pt-br'
,p_message_text=>'%0 menor que %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282966119782871450)
,p_name=>'APEX.IG.X.LESS_THAN_OR_EQUALS.Y'
,p_message_language=>'pt-br'
,p_message_text=>'%0 menor que ou igual a %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282966482052871450)
,p_name=>'APEX.IG.X.LIKE.Y'
,p_message_language=>'pt-br'
,p_message_text=>'%0 como %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282967006087871450)
,p_name=>'APEX.IG.X.MATCHES_REGULAR_EXPRESSION.Y'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 corresponde \00E0 express\00E3o regular %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283017745243871483)
,p_name=>'APEX.IG.X.MINUTES_AGO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('H\00E1 %0 minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282967212882871450)
,p_name=>'APEX.IG.X.NOT_BETWEEN.Y.AND.Z'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 entre %1 e %2')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282965759223871449)
,p_name=>'APEX.IG.X.NOT_EQUALS.Y'
,p_message_language=>'pt-br'
,p_message_text=>'%0 diferente de %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282966739551871450)
,p_name=>'APEX.IG.X.NOT_IN.Y'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o em %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282969085773871451)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nos %1 \00FAltimos dias')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282968858070871451)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.HOURS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nas %1 \00FAltimas horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282968697171871451)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MINUTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nos %1 \00FAltimos minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282969448324871452)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MONTHS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nos %1 \00FAltimos meses')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282969258072871452)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.WEEKS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nas %1 \00FAltimas semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282969606226871452)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.YEARS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nos %1 \00FAltimos anos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282968954421871451)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_DAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 no \00FAltimo dia')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282968706830871451)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_HOUR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 na \00FAltima hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282968502703871451)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MINUTE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 no \00FAltimo minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282969306254871452)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MONTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 no \00FAltimo m\00EAs')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282969107767871451)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_WEEK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 na \00FAltima semana')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282969519590871452)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_YEAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 no \00FAltimo ano')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282971429923871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nos %1 pr\00F3ximos dias')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282971251437871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.HOURS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nas %1 pr\00F3ximas horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282971054017871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nos %1 pr\00F3ximos minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282971803118871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nos %1 pr\00F3ximos meses ')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282971620074871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nas %1 pr\00F3ximas semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282972091519871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.YEARS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 nos %1 pr\00F3ximos anos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282971369207871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_DAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 no pr\00F3ximo dia')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282971151064871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_HOUR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 na \00FAltima hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282970900069871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MINUTE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 no pr\00F3ximo minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282971714747871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MONTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 no \00FAltimo m\00EAs')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282971564475871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_WEEK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 na pr\00F3xima semana')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282971905758871453)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_YEAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 no pr\00F3ximo ano')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282966581524871450)
,p_name=>'APEX.IG.X.NOT_LIKE.Y'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o \00E9 como %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283027690671871489)
,p_name=>'APEX.IG.X.STARTS_WITH.Y'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 come\00E7a com %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283485905260871799)
,p_name=>'APEX.IG.X_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'X'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283037113531871495)
,p_name=>'APEX.IG.YEARS'
,p_message_language=>'pt-br'
,p_message_text=>'anos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283486075339871799)
,p_name=>'APEX.IG.Y_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Y'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283486196229871799)
,p_name=>'APEX.IG.Z_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Z'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283506650111871813)
,p_name=>'APEX.IG_FORMAT_SAMPLE_1'
,p_message_language=>'pt-br'
,p_message_text=>'Segunda-feira, 12 de janeiro de 2016'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283506737842871813)
,p_name=>'APEX.IG_FORMAT_SAMPLE_2'
,p_message_language=>'pt-br'
,p_message_text=>'Janeiro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283506893253871813)
,p_name=>'APEX.IG_FORMAT_SAMPLE_3'
,p_message_language=>'pt-br'
,p_message_text=>unistr('16 horas atr\00E1s')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283506961518871813)
,p_name=>'APEX.IG_FORMAT_SAMPLE_4'
,p_message_language=>'pt-br'
,p_message_text=>'em 16h'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282362709547871060)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O suporte para impress\00E3o deve ser STANDARD ou ADVANCED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282362841383871060)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel remover o primeiro esquema provisionado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282251605293870989)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ID de aplicativo inv\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282789649945871336)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Endere\00E7o de E-mail inv\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282232775841870977)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O valor deve ser zero ou um n\00FAmero inteiro positivo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282362987896871060)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero de porta inv\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282825414672871359)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ID de assinatura inv\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282363005755871060)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_language=>'pt-br'
,p_message_text=>'O caminho da wallet deve estar no arquivo do form:<filesystempath>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282454461127871118)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O espa\00E7o de trabalho n\00E3o foi encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282454382156871118)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ID de espa\00E7o de trabalho inv\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282381921994871072)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O valor "%1" do par\00E2metro da inst\00E2ncia "%0" n\00E3o corresponde \00E0 express\00E3o regular "%2"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282381840195871072)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O par\00E2metro "%0" da inst\00E2ncia deve ter um valor')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282363185119871060)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Par\00E2metro da inst\00E2ncia n\00E3o encontrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282821029942871356)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_language=>'pt-br'
,p_message_text=>'Senha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282186438750870947)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Senha (Somente para autentica\00E7\00E3o no reposit\00F3rio de contas do usu\00E1rio do espa\00E7o de trabalho)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283106580323871540)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Senha (Somente para autentica\00E7\00E3o no reposit\00F3rio de contas do usu\00E1rio do espa\00E7o de trabalho)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282928062645871425)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Senha (Somente para autentica\00E7\00E3o no reposit\00F3rio de contas do usu\00E1rio do espa\00E7o de trabalho)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282508230748871153)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Senha (Somente para autentica\00E7\00E3o no reposit\00F3rio de contas do usu\00E1rio do espa\00E7o de trabalho)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282820960079871356)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Senha (Somente para autentica\00E7\00E3o no reposit\00F3rio de contas do usu\00E1rio do espa\00E7o de trabalho)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282365090286871061)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O protocolo do servidor de impress\00E3o deve ser http ou https')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282365102999871061)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O esquema n\00E3o existe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282365262089871061)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esquema \00E9 restrito')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282211320790870963)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282211131473870963)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O aplicativo n\00E3o existe mais')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283155781475871573)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_language=>'pt-br'
,p_message_text=>'Designar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283436088619871764)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cart\00F5es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282213209751870964)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_language=>'pt-br'
,p_message_text=>'Comentado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282213123845870964)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('coment\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282187986964870948)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282187788008870948)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tem certeza de que deseja excluir este coment\00E1rio?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283140145660871562)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Problema'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282197514892870954)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>'Tem certeza de que deseja excluir este problema?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282214816023870965)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_language=>'pt-br'
,p_message_text=>'Documento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282213757492870965)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Documentos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282187875993870948)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_language=>'pt-br'
,p_message_text=>'Editar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283363641896871715)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Coment\00E1rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283363780978871715)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Problema'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282211973024870963)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O aplicativo especificado n\00E3o existe neste espa\00E7o de trabalho.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282212356703870964)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao tentar excluir o coment\00E1rio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282212240247870964)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coment\00E1rio n\00E3o encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282212567104870964)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Problema n\00E3o encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282212697574870964)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao tentar marcar o problema para exclus\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282212007752870964)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A p\00E1gina especificada n\00E3o existe neste espa\00E7o de trabalho ou no aplicativo fornecido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282212410412870964)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O usu\00E1rio n\00E3o est\00E1 autorizado a excluir este coment\00E1rio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282212798265870964)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rio n\00E3o autorizado a excluir este problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282212124603870964)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O usu\00E1rio n\00E3o est\00E1 autorizado a alterar a visibilidade deste coment\00E1rio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283372558079871721)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Ocorreu um problema ao verificar os tamanhos de arquivo. Entre em contato com o administrador do sistema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283372403661871721)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Um desses arquivos \00E9 maior do que o tamanho m\00E1ximo de %0 bytes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283372304128871721)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este arquivo \00E9 maior do que o tamanho m\00E1ximo de %0 bytes.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282188038024870948)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_language=>'pt-br'
,p_message_text=>'Ocultar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282214697323870965)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Imagem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282213587157870964)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_language=>'pt-br'
,p_message_text=>'Imagens'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282210972212870963)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('um problema que n\00E3o foi encontrado no sistema')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282171651889870938)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Prefer\00EAncia do Usu\00E1rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282213355187870964)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_language=>'pt-br'
,p_message_text=>'Anexar Arquivos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282213006100870964)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_language=>'pt-br'
,p_message_text=>'Fechado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283441685555871768)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cabe\00E7alho')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282214368991870965)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('est\00E1 vazio.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282214126690870965)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Um destes arquivos \00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282212964802870964)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_language=>'pt-br'
,p_message_text=>'Abrir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282215441778870966)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Permanentemente Selecionado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283141053876871563)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Expurgar Tudo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282215308128870966)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_language=>'pt-br'
,p_message_text=>'Reintegrar Selecionado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282213465353870964)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_language=>'pt-br'
,p_message_text=>'Modelos de Resposta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282214235436870965)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_language=>'pt-br'
,p_message_text=>'muito grande para upload. <br>Os arquivos devem ser menores que'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282214569358870965)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os tipos de arquivos suportados s\00E3o: ')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283367586733871718)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Selecionar um Modelo de Resposta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282214038017870965)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este arquivo est\00E1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282214431751870965)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o \00E9 um tipo de arquivo suportado.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283079882797871523)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_language=>'pt-br'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283080481993871524)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Problema na Documenta\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283079959201871523)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00E3o de Melhoria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283080098207871523)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00E3o de Funcionalidade')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283080349753871524)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Problema de Instala\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283080216899871523)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_language=>'pt-br'
,p_message_text=>'Problema de Desempenho'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283080129324871523)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Problema de Seguran\00E7a')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283080514711871524)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_language=>'pt-br'
,p_message_text=>'Problema de Treinamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283081273061871524)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Administra\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283080916977871524)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_language=>'pt-br'
,p_message_text=>'CSS / HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283081078145871524)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00F5es Din\00E2micas / JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283080763941871524)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_language=>'pt-br'
,p_message_text=>'Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283081373927871524)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Integra\00E7\00E3o do Sistema Externo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283080871801871524)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Integra\00E7\00E3o REST')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283081162661871524)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Seguran\00E7a')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283080693723871524)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_language=>'pt-br'
,p_message_text=>'UI / UX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283079707297871523)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Categoria designada ao problema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283078807366871522)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Categoria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283079669801871523)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rea funcional afetada pelo problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283078960086871523)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rea Funcional')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283079524252871523)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00EDvel de import\00E2ncia designado ao problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283079036142871523)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Import\00E2ncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283079437602871523)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00EDvel de esfor\00E7o para tratar do problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283079199305871523)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00EDvel de Esfor\00E7o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283079339428871523)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Andamento do problema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283079252116871523)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Andamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283081740950871524)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_language=>'pt-br'
,p_message_text=>'Backlog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283081435029871524)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cr\00EDtico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283081502405871524)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_language=>'pt-br'
,p_message_text=>'Importante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283081630606871524)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_language=>'pt-br'
,p_message_text=>'Normal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283081829757871524)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o Ser\00E1 Tratado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283081962303871525)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Corre\00E7\00E3o F\00E1cil')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283082120780871525)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Grande Esfor\00E7o de Desenvolvimento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283082071154871525)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esfor\00E7o Moderado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283082515528871525)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o Pode Ser Corrigido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283082695656871525)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conclu\00EDdo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283082357817871525)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Requer Mais Informa\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283082456545871525)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_language=>'pt-br'
,p_message_text=>'Aguardando Terceiros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283082260236871525)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_language=>'pt-br'
,p_message_text=>'Trabalhando nisso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283092930624871532)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este Grupo de Labels n\00E3o pode ser exclu\00EDdo porque um ou mais de seus membros foram designados a um problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282212873298870964)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Duplica\00E7\00E3o marcada de')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283140505398871563)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_language=>'pt-br'
,p_message_text=>'Favorecidos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283140474007871563)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_language=>'pt-br'
,p_message_text=>'Labels'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283140903089871563)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_language=>'pt-br'
,p_message_text=>'Marcos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283140345382871563)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_language=>'pt-br'
,p_message_text=>'Status'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282210736684870963)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_language=>'pt-br'
,p_message_text=>'marcos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283083277318871525)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Congelamento do C\00F3digo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283083427242871526)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_language=>'pt-br'
,p_message_text=>'Release Final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283083310382871525)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Congelamento da Interface de Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282215215208870966)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 adicionou um coment\00E1rio a %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282171312736870938)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_language=>'pt-br'
,p_message_text=>'foi alterado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283097184254871534)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O n\00FAmero do problema %0 no espa\00E7o de trabalho %1 foi alterado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283372294025871721)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum Label foi definido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282213928548870965)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_language=>'pt-br'
,p_message_text=>'Outro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282211410202870963)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282211233695870963)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A p\00E1gina n\00E3o existe mais')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283433550161871762)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_language=>'pt-br'
,p_message_text=>'Expurgar Tudo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283155835527871573)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_language=>'pt-br'
,p_message_text=>'Remover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282211084661870963)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Removida a associa\00E7\00E3o de Aplicativo e P\00E1gina de')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282211768320870963)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_language=>'pt-br'
,p_message_text=>'Removido o anexo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283407329384871745)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Deseja substituir seu coment\00E1rio atual por este modelo?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283409390277871746)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ol\00E1! '),
'',
unistr('Este \00E9 o seu primeiro problema! Voc\00EA pode criar problemas para fazer o acompanhamento de tarefas, funcionalidades, bugs e feedback de todos os seus projetos APEX! \00C9 poss\00EDvel adicionar labels aos problemas, adicionar favorecidos, definir marcos e at\00E9 ')
||unistr('mesmo aplicar formata\00E7\00E3o usando Markdown abreviada!  '),
'',
unistr('Abaixo est\00E1 uma r\00E1pida amostra do que voc\00EA pode fazer com a Markdown:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283409299157871746)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Bem-vindo ao Team Development no Oracle APEX!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283156116151871573)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_language=>'pt-br'
,p_message_text=>'- Selecionar -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282211813915870963)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_language=>'pt-br'
,p_message_text=>'Definir o status como'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282188253318870948)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mostrar a\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283409149388871746)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar Mais...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282211525496870963)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_language=>'pt-br'
,p_message_text=>'Assinado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283372655387871721)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 no espa\00E7o de trabalho %1 possui %2 novas notifica\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283076330313871521)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo usado para registrar um bug no log.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283076260719871521)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo de Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283076155866871521)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Comportamento Esperado**',
unistr('- Informe o que voc\00EA acredita que deve acontecer.'),
'',
'',
'**Comportamento Atual**',
'- Informe o que acontece.',
'',
'',
unistr('**Quem \00E9 afetado**'),
unistr('- Informe quem/o que \00E9 afetado. '),
'',
unistr('**Poss\00EDvel Solu\00E7\00E3o**'),
unistr('- Se puder, sugira como voc\00EA corrigiria esse bug.'),
'',
'**Etapas a Serem Reproduzidas**',
unistr('- Forne\00E7a um conjunto n\00E3o amb\00EDguo de etapas a serem reproduzidas, incluindo capturas de tela e trechos de c\00F3digo, se for apropriado.'),
'1.',
'2.',
'3.',
'',
'**Contexto**',
unistr('- O que voc\00EA estava tentando fazer quando o bug ocorreu. O bug s\00F3 o corre em determinadas condi\00E7\00F5es, ou em certas horas do dia, e assim por diante.'),
'',
'**Ambiente**',
'',
unistr('- Vers\00E3o: '),
'- Plataforma: ',
'- Subsistema:',
'',
'______',
'',
unistr('_**OBSERVA\00C7\00C3O:** Para associar um problema a um aplicativo e/ou p\00E1gina, primeiro registro o problema, depois use o drop down **A\00C7\00D5ES** para associar o Aplicativo e a P\00E1gina._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283077413092871522)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Um bug foi adicionado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283077302479871522)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Bug Adicionado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283077522112871522)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Um **Bug** foi arquivado no sistema externo apropriado.',
'',
'- Sistema de Rastreamento de Bug: ',
'- ID do Bug: ',
'- URL para o bug: ',
'',
unistr('Coment\00E1rios:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283076582809871521)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo usado para registrar uma funcionalidade no log.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283076429225871521)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo de Solicita\00E7\00E3o de Funcionalidade')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283076648513871521)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Resumo da Funcionalidade**',
unistr(' - Forne\00E7a um par\00E1grafo de vis\00E3o geral da solicita\00E7\00E3o da funcionalidade.'),
'',
'',
'**Contexto**',
unistr(' - Essa solicita\00E7\00E3o se refere a uma situa\00E7\00E3o ou processo espec\00EDfico? Por exemplo, "Fico sempre frustrado quando [...]"'),
'',
'',
unistr(' - Forne\00E7a informa\00E7\00F5es de apoio, incluindo capturas de tela, casos de uso e assim por diante.'),
'',
'',
unistr('**Solu\00E7\00E3o Preferencial**'),
unistr('- Forne\00E7a uma descri\00E7\00E3o clara do que voc\00EA gostaria que fosse implementado.'),
'',
'',
unistr('**Solu\00E7\00F5es Alternativas**'),
unistr('- Forne\00E7a uma descri\00E7\00E3o de outras solu\00E7\00F5es ou funcionalidades consideradas, ou de solu\00E7\00F5es alternativas usadas.'),
'',
'',
'______',
unistr('_**OBSERVA\00C7\00C3O:** Para associar um problema a um aplicativo e/ou p\00E1gina, primeiro registre o problema, depois use o drop down **A\00C7\00D5ES** para associar o Aplicativo e a P\00E1gina._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283077775780871522)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Uma solicita\00E7\00E3o de funcionalidade foi arquivada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283077633666871522)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00E3o de Funcionalidade Arquivada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283077854896871522)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Uma **Solicita\00E7\00E3o de Funcionalidade** foi arquivada no sistema externo apropriado.'),
'',
'- Sistema de Rastreamento de Funcionalidade: ',
'- ID da Funcionalidade: ',
unistr('- URL para a Defini\00E7\00E3o da Funcionalidade: '),
'',
unistr('Coment\00E1rios:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283078648771871522)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Uma a\00E7\00E3o de acompanhamento \00E9 necess\00E1ria.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283078530307871522)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00E3o de Acompanhamento Necess\00E1ria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283078784271871522)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Execute as seguintes a\00E7\00F5es: '),
'',
'1.',
'2.',
'3.',
'4.',
'',
unistr('Coment\00E1rios: ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283076882703871521)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo usado para fazer uma pergunta de procedimento.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283076725747871521)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Como Posso...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283076991717871521)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Pergunta**',
unistr('- Fa\00E7a sua pergunta ou solicita\00E7\00E3o da forma mais sucinta poss\00EDvel.'),
'',
'**Contexto Geral**',
unistr('- O que voc\00EA est\00E1 tentando fazer? '),
'',
'',
unistr('- Onde mais voc\00EA procurou ou quem mais voc\00EA contatou para encontrar uma resposta? '),
'',
'',
'**Ambiente** ',
unistr('Essa pergunta \00E9 espec\00EDfica de um ambiente, linguagem de programa\00E7\00E3o ou outra \00E1rea?'),
'',
'______',
unistr('_**OBSERVA\00C7\00C3O:** Para associar um problema a um aplicativo e/ou p\00E1gina, primeiro registre o problema, depois use o drop down **A\00C7\00D5ES** para associar o Aplicativo e a P\00E1gina._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283078309436871522)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fa\00E7a refer\00EAncia a um problema conhecido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283078263515871522)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Problema Conhecido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283078428281871522)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ap\00F3s an\00E1lise, foi determinado que este \00E9 um problema conhecido. Veja os detalhes abaixo.'),
'',
'- Sistema de Rastreamento de Bug: ',
'- ID do Bug: ',
'- URL para o bug: ',
'',
unistr('Coment\00E1rios: ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283078094270871522)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicitar mais informa\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283077968640871522)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mais Informa\00E7\00F5es S\00E3o Necess\00E1rias')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283078177120871522)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**Mais informa\00E7\00F5es s\00E3o necess\00E1rias para esse problema:**'),
'',
unistr('Forne\00E7a as informa\00E7\00F5es solicitadas abaixo. Sem elas, ser\00E1 dif\00EDcil fazer a triagem e continuar a tratar do problema.'),
'',
'',
unistr('Coment\00E1rios:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283077122528871521)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esse problema n\00E3o ser\00E1 tratado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283077031242871521)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00E3o Negativa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283077246741871521)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ap\00F3s uma considera\00E7\00E3o cuidadosa, **nenhuma provid\00EAncia mais ser\00E1 tomada quanto a esse problema**. '),
'',
unistr('Coment\00E1rios:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282214909660870965)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivo de Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282213897271870965)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivos de Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282210605396870963)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_language=>'pt-br'
,p_message_text=>'esse problema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283098239871871535)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_language=>'pt-br'
,p_message_text=>'anexo %0 adicionado a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283097232689871534)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 adicionado a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283098807511871535)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_language=>'pt-br'
,p_message_text=>'%0 adicionado a %1 %2				'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283097413903871535)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_language=>'pt-br'
,p_message_text=>'%0 designado a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283097867216871535)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_language=>'pt-br'
,p_message_text=>'%0 associado a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282215104174870965)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('editou um coment\00E1rio para %0	%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283098765488871535)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_language=>'pt-br'
,p_message_text=>'Esse problema foi oculto.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283097679262871535)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_language=>'pt-br'
,p_message_text=>'%0 marcado como duplicata de %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283098633218871535)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_language=>'pt-br'
,p_message_text=>'%0 aberto por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283098389772871535)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_language=>'pt-br'
,p_message_text=>'anexo %0 removido de %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283097326645871534)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 removido de %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283098998408871536)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_language=>'pt-br'
,p_message_text=>'%0 removido de %1 %2 			'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283098449281871535)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_language=>'pt-br'
,p_message_text=>'status de %0 definido como %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283098033909871535)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_language=>'pt-br'
,p_message_text=>'inscrito em %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283097566773871535)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('designa\00E7\00E3o de %0 retirada de %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283097944262871535)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('removida a associa\00E7\00E3o de Aplicativo e P\00E1gina de %0 %1')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283097729230871535)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_language=>'pt-br'
,p_message_text=>'%0 desmarcado como duplicata de %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283098140777871535)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('cancelada a inscri\00E7\00E3o de %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283098527458871535)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_language=>'pt-br'
,p_message_text=>'duplicata de %0 %1 marcada por %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282210838523870963)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o designado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282188176921870948)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282211651923870963)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o Inscrito')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283140274657871563)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282214701003870965)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivo Zip'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282213685904870965)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivos Zip'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283446519875871771)
,p_name=>'APEX.ITEM.FILE.BROWSE'
,p_message_language=>'pt-br'
,p_message_text=>'Procurar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283444416389871770)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILE'
,p_message_language=>'pt-br'
,p_message_text=>'Escolher arquivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283444515096871770)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILES'
,p_message_language=>'pt-br'
,p_message_text=>'Escolher arquivos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283549474447871842)
,p_name=>'APEX.ITEM.HELP_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Texto da Ajuda: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283402588157871742)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Item %0 n\00E3o encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282198266429870955)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# n\00E3o est\00E1 entre o intervalo v\00E1lido de %0 e %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282198307335870955)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_MULTIPLE_OF_STEP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# n\00E3o \00E9 m\00FAltiplo de %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282197678757870954)
,p_name=>'APEX.ITEM_TYPE.YES_NO.INVALID_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'#LABEL# deve corresponder aos valores %0 e %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282197888547870954)
,p_name=>'APEX.ITEM_TYPE.YES_NO.NO_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282857453934871380)
,p_name=>'APEX.ITEM_TYPE.YES_NO.OFF_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Desativado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282857582195871380)
,p_name=>'APEX.ITEM_TYPE.YES_NO.ON_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Ativado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282197785635870954)
,p_name=>'APEX.ITEM_TYPE.YES_NO.YES_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Sim'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282168833367870936)
,p_name=>'APEX.LIST_MANAGER.ADD_ENTRY'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Entrada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283114355509871545)
,p_name=>'APEX.LIST_MANAGER.BUTTON_ADD'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283114425749871545)
,p_name=>'APEX.LIST_MANAGER.BUTTON_REMOVE'
,p_message_language=>'pt-br'
,p_message_text=>'Remover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282168921540870936)
,p_name=>'APEX.LIST_MANAGER.SELECTED_ENTRY'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas selecionadas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283346188289871703)
,p_name=>'APEX.LTO.ADVANCED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Avan\00E7ado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283346402806871704)
,p_name=>'APEX.LTO.CANCEL'
,p_message_language=>'pt-br'
,p_message_text=>'Cancelar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283346234148871703)
,p_name=>'APEX.LTO.COMMON'
,p_message_language=>'pt-br'
,p_message_text=>'Comum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283346563677871704)
,p_name=>'APEX.LTO.LIVE_TEMPLATE_OPTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es de Modelo Ativas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283347711125871704)
,p_name=>'APEX.LTO.NOT_APPLICABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('As Op\00E7\00F5es de Modelo n\00E3o est\00E3o dispon\00EDveis porque este componente n\00E3o foi processado na p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283346096924871703)
,p_name=>'APEX.LTO.NO_OPTIONS_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nenhuma Op\00E7\00E3o de Modelo encontrada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283346386695871704)
,p_name=>'APEX.LTO.SAVE'
,p_message_language=>'pt-br'
,p_message_text=>'Salvar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283343833520871702)
,p_name=>'APEX.MARKDOWN.BOLD'
,p_message_language=>'pt-br'
,p_message_text=>'Negrito'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283345199066871703)
,p_name=>'APEX.MARKDOWN.IMAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Imagem'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283344712530871702)
,p_name=>'APEX.MARKDOWN.INLINE_CODE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00F3digo em Linha')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283439657736871767)
,p_name=>'APEX.MARKDOWN.INSERT_IMAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Inserir Imagem'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283439712235871767)
,p_name=>'APEX.MARKDOWN.INSERT_LINK'
,p_message_language=>'pt-br'
,p_message_text=>'Inserir Link'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283343924758871702)
,p_name=>'APEX.MARKDOWN.ITALIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('It\00E1lico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283441471641871768)
,p_name=>'APEX.MARKDOWN.LINK'
,p_message_language=>'pt-br'
,p_message_text=>'Link'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283345071645871703)
,p_name=>'APEX.MARKDOWN.LIST'
,p_message_language=>'pt-br'
,p_message_text=>'Lista'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283344984493871703)
,p_name=>'APEX.MARKDOWN.ORDERED_LIST'
,p_message_language=>'pt-br'
,p_message_text=>'Lista Ordenada'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283344080363871702)
,p_name=>'APEX.MARKDOWN.PREVIEW'
,p_message_language=>'pt-br'
,p_message_text=>'Visualizar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283344596723871702)
,p_name=>'APEX.MARKDOWN.PREVIEW_EMPTY'
,p_message_language=>'pt-br'
,p_message_text=>'Nada a Ser Visualizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283344649067871702)
,p_name=>'APEX.MARKDOWN.STRIKETHROUGH'
,p_message_language=>'pt-br'
,p_message_text=>'Tachado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283344886581871703)
,p_name=>'APEX.MARKDOWN.UNORDERED_LIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Lista N\00E3o Ordenada')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282972532804871454)
,p_name=>'APEX.MENU.CURRENT_MENU'
,p_message_language=>'pt-br'
,p_message_text=>'atual'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283512753070871817)
,p_name=>'APEX.MENU.OVERFLOW_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Mais...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282972469825871454)
,p_name=>'APEX.MENU.PROCESSING'
,p_message_language=>'pt-br'
,p_message_text=>'Carregando'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283423357439871756)
,p_name=>'APEX.NOTIFICATION_MESSAGE_HEADING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mensagem de Notifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282334687699871042)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro de conte\00FAdo de checksum da mensagem de notifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282334558885871042)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro no formato de checksum da mensagem de notifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283048059783871503)
,p_name=>'APEX.NUMBER_FIELD.VALUE_GREATER_MAX_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# \00E9 maior que o m\00E1ximo especificado %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283048116255871503)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# deve ser Num\00E9rico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283048219282871503)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID2'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# n\00E3o corresponde ao formato de n\00FAmero %0 (Exemplo: %1).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283047944982871503)
,p_name=>'APEX.NUMBER_FIELD.VALUE_LESS_MIN_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# \00E9 anterior ao m\00EDnimo especificado %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283047878542871502)
,p_name=>'APEX.NUMBER_FIELD.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# n\00E3o est\00E1 entre o intervalo v\00E1lido de %0 e %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282573687179871196)
,p_name=>'APEX.PAGE.DUPLICATE_SUBMIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esta p\00E1gina j\00E1 foi submetida e n\00E3o pode ser ressubmetida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282436383728871107)
,p_name=>'APEX.PAGE.NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Aplicativo "%0" P\00E1gina "%1" n\00E3o encontradas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282717265252871288)
,p_name=>'APEX.PAGE_ITEM_IS_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>'#LABEL# deve ter algum valor.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283452916526871776)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_language=>'pt-br'
,p_message_text=>'Sobre este Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283452769597871776)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es de Configura\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283452894421871776)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sele\00E7\00E3o de Estilo do Tema')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283114782789871546)
,p_name=>'APEX.POPUP_LOV.BUTTON_CLOSE'
,p_message_language=>'pt-br'
,p_message_text=>'Fechar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283114691797871546)
,p_name=>'APEX.POPUP_LOV.BUTTON_FIND'
,p_message_language=>'pt-br'
,p_message_text=>'Localizar%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283114927065871546)
,p_name=>'APEX.POPUP_LOV.BUTTON_NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283114842634871546)
,p_name=>'APEX.POPUP_LOV.BUTTON_PREV'
,p_message_language=>'pt-br'
,p_message_text=>'Anterior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282192279922870951)
,p_name=>'APEX.POPUP_LOV.FILTER_REQ'
,p_message_language=>'pt-br'
,p_message_text=>'Digite um termo de pesquisa com pelo menos %0 caracteres.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282766516102871321)
,p_name=>'APEX.POPUP_LOV.ICON_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Lista de Valores Popup: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282192303434870951)
,p_name=>'APEX.POPUP_LOV.INITIAL_FILTER_REQ'
,p_message_language=>'pt-br'
,p_message_text=>'Digite um termo para pesquisa.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282192171696870951)
,p_name=>'APEX.POPUP_LOV.NO_RESULTS'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum resultado encontrado.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282192014260870951)
,p_name=>'APEX.POPUP_LOV.REMOVE_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Remover %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282934755589871429)
,p_name=>'APEX.POPUP_LOV.SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar Termo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283114587523871545)
,p_name=>'APEX.POPUP_LOV.TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Caixa de Di\00E1logo Pesquisar')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282194845156870953)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel obter o pr\00F3ximo valor da chave prim\00E1ria/obter o valor anterior da chave prim\00E1ria.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282927777914871425)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Web service n\00E3o foi encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282437804752871108)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro ao executar o processo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283406903344871745)
,p_name=>'APEX.PROCESSING'
,p_message_language=>'pt-br'
,p_message_text=>'Processamento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282221509798870970)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('O Application Express n\00E3o p\00F4de processar a solicita\00E7\00E3o devido a limita\00E7\00F5es de recurso da sess\00E3o do banco de dados. Tente novamente mais tarde.'),
'<p/>',
unistr('Os detalhes sobre este incidente est\00E3o dispon\00EDveis via id de depura\00E7\00E3o "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283463967400871783)
,p_name=>'APEX.REGION.CSSCALENDAR.ADD'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282886161221871398)
,p_name=>'APEX.REGION.CSSCALENDAR.ALL_DAY'
,p_message_language=>'pt-br'
,p_message_text=>'Um Dia Inteiro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283536298402871833)
,p_name=>'APEX.REGION.CSSCALENDAR.BUTTON.SENDEMAIL'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar Convite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283535906117871833)
,p_name=>'APEX.REGION.CSSCALENDAR.CHOOSE_ACTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282901207932871408)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_ALLDAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('View di\00E1ria para o dia todo ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282901098044871408)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_TIME_SPECIFIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('View Di\00E1ria de dados com hora ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283425887143871757)
,p_name=>'APEX.REGION.CSSCALENDAR.DAY'
,p_message_language=>'pt-br'
,p_message_text=>'Dia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283372725967871721)
,p_name=>'APEX.REGION.CSSCALENDAR.DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Descri\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282283834453871010)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.CSV'
,p_message_language=>'pt-br'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282283645154871009)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.ICALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>'iCal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282283544979871009)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.PDF'
,p_message_language=>'pt-br'
,p_message_text=>'PDF'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282283762945871009)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.XML'
,p_message_language=>'pt-br'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282283294016871009)
,p_name=>'APEX.REGION.CSSCALENDAR.ENDDATE'
,p_message_language=>'pt-br'
,p_message_text=>'Data Final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282283409692871009)
,p_name=>'APEX.REGION.CSSCALENDAR.EVENTNAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283536002147871833)
,p_name=>'APEX.REGION.CSSCALENDAR.INVITATION'
,p_message_language=>'pt-br'
,p_message_text=>'Convite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283425928471871757)
,p_name=>'APEX.REGION.CSSCALENDAR.LIST'
,p_message_language=>'pt-br'
,p_message_text=>'Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283425645420871757)
,p_name=>'APEX.REGION.CSSCALENDAR.MONTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00EAs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283440675582871767)
,p_name=>'APEX.REGION.CSSCALENDAR.NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283494348483871804)
,p_name=>'APEX.REGION.CSSCALENDAR.NOEVENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283536615499871833)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.FORM'
,p_message_language=>'pt-br'
,p_message_text=>'Edite um Evento Existente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283536586660871833)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.SEND'
,p_message_language=>'pt-br'
,p_message_text=>'Enviando um convite por e-mail.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283440707797871767)
,p_name=>'APEX.REGION.CSSCALENDAR.PREVIOUS'
,p_message_language=>'pt-br'
,p_message_text=>'Anterior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283480096308871795)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283479620771871794)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.BUTTON'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283543681757871838)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Todos os campos s\00E3o obrigat\00F3rios.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283543531864871838)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar Convite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283535602402871833)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.SUBJECT'
,p_message_language=>'pt-br'
,p_message_text=>'Assunto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283479997519871794)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.TO'
,p_message_language=>'pt-br'
,p_message_text=>'Para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282283385435871009)
,p_name=>'APEX.REGION.CSSCALENDAR.STARTDATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Data de In\00EDcio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283460637988871781)
,p_name=>'APEX.REGION.CSSCALENDAR.TABLEFORM'
,p_message_language=>'pt-br'
,p_message_text=>'Form em %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282900872472871407)
,p_name=>'APEX.REGION.CSSCALENDAR.TIME'
,p_message_language=>'pt-br'
,p_message_text=>'Hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283441332660871768)
,p_name=>'APEX.REGION.CSSCALENDAR.TODAY'
,p_message_language=>'pt-br'
,p_message_text=>'Hoje'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283426740513871758)
,p_name=>'APEX.REGION.CSSCALENDAR.VIEW'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283425764384871757)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEK'
,p_message_language=>'pt-br'
,p_message_text=>'Semana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282901193180871408)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_ALLDAY'
,p_message_language=>'pt-br'
,p_message_text=>'View semanal para o dia todo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282900940346871407)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_TIME_SPECIFIC'
,p_message_language=>'pt-br'
,p_message_text=>'View Semanal de dados com hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283426328695871758)
,p_name=>'APEX.REGION.CSSCALENDAR.YEAR'
,p_message_language=>'pt-br'
,p_message_text=>'Ano'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282195126095870953)
,p_name=>'APEX.REGION.FLASH_CHART.INITIALIZING'
,p_message_language=>'pt-br'
,p_message_text=>'Inicializando...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282454543695871119)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_DATA'
,p_message_language=>'pt-br'
,p_message_text=>'Carregando dados...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283465453910871785)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_RESOURCES'
,p_message_language=>'pt-br'
,p_message_text=>'Carregando recursos...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283465528743871785)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_TEMPLATES'
,p_message_language=>'pt-br'
,p_message_text=>'Carregando modelos...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282195273954870953)
,p_name=>'APEX.REGION.FLASH_CHART.NO_DATA_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dados n\00E3o encontrados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282360036666871058)
,p_name=>'APEX.REGION.FLASH_CHART.SHOW_XML'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282454671530871119)
,p_name=>'APEX.REGION.FLASH_CHART.WAITING'
,p_message_language=>'pt-br'
,p_message_text=>'Carregando dados. Aguarde.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283426087201871757)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283426199155871757)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.LOAD_MORE'
,p_message_language=>'pt-br'
,p_message_text=>'Carregar mais...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282626965113871230)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.BACK'
,p_message_language=>'pt-br'
,p_message_text=>'Voltar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282223051400870971)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.LOAD_MORE'
,p_message_language=>'pt-br'
,p_message_text=>'Carregar mais...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282248020134870986)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283426216644871757)
,p_name=>'APEX.REGION.JQM_REFLOW.LOAD_MORE'
,p_message_language=>'pt-br'
,p_message_text=>'Carregar mais...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283439927766871767)
,p_name=>'APEX.REGION.NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ID de Regi\00E3o %0 n\00E3o encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282234233568870978)
,p_name=>'APEX.REGION.NO_DATA_FOUND_MESSAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dados N\00E3o Encontrados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282442258893871111)
,p_name=>'APEX.REGION.PAGINATION.RESET_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o foi poss\00EDvel redefinir pagina\00E7\00E3o de regi\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282195014203870953)
,p_name=>'APEX.REGION.PAGINATION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao definir pagina\00E7\00E3o da regi\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283367434117871718)
,p_name=>'APEX.REGION.RESPONSIVE_TABLE.COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283439886157871767)
,p_name=>'APEX.REGION.TYPE_NOT_SUPPORTED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o h\00E1 suporte para o Tipo de Regi\00E3o %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282194963905870953)
,p_name=>'APEX.REGION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao renderizar a regi\00E3o "#COMPONENT_NAME#".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282717399558871288)
,p_name=>'APEX.REGION_COLUMN_IS_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>'#COLUMN_HEADER# deve ter algum valor.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282897473057871405)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Falha de autentica\00E7\00E3o do servi\00E7o de SQL Ativada REST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282221874955870970)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Falha de autentica\00E7\00E3o. A Lista de Valores usa uma origem de dados SQL Ativada REST que menciona credenciais web inv\00E1lidas, o que impedir\00E1 voc\00EA de editar as informa\00E7\00F5es da coluna nessa LOV. Verifique as credenciais de autentica\00E7\00E3o. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283435762866871764)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Falha de comunica\00E7\00E3o. Houve um problema ao chamar a origem de dados REST Enabled SQL referenciada pela Lista de Valores, o que o impedir\00E1 de editar informa\00E7\00F5es de coluna da LOV. Verifique se a origem de dados REST Enabled SQL est\00E1 funcionando correta')
||unistr('mente, e tamb\00E9m se as credenciais de autentica\00E7\00E3o correspondentes est\00E3o corretas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282965103841871449)
,p_name=>'APEX.REMOTESQL.OAUTH_IS_RECOMMENDED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Advert\00EAncia: A Oracle recomenda o uso de Credenciais do Cliente OAuth para autentica\00E7\00E3o com SQL ativada por REST.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282898841135871406)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro no Servidor Remoto: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282855601527871378)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A inst\00E2ncia especificada de SQL Ativada REST do ORDS n\00E3o foi encontrada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282456815210871120)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_language=>'pt-br'
,p_message_text=>'O servidor enviou um redirecionamento para: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282744876044871308)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_language=>'pt-br'
,p_message_text=>'O Demonstrativo SQL tem mais de 32.767 bytes.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282764765524871320)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ol\00E1, Application Express! Voc\00EA est\00E1 conectado como #USER#.'),
unistr('O timestamp do banco de dados local \00E9: #SYSDATE#.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283092820092871532)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA est\00E1 editando o alias do esquema padr\00E3o do espa\00E7o de trabalho. A defini\00E7\00E3o deste alias tamb\00E9m alterar\00E1 o Prefixo do Caminho no n\00EDvel do espa\00E7o de trabalho. Isso afetar\00E1 o URL de quaisquer servi\00E7os RESTful Baseados no APEX que voc\00EA possa ter defi')
||'nido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282752000368871312)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ORDS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A vers\00E3o atual do ORDS n\00E3o suporta a interface de Administra\00E7\00E3o REST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282752159810871312)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ROLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A atribui\00E7\00E3o do cliente em quest\00E3o n\00E3o \00E9 suportada pela interface de administra\00E7\00E3o REST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283531464707871830)
,p_name=>'APEX.RICH_TEXT_EDITOR.ACCESSIBLE_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'%0, editor RTF'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282742458379871306)
,p_name=>'APEX.RICH_TEXT_EDITOR.MAXIMUM_LENGTH_EXCEEDED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A marca\00E7\00E3o HTML Rich Text excede o tamanho m\00E1ximo do item (real %0, permitido %1 caracteres)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283424621486871756)
,p_name=>'APEX.RV.DELETE'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283350408785871706)
,p_name=>'APEX.RV.DUPLICATE'
,p_message_language=>'pt-br'
,p_message_text=>'Duplicado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283345665270871703)
,p_name=>'APEX.RV.EXCLUDE_HIDDEN'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas Exibidas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283345591201871703)
,p_name=>'APEX.RV.EXCLUDE_NULL'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Valores Nulos'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283424728055871756)
,p_name=>'APEX.RV.INSERT'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282884801808871397)
,p_name=>'APEX.RV.MOVE_DOWN'
,p_message_language=>'pt-br'
,p_message_text=>'Mover para Baixo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282884914747871397)
,p_name=>'APEX.RV.MOVE_UP'
,p_message_language=>'pt-br'
,p_message_text=>'Mover para Cima'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283345354567871703)
,p_name=>'APEX.RV.NEXT_RECORD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283345962503871703)
,p_name=>'APEX.RV.NOT_GROUPED_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Outras Colunas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283345483780871703)
,p_name=>'APEX.RV.PREV_RECORD'
,p_message_language=>'pt-br'
,p_message_text=>'Anterior'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283345713466871703)
,p_name=>'APEX.RV.REC_X'
,p_message_language=>'pt-br'
,p_message_text=>'Linha %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283345806840871703)
,p_name=>'APEX.RV.REC_XY'
,p_message_language=>'pt-br'
,p_message_text=>'Linha %0 de %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283350567684871706)
,p_name=>'APEX.RV.REFRESH'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283350663400871706)
,p_name=>'APEX.RV.REVERT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Reverter Altera\00E7\00F5es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283345251604871703)
,p_name=>'APEX.RV.SETTINGS_MENU'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Menu Defini\00E7\00F5es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282819622269871355)
,p_name=>'APEX.SAMPLE_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>'Por exemplo, %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282742585993871306)
,p_name=>'APEX.SC.REFERENCES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('refer\00EAncias %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283084106290871526)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Utilit\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283084216555871526)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Utilit\00E1rios do Aplicativo \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283091606149871531)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ir para a p\00E1gina')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283091511767871531)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Ir para Componentes Compartilhados'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283084339379871526)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_language=>'pt-br'
,p_message_text=>'App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283084467337871526)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_language=>'pt-br'
,p_message_text=>'Tarefas do App Builder > '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283084577051871526)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>'Itens do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283084677424871526)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Itens de Aplicativo \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283084717484871526)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('L\00F3gica do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283084896562871526)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esquemas de Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283084986427871526)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Esquemas de Autentica\00E7\00E3o de Seguran\00E7a \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283085004757871527)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esquemas de Autoriza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283085144255871527)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Esquemas de Autoriza\00E7\00E3o de Seguran\00E7a \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283085295501871527)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_language=>'pt-br'
,p_message_text=>'Breadcrumbs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283085310709871527)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Breadcrumbs \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283085447226871527)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es de Build')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283085584619871527)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Op\00E7\00F5es de Build \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283085658353871527)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de Componentes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283085767929871527)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Defini\00E7\00F5es do Componente \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283085845010871527)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00E1lculos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283085997035871527)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C C\00E1lculos do Aplicativo \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283086055189871527)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Item do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283086125293871527)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar Esquema de Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283086226033871527)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar Op\00E7\00E3o de Build')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283086351834871527)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar C\00E1lculo do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283086464074871527)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Modelo de E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283086545733871527)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Plug-in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283086600794871528)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283086763070871528)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Credenciais Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283086846795871528)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de Carga de Dados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283086967574871528)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue para: Componentes Compartilhados \005C Defini\00E7\00F5es de Carga de Dados \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283087095019871528)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_language=>'pt-br'
,p_message_text=>'Origens de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283087172497871528)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atributos de Defini\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283087259856871528)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_language=>'pt-br'
,p_message_text=>'Modelos de E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283087374708871528)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Layouts de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283087474830871528)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Layouts de Relat\00F3rio \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283087564113871528)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_language=>'pt-br'
,p_message_text=>'Web Services Legados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283087635327871528)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Web Services Legados \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283087748708871528)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Listas de Navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283087858285871528)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Listas de Navega\00E7\00E3o Cl\00E1ssica \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283087998571871528)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_language=>'pt-br'
,p_message_text=>'Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283088002938871528)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Lista de Valores \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283088183012871529)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283088246953871529)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Outros Componentes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283088300463871529)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_language=>'pt-br'
,p_message_text=>'Plug-ins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283088443108871529)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Plug-ins \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283088580793871529)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_language=>'pt-br'
,p_message_text=>'Processos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283088687223871529)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Processos do Aplicativo \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283088707769871529)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Consultas de Relat\00F3rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283088850935871529)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Consultas de Relat\00F3rio \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283088943568871529)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283089064654871529)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_language=>'pt-br'
,p_message_text=>'SQL Ativada REST'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283089174598871529)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C REST Enabled SQL \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283089268629871529)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Seguran\00E7a')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283089316055871529)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prote\00E7\00E3o de Estado de Sess\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283089455207871529)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Definir Prote\00E7\00E3o de Estado do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283089630532871530)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Componentes Compartilhados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283089727279871530)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283089860986871530)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_language=>'pt-br'
,p_message_text=>'Atalhos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283089905565871530)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Atalhos \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283090055138871530)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_language=>'pt-br'
,p_message_text=>'Guias (Legado)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283090152300871530)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_language=>'pt-br'
,p_message_text=>'Modelos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283090264324871530)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Modelos de Interface do Usu\00E1rio \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283090361726871530)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_language=>'pt-br'
,p_message_text=>'Temas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283090463284871530)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Temas de Interface do Usu\00E1rio \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283090557158871530)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Interface do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283090649878871530)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_language=>'pt-br'
,p_message_text=>'Credenciais Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283090771785871530)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C Credenciais Web de Seguran\00E7a \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283090845730871530)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00F3dulos de Origem Web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283090973410871530)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navegue at\00E9: Componentes Compartilhados \005C M\00F3dulos de Origem Web \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283091024405871530)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_language=>'pt-br'
,p_message_text=>'SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283091183542871531)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283091235320871531)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>'Criar %LIST_ITEM_NAME% no SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283091317505871531)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_language=>'pt-br'
,p_message_text=>'Editor de Script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283091487660871531)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_language=>'pt-br'
,p_message_text=>'Tarefas do SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283473909190871790)
,p_name=>'APEX.SESSION.DB_SESSION_CLEANUP.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar c\00F3digo de limpeza de sess\00E3o do banco de dados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282435821858871107)
,p_name=>'APEX.SESSION.DB_SESSION_INIT.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar c\00F3digo de configura\00E7\00E3o de sess\00E3o do banco de dados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282209587790870962)
,p_name=>'APEX.SESSION.EXPIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sua sess\00E3o expirou')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283465623890871785)
,p_name=>'APEX.SESSION.EXPIRED.CLOSE_DIALOG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Feche esta caixa de di\00E1logo e pressione o bot\00E3o de recarregar o seu browser para obter uma nova sess\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283525858227871826)
,p_name=>'APEX.SESSION.EXPIRED.NEW_SESSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Clique <a href="%0">aqui</a> para criar uma nova sess\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282888939553871400)
,p_name=>'APEX.SESSION.RAS.NO_DYNAMIC_ROLES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nenhuma Atribui\00E7\00E3o Din\00E2mica poder ser ativada na sess\00E3o Seguran\00E7a Real do Aplicativo para o usu\00E1rio "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282428791269871102)
,p_name=>'APEX.SESSION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ERR-99900 N\00E3o foi poss\00EDvel criar ID de sess\00E3o \00FAnico: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283536998754871833)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Item de p\00E1gina %0 \00E9 baseado em uma Coluna do Banco de Dados, mas o atributo ''Origem Usada'' est\00E1 definido como ''Somente quando o valor atual no estado da sess\00E3o for nulo''. Isso \00E9 muito perigoso e pode resultar na substitui\00E7\00E3o acidental de dados ao v')
||unistr('isualizar e salvar v\00E1rios registros. Sempre defina ''Origem Usada'' como ''Sempre, substituindo qualquer valor existente no estado da sess\00E3o''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283446408547871771)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O acesso ao estado da sess\00E3o foi desativado; tentativa de leitura/grava\00E7\00E3o bloqueada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282247137266870986)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tentativa de salvar o item %0 no estado da sess\00E3o durante o processamento da exibi\00E7\00E3o; o item possui o n\00EDvel de prote\00E7\00E3o Interna Somente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282228541705870974)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tentativa de salvar o item %0 no estado da sess\00E3o durante o processamento da aceita\00E7\00E3o; o item possui o n\00EDvel de prote\00E7\00E3o Interna Somente ou n\00E3o \00E9 um item de form que possa ser publicado com o comando POST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282503034150871150)
,p_name=>'APEX.SESSION_STATE.ITEM_VALUE_PROTECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Viola\00E7\00E3o de prote\00E7\00E3o de estado de sess\00E3o. Isso pode ser causado por uma altera\00E7\00E3o manual do item %0 de p\00E1gina protegido. Se n\00E3o estiver certo quanto ao que causou este erro, entre em contato com o administrador da publica\00E7\00E3o para obter ajuda.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283561935694871850)
,p_name=>'APEX.SESSION_STATE.PAGE_PROTECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Viola\00E7\00E3o de prote\00E7\00E3o da p\00E1gina: isso pode ser causado pela submiss\00E3o de uma p\00E1gina que ainda n\00E3o tinha terminado de carregar ou pela altera\00E7\00E3o manual de itens de p\00E1gina protegidos. Para obter ajuda, entre em contato com o administrador do aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283558897342871848)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 cont\00E9m um dos seguintes caracteres inv\00E1lidos &<>"/;,*|=% ou --')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283558982864871848)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR_NL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 cont\00E9m um dos seguintes caracteres inv\00E1lidos &<>"/;,*|=% ou -- ou nova linha.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283558628728871848)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.US_ONLY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 cont\00E9m caracteres especiais. Somente os caracteres de a-Z, 0-9 e espa\00E7os s\00E3o permitidos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283558759688871848)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 cont\00E9m <, > ou " que s\00E3o caracteres inv\00E1lidos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282228168023870974)
,p_name=>'APEX.SESSION_STATE.SSP_CHECKSUM_MISSING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o foi fornecida uma checksum para o procedimento de exibi\00E7\00E3o de uma p\00E1gina que requer uma checksum quando um ou mais valores de solicita\00E7\00E3o, limpeza de cache ou argumento s\00E3o especificados como argumentos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282490007478871141)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Viola\00E7\00E3o de prote\00E7\00E3o de estado de sess\00E3o. Isso pode ser causado por uma altera\00E7\00E3o manual de um URL que cont\00E9m uma checksum ou pela utiliza\00E7\00E3o de um link com uma checksum incorreta ou que n\00E3o foi encontrada. Se n\00E3o estiver certo quanto ao que causou e')
||unistr('ste erro, entre em contato com o administrador da publica\00E7\00E3o para obter ajuda.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282228265939870974)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('A checksum calculada com base na solicita\00E7\00E3o, limpeza de cache, nomes de argumentos e valores de argumentos (%0) n\00E3o correspondeu \00E0 checksum especificada no procedimento de exibi\00E7\00E3o (%1).'),
'',
unistr('Observa\00E7\00E3o: Os usu\00E1rios finais obt\00EAm uma mensagem de erro diferente.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282227157896870973)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Tentativa de salvar o item %0 no estado da sess\00E3o durante o processamento de exibi\00E7\00E3o. O n\00EDvel de prote\00E7\00E3o do item indica:'),
' %1',
unistr('Nenhuma checksum foi especificada ou a checksum especificada \00E9 adequada para um item com n\00EDvel de prote\00E7\00E3o "%2".'),
'',
unistr('Observa\00E7\00E3o: os usu\00E1rios finais recebem uma mensagem de erro diferente.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282437640514871108)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ERR-1022 N\00E3o foi poss\00EDvel salvar os atributos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283346659777871704)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_OFF'
,p_message_language=>'pt-br'
,p_message_text=>'Desativar Modo de Contraste Elevado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283346768861871704)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_ON'
,p_message_language=>'pt-br'
,p_message_text=>'Ativar Modo de Contraste Elevado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282462456627871123)
,p_name=>'APEX.SHUTTLE.CONTROL_BOTTOM'
,p_message_language=>'pt-br'
,p_message_text=>'Inferior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282462600795871124)
,p_name=>'APEX.SHUTTLE.CONTROL_DOWN'
,p_message_language=>'pt-br'
,p_message_text=>'Inativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282462701939871124)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE'
,p_message_language=>'pt-br'
,p_message_text=>'Mover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282462894721871124)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Mover Tudo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282462996478871124)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE'
,p_message_language=>'pt-br'
,p_message_text=>'Remover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282463064599871124)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Remover Tudo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282463147115871124)
,p_name=>'APEX.SHUTTLE.CONTROL_RESET'
,p_message_language=>'pt-br'
,p_message_text=>'Redefinir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282462343542871123)
,p_name=>'APEX.SHUTTLE.CONTROL_TOP'
,p_message_language=>'pt-br'
,p_message_text=>'Superior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282462520302871124)
,p_name=>'APEX.SHUTTLE.CONTROL_UP'
,p_message_language=>'pt-br'
,p_message_text=>'Ativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283499864243871808)
,p_name=>'APEX.SINCE.SHORT.DAYS_AGO'
,p_message_language=>'pt-br'
,p_message_text=>'%0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283500564071871809)
,p_name=>'APEX.SINCE.SHORT.DAYS_FROM_NOW'
,p_message_language=>'pt-br'
,p_message_text=>'em %0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283499754744871808)
,p_name=>'APEX.SINCE.SHORT.HOURS_AGO'
,p_message_language=>'pt-br'
,p_message_text=>'%0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283500623314871809)
,p_name=>'APEX.SINCE.SHORT.HOURS_FROM_NOW'
,p_message_language=>'pt-br'
,p_message_text=>'em %0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283499566329871808)
,p_name=>'APEX.SINCE.SHORT.MINUTES_AGO'
,p_message_language=>'pt-br'
,p_message_text=>'%0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283500751922871809)
,p_name=>'APEX.SINCE.SHORT.MINUTES_FROM_NOW'
,p_message_language=>'pt-br'
,p_message_text=>'em %0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283500129417871808)
,p_name=>'APEX.SINCE.SHORT.MONTHS_AGO'
,p_message_language=>'pt-br'
,p_message_text=>'%0mo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283500342690871808)
,p_name=>'APEX.SINCE.SHORT.MONTHS_FROM_NOW'
,p_message_language=>'pt-br'
,p_message_text=>'em %0mo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283499636340871808)
,p_name=>'APEX.SINCE.SHORT.SECONDS_AGO'
,p_message_language=>'pt-br'
,p_message_text=>'%0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283500446744871809)
,p_name=>'APEX.SINCE.SHORT.SECONDS_FROM_NOW'
,p_message_language=>'pt-br'
,p_message_text=>'em %0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283499929003871808)
,p_name=>'APEX.SINCE.SHORT.WEEKS_AGO'
,p_message_language=>'pt-br'
,p_message_text=>'%0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283500823248871809)
,p_name=>'APEX.SINCE.SHORT.WEEKS_FROM_NOW'
,p_message_language=>'pt-br'
,p_message_text=>'em %0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283500066431871808)
,p_name=>'APEX.SINCE.SHORT.YEARS_AGO'
,p_message_language=>'pt-br'
,p_message_text=>'%0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283500224168871808)
,p_name=>'APEX.SINCE.SHORT.YEARS_FROM_NOW'
,p_message_language=>'pt-br'
,p_message_text=>'em %0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282676242338871261)
,p_name=>'APEX.SPLITTER.COLLAPSE_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Contrair'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282676104914871261)
,p_name=>'APEX.SPLITTER.RESTORE_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Restaurar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283083154830871525)
,p_name=>'APEX.STAR_RATING.CLEAR_RATING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Apagar Classifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283047132053871502)
,p_name=>'APEX.STAR_RATING.INVALID_RATING_RANGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 na faixa de classifica\00E7\00E3o v\00E1lida de 1 a %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283047245640871502)
,p_name=>'APEX.STAR_RATING.IS_NOT_NUMERIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o \00E9 num\00E9rico')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283019126051871484)
,p_name=>'APEX.SUCCESS_MESSAGE_HEADING'
,p_message_language=>'pt-br'
,p_message_text=>'Mensagem de Sucesso'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282334871453871042)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro de conte\00FAdo de checksum da mensagem com sucesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282334702276871042)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro no formato de checksum da mensagem com sucesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283531039922871829)
,p_name=>'APEX.TABS.NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283530921864871829)
,p_name=>'APEX.TABS.PREVIOUS'
,p_message_language=>'pt-br'
,p_message_text=>'Anterior'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282186282964870947)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao calcular valor padr\00E3o para a coluna #COMPONENT_NAME#.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282186848783870947)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar Exclus\00E3o de V\00E1rias Linhas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282471887317871129)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A coluna de checksum ("FCS") \00E9 obrigat\00F3ria e n\00E3o foi fornecida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282472052105871130)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o foram fornecidos valores-chave; pelo menos uma linha deve ser fornecida para que as atualiza\00E7\00F5es ocorram')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282472860206871130)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o foram fornecidos valores secund\00E1rios para a coluna de chave secund\00E1ria identificada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282589794290871206)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_language=>'pt-br'
,p_message_text=>'nenhum dado encontrado em formato tabular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282471747399871129)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A coluna de chave prim\00E1ria n\00E3o foi especificada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282472779086871130)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A coluna de chave secund\00E1ria identificada n\00E3o foi localizada na lista de sele\00E7\00E3o da consulta')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282471691405871129)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Nome da Tabela n\00E3o foi especificado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282471552570871129)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Propriet\00E1rio da Tabela n\00E3o foi especificado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282493864859871144)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao executar processo de Atualiza\00E7\00E3o de V\00E1rias Linhas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283494415208871804)
,p_name=>'APEX.TB.TOOLBAR'
,p_message_language=>'pt-br'
,p_message_text=>'Barra de Ferramentas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282355154602871055)
,p_name=>'APEX.TEAM.COMMITTED'
,p_message_language=>'pt-br'
,p_message_text=>'Confirmado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282354916224871055)
,p_name=>'APEX.TEAM.CONTRIBUTOR'
,p_message_language=>'pt-br'
,p_message_text=>'Colaborador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282356808439871056)
,p_name=>'APEX.TEAM.CREATE'
,p_message_language=>'pt-br'
,p_message_text=>'Funcionalidade %0 adicionada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282356975615871056)
,p_name=>'APEX.TEAM.DELETE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Funcionalidade %0 exclu\00EDda.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282177252108870941)
,p_name=>'APEX.TEAM.DEPRECATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O APEX Team Development tornou-se obsoleto a partir da vers\00E3o 19.2 e ser\00E1 removido de uma release futura. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282355247704871055)
,p_name=>'APEX.TEAM.ESTIMATED_EFFORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esfor\00E7o Estimado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282355540561871055)
,p_name=>'APEX.TEAM.FEATURE_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Descri\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282354770948871055)
,p_name=>'APEX.TEAM.FEATURE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Recurso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282355356312871055)
,p_name=>'APEX.TEAM.FEATURE_STATUS'
,p_message_language=>'pt-br'
,p_message_text=>'Status do Recurso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282355452133871055)
,p_name=>'APEX.TEAM.MILESTONE'
,p_message_language=>'pt-br'
,p_message_text=>'Marco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282355725304871055)
,p_name=>'APEX.TEAM.NO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282354821621871055)
,p_name=>'APEX.TEAM.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282355059234871055)
,p_name=>'APEX.TEAM.RELEASE'
,p_message_language=>'pt-br'
,p_message_text=>'Release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282353823436871054)
,p_name=>'APEX.TEAM.SAVE'
,p_message_language=>'pt-br'
,p_message_text=>'Funcionalidade %0 atualizada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282355691212871055)
,p_name=>'APEX.TEAM.YES'
,p_message_language=>'pt-br'
,p_message_text=>'Sim'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283533801491871831)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_NAV_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Expandir / Recolher Navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283533960346871831)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_SIDE_COL_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Expandir / Recolher Coluna Lateral'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282209954525870962)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel copiar o tema "%0" no aplicativo "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283526375879871826)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('O tema importado n\00E3o \00E9 compat\00EDvel com o tema atual.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283492115380871803)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O n\00FAmero do tema \00E9 inv\00E1lido ou o tema n\00E3o \00E9 um tema de IU atual.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282816054613871353)
,p_name=>'APEX.TIME.DAY'
,p_message_language=>'pt-br'
,p_message_text=>'1 dia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282815857532871353)
,p_name=>'APEX.TIME.HOUR'
,p_message_language=>'pt-br'
,p_message_text=>'1 hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282816197307871353)
,p_name=>'APEX.TIME.N_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 dias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282815931499871353)
,p_name=>'APEX.TIME.N_HOURS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 horas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282815783211871353)
,p_name=>'APEX.TIME.N_MINUTES'
,p_message_language=>'pt-br'
,p_message_text=>'%0 minutos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282816337073871353)
,p_name=>'APEX.TIME.N_WEEKS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 semanas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282816211015871353)
,p_name=>'APEX.TIME.WEEK'
,p_message_language=>'pt-br'
,p_message_text=>'1 semana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283445536612871771)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('As Colunas de Chave Prim\00E1ria e Chave M\00E3e s\00E3o obrigat\00F3rias para calcular a hierarquia.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283445679918871771)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('As Colunas de N\00EDvel e Status do N\00F3 s\00E3o obrigat\00F3rias quando a hierarquia n\00E3o \00E9 calculada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283553500305871845)
,p_name=>'APEX.UI.BACK_TO_TOP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('In\00EDcio da p\00E1gina')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282371219023871065)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_language=>'pt-br'
,p_message_text=>'Modo Escuro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282371407070871065)
,p_name=>'APEX.UI.DISABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Desativado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282371354346871065)
,p_name=>'APEX.UI.ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Ativado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282810956467871350)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Selecione uma interface de usu\00E1rio na lista abaixo:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282813444873871352)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 - Sele\00E7\00E3o de Interface do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282186571360870947)
,p_name=>'APEX.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar solicita\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282331474538871040)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Acesso n\00E3o autorizado (vari\00E1vel de pacote de grupo de seguran\00E7a n\00E3o definida).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282332013980871040)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel extrair informa\00E7\00F5es de localiza\00E7\00E3o do usu\00E1rio. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282319295368871032)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O usu\00E1rio %0 precisa ter o privil\00E9gio ADMIN para executar esta opera\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282331966413871040)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O usu\00E1rio %0 n\00E3o forneceu um endere\00E7o de e-mail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282287439214871012)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Acesso n\00E3o autorizado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282331887355871040)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O usu\00E1rio %0 n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282437780887871108)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro ao processar valida\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282819920091871356)
,p_name=>'APEX.VALUE_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor Necess\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283543199653871838)
,p_name=>'APEX.WAIT_UNTIL_PAGE_LOADED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Aguarde at\00E9 a p\00E1gina ser totalmente carregada e tente novamente.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283367061327871718)
,p_name=>'APEX.WARN_ON_UNSAVED_CHANGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esta p\00E1gina tem altera\00E7\00F5es n\00E3o salvas.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283446983257871772)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Application Express n\00E3o pode calcular um perfil de dados com base nos dados de resposta do tipo: %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282877759097871393)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_language=>'pt-br'
,p_message_text=>'Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282877619751871392)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_language=>'pt-br'
,p_message_text=>'Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283430885253871761)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A express\00E3o de filtro n\00E3o \00E9 uma JSON v\00E1lida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283422567595871755)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O filtro n\00E3o \00E9 suportado pelos Oracle REST Data Services.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282764249833871320)
,p_name=>'APEX.WEBSRC.HIDE_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Ocultar Colunas Selecionadas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282857117521871379)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_language=>'pt-br'
,p_message_text=>'HTTP 200: Sucesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282857206932871379)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_language=>'pt-br'
,p_message_text=>'HTTP 201: Criado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282856631588871379)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTTP 400: Solicita\00E7\00E3o Inv\00E1lida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282856486867871379)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTTP 401: N\00E3o Autorizado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282856705519871379)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_language=>'pt-br'
,p_message_text=>'HTTP 403: Proibido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282856532854871379)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTTP 404: N\00E3o Encontrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282856893814871379)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTTP 405: M\00E9todo n\00E3o permitido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282176494456870941)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTTP 407: Autentica\00E7\00E3o de Proxy obrigat\00F3ria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282176799485870941)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_language=>'pt-br'
,p_message_text=>'HTTP 409: Conflito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282176592201870941)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTTP 412: Falha na Pr\00E9-condi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282176641734870941)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTTP 428: Pr\00E9-condi\00E7\00E3o Obrigat\00F3ria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282856997019871379)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_language=>'pt-br'
,p_message_text=>'HTTP 500: Erro Interno do Servidor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282857055691871379)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTTP 502: Gateway Inv\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283447376455871772)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTTP 503: Servi\00E7o Indispon\00EDvel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283447491416871772)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_language=>'pt-br'
,p_message_text=>'HTTP 504: Timeout do Gateway'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283366933744871718)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_language=>'pt-br'
,p_message_text=>'A Origem Web retornou um erro de HTTP: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282855552808871378)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00F3dulo de origem web n\00E3o encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282399885058871084)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Seletor de Linha "%0" n\00E3o selecionou um array de objetos a serem tratados como uma Tabela.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282399976104871084)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Seletor de Linha "%0" n\00E3o selecionou um objeto a ser tratado como uma Linha \00DAnica.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283366833183871717)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O par\00E2metro obrigat\00F3rio IN "%0" do tipo "%1" da Origem Web deve ter um valor.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283349433036871706)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O corpo da resposta \00E9 muito grande para ser exibido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282764464005871320)
,p_name=>'APEX.WEBSRC.SHOW_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar Colunas Selecionadas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282819866813871356)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O servi\00E7o REST legado do ORDS usa um Tamanho de P\00E1gina Fixo pequeno.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282764866692871320)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_language=>'pt-br'
,p_message_text=>'Timeout excedido ao extrair todos os dados de origem web.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282739531422871302)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os filtros de SQL locais atuais exigem muitas solicita\00E7\00F5es de "Pr\00F3xima P\00E1gina" ao servi\00E7o REST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282819717859871356)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Tamanho de P\00E1gina Fixo para o Servi\00E7o REST Legado do ORDS \00E9 desconhecido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283471354168871789)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Coluna de Grade Interativa ''%0'' especificada para a A\00E7\00E3o Din\00E2mica ''#COMPONENT_NAME#'' n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283471577079871789)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_language=>'pt-br'
,p_message_text=>'O processo ''%0'' gerou ''%1'' ao desempenhar o bloqueio de linha. Esse erro pode ocorrer quando o processo emite um SELECT FOR UPDATE em uma view complexa com um trigger instead-of, para bloquear a linha. Defina o atributo de processo ''Bloquear Linha'' c'
||unistr('omo N\00E3o ou C\00F3digo PL/SQL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283471462357871789)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O processo ''%0'' gerou ''%1'' ao executar um comando DML. Esse erro pode ocorrer se uma coluna se basear em uma agrega\00E7\00E3o ou express\00E3o SQL. Defina o atributo de coluna ''S\00F3 Consulta'' como Sim para excluir a coluna da instru\00E7\00E3o INSERT e UPDATE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283135521144871559)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A coluna detalhe mestre ''%0'' n\00E3o cont\00E9m um valor. Certifique-se de que o processo ''%1'' seja executado ap\00F3s o processo correspondente da regi\00E3o mestra.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283453149203871776)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Grade Interativa ''%0'' n\00E3o tem uma coluna mestra definida que \00E9 obrigat\00F3ria para um relacionamento detalhe/mestre.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282809228876871349)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Grade Interativa ''%0'' n\00E3o tem uma coluna de chave prim\00E1ria definida que \00E9 obrigat\00F3ria para um relacionamento detalhe/mestre.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283424892642871757)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Para uma Grade Interativa Edit\00E1vel, o atributo de P\00E1gina ''Recarregar ao Submeter'' deve ser definido como ''Somente para \00CAxito''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283424954566871757)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Para um Form Tabular, o atributo de P\00E1gina ''Recarregar ao Submeter'' deve ser definido como ''Sempre''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282366956662871063)
,p_name=>'APEXIR_3D'
,p_message_language=>'pt-br'
,p_message_text=>'3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283460281159871781)
,p_name=>'APEXIR_ACTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282587681634871205)
,p_name=>'APEXIR_ACTIONS_MENU'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Menu A\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282492526967871143)
,p_name=>'APEXIR_ADD'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282577234502871198)
,p_name=>'APEXIR_ADD_FUNCTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Fun\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282577121320871198)
,p_name=>'APEXIR_ADD_GROUP_BY_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Grupo por Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282901633785871408)
,p_name=>'APEXIR_ADD_PIVOT_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Coluna Piv\00F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282901759498871408)
,p_name=>'APEXIR_ADD_ROW_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Coluna de Linhas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283065409757871514)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Inscri\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282367149466871063)
,p_name=>'APEXIR_AGGREGATE'
,p_message_language=>'pt-br'
,p_message_text=>'Agregar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282611627572871220)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os agregados s\00E3o exibidos depois de cada interrup\00E7\00E3o de controle e no final do relat\00F3rio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282614767952871222)
,p_name=>'APEXIR_AGGREGATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Agrega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282493077960871143)
,p_name=>'APEXIR_AGG_AVG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9dia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282501989983871149)
,p_name=>'APEXIR_AGG_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282518974716871161)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_language=>'pt-br'
,p_message_text=>'Contar Diferentes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282493179107871143)
,p_name=>'APEXIR_AGG_MAX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282493305743871144)
,p_name=>'APEXIR_AGG_MEDIAN'
,p_message_language=>'pt-br'
,p_message_text=>'Mediano'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282493297909871144)
,p_name=>'APEXIR_AGG_MIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00EDnimo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282493485811871144)
,p_name=>'APEXIR_AGG_MODE'
,p_message_language=>'pt-br'
,p_message_text=>'Modo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282492941118871143)
,p_name=>'APEXIR_AGG_SUM'
,p_message_language=>'pt-br'
,p_message_text=>'Soma %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282494728821871145)
,p_name=>'APEXIR_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Tudo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282366188848871062)
,p_name=>'APEXIR_ALL_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Todas as Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282216903673870967)
,p_name=>'APEXIR_ALL_ROWS'
,p_message_language=>'pt-br'
,p_message_text=>'Todas as Linhas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283456719256871778)
,p_name=>'APEXIR_ALTERNATIVE'
,p_message_language=>'pt-br'
,p_message_text=>'Alternativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283458866599871780)
,p_name=>'APEXIR_ALTERNATIVE_DEFAULT_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00E3o Alternativo: %0 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282452837424871117)
,p_name=>'APEXIR_AND'
,p_message_language=>'pt-br'
,p_message_text=>'e'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282373677639871067)
,p_name=>'APEXIR_APPLY'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283422753031871755)
,p_name=>'APEXIR_AREA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rea')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282337500756871044)
,p_name=>'APEXIR_ASCENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Crescente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282465363217871125)
,p_name=>'APEXIR_AS_OF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('H\00E1 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283459463221871780)
,p_name=>'APEXIR_AVERAGE_X'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9dia %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283422697426871755)
,p_name=>'APEXIR_BAR'
,p_message_language=>'pt-br'
,p_message_text=>'Barras'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282370055278871064)
,p_name=>'APEXIR_BETWEEN'
,p_message_language=>'pt-br'
,p_message_text=>'entre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282336260687871043)
,p_name=>'APEXIR_BGCOLOR'
,p_message_language=>'pt-br'
,p_message_text=>'Cor de Fundo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283062470837871512)
,p_name=>'APEXIR_BLACK'
,p_message_language=>'pt-br'
,p_message_text=>'Preto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282338392764871044)
,p_name=>'APEXIR_BLUE'
,p_message_language=>'pt-br'
,p_message_text=>'azul'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282580054946871200)
,p_name=>'APEXIR_BOTTOM'
,p_message_language=>'pt-br'
,p_message_text=>'Inferior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282494352253871144)
,p_name=>'APEXIR_CALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Calend\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282338978161871045)
,p_name=>'APEXIR_CANCEL'
,p_message_language=>'pt-br'
,p_message_text=>'Cancelar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282379018463871070)
,p_name=>'APEXIR_CATEGORY'
,p_message_language=>'pt-br'
,p_message_text=>'Categoria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282336192360871043)
,p_name=>'APEXIR_CELL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00E9lula')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282494222546871144)
,p_name=>'APEXIR_CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1fico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282583286722871202)
,p_name=>'APEXIR_CHART_INITIALIZING'
,p_message_language=>'pt-br'
,p_message_text=>'Inicializando...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282937547896871431)
,p_name=>'APEXIR_CHART_LABEL_NOT_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 necess\00E1rio especificar o label do gr\00E1fico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283050091602871504)
,p_name=>'APEXIR_CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sua consulta ultrapassa o n\00FAmero m\00E1ximo de %0 pontos de dados por gr\00E1fico. Aplique um filtro para reduzir o n\00FAmero de registros de sua consulta base.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283044010374871500)
,p_name=>'APEXIR_CHART_MAX_ROW_CNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A contagem m\00E1xima de linha de uma consulta do Gr\00E1fico limita o n\00FAmero de linhas na consulta-base, n\00E3o o n\00FAmero de linhas exibidas. Sua consulta-base excede a contagem de linhas m\00E1xima de %0. Aplique um filtro para reduzir o n\00FAmero de registros em sua')
||' consulta-base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282366436695871062)
,p_name=>'APEXIR_CHART_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283019821760871484)
,p_name=>'APEXIR_CHECK_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Marcar Tudo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282465727727871126)
,p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Escolher formato de download do relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282568474611871193)
,p_name=>'APEXIR_CLEAR'
,p_message_language=>'pt-br'
,p_message_text=>'limpar'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282338828604871045)
,p_name=>'APEXIR_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282611761891871220)
,p_name=>'APEXIR_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283438926972871766)
,p_name=>'APEXIR_COLUMN_FILTER'
,p_message_language=>'pt-br'
,p_message_text=>'Filtrar...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282578166133871199)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cabe\00E7alho da Coluna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282572172545871195)
,p_name=>'APEXIR_COLUMN_HEADING_MENU'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Menu de Cabe\00E7alho de Coluna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282583032550871202)
,p_name=>'APEXIR_COLUMN_INFO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informa\00E7\00F5es da Coluna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283449176305871773)
,p_name=>'APEXIR_COLUMN_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Label de Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282577837241871199)
,p_name=>'APEXIR_COLUMN_N'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282447115731871114)
,p_name=>'APEXIR_COMPARISON_CONTAINS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('cont\00E9m')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282451807883871117)
,p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o cont\00E9m')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282337263479871044)
,p_name=>'APEXIR_COMPARISON_IN'
,p_message_language=>'pt-br'
,p_message_text=>'em'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282452050567871117)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o est\00E1 no \00FAltimo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282497496177871146)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o est\00E1 no pr\00F3ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282451933442871117)
,p_name=>'APEXIR_COMPARISON_IS_IN_LAST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('est\00E1 no \00FAltimo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282497370843871146)
,p_name=>'APEXIR_COMPARISON_IS_IN_NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('est\00E1 no pr\00F3ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282337144331871044)
,p_name=>'APEXIR_COMPARISON_IS_NOT_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o \00E9 nulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282337001083871044)
,p_name=>'APEXIR_COMPARISON_IS_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00E9 nulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282336828954871043)
,p_name=>'APEXIR_COMPARISON_LIKE'
,p_message_language=>'pt-br'
,p_message_text=>'como'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282337350023871044)
,p_name=>'APEXIR_COMPARISON_NOT_IN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o contido em')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282336969217871043)
,p_name=>'APEXIR_COMPARISON_NOT_LIKE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o \00E9 semelhante')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282447887716871114)
,p_name=>'APEXIR_COMPARISON_REGEXP_LIKE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('corresponde \00E0 express\00E3o regular')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282465654526871125)
,p_name=>'APEXIR_COMPUTATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00E1lculo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283043657170871500)
,p_name=>'APEXIR_COMPUTATION_EXPRESSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Express\00E3o de C\00E1lculo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282612048401871221)
,p_name=>'APEXIR_COMPUTATION_FOOTER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cria um c\00E1lculo usando aliases de coluna.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282612156716871221)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E1'
,p_message_language=>'pt-br'
,p_message_text=>'(B+C)*100'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282612252596871221)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E2'
,p_message_language=>'pt-br'
,p_message_text=>'INITCAP(B)||'', ''||INITCAP(C)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282612330108871221)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E3'
,p_message_language=>'pt-br'
,p_message_text=>'CASE WHEN A = 10 THEN B + C ELSE B END'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282204238725870959)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E4'
,p_message_language=>'pt-br'
,p_message_text=>'ROUND(C / 1000000)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282495463529871145)
,p_name=>'APEXIR_COMPUTE'
,p_message_language=>'pt-br'
,p_message_text=>'Calcular'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282578852105871200)
,p_name=>'APEXIR_CONTROL_BREAK'
,p_message_language=>'pt-br'
,p_message_text=>'Quebra de Controle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282587006255871205)
,p_name=>'APEXIR_CONTROL_BREAKS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Interrup\00E7\00F5es de Controle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283467577201871786)
,p_name=>'APEXIR_CONTROL_BREAK_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas de Quebra de Controle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282196479570870954)
,p_name=>'APEXIR_COUNT_DISTINCT'
,p_message_language=>'pt-br'
,p_message_text=>'Contar Diferentes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283459940124871780)
,p_name=>'APEXIR_COUNT_DISTINCT_X'
,p_message_language=>'pt-br'
,p_message_text=>'Contar Diferentes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283459888724871780)
,p_name=>'APEXIR_COUNT_X'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283062924814871512)
,p_name=>'APEXIR_DAILY'
,p_message_language=>'pt-br'
,p_message_text=>'Diariamente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283552441274871844)
,p_name=>'APEXIR_DATA'
,p_message_language=>'pt-br'
,p_message_text=>'Dados'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282583132786871202)
,p_name=>'APEXIR_DATA_AS_OF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dados do relat\00F3rio %0 minutos atr\00E1s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283414268200871749)
,p_name=>'APEXIR_DATA_GRID_HELP'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda da Grade de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282367368905871063)
,p_name=>'APEXIR_DATE'
,p_message_language=>'pt-br'
,p_message_text=>'Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283458469259871779)
,p_name=>'APEXIR_DAY'
,p_message_language=>'pt-br'
,p_message_text=>'Dia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282609383590871219)
,p_name=>'APEXIR_DEFAULT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283456581810871778)
,p_name=>'APEXIR_DEFAULT_REPORT_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de Relat\00F3rio Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282339013364871045)
,p_name=>'APEXIR_DELETE'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282496216113871146)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Marcado(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282368268041871063)
,p_name=>'APEXIR_DELETE_CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Deseja excluir essas defini\00E7\00F5es de relat\00F3rio?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282613596757871221)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gostaria de executar esta a\00E7\00E3o de exclus\00E3o?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283347230980871704)
,p_name=>'APEXIR_DELETE_DEFAULT_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Excluir Relat\00F3rio Padr\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282578593987871199)
,p_name=>'APEXIR_DELETE_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Excluir Relat\00F3rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282337678685871044)
,p_name=>'APEXIR_DESCENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Decrescente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282379198175871070)
,p_name=>'APEXIR_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Descri\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282572061432871195)
,p_name=>'APEXIR_DETAIL_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>'View de Uma Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282610352655871219)
,p_name=>'APEXIR_DIRECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dire\00E7\00E3o %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282587544644871205)
,p_name=>'APEXIR_DISABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Desativar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282611546261871220)
,p_name=>'APEXIR_DISABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Desativado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282367404448871063)
,p_name=>'APEXIR_DISPLAY'
,p_message_language=>'pt-br'
,p_message_text=>'Visualizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282338519021871045)
,p_name=>'APEXIR_DISPLAYED'
,p_message_language=>'pt-br'
,p_message_text=>'Exibido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282366079247871062)
,p_name=>'APEXIR_DISPLAYED_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas Exibidas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282610242714871219)
,p_name=>'APEXIR_DISPLAY_IN_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir no Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282339207538871045)
,p_name=>'APEXIR_DONUT'
,p_message_language=>'pt-br'
,p_message_text=>'Rosca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282579952223871200)
,p_name=>'APEXIR_DOWN'
,p_message_language=>'pt-br'
,p_message_text=>'Inativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282495593673871145)
,p_name=>'APEXIR_DOWNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>'Fazer Download'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282367297585871063)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('- N\00E3o agregar -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282610189765871219)
,p_name=>'APEXIR_DO_NOT_DISPLAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o Exibir')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283467740939871786)
,p_name=>'APEXIR_DUPLICATE_PIVOT_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna piv\00F4 duplicada. A lista de colunas piv\00F4 deve ser exclusiva.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283468182995871786)
,p_name=>'APEXIR_EDIT'
,p_message_language=>'pt-br'
,p_message_text=>'Editar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283406877653871744)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Alternativa Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282583320975871202)
,p_name=>'APEXIR_EDIT_CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Defini\00E7\00F5es de Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282613325326871221)
,p_name=>'APEXIR_EDIT_CHART2'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282613851233871222)
,p_name=>'APEXIR_EDIT_FILTER'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283109730830871542)
,p_name=>'APEXIR_EDIT_GROUP_BY'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Grupo Por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282613739712871222)
,p_name=>'APEXIR_EDIT_HIGHLIGHT'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Destaque'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282926493402871424)
,p_name=>'APEXIR_EDIT_PIVOT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Piv\00F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283456819393871778)
,p_name=>'APEXIR_EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>'E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282282151145871008)
,p_name=>'APEXIR_EMAIL_ADDRESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Endere\00E7o de E-mail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283457107135871779)
,p_name=>'APEXIR_EMAIL_BCC'
,p_message_language=>'pt-br'
,p_message_text=>'Cco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283457374548871779)
,p_name=>'APEXIR_EMAIL_BODY'
,p_message_language=>'pt-br'
,p_message_text=>'Corpo do Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283457072428871778)
,p_name=>'APEXIR_EMAIL_CC'
,p_message_language=>'pt-br'
,p_message_text=>'Cc'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283458088095871779)
,p_name=>'APEXIR_EMAIL_FREQUENCY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Frequ\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282316971704871031)
,p_name=>'APEXIR_EMAIL_NOT_CONFIGURED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O e-mail n\00E3o foi configurado para este aplicativo. Entre em contato com o administrador.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283062088430871512)
,p_name=>'APEXIR_EMAIL_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Endere\00E7o de E-mail deve ser especificado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283457451421871779)
,p_name=>'APEXIR_EMAIL_SEE_ATTACHED'
,p_message_language=>'pt-br'
,p_message_text=>'Consulte anexo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283457243547871779)
,p_name=>'APEXIR_EMAIL_SUBJECT'
,p_message_language=>'pt-br'
,p_message_text=>'Assunto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283063916452871513)
,p_name=>'APEXIR_EMAIL_SUBJECT_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>'O Assunto do E-mail deve ser especificado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283456914371871778)
,p_name=>'APEXIR_EMAIL_TO'
,p_message_language=>'pt-br'
,p_message_text=>'Para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282587499845871205)
,p_name=>'APEXIR_ENABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Ativar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282335915701871043)
,p_name=>'APEXIR_ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Ativado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282613605357871222)
,p_name=>'APEXIR_ENABLE_DISABLE_ALT'
,p_message_language=>'pt-br'
,p_message_text=>'Ativar/Desativar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282613052677871221)
,p_name=>'APEXIR_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282612428690871221)
,p_name=>'APEXIR_EXAMPLES'
,p_message_language=>'pt-br'
,p_message_text=>'Exemplos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282613405178871221)
,p_name=>'APEXIR_EXAMPLES_WITH_COLON'
,p_message_language=>'pt-br'
,p_message_text=>'Exemplos:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282365901312871062)
,p_name=>'APEXIR_EXCLUDE_NULL'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Valores Nulos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282614328816871222)
,p_name=>'APEXIR_EXPAND_COLLAPSE_ALT'
,p_message_language=>'pt-br'
,p_message_text=>'Expandir/Contrair'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282611236833871220)
,p_name=>'APEXIR_EXPRESSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Express\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282495083394871145)
,p_name=>'APEXIR_FILTER'
,p_message_language=>'pt-br'
,p_message_text=>'Filtro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282586985847871205)
,p_name=>'APEXIR_FILTERS'
,p_message_language=>'pt-br'
,p_message_text=>'Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282671401159871258)
,p_name=>'APEXIR_FILTER_EXPRESSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Express\00E3o de Filtro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283534304429871832)
,p_name=>'APEXIR_FILTER_EXPR_TOO_LONG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A express\00E3o de filtro \00E9 muito longa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282671366322871258)
,p_name=>'APEXIR_FILTER_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282614537032871222)
,p_name=>'APEXIR_FINDER_ALT'
,p_message_language=>'pt-br'
,p_message_text=>'Selecionar colunas para pesquisa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282495330298871145)
,p_name=>'APEXIR_FLASHBACK'
,p_message_language=>'pt-br'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282610915517871220)
,p_name=>'APEXIR_FLASHBACK_DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>'Uma consulta de flashback permite exibir os dados conforme existiam em um momento anterior.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282612821824871221)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel realizar a solicita\00E7\00E3o de flashback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283062644065871512)
,p_name=>'APEXIR_FLASHBACK_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dura\00E7\00E3o do Flashback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283071288980871518)
,p_name=>'APEXIR_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>'Formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282465525176871125)
,p_name=>'APEXIR_FORMAT_MASK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1scara de Formato %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282578229409871199)
,p_name=>'APEXIR_FUNCTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282611976731871220)
,p_name=>'APEXIR_FUNCTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00F5es %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283456447448871778)
,p_name=>'APEXIR_FUNCTIONS_OPERATORS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00F5es / Operadores')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283044156046871500)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna de Fun\00E7\00E3o %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282577748929871199)
,p_name=>'APEXIR_FUNCTION_N'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00E3o %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282494802057871145)
,p_name=>'APEXIR_GO'
,p_message_language=>'pt-br'
,p_message_text=>'Ir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283062542389871512)
,p_name=>'APEXIR_GRAY'
,p_message_language=>'pt-br'
,p_message_text=>'Cinza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282336480042871043)
,p_name=>'APEXIR_GREEN'
,p_message_language=>'pt-br'
,p_message_text=>'verde'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282196599047870954)
,p_name=>'APEXIR_GROUP_BY'
,p_message_language=>'pt-br'
,p_message_text=>'Agrupar por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283457564217871779)
,p_name=>'APEXIR_GROUP_BY_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Agrupar por Coluna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282937638621871431)
,p_name=>'APEXIR_GROUP_BY_COL_NOT_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 necess\00E1rio especificar a coluna Agrupar por.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283043993146871500)
,p_name=>'APEXIR_GROUP_BY_MAX_ROW_CNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A contagem m\00E1xima de linha de uma consulta Agrupar por limita o n\00FAmero de linhas na consulta-base, n\00E3o o n\00FAmero de linhas exibidas. Sua consulta-base excede a contagem de linhas m\00E1xima de %0. Aplique um filtro para reduzir o n\00FAmero de registros em su')
||'a consulta-base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282858033728871380)
,p_name=>'APEXIR_GROUP_BY_SORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Agrupar por Classifica\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283467634665871786)
,p_name=>'APEXIR_GROUP_BY_SORT_ORDER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Agrupar por Ordem de Classifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282366582814871062)
,p_name=>'APEXIR_HCOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna Horizontal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282604705587871216)
,p_name=>'APEXIR_HELP'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282570309012871194)
,p_name=>'APEXIR_HELP_01'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Os relat\00F3rios interativos permitem que os usu\00E1rios finais personalizem os relat\00F3rios. Os usu\00E1rios podem alterar o layout de dados do relat\00F3rio, selecionando colunas, aplicando filtros, destacando e classificando. Os usu\00E1rios tamb\00E9m podem definir queb')
||unistr('ras, agrega\00E7\00F5es, gr\00E1ficos, agrupar por e adicionar seus pr\00F3prios c\00E1lculos. Os usu\00E1rios tamb\00E9m podem configurar uma inscri\00E7\00E3o, de forma que uma vers\00E3o HTML do relat\00F3rio seja enviada por e-mail para eles em um intervalo designado. Os usu\00E1rios podem cri')
||unistr('ar varia\00E7\00F5es de um relat\00F3rio e salv\00E1-las como relat\00F3rios nomeados, para visualiza\00E7\00E3o p\00FAblica ou privada.'),
'<p/>',
unistr('As se\00E7\00F5es a seguir resumem formas de personalizar um relat\00F3rio interativo. Para saber mais, consulte "Using Interactive Reports" no <i>Oracle Application Express End User''s Guide</i></a>.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282587781990871205)
,p_name=>'APEXIR_HELP_ACTIONS_MENU'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O menu A\00E7\00F5es aparece \00E0 direita do bot\00E3o Ir na barra de Pesquisa. Use este menu para personalizar um relat\00F3rio interativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282571360180871195)
,p_name=>'APEXIR_HELP_AGGREGATE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Agregados s\00E3o c\00E1lculos matem\00E1ticos realizados em uma coluna. Os agregados s\00E3o exibidos depois de cada interrup\00E7\00E3o de controle e no final do relat\00F3rio na coluna onde s\00E3o definidos. As op\00E7\00F5es incluem:'),
'<p>',
'</p><ul>',
unistr('<li><b>Agrega\00E7\00E3o</b> permite selecionar uma agrega\00E7\00E3o previamente definida para editar.</li>'),
unistr('<li><b>Fun\00E7\00E3o</b> \00E9 a fun\00E7\00E3o a realizar (por exemplo, SUM, MIN).</li>'),
unistr('<li><b>Coluna</b> \00E9 usado para selecionar a coluna \00E0 qual aplicar a fun\00E7\00E3o'),
unistr(' matem\00E1tica. S\00F3 s\00E3o exibidas colunas num\00E9ricas.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282571425108871195)
,p_name=>'APEXIR_HELP_CHART'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Voc\00EA pode definir um gr\00E1fico por relat\00F3rio salvo. Depois'),
unistr(' de definido, voc\00EA pode alternar entre as views de gr\00E1fico e de relat\00F3rio, usando os \00EDcones de view da barra de Pesquisa.'),
unistr('As op\00E7\00F5es incluem:'),
'<p>',
'</p><ul>',
unistr('<li><b>Tipo de Gr\00E1fico</b> identifica o tipo de gr\00E1fico a incluir.'),
'Selecione entre barra horizontal, barra vertical, pizza ou linha.</li>',
'<li><b>Label</b> permite selecionar a coluna a ser usada como label.</li>',
unistr('<li><b>T\00EDtulo do Eixo do Label</b> \00E9 o t\00EDtulo exibido no eixo associado \00E0 coluna selecionada para'),
unistr(' o Label. Isso n\00E3o est\00E1 dispon\00EDvel para gr\00E1fico de pizza.</li>'),
'<li><b>Valor</b> permite selecionar a coluna a usar como o valor. Se sua',
unistr(' fun\00E7\00E3o for COUNT, n\00E3o \00E9 necess\00E1rio selecionar um Valor.</li>'),
unistr('<li><b>T\00EDtulo do Eixo do Valor</b> \00E9 o t\00EDtulo exibido no eixo associado \00E0'),
unistr(' coluna selecionada para Valor. Indispon\00EDvel para gr\00E1fico de pizza.</li>'),
unistr('<li><b>Fun\00E7\00E3o</b> \00E9 uma fun\00E7\00E3o opcional a ser executada na coluna selecionada para Valor.</li>'),
unistr('<li><b>Classifica\00E7\00E3o</b> permite classificar o conjunto de resultados.</li></ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282570793876871194)
,p_name=>'APEXIR_HELP_COLUMN_HEADING_MENU'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Clicar em qualquer cabe\00E7alho de coluna exp\00F5e um menu do cabe\00E7alho de coluna. As op\00E7\00F5es incluem:'),
'<p></p>',
'<ul>',
unistr('<li><b>\00CDcone Classificar por Ordem Crescente</b> ordena o relat\00F3rio pela coluna em ordem crescente.</li>'),
unistr('<li><b>\00CDcone Classificar por Ordem Decrescente</b> ordena o relat\00F3rio pela coluna em ordem decrescente.</li>'),
unistr('<li><b>Ocultar Coluna</b> oculta a coluna.  Nem todas as colunas podem ser ocultadas. Se uma coluna n\00E3o puder ser ocultada, o \00EDcone Ocultar Coluna n\00E3o ser\00E1 exibido.</li>'),
unistr('<li><b>Quebrar Coluna</b> cria um grupo de quebra na coluna. Isso retira a coluna do relat\00F3rio como um registro-mestre.</li>'),
unistr('<li><b>Informa\00E7\00F5es da Coluna</b> exibe texto de ajuda sobre a coluna, se dispon\00EDvel.</li>'),
unistr('<li><b>\00C1rea de Texto</b> \00E9 usada para informar crit\00E9rios de pesquisa que n\00E3o diferenciam mai\00FAsculas de min\00FAsculas'),
unistr(' (n\00E3o necess\00E1rio para caracteres curinga). Informar um valor reduzir\00E1 a lista de '),
unistr('valores na base do menu. Voc\00EA pode selecionar um valor da'),
unistr('parte inferior e o valor selecionado ser\00E1 criado como um filtro usando ''='' '),
unistr('(por exemplo, <code>coluna = ''ABC''</code>). Como alternativa, voc\00EA poder\00E1 clicar no \00EDcone da Lanterna e informar um valor que ser\00E1 criado '),
'como um filtro com o modificador ''LIKE'' ',
'(por exemplo, <code>coluna LIKE ''%ABC%''</code>).</li>',
unistr('<li><b>Lista de Valores \00DAnicos</b> cont\00E9m os 500 primeiros valores \00FAnicos '),
unistr('que atendem a seus crit\00E9rios de filtro. Se a primeira coluna for uma data, ser\00E1'),
unistr(' exibida uma lista de faixas de datas. Se selecionar um valor, ser\00E1 criado um'),
' filtro usando ''='' (por exemplo, <code>coluna = ''ABC''</code>).</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282571239009871195)
,p_name=>'APEXIR_HELP_COMPUTE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Permite que voc\00EA adicione colunas calculadas a seu relat\00F3rio. Podem ser c\00E1lculos matem\00E1ticos (por exemplo, <code>NBR_HOURS/24</code>) ou fun\00E7\00F5es padr\00E3o do Oracle'),
unistr(' aplicadas a colunas existentes. Algumas s\00E3o exibidas como exemplo, outras (como <code>TO_DATE)</code>, tamb\00E9m podem ser usadas). As op\00E7\00F5es incluem:'),
'<p><p/>',
'<ul>',
unistr('<li><b>C\00E1lculo</b> permite selecionar um c\00E1lculo previamente definido para editar.</li>'),
unistr('<li><b>Cabe\00E7alho da Coluna</b> \00E9 o cabe\00E7alho da nova coluna.</li>'),
unistr('<li><b>M\00E1scara de Formato</b> \00E9 uma m\00E1scara de formato do Oracle a ser aplicada \00E0 coluna (como S9999).</li>'),
unistr('<li><b>C\00E1lculo</b> \00E9 o c\00E1lculo a realizar, onde as colunas s\00E3o referenciadas usando os aliases exibidos.</li>'),
'</ul>',
unistr('<p>Abaixo do c\00E1lculo as colunas em sua consulta s\00E3o exibidas com'),
unistr(' seus aliases associados. Clicar no nome ou no alias da coluna ir\00E1 '),
unistr('escrev\00EA-la no C\00E1lculo. Perto das Colunas h\00E1 um teclado num\00E9rico. Estas fun\00E7\00F5es do teclado num\00E9rico s\00E3o como'),
unistr(' um atalho para as teclas mais usadas. No extremo direito est\00E3o as Fun\00E7\00F5es</p>.'),
unistr('<p>A seguir o exemplo de c\00E1lculo demonstra como exibir a remunera\00E7\00E3o total:</p>'),
'<pre>CASE WHEN A = ''SALES'' THEN B + C ELSE B END</pre>',
unistr('(onde A \00E9 ORGANIZATION, B \00E9 SALARY e C \00E9 COMMISSION)</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282587809170871205)
,p_name=>'APEXIR_HELP_CONTROL_BREAK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usado para criar um grupo de interrup\00E7\00E3o em uma ou mais colunas. Isso retira as colunas do relat\00F3rio interativo e as exibe como um registro mestre.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282571976219871195)
,p_name=>'APEXIR_HELP_DETAIL_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Para exibir os detalhes de uma linha por vez, clique no \00EDcone view de uma linha na linha que deseja exibir. Se estiver dispon\00EDvel, a view de uma linha sempre ser\00E1 a primeira coluna. Dependendo da personaliza\00E7\00E3o do relat\00F3rio interativo, a view de uma ')
||unistr('linha poder\00E1 ser a view padr\00E3o ou uma p\00E1gina personalizada que permita atualiza\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282571841710871195)
,p_name=>'APEXIR_HELP_DOWNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Permite que o conjunto de resultados atual seja obtido por download. Os formatos',
unistr('de download dependem da instala\00E7\00E3o e da defini\00E7\00E3o do relat\00F3rio mas'),
'podem incluir CSV, HTML, E-mail, XLS, PDF ou RTF.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282570968161871194)
,p_name=>'APEXIR_HELP_FILTER'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Foca o relat\00F3rio adicionando ou modificando a cl\00E1usula <code>WHERE</code> na consulta. Voc\00EA pode filtrar por coluna ou por linha.  '),
unistr('<p>Se filtrar por coluna, selecione uma coluna (n\00E3o precisa ser a que est\00E1 exibida), selecione um operador Oracle padr\00E3o  (=, !=, n\00E3o em, entre) e informe uma express\00E3o a ser comparada. As express\00F5es n\00E3o diferenciam mai\00FAsculas e min\00FAsculas. Use  % co')
||'mo curinga (por exemplo, <code>STATE_NAME',
'like A%)</code>.</p>',
unistr('<p>Se voc\00EA filtrar por linha, voc\00EA pode criar cl\00E1usulas <code>WHERE</code> complexas usando aliases da coluna e quaisquer fun\00E7\00F5es ou operadores Oracle (por exemplo, <code>G = ''VA'' ou G = ''CT''</code>, onde'),
unistr('<code>G</code> \00E9 o alias de <code>CUSTOMER_STATE</code>).</p>'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282571551848871195)
,p_name=>'APEXIR_HELP_FLASHBACK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Uma consulta de flashback permite exibir os dados conforme existiam em um momento anterior. O per\00EDodo padr\00E3o de flashback \00E9 de 3 horas (ou 180 minutos) mas o valor real difere de cada banco de dados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283071176258871518)
,p_name=>'APEXIR_HELP_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>O formato permite personalizar a exibi\00E7\00E3o do relat\00F3rio.'),
unistr('O formato cont\00E9m o seguinte submenu:</p>'),
'<ul><li>Classificar</li>',
'<li>Quebras de Controle</li>',
'<li>Destaque</li>',
'<li>Calcular</li>',
'<li>Agregar</li>',
unistr('<li>Gr\00E1fico</li>'),
'<li>Agrupar por</li>',
unistr('<li>Piv\00F4</li>'),
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283061841409871512)
,p_name=>'APEXIR_HELP_GROUP_BY'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Voc\00EA pode definir uma view Agrupar por para cada relat\00F3rio salvo.'),
unistr('Depois de definido, \00E9 poss\00EDvel alternar entre as views e relat\00F3rios Agrupar por'),
unistr('usando \00EDcones de views da barra de Pesquisa. Para criar uma view Agrupar por,'),
'selecione:',
'<p></p><ul>',
unistr('<li>as colunas nas quais ser\00E3o agrupadas</li>'),
unistr('<li>as colunas a serem agregadas com a fun\00E7\00E3o a ser executada (m\00E9dia, soma, contagem etc.)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282571131782871194)
,p_name=>'APEXIR_HELP_HIGHLIGHT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite a voc\00EA definir um filtro. As linhas que atendem ao crit\00E9rio do filtro s\00E3o destacadas usando as caracter\00EDsticas associadas ao filtro. As op\00E7\00F5es incluem:'),
'<p/>',
unistr('<ul><li><b>Nome</b> \00E9 usado apenas para exibi\00E7\00E3o.</li>'),
unistr('<li><b>Sequ\00EAncia</b> identifica a sequ\00EAncia na qual as regras ser\00E3o avaliadas.</li>'),
unistr('<li><b>Ativado</b> identifica se a regra est\00E1 ativada ou desativada.</li>'),
unistr('<li><b>Tipo de Destaque</b> identifica se a Linha ou C\00E9lula deve ser destacada. Se a C\00E9lula for selecionada, a coluna referenciada na Condi\00E7\00E3o de Destaque ser\00E1 destacada.</li>'),
unistr('<li><b>Cor de Fundo</b> \00E9 a nova cor do fundo da \00E1rea destacada.</li>'),
unistr('<li><b>Cor do Texto</b> \00E9 a nova cor do texto na \00E1rea destacada.</li>'),
unistr('<li><b>Condi\00E7\00E3o de Destaque</b> define sua condi\00E7\00E3o de filtro.</li></ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282167844650870935)
,p_name=>'APEXIR_HELP_PIVOT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Voc\00EA pode definir uma view Piv\00F4 por relat\00F3rio salvo. Depois de definido, \00E9 poss\00EDvel alternar entre as views de relat\00F3rio e piv\00F4 usando \00EDcones de views da barra de Pesquisa. Para criar uma view Piv\00F4, selecione:'),
'<p></p>',
'<ul>',
unistr('<li>as colunas para criar uma view din\00E2mica</li>'),
'<li>as colunas a serem exibidas como linhas</li>',
unistr('<li>as colunas a serem agregadas com a fun\00E7\00E3o a ser executada (m\00E9dia, soma, contagem etc.)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282612685771871221)
,p_name=>'APEXIR_HELP_REPORT_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Se voc\00EA personalizar um relat\00F3rio interativo, as configura\00E7\00F5es do relat\00F3rio ser\00E3o exibidas'),
unistr('abaixo da barra de Pesquisa e acima do relat\00F3rio. Essa \00E1rea pode ser contra\00EDda e expandida usando o \00EDcone \00E0 esquerda.'),
'<p>',
unistr('Para cada defini\00E7\00E3o de relat\00F3rio, \00E9 poss\00EDvel:'),
'</p><ul>',
unistr('<li>Editar uma defini\00E7\00E3o clicando no nome.</li>'),
unistr('<li>Desativar/Ativar uma defini\00E7\00E3o, desmarcando ou marcando a caixa de sele\00E7\00E3o Ativar/Desativar. Isso \00E9 usado para ativar/desativar temporariamente uma defini\00E7\00E3o.</li>'),
unistr('<li>Remover uma defini\00E7\00E3o clicando no \00EDcone Remover.</li>'),
'</ul>',
unistr('<p>Se voc\00EA criou um gr\00E1fico ou agrupamento, poder\00E1 alternar entre eles'),
unistr(' e o relat\00F3rio de base usando os links View de Relat\00F3rio, View de Gr\00E1fico, Piv\00F4 e'),
unistr(' Agrupar por mostrados \00E0 direita. Se estiver exibindo um gr\00E1fico ou'),
unistr(' agrupamento, tamb\00E9m poder\00E1 usar o link Editar para editar as defini\00E7\00F5es.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282571746796871195)
,p_name=>'APEXIR_HELP_RESET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Redefine o relat\00F3rio \00E0s configura\00E7\00F5es padr\00E3o, removendo qualquer personaliza\00E7\00E3o realizada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283071464745871518)
,p_name=>'APEXIR_HELP_ROWS_PER_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Define o n\00FAmero de registros para exibi\00E7\00E3o por p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282571640660871195)
,p_name=>'APEXIR_HELP_SAVE_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Salva o relat\00F3rio personalizado para uso futuro. Voc\00EA fornece um nome e uma descri\00E7\00E3o opcional e pode tornar o relat\00F3rio acess\00EDvel ao p\00FAblico (isto \00E9, todos os usu\00E1rios que podem acessar o relat\00F3rio padr\00E3o). Voc\00EA pode salvar quatro tipos de relat\00F3')
||'rios interativos:</p>',
'<ul>',
unistr('<li><strong>Padr\00E3o Principal</strong> (Somente Desenvolvedor). O Padr\00E3o Principal \00E9 o relat\00F3rio que \00E9 exibido inicialmente. Os relat\00F3rios Padr\00E3o Principal n\00E3o podem ser renomeados ou exclu\00EDdos.</li>'),
unistr('<li><strong>Relat\00F3rio Alternativo</strong> (Somente Desenvolvedor). Permite que os desenvolvedores criem v\00E1rios layouts de relat\00F3rio. Somente os desenvolvedores podem salvar, renomear ou excluir um Relat\00F3rio Alternativo.</li>'),
unistr('<li><strong>Relat\00F3rio P\00FAblico</strong> (Usu\00E1rio final). Pode ser salvo, renomeado ou exclu\00EDdo pelo usu\00E1rio final que o criou. Outros usu\00E1rios podem exibir e salvar o relat\00F3rio como outro relat\00F3rio.</li>'),
unistr('<li><strong>Relat\00F3rio Privado</strong> (Usu\00E1rio final). Somente o usu\00E1rio final que criou o relat\00F3rio pode exibir, salvar, renomear ou excluir o relat\00F3rio.</li>'),
'</ul>',
unistr('<p>Se voc\00EA salvar os relat\00F3rios personalizados, um selector de Relat\00F3rios \00E9 exibido na barra de Pesquisa \00E0 esquerda do selector de Linhas (se este recurso for ativado).</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282570633753871194)
,p_name=>'APEXIR_HELP_SEARCH_BAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Na parte superior de cada p\00E1gina do relat\00F3rio, h\00E1 uma regi\00E3o de pesquisa. A regi\00E3o (ou barra de Pesquisa) apresenta os seguintes recursos:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283072098157871518)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ACTIONS_MENU'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<li><b>Menu A\00E7\00F5es</b> permite que voc\00EA personalize um relat\00F3rio. Consulte as se\00E7\00F5es as seguir.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283071526433871518)
,p_name=>'APEXIR_HELP_SEARCH_BAR_FINDER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<li><b>\00CDcone Selecionar colunas</b> permite que voc\00EA identifique qual coluna pesquisar (ou todas).</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283071823842871518)
,p_name=>'APEXIR_HELP_SEARCH_BAR_REPORTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<li><b>Relat\00F3rios</b> exibe relat\00F3rios privados ou p\00FAblicos padr\00E3o e salvos alternativos.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283071726949871518)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ROWS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<li><b>Linhas</b> define o n\00FAmero de registros para exibi\00E7\00E3o por p\00E1gina.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283071671141871518)
,p_name=>'APEXIR_HELP_SEARCH_BAR_TEXTBOX'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li><b>\00C1rea de texto</b> permite que voc\00EA digite os crit\00E9rios de pesquisa que n\00E3o distinguem mai\00FAsculas e min\00FAsculas (caracteres curinga s\00E3o utilizados).</li>'),
unistr('<li><b>Bot\00E3o Ir</b> executa a pesquisa. Pressione a tecla Enter para executar tamb\00E9m a pesquisa quando o cursor estiver na \00E1rea de texto da pesquisa.</li>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283071961830871518)
,p_name=>'APEXIR_HELP_SEARCH_BAR_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<li><b>\00CDcones de Exibi\00E7\00E3o</b> alternam entre as exibi\00E7\00F5es de \00EDcone, relat\00F3rio, detalhes, gr\00E1ficos, agrupar por e piv\00F4 do relat\00F3rio, caso tenham sido definidos.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283414365203871750)
,p_name=>'APEXIR_HELP_SEARCH_BAR_WS_MANAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<li><b>Gerenciar</b> permite que voc\00EA gerencie as propriedades, colunas, linhas e exiba o hist\00F3rico do relat\00F3rio ou da grade de dados.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282570890113871194)
,p_name=>'APEXIR_HELP_SELECT_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usado para modificar as colunas exibidas. As colunas \00E0 direita s\00E3o exibidas. As colunas \00E0 esquerda s\00E3o ocultas. Voc\00EA poder\00E1 reordenar as colunas exibidas usando as setas na extremidade direita. As colunas calculadas recebem o prefixo <b>**</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282571097539871194)
,p_name=>'APEXIR_HELP_SORT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usado para alterar a(s) coluna(s) a classificar e determina se',
unistr(' a classifica\00E7\00E3o ser\00E1 em ordem crescente ou decrescente. Tamb\00E9m \00E9 poss\00EDvel especificar como tratar'),
unistr(' os <code>NULOs</code>. A configura\00E7\00E3o padr\00E3o sempre exibe os <code>NULOs</code> por \00FAltimo ou primeiro. A classifica\00E7\00E3o resultante \00E9 exibida \00E0 direita'),
unistr(' dos cabe\00E7alhos das colunas no relat\00F3rio.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283061490383871511)
,p_name=>'APEXIR_HELP_SUBSCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ao adicionar uma assinatura, voc\00EA fornece um endere\00E7o de e-mail (ou diversos endere\00E7os de e-mail, separados por v\00EDrgula), o assunto do e-mail, a frequ\00EAncia e as datas inicial e final. Os e-mails resultantes incluem uma vers\00E3o HTML do relat\00F3rio intera')
||unistr('tivo que cont\00E9m os dados atuais que usam a defini\00E7\00E3o de relat\00F3rio que estava presente quando a assinatura foi adicionada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283413809097871749)
,p_name=>'APEXIR_HELP_WS_01'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Grades de dados basicamente s\00E3o relat\00F3rios edit\00E1veis que s\00E3o altamente personaliz\00E1veis. Os usu\00E1rios podem alterar o layout dos dados do relat\00F3rio, selecionando colunas, aplicando filtros, destacando e classificando. Os usu\00E1rios tamb\00E9m podem definir q')
||unistr('uebras, agrega\00E7\00F5es, gr\00E1ficos, agrupar por e adicionar seus pr\00F3prios c\00E1lculos. Podem criar diversas varia\00E7\00F5es de um relat\00F3rio e salv\00E1-las como relat\00F3rios nomeados para exibi\00E7\00E3o privadas.'),
'<p/>',
unistr('Uma grade de Dados pode ser personalizada usando-se a barra de Pesquisa, o menu A\00E7\00F5es, o menu Gerenciar ou o Cabe\00E7alho da Coluna.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283466251780871785)
,p_name=>'APEXIR_HELP_WS_ACTIONS_MENU'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O menu A\00E7\00F5es aparece \00E0 direita do bot\00E3o Ir na barra de Pesquisa. Use este menu para personalizar um relat\00F3rio de grade de dados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283414625591871750)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar/Editar P\00E1gina da Linha')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283414711955871750)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT_ROW'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para adicionar uma linha \00E0 grade de dados, clique em Adicionar Linha. Para editar os detalhes de uma linha, clique no \00EDcone da linha de edi\00E7\00E3o (primeira coluna) da linha que voc\00EA deseja editar. A p\00E1gina Adicionar/Editar Linha ser\00E1 exibida mostrand')
||'o as colunas da grade de dados. </p>',
'',
unistr('<p>Ao editar uma linha voc\00EA pode:</p>'),
'',
'<p><ul>',
'<li><b>Excluir</b> a linha.</li>',
unistr('<li><b>Aplicar Altera\00E7\00F5es</b> para salvar as altera\00E7\00F5es feitas na linha.</li>'),
unistr('<li>Em <b>A\00E7\00F5es</b>, adicione uma linha, adicionar arquivos, observa\00E7\00F5es, links ou tags e revise o hist\00F3rico.</li>'),
unistr('<li>Navegue at\00E9 as linhas <b>Pr\00F3xima e Anterior</b>.</li>'),
unistr('<li>Em <b>Gerenciar</b>, defina as propriedades da coluna, valida\00E7\00F5es e lista de valores.</li>'),
'</ul></p>',
'',
unistr('<p>A regi\00E3o Anota\00E7\00F5es nap arte inferior da p\00E1gina exibir\00E1 os arquivos, observa\00E7\00F5es, links ou tags que n\00E3o est\00E3o associados \00E0 linha atual.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283466378194871785)
,p_name=>'APEXIR_HELP_WS_CONTROL_BREAK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usado para criar um grupo de interrup\00E7\00E3o em uma ou mais colunas. Isso retira as colunas da grade de dados e as exibe como um registro mestre.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283414511263871750)
,p_name=>'APEXIR_HELP_WS_DOWNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Permite que o conjunto de resultados atual seja obtido por download. Os formatos',
'de download incluem CSV, HTML ou E-mail.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283466419049871785)
,p_name=>'APEXIR_HELP_WS_REPORT_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Se voc\00EA personalizar um relat\00F3rio de grade de dados, as defini\00E7\00F5es do relat\00F3rio ser\00E3o exibidas'),
unistr('abaixo da barra de Pesquisa e acima do relat\00F3rio. Essa \00E1rea pode ser contra\00EDda e expandida usando-se o \00EDcone \00E0 esquerda.'),
'<p>',
unistr('Para cada defini\00E7\00E3o de relat\00F3rio, voc\00EA pode:'),
'</p><ul>',
unistr('<li>Editar uma defini\00E7\00E3o clicando no nome.</li>'),
unistr('<li>Desativar/Ativar uma defini\00E7\00E3o desmarcando ou marcando a caixa de sele\00E7\00E3o Ativar/Desativar. Use esse controle para ativar/desativar temporariamente uma defini\00E7\00E3o.</li>'),
unistr('<li>Remover uma defini\00E7\00E3o clicando no \00EDcone Remover.</li>'),
'</ul>',
unistr('<p>Se voc\00EA criou um gr\00E1fico ou agrupamento, poder\00E1 alternar entre eles'),
unistr('e o relat\00F3rio de base usando os links View de Relat\00F3rio, View de Gr\00E1fico e Agrupar por'),
unistr('mostrados \00E0 direita. Se estiver exibindo um gr\00E1fico ou agrupamento,'),
unistr('tamb\00E9m poder\00E1 usar o link Editar para editar as defini\00E7\00F5es.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283414435857871750)
,p_name=>'APEXIR_HELP_WS_SAVE_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Salva o relat\00F3rio da grade de dados personalizado para uso futuro. Voc\00EA fornece um nome e uma descri\00E7\00E3o opcional.  Voc\00EA pode salvar tr\00EAs tipos de layouts de relat\00F3rio da grade de dados:</p>'),
'<ul>',
unistr('<li><strong>Padr\00E3o Principal</strong> (Somente Administrador). O Padr\00E3o Principal \00E9 o layout que \00E9 exibido inicialmente. Os relat\00F3rios Padr\00E3o Principal n\00E3o podem ser renomeados ou exclu\00EDdos.</li>'),
unistr('<li><strong>Relat\00F3rio Alternativo</strong> (Somente Administrador). Permite que os administradores criem v\00E1rios layouts de relat\00F3rio. Somente os administradores podem salvar, renomear ou excluir um Relat\00F3rio Alternativo.</li>'),
unistr('<li><strong>Relat\00F3rio P\00FAblico</strong> (Todos os usu\00E1rios). O usu\00E1rio que criou o layout do relat\00F3rio pode exibir, salvar, renomear ou excluir o relat\00F3rio.</li>'),
'</ul>',
unistr('<p>Se voc\00EA salvar os relat\00F3rios personalizados, um seletor de Relat\00F3rios \00E9 exibido na barra de Pesquisa \00E0 esquerda do seletor de Linhas (se este recurso estiver ativado).</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282582955113871202)
,p_name=>'APEXIR_HIDE_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Ocultar Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282495205924871145)
,p_name=>'APEXIR_HIGHLIGHT'
,p_message_language=>'pt-br'
,p_message_text=>'Destacar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282587107719871205)
,p_name=>'APEXIR_HIGHLIGHTS'
,p_message_language=>'pt-br'
,p_message_text=>'Destaques'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282612756010871221)
,p_name=>'APEXIR_HIGHLIGHT_CONDITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Condi\00E7\00E3o do Destaque')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283062311435871512)
,p_name=>'APEXIR_HIGHLIGHT_STYLE'
,p_message_language=>'pt-br'
,p_message_text=>'Estilo do Destaque'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282336095617871043)
,p_name=>'APEXIR_HIGHLIGHT_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Destaque'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282336709922871043)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_language=>'pt-br'
,p_message_text=>'Destacar Quando'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283422922197871755)
,p_name=>'APEXIR_HORIZONTAL'
,p_message_language=>'pt-br'
,p_message_text=>'Horizontal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283526495250871826)
,p_name=>'APEXIR_INACTIVE_SETTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('1 defini\00E7\00E3o inativa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283526566766871826)
,p_name=>'APEXIR_INACTIVE_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 defini\00E7\00F5es inativas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282572305548871195)
,p_name=>'APEXIR_INTERACTIVE_REPORT_HELP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ajuda de Relat\00F3rio Interativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282614010993871222)
,p_name=>'APEXIR_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Inv\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282585611663871204)
,p_name=>'APEXIR_INVALID_COMPUTATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Express\00E3o de c\00E1lculo inv\00E1lida. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282283194564871009)
,p_name=>'APEXIR_INVALID_END_DATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A data de t\00E9rmino deve ser posterior \00E0 data de in\00EDcio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282732461056871297)
,p_name=>'APEXIR_INVALID_FILTER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Express\00E3o de filtro inv\00E1lida. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283459013206871780)
,p_name=>'APEXIR_INVALID_FILTER_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Consulta de filtro inv\00E1lida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283526629241871826)
,p_name=>'APEXIR_INVALID_SETTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('1 defini\00E7\00E3o inv\00E1lida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283526765593871827)
,p_name=>'APEXIR_INVALID_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 defini\00E7\00F5es inv\00E1lidas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283062729142871512)
,p_name=>'APEXIR_IN_MINUTES'
,p_message_language=>'pt-br'
,p_message_text=>'(em minutos)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283405886112871744)
,p_name=>'APEXIR_IS_IN_THE_LAST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 est\00E1 no/a(s) \00FAltimo/a(s) %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283406163189871744)
,p_name=>'APEXIR_IS_IN_THE_NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 est\00E1 no/a(s) pr\00F3ximo/a(s) %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283406030394871744)
,p_name=>'APEXIR_IS_NOT_IN_THE_LAST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 no/a(s) \00FAltimo/a(s) %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283406270817871744)
,p_name=>'APEXIR_IS_NOT_IN_THE_NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o est\00E1 no pr\00F3ximo %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282611878671871220)
,p_name=>'APEXIR_KEYPAD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Teclado num\00E9rico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282367031312871063)
,p_name=>'APEXIR_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Label %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282580537993871201)
,p_name=>'APEXIR_LABEL_AXIS_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo do Eixo para Label')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282927848918871425)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_language=>'pt-br'
,p_message_text=>'Prefixo do Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282499442747871148)
,p_name=>'APEXIR_LAST_DAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimo Dia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282499627417871148)
,p_name=>'APEXIR_LAST_HOUR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltima Hora')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282499130769871147)
,p_name=>'APEXIR_LAST_MONTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00EAs Passado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282499213462871147)
,p_name=>'APEXIR_LAST_WEEK'
,p_message_language=>'pt-br'
,p_message_text=>'Semana Passada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282499323493871148)
,p_name=>'APEXIR_LAST_X_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimos %0 Dias')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282499536073871148)
,p_name=>'APEXIR_LAST_X_HOURS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimas %0 Horas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282498972622871147)
,p_name=>'APEXIR_LAST_X_YEARS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltimos %0 Anos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282499007640871147)
,p_name=>'APEXIR_LAST_YEAR'
,p_message_language=>'pt-br'
,p_message_text=>'Ano Passado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282366870713871062)
,p_name=>'APEXIR_LINE'
,p_message_language=>'pt-br'
,p_message_text=>'Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282339192895871045)
,p_name=>'APEXIR_LINE_WITH_AREA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Linha com \00C1rea')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283046060413871501)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>'Clique em <a href=''%0''>aqui</a> para gerenciar sua assinatura.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283458952329871780)
,p_name=>'APEXIR_MAP_IT'
,p_message_language=>'pt-br'
,p_message_text=>'Mapear'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282583598499871203)
,p_name=>'APEXIR_MAX_QUERY_COST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A consulta \00E9 prevista para exceder os recursos m\00E1ximos permitidos. Modifique as configura\00E7\00F5es do relat\00F3rio e tente novamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282451759902871117)
,p_name=>'APEXIR_MAX_ROW_CNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A contagem m\00E1xima de linhas deste relat\00F3rio \00E9 %0 linhas. Aplique um filtro para reduzir o n\00FAmero de registros em sua consulta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283459528379871780)
,p_name=>'APEXIR_MAX_X'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1ximo %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283459749098871780)
,p_name=>'APEXIR_MEDIAN_X'
,p_message_language=>'pt-br'
,p_message_text=>'Mediano %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282465453553871125)
,p_name=>'APEXIR_MIN_AGO'
,p_message_language=>'pt-br'
,p_message_text=>'%0 minutos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283459637216871780)
,p_name=>'APEXIR_MIN_X'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00EDnimo %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283458559252871780)
,p_name=>'APEXIR_MONTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00EAs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283063119802871512)
,p_name=>'APEXIR_MONTHLY'
,p_message_language=>'pt-br'
,p_message_text=>'Mensalmente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282614254080871222)
,p_name=>'APEXIR_MORE_DATA'
,p_message_language=>'pt-br'
,p_message_text=>'Mais Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282579408193871200)
,p_name=>'APEXIR_MOVE'
,p_message_language=>'pt-br'
,p_message_text=>'Mover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282579374785871200)
,p_name=>'APEXIR_MOVE_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Mover Tudo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283544823831871839)
,p_name=>'APEXIR_MULTIIR_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O ID Est\00E1tico da Regi\00E3o deve ser especificado porque a p\00E1gina cont\00E9m diversos relat\00F3rios interativos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282337898984871044)
,p_name=>'APEXIR_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282568748183871193)
,p_name=>'APEXIR_NEW_AGGREGATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nova Agrega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282361052208871059)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_language=>'pt-br'
,p_message_text=>'- Nova Categoria -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283528168856871827)
,p_name=>'APEXIR_NEW_CATEGORY_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Nova Categoria'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282568879730871193)
,p_name=>'APEXIR_NEW_COMPUTATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Novo C\00E1lculo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282493577565871144)
,p_name=>'APEXIR_NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282500066751871148)
,p_name=>'APEXIR_NEXT_DAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo Dia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282499806872871148)
,p_name=>'APEXIR_NEXT_HOUR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3xima Hora')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282500314258871148)
,p_name=>'APEXIR_NEXT_MONTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo M\00EAs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282500263309871148)
,p_name=>'APEXIR_NEXT_WEEK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3xima Semana')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282500132216871148)
,p_name=>'APEXIR_NEXT_X_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximos %0 Dias')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282499971650871148)
,p_name=>'APEXIR_NEXT_X_HOURS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximas %0 Horas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282500558217871148)
,p_name=>'APEXIR_NEXT_X_YEARS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximos %0 Anos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282500434789871148)
,p_name=>'APEXIR_NEXT_YEAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo Ano')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282338145790871044)
,p_name=>'APEXIR_NO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282614451562871222)
,p_name=>'APEXIR_NONE'
,p_message_language=>'pt-br'
,p_message_text=>'- Nenhum -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283062191999871512)
,p_name=>'APEXIR_NOT_VALID_EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 um endere\00E7o de e-mail v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282496342745871146)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nenhuma agrega\00E7\00E3o definida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282450584322871116)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o h\00E1 informa\00E7\00F5es de colunas dispon\00EDveis.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282496433103871146)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nenhum c\00E1lculo definido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283458336936871779)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_language=>'pt-br'
,p_message_text=>'- Sem Data Final -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282609529739871219)
,p_name=>'APEXIR_NULLS_ALWAYS_FIRST'
,p_message_language=>'pt-br'
,p_message_text=>'Nulos Sempre em Primeiro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282609457796871219)
,p_name=>'APEXIR_NULLS_ALWAYS_LAST'
,p_message_language=>'pt-br'
,p_message_text=>'Nulos Sempre no Final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282610446588871220)
,p_name=>'APEXIR_NULL_SORTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Classifica\00E7\00E3o Nula %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282585793964871204)
,p_name=>'APEXIR_NUMERIC_FLASHBACK_TIME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O tempo de flashback deve ser num\00E9rico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282585262521871204)
,p_name=>'APEXIR_NUMERIC_SEQUENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A sequ\00EAncia deve ser num\00E9rica.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282611123135871220)
,p_name=>'APEXIR_OPERATOR'
,p_message_language=>'pt-br'
,p_message_text=>'Operador'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282336556553871043)
,p_name=>'APEXIR_ORANGE'
,p_message_language=>'pt-br'
,p_message_text=>'laranja'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283422863608871755)
,p_name=>'APEXIR_ORIENTATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Orienta\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282338695330871045)
,p_name=>'APEXIR_OTHER'
,p_message_language=>'pt-br'
,p_message_text=>'Outro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283460072313871781)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_COUNT_X'
,p_message_language=>'pt-br'
,p_message_text=>'Percentual da Contagem Total %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283459293759871780)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_SUM_X'
,p_message_language=>'pt-br'
,p_message_text=>'Percentual da Soma Total %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283457728061871779)
,p_name=>'APEXIR_PERCENT_TOTAL_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Percentual da Contagem Total'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283457621209871779)
,p_name=>'APEXIR_PERCENT_TOTAL_SUM'
,p_message_language=>'pt-br'
,p_message_text=>'Percentual da Soma Total'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282366733293871062)
,p_name=>'APEXIR_PIE'
,p_message_language=>'pt-br'
,p_message_text=>'Pizza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282901564421871408)
,p_name=>'APEXIR_PIVOT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Piv\00F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282929168609871426)
,p_name=>'APEXIR_PIVOT_AGG_NOT_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 necess\00E1rio especificar a coluna Agregados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282929491536871426)
,p_name=>'APEXIR_PIVOT_AGG_NOT_ON_ROW_COL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel agregar em uma coluna selecionada como coluna de linha.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282926940242871424)
,p_name=>'APEXIR_PIVOT_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Colunas Piv\00F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282926780276871424)
,p_name=>'APEXIR_PIVOT_COLUMN_N'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna Piv\00F4 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282928981098871426)
,p_name=>'APEXIR_PIVOT_COLUMN_NOT_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 necess\00E1rio especificar a coluna Piv\00F4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282167717053870935)
,p_name=>'APEXIR_PIVOT_MAX_ROW_CNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A contagem m\00E1xima de linhas de uma consulta de Piv\00F4 limita o n\00FAmero de linhas na consulta-base, n\00E3o o n\00FAmero de linhas exibidas. Sua consulta-base excede a contagem de linhas m\00E1xima de %0. Aplique um filtro para reduzir o n\00FAmero de registros em sua c')
||'onsulta-base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283540789098871836)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Selecione outra coluna de linha. A express\00E3o ou link HTML na coluna de linha cont\00E9m a coluna definida como piv\00F4 ou coluna agregada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282927938540871425)
,p_name=>'APEXIR_PIVOT_SORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Classifica\00E7\00E3o de Piv\00F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283062230919871512)
,p_name=>'APEXIR_PREVIEW'
,p_message_language=>'pt-br'
,p_message_text=>'Visualizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282493647917871144)
,p_name=>'APEXIR_PREVIOUS'
,p_message_language=>'pt-br'
,p_message_text=>'Anterior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283456665619871778)
,p_name=>'APEXIR_PRIMARY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prim\00E1ria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283065949410871514)
,p_name=>'APEXIR_PRIMARY_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio Prim\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282726467070871294)
,p_name=>'APEXIR_PRIVATE'
,p_message_language=>'pt-br'
,p_message_text=>'Particular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282368136348871063)
,p_name=>'APEXIR_PUBLIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00FAblico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282338475596871044)
,p_name=>'APEXIR_RED'
,p_message_language=>'pt-br'
,p_message_text=>'vermelho'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283544744080871839)
,p_name=>'APEXIR_REGION_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O ID Est\00E1tico %0 da Regi\00E3o n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282579550234871200)
,p_name=>'APEXIR_REMOVE'
,p_message_language=>'pt-br'
,p_message_text=>'Remover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282492611685871143)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_language=>'pt-br'
,p_message_text=>'Remover Agregados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282579693329871200)
,p_name=>'APEXIR_REMOVE_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Remover Tudo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283526842473871827)
,p_name=>'APEXIR_REMOVE_CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Remover Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282578919768871200)
,p_name=>'APEXIR_REMOVE_CONTROL_BREAK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Remover Interrup\00E7\00E3o de Controle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282578639913871199)
,p_name=>'APEXIR_REMOVE_FILTER'
,p_message_language=>'pt-br'
,p_message_text=>'Remover Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282578705976871199)
,p_name=>'APEXIR_REMOVE_FLASHBACK'
,p_message_language=>'pt-br'
,p_message_text=>'Remover Flashback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283526928410871827)
,p_name=>'APEXIR_REMOVE_GROUP_BY'
,p_message_language=>'pt-br'
,p_message_text=>'Remover Grupo Por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282579086375871200)
,p_name=>'APEXIR_REMOVE_HIGHLIGHT'
,p_message_language=>'pt-br'
,p_message_text=>'Remover Destaque'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283527050772871827)
,p_name=>'APEXIR_REMOVE_PIVOT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Remover Piv\00F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283468219431871786)
,p_name=>'APEXIR_REMOVE_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Remover Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283347140045871704)
,p_name=>'APEXIR_RENAME_DEFAULT_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Renomear Relat\00F3rio Padr\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282614801860871222)
,p_name=>'APEXIR_RENAME_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Renomear Relat\00F3rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282494160965871144)
,p_name=>'APEXIR_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283460148538871781)
,p_name=>'APEXIR_REPORTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282327643020871038)
,p_name=>'APEXIR_REPORT_ALIAS_DOES_NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O relat\00F3rio Interativo salvo com o alias %0 n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282877093311871392)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O n\00FAmero de colunas de exibi\00E7\00E3o atingiu o limite no relat\00F3rio. Clique em Selecionar Colunas no menu A\00E7\00F5es para minimizar a lista de colunas de exibi\00E7\00E3o do relat\00F3rio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282729727597871296)
,p_name=>'APEXIR_REPORT_DOES_NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O relat\00F3rio n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282327733021871038)
,p_name=>'APEXIR_REPORT_ID_DOES_NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O ID do Relat\00F3rio Interativo Salvo %0 n\00E3o existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282612524331871221)
,p_name=>'APEXIR_REPORT_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Configura\00E7\00F5es do Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282465965838871126)
,p_name=>'APEXIR_REPORT_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('View de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282495788924871145)
,p_name=>'APEXIR_RESET'
,p_message_language=>'pt-br'
,p_message_text=>'Redefinir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282368394504871063)
,p_name=>'APEXIR_RESET_CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Restaurar o relat\00F3rio para as configura\00E7\00F5es padr\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282338284601871044)
,p_name=>'APEXIR_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283452489923871775)
,p_name=>'APEXIR_ROWID_NOT_SUPPORTED_FOR_WEBSOURCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA n\00E3o pode usar ROWID como a coluna de chave prim\00E1ria para uma origem web.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282577675483871199)
,p_name=>'APEXIR_ROWS'
,p_message_language=>'pt-br'
,p_message_text=>'Linhas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283071398436871518)
,p_name=>'APEXIR_ROWS_PER_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Linhas Por P\00E1gina')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282927082948871424)
,p_name=>'APEXIR_ROW_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas de Linhas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282926840965871424)
,p_name=>'APEXIR_ROW_COLUMN_N'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna de Linha %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282929063889871426)
,p_name=>'APEXIR_ROW_COLUMN_NOT_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 necess\00E1rio especificar a coluna Linhas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282929219883871426)
,p_name=>'APEXIR_ROW_COL_DIFF_FROM_PIVOT_COL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A coluna de linhas deve ser diferente da coluna de piv\00F4s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282674310786871260)
,p_name=>'APEXIR_ROW_FILTER'
,p_message_language=>'pt-br'
,p_message_text=>'Filtro de Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282466090958871126)
,p_name=>'APEXIR_ROW_OF'
,p_message_language=>'pt-br'
,p_message_text=>'Linha %0 de %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282465222646871125)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_language=>'pt-br'
,p_message_text=>'Ordem da Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282497276699871146)
,p_name=>'APEXIR_ROW_TEXT_CONTAINS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Texto da linha cont\00E9m')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282187692148870948)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O n\00FAmero de colunas de exibi\00E7\00E3o atingiu o limite no relat\00F3rio. Clique em Selecionar Colunas no menu A\00E7\00F5es para minimizar a lista de colunas de exibi\00E7\00E3o do relat\00F3rio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282337480286871044)
,p_name=>'APEXIR_SAVE'
,p_message_language=>'pt-br'
,p_message_text=>'Salvar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282587371041871205)
,p_name=>'APEXIR_SAVED_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio Salvo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282587249928871205)
,p_name=>'APEXIR_SAVED_REPORT_MSG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio Salvo = "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282496178264871145)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Salvar como Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282608756738871218)
,p_name=>'APEXIR_SAVE_DEFAULT_CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('As configura\00E7\00F5es atuais do relat\00F3rio ser\00E3o usadas como padr\00E3o para todos os usu\00E1rios.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283347071245871704)
,p_name=>'APEXIR_SAVE_DEFAULT_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Salvar Relat\00F3rio Padr\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282495633529871145)
,p_name=>'APEXIR_SAVE_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Salvar Relat\00F3rio')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283528081806871827)
,p_name=>'APEXIR_SAVE_REPORT_DEFAULT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Salvar Relat\00F3rio*')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283082957504871525)
,p_name=>'APEXIR_SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282572267550871195)
,p_name=>'APEXIR_SEARCH_BAR'
,p_message_language=>'pt-br'
,p_message_text=>'Barra de Pesquisa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283527985379871827)
,p_name=>'APEXIR_SEARCH_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283132259901871557)
,p_name=>'APEXIR_SEARCH_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio de Pesquisa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283043883433871500)
,p_name=>'APEXIR_SELECTED_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas Selecionadas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282337736353871044)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_language=>'pt-br'
,p_message_text=>'- Selecionar Categoria -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282339371135871045)
,p_name=>'APEXIR_SELECT_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'- Selecionar Coluna -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282494954134871145)
,p_name=>'APEXIR_SELECT_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Selecionar Colunas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282614699516871222)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_language=>'pt-br'
,p_message_text=>'As colunas calculadas recebem o prefixo **.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282367500027871063)
,p_name=>'APEXIR_SELECT_FUNCTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('- Selecionar Fun\00E7\00E3o -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282577049870871198)
,p_name=>'APEXIR_SELECT_GROUP_BY_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'- Selecionar Grupo por Coluna -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282926535558871424)
,p_name=>'APEXIR_SELECT_PIVOT_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('- Selecionar Coluna por Piv\00F4 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283459170624871780)
,p_name=>'APEXIR_SELECT_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Selecionar Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282926670485871424)
,p_name=>'APEXIR_SELECT_ROW_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'- Selecionar Coluna de Linha -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283457974761871779)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('- Selecionar Coluna de Classifica\00E7\00E3o -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282614121069871222)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Selecionar Valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282177476428870941)
,p_name=>'APEXIR_SEND'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282337903171871044)
,p_name=>'APEXIR_SEQUENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sequ\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282495175938871145)
,p_name=>'APEXIR_SORT'
,p_message_language=>'pt-br'
,p_message_text=>'Classificar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282582791189871202)
,p_name=>'APEXIR_SORT_ASCENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Classificar por Ordem Crescente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283457844480871779)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Classificar Coluna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282582879887871202)
,p_name=>'APEXIR_SORT_DESCENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Classificar por Ordem Decrescente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283467416557871786)
,p_name=>'APEXIR_SORT_ORDER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ordem de Classifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282568325070871193)
,p_name=>'APEXIR_SPACE_AS_IN_ONE_EMPTY_STRING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('espa\00E7o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282611477226871220)
,p_name=>'APEXIR_STATUS'
,p_message_language=>'pt-br'
,p_message_text=>'Status %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283062882724871512)
,p_name=>'APEXIR_SUBSCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Inscri\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283458290974871779)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING'
,p_message_language=>'pt-br'
,p_message_text=>'Fim'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283043714574871500)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_language=>'pt-br'
,p_message_text=>'Encerrando Unidade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283458177230871779)
,p_name=>'APEXIR_SUBSCRIPTION_STARTING_FROM'
,p_message_language=>'pt-br'
,p_message_text=>'Iniciando de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283459347771871780)
,p_name=>'APEXIR_SUM_X'
,p_message_language=>'pt-br'
,p_message_text=>'Soma %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283408615898871746)
,p_name=>'APEXIR_TABLE_SUMMARY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regi\00E3o = %0, Relat\00F3rio = %1, View = %2, In\00EDcio das Linhas Exibidas = %3, Fim das Linhas Exibidas = %4, Total de Linhas = %5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282518762379871160)
,p_name=>'APEXIR_TABLE_SUMMARY_NO_TOTAL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regi\00E3o = %0, Relat\00F3rio = %1, View = %2, In\00EDcio das Linhas Exibidas = %3, Fim das Linhas Exibidas = %4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282336657107871043)
,p_name=>'APEXIR_TEXT_COLOR'
,p_message_language=>'pt-br'
,p_message_text=>'Cor do Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282452374350871117)
,p_name=>'APEXIR_TIME_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>'dias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282452214997871117)
,p_name=>'APEXIR_TIME_HOURS'
,p_message_language=>'pt-br'
,p_message_text=>'horas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282452146214871117)
,p_name=>'APEXIR_TIME_MINS'
,p_message_language=>'pt-br'
,p_message_text=>'minutos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282452570596871117)
,p_name=>'APEXIR_TIME_MONTHS'
,p_message_language=>'pt-br'
,p_message_text=>'meses'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282452429581871117)
,p_name=>'APEXIR_TIME_WEEKS'
,p_message_language=>'pt-br'
,p_message_text=>'semanas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282452626252871117)
,p_name=>'APEXIR_TIME_YEARS'
,p_message_language=>'pt-br'
,p_message_text=>'anos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283468084619871786)
,p_name=>'APEXIR_TOGGLE'
,p_message_language=>'pt-br'
,p_message_text=>'Alternar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282579735266871200)
,p_name=>'APEXIR_TOP'
,p_message_language=>'pt-br'
,p_message_text=>'Superior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282612916925871221)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o autorizado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283441810760871768)
,p_name=>'APEXIR_UNGROUPED_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna N\00E3o Agrupada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282585454269871204)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Cabe\00E7alho da Coluna deve ser exclusivo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282585177557871204)
,p_name=>'APEXIR_UNIQUE_HIGHLIGHT_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'O Nome do Destaque deve ser exclusivo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282365894149871062)
,p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('tipo de dados n\00E3o suportado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282579818817871200)
,p_name=>'APEXIR_UP'
,p_message_language=>'pt-br'
,p_message_text=>'Ativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282585333320871204)
,p_name=>'APEXIR_VALID_COLOR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informe uma cor v\00E1lida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282585556785871204)
,p_name=>'APEXIR_VALID_FORMAT_MASK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informe uma m\00E1scara de formato v\00E1lida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282338733250871045)
,p_name=>'APEXIR_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282580679675871201)
,p_name=>'APEXIR_VALUE_AXIS_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo do Eixo para Valor')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282613943158871222)
,p_name=>'APEXIR_VALUE_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor Necess\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282366690304871062)
,p_name=>'APEXIR_VCOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna Vertical'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283423056240871755)
,p_name=>'APEXIR_VERTICAL'
,p_message_language=>'pt-br'
,p_message_text=>'Vertical'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282613114284871221)
,p_name=>'APEXIR_VIEW_CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283112039015871544)
,p_name=>'APEXIR_VIEW_DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>'Detalhe da View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283531156848871830)
,p_name=>'APEXIR_VIEW_DOES_NOT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O relat\00F3rio n\00E3o tem a view %0 definida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283112149217871544)
,p_name=>'APEXIR_VIEW_GROUP_BY'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir Grupo Por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283111984064871544)
,p_name=>'APEXIR_VIEW_ICONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir \00CDcones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282926341286871424)
,p_name=>'APEXIR_VIEW_PIVOT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir Piv\00F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282613258223871221)
,p_name=>'APEXIR_VIEW_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283458719142871780)
,p_name=>'APEXIR_WEEK'
,p_message_language=>'pt-br'
,p_message_text=>'Semana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283063061034871512)
,p_name=>'APEXIR_WEEKLY'
,p_message_language=>'pt-br'
,p_message_text=>'Semanalmente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282494015950871144)
,p_name=>'APEXIR_WORKING_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio Funcional')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283460905809871781)
,p_name=>'APEXIR_X_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 dias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283460871030871781)
,p_name=>'APEXIR_X_HOURS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 horas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283460705494871781)
,p_name=>'APEXIR_X_MINS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 minutos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283461165806871781)
,p_name=>'APEXIR_X_MONTHS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 meses'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283461085694871781)
,p_name=>'APEXIR_X_WEEKS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 semanas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283461233660871781)
,p_name=>'APEXIR_X_YEARS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 anos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283458638527871780)
,p_name=>'APEXIR_YEAR'
,p_message_language=>'pt-br'
,p_message_text=>'Ano'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282336353370871043)
,p_name=>'APEXIR_YELLOW'
,p_message_language=>'pt-br'
,p_message_text=>'amarelo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282338018273871044)
,p_name=>'APEXIR_YES'
,p_message_language=>'pt-br'
,p_message_text=>'Sim'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282184730977870946)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Servi\00E7os Administrativos do Application Express')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283407269167871745)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o h\00E1 autentica\00E7\00E3o configurada para este aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282580443373871201)
,p_name=>'APEX_GROUP.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 cont\00E9m < ou > que s\00E3o caracteres inv\00E1lidos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282797674185871341)
,p_name=>'APEX_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282654337561871248)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os seguintes objetos de banco de dados ser\00E3o %0 no esquema selecionado:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282654488439871248)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Os seguintes objetos de banco de dados foram %0 com sucesso:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283142392897871564)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_language=>'pt-br'
,p_message_text=>'Rolar para baixo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283142441864871564)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_language=>'pt-br'
,p_message_text=>'Rolar para cima'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282190357747870950)
,p_name=>'APEX_WIZARD_FORM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Form de navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283406732639871744)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282825243897871359)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Objetos Inv\00E1lidos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283465151500871784)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o existem p\00E1ginas de mesmo n\00EDvel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283410056926871747)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_language=>'pt-br'
,p_message_text=>'Objetos a serem criados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283410224070871747)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir das Tabelas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283410459400871747)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_language=>'pt-br'
,p_message_text=>'Eliminar Objetos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283073140881871519)
,p_name=>'APEX_WS_SETUP_DROP_TABLES'
,p_message_language=>'pt-br'
,p_message_text=>'Eliminar Tabelas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283072444640871518)
,p_name=>'APEX_WS_SETUP_MSG1'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Estes objetos ser\00E3o criados no esquema <b>%0</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283410525974871747)
,p_name=>'APEX_WS_SETUP_MSG10'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Estes objetos j\00E1 existem no esquema <b>%0</b> e s\00E3o usados por outros espa\00E7os de trabalho. Se voc\00EA continuar, os objetos da Websheet de <b>%0</b> ser\00E3o associados tamb\00E9m a este espa\00E7o de trabalho.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283410690601871747)
,p_name=>'APEX_WS_SETUP_MSG11'
,p_message_language=>'pt-br'
,p_message_text=>'Selecione o esquema a ser usado para estes objetos:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283410760337871747)
,p_name=>'APEX_WS_SETUP_MSG12'
,p_message_language=>'pt-br'
,p_message_text=>'Tabelas existentes a serem usadas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283411662504871748)
,p_name=>'APEX_WS_SETUP_MSG13'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os objetos de banco de dados da websheet ser\00E3o criados com as informa\00E7\00F5es as informa\00E7\00F5es a seguir. Confirme sua solicita\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283072589633871518)
,p_name=>'APEX_WS_SETUP_MSG2'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Se voc\00EA preferir criar os objetos da Websheet em um novo esquema use o assistente <a href=%0>Esquema do Banco de Dados da Solicita\00E7\00E3o</a>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283072640096871518)
,p_name=>'APEX_WS_SETUP_MSG3'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Para executar Websheets, os seguintes objetos s\00E3o necess\00E1rios:')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283072770387871519)
,p_name=>'APEX_WS_SETUP_MSG5'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os objetos do banco de dados da websheet ser\00E3o criados usando as seguintes informa\00E7\00F5es. Confirme sua solicita\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283072847219871519)
,p_name=>'APEX_WS_SETUP_MSG6'
,p_message_language=>'pt-br'
,p_message_text=>'Tabelas para criar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283072939441871519)
,p_name=>'APEX_WS_SETUP_MSG7'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA est\00E1 prestes a remover os objetos do banco de dados da Websheet. Isso eliminar\00E1 os objetos do banco de dados da Websheet e tamb\00E9m os dados internos que cont\00EAm componentes da Websheet em seu espa\00E7o de trabalho. Deseja continuar?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283073200646871519)
,p_name=>'APEX_WS_SETUP_MSG8'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os seguintes objetos inv\00E1lidos precisam ser corrigidos para que as Websheet sejam executadas adequadamente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283410109882871747)
,p_name=>'APEX_WS_SETUP_MSG9'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA est\00E1 prestes a remover as defini\00E7\00F5es da Websheet deste espa\00E7o de trabalho. Os objetos do banco de dados da Websheet tamb\00E9m s\00E3o usados por outros espa\00E7os de trabalho, de forma que n\00E3o ser\00E3o eliminados. Os registros associados a este espa\00E7o de tra')
||unistr('balho ser\00E3o exclu\00EDdos. Deseja continuar?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283073336776871519)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283073434382871519)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283073009951871519)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_language=>'pt-br'
,p_message_text=>'Esquema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283409919230871747)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_language=>'pt-br'
,p_message_text=>'Objetos existentes a serem usados'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282201605984870957)
,p_name=>'API_PRECONDITION_VIOLATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00E9-condi\00E7\00E3o da API violada')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282359915526871058)
,p_name=>'APP.SETTING.CANNOT.GET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel obter o valor para a Defini\00E7\00E3o de Aplicativo %0, pois a op\00E7\00E3o de build est\00E1 desativada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282359860818871058)
,p_name=>'APP.SETTING.CANNOT.SET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel definir o valor para a Defini\00E7\00E3o de Aplicativo %0, pois a op\00E7\00E3o de build est\00E1 desativada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283436669514871765)
,p_name=>'APP.SETTING.INVALID.VALUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O valor %0 da Defini\00E7\00E3o de Aplicativo \00E9 inv\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283436514015871764)
,p_name=>'APP.SETTING.NOT.DEFINED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Defini\00E7\00E3o %0 de Aplicativo Solicitada n\00E3o foi configurada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283436795110871765)
,p_name=>'APP.SETTING.VALUE.NOT.NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Defini\00E7\00E3o de Aplicativo %0 n\00E3o pode ser definido como um valor nulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282253043686870990)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00E1lculos do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282252953098870990)
,p_name=>'APPLICACTION_PROCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Processos do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282818263535871355)
,p_name=>'APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282898479654871406)
,p_name=>'APPLICATION BUILDER'
,p_message_language=>'pt-br'
,p_message_text=>'App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282722914068871291)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Condi\00E7\00E3o de C\00E1lculo do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282725692117871293)
,p_name=>'APPLICATION IMAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Imagem do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282723017921871291)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Condi\00E7\00E3o de Processo do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282649757741871245)
,p_name=>'APPLICATIONS'
,p_message_language=>'pt-br'
,p_message_text=>'aplicativos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282795488332871340)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282695754818871274)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_language=>'pt-br'
,p_message_text=>'Atividade de Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282736274618871300)
,p_name=>'APPLICATION_ALIAS'
,p_message_language=>'pt-br'
,p_message_text=>'Alias do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282734215672871299)
,p_name=>'APPLICATION_DELETED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Aplicativo Exclu\00EDdo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282184468180870946)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_language=>'pt-br'
,p_message_text=>'Desenvolvimento de Aplicativos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282735272201871299)
,p_name=>'APPLICATION_HELP'
,p_message_language=>'pt-br'
,p_message_text=>'Identifica o Aplicativo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282692380056871272)
,p_name=>'APPLICATION_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282581676568871201)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O ID do Aplicativo est\00E1 reservado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282581524933871201)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O ID do Aplicativo deve ser um n\00FAmero inteiro positivo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283113796434871545)
,p_name=>'APPLICATION_IMAGES'
,p_message_language=>'pt-br'
,p_message_text=>'Imagens do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282765565929871321)
,p_name=>'APPLICATION_ITEM'
,p_message_language=>'pt-br'
,p_message_text=>'Item de Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282282093671871008)
,p_name=>'APPLICATION_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>'Itens do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282247439203870986)
,p_name=>'APPLICATION_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282736172475871300)
,p_name=>'APPLICATION_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283464746613871784)
,p_name=>'APPLICATION_NAMES'
,p_message_language=>'pt-br'
,p_message_text=>'Nomes de Aplicativos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282858574609871380)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ID de Substitui\00E7\00E3o do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282733777372871298)
,p_name=>'APPLICATION_OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283464626574871784)
,p_name=>'APPLICATION_PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1ginas do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282370156445871065)
,p_name=>'APPLICATION_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282733978576871298)
,p_name=>'APPLICATION_STATUS'
,p_message_language=>'pt-br'
,p_message_text=>'Status do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282820250486871356)
,p_name=>'APPLICATION_VERSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Vers\00E3o do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282200085320870956)
,p_name=>'APPLICATION_X'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282679500792871264)
,p_name=>'APPROVED'
,p_message_language=>'pt-br'
,p_message_text=>'Aprovado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282740408859871302)
,p_name=>'APP_SUCCESS_MSG'
,p_message_language=>'pt-br'
,p_message_text=>'O aplicativo foi criado com sucesso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283467344816871786)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo-Modelo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282234424181870978)
,p_name=>'APP_TYPE_DATABASE'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo de Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282234598230870978)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo de Produtividade ou Amostra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282761956155871318)
,p_name=>'APP_TYPE_PACKAGED_WS'
,p_message_language=>'pt-br'
,p_message_text=>'Websheet de Amostra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282234372564870978)
,p_name=>'APP_TYPE_WEBSHEET'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo de Websheet'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282679007214871263)
,p_name=>'ARCHIVED'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282247784778870986)
,p_name=>'ARCHIVELOG'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivamento de Log: Ativado'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282498689492871147)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_language=>'pt-br'
,p_message_text=>'Argumentos Devem Ter Checksum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282594475670871209)
,p_name=>'ARGUMENT_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Argumento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282594683159871210)
,p_name=>'ARGUMENT_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Argumento'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282672988382871259)
,p_name=>'ASAP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O mais r\00E1pido poss\00EDvel')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282669549205871257)
,p_name=>'ASSIGNED'
,p_message_language=>'pt-br'
,p_message_text=>'Designado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282367757650871063)
,p_name=>'ASSIGNEE'
,p_message_language=>'pt-br'
,p_message_text=>'Favorecido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283492260699871803)
,p_name=>'ASSIGN_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Atribuir  %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282428395147871102)
,p_name=>'ASSOCIATED'
,p_message_language=>'pt-br'
,p_message_text=>'associado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282369638463871064)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_language=>'pt-br'
,p_message_text=>'Recursos Associados'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282700988559871277)
,p_name=>'ATTACHMENT'
,p_message_language=>'pt-br'
,p_message_text=>'Anexo'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283508627567871814)
,p_name=>'AT_RISK_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Em Risco'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282398202514871083)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA est\00E1 prestes a migrar estas op\00E7\00F5es de autentica\00E7\00E3o personalizada deste aplicativo para um esquema de autentica\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282397786711871082)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9todo de Autentica\00E7\00E3o Atual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282398104815871083)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00E3o de Autentica\00E7\00E3o Personalizada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282397874461871082)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina de Log-in')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282398064430871083)
,p_name=>'AUTH.LOGIN_URL'
,p_message_language=>'pt-br'
,p_message_text=>'URL de Log-in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282397920056871082)
,p_name=>'AUTH.NONE'
,p_message_language=>'pt-br'
,p_message_text=>'nenhum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282403365360871086)
,p_name=>'AUTHENTICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282723996539871292)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00E3o de Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282723688192871292)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esquema de Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282418450746871096)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA est\00E1 prestes a excluir um esquema de autentica\00E7\00E3o do aplicativo %0. Se o aplicativo n\00E3o estiver atualmente usando a autentica\00E7\00E3o SCHEME ou se este n\00E3o for o esquema de autentica\00E7\00E3o atual, a exclus\00E3o do esquema n\00E3o afetar\00E1 a opera\00E7\00E3o do aplicativ')
||unistr('o. Se o aplicativo estiver usando a autentica\00E7\00E3o SCHEME e se este for o esquema de autentica\00E7\00E3o atual, o aplicativo continuar\00E1 a ser executada com o uso da autentica\00E7\00E3o SCHEME, mas com um esquema de autentica\00E7\00E3o padr\00E3o. Ela usar\00E1 uma p\00E1gina de log-in')
||unistr(' incorporada com verifica\00E7\00E3o de credenciais de "acesso livre" (ou seja, qualquer pessoa ter\00E1 autoriza\00E7\00E3o para executar o aplicativo). ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282420340493871097)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Clique no bot\00E3o Tornar Atual para que o seu aplicativo use este esquema de autentica\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282928245930871425)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_language=>'pt-br'
,p_message_text=>'Contas do Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282181072997870944)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'pt-br'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282928354029871425)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_language=>'pt-br'
,p_message_text=>'Personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282928622660871425)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sem Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282928414310871425)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_language=>'pt-br'
,p_message_text=>'Contas de Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283361663322871714)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Vari\00E1vel de Cabe\00E7alho HTTP')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282928870324871426)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_language=>'pt-br'
,p_message_text=>'SSO do Oracle Application Server'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282928512519871425)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Diret\00F3rio LDAP')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282928763144871425)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_language=>'pt-br'
,p_message_text=>'Credenciais de Acesso Livre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282171241768870938)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Acesso \00E0 SAML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282209745562870962)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_language=>'pt-br'
,p_message_text=>'Acesso Social'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282766604481871321)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esquema de Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282723519394871292)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esquema de Autoriza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282181144737870944)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'pt-br'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282200247729870956)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>'Consulta SQL Existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282200382329870956)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00E3o PL/SQL que Retorna Booleano')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282577401987871199)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Est\00E1 na Atribui\00E7\00E3o ou Grupo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282577582556871199)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o Est\00E1 na Atribui\00E7\00E3o ou Grupo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282200480289870956)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor de Item da Express\00E3o 1 \00C9 Igual \00E0 Express\00E3o 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282200512061870956)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Item da Express\00E3o1 \00E9 N\00C3O NULO')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282200600429870956)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Item da Express\00E3o 1 \00E9 NULO')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282200772512870956)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor de Item da Express\00E3o 1 N\00C3O \00C9 Igual \00E0 Express\00E3o 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282200843533870956)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Consulta SQL N\00C3O Existe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282200956891870956)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor de Prefer\00EAncia da Express\00E3o 1 \00C9 Igual \00E0 Express\00E3o 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282201016494870956)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor de Prefer\00EAncia da Express\00E3o 1 N\00C3O \00C9 Igual \00E0 Express\00E3o 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282266018500870998)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Avaliar a cada view de p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282266170813870998)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Avaliar uma vez por sess\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282203411388870958)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_language=>'pt-br'
,p_message_text=>'Conta Expirada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282203373765870958)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_language=>'pt-br'
,p_message_text=>'Conta Bloqueada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282203796686870958)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero M\00E1ximo de Tentativas de Log-in Excedido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282203896930870958)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro Interno Desconhecido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282203655776870958)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_language=>'pt-br'
,p_message_text=>'Primeiro Uso da Senha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282203596798870958)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_language=>'pt-br'
,p_message_text=>'Senha Incorreta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282203124051870958)
,p_name=>'AUTH_SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Normal, autentica\00E7\00E3o bem-sucedida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282203232235870958)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome de Usu\00E1rio Desconhecido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282318044657871031)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome de Espa\00E7o de Trabalho Desconhecido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282328579711871038)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome de Espa\00E7o de Trabalho Desconhecido: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282472389210871130)
,p_name=>'AUTOCOMMIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Instru\00E7\00E3o de commit n\00E3o aplic\00E1vel. Todas as instru\00E7\00F5es t\00EAm commit autom\00E1tico.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282796002931871340)
,p_name=>'AUTOPROVISION_MODE'
,p_message_language=>'pt-br'
,p_message_text=>'Modo de Provisionamento'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282178794697870942)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_language=>'pt-br'
,p_message_text=>'Primeiro Item'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282821928870871357)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_language=>'pt-br'
,p_message_text=>'Disponibilidade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282208379550870961)
,p_name=>'AVAILABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dispon\00EDvel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283025673452871488)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dispon\00EDvel Apenas para Desenvolvedores')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283025507075871488)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dispon\00EDvel com a Barra de Ferramentas do Desenvolvedor')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282696588320871274)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tempo M\00E9dio de Renderiza\00E7\00E3o (Segundos)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282266812636870998)
,p_name=>'BACK'
,p_message_language=>'pt-br'
,p_message_text=>'Voltar'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282677400712871262)
,p_name=>'BAR_CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1fico de Barras')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283099116253871536)
,p_name=>'BASIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('B\00E1sico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282222189797870970)
,p_name=>'BASIC_DEVELOPER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Desenvolvedor B\00E1sico')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282656714327871249)
,p_name=>'BEFORE'
,p_message_language=>'pt-br'
,p_message_text=>'Antes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283470031314871788)
,p_name=>'BEFORE LIST ENTRY'
,p_message_language=>'pt-br'
,p_message_text=>'Antes da Entrada da Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283490901666871802)
,p_name=>'BEFORE_FIRST'
,p_message_language=>'pt-br'
,p_message_text=>'Antes do Primeiro'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282726853547871294)
,p_name=>'BIND_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Label do Bind'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282726100773871293)
,p_name=>'BIND_VARIABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Vari\00E1vel de Bind')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282726235850871293)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Label da Vari\00E1vel de Bind')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282742097400871303)
,p_name=>'BLACK_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Texto em Preto'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282185580676870947)
,p_name=>'BLANK'
,p_message_language=>'pt-br'
,p_message_text=>'Em Branco'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282700134803871277)
,p_name=>'BLOB_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282860221844871381)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Fazer Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282237295931870980)
,p_name=>'BLOB_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>'Formato Blob'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282860640034871382)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_language=>'pt-br'
,p_message_text=>'Anexo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282860375346871381)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>'DOWNLOAD'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282860416520871382)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_language=>'pt-br'
,p_message_text=>'IMAGE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282860575373871382)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_language=>'pt-br'
,p_message_text=>'Em Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282701129485871277)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_language=>'pt-br'
,p_message_text=>'Formato BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282700611638871277)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna da \00DAltima Atualiza\00E7\00E3o do BLOB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282700014484871277)
,p_name=>'BLOB_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Tabela BLOB'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282741944353871303)
,p_name=>'BLUE_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Texto em Azul'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282717164643871288)
,p_name=>'BRANCH CONDITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Condi\00E7\00E3o de Ramifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282270486619871001)
,p_name=>'BRANCHES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ramifica\00E7\00F5es')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282494566866871144)
,p_name=>'BREADCRUMB'
,p_message_language=>'pt-br'
,p_message_text=>'Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282657402008871249)
,p_name=>'BREADCRUMB LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Label de Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282657528156871250)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome Longo do Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282494609305871144)
,p_name=>'BREADCRUMBS'
,p_message_language=>'pt-br'
,p_message_text=>'Breadcrumbs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282750595516871311)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_language=>'pt-br'
,p_message_text=>'Entrada de Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282765784168871321)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Entrada Breadcrumb: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282581830328871201)
,p_name=>'BREADCRUMB_PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1ginas de Breadcrumb')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282665670330871255)
,p_name=>'BREADCRUMB_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regi\00E3o de Breadcrumb')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282330840230871040)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_language=>'pt-br'
,p_message_text=>'O breadcrumb foi criado com sucesso.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282660045337871251)
,p_name=>'BROWSE_ICON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Procurar \00CDcone')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282659879715871251)
,p_name=>'BROWSE_PACKAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Procurar Pacote'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282594130038871209)
,p_name=>'BROWSE_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Procurar Tabela'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282188826119870949)
,p_name=>'BUFFER CACHE'
,p_message_language=>'pt-br'
,p_message_text=>'Buffer Cache'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282673439079871260)
,p_name=>'BUG'
,p_message_language=>'pt-br'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282697602566871275)
,p_name=>'BUGS'
,p_message_language=>'pt-br'
,p_message_text=>'Bugs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282720141120871290)
,p_name=>'BUGS_ASSIGNED'
,p_message_language=>'pt-br'
,p_message_text=>'bugs designados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282759364325871317)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Bugs Designados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282217404679870967)
,p_name=>'BUGS_CLOSED'
,p_message_language=>'pt-br'
,p_message_text=>'Bugs fechados (%0/%1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283134875541871559)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_language=>'pt-br'
,p_message_text=>'Percentual de bugs fechados (%0/%1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282759463839871317)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bugs N\00E3o Designados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282759590138871317)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sem Corre\00E7\00E3o por Datas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283135265322871559)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_language=>'pt-br'
,p_message_text=>'Bugs: %1 de %0 fechados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283499171941871808)
,p_name=>'BUG_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Bug: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282713477103871285)
,p_name=>'BUILD QUERY'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Consulta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282180608012870944)
,p_name=>'BUILDER'
,p_message_language=>'pt-br'
,p_message_text=>'Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282819418523871355)
,p_name=>'BUILDER.PLUGINS'
,p_message_language=>'pt-br'
,p_message_text=>'Plug-ins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282814984178871352)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('[N\00E3o suportado]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283109685070871542)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mensagem do Espa\00E7o de Trabalho')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282410649243871091)
,p_name=>'BUILD_OPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00E3o de Build')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282883850471871396)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00E3o de Build: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283497816647871807)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Status do Build: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282884772995871397)
,p_name=>'BUILD_VERSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Vers\00E3o do Build')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282752939833871313)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Desenvolver o Modelo de Relat\00F3rio')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282655902077871249)
,p_name=>'BUTTON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('bot\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282656675705871249)
,p_name=>'BUTTON LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Label de Bot\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282861949281871382)
,p_name=>'BUTTON.ADD'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282197295538870954)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os Atributos do Bot\00E3o selecionado n\00E3o devem conter um ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282197125862870954)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O bot\00E3o selecionado deve ser um bot\00E3o com uma A\00E7\00E3o configurada como ''Definido por A\00E7\00E3o Din\00E2mica''')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282197481389870954)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O bot\00E3o selecionado usa um ''Modelo de Bot\00E3o'' que n\00E3o cont\00E9m a string de substitui\00E7\00E3o #BUTTON_ID#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282861715316871382)
,p_name=>'BUTTON.DELETE'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282270781421871001)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 necess\00E1rio especificar a p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282246968840870986)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Consulta do Relat\00F3rio deve ser especificada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282234123106870978)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Solicita\00E7\00E3o de Bot\00E3o deve ser especificada em todos os Tipos de Origem da Solicita\00E7\00E3o de Bot\00E3o, a menos que o Tipo de Origem da Solicita\00E7\00E3o de Bot\00E3o seja "Sempre Nulo".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282234866297870978)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Tipo de Origem de Solicita\00E7\00E3o do Bot\00E3o deve ser especificado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282270803395871001)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_language=>'pt-br'
,p_message_text=>'Especifique o Destino do URL.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282199759967870956)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Quando a A\00E7\00E3o \00E9 ''Definido por A\00E7\00E3o Din\00E2mica'', os Atributos do Bot\00E3o n\00E3o devem conter um ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282272425858871002)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_language=>'pt-br'
,p_message_text=>'A imagem deve ser especificada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282272511808871002)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_language=>'pt-br'
,p_message_text=>'O estilo deve ser especificado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282272396456871002)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Especifique o modelo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282199624490870956)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Quando o Estilo de Bot\00E3o \00E9 ''Bot\00E3o Baseado em Modelo'' e A\00E7\00E3o \00E9 ''Definido por A\00E7\00E3o Din\00E2mica'', o Modelo de Bot\00E3o selecionado deve conter a string de substitui\00E7\00E3o #BUTTON_ID#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282187243016870948)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O bot\00E3o n\00E3o pode ser deletado, pois ele \00E9 referenciado em uma A\00E7\00E3o Din\00E2mica (P\00E1gina: %0, A\00E7\00E3o Din\00E2mica: ''%1'', A\00E7\00E3o: ''%2'', Atributo: ''Elemento Afetado'').')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282187174304870948)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O bot\00E3o n\00E3o pode ser deletado, pois ele \00E9 referenciado em uma A\00E7\00E3o Din\00E2mica (P\00E1gina: %0, A\00E7\00E3o Din\00E2mica: ''%1'', Atributo: ''Quando'').')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282861801238871382)
,p_name=>'BUTTON.SUBMIT'
,p_message_language=>'pt-br'
,p_message_text=>'Submeter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282857794919871380)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_language=>'pt-br'
,p_message_text=>'Para ser usado em um atributo"onclick"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282861238477871382)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_language=>'pt-br'
,p_message_text=>'Para ser usado em um atributo"href"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282270653163871001)
,p_name=>'BUTTONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bot\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282727390377871294)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atributos do Bot\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282179578013870943)
,p_name=>'BUTTON_CSS_CLASSES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Classes CSS do Bot\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282378027702871070)
,p_name=>'BUTTON_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O ID de bot\00E3o gerado ser\00E1 o ID Est\00E1tico do bot\00E3o, se definido; sen\00E3o, ser\00E1 um ID gerado internamente no formato ''B'' || [ID de Bot\00E3o Interno]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283497600485871807)
,p_name=>'BUTTON_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bot\00E3o: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282732528320871297)
,p_name=>'BUTTON_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo de Bot\00E3o')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282267539916870999)
,p_name=>'BYTES'
,p_message_language=>'pt-br'
,p_message_text=>'bytes'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282673082064871259)
,p_name=>'BY_NEXT_PATCH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('No pr\00F3ximo patch')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282673106360871259)
,p_name=>'BY_NEXT_RELEASE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Na pr\00F3xima release')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283597067555871876)
,p_name=>'CA.ABOUT'
,p_message_language=>'pt-br'
,p_message_text=>'Sobre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283563340735871851)
,p_name=>'CA.ABOUT.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina Sobre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283563274638871851)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Inclua uma p\00E1gina sobre este aplicativo que apresente uma descri\00E7\00E3o do aplicativo, sua vers\00E3o e uma contagem de p\00E1ginas.'),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282388188874871076)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cont\00EAiner do Conte\00FAdo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283597237435871876)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina Sobre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283597322474871876)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'O texto sobre este aplicativo pode ser colocado aqui.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283596918984871876)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sobre esta P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283609274294871885)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sobre este pr\00E9-lan\00E7amento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283563659195871852)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_language=>'pt-br'
,p_message_text=>'Controle de Acesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283599532197871878)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00F5es de Controle de Acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283589028716871870)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Configura\00E7\00E3o do Controle de Acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283562069558871851)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ativar autoriza\00E7\00E3o do usu\00E1rio com base na fun\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283563748091871852)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Incorpora a autentica\00E7\00E3o do usu\00E1rio com base na fun\00E7\00E3o dentro do aplicativo.'),
unistr('Os usu\00E1rios podem ser definidos como Administradores, Colaboradores ou Leitores.'),
unistr('Voc\00EA pode definir rapidamente acesso diverso a diferentes fun\00E7\00F5es para os v\00E1rios componentes por todo o aplicativo, como p\00E1ginas, entradas do menu, regi\00F5es, colunas, itens, bot\00F5es e assim por diante.</p>'),
'<p>Inclui os seguintes componentes:',
'<ul>',
unistr('<li>\00C1rea da p\00E1gina administrativa com links para acessar as funcionalidades de controle</li>'),
unistr('<li>Tabela de usu\00E1rios para gerenciar o controle de acesso</li>'),
unistr('<li>P\00E1gina de configura\00E7\00E3o para definir o n\00EDvel de acesso aos usu\00E1rios autenticados</li>'),
unistr('<li>P\00E1gina de configura\00E7\00E3o para especificar se os nomes de usu\00E1rios s\00E3o ou n\00E3o endere\00E7os de e-mail</li>'),
unistr('<li>P\00E1gina de gerenciamento de acesso dos usu\00E1rios para reportar e editar o acesso do usu\00E1rio</li>'),
unistr('<li>P\00E1gina de adi\00E7\00E3o de usu\00E1rio com a capacidade de adicionar um \00FAnico usu\00E1rio</li>'),
unistr('<li>P\00E1gina de adi\00E7\00E3o de v\00E1rios usu\00E1rios com a capacidade de adicionar v\00E1rios usu\00E1rios (somente nomes de usu\00E1rios do e-mail)</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283587912447871869)
,p_name=>'CA.ACCESS.ROLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atribui\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283588605204871870)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Acessar ID de Atribui\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282307513567871025)
,p_name=>'CA.ACCESS.ROLES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atribui\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283588017285871869)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_language=>'pt-br'
,p_message_text=>'Conta Bloqueada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282335351711871042)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_language=>'pt-br'
,p_message_text=>'Confirmado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283599349702871878)
,p_name=>'CA.ACL.INFORMATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informa\00E7\00F5es sobre ACL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283600079521871878)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Privil\00E9gios insuficientes; o usu\00E1rio n\00E3o \00E9 um Administrador')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283600129982871879)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a exibir este aplicativo porque n\00E3o recebeu acesso ou sua conta foi bloqueada. Entre em contato com o administrador do aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283600205349871879)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Privil\00E9gios insuficientes; o usu\00E1rio n\00E3o \00E9 um Colaborador')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283589753143871871)
,p_name=>'CA.ACL.SAVED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de Controle de Acesso salvas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283594419051871874)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTML de Bot\00E3o de A\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283593323369871873)
,p_name=>'CA.ACTION.LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Label da A\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283593439789871873)
,p_name=>'CA.ACTION.LINK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Link de A\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283596095321871875)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTML de Link de A\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283581576934871864)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00E3o Processada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283587094535871869)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_language=>'pt-br'
,p_message_text=>'Atividade por hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283621369086871895)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_language=>'pt-br'
,p_message_text=>'Painel de Controle de Atividades'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283563856901871852)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio de Atividades')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283563039526871851)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Incluir atividade do usu\00E1rio e relat\00F3rios de erro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283563911367871852)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Inclui v\00E1rios relat\00F3rios sobre a atividade do usu\00E1rio final de seu aplicativo. Determina os usu\00E1rios mais ativos, as p\00E1ginas mais utilizadas, o desempenho das p\00E1ginas e os erros surgidos, para compreender melhor como o aplicativo est\00E1 sendo utiliz')
||unistr('ado e as \00E1reas a serem aprimoradas.</p>'),
'<p>Inclui os seguintes componentes:',
'<ul>',
unistr('<li>Relat\00F3rio de principais usu\00E1rios</li>'),
unistr('<li>Relat\00F3rio do Log de Erros do Aplicativo</li>'),
unistr('<li>Desempenho da P\00E1gina, atividade e desempenho por p\00E1gina</li>'),
unistr('<li>Relat\00F3rio de atividade do aplicativo por p\00E1gina</li>'),
unistr('<li>Relat\00F3rio detalhado das visualiza\00E7\00F5es de p\00E1gina</li>'),
'',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282709778106871283)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Data de In\00EDcio Real')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283599223348871878)
,p_name=>'CA.ADD'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283594614105871874)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Modelo de E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283612264025871888)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Diversos Usu\00E1rios - Etapa 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283597522425871877)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Novo %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283580583031871863)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Notifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283453052003871776)
,p_name=>'CA.ADD.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283588740503871870)
,p_name=>'CA.ADD.USER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283612622419871888)
,p_name=>'CA.ADD.USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Usu\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283565480253871853)
,p_name=>'CA.ADDING.PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionando P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283565941358871853)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Clique em <strong>Adicionar P\00E1gina</strong> para adicionar uma p\00E1gina a seu aplicativo. Em seguida, selecione um tipo de p\00E1gina (como Em Branco, Gr\00E1fico, Form, Relat\00F3rio etc.) e defina seus atributos. Tamb\00E9m pode ser necess\00E1rio especificar uma tab')
||unistr('ela ou view v\00E1lida ou usar o SQL Workshop para preparar os objetos do banco de dados em seu espa\00E7o de trabalho.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283595406204871875)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Avan\00E7ado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282709080124871282)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informa\00E7\00F5es Adicionais')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283588446802871870)
,p_name=>'CA.ADDRESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Endere\00E7o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283568616569871855)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_language=>'pt-br'
,p_message_text=>'Controle de Acesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283569272119871855)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defina o n\00EDvel de acesso dos usu\00E1rios autenticados deste aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283567798323871854)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rios de Atividades')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283568796583871855)
,p_name=>'CA.ADMIN.ADD'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283570434594871856)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Administra\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283569188851871855)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_language=>'pt-br'
,p_message_text=>'Administradores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282744702555871307)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Configura\00E7\00E3o do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282855414147871378)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Interface do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283604026227871882)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Administra\00E7\00E3o de Aplicativos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283604107910871882)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Gerenciar componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283567369724871854)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sele\00E7\00E3o de Estilo do Tema')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283567410527871854)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Define a apar\00EAncia e a funcionalidade do aplicativo padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283567014100871854)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es de Configura\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283566962331871854)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Ativar ou desativar funcionalidades do aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283568097463871855)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_language=>'pt-br'
,p_message_text=>'Log de Erros do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283568169942871855)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio de erros registrados por este aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283567528004871854)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283567625675871854)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defina um nome e uma descri\00E7\00E3o curta para o aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283567187006871854)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atualiza\00E7\00F5es do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283567297489871854)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mantenha a lista de atualiza\00E7\00F5es do aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283566699011871854)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Configura\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283569060410871855)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_language=>'pt-br'
,p_message_text=>'Colaboradores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283620113090871894)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_language=>'pt-br'
,p_message_text=>'Painel de Controle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283620071239871894)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir m\00E9tricas de atividade do aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283572136983871857)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fuso Hor\00E1rio Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283572230685871857)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defina o fuso hor\00E1rio padr\00E3o deste aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283569965677871856)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>'E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283572380459871858)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de E-mail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283572484772871858)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Defina se o e-mail deve ser enviado e, em caso afirmativo, quem deve responder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283569456198871856)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_language=>'pt-br'
,p_message_text=>'Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283569716223871856)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de Feedback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283569859074871856)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Gerencie se os anexos devem ser permitidos.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283569592234871856)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Feedback do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283569673814871856)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio de todo o feedback enviado pelos usu\00E1rios do aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283570092554871856)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_language=>'pt-br'
,p_message_text=>'Modelos de E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283570110071871856)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Gerencie HTML e CSS do modelo de e-mail usado por este aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283566728558871854)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Notifica\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283566872479871854)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir notifica\00E7\00F5es na home page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283604732949871882)
,p_name=>'CA.ADMIN.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina de Administra\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283568204516871855)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Desempenho da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283568365860871855)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio de atividade e desempenho por p\00E1gina do aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283568424264871855)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Views de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283568513142871855)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio de cada visualiza\00E7\00E3o de p\00E1gina por usu\00E1rio, incluindo a data de acesso e o tempo decorrido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283568940294871855)
,p_name=>'CA.ADMIN.READERS'
,p_message_language=>'pt-br'
,p_message_text=>'Leitores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283613379119871889)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283613429872871889)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar e-mail baseado em modelo deste aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283567870644871855)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Principais Usu\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283567971012871855)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio de views de p\00E1gina agregadas por usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283568895095871855)
,p_name=>'CA.ADMIN.USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283569391509871855)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Altere as defini\00E7\00F5es de controle de acesso e desative o controle de acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283570279544871856)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_language=>'pt-br'
,p_message_text=>'Log de E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283570346093871856)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Exiba log de e-mails enviados por este aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282491366570871142)
,p_name=>'CA.ADVANCED'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Avan\00E7ado</strong> - Expanda para ver op\00E7\00F5es avan\00E7adas.'),
'    <ul>',
unistr('      <li><strong>Definir como Home Page</strong> - Torne esta p\00E1gina a home page do aplicativo.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;Qualquer p\00E1gina definida anteriormente como a home page ser\00E1 atualizada.</li>'),
unistr('      <li><strong>Definir como P\00E1gina de Administra\00E7\00E3o</strong> - Adicione esta p\00E1gina sob Administra\00E7\00E3o, em vez de como p\00E1gina normal no aplicativo. Acesse clicando em Administra\00E7\00E3o no menu principal e depois selecionando na lista de Administra\00E7\00E3o d')
||'e Aplicativos.<br>',
unistr('        <em><strong>Observa\00E7\00E3o:</strong> Uma p\00E1gina n\00E3o pode ser uma Home page e uma p\00E1gina sob Administra\00E7\00E3o.</em></li>'),
'      &nbsp;<br>',
unistr('      <li><strong>Ajuda da P\00E1gina</strong> - Digite o texto a ser adicionado ao Texto de Ajuda da p\00E1gina.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282361600592871059)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Avan\00E7ado</strong> - Expanda para ver op\00E7\00F5es avan\00E7adas.'),
'    <ul>',
unistr('      <li><strong>Ajuda da P\00E1gina</strong> - Digite um texto a ser adicionado ao Texto da Ajuda da p\00E1gina.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283605165130871882)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Configura\00E7\00F5es Avan\00E7adas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283605285693871882)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Fa\00E7a defini\00E7\00F5es adicionais, de seguran\00E7a e de globaliza\00E7\00E3o. Essas defini\00E7\00F5es podem ser aplicadas durante a cria\00E7\00E3o do aplicativo e tamb\00E9m editadas ap\00F3s a cria\00E7\00E3o do aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283608297086871885)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Leia a ajuda do item ( <span class="fa fa-question-circle" aria-hidden="true"></span> ) referente a cada defini\00E7\00E3o para obter mais informa\00E7\00F5es.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283614024584871889)
,p_name=>'CA.AFTER.ROWS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ap\00F3s as Linhas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283594365153871874)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTML ap\00F3s as Linhas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283597427133871877)
,p_name=>'CA.ALL.COLS'
,p_message_language=>'pt-br'
,p_message_text=>'Todas as Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283593514333871874)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_language=>'pt-br'
,p_message_text=>'Permitir Recusa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282702610106871278)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Permitir Execu\00E7\00F5es no Modo Restrito')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283586915032871868)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_language=>'pt-br'
,p_message_text=>'Log de Erros do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283582838820871865)
,p_name=>'CA.APP.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282755631951871314)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Se o controle de acesso est\00E1 ou n\00E3o ativado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282755772159871314)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O n\00EDvel de acesso padr\00E3o fornecido a usu\00E1rios autenticados que n\00E3o est\00E3o na lista de controle de acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283583238833871866)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es do aplicativo atualizadas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283583023321871865)
,p_name=>'CA.APP.SUBTITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Descri\00E7\00E3o Breve')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283583143851871866)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O texto inserido aqui \00E9 exibido sob o nome do aplicativo na home page do aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283572550997871858)
,p_name=>'CA.APPEARANCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Apar\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283572633285871858)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Defina o esquema de cores do aplicativo padr\00E3o (estilo de tema) no qual a navega\00E7\00E3o est\00E1 localizada e o \00EDcone usado para o aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283592058930871872)
,p_name=>'CA.APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283579177406871862)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Apar\00EAncia do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283573152682871858)
,p_name=>'CA.APPLICATION.ICON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00CDcone do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283573218111871858)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Clique em <strong>Escolher Novo \00CDcone</strong> para selecionar a cor do \00EDcone e um dos \00EDcones dispon\00EDveis. Sua sele\00E7\00E3o \00E9 exibida na home page do aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283573511667871858)
,p_name=>'CA.APPLICATION.ID'
,p_message_language=>'pt-br'
,p_message_text=>'ID do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283573654086871858)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Informe um identificador num\00E9rico, exclusivo para seu aplicativo. Este campo cont\00E9m um identificador gerado automaticamente, por padr\00E3o.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283592668852871873)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283584863748871867)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sess\00F5es do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283563489456871851)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283562387281871851)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defina um nome e uma descri\00E7\00E3o curta para o aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283563519804871852)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite que os administradores do aplicativo atualizem v\00E1rias defini\00E7\00F5es, como o nome do aplicativo e uma descri\00E7\00E3o, fuso hor\00E1rio padr\00E3o e assim por diante.</p>'),
'<p>Inclui os seguintes componentes:',
'<ul>',
unistr('<li>Entrada e form da lista da p\00E1gina administrativa</li>'),
'<li>Capacidade de definir o nome do aplicativo</li>',
unistr('<li>Capacidade de definir o subt\00EDtulo da \00E1rea de imagem principal da home page</li>'),
unistr('<li>Capacidade de definir destinat\00E1rios de feedback, se usar o feedback</li>'),
unistr('<li>Capacidade de definir o fuso hor\00E1rio padr\00E3o do aplicativo</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283619188779871893)
,p_name=>'CA.APPLICATIONITEM'
,p_message_language=>'pt-br'
,p_message_text=>'Item de Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283620949008871895)
,p_name=>'CA.APPLY'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283622729947871897)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Aplicando padr\00F5es do aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283578316999871862)
,p_name=>'CA.APPLY.CHANGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Aplicar Altera\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283620737459871894)
,p_name=>'CA.APPLY.FILTERS'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicar Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282853389102871377)
,p_name=>'CA.APP_BANNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Aplicativo criado com base no assistente de cria\00E7\00E3o de aplicativos %0.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282854652080871378)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Salvar Defini\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283624949495871899)
,p_name=>'CA.ATTACHMENT'
,p_message_language=>'pt-br'
,p_message_text=>'Anexo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282569029004871193)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem de Anexos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283625023548871899)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Anexo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282568962338871193)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_language=>'pt-br'
,p_message_text=>'Tamanho do Anexo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283621034316871895)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00F5es de Atributo j\00E1 definidos para: %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283589179067871870)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Qualquer usu\00E1rio autenticado pode acessar este aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283574341981871859)
,p_name=>'CA.AUTHENTICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283574487520871859)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Selecione como voc\00EA deseja que os usu\00E1rios sejam autenticados em seu aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282705389229871280)
,p_name=>'CA.AUTO.DROP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Elimina\00E7\00E3o Autom\00E1tica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283585588784871867)
,p_name=>'CA.AVG.ELAPSED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9d. Decorrido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282752773610871313)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voltar ao Relat\00F3rio de Jobs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282569773036871194)
,p_name=>'CA.BCC'
,p_message_language=>'pt-br'
,p_message_text=>'CCO'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283613982813871889)
,p_name=>'CA.BEFORE.ROWS'
,p_message_language=>'pt-br'
,p_message_text=>'Antes das Linhas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283594288145871874)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_language=>'pt-br'
,p_message_text=>'HTML antes das Linhas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283595741975871875)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conte\00FAdo antes das Linhas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283571026250871857)
,p_name=>'CA.BLANK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina em Branco')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283571103702871857)
,p_name=>'CA.BLANK.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crie uma p\00E1gina em branco como placeholder. Quando voc\00EA criar o aplicativo, poder\00E1 prontamente criar regi\00F5es na p\00E1gina com base no Designer de P\00E1ginas.</p>'),
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome da P\00E1gina</strong> (Obrigat\00F3rio) - Digite um nome para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone para exibir no menu de navega\00E7\00E3o desta p\00E1gina.</li>'),
unistr('<!--  <li><strong>Incluir Navega\00E7\00E3o de P\00E1gina</strong> - Marque esta op\00E7\00E3o para exibir uma lista de cart\00F5es de todas as outras p\00E1ginas definidas no seu aplicativo.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;Esta op\00E7\00E3o em geral \00E9 usada na home page do seu aplicativo.</li>'),
'-->',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283604438484871882)
,p_name=>'CA.BLUEPRINT'
,p_message_language=>'pt-br'
,p_message_text=>'Projeto do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283604594742871882)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>O blueprint lista a defini\00E7\00E3o do aplicativo no formato JSON.</p>'),
unistr('<p>Quando se acessa essa tela pela primeira vez, a defini\00E7\00E3o atual do aplicativo \00E9 transformada em um documento JSON e exibida. Voc\00EA pode editar o documento para atualizar as propriedades do aplicativo e, em seguida, clicar em <strong>Aplicar Bluepri')
||'nt</strong> para alterar os detalhes do aplicativo atual.</p>',
'<p>&nbsp;</p>',
unistr('<p>Se for necess\00E1rio criar um n\00FAmero grande de p\00E1ginas semelhantes, a a\00E7\00E3o de copiar o c\00F3digo JSON relevante de uma p\00E1gina, colar diversas vezes e fazer pequenos ajustes no JSON ser\00E1 significativamente mais r\00E1pida do que usar manualmente a a\00E7\00E3o <stro')
||unistr('ng>Adicionar P\00E1gina</strong> para cada p\00E1gina.</p>'),
unistr('<p>Clique em <strong>Carregar um Blueprint Anterior</strong> para substituir o blueprint pela defini\00E7\00E3o de um aplicativo gerado anteriormente. Dessa forma, ser\00E1 poss\00EDvel iterar muito facilmente um design de aplicativo adicionando mais p\00E1ginas, altera')
||unistr('ndo as funcionalidades ou ajustando as defini\00E7\00F5es, antes de gerar o aplicativo novamente.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283593178297871873)
,p_name=>'CA.BODY1.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Texto do Corpo1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283593233827871873)
,p_name=>'CA.BODY2.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Texto do Corpo2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283614392554871889)
,p_name=>'CA.BOTH'
,p_message_language=>'pt-br'
,p_message_text=>'Ambos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283579521138871862)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ramificar para P\00E1gina Admin')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282490208751871142)
,p_name=>'CA.BUTTON.BAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Barra de Bot\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283579293819871862)
,p_name=>'CA.BUTTONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bot\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283571725164871857)
,p_name=>'CA.CALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina do Calend\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283571897256871857)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cria uma p\00E1gina que exibe um calend\00E1rio.</p>'),
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome da P\00E1gina</strong> (Obrigat\00F3rio) - Informe um nome para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone para exibir no menu de navega\00E7\00E3o desta p\00E1gina.</li>'),
unistr('  <li><strong>Tabela ou View</strong> (Obrigat\00F3rio) - Selecione o objeto do banco de dados do calend\00E1rio.</li>'),
unistr('  <li><strong>Coluna para Exibi\00E7\00E3o</strong> (Obrigat\00F3rio) - Selecione a coluna da tabela ou view a ser exibida nos eventos do calend\00E1rio.</li>'),
unistr('  <li><strong>Coluna de Data Inicial</strong> (Obrigat\00F3rio) - Selecione a coluna de data da tabela ou view a ser usada como data inicial dos eventos do calend\00E1rio.</li>'),
unistr('  <li><strong>Coluna de Data Final</strong> - Selecione a coluna de data na tabela ou view a ser usada como a data final dos eventos do calend\00E1rio.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;Se a Data Final for especificada, os eventos com base na dura\00E7\00E3o ser\00E3o exibidos. </li>'),
unistr('  <li><strong>Mostrar Hora</strong> - Selecione <strong>Sim</strong> para mostrar a parte de hora dos eventos e tamb\00E9m ativar as views do calend\00E1rio Semanal e Di\00E1rio. Selecione <strong>N\00E3o</strong> para mostrar somente as datas dos eventos.</li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283578230466871862)
,p_name=>'CA.CANCEL'
,p_message_language=>'pt-br'
,p_message_text=>'Cancelar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283580102581871863)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cancelar Caixa de Di\00E1logo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282470303440871128)
,p_name=>'CA.CANCEL.MODAL'
,p_message_language=>'pt-br'
,p_message_text=>'Cancelar Modal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283590017223871871)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA n\00E3o pode remover os direitos de administra\00E7\00E3o de seu pr\00F3prio registro.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283621990165871895)
,p_name=>'CA.CARD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina de Cart\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283621816066871895)
,p_name=>'CA.CARD.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crie uma p\00E1gina que exiba cart\00F5es.</p>'),
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome da P\00E1gina</strong> (Obrigat\00F3rio) - Digite um nome para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone a ser exibido no menu de navega\00E7\00E3o desta p\00E1gina.</li>'),
unistr('  <li><strong>Tabela ou View</strong> (Obrigat\00F3rio) - Selecione o objeto de banco de dados para o cart\00E3o.</li>'),
unistr('  <li><strong>T\00EDtulo do Cart\00E3o</strong> (Obrigat\00F3rio) - Selecione a coluna da tabela ou view a ser usada como o t\00EDtulo do cart\00E3o.</li>'),
unistr('  <li><strong>Coluna de Descri\00E7\00E3o</strong> (Obrigat\00F3rio) - Selecione a coluna da tabela ou view a ser usada como a descri\00E7\00E3o do cart\00E3o.</li>'),
unistr('  <li><strong>Coluna de Texto Adicional</strong> - Selecione a coluna na tabela ou view a ser usada como a descri\00E7\00E3o secund\00E1ria do cart\00E3o.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283620419215871894)
,p_name=>'CA.CARDS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cart\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283620577263871894)
,p_name=>'CA.CARDS.VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('View de Cart\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282569893943871194)
,p_name=>'CA.CC'
,p_message_language=>'pt-br'
,p_message_text=>'CC'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282854007747871377)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_language=>'pt-br'
,p_message_text=>'Alterar Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283570891547871857)
,p_name=>'CA.CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina do Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283570904794871857)
,p_name=>'CA.CHART.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crie uma p\00E1gina que exiba um gr\00E1fico de \00E1reas, barras, linhas ou pizza.</p>'),
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome da P\00E1gina</strong> (Obrigat\00F3rio) - Digite um nome para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone para exibir no menu de navega\00E7\00E3o desta p\00E1gina.</li>'),
unistr('  <li><strong>Tipo de Gr\00E1fico</strong> - Selecione o tipo de gr\00E1fico a ser exibido [<strong>\00C1reas</strong>, <strong>Barras</strong>, <strong>Linhas</strong>, <strong>Pizza</strong>].</li>'),
unistr('  <li><strong>Tabela ou View</strong> (Obrigat\00F3rio) - Selecione o objeto do banco de dados do gr\00E1fico.</li>'),
unistr('  <li><strong>Coluna do Label</strong> (Obrigat\00F3rio) - Selecione a coluna da tabela ou view a ser usada como label para o gr\00E1fico.</li>'),
unistr('  <li><strong>Agrega\00E7\00E3o de Valor</strong> - Selecione como a coluna de valor deve ser exibida ou agregada<br>'),
'      &nbsp;&nbsp;&nbsp;[Valor da Coluna, Soma, Contagem].</li>',
unistr('  <li><strong>Coluna de Valor</strong> (Obrigat\00F3rio) - Selecione uma coluna num\00E9rica na tabela ou da view que \00E9 usada para calcular os valores do gr\00E1fico exibidos.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283571225328871857)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h3>Exemplos</h3>',
'<p>Revisa os exemplos de como utilizar os diferentes tipos de <strong>Resumo</strong>:</p>',
unistr('<p><strong>Exemplo 1:</strong> Exibe um gr\00E1fico de Funcion\00E1rios com o n\00FAmero de funcion\00E1rios do gerente de cada funcion\00E1rio.'),
'<code><ul>',
'  <li>Tabela ou View - Selecione EMP.</li>',
'  <li>Coluna de Label - Selecione ENAME.</li>',
'  <li>Resumo - Selecione <u><strong>Valor da Coluna</strong></u>.</li>',
'  <li>Valor da Coluna - Selecione MGR.</li>',
'</ul></code>',
'</p>',
unistr('<p><strong>Exemplo 2:</strong> Exibe um gr\00E1fico sobre os Funcion\00E1rios com o sal\00E1rio total de cada cargo.'),
'<code><ul>',
'  <li>Tabela ou View - Selecione EMP.</li>',
'  <li>Coluna do Label - Selecione JOB.</li>',
'  <li>Resumo - Selecione <u><strong>Res.</strong></u>.</li>',
'  <li>Coluna de Valor - Selecione SAL.</li>',
'</ul></code>',
'</p>',
unistr('<p><strong>Exemplo 3:</strong> Exibe um gr\00E1fico sobre os Funcion\00E1rios com o n\00FAmero de funcion\00E1rios de cada departamento.'),
'<code><ul>',
'  <li>Tabela ou View - Selecione EMP.</li>',
'  <li>Coluna do Label - Selecione DEPTNO.</li>',
'  <li>Resumo - Selecione <u><strong>Contagem</strong></u>.</li>',
'  <li>Coluna de Valor - Selecione EMPNO.</li>',
'</ul></code>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282707382271871281)
,p_name=>'CA.CLIENT.ID'
,p_message_language=>'pt-br'
,p_message_text=>'ID do Cliente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283625146445871899)
,p_name=>'CA.CLOSE'
,p_message_language=>'pt-br'
,p_message_text=>'Fechar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282335255494871042)
,p_name=>'CA.CLOSED'
,p_message_language=>'pt-br'
,p_message_text=>'Fechado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283623145450871898)
,p_name=>'CA.COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283599097481871878)
,p_name=>'CA.COLUMN.1'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283599131236871878)
,p_name=>'CA.COLUMN.2'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283586421869871868)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_language=>'pt-br'
,p_message_text=>'Alias de Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283618910315871893)
,p_name=>'CA.COMMENTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coment\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283584164725871866)
,p_name=>'CA.COMPONENT.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283588904849871870)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_language=>'pt-br'
,p_message_text=>'Configurar Controle de Acesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283579388627871862)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Configurar Apar\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283579487119871862)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>A apar\00EAncia de seu aplicativo \00E9 definida pelo Estilo do Tema.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283582710362871865)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es de Configura\00E7\00E3o atualizadas. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283564624122871852)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es de Configura\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283562928810871851)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Ativar ou desativar funcionalidades do aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283564716327871852)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite que os administradores do aplicativo ativem ou desativem a funcionalidade espec\00EDfica dentro do aplicativo. Esta funcionalidade \00E9 muito \00FAtil, se forem selecionadas funcionalidades que demandem maior esfor\00E7o de desenvolvimento para que possa')
||unistr('m ser usadas pelos usu\00E1rios finais.<br>'),
unistr('Esta funcionalidade tamb\00E9m pode ser expandida para as funcionalidades espec\00EDficas do aplicativo. Se os desenvolvedores definirem op\00E7\00F5es de build adicionais e associarem-nas \00E0 funcionalidade espec\00EDfica por todo o aplicativo, ent\00E3o elas poder\00E3o ser adi')
||unistr('cionadas \00E0s defini\00E7\00F5es de configura\00E7\00E3o para os administradores. Por exemplo, dentro do Pacote de Aplicativos do Rastreador de Clientes, os administradores podem ativar ou desativar funcionalidades como Contatos, Carga de Dados, Geografia e muito mais')
||'.',
'</p>',
'<p>Inclui os seguintes componentes:',
'<ul>',
'<li>Permite que a funcionalidade do aplicativo seja ativada ou desativada</li>',
unistr('<li>Usa a funcionalidade para permitir funcionalidade seletiva por implanta\00E7\00E3o</li>'),
unistr('<li>Permite o agrupamento de defini\00E7\00F5es do aplicativo relacionadas</li>'),
unistr('<li>Os desenvolvedores do aplicativo controlam os componentes usando as op\00E7\00F5es de build</li>'),
unistr('<li>Dispon\00EDvel na p\00E1gina de Administra\00E7\00E3o</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282702248216871278)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome da Credencial de Conex\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282702383876871278)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conectar Propriet\00E1rio da Credencial')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283432275943871762)
,p_name=>'CA.CONTEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Contexto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283589401198871870)
,p_name=>'CA.CONTRIBUTOR'
,p_message_language=>'pt-br'
,p_message_text=>'Colaborador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282709268652871283)
,p_name=>'CA.CPU.USED'
,p_message_language=>'pt-br'
,p_message_text=>'CPU Utilizada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283597950501871877)
,p_name=>'CA.CREATE'
,p_message_language=>'pt-br'
,p_message_text=>'Criar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283603006633871881)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina de administra\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283600672329871879)
,p_name=>'CA.CREATE.APP'
,p_message_language=>'pt-br'
,p_message_text=>'Criando aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283601785011871880)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando c\00E1lculos do aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283601027308871879)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando \00EDcone do aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283601661184871880)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_language=>'pt-br'
,p_message_text=>'Criando itens de aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283601831486871880)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Criando processos do aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283443224750871769)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando defini\00E7\00F5es de aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283609045728871885)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Criar um Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282754017946871313)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando atribui\00E7\00F5es de aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283601228078871879)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando esquemas de autoriza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283602040854871880)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina em branco')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283601119227871879)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando op\00E7\00F5es de build')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283602443641871880)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina do calend\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283615378512871890)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando a p\00E1gina de cart\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283602257099871880)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina do gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283602780812871881)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina de relat\00F3rio cl\00E1ssico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283602338598871880)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina do painel de controle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283600508555871879)
,p_name=>'CA.CREATE.END'
,p_message_language=>'pt-br'
,p_message_text=>'Finalizando'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283622622645871897)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina de pesquisa facetada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283603316284871881)
,p_name=>'CA.CREATE.FEATURES'
,p_message_language=>'pt-br'
,p_message_text=>'Criando funcionalidades'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283619994667871894)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando P\00E1gina de Conte\00FAdo Filtrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283602100038871880)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina do form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283600724395871879)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina global')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283602950150871881)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando lista de navega\00E7\00E3o da home page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283602880768871881)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina de grade interativa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283602634691871880)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina de relat\00F3rio interativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283608726850871885)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1ginas detalhe/mestre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283601434118871880)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando barras de navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283604638864871882)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando um grupo de p\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283603253795871881)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Executando a tradu\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283603121066871881)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Executando a tradu\00E7\00E3o de %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283602529004871880)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando relat\00F3rio e p\00E1gina do form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283608971385871885)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_language=>'pt-br'
,p_message_text=>'Salvando o blueprint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283601500398871880)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_language=>'pt-br'
,p_message_text=>'Criando atalho'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283601930234871880)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina de acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283600423474871879)
,p_name=>'CA.CREATE.START'
,p_message_language=>'pt-br'
,p_message_text=>unistr('In\00EDcio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283600886610871879)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_language=>'pt-br'
,p_message_text=>'Criando scripts de objeto de suporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283601303774871879)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_language=>'pt-br'
,p_message_text=>'Criando mensagens de texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283615420482871890)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando a p\00E1gina de linha do tempo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283622897851871898)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criando p\00E1gina do assistente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283582094612871865)
,p_name=>'CA.CREATED'
,p_message_language=>'pt-br'
,p_message_text=>'Criado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283582113993871865)
,p_name=>'CA.CREATED.BY'
,p_message_language=>'pt-br'
,p_message_text=>'Criado por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283570539842871856)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Criando Aplicativo ...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282702950297871279)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Credencial'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282709194857871283)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio da Credencial')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283582696614871865)
,p_name=>'CA.CURRENT.STATUS'
,p_message_language=>'pt-br'
,p_message_text=>'Status Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283603652610871881)
,p_name=>'CA.CUSTOM.QRY'
,p_message_language=>'pt-br'
,p_message_text=>'Consulta Personalizada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282800840594871344)
,p_name=>'CA.CUSTOM.THEME'
,p_message_language=>'pt-br'
,p_message_text=>'Usar Tema Personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282800958569871344)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Alterne o assistente para usar um tema personalizado em vez do Universal Theme.</p>',
'',
unistr('<p>Selecione um Tema de Espa\00E7o de Trabalho para o aplicativo. Se o tema suportar Estilos de Temas, o estilo tamb\00E9m poder\00E1 ser selecionado.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282470033926871128)
,p_name=>'CA.CUSTOM_THEME'
,p_message_language=>'pt-br'
,p_message_text=>'Tema Personalizado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283604209619871882)
,p_name=>'CA.DASHBOARD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina de Painel de Controle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283430661681871760)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1fico %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283604304135871882)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crie uma p\00E1gina do painel de controle com v\00E1rios gr\00E1ficos.</p>'),
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome da P\00E1gina</strong> (Obrigat\00F3rio) - Digite um nome para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone a ser exibido no menu de navega\00E7\00E3o desta p\00E1gina.</li>'),
'  </ul>',
'</ul>',
'&nbsp;<br>',
unistr('<p>Cada gr\00E1fico (Gr\00E1fico 1, Gr\00E1fico 2, Gr\00E1fico 3 e Gr\00E1fico 4) adota como padr\00E3o diversos tipos de gr\00E1ficos e se baseia na <em>Amostra de Dados</em>. '),
unistr('  Como tal, voc\00EA n\00E3o precisa inserir nenhum detalhe adicional para adicionar esta p\00E1gina.'),
unistr('  No entanto, voc\00EA pode personalizar cada gr\00E1fico substituindo os valores padr\00E3o por suas pr\00F3prias sele\00E7\00F5es.<br>'),
unistr('  Para personalizar um gr\00E1fico, informe os seguintes atributos:</p>'),
'<ul>',
unistr('  <li><strong>Nome do Gr\00E1fico</strong> (Obrigat\00F3rio) - Digite o nome do gr\00E1fico.</li>'),
unistr('  <li><strong>Tipo de Gr\00E1fico</strong> - Selecione o tipo de gr\00E1fico a ser exibido [<strong>\00C1reas</strong>, <strong>Barras</strong>, <strong>Linhas</strong>, <strong>Pizza</strong>].</li>'),
unistr('  <li><strong>Tabela ou View</strong> (Obrigat\00F3rio) - Selecione o objeto de banco de dados para o gr\00E1fico.</li>'),
unistr('  <li><strong>Coluna do Label</strong> (Obrigat\00F3rio) - Selecione a coluna na tabela ou view a ser usada como o label para o gr\00E1fico.</li>'),
unistr('  <li><strong>Agrega\00E7\00E3o de Valor</strong> - Selecione como a coluna de valor deve ser exibida ou agregada<br>'),
'      &nbsp;&nbsp;&nbsp;[Valor da Coluna, Soma, Contagem].</li>',
unistr('  <li><strong>Coluna de Valor</strong> (Obrigat\00F3rio) - Selecione uma coluna num\00E9rica na tabela ou view que seja usada para calcular os valores de gr\00E1fico exibidos.</li>'),
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283616042505871891)
,p_name=>'CA.DATATYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283617164544871892)
,p_name=>'CA.DATEFORMATMASK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1scara de Formato de Data')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283583361715871866)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fuso Hor\00E1rio Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283583422532871866)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fuso hor\00E1rio padr\00E3o atualizado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283605094054871882)
,p_name=>'CA.DEFAULTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00F5es de Atributo de Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283605331790871883)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esse documento JSON permite controle fino da gera\00E7\00E3o de nomes de colunas, m\00E1scaras de formato etc. de relat\00F3rios e forms. Voc\00EA tamb\00E9m pode definir listas de valores e outros componentes compartilhados. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283622445962871897)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_language=>'pt-br'
,p_message_text=>'Atributos da Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283622510181871897)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Adicione um atributo de lista de valores (LOV). As LOVs podem ser usadas em defini\00E7\00F5es de colunas da tabela.</p>'),
'<p>Informe os seguintes atributos:',
'  <ul>',
unistr('    <li><strong>Nome</strong> (Obrigat\00F3rio) - Digite o nome da lista de valores.</li>'),
unistr('    <li><strong>Tipo</strong> - Selecione o tipo de lista de valores [Estruturada, Din\00E2mica, Est\00E1tica].<br>'),
'      Para o Tipo <u>Estruturado</u> - ',
'      <ul>',
unistr('          <li><strong>Tabela</strong> (Obrigat\00F3rio) - Selecione a tabela ou view na qual a lista de valores se basear\00E1.</li>'),
unistr('          <li><strong>Coluna de Exibi\00E7\00E3o</strong> (Obrigat\00F3rio) - Selecione a coluna a ser exibida aos usu\00E1rios finais.</li>'),
unistr('          <li><strong>Coluna de Chaves</strong> (Obrigat\00F3rio) - Selecione o valor da coluna a ser retornado. Em geral \00E9 a chave prim\00E1ria da tabela.</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      Para o Tipo <u>Din\00E2mico</u> -'),
'      <ul>',
unistr('          <li><strong>Consulta SQL</strong> (Obrigat\00F3rio) - Informe uma instru\00E7\00E3o SQL select v\00E1lida que retorne dois valores (valor de exibi\00E7\00E3o e valor de retorno).</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      Para o Tipo <u>Est\00E1tico</u> -'),
'      <ul>',
unistr('          <li><strong>Lista de Valores Est\00E1tica</strong> (Obrigat\00F3rio) - Informe uma lista est\00E1tica v\00E1lida com o formato:'),
'          <ul>',
'            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>Lista exibida na ordem digitada</li>',
unistr('            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>Lista em ordem alfab\00E9tica</li>'),
unistr('            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>Valor de exibi\00E7\00E3o e valor de retorno s\00E3o iguais</li>'),
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283623662688871898)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atributos do Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283623785757871898)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Edite os atributos de todos os relat\00F3rios.</p>'),
'<p>Informe os seguintes atributos:',
'  <ul>',
unistr('    <li><strong>Linhas por P\00E1gina</strong> - Informe o n\00FAmero de linhas de relat\00F3rio a serem exibidas por padr\00E3o.</li>'),
unistr('    <li><strong>M\00E9todo de Pagina\00E7\00E3o</strong> - Selecione como a pagina\00E7\00E3o do relat\00F3rio ser\00E1 exibida.</li>'),
unistr('    <li><strong>M\00E1scara de Formato Num\00E9rico</strong> - Informe a m\00E1scara de formato a ser aplicada a colunas e itens num\00E9ricos.</li>'),
unistr('    <li><strong>M\00E1scara de Formato de Data</strong> - Informe a m\00E1scara de formato a ser aplicada a colunas e itens de data.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283623452163871898)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Atributos de Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283623269589871898)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Atributos de Coluna da Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283623303339871898)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edite os atributos da coluna da tabela selecionada.</p>',
'<p>Informe os seguintes atributos:',
'  <ul>',
unistr('    <li><strong>Tabela</strong> (Somente para Exibi\00E7\00E3o) - A tabela associada.</li>'),
unistr('    <li><strong>Coluna</strong> (Somente para Exibi\00E7\00E3o) - A coluna com base na qual os atributos s\00E3o definidos.</li>'),
unistr('    <li><strong>Label</strong> - Informe o label a ser usado nos t\00EDtulos dos relat\00F3rios e nos labels de forms.</li>'),
'    <li><strong>Controle de Form</strong> - Selecione o tipo de item a ser usado em forms.</li>',
unistr('    <li><strong>Lista de Valores</strong> - Selecione uma Lista de Valores existente a ser usada para exibir nomes f\00E1ceis conforme apropriado.</li>'),
unistr('    <li><strong>M\00E1scara de Formato</strong> - Informe uma m\00E1scara de formato apropriada com base no tipo de coluna (texto, n\00FAmero, data etc.).</li>'),
unistr('    <li><strong>Valor Padr\00E3o Est\00E1tico</strong> - Informe um valor padr\00E3o de texto para a coluna.</li>'),
unistr('    <li><strong>Incluir em Forms</strong> - Clique em Sim se a coluna tiver de ser inclu\00EDda em forms.</li>'),
unistr('    <li><strong>Incluir em Relat\00F3rios</strong> - Clique em Sim se a coluna tiver de ser inclu\00EDda em relat\00F3rios.</li>'),
unistr('    <li><strong>Obrigat\00F3rio</strong> - Clique em Sim se os dados tiverem de ser inseridos nesta coluna dos forms.</li>'),
'    <li><strong>Ajuda</strong> - Digite um texto de ajuda a ser adicionado ao atributo de ajuda do item.</li>',
'  </ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283623539514871898)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edite os atributos da tabela selecionada.</p>',
'<p>Informe os seguintes atributos:',
'  <ul>',
unistr('    <li><strong>Tabela</strong> (Somente para Exibi\00E7\00E3o) - A tabela associada.</li>'),
unistr('    <li><strong>Label, Singular</strong> (Obrigat\00F3rio) - Informe o label a ser usado nas p\00E1ginas dos forms.</li>'),
unistr('    <li><strong>Label, Plural</strong> (Obrigat\00F3rio) - Informe o label a ser usado em t\00EDtulos de regi\00E3o e nomes de p\00E1ginas.</li>'),
unistr('    <li><strong>Coluna de Exibi\00E7\00E3o Principal</strong> - Selecione a primeira coluna a ser exibida, por exemplo, em regi\00F5es do cart\00E3o.</li>'),
unistr('    <li><strong>Coluna de Exibi\00E7\00E3o Secund\00E1ria</strong> - Selecione a segunda coluna a ser exibida, por exemplo, em regi\00F5es do cart\00E3o.</li>'),
unistr('    <li><strong>Coluna de Chave Prim\00E1ria</strong> - Selecione a coluna de chave exclusiva para a tabela.</li>'),
unistr('    <li><strong>Descri\00E7\00E3o</strong> - Digite uma descri\00E7\00E3o para a tabela.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282702746058871278)
,p_name=>'CA.DEFERRED.DROP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Elimina\00E7\00E3o Adiada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283617791882871892)
,p_name=>'CA.DEFINITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283600361263871879)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Desinstala\00E7\00E3o conclu\00EDda.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283580617921871863)
,p_name=>'CA.DELETE'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283599997985871878)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gostaria de executar esta a\00E7\00E3o de exclus\00E3o?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283566233520871853)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tem certeza de que deseja excluir esta p\00E1gina?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283590472334871871)
,p_name=>'CA.DELETE.PHOTO'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283581329214871864)
,p_name=>'CA.DESCRIPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Descri\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283598582128871877)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Barra de Navega\00E7\00E3o da \00C1rea de Trabalho')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283598450128871877)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Menu de Navega\00E7\00E3o da \00C1rea de Trabalho')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283579656777871863)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_language=>'pt-br'
,p_message_text=>'Estilo do Tema do Desktop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283579767039871863)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Estilo do Tema padr\00E3o \00E9 aplicado a todos os usu\00E1rios.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282703191323871279)
,p_name=>'CA.DESTINATION'
,p_message_language=>'pt-br'
,p_message_text=>'Destino'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282703240691871279)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio de Destino')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282470100656871128)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bot\00F5es de Caixa de Di\00E1logo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283594918432871875)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_language=>'pt-br'
,p_message_text=>'Despachar E-mails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283614568154871890)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_language=>'pt-br'
,p_message_text=>'Determina se os e-mails devem ser enviados pela Estrutura de E-mail.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283581174115871864)
,p_name=>'CA.DISPLAY.FROM'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir - De'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283581098266871864)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sequ\00EAncia de Exibi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283581270710871864)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir - At\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283616242397871891)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna de Exibi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283584786870871867)
,p_name=>'CA.DISTINCT .USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rios Distintos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283598074424871877)
,p_name=>'CA.DOWNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>'Fazer Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283604977778871882)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Arrastar para reordenar a p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282491452232871142)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
'  <li><strong>Link de Drill-down</strong> - Expanda para ver atributos para definir um link de drill-down.',
'&nbsp;<br>',
unistr('    <em><strong>Observa\00E7\00E3o:</strong> O Link de Drill-down s\00F3 aparecer\00E1 se a p\00E1gina atual se basear em uma tabela ou view e for do tipo Relat\00F3rio Interativo, e voc\00EA tiver definido uma p\00E1gina de relat\00F3rio (Relat\00F3rio Interativo) ou de detalhe mestre (De')
||'talhe Mestre).</em>',
'  <ul>',
unistr('    <li><strong>Coluna de Link</strong> - Selecione a coluna a ser alterada para uma coluna de link no relat\00F3rio.</li>'),
unistr('    <li><strong>Chave de Link</strong> - Selecione a coluna de chave de link (chave externa) usada para identificar o registro espec\00EDfico na p\00E1gina ao qual est\00E1 sendo vinculado.</li>'),
unistr('    <li><strong>Link para a P\00E1gina</strong> - Selecione o relat\00F3rio ou p\00E1gina de form para a qual o link navegar\00E1.</li>'),
unistr('    <li><strong>Chave de Destino</strong> - Selecione a coluna de chave de destino (chave prim\00E1ria) na tabela na qual a p\00E1gina de relat\00F3rio se baseia e at\00E9 a qual o link navega.'),
'  </ul>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283583817016871866)
,p_name=>'CA.ELAPSED'
,p_message_language=>'pt-br'
,p_message_text=>'Decorrido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283566468345871854)
,p_name=>'CA.EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>'Estrutura de E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283614173827871889)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Endere\00E7os de E-mail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283624114267871899)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283566324738871854)
,p_name=>'CA.EMAIL.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Adicione a capacidade de configurar e enviar e-mails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283566588694871854)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Inclua a capacidade para enviar e-mails do seu aplicativo. Com o uso do modelo de e-mail de exemplo, envie e-mails de pesquisa profissionais aos usu\00E1rios. Os e-mails enviados s\00E3o registrados para que os administradores possam acompanhar a atividad')
||'e de e-mail.<br>',
'<p>Inclui os seguintes componentes:',
'<ul>',
unistr('<li>Sistema de modelo de E-mail HTML Extens\00EDvel </li>'),
'<li>Pacote PL/SQL para enviar e-mail por pacotes APEX</li>',
'<li>Registro de atividades de e-mail e status</li>',
'<li>IU Administrativa para gerenciar modelos</li>',
'<li>IU Administrativa para exibir logs de e-mail</li>',
'<li>IU Administrativa para enviar e-mails</li>',
'</ul>',
'</p>',
unistr('<p><em>Observa\00E7\00E3o: essa funcionalidade ser\00E1 ativada quando Feedback for selecionado</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283619849751871894)
,p_name=>'CA.EMAIL.FROM'
,p_message_language=>'pt-br'
,p_message_text=>'Remetente do E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283593966982871874)
,p_name=>'CA.EMAIL.LOG'
,p_message_language=>'pt-br'
,p_message_text=>'Log de E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283624723571871899)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Detalhes exigidos da defini\00E7\00E3o de e-mail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283624270282871899)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Endere\00E7o do Remetente n\00E3o \00E9 um e-mail v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283615731649871890)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Endere\00E7o do Remetente n\00E3o \00E9 um e-mail v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283614936334871890)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_language=>'pt-br'
,p_message_text=>'E-mail processado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282570149226871194)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gera\00E7\00E3o de Relat\00F3rio de E-mail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282755941690871315)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio de todos os e-mails enfileirados a serem enviados e os que j\00E1 foram enviados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283594873784871875)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de E-mail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283595242429871875)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de e-mail atualizadas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283620298522871894)
,p_name=>'CA.EMAIL.STATUS'
,p_message_language=>'pt-br'
,p_message_text=>'Status do E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283595318430871875)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>'Detalhes do Modelo de E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283107077081871541)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Interrup\00E7\00E3o Programada para #SERVICE_NAME#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282808443104871348)
,p_name=>'CA.EMAIL2'
,p_message_language=>'pt-br'
,p_message_text=>'E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283593839372871874)
,p_name=>'CA.EMAILS.SENT'
,p_message_language=>'pt-br'
,p_message_text=>'E-mails Enviados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283624391696871899)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Ativar Anexos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282708216907871282)
,p_name=>'CA.ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>'Ativado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282705422109871280)
,p_name=>'CA.END.DATE'
,p_message_language=>'pt-br'
,p_message_text=>'Data Final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283595943181871875)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conte\00FAdo ap\00F3s as Linhas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283612013939871888)
,p_name=>'CA.ENTER.USERNAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Digite os nomes de usu\00E1rios aqui')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283584412145871867)
,p_name=>'CA.ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283586778983871868)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_language=>'pt-br'
,p_message_text=>'Rastreamento de Pilha de Erros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283586650339871868)
,p_name=>'CA.ERROR.CODE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00F3digo de Erro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283585948253871868)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Mensagem de Erro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282709957333871283)
,p_name=>'CA.ERROR.NUMBER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero do Erro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282708973468871282)
,p_name=>'CA.ERRORS'
,p_message_language=>'pt-br'
,p_message_text=>'Erros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282705806297871280)
,p_name=>'CA.EVENT.CONDITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Condi\00E7\00E3o do Evento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282705929534871280)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_language=>'pt-br'
,p_message_text=>'Agente da Fila do Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282706077041871281)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Fila do Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282706169174871281)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio da Fila do Evento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282705797003871280)
,p_name=>'CA.EVENT.RULE'
,p_message_language=>'pt-br'
,p_message_text=>'Regra de Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283612352464871888)
,p_name=>'CA.EXCEPTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exce\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283625232637871899)
,p_name=>'CA.EXPERIENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Experi\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282707945289871282)
,p_name=>'CA.FAILURE.COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem de Falhas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283582462120871865)
,p_name=>'CA.FEATURE'
,p_message_language=>'pt-br'
,p_message_text=>'Recurso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283362478367871714)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Vers\00E3o do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283362521383871715)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282854482516871378)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Usu\00E1rios \00E0 Lista de Controle de Acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282854224453871378)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ir para Pr\00F3xima Etapa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282854389650871378)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar Cole\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282854128810871378)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel alterar o \00FAltimo administrador')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283362140521871714)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltima Atividade')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282853978903871377)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhuma atividade encontrada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283362356509871714)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_language=>'pt-br'
,p_message_text=>'Motivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282854528160871378)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 Obrigat\00F3rio pelo Menos um Feedback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282854817026871378)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_language=>'pt-br'
,p_message_text=>'Obter ID do Arquivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282853497318871377)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_language=>'pt-br'
,p_message_text=>'Salvar Estilo do Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282853586052871377)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Salvar Prefer\00EAncia de Estilo do Usu\00E1rio Final')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283362255698871714)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283570627734871856)
,p_name=>'CA.FEATURES'
,p_message_language=>'pt-br'
,p_message_text=>'Funcionalidades'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283570742579871856)
,p_name=>'CA.FEATURES.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os recursos fornecem funcionalidades no n\00EDvel do aplicativo e s\00E3o tipicamente adicionados uma vez por aplicativo. Escolhe as funcionalidades a serem inclu\00EDdas no seu aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283564565748871852)
,p_name=>'CA.FEEDBACK'
,p_message_language=>'pt-br'
,p_message_text=>'Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283562536850871851)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Permitir que os usu\00E1rios forne\00E7am feedback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283564437463871852)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Fornece um mecanismo para que os usu\00E1rios finais postem coment\00E1rios gerais aos administradores e desenvolvedores do aplicativo. As postagens incluem informa\00E7\00F5es \00FAteis do estado da sess\00E3o para ajudar a determinar de onde o usu\00E1rio final enviou o fe')
||unistr('edback. Fornecer um loop de feedback f\00E1cil melhora a comunica\00E7\00E3o entre a comunidade de usu\00E1rios e os propriet\00E1rios do aplicativo, o que conduz a uma satisfa\00E7\00E3o muito maior por parte do usu\00E1rio final.</p>'),
'<p>Inclui os seguintes componentes:',
'<ul>',
unistr('<li>Capacidade dos usu\00E1rios finais de deixar feedback, clicando no \00EDcone da barra de navega\00E7\00E3o</li>'),
unistr('<li>Relat\00F3rio administrativo para exibir e atualizar feedback</li>'),
unistr('<li>O feedback capturar\00E1 as informa\00E7\00F5es de usu\00E1rio, data e hora e agente do usu\00E1rio</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283625621331871900)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Forne\00E7a feedback ou sua experi\00EAncia.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283624621970871899)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283624025199871898)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de Feedback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283591976667871872)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de feedback atualizadas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283624839245871899)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Feedback Enviado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282705525465871280)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Observador de Arquivos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282705690074871280)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio do Observador de Arquivos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282360724702871059)
,p_name=>'CA.FILED'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282360819575871059)
,p_name=>'CA.FILED.BY'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivado por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283620340776871894)
,p_name=>'CA.FILTER.REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio do Filtro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283596303321871876)
,p_name=>'CA.FILTERS'
,p_message_language=>'pt-br'
,p_message_text=>'Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283623080102871898)
,p_name=>'CA.FINISH'
,p_message_language=>'pt-br'
,p_message_text=>'Finalizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283590654973871871)
,p_name=>'CA.FIRST.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282702508238871278)
,p_name=>'CA.FLAGS'
,p_message_language=>'pt-br'
,p_message_text=>'Flags'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283572062971871857)
,p_name=>'CA.FORM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina de Form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283571971605871857)
,p_name=>'CA.FORM.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crie uma p\00E1gina que exiba uma p\00E1gina de form para permitir que os usu\00E1rios finais mantenham dados.</p>'),
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome da P\00E1gina</strong> (Obrigat\00F3rio) - Digite um nome para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone a ser exibido no menu de navega\00E7\00E3o desta p\00E1gina.</li>'),
unistr('  <li><strong>Tabela</strong> (Obrigat\00F3rio) - Selecione a tabela para o form.</li>'),
unistr('<li><strong>Incluir Relat\00F3rio</strong> (Obrigat\00F3rio) - Selecione esta op\00E7\00E3o para criar um relat\00F3rio e um form. A primeira p\00E1gina \00E9 um relat\00F3rio interativo. Cada linha fornece um link para um form no qual os usu\00E1rios podem atualizar o registro. </li>'),
'  &nbsp;<br>',
unistr('<li><strong>Avan\00E7ado</strong> - Expanda para ver op\00E7\00F5es avan\00E7adas.'),
'     <ul>',
unistr('      <li><strong>Ajuda da P\00E1gina</strong> - Digite o texto a ser adicionado ao Texto de Ajuda da p\00E1gina.</li>'),
'      </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282490470787871142)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rea de Itens do Form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283598281474871877)
,p_name=>'CA.FORM.ON'
,p_message_language=>'pt-br'
,p_message_text=>'Form em %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283611807941871887)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O tipo de form n\00E3o \00E9 v\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283618289495871892)
,p_name=>'CA.FORMATMASK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1scara de Formato')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283617227234871892)
,p_name=>'CA.FORMCONTROL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Controle de Formul\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283581847900871865)
,p_name=>'CA.FROM'
,p_message_language=>'pt-br'
,p_message_text=>'De'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283595068804871875)
,p_name=>'CA.FROM.ADDRESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Endere\00E7o do Remetente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283619746412871894)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00E3o do "Endere\00E7o do Remetente" do E-mail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283615626899871890)
,p_name=>'CA.FROM.EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>'E-mail do Remetente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283615509219871890)
,p_name=>'CA.FROM.WHO'
,p_message_language=>'pt-br'
,p_message_text=>'De quem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283364340844871716)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisa 0%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283585310580871867)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Visualiza\00E7\00F5es de P\00E1gina Inteira')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283594073294871874)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_language=>'pt-br'
,p_message_text=>'HTML de Modelo Completo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283616715414871891)
,p_name=>'CA.FUNCTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283564977051871853)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisa Global'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283562767238871851)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Fornecer recursos de pesquisa do aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283564843719871852)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite que os usu\00E1rios finais procurem texto em tabelas ou views da chave dentro do aplicativo. A p\00E1gina avan\00E7ada de pesquisa inclui filtros para simplificar a restri\00E7\00E3o de resultados para os usu\00E1rios finais.<br>'),
unistr('Esta funcionalidade muito avan\00E7ada n\00E3o requer esfor\00E7o de desenvolvimento para definir a SQL (com base nos exemplos fornecidos).</p>'),
'<p>Inclui os seguintes componentes:',
'<ul>',
unistr('<li>Exibe um \00EDcone de pesquisa na barra do cabe\00E7alho</li>'),
unistr('<li>Inclui uma p\00E1gina de resultados de pesquisa com filtro da barra lateral</li>'),
'<li>Requer que o desenvolvedor implemente a SQL para definir a pesquisa do Aplicativo</li>',
unistr('<li>Inclui dados de amostra para ilustra\00E7\00E3o</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282707269614871281)
,p_name=>'CA.GLOBAL.UID'
,p_message_language=>'pt-br'
,p_message_text=>'ID Exclusivo Global'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282853020463871377)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina Global - Desktop')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282470292403871128)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ir para a P\00E1gina de Administra\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283571579552871857)
,p_name=>'CA.GRID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina de Grade Interativa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283571607169871857)
,p_name=>'CA.GRID.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crie uma p\00E1gina que exibe uma grade interativa, que \00E9 semelhante a uma planilha que permite que v\00E1rias linhas sejam editadas diretamente na p\00E1gina (quando a op\00E7\00E3o Permitir Edi\00E7\00E3o estiver ativada).</p>'),
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome da P\00E1gina</strong> (Obrigat\00F3rio) - Informe um nome para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone para exibir no menu de navega\00E7\00E3o desta p\00E1gina.</li>'),
unistr('  <li><strong>Tipo de Consulta</strong> - Selecione a origem do relat\00F3rio [<strong>Tabela ou View</strong> ou <strong>Consulta SQL</strong>].<br>'),
'    <strong>Tabela ou View</strong>:',
'    <ul>',
unistr('      <li><strong>Tabela ou View</strong> (Obrigat\00F3rio) - Selecione o objeto do banco de dados da grade.</li>'),
'    </ul>',
'    <strong>Consulta SQL</strong>:',
'    <ul>',
unistr('      <li><strong>Consulta SQL</strong> (Obrigat\00F3ria) - Informe uma instru\00E7\00E3o SQL v\00E1lida que retorne colunas distintas.</li>'),
'    </ul>',
unistr('  <li><strong>Tipo de Grade</strong> - Selecione se os usu\00E1rios finais podem editar as linhas na grade [<strong>Permitir Edi\00E7\00E3o</strong> ou <strong>Somente para Leitura</strong>].</li>'),
unistr('Para ativar a edi\00E7\00E3o, selecione <strong>Permitir Edi\00E7\00E3o</strong>.</li>'),
'  &nbsp;<br>',
unistr('<em><strong>Advert\00EAncia:</strong> Se voc\00EA selecionar um Tipo de Consulta de <strong>Consulta SQL</strong> mais um Tipo de Grade de <strong>Permitir Edi\00E7\00E3o</strong> e sua consulta juntar duas ou mais tabelas, a grade interativa gerada falhar\00E1 quando o')
||unistr('s usu\00E1rios tentarem atualizar os registros.'),
unistr('Al\00E9m disso, se voc\00EA selecionar o Tipo de Grade de <strong>Permitir Edi\00E7\00E3o</strong> e a consulta (ou Tabela ou View selecionada) usar uma exibi\00E7\00E3o que n\00E3o \00E9 atualiz\00E1vel, ent\00E3o a Grade Interativa gerada falhar\00E1 quando os usu\00E1rios tentarem atualizar os ')
||'registros.</em><br>',
'  </li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283596835141871876)
,p_name=>'CA.HELP'
,p_message_language=>'pt-br'
,p_message_text=>'Ajuda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283589294986871870)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Escolha <strong>N\00E3o</strong> se todos os usu\00E1rios forem definidos na lista de controle de acesso. Escolha <strong>Sim</strong> se os usu\00E1rios autenticados que n\00E3o estiverem na lista de controle de acesso tamb\00E9m puderem usar este aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283582946186871865)
,p_name=>'CA.HELP.APP.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O texto informado aqui \00E9 usado por todo o aplicativo, mais notavelmente, no canto superior esquerdo de cada p\00E1gina. A altera\00E7\00E3o ter\00E1 efeito imediatamente para o administrador que faz a altera\00E7\00E3o, mas os outros usu\00E1rios s\00F3 ver\00E3o a altera\00E7\00E3o quando ini')
||unistr('ciarem uma nova sess\00E3o (por exemplo, no pr\00F3ximo log-in).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283577576398871861)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Clique no \00EDcone de feedback ( <span class="fa fa-comment-o" aria-hidden="true"></span> ) na barra de navega\00E7\00E3o, em qualquer p\00E1gina do aplicativo, para deixar feedback para os administradores do aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283577259611871861)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Esta \00E9 a home page do aplicativo. Clique nos cart\00F5es para acessar diferentes p\00E1ginas do aplicativo ou use o menu de navega\00E7\00E3o na lateral da p\00E1gina.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283577494747871861)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Esta \00E9 a home page do aplicativo. Clique nos cart\00F5es para acessar diferentes p\00E1ginas do aplicativo ou use o menu de navega\00E7\00E3o na parte superior da p\00E1gina.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283577679360871861)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Informe um termo de pesquisa no campo <strong>Pesquisar Aplicativo</strong> nesta p\00E1gina ou clique no \00EDcone de pesquisa ( <span class="fa fa-search" aria-hidden="true"></span> ) na barra de navega\00E7\00E3o de qualquer p\00E1gina para procurar o termo dentro')
||' do aplicativo.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283577905331871861)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Clique na lista suspensa do nome na barra de navega\00E7\00E3o para sair do aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283577871696871861)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Clique no menu do usu\00E1rio ( <span class="fa fa-user" aria-hidden="true"></span> ) na barra de navega\00E7\00E3o para atualizar sua prefer\00EAncia de fuso hor\00E1rio e sair do aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283577390796871861)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Home Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283578053404871861)
,p_name=>'CA.HELP.HOME.USER'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Clique no menu do usu\00E1rio ( <span class="fa fa-user" aria-hidden="true"></span> ) na barra de navega\00E7\00E3o (parte superior direita da p\00E1gina) para acessar o perfil do usu\00E1rio e sair do aplicativo.<br>'),
unistr('Se voc\00EA clicar em <strong>Exibir Meu Perfil</strong>, poder\00E1 clicar em <strong>Atualizar Perfil</strong> para inserir seus detalhes pessoais e fazer upload de uma foto ou avatar.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283577736809871861)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Clique no menu do usu\00E1rio ( <span class="fa fa-user" aria-hidden="true"></span> ) na barra de navega\00E7\00E3o para acessar seu perfil do usu\00E1rio, atualizar sua prefer\00EAncia de fuso hor\00E1rio e sair do aplicativo.<br>'),
unistr('Se voc\00EA clicar em <strong>Exibir Meu Perfil</strong>, poder\00E1 clicar em <strong>Atualizar Perfil</strong> para inserir seus detalhes pessoais e fazer upload de uma foto ou avatar.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283603846593871881)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para localizar os dados, digite um termo de pesquisa na caixa de di\00E1logo ou clique nos cabe\00E7alhos da coluna para limitar os registros retornados.</p>'),
'',
unistr('<p>Voc\00EA pode executar v\00E1rias fun\00E7\00F5es clicando no bot\00E3o <strong>A\00E7\00F5es</strong>. Isso inclui a sele\00E7\00E3o de colunas que s\00E3o exibidas/ocultas e sua sequ\00EAncia de exibi\00E7\00E3o, mais v\00E1rios dados e fun\00E7\00F5es de formato. Tamb\00E9m \00E9 poss\00EDvel definir uma exibi\00E7\00E3o adici')
||unistr('onal de dados usando a op\00E7\00E3o do gr\00E1fico.</p>'),
'',
unistr('<p>Se quiser salvar suas personaliza\00E7\00F5es, selecione relat\00F3rio ou clique em download para descarregar os dados.<p>'),
'<br>',
unistr('<p>Para obter informa\00E7\00F5es adicionais, clique em Ajuda na parte inferior do menu A\00E7\00F5es.</p>'),
'',
unistr('<p>Clique no bot\00E3o <strong>Redefinir</strong> para redefinir o relat\00F3rio interativo para as configura\00E7\00F5es padr\00E3o.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283603766116871881)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Voc\00EA pode inserir, atualizar e excluir dados diretamente dessa grade interativa.<br>'),
unistr('  Insira uma nova linha clicando no bot\00E3o Adicionar Linha.<br>'),
unistr('  Clique duas vezes em uma c\00E9lula ou clique no bot\00E3o <strong>Editar</strong> para atualizar valores de dados, como na edi\00E7\00E3o de dados em uma planilha.</p>'),
'',
unistr('<p>Use o menu A\00E7\00F5es da Linha ( <span class="fa fa-bars" aria-hidden="true"></span> ) na parte superior do relat\00F3rio para duplicar, excluir, atualizar ou reverter as linhas selecionadas.<br>'),
unistr('  Use o menu A\00E7\00F5es da Linha em linhas individuais para tamb\00E9m acessar a linha \00FAnica, exibir ou adicionar uma nova linha.</p>'),
'',
unistr('<p>Para localizar os dados, digite um termo de pesquisa na caixa de di\00E1logo ou clique nos cabe\00E7alhos das colunas para limitar os registros retornados.</p>'),
'',
unistr('<p>Voc\00EA pode executar v\00E1rias fun\00E7\00F5es clicando no bot\00E3o <strong>A\00E7\00F5es</strong>. Isso inclui a sele\00E7\00E3o de colunas que s\00E3o exibidas/ocultadas e sua sequ\00EAncia de exibi\00E7\00E3o, mais v\00E1rios dados e fun\00E7\00F5es de formato. Tamb\00E9m \00E9 poss\00EDvel definir uma exibi\00E7\00E3o adi')
||unistr('cional dos dados usando a op\00E7\00E3o de gr\00E1fico.</p>'),
'',
unistr('<p>Se quiser salvar suas personaliza\00E7\00F5es, selecione o relat\00F3rio ou clique em download para descarregar os dados.<p>'),
'',
unistr('<p>Para obter informa\00E7\00F5es adicionais, clique em Ajuda na parte inferior do menu A\00E7\00F5es.</p>'),
'',
unistr('<p>Clique no bot\00E3o <strong>Redefinir</strong> para redefinir o relat\00F3rio interativo para as configura\00E7\00F5es padr\00E3o.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283577157527871861)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para localizar os dados, digite um termo de pesquisa na caixa de di\00E1logo ou clique nos cabe\00E7alhos da coluna para limitar os registros retornados.</p>'),
'',
unistr('<p>Voc\00EA pode executar v\00E1rias fun\00E7\00F5es clicando no bot\00E3o <strong>A\00E7\00F5es</strong>. Isso inclui a sele\00E7\00E3o de colunas que s\00E3o exibidas/ocultas e sua sequ\00EAncia de exibi\00E7\00E3o, mais v\00E1rios dados e fun\00E7\00F5es de formato. Tamb\00E9m \00E9 poss\00EDvel definir views adicionais d')
||unistr('e dados usando a op\00E7\00E3o do gr\00E1fico, agrupar por e tabela din\00E2mica.</p>'),
'',
unistr('<p>Se quiser salvar suas personaliza\00E7\00F5es, selecione o relat\00F3rio ou clique em download para descarregar os dados. Informe seu endere\00E7o de e-mail e per\00EDodo de assinatura para que os dados sejam enviados regularmente.<p>'),
'',
unistr('<p>Para obter informa\00E7\00F5es adicionais, clique em Ajuda na parte inferior do menu A\00E7\00F5es.</p>'),
'',
unistr('<p>Clique no bot\00E3o <strong>Redefinir</strong> para redefinir o relat\00F3rio interativo para as configura\00E7\00F5es padr\00E3o.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283612816565871888)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta p\00E1gina de relat\00F3rio exibe os principais registros em um seletor no lado da p\00E1gina. '),
'  Selecione um registro para ver o registro mestre e todos os registros detalhados definidos.<br> ',
unistr('  Clique no \00EDcone de edi\00E7\00E3o ( <span class="fa fa-pencil-square-o" aria-hidden="true"></span> ) para editar o registro mestre.'),
unistr('  Para registros detalhados, clique no l\00E1pis, no in\00EDcio de cada linha, para editar esse registro.</p>'),
unistr('<p>Para limitar os dados exibidos no seletor, digite um termo de pesquisa na caixa de di\00E1logo de pesquisa.</p>'),
unistr('<p>Para adicionar um novo registro mestre, clique em <strong>Criar</strong> na parte superior da p\00E1gina.'),
unistr('  Para registros detalhados, clique no \00EDcone de mais ( + ) na parte superior da regi\00E3o de detalhes para adicionar um registro detalhado.</p>'),
'',
unistr('<p>Clique em <strong>Redefinir</strong> na parte superior da p\00E1gina para redefinir a p\00E1gina novamente \00E0s defini\00E7\00F5es padr\00E3o, removendo qualquer termo de pesquisa e filtros anteriormente definidos.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283575165384871859)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>A p\00E1gina de administra\00E7\00E3o permite que os propriet\00E1rios do aplicativo (Administradores) configurem o aplicativo e mantenham os dados comuns usados pelo aplicativo.'),
unistr('Selecionando uma das defini\00E7\00F5es dispon\00EDveis, os administradores podem alterar muito a forma pela qual o aplicativo \00E9 exibido e/ou as funcionalidades dispon\00EDveis para os usu\00E1rios finais.</p>'),
unistr('<p>O acesso a esta p\00E1gina deve ser limitado somente aos Administradores.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283576332804871860)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Selecione a op\00E7\00E3o apropriada para quaisquer usu\00E1rios autenticados.<br>'),
unistr('Selecionar <strong>N\00E3o</strong> torna o aplicativo mais seguro, pois somente os usu\00E1rios especificados podem acessar o aplicativo.'),
unistr('Por\00E9m, se seu aplicativo tiver uma comunidade de usu\00E1rios maior, ent\00E3o manter os usu\00E1rios pode implicar em gastos e talvez voc\00EA prefira escolher <strong>Sim</strong> e s\00F3 inserir Administradores do aplicativo e, possivelmente, Colaboradores.<br>'),
unistr('Se voc\00EA selecionar <strong>Sim</strong>, ent\00E3o tamb\00E9m dever\00E1 selecionar quantos usu\00E1rios n\00E3o inclu\00EDdos na lista de usu\00E1rios ser\00E3o tratados.</p>'),
unistr('<p>Selecione entre endere\00E7os de e-mail necess\00E1rios e qualquer valor alfanum\00E9rico para Nomes de usu\00E1rios.<br>'),
unistr('Geralmente, voc\00EA deve estabelecer esta defini\00E7\00E3o como <strong>Endere\00E7o de E-mail</strong> se seu aplicativo usar (ou for configurado para usar) um esquema de autentica\00E7\00E3o centralizado, como Oracle Access Manager ou SSO.</p>'),
unistr('<p><em><strong>Observa\00E7\00E3o:</strong> Este aplicativo suporta os seguintes 3 n\00EDveis de acesso: Leitor, Colaborador e Administrador.'),
'<ul>',
unistr('  <li><strong>Leitores</strong> t\00EAm acesso somente para leitura a todas as informa\00E7\00F5es e tamb\00E9m podem exibir relat\00F3rios.</li>'),
unistr('  <li><strong>Colaboradores</strong> podem criar, editar e excluir informa\00E7\00F5es e exibir relat\00F3rios.</li>'),
unistr('  <li><strong>Administradores</strong> al\00E9m do recurso de Colaboradores, tamb\00E9m podem executar a configura\00E7\00E3o do aplicativo, acessando a se\00E7\00E3o Administra\00E7\00E3o do aplicativo.</li>'),
'</ul>',
'</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283576560765871860)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use este form para inserir usu\00E1rios, seus endere\00E7os de e-mail e definir seu n\00EDvel de acesso.'),
unistr('As defini\00E7\00F5es estabelecidas em <em>Configurar Controle de Acesso</em> determinar\00E3o se o nome de usu\00E1rio deve ser o endere\00E7o de e-mail ou se pode ser qualquer entrada alfanum\00E9rica.</p>'),
unistr('<p>Este aplicativo suporta os seguintes 3 n\00EDveis de acesso: Leitor, Colaborador e Administrador.</p>'),
'<ul>',
unistr('  <li><strong>Leitores</strong> t\00EAm acesso somente para leitura a todas as informa\00E7\00F5es e tamb\00E9m podem exibir relat\00F3rios.</li>'),
unistr('  <li><strong>Colaboradores</strong> podem criar, editar e excluir informa\00E7\00F5es e exibir relat\00F3rios.</li>'),
unistr('  <li><strong>Administradores</strong>, al\00E9m do recurso de Colaboradores, tamb\00E9m podem executar configura\00E7\00E3o do aplicativo, acessando a se\00E7\00E3o Administra\00E7\00E3o do aplicativo.</li>'),
'</ul>',
unistr('<p>Ao editar um usu\00E1rio existente, voc\00EA pode bloquear sua conta, o que impedir\00E1 que ele acesse o aplicativo.</p>'),
unistr('<p><em><strong>Observa\00E7\00E3o:</strong> Se usar as contas do Oracle Application Express, ent\00E3o os usu\00E1rios inseridos aqui tamb\00E9m devem ser definidos como usu\00E1rios finais por um Administrador do Espa\00E7o de Trabalho que tamb\00E9m pode definir as senhas dos usu')
||unistr('\00E1rios.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283576420613871860)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta p\00E1gina mostra um relat\00F3rio de usu\00E1rios do aplicativo e o n\00EDvel de acesso concedido.</p>'),
unistr('<p>Clique nos cabe\00E7alhos da coluna para classificar e filtrar os dados ou clique no bot\00E3o <strong>A\00E7\00F5es</strong> para personalizar a exibi\00E7\00E3o da coluna e muitas funcionalidades avan\00E7adas adicionais.<br>'),
unistr('Clique no bot\00E3o <strong>Redefinir</strong> para redefinir o relat\00F3rio interativo de volta \00E0s defini\00E7\00F5es padr\00E3o.</p>'),
unistr('<p>Clique no \00EDcone de edi\00E7\00E3o (l\00E1pis amarelo) para editar os detalhes do usu\00E1rio e o n\00EDvel de acesso ou para excluir o usu\00E1rio.</p>'),
unistr('<p>Clique em <strong>Adicionar Usu\00E1rio</strong>, na parte superior do relat\00F3rio, para adicionar um novo usu\00E1rio e seu n\00EDvel de acesso.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283589935218871871)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Quando o Controle de Acesso \00E9 ativado, os Administradores t\00EAm a capacidade de restringir o acesso a determinadas funcionalidades do aplicativo para usu\00E1rios autenticados. Este aplicativo suporta os seguintes 3 n\00EDveis de acesso: Leitor, Colaborador')
||' e Administrador.<p>',
'<ul>',
unistr('  <li><strong>Leitores</strong> t\00EAm acesso somente para leitura a todas as informa\00E7\00F5es e tamb\00E9m podem exibir relat\00F3rios.</li>'),
unistr('  <li><strong>Colaboradores</strong> podem criar, editar e excluir informa\00E7\00F5es e exibir relat\00F3rios.</li>'),
unistr('  <li><strong>Administradores</strong>,al\00E9m da capacidade de Colaboradores, tamb\00E9m podem executar a configura\00E7\00E3o do aplicativo.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283611907497871888)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Digite os nomes de usu\00E1rios separados por v\00EDrgulas, pontos e v\00EDrgulas ou espa\00E7o em branco. Os nomes de usu\00E1rio existentes ou duplicados ser\00E3o automaticamente ignorados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283575388945871860)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>As defini\00E7\00F5es da configura\00E7\00E3o permitem que voc\00EA torne a funcionalidade espec\00EDfica dispon\00EDvel (ativada) ou indispon\00EDvel (desativada) para os usu\00E1rios finais.</p>'),
unistr('<p>Se uma fun\00E7\00E3o espec\00EDfica n\00E3o estiver 100% pronta ou precisar ser removida temporariamente, clique em <strong>Desativada</strong>.'),
unistr('Depois que ela ficar dispon\00EDvel, basta clicar em <strong>Ativada</strong>.</p>'),
unistr('<p><em><strong>Observa\00E7\00F5es:</strong> As altera\00E7\00F5es feitas aqui n\00E3o ser\00E3o refletidas para os usu\00E1rios individuais que no momento executam o aplicativo. Depois que o usu\00E1rio final sair do sistema e entrar novamente, as defini\00E7\00F5es da funcionalidade revi')
||unistr('sadas ser\00E3o chamadas.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283575487285871860)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Selecione o esquema de cor padr\00E3o usado para exibir o aplicativo.</p>'),
unistr('<p>Se a op\00E7\00E3o <strong>Permitir Que os Usu\00E1rios Finais escolham o Estilo do Tema</strong> estiver marcada, ent\00E3o cada usu\00E1rio final pode selecionar os estilos de tema dispon\00EDveis, clicando no link <em>Personalizar</em> no canto inferior esquerdo da Ho')
||'me page.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283576078839871860)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta p\00E1gina fornece um relat\00F3rio interativo de todos os erros inesperados registrados por este aplicativo.</p>'),
unistr('<p>Clique nos cabe\00E7alhos da coluna para classificar e filtrar os dados ou clique no bot\00E3o <strong>A\00E7\00F5es</strong> para personalizar a exibi\00E7\00E3o da coluna e muitas funcionalidades adicionais avan\00E7adas. Clique no bot\00E3o <strong>Redefinir</strong> para red')
||unistr('efinir o relat\00F3rio interativo de volta \00E0s defini\00E7\00F5es padr\00E3o.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283575952354871860)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Use este relat\00F3rio e gr\00E1fico para ver os usu\00E1rios com mais visualiza\00E7\00F5es de p\00E1gina no per\00EDodo especificado.</p>'),
unistr('<p>Selecione o per\00EDodo do relat\00F3rio (Padr\00E3o = 1 dia) e escolha entre os \00EDcones de relat\00F3rio e de gr\00E1fico na parte superior da p\00E1gina.</p>'),
unistr('<p>Para o relat\00F3rio interativo, use o campo de pesquisa ou selecione o cabe\00E7alho da coluna <strong>Usu\00E1rio</strong>, para selecionar um usu\00E1rio espec\00EDfico. \00C9 poss\00EDvel executar v\00E1rias fun\00E7\00F5es, clicando no bot\00E3o <strong>A\00E7\00F5es</strong>, tais como coluna')
||unistr('s exibidas/ocultas, linhas por p\00E1gina e assim por diante. Clique no bot\00E3o <strong>Redefinir</strong> para redefinir o relat\00F3rio interativo de volta \00E0s defini\00E7\00F5es padr\00E3o.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283576114068871860)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta p\00E1gina fornece um relat\00F3rio interativo do desempenho e popularidade da p\00E1gina. O relat\00F3rio \00E9 classificado por <strong>Desempenho Ponderado</strong> que \00E9 calculado multiplicando-se o tempo M\00E9dio Decorrido e o n\00FAmero de Visualiza\00E7\00F5es de P\00E1gina')
||'.</p>',
unistr('<p>Selecione o per\00EDodo do relat\00F3rio (Padr\00E3o = 1 dia) na parte superior da p\00E1gina, conforme necess\00E1rio.<br>'),
unistr('Clique nos cabe\00E7alhos da coluna para classificar e filtrar os dados ou clique no bot\00E3o <strong>A\00E7\00F5es</strong> para personalizar a exibi\00E7\00E3o da coluna e muitas funcionalidades adicionais avan\00E7adas. Clique no bot\00E3o <strong>Redefinir</strong> para redefi')
||unistr('nir o relat\00F3rio interativo de volta \00E0s defini\00E7\00F5es padr\00E3o.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283576293669871860)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta p\00E1gina fornece um relat\00F3rio interativo das visualiza\00E7\00F5es de p\00E1gina mais recentes.</p>'),
unistr('<p>Selecione o per\00EDodo do relat\00F3rio (Padr\00E3o = 1 dia) na parte superior da p\00E1gina, conforme necess\00E1rio.<br>'),
unistr('Clique nos cabe\00E7alhos da coluna para classificar e filtrar os dados ou clique no bot\00E3o <strong>A\00E7\00F5es</strong> para personalizar a exibi\00E7\00E3o da coluna e muitas funcionalidades adicionais avan\00E7adas. Clique no bot\00E3o <strong>Redefinir</strong> para redefi')
||unistr('nir o relat\00F3rio interativo de volta \00E0s defini\00E7\00F5es padr\00E3o.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283575202079871860)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>As notifica\00E7\00F5es s\00E3o exibidas na home page, quando estiverem ativas.</p>'),
unistr('<p>Este relat\00F3rio mostra as notifica\00E7\00F5es definidas e o per\00EDodo no qual elas s\00E3o exibidas.</p>'),
unistr('<p>Clique no \00EDcone de edi\00E7\00E3o (l\00E1pis amarelo) para editar uma notifica\00E7\00E3o existente ou clique em <strong>Adicionar Notifica\00E7\00E3o</strong> para inserir uma nova notifica\00E7\00E3o.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283575588554871860)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Informe o nome e a descri\00E7\00E3o curta do aplicativo.</p>'),
unistr('<p>O nome \00E9 exibido na home page; a descri\00E7\00E3o, abaixo do nome.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283575747619871860)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>O feedback pode ser inserido pelos usu\00E1rios finais em qualquer p\00E1gina normal dentro do aplicativo.</p>'),
unistr('<p>Este relat\00F3rio mostra o feedback informado, qualquer resposta inserida pelos administradores e o status do feedback.</p>'),
unistr('<p>Clique no \00EDcone de edi\00E7\00E3o (l\00E1pis amarelo) para inserir uma resposta ou atualizar o status do feedback.</p>'),
unistr('<p><em><strong>Observa\00E7\00E3o:</strong> Se os destinat\00E1rios de feedback forem definidos, ent\00E3o os envios de feedback tamb\00E9m ser\00E3o feitos por e-mail aos endere\00E7os de e-mail da lista de destinat\00E1rios de feedback.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283591853439871872)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Forne\00E7a uma lista separada por v\00EDrgulas de endere\00E7os de e-mail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283575839190871860)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p><strong>Ativar Anexos</strong> - Em caso afirmativo, os usu\00E1rios poder\00E3o fazer upload de um anexo em suporte a seu feedback.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283576813649871861)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta p\00E1gina lista os modelos de e-mail definidos e quantas vezes o modelo foi mencionado nos e-mails enviados.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283576655536871861)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta p\00E1gina lista os e-mails enviados.</p>'),
unistr('<p>Clique no \00EDcone de Lupa para exibir mais detalhes sobre os e-mails enviados.</p>'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283576791733871861)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Preencha os seguintes campos para definir um modelo de e-mail:</p>',
'<ul>',
unistr('  <li><strong>Nome do Modelo</strong> (Obrigat\00F3rio) - Digite um nome significativo para o modelo.</li>'),
unistr('  <li><strong>Modelo HTML</strong> (Obrigat\00F3rio) - Digite o c\00F3digo HTML usado para criar o e-mail enviado aos destinat\00E1rios que permitem a entrega de e-mails baseados em HTML.</li>'),
unistr('  <li><strong>Modelo de Texto sem Formata\00E7\00E3o</strong> (Obrigat\00F3rio) - Digite o texto sem formata\00E7\00E3o usado para criar o e-mail enviado aos destinat\00E1rios que n\00E3o aceitam e-mails baseados em HTML.'),
'    Os valores substitutos incluem:',
'    <ul>',
unistr('        <li><strong>#APP_NAME#</strong> - ser\00E1 substitu\00EDdo pelo nome do aplicativo</li>'),
unistr('        <li><strong>#BODY1#</strong> - ser\00E1 substitu\00EDdo pelo valor informado como p_body1_text</li> '),
unistr('        <li><strong>#TABLE#</strong> - ser\00E1 substitu\00EDdo pelo valor informado como p_table_content, usando HTML de Abertura da Tabela, HTML de Linha da Tabela e HTML de Fechamento da Tabela</li> '),
unistr('        <li><strong>#BODY2#</strong> - ser\00E1 substitu\00EDdo pelo valor informado como p_body2_text</li> '),
unistr('        <li><strong>#ACTION#</strong> - ser\00E1 substitu\00EDdo pelo valor informado como p_action_label e p_action_link, usando o modelo de Link de A\00E7\00E3o</li>'),
'     </ul></li>',
unistr('  <li><strong>Modelo de Texto Simples</strong> (Obrigat\00F3rio) - Digite o texto simples usado para criar o e-mail enviado aos destinat\00E1rios que n\00E3o aceitam e-mails baseados em HTML. Ele usa as mesmas substitui\00E7\00F5es que o Modelo HTML, exceto #TABLE# e #A')
||unistr('CTION#, que ser\00E3o renderizados como texto simples.</li>'),
'<ul>',
unistr('<p>Modelos HTML adicionais permitem e-mails mais avan\00E7ados. Esses itens incluem:</p>'),
'<ul>',
unistr('  <li><strong>Antes das Linhas</strong> - Informe HTML para substituir #TABLE# no Modelo HTML. S\00F3 ser\00E1 utilizado se p_table_content for informado.</li>'),
unistr('  <li><strong>Modelo de Linha</strong> - Informe HTML para renderizar cada linha da tabela. Isso inclui abertura/fechamento de linha e de dados usando as substitui\00E7\00F5es #LABEL# e #VALUE#. S\00F3 ser\00E1 utilizado se p_table_content for informado.</li>'),
unistr('  <li><strong>Ap\00F3s as Linhas</strong> - Informe HTML para fechar a tabela ou div. S\00F3 ser\00E1 utilizado se p_table_content for informado.</li>'),
unistr('  <li><strong>HTML de Link de A\00E7\00E3o</strong> - Informe o HTML para substituir #ACTION# no Modelo de HTML. Dever\00E1 conter #ACTION_LINK# e #ACTION_TEXT#. S\00F3 ser\00E1 utilizado se p_action_label e p_action_link forem informados.</li>'),
'</ul>',
unistr('<p><em><strong>Observa\00E7\00E3o:</strong> Use as entradas do <strong>modelo padr\00E3o</strong> como exemplo para desenvolver seu pr\00F3prio modelo. O modelo padr\00E3o usa todas as vari\00E1veis de substitui\00E7\00E3o que voc\00EA pode ou n\00E3o querer incluir em seu pr\00F3prio modelo d')
||'e e-mail.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283576903819871861)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Ative ou desative o envio de e-mails selecionando uma das op\00E7\00F5es de <strong>Despachar E-mails</strong>.</p>'),
unistr('<p>Informe <strong>E-mails Enviados de</strong> usando um endere\00E7o de e-mail do contato principal para problemas no aplicativo. Esse valor pode ser usado ou substitu\00EDdo ao utilizar a funcionalidade de e-mail.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283595144931871875)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este \00E9 o endere\00E7o do remetente que ser\00E1 usado para enviar e-mails. Ele pode ser substitu\00EDdo durante a utiliza\00E7\00E3o da funcionalidade de e-mail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283613525093871889)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Preencha os itens a seguir e clique em [Enviar E-mail]. Todos os e-mails enviados s\00E3o registrados no Log de E-mails.'),
'    <ul>',
unistr('        <li><strong>De</strong> - Se o "Endere\00E7o do Remetente" estiver configurado nas Defini\00E7\00F5es de E-mail, esse endere\00E7o ser\00E1 uma op\00E7\00E3o de origem de envio. Se esse aplicativo usar Endere\00E7os de E-mail como nome de usu\00E1rio, voc\00EA poder\00E1 selecionar o e')
||unistr('nvio de e-mails do seu endere\00E7o. Por \00FAltimo, voc\00EA sempre poder\00E1 definir ''Enviar de'' da mesma forma que ''Enviar para''.</li>'),
unistr('        <li><strong>Enviar para</strong> - Se esse aplicativo usar Endere\00E7os de E-mail como nome de usu\00E1rio, voc\00EA ter\00E1 a op\00E7\00E3o de selecionar o envio de e-mails para Endere\00E7os de E-mail e/ou Usu\00E1rios.</li>'),
unistr('        <li><strong>Endere\00E7os de E-mail</strong> - Lista de endere\00E7os de e-mail separados por v\00EDrgulas para receber o e-mail. Aqueles descobertos como inv\00E1lidos n\00E3o ser\00E3o inclu\00EDdos.</li>'),
unistr('        <li><strong>Atribui\00E7\00E3o</strong> - Envie um e-mail para todos os usu\00E1rios de uma atribui\00E7\00E3o selecionada ou a todos os usu\00E1rios definidos. A lista de sele\00E7\00E3o inclui uma lista de atribui\00E7\00F5es e a contagem de usu\00E1rios com essa atribui\00E7\00E3o.</li>'),
'        <li><strong>Modelo</strong> - Selecione o modelo de e-mail a ser usado para criar o corpo do e-mail.</li>',
'        <li><strong>Assunto</strong> - O assunto do e-mail.</li>',
unistr('        <li><strong>Corpo do E-mail</strong> - Texto a ser inclu\00EDdo como corpo do e-mail.</li>'),
unistr('        <li><strong>Permitir Recusa</strong> - Alguns e-mails dever\00E3o ser enviados independentemente de o usu\00E1rio optar pelo n\00E3o recebimento. Isso inclui mensagens de interrup\00E7\00E3o etc. Esse flag identifica se esse e-mail pode ser recusado ou se deve s')
||unistr('er enviado independentemente da prefer\00EAncia do usu\00E1rio.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283615289782871890)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Preencha os itens a seguir e clique em [Enviar E-mail]. Todos os e-mails enviados s\00E3o registrados no Log de E-mails.'),
'    <ul>',
unistr('        <li><strong>De</strong> - Se o "Endere\00E7o do Remetente" for configurado nas Defini\00E7\00F5es de E-mail, esse endere\00E7o ser\00E1 uma op\00E7\00E3o de origem de envio. Caso contr\00E1rio, voc\00EA sempre poder\00E1 definir ''Enviar de'' da mesma forma que ''Enviar para''.</li>'),
unistr('        <li><strong>Endere\00E7os de E-mail</strong> - Lista de endere\00E7os de e-mail separados por v\00EDrgulas para receber o e-mail. Aqueles descobertos como inv\00E1lidos n\00E3o ser\00E3o inclu\00EDdos.</li>'),
'        <li><strong>Modelo</strong> - Selecione o modelo de e-mail a ser usado para criar o corpo do e-mail.</li>',
'        <li><strong>Assunto</strong> - O assunto do e-mail.</li>',
unistr('        <li><strong>Corpo do E-mail</strong> - Texto a ser inclu\00EDdo como corpo do e-mail.</li>'),
unistr('        <li><strong>Permitir Recusa</strong> - Alguns e-mails dever\00E3o ser enviados independentemente de o usu\00E1rio optar pelo recebimento. Isso inclui mensagens de interrup\00E7\00E3o etc. Esse flag identifica se esse e-mail pode ser recusado ou se deve ser e')
||unistr('nviado independentemente da prefer\00EAncia do usu\00E1rio.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283575690282871860)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Selecione o fuso hor\00E1rio padr\00E3o para todos os usu\00E1rios deste aplicativo.</p>'),
unistr('<p>Os usu\00E1rios individuais podem substituir esta defini\00E7\00E3o, clicando no nome do usu\00E1rio (parte superior direita) e selecionando <strong>Prefer\00EAncias</strong>. Se preferir, eles podem clicar no link do fuso hor\00E1rio exibido na parte inferior da home pa')
||'ge.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283591553652871872)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esta p\00E1gina n\00E3o fica acess\00EDvel diretamente pela Interface do Usu\00E1rio. \00C9 usada para facilitar o download da foto de perfil.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283591210030871872)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A P\00E1gina de Perfil do Usu\00E1rio permite que voc\00EA veja informa\00E7\00F5es relevantes sobre um usu\00E1rio em uma tela f\00E1cil de usar.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283590927477871871)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fa\00E7a upload de uma foto com um aspecto quadrado; caso contr\00E1rio, ela poder\00E1 ser distorcida. O tamanho de imagem preferido \00E9 250x250 pixels.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283577024200871861)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Este form permite que voc\00EA atualize seus detalhes pessoais e fa\00E7a upload de uma foto ou avatar.</p>'),
unistr('<p>Para fazer upload de uma imagem, clique em <strong>Procurar</strong> ou arraste e solte a imagem acima do bot\00E3o.<br>'),
unistr('Fa\00E7a upload de uma foto com um aspecto quadrado, caso contr\00E1rio ela poder\00E1 ficar distorcida. O tamanho preferido da imagem \00E9 250x250 pixels.</p>'),
'<p>Clique em <strong>Excluir Foto</strong> para remover a imagem.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283597199210871876)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Todo texto de ajuda do aplicativo pode ser acessado nesta p\00E1gina. Os links da regi\00E3o "Documenta\00E7\00E3o" fornecem uma explica\00E7\00E3o mais detalhada das funcionalidades do aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283578104271871862)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 poss\00EDvel definir as prefer\00EAncias do aplicativo para sua conta nesta p\00E1gina. As prefer\00EAncias podem afetar v\00E1rios aspectos do aplicativo, como por exemplo, fuso hor\00E1rio. Clique nos \00EDcones de ajuda em n\00EDvel de item para saber o que cada prefer\00EAncia fa')
||'z.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282570283335871194)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Este relat\00F3rio mostra todos os e-mails enfileirados a serem enviados e os que j\00E1 foram enviados.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282702173068871278)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Este relat\00F3rio inclui todos os jobs selecionados para serem monitorados por este aplicativo. Mais detalhes de cada job podem ser vistos clicando-se no nome do job.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282708750511871282)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Este relat\00F3rio inclui os detalhes da execu\00E7\00E3o sobre os jobs selecionados para serem monitorados por este aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283562424041871851)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar p\00E1gina sobre este aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283578852360871862)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defina esta op\00E7\00E3o como N\00E3o, se n\00E3o quiser receber e-mails deste aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283613033489871888)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Digite um termo de pesquisa na caixa de di\00E1logo de pesquisa e clique em <strong>Pesquisar</strong>.<br>'),
unistr('Clique em qualquer um dos t\00EDtulos de resultados para navegar at\00E9 esse registro espec\00EDfico.</p>'),
unistr('<p>Para limitar a pesquisa, desmarque uma ou mais origens. Isso remover\00E1 o relat\00F3rio dos resultados da pesquisa.</p>'),
'<p>Clique em <strong>Redefinir</strong> para remover o termo de pesquisa e marque todas as Origens.</p> '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283578646944871862)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defina seu fuso hor\00E1rio preferido para usar por todo o aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282490749938871142)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>'Itens Ocultos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283598788048871877)
,p_name=>'CA.HOME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('In\00EDcio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283604854653871882)
,p_name=>'CA.HOME.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Home Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283621269383871895)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Eventos da P\00E1gina por Hora')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282569375094871193)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_language=>'pt-br'
,p_message_text=>'Tamanho do Corpo HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283595565502871875)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283592292716871872)
,p_name=>'CA.IN.PROGRESS'
,p_message_language=>'pt-br'
,p_message_text=>'Em Andamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283617460157871892)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_language=>'pt-br'
,p_message_text=>'Incluir nos Forms'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283617368301871892)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Incluir nos Relat\00F3rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283600988896871879)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_language=>'pt-br'
,p_message_text=>'Instalando scripts de objeto de suporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282702825469871278)
,p_name=>'CA.INSTANCE.ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ID da Inst\00E2ncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282704028768871279)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Perman\00EAncia na Inst\00E2ncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283574626535871859)
,p_name=>'CA.INTRO.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Bem-vindo a esta visualiza\00E7\00E3o somente em nuvem de uma forma nova e aprimorada de criar um aplicativo com funcionalidades mais completas. O Assistente de Cria\00E7\00E3o de Aplicativo padr\00E3o s\00F3 permite que voc\00EA selecione p\00E1ginas para gera\00E7\00E3o, enquanto este')
||unistr(' assistente tamb\00E9m permite que voc\00EA pr\00E9-carregue rapidamente v\00E1rias funcionalidades adicionais para seu aplicativo.</p>'),
unistr('<p>Os aplicativos gerados usando este assistente ser\00E3o totalmente suportados e tamb\00E9m podem ter Objetos de Suporte para funcionalidades selecionadas, como Controle de Acesso, Estrutura de E-mail, Feedback e muito mais.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283574826715871859)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Comece informando um nome de aplicativo. Em seguida, adicione uma ou mais p\00E1ginas ao seu aplicativo. Marque as funcionalidades que voc\00EA deseja incluir. Fa\00E7a escolhas em rela\00E7\00E3o \00E0 apar\00EAncia do aplicativo e, em seguida, verifique as defini\00E7\00F5es.<br>'),
'Pronto - Basta clicar em <strong>Criar Aplicativo</strong>.</p>',
unistr('<p>Clique em <strong>Exibir Blueprint</strong> para reutilizar o modelo de um aplicativo gerado anteriormente ou para replicar p\00E1ginas rapidamente.</p>'),
unistr('<p><em><strong>Observa\00E7\00E3o:</strong> Cada se\00E7\00E3o e cada ''Adicionar P\00E1gina'' inclui ajuda detalhada para auxiliar voc\00EA ainda mais.</em></p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283574785888871859)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Como Usar Este Assistente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283609438328871886)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta \00E9 uma lista de problemas significativos na fase de lan\00E7amento:'),
'<ol>',
unistr('  <li>O Assistente de Cria\00E7\00E3o de Aplicativo com base em Blueprint n\00E3o est\00E1 traduzido.</li>'),
unistr('  <li>Os aplicativos traduzidos gerados com esse assistente est\00E3o apenas parcialmente traduzidos.</li>'),
unistr('  <li>O Drill Down de Relat\00F3rio s\00F3 permite uma coluna de drill down.</li>'),
unistr('  <li>N\00E3o \00E9 poss\00EDvel gerar as p\00E1ginas de relat\00F3rio de filtro.</li>'),
unistr('  <li>A funcionalidade de e-mail fornece a API de n\00EDvel baixo, mas ainda n\00E3o inclui funcionalidades de e-mail de n\00EDvel mais alto.</li>'),
unistr('  <li>A gera\00E7\00E3o de um aplicativo com base em um Blueprint que faz refer\00EAncia a tabelas ausentes falhar\00E1 de forma anormal.</li>'),
unistr('  <li>Defini\00E7\00F5es Avan\00E7adas - Formatos de Data n\00E3o s\00E3o aplicados ao aplicativo gerado.</li>'),
'</ol>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283609354287871886)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Problemas Conhecidos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283575030216871859)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Lan\00E7ado em %0.</p>'),
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283574946224871859)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Detalhes da Release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283574524686871859)
,p_name=>'CA.INTRO.TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Assistente de Cria\00E7\00E3o de Aplicativo de um Projeto {Visualiza\00E7\00E3o Somente em Nuvem}')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283586125455871868)
,p_name=>'CA.IP.ADDRESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Endere\00E7o IP')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283584304082871866)
,p_name=>'CA.IR.SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisa de IR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283587315787871869)
,p_name=>'CA.IR.SEARCHES'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisas IR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283615831887871891)
,p_name=>'CA.ITEMNAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282706875894871281)
,p_name=>'CA.JOB.ACTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00E3o do Job')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282708389712871282)
,p_name=>'CA.JOB.CLASS'
,p_message_language=>'pt-br'
,p_message_text=>'Classe do Job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282707416273871281)
,p_name=>'CA.JOB.CREATOR'
,p_message_language=>'pt-br'
,p_message_text=>'Criador do Job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282708584878871282)
,p_name=>'CA.JOB.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282705051929871280)
,p_name=>'CA.JOB.PRIORITY'
,p_message_language=>'pt-br'
,p_message_text=>'Prioridade do Job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282702010881871278)
,p_name=>'CA.JOB.REPORTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rios de Jobs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282744611591871307)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir status e executar detalhes de jobs que suportam este aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282708673218871282)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Detalhes de Execu\00E7\00E3o do Job')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282707598784871282)
,p_name=>'CA.JOB.STYLE'
,p_message_language=>'pt-br'
,p_message_text=>'Estilo do Job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282707637966871282)
,p_name=>'CA.JOB.SUBNAME'
,p_message_language=>'pt-br'
,p_message_text=>'Subnome do Job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282706970174871281)
,p_name=>'CA.JOB.TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282703603488871279)
,p_name=>'CA.JOB.WEIGHT'
,p_message_language=>'pt-br'
,p_message_text=>'Peso do Job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283616324808871891)
,p_name=>'CA.KEYCOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna de Chaves'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283618193217871892)
,p_name=>'CA.LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283616602795871891)
,p_name=>'CA.LABELCOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna de Labels'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283618345050871893)
,p_name=>'CA.LABELPLURAL'
,p_message_language=>'pt-br'
,p_message_text=>'Label no Plural'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283618084822871892)
,p_name=>'CA.LABELSINGULAR'
,p_message_language=>'pt-br'
,p_message_text=>'Label no Singular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283573726998871858)
,p_name=>'CA.LANGUAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Idioma'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283573853683871859)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>'Selecione o idioma principal para este aplicativo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283608878377871885)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>O idioma principal \00E9 aquele usado para exibir as p\00E1ginas e os componentes gerados no App Builder. A sele\00E7\00E3o de diversas tradu\00E7\00F5es permitir\00E1 que os usu\00E1rios escolham qual idioma usar na renderiza\00E7\00E3o do aplicativo de runtime.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282853262104871377)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_language=>'pt-br'
,p_message_text=>'Seletor de Idioma'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283590785094871871)
,p_name=>'CA.LAST.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Sobrenome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282707778935871282)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dura\00E7\00E3o da \00DAltima Execu\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282707814173871282)
,p_name=>'CA.LAST.START.DATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00DAltima Data de In\00EDcio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283621695784871895)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_language=>'pt-br'
,p_message_text=>'Atividade Mais Recente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283617531046871892)
,p_name=>'CA.LISTOFVALUES'
,p_message_language=>'pt-br'
,p_message_text=>'Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283612929233871888)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_language=>'pt-br'
,p_message_text=>'Carregar Blueprint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282710182912871283)
,p_name=>'CA.LOG.DATE'
,p_message_language=>'pt-br'
,p_message_text=>'Data do Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282710306400871283)
,p_name=>'CA.LOG.ID'
,p_message_language=>'pt-br'
,p_message_text=>'ID do Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282704310833871279)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00EDvel de Log')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282491556297871142)
,p_name=>'CA.LOOKUP.COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Colunas de Lookup</strong> - Expanda para ver atributos para definir um lookup para outra tabela. Use Colunas de Lookup para substituir identificadores por uma coluna de exibi\00E7\00E3o, como mostrar o nome do departamento em vez do n\00FAmero.<br>'),
unistr('<em><strong>Observa\00E7\00E3o:</strong> As Colunas de Lookup s\00F3 aparecer\00E3o se a p\00E1gina atual se basear em uma tabela ou view e tenha restri\00E7\00F5es de chave externa para outra tabela.'),
'  <ul>',
unistr('    <li><strong>Chave de Lookup</strong> - Selecione a coluna a ser alterada para produzir a coluna de exibi\00E7\00E3o.</li>'),
unistr('    <li><strong>Coluna de Exibi\00E7\00E3o</strong> - Selecione a coluna (na tabela de lookup) a ser exibida.</li>'),
'    &nbsp;<br>',
unistr('    <em><strong>Observa\00E7\00E3o:</strong> S\00F3 selecione colunas que fa\00E7am refer\00EAncia a outra tabela (usando uma chave externa).</em></li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283594789764871874)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_language=>'pt-br'
,p_message_text=>'Gerenciar Modelos de E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283592726999871873)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_language=>'pt-br'
,p_message_text=>'Gerenciar Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283588830700871870)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gerenciar Acesso do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283622252965871897)
,p_name=>'CA.MASTER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina Detalhe/Mestre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283622390261871897)
,p_name=>'CA.MASTER.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crie uma p\00E1gina que exiba uma p\00E1gina detalhe/mestre para permitir que os usu\00E1rios finais vejam e mantenham dados.<br>'),
'&nbsp;</p>',
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome da P\00E1gina</strong> (Obrigat\00F3rio) - Informe um nome para essa p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone a ser exibido no menu de navega\00E7\00E3o dessa p\00E1gina.</li>'),
unistr('  <li><strong>Tipo de P\00E1gina</strong> - Selecione o tipo de p\00E1gina [Lado a Lado; Empilhada].<br>'),
'    <strong>Lado a Lado</strong>: <br>',
unistr('<em>Um detalhe/mestre de uma \00FAnica p\00E1gina que utiliza regi\00F5es de layout e relat\00F3rios lado a lado com janelas de edi\00E7\00E3o.</em>'),
'    <ul>',
unistr('     <li><strong>Tabela</strong> (Obrigat\00F3rio) - Selecione a tabela mestra da p\00E1gina.</li>'),
unistr('      <li><strong>Coluna de Exibi\00E7\00E3o Principal</strong> (Obrigat\00F3rio) - Selecione a coluna a ser exibida na lista de registros mestres.</li>'),
unistr('      <li><strong>Coluna de Exibi\00E7\00E3o Secund\00E1ria</strong> (Obrigat\00F3rio) - Selecione a coluna descritiva a ser exibida na lista de registros mestres, sob a Coluna de Exibi\00E7\00E3o Principal.</li>'),
unistr('      <li><strong>Tabela Detalhada 1</strong> (Obrigat\00F3rio) - Selecione a primeira tabela detalhada da p\00E1gina.</li>'),
unistr('      <li><strong>Tabela Detalhada 2</strong> - Selecione a segunda tabela detalhada da p\00E1gina.</li>'),
unistr('      <li><strong>Tabela Detalhada 3</strong> - Selecione a terceira tabela detalhada da p\00E1gina.</li>'),
unistr('      <li><strong>Tabela Detalhada 4</strong> - Selecione a quarta tabela detalhada da p\00E1gina.</li>'),
'    </ul>',
'    <strong>Empilhada</strong>: <br>',
unistr('<em>Um detalhe/mestre de uma \00FAnica p\00E1gina que utiliza Grades Interativas edit\00E1veis.</em>'),
'    <ul>',
unistr('      <li><strong>Tabela</strong> (Obrigat\00F3rio) - Selecione a tabela mestra da grade interativa edit\00E1vel.</li>'),
unistr('      <li><strong>Tabela Detalhada</strong> (Obrigat\00F3rio) - Selecione a tabela detalhada da p\00E1gina.</li>'),
unistr('      <em><strong>Observa\00E7\00E3o:</strong> Somente uma tabela detalhada (grade interativa edit\00E1vel) pode ser adicionada com o assistente. Tabelas detalhadas adicionais podem ser facilmente inclu\00EDdas ap\00F3s a gera\00E7\00E3o.</em>'),
'    </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282853129920871377)
,p_name=>'CA.MASTER_RECORDS'
,p_message_language=>'pt-br'
,p_message_text=>'Registros Mestres'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283585040189871867)
,p_name=>'CA.MAX.ELAPSED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1x. Decorrido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282704872597871280)
,p_name=>'CA.MAX.FAILURES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1ximo de Falhas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282704401233871279)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dura\00E7\00E3o M\00E1xima da Execu\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282704950650871280)
,p_name=>'CA.MAX.RUNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1ximo de Execu\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283616587450871891)
,p_name=>'CA.MAXIMUMROWS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1ximo de Linhas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283619553684871893)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Largura M\00E1xima')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283610192091871886)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283610584095871887)
,p_name=>'CA.MD.ADD.ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283610035753871886)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicar Filtros'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283610951838871887)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Valor de Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283611061122871887)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_language=>'pt-br'
,p_message_text=>'Valor de Data 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283610286578871886)
,p_name=>'CA.MD.EDIT'
,p_message_language=>'pt-br'
,p_message_text=>'Editar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283609648694871886)
,p_name=>'CA.MD.FILTER'
,p_message_language=>'pt-br'
,p_message_text=>'Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283609598259871886)
,p_name=>'CA.MD.FILTERS'
,p_message_language=>'pt-br'
,p_message_text=>'Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283610640600871887)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_language=>'pt-br'
,p_message_text=>'Sem Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283609910586871886)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum Registro Selecionado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283609850696871886)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum Registro Encontrado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283610413564871886)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 exclu\00EDdo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283610362603871886)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_language=>'pt-br'
,p_message_text=>'%0 atualizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283609704367871886)
,p_name=>'CA.MD.SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283610751428871887)
,p_name=>'CA.MD.VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283610880203871887)
,p_name=>'CA.MD.VALUE.2'
,p_message_language=>'pt-br'
,p_message_text=>'Valor 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283584552866871867)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_language=>'pt-br'
,p_message_text=>'Mediano Decorrido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283593684769871874)
,p_name=>'CA.MESSAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Mensagem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283619001186871893)
,p_name=>'CA.METRIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9trica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283585419436871867)
,p_name=>'CA.MIN.ELAPSED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00EDn. Decorrido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283588279962871869)
,p_name=>'CA.MOBILE.PHONE'
,p_message_language=>'pt-br'
,p_message_text=>'Telefone Celular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283584031653871866)
,p_name=>'CA.MODE'
,p_message_language=>'pt-br'
,p_message_text=>'Modo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283597815201871877)
,p_name=>'CA.MORE'
,p_message_language=>'pt-br'
,p_message_text=>'Mais'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283587402523871869)
,p_name=>'CA.MOST RECENT'
,p_message_language=>'pt-br'
,p_message_text=>'Most_Recent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283621420357871895)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1ginas Mais Ativas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282491684056871143)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('V\00E1rios Relat\00F3rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282491761985871143)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Marque uma ou mais nomes de tabela ou view. Como alternativa, clique na caixa de sele\00E7\00E3o no cabe\00E7alho para selecionar ou cancelar a sele\00E7\00E3o de todos os objetos de banco de dados listados.</p>'),
unistr('<p>Uma p\00E1gina com um relat\00F3rio interativo ser\00E1 adicionada para cada objeto de banco de dados marcado.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283581478597871864)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('#LABEL# deve ser um timestamp v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283618830298871893)
,p_name=>'CA.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283572937178871858)
,p_name=>'CA.NAVIGATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283573038174871858)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>'<p>Selecione se o menu deve ser exibido na lateral do aplicativo ou na parte superior do aplicativo.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283625503268871900)
,p_name=>'CA.NEGATIVE'
,p_message_language=>'pt-br'
,p_message_text=>'Negativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283625439502871900)
,p_name=>'CA.NEUTRAL'
,p_message_language=>'pt-br'
,p_message_text=>'Neutro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283611516274871887)
,p_name=>'CA.NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282704688584871280)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3xima Data de Execu\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282703598186871279)
,p_name=>'CA.NLS.ENV'
,p_message_language=>'pt-br'
,p_message_text=>'Ambiente NLS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282801381105871344)
,p_name=>'CA.NO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283592362671871873)
,p_name=>'CA.NO.ACTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sem A\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283603989242871881)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o h\00E1 ajuda dispon\00EDvel para esta p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282490825669871142)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o Existem Usu\00E1rios V\00E1lidos - Informa\00E7\00F5es da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283612566593871888)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nenhum novo usu\00E1rio v\00E1lido encontrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283608620134871885)
,p_name=>'CA.NONE'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283588544132871870)
,p_name=>'CA.NOTE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Observa\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283564014982871852)
,p_name=>'CA.NOTIFICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Notifica\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283562808111871851)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir notifica\00E7\00F5es na home page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283564167177871852)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite que os administradores do aplicativo especifiquem alertas (amarelo) ou erros (vermelho) que s\00E3o exibidos a todos os usu\00E1rios finais na home page do aplicativo. Esta funcionalidade \00E9 \00FAtil para transmitir informa\00E7\00F5es importantes para sua com')
||unistr('unidade de usu\00E1rios finais.</p>'),
'<p>Inclui os seguintes componentes:<ul>',
unistr('<li>Capacidade de definir notifica\00E7\00F5es</li>'),
unistr('<li>Exibi\00E7\00E3o de notifica\00E7\00E3o na home page do aplicativo</li>'),
unistr('<li>Capacidade de controlar a janela de tempo da exibi\00E7\00E3o da notifica\00E7\00E3o</li>'),
unistr('<li>Suporte \00E0 codifica\00E7\00E3o de cores das notifica\00E7\00F5es, por tipo</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283580736275871863)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283584286807871866)
,p_name=>'CA.NUM.ROWS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAm. de Linhas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282706704562871281)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero de Argumentos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282703300504871279)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero dos Destinos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283617055335871892)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1scara de Formato de N\00FAmero')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283585714227871868)
,p_name=>'CA.OCCURRENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ocorr\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283625707287871900)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA n\00E3o pode executar esta a\00E7\00E3o, a menos que haja outro administrador.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283592520872871873)
,p_name=>'CA.OPEN'
,p_message_language=>'pt-br'
,p_message_text=>'Abrir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283565572679871853)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Organizando P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283565879581871853)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Organize as p\00E1ginas na ordem em que deseja que elas apare\00E7am no seu aplicativo. <br>'),
unistr('Reordene as p\00E1ginas na lista clicando e mantendo pressionado o \00EDcone <em>Arrastar para reordenar a p\00E1gina</em> ( <span class="fa fa-bars" aria-hidden="true"></span> ) no fim de cada listagem de p\00E1gina e, em seguida, arraste e solte essa p\00E1gina para c')
||'ima ou para baixo.</p>',
unistr('<p>A home page sempre \00E9 exibida primeiro e n\00E3o pode ser reordenada..<br>'),
unistr('As p\00E1ginas administrativas s\00E3o sempre exibidas no final da lista e a ordem indicar\00E1 onde elas aparecem na lista Administra\00E7\00E3o de Aplicativos, na p\00E1gina Administra\00E7\00E3o.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282708843681871282)
,p_name=>'CA.OUTPUT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sa\00EDda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282710056350871283)
,p_name=>'CA.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283583982439871866)
,p_name=>'CA.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283587190130871869)
,p_name=>'CA.PAGE.EVENTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Eventos de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283599605416871878)
,p_name=>'CA.PAGE.HELP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ajuda da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283586230114871868)
,p_name=>'CA.PAGE.ITEM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Item de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282855155154871378)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Registro Mestre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282855312098871378)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Executar Pesquisa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283583554492871866)
,p_name=>'CA.PAGE.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283598910354871878)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navega\00E7\00E3o por P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283585635602871867)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Desempenho da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283611618722871887)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O tipo de p\00E1gina "%0" n\00E3o \00E9 v\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283584942886871867)
,p_name=>'CA.PAGE.VIEWS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Views de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283566046143871853)
,p_name=>'CA.PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283566124641871853)
,p_name=>'CA.PAGES.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Defina p\00E1gina(s) para incluir em seu aplicativo inicial. \00C9 necess\00E1rio definir pelo menos uma p\00E1gina antes de criar seu aplicativo.</p>'),
unistr('<p>Voc\00EA pode esbo\00E7ar seu aplicativo criando qualquer n\00FAmero de p\00E1ginas que usam este assistente. Depois que criar seu aplicativo, use o Assistente de Cria\00E7\00E3o de P\00E1gina para adicionar mais p\00E1ginas.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283616941452871891)
,p_name=>'CA.PAGINATIONMETHOD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9todo de Pagina\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283585258307871867)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Views Parciais da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283591035703871872)
,p_name=>'CA.PHOTO'
,p_message_language=>'pt-br'
,p_message_text=>'Foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283591673799871872)
,p_name=>'CA.PHOTO.DELETED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Foto exclu\00EDda.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283591147398871872)
,p_name=>'CA.PHOTO.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283590894883871871)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_language=>'pt-br'
,p_message_text=>'Upload de Foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283595628400871875)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo de Texto sem Formata\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283625323422871899)
,p_name=>'CA.POSITIVE'
,p_message_language=>'pt-br'
,p_message_text=>'Positivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283578466184871862)
,p_name=>'CA.PREFERENCES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prefer\00EAncias')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283622922952871898)
,p_name=>'CA.PREVIOUS'
,p_message_language=>'pt-br'
,p_message_text=>'Anterior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283617601754871892)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna de Exibi\00E7\00E3o Principal')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283618510690871893)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna da Chave Prim\00E1ria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283618698050871893)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tabela M\00E3e Prim\00E1ria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283585862588871868)
,p_name=>'CA.PROCEDURE'
,p_message_language=>'pt-br'
,p_message_text=>'Procedimento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283579074085871862)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prefer\00EAncia de e-mail atualizada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282854785378871378)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Extrair Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283580209964871863)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de Apar\00EAncia do Aplicativo Salvas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283578927596871862)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prefer\00EAncia de fuso hor\00E1rio atualizada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283591414370871872)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>'Download da Foto de Perfil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282707064877871281)
,p_name=>'CA.PROGRAM.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Programa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282707126093871281)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio do Programa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283617912892871892)
,p_name=>'CA.QUERY'
,p_message_language=>'pt-br'
,p_message_text=>'Consulta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282703842666871279)
,p_name=>'CA.RAISE.EVENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Gerar Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282335608514871043)
,p_name=>'CA.RATING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Classifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283589372751871870)
,p_name=>'CA.READERS'
,p_message_language=>'pt-br'
,p_message_text=>'Leitores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283578785467871862)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_language=>'pt-br'
,p_message_text=>'Receber E-mails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283621568858871895)
,p_name=>'CA.RECENT.ERRORS'
,p_message_language=>'pt-br'
,p_message_text=>'Erros Recentes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283361987361871714)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283362063072871714)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283580940953871864)
,p_name=>'CA.RED'
,p_message_language=>'pt-br'
,p_message_text=>'Vermelho'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283594596388871874)
,p_name=>'CA.REFERENCED'
,p_message_language=>'pt-br'
,p_message_text=>'Referenciado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282853860699871377)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atualizar P\00E1gina Admin')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282471293682871129)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atualizar ao Fechar a Caixa de Di\00E1logo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282855292304871378)
,p_name=>'CA.REFRESH_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atualizar Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283580490089871863)
,p_name=>'CA.REGION.BUTTONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regi\00E3o de Bot\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283580326013871863)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rea de Itens do Form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283586378768871868)
,p_name=>'CA.REGION.ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ID da Regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283598368718871877)
,p_name=>'CA.RELEASE'
,p_message_language=>'pt-br'
,p_message_text=>'Release %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283565622349871853)
,p_name=>'CA.REMOVING.PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Removendo P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283565730402871853)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Clique em <strong>Editar</strong> para selecionar a p\00E1gina; em seguida, clique em <strong>Excluir P\00E1gina</strong> para remover uma p\00E1gina de seu aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282708451610871282)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Intervalo de Repeti\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282569943694871194)
,p_name=>'CA.REPLY.TO'
,p_message_language=>'pt-br'
,p_message_text=>'Responder Para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283571490298871857)
,p_name=>'CA.REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina do Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283571336112871857)
,p_name=>'CA.REPORT.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crie uma p\00E1gina que seja exibida como relat\00F3rio interativo ou cl\00E1ssico.</p>'),
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome da P\00E1gina</strong> (Obrigat\00F3rio) - Digite um nome para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone a ser exibido no menu de navega\00E7\00E3o desta p\00E1gina.</li>'),
unistr('  <li><strong>Tipo de Consulta</strong> - Selecione a origem do relat\00F3rio [<strong>Tabela ou View</strong> ou <strong>Consulta SQL</strong>]:<br>'),
'    <strong>Tabela ou View</strong>:',
'    <ul>',
unistr('      <li>Tabela ou View (Obrigat\00F3rio) - Selecione o objeto do banco de dados para o relat\00F3rio.</li>'),
unistr('      <li>Incluir Form - Selecione para incluir uma p\00E1gina do form vinculada para permitir que os usu\00E1rios mantenham os valores de tabela.</li>'),
'    </ul>',
'    <strong>Consulta SQL</strong>:',
'    <ul>',
unistr('      <li>Consulta SQL (Obrigat\00F3rio) - Informe uma instru\00E7\00E3o SQL v\00E1lida que retorne colunas distintas.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>Tipo de Relat\00F3rio</strong> - Selecione o tipo de relat\00F3rio (<strong>Relat\00F3rio Interativo</strong> ou <strong>Relat\00F3rio Cl\00E1ssico</strong>).</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283563137074871851)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_language=>'pt-br'
,p_message_text=>'%0 com Form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283407930692871745)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283620696789871894)
,p_name=>'CA.REPORT.VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('View de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283619249104871893)
,p_name=>'CA.REPORTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282709881622871283)
,p_name=>'CA.REQ.START.DATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Data de In\00EDcio Solicitada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283619456812871893)
,p_name=>'CA.REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Obrigat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283596433461871876)
,p_name=>'CA.RESET'
,p_message_language=>'pt-br'
,p_message_text=>'Redefinir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283592454897871873)
,p_name=>'CA.RESOLVED'
,p_message_language=>'pt-br'
,p_message_text=>'Resolvido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283592189480871872)
,p_name=>'CA.RESPONSE'
,p_message_language=>'pt-br'
,p_message_text=>'Resposta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282705130668871280)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_language=>'pt-br'
,p_message_text=>'Reiniciar ao Falhar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282705210481871280)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_language=>'pt-br'
,p_message_text=>'Reiniciar ao Recuperar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282702425181871278)
,p_name=>'CA.RESTARTABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Reinicializ\00E1vel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282704776959871280)
,p_name=>'CA.RETRY.COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Cont. Tentativas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283614447878871890)
,p_name=>'CA.ROLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atribui\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283586577363871868)
,p_name=>'CA.ROW.NUMBER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero de Linhas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283595818788871875)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo de Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283613813106871889)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_language=>'pt-br'
,p_message_text=>'HTML de Modelo de Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283615171241871890)
,p_name=>'CA.ROWS.CONTENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conte\00FAdo de Linhas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283587204308871869)
,p_name=>'CA.ROWS.FETCHED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Linhas Extra\00EDdas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283616823559871891)
,p_name=>'CA.ROWSPERPAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Linhas Por P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282708019098871282)
,p_name=>'CA.RUN.COUNT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Contagem de Execu\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282709695590871283)
,p_name=>'CA.RUN.DURATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dura\00E7\00E3o da Execu\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282704573710871280)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Limite de Programa\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282706530519871281)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome da Programa\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282706657065871281)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio da Programa\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282706411564871281)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de Programa\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283573910587871859)
,p_name=>'CA.SCHEMA'
,p_message_language=>'pt-br'
,p_message_text=>'Esquema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283574075085871859)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Selecione o esquema do banco de dados que armazena os objetos do banco de dados que voc\00EA deseja usar neste aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283615980498871891)
,p_name=>'CA.SCOPE'
,p_message_language=>'pt-br'
,p_message_text=>'Escopo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283596590920871876)
,p_name=>'CA.SEARCH'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283596651190871876)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisar Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283596724396871876)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Caixa de Di\00E1logo Pesquisar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283620828177871894)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_language=>'pt-br'
,p_message_text=>'Filtros da Pesquisa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283603468445871881)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Esta p\00E1gina se baseia na Lista de Componentes Compartilhados chamada Tabelas Pesquisadas.'),
'',
unistr('Qualquer p\00E1gina do Relat\00F3rio Interativo gerada inicialmente no assistente de Cria\00E7\00E3o de Aplicativo ser\00E1 adicionada automaticamente \00E0 lista. '),
unistr('Para adicionar suas pr\00F3prias tabelas \00E0 lista, navegue para Componentes Compartilhados, selecione Listas e, em seguida, clique em Tabelas Pesquisadas.'),
'  Informe os seguintes atributos:',
unistr('    Entrada: Label de Entrada da Lista - informe o nome para exibi\00E7\00E3o da tabela.'),
unistr('    Destino: P\00E1gina - selecione a p\00E1gina apropriada at\00E9 a qual navegar (preferencialmente, um Relat\00F3rio Interativo)'),
unistr('    Destino: Limpar Cache - informe as p\00E1ginas que precisam ser removidas (geralmente, o mesmo n\00FAmero informado em P\00E1gina).'),
unistr('       Se estiver navegando at\00E9 uma p\00E1gina de Relat\00F3rio Interativo, adicione CIR, RIR para remover qualquer filtro existente e assim por diante.'),
unistr('    Destino: Definir estes itens - selecione (ou informe) o item apropriado da p\00E1gina que deve ser preenchido.'),
unistr('       Se estiver navegando at\00E9 uma p\00E1gina do Relat\00F3rio Interativo, informe IR_[COLUMN_NAME].'),
'    Destino: Com estes valores - informe =PK=',
unistr('    Atributos Definidos pelo Usu\00E1rio: 1 - informe o nome da tabela a ser pesquisado em letras mai\00FAsculas.'),
unistr('    Atributos Definidos pelo Usu\00E1rio: 2 - informe o nome da coluna principal em letras mai\00FAsculas.'),
unistr('    Atributos Definidos pelo Usu\00E1rio: 3 (Opcional) - lista de colunas separadas por v\00EDrgulas a serem pesquisadas.'),
unistr('       Se nenhuma coluna for especificada, todas as colunas de texto (varchar2) e objeto grande de caractere (clob) ser\00E3o pesquisadas.'),
'',
unistr('Observa\00E7\00E3o: Uma lista de tabelas dispon\00EDveis para pesquisa s\00F3 ser\00E1 exibida aos usu\00E1rios se mais de uma tabela for listada.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283596229522871876)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_language=>'pt-br'
,p_message_text=>'Resultados da Pesquisa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283618457823871893)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna de Exibi\00E7\00E3o Secund\00E1ria')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283592889928871873)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo Selecionado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282569250105871193)
,p_name=>'CA.SEND.BEGIN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('In\00EDcio do Envio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282569653701871194)
,p_name=>'CA.SEND.COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem de Envios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282569137806871193)
,p_name=>'CA.SEND.END'
,p_message_language=>'pt-br'
,p_message_text=>'Fim do Envio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282569597759871193)
,p_name=>'CA.SEND.ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro de Envio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283624447711871899)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar E-mails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283624525109871899)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_language=>'pt-br'
,p_message_text=>'Determina se os e-mails devem ser enviados quando um novo feedback for recebido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283621128672871895)
,p_name=>'CA.SEND.FROM'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283613619248871889)
,p_name=>'CA.SEND.TO'
,p_message_language=>'pt-br'
,p_message_text=>'Enviar para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283598130461871877)
,p_name=>'CA.SERIES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('S\00E9rie %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282709563449871283)
,p_name=>'CA.SESSION.ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ID da Sess\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283616130399871891)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prote\00E7\00E3o de Estado de Sess\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283573318287871858)
,p_name=>'CA.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283573470482871858)
,p_name=>'CA.SETTINGS.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Especifique as defini\00E7\00F5es usadas na gera\00E7\00E3o do aplicativo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283597777724871877)
,p_name=>'CA.SHOW.ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar Tudo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282470463950871128)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar/Ocultar Escopo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283598839729871878)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mostrar Fuso Hor\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283598638188871877)
,p_name=>'CA.SIGN.IN'
,p_message_language=>'pt-br'
,p_message_text=>'Acessar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283599803443871878)
,p_name=>'CA.SIGN.OUT'
,p_message_language=>'pt-br'
,p_message_text=>'Sair'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282709452021871283)
,p_name=>'CA.SLAVE.PID'
,p_message_language=>'pt-br'
,p_message_text=>'PID Escravo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282703408435871279)
,p_name=>'CA.SOURCE'
,p_message_language=>'pt-br'
,p_message_text=>'Origem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283611782798871887)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O tipo de origem n\00E3o \00E9 v\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283603506929871881)
,p_name=>'CA.SOURCES'
,p_message_language=>'pt-br'
,p_message_text=>'Origens'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282706360254871281)
,p_name=>'CA.START.DATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Data de In\00EDcio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282708180037871282)
,p_name=>'CA.STATE'
,p_message_language=>'pt-br'
,p_message_text=>'Estado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283619345174871893)
,p_name=>'CA.STATICDEFAULT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00E3o Est\00E1tico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283582551970871865)
,p_name=>'CA.STATUS'
,p_message_language=>'pt-br'
,p_message_text=>'Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282704149404871279)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_language=>'pt-br'
,p_message_text=>'Interromper Caso a Janela Seja Fechada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282704211418871279)
,p_name=>'CA.STORE.OUTPUT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sa\00EDda do Armazenamento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283593042269871873)
,p_name=>'CA.SUBJECT'
,p_message_language=>'pt-br'
,p_message_text=>'Assunto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283591749582871872)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_language=>'pt-br'
,p_message_text=>'Submeter Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283616470430871891)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Visualiza\00E7\00E3o Sugerida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283608381790871885)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_language=>'pt-br'
,p_message_text=>'Objetos de Suporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283608484439871885)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<p>Digite o c\00F3digo no script de instala\00E7\00E3o, geralmente para criar ou manipular objetos de banco de dados ou fazer inser\00E7\00F5es/atualiza\00E7\00F5es/exclus\00F5es nos registros existentes. Digite o c\00F3digo na desinstala\00E7\00E3o, geralmente para remover (eliminar) objetos ')
||unistr('de banco de dados. Esses scripts ser\00E3o incorporados nos Objetos de Suporte para que, quando voc\00EA exportar o aplicativo, ele fa\00E7a essas mesmas atualiza\00E7\00F5es nos ambientes de teste e produ\00E7\00E3o.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283608596981871885)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Digite instru\00E7\00F5es SQL e/ou PL/SQL v\00E1lidas no Script de Instala\00E7\00E3o que sejam executadas quando o aplicativo for importado.</p>'),
unistr('<p>Se voc\00EA quiser que essas instru\00E7\00F5es tamb\00E9m sejam executadas no ambiente atual e n\00E3o apenas quando o aplicativo for importado em outro ambiente, clique em <strong>Executar ao criar aplicativo</strong>.</p>'),
unistr('<p>Digite instru\00E7\00F5es SQL e/ou PL/SQL v\00E1lidas no Script de Desinstala\00E7\00E3o que sejam executadas quando o aplicativo for exclu\00EDdo do App Builder.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282703763975871279)
,p_name=>'CA.SYSTEM'
,p_message_language=>'pt-br'
,p_message_text=>'Sistema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283617823449871892)
,p_name=>'CA.TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283574108099871859)
,p_name=>'CA.TABLE.PREFIX'
,p_message_language=>'pt-br'
,p_message_text=>'Prefixo de Objeto da Estrutura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283574221641871859)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Informe um prefixo de objeto a ser usado pelo aplicativo. Algumas funcionalidades adicionam este prefixo aos objetos do banco de dados que elas criam (inclusive pacotes e tabelas).</p>',
unistr('<p>Advert\00EAncia: Certifique-se de informar um prefixo exclusivo que n\00E3o \00E9 usado por outros aplicativos. Se n\00E3o for exclusivo, o aplicativo pode gerar erros ao ser criado e n\00E3o funcionar corretamente.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283618786860871893)
,p_name=>'CA.TABLECOLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna da Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283613724072871889)
,p_name=>'CA.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283596196009871876)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este nome de modelo j\00E1 est\00E1 sendo utilizado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283592917952871873)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Modelo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283581621241871864)
,p_name=>'CA.TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282569464704871193)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_language=>'pt-br'
,p_message_text=>'Tamanho do Corpo do Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283594180504871874)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo de Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283579863559871863)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prefer\00EAncia de Tema do Usu\00E1rio Final')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283580080012871863)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Se essa op\00E7\00E3o for marcada, os usu\00E1rios finais poder\00E3o escolher seu pr\00F3prio Estilo do Tema usando o link Personalizar.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283579936338871863)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Permite que os Usu\00E1rios Finais escolham o Estilo do Tema')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283564269939871852)
,p_name=>'CA.THEME.SELECTOR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sele\00E7\00E3o de Estilo do Tema')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283562611343871851)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atualizar apar\00EAncia do aplicativo padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283564300715871852)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite que os administradores selecionem um esquema de cor padr\00E3o (estilo do tema) para o aplicativo. Os administradores tamb\00E9m podem optar por permitir que os usu\00E1rios finais escolham seu pr\00F3prio estilo de tema. Os usu\00E1rios finais podem simplesm')
||unistr('ente clicar no bot\00E3o <em>Personalizar</em> na parte inferior da home page e selecionar os estilos de tema dispon\00EDveis. Por exemplo, usu\00E1rios com defici\00EAncia visual talvez prefiram utilizar o estilo de tema do <em>Vista</em> que tem um contraste de co')
||'r muito maior.</p>',
'<p>Inclui os seguintes componentes:',
'<ul>',
unistr('<li>Permite que os administradores definam o estilo de tema padr\00E3o</li>'),
unistr('<li>Permite que os usu\00E1rios finais selecionem v\00E1rios estilos de tema</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283572750912871858)
,p_name=>'CA.THEME.STYLE'
,p_message_language=>'pt-br'
,p_message_text=>'Estilo do Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283572812617871858)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Selecione o estilo do tema padr\00E3o usado para exibir o aplicativo.</p>'),
unistr('<p>O estilo pode ser facilmente alterado para outro estilo predefinido, ou modificado ap\00F3s a gera\00E7\00E3o. Para alterar o estilo, execute o aplicativo e, em seguida, clique em <strong>Rolador do Tema</strong> na barra de ferramentas do Desenvolvedor.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283586800471871868)
,p_name=>'CA.TIME'
,p_message_language=>'pt-br'
,p_message_text=>'Hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283578575425871862)
,p_name=>'CA.TIME.ZONE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fuso Hor\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283565382063871853)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Suporte de Fuso Hor\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283562297834871851)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Definir fusos hor\00E1rios do usu\00E1rio e padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283565020632871853)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite que os usu\00E1rios finais definam seus fusos hor\00E1rios locais. Isso \00E9 importante se suas tabelas de aplicativo utilizam fuso hor\00E1rio com foco em tipos de data (como, por exemplo, Timestamp com Fuso Hor\00E1rio Local) de forma que os relat\00F3rios e a')
||unistr(' entrada de dados reflitam onde os usu\00E1rios finais est\00E3o localizados.</p>'),
'<p>Inclui os seguintes componentes:',
'<ul>',
unistr('<li>Permite que os administradores definam o fuso hor\00E1rio padr\00E3o</li>'),
unistr('<li>Permite que os usu\00E1rios finais selecionem a prefer\00EAncia do fuso hor\00E1rio</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283621783051871895)
,p_name=>'CA.TIMEFRAME'
,p_message_language=>'pt-br'
,p_message_text=>'Prazo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283622055135871895)
,p_name=>'CA.TIMELINE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar P\00E1gina de Linha do Tempo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283622181176871897)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crie uma p\00E1gina que exiba uma linha de tempo que seja especialmente \00FAtil para exibir atualiza\00E7\00F5es.</p>'),
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome da P\00E1gina</strong> (Obrigat\00F3rio) - Digite um nome para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone a ser exibido no menu de navega\00E7\00E3o desta p\00E1gina.</li>'),
unistr('  <li><strong>Tabela ou View</strong> (Obrigat\00F3rio) - Selecione o objeto de banco de dados para a linha de tempo.</li>'),
unistr('  <li><strong>Nome do Usu\00E1rio</strong> (Obrigat\00F3rio) - Selecione a coluna da tabela ou view a ser usada como o usu\00E1rio exibido para as entradas de linha do tempo.</li>'),
unistr('  <li><strong>Data</strong> (Obrigat\00F3rio) - Selecione a coluna na tabela ou view a ser usada como a data para as entradas de linha de tempo.</li>'),
unistr('  <li><strong>Nome do Evento</strong> (Obrigat\00F3rio) - Selecione a coluna da tabela ou view a ser usada como o t\00EDtulo para as entradas de linha de tempo.</li>'),
unistr('  <li><strong>Descri\00E7\00E3o</strong> - Selecione a coluna na tabela ou view a ser usada como a descri\00E7\00E3o para as entradas de linha de tempo.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283583769710871866)
,p_name=>'CA.TIMESTAMP'
,p_message_language=>'pt-br'
,p_message_text=>'Timestamp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283588306178871869)
,p_name=>'CA.TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282570036362871194)
,p_name=>'CA.TO'
,p_message_language=>'pt-br'
,p_message_text=>'Para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283587519719871869)
,p_name=>'CA.TOP.USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Principais Usu\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283587616212871869)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1fico de Principais Usu\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283585188781871867)
,p_name=>'CA.TOTAL.ROWS'
,p_message_language=>'pt-br'
,p_message_text=>'Total de Linhas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283589567666871870)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atribui\00E7\00E3o padr\00E3o para usu\00E1rios que n\00E3o est\00E3o na lista de controle de acesso:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283581761977871864)
,p_name=>'CA.TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282800632125871343)
,p_name=>'CA.UI.DEFAULTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00F5es da Interface do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282800725701871343)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Configura padr\00F5es para defini\00E7\00F5es de interface de usu\00E1rio, como linhas por p\00E1gina, e adiciona a lista de defini\00E7\00F5es de valores. Essas defini\00E7\00F5es s\00E3o usadas ao gerar componentes dentro do aplicativo. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283581995717871865)
,p_name=>'CA.UNTIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('At\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282853619833871377)
,p_name=>'CA.UPDATE'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283591381259871872)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar Perfil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283582280184871865)
,p_name=>'CA.UPDATED'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283582328819871865)
,p_name=>'CA.UPDATED.BY'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizado por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283583690813871866)
,p_name=>'CA.USER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283611250991871887)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Diversos Usu\00E1rios - Etapa 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283611318675871887)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Diversos Usu\00E1rios - Etapa 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283611407077871887)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Diversos Usu\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283586059270871868)
,p_name=>'CA.USER.AGENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Agente do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283599423673871878)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio de Contagens do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283587840235871869)
,p_name=>'CA.USER.NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283590379754871871)
,p_name=>'CA.USER.PROFILE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Perfil do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283565211368871853)
,p_name=>'CA.USER.PROFILES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Perfis de Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283562135510871851)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Permite que os usu\00E1rios atualizem seus perfis')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283565124473871853)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite que os usu\00E1rios finais especifiquem informa\00E7\00F5es adicionais sobre eles mesmos, incluindo uma foto ou avatar, para personalizar sua conta.</p>'),
'<p>Inclui os seguintes componentes:',
'<ul>',
unistr('<li>Defini\00E7\00E3o de p\00E1gina para usu\00E1rios finais definirem seus perfis</li>'),
'<li>Capacidade de fazer upload de foto ou avatar</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283590598793871871)
,p_name=>'CA.USERNAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283589618502871871)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Formato de nome de usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283612149582871888)
,p_name=>'CA.USERNAMES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nomes de Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282808366418871348)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Formato de Nome de Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283612728977871888)
,p_name=>'CA.USERS.ADDED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rio(s) adicionado(s).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283614239469871889)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rios por Atribui\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283593783810871874)
,p_name=>'CA.USERS.INCLUDED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rios Inclu\00EDdos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283612477310871888)
,p_name=>'CA.USERS.TO.ADD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rios a serem Adicionados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283589800623871871)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Formato de nome de usu\00E1rio atualizado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282490618082871142)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Existem Usu\00E1rios V\00E1lidos - Informa\00E7\00F5es da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283605491712871883)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O ID do Aplicativo j\00E1 existe ou est\00E1 reservado para outro aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282748993424871310)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_language=>'pt-br'
,p_message_text=>'Especifique o nome do aplicativo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283614872171871890)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 necess\00E1rio informar os endere\00E7os de e-mail aos quais enviar o e-mail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283614693541871890)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 necess\00E1rio informar os endere\00E7os de e-mail ou selecionar um conjunto de usu\00E1rios aos quais enviar o e-mail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283614717325871890)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C9 necess\00E1rio selecionar um conjunto de usu\00E1rios para os quais enviar o e-mail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283605564077871883)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O prefixo de tabela n\00E3o deve ter mais de seis caracteres, deve come\00E7ar com letra e conter apenas letras, n\00FAmeros e sublinhados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283605613399871883)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informe outro Prefixo de Tabela. Os seguintes Objetos de Banco de Dados j\00E1 existem: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283590205847871871)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O nome de usu\00E1rio n\00E3o est\00E1 em um formato de endere\00E7o de e-mail v\00E1lido. Observe o formato de nome de usu\00E1rio do aplicativo abaixo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283590188217871871)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>'Verificar Formato de E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283587715860871869)
,p_name=>'CA.VIEW.AS'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir Como'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283609148295871885)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir Blueprint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283597614551871877)
,p_name=>'CA.VIEW.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>'Detalhes da View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283615000908871890)
,p_name=>'CA.VIEW.EMAIL'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir E-mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283599766034871878)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir Meu Perfil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283584638266871867)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_language=>'pt-br'
,p_message_text=>'Desempenho Ponderado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283619669593871894)
,p_name=>'CA.WIDTH'
,p_message_language=>'pt-br'
,p_message_text=>'Largura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283623866694871898)
,p_name=>'CA.WIZARD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar P\00E1ginas de Assistente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282490542568871142)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cont\00EAiner do Assistente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283623980621871898)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crie uma cole\00E7\00E3o de p\00E1ginas a serem usadas como assistente. Em geral os assistentes s\00E3o usados para inserir dados em v\00E1rias etapas.</p>'),
'<p>Informe os seguintes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nome do Assistente</strong> (Obrigat\00F3rio) - Digite um nome para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir \00CDcone</strong> - Selecione um \00EDcone a ser exibido no menu de navega\00E7\00E3o desta p\00E1gina.</li>'),
unistr('  <li><strong>Modo de P\00E1gina</strong> (Obrigat\00F3rio) - Selecione se as etapas do assistente s\00E3o exibidas como p\00E1ginas modais ou normais. Selecione <strong>P\00E1gina Modal</strong> ou <strong>P\00E1gina completa</strong>.</li>'),
unistr('  <li><strong>Etapa 1 ... 8</strong> - Digite o nome da p\00E1gina para as etapas do assistente.<br><em><strong>Observa\00E7\00E3o:</strong> As Etapas de 5 a 8 s\00E3o exibidas \00E0 medida que um nome \00E9 inserido para cada etapa anterior.</em></li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283588184165871869)
,p_name=>'CA.WORK.PHONE'
,p_message_language=>'pt-br'
,p_message_text=>'Telefone comercial'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283580855210871863)
,p_name=>'CA.YELLOW'
,p_message_language=>'pt-br'
,p_message_text=>'Amarelo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282801265478871344)
,p_name=>'CA.YES'
,p_message_language=>'pt-br'
,p_message_text=>'Sim'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282335503110871043)
,p_name=>'CACHED'
,p_message_language=>'pt-br'
,p_message_text=>'No Cache'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282219264640870968)
,p_name=>'CACHE_CREATED'
,p_message_language=>'pt-br'
,p_message_text=>'Cache Criado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282206785925870960)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A funcionalidade Excluir Dados est\00E1 desativada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282191297481870950)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A funcionalidade de adi\00E7\00E3o de dados est\00E1 desativada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282191361777870950)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A funcionalidade de atualiza\00E7\00E3o de dados est\00E1 desativada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282374527102871067)
,p_name=>'CALENDAR.NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pr\00F3ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282374405037871067)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_language=>'pt-br'
,p_message_text=>'Anterior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282232191451870976)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Calend\00E1rio F\00E1cil')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283395628640871737)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Entrada do Calend\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282179821852870943)
,p_name=>'CALENDAR_POPUP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Popup de Calend\00E1rio para %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282330340499871039)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O calend\00E1rio foi criado com sucesso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282733132846871298)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo de Calend\00E1rio Legado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282232083860870976)
,p_name=>'CALENDAR_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Calend\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282583627874871203)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o encontrados modelos de calend\00E1rio ao tentar copiar do aplicativo %0 e ID de modelo %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282734570111871299)
,p_name=>'CANCEL'
,p_message_language=>'pt-br'
,p_message_text=>'Cancelar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282172990642870939)
,p_name=>'CANDLESTICK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Casti\00E7al')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283069277501871516)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_language=>'pt-br'
,p_message_text=>'Folhas de Estilo em Cascata'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282790673568871337)
,p_name=>'CENTER'
,p_message_language=>'pt-br'
,p_message_text=>'Centralizado'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282824759817871359)
,p_name=>'CHANGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Altera\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283454821048871777)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Alterar Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282728913932871295)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_language=>'pt-br'
,p_message_text=>'Alterar Tamanho do Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282347144389871050)
,p_name=>'CHANGE_PW_REQUEST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00E3o %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282728742522871295)
,p_name=>'CHANGE_REQUEST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00E3o de Altera\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283016474243871482)
,p_name=>'CHANGE_WORKSPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Alterar Espa\00E7o de Trabalho')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282700777619871277)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna do Conjunto de Caracteres'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282426097735871100)
,p_name=>'CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282178221244870942)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Consulta de gr\00E1fico inv\00E1lida: %0<br><br>'),
'Use a seguinte sintaxe:',
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>O texto que acompanha a barra</td></tr>',
unistr('<tr><td>VALUE</td><td>Coluna num\00E9rica que define o tamanho da barra</td></tr>'),
'</table>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282369349077871064)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Consulta de gr\00E1fico inv\00E1lida.<br /><br /> Use a seguinte sintaxe: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'),
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
unistr('<td>Coluna num\00E9rica que define o valor do quadrante.</td>'),
'</tr>',
'<tr>',
'<td>MAX</td>',
unistr('<td>Coluna num\00E9rica que define o Valor m\00E1ximo do quadrante.</td>'),
'</tr>',
'<tr>',
'<td>LOW (opcional)</td>',
unistr('<td>Coluna num\00E9rica que define o Valor m\00EDnimo do quadrante anterior.</td>'),
'</tr>',
'<tr>',
'<td>HIGH (opcional)</td>',
unistr('<td>Coluna num\00E9rica que define o Valor m\00E1ximo do quadrante anterior.</td>'),
'</tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282444280493871112)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de gr\00E1fico inv\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282178161788870942)
,p_name=>'CHART.INVALID_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Falha ao fazer parsing da consulta SQL!',
'<p>%0</p>',
unistr('Algumas consultas s\00F3 podem ser executadas durante a execu\00E7\00E3o do aplicativo. Se a consulta estiver com a sintaxe correta, ser\00E1 poss\00EDvel salv\00E1-la sem valida\00E7\00E3o (consulte as op\00E7\00F5es abaixo da origem da consulta).')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283510078389871815)
,p_name=>'CHART_DEGREES'
,p_message_language=>'pt-br'
,p_message_text=>'graus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282677654583871262)
,p_name=>'CHART_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282207510614870961)
,p_name=>'CHART_SERIES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('S\00E9rie de Gr\00E1ficos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282725280502871293)
,p_name=>'CHART_SERIES_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro de s\00E9rie %0 no gr\00E1fico para %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282323512868871035)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O gr\00E1fico foi criado com sucesso.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282282843817871009)
,p_name=>'CHECK$'
,p_message_language=>'pt-br'
,p_message_text=>'seletor de linhas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283442536797871769)
,p_name=>'CHECKED'
,p_message_language=>'pt-br'
,p_message_text=>'marcado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282681508826871265)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Checksum Obrigat\00F3ria - N\00EDvel do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282498003368871147)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Checksum Obrigat\00F3ria - N\00EDvel da Sess\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282497998415871147)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Checksum Obrigat\00F3ria - N\00EDvel do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282497844372871147)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Checksum Obrigat\00F3ria - N\00EDvel do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283512424219871817)
,p_name=>'CHECK_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Marcar Tudo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282665508032871255)
,p_name=>'CLASSIC_CALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Calend\00E1rio Cl\00E1ssico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282668597005871256)
,p_name=>'CLASSIC_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio Cl\00E1ssico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282367885499871063)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Colunas do Relat\00F3rio Cl\00E1ssico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282666155397871255)
,p_name=>'CLASSIC_TREE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rvore Cl\00E1ssica')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282664352210871254)
,p_name=>'CLEAN_UP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Limpar P\00E1gina')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282201793427870957)
,p_name=>'CLEAR_COMMAND'
,p_message_language=>'pt-br'
,p_message_text=>'Limpar Comando'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282674214189871260)
,p_name=>'CLOSED'
,p_message_language=>'pt-br'
,p_message_text=>'Fechado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282721859709871291)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fechados nos 7 \00DAltimos Dias')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282487567964871140)
,p_name=>'CLOSE_WINDOW'
,p_message_language=>'pt-br'
,p_message_text=>'Fechar Janela'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283606061971871883)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'pt-br'
,p_message_text=>'Fechar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283607702995871884)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'pt-br'
,p_message_text=>'Localizar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283605905664871883)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'pt-br'
,p_message_text=>'Localizar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283607669679871884)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Localizar Pr\00F3ximo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283607552393871884)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'pt-br'
,p_message_text=>'Localizar Anterior'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283607309547871884)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'pt-br'
,p_message_text=>'Completar Automaticamente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283606635675871883)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'pt-br'
,p_message_text=>'Tamanho do Recuo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283606885585871884)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Inser\00E7\00F5es de Espa\00E7os na Tabula\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283606285301871883)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Corresponder Mai\00FAsculas e Min\00FAsculas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283606168456871883)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Express\00E3o Regular')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283611135414871887)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_language=>'pt-br'
,p_message_text=>'Construtor de Consultas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283607851356871884)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'pt-br'
,p_message_text=>'Refazer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283607492111871884)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'pt-br'
,p_message_text=>'Substituir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283605719670871883)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Substituir Tudo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283605890444871883)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'pt-br'
,p_message_text=>'Substituir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283608135150871885)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'pt-br'
,p_message_text=>'Ignorar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283607195332871884)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283606481975871883)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283606985058871884)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mostrar N\00FAmeros de Linha')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283606321446871883)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mostrar R\00E9gua')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283606767753871884)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tamanho da Tabula\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283606582679871883)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'pt-br'
,p_message_text=>'Temas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283607931467871884)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'pt-br'
,p_message_text=>'Desfazer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283607030054871884)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usar Editor de Texto Sem Formata\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283607278979871884)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'pt-br'
,p_message_text=>'Validar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283608098557871885)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valida\00E7\00E3o bem-sucedida')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282604454726871216)
,p_name=>'COLLAPSE'
,p_message_language=>'pt-br'
,p_message_text=>'Contrair '
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282215037105870965)
,p_name=>'COLOR_PALETTE'
,p_message_language=>'pt-br'
,p_message_text=>'Paleta de Cores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282440871815871110)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Anal\00F3gico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282440418030871110)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_language=>'pt-br'
,p_message_text=>'Complementar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282441031741871110)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_language=>'pt-br'
,p_message_text=>'Cores Complementares'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282440903583871110)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mon\00F3tono')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282440564421871110)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_language=>'pt-br'
,p_message_text=>'Dividir complementar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282440729668871110)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00E9trada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282440645759871110)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tr\00EDade')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283061363899871511)
,p_name=>'COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283497458209871806)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome para Exibi\00E7\00E3o: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282596701700871211)
,p_name=>'COLUMN_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Coluna'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282802495127871345)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Todos os usu\00E1rios autenticados podem acessar este aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282802521365871345)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Somente usu\00E1rios definidos na lista de controle de acesso do aplicativo podem acessar este aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282802632683871345)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor de Defini\00E7\00E3o de Controle de Acesso Inesperado: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282208419009870961)
,p_name=>'COMING_SOON'
,p_message_language=>'pt-br'
,p_message_text=>'Em Breve'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282597231568871211)
,p_name=>'COMMENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coment\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282734755166871299)
,p_name=>'COMMENTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coment\00E1rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282488740016871141)
,p_name=>'COMPILE_FAILURE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Falha de compila\00E7\00E3o; linha <a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282818744697871355)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A compila\00E7\00E3o falhou na linha %0 (%2). Os n\00FAmeros de linha associados a erros de compila\00E7\00E3o s\00E3o relativos \00E0 primeira instru\00E7\00E3o BEGIN. Isso s\00F3 afeta a compila\00E7\00E3o de triggers do banco de dados.<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282488670174871141)
,p_name=>'COMPILE_SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00F3digo PL/SQL compilado com sucesso (%0)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282671535420871258)
,p_name=>'COMPLETE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conclu\00EDdo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282678987707871263)
,p_name=>'COMPLETED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conclu\00EDdo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282685965429871268)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conclu\00EDdo / Sem problemas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282722465597871291)
,p_name=>'COMPONENT'
,p_message_language=>'pt-br'
,p_message_text=>'Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282879285650871393)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Componente: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283150590567871569)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Componente n\00E3o ativado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282327038312871037)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_language=>'pt-br'
,p_message_text=>'O componente foi criado com sucesso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283492703476871803)
,p_name=>'COMPONENT_SUMMARY'
,p_message_language=>'pt-br'
,p_message_text=>'Resumo do Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282270247591871001)
,p_name=>'COMPUTATIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00E1lculos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282745964210871308)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_language=>'pt-br'
,p_message_text=>'Componentes do aplicativo instalados com sucesso.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282489335440871141)
,p_name=>'CONDITIONAL'
,p_message_language=>'pt-br'
,p_message_text=>'Condicional'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282579227961871200)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_language=>'pt-br'
,p_message_text=>'Lista de Valores popup'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282663022592871253)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_language=>'pt-br'
,p_message_text=>'sempre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282399055830871083)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>'existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282398559531871083)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_language=>'pt-br'
,p_message_text=>'item/coluna=valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282398610212871083)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('item/coluna n\00E3o nulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283364620639871716)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_language=>'pt-br'
,p_message_text=>'item / coluna nulo(a)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282399151180871083)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_language=>'pt-br'
,p_message_text=>'nunca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282399229893871083)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_language=>'pt-br'
,p_message_text=>'nenhum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282398860303871083)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('p\00E1gina em')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282398981074871083)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('a p\00E1gina n\00E3o est\00E1 em')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282398449836871083)
,p_name=>'CONDITIONS_SHORTCUT_PLSQL'
,p_message_language=>'pt-br'
,p_message_text=>'PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282398717573871083)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_language=>'pt-br'
,p_message_text=>unistr('solicita\00E7\00E3o=e1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282410306542871090)
,p_name=>'CONDITION_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de Condi\00E7\00E3o')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282624493582871228)
,p_name=>'CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>'Confirmar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282174720765870940)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Detalhe mestre em duas p\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282174683576870940)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Detalhe mestre em tr\00EAs p\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282385042154871074)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome Real'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282670732662871258)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_language=>'pt-br'
,p_message_text=>'Agregar por Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282670873568871258)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fun\00E7\00F5es de Agrega\00E7\00E3o a Serem Usadas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282382450787871072)
,p_name=>'CONFIRM.APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282395871016871081)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_language=>'pt-br'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282395966711871081)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Idioma Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282395779669871081)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282276940191871005)
,p_name=>'CONFIRM.ARRAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rvore de Resultados para Relat\00F3rio Ativada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282277003401871005)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Par\00E2metros de Resultados para Relat\00F3rio Ativados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282396075864871081)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282862469240871383)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ramificar para P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282586669164871204)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Quebrar Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282384821724871074)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ramifica\00E7\00E3o do Bot\00E3o %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282384740506871074)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Texto de Exibi\00E7\00E3o do Bot\00E3o %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282188439108870948)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ativar Adi\00E7\00E3o de Dados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282188374356870948)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_language=>'pt-br'
,p_message_text=>'Ativar Arrastar e Soltar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282804882229871346)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cancelar Ramifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282862295224871383)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Label do Bot\00E3o Cancelar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282852715972871377)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Distin\00E7\00E3o entre Mai\00FAsculas e Min\00FAsculas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282487095161871139)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou altera\00E7\00E3o na consulta do Relat\00F3rio Interativo. Se voc\00EA removeu qualquer coluna da consulta, isso desativar\00E1 os filtros existentes, as regras de destaque e outras defini\00E7\00F5es de relat\00F3rio dessas colunas. Confirme sua solicita\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282385935995871075)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Eixo do Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282735064507871299)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_language=>'pt-br'
,p_message_text=>'Quadrante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282735184398871299)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_language=>'pt-br'
,p_message_text=>'Quadrante (Curva)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282386686792871075)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_language=>'pt-br'
,p_message_text=>'Barra Horizontal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282386835788871075)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_language=>'pt-br'
,p_message_text=>'Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282386181465871075)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1scara de N\00FAmero')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282386754365871075)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_language=>'pt-br'
,p_message_text=>'Pizza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282385857825871075)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Consulta de Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282386080419871075)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_language=>'pt-br'
,p_message_text=>'Escala'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282386927206871075)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dispers\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282386438515871075)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tamanho do Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282386386896871075)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo do Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282386279941871075)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282386521879871075)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_language=>'pt-br'
,p_message_text=>'Barra Vertical'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282277146021871005)
,p_name=>'CONFIRM.COLLECTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome do Conjunto de Resultados Tempor\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282383263536871073)
,p_name=>'CONFIRM.COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282586430122871204)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cabe\00E7alhos de Coluna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282762320319871319)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282805006475871346)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_language=>'pt-br'
,p_message_text=>'Nomes da Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282395583679871081)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usar Classifica\00E7\00E3o de Cabe\00E7alho de Coluna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282502225882871149)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a c\00F3pia de um aplicativo com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282394106003871080)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a c\00F3pia de uma p\00E1gina com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282383730243871073)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Um novo conjunto de guias "%0" ser\00E1 criado e usado por esta p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282395623502871081)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de um aplicativo com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282388205909871076)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de calend\00E1rio com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282391443224871078)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de relat\00F3rio de drill-down com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282451109888871116)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de Relat\00F3rio Interativo com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282394443906871080)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de relat\00F3rio com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282182071566870944)
,p_name=>'CONFIRM.CREATE_FLASH_CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de gr\00E1fico Flash com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283468323390871787)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de um aplicativo de Banco de Dados usando o mesmo ID de outro aplicativo de Banco de Dados existente no espa\00E7o de trabalho atual. O aplicativo de Banco de Dados existente ser\00E1 exclu\00EDdo e substitu\00EDdo pelo novo. Confirme suas s')
||unistr('ele\00E7\00F5es. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282759149631871317)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de form e p\00E1ginas da view em lista com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282670453333871258)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de um form em uma p\00E1gina de relat\00F3rio com p\00E1ginas de an\00E1lise. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282387834770871076)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de um form na consulta SQL com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282387743413871076)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de um form em procedimento armazenado com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282387685885871076)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de um form em uma p\00E1gina de tabela com os atributos a seguir.   Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282233150229870977)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de um form em uma p\00E1gina de refer\00EAncia a Web service com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282289982763871013)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de um form e um relat\00F3rio em uma p\00E1gina de refer\00EAncia a Web service com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282699746429871276)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de Mapa com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282172139701870938)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de p\00E1ginas detalhe mestre com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282389406970871077)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma regi\00E3o e de uma op\00E7\00E3o de breadcrumb com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282677715856871262)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Modo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282387448670871076)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283543874107871838)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283543987642871838)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar Nome da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282390220294871077)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de p\00E1ginas de relat\00F3rio e form com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283464236678871784)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282394259234871080)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de relat\00F3rio com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282387958373871076)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma P\00E1gina de Gr\00E1fico de Barras HTML com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282393825476871080)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de resumo com os atributos a seguir. Pressione o bot\00E3o "Adicionar Mais" para adicionar itens de outras p\00E1ginas e/ou regi\00F5es. Pressione "Finalizar" para criar os itens de resumo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282388006453871076)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de gr\00E1fico SVG com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282387366955871076)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de form tabular com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282388557377871076)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma p\00E1gina de \00E1rvore com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282387592143871076)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de um assistente com os atributos a seguir. Confirme suas sele\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283467965047871786)
,p_name=>'CONFIRM.CREATE_WS_APP_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de um aplicativo de Websheet usando o mesmo ID de outro aplicativo de Websheet existente no espa\00E7o de trabalho atual. O aplicativo de Websheet existente ser\00E1 exclu\00EDdo e substitu\00EDdo pelo novo. Confirme suas sele\00E7\00F5es. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282582266536871202)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Label do Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283400967881871740)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome da Defini\00E7\00E3o de Carga de Dados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283475547203871791)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esta Defini\00E7\00E3o de Carga de Dados ser\00E1 recreada com as pesquisas de tabela e regras de transforma\00E7\00E3o existentes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282852850112871377)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282388358686871076)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna de Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282677828845871262)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esquema de Autentica\00E7\00E3o Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282387254627871076)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282392124024871079)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Colunas de Exibi\00E7\00E3o Detalhadas %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282175111610870940)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna(s) de Exibi\00E7\00E3o Detalhada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282393728347871080)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna Detalhada do Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282392956297871079)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tabela Detalhada %0 para Ordena\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282391679243871078)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina Detalhada %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282175073084870940)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Tabela Detalhada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282391973805871079)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Tabela Detalhada %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282391772406871078)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Detalhar Label da Guia %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282805355329871346)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Fazer Upload da Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282385310970871074)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282762086178871319)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_language=>'pt-br'
,p_message_text=>'Fazer Upload da Coluna 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282762118983871319)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_language=>'pt-br'
,p_message_text=>'Fazer Upload da Coluna 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282389605785871077)
,p_name=>'CONFIRM.DISPLAY_POINT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ponto de Exibi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283552723466871844)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283552876337871844)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Nome da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282575199173871197)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sa\00EDda em CSV')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282575869966871198)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Imprimir Sa\00EDda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282576424481871198)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ativar Classifica\00E7\00E3o de Cabe\00E7alho de Coluna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282626380688871230)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Uma regi\00E3o ser\00E1 adicionada \00E0 P\00E1gina de Administra\00E7\00E3o existente:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282804903238871346)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Finalizar Ramifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282390710202871078)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina de Form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282390822386871078)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome da P\00E1gina de Form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282391064656871078)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Label da Guia da P\00E1gina de Form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282390970406871078)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conjunto de Guias da P\00E1gina de Form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282677974756871263)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_language=>'pt-br'
,p_message_text=>'Importar Componentes Compartilhados de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283135436196871559)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Incluir Calend\00E1rio Personalizado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282175354357870940)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Incluir relat\00F3rio mestre?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282393442161871079)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_language=>'pt-br'
,p_message_text=>'Incluir um Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282384589394871074)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo de Informa\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282384624793871074)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Texto Padr\00E3o para Informa\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282233345190870977)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>'Itens de Form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282277317629871005)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo da Regi\00E3o do Form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282277219381871005)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo da Regi\00E3o do Form')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282387098485871075)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Inserir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282384317284871074)
,p_name=>'CONFIRM.ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>'Itens'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282805260389871346)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Retornar Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282804154620871346)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna 1 de Chave de Pesquisa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282804237760871346)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna-Chave 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282804327880871346)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna-Chave 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282388494538871076)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna de Labels'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282762264829871319)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio da Pesquisa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282805192688871346)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Tabela de Consulta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282175492141870940)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_language=>'pt-br'
,p_message_text=>'Layout de Detalhe Mestre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282174943407870940)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna(s) de Exibi\00E7\00E3o Mestra')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282175250359870940)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_language=>'pt-br'
,p_message_text=>'Navegar registro mestre por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282174829551870940)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Tabela Mestra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282586588496871204)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero M\00E1ximo de Colunas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282582043454871202)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Linhas Por P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282459895647871122)
,p_name=>'CONFIRM.MENU'
,p_message_language=>'pt-br'
,p_message_text=>'Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282389989927871077)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_language=>'pt-br'
,p_message_text=>'Link de Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282393520537871080)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_language=>'pt-br'
,p_message_text=>'Raiz de Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282389782501871077)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo de Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282390034829871077)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Texto de Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282307669294871025)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou o upgrade do gr\00E1fico Flash para o novo gr\00E1fico Flash 6. Confirme sua solicita\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282671680167871258)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6_XML'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou upgrade de um gr\00E1fico Flash com base em XML personalizado para o novo gr\00E1fico Flash 6. Devido a diferen\00E7as na estrutura XML entre o gr\00E1fico Flash 6 atual e o novo, os gr\00E1fico submetido a upgrade n\00E3o ser\00E1 exibido. Voc\00EA dever\00E1 modificar ')
||unistr('o XML personalizado do gr\00E1fico submetido a upgrade para usar a nova estrutura XML. Confirme sua solicita\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282245934551870985)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou o upgrade do gr\00E1fico Flash para o novo gr\00E1fico HTML5. Confirme sua solicita\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282246075809870985)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5_XML'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou upgrade de um gr\00E1fico Flash com base em XML personalizado para o novo gr\00E1fico HTML5. Devido a diferen\00E7as na estrutura XML entre o gr\00E1fico HTML5 atual e o novo, os gr\00E1fico submetido a upgrade n\00E3o ser\00E1 exibido. Voc\00EA dever\00E1 modificar o XM')
||unistr('L personalizado do gr\00E1fico submetido a upgrade para usar a nova estrutura XML. Confirme sua solicita\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282245899213870985)
,p_name=>'CONFIRM.MIGRATE_HTML_TO_HTML5'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou o upgrade do gr\00E1fico HTML para o novo gr\00E1fico HTML5. Confirme sua solicita\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283488743153871800)
,p_name=>'CONFIRM.MIGRATE_JSTREE_TO_APEXTREE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou o upgrade de jsTree para uma nova \00C1rvore. Confirme sua solicita\00E7\00E3o.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282373775749871067)
,p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('O gr\00E1fico SVG ser\00E1 submetido a upgrade com as seguintes restri\00E7\00F5es:  '),
'<ul>',
'<li>',
unistr('Somente os formatos de n\00FAmero definidos nas strings do formato do eixo ser\00E3o migradas. Os formatos de data e de hor\00E1rio ser\00E3o ignorados.'),
'</li>',
'<li>',
unistr('Os elementos do formato do n\00FAmero que cont\00EAm as seguintes op\00E7\00F5es ser\00E3o migrados:'),
'<br />',
unistr('0,9,D,G,, (v\00EDrgula),. (ponto final),$,C,L,FM'),
'</li>',
'<li>',
unistr('O label para cada s\00E9rie no gr\00E1fico em Flash ser\00E1 derivado de cada alias da coluna da s\00E9rie.  '),
unistr('Esse recurso difere dos gr\00E1ficos SVG, onde o label para cada s\00E9rie foi derivado do atributo do Nome da S\00E9rie.'),
'</li>',
'<li>',
unistr('Os gr\00E1ficos de Quadrantes em Flash exibem os valores reais em vez de percentuais.'),
'</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282328879514871038)
,p_name=>'CONFIRM.MIGRATE_SVG_TO_HTML5'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou o upgrade do gr\00E1fico SVG para um gr\00E1fico HTML5. Confirme sua solicita\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283464033106871784)
,p_name=>'CONFIRM.NAVIGATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282396326567871081)
,p_name=>'CONFIRM.NAV_BAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Barra de Navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283114286525871545)
,p_name=>'CONFIRM.NAV_LIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Lista do Menu de Navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282689585135871270)
,p_name=>'CONFIRM.NEW_ADMIN_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Uma nova p\00E1gina de Administra\00E7\00E3o ser\00E1 adicionada, P\00E1gina:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282487202000871140)
,p_name=>'CONFIRM.NEW_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Novas Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282385178583871074)
,p_name=>'CONFIRM.NEW_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Novo Modelo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282862004160871383)
,p_name=>'CONFIRM.NEXT_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Label do Bot\00E3o Pr\00F3ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282383607249871073)
,p_name=>'CONFIRM.NO.TABSET.SELECTED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nenhum conjunto de guias foi selecionado para esta p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282384251699871074)
,p_name=>'CONFIRM.NO_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Sem Modelo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282233446251870977)
,p_name=>'CONFIRM.OUTPUT_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Itens de Sa\00EDda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282385577572871074)
,p_name=>'CONFIRM.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282382557095871073)
,p_name=>'CONFIRM.PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282396115501871081)
,p_name=>'CONFIRM.PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282382686472871073)
,p_name=>'CONFIRM.PAGE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282383557906871073)
,p_name=>'CONFIRM.PAGE_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282392086182871079)
,p_name=>'CONFIRM.PARENT_DISPLAY_COLS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Colunas de Exibi\00E7\00E3o M\00E3es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282390190261871077)
,p_name=>'CONFIRM.PARENT_MENU'
,p_message_language=>'pt-br'
,p_message_text=>'Breadcrumb Pai'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282393666802871080)
,p_name=>'CONFIRM.PARENT_MENU_COL'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna do Breadcrumb Pai'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282392290268871079)
,p_name=>'CONFIRM.PARENT_ORDER_BY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tabela Pai para Ordena\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282391566368871078)
,p_name=>'CONFIRM.PARENT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina M\00E3e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282391859248871078)
,p_name=>'CONFIRM.PARENT_TABLE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Tabela Pai'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282384168340871074)
,p_name=>'CONFIRM.PARENT_TAB_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Label da Guia M\00E3e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282384085941871073)
,p_name=>'CONFIRM.PARENT_TAB_SET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conjunto de Guias M\00E3es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282486908567871139)
,p_name=>'CONFIRM.PARSING_SCHEMA'
,p_message_language=>'pt-br'
,p_message_text=>'Esquema de Parsing'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282495967398871145)
,p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atualiza\00E7\00E3o de P\00E1gina Parcial')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282862182915871383)
,p_name=>'CONFIRM.PREVIOUS_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Label do Bot\00E3o Anterior')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282383478130871073)
,p_name=>'CONFIRM.PRIMARY_KEY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna de Chave Prim\00E1ria %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282391186879871078)
,p_name=>'CONFIRM.PRIMARY_KEY_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna da Chave Prim\00E1ria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282582338052871202)
,p_name=>'CONFIRM.PRINT_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Formato de Sa\00EDda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282586748799871205)
,p_name=>'CONFIRM.PRINT_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Imprimir Label do Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282582435925871202)
,p_name=>'CONFIRM.PRINT_OUTPUT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Impress\00E3o de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282385405539871074)
,p_name=>'CONFIRM.PROCESS_OPTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es de Processo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282582166239871202)
,p_name=>'CONFIRM.REGION_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna de Regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282384453663871074)
,p_name=>'CONFIRM.REGION_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo de Regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282382762623871073)
,p_name=>'CONFIRM.REGION_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo da Regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282389565741871077)
,p_name=>'CONFIRM.REGION_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de Regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282487121142871140)
,p_name=>'CONFIRM.REMOVED_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas Removidas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282391280357871078)
,p_name=>'CONFIRM.REPORT_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Colunas do Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282604559985871216)
,p_name=>'CONFIRM.REPORT_IMPLEMENTATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Implementa\00E7\00E3o de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282390321536871077)
,p_name=>'CONFIRM.REPORT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282390494792871078)
,p_name=>'CONFIRM.REPORT_PAGE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome da P\00E1gina de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282390607584871078)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Label de Guia de P\00E1gina de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282390502237871078)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_SET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conjunto de Guias da P\00E1gina de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282277553544871005)
,p_name=>'CONFIRM.REPORT_REGION_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo da Regi\00E3o do Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282277488621871005)
,p_name=>'CONFIRM.REPORT_REGION_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('T\00EDtulo da Regi\00E3o de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282394537391871080)
,p_name=>'CONFIRM.REPORT_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282280049612871007)
,p_name=>'CONFIRM.ROW_VERSION_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna de Vers\00E3o da Linha')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282394793251871080)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME1'
,p_message_language=>'pt-br'
,p_message_text=>unistr('padr\00E3o: HTML (padr\00E3o)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282395077092871081)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME11'
,p_message_language=>'pt-br'
,p_message_text=>unistr('padr\00E3o: Apar\00EAncia 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282395164426871081)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME12'
,p_message_language=>'pt-br'
,p_message_text=>unistr('padr\00E3o: Apar\00EAncia 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282486716040871139)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME13'
,p_message_language=>'pt-br'
,p_message_text=>unistr('padr\00E3o: Apar\00EAncia 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282486889640871139)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME14'
,p_message_language=>'pt-br'
,p_message_text=>unistr('padr\00E3o: Apar\00EAncia 4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282278013990871006)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME15'
,p_message_language=>'pt-br'
,p_message_text=>unistr('padr\00E3o: Apar\00EAncia 5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282394857273871080)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME2'
,p_message_language=>'pt-br'
,p_message_text=>unistr('padr\00E3o: relat\00F3rio vertical')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282395273552871081)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME21'
,p_message_language=>'pt-br'
,p_message_text=>'exportar: CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282395335786871081)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME22'
,p_message_language=>'pt-br'
,p_message_text=>'exportar: XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282394949712871080)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME3'
,p_message_language=>'pt-br'
,p_message_text=>unistr('padr\00E3o: relat\00F3rio vertical, apar\00EAncia 1 (incluir colunas nulas)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282486503203871139)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME4'
,p_message_language=>'pt-br'
,p_message_text=>unistr('padr\00E3o: relat\00F3rio vertical, apar\00EAncia 2 (excluir colunas nulas)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282486669115871139)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME5'
,p_message_language=>'pt-br'
,p_message_text=>unistr('padr\00E3o: relat\00F3rio vertical, apar\00EAncia 2 (incluir colunas nulas)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282805454733871346)
,p_name=>'CONFIRM.RULE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Regra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282805603527871347)
,p_name=>'CONFIRM.RULE_SEQUENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sequ\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282805786662871347)
,p_name=>'CONFIRM.RULE_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Regra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282207251143870960)
,p_name=>'CONFIRM.RUN_SCRIPT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA solicitou a execu\00E7\00E3o do script a seguir. Confirme sua sele\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282389817535871077)
,p_name=>'CONFIRM.SEQUENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sequ\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282394657391871080)
,p_name=>'CONFIRM.SORT_OPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00E3o de Classifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282385796112871075)
,p_name=>'CONFIRM.SQL_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>'Consulta SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282495850195871145)
,p_name=>'CONFIRM.STANDARD_CALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282624004294871228)
,p_name=>'CONFIRM.STARTING_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('V\00E1rias p\00E1ginas ser\00E3o criadas, come\00E7ando pela P\00E1gina:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282385683755871074)
,p_name=>'CONFIRM.STORED_PROCEDURE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Procedimento Armazenado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282488589715871140)
,p_name=>'CONFIRM.STORED_PROCEDURE_OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio do Procedimento Armazenado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282862369831871383)
,p_name=>'CONFIRM.SUBMIT_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Label do Bot\00E3o Finalizar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283479585784871794)
,p_name=>'CONFIRM.SUBSCRIBE_THEME'
,p_message_language=>'pt-br'
,p_message_text=>'Inscrever Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282384966678871074)
,p_name=>'CONFIRM.SUGGESTED_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome Sugerido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282670583121871258)
,p_name=>'CONFIRM.TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Tabela/View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282670650262871258)
,p_name=>'CONFIRM.TABLE_COLS'
,p_message_language=>'pt-br'
,p_message_text=>'Resumir Por Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282889598166871400)
,p_name=>'CONFIRM.TABLE_LOOKUPS'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisas de Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282383197590871073)
,p_name=>'CONFIRM.TABLE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282383087986871073)
,p_name=>'CONFIRM.TABLE_OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio da Tabela')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283061649939871511)
,p_name=>'CONFIRM.TABLE_RULE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regra de Transforma\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282805854280871347)
,p_name=>'CONFIRM.TABLE_RULES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regras de Transforma\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282487426818871140)
,p_name=>'CONFIRM.TABLE_VIEW_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Tabela / View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282487312283871140)
,p_name=>'CONFIRM.TABLE_VIEW_OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio da Tabela/View')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282396263516871081)
,p_name=>'CONFIRM.TABS'
,p_message_language=>'pt-br'
,p_message_text=>'Guias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282383919637871073)
,p_name=>'CONFIRM.TABSET.INCOMPLETE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Advert\00EAncia; as informa\00E7\00F5es do conjunto de guias est\00E1 incompleta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282382908623871073)
,p_name=>'CONFIRM.TAB_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Label de Guia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282394332551871080)
,p_name=>'CONFIRM.TAB_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome da Guia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282382832893871073)
,p_name=>'CONFIRM.TAB_SET'
,p_message_language=>'pt-br'
,p_message_text=>'Conjunto de Guias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282395470432871081)
,p_name=>'CONFIRM.TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'modelo:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282389193516871077)
,p_name=>'CONFIRM.TREE_LOV'
,p_message_language=>'pt-br'
,p_message_text=>'Com base no novo item com lista de valores popup'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282388860366871077)
,p_name=>'CONFIRM.TREE_MAX_LEVEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E1x. de N\00EDveis')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282388610148871076)
,p_name=>'CONFIRM.TREE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome da \00C1rvore')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282389047659871077)
,p_name=>'CONFIRM.TREE_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Consulta de \00C1rvore')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282389260979871077)
,p_name=>'CONFIRM.TREE_SQL'
,p_message_language=>'pt-br'
,p_message_text=>'Com Base em uma Consulta SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282388999305871077)
,p_name=>'CONFIRM.TREE_START'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rvore Inicial:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282389330422871077)
,p_name=>'CONFIRM.TREE_STATIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor est\00E1tico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282388748511871077)
,p_name=>'CONFIRM.TREE_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de \00C1rvore')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282396445456871081)
,p_name=>'CONFIRM.UI_THEME'
,p_message_language=>'pt-br'
,p_message_text=>'Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282396531705871082)
,p_name=>'CONFIRM.UI_THEME1'
,p_message_language=>'pt-br'
,p_message_text=>'Azul e Marrom-Amarelado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282396608220871082)
,p_name=>'CONFIRM.UI_THEME2'
,p_message_language=>'pt-br'
,p_message_text=>'Vermelho'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282396709116871082)
,p_name=>'CONFIRM.UI_THEME4'
,p_message_language=>'pt-br'
,p_message_text=>'Azul-Marinho e Cinza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282396874358871082)
,p_name=>'CONFIRM.UI_THEME5'
,p_message_language=>'pt-br'
,p_message_text=>'Verde-oliva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282396951691871082)
,p_name=>'CONFIRM.UI_THEME6'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bord\00F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282397042629871082)
,p_name=>'CONFIRM.UI_THEME7'
,p_message_language=>'pt-br'
,p_message_text=>'Azul Simples e Marrom Amarelado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282397159139871082)
,p_name=>'CONFIRM.UI_THEME8'
,p_message_language=>'pt-br'
,p_message_text=>'Azul'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282397209893871082)
,p_name=>'CONFIRM.UI_THEME_NONE'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282383380974871073)
,p_name=>'CONFIRM.UPDATEABLE_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Colunas Atualiz\00E1veis')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282387177497871075)
,p_name=>'CONFIRM.UPDATE_PROCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282383818162871073)
,p_name=>'CONFIRM.USE.EXISTING.TABSET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esta p\00E1gina usar\00E1 o conjunto de guias existente "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282233288701870977)
,p_name=>'CONFIRM.WEB_SERVICE_REF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Refer\00EAncia a Web Service, Opera\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282391311246871078)
,p_name=>'CONFIRM.WHERE_CLAUSE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cl\00E1usula Where')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282659985790871251)
,p_name=>'CONFIRMATION_ICON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00CDcone de Confirma\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282672086326871259)
,p_name=>'CONFIRMED'
,p_message_language=>'pt-br'
,p_message_text=>'Confirmado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282672373279871259)
,p_name=>'CONFIRMED_BY_QA'
,p_message_language=>'pt-br'
,p_message_text=>'Confirmado pelo Contr. Qualidade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282582622513871202)
,p_name=>'CONFIRM_BREAK_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Quebrar Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282582573595871202)
,p_name=>'CONFIRM_PRINT_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Formato de Impress\00E3o')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282700837081871277)
,p_name=>'CONTENT_DISPOSITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Disposi\00E7\00E3o de Conte\00FAdo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282736066560871300)
,p_name=>'CONTENT_SERVED_IN_KBYTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Conte\00FAdo Fornecido')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282573548581871196)
,p_name=>'CONTINUE'
,p_message_language=>'pt-br'
,p_message_text=>'Continuar'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283613160278871889)
,p_name=>'CONTRIBUTORS'
,p_message_language=>'pt-br'
,p_message_text=>'Colaboradores'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283505701955871812)
,p_name=>'COPY.PAGE.NEW_STATIC_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Novo ID Est\00E1tico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282269982533871000)
,p_name=>'COPYRIGHT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Copyright \00A9 %0, Oracle. Todos os direitos reservados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282328361863871038)
,p_name=>'COPY_APP_SUCCESS_MSG'
,p_message_language=>'pt-br'
,p_message_text=>'O seu aplicativo foi copiado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282463906092871124)
,p_name=>'COPY_BUTTON.EXECUTION_ERR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro durante a execu\00E7\00E3o de copy_button: %0 >> %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282502829678871150)
,p_name=>'COPY_DEPLOYMENT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Copiar Atributos de Defini\00E7\00E3o do Objeto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282301690463871021)
,p_name=>'COPY_EXISTING_APP'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282759945831871317)
,p_name=>'COPY_FEATURE'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar Recurso: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282502450004871150)
,p_name=>'COPY_FROM_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar Do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282936670159871431)
,p_name=>'COPY_FROM_APP_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Com Base na Aplicativo-Modelo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282502516389871150)
,p_name=>'COPY_FROM_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar de Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282330539564871039)
,p_name=>'COPY_LIST_ENTRY'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar Entrada de Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282464324368871125)
,p_name=>'COPY_NAMED_LOV.EXECUTION_ERR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro durante a execu\00E7\00E3o de copy_named_lov: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282464283419871125)
,p_name=>'COPY_NAMED_LOV.NOT_FOUND_ERR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O ID da Lista de Valores "%0" n\00E3o foi encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282464183663871125)
,p_name=>'COPY_NAMED_LOV.NUMERIC_ERR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('ID da Lista de Valores "%0" n\00E3o \00E9 num\00E9rico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282740967744871303)
,p_name=>'COPY_PAGE.COPY_FROM_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Copiar Da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282741087622871303)
,p_name=>'COPY_PAGE.COPY_TO_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Copiar Para P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282739939398871302)
,p_name=>'COPY_PAGE.SELECT_AUTHORIZATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('- Selecionar Autoriza\00E7\00E3o -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282739872490871302)
,p_name=>'COPY_PAGE.SELECT_LIST'
,p_message_language=>'pt-br'
,p_message_text=>'- Selecionar Lista -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282739797792871302)
,p_name=>'COPY_PAGE.SELECT_NAMED_LOV'
,p_message_language=>'pt-br'
,p_message_text=>'- Selecionar Lista de Valores -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282811899800871350)
,p_name=>'COPY_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar %0 para a tabela %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282502623205871150)
,p_name=>'COPY_TO_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar Para Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282502721704871150)
,p_name=>'COPY_TO_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar para Nome'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282428140003871102)
,p_name=>'CORE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('b\00E1sico')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282595094653871210)
,p_name=>'COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Contagem'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282652865404871247)
,p_name=>'CREATE'
,p_message_language=>'pt-br'
,p_message_text=>'Criar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282899000357871406)
,p_name=>'CREATE APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282899149834871406)
,p_name=>'CREATE OBJECT'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283108766804871542)
,p_name=>'CREATED'
,p_message_language=>'pt-br'
,p_message_text=>'Criado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283108817706871542)
,p_name=>'CREATED_BY'
,p_message_language=>'pt-br'
,p_message_text=>'Criado por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282759611884871317)
,p_name=>'CREATED_LAST_7_DAYS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criados(as) nos 7 \00FAltimos dias')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282465098352871125)
,p_name=>'CREATED_ON'
,p_message_language=>'pt-br'
,p_message_text=>'Criado em'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282301783610871021)
,p_name=>'CREATE_APP_FROM_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'De um modelo de aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283402980262871742)
,p_name=>'CREATE_APP_WIZ.CANDLE_CHARTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1ficos Candlestick')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283402701650871742)
,p_name=>'CREATE_APP_WIZ.COL_CHARTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1ficos de Barras e Empilhados, Colunas, 2D e 3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283403419976871742)
,p_name=>'CREATE_APP_WIZ.GAUGE_CHARTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1fico de Quadrantes e Quadrante (Percentual)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283402847860871742)
,p_name=>'CREATE_APP_WIZ.PIE_CHARTS'
,p_message_language=>'pt-br'
,p_message_text=>'Setores Circular e Anel em 2D e 3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283403175190871742)
,p_name=>'CREATE_APP_WIZ.PROJECTGANTT_CHARTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1ficos de Gantt do Projeto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283403393254871742)
,p_name=>'CREATE_APP_WIZ.RANGE_CHARTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1ficos de Faixa 2D e 3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283403258309871742)
,p_name=>'CREATE_APP_WIZ.RESOURCEGANTT_CHARTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1ficos de Gantt do Recurso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283403013762871742)
,p_name=>'CREATE_APP_WIZ.SCATTER_CHARTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1ficos do Marcador de Dispers\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282420044300871097)
,p_name=>'CREATE_CONDITION.AND'
,p_message_language=>'pt-br'
,p_message_text=>'AND'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282419843648871097)
,p_name=>'CREATE_CONDITION.ARROW_DOWN'
,p_message_language=>'pt-br'
,p_message_text=>'Seta para Baixo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282419920958871097)
,p_name=>'CREATE_CONDITION.ARROW_RIGHT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Seta \00E1 Direita')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282419627228871096)
,p_name=>'CREATE_CONDITION.COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282419731013871096)
,p_name=>'CREATE_CONDITION.CONDITIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Condi\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282420177924871097)
,p_name=>'CREATE_CONDITION.OR'
,p_message_language=>'pt-br'
,p_message_text=>'OR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282420261351871097)
,p_name=>'CREATE_CONDITION.PREVIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Condi\00E7\00E3o de Visualiza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282760466226871317)
,p_name=>'CREATE_DEMO_APP.GRANT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Clique no bot\00E3o Conceder Privil\00E9gios a seguir para conceder estes privil\00E9gios agora para %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282760287233871317)
,p_name=>'CREATE_DEMO_APP.NO_CREATE_PRIV'
,p_message_language=>'pt-br'
,p_message_text=>unistr('%0 n\00E3o tem o privil\00E9gio CREATE TABLE, CREATE VIEW, CREATE TRIGGER, CREATE SEQUENCE ou CREATE PROCEDURE e n\00E3o poder\00E1 instalar o aplicativo de demonstra\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282760390902871317)
,p_name=>'CREATE_DEMO_APP.NO_EXEC_PRIV'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('%0 n\00E3o tem privil\00E9gio de execu\00E7\00E3o em CTX_DOC e CTX_DDL e n\00E3o poder\00E1 instalar a demonstra\00E7\00E3o de discurso de posse do presidente. Fa\00E7a as seguintes concess\00F5es como um usu\00E1rio privilegiado: '),
'<pre>',
'GRANT EXECUTE ON CTXSYS.CTX_DDL TO %0; ',
'GRANT EXECUTE ON CTXSYS.CTX_DOC TO %0;',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283106888750871541)
,p_name=>'CREATE_DIALOG_CLOSED_DA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar Bot\00E3o - Caixa de Di\00E1logo Fechada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282204121474870958)
,p_name=>'CREATE_DYNAMIC_LIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar Lista Din\00E2mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282488291631871140)
,p_name=>'CREATE_DYNAMIC_LOV'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar LOV Din\00E2mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282182163460870944)
,p_name=>'CREATE_FLOW.CLOUD_IDM'
,p_message_language=>'pt-br'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282221694844870970)
,p_name=>'CREATE_FLOW.DBACCOUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Conta de Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282925285613871423)
,p_name=>'CREATE_FLOW.HTMLDB_AUTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Autentica\00E7\00E3o do Application Express')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282760837897871318)
,p_name=>'CREATE_FLOW.LDAP'
,p_message_language=>'pt-br'
,p_message_text=>'LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283464171538871784)
,p_name=>'CREATE_FLOW.NAVIGATION_LIST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Lista do Menu de Navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282925317240871423)
,p_name=>'CREATE_FLOW.NO_AUTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sem Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282924913808871423)
,p_name=>'CREATE_FLOW.NO_TABS'
,p_message_language=>'pt-br'
,p_message_text=>'Sem Guias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282925095271871423)
,p_name=>'CREATE_FLOW.ONE_LEVEL_TABS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Um N\00EDvel de Guias')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282760981301871318)
,p_name=>'CREATE_FLOW.SSO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Senha de Sign-on \00DAnico (SSO)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282925119669871423)
,p_name=>'CREATE_FLOW.TWO_LEVEL_TABS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dois N\00EDveis de Guias')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282301505439871021)
,p_name=>'CREATE_FROM_SPREADSHEET'
,p_message_language=>'pt-br'
,p_message_text=>'Em uma planilha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282178576266870942)
,p_name=>'CREATE_GLOBAL_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os componentes da p\00E1gina global ser\00E3o exibidos em todas as p\00E1ginas se o ponto de exibi\00E7\00E3o da regi\00E3o estiver dentro do modelo de p\00E1gina selecionado. Os atributos Exibi\00E7\00E3o Condicional podem ser usados para suprimir a exibi\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282453285224871118)
,p_name=>'CREATE_INDEX'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar \00CDndice')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282608826333871218)
,p_name=>'CREATE_ITEM_WIZ.NO_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('nenhuma regi\00E3o associada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282427811007871102)
,p_name=>'CREATE_NEW_LOGIN_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar nova p\00E1gina de log-in.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282421757167871098)
,p_name=>'CREATE_PACKAGE.BACK'
,p_message_language=>'pt-br'
,p_message_text=>'Voltar para Criar Assistente de Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282421267893871097)
,p_name=>'CREATE_PACKAGE.BROWSE'
,p_message_language=>'pt-br'
,p_message_text=>'Procurar Pacote'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282421173892871097)
,p_name=>'CREATE_PACKAGE.CREATED'
,p_message_language=>'pt-br'
,p_message_text=>'O pacote "%0" foi criado no esquema "%1".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282421882897871098)
,p_name=>'CREATE_PACKAGE.FAILED'
,p_message_language=>'pt-br'
,p_message_text=>'Falha ao criar tabela "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282421635081871098)
,p_name=>'CREATE_PACKAGE.HOME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('In\00EDcio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282421409844871098)
,p_name=>'CREATE_PACKAGE.RETURN_TO'
,p_message_language=>'pt-br'
,p_message_text=>'Retornar a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282421594889871098)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP'
,p_message_language=>'pt-br'
,p_message_text=>'SQL&nbsp;Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282421326676871097)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME'
,p_message_language=>'pt-br'
,p_message_text=>'Home do SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282417017283871095)
,p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum item encontrado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282416625830871094)
,p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Itens da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282416925296871095)
,p_name=>'CREATE_PAGE_ITEM.PROMPT'
,p_message_language=>'pt-br'
,p_message_text=>'Prompt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282416754641871095)
,p_name=>'CREATE_PAGE_ITEM.REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282416809289871095)
,p_name=>'CREATE_PAGE_ITEM.SET_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('clique para definir regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282414714702871093)
,p_name=>'CREATE_PROCESS.PAGE_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Itens da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282414895577871093)
,p_name=>'CREATE_PROCESS.REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282421093687871097)
,p_name=>'CREATE_TABLE.HOME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('In\00EDcio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282420800752871097)
,p_name=>'CREATE_TABLE.RETURN_TO'
,p_message_language=>'pt-br'
,p_message_text=>'Retornar a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282420794917871097)
,p_name=>'CREATE_TABLE.RUN_SCRIPT'
,p_message_language=>'pt-br'
,p_message_text=>'Executar Script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282420446595871097)
,p_name=>'CREATE_TABLE.SCRIPT_CREATED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Foi criado criar script de tabela para a tabela %0 no reposit\00F3rio de script SQL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282420506339871097)
,p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ir Para o Reposit\00F3rio de Scripts')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282420900891871097)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP'
,p_message_language=>'pt-br'
,p_message_text=>'SQL&nbsp;Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282420681710871097)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME'
,p_message_language=>'pt-br'
,p_message_text=>'Home do SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282877888166871393)
,p_name=>'CREATE_TABULAR_FORM'
,p_message_language=>'pt-br'
,p_message_text=>'Form Tabular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283483480795871797)
,p_name=>'CREATE_TO_DO'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Tarefa'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282812694018871351)
,p_name=>'CREATE_TRIGGER'
,p_message_language=>'pt-br'
,p_message_text=>'Criar trigger %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282750880894871311)
,p_name=>'CREATE_WS_OBJ_SUCCESS_MSG'
,p_message_language=>'pt-br'
,p_message_text=>'Objetos criados do banco de dados da websheet.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282703090846871279)
,p_name=>'CREDENTIAL.OWNER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Propriet\00E1rio da Credencial')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282665407731871255)
,p_name=>'CSS_CALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Calend\00E1rio')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282578357393871199)
,p_name=>'CURRENT'
,p_message_language=>'pt-br'
,p_message_text=>'Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282657266899871249)
,p_name=>'CURRENT ENTRY'
,p_message_language=>'pt-br'
,p_message_text=>'Entrada Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282656996010871249)
,p_name=>'CURRENT FORM ELEMENT'
,p_message_language=>'pt-br'
,p_message_text=>'Elemento de form atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282441196460871110)
,p_name=>'CURRENT ITEM HELP TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Texto de Ajuda do Item Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282657092690871249)
,p_name=>'CURRENT ITEM IDENTIFICATION NUMBER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero de Identifica\00E7\00E3o do Item Atual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282657155677871249)
,p_name=>'CURRENT ITEM LABEL NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Label de Item Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282716186184871287)
,p_name=>'CURRENT TAB'
,p_message_language=>'pt-br'
,p_message_text=>'Guia Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282402906920871086)
,p_name=>'CURRENT_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282409968360871090)
,p_name=>'CURRENT_IMAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Imagem Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283016637862871482)
,p_name=>'CURRENT_ITEM_CONTAINER_ID'
,p_message_language=>'pt-br'
,p_message_text=>'O ID que pode ser usado em um elemento de container que encapsula o campo atual, no atributo Label e Item Anteriores.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283491932315871803)
,p_name=>'CURRENT_ITEM_HELP_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Label da Ajuda do Item Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282368793575871064)
,p_name=>'CURRENT_MILESTONE'
,p_message_language=>'pt-br'
,p_message_text=>'Marco Atual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282409071807871090)
,p_name=>'CURRENT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina Atual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282683701777871266)
,p_name=>'CURRENT_PAGE_CONTAINS_NO_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina Atual Cont\00E9m N\00E3o Tem Itens.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282574181934871196)
,p_name=>'CUSTOM'
,p_message_language=>'pt-br'
,p_message_text=>'Personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282616888619871224)
,p_name=>'CUSTOMIZE'
,p_message_language=>'pt-br'
,p_message_text=>'Personalizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282652759847871246)
,p_name=>'CUSTOMIZE LINK'
,p_message_language=>'pt-br'
,p_message_text=>'Personalizar Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282662395182871253)
,p_name=>'CUSTOMIZE.USER_PAGE_PREFS_RESET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prefer\00EAncias de p\00E1gina redefinidas para o usu\00E1rio %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282662455009871253)
,p_name=>'CUSTOMIZE.USER_PREFS_CHANGED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prefer\00EAncias alteradas para o usu\00E1rio %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282662235958871253)
,p_name=>'CUSTOMIZE.USER_PREFS_RESET'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prefer\00EAncias de p\00E1gina redefinidas para o usu\00E1rio %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283366695794871717)
,p_name=>'CUSTOM_APPLICATIONS'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativos Personalizados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282203082844870958)
,p_name=>'CUSTOM_AUTH_SCHEME_DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Desenvolvedor Definido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282457483361871120)
,p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro em %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282368978156871064)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informe qualquer string a ser usada como seu identificador de usu\00E1rio para esta sess\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282369058182871064)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informe o %0 nome do usu\00E1rio e a senha.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282369134158871064)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informe o nome do usu\00E1rio e a senha para verifica\00E7\00E3o pelo host LDAP: %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282369226485871064)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informe o nome do usu\00E1rio e a senha do esquema de banco de dados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283135777307871560)
,p_name=>'CUSTOM_CALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>'Recarregar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283140828378871563)
,p_name=>'CUSTOM_CALENDAR.END_DATE'
,p_message_language=>'pt-br'
,p_message_text=>'Data Final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283140789795871563)
,p_name=>'CUSTOM_CALENDAR.START_DATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Data de In\00EDcio')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282813582619871352)
,p_name=>'DA.SET_VALUE.SQL.HELP_MSG'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Quando a A\00E7\00E3o Verdadeira for Definir Valor com Definir Tipo de Instru\00E7\00E3o de SQL, \00E9 necess\00E1rio definir os Elementos Afetados na mesma ordem da ordem da coluna de sua instru\00E7\00E3o SQL. A Instru\00E7\00E3o SQL definida foi:</p>'),
'<pre>%0</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282374367800871067)
,p_name=>'DAILY'
,p_message_language=>'pt-br'
,p_message_text=>'Diariamente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282591503505871208)
,p_name=>'DATA'
,p_message_language=>'pt-br'
,p_message_text=>'Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282898675456871406)
,p_name=>'DATA WORKSHOP'
,p_message_language=>'pt-br'
,p_message_text=>'Data Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282469034246871128)
,p_name=>'DATA.LOAD.ALL_COL_MAPPED'
,p_message_language=>'pt-br'
,p_message_text=>'Todas as %0 colunas foram mapeadas automaticamente para a tabela %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282469890840871128)
,p_name=>'DATA.LOAD.APPEND_INCOMPLETE'
,p_message_language=>'pt-br'
,p_message_text=>'Dados da tabela <code>%0</code> com <b id="incompl_success_row_count"></b> novas linhas anexadas.  <b class="u-danger-text" id="incompl_fail_row_count"></b> linhas rejeitadas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282469405721871128)
,p_name=>'DATA.LOAD.APPEND_SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Dados da tabela <code>%0</code> com <b id="success_row_count"></b> novas linhas anexadas!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282469626068871128)
,p_name=>'DATA.LOAD.APPEND_WARNING'
,p_message_language=>'pt-br'
,p_message_text=>'Dados da tabela <code>%0</code> com <b id="err_success_row_count"></b> novas linhas anexadas. <b class="u-danger-text" id="err_fail_row_count"></b> linhas rejeitadas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282179010838870943)
,p_name=>'DATA.LOAD.CHOOSE_FILE'
,p_message_language=>'pt-br'
,p_message_text=>'Escolher Arquivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282216639823870966)
,p_name=>'DATA.LOAD.CONFIGURATION_SAVED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Configura\00E7\00E3o Salva!')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282469108321871128)
,p_name=>'DATA.LOAD.DEFINE_COL_MAPPING'
,p_message_language=>'pt-br'
,p_message_text=>'Defina o mapeamento de coluna para carregar esses dados na tabela %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282178941237870942)
,p_name=>'DATA.LOAD.DRAG_DROP_FILE_HERE'
,p_message_language=>'pt-br'
,p_message_text=>'Arraste e solte o arquivo aqui ou'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282178848802870942)
,p_name=>'DATA.LOAD.FILE_FORMATS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os formatos suportados s\00E3o csv, xlsx, txt, xml e json')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282179907400870943)
,p_name=>'DATA.LOAD.INVALID_FILE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O arquivo transferido por upload \00E9 inv\00E1lido ou sua extens\00E3o est\00E1 incorreta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282348297090871051)
,p_name=>'DATA.LOAD.INVALID_SELECTOR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Seletor de XML ou JSON inv\00E1lido utilizado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282896584805871405)
,p_name=>'DATA.LOAD.JOB_INTERMITTENTLY_FAILED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A execu\00E7\00E3o do job de Carregamento de Dados foi interrompida inesperadamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282820767662871356)
,p_name=>'DATA.LOAD.JOB_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Job de Carregamento de Dados no Espa\00E7o de Trabalho %0: Carregar na Tabela %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282469295907871128)
,p_name=>'DATA.LOAD.MAP_REMAINING_COLS'
,p_message_language=>'pt-br'
,p_message_text=>'%0 de %1 colunas foram mapeadas automaticamente para a tabela %2. Configure as %3 colunas restantes.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282814374923871352)
,p_name=>'DATA.LOAD.NO_FILE_CONTENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum dado encontrado no arquivo submetido a upload.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282814496294871352)
,p_name=>'DATA.LOAD.NO_WORKSHEET_CONTENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhum dado encontrado na planilha "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282179362524870943)
,p_name=>'DATA.LOAD.NO_XLSX_FILE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O arquivo especificado n\00E3o \00E9 um arquivo XLSX.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282861195450871382)
,p_name=>'DATA.LOAD.PASTED_DATA'
,p_message_language=>'pt-br'
,p_message_text=>'Dados Colados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282469952065871128)
,p_name=>'DATA.LOAD.REPLACE_INCOMPLETE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dados da tabela <code>%0</code> substitu\00EDdos por <b id="incompl_success_row_count"></b> novas linhas.  <b class="u-danger-text" id="incompl_fail_row_count"></b> linhas rejeitadas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282469594679871128)
,p_name=>'DATA.LOAD.REPLACE_SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dados da tabela <code>%0</code> substitu\00EDdos por <b id="success_row_count"></b> novas linhas!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282469747884871128)
,p_name=>'DATA.LOAD.REPLACE_WARNING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Dados da tabela <code>%0</code> substitu\00EDdos por <b id="err_success_row_count"></b> novas linhas. <b class="u-danger-text" id="err_fail_row_count"></b> linhas rejeitadas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282469387739871128)
,p_name=>'DATA.LOAD.SELECT_COLS'
,p_message_language=>'pt-br'
,p_message_text=>'Selecione as colunas a serem carregadas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283476208108871792)
,p_name=>'DATABASE'
,p_message_language=>'pt-br'
,p_message_text=>'Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282899269849871406)
,p_name=>'DATABASE BROWSER'
,p_message_language=>'pt-br'
,p_message_text=>'Browser do Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283414894461871750)
,p_name=>'DATABASE.DEMO.SAMPLE.APP'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo de Banco de Dados de Amostra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283476368204871792)
,p_name=>'DATABASE_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo de Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282223336359870971)
,p_name=>'DATABASE_APPLICATIONS'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativos de Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282251185845870988)
,p_name=>'DATABASE_APPS'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativos de Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282745741631871308)
,p_name=>'DATABASE_APP_SUCCESS_MSG'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo <strong>%0</strong> instalado com sucesso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282642683869871240)
,p_name=>'DATABASE_LINK'
,p_message_language=>'pt-br'
,p_message_text=>'Link de Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282695450356871274)
,p_name=>'DATABASE_OBJECT_COUNTS_BY_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Contagens de Objetos do Banco de Dados por Tipo de Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282698677750871276)
,p_name=>'DATABASE_ROLE_PRIVILEGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Privil\00E9gios de Atribui\00E7\00E3o do Banco de Dados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282245601933870985)
,p_name=>'DATABASE_USERS'
,p_message_language=>'pt-br'
,p_message_text=>'Banco de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282806367060871347)
,p_name=>'DATA_GRID'
,p_message_language=>'pt-br'
,p_message_text=>'Grade de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283405420581871744)
,p_name=>'DATA_GRIDS'
,p_message_language=>'pt-br'
,p_message_text=>'Grades de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283405943101871744)
,p_name=>'DATA_GRID_DATA'
,p_message_language=>'pt-br'
,p_message_text=>'Dados da Grade de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283395979990871737)
,p_name=>'DATA_LOAD.ADVANCED_SETTINGS_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es Avan\00E7adas de Carga de Dados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282332543589871041)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Formatos de Data / N\00FAmero a serem usados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282332621853871041)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT_HELP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Escolha se vai fornecer m\00E1scaras de formato personalizado ou usar as de formato padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282247021945870986)
,p_name=>'DATA_LOAD.CHARSET'
,p_message_language=>'pt-br'
,p_message_text=>'Conjunto de Caracteres do Arquivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282887272649871399)
,p_name=>'DATA_LOAD.COLUMN_NAMES'
,p_message_language=>'pt-br'
,p_message_text=>'Nomes de Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282885766457871398)
,p_name=>'DATA_LOAD.COLUMN_NAMES_MAPPING'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna de Destino'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282743802468871307)
,p_name=>'DATA_LOAD.COLUMN_NAME_ALIASES'
,p_message_language=>'pt-br'
,p_message_text=>'Aliases dos Nomes da Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283100257911871536)
,p_name=>'DATA_LOAD.CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>'Os dados foram submetidos a upload com sucesso para sua tabela.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283107520727871541)
,p_name=>'DATA_LOAD.COPY_PASTE'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar e Colar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283093867453871532)
,p_name=>'DATA_LOAD.COPY_PASTE_TEXTAREA'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar e Colar Dados Delimitados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283436237208871764)
,p_name=>'DATA_LOAD.CURRENCY_ITEM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('S\00EDmbolo da Moeda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283436399912871764)
,p_name=>'DATA_LOAD.CURRENCY_ITEM_HELP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Se seus dados contiverem o s\00EDmbolo de moeda internacional, informe-o aqui. Por exemplo, se seus dados tiverem "&euro;1,234.56" ou "&yen;1,234.56", informe "&euro;" ou "&yen;". Do contr\00E1rio, os dados n\00E3o ser\00E3o carregados corretamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282252001048870989)
,p_name=>'DATA_LOAD.DATA_LOADING'
,p_message_language=>'pt-br'
,p_message_text=>'Carga de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283396032924871737)
,p_name=>'DATA_LOAD.DATE_FORMAT_APP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usar m\00E1scaras de formato padr\00E3o do aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283396174452871737)
,p_name=>'DATA_LOAD.DATE_FORMAT_CUSTOM'
,p_message_language=>'pt-br'
,p_message_text=>'Fornecer formatos personalizados para colunas submetidas a upload'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283437880380871765)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_HELP'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>O caractere de decimal separa o inteiro e as partes decimais de um n\00FAmero.</p>'),
unistr('<p> Qualquer caractere pode ser o caractere de decimal. O caractere especificado deve ser monobyte, e o caractere de decimal deve ser diferente do separador de grupo. O caractere pode ser um espa\00E7o, mas n\00E3o pode ser um n\00FAmero ou um dos seguintes cara')
||'cteres:</p>',
'<ul class="noIndent">',
'<li>mais (+)</li>',
unistr('<li>h\00EDfen (-)</li> '),
'<li>sinal de menor que (<)</li>',
'<li>sinal de maior que (>)</li> ',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283436940225871765)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_ITEM'
,p_message_language=>'pt-br'
,p_message_text=>'Caractere de Decimal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282744062255871307)
,p_name=>'DATA_LOAD.DISPLAY'
,p_message_language=>'pt-br'
,p_message_text=>'Visualizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282887110431871399)
,p_name=>'DATA_LOAD.DO_NOT_LOAD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o Carregar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283431890195871761)
,p_name=>'DATA_LOAD.FAILED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Erro de pr\00E9-processamento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283344388266871702)
,p_name=>'DATA_LOAD.FAILED_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Linha(s) com Falha:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283415861435871751)
,p_name=>'DATA_LOAD.FAILED_RECORD'
,p_message_language=>'pt-br'
,p_message_text=>'Registros com Falha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283435855973871764)
,p_name=>'DATA_LOAD.FILE_NAME_ITEM'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do arquivo para upload'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282886062830871398)
,p_name=>'DATA_LOAD.FIRST_COLUMN_NAMES'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna de Origem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283104229122871539)
,p_name=>'DATA_LOAD.FIRST_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'A Primeira Linha tem Nomes de Coluna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283435994668871764)
,p_name=>'DATA_LOAD.FIRST_ROW_HELP'
,p_message_language=>'pt-br'
,p_message_text=>'Selecione esta caixa se seus dados contiverem nomes de coluna na primeira linha.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282887317690871399)
,p_name=>'DATA_LOAD.FORMAT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Formato de Data/N\00FAmero')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283436102386871764)
,p_name=>'DATA_LOAD.GLOBALIZATION_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Globaliza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283436898175871765)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_HELP'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Um separador de grupo \00E9 um caractere que separa grupos de inteiros, por exemplo, para mostrar milhares e milh\00F5es.</p>'),
unistr('<p>Qualquer caractere pode ser o separador de grupo. O caractere especificado deve ser monobyte, e o separador de grupo deve ser diferente de qualquer outro caractere de decimal. O caractere pode ser um espa\00E7o, mas n\00E3o pode ser um n\00FAmero ou um dos se')
||'guintes:</p>',
'<ul class="noIndent">',
'<li>mais (+)</li>',
unistr('<li>h\00EDfen (-)</li> '),
'<li>sinal de menor que (<)</li>',
'<li>sinal de maior que (>)</li> ',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283436441857871764)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_ITEM'
,p_message_language=>'pt-br'
,p_message_text=>'Separador de Grupo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283431569722871761)
,p_name=>'DATA_LOAD.INSERT'
,p_message_language=>'pt-br'
,p_message_text=>'Inserir linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283344110867871702)
,p_name=>'DATA_LOAD.INSERTED_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Linha(s) Inserida(s):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283433308625871762)
,p_name=>'DATA_LOAD.IR_MAX_ROW_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Essa consulta retorna mais de #MAX_ROW_COUNT# linhas. Filtre seus dados para garantir resultados completos.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282742729173871306)
,p_name=>'DATA_LOAD.JUSTCHANGED_RECORD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Registros Alterados por Outro Usu\00E1rio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282359049906871058)
,p_name=>'DATA_LOAD.LABEL_CASE_SENSITIVE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Distin\00E7\00E3o entre Mai\00FAsculas e Min\00FAsculas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282358951836871057)
,p_name=>'DATA_LOAD.LABEL_UNIQUE_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coluna \00DAnica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283067349811871515)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Falha ao Carregar Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283067453392871515)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00E3o Processada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283093042061871532)
,p_name=>'DATA_LOAD.LOAD_TO'
,p_message_language=>'pt-br'
,p_message_text=>'Importar de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283496914270871806)
,p_name=>'DATA_LOAD.LOOKUP_FAILED'
,p_message_language=>'pt-br'
,p_message_text=>'Falha ao recuperar o valor de consulta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283113455082871545)
,p_name=>'DATA_LOAD.MAPPING'
,p_message_language=>'pt-br'
,p_message_text=>'Mapeamento de Dados / Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282804573228871346)
,p_name=>'DATA_LOAD.MAPPING_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Etapa 2 - Nome da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283495609255871805)
,p_name=>'DATA_LOAD.NO_PREVIEW'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nenhuma visualiza\00E7\00E3o de arquivo dispon\00EDvel')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283435059497871763)
,p_name=>'DATA_LOAD.OPTIONAL_ENCLOSE_ITEM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Opcionalmente Inclu\00EDdo Por')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283399301007871739)
,p_name=>'DATA_LOAD.PROGRESS_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Andamento do Assistente de Carga de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282804799204871346)
,p_name=>'DATA_LOAD.RESULTS_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Etapa 4 - Nome da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282743994531871307)
,p_name=>'DATA_LOAD.RETURN'
,p_message_language=>'pt-br'
,p_message_text=>'Retornar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282742251926871306)
,p_name=>'DATA_LOAD.REVIEW_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Linhas a Serem Revisadas:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282887427588871399)
,p_name=>'DATA_LOAD.ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282883981546871397)
,p_name=>'DATA_LOAD.RULES_PLSQL_EXPRESSION_EXAMPLES'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'to_char(sysdate);',
'',
'my_func(p_1  => :SAL,',
'        p_2  => :COMM);',
'',
unistr('onde SAL e COMM s\00E3o nomes de coluna de dados submetidos a upload'),
unistr('e   my_func \00E9 a fun\00E7\00E3o que retornar o valor que ser\00E1 o novo valor'),
unistr('da coluna para a qual esta regra de transforma\00E7\00E3o \00E9 definida.'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282884162734871397)
,p_name=>'DATA_LOAD.RULES_PLSQL_FUNCTION_EXAMPLES'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'declare',
'    l_result number;',
'begin',
'    l_result := :SAL * :COMM;',
'    return l_result;',
'end;',
'',
unistr('O resultado retornado ser\00E1 o novo valor da coluna para a qual esta regra de transforma\00E7\00E3o \00E9 definida.'),
'',
'E :SAL e :COMM referem-se aos nomes das colunas SAL e COMM dos dados submetidos a upload.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282884099817871397)
,p_name=>'DATA_LOAD.RULES_SQL_QUERY_EXAMPLES'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'',
'select depno',
'  from dept',
'  where dname = :DEPTNAME',
'  and   loc = :LOC',
'',
'onde :DEPNAME e :LOC referem-se aos nomes da coluna DEPNAME e LOC dos dados submetidos a upload.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283434872393871763)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_HELP'
,p_message_language=>'pt-br'
,p_message_text=>'Identifique um caractere separador de coluna. Use <strong>\t</strong> para separadores de guia.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283434915461871763)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Separador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282744108464871307)
,p_name=>'DATA_LOAD.SEQUENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sequ\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283488699196871800)
,p_name=>'DATA_LOAD.SEQUENCE_ACTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sequ\00EAncia: A\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283395769386871737)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usar Defini\00E7\00F5es Avan\00E7adas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283395830079871737)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS_HELP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir defini\00E7\00F5es avan\00E7adas para carregamento de dados: S\00EDmbolo de Moeda, Caracteres Decimais, Codifica\00E7\00E3o de Arquivo ou Formatos de Data')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283112893637871544)
,p_name=>'DATA_LOAD.SOURCE'
,p_message_language=>'pt-br'
,p_message_text=>'Origem da Carga de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282804492653871346)
,p_name=>'DATA_LOAD.SOURCE_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Etapa 1 - Nome da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283476581376871792)
,p_name=>'DATA_LOAD.TAB_SEPARTOR_NOTE'
,p_message_language=>'pt-br'
,p_message_text=>'(\t para a guia)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282817582101871354)
,p_name=>'DATA_LOAD.TRANSFORMATION_FAILED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Falha na regra de transforma\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283433624200871763)
,p_name=>'DATA_LOAD.UNIQUE_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Coluna Exclusiva %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283431631136871761)
,p_name=>'DATA_LOAD.UPDATE'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar linha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283344218944871702)
,p_name=>'DATA_LOAD.UPDATED_COUNT'
,p_message_language=>'pt-br'
,p_message_text=>'Linha(s) Atualizada(s):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283544338669871838)
,p_name=>'DATA_LOAD.UPLOADED_NULL_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Foi feito upload de um valor nulo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283107488407871541)
,p_name=>'DATA_LOAD.UPLOAD_FILE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Arquivo obtido por upload, separado por v\00EDrgulas (*.csv) ou delimitado por tabula\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283113057931871545)
,p_name=>'DATA_LOAD.UPLOAD_RESULTS'
,p_message_language=>'pt-br'
,p_message_text=>'Resultados de Carga de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283112926490871544)
,p_name=>'DATA_LOAD.VALIDATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valida\00E7\00E3o de Dados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282804663856871346)
,p_name=>'DATA_LOAD.VALIDATION_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Etapa 3 - Nome da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282808706513871349)
,p_name=>'DATA_LOAD_WIZARD_CREATED_SUCCESSFULLY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('As p\00E1ginas do assistente de carga de dados foram criadas com sucesso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283067539021871515)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Falha de Mapeamento de Dados / Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283067623765871515)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00E3o Processada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282666994816871255)
,p_name=>'DATA_UPLOAD_COLUMN_MAPPING'
,p_message_language=>'pt-br'
,p_message_text=>'Mapeamento de Coluna de Upload de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282592419209871208)
,p_name=>'DATE'
,p_message_language=>'pt-br'
,p_message_text=>'Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282797000607871341)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O valor do atributo Data Real\00E7ada informado %0 para o item %1 n\00E3o corresponde ao formato %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282802873295871345)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID_RELATIVE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O valor do atributo Data Real\00E7ada informado %0 para o item %1 n\00E3o \00E9 uma data relativa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282797224537871341)
,p_name=>'DATEPICKER.MAX_DATE_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O valor do atributo Data M\00E1xima informado %0 para o item %1 n\00E3o corresponde ao formato %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282803001544871345)
,p_name=>'DATEPICKER.MAX_DATE_INVALID_RELATIVE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O valor do atributo Data M\00E1xima informado %0 para o item %1 n\00E3o \00E9 uma data relativa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282797184125871341)
,p_name=>'DATEPICKER.MIN_DATE_INVALID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O valor do atributo Data M\00EDnima informado %0 para o item %1 n\00E3o corresponde ao formato %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282802975130871345)
,p_name=>'DATEPICKER.MIN_DATE_INVALID_RELATIVE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O valor do atributo Data M\00EDnima informado %0 para o item %1 n\00E3o \00E9 uma data relativa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282930997987871427)
,p_name=>'DATE_ADDED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Data de Adi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283403705639871742)
,p_name=>'DATE_OF_LAST_RUN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Jobs do banco de dados do Oracle Application Express com o hor\00E1rio da \00FAltima execu\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282422924440871098)
,p_name=>'DAY'
,p_message_language=>'pt-br'
,p_message_text=>'dia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282423027254871099)
,p_name=>'DAYS'
,p_message_language=>'pt-br'
,p_message_text=>'dias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282719692895871289)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('at\00E9 o marco final')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282719717909871289)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE_OF_RELASE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('at\00E9 o marco final da release %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282802165881871344)
,p_name=>'DA_NAME.NATIVE_ADD_CLASS'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Classe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283408771854871746)
,p_name=>'DA_NAME.NATIVE_ALERT'
,p_message_language=>'pt-br'
,p_message_text=>'Alerta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283407425220871745)
,p_name=>'DA_NAME.NATIVE_CANCEL_EVENT'
,p_message_language=>'pt-br'
,p_message_text=>'Cancelar Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283408957803871746)
,p_name=>'DA_NAME.NATIVE_CLEAR'
,p_message_language=>'pt-br'
,p_message_text=>'Limpar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283408885525871746)
,p_name=>'DA_NAME.NATIVE_CONFIRM'
,p_message_language=>'pt-br'
,p_message_text=>'Confirmar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282168548593870936)
,p_name=>'DA_NAME.NATIVE_DIALOG_CANCEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Cancelar Caixa de Di\00E1logo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282168645206870936)
,p_name=>'DA_NAME.NATIVE_DIALOG_CLOSE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Fechar Caixa de Di\00E1logo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282328212794871038)
,p_name=>'DA_NAME.NATIVE_DISABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Desativar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282328112981871038)
,p_name=>'DA_NAME.NATIVE_ENABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Ativar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283401029774871741)
,p_name=>'DA_NAME.NATIVE_EXECUTE_PLSQL_CODE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Executar C\00F3digo PL/SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282328054517871038)
,p_name=>'DA_NAME.NATIVE_HIDE'
,p_message_language=>'pt-br'
,p_message_text=>'Ocultar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282714404630871286)
,p_name=>'DA_NAME.NATIVE_JAVASCRIPT_CODE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Executar C\00F3digo JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283074486175871520)
,p_name=>'DA_NAME.NATIVE_REFRESH'
,p_message_language=>'pt-br'
,p_message_text=>'Atualizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282802255573871344)
,p_name=>'DA_NAME.NATIVE_REMOVE_CLASS'
,p_message_language=>'pt-br'
,p_message_text=>'Remover Classe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282802380482871344)
,p_name=>'DA_NAME.NATIVE_SET_CSS'
,p_message_language=>'pt-br'
,p_message_text=>'Definir Estilo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283047354253871502)
,p_name=>'DA_NAME.NATIVE_SET_FOCUS'
,p_message_language=>'pt-br'
,p_message_text=>'Definir Foco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282714334287871286)
,p_name=>'DA_NAME.NATIVE_SET_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Definir Valor'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282327967155871038)
,p_name=>'DA_NAME.NATIVE_SHOW'
,p_message_language=>'pt-br'
,p_message_text=>'Mostrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283047450764871502)
,p_name=>'DA_NAME.NATIVE_SUBMIT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Submeter P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282984908086871462)
,p_name=>'DA_NAME.NATIVE_TREE_COLLAPSE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Contrair \00C1rvore')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282984818971871462)
,p_name=>'DA_NAME.NATIVE_TREE_EXPAND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Expandir \00C1rvore')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282205446684870959)
,p_name=>'DBACCOUNT_AUTH_SCHEME_DESC'
,p_message_language=>'pt-br'
,p_message_text=>'Conta de Banco de Dados'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282710541190871283)
,p_name=>'DB_COLS_CASE_SEN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nomes de coluna e tabela de banco de dados fazem distin\00E7\00E3o entre mai\00FAsculas e min\00FAsculas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282822861066871358)
,p_name=>'DB_OBJECT_CREATION_EXCEPTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('exce\00E7\00E3o na cria\00E7\00E3o de objeto de bd')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282219125520870968)
,p_name=>'DB_PRODUCT_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Oracle Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283466769113871785)
,p_name=>'DB_SERVICES_ALIAS'
,p_message_language=>'pt-br'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283463185450871783)
,p_name=>'DB_SERVICES_ALL_MIMES'
,p_message_language=>'pt-br'
,p_message_text=>'Todos os Mimes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283466673221871785)
,p_name=>'DB_SERVICES_CREATE_HANDLER'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283463415428871783)
,p_name=>'DB_SERVICES_CREATE_METHOD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar M\00E9todo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283463264748871783)
,p_name=>'DB_SERVICES_CREATE_PARAMETER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Criar Par\00E2metro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283463305456871783)
,p_name=>'DB_SERVICES_CREATE_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Criar Modelo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283470432654871788)
,p_name=>'DB_SERVICES_DB_SERVICES_MODULE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00F3dulo de Servi\00E7os RESTful')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283466530940871785)
,p_name=>'DB_SERVICES_HANDLER'
,p_message_language=>'pt-br'
,p_message_text=>'Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283470949040871788)
,p_name=>'DB_SERVICES_HANDLER_BIND_VARIABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Vari\00E1vel de Bind do Handler')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283440349671871767)
,p_name=>'DB_SERVICES_HANDLER_METHOD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9todo do Handler')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283471286726871789)
,p_name=>'DB_SERVICES_HANDLER_SOURCE'
,p_message_language=>'pt-br'
,p_message_text=>'Origem do Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283440485858871767)
,p_name=>'DB_SERVICES_HANDLER_SRC_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Origem do Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283462979514871783)
,p_name=>'DB_SERVICES_METHOD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9todo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283470595842871788)
,p_name=>'DB_SERVICES_MODULE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome do M\00F3dulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283471053902871788)
,p_name=>'DB_SERVICES_MODULE_URI'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Prefixo de URI do M\00F3dulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283463597423871783)
,p_name=>'DB_SERVICES_NO_SOURCE'
,p_message_language=>'pt-br'
,p_message_text=>'Nenhuma Origem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283462864806871783)
,p_name=>'DB_SERVICES_PARAMETER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Par\00E2metro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283470715659871788)
,p_name=>'DB_SERVICES_RESTFUL_SERVICES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Servi\00E7os RESTful')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283463037763871783)
,p_name=>'DB_SERVICES_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283471115269871788)
,p_name=>'DB_SERVICES_TEMPLATE_URI'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo de URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283440263301871767)
,p_name=>'DB_SERVICES_URI'
,p_message_language=>'pt-br'
,p_message_text=>'URI (Uniform Resource Identifier)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283470264008871788)
,p_name=>'DB_SERVICES_URI_PRIFIX'
,p_message_language=>'pt-br'
,p_message_text=>'Prefixo de URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283470317564871788)
,p_name=>'DB_SERVICES_URI_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo de URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283440521298871767)
,p_name=>'DB_SERVICE_QUERY_ONE_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Consultar Uma Linha'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282615994261871223)
,p_name=>'DEBUG'
,p_message_language=>'pt-br'
,p_message_text=>'Depurar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282730959841871296)
,p_name=>'DEBUGGING_OFF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A depura\00E7\00E3o n\00E3o est\00E1 ativada para este aplicativo.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282727601071871294)
,p_name=>'DECLINED'
,p_message_language=>'pt-br'
,p_message_text=>'Recusado'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283542225467871837)
,p_name=>'DEFAULT_DIALOGBTNR_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo da Regi\00E3o do Bot\00E3o do Di\00E1logo Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283542148175871837)
,p_name=>'DEFAULT_DIALOGR_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo da Regi\00E3o do Conte\00FAdo do Di\00E1logo Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283068367010871516)
,p_name=>'DEFAULT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1gina Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282596893132871211)
,p_name=>'DEFAULT_TABLESPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('tablespace padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282598577659871212)
,p_name=>'DEFAULT_TABLESPACE_INIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tablespace Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282886207502871398)
,p_name=>'DEFAULT_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo Padr\00E3o')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282201113622870957)
,p_name=>'DEFINED_BY_DA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Definido por A\00E7\00E3o Din\00E2mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283131917273871557)
,p_name=>'DEFINED_TABS'
,p_message_language=>'pt-br'
,p_message_text=>'Este aplicativo tem %0 guias organizadas em %1 conjuntos de guias e %2 de guias pai definidas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282488144876871140)
,p_name=>'DEFINE_LOV'
,p_message_language=>'pt-br'
,p_message_text=>'Definir Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282653098264871247)
,p_name=>'DEFINITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00E3o')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282820622411871356)
,p_name=>'DEINSTALLATION_SCRIPT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Script de Desinstala\00E7\00E3o')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282424712583871100)
,p_name=>'DELETE'
,p_message_language=>'pt-br'
,p_message_text=>'excluir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282316312934871030)
,p_name=>'DELETED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exclu\00EDdo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283404981155871743)
,p_name=>'DELETE_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282877985376871393)
,p_name=>'DELETE_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282853744064871377)
,p_name=>'DELETE_LINK_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282229759394870975)
,p_name=>'DELETE_MSG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gostaria de executar esta a\00E7\00E3o de exclus\00E3o?')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282267407290870999)
,p_name=>'DEMO.COLLECT.DESCR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Mostru\00E1rio de Cole\00E7\00F5es permite armazenar linhas de dados para usar dentro de uma sess\00E3o do Oracle Application Express. Este aplicativo de banco de dados ilustra como usar PL/SQL para criar e gerenciar o estado da sess\00E3o com base na coleta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282267217256870999)
,p_name=>'DEMO.SAMPLE.APP'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo de Amostra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282267343211870999)
,p_name=>'DEMO.SAMPLE.APP.DESCR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Portal de Produtos \00E9 um aplicativo de amostra que destaca conceitos de design comuns. Ele inclui p\00E1ginas dedicadas para clientes, produtos e pedidos, al\00E9m de demonstrar o uso de relat\00F3rios, gr\00E1ficos, calend\00E1rios, mapas e \00E1rvores.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282675770733871261)
,p_name=>'DEMONSTRABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Demonstr\00E1vel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282405599776871087)
,p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exemplos de conceitos de relat\00F3rios robustos e de pagina\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282405247464871087)
,p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exemplo de armazenamento on-line constru\00EDdo com o uso de %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282405999456871088)
,p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL'
,p_message_language=>'pt-br'
,p_message_text=>'Aprenda sobre o uso do Oracle Text com %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282406326440871088)
,p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exemplo de aplicativo de rastreamento de status de projetos constru\00EDda com %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282405776166871088)
,p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES'
,p_message_language=>'pt-br'
,p_message_text=>'Aprenda a usar os Web services com %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282404037197871086)
,p_name=>'DEMO_APPLICATION.ACTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282401837838871085)
,p_name=>'DEMO_APPLICATION.APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282401569988871085)
,p_name=>'DEMO_APPLICATION.BASIC_LEXER'
,p_message_language=>'pt-br'
,p_message_text=>'BASIC_LEXER'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282405435616871087)
,p_name=>'DEMO_APPLICATION.BUSINESS_LOOK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Apar\00EAncia de Neg\00F3cios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282404142673871087)
,p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mostru\00E1rio de Cole\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282401688090871085)
,p_name=>'DEMO_APPLICATION.CONTEXT_INDEX'
,p_message_language=>'pt-br'
,p_message_text=>'CONTEXT INDEX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282401093724871084)
,p_name=>'DEMO_APPLICATION.CREATE_BASIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA est\00E1 prestes a criar o Aplicativo de Demonstra\00E7\00E3o de Exemplos B\00E1sicos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282399603867871083)
,p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA est\00E1 prestes a (re)criar o Aplicativo de Demonstra\00E7\00E3o de neg\00F3cios.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282401131799871085)
,p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA est\00E1 prestes a criar a Aplicativo de Demonstra\00E7\00E3o de Mostru\00E1rio de Cole\00E7\00F5es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282401216562871085)
,p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE'
,p_message_language=>'pt-br'
,p_message_text=>'criar ou recriar no esquema %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282399510446871083)
,p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES'
,p_message_language=>'pt-br'
,p_message_text=>'Criar um exemplo de aplicativo de Web services.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282399718127871084)
,p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA est\00E1 prestes a criar o Aplicativo de Demonstra\00E7\00E3o de Mania de Copa do Mundo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282209638705870962)
,p_name=>'DEMO_APPLICATION.DEINSTALL'
,p_message_language=>'pt-br'
,p_message_text=>'Remover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282403864370871086)
,p_name=>'DEMO_APPLICATION.DEMO_APP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Aplicativo de Demonstra\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282402194791871085)
,p_name=>'DEMO_APPLICATION.FREE_SPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA tem cerca de %0 MB livres.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282404668386871087)
,p_name=>'DEMO_APPLICATION.INSTALL'
,p_message_language=>'pt-br'
,p_message_text=>'Instalar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282404328024871087)
,p_name=>'DEMO_APPLICATION.INSTALLED'
,p_message_language=>'pt-br'
,p_message_text=>'Instalado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282519346289871161)
,p_name=>'DEMO_APPLICATION.INSTALL_DEMO_APP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA est\00E1 prestes a instalar Amostras de Aplicativos, o que demonstra os recursos-chave de %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282405361192871087)
,p_name=>'DEMO_APPLICATION.INSTALL_NOW'
,p_message_language=>'pt-br'
,p_message_text=>'Instalar Agora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282404290940871087)
,p_name=>'DEMO_APPLICATION.LEARN_ABOUT'
,p_message_language=>'pt-br'
,p_message_text=>'Aprenda sobre conceitos de carrinho de compras %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282857948722871380)
,p_name=>'DEMO_APPLICATION.LOCKED'
,p_message_language=>'pt-br'
,p_message_text=>'Bloqueado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282401979488871085)
,p_name=>'DEMO_APPLICATION.NEED_7M'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A Demonstra\00E7\00E3o do Discurso de Posse do Presidente requer cerca de 7 MB de espa\00E7o livre em disco e pode levar dois minutos para ser instalada no seu esquema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282519067705871161)
,p_name=>'DEMO_APPLICATION.NOT_ENOUGH_SPACE_ERR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o houve espa\00E7o suficiente para criar esta demonstra\00E7\00E3o. Solicite armazenamento adicional indo at\00E9 a p\00E1gina da administra\00E7\00E3o; l\00E1, v\00E1 para servi\00E7os de provisionamento e clique no link para solicitar armazenamento adicional. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282404560123871087)
,p_name=>'DEMO_APPLICATION.NOT_INSTALLED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o Instalado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282400477932871084)
,p_name=>'DEMO_APPLICATION.OBJECT_EXIST'
,p_message_language=>'pt-br'
,p_message_text=>'Existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282399309685871083)
,p_name=>'DEMO_APPLICATION.OBJECT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>'existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282400393581871084)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282401484664871085)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME2'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282399450722871083)
,p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('n\00E3o existe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282400036736871084)
,p_name=>'DEMO_APPLICATION.OBJECT_RECREATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os seguintes objetos de banco de dados ser\00E3o recriados, se existirem')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282400219961871084)
,p_name=>'DEMO_APPLICATION.OBJECT_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282400970127871084)
,p_name=>'DEMO_APPLICATION.PACKAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Pacote'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282405177567871087)
,p_name=>'DEMO_APPLICATION.PETSTORE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Loja de artigos para animais de estima\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282405809243871088)
,p_name=>'DEMO_APPLICATION.PRESIDENTIAL'
,p_message_language=>'pt-br'
,p_message_text=>'Discursos de Posse do Presidente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282406149947871088)
,p_name=>'DEMO_APPLICATION.PROJECT_TRACKING'
,p_message_language=>'pt-br'
,p_message_text=>'Rastreamento do Projeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282602581107871215)
,p_name=>'DEMO_APPLICATION.RE_INSTALL'
,p_message_language=>'pt-br'
,p_message_text=>'Reinstalar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282404425072871087)
,p_name=>'DEMO_APPLICATION.RUN'
,p_message_language=>'pt-br'
,p_message_text=>'Executar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282400154689871084)
,p_name=>'DEMO_APPLICATION.SCHEMA'
,p_message_language=>'pt-br'
,p_message_text=>'Esquema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282400701062871084)
,p_name=>'DEMO_APPLICATION.SEQUENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Sequ\00EAncia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282403908472871086)
,p_name=>'DEMO_APPLICATION.STATUS'
,p_message_language=>'pt-br'
,p_message_text=>'Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282400564393871084)
,p_name=>'DEMO_APPLICATION.TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Tabela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282403783231871086)
,p_name=>'DEMO_APPLICATION.TABLE_SUMMARY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio de Status de Instala\00E7\00E3o do Aplicativo de Demonstra\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282400802889871084)
,p_name=>'DEMO_APPLICATION.TRIGGER'
,p_message_language=>'pt-br'
,p_message_text=>'Trigger'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282858101507871380)
,p_name=>'DEMO_APPLICATION.UNLOCKED'
,p_message_language=>'pt-br'
,p_message_text=>'Desbloqueado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282246663090870986)
,p_name=>'DEMO_APPLICATION.UPDATE_AVAILABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atualiza\00E7\00E3o Dispon\00EDvel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283496676330871806)
,p_name=>'DEMO_APPLICATION.WEBSHEET_OBJECT_VALIDATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os seguintes objetos inv\00E1lidos precisam ser corrigidos para que as Websheet sejam executadas adequadamente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282405618040871087)
,p_name=>'DEMO_APPLICATION.WEB_SERVICES'
,p_message_language=>'pt-br'
,p_message_text=>'Web Services'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282402279729871085)
,p_name=>'DEMO_APPLICATION.WILL_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Poder\00E1 ocorrer erro se voc\00EA n\00E3o estiver recriando esta demonstra\00E7\00E3o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282335137020871042)
,p_name=>'DEMO_FLOW.CREATED_ERROR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o havia espa\00E7o suficiente para criar a demonstra\00E7\00E3o. Para solicitar um armazenamento adicional, v\00E1 para a p\00E1gina de administra\00E7\00E3o e clique no link "Solicitar Altera\00E7\00F5es no Servi\00E7o Atual".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282335024716871042)
,p_name=>'DEMO_FLOW.CREATED_SUCCESS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O aplicativo de demonstra\00E7\00E3o %0 foi criada.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283106166794871540)
,p_name=>'DEPRECATED'
,p_message_language=>'pt-br'
,p_message_text=>'Obsoleto'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282283005819871009)
,p_name=>'DERIVED$'
,p_message_language=>'pt-br'
,p_message_text=>'coluna derivada'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282675638402871261)
,p_name=>'DESIRABLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Desej\00E1vel')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282751562663871312)
,p_name=>'DETAIL'
,p_message_language=>'pt-br'
,p_message_text=>'Detalhe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282818310625871355)
,p_name=>'DETAILS_FOR_ALT_TAG'
,p_message_language=>'pt-br'
,p_message_text=>'Detalhes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282751683854871312)
,p_name=>'DETAIL_2'
,p_message_language=>'pt-br'
,p_message_text=>'Detalhe 2'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282217790908870967)
,p_name=>'DEVELOPER'
,p_message_language=>'pt-br'
,p_message_text=>'Desenvolvedor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282824521167871359)
,p_name=>'DEVELOPERS'
,p_message_language=>'pt-br'
,p_message_text=>'Desenvolvedores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282696011865871274)
,p_name=>'DEVELOPER_ACTIVITY_SUMMARY'
,p_message_language=>'pt-br'
,p_message_text=>'Resumo de Atividades do Desenvolvedor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282720900525871290)
,p_name=>'DEVELOPER_SUMMARY'
,p_message_language=>'pt-br'
,p_message_text=>'Resumo do Desenvolvedor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282901448191871408)
,p_name=>'DEVELOPER_TOOLBAR_CLEAR'
,p_message_language=>'pt-br'
,p_message_text=>'Limpar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282901373219871408)
,p_name=>'DEVELOPER_TOOLBAR_COPY'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282930035165871426)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Depurar (%0)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282929579137871426)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00EDvel de Depura\00E7\00E3o Padr\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282929758934871426)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL4'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informa\00E7\00F5es (padr\00E3o)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282929868029871426)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL6'
,p_message_language=>'pt-br'
,p_message_text=>'Rastreamento de Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282929943789871426)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL9'
,p_message_language=>'pt-br'
,p_message_text=>'Rastreamento Completo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282889087474871400)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Um ou mais erros ocorrerem desde que a p\00E1gina foi carregada. Abra a console JavaScript do Browser para ver os erros.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282889678745871400)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS_BTN'
,p_message_language=>'pt-br'
,p_message_text=>'Erros de JavaScript'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282984543284871461)
,p_name=>'DEVELOPER_TOOLBAR_NO_BUILDER'
,p_message_language=>'pt-br'
,p_message_text=>'Esta funcionalidade requer que a janela do Application Express App Builder esteja aberta. Deseja abrir o Builder nesta janela?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282964487619871448)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es da Barra de Ferramentas do Desenvolvedor')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282972714873871454)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_AUTO_HIDE'
,p_message_language=>'pt-br'
,p_message_text=>'Ocultar Automaticamente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282972903797871454)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_DISPLAY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Posi\00E7\00E3o de Exibi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282972887042871454)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_ICONS_ONLY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mostrar Somente \00CDcones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282973144750871454)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_BOTTOM'
,p_message_language=>'pt-br'
,p_message_text=>'Inferior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282973088994871454)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_LEFT'
,p_message_language=>'pt-br'
,p_message_text=>'Esquerda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282973243519871454)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_RIGHT'
,p_message_language=>'pt-br'
,p_message_text=>'Direita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282980817807871459)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_TOP'
,p_message_language=>'pt-br'
,p_message_text=>'Superior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282895702086871404)
,p_name=>'DEVELOPER_TOOLBAR_PAGE_INFO'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Informa\00E7\00F5es da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282895993807871404)
,p_name=>'DEVELOPER_TOOLBAR_PERF_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tempo do Desempenho da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282964505827871448)
,p_name=>'DEVELOPER_TOOLBAR_QUICK_EDIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Edi\00E7\00E3o R\00E1pida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282895863950871404)
,p_name=>'DEVELOPER_TOOLBAR_SHOW_PERF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Mostrar Tempo da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283512644140871817)
,p_name=>'DEVELOPER_TOOLBAR_THEME_ROLLER'
,p_message_language=>'pt-br'
,p_message_text=>'Rolador do Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282972643124871454)
,p_name=>'DEVELOPER_TOOLBAR_TITLE'
,p_message_language=>'pt-br'
,p_message_text=>'Barra de Ferramentas do Desenvolvedor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282669149906871257)
,p_name=>'DEVELOPMENT_TASK'
,p_message_language=>'pt-br'
,p_message_text=>'Tarefa de Desenvolvimento'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282852294650871376)
,p_name=>'DIAL_CHART_ALERT_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Alerta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282852140602871376)
,p_name=>'DIAL_CHART_HIGH_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Alto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282852017296871376)
,p_name=>'DIAL_CHART_LOW_VALUE'
,p_message_language=>'pt-br'
,p_message_text=>'Valor Baixo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282172383981870938)
,p_name=>'DIAL_PCT'
,p_message_language=>'pt-br'
,p_message_text=>'Quadrante (Percentual)'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282253838894870990)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATIONS'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicativos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282256491191870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esquemas de Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282256539304870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTHORIZATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esquemas de Autoriza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282255602236870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BC_ENTRIES'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282255549377870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BREADCRUMBS'
,p_message_language=>'pt-br'
,p_message_text=>'Breadcrumbs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283554457916871845)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BUILD_OPTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es de Build')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282255286234870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_COMPUTATIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00E1lculos do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282255434857870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>'Itens do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282255757948870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LISTS'
,p_message_language=>'pt-br'
,p_message_text=>'Listas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282255848438870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LIST_ENTRIES'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282255975012870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOVS'
,p_message_language=>'pt-br'
,p_message_text=>'Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282191944882870951)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_COLS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas de Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282256014709870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_ENTRIES'
,p_message_language=>'pt-br'
,p_message_text=>'Entradas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282256147812870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_NAV_BAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Barras de Navega\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282253960879870990)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282255111938870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BRANCHES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ramifica\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282254336404870990)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BUTTONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bot\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282642121497871240)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHARTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1ficos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282642390972871240)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_A'
,p_message_language=>'pt-br'
,p_message_text=>'Eixos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282642204747871240)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_S'
,p_message_language=>'pt-br'
,p_message_text=>unistr('S\00E9rie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282254832962870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_COMP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00E1lculos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282301097279871021)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00F5es Din\00E2micas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282301101853871021)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA_ACTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00E3o Din\00E2mica - A\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283073756730871519)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1ficos Flash 5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283073879859871519)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5_S'
,p_message_language=>'pt-br'
,p_message_text=>unistr('S\00E9rie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282254450239870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_CH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gr\00E1ficos Flash')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282254579189870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_S'
,p_message_language=>'pt-br'
,p_message_text=>unistr('S\00E9rie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282254664146870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regi\00F5es IR')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282254786181870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR_COL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Colunas do Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282254128971870990)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Itens da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282255008017870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_PROC'
,p_message_language=>'pt-br'
,p_message_text=>'Processos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282254092956870990)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REGIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regi\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283365851727871717)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REG_COLS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282254261490870990)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_RPT_COLS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Colunas do Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283461383484871782)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_TREES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rvores')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282254997348870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_VAL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valida\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282256292263870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PARENT_TABS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Guias M\00E3es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282255348711870991)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PROCESSES'
,p_message_language=>'pt-br'
,p_message_text=>'Processos do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283492574709871803)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_LAYOUTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Layouts de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283493365057871804)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QRY_STMTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Instru\00E7\00F5es SQL da Consulta de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283492430488871803)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QUERIES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Consultas de Relat\00F3rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283431458441871761)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es do Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282256626769870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SHORTCUTS'
,p_message_language=>'pt-br'
,p_message_text=>'Atalhos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282251818006870989)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_STATIC_FILES'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivos do Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282258195074870993)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUBSTITUTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Substitui\00E7\00F5es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283554173277871845)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJECTS'
,p_message_language=>'pt-br'
,p_message_text=>'Objetos de Suporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283554269208871845)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_BOPT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Objetos de Suporte - Op\00E7\00F5es de Build')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282257960843870993)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_CHCK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Objetos - Valida\00E7\00F5es de Suporte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282258034913870993)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_SCR'
,p_message_language=>'pt-br'
,p_message_text=>'Objetos - Scripts de Suporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282256363021870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TABS'
,p_message_language=>'pt-br'
,p_message_text=>'Guias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282257078098870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BC'
,p_message_language=>'pt-br'
,p_message_text=>'Modelos de Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282257136351870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BUTTON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelos de Bot\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282257297253870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_CALENDAR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelos de Calend\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282327565236871037)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_GRID'
,p_message_language=>'pt-br'
,p_message_text=>'Modelos de Grade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282257309798870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>'Modelos de Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282257487520870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LIST'
,p_message_language=>'pt-br'
,p_message_text=>'Modelos de Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282257559932870993)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelos de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282257669713870993)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_POPUPLOV'
,p_message_language=>'pt-br'
,p_message_text=>'Modelos de LOV Popup'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282257790514870993)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelos de Regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282257844682870993)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelos de Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282256932549870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEMES'
,p_message_language=>'pt-br'
,p_message_text=>'Temas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282234010842870977)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_FILES'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivos de Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282180160474870943)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_STYLES'
,p_message_language=>'pt-br'
,p_message_text=>'Estilos de Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282701272731871277)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANSLATIONS'
,p_message_language=>'pt-br'
,p_message_text=>'Mensagens de Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282226562536870973)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_DYNAMIC'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tradu\00E7\00F5es Din\00E2micas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282226614117870973)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_REPOS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Texto Traduz\00EDvel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282256872580870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TREES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00C1rvores')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282256758504870992)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_WEB_SERVICES'
,p_message_language=>'pt-br'
,p_message_text=>'Web Services'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283452545562871775)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_ROLES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Atribui\00E7\00F5es de Controle de Acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283452666317871776)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rios do Controle de Acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282742985222871306)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USER_ROLES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Designa\00E7\00E3o de Atribui\00E7\00E3o de Usu\00E1rio para Controle de Acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283496258298871806)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_CONCATENATED_FILES'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivos Concatenados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282650175286871245)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILES'
,p_message_language=>'pt-br'
,p_message_text=>'Perfis de Parsing de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282650251382871245)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILE_COLS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas de Perfis de Parsing de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283525904282871826)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DEVELOPER_COMMENTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Coment\00E1rios do Desenvolvedor')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283061503192871511)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE'
,p_message_language=>'pt-br'
,p_message_text=>'Tabela de Carga de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283049798779871504)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLES'
,p_message_language=>'pt-br'
,p_message_text=>'Tabelas de Carga de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283049819386871504)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_LOOKUPS'
,p_message_language=>'pt-br'
,p_message_text=>'Pesquisas da Tabela de Carga de Dados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283049977082871504)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_RULES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regras de Transforma\00E7\00E3o da Tabela de Carga de Dados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282186935610870947)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CALENDARS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1ginas de Calend\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282965390894871449)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Regi\00F5es da Grade Interativa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282965471240871449)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Colunas do Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282965563181871449)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COL_GROUPS'
,p_message_language=>'pt-br'
,p_message_text=>'Grupos de Colunas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282274203095871003)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGINS'
,p_message_language=>'pt-br'
,p_message_text=>'Plug-ins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282274304145871003)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTRIBUTES'
,p_message_language=>'pt-br'
,p_message_text=>'Atributos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282699875960871277)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTR_VALUES'
,p_message_language=>'pt-br'
,p_message_text=>'Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282332329581871041)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_EVENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282276736594871005)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_FILES'
,p_message_language=>'pt-br'
,p_message_text=>'Arquivos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282752265227871312)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ITEM_FILTERS'
,p_message_language=>'pt-br'
,p_message_text=>'Operadores de Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283554346179871845)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_SETTINGS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Defini\00E7\00F5es de Componentes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283467122254871786)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_STD_ATTRS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Metadados do Atributo Padr\00E3o do Plug-In')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282650022052871245)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_REMOTE_SQL'
,p_message_language=>'pt-br'
,p_message_text=>'Servidores de SQL Ativados por REST'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283365791691871717)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Op\00E7\00F5es de Modelo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283554000099871845)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GROUPS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Grupos de Op\00E7\00F5es de Modelo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283438315108871766)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GRP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Grupo de Op\00E7\00F5es do Modelo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283509412167871815)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_PAGE_DP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pontos de Exibi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283509528965871815)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_REGION_DP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pontos de Exibi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282330779793871040)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_THEME_DISPLAY_POINTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pontos de Exibi\00E7\00E3o do Tema')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282251723949870989)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_USER_INTERFACES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Interfaces do Usu\00E1rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282650760244871245)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_COMP_PARAMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Par\00E2metros de Origem Web do Componente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282650467939871245)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_MODULES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00F3dulos de Origem Web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282650581330871245)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_OPERATIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Opera\00E7\00F5es de Origem Web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282650651211871245)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_PARAMETERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Par\00E2metros de Origem Web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282650352618871245)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_SERVERS'
,p_message_language=>'pt-br'
,p_message_text=>'Servidores Remotos de Origem Web'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283469651190871787)
,p_name=>'DISABLED_NEXT_BUTTON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bot\00E3o Pr\00F3ximo Desativado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283469577468871787)
,p_name=>'DISABLED_PREVIOUS_BUTTON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bot\00E3o Anterior Desativado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282812983739871351)
,p_name=>'DISABLE_TRIGGER'
,p_message_language=>'pt-br'
,p_message_text=>'Desativar trigger %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282410242916871090)
,p_name=>'DISPLAY_CONDITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exibir Condi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282410466898871090)
,p_name=>'DISPLAY_CONDITION_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Exibir Texto Condicional'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282878138510871393)
,p_name=>'DISPLAY_ORDER_LABEL'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ordem de Exibi\00E7\00E3o: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282280713511871007)
,p_name=>'DISPLAY_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de Exibi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283553716066871845)
,p_name=>'DISPLAY_VALUE.N'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valor de Exibi\00E7\00E3o: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283464914734871784)
,p_name=>'DISTINCT_PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('P\00E1ginas Distintas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283465069965871784)
,p_name=>'DISTINCT_USERS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rios Distintos')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282191609057870950)
,p_name=>'DML_FORM'
,p_message_language=>'pt-br'
,p_message_text=>'Form DML'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282498509422871147)
,p_name=>'DO NOT UPDATE PAGE ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>'DO_NOT_UPDATE_PAGE_ITEMS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282691649084871271)
,p_name=>'DOC_IMPACT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Impacto da Documenta\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282692858849871272)
,p_name=>'DOC_STATUS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Status da Documenta\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282693061358871272)
,p_name=>'DOC_WRITER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Gravador da Documenta\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282570573667871194)
,p_name=>'DOWN'
,p_message_language=>'pt-br'
,p_message_text=>'Inativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282202076608870957)
,p_name=>'DOWNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>'Fazer Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282701055928871277)
,p_name=>'DOWNLOAD_LINK_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Texto do Link de Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282498204992871147)
,p_name=>'DO_NOT_UPDATE_APPLICATION_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o atualizar itens do aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282498313065871147)
,p_name=>'DO_NOT_UPDATE_DATA_ENTRY_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o atualizar itens de entrada de dados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282498497773871147)
,p_name=>'DO_NOT_UPDATE_DISPLAY_ONLY_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o atualizar itens somente para exibi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282498124989871147)
,p_name=>'DO_NOT_UPDATE_PAGES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o atualizar p\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282499796077871148)
,p_name=>'DO_NOT_UPDATE_PAGE_ITEMS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o atualizar itens de p\00E1gina')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282378726942871070)
,p_name=>'DRAG_AND_DROP'
,p_message_language=>'pt-br'
,p_message_text=>'Arrastar e Soltar'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282271463524871001)
,p_name=>'DRILLDOWN'
,p_message_language=>'pt-br'
,p_message_text=>'Drill-down'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282271369074871001)
,p_name=>'DRILLUP'
,p_message_language=>'pt-br'
,p_message_text=>'Drill-up'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282427019286871101)
,p_name=>'DRIVEN'
,p_message_language=>'pt-br'
,p_message_text=>'conduzido'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282812752715871351)
,p_name=>'DROP TRIGGER'
,p_message_language=>'pt-br'
,p_message_text=>'Eliminar trigger %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282811628053871350)
,p_name=>'DROP_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Eliminar Coluna %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283045031821871501)
,p_name=>'DS_ACCESS_METHOD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('M\00E9todo de Acesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283044861434871501)
,p_name=>'DS_BIND_VARIABLE_NAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome da Vari\00E1vel de Bind')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283045210346871501)
,p_name=>'DS_HANDLER'
,p_message_language=>'pt-br'
,p_message_text=>'Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283045680502871501)
,p_name=>'DS_ITEMS_PER_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Itens Por P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283045446469871501)
,p_name=>'DS_MIME_TYPES_ALLOWED'
,p_message_language=>'pt-br'
,p_message_text=>'Tipos MIME Permitidos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283045527277871501)
,p_name=>'DS_ORIGINS_ALLOWED'
,p_message_language=>'pt-br'
,p_message_text=>'Origens Permitidas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283045123881871501)
,p_name=>'DS_PARAMETER_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Tipo de Par\00E2metro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283045714460871501)
,p_name=>'DS_SECURITY_CONSTRAINT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Constraint de Seguran\00E7a')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283044983457871501)
,p_name=>'DS_SOURCE'
,p_message_language=>'pt-br'
,p_message_text=>'Origem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283045357902871501)
,p_name=>'DS_SOURCE_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo de Origem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283045802948871501)
,p_name=>'DS_URI_PREFIX'
,p_message_language=>'pt-br'
,p_message_text=>'Prefixo de URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283044555971871500)
,p_name=>'DS_URI_TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>'Modelo de URI'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283493431420871804)
,p_name=>'DUE'
,p_message_language=>'pt-br'
,p_message_text=>'Vencimento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282692674603871272)
,p_name=>'DUE_DATE'
,p_message_language=>'pt-br'
,p_message_text=>'Data de Vencimento'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282672425769871259)
,p_name=>'DUPLICATE'
,p_message_language=>'pt-br'
,p_message_text=>'Duplicado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283465831393871785)
,p_name=>'DUPLICATE_USER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rio duplicado na lista')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283115083221871546)
,p_name=>'DUP_USER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Nome do Usu\00E1rio Duplicado na lista.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282180551857870943)
,p_name=>'DYNAMIC ACTION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00E3o Din\00E2mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282180463024870943)
,p_name=>'DYNAMIC ACTIONS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A\00E7\00F5es Din\00E2micas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282190254442870950)
,p_name=>'DYNAMIC_FORM'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Form din\00E2mico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282316474571871030)
,p_name=>'DYNAMIC_HTML'
,p_message_language=>'pt-br'
,p_message_text=>unistr('HTML Din\00E2mico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282377597120871069)
,p_name=>'DYNAMIC_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Relat\00F3rio Interativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282178047527870942)
,p_name=>'DYNAMIC_REFERENCE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Refer\00EAncia Din\00E2mica')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282486461749871139)
,p_name=>'EASY_REPORT.INVALID_CONDITION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('A condi\00E7\00E3o que voc\00EA est\00E1 adicionando invalidou a consulta.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282271536368871001)
,p_name=>'EDIT'
,p_message_language=>'pt-br'
,p_message_text=>'Editar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282185727880870947)
,p_name=>'EDIT PAGE GROUP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Grupo de P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282735918518871300)
,p_name=>'EDITOR_EXIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Voc\00EA perder\00E1 as altera\00E7\00F5es n\00E3o salvas se selecionar OK.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282217051096870967)
,p_name=>'EDIT_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Tudo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282487615363871140)
,p_name=>'EDIT_ALL_PAGE_DEFINITION_ATTRIBUTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Edite todos os atributos da defini\00E7\00E3o de p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282730121269871296)
,p_name=>'EDIT_ALL_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar todos os itens desta regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282656263421871249)
,p_name=>'EDIT_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282750396093871311)
,p_name=>'EDIT_ATTRIBUTE'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Atributo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283405126149871743)
,p_name=>'EDIT_AUTHENTICATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Autentica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282740336539871302)
,p_name=>'EDIT_COMPONENT'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282750478939871311)
,p_name=>'EDIT_COMPONENT_DEF'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Defini\00E7\00E3o do Componente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282852964964871377)
,p_name=>'EDIT_LINK_TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Editar %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282750264222871311)
,p_name=>'EDIT_LIST_DEV'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Defini\00E7\00E3o da Lista')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283479854281871794)
,p_name=>'EDIT_LOCK'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Bloqueio de Edi\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282615796270871223)
,p_name=>'EDIT_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282490137723871142)
,p_name=>'EDIT_PAGE_ATTRIBUTES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar atributos de p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283113515330871545)
,p_name=>'EDIT_PROFILE'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Perfil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283134454952871559)
,p_name=>'EDIT_PROFILE.USER_NO_PRIV_ERR'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O usu\00E1rio 0% n\00E3o tem privil\00E9gios para atualizar as informa\00E7\00F5es de outro usu\00E1rio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282740179269871302)
,p_name=>'EDIT_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Regi\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282825309716871359)
,p_name=>'EDIT_REPORTING_TIMEFRAME'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Per\00EDodo de Relat\00F3rios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282740215138871302)
,p_name=>'EDIT_REPORT_COLS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Colunas do Relat\00F3rio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283106914279871541)
,p_name=>'EDIT_REPORT_DIALOG_CLOSED_DA'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Editar Relat\00F3rio - Caixa de Di\00E1logo Fechada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282729171038871295)
,p_name=>'EDIT_SYSTEM_MESSAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Mensagem do Sistema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283068153037871516)
,p_name=>'EDIT_TAB'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Guia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282751974376871312)
,p_name=>'EDIT_THIS_ATTRIBUTE'
,p_message_language=>'pt-br'
,p_message_text=>'Editar este atributo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282592860108871208)
,p_name=>'ELAPSED_TIME'
,p_message_language=>'pt-br'
,p_message_text=>'Tempo Decorrido'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282679815396871264)
,p_name=>'EMAIL.TEMPLATE.FOOTER_EXAMPLE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<a href="#MY_APPLICATION_LINK#">Visitar Meu Aplicativo e gerenciar suas prefer\00EAncias de e-mail</a>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282687072011871268)
,p_name=>'EMAIL.TEMPLATE.HEADER_EXAMPLE'
,p_message_language=>'pt-br'
,p_message_text=>'<b style="font-size: 24px;">Meu Aplicativo</b>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282812085834871351)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.EV'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<b>Ol\00E1 #INVITEE#,</b><br>'),
'<br>',
unistr('Este \00E9 um lembrete de um evento futuro para o qual voc\00EA foi convidado. Veja os detalhes do evento abaixo:<br>'),
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Organizador</th>',
'    <td>#ORGANIZER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Data do Evento</th>',
'    <td>#EVENT_DATE#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left">Hor\00E1rio de In\00EDcio</th>'),
'    <td>#START_TIME#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left">Dura\00E7\00E3o</th>'),
'    <td>#DURATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Local</th>',
'    <td>#LOCATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">URL</th>',
'    <td><a href="#URL_LINK#">#URL_NAME#</a></td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left" valign="top">Observa\00E7\00F5es</th>'),
'    <td>#NOTES#</td>',
'  </tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282679760937871264)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.OD'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<b>Ol\00E1 #CUSTOMER_NAME#</b>,<br>'),
'<br>',
'Obrigado pelo seu pedido!<br>',
'<br>',
'<b>Detalhes do Pedido</b><br>',
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Data do Pedido</th>',
'    <td>#ORDER_DATE#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left">N\00FAmero do Pedido</th>'),
'    <td>#ORDER_NUMBER#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left">Refer\00EAncia de Envio</th>'),
'    <td>#SHIP_TO#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left" valign="top">Endere\00E7o para Remessa</th>'),
'    <td>',
'      #SHIPPING_ADDRESS_LINE_1#<br>',
'      #SHIPPING_ADDRESS_LINE_2#',
'    </td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Itens Pedidos</th>',
'    <td>#ITEMS_ORDERED#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Total do Pedido</th>',
'    <td>#ORDER_TOTAL#</td>',
'  </tr>',
'</table>',
'<br>',
'<br>',
unistr('Precisa fazer uma altera\00E7\00E3o no seu pedido? <a href="#ORDER_URL#">Gerencie seu pedido #ORDER_NUMBER# aqui.</a>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283107223802871541)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.SO'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ol\00E1 #SERVICE_USER#,<br>'),
'<br>',
unistr('Fique ciente de que h\00E1 uma interrup\00E7\00E3o futura programada para seu servi\00E7o #SERVICE_NAME#.'),
unistr('A interrup\00E7\00E3o est\00E1 programada para come\00E7ar em #OUTAGE_START# e o tempo de indisponibilidade planejado \00E9 de #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.<br>'),
'<br>',
unistr('As seguintes a\00E7\00F5es ser\00E3o executadas durante esta interrup\00E7\00E3o programada:<br>'),
'#OUTAGE_REASON#<br>',
'<br>',
'<br>',
unistr('Para quaisquer quest\00F5es relativas a esta interrup\00E7\00E3o, entre em contato com #OUTAGE_CONTACT#.<br>'),
'<br>',
unistr('Agradecemos sua compreens\00E3o,<br>'),
'#SERVICE_TEAM#'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283106667620871541)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.EV'
,p_message_language=>'pt-br'
,p_message_text=>'Lembrete de Evento: #EVENT_NAME#'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283106737872871541)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.OD'
,p_message_language=>'pt-br'
,p_message_text=>'Pedido (#ORDER_NUMBER#) Confirmado!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282812233036871351)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.EV'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ol\00E1 #INVITEE#,'),
'',
unistr('Este e-mail \00E9 para lembr\00E1-lo de um evento futuro ao qual voc\00EA est\00E1 associado.'),
'',
'Data do Evento: #EVENT_DATE#',
unistr('Hor\00E1rio de In\00EDcio: #START_TIME#'),
unistr('Dura\00E7\00E3o:   #DURATION#'),
'Organizador:  #ORGANIZER#',
'Local:   #LOCATION#',
'URL:        #URL_NAME# (#URL_LINK#)',
unistr('Observa\00E7\00F5es:      #NOTES#'),
'',
'Veja outros detalhes do evento aqui: #EVENT_LINK#'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282812113408871351)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.OD'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ol\00E1 #CUSTOMER_NAME#,'),
'',
'Obrigado pelo seu pedido!',
'',
'Detalhes do Pedido',
'--------------------------------------------------------------------------------',
'  Data do Pedido:       #ORDER_DATE#',
unistr('  N\00FAmero do Pedido:     #ORDER_NUMBER#'),
unistr('  Refer\00EAncia de Envio:          #SHIP_TO#'),
unistr('  Endere\00E7o para Remessa: #SHIPPING_ADDRESS_LINE_1#'),
'                    #SHIPPING_ADDRESS_LINE_2#',
'  Itens Pedidos:    #ITEMS_ORDERED#',
'  Total do Pedido:      #ORDER_TOTAL#',
'--------------------------------------------------------------------------------',
'',
unistr('Precisa fazer alguma altera\00E7\00E3o no seu pedido? Gerencie seu pedido #ORDER_NUMBER# aqui: #ORDER_URL#')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283107102543871541)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.SO'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ol\00E1 #SERVICE_USER#,'),
'',
unistr('Fique ciente de que h\00E1 uma interrup\00E7\00E3o futura programada para seu servi\00E7o #SERVICE_NAME#.'),
unistr('A interrup\00E7\00E3o est\00E1 programada para come\00E7ar em #OUTAGE_START# e o tempo de indisponibilidade planejado \00E9 de #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.'),
'',
unistr('As seguintes a\00E7\00F5es ser\00E3o executadas durante esta interrup\00E7\00E3o programada:'),
'#OUTAGE_REASON#',
'',
unistr('Para quaisquer quest\00F5es relativas a esta interrup\00E7\00E3o, entre em contato com #OUTAGE_CONTACT#.'),
'',
unistr('Agradecemos sua compreens\00E3o,'),
'#SERVICE_TEAM#',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282347095369871050)
,p_name=>'EMAIL_NOT_FOUND'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O endere\00E7o de e-mail "%0" n\00E3o foi encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282218025634870967)
,p_name=>'EMAIL_SENT_BY'
,p_message_language=>'pt-br'
,p_message_text=>'Este e-mail foi enviado por %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283115256937871546)
,p_name=>'EMAIL_TOO_LONG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O Endere\00E7o de E-mail \00E9 muito longo. O limite \00E9 240 caracteres.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282734083697871298)
,p_name=>'ENABLE_DEBUGGING'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ativar Depura\00E7\00E3o Sim ou N\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282812870325871351)
,p_name=>'ENABLE_TRIGGER'
,p_message_language=>'pt-br'
,p_message_text=>'Ativar trigger %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282219682361870968)
,p_name=>'ENCRYPTION_INPUT_TOO_LONG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('O tamanho do valor a ser criptografado n\00E3o pode exceder 4000 bytes.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282217834628870967)
,p_name=>'END_USER'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Usu\00E1rio Final')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282668784219871257)
,p_name=>'ENHANCEMENT_REQUEST'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00E3o de Melhoria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283135123965871559)
,p_name=>'ENHANCEMENT_REQUEST_DASH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Solicita\00E7\00F5es de Melhoria: %1 de %0 fechadas')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282671941924871259)
,p_name=>'ENTERED'
,p_message_language=>'pt-br'
,p_message_text=>'Registrado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282184351522870946)
,p_name=>'ENTER_WEBSHEETS_CREDENTIALS'
,p_message_language=>'pt-br'
,p_message_text=>'Informar credenciais das Websheets.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282657971645871250)
,p_name=>'ENTRY LINK'
,p_message_language=>'pt-br'
,p_message_text=>'Link da Entrada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282657895005871250)
,p_name=>'ENTRY TEXT'
,p_message_language=>'pt-br'
,p_message_text=>'Texto da Entrada'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282572815671871196)
,p_name=>'ERROR'
,p_message_language=>'pt-br'
,p_message_text=>'Erro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282716528067871287)
,p_name=>'ERROR PAGE TEMPLATE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Modelo de P\00E1gina de Erro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282568245532871193)
,p_name=>'ERRORPAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Em P\00E1gina de Erro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282730700457871296)
,p_name=>'ERRORS'
,p_message_language=>'pt-br'
,p_message_text=>'Erros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282659127562871251)
,p_name=>'ERROR_ICON'
,p_message_language=>'pt-br'
,p_message_text=>unistr('\00CDcone de Erro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283491800232871803)
,p_name=>'ERROR_MESSAGE'
,p_message_language=>'pt-br'
,p_message_text=>'Mensagem de Erro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282818596625871355)
,p_name=>'ERROR_SET_ITEM_STATE_FOR_PPR_REGION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00E3o \00E9 poss\00EDvel definir o valor de origem do item de p\00E1gina para atualiza\00E7\00E3o parcial da regi\00E3o da p\00E1gina')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282651207616871246)
,p_name=>'ESCAPED_COL_TOO_LARGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('<br><b>Dados de Escape excederam o limite; os resultados ser\00E3o reduzidos a 32k</b>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282426296664871101)
,p_name=>'ESCAPE_SC'
,p_message_language=>'pt-br'
,p_message_text=>'caracteres especiais de escape'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282694164100871273)
,p_name=>'ESTIMATED_EFFORT_IN_HOURS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Esfor\00E7o Estimado em Horas')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283044754136871500)
,p_name=>'ETAG_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>'Consulta ETAG'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283044679053871500)
,p_name=>'ETAG_TYPE'
,p_message_language=>'pt-br'
,p_message_text=>'Tipo ETAG'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282669317986871257)
,p_name=>'EVENT'
,p_message_language=>'pt-br'
,p_message_text=>'Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283111781368871544)
,p_name=>'EVENT.APEX.APEXAFTERREFRESH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Depois da Atualiza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283112377896871544)
,p_name=>'EVENT.APEX.APEXBEFOREPAGESUBMIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Antes da Submiss\00E3o da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283111645124871544)
,p_name=>'EVENT.APEX.APEXBEFOREREFRESH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Antes da Atualiza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283115989899871546)
,p_name=>'EVENT.BROWSER'
,p_message_language=>'pt-br'
,p_message_text=>'Eventos do Browser'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282482780925871137)
,p_name=>'EVENT.BROWSER.APEXDOUBLETAP'
,p_message_language=>'pt-br'
,p_message_text=>'Toque Duplo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282482969369871137)
,p_name=>'EVENT.BROWSER.APEXPAN'
,p_message_language=>'pt-br'
,p_message_text=>'Panorama'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282482827464871137)
,p_name=>'EVENT.BROWSER.APEXPRESS'
,p_message_language=>'pt-br'
,p_message_text=>'Pressionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282483034445871137)
,p_name=>'EVENT.BROWSER.APEXSWIPE'
,p_message_language=>'pt-br'
,p_message_text=>'Deslizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282482672049871137)
,p_name=>'EVENT.BROWSER.APEXTAP'
,p_message_language=>'pt-br'
,p_message_text=>'Tocar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283111157363871543)
,p_name=>'EVENT.BROWSER.CHANGE'
,p_message_language=>'pt-br'
,p_message_text=>'Alterar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283110422397871543)
,p_name=>'EVENT.BROWSER.CLICK'
,p_message_language=>'pt-br'
,p_message_text=>'Clicar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283110564707871543)
,p_name=>'EVENT.BROWSER.DBLCLICK'
,p_message_language=>'pt-br'
,p_message_text=>'Clique Duplo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283109932458871543)
,p_name=>'EVENT.BROWSER.FOCUSIN'
,p_message_language=>'pt-br'
,p_message_text=>'Elemento ativo selecionado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283109831846871543)
,p_name=>'EVENT.BROWSER.FOCUSOUT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Elemento ativo n\00E3o selecionado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283111341816871543)
,p_name=>'EVENT.BROWSER.KEYDOWN'
,p_message_language=>'pt-br'
,p_message_text=>'Pressionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283111494291871544)
,p_name=>'EVENT.BROWSER.KEYPRESS'
,p_message_language=>'pt-br'
,p_message_text=>'Pressionar Tecla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283111597058871544)
,p_name=>'EVENT.BROWSER.KEYUP'
,p_message_language=>'pt-br'
,p_message_text=>'Liberar Tecla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283110054642871543)
,p_name=>'EVENT.BROWSER.LOAD'
,p_message_language=>'pt-br'
,p_message_text=>'Carga de Recurso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283110666066871543)
,p_name=>'EVENT.BROWSER.MOUSEDOWN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Pressionamento do Bot\00E3o do Mouse')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283110992088871543)
,p_name=>'EVENT.BROWSER.MOUSEENTER'
,p_message_language=>'pt-br'
,p_message_text=>'Entrada do Mouse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283111073863871543)
,p_name=>'EVENT.BROWSER.MOUSELEAVE'
,p_message_language=>'pt-br'
,p_message_text=>'Retirada do Mouse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283110877117871543)
,p_name=>'EVENT.BROWSER.MOUSEMOVE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Movimenta\00E7\00E3o do Mouse')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283110742439871543)
,p_name=>'EVENT.BROWSER.MOUSEUP'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Libera\00E7\00E3o do Bot\00E3o do Mouse')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282183386651870945)
,p_name=>'EVENT.BROWSER.ORIENTATIONCHANGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Altera\00E7\00E3o da Orienta\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283120866053871550)
,p_name=>'EVENT.BROWSER.READY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Carregamento de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283110178309871543)
,p_name=>'EVENT.BROWSER.RESIZE'
,p_message_language=>'pt-br'
,p_message_text=>'Redimensionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283110220841871543)
,p_name=>'EVENT.BROWSER.SCROLL'
,p_message_language=>'pt-br'
,p_message_text=>'Rolar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282183489664870945)
,p_name=>'EVENT.BROWSER.SCROLLSTART'
,p_message_language=>'pt-br'
,p_message_text=>'Rolar para Iniciar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282183508925870945)
,p_name=>'EVENT.BROWSER.SCROLLSTOP'
,p_message_language=>'pt-br'
,p_message_text=>'Rolar para Interromper'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283111262602871543)
,p_name=>'EVENT.BROWSER.SELECT'
,p_message_language=>'pt-br'
,p_message_text=>'Selecionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282182503952870945)
,p_name=>'EVENT.BROWSER.SWIPE'
,p_message_language=>'pt-br'
,p_message_text=>'Deslizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282182694826870945)
,p_name=>'EVENT.BROWSER.SWIPELEFT'
,p_message_language=>'pt-br'
,p_message_text=>'Deslizar para a Esquerda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282182713022870945)
,p_name=>'EVENT.BROWSER.SWIPERIGHT'
,p_message_language=>'pt-br'
,p_message_text=>'Deslizar para a Direita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282182365809870945)
,p_name=>'EVENT.BROWSER.TAP'
,p_message_language=>'pt-br'
,p_message_text=>'Tocar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282182422055870945)
,p_name=>'EVENT.BROWSER.TAPHOLD'
,p_message_language=>'pt-br'
,p_message_text=>'Tocar e Segurar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283110309650871543)
,p_name=>'EVENT.BROWSER.UNLOAD'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Descarga da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282183178405870945)
,p_name=>'EVENT.BROWSER.VCLICK'
,p_message_language=>'pt-br'
,p_message_text=>'Clique Virtual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282183231790870945)
,p_name=>'EVENT.BROWSER.VMOUSECANCEL'
,p_message_language=>'pt-br'
,p_message_text=>'Tocar em Cancelar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282182832077870945)
,p_name=>'EVENT.BROWSER.VMOUSEDOWN'
,p_message_language=>'pt-br'
,p_message_text=>'Tocar em Iniciar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282182911597870945)
,p_name=>'EVENT.BROWSER.VMOUSEMOVE'
,p_message_language=>'pt-br'
,p_message_text=>'Tocar em Mover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282183040858870945)
,p_name=>'EVENT.BROWSER.VMOUSEUP'
,p_message_language=>'pt-br'
,p_message_text=>'Tocar em Fim'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283116196790871547)
,p_name=>'EVENT.COMPONENT'
,p_message_language=>'pt-br'
,p_message_text=>'Eventos do Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282179136806870943)
,p_name=>'EVENT.CUSTOM'
,p_message_language=>'pt-br'
,p_message_text=>'Evento Personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282179295980870943)
,p_name=>'EVENT.CUSTOM.CUSTOM'
,p_message_language=>'pt-br'
,p_message_text=>'Personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283116009548871546)
,p_name=>'EVENT.FRAMEWORK'
,p_message_language=>'pt-br'
,p_message_text=>'Eventos da Estrutura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282740073437871302)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERCLOSEDIALOG'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Caixa de Di\00E1logo Fechada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283506235539871812)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERREFRESH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Depois da Atualiza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283506339020871812)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREPAGESUBMIT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Antes da Submiss\00E3o da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283506118373871812)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREREFRESH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Antes da Atualiza\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282653126232871247)
,p_name=>'EVENTS'
,p_message_language=>'pt-br'
,p_message_text=>'Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282692768763871272)
,p_name=>'EVENT_ID'
,p_message_language=>'pt-br'
,p_message_text=>unistr('N\00FAmero do Marco')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282736380042871300)
,p_name=>'EXACT_SUBS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Substitui\00E7\00F5es Exatas')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282877182865871392)
,p_name=>'EXAMPLE_1'
,p_message_language=>'pt-br'
,p_message_text=>'Exemplo 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282877210809871392)
,p_name=>'EXAMPLE_2'
,p_message_language=>'pt-br'
,p_message_text=>'Exemplo 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283410309031871747)
,p_name=>'EXAMPLE_OF_XML_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este \00E9 um exemplo dos dados contidos em uma coluna do banco de dados XML.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283465786849871785)
,p_name=>'EXAMPLE_URI'
,p_message_language=>'pt-br'
,p_message_text=>'Exemplo de URI'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282813977503871352)
,p_name=>'EXCLUDE'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282788028309871335)
,p_name=>'EXISTING_SCHEMA_NAME'
,p_message_language=>'pt-br'
,p_message_text=>'Nome do Esquema Existente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282726570258871294)
,p_name=>'EXISTS'
,p_message_language=>'pt-br'
,p_message_text=>'Existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282265166818870997)
,p_name=>'EXISTS_SQL_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>'Consulta SQL EXISTE'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283099047102871536)
,p_name=>'EXPANDED'
,p_message_language=>'pt-br'
,p_message_text=>'Expandido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283460489340871781)
,p_name=>'EXPAND_ALL'
,p_message_language=>'pt-br'
,p_message_text=>'Expandir Tudo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282335879529871043)
,p_name=>'EXPIRED'
,p_message_language=>'pt-br'
,p_message_text=>'Expirado'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282656417967871249)
,p_name=>'EXPLAIN PLAN'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Plano de Explica\00E7\00E3o')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282653474932871247)
,p_name=>'EXPORT'
,p_message_language=>'pt-br'
,p_message_text=>'Exportar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283069495870871516)
,p_name=>'EXPORT REPOSITORY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Reposit\00F3rio de Exporta\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282740709919871303)
,p_name=>'EXPORTED_FROM_ANOTHER_WORKSPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exportada de outro espa\00E7o de trabalho ou aplicativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282740877638871303)
,p_name=>'EXPORTED_FROM_CURRENT_WORKSPACE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exportada do espa\00E7o de trabalho atual.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282820324485871356)
,p_name=>'EXPORT_APPLICATION'
,p_message_language=>'pt-br'
,p_message_text=>'Exportar Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282824914417871359)
,p_name=>'EXPORT_PKG_APP_FOR_DEPLOYMENT'
,p_message_language=>'pt-br'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Use esses links para fazer download deste aplicativo e do banco de dados correspondente que suporta objetos para implanta\00E7\00E3o em uma instala\00E7\00E3o do Oracle Application Express. Os arquivos submetidos a download ser\00E3o Scripts SQL que podem ser executados')
||' no SQL*Plus, SQL Developer ou Scripts SQL dentro do Oracle Application Express.',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282820455579871356)
,p_name=>'EXPORT_SUPPORTING_OBJECTS'
,p_message_language=>'pt-br'
,p_message_text=>'Exportar Objetos de Suporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282653789647871247)
,p_name=>'EXPORT_TYPES.APP_EXPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exporta\00E7\00E3o de Aplicativo  ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282653989313871247)
,p_name=>'EXPORT_TYPES.CSS_EXPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exporta\00E7\00E3o de Folhas de Estilo em Cascata')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282654139664871247)
,p_name=>'EXPORT_TYPES.FILE_EXPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exporta\00E7\00E3o do Arquivo Est\00E1tico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282654028651871247)
,p_name=>'EXPORT_TYPES.IMAGE_EXPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exporta\00E7\00E3o de Imagem')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282653889702871247)
,p_name=>'EXPORT_TYPES.PAGE_EXPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exporta\00E7\00E3o da P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282654263796871247)
,p_name=>'EXPORT_TYPES.SCRIPT_FILE_EXPORT'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Exporta\00E7\00E3o do Arquivo de Script')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282649932701871245)
,p_name=>'EXPORT_TYPES.UI_DEFAULTS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Padr\00F5es da Interface do Usu\00E1rio')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282575953416871198)
,p_name=>'F4000.APPLICATION_COMPUTATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('C\00E1lculo de Aplicativo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282573734828871196)
,p_name=>'F4000.APPLICATION_ITEM'
,p_message_language=>'pt-br'
,p_message_text=>'Item de Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282575774576871197)
,p_name=>'F4000.APPLICATION_PROCESS'
,p_message_language=>'pt-br'
,p_message_text=>'Processo de Aplicativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282400657589871084)
,p_name=>'F4000.APPLICATION_RESERVED'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Os IDs de aplicativo 3000 a 8999 est\00E3o reservados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282266492129870998)
,p_name=>'F4000.APP_EXPORT_CURR_WS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este aplicativo foi exportado do espa\00E7o de trabalho atual.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282266598504870998)
,p_name=>'F4000.APP_EXPORT_NON_CURR_WS'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Este aplicativo foi exportado de outro espa\00E7o de trabalho.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282575664612871197)
,p_name=>'F4000.BRANCH'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ramifica\00E7\00E3o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282588295854871206)
,p_name=>'F4000.BRANCH_FROM_PAGE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Ramificar a partir da p\00E1gina')
);
wwv_flow_api.create_message(
 p_