prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4605
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4605 - Oracle APEX Issues
--
-- Application Export:
--   Application:     4605
--   Name:            Oracle APEX Issues
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                     43
--       Items:                  139
--       Computations:            18
--       Validations:             10
--       Processes:               82
--       Regions:                168
--       Buttons:                104
--       Dynamic Actions:         65
--     Shared Components:
--       Logic:
--         Items:                 23
--         Processes:              2
--         Computations:           3
--         Build Options:          3
--       Navigation:
--         Lists:                  8
--         Breadcrumbs:            1
--           Entries:             27
--       Security:
--         Authentication:         1
--         Authorization:         12
--       User Interface:
--         Templates:
--           Page:                 9
--           Region:              44
--           Label:               11
--           List:                17
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           1
--           Button:               7
--           Report:              22
--         LOVs:                  11
--         Shortcuts:              2
--         Plug-ins:              17
--       Globalization:
--       Reports:
--       E-Mail:
--         Templates:              2
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Issues')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286629489754934029')
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20191024135345'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'19.2'
,p_flow_language=>'pt-br'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(544702116026132813.4605)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_vpd=>'wwv_flow_ws_auth.init_schema;'
,p_security_scheme=>wwv_flow_api.id(183695412901211253)
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'MSG_LANGUAGE'
,p_substitution_value_01=>'Idioma'
,p_substitution_string_02=>'MSG_USER'
,p_substitution_value_02=>unistr('Usu\00E1rio')
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>unistr('Espa\00E7o de Trabalho: &COMPANY.')
,p_substitution_string_04=>'DELETE_MSG'
,p_substitution_value_04=>unistr('Gostaria de executar esta a\00E7\00E3o de exclus\00E3o?')
,p_substitution_string_05=>'PRODUCT_NAME'
,p_substitution_value_05=>'Application Express'
,p_substitution_string_06=>'HELP'
,p_substitution_value_06=>'Ajuda'
,p_substitution_string_07=>'EDIT'
,p_substitution_value_07=>'Editar'
,p_substitution_string_08=>'TOP'
,p_substitution_value_08=>'Superior'
,p_substitution_string_09=>'CLOSE'
,p_substitution_value_09=>'Fechar'
,p_substitution_string_10=>'MSG_COPYRIGHT'
,p_substitution_value_10=>'Copyright &copy; 1999, 2019, Oracle. Todos os direitos reservados.'
,p_substitution_string_11=>'DATE_FORMAT'
,p_substitution_value_11=>'dd/mm/rr'
,p_substitution_string_12=>'MSG_JSCRIPT'
,p_substitution_value_12=>unistr('Voc\00EA deve executar este produto com o JavaScript ativado.')
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141338'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/issues_jump_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(5181728677916157.4605)
,p_name=>'Issues Jump Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16168536941093080.4605)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Problemas'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-list'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16180080482256471.4605)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>'Exibir Meu Perfil'
,p_list_item_link_target=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.:RP:P500_USER_NAME:&APP_USER.:'
,p_list_item_icon=>'fa fa-user'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16172422180101261.4605)
,p_list_item_display_sequence=>12
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5181944583916158.4605)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Gerenciar Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-tags'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5182389007916162.4605)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Gerenciar Marcos'
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-map-signs'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5182706276916162.4605)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Gerenciar Modelos'
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-files-o'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16177134226140587.4605)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(16168929118093088.4605)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Utilit\00E1rios')
,p_list_item_link_target=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-wrench'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(5251802537036599.4605)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'App Builder'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW::'
,p_list_item_icon_alt_attribute=>'Drill-down do Application Builder'
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_api.id(183694515603211251)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5252401971036611.4605)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Aplicativos de Banco de Dados'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:DATABASE:'
,p_parent_list_item_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5252844506036613.4605)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Aplicativos de Websheet'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:WEBSHEET:'
,p_parent_list_item_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5253276482036613.4605)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5253638356036613.4605)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Criar'
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID:'
,p_parent_list_item_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5254074795036613.4605)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Importar'
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:F4000_P56_CREATE_OPTION,P460_FILE_TYPE:IMP,FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5254449813036614.4605)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Exportar'
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5254843947036614.4605)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5255289379036614.4605)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>unistr('Utilit\00E1rios de Espa\00E7o de Trabalho')
,p_parent_list_item_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5255655140036614.4605)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>unistr('Todos os Utilit\00E1rios de Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(5255289379036614.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5256075954036614.4605)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(5255289379036614.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5256434081036615.4605)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>unistr('Padr\00F5es do App Builder')
,p_list_item_link_target=>'f?p=4000:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(5255289379036614.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5256834468036615.4605)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>unistr('Temas de Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(5255289379036614.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5257222669036615.4605)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>'Grupos de Aplicativos'
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_api.id(5255289379036614.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5257610331036615.4605)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>'Views do Application Express'
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(5255289379036614.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5258089674036615.4605)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>unistr('Relat\00F3rios entre Aplicativos')
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(5255289379036614.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5258437457036616.4605)
,p_list_item_display_sequence=>169
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5258870305036616.4605)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('Migra\00E7\00F5es')
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5252023031036605.4605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5259273028036616.4605)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'SQL Workshop'
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>'Drill-down do SQL Workshop'
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_api.id(183694924473211252)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5259665699036616.4605)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Browser de Objetos'
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5259273028036616.4605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5260069543036617.4605)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'Comandos SQL'
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5259273028036616.4605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5260436953036617.4605)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Scripts SQL'
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5259273028036616.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('Utilit\00E1rios')
,p_parent_list_item_id=>wwv_flow_api.id(5259273028036616.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5261243650036617.4605)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>unistr('Todos os Utilit\00E1rios')
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5261654532036617.4605)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5262022150036639.4605)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>'Data Workshop'
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5262417967036639.4605)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>'Construtor de Consultas'
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5262856644036640.4605)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>unistr('SQL R\00E1pida')
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5263253617036640.4605)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>'Conjuntos de Dados de Amostra'
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5263623442036640.4605)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>'Gerar DDL'
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5264073733036640.4605)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>unistr('Padr\00F5es da Interface do Usu\00E1rio')
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5264428148036640.4605)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>unistr('Compara\00E7\00E3o de Esquemas')
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5264878435036641.4605)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('M\00E9todos em Tabelas')
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5265215399036641.4605)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>'Lixeira'
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5265626007036641.4605)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>unistr('Relat\00F3rios de Objetos')
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5266058341036641.4605)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>'Sobre o BD'
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5266483775036641.4605)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>'Monitor de Banco de Dados'
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(5260839481036617.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5266819235036642.4605)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>unistr('Servi\00E7os RESTful')
,p_list_item_link_target=>'f?p=4850:500:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(5259273028036616.4605)
,p_security_scheme=>wwv_flow_api.id(807841331942262216)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5297237022094844.4605)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Team Development'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>'Drill Down de Problemas'
,p_list_text_01=>'tab-team-dev'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5298294556155132.4605)
,p_list_item_display_sequence=>301
,p_list_item_link_text=>'Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(5297237022094844.4605)
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5299469878216734.4605)
,p_list_item_display_sequence=>302
,p_list_item_link_text=>'Marcos'
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(5297237022094844.4605)
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5299708358219790.4605)
,p_list_item_display_sequence=>303
,p_list_item_link_text=>'Modelos'
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(5297237022094844.4605)
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5302803126254705.4605)
,p_list_item_display_sequence=>304
,p_list_item_link_text=>unistr('Utilit\00E1rios')
,p_list_item_link_target=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(5297237022094844.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5298748302170715.4605)
,p_list_item_display_sequence=>308
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(5297237022094844.4605)
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5267230397036642.4605)
,p_list_item_display_sequence=>309
,p_list_item_link_text=>'Feedback'
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.:RP'
,p_list_item_icon_alt_attribute=>'Drill-down do Team Development'
,p_parent_list_item_id=>wwv_flow_api.id(5297237022094844.4605)
,p_list_text_01=>'tab-team-dev'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5275699929036648.4605)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Galeria de Aplicativos'
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_text_01=>'tab-apps'
,p_security_scheme=>wwv_flow_api.id(768489712602134102)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5276043705036648.4605)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>'Aplicativos de Produtividade'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:PACKAGE'
,p_parent_list_item_id=>wwv_flow_api.id(5275699929036648.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5276411691036648.4605)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>'Aplicativos de Amostra'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:SAMPLE'
,p_parent_list_item_id=>wwv_flow_api.id(5275699929036648.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5276810956036648.4605)
,p_list_item_display_sequence=>425
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(5275699929036648.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5277251355036649.4605)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>unistr('Administra\00E7\00E3o')
,p_list_item_link_target=>'f?p=4750:6:&SESSION.::&DEBUG.:6:'
,p_parent_list_item_id=>wwv_flow_api.id(5275699929036648.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/issues_action_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6321465669737549.4605)
,p_name=>'Issues Action Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6321683875737582.4605)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Editar T\00EDtulo')
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-pencil-square-o'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' ',
'  from wwv_flow_issues',
' where id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id',
'   and (created_by = :APP_USER',
'        or ',
'        instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0)'))
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6395527024620562.4605)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Editar Texto do Problema'
,p_list_item_link_target=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-pencil-square-o'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' ',
'  from wwv_flow_issues',
' where id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id',
'   and (created_by = :APP_USER',
'        or ',
'        instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0)'))
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6428625570476851.4605)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6322436967737593.4605)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Definir Favorecidos'
,p_list_item_link_target=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-user-edit'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6322865946737593.4605)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Definir Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:107:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-tags'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6323201645737593.4605)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Definir Marcos'
,p_list_item_link_target=>'f?p=&APP_ID.:106:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-map-signs'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6659247514556184.4605)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6397756984628146.4605)
,p_list_item_display_sequence=>81
,p_list_item_link_text=>unistr('Associar a Aplicativo ou P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:104:&SESSION.::&DEBUG.:104:::'
,p_list_item_icon=>'fa fa-window-plus'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6322058914737592.4605)
,p_list_item_display_sequence=>85
,p_list_item_link_text=>'Marcar como Duplicado'
,p_list_item_link_target=>'f?p=&APP_ID.:103:&SESSION.::&DEBUG.:103:::'
,p_list_item_icon=>'fa fa-synonym'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6667497053606755.4605)
,p_list_item_display_sequence=>86
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10542353923952887.4605)
,p_list_item_display_sequence=>87
,p_list_item_link_text=>'Excluir Problema'
,p_list_item_icon=>'fa fa-trash-o'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' ',
'  from wwv_flow_issues',
' where id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id',
'   and (created_by = :APP_USER',
'        or ',
'        instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0)'))
,p_list_text_01=>'delete_issue_item'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10542678463952909.4605)
,p_list_item_display_sequence=>88
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6667150941606755.4605)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Fechar Problema'
,p_list_item_link_target=>'javascript:apex.page.submit(''CLOSE'');'
,p_list_item_icon=>'fa fa-check-circle-o'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P100_STATUS'
,p_list_item_disp_condition2=>'OPEN'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6668182022614506.4605)
,p_list_item_display_sequence=>95
,p_list_item_link_text=>'Reabrir Problema'
,p_list_item_link_target=>'javascript:apex.page.submit(''REOPEN'');'||wwv_flow.LF||
''
,p_list_item_icon=>'fa fa-undo-alt'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P100_STATUS'
,p_list_item_disp_condition2=>'CLOSED'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/issues_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10555300999175496.4605)
,p_name=>'Issues Utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10555576852175501.4605)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Gerenciar Problemas Exclu\00EDdos')
,p_list_item_link_target=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-exclamation-circle-o'
,p_list_text_01=>unistr('Expurgar ou Reintegrar problemas que foram exclu\00EDdos.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10883541872039963.4605)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Gerenciar Modelos'
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:RP,1000:::'
,p_list_item_icon=>'fa fa-synonym'
,p_list_text_01=>unistr('Gerencie Modelos de Problemas e Coment\00E1rios.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11079055119909322.4605)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Gerenciar Marcos'
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:RP,200:::'
,p_list_item_icon=>'fa fa-map-signs'
,p_list_text_01=>unistr('Gerenciar Marcos como dispon\00EDveis para designa\00E7\00E3o a Problemas')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11079571642916049.4605)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Gerenciar Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP,300:::'
,p_list_item_icon=>'fa fa-tags'
,p_list_text_01=>unistr('Gerenciar Labels e Grupos de Label dispon\00EDveis para designa\00E7\00E3o a Problemas')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11085752017069486.4605)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Exibir Arquivos'
,p_list_item_link_target=>'f?p=&APP_ID.:2030:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-folder-file'
,p_list_text_01=>'Veja detalhes dos arquivos transferidos por upload para Problemas.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11085146769053736.4605)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Expurgar Dados'
,p_list_item_link_target=>'f?p=&APP_ID.:2020:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-trash-o'
,p_list_text_01=>'Expurgue todos os dados dos componentes selecionados.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11086206760089752.4605)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Atualizar Favorecidos'
,p_list_item_link_target=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-user-check'
,p_list_text_01=>unistr('Execute redesigna\00E7\00E3o em massa de Problemas designados a um determinado usu\00E1rio.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11086771269112985.4605)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('Redesignar Propriet\00E1rio')
,p_list_item_link_target=>'f?p=&APP_ID.:2050:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-users'
,p_list_text_01=>unistr('Redesigna\00E7\00E3o em massa do propriet\00E1rio do problema para um determinado usu\00E1rio.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11087216341139132.4605)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Remover Marco de Todos os Problemas'
,p_list_item_link_target=>'f?p=&APP_ID.:2060:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-map-signs fam-minus fam-is-disabled fa-lg'
,p_list_text_01=>'Remova um determinado marco de todos os problemas.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11087732023154648.4605)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Remover Labels de Todos os Problemas'
,p_list_item_link_target=>'f?p=&APP_ID.:2070:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-tags fam-minus fam-is-disabled fa-lg'
,p_list_text_01=>'Remova Labels especificados de todos os Problemas.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1639797396471215.4605)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('Gerenciar Prefer\00EAncias de Notifica\00E7\00E3o do Usu\00E1rio')
,p_list_item_link_target=>'f?p=&APP_ID.:2080:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-envelope-o'
,p_list_text_01=>'Manage the notification preferences for all users  in the workspace.'
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15789672192155205.4605)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Team Development Legado (Obsoleto)'
,p_list_item_link_target=>'f?p=4800:4000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-commenting-o'
,p_list_text_01=>'Navigate to the Team Development pages. This section of APEX has now been deprecated.'
,p_security_scheme=>wwv_flow_api.id(183695412901211253)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/user_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(11496705512045322.4605)
,p_name=>'User Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11496998817045325.4605)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Problemas'
,p_list_item_link_target=>'f?p=&APP_ID.:500:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(11497325343045337.4605)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Notifica\00E7\00F5es')
,p_list_item_link_target=>'f?p=&APP_ID.:502:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/navigation_icons
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(182126621824656316.4605)
,p_name=>'navigation icons'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(702381952631922533.4605)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702382115982922536.4605)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('Administra\00E7\00E3o')
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702382408956922537.4605)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702382744919922537.4605)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('Gerenciar Servi\00E7o')
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702383056161922537.4605)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('Gerenciar Servi\00E7o')
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(702382744919922537.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702383312325922537.4605)
,p_list_item_display_sequence=>215
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(702382744919922537.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702383669443922538.4605)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('Fazer uma Solicita\00E7\00E3o de Servi\00E7o')
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(702382744919922537.4605)
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702384257135922538.4605)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('Editar An\00FAncio')
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(702382744919922537.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702384584543922538.4605)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('Utiliza\00E7\00E3o do Espa\00E7o de Trabalho')
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(702382744919922537.4605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702384861674922538.4605)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('Gerenciar Usu\00E1rios e Grupos')
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702385112276922538.4605)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Monitorar Atividade'
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(15353907298685325)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702385449098922539.4605)
,p_list_item_display_sequence=>500
,p_list_item_link_text=>unistr('Pain\00E9is de Controle')
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(15353907298685325)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(702386956612924063.4605)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702387138145924064.4605)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Documenta\00E7\00E3o')
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2110715883843512302.4605)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('F\00F3rum de Discuss\00E3o')
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2190261126573039321.4605)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Oracle Technology Network'
,p_list_item_link_target=>'http://otn.oracle.com/apex'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(702388035956924065.4605)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(895735745336087.4605)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(6826142137869668.4605)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(19608224744399589.4605)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(96742782884031030.4605)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(274218939827863713.4605)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.D3.BARCHART'
,p_attribute_01=>'3'
,p_attribute_02=>'1.333'
,p_attribute_03=>'480'
,p_attribute_04=>'WINDOW'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1769832374372170712.4605)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1836482126643452536.4605)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1922397339626398570.4605)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2015742369962577737.4605)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.FLOTLINECHART2'
,p_attribute_01=>'3'
,p_attribute_02=>'1.333'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(15353907298685325.4605)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a acessar Pain\00E9is e Monitorar Atividade.')
,p_reference_id=>786936829326142579.4605
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(17268112003727577.4605)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a editar aplicativos')
,p_reference_id=>12480509677812756.4605
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(17281223028976738.4605)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a administrar aplicativos')
,p_reference_id=>12511219858301010.4605
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(183694515603211251.4605)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('N\00E3o h\00E1 privil\00E9gios para a opera\00E7\00E3o em quest\00E3o')
,p_reference_id=>786516029127697713.4605
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(183694924473211252.4605)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a usar o SQL Workshop')
,p_reference_id=>786516265251697717.4605
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(183695412901211253.4605)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('O Team Development n\00E3o est\00E1 ativado para este espa\00E7o de trabalho')
,p_reference_id=>786516861027697723.4605
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(183695930909211253.4605)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('N\00E3o h\00E1 privil\00E9gios para a opera\00E7\00E3o em quest\00E3o')
,p_reference_id=>786517166823697723.4605
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/team_dev_file_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(328409007532727880.4605)
,p_name=>'Team Dev File Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_team_file.team_dev_file_enabled then',
'   return true;',
'else',
'   return false;',
'end if;'))
,p_error_message=>unistr('O acesso a esta p\00E1gina requer que os arquivos de desenvolvimento da equipe sejam ativados.')
,p_reference_id=>786943600005207200.4605
,p_caching=>'NOCACHE'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(339062033074422888.4605)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>unistr('O SSO do Builder n\00E3o est\00E1 ativado')
,p_reference_id=>6738410669854771.4605
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_packaged_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(768489712602134102.4605)
,p_name=>'APEX 5.0 Packaged App Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a instalar Aplicativos Empacotados')
,p_reference_id=>786517456817697723.4605
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_restful_services_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(807841331942262216.4605)
,p_name=>'APEX 5.0 RESTful Services Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies',
'where ALLOW_RESTFUL_SERVICES_YN = ''Y'' and ',
'      PROVISIONING_COMPANY_ID = :flow_security_group_id',
'and exists (select 1',
'                  from wwv_flow_platform_prefs',
'                 where name  = ''RESTFUL_SERVICES_ENABLED''',
'                   and value = ''Y'')'))
,p_error_message=>unistr('N\00E3o h\00E1 privil\00E9gios para a opera\00E7\00E3o em quest\00E3o')
,p_reference_id=>786519856057734816.4605
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/service_requests_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(922396026104496881.4605)
,p_name=>'Service Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'' then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>unistr('N\00E3o h\00E1 privil\00E9gios para a opera\00E7\00E3o em quest\00E3o.')
,p_reference_id=>786932326296107981.4605
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(115174850856693681.4605)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(238481725164011026.4605)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'   p_app_id           => wwv_flow.g_x01,',
'   p_get_apps_list    => wwv_flow.g_x02);'))
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(37912420806172595.4605)
,p_name=>'AJAX_WS_ACTION'
,p_protection_level=>'N'
,p_item_comment=>'FILTER,SEARCH,SORT'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(37940528715420891.4605)
,p_name=>'AJAX_WS_COLUMN'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(37939746245416465.4605)
,p_name=>'AJAX_WS_FILTER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(37938333085412702.4605)
,p_name=>'AJAX_WS_FILTER_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(38842438717798590.4605)
,p_name=>'AJAX_WS_NUM'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(38688041917115502.4605)
,p_name=>'APPROVAL_STATUS'
,p_data_type=>'NUMBER'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(806410516575908378.4605)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(174573819842644837.4605)
,p_name=>'F4600_LAST_VIEW'
,p_protection_level=>'B'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185417628459576998.4605)
,p_name=>'FOLDER_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(168218724319674550.4605)
,p_name=>'FSP_AFTER_LOGIN_URL'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(21369340420081660.4605)
,p_name=>'ITEM_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(210854931189892354.4605)
,p_name=>'MSG_COMPANY'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(190079937165083234.4605)
,p_name=>'OWNER_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(193240824799898826.4605)
,p_name=>'RPT_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185565221971032033.4605)
,p_name=>'SHOWNAV'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(21400435233205909.4605)
,p_name=>'TEMPORARY_ACTION'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(36523045963068949.4605)
,p_name=>'TEMPORARY_FILTER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(21400031770204912.4605)
,p_name=>'TEMPORARY_FOLDER'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(21373845287234405.4605)
,p_name=>'TEMPORARY_ITEM'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(17476426782744789.4605)
,p_name=>'WORKGROUP'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(17484043348395783.4605)
,p_name=>'WORKGROUP_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(37236418088215827.4605)
,p_name=>'WORKSHEET_FILTER_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(92353535466226138.4605)
,p_name=>'WORKSHEET_NAME'
,p_protection_level=>'I'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(806410907010915119.4605)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>unistr('N\00E3o \00E9 poss\00EDvel calcular o nome do espa\00E7o de trabalho.')
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(38688210218120326.4605)
,p_computation_sequence=>10
,p_computation_item=>'APPROVAL_STATUS'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'QUERY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'select default_rpt_feature_type_id from wwv_flow_task_defaults'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(185565827511033694.4605)
,p_computation_sequence=>10
,p_computation_item=>'SHOWNAV'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'Y'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/application_and_page_search
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(668635072324511178.4605)
,p_lov_name=>'APPLICATION AND PAGE SEARCH'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id|| '' - ''|| f.name||''(''||f.alias||'')'' APP_NAME,',
'       --f.alias APP_ALIAS,',
'       f.id APP_ID,',
'       s.id||'' - ''||s.name PAGE_NAME, ',
'       s.alias PAGE_ALIAS,',
'       s.id PAGE_ID,',
'       g.group_name',
'  from wwv_flows f, ',
'       wwv_flow_steps s, ',
'       wwv_flow_page_groups g',
' where f.security_group_id = :flow_security_group_id',
'   and s.flow_id = f.id',
'   and g.id (+) = s.group_id',
'   and not exists (',
'    select null',
'      from wwv_flow_language_map',
'     where translation_flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
')',
'   and ( exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id is null',
'       and security_group_id = :flow_security_group_id',
')',
'    or exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
') )',
'order by f.id, s.id'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'APP_ID'
,p_display_column_name=>'APP_NAME'
,p_group_column_name=>'APP_NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'PAGE_ID'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(672265511386888773.4605)
,p_query_column_name=>'APP_ID'
,p_display_sequence=>10
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(672265939351888774.4605)
,p_query_column_name=>'APP_NAME'
,p_heading=>'Nome do Aplicativo'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(672266395240888774.4605)
,p_query_column_name=>'PAGE_ID'
,p_heading=>unistr('Id da P\00E1gina')
,p_display_sequence=>30
,p_data_type=>'NUMBER'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(672266756188888774.4605)
,p_query_column_name=>'PAGE_NAME'
,p_heading=>unistr('Nome da P\00E1gina')
,p_display_sequence=>40
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(672267116153888774.4605)
,p_query_column_name=>'PAGE_ALIAS'
,p_heading=>unistr('Alias da P\00E1gina')
,p_display_sequence=>50
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(672267522080888774.4605)
,p_query_column_name=>'GROUP_NAME'
,p_heading=>'Nome do Grupo'
,p_display_sequence=>60
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_name_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(5887246189354055.4605)
,p_lov_name=>'APPLICATION NAME RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id',
'       || ''. ''',
'       || name d,',
'       id r',
'  from wwv_flows f',
' where security_group_id = :flow_security_group_id',
'   and not exists (',
'    select null',
'      from wwv_flow_language_map',
'     where translation_flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
')',
'   and ( exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id is null',
'       and security_group_id = :flow_security_group_id',
')',
'    or exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
') )',
'order by id'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'R'
,p_display_column_name=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/intervals
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1656102236549848.4605)
,p_lov_name=>'INTERVALS'
,p_lov_query=>'.'||wwv_flow_api.id(1656102236549848.4605)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1656418374549852.4605)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Imediatamente'
,p_lov_return_value=>'IMMEDIATELY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1656826725549855.4605)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Resumo por Hora'
,p_lov_return_value=>'HOURLY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1657255076549856.4605)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Resumo Di\00E1rio')
,p_lov_return_value=>'DAILY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/issue_statuses_static
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(5664182917694426.4605)
,p_lov_name=>'ISSUE_STATUSES_STATIC'
,p_lov_query=>'.'||wwv_flow_api.id(5664182917694426.4605)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5664453481694435.4605)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Aberto'
,p_lov_return_value=>'OPEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5664876171694445.4605)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Fechado'
,p_lov_return_value=>'CLOSED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/label_group_colors
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(5734638238767974.4605)
,p_lov_name=>'LABEL_GROUP_COLORS'
,p_lov_query=>'.'||wwv_flow_api.id(5734638238767974.4605)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5734918745767983.4605)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cor 1'
,p_lov_return_value=>'label-color-1'
,p_lov_template=>'<span class="color-option label-color-1" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5735321525788743.4605)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Cor 2'
,p_lov_return_value=>'label-color-2'
,p_lov_template=>'<span class="color-option label-color-2" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5735679529788743.4605)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Cor 3'
,p_lov_return_value=>'label-color-3'
,p_lov_template=>'<span class="color-option label-color-3" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5736043280788744.4605)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Cor 4'
,p_lov_return_value=>'label-color-4'
,p_lov_template=>'<span class="color-option label-color-4" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5736405025788744.4605)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Cor 5'
,p_lov_return_value=>'label-color-5'
,p_lov_template=>'<span class="color-option label-color-5" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5736803684788744.4605)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Cor 6'
,p_lov_return_value=>'label-color-6'
,p_lov_template=>'<span class="color-option label-color-6" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5737219761788744.4605)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Cor 7'
,p_lov_return_value=>'label-color-7'
,p_lov_template=>'<span class="color-option label-color-7" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5737679091788744.4605)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Cor 8'
,p_lov_return_value=>'label-color-8'
,p_lov_template=>'<span class="color-option label-color-8" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5738078036788745.4605)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Cor 9'
,p_lov_return_value=>'label-color-9'
,p_lov_template=>'<span class="color-option label-color-9" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5738459690788747.4605)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cor 10'
,p_lov_return_value=>'label-color-10'
,p_lov_template=>'<span class="color-option label-color-10" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5738861781788748.4605)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Cor 11'
,p_lov_return_value=>'label-color-11'
,p_lov_template=>'<span class="color-option label-color-11" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5739240848788748.4605)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Cor 12'
,p_lov_return_value=>'label-color-12'
,p_lov_template=>'<span class="color-option label-color-12" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5739685253788748.4605)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Cor 13'
,p_lov_return_value=>'label-color-13'
,p_lov_template=>'<span class="color-option label-color-13" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5740078115788748.4605)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Cor 14'
,p_lov_return_value=>'label-color-14'
,p_lov_template=>'<span class="color-option label-color-14" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5740411405788748.4605)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Cor 15'
,p_lov_return_value=>'label-color-15'
,p_lov_template=>'<span class="color-option label-color-15" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6071628520214755.4605)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Cor 16'
,p_lov_return_value=>'label-color-16'
,p_lov_template=>'<span class="color-option label-color-16" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6071948620214757.4605)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Cor 17'
,p_lov_return_value=>'label-color-17'
,p_lov_template=>'<span class="color-option label-color-17" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6072354386214757.4605)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Cor 18'
,p_lov_return_value=>'label-color-18'
,p_lov_template=>'<span class="color-option label-color-18" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6072701888214757.4605)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'Cor 19'
,p_lov_return_value=>'label-color-19'
,p_lov_template=>'<span class="color-option label-color-19" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6073167607214758.4605)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Cor 20'
,p_lov_return_value=>'label-color-20'
,p_lov_template=>'<span class="color-option label-color-20" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6073559823214758.4605)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'Cor 21'
,p_lov_return_value=>'label-color-21'
,p_lov_template=>'<span class="color-option label-color-21" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6073957520214758.4605)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>'Cor 22'
,p_lov_return_value=>'label-color-22'
,p_lov_template=>'<span class="color-option label-color-22" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6074341681214758.4605)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>'Cor 23'
,p_lov_return_value=>'label-color-23'
,p_lov_template=>'<span class="color-option label-color-23" aria-hidden="true"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6074730945214758.4605)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>'Cor 24'
,p_lov_return_value=>'label-color-24'
,p_lov_template=>'<span class="color-option label-color-24" aria-hidden="true"></span>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/localized_open_closed
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(15773100381005765.4605)
,p_lov_name=>'LOCALIZED OPEN CLOSED'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.OPEN'') d, ''OPEN'' r ',
'from dual',
'UNION',
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.CLOSED'') d, ''CLOSED'' r ',
'from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/notification_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1643009509517335.4605)
,p_lov_name=>'NOTIFICATION TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(1643009509517335.4605)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1643337181517343.4605)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Texto do Problema Editado'
,p_lov_return_value=>'ISSUE_EDIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1643790317517359.4605)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Novo Coment\00E1rio')
,p_lov_return_value=>'COMMENT_ADD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1644118795517363.4605)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Texto do Coment\00E1rio Editado')
,p_lov_return_value=>'COMMENT_EDIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1644519868517363.4605)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Status '
,p_lov_return_value=>'STATUS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1644981141517367.4605)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Favorecido'
,p_lov_return_value=>'ASSIGNEE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1645366808517367.4605)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Assinante'
,p_lov_return_value=>'SUBSCRIBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1645788275517368.4605)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Marco'
,p_lov_return_value=>'MILESTONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1646162433517368.4605)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Label'
,p_lov_return_value=>'LABEL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1646597713517368.4605)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Marcado como Duplicado'
,p_lov_return_value=>'DUPLICATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1646959379517368.4605)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Designa\00E7\00E3o de Aplicativo/P\00E1gina')
,p_lov_return_value=>'ASSOCIATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1647355568517369.4605)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Anexo(s)'
,p_lov_return_value=>'ATTACHMENT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/response_templates
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6673547635351160.4605)
,p_lov_name=>'RESPONSE_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select template_name as d,',
'       id as r',
'  from wwv_flow_issue_templates',
' where template_type = ''RESPONSE'' ',
'   and security_group_id = :flow_security_group_id',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/template_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(5337630119489013.4605)
,p_lov_name=>'TEMPLATE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(5337630119489013.4605)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5337833082489021.4605)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Resposta'
,p_lov_return_value=>'RESPONSE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5338249958489023.4605)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Problema'
,p_lov_return_value=>'ISSUE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/workspace_users
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(5669473527908412.4605)
,p_lov_name=>'WORKSPACE_USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'       case ',
'            when first_name||last_name is null then "USER"',
'            else first_name||'' ''||last_name',
'        end display,',
'         a."USER" return ',
'from wwv_flow_workspace_users a',
'where workspace_id = :flow_security_group_id'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'RETURN'
,p_display_column_name=>'DISPLAY'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'DISPLAY'
,p_default_sort_direction=>'ASC_NULLS_FIRST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(17525524968129983.4605)
,p_lov_name=>'YES NO RETURNS Y N'
,p_lov_query=>'.'||wwv_flow_api.id(17525524968129983.4605)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17525727619129986.4605)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Sim'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17525935048129988.4605)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('N\00E3o')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/issues_breadcrumbs
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(92331531826187224.4605)
,p_name=>'Issues Breadcrumbs'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1609827273716053.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>unistr('Gerenciar Prefer\00EAncias de Notifica\00E7\00E3o')
,p_link=>'f?p=&APP_ID.:2080:&SESSION.'
,p_page_id=>2080
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4881171519105736.4605)
,p_parent_id=>wwv_flow_api.id(5845246212205599.4605)
,p_short_name=>'Detalhes do Problema'
,p_link=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:::'
,p_page_id=>100
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4882133165116855.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Marcos'
,p_link=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:::'
,p_page_id=>200
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4882644814119470.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Labels'
,p_link=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:::'
,p_page_id=>300
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5001217954462703.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Modelos'
,p_link=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:::'
,p_page_id=>1000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5001686955462712.4605)
,p_parent_id=>wwv_flow_api.id(5001217954462703.4605)
,p_short_name=>'Editar Modelo'
,p_link=>'f?p=&APP_ID.:1010:&SESSION.'
,p_page_id=>1010
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5353737069645712.4605)
,p_parent_id=>wwv_flow_api.id(4882133165116855.4605)
,p_short_name=>'Marco'
,p_link=>'f?p=&APP_ID.:210:&SESSION.'
,p_page_id=>210
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5384647942926430.4605)
,p_parent_id=>wwv_flow_api.id(4882133165116855.4605)
,p_short_name=>'Marco'
,p_link=>'f?p=&APP_ID.:205:&SESSION.'
,p_page_id=>205
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5714590146586339.4605)
,p_parent_id=>wwv_flow_api.id(4882644814119470.4605)
,p_short_name=>'Gerenciar Labels'
,p_link=>'f?p=&APP_ID.:305:&SESSION.'
,p_page_id=>305
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5845246212205599.4605)
,p_parent_id=>wwv_flow_api.id(116983012395599679.4605)
,p_short_name=>'Problemas'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6132745478763966.4605)
,p_parent_id=>wwv_flow_api.id(116983012395599679.4605)
,p_short_name=>unistr('Utilit\00E1rios ')
,p_link=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.:::'
,p_page_id=>2000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6157811337242892.4605)
,p_parent_id=>wwv_flow_api.id(116983012395599679.4605)
,p_short_name=>unistr('Perfil do Usu\00E1rio')
,p_link=>'f?p=&APP_ID.:500:&SESSION.'
,p_page_id=>500
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10558517588230547.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>unistr('Gerenciar Problemas Exclu\00EDdos')
,p_link=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.:::'
,p_page_id=>2010
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11145298131075273.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Expurgar Dados '
,p_link=>'f?p=&APP_ID.:2020:&SESSION.::&DEBUG.:::'
,p_page_id=>2020
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11158477298366433.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Arquivos de Problema'
,p_link=>'f?p=&APP_ID.:2030:&SESSION.'
,p_page_id=>2030
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11223139265628904.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Atualizar Favorecidos'
,p_link=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.:::'
,p_page_id=>2040
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11225065027657825.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Remover Marcos'
,p_link=>'f?p=&APP_ID.:2060:&SESSION.::&DEBUG.:::'
,p_page_id=>2060
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11225560985663098.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Remover Labels'
,p_link=>'f?p=&APP_ID.:2070:&SESSION.::&DEBUG.:::'
,p_page_id=>2070
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11263840466388445.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>unistr('Redesignar Propriet\00E1rio')
,p_link=>'f?p=&APP_ID.:2050:&SESSION.::&DEBUG.:::'
,p_page_id=>2050
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11264768364404173.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Atualizar Favorecidos'
,p_link=>'f?p=&APP_ID.:2045:&SESSION.::&DEBUG.:::'
,p_page_id=>2045
,p_security_scheme=>wwv_flow_api.id(17281223028976738)
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11272348512449506.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>unistr('Redesignar Propriet\00E1rio')
,p_link=>'f?p=&APP_ID.:2055:&SESSION.'
,p_page_id=>2055
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11304459558976959.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Remover Marco'
,p_link=>'f?p=&APP_ID.:2065:&SESSION.'
,p_page_id=>2065
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11316325099178200.4605)
,p_parent_id=>wwv_flow_api.id(6132745478763966.4605)
,p_short_name=>'Remover Marcos'
,p_link=>'f?p=&APP_ID.:2075:&SESSION.'
,p_page_id=>2075
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(11492813428017727.4605)
,p_parent_id=>wwv_flow_api.id(116983012395599679.4605)
,p_short_name=>unistr('Perfil do Usu\00E1rio')
,p_link=>'f?p=&APP_ID.:502:&SESSION.::&DEBUG.:::'
,p_page_id=>502
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(116983012395599679.4605)
,p_parent_id=>wwv_flow_api.id(.4605)
,p_short_name=>'<span class="u-VisuallyHidden">Problemas</span><span class="a-Icon icon-breadcrumb-previous" title="Issues"></span>'
,p_link=>'f?p=&APP_ID.:999:&SESSION.::&DEBUG.:::'
,p_page_id=>999
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(393283835495701129.4605)
,p_parent_id=>wwv_flow_api.id(.4605)
,p_short_name=>'0'
,p_link=>'f?p=&FLOW_ID.:0:&SESSION.'
,p_page_id=>0
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(597593414202185271.4605)
,p_parent_id=>wwv_flow_api.id(5845246212205599.4605)
,p_short_name=>'Bem-vindo'
,p_link=>'f?p=&APP_ID.:10:&SESSION.'
,p_page_id=>10
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_page_edit_page_4150
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(21618168739790751.4605)
,p_theme_id=>101
,p_name=>'APEX 4.2 - Page Edit Page (4150).pt-br'
,p_internal_name=>'APEX_4.2_PAGE_EDIT_PAGE_4150'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div id="ContentBody">',
'    #REGION_POSITION_02##REGION_POSITION_01#',
'    <table border="0" cellpadding="0" cellspacing="0" summary="" width="100%" id="body4150">',
'      <tbody>',
'        <tr>',
'          <td valign="top" style="width:44%;" class="comp-view-col-cell">',
'            <div class="comp-view-col">',
'              #REGION_POSITION_03#',
'            </div>',
'          </td>',
'          <td valign="top" style="width:28%;" class="comp-view-col-cell">',
'            <div class="comp-view-col">',
'            #REGION_POSITION_04#',
'            </div>',
'          </td>',
'          <td valign="top" style="width:28%;" class="comp-view-col-cell">',
'            <div class="comp-view-col">',
'            #REGION_POSITION_05#',
'            </div>',
'          </td>',
'        </tr>',
'      </tbody>',
'    </table>',
'    #BODY#',
'  </div>',
'</div>',
'',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>16407516425591353.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_popup
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(25147761418110187.4605)
,p_theme_id=>101
,p_name=>'APEX 4.2 - Popup.pt-br'
,p_internal_name=>'APEX_4.2_POPUP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title><link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head><body #ONLOAD# style="padding:5px;min-width:380px;"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>',
'  <div id="RP2">#REGION_POSITION_02#</div>',
'  <div id="RP3">#REGION_POSITION_03#</div>',
'  <div id="RP4">#REGION_POSITION_04#</div>',
'  <div id="RP5">#REGION_POSITION_05#</div>',
'  <div class="popupContent" id="ContentArea">#BODY#</div>',
'</div>',
'<div id="RP8" style="text-align:middle;">#REGION_POSITION_08#</div>',
'<br />',
'<br />',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>36144306570651063.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(126075773730973072.4605)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Dialog.pt-br'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'auto'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_page_designer
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(389915650581127935.4605)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Page Designer.pt-br'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER'
,p_is_popup=>false
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if ( apex.jQuery( "#successMessage" ).length > 0 ) {',
'    window.pageDesigner.showNotification( apex.jQuery( "#successMessage" ).text() );',
'}'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="#PAGE_CSS_CLASSES#">',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_01#',
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" style="display: none;" id="pdNotification">',
' <div class="a-AlertMessages-item">',
'  <div id="pdNotificationState" class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span id="pdNotificationIcon" class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="pdNotificationMessage">#PD_MESSAGE#</h5>',
'      <button id="pdNotificationClose" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'',
'',
'<div id="a_PageDesigner" class="a-PageDesigner resize">',
'  #REGION_POSITION_02#',
'  #REGION_POSITION_03#',
'  #REGION_POSITION_04#',
'  #BODY#',
'  <div style="display:none;">',
'  #REGION_POSITION_06#',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>-->',
'<div style="display: none;" id="successMessage">#SUCCESS_MESSAGE#</div>',
''))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(389915886911127940.4605)
,p_page_template_id=>wwv_flow_api.id(389915650581127935.4605)
,p_name=>'Dialog Area'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>-1
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(391881764116992437.4605)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Right Side Bar.pt-br'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222.4605
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(164505318608427240.4605)
,p_page_template_id=>wwv_flow_api.id(391881764116992437.4605)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(164505800746427240.4605)
,p_page_template_id=>wwv_flow_api.id(391881764116992437.4605)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(164506276586427240.4605)
,p_page_template_id=>wwv_flow_api.id(391881764116992437.4605)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(164506848325427241.4605)
,p_page_template_id=>wwv_flow_api.id(391881764116992437.4605)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(164507257952427241.4605)
,p_page_template_id=>wwv_flow_api.id(391881764116992437.4605)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(164507773640427241.4605)
,p_page_template_id=>wwv_flow_api.id(391881764116992437.4605)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(164508303273427242.4605)
,p_page_template_id=>wwv_flow_api.id(391881764116992437.4605)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(694269863376113197.4605)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Wizard Dialog.pt-br'
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.builder.initWizardModal();',
'apex.builder.initWizardProgressBar();'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="utf-8">  ',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'auto'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--wizard'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689061037088924910.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(694810454825113224.4605)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Edit Screen.pt-br'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4605
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(164510198801427253.4605)
,p_page_template_id=>wwv_flow_api.id(694810454825113224.4605)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(164510663746427255.4605)
,p_page_template_id=>wwv_flow_api.id(694810454825113224.4605)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(703879338414253261.4605)
,p_theme_id=>101
,p_name=>'APEX 5.0 - No Side Bar.pt-br'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(707892828837195217.4605)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Wizard Page.pt-br'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(5208262349044176.4605)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4605
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(5208327130603219.4605)
,p_template_name=>'APEX 5.0 - Icon Badge Menu Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_reference_id=>631020159860848910.4605
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(5208338701524668.4605)
,p_template_name=>'APEX 5.0 - Icon Badge Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><span class="a-But'
||'ton-badge"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><spa'
||'n class="a-Button-badge"></span></button>'
,p_reference_id=>631020282344854024.4605
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(188432383783551716.4605)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4605
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(359238865408012460.4605)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4605
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(656569185201725731.4605)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233.4605
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon_not_escaped
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(2050872492464936456.4605)
,p_template_name=>'APEX 5.0 - Button with Icon - NOT ESCAPED'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON_NOT_ESCAPED'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/region/gray_box_c_htmldbgraybox
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(5204557330889909.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading editRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'      <a href="#" class="aIconButton" onclick="uF();return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" class="upIcon" alt="&TOP." /></a>',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Gray Box (c:htmldbGrayBox)'
,p_internal_name=>'GRAY_BOX_C:HTMLDBGRAYBOX'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17353903289599940.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/search_and_replace_region_editor
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(9958270200471956.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <script type="text/javascript">  ',
'    function toggleFind() {',
'      html_ToggleElement(''body#REGION_ID#'');  ',
'    }',
'  </script>',
'  <div id="body#REGION_ID#" style="display:none;">',
'    <table cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_ID#">',
'      <tr>',
'        <td valign="top">#BODY#</td>',
'        <td valign="top">#CLOSE##EDIT##DELETE##CREATE##CREATE2##PREVIOUS##NEXT#</td>',
'      </tr>',
'    </table>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Search and Replace Region (Editor)'
,p_internal_name=>'SEARCH_AND_REPLACE_REGION_EDITOR'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>112829305325461983.4605
,p_translate_this_template=>'N'
,p_template_comment=>'Gray Head, white body'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_dialog
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(10813455696794486.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#"  class="a-DialogRegion js-regionDialog #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# style="display:none" title="#TITLE#">',
'  <div class="a-DialogRegion-body">',
'#BODY#',
'  </div>',
'  <div class="a-DialogRegion-buttons">',
'     <div class="a-ButtonRegion a-ButtonRegion--dialogRegion">',
'       <div class="a-ButtonRegion-wrap">',
'         <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'         <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'       </div>',
'     </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region Dialog'
,p_internal_name=>'APEX_5.0_REGION_DIALOG'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_template_options=>'js-draggable:js-modal:js-resizable'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(11142767973379800.4605)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #COMPONENT_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Page Anchors'
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17354206769599941.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_message_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(34638664849443220.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-SystemMessage #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Message Region'
,p_internal_name=>'APEX_5.0_MESSAGE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>29333927116050844.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_small_gray_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37822161250843049.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion smallRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Small (Gray Top)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_SMALL_GRAY_TOP'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>32612420016685806.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box_wide
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(41146075931369682.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-wiz-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# style="width:100%;">',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title"><h2>#TITLE#</h2></div>',
'    <div class="rc-buttons">#CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box (wide)'
,p_internal_name=>'APEX_4.0_WIZARD_BOX_WIDE'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>35936104232216540.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(45982758247246967.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardHeader" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Header'
,p_internal_name=>'APEX_5.0_WIZARD_HEADER'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210710875242480.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(47229974494774989.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Wizard-region a-Form #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Wizard-regionHeader">#REGION_HEADER#</div>',
'  <div class="a-Wizard-regionBody">#BODY#</div>',
'  <div class="a-Wizard-regionFooter">#REGION_FOOTER#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Region'
,p_internal_name=>'APEX_5.0_WIZARD_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>702777601713950915.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body_divider
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(47231973932784377.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion dividerTop" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'<div class="wizardRegionHeading">',
'  <h1>#TITLE#</h1>',
'  <div class="buttonContainer">',
'#EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'  </div>',
'</div>',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body (Divider)'
,p_internal_name=>'APEX_4.2_WIZARD_BODY_DIVIDER'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209811475242480.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(97184986249431616.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box'
,p_internal_name=>'APEX_4.0_WIZARD_BOX'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/finder_help
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(113038566483763896.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Finder Help'
,p_internal_name=>'FINDER_HELP'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/page_edit_standard_content
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(114707373931146077.4605)
,p_layout=>'TABLE'
,p_template=>'<section class="aRegion smallHeading noPadding componentRegion #REGION_CSS_CLASSES#" id="#REGION_ID#" #REGION_ATTRIBUTES#>#BODY#</section>'
,p_page_plug_template_name=>'Page Edit - Standard Content'
,p_internal_name=>'PAGE_EDIT_STANDARD_CONTENT'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_page_edit_component_top_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(114716561310184878.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="componentViewHeader aRegion #REGION_CSS_CLASSES#" id="#REGION_ID#" #REGION_ATTRIBUTES#>',
'  <h1>#TITLE#</h1>',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Page Edit Component Top Bar'
,p_internal_name=>'APEX_4.2_PAGE_EDIT_COMPONENT_TOP_BAR'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box_confirm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(153782564453027959.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box (Confirm)'
,p_internal_name=>'WIZARD_BOX_CONFIRM'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box_success
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(154386270691497579.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion successRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box (Success)'
,p_internal_name=>'WIZARD_BOX_SUCCESS'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>149030901078827666.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box_fail
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(168458481592608868.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion failRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box (Fail)'
,p_internal_name=>'WIZARD_BOX_FAIL'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>160023608986860686.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box_warning
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(168458987621608889.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion warningRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box (Warning)'
,p_internal_name=>'WIZARD_BOX_WARNING'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>162320107014603380.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_accordion
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(179988483546212227.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion resize #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #SUB_REGIONS#',
'</div>',
''))
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion-item">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Accordion'
,p_internal_name=>'APEX_5.0_ACCORDION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174746301430371105.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(179988979456212289.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn resize #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-PageColumn-header">',
'    <h2 class="a-PageColumn-heading">#TITLE#</h2>',
'  </div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613223222362440.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(179998378981224010.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn-body resize #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column (Body)'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN_BODY'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174630015632506596.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(179998957300224011.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174748721787471587.4605
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_top_buttons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(179999680126224011.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--left">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--right">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region (Top Buttons)'
,p_internal_name=>'APEX_5.0_REGION_TOP_BUTTONS'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174747104640428780.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(180000359887224011.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Toolbar-items a-Toolbar-items--left">#PREVIOUS#</div>',
'  <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar'
,p_internal_name=>'APEX_5.0_TOOLBAR'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613705533399534.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_nested_splitter
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(182578463737748137.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="resize #REGION_CSS_CLASSES#"> ',
'#BODY#',
'<div id="#REGION_STATIC_ID#_content" class="resize">',
'#SUB_REGIONS#',
'</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Nested Splitter'
,p_internal_name=>'APEX_5.0_NESTED_SPLITTER'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(188424184018478913.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Tabs-toolbar a-Toolbar">',
'    #SUB_REGION_HEADERS#',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  #SUB_REGIONS#',
'</div>',
''))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#">#SUB_REGION_TITLE#</a></li>'
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUB_REGION#',
''))
,p_page_plug_template_name=>'APEX 5.0 - Tabs'
,p_internal_name=>'APEX_5.0_TABS'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>183211208341566300.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(201817560415259244.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar (Gray Header)'
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>101
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_page_edit_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(207361560772148010.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion pageEditBar #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'	<div class="gotoPage">',
'	#BODY##EXPAND#',
'	</div>',
'	<span class="lButtonContainer">',
'		#EDIT##CLOSE##CREATE##CREATE2##HELP##DELETE##COPY##PREVIOUS#',
'	</span>',
'	<div class="pageEditRight">',
'        <div class="rButtonContainer">',
'        #NEXT#',
'        </div>',
'		#SUB_REGIONS#',
'	</div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Page Edit Bar '
,p_internal_name=>'APEX_4.2_PAGE_EDIT_BAR_'
,p_theme_id=>101
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>202152130536978817.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box_confirm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(207487462312907810.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box (Confirm)'
,p_internal_name=>'APEX_4.0_WIZARD_BOX_CONFIRM'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(214132567690623104.4605)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(756540274656092333.4605)
,p_plug_template_id=>wwv_flow_api.id(214132567690623104.4605)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column_no_heading
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(231276082996869606.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn resize #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column (No Heading)'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN_NO_HEADING'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613223222362440.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar_for_list_buttons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(259285788981232056.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="topbar" style="width:100%;clear:both;" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="topbar-top"><div class="topbar-top-r"></div></div>',
'  <div class="topbar-body"><div class="topbar-body-r"><div class="topbar-content">',
'     #BODY#',
'   </div></div></div>',
'  <div class="topbar-bottom"><div class="topbar-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar (for list buttons)'
,p_internal_name=>'APEX_4.0_TOP_BAR_FOR_LIST_BUTTONS'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>254074518265073133.4605
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(405054454026874128.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(651492083233530570.4605)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(660773436427335038.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>101
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>698829239393878937.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(694479338908463138.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>687153470345619376.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(695174842442319385.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'      <button class="a-Button a-Button--icon a-Button--hideShow" type="button"></button>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>689955986849128825.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_title_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(708692623972319459.4605)
,p_layout=>'TABLE'
,p_template=>'<div class="#REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#><h1 class="a-Wizard-title">#TITLE#</h1></div>'
,p_page_plug_template_name=>'APEX 5.0 - Wizard Title Region'
,p_internal_name=>'APEX_5.0_WIZARD_TITLE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>703469000349150769.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(775445099592054705.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>101
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>746362351042209764.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_1_tabs_with_icons_text
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1099875267597409334.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Tabs-toolbar a-Toolbar">',
'    #SUB_REGION_HEADERS#',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  #SUB_REGIONS#',
'</div>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#"><span title="#SUB_REGION_TITLE#" class="a-Icon #SUB_REGION_ICON_CSS_CLASSES#"></span><span class="a-Tabs-label">#SUB_REGION_TITLE#</span></a></li>'
,p_sub_plug_template=>'#SUB_REGION#'
,p_page_plug_template_name=>'APEX 5.1 - Tabs with Icons + Text'
,p_internal_name=>'APEX_5.1_TABS_WITH_ICONS_+_TEXT'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>1094662472079256126.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_processing_spinner_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1152499662607227329.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ProcessingRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <span class="u-Processing"><span class="u-Processing-spinner"></span></span>',
'  <div class="a-ProcessingRegion-title">#TITLE#</div>',
'  <div class="a-ProcessingRegion-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Processing Spinner Region'
,p_internal_name=>'APEX_5.0_PROCESSING_SPINNER_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>1147280303078953726.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_grouping_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#" role="group" aria-labelledby="#REGION_STATIC_ID#_label">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title" id="#REGION_STATIC_ID#_label">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Grouping Region'
,p_internal_name=>'APEX_5.0_GROUPING_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--paddedBody:a-Region--simple'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>1157694368668532777.4605
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_tree_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1498725972854847460.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" class="a-PageDesigner-treeRegion resize #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>',
'  <div class="a-Toolbar a-Toolbar-pageColumn a-Toolbar--treeRegion">',
'    <div class="a-Toolbar-items a-Toolbar-items--left">',
'      <h3 id="#REGION_STATIC_ID#_title" class="a-PageDesigner-treeTitle">#TITLE#</h3>',
'    </div>',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  <div class="a-PageDesigner-treeWrap u-ScrollingViewport resize">',
'    #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Tree Region'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_TREE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>1493511686675667790.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs_with_icons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2051465203902440174.4605)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Tabs-toolbar a-Toolbar">',
'    #SUB_REGION_HEADERS#',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  #SUB_REGIONS#',
'</div>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#"><span title="#SUB_REGION_TITLE#" class="a-Icon #SUB_REGION_ICON_CSS_CLASSES#"></span><span class="u-VisuallyHidden">#SUB_REGION_TITLE#</span></a></li>'
,p_sub_plug_template=>'#SUB_REGION#'
,p_page_plug_template_name=>'APEX 5.0 - Tabs with Icons'
,p_internal_name=>'APEX_5.0_TABS_WITH_ICONS'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2046249791523279568.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(5208269691267696.4605)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>101
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_second_level_tabs_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(11515926722097128.4605)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX Second Level Tabs Navigation'
,p_internal_name=>'APEX_SECOND_LEVEL_TABS_NAVIGATION'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>' <div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>' '
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_c_htmldbul_from_4999
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(40271258725782407.4605)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'Unordered List (c:htmldbUl) From 4999'
,p_internal_name=>'UNORDERED_LIST_C:HTMLDBUL_FROM_4999'
,p_theme_id=>101
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(45984563067371352.4605)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress Bar'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS_BAR'
,p_theme_id=>101
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/list/horizontal_list_with_images_fixed_width_30pxc_htmldblistimageshfw
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(79963472647518994.4605)
,p_list_template_current=>'<td align="center" valign="top"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon" /></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_noncurrent=>'<td align="center" valign="top"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon"/></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_name=>'Horizontal List with Images Fixed Width 30px(c:htmldbListImagesHFW)'
,p_internal_name=>'HORIZONTAL_LIST_WITH_IMAGES_FIXED_WIDTH_30PXC:HTMLDBLISTIMAGESHFW'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="htmldbListImages30px" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_reference_id=>338219701416750315.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_image_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(120406665657180147.4605)
,p_list_template_current=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_name=>'Simple Image List'
,p_internal_name=>'SIMPLE_IMAGE_LIST'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="listwithicon">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>32421627622986728.4605
,p_list_template_comment=>'<img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_without_links
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(143051788198654131.4605)
,p_list_template_current=>'<li><span class="fielddata">#TEXT#</span></li>'
,p_list_template_noncurrent=>'<li><span class="fielddata">#TEXT#</a></li>'
,p_list_template_name=>'unordered list without links'
,p_internal_name=>'UNORDERED_LIST_WITHOUT_LINKS'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="htmldbUl">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sub_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(173916782273383700.4605)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Sub Tabs'
,p_internal_name=>'APEX_5.0_SUB_TABS'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4605
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_run_edit_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(215597759297909051.4605)
,p_list_template_current=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_noncurrent=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_name=>'APEX 4.2 - Run / Edit Bar'
,p_internal_name=>'APEX_4.2_RUN_/_EDIT_BAR'
,p_theme_id=>101
,p_theme_class_id=>3
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="aRunEditBar">',
'  <li><span class="currentPage">&PAGE. &FB_FLOW_PAGE_ID.</span></li>'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>210390516819756900.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_pull_down_button_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(259079678731769191.4605)
,p_list_template_current=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton #A01#" type="button"><span>#TEXT#</span></button> '
,p_list_template_noncurrent=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton #A01#" type="button"><span>#TEXT#</span></button> '
,p_list_template_name=>'APEX 4.0 - Pull Down Button List'
,p_internal_name=>'APEX_4.0_PULL_DOWN_BUTTON_LIST'
,p_theme_id=>101
,p_theme_class_id=>9
,p_list_template_before_rows=>'<div class="rButtonContainer dhtmlMenuLGButton">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton #A01#" type="button"><span>#TEXT#</span></button> '
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" class="dhtmlMenu" type="button"><span>#TEXT#<img src="#IMAGE_PREFIX#f_spacer.gif" alt="" /></span></button> ',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
,p_reference_id=>253872418832604079.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(389919542813170530.4605)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>101
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(486498848592697101.4605)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508.4605
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_no_links
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(497344687322855129.4605)
,p_list_template_current=>'<li>#TEXT#</li>'
,p_list_template_noncurrent=>'<li>#TEXT#</li>'
,p_list_template_name=>'Unordered List (no links)'
,p_internal_name=>'UNORDERED_LIST_NO_LINKS'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="htmldbUl">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(698626888016487602.4605)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>101
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(702419290542782266.4605)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>101
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_basic_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1147196030581261316.4605)
,p_list_template_current=>'<li class="a-List-item is-current"><a href="#LINK#" class="a-Links-link" #A02#>#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-List-item"><a href="#LINK#" class="a-Links-link" #A02#>#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Basic List'
,p_internal_name=>'APEX_5.0_BASIC_LIST'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="a-List #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>1141986383000090627.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_basic_list_no_links
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1147196572106261322.4605)
,p_list_template_current=>'<li class="a-List-item is-current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li class="a-List-item">#TEXT#</li>'
,p_list_template_name=>'APEX 5.0 - Basic List (no links)'
,p_internal_name=>'APEX_5.0_BASIC_LIST_NO_LINKS'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="a-List a-List--basic #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>1141988805895106920.4605
);
end;
/
prompt --application/shared_components/user_interface/templates/report/timeline
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(5473608411738262.4605)
,p_row_template_name=>'Issue Timeline'
,p_internal_name=>'TIMELINE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<article class="a-TimelineEntry #ENTRY_MODIFIER_CLASSES#">',
'  <div class="a-TimelineEntry-wrap">',
'    <div class="a-TimelineEntry-header">',
'      <div class="a-TimelineEntry-headerItems a-TimelineEntry-headerItems--type">',
'        <span class="a-TimelineEntry-typeIcon #ENTRY_TYPE_ICON_MODIFIER#"><span class="#ENTRY_TYPE_ICON_CLASS#" aria-hidden="true"></span></span>',
'      </div>',
'      <div class="a-TimelineEntry-headerItems a-TimelineEntry-headerItems--info">',
'        <div class="a-TimelineEntry-infoAuthor">#ENTRY_AUTHOR#</div>',
'        <div class="a-TimelineEntry-infoStatus">#ENTRY_STATUS_TYPE#</div>',
'      </div>',
'      <div class="a-TimelineEntry-headerItems a-TimelineEntry-headerItems--actions">#ENTRY_ACTIONS#</div>',
'    </div>',
'    <div class="a-TimelineEntry-body">',
'        <div data-markdown="true" class="a-TimelineEntry-bodyContent" id="#ID#">#ENTRY_BODY#</div>',
'        <div class="a-TimelineEntry-more" id="MORE_#ID#">#MORE_DATA#</div>',
'    </div>',
'  </div>',
'</article>',
''))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TimelineReport">',
'  <div class="a-Timeline">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'   </div>',
'</div>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_19_2_empty_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(6221345279028573.4605)
,p_row_template_name=>'APEX 19.2 - Empty Report'
,p_internal_name=>'APEX_19.2_EMPTY_REPORT'
,p_row_template1=>'#DISPLAY_VALUE#'
,p_row_template_before_rows=>' '
,p_row_template_after_rows=>' '
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/content_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(6811165341870886.4605)
,p_row_template_name=>'Content Row'
,p_internal_name=>'CONTENT_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item #ITEM_CSS_MODIFIERS#" #ITEM_CUSTOM_ATTRS#>',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemSelection">#ITEM_SELECTION#</div>',
'    <div class="a-ContentRowReport-itemIconWrap">',
'      <span class="a-ContentRowReport-itemIcon #ITEM_ICON#" aria-hidden="true"></span>',
'    </div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle"><a href="#ITEM_LINK#">#ITEM_TITLE#</a></h3>',
'        <div class="a-ContentRowReport-itemDescription">#ITEM_DESCRIPTION#</div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">#ITEM_MISC#</div>',
'      <div class="a-ContentRowReport-itemActions">#ITEM_ACTIONS#</div>',
'    </div>',
'  </div>',
'</div>',
''))
,p_row_template_condition1=>':ITEM_LINK is not null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item #ITEM_CSS_MODIFIERS#" #ITEM_CUSTOM_ATTRS#>',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemSelection">#ITEM_SELECTION#</div>',
'    <div class="a-ContentRowReport-itemIconWrap">',
'      <span class="a-ContentRowReport-itemIcon #ITEM_ICON#" aria-hidden="true"></span>',
'    </div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle">#ITEM_TITLE#</h3>',
'        <div class="a-ContentRowReport-itemDescription">#ITEM_DESCRIPTION#</div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">#ITEM_MISC#</div>',
'      <div class="a-ContentRowReport-itemActions">#ITEM_ACTIONS#</div>',
'    </div>',
'  </div>',
'</div>',
''))
,p_row_template_condition2=>':ITEM_LINK is null'
,p_row_template_before_rows=>'<div class="a-ContentRowReport #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</div>',
'#PAGINATION#'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/content_row_link
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(10733983191535295.4605)
,p_row_template_name=>'Content Row Link'
,p_internal_name=>'CONTENT_ROW_LINK'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item #ITEM_CSS_MODIFIERS#" #ITEM_CUSTOM_ATTRS#>',
'  <a class="a-ContentRowReport-itemWrap" href="#ITEM_LINK#">',
'    <div class="a-ContentRowReport-itemIconWrap">',
'      <span class="a-ContentRowReport-itemIcon #ITEM_ICON#" aria-hidden="true"></span>',
'    </div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle">#ITEM_TITLE#</h3>',
'        <div class="a-ContentRowReport-itemDescription">#ITEM_DESCRIPTION#</div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">#ITEM_MISC#</div>',
'      <div class="a-ContentRowReport-itemActions">#ITEM_ACTIONS#</div>',
'    </div>',
'  </a>',
'</div>',
''))
,p_row_template_condition1=>':ITEM_LINK is not null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item #ITEM_CSS_MODIFIERS#" #ITEM_CUSTOM_ATTRS#>',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemIconWrap">',
'      <span class="a-ContentRowReport-itemIcon #ITEM_ICON#" aria-hidden="true"></span>',
'    </div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle">#ITEM_TITLE#</h3>',
'        <div class="a-ContentRowReport-itemDescription">#ITEM_DESCRIPTION#</div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">#ITEM_MISC#</div>',
'      <div class="a-ContentRowReport-itemActions">#ITEM_ACTIONS#</div>',
'    </div>',
'  </div>',
'</div>',
''))
,p_row_template_condition2=>':ITEM_LINK is null'
,p_row_template_before_rows=>'<div class="a-ContentRowReport #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</div>',
'#PAGINATION#'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(16872467321495251.4605)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4605
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(16872467321495251.4605)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/result
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(38839184397267347.4605)
,p_row_template_name=>'Result'
,p_internal_name=>'RESULT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr><td align="left" class="header" style="width:70px;">#COLUMN_HEADER#</th><td#ALIGNMENT#>#COLUMN_VALUE#</td></tr>',
''))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'table.htmldbStandard3 td.header { vertical-align:middle; }',
'table.htmldbStandard3 td.pagination { border: medium none; }',
'</style>',
'<table width="100%" cellpadding="0" cellspacing="0" class="htmldbStandard3" role="presentation" datatable=0 summary="">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>',
''))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>101
,p_theme_class_id=>6
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(38839184397267347.4605)
,p_row_template_after_last=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>',
'<p/>',
'<table width="100%" cellpadding="0" cellspacing="0" class="htmldbStandard3" role="presentation" datatable=0 summary="">',
'<tbody>'))
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_2_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(52346073432218689.4605)
,p_row_template_name=>'APEX 4.2 - Portlet Row Template'
,p_internal_name=>'APEX_4.2_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_2_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(53143976115374711.4605)
,p_row_template_name=>'APEX 4.2 - Portlet Column Template'
,p_internal_name=>'APEX_4.2_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/vertical_standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(87320675886385724.4605)
,p_row_template_name=>'Vertical Standard'
,p_internal_name=>'VERTICAL_STANDARD'
,p_row_template1=>'<tr><td scope="row" class="label">#COLUMN_HEADER#</td><td class="data">#COLUMN_VALUE#</td></tr>'
,p_row_template_before_rows=>'#CSV_LINK#<table class="htmldbVerticalRegion2"  summary="#REGION_TITLE#" cellpadding="0" cellspacing="0" border="0">'
,p_row_template_after_rows=>'</table>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>101
,p_theme_class_id=>0
,p_reference_id=>81978430803840109.4605
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(87320675886385724.4605)
,p_row_template_before_first=>' '
,p_row_template_after_last=>'<tr><td class="blank"><br /></td><td class="blank"><br /></td></tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_vertical_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(87612589317776005.4605)
,p_row_template_name=>'APEX 5.0 - Vertical Report'
,p_internal_name=>'APEX_5.0_VERTICAL_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr>',
'  <td class="a-Report-cell a-Report-cell--header" scope="row">#COLUMN_HEADER#</td>',
'  <td class="a-Report-cell">#COLUMN_VALUE#</td>',
'</tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report a-Report--vertical a-Report--staticRowColors #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>1126924627125205941.4605
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(87612589317776005.4605)
,p_row_template_before_first=>' '
,p_row_template_after_last=>' '
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/standard_mru_ajax_sortable
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(118284487222034553.4605)
,p_row_template_name=>'Standard (MRU AJAX SORTABLE)'
,p_internal_name=>'STANDARD_MRU_AJAX_SORTABLE'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="report_#REGION_ID#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<script type="text/javascript">',
'var g_rpreview_global = ''report_#REGION_ID#'';',
'var g_#REGION_ID#;',
'function f_#REGION_ID#(){',
'		g_#REGION_ID# =  new apex.tabular.sort(''report_#REGION_ID#'');',
'		g_#REGION_ID#.row.after_move = function(){rpreview()}',
'}',
'addLoadEvent(f_#REGION_ID#)',
'</script>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>113076128479881902.4605
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(118284487222034553.4605)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(128932681614424007.4605)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4605
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(128932681614424007.4605)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/no_background
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(254449264728006664.4605)
,p_row_template_name=>'No Background'
,p_internal_name=>'NO_BACKGROUND'
,p_row_template1=>'<td#ALIGNMENT# id="td#ROWNUM#_#COLNUM#" headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" class="htmldbRptNoBackground" summary="#REGION_TITLE#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>237868603542157245.4605
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(254449264728006664.4605)
,p_row_template_before_first=>'<tr id="row#ROWNUM#">'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/p890_ad_matching_items
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(259328758800535285.4605)
,p_row_template_name=>'P890_AD_MATCHING_ITEMS'
,p_internal_name=>'P890_AD_MATCHING_ITEMS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr><td>#CHK#</td><td>#REGION_NAME#</td><td>#I_NAME#</td><td>#I_LABEL#</td><td>#I_HELP_TEXT#</td><td>#I_FORMAT_MASK#</td><td>#I_FORMAT_MASK2#</td><td>#I_DEFAULT#</td><td>#I_WIDTH#</td><td>#I_HEIGHT#</td><td>#I_DATA_TYPE#</td></tr>',
'<tr><td>&nbsp;</td><td>#FROM_AD#</td><td>#C_COLUMN_NAME#</td><td>#C_LABEL#</td><td>#C_HELP_TEXT#</td><td>#C_FORMAT_MASK#</td><td>#C_FORM_FORMAT_MASK#</td><td>#C_DEFAULT_VALUE#</td><td>#C_FORM_DISPLAY_WIDTH#</td><td>#C_FORM_DISPLAY_HEIGHT#</td><td>#C_'
||'FORM_DATA_TYPE#</td></tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/p897_ad_matching_rc
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(262221362311141944.4605)
,p_row_template_name=>'P897_AD_MATCHING_RC'
,p_internal_name=>'P897_AD_MATCHING_RC'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr><td>#CHK#</td><td>#REGION_NAME#</td><td>#RC_NAME#</td><td>#RC_LABEL#</td><td>#RC_HELP_TEXT#</td><td>#RC_FORMAT_MASK#</td><td>#RC_FORMAT_MASK2#</td><td>#RC_REPORT_COL_ALIGN#</td></tr>',
'<tr><td>&nbsp;</td><td>#FROM_AD#</td><td>&nbsp;</td><td>#C_LABEL#</td><td>#C_HELP_TEXT#</td><td>#C_FORMAT_MASK#</td><td>#C_REPORT_FORMAT_MASK#</td><td>#C_REPORT_COL_ALIGN#</td></tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/p921_ad_matching_items
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(451299075390647561.4605)
,p_row_template_name=>'P921_AD_MATCHING_ITEMS'
,p_internal_name=>'P921_AD_MATCHING_ITEMS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr><td>#CHK#</td><td>#REGION_NAME#</td><td>#I_NAME#</td><td>#I_LABEL#</td><td>#I_HELP_TEXT#</td><td>#I_FORMAT_MASK#</td><td>#I_DEFAULT#</td><td>#I_WIDTH#</td><td>#I_HEIGHT#</td><td>#I_DATA_TYPE#</td></tr>',
'<tr><td>&nbsp;</td><td>#FROM_AD#</td><td>#C_COLUMN_NAME#</td><td>#C_LABEL#</td><td>#C_HELP_TEXT#</td><td>#C_FORMAT_MASK#</td><td>#C_DEFAULT_VALUE#</td><td>#C_FORM_DISPLAY_WIDTH#</td><td>#C_FORM_DISPLAY_HEIGHT#</td><td>#C_FORM_DATA_TYPE#</td></tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/p922_ad_matching_rc
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(451456269530572938.4605)
,p_row_template_name=>'P922_AD_MATCHING_RC'
,p_internal_name=>'P922_AD_MATCHING_RC'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr><td>#CHK#</td><td>#REGION_NAME#</td><td>#RC_NAME#</td><td>#RC_LABEL#</td><td>#RC_HELP_TEXT#</td><td>#RC_FORMAT_MASK#</td><td>#RC_REPORT_COL_ALIGN#</td></tr>',
'<tr><td>&nbsp;</td><td>#FROM_AD#</td><td>&nbsp;</td><td>#C_LABEL#</td><td>#C_HELP_TEXT#</td><td>#C_FORMAT_MASK#</td><td>#C_REPORT_COL_ALIGN#</td></tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_app_cards_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1046844478120553869.4605)
,p_row_template_name=>'APEX 5.0 - App Cards Report'
,p_internal_name=>'APEX_5.0_APP_CARDS_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AppCards-item #ID#">',
'  <div class="a-AppCards-itemContainer">',
'    <div class="a-AppCards-iconContainer">',
'      <span class="a-AppCards-icon #ICON_CLASS#"></span>',
'    </div>',
'    <div class="a-AppCards-contentContainer" id="#ID#_name">',
'      <h2 class="a-AppCards-name">#APP_NAME#</h2>',
'      <div class="a-AppCards-info">#APP_INFO#</div>',
'    </div>',
'    <div class="a-AppCards-actionsContainer">',
'        #MODIFY_APP_BUTTON#',
'        #RUN_APP_BUTTON#',
'    </div>',
'  </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AppCards a-AppCards--slim  a-AppCards--stacked">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>932268343459577530.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_named_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_row_template_name=>'APEX 5.0 - Badge List (Named Column)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_NAMED_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1046849559229553949.4605)
,p_row_template_name=>'APEX 5.0 - Badge List (Row)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
'  <span class="t-BadgeList-label">#1#</span>',
'  <span class="t-BadgeList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>6
,p_reference_id=>689060248369886348.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1046850417023553952.4605)
,p_row_template_name=>'APEX 5.0 - Portlet Column Template'
,p_internal_name=>'APEX_5.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1046851149224553954.4605)
,p_row_template_name=>'APEX 5.0 - Portlet Row Template'
,p_internal_name=>'APEX_5.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(10128482508892221.4605)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>101
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional_no_labelonly_for_radiogroup
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(48271887820999885.4605)
,p_template_name=>'FormField_Optional (no label-only for radiogroup)'
,p_internal_name=>'FORMFIELD_OPTIONAL_NO_LABELONLY_FOR_RADIOGROUP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>101
,p_theme_class_id=>0
,p_reference_id=>43065615312847035.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_4_0_top_bar_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(62936183445003887.4605)
,p_template_name=>'APEX 4.0 - Top Bar Label'
,p_internal_name=>'APEX_4.0_TOP_BAR_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>101
,p_theme_class_id=>0
,p_reference_id=>57728329098847875.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(98577379800732474.4605)
,p_template_name=>'FormField_Optional'
,p_internal_name=>'FORMFIELD_OPTIONAL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>17388415351892041.4605
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/columnheader
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(99502069539557325.4605)
,p_template_name=>'ColumnHeader'
,p_internal_name=>'COLUMNHEADER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>17388415351892041.4605
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(457861279924367968.4605)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_reference_id=>487443659585685414.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(566752393121369432.4605)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_reference_id=>487444299516703815.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(566754195708398878.4605)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_reference_id=>492676964457041934.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(566754273980399706.4605)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_reference_id=>492677038682043223.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(571215478963548485.4605)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_reference_id=>687907221148719616.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_dynamic_attribute
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(571257652710828592.4605)
,p_template_name=>'APEX 5.0 - Dynamic Attribute'
,p_internal_name=>'APEX_5.0_DYNAMIC_ATTRIBUTE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-dynamicItemHelp" data-itemname="#CURRENT_ITEM_NAME#" data-appid="&FB_FLOW_ID." title="" aria-label="" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span>'
||'</button>#ERROR_TEMPLATE#</div>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>692681574974429799.4605
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(5208262300686444.4605)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>9
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>689285808648404711.4605
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(15421877085757803.4605)
,p_page_name=>'winlov'
,p_page_title=>unistr('Caixa de Di\00E1logo Pesquisar')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>'Pesquisar'
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>'Fechar'
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>unistr('Pr\00F3ximo &gt;')
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>'&lt; Anterior'
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>'<div class="a-PopupLOV-pagination">Linha(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>17343114994581872.4605
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/default_calander
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(53950578804123182.4605)
,p_cal_template_name=>'Default Calander'
,p_internal_name=>'DEFAULT_CALANDER'
,p_day_of_week_format=>'<th scope="col" width="14%" class="htmldbDayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbCalendarHolder" cellpadding="0" cellspacing="0" border="0" width="100%" summary="" role="presentation"><tr>',
'<td class="htmldbMonthTitle">#IMONTH# #YYYY#</td>',
'</tr>',
'<tr><td>'))
,p_month_open_format=>'<table class="htmldbCalendar" cellpadding="0" cellspacing="3" border="0" width="100%" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td></tr></table>',
'',
''))
,p_day_title_format=>'<div class="htmldbDayTitle">#DD#</div>'
,p_day_open_format=>'<td class="htmldbDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="htmldbToday">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="htmldbWeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td class="htmldbWeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="htmldbNonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="htmldbNonDay">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>353925314576528967.4605
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(77533347140630629.4605)
,p_theme_id=>101
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(209225663324524664.4605)
,p_theme_id=>101
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(10813894202794535.4605)
,p_theme_id=>101
,p_name=>'DIALOG_SIZE'
,p_display_name=>'Dialog Size'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Predefined dialog sizes'
,p_null_text=>'Default Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(694480036806463139.4605)
,p_theme_id=>101
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(694481016688463140.4605)
,p_theme_id=>101
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(694814532471133994.4605)
,p_theme_id=>101
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(694816751912133995.4605)
,p_theme_id=>101
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695072740319798635.4605)
,p_theme_id=>101
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695072854793798635.4605)
,p_theme_id=>101
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695072938306798635.4605)
,p_theme_id=>101
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695072973969798636.4605)
,p_theme_id=>101
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695073116328798636.4605)
,p_theme_id=>101
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695073211513798636.4605)
,p_theme_id=>101
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695073322476798637.4605)
,p_theme_id=>101
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695073374573798637.4605)
,p_theme_id=>101
,p_name=>'MAX_HEIGHT'
,p_display_name=>'Max Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'No Max Height'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695073477662798637.4605)
,p_theme_id=>101
,p_name=>'MIN_HEIGHT'
,p_display_name=>'Min Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'No Min Height'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695073609547798637.4605)
,p_theme_id=>101
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695073701037798637.4605)
,p_theme_id=>101
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695073825395798637.4605)
,p_theme_id=>101
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695073892169798638.4605)
,p_theme_id=>101
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695073978083798638.4605)
,p_theme_id=>101
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695074115159798638.4605)
,p_theme_id=>101
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(695179142948319388.4605)
,p_theme_id=>101
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698627343191487614.4605)
,p_theme_id=>101
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(701826319113292817.4605)
,p_theme_id=>101
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(702432470636856200.4605)
,p_theme_id=>101
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746203959297757572.4605)
,p_theme_id=>101
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746204290236757573.4605)
,p_theme_id=>101
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746205145910757573.4605)
,p_theme_id=>101
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746205382468757573.4605)
,p_theme_id=>101
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(775445499790054719.4605)
,p_theme_id=>101
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(6856778639622928.4605)
,p_theme_id=>101
,p_name=>'HIDE_ICON_COLUMN'
,p_display_name=>'Hide Icon Column'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(6811165341870886.4605)
,p_css_classes=>'a-ContentRowReport--hideIcons'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(10734369185535315.4605)
,p_theme_id=>101
,p_name=>'HIDE_ICON_COLUMN'
,p_display_name=>'Hide Icon Column'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(10733983191535295.4605)
,p_css_classes=>'a-ContentRowReport--hideIcons'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(10814278502794541.4605)
,p_theme_id=>101
,p_name=>'SMALL_480X320'
,p_display_name=>'Small (480x320)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(10813455696794486.4605)
,p_css_classes=>'js-dialog-size480x320'
,p_group_id=>wwv_flow_api.id(10813894202794535)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(10814615790794547.4605)
,p_theme_id=>101
,p_name=>'MEDIUM_600X400'
,p_display_name=>'Medium (600x400)'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(10813455696794486.4605)
,p_css_classes=>'js-dialog-size600x400'
,p_group_id=>wwv_flow_api.id(10813894202794535)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(10814914136794547.4605)
,p_theme_id=>101
,p_name=>'LARGE_720X480'
,p_display_name=>'Large (720x480)'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_api.id(10813455696794486.4605)
,p_css_classes=>'js-dialog-size720x480'
,p_group_id=>wwv_flow_api.id(10813894202794535)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(10815365068794547.4605)
,p_theme_id=>101
,p_name=>'DRAGGABLE'
,p_display_name=>'Draggable'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(10813455696794486.4605)
,p_css_classes=>'js-draggable'
,p_template_types=>'REGION'
,p_help_text=>'Allow dialog to be moved.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(10815769268794548.4605)
,p_theme_id=>101
,p_name=>'MODAL'
,p_display_name=>'Modal'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_api.id(10813455696794486.4605)
,p_css_classes=>'js-modal'
,p_template_types=>'REGION'
,p_help_text=>'Display as modal.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(10816139144794548.4605)
,p_theme_id=>101
,p_name=>'RESIZABLE'
,p_display_name=>'Resizable'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(10813455696794486.4605)
,p_css_classes=>'js-resizable'
,p_template_types=>'REGION'
,p_help_text=>'Allow dialog to be resized.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(702412839760774923.4605)
,p_theme_id=>101
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626888016487602.4605)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(698627343191487614)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(702413156612774923.4605)
,p_theme_id=>101
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626888016487602.4605)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(698627343191487614)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(702413398335774923.4605)
,p_theme_id=>101
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626888016487602.4605)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(698627343191487614)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(702413726246774923.4605)
,p_theme_id=>101
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626888016487602.4605)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(698627343191487614)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(702414008912774923.4605)
,p_theme_id=>101
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626888016487602.4605)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(698627343191487614)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(702414308619774923.4605)
,p_theme_id=>101
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626888016487602.4605)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(702414635053774923.4605)
,p_theme_id=>101
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626888016487602.4605)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(702414893173774924.4605)
,p_theme_id=>101
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626888016487602.4605)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(702415177789774924.4605)
,p_theme_id=>101
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626888016487602.4605)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(702415501189774924.4605)
,p_theme_id=>101
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626888016487602.4605)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746294211505150949.4605)
,p_theme_id=>101
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_api.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746294431394150949.4605)
,p_theme_id=>101
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_api.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746294653320150949.4605)
,p_theme_id=>101
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_api.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746294821672150950.4605)
,p_theme_id=>101
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_api.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746295005920150950.4605)
,p_theme_id=>101
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_api.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746295251397150950.4605)
,p_theme_id=>101
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_api.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746295422626150951.4605)
,p_theme_id=>101
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(746203959297757572)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746295558353150952.4605)
,p_theme_id=>101
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_api.id(746204290236757573)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746295785471150952.4605)
,p_theme_id=>101
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_api.id(695072740319798635)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746296007578150952.4605)
,p_theme_id=>101
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_api.id(746204290236757573)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746296166286150952.4605)
,p_theme_id=>101
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_api.id(746204290236757573)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746296386377150952.4605)
,p_theme_id=>101
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_api.id(746204290236757573)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746296616105150952.4605)
,p_theme_id=>101
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_api.id(695072740319798635)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746296801146150952.4605)
,p_theme_id=>101
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_api.id(746205145910757573)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746297038245150952.4605)
,p_theme_id=>101
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(746205382468757573)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746297193678150952.4605)
,p_theme_id=>101
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_api.id(695072854793798635)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746297433497150952.4605)
,p_theme_id=>101
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(695073116328798636)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746297631516150952.4605)
,p_theme_id=>101
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_api.id(695073211513798636)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746297847783150953.4605)
,p_theme_id=>101
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(695072740319798635)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746298002917150953.4605)
,p_theme_id=>101
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(695072973969798636)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746298200231150953.4605)
,p_theme_id=>101
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_api.id(695072938306798635)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746298317010150953.4605)
,p_theme_id=>101
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746298487581150953.4605)
,p_theme_id=>101
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_api.id(695072854793798635)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746298691596150953.4605)
,p_theme_id=>101
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_api.id(695073116328798636)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746298922805150953.4605)
,p_theme_id=>101
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_api.id(695073211513798636)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746298962077150953.4605)
,p_theme_id=>101
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746299057511150953.4605)
,p_theme_id=>101
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746310971087489751.4605)
,p_theme_id=>101
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(694479338908463138.4605)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746311250336489752.4605)
,p_theme_id=>101
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(694479338908463138.4605)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746311396306489758.4605)
,p_theme_id=>101
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(694479338908463138.4605)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746311583261489758.4605)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(694479338908463138.4605)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746311760604489760.4605)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(694479338908463138.4605)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746311863031489760.4605)
,p_theme_id=>101
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(694479338908463138.4605)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746312117555489760.4605)
,p_theme_id=>101
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(694479338908463138.4605)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_api.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746312272166489760.4605)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(694479338908463138.4605)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_api.id(701826319113292817)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(775446710125054764.4605)
,p_theme_id=>101
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(775445099592054705.4605)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(775446774761054764.4605)
,p_theme_id=>101
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(775445099592054705.4605)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(775447012729054764.4605)
,p_theme_id=>101
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(775445099592054705.4605)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_api.id(775445499790054719)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(775447185351054764.4605)
,p_theme_id=>101
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(775445099592054705.4605)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_api.id(775445499790054719)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(775447394419054764.4605)
,p_theme_id=>101
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(775445099592054705.4605)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_api.id(775445499790054719)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(775447592646054764.4605)
,p_theme_id=>101
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(775445099592054705.4605)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(695179142948319388)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(775447835567054764.4605)
,p_theme_id=>101
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(775445099592054705.4605)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_api.id(695179142948319388)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(775447873557054764.4605)
,p_theme_id=>101
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(775445099592054705.4605)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(775448137203054765.4605)
,p_theme_id=>101
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(775445099592054705.4605)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_api.id(775445499790054719)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(792318870187097065.4605)
,p_theme_id=>101
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(128932681614424007.4605)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(695073609547798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(792319116358097065.4605)
,p_theme_id=>101
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(128932681614424007.4605)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(695074115159798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(792319356976097066.4605)
,p_theme_id=>101
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(128932681614424007.4605)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(792319466176097066.4605)
,p_theme_id=>101
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(128932681614424007.4605)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(792319678160097066.4605)
,p_theme_id=>101
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(128932681614424007.4605)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(792319808446097066.4605)
,p_theme_id=>101
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(128932681614424007.4605)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(792320002434097066.4605)
,p_theme_id=>101
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(128932681614424007.4605)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(695073978083798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(933730712592032542.4605)
,p_theme_id=>101
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(5208269691267696.4605)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(933730787698032542.4605)
,p_theme_id=>101
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(5208269691267696.4605)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(945899703441488925.4605)
,p_theme_id=>101
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(45984563067371352.4605)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046847155863553947.4605)
,p_theme_id=>101
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_api.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046847339966553947.4605)
,p_theme_id=>101
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046847476349553947.4605)
,p_theme_id=>101
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046847679905553947.4605)
,p_theme_id=>101
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_api.id(695073825395798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046847873800553947.4605)
,p_theme_id=>101
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(695073825395798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046848091097553947.4605)
,p_theme_id=>101
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_api.id(695073825395798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046848312274553947.4605)
,p_theme_id=>101
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(695073825395798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046848550784553948.4605)
,p_theme_id=>101
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(695073825395798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046848682352553948.4605)
,p_theme_id=>101
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046848892380553948.4605)
,p_theme_id=>101
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046849088026553949.4605)
,p_theme_id=>101
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046849355242553949.4605)
,p_theme_id=>101
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1046849544358553949.4605)
,p_theme_id=>101
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1046845011939553934.4605)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1136971639671341337.4605)
,p_theme_id=>101
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(87612589317776005.4605)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(695074115159798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1136971791228341338.4605)
,p_theme_id=>101
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(87612589317776005.4605)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1136971924032341338.4605)
,p_theme_id=>101
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(87612589317776005.4605)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1136972062275341338.4605)
,p_theme_id=>101
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(87612589317776005.4605)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1136972283158341338.4605)
,p_theme_id=>101
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(87612589317776005.4605)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(695073978083798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1136972490407341338.4605)
,p_theme_id=>101
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(87612589317776005.4605)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162908214577693718.4605)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162908408137693718.4605)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162908602718693718.4605)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162908853288693723.4605)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162909033397693723.4605)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162909254304693723.4605)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162909348932693723.4605)
,p_theme_id=>101
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162909500752693723.4605)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162909706012693723.4605)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(694814532471133994)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162909858582693724.4605)
,p_theme_id=>101
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(694480036806463139)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1162910126957693724.4605)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1162906397341693705.4605)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1204766553506179789.4605)
,p_theme_id=>101
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(656569185201725731.4605)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(695072973969798636)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1246871186591544316.4605)
,p_theme_id=>101
,p_name=>'USED_IN_DIALOG'
,p_display_name=>'Used in Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1152499662607227329.4605)
,p_css_classes=>'a-ProcessingRegion--dialog'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530854820258329406.4605)
,p_theme_id=>101
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(40271258725782407.4605)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530854866395329406.4605)
,p_theme_id=>101
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(40271258725782407.4605)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530855046641329406.4605)
,p_theme_id=>101
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(40271258725782407.4605)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530855150576329406.4605)
,p_theme_id=>101
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(40271258725782407.4605)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530855284457329410.4605)
,p_theme_id=>101
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(40271258725782407.4605)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(702432470636856200)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530855479454329410.4605)
,p_theme_id=>101
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(40271258725782407.4605)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(702432470636856200)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530871148108329490.4605)
,p_theme_id=>101
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(702419290542782266.4605)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530871158921329490.4605)
,p_theme_id=>101
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(702419290542782266.4605)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530871316106329490.4605)
,p_theme_id=>101
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(702419290542782266.4605)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530871427150329490.4605)
,p_theme_id=>101
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(702419290542782266.4605)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530871567576329491.4605)
,p_theme_id=>101
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(702419290542782266.4605)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(702432470636856200)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1530871761769329491.4605)
,p_theme_id=>101
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(702419290542782266.4605)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(702432470636856200)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1550019249633625338.4605)
,p_theme_id=>101
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(16872467321495251.4605)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1550019294378625339.4605)
,p_theme_id=>101
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(16872467321495251.4605)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1550019445696625339.4605)
,p_theme_id=>101
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(16872467321495251.4605)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560014988358555730.4605)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560015216681555730.4605)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560015454132555730.4605)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560015617913555730.4605)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560015854389555731.4605)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(694814532471133994)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560015978344555731.4605)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560016190470555731.4605)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560016364623555731.4605)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560016612303555731.4605)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560016698724555731.4605)
,p_theme_id=>101
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560016860365555731.4605)
,p_theme_id=>101
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(179998957300224011.4605)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(694480036806463139)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560038171248674177.4605)
,p_theme_id=>101
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(651492083233530570.4605)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560038304997674177.4605)
,p_theme_id=>101
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(651492083233530570.4605)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560038401929674177.4605)
,p_theme_id=>101
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(651492083233530570.4605)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560047458334689625.4605)
,p_theme_id=>101
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695174842442319385.4605)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560047633130689625.4605)
,p_theme_id=>101
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695174842442319385.4605)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560047782133689626.4605)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695174842442319385.4605)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560047993254689626.4605)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695174842442319385.4605)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560048177638689626.4605)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695174842442319385.4605)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(694814532471133994)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560048433418689626.4605)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695174842442319385.4605)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560048557981689626.4605)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695174842442319385.4605)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560048826398689626.4605)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695174842442319385.4605)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560049005427689626.4605)
,p_theme_id=>101
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_api.id(695174842442319385.4605)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(695179142948319388)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560049178209689626.4605)
,p_theme_id=>101
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695174842442319385.4605)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(695179142948319388)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560075282931698185.4605)
,p_theme_id=>101
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(660773436427335038.4605)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560075551079698185.4605)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(660773436427335038.4605)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560075683207698185.4605)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(660773436427335038.4605)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560075863456698186.4605)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(660773436427335038.4605)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560076096057698186.4605)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(660773436427335038.4605)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560076276641698186.4605)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(660773436427335038.4605)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560076470349698186.4605)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(660773436427335038.4605)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560076749242698186.4605)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(660773436427335038.4605)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560076920534698186.4605)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(660773436427335038.4605)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(694814532471133994)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1560077106633698186.4605)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(660773436427335038.4605)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2050872719238936523.4605)
,p_theme_id=>101
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(2050872492464936456.4605)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(695072973969798636)
,p_template_types=>'BUTTON'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(37871219870687828.4605)
,p_build_option_name=>'Enable Approval Status'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(319172522601854021.4605)
,p_build_option_name=>'file attachments'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(698205300939964492.4605)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(20611320407398152.4605)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('Tem certeza de que deseja sair desta p\00E1gina sem salvar?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(168592128240568136.4605)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('Gostaria de executar esta a\00E7\00E3o de exclus\00E3o?')
);
end;
/
prompt --application/shared_components/email/templates/issues_summary
begin
wwv_flow_api.create_email_template(
 p_id=>wwv_flow_api.id(15671658472460013.4605)
,p_name=>'Issues Summary'
,p_static_id=>'ISSUES_SUMMARY'
,p_subject=>unistr('Voc\00EA tem #NOTIFICATION_COUNT# novas notifica\00E7\00F5es')
,p_html_body=>wwv_flow_string.join(wwv_flow_t_varchar2(
'              <!-- SubHeader -->',
'              <table width="100%" style="color: #3e3e3e; background-color: #fcfcfc; border-bottom: 1px solid #f0f0f0;">',
'                <tr>',
'                  <td class="hero-reduced" style="text-align: center; padding: 32px; font-size: 14px;">',
unistr('                    <span style="font-size: 20px; font-weight: 500;"> #NOTIFICATION_COUNT# novas notifica\00E7\00F5es com rela\00E7\00E3o aos seguintes Problemas:</span>'),
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // SubHeader -->',
'',
'              <!-- Main Body --> ',
'              <table width="100%" style="background-color: #ffffff;">',
'                <tr>',
'                  <td class="main main-reduced" style="text-align: left; padding: 32px; font-size: 14px; line-height: 20px;">',
'',
'                    #ISSUES_CHANGED!RAW#<br>',
'                    <br>',
'                    <!-- Button -->',
'                    <table align="center">',
'                      <tr>',
'                        <td style="background-color: #056abf; color: #ffffff; padding: 12px 32px; border-radius: 2px; min-width: 160px;" align="center">',
'                          <a href="#NOTIFICATIONS_URL#" target="_blank" style="font-size: 16px; font-weight: 500; color: #ffffff; text-decoration: none; display: inline-block;">',
unistr('                            <span style="text-align: center; display: block; padding: 12px 32px; margin: -12px -32px;">View #NOTIFICATION_COUNT# Notifica\00E7\00F5es</span>'),
'                          </a>',
'                        </td>',
'                      </tr>',
'                    </table>',
'                    <!-- // Button -->',
'',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // Main Body -->'))
,p_html_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'              <!-- Header -->',
'              <table width="100%">',
'                <tr>',
'                  <td style="border-bottom: 1px solid #e6e6e6; line-height: 0; padding: 4px 8px;">',
'',
'                    <!-- Logo -->',
'                    <a href="#EMAIL_LOGO_URL#" style=" display: inline-block; text-decoration: none;">',
'                      <table>',
'                        <tr>',
'                          <td style="vertical-align: middle;"><img src="https://apex.oracle.com/i/email/img/oracle-logo-2x.png" width="128" height="16" alt="Oracle" style="border: 0; font-size: 16px; line-height: 16px; display: block; width: 128px; h'
||'eight: 16px;"  /></td>',
'                          <td style="vertical-align: middle; padding: 12px; font-size: 16px; line-height: 20px; font-weight: 600; color: rgba(0,0,0,.85);">#APP_SHORT_NAME#</td>',
'                        </tr>',
'                      </table>',
'                    </a>',
'                    <!-- // Logo -->',
'',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // Header -->',
''))
,p_html_footer=>wwv_flow_string.join(wwv_flow_t_varchar2(
'             <!-- Footer -->',
'              <table width="100%">',
'                <tr>',
'                  <td class="footer-reduced" style="font-size: 12px; padding: 12px 32px; text-align: center; border-top: 1px solid #e6e6e6;">',
unistr('                    Voc\00EA recebeu esta notifica\00E7\00E3o porque se inscreveu para problemas que tenham nova atividade. Para deixar de receber futuras atualiza\00E7\00F5es, voc\00EA pode <a href="#EMAIL_PREFS_URL#" style="color: #056abf; text-decoration: none;">desativa')
||unistr('r notifica\00E7\00F5es por e-mail</a>.'),
'                  </td>',
'                </tr>',
'              </table>',
'            <!-- // Footer -->'))
,p_html_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE HTML>',
'<html>',
'<head>',
'  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">',
'  <meta name="viewport" content="width=device-width">',
'  <style>',
'    body { background-color: #fdfdfd; color: #3e3e3e; margin: 0; padding: 0; min-width: 100%; -webkit-text-size-adjust: none; -ms-text-size-adjust: none; text-size-adjust: none; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Helvetica N'
||'eue", Roboto, Helvetica, Arial, sans-serif; line-height: 1.5; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; }',
'    table { border: 0; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; }',
'    table td { padding: 0; vertical-align: top; border-collapse: collapse; }',
'    table, th, td { line-height: inherit; }',
'    img { vertical-align: middle; text-decoration: none; outline: none; border: 0; -ms-interpolation-mode: bicubic; }',
'    table.container { margin-right: auto; margin-left: auto; width: 600px; }',
'    p { margin: 0 0 20px 0; }',
'    a, .main a { color: #056abf; }',
'    @media only screen and (max-width: 612px) {',
'      .mobile-hide { display: none !important; }',
'      .stack { display: block !important; width: auto !important; }',
'      table.container { width: 100% !important; }',
'      table td { text-align: left !important; }',
'    }',
'  </style>',
'</head>',
'<body yahoo="fix" style="background-color: #efefef; line-height: 1.5;">',
'<table class="body" border="0" width="100%">',
'  <tr>',
'    <td align="center" valign="top" style="background-color: #efefef;">',
'      <center>',
'        <table class="container" width="600">',
'          <tr>',
'            <td style="padding: 12px 6px;">',
'',
'              #HEADER#',
'              #BODY#',
'              #FOOTER#',
'',
'            </td>',
'          </tr>',
'        </table>',
'      </center>',
'    </td>',
'  </tr>',
'</table>',
'</body>',
'</html>'))
,p_text_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('#NOTIFICATION_COUNT# Novas Notifica\00E7\00F5es'),
'',
'#NOTIFICATIONS_URL#'))
);
end;
/
prompt --application/shared_components/email/templates/issue_change
begin
wwv_flow_api.create_email_template(
 p_id=>wwv_flow_api.id(15674570214174148.4605)
,p_name=>'Issue Change'
,p_static_id=>'ISSUE_CHANGE'
,p_subject=>'#EMAIL_SUBJECT#'
,p_html_body=>wwv_flow_string.join(wwv_flow_t_varchar2(
'              <!-- SubHeader -->',
'              <table width="100%" style="color: #3e3e3e; background-color: #fcfcfc; border-bottom: 1px solid #f0f0f0;">',
'                <tr>',
'                  <td class="hero-reduced" style="text-align: center; padding: 32px; font-size: 14px;">',
'                    <span style="font-size: 20px; font-weight: 500;">#HEADER_MESSAGE#</span>',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // SubHeader -->',
'',
'              <!-- Main Body --> ',
'              <table width="100%" style="background-color: #ffffff;">',
'                <tr>',
'                  <td class="main main-reduced" style="text-align: left; padding: 32px; font-size: 14px; line-height: 20px;">',
'',
'                    #CHANGE_MESSAGE!RAW#<br>',
'                    <br>',
'                    <br>',
'                    <!-- Button -->',
'                    <table align="center">',
'                      <tr>',
'                        <td style="background-color: #056abf; color: #ffffff; padding: 12px 32px; border-radius: 2px; min-width: 160px;" align="center">',
'                          <a href="#ISSUE_URL#" target="_blank" style="font-size: 16px; font-weight: 500; color: #ffffff; text-decoration: none; display: inline-block;">',
'                            <span style="text-align: center; display: block; padding: 12px 32px; margin: -12px -32px;">Exibir Problema</span>',
'                          </a>',
'                        </td>',
'                      </tr>',
'                    </table>',
'                    <!-- // Button -->',
'',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // Main Body -->'))
,p_html_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'              <!-- Header -->',
'              <table width="100%">',
'                <tr>',
'                  <td style="border-bottom: 1px solid #e6e6e6; line-height: 0; padding: 4px 8px;">',
'',
'                    <!-- Logo -->',
'                    <a href="#EMAIL_LOGO_URL#" style=" display: inline-block; text-decoration: none;">',
'                      <table>',
'                        <tr>',
'                          <td style="vertical-align: middle;"><img src="https://apex.oracle.com/i/email/img/oracle-logo-2x.png" width="128" height="16" alt="Oracle" style="border: 0; font-size: 16px; line-height: 16px; display: block; width: 128px; h'
||'eight: 16px;"  /></td>',
'                          <td style="vertical-align: middle; padding: 12px; font-size: 16px; line-height: 20px; font-weight: 600; color: rgba(0,0,0,.85);">#APP_SHORT_NAME#</td>',
'                        </tr>',
'                      </table>',
'                    </a>',
'                    <!-- // Logo -->',
'',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // Header -->',
'',
''))
,p_html_footer=>wwv_flow_string.join(wwv_flow_t_varchar2(
'             <!-- Footer -->',
'              <table width="100%">',
'                <tr>',
'                  <td class="footer-reduced" style="font-size: 12px; padding: 12px 32px; text-align: center; border-top: 1px solid #e6e6e6;">',
unistr('                    Voc\00EA recebeu esta notifica\00E7\00E3o porque se inscreveu para problemas que tenham nova atividade. Para deixar de receber futuras atualiza\00E7\00F5es, voc\00EA pode <a href="#EMAIL_PREFS_URL#" style="color: #056abf; text-decoration: none;">desativa')
||unistr('r notifica\00E7\00F5es por e-mail</a>.'),
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // Footer -->'))
,p_html_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE HTML>',
'<html>',
'<head>',
'  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">',
'  <meta name="viewport" content="width=device-width">',
'  <style>',
'    body { background-color: #fdfdfd; color: #3e3e3e; margin: 0; padding: 0; min-width: 100%; -webkit-text-size-adjust: none; -ms-text-size-adjust: none; text-size-adjust: none; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Helvetica N'
||'eue", Roboto, Helvetica, Arial, sans-serif; line-height: 1.5; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; }',
'    table { border: 0; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; }',
'    table td { padding: 0; vertical-align: top; border-collapse: collapse; }',
'    table, th, td { line-height: inherit; }',
'    img { vertical-align: middle; text-decoration: none; outline: none; border: 0; -ms-interpolation-mode: bicubic; }',
'    table.container { margin-right: auto; margin-left: auto; width: 600px; }',
'    p { margin: 0 0 20px 0; }',
'    a, .main a { color: #056abf; }',
'    @media only screen and (max-width: 612px) {',
'      .mobile-hide { display: none !important; }',
'      .stack { display: block !important; width: auto !important; }',
'      table.container { width: 100% !important; }',
'    }',
'  </style>',
'</head>',
'<body yahoo="fix" style="background-color: #efefef; line-height: 1.5;">',
'<table class="body" border="0" width="100%">',
'  <tr>',
'    <td align="center" valign="top" style="background-color: #efefef;">',
'      <center>',
'        <table class="container" width="600">',
'          <tr>',
'            <td style="padding: 12px 6px;">',
'',
'              #HEADER#',
'              #BODY#',
'              #FOOTER#',
'',
'            </td>',
'          </tr>',
'        </table>',
'      </center>',
'    </td>',
'  </tr>',
'</table>',
'</body>',
'</html>'))
,p_text_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#EMAIL_SUBJECT#',
'',
'#ISSUE_URL#'))
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(544702116026132813.4605)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040.4605
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(17268319223727578.4605)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>unistr('Autoriza\00E7\00E3o do Desenvolvedor')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(791660229562971532.4605)
,p_plugin_id=>wwv_flow_api.id(17268319223727578.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791660605682971532.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791661203571971534.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791661694542971534.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791662185290971534.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791662620816971534.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791663127709971535.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791663642901971537.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791664174494971537.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791664698710971538.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791665180129971538.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791665671443971539.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(791666120822971539.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(791660229562971532.4605)
,p_display_sequence=>120
,p_display_value=>'PKG_APPS: Ability to install packaged applications'
,p_return_value=>'PKG_APPS'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_searchbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(78652560687827668.4605)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.SEARCHBOX'
,p_display_name=>'Caixa de Pesquisa'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.SEARCHBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_searchbox'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT'
,p_substitute_attributes=>true
,p_reference_id=>42609120788689442.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1517927831748688683.4605)
,p_plugin_id=>wwv_flow_api.id(78652560687827668.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Redirect URL'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:<target page>:&SESSION.::&DEBUG.::<target item>:'
,p_display_length=>80
,p_max_length=>4000
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1517928294783688683.4605)
,p_plugin_id=>wwv_flow_api.id(78652560687827668.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Search Text'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Search'
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
''))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(118506410176124090.4605)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>unistr('Autentica\00E7\00E3o Apex')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(123365889011393768.4605)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>'INTERNAL Acesso Social'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(123366014302393769.4605)
,p_plugin_id=>wwv_flow_api.id(123365889011393768.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(123367977503393769.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(123366014302393769.4605)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(123366464993393769.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(123366014302393769.4605)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(123367004755393769.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(123366014302393769.4605)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(123367500098393769.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(123366014302393769.4605)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(123368405598393770.4605)
,p_plugin_id=>wwv_flow_api.id(123365889011393768.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(123366014302393769.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(123368882400393770.4605)
,p_plugin_id=>wwv_flow_api.id(123365889011393768.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(123366014302393769.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(123369237284393770.4605)
,p_plugin_id=>wwv_flow_api.id(123365889011393768.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(123366014302393769.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(123369618528393770.4605)
,p_plugin_id=>wwv_flow_api.id(123365889011393768.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(123366014302393769.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(123370077293393770.4605)
,p_plugin_id=>wwv_flow_api.id(123365889011393768.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Application Express automatically adds the "openid" scope. The authent'
||'ication provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(123370501239393770.4605)
,p_plugin_id=>wwv_flow_api.id(123365889011393768.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(123370829564393771.4605)
,p_plugin_id=>wwv_flow_api.id(123365889011393768.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(123371277911393771.4605)
,p_plugin_id=>wwv_flow_api.id(123365889011393768.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(361433126909906343.4605)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>'INTERNAL Oracle Cloud Identity Management'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749806821809026.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(361435914819906347.4605)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>'INTERNAL Contas de Banco de Dados'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749511183746276.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(361467810754906382.4605)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>unistr('INTERNAL Vari\00E1vel de Cabe\00E7alho HTTP')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>708795120396802284.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361468024245906382.4605)
,p_plugin_id=>wwv_flow_api.id(361467810754906382.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361468405159906382.4605)
,p_plugin_id=>wwv_flow_api.id(361467810754906382.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361468818132906382.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361468405159906382.4605)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361469336586906383.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361468405159906382.4605)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361469823567906383.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361468405159906382.4605)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361470317133906383.4605)
,p_plugin_id=>wwv_flow_api.id(361467810754906382.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(361468405159906382.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>',
'<p>',
'<h3>Example:</h3>',
'<pre>http://sso.mycompany.com/?success=#CALLBACK#</pre>',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361470706531906384.4605)
,p_plugin_id=>wwv_flow_api.id(361467810754906382.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(361468405159906382.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361471110968906384.4605)
,p_plugin_id=>wwv_flow_api.id(361467810754906382.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(361468405159906382.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'BUILTIN_URL,URL'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361471530408906384.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361471110968906384.4605)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361472022352906385.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361471110968906384.4605)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361472506878906385.4605)
,p_plugin_id=>wwv_flow_api.id(361467810754906382.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(361538211820906436.4605)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>unistr('INTERNAL Diret\00F3rio LDAP')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>863910941135523528.4605
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Informe o nome de usu\00E1rio e a senha para autentica\00E7\00E3o no diret\00F3rio LDAP identificado na p\00E1gina de log-in. Lembre-se de que as senhas podem fazer distin\00E7\00E3o entre mai\00FAsculas e min\00FAsculas.</p>'),
''))
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361538531240906436.4605)
,p_plugin_id=>wwv_flow_api.id(361538211820906436.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361538917330906436.4605)
,p_plugin_id=>wwv_flow_api.id(361538211820906436.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361539328797906436.4605)
,p_plugin_id=>wwv_flow_api.id(361538211820906436.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361539709386906436.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361539328797906436.4605)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361540220840906436.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361539328797906436.4605)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361540722154906437.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361539328797906436.4605)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361541215083906437.4605)
,p_plugin_id=>wwv_flow_api.id(361538211820906436.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361541630010906438.4605)
,p_plugin_id=>wwv_flow_api.id(361538211820906436.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361542006423906438.4605)
,p_plugin_id=>wwv_flow_api.id(361538211820906436.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(361541630010906438.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361542419805906438.4605)
,p_plugin_id=>wwv_flow_api.id(361538211820906436.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(361542827737906438.4605)
,p_plugin_id=>wwv_flow_api.id(361538211820906436.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361543237609906438.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361542827737906438.4605)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361543718091906439.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361542827737906438.4605)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(361544225021906439.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(361542827737906438.4605)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(361579733902906466.4605)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'INTERNAL SSO do Oracle Application Server'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113750429890071859.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_html5_bar_chart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(635874051061319712.4605)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_display_name=>unistr('Gr\00E1fico de Barras HTML 5 ***')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.HTML5_BAR_CHART'),'#IMAGE_PREFIX#plugins/com.oracle.apex.html5_bar_chart/1.0/')
,p_javascript_file_urls=>'#PLUGIN_FILES#com_oracle_apex_html5_bar_chart.js'
,p_css_file_urls=>'#PLUGIN_FILES#com_oracle_apex_html5_bar_chart.css'
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'FUNCTION RENDER (',
'    P_REGION IN APEX_PLUGIN.T_REGION,',
'    P_PLUGIN IN APEX_PLUGIN.T_PLUGIN,',
'    P_IS_PRINTER_FRIENDLY IN BOOLEAN',
') RETURN APEX_PLUGIN.T_REGION_RENDER_RESULT IS',
'BEGIN',
'    sys.HTP.PRN(''<div id="''||APEX_ESCAPE.HTML_ATTRIBUTE(P_REGION.STATIC_ID)||''_chart" class="hbc">'');',
'    sys.HTP.PRN(''</div>'');',
'    ',
'    APEX_JAVASCRIPT.ADD_ONLOAD_CODE (',
'        P_CODE => ''com_oracle_apex_html5_bar_chart(''||',
'            APEX_JAVASCRIPT.ADD_VALUE(P_REGION.STATIC_ID)||',
'            ''{''||',
'                -- Why is this attribute needed if is not used?',
'                APEX_JAVASCRIPT.ADD_ATTRIBUTE(',
'                    ''pageItems'', ',
'                    APEX_PLUGIN_UTIL.PAGE_ITEM_NAMES_TO_JQUERY(P_REGION.AJAX_ITEMS_TO_SUBMIT)',
'                )||',
'                APEX_JAVASCRIPT.ADD_ATTRIBUTE(',
'                    ''ajaxIdentifier'', ',
'                    APEX_PLUGIN.GET_AJAX_IDENTIFIER, ',
'                    FALSE, ',
'                    FALSE',
'                )||',
'            ''}''||',
'        '');''',
'    );',
'    ',
'    RETURN NULL;',
'END RENDER;',
'',
'FUNCTION AJAX (',
'    P_REGION IN APEX_PLUGIN.T_REGION,',
'    P_PLUGIN IN APEX_PLUGIN.T_PLUGIN',
') RETURN APEX_PLUGIN.T_REGION_AJAX_RESULT IS',
'    -- Map region attributes to function constants',
'    -- MODERN, CLASSIC',
'    C_CHART_TYPE CONSTANT VARCHAR2(7) := P_REGION.ATTRIBUTE_15;',
'    -- MODERN, MODERN_2, SOLAR, METRO, CUSTOM, COLUMN',
'    C_COLOR_SCHEME CONSTANT VARCHAR2(8) := P_REGION.ATTRIBUTE_17;',
'    C_CUSTOM_CHART_COLORS CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_10;',
'    C_COLOR_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_19;',
'    -- NONE, IMAGE, ICON, INITIALS',
'    C_ICON_TYPE CONSTANT VARCHAR2(8) := case when C_CHART_TYPE = ''ICON'' then P_REGION.ATTRIBUTE_01 end;',
'    C_LABEL_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_02;',
'    C_LABEL_LINK CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_03;',
'    C_VALUE_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_04;',
'    C_VALUE_LINK CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_05;',
'    -- ABOVE, AROUND',
'    C_TEXT_POSITION VARCHAR2(6) := P_REGION.ATTRIBUTE_18;',
'    C_CHART_CSS_CLASSES CONSTANT VARCHAR2(32767) := P_REGION.ATTRIBUTE_06;',
'    C_IMAGE_URL CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_07;',
'    C_CSS_ICON_CLASS_NAME CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_08;',
'    C_INITIALS_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_09;',
'    -- ABSOLUTE, RELATIVE',
'    C_BAR_WIDTH_CALCULATION CONSTANT VARCHAR2(8) := P_REGION.ATTRIBUTE_16;',
'    C_DISPLAY CONSTANT VARCHAR2(19) := P_REGION.ATTRIBUTE_11;',
'    C_PREFIX_FOR_VALUE CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_12;',
'    C_POSTFIX_FOR_VALUE CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_13;',
'    C_MAXIMUM_ROWS CONSTANT NUMBER := P_REGION.ATTRIBUTE_14;',
'    C_MESSAGE_WHEN_NO_DATA_FOUND CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_20;',
'    ',
'    L_COLOR_COLUMN_NUMBER PLS_INTEGER;',
'    L_LABEL_COLUMN_NUMBER PLS_INTEGER;',
'    L_VALUE_COLUMN_NUMBER PLS_INTEGER;',
'    L_INITIALS_COLUMN_NUMBER PLS_INTEGER;',
'    ',
'    L_COLUMN_VALUE_LIST APEX_PLUGIN_UTIL.T_COLUMN_VALUE_LIST2;',
'    ',
'    L_COLOR VARCHAR2(4000) := NULL;',
'    L_LABEL VARCHAR2(4000) := NULL;',
'    L_LABEL_LINK VARCHAR2(4000) := NULL;',
'    L_VALUE VARCHAR2(4000) := NULL;',
'    L_VALUE_LINK VARCHAR2(4000) := NULL;',
'    L_IMAGE_URL VARCHAR2(4000) := NULL;',
'    L_CSS_ICON_CLASS_NAME VARCHAR2(4000) := NULL;',
'    L_INITIALS VARCHAR2(4000) := NULL;',
'    L_MESSAGE_WHEN_NO_DATA_FOUND VARCHAR2(4000) := NULL;',
'',
'    L_CUSTOM_CHART_COLORS_TABLE APEX_APPLICATION_GLOBAL.VC_ARR2;',
'    L_CUSTOM_CHART_COLORS VARCHAR2(32767) := NULL;',
'BEGIN',
'    L_COLUMN_VALUE_LIST := APEX_PLUGIN_UTIL.GET_DATA2(',
'        P_SQL_STATEMENT  => P_REGION.SOURCE,',
'        P_MIN_COLUMNS    => 1,',
'        P_MAX_COLUMNS    => NULL,',
'        P_COMPONENT_NAME => P_REGION.NAME,',
'        P_MAX_ROWS => C_MAXIMUM_ROWS',
'    );',
'',
'    L_COLOR_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Color Column'',',
'        P_COLUMN_ALIAS      => C_COLOR_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => C_COLOR_SCHEME = ''COLUMN'',',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    L_LABEL_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Label Column'',',
'        P_COLUMN_ALIAS      => C_LABEL_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => TRUE,',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    L_VALUE_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Value Column'',',
'        P_COLUMN_ALIAS      => C_VALUE_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => TRUE,',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    if C_ICON_TYPE = ''INITIALS'' then',
'        L_INITIALS_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'            P_ATTRIBUTE_LABEL   => ''Initials Column'',',
'            P_COLUMN_ALIAS      => C_INITIALS_COLUMN,',
'            P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'            P_IS_REQUIRED       => true,',
'            P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'        );',
'    end if;',
'    -- Begin output as JSON',
'    sys.OWA_UTIL.MIME_HEADER(''application/json'', FALSE);',
'    sys.HTP.P(''Cache-Control: no-cache'');',
'    sys.HTP.P(''Pragma: no-cache'');',
'    sys.OWA_UTIL.HTTP_HEADER_CLOSE;',
'    ',
'    IF C_COLOR_SCHEME = ''CUSTOM'' THEN',
'        L_CUSTOM_CHART_COLORS_TABLE := APEX_UTIL.STRING_TO_TABLE(CASE WHEN C_CUSTOM_CHART_COLORS IS NOT NULL THEN TRIM(BOTH '''''''' FROM APEX_ESCAPE.JS_LITERAL(C_CUSTOM_CHART_COLORS)) END, '':'');',
'        L_CUSTOM_CHART_COLORS := ''"color_scheme":['';',
'        FOR I IN L_CUSTOM_CHART_COLORS_TABLE.FIRST .. L_CUSTOM_CHART_COLORS_TABLE.LAST LOOP',
'            IF I > 1 THEN',
'                L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||'','';',
'            END IF;',
'            L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||''"''||L_CUSTOM_CHART_COLORS_TABLE(I)||''"'';',
'        END LOOP;',
'        L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||''],'';',
'    END IF;',
'',
'    L_MESSAGE_WHEN_NO_DATA_FOUND := APEX_ESCAPE.HTML_WHITELIST(',
'        APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                P_VALUE  => C_MESSAGE_WHEN_NO_DATA_FOUND,',
'                P_ESCAPE => FALSE',
'            )',
'        );',
'',
'    sys.HTP.PRN(',
'        ''{''||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''chart_type'',',
'                C_CHART_TYPE,',
'                FALSE,',
'                TRUE',
'            )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''message_when_no_data_found'',',
'            L_MESSAGE_WHEN_NO_DATA_FOUND,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''chart_css_class_names'',',
'            C_CHART_CSS_CLASSES,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''icon_type'',',
'            C_ICON_TYPE,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    IF C_COLOR_SCHEME = ''CUSTOM'' THEN',
'        sys.HTP.PRN(',
'            L_CUSTOM_CHART_COLORS',
'        );',
'    ELSE',
'        sys.HTP.PRN(',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''color_scheme'',',
'                C_COLOR_SCHEME,',
'                TRUE,',
'                TRUE',
'            )',
'        );',
'    END IF;',
'    sys.HTP.PRN(',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''text_position'',',
'                C_TEXT_POSITION,',
'                FALSE,',
'                TRUE',
'            )||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''bar_width_calculation'',',
'                C_BAR_WIDTH_CALCULATION,',
'                FALSE,',
'                TRUE',
'            )||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''display'',',
'                C_DISPLAY,',
'                FALSE,',
'                TRUE',
'            )||',
'            CASE ',
'            	WHEN C_DISPLAY IN (''VALUE'') THEN',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''prefix_for_value'',',
'						C_PREFIX_FOR_VALUE,',
'						TRUE,',
'						TRUE',
'					)||',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''postfix_for_value'',',
'						C_POSTFIX_FOR_VALUE,',
'						TRUE,',
'						TRUE',
'					)',
'			END||',
'            ''"items":[''',
'    );',
'    ',
'    --FOR L_ROW_NUMBER IN L_COLUMN_VALUE_LIST(1).VALUE_LIST.FIRST .. L_COLUMN_VALUE_LIST(1).VALUE_LIST.LAST LOOP',
'    FOR L_ROW_NUMBER IN 1 .. L_COLUMN_VALUE_LIST(1).VALUE_LIST.COUNT LOOP',
'        BEGIN',
'            APEX_PLUGIN_UTIL.SET_COMPONENT_VALUES (',
'                P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'                P_ROW_NUM => L_ROW_NUMBER ',
'            );',
'            ',
'            IF L_ROW_NUMBER > 1 THEN',
'            	sys.HTP.PRN('', '');',
'            END IF;',
'            ',
'            sys.HTP.PRN(''{'');',
'            ',
'            L_LABEL := APEX_PLUGIN_UTIL.ESCAPE (',
'                APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                    P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_LABEL_COLUMN_NUMBER).DATA_TYPE,',
'                    P_VALUE => L_COLUMN_VALUE_LIST(L_LABEL_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'                ),',
'                P_REGION.ESCAPE_OUTPUT',
'            );',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''label'',',
'                    L_LABEL,',
'                    FALSE',
'            	)',
'            );',
'            L_LABEL_LINK := ',
'                CASE ',
'                    WHEN C_LABEL_LINK IS NOT NULL THEN ',
'                        APEX_UTIL.PREPARE_URL (',
'                            APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                P_VALUE  => C_LABEL_LINK,',
'                                P_ESCAPE => FALSE',
'                            )',
'                        )',
'                END;',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''label_link'',',
'                    L_LABEL_LINK',
'                )',
'            );',
'            L_VALUE := APEX_PLUGIN_UTIL.ESCAPE (',
'               APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                   P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_VALUE_COLUMN_NUMBER).DATA_TYPE,',
'                   P_VALUE => L_COLUMN_VALUE_LIST(L_VALUE_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'               ),',
'               P_REGION.ESCAPE_OUTPUT',
'            );',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''value'',',
'                    L_VALUE,',
'                    FALSE,',
'                    C_VALUE_LINK IS NOT NULL OR L_COLOR_COLUMN_NUMBER IS NOT NULL OR C_CHART_TYPE = ''ICON''',
'                )',
'            );',
'            L_VALUE_LINK := ',
'                CASE ',
'                    WHEN C_VALUE_LINK IS NOT NULL THEN ',
'                        APEX_UTIL.PREPARE_URL (',
'                            APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                P_VALUE  => C_VALUE_LINK,',
'                                P_ESCAPE => FALSE',
'                            )',
'                        )',
'                END;',
'             sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''value_link'',',
'                    L_VALUE_LINK,',
'                    TRUE,',
'                    L_COLOR_COLUMN_NUMBER IS NOT NULL OR C_CHART_TYPE = ''ICON''',
'                )',
'            );',
'            IF L_COLOR_COLUMN_NUMBER IS NOT NULL THEN',
'                L_COLOR := APEX_PLUGIN_UTIL.ESCAPE (',
'                   APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                       P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_COLOR_COLUMN_NUMBER).DATA_TYPE,',
'                       P_VALUE => L_COLUMN_VALUE_LIST(L_COLOR_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'                   ),',
'                   P_REGION.ESCAPE_OUTPUT',
'                );',
'                sys.HTP.PRN(',
'                    APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                        ''color'',',
'                        L_COLOR,',
'                        FALSE,',
'                        C_CHART_TYPE = ''ICON''',
'                    )',
'                );',
'            END IF;',
'            IF C_ICON_TYPE = ''IMAGE'' THEN',
'				L_IMAGE_URL := ',
'                    CASE ',
'                        WHEN C_IMAGE_URL IS NOT NULL THEN ',
'                            APEX_UTIL.PREPARE_URL (',
'                                APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                    P_VALUE  => C_IMAGE_URL,',
'                                    P_ESCAPE => FALSE',
'                                )',
'                            )',
'                    END;',
'				sys.HTP.PRN(',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''image_url'',',
'						L_IMAGE_URL,',
'						FALSE,',
'						FALSE',
'					)',
'				);',
'			ELSIF C_ICON_TYPE = ''ICON'' THEN',
'				L_CSS_ICON_CLASS_NAME := APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                    P_VALUE  => C_CSS_ICON_CLASS_NAME,',
'                    P_ESCAPE => TRUE',
'                );',
'				sys.HTP.PRN(',
'                	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''icon_css_class_name'',',
'						L_CSS_ICON_CLASS_NAME,',
'						FALSE,',
'						FALSE',
'					)',
'				);',
'			ELSIF C_ICON_TYPE = ''INITIALS'' THEN',
'				L_INITIALS := APEX_PLUGIN_UTIL.ESCAPE (',
'					APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'						P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_INITIALS_COLUMN_NUMBER).DATA_TYPE,',
'						P_VALUE => L_COLUMN_VALUE_LIST(L_INITIALS_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'					),',
'					P_REGION.ESCAPE_OUTPUT',
'				);',
'				sys.HTP.PRN(',
'                	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    	''initials'',',
'	                    L_INITIALS,',
'	                    FALSE,',
'	                    FALSE',
'    	            )',
'    	        );',
'            END IF;',
'            ',
'			sys.HTP.PRN(''}'');',
'            ',
'            APEX_PLUGIN_UTIL.CLEAR_COMPONENT_VALUES;',
'        EXCEPTION',
'            WHEN OTHERS THEN',
'                APEX_PLUGIN_UTIL.CLEAR_COMPONENT_VALUES;',
'                RAISE;',
'        END;',
'    END LOOP;',
'    sys.HTP.PRN(',
'            '']''||',
'        ''}''',
'    );',
'    ',
'    RETURN NULL;',
'END AJAX;'))
,p_api_version=>1
,p_render_function=>'RENDER'
,p_ajax_function=>'AJAX'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT:ESCAPE_OUTPUT'
,p_substitute_attributes=>false
,p_reference_id=>5610141522737396215.4605
,p_subscribe_plugin_settings=>true
,p_help_text=>unistr('<p>Este plug-in desenha gr\00E1ficos de barras horizontais que cont\00EAm labels, valores e at\00E9 mesmo \00EDcones</p>')
,p_version_identifier=>'1.0'
,p_files_version=>16
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707135254198706759.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Icon Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'INITIALS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1707143388133706765.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ICON'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'    <li><strong>Image</strong>: Adds an image HTML element on the left side of the chart.</li>',
'    <li><strong>CSS Icon</strong>: Unlike the &quot;Image&quot; icon, instead of displaying an image HTML element, it displays an icon with the given CSS class.</li>',
'    <li><strong>Initials</strong>: Opposed to both, the &quot;Image&quot; and &quot;CSS Icon&quot; icons, this one displays a colored circle containing the given initials.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707135682945706760.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707135254198706759.4605)
,p_display_sequence=>10
,p_display_value=>'Image'
,p_return_value=>'IMAGE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707136134655706760.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707135254198706759.4605)
,p_display_sequence=>20
,p_display_value=>'CSS Icon'
,p_return_value=>'ICON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707136612576706760.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707135254198706759.4605)
,p_display_sequence=>30
,p_display_value=>'Initials'
,p_return_value=>'INITIALS'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707137139895706761.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Label Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'<p>A query column from which the label to be displayed is given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707137535232706761.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Label Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
,p_help_text=>'<p>A URL to be opened whenever the label is clicked. This attribute supports substitution strings.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707137965217706761.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'<p>A query column from which the label to be displayed is given. Notice that this value is not displayed on the chart items when the chart has been configured to display the bar width percentage instead.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707138328998706762.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Value Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
,p_help_text=>'<p>A URL to be opened whenever the displayed value is clicked. This attribute supports substitution strings.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707138785500706762.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>5
,p_prompt=>'Chart CSS Class Names'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'<p>CSS class names to be added to the root element of the chart separated with spaces.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707139150844706762.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>13
,p_prompt=>'Image URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1707135254198706759.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'IMAGE'
,p_help_text=>'<p>The Image URL to be displayed as the chart icon. This attribute supports Substitution strings referring to som query column like in <strong>&amp;IMAGE_URL.</strong> which would reference the <strong>IMAGE_URL</strong> column value for each of the '
||'bars presented on the char. Notice that substitutions with no value will be replaced with an empty string.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707139591374706763.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>12
,p_prompt=>'CSS Icon Class Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1707135254198706759.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ICON'
,p_help_text=>'<p>The Icon CSS Class Name.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707139934675706763.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>14
,p_prompt=>'Initials Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1707135254198706759.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'INITIALS'
,p_help_text=>'<p>A query column from which initials to be displayed as an icon are given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707140345407706763.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>7
,p_prompt=>'Custom Chart Colors'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1707146119891706768.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'<p>A list of CSS supported colors separated by colons.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707140779500706763.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Display'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VALUE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'<p>Displays either the item value or the calculated bar width on the right most text in the chart item.</p>'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707141195917706764.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707140779500706763.4605)
,p_display_sequence=>10
,p_display_value=>'Value'
,p_return_value=>'VALUE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707141676390706764.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707140779500706763.4605)
,p_display_sequence=>20
,p_display_value=>'Bar Width'
,p_return_value=>'BAR_WIDTH'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707142158372706764.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Prefix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1707140779500706763.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE'
,p_help_text=>'<p>When the value is displayed on the right most side of the chart item. The value of this attribute is prepended to it.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707142580011706765.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Postfix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1707140779500706763.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE'
,p_help_text=>'<p>When the value is displayed on the right most side of the chart item. The value of this attribute is appended to it.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707142944778706765.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Maximum Rows'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'5'
,p_is_translatable=>false
,p_help_text=>'<p>The maximum number of items to be displayed inside the region. Notice bar width calculations are made based on the number of items displayed.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707143388133706765.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>4
,p_prompt=>'Chart Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'TEXT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Defines how the chart will be displayed. There are two types of chart: </p>',
'<ul>',
'    <li><strong>Icon Chart</strong>: Displays bars with the label and value above and add an icon on the left.</li>',
'    <li><strong>Text Chart</strong>: Displays bars with the label and value either above or inline with the bar.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707143720575706765.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707143388133706765.4605)
,p_display_sequence=>10
,p_display_value=>'Icon Chart'
,p_return_value=>'ICON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707144217603706766.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707143388133706765.4605)
,p_display_sequence=>20
,p_display_value=>'Text Chart'
,p_return_value=>'TEXT'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707144804246706766.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>105
,p_prompt=>'Bar Width Calculation'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ABSOLUTE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Bar widths for each one of the chart items can be calculated in two ways:</p>',
'<ul>',
'    <li><strong>Absolute</strong>: 100% bar width is represented by the maximum value on the displayed chart items.</li>',
'    <li><strong>Relative</strong>: 100% bar width is represented by the sum of the values of all the displayed chart items.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707145178337706766.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707144804246706766.4605)
,p_display_sequence=>10
,p_display_value=>'Absolute'
,p_return_value=>'ABSOLUTE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707145635591706767.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707144804246706766.4605)
,p_display_sequence=>20
,p_display_value=>'Relative'
,p_return_value=>'RELATIVE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707146119891706768.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>6
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'MODERN'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The colors to be used in the chart bars. There are two special types of configuration: </p>',
'<ul>',
'    <li><strong>Custom</strong>: Provides a text box to receive a colon separated list of css supported colors.</li>',
'</ul>',
'<ul>',
'    <li><strong>Query Column</strong>: Provides a select list with the query columns which expects a css valid color.</li>',
'</ul>',
''))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707146594181706769.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707146119891706768.4605)
,p_display_sequence=>5
,p_display_value=>'Default'
,p_return_value=>'DEFAULT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707147049523706769.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707146119891706768.4605)
,p_display_sequence=>10
,p_display_value=>'Modern'
,p_return_value=>'MODERN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707147580790706770.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707146119891706768.4605)
,p_display_sequence=>20
,p_display_value=>'Modern 2'
,p_return_value=>'MODERN_2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707148102067706770.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707146119891706768.4605)
,p_display_sequence=>30
,p_display_value=>'Solar'
,p_return_value=>'SOLAR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707148551555706770.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707146119891706768.4605)
,p_display_sequence=>40
,p_display_value=>'Metro'
,p_return_value=>'METRO'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707149042666706771.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707146119891706768.4605)
,p_display_sequence=>50
,p_display_value=>'Custom'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707149558976706771.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707146119891706768.4605)
,p_display_sequence=>60
,p_display_value=>'Query Column'
,p_return_value=>'COLUMN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707150076740706771.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>55
,p_prompt=>'Text Position'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'AROUND'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1707143388133706765.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'TEXT'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When displaying a text chart, two options are available for displaying the label and value texts:</p>',
'<ul>',
'    <li><strong>Above the bar</strong>: The label and value texts are displayed above the bar at the left and right most sides of it respectively.</li>',
'    <li><strong>Inline with the bar</strong>: The label, the bar and the value are displayed in one line on that order.</li>',
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707150442754706772.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707150076740706771.4605)
,p_display_sequence=>10
,p_display_value=>'Above the bar'
,p_return_value=>'ABOVE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1707150983585706772.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1707150076740706771.4605)
,p_display_sequence=>20
,p_display_value=>'Inline with the bar'
,p_return_value=>'AROUND'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707151473915706773.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>8
,p_prompt=>'Chart Colors Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1707146119891706768.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'COLUMN'
,p_help_text=>'<p>A query column from which CSS supported colors are given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1707151717220706773.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>200
,p_prompt=>'Message When No Data Found'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_default_value=>'No data found.'
,p_is_translatable=>true
,p_help_text=>'<p>Message to be displayed when no data was found.</p>'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(1707159351786706781.4605)
,p_plugin_id=>wwv_flow_api.id(635874051061319712.4605)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>1
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_listcalendar
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.LISTCALENDAR'
,p_display_name=>unistr('Listar Calend\00E1rio (Builder)')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.LISTCALENDAR'),'#IMAGE_PREFIX#plugins/com.oracle.apex.listcalendar/')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'procedure render_list_calendar( p_region in apex_plugin.t_region ) is',
'    c_date_col           constant varchar2(255) := p_region.attribute_01;',
'    c_color_col          constant varchar2(255) := p_region.attribute_02;',
'    c_title_col          constant varchar2(255) := p_region.attribute_03;',
'    c_link_col           constant varchar2(255) := p_region.attribute_04;',
'    c_row1_attr1_lbl_col constant varchar2(255) := p_region.attribute_05;',
'    c_row1_attr1_val_col constant varchar2(255) := p_region.attribute_06;',
'    c_row1_attr2_lbl_col constant varchar2(255) := p_region.attribute_07;',
'    c_row1_attr2_val_col constant varchar2(255) := p_region.attribute_08;',
'    c_row2_attr1_lbl_col constant varchar2(255) := p_region.attribute_09;',
'    c_row2_attr1_val_col constant varchar2(255) := p_region.attribute_10;',
'    c_row2_attr2_lbl_col constant varchar2(255) := p_region.attribute_11;',
'    c_row2_attr2_val_col constant varchar2(255) := p_region.attribute_12;',
'    c_description_1_col  constant varchar2(255) := p_region.attribute_13;',
'    c_description_2_col  constant varchar2(255) := p_region.attribute_14;',
'    c_description_3_col  constant varchar2(255) := p_region.attribute_15;',
'',
'    l_date_col_no           pls_integer;',
'    l_color_col_no          pls_integer;',
'    l_title_col_no          pls_integer;',
'    l_link_col_no           pls_integer;',
'    l_row1_attr1_lbl_col_no pls_integer;',
'    l_row1_attr1_val_col_no pls_integer;',
'    l_row1_attr2_lbl_col_no pls_integer;',
'    l_row1_attr2_val_col_no pls_integer;',
'    l_row2_attr1_lbl_col_no pls_integer;',
'    l_row2_attr1_val_col_no pls_integer;',
'    l_row2_attr2_lbl_col_no pls_integer;',
'    l_row2_attr2_val_col_no pls_integer;',
'    l_description_1_col_no  pls_integer;',
'    l_description_2_col_no  pls_integer;',
'    l_description_3_col_no  pls_integer;',
'',
'    l_date           timestamp with local time zone;',
'    l_color          varchar2(4000);',
'    l_color_hex      varchar2(4000);',
'    l_title          varchar2(4000);',
'    l_link           varchar2(4000);',
'    l_row1_attr1_lbl varchar2(4000);',
'    l_row1_attr1_val varchar2(4000);',
'    l_row1_attr2_lbl varchar2(4000);',
'    l_row1_attr2_val varchar2(4000);',
'    l_row2_attr1_lbl varchar2(4000);',
'    l_row2_attr1_val varchar2(4000);',
'    l_row2_attr2_lbl varchar2(4000);',
'    l_row2_attr2_val varchar2(4000);',
'    l_description_1  varchar2(4000);',
'    l_description_2  varchar2(4000);',
'    l_description_3  varchar2(4000);',
'',
'    --',
'    l_no_data_found     varchar2(32767) := p_region.no_data_found_message;',
'    l_num_rows          pls_integer     := p_region.fetched_rows;',
'    --',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_region_source        varchar2(32767) := p_region.source;',
'',
'    --',
'    l_last_month  varchar2(255) := ''x'';',
'    l_this_year   varchar2(4)   := ''x'';',
'',
'    l_found boolean;',
'    l_count pls_integer := 0;',
'begin',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => l_region_source,',
'                               p_min_columns    => 3,',
'                               p_max_columns    => null,',
'                               p_component_name => p_region.name,',
'                               p_max_rows       => null );',
'',
'    -- Get the actual column number for the fields we want.',
'    l_date_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Date column'',',
'                        p_column_alias      => c_date_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => null -- might be date, timestamp, etc.',
'                    );',
'',
'    l_color_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Color column'',',
'                        p_column_alias      => c_color_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_title_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Title column'',',
'                        p_column_alias      => c_title_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_link_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Link column'',',
'                        p_column_alias      => c_link_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr1_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Attribute Label column'',',
'                        p_column_alias      => c_row1_attr1_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr1_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Attribute Value column'',',
'                        p_column_alias      => c_row1_attr1_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr2_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Attribute Label column'',',
'                        p_column_alias      => c_row1_attr2_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr2_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Attribute Value column'',',
'                        p_column_alias      => c_row1_attr2_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr1_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Attribute Label column'',',
'                        p_column_alias      => c_row2_attr1_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr1_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Attribute Value column'',',
'                        p_column_alias      => c_row2_attr1_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr2_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Fourth Attribute Label column'',',
'                        p_column_alias      => c_row2_attr2_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr2_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Fourth Attribute Value column'',',
'                        p_column_alias      => c_row2_attr2_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_1_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Description column'',',
'                        p_column_alias      => c_description_1_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_2_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Description column'',',
'                        p_column_alias      => c_description_2_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_3_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Description column (allows HTML)'',',
'                        p_column_alias      => c_description_3_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    -- Loop through the data',
'',
'    sys.htp.p(''<div class="a-StatusList a-StatusList--dates">'');',
'',
'    for l_row_num in 1..l_column_value_list(1).value_list.count loop',
'        l_found := true;',
'',
'        if l_column_value_list(l_date_col_no).value_list(l_row_num).date_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).date_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_tz_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_tz_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_ltz_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_ltz_value;',
'        else',
'            -- Couldn''t get a usable date value; ignore this row.',
'            l_found := false;',
'        end if;',
'        if l_found = true and l_count < nvl(l_num_rows,l_count) then',
'            l_count := l_count + 1;',
'            if l_color_col_no is not null then',
'                l_color := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_color_col_no).data_type,',
'                                p_value     => l_column_value_list(l_color_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_title_col_no is not null then',
'                l_title := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_title_col_no).data_type,',
'                                p_value     => l_column_value_list(l_title_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_link_col_no is not null then',
'                l_link := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_link_col_no).data_type,',
'                                p_value     => l_column_value_list(l_link_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr1_lbl_col_no is not null then',
'                l_row1_attr1_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr1_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr1_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr1_val_col_no is not null then',
'                l_row1_attr1_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr1_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr1_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr2_lbl_col_no is not null then',
'                l_row1_attr2_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr2_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr2_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr2_val_col_no is not null then',
'                l_row1_attr2_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr2_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr2_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr1_lbl_col_no is not null then',
'                l_row2_attr1_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr1_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr1_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr1_val_col_no is not null then',
'                l_row2_attr1_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr1_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr1_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr2_lbl_col_no is not null then',
'                l_row2_attr2_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr2_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr2_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr2_val_col_no is not null then',
'                l_row2_attr2_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr2_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr2_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_1_col_no is not null then',
'                l_description_1 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_1_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_1_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_2_col_no is not null then',
'                l_description_2 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_2_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_2_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_3_col_no is not null then',
'                l_description_3 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_3_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_3_col_no).value_list(l_row_num) ),',
'                            false );',
'            end if;',
'',
'            -- Limit it down to the colors we support.',
'            l_color := initcap(l_color);',
'            if l_color not in (''Red'',''Black'',''Yellow'',''Green'') then',
'                l_color_hex := l_color;',
'                l_color     := '''';',
'            else',
'                l_color_hex := '''';',
'            end if;',
'',
'            if l_color = ''Red'' then',
'                l_color := ''is-error'';',
'            elsif l_color = ''Black'' then',
'                l_color := ''is-complete'';',
'            elsif l_color = ''Yellow'' then',
'                l_color := ''is-warning'';',
'            elsif l_color = ''Green'' then',
'                l_color := ''is-open'';',
'            end if;',
'',
'            -- Start of the actual rendering code.',
'',
'            if l_last_month != to_char(l_date,''YYYYMM'') then',
'                l_last_month := to_char(l_date,''YYYYMM'');',
'',
'                if l_count > 1 then',
'                    -- Not the first row; close the previous group.',
'                    sys.htp.p(''</ul></div>'');',
'                end if;',
'',
'                sys.htp.p(''<div class="a-StatusList-block">'');',
'                -- if to_char(l_date,''YYYY'') != l_this_year then',
'                sys.htp.p(''<h3 class="a-StatusList-blockHeader"><span class="a-StatusList-headerTextPrimary">''||trim(to_char(l_date,''Month''))||',
'                    ''</span><span class="a-StatusList-headerTextAlt">''||to_char(l_date,''YYYY'')||''</span></h3>'');',
'                l_this_year := to_char(l_date,''YYYY'');',
'                -- else',
'                    -- sys.htp.p(''<h3>''||to_char(l_date,''Month'')||''</h3>'');',
'                -- end if;',
'                sys.htp.p(''<ul class="a-StatusList-list">'');',
'            end if;',
'',
'            sys.htp.p(''<li class="a-StatusList-item ''||l_color||''"><div class="a-StatusList-itemMarker"><span class="a-StatusList-marker" role="presentation">''',
'                ||to_char(l_date,''fmDD'')||''</span></div>'');',
'            -- if l_color is not null then',
'                -- sys.htp.p(''<div class="status''||l_color||''">'');',
'            -- else',
'                -- sys.htp.p(''<div style="border-left-color: ''||l_color_hex||''">'');',
'            -- end if;',
'            sys.htp.p(''<div class="a-StatusList-itemBody">'');',
'            sys.htp.p(''<p class="a-StatusList-itemTitle"><a href="''||apex_util.prepare_url(l_link)||''">''||l_title||''</a></p>'');',
'',
'            if l_row1_attr1_lbl is not null or l_row1_attr1_val is not null',
'                    or l_row1_attr2_lbl is not null or l_row1_attr2_val is not null then',
'                sys.htp.prn(''<div class="a-StatusList-itemAttrs">'');',
'                if l_row1_attr1_lbl is not null and l_row1_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr1_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row1_attr1_val||''</span></span>'');',
'                elsif l_row1_attr1_lbl is null and l_row1_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row1_attr1_val||''</span></span>'');',
'                elsif l_row1_attr1_lbl is not null and l_row1_attr1_val is null then',
'                    sys.htp.prn(''<span><span class="a-StatusList-attrLabel">''||l_row1_attr1_lbl||''</span></span>'');',
'                else',
'                    -- No attr1.',
'                    null;',
'                end if;',
'',
'                if l_row1_attr2_lbl is not null and l_row1_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr2_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row1_attr2_val||''</span></span>'');',
'                elsif l_row1_attr2_lbl is null and l_row1_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row1_attr2_val||''</span></span>'');',
'                elsif l_row1_attr2_lbl is not null and l_row1_attr2_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr2_lbl||''</span></span>'');',
'                else',
'                    -- No attr2.',
'                    null;',
'                end if;',
'                -- sys.htp.prn(''</div>'');',
'            end if;',
'',
'            if l_row2_attr1_lbl is not null or l_row2_attr1_val is not null',
'                    or l_row2_attr2_lbl is not null or l_row2_attr2_val is not null then',
'                -- sys.htp.prn(''<p>'');',
'                if l_row2_attr1_lbl is not null and l_row2_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr1_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row2_attr1_val||''</span></span>'');',
'                elsif l_row2_attr1_lbl is null and l_row2_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row2_attr1_val||''</span></span>'');',
'                elsif l_row2_attr1_lbl is not null and l_row2_attr1_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr1_lbl||''</span></span>'');',
'                else',
'                    -- No attr3.',
'                    null;',
'                end if;',
'',
'                if l_row2_attr2_lbl is not null and l_row2_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr2_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row2_attr2_val||''</span></span>'');',
'                elsif l_row2_attr2_lbl is null and l_row2_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row2_attr2_val||''</span></span>'');',
'                elsif l_row2_attr2_lbl is not null and l_row2_attr2_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr2_lbl||''</span></span>'');',
'                else',
'                    -- No attr4.',
'                    null;',
'                end if;',
'                sys.htp.prn(''</div>'');',
'            end if;',
'',
'            if l_description_1 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_1||''</p>'');',
'            end if;',
'',
'            if l_description_2 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_2||''</p>'');',
'            end if;',
'',
'            if l_description_3 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_3||''</p>'');',
'            end if;',
'',
'            sys.htp.prn(''</div></li>'');',
'        end if;',
'    end loop;',
'    if l_count > 0 then',
'        -- Close the HTML.',
'        sys.htp.p(''</ul></div>'');',
'    else',
'        sys.htp.p(''<span class="nodatafound">''||l_no_data_found||''</span>'');',
'    end if;',
'    sys.htp.p(''</div>'');',
'end render_list_calendar;',
'',
'function render ( p_region in apex_plugin.t_region,',
'    p_plugin in apex_plugin.t_plugin, p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result is',
'begin',
'    render_list_calendar( p_region );',
'    return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render'
,p_standard_attributes=>'SOURCE_SQL:FETCHED_ROWS:NO_DATA_FOUND_MESSAGE:ESCAPE_OUTPUT'
,p_substitute_attributes=>true
,p_reference_id=>1517592169582192572.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
,p_files_version=>3
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396073891043383619.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Date column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'DATE:TIMESTAMP:TIMESTAMP_TZ:TIMESTAMP_LTZ'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396074282467383619.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Color column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396074605776383619.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Title column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396075016196383619.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Link column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396075429885383619.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'First Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396075877026383621.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'First Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396076209073383622.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Second Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396076606102383622.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Second Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396077103994383622.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Third Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396077425924383623.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Third Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396077848416383623.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Fourth Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396078237202383623.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Fourth Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
end;
/
begin
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396078564095383623.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'First Description column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396079002274383623.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Second Description column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2396079329774383623.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>150
,p_prompt=>'Third Description column (allows HTML)'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(849917626128293237.4605)
,p_plugin_id=>wwv_flow_api.id(1522394186038843824.4605)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>3
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_d3_barchart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.D3.BARCHART'
,p_display_name=>unistr('Gr\00E1fico de Barras D3 ***')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.D3.BARCHART'),'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.barchart/')
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/d3/3.3.11/d3.min.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3/d3.oracle.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3/oracle.jql.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3/jquery.getScrollbarWidth.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.tooltip/d3.oracle.tooltip.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.ary/d3.oracle.ary.js',
'#PLUGIN_FILES#d3.oracle.barchart.js',
'#PLUGIN_FILES#d3.oracle.barchart.apex.js',
'#PLUGIN_FILES#com.oracle.apex.d3.barchart.js'))
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.tooltip/d3.oracle.tooltip.css',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.ary/d3.oracle.ary.css',
'#PLUGIN_FILES#d3.oracle.barchart.css'))
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render ',
'(',
'    p_region                in  apex_plugin.t_region,',
'    p_plugin                in  apex_plugin.t_plugin,',
'    p_is_printer_friendly   in  boolean ',
')',
'return apex_plugin.t_region_render_result',
'is',
'    c_region_static_id      constant varchar2(255)  := apex_escape.html_attribute( p_region.static_id );',
'',
'-- Assign readable names to plugin attributes. Omit data attributes, they''ll be handled in ajax function.',
'    -- Dimensions',
'    c_height_mode           constant varchar2(200)  := p_region.attribute_21;',
'    c_min_height            constant number         := nvl(p_region.attribute_18, 100);',
'    c_max_height            constant number         := nvl(p_region.attribute_19, 500);',
'    c_spacing               constant number         := nvl(p_region.attribute_16, 20);',
'    c_inner_spacing         constant number         := nvl(p_region.attribute_17, 20);',
'',
'    -- Axis titles',
'    c_x_axis_title          constant varchar2(200)  := p_region.attribute_08;',
'    c_y_axis_title          constant varchar2(200)  := p_region.attribute_09;',
'',
'    -- Axis grid',
'    c_x_axis_grid           constant boolean        := instr('':'' || p_region.attribute_22 || '':'', '':X:'') > 0;',
'    c_y_axis_grid           constant boolean        := instr('':'' || p_region.attribute_22 || '':'', '':Y:'') > 0;',
'',
'    -- Tooltip configuration',
'    c_show_tooltip          constant boolean        := p_region.attribute_10 is not null;',
'    c_series_tooltip        constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':SERIES:'') > 0;',
'    c_x_tooltip             constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':X:'') > 0;',
'    c_y_tooltip             constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':Y:'') > 0;',
'    c_custom_tooltip        constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':CUSTOM:'') > 0;',
'',
'    -- Legend',
'    c_show_legend           constant boolean        := p_region.attribute_12 is not null;',
'    c_legend_position       constant varchar2(200)  := p_region.attribute_12;',
'',
'    -- Display modes',
'    c_value_template        constant varchar2(200)  := nvl(p_region.attribute_15, p_region.attribute_25);',
'    c_horizontal            constant boolean        := substr(p_region.attribute_06, 1, instr(p_region.attribute_06, '','') - 1) = ''HORIZONTAL'';',
'    c_display               constant varchar2(200)  := substr(p_region.attribute_06, instr(p_region.attribute_06, '','') + 1);',
'    c_responsive            constant boolean        := p_plugin.attribute_06 = ''Y'';',
'    c_transitions           constant boolean        := p_plugin.attribute_05 = ''Y'';',
'',
'    -- Colors',
'    c_color_scheme          constant varchar2(200)  := p_region.attribute_13;',
'    l_colors                varchar2(200)           := p_region.attribute_14;',
'    c_multiple_colors       constant boolean        := p_region.attribute_24 = ''Y'';',
'',
'    -- Aspect ratios',
'    c_min_ar                constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_plugin.attribute_02, ''Min Aspect Radio'' ), 1.333);',
'    c_max_ar                constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_plugin.attribute_01, ''Max Aspect Radio'' ), 3);',
'    c_threshold             constant number         := p_plugin.attribute_03;',
'    c_threshold_of          constant varchar2(200)  := p_plugin.attribute_04;',
'',
'    -- Function constants',
'    c_rgb_list_regex        constant varchar2(200)  := ''^#[0-9a-fA-F]{6}(,#[0-9a-fA-F]{6})*$'';',
'begin',
'    -- Add placeholder div',
'    sys.htp.p (',
'        ''<div class="a-D3BarChart" id="'' || c_region_static_id || ''_region">'' ||',
'            ''<div class="a-D3BarChart-container" id="'' || c_region_static_id || ''_chart"></div>'' ||',
'        ''</div>'' );',
'',
'',
'    -- Color scheme',
'    case c_color_scheme',
'        when ''MODERN'' then',
'            l_colors := ''#FF3B30:#FF9500:#FFCC00:#4CD964:#34AADC:#007AFF:#5856D6:#FF2D55:#8E8E93:#C7C7CC'';',
'        when ''MODERN2'' then',
'            l_colors := ''#1ABC9C:#2ECC71:#4AA3DF:#9B59B6:#3D566E:#F1C40F:#E67E22:#E74C3C'';',
'        when ''SOLAR'' then',
'            l_colors := ''#B58900:#CB4B16:#DC322F:#D33682:#6C71C4:#268BD2:#2AA198:#859900'';',
'        when ''METRO'' then',
'            l_colors := ''#E61400:#19A2DE:#319A31:#EF9608:#8CBE29:#A500FF:#00AAAD:#FF0094:#9C5100:#E671B5'';',
'        else',
'            null;',
'    end case;',
'',
'    -- Build the initial chart. Data will be loaded with ajax.',
'    apex_javascript.add_onload_code (',
'        p_code => ''com_oracle_apex_d3_barchart('' ||',
'            apex_javascript.add_value(p_region.static_id) ||',
'            ''{'' ||',
'                apex_javascript.add_attribute(''chartRegionId'',  p_region.static_id || ''_chart'') ||',
'                apex_javascript.add_attribute(''xAxisTitle'',     c_x_axis_title) || ',
'                apex_javascript.add_attribute(''yAxisTitle'',     c_y_axis_title) || ',
'                apex_javascript.add_attribute(''showTooltip'',    c_show_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipSeries'',  c_series_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipX'',       c_x_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipY'',       c_y_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipCustom'',  c_custom_tooltip) || ',
'                apex_javascript.add_attribute(''spacing'',        c_spacing) || ',
'                apex_javascript.add_attribute(''innerSpacing'',   c_inner_spacing) || ',
'                apex_javascript.add_attribute(''horizontal'',     c_horizontal) || ',
'                apex_javascript.add_attribute(''display'',        c_display) || ',
'                apex_javascript.add_attribute(''responsive'',     c_responsive) || ',
'                apex_javascript.add_attribute(''transitions'',    c_transitions) || ',
'                apex_javascript.add_attribute(''valueTemplate'',  c_value_template) || ',
'                apex_javascript.add_attribute(''showLegend'',     c_show_legend) || ',
'                apex_javascript.add_attribute(''legendPosition'', c_legend_position) || ',
'                apex_javascript.add_attribute(''colors'',         l_colors) || ',
'                apex_javascript.add_attribute(''xGrid'',          c_x_axis_grid) || ',
'                apex_javascript.add_attribute(''yGrid'',          c_y_axis_grid) || ',
'                apex_javascript.add_attribute(''multipleColors'', c_multiple_colors) || ',
'                apex_javascript.add_attribute(''heightMode'',     c_height_mode) || ',
'                apex_javascript.add_attribute(''minHeight'',      c_min_height) || ',
'                apex_javascript.add_attribute(''maxHeight'',      c_max_height) || ',
'                apex_javascript.add_attribute(''threshold'',      c_threshold) || ',
'                apex_javascript.add_attribute(''thresholdOf'',    c_threshold_of) || ',
'                apex_javascript.add_attribute(''minAR'',          c_min_ar) || ',
'                apex_javascript.add_attribute(''maxAR'',          c_max_ar) || ',
'                apex_javascript.add_attribute(''noDataFoundMessage'', p_region.no_data_found_message) || ',
'                apex_javascript.add_attribute(''pageItems'',      apex_plugin_util.page_item_names_to_jquery(p_region.ajax_items_to_submit)) ||',
'                apex_javascript.add_attribute(''ajaxIdentifier'', apex_plugin.get_ajax_identifier, false, false) ||',
'            ''});'' );',
'    return null;',
'end;',
'',
'function ajax',
'(',
'    p_region    in  apex_plugin.t_region,',
'    p_plugin    in  apex_plugin.t_plugin ',
')',
'return apex_plugin.t_region_ajax_result',
'is',
'    -- It''s better to have named variables instead of using the generic ones, ',
'    -- makes the code more readable. ',
'',
'    c_has_multiple_series   constant boolean := ( p_region.attribute_03 = ''Y'' );',
'',
'    -- Column names',
'    c_x_column              constant varchar2(255) := p_region.attribute_01;',
'    c_y_column              constant varchar2(255) := p_region.attribute_02;',
'    c_series_column         constant varchar2(255) := case when c_has_multiple_series then p_region.attribute_04 end;',
'    c_tooltip_column        constant varchar2(255) := p_region.attribute_11;',
'    c_link_target           constant varchar2(255) := p_region.attribute_20;',
'',
'    -- Series name, for single series configuration',
'    c_series_name           constant varchar2(200) := case when not c_has_multiple_series then p_region.attribute_05 end;',
'    c_use_sql_color         constant boolean       := p_region.attribute_13 = ''COLUMN'';',
'',
'    -- Column numbers for fetching',
'    l_x_column_no           pls_integer;',
'    l_y_column_no           pls_integer;',
'    l_series_column_no      pls_integer;',
'    l_tooltip_column_no     pls_integer;',
'    l_column_value_list     apex_plugin_util.t_column_value_list2;',
'',
'    -- Holders for row data',
'    l_x                     varchar2(200);',
'    l_y                     number;',
'    l_series                varchar2(4000);',
'    l_color                 varchar2(4000);',
'    l_tooltip               varchar2(4000);',
'    l_link                  varchar2(4000);',
'',
'begin',
'',
'    apex_json.initialize_output (',
'        p_http_cache => false );',
'',
'    apex_json.open_object;',
'',
'    -- First, we must get the color mapping if the color scheme requires it.',
'    if c_use_sql_color then',
'        l_column_value_list := apex_plugin_util.get_data2 (',
'            p_sql_statement     => p_region.attribute_23,',
'            p_min_columns       => 2,',
'            p_max_columns       => 2,',
'            p_component_name    => p_region.name );',
'',
'        apex_json.open_array(''colors'');',
'        for l_row_num in 1 .. l_column_value_list(1).value_list.count loop',
'            -- Series, optional',
'            l_series := apex_plugin_util.get_value_as_varchar2 (',
'                p_data_type => l_column_value_list(1).data_type,',
'                p_value     => l_column_value_list(1).value_list(l_row_num) );',
'            l_color := apex_plugin_util.get_value_as_varchar2 (',
'                p_data_type => l_column_value_list(2).data_type,',
'                p_value     => l_column_value_list(2).value_list(l_row_num) );',
'            ',
'            apex_json.open_object;',
'            apex_json.write(''series'', l_series);',
'            apex_json.write(''color'',  l_color);',
'            apex_json.close_object;',
'',
'        end loop;',
'        apex_json.close_array;',
'',
'        l_series := null;',
'    end if;',
'',
'    -- Then, we get the actual data points.',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'        p_sql_statement  => p_region.source,',
'        p_min_columns    => 2,',
'        p_max_columns    => 5,',
'        p_component_name => p_region.name );',
'',
'    -- Get the actual column # for faster access and also verify that the data type',
'    -- of the column matches with what we are looking for',
'    l_x_column_no := apex_plugin_util.get_column_no (',
'                p_attribute_label       => ''x column'',',
'                p_column_alias          => c_x_column,',
'                p_column_value_list     => l_column_value_list,',
'                p_is_required           => true,',
'                p_data_type             => apex_plugin_util.c_data_type_varchar2 );',
'',
'    l_y_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''y column'',',
'        p_column_alias          => c_y_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => true,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    l_series_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''series column'',',
'        p_column_alias          => c_series_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_varchar2 );',
'',
'    l_tooltip_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''tooltip column'',',
'        p_column_alias          => c_tooltip_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_varchar2 );',
'',
'    apex_json.open_array(''data'');',
'',
'    -- Fetch data',
'    for l_row_num in 1 .. l_column_value_list(1).value_list.count loop',
'        begin',
'            apex_plugin_util.set_component_values (',
'                p_column_value_list => l_column_value_list,',
'                p_row_num => l_row_num ',
'            );',
'',
'            -- X is a string, required',
'            if l_x_column_no is not null then',
'                l_x := apex_plugin_util.get_value_as_varchar2 (',
'                    p_data_type => l_column_value_list(l_x_column_no).data_type,',
'                    p_value     => l_column_value_list(l_x_column_no).value_list(l_row_num) );',
'            end if;',
'',
'            -- Y is a number, required',
'            l_y := l_column_value_list(l_y_column_no).value_list(l_row_num).number_value;',
'',
'            -- Series, optional',
'            if l_series_column_no is not null then',
'                l_series := apex_plugin_util.get_value_as_varchar2 (',
'                    p_data_type => l_column_value_list(l_series_column_no).data_type,',
'                    p_value     => l_column_value_list(l_series_column_no).value_list(l_row_num) );',
'            end if;',
'',
'            -- Tooltip, optional',
'            if l_tooltip_column_no is not null then',
'                l_tooltip := apex_plugin_util.get_value_as_varchar2 (',
'                    p_data_type => l_column_value_list(l_tooltip_column_no).data_type,',
'                    p_value     => l_column_value_list(l_tooltip_column_no).value_list(l_row_num) );',
'            end if;',
'',
'            -- Link, optional',
'            if c_link_target is not null then',
'                l_link := wwv_flow_utilities.prepare_url (',
'                    apex_plugin_util.replace_substitutions (',
'                        p_value  => c_link_target,',
'                        p_escape => false ) );',
'            end if;',
'',
'            apex_json.open_object;',
'            apex_json.write(''series'',  nvl(l_series, c_series_name));',
'            apex_json.write(''tooltip'', l_tooltip);',
'            apex_json.write(''link'',    l_link);',
'            apex_json.write(''x'',       l_x);',
'            apex_json.write(''y'',       l_y);',
'            apex_json.close_object;',
'',
'            apex_plugin_util.clear_component_values;',
'        exception when others then',
'            apex_plugin_util.clear_component_values;',
'            raise;',
'        end;',
'    end loop;',
'    apex_json.close_array;',
'    apex_json.close_object;',
'',
'    return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render'
,p_ajax_function=>'ajax'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT:NO_DATA_FOUND_MESSAGE'
,p_substitute_attributes=>false
,p_reference_id=>8312108105074277335.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'0.1'
,p_files_version=>58
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274187498679863686.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Max Aspect Ratio'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'3'
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The maximum aspect ratio that Flot line charts use to recommend a height. A max aspect ratio of 3 means that the chart''s width should be no greater than 3 times its height. It can be overridden by the ''Max Height'' setting on each region.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274187880613863686.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Min Aspect Ratio'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'1.333'
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The minimum aspect ratio that Flot line charts use to recommend a height. A min aspect ratio of 1.333 means that the chart''s width should be no less than 1.333 times its height. It can be overridden by the ''Min Height'' setting on each region.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274188226533863686.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Responsive Behavior Threshold'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'480'
,p_display_length=>5
,p_max_length=>5
,p_is_translatable=>false
,p_help_text=>'The threshold (in pixels) at which the responsive behavior will be activated.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274188651597863687.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Responsive Behavior Measure'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'WINDOW'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Whether the responsive behavior threshold will be compared to the window or the region''s width.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274189076979863687.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274188651597863687.4605)
,p_display_sequence=>10
,p_display_value=>'Window'
,p_return_value=>'WINDOW'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274189509944863687.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274188651597863687.4605)
,p_display_sequence=>20
,p_display_value=>'Region'
,p_return_value=>'REGION'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274190082405863688.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Enable Transitions'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274190422545863688.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>6
,p_display_sequence=>25
,p_prompt=>'Responsive Behavior'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274190890863863688.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'X Values Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'X'
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'The column of the region SQL query to use as X values.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274191263896863689.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Y Values Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'Y'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column of the region SQL query to use as Y values.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274191688574863689.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Multiple Series'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Enable multi-series functionality on the chart. If selected, you must select a column to use as a series identifier.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274192024660863689.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274191688574863689.4605)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274192534249863690.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Series Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'SERIES'
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(274191688574863689.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The column of the region SQL query to use as a series identifier. The values on this column will become the series'' names.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274192938174863690.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Series Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(274191688574863689.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
,p_help_text=>'The name of the single data series to be shown on the legend.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274193345639863690.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>2
,p_prompt=>'Display'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VERTICAL,SIDE-BY-SIDE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274193776328863690.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274193345639863690.4605)
,p_display_sequence=>10
,p_display_value=>'Vertical, Side by Side'
,p_return_value=>'VERTICAL,SIDE-BY-SIDE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274194214218863691.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274193345639863690.4605)
,p_display_sequence=>20
,p_display_value=>'Horizontal, Side by Side'
,p_return_value=>'HORIZONTAL,SIDE-BY-SIDE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274194723294863691.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274193345639863690.4605)
,p_display_sequence=>30
,p_display_value=>'Vertical, Stacked'
,p_return_value=>'VERTICAL,STACKED'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274195257453863691.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274193345639863690.4605)
,p_display_sequence=>40
,p_display_value=>'Horizontal, Stacked'
,p_return_value=>'HORIZONTAL,STACKED'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274195714696863692.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'X Axis Title'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_help_text=>'The label for the X axis.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274196148596863692.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Y Axis Title'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_help_text=>'The label for the Y axis.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274196517409863692.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Tooltips'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Customize what is shown on the tooltip for each data point. The ''Custom column'' option allows you to specify text for each individual data point as an additional column in the region SQL query. Leave all options unselected to disable the tooltips.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274196931579863693.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274196517409863692.4605)
,p_display_sequence=>0
,p_display_value=>'Show series name'
,p_return_value=>'SERIES'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274197471330863693.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274196517409863692.4605)
,p_display_sequence=>10
,p_display_value=>'Show X value'
,p_return_value=>'X'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274197843396863693.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274196517409863692.4605)
,p_display_sequence=>20
,p_display_value=>'Show Y value'
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274198350199863694.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274196517409863692.4605)
,p_display_sequence=>30
,p_display_value=>'Custom column'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274198891721863694.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Tooltip Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(274196517409863692.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'SERIES:X:Y:CUSTOM,SERIES:X:CUSTOM,SERIES:Y:CUSTOM,X:Y:CUSTOM,SERIES:CUSTOM,X:CUSTOM,Y:CUSTOM,CUSTOM'
,p_help_text=>'The column of the region SQL query to use as custom tooltip values.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274199223629863694.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Legend'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_default_value=>'TOP'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_null_text=>'None'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274199644085863694.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274199223629863694.4605)
,p_display_sequence=>10
,p_display_value=>'Above chart'
,p_return_value=>'TOP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274200142780863695.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274199223629863694.4605)
,p_display_sequence=>20
,p_display_value=>'Below chart'
,p_return_value=>'BOTTOM'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274200634393863695.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'MODERN'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_null_text=>'Theme Default'
,p_help_text=>'The color scheme used to render the chart. A different color will be assigned to each series.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274201037097863695.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274200634393863695.4605)
,p_display_sequence=>10
,p_display_value=>'Modern'
,p_return_value=>'MODERN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274201554412863696.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274200634393863695.4605)
,p_display_sequence=>20
,p_display_value=>'Modern 2'
,p_return_value=>'MODERN2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274202059702863696.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274200634393863695.4605)
,p_display_sequence=>30
,p_display_value=>'Solar'
,p_return_value=>'SOLAR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274202569183863696.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274200634393863695.4605)
,p_display_sequence=>40
,p_display_value=>'Metro'
,p_return_value=>'METRO'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274203083837863697.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274200634393863695.4605)
,p_display_sequence=>50
,p_display_value=>'Custom'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274203583452863697.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274200634393863695.4605)
,p_display_sequence=>60
,p_display_value=>'SQL Query'
,p_return_value=>'COLUMN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274204059630863697.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Colors'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(274200634393863695.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'A colon-separated list of color strings (e.g. #FF3377, rgba(0,25,47,0.5), blue) to use as a color scheme for the chart.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274204446847863698.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>60
,p_prompt=>'Custom Value Formatting'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'FRIENDLY'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'<li><b>,d</b> = 14,435</li>',
'<li><b>d</b> = 14435</li>',
'<li><b>,.2f</b> = 14,435.49</li>',
'<li><b>.2f</b> = 14435.49</li>',
'<li><b>.3s</b> = 14.4k</li>',
'<li><b>$,d</b> = $14,435</li>',
'<li><b>$d</b> = $14435</li>',
'<li><b>$,.2f</b> = $14,435.49</li>',
'<li><b>$.2f</b> = $14435.49</li>',
'<li><b>$.3s</b> = $14.4k</li>',
'<li><b>n" ft."</b> = 14435.49 ft. **</li>',
'<li><b>"[["$.3s"]]"</b> = [[$14.4k]] **</li>',
'<li>Refer to https://github.com/mbostock/d3/wiki/Formatting#d3_format for the full syntax specification</li>',
'</ul>',
'<br/>',
'** You may use leading and trailing double-quoted literals, but this feature is not part of the standard D3 specification'))
,p_help_text=>'The D3 format string used to format the "Y" values on axes, tooltips and legends. Write "FRIENDLY" to use sensible formatting defaults for your data.'
);
end;
/
begin
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274204864088863698.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>61
,p_prompt=>'Spacing Between Categories'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'10'
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The spacing between categories, expressed as an integer percentage (1-100).'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274205270272863698.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>62
,p_prompt=>'Spacing Between Series'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'10'
,p_display_length=>5
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(274191688574863689.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NOT_NULL'
,p_help_text=>'This spacing applies between bars of different series on the same category (X value). It is represented as an integer percentage (0-100). Affects only "Side by Side" display modes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274205629225863699.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>1
,p_prompt=>'Min Height'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The minimum height, in pixels, of the chart. Chart width will adapt to the size of the region. Defaults to 100px.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274206047178863699.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>2
,p_prompt=>'Max Height'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The maximum height, in pixels, of the chart. Chart width will adapt to the size of the region. Defaults to 500px.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274206407436863699.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>115
,p_prompt=>'Link Target'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274206847162863699.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>21
,p_display_sequence=>0
,p_prompt=>'Height Measure'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BARS'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274207232993863701.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274206847162863699.4605)
,p_display_sequence=>10
,p_display_value=>'Bars Area'
,p_return_value=>'BARS'
,p_help_text=>'Min and max height for the area where the bars are drawn. Axis labels may take additional space.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274207706455863701.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274206847162863699.4605)
,p_display_sequence=>20
,p_display_value=>'Chart Area'
,p_return_value=>'CHART'
,p_help_text=>'Min and max height will include the axes'' dimensions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274208247308863701.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>22
,p_display_sequence=>220
,p_prompt=>'Show Grid Lines'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274208662989863702.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274208247308863701.4605)
,p_display_sequence=>10
,p_display_value=>'X Axis'
,p_return_value=>'X'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274209204044863703.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274208247308863701.4605)
,p_display_sequence=>20
,p_display_value=>'Y Axis'
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274209627573863703.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>23
,p_display_sequence=>230
,p_prompt=>'Color SQL Query'
,p_attribute_type=>'SQL'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(274200634393863695.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'COLUMN'
,p_help_text=>'A SQL query that maps a series name to an RGB color. The first column must contain the series names (and those values must match the ones returned from the region SQL) and the second column must have the RGB color for the series. Both columns must be'
||' VARCHAR2.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274210052379863703.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>24
,p_display_sequence=>60
,p_prompt=>'Multiple Colors'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(274191688574863689.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(274210433601863703.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>25
,p_display_sequence=>59
,p_prompt=>'Value Formatting'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'.3s'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_null_text=>'Custom'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274210892570863704.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_display_sequence=>30
,p_display_value=>'14,435'
,p_return_value=>',.0f'
,p_help_text=>'Comma-separated thousands, integers'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274211371588863704.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_display_sequence=>40
,p_display_value=>'14435'
,p_return_value=>'.0f'
,p_help_text=>'Integer'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274211864617863704.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_display_sequence=>60
,p_display_value=>'14,435.49'
,p_return_value=>',.2f'
,p_help_text=>'Comma-separated thousands, 2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274212399429863705.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_display_sequence=>70
,p_display_value=>'14435.49'
,p_return_value=>'.2f'
,p_help_text=>'2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274212861487863705.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_display_sequence=>71
,p_display_value=>'14.4k'
,p_return_value=>'.3s'
,p_help_text=>'Precision 3, SI suffixes'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274213333592863705.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_display_sequence=>80
,p_display_value=>'$14,435'
,p_return_value=>'$,.0f'
,p_help_text=>'Currency, comma-separated thousands, integer'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274213896415863706.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_display_sequence=>90
,p_display_value=>'$14435'
,p_return_value=>'$.0f'
,p_help_text=>'Currency, integer'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274214323388863706.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_display_sequence=>99
,p_display_value=>'$14,435.49'
,p_return_value=>'$,.2f'
,p_help_text=>'Currency, comma-separated thousands, 2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274214820355863706.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_display_sequence=>100
,p_display_value=>'$14435.49'
,p_return_value=>'$.2f'
,p_help_text=>'Currency, 2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(274215376243863707.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(274210433601863703.4605)
,p_display_sequence=>120
,p_display_value=>'$14.4k'
,p_return_value=>'$.3s'
,p_help_text=>'Currency, precison 3, SI suffixes'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(849917776848293239.4605)
,p_plugin_id=>wwv_flow_api.id(1549486640099764618.4605)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>2
,p_sql_max_column_count=>5
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_css_bar_chart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1814800064819674152.4605)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.CSS_BAR_CHART'
,p_display_name=>unistr('Gr\00E1fico de Barras CSS')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.CSS_BAR_CHART'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'procedure render_bar_chart (',
'    p_region in apex_plugin.t_region )',
'is',
'    -- constants for the columns of our region source query',
'    c_label_col constant pls_integer := 1;',
'    c_value_col constant pls_integer := 2;',
'    c_url_col   constant pls_integer := 3;',
'    c_color_col constant pls_integer := 4;',
'',
'    -- attributes of the plug-in',
'    l_display_as           varchar2(20)    := nvl(p_region.attribute_01, ''VALUE_ABSOLUTE'');',
'    l_value_prefix         varchar2(40)    := p_region.attribute_02;',
'    l_value_postfix        varchar2(40)    := p_region.attribute_03;',
'    -- page items to submit = p_region.attribute_09',
'    l_max_rows             number          := to_number(p_region.attribute_10);',
'    l_region_source        varchar2(32767) := p_region.source;',
'',
'    l_valid_data_type_list wwv_flow_global.vc_arr2;',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_max_value            number;',
'    l_total_value          number;',
'    l_label                varchar2(4000);',
'    l_value                number;',
'    l_url                  varchar2(4000);',
'    l_color                varchar2(4000);',
'    l_width                number;',
'    l_display_value        varchar2(4000);',
'begin',
'',
'    -- if percentage is displayed then the value will always have % as postfix',
'    if l_display_as like ''PERCENTAGE%'' then',
'        l_value_postfix := '' %'';',
'    end if;',
'',
'    -- define the valid column data types for the region query',
'    l_valid_data_type_list(c_label_col) := apex_plugin_util.c_data_type_varchar2;',
'    l_valid_data_type_list(c_value_col) := apex_plugin_util.c_data_type_number;',
'    l_valid_data_type_list(c_url_col)   := apex_plugin_util.c_data_type_varchar2;',
'    l_valid_data_type_list(c_color_col) := apex_plugin_util.c_data_type_varchar2;',
'',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => l_region_source,',
'                               p_min_columns    => 2,',
'                               p_max_columns    => 4,',
'                               p_data_type_list => l_valid_data_type_list,',
'                               p_component_name => p_region.name,',
'                               p_max_rows       => l_max_rows );',
'',
'    -- calculate the total or max value depending on "Display As"',
'    -- We could rewrite the region query with SUM(xxx) over ()',
'    -- but that would require that we know how the columns are named in the query.',
'    -- That''s why we just do a simple loop of the tiny array to get the',
'    -- total/max value which is probably faster anyway',
'    if l_display_as like ''%RELATIVE'' then',
'        l_total_value := 0;',
'        for i in 1 .. l_column_value_list(c_value_col).value_list.count loop',
'            -- $$$ what should we do if VALUE is NULL??? Set l_total_value to NULL as well?',
'            l_total_value := l_total_value + l_column_value_list(c_value_col).value_list(i).number_value;',
'        end loop;',
'    else',
'        l_max_value := 0;',
'        for i in 1 .. l_column_value_list(c_value_col).value_list.count loop',
'            -- $$$ what should we do if VALUE is NULL??? Set l_max_value to NULL as well?',
'            if l_column_value_list(c_value_col).value_list(i).number_value > l_max_value then',
'                l_max_value := l_column_value_list(c_value_col).value_list(i).number_value;',
'            end if;',
'        end loop;',
'    end if;',
'',
'    -- print our bar chart',
'    sys.htp.p(''<table class="cbc" border="0" cellspacing="0" cellpadding="0" ''||wwv_flow_utilities.get_layout_table_attributes||''>'');',
'',
'    for i in 1 .. l_column_value_list(c_label_col).value_list.count loop',
'        l_label := sys.htf.escape_sc(l_column_value_list(c_label_col).value_list(i).varchar2_value);',
'        l_value := l_column_value_list(c_value_col).value_list(i).number_value;',
'',
'        -- get the value of the URL and color only if the column exists in the SQL statement',
'        if l_column_value_list.exists(c_url_col) then',
'            l_url := wwv_flow_utilities.prepare_url (',
'                         apex_application.do_substitutions (',
'                             l_column_value_list(c_url_col).value_list(i).varchar2_value ));',
'        end if;',
'        if l_column_value_list.exists(c_color_col) then',
'            l_color := lower(l_column_value_list(c_color_col).value_list(i).varchar2_value);',
'            -- map a few of the standard colors to better looking ones',
'            l_color := case l_color',
'                         when ''red''     then ''#e10''',
'                         when ''yellow''  then ''#fd0''',
'                         when ''green''   then ''#0c0''',
'                         when ''black''   then ''#555''',
'                         when ''default'' then ''#ddd''',
'                         else l_color',
'                       end;',
'        end if;',
'',
'        -- calculate how long the chart bar should be',
'        if l_display_as like ''%RELATIVE'' then',
'            if l_total_value = 0 then',
'                l_width := 0;',
'            else',
'                l_width := round(l_value * 100 / l_total_value);',
'            end if;',
'        else',
'            if l_max_value = 0 then',
'                l_width := 0;',
'            else',
'                l_width := round(l_value * 100 / l_max_value);',
'            end if;',
'        end if;',
'',
'        if l_display_as like ''PERCENTAGE%'' then',
'            l_value := l_width;',
'        end if;',
'',
'        l_display_value := case when l_value_prefix is not null then l_value_prefix||'' '' end||',
'                           trim(to_char(l_value, ''999G999G999G990''))||',
'                           case when l_value_postfix is not null then '' ''||l_value_postfix end;',
'',
'        sys.htp.p(''<tr>'');',
'',
'        -- print label column and add link if an URL has been specified in the SQL statement',
'        -- otherwise just print the label',
'        sys.htp.p(''<td class="label"><span class="cbc_label">'');',
'        if l_url is not null then',
'            sys.htp.p(''<a href="''||l_url||''">''||l_label||''</a>'');',
'        else',
'            sys.htp.p(l_label);',
'        end if;',
'        sys.htp.p(''</span></td>'');',
'',
'        -- print chart bar',
'        sys.htp.p(''<td>'');',
'        sys.htp.p(''<span class="cbc_bar_background">'');',
'',
'        -- add link if an URL has been specified in the SQL statement otherwise just print the value',
'        if l_url is not null then',
'            sys.htp.p(''<span class="cbc_value"><a href="''||l_url||''">''||l_display_value||''</a></span>'');',
'        else',
'            sys.htp.p(''<span class="cbc_value">''||l_display_value||''</span>'');',
'        end if;',
'        ',
'        sys.htp.p (',
'            ''<span class="cbc_bar" style="width:''||l_width||''%;''||',
'            case when l_color is not null then ''background-color:''||l_color end||',
'            ''"></span>'' );',
'        sys.htp.p(''</span>'');',
'        sys.htp.p(''</td>'');',
'',
'        sys.htp.p(''</tr>'');',
'    end loop;',
'',
'    sys.htp.p(''</table>'');',
'end render_bar_chart;',
'',
'',
'function render (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result',
'is',
'    l_page_items_to_submit varchar2(4000)  := p_region.attribute_09;',
'begin',
'    apex_css.add_file (',
'        p_name      => ''css_bar_chart'',',
'        p_directory => p_plugin.file_prefix,',
'        p_version   => null );',
'',
'    sys.htp.p (''',
'<!--[if IE]> ',
'<style type="text/css" media="screen">',
'.cbc .cbc_bar_background {',
'  background-color: #FFF;',
'  border: 1px solid #AAA;',
'}',
'.cbc .cbc_value {',
'  color: #000;',
'  border-right: 1px solid #AAA;',
'}',
'.cbc .cbc_value a {',
'  color: #000;',
'}',
'.cbc .cbc_value a:hover {',
'  text-decoration: underline',
'}',
'</style>',
'<![endif]-->'');',
'',
'    -- print our region data',
'    sys.htp.p(''<div id="''||p_region.static_id||''_chart" class="cbc">'');',
'',
'    render_bar_chart (',
'        p_region => p_region );',
'',
'    sys.htp.p(''</div>'');',
'',
'    apex_javascript.add_library (',
'        p_name      => ''com_oracle_apex_css_bar_chart'',',
'        p_directory => p_plugin.file_prefix,',
'        p_version   => null );',
'',
'    apex_javascript.add_onload_code (',
'        p_code => ''com_oracle_apex_css_bar_chart(''||',
'                      apex_javascript.add_value(p_region.static_id)||',
'                      ''{''||',
'                      apex_javascript.add_attribute(''pageItemsToSubmit'', apex_plugin_util.page_item_names_to_jquery(l_page_items_to_submit))||',
'                      apex_javascript.add_attribute(''ajaxIdentifier'',    apex_plugin.get_ajax_identifier, false, false)||',
'                      ''});'' );',
'',
'    return null;',
'end render;',
'',
'function ajax (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin )',
'    return apex_plugin.t_region_ajax_result',
'is',
'begin',
'    sys.owa_util.mime_header(''text/html'', false);',
'    sys.htp.p(''Cache-Control: no-cache'');',
'    sys.htp.p(''Pragma: no-cache'');',
'    sys.owa_util.http_header_close;',
'',
'    render_bar_chart (',
'        p_region => p_region );',
'',
'    return null;',
'exception when others then',
'    sys.htp.p(''Error: ''||sqlerrm);',
'end ajax;'))
,p_api_version=>1
,p_render_function=>'render'
,p_ajax_function=>'ajax'
,p_standard_attributes=>'SOURCE_SQL'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'0.9'
,p_about_url=>'http://apex.oracle.com/plugins'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1814800377633677869.4605)
,p_plugin_id=>wwv_flow_api.id(1814800064819674152.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Display As'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VALUE_ABSOLUTE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(916691851992243748.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1814800377633677869.4605)
,p_display_sequence=>1
,p_display_value=>'Percentage with absolute bar width'
,p_return_value=>'PERCENTAGE_ABSOLUT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(916692365844247795.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1814800377633677869.4605)
,p_display_sequence=>1
,p_display_value=>'Percentage with relative bar width'
,p_return_value=>'PERCENTAGE_RELATIVE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(916692941041250021.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1814800377633677869.4605)
,p_display_sequence=>1
,p_display_value=>'Value with absolute bar width'
,p_return_value=>'VALUE_ABSOLUTE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(916693447967252007.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(1814800377633677869.4605)
,p_display_sequence=>1
,p_display_value=>'Value with relative bar width'
,p_return_value=>'VALUE_RELATIVE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1814800856639681262.4605)
,p_plugin_id=>wwv_flow_api.id(1814800064819674152.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Prefix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>10
,p_max_length=>40
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1814800377633677869.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE_ABSOLUTE,VALUE_RELATIVE'
,p_help_text=>'Specify the prefix which should be added to the displayed value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1814801363565683335.4605)
,p_plugin_id=>wwv_flow_api.id(1814800064819674152.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Postfix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>10
,p_max_length=>40
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1814800377633677869.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE_ABSOLUTE,VALUE_RELATIVE'
,p_help_text=>'Specify the postfix which should be added to the displayed value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(916696261042274738.4605)
,p_plugin_id=>wwv_flow_api.id(1814800064819674152.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Page Items to Submit'
,p_attribute_type=>'PAGE ITEMS'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Specify a comma separated list of page items that will be submitted to the server and thus, available for use from within your region source SQL statement.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1814801980534688192.4605)
,p_plugin_id=>wwv_flow_api.id(1814800064819674152.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Maximum Rows'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'5'
,p_display_length=>3
,p_max_length=>3
,p_is_translatable=>false
,p_help_text=>'Defines the maximum number of rows to query and to display.'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(849917830186293241.4605)
,p_plugin_id=>wwv_flow_api.id(1814800064819674152.4605)
,p_name=>'SOURCE_SQL'
,p_is_required=>false
,p_sql_min_column_count=>2
,p_sql_max_column_count=>4
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The region source has to be in the following format:',
'<pre>',
'select label,',
'       value,',
'       [link,]',
'       [color]',
'  from table',
' order by value',
'</pre>',
'<ul>',
'<li><strong>Label</strong> is the label ...</li>',
'<li><strong>Value</strong> is the value ... and has to be of type NUMBER</li>',
'<li><strong>Link</strong> is optional and can allow a user to navigate to another page within the application or a provided URL, and is activated by clicking on the chart bar of the record.</li>',
'<li><strong>Color</strong> is optional and is the background color of the chart bar for the record. The color is a hex value (for example #ff0000) or one of the standard web colors like red, green, ...</li>',
'</ul>',
'<h5>Example with a link column</h5>',
'<pre>',
'select ename,',
'       sal,',
'       ''f?p=&APP_ID.:300:''||:APP_SESSION||''::::P300_EMPNO:''||empno as link',
'  from emp',
' order by sal desc',
'</pre>'))
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_tag_cloud
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1821820281896950874.4605)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.TAG_CLOUD'
,p_display_name=>'Tag Cloud 2'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.TAG_CLOUD'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result',
'is',
'    -- Constants for the columns of our region source query',
'    c_tag_col   constant pls_integer := 1;',
'    c_count_col constant pls_integer := 2;',
'',
'    -- attributes of the plug-in',
'    l_target_url           varchar2(4000)  := p_region.attribute_01;',
'    l_max_display_tags     number          := p_region.attribute_02;',
'    l_show_count           boolean         := nvl(p_region.attribute_03,''Y'') = ''Y'';',
'',
'',
'    l_valid_data_type_list wwv_flow_global.vc_arr2;',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_printed_records    number := 0;',
'    l_available_records  number := 20;',
'    l_max                number;',
'    l_min                number;',
'    l_total              number := 0;',
'    l_cnts               number;',
'    l_tag                varchar2(4000);',
'',
'    l_class_size         number;',
'    l_class              varchar2(30);',
'',
'begin',
'    -- don''t need to load css file, styles are contained within theme_42',
'    ',
'    -- apex_css.add_file (',
'    --     p_name      => ''tag_cloud'',',
'    --     p_directory => p_plugin.file_prefix,',
'    --     p_version   => null );',
'',
'',
'    -- define the valid column data types for the region query',
'    l_valid_data_type_list(c_tag_col) := apex_plugin_util.c_data_type_varchar2;',
'    l_valid_data_type_list(c_count_col) := apex_plugin_util.c_data_type_number;',
'',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => p_region.source,',
'                               p_min_columns    => 2,',
'                               p_max_columns    => 2,',
'                               p_data_type_list => l_valid_data_type_list,',
'                               p_component_name => p_region.name );',
'',
'   l_available_records := l_column_value_list(c_tag_col).value_list.count;',
'',
'   -----------------------------------------------',
'   -- Determine total count and maximum tag counts',
'   --',
'   l_max := 0;',
'   l_min := 1000;',
'   FOR i in 1.. l_column_value_list(c_count_col).value_list.count loop',
'      l_cnts := l_column_value_list(c_count_col).value_list(i).number_value;',
'      l_total := l_total + l_cnts;',
'      if l_cnts > l_max then',
'         l_max := l_cnts;',
'      end if;',
'      if l_cnts < l_min then',
'         l_min := l_cnts;',
'      end if;',
'   end loop;',
'   if l_max = 0 then l_max := 1; end if;',
'',
'',
'   l_class_size := round((l_max-l_min)/6);',
'',
'   ------------------------',
'   -- Generate tag cloud --',
'   --',
'   ',
'   sys.htp.prn(''<ul class="a-TagCloud">'');',
'',
'   for i in 1.. l_column_value_list(c_tag_col).value_list.count loop',
'       l_printed_records := l_printed_records + 1;',
'       l_tag := sys.htf.escape_sc(l_column_value_list(c_tag_col).value_list(i).varchar2_value);',
'       l_cnts := l_column_value_list(c_count_col).value_list(i).number_value;',
'       if l_cnts < l_min + l_class_size then',
'          l_class := ''size1'';',
'       elsif l_cnts < l_min + (l_class_size*2) then',
'          l_class := ''size2'';',
'       elsif l_cnts < l_min + (l_class_size*3) then',
'          l_class := ''size3'';',
'       elsif l_cnts < l_min + (l_class_size*4) then',
'          l_class := ''size4'';',
'       elsif l_cnts < l_min + (l_class_size*5) then',
'          l_class := ''size5'';',
'       else l_class := ''size6'';',
'       end if;      ',
'       ',
'        sys.htp.prn(''<li class="a-TagCloud-item">''',
'            ||apex_plugin_util.get_link(',
'                p_url  => replace(l_target_url,''#TAG#'',l_tag),',
'                p_text => l_tag',
'                            ||case when l_show_count then',
'                                '' <span class="a-TagCloud-count">''||l_cnts||''</span>''',
'                            end,',
'                p_escape_text => false,',
'                p_attributes => ''class="a-TagCloud-link a-TagCloud-link--''',
'                    ||l_class||''"'')',
'            ||''</li>'');',
'',
'       if  l_printed_records > l_max_display_tags then',
'           exit;',
'       end if;',
'   end loop;',
'',
'   sys.htp.prn(''</ul>'');',
'',
'   return null;',
'end render;'))
,p_api_version=>1
,p_render_function=>'render'
,p_standard_attributes=>'SOURCE_SQL'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1821852462681983135.4605)
,p_plugin_id=>wwv_flow_api.id(1821820281896950874.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Target URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:2:&APP_SESSION.::::P2_FILTER:#TAG#'
,p_display_length=>60
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1821853862466992590.4605)
,p_plugin_id=>wwv_flow_api.id(1821820281896950874.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Maximum Displayed Tags'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>4
,p_max_length=>4
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1821854673201995705.4605)
,p_plugin_id=>wwv_flow_api.id(1821820281896950874.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Show Count'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(849917909106293242.4605)
,p_plugin_id=>wwv_flow_api.id(1821820281896950874.4605)
,p_name=>'SOURCE_SQL'
,p_is_required=>false
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2080239482051425991.4605)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>unistr('Adicionar caixa de sele\00E7\00E3o Marcar todas')
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512.4605
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>A a\00E7\00E3o din\00E2mica "Adicionar caixa de sele\00E7\00E3o Marcar todas" transforma um cabe\00E7alho de coluna que cont\00E9m a string #CHECK_ALL_CHECKBOX# em uma caixa de sele\00E7\00E3o Marcar todas acess\00EDvel, que marcar\00E1 ou desmarcar\00E1 todas as caixas de sele\00E7\00E3o na sua coluna')
||' correspondente.<p>',
'<p>',
unistr('Para usar este plug-in, verifique se os atributos a seguir est\00E3o definidos:'),
'<ol>',
unistr('<li>Na coluna de relat\00F3rios, defina ''#CHECK_ALL_CHECKBOX#'' como o valor do Cabe\00E7alho.</li>'),
unistr('<li>Para o atributo When da A\00E7\00E3o Din\00E2mica, selecione a regi\00E3o do relat\00F3rio que cont\00E9m a coluna.</li>'),
unistr('<li>Defina a A\00E7\00E3o Din\00E2mica para acionar ''Ap\00F3s Atualiza\00E7\00E3o'', e a A\00E7\00E3o para ''Carga de Acionamento da P\00E1gina''. (Ambas ser\00E3o definidas como padr\00E3o apropriadamente se a A\00E7\00E3o Din\00E2mica for criada selecionando a regi\00E3o na se\00E7\00E3o ''Renderiza\00E7\00E3o'' do Designer de ')
||unistr('p\00E1ginas e criando a A\00E7\00E3o Din\00E2mica nela.</li>'),
unistr('<li>Isso n\00E3o tratar\00E1 a acessibilidade das caixas de sele\00E7\00E3o renderizadas em cada linha. Isso deve ser feito separadamente na origem da regi\00E3o. (Consulte a regi\00E3o 4000:656 ''Regions'' para ver um exemplo).</li>'),
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_raphael_justgage
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.RAPHAEL.JUSTGAGE'
,p_display_name=>'Gauge JustGage ***'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.RAPHAEL.JUSTGAGE'),'#IMAGE_PREFIX#plugins/com.oracle.apex.raphael.justgage/1.0/')
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#PLUGIN_FILES#plugin.js',
'#PLUGIN_FILES#justgage.js',
'#IMAGE_PREFIX#libraries/raphaeljs/2.1.2/apex.raphael.min.js'))
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render ',
'(',
'    p_region                in  apex_plugin.t_region,',
'    p_plugin                in  apex_plugin.t_plugin,',
'    p_is_printer_friendly   in  boolean ',
')',
'return apex_plugin.t_region_render_result',
'is',
'    -- Assign readable names to plugin attributes. Omit data attributes, they''ll be handled in ajax function.',
'    -- Label configuration',
'    c_show_labels           constant boolean        := p_region.attribute_04 = ''Y'';',
'    l_title                 varchar(200)            := nvl(p_region.attribute_05, '''');',
'    l_units                 varchar(200)            := nvl(p_region.attribute_06, '''');',
'    l_value_prefix          varchar(200)            := nvl(p_region.attribute_07, '''');',
'    l_value_suffix          varchar(200)            := nvl(p_region.attribute_08, '''');',
'    l_show_min_max          boolean                 := nvl(p_region.attribute_09, ''N'') = ''Y'';',
'    c_description_template  constant varchar(2000)  := apex_plugin_util.replace_substitutions(',
'                                                           nvl(p_region.attribute_20, ''''));',
'    l_heading               varchar(200)            := apex_plugin_util.replace_substitutions(',
'                                                           nvl(p_region.attribute_21, ''''));',
'',
'    -- Shadow configuration',
'    c_show_shadow           constant boolean        := nvl(p_region.attribute_10, ''N'') = ''Y'';',
'    c_shadow_opacity        constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_region.attribute_11, ''Shadow Opacity'' ), 0 );',
'    c_shadow_offset         constant number         := to_number(nvl(p_region.attribute_12, 0));',
'',
'    -- Gauge configuration',
'    c_gauge_width           constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_region.attribute_13, ''Gauge Width Scale'' ), 1 );',
'    c_gauge_color_scheme    constant varchar(200)   := p_region.attribute_14;',
'    l_gauge_colors          varchar(200)            := p_region.attribute_15;',
'    l_gauge_bg_color        varchar(200)            := p_region.attribute_16;',
'    c_gauge_mode            constant varchar(200)   := p_region.attribute_17;',
'    c_width                 constant number         := p_region.attribute_18;',
'    c_height                constant number         := p_region.attribute_19;',
'    c_decimals              constant number         := greatest(nvl(p_region.attribute_24, 0), 0);',
'    l_width_style           varchar(200)            := '''';',
'    l_height_style          varchar(200)            := '''';',
'',
'    -- Function constants',
'    c_rgb_single_regex      constant varchar2(200)  := ''^#[0-9a-fA-F]{6}$'';',
'    c_rgb_list_regex        constant varchar2(200)  := ''^#[0-9a-fA-F]{6}(,#[0-9a-fA-F]{6})*$'';',
'begin',
'    -- Size style settings',
'    if c_width is not null then ',
'        l_width_style := ''width:'' || c_width || ''px;'';',
'    end if;',
'    if c_height is not null then ',
'        l_height_style := ''height:'' || c_height || ''px;'';',
'    end if;',
'',
'    -- Add placeholder div',
'    sys.htp.p (',
'        ''<div class="a-BadgeChart a-BadgeChart--justGage" id="'' || p_region.static_id || ''_container">'' ||',
'            ''<div class="a-JustGage-desc"></div>'' ||',
'            ''<div id="'' || p_region.static_id || ''_gauge" class="a-JustGage-chart" style="'' || l_width_style || l_height_style || ''"></div>'' ||',
'            ''<div class="a-BadgeChart-text">'' ||',
'                ''<span class="a-BadgeChart-label"></span>'' ||',
'                ''<span class="a-BadgeChart-desc"></span>'' ||',
'            ''</div>'' ||',
'        ''</div>'');',
'',
'    -- Labels defaults',
'    if not c_show_labels then',
'        l_title := '''';',
'        l_units := '''';',
'        l_value_prefix := '''';',
'        l_value_suffix := '''';',
'        l_show_min_max := false;',
'    end if;',
'',
'    -- Donut mode has no min/max value labels',
'    l_show_min_max := l_show_min_max and c_gauge_mode <> ''donut'';',
'',
'    -- Validate shadow configuration',
'    if c_show_shadow then',
'        if c_shadow_opacity < 0 or c_shadow_opacity > 1 then',
'            -- invalid option',
'            null;',
'        end if; ',
'    end if;',
'',
'    -- Validate gauge configuration',
'    if c_gauge_width <= 0 then',
'        -- invalid option',
'        null;',
'    end if;',
'    case c_gauge_color_scheme',
'        when ''GTR'' then',
'            l_gauge_colors := ''#56bd0d,#f0dc05,#f52900'';',
'        when ''RTG'' then',
'            l_gauge_colors := ''#f52900,#f0dc05,#56bd0d'';',
'        else',
'            l_gauge_colors := replace(l_gauge_colors, '' '', '''');',
'            if not regexp_like(l_gauge_colors, c_rgb_list_regex) then',
'                -- invalid option',
'                null;',
'            end if;',
'    end case;',
'    l_gauge_bg_color := replace(l_gauge_bg_color, '' '', '''');',
'    if not regexp_like(l_gauge_bg_color, c_rgb_single_regex) then',
'        -- invalid option',
'        null;',
'    end if;',
'',
'    -- Build the initial chart. Data will be loaded with ajax.',
'    apex_javascript.add_onload_code (',
'        p_code => ''com_oracle_apex_raphael_justgage('' ||',
'            apex_javascript.add_value(p_region.static_id) ||',
'            ''{'' ||',
'                apex_javascript.add_attribute(''regionId'',       p_region.static_id || ''_gauge'') || ',
'                apex_javascript.add_attribute(''title'',          l_title) || ',
'                apex_javascript.add_attribute(''units'',          l_units) || ',
'                apex_javascript.add_attribute(''valuePrefix'',    l_value_prefix) || ',
'                apex_javascript.add_attribute(''valueSuffix'',    l_value_suffix) || ',
'                apex_javascript.add_attribute(''roundTo'',        c_decimals) || ',
'                apex_javascript.add_attribute(''showMinMax'',     l_show_min_max) || ',
'                apex_javascript.add_attribute(''showShadow'',     c_show_shadow) || ',
'                apex_javascript.add_attribute(''shadowOpacity'',  c_shadow_opacity) || ',
'                apex_javascript.add_attribute(''shadowOffset'',   c_shadow_offset) || ',
'                apex_javascript.add_attribute(''gaugeWidth'',     c_gauge_width) || ',
'                apex_javascript.add_attribute(''gaugeColors'',    l_gauge_colors) || ',
'                apex_javascript.add_attribute(''gaugeBgColor'',   l_gauge_bg_color) || ',
'                apex_javascript.add_attribute(''gaugeMode'',      c_gauge_mode) || ',
'                apex_javascript.add_attribute(''heading'',        l_heading) || ',
'                apex_javascript.add_attribute(''description'',    c_description_template) || ',
'                apex_javascript.add_attribute(''pageItems'',      apex_plugin_util.page_item_names_to_jquery(p_region.ajax_items_to_submit)) ||',
'                apex_javascript.add_attribute(''ajaxIdentifier'', apex_plugin.get_ajax_identifier, false, false) ||',
'            ''});'' );',
'    return null;',
'end;',
'',
'',
'function ajax ',
'(',
'    p_region    in  apex_plugin.t_region,',
'    p_plugin    in  apex_plugin.t_plugin ',
')',
'return apex_plugin.t_region_ajax_result',
'is',
'    -- It''s better to have named variables instead of using the generic ones, ',
'    -- makes the code more readable. ',
'    c_value_column          constant varchar2(255) := p_region.attribute_01;',
'    c_min_column            constant varchar2(255) := p_region.attribute_02;',
'    c_max_column            constant varchar2(255) := p_region.attribute_03;',
'    c_heading_link          constant varchar2(4000) := p_region.attribute_22;',
'    c_description_link      constant varchar2(4000) := p_region.attribute_23;',
'',
'    l_value_column_no       pls_integer;',
'    l_min_column_no         pls_integer;',
'    l_max_column_no         pls_integer;',
'    l_column_value_list     apex_plugin_util.t_column_value_list2;',
'',
'    l_value                 number;',
'    l_min                   number;',
'    l_max                   number;',
'    l_heading_link          varchar2(4000);',
'    l_description_link      varchar2(4000);',
'begin',
'    apex_plugin_util.print_json_http_header;',
'',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'        p_sql_statement     => p_region.source,',
'        p_min_columns       => 1,',
'        p_max_columns       => 3,',
'        p_component_name    => p_region.name );',
'',
'    -- Get the actual column # for faster access and also verify that the data type',
'    -- of the column matches with what we are looking for',
'    l_value_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''value column'',',
'        p_column_alias          => c_value_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => true,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    l_min_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''min value column'',',
'        p_column_alias          => c_min_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    l_max_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''min value column'',',
'        p_column_alias          => c_max_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    -- Fetch the data',
'    if l_column_value_list(1).value_list.count = 1 then',
'        apex_plugin_util.set_component_values (',
'            p_column_value_list => l_column_value_list,',
'            p_row_num => 1 ',
'        );',
'    ',
'        l_heading_link := case',
'            when c_heading_link is not null then',
'                apex_util.prepare_url (',
'                    apex_plugin_util.replace_substitutions (',
'                        p_value  => c_heading_link,',
'                        p_escape => false',
'                    )',
'                )',
'        end;',
'        ',
'        l_description_link := case',
'            when c_description_link is not null then',
'                apex_util.prepare_url (',
'                    apex_plugin_util.replace_substitutions (',
'                        p_value  => c_description_link,',
'                        p_escape => false',
'                    )',
'                )',
'        end;',
'        ',
'        l_value := l_column_value_list(l_value_column_no).value_list(1).number_value;',
'        if l_min_column_no is not null then',
'            l_min := l_column_value_list(l_min_column_no).value_list(1).number_value;',
'        end if;',
'        if l_max_column_no is not null then',
'            l_max := l_column_value_list(l_max_column_no).value_list(1).number_value;',
'        end if;',
'        ',
'        apex_plugin_util.clear_component_values;',
'    else',
'        --invalid number of rows',
'        null;',
'    end if;',
'',
'    -- Default value to 0.',
'    l_value := nvl(l_value, 0);',
'',
'    -- Default min value to 0.',
'    l_min := nvl(l_min, 0);',
'',
'    -- Default max value to the smallest power of 10 equal to or greater than the value, starting with 100.',
'    if l_max is null then',
'        l_max := 100;',
'        loop',
'            exit when l_max >= l_value;',
'            l_max := l_max * 10;',
'        end loop;',
'    end if;',
'',
'    -- Print the actual, max and min values',
'    sys.htp.prn (',
'        ''[{'' ||',
'            apex_javascript.add_attribute(''headingLink'',  l_heading_link) ||',
'            apex_javascript.add_attribute(''descriptionLink'',  l_description_link) ||',
'            apex_javascript.add_attribute(''value'',  l_value) ||',
'            apex_javascript.add_attribute(''min'',    l_min) ||',
'            apex_javascript.add_attribute(''max'',    l_max, false, false) ||',
'        ''}]'' );',
'',
'    return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render'
,p_ajax_function=>'ajax'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT'
,p_substitute_attributes=>false
,p_reference_id=>7534122046207970661.4605
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
,p_files_version=>7
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029325211927676154.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'VALUE'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column that contains the value to be represented on the gauge.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029325664480676154.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Min Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_default_value=>'MIN'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column containing the minimum value represented by the gauge. When the value is equal or lesser than the minimum, the gauge will be shown as completely empty empty. If left empty, the minimum value defaults to 0.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029326025793676154.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Max Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_default_value=>'MAX'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column containing the maximum value represented by the gauge. When the value is equal or greater than the minimum, the gauge will be shown as completely full. If left blank, the maximum value defaults to the lesser power of 10 greater than the va'
||'lue.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029326431987676154.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Show Labels'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2029326899650676155.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2029326431987676154.4605)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029327384260676155.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Title'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2029326431987676154.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The text for the label above the gauge.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029327777047676155.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Units'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2029326431987676154.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The text for the label immediately below the gauge value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029328178042676155.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Value Prefix'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>2
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2029326431987676154.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The value label will be prefixed with this text.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029328533947676155.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Value Suffix'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>2
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2029326431987676154.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'This text will be appended to the value label.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029328911048676156.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Show Min and Max Values'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2029334641656676159.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'GAUGE'
,p_lov_type=>'STATIC'
,p_help_text=>'Whether to the actual minimum and maximum values on the gauge.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2029329380332676157.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2029328911048676156.4605)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029329819295676157.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Show Shadow'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Whether to render a shadow gradient on the gauge.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2029330272808676157.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2029329819295676157.4605)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029330800033676157.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Shadow Opacity'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_default_value=>'0.5'
,p_display_length=>5
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2029329819295676157.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The opacity of the shadow, measured between 0 and 1.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029331131030676157.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Shadow Offset'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'0'
,p_display_length=>5
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2029329819295676157.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The vertical offset of the shadow, in pixels.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029331536532676158.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Gauge Width Scale'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_default_value=>'1'
,p_display_length=>5
,p_max_length=>5
,p_is_translatable=>false
,p_help_text=>'The scale of the gauge''s width.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029331925634676158.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'GTR'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2029332371028676158.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2029331925634676158.4605)
,p_display_sequence=>10
,p_display_value=>'Dynamic Green-to-Red'
,p_return_value=>'GTR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2029332899859676159.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2029331925634676158.4605)
,p_display_sequence=>20
,p_display_value=>'Dynamic Red-to-Green'
,p_return_value=>'RTG'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2029333338667676159.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2029331925634676158.4605)
,p_display_sequence=>30
,p_display_value=>'Custom Color(s)'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029333848354676159.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>150
,p_prompt=>'Gauge Color(s)'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'#144485'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2029331925634676158.4605)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'A comma-separated list of RGB colors to be used on the gauge. The first color will be used when the value is near the minimum and the last color will be used when the value is near the maximum. Leave only one color for a solid fill.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029334303391676159.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>160
,p_prompt=>'Empty Color'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'#d9d9d9'
,p_display_length=>10
,p_is_translatable=>false
,p_help_text=>'The color to be used on the ''empty'' sector of the gauge.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029334641656676159.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>1
,p_prompt=>'Gauge Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'GAUGE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Whether to render the gauge as a half circle or as a full circle.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2029335015785676160.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2029334641656676159.4605)
,p_display_sequence=>10
,p_display_value=>'Normal'
,p_return_value=>'GAUGE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2029335560173676160.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2029334641656676159.4605)
,p_display_sequence=>20
,p_display_value=>'Donut'
,p_return_value=>'DONUT'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029336047079676160.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>2
,p_prompt=>'Width'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The fixed width of the gauge, in pixels. Leave blank for automatic/responsive.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029336498611676160.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>3
,p_prompt=>'Height'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The fixed height of the gauge, in pixels. Leave blank for automatic/responsive.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029336820241676161.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>91
,p_prompt=>'Description'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'To be shown under the Gauge. You may use the following text replacements:',
'<ul>',
'<li>:MIN:</li>',
'<li>:MAX:</li>',
'<li>:VALUE:</li>',
'</ul>',
'Example:<br/>',
'The actual value is :VALUE: (out of :MAX:)'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029337221675676161.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>21
,p_display_sequence=>95
,p_prompt=>'Heading'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_max_length=>200
,p_is_translatable=>true
,p_help_text=>'The heading is displayed directly above the description and is commonly set to the label for the chart.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029337623795676161.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>22
,p_display_sequence=>96
,p_prompt=>'Heading Link Target'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'A URL to which the user will be redirected when the heading gets clicked. This attribute supports substitution strings.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029338005106676161.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>23
,p_display_sequence=>92
,p_prompt=>'Description Link Target'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'A URL to which the user will be redirected when the description gets clicked. This attribute supports substitution strings.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2029338409202676162.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>24
,p_display_sequence=>240
,p_prompt=>'Decimals'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_default_value=>'0'
,p_display_length=>5
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(849918025855293244.4605)
,p_plugin_id=>wwv_flow_api.id(2366024944441499041.4605)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>1
,p_sql_max_column_count=>3
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_advanced_auto_complete
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2689778454340234650.4605)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM_ORACLE_APEX_ADVANCED_AUTO_COMPLETE'
,p_display_name=>unistr('Preenchimento Autom\00E1tico Avan\00E7ado')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM_ORACLE_APEX_ADVANCED_AUTO_COMPLETE'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_advanced_auto_complete'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_advanced_auto_complete'
,p_validation_function=>'wwv_flow_f4000_plugins.validate_advanced_auto_compl'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:READONLY:ESCAPE_OUTPUT:SOURCE:ELEMENT:WIDTH:ENCRYPT:LOV:CASCADING_LOV'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_help_text=>'<br />'
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2689787645364459113.4605)
,p_plugin_id=>wwv_flow_api.id(2689778454340234650.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Search'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'CONTAINS_IGNORE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'<p>Defines how the search with the entered value should be performed. When using &quot;Lazy Loading&quot; this setting can have an impact on query performance. Contains and/or Ignore Case will prevent the use of an existing index on the column.</p>'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2340837999983480152.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2689787645364459113.4605)
,p_display_sequence=>10
,p_display_value=>'Contains & Case Sensitive'
,p_return_value=>'CONTAINS_CASE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2340838092593480152.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2689787645364459113.4605)
,p_display_sequence=>20
,p_display_value=>'Exact & Case Sensitive'
,p_return_value=>'EXACT_CASE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2340838186030480152.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2689787645364459113.4605)
,p_display_sequence=>30
,p_display_value=>'Contains & Ignore Case'
,p_return_value=>'CONTAINS_IGNORE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2340838291521480153.4605)
,p_plugin_attribute_id=>wwv_flow_api.id(2689787645364459113.4605)
,p_display_sequence=>40
,p_display_value=>'Exact & Ignore Case'
,p_return_value=>'EXACT_IGNORE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2689788542725467853.4605)
,p_plugin_id=>wwv_flow_api.id(2689778454340234650.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Only Values from List'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_help_text=>'<p>If set to yes, the autocompleter will only allow to enter values which are returned by the SQL statement. Not existing values will result in an empty input box when leaving the field.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2689789327618472986.4605)
,p_plugin_id=>wwv_flow_api.id(2689778454340234650.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Separator for Multi-Selection'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>2
,p_max_length=>2
,p_is_translatable=>false
,p_help_text=>'<p>If defined, the textfield allows to select multiple values. The entered value will be used as a separator  between the values.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2689791540216486008.4605)
,p_plugin_id=>wwv_flow_api.id(2689778454340234650.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Lazy Loading'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_help_text=>'<p>If set to yes, the matching values will be read from the database each time the user types a character. If set to no, all values will be read only once when the page is rendered.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2689792554761490224.4605)
,p_plugin_id=>wwv_flow_api.id(2689778454340234650.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Maximum Values in List'
,p_attribute_type=>'NUMBER'
,p_is_required=>false
,p_display_length=>3
,p_max_length=>3
,p_is_translatable=>false
,p_help_text=>'<p>Limits the number of items in the select box to avoid performance problems by returning to many rows.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2689789940778476717.4605)
,p_plugin_id=>wwv_flow_api.id(2689778454340234650.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Automatic Fill'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_help_text=>'<p>Fill the textfield while still selecting a value, replacing the value if more is typed or something else is selected.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2689790830174483173.4605)
,p_plugin_id=>wwv_flow_api.id(2689778454340234650.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Select First'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'<p>If this is set, the first autocomplete value will be automatically selected on tab/return, even if it has not been handpicked by keyboard or mouse action. If there is a handpicked (highlighted) result, that result will take precedence.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2689793135845494212.4605)
,p_plugin_id=>wwv_flow_api.id(2689778454340234650.4605)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Highlight Search'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'<p>Defines if the entered value is highlighted in the select box of matching entries.</p>'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(849918180332293245.4605)
,p_plugin_id=>wwv_flow_api.id(2689778454340234650.4605)
,p_name=>'LOV'
,p_sql_min_column_count=>1
,p_sql_max_column_count=>2
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'<strong>Example 1: Display and store same value in page item</strong>',
'<pre>',
'SELECT ename FROM emp ORDER by 1',
'</pre>',
'</p>',
'',
'<p>',
'<strong>Example 2: Display ENAME but store EMPNO in page item</strong>',
'<pre>',
'SELECT ename d, empno r FROM emp ORDER BY 1',
'</pre>',
'</p>',
'',
'<p>',
'<b>Example 3: Display employees of a specific department by using a bind variable</b>',
'<pre>',
'SELECT ename FROM emp WHERE deptno = :P3_DEPTNO ORDER by 1',
'</pre>',
'</p>',
'',
'<p>',
'<b>Example 4: Static list examples</b>',
'<ul>',
'<li>STATIC:Cow,Dog,Cat,Lion (will be sorted alphabetically)</li>',
'<li>STATIC2:10,15,20,25,50,100,200,500,1000,10000 (sorted in order of creation)</li>',
'</ul>',
'</p>',
''))
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(9728334451760999.4605)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>unistr('\00C1rea de Trabalho')
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>101
,p_home_url=>'f?p=&APP_ID.:1:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4605
,p_navigation_list_template_id=>wwv_flow_api.id(389919542813170530.4605)
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>unistr('P\00E1gina Global')
,p_step_title=>'0'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21040795940063799.4605)
,p_plug_name=>unistr('Links R\00E1pidos')
,p_region_name=>'issues_jump'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>350
,p_plug_display_point=>'REGION_POSITION_04'
,p_list_id=>wwv_flow_api.id(5181728677916157.4605)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(5208269691267696.4605)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393161701706868148.4605)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-team-dev'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393161820752868148.4605)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(393161701706868148.4605)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(42604339764717849.4605)
,p_plug_name=>'APEX 5 - Tabs'
,p_region_name=>'a_Header_menu'
,p_parent_plug_id=>wwv_flow_api.id(393161820752868148.4605)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(5251802537036599.4605)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(389919542813170530.4605)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393162297665868148.4605)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(393161820752868148.4605)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="''||apex_util.prepare_url(''f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::'')||''" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393162044284868148.4605)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(393161701706868148.4605)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393162683062868149.4605)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_api.id(393162044284868148.4605)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393280012828677060.4605)
,p_plug_name=>'APEX 5 - Administration Menu'
,p_region_name=>'adminMenu'
,p_parent_plug_id=>wwv_flow_api.id(393162683062868149.4605)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(702381952631922533.4605)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(5208269691267696.4605)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491531548304760390.4605)
,p_plug_name=>'APEX 5 - Help Menu'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_api.id(393162683062868149.4605)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(702386956612924063.4605)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(5208269691267696.4605)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393162851516868149.4605)
,p_plug_name=>'APEX 5 - Account'
,p_parent_plug_id=>wwv_flow_api.id(393162044284868148.4605)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393280813800685819.4605)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-team-dev'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>310
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393281636948687250.4605)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_api.id(393280813800685819.4605)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>320
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393283583382701129.4605)
,p_plug_name=>'APEX 5 - Breadcrumb'
,p_parent_plug_id=>wwv_flow_api.id(393281636948687250.4605)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_display_point=>'BODY'
,p_menu_id=>wwv_flow_api.id(92331531826187224.4605)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(5208262300686444.4605)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(393281844168687250.4605)
,p_plug_name=>'APEX 5 - Control Bar Right'
,p_parent_plug_id=>wwv_flow_api.id(393280813800685819.4605)
,p_region_css_classes=>'a-ControlBar-col'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>330
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(238359912274538263.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(393162683062868149.4605)
,p_button_name=>'SPOTLIGHT'
,p_button_static_id=>'header-spotlightSearch'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(359238865408012460.4605)
,p_button_image_alt=>'Pesquisa do Spotlight'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-actionButton a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-search'
,p_button_cattributes=>'data-action="spotlight-search"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5948435972329309.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(393281844168687250.4605)
,p_button_name=>'NOTIFICATIONS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(5208338701524668.4605)
,p_button_image_alt=>unistr('Notifica\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:502:&SESSION.::&DEBUG.:RP::'
,p_icon_css_classes=>'fa fa-bell-o'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(389448583141391465.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(393162683062868149.4605)
,p_button_name=>'ADMINISTRATION'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(5208262349044176.4605)
,p_button_image_alt=>unistr('Administra\00E7\00E3o')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(11815070154752023.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(393281844168687250.4605)
,p_button_name=>'JUMP_MENU'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:a-Button--gapRight'
,p_button_template_id=>wwv_flow_api.id(656569185201725731.4605)
,p_button_image_alt=>'Saltar para...'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-menuButton'
,p_icon_css_classes=>'icon-menu-drop-down'
,p_button_cattributes=>'data-menu="issues_jump_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(389448647174391466.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(393162683062868149.4605)
,p_button_name=>'FEEDBACK'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(359238865408012460.4605)
,p_button_image_alt=>'Feedback'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
,p_required_patch=>wwv_flow_api.id(698205300939964492.4605)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5840009192198704.4605)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(393281844168687250.4605)
,p_button_name=>'GO_MILESTONES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(359238865408012460.4605)
,p_button_image_alt=>'Marcos'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:RP::'
,p_button_condition_type=>'NEVER'
,p_icon_css_classes=>'fa fa-map-signs'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(389448799086391467.4605)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(393162683062868149.4605)
,p_button_name=>'HELP'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(5208262349044176.4605)
,p_button_image_alt=>'Ajuda'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5839960308198703.4605)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(393281844168687250.4605)
,p_button_name=>'GO_LABELS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(359238865408012460.4605)
,p_button_image_alt=>'Labels'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::'
,p_button_condition_type=>'NEVER'
,p_icon_css_classes=>'fa fa-tags'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5840227830198706.4605)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(393281844168687250.4605)
,p_button_name=>'GO_UTILITIES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--padRight'
,p_button_template_id=>wwv_flow_api.id(359238865408012460.4605)
,p_button_image_alt=>unistr('Utilit\00E1rios')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.:RP::'
,p_button_condition_type=>'NEVER'
,p_icon_css_classes=>'icon-tools'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5839889927198702.4605)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(393281844168687250.4605)
,p_button_name=>'NEW_ISSUE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Novo Problema'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,109,111:F4600_LAST_VIEW:&P0_CURRENT_PAGE.'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_count  number;',
'    l_template_count number;',
'    l_label_count number;',
'    l_milestone_count number;',
'    ',
'begin ',
'    -- Issues',
'    select count(*)',
'      into l_issue_count',
'      from wwv_flow_issues',
'     where security_group_id = :flow_security_group_id;',
'    -- Labels',
'    select count(*)',
'      into l_label_count',
'      from wwv_flow_label_groups',
'     where security_group_id = :flow_security_group_id;',
'    -- templates',
'    select count(*)',
'      into l_template_count',
'      from wwv_flow_issue_templates',
'     where security_group_id = :flow_security_group_id;',
'    -- milestones',
'    select count(*)',
'      into l_milestone_count',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id;',
'',
'return (l_issue_count >0 or l_label_count >0 or l_template_count > 0 or l_milestone_count > 0);',
'',
'end;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_security_scheme=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5712328082527240.4605)
,p_name=>'P0_CURRENT_PAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(393281844168687250.4605)
,p_use_cache_before_default=>'NO'
,p_item_default=>'&APP_PAGE_ID.'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Home do Team Development'
,p_alias=>'TEAMDEV'
,p_step_title=>'Team Development'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function getSelectedIds() {',
'    var model,',
'        ids = [],',
'        issuesIG = apex.region("issues");',
'',
'    model = issuesIG.call("getCurrentView").model;',
'    ids = issuesIG.call("getSelectedRecords").map(function(rec) {return model.getRecordId(rec)});',
'    return ids.join('':'');',
'}'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var p1_app  = $v2("P1_APPLICATION_ID"), ',
'    p1_page = $v2("P1_PAGE_ID");',
'',
'/*',
'  Only deals with setting column filters using equal operator, case insensitive',
'  An empty string value removes the filter.',
'  columns and values are arrays and must have same length',
'*/',
'function setIGFilters( regionId, columns, values ) {',
'    var i, filter, col, val, id, curVal,',
'        colMap = {},',
'        idMap = {},',
'        changed = false,',
'        region = apex.region(regionId),',
'        inst = region.call("instance"),',
'        filters = region.call("getFilters"),',
'        options = { save: false };',
'',
'    for (i = 0; i < columns.length; i++) {',
'        col = columns[i];',
'        if (inst._getColumnByName(col)) {',
'            id = inst._getColumnByName(col).id;',
'            idMap[id] = col;',
'        }',
'    }',
'',
'    for (i = 0; i < filters.length; i++) {',
'        filter = filters[i];',
'        if (filter.type === "column" && filter.operator === "EQ" && idMap[filter.columnId]) {',
'            colMap[idMap[filter.columnId]] = {',
'                id: filter.id,',
'                val: filter.value',
'            };',
'        }',
'    }',
'',
'    for (i = 0; i < columns.length; i++) {',
'        col = columns[i];',
'        val = values[i];',
'        id = curVal = null;',
'        if (colMap[col]) {',
'            id = colMap[col].id;',
'            curVal = colMap[col].val;',
'        }',
'        if (val !== "") { ',
'            filter = {',
'                   type: "column",',
'                   columnType: "column",',
'                   operator: "EQ",',
'                   value: val,',
'                   isCaseSensitive: false',
'            };',
'            if (id) {',
'                if (val !== curVal) {',
'                    region.call("updateFilter", id, filter, options);',
'                    changed = true;',
'                }',
'            } else {',
'                filter.columnName = col;',
'                region.call("addFilter", filter, options);',
'                changed = true;',
'            }',
'        } else if ( id ) {',
'            region.call("deleteFilter", id, options);',
'            changed = true;',
'        }',
'    }',
'    if (changed) {',
'        inst._setReportSettings({});',
'    }',
'}',
'if (p1_app) {',
'    setIGFilters("issues", ["APPLICATION_ID", "PAGE_ID", "STATUS"],[ p1_app, p1_page, "Open" ]);',
'    apex.item("issues").show();',
'    apex.region("issues").call("resize"); // this seems to help with sizing after becoming visible',
'} else {',
'    apex.item("issues").show();',
'    apex.region("issues").call("resize"); // this seems to help with sizing after becoming visible',
'}'))
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.is-disabled {opacity: 0.5; pointer-events: none;}',
'.group h2 {',
'  margin-bottom: 8px;',
'  font-size: 14px;',
'  line-height: 24px;',
'}',
'',
'.group p {',
'  color: #707070;',
'  margin-top: -4px;',
'}',
'',
'.group-item {',
'  margin: 8px 0;',
'}',
'',
'.group {',
'  margin: 16px;',
'}',
''))
,p_step_template=>wwv_flow_api.id(391881764116992437.4605)
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(4876236258998332.4605)
,p_name=>'Problemas em Aberto'
,p_region_name=>'dashboard'
,p_template=>wwv_flow_api.id(179998957300224011.4605)
,p_display_sequence=>40
,p_region_sub_css_classes=>'a-BadgeList--cols a-BadgeList--responsive a-BadgeList--large'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-BadgeList--fixed:a-BadgeList--large'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4500P1000c */',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues ',
'      where security_group_id = :flow_security_group_id',
'        and status = ''OPEN''',
'        and deleted = ''N'')  issues,',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues ',
'      where security_group_id = :flow_security_group_id',
'        and created_by = :APP_USER',
'        and status = ''OPEN''',
'        and deleted = ''N'')  owned,',
'      (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues i, ',
'           wwv_flow_issue_stakeholders s',
'     where s.issue_id = i.id',
'       and s.stakeholder = :APP_USER',
'       and s.stakeholder_type = ''ASSIGNEE''',
'       and i.status = ''OPEN''',
'       and i.deleted = ''N''',
'       and s.security_group_id = :flow_security_group_id',
'       and i.security_group_id = :flow_security_group_id) assigned,',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues i, ',
'           wwv_flow_issue_stakeholders s',
'     where s.issue_id = i.id',
'       and s.stakeholder_type = ''SUBSCRIBER''',
'       and i.status = ''OPEN''',
'       and i.deleted = ''N''',
'       and s.security_group_id = :flow_security_group_id',
'       and i.security_group_id = :flow_security_group_id)  subscribed ',
' from dual'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(1046845011939553934.4605)
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_row_count_max=>7
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
,p_comment=>'style="width:33%; float:left;"'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5165497807832105.4605)
,p_query_column_id=>1
,p_column_alias=>'ISSUES'
,p_column_display_sequence=>1
,p_column_heading=>'Total'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(15580950867474513.4605)
,p_query_column_id=>2
,p_column_alias=>'OWNED'
,p_column_display_sequence=>2
,p_column_heading=>'De Propriedade de'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(15581023832474514.4605)
,p_query_column_id=>3
,p_column_alias=>'ASSIGNED'
,p_column_display_sequence=>3
,p_column_heading=>'Designado'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(15581179397474515.4605)
,p_query_column_id=>4
,p_column_alias=>'SUBSCRIBED'
,p_column_display_sequence=>4
,p_column_heading=>'Assinado'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4926428596003033.4605)
,p_plug_name=>'Status '
,p_region_name=>'statusDialog'
,p_region_template_options=>'#DEFAULT#:js-dialog-size480x320'
,p_plug_template=>wwv_flow_api.id(10813455696794486.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('Este status ser\00E1 aplicado a todos os problemas selecionados.')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5402528899234735.4605)
,p_plug_name=>'IG de Problemas'
,p_region_name=>'issues'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display:none;"'
,p_plug_template=>wwv_flow_api.id(651492083233530570.4605)
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with agg_stakeholders as (',
'    select issue_id,',
'           listagg(case when seqnum <=5 then wwv_flow_issue_int.get_user_name(stakeholder) end, '', '') ',
'            within group(order by wwv_flow_issue_int.get_user_name(stakeholder) ) assignees, ',
'           listagg(case when seqnum <=5 then wwv_flow_issue_int.get_avatar(stakeholder, p_image_size => 24, p_include_link => ''Y'') end, '' '') ',
'            within group(order by stakeholder ) assignees_html, ',
'           count(*) assignee_count',
'      from (select ss.*, ',
'                   row_number() over (partition by ISSUE_ID order by stakeholder ) as seqnum ',
'              from wwv_flow_issue_stakeholders ss',
'             where ss.stakeholder_type = ''ASSIGNEE''',
'               and ss.security_group_id = :flow_security_group_id)',
'     group by issue_id',
'), agg_subscribers as (',
'    select issue_id,',
'           listagg(wwv_flow_issue_int.get_user_name(stakeholder), '':'') ',
'            within group(order by wwv_flow_issue_int.get_user_name(stakeholder) ) subcribers,',
'           listagg(wwv_flow_issue_int.get_avatar(stakeholder, p_image_size => 24, p_include_link => ''Y''), '' '') ',
'            within group( order by stakeholder ) subscribers_html, ',
'           count(*) subscriber_count',
'      from wwv_flow_issue_stakeholders',
'     where stakeholder_type = ''SUBSCRIBER''',
'       and security_group_id = :flow_security_group_id',
'     group by issue_id',
'), ',
'agg_labels as (',
'    select issue_id,',
'           listagg(label_name, '', '') within group(',
'                order by label_name',
'           ) labels, ',
'           listagg(''<span class="a-IssueLabel ''||g.group_color||''" > ''||label_name||''</span>'', '''') within group(',
'                order by g.group_name, l.label_name',
'           ) labels_html',
'      from wwv_flow_issue_labels il,',
'           wwv_flow_labels l, ',
'           wwv_flow_label_groups g',
'     where il.label_id = l.id',
'       and l.label_group_id = g.id',
'       and il.security_group_id = :flow_security_group_id',
'       and l.security_group_id = :flow_security_group_id',
'       and g.security_group_id = :flow_security_group_id',
'     group by issue_id',
'), ',
'agg_milestones as (',
'  select issue_id,',
'           listagg(milestone_name, '':'') within group(',
'                order by milestone_name',
'           ) milestones,',
'           listagg(''<a class="a-IssueMilestone" href="''||apex_util.prepare_url(''f?p=''||:APP_ID||'':205:''||:APP_SESSION||''::::P205_ID:''||m.id,  p_checksum_type =>3 )||''"><span class="fa fa-map-signs" aria-hidden="true"></span>''||milestone_name||''</a> '''
||', '' '') within group(',
'                order by milestone_name',
'           ) milestones_html',
'      from wwv_flow_issue_milestones im,',
'           wwv_flow_milestones m',
'     where im.milestone_id = m.id',
'       and im.security_group_id = :flow_security_group_id',
'       and m.security_group_id = :flow_security_group_id',
'     group by issue_id',
')',
'select i.id,',
'       i.issue_number,',
'       i.title,',
'       i.slug,',
'       i.status,',
'       case ',
'           when i.status = ''OPEN'' then ''<span aria-hidden="true" class="a-IssueList-itemStatusIcon a-IssueList-itemStatusIcon--open fa fa-exclamation-circle-o" title="''||i.status||''"></span>''',
'           WHEN i.status = ''CLOSED'' then ''<span aria-hidden="true" class="a-IssueList-itemStatusIcon a-IssueList-itemStatusIcon--closed fa fa-exclamation-circle-o fam-check fam-is-danger" title="''||i.status||''"></span>''',
'       end issue_status,',
'       i.issue_text,',
'       case ',
'            when i.duplicate_of is not null then ',
'                wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.MARKED_DUPLICATE_OF'', p0=> i2.title, p1=> apex_util.get_since(i.duplicate_identified_on),  p2=>i.duplicate_identified_by )',
'            else ''''',
'        end  marked_duplicate,',
'       i.application_id,',
'       i.page_id,',
'        wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.OPENED'', p0=>apex_util.get_since(i.created_on)) created,',
'       apex_util.prepare_url(''f?p=''||:APP_ID||'':500:''||:APP_SESSION||''::::P500_USER_NAME:''||i.created_by, p_checksum_type =>3) created_by_link,',
'       i.created_on ,',
'       wwv_flow_issue_int.get_user_name(i.created_by) created_by,',
'       (',
'           select count(*)',
'             from wwv_flow_issue_comments c',
'            where c.issue_id = i.id',
'       ) comment_count,',
'       (',
'           select count(*)',
'             from wwv_flow_issue_events e',
'            where e.issue_id = i.id',
'       ) event_count,',
'       h.assignees,',
'       h.assignees_html,',
'       ss.subcribers,',
'       ss.subscribers_html,',
'       l.labels,',
'       l.labels_html,',
'       m.milestones, ',
'       m.milestones_html,',
'       apex_util.prepare_url(''f?p=''||:APP_ID||'':100:''||:APP_SESSION||''::NO:RP:P100_ISSUE_ID:''||i.id , p_checksum_type=>3)issue_link, ',
'       case ',
'         when h.assignee_count > 5 then ''+''||(h.assignee_count -5) ',
'         else null',
'       end more_assignees',
'  from wwv_flow_issues               i,',
'       wwv_flow_current_workspaces   w,',
'       agg_stakeholders              h,',
'       agg_subscribers               ss,',
'       agg_labels                    l,',
'       wwv_flow_issues               i2,',
'       agg_milestones                  m',
' where i.deleted = ''N'' ',
'   and i.security_group_id = w.workspace_id',
'   and i.security_group_id = :flow_security_group_id',
'   and w.workspace_id = :flow_security_group_id',
'   and h.issue_id (+) = i.id',
'   and ss.issue_id (+) = i.id',
'   and l.issue_id (+) = i.id',
'   and m.issue_id (+) = i.id',
'   and i.duplicate_of = i2.id (+)',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_count  number;',
'    l_template_count number;',
'    l_label_count number;',
'    l_milestone_count number;',
'    ',
'begin ',
'    -- Issues',
'    select count(*)',
'      into l_issue_count',
'      from wwv_flow_issues',
'     where security_group_id = :flow_security_group_id;',
'    -- Labels',
'    select count(*)',
'      into l_label_count',
'      from wwv_flow_label_groups',
'     where security_group_id = :flow_security_group_id;',
'    -- templates',
'    select count(*)',
'      into l_template_count',
'      from wwv_flow_issue_templates',
'     where security_group_id = :flow_security_group_id;',
'    -- milestones',
'    select count(*)',
'      into l_milestone_count',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id;',
'',
'return (l_issue_count >0 or l_label_count >0 or l_template_count > 0 or l_milestone_count > 0);',
'',
'end;'))
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5402773306234737.4605)
,p_name=>'ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'ID'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>20
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5402846102234738.4605)
,p_name=>'TITLE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TITLE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_LINK'
,p_heading=>unistr('T\00EDtulo')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP:P100_ISSUE_ID:&ID.'
,p_link_text=>'&TITLE.'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>true
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5402921773234739.4605)
,p_name=>'SLUG'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SLUG'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>40
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5403034736234740.4605)
,p_name=>'ISSUE_STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\00CDcone de Status')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_lov_type=>'SHARED'
,p_lov_id=>wwv_flow_api.id(5664182917694426)
,p_lov_display_extra=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5403109019234741.4605)
,p_name=>'ISSUE_TEXT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_TEXT'
,p_data_type=>'CLOB'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Texto do Problema'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>true
,p_max_length=>32767
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5403271720234742.4605)
,p_name=>'MARKED_DUPLICATE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MARKED_DUPLICATE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>unistr('Marcado como Duplica\00E7\00E3o')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5403431737234744.4605)
,p_name=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PAGE_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>unistr('ID da P\00E1gina')
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>80
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5403552407234745.4605)
,p_name=>'CREATED'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Criado'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>90
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5403605548234746.4605)
,p_name=>'CREATED_BY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_BY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Criado por'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>100
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5403778044234747.4605)
,p_name=>'COMMENT_COUNT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'COMMENT_COUNT'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>unistr('Coment\00E1rios')
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>110
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5403864761234748.4605)
,p_name=>'EVENT_COUNT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'EVENT_COUNT'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Eventos'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>120
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5403906064234749.4605)
,p_name=>'ASSIGNEES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ASSIGNEES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Lista de Favorecidos'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>130
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5404070524234750.4605)
,p_name=>'ASSIGNEES_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ASSIGNEES_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\00CDcones de Favorecidos')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>140
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5442632521568801.4605)
,p_name=>'SUBCRIBERS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUBCRIBERS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Lista de Assinantes'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>150
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5442743104568802.4605)
,p_name=>'SUBSCRIBERS_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUBSCRIBERS_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\00CDcones de Assinante')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>160
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5442829111568803.4605)
,p_name=>'LABELS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABELS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Lista de Labels'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>170
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5442980375568804.4605)
,p_name=>'LABELS_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABELS_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Labels Aprimorados'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>180
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5443011520568805.4605)
,p_name=>'MILESTONES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MILESTONES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Lista de Marcos'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>190
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5443190471568806.4605)
,p_name=>'MILESTONES_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MILESTONES_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Marcos Aprimorados'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>200
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5612738543530335.4605)
,p_name=>'ISSUE_LINK'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_LINK'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Link do Problema'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>210
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5947690738329301.4605)
,p_name=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Status'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>220
,p_value_alignment=>'LEFT'
,p_attribute_02=>'LOV'
,p_lov_type=>'SHARED'
,p_lov_id=>wwv_flow_api.id(5664182917694426)
,p_lov_display_extra=>true
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5947743824329302.4605)
,p_name=>'CREATED_ON'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_ON'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'Criado'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>230
,p_value_alignment=>'LEFT'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_format_mask=>'SINCE'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
end;
/
begin
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(6186097491627141.4605)
,p_name=>'CREATED_BY_LINK'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_BY_LINK'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>240
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(6332983198146504.4605)
,p_name=>'ISSUE_NUMBER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_NUMBER'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>unistr('Problema n\00BA')
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>250
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(10861362760686809.4605)
,p_name=>'MORE_ASSIGNEES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MORE_ASSIGNEES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Mais Favorecidos'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>260
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>41
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(156404054164150743.4605)
,p_name=>'APPLICATION_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'APPLICATION_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Id do Aplicativo'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>270
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(2567473977208406322.4605)
,p_name=>'Row Selector'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(5402636881234736.4605)
,p_internal_uid=>5402636881234736
,p_is_editable=>false
,p_lazy_loading=>true
,p_requires_filter=>false
,p_show_nulls_as=>'-'
,p_select_first_row=>false
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_no_data_found_message=>unistr('N\00E3o h\00E1 Problemas definidos no sistema.')
,p_show_toolbar=>true
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'PAGE'
,p_show_icon_view=>true
,p_icon_view_use_custom=>true
,p_icon_view_custom=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-ContentRowReport-item" data-id="&APEX$ROW_ID.">',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemSelection"><span class="u-selector"></span></div>',
'    <div class="a-ContentRowReport-itemIconWrap">&ISSUE_STATUS.</div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle" id="label_&ID."><a href="&ISSUE_LINK.">&TITLE.</a></h3> <span class="a-IssueList-itemLabels">&LABELS_HTML.</span>',
'        <div class="a-ContentRowReport-itemDescription">#&ISSUE_NUMBER. &CREATED. <a class="a-IssueList-itemAuthor" href="&CREATED_BY_LINK.">&CREATED_BY.</a> <span class="a-IssueList-itemMilestones">&MILESTONES_HTML.</span></div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">&ASSIGNEES_HTML.<span class="a-User a-User--more" title="&MORE_ASSIGNEES. other assignees"><span class="a-User-initials" role="presentation">&MORE_ASSIGNEES.</span></span></div>',
'      <div class="a-ContentRowReport-itemActions">',
'        <a class="a-IssueList-itemCommentsLink" href="&ISSUE_LINK."><span class="a-IssueList-itemCommentsIcon fa fa-comments-o"></span><span class="a-IssueList-itemCommentsCount">&COMMENT_COUNT.</span></a>',
'      </div>',
'    </div>',
'  </div>',
'</li>',
''))
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function (options) {',
'    var $ = apex.jQuery,',
'        toolbarData = $.apex.interactiveGrid.copyDefaultToolbar();',
'',
'    toolbarData.toolbarInsertAfter( "actions_button", {',
'       type: "MENU",',
'       labelKey: "APEX.ISSUES.UPDATE_MENU",',
'       id: "multi_edit_issues",',
'       menu: {',
'           items: [',
'               {',
'                   type:     "action",',
'                   labelKey: "APEX.ISSUES.MENU.STATUS",',
'                   action:   "open-status-dialog"',
'               },',
'               {',
'                   type:     "action",',
'                   labelKey: "APEX.ISSUES.MENU.ASSIGNEES",',
'                   action:   "open-assignees-dialog"',
'               },',
'               {',
'                   type:     "action",',
'                   labelKey: "APEX.ISSUES.MENU.LABELS",',
'                   action:   "open-labels-dialog"',
'               },',
'               {',
'                   type:     "action",',
'                   labelKey: "APEX.ISSUES.MENU.MILESTONES",',
'                   action:   "open-milestones-dialog"',
'               }',
'           ]',
'       }',
'    });',
'',
'    ',
'    options.toolbarData = toolbarData;',
'',
'    // don''t want single row view',
'    apex.util.getNestedObject(options, "views.grid.features").singleRowView = false;',
'',
'    options.defaultIconViewOptions = {',
'        collectionClasses: "a-ContentRowReport a-IssueList",',
'        iconListOptions: {',
'            navigation: false,',
'            tabbableContent: "a"',
'            // comes from row selector when navigation is false',
'            // multiple: true ',
'            // itemSelector: true',
'        }',
'    };',
'',
'    function checkOpen(dialogId) {',
'        if (getSelectedIds()) {',
'            apex.theme.openRegion(dialogId);',
'        } else {',
'            apex.theme.openRegion("noSelectionDialog");',
'        }',
'        return true; // setting focus',
'    }',
'',
'    //',
'    // Actions ',
'    //',
'    options.initActions = function(actions) {',
'        var ig$ = $(actions.context),',
'            iconView = ig$.interactiveGrid("getViews").icon;',
'',
'        iconView.title = apex.lang.getMessage( "APEX.ISSUES.CARDS"); ',
'        iconView.icon = "icon-ig-details";',
'',
'        actions.add([',
'            {name: "open-status-dialog",',
'            shortcut: "Ctrl+/,S",',
'            action: function (event, elm) {',
'                return checkOpen("statusDialog");',
'            }},',
'            {name: "open-assignees-dialog",',
'            shortcut: "Ctrl+/,A",',
'            action: function (event, elm) {',
'                return checkOpen("assignDialog");',
'            }},',
'            {name: "open-labels-dialog",',
'            shortcut: "Ctrl+/,L",',
'            action: function (event, elm) {',
'                return checkOpen("labelDialog");',
'            }},',
'            {name: "open-milestones-dialog",',
'            shortcut: "Ctrl+/,M",',
'            action: function (event, elm) {',
'                return checkOpen("milestoneDialog");',
'            }}',
'        ]);',
'    };',
'    return options;',
'}'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9774052912317313.4605)
,p_plug_name=>'Sobre'
,p_region_css_classes=>'a-Region--stacked a-Region--padded a-Region--flush a-Region--sideRegion'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>O Team Development permite rastrear e gerenciar problemas em forma de conversa\00E7\00E3o. Voc\00EA pode classificar o problema usando labels, designar usu\00E1rios aos problemas, vincular um problema a marcos e anexar arquivos a um problema.</p>'),
'<p><a target="_blank" href="&SYSTEM_HELP_URL./htmdb/managing-team-development.html">Saiba Mais...</a></p>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10422245393079420.4605)
,p_plug_name=>'Label'
,p_region_name=>'labelDialog'
,p_region_css_classes=>'a-DialogRegion--noPadding'
,p_region_template_options=>'#DEFAULT#:js-dialog-size720x480'
,p_plug_template=>wwv_flow_api.id(10813455696794486.4605)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
' declare',
'    l_item_type    varchar2(30);',
'    l_label_select varchar2(4000) := wwv_flow_lang.system_message(''APEX.ISSUES.SELECT'');',
'    l_label_assign varchar2(4000) := wwv_flow_lang.system_message(''APEX.ISSUES.ASSIGN'');',
'    l_label_remove varchar2(4000) := wwv_flow_lang.system_message(''APEX.ISSUES.REMOVE'');',
'begin',
'',
'    for label_group in (select id,',
'                               group_name,',
'                               values_are_exclusive,',
'                               group_color,',
'                               wwv_flow_issue_int.gen_slug(group_name) group_slug',
'                          from wwv_flow_label_groups g',
'                         where security_group_id = :flow_security_group_id',
'                         order by group_name) ',
'    loop',
'',
'        if label_group.values_are_exclusive = ''Y'' then',
'          sys.htp.p(''<div class="group is-exclusive">'');',
'        else',
'          sys.htp.p(''<div class="group">'');',
'        end if;',
'        sys.htp.p(''<h2 id="group_''||label_group.group_slug||''">'');',
'        sys.htp.p(label_group.group_name||''</h2>'');',
'        if  label_group.values_are_exclusive = ''Y'' then ',
'            sys.htp.p(''<div class="group-item">'');',
'            sys.htp.p( APEX_ITEM.SELECT_LIST(',
'              p_idx           => 3,',
'              p_value         => null,',
'              p_list_values   => l_label_assign||'';ASSIGN,''||l_label_remove||'';REMOVE'',',
'              p_attributes    => ''class="a-Form-select apex-item-select is-label-group"'',',
'              p_show_null     => ''YES'',',
'              p_null_value    => ''NONE'',',
'              p_null_text     => l_label_select,',
'              p_item_id       => ''group_''||label_group.id,',
'              p_item_label    => ''Set ''||label_group.group_name||'' label'',',
'              p_show_extra    => ''NO'') );',
'            sys.htp.p(''</div>''); -- close .group-item',
'        end if;',
'        sys.htp.p(''<div class="group-items" role="group" data-group-id="group_''||label_group.id||''" aria-labelledby="group_''||label_group.group_slug||''">'');',
'        for label in (select id,',
'                             label_name',
'                      from wwv_flow_labels',
'                     where security_group_id = :flow_security_group_id',
'                       and label_group_id = label_group.id',
'                     order by display_sequence asc) ',
'        loop',
'            if label_group.values_are_exclusive = ''Y'' then ',
'                sys.htp.p(''<div class="group-item">'');',
'                sys.htp.p(''<label>'');',
'                sys.htp.p(''<input type="radio" ''',
'                           ||''name="''||label_group.group_slug||''_''||label_group.id||''" ''',
'                           ||''value="''||label.id||''" ''',
'                           ||''class="u-vh label-item apex-ui-selector-input ''||label_group.group_name||''" ''',
'                           ||''id="P1_R_''||label.id||''">''',
'                           || ''<span class="apex-ui-selector"></span>''',
'                           || ''<span class="a-IssueLabel ''||label_group.group_color||''">''||label.label_name||''</span>'');',
'                sys.htp.p(''</label>'');',
'                sys.htp.p(''</div>''); -- close .group-item',
'            else ',
'                sys.htp.prn(''<div class="group-item">'');',
'                sys.htp.p( APEX_ITEM.SELECT_LIST(',
'                    p_idx           => 4,',
'                    p_value         => null,',
'                    p_list_values   => l_label_assign||'';ASSIGN_''||label.id||'',''||l_label_remove||'';REMOVE_''||label.id,',
'                    p_attributes    => ''class="a-Form-select apex-item-select"'',',
'                    p_show_null     => ''YES'',',
'                    p_null_value    => ''NONE'',',
'                    p_null_text     => l_label_select,',
'                    p_item_id       => ''P1_L01_''||label.id,',
'                    p_item_label    => null,',
'                    p_show_extra    => ''NO'') );',
'                    sys.htp.p(''<label for="P1_L01_''||label.id||''">'' ||',
'                                -- ''<div class="a-TriSwitch">''||',
'                                -- ''<input id="P1_L01_''||label.id||''" type="radio" name="f''||label.id||''" value="ASSIGN_''||label.id||''"><label for="P1_L01_''||label.id||''"><span class="u-vh">Assign</span></label>''||',
'                                -- ''<input id="P1_L02_''||label.id||''" type="radio" name="f''||label.id||''" value="NONE" checked="checked"><label for="P1_L02_''||label.id||''"><span class="u-vh">None</span></label>''||',
'                                -- ''<input id="P1_L03_''||label.id||''" type="radio" name="f''||label.id||''" value="REMOVE_''||label.id||''"><label for="P1_L03_''||label.id||''"><span class="u-vh">Remove</span></label>''||',
'                                -- ''</div>''||',
'                                ''<span class="a-IssueLabel ''||label_group.group_color||''">''||label.label_name||''</span><br/>''||',
'                                ''</label>''||',
'                                ''</div> '');',
'            end if;',
'        end loop;',
'',
'        sys.htp.p(''</div>''); -- close .group-items',
'',
'        sys.htp.p(''</div>''); -- close .group',
'    end loop;',
'',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10422390008079421.4605)
,p_plug_name=>'Marco'
,p_region_name=>'milestoneDialog'
,p_region_css_classes=>'a-DialogRegion--noPadding'
,p_region_template_options=>'#DEFAULT#:js-dialog-size720x480'
,p_plug_template=>wwv_flow_api.id(10813455696794486.4605)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(22141335210602257.4605)
,p_name=>'MILESTONE'
,p_region_name=>'milestones'
,p_parent_plug_id=>wwv_flow_api.id(10422390008079421.4605)
,p_template=>wwv_flow_api.id(214132567690623104.4605)
,p_display_sequence=>10
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-ContentRowReport--hideIcons'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with messages as (',
'select',
'    wwv_flow_lang.system_message(''APEX.ISSUES.SELECT'') as label_select,',
'    wwv_flow_lang.system_message(''APEX.ISSUES.ASSIGN'') as label_assign,',
'    wwv_flow_lang.system_message(''APEX.ISSUES.REMOVE'') as label_remove',
'from dual ) ',
'select',
'  null as ITEM_CUSTOM_ATTRS,',
'  null as ITEM_CSS_MODIFIERS, ',
'  ''<label for="P1_M01_''||rownum||''">''||milestone_name||''</label>'' as ITEM_TITLE,',
'  APEX_ITEM.SELECT_LIST(',
'    p_idx           => 2,',
'    p_value         => null,',
'    p_list_values   => msg.label_assign||'';ASSIGN_''||id||'',''||msg.label_remove||'';REMOVE_''||id||'''',',
'    p_attributes    => ''class="a-Form-select apex-item-select"'',',
'    p_show_null     => ''YES'',',
'    p_null_value    => ''NONE'',',
'    p_null_text     => msg.label_select,',
'    p_item_id       => ''P1_M01_''||rownum,',
'    p_item_label    => NULL,',
'    p_show_extra    => ''NO'') ITEM_ACTIONS,',
'  case ',
'      when milestone_status = ''CLOSED'' then ''fa fa-check-square xfam-check xfam-is-success u-success-text''',
'      when milestone_status = ''OPEN'' then',
'        case ',
'             when sysdate > milestone_date  then ''fa fa-exclamation-circle xfam-warning xfam-is-danger u-danger-text''',
'             when sysdate + 15 > milestone_date then ''fa fa-warning xfam-warning xfam-is-warning u-warning-text''',
'             else ''fa fa-flag-o''',
'        end ',
'  end as ITEM_ICON,',
'  null as ITEM_LINK,',
'  case ',
'      when milestone_status = ''CLOSED'' then ''<span class="fa fa-check-square u-success-text" aria-hidden="true"></span> Closed &mdash; '' || to_char(milestone_date, ''Month DD YYYY'')',
'      when milestone_status = ''OPEN'' then',
'        case ',
'             when sysdate > milestone_date  then ''<span class="fa fa-warning u-danger-text" aria-hidden="true"></span> Past due &mdash; '' || apex_util.get_since(milestone_date)',
'             when sysdate + 15 > milestone_date then ''<span aria-hidden="true" class="fa fa-info-square u-warning-text"></span> Due &mdash; '' || apex_util.get_since(milestone_date)',
'             else ''<span aria-hidden="true" class="fa fa-calendar-o"></span> Due &mdash; '' || apex_util.get_since(milestone_date)',
'        end ',
'  end as ITEM_DESCRIPTION,',
'',
'  -- apex_util.get_since(milestone_date) as ITEM_DESCRIPTION,',
'  null as ITEM_MISC,',
'  null as ITEM_SELECTION',
'  ',
'  from wwv_flow_milestones m, messages msg',
' where security_group_id = :flow_security_group_id',
' order by milestone_date asc',
''))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(6811165341870886.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(11058708634101631.4605)
,p_query_column_id=>1
,p_column_alias=>'ITEM_CUSTOM_ATTRS'
,p_column_display_sequence=>1
,p_column_heading=>'Atributos Personalizados de Itens'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(11059111240101631.4605)
,p_query_column_id=>2
,p_column_alias=>'ITEM_CSS_MODIFIERS'
,p_column_display_sequence=>2
,p_column_heading=>'Modificadores de Css de Itens'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(11059959894101632.4605)
,p_query_column_id=>3
,p_column_alias=>'ITEM_TITLE'
,p_column_display_sequence=>4
,p_column_heading=>unistr('T\00EDtulo do Item')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(11061998264101637.4605)
,p_query_column_id=>4
,p_column_alias=>'ITEM_ACTIONS'
,p_column_display_sequence=>9
,p_column_heading=>unistr('A\00E7\00F5es do Item')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(11060330192101632.4605)
,p_query_column_id=>5
,p_column_alias=>'ITEM_ICON'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\00CDcone do Item')
,p_use_as_row_header=>'N'
,p_column_html_expression=>'fa-lg #ITEM_ICON#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(11060763408101635.4605)
,p_query_column_id=>6
,p_column_alias=>'ITEM_LINK'
,p_column_display_sequence=>6
,p_column_heading=>'Link de Item'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(11061134833101635.4605)
,p_query_column_id=>7
,p_column_alias=>'ITEM_DESCRIPTION'
,p_column_display_sequence=>7
,p_column_heading=>unistr('Descri\00E7\00E3o do Item')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(11061564234101635.4605)
,p_query_column_id=>8
,p_column_alias=>'ITEM_MISC'
,p_column_display_sequence=>8
,p_column_heading=>'Diversos Itens'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(11059549127101632.4605)
,p_query_column_id=>9
,p_column_alias=>'ITEM_SELECTION'
,p_column_display_sequence=>3
,p_column_heading=>unistr('Sele\00E7\00E3o de Item')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10422678430079424.4605)
,p_plug_name=>'Designar '
,p_region_name=>'assignDialog'
,p_region_css_classes=>'a-DialogRegion--noPadding'
,p_region_template_options=>'#DEFAULT#:js-dialog-size720x480'
,p_plug_template=>wwv_flow_api.id(10813455696794486.4605)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(10424237842079440.4605)
,p_name=>'ASIGNEES'
,p_parent_plug_id=>wwv_flow_api.id(10422678430079424.4605)
,p_template=>wwv_flow_api.id(214132567690623104.4605)
,p_display_sequence=>10
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-ContentRowReport--hideIcons'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with messages as (',
'select',
'    wwv_flow_lang.system_message(''APEX.ISSUES.SELECT'') as label_select,',
'    wwv_flow_lang.system_message(''APEX.ISSUES.ASSIGN'') as label_assign,',
'    wwv_flow_lang.system_message(''APEX.ISSUES.REMOVE'') as label_remove',
'from dual )',
'select',
'  null as ITEM_CUSTOM_ATTRS,',
'  null as ITEM_CSS_MODIFIERS,',
'  ''<label for="P1_A01_''||rownum||''">'' || wwv_flow_issue_int.get_avatar (p_user_name => user_name, p_include_name => ''Y'') || ''</label>'' as ITEM_TITLE,  ',
'  APEX_ITEM.SELECT_LIST(',
'    p_idx           => 1,',
'    p_value         => null,',
'    p_list_values   => msg.label_assign||'';ASSIGN_''||user_name||'',''||msg.label_remove||'';REMOVE_''||user_name||'''',',
'    p_attributes    => ''class="a-Form-select apex-item-select"'',',
'    p_show_null     => ''YES'',',
'    p_null_value    => ''NONE'',',
'    p_null_text     => msg.label_select,',
'    p_item_id       => ''P1_A01_''||rownum,',
'    p_item_label    => NULL,',
'    p_show_extra    => ''NO'') ITEM_ACTIONS,',
'  null as ITEM_ICON,',
'  null as ITEM_LINK,',
'  null as ITEM_DESCRIPTION,',
'  null as ITEM_MISC,',
'  null as ITEM_SELECTION',
'  from wwv_flow_fnd_user u, messages msg',
'  where security_group_id = :flow_security_group_id',
'',
'',
''))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(6811165341870886.4605)
,p_query_num_rows=>10000
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10424304640079441.4605)
,p_query_column_id=>1
,p_column_alias=>'ITEM_CUSTOM_ATTRS'
,p_column_display_sequence=>1
,p_column_heading=>'Atributos Personalizados de Itens'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10424482366079442.4605)
,p_query_column_id=>2
,p_column_alias=>'ITEM_CSS_MODIFIERS'
,p_column_display_sequence=>2
,p_column_heading=>'Modificadores de Css de Itens'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10861483880686810.4605)
,p_query_column_id=>3
,p_column_alias=>'ITEM_TITLE'
,p_column_display_sequence=>8
,p_column_heading=>unistr('T\00EDtulo do Item')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10425187285079449.4605)
,p_query_column_id=>4
,p_column_alias=>'ITEM_ACTIONS'
,p_column_display_sequence=>7
,p_column_heading=>unistr('A\00E7\00F5es do Item')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10424789792079445.4605)
,p_query_column_id=>5
,p_column_alias=>'ITEM_ICON'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\00CDcone do Item')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10424805175079446.4605)
,p_query_column_id=>6
,p_column_alias=>'ITEM_LINK'
,p_column_display_sequence=>4
,p_column_heading=>'Link de Item'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10424995467079447.4605)
,p_query_column_id=>7
,p_column_alias=>'ITEM_DESCRIPTION'
,p_column_display_sequence=>5
,p_column_heading=>unistr('Descri\00E7\00E3o do Item')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10425021215079448.4605)
,p_query_column_id=>8
,p_column_alias=>'ITEM_MISC'
,p_column_display_sequence=>6
,p_column_heading=>'Diversos Itens'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(499483267980605008.4605)
,p_query_column_id=>9
,p_column_alias=>'ITEM_SELECTION'
,p_column_display_sequence=>9
,p_column_heading=>unistr('Sele\00E7\00E3o de Item')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10422744982079425.4605)
,p_plug_name=>'Nenhum Problema Selecionado'
,p_region_name=>'noSelectionDialog'
,p_region_template_options=>'#DEFAULT#:js-dialog-size480x320'
,p_plug_template=>wwv_flow_api.id(10813455696794486.4605)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source=>unistr('Selecione um ou mais Problemas para executar uma opera\00E7\00E3o de atualiza\00E7\00E3o em massa. Selecione pelo menos um problema e tente novamente.')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(15607707130231509.4605)
,p_name=>'Feedback'
,p_template=>wwv_flow_api.id(179998957300224011.4605)
,p_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-BadgeList--fixed:a-BadgeList--large'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'(select count(security_group_id||created_by) entries',
'   from wwv_flow_feedback f',
'  where f.security_group_id = :FLOW_SECURITY_GROUP_ID) total,',
'(select count(security_group_id||created_by)',
'   from wwv_flow_feedback f',
'  where f.security_group_id = :FLOW_SECURITY_GROUP_ID',
'    and feedback_status != 4) open',
'from dual'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(1046845011939553934.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(15581219341474516.4605)
,p_query_column_id=>1
,p_column_alias=>'TOTAL'
,p_column_display_sequence=>1
,p_column_heading=>'Total'
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=4650:8012:&SESSION.::&DEBUG.:RP,8012::'
,p_column_linktext=>'#TOTAL#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(15581339109474517.4605)
,p_query_column_id=>2
,p_column_alias=>'OPEN'
,p_column_display_sequence=>2
,p_column_heading=>'Abrir'
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=4650:8012:&SESSION.::&DEBUG.:RP,8012::'
,p_column_linktext=>'#OPEN#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(10422836863079426.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(10422744982079425.4605)
,p_button_name=>'CANCEL_ERROR'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(10860533434686801.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(10422678430079424.4605)
,p_button_name=>'CANCEL_ASSIGNEES'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(10861506186686811.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(10422390008079421.4605)
,p_button_name=>'CANCEL_MILESTONES'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(10423113777079429.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(4926428596003033.4605)
,p_button_name=>'CANCEL_STATUS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(11140656805970428.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(10422245393079420.4605)
,p_button_name=>'CANCEL_LABELS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
end;
/
begin
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(10423258900079430.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(4926428596003033.4605)
,p_button_name=>'APPLY_STATUS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(11140770668970429.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(10422245393079420.4605)
,p_button_name=>'APPLY_LABELS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(10425263415079450.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(10422678430079424.4605)
,p_button_name=>'APPLY_ASSIGNEES'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(10861699421686812.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(10422390008079421.4605)
,p_button_name=>'APPLY_MILESTONES'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(156399999666150702.4605)
,p_branch_name=>'Go To Page Team Dev if END USER'
,p_branch_action=>'f?p=4600:2000:&SESSION.::&DEBUG.:::'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'FUNCTION_BODY'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_is_end_user varchar2(1) := ''N'';',
'begin ',
'',
'    for l_user in ( select user_name,',
'                       security_group_id',
'                  from wwv_flow_fnd_user',
'                 where user_name = :APP_USER',
'                   and security_group_id = :flow_security_group_id )',
'    loop',
'         if  l_user.security_group_id=''10'' then ',
'             l_is_end_user := ''N'';',
'         elsif wwv_flow_fnd_user_int.get_user_roles (p_security_group_id => l_user.security_group_id,p_username => l_user.user_name ) is null then ',
'             l_is_end_user := ''Y'';',
'         else ',
'            l_is_end_user := ''N'';',
'         end if;',
'    end loop;',
'    if l_is_end_user = ''Y'' then ',
'        return TRUE;',
'    else ',
'        return FALSE;',
'    end if;',
'end;'))
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(598174128609635601.4605)
,p_branch_name=>'Redirect to Welcome Page'
,p_branch_action=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:RP,10::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'FUNCTION_BODY'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_count  number;',
'    l_template_count number;',
'    l_label_count number;',
'    l_milestone_count number;',
'    ',
'begin ',
'    -- Issues',
'    select count(*)',
'      into l_issue_count',
'      from wwv_flow_issues',
'     where security_group_id = :flow_security_group_id;',
'    -- Labels',
'    select count(*)',
'      into l_label_count',
'      from wwv_flow_label_groups',
'     where security_group_id = :flow_security_group_id;',
'    -- templates',
'    select count(*)',
'      into l_template_count',
'      from wwv_flow_issue_templates',
'     where security_group_id = :flow_security_group_id;',
'    -- milestones',
'    select count(*)',
'      into l_milestone_count',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id;',
'',
'return NOT (l_issue_count >0 or l_label_count >0 or l_template_count > 0 or l_milestone_count > 0);',
'',
'end;'))
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(10423739440079435.4605)
,p_name=>'P1_SELECTED_ISSUES'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(5402528899234735.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(10860827363686804.4605)
,p_name=>'P1_ASSIGNEES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(10422678430079424.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(10862171718686817.4605)
,p_name=>'P1_MILESTONES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(10422390008079421.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(10862790753686823.4605)
,p_name=>'P1_SELECTED_STATUS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(4926428596003033.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(11141256505970434.4605)
,p_name=>'P1_LABELS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(10422245393079420.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(156404123007150744.4605)
,p_name=>'P1_APPLICATION_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5402528899234735.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
,p_item_comment=>'Used to filter the interactive grid.'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(156404221186150745.4605)
,p_name=>'P1_PAGE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5402528899234735.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
,p_item_comment=>'Used to filter the interactive grid.'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(499483349427605009.4605)
,p_name=>'P1_STATUS'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(4926428596003033.4605)
,p_prompt=>'Status'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LOCALIZED OPEN CLOSED'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.OPEN'') d, ''OPEN'' r ',
'from dual',
'UNION',
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.CLOSED'') d, ''CLOSED'' r ',
'from dual'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Selecionar -'
,p_lov_null_value=>'NONE'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(165798641973198807.4605)
,p_computation_sequence=>10
,p_computation_item=>'P1_APPLICATION_ID'
,p_computation_point=>'AFTER_FOOTER'
,p_computation=>'null'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(165798716780198808.4605)
,p_computation_sequence=>20
,p_computation_item=>'P1_PAGE_ID'
,p_computation_point=>'AFTER_FOOTER'
,p_computation=>'null'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(10422950921079427.4605)
,p_name=>'Close Dialog'
,p_event_sequence=>50
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(10422836863079426.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(10423047637079428.4605)
,p_event_id=>wwv_flow_api.id(10422950921079427.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CLOSE_REGION'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(10422744982079425.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(10423573307079433.4605)
,p_name=>'Close Status Dialog'
,p_event_sequence=>60
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(10423113777079429.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(10423630195079434.4605)
,p_event_id=>wwv_flow_api.id(10423573307079433.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.item(''P1_STATUS'').setValue(''NONE'');',
'apex.theme.closeRegion("statusDialog");'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(10423871357079436.4605)
,p_name=>'Apply Status Changes'
,p_event_sequence=>70
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(10423258900079430.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(10423940713079437.4605)
,p_event_id=>wwv_flow_api.id(10423871357079436.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var status = $("#P1_STATUS")[0];',
'var myIssues = getSelectedIds();',
'var myChecked = '''';',
'',
'if (status.value !== ''NONE'') {',
'  myChecked = status.value;',
'}',
'',
'apex.page.submit({',
'    request: "APPLY_STATUS",',
'        set: {',
'            "P1_SELECTED_ISSUES": myIssues,',
'            "P1_SELECTED_STATUS": myChecked',
'        },',
'        showWait: true,',
'} );',
'    ',
'    '))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(10860629415686802.4605)
,p_name=>'Close Assignee Dialog'
,p_event_sequence=>80
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(10860533434686801.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(10860729796686803.4605)
,p_event_id=>wwv_flow_api.id(10860629415686802.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CLOSE_REGION'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(10422678430079424.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(10860929671686805.4605)
,p_name=>'Apply Assignee Changes'
,p_event_sequence=>90
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(10425263415079450.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(10861015427686806.4605)
,p_event_id=>wwv_flow_api.id(10860929671686805.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var mySelection = $("#assignDialog select").filter("[id^=P1_A]");',
'var myIssues = getSelectedIds();',
'var myChecked = '''';',
'',
'for  (var i=0; i<mySelection.length; i++)  {',
'  if (mySelection[i].value !== ''NONE'') {',
'      myChecked = myChecked + mySelection[i].value + '':'';',
'  }',
'}',
'',
'//',
'apex.page.submit({',
'    request: "APPLY_ASSIGNEES",',
'        set: {',
'            "P1_SELECTED_ISSUES": myIssues,',
'            "P1_ASSIGNEES": myChecked',
'        },',
'        showWait: true,',
'} );',
''))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(10861708893686813.4605)
,p_name=>'Close Milestone Dialog'
,p_event_sequence=>100
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(10861506186686811.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(10861848499686814.4605)
,p_event_id=>wwv_flow_api.id(10861708893686813.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CLOSE_REGION'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(10422390008079421.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(10861916311686815.4605)
,p_name=>'Apply Assign Milestones'
,p_event_sequence=>110
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(10861699421686812.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(10862089533686816.4605)
,p_event_id=>wwv_flow_api.id(10861916311686815.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var mySelection = $("#milestoneDialog select").filter("[id^=P1_M]");',
'var myIssues = getSelectedIds();',
'myChecked = '''';',
'',
'for  (var i=0; i<mySelection.length; i++)  {',
'  if (mySelection[i].value !== ''NONE'') {',
'      myChecked = myChecked + mySelection[i].value + '':'';',
'  }',
'}',
'',
'//',
'apex.page.submit({',
'    request: "APPLY_MILESTONES",',
'        set: {',
'            "P1_SELECTED_ISSUES": myIssues,',
'            "P1_MILESTONES": myChecked',
'        },',
'        showWait: true,',
'} );'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(11140869150970430.4605)
,p_name=>'Close Label Dialog'
,p_event_sequence=>120
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(11140656805970428.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(11140940424970431.4605)
,p_event_id=>wwv_flow_api.id(11140869150970430.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CLOSE_REGION'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(10422245393079420.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(11141058440970432.4605)
,p_name=>'Apply Label Changes'
,p_event_sequence=>130
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(11140770668970429.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(11141101886970433.4605)
,p_event_id=>wwv_flow_api.id(11141058440970432.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var applyChanges = function (myChecked, myIssues) {',
'	apex.page.submit({',
'        request: "APPLY_LABELS",',
'        set: {',
'          "P1_SELECTED_ISSUES": myIssues,',
'          "P1_LABELS": myChecked',
'        },',
'        showWait: true,',
'      });',
'};',
'',
'var displayWarning = ''N'';',
'',
'// Do validations for',
'//  - Exclusive groups with an action selected but no radios checked',
'$(".is-exclusive > .group-item").each(function() {',
'	var currentGroup$ = $(this);',
'	var exclusiveGroupSelect$ = currentGroup$.find(".is-label-group");',
'	if (exclusiveGroupSelect$.val() !== "NONE") {',
'		var exclusiveGroupRadios$ = exclusiveGroupSelect$.parents(".group-item").next().find("input:radio");',
'		var radioChecked = ''N'';',
'		exclusiveGroupRadios$.each(function() {',
'			if ($(this).prop("checked")) {',
'				radioChecked = ''Y'';',
'			}',
'		});',
'		if (radioChecked === ''N'') {',
'			displayWarning = ''Y'';',
'			return;',
'		}',
'	}',
'});',
'',
'',
'// Generate request string',
'var myChecked = '''';',
'// Take care of the non-exclusive first - its easier.',
'// Loop through the non-exclusives',
'$(".group-item > select").filter("[id^=P1_L]").each(function() {',
'	if ($(this).val() !== "NONE") {',
'		myChecked = myChecked + $(this).val() + '':''; ',
'	}',
'});',
'',
'',
'$(".is-label-group").each(function (){',
'	var currentSelect$ = $(this);',
'	if (currentSelect$.val() !== "NONE"){',
'		var currentGroupRadios$ = currentSelect$.parents(".group-item").next().find("input:radio");',
'		currentGroupRadios$.each(function (){',
'			if ($(this).prop("checked")) {',
'				if ($(this).val() !== "NONE") {',
'					myChecked = myChecked + currentSelect$.val() + ''_'' + $(this).val() + '':'';',
'				}',
'			}',
'		})',
'	}',
'})',
'',
'',
'if (displayWarning == ''Y'') {',
'  apex.message.confirm("One or more exclusive Lable Group has an Action selected with no Value. This will result in no action being taken for the affected Group(s). Do you wish to continue?", function(okPressed) {',
'    if (okPressed) {',
'    	applyChanges(myChecked, getSelectedIds());',
'    }',
'  });',
'} else {',
'	applyChanges(myChecked, getSelectedIds());',
'}',
''))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2567474003359406323.4605)
,p_name=>'Grid Enable / Disable Multi Update Button'
,p_event_sequence=>160
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(5402528899234735.4605)
,p_bind_type=>'live'
,p_bind_event_type=>'NATIVE_IG|REGION TYPE|interactivegridselectionchange'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2567474137739406324.4605)
,p_event_id=>wwv_flow_api.id(2567474003359406323.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var records = apex.region("issues").call("getSelectedRecords");',
'var selectedCount = records ? records.length : 0;',
'apex.region("issues").call("getToolbar").toolbar("findElement", "multi_edit_issues").prop("disabled", selectedCount === 0);',
'// note just enabling/disabling the Update button doesn''t stop use of the actions such asopen-status-dialog ',
'// could disable the actions but not critical because there is the dialog that tells you there is no selection.'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(499483041333605006.4605)
,p_name=>'Disable Issue Update Menu Button'
,p_event_sequence=>170
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(499483146523605007.4605)
,p_event_id=>wwv_flow_api.id(499483041333605006.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.region("issues").call("getToolbar").toolbar("findElement", "multi_edit_issues").prop("disabled", true);'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(499483433817605010.4605)
,p_name=>'Handle Exclusive Group Updates'
,p_event_sequence=>180
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'select.is-label-group'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(499483505727605011.4605)
,p_event_id=>wwv_flow_api.id(499483433817605010.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var status = this.triggeringElement.value;',
'var groupItem$ = $(this.triggeringElement).parents(".group-item").next(".group-items");',
'var groupRadios$ = groupItem$.find("input:radio");',
'',
'if (status === ''NONE'') {',
'    groupRadios$.prop("disabled",true).prop("checked",false);',
'    groupItem$.addClass("is-disabled");',
'} else {',
'    groupRadios$.prop("disabled",false);',
'    groupItem$.removeClass("is-disabled");    ',
'}',
''))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2567473477607406317.4605)
,p_name=>'Init label dialog'
,p_event_sequence=>190
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2567473508349406318.4605)
,p_event_id=>wwv_flow_api.id(2567473477607406317.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$("#labelDialog").dialog({',
' open: function(){',
'    var labelGroupSelects$ = $(".is-label-group"),',
'        exclGroupItems$ = labelGroupSelects$.parents(".group-item").next();',
'',
'    labelGroupSelects$.val("NONE");',
'    exclGroupItems$.find("input:radio").prop("disabled",true).prop("checked",false);',
'    exclGroupItems$.addClass("is-disabled");',
' }',
'});',
''))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2567473797919406320.4605)
,p_name=>'Grid view activate to open'
,p_event_sequence=>200
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(5402528899234735.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'custom'
,p_bind_event_type_custom=>'gridactivatecell'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2567473807238406321.4605)
,p_event_id=>wwv_flow_api.id(2567473797919406320.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var rec, meta, link,',
'    issuesIG = apex.region("issues"),',
'    view =  issuesIG.call("getCurrentView"), // this will be the grid view',
'    model = view.model;',
'',
'rec = view.getContextRecord(this.browserEvent.originalEvent.target);',
'meta = model.getRecordMetadata(model.getRecordId(rec[0]));',
'if (meta && meta.fields.TITLE) {',
'    apex.navigation.redirect(meta.fields.TITLE.url);',
'}',
''))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(581219589628849523.4605)
,p_name=>'New'
,p_event_sequence=>210
,p_bind_type=>'bind'
,p_bind_event_type=>'resize'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(581219666266849524.4605)
,p_event_id=>wwv_flow_api.id(581219589628849523.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.region("issues").call("resize")',
''))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(10423487360079432.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Apply Status'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issues     apex_t_varchar2 := apex_string.split(:P1_SELECTED_ISSUES, '':'');',
'    l_status     varchar2(100);',
'begin ',
'',
'l_status := trim(BOTH '':'' FROM :P1_SELECTED_STATUS);',
'if l_status in (''OPEN'',''CLOSED'') then ',
'    for i in 1..l_issues.count loop',
'        -- ',
'        wwv_flow_issue_int.set_status(p_issue_id => l_issues(i), p_status_id => l_status); ',
'        --',
'',
'    end loop;',
'end if;',
'    :P1_SELECTED_ISSUES:= '''';',
'end;',
''))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel atualizar o Status dos Problemas selecionados.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(10423258900079430.4605)
,p_process_success_message=>'Status atualizado para problemas selecionados;'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(10861239138686808.4605)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Apply Assignees'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issues     apex_t_varchar2 := apex_string.split(:P1_SELECTED_ISSUES, '':'');',
'    l_assignees  apex_t_varchar2 := apex_string.split(:P1_ASSIGNEES, '':'');',
'    l_assign     apex_t_varchar2 := apex_t_varchar2();',
'    l_assign_cnt number := 0;',
'    l_remove     apex_t_varchar2 := apex_t_varchar2();',
'    l_remove_cnt number := 0;',
'begin ',
'',
'if :P1_ASSIGNEES is not null then ',
'    -- First loop through the assignees and sort the ASSIGN from the REMOVE.',
'    for a in 1..l_assignees.count loop',
'        if substr(l_assignees(a),1,6) = ''ASSIGN'' then ',
'           l_assign_cnt := l_assign_cnt +1;',
'           l_assign.extend;',
'           l_assign(l_assign_cnt) := substr(l_assignees(a),8);',
'        elsif substr(l_assignees(a),1,6) = ''REMOVE'' then ',
'           l_remove_cnt := l_remove_cnt +1;',
'           l_remove.extend;',
'           l_remove(l_remove_cnt) := substr(l_assignees(a),8);',
'        else',
'           null; -- Igonre anything that got in accidentally',
'        end if;',
'    end loop;',
'    --Now loop through each selected issue',
'    for i in 1..l_issues.count loop',
'        -- call the ADD_ASSIGNEES function ',
'        if l_assign_cnt > 0 then ',
'            wwv_flow_issue_int.add_assignees(p_issue_id => l_issues(i), p_assignee_ids => apex_string.join(p_table => l_assign, p_sep => '':'' )); ',
'        end if;',
'        -- loop through all REMOVALS and remove them',
'        if l_remove_cnt > 0 then ',
'            wwv_flow_issue_int.remove_assignees(p_issue_id => l_issues(i), p_assignee_ids => apex_string.join(p_table => l_remove, p_sep => '':'' )); ',
'        end if;',
'    end loop;',
'end if;',
'-- clean up session state',
'    :P1_SELECTED_ISSUES:= '''';',
'    :P1_ASSIGNEES := '''';',
'end;',
''))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel atualizar os Favorecidos dos Problemas selecionados.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(10425263415079450.4605)
,p_process_success_message=>'Favorecidos atualizados para Problemas selecionados.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(10862200430686818.4605)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Apply Milestones'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issues     apex_t_varchar2 := apex_string.split(:P1_SELECTED_ISSUES, '':'');',
'    l_milestones apex_t_varchar2 := apex_string.split(:P1_MILESTONES, '':'');',
'    l_assign     apex_t_varchar2 := apex_t_varchar2();',
'    l_assign_cnt number := 0;',
'    l_remove     apex_t_varchar2 := apex_t_varchar2();',
'    l_remove_cnt number := 0;',
'begin ',
'',
'if :P1_MILESTONES is not null then ',
'    -- First loop through the MILESTONES and sort the ASSIGN from the REMOVE.',
'    for a in 1..l_milestones.count loop',
'        if substr(l_milestones(a),1,6) = ''ASSIGN'' then ',
'           l_assign_cnt := l_assign_cnt +1;',
'           l_assign.extend;',
'           l_assign(l_assign_cnt) := substr(l_milestones(a),8);',
'        elsif substr(l_milestones(a),1,6) = ''REMOVE'' then ',
'           l_remove_cnt := l_remove_cnt +1;',
'           l_remove.extend;',
'           l_remove(l_remove_cnt) := substr(l_milestones(a),8);',
'        else',
'           null; -- Igonre anything that got in accidentally',
'        end if;',
'    end loop;',
'    --Now loop through each selected issue',
'    for i in 1..l_issues.count loop',
'        -- call the ADD_MILESTONES function ',
'        if l_assign_cnt > 0 then ',
'            wwv_flow_issue_int.add_milestones(p_issue_id => l_issues(i), p_milestone_ids => apex_string.join(p_table => l_assign, p_sep => '':'' )); ',
'        end if;',
'        -- loop through all REMOVALS and remove them',
'        if l_remove_cnt > 0 then ',
'            wwv_flow_issue_int.remove_milestones(p_issue_id => l_issues(i), p_milestone_ids => apex_string.join(p_table => l_remove, p_sep => '':'' )); ',
'        end if;',
'    end loop;',
'end if;',
'-- clean up session state',
'    :P1_SELECTED_ISSUES:= '''';',
'    :P1_MILESTONES := '''';',
'end;',
''))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel atualizar os Marcos dos Problemas selecionados.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(10861699421686812.4605)
,p_process_success_message=>'Marcos atualizados para problemas selecionados.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(11141350269970435.4605)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Apply Labels'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issues     apex_t_varchar2 := apex_string.split(:P1_SELECTED_ISSUES, '':'');',
'    l_labels apex_t_varchar2 := apex_string.split(:P1_LABELS, '':'');',
'    l_assign     apex_t_varchar2 := apex_t_varchar2();',
'    l_assign_cnt number := 0;',
'    l_remove     apex_t_varchar2 := apex_t_varchar2();',
'    l_remove_cnt number := 0;',
'begin ',
'',
'if :P1_LABELS is not null then ',
'    -- First loop through the LABELS and sort the ASSIGN from the REMOVE.',
'    for a in 1..l_labels.count loop',
'        if substr(l_labels(a),1,6) = ''ASSIGN'' then ',
'           l_assign_cnt := l_assign_cnt +1;',
'           l_assign.extend;',
'           l_assign(l_assign_cnt) := substr(l_labels(a),8);',
'        elsif substr(l_labels(a),1,6) = ''REMOVE'' then ',
'           l_remove_cnt := l_remove_cnt +1;',
'           l_remove.extend;',
'           l_remove(l_remove_cnt) := substr(l_labels(a),8);',
'        else',
'           null; -- Igonre anything that got in accidentally',
'        end if;',
'    end loop;',
'    -- Now loop through each selected issue',
'    for i in 1..l_issues.count loop',
'        -- call the ADD_MILESTONES function ',
'        if l_assign_cnt > 0 then ',
'            wwv_flow_issue_int.add_labels(p_issue_id => l_issues(i), p_label_ids => apex_string.join(p_table => l_assign, p_sep => '':'' )); ',
'        end if;',
'        -- loop through all REMOVALS and remove them',
'        if l_remove_cnt > 0 then ',
'            wwv_flow_issue_int.remove_labels(p_issue_id => l_issues(i), p_label_ids => apex_string.join(p_table => l_remove, p_sep => '':'' )); ',
'        end if;',
'    end loop;',
'end if;',
'-- clean up session state',
'    --:P1_SELECTED_ISSUES:= '''';',
'    --:P1_LABELS := '''';',
'end;',
''))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel atualizar os Labels dos Problemas selecionados.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(11140770668970429.4605)
,p_process_success_message=>'Labels atualizados para os Problemas selecionados.'
);
end;
/
prompt --application/pages/page_00010
begin
wwv_flow_api.create_page(
 p_id=>10.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>unistr('P\00E1gina de Boas-Vindas')
,p_step_title=>'Bem-vindo ao Team Development'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-Alert--horizontal .a-Alert-title {',
'    font-size: 14px;',
'    font-weight: 600;',
'}',
'',
'.a-Alert--horizontal.a-Alert--inline {',
'    border-width: 0;',
'}',
'',
'.a-Alert--inline.a-Alert--horizontal .a-Alert-body p {',
'    flex-grow: 1;',
'}',
'',
'.a-Alert--inline.a-Alert--horizontal  .a-Form-fieldContainer {',
'    text-align: right;',
'    flex-shrink: 0;',
'}',
'.a-Alert--inline.a-Alert--horizontal  .a-Form-fieldContainer.apex-item-wrapper--yes-no {',
'    flex-basis: 64px;',
'}',
'.a-Alert--inline.a-Alert--horizontal  .a-Form-fieldContainer.apex-item-wrapper--select-list {',
'    flex-basis: 180px;',
'}',
'',
'.a-Alert--inline.a-Alert--horizontal .a-Alert-buttons {',
'    display: none;',
'}',
'',
'.a-Alert--inline.a-Alert--horizontal .a-Alert-body {',
'    display: flex;',
'    align-items: center;',
'}'))
,p_step_template=>wwv_flow_api.id(707892828837195217.4605)
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(597618556777219101.4605)
,p_plug_name=>'Bem-vindo ao Team Development'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(708692623972319459.4605)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(597619604653219112.4605)
,p_plug_name=>unistr('Op\00E7\00F5es')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(597618807525219104.4605)
,p_plug_name=>'Install Sample Labels'
,p_parent_plug_id=>wwv_flow_api.id(597619604653219112.4605)
,p_region_css_classes=>'a-Alert--inline margin-top-md'
,p_icon_css_classes=>'fa-lg fa-tags'
,p_region_template_options=>'a-Alert--info:a-Alert--horizontal:a-Form--leftLabels:a-Form--autoWidthLabels'
,p_plug_template=>wwv_flow_api.id(775445099592054705.4605)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>O Team Development usa Grupos de Labels e Labels para ajudar os usu\00E1rios a classificar problemas. \00C9 poss\00EDvel criar um conjunto inicial de Grupos de Labels e Labels para voc\00EA.</p>')
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(597619013461219106.4605)
,p_plug_name=>'Install Sample Templates'
,p_parent_plug_id=>wwv_flow_api.id(597619604653219112.4605)
,p_region_css_classes=>'a-Alert--inline'
,p_icon_css_classes=>'fa-lg fa-synonym'
,p_region_template_options=>'a-Alert--info:a-Alert--horizontal:a-Form--leftLabels:a-Form--autoWidthLabels'
,p_plug_template=>wwv_flow_api.id(775445099592054705.4605)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Os modelos permitem que os usu\00E1rios tratem de problemas ou gerem respostas rapidamente com base em texto edit\00E1vel. \00C9 poss\00EDvel criar um conjunto inicial de Modelos para voc\00EA.</p>')
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(597619275441219108.4605)
,p_plug_name=>'Install Sample Milestones'
,p_parent_plug_id=>wwv_flow_api.id(597619604653219112.4605)
,p_region_css_classes=>'a-Alert--inline'
,p_icon_css_classes=>'fa-lg fa-map-signs'
,p_region_template_options=>'a-Alert--info:a-Alert--horizontal:a-Form--leftLabels:a-Form--autoWidthLabels'
,p_plug_template=>wwv_flow_api.id(775445099592054705.4605)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Os marcos ajudam a rastrear datas importantes com rela\00E7\00E3o \00E0s quais os Problemas podem ser designados e rastreados. \00C9 poss\00EDvel criar uma amostra de conjunto de marcos para voc\00EA.</p>')
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(597619501199219111.4605)
,p_plug_name=>'Sample Data Language'
,p_parent_plug_id=>wwv_flow_api.id(597619604653219112.4605)
,p_region_css_classes=>'a-Alert--inline'
,p_icon_css_classes=>'fa-lg fa-language'
,p_region_template_options=>'a-Alert--info:a-Alert--horizontal:a-Form--leftLabels:a-Form--autoWidthLabels'
,p_plug_template=>wwv_flow_api.id(775445099592054705.4605)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Selecione um idioma a ser usado para as amostras de labels, marcos e modelos.</p>',
''))
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(753994592734338714.4605)
,p_plug_name=>unistr('Assistente de Introdu\00E7\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(47229974494774989.4605)
,p_plug_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_count  number;',
'    l_template_count number;',
'    l_label_count number;',
'    l_milestone_count number;',
'    ',
'begin ',
'    -- Issues',
'    select count(*)',
'      into l_issue_count',
'      from wwv_flow_issues',
'     where security_group_id = :flow_security_group_id;',
'    -- Labels',
'    select count(*)',
'      into l_label_count',
'      from wwv_flow_label_groups',
'     where security_group_id = :flow_security_group_id;',
'    -- templates',
'    select count(*)',
'      into l_template_count',
'      from wwv_flow_issue_templates',
'     where security_group_id = :flow_security_group_id;',
'    -- milestones',
'    select count(*)',
'      into l_milestone_count',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id;',
'',
'return NOT (l_issue_count >0 or l_label_count >0 or l_template_count > 0 or l_milestone_count > 0);',
'',
'end;'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(753994648420338715.4605)
,p_plug_name=>'Welcome Text'
,p_region_css_classes=>'a-Wizard-subTitle'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>O Team Development foi repensado como uma nova forma de trabalhar em conjunto no APEX! Voc\00EA pode facilmente acompanhar tarefas, funcionalidades, bugs e feedback de toda a sua equipe, tudo em um s\00F3 local! Ele foi projetado para ser mais simples do ')
||unistr('que antes, mas avan\00E7ado e flex\00EDvel o suficiente para ser uma parte essencial do seu processo de desenvolvimento! Tenha um in\00EDcio r\00E1pido, selecionando as op\00E7\00F5es de configura\00E7\00E3o abaixo!</p>')
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(753996721605338736.4605)
,p_plug_name=>unistr('Cont\00EAiner de Bot\00F5es')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI:a-ButtonRegion--accessibleTitle'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(597599024765188045.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(753996721605338736.4605)
,p_button_name=>'SETUP'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Concluir Configura\00E7\00E3o')
,p_button_position=>'REGION_TEMPLATE_CHANGE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(597618653661219102.4605)
,p_branch_name=>'Already Completed Setup'
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP,1::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'FUNCTION_BODY'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_count  number;',
'    l_template_count number;',
'    l_label_count number;',
'    l_milestone_count number;',
'    ',
'begin ',
'    -- Issues',
'    select count(*)',
'      into l_issue_count',
'      from wwv_flow_issues',
'     where security_group_id = :flow_security_group_id;',
'    -- Labels',
'    select count(*)',
'      into l_label_count',
'      from wwv_flow_label_groups',
'     where security_group_id = :flow_security_group_id;',
'    -- templates',
'    select count(*)',
'      into l_template_count',
'      from wwv_flow_issue_templates',
'     where security_group_id = :flow_security_group_id;',
'    -- milestones',
'    select count(*)',
'      into l_milestone_count',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id;',
'',
'return (l_issue_count > 0 or l_label_count > 0 or l_template_count > 0 or l_milestone_count > 0);',
'',
'end;'))
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(597594702973188029.4605)
,p_name=>'P10_INSTALL_LABELS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(597618807525219104.4605)
,p_item_default=>'Y'
,p_prompt=>unistr('Instalar Labels Padr\00E3o')
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(571215478963548485.4605)
,p_item_css_classes=>'a-Form-fieldContainer--noPadding'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(597595579273188033.4605)
,p_name=>'P10_INSTALL_TEMPLATES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(597619013461219106.4605)
,p_item_default=>'Y'
,p_prompt=>unistr('Instalar Modelos Padr\00E3o')
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(571215478963548485.4605)
,p_item_css_classes=>'a-Form-fieldContainer--noPadding'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(597596300982188035.4605)
,p_name=>'P10_INSTALL_MILESTONES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(597619275441219108.4605)
,p_item_default=>'Y'
,p_prompt=>'Instalar Amostras de Marcos'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(571215478963548485.4605)
,p_item_css_classes=>'a-Form-fieldContainer--noPadding'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(597597969744188042.4605)
,p_name=>'P10_LANGUAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(597619501199219111.4605)
,p_item_default=>'APEX_UTIL.GET_SESSION_LANG'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Idioma da Amostra de Dados'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  l.translated_lang_name d, f.flow_language r',
'                  from ( select flow_language',
'                           from wwv_flows f',
'                          where id = :APP_ID',
'                          union',
'                         select flow_language',
'                           from wwv_flows f',
'                          where id in ( select translation_flow_id',
'                                          from wwv_flow_language_map',
'                                         where primary_language_flow_id = :APP_ID )',
'                       ) f,',
'                       wwv_flow_languages l',
'                 where f.flow_language = l.lang_id'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(571215478963548485.4605)
,p_item_css_classes=>'a-Form-fieldContainer--noPadding'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(597600117330189669.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Complete Setup'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    --',
'    if :P10_INSTALL_LABELS = ''Y'' then ',
'        wwv_flow_issue_seed_int.install_default_labels(p_lang => :P10_LANGUAGE);',
'    end if;',
'    --',
'    if :P10_INSTALL_TEMPLATES = ''Y'' then ',
'        wwv_flow_issue_seed_int.install_default_templates(p_lang => :P10_LANGUAGE);',
'    end if;',
'    --',
'    if :P10_INSTALL_MILESTONES = ''Y'' then ',
'        wwv_flow_issue_seed_int.install_sample_milestones(p_lang => :P10_LANGUAGE);',
'    end if;',
'    --',
'    wwv_flow_issue_seed_int.install_sample_issue;',
'    --',
' end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_api.create_page(
 p_id=>11.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>unistr('O Arquivo N\00E3o Existe')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('O Arquivo N\00E3o Existe')
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1664201025663420.4605)
,p_plug_name=>'Novo'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source=>unistr('N\00C3O... N\00E3o aqui.')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00100
begin
wwv_flow_api.create_page(
 p_id=>100.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Problema'
,p_alias=>'ISSUE'
,p_step_title=>'&P100_ISSUE_TITLE. - Problema'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_javascript_file_urls=>'#IMAGE_PREFIX#apex_ui/js/issues.utils.js'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'//Catching the custom Close event from the View Files dialog',
'function customCloseEvent(event, data){',
'    apex.event.trigger(document, event, data);',
'}',
'',
'// Function to allow inserting file references after uploading a file.',
'function insertFileReference(data){',
'    //mdEditor.setValue(data);',
'    apex.item(''P100_COMMENT'').setValue(data);',
'}',
'',
'// Function to get the template body',
'function getResponseTemplate(pID) {',
'    apex.server.process("getResponseTemplate", { x01: pID },{',
'         success: function(pData) {',
'            var item = apex.item(''P100_COMMENT'');',
'            var text = item.getValue();',
'             var replace = true;',
'            if(text && text.length > 0){',
'                var message = apex.lang.getMessage("APEX.ISSUES.REPLACE_COMMENT_CONFIRM");',
'               replace = confirm(message);',
'            }',
'             if(replace){',
'                 apex.item(''P100_COMMENT'').setValue(pData.text);',
'            }',
'         }',
'    });',
'}',
'',
'// Edit Menus for Comments',
'var menu$ = $("<div id=''timelineMenu''></div>");',
'$("body").append(menu$);',
'menu$.menu({',
'  iconType: "fa",',
'  items: [{',
'      type: "action",',
'      labelKey: "APEX.ISSUES.EDIT",',
'      icon: "fa-pencil",',
'      action: function(menu, btn) {',
'        var link,',
'          dialogTitle,',
'          button$ = $(btn),',
'          commentType = button$.attr("data-type") === "comment" ? "EDIT_COMMENT" : "EDIT_ISSUE",',
'          link = button$.attr("data-link").replace(/\\u(\d\d\d\d)/g, function(m, d) {',
'            return String.fromCharCode(parseInt(d, 16));',
'          });',
'        apex.navigation.dialog(link, {',
'          title: apex.lang.getMessage(''APEX.ISSUES.'' + commentType),',
'          resizable: true,',
'          draggable: true,',
'          width: 640,',
'          height: ''auto''',
'        }, "a-Dialog--uiDialog", button$);',
'      },',
'      hide: function(menu) {',
'        var button$ = $("button.is-active.js-menuButton.js-timelineEditButton"),',
'          link = button$.attr("data-link");',
'        return button$.attr("data-link") ? false : true;',
'      }',
'    },',
'    {',
'      type: "separator"',
'    },',
'    {',
'      type: "action",',
'      labelKey: "APEX.ISSUES.HIDE",',
'      icon: "fa-eye-slash",',
'      action: function(menu, btn) {',
'        var button$ = $(btn),',
'          timelineItemId = button$.attr("data-comment-id");',
'        apex.server.process(',
'          ''hideComment'', {',
'            x01: timelineItemId',
'          }, {',
'            success: function(data) {',
'              apex.region(''issueTimeline'').refresh()',
'            }',
'          }',
'        );',
'      },',
'      hide: function(menu) {',
'        var btn$ = $("button.is-active.js-menuButton.js-timelineEditButton");',
'        type = btn$.attr("data-type"),',
'          commentStatus = btn$.attr("data-comment-status");',
'        if (type === "comment" && commentStatus === "visible") {',
'          return false;',
'        } else {',
'          return true;',
'        }',
'      }',
'    },',
'    {',
'      type: "action",',
'      labelKey: "APEX.ISSUES.UNHIDE",',
'      icon: "fa-eye",',
'      action: function(menu, btn) {',
'        var button$ = $(btn),',
'          timelineItemId = button$.attr("data-comment-id");',
'        apex.server.process(',
'          ''showComment'', {',
'            x01: timelineItemId',
'          }, {',
'            success: function(data) {',
'              apex.region(''issueTimeline'').refresh()',
'            }',
'          }',
'        );',
'      },',
'      hide: function(menu) {',
'        var btn$ = $("button.is-active.js-menuButton.js-timelineEditButton"),',
'          type = btn$.attr("data-type"),',
'          commentStatus = btn$.attr("data-comment-status");',
'',
'        if (type === "comment" && commentStatus === "hidden") {',
'          return false',
'        } else {',
'          return true;',
'        }',
'      }',
'    },',
'    {',
'      type: "action",',
'      labelKey: "APEX.ISSUES.DELETE",',
'      icon: "fa-trash-o",',
'      id: "delete_comment",',
'      action: function(menu, btn) {',
'        var button$ = $(btn),',
'          timelineItemId = button$.attr("data-comment-id");',
'',
'        apex.message.confirm(apex.lang.getMessage("APEX.ISSUES.DELETE_COMMENT_CONFIRM"), function(confirm) {',
'          if (confirm) {',
'            apex.server.process(',
'              ''deleteComment'', {',
'                x01: timelineItemId',
'              }, {',
'                success: function(data) {',
'                  apex.region(''issueTimeline'').refresh()',
'                }',
'              }',
'            );',
'          }',
'        });',
'      },',
'      hide: function(menu) {',
'        var btn$ = $("button.is-active.js-menuButton.js-timelineEditButton"),',
'          type = btn$.attr("data-type");',
'',
'        return type === "comment" ? false : true;',
'      }',
'    },',
'    {',
'      type: "action",',
'      labelKey: "APEX.ISSUES.DELETE_ISSUE",',
'      icon: "fa-trash-o",',
'      id: "delete_issue",',
'      action: function() {',
'        apex.confirm(apex.lang.getMessage("APEX.ISSUES.DELETE_ISSUE_CONFIRM"), {',
'          request: "DELETE"',
'        })',
'      },',
'      hide: function(menu) {',
'        var btn$ = $("button.is-active.js-menuButton.js-timelineEditButton"),',
'          type = btn$.attr("data-type");',
'',
'        return type === "issue" ? false : true;',
'      }',
'    }',
'  ]',
'});',
'',
'// Function to retrieve full text of issue or comment and replace what is currently in the page. ',
'function getFullText(pType, pID){',
'    apex.server.process("getFullText", { x01: pType, ',
'                                         x02: pID',
'    },{  dataType: ''text'',',
'         success: function(pData) {',
'               document.getElementById(pID).innerHTML = pData;',
'               document.getElementById("MORE_"+ pID).innerHTML = '' '';',
'               $( document.getElementById(pID) ).removeClass( ''is-markdownified'' );',
'               apex.widget.markdown.render( ''.a-TimelineEntry-bodyContent'' );',
'',
'',
'         }',
'    });',
'}'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/* Handle Delete Issues menu item */',
'var deleteIssueMenuItem = $("#issueActions_menu").menu("find", "delete_issue_item");',
'',
'if ( deleteIssueMenuItem ) {',
'  deleteIssueMenuItem.action = function() {',
'    apex.confirm(apex.lang.getMessage("APEX.ISSUES.DELETE_ISSUE_CONFIRM"), {',
'      request: "DELETE"',
'    })',
'  }',
'}',
''))
,p_step_template=>wwv_flow_api.id(391881764116992437.4605)
,p_page_css_classes=>'a-Page--issue'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_deep_linking=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1664332366663421.4605)
,p_plug_name=>unistr('Arquivo N\00E3o Encontrado')
,p_region_name=>'noFileFound'
,p_region_template_options=>'#DEFAULT#:js-dialog-size480x320:h240'
,p_region_attributes=>'style="display:none"'
,p_plug_template=>wwv_flow_api.id(10813455696794486.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--defaultIcons a-Alert--danger a-Alert--horizontal h240" >',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon "></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">Erro de Arquivo</h2>',
'      </div>',
'      <div class="a-Alert-body">',
unistr('        O arquivo ao qual voc\00EA tentou fazer refer\00EAncia n\00E3o existe mais. Talvez voc\00EA queira remover deste problema todas as refer\00EAncias a esse arquivo.'),
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      ',
'    </div>',
'  </div>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4873675327998306.4605)
,p_plug_name=>unistr('Barra de T\00EDtulo')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    for issue in (',
'        select ',
'            issue_number, ',
'            title,',
'            created_by,',
'            wwv_flow_issue_int.get_user_name(created_by) user_name,',
'            apex_util.get_since(created_on) created_on,',
'            case status when ''OPEN''   then ''a-IssueList-itemStatusIcon--open fa-exclamation-circle-o''',
'                        when ''CLOSED'' then ''a-IssueList-itemStatusIcon--closed fa-exclamation-circle-o fam-check fam-is-danger''',
'            end status_icon,',
'            ( select count(*) from wwv_flow_issue_comments c where c.issue_id = i.id ) comment_count',
'        from ',
'            wwv_flow_issues i',
'        where id = :P100_ISSUE_ID',
'          and security_group_id = :flow_security_group_id',
'    ) loop',
'        sys.htp.p(''<div class="a-IssueHeader">'' );',
'        sys.htp.p(''  <div class="a-IssueHeader-itemStatusIconWrap">'' );',
'        sys.htp.p(''    <span class="a-IssueList-itemStatusIcon fa fa-lg ''||issue.status_icon||''" aria-hidden="true"></span>'');',
'        sys.htp.p(''  </div>'');',
'        sys.htp.p(''  <div class="a-IssueHeader-body">'');',
'        sys.htp.p(''    <h1 class="a-IssueHeader-title">''||issue.title||''</h1>'');',
'        sys.htp.p(''    <div class="a-IssueHeader-info"><span class="a-IssueHeader-issueNumber">#''||issue.issue_number||''</span> ''',
'                    || wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.OPENED'', p0=> issue.created_on)||'' <a href="''',
'                    || apex_page.get_url(p_application => 4600,p_page=> 500,p_items=> ''P500_USER_NAME'',p_values=> issue.created_by)',
'                    ||''">''|| issue.user_name',
'                    || ''</a> &middot; ''|| issue.comment_count ||'' ''||wwv_flow_lang.system_message(''APEX.ISSUES.COMMENTS'')||''</div>'');',
'        sys.htp.p(''  </div>'');',
'        sys.htp.p(''</div>'');',
'    end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(4874097402998310.4605)
,p_name=>'Labels'
,p_template=>wwv_flow_api.id(179998957300224011.4605)
,p_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''<a href="#" class="a-IssueLabel ''||g.group_color||''"> ''||l.label_name||''</a>''  as display_value    ',
'  from wwv_flow_labels l,',
'       wwv_flow_label_groups g,',
'       wwv_flow_issue_labels il',
' where il.issue_id = :P100_ISSUE_ID',
'   and il.label_id = l.id',
'   and l.label_group_id = g.id',
'   and il.security_group_id = :flow_security_group_id',
'   and l.security_group_id = :flow_security_group_id',
'   and g.security_group_id = :flow_security_group_id',
'order by g.group_name, l.label_name'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(6221345279028573.4605)
,p_query_num_rows=>30
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'Nenhum Label Designado'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8722121265916105.4605)
,p_query_column_id=>1
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Valor para Exibi\00E7\00E3o')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(4874178306998311.4605)
,p_name=>'Marcos'
,p_template=>wwv_flow_api.id(179998957300224011.4605)
,p_display_sequence=>70
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id milestone_id,',
'        milestone_date, ',
'       ''<span class="a-IssueLabel ''|| case when milestone_date < sysdate then ''u-danger''',
'                                           when milestone_date >= sysdate and milestone_date <= sysdate + 15 then ''u-warning''',
'                                           else ''u-success''',
'                                       end',
'                       ||''"  style="width:100%"> ''||milestone_name||''<br/>''||milestone_date||''</span>''  as display_value',
'  from wwv_flow_issue_milestones im ,',
'       wwv_flow_milestones m',
' where im.issue_id = :P100_ISSUE_ID',
'   and im.milestone_id = m.id',
'   and m.security_group_id = :flow_security_group_id',
'   and im.security_group_id = :flow_security_group_id',
'order by milestone_date asc'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(6221345279028573.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'Nenhum Marco Designado'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5948623774329311.4605)
,p_query_column_id=>1
,p_column_alias=>'MILESTONE_ID'
,p_column_display_sequence=>2
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5611666794530324.4605)
,p_query_column_id=>2
,p_column_alias=>'MILESTONE_DATE'
,p_column_display_sequence=>1
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8722217770916106.4605)
,p_query_column_id=>3
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>3
,p_column_heading=>unistr('Valor para Exibi\00E7\00E3o')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4874226588998312.4605)
,p_plug_name=>unistr('Notifica\00E7\00F5es')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>80
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(4929538370267901.4605)
,p_name=>'Linha de Tempo do Problema'
,p_region_name=>'issueTimeline'
,p_template=>wwv_flow_api.id(214132567690623104.4605)
,p_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with timeline as (',
'    --',
'    select id,',
'           ''ISSUE'' event_target,',
'           ''OPENED'' event_action,',
'           null entry_type_icon,',
'           ''a-TimelineEntry--expanded'' entry_modifier_classes,',
'            issue_text   entry_body,',
'            to_clob(''Created this issue ''||apex_util.get_since(created_on))  entry_status_type,',
'           created_on   entry_date,',
'           created_by   entry_author,',
'           null public_yn',
'      from wwv_flow_issues',
'     where id = :P100_ISSUE_ID',
'       and security_group_id = :flow_security_group_id',
'    --   ',
'    union all',
'    --',
'    select id,',
'           ''COMMENT'' event_target,',
'           ''CREATED'' event_action,',
'           null entry_type_icon,',
'           case public_yn',
'                when ''N'' then ''a-TimelineEntry--collapsed a-TimelineEntry--hidden'' ',
'                else ''a-TimelineEntry--expanded'' ',
'           end entry_modifier_classes,',
'           comment_text entry_body,',
'           case public_yn ',
'                when ''N'' then to_clob(wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.HIDDEN''))',
'                else to_clob(wwv_flow_lang.system_message(''APEX.ISSUES.COMMENTED'')||'' ''||apex_util.get_since(created_on)) ',
'           end entry_status_type,',
'           created_on     entry_date,',
'           created_by     entry_author,',
'           public_yn public_yn',
'      from wwv_flow_issue_comments',
'     where issue_id = :P100_ISSUE_ID',
'       and security_group_id = :flow_security_group_id',
'       and (public_yn != ''N'' ',
'            OR ',
'            instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0',
'            OR ',
'            created_by = :APP_USER)',
'    --',
'    union all',
'    --',
'    select id,',
'           upper(wwv_flow_issue_int.get_json_event_type(event_text)) event_target,',
'           upper(wwv_flow_issue_int.get_json_event_action(event_text)) event_action,',
'           null ENTRY_TYPE_ICON,',
'           ''a-TimelineEntry--collapsed'' entry_modifier_classes,',
'           null entry_body,',
'           wwv_flow_issue_int.format_event_json(event_text) entry_status_type,',
'           event_date   entry_date,',
'           created_by   entry_author,',
'           null public_yn',
'      from wwv_flow_issue_events',
'     where issue_id = :P100_ISSUE_ID',
'       and upper(wwv_flow_issue_int.get_json_event_type(event_text)) not in (''ISSUE'',''COMMENT'')',
'       and security_group_id = :flow_security_group_id',
')',
'--',
'select ',
'    id,',
'    event_target,',
'    event_action,',
'    case event_action ',
'        when ''ADD'' then ''u-success''',
'        when ''REMOVE'' then ''u-danger''',
'        when ''SET'' then ''u-info''',
'        else ''other-event-action''',
'    end entry_type_icon_modifier,',
'    case event_target',
'        when ''ISSUE''        then',
'            ''fa fa-exclamation-circle-o''',
'        when ''COMMENT''      then',
'                case public_yn ',
'                    when ''N'' then ',
'                        ''fa fa-eye-slash''',
'                    else ',
'                        ''fa fa-comment-o''',
'                end',
'        when ''STATUS''       then',
'           ''fa fa-pencil''         -- ''a-TimelineEntry-typeIcon -- status''',
'        when ''LABEL''        then',
'           ''fa fa-tag''            -- ''a-TimelineEntry-typeIcon -- label''',
'        when ''MILESTONE''    then',
'           ''fa fa-map-signs''      -- ''a-TimelineEntry-typeIcon -- milestone''',
'        when ''ASSIGNEE''     then',
'           case event_action when ''ADD'' then ''fa fa-user-plus''',
'                             when ''REMOVE'' then ''fa fa-user-x''',
'           end',
'        when ''SUBSCRIBER''   then',
'           ''fa fa-check-circle-o'' -- ''a-TimelineEntry-typeIcon -- subscriber''',
'        when ''ATTACHMENT''   then',
'           ''fa fa-paperclip''      -- ''a-TimelineEntry-typeIcon -- attachment''',
'        when ''DUPLICATE'' then ',
'           ''fa fa-copy'' ',
'        when ''ASSOCIATION'' then ',
'            ''fa fa-window-bookmark''',
'       else event_target',
'    end entry_type_icon_class,',
'    null entry_type_icon,',
'    entry_modifier_classes,',
'    --entry_body,',
'    wwv_flow_escape.html_trunc(replace(entry_body, ''#ISSUE_FILE#'',''f?p=''||:APP_ID||'':100:''||:APP_SESSION||'':APPLICATION_PROCESS=getAttachment:NO::P100_ISSUE_ID,P100_FILE_NAME_SLUG:''||:P100_ISSUE_ID||'','')) as entry_body,',
'    case ',
'    when sys.dbms_lob.getlength(replace(entry_body, ''#ISSUE_FILE#'',''f?p=''||:APP_ID||'':100:''||:APP_SESSION||'':APPLICATION_PROCESS=getAttachment:NO::P100_ISSUE_ID,P100_FILE_NAME_SLUG:''||:P100_ISSUE_ID||'','') ) > 4000 THEN ',
'        ''<a href="javascript:getFullText(''''''||event_target||'''''', ''''''||id||'''''');" class="a-TimelineEntry-moreLink">''|| wwv_flow_lang.system_message(''APEX.ISSUES.SHOW_MORE'') ||''</a>''',
'    else '' ''',
'    end as more_data,',
'    entry_status_type,',
'    case  ',
'        when (event_target = ''COMMENT'') THEN ',
'             case ',
'                 -- if ADMIN',
'                 when (instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0  ) AND (public_yn = ''N'')',
'                   then  ',
'                     ''<button id="toggleBody" class="a-Button a-Button--noLabel a-Button--iconTextButton a-Button--noUI" type="button" title="Toggle Body" aria-label="Toggle Body" onclick="$(this).closest(''''article'''').toggleClass(''''a-TimelineEntry--c'
||'ollapsed'''').toggleClass(''''a-TimelineEntry--expanded'''');"><span class="fa fa-expand-collapse" aria-hidden="true"></span></button>''',
'                 else null',
'             end ',
'        else null',
'    end entry_actions,',
'    (',
'       -- Dynamic Menu',
'       case ',
'       when event_target in (''ISSUE'',''COMMENT'') ',
'            and (',
'                    (instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') > 0) ',
'                      OR ',
'                    (t.entry_author = :APP_USER)',
'                )',
'       then',
'           ''<button type="button" class="a-Button a-Button--noLabel a-Button--noUI js-timelineEditButton js-menuButton" ''',
'            ||''data-menu="timelineMenu" aria-label="''||wwv_flow_lang.system_message(''APEX.ISSUES.SHOW_ACTIONS'')||''" title="''||wwv_flow_lang.system_message(''APEX.ISSUES.SHOW_ACTIONS'')||''"''',
'            -- Capture Event Type',
'            || ''data-type="''||lower(event_target)||''"'' ||',
'            -- Capture Edit Links',
'            case event_target ',
'              when ''ISSUE'' then ''data-link="''||trim( both '''''''' from regexp_substr(apex_util.prepare_url(p_url => ''f?p=''||:APP_ID||'':101:''||:APP_SESSION, p_checksum_type => ''SESSION''),''''''f\?p=[^'''']*'''''') )||''" ''',
'              when ''COMMENT'' then ''data-comment-id="''||id||''" data-link="''||trim( both '''''''' from regexp_substr(apex_util.prepare_url(p_url => ''f?p=''||:APP_ID||'':108:''||:APP_SESSION||''::::P108_COMMENT_ID,P100_ISSUE_ID_VALUE:''||id||'',''||:P100_ISSUE_ID,'
||' p_checksum_type => ''SESSION''),''''''f\?p=[^'''']*'''''') )||''" ''',
'              else null',
'            end ||',
'            -- Capture Comment Status',
'            case ',
'              when (instr(',
'                          wwv_flow_fnd_user_int.get_user_roles(',
'                            p_security_group_id => :flow_security_group_id, ',
'                            p_username => :APP_USER',
'                          ), ''ADMIN'') > 0  ) ',
'              then',
'                   case public_yn ',
'                     when ''N'' then ''data-comment-status="hidden"''',
'                     when ''Y'' then ''data-comment-status="visible"''',
'                   end',
'              else ',
'                null',
'            end ||',
'            ''><span aria-hidden="true" class="fa fa-ellipsis-v-o"></span></button>''',
'       else ',
'        null -- When the target is not an issue or comment, we don''t need to show actions menu',
'       end',
'    ) as entry_options_menu,',
'    entry_date,',
'    wwv_flow_issue_int.get_avatar(p_user_name => entry_author, p_image_size => 24, p_include_name => ''Y'', p_include_link => ''Y'') entry_author,',
'    case',
'        when u.user_id is null then',
'            ''''',
'        else',
'            ''wwv_flow_file_mgr.get_file?p_user_id='' || u.user_id',
'    end image_link',
'',
'  from timeline            t,',
'       wwv_flow_fnd_user   u',
' where t.entry_author = u.user_name (+)',
'   and :flow_security_group_id = u.security_group_id (+)',
' order by entry_date asc'))
,p_ajax_enabled=>'Y'
,p_ajax_items_to_submit=>'P100_ISSUE_ID'
,p_query_row_template=>wwv_flow_api.id(5473608411738262.4605)
,p_query_num_rows=>1100
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(4929664747267902.4605)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_column_heading=>'Id'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(4930781814267913.4605)
,p_query_column_id=>2
,p_column_alias=>'EVENT_TARGET'
,p_column_display_sequence=>3
,p_column_heading=>'Alvo do Evento'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6448950234807346.4605)
,p_query_column_id=>3
,p_column_alias=>'EVENT_ACTION'
,p_column_display_sequence=>12
,p_column_heading=>unistr('A\00E7\00E3o do Evento')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8721928967916103.4605)
,p_query_column_id=>4
,p_column_alias=>'ENTRY_TYPE_ICON_MODIFIER'
,p_column_display_sequence=>11
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(4923539353003004.4605)
,p_query_column_id=>5
,p_column_alias=>'ENTRY_TYPE_ICON_CLASS'
,p_column_display_sequence=>9
,p_column_heading=>unistr('Classe de \00CDcone de Tipo de Entrada')
,p_use_as_row_header=>'N'
,p_column_html_expression=>'#ENTRY_TYPE_ICON_CLASS# #EVENT_ACTION#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5444053036568815.4605)
,p_query_column_id=>6
,p_column_alias=>'ENTRY_TYPE_ICON'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\00CDcone de Tipo de Entrada')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5443271658568807.4605)
,p_query_column_id=>7
,p_column_alias=>'ENTRY_MODIFIER_CLASSES'
,p_column_display_sequence=>5
,p_column_heading=>'Classes de Modificador de Entrada'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(15580721229474511.4605)
,p_query_column_id=>8
,p_column_alias=>'ENTRY_BODY'
,p_column_display_sequence=>14
,p_column_heading=>'Corpo da Entrada'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(15607449604231506.4605)
,p_query_column_id=>9
,p_column_alias=>'MORE_DATA'
,p_column_display_sequence=>15
,p_column_heading=>'Mais Dados'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5444144303568816.4605)
,p_query_column_id=>10
,p_column_alias=>'ENTRY_STATUS_TYPE'
,p_column_display_sequence=>8
,p_column_heading=>'Tipo de Status de Entrada'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5960846667537001.4605)
,p_query_column_id=>11
,p_column_alias=>'ENTRY_ACTIONS'
,p_column_display_sequence=>10
,p_column_heading=>unistr('A\00E7\00F5es de Entrada')
,p_use_as_row_header=>'N'
,p_column_html_expression=>'#ENTRY_ACTIONS##ENTRY_OPTIONS_MENU#'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8725456169916138.4605)
,p_query_column_id=>12
,p_column_alias=>'ENTRY_OPTIONS_MENU'
,p_column_display_sequence=>13
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(4929997352267905.4605)
,p_query_column_id=>13
,p_column_alias=>'ENTRY_DATE'
,p_column_display_sequence=>2
,p_column_heading=>'Data de Entrada'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5443468883568809.4605)
,p_query_column_id=>14
,p_column_alias=>'ENTRY_AUTHOR'
,p_column_display_sequence=>6
,p_column_heading=>'Autor da Entrada'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(4930974119267915.4605)
,p_query_column_id=>15
,p_column_alias=>'IMAGE_LINK'
,p_column_display_sequence=>4
,p_column_heading=>'Link de Imagem'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5446940561568844.4605)
,p_plug_name=>unistr('Coment\00E1rio')
,p_region_name=>'comment'
,p_region_css_classes=>'padding-sm'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>41
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<a name="comments"></a><h2 class="padding-sm">Adicionar Coment\00E1rio</h2>')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null ',
'  from wwv_flow_issues',
'where id = :P100_ISSUE_ID',
'  and security_group_id = :flow_security_group_id'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(8722597345916109.4605)
,p_plug_name=>unistr('Bot\00F5es de Coment\00E1rio')
,p_parent_plug_id=>wwv_flow_api.id(5446940561568844.4605)
,p_region_css_classes=>'padding-sm'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noPadding:a-ButtonRegion--noUI'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6186211948627143.4605)
,p_plug_name=>'Feedback'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' ',
'  from wwv_flow_feedback ',
' where ISSUE_ID = :P100_ISSUE_ID',
'   and SECURITY_GROUP_ID = :flow_security_group_id'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(6335901170146534.4605)
,p_name=>'Favorecidos'
,p_template=>wwv_flow_api.id(179998957300224011.4605)
,p_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'wwv_flow_issue_int.get_avatar(p_user_name => stakeholder, p_image_size => 24, p_include_name => ''Y'', p_include_link => ''Y'', p_modifier_class => ''a-User--block'') as display_value',
'from wwv_flow_issue_stakeholders s',
'where s.issue_id = :P100_ISSUE_ID',
'  and s.stakeholder_type = ''ASSIGNEE'''))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(6221345279028573.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>unistr('Nenhum Usu\00E1rio Designado')
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
end;
/
begin
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6336194780146536.4605)
,p_query_column_id=>1
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Valor para Exibi\00E7\00E3o')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(6445706829807314.4605)
,p_name=>unistr('Duplica\00E7\00E3o Marcada de')
,p_template=>wwv_flow_api.id(179998957300224011.4605)
,p_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''<a href="''||apex_util.prepare_url(''f?p=''||:APP_ID||'':100:''||:APP_SESSION||''::::P100_ISSUE_ID:''||i1.duplicate_of)||''">#''||i2.issue_number||'' ''||i2.title||''</a>'' as display_value',
'from wwv_flow_issues i2 ,',
'     wwv_flow_issues i1',
'where i1.id = :P100_ISSUE_ID',
'  and i2.id = i1.duplicate_of',
'  and i1.security_group_id = :flow_security_group_id',
'  and i2.security_group_id = :flow_security_group_id'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' from wwv_flow_issues ',
'where id = :P100_ISSUE_ID ',
'  and DUPLICATE_OF is not null',
'  and security_group_id = :flow_security_group_id'))
,p_display_condition_type=>'EXISTS'
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(6221345279028573.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>unistr('N\00E3o Marcado como duplicado')
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6445847908807315.4605)
,p_query_column_id=>1
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Valor para Exibi\00E7\00E3o')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(8722347756916107.4605)
,p_plug_name=>unistr('Menu A\00E7\00F5es')
,p_region_name=>'issueActions'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>51
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(6321465669737549.4605)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(5208269691267696.4605)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(11426346067280827.4605)
,p_name=>'Anexos'
,p_region_name=>'attachmentsReport'
,p_template=>wwv_flow_api.id(179998957300224011.4605)
,p_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with attachments as (',
'select case ',
'            when substr(mime_type,1,5) = ''image'' then ',
'                wwv_flow_lang.system_message(''APEX.ISSUES.IMAGES'')',
'            when substr(mime_type,1,11) = ''application'' then',
'                case ',
'                    when substr(mime_type,13) in (''zip'',''x-gzip'') then',
'                        wwv_flow_lang.system_message(''APEX.ISSUES.ZIP_FILES'')',
'                    else ',
'                        wwv_flow_lang.system_message(''APEX.ISSUES.DOCUMENTS'')',
'                    end',
'            when substr(mime_type,1,4) = ''text'' then',
'                wwv_flow_lang.system_message(''APEX.ISSUES.TEXT_FILES'')',
'            else ',
'                wwv_flow_lang.system_message(''APEX.ISSUES.OTHER'')',
'        end Image_type,',
'        ''1'' files',
'from wwv_flow_issue_attachments',
'where issue_id = :P100_ISSUE_ID',
'  and security_group_id = :flow_security_group_id)',
'select image_type, sum(files) number_of_files',
'from attachments',
'group By image_type',
'order by 1 asc',
'                ',
'        '))
,p_display_when_condition=>'P100_ALLOW_ISSUE_FILES_YN'
,p_display_when_cond2=>'Y'
,p_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_ajax_enabled=>'Y'
,p_ajax_items_to_submit=>'P100_ISSUE_ID'
,p_query_row_template=>wwv_flow_api.id(1046851149224553954.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(11426465825280828.4605)
,p_query_column_id=>1
,p_column_alias=>'IMAGE_TYPE'
,p_column_display_sequence=>1
,p_column_heading=>'Tipo de Imagem'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1218954926620101.4605)
,p_query_column_id=>2
,p_column_alias=>'NUMBER_OF_FILES'
,p_column_display_sequence=>2
,p_column_heading=>unistr('N\00FAmero de Arquivos')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11426709614280831.4605)
,p_plug_name=>unistr('Bot\00E3o Anexo')
,p_parent_plug_id=>wwv_flow_api.id(11426346067280827.4605)
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI:a-ButtonRegion--accessibleTitle'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(156403623260150739.4605)
,p_name=>'Associado Com'
,p_template=>wwv_flow_api.id(179998957300224011.4605)
,p_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''<a href="f?p=4000:1:''||:APP_SESSION||''::NO:RP:FB_FLOW_ID,F4000_P1_FLOW,P0_FLOWPAGE,RECENT_PAGES:''||f.id||'',''||f.id||'',''||f.id||''">''||f.id||'' - ''||f.name||''</a>''||',
'        decode(s.id, null, null, ''<br/><a href="f?p=4000:4500:''||:APP_SESSION||''::::FB_FLOW_ID,FB_FLOW_PAGE_ID,F4000_P4150_GOTO_PAGE:''||f.id||'',''||s.id||'',''||s.id||''">''||s.id||'' - ''||s.name||''</a>'') as display_value',
'  from wwv_flows f, ',
'     wwv_flow_steps s, ',
'     wwv_flow_issues i',
'where i.id = :P100_ISSUE_ID',
'  and f.id = i.application_id ',
'  and s.id (+) = i.page_id ',
'  and s.flow_id (+) = f.id',
'  and i.security_group_id = :flow_security_group_id',
'  and f.security_group_id = :flow_security_group_id',
'  and s.security_group_id (+) = :flow_security_group_id'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' from wwv_flow_issues ',
'where id = :P100_ISSUE_ID ',
'  and APPLICATION_ID is not null',
'  and security_group_id = :flow_security_group_id'))
,p_display_condition_type=>'EXISTS'
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(6221345279028573.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>unistr('N\00E3o Marcado como duplicado')
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(156403716995150740.4605)
,p_query_column_id=>1
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Valor para Exibi\00E7\00E3o')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(629071096340884086.4605)
,p_plug_name=>'Sobre'
,p_region_css_classes=>'a-Region--stacked a-Region--padded a-Region--flush a-Region--sideRegion'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Os Detalhes dos Problemas permitem gerenciar a vida de um problema. Na p\00E1gina principal, voc\00EA ver\00E1 a linha do tempo do problema, mostrando todos os eventos e coment\00E1rios por ordem de ocorr\00EAncia. \00C0 direita voc\00EA ver\00E1 as op\00E7\00F5es que ajudam a classific')
||'ar o problema.</p>',
'<p><a target="_blank" href="&SYSTEM_HELP_URL./htmdb/creating-and-updating-issues.html#GUID-72F71401-8528-44A1-82AA-FBAC83D23690">Saiba Mais...</a></p>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(11426676059280830.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(11426709614280831.4605)
,p_button_name=>'VIEW_ATTACHMENTS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Exibir Anexos'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:112:&SESSION.::&DEBUG.:RP,112::'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(156403200471150735.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(6186211948627143.4605)
,p_button_name=>'FEEDBACK'
,p_button_action=>'REDIRECT_APP'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Exibir Feedback Relacionado'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=4650:8001:&SESSION.::&DEBUG.:RP:P8001_ID:&P100_RELATED_FEEDBACK.'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5611080609530318.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(4874178306998311.4605)
,p_button_name=>'MANAGE_MILESTONES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(5208338701524668.4605)
,p_button_image_alt=>'Definir Marcos'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:106:&SESSION.::&DEBUG.:RP,105::'
,p_icon_css_classes=>'icon-edit'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5710376476527220.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(4874097402998310.4605)
,p_button_name=>'MANAGE_LABELS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(5208338701524668.4605)
,p_button_image_alt=>'Definir Labels'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:107:&SESSION.::&DEBUG.:RP,107::'
,p_icon_css_classes=>'icon-edit'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6336046011146535.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(6335901170146534.4605)
,p_button_name=>'MANAGE_ASSIGNEES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(5208338701524668.4605)
,p_button_image_alt=>'Definir Favorecidos'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:RP,105::'
,p_icon_css_classes=>'icon-edit'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5840320533198707.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(4873675327998306.4605)
,p_button_name=>'JUMP_TO_LATEST'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>unistr('Pular para o \00DAltimo')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'#comments'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null ',
'  from wwv_flow_issues',
'where id = :P100_ISSUE_ID',
'  and security_group_id = :flow_security_group_id'))
,p_button_condition_type=>'EXISTS'
,p_button_css_classes=>'a-Button--simple'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6333633915146511.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(8722597345916109.4605)
,p_button_name=>'CLOSE'
,p_button_static_id=>'CLOSE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Comentar e Fechar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P100_STATUS'
,p_button_condition2=>'OPEN'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6333763850146512.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(8722597345916109.4605)
,p_button_name=>'REOPEN'
,p_button_static_id=>'REOPEN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Comentar e Reabrir'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P100_STATUS'
,p_button_condition2=>'CLOSED'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(8722484274916108.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(4873675327998306.4605)
,p_button_name=>'ISSUE_ACTIONS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(656569185201725731.4605)
,p_button_image_alt=>unistr('A\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null ',
'  from wwv_flow_issues',
'where id = :P100_ISSUE_ID',
'  and security_group_id = :flow_security_group_id'))
,p_button_condition_type=>'EXISTS'
,p_button_css_classes=>'js-menuButton'
,p_icon_css_classes=>'icon-menu-drop-down'
,p_button_cattributes=>'data-menu="issueActions_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5712509758527242.4605)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(8722597345916109.4605)
,p_button_name=>'COMMENT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Coment\00E1rio')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(10420941074079407.4605)
,p_branch_name=>'Go To Page 1 on Delete'
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP,100::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'DELETE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(6446192775807318.4605)
,p_branch_name=>'Go To Page 100'
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP:P100_COMMENT:&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1664662478663424.4605)
,p_name=>'P100_REQUEST'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(4929538370267901.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4930095638267906.4605)
,p_name=>'P100_ISSUE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(4929538370267901.4605)
,p_item_default=>'4840740643993632'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4930125701267907.4605)
,p_name=>'P100_ISSUE_TITLE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(4929538370267901.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4930434506267910.4605)
,p_name=>'P100_ISSUE_SLUG'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(4929538370267901.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4930507711267911.4605)
,p_name=>'P100_ISSUE_CREATE_MESSAGE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(4929538370267901.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5610586983530313.4605)
,p_name=>'P100_SUBSCRIBED'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(4874226588998312.4605)
,p_prompt=>'Assinar'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(566754195708398878.4605)
,p_item_template_options=>'#DEFAULT#'
,p_warn_on_unsaved_changes=>'I'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6332865140146503.4605)
,p_name=>'P100_ISSUE_NUMBER'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(4929538370267901.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6333852047146513.4605)
,p_name=>'P100_STATUS'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(4929538370267901.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6748593635011304.4605)
,p_name=>'P100_ATTACH_FILES_TARGET_URL'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5446940561568844.4605)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.prepare_url(',
'    p_url => ''f?p=''||:APP_ID||'':109:''||:APP_SESSION||''::::P109_ISSUE_ID:''||:P100_ISSUE_ID,',
'    p_checksum_type => ''SESSION''',
')'))
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(8722615197916110.4605)
,p_name=>'P100_RESPONSE_TEMPLATE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5446940561568844.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(10637390756317401.4605)
,p_name=>'P100_COMMENT'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(5446940561568844.4605)
,p_prompt=>unistr('Coment\00E1rio')
,p_display_as=>'NATIVE_MARKDOWN_EDITOR'
,p_cSize=>30
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(571215478963548485.4605)
,p_item_css_classes=>'a-IssueComments'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_plugin_init_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(options) {',
'    var markDownEditor = this;   ',
'    markDownEditor.onBeforePreviewText = function(text){',
'        return apex.issues.replacePrefixImage(text, ''P100_ISSUE_ID'');',
'    };',
'    var templatesLOV = JSON.parse($v(''P100_RESPONSE_TEMPLATES''));',
'    var templateMenu = [];',
'    templatesLOV.forEach(function(element){',
'        templateMenu.push(',
'            {',
'                type: "action",',
'                label: element.templateName,',
'                action: function(){',
'                    getResponseTemplate(element.templateID) ;',
'                }',
'            }',
'        );  ',
'    });',
'    ',
'    // template and attach buttons',
'    apex.issues.addAttachButton(options, ''P100_ALLOW_ISSUE_FILES_YN'', ''P100_COMMENT'', ''P100_ATTACH_FILES_TARGET_URL'');',
'    ',
'    if(templateMenu.length > 0){',
'       options',
'        .toolbar',
'        .data[options.toolbar.data.length - 1]',
'        .controls',
'        .unshift(',
'            {',
'                type: ''MENU'',',
'                label: apex.lang.getMessage("APEX.ISSUES.JS.TEMPLATE"),',
'                menu: {',
'                    items: templateMenu',
'                }',
'            }',
'        );',
'    }',
'    ',
'    // Add the Open Dialog',
' ',
'   ',
'    return options;',
'}'))
,p_attribute_01=>'FULL'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(11428653597280850.4605)
,p_name=>'P100_FILES_INFO'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(4929538370267901.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(11591683961975602.4605)
,p_name=>'P100_FILE_NAME_SLUG'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(11426346067280827.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(156403868198150741.4605)
,p_name=>'P100_RELATED_FEEDBACK'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(6186211948627143.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(562258638644331715.4605)
,p_name=>'P100_RESPONSE_TEMPLATES'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(5446940561568844.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(581217966139849507.4605)
,p_name=>'P100_ALLOW_ISSUE_FILES_YN'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(4929538370267901.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(581218638645849514.4605)
,p_name=>'P100_ISSUE_DOESNT_EXIST'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(4873675327998306.4605)
,p_item_default=>'The Issue requested does not exist in this workspace.'
,p_prompt=>unistr('O problema n\00E3o existe')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null ',
'  from wwv_flow_issues',
'where id = :P100_ISSUE_ID',
'  and security_group_id = :flow_security_group_id'))
,p_display_when_type=>'NOT_EXISTS'
,p_field_template=>wwv_flow_api.id(571215478963548485.4605)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1664804295663426.4605)
,p_computation_sequence=>10
,p_computation_item=>'P100_REQUEST'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>':REQUEST'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(11427275187280836.4605)
,p_computation_sequence=>20
,p_computation_item=>'P100_COMMENT'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(562258742389331716.4605)
,p_computation_sequence=>30
,p_computation_item=>'P100_RESPONSE_TEMPLATES'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_json     varchar2(32767);',
'begin ',
'    l_json := l_json ||''['';',
'    --',
'    for templates in (select template_name, id',
'                        from wwv_flow_issue_templates',
'                       where template_type = ''RESPONSE''',
'                         and security_group_id = :flow_security_group_id',
'                     )',
'    loop',
'        l_json := l_json ',
'                  || ''{',
'                             "templateName": "''||apex_escape.json(templates.template_name)||''",',
'                             "templateID": "''||templates.id||''"',
'                       },'';',
'    end loop;',
'    l_json := rtrim(l_json,'','');',
'    --',
'    l_json := l_json || '']'';',
'    return l_json;',
'--',
'end;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(156403948907150742.4605)
,p_computation_sequence=>40
,p_computation_item=>'P100_RELATED_FEEDBACK'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id ',
'  from wwv_flow_feedback ',
' where ISSUE_ID = :P100_ISSUE_ID',
'   and SECURITY_GROUP_ID = :flow_security_group_id'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(581218035298849508.4605)
,p_computation_sequence=>50
,p_computation_item=>'P100_ALLOW_ISSUE_FILES_YN'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ALLOW_ISSUE_FILES_YN',
'  from wwv_flow_companies',
' where provisioning_company_id = :flow_security_group_id;'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5610668348530314.4605)
,p_name=>'Change Subscription Status'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P100_SUBSCRIBED'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5610731991530315.4605)
,p_event_id=>wwv_flow_api.id(5610668348530314.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P100_SUBSCRIBED = ''Y'' then ',
'    wwv_flow_issue_int.add_subscribers(p_issue_id => :P100_ISSUE_ID, p_subscriber_ids => :APP_USER);',
'elsif :P100_SUBSCRIBED = ''N'' then ',
'    wwv_flow_issue_int.remove_subscribers(p_issue_id => :P100_ISSUE_ID, p_subscriber_ids => :APP_USER);',
'end if;'))
,p_attribute_02=>'P100_ISSUE_ID,P100_SUBSCRIBED'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5610892628530316.4605)
,p_event_id=>wwv_flow_api.id(5610668348530314.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(4929538370267901.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5611797666530325.4605)
,p_name=>'Manage Milestones Dialog Close'
,p_event_sequence=>30
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(5611080609530318.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5611847854530326.4605)
,p_event_id=>wwv_flow_api.id(5611797666530325.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(4874178306998311.4605)
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5611934378530327.4605)
,p_event_id=>wwv_flow_api.id(5611797666530325.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(4929538370267901.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5948003590329305.4605)
,p_name=>'Manage Labels Dialog Close'
,p_event_sequence=>40
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(5710376476527220.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5948166716329306.4605)
,p_event_id=>wwv_flow_api.id(5948003590329305.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(4874097402998310.4605)
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5948277520329307.4605)
,p_event_id=>wwv_flow_api.id(5948003590329305.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(4929538370267901.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(6186776800627148.4605)
,p_name=>'Actions Menu on Dialog Close'
,p_event_sequence=>50
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'[id^=issueActions_menu]'
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6186809967627149.4605)
,p_event_id=>wwv_flow_api.id(6186776800627148.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(4929538370267901.4605)
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6186963934627150.4605)
,p_event_id=>wwv_flow_api.id(6186776800627148.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(6335901170146534.4605)
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6332694523146501.4605)
,p_event_id=>wwv_flow_api.id(6186776800627148.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(4874097402998310.4605)
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6332760764146502.4605)
,p_event_id=>wwv_flow_api.id(6186776800627148.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>50
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(4874178306998311.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(6336201193146537.4605)
,p_name=>'Manage Assignees Dialog Clode'
,p_event_sequence=>80
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(6336046011146535.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6336368941146538.4605)
,p_event_id=>wwv_flow_api.id(6336201193146537.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(6335901170146534.4605)
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6336403753146539.4605)
,p_event_id=>wwv_flow_api.id(6336201193146537.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(4929538370267901.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(6448325525807340.4605)
,p_name=>'Issue Timleine Actions Dialog Closed '
,p_event_sequence=>120
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'#issueTimeline'
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6448490558807341.4605)
,p_event_id=>wwv_flow_api.id(6448325525807340.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(4929538370267901.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(11428499493280848.4605)
,p_name=>'View Attachments Dialog Close'
,p_event_sequence=>130
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(11426676059280830.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(15606984295231501.4605)
,p_event_id=>wwv_flow_api.id(11428499493280848.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P100_FILES_INFO'
,p_attribute_01=>'FUNCTION_BODY'
,p_attribute_06=>'return :P112_FILES_INFO;'
,p_attribute_08=>'N'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
end;
/
begin
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(11428517860280849.4605)
,p_event_id=>wwv_flow_api.id(11428499493280848.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var filesInfoArray,',
'	urlPrefix = ''#ISSUE_FILE#'',',
'	i,',
'	len,',
'	file,',
'	fileName,',
'	fileUrl,',
'	loadImagePrefix;',
'',
'if ($v(''P100_FILES_INFO'')) {',
'	filesInfoArray = JSON.parse($v(''P100_FILES_INFO''));',
'	len = filesInfoArray.length;',
'',
'	for (i = 0; i < len; i++) {',
'		file = filesInfoArray[i];',
'		fileName = file.n;',
'		fileUrl = urlPrefix + file.slug;',
'		loadImagePrefix = file.isImage ? ''!'' : '''';',
'',
'		insertFileReference(loadImagePrefix + ''['' + fileName + '']('' + fileUrl + '')'');',
'	}',
'',
'}',
''))
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1665340621663431.4605)
,p_event_id=>wwv_flow_api.id(11428499493280848.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(11426346067280827.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(40399849212841613.4605)
,p_name=>'Render Markdown After Refresh'
,p_event_sequence=>140
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(4929538370267901.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(40399925435841614.4605)
,p_event_id=>wwv_flow_api.id(40399849212841613.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'JAVASCRIPT_EXPRESSION'
,p_affected_elements=>'apex.widget.markdown.render(''.a-TimelineEntry-bodyContent'');'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1664959024663427.4605)
,p_name=>'Display File Not Found'
,p_event_sequence=>150
,p_condition_element=>'P100_REQUEST'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'FILENOTFOUND'
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1665033003663428.4605)
,p_event_id=>wwv_flow_api.id(1664959024663427.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.theme.openRegion("noFileFound");'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1665625507663434.4605)
,p_name=>'View Attachments Dialog CANCEL'
,p_event_sequence=>160
,p_triggering_element_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_element=>'document'
,p_bind_type=>'bind'
,p_bind_event_type=>'custom'
,p_bind_event_type_custom=>'customDialogClose'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1665711374663435.4605)
,p_event_id=>wwv_flow_api.id(1665625507663434.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(11426346067280827.4605)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(4930377421267909.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_BOX_BODY'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Issue Details'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'    select issue_number, ',
'           title, ',
'           slug, ',
'           wwv_flow_issue_int.get_user_name(created_by)||'' opened this issue ''||apex_util.get_since(created_on),',
'           status',
'      into :P100_ISSUE_NUMBER, ',
'           :P100_ISSUE_TITLE,',
'           :P100_ISSUE_SLUG,',
'           :P100_ISSUE_CREATE_MESSAGE,',
'           :P100_STATUS',
'      from wwv_flow_issues ',
'     where id = :P100_ISSUE_ID;',
'END;',
'          ',
'  '))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel obter os detalhes do problema.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P100_ISSUE_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6448767675807344.4605)
,p_process_sequence=>20
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'showComment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'',
'wwv_flow_issue_int.show_comment(p_comment_id =>apex_application.g_x01 );',
'',
'  ',
'sys.htp.p(''{"return": "SUCCESS"}'');',
'',
'    ',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6448855654807345.4605)
,p_process_sequence=>30
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'hideComment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'',
'wwv_flow_issue_int.hide_comment(p_comment_id => apex_application.g_x01);',
'',
'sys.htp.p(''{"return": "SUCCESS"}'');',
'    ',
'END;'))
,p_process_error_message=>'JOEY'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'DOUG'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6766034959282902.4605)
,p_process_sequence=>40
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'deleteComment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'',
'wwv_flow_issue_int.delete_comment(p_comment_id => apex_application.g_x01 );',
'',
'',
'sys.htp.p(''{"return": "SUCCESS"}'');',
'    ',
'END;'))
,p_process_error_message=>'JOEY'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'DOUG'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(11170716936554339.4605)
,p_process_sequence=>60
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'getResponseTemplate'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_template varchar2(32767);',
'begin ',
'    --',
'    for template in (select template_text',
'                        from wwv_flow_issue_templates',
'                       where id = apex_application.g_x01',
'                         and security_group_id = :flow_security_group_id',
'                     )',
'    loop',
'        l_template := ''{"text": "''||apex_escape.json(template.template_text)||''"}'';',
'    end loop;',
'    --',
'    sys.htp.p(l_template);',
'--',
'end;',
'',
''))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(11591516245975601.4605)
,p_process_sequence=>70
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'getAttachment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_file_blob wwv_flow_issue_attachments.file_blob%type;',
'    l_mime_type wwv_flow_issue_attachments.mime_type%type;',
'    l_charset   wwv_flow_issue_attachments.charset%type;',
'    l_file_name wwv_flow_issue_attachments.file_name%type;',
'begin    ',
'',
'    select file_blob,',
'           mime_type,',
'           charset, ',
'           file_name',
'      into l_file_blob,',
'           l_mime_type,',
'           l_charset,',
'           l_file_name',
'      from wwv_flow_issue_attachments',
'     where issue_id          = :P100_ISSUE_ID',
'       and file_name_slug    = :P100_FILE_NAME_SLUG',
'       and security_group_id = :flow_security_group_id;',
'       ',
'    -- download zip file to the browser',
'    sys.htp.init;',
'    apex_application.g_page_text_generated := true;',
'    wwv_flow_utilities.print_download_header (',
'        p_mime_type      => l_mime_type,',
'        p_mime_charset   => l_charset,',
'        p_file_name      => l_file_name,',
'        p_is_attachment  => true,',
'        p_content_length => length( l_file_blob ));',
'    sys.owa_util.http_header_close;',
'    sys.wpg_docload.download_file( l_file_blob );',
'    ',
'    apex_application.stop_apex_engine;',
'exception ',
'    when NO_DATA_FOUND then ',
'        apex_util.redirect_url(''f?p=4600:100:''||:APP_SESSION||'':FILENOTFOUND:NO:RP:P100_ISSUE_ID:''||:P100_ISSUE_ID);',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(15607567032231507.4605)
,p_process_sequence=>80
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'getFullText'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
' declare',
'     l_clob   clob;',
'     l_chunk  varchar2(32767);',
'     l_offset pls_integer;',
' begin',
'',
'if apex_application.g_x01 = ''ISSUE'' then ',
'     select issue_text',
'       into l_clob',
'       from wwv_flow_issues',
'      where id = to_number(apex_application.g_x02)',
'        and security_group_id = :flow_security_group_id;',
'     --',
'     while apex_string.next_chunk (',
'               p_str    => l_clob,',
'               p_chunk  => l_chunk,',
'               p_offset => l_offset )',
'     loop',
'         sys.htp.prn(apex_escape.html(l_chunk));',
'     end loop;',
'else ',
'     select comment_text',
'       into l_clob',
'       from wwv_flow_issue_comments',
'      where id = to_number(apex_application.g_x02)',
'        and security_group_id = :flow_security_group_id;',
'     --',
'     while apex_string.next_chunk (',
'               p_str    => l_clob,',
'               p_chunk  => l_chunk,',
'               p_offset => l_offset )',
'     loop',
'         sys.htp.prn(apex_escape.html(l_chunk));',
'     end loop;',
'end if;',
'',
'end;',
'',
''))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5712762134527244.4605)
,p_process_sequence=>10
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Save Comment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_comment_id number;',
'BEGIN',
'',
'IF :P100_COMMENT IS NOT NULL THEN ',
'    insert into wwv_flow_issue_comments ',
'    (Issue_id, comment_text)',
'    values',
'    (:P100_ISSUE_ID, :P100_COMMENT)',
'    returning id into l_comment_id;',
'    --',
'    commit;',
'    ',
'    --',
'    wwv_flow_issue_notify_int.add_notification( p_notification_type => ''COMMENT_ADD'',',
'                                                p_issue_id => null,',
'                                                p_comment_id => l_comment_id,',
'                                                p_event_id => null);',
'END IF;',
'',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'COMMENT,CLOSE,REOPEN'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6445917261807316.4605)
,p_process_sequence=>20
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Mark Issue Closed'
,p_process_sql_clob=>'wwv_flow_issue_int.set_status(:P100_ISSUE_ID, ''CLOSED'');'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(6333633915146511.4605)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6446071303807317.4605)
,p_process_sequence=>30
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Mark Issue Open'
,p_process_sql_clob=>'wwv_flow_issue_int.set_status(:P100_ISSUE_ID, ''OPEN'');'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(6333763850146512.4605)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(10420810126079406.4605)
,p_process_sequence=>40
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Soft Delete Issue'
,p_process_sql_clob=>'wwv_flow_issue_int.soft_delete_issue(p_issue_id => :P100_ISSUE_ID);'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'DELETE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
,p_process_success_message=>unistr('Problema exclu\00EDdo com sucesso.')
);
end;
/
prompt --application/pages/page_00101
begin
wwv_flow_api.create_page(
 p_id=>101.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Editar Texto do Problema'
,p_page_mode=>'MODAL'
,p_step_title=>'Editar Texto do Problema'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_javascript_file_urls=>'#IMAGE_PREFIX#apex_ui/js/issues.utils.js'
,p_step_template=>wwv_flow_api.id(126075773730973072.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6334297351146517.4605)
,p_plug_name=>'Texto do problema'
,p_region_css_classes=>'padding-md'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11846777498214663.4605)
,p_plug_name=>unistr('Regi\00E3o de Bot\00E3o ')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6400639309645830.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(11846777498214663.4605)
,p_button_name=>'APPLY'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6334306885146518.4605)
,p_name=>'P101_ISSUE_TEXT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(6334297351146517.4605)
,p_prompt=>'Texto do Problema'
,p_display_as=>'NATIVE_MARKDOWN_EDITOR'
,p_cSize=>80
,p_cHeight=>10
,p_field_template=>wwv_flow_api.id(10128482508892221.4605)
,p_item_template_options=>'#DEFAULT#'
,p_plugin_init_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(options){',
'    var markdownEditor = this;',
'    markdownEditor.onBeforePreviewText = function(text){',
'        return apex.issues.replacePrefixImage(text, ''P101_ISSUE_ID'');',
'    };',
'    ',
'    apex.issues.addAttachButton(options, ''P101_ALLOW_ISSUE_FILES_YN'', ''P101_ISSUE_TEXT'', ''P101_ATTACH_FILES_TARGET_URL'');',
'    //apex.issues.addHeadButton(options);',
'}'))
,p_attribute_01=>'SIMPLE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(40400426528841619.4605)
,p_name=>'P101_ISSUE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(6334297351146517.4605)
,p_item_default=>'P100_ISSUE_ID'
,p_item_default_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(495964836588606405.4605)
,p_name=>'P101_ALLOW_ISSUE_FILES_YN'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(6334297351146517.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(495965030999606407.4605)
,p_name=>'P101_ATTACH_FILES_TARGET_URL'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(6334297351146517.4605)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.prepare_url(',
'    p_url => ''f?p=''||:APP_ID||'':109:''||:APP_SESSION||''::::P109_ISSUE_ID:''||:P101_ISSUE_ID,',
'    p_checksum_type => ''SESSION''',
')'))
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(495964963214606406.4605)
,p_computation_sequence=>10
,p_computation_item=>'P101_ALLOW_ISSUE_FILES_YN'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ALLOW_ISSUE_FILES_YN',
'  from wwv_flow_companies',
' where provisioning_company_id = :flow_security_group_id;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6334562680146520.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Issue text'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin  ',
'    update wwv_flow_issues',
'      set  issue_text = :P101_ISSUE_TEXT',
'     where ID = :P100_ISSUE_ID',
'      and  security_group_id = :flow_security_group_id;',
'end;',
'',
''))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6334758153146522.4605)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6334403104146519.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'GET ISSUE_TEXT'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'select issue_text ',
'  into :P101_ISSUE_TEXT',
'  from wwv_flow_issues ',
' where id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id;',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00102
begin
wwv_flow_api.create_page(
 p_id=>102.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>unistr('Editar T\00EDtulo do Problema')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('Editar T\00EDtulo do Problema')
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_step_template=>wwv_flow_api.id(126075773730973072.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_dialog_height=>'300'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(12740780471989523.4605)
,p_plug_name=>unistr('T\00EDtulo do Problema')
,p_region_css_classes=>'padding-md'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18253260619057669.4605)
,p_plug_name=>unistr('Regi\00E3o de Bot\00E3o ')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6407041119843008.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(18253260619057669.4605)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(6335837729146533.4605)
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6335353569146528.4605)
,p_name=>'P102_ISSUE_SLUG'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(12740780471989523.4605)
,p_prompt=>'Novo'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(566754195708398878.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6407789750843020.4605)
,p_name=>'P102_ISSUE_TITLE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(12740780471989523.4605)
,p_prompt=>unistr('T\00EDtulo do Problema')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>80
,p_field_template=>wwv_flow_api.id(566754195708398878.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(6335646011146531.4605)
,p_validation_name=>'Validate Slug'
,p_validation_sequence=>10
,p_validation=>'return wwv_flow_issue_int.validate_slug(:P102_ISSUE_SLUG);'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Slug inv\00E1lido. Um slug s\00F3 pode conter caracteres min\00FAsculos, n\00FAmeros e tra\00E7os.')
,p_associated_item=>wwv_flow_api.id(6335353569146528.4605)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(6335777711146532.4605)
,p_validation_name=>'Slug is unique within workspace'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1''',
'  from wwv_flow_issues',
' where slug = :P102_ISSUE_SLUG',
'   and ID != :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('O slug deve ser exclusivo. Digite outro valor contendo apenas caracteres min\00FAsculos, n\00FAmeros e tra\00E7os.')
,p_associated_item=>wwv_flow_api.id(6335353569146528.4605)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(581220261201849530.4605)
,p_name=>'Generate Slug'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P102_ISSUE_TITLE'
,p_bind_type=>'bind'
,p_bind_event_type=>'keyup'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(581220371841849531.4605)
,p_event_id=>wwv_flow_api.id(581220261201849530.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>':P102_ISSUE_SLUG := wwv_flow_issue_int.gen_slug(:P102_ISSUE_TITLE);'
,p_attribute_02=>'P102_ISSUE_TITLE'
,p_attribute_03=>'P102_ISSUE_SLUG'
,p_attribute_04=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6408554903843037.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Issue title and slug'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin  ',
'    update wwv_flow_issues',
'      set  title = :P102_ISSUE_TITLE, ',
'           slug = :P102_ISSUE_SLUG',
'     where ID = :P100_ISSUE_ID',
'      and  security_group_id = :flow_security_group_id;',
'end;',
'',
''))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(6407041119843008.4605)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6408168465843036.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Title '
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'select TITLE,',
'       SLUG',
'  into :P102_ISSUE_TITLE,',
'       :P102_ISSUE_SLUG',
'  from wwv_flow_issues ',
' where id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id;',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00103
begin
wwv_flow_api.create_page(
 p_id=>103.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Marcar como Duplicado'
,p_page_mode=>'MODAL'
,p_step_title=>'Marcar como Duplicado'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_step_template=>wwv_flow_api.id(694269863376113197.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6336576116146540.4605)
,p_plug_name=>unistr('Coment\00E1rio')
,p_region_name=>'comment_region'
,p_region_template_options=>'#DEFAULT#:a-Form--labelsAbove'
,p_region_attributes=>'style="display:none;"'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19170670253487938.4605)
,p_plug_name=>'Pesquisar'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--noBorder:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(24683150400556084.4605)
,p_plug_name=>unistr('Regi\00E3o de Bot\00E3o ')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6430438945498420.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(24683150400556084.4605)
,p_button_name=>'MARK_DUPLICATE'
,p_button_static_id=>'MarkDuplicate'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_cattributes=>'style="disabled=true;"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6337229936146547.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(24683150400556084.4605)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(6434443563498451.4605)
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6336649483146541.4605)
,p_name=>'P103_COMMENTS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(6336576116146540.4605)
,p_prompt=>unistr('Coment\00E1rios')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>10
,p_field_template=>wwv_flow_api.id(566754195708398878.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6336765193146542.4605)
,p_name=>'P103_ISSUES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(19170670253487938.4605)
,p_prompt=>unistr('Problema de Duplica\00E7\00E3o')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Select ''#''||issue_number||'' ''||title d, id r',
'  from wwv_flow_issues',
' where security_group_id = :flow_security_group_id',
'   and id != :P100_ISSUE_ID',
' order by created_on asc , issue_number asc '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- O problema n\00E3o \00E9 uma duplica\00E7\00E3o -')
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(566754273980399706.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6444900084807306.4605)
,p_name=>'P103_CURRENT_DUP'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(19170670253487938.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(6337386049146548.4605)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(6337229936146547.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6337493785146549.4605)
,p_event_id=>wwv_flow_api.id(6337386049146548.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(6444468363807301.4605)
,p_name=>'On Change'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P103_ISSUES'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6444578083807302.4605)
,p_event_id=>wwv_flow_api.id(6444468363807301.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var newIssue = $v(''P103_ISSUES'');',
'var oldIssue = $v(''P103_CURRENT_DUP'');',
'',
'console.log( $v(''P103_ISSUES''));',
'console.log( $v(''P103_CURRENT_DUP''));',
'',
'if (!newIssue) { ',
'    if (!oldIssue ) { ',
'        $(''#comment_region'').hide();',
'        apex.item( "MarkDuplicate" ).disable();',
'    } else {',
'        $(''#comment_region'').show();',
'        apex.item( "MarkDuplicate" ).enable();',
'    } ',
'} else if (newIssue == oldIssue) {',
'    $(''#comment_region'').hide();',
'    apex.item( "MarkDuplicate" ).disable();',
'',
'} else {',
'    $(''#comment_region'').show();',
'    apex.item( "MarkDuplicate" ).enable();',
'',
'}',
''))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6433050199498449.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Duplicate and Create Comment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin  ',
'    -- Update the duplicate ',
'    if :P103_ISSUES IS NOT NULL then ',
'        wwv_flow_issue_int.add_duplicate( p_issue_id => :P100_ISSUE_ID,',
'                                           p_duplicate_issue_id => :P103_ISSUES,',
'                                           p_duplicate_identified_on => sysdate,',
'                                           p_duplicate_identified_by => :APP_USER);',
'    else',
'        wwv_flow_issue_int.remove_duplicate( p_issue_id => :P100_ISSUE_ID);',
'    end if;',
'      ',
'    ',
'    -- Add the Comment ',
'    if :P103_COMMENTS is not null then ',
'',
'        insert into wwv_flow_issue_comments ',
'            (Issue_id, comment_text)',
'            values',
'            (:P100_ISSUE_ID, :P103_COMMENTS);',
'        ',
'    end if;',
'end;',
'',
''))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6337539622146550.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load Duplicate'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select duplicate_of a, ',
'       duplicate_of b',
'  into :P103_ISSUES,',
'       :P103_CURRENT_DUP',
'  from wwv_flow_issues ',
' where id = :P100_ISSUE_ID',
'  and security_group_id = :flow_security_group_id;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_issues',
'where id = :P100_ISSUE_ID ',
'  and security_group_id = :flow_security_group_id ',
'  and duplicate_of is not null'))
,p_process_when_type=>'EXISTS'
);
end;
/
prompt --application/pages/page_00104
begin
wwv_flow_api.create_page(
 p_id=>104.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>unistr('Aplicativo Associado e P\00E1gina')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('Aplicativo Associado e P\00E1gina')
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_step_template=>wwv_flow_api.id(694269863376113197.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(12813282274569173.4605)
,p_plug_name=>unistr('Coment\00E1rio')
,p_region_name=>'comment_region'
,p_region_template_options=>'#DEFAULT#:a-Form--labelsAbove'
,p_region_attributes=>'style="display:none;"'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25647376411910571.4605)
,p_plug_name=>'Pesquisar'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--noBorder:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(31159856558978717.4605)
,p_plug_name=>unistr('Regi\00E3o de Bot\00E3o ')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6477306760422666.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(31159856558978717.4605)
,p_button_name=>'ASSIGN_PAGE'
,p_button_static_id=>'AssignPage'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_cattributes=>'style="disabled=true;"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6477772252422672.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(31159856558978717.4605)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(6482568654422746.4605)
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6445251176807309.4605)
,p_name=>'P104_PAGE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(25647376411910571.4605)
,p_prompt=>unistr('P\00E1gina ')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'  from wwv_flow_steps',
' where security_group_id = :flow_security_group_id and ',
'    FLOW_ID = :P104_APPLICATIONS',
' order by id'))
,p_lov_display_null=>'YES'
,p_lov_cascade_parent_items=>'P104_APPLICATIONS'
,p_ajax_items_to_submit=>'P104_APPLICAITONS'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(566754195708398878.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6445328286807310.4605)
,p_name=>'P104_ORIG_PAGE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(25647376411910571.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6478494381422678.4605)
,p_name=>'P104_APPLICATIONS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(25647376411910571.4605)
,p_prompt=>'Aplicativo'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'APPLICATION NAME RETURNING ID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id',
'       || ''. ''',
'       || name d,',
'       id r',
'  from wwv_flows f',
' where security_group_id = :flow_security_group_id',
'   and not exists (',
'    select null',
'      from wwv_flow_language_map',
'     where translation_flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
')',
'   and ( exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id is null',
'       and security_group_id = :flow_security_group_id',
')',
'    or exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
') )',
'order by id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Nenhum Aplicativo Designado -'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(566754195708398878.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6478889498422696.4605)
,p_name=>'P104_ORIG_APP'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(25647376411910571.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6479519038422698.4605)
,p_name=>'P104_COMMENTS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(12813282274569173.4605)
,p_prompt=>unistr('Coment\00E1rios')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>10
,p_field_template=>wwv_flow_api.id(566754195708398878.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(6480725217422741.4605)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(6477772252422672.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6481256132422742.4605)
,p_event_id=>wwv_flow_api.id(6480725217422741.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(6481571935422742.4605)
,p_name=>'On Change'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P104_APPLICATIONS,P104_PAGE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6482006217422743.4605)
,p_event_id=>wwv_flow_api.id(6481571935422742.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var newApp     = $v(''P104_APPLICATIONS'');',
'var oldApp     = $v(''P104_ORIG_APP'');',
'var newPage    = $v(''P104_PAGE'');',
'var oldPage    = $v(''P104_ORIG_PAGE'');',
'',
'',
'// If no app & page have been assigned',
'if (!newApp && !newPage) { ',
'    // If the current record has no app/page assigned',
'    if (!oldApp && !oldPage ) { ',
'        //Then there has been no change - Disable all the things.',
'        $(''#comment_region'').hide();',
'        apex.item( "AssignPage" ).disable();',
'    } else {',
'        //Otherwise, enable stuff ',
'        $(''#comment_region'').show();',
'        apex.item( "AssignPage" ).enable();',
'    } ',
'  // If the values are not null but the same as the originals  ',
'} else if (newApp === oldApp &&  newPage === oldPage) {',
'    // Then no change - Disable',
'    $(''#comment_region'').hide();',
'    apex.item( "AssignPage" ).disable();',
'} else {',
'    //Change is happening. ',
'    $(''#comment_region'').show();',
'    apex.item( "AssignPage" ).enable();',
'}',
''))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6480392587422739.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Association and create comment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin  ',
'    -- Update the Assignment ',
'    if :P104_APPLICATIONS is not null then ',
'        wwv_flow_issue_int.add_association(p_issue_id => :P100_ISSUE_ID,',
'                                            p_application_id => :P104_APPLICATIONS,',
'                                            p_page_id => :P104_PAGE);',
'    else ',
'        wwv_flow_issue_int.remove_association(p_issue_id => :P100_ISSUE_ID);',
'    end if;',
'    ',
'    -- Add the Comment ',
'    if :P104_COMMENTS is not null then ',
'',
'        insert into wwv_flow_issue_comments ',
'            (Issue_id, comment_text)',
'            values',
'            (:P100_ISSUE_ID, :P104_COMMENTS);',
'     ',
'    end if;',
' end;   ',
'  '))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6479952155422738.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load Assignment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select application_id , ',
'       application_id ,',
'       page_id ,',
'       page_id ',
'  into :P104_APPLICATIONS,',
'       :P104_ORIG_APP,',
'       :P104_PAGE,',
'       :P104_ORIG_PAGE',
'  from wwv_flow_issues ',
' where id = :P100_ISSUE_ID',
'  and security_group_id = :flow_security_group_id;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_issues',
'where id = :P100_ISSUE_ID ',
'  and security_group_id = :flow_security_group_id ',
'  and application_id is not null'))
,p_process_when_type=>'EXISTS'
);
end;
/
prompt --application/pages/page_00105
begin
wwv_flow_api.create_page(
 p_id=>105.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Favorecidos'
,p_page_mode=>'MODAL'
,p_step_title=>'Favorecidos'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_inline_css=>'.nodatafound {padding: 32px; text-align: center;}'
,p_step_template=>wwv_flow_api.id(126075773730973072.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_dialog_width=>'480'
,p_dialog_attributes=>'maxHeight: ''640px'''
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5445151085568826.4605)
,p_name=>'Favorecidos'
,p_template=>wwv_flow_api.id(214132567690623104.4605)
,p_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-ContentRowReport--hideIcons'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  null as ITEM_CUSTOM_ATTRS,',
'  null as ITEM_CSS_MODIFIERS,',
'  ',
'  apex_item.checkbox2(p_idx => 1, ',
'                      p_value => user_name, ',
'                      p_attributes =>( select ''CHECKED''',
'                                              from wwv_flow_issue_stakeholders s',
'                                          where s.stakeholder = u.user_name',
'                                            and s.issue_id = :P100_ISSUE_ID',
'                                            and s.stakeholder_type = ''ASSIGNEE'') || '' class="u-vh apex-ui-selector-input"'',',
'                           p_item_id => ''cb_''||user_name) || ''<label aria-labelledby="label_''||user_name||''" for="cb_''||user_name||''" class="apex-ui-selector"></label>''  as ITEM_SELECTION,',
'  ''<label for="cb_''||user_name||''" id="label_''||user_name||''">''||wwv_flow_issue_int.get_avatar (p_user_name => user_name, p_include_name => ''Y'')||''</label>'' as ITEM_TITLE,',
'  null as ITEM_ICON,',
'  null as ITEM_LINK,',
'  null as ITEM_DESCRIPTION,',
'  null as ITEM_MISC,',
'  null as ITEM_ACTIONS',
'  from wwv_flow_fnd_user u',
'  where security_group_id = :flow_security_group_id',
'    and wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => u.user_name) is not null',
'',
'',
'',
''))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(6811165341870886.4605)
,p_query_num_rows=>500
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>unistr('N\00E3o h\00E1 favorecidos.')
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8724532710916129.4605)
,p_query_column_id=>1
,p_column_alias=>'ITEM_CUSTOM_ATTRS'
,p_column_display_sequence=>1
,p_column_heading=>'Atributos Personalizados de Itens'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8724614189916130.4605)
,p_query_column_id=>2
,p_column_alias=>'ITEM_CSS_MODIFIERS'
,p_column_display_sequence=>2
,p_column_heading=>'Modificadores de Css de Itens'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8724716994916131.4605)
,p_query_column_id=>3
,p_column_alias=>'ITEM_SELECTION'
,p_column_display_sequence=>3
,p_column_heading=>unistr('Sele\00E7\00E3o de Item')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8724872976916132.4605)
,p_query_column_id=>4
,p_column_alias=>'ITEM_TITLE'
,p_column_display_sequence=>4
,p_column_heading=>unistr('T\00EDtulo do Item')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8724929432916133.4605)
,p_query_column_id=>5
,p_column_alias=>'ITEM_ICON'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\00CDcone do Item')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8725083927916134.4605)
,p_query_column_id=>6
,p_column_alias=>'ITEM_LINK'
,p_column_display_sequence=>6
,p_column_heading=>'Link de Item'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8725114396916135.4605)
,p_query_column_id=>7
,p_column_alias=>'ITEM_DESCRIPTION'
,p_column_display_sequence=>7
,p_column_heading=>unistr('Descri\00E7\00E3o do Item')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8725211699916136.4605)
,p_query_column_id=>8
,p_column_alias=>'ITEM_MISC'
,p_column_display_sequence=>8
,p_column_heading=>'Diversos Itens'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8725340384916137.4605)
,p_query_column_id=>9
,p_column_alias=>'ITEM_ACTIONS'
,p_column_display_sequence=>9
,p_column_heading=>unistr('A\00E7\00F5es do Item')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5446410161568839.4605)
,p_plug_name=>unistr('Regi\00E3o de Bot\00E3o ')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5446323081568838.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5446410161568839.4605)
,p_button_name=>'APPLY'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(165799887329198819.4605)
,p_name=>'Refresh Search'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P105_SEARCH'
,p_bind_type=>'bind'
,p_bind_event_type=>'keyup'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(581219915741849527.4605)
,p_event_id=>wwv_flow_api.id(165799887329198819.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>':P105_SEARCH := :P105_SEARCH;'
,p_attribute_02=>'P105_SEARCH'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(165799981641198820.4605)
,p_event_id=>wwv_flow_api.id(165799887329198819.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(5445151085568826.4605)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5446521079568840.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Process Assignees'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_assignees varchar2(4000);',
'    l_unassign  varchar2(4000);',
'BEGIN',
'  FOR i in 1..APEX_APPLICATION.G_F01.COUNT LOOP',
'    BEGIN',
'      IF APEX_APPLICATION.G_F01(i) IS NOT NULL THEN',
'          l_assignees := l_assignees ||APEX_APPLICATION.G_F01(i)||'':'';',
'      END IF;',
'      EXCEPTION WHEN DUP_VAL_ON_INDEX THEN NULL;',
'    END;',
'  END LOOP;',
'  ',
'  l_assignees := trim(BOTH '':'' from l_assignees);',
'  ',
'  wwv_flow_issue_int.add_assignees(p_issue_id => :P100_ISSUE_ID, p_assignee_ids => l_assignees);',
'  ',
'  for a in (select user_name from wwv_flow_fnd_user where security_group_id = :flow_security_group_id) LOOP',
'      if nvl(instr(l_assignees, a.user_name),0) = 0 then ',
'          l_unassign := l_unassign || a.user_name ||'':'';',
'      end if;',
'  end loop;',
'  ',
'  l_unassign := trim(BOTH '':'' from l_unassign);',
'  wwv_flow_issue_int.remove_assignees(p_issue_id => :P100_ISSUE_ID, p_assignee_ids => l_unassign);',
'  ',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5447125281568846.4605)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00106
begin
wwv_flow_api.create_page(
 p_id=>106.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Marcos'
,p_page_mode=>'MODAL'
,p_step_title=>'Marcos'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_inline_css=>'.nodatafound {padding: 32px; text-align: center;}'
,p_step_template=>wwv_flow_api.id(126075773730973072.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_dialog_width=>'480'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5612570225530333.4605)
,p_plug_name=>unistr('Regi\00E3o do Item')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(11082864205500636.4605)
,p_name=>'Marcos'
,p_region_name=>'milestones'
,p_template=>wwv_flow_api.id(214132567690623104.4605)
,p_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-ContentRowReport--hideIcons'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  null as ITEM_CUSTOM_ATTRS,',
'  null as ITEM_CSS_MODIFIERS,',
'  ',
'  apex_item.checkbox2(p_idx        => 1, ',
'                      p_value      => id, ',
'                      p_attributes =>( select ''CHECKED''',
'                                              from wwv_flow_issue_milestones im',
'                                          where im.issue_id = :P100_ISSUE_ID',
'                                            and im.milestone_id = m.id) || '' class="u-vh apex-ui-selector-input"'',',
'                      p_item_id     => ''cb_''||id) || ''<label class="apex-ui-selector" for="cb_''||id||''" aria-labelledby="label_''||id||''"></label>''  as ITEM_SELECTION,',
'  ''<label for="cb_''||id||''" id="label_''||id||''">''||milestone_name||''</label>'' as ITEM_TITLE,',
'  case ',
'      when milestone_status = ''CLOSED'' then ''fa fa-check-square xfam-check xfam-is-success u-success-text''',
'      when milestone_status = ''OPEN'' then',
'        case ',
'             when sysdate > milestone_date  then ''fa fa-exclamation-circle xfam-warning xfam-is-danger u-danger-text''',
'             when sysdate + 15 > milestone_date then ''fa fa-warning xfam-warning xfam-is-warning u-warning-text''',
'             else ''fa fa-flag-o''',
'        end ',
'  end as ITEM_ICON,',
'  null as ITEM_LINK,',
'  case ',
'      when milestone_status = ''CLOSED'' then ''<span class="fa fa-check-square u-success-text" aria-hidden="true"></span> Closed &mdash; '' || to_char(milestone_date, ''Month DD YYYY'')',
'      when milestone_status = ''OPEN'' then',
'        case ',
'             when sysdate > milestone_date  then ''<span class="fa fa-warning u-danger-text" aria-hidden="true"></span> Past due &mdash; '' || apex_util.get_since(milestone_date)',
'             when sysdate + 15 > milestone_date then ''<span aria-hidden="true" class="fa fa-info-square u-warning-text"></span> Due &mdash; '' || apex_util.get_since(milestone_date)',
'             else ''<span aria-hidden="true" class="fa fa-calendar-o"></span> Due &mdash; '' || apex_util.get_since(milestone_date)',
'        end ',
'  end as ITEM_DESCRIPTION,',
'',
'  -- apex_util.get_since(milestone_date) as ITEM_DESCRIPTION,',
'  null as ITEM_MISC,',
'  null as ITEM_ACTIONS',
'  ',
'  from wwv_flow_milestones m',
' where security_group_id = :flow_security_group_id',
'   and (',
'           (:P106_SHOW_CLOSED_YN is null and milestone_status = ''OPEN'')',
'           or',
'           (:P106_SHOW_CLOSED_YN = ''Y'')',
'       )',
' order by milestone_date asc',
''))
,p_ajax_enabled=>'Y'
,p_ajax_items_to_submit=>'P106_SHOW_CLOSED_YN'
,p_query_row_template=>wwv_flow_api.id(6811165341870886.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>'Nenhum Marco foi definido.'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8726052589916144.4605)
,p_query_column_id=>1
,p_column_alias=>'ITEM_CUSTOM_ATTRS'
,p_column_display_sequence=>1
,p_column_heading=>'Atributos Personalizados de Itens'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8726181300916145.4605)
,p_query_column_id=>2
,p_column_alias=>'ITEM_CSS_MODIFIERS'
,p_column_display_sequence=>2
,p_column_heading=>'Modificadores de Css de Itens'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8726213296916146.4605)
,p_query_column_id=>3
,p_column_alias=>'ITEM_SELECTION'
,p_column_display_sequence=>3
,p_column_heading=>unistr('Sele\00E7\00E3o de Item')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8726394719916147.4605)
,p_query_column_id=>4
,p_column_alias=>'ITEM_TITLE'
,p_column_display_sequence=>4
,p_column_heading=>unistr('T\00EDtulo do Item')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8726415030916148.4605)
,p_query_column_id=>5
,p_column_alias=>'ITEM_ICON'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\00CDcone do Item')
,p_use_as_row_header=>'N'
,p_column_html_expression=>'fa-lg #ITEM_ICON#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8726580151916149.4605)
,p_query_column_id=>6
,p_column_alias=>'ITEM_LINK'
,p_column_display_sequence=>6
,p_column_heading=>'Link de Item'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8726637197916150.4605)
,p_query_column_id=>7
,p_column_alias=>'ITEM_DESCRIPTION'
,p_column_display_sequence=>7
,p_column_heading=>unistr('Descri\00E7\00E3o do Item')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6872159638843401.4605)
,p_query_column_id=>8
,p_column_alias=>'ITEM_MISC'
,p_column_display_sequence=>8
,p_column_heading=>'Diversos Itens'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6872256299843402.4605)
,p_query_column_id=>9
,p_column_alias=>'ITEM_ACTIONS'
,p_column_display_sequence=>9
,p_column_heading=>unistr('A\00E7\00F5es do Item')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11084123281500649.4605)
,p_plug_name=>unistr('Regi\00E3o de Bot\00E3o ')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5639480379931867.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(11084123281500649.4605)
,p_button_name=>'APPLY'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5612072482530328.4605)
,p_name=>'P106_SHOW_CLOSED_YN'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(11084123281500649.4605)
,p_prompt=>unistr('Exibi\00E7\00E3o de Marcos')
,p_display_as=>'NATIVE_CHECKBOX'
,p_lov=>'STATIC:Show Closed Milestones;Y'
,p_field_template=>wwv_flow_api.id(571215478963548485.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5612275982530330.4605)
,p_name=>'Refresh on toggle'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P106_SHOW_CLOSED_YN'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5612362900530331.4605)
,p_event_id=>wwv_flow_api.id(5612275982530330.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(11082864205500636.4605)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5639889869931889.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Process Milestones'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_milestones varchar2(4000);',
'    l_unassign  varchar2(4000);',
'BEGIN',
'  FOR i in 1..APEX_APPLICATION.G_F01.COUNT LOOP',
'    BEGIN',
'      IF APEX_APPLICATION.G_F01(i) IS NOT NULL THEN',
'          l_milestones := l_milestones ||APEX_APPLICATION.G_F01(i)||'':'';',
'      END IF;',
'    END;',
'  END LOOP;',
'  ',
'  l_milestones := trim(BOTH '':'' from l_milestones);',
'  ',
'  wwv_flow_issue_int.add_milestones(p_issue_id => :P100_ISSUE_ID, p_milestone_ids => l_milestones);',
'  ',
'  for a in (select to_char(id) milestone_id',
'             from wwv_flow_milestones ',
'            where security_group_id = :flow_security_group_id) LOOP',
'      if nvl(instr(l_milestones, a.milestone_id),0) = 0 then ',
'          l_unassign := l_unassign || a.milestone_id ||'':'';',
'      end if;',
'  end loop;',
'  ',
'  l_unassign := trim(BOTH '':'' from l_unassign);',
'  wwv_flow_issue_int.remove_milestones(p_issue_id => :P100_ISSUE_ID, p_milestone_ids => l_unassign);',
'  ',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5640216218931891.4605)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00107
begin
wwv_flow_api.create_page(
 p_id=>107.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Labels'
,p_page_mode=>'MODAL'
,p_step_title=>'Labels'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.group h2 {',
'  margin-bottom: 8px;',
'  font-size: 14px;',
'  line-height: 24px;',
'}',
'',
'.group p {',
'  color: #707070;',
'  margin-top: -4px;',
'}',
'',
'.group-item {',
'  margin: 8px 0;',
'}',
'',
'.group {',
'  margin: 24px 24px 20px 24px;',
'}',
'',
'.group-item label {',
'  display: flex;',
'  align-items: center;',
'}',
''))
,p_step_template=>wwv_flow_api.id(126075773730973072.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_dialog_width=>'480'
,p_dialog_attributes=>'maxHeight: ''640px'''
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5947835348329303.4605)
,p_plug_name=>unistr('JavaScript para Caixas de Sele\00E7\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'    sys.htp.p(''<script>'');',
'    --',
'    for i in (select wwv_flow_issue_int.gen_slug(group_name) class',
'                from wwv_flow_label_groups ',
'               where values_are_exclusive = ''Y''',
'                 and security_group_id = :flow_security_group_id) ',
'    loop',
'        sys.htp.p(''$(".''||i.class||''").change(function() {',
'    $(".''||i.class||''").not(this).prop(''''checked'''', false);',
'});',
''');',
'    end loop;',
'    sys.htp.p(''</script>'');',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6874950282843429.4605)
,p_plug_name=>'Labels'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_label_count number;',
'    l_item_type         varchar2(30);',
'begin',
'    -- See if there are any label groups to process',
'    select count(*) ',
'      into l_label_count ',
'      from wwv_flow_labels',
'    where security_group_id = :flow_security_group_id;',
'    --',
'    if l_label_count = 0 then ',
'        sys.htp.p(''<div class="padding-lg nodatafound u-tC">'' || wwv_flow_lang.system_message(''APEX.ISSUES.NO_LABLES_FOUND'') || ''</div>'');',
'    else',
'    ',
'        for label_group in (',
'          select id,',
'                 group_name,',
'                 values_are_exclusive,',
'                 group_color,',
'                 wwv_flow_issue_int.gen_slug(group_name) group_slug,',
'                 (select count(*) ',
'                        from wwv_flow_issue_labels il, wwv_flow_labels l ',
'                        where il.issue_id = :P100_ISSUE_ID and il.label_id = l.id and l.label_group_id = g.id ',
'                  ) active_selections',
'            from wwv_flow_label_groups g',
'           where security_group_id = :flow_security_group_id',
'           order by group_name',
'        ) ',
'        loop',
'            if label_group.values_are_exclusive = ''Y'' then ',
'                l_item_type := ''radio'';',
'            else ',
'                l_item_type := ''checkbox'';',
'            end if;',
'            ',
'            sys.htp.p(''<div class="group">'');',
'            sys.htp.p(''<h2 id="group_''||label_group.group_slug||''">''||label_group.group_name||''</h2>'');',
'            sys.htp.p(''<div class="group-items" role="group" aria-labelledby="group_''||label_group.group_slug||''">'');',
'            for label in (',
'                select id,',
'                       label_name,',
'                       nvl(',
'                        (select ''checked '' from wwv_flow_issue_labels il where il.issue_id = :P100_ISSUE_ID and il.label_id = id),',
'                        '''') checked',
'                from wwv_flow_labels',
'                where security_group_id = :flow_security_group_id',
'                  and label_group_id = label_group.id',
'                order by display_sequence asc',
'            ) loop',
'                sys.htp.p(''<div class="group-item">'');',
'                sys.htp.p(''<label>'');',
'                sys.htp.p(''<input type="''||l_item_type||''" ''',
'                           ||''name="''||label_group.group_slug||''_''||label_group.id||''" ''',
'                           ||''value="''||label.id||''" ''',
'                           || label.checked',
'                           ||''class="u-vh label-item apex-ui-selector-input ''||label_group.group_name||''" ''',
'                           ||''id="cb_''||label.id||''">''',
'                           || ''<span class="apex-ui-selector"></span>''',
'                           || ''<span class="a-IssueLabel ''||label_group.group_color||''">''||label.label_name||''</span></label>'');',
'                sys.htp.p(''</label>'');',
'                sys.htp.p(''</div>''); -- close .group-item',
'            end loop;',
'    ',
'            if l_item_type = ''radio'' then',
'                sys.htp.p(''<div class="group-item">'');',
'                sys.htp.p(''<label>'');',
'                sys.htp.p(''<input type="radio" ''',
'                           ||''name="''||label_group.group_slug||''_''||label_group.id||''" ''',
'                           ||''value="" ''',
'                           ||''class="u-vh label-item apex-ui-selector-input ''||label_group.group_name||''" '');',
'    ',
'                if label_group.active_selections = 0 then ',
'                    sys.htp.prn(''checked'');',
'                end if;',
'    ',
'                sys.htp.prn(''>''',
'                           || ''<span class="apex-ui-selector"></span>''',
'                           || ''<span class="a-IssueLabel group-label-none">'' || wwv_flow_lang.system_message(''CA.NONE'') || ''</span></label>'');',
'                sys.htp.p(''</label>'');',
'                sys.htp.p(''</div>''); -- close .group-item',
'            end if;',
'            sys.htp.p(''</div>''); -- close .group-items',
'    ',
'            sys.htp.p(''</div>''); -- close .group',
'        end loop;',
'    end if;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(16891196011494332.4605)
,p_plug_name=>unistr('Regi\00E3o de Bot\00E3o ')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5809101813993699.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(16891196011494332.4605)
,p_button_name=>'APPLY'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6874689428843426.4605)
,p_name=>'P107_SELECTIONS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(6874950282843429.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(6874756006843427.4605)
,p_name=>'Update Selection on Change'
,p_event_sequence=>20
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'.label-item'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(6874876625843428.4605)
,p_event_id=>wwv_flow_api.id(6874756006843427.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var sel = '':'';',
'$(''.label-item:checked'').each(function(){',
'  if ($(this).val().length > 0) {',
'    sel = sel + $(this).val() + '':'';',
'  }',
'})',
'console.log(sel);',
'$s(''P107_SELECTIONS'',sel);'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5947984653329304.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Process Labels'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_labels     varchar2(4000);',
'    l_unassign   varchar2(4000);',
'begin',
'    --',
'    wwv_flow_issue_int.add_labels(p_issue_id => :p100_issue_id, p_label_ids => :P107_SELECTIONS);',
'    --',
'    for a in (',
'        select to_char(l.id) label_id',
'          from wwv_flow_labels l',
'         where l.security_group_id = :flow_security_group_id',
'    ) loop ',
'        --',
'        if nvl(instr(:P107_SELECTIONS, a.label_id),0) = 0 then',
'            l_unassign := l_unassign || a.label_id || '':'';',
'        end if;',
'    end loop;',
'    --',
'    l_unassign := trim(both '':'' from l_unassign);',
'    --',
'    wwv_flow_issue_int.remove_labels(p_issue_id => :p100_issue_id, p_label_ids => l_unassign);',
'',
'end;'))
,p_process_error_message=>'Erro... '
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5810648769993713.4605)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(5809101813993699.4605)
);
end;
/
prompt --application/pages/page_00108
begin
wwv_flow_api.create_page(
 p_id=>108.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>unistr('Edite Texto do Coment\00E1rio')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('Edite Texto do Coment\00E1rio')
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_javascript_file_urls=>'#IMAGE_PREFIX#apex_ui/js/issues.utils.js'
,p_step_template=>wwv_flow_api.id(126075773730973072.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(13052086800306811.4605)
,p_plug_name=>unistr('Texto do coment\00E1rio')
,p_region_css_classes=>'padding-md'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18564566947374957.4605)
,p_plug_name=>unistr('Regi\00E3o de Bot\00E3o ')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6719036574160314.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(18564566947374957.4605)
,p_button_name=>'APPLY'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6448597442807342.4605)
,p_name=>'P108_COMMENT_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(13052086800306811.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6718322419160311.4605)
,p_name=>'P108_COMMENT_TEXT'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(13052086800306811.4605)
,p_prompt=>unistr('Texto de Coment\00E1rio')
,p_display_as=>'NATIVE_MARKDOWN_EDITOR'
,p_cSize=>80
,p_cHeight=>10
,p_field_template=>wwv_flow_api.id(571215478963548485.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_plugin_init_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(options){    ',
'    var markdownEditor = this;',
'    markdownEditor.onBeforePreviewText = function(text){',
'        return apex.issues.replacePrefixImage(text, ''P100_ISSUE_ID_VALUE'');',
'    };',
'    apex.issues.addAttachButton(options, ''P108_ALLOW_ISSUE_FILES_YN'', ''P108_COMMENT_TEXT'', ''P108_ATTACH_FILES_TARGET_URL'');',
'}'))
,p_attribute_01=>'SIMPLE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(40399772608841612.4605)
,p_name=>'P100_ISSUE_ID_VALUE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(13052086800306811.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(40400181717841616.4605)
,p_name=>'P108_ALLOW_ISSUE_FILES_YN'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(13052086800306811.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(40400319525841618.4605)
,p_name=>'P108_ATTACH_FILES_TARGET_URL'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(13052086800306811.4605)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.prepare_url(',
'    p_url => ''f?p=''||:APP_ID||'':109:''||:APP_SESSION||''::::P109_ISSUE_ID:''||:P100_ISSUE_ID_VALUE,',
'    p_checksum_type => ''SESSION''',
')'))
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(40400239674841617.4605)
,p_computation_sequence=>10
,p_computation_item=>'P108_ALLOW_ISSUE_FILES_YN'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ALLOW_ISSUE_FILES_YN',
'  from wwv_flow_companies',
' where provisioning_company_id = :flow_security_group_id;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6719877740160327.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update comment text'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_comment_text clob;',
'',
'begin  ',
'    -- Get the original comment text ',
'    select comment_text ',
'      into l_comment_text',
'      from wwv_flow_issue_comments',
'     where id = :P108_COMMENT_ID',
'       and issue_id = :P100_ISSUE_ID',
'       and security_group_id = :flow_security_group_id;',
'       ',
'    -- Update the table with the new comment',
'    update wwv_flow_issue_comments',
'      set  comment_text = :P108_COMMENT_TEXT',
'     where ID = :P108_COMMENT_ID',
'      and  issue_id = :P100_ISSUE_ID',
'      and  security_group_id = :flow_security_group_id;',
'    --',
'    commit;',
'      ',
'    -- Track the edit passing the old comment text',
'    wwv_flow_issue_int.track_comment_edit(p_comment_id =>:P108_COMMENT_ID,  p_comment_text => l_comment_text);',
'',
'end;',
'',
''))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6720216213160328.4605)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6719437399160327.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'GET COMMENT_TEXT'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'select comment_text ',
'  into :P108_COMMENT_TEXT',
'  from wwv_flow_issue_comments ',
' where id = :P108_COMMENT_ID',
'   and issue_id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id;',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00109
begin
wwv_flow_api.create_page(
 p_id=>109.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Anexar Arquivo'
,p_alias=>'ATTACHMENTS'
,p_page_mode=>'MODAL'
,p_step_title=>'Anexar Arquivo'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// Set drag and drop labels',
'var fileUpload$ = apex.jQuery(''.apex-item-group--file:not(.upload-completed) .apex-item-file-dropzone'');',
'',
'fileUpload$.append("<span class=''a-FileDrop-heading''>" + apex.lang.getMessage("DATA.LOAD.DRAG_DROP_FILE_HERE") + "</span> ");',
'fileUpload$.append("<span class=''a-FileDrop-action''>" + apex.lang.getMessage("DATA.LOAD.CHOOSE_FILE") + "</span> ");',
'//fileUpload$.append("<span class=''a-FileDrop-formats''>" + apex.lang.getMessage("DATA.LOAD.FILE_FORMATS") + "</span>");'))
,p_inline_css=>'.a-Dialog-body {padding: 0 32px 32px 32px !important}'
,p_step_template=>wwv_flow_api.id(694269863376113197.4605)
,p_page_css_classes=>'a-Page--DataLoad.is-first-step'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_dialog_width=>'640'
,p_dialog_chained=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6446779703807324.4605)
,p_plug_name=>'Anexos'
,p_region_name=>'drag_drop_file'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(581217655310849504.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(6446779703807324.4605)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Submeter'
,p_button_position=>'BODY'
,p_button_condition_type=>'NEVER'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6446848859807325.4605)
,p_name=>'P109_FILE_BLOB'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(6446779703807324.4605)
,p_prompt=>'Adicionar Arquivos'
,p_display_as=>'NATIVE_FILE'
,p_cSize=>60
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(571215478963548485.4605)
,p_item_css_classes=>'a-FileDrop data-load-input'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'APEX_APPLICATION_TEMP_FILES'
,p_attribute_09=>'SESSION'
,p_attribute_10=>'Y'
,p_attribute_11=>'&P109_ISSUE_ALLOWED_FILE_TYPES.'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6446926953807326.4605)
,p_name=>'P109_ISSUE_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(6446779703807324.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6447084409807327.4605)
,p_name=>'P109_FILES_INFO'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(6446779703807324.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(156404580728150748.4605)
,p_name=>'P109_ISSUE_FILES_YN'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(6446779703807324.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(156404626462150749.4605)
,p_name=>'P109_ISSUE_FS_LIMIT'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(6446779703807324.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(581217730789849505.4605)
,p_validation_name=>'Validate File Sizes'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_file_name_array           wwv_flow_global.vc_arr2;',
'    l_actual_file_size          number;',
'    l_too_large_count           number;',
'',
'begin ',
'    --      ',
'    l_too_large_count     := 0;',
'    ',
'    -- Split the selected files into an array',
'    l_file_name_array := apex_string.string_to_table(:P109_FILE_BLOB, '':'');',
'    ',
'    -- Loop through the files',
'    for i in 1 .. l_file_name_array.count loop',
'         -- Get the actual file size for the file',
'         select file_size',
'           into l_actual_file_size ',
'           from APEX_WORKSPACE_FILES',
'          where FILE_ID = substr(l_file_name_array(i),1,instr(l_file_name_array(i),''/'')-1);',
'         ',
'         -- if the file is too large. ',
'         if l_actual_file_size > :P109_ISSUE_FS_LIMIT then ',
'             l_too_large_count := l_too_large_count + 1;',
'         end if;',
'         --             ',
'    end loop;',
'    --',
'    if l_too_large_count > 0 then ',
'        if l_file_name_array.count > 1 then ',
'            return wwv_flow_lang.system_message(''APEX.ISSUES.FILE_SIZE_PLURAL'', p0=>to_char(:P109_ISSUE_FS_LIMIT,''999,999,999,999'') );',
'            --''One of these files is larger than the max file size of %0 bytes.'';',
'        else',
'            return wwv_flow_lang.system_message(''APEX.ISSUES.FILE_SIZE_SINGULAR'', p0=>to_char(:P109_ISSUE_FS_LIMIT,''999,999,999,999'') );',
'            --''This file is larger than the max file size of %0 bytes.'';',
'        end if;',
'     else ',
'         return null;',
'     end if;',
'     -- ',
'    RETURN null;',
'     ',
'',
'     EXCEPTION ',
'         WHEN OTHERS THEN ',
'             RETURN wwv_flow_lang.system_message(''APEX.ISSUES.FILE_SIZE_CHECK_ERROR'' );',
'             --''There was a problem checking file sizes. Please contact your system administrator.'';',
'     ',
'     ',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_always_execute=>'Y'
,p_when_button_pressed=>wwv_flow_api.id(581217655310849504.4605)
,p_associated_item=>wwv_flow_api.id(6446848859807325.4605)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(597621907466219135.4605)
,p_name=>'Upload File'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P109_FILE_BLOB'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(597622009250219136.4605)
,p_event_id=>wwv_flow_api.id(597621907466219135.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.jQuery(".apex-item-group--file").addClass("uploading");',
'apex.jQuery(".apex-item-file-dropzone").html("<span class=''a-DataLoad-progressMeter''></span>");'))
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(597622379221219139.4605)
,p_event_id=>wwv_flow_api.id(597621907466219135.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6447457944807331.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Upload Files'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_issue_int.upload_files(',
'    p_issue_id => :P109_ISSUE_ID,',
'    p_file_names => :P109_FILE_BLOB,',
'    p_files_info => :P109_FILES_INFO);'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6447591159807332.4605)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_attribute_01=>'P109_FILES_INFO'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6447687059807333.4605)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'Reset page'
,p_attribute_01=>'CLEAR_CACHE_CURRENT_PAGE'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(581217897275849506.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Compute File Limits'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select allow_issue_files_yn, ',
'       issue_fs_limit',
' into :P109_ISSUE_FILES_YN,',
'      :P109_ISSUE_FS_LIMIT',
' from wwv_flow_companies    ',
'where provisioning_company_id = :flow_security_group_id;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00110
begin
wwv_flow_api.create_page(
 p_id=>110.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Novo Problema - Escolher Modelo'
,p_page_mode=>'MODAL'
,p_step_title=>'Novo Problema'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_protection_level=>'C'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5711295175527229.4605)
,p_plug_name=>unistr('Cont\00EAiner do Bot\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5711777283527234.4605)
,p_plug_name=>'Sem Mensagem de Modelo'
,p_region_css_classes=>'padding-md'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('N\00E3o v\00EA um modelo que corresponda a sua necessidade? <a href="f?p=&APP_ID.:111:&APP_SESSION.:::111">Continuar sem um modelo</a>.')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5860054780152803.4605)
,p_name=>'Modelos de Problema'
,p_template=>wwv_flow_api.id(214132567690623104.4605)
,p_display_sequence=>10
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  id,',
'  '' '' as ITEM_CUSTOM_ATTRS,',
'  '' '' as ITEM_CSS_MODIFIERS,',
'  '' '' as ITEM_SELECTION,',
'  ''fa fa-lg fa-file-text-o'' as ITEM_ICON,',
'  apex_page.get_url(p_page => 111, p_items => ''P111_TEMPLATE_ID'', p_values => id) as ITEM_LINK,',
'  template_name as ITEM_TITLE,',
'  template_description as ITEM_DESCRIPTION,',
'  '' '' as ITEM_MISC,',
'  '' '' as ITEM_ACTIONS',
'  ',
'  from wwv_flow_issue_templates t',
' where t.template_type = ''ISSUE''',
'   and t.security_group_id = :flow_security_group_id',
'order by template_name'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(10733983191535295.4605)
,p_query_num_rows=>115
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>unistr('dados n\00E3o encontrados')
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_prn_format=>'PDF'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5860414121152820.4605)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8723661921916120.4605)
,p_query_column_id=>2
,p_column_alias=>'ITEM_CUSTOM_ATTRS'
,p_column_display_sequence=>2
,p_column_heading=>'Atributos Personalizados de Itens'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8723717790916121.4605)
,p_query_column_id=>3
,p_column_alias=>'ITEM_CSS_MODIFIERS'
,p_column_display_sequence=>3
,p_column_heading=>'Modificadores de Css de Itens'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8723818089916122.4605)
,p_query_column_id=>4
,p_column_alias=>'ITEM_SELECTION'
,p_column_display_sequence=>4
,p_column_heading=>unistr('Sele\00E7\00E3o de Item')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8723964910916123.4605)
,p_query_column_id=>5
,p_column_alias=>'ITEM_ICON'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\00CDcone do Item')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8724086277916124.4605)
,p_query_column_id=>6
,p_column_alias=>'ITEM_LINK'
,p_column_display_sequence=>6
,p_column_heading=>'Link de Item'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8724193230916125.4605)
,p_query_column_id=>7
,p_column_alias=>'ITEM_TITLE'
,p_column_display_sequence=>7
,p_column_heading=>unistr('T\00EDtulo do Item')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8724286914916126.4605)
,p_query_column_id=>8
,p_column_alias=>'ITEM_DESCRIPTION'
,p_column_display_sequence=>8
,p_column_heading=>unistr('Descri\00E7\00E3o do Item')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8724371112916127.4605)
,p_query_column_id=>9
,p_column_alias=>'ITEM_MISC'
,p_column_display_sequence=>9
,p_column_heading=>'Diversos Itens'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(8724408782916128.4605)
,p_query_column_id=>10
,p_column_alias=>'ITEM_ACTIONS'
,p_column_display_sequence=>10
,p_column_heading=>unistr('A\00E7\00F5es do Item')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5711473141527231.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5711295175527229.4605)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(11817687209752049.4605)
,p_branch_name=>'Redirect to New Issue if no Templates'
,p_branch_action=>'f?p=&APP_ID.:111:&SESSION.::&DEBUG.:RP,111::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'NOT_EXISTS'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  null',
'  from wwv_flow_issue_templates t',
' where t.template_type = ''ISSUE''',
'   and t.security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5711536102527232.4605)
,p_name=>'Close Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(5711473141527231.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5711653250527233.4605)
,p_event_id=>wwv_flow_api.id(5711536102527232.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
);
end;
/
prompt --application/pages/page_00111
begin
wwv_flow_api.create_page(
 p_id=>111.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Novo Problema > Informar Detalhes'
,p_page_mode=>'MODAL'
,p_step_title=>'Novo Problema'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_javascript_file_urls=>'#IMAGE_PREFIX#apex_ui/js/issues.utils.js'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var htmldb_delete_message = ''"DELETE_CONFIRM_MSG"'';',
'',
'// Function to allow inserting file references after uploading a file.',
'function insertFileReference(data){',
'    var cm = $(''.CodeMirror'')[0].CodeMirror; // Get the reference to CodeMirror',
'    var doc = cm.getDoc(); // Get the Document',
'    doc.replaceSelection(data); // Replace selection with passed string',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_protection_level=>'C'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5870252943250868.4605)
,p_plug_name=>'Criar Form'
,p_region_css_classes=>'a-Form--large'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(47229974494774989.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'TABLE'
,p_query_table=>'WWV_FLOW_ISSUES'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5874723955250887.4605)
,p_plug_name=>unistr('Bot\00F5es')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5875170956250888.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(5874723955250887.4605)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5877587528250891.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(5874723955250887.4605)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Criar Problema'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P111_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5711878297527235.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5874723955250887.4605)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(5208338701524668.4605)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,111::'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  null',
'  from wwv_flow_issue_templates t',
' where t.template_type = ''ISSUE''',
'   and t.security_group_id = :flow_security_group_id'))
,p_button_condition_type=>'EXISTS'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(5712448293527241.4605)
,p_branch_name=>'Return to Previoius Page'
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP,111:P100_ISSUE_ID:&P111_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5711911232527236.4605)
,p_name=>'P111_TEMPLATE_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5870575180250869.4605)
,p_name=>'P111_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_source=>'ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5870993442250874.4605)
,p_name=>'P111_TITLE'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_prompt=>unistr('T\00EDtulo')
,p_placeholder=>unistr('T\00EDtulo do Problema')
,p_source=>'TITLE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(566754273980399706.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_is_persistent=>'N'
,p_help_text=>unistr('Um t\00EDtulo descritivo sucinto para o problema.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5871330662250882.4605)
,p_name=>'P111_SLUG'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_prompt=>'Slug'
,p_placeholder=>'Slug do Problema'
,p_source=>'SLUG'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(566754273980399706.4605)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_is_persistent=>'N'
,p_help_text=>unistr('Uma string usada para identificar de forma exclusiva um problema. S\00F3 pode conter n\00FAmeros, letras e tra\00E7os.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5871767616250882.4605)
,p_name=>'P111_ISSUE_TEXT'
,p_source_data_type=>'CLOB'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_prompt=>'Texto do Problema'
,p_placeholder=>'Informe o problema aqui...'
,p_source=>'ISSUE_TEXT'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_MARKDOWN_EDITOR'
,p_cSize=>60
,p_cHeight=>12
,p_field_template=>wwv_flow_api.id(571215478963548485.4605)
,p_item_css_classes=>'a-IssueComments'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_is_persistent=>'N'
,p_plugin_init_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(options) {',
'    ',
'    // Add Attach Button',
'    ',
'    apex.issues.addAttachButton(options, ''P111_ALLOW_ISSUE_FILES_YN'', ''P111_ISSUE_TEXT'', ''P111_ATTACH_FILES_TARGET_URL'');',
'',
'    // Add the Open Dialog',
'    ',
'    return options;',
'}'))
,p_attribute_01=>'SIMPLE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5872163254250883.4605)
,p_name=>'P111_APPLICATION_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_prompt=>'Aplicativo'
,p_source=>'APPLICATION_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'APPLICATION NAME RETURNING ID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id',
'       || ''. ''',
'       || name d,',
'       id r',
'  from wwv_flows f',
' where security_group_id = :flow_security_group_id',
'   and not exists (',
'    select null',
'      from wwv_flow_language_map',
'     where translation_flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
')',
'   and ( exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id is null',
'       and security_group_id = :flow_security_group_id',
')',
'    or exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
') )',
'order by id'))
,p_cSize=>30
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5872511005250883.4605)
,p_name=>'P111_PAGE_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_prompt=>unistr('M\00F3dulo/P\00E1gina')
,p_source=>'PAGE_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'  from wwv_flow_steps',
' where security_group_id = :flow_security_group_id and ',
'    FLOW_ID = :P111_APPLICATION_ID',
' order by id'))
,p_lov_cascade_parent_items=>'P111_APPLICATION_ID'
,p_ajax_items_to_submit=>'P111_APPLICATION_ID'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>30
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(15633150389171571.4605)
,p_name=>'P111_FILES_INFO'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_prompt=>'File Info'
,p_display_as=>'NATIVE_HIDDEN'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(15633472921181621.4605)
,p_name=>'P111_ATTACH_FILES_TARGET_URL'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.prepare_url(',
'    p_url => ''f?p=''||:APP_ID||'':109:''||:APP_SESSION||'':::::'',',
'    p_checksum_type => ''SESSION''',
')'))
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(581218191068849509.4605)
,p_name=>'P111_ALLOW_ISSUE_FILES_YN'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(5870252943250868.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(581218293176849510.4605)
,p_computation_sequence=>10
,p_computation_item=>'P111_ALLOW_ISSUE_FILES_YN'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ALLOW_ISSUE_FILES_YN',
'  from wwv_flow_companies',
' where provisioning_company_id = :flow_security_group_id;'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(5712929932527246.4605)
,p_validation_name=>'Validate Slug'
,p_validation_sequence=>10
,p_validation=>'return wwv_flow_issue_int.validate_slug(:P111_SLUG);'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Slug inv\00E1lido. Um slug s\00F3 pode conter caracteres min\00FAsculos, n\00FAmeros e tra\00E7os.')
,p_when_button_pressed=>wwv_flow_api.id(5877587528250891.4605)
,p_associated_item=>wwv_flow_api.id(5871330662250882.4605)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(5713097318527247.4605)
,p_validation_name=>'Slug is unique within workspace'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1''',
'  from wwv_flow_issues',
' where slug = :P111_SLUG',
'   and ID != :P111_id',
'   and security_group_id = :flow_security_group_id'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('O slug deve ser exclusivo. Digite outro valor contendo apenas caracteres min\00FAsculos, n\00FAmeros e tra\00E7os.')
,p_when_button_pressed=>wwv_flow_api.id(5877587528250891.4605)
,p_associated_item=>wwv_flow_api.id(5871330662250882.4605)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5875263039250888.4605)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(5875170956250888.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5876071399250889.4605)
,p_event_id=>wwv_flow_api.id(5875263039250888.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(581220012785849528.4605)
,p_name=>'Generate Title Slug'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P111_TITLE'
,p_bind_type=>'bind'
,p_bind_event_type=>'keyup'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(581220144627849529.4605)
,p_event_id=>wwv_flow_api.id(581220012785849528.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>':P111_SLUG := wwv_flow_issue_int.gen_slug(:P111_TITLE);'
,p_attribute_02=>'P111_TITLE'
,p_attribute_03=>'P111_SLUG'
,p_attribute_04=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5878346054250893.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_api.id(5870252943250868.4605)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Create Form'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'Problema criado.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(15580499362474508.4605)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Upload Files'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_issue_int.upload_files(',
'    p_issue_id => :P111_ID,',
'    p_file_names => :P109_FILE_BLOB,',
'    p_files_info => :P109_FILES_INFO);'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5877986852250892.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_api.id(5870252943250868.4605)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Create Form'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5712229619527239.4605)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fill Issue Text'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    select template_text ',
'      into :P111_ISSUE_TEXT ',
'      from wwv_flow_issue_templates',
'     where id = :P111_TEMPLATE_ID',
'       and security_group_id = :flow_security_group_id;',
'exception ',
'    when no_data_found then ',
'        :P111_ISSUE_TEXT := '''';',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00112
begin
wwv_flow_api.create_page(
 p_id=>112.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Anexos'
,p_page_mode=>'MODAL'
,p_step_title=>'Anexos'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_dialog_attributes=>'close: function() { customCloseEvent(''customDialogClose'', {modalPageId: ''MODAL_CLOSE_FIXED''});}'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11544255581836121.4605)
,p_plug_name=>'Anexos'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(651492083233530570.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id,',
'       file_name,',
'       case',
'           when substr(mime_type, 1, 5) = ''image''        then',
'               wwv_flow_lang.system_message(''APEX.ISSUES.IMAGE'')',
'           when substr(mime_type, 1, 11) = ''Application'' then',
'               case',
'                    when substr(mime_type, 13) in (''zip'',''x-gzip'') then',
'                        wwv_flow_lang.system_message(''APEX.ISSUES.ZIP_FILE'')',
'                    else',
'                        wwv_flow_lang.system_message(''APEX.ISSUES.DOCUMENT'')',
'                end',
'            when substr(mime_type,1,4) = ''text'' then',
'                wwv_flow_lang.system_message(''APEX.ISSUES.TEXT_FILE'')',
'            else ',
'                wwv_flow_lang.system_message(''APEX.ISSUES.OTHER'')',
'       end  FILE_TYPE,',
'       sys.dbms_lob.getlength(file_blob) FILE_SIZE,',
'       sys.dbms_lob.getlength(file_blob) FILE_SIZE_DISPLAY,',
'       wwv_flow_issue_int.get_user_name(CREATED_BY) CREATED_BY, ',
'       apex_util.get_since(created_on) CREATED,',
'        ''<span style="display:flex"><button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--small" onclick="apex.page.submit({request:''''INSERT'''', set: {''''P112_ATTACHMENT_ID'''':''''''||id||''''''}, showWait: true});"  type="button"  style="mar'
||'gin-left:5px;"><span class="fa fa-download-alt" aria-hidden="true"></span></button>''||',
'        case ',
'            when instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0 OR  created_by = :APP_USER then ',
'                ''<button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--small" onclick="apex.page.submit({request:''''DELETE'''', set: {''''P112_ATTACHMENT_ID'''':''''''||id||''''''}, showWait: true});"  type="button"  style="margin-left:5px;"><spa'
||'n class="fa fa-trash-o" aria-hidden="true"></span></button>'' ',
'            else ',
'                null',
'        end ||''</span>'' ACTIONS',
'  from WWV_FLOW_ISSUE_ATTACHMENTS',
' where issue_id = :P100_ISSUE_ID',
'and security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(11171837955554350.4605)
,p_max_row_count=>'1000000'
,p_no_data_found_message=>'Nenhum anexo foi encontrado para esse problema.'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_search_bar=>'N'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_owner=>'DGAULT'
,p_internal_uid=>11171837955554350
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(15579778002474501.4605)
,p_db_column_name=>'ID'
,p_display_order=>10
,p_column_identifier=>'A'
,p_column_label=>'Id'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(15579859930474502.4605)
,p_db_column_name=>'FILE_NAME'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>'Nome do Arquivo'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(11428064698280844.4605)
,p_db_column_name=>'FILE_TYPE'
,p_display_order=>30
,p_column_identifier=>'H'
,p_column_label=>'Tipo de Arquivo'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(15579993911474503.4605)
,p_db_column_name=>'FILE_SIZE'
,p_display_order=>40
,p_column_identifier=>'C'
,p_column_label=>'Nome do Arquivo'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'NUMBER'
,p_format_mask=>'DOWNLOAD:WWV_FLOW_ISSUE_ATTACHMENTS:FILE_BLOB:ID::MIME_TYPE:FILE_NAME:UPDATED_ON:CHARSET:attachment:#FILE_NAME#:'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(15580086208474504.4605)
,p_db_column_name=>'FILE_SIZE_DISPLAY'
,p_display_order=>50
,p_column_identifier=>'D'
,p_column_label=>'Tamanho do Arquivo'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(15580127853474505.4605)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>60
,p_column_identifier=>'E'
,p_column_label=>'Criado por'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(15580281878474506.4605)
,p_db_column_name=>'CREATED'
,p_display_order=>70
,p_column_identifier=>'F'
,p_column_label=>'Criado'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(15580327924474507.4605)
,p_db_column_name=>'ACTIONS'
,p_display_order=>80
,p_column_identifier=>'G'
,p_column_label=>unistr('A\00E7\00F5es')
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(11428129516280845.4605)
,p_name=>'P112_ATTACHMENT_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(11544255581836121.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(15598869492897412.4605)
,p_name=>'P112_FILES_INFO'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(11544255581836121.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(11428216101280846.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Build Attachment JSON'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_is_image       boolean := false;',
'    l_attachment     wwv_flow_issue_attachments%rowtype;',
'BEGIN ',
'    apex_json.initialize_clob_output;',
'    apex_json.open_array();',
'    --',
'    select * ',
'      into l_attachment',
'      from wwv_flow_issue_attachments',
'     where id = :P112_ATTACHMENT_ID',
'       and security_group_id = :flow_security_group_id; ',
'    --',
'    if instr(l_attachment.mime_type, ''image'') > 0 then  ',
'        l_is_image := true;',
'    else ',
'        l_is_image := false;',
'    end if;',
'    --',
'    apex_json.open_object;',
'    --',
'    apex_json.write(''n'',l_attachment.file_name);',
'    apex_json.write(''slug'', l_attachment.file_name_slug);',
'    apex_json.write(''id'',l_attachment.id);',
'    apex_json.write(''isImage'',l_is_image);',
'    --',
'    apex_json.close_object;',
'    --',
'    apex_json.close_array();',
'    --',
'    :P112_FILES_INFO := apex_json.get_clob_output;',
'    --',
'    apex_json.free_output;',
'EXCEPTION ',
'    when NO_DATA_FOUND then ',
'        :P112_FILES_INFO := '''';',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'INSERT'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(11428357134280847.4605)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog for Insert'
,p_attribute_01=>'P112_FILES_INFO'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'INSERT'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(15607015948231502.4605)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Delete Attachment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'wwv_flow_issue_int.remove_attachment(p_issue_id => :P100_ISSUE_ID, p_attachment_id => :P112_ATTACHMENT_ID);'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('Anexo exclu\00EDdo com sucesso.')
);
end;
/
prompt --application/pages/page_00120
begin
wwv_flow_api.create_page(
 p_id=>120.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Editar Problema'
,p_page_mode=>'MODAL'
,p_step_title=>'Editar Problema'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883594172125992)
,p_javascript_code=>'var htmldb_delete_message = ''"DELETE_CONFIRM_MSG"'';'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_protection_level=>'C'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5910690798794428.4605)
,p_plug_name=>'Criar Form'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(47229974494774989.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'TABLE'
,p_query_table=>'WWV_FLOW_ISSUES'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5917978397794433.4605)
,p_plug_name=>unistr('Bot\00F5es')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5918357445794434.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5917978397794433.4605)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5919932600794436.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(5917978397794433.4605)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Excluir'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P120_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5920371002794436.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(5917978397794433.4605)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P120_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5920753096794436.4605)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(5917978397794433.4605)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Criar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P120_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5910972472794429.4605)
,p_name=>'P120_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_source=>'ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5911357220794429.4605)
,p_name=>'P120_TITLE'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_prompt=>unistr('T\00EDtulo')
,p_source=>'TITLE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(457861279924367968.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5911786581794429.4605)
,p_name=>'P120_SLUG'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_prompt=>'Slug'
,p_source=>'SLUG'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(457861279924367968.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5912147053794430.4605)
,p_name=>'P120_DUPLICATE_OF'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_prompt=>'Duplicidade de'
,p_source=>'DUPLICATE_OF'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5912598076794430.4605)
,p_name=>'P120_ISSUE_TEXT'
,p_source_data_type=>'CLOB'
,p_is_required=>true
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_prompt=>'Texto do Problema'
,p_source=>'ISSUE_TEXT'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>255
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(457861279924367968.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5913769127794431.4605)
,p_name=>'P120_APPLICATION_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_prompt=>'Id do Aplicativo'
,p_source=>'APPLICATION_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'APPLICATION NAME RETURNING ID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id',
'       || ''. ''',
'       || name d,',
'       id r',
'  from wwv_flows f',
' where security_group_id = :flow_security_group_id',
'   and not exists (',
'    select null',
'      from wwv_flow_language_map',
'     where translation_flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
')',
'   and ( exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id is null',
'       and security_group_id = :flow_security_group_id',
')',
'    or exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
') )',
'order by id'))
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5914183028794431.4605)
,p_name=>'P120_PAGE_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_prompt=>unistr('Id da P\00E1gina')
,p_source=>'PAGE_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'  from wwv_flow_steps',
' where security_group_id = :flow_security_group_id and ',
'    FLOW_ID = :P111_APPLICATION_ID',
' order by id'))
,p_lov_cascade_parent_items=>'P120_APPLICATION_ID'
,p_ajax_items_to_submit=>'P120_APPLICATION_ID'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5914564763794431.4605)
,p_name=>'P120_STATUS'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5910690798794428.4605)
,p_prompt=>'Status'
,p_source=>'STATUS'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ISSUE_STATUSES_STATIC'
,p_lov=>'.'||wwv_flow_api.id(5664182917694426.4605)||'.'
,p_lov_display_null=>'YES'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5918466035794434.4605)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(5918357445794434.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5919254149794435.4605)
,p_event_id=>wwv_flow_api.id(5918466035794434.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5921585551794437.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_api.id(5910690798794428.4605)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Create Form'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5921946123794437.4605)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'CREATE,SAVE,DELETE'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5921122463794436.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_api.id(5910690798794428.4605)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Create Form'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00200
begin
wwv_flow_api.create_page(
 p_id=>200.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Marcos'
,p_alias=>'MILESTONES'
,p_step_title=>'Marcos'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883665819126633)
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-ContentRowReport-itemMisc {',
'  flex-direction: column;',
'  align-items: flex-start;',
'  flex-basis: 33.333%;',
'}',
'',
'.a-ContentRowReport p {',
'  margin: 8px 0 0 0;',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4933933334267945.4605)
,p_plug_name=>'Marcos'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(651492083233530570.4605)
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with milestone_data as ',
'( select id,',
'       milestone_name,',
'       milestone_desc,',
'       milestone_date,',
'       milestone_status,',
'       (select count(*) ',
'          from wwv_flow_issues i, wwv_flow_issue_milestones m ',
'         where i.id = m.issue_id ',
'           and m.milestone_id = mi.ID',
'           and i.security_group_id = :flow_security_group_id',
'           and m.security_group_id = :flow_security_group_id ',
'           and i.status = ''OPEN'') OPEN_COUNT, ',
'      (select count(*) ',
'          from wwv_flow_issues i, wwv_flow_issue_milestones m ',
'         where i.id = m.issue_id ',
'           and m.milestone_id = mi.ID',
'           and i.security_group_id = :flow_security_group_id',
'           and m.security_group_id = :flow_security_group_id ',
'           and i.status = ''CLOSED'') CLOSED_COUNT,  ',
'       created_on,',
'       created_by,',
'       updated_on,',
'       updated_by,',
'       milestone_slug,',
'       milestone_id,',
'       apex_page.get_url(p_page => 205, p_items => ''P205_ID'', p_values => id, p_clear_cache => 205) milestone_link,',
'       case ',
'           when milestone_status = ''CLOSED'' then ''<span class="fa fa-check-square u-success-text" aria-hidden="true"></span> '' || wwv_flow_lang.system_message(''CLOSED'') || '' &mdash; '' || to_char(milestone_date, ''Month DD YYYY'')',
'           when milestone_status = ''OPEN'' then',
'             case ',
'                  when sysdate > milestone_date  then ''<span class="fa fa-warning u-danger-text" aria-hidden="true"></span> '' || wwv_flow_lang.system_message(''PAST_DUE'') || '' &mdash; '' || apex_util.get_since(milestone_date)',
'                  when sysdate + 15 > milestone_date then ''<span aria-hidden="true" class="fa fa-info-square u-warning-text"></span> '' || wwv_flow_lang.system_message(''DUE'') || '' &mdash; '' || apex_util.get_since(milestone_date)',
'                  else ''<span aria-hidden="true" class="fa fa-calendar-o"></span> '' || wwv_flow_lang.system_message(''DUE'') || '' &mdash; '' || apex_util.get_since(milestone_date)',
'             end ',
'       end as DISPLAY_STATUS,',
'       case ',
'           when milestone_status = ''CLOSED'' then ''fa-check-square u-success-text''',
'           when milestone_status = ''OPEN'' then',
'             case ',
'                  when sysdate > milestone_date  then ''fa-warning u-danger-text''',
'                  when sysdate + 15 > milestone_date then ''fa-info-square u-warning-text''',
'                  else ''fa-calendar-o''',
'             end ',
'       end as MILESTONE_ICON',
'  from wwv_flow_milestones mi',
' where security_group_id = :flow_security_group_id)',
'select milestone_name,',
'       milestone_desc,',
'       milestone_date,',
'       milestone_status,',
'       open_count,',
'       closed_count,',
'       to_char(decode((closed_count + open_count),0,0,((closed_count / (closed_count + open_count))*100)), ''990'') percent_complete ,',
'       created_on,',
'       created_by,',
'       updated_on,',
'       updated_by,',
'       milestone_slug,',
'       milestone_id,',
'       milestone_link,',
'       display_status,',
'       milestone_icon',
'  from milestone_data',
''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(5312744428399715.4605)
,p_max_row_count=>'1000000'
,p_no_data_found_message=>'Nenhum Marco foi definido.'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_detail_view_enabled_yn=>'Y'
,p_detail_view_before_rows=>'<div class="a-ContentRowReport">'
,p_detail_view_for_each_row=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item">',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle"><a href="#MILESTONE_LINK#">#MILESTONE_NAME# - #MILESTONE_DATE#</a></h3>',
'        <div class="a-ContentRowReport-itemDescription">',
'          <div class="a-Attributes">',
'            <span class="a-Attribute">#DISPLAY_STATUS#</span>',
'            <span class="a-Attribute"><span aria-hidden="true" class="fa fa-clock-o"></span> Last updated #UPDATED_ON#</span>',
'          </div>',
'          <div>#MILESTONE_DESC#</div>',
'        </div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">',
'        <div class="a-Report-percentChart"><div class="a-Report-percentChart-fill" style="width: #PERCENT_COMPLETE#%;"></div>',
'        <span class="u-VisuallyHidden">#PERCENT_COMPLETE#%</span></div>',
'        <div class="a-Attributes">',
'          <span class="a-Attribute"><strong>#PERCENT_COMPLETE#%</strong> complete</span>',
'          <span class="a-Attribute"><strong>#OPEN_COUNT#</strong> open</span>',
'          <span class="a-Attribute"><strong>#CLOSED_COUNT#</strong> closed</span>',
'          </div>',
'      </div>',
'    </div>',
'  </div>',
'</div>',
''))
,p_detail_view_after_rows=>'</div>'
,p_owner=>'DGAULT'
,p_internal_uid=>5312744428399715
);
wwv_flow_api.create_worksheet_col_group(
 p_id=>wwv_flow_api.id(5167526317832126.4605)
,p_name=>'Problemas Designados'
,p_display_sequence=>10
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5313024374399718.4605)
,p_db_column_name=>'MILESTONE_NAME'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>'Marco'
,p_column_link=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:RP,210:P205_ID:#MILESTONE_ID#'
,p_column_linktext=>'#MILESTONE_NAME#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5313700155399725.4605)
,p_db_column_name=>'MILESTONE_SLUG'
,p_display_order=>40
,p_column_identifier=>'J'
,p_column_label=>'Slug de Marco'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(6449062434807347.4605)
,p_db_column_name=>'MILESTONE_DESC'
,p_display_order=>50
,p_column_identifier=>'P'
,p_column_label=>unistr('Descri\00E7\00E3o do Marco')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5313124988399719.4605)
,p_db_column_name=>'MILESTONE_DATE'
,p_display_order=>60
,p_column_identifier=>'D'
,p_column_label=>'Data'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10420770260079405.4605)
,p_db_column_name=>'MILESTONE_STATUS'
,p_display_order=>70
,p_column_identifier=>'Q'
,p_column_label=>'Status do Marco'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5313436691399722.4605)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>80
,p_column_identifier=>'G'
,p_column_label=>'Criado por'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(5669473527908412)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5313344981399721.4605)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>90
,p_column_identifier=>'F'
,p_column_label=>'Criado em'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5313619600399724.4605)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>100
,p_column_identifier=>'I'
,p_column_label=>'Atualizado por'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(5669473527908412)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5313524844399723.4605)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>110
,p_column_identifier=>'H'
,p_column_label=>'Atualizado em'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5167277084832123.4605)
,p_db_column_name=>'OPEN_COUNT'
,p_display_order=>120
,p_group_id=>wwv_flow_api.id(5167526317832126.4605)
,p_column_identifier=>'M'
,p_column_label=>'Aberto'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5167407311832125.4605)
,p_db_column_name=>'CLOSED_COUNT'
,p_display_order=>140
,p_group_id=>wwv_flow_api.id(5167526317832126.4605)
,p_column_identifier=>'O'
,p_column_label=>'Fechado'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5167603974832127.4605)
,p_db_column_name=>'MILESTONE_ID'
,p_display_order=>150
,p_column_identifier=>'R'
,p_column_label=>'Id do Marco'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(6875382435843433.4605)
,p_db_column_name=>'MILESTONE_ICON'
,p_display_order=>170
,p_column_identifier=>'T'
,p_column_label=>unistr('\00CDcone do Marco')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10421138593079409.4605)
,p_db_column_name=>'DISPLAY_STATUS'
,p_display_order=>200
,p_column_identifier=>'W'
,p_column_label=>'Exibir Status'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10421226247079410.4605)
,p_db_column_name=>'MILESTONE_LINK'
,p_display_order=>210
,p_column_identifier=>'X'
,p_column_label=>'Link do Marco'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(10421322398079411.4605)
,p_db_column_name=>'PERCENT_COMPLETE'
,p_display_order=>220
,p_column_identifier=>'Y'
,p_column_label=>unistr('Percentual Conclu\00EDdo')
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5401082943234720.4605)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>unistr('<p>Eventos de rastreamento de marcos. \00C9 poss\00EDvel designar problemas a um ou mais marcos.</p>')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(44794417850280067.4605)
,p_plug_name=>unistr('Utilit\00E1rios')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_list_id=>wwv_flow_api.id(10555300999175496.4605)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(702419290542782266.4605)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5314340360399731.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(4933933334267945.4605)
,p_button_name=>'CREATE_MILESTIONE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(656569185201725731.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Criar Marco'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:210:&SESSION.::&DEBUG.:RP,210::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(5400915637234719.4605)
,p_computation_sequence=>10
,p_computation_item=>'F4600_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'&APP_PAGE_ID.'
);
end;
/
prompt --application/pages/page_00205
begin
wwv_flow_api.create_page(
 p_id=>205.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Marco'
,p_step_title=>'Marco'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883665819126633)
,p_step_template=>wwv_flow_api.id(694810454825113224.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_protection_level=>'C'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5314412550399732.4605)
,p_plug_name=>'&P205_MILESTONE_NAME.'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--showTitle:a-Form--leftLabels'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5314892942399736.4605)
,p_plug_name=>'Region Display Selector'
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5314983701399737.4605)
,p_plug_name=>'Hidden Items'
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5315591150399743.4605)
,p_name=>'Milestone'
,p_display_sequence=>20
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4600P205 */',
'    milestone_name,',
'    milestone_date,',
'    milestone_status,',
'    milestone_desc,',
'    wwv_flow_issue_int.get_avatar(p_user_name => created_by, p_image_size => 16, p_include_name => ''Y'', p_include_link => ''Y'') CREATED_BY,',
'    apex_util.get_since(m.created_on) CREATED_ON,',
'    wwv_flow_issue_int.get_avatar(p_user_name => updated_by, p_image_size => 16, p_include_name => ''Y'', p_include_link => ''Y'') UPDATED_BY,',
'    apex_util.get_since(m.updated_on) UPDATED_ON',
'from wwv_flow_milestones m',
'where security_group_id = :flow_security_group_id and ',
'      id = :P205_ID'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(1046850417023553952.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5315636303399744.4605)
,p_query_column_id=>1
,p_column_alias=>'MILESTONE_NAME'
,p_column_display_sequence=>1
,p_column_heading=>'Nome'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6449225521807349.4605)
,p_query_column_id=>2
,p_column_alias=>'MILESTONE_DATE'
,p_column_display_sequence=>2
,p_column_heading=>'Data'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10420318386079401.4605)
,p_query_column_id=>3
,p_column_alias=>'MILESTONE_STATUS'
,p_column_display_sequence=>3
,p_column_heading=>'Status'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'TEXT_FROM_LOV'
,p_named_lov=>wwv_flow_api.id(15773100381005765)
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10420426153079402.4605)
,p_query_column_id=>4
,p_column_alias=>'MILESTONE_DESC'
,p_column_display_sequence=>4
,p_column_heading=>unistr('Descri\00E7\00E3o')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5315808685399746.4605)
,p_query_column_id=>5
,p_column_alias=>'CREATED_BY'
,p_column_display_sequence=>5
,p_column_heading=>'Criado por'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10420535183079403.4605)
,p_query_column_id=>6
,p_column_alias=>'CREATED_ON'
,p_column_display_sequence=>6
,p_column_heading=>'Criado em'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5315940168399747.4605)
,p_query_column_id=>7
,p_column_alias=>'UPDATED_BY'
,p_column_display_sequence=>7
,p_column_heading=>'Atualizado por'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(10420629544079404.4605)
,p_query_column_id=>8
,p_column_alias=>'UPDATED_ON'
,p_column_display_sequence=>8
,p_column_heading=>'Atualizado em'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5399599693234705.4605)
,p_name=>'Problemas Associados'
,p_template=>wwv_flow_api.id(179998957300224011.4605)
,p_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  select i.id,',
'       wwv_flow_issue_int.get_avatar(p_user_name =>i.created_by, p_image_size => 16, p_include_name => ''Y'', p_include_link => ''Y'') owner,',
'       i.title      issue,',
'       i.status     Status',
'  from wwv_flow_issues i,',
'       wwv_flow_issue_milestones im',
' where im.issue_id = i.id',
'   and im.milestone_id = :P205_ID'))
,p_display_when_condition=>'P205_ID'
,p_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(128932681614424007.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>unistr('N\00E3o h\00E1 problemas associados a este Marco.')
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5399632808234706.4605)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5399778095234707.4605)
,p_query_column_id=>2
,p_column_alias=>'OWNER'
,p_column_display_sequence=>4
,p_column_heading=>unistr('Propriet\00E1rio')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5399836934234708.4605)
,p_query_column_id=>3
,p_column_alias=>'ISSUE'
,p_column_display_sequence=>2
,p_column_heading=>'Problema'
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP,100:P100_ISSUE_ID:#ID#'
,p_column_linktext=>'#ISSUE#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5399914604234709.4605)
,p_query_column_id=>4
,p_column_alias=>'STATUS'
,p_column_display_sequence=>3
,p_column_heading=>'Status'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'TEXT_FROM_LOV'
,p_named_lov=>wwv_flow_api.id(15773100381005765)
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5400044793234710.4605)
,p_name=>'Metrics'
,p_display_sequence=>10
,p_component_template_options=>'#DEFAULT#:a-BadgeList--stacked:a-BadgeList--large'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4600P205Metrics */',
'   trunc (milestone_date) - trunc(sysdate) days_out,',
'   (select count(*) ',
'      from wwv_flow_issue_milestones',
'     where security_group_id = :flow_security_group_id ',
'       and milestone_id = m.id) associated_issues',
'  from wwv_flow_milestones m',
' where security_group_id = :flow_security_group_id ',
'   and id = :P205_ID'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(1046845011939553934.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5400113068234711.4605)
,p_query_column_id=>1
,p_column_alias=>'DAYS_OUT'
,p_column_display_sequence=>1
,p_column_heading=>'Dias Restantes'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5400274615234712.4605)
,p_query_column_id=>2
,p_column_alias=>'ASSOCIATED_ISSUES'
,p_column_display_sequence=>2
,p_column_heading=>'Problemas Associados'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5400359807234713.4605)
,p_name=>'Breakdown'
,p_display_sequence=>20
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.OPEN'') status, count(*) ',
'          from wwv_flow_issues i, ',
'               wwv_flow_issue_milestones m',
'         where i.id = m.issue_id ',
'           and m.milestone_id = :P205_ID',
'           and i.security_group_id = :flow_security_group_id',
'           and m.security_group_id = :flow_security_group_id ',
'           and i.status = ''OPEN''',
'UNION ALL ',
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.CLOSED'') status, count(*) ',
'          from wwv_flow_issues i, ',
'               wwv_flow_issue_milestones m',
'         where i.id = m.issue_id ',
'           and m.milestone_id = :P205_ID',
'           and i.security_group_id = :flow_security_group_id',
'           and m.security_group_id = :flow_security_group_id ',
'           and i.status = ''CLOSED'''))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(52346073432218689.4605)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5400659454234716.4605)
,p_query_column_id=>1
,p_column_alias=>'STATUS'
,p_column_display_sequence=>1
,p_column_heading=>'Status'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(5612656439530334.4605)
,p_query_column_id=>2
,p_column_alias=>'COUNT(*)'
,p_column_display_sequence=>2
,p_column_heading=>'Contagem de Status'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5314759854399735.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5314412550399732.4605)
,p_button_name=>'EDIT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Editar Marco'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:210:&SESSION.::&DEBUG.:210:P210_ID:&P205_ID.'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5314530526399733.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(5314412550399732.4605)
,p_button_name=>'PREVIOUS_MILESONE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--pillStart'
,p_button_template_id=>wwv_flow_api.id(359238865408012460.4605)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_css_classes=>'apex_disabled'
,p_icon_css_classes=>'icon-left-chevron'
,p_button_cattributes=>'disabled=""'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5314660324399734.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(5314412550399732.4605)
,p_button_name=>'NEXT_MILESTONE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--pillEnd'
,p_button_template_id=>wwv_flow_api.id(359238865408012460.4605)
,p_button_image_alt=>unistr('Pr\00F3ximo')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_css_classes=>'apex_disabled'
,p_icon_css_classes=>'icon-right-chevron'
,p_button_cattributes=>'disabled=""'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(5399392796234703.4605)
,p_branch_name=>'Load Previous Milestone'
,p_branch_action=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.::P205_ID:&P205_PREVIOUS_MILESTONE_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(5314530526399733.4605)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(5399496323234704.4605)
,p_branch_name=>'Load Next Milestone'
,p_branch_action=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.::P205_ID:&P205_NEXT_MILESTONE_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5315074498399738.4605)
,p_name=>'P205_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5314412550399732.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5315162449399739.4605)
,p_name=>'P205_NEXT_MILESTONE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5314412550399732.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when=>'P205_NEXT_MILESTONE_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5315375449399741.4605)
,p_name=>'P205_PREVIOUS_MILESTONE_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(5314412550399732.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when=>'P205_PREVIOUS_MILESTONE_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5315431704399742.4605)
,p_name=>'P205_MILESTONE_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(5314412550399732.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(5400897196234718.4605)
,p_computation_sequence=>10
,p_computation_item=>'F4600_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'&APP_PAGE_ID.'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5316188393399749.4605)
,p_name=>'ENABLE PREVIOUS'
,p_event_sequence=>10
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_display_when_cond=>'P205_PREVIOUS_MILESTONE_ID'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5316295926399750.4605)
,p_event_id=>wwv_flow_api.id(5316188393399749.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_api.id(5314530526399733.4605)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5399144284234701.4605)
,p_name=>'ENABLE NEXT'
,p_event_sequence=>20
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_display_when_cond=>'P205_NEXT_MILESTONE_ID'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5399259798234702.4605)
,p_event_id=>wwv_flow_api.id(5399144284234701.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_api.id(5314660324399734.4605)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5315241181399740.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Compute Next and Previous'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_current_ms_date date;',
'    l_current_ms_id   number;',
'begin',
'',
':P205_NEXT_MILESTONE_ID     := null;',
':P205_PREVIOUS_MILESTONE_ID := null;',
'',
'--',
'for c1 in (select milestone_name, milestone_date, milestone_id',
'             from wwv_flow_milestones',
'            where id = :P205_ID',
'              and security_group_id = :flow_security_group_id) LOOP',
'    :P205_MILESTONE_NAME := c1.milestone_name;',
'    l_current_ms_date := c1.milestone_date;',
'    l_current_ms_id   := c1.milestone_id;',
'    exit;',
'end loop;',
'',
'--',
'for c1 in ( select id, milestone_id, milestone_date ',
'              from wwv_flow_milestones ',
'             where MILESTONE_DATE >=(select MILESTONE_DATE ',
'                                     from wwv_flow_milestones ',
'                                    where id = :P205_ID ',
'                                      and security_group_id = :flow_security_group_id) ',
'',
'               and security_group_id = :flow_security_group_id',
'               and id != :P205_ID',
'             order by milestone_date asc, milestone_id asc ) loop',
'     if c1.milestone_date > l_current_ms_date then ',
'        :P205_NEXT_MILESTONE_ID := c1.id;',
'        exit;',
'     elsif c1.milestone_date = l_current_ms_date and c1.milestone_id > l_current_ms_id then ',
'        :P205_NEXT_MILESTONE_ID := c1.id;',
'        exit;',
'     end if;',
'end loop;',
'',
'--',
'for c1 in ( select id, milestone_id, milestone_date ',
'              from wwv_flow_milestones ',
'             where MILESTONE_DATE <=(select MILESTONE_DATE ',
'                                     from wwv_flow_milestones ',
'                                    where id = :P205_ID ',
'                                      and security_group_id = :flow_security_group_id) ',
'',
'               and security_group_id = :flow_security_group_id',
'               and id != :P205_ID',
'             order by milestone_date desc, milestone_id desc ) loop',
'     if c1.milestone_date < l_current_ms_date then ',
'        :P205_PREVIOUS_MILESTONE_ID := c1.id;',
'        exit;',
'     elsif c1.milestone_date = l_current_ms_date and c1.milestone_id < l_current_ms_id then ',
'        :P205_PREVIOUS_MILESTONE_ID := c1.id;',
'        exit;',
'     end if;',
'end loop;',
'',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00210
begin
wwv_flow_api.create_page(
 p_id=>210.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Gerenciar Marco'
,p_step_title=>'Marco'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883665819126633)
,p_javascript_code=>'var htmldb_delete_message = ''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(694810454825113224.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_protection_level=>'C'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5314046459399728.4605)
,p_plug_name=>'Novo'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5353968463645868.4605)
,p_plug_name=>'Marco'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'TABLE'
,p_query_table=>'WWV_FLOW_MILESTONES'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10828778852511881.4605)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>unistr('<p>Eventos de rastreamento de marcos. \00C9 poss\00EDvel designar problemas a um ou mais marcos.</p>')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5359677139645897.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5314046459399728.4605)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P210_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5360044073645897.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(5314046459399728.4605)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Criar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P210_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5358405324645890.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(5314046459399728.4605)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4600_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5359280496645896.4605)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(5314046459399728.4605)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Excluir'
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P210_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(5360378019645897.4605)
,p_branch_name=>'Go To Page &F4600_LAST_ViEW.'
,p_branch_action=>'f?p=&APP_ID.:&F4600_LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5354201894645869.4605)
,p_name=>'P210_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_source=>'ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5355004527645887.4605)
,p_name=>'P210_MILESTONE_NAME'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_prompt=>'Nome do Marco'
,p_source=>'MILESTONE_NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(457861279924367968.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>'Identifica o nome do marco.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5355470848645888.4605)
,p_name=>'P210_MILESTONE_DATE'
,p_source_data_type=>'DATE'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_prompt=>'Data'
,p_source=>'MILESTONE_DATE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_DATE_PICKER'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(457861279924367968.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>'Identifica a data do marco.'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5356231206645888.4605)
,p_name=>'P210_MILESTONE_SLUG'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_prompt=>'Slug'
,p_source=>'MILESTONE_SLUG'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(457861279924367968.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>unistr('Um identificador de string exclusivo para o marco que ser\00E1 usado em URLs.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6449146520807348.4605)
,p_name=>'P210_MILESTONE_DESC'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_prompt=>unistr('Descri\00E7\00E3o')
,p_source=>'MILESTONE_DESC'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6449312976807350.4605)
,p_name=>'P210_MILESTONE_STATUS'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5353968463645868.4605)
,p_item_default=>'OPEN'
,p_prompt=>'Status do Marco'
,p_source=>'MILESTONE_STATUS'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LOCALIZED OPEN CLOSED'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.OPEN'') d, ''OPEN'' r ',
'from dual',
'UNION',
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.CLOSED'') d, ''CLOSED'' r ',
'from dual'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(5401961051234729.4605)
,p_validation_name=>'Validate Slug'
,p_validation_sequence=>10
,p_validation=>'return wwv_flow_issue_int.validate_slug(:P210_MILESTONE_SLUG);'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Slug inv\00E1lido. Um slug s\00F3 pode conter caracteres min\00FAsculos, n\00FAmeros e tra\00E7os.')
,p_associated_item=>wwv_flow_api.id(5356231206645888.4605)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(5402084147234730.4605)
,p_validation_name=>'Slug is unique in workspace'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1''',
'  from wwv_flow_milestones ',
' where milestone_slug = :P210_MILESTONE_SLUG',
'   and ID != :P210_ID',
'   and security_group_id = :flow_security_group_id'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('O slug deve ser exclusivo. Digite outro valor contendo apenas caracteres min\00FAsculos, n\00FAmeros e tra\00E7os.')
,p_associated_item=>wwv_flow_api.id(5356231206645888.4605)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5401195385234721.4605)
,p_name=>'Generate Slug'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P210_MILESTONE_NAME'
,p_condition_element=>'P210_MILESTONE_NAME'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'keyup'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5401295713234722.4605)
,p_event_id=>wwv_flow_api.id(5401195385234721.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>':P210_MILESTONE_SLUG := wwv_flow_issue_int.gen_slug(:P210_MILESTONE_NAME);'
,p_attribute_02=>'P210_MILESTONE_NAME'
,p_attribute_03=>'P210_MILESTONE_SLUG'
,p_attribute_04=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5361282438645903.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_api.id(5353968463645868.4605)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Create Form'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5360898494645903.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_api.id(5353968463645868.4605)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Create Form'
);
end;
/
prompt --application/pages/page_00300
begin
wwv_flow_api.create_page(
 p_id=>300.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Labels'
,p_alias=>'LABELS'
,p_step_title=>'Labels'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883741872127080)
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.color-option {',
'  display: block;',
'  width: 32px;',
'  height: 32px;',
'  padding: 3px;',
'  line-height: 24px;',
'  border-radius: 32px;',
'  text-align: center;',
'  border-style: solid;',
'  border-width: 1px;',
'  font-weight: 500;',
'}'))
,p_step_template=>wwv_flow_api.id(391881764116992437.4605)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1219801112620110.4605)
,p_plug_name=>unistr('Instalar Labels Padr\00E3o')
,p_region_template_options=>'#DEFAULT#:js-dialog-size480x320'
,p_plug_template=>wwv_flow_api.id(10813455696794486.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Selecione qual idioma deve ser usado para instalar as amostras de Labels.</p></br>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1220131719620113.4605)
,p_plug_name=>unistr('Instalar Labels Padr\00E3o')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NOT_EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select * ',
'from wwv_flow_label_groups',
'where security_group_id = :flow_security_group_id'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5612979410530337.4605)
,p_plug_name=>'Label Groups Report'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(651492083233530570.4605)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id,',
'       group_name,',
'       group_color,',
'       group_description,',
'       case values_are_exclusive',
'        when ''Y'' then ''<span class="fa fa-star-o" title="Values are Exclusive"></span>''',
'        else null',
'       end values_are_exclusive ,',
'       --',
'       (select count(*) from wwv_flow_labels lg where lg.label_group_id = l.id and lg.security_group_id = :flow_security_group_id) entries,',
'       --',
'       nvl(l.updated_on, l.created_on) group_last_updated,',
'       --',
'       nvl(nvl((select max(nvl(updated_on, created_on))',
'                 from  wwv_flow_labels ',
'                where label_group_id = l.id',
'                  and updated_on is not null), l.updated_on), l.created_on ) entries_last_updated,',
'       wwv_flow_issue_int.get_user_name(created_by) created_by,',
'       created_on,',
'       ---',
'       apex_page.get_url(p_page => 305, p_items => ''P305_LABEL_GROUP_ID'', p_values => id, p_clear_cache => 305) group_link',
'  from wwv_flow_label_groups l',
'where security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(5613062644530338.4605)
,p_max_row_count=>'1000000'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_detail_view_enabled_yn=>'Y'
,p_detail_view_before_rows=>'<div class="a-ContentRowReport">'
,p_detail_view_for_each_row=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item">',
'  <a href="#GROUP_LINK#" class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemIconWrap">',
'      <span class="a-ContentRowReport-itemIcon color-option #GROUP_COLOR#" aria-hidden="true">Aa</span>',
'    </div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle">#GROUP_NAME#</h3>',
'        <div class="a-ContentRowReport-itemDescription">#GROUP_DESCRIPTION#</div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">#VALUES_ARE_EXCLUSIVE#</div>',
'      <div class="a-ContentRowReport-itemActions"><span aria-hidden="true" class="fa fa-tags"></span> #ENTRIES#</div>',
'    </div>',
'  </a>',
'</div>',
''))
,p_detail_view_after_rows=>'</div>'
,p_owner=>'DGAULT'
,p_internal_uid=>5613062644530338
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5613193670530339.4605)
,p_db_column_name=>'ID'
,p_display_order=>10
,p_column_identifier=>'A'
,p_column_label=>'Id'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5613297696530340.4605)
,p_db_column_name=>'GROUP_NAME'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>'Nome do Grupo'
,p_column_link=>'f?p=&APP_ID.:305:&SESSION.::&DEBUG.:RP,305:P305_LABEL_GROUP_ID:#ID#'
,p_column_linktext=>'#GROUP_NAME#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5613394497530341.4605)
,p_db_column_name=>'GROUP_COLOR'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>'Cor do Grupo'
,p_column_html_expression=>'<span class="color-option #GROUP_COLOR#">Aa</span>'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5613438620530342.4605)
,p_db_column_name=>'GROUP_DESCRIPTION'
,p_display_order=>40
,p_column_identifier=>'D'
,p_column_label=>unistr('Descri\00E7\00E3o do Grupo')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5613533165530343.4605)
,p_db_column_name=>'VALUES_ARE_EXCLUSIVE'
,p_display_order=>50
,p_column_identifier=>'E'
,p_column_label=>unistr('Valores S\00E3o Exclusivos')
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5613644069530344.4605)
,p_db_column_name=>'ENTRIES'
,p_display_order=>60
,p_column_identifier=>'F'
,p_column_label=>'Entradas'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5613740888530345.4605)
,p_db_column_name=>'GROUP_LAST_UPDATED'
,p_display_order=>70
,p_column_identifier=>'G'
,p_column_label=>unistr('\00DAltima Atualiza\00E7\00E3o do Grupo')
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5613837599530346.4605)
,p_db_column_name=>'ENTRIES_LAST_UPDATED'
,p_display_order=>80
,p_column_identifier=>'H'
,p_column_label=>unistr('\00DAltima Atualiza\00E7\00E3o das Entradas')
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5613935889530347.4605)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>90
,p_column_identifier=>'I'
,p_column_label=>'Criado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(5614029872530348.4605)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>100
,p_column_identifier=>'J'
,p_column_label=>'Criado em'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(6875688403843436.4605)
,p_db_column_name=>'GROUP_LINK'
,p_display_order=>110
,p_column_identifier=>'K'
,p_column_label=>'Link do Grupo'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6950681909294493.4605)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>unistr('<p>Os Grupos de Labels e Labels s\00E3o usados para classificar problemas. Cada grupo recebe uma cor identificadora para que os labels dentro do mesmo grupo possam ser identificados facilmente. \00C9 poss\00EDvel definir os grupos como Exclusivos ou N\00E3o Exclusiv')
||unistr('os, determinando se v\00E1rios valores de um \00FAnico grupo podem ser designados a um problema. </p>')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(56003781858197975.4605)
,p_plug_name=>unistr('Utilit\00E1rios')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_list_id=>wwv_flow_api.id(10555300999175496.4605)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(702419290542782266.4605)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1220205376620114.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1220131719620113.4605)
,p_button_name=>'INSTALL_DEFAULT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Instalar Labels Padr\00E3o')
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1220069539620112.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1219801112620110.4605)
,p_button_name=>'INSTALL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Instalar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1219988323620111.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1219801112620110.4605)
,p_button_name=>'CANCEL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5708453352527201.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(5612979410530337.4605)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:300,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5708574915527202.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(5612979410530337.4605)
,p_button_name=>'CREATE_NEW_GROUP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(656569185201725731.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Criar'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:301:&SESSION.::&DEBUG.:301,305::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1251680459956460.4605)
,p_name=>'P300_LANGUAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1219801112620110.4605)
,p_item_default=>'APEX_UTIL.GET_SESSION_LANG'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Idioma do Label'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  l.translated_lang_name d, f.flow_language r',
'                  from ( select flow_language',
'                           from wwv_flows f',
'                          where id = :APP_ID',
'                          union',
'                         select flow_language',
'                           from wwv_flows f',
'                          where id in ( select translation_flow_id',
'                                          from wwv_flow_language_map',
'                                         where primary_language_flow_id = :APP_ID )',
'                       ) f,',
'                       wwv_flow_languages l',
'                 where f.flow_language = l.lang_id'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(457861279924367968.4605)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1220391298620115.4605)
,p_name=>'Show Install Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(1220205376620114.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1220482077620116.4605)
,p_event_id=>wwv_flow_api.id(1220391298620115.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_OPEN_REGION'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(1219801112620110.4605)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1219682985620108.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Default Labels'
,p_process_sql_clob=>'wwv_flow_issue_seed_int.install_default_labels(p_lang => :P300_LANGUAGE);'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1220069539620112.4605)
);
end;
/
prompt --application/pages/page_00301
begin
wwv_flow_api.create_page(
 p_id=>301.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Criar/Editar Grupo de Labels'
,p_page_mode=>'MODAL'
,p_step_title=>'Criar/Editar Grupo de Labels'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883741872127080)
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/* Color Options Radio Item',
'   ========================================================================== */',
'/* Display radios as inline blocks */',
'.color-options-radio .apex-item-option {',
'  display: inline-block;',
'  vertical-align: top;',
'}',
'',
'/* This is necessary to show the help icon to the right of the color radios */',
'.color-options-radio .a-Form-inputContainer {',
'  display: flex;',
'  align-items: start;',
'}',
'',
'/* Remove the focus outline as the first radio will automatically gain focus */',
'.color-options-radio .apex-item-radio:focus {',
'  outline: none;',
'}',
'',
'/* Visually hide radio buttons */',
'.color-options-radio input[type=''radio''] {',
'  position: absolute;',
'  overflow: hidden;',
'  clip: rect(0 0 0 0);',
'  margin: -1px;',
'  padding: 0;',
'  width: 1px;',
'  height: 1px;',
'  border: 0;',
'}',
'',
'/* Display labels as block and set appropriate spacing, dimensions',
'   This label is used to indicate focus state */',
'.color-options-radio input + label {',
'  display: block;',
'  padding: 0 !important;',
'  margin: 4px;',
'  border-radius: 24px;',
'}',
'',
'.color-options-radio label:before,',
'.color-options-radio label:after {',
'  content: none !important;',
'}',
'',
'/* The default state for these color radios will display the text ',
'   ''Aa'' inside the circle */',
'.color-options-radio input + label span:before {',
'  content: ''Aa'';',
'  font-weight: 500;',
'}',
'',
'/* Add outline the label when checked */',
'.color-options-radio input:checked + label {',
'  box-shadow: 0 0 0 2px white, 0 0 0 4px #0572ce;',
'}',
'',
'/* Add an outline + glow to label when focused */',
'.color-options-radio input:focus + label {',
'  box-shadow: 0 0 0 2px white, 0 0 0 4px #0572ce, 0 0 4px 4px #0572ce;',
'}',
'',
'/* When an item is checked, display check icon instead of text */',
'.color-options-radio input:checked + label span:before {',
'  font-family: "apex-5-icon-font" !important;',
'  font-style: normal !important;',
'  font-weight: normal !important;',
'  font-variant: normal !important;',
'  text-transform: none !important;',
'  speak: none;',
'  font-size: 20px;',
'  line-height: 24px;',
'  -webkit-font-smoothing: antialiased;',
'  content: "\e007";',
'  display: block;',
'  text-shadow: 0 0 1px, 0 0 1px, 0 0 1px;',
'}',
'',
'/* Color Radio Options (set in the globalization template)',
'   ========================================================================== */',
'.color-option {',
'  display: block;',
'  width: 32px;',
'  height: 32px;',
'  padding: 3px;',
'  line-height: 24px;',
'  border-radius: 32px;',
'  text-align: center;',
'  border-style: solid;',
'  border-width: 1px;',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_protection_level=>'C'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5760797683920682.4605)
,p_plug_name=>'Editar Grupos de Labels'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(47229974494774989.4605)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'TABLE'
,p_query_table=>'WWV_FLOW_LABEL_GROUPS'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5764550641920696.4605)
,p_plug_name=>unistr('Bot\00F5es do Assistente')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5764939662920696.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5764550641920696.4605)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5766514193920717.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(5764550641920696.4605)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Excluir'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_count number;',
'BEGIN ',
'',
'select count(*)',
'  into l_count',
'  from wwv_flow_issue_labels ',
' where label_id in (select l.id',
'                      from wwv_flow_labels l',
'                     where label_group_id = :P301_id',
'                       and security_group_id = :flow_security_group_id)',
'   and security_group_id = :flow_security_group_id;',
'--',
'if :P301_ID is not null and l_count = 0 then ',
'    return TRUE;',
'else ',
'    return FALSE;',
'end if;',
'',
'END;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5766983411920718.4605)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(5764550641920696.4605)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P301_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5767378673920718.4605)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(5764550641920696.4605)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Criar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P301_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(5709059297527207.4605)
,p_branch_name=>'Go to 305'
,p_branch_action=>'f?p=&APP_ID.:305:&SESSION.::&DEBUG.:RP:P305_LABEL_GROUP_ID:&P301_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_IN_CONDITION'
,p_branch_condition=>'SAVE,CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(5709152444527208.4605)
,p_branch_name=>'Go To Page 301'
,p_branch_action=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(5766514193920717.4605)
,p_branch_sequence=>20
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5710186210527218.4605)
,p_name=>'P301_DELETE_WARNING'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_item_default=>'wwv_flow_lang.system_message(''APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'')'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'NOTE:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' ',
'  from wwv_flow_issue_labels ',
' where label_id in (select l.id',
'                      from wwv_flow_labels l',
'                     where label_group_id = :P301_id',
'                       and security_group_id = :flow_security_group_id)',
'   and security_group_id = :flow_security_group_id',
'    '))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5761077930920684.4605)
,p_name=>'P301_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_source=>'ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5761493789920691.4605)
,p_name=>'P301_GROUP_NAME'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_prompt=>'Nome do Grupo'
,p_source=>'GROUP_NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(457861279924367968.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>'Nome exclusivo para o grupo de labels.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5761813224920693.4605)
,p_name=>'P301_GROUP_COLOR'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_prompt=>'Cor do Label do Grupo'
,p_source=>'GROUP_COLOR'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'LABEL_GROUP_COLORS'
,p_lov=>'.'||wwv_flow_api.id(5734638238767974.4605)||'.'
,p_field_template=>wwv_flow_api.id(457861279924367968.4605)
,p_item_css_classes=>'color-options-radio'
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('A cor que ser\00E1 usada para exibir todos os labels do grupo. ')
,p_attribute_01=>'8'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5762285296920694.4605)
,p_name=>'P301_GROUP_DESCRIPTION'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_prompt=>unistr('Descri\00E7\00E3o do Grupo')
,p_source=>'GROUP_DESCRIPTION'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5762658425920694.4605)
,p_name=>'P301_VALUES_ARE_EXCLUSIVE'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_item_source_plug_id=>wwv_flow_api.id(5760797683920682.4605)
,p_prompt=>unistr('Valores S\00E3o Exclusivos')
,p_source=>'VALUES_ARE_EXCLUSIVE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(457861279924367968.4605)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>unistr('Indica se os valores do grupo s\00E3o designados exclusivamente a um problema. Se <b>Ativado</b>, apenas um label do grupo poder\00E1 ser designado a um problema por vez. Se <b>Desativado</b>, diversos labels do mesmo grupo poder\00E3o ser designados a um proble')
||'ma.'
,p_attribute_01=>'CUSTOM'
,p_attribute_02=>'Y'
,p_attribute_03=>'Yes'
,p_attribute_04=>'N'
,p_attribute_05=>'No'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(5765094853920696.4605)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(5764939662920696.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(5765898088920705.4605)
,p_event_id=>wwv_flow_api.id(5765094853920696.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5768140350920719.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_api.id(5760797683920682.4605)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Create Form'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5767767486920719.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_api.id(5760797683920682.4605)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Create Form'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00305
begin
wwv_flow_api.create_page(
 p_id=>305.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>'Gerenciar Labels'
,p_step_title=>'Gerenciar Labels'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(4883741872127080)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5708682809527203.4605)
,p_plug_name=>'Barra Superior'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5710040153527217.4605)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Os labels s\00E3o classificados em Grupos de Labels e usados para classificar problemas. Aqui voc\00EA pode gerenciar os Labels do Grupo selecionado. </p>'),
'<br/>',
unistr('<p><B>OBSERVA\00C7\00C3O:</b> Voc\00EA n\00E3o pode excluir os labels atualmente designados a um problema. </p>')))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5714789063586345.4605)
,p_plug_name=>'Gerenciar Labels'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(651492083233530570.4605)
,p_plug_display_sequence=>11
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with labels as (select ID,',
'       LABEL_GROUP_ID,',
'       LABEL_NAME,',
'       LABEL_DESC,',
'       LABEL_SLUG,',
'       DISPLAY_SEQUENCE, ',
'       (select count(*) from wwv_flow_issue_labels where label_id = l.id and security_group_id = :flow_security_group_id) references',
'  from WWV_FLOW_LABELS l',
' where label_group_id = :P305_LABEL_GROUP_ID',
'   and security_group_id = :flow_security_group_id)',
' select ID, ',
'        LABEL_GROUP_ID,',
'        LABEL_NAME,',
'        LABEL_DESC,',
'        LABEL_SLUG,',
'        DISPLAY_SEQUENCE,',
'        REFERENCES, ',
'        case ',
'            when REFERENCES > 0 then ''U''',
'            ELSE ''UD''',
'        end ALLOWED_OPS',
'  from labels    '))
,p_plug_source_type=>'NATIVE_IG'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_plug_display_when_condition=>'P305_LABEL_GROUP_ID'
,p_plug_display_when_cond2=>'0'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5709623269527213.4605)
,p_name=>'ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>30
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5709705992527214.4605)
,p_name=>'REFERENCES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'REFERENCES'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('Refer\00EAncias')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>100
,p_value_alignment=>'RIGHT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>false
,p_is_primary_key=>false
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5709944021527216.4605)
,p_name=>'ALLOWED_OPS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ALLOWED_OPS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>50
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5715983075586359.4605)
,p_name=>'APEX$ROW_SELECTOR'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_enable_hide=>true
,p_is_primary_key=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5716497343586364.4605)
,p_name=>'APEX$ROW_ACTION'
,p_item_type=>'NATIVE_ROW_ACTION'
,p_label=>unistr('A\00E7\00F5es')
,p_heading_alignment=>'CENTER'
,p_display_sequence=>20
,p_value_alignment=>'CENTER'
,p_enable_hide=>true
,p_is_primary_key=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5717653661586367.4605)
,p_name=>'LABEL_GROUP_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_GROUP_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>40
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_default_type=>'ITEM'
,p_default_expression=>'P305_LABEL_GROUP_ID'
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5718867906586368.4605)
,p_name=>'LABEL_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Nome do Label'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>255
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5719470789586368.4605)
,p_name=>'LABEL_DESC'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_DESC'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>unistr('Descri\00E7\00E3o do Label')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>80
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5722449928586370.4605)
,p_name=>'LABEL_SLUG'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_SLUG'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Slug do Label'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>255
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(5723017344586370.4605)
,p_name=>'DISPLAY_SEQUENCE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DISPLAY_SEQUENCE'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>unistr('Sequ\00EAncia')
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>90
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(5715253254586347.4605)
,p_internal_uid=>5715253254586347
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_edit_row_operations_column=>'ALLOWED_OPS'
,p_lost_update_check_type=>'VALUES'
,p_add_row_if_empty=>false
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_show_nulls_as=>'-'
,p_select_first_row=>false
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>true
,p_no_data_found_message=>unistr('N\00E3o existem labels nesse grupo no momento. Voc\00EA pode adicion\00E1-los aqui.')
,p_show_toolbar=>true
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>true
,p_enable_mail_download=>true
,p_fixed_header=>'PAGE'
,p_show_icon_view=>false
,p_show_detail_view=>false
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5708911293527206.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5708682809527203.4605)
,p_button_name=>'EDIT_GROUP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Editar Grupo'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:301:&SESSION.::&DEBUG.:RP,301:P301_ID:&P305_LABEL_GROUP_ID.'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5708861547527205.4605)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(5708682809527203.4605)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(188432383783551716.4605)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP,305::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5708734444527204.4605)
,p_name=>'P305_LABEL_GROUP_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5708682809527203.4605)
,p_prompt=>'Grupo de Labels '
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Select wwv_flow_escape.html(group_name) name, id',
'from wwv_flow_label_groups',
'where security_group_id = :flow_security_group_id',
'order by upper(name)'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Selecionar Grupo de Labels -'
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(566752393121369432.4605)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione o Grupo de Labels que voc\00EA gostaria de editar. Os Labels do Grupo ser\00E3o exibidos automaticamente. Crie ou selecione um Grupo de Labels antes de adicionar Labels.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(5709491226527211.4605)
,p_tabular_form_region_id=>wwv_flow_api.id(5714789063586345.4605)
,p_validation_name=>'Validate Slug'
,p_validation_sequence=>10
,p_validation=>'return wwv_flow_issue_int.validate_slug(:LABEL_SLUG);'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Slug inv\00E1lido. Um slug s\00F3 pode conter caracteres min\00FAsculos, n\00FAmeros e tra\00E7os.')
,p_always_execute=>'Y'
,p_associated_item=>wwv_flow_api.id(.4605)
,p_associated_column=>'LABEL_SLUG'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(5709553111527212.4605)
,p_tabular_form_region_id=>wwv_flow_api.id(5714789063586345.4605)
,p_validation_name=>'Label Slug is Unique in Workspace'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1''',
'  from wwv_flow_labels',
' where label_slug = :LABEL_SLUG',
'   and id != :ID',
'   and security_group_id = :flow_security_group_id'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('O slug deve ser exclusivo. Digite outro valor contendo apenas caracteres min\00FAsculos, n\00FAmeros e tra\00E7os.')
,p_associated_item=>wwv_flow_api.id(.4605)
,p_associated_column=>'LABEL_SLUG'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(889477190767514001.4605)
,p_name=>'Gen Slug'
,p_event_sequence=>10
,p_triggering_element_type=>'COLUMN'
,p_triggering_region_id=>wwv_flow_api.id(5714789063586345.4605)
,p_triggering_element=>'LABEL_NAME'
,p_condition_element_type=>'COLUMN'
,p_condition_element=>'LABEL_NAME'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(889477275411514002.4605)
,p_event_id=>wwv_flow_api.id(889477190767514001.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>':LABEL_SLUG := wwv_flow_issue_int.gen_slug(:LABEL_NAME);'
,p_attribute_02=>'LABEL_SLUG,LABEL_NAME'
,p_attribute_03=>'LABEL_SLUG'
,p_attribute_04=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5723669112586376.4605)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_api.id(5714789063586345.4605)
,p_process_type=>'NATIVE_IG_DML'
,p_process_name=>'Manage Labels - Save Interactive Grid Data'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00500
begin
wwv_flow_api.create_page(
 p_id=>500.4605
,p_user_interface_id=>wwv_flow_api.id(9728334451760999.4605)
,p_name=>unistr('Perfil do Usu\00E1rio')
,p_step_title=>'&P500_DISPLAY_NAME. - Problemas'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(17268112003727577)
,p_protection_level=>'C'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(11047540937484649.4605)
,p_name=>'Resumo'
,p_region_name=>'dashboard'
,p_template=>wwv_flow_api.id(179998957300224011.4605)
,p_display_sequence=>20
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-BadgeList--stacked:a-BadgeList--large'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues i',
'     where created_by = :P500_USER_NAME',
'       and i.status = ''OPEN''',
'       and i.deleted= ''N''',
'       and security_group_id = :flow_security_group_id)  owned_issues    ,',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues i, ',
'           wwv_flow_issue_stakeholders s',
'     where s.issue_id = i.id',
'       and s.stakeholder = :P500_USER_NAME',
'       and s.stakeholder_type = ''ASSIGNEE''',
'       and i.status = ''OPEN''',
'       and i.deleted = ''N''',
'       and s.security_group_id = :flow_security_group_id',
'       and i.security_group_id = :flow_security_group_id)  assigned_issues,       ',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues i, ',
'           wwv_flow_issue_stakeholders s',
'     where s.issue_id = i.id',
'       and s.stakeholder = :P500_USER_NAME',
'       and s.stakeholder_type = ''SUBSCRIBER''',
'       and i.status = ''OPEN''',
'       and i.deleted = ''N''',
'       and s.security_group_id = :flow_security_group_id',
'       and i.security_group_id = :flow_security_group_id)  subscribed_issues, ',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id',
'       and created_by = :P500_USER_NAME) owned_milestones',
' from dual'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(1046845011939553934.4605)
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_row_count_max=>7
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
,p_comment=>'style="width:33%; float:left;"'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6185654103627137.4605)
,p_query_column_id=>1
,p_column_alias=>'OWNED_ISSUES'
,p_column_display_sequence=>1
,p_column_heading=>'Problemas de Propriedade'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'CENTER'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6185860860627139.4605)
,p_query_column_id=>2
,p_column_alias=>'ASSIGNED_ISSUES'
,p_column_display_sequence=>3
,p_column_heading=>'Problemas Designados'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'CENTER'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6185963790627140.4605)
,p_query_column_id=>3
,p_column_alias=>'SUBSCRIBED_ISSUES'
,p_column_display_sequence=>4
,p_column_heading=>'Problemas Assinados'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'CENTER'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6185790300627138.4605)
,p_query_column_id=>4
,p_column_alias=>'OWNED_MILESTONES'
,p_column_display_sequence=>5
,p_column_heading=>'Marcos de Propriedade'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'CENTER'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11125556808028800.4605)
,p_plug_name=>unistr('Barra de T\00EDtulo')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_plug_template=>wwv_flow_api.id(694479338908463138.4605)
,p_plug_display_sequence=>11
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_html      varchar2(32767);',
'begin ',
'    l_html :=    ''',
'<div class="a-IssueHeader">',
'  <div class="a-IssueHeader-itemStatusIconWrap">'' || wwv_flow_issue_int.get_avatar(p_user_name => :P500_USER_NAME, p_modifier_class => ''a-User--large'', p_include_name => ''N'') || ''</div>',
'  <div class="a-IssueHeader-body">',
'    <h1 class="a-IssueHeader-title">''||apex_escape.html(:P500_DISPLAY_NAME)||''</h1>',
'    <div class="a-IssueHeader-info">''||apex_escape.html(:P500_EMAIL_ADDRESS)||''</div>',
'  </div>',
'</div>',
''';',
'    sys.htp.p(l_html);',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11497747092045337.4605)
,p_plug_name=>unistr('Guias Usu\00E1rio')
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(214132567690623104.4605)
,p_plug_display_sequence=>21
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(11496705512045322.4605)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11515926722097128.4605)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'  from dual ',
'where :APP_USER = :P500_USER_NAME'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(16097755849950438.4605)
,p_plug_name=>'Meus Problemas'
,p_region_name=>'issues'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(651492083233530570.4605)
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with agg_stakeholders as (',
'    select issue_id,',
'           listagg(case when seqnum <=5 then wwv_flow_issue_int.get_user_name(stakeholder) end, '', '') ',
'            within group(order by wwv_flow_issue_int.get_user_name(stakeholder) ) assignees, ',
'           listagg(case when seqnum <=5 then wwv_flow_issue_int.get_avatar(stakeholder, p_image_size => 24, p_include_link => ''Y'') end, '' '') ',
'            within group(order by stakeholder ) assignees_html, ',
'           count(*) assignee_count',
'      from (select ss.*, ',
'                   row_number() over (partition by ISSUE_ID order by stakeholder ) as seqnum ',
'              from wwv_flow_issue_stakeholders ss',
'             where ss.stakeholder_type = ''ASSIGNEE''',
'               and ss.security_group_id = :flow_security_group_id)',
'     group by issue_id',
'), agg_subscribers as (',
'    select issue_id,',
'           listagg(wwv_flow_issue_int.get_user_name(stakeholder), '':'') ',
'            within group(order by wwv_flow_issue_int.get_user_name(stakeholder) ) subcribers,',
'           listagg(wwv_flow_issue_int.get_avatar(stakeholder, p_image_size => 24, p_include_link => ''Y''), '' '') ',
'            within group( order by stakeholder ) subscribers_html, ',
'           count(*) subscriber_count',
'      from wwv_flow_issue_stakeholders',
'     where stakeholder_type = ''SUBSCRIBER''',
'       and security_group_id = :flow_security_group_id',
'     group by issue_id',
'), ',
'agg_labels as (',
'    select issue_id,',
'           listagg(label_name, '', '') within group(',
'                order by label_name',
'           ) labels, ',
'           listagg(''<span class="a-IssueLabel ''||g.group_color||''" > ''||label_name||''</span>'', '''') within group(',
'                order by g.group_name, l.label_name',
'           ) labels_html',
'      from wwv_flow_issue_labels il,',
'           wwv_flow_labels l, ',
'           wwv_flow_label_groups g',
'     where il.label_id = l.id',
'       and l.label_group_id = g.id',
'       and il.security_group_id = :flow_security_group_id',
'       and l.security_group_id = :flow_security_group_id',
'       and g.security_group_id = :flow_security_group_id',
'     group by issue_id',
'), ',
'agg_milestones as (',
'  select issue_id,',
'           listagg(milestone_name, '':'') within group(',
'                order by milestone_name',
'           ) milestones,',
'           listagg(''<a class="a-IssueMilestone" href="''||apex_util.prepare_url(''f?p=''||:APP_ID||'':205:''||:APP_SESSION||''::::P205_ID:''||m.id,  p_checksum_type =>3 )||''"><span class="fa fa-map-signs" aria-hidden="true"></span>''||milestone_name||''</a> '''
||', '' '') within group(',
'                order by milestone_name',
'           ) milestones_html',
'      from wwv_flow_issue_milestones im,',
'           wwv_flow_milestones m',
'     where im.milestone_id = m.id',
'       and im.security_group_id = :flow_security_group_id',
'       and m.security_group_id = :flow_security_group_id',
'     group by issue_id',
')',
'select i.id,',
'       i.issue_number,',
'       i.title,',
'       i.slug,',
'       i.status,',
'       case ',
'           when i.status = ''OPEN'' then ''<span aria-hidden="true" class="a-IssueList-itemStatusIcon a-IssueList-itemStatusIcon--open fa fa-exclamation-circle-o" title="''||i.status||''"></span>''',
'           WHEN i.status = ''CLOSED'' then ''<span aria-hidden="true" class="a-IssueList-itemStatusIcon a-IssueList-itemStatusIcon--closed fa fa-exclamation-circle-o fam-check fam-is-danger" title="''||i.status||''"></span>''',
'       end issue_status,',
'       i.issue_text,',
'       case ',
'            when i.duplicate_of is not null then ',
'                wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.MARKED_DUPLICATE_OF'', p0=> i2.title, p1=> apex_util.get_since(i.duplicate_identified_on),  p2=>i.duplicate_identified_by )',
'            else ''''',
'        end  marked_duplicate,',
'       i.application_id,',
'       i.page_id,',
'        wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.OPENED'', p0=>apex_util.get_since(i.created_on)) created,',
'       apex_util.prepare_url(''f?p=''||:APP_ID||'':500:''||:APP_SESSION||''::::P500_USER_NAME:''||i.created_by, p_checksum_type =>3) created_by_link,',
'       i.created_on ,',
'       wwv_flow_issue_int.get_user_name(i.created_by) created_by,',
'       (',
'           select count(*)',
'             from wwv_flow_issue_comments c',
'            where c.issue_id = i.id',
'       ) comment_count,',
'       (',
'           select count(*)',
'             from wwv_flow_issue_events e',
'            where e.issue_id = i.id',
'       ) event_count,',
'       h.assignees,',
'       h.assignees_html,',
'       ss.subcribers,',
'       ss.subscribers_html,',
'       l.labels,',
'       l.labels_html,',
'       m.milestones, ',
'       m.milestones_html,',
'       apex_util.prepare_url(''f?p=''||:APP_ID||'':100:''||:APP_SESSION||''::NO:RP:P100_ISSUE_ID:''||i.id , p_checksum_type=>3)issue_link, ',
'       case ',
'         when h.assignee_count > 5 then ''+''||(h.assignee_count -5) ',
'         else null',
'       end more_assignees',
'  from wwv_flow_issues               i,',
'       wwv_flow_current_workspaces   w,',
'       agg_stakeholders              h,',
'       agg_subscribers               ss,',
'       agg_labels                    l,',
'       wwv_flow_issues               i2,',
'       agg_milestones                  m',
' where i.deleted = ''N'' ',
'   and i.security_group_id = w.workspace_id',
'   and i.security_group_id = :flow_security_group_id',
'   and w.workspace_id = :flow_security_group_id',
'   and h.issue_id (+) = i.id',
'   and ss.issue_id (+) = i.id',
'   and l.issue_id (+) = i.id',
'   and m.issue_id (+) = i.id',
'   and i.duplicate_of = i2.id (+)',
'   and (i.created_by = :P500_USER_NAME',
'        OR ',
'        instr(h.assignees, wwv_flow_issue_int.get_user_name(:P500_USER_NAME) ) > 0',
'        OR',
'        instr(ss.subcribers,  wwv_flow_issue_int.get_user_name(:P500_USER_NAME)) > 0)',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16098000256950440.4605)
,p_name=>'ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'ID'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>20
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16098073052950441.4605)
,p_name=>'TITLE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TITLE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_LINK'
,p_heading=>unistr('T\00EDtulo')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP:P100_ISSUE_ID:&ID.'
,p_link_text=>'&TITLE.'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16098148723950442.4605)
,p_name=>'SLUG'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SLUG'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>40
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16098261686950443.4605)
,p_name=>'ISSUE_STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\00CDcone de Status')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16098335969950444.4605)
,p_name=>'ISSUE_TEXT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_TEXT'
,p_data_type=>'CLOB'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Texto do Problema'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>true
,p_max_length=>32767
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16098498670950445.4605)
,p_name=>'MARKED_DUPLICATE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MARKED_DUPLICATE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>unistr('Marcado como Duplica\00E7\00E3o')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16098658687950447.4605)
,p_name=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PAGE_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>unistr('ID da P\00E1gina')
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>90
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16098779357950448.4605)
,p_name=>'CREATED'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Criado'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>100
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16098832498950449.4605)
,p_name=>'CREATED_BY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_BY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Criado por'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>110
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16099004994950450.4605)
,p_name=>'COMMENT_COUNT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'COMMENT_COUNT'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>unistr('Coment\00E1rios')
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>120
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16099091711950451.4605)
,p_name=>'EVENT_COUNT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'EVENT_COUNT'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Eventos'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>130
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16099133014950452.4605)
,p_name=>'ASSIGNEES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ASSIGNEES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Lista de favorecidos'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>140
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16099297474950453.4605)
,p_name=>'ASSIGNEES_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ASSIGNEES_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\00CDcones de Favorecidos')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>150
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16137859472284504.4605)
,p_name=>'SUBCRIBERS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUBCRIBERS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Lista de Assinantes'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>160
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16137970055284505.4605)
,p_name=>'SUBSCRIBERS_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUBSCRIBERS_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\00CDcones de Assinante')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>170
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16138056062284506.4605)
,p_name=>'LABELS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABELS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Lista de Labels'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>180
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16138207326284507.4605)
,p_name=>'LABELS_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABELS_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Labels Aprimorados'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>190
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16138238471284508.4605)
,p_name=>'MILESTONES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MILESTONES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Lista de Marcos'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>200
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16138417422284509.4605)
,p_name=>'MILESTONES_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MILESTONES_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Marcos Aprimorados'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>210
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16307965494246038.4605)
,p_name=>'ISSUE_LINK'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_LINK'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Link do Problema'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>220
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16642917689045004.4605)
,p_name=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Status'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>230
,p_value_alignment=>'LEFT'
,p_attribute_02=>'LOV'
,p_lov_type=>'SHARED'
,p_lov_id=>wwv_flow_api.id(5664182917694426)
,p_lov_display_extra=>true
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16642970775045005.4605)
,p_name=>'CREATED_ON'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_ON'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'Criado em'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>240
,p_value_alignment=>'CENTER'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(16881324442342844.4605)
,p_name=>'CREATED_BY_LINK'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_BY_LINK'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Link Criado por'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>250
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(17028210148862207.4605)
,p_name=>'ISSUE_NUMBER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_NUMBER'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>unistr('Problema n\00BA')
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>260
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(156403038933150733.4605)
,p_name=>'MORE_ASSIGNEES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MORE_ASSIGNEES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Mais Favorecidos'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>270
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>41
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(165799585931198816.4605)
,p_name=>'APPLICATION_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'APPLICATION_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'ID do Aplicativo'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>80
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
end;
/
begin
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(681099570647003801.4605)
,p_name=>'Row Selector'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(16097863831950439.4605)
,p_internal_uid=>16097863831950439
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_show_nulls_as=>'-'
,p_select_first_row=>false
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_no_data_found_message=>unistr('Este usu\00E1rio n\00E3o \00E9 referenciado por problema algum.')
,p_show_toolbar=>true
,p_toolbar_buttons=>'SEARCH_FIELD:ACTIONS_MENU:RESET:SAVE'
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'PAGE'
,p_show_icon_view=>true
,p_icon_view_use_custom=>true
,p_icon_view_custom=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-ContentRowReport-item" data-id="&APEX$ROW_ID.">',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemSelection"><span class="u-selector"></span></div>',
'    <div class="a-ContentRowReport-itemIconWrap">&ISSUE_STATUS.</div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle" id="label_&ID."><a href="&ISSUE_LINK.">&TITLE.</a></h3> <span class="a-IssueList-itemLabels">&LABELS_HTML.</span>',
'        <div class="a-ContentRowReport-itemDescription">#&ISSUE_NUMBER. &CREATED. <a class="a-IssueList-itemAuthor" href="&CREATED_BY_LINK.">&CREATED_BY.</a> <span class="a-IssueList-itemMilestones">&MILESTONES_HTML.</span></div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">&ASSIGNEES_HTML.<span class="a-User a-User--more" title="&MORE_ASSIGNEES. other assignees"><span class="a-User-initials" role="presentation">&MORE_ASSIGNEES.</span></span></div>',
'      <div class="a-ContentRowReport-itemActions">',
'        <a class="a-IssueList-itemCommentsLink" href="&ISSUE_LINK."><span class="a-IssueList-itemCommentsIcon fa fa-comments-o"></span><span class="a-IssueList-itemCommentsCount">&COMMENT_COUNT.</span></a>',
'      </div>',
'    </div>',
'  </div>',
'</li>'))
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function (options) {',
'    var $ = apex.jQuery,',
'        toolbarData = $.apex.interactiveGrid.copyDefaultToolbar();',
'',
'    // don''t want single row view',
'    apex.util.getNestedObject(options, "views.grid.features").singleRowView = false;',
'',
'    options.defaultIconViewOptions = {',
'        collectionClasses: "a-ContentRowReport a-IssueList",',
'        iconListOptions: {',
'            navigation: false,',
'            tabbableContent: "a"',
'            // comes from row selector when navigation is false',
'            // multiple: true ',
'            // itemSelector: true',
'        }',
'    }',
'',
'    options.initActions = function(actions) {',
'        var ig$ = $(actions.context),',
'            iconView = ig$.interactiveGrid("getViews").icon;',
'',
'        iconView.title = apex.lang.getMessage( "Cards"); ',
'        iconView.icon = "icon-ig-details";',
'    };',
'',
'    return options;',
'',
'}',
''))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(633170192972983377.4605)
,p_plug_name=>'Sobre'
,p_region_css_classes=>'a-Region--stacked a-Region--padded a-Region--flush a-Region--sideRegion'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(179998957300224011.4605)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>O perfil deste usu\00E1rio do Team Development mostra os problemas pertencentes a um usu\00E1rio, aos quais ele foi designado ou nos quais est\00E1 inscrito.</p>'),
'<p><a target="_blank" href="&SYSTEM_HELP_URL./htmdb/viewing-your-user-profile.html#GUID-4A325C31-A23E-4182-BFE7-5718ADB70C9E">Saiba Mais...</a></p>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(11141499311970436.4605)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(11125556808028800.4605)
,p_button_name=>'NOTIFICATION_PREFERENCES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(656569185201725731.4605)
,p_button_image_alt=>unistr('Prefer\00EAncias de Notifica\00E7\00E3o')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:501:&SESSION.::&DEBUG.:RP,501::'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P500_USER_NAME = :APP_USER then ',
'  return true;',
'else ',
'  return false;',
'end if;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_icon_css_classes=>'icon-tools'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5949330299329318.4605)
,p_name=>'P500_USER_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(11125556808028800.4605)
,p_use_cache_before_default=>'NO'
,p_source=>'USER_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5949415922329319.4605)
,p_name=>'P500_EMAIL_ADDRESS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(11125556808028800.4605)
,p_use_cache_before_default=>'NO'
,p_source=>'EMAIL_ADDRESS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5949515464329320.4605)
,p_name=>'P500_FIRST_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(11125556808028800.4605)
,p_use_cache_before_default=>'NO'
,p_source=>'FIRST_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5949672127329321.4605)
,p_name=>'P500_LAST_NAME'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(11125556808028800.4605)
,p_use_cache_before_default=>'NO'
,p_source=>'LAST_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5949829216329323.4605)
,p_name=>'P500_USER_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(11125556808028800.4605)
,p_use_cache_before_default=>'NO'
,p_source=>'USER_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6185489765627135.4605)
,p_name=>'P500_DISPLAY_NAME'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(11125556808028800.4605)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(11426222230280826.4605)
,p_computation_sequence=>10
,p_computation_item=>'P500_USER_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(:P500_USER_NAME, :APP_USER)',
'  from sys.dual',
''))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(5950038976329325.4605)
,p_computation_sequence=>20
,p_computation_item=>'P500_USER_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select user_id ',
'  from wwv_flow_fnd_user',
' where user_name = :P500_USER_NAME',
'and security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(6185585024627136.4605)
,p_computation_sequence=>30
,p_computation_item=>'P500_DISPLAY_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select coalesce(trim(first_name||'' ''||last_name), user_name) display_name',
'  from wwv_flow_fnd_user',
'  where user_id = :P500_USER_ID',
'    and security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(681099628068003802.4605)
,p_name=>'Grid view activate to open'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(16097755849950438.4605)
,p_bind_type=>'bind'
,p_bind_event_type=>'custom'
,p_bind_event_type_custom=>'gridactivatecell'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(681099705640003803.4605)
,p_event_id=>wwv_flow_api.id(681099628068003802.4605)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var rec, meta, link,',
'    issuesIG = apex.region("issues"),',
'    view =  issuesIG.call("getCurrentView"), // this will be the grid view',
'    model = view.model;',
'',
'rec = view.getContextRecord(this.browserEvent.originalEvent.target);',
'meta = model.getRecordMetadata(model.getRecordId(rec[0]));',
'if (meta && meta.fields.TITLE) {',
'    apex.navigation.redirect(meta.fields.TITLE.url);',
'}',
''))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5950254008329327.4605)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch User 