prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4905
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4905 - Oracle APEX Websheets
--
-- Application Export:
--   Application:     4905
--   Name:            Oracle APEX Websheets
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                    112
--       Items:                  529
--       Computations:            62
--       Validations:            104
--       Processes:              132
--       Regions:                506
--       Buttons:                234
--       Dynamic Actions:         47
--     Shared Components:
--       Logic:
--         Items:                 29
--         Processes:             14
--         Computations:           5
--         Build Options:          1
--       Navigation:
--         Lists:                 23
--         Breadcrumbs:            1
--           Entries:             81
--         NavBar Entries:         5
--       Security:
--         Authentication:         1
--         Authorization:         11
--       User Interface:
--         Templates:
--           Page:                11
--           Region:              22
--           Label:                5
--           List:                14
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           1
--           Button:              20
--           Report:               4
--         LOVs:                 118
--         Shortcuts:              8
--         Plug-ins:               6
--       Globalization:
--         Messages:              30
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Websheets')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286634880694940263')
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135403'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'pt-br'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'DS'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(709672827800503408.4905)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'T'
,p_logo_text=>'Application Express'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'S'
,p_deep_linking=>'Y'
,p_vpd=>'wwv_flow_ws_auth.init_schema;'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'MSG_LANGUAGE'
,p_substitution_value_01=>'Idioma'
,p_substitution_string_02=>'MSG_USER'
,p_substitution_value_02=>unistr('Usu\00E1rio')
,p_substitution_string_03=>'DELETE_MSG'
,p_substitution_value_03=>unistr('Gostaria de executar esta a\00E7\00E3o de exclus\00E3o?')
,p_substitution_string_04=>'PRODUCT_NAME'
,p_substitution_value_04=>'Application Express'
,p_substitution_string_05=>'VIEW'
,p_substitution_value_05=>'Exibir'
,p_substitution_string_06=>'MSG_JSCRIPT'
,p_substitution_value_06=>unistr('Voc\00EA deve executar este produto com o JavaScript ativado.')
,p_substitution_string_07=>'CLOSE_MESSAGE'
,p_substitution_value_07=>'Fechar Mensagem'
,p_substitution_string_08=>'GO_TO_TOP'
,p_substitution_value_08=>unistr('Ir para o In\00EDcio')
,p_substitution_string_09=>'COLLAPSE'
,p_substitution_value_09=>'Contrair'
,p_substitution_string_10=>'EDIT'
,p_substitution_value_10=>'Editar'
,p_substitution_string_11=>'EXPANDED'
,p_substitution_value_11=>'Expandido'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141440'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/edit_sections
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15661014418081294.4905)
,p_name=>'Edit Sections'
,p_list_type=>'SQL_QUERY'
,p_list_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 as level_value',
'	, c001 label_value',
'	, ''f?p=''||:APP_ID||'':''||:APP_PAGE_ID||'':''||:APP_SESSION target',
'	, null is_current_list_entry',
'	, null image',
'	, null image_attribute',
'	, null image_alt_attribute',
'	, lower(c002)||''Icon'' attribute1',
'	, wwv_flow_item.text_from_lov(c002,''SECTION TYPES'') attribute2',
'	, lower(decode(c005,null,c004,c005)) attribute3',
'	, htmldb_util.get_since(decode(d001,null,d002,d001)) attribute4',
'	, case when c002 = ''TEXT'' and :APP_PAGE_ID = 930 and n003 = :P930_SECTION_ID then ''active''',
'	       when c002 = ''NAV_PAGE'' and :APP_PAGE_ID = 931 and n003 = :P931_SECTION_ID then ''active''',
'	       when c002 = ''NAV_SECTION'' and :APP_PAGE_ID = 932 and n003 = :P932_SECTION_ID then ''active''',
'	       when c002 = ''CHART'' and :APP_PAGE_ID = 760 and n003 = :P760_SECTION_ID then ''active''',
'	       when c002 = ''DATA'' and :APP_PAGE_ID = 934 and n003 = :P934_SECTION_ID then ''active''',
'	       when c002 = ''PLSQL'' and :APP_PAGE_ID = 23 and n003 = :P23_SECTION_ID then ''active''',
'	       when :APP_PAGE_ID = 991 and n003 = :SECTION_ID then ''active''',
'               when :APP_PAGE_ID = 990 and n003 = :SECTION_ID then ''active''	  ',
'	  end attribute5        ',
'    , c006 attribute6 -- next page id',
'    , c007 attribute7 -- next section page item name to hold section id',
'    , n003 attribute8 -- next section id',
'    , n002 display_sequence',
'from wwv_flow_collections',
'where collection_name = ''APEX$_WS_PAGE_SECTIONS''',
'order by n002'))
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/sections_settings_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(17135113310000767.4905)
,p_name=>'Sections Settings Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(17154020760040710.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Editar V\00E1rias Se\00E7\00F5es')
,p_list_item_link_target=>'f?p=&APP_ID.:940:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18786329979544670.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Mostrar Hist\00F3rico de Se\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:950:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18786123053542660.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Mover Se\00E7\00E3o para Nova P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:991:&SESSION.::&DEBUG.:991:P991_SECTION_ID,P991_PAGE_ID:&SECTION_ID.,&P900_ID.:'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18785810240539012.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Mover Se\00E7\00E3o para Outra P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:990:&SESSION.::&DEBUG.::P990_SECTION_ID,P990_PAGE_ID:&SECTION_ID.,&P900_ID.:'
,p_list_item_current_type=>'NEVER'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_pages
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(18529824151546479.4905)
,p_name=>'Edit Pages'
,p_list_type=>'FUNCTION_RETURNING_SQL_QUERY'
,p_list_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    q               varchar2(32767) := null;',
'    l_parent_page_id number := null;',
'begin      ',
'    for c1 in (select parent_page_id',
'               from wwv_flow_ws_webpages',
'               where ws_app_id = :ws_app_id',
'               and security_group_id = :flow_security_group_id',
'               and id =:P53_ID)',
'    loop',
'        l_parent_page_id := c1.parent_page_id;',
'    end loop;    ',
'    ',
'    q := ''select level ''||',
'         ''	, name label ''||',
'         ''  , ''''javascript:applyAndGoToNextPage(''''''''''''||id||'''''''''''')'''' target ''||         ',
'         ''	, null is_current_list_entry ''||',
'         ''	, null image ''||',
'         ''	, null image_attribute ''||',
'         ''	, null image_alt_attribute ''||',
'         ''	, lower(decode(updated_by,null,created_by,updated_by)) attribute1 ''||',
'         ''	, htmldb_util.get_since(decode(updated_on,null,created_on,updated_on)) attribute2 ''||',
'         ''	, case when id = :P53_ID then ''''active'''' end attribute3 ''||',
'         ''from wwv_flow_ws_webpages ''||',
'         ''where security_group_id = :FLOW_SECURITY_GROUP_ID ''||',
'         ''and ws_app_id = :WS_APP_ID '';',
'         --''and level    <= 2 '';',
'    ',
'    if l_parent_page_id is null then',
'        q:=q||''start with parent_page_id is null '';',
'    else',
'        q:=q||''start with id = ''||l_parent_page_id;        ',
'    end if; ',
'',
'    q:=q||''connect by prior id = parent_page_id '';',
'    q:=q||''order siblings by name'';        ',
'    ',
'    return q;',
'end;'))
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/pages_settings_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(18583325957802446.4905)
,p_name=>'Pages Settings Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18583829450802448.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Nova P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:200:P200_PARENT_PAGE,WS_APP_ID:&P900_ID.,&WS_APP_ID.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18584127738802448.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Nova P\00E1gina como uma C\00F3pia')
,p_list_item_link_target=>'f?p=&APP_ID.:908:&SESSION.::&DEBUG.:908:WS_APP_ID,P908_COPY_PAGE_FROM,P900_ID:&WS_APP_ID.,&P900_ID.,&P900_ID.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_activity_tab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(23689225706066046.4905)
,p_name=>'Monitor Activity Tab'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23689400293066047.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Views de P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'18'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23689719692066048.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Principais P\00E1ginas')
,p_list_item_link_target=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'24'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23690031914066048.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Principais Grades de Dados'
,p_list_item_link_target=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.::::	'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'141'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23690308632066049.4905)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Principais Relat\00F3rios')
,p_list_item_link_target=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'142'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23690603303066049.4905)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Principais Usu\00E1rios')
,p_list_item_link_target=>'f?p=&APP_ID.:146:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'146'
);
end;
/
prompt --application/shared_components/navigation/lists/admin_annotations_tab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(23775330395531080.4905)
,p_name=>'Admin Annotations Tab'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23775513281531081.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Principais Arquivos'
,p_list_item_link_target=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'143'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23775818182531082.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Principais Observa\00E7\00F5es')
,p_list_item_link_target=>'f?p=&APP_ID.:144:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'144'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23776108748531082.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Principais Tags'
,p_list_item_link_target=>'f?p=&APP_ID.:145:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'145'
);
end;
/
prompt --application/shared_components/navigation/lists/create_page_progress_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(29874807106517169.4905)
,p_name=>'create page progress bar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(173227427841861244.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Tipo de Componente'
,p_list_item_link_target=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'131'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(29885520930644174.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('M\00E9todo de Cria\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'205'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(29885725086645395.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Propriedades'
,p_list_item_link_target=>'f?p=&APP_ID.:201:&SESSION.::&DEBUG.:201:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'201,206'
);
end;
/
prompt --application/shared_components/navigation/lists/create_section_progress_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(174369523339947712.4905)
,p_name=>'create section progress bar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(174370314120954487.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Escolher Tipo de Se\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:920:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'920'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(178563610566182386.4905)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('Tipo de Navega\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:926:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'921,926,927'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'926'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(178522522266580262.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Origem de Dados'
,p_list_item_link_target=>'f?p=&APP_ID.:922:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'922,925'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'922'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(174370522431956915.4905)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Definir Se\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:910:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'910,921,927,925'
);
end;
/
prompt --application/shared_components/navigation/lists/annotation_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(178837028298310188.4905)
,p_name=>'annotation tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(187173101861909018.4905)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Tudo'
,p_list_item_link_target=>'f?p=&APP_ID.:906:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'906'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(178837317622310200.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Arquivos'
,p_list_item_link_target=>'f?p=&APP_ID.:903:&SESSION.::&DEBUG.:APEX$_WS_FILES:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'903'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(178838019750310282.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Observa\00E7\00F5es')
,p_list_item_link_target=>'f?p=&APP_ID.:905:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'905'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(473073917597603316.4905)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Links'
,p_list_item_link_target=>'f?p=&APP_ID.:915:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'915'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(178837724276310282.4905)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Tags'
,p_list_item_link_target=>'f?p=&APP_ID.:904:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'904'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(458964205010652503.4905)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Nuvem de Tags'
,p_list_item_link_target=>'f?p=&APP_ID.:928:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'928'
);
end;
/
prompt --application/shared_components/navigation/lists/create_report_progress_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(181250307256073810.4905)
,p_name=>'create report progress bar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181310223288910949.4905)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Tipo de Componente'
,p_list_item_link_target=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'131'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181259832284137754.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Atributos do Relat\00F3rio')
,p_list_item_link_target=>'f?p=&APP_ID.:1310:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1310'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181272207059234540.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Confirmar'
,p_list_item_link_target=>'f?p=&APP_ID.:1320:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1320'
);
end;
/
prompt --application/shared_components/navigation/lists/p_902_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(187087619151586620.4905)
,p_name=>'p 902 tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(187087931306586621.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Tudo'
,p_list_item_link_target=>'f?p=&APP_ID.:902:&SESSION.::&DEBUG.::P902_SHOW:ALL:'
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_list_item_current_type=>'EXISTS'
,p_list_item_current_for_pages=>'select 1 from dual where nvl(:P902_SHOW,''ALL'') = ''ALL'''
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(187088302932586621.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Grades de Dados'
,p_list_item_link_target=>'f?p=4900:902:&SESSION.::::P902_SHOW:DATAGRID'
,p_list_item_current_type=>'EXISTS'
,p_list_item_current_for_pages=>'select 1 from dual where :P902_SHOW = ''DATAGRID'''
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(187088713953586622.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Relat\00F3rios')
,p_list_item_link_target=>'f?p=&APP_ID.:902:&SESSION.::&DEBUG.::P902_SHOW:REPORT:'
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_list_item_current_type=>'EXISTS'
,p_list_item_current_for_pages=>'select 1 from dual where :P902_SHOW = ''REPORT'''
);
end;
/
prompt --application/shared_components/navigation/lists/admin_toolbar_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(202684424744514793.4905)
,p_name=>'Admin Toolbar Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202686125516514795.4905)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('Administra\00E7\00E3o')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(:APP_USER,''nobody'') not in (''APEX_PUBLIC_USER'',''HTMLDB_PUBLIC_USER'',''ANONYMOUS'',''nobody'',''PUBLIC_USER'') then',
'  if wwv_flow_ws_security.current_user_is_admin or wwv_flow_ws_api.show_reset_password(p_ws_app_id => :ws_app_id) then',
'      return true;',
'  else',
'      return false;',
'  end if;',
'else',
'  return false;',
'end if;'))
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202688803947514796.4905)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Painel de Controle'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4905)
,p_list_text_01=>'ws-admin-dashboard'
,p_list_text_05=>'Alt+B'
,p_security_scheme=>wwv_flow_api.id(456220816180174638)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202692116934514798.4905)
,p_list_item_display_sequence=>280
,p_list_item_link_text=>'Monitorar Atividade'
,p_list_item_link_target=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4905)
,p_list_text_01=>'ws-admin-monitor'
,p_list_text_05=>'Alt+M'
,p_security_scheme=>wwv_flow_api.id(456220816180174638)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202692413363514798.4905)
,p_list_item_display_sequence=>290
,p_list_item_link_text=>'Propriedades da Websheet'
,p_list_item_link_target=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:1250:P1250_ID:&WS_APP_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4905)
,p_list_text_01=>'ws-admin-properties'
,p_list_text_05=>'Alt+P'
,p_security_scheme=>wwv_flow_api.id(456220816180174638)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202692709697514798.4905)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Controle de Acesso'
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4905)
,p_list_text_01=>'ws-admin-acl'
,p_list_text_05=>'Alt+X'
,p_security_scheme=>wwv_flow_api.id(456220816180174638)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(212953623410993837.4905)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'--'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4905)
,p_list_text_01=>'wsMenuSep'
,p_security_scheme=>wwv_flow_api.id(506060600392166972)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202693609322514799.4905)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>'Alterar Minha Senha'
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:5:::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4905)
,p_security_scheme=>wwv_flow_api.id(506060600392166972)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/create_chart_section_progress_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(261469429368022853.4905)
,p_name=>'create chart section progress bar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(261470512876027512.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Tipo de Se\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:920:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'920'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(261470821880030114.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Tipo de Gr\00E1fico')
,p_list_item_link_target=>'f?p=&APP_ID.:710:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'710'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(261471504481044080.4905)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Origem do Gr\00E1fico')
,p_list_item_link_target=>'f?p=&APP_ID.:740:&SESSION.::&DEBUG.::::'
,p_list_item_disp_condition2=>'DATA_GRID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'740:745'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(261471828030050875.4905)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Defini\00E7\00E3o do Gr\00E1fico')
,p_list_item_link_target=>'f?p=&APP_ID.:742:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'742'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(261472414655056417.4905)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Criar'
,p_list_item_link_target=>'f?p=&APP_ID.:750:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'750'
);
end;
/
prompt --application/shared_components/navigation/lists/help_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(456471813385447055.4905)
,p_name=>'Help Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(472810017189623092.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Sobre'
,p_list_item_link_target=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'16'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(456472503328447058.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Vis\00E3o Geral')
,p_list_item_link_target=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'15'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(619280916964076011.4905)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Controle de Acesso'
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(456472932226447059.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Sintaxe de Marca\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'17'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6247915223597961.4905)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Grade de Dados'
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491253712635289676.4905)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('Conte\00FAdo do Aplicativo')
,p_list_item_link_target=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'25,27,28,29,30,12'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(487175029602607075.4905)
,p_list_item_display_sequence=>999
,p_list_item_link_text=>'Perguntas Mais Frequentes'
,p_list_item_link_target=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'19'
);
end;
/
prompt --application/shared_components/navigation/lists/administration_menu_options
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(457230629124432618.4905)
,p_name=>'administration menu options'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457230905908432621.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Painel de Controle'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'ws/ws-dashboard.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457231305495432622.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Monitorar Atividade'
,p_list_item_link_target=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'ws/ws-chart.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'140'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457232713110446916.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Propriedades da Websheet'
,p_list_item_link_target=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:1250:P1250_ID:&WS_APP_ID.:'
,p_list_item_icon=>'ws/ws-properties.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457321625061188359.4905)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Controle de Acesso'
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'ws/ws-access-control.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_menu_options
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(457456818808085338.4905)
,p_name=>'Page Menu Options'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457458705480119260.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Home Page'
,p_list_item_link_target=>'ws?p=&WS_APP_ID.:home:&SESSION.'
,p_list_item_icon=>'apex/builder/menu-home-128.gif'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457457112971085339.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Diret\00F3rio de P\00E1ginas')
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex/builder/menu-page-dir-128.gif'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457468208784233794.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Exibir Hist\00F3rico')
,p_list_item_link_target=>'f?p=&APP_ID.:950:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex/builder/menu-change-log-128.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457482932080297318.4905)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Criar Nova P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:200:::'
,p_list_item_icon=>'apex/builder/menu-add-page-128.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_activity
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(459634320543429042.4905)
,p_name=>'Monitor Activity'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(459634600866429048.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Views de P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'18'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471679808716623953.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Principais P\00E1ginas')
,p_list_item_link_target=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'18'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471680625685628854.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Principais Grades de Dados'
,p_list_item_link_target=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.::::	'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'141'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471681413003634676.4905)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Principais Relat\00F3rios')
,p_list_item_link_target=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'142'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471917315656277818.4905)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('Principais Usu\00E1rios')
,p_list_item_link_target=>'f?p=&APP_ID.:146:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'142'
);
end;
/
prompt --application/shared_components/navigation/lists/annotations
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(461178801985335895.4905)
,p_name=>'Annotations'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(461179122466335896.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Principais Arquivos'
,p_list_item_link_target=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'140'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(461179526172335897.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Principais Observa\00E7\00F5es')
,p_list_item_link_target=>'f?p=&APP_ID.:144:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'140'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(461179925451335897.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Principais Tags'
,p_list_item_link_target=>'f?p=&APP_ID.:145:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'140'
);
end;
/
prompt --application/shared_components/navigation/lists/page_directory
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(461346705230446581.4905)
,p_name=>'Page Directory'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(461347024629446628.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Diret\00F3rio de P\00E1ginas')
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.:'
,p_list_item_current_for_pages=>'1000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(461347428128446630.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Diret\00F3rio da Websheet')
,p_list_item_link_target=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/history_tab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(471880222274882374.4905)
,p_name=>'History Tab'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471880504499882381.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Relat\00F3rio')
,p_list_item_link_target=>'f?p=&APP_ID.:950:&SESSION.:'
,p_list_item_current_for_pages=>'950'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471880901168882390.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Calend\00E1rio')
,p_list_item_link_target=>'f?p=&APP_ID.:951:&SESSION.:'
,p_list_item_current_for_pages=>'951'
);
end;
/
prompt --application/shared_components/navigation/lists/help_application_content_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(491255024672312078.4905)
,p_name=>'Help application content tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491256117021312081.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('P\00E1ginas')
,p_list_item_link_target=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'25'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492152905074851834.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Se\00E7\00F5es')
,p_list_item_link_target=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'28'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491256416740312081.4905)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Arquivos / Imagens'
,p_list_item_link_target=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'27'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491257030941312082.4905)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Grades de Dados'
,p_list_item_link_target=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT 1',
'from wwv_flow_worksheets w, ',
'     wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id and',
'      w.security_group_id = :flow_security_group_id and                  ',
'      a.ws_app_id = :ws_app_id and',
'      nvl(a.websheet_type,''DATA'') = ''DATA'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'29'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491257320723312082.4905)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('Relat\00F3rios')
,p_list_item_link_target=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT 1',
'from wwv_flow_worksheets w, ',
'     wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id and',
'      w.security_group_id = :flow_security_group_id and                  ',
'      a.ws_app_id = :ws_app_id and',
'      nvl(a.websheet_type,''DATA'') = ''REPORT'''))
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'30'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491257610094312082.4905)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'SQL Sugerido'
,p_list_item_link_target=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_ws_applications',
' where id = :WS_APP_ID',
'   and security_group_id = :flow_security_group_id',
'   and allow_sql_yn = ''Y''',
'   and exists (select 1 from wwv_flow_ws_app_sug_objects',
'                where ws_app_id = :WS_APP_ID',
'                and security_group_id = :flow_security_group_id)'))
,p_security_scheme=>wwv_flow_api.id(495860932509802714)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'12'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_report_view_mode
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(491741626522063565.4905)
,p_name=>'edit report view mode'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491742324922072587.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Atributos do Relat\00F3rio')
,p_list_item_link_target=>'javascript:doSubmit(''SAVE_REPORT_ATTR'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3010:3020'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491761112810144768.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Consulta de Relat\00F3rios')
,p_list_item_link_target=>'javascript:doSubmit(''SAVE_QUERY'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3030:3060'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_0_toolbar_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(929134615131186819.4905)
,p_name=>'APEX 5.0 - Toolbar Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929134801726186821.4905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Exibir'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929138403023186825.4905)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('In\00EDcio')
,p_list_item_link_target=>'ws?p=&WS_APP_ID.:home:&APP_SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4905)
,p_list_text_01=>'ws-view-home'
,p_list_text_05=>'Alt+H'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929138706106186825.4905)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('Modo de Apresenta\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:901:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'900'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4905)
,p_list_text_01=>'ws-view-presentation-mode'
,p_list_text_05=>'Alt+Q'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929139001784186826.4905)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('Diret\00F3rio de P\00E1ginas')
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4905)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929140888830186828.4905)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('Relat\00F3rios')
,p_list_item_link_target=>'f?p=&APP_ID.:902:&SESSION.::&DEBUG.::P902_SHOW:REPORT:'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4905)
,p_list_text_01=>'ws-view-reports'
,p_list_text_05=>'Alt+R'
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929141179837186828.4905)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('Hist\00F3rico de P\00E1ginas')
,p_list_item_link_target=>'f?p=&APP_ID.:950:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4905)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929141414305186828.4905)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('Diret\00F3rio da Websheet')
,p_list_item_link_target=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4905)
,p_list_text_01=>'ws-view-ws-directory'
,p_list_text_05=>'Alt+Shift+D'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(930987028365270703.4905)
,p_list_item_display_sequence=>270
,p_list_item_link_text=>unistr('Anota\00E7\00F5es')
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4905)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929139607423186826.4905)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Arquivos'
,p_list_item_link_target=>'f?p=&APP_ID.:903:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4905)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929139919238186826.4905)
,p_list_item_display_sequence=>180
,p_list_item_link_text=>'Tags'
,p_list_item_link_target=>'f?p=&APP_ID.:928:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4905)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929140243536186826.4905)
,p_list_item_display_sequence=>190
,p_list_item_link_text=>unistr('Observa\00E7\00F5es')
,p_list_item_link_target=>'f?p=&APP_ID.:905:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4905)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929140500508186828.4905)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'Links'
,p_list_item_link_target=>'f?p=&APP_ID.:915:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4905)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(931217661486553673.4905)
,p_list_item_display_sequence=>203
,p_list_item_link_text=>'--'
,p_list_item_link_target=>'separator'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'7,8,32'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4905)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929139371751186826.4905)
,p_list_item_display_sequence=>205
,p_list_item_link_text=>'Exibir Tudo'
,p_list_item_link_target=>'f?p=&APP_ID.:906:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4905)
,p_list_text_01=>'ws-view-all-annotations'
,p_list_text_05=>'Alt+A'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929135108865186823.4905)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Criar'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929136360244186823.4905)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('Nova P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:200:P200_PARENT_PAGE,WS_APP_ID:&P900_ID.,&WS_APP_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4905)
,p_list_text_01=>'ws-create-page'
,p_list_text_05=>'Alt+N'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929136628803186823.4905)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('Nova P\00E1gina como uma C\00F3pia')
,p_list_item_link_target=>'f?p=&APP_ID.:908:&SESSION.::&DEBUG.:908:WS_APP_ID,P908_COPY_PAGE_FROM,P900_ID:&WS_APP_ID.,&P900_ID.,&P900_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4905)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929136959895186825.4905)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('Nova Se\00E7\00E3o')
,p_list_item_link_target=>'f?p=&APP_ID.:920:&SESSION.::&DEBUG.:920,921:WS_APP_ID,P921_STARTING_PAGE:&WS_APP_ID.,&P900_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4905)
,p_list_text_01=>'ws-create-section'
,p_list_text_05=>'Alt+Shift+N'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929137293514186825.4905)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Nova Grade de Dados'
,p_list_item_link_target=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:205,1310,1320:WS_APP_ID:&WS_APP_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4905)
,p_list_text_01=>'ws-create-datagrid'
,p_list_text_05=>'Alt+Shift+D'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929137547826186825.4905)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('Novo Relat\00F3rio')
,p_list_item_link_target=>'f?p=&APP_ID.:1310:&SESSION.::&DEBUG.:1310,1320:WS_APP_ID:&WS_APP_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4905)
,p_list_text_01=>'ws-create-report'
,p_list_text_05=>'Alt+Shift+R'
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929137898140186825.4905)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'--'
,p_list_item_link_target=>'separator'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'7,8,32'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4905)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929138168832186825.4905)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Nova Websheet'
,p_list_item_link_target=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:7,8,32:::'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4905)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929135423776186823.4905)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Criar'
,p_list_text_02=>'true'
,p_security_scheme=>'!'||wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929135709186186823.4905)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Editar'
,p_list_text_03=>'Ctrl+N'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929141723344186828.4905)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('Editar P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.:53:P53_ID,WS_APP_ID:&P900_ID.,&WS_APP_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135709186186823.4905)
,p_list_text_01=>'ws-edit-page'
,p_list_text_05=>'Alt+E'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929142003161186828.4905)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('Excluir P\00E1gina')
,p_list_item_link_target=>'f?p=&APP_ID.:960:&SESSION.::&DEBUG.:53:P53_ID:&P900_ID.:'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_ws_api.is_app_home_page(p_ws_app_id => :ws_app_id, p_webpage_id => :p900_id)'
,p_parent_list_item_id=>wwv_flow_api.id(929135709186186823.4905)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929142397543186828.4905)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>unistr('Editar Se\00E7\00F5es')
,p_list_item_link_target=>'f?p=&APP_ID.:940:&SESSION.::&DEBUG.:940:::'
,p_parent_list_item_id=>wwv_flow_api.id(929135709186186823.4905)
,p_list_text_01=>'ws-edit-sections'
,p_list_text_05=>'Alt+Shift+E'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929136059659186823.4905)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Editar'
,p_list_text_02=>'true'
,p_security_scheme=>'!'||wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1081228229344684.4905)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2015719452410064.4905)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14849102226940934.4905)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(92009116035572450.4905)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765073485610712056.4905)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831723025707993879.4905)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917633175675939889.4905)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178942513630772437.4905)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('N\00E3o h\00E1 privil\00E9gios para a opera\00E7\00E3o em quest\00E3o')
,p_reference_id=>786516029127697713.4905
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178942909534772438.4905)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a usar o SQL Workshop')
,p_reference_id=>786516265251697717.4905
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178943426646772439.4905)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('O Team Development n\00E3o est\00E1 ativado para este espa\00E7o de trabalho')
,p_reference_id=>786516861027697723.4905
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178943900647772439.4905)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('N\00E3o h\00E1 privil\00E9gios para a opera\00E7\00E3o em quest\00E3o')
,p_reference_id=>786517166823697723.4905
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/current_user_is_at_least_contributor
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(456220226828170850.4905)
,p_name=>'Current user is at least contributor'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_ws_security.current_user_is_not_reader;'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a acessar esta fun\00E7\00E3o.')
,p_reference_id=>786952716254317846.4905
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/current_user_is_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(456220816180174638.4905)
,p_name=>'Current user is admin'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_ws_security.current_user_is_admin;'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a acessar esta fun\00E7\00E3o.')
,p_reference_id=>786954200597322276.4905
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/user_is_apex_developer
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(487678607690660963.4905)
,p_name=>'User is APEX Developer'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  for c1 in (select 1 ',
'             from wwv_flow_developer_workspaces ',
'             where workspace_id = :flow_security_group_id',
'             and developer_name= :app_user)',
'  loop',
'    -- if websheet logged in user is developer then, return true',
'    return true;',
'  end loop;  ',
'  return false;',
'end;'))
,p_error_message=>unistr('Voc\00EA deve ser um Desenvolvedor do Application Express para acessar esta fun\00E7\00E3o.')
,p_reference_id=>786953667141317846.4905
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sql_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(492214905335570870.4905)
,p_name=>'SQL_ENABLED'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_ws_security.sql_enabled(:WS_APP_ID) and wwv_flow_ws_security.sql_enabled_inst;'
,p_error_message=>unistr('Acesso ao SQL n\00E3o ativado.')
,p_reference_id=>786953304778317846.4905
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/current_user_is_at_least_contributor_and_sql_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(495860932509802714.4905)
,p_name=>'Current user is at least contributor and SQL enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_ws_security.current_user_is_not_reader and wwv_flow_ws_security.sql_enabled(:WS_APP_ID) and wwv_flow_ws_security.sql_enabled_inst;'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a acessar esta fun\00E7\00E3o.')
,p_reference_id=>786953038199317846.4905
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/show_reset_password
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(506060600392166972.4905)
,p_name=>'show reset password'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_ws_api.show_reset_password(p_ws_app_id => :ws_app_id);'
,p_error_message=>unistr('A redefini\00E7\00E3o de senha n\00E3o est\00E1 ativada.')
,p_reference_id=>786953911558317846.4905
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_packaged_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(763730931852686354.4905)
,p_name=>'APEX 5.0 Packaged App Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a instalar Aplicativos Empacotados')
,p_reference_id=>786517456817697723.4905
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(2221120362249577.4905)
,p_icon_sequence=>10
,p_icon_subtext=>'Bem-vindo &APP_USER.'
,p_icon_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_icon_image_alt=>'Bem-vindo &APP_USER.'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(617028331038386115.4905)
,p_icon_sequence=>20
,p_icon_subtext=>'( <span style="text-decoration:underline;">Fazer Log-in</span> )'
,p_icon_target=>'f?p=&APP_ID.:79:&SESSION.:LOGIN:&DEBUG.::WS_APP_ID:&WS_APP_ID.:'
,p_icon_image_alt=>'Log-in'
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond_type=>'USER_IS_PUBLIC_USER'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(620001721380496329.4905)
,p_icon_sequence=>30
,p_icon_subtext=>'Idioma'
,p_icon_target=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.:::'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(2290404332055831.4905)
,p_icon_sequence=>40
,p_icon_subtext=>'( <span style="text-decoration:underline;">Fazer Log-out</span> )'
,p_icon_target=>'f?p=&APP_ID.:79:&SESSION.::&DEBUG.::::'
,p_icon_image_alt=>'Log-out'
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond_type=>'USER_IS_NOT_PUBLIC_USER'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(203498613231050603.4905)
,p_icon_sequence=>50
,p_icon_subtext=>'Feedback'
,p_icon_target=>'javascript:popupURL(''f?p=4900:102:&SESSION.:::102:P102_APPLICATION_ID,P102_PAGE_ID:&APP_ID.,&APP_PAGE_ID.'');'
,p_nav_entry_is_feedback_yn=>'Y'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(111038982738267161.4905)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/set_websheet_application_date_format_for_session
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(467798605271386699.4905)
,p_process_sequence=>5
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Websheet Application Date Format for Session'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_worksheet_standard.set_ws_app_date_format( ',
'    p_ws_app_id => :WS_APP_ID );'))
,p_process_error_message=>'Erro ao definir o formato de data do aplicativo de websheet'
,p_process_when=>'WS_APP_ID'
,p_process_when_type=>'ITEM_NOT_NULL_OR_ZERO'
);
end;
/
prompt --application/shared_components/logic/application_processes/maintain_g_running_worksheets_app
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(185099800820727550.4905)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'maintain g_running_worksheets_app'
,p_process_sql_clob=>'wwv_flow_log.g_websheet_id := :WS_APP_ID;'
,p_process_error_message=>unistr('n\00E3o \00E9 poss\00EDvel definir global')
);
end;
/
prompt --application/shared_components/logic/application_processes/check_user_is_at_least_reader
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(456113631939841224.4905)
,p_process_sequence=>15
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check user is at least reader'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_ws_security.get_current_user_role,''0'') = ''0'' then',
'  sys.htp.init;',
'  wwv_flow.g_unrecoverable_error := true;',
'                 sys.owa_util.redirect_url(''f?p=&APP_ID.:99:&SESSION.'');',
'',
'end if;'))
,p_process_error_message=>unistr('Erro ao determinar a autoriza\00E7\00E3o.')
,p_process_when=>':APP_PAGE_ID not in (''79'',''99'',''101'') and nvl(wwv_flow_security.g_user,''nobody'') != ''nobody'''
,p_process_when_type=>'PLSQL_EXPRESSION'
);
end;
/
prompt --application/shared_components/logic/application_processes/user_is_at_least_a_contributor
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(456277312414876323.4905)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'User is at least a contributor'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_ws_security.get_current_user_role,''0'') not in (''C'',''A'') then',
'  sys.htp.init;',
'  wwv_flow.g_unrecoverable_error := true;',
'  sys.owa_util.redirect_url(''f?p=&APP_ID.:99:&SESSION.'');',
'end if;'))
,p_process_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a acessar esta fun\00E7\00E3o.')
,p_process_when=>'20,53,90,131,200,201,205,206,710,760,908,910,920,921,922,926,927,930,931,932,934,1310,1320,4020,4030,4040,940,960,3010,3030'
,p_process_when_type=>'CURRENT_PAGE_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/check_user_is_admin
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(456253831789380446.4905)
,p_process_sequence=>25
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check user is admin'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if not wwv_flow_ws_security.current_user_is_admin then',
'',
'  sys.htp.init;',
'  wwv_flow.g_unrecoverable_error := true;',
'                 sys.owa_util.redirect_url(''f?p=4900:99:''||:APP_SESSION);',
'',
'end if;'))
,p_process_error_message=>unistr('Voc\00EA n\00E3o est\00E1 autorizado a acessar esta fun\00E7\00E3o.')
,p_process_when=>'1,3,11,13,18,24,140,141,142,143,144,145,146,1250'
,p_process_when_type=>'CURRENT_PAGE_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/websheet
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(1367007177305239.4905)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'websheet'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_widget_action     varchar2(32767) := wwv_flow.g_widget_action;',
'  l_validation_error  varchar2(32767) := null;',
'  l_opt               varchar2(4000) := null;',
'begin',
'  if l_widget_action = ''websheet_properties_save'' then',
'    wwv_flow_ws_api.save_websheet_properties (',
'        p_ws_app_id        => :WS_APP_ID,',
'        p_worksheet_id     => :P2_ID,        ',
'        p_name             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NAME''),',
'        p_alias            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ALIAS''),',
'        p_description      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DESCRIPTION''),        ',
'        p_row_pk1          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROW_PK1''),',
'        p_row_pk2          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROW_PK2''),',
'        p_row_pk3          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROW_PK3''),',
'        p_publish          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_PUBLISH''),',
'        p_validation_error => l_validation_error',
'        );',
'  elsif l_widget_action = ''column_properties_save'' then',
'     wwv_flow_ws_api.save_column_properties (',
'        p_worksheet_id      => :P2_ID,',
'        p_websheet_id       => :P2_WEBSHEET_ID,',
'        p_app_user          => :APP_USER,',
'        p_db_column_name    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'        p_display_order     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_SEQUENCE''),',
'        p_group_id          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID''),       ',
'        p_display_as        => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_AS''),        ',
'        p_label             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_LABEL''),',
'        p_format_mask       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_FORMAT_MASK''),        ',
'        p_value_required    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REQUIRED''),        ',
'        p_heading_alignment => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_HEADING_ALIGNMENT''),',
'        p_column_alignment  => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_ALIGNMENT''),        ',
'        p_lov_id            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV''),',
'        p_lov_name          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'        p_lov_entries       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),        ',
'        p_default_type      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TYPE''),',
'        p_default_text      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TEXT''),        ',
'        p_width             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_WIDTH''),',
'        p_max_width         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_MAX_LENGTH''),',
'        p_height            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_HEIGHT''),',
'        p_help_text         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_HELP_TEXT''),',
'        p_validation_error  => l_validation_error',
'        );',
'  elsif l_widget_action = ''column_add'' then',
'     wwv_flow_ws_api.add_column (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_report_id        => :RPT_ID,',
'         p_app_user         => :APP_USER,',
'         p_column_name      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_NAME''),',
'         p_column_type      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_TYPE''),',
'         p_display_as       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_AS''),',
'         p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV''),',
'         p_value_required   => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REQUIRED''),',
'         p_default_type     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TYPE''),',
'         p_default_text     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TEXT''),',
'         p_lov_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'         p_lov_entries      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),',
'         p_validation_error => l_validation_error',
'         ); ',
'  elsif l_widget_action = ''column_remove'' then',
'',
'',
'',
'     wwv_flow_ws_api.remove_column (',
'         p_worksheet_id     => :P2_ID,',
'         p_columns          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'         p_confirm          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_CONFIRM''),      ',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''lov_save'' then',
'     wwv_flow_ws_api.save_lov (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ID''),',
'         p_lov_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'         p_lov_entries      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),  ',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''column_groups_save'' then',
'     wwv_flow_ws_api.save_column_group (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_group_id         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID''),',
'         p_seq              => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_SEQUENCE''),',
'         p_group_name       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NAME''),',
'         p_description      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DESCRIPTION''),         ',
'         p_columns          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_SHUTTLE_RIGHT''),',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''column_groups_delete'' then',
'     wwv_flow_ws_api.delete_column_group (',
'         p_worksheet_id     => :P2_ID,',
'         p_group_id         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID'')',
'         );',
'  elsif l_widget_action = ''copy'' then',
'    wwv_flow_ws_api.copy_websheet (',
'         p_ws_app_id        => :WS_APP_ID,',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_new_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NEW_WORKSHEET_NAME''),',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''delete_websheet'' then    ',
'    wwv_flow_ws_api.delete_websheet (',
'        p_worksheet_id     => :P2_ID,',
'        p_websheet_id      => :P2_WEBSHEET_ID,               ',
'        p_confirm          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_CONFIRM''),',
'        p_validation_error => l_validation_error);       ',
'  elsif l_widget_action = ''delete_rows'' then',
'    wwv_flow_ws_api.delete_rows (',
'        p_websheet_id      => :P2_WEBSHEET_ID,',
'        p_rows             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROWS''),',
'        p_selected_rows    => wwv_flow.g_x01,',
'        p_confirm          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_CONFIRM''),',
'        p_validation_error => l_validation_error);',
'  elsif l_widget_action = ''set_column_value'' then',
'    wwv_flow_ws_api.set_column_value (',
'        p_websheet_id      => :P2_WEBSHEET_ID, ',
'        p_db_column_name   => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'        p_new_value        => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NEW_COLUMN_VALUE''),',
'        p_rows             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROWS''),',
'        p_selected_rows    => wwv_flow.g_x01,',
'        p_validation_error => l_validation_error);',
'  elsif l_widget_action = ''replace_column_value'' then',
'    wwv_flow_ws_api.replace_column_value (',
'        p_websheet_id      => :P2_WEBSHEET_ID,',
'        p_rows              => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROWS''),',
'        p_db_column_names   => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMS''),',
'        p_find_what         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REPLACE''),',
'        p_replace_with      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REPLACE_WITH''),',
'        p_selected_rows     => wwv_flow.g_x01,',
'        p_validation_error  => l_validation_error);',
'  elsif l_widget_action = ''fill_column_value'' then',
'    wwv_flow_ws_api.fill_column_value (',
'        p_websheet_id      => :P2_WEBSHEET_ID,',
'        p_db_column_name     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),    ',
'        p_validation_error   => l_validation_error);',
'  elsif l_widget_action = ''lov_delete'' then',
'    wwv_flow_ws_api.delete_lov (',
'        p_worksheet_id     => :P2_ID,',
'        p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ID''),  ',
'        p_validation_error => l_validation_error',
'        );     ',
'  elsif l_widget_action = ''toggle_checkboxes'' then',
'        if nvl(v(''P2_SHOW_CHECKBOX''),''N'') = ''Y'' then',
'            wwv_flow.update_cache_with_write(p_name => ''P2_SHOW_CHECKBOX'', p_value => ''N'');            ',
'        elsif nvl(v(''P2_SHOW_CHECKBOX''),''N'') = ''N'' then',
'            wwv_flow.update_cache_with_write(p_name => ''P2_SHOW_CHECKBOX'', p_value => ''Y'');',
'        end if;',
'  elsif l_widget_action = ''export'' then',
'    if wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_EXPORT_FORMAT'') = ''DATABASE'' then',
'        sys.owa_util.redirect_url(''f?p=''||:APP_ID||'':2:''||:APP_SESSION||'':HTMLD'');',
'    end if;',
'  elsif l_widget_action = ''set_geocode'' then',
'    wwv_flow_ws_geocode.save_geocodes(',
'        p_worksheet_id => :P2_ID,',
'        p_columns      => wwv_flow.g_x01 );',
'  elsif l_widget_action = ''refresh_geocode'' then',
'    wwv_flow_ws_geocode.reset_geocodes(',
'        p_worksheet_id => :P2_ID);',
'  elsif l_widget_action = ''VALIDATION_SAVE'' then',
'     wwv_flow_ws_api.save_column_validation (',
'         p_ws_app_id        => :WS_APP_ID,',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_validation_id    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_ID''),',
'         p_validation_level => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_LEVEL''),',
'         p_name             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_NAME''),',
'         p_seq              => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_SEQUENCE''),',
'         p_type             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_TYPE''),',
'         p_expr1            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'         p_expr2            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION''),',
'         p_error_message    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ERROR_MESSAGE''),',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''VALIDATION_DELETE'' then',
'     wwv_flow_ws_api.delete_column_validation (',
'         p_worksheet_id     => :P2_ID,',
'         p_validation_id    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_ID'')         ',
'         );       ',
'  end if;  ',
'',
'  if l_validation_error is null then',
'      sys.htp.prn(''true'');      ',
'  else',
'      sys.htp.prn(l_validation_error);      ',
'  end if;',
'exception when others then',
'  sys.htp.prn(''error ''||wwv_flow_escape.html(sqlerrm));',
'end;'))
,p_process_error_message=>'websheet process error'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_process_comment=>'WebSheet dialog saving.'
);
end;
/
prompt --application/shared_components/logic/application_processes/item_row
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(2693010773842087.4905)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ITEM_ROW'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_goto_ws_row       varchar2(32767);',
'    l_validation_error	varchar2(32767) := null;',
'    l_validation_count  number          := 0;',
'    l_validation_title  varchar2(4000)  := null;',
'    l_action            varchar2(4000)  := wwv_flow.g_x01;',
'begin',
'    -- Don''t process the row, if we''re removing a column.',
'    if l_action != ''column_remove'' then ',
'        wwv_flow_ws_api.process_row (',
'            p_ws_app_id     => :WS_APP_ID,',
'            p_worksheet_id  => :P2_ID,',
'            p_websheet_id   => :P2_WEBSHEET_ID,',
'            p_row_id        => :CURRENT_WORKSHEET_ROW,',
'            f01             => wwv_flow.g_f01,',
'            f02             => wwv_flow.g_f02,       ',
'            p_validation_error => l_validation_error,',
'            p_validation_count => l_validation_count,',
'            p_ajax_mode => true );',
'    end if;',
'    ',
'    if l_validation_count = 0 then',
'        htmldb_util.set_session_state(''CURRENT_WORKSHEET_ROW'', v(''GOTO_WORKSHEET_ROW''));',
'        htmldb_util.set_session_state(''P20_ROW_ID'', v(''GOTO_WORKSHEET_ROW''));',
'        --htmldb_util.set_session_state(''P20_IR_ID'', :P2_ID);',
'        --htmldb_util.set_session_state(''P20_DATA_GRID_ID'', :P2_WEBSHEET_ID);',
'        --:CURRENT_WORKSHEET_ROW := :GOTO_WORKSHEET_ROW;',
'        --:P20_ROW_ID := :GOTO_WORKSHEET_ROW;',
'        --:P20_IR_ID := :P2_ID;',
'        --:P20_DATA_GRID_ID := :P2_WEBSHEET_ID; ',
'        -- Redraw the form, with the new row''s details.',
'        sys.htp.prn(''<div id="apexir_WORKSHEET_REGION" class="apex_worksheet">'');',
'        sys.htp.prn(''<div id="apexir_DETAIL" class="detail">'');        ',
'        wwv_flow_ws_form.show (',
'            p_ws_app_id            => :WS_APP_ID,',
'        	p_worksheet_id         => :P2_ID,',
'        	p_data_grid_id         => :P2_WEBSHEET_ID,',
'        	p_session              => :APP_SESSION,',
'        	p_app_user             => :APP_USER,',
'        	p_row_id               => v(''CURRENT_WORKSHEET_ROW''),         ',
'        	p_base_report_id       => :RPT_ID,',
'            p_partial_page_refresh => true,',
'            p_last_page_id         => :P20_LAST_PAGE_ID,',
'            p_last_section_id      => :P20_LAST_SECTION_ID);',
'        sys.htp.prn(''</div></div>'');',
'    else',
'        if l_validation_count = 1 then',
'            l_validation_title := wwv_flow_lang.system_message(''FLOW.SINGLE_VALIDATION_ERROR'');',
'        else',
'            l_validation_title := wwv_flow_lang.system_message(''FLOW.VALIDATION_ERROR'', l_validation_count);',
'        end if;',
'        l_validation_error := l_validation_title || ''<ul class="htmldbUlErr">'' || l_validation_error || ''</ul>'';',
'        sys.htp.prn(''error|'' || l_validation_error);',
'    end if;',
'      ',
'exception',
'    when others then',
'        sys.htp.prn(''error|'' || wwv_flow_escape.html(sqlerrm));',
'end;'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_process_comment=>'This application process is used to re-load single row detail view data with validation message from page 20.'
);
end;
/
prompt --application/shared_components/logic/application_processes/websheet_detail
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(2776923488356345.4905)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'websheet_detail'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_widget_action           varchar2(32767) := upper(wwv_flow.g_widget_action);',
'  l_widget_action_mod       varchar2(32767) := wwv_flow.g_widget_action_mod;',
'  l_validation_error        varchar2(32767) := null;',
'begin  ',
'  if l_widget_action = ''NOTE_SAVE'' then      ',
'      wwv_flow_ws_api.add_note (',
'        p_ws_app_id         => :WS_APP_ID,',
'        p_websheet_id       => :P2_WEBSHEET_ID,',
'        p_row_id            => :CURRENT_WORKSHEET_ROW,',
'        p_note_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NOTE_ID''),',
'        p_component_level   => ''ROW'',',
'        p_content           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NOTES''),',
'        p_validation_error  => l_validation_error',
'        );',
'  elsif l_widget_action = ''NOTE_DELETE'' then',
'      wwv_flow_ws_api.delete_note ( ',
'        p_note_id   => l_widget_action_mod);',
'  elsif l_widget_action = ''COLUMN_PROPERTIES_SAVE'' then      ',
'      wwv_flow_ws_api.save_column_properties (',
'        p_worksheet_id      => :P2_ID,',
'        p_websheet_id       => :P2_WEBSHEET_ID,',
'        p_app_user          => :APP_USER,',
'        p_db_column_name    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'        p_display_order     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_SEQUENCE''),',
'        p_group_id          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID''),       ',
'        p_display_as        => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_AS''),',
'        p_label             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_LABEL''),',
'        p_format_mask       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_FORMAT_MASK''),        ',
'        p_value_required    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REQUIRED''),        ',
'        p_heading_alignment => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_HEADING_ALIGNMENT''),',
'        p_column_alignment  => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_ALIGNMENT''),        ',
'        p_lov_id            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV''),',
'        p_lov_name          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'        p_lov_entries       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),        ',
'        p_default_type      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TYPE''),',
'        p_default_text      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TEXT''),        ',
'        p_width             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_WIDTH''),',
'        p_max_width         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_MAX_LENGTH''),',
'        p_height            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_HEIGHT''),',
'        p_help_text         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_HELP_TEXT''),',
'        p_validation_error  => l_validation_error',
'        );',
'  elsif l_widget_action = ''LINK_SAVE'' then',
'      wwv_flow_ws_api.add_link (',
'        p_ws_app_id         => :WS_APP_ID,',
'        p_websheet_id       => :P2_WEBSHEET_ID,          ',
'        p_row_id            => :CURRENT_WORKSHEET_ROW,',
'        p_component_level   => ''ROW'',',
'        p_link_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LINK_ID''),',
'        p_link_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LINK_NAME''), ',
'        p_url               => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_URL''),',
'        p_validation_error  => l_validation_error',
'        );',
'  elsif l_widget_action = ''LINK_DELETE'' then',
'        wwv_flow_ws_api.delete_link ( ',
'            p_link_id   => l_widget_action_mod);',
'',
'  elsif l_widget_action = ''TAG_SAVE'' then',
'    wwv_flow_ws_api.add_tags (    ',
'        p_ws_app_id       => :WS_APP_ID,            ',
'        p_websheet_id     => :P2_WEBSHEET_ID,',
'        p_row_id          => :CURRENT_WORKSHEET_ROW,',
'        p_component_level => ''ROW'',',
'        p_tag             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_TAGS'')); ',
'  elsif l_widget_action = ''TAG_DELETE'' then',
'        wwv_flow_ws_api.delete_tag (',
'            p_websheet_id  => :P2_WEBSHEET_ID,',
'            p_row_id       => :CURRENT_WORKSHEET_ROW,',
'            p_tag_id       => l_widget_action_mod);',
'  elsif l_widget_action = ''ATTACHMENT_DELETE'' then',
'        wwv_flow_ws_attachment.delete_doc ( ',
'            p_doc_id   => l_widget_action_mod);',
'  elsif l_widget_action = ''LOV_DELETE'' then',
'    wwv_flow_ws_api.delete_lov (',
'        p_worksheet_id     => :P2_ID,',
'        p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ID''),  ',
'        p_validation_error => l_validation_error',
'        );',
'  elsif l_widget_action = ''LOV_SAVE'' then',
'     wwv_flow_ws_api.save_lov (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ID''),',
'         p_lov_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'         p_lov_entries      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),  ',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''VALIDATION_SAVE'' then',
'     wwv_flow_ws_api.save_column_validation (',
'         p_ws_app_id        => :WS_APP_ID,',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_validation_id    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_ID''),',
'         p_validation_level => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_LEVEL''),',
'         p_name             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_NAME''),',
'         p_seq              => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_SEQUENCE''),',
'         p_type             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_TYPE''),',
'         p_expr1            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'         p_expr2            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION''),',
'         p_error_message    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ERROR_MESSAGE''),',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''VALIDATION_DELETE'' then',
'     wwv_flow_ws_api.delete_column_validation (',
'         p_worksheet_id     => :P2_ID,',
'         p_validation_id    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_ID'')         ',
'         );',
'  elsif l_widget_action = ''COLUMN_GROUPS_SAVE'' then',
'     wwv_flow_ws_api.save_column_group (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_group_id         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID''),',
'         p_seq              => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_SEQUENCE''),',
'         p_group_name       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NAME''),',
'         p_description      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DESCRIPTION''),         ',
'         p_columns          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_SHUTTLE_RIGHT''),',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''COLUMN_GROUPS_DELETE'' then',
'     wwv_flow_ws_api.delete_column_group (',
'         p_worksheet_id     => :P2_ID,',
'         p_group_id         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID'')',
'         );',
'  -- cbcho',
'  elsif l_widget_action = ''COLUMN_ADD'' then',
'     wwv_flow_ws_api.add_column (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_report_id        => :RPT_ID,',
'         p_app_user         => :APP_USER,',
'         p_column_name      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_NAME''),',
'         p_group_id         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID''),',
'         p_column_type      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_TYPE''),',
'         p_display_as       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_AS''),',
'         p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV''),',
'         p_value_required   => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REQUIRED''),',
'         p_default_type     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TYPE''),',
'         p_default_text     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TEXT''),',
'         p_lov_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'         p_lov_entries      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),',
'         p_validation_error => l_validation_error',
'         ); ',
'  elsif l_widget_action = ''COLUMN_REMOVE'' then',
'     wwv_flow_ws_api.remove_column (',
'         p_worksheet_id     => :P2_ID,',
'         p_columns          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'         p_confirm          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_CONFIRM''),      ',
'         p_validation_error => l_validation_error',
'         );',
'  end if;',
'',
'  if l_validation_error is null then',
'      sys.htp.prn(''true'');      ',
'  else',
'      sys.htp.prn(l_validation_error);      ',
'  end if;',
'exception when others then',
'  sys.htp.prn(''error ''||wwv_flow_escape.html(sqlerrm));',
'end;'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
);
end;
/
prompt --application/shared_components/logic/application_processes/dialog
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(3291701954237236.4905)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'DIALOG'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_dialog.ondemand_dialog (',
'    p_websheet_id    => :P2_WEBSHEET_IT,',
'    p_worksheet_id   => :P2_ID,',
'    p_base_report_id => :RPT_ID,',
'    p_row_id         => :CURRENT_WORKSHEET_ROW );'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
);
end;
/
prompt --application/shared_components/logic/application_processes/cell
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(37132405811210809.4905)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'CELL'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_ACTION			varchar2(32767);',
'    l_ROW				varchar2(32767);',
'    l_COLUMN			varchar2(32767);',
'    l_VALUE				varchar2(32767);',
'    l_CHANGE			varchar2(32767);',
'    l_validation_error	varchar2(32767) := null;',
'begin',
'    l_ROW       := wwv_flow_ws_api.get_item_value(p_item_name => ''ROW'');',
'    l_COLUMN    := wwv_flow_ws_api.get_item_value(p_item_name => ''COLUMN'');',
'    l_VALUE     := wwv_flow_ws_api.get_item_value(p_item_name => ''VALUE'');',
'    l_CHANGE    := wwv_flow_ws_api.get_item_value(p_item_name => ''CHANGE'');',
'    l_ACTION    := wwv_flow_ws_api.get_item_value(p_item_name => ''ACTION'');    ',
'    if l_ACTION = ''SAVE'' then                       ',
'    	wwv_flow_ws_api.update_cell( ',
'            p_worksheet_id     => :P2_ID,',
'    	   p_websheet_id      => :P2_WEBSHEET_ID, ',
'    	   p_row_id           => l_ROW , ',
'    	   p_column_name      => l_COLUMN, ',
'    	   p_new_value        => l_VALUE,',
'    	   p_change_count     => l_CHANGE,',
'    	   p_validation_error => l_validation_error);',
'     else ',
'    	null;',
'     end if;',
'    if l_validation_error is null then    ',
'        sys.htp.prn(''true'');',
'    else',
'        sys.htp.prn(l_validation_error);',
'    end if;',
'exception when others then',
'    sys.htp.prn(wwv_flow_escape.html(substr(sqlerrm,instr(sqlerrm,''ORA-'',-1))));',
'end;'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
);
end;
/
prompt --application/shared_components/logic/application_processes/get_item_help
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(452245511492078992.4905)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'GET_ITEM_HELP'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_form.show_column_popup (',
'    p_db_column_name => wwv_flow_ws_api.get_item_value(p_item_name => ''COLUMN_NAME''),',
'    p_workspace_id   => to_number(:WORKSPACE_ID),',
'    p_worksheet_id   => to_number(:P2_ID));'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
);
end;
/
prompt --application/shared_components/logic/application_processes/get_dtfmt
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(460600501716774062.4905)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'get_dtFmt'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_COLUMN			varchar2(32767);',
'    l_DATE                      varchar2(32767);',
'    l_app_date_format   varchar2(4000);',
'    l_format_mask       varchar2(4000);',
'    l_json_return           varchar2(32767);',
'begin',
'    l_COLUMN    := wwv_flow_ws_api.get_item_value(p_item_name => ''COLUMN'');',
'    l_DATE      := wwv_flow_ws_api.get_item_value(p_item_name => ''DATE'');',
'',
'    l_json_return := wwv_flow_ws_api.inline_date_picker_options(',
'        p_worksheet_id => :P2_ID,',
'        p_date         => l_DATE,',
'        p_column       => l_COLUMN );',
'',
'',
'    sys.htp.prn(l_json_return);',
'',
'end;'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
);
end;
/
prompt --application/shared_components/logic/application_processes/get_lov_json
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(615062144451949851.4905)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'GET_LOV_JSON'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_worksheet_id varchar2(32767) := wwv_flow.g_x01;  ',
'    l_single_id    varchar2(32767) := wwv_flow_worksheet_ajax.clean_column_name(wwv_flow.g_x02);',
'begin',
'    wwv_flow_ws_api.get_lov_json(',
'        p_worksheet_id   => l_worksheet_id,',
'        p_db_column_name => l_single_id );',
'end;        '))
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(24477906500589587.4905)
,p_name=>'AJAX_WS_ACTION'
,p_protection_level=>'N'
,p_item_comment=>'FILTER,SEARCH,SORT'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(24506014409837883.4905)
,p_name=>'AJAX_WS_COLUMN'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(24505231939833457.4905)
,p_name=>'AJAX_WS_FILTER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(24503818779829694.4905)
,p_name=>'AJAX_WS_FILTER_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(25407924412215582.4905)
,p_name=>'AJAX_WS_NUM'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(187889401560281661.4905)
,p_name=>'APP_NAME'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(406291700131840546.4905)
,p_name=>'BUILDER_SESSION_ID'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(179652013865859868.4905)
,p_name=>'CURRENT_WORKSHEET_ROW'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(161139305537061829.4905)
,p_name=>'F4900_LAST_VIEW'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(617034601471718123.4905)
,p_name=>'F4900_LOGIN_URL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(471216109613872357.4905)
,p_name=>'F4900_LOGO'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(154784210014091542.4905)
,p_name=>'FSP_AFTER_LOGIN_URL'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(461331700195331599.4905)
,p_name=>'GOTO_WORKSHEET_ROW'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(458560827333195349.4905)
,p_name=>'HOME_PAGE_ID'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185115316114835976.4905)
,p_name=>'IR_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
,p_item_comment=>'This application item is used to run Websheet reports and Data Grid on page 3010.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(7934826114498652.4905)
,p_name=>'ITEM_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(176645422859500226.4905)
,p_name=>'OWNER_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(179806310494315818.4905)
,p_name=>'RPT_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185298032482647725.4905)
,p_name=>'RUN_LINK'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(20015114768535427.4905)
,p_name=>'SECTION_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(172130707665449025.4905)
,p_name=>'SHOWNAV'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(7965920927622901.4905)
,p_name=>'TEMPORARY_ACTION'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(23088531657485941.4905)
,p_name=>'TEMPORARY_FILTER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(7939330981651397.4905)
,p_name=>'TEMPORARY_ITEM'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using AJAX it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(23801903782632819.4905)
,p_name=>'WORKSHEET_FILTER_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(78919021160643130.4905)
,p_name=>'WORKSHEET_NAME'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185116129620839895.4905)
,p_name=>'WS_APP_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
,p_item_comment=>'Websheet application ID'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185115622347837829.4905)
,p_name=>'WS_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
,p_item_comment=>'This application item is used to run Websheet reports and Data Grid on page 3010.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(451945309573247981.4905)
,p_name=>'WS_SETUP_VALID'
,p_protection_level=>'I'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(471216708359881476.4905)
,p_computation_sequence=>100
,p_computation_item=>'F4900_LOGO'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'return wwv_flow_ws_api.get_logo(p_ws_app_id=>:WS_APP_ID,p_security_group_id=>:flow_security_group_id);'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(458561209110199522.4905)
,p_computation_sequence=>10
,p_computation_item=>'HOME_PAGE_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select HOME_PAGE_ID',
'  from WWV_FLOW_WS_APPLICATIONS',
' where id = :WS_APP_ID',
'and security_group_id = :WORKSPACE_ID'))
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(617038105476908535.4905)
,p_computation_sequence=>10
,p_computation_item=>'F4900_LOGIN_URL'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'return wwv_flow_ws_webpage.get_login_url(:WS_APP_ID);'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(172131313205450686.4905)
,p_computation_sequence=>10
,p_computation_item=>'SHOWNAV'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'Y'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(406460806842851924.4905)
,p_computation_sequence=>10
,p_computation_item=>'BUILDER_SESSION_ID'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'return wwv_flow_security.get_builder_session_id;'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/accessibility_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(680996401756072029.4905)
,p_lov_name=>'ACCESSIBILITY_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(680996401756072029.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(680996730973072031.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Leitor de Tela'
,p_lov_return_value=>'SCREEN_READER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(680996901097072032.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Contraste Elevado'
,p_lov_return_value=>'HIGH_CONTRAST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/acl_priv
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4183515898494342.4905)
,p_lov_name=>'ACL_PRIV'
,p_lov_query=>'.'||wwv_flow_api.id(4183515898494342.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4183804118494346.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Exibir e Editar'
,p_lov_return_value=>'EDIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4184010247494348.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Exibir Apenas'
,p_lov_return_value=>'VIEW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/alignment_l_c_r
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187517603302080409.4905)
,p_lov_name=>'ALIGNMENT_L_C_R'
,p_lov_query=>'.'||wwv_flow_api.id(187517603302080409.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187517811651080411.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'esquerda'
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187518005825080412.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'centralizado'
,p_lov_return_value=>'CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187518229295080412.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'direita'
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/all_or_selected_or_null_row_domain
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6200201590860952.4905)
,p_lov_name=>'ALL OR SELECTED OR NULL (ROW DOMAIN)'
,p_lov_query=>'.'||wwv_flow_api.id(6200201590860952.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6200409579860953.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Todas as Linhas'
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6200608372860954.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Linhas Selecionadas'
,p_lov_return_value=>'SELECTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20082523608431635.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Linhas Nulas'
,p_lov_return_value=>'NULL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/annotation_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(251379008493597083.4905)
,p_lov_name=>'ANNOTATION TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(251379008493597083.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251379209365597089.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arquivos'
,p_lov_return_value=>'ATTACHMENT'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:4020:&SESSION.:::4020:P4020_ANNOTATION_TYPE:ATTACHMENT"><img src="#IMAGE_PREFIX#menu/wiz_multiple_140x90.gif" height="90" widt'
||'h="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251379423628597095.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Observa\00E7\00F5es')
,p_lov_return_value=>'NOTE'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:4020:&SESSION.:::4020:P4020_ANNOTATION_TYPE:NOTE"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" height="90" '
||'width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251379620302597095.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Tag'
,p_lov_return_value=>'TAG'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:4020:&SESSION.:::4020:P4020_ANNOTATION_TYPE"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" height="90" width'
||'="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(631189019655476474.4905)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Links'
,p_lov_return_value=>'LINK'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'906'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_name_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(172965416124494830.4905)
,p_lov_name=>'APPLICATION NAME RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'from   wwv_flows f',
'where  ',
'       security_group_id = :flow_security_group_id and',
'       not exists (',
'       select null from wwv_flow_language_map',
'       where translation_flow_id = f.id and ',
'         security_group_id = :flow_security_group_id) and',
'       (',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :app_user and ',
'             flow_id is null and ',
'             security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :app_user and ',
'             flow_id = f.id and ',
'             security_group_id = :flow_security_group_id ))'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/attachment_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177785329944899135.4905)
,p_lov_name=>'ATTACHMENT OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(177785329944899135.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177785525202899136.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Mostrar no relat\00F3rio com \00CDcone e Nome')
,p_lov_return_value=>'BOTH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177785716327899136.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Mostrar no relat\00F3rio com nome apenas')
,p_lov_return_value=>'NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177785901379899136.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('Mostrar com \00CDcone Apenas')
,p_lov_return_value=>'ICON'
);
end;
/
prompt --application/shared_components/user_interface/lovs/blob_content_disposition
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(382939512009208407.4905)
,p_lov_name=>'BLOB_CONTENT_DISPOSITION'
,p_lov_query=>'.'||wwv_flow_api.id(382939512009208407.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(382939815594208407.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Em Linha'
,p_lov_return_value=>'inline'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(382940022425208407.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Anexo'
,p_lov_return_value=>'attachment'
);
end;
/
prompt --application/shared_components/user_interface/lovs/blob_format_mask
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(382915819151201016.4905)
,p_lov_name=>'BLOB_FORMAT_MASK'
,p_lov_query=>'.'||wwv_flow_api.id(382915819151201016.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(382916131553201016.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'DOWNLOAD'
,p_lov_return_value=>'DOWNLOAD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(382916305818201016.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'IMAGE'
,p_lov_return_value=>'IMAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_on
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(22967915270872919.4905)
,p_lov_name=>'BREAK ON'
,p_lov_query=>'.'||wwv_flow_api.id(22967915270872919.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24136313336017502.4905)
,p_lov_disp_sequence=>0
,p_lov_disp_value=>'Sem Quebras'
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22968117650872920.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Coluna 1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22968313303872920.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Colunas 1 e 2'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22968508747872920.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Colunas 1, 2 e 3'
,p_lov_return_value=>'3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_functions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(261396928274568408.4905)
,p_lov_name=>'CHART FUNCTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(261396928274568408.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261397126573568409.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Soma'
,p_lov_return_value=>'SUM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261397325621568409.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('M\00E9dia')
,p_lov_return_value=>'AVG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261397511265568409.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('M\00EDnimo')
,p_lov_return_value=>'MIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261397717213568409.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('M\00E1ximo')
,p_lov_return_value=>'MAX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261397932564568409.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Contagem'
,p_lov_return_value=>'COUNT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_sort
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(261446703779618102.4905)
,p_lov_name=>'CHART SORT'
,p_lov_query=>'.'||wwv_flow_api.id(261446703779618102.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261446917693618102.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Padr\00E3o')
,p_lov_return_value=>'DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261447112282618103.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Valor - Crescente'
,p_lov_return_value=>'VALUE_ASC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261447310262618103.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Valor - Decrescente'
,p_lov_return_value=>'VALUE_DESC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261447525538618103.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Label - Crescente'
,p_lov_return_value=>'LABEL_ASC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261447704881618103.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Label - Decrescente'
,p_lov_return_value=>'LABEL_DESC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_3d
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(430988702419464894.4905)
,p_lov_name=>'CHART_3D'
,p_lov_query=>'.'||wwv_flow_api.id(430988702419464894.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(430988921586464895.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Ativar 3D'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_orientation
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(107038275478210797.4905)
,p_lov_name=>'CHART_ORIENTATION'
,p_lov_query=>'.'||wwv_flow_api.id(107038275478210797.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(107038518670210798.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vertical'
,p_lov_return_value=>'vertical'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(107038941666210804.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Horizontal'
,p_lov_return_value=>'horizontal'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(259453605523899856.4905)
,p_lov_name=>'CHART_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(259453605523899856.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(259453813697899860.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Barras'
,p_lov_return_value=>'bar'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=4900:740:&SESSION.:::740:P710_CHART_TYPE:bar"><img src="#IMAGE_PREFIX#ws/ws-column-chart.png" alt="#DISPLAY_VALUE#" width="128" height='
||'"128" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(259454024992899863.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Linha com \00C1rea')
,p_lov_return_value=>'lineWithArea'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=4900:740:&SESSION.:::740:P710_CHART_TYPE:lineWithArea"><img src="#IMAGE_PREFIX#ws/ws-line-area-chart.png" alt="#DISPLAY_VALUE#" width="'
||'128" height="128" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(259454217060899863.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Pizza'
,p_lov_return_value=>'pie'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=4900:740:&SESSION.:::740:P710_CHART_TYPE:pie"><img src="#IMAGE_PREFIX#ws/ws-pie-chart.png" alt="#DISPLAY_VALUE#" width="128" height="12'
||'8" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(259454601928899863.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Linha'
,p_lov_return_value=>'line'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=4900:740:&SESSION.:::740:P710_CHART_TYPE:line"><img src="#IMAGE_PREFIX#ws/ws-line-chart.png" alt="#DISPLAY_VALUE#" width="128" height="'
||'128" /></a></td><td>&nbsp;</td></tr></table>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_groups
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(169740222151305876.4905)
,p_lov_name=>'COLUMN GROUPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select NAME display_value, ID return_value ',
'from WWV_FLOW_WORKSHEET_COL_GROUPS',
'where worksheet_id = :p2_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_label_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(157556708734983770.4905)
,p_lov_name=>'COLUMN LABEL RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select COLUMN_LABEL display_value, ID return_value ',
'from WWV_FLOW_WORKSHEET_COLUMNS',
'where worksheet_id = :p2_id',
'order by DISPLAY_ORDER, upper(column_label)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_filter_operators
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(178773405987392681.4905)
,p_lov_name=>'COLUMN_FILTER_OPERATORS'
,p_lov_query=>'.'||wwv_flow_api.id(178773405987392681.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178773624786392683.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'='
,p_lov_return_value=>'='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178773816619392689.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'!='
,p_lov_return_value=>'!='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178774029915392689.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'>'
,p_lov_return_value=>'>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178774203147392689.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'>='
,p_lov_return_value=>'>='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178774404844392689.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'<'
,p_lov_return_value=>'<'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178774611401392689.4905)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'<='
,p_lov_return_value=>'<='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178774803359392690.4905)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\00E9 nulo')
,p_lov_return_value=>'is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178775031923392690.4905)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('n\00E3o \00E9 nulo')
,p_lov_return_value=>'is not null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178775213763392690.4905)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'como'
,p_lov_return_value=>'like'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178775414742392690.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('n\00E3o \00E9 semelhante')
,p_lov_return_value=>'not like'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178775626341392690.4905)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'em'
,p_lov_return_value=>'in'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178775816853392690.4905)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('n\00E3o contido em')
,p_lov_return_value=>'not in'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178776030779392690.4905)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('cont\00E9m')
,p_lov_return_value=>'contains'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178776226760392690.4905)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('n\00E3o cont\00E9m')
,p_lov_return_value=>'does not contain'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178776415143392690.4905)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'regexp_like'
,p_lov_return_value=>'regexp_like'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178778229882399595.4905)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'entre'
,p_lov_return_value=>'between'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178779911313403739.4905)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('est\00E1 no \00FAltimo')
,p_lov_return_value=>'is in the last'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178780215815404960.4905)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('n\00E3o est\00E1 no \00FAltimo')
,p_lov_return_value=>'is not in the last'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178780518932405861.4905)
,p_lov_disp_sequence=>28
,p_lov_disp_value=>unistr('est\00E1 no pr\00F3ximo')
,p_lov_return_value=>'is in the next'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178780722741406996.4905)
,p_lov_disp_sequence=>38
,p_lov_disp_value=>unistr('n\00E3o est\00E1 no pr\00F3ximo')
,p_lov_return_value=>'is not in the next'
);
end;
/
prompt --application/shared_components/user_interface/lovs/comparison_expressions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(157548605355963845.4905)
,p_lov_name=>'COMPARISON EXPRESSIONS'
,p_lov_query=>'.'||wwv_flow_api.id(157548605355963845.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157548815917963845.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'='
,p_lov_return_value=>'='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157549008133963845.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'>'
,p_lov_return_value=>'>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177923106066093754.4905)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'>='
,p_lov_return_value=>'>='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157549227534963845.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'<'
,p_lov_return_value=>'<'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177923812646095626.4905)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>'<='
,p_lov_return_value=>'<='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157549604153963845.4905)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'como'
,p_lov_return_value=>'LIKE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(179793328389112795.4905)
,p_lov_disp_sequence=>51
,p_lov_disp_value=>unistr('N\00E3o \00E9 Semelhante')
,p_lov_return_value=>'not like '
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157549823989963846.4905)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'!='
,p_lov_return_value=>'!='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6035512141000243.4905)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\00E9 nulo')
,p_lov_return_value=>'is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6035915258001184.4905)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('n\00E3o \00E9 nulo')
,p_lov_return_value=>'is not null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24709324557666429.4905)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'em'
,p_lov_return_value=>'in'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24709626635667023.4905)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('n\00E3o contido em')
,p_lov_return_value=>'not in'
);
end;
/
prompt --application/shared_components/user_interface/lovs/component_level
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(455012825948829772.4905)
,p_lov_name=>'COMPONENT_LEVEL'
,p_lov_query=>'.'||wwv_flow_api.id(455012825948829772.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(455013000682829776.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('P\00E1gina')
,p_lov_return_value=>'WEBPAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(455013212503829779.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Linha'
,p_lov_return_value=>'ROW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/control_break_groups
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(22978927746952171.4905)
,p_lov_name=>'CONTROL BREAK GROUPS'
,p_lov_query=>'.'||wwv_flow_api.id(22978927746952171.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22979110471952172.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Todos os Grupos de Interrup\00E7\00E3o de Controle')
,p_lov_return_value=>'ALL_GROUPS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22979300855952172.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Um Grupo de Interrup\00E7\00E3o de Controle')
,p_lov_return_value=>'ONE_GROUP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_data_or_report
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(173236520362944199.4905)
,p_lov_name=>'CREATE DATA OR REPORT'
,p_lov_query=>'.'||wwv_flow_api.id(173236520362944199.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173236715134944199.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Grade de Dados'
,p_lov_return_value=>'DATA'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:205:&SESSION.:::205"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" height="90" width="140" alt="#DISPLAY_VAL'
||'UE#" class="htmldbGreenIcons" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181301630402676517.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('Relat\00F3rio')
,p_lov_return_value=>'REPORT'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:1310:&SESSION.:::1310,1320"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" height="90" width="140" alt="#DISP'
||'LAY_VALUE#" class="htmldbGreenIcons" /></a></td><td>&nbsp;</td></tr></table>'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_security.current_user_is_not_reader',
'and wwv_flow_ws_security.sql_enabled(:WS_APP_ID)',
'and wwv_flow_ws_security.sql_enabled_inst()'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_text_section_method
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(18725515716010637.4905)
,p_lov_name=>'CREATE TEXT SECTION METHOD'
,p_lov_query=>'.'||wwv_flow_api.id(18725515716010637.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(18725807766010639.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Criar se\00E7\00E3o de texto \00FAnico')
,p_lov_return_value=>'NORMAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(18726004246010640.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Criar se\00E7\00E3o de v\00E1rios textos da Planilha')
,p_lov_return_value=>'SPREADSHEET'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_worksheet_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2960208403984068.4905)
,p_lov_name=>'CREATE WORKSHEET OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(2960208403984068.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2960523083984070.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Totalmente Novo(a)'
,p_lov_return_value=>'SCRATCH'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:201:&SESSION.:::201,WS_WIZ_COLUMNS"><img src="#IMAGE_PREFIX#ws/ws-from-scratch.png" height="128" width="128" alt="#DISPLAY_VAL'
||'UE#" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2960708902984070.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Copiar e Colar'
,p_lov_return_value=>'CUTANDPASTE'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:206:&SESSION.:::206,CLOB_CONTENT,RP"><img src="#IMAGE_PREFIX#ws/ws-copy-paste.png" height="128" width="128" alt="#DISPLAY_VALU'
||'E#" /></a></td><td>&nbsp;</td></tr></table>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_ws_auth_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174618728240220381.4905)
,p_lov_name=>'CREATE_WS_AUTH_OPTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, v from (',
'select ',
'  :product_name||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/admin_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d ,''HTML DB'' v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.NO_AUTH'')||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/opendoor_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DATABASE'' v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'')||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/dbauth_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DBACCOUNT'' v from dual)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_grid
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(179694201378826303.4905)
,p_lov_name=>'DATA GRID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name, id',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id',
'and websheet_type = ''DATA'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_section_style
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(746262913082105905.4905)
,p_lov_name=>'DATA SECTION STYLE'
,p_lov_query=>'.'||wwv_flow_api.id(746262913082105905.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(746263201593105907.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Estilo 1'
,p_lov_return_value=>'1'
,p_lov_template=>'<img src="#IMAGE_PREFIX#ws/report_style_1.gif" height="48" width="128" alt="#DISPLAY_VALUE#" class="radioGroupImage"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(746263432526105909.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Estilo 2'
,p_lov_return_value=>'2'
,p_lov_template=>'<img src="#IMAGE_PREFIX#ws/report_style_2.gif" height="48" width="128" alt="#DISPLAY_VALUE#" class="radioGroupImage"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(746263605381105909.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Estilo 3'
,p_lov_return_value=>'3'
,p_lov_template=>'<img src="#IMAGE_PREFIX#ws/report_style_3.gif" height="48" width="128" alt="#DISPLAY_VALUE#" class="radioGroupImage"/>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_grid_returning_worksheet_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(745648018052041064.4905)
,p_lov_name=>'DATA_GRID_RETURNING_WORKSHEET_ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.websheet_name d, w.id r',
'from wwv_flow_ws_websheet_attr a, wwv_flow_worksheets w',
'where a.worksheet_id = w.id',
'and a.ws_app_id = :ws_app_id',
'and a.security_group_id = :flow_security_group_id',
'and a.websheet_type = ''DATA'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_with_user_saved_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(497241820310060978.4905)
,p_lov_name=>'DATA_WITH_USER_SAVED_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ws.websheet_name d, ws.websheet_name r',
'from wwv_flow_worksheets i,',
'wwv_flow_worksheet_rpts r,',
'wwv_flow_ws_applications a,',
'wwv_flow_ws_websheet_attr ws',
'where a.id = ws.ws_app_id',
'and ws.worksheet_id = i.id',
'and r.worksheet_id = i.id',
'and r.websheet_id is not null',
'and r.security_group_id = :flow_security_group_id',
'and a.id = :ws_app_id',
'and r.application_user = :app_user',
'and r.session_id is null',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/date_format_lov
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(460140315153255042.4905)
,p_lov_name=>'DATE_FORMAT_LOV'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'  from wwv_flow_format_masks',
' where t=''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_rows
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(161072331491917913.4905)
,p_lov_name=>'DISPLAY ROWS'
,p_lov_query=>'.'||wwv_flow_api.id(161072331491917913.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161075705996920049.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161076108073920614.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161072510215917914.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161072713820917914.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161072930490917914.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161073118910917914.4905)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161073314283917914.4905)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161073520539917914.4905)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161073726945917914.4905)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161073905737917914.4905)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161074106700917914.4905)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161074329336917914.4905)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161074529716917914.4905)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177272802329654940.4905)
,p_lov_disp_sequence=>9999
,p_lov_disp_value=>'Tudo'
,p_lov_return_value=>'100000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/expression_types_column_value
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(175787711198660520.4905)
,p_lov_name=>'EXPRESSION TYPES (COLUMN/VALUE)'
,p_lov_query=>'.'||wwv_flow_api.id(175787711198660520.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175788023327660521.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Valor'
,p_lov_return_value=>'VALUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175788232491660521.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Coluna'
,p_lov_return_value=>'COLUMN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_component
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(945870019196474793.4905)
,p_lov_name=>'FEEDBACK_COMPONENT'
,p_lov_query=>'.'||wwv_flow_api.id(945870019196474793.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945870326932474795.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Grade de dados'
,p_lov_return_value=>'Datagrid'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945870517003474796.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('P\00E1gina')
,p_lov_return_value=>'Page'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945870730487474797.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Controle de Acesso'
,p_lov_return_value=>'Access Control'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945870930916474797.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('Relat\00F3rio')
,p_lov_return_value=>'Report'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945871101913474797.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('Sintaxe de Marca\00E7\00E3o')
,p_lov_return_value=>'Markup Syntax'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945871316354474797.4905)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Outro'
,p_lov_return_value=>'Other'
);
end;
/
prompt --application/shared_components/user_interface/lovs/first_row_contains_column_headings
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(799517811838484369.4905)
,p_lov_name=>'FIRST_ROW_CONTAINS_COLUMN_HEADINGS'
,p_lov_query=>'.'||wwv_flow_api.id(799517811838484369.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(799518019833484371.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('A Primeira Linha Cont\00E9m Cabe\00E7alhos de Colunas')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187514328189059218.4905)
,p_lov_name=>'FORMAT MASK DYNAMIC'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'from wwv_flow_format_masks'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/hr_column_names
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(162817307492916433.4905)
,p_lov_name=>'HR COLUMN NAMES'
,p_lov_query=>'.'||wwv_flow_api.id(162817307492916433.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162817620426916433.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Nome'
,p_lov_return_value=>'FIRST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162817815634916433.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Sobrenome'
,p_lov_return_value=>'LAST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162818030292916433.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Nome Completo'
,p_lov_return_value=>'FULL_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162818210247916433.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('Endere\00E7o de E-mail')
,p_lov_return_value=>'EMAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/hr_column_names_for_seeding
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(166804518636616614.4905)
,p_lov_name=>'HR COLUMN NAMES (FOR SEEDING)'
,p_lov_query=>'.'||wwv_flow_api.id(166804518636616614.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166804814185616615.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Nome'
,p_lov_return_value=>'FIRST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166805014333616615.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Sobrenome'
,p_lov_return_value=>'LAST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166805200851616615.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Endere\00E7o de E-mail')
,p_lov_return_value=>'EMAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166805429286616615.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Nome para Encaminhamento'
,p_lov_return_value=>'FORWARD_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166807720152626504.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Nome Inverso'
,p_lov_return_value=>'REVERSE_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166808026385628340.4905)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'GUID'
,p_lov_return_value=>'USERID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166808400544630345.4905)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('T\00EDtulo Arbitr\00E1rio')
,p_lov_return_value=>'TITLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166808808855632713.4905)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Centro de Custo'
,p_lov_return_value=>'COST_CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166809111972633632.4905)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('Organiza\00E7\00E3o')
,p_lov_return_value=>'ORGANIZATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166809515781634745.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Telefone Comercial'
,p_lov_return_value=>'WORK_PHONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166809820629636090.4905)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('Edif\00EDcio Comercial')
,p_lov_return_value=>'WORK_BUILDING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166810125131637429.4905)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Piso Comercial'
,p_lov_return_value=>'WORK_FLOOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166810430672639004.4905)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('N\00FAmero do Escrit\00F3rio Comercial')
,p_lov_return_value=>'WORK_OFFICE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166810803099640515.4905)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('Endere\00E7o Comercial')
,p_lov_return_value=>'WORK_ADDR1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166811408293641989.4905)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Cidade Comercial'
,p_lov_return_value=>'WORK_CITY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166812011410642946.4905)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Estado Comercial'
,p_lov_return_value=>'WORK_STATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166812416605644416.4905)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'CEP Comercial'
,p_lov_return_value=>'WORK_ZIP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166812722492646170.4905)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('Pa\00EDs Comercial')
,p_lov_return_value=>'WORK_COUNTRY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166813328033647779.4905)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'Subordinados'
,p_lov_return_value=>'DIRECTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166813732188648908.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Total de Subordinados'
,p_lov_return_value=>'TOTAL_REPORTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166814003230649994.4905)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('\00C9 Gerente?')
,p_lov_return_value=>'IS_MANAGER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_languages_locales
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(502587106305037128.4905)
,p_lov_name=>'I18N_LANGUAGES_LOCALES'
,p_reference_id=>107899321117195063.4905
,p_lov_query=>'.'||wwv_flow_api.id(502587106305037128.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699077671048180068.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Azerbaij\00E3o (az)')
,p_lov_return_value=>'az'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699078037978180068.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Afric\00E2ner (af)')
,p_lov_return_value=>'af'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699078405074180068.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (ar)')
,p_lov_return_value=>'ar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699078828289180068.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Arg\00E9lia) (ar-dz)')
,p_lov_return_value=>'ar-dz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699079234537180069.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Barein) (ar-bh)')
,p_lov_return_value=>'ar-bh'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699079606258180069.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Egito) (ar-eg)')
,p_lov_return_value=>'ar-eg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699080050912180069.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Iraque) (ar-iq)')
,p_lov_return_value=>'ar-iq'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699080454215180069.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Jord\00E2nia) (ar-jo)')
,p_lov_return_value=>'ar-jo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699080864791180070.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Kuwait) (ar-kw)')
,p_lov_return_value=>'ar-kw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699081255911180070.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (L\00EDbano) (ar-lb)')
,p_lov_return_value=>'ar-lb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699081603517180070.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (L\00EDbia) (ar-ly)')
,p_lov_return_value=>'ar-ly'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699082008415180070.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Marrocos) (ar-ma)')
,p_lov_return_value=>'ar-ma'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699082459066180070.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Om\00E3) (ar-om)')
,p_lov_return_value=>'ar-om'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699082811282180071.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Catar) (ar-qa)')
,p_lov_return_value=>'ar-qa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699083231940180071.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Ar\00E1bia Saudita) (ar-sa)')
,p_lov_return_value=>'ar-sa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699083518057180071.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (S\00EDria) (ar-sy)')
,p_lov_return_value=>'ar-sy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699083935661180071.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Tun\00EDsia) (ar-tn)')
,p_lov_return_value=>'ar-tn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699084301028180072.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (Emirados \00C1rabes Unidos) (ar-ae)')
,p_lov_return_value=>'ar-ae'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699084726592180072.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1rabe (I\00EAmen) (ar-ye)')
,p_lov_return_value=>'ar-ye'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699085149541180072.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Assam\00EAs (as)')
,p_lov_return_value=>'as'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699085551541180073.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Basco (eu)'
,p_lov_return_value=>'eu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699085941439180073.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bielo-russo (be)'
,p_lov_return_value=>'be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699086317208180073.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bengali (bn)'
,p_lov_return_value=>'bn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699086722772180073.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('B\00FAlgaro (bg)')
,p_lov_return_value=>'bg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699087134419180073.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Catal\00E3o (ca)')
,p_lov_return_value=>'ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699087520210180074.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Chin\00EAs (zh)')
,p_lov_return_value=>'zh'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699087954139180074.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Chin\00EAs (China) (zh-cn)')
,p_lov_return_value=>'zh-cn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699088321602180074.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Chin\00EAs (Hong Kong SAR) (zh-hk)')
,p_lov_return_value=>'zh-hk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699088718989180074.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Chin\00EAs (Macau SAR) (zh-mo)')
,p_lov_return_value=>'zh-mo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699089197590180075.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Chin\00EAs (Cingapura) (zh-sg)')
,p_lov_return_value=>'zh-sg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699089584303180075.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Chin\00EAs (Taiwan) (zh-tw)')
,p_lov_return_value=>'zh-tw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699089965064180075.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Croata (hr)'
,p_lov_return_value=>'hr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699090330404180075.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tcheco (cs)'
,p_lov_return_value=>'cs'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699090719346180076.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Dinamarqu\00EAs (da)')
,p_lov_return_value=>'da'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699091122669180076.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Holand\00EAs (B\00E9lgica) (nj-be)')
,p_lov_return_value=>'nl-be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699091589403180076.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Holand\00EAs (Pa\00EDses Baixos) (nl)')
,p_lov_return_value=>'nl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699091971660180076.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (en)')
,p_lov_return_value=>'en'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699092358936180076.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Austr\00E1lia) (en-au)')
,p_lov_return_value=>'en-au'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699092773809180077.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Belize) (en-bz)')
,p_lov_return_value=>'en-bz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699093124993180077.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Canad\00E1) (en-ca)')
,p_lov_return_value=>'en-ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699093521574180077.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Irlanda) (en-ie)')
,p_lov_return_value=>'en-ie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699093981695180077.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Jamaica) (en-jm)')
,p_lov_return_value=>'en-jm'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699094398450180078.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Nova Zel\00E2ndia) (en-nz)')
,p_lov_return_value=>'en-nz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699094718902180078.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Filipinas) (en-ph)')
,p_lov_return_value=>'en-ph'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699095171931180078.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (\00C1frica do Sul) (en-za)')
,p_lov_return_value=>'en-za'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699095556248180078.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Trinidad) (en-tt)')
,p_lov_return_value=>'en-tt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699095900882180078.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Reino Unido) (en-gb)')
,p_lov_return_value=>'en-gb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699096397022180079.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Estados Unidos) (en-us)')
,p_lov_return_value=>'en-us'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699096756533180079.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs (Zimb\00E1bue) (en-zw)')
,p_lov_return_value=>'en-zw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699097111707180079.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Estoniano (et)'
,p_lov_return_value=>'et'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699097569130180079.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('FYRO - Maced\00F4nio (mk)')
,p_lov_return_value=>'mk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699097901194180080.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Fero\00EAs (fo)')
,p_lov_return_value=>'fo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699098392128180080.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Farsi (fa)'
,p_lov_return_value=>'fa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699098761314180080.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Franc\00EAs (Su\00ED\00E7a) (fr-ch)')
,p_lov_return_value=>'fr-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699099157140180080.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Finland\00EAs (fi)')
,p_lov_return_value=>'fi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699099528056180081.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Franc\00EAs (B\00E9lgica) (fr-be)')
,p_lov_return_value=>'fr-be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699099985670180081.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Franc\00EAs (Canad\00E1) (fr-ca)')
,p_lov_return_value=>'fr-ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699100362011180081.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Franc\00EAs (Fran\00E7a) (fr)')
,p_lov_return_value=>'fr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699100749619180081.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Franc\00EAs (Luxemburgo) (fr-lu)')
,p_lov_return_value=>'fr-lu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699101188548180082.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Franc\00EAs (M\00F4naco) (fr-mc)')
,p_lov_return_value=>'fr-mc'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699101509999180082.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ga\00E9lico (gd)')
,p_lov_return_value=>'gd'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699101965546180082.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Gaul\00EAs (gl)')
,p_lov_return_value=>'gl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699102367955180082.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Alem\00E3o (\00C1ustria) (de-at)')
,p_lov_return_value=>'de-at'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699102767340180083.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Alem\00E3o (Alemanha) (de)')
,p_lov_return_value=>'de'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699103114120180083.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Alem\00E3o (Liechtenstein) (de-li)')
,p_lov_return_value=>'de-li'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699103543063180083.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Alem\00E3o (Luxemburgo) (de-lu)')
,p_lov_return_value=>'de-lu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699103949411180083.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Alem\00E3o (Su\00ED\00E7a) (de-ch)')
,p_lov_return_value=>'de-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699104368944180083.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Grego (el)'
,p_lov_return_value=>'el'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699104710217180084.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Guzerate (gu)'
,p_lov_return_value=>'gu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699105112508180084.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hebraico (he)'
,p_lov_return_value=>'he'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699105550789180084.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hindu (hi)'
,p_lov_return_value=>'hi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699105901185180085.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('H\00FAngaro (hu)')
,p_lov_return_value=>'hu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699106301886180085.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Island\00EAs (is)')
,p_lov_return_value=>'is'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699106757512180085.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Indon\00E9sio (id)')
,p_lov_return_value=>'id'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699107115109180085.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Italiano (It\00E1lia) (it)')
,p_lov_return_value=>'it'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699107521210180086.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Italiano (Su\00ED\00E7a) (it-ch)')
,p_lov_return_value=>'it-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699107936215180086.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Japon\00EAs (ja)')
,p_lov_return_value=>'ja'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699108362538180086.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Canar\00EAs (kn)')
,p_lov_return_value=>'kn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699108709201180086.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cazaque (kk)'
,p_lov_return_value=>'kk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699109156123180086.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Concani (kok)'
,p_lov_return_value=>'kok'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699109579709180087.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Coreano (ko)'
,p_lov_return_value=>'ko'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699109999363180087.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Quirguistan\00EAs (kz)')
,p_lov_return_value=>'kz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699110323574180087.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Let\00E3o (lv)')
,p_lov_return_value=>'lv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699110750109180087.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lituano (lt)'
,p_lov_return_value=>'lt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699111197428180088.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Malaio (Mal\00E1sia) (ms)')
,p_lov_return_value=>'ms'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699111558985180088.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Malaiala (ml)'
,p_lov_return_value=>'ml'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699111988302180088.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Malt\00EAs (mt)')
,p_lov_return_value=>'mt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699112318794180088.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Marati (mr)'
,p_lov_return_value=>'mr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699112751141180088.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Nepal\00EAs (\00CDndia) (ne)')
,p_lov_return_value=>'ne'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699113167827180089.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Noruegu\00EAs (Bokmal) (nb-no)')
,p_lov_return_value=>'nb-no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699113521452180089.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Noruegu\00EAs (Bokmal) (no)')
,p_lov_return_value=>'no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699113935508180089.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Noruegu\00EAs (Nynorsk) (nn-no)')
,p_lov_return_value=>'nn-no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699114353177180089.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ori\00E1 (or)')
,p_lov_return_value=>'or'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699114731122180089.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Polon\00EAs (pl)')
,p_lov_return_value=>'pl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699115176842180090.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Portugu\00EAs (Brasil) (pt-br)')
,p_lov_return_value=>'pt-br'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699115528210180090.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Portugu\00EAs (Portugal) (pt)')
,p_lov_return_value=>'pt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699115900344180090.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Punjabi (pa)'
,p_lov_return_value=>'pa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699116347937180090.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Romeno (ro)'
,p_lov_return_value=>'ro'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699116720955180091.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Russo (ru)'
,p_lov_return_value=>'ru'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699117177554180091.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Russo (Mold\00E1via) (ru-md)')
,p_lov_return_value=>'ru-md'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699117577240180091.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('S\00E9rvio (sr)')
,p_lov_return_value=>'sr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699117988910180091.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Eslovaco (sk)'
,p_lov_return_value=>'sk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699118314040180091.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Esloveno (sl)'
,p_lov_return_value=>'sl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699118753922180092.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Argentina) (es-ar)'
,p_lov_return_value=>'es-ar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699119188393180092.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Espanhol (Bol\00EDvia) (es-bo)')
,p_lov_return_value=>'es-bo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699119581631180092.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Chile) (es-cl)'
,p_lov_return_value=>'es-cl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699119997191180092.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Espanhol (Col\00F4mbia) (es-co)')
,p_lov_return_value=>'es-co'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699120318838180092.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Costa Rica) (es-cr)'
,p_lov_return_value=>'es-cr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699120709109180093.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Espanhol (Rep\00FAblica Dominicana) (es-do)')
,p_lov_return_value=>'es-do'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699121134727180093.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Equador) (es-ec)'
,p_lov_return_value=>'es-ec'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699121568485180093.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (El Salvador) (es-sv)'
,p_lov_return_value=>'es-sv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699121921139180093.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Guatemala) (es-gt)'
,p_lov_return_value=>'es-gt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699122338312180094.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Honduras) (es-hn)'
,p_lov_return_value=>'es-hn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699122706175180094.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Espanhol (M\00E9xico) (es-mx)')
,p_lov_return_value=>'es-mx'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699123193173180094.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Espanhol (Nicar\00E1gua) (es-ni)')
,p_lov_return_value=>'es-ni'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699123576249180094.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Espanhol (Panam\00E1) (es-pa)')
,p_lov_return_value=>'es-pa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699123952759180094.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Paraguai) (es-py)'
,p_lov_return_value=>'es-py'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699124377656180095.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Peru) (es-pe)'
,p_lov_return_value=>'es-pe'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699124748226180095.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Porto Rico) (es-pr)'
,p_lov_return_value=>'es-pr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699125127369180095.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Tradicional) (es)'
,p_lov_return_value=>'es'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699125511532180095.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Estados Unidos) (es-us)'
,p_lov_return_value=>'es-us'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699125971306180096.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Uruguai) (es-uy)'
,p_lov_return_value=>'es-uy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699126309761180096.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol (Venezuela) (es-ve)'
,p_lov_return_value=>'es-ve'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699126741047180096.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Sueco (sv)'
,p_lov_return_value=>'sv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699127176377180096.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Sueco (Finl\00E2ndia) (sv-fi)')
,p_lov_return_value=>'sv-fi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699127597883180096.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('T\00E2mil (ta)')
,p_lov_return_value=>'ta'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699127927061180097.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('T\00E9lugo (te)')
,p_lov_return_value=>'te'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699128382178180097.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Tailand\00EAs (th)')
,p_lov_return_value=>'th'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699128731024180097.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Turco (tr)'
,p_lov_return_value=>'tr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699129157411180097.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ucraniano (uk)'
,p_lov_return_value=>'uk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699129585255180098.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Urdu (ur)'
,p_lov_return_value=>'ur'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699129971575180098.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Uzbequist\00E3o (uz)')
,p_lov_return_value=>'uz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699130356540180098.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Vietnamita (vi)'
,p_lov_return_value=>'vi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699130787098180098.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Irland\00EAs (ga)')
,p_lov_return_value=>'ga'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699131129792180100.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Gal\00EAs (cy)')
,p_lov_return_value=>'cy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699131522308180101.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Swahili (sw)'
,p_lov_return_value=>'sw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699131990424180101.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Alban\00EAs')
,p_lov_return_value=>'sq'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699132366271180101.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Arm\00EAnio')
,p_lov_return_value=>'hy'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_territories
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(634728210841234369.4905)
,p_lov_name=>'I18N_TERRITORIES'
,p_reference_id=>634612723768159258.4905
,p_lov_query=>'.'||wwv_flow_api.id(634728210841234369.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62768512046442477.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Azerbaij\00E3o')
,p_lov_return_value=>'AZERBAIJAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62768930505442477.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Arg\00E9lia')
,p_lov_return_value=>'ALGERIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62769309199442477.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Am\00E9rica')
,p_lov_return_value=>'AMERICA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62769770701442478.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Argentina'
,p_lov_return_value=>'ARGENTINA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62770125083442478.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Austr\00E1lia')
,p_lov_return_value=>'AUSTRALIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62770576591442478.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1ustria')
,p_lov_return_value=>'AUSTRIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62770950179442478.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Barein'
,p_lov_return_value=>'BAHRAIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62771329653442479.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bangladesh'
,p_lov_return_value=>'BANGLADESH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62771751169442479.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('B\00E9lgica')
,p_lov_return_value=>'BELGIUM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62772126105442479.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Brasil'
,p_lov_return_value=>'BRAZIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62772555136442479.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Bulg\00E1ria')
,p_lov_return_value=>'BULGARIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62772924789442480.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Canad\00E1')
,p_lov_return_value=>'CANADA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62773397498442480.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Catalunha'
,p_lov_return_value=>'CATALONIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62773715833442480.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chile'
,p_lov_return_value=>'CHILE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62774123927442480.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'China'
,p_lov_return_value=>'CHINA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62774562332442481.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Col\00F4mbia')
,p_lov_return_value=>'COLOMBIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62774972634442481.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Costa Rica'
,p_lov_return_value=>'COSTA RICA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62775351297442481.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Cro\00E1cia')
,p_lov_return_value=>'CROATIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62775747407442481.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Rep\00FAblica Tcheca')
,p_lov_return_value=>'CZECH REPUBLIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62776195701442481.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Dinamarca'
,p_lov_return_value=>'DENMARK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62776502463442482.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Equador'
,p_lov_return_value=>'ECUADOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62776904673442482.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Egito'
,p_lov_return_value=>'EGYPT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62777371218442482.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'El Salvador'
,p_lov_return_value=>'EL SALVADOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62777721576442482.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Est\00F4nia')
,p_lov_return_value=>'ESTONIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62778182718442483.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Finl\00E2ndia')
,p_lov_return_value=>'FINLAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62778552942442483.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Fran\00E7a')
,p_lov_return_value=>'FRANCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62778904538442483.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Maced\00F4nia')
,p_lov_return_value=>'FYR MACEDONIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62779355380442483.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Alemanha'
,p_lov_return_value=>'GERMANY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62779707068442484.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Gr\00E9cia')
,p_lov_return_value=>'GREECE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62780191281442484.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Guatemala'
,p_lov_return_value=>'GUATEMALA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62780570482442484.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hong Kong'
,p_lov_return_value=>'HONG KONG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62780972409442484.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hungria'
,p_lov_return_value=>'HUNGARY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62781310225442485.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Isl\00E2ndia')
,p_lov_return_value=>'ICELAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62781759163442485.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00CDndia')
,p_lov_return_value=>'INDIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62782151355442485.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Indon\00E9sia')
,p_lov_return_value=>'INDONESIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62782519713442486.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Iraque'
,p_lov_return_value=>'IRAQ'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62782982144442486.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Irlanda'
,p_lov_return_value=>'IRELAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62783350927442486.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Israel'
,p_lov_return_value=>'ISRAEL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62783797822442486.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('It\00E1lia')
,p_lov_return_value=>'ITALY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62784141001442486.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Jap\00E3o')
,p_lov_return_value=>'JAPAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62784519265442487.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Jord\00E2nia')
,p_lov_return_value=>'JORDAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62784913226442487.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Cazaquist\00E3o')
,p_lov_return_value=>'KAZAKHSTAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62785308333442487.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Coreia'
,p_lov_return_value=>'KOREA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62785717099442487.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Kuwait'
,p_lov_return_value=>'KUWAIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62786101932442488.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Let\00F4nia')
,p_lov_return_value=>'LATVIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62786558628442488.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('L\00EDbano')
,p_lov_return_value=>'LEBANON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62786952129442488.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('L\00EDbia')
,p_lov_return_value=>'LIBYA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62787323890442488.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Litu\00E2nia')
,p_lov_return_value=>'LITHUANIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62787782538442489.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Luxemburgo'
,p_lov_return_value=>'LUXEMBOURG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62788182614442489.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Mal\00E1sia')
,p_lov_return_value=>'MALAYSIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62788528479442489.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('M\00E9xico')
,p_lov_return_value=>'MEXICO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62788997279442490.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Marrocos'
,p_lov_return_value=>'MOROCCO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62789325661442490.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Nova Zel\00E2ndia')
,p_lov_return_value=>'NEW ZEALAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62789782549442490.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Nicar\00E1gua')
,p_lov_return_value=>'NICARAGUA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62790133238442490.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Noruega'
,p_lov_return_value=>'NORWAY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62790562008442491.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Om\00E3')
,p_lov_return_value=>'OMAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62790923765442491.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Panam\00E1')
,p_lov_return_value=>'PANAMA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62791326115442491.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Peru'
,p_lov_return_value=>'PERU'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62791722352442491.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Filipinas'
,p_lov_return_value=>'PHILIPPINES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62792127389442492.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Pol\00F4nia')
,p_lov_return_value=>'POLAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62792532827442492.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portugal'
,p_lov_return_value=>'PORTUGAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62792943133442492.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Porto Rico'
,p_lov_return_value=>'PUERTO RICO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62793345569442492.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Catar'
,p_lov_return_value=>'QATAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62793726564442493.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Rom\00EAnia')
,p_lov_return_value=>'ROMANIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62794173620442493.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('R\00FAssia')
,p_lov_return_value=>'RUSSIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62794528506442493.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ar\00E1bia Saudita')
,p_lov_return_value=>'SAUDI ARABIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62794957133442493.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('S\00E9rvia e Montenegro')
,p_lov_return_value=>'SERBIA AND MONTENEGRO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62795307781442494.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cingapura'
,p_lov_return_value=>'SINGAPORE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62795777034442494.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Eslov\00E1quia')
,p_lov_return_value=>'SLOVAKIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62796162893442494.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Eslov\00EAnia')
,p_lov_return_value=>'SLOVENIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62796548292442494.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00C1frica do Sul')
,p_lov_return_value=>'SOUTH AFRICA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62796908133442495.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanha'
,p_lov_return_value=>'SPAIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62797382995442495.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Su\00E9cia')
,p_lov_return_value=>'SWEDEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62797757964442495.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Su\00ED\00E7a')
,p_lov_return_value=>'SWITZERLAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62798128335442495.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('S\00EDria')
,p_lov_return_value=>'SYRIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62798526167442495.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Taiwan'
,p_lov_return_value=>'TAIWAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62798964210442496.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Tail\00E2ndia')
,p_lov_return_value=>'THAILAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62799338177442496.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Holanda'
,p_lov_return_value=>'THE NETHERLANDS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62799783102442496.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Tun\00EDsia')
,p_lov_return_value=>'TUNISIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62800138392442496.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Turquia'
,p_lov_return_value=>'TURKEY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62800521279442497.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ucr\00E2nia')
,p_lov_return_value=>'UKRAINE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62800975328442497.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Emirados \00C1rabes Unidos')
,p_lov_return_value=>'UNITED ARAB EMIRATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62801343830442497.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Reino Unido'
,p_lov_return_value=>'UNITED KINGDOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62801707976442497.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Uzbequist\00E3o')
,p_lov_return_value=>'UZBEKISTAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62802182931442498.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Venezuela'
,p_lov_return_value=>'VENEZUELA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62802531981442498.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Vietn\00E3')
,p_lov_return_value=>'VIETNAM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62802931670442498.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('I\00EAmen')
,p_lov_return_value=>'YEMEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_clear_settings
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184141723318598286.4905)
,p_lov_name=>'IR_CLEAR_SETTINGS'
,p_lov_query=>'.'||wwv_flow_api.id(184141723318598286.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184141903129598286.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Limpar Defini\00E7\00F5es do Relat\00F3rio')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_column_filter_lov
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187536631811296748.4905)
,p_lov_name=>'IR_COLUMN_FILTER_LOV'
,p_lov_query=>'.'||wwv_flow_api.id(187536631811296748.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187536803714296749.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Nenhum'
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187537027390296749.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Padr\00E3o Baseado no Tipo de Coluna')
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187537221036296749.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Usar Lista de Valores definida para Filtrar Correspond\00EAncia Exata')
,p_lov_return_value=>'S'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187537420494296749.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('Usar Lista de Valores definida para Filtrar a Palavra Cont\00E9m')
,p_lov_return_value=>'C'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_column_functionality
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187521603695108878.4905)
,p_lov_name=>'IR_COLUMN_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_api.id(187521603695108878.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261252015294852290.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Ocultar'
,p_lov_return_value=>'HIDE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187521815724108878.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Classificar'
,p_lov_return_value=>'SORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187522018417108878.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Filtro'
,p_lov_return_value=>'FILTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187522228192108878.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Destacar'
,p_lov_return_value=>'HIGHLIGHT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187522424754108878.4905)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Quebra de Controle'
,p_lov_return_value=>'BREAK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187522603425108878.4905)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Agregar'
,p_lov_return_value=>'AGGREGATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187522808972108878.4905)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Calcular'
,p_lov_return_value=>'COMPUTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187523010729108878.4905)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('Gr\00E1fico')
,p_lov_return_value=>'CHART'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187523228523108878.4905)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Agrupar por'
,p_lov_return_value=>'GROUP_BY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3701401105670.4905)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('Piv\00F4')
,p_lov_return_value=>'PIVOT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_detail_page_functionality
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184015632435758855.4905)
,p_lov_name=>'IR_DETAIL_PAGE_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_api.id(184015632435758855.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184015811357758856.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Permitir Exclus\00E3o de Valores Nulos')
,p_lov_return_value=>'EXCLUDE_NULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184016009426758856.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Permitir Colunas Exibidas'
,p_lov_return_value=>'HIDE_EXTR_COL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_display_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(183810312847513834.4905)
,p_lov_name=>'IR_DISPLAY_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(183810312847513834.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183810509783513835.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Coluna de Relat\00F3rio Padr\00E3o')
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183810717133513835.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Exibir como Texto (caracteres especiais de escape)'
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(450527627281054238.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Remover HTML e caracteres especiais de escape'
,p_lov_return_value=>'STRIP_HTML_ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183810915056513835.4905)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Oculto'
,p_lov_return_value=>'HIDDEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_link_column
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184013026632738314.4905)
,p_lov_name=>'IR_LINK_COLUMN'
,p_lov_query=>'.'||wwv_flow_api.id(184013026632738314.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184013223015738314.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Link para View de Uma Linha'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184013402164738315.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Link para Alvo Personalizado'
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184013623895738315.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Excluir Coluna do Link'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_link_operator
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184114411019556922.4905)
,p_lov_name=>'IR_LINK_OPERATOR'
,p_lov_query=>'.'||wwv_flow_api.id(184114411019556922.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184114626877556922.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Igual a'
,p_lov_return_value=>'EQ'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184114812403556922.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Diferente de'
,p_lov_return_value=>'NEQ'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184115009808556923.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Menor que'
,p_lov_return_value=>'LT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184115216118556923.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Menor ou igual a'
,p_lov_return_value=>'LTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184115410372556923.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Maior que'
,p_lov_return_value=>'GT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184115603175556923.4905)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Maior ou Igual a'
,p_lov_return_value=>'GTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184115811804556923.4905)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Operador Like SQL'
,p_lov_return_value=>'LIKE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184116014545556923.4905)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Nulo'
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184116211240556923.4905)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('N\00E3o Nulo')
,p_lov_return_value=>'NN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184116429729556923.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Cont\00E9m')
,p_lov_return_value=>'C '
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184116600682556923.4905)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('N\00E3o Cont\00E9m')
,p_lov_return_value=>'NC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184116820056556923.4905)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('Linha Cont\00E9m')
,p_lov_return_value=>'IR_ROWFILTER '
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_notify_interval
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(497258407132255912.4905)
,p_lov_name=>'IR_NOTIFY_INTERVAL'
,p_lov_query=>'.'||wwv_flow_api.id(497258407132255912.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(497258621830255914.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Diariamente'
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(497258807889255918.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Semanalmente'
,p_lov_return_value=>'W'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(497259008562255918.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Mensalmente'
,p_lov_return_value=>'M'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_pagination_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(183988226651539622.4905)
,p_lov_name=>'IR_PAGINATION_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(183988226651539622.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183988425548539651.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Faixas de Linha X a Y de Z'
,p_lov_return_value=>'ROWS_X_TO_Y_OF_Z'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183988600836539651.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Faixas de Linha X a Y'
,p_lov_return_value=>'ROWS_X_TO_Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_reports_in_current_app
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184030311010131156.4905)
,p_lov_name=>'IR_REPORTS_IN_CURRENT_APP'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name, id',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :WS_APP_ID',
'and security_group_id = :flow_security_group_id',
'and websheet_type = ''REPORT''',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_reset
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184090310224424164.4905)
,p_lov_name=>'IR_RESET'
,p_lov_query=>'.'||wwv_flow_api.id(184090310224424164.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184090518146424166.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Redefinir Relat\00F3rio')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_rowid_or_cols
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184017715035772751.4905)
,p_lov_name=>'IR_ROWID_OR_COLS'
,p_lov_query=>'.'||wwv_flow_api.id(184017715035772751.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184017914148772751.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'ROWID'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184018110509772751.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Coluna \00DAnica')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_same_label_for_detail_view
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187510818230037360.4905)
,p_lov_name=>'IR_SAME_LABEL_FOR_DETAIL_VIEW'
,p_lov_query=>'.'||wwv_flow_api.id(187510818230037360.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187511006081037360.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Usar Mesmo Texto para View de Uma Linha'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/languages_installed
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(631691002719703351.4905)
,p_lov_name=>'LANGUAGES_INSTALLED'
,p_reference_id=>631619712812572565.4905
,p_lov_query=>'.'||wwv_flow_api.id(631691002719703351.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797110708703121637.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Alem\00E3o')
,p_lov_return_value=>'de'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''de'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797110905024121637.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Ingl\00EAs')
,p_lov_return_value=>'en'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''zh-cn'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797111115323121638.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Espanhol'
,p_lov_return_value=>'es'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''es'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797111316804121638.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Franc\00EAs')
,p_lov_return_value=>'fr'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''fr'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797111505126121638.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Italiano'
,p_lov_return_value=>'it'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''it'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797111712120121638.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Japon\00EAs')
,p_lov_return_value=>'ja'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''ja'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797111918483121638.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Coreano'
,p_lov_return_value=>'ko'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''ko'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797112116588121638.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Portugu\00EAs (Brasil)')
,p_lov_return_value=>'pt-br'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''pt-br'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797112313424121638.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Chin\00EAs (China)')
,p_lov_return_value=>'zh-cn'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''zh-cn'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797112528313121640.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Chin\00EAs (Taiwan)')
,p_lov_return_value=>'zh-tw'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''zh-tw'')         '))
);
end;
/
prompt --application/shared_components/user_interface/lovs/language_derived_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(502656918406037207.4905)
,p_lov_name=>'LANGUAGE_DERIVED_FROM'
,p_lov_query=>'.'||wwv_flow_api.id(502656918406037207.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(502657718966037208.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Idioma Principal do Aplicativo'
,p_lov_return_value=>'FLOW_PRIMARY_LANGUAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(502657317052037208.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('Browser (usar prefer\00EAncia de idioma do browser)')
,p_lov_return_value=>'BROWSER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_application_pages
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(461381027000774471.4905)
,p_lov_name=>'LIST APPLICATION PAGES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select substr(name,1,30) name , id',
'from wwv_flow_ws_webpages p',
'where  p.ws_app_id = :ws_app_id and security_group_id = :flow_security_group_id',
'order by name'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/logo_attributes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(461438607298231622.4905)
,p_lov_name=>'LOGO ATTRIBUTES'
,p_reference_id=>461376702019738964.4905
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''BLACK_TEXT'') d, ''style="font-family:Arial; color:#000000; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''BLUE_TEXT'') d, ''style="font-family:Arial; color:#004C66; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''WHITE_TEXT'') d, ''style="font-family:Arial; color:#FFFFFF; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual',
'union all',
'select wwv_flow_lang.system_message(''GRAY_TEXT'') d, ''style="font-family:Arial; color:#303030; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''image_attributes'') d, ''alt="Application" title="Application"'' r from dual '))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lov_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88891506202224413.4905)
,p_lov_name=>'LOV_FROM'
,p_lov_query=>'.'||wwv_flow_api.id(88891506202224413.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88892002310224415.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lista de Valores  Compartilhada'
,p_lov_return_value=>'SHARED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88891803220224415.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Valores de Colunas Distintos'
,p_lov_return_value=>'DISTINCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88938810600443285.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Criar Novo'
,p_lov_return_value=>'CREATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/nav_section_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(178562403162170735.4905)
,p_lov_name=>'NAV_SECTION_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(178562403162170735.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178562620987170738.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Navega\00E7\00E3o por P\00E1gina')
,p_lov_return_value=>'NAV_PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178562830738170741.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Navega\00E7\00E3o por Se\00E7\00E3o')
,p_lov_return_value=>'NAV_SECTION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/order_by_direction
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(606013026952235682.4905)
,p_lov_name=>'ORDER_BY_DIRECTION'
,p_lov_query=>'.'||wwv_flow_api.id(606013026952235682.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(606013300020235684.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Crescente'
,p_lov_return_value=>'ASC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(606013531554235685.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Decrescente'
,p_lov_return_value=>'DESC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p740_saved_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(429632313107701908.4905)
,p_lov_name=>'P740_SAVED_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P740_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P740_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')) x',
'order by x.seq, x.r'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p742_data_grid_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(261395425456539191.4905)
,p_lov_name=>'P742_DATA_GRID_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P740_WEBSHEET_ID',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P740_SAVED_REPORT_ID',
'and worksheet_id = :P740_WORKSHEET_ID',
'and websheet_id = :P740_WEBSHEET_ID',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p742_data_grid_num_cols
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(261459220009944453.4905)
,p_lov_name=>'P742_DATA_GRID_NUM_COLS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P740_WEBSHEET_ID',
'and c.column_type = ''NUMBER''',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P740_SAVED_REPORT_ID',
'and worksheet_id = :P740_WORKSHEET_ID',
'and websheet_id = :P740_WEBSHEET_ID',
'and column_type = ''NUMBER''',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p750_chart_source
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(428899916079615170.4905)
,p_lov_name=>'P750_CHART_SOURCE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name||',
'       case when websheet_type=''DATA'' then '' (''||wwv_flow_lang.system_message(''DATA_GRID'')||'')''',
'            when websheet_type=''REPORT'' then '' (''||wwv_flow_lang.system_message(''REPORT'')||'')''',
'       end d,',
'       id r',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p760_chart_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(444797819996488091.4905)
,p_lov_name=>'P760_CHART_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(444797819996488091.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444798026947488095.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Barras'
,p_lov_return_value=>'bar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444798216267488096.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Linha com \00C1rea')
,p_lov_return_value=>'lineWithArea'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444798632016488096.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Pizza'
,p_lov_return_value=>'pie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444798420560488096.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Linha'
,p_lov_return_value=>'line'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p760_data_grid_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(293396605682831178.4905)
,p_lov_name=>'P760_DATA_GRID_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P760_WEBSHEET_ID',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P760_SAVED_REPORT_ID',
'and websheet_id = :P760_WEBSHEET_ID',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P760_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P760_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p760_data_grid_num_cols
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(424623105999868608.4905)
,p_lov_name=>'P760_DATA_GRID_NUM_COLS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P760_WEBSHEET_ID',
'and d.security_group_id = :flow_security_group_id',
'and c.column_type = ''NUMBER''',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P760_SAVED_REPORT_ID',
'and websheet_id = :P760_WEBSHEET_ID',
'and security_group_id = :flow_security_group_id',
'and column_type = ''NUMBER'')',
'where instr('':''||:P760_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P760_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p760_saved_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(429677014294033232.4905)
,p_lov_name=>'P760_SAVED_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P760_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P760_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')) x',
'order by x.seq, x.r'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p922_datagrid_show_opt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(244084119358061944.4905)
,p_lov_name=>'P922_DATAGRID_SHOW_OPT'
,p_lov_query=>'.'||wwv_flow_api.id(244084119358061944.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244084422806061944.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Adicionar Linha'
,p_lov_return_value=>'ADD_ROW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244084730829061948.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Editar Linha'
,p_lov_return_value=>'EDIT_ROW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244085024367061948.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Campo de Pesquisa'
,p_lov_return_value=>'SEARCH'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p922_data_grid_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(178772114682347881.4905)
,p_lov_name=>'P922_DATA_GRID_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P922_DATA_GRID_ID',
'and d.security_group_id = :flow_security_group_id',
'order by display_order'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p922_report_show_opt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(244090113649098118.4905)
,p_lov_name=>'P922_REPORT_SHOW_OPT'
,p_lov_query=>'.'||wwv_flow_api.id(244090113649098118.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244091002759098119.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Campo de Pesquisa'
,p_lov_return_value=>'SEARCH'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p922_saved_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(430293730079245893.4905)
,p_lov_name=>'P922_SAVED_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P922_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') != ''NOTIFICATION''',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P922_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') != ''NOTIFICATION'') x',
'order by x.seq, x.r'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p925_data_section_style
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(244105603016227532.4905)
,p_lov_name=>'P925_DATA_SECTION_STYLE'
,p_lov_query=>'.'||wwv_flow_api.id(244105603016227532.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244105926056227533.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Estilo 1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244106215253227534.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Estilo 2'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244106500467227534.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Estilo 3'
,p_lov_return_value=>'3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p934_data_section_show_opt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(239269013341119720.4905)
,p_lov_name=>'P934_DATA_SECTION_SHOW_OPT'
,p_lov_query=>'.'||wwv_flow_api.id(239269013341119720.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(239269323845119720.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Adicionar Linha'
,p_lov_return_value=>'ADD_ROW'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P934_WEBSHEET_TYPE'
,p_lov_disp_cond2=>'DATA_GRID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(239269606033119720.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Editar Linha'
,p_lov_return_value=>'EDIT_ROW'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P934_WEBSHEET_TYPE'
,p_lov_disp_cond2=>'DATA_GRID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(239269902232119720.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Campo de Pesquisa'
,p_lov_return_value=>'SEARCH'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p934_saved_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(431037130827466603.4905)
,p_lov_name=>'P934_SAVED_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P934_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P934_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')) x',
'order by x.seq, x.r'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_email_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(473383419441178851.4905)
,p_lov_name=>'PAGE EMAIL OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(473383419441178851.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(473383631984178859.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Enviar por e-mail o link para a p\00E1gina')
,p_lov_return_value=>'LINK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(473383814758178865.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Conte\00FAdo da p\00E1gina de e-mail')
,p_lov_return_value=>'PAGE'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_navigation_order
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(381950720171699749.4905)
,p_lov_name=>'PAGE NAVIGATION ORDER'
,p_lov_query=>'.'||wwv_flow_api.id(381950720171699749.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(381951031098699751.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Nome da P\00E1gina')
,p_lov_return_value=>'PAGE_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(381951211109699752.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Data de Cria\00E7\00E3o')
,p_lov_return_value=>'CREATED_ON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(381951400366699752.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Data de Atualiza\00E7\00E3o')
,p_lov_return_value=>'UPDATED_ON'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_position
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174603521097074779.4905)
,p_lov_name=>'PAGE POSITION'
,p_lov_query=>'.'||wwv_flow_api.id(174603521097074779.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174603926494074780.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Esquerda'
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174604103608074780.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Centralizado'
,p_lov_return_value=>'CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174604316948074780.4905)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Direita'
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pages
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(454994331134405615.4905)
,p_lov_name=>'PAGES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'from wwv_flow_ws_webpages',
'where ws_app_id = :WS_APP_ID',
'and security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pick_parent_page_for_page_53
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177413911605744887.4905)
,p_lov_name=>'PICK PARENT PAGE (FOR PAGE 53)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'  from wwv_flow_ws_webpages',
' where security_group_id = :flow_security_group_id',
'   and ws_app_id = :WS_APP_ID',
'minus',
'select name d, id r',
'  from wwv_flow_ws_webpages',
' where security_group_id = :flow_security_group_id ',
'   and ws_app_id = :WS_APP_ID ',
'connect by prior id = parent_page_id',
'start with id = :P53_ID',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/popup_data_grid_view_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6245305086538240.4905)
,p_lov_name=>'POPUP_DATA_GRID_VIEW_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(6245305086538240.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6245604034538241.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Grades de Dados'
,p_lov_return_value=>'DATA_GRIDS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6245803688538242.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Colunas da Grade de Dados Selecionada'
,p_lov_return_value=>'COLUMNS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6246002516538242.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Consulta na Grade de Dados Selecionada'
,p_lov_return_value=>'QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/remember_username
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(263997216503587205.4905)
,p_lov_name=>'REMEMBER_USERNAME'
,p_lov_query=>'.'||wwv_flow_api.id(263997216503587205.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(263997505048587206.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Lembrar nome do usu\00E1rio')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/report
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(428697210472793191.4905)
,p_lov_name=>'REPORT'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name, id',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id',
'and websheet_type = ''REPORT'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/report_label_returning_column_alias
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(157608702042123701.4905)
,p_lov_name=>'REPORT LABEL RETURNING COLUMN ALIAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_label, db_column_name',
'from wwv_flow_worksheet_columns',
'where worksheet_id = :P2_ID',
'and security_group_id = :WORKSPACE_ID',
'order by display_order'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/report_source_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181139517862367299.4905)
,p_lov_name=>'REPORT_SOURCE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(181139517862367299.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181139731760367303.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Tabela'
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181139914754367305.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Consulta SQL'
,p_lov_return_value=>'QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/row_security_restrict_by
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4200913969354730.4905)
,p_lov_name=>'ROW_SECURITY_RESTRICT_BY'
,p_lov_query=>'.'||wwv_flow_api.id(4200913969354730.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4201216137354731.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Express\00E3o da Coluna')
,p_lov_return_value=>'COLUMN_EXPR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4201401816354731.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Nome do Usu\00E1rio em Colunas')
,p_lov_return_value=>'USERNAME_IN_COLUMNS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4201616338354731.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Nome do Usu\00E1rio em Hierarquia')
,p_lov_return_value=>'USERNAME_IN_HIERARCHY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/searchable_components
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(468375932547106712.4905)
,p_lov_name=>'SEARCHABLE COMPONENTS'
,p_lov_query=>'.'||wwv_flow_api.id(468375932547106712.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468388406715184404.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Nome da P\00E1gina')
,p_lov_return_value=>'Page name'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(471083025269088996.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Alias da P\00E1gina')
,p_lov_return_value=>'Page alias'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(471083730810090673.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Descri\00E7\00E3o da P\00E1gina')
,p_lov_return_value=>'Page description'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468376931120106721.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('T\00EDtulo da se\00E7\00E3o')
,p_lov_return_value=>'Section title'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468376724828106721.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('Conte\00FAdo da se\00E7\00E3o')
,p_lov_return_value=>'Section content'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468376107670106719.4905)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('Nome do Arquivo, Alias, Descri\00E7\00E3o')
,p_lov_return_value=>'File'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468377117690106722.4905)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Tags'
,p_lov_return_value=>'Tags'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468376332154106721.4905)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('Observa\00E7\00F5es')
,p_lov_return_value=>'Notes'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468763112243277596.4905)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Dados da Grade de Dados'
,p_lov_return_value=>'Data grid'
);
end;
/
prompt --application/shared_components/user_interface/lovs/section_type_selector
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174363201295924966.4905)
,p_lov_name=>'SECTION TYPE SELECTOR'
,p_lov_query=>'.'||wwv_flow_api.id(174363201295924966.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174363729720924971.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Texto'
,p_lov_return_value=>'TEXT'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:910:&SESSION.:::910,P910_CONTENT,P910_SPREADSHEET:P920_SECTION_TYPE:TEXT"><img src="#IMAGE_PREFIX#ws/ws-text.png" height="128"'
||' width="128" alt="#DISPLAY_VALUE#" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174366523901938416.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('Navega\00E7\00E3o')
,p_lov_return_value=>'NAV'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:926:&SESSION.:::926:P920_SECTION_TYPE:NAV"><img src="#IMAGE_PREFIX#ws/ws-navigation.png" height="128" width="128" alt="#DISPLA'
||'Y_VALUE#" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174363503996924969.4905)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Dados'
,p_lov_return_value=>'DATA'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:922:&SESSION.:::922,925:P920_SECTION_TYPE:DATA"><img src="#IMAGE_PREFIX#ws/ws-from-scratch.png" height="128" width="128" alt="'
||'#DISPLAY_VALUE#" /></a></td><td>&nbsp;</td></tr></table>'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(257305806305291010.4905)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('Gr\00E1fico')
,p_lov_return_value=>'CHART'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:710:&SESSION.:::710,740,742,750:P920_SECTION_TYPE:CHART"><img src="#IMAGE_PREFIX#ws/ws-chart.png" height="128" width="128" alt'
||'="#DISPLAY_VALUE#" /></a></td><td>&nbsp;</td></tr></table>'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/section_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(492203630195322675.4905)
,p_lov_name=>'SECTION TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(492203630195322675.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492203816689322675.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Texto'
,p_lov_return_value=>'TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492204004458322675.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Gr\00E1fico')
,p_lov_return_value=>'CHART'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492204222124322676.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Navega\00E7\00E3o por Se\00E7\00E3o')
,p_lov_return_value=>'NAV_SECTION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492204407452322676.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('Navega\00E7\00E3o por P\00E1gina')
,p_lov_return_value=>'NAV_PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492204623758322676.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Dados'
,p_lov_return_value=>'DATA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15734501398512875.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'PL/SQL'
,p_lov_return_value=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/section_source
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(428681322228645128.4905)
,p_lov_name=>'SECTION_SOURCE'
,p_lov_query=>'.'||wwv_flow_api.id(428681322228645128.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(428681516422645131.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Grade de Dados'
,p_lov_return_value=>'DATA_GRID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(428681722703645131.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Relat\00F3rio ')
,p_lov_return_value=>'REPORT'
,p_lov_disp_cond_type=>'FUNCTION_BODY'
,p_lov_disp_cond=>'return wwv_flow_ws_security.current_user_is_not_reader and wwv_flow_ws_security.sql_enabled(:WS_APP_ID) and wwv_flow_ws_security.sql_enabled_inst;'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sharing_standard_codes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(161342315175360665.4905)
,p_lov_name=>'SHARING - STANDARD CODES'
,p_lov_query=>'.'||wwv_flow_api.id(161342315175360665.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161342511198360666.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Compartilhado com Todos'
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22963820418845971.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Compartilhado com Lista de Controle de Acesso'
,p_lov_return_value=>'ACL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161342929843360666.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Particular'
,p_lov_return_value=>'AVAILABLE_FOR_OWNER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_all_websheets_or_my_websheets
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(83901725439965785.4905)
,p_lov_name=>'SHOW ALL WEBSHEETS OR MY WEBSHEETS'
,p_lov_query=>'.'||wwv_flow_api.id(83901725439965785.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(83901929137965786.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Todas as WebSheets'
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(83902128718965786.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Minhas WebSheets'
,p_lov_return_value=>'MINE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/suggested_sql_table_type_p90
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(17231024016826986.4905)
,p_lov_name=>'SUGGESTED SQL TABLE TYPE (P90)'
,p_lov_query=>'.'||wwv_flow_api.id(17231024016826986.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17231212381826990.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Objetos Sugeridos'
,p_lov_return_value=>'S'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17231413694826994.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Todos os Objetos Acess\00EDveis')
,p_lov_return_value=>'A'
);
end;
/
prompt --application/shared_components/user_interface/lovs/text_websheets
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174421329189713558.4905)
,p_lov_name=>'TEXT WEBSHEETS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'from   wwv_flow_ws_webpages',
'where security_group_id = :flow_security_group_id and',
'      ws_app_id = :WS_APP_ID',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/timeframe
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(185584826211920495.4905)
,p_lov_name=>'TIMEFRAME'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/url_or_report
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184024419940878266.4905)
,p_lov_name=>'URL_OR_REPORT'
,p_lov_query=>'.'||wwv_flow_api.id(184024419940878266.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184024616003878266.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Relat\00F3rio neste Aplicativo')
,p_lov_return_value=>'REPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184024823203878266.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'URL'
,p_lov_return_value=>'URL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/use_primary_default
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(428734704772905075.4905)
,p_lov_name=>'USE_PRIMARY_DEFAULT'
,p_lov_query=>'.'||wwv_flow_api.id(428734704772905075.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(428734912977905076.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Usar Defini\00E7\00F5es Prim\00E1rias de Relat\00F3rio Padr\00E3o')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/validate_plsql
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12497031296679964.4905)
,p_lov_name=>'VALIDATE_PLSQL'
,p_lov_query=>'.'||wwv_flow_api.id(12497031296679964.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12497306721679972.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('N\00E3o validar c\00F3digo PL/SQL (fazer parse do c\00F3digo PL/SQL somente em runtime).')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/view_as_icons_or_details
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(83845910791829052.4905)
,p_lov_name=>'VIEW AS ICONS OR DETAILS'
,p_lov_query=>'.'||wwv_flow_api.id(83845910791829052.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(83846129033829055.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\00CDcones')
,p_lov_return_value=>'ICONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(83846305343829058.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Detalhes'
,p_lov_return_value=>'DETAILS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_application_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(471867429070174759.4905)
,p_lov_name=>'WEBSHEET APPLICATION STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(471867429070174759.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(471867623399174772.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Dispon\00EDvel')
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(471868003921176945.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('N\00E3o dispon\00EDvel')
,p_lov_return_value=>'UNAVAILABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_authentication
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(444727703759035884.4905)
,p_lov_name=>'WEBSHEET AUTHENTICATION'
,p_lov_query=>'.'||wwv_flow_api.id(444727703759035884.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444728117740035894.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Conta do Application Express'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444728300760035894.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Sign-on \00DAnico')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444728526805035894.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'LDAP'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1959643209188118620.4905)
,p_lov_disp_sequence=>4.5
,p_lov_disp_value=>'Oracle Cloud Identity Management'
,p_lov_return_value=>'5'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444728724858035894.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Personalizado'
,p_lov_return_value=>'4'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_home_page_selector_p_1250
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177463924416148776.4905)
,p_lov_name=>'WEBSHEET HOME PAGE SELECTOR (P 1250)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name, id ',
'from WWV_FLOW_WS_WEBPAGES ',
'where WS_APP_ID = :P1250_ID and',
'      security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_page_style
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(478186020350840371.4905)
,p_lov_name=>'WEBSHEET PAGE STYLE'
,p_lov_query=>'.'||wwv_flow_api.id(478186020350840371.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(478186224261840375.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Estilo Padr\00E3o')
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(478186402878840381.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Estilo de Alternativa 1'
,p_lov_return_value=>'1'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(478187212720840384.4905)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Estilo Personalizado'
,p_lov_return_value=>'99'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_page_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177459420645100351.4905)
,p_lov_name=>'WEBSHEET PAGE TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(177459420645100351.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177459613519100354.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('P\00E1gina')
,p_lov_return_value=>'PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177459807231100356.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Grades de dados'
,p_lov_return_value=>'DATA'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheets_pick_parent_show_all_pages
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(477788102822094591.4905)
,p_lov_name=>'WEBSHEETS - PICK PARENT -- SHOW ALL PAGES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'from   wwv_flow_ws_webpages',
'where security_group_id = :flow_security_group_id and',
'      ws_app_id = :WS_APP_ID ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_priv
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4272307523349785.4905)
,p_lov_name=>'WEBSHEET_PRIV'
,p_lov_query=>'.'||wwv_flow_api.id(4272307523349785.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4272616503349799.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Exibir e Editar'
,p_lov_return_value=>'EDIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4272800274349801.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Exibir Apenas'
,p_lov_return_value=>'VIEW_ONLY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_share_with
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4270305567216064.4905)
,p_lov_name=>'WEBSHEET_SHARE_WITH'
,p_lov_query=>'.'||wwv_flow_api.id(4270305567216064.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4271211380216070.4905)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('Privado, N\00E3o Compartilhado')
,p_lov_return_value=>'PRIVATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_column_lov_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7088909602608513.4905)
,p_lov_name=>'WORKSHEET COLUMN LOV FROM'
,p_lov_query=>'.'||wwv_flow_api.id(7088909602608513.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7089115009608515.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Valores de Colunas Distintos'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7089311442608516.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('Dom\00EDnio de Valores Est\00E1tico')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_lovs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(20284128708076403.4905)
,p_lov_name=>'WORKSHEET LOVS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select NAME display_value, ID return_value ',
'from WWV_FLOW_WORKSHEET_LOVS',
'where worksheet_id = :p2_id',
'and security_group_id = :WORKSPACE_ID',
'order by upper(name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_reports_with_worksheet
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1097408377479572.4905)
,p_lov_name=>'WORKSHEET REPORTS WITH WORKSHEET'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(name, ''- Worksheet -'') name, id ',
'  from wwv_flow_worksheet_rpts',
' where worksheet_id = :P2_ID',
'   and application_user = :APP_USER',
'   and name is not null',
'   and security_group_id = :flow_security_group_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4196722056290886.4905)
,p_lov_name=>'WORKSHEET_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select report_label, db_column_name',
'from wwv_flow_worksheet_columns',
'where worksheet_id = :p2_id',
'and security_group_id = :WORKSPACE_ID',
'order by display_order'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_column_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(159512305334979648.4905)
,p_lov_name=>'WORKSHEET_COLUMN_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(159512305334979648.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159512611310979649.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'String'
,p_lov_return_value=>'STRING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159512810815979649.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('N\00FAmero')
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159513008482979649.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Data'
,p_lov_return_value=>'DATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159513210897979649.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Documento'
,p_lov_return_value=>'DOCUMENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(11517807514880595.4905)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Calculado'
,p_lov_return_value=>'COMPUTED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_column_types2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(38353412581019585.4905)
,p_lov_name=>'WORKSHEET_COLUMN_TYPES2'
,p_lov_query=>'.'||wwv_flow_api.id(38353412581019585.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38353715513019587.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'String'
,p_lov_return_value=>'STRING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38353907530019587.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('N\00FAmero')
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38354113803019587.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Data'
,p_lov_return_value=>'DATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_acl_privs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(451333930142995878.4905)
,p_lov_name=>'WS_ACL_PRIVS'
,p_lov_query=>'.'||wwv_flow_api.id(451333930142995878.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(451334128711995879.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Leitor'
,p_lov_return_value=>'R'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(451334314312995960.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Colaborador'
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(451334509043995960.4905)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Administrador'
,p_lov_return_value=>'A'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_app_acl_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(450940100671567605.4905)
,p_lov_name=>'WS_APP_ACL_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(450940100671567605.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(450940311282567606.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Padr\00E3o')
,p_lov_return_value=>'DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(450940510709567608.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Personalizado'
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_logo_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(461278502171499627.4905)
,p_lov_name=>'WS_LOGO_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(461278502171499627.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461278702764499627.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Nenhum'
,p_lov_return_value=>'NONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461278910485499644.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Texto'
,p_lov_return_value=>'TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461279109274499644.4905)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Imagem Submetida a Upload'
,p_lov_return_value=>'IMAGE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461279326169499644.4905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Caminho do Arquivo'
,p_lov_return_value=>'FILEPATH'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_page_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174627223457398766.4905)
,p_lov_name=>'WS_PAGE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(174627223457398766.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174627515804398767.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Grades de dados'
,p_lov_return_value=>'DATA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174627719694398770.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Texto'
,p_lov_return_value=>'TEXT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returning_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(159003224636178271.4905)
,p_lov_name=>'YES NO RETURNING Y N'
,p_lov_query=>'.'||wwv_flow_api.id(159003224636178271.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159003530237178272.4905)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Sim'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159003719271178272.4905)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('N\00E3o')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4091010662546975.4905)
,p_lov_name=>'YES NO RETURNS Y N'
,p_lov_query=>'.'||wwv_flow_api.id(4091010662546975.4905)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4091213313546978.4905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Sim'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4091420742546980.4905)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('N\00E3o')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/worksheet_standard
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(78897017520604216.4905)
,p_name=>'worksheet standard'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2670021526029217.4905)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4905)
,p_short_name=>unistr('Exibir Hist\00F3rico de Altera\00E7\00F5es')
,p_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
,p_page_id=>14
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4230728579343205.4905)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4905)
,p_short_name=>'Alterar Tipo de Coluna'
,p_link=>'f?p=&FLOW_ID.:89:&SESSION.'
,p_page_id=>89
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4233729491405795.4905)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4905)
,p_short_name=>'Alterar Tipo de Coluna'
,p_link=>'f?p=&FLOW_ID.:91:&SESSION.'
,p_page_id=>91
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5510514461754522.4905)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4905)
,p_short_name=>'Painel de Controle'
,p_link=>'f?p=&FLOW_ID.:400:&SESSION.'
,p_page_id=>400
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(78897520983605269.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Diret\00F3rio de P\00E1ginas')
,p_link=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:::'
,p_page_id=>1000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(78901107456613285.4905)
,p_parent_id=>wwv_flow_api.id(78897520983605269.4905)
,p_short_name=>unistr('Criar P\00E1gina')
,p_link=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:::'
,p_page_id=>200
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(78917815626639965.4905)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4905)
,p_short_name=>'&WORKSHEET_NAME.'
,p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::P2_ID:&P2_ID.'
,p_page_id=>2
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(81681714437489706.4905)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4905)
,p_short_name=>'Adicionar/Editar Linha'
,p_link=>'f?p=&FLOW_ID.:20:&SESSION.'
,p_page_id=>20
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(81687303832540185.4905)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4905)
,p_short_name=>'Adicionar Anexo'
,p_link=>'f?p=&FLOW_ID.:50:&SESSION.'
,p_page_id=>50
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(85198520867592463.4905)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4905)
,p_short_name=>'Criar Grade de Dados'
,p_link=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:::'
,p_page_id=>205
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(85200708143598339.4905)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4905)
,p_short_name=>'Criar Grade de Dados'
,p_link=>'f?p=&APP_ID.:201:&SESSION.::&DEBUG.:::'
,p_page_id=>201
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(87067930193889011.4905)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4905)
,p_short_name=>'Criar Grade de Dados'
,p_link=>'f?p=&APP_ID.:206:&SESSION.::&DEBUG.:::'
,p_page_id=>206
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171300231813414293.4905)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4905)
,p_short_name=>'&P3000_REPORT_NAME!RAW.'
,p_link=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.:::'
,p_page_id=>3000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171582602179856081.4905)
,p_parent_id=>wwv_flow_api.id(171300231813414293.4905)
,p_short_name=>unistr('Editar Relat\00F3rio')
,p_link=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:::'
,p_page_id=>3010
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(172959905219473555.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>'Pesquisar'
,p_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:::'
,p_page_id=>8000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(173221216721622592.4905)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4905)
,p_short_name=>'Criar'
,p_link=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.:::'
,p_page_id=>131
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174460015452180827.4905)
,p_parent_id=>wwv_flow_api.id(.4905)
,p_short_name=>unistr('In\00EDcio')
,p_link=>'ws?p=&WS_APP_ID.:home:&SESSION.'
,p_page_id=>900
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174536419956209170.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Nova Se\00E7\00E3o')
,p_link=>'f?p=&APP_ID.:910:&SESSION.::&DEBUG.:::'
,p_page_id=>910
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174537325551221738.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Nova Se\00E7\00E3o')
,p_link=>'f?p=&FLOW_ID.:920:&SESSION.'
,p_page_id=>920
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174562103281566299.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Editar Se\00E7\00E3o')
,p_link=>'f?p=&FLOW_ID.:930:&SESSION.'
,p_page_id=>930
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174587421741748355.4905)
,p_parent_id=>wwv_flow_api.id(456716629226062947.4905)
,p_short_name=>'Painel de Controle'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(176493330002233411.4905)
,p_parent_id=>wwv_flow_api.id(456716629226062947.4905)
,p_short_name=>'Propriedades da Websheet'
,p_link=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:::'
,p_page_id=>1250
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(177132319189562341.4905)
,p_parent_id=>wwv_flow_api.id(174587421741748355.4905)
,p_short_name=>unistr('Gerenciar Esquemas de Autentica\00E7\00E3o')
,p_link=>'f?p=&FLOW_ID.:51:&SESSION.'
,p_page_id=>51
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(177425500872951637.4905)
,p_parent_id=>wwv_flow_api.id(.4905)
,p_short_name=>unistr('Editar P\00E1gina')
,p_link=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.:::'
,p_page_id=>53
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(177505624887294566.4905)
,p_parent_id=>wwv_flow_api.id(174587421741748355.4905)
,p_short_name=>unistr('Criar Se\00E7\00E3o')
,p_link=>'f?p=&FLOW_ID.:921:&SESSION.'
,p_page_id=>921
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(177969610547759155.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Excluir P\00E1gina')
,p_link=>'f?p=&FLOW_ID.:960:&SESSION.'
,p_page_id=>960
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178435411977260701.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Editar Se\00E7\00E3o')
,p_link=>'f?p=&FLOW_ID.:931:&SESSION.'
,p_page_id=>931
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178515920668406977.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Criar Se\00E7\00E3o de Dados')
,p_link=>'f?p=&APP_ID.:922:&SESSION.::&DEBUG.:::'
,p_page_id=>922
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178567213402219839.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Criar Se\00E7\00E3o')
,p_link=>'f?p=&FLOW_ID.:926:&SESSION.'
,p_page_id=>926
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178572623297245626.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Criar Se\00E7\00E3o')
,p_link=>'f?p=&FLOW_ID.:927:&SESSION.'
,p_page_id=>927
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178735000980446641.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Editar Se\00E7\00E3o')
,p_link=>'f?p=&FLOW_ID.:932:&SESSION.'
,p_page_id=>932
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178832411836267350.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>'Dados'
,p_link=>'f?p=&APP_ID.:902:&SESSION.::&DEBUG.:::'
,p_page_id=>902
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178833326920275511.4905)
,p_parent_id=>wwv_flow_api.id(187171813556872743.4905)
,p_short_name=>'Arquivos'
,p_link=>'f?p=&APP_ID.:903:&SESSION.::&DEBUG.:::'
,p_page_id=>903
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178833723901276942.4905)
,p_parent_id=>wwv_flow_api.id(187171813556872743.4905)
,p_short_name=>'Tags'
,p_link=>'f?p=&APP_ID.:904:&SESSION.::&DEBUG.:::'
,p_page_id=>904
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178834117647279840.4905)
,p_parent_id=>wwv_flow_api.id(187171813556872743.4905)
,p_short_name=>unistr('Observa\00E7\00F5es')
,p_link=>'f?p=&APP_ID.:905:&SESSION.::&DEBUG.:::'
,p_page_id=>905
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178856318730488076.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Copiar P\00E1gina')
,p_link=>'f?p=&FLOW_ID.:908:&SESSION.'
,p_page_id=>908
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(179692514107778690.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Criar Se\00E7\00E3o de Dados')
,p_link=>'f?p=&APP_ID.:925:&SESSION.::&DEBUG.:::'
,p_page_id=>925
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180470222886094847.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Editar Se\00E7\00E3o')
,p_link=>'f?p=&FLOW_ID.:934:&SESSION.'
,p_page_id=>934
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181263431536172556.4905)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4905)
,p_short_name=>unistr('Criar Relat\00F3rio')
,p_link=>'f?p=&APP_ID.:1310:&SESSION.::&DEBUG.:::'
,p_page_id=>1310
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181299229440629329.4905)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4905)
,p_short_name=>unistr('Criar Relat\00F3rio')
,p_link=>'f?p=&APP_ID.:1320:&SESSION.::&DEBUG.:::'
,p_page_id=>1320
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(184267525052006599.4905)
,p_parent_id=>wwv_flow_api.id(171582602179856081.4905)
,p_short_name=>unistr('Editar Coluna do Relat\00F3rio')
,p_link=>'f?p=&APP_ID.:3020:&SESSION.::&DEBUG.:::'
,p_page_id=>3020
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(185430107950682414.4905)
,p_parent_id=>wwv_flow_api.id(171300231813414293.4905)
,p_short_name=>unistr('Editar Relat\00F3rio')
,p_link=>'f?p=&APP_ID.:3030:&SESSION.::&DEBUG.:::'
,p_page_id=>3030
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(187171813556872743.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Anota\00E7\00F5es')
,p_link=>'f?p=&APP_ID.:906:&SESSION.::&DEBUG.:::'
,p_page_id=>906
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(187174620703946459.4905)
,p_parent_id=>wwv_flow_api.id(456716629226062947.4905)
,p_short_name=>'Monitorar Atividade'
,p_link=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:::'
,p_page_id=>140
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(188056521384504797.4905)
,p_parent_id=>wwv_flow_api.id(171300231813414293.4905)
,p_short_name=>unistr('Editar Relat\00F3rio')
,p_link=>'f?p=&APP_ID.:3060:&SESSION.::&DEBUG.:::'
,p_page_id=>3060
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(301532509548629032.4905)
,p_parent_id=>wwv_flow_api.id(176493330002233411.4905)
,p_short_name=>'Excluir Aplicativo'
,p_link=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::'
,p_page_id=>4
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(318860608321904558.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>'Criar Websheet'
,p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(321423130089423576.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>'Criar Websheet'
,p_link=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:::'
,p_page_id=>8
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(322238812351579455.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>'Criar Websheet'
,p_link=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:::'
,p_page_id=>32
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(431020021350285368.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_link=>'f?p=&FLOW_ID.:710:&SESSION.'
,p_page_id=>710
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(451312903217376859.4905)
,p_parent_id=>wwv_flow_api.id(456716629226062947.4905)
,p_short_name=>'Controle de Acesso'
,p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(451316327052485988.4905)
,p_parent_id=>wwv_flow_api.id(451312903217376859.4905)
,p_short_name=>'Detalhes da Entrada'
,p_link=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
,p_page_id=>13
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(454926007401991139.4905)
,p_parent_id=>wwv_flow_api.id(178833326920275511.4905)
,p_short_name=>'Detalhes'
,p_link=>'f?p=&APP_ID.:912:&SESSION.::&DEBUG.:::'
,p_page_id=>912
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(455078007098014547.4905)
,p_parent_id=>wwv_flow_api.id(178833723901276942.4905)
,p_short_name=>'Detalhes'
,p_link=>'f?p=&APP_ID.:913:&SESSION.::&DEBUG.:::'
,p_page_id=>913
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(455084307504044741.4905)
,p_parent_id=>wwv_flow_api.id(178834117647279840.4905)
,p_short_name=>'Detalhes'
,p_link=>'f?p=&APP_ID.:914:&SESSION.::&DEBUG.:::'
,p_page_id=>914
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(455867027556226619.4905)
,p_parent_id=>wwv_flow_api.id(456715709817052851.4905)
,p_short_name=>unistr('Vis\00E3o Geral das Websheets')
,p_link=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.:::'
,p_page_id=>15
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(456716629226062947.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Administra\00E7\00E3o')
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(456723414173263488.4905)
,p_parent_id=>wwv_flow_api.id(456715709817052851.4905)
,p_short_name=>unistr('Sintaxe de Marca\00E7\00E3o')
,p_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::'
,p_page_id=>17
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(457141423716390388.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>'Adicionar Arquivo'
,p_link=>'f?p=&APP_ID.:4020:&SESSION.::&DEBUG.:::'
,p_page_id=>4020
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(457151729837534039.4905)
,p_parent_id=>wwv_flow_api.id(.4905)
,p_short_name=>unistr('Adicionar Observa\00E7\00E3o')
,p_link=>'f?p=&APP_ID.:4030:&SESSION.::&DEBUG.:::'
,p_page_id=>4030
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(457152105511545952.4905)
,p_parent_id=>wwv_flow_api.id(.4905)
,p_short_name=>'Adicionar Tag'
,p_link=>'f?p=&APP_ID.:4040:&SESSION.::&DEBUG.:::'
,p_page_id=>4040
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(457468026650230855.4905)
,p_parent_id=>wwv_flow_api.id(.4905)
,p_short_name=>unistr('Hist\00F3rico de Se\00E7\00F5es de P\00E1ginas')
,p_link=>'f?p=&APP_ID.:950:&SESSION.::&DEBUG.:::'
,p_page_id=>950
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(459182006892056281.4905)
,p_parent_id=>wwv_flow_api.id(187171813556872743.4905)
,p_short_name=>'Nuvem de Tags'
,p_link=>'f?p=&FLOW_ID.:928:&SESSION.'
,p_page_id=>928
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(459633626075416367.4905)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4905)
,p_short_name=>unistr('Views de P\00E1gina')
,p_link=>'f?p=&FLOW_ID.:18:&SESSION.'
,p_page_id=>18
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(459662412537763358.4905)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4905)
,p_short_name=>unistr('Principais P\00E1ginas')
,p_link=>'f?p=&FLOW_ID.:24:&SESSION.'
,p_page_id=>24
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(461238603047810834.4905)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4905)
,p_short_name=>'Principais Grades de Dados'
,p_link=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.:::'
,p_page_id=>141
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(461331422787325871.4905)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4905)
,p_short_name=>unistr('Principais Relat\00F3rios')
,p_link=>'f?p=&FLOW_ID.:142:&SESSION.'
,p_page_id=>142
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(461348622392450101.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>unistr('Diret\00F3rio da Websheet')
,p_link=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.:::'
,p_page_id=>1001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(471882914071890170.4905)
,p_parent_id=>wwv_flow_api.id(.4905)
,p_short_name=>unistr('Calend\00E1rio de Cria\00E7\00E3o de P\00E1gina')
,p_link=>'f?p=&FLOW_ID.:951:&SESSION.'
,p_page_id=>951
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(471901627876065162.4905)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4905)
,p_short_name=>'Principais Arquivos'
,p_link=>'f?p=&FLOW_ID.:143:&SESSION.'
,p_page_id=>143
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(471903119311084491.4905)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4905)
,p_short_name=>unistr('Principais Observa\00E7\00F5es')
,p_link=>'f?p=&APP_ID.:144:&SESSION.::&DEBUG.:::'
,p_page_id=>144
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(471904206990093888.4905)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4905)
,p_short_name=>'Principais Tags'
,p_link=>'f?p=&FLOW_ID.:145:&SESSION.'
,p_page_id=>145
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(471917025140272524.4905)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4905)
,p_short_name=>unistr('Principais Usu\00E1rios')
,p_link=>'f?p=&APP_ID.:146:&SESSION.::&DEBUG.:::'
,p_page_id=>146
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(472197018359897527.4905)
,p_parent_id=>wwv_flow_api.id(174562103281566299.4905)
,p_short_name=>unistr('Mover se\00E7\00E3o para p\00E1gina existente')
,p_link=>'f?p=&APP_ID.:990:&SESSION.::&DEBUG.:::'
,p_page_id=>990
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(472200003119943726.4905)
,p_parent_id=>wwv_flow_api.id(174562103281566299.4905)
,p_short_name=>unistr('Mover se\00E7\00E3o para nova p\00E1gina')
,p_link=>'f?p=&FLOW_ID.:991:&SESSION.'
,p_page_id=>991
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(472804624985588482.4905)
,p_parent_id=>wwv_flow_api.id(456715709817052851.4905)
,p_short_name=>'Sobre este Aplicativo'
,p_link=>'f?p=&FLOW_ID.:16:&SESSION.'
,p_page_id=>16
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(473082318328043502.4905)
,p_parent_id=>wwv_flow_api.id(187171813556872743.4905)
,p_short_name=>'Links'
,p_link=>'f?p=&FLOW_ID.:915:&SESSION.'
,p_page_id=>915
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(497240808682988557.4905)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4905)
,p_short_name=>unistr('Meus Relat\00F3rios Salvos')
,p_link=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.:::'
,p_page_id=>42
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(619997132010437333.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>'Selecionar Idioma'
,p_link=>'f?p=&FLOW_ID.:37:&SESSION.'
,p_page_id=>37
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(626920713710448375.4905)
,p_parent_id=>wwv_flow_api.id(473082318328043502.4905)
,p_short_name=>'Detalhes do Link'
,p_link=>'f?p=&FLOW_ID.:916:&SESSION.'
,p_page_id=>916
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(733378208922655612.4905)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4905)
,p_short_name=>'Alterar Senha'
,p_link=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::'
,p_page_id=>5
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_ws_three_columns
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3700422714748.4905)
,p_theme_id=>3
,p_name=>'[EBA] WS Three Columns.pt-br'
,p_internal_name=>'[EBA]_WS_THREE_COLUMNS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'		',
'	<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'			<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame">',
'<div class="ebaFrameHeader">',
'	<div class="wsToolbar">',
'		<div class="wsToolbarLeft">',
'#REGION_POSITION_02#',
'		</div>',
'		<div class="wsToolbarRight">',
'#REGION_POSITION_08#',
'		</div>',
'	</div>',
'	<div class="clear"></div>',
'</div> <!-- End .wsToolbar -->',
'<div class="ebaContentContainer">',
'#REGION_POSITION_04#',
'	<div class="ebaContent ebaOneCol">',
'#REGION_POSITION_03#',
'		<div class="ebaMainCol">',
'#BODY#',
'		</div>',
'		<div class="ebaSideCol">',
'#REGION_POSITION_05#',
'		</div>',
'	</div> <!-- End .ebaContent -->',
'</div> <!-- End .ebaContentContainer -->',
'#REGION_POSITION_07#',
'</div> <!-- End .ebaFrame -->',
'#REGION_POSITION_06#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/iframe_load_required_for_data_grid_file_upload
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3152608674388513.4905)
,p_theme_id=>3
,p_name=>'iframe load - Required for Data Grid File Upload.pt-br'
,p_internal_name=>'IFRAME_LOAD_REQUIRED_FOR_DATA_GRID_FILE_UPLOAD'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# style="margin:5px;"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>',
''))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'#REGION_POSITION_04#',
'#REGION_POSITION_05#',
'#BODY#',
'</div>',
'<div style="text-align:middle;">#REGION_POSITION_08#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="htmldbSuccessMessage">#SUCCESS_MESSAGE#</div>',
''))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="htmldbNotification">#MESSAGE#</div>',
''))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_ws_two_columns
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(9297021464956579.4905)
,p_theme_id=>3
,p_name=>'[EBA] WS Two Columns.pt-br'
,p_internal_name=>'[EBA]_WS_TWO_COLUMNS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame">',
'<div class="ebaFrameHeader">',
'	<div class="wsToolbar">',
'		<div class="wsToolbarLeft">',
'#REGION_POSITION_02#',
'		</div>',
'		<div class="wsToolbarRight">',
'#REGION_POSITION_08#',
'		</div>',
'	</div>',
'	<div class="clear"></div>',
'</div> <!-- End .wsToolbar -->',
'<div class="ebaContentContainer">',
'#REGION_POSITION_04#',
'	<div class="ebaContent ebaOneCol">',
'#REGION_POSITION_03#',
'		<div class="ebaMainCol">',
'#BODY#',
'		</div>',
'		<div class="ebaSideCol">',
'#REGION_POSITION_05#',
'		</div>',
'	</div> <!-- End .ebaContent -->',
'</div> <!-- End .ebaContentContainer -->',
'#REGION_POSITION_07#',
'</div> <!-- End .ebaFrame -->',
'#REGION_POSITION_06#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_ws_one_column
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(10606007362285088.4905)
,p_theme_id=>3
,p_name=>'[EBA] WS One Column.pt-br'
,p_internal_name=>'[EBA]_WS_ONE_COLUMN'
,p_is_popup=>false
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/apex/widget.stickyWidget.js',
'#IMAGE_PREFIX#libraries/apex/widget.stickyTableHeader.js'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// $(''.a-IRR-reportView'').setTableHeadersAsFixed();',
'//$(".js-stickyTableHeader").stickyWidget({',
'//   toggleWidth: true',
'//});'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/core/WizardSteps.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame">',
'<div class="ebaFrameHeader">',
'	<div class="wsToolbar">',
'		<div class="wsToolbarLeft">',
'#REGION_POSITION_02#',
'		</div>',
'		<div class="wsToolbarRight">',
'#REGION_POSITION_08#',
'		</div>',
'	</div>',
'	<div class="clear"></div>',
'</div> <!-- End .wsToolbar -->',
'<div class="ebaContentContainer">',
'#REGION_POSITION_04#',
'	<div class="ebaContent ebaOneCol">',
'#REGION_POSITION_03#',
'		<div class="wsPaddedContentContainer">',
'#BODY#',
'#REGION_POSITION_05#',
'		</div>',
'	</div> <!-- End .ebaContent -->',
'</div> <!-- End .ebaContentContainer -->',
'#REGION_POSITION_07#',
'</div> <!-- End .ebaFrame -->',
'#REGION_POSITION_06#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_help_pop_up
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(11249921373943607.4905)
,p_theme_id=>3
,p_name=>'[EBA] Help Pop Up.pt-br'
,p_internal_name=>'[EBA]_HELP_POP_UP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="wsPopup ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE." class="wsPopup"> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body #ONLOAD# class="wsPopup">',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="wsPopUpHeader">',
'#REGION_POSITION_02#',
'</div>',
'<div class="wsPopUpContent">',
'  <div class="wsSideCol">',
'#REGION_POSITION_03#',
'  </div>',
'  <div class="wsMainCol">',
'#BODY#',
'  </div>',
'<div class="clear"></div>',
'</div>',
'#REGION_POSITION_04#',
'#REGION_POSITION_05#',
'#REGION_POSITION_06#',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_ws_two_panel_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(15627530893704526.4905)
,p_theme_id=>3
,p_name=>'[EBA] WS Two Panel Page.pt-br'
,p_internal_name=>'[EBA]_WS_TWO_PANEL_PAGE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame">',
'<div class="ebaFrameHeader">',
'	<div class="wsToolbar">',
'		<div class="wsToolbarLeft">',
'#REGION_POSITION_02#',
'		</div>',
'		<div class="wsToolbarRight">',
'#REGION_POSITION_08#',
'		</div>',
'	</div>',
'	<div class="clear"></div>',
'</div> <!-- End .wsToolbar -->',
'<div class="ebaContentContainer">',
'#REGION_POSITION_03#',
'	<div class="ebaTwoColPane">',
'		<div class="ebaSideCol contentSection" id="wsSideCol">',
'					<h2 class="leftButtons">',
'			#REGION_POSITION_05#',
'					</h2>',
'			#REGION_POSITION_06#',
'		</div>',
'		<div class="ebaMainCol contentSection">',
'			#REGION_POSITION_04#',
'			<div class="ebaMainColContentContainer">',
'				<div class="ebaContent ebaOneCol">',
'					#BODY#',
'				</div> <!-- End .ebaContent .ebaOneCol -->',
'			</div> <!-- End .wsMainColContentContainer -->',
'		</div> <!-- End .ebaMainCol contentSection -->',
'	</div> <!-- End .ebaTwoColPane -->',
'</div> <!-- End .ebaContentContainer -->',
'#REGION_POSITION_07#',
'</div> <!-- End .ebaFrame -->'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_login_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(53193408981633671.4905)
,p_theme_id=>3
,p_name=>'[EBA] Login Page.pt-br'
,p_internal_name=>'[EBA]_LOGIN_PAGE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame ebaWizardFrame ebaLoginWizard">',
'<div class="ebaFrameHeader">',
'		<h1 class="oracleLogo">',
'			#LOGO#',
'		</h1>',
'		<div class="ebaProgressBar">',
'#REGION_POSITION_02#',
'		</div>',
'</div> <!-- End .ebaFrameHeader -->',
'<div class="ebaContentContainer">',
'	<div class="ebaContent">',
'<div class="websheetsIcon">',
'#REGION_POSITION_03#',
'</div>',
'<div class="loginFormFields">',
'#BODY#',
'</div>',
'	</div> <!-- End .ebaContent -->',
'</div> <!-- End .ebaContentContainer -->',
'	<div class="ebaFrameFooter">',
'#REGION_POSITION_04#',
'<span>',
'#REGION_POSITION_05#',
'</span>',
'	</div>',
'</div> <!-- End .ebaFrame -->',
'#REGION_POSITION_06#',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>6
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_presentation_view
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(75962824844186301.4905)
,p_theme_id=>3
,p_name=>'[EBA] Presentation View.pt-br'
,p_internal_name=>'[EBA]_PRESENTATION_VIEW'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_presentation.css" type="text/css" />',
'	<script src="#IMAGE_PREFIX#ws/js/ws_presentation.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div id="wspToolbar">',
'	#REGION_POSITION_01#',
'</div>',
'<div class="wspSectionContainer" aria-live="polite">',
'#BODY#',
'</div>',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'#REGION_POSITION_04#',
'#REGION_POSITION_05#',
'#REGION_POSITION_06#',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_pop_up
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(134255203486851095.4905)
,p_theme_id=>3
,p_name=>'[EBA] Pop Up.pt-br'
,p_internal_name=>'[EBA]_POP_UP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="wsPopup ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE." class="wsPopup"> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body #ONLOAD# class="wsPopup">',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="wsPopUpHeader">',
'#REGION_POSITION_02#',
'</div>',
'<div class="wsPopUpContent simplePopUp paddedPopUp">',
'  <div class="wsMainCol">',
'#BODY#',
'  </div>',
'<div class="clear"></div>',
'</div>',
'#REGION_POSITION_04#',
'#REGION_POSITION_05#',
'#REGION_POSITION_06#',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_0_websheets_printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(636311004626147097.4905)
,p_theme_id=>3
,p_name=>'APEX 4.0 - WEBSHEETS (printer friendly).pt-br'
,p_internal_name=>'APEX_4.0_WEBSHEETS_PRINTER_FRIENDLY'
,p_is_popup=>false
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'div.wsSection h2 span,',
'div.wsFooter ul.wsViewModes,',
'span.wsBreadcrumbBarLinks,',
'div.wsSection h2 a.wsSectionControl,',
'.ebaHeader ul,',
'.ebaFrameHeader,',
'.wsSideSection {',
'    display: none !important;',
'}',
'body .ebaHeader h1 a {',
'    color: #000;',
'    text-shadow: none;',
'}',
'body .ebaHeader {',
'    background: none #F8FBFF;',
'}',
'body div.wsBreadcrumb>ul>li>a {',
'    border: none;',
'}'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#libraries/jquery-qtip2/2.0-6.26.2011/jquery.qtip.min.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame">',
'<div class="ebaFrameHeader">',
'	<div class="wsToolbar">',
'		<div class="wsToolbarLeft">',
'#REGION_POSITION_02#',
'		</div>',
'		<div class="wsToolbarRight">',
'#REGION_POSITION_08#',
'		</div>',
'	</div>',
'	<div class="clear"></div>',
'</div> <!-- End .wsToolbar -->',
'<div class="ebaContentContainer">',
'#REGION_POSITION_04#',
'	<div class="ebaContent ebaOneCol">',
'#REGION_POSITION_03#',
'		<div class="wsPaddedContentContainer">',
'#BODY#',
'#REGION_POSITION_05#',
'		</div>',
'	</div> <!-- End .ebaContent -->',
'</div> <!-- End .ebaContentContainer -->',
'#REGION_POSITION_07#',
'</div> <!-- End .ebaFrame -->',
'#REGION_POSITION_06#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>',
''))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_websheets_sign_in_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1418140425267007336.4905)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Websheets Sign In Page.pt-br'
,p_internal_name=>'APEX_5.0_WEBSHEETS_SIGN_IN_PAGE'
,p_is_popup=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$(function() {',
'  $(''a[href*="#"]:not([href="#"])'').click(function() {',
'    if (location.pathname.replace(/^\//,'''') == this.pathname.replace(/^\//,'''') && location.hostname == this.hostname) {',
'      var target = $(this.hash);',
'      target = target.length ? target : $(''[name="'' + this.hash.slice(1) +''"]'');',
'      if (target.length) {',
'        $(''html,body'').animate({',
'          scrollTop: target.offset().top',
'        }, 500);',
'        return false;',
'      }',
'    }',
'  });',
'});'))
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--login #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'<div class="u-Layout u-Layout--centerVertically a-Login-slide" id="top">',
'  #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Login-container">',
'  #BODY#',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_image_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(3791820543327.4905)
,p_template_name=>'HTML image (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_IMAGE_LEGACY_APEX_5_MIGRATION'
,p_template=>'<a href="#LINK#" id="#BUTTON_ID#" title="#LABEL!ATTR#"><img src="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" border="#" #BUTTON_ATTRIBUTES# /></a>'
,p_hot_template=>'<a href="#LINK#" id="#BUTTON_ID#" title="#LABEL!ATTR#"><img src="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" border="#" #BUTTON_ATTRIBUTES# /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_title_add_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(9301120013126533.4905)
,p_template_name=>'[EBA] Title - Add Button'
,p_internal_name=>'[EBA]_TITLE_ADD_BUTTON'
,p_template=>'<a href="#LINK#" class="ebaTitleButton" role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="addIcon" #BUTTON_ATTRIBUTES# id="#BUTTON_ID" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_title_view_all_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(9301209409132905.4905)
,p_template_name=>'[EBA] Title - View All Button'
,p_internal_name=>'[EBA]_TITLE_VIEW_ALL_BUTTON'
,p_template=>'<a href="#LINK#" class="ebaTitleButton" role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="viewAllIcon" #BUTTON_ATTRIBUTES# id="#BUTTON_ID" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_hot_button_next
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(10604003722246228.4905)
,p_template_name=>'[EBA] Hot Button (Next)'
,p_internal_name=>'[EBA]_HOT_BUTTON_NEXT'
,p_template=>'<a href="#LINK#" class="ebaHotButton ebaNextButton" role="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" alt="" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(15106902867837483.4905)
,p_template_name=>'[EBA] Button'
,p_internal_name=>'[EBA]_BUTTON'
,p_template=>'<a href="#LINK#" class="ebaButton" id="#BUTTON_ID#" role="button" #BUTTON_ATTRIBUTES#>#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_hot_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(15108012910840408.4905)
,p_template_name=>'[EBA] Hot Button'
,p_internal_name=>'[EBA]_HOT_BUTTON'
,p_template=>'<a href="#LINK#" class="ebaHotButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_button_delete
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(15160928947568323.4905)
,p_template_name=>'[EBA] Button (Delete)'
,p_internal_name=>'[EBA]_BUTTON_DELETE'
,p_template=>'<a href="#LINK#" class="ebaButton ebaDeleteButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_title_options_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(15650119453846225.4905)
,p_template_name=>'[EBA] Title - Options Button'
,p_internal_name=>'[EBA]_TITLE_OPTIONS_BUTTON'
,p_template=>'<a href="#LINK#" class="ebaTitleButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><img src="#IMAGE_PREFIX#f_spacer.gif" class="addIcon" #BUTTON_ATTRIBUTES# id="#BUTTON_ID" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_title_back_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(15650219931855856.4905)
,p_template_name=>'[EBA] Title - Back Button '
,p_internal_name=>'[EBA]_TITLE_BACK_BUTTON_'
,p_template=>'<a href="#LINK#" class="ebaTitleButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><img src="#IMAGE_PREFIX#f_spacer.gif" class="backIcon"/></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_title_expand_collapse_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(16714408571357214.4905)
,p_template_name=>'[EBA] Title - Expand/Collapse Button '
,p_internal_name=>'[EBA]_TITLE_EXPAND/COLLAPSE_BUTTON_'
,p_template=>'<a href="#LINK#" class="ebaTitleButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" title="#LABEL!ATTR#"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideIcon" alt="#LABEL!ATTR#" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_small_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(20457218105321816.4905)
,p_template_name=>'[EBA] Small Button'
,p_internal_name=>'[EBA]_SMALL_BUTTON'
,p_template=>'<a href="#LINK#" class="wsSmallButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_small_hot_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(20480423759330923.4905)
,p_template_name=>'[EBA] Small Hot Button'
,p_internal_name=>'[EBA]_SMALL_HOT_BUTTON'
,p_template=>'<a href="#LINK#" class="wsSmallButton wsHotButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>4
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_small_button_previous
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(20890400835826116.4905)
,p_template_name=>'[EBA] Small Button (Previous)'
,p_internal_name=>'[EBA]_SMALL_BUTTON_PREVIOUS'
,p_template=>'<a href="#LINK#" class="wsSmallButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="smallPrevIcon" /> #LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_small_hot_button_next
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(20890726723852448.4905)
,p_template_name=>'[EBA] Small Hot Button (Next) '
,p_internal_name=>'[EBA]_SMALL_HOT_BUTTON_NEXT_'
,p_template=>'<a href="#LINK#" class="wsSmallButton wsHotButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML# <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="smallNextIcon" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_small_button_next
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(20905523503069232.4905)
,p_template_name=>'[EBA] Small Button (Next) '
,p_internal_name=>'[EBA]_SMALL_BUTTON_NEXT_'
,p_template=>'<a href="#LINK#" class="wsSmallButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML# <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="smallNextIcon" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_button_previous
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(61282809984809202.4905)
,p_template_name=>'[EBA] Button (Previous)'
,p_internal_name=>'[EBA]_BUTTON_PREVIOUS'
,p_template=>'<a href="#LINK#" class="ebaButton ebaPrevButton" role="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_button_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(629231036412957099.4905)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_BUTTON_LEGACY_APEX_5_MIGRATION'
,p_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(798473351219404350.4905)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4905
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(936712837989177653.4905)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4905
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(936746267011392790.4905)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4905
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/div_with_id
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3700433754276.4905)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'Div with ID'
,p_internal_name=>'DIV_WITH_ID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>7
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_ws_side_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(9299916504097072.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsSideSection">',
'	<h3>#TITLE#',
'		<span>',
'		#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#',
'		</span>',
'	</h3>',
'	#BODY#',
'</div>'))
,p_page_plug_template_name=>'[EBA] WS Side Region'
,p_internal_name=>'[EBA]_WS_SIDE_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(10604720260269861.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsButtonBar">',
'#BODY##CLOSE##EDIT##DELETE##PREVIOUS##CREATE##CHANGE##CREATE2##EXPAND##HELP##COPY##NEXT#</div>'))
,p_page_plug_template_name=>'[EBA] Button Region'
,p_internal_name=>'[EBA]_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_collapsable_text_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(11269620137104105.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsSection" id="#REGION_STATIC_ID#"> <!-- Begin .wsSection -->',
'	<h2><a href="javascript:void(0)" class="wsSectionControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&COLLAPSE." /></a>',
'		#TITLE#',
'		<span>',
'			<a href="#" class="wsSectionLink wsTopLink" title="&GO_TO_TOP."><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&GO_TO_TOP." class="topIcon" /></a>',
'		</span>',
'	</h2>',
'	<div class="wsSectionContent">',
'		<div class="wsTextSection #REGION_ATTRIBUTES#">',
'			#BODY#',
'		</div>',
'	</div>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Collapsable Text Region'
,p_internal_name=>'[EBA]_COLLAPSABLE_TEXT_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_two_col_pane_heading_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(15634208564734334.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 #REGION_ATTRIBUTES#>',
'	<span class="leftButtons">',
'		#PREVIOUS#',
'	</span>',
'	#TITLE#',
'	<span>',
'		#EDIT##CLOSE##DELETE##CREATE##CREATE2##EXPAND##HELP##COPY##NEXT#',
'	</span>',
'</h2>',
'#BODY#'))
,p_page_plug_template_name=>'[EBA] Two Col Pane Heading Region'
,p_internal_name=>'[EBA]_TWO_COL_PANE_HEADING_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_two_col_pane_heading_left_col_with_control_menu
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(17121518626936007.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="leftButtons" #REGION_ATTRIBUTES#>#PREVIOUS##EXPAND##EDIT##CLOSE##DELETE##CREATE##CREATE2##HELP##COPY##NEXT# </span>',
'#TITLE#<span class="rightButtons" #REGION_ATTRIBUTES#>#CHANGE#</span>'))
,p_page_plug_template_name=>'[EBA] Two Col Pane Heading (Left Col with Control Menu)'
,p_internal_name=>'[EBA]_TWO_COL_PANE_HEADING_LEFT_COL_WITH_CONTROL_MENU'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_form_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(20185117556737935.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsFormRegion">',
'#BODY#',
'</div>'))
,p_page_plug_template_name=>'[EBA] Form Region'
,p_internal_name=>'[EBA]_FORM_REGION'
,p_theme_id=>3
,p_theme_class_id=>8
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_action_bar_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(20454830409304572.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsActionBar">',
'#PREVIOUS#',
'#BODY#',
'<span class="wsActionBarRight">',
'#CLOSE##EDIT##DELETE##CREATE##CREATE2##EXPAND##HELP##COPY##NEXT#',
'</span>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Action Bar Top'
,p_internal_name=>'[EBA]_ACTION_BAR_TOP'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_action_bar_bottom
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(20910304550120452.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsActionBar wsActionBarBottom">',
'<div class="wsActionBarInside">',
'#PREVIOUS#',
'#BODY#',
'<span class="wsActionBarRight">',
'#CLOSE##EDIT##DELETE##CREATE##CREATE2##EXPAND##HELP##COPY##NEXT#',
'</span>',
'</div>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Action Bar Bottom'
,p_internal_name=>'[EBA]_ACTION_BAR_BOTTOM'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_interactive_report_with_no_action_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(20956911766368602.4905)
,p_layout=>'TABLE'
,p_template=>'<div class="wsInteractiveReportOnly" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'[EBA] Interactive Report with No Action Bar'
,p_internal_name=>'[EBA]_INTERACTIVE_REPORT_WITH_NO_ACTION_BAR'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_action_bar_only
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(25109627701530900.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsActionBar wsActionBarOnly" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'#PREVIOUS#',
'#BODY#',
'<span class="wsActionBarRight">',
'#CLOSE##EDIT##DELETE##CREATE##CREATE2##EXPAND##HELP##COPY##NEXT#',
'</span>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Action Bar Only'
,p_internal_name=>'[EBA]_ACTION_BAR_ONLY'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_collapsable_form_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(27071223638280295.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsSection"> <!-- Begin .wsSection -->',
'	<h2><a href="javascript:void(0)" class="wsSectionControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&COLLAPSE." /></a>',
'		#TITLE#',
'		<span>',
'			<a href="#" class="wsSectionLink wsTopLink" title="&GO_TO_TOP."><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&GO_TO_TOP." class="topIcon" /></a>',
'		</span>',
'	</h2>',
'	<div class="wsSectionContent">',
'		<div class="wsFormRegion">',
'			#BODY#',
'		</div>',
'	</div>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Collapsable Form Region '
,p_internal_name=>'[EBA]_COLLAPSABLE_FORM_REGION_'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_collapsable_form_region_collapsed
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(47316730240795884.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsSection"> <!-- Begin .wsSection -->',
'	<h2><a href="javascript:void(0)" class="wsSectionControl wsSectionCollapsed"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&COLLAPSE." /></a>',
'		#TITLE#',
'		<span>',
'			<a href="#" class="wsSectionLink wsTopLink" title="&GO_TO_TOP."><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&GO_TO_TOP." class="topIcon" /></a>',
'		</span>',
'	</h2>',
'	<div class="wsSectionContent" style="display: none">',
'		<div class="wsFormRegion">',
'			#BODY#',
'		</div>',
'	</div>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Collapsable Form Region (Collapsed) '
,p_internal_name=>'[EBA]_COLLAPSABLE_FORM_REGION_COLLAPSED_'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_small_form_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(82536903857665765.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsFormRegion wsSmallFormRegion">',
'#BODY#',
'</div>'))
,p_page_plug_template_name=>'[EBA] Small Form Region'
,p_internal_name=>'[EBA]_SMALL_FORM_REGION'
,p_theme_id=>3
,p_theme_class_id=>8
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_small_form_component_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(108051114664442909.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsSmallFormComponent wsSmallFormComponentLeft" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'#PREVIOUS#',
'#BODY#',
'#CLOSE##EDIT##DELETE##CREATE##CREATE2##EXPAND##HELP##COPY##NEXT#',
'</div>'))
,p_page_plug_template_name=>'[EBA] Small Form Component Left'
,p_internal_name=>'[EBA]_SMALL_FORM_COMPONENT_LEFT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/dhtml_hidden_with_id_required_for_data_grid_file_upload
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(173336062654423126.4905)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#" style="display:none;">#BODY#</div>'
,p_page_plug_template_name=>'(DHTML) Hidden with ID (Required for Data Grid File Upload)'
,p_internal_name=>'DHTML_HIDDEN_WITH_ID_REQUIRED_FOR_DATA_GRID_FILE_UPLOAD'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_toolbar_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(202707431395573866.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsMenu" id="#REGION_STATIC_ID#">',
'#BODY#',
'</div>'))
,p_page_plug_template_name=>'[EBA] Toolbar Container'
,p_internal_name=>'[EBA]_TOOLBAR_CONTAINER'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/div_with_id_required_for_edit_report_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(400020739576925060.4905)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'Div  with ID ( Required for Edit Report Attributes)'
,p_internal_name=>'DIV_WITH_ID_REQUIRED_FOR_EDIT_REPORT_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>7
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(931543191007401308.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>746362351042209764.4905
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_no_template
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1071999318750156264.4905)
,p_layout=>'TABLE'
,p_template=>'#BODY#'
,p_page_plug_template_name=>'[EBA] No Template'
,p_internal_name=>'[EBA]_NO_TEMPLATE'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1332151043262185426.4905)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4905
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_workspace_login_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1418149362592020763.4905)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Login-body">',
'  #BODY#',
'</div>',
'<div class="a-Login-buttons">',
'  #NEXT#',
'</div>',
'<div class="a-Login-links">',
'  #EDIT##CREATE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Workspace Login Region'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>781637364422290692.4905
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_toolbar_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(9301809587170761.4905)
,p_list_template_current=>'<li class="#A01#"><a href="javascript:void(0)" id="#A03#">#TEXT#<img src="#IMAGE_PREFIX#ws/img/spacer.gif" alt="" /></a></li>'
,p_list_template_noncurrent=>'<li class="#A01#"><a href="javascript:void(0)" id="#A03#">#TEXT#<img src="#IMAGE_PREFIX#ws/img/spacer.gif" alt="" /></a></li>'
,p_list_template_name=>'[EBA] Toolbar Menu '
,p_internal_name=>'[EBA]_TOOLBAR_MENU_'
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>' '
,p_list_template_after_rows=>' '
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_noncurrent=>'<li class="#A01#"><a href="#LINK#" class="wsMenuItem #A04#">#TEXT#<span>#A02#</span></a></li>'
,p_item_templ_curr_w_child=>'<li class="#A01#"><a href="javascript:void(0)" id="#A03#">#TEXT#<img src="#IMAGE_PREFIX#ws/img/spacer.gif" alt="" /></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="#A01#"><a href="javascript:void(0)" id="#A03#">#TEXT#<img src="#IMAGE_PREFIX#ws/img/spacer.gif" alt="" /></a>#SUB_LISTS#</li>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_pop_up_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(11252405836967523.4905)
,p_list_template_current=>'--><li class="active"><a href="#LINK#">#TEXT#</a></li><!--'
,p_list_template_noncurrent=>'--><li><a href="#LINK#">#TEXT#</a></li><!--'
,p_list_template_name=>'[EBA] Pop Up Tabs'
,p_internal_name=>'[EBA]_POP_UP_TABS'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsTabs">',
'  <ul><!-- '))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'--><li class="searchBox">',
'    <div class="wsSearch" style="display: none;">',
'      <input type="text" id="wsSearchBar"/>',
'      <span></span>',
'    </div>',
'  </li>',
'</ul>',
'</div>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_pop_up_side_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(11270206893119252.4905)
,p_list_template_current=>'<li><a href="#LINK#" class="active">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'[EBA] Pop Up Side Navigation'
,p_internal_name=>'[EBA]_POP_UP_SIDE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_left_pane_sections_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(15654631677982271.4905)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="javascript:applyAndGoToNextSection(''&APP_PAGE_ID.'',''#A06#'',''#A07#'',''#A08#'');" class="#A05#" title="#A02#">',
'		<span><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" alt="#A02#" /></span>',
'		<h3>#TEXT_ESC_SC#',
'			<em>#A03# &mdash; #A04#</em></h3>',
'	</a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="#LINK#">',
'		<span><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" alt="#A02#" /></span>',
'		<h3>#TEXT_ESC_SC#',
'			<em>#A03# &mdash; #A04#</em></h3>',
'	</a>',
'</li>'))
,p_list_template_name=>'[EBA] Left Pane Sections List'
,p_internal_name=>'[EBA]_LEFT_PANE_SECTIONS_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<ul class="sectionList">'
,p_list_template_after_rows=>' </ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_heading_control_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(17118702088912337.4905)
,p_list_template_current=>'<a href="#LINK#" class="ebaTitleButton"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" alt="#TEXT#" title="#TEXT#"/></a>'
,p_list_template_noncurrent=>'<a href="#LINK#" class="ebaTitleButton"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#"  alt="#TEXT#" title="#TEXT#"/></a>'
,p_list_template_name=>'[EBA] Heading Control Menu'
,p_internal_name=>'[EBA]_HEADING_CONTROL_MENU'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<span class="controlMenus">'
,p_list_template_after_rows=>' </span>'
,p_before_sub_list=>'<div class="panelMenuContainer"><div class="panelMenu"><ul>'
,p_after_sub_list=>'</ul></div></div>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<a href="#LINK#" class="ebaTitleButton controlMenu"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" alt="#TEXT#" title="#TEXT#"/></a>'
,p_item_templ_noncurr_w_child=>'<a href="#LINK#" class="ebaTitleButton controlMenu"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" alt="#TEXT#" title="#TEXT#"/></a>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_horizontal_progress_bar_train
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(17197023652325418.4905)
,p_list_template_current=>'<li class="currentStep"><span></span></li>'
,p_list_template_noncurrent=>'<li><span></span></li>'
,p_list_template_name=>'[EBA] Horizontal Progress Bar Train'
,p_internal_name=>'[EBA]_HORIZONTAL_PROGRESS_BAR_TRAIN'
,p_theme_id=>3
,p_theme_class_id=>17
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="ebaProgressWizard">',
''))
,p_list_template_after_rows=>' </ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_left_pane_pages_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(18574125863745642.4905)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="#LINK#" class="#A04#">',
'		<span><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" /></span>',
'		<h3>#TEXT#',
'			<em>#A02# &mdash; #A03#</em></h3>',
'	</a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="#LINK#">',
'		<span><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" /></span>',
'		<h3>#TEXT#',
'			<em>#A02# &mdash; #A03#</em></h3>',
'	</a>',
'</li>'))
,p_list_template_name=>'[EBA] Left Pane Pages List '
,p_internal_name=>'[EBA]_LEFT_PANE_PAGES_LIST_'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<ul class="sectionList">'
,p_list_template_after_rows=>' </ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_unformatted_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(20455926267312733.4905)
,p_list_template_current=>'<li><a href="#LINK#" class="active">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'[EBA] Unformatted List'
,p_internal_name=>'[EBA]_UNFORMATTED_LIST'
,p_theme_id=>3
,p_theme_class_id=>3
,p_list_template_before_rows=>' <ul>'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_large_icons_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(138239722779443444.4905)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_name=>'[EBA] Large Icons List'
,p_internal_name=>'[EBA]_LARGE_ICONS_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table class="ebaLargeIcons" width="100%" cellspacing="0" cellpadding="0" border="0" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist_from_4999
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(156210646767386810.4905)
,p_list_template_current=>'<div class="dhtmlMenuItem"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#ws/dropdown_32x24.gif" width="32" height="24" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#L'
||'IST_ITEM_ID#'',false)" alt=""/><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_list_template_noncurrent=>'<div class="dhtmlMenuItem"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_list_template_name=>'DHTML List (Image) with Sublist from 4999'
,p_internal_name=>'DHTML_LIST_IMAGE_WITH_SUBLIST_FROM_4999'
,p_theme_id=>3
,p_theme_class_id=>4
,p_list_template_before_rows=>'<div class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">',
'<li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>'))
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" />#TEXT#</li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />#TEXT#</a></li>'
,p_item_templ_noncurr_w_child=>'<div class="dhtmlMenuItem"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="dhtmlMenu" onclick="ws_Pd(this,''#LIST_ITEM_ID#'',false)" alt=""/><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /><span>#TEXT#</span><img class="htmldbMIMG" alt="" s'
||'rc="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#" style="background-image:url(#IMAGE_PREFIX#menu_open_right2.gif);background-repeat:no-repeat;background-position:95% cente'
||'r;"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />#TEXT#</a></li>'
,p_list_template_comment=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />#TEXT#</span><img class="htmldbMIMG" alt="" s'
||'rc="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_left_pane_pages_list_new
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(158861503239501998.4905)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03#">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="-" /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03#">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="-" /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_list_template_name=>'[EBA] Left Pane Pages List [NEW]'
,p_internal_name=>'[EBA]_LEFT_PANE_PAGES_LIST_[NEW]'
,p_theme_id=>3
,p_theme_class_id=>19
,p_list_template_before_rows=>' <ul class="pageList" id="pageList">'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03#">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="-" /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03#">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="-" /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03# containsSubList">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl expanded"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&EXPANDED." /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03# containsSubList">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl expanded"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&EXPANDED." /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03# containsSubList">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl expanded"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&EXPANDED." /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03# containsSubList">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl expanded"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&EXPANDED." /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_websheets_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(929122129315135247.4905)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Websheets Menu'
,p_internal_name=>'APEX_5.0_WEBSHEETS_MENU'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>' '
,p_list_template_after_rows=>' '
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>926415475390827132.4905
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(936708315591140469.4905)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4905
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1338174060370978758.4905)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4905
);
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_report_sortable
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(46784125242633572.4905)
,p_row_template_name=>'[EBA] Report (Sortable)'
,p_internal_name=>'[EBA]_REPORT_SORTABLE'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>'<table class="wsStandardReport wsTable" summary="" cellspacing="0" cellpadding="0" id="r#REGION_ID#"><tbody>'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>',
'<script>',
'var g_#REGION_ID#;',
'function f_#REGION_ID#(){',
'		g_#REGION_ID# =  new apex.tabular.sort(''r#REGION_ID#'');',
'		g_#REGION_ID#.row.after_move = function(){rpreview()}',
'}',
'addLoadEvent(f_#REGION_ID#)',
'</script>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#EEE'
,p_row_style_checked=>'#EEE'
,p_theme_id=>3
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(46784125242633572.4905)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(129228711620465473.4905)
,p_row_template_name=>'[EBA] Report'
,p_internal_name=>'[EBA]_REPORT'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>'<table class="wsStandardReport wsTable" summary="" cellspacing="0" cellpadding="0" id="r#REGION_ID#"><tbody>'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#EEE'
,p_row_style_checked=>'#EEE'
,p_theme_id=>3
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(129228711620465473.4905)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_portlet_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(171646109232237656.4905)
,p_row_template_name=>'[EBA] Portlet Column'
,p_internal_name=>'[EBA]_PORTLET_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4905
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_portlet_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(171646521495237685.4905)
,p_row_template_name=>'[EBA] Portlet Row'
,p_internal_name=>'[EBA]_PORTLET_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr>',
'<th><label>#1#</label></th>',
'<td>#2#</td>',
'</tr>'))
,p_row_template_before_rows=>'<table class="wsTable wsPortlet" #REPORT_ATTRIBUTES# id="#REGION_ID#">'
,p_row_template_after_rows=>'</table>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(5556614497310460.4905)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4905
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/eba_optional_w_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(11461002620401386.4905)
,p_template_name=>'[EBA] Optional w/ Help'
,p_internal_name=>'[EBA]_OPTIONAL_W/_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="wsOptional">'
,p_template_body2=>'</label>'
,p_after_element=>'#HELP_TEMPLATE#'
,p_help_link=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button">',
'    <span class="a-Icon icon-help"></span>',
'    <span class="u-VisuallyHidden">#CURRENT_ITEM_HELP_LABEL#</span>',
'</button>'))
,p_on_error_after_label=>'<span class="wsLabelError">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/eba_required_w_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(11461206197401386.4905)
,p_template_name=>'[EBA] Required w/ Help'
,p_internal_name=>'[EBA]_REQUIRED_W/_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="wsRequired">'
,p_template_body2=>' <img src="#IMAGE_PREFIX#f_spacer.gif" alt="#VALUE_REQUIRED#" class="wsAsterisk" /></label>'
,p_after_element=>'#HELP_TEMPLATE#'
,p_help_link=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button">',
'    <span class="a-Icon icon-help"></span>',
'    <span class="u-VisuallyHidden">#CURRENT_ITEM_HELP_LABEL#</span>',
'</button>'))
,p_on_error_after_label=>'<span class="wsLabelError">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_workspace_login_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(264000229814622656.4905)
,p_template_name=>'Login Hidden Label'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_HIDDEN_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Icon a-Login-iconLabel a-Login-hiddenLabel u-VisuallyHidden">'
,p_template_body2=>'</label>'
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--hiddenLabel #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#"><div class="a-Form-inputContainer">'
,p_after_item=>'#HELP_TEMPLATE#</div></div>'
,p_after_element=>'#ERROR_TEMPLATE#'
,p_help_link=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button">',
'    <span class="a-Icon icon-help"></span>',
'    <span class="u-VisuallyHidden">#CURRENT_ITEM_HELP_LABEL#</span>',
'</button>'))
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_workspace_login_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1418153120551046350.4905)
,p_template_name=>'APEX 5.0 - Workspace Login Label'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Icon a-Login-iconLabel">'
,p_template_body2=>'</label>'
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#"><div class="a-Form-inputContainer">'
,p_after_item=>'</div></div>'
,p_after_element=>'<span class="a-Login-iconValidation a-Icon icon-check"></span>#ERROR_TEMPLATE#'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help"></span><span class="u-VisuallyHidden">#CURRENT_ITE'
||'M_HELP_LABEL#</span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>781637020106265852.4905
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/eba_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(20175617163709368.4905)
,p_name=>'[EBA] Breadcrumbs'
,p_internal_name=>'[EBA]_BREADCRUMBS'
,p_before_first=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsBreadcrumb wsBreadcrumbSubPage" id="wsBreadcrumb">',
'<ul class="ws-Breadcrumb">',
''))
,p_current_page_option=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="#LINK#">#NAME# <span class="a-Icon icon-right-chevron"></span></a>',
'</li>',
''))
,p_non_current_page_option=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="#LINK#">#NAME# <span class="a-Icon icon-right-chevron"></span></a>',
'</li>',
''))
,p_after_last=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'</div>'))
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(165003451930708292.4905)
,p_popup_icon=>'#IMAGE_PREFIX#htmldb/icons/view_small.gif'
,p_popup_icon_attr=>'width="18" height="18" alt="#LIST_OF_VALUES#" title="#LIST_OF_VALUES#"'
,p_page_name=>'winlov'
,p_page_title=>'Pesquisar'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<!--[if IE]><meta http-equiv="X-UA-Compatible" content="IE=edge" /><![endif]-->',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'<!--[if IE 7]>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'<![endif]-->',
'<!--[if IE 8]>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'<![endif]-->',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'class="wsPopUpLOV"'
,p_before_field_text=>'<div class="wsActionBar wsActionBarOnly">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="searchField"'
,p_find_button_text=>'Pesquisar'
,p_find_button_attr=>'class="smallButton"'
,p_close_button_text=>'Fechar'
,p_close_button_attr=>'class="smallButton hotButton"'
,p_next_button_text=>unistr('Pr\00F3ximo >')
,p_next_button_attr=>'class="smallButton"'
,p_prev_button_text=>'< Anterior'
,p_prev_button_attr=>'class="smallButton"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'500'
,p_result_row_x_of_y=>'<div class="lovPagination">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="lovLinks">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/eba_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(20940421004163137.4905)
,p_cal_template_name=>'[EBA] Calendar'
,p_internal_name=>'[EBA]_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="CalendarHolder"> ',
' <tr>',
'   <td class="MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="WeekCalendarHolder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="Today">'
,p_daily_time_open_format=>'<th scope="row" class="Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(931574038306409142.4905)
,p_theme_id=>3
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(931574723130409146.4905)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(936751341799414713.4905)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931573772023409139.4905)
,p_theme_id=>3
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4905)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931573860104409140.4905)
,p_theme_id=>3
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4905)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931574184140409145.4905)
,p_theme_id=>3
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4905)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_api.id(931574038306409142)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931574386836409146.4905)
,p_theme_id=>3
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4905)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_api.id(931574038306409142)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931574519466409146.4905)
,p_theme_id=>3
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4905)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_api.id(931574038306409142)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931574894275409146.4905)
,p_theme_id=>3
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4905)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(931574723130409146)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931575094854409146.4905)
,p_theme_id=>3
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4905)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_api.id(931574723130409146)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931575149476409146.4905)
,p_theme_id=>3
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4905)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931575333122409146.4905)
,p_theme_id=>3
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4905)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_api.id(931574038306409142)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(936709001085140492.4905)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(936708315591140469.4905)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(936709194813140492.4905)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(936708315591140469.4905)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1338174721014978766.4905)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4905)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554832103532526804.4905)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(1332151043262185426.4905)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554832278061526804.4905)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1332151043262185426.4905)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554832317693526804.4905)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1332151043262185426.4905)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(239986615251259134.4905)
,p_build_option_name=>'Do Not Include in APEX 4.2 EA1'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286612337226883137)
,p_name=>'ADD'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286610452179883135)
,p_name=>'ADD_COLUMN'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Coluna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286611655919883136)
,p_name=>'ADD_FILE'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Arquivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286611866907883136)
,p_name=>'ADD_LINK'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Link'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286611797337883136)
,p_name=>'ADD_NOTE'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Adicionar Observa\00E7\00E3o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286612588627883137)
,p_name=>'ADD_ROW'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Linha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286611952797883136)
,p_name=>'ADD_TAGS'
,p_message_language=>'pt-br'
,p_message_text=>'Adicionar Tags'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286610154989883135)
,p_name=>'APPLY'
,p_message_language=>'pt-br'
,p_message_text=>'Aplicar'
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286609959967883135)
,p_name=>'CANCEL'
,p_message_language=>'pt-br'
,p_message_text=>'Cancelar'
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286612281497883136)
,p_name=>'COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Colunas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286610763069883136)
,p_name=>'COLUMN_GROUPS'
,p_message_language=>'pt-br'
,p_message_text=>'Grupos de Colunas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286610582478883135)
,p_name=>'COLUMN_PROPERTIES'
,p_message_language=>'pt-br'
,p_message_text=>'Propriedades da Coluna'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286610287156883135)
,p_name=>'COPY'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286611464604883136)
,p_name=>'COPY_DATA_GRID'
,p_message_language=>'pt-br'
,p_message_text=>'Copiar Grade de Dados'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286610328570883135)
,p_name=>'DATA_GRID_PROPERTIES'
,p_message_language=>'pt-br'
,p_message_text=>'Propriedades de Grade de Dados'
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286610055009883135)
,p_name=>'DELETE'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286610951017883136)
,p_name=>'DELETE_COLUMNS'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Colunas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286611520872883136)
,p_name=>'DELETE_DATA_GRID'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Grade de Dados'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286611302756883136)
,p_name=>'DELETE_ROWS'
,p_message_language=>'pt-br'
,p_message_text=>'Excluir Linhas'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286612715524883137)
,p_name=>'EDIT_ATTRIBUTES'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Atributos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286612850058883137)
,p_name=>'EDIT_QUERY'
,p_message_language=>'pt-br'
,p_message_text=>'Editar Consulta'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286611249809883136)
,p_name=>'FILL'
,p_message_language=>'pt-br'
,p_message_text=>'Preencher'
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286612602512883137)
,p_name=>'HISTORY'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Hist\00F3rico')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286610697329883135)
,p_name=>'LIST_OF_VALUES'
,p_message_language=>'pt-br'
,p_message_text=>'Lista de Valores'
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286612036527883136)
,p_name=>'PROPERTIES'
,p_message_language=>'pt-br'
,p_message_text=>'Propriedades'
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286611176353883136)
,p_name=>'REPLACE'
,p_message_language=>'pt-br'
,p_message_text=>'Substituir'
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286612466689883137)
,p_name=>'ROWS'
,p_message_language=>'pt-br'
,p_message_text=>'Linhas'
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286611042493883136)
,p_name=>'SET_COLUMN_VALUES'
,p_message_language=>'pt-br'
,p_message_text=>'Definir Valores de Coluna'
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286612165926883136)
,p_name=>'TOGGLE_CHECKBOXES'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Alternar Caixas de Sele\00E7\00E3o')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286610878033883136)
,p_name=>'VALIDATION'
,p_message_language=>'pt-br'
,p_message_text=>unistr('Valida\00E7\00E3o')
,p_is_js_message=>true
);
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(7176806101815144.4905)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('Tem certeza de que deseja sair desta p\00E1gina sem salvar?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(155157613934985128.4905)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('Gostaria de executar esta a\00E7\00E3o de exclus\00E3o?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/pick_ws_rpt_col_name
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(184021228934805221.4905)
,p_shortcut_name=>'PICK_WS_RPT_COL_NAME'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3050:&SESSION.::::P3050_CALLING_ITEM,P3050_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3010_LB_WS_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0" w'
||'idth="18" height="18" alt="flashlight" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/pick_ws_rpt_col_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(185539627466561397.4905)
,p_shortcut_name=>'PICK_WS_RPT_COL_VALUE'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3040:&SESSION.::::P3040_CALLING_ITEM,P3040_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3010_WEBSHEET_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0'
||'" width="18" height="18" alt="flashlight" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/pick_curr_ws_rpt_col
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(185548307614697562.4905)
,p_shortcut_name=>'PICK_CURR_WS_RPT_COL'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3040:&SESSION.::::P3040_CALLING_ITEM,P3040_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3010_WEBSHEET_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0'
||'" width="18" height="18" alt="flashlight" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/p3020_pick_curr_ws_rpt_col
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(187888728094279874.4905)
,p_shortcut_name=>'P3020_PICK_CURR_WS_RPT_COL'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3040:&SESSION.::::P3040_CALLING_ITEM,P3040_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3020_WEBSHEET_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0'
||'" width="18" height="18" alt="flashlight" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/p3020_pick_ws_rpt_col_name
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(187889809179283856.4905)
,p_shortcut_name=>'P3020_PICK_WS_RPT_COL_NAME'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3050:&SESSION.::::P3050_CALLING_ITEM,P3050_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3020_LB_WS_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0" w'
||'idth="18" height="18" alt="flashlight" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/p3020_pick_ws_rpt_col_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(187890114027285273.4905)
,p_shortcut_name=>'P3020_PICK_WS_RPT_COL_VALUE'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3040:&SESSION.:::3040:P3040_CALLING_ITEM,P3040_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3020_WEBSHEET_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" borde'
||'r="0" width="18" height="18" alt="flashlight" /></a>'
);
end;
/
prompt --application/shared_components/security/authentications/internal_websheet_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(709672827800503408.4905)
,p_name=>'Internal Websheet Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.AUTHENTICATION.WEBSHEET'
,p_invalid_session_type=>'URL'
,p_invalid_session_url=>'f?p=4900:101:&APP_SESSION.'
,p_cookie_name=>'-NO_COOKIE-'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_searchbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(65218046382244660.4905)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.SEARCHBOX'
,p_display_name=>'Caixa de Pesquisa'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.SEARCHBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_searchbox'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT'
,p_substitute_attributes=>true
,p_reference_id=>42609120788689442.4905
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513167447444230024.4905)
,p_plugin_id=>wwv_flow_api.id(65218046382244660.4905)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Redirect URL'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:<target page>:&SESSION.::&DEBUG.::<target item>:'
,p_display_length=>80
,p_max_length=>4000
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513167803753230024.4905)
,p_plugin_id=>wwv_flow_api.id(65218046382244660.4905)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Search Text'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Search'
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
''))
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_clob_textarea
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(377419101248577827.4905)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.CLOB_TEXTAREA'
,p_display_name=>unistr('\00C1rea de Texto CLOB')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.CLOB_TEXTAREA'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_clob_textarea'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_clob_textarea'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:ELEMENT:WIDTH:HEIGHT'
,p_substitute_attributes=>false
,p_reference_id=>200125518386793215.4905
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513356480445479112.4905)
,p_plugin_id=>wwv_flow_api.id(377419101248577827.4905)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'SQL or PL/SQL to get CLOB value'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>false
,p_display_length=>80
,p_sql_min_column_count=>1
,p_sql_max_column_count=>1
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'This item supports sql statements, like',
'<pre>',
'select big_data',
'from my_table',
'where id=:P4711_ID',
'</pre>',
'and function results, like',
'<pre>',
'return wwv_flow_xxx.get_big_data(p_id => :P4711_ID);',
'</pre>',
'to get a clob value for rendering.',
'',
'To write the data back, the CLOB Textarea makes an AJAX call before the actual page submit, which stores the clob value in wwv_flow_collections.clob001, with a collection name that equals the item name.',
'Developers can then define a page process that stores the clob value where it belongs, either directly',
'<pre>',
'update my_table',
'   set big_data = (select clob001',
'                     from wwv_flow_collections',
'                    where collection_name=''P4711_BIG_DATA'')',
' where id = :P4711_ID;',
'</pre>',
'or via the built-in function wwv_flow_f4000_plugins.get_clob_textarea_value:',
'',
'<pre>',
'update my_table',
'   set agreement_text = wwv_flow_f4000_plugins.get_clob_textarea_value(''P4711_BIG_DATA'')',
' where id = :P4711_ID;',
'</pre>',
''))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513356893048479113.4905)
,p_plugin_id=>wwv_flow_api.id(377419101248577827.4905)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Textarea Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'HTML'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1513357286353479114.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1513356893048479113.4905)
,p_display_sequence=>10
,p_display_value=>'HTML Textarea'
,p_return_value=>'HTML'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1513357742751479114.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1513356893048479113.4905)
,p_display_sequence=>20
,p_display_value=>'Rich Text Editor'
,p_return_value=>'CKEDITOR-Full'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_data_grid
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(596503234954274806.4905)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.DATA_GRID'
,p_display_name=>'Grade de Dados'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.DATA_GRID'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_data_grid'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_data_grid'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_help_text=>'Exibe um widget ''Grade de Dados'' do Application Express.'
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(615743690109519472.4905)
,p_plugin_id=>wwv_flow_api.id(596503234954274806.4905)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Worksheet ID Item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>true
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(615744471837526561.4905)
,p_plugin_id=>wwv_flow_api.id(596503234954274806.4905)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Show Checkbox Item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>false
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(632128835511089827.4905)
,p_plugin_id=>wwv_flow_api.id(596503234954274806.4905)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Checks SQL Enabled'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_authentication_websheet
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(709653022821492509.4905)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.AUTHENTICATION.WEBSHEET'
,p_display_name=>unistr('Autentica\00E7\00E3o de Websheet Interna')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.AUTHENTICATION.WEBSHEET'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_f4900.callback'
,p_session_sentry_function=>'wwv_flow_authentication_f4900.session_sentry'
,p_invalid_session_function=>'wwv_flow_authentication_f4900.invalid_session'
,p_post_logout_function=>'wwv_flow_authentication_f4900.post_logout'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1129000224849873155.4905)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>unistr('Autoriza\00E7\00E3o do Desenvolvedor')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12506617921221692.4905
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_plugin_id=>wwv_flow_api.id(1129000224849873155.4905)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129000814405873158.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129001313664873159.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129001807630873159.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129002315248873160.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129002821612873160.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129003318368873161.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129003820421873162.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129004309072873162.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129004805053873163.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129005309770873163.4905)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4905)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2564397076686507738.4905)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>unistr('Adicionar caixa de sele\00E7\00E3o Marcar todas')
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512.4905
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>A a\00E7\00E3o din\00E2mica "Adicionar caixa de sele\00E7\00E3o Marcar todas" transforma um cabe\00E7alho de coluna que cont\00E9m a string #CHECK_ALL_CHECKBOX# em uma caixa de sele\00E7\00E3o Marcar todas acess\00EDvel, que marcar\00E1 ou desmarcar\00E1 todas as caixas de sele\00E7\00E3o na sua coluna')
||' correspondente.<p>',
'<p>',
unistr('Para usar este plug-in, verifique se os atributos a seguir est\00E3o definidos:'),
'<ol>',
unistr('<li>Na coluna de relat\00F3rios, defina ''#CHECK_ALL_CHECKBOX#'' como o valor do Cabe\00E7alho.</li>'),
unistr('<li>Para o atributo When da A\00E7\00E3o Din\00E2mica, selecione a regi\00E3o do relat\00F3rio que cont\00E9m a coluna.</li>'),
unistr('<li>Defina a A\00E7\00E3o Din\00E2mica para acionar ''Ap\00F3s Atualiza\00E7\00E3o'', e a A\00E7\00E3o para ''Carga de Acionamento da P\00E1gina''. (Ambas ser\00E3o definidas como padr\00E3o apropriadamente se a A\00E7\00E3o Din\00E2mica for criada selecionando a regi\00E3o na se\00E7\00E3o ''Renderiza\00E7\00E3o'' do Designer de ')
||unistr('p\00E1ginas e criando a A\00E7\00E3o Din\00E2mica nela.</li>'),
unistr('<li>Isso n\00E3o tratar\00E1 a acessibilidade das caixas de sele\00E7\00E3o renderizadas em cada linha. Isso deve ser feito separadamente na origem da regi\00E3o. (Consulte a regi\00E3o 4000:656 ''Regions'' para ver um exemplo).</li>'),
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(4968616267302342.4905)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>unistr('\00C1rea de Trabalho')
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>3
,p_home_url=>'f?p=&APP_ID.:1000:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4905
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'0'
,p_step_title=>'0'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11470321135602393.4905)
,p_plug_name=>'Application Header [EBA]'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.page_header (',
'   p_app_id => :app_id,',
'   p_session => :app_session,',
'   p_app_user => :app_user,',
'   p_ws_app_id => :ws_app_id);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'90,102,605,3040,3050,92,101,888,999,6,12,15,16,17,19,22,25,27,28,29,30,901,50,33'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_comment=>'900,908,200,53,930,760,934,932,931,23,920,940,991,20,902,2,1000,9,950,906,903,904,905,915,928,1001,3,1,140,1250,11,951,910,990,31,960,205,201,206,4020,1310,1320,131,912,4040,4030,3000,21,926,921,927,922,923,925,710,740,745,742,750,37,13,18,24,141,800'
||'0,142,146,143,144,145,42,3010,3020,3030,3060,914,91,89'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22912720326182943.4905)
,p_plug_name=>'Search'
,p_region_css_classes=>'wsSearch'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3700433754276.4905)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'33,90,92,101,102,888,901,999,6,12,15,16,17,19,22,25,27,28,29,30,3040,3050,8000'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23000306359277138.4905)
,p_plug_name=>'widget for ws'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BEFORE_FOOTER'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="rollover" style="position:absolute;display:none;">',
'  <table cellpadding="1" cellspacing="0" border="0" width="100%">',
'    <tr>',
'      <td><input type="text" onkeyup="html_Find(''rollover_content'',this.value);" style="width:150px;" id="search" /><img onclick="ws_SearchApply()" src="#IMAGE_PREFIX#ws/find_20x.gif" /></td>',
'    </tr>',
'    <tr>',
'      <td>',
'        <span id="sortup"><img src="#IMAGE_PREFIX#ws/dup.gif" alt="Classificar por Ordem Crescente" title="Classificar por Ordem Crescente" onclick="gReport.column.order(''ASC'')" /></span>',
'        <span id="sortdown"><img src="#IMAGE_PREFIX#ws/ddown.gif" alt="Classificar por Ordem Decrescente" title="Classificar por Ordem Decrescente" onclick="gReport.column.order(''DESC'')" /></span>',
'        <span id="removefilter"><img src="#IMAGE_PREFIX#ws/no_filter.gif" alt="Remover Filtro" title="Remover Filtro" onclick="gReport.column.filter_delete()" /></span>',
'        <span id="hide"><img src="#IMAGE_PREFIX#ws/trash.gif" alt="Ocultar Coluna" title="Ocultar Coluna" onclick="gReport.column.hide()" /></span>',
'        <span id="break"><img src="#IMAGE_PREFIX#ws/break_col.gif" alt="Quebrar Coluna" title="Quebrar Coluna" onclick="gReport.column.break_on()" /></span>',
'      </td>',
'    </tr>',
'  </table>',
'  <div id="rollover_content"></div>',
'</div>',
''))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'CURRENT_PAGE_IN_CONDITION'
,p_plug_display_when_condition=>'2,16'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(202667427121487089.4905)
,p_plug_name=>'Toolbar Menu Container'
,p_region_name=>'wsMenu'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(202707431395573866.4905)
,p_plug_display_sequence=>70
,p_plug_display_point=>'REGION_POSITION_02'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'33,90,92,101,102,888,901,999,6,12,15,16,17,19,22,25,27,28,29,30,3040,3050'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'900,902,1,1000,906,903,904,928,905,915,2,3000,950,951,140,1250,11,3,18,24,141,8000,142,146,143,144,145,42'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(202668901410498676.4905)
,p_plug_name=>'Data Grid Menu'
,p_parent_plug_id=>wwv_flow_api.id(202667427121487089.4905)
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_data_grid_menu (',
'    p_ws_app_id   => :WS_APP_ID,',
'    p_app_session => :APP_SESSION);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(202703416002531181.4905)
,p_plug_name=>'Admin Menu'
,p_parent_plug_id=>wwv_flow_api.id(202667427121487089.4905)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(202684424744514793.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(929122129315135247.4905)
,p_translate_title=>'N'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_footer=>'</ul></div>'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(246646208489080880.4905)
,p_plug_name=>'Report Menu'
,p_parent_plug_id=>wwv_flow_api.id(202667427121487089.4905)
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>50
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_report_menu (',
'    p_ws_app_id   => :WS_APP_ID,',
'    p_app_session => :APP_SESSION);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_security.sql_enabled(:WS_APP_ID) and',
'   wwv_flow_ws_security.sql_enabled_inst then',
'  return true;',
'end if;',
'return false;'))
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(929118964340126057.4905)
,p_plug_name=>'APEX 5.0 - Toolbar Menu'
,p_parent_plug_id=>wwv_flow_api.id(202667427121487089.4905)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(929134615131186819.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(929122129315135247.4905)
,p_translate_title=>'N'
,p_plug_header=>'<div id="websheets_menubar" class=""><ul style="display: none">'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(353259602905391710.4905)
,p_plug_name=>'print app custom css'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.print_custom_css (',
'    p_ws_app_id  => :WS_APP_ID',
'    );'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'90,102,605,3040,3050,92,101,888,999,6,12,15,16,17,19,22,25,27,28,29,30,901,50,33'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(978301830711571982.4905)
,p_plug_name=>'high contrast mode CSS'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if htmldb_util.is_high_contrast_session then',
'  sys.htp.p(''<link rel="stylesheet" href="''||wwv_flow.g_image_prefix||''ws/css/ws_hc.css" type="text/css" />'');',
'end if;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(978405910887585124.4905)
,p_plug_name=>'high contrast mode .js'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BEFORE_FOOTER'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if htmldb_util.is_high_contrast_session then',
'  sys.htp.p(''<script type="text/javascript">'');',
'  sys.htp.p(''initHighContrastMode()'');',
'  sys.htp.p(''</script>'');',
'end if;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(29174927846182851.4905)
,p_name=>'P0_SEARCH'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(22912720326182943.4905)
,p_prompt=>'Pesquisar Websheet'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.SEARCHBOX'
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(5556614497310460.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'f?p=&APP_ID.:8000:&SESSION.:::RIR:P8000_SEARCH:'
,p_attribute_02=>'Pesquisar Websheet'
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Painel de Controle'
,p_step_title=>'Painel de Controle'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(9297021464956579.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(174589600742777269.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4905)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Esta p\00E1gina mostra informa\00E7\00F5es sobre este aplicativo.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(181148802605561554.4905)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(25109627701530900.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(108117930940447534.4905)
,p_plug_name=>'Prazo'
,p_parent_plug_id=>wwv_flow_api.id(181148802605561554.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(108051114664442909.4905)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(185579501876856681.4905)
,p_name=>'Detalhes do Aplicativo'
,p_template=>wwv_flow_api.id(27071223638280295.4905)
,p_display_sequence=>20
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:33%; float:left;"'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'(',
'select name co',
'from wwv_flow_ws_applications',
'where id = :ws_app_id and',
'      security_group_id = :flow_security_group_id',
') application_name,',
'(',
'select apex_util.get_since(created_on) co',
'from wwv_flow_ws_applications',
'where id = :ws_app_id and',
'      security_group_id = :flow_security_group_id',
') application_created,',
'(',
'select created_by co',
'from wwv_flow_ws_applications',
'where id = :ws_app_id and',
'      security_group_id = :flow_security_group_id',
') created_by,',
'(',
'select count(*) websheet_pages',
'from wwv_flow_ws_webpages p,',
'     wwv_flow_ws_applications a',
'where p.security_group_id = :flow_security_group_id ',
'and p.ws_app_id = :ws_app_id',
'and a.id = p.ws_app_id',
') websheet_pages,',
'(',
'select count(*) websheet_datagrids',
'from wwv_flow_worksheets w, ',
'                  wwv_flow_ws_websheet_attr a',
'             where w.id = a.worksheet_id and',
'             w.security_group_id = :flow_security_group_id and             ',
'             a.ws_app_id = :ws_app_id and',
'             nvl(a.websheet_type,''DATA'') = ''DATA''',
') websheet_datagrids,',
'(',
'select count(*) websheet_reports',
'from wwv_flow_worksheets w, ',
'                  wwv_flow_ws_websheet_attr a',
'             where w.id = a.worksheet_id and',
'             w.security_group_id = :flow_security_group_id and             ',
'             a.ws_app_id = :ws_app_id and',
'             nvl(a.websheet_type,''DATA'') = ''REPORT'' ',
') websheet_reports',
'from dual'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(171646109232237656.4905)
,p_query_num_rows=>1
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('dados n\00E3o encontrados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>1
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185791324487395890.4905)
,p_query_column_id=>1
,p_column_alias=>'APPLICATION_NAME'
,p_column_display_sequence=>1
,p_column_heading=>'Nome'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185791420618395890.4905)
,p_query_column_id=>2
,p_column_alias=>'APPLICATION_CREATED'
,p_column_display_sequence=>3
,p_column_heading=>'Criado'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185793209343448296.4905)
,p_query_column_id=>3
,p_column_alias=>'CREATED_BY'
,p_column_display_sequence=>2
,p_column_heading=>'Criado por'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185579730924856683.4905)
,p_query_column_id=>4
,p_column_alias=>'WEBSHEET_PAGES'
,p_column_display_sequence=>4
,p_column_heading=>unistr('P\00E1ginas da Websheet')
,p_column_format=>'999G999G999G999G999G999G990'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185582712789897769.4905)
,p_query_column_id=>5
,p_column_alias=>'WEBSHEET_DATAGRIDS'
,p_column_display_sequence=>5
,p_column_heading=>'Grades de Dados da Websheet'
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185583313959907472.4905)
,p_query_column_id=>6
,p_column_alias=>'WEBSHEET_REPORTS'
,p_column_display_sequence=>6
,p_column_heading=>unistr('Relat\00F3rios da Websheet')
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(185592226389958372.4905)
,p_name=>unistr('Principais Usu\00E1rios')
,p_template=>wwv_flow_api.id(27071223638280295.4905)
,p_display_sequence=>40
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:33%; float:left;"'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select userid user_name, count(*) page_events',
'from wwv_flow_activity_log',
'where websheet_id = :ws_app_id and',
'      security_group_id = :flow_security_group_id and',
'      time_stamp >= (sysdate - nvl(:P1_TIMEFRAME,7))',
'group by userid',
'order by 2 desc'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(171646521495237685.4905)
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185597127736006112.4905)
,p_query_column_id=>1
,p_column_alias=>'USER_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Nome do Usu\00E1rio')
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185597203639006112.4905)
,p_query_column_id=>2
,p_column_alias=>'PAGE_EVENTS'
,p_column_display_sequence=>2
,p_column_heading=>unistr('Eventos de P\00E1gina')
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(185694921184931340.4905)
,p_name=>unistr('Principais P\00E1ginas')
,p_template=>wwv_flow_api.id(27071223638280295.4905)
,p_display_sequence=>50
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:66%; float:left;"'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'          (select max(name)',
'          from wwv_flow_ws_webpages p',
'          where p.ws_app_id = :ws_app_id',
'            and p.id = v.webpage_id',
'            and p.security_group_id = :flow_security_group_id) page_name,',
'       page_events',
'from (',
'select webpage_id, count(*) page_events',
'from wwv_flow_activity_log',
'where websheet_id = :ws_app_id and',
'      security_group_id = :flow_security_group_id and',
'      time_stamp >= (sysdate - nvl(:P1_TIMEFRAME,7)) and',
'      webpage_id is not null and',
'      webpage_id in (select id from wwv_flow_ws_webpages where ws_app_id = :ws_app_id)',
'group by  webpage_id',
'order by count(*) desc',
') v',
'where rownum < 8',
'order by 2 desc'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(171646521495237685.4905)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(459664827478856710.4905)
,p_query_column_id=>1
,p_column_alias=>'PAGE_NAME'
,p_column_display_sequence=>2
,p_column_heading=>unistr('Nome da P\00E1gina')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185695219132931341.4905)
,p_query_column_id=>2
,p_column_alias=>'PAGE_EVENTS'
,p_column_display_sequence=>1
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(185788025254301476.4905)
,p_name=>unistr('Altera\00E7\00F5es Recentes')
,p_template=>wwv_flow_api.id(27071223638280295.4905)
,p_display_sequence=>30
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:66%; float:left;"'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(updated_by,created_by)||'' ''||wwv_flow_lang.system_message(''DATA_GRID'')||'': ''||websheet_name n,',
'       nvl(updated_on,created_on) the_date',
'from wwv_flow_ws_websheet_attr a',
'where a.ws_app_id = :ws_app_id and',
'      a.security_group_id = :workspace_id and',
'      nvl(a.websheet_type,''DATA'') = ''DATA''',
'union all',
'select nvl(updated_by,created_by)||'' ''||wwv_flow_lang.system_message(''F4000.PAGE'')||'': ''||name n,',
'       nvl(updated_on,created_on) the_date',
'from wwv_flow_ws_webpages p',
'where p.ws_app_id = :ws_app_id and',
'      p.security_group_id = :workspace_id',
'union all',
'select nvl(updated_by,created_by)||'' ''||wwv_flow_lang.system_message(''REPORT'')||'': ''||websheet_name n, nvl(updated_on,created_on) the_date',
'from  wwv_flow_ws_websheet_attr a',
'where  a.ws_app_id = :ws_app_id and',
'       a.security_group_id = :workspace_id and',
'       nvl(a.websheet_type,''DATA'') = ''REPORT'' ',
'order by 2 desc'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(171646521495237685.4905)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('O relat\00F3rio n\00E3o cont\00E9m dados')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185789009633344267.4905)
,p_query_column_id=>1
,p_column_alias=>'N'
,p_column_display_sequence=>1
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185789100826344267.4905)
,p_query_column_id=>2
,p_column_alias=>'THE_DATE'
,p_column_display_sequence=>2
,p_column_format=>'SINCE'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(431071714612124037.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(185591206649952695.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(108117930940447534.4905)
,p_button_name=>'P1_SET'
,p_button_static_id=>'P1_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Definir'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_button_condition_type=>'NEVER'
,p_request_source=>'refresh'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(467407418236734151.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(181148802605561554.4905)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:1,RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(185586311236935113.4905)
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185585314221926524.4905)
,p_name=>'P1_TIMEFRAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(108117930940447534.4905)
,p_item_default=>'7'
,p_prompt=>'Prazo'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione o per\00EDodo deste relat\00F3rio.')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(185297526463636542.4905)
,p_computation_sequence=>10
,p_computation_item=>'RUN_LINK'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''f?p=''||:app_id||'':900:''||:app_session||''::::WS_APP_ID,P900_ID:''||',
'          :WS_APP_ID||'',''||home_page_id',
'  from WWV_FLOW_WS_APPLICATIONS',
' where SECURITY_GROUP_ID = :flow_security_group_id ',
'   and id = :WS_APP_ID '))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(174635511046499211.4905)
,p_computation_sequence=>20
,p_computation_item=>'F4900_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'1'
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_api.create_page(
 p_id=>2.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Grade de Dados'
,p_step_title=>'Grade de Dados'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18847410435428482.4905)
,p_plug_name=>unistr('Bot\00F5es Direitos da Barra de Ferramentas')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20889528970815297.4905)
,p_plug_name=>'Hidden Region'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(32890424941372009.4905)
,p_plug_name=>'Layout 1'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'<table border="0" cellpadding="0" cellspacing="0" width="100%" ><tr><td valign="top">'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(32890625221372009.4905)
,p_plug_name=>'Layout 2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'</td><td width="100%" valign="top" style="padding:0 0 0 15px;">'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(32890824632372010.4905)
,p_plug_name=>'Layout 3'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'</td></tr></table>'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(78917510079639965.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(155020820894822892.4905)
,p_plug_name=>'name'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(394039573177873943.4905)
,p_plug_name=>'Grade de Dados'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4905)
,p_plug_display_sequence=>70
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.DATA_GRID'
,p_attribute_01=>'P2_ID'
,p_attribute_02=>'P2_SHOW_CHECKBOX'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(460549006734687548.4905)
,p_plug_name=>'Ajax Notification Holder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="ajaxMESSAGE" style="display:none;"><div id="theMESSAGE"></div>',
'<a href="javascript:void()" onclick="$x_Remove(''ajaxMESSAGE'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt=""/></a>',
'</div>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(154946714578185788.4905)
,p_branch_action=>'f?p=&FLOW_ID.:2:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2631325119551194.4905)
,p_name=>'P2_SHOW_CHECKBOX'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(20889528970815297.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(159405412148423457.4905)
,p_name=>'P2_SHOW_TOOLBAR'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(20889528970815297.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185166302121096890.4905)
,p_name=>'P2_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(20889528970815297.4905)
,p_prompt=>'Id'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185166510779099358.4905)
,p_name=>'P2_WEBSHEET_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(20889528970815297.4905)
,p_prompt=>'Websheet Id'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(161140617657065325.4905)
,p_computation_sequence=>10
,p_computation_item=>'F4900_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'2'
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(5115909074633266.4905)
,p_computation_sequence=>20
,p_computation_item=>'RPT_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'null'
,p_compute_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_worksheet_rpts',
'where worksheet_id = :P2_ID',
'and id = :RPT_ID'))
,p_compute_when_type=>'NOT_EXISTS'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(471737810971362548.4905)
,p_computation_sequence=>30
,p_computation_item=>'WORKSHEET_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>'return wwv_flow_ws_api.get_websheet_name(p_worksheet_id => :p2_id);'
,p_computation_error_message=>unistr('N\00E3o \00E9 obter o nome da Grade de Dados.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5886702465031774.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Collection'
,p_process_sql_clob=>'wwv_flow_ws_api.save_checked(p_worksheet_id => :P2_ID);'
,p_process_when_type=>'NEVER'
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_api.create_page(
 p_id=>3.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Administra\00E7\00E3o')
,p_step_title=>unistr('Administra\00E7\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456716416117062946.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(457231706098432622.4905)
,p_plug_name=>'administration menu options'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(457230629124432618.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(138239722779443444.4905)
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(457236625109516658.4905)
,p_computation_sequence=>10
,p_computation_item=>'F4900_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'3'
);
end;
/
prompt --application/pages/page_00004
begin
wwv_flow_api.create_page(
 p_id=>4.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Excluir Aplicativo'
,p_step_title=>'Excluir Aplicativo'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(456220816180174638)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(301529030296629019.4905)
,p_plug_name=>unistr('Confirmar Exclus\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>31
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_required_role=>wwv_flow_api.id(487678607690660963)
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>Ao excluir um aplicativo, voc\00EA excluir\00E1 o aplicativo e todos os seus componentes correspondentes.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(301532105496629025.4905)
,p_plug_name=>'Confirm Delete'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(301601412384641231.4905)
,p_plug_name=>'Toolbar Right Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin-bottom: 10px"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_footer=>'<div class="clear"></div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(318042708957711067.4905)
,p_plug_name=>unistr('N\00E3o \00C9 Poss\00EDvel Excluir Aplicativo')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>41
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_required_role=>'!'||wwv_flow_api.id(487678607690660963)
,p_plug_header=>unistr('<div class="wsErrorMessageSQL">Voc\00EA deve ser Desenvolvedor de &PRODUCT_NAME. para acessar esta fun\00E7\00E3o.</div>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(301529230900629020.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(301601412384641231.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(319787302199021438.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(301601412384641231.4905)
,p_button_name=>'BUILDER_LOGIN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Log-in em Desenvolvimento'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_security_scheme=>'!'||wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(301529418920629020.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(301601412384641231.4905)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Excluir Permanentemente Agora'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_security_scheme=>wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(302848719197785179.4905)
,p_branch_action=>'f?p=4000:1500:&BUILDER_SESSION_ID.::NO:RP:P1500_SHOW:WEBSHEET'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_ws_applications',
'where security_group_id = :flow_security_group_id'))
,p_security_scheme=>wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(301529629185629020.4905)
,p_name=>'P4_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(301529030296629019.4905)
,p_prompt=>'Aplicativo'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'O aplicativo selecionado.'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(301530122954629023.4905)
,p_name=>'P4_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(301529030296629019.4905)
,p_prompt=>'Nome'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name from wwv_flow_ws_applications ',
' where id = :P4_ID',
'   and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'O nome do aplicativo selecionado.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(301530606969629023.4905)
,p_name=>'P4_PAGES'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(301529030296629019.4905)
,p_prompt=>unistr('P\00E1ginas')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*) ',
'from wwv_flow_ws_webpages p,',
'     wwv_flow_ws_applications a',
'where p.security_group_id = :flow_security_group_id ',
'and p.ws_app_id = :P4_ID',
'and a.id = p.ws_app_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('O n\00FAmero de p\00E1ginas no aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(301531114457629024.4905)
,p_name=>'P4_DATAGRIDS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(301529030296629019.4905)
,p_prompt=>'Grades de Dados'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*) ',
' from wwv_flow_worksheets w, ',
'       wwv_flow_ws_websheet_attr a',
' where w.id = a.worksheet_id and',
'       w.security_group_id = :flow_security_group_id and            ',
'       a.websheet_type = ''DATA'' and',
'       a.ws_app_id = :P4_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('O n\00FAmero das grades de dados dentro do aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(301531601072629024.4905)
,p_name=>'P4_REPORTS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(301529030296629019.4905)
,p_prompt=>unistr('Relat\00F3rios')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*) ',
' from wwv_flow_worksheets w, ',
'       wwv_flow_ws_websheet_attr a',
' where w.id = a.worksheet_id and',
'       w.security_group_id = :flow_security_group_id and            ',
'       a.websheet_type = ''REPORT'' and',
'       a.ws_app_id = :P4_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('O n\00FAmero de relat\00F3rios dentro do aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(317199623052582715.4905)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete websheet application'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.delete_ws_app (',
'    p_ws_app_id   => :P4_ID);'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel excluir o aplicativo.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(301529418920629020.4905)
,p_process_success_message=>unistr('Aplicativo exclu\00EDdo.')
,p_security_scheme=>wwv_flow_api.id(487678607690660963)
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Alterar Senha'
,p_step_title=>'Alterar Senha'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(506060600392166972)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(733375232512655603.4905)
,p_plug_name=>'Alterar Senha'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_ws_applications ',
'where id = :WS_APP_ID',
'and security_group_id = :WORKSPACE_ID'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(733377515496655611.4905)
,p_plug_name=>'Toobar Right Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(733377932388655611.4905)
,p_plug_name=>'Change Password'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(733377104075655609.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(733377515496655611.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(733377316895655611.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(733377515496655611.4905)
,p_button_name=>'RESET_PASSWORD'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>'Alterar Senha'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(733378822544655614.4905)
,p_branch_action=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(733375407229655605.4905)
,p_name=>'P5_CURRENT_PASSWORD'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(733375232512655603.4905)
,p_prompt=>'Informar Senha Atual'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'YES'
,p_help_text=>'Digite sua senha atual.'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(733376401898655607.4905)
,p_name=>'P5_USERNAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(733375232512655603.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Nome do Usu\00E1rio')
,p_source=>'APP_USER'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Nome do usu\00E1rio cuja senha ser\00E1 alterada.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(739791012792509692.4905)
,p_name=>'P5_NEW_PASSWORD'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(733375232512655603.4905)
,p_prompt=>'Informar Nova Senha'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'YES'
,p_help_text=>'Informe a nova senha.'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(739973506690517391.4905)
,p_name=>'P5_CONFIRM_PASSWORD'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(733375232512655603.4905)
,p_prompt=>'Confirmar Nova Senha'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'YES'
,p_help_text=>'Entre novamente com a nova senha.'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(740169510284527901.4905)
,p_validation_name=>'APP_USER not null'
,p_validation_sequence=>10
,p_validation=>'APP_USER'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('O nome do usu\00E1rio n\00E3o foi definido corretamente. Feche o browser completamente e tente alterar sua senha novamente.')
,p_associated_item=>wwv_flow_api.id(733376401898655607.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(740337923575541125.4905)
,p_validation_name=>'new passwd = confirm passwd'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P5_NEW_PASSWORD != :P5_CONFIRM_PASSWORD then',
'  :P5_NEW_PASSWORD := null;',
'  :P5_CONFIRM_PASSWORD := null;',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('A senha de confirma\00E7\00E3o corresponde \00E0 nova senha.')
,p_validation_condition=>':P5_NEW_PASSWORD is not null and :P5_CONFIRM_PASSWORD is not null'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(.4905)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(740556219204549371.4905)
,p_validation_name=>'Validate Current Password'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_api.is_login_password_valid(',
'  p_username => :APP_USER,',
'  p_password => :P5_CURRENT_PASSWORD);'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Senha Inv\00E1lida')
,p_validation_condition=>'P5_CURRENT_PASSWORD'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(.4905)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(740770724529560332.4905)
,p_validation_name=>'strong password'
,p_validation_sequence=>40
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_security.strong_password_validation(',
'      p_username              => :APP_USER,',
'      p_password              => :P5_NEW_PASSWORD,',
'      p_old_password          => :P5_CURRENT_PASSWORD,',
'      p_workspace_name        => wwv_flow_security.find_company_name(:flow_security_group_id));'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>'Erro'
,p_validation_condition=>':P5_NEW_PASSWORD is not null and :P5_CONFIRM_PASSWORD is not null'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(.4905)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(733378319666655613.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'change password'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_api.g_fnd_user_password_action := true;',
'update wwv_flow_fnd_user ',
'  set web_password = :P5_NEW_PASSWORD',
'where security_group_id = :flow_security_group_id ',
'  and user_id = (select user_id ',
'                  from wwv_flow_fnd_user ',
'                 where security_group_id = :flow_security_group_id ',
'                   and user_name = :app_user);',
'wwv_flow_api.g_fnd_user_password_action := false;',
'',
':P5_NEW_PASSWORD := null;',
':P5_CONFIRM_PASSWORD := null;',
':P5_CURRENT_PASSWORD := null;'))
,p_process_error_message=>'Erro ao alterar a senha.'
,p_process_when=>':P5_NEW_PASSWORD = :P5_CONFIRM_PASSWORD'
,p_process_when_type=>'PLSQL_EXPRESSION'
,p_process_success_message=>'Senha alterada.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(741456721937597439.4905)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'5'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00006
begin
wwv_flow_api.create_page(
 p_id=>6.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Controle de Acesso'
,p_step_title=>'Controle de Acesso'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style type="text/css" media="screen">',
'	/* Hide left col */',
'	div.wsSideCol {',
'		 display: none !important;',
'	}',
'	div.wsMainCol {',
'		 padding: 5px;',
'	}',
'</style>'))
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(619279823495072045.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(619385132669714338.4905)
,p_plug_name=>'Controle de Acesso'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(628484022950304722.4905)
,p_plug_name=>'intro text'
,p_parent_plug_id=>wwv_flow_api.id(619385132669714338.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<p>''||wwv_flow_lang.system_message(''ACL_TABLE.INTRO_TEXT'')||''</p>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(628484309576310290.4905)
,p_plug_name=>'acl table'
,p_parent_plug_id=>wwv_flow_api.id(619385132669714338.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(wwv_flow_ws_api.get_acl_table);'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(619280212586072050.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Window'
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Criar Websheet - Definir Websheet'
,p_step_title=>'Criar Websheet - Definir Websheet'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(487678607690660963)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(318854823839904542.4905)
,p_plug_name=>'Criar Websheet'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_required_role=>wwv_flow_api.id(487678607690660963)
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P7_WS_OBJ_VALID'
,p_plug_display_when_cond2=>'Y'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(318859432686904552.4905)
,p_plug_name=>'Websheet'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>5
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_required_role=>wwv_flow_api.id(487678607690660963)
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P7_WS_OBJ_VALID'
,p_plug_display_when_cond2=>'N'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<div class="wsErrorMessageSQL">Os objetos de banco de dados exigidos para criar os aplicativos de Websheet s\00E3o inv\00E1lidos ou n\00E3o existem. Entre em contato com o Administrador do Espa\00E7o de Trabalho.</div>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(318860207517904554.4905)
,p_plug_name=>'Create Websheet - Define Websheet'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(318967230409915957.4905)
,p_plug_name=>'Topbar Right Side'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(320644524521264400.4905)
,p_plug_name=>'Criar Erro de Websheet'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_required_role=>'!'||wwv_flow_api.id(487678607690660963)
,p_plug_header=>unistr('<div class="wsErrorMessageSQL">Voc\00EA deve ser Desenvolvedor de &PRODUCT_NAME. para acessar esta fun\00E7\00E3o.</div>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(318855016053904543.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(318967230409915957.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(318855428690904544.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(318967230409915957.4905)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4905)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Pr\00F3ximo')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_security_scheme=>wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(320757101234276586.4905)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(318967230409915957.4905)
,p_button_name=>'BUILDER_LOGIN'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Log-in em Desenvolvimento'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=4500:1000:&BUILDER_SESSION_ID.'
,p_security_scheme=>'!'||wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(318860014037904553.4905)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(318967230409915957.4905)
,p_button_name=>'FIX_WS_OBJ'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4905)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Gerenciar Objetos do Banco de Dados da Websheet'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4350:2000:&BUILDER_SESSION_ID.'
,p_button_execute_validations=>'N'
,p_button_condition=>'P7_WS_OBJ_VALID'
,p_button_condition2=>'N'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_security_scheme=>wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(318862427044904561.4905)
,p_branch_action=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(318855428690904544.4905)
,p_branch_sequence=>30
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(318855611632904545.4905)
,p_name=>'P7_WEBSHEET_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(318854823839904542.4905)
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>255
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('O nome usado para identificar o aplicativo em rela\00E7\00E3o aos desenvolvedores.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(318856114895904546.4905)
,p_name=>'P7_WS_APP_ID'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(318854823839904542.4905)
,p_prompt=>'Websheet'
,p_source=>'wwv_flow_utilities.minimum_free_flow'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>12
,p_cMaxlength=>120
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Especifique um valor de n\00FAmero inteiro que identifica o aplicativo. O ID do aplicativo deve ser exclusivo na inst\00E2ncia de &PRODUCT_NAME..<br /><br />'),
unistr('Os IDs do aplicativo na faixa de 3000 a 9000 s\00E3o reservados para uso interno pelo &PRODUCT_NAME.')))
,p_attribute_01=>'0'
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(318856522037904548.4905)
,p_name=>'P7_DESCRIPTION'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(318854823839904542.4905)
,p_prompt=>unistr('Descri\00E7\00E3o')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_cAttributes=>'nowrap'
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Descri\00E7\00E3o do seu aplicativo.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(318857629067904549.4905)
,p_name=>'P7_WS_OBJ_VALID'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(318854823839904542.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(318860812527904558.4905)
,p_computation_sequence=>10
,p_computation_item=>'P7_WEBSHEET_NAME'
,p_computation=>'ltrim(rtrim(:P7_WEBSHEET_NAME))'
,p_compute_when=>'CREATE'
,p_compute_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(318861027774904559.4905)
,p_computation_sequence=>10
,p_computation_item=>'P7_WEBSHEET_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    r varchar2(255) := null;',
'    c pls_integer;',
'begin',
'    for i in 1..12 ',
'    loop',
'        select  count(*) into c',
'        from  wwv_flow_ws_applications',
'        where security_group_id = :flow_security_group_id',
'        and name = upper(:app_user)||'' 0''||i;',
'        if c = 0 then',
'           r := upper(:app_user)||'' 0''||i;',
'           exit;',
'        end if;',
'    end loop;',
'    return r;',
'end;'))
,p_compute_when=>'P7_WEBSHEET_NAME'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(318861220395904559.4905)
,p_computation_sequence=>10
,p_computation_item=>'P7_WS_OBJ_VALID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_setup.all_object_valid2 then',
'  return ''Y'';',
'else',
'  return ''N'';',
'end if;'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(318861410474904560.4905)
,p_validation_name=>'P7_WS_APP_ID not exists'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_models',
' where flow_id = :P7_WS_APP_ID ',
'   and model_complete = ''Y''',
'   and flow_id in (select id from wwv_flows)',
'union',
'select 1 from wwv_flows',
' where id = :P7_WS_APP_ID',
'union',
'select 1 from wwv_flow_ws_applications',
' where id = :P7_WS_APP'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('O ID do Aplicativo j\00E1 existe ou est\00E1 reservado para outro modelo de aplicativo.')
,p_validation_condition=>'P7_WS_APP_ID'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(318856114895904546.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(318861624125904560.4905)
,p_validation_name=>'P7_WS_APP_ID not reserved'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_utilities.is_available_application_id(',
'    p_security_group_id => :flow_security_group_id,',
'    p_application_id    => :P7_WS_APP_ID,',
'    p_check_reserved    => FALSE ) = FALSE then',
'    --',
'    return FALSE;',
'else',
'    return TRUE;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'ID do Aplicativo reservado.'
,p_validation_condition=>'P7_WS_APP_ID'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(318856114895904546.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00008
begin
wwv_flow_api.create_page(
 p_id=>8.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Criar Websheet'
,p_step_title=>'Criar Websheet'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(487678607690660963)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(321421909516423567.4905)
,p_plug_name=>'Confirmar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>Voc\00EA solicitou a cria\00E7\00E3o de uma Websheet com os atributos a seguir. Confirme suas sele\00E7\00F5es.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(321422704576423569.4905)
,p_plug_name=>'Create Websheet'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(321563209349439790.4905)
,p_plug_name=>'Topbar Right Side'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>31
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(321422118221423568.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(321563209349439790.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(321422324783423569.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(321563209349439790.4905)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Criar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(321422507191423569.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(321563209349439790.4905)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4905)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(321423518422423582.4905)
,p_branch_action=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(321422324783423569.4905)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(321849905586467114.4905)
,p_name=>'P8_WEBSHEET_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(321421909516423567.4905)
,p_prompt=>'Nome'
,p_source=>'P7_WEBSHEET_NAME'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>40
,p_cMaxlength=>255
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('O nome usado para identificar o aplicativo em rela\00E7\00E3o aos desenvolvedores.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(321884016322470228.4905)
,p_name=>'P8_WS_APP_ID'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(321421909516423567.4905)
,p_prompt=>'Websheet'
,p_source=>'P7_WS_APP_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>12
,p_cMaxlength=>120
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'O valor inteiro que identifica o aplicativo.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(321903521516471689.4905)
,p_name=>'P8_DESCRIPTION'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(321421909516423567.4905)
,p_prompt=>unistr('Descri\00E7\00E3o')
,p_source=>'P7_DESCRIPTION'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Descri\00E7\00E3o do seu aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(321423206166423578.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create websheet'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_ws_app (',
'      p_ws_app_id      => :P7_WS_APP_ID,',
'      p_name           => :P7_WEBSHEET_NAME,',
'      p_description    => :P7_DESCRIPTION,      ',
'      --',
'      p_flow_id        => :APP_ID',
'      );'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar um aplicativo.')
,p_process_when_button_id=>wwv_flow_api.id(321422324783423569.4905)
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_api.create_page(
 p_id=>11.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Controle de Acesso'
,p_step_title=>'Controle de Acesso'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(9297021464956579.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(451311515410376846.4905)
,p_plug_name=>'Access Control List Entries'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select n001 id,',
'       c001 username,',
'       c002 priv,',
'       wwv_flow_lang.system_message(''EDIT_LINK_TEXT'', wwv_flow_escape.html(c001)) link_text',
'from wwv_flow_collections',
'where collection_name = ''APEX$_ACL'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(451311719920376851.4905)
,p_name=>'Change History'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('N\00E3o h\00E1 entradas na lista de controle de acesso.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="" />'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'CBCHO'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(451333131265977320.4905)
,p_db_column_name=>'ID'
,p_display_order=>2
,p_column_identifier=>'D'
,p_column_label=>' '
,p_column_link=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:13:P13_ID:#ID#'
,p_column_linktext=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="#LINK_TEXT#">'
,p_column_link_attr=>'Edit'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_hide=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(451314505039414398.4905)
,p_db_column_name=>'USERNAME'
,p_display_order=>3
,p_column_identifier=>'B'
,p_column_label=>unistr('Nome do Usu\00E1rio')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(451314610985414398.4905)
,p_db_column_name=>'PRIV'
,p_display_order=>4
,p_column_identifier=>'C'
,p_column_label=>unistr('Privil\00E9gio')
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(451333930142995878)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(247045499759377619.4905)
,p_db_column_name=>'LINK_TEXT'
,p_display_order=>14
,p_column_identifier=>'E'
,p_column_label=>'Texto do Link'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(451312628829376856.4905)
,p_plug_name=>'Manage Access Control List'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(458561726210213950.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4905)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Se o aplicativo estiver usando a autoriza\00E7\00E3o personalizada, esta lista de controle de acesso gerencia os privil\00E9gios destes usu\00E1rios do aplicativo.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(458945107668445108.4905)
,p_plug_name=>unistr('Esquema de Autentica\00E7\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_auth_type varchar2(255);',
'begin',
'  l_auth_type := wwv_flow_item.text_from_lov(wwv_flow_ws_security.ws_auth_type(:WS_APP_ID),''WEBSHEET AUTHENTICATION'');',
'',
'  sys.htp.prn(''<p>''||',
'      wwv_flow_lang.system_message(''F4900_P11_AUTH_TYPE_MESSAGE'',l_auth_type)||''</p>'');',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466701412926181295.4905)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(466702532319186899.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(466701412926181295.4905)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:11,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(451340528822175261.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(451311515410376846.4905)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4905)
,p_button_image_alt=>'Criar Entrada >'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:13::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(451313319291376861.4905)
,p_branch_action=>'f?p=&FLOW_ID.:11:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(451313108133376860.4905)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create ACL collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_acl_collection (',
'    p_ws_app_id => :WS_APP_ID',
'    );'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar a cole\00E7\00E3o de ACLs.')
);
end;
/
prompt --application/pages/page_00012
begin
wwv_flow_api.create_page(
 p_id=>12.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'SQL Sugerido'
,p_step_title=>'SQL Sugerido'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_required_role=>wwv_flow_api.id(495860932509802714)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488396212380125306.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4905)
,p_plug_display_sequence=>130
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>Voc\00EA pode usar SQL em Relat\00F3rios e em Tags de SQL. Esta \00E9 uma lista de Objetos Sugeridos que podem ser de interesse do aplicativo. Selecione um objeto e ser\00E1 exibida a instru\00E7\00E3o SQL SELECT apropriada para sua utiliza\00E7\00E3o.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488403717840125334.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488408215444168022.4905)
,p_plug_name=>'Objetos Sugeridos'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4905)
,p_plug_display_sequence=>15
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name,',
'       object_comment',
'  from wwv_flow_ws_app_sug_objects',
' where ws_app_id = :WS_APP_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(488408303926168022.4905)
,p_name=>'Available Objects'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(488408529626168027.4905)
,p_db_column_name=>'OBJECT_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Nome do Objeto'
,p_column_link=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:12:P12_TABLE_NAME:#OBJECT_NAME#'
,p_column_linktext=>'#OBJECT_NAME#'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492616214470258718.4905)
,p_db_column_name=>'OBJECT_COMMENT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('Coment\00E1rio')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488409211280188810.4905)
,p_plug_name=>'&P12_TABLE_NAME.'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(27071223638280295.4905)
,p_plug_display_sequence=>25
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare q varchar2(32767);',
'begin',
'q := ''select'';',
'for c1 in (',
'select column_name',
'  from sys.dba_tab_columns',
' where table_name = :P12_TABLE_NAME and',
'       owner = wwv_flow_security.g_apex$_schema',
' order by column_id) loop',
'q := q||''<br />'';',
'q := q||''&nbsp;&nbsp;&nbsp;&nbsp;''||wwv_flow_escape.html(c1.column_name)||'','';',
'end loop;',
'q := rtrim(q,'','')||''<br />from ''||wwv_flow_escape.html(:P12_TABLE_NAME);',
'sys.htp.p(q);',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P12_TABLE_NAME'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488415531993365037.4905)
,p_plug_name=>'Exemplos'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4905)
,p_plug_display_sequence=>35
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'[[SQL: select ename "Employee Name", sal "Salary" from emp order by sal desc | limit=10]]',
'[[SQLVALUE: select count(*)  from emp ]]',
'</pre>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491315127198795285.4905)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(488411205618253386.4905)
,p_button_sequence=>5
,p_button_plug_id=>wwv_flow_api.id(488408215444168022.4905)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:12,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(488409426171193110.4905)
,p_name=>'P12_TABLE_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(488396212380125306.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
end;
/
prompt --application/pages/page_00013
begin
wwv_flow_api.create_page(
 p_id=>13.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Criar/Editar Entrada da Lista de Controle de Acesso'
,p_step_title=>'Criar/Editar Entrada da Lista de Controle de Acesso'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22693023416256513.4905)
,p_plug_name=>'Top Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22695808618308969.4905)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(451316114910485987.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(451316527354493693.4905)
,p_plug_name=>'Entrada'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455753022786260831.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4905)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Se o aplicativo estiver usando autoriza\00E7\00E3o personalizada, a lista de controle de acesso gerencia os privil\00E9gios dos usu\00E1rios deste aplicativo.</p>'),
'',
'<ul>',
unistr('<li><b>Leitor</b> - pode exibir, mas n\00E3o editar, o conte\00FAdo</li>'),
unistr('<li><b>Colaborador</b> - pode exibir e editar o conte\00FAdo</li>'),
unistr('<li><b>Administrador</b> - pode exibir e editar o conte\00FAdo e tamb\00E9m editar as Propriedades do Aplicativo e gerenciar a Lista de Controle de Acesso</li>'),
'</ul>',
''))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(451317504937543969.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(22693023416256513.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(451317707492554199.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(22693023416256513.4905)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>'Criar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P13_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(488046828362984858.4905)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(22693023416256513.4905)
,p_button_name=>'CREATE_AND_CREATE_ANOTHER'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Criar e Criar Outro'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P13_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(451326723076908671.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(22693023416256513.4905)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_condition=>'P13_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(451334810665009173.4905)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(22693023416256513.4905)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15160928947568323.4905)
,p_button_image_alt=>'Excluir'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'javascript:confirmDelete(''&DELETE_MSG.'',''DELETE'');'
,p_button_condition=>'P13_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(488047325507002977.4905)
,p_branch_action=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:13::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(488046828362984858.4905)
,p_branch_sequence=>2
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(451317931226554200.4905)
,p_branch_action=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(451316709130497825.4905)
,p_name=>'P13_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(22695808618308969.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(451316912509517726.4905)
,p_name=>'P13_USERNAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(451316527354493693.4905)
,p_prompt=>unistr('Nome do Usu\00E1rio')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifique o nome do usu\00E1rio do qual voc\00EA deseja controlar o acesso.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(451317328917531994.4905)
,p_name=>'P13_PRIV'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(451316527354493693.4905)
,p_item_default=>'R'
,p_prompt=>unistr('Privil\00E9gio')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'WS_ACL_PRIVS'
,p_lov=>'.'||wwv_flow_api.id(451333930142995878.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'LEFT-TOP'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Identifique o n\00EDvel de privil\00E9gio do usu\00E1rio. Se o aplicativo estiver usando autoriza\00E7\00E3o personalizada, a lista de controle de acesso gerenciar\00E1 os privil\00E9gios dos usu\00E1rios desse aplicativo.</p>'),
'',
'<ul>',
unistr('<li><b>Leitor</b> - Pode exibir, mas n\00E3o editar conte\00FAdo</li>'),
unistr('<li><b>Colaborador</b> - Pode exibir e editar conte\00FAdo</li>'),
unistr('<li><b>Administrador</b> - Pode exibir e editar conte\00FAdo, al\00E9m de editar Propriedades do Aplicativo e gerenciar a Lista de Controle de Acesso</li>'),
'</ul>'))
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(22573104501037740.4905)
,p_computation_sequence=>10
,p_computation_item=>'P13_USERNAME'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'trim(:P13_USERNAME)'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(456322608585423890.4905)
,p_validation_name=>'Cannot Delete or lesser privilege yourself'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select c001',
'             from wwv_flow_collections',
'            where collection_name = ''APEX$_ACL''',
'              and n001 = :P13_ID ) loop',
'  if :REQUEST = ''DELETE'' and c1.c001 = upper(:APP_USER) then',
'    return false;',
'  elsif :REQUEST = ''APPLY_CHANGES'' and c1.c001 = upper(:APP_USER) and :P13_PRIV != ''A'' then',
'    return false;',
'  else',
'    return true;',
'  end if;',
'end loop;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Voc\00EA n\00E3o pode remover a si mesmo como administrador.')
,p_validation_condition=>':REQUEST in (''DELETE'',''APPLY_CHANGES'') and wwv_flow_ws_security.ws_acl_type(:WS_APP_ID) = ''CUSTOM'''
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(451316912509517726.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(799469025785845096.4905)
,p_validation_name=>'P13_USERNAME already exists'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flow_collections',
' where collection_name = ''APEX$_ACL''',
'   and c001 = upper(:P13_USERNAME)'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('O usu\00E1rio j\00E1 existe na lista de controle de acesso.')
,p_validation_condition=>'CREATE,CREATE_AND_CREATE_ANOTHER'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(451316912509517726.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(819882220390557560.4905)
,p_validation_name=>'P13_USERNAME not null'
,p_validation_sequence=>30
,p_validation=>'P13_USERNAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('O nome de usu\00E1rio deve ser fornecido.')
,p_validation_condition=>'CREATE,CREATE_AND_CREATE_ANOTHER,APPLY_CHANGES'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(451316912509517726.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(451339402456139272.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add/update ACL'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.add_acl_entry(',
'    p_ws_app_id  => :WS_APP_ID,',
'    p_acl_id          => :P13_ID,',
'    p_username   => :P13_USERNAME,',
'    p_priv             => :P13_PRIV );'))
,p_process_error_message=>'Erro ao criar entrada da lista de controle de acesso.'
,p_process_when=>'CREATE,APPLY_CHANGES,CREATE_AND_CREATE_ANOTHER'
,p_process_when_type=>'REQUEST_IN_CONDITION'
,p_process_success_message=>'Entrada da lista de controle de acesso criada ou modificada.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(833790620596523418.4905)
,p_process_sequence=>15
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create ACL collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_acl_collection (',
'    p_ws_app_id => :WS_APP_ID',
'    );'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar a cole\00E7\00E3o de ACLs.')
,p_process_when_button_id=>wwv_flow_api.id(488046828362984858.4905)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(451340317956162700.4905)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete acl entry'
,p_process_sql_clob=>'wwv_flow_ws_api.delete_acl_entry(:P13_ID);'
,p_process_error_message=>'Erro ao excluir entrada da lista de controle de acesso.'
,p_process_when_button_id=>wwv_flow_api.id(451334810665009173.4905)
,p_process_success_message=>unistr('Entrada da lista de controle de acesso exclu\00EDda.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(451338731714109921.4905)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'pop items'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select c001 username, c002 priv',
'             from wwv_flow_collections',
'            where collection_name = ''APEX$_ACL''',
'              and n001 = :P13_ID ) loop',
'    :P13_USERNAME := c1.username;',
'    :P13_PRIV := c1.priv;',
'    exit;',
'end loop;'))
,p_process_when=>'P13_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00014
begin
wwv_flow_api.create_page(
 p_id=>14.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Exibir Hist\00F3rico de Altera\00E7\00F5es')
,p_step_title=>unistr('Exibir Hist\00F3rico de Altera\00E7\00F5es')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2669725667029212.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29080824628705464.4905)
,p_plug_name=>unistr('Exibir Hist\00F3rico de Altera\00E7\00F5es')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4905)
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001 row_key,',
'       c002 column_name,',
'       c003 old_value,',
'       c004 new_value,',
'       c005 application_user_id,',
'       d001 date_of_change,',
'       c006 history_rowid',
'from wwv_flow_collections',
'where collection_name = ''APEX$_WS_HISTORY'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(29080913600705464.4905)
,p_name=>'Change History'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_base_pk1=>'ROW_KEY'
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_rows_per_page=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#ws/small_page.gif" alt="&VIEW." />'
,p_owner=>'CBCHO'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1524146599951611412.4905)
,p_db_column_name=>'ROW_KEY'
,p_display_order=>10
,p_column_identifier=>'G'
,p_column_label=>'Chave da Linha'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(29081219740705468.4905)
,p_db_column_name=>'COLUMN_NAME'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>'Nome da Coluna'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(29081302162705468.4905)
,p_db_column_name=>'OLD_VALUE'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>'Antigo Valor'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(29081429809705469.4905)
,p_db_column_name=>'NEW_VALUE'
,p_display_order=>40
,p_column_identifier=>'D'
,p_column_label=>'Novo Valor'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(29081503189705469.4905)
,p_db_column_name=>'APPLICATION_USER_ID'
,p_display_order=>50
,p_column_identifier=>'E'
,p_column_label=>unistr('Id do Usu\00E1rio do Aplicativo')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(29085729935792011.4905)
,p_db_column_name=>'DATE_OF_CHANGE'
,p_display_order=>60
,p_column_identifier=>'F'
,p_column_label=>'Alterado'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(246124596661890750.4905)
,p_db_column_name=>'HISTORY_ROWID'
,p_display_order=>70
,p_column_identifier=>'I'
,p_column_label=>unistr('Id de linha do hist\00F3rico')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(906866216721570277.4905)
,p_plug_name=>unistr('Bot\00F5es Direitos da Barra de Ferramentas')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(907020707979586718.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(29080824628705464.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2647813413278526.4905)
,p_branch_action=>'f?p=&FLOW_ID.:14:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(29080030787678754.4905)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create history collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_history_collection (',
'    p_worksheet_id => :p2_id,',
'    p_websheet_id  => :p2_websheet_id',
'    );'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar a cole\00E7\00E3o de hist\00F3rico.')
);
end;
/
prompt --application/pages/page_00015
begin
wwv_flow_api.create_page(
 p_id=>15.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Vis\00E3o Geral')
,p_step_title=>unistr('Vis\00E3o Geral')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455867416484229688.4905)
,p_plug_name=>'Aplicativos de Websheet'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Usando aplicativos de Websheet, os usu\00E1rios finais podem gerenciar dados estruturados e n\00E3o estruturados, sem precisar do desenvolvedor. Os recursos permitem aos usu\00E1rios:</p> '),
'',
'<ul>',
unistr('<li>Criar e compartilhar o conte\00FAdo pela web usando apenas um Web browser.</li>'),
unistr('<li>Organizar p\00E1ginas em uma hierarquia e p\00E1ginas de links cruzados (usando a sintaxe [[ pagename ]]).</li>'),
'<li>Criar e gerenciar dados tabulares usando um recurso incorporado denominado grades de dados.</li>',
unistr('<li>Criar relat\00F3rios interativos usando SQL nas estruturas de dados existentes dentro do banco de dados.</li>'),
unistr('<li>Expor dados da grade de dados e de relat\00F3rio nas p\00E1ginas como gr\00E1ficos ou relat\00F3rios.</li>'),
unistr('<li>Anotar p\00E1ginas com arquivos, tags e observa\00E7\00F5es. As imagens associadas podem ser mostradas alinhadas dentro do conte\00FAdo da p\00E1gina (usando a sintaxe [[image: filename]]).</li>'),
unistr('<li>Pesquisar conte\00FAdo da p\00E1gina (usando a fun\00E7\00E3o de pesquisa incorporada).</li>'),
unistr('<li>Gerenciar quem pode fazer log-in. Ap\00F3s o log-in, gerenciar quem pode ler, gravar ou administrar o aplicativo (autentica\00E7\00E3o e autoriza\00E7\00E3o).</li>'),
'</ul> '))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455869309520274904.4905)
,p_plug_name=>unistr('P\00E1ginas')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>O conte\00FAdo das p\00E1ginas \00E9 organizado em se\00E7\00F5es. As websheets suportam os seguintes tipos de se\00E7\00E3o:</p>'),
'<ul>',
unistr('<li>Texto \2013 Exibir o texto informado, imagens e relat\00F3rios em linha e tamb\00E9m links para relat\00F3rios, grades de dados, outras p\00E1ginas, arquivos, URLs externos etc. As se\00E7\00F5es do texto s\00E3o gerenciadas usando-se um editor WYSIWIG intuitivo. </li>'),
unistr('<li>Navega\00E7\00E3o \2013 Adicionar a navega\00E7\00E3o gerada dinamicamente \00E0s p\00E1ginas ou se\00E7\00F5es de p\00E1ginas subordinadas.</li>'),
unistr('<li>Dados \2013 Criar relat\00F3rios em linha com base em uma grade de dados ou em um relat\00F3rio.</li>'),
unistr('<li>Gr\00E1fico \2013 Criar gr\00E1ficos em linha com base em uma grade de dados ou em um relat\00F3rio.</li>'),
'</ul>',
''))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455869514368276321.4905)
,p_plug_name=>unistr('Anota\00E7\00F5es')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Dentro das p\00E1ginas ou linhas de uma grade de dados, voc\00EA pode incluir as seguintes anota\00E7\00F5es:</p>'),
'<ul>',
unistr('<li>Arquivos \2013 Fazer upload de arquivos para download ou exibi\00E7\00E3o como imagem em linha dentro do texto da se\00E7\00E3o</li>'),
unistr('<li>Observa\00E7\00F5es \2013 Incluir observa\00E7\00F5es espec\00EDficas do conte\00FAdo'),
unistr('<li>Tags \2013 Adicionar tags para aprimorar o recurso de pesquisa incorporada.'),
'</ul>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455869719909277967.4905)
,p_plug_name=>'Controle de Acesso'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Um Administrador controla quem pode fazer log-in em um aplicativo de Websheet, especificando um dos seguintes mecanismos de autentica\00E7\00E3o:</p>'),
'<ul>',
unistr('<li>Acesso p\00FAblico (sem autentica\00E7\00E3o)</li>'),
'<li>Contas do Oracle Application Express</li>',
'<li>Oracle Single Sign-On</li>',
unistr('<li>Verifica\00E7\00E3o de Credenciais LDAP</li>'),
'<li>Personalizados',
'</ul>',
'',
unistr('<p>Ap\00F3s fazer log-in em um aplicativo, o acesso ser\00E1 determinado pela atribui\00E7\00E3o designada ao usu\00E1rio. As atribui\00E7\00F5es suportadas incluem:</p>'),
'<ul>',
'<li>Administrador</li>',
'<li>Colaborador</li>',
'<li>Leitor</li>',
'</ul>',
'',
'',
''))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455870812899294887.4905)
,p_plug_name=>'Grades de Dados'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Grades de dados s\00E3o conjuntos de dados tabulares definidos pelo colaborador, basicamente uma planilha baseada na Web. Voc\00EA pode definir a estrutura de uma grade de dados usando nomes de coluna, tipos de dados e valida\00E7\00F5es b\00E1sicas, ou criar uma gra')
||unistr('de de dados nos dados da planilha. Depois de criadas, a estrutura pode ser modificada conforme necess\00E1rio.</p>'),
'',
unistr('<p>Al\00E9m das colunas definidas, um conjunto de colunas padr\00E3o sempre \00E9 inclu\00EDdo em cada grade de dados. Elas incluem propriet\00E1rio, criado por, criado em, atualizado por, atualizado em, ordem da linha e anota\00E7\00E3o (arquivos, observa\00E7\00F5es, links e tags).</')
||'p>',
'',
unistr('<p>As grades de dados s\00E3o relat\00F3rios edit\00E1veis que s\00E3o altamente personaliz\00E1veis. Os usu\00E1rios podem alterar o layout dos dados do relat\00F3rio selecionando as colunas ou aplicando filtros, destacando e classificando. Podem tamb\00E9m definir quebras, agrega')
||unistr('\00E7\00F5es, agrupar por, c\00E1lculos e diferentes gr\00E1ficos, ou ainda criar Inscri\00E7\00F5es para enviar os dados por e-mail em um intervalo designado e criar varia\00E7\00F5es de uma grade de dados e salv\00E1-las como relat\00F3rios com nome para exibi\00E7\00E3o p\00FAblica ou privada.</p>'),
'',
unistr('<p>Al\00E9m de estarem dispon\00EDveis no menu Exibir, os dados de uma grade podem ser inclu\00EDdos como gr\00E1fico ou relat\00F3rio em qualquer p\00E1gina.</p>')))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455871123288297886.4905)
,p_plug_name=>unistr('Relat\00F3rios')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Relat\00F3rios s\00E3o consultas referentes aos objetos do banco de dados que voc\00EA acessou. Para definir um relat\00F3rio, basta selecionar uma tabela ou view dentro de um esquema dispon\00EDvel ou criar algo mais complexo usando o SQL padr\00E3o da ind\00FAstria.</p>'),
'',
unistr('<p>Exatamente como nas grades de dados, os relat\00F3rios s\00E3o altamente personaliz\00E1veis. Os usu\00E1rios podem alterar o layout de dados do relat\00F3rio, selecionando as colunas de seu interesse e aplicando filtros, destacando e classificando.  Eles tamb\00E9m pode')
||unistr('m definir quebras, agrega\00E7\00F5es, agrupar por, c\00E1lculos e diferentes gr\00E1ficos. Uma inscri\00E7\00E3o tamb\00E9m pode ser definida para enviar o relat\00F3rio por e-mail em um intervalo designado. Os usu\00E1rios podem criar v\00E1rias varia\00E7\00F5es de um relat\00F3rio e salv\00E1-las como')
||unistr(' relat\00F3rios nomeados para exibi\00E7\00E3o p\00FAblica ou privada.</p>'),
'',
unistr('<p>Al\00E9m de estarem dispon\00EDveis na guia Dados, os dados de um relat\00F3rio podem ser inclu\00EDdos em qualquer p\00E1gina.</p>'),
''))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_required_role=>wwv_flow_api.id(492214905335570870)
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466849110862832553.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(468686130956258389.4905)
,p_plug_name=>'anchors'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>5
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_list_template_id=>wwv_flow_api.id(171596314926127907.4905)
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
end;
/
prompt --application/pages/page_00016
begin
wwv_flow_api.create_page(
 p_id=>16.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Sobre este Aplicativo'
,p_step_title=>'Sobre este Aplicativo'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style type="text/css" media="screen">',
'	/* Hide left col */',
'	div.wsSideCol {',
'		 display: none !important;',
'	}',
'	div.wsMainCol {',
'		 padding: 5px;',
'	}',
'</style>'))
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(472804823833588483.4905)
,p_plug_name=>'Sobre este Aplicativo'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_plug_template=>wwv_flow_api.id(82536903857665765.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(472809806454619957.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472810527578626072.4905)
,p_name=>'P16_APPLICATION_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>'Nome do Aplicativo'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Identifica o nome deste aplicativo.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472817823619814197.4905)
,p_name=>'P16_CREATED_BY'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>'Criado por'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Identifica quem criou o aplicativo.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472818029160815789.4905)
,p_name=>'P16_CREATED_ON'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>'Criado'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Identifica quando o aplicativo foi criado.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472818901717826724.4905)
,p_name=>'P16_RUN_LINK'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>'Executar Link'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Identifica o URL usado para executar este aplicativo.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472819621719851449.4905)
,p_name=>'P16_WEB_PAGES'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>unistr('P\00E1ginas')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica o n\00FAmero de p\00E1ginas deste aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472823322804880132.4905)
,p_name=>'P16_DATA_GRIDS'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>'Grades de Dados'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica o n\00FAmero de grades de dados deste aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472824025144899716.4905)
,p_name=>'P16_REPORTS'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>unistr('Relat\00F3rios')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_help_text=>unistr('Identifica o n\00FAmero de relat\00F3rios deste aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472827429534042915.4905)
,p_name=>'P16_FILES'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>'Arquivos'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica o n\00FAmero de arquivos deste aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472829909495065498.4905)
,p_name=>'P16_FILE_STORAGE'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>'Armazenamento do Arquivo'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Identifica o tamanho total do arquivo de todos os arquivos deste aplicativo.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472835720408106552.4905)
,p_name=>'P16_PAGE_SECTIONS'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>unistr('Se\00E7\00F5es da P\00E1gina')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica o n\00FAmero de relat\00F3rios deste aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472849515269209062.4905)
,p_name=>'P16_NOTES'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>unistr('Observa\00E7\00F5es')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica o n\00FAmero de observa\00E7\00F5es deste aplicativo')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472849720118210471.4905)
,p_name=>'P16_TAGS'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>'Tags'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica o n\00FAmero de tags deste aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472850124966211939.4905)
,p_name=>'P16_DATAGRID_ROWS'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>'Linhas da Grade de Dados'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica o n\00FAmero de linhas em todas as grades de dados contidas neste aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(484478622627455477.4905)
,p_name=>'P16_DESCRIPTION'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4905)
,p_prompt=>unistr('Descri\00E7\00E3o')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P16_DESCRIPTION'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('A descri\00E7\00E3o do aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(472810926324635162.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set item values'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'    select name, created_by, created_on, id, description',
'    from WWV_FLOW_WS_APPLICATIONS ',
'    where id = :WS_APP_ID and security_group_id = :flow_security_group_id) loop',
'  :P16_APPLICATION_NAME := c1.name;',
'  :P16_CREATED_BY := c1.created_by;',
'  :P16_CREATED_ON := htmldb_util.get_since(c1.created_on);',
'  :P16_RUN_LINK := wwv_flow_utilities.host_url(''SCRIPT'')||''ws?p=''||c1.id||'':home'';',
'  :P16_DESCRIPTION := c1.description;',
'   for c2 in (select count(*) c from WWV_FLOW_WS_WEBPAGES where ws_app_id = c1.id) loop',
'      :P16_WEB_PAGES := to_char(c2.c,''999G999G999G990'');',
'   end loop;',
'   for c2 in (',
'     select count(*) c',
'     from wwv_flow_worksheets w, ',
'             wwv_flow_ws_websheet_attr a',
'     where w.id = a.worksheet_id and',
'         w.security_group_id = :flow_security_group_id and                  ',
'         a.ws_app_id = :ws_app_id and',
'         nvl(a.websheet_type,''DATA'') = ''DATA'') loop',
'    :P16_DATA_GRIDS := to_char(c2.c,''999G999G999G990'');',
'    end loop;',
'    for c2 in (',
'       select count(*) c',
'       from wwv_flow_worksheets w, ',
'              wwv_flow_ws_websheet_attr a',
'       where w.id = a.worksheet_id and',
'                w.security_group_id = :flow_security_group_id and                  ',
'               a.ws_app_id = :ws_app_id and',
'               nvl(a.websheet_type,''DATA'') = ''REPORT'') loop',
'         :P16_REPORTS := c2.c;',
'     end loop;',
'     :P16_files := trim(to_char(wwv_flow_ws_api.get_file_count(p_ws_app_id=>:WS_APP_ID),''999G999G999G990''));',
'     :P16_FILE_STORAGE :=trim(htmldb_util.filesize_mask(wwv_flow_ws_api.get_file_size(p_ws_app_id=>:WS_APP_ID)));',
'     :P16_PAGE_SECTIONS := trim(to_char(wwv_flow_ws_api.get_section_count(p_ws_app_id=>:WS_APP_ID),''999G999G999G990''));',
'     :P16_TAGS := trim(to_char(wwv_flow_ws_api.get_tag_count(p_ws_app_id=>:WS_APP_ID),''999G999G999G990''));',
'     :P16_NOTES := trim(to_char(wwv_flow_ws_api.get_note_count(p_ws_app_id=>:WS_APP_ID),''999G999G999G990''));',
'     :P16_DATAGRID_ROWS := trim(to_char(wwv_flow_ws_api.get_datagrid_row_count(',
'         p_ws_app_id=>:WS_APP_ID),''999G999G999G990''));',
'',
'end loop;'))
);
end;
/
prompt --application/pages/page_00017
begin
wwv_flow_api.create_page(
 p_id=>17.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Sintaxe de Marca\00E7\00E3o')
,p_step_title=>unistr('Sintaxe de Marca\00E7\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456375908174931142.4905)
,p_plug_name=>'URLs Externos'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para incluir links para URLs externos nas se\00E7\00F5es da p\00E1gina, use a sintaxe a seguir. Observe que o uso do identificador <code>''url:''</code> \00E9 opcional. Para abrir o link em uma nova janela do browser, use o prefixo do pop-up.</p>'),
'',
'<p><b>Sintaxe:</b></p>',
'<pre>',
'[[ url: &lt;url> | &lt;link name> ]]',
'[[ popupurl: &lt;url> | &lt;link name> ]]',
'[[ &lt;url> | &lt;link name> ]]',
'</pre>',
'',
'<p><b>Exemplos de Sintaxe:</b></p>',
'<pre>',
'[[url: http://www.oracle.com/store | oraclestore]] ',
'[[popupurl: http://www.oracle.com/store | oraclestore]]',
'[[http://www.google.com | google]] ',
'[[http://www.google.com ]] ',
'</pre>',
'',
'<p><b>Exemplo no Contexto:</b></p>',
'<pre>',
unistr('Voc\00EA pode comprar software Oracle no Site [[http://www.oracle.com/store | Oracle Store]].'),
'</pre>',
'',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456378202762952007.4905)
,p_plug_name=>'Imagens'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Ap\00F3s o upload de uma imagem, voc\00EA pode exibi-la em qualquer se\00E7\00E3o de p\00E1gina de um aplicativo incorporando um link de download com o uso da sintaxe a seguir. Voc\00EA pode referenciar uma imagem transferida por upload usando o nome ou alias da imagem. ')
||unistr('As imagens definidas para a p\00E1gina atual s\00E3o usadas antes daquelas associadas a outras p\00E1ginas. Se os nomes de imagens forem amb\00EDguos, ser\00E1 exibida aquela criada mais recentemente. As propriedades da imagem podem ser definidas para o arquivo ou defin')
||unistr('idas em linha. Se voc\00EA definir atributos em linha, eles ter\00E3o preced\00EAncia sobre os atributos definidos para o arquivo.</p>'),
'',
'<p><b>Sintaxe:</b></p>',
'<pre>',
'[[ image: &lt; file name > | &lt; properties > ]]',
'[[ image: &lt; file alias > | &lt; properties > ]]',
'</pre>',
'',
'<p><b>Exemplos de Sintaxe:</b></p>',
'<pre>',
'[[image: myimage ]]',
'[[image: theimagename.jpg ]]',
'[[image: myimage | width="600" alt="my image" ]]',
'</pre>',
'',
'<p><b>Exemplo no Contexto:</b></p>',
'<pre>',
'Este diagrama [[image: diagram1]] ilustra o workflow.',
'</pre>',
'',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456378508650953757.4905)
,p_plug_name=>unistr('Vincula\00E7\00E3o de P\00E1gina')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para incluir links nas se\00E7\00F5es da p\00E1gina para outras p\00E1ginas de uma Websheet, use a sintaxe descrita a seguir. Observe que o uso do identificador <code>''page:''</code> \00E9 opcional. Se a p\00E1gina existir, um link ser\00E1 exibido; caso contr\00E1rio, ser\00E1 exibi')
||unistr('do um link para cri\00E1-la.</p>'),
'',
'<p><b>Sintaxe:</b></p>',
'<pre>',
'[[ page: &lt;page alias> | &lt;link name> ]]',
'[[ &lt;page alias> | &lt;link name> ]]',
'</pre>',
'',
'<p><b>Exemplos de Sintaxe:</b></p>',
'<pre>',
'[[page: home]] ',
'[[mypage | My Page]] ',
'</pre>',
'',
'<p><b>Exemplo no Contexto:</b></p>',
'<pre>',
unistr('Um dos peixes mais coloridos \00E9 [[ clownfish | Clown fish]].'),
'</pre>',
'',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456378714883955473.4905)
,p_plug_name=>unistr('Vincula\00E7\00E3o da Grade de Dados')
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para incluir links para grades de dados nas se\00E7\00F5es da p\00E1gina, use a sintaxe a seguir. Voc\00EA pode usar esses links para exibir a grade de dados ou criar novos dados. Observe que a grade de dados pode ser uma ou duas palavras.</p>'),
'',
'<p><b>Sintaxe:</b></p>',
'<pre>',
'[[ data grid: &lt;datagrid alias | &lt;link name> ]] ',
'[[ datagrid: &lt;datagrid alias | &lt;link name> ]] ',
'[[ datagrid: &lt;datagrid alias . &lt;saved report name (may not be private)> | &lt;link name> ]] ',
'</pre>',
'',
'<p><b>Exemplos de Sintaxe:</b></p>',
'<pre>',
'[[ data grid: todo list | To Do List ]] ',
'[[ data grid: todo list . open todo items | To Do List ]] ',
'[[ datagrid: todo list | To Do List ]] ',
'</pre>',
'',
'<p><b>No Exemplo no Contexto:</b></p>',
'<pre>',
'Revise [[ data grid: todo list | To Do List ]] e certifique-se de que ',
unistr('as tarefas possam ser realizadas at\00E9 sexta-feira.'),
'</pre>',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456463415491324659.4905)
,p_plug_name=>unistr('Vincula\00E7\00E3o de Se\00E7\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para incluir links para uma se\00E7\00E3o de uma p\00E1gina, use a sintaxe a seguir. Se a se\00E7\00E3o existir, ser\00E1 exibido um link; caso contr\00E1rio, ser\00E1 exibido um link para cri\00E1-la. Observe que, se a se\00E7\00E3o n\00E3o tiver uma p\00E1gina de pref\00E1cio, estar\00E1 presumidamente n')
||unistr('a p\00E1gina atual.</p>'),
'',
'<p><b>Sintaxe:</b></p>',
'<pre>',
'[[ section: &lt;page alias> . &lt;page section> | &lt;link name> ]]',
'[[ section: &lt;page section> | &lt;link name> ]]',
'</pre>',
'',
unistr('<p><b>Exemplo de Sintaxe - Link na p\00E1gina atual:</b></p>'),
'<pre>',
'[[section: clownfish | Clown Fish]] ',
'</pre>',
'',
unistr('<p><b>Exemplo de Sintaxe \2013 Link para outra p\00E1gina:</b></p>'),
'<pre>',
'[[section: fish.clownfish | Clown Fish]] ',
'</pre>',
'',
'<p><b>Exemplos de Contexto:</b></p>',
'<pre>',
unistr('Um dos peixes mais coloridos \00E9 o [[ section: clownfish | Clown fish]].'),
unistr('Visite a p\00E1gina sobre peixes para ver o [[ section: fish . clownfish | Clown fish]], tamb\00E9m conhecido como Nemo.'),
'</pre>',
'',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456475006515549140.4905)
,p_plug_name=>'Anchors'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_list_template_id=>wwv_flow_api.id(171596314926127907.4905)
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456475623830554083.4905)
,p_plug_name=>'SQL'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(506319619645513438.4905)
,p_plug_name=>'SQL Introduction'
,p_parent_plug_id=>wwv_flow_api.id(456475623830554083.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Usando a sintaxe <code>SQL</code> ou <code>SQLVALUE</code>, voc\00EA pode incluir resultados de valor \00FAnico e tabulares de consultas para grades de dados ou tabelas e views nas se\00E7\00F5es de uma p\00E1gina. A tag <code>SQLVALUE</code> exibe a primeira coluna ')
||unistr('da primeira linha retornada pela consulta SQL. Isso permite incorporar dados em uma senten\00E7a (por exemplo: H\00E1 no momento 5 tipos de gatos.). Para resultados tabulares, use a tag <code>SQL</code>. Os resultados da tag <code>SQL</code> s\00E3o exibidos em ')
||unistr('um relat\00F3rio pesquis\00E1vel. Por padr\00E3o, entretanto, a op\00E7\00E3o de pesquisa pode ser desativada usando-se a sintaxe <code>NOSEARCH</code>.</p>'),
'',
unistr('<p>Quando se trabalha com grades de dados, h\00E1 outras op\00E7\00F5es, mostradas em Sintaxe, e mais regras. As regras b\00E1sicas ao gravar uma consulta de grade de dados incluem:</p>'),
'<p>',
'<ul>',
'<li>O nome ou alias da grade de dados deve estar entre chaves. Por exemplo:',
'<pre>{Fatos sobre Felinos}</pre></li>',
'<li>Os nomes das colunas da Grade de Dados devem estar entre aspas duplas. Por exemplo:',
'<pre>"Tipo de Felino"</pre></li>',
'</ul>',
unistr('As regras avan\00E7adas s\00E3o detalhadas na \00FAltima se\00E7\00E3o.'),
'</p>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(506320009733520103.4905)
,p_plug_name=>'SQL Syntax'
,p_parent_plug_id=>wwv_flow_api.id(456475623830554083.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p><b>Sintaxe para Consultas em Tabelas ou Views:</b></p>',
'<pre>',
'[[sql: &lt;select statement> ]]',
'[[sql: &lt;select statement | limit="&lt;maximum rows>" nosearch style="&lt;style number>" ]]',
'[[sqlvalue: &lt;select statement> ]]',
'</pre>',
'',
'<p><b>Sintaxe para Consultas de Grade de Dados:</b></p>',
'<pre>',
'[[sql: &lt;select statement> ]]',
'[[sql: &lt;select statement | limit="&lt;maximum rows>" nosearch style="&lt;style number>" edit_row add_row show_sql ]]',
'[[sqlvalue: &lt;select statement> ]]',
'[[sqlvalue: &lt;select statement> | show_sql ]]',
'</pre>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(506320222200523729.4905)
,p_plug_name=>'SQL Examples'
,p_parent_plug_id=>wwv_flow_api.id(456475623830554083.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>120
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p><b>Exemplos de Sintaxe de Tag SQL em Contexto:</b></p>',
'<pre>',
unistr('Veja aqui um relat\00F3rio de no m\00E1ximo 10 funcion\00E1rios que trabalham no departamento 10: '),
unistr('[[sql: select ename "Nome do Funcion\00E1rio", sal "Sal\00E1rio" from emp order by sal desc | limit="10" style="2"]].'),
'[[sql: select "Tipo de Felino",',
unistr('              "Popula\00E7\00E3o Estimada",'),
unistr('              "Maiores Amea\00E7as",'),
unistr('              "Velocidade M\00E1xima",'),
unistr('              "Nome Cient\00EDfico",'),
'              "Status IUCN",',
'              "Peso",',
'              "Data do Estudo"',
'       from {Fatos sobre Felinos} | add_row edit_row ]]',
'</pre>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(506321126618543925.4905)
,p_plug_name=>'SQLVALUE Tag Example'
,p_parent_plug_id=>wwv_flow_api.id(456475623830554083.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>130
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p><b>Nos Exemplos de Sintaxe da Tag SQLVALUE do Contexto:</b></p>',
'<pre>',
unistr('Temos [[sqlvalue: select count(*) from emp]] funcion\00E1rios em nosso banco de dados, '),
'[[sqlvalue: select count(*) from emp where deptno=10 ]] trabalham no departamento 10.',
'Estamos no momento rastreando [[sqlvalue: select count(*) from {Fatos sobre Felinos} ]] tipos gatos.',
'</pre>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456684602920305675.4905)
,p_plug_name=>unistr('Vincula\00E7\00E3o do Relat\00F3rio')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para incluir links para uma se\00E7\00E3o de uma p\00E1gina, use a sintaxe a seguir.</p>'),
'',
'<p><b>Sintaxe:</b></p>',
'<pre>',
'[[ report: &lt;report alias> | &lt;link name> ]]',
'[[ report: &lt;report alias> . &lt;saved report name (may not be private)> | &lt;link name> ]] ',
'</pre>',
'',
'<p><b>Exemplos de Sintaxe:</b></p>',
'<pre>',
'[[ report: fish | marine fish ]]',
'[[ report: fish . my favorite | marine fish ]] ',
'',
'</pre>',
'',
'<p><b>Exemplo no Contexto:</b></p>',
'<pre>',
'Exiba o [[ report: fish | perfect temperature ]] peixe selecionado.',
'</pre>'))
,p_plug_required_role=>wwv_flow_api.id(492214905335570870)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456722229827231075.4905)
,p_plug_name=>'Arquivos'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Voc\00EA pode incorporar links de download em uma se\00E7\00E3o de p\00E1gina usando a sintaxe a seguir.<p/>'),
'',
'<p><b>Sintaxe:</b></p>',
'<pre>',
'[[ file: &lt; file name > | &lt; link name > ]]',
'[[ file: &lt; file alias > | &lt; link name > ]]',
'</pre>',
'',
'<p><b>Exemplos de Sintaxe:</b></p>',
'<pre>',
'[[file: myfile ]]',
'[[file: myfile.xls ]]',
'[[file: myfile | My File ]]',
'</pre>',
'',
'<p><b>Exemplo no Contexto:</b></p>',
'<pre>',
unistr('Este [[file: parts01.xls | spreadsheet ]] documenta nossos n\00FAmeros de componente.'),
'</pre>'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466849412509851927.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752825018135722319.4905)
,p_plug_name=>unistr('Consultas de Grade de Dados Avan\00E7adas')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>105
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>As regras de consulta de grade de dados avan\00E7ada incluem:</p>'),
'<p>',
'<ul>',
unistr('<li>A consulta deve fazer refer\00EAncia \00E0 grade de dados s\00F3 uma vez, para incluir um link de edi\00E7\00E3o ou adi\00E7\00E3o de linha (ou seja, voc\00EA n\00E3o pode juntar a grade de dados a si mesma dentro da consulta).</li>'),
unistr('<li>A primeira coluna deve ser a chave prim\00E1ria (ou seja, a coluna que identifica com exclusividade a linha de dados) da grade de dados para incluir um link de edi\00E7\00E3o de linha. Se a op\00E7\00E3o "edit_row" for inclu\00EDda e a consulta tiver uma instru\00E7\00E3o de se')
||unistr('le\00E7\00E3o \00FAnica, a coluna de chave prim\00E1ria ser\00E1 inclu\00EDda automaticamente. Se a consulta contiver v\00E1rias instru\00E7\00F5es de sele\00E7\00E3o, voc\00EA poder\00E1 usar a substitui\00E7\00E3o <code>"APXWS_DATA_GRID_PK"</code> (sempre entre aspas duplas) como a primeira coluna na instru')
||unistr('\00E7\00E3o de sele\00E7\00E3o para inclus\00E3o da chave prim\00E1ria, para incluir um link de edi\00E7\00E3o de linha.</li>'),
unistr('<li>Os nomes de colunas de relat\00F3rio ser\00E3o o nome da coluna da grade de dados, mas podem ser modificados usando-se a sintaxe de alias da coluna SQL padr\00E3o. O exemplo a seguir exibe dos dados da coluna "N\00FAmero M\00EDnimo", mas o cabe\00E7alho ser\00E1 exibido com')
||unistr('o "M\00EDn":'),
unistr('<pre>selecione "N\00FAmero M\00EDnimo" "M\00EDn" em ...</pre></li>'),
unistr('<li>Se um nome de coluna tiver mais de 30 caracteres, inclua s\00F3 os primeiros 30 como o nome. Por exemplo, use: '),
unistr('<pre>"% de Le\00F5es Estimado em Cada Re"</pre> '),
'em vez de:',
unistr('<pre>"% de Le\00F5es Estimado em Cada Regi\00E3o"</pre>'),
unistr('<li>Para exibir a consulta executada, inclua a op\00E7\00E3o "show_sql". Isso faz com que a consulta seja exibida acima do relat\00F3rio inclu\00EDdo. embora seja uma boa estrat\00E9gia para depura\00E7\00E3o, a Oracle n\00E3o recomenda "show_sql" em aplicativos de produ\00E7\00E3o.</li>'),
'</ul>',
'</p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00018
begin
wwv_flow_api.create_page(
 p_id=>18.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Views de P\00E1gina')
,p_step_title=>unistr('Views de P\00E1gina')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23684126174999945.4905)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23684522796999946.4905)
,p_plug_name=>'Set Page'
,p_parent_plug_id=>wwv_flow_api.id(23684126174999945.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>200
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<div class="wsSmallFormComponent">'
,p_plug_footer=>'</div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23691322028074401.4905)
,p_plug_name=>'Monitor Activity Tab'
,p_parent_plug_id=>wwv_flow_api.id(23684126174999945.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23689225706066046.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459633427711416362.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459640000854444211.4905)
,p_plug_name=>'Page Views'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    time_stamp,',
'    (select name from wwv_flow_steps p where p.id = l.step_id and p.flow_id = 4900) component_name,',
'    webpage_id,',
'    decode(webpage_id,null,null,(',
'       select max(name)',
'       from wwv_flow_ws_webpages p',
'       where p.ws_app_id = :ws_app_id',
'       and p.security_group_id = :flow_security_group_id',
'       and p.id = l.webpage_id)) page_name,',
'    elap,',
'    num_rows,',
'    lower(userid) userid,',
'    session_id,',
'    substr(user_agent,1,100) user_agent,',
'    sqlerrm,',
'   websheet_id,',
'   worksheet_id,',
'   ir_search,',
'   CONTENT_LENGTH',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - nvl(:P18_TIME,1)) and',
'    ( flow_id = 4900 ) and',
'    websheet_id = :ws_app_id and',
'    webpage_id in (select id from wwv_flow_ws_webpages where ws_app_id = :ws_app_id and security_group_id = :flow_security_group_id)'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(459640129876444211.4905)
,p_name=>'Page Views'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459640328679444227.4905)
,p_db_column_name=>'TIME_STAMP'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Data'
,p_column_type=>'DATE'
,p_heading_alignment=>'LEFT'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459640430971444230.4905)
,p_db_column_name=>'ELAP'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Tempo de Renderiza\00E7\00E3o')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'LEFT'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459640528870444230.4905)
,p_db_column_name=>'NUM_ROWS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Linhas'
,p_column_type=>'NUMBER'
,p_heading_alignment=>'LEFT'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459640631431444230.4905)
,p_db_column_name=>'USERID'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('Usu\00E1rio')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459641100631444231.4905)
,p_db_column_name=>'SESSION_ID'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('Sess\00E3o')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459641220629444231.4905)
,p_db_column_name=>'USER_AGENT'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('Agente do Usu\00E1rio')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459641414761444232.4905)
,p_db_column_name=>'SQLERRM'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>'Mensagem de Erro'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459642022665444233.4905)
,p_db_column_name=>'WEBSHEET_ID'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>'Websheet'
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459642106997444233.4905)
,p_db_column_name=>'WORKSHEET_ID'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>'Planilha'
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459642211221444233.4905)
,p_db_column_name=>'IR_SEARCH'
,p_display_order=>20
,p_column_identifier=>'T'
,p_column_label=>'Pesquisar Texto'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459642314321444233.4905)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('Tamanho do Conte\00FAdo')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459654731381564614.4905)
,p_db_column_name=>'WEBPAGE_ID'
,p_display_order=>23
,p_column_identifier=>'W'
,p_column_label=>unistr('ID da P\00E1gina')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459654904510641947.4905)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>24
,p_column_identifier=>'X'
,p_column_label=>unistr('Nome da P\00E1gina')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459656813953701510.4905)
,p_db_column_name=>'COMPONENT_NAME'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>'Nome do Componente'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(459653504454537879.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(459640000854444211.4905)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:18,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459652428040497404.4905)
,p_name=>'P18_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(23684522796999946.4905)
,p_item_default=>'1'
,p_prompt=>'Prazo'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Exibir dados do relat\00F3rio no per\00EDodo de relat\00F3rios selecionado.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00019
begin
wwv_flow_api.create_page(
 p_id=>19.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Perguntas Mais Frequentes'
,p_step_title=>'Perguntas Mais Frequentes'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style type="text/css" media="screen">',
'	/* Hide left col */',
'	div.wsSideCol {',
'		 display: none !important;',
'	}',
'	div.wsMainCol {',
'		 padding: 5px;',
'	}',
'</style>'))
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(487174720945604524.4905)
,p_plug_name=>'Perguntas Mais Frequentes'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<p><ol>'');',
'for i in 1..6 loop',
'    sys.htp.p(''<li>'');',
'    sys.htp.p(''<b>''||wwv_flow_lang.system_message(''WEBSHEETS_FAQ_Q''||i)||''</b>'');',
'    sys.htp.p(''<p>''||wwv_flow_lang.system_message(''WEBSHEETS_FAQ_A''||i)||''</p>'');',
'    sys.htp.p(''</li>'');',
'end loop;',
'sys.htp.p(''</ol></p>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(487175204107609089.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
end;
/
prompt --application/pages/page_00020
begin
wwv_flow_api.create_page(
 p_id=>20.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Adicionar/Editar Linha'
,p_step_title=>'Adicionar/Editar Linha'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'.ie7 table.wsTable,',
'.ie9 table.wsTable { width: 100%;}',
'</style>'))
,p_step_template=>wwv_flow_api.id(9297021464956579.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(456220226828170850)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_comment=>'onload="wsPageInit(); $x_Hide(''R177113009695013686'');"'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3156111248550044.4905)
,p_plug_name=>'HIDDEN FORM ELEMENTS'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(173336062654423126.4905)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18840420076327189.4905)
,p_plug_name=>'Toolbar Right Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(60003614641461883.4905)
,p_plug_name=>'edit row'
,p_region_name=>'row'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_validation_passed varchar2(1) := null;  ',
'begin',
'  if :P20_VALIDATION_CNT > 0 then',
'    l_validation_passed := ''N'';',
'  else',
'    l_validation_passed := ''Y'';',
'  end if;',
'',
'  wwv_flow_ws_form.show (',
'    p_ws_app_id            => :WS_APP_ID,',
'    p_worksheet_id         => :P2_ID,',
'    p_data_grid_id         => :P2_WEBSHEET_ID,',
'    p_session              => :APP_SESSION,',
'    p_app_user             => :APP_USER,',
'    p_row_id               => :CURRENT_WORKSHEET_ROW,         ',
'    p_base_report_id       => :RPT_ID,',
'    p_partial_page_refresh => false,    ',
'    p_validation_passed    => l_validation_passed,',
'    p_last_page_id         => :P20_LAST_PAGE_ID,',
'    p_last_section_id      => :P20_LAST_SECTION_ID',
'    );',
'',
'  sys.htp.prn(''<span id="apexir_LOADER" style="display:none;" role="alert">'');',
'  sys.htp.prn(''<img alt="''||wwv_flow_lang.system_message(''WAITING.GENERIC'')||''" src="''||wwv_flow.g_image_prefix||''ws/ajax-loader.gif" />'');',
'  sys.htp.prn(''</span>'');    ',
'',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(81681415007489705.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466744416033456525.4905)
,p_plug_name=>'Ajax Notification Holder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'<div class="htmldbNotification" id="ajaxMESSAGE" style="display:none;"><img src="#IMAGE_PREFIX#delete.gif" onclick="apex.jQuery(''#ajaxMESSAGE'').hide();"  style="float:right;" class="pb" alt="" /><div id="theMESSAGE"></div></div>'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(617574631447733199.4905)
,p_plug_name=>unistr('A\00E7\00F5es')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_form.show_actions (',
'    p_ws_app_id       => :WS_APP_ID,',
'    p_ir_id           => :P2_ID,',
'    p_data_grid_id    => :P2_WEBSHEET_ID,',
'    p_row_id          => :CURRENT_WORKSHEET_ROW',
'    );'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'CURRENT_WORKSHEET_ROW'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(18840704623332140.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(18840420076327189.4905)
,p_button_name=>'BACK'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
,p_button_condition_type=>'NEVER'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(157417700068555483.4905)
,p_branch_action=>'&P20_RETURN_URL.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'PLSQL_EXPRESSION'
,p_branch_condition=>':REQUEST in (''CREATE'',''APPLY_CHANGES'',''DELETE'') and :P20_RETURN_URL is not null'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3142429378139099.4905)
,p_branch_action=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>60
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'ATTACHMENT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(157307002240912816.4905)
,p_branch_action=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>70
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3040322372230697.4905)
,p_name=>'P20_DESC'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4905)
,p_prompt=>unistr('Descri\00E7\00E3o')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3142702413159613.4905)
,p_name=>'P20_X'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4905)
,p_display_as=>'NATIVE_FILE'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'WWV_FLOW_FILES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(10603912332220266.4905)
,p_name=>'P20_LAST_SECTION_ID'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(253264503612911225.4905)
,p_name=>'P20_LAST_PAGE_ID'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(254176711273952957.4905)
,p_name=>'P20_RETURN_URL'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(636400801424215275.4905)
,p_name=>'P20_VALIDATION_CNT'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2495429001405484202.4905)
,p_name=>'P20_IR_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2495429311101487046.4905)
,p_name=>'P20_DATA_GRID_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2495988315189126716.4905)
,p_name=>'P20_ROW_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(2495429625300491103.4905)
,p_computation_sequence=>10
,p_computation_item=>'P2_ID'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'P20_IR_ID'
,p_compute_when=>'P20_IR_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(2495430601190493614.4905)
,p_computation_sequence=>20
,p_computation_item=>'P2_WEBSHEET_ID'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'P20_DATA_GRID_ID'
,p_compute_when=>'P20_DATA_GRID_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(254184217200086883.4905)
,p_computation_sequence=>40
,p_computation_item=>'P20_RETURN_URL'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_url             varchar2(4000);',
'    l_page_alias      varchar2(255);',
'    l_data_grid_alias varchar2(255);',
'begin               ',
'    if :P20_LAST_PAGE_ID is not null then',
'        l_page_alias := wwv_flow_ws_api.get_page_alias(p_ws_app_id => :WS_APP_ID,p_page_id=> :P20_LAST_PAGE_ID);',
'        l_url := wwv_flow_ws_webpage.get_url (',
'                    p_ws_app_id   => :WS_APP_ID,',
'                    p_session     => :APP_SESSION,',
'                    p_alias       => l_page_alias,',
'                    p_url_postfix => ''#SECTION_''||:P20_LAST_SECTION_ID);',
'    else',
'        l_data_grid_alias := wwv_flow_ws_api.get_data_grid_alias(p_ws_app_id => :WS_APP_ID,p_data_grid_id=> :P20_DATA_GRID_ID);',
'        l_url := wwv_flow_ws_webpage.get_url (',
'                    p_ws_app_id   => :WS_APP_ID,',
'                    p_session     => :APP_SESSION,',
'                    p_alias       => ''DG_''||l_data_grid_alias);',
'    end if;',
'    return l_url;',
'end;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(471737310147352854.4905)
,p_computation_sequence=>20
,p_computation_item=>'WORKSHEET_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>'return wwv_flow_ws_api.get_websheet_name(p_worksheet_id => :p2_id);'
,p_computation_error_message=>unistr('N\00E3o \00E9 obter o nome da Grade de Dados.')
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(162010510295416465.4905)
,p_computation_sequence=>30
,p_computation_item=>'F4900_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'20'
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(458952427548535993.4905)
,p_validation_name=>'process row'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_validation_error varchar2(32767);',
'  l_validation_count number;',
'begin',
'',
'wwv_flow_ws_api.process_row (',
'    p_ws_app_id     => :WS_APP_ID,',
'    p_worksheet_id  => :P2_ID,',
'    p_websheet_id   => :P2_WEBSHEET_ID,',
'    p_row_id        => :CURRENT_WORKSHEET_ROW,',
'    f01             => wwv_flow.g_f01,',
'    f02             => wwv_flow.g_f02,   ',
'    p_validation_error => l_validation_error,',
'    p_validation_count => l_validation_count,',
'    p_ajax_mode     => false );',
'',
'  :P20_VALIDATION_CNT :=  l_validation_count;',
'',
'  return '''';',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>unistr('Ocorreu um erro de valida\00E7\00E3o.')
,p_validation_condition=>'CREATE_AND_CREATE_ANOTHER,CREATE,APPLY_CHANGES'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(.4905)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(157440521988694296.4905)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Delete Row'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.delete_row(',
'    p_websheet_id   => :P2_WEBSHEET_ID,',
'    p_row_id        => :CURRENT_WORKSHEET_ROW);'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel processar a solicita\00E7\00E3o.')
,p_process_when=>'DELETE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00022
begin
wwv_flow_api.create_page(
 p_id=>22.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Sintaxe de SQL da Grade de Dados'
,p_step_title=>'Sintaxe de SQL da Grade de Dados'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(456220226828170850)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6247329636592604.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6498131507796437.4905)
,p_plug_name=>'Data Grids'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.p22_data_grid_list (',
'    p_app_id       => :app_id,',
'    p_app_session  => :app_session,',
'    p_ws_app_id    => :ws_app_id,',
'    p_data_grid_id => :P22_DATA_GRID_ID);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6674628032470220.4905)
,p_plug_name=>'Colunas em &P22_DATA_GRID_NAME.'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.p22_data_grid_columns (',
'    p_data_grid_id   => :P22_DATA_GRID_ID);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P22_DATA_GRID_ID'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6707429061744964.4905)
,p_plug_name=>'Consultas baseadas em &P22_DATA_GRID_NAME.'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.p22_data_grid_query (',
'    p_data_grid_id   => :P22_DATA_GRID_ID);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P22_DATA_GRID_ID'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>Selecione uma grade de dados \00E0 esquerda para gerar consultas SQL e SQLVALUE que voc\00EA pode usar no seu aplicativo.</p>')
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11359532303186287.4905)
,p_plug_name=>'Sem Grades de Dados'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(1071999318750156264.4905)
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NULL'
,p_plug_display_when_condition=>'P22_DATA_GRID_ID'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<div class="wsPageMessage">O aplicativo n\00E3o tem Grades de Dados.</div>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(133788708672776881.4905)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(248081616517731203.4905)
,p_plug_name=>unistr('Link de marca\00E7\00E3o para &P22_DATA_GRID_NAME.')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>75
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''ws?p=''||:WS_APP_ID||'':DG_''||:P22_DATA_GRID_ALIAS);',
'sys.htp.p(''<br />'');',
'sys.htp.p(''ws?p=''||:WS_APP_ID||'':DG_''||:P22_DATA_GRID_ALIAS||''::ROW_ID:[DATA_GRID_ROW_ID]'');',
'sys.htp.p(''<br /><br />'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P22_DATA_GRID_ID'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>'<p>Para marcar com bookmark diretamente para uma Grade de Dados ou uma linha, use a seguinte sintaxe:</p>'
,p_plug_footer=>unistr('<p>Observa\00E7\00E3o: o DATA_GRID_ROW_ID \00E9 um valor de coluna de ID da tabela APEX$_WS_ROWS.  Voc\00EA pode obter um link para uma linha de Grade de Dados espec\00EDfica, executando uma Grade de Dados; clique em editar \00EDcone de linha e obtenha o URL do browser.</p>')
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(268418006320837162.4905)
,p_plug_name=>unistr('Vincular para &P22_DATA_GRID_NAME. (Sintaxe de Marca\00E7\00E3o)')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>85
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para incluir links para grades de dados nas se\00E7\00F5es da p\00E1gina, use a sintaxe a seguir. Voc\00EA pode usar esses links para exibir a grade de dados ou criar novos dados. Observe que a grade de dados pode ser uma ou duas palavras.</p>'),
'',
'<p><b>Sintaxe:</b></p>',
'<pre>',
'[[ data grid: &lt;datagrid alias | &lt;link name> ]] ',
'[[ datagrid: &lt;datagrid alias | &lt;link name> ]] ',
'[[ datagrid: &lt;datagrid alias . &lt;saved report name (may not be private)> | &lt;link name> ]] ',
'</pre>',
'',
'<p><b>Exemplos de Sintaxe:</b></p>',
'<pre>',
'[[ data grid: todo list | To Do List ]] ',
'[[ data grid: todo list . open todo items | To Do List ]] ',
'[[ datagrid: todo list | To Do List ]] ',
'</pre>',
'',
'<p><b>No Exemplo no Contexto:</b></p>',
'<pre>',
'Revise [[ data grid: todo list | To Do List ]] e certifique-se de que ',
unistr('as tarefas possam ser realizadas at\00E9 sexta-feira.'),
'</pre>',
''))
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P22_DATA_GRID_ID'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6706611868673736.4905)
,p_name=>'P22_DATA_GRID_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(133788708672776881.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(248170113574405575.4905)
,p_name=>'P22_DATA_GRID_ALIAS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(133788708672776881.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(605139824509083611.4905)
,p_name=>'P22_DATA_GRID_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(133788708672776881.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(8467419570074984.4905)
,p_computation_sequence=>10
,p_computation_item=>'P22_DATA_GRID_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id',
'from wwv_flow_ws_websheet_attr',
'where security_group_id = :flow_security_group_id',
'and ws_app_id = :ws_app_id',
'and rownum = 1',
'order by websheet_name',
''))
,p_compute_when=>'P22_DATA_GRID_ID'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(248170305595409210.4905)
,p_computation_sequence=>10
,p_computation_item=>'P22_DATA_GRID_ALIAS'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_alias',
'from wwv_flow_ws_websheet_attr',
'where security_group_id = :flow_security_group_id',
'and ws_app_id = :ws_app_id',
'and id = :P22_DATA_GRID_ID'))
,p_compute_when=>'P22_DATA_GRID_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(605211826718093751.4905)
,p_computation_sequence=>10
,p_computation_item=>'P22_DATA_GRID_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name',
'from wwv_flow_ws_websheet_attr',
'where security_group_id = :flow_security_group_id',
'and ws_app_id = :ws_app_id',
'and id = :P22_DATA_GRID_ID',
''))
,p_compute_when=>'P22_DATA_GRID_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00024
begin
wwv_flow_api.create_page(
 p_id=>24.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Principais P\00E1ginas')
,p_step_title=>unistr('Principais P\00E1ginas')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459659409774763317.4905)
,p_plug_name=>'Page Views'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    webpage_id,',
'    decode(webpage_id,null,null,(',
'       select max(name)',
'       from wwv_flow_ws_webpages p',
'       where p.ws_app_id = :ws_app_id',
'       and p.id = l.webpage_id)) page_name,',
'    count(*) page_views,',
'    avg(elap) elap,',
'    avg(num_rows) num_rows,',
'    count(distinct userid) userid,',
'    avg(content_length) CONTENT_LENGTH,',
'  sum(CONTENT_LENGTH) content_served,',
'   sum(elap) page_generation_time,',
'   max(time_stamp) last_view',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - nvl(:P24_TIME,1)) and',
'    ( flow_id = 4900 ) and',
'    websheet_id = :ws_app_id and',
'    webpage_id is not null  and',
'    webpage_id in (select id from wwv_flow_ws_webpages where ws_app_id = :ws_app_id and security_group_id = :flow_security_group_id)',
'group by     webpage_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(459659605981763318.4905)
,p_name=>'Page Views'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459659820880763321.4905)
,p_db_column_name=>'ELAP'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Tempo M\00E9dio de Convers\00E3o')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459659905607763326.4905)
,p_db_column_name=>'NUM_ROWS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('M\00E9dia de Linhas')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459660912570763334.4905)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('Conte\00FAdo M\00E9dio do Texto')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459661125550763335.4905)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>24
,p_column_identifier=>'X'
,p_column_label=>unistr('Nome da P\00E1gina')
,p_column_link=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.::WS_APP_ID,P900_ID:&WS_APP_ID.,#WEBPAGE_ID#'
,p_column_linktext=>'#PAGE_NAME#'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459663826561790231.4905)
,p_db_column_name=>'USERID'
,p_display_order=>25
,p_column_identifier=>'Y'
,p_column_label=>unistr('Usu\00E1rios Distintos')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459664004874793441.4905)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('Views de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471969020072698244.4905)
,p_db_column_name=>'CONTENT_SERVED'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>unistr('Conte\00FAdo Fornecido')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471969215286698247.4905)
,p_db_column_name=>'PAGE_GENERATION_TIME'
,p_display_order=>29
,p_column_identifier=>'AC'
,p_column_label=>unistr('Tempo de Gera\00E7\00E3o da P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(479550923423223017.4905)
,p_db_column_name=>'WEBPAGE_ID'
,p_display_order=>30
,p_column_identifier=>'AD'
,p_column_label=>unistr('P\00E1gina Web')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(479557502570311662.4905)
,p_db_column_name=>'LAST_VIEW'
,p_display_order=>31
,p_column_identifier=>'AE'
,p_column_label=>unistr('\00DAltima View')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459661531662763337.4905)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23692317442092071.4905)
,p_plug_name=>'Monitor Activity Tab'
,p_parent_plug_id=>wwv_flow_api.id(459661531662763337.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23689225706066046.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23692521944093325.4905)
,p_plug_name=>'Set Page'
,p_parent_plug_id=>wwv_flow_api.id(459661531662763337.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<div class="wsSmallFormComponent">'
,p_plug_footer=>'</div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459662911407766995.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(459661713093763338.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(459659409774763317.4905)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:24,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459661926271763339.4905)
,p_name=>'P24_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(23692521944093325.4905)
,p_item_default=>'1'
,p_prompt=>'Prazo'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Exibir dados do relat\00F3rio no per\00EDodo de relat\00F3rios selecionado.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00025
begin
wwv_flow_api.create_page(
 p_id=>25.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Links da P\00E1gina e da Se\00E7\00E3o')
,p_step_title=>unistr('Links da P\00E1gina e da Se\00E7\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488510805876131179.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491313913908782031.4905)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491318015433867606.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4905)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>Copie o link da p\00E1gina ou da se\00E7\00E3o e cole-o no texto da se\00E7\00E3o para criar um link em uma p\00E1gina.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491577932536354374.4905)
,p_plug_name=>unistr('Links para P\00E1ginas')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select p.name page_name, ',
'       decode(a.home_page_id, p.id, ''[[ page: ''||p.name||'' ]]'', ',
'          ''[[ page: ''||p.page_alias||'' | ''||p.name||'' ]]'') page_link',
'from wwv_flow_ws_webpages p,',
'     wwv_flow_ws_applications a',
'where p.security_group_id = :flow_security_group_id ',
'  and p.ws_app_id = :ws_app_id',
'  and p.ws_app_id = a.id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(491578027851354374.4905)
,p_name=>'Page and Section Links'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491578208150354381.4905)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('P\00E1gina')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491578311606354385.4905)
,p_db_column_name=>'PAGE_LINK'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Link de P\00E1gina')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(488510218502131175.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(491577932536354374.4905)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(491599426242893169.4905)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create section collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_section_collection (',
'    p_security_group_id => :flow_security_group_id,',
'    p_ws_app_id         => :ws_app_id',
'    );'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar a coleta.')
);
end;
/
prompt --application/pages/page_00026
begin
wwv_flow_api.create_page(
 p_id=>26.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Fazer Upload da Planilha (Ponto Final Ajax)'
,p_step_title=>'Fazer Upload da Planilha (Ponto Final Ajax)'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(157592926751064610)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(157427219470636840.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'SPREADSHEET_SAVE'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_code clob := empty_clob;',
'begin',
'   sys.dbms_lob.createtemporary( l_code, false, sys.dbms_lob.SESSION );',
'   for i in 1..wwv_flow.g_f02.count loop',
'        sys.dbms_lob.writeappend(l_code,length(wwv_flow.g_f02(i)),wwv_flow.g_f02(i));',
'    end loop;',
'apex_collection.create_or_truncate_collection(p_collection_name=>''SPREADSHEET_CONTENT'');',
'apex_collection.add_member(p_collection_name=>''SPREADSHEET_CONTENT'',p_c001=>wwv_flow.g_f01(1),p_clob001=>l_code);',
'sys.htp.prn(''success'');',
'htmldb_application.g_unrecoverable_error := TRUE;',
'end;'))
);
end;
/
prompt --application/pages/page_00027
begin
wwv_flow_api.create_page(
 p_id=>27.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Arquivos'
,p_step_title=>'Arquivos'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488523103160992637.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491316430100805612.4905)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491454229828060959.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4905)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Crie links para fazer download dos arquivos usando a sintaxe [[FILE: ]] ou exiba as imagens em linha usando a sintaxe [[IMAGE: ]].</p>'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491582707308395779.4905)
,p_plug_name=>'Arquivos'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="clear: both"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select (select name from wwv_flow_ws_webpages ',
'         where id = n003 and ws_app_id = n002 ',
'           and security_group_id=:flow_security_group_id) page_name,',
'       (select w.id from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr ws ',
'         where w.id=ws.worksheet_id and ws.id = n004 ',
'           and w.security_group_id=:flow_security_group_id) worksheet_id,',
'       (select websheet_name from wwv_flow_ws_websheet_attr ',
'         where id = n004 and ws_app_id = n002 ',
'           and security_group_id=:flow_security_group_id) data_grid_name,',
'       c001 component_level,',
'       c002 file_name,',
'       c003 image_alias,',
'       c008 description,',
'       c009 created_by,',
'       to_number(c011) doc_size,',
'       ''[[ file: ''||c003||'' | ''||c002||'' ]]'' file_link,',
'       ''[[ image: ''||c003||'' | title="''||c002||''" ]]'' image_link,',
'       d001 created_on',
'  from wwv_flow_collections',
' where collection_name = ''APEX$_WS_FILES'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(491582908789395824.4905)
,p_name=>'Attachments'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_link_column=>'ICON_LINK'
,p_icon_view_img_src_column=>'ICON_IMG'
,p_icon_view_label_column=>'ICON_NAME'
,p_icon_view_columns_per_row=>5
,p_owner=>'CBCHO'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491584227347395830.4905)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('P\00E1gina')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491584331848395830.4905)
,p_db_column_name=>'DATA_GRID_NAME'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Grade de Dados'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491584421517395830.4905)
,p_db_column_name=>'COMPONENT_LEVEL'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('N\00EDvel')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491584708827395830.4905)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>unistr('Descri\00E7\00E3o')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491585006345395831.4905)
,p_db_column_name=>'WORKSHEET_ID'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>'Id da Planilha'
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491585118316395831.4905)
,p_db_column_name=>'FILE_NAME'
,p_display_order=>22
,p_column_identifier=>'V'
,p_column_label=>'Nome do Arquivo'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491583420164395827.4905)
,p_db_column_name=>'IMAGE_ALIAS'
,p_display_order=>31
,p_column_identifier=>'AE'
,p_column_label=>'Alias'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491591904650603108.4905)
,p_db_column_name=>'FILE_LINK'
,p_display_order=>32
,p_column_identifier=>'AF'
,p_column_label=>'Link do Arquivo'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491592915647625219.4905)
,p_db_column_name=>'IMAGE_LINK'
,p_display_order=>33
,p_column_identifier=>'AG'
,p_column_label=>'Link de Imagem'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(495846530207735868.4905)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>34
,p_column_identifier=>'AH'
,p_column_label=>'Criado'
,p_column_type=>'DATE'
,p_heading_alignment=>'LEFT'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(495848524451743667.4905)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>35
,p_column_identifier=>'AI'
,p_column_label=>'Criado por'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(495860525237800639.4905)
,p_db_column_name=>'DOC_SIZE'
,p_display_order=>36
,p_column_identifier=>'AJ'
,p_column_label=>'Tamanho'
,p_column_type=>'NUMBER'
,p_heading_alignment=>'LEFT'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(488522502529992636.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(491582707308395779.4905)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(491585815273398010.4905)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create file collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_attachment_collection (',
'    p_ws_app_id    => :ws_app_id',
'    );'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar a coleta.')
);
end;
/
prompt --application/pages/page_00028
begin
wwv_flow_api.create_page(
 p_id=>28.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Links da Se\00E7\00E3o')
,p_step_title=>unistr('Links da Se\00E7\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492133721971626990.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492133918103626991.4905)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492134119027626992.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4905)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>Copie o link da p\00E1gina ou da se\00E7\00E3o e cole-o no texto da se\00E7\00E3o para criar um link em uma p\00E1gina.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492134510311626995.4905)
,p_plug_name=>unistr('Links da Se\00E7\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select p.name page_name, ',
'       s.c001 section_name,',
'       s.c002 section_type,',
'       decode(s.n001, NULL, NULL, ''[[ section: ''||p.page_alias||''.''||s.c001||',
'              '' |  ''||s.c001||'' ]]'') section_link,',
'       s.n003 section_seq',
'from wwv_flow_ws_webpages p,',
'     wwv_flow_ws_applications a,',
'     wwv_flow_collections s',
'where p.security_group_id = :flow_security_group_id ',
'  and p.ws_app_id = :ws_app_id',
'  and p.ws_app_id = a.id',
'  and p.id = s.n002 (+)',
'  and s.collection_name (+) = ''APEX$_WS_SECTIONS''',
'  and s.c002 != ''PLSQL'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(492134718217626996.4905)
,p_name=>'Page and Section Links'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492134831239626996.4905)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('P\00E1gina')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492135023564626998.4905)
,p_db_column_name=>'SECTION_NAME'
,p_display_order=>2
,p_column_identifier=>'C'
,p_column_label=>unistr('Se\00E7\00E3o')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492135204191626998.4905)
,p_db_column_name=>'SECTION_SEQ'
,p_display_order=>3
,p_column_identifier=>'E'
,p_column_label=>unistr('Sequ\00EAncia na P\00E1gina')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492135323582626998.4905)
,p_db_column_name=>'SECTION_TYPE'
,p_display_order=>4
,p_column_identifier=>'F'
,p_column_label=>unistr('Tipo de Se\00E7\00E3o')
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(492203630195322675)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492135114156626998.4905)
,p_db_column_name=>'SECTION_LINK'
,p_display_order=>5
,p_column_identifier=>'D'
,p_column_label=>'Link'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492134320826626994.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(492134510311626995.4905)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(492135623803626999.4905)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create section collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_section_collection (',
'    p_security_group_id => :flow_security_group_id,',
'    p_ws_app_id         => :ws_app_id',
'    );'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar a coleta.')
);
end;
/
prompt --application/pages/page_00029
begin
wwv_flow_api.create_page(
 p_id=>29.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Links da Grade de Dados'
,p_step_title=>'Links da Grade de Dados'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488528711832072509.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4905)
,p_plug_display_sequence=>300
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>Copie o link da grade de dados e cole-o no texto da se\00E7\00E3o para criar um link em uma p\00E1gina.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488529907857072513.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491316014516801049.4905)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>25
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491746024610087200.4905)
,p_plug_name=>'Links da Grade de Dados'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select w.name name, ',
'       ''[[ data grid: ''||lower(a.websheet_alias)||'' | ''|| w.name ||'' ]]'' data_grid_link',
'from wwv_flow_worksheets w, ',
'     wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id and',
'      w.security_group_id = :flow_security_group_id and                  ',
'      a.ws_app_id = :ws_app_id and',
'      nvl(a.websheet_type,''DATA'') = ''DATA'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(491746111378087200.4905)
,p_name=>'Data Grid Links'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491746317155087207.4905)
,p_db_column_name=>'NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Nome'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491746428175087207.4905)
,p_db_column_name=>'DATA_GRID_LINK'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Link da Grade de Dados'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(488529313077072512.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(491746024610087200.4905)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:RIR::'
);
end;
/
prompt --application/pages/page_00030
begin
wwv_flow_api.create_page(
 p_id=>30.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Links do Relat\00F3rio')
,p_step_title=>unistr('Links do Relat\00F3rio')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4905)
,p_required_role=>wwv_flow_api.id(492214905335570870)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488531706310080311.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4905)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>Copie o link do relat\00F3rio e cole-o no texto da se\00E7\00E3o para criar um link em uma p\00E1gina.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488532919512080318.4905)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491315807244799034.4905)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491748021852099994.4905)
,p_plug_name=>unistr('Links do Relat\00F3rio')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select w.name name, ',
'       ''[[ report: ''||lower(a.websheet_alias)||'' | ''|| w.name ||'' ]]'' report_link',
'from wwv_flow_worksheets w, ',
'     wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id and',
'      w.security_group_id = :flow_security_group_id and                  ',
'      a.ws_app_id = :ws_app_id and',
'      a.websheet_type = ''REPORT'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(491748229774099997.4905)
,p_name=>'Data Grid Links'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491748324162100000.4905)
,p_db_column_name=>'NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Nome'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491751223153119333.4905)
,p_db_column_name=>'REPORT_LINK'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Link do relat\00F3rio')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(491750704452113945.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(491748021852099994.4905)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:RIR::'
);
end;
/
prompt --application/pages/page_00031
begin
wwv_flow_api.create_page(
 p_id=>31.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Copiar P\00E1gina')
,p_step_title=>unistr('Copiar P\00E1gina')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(456220226828170850)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20320615327276649.4905)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,    ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',   ',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_COPY_PAGE''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(929190133057280555.4905)
,p_plug_name=>'Sucesso'
,p_region_template_options=>'#DEFAULT#:a-Alert--success:a-Alert--wizard'
,p_plug_template=>wwv_flow_api.id(931543191007401308.4905)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows=>15
,p_plug_header=>unistr('<p>A p\00E1gina foi copiada com sucesso.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(929190488644282428.4905)
,p_plug_name=>unistr('barra de bot\00F5es')
,p_region_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(929190621583287226.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(929190488644282428.4905)
,p_button_name=>'VIEW_CURRENT_PAGE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>unistr('Exibir P\00E1gina Atual')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:900:P900_ID:&P900_ID.'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(929190863882290386.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(929190488644282428.4905)
,p_button_name=>'VIEW_NEW_PAGE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>unistr('Exibir Nova P\00E1gina')
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:900:P900_ID:&P908_NEW_PAGE_ID.'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
end;
/
prompt --application/pages/page_00032
begin
wwv_flow_api.create_page(
 p_id=>32.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Criar Websheet'
,p_step_title=>'Criar Websheet'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(487678607690660963)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(322238423988579452.4905)
,p_plug_name=>'Create Application'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(929133081486158181.4905)
,p_plug_name=>'Sucesso'
,p_region_css_classes=>'wsFormRegion'
,p_region_template_options=>'#DEFAULT#:a-Alert--defaultIcons:a-Alert--success:a-Alert--wizard'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(931543191007401308.4905)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows=>15
,p_plug_header=>'<p>A Websheet foi criada com sucesso.</p>'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(929180946479219942.4905)
,p_plug_name=>'button bar'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(929100843522099793.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(929180946479219942.4905)
,p_button_name=>'EDIT_PROPERTY'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Editar Propriedades'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:1250:P1250_ID,WS_APP_ID:&P7_WS_APP_ID.,&P7_WS_APP_ID.'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(929133818885166572.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(929180946479219942.4905)
,p_button_name=>'RUN_WEBSHEET'
,p_button_action=>'REDIRECT_URL'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Executar Websheet'
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_redirect_url=>'ws?p=&P7_WS_APP_ID.:home:&SESSION.'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(322237424272579450.4905)
,p_name=>'P32_WS_APP_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(929133081486158181.4905)
,p_prompt=>'Websheet'
,p_source=>'P7_WS_APP_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Aplicativo criada recentemente.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(322237920970579451.4905)
,p_name=>'P32_WS_APP_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(929133081486158181.4905)
,p_prompt=>'Nome'
,p_source=>'P7_WEBSHEET_NAME'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Nome do aplicativo criado recentemente.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
end;
/
prompt --application/pages/page_00033
begin
wwv_flow_api.create_page(
 p_id=>33.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('M\00E1scara de Formato BLOB')
,p_step_title=>unistr('M\00E1scara de Formato BLOB')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
'  function apex_p33_download_format_set(){',
'    var l_Array = [$v(''P33_TYPE''),$v(''P33_BLOB_TABLE''),$v(''P33_BLOB_COLUMN''),$v(''P33_PK1''),$v(''P33_PK2''),$v(''P33_MIMETYPE''),$v(''P33_FILENAME''),$v(''P33_UPDATED''),$v(''P33_CHARSET''),$v(''P33_CONTENT_DISPOSITION''),$v(''P33_LINK_TEXT'')];',
'    var lItem = ''P3020_FORMAT_MASK'';',
'    var l_Value = $u_ArrayToString(l_Array,'':'');',
'    opener.$s(lItem,l_Value);',
'    window.close();',
'    opener.$x(lItem).focus();',
'  }',
'',
'//-->',
'</script>  '))
,p_step_template=>wwv_flow_api.id(134255203486851095.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(456220226828170850)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(382871122829192382.4905)
,p_plug_name=>unistr('M\00E1scara de Formato BLOB')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(82536903857665765.4905)
,p_plug_display_sequence=>20
,p_plug_new_grid=>true
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(383167816689247554.4905)
,p_plug_name=>'Top Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(25109627701530900.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(383212323961249647.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(383167816689247554.4905)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4905)
,p_button_image_alt=>'Aplicar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex_p33_download_format_set();'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(382974024476212019.4905)
,p_name=>'P33_TYPE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>unistr('M\00E1scara de Formato')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'BLOB_FORMAT_MASK'
,p_lov=>'.'||wwv_flow_api.id(382915819151201016.4905)||'.'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(383000402790215206.4905)
,p_name=>'P33_BLOB_TABLE'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>'Tabela BLOB'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(383045518374219662.4905)
,p_name=>'P33_BLOB_COLUMN'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>'Coluna BLOB'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(402663623371449753.4905)
,p_name=>'P33_PK1'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>unistr('Coluna 1 de Chave Prim\00E1ria')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(402992609350483622.4905)
,p_name=>'P33_PK2'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>unistr('Coluna 2 de Chave Prim\00E1ria')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403109000131490412.4905)
,p_name=>'P33_MIMETYPE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>'Tipo de Coluna MIME'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403280800609499987.4905)
,p_name=>'P33_FILENAME'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>'Coluna do Nome de Arquivo'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403382322426506264.4905)
,p_name=>'P33_UPDATED'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>unistr('Coluna da \00DAltima Atualiza\00E7\00E3o do BLOB')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403460500740509547.4905)
,p_name=>'P33_CHARSET'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>'Coluna do Conjunto de Caracteres'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403561421518515499.4905)
,p_name=>'P33_CONTENT_DISPOSITION'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>unistr('Disposi\00E7\00E3o de Conte\00FAdo')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'BLOB_CONTENT_DISPOSITION'
,p_lov=>'.'||wwv_flow_api.id(382939512009208407.4905)||'.'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403683725112525989.4905)
,p_name=>'P33_LINK_TEXT'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4905)
,p_prompt=>'Texto do Link de Download'
,p_source=>'wwv_flow_lang.system_message(''DOWNLOAD'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(992326827720799292.4905)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch blob format mask info'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.p33_fetch_blob_format (',
'    p_format_mask         => :P3020_FORMAT_MASK,    ',
'    --',
'    p_type                => :P33_TYPE,',
'    p_blob_table          => :P33_BLOB_TABLE,',
'    p_blob_column         => :P33_BLOB_COLUMN,',
'    p_pk1_column          => :P33_PK1,',
'    p_pk2_column          => :P33_PK2,',
'    p_mimetype_column     => :P33_MIMETYPE,',
'    p_filename_column     => :P33_FILENAME,',
'    p_last_upd_column     => :P33_UPDATED,',
'    p_charset_column      => :P33_CHARSET,',
'    p_content_disposition => :P33_CONTENT_DISPOSITION,',
'    p_download_text       => :P33_LINK_TEXT',
'    );'))
);
end;
/
prompt --application/pages/page_00037
begin
wwv_flow_api.create_page(
 p_id=>37.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Selecionar Idioma'
,p_step_title=>'Selecionar Idioma'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>'MUST_NOT_BE_PUBLIC_USER'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22687832673202415.4905)
,p_plug_name=>'Top Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>31
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(619996914922437329.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(633817727195790601.4905)
,p_plug_name=>unistr('Selecionar Idioma e Territ\00F3rio')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(620002529476508161.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(22687832673202415.4905)
,p_button_name=>'RETURN'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(633832411704842867.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(22687832673202415.4905)
,p_button_name=>'SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>'Definir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(636473024858464198.4905)
,p_branch_action=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(633832411704842867.4905)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(633818130920810528.4905)
,p_name=>'P37_LANGUAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(633817727195790601.4905)
,p_item_default=>'wwv_flow_lang.get_g_session_lang'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Idioma'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LANGUAGES_INSTALLED'
,p_lov=>'.'||wwv_flow_api.id(631691002719703351.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Selecione o idioma a ser usado ao executar este aplicativo. Se os cookies forem ativados no seu Web browser, esta prefer\00EAncia de idioma ser\00E1 gravada em um cookie e controlar\00E1 sua prefer\00EAncia de idioma para todos os aplicativos de Websheet nesta inst\00E2')
||unistr('ncia. Esta lista de idiomas \00E9 determinada pelas vers\00F5es traduzidas do &PRODUCT_NAME. instaladas.'),
'',
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(633818321354817301.4905)
,p_name=>'P37_TERRITORY'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(633817727195790601.4905)
,p_use_cache_before_default=>'NO'
,p_item_default=>'wwv_flow_lang.get_g_session_territory'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('Territ\00F3rio')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'I18N_TERRITORIES'
,p_lov=>'.'||wwv_flow_api.id(634728210841234369.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Selecione a prefer\00EAncia de territ\00F3rio a ser usada ao executar este aplicativo. Esta sele\00E7\00E3o controlar\00E1 o modo como datas, n\00FAmeros e calend\00E1rios ser\00E3o exibidos por padr\00E3o. Se os cookies forem ativados no seu browser, esta prefer\00EAncia de territ\00F3rio ser')
||unistr('\00E1 gravada em um cookie e controlar\00E1 sua prefer\00EAncia de territ\00F3rio para todos os aplicativos de Websheet nesta inst\00E2ncia.  '),
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(636322931994230689.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set language and territory'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_lang.set_session_lang( p_lang => :P37_LANGUAGE );',
'wwv_flow.g_browser_language := :P37_LANGUAGE;',
'wwv_flow_lang.set_session_territory( p_territory => :P37_TERRITORY );',
'',
'commit;'))
,p_process_error_message=>unistr('Erro ao processar atualiza\00E7\00E3o.')
,p_process_when_button_id=>wwv_flow_api.id(633832411704842867.4905)
,p_process_success_message=>unistr('A\00E7\00E3o processada.')
);
end;
/
prompt --application/pages/page_00042
begin
wwv_flow_api.create_page(
 p_id=>42.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Meus Relat\00F3rios Salvos')
,p_step_title=>unistr('Meus Relat\00F3rios Salvos')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(9297021464956579.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>'MUST_NOT_BE_PUBLIC_USER'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(496647113913986363.4905)
,p_plug_name=>unistr('Meus Relat\00F3rios Salvos')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4905)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'case when r.is_default!=''Y'' or r.application_user!=''APXWS_DEFAULT'' then',
'    wwv_flow_item.checkbox(',
'        1,',
'        r.id,null,null,'':'',',
'       ''f''||lpad(''''||1,2,''0'') || ''_'' || lpad(''''||rownum,4,''0'') ,',
'        wwv_flow_lang.system_message(''REPORT_LABEL'',',
'                            case',
'                              when r.is_default=''Y'' and r.application_user=''APXWS_DEFAULT'' then',
'                                wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'')',
'                              else',
'                                wwv_flow_escape.html(r.name)',
'                            end) )',
'end id,',
'a.id napp_id,',
'case when ws.websheet_type = ''DATA'' then',
'       ''<a href="f?p=''||:app_id||'':2:''||:app_session||''::::WS_APP_ID,P2_ID,P2_WEBSHEET_ID:''||:ws_app_id||'',''||i.id||'',''||ws.id||''">''||wwv_flow_escape.html(ws.websheet_name)||''</a>''',
'     when ws.websheet_type = ''REPORT'' then',
'       ''<a href="f?p=''||:app_id||'':3000:''||:app_session||''::::WS_APP_ID,IR_ID,WS_ID:''||:ws_app_id||'',''||i.id||'',''||ws.id||''">''||wwv_flow_escape.html(ws.websheet_name)||''</a>''',
'end websheet_name,',
'case when ws.websheet_type = ''DATA'' then',
'       sm.data_grid',
'     when ws.websheet_type = ''REPORT'' then',
'       sm.report',
'end websheet_type,',
'case when r.is_default = ''Y''then ',
'     decode(r.application_user,',
'            ''APXWS_DEFAULT'',sm.primary_def, ',
'            ''APXWS_ALTERNATIVE'',sm.alt_def)',
'     when r.is_default = ''N'' and r.status = ''PUBLIC'' then',
'         sm.spublic',
'     when r.is_default = ''N'' and r.status = ''PRIVATE'' then',
'         sm.private',
'end report_type, ',
'case when r.is_default=''Y'' and r.application_user=''APXWS_DEFAULT'' then',
'    wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'')',
'else',
'    r.name',
'end name,',
'decode(r.application_user,',
'       ''APXWS_DEFAULT'',null,',
'       ''APXWS_ALTERNATIVE'',null,',
'       lower(r.application_user)) owner,',
'substr(r.description,1,50) description,        ',
'r.report_alias report_alias,',
'r.created_on',
'from wwv_flow_worksheets i,',
'wwv_flow_worksheet_rpts r,',
'wwv_flow_ws_applications a,',
'wwv_flow_ws_websheet_attr ws,',
'(select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary_def,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alt_def,               ',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIVATE'') private,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') spublic,',
'      wwv_flow_lang.system_message(''DATA_GRID'') data_grid,',
'      wwv_flow_lang.system_message(''REPORT'') report',
' from dual) sm',
'where a.id = ws.ws_app_id',
'and ws.worksheet_id = i.id',
'and r.worksheet_id = i.id',
'and r.websheet_id is not null',
'and r.security_group_id = :flow_security_group_id',
'and a.id = :ws_app_id',
'and r.application_user = :app_user',
'and r.session_id is null'))
,p_plug_source_type=>'NATIVE_IR'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(496647211081986363.4905)
,p_name=>'Saved Reports'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'CBCHO'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647413912986368.4905)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'#CHECK_ALL_CHECKBOX#'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647505239986368.4905)
,p_db_column_name=>'NAPP_ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Aplicativo'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647610315986368.4905)
,p_db_column_name=>'WEBSHEET_NAME'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Dados'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(497241820310060978)
,p_rpt_show_filter_lov=>'2'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647729642986369.4905)
,p_db_column_name=>'WEBSHEET_TYPE'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Tipo'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647830164986369.4905)
,p_db_column_name=>'REPORT_TYPE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('Tipo de Relat\00F3rio')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647931210986369.4905)
,p_db_column_name=>'NAME'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Nome'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496648005718986369.4905)
,p_db_column_name=>'OWNER'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('Propriet\00E1rio')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496648117100986369.4905)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('Descri\00E7\00E3o')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496648221465986369.4905)
,p_db_column_name=>'REPORT_ALIAS'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('Alias do Relat\00F3rio')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(737065808338186629.4905)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Criado'
,p_column_type=>'DATE'
,p_heading_alignment=>'LEFT'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(497240631383988555.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(497261218307315877.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Use esta p\00E1gina para gerenciar seus relat\00F3rios salvos. Voc\00EA pode criar relat\00F3rios salvos usando o menu A\00E7\00F5es ao exibir Relat\00F3rios e Grades de Dados. As defini\00E7\00F5es de um relat\00F3rio salvo s\00E3o referenciadas ao criar uma se\00E7\00E3o baseada em um Relat\00F3rio o')
||unistr('u Grade de Dados. Elas s\00E3o usadas para personalizar os dados apresentados nessa se\00E7\00E3o.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(497767325222992406.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(496647113913986363.4905)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.:42,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(497233530597931570.4905)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(496647113913986363.4905)
,p_button_name=>'DELETE_CHECKED'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4905)
,p_button_image_alt=>'Excluir Marcado(s)'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(497233703023933067.4905)
,p_branch_action=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(497241020778994879.4905)
,p_validation_name=>'must select report to delete'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow.g_f01.count = 0 then',
'  return false;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('O relat\00F3rio deve ser selecionado para exclus\00E3o.')
,p_when_button_pressed=>wwv_flow_api.id(497233530597931570.4905)
,p_associated_item=>wwv_flow_api.id(.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2045581531252367912.4905)
,p_name=>'ADD CHECK ALL CHECKBOX'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(496647113913986363.4905)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2045581649091367913.4905)
,p_event_id=>wwv_flow_api.id(2045581531252367912.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'PLUGIN_COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(497237425533939526.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete checked'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for i in 1..wwv_flow.g_f01.count',
'loop',
'    for c1 in (select id report_id, worksheet_id, application_user, is_default, report_type',
'               from wwv_flow_worksheet_rpts',
'               where id = wwv_flow.g_f01(i)',
'               and security_group_id=:flow_security_group_id',
'               and application_user = :app_user)',
'    loop                ',
'        wwv_flow_worksheet_api.delete_saved_report (            ',
'            p_worksheet_id      => c1.worksheet_id,               ',
'            p_report_id         => c1.report_id,',
'            p_is_default        => c1.is_default);        ',
'    end loop;',
'end loop;'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel remover o relat\00F3rio.')
,p_process_when_button_id=>wwv_flow_api.id(497233530597931570.4905)
,p_process_success_message=>unistr('O(s) relat\00F3rio(s) foi(ram) removido(s).')
);
end;
/
prompt --application/pages/page_00050
begin
wwv_flow_api.create_page(
 p_id=>50.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Adicionar Anexo'
,p_step_title=>'Adicionar Anexo'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(3152608674388513.4905)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_page_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'This page needed for Ajax in Data Grid Single Row View (page 20).',
'onload="window.parent.closeupload();"'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3144901000282263.4905)
,p_plug_name=>'Upload'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_error_msg varchar2(4000);',
'begin',
'    wwv_flow_ws_attachment.add_doc (',
'        p_ws_app_id       => :WS_APP_ID,',
'        p_websheet_id     => :P2_WEBSHEET_ID,',
'        p_row_id          => :CURRENT_WORKSHEET_ROW,',
'        p_component_level => ''ROW'',',
'        p_file_name       => :P20_X,',
'        p_desc            => :P20_DESC',
'    );',
'    sys.htp.p(''<script type="text/javascript" charset="utf-8">'');',
'    sys.htp.p(''  window.parent.apex.websheet.closeUpload();'');',
'    sys.htp.p(''</script>'');',
'exception when others then',
'    if sqlcode = -1691 then',
'        l_error_msg := wwv_flow_lang.system_message(''WS_ADD_FILE_NOT_ENOUGH_SPACE_ERROR'');',
'    else',
'        l_error_msg := sqlerrm;',
'    end if;',
'    sys.htp.p(''<script type="text/javascript" charset="utf-8">'');',
'    sys.htp.p(''  window.parent.apex.websheet.spinner$.remove();'');',
'    sys.htp.p(''  $("#apexir_DIALOG_MESSAGE", window.parent.document).html("''||wwv_flow_escape.html(l_error_msg)||''");'');',
'    sys.htp.p(''</script>'');',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(177392830105668569.4905)
,p_branch_name=>'Go To Page 20'
,p_branch_action=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
end;
/
prompt --application/pages/page_00051
begin
wwv_flow_api.create_page(
 p_id=>51.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Gerenciar Esquemas de Autentica\00E7\00E3o')
,p_step_title=>unistr('Gerenciar Esquemas de Autentica\00E7\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(177132113855562337.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
end;
/
prompt --application/pages/page_00053
begin
wwv_flow_api.create_page(
 p_id=>53.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Editar P\00E1gina')
,p_step_title=>unistr('Editar P\00E1gina')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'//-->',
'</script>',
'<style>',
'/* There is no collapse left col functionality on this page, so adding additional padding to Left Col heading */',
'div.ebaTwoColPane > div h2.leftButtons {padding-left: 10px !important;}',
'</style>'))
,p_step_template=>wwv_flow_api.id(15627530893704526.4905)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18534419096630219.4905)
,p_plug_name=>'List of Pages'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(18529824151546479.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(158861503239501998.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18534800527634294.4905)
,p_plug_name=>'Detalhes do &P53_NAME.'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(15634208564734334.4905)
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18557529579690008.4905)
,p_plug_name=>unistr('P\00E1ginas')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(17121518626936007.4905)
,p_plug_display_sequence=>120
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18585811889807838.4905)
,p_plug_name=>'Page Settings List'
,p_region_name=>'page_control'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>130
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(18583325957802446.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(936708315591140469.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(162991400186731236.4905)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>140
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(177409809869723629.4905)
,p_plug_name=>unistr('P\00E1gina')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(177422928892872875.4905)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2061383146528710242.4905)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(18557529579690008.4905)
,p_button_name=>'CREATE_PAGE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(936712837989177653.4905)
,p_button_image_alt=>unistr('Criar P\00E1gina')
,p_button_position=>'REGION_TEMPLATE_CHANGE'
,p_icon_css_classes=>'icon-plus'
,p_button_cattributes=>'data-menu="page_control_menu"'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(177410225400723635.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(177422928892872875.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(18562324993707537.4905)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(18557529579690008.4905)
,p_button_name=>'Hide/Show'
,p_button_static_id=>'sideColControl'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(16714408571357214.4905)
,p_button_image_alt=>'Ocultar/Mostrar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'javascript:void(0)'
,p_button_condition_type=>'NEVER'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(177410026421723634.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(177422928892872875.4905)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P53_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(177410112058723634.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(177422928892872875.4905)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15160928947568323.4905)
,p_button_image_alt=>'Excluir'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_condition=>'(:P53_ID is not null) and (not wwv_flow_ws_api.is_app_home_page(p_ws_app_id => :ws_app_id, p_webpage_id => :p53_id))'
,p_button_condition_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(163262329454777553.4905)
,p_branch_action=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.:53:P53_ID:&P53_NEXT_PAGE_ID.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'GET_NEXT_PAGE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(177410910657723644.4905)
,p_branch_action=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(467021002093988715.4905)
,p_branch_action=>'f?p=&APP_ID.:960:&SESSION.::&DEBUG.:::'
,p_branch_point=>'BEFORE_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(177410112058723634.4905)
,p_branch_sequence=>20
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(163040114731735379.4905)
,p_name=>'P53_NEXT_PAGE_ID'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(162991400186731236.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177411102679723645.4905)
,p_name=>'P53_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(162991400186731236.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Id'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>255
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177411303356723657.4905)
,p_name=>'P53_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nome'
,p_source=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica o nome da p\00E1gina, que ser\00E1 exibido no t\00EDtulo da janela e tamb\00E9m no breadcrumb.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177411518259723658.4905)
,p_name=>'P53_OWNER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Propriet\00E1rio')
,p_source=>'OWNER'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica o propriet\00E1rio da p\00E1gina.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177411701386723658.4905)
,p_name=>'P53_STATUS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Status'
,p_source=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>30
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica o status da p\00E1gina.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177411912672723659.4905)
,p_name=>'P53_DESCRIPTION'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Descri\00E7\00E3o da P\00E1gina')
,p_source=>'DESCRIPTION'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Texto que descreve a p\00E1gina.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177412115882723659.4905)
,p_name=>'P53_PARENT_PAGE_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('P\00E1gina M\00E3e')
,p_source=>'PARENT_PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PICK PARENT PAGE (FOR PAGE 53)'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'  from wwv_flow_ws_webpages',
' where security_group_id = :flow_security_group_id',
'   and ws_app_id = :WS_APP_ID',
'minus',
'select name d, id r',
'  from wwv_flow_ws_webpages',
' where security_group_id = :flow_security_group_id ',
'   and ws_app_id = :WS_APP_ID ',
'connect by prior id = parent_page_id',
'start with id = :P53_ID',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Nenhum Pai -'
,p_lov_null_value=>'%null%'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Identifica a p\00E1gina m\00E3e. A p\00E1gina m\00E3e definida \00E9 usada para construir breadcrumbs e a navega\00E7\00E3o entre as p\00E1ginas.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(457384308073732200.4905)
,p_name=>'P53_PAGE_ALIAS'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Alias'
,p_source=>'PAGE_ALIAS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>255
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Informe um alias alfanum\00E9rico para esta p\00E1gina. Um alias de p\00E1gina permite criar links nas se\00E7\00F5es da p\00E1gina para outras p\00E1ginas. Um alias de p\00E1gina deve ser exclusivo dentro de um aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(457472018265246008.4905)
,p_validation_name=>'P53_PAGE_ALIAS must be unique'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P53_PAGE_ALIAS is not null then',
'  if wwv_flow_ws_api.alias_exists(',
'     p_ws_app_id=>:WS_APP_ID,',
'     p_alias=>:P53_PAGE_ALIAS,',
'     p_alias_type=>''PAGE'',',
'     p_page_id=>:P53_ID) then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('O alias da p\00E1gina j\00E1 existe. Informe outro alias.')
,p_validation_condition=>'SAVE,GET_NEXT_PAGE'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(457384308073732200.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(467021405256017928.4905)
,p_validation_name=>'cannot delete home page'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_home_page_id  number;',
'begin',
'   for c1 in (',
'      select home_page_id',
'        from wwv_flow_ws_applications',
'       where id = :WS_APP_ID',
'         and security_group_id = :flow_security_group_id )',
'   loop',
'      l_home_page_id := c1.home_page_id;',
'   end loop;',
'',
'   if :P53_ID = l_home_page_id then',
'      return false;',
'   else',
'      return true;',
'   end if;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('N\00E3o \00E9 poss\00EDvel excluir a home page. Edite as propriedades do aplicativo e selecione uma nova home page.')
,p_when_button_pressed=>wwv_flow_api.id(177410112058723634.4905)
,p_associated_item=>wwv_flow_api.id(177411303356723657.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(467022317985040552.4905)
,p_validation_name=>'cannot delete only page'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_page_count  number;',
'begin',
'   for c1 in (',
'      select count(*) cnt',
'        from wwv_flow_ws_webpages',
'       where ws_app_id = :WS_APP_ID',
'         and security_group_id = :flow_security_group_id )',
'   loop',
'      l_page_count := c1.cnt;',
'   end loop;',
'',
'   if l_page_count = 1 then',
'      return false;',
'   else',
'      return true;',
'   end if;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Cada aplicativo deve ter pelo menos uma p\00E1gina. Voc\00EA n\00E3o pode excluir a \00FAnica p\00E1gina.')
,p_when_button_pressed=>wwv_flow_api.id(177410112058723634.4905)
,p_associated_item=>wwv_flow_api.id(177411303356723657.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(6140313816861525.4905)
,p_validation_name=>'P53_PAGE_ALIAS is valid'
,p_validation_sequence=>40
,p_validation=>'P53_PAGE_ALIAS'
,p_validation_type=>'ITEM_IS_ALPHANUMERIC'
,p_error_message=>unistr('O alias deve ser alfanum\00E9rico.')
,p_validation_condition=>':P53_PAGE_ALIAS is not null and :REQUEST in (''SAVE'',''GET_NEXT_PAGE'')'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(457384308073732200.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(177412315870723660.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_WS_WEBPAGES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_WS_WEBPAGES'
,p_attribute_03=>'P53_ID'
,p_attribute_04=>'ID'
,p_attribute_08=>wwv_flow_string.join(wwv_flow_t_varchar2(
'security_group_id = :WORKSPACE_ID',
'and ws_app_id = :WS_APP_ID'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel extrair a linha.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(177412503075723662.4905)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_WS_WEBPAGES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_WS_WEBPAGES'
,p_attribute_03=>'P53_ID'
,p_attribute_04=>'ID'
,p_attribute_08=>wwv_flow_string.join(wwv_flow_t_varchar2(
'security_group_id = :WORKSPACE_ID',
'and ws_app_id = :WS_APP_ID'))
,p_attribute_11=>'U'
,p_attribute_12=>'Y'
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel processar linha da tabela WWV_FLOW_WS_WEBPAGES.')
,p_process_when=>'SAVE,GET_NEXT_PAGE'
,p_process_when_type=>'REQUEST_IN_CONDITION'
,p_process_success_message=>unistr('A\00E7\00E3o Processada.')
);
end;
/
prompt --application/pages/page_00079
begin
wwv_flow_api.create_page(
 p_id=>79.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Administra\00E7\00E3o')
,p_step_title=>unistr('Administra\00E7\00E3o')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(4881207741750467)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4098511924636618.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(198343320048239476.4905)
,p_plug_name=>'perform logout'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_ws_app_id number := v(''WS_APP_ID'');',
'begin',
'    for c1 in (select auth_id authentication ',
'              from wwv_flow_ws_applications',
'              where id = l_ws_app_id',
'              and security_group_id = :flow_security_group_id)',
'    loop',
'        if c1.authentication is null then',
'            null;',
'        else',
'            for c2 in (select page_sentry_function,logout_url from wwv_flow_ws_custom_auth_setups where id = c1.authentication) loop',
'                if c2.page_sentry_function = ''-DATABASE-'' then',
'                    null;',
'                else',
'                    sys.htp.init;',
'                    sys.owa_util.redirect_url(replace(replace(replace(c2.logout_url,''&''||''WS_APP_ID.'',l_ws_app_id),''&''||''APP_SESSION.'',''&''||''SESSION.''),''&''||''SESSION.'',v(''APP_SESSION'')));',
'                    wwv_flow.stop_apex_engine;',
'                end if;',
'            end loop;                    ',
'        end if;',
'    end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(811176724741077278.4905)
,p_process_sequence=>50
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'redirect if login'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_found boolean := false;',
'  l_territory      varchar2(255);',
'begin',
'for c1 in (select auth_id, language, territory, home_page_id',
'             from wwv_flow_ws_applications',
'            where id = :WS_APP_ID) loop',
'  for c2 in (select auth_function, invalid_session_url',
'               from wwv_flow_ws_custom_auth_setups',
'              where id = c1.auth_id ) loop',
'               if c1.territory is null then',
'                   for c3 in (select nls_territory from wwv_flow_languages where lang_id = c1.language) loop',
'                       l_territory := c3.nls_territory;',
'                       exit;',
'                   end loop;',
'               else',
'                   l_territory := c1.territory;',
'               end if;',
'    if c2.invalid_session_url = ''-PORTAL_SSO-'' then',
'            wwv_flow.g_user := ''nobody'';',
'            wwv_flow_security.g_user := wwv_flow.g_user;',
'            wwv_flow_custom_auth.remember_deep_link(',
'                p_url=>''f?p=''||:app_id||'':900:::::WS_APP_ID,P900_ID:''||:WS_APP_ID||'',''||c1.home_page_id);',
'            begin',
'            wwv_flow_security.g_context := ''WWV_FLOW_CUSTOM_AUTH_SSO'';',
'            wwv_flow_dynamic_exec.run_block (',
'                p_sql=>''begin wwv_flow_custom_auth_sso.portal_sso_redirect; end;'',',
'                p_user=>wwv_flow.g_flow_schema_owner);',
'            wwv_flow_security.g_context := ''NULL'';',
'            exception when others then',
'               wwv_flow_security.g_context := ''NULL'';',
'               l_found := false;',
'               for c1 in (select /* APEXad5ea5 */  1 from sys.dba_objects',
'                   where object_name=''WWSEC_SSO_ENABLER_PRIVATE'' and',
'                   object_type = ''PACKAGE''',
'                   and status = ''VALID'') loop',
'                   l_found := true;',
'               end loop;',
'               if not l_found then',
'                    wwv_flow_error.raise_internal_error (',
'                        p_error_message =>',
'                            wwv_flow_lang.system_message(',
'                                p_name=>''WWV_FLOW_SECURITY.SSO_PKG_MISSING1'')||',
'                                ''<br>&nbsp;''||',
'                            wwv_flow_lang.system_message(',
'                                p_name=>''WWV_FLOW_SECURITY.SSO_PKG_MISSING2'',',
'                                p0=>''&PRODUCT_NAME.'') );',
'               else',
'                   wwv_flow_error.raise_internal_error (',
'                       p_error_code => ''WWV_FLOW_SECURITY.SSO_PKG_ERR'' );',
'               end if;',
'               return;',
'            end;',
'    else',
'      sys.htp.init;',
'      sys.owa_util.redirect_url(wwv_flow_ws_webpage.get_login_url(:WS_APP_ID));',
'      wwv_flow.stop_apex_engine;',
'    end if;',
'  end loop;',
'end loop;',
'end;'))
,p_process_when=>'LOGIN'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00089
begin
wwv_flow_api.create_page(
 p_id=>89.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Alterar Tipo de Coluna'
,p_step_title=>'Alterar Tipo de Coluna'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4230411616343203.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4231008955350266.4905)
,p_plug_name=>unistr('Confirmar Altera\00E7\00E3o do Tipo de Coluna')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_header=>unistr('Voc\00EA solicitou a altera\00E7\00E3o do tipo de coluna da Grade de Dados. A altera\00E7\00E3o do tipo de coluna desativar\00E1 os filtros existentes, destacar\00E1 as regras e outras defini\00E7\00F5es de relat\00F3rio que fazem refer\00EAncia a essas colunas. Confirme sua solicita\00E7\00E3o.<p />')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(128720011527408660.4905)
,p_plug_name=>unistr('Bot\00F5es Direitos da Barra de Ferramentas')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(4231507009359228.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(128720011527408660.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(4231818090362334.4905)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(128720011527408660.4905)
,p_button_name=>'CONFIRM'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>'Confirmar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(4236313729446260.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(128720011527408660.4905)
,p_button_name=>'PREVIOUS'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4905)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(4232110828362335.4905)
,p_branch_action=>'f?p=&FLOW_ID.:2:&SESSION.::&DEBUG.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(4231818090362334.4905)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(4236626497446261.4905)
,p_branch_action=>'f?p=&APP_ID.:91:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(4236313729446260.4905)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4239107514595863.4905)
,p_name=>'P89_COLUMN_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(4231008955350266.4905)
,p_prompt=>'Nome da Coluna'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_label',
'from wwv_flow_worksheet_columns',
'where db_column_name = :p91_db_column_name',
'and worksheet_id = :p2_id',
'and security_group_id = :WORKSPACE_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_lov_display_extra=>'NO'
,p_help_text=>'O nome da coluna selecionada para alterar o tipo de coluna.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4239902235613223.4905)
,p_name=>'P89_OLD_COLUMN_TYPE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(4231008955350266.4905)
,p_prompt=>'Tipo de Coluna Antigo'
,p_source=>'wwv_flow_item.text_from_lov (:p91_column_type,''WORKSHEET_COLUMN_TYPES2'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'O tipo de coluna antigo.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4240110892615736.4905)
,p_name=>'P89_NEW_COLUMN_TYPE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(4231008955350266.4905)
,p_prompt=>'Novo Tipo de Coluna'
,p_source=>'wwv_flow_item.text_from_lov (:p91_new_column_type,''WORKSHEET_COLUMN_TYPES2'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'O novo tipo de coluna.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4242814626061519.4905)
,p_name=>'P89_FORMAT_MASK'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(4231008955350266.4905)
,p_prompt=>unistr('M\00E1scara de Formato para Usar Durante Altera\00E7\00E3o do Tipo de Coluna')
,p_source=>'P91_FORMAT_MASK'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('A m\00E1scara de formato para usar durante altera\00E7\00E3o do tipo de coluna.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(4243626448093240.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'change column type'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.change_column_type (',
'    p_worksheet_id         => :p2_id,',
'    p_websheet_id          => :p2_websheet_id,',
'    p_old_db_column_name   => :p91_db_column_name,    ',
'    p_new_column_type      => :P91_NEW_COLUMN_TYPE,',
'    p_format_mask_to_use   => :P91_FORMAT_MASK);'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel alterar o tipo de coluna.')
,p_process_when_button_id=>wwv_flow_api.id(4231818090362334.4905)
,p_process_success_message=>'Tipo de coluna alterado.'
);
end;
/
prompt --application/pages/page_00090
begin
wwv_flow_api.create_page(
 p_id=>90.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Objetos Dispon\00EDveis')
,p_step_title=>unistr('Objetos Dispon\00EDveis')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript">',
'   function passBack(passVal1)',
'   {',
'   opener.document.getElementById("P1310_TABLE_NAME").value = passVal1;',
'   opener.document.getElementById("P1310_TABLE_NAME").focus();',
'   close();',
'   }',
'</script>',
''))
,p_step_template=>wwv_flow_api.id(134255203486851095.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(134428823965885392.4905)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492080122343937551.4905)
,p_plug_name=>'Objects'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, ',
'       null t,',
'       object_name v,',
'       object_comment c',
'  from wwv_flow_ws_app_sug_objects',
' where ws_app_id = :WS_APP_ID',
'   and security_group_id = :workspace_id',
'   and nvl(:P90_TABLE_TYPE,''S'') = ''S''',
'union all',
'select table_name d,',
'       wwv_flow_lang.system_message(''TABLE'') t, ',
'       table_name v,',
'       null c',
'  from sys.dba_tables',
' where owner = :P90_SCHEMA',
'   and table_name not like ''BIN$%''',
'   and table_name not like ''APEX$_%''',
'   and :P90_TABLE_TYPE = ''A''',
'union all',
'select view_name d,',
'       wwv_flow_lang.system_message(''VIEW'') t, ',
'       view_name v,',
'       null c',
'  from sys.dba_views',
' where owner = :P90_SCHEMA',
'   and :P90_TABLE_TYPE = ''A''',
'union all',
'select synonym_name d,',
'       wwv_flow_lang.system_message(''SYNONYM'') t, ',
'       synonym_name v,',
'       null c',
'  from sys.dba_synonyms',
' where owner = :P90_SCHEMA',
'   and :P90_TABLE_TYPE = ''A''',
' order by 1'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(492080213042937551.4905)
,p_name=>'Objects'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492080416858937588.4905)
,p_db_column_name=>'D'
,p_display_order=>2
,p_column_identifier=>'A'
,p_column_label=>'Nome do Objeto'
,p_column_link=>'javascript:passBack(''#V#'');'
,p_column_linktext=>'#D#'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492103930374310439.4905)
,p_db_column_name=>'T'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Tipo de Objeto'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_condition=>'P90_TABLE_TYPE'
,p_display_condition2=>'A'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492623505769353937.4905)
,p_db_column_name=>'C'
,p_display_order=>4
,p_column_identifier=>'E'
,p_column_label=>unistr('Coment\00E1rio')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_condition=>'P90_TABLE_TYPE'
,p_display_condition2=>'S'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492080514008937588.4905)
,p_db_column_name=>'V'
,p_display_order=>5
,p_column_identifier=>'B'
,p_column_label=>'V'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492053301677732661.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(134428823965885392.4905)
,p_button_name=>'CLOSE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4905)
,p_button_image_alt=>'Fechar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:window.close();'
,p_button_execute_validations=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492102203653198613.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(492080122343937551.4905)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:90:&SESSION.::&DEBUG.:90,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492067824637769509.4905)
,p_name=>'P90_TABLE_TYPE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(134428823965885392.4905)
,p_prompt=>'Visualizar'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'SUGGESTED SQL TABLE TYPE (P90)'
,p_lov=>'.'||wwv_flow_api.id(17231024016826986.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'2'
,p_attribute_02=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492697000185414926.4905)
,p_name=>'P90_SCHEMA'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(492080122343937551.4905)
,p_use_cache_before_default=>'NO'
,p_source=>'wwv_flow_ws_setup.get_apex$_schema (p_workspace_id=>:flow_security_group_id)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(495865912227957737.4905)
,p_computation_sequence=>10
,p_computation_item=>'P90_TABLE_TYPE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'select count(*) cnt ',
'  from wwv_flow_ws_app_sug_objects',
' where security_group_id = :flow_security_group_id',
'   and ws_app_id = :WS_APP_ID )',
'loop',
'   if c1.cnt = 0 then',
'      return ''A'';',
'   else',
'      return ''S'';',
'   end if;',
'end loop;'))
,p_compute_when=>'P90_TABLE_TYPE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(495717104974056773.4905)
,p_name=>'when no sug obj'
,p_event_sequence=>10
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
,p_display_when_type=>'NOT_EXISTS'
,p_display_when_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'  from wwv_flow_ws_app_sug_objects',
' where security_group_id = :flow_security_group_id',
'   and ws_app_id = :WS_APP_ID'))
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(495717422657056775.4905)
,p_event_id=>wwv_flow_api.id(495717104974056773.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P90_TABLE_TYPE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(432751509152951102.4905)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'check priv'
,p_process_sql_clob=>'wwv_flow_sw_api.check_priv(p_schema => :P90_SCHEMA);'
,p_process_when=>'P90_SCHEMA'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00091
begin
wwv_flow_api.create_page(
 p_id=>91.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Alterar Tipo de Coluna'
,p_step_title=>'Alterar Tipo de Coluna'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4233421912405794.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4233920131410265.4905)
,p_plug_name=>'Alterar Tipo de Coluna'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(127798813633286291.4905)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(128015931556310368.4905)
,p_plug_name=>unistr('Bot\00F5es Direitos da Barra de Ferramentas')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>31
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(4234716106418588.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(128015931556310368.4905)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>unistr('Aplicar Altera\00E7\00F5es')
,p_button_position=>'REGION_TEMPLATE_CHANGE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(4234126710412218.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(128015931556310368.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(4235020699418588.4905)
,p_branch_action=>'f?p=&APP_ID.:89:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(4234716106418588.4905)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4235200653423582.4905)
,p_name=>'P91_COLUMN_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(4233920131410265.4905)
,p_prompt=>'Nome da Coluna'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_label',
'from wwv_flow_worksheet_columns',
'where db_column_name = :P91_DB_COLUMN_NAME',
'and worksheet_id = :p2_id',
'and security_group_id = :WORKSPACE_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_lov_display_extra=>'NO'
,p_help_text=>'O nome da coluna selecionada para alterar o tipo de coluna.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4235408965425946.4905)
,p_name=>'P91_COLUMN_TYPE_DISPLAY'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(4233920131410265.4905)
,p_prompt=>'Tipo de Coluna'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_item.text_from_lov (column_type,''WORKSHEET_COLUMN_TYPES2'')',
'from wwv_flow_worksheet_columns',
'where db_column_name = :P91_DB_COLUMN_NAME',
'and worksheet_id = :p2_id',
'and security_group_id = :WORKSPACE_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_lov_display_extra=>'NO'
,p_help_text=>'O tipo de coluna atual.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4235631474432520.4905)
,p_name=>'P91_NEW_COLUMN_TYPE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(4233920131410265.4905)
,p_prompt=>'Novo Tipo de Coluna'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'WORKSHEET_COLUMN_TYPES2'
,p_lov=>'.'||wwv_flow_api.id(38353412581019585.4905)||'.'
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Selecionar Tipo de Coluna -'
,p_lov_null_value=>'%null%'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Selecione o novo tipo de coluna.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4235917061437778.4905)
,p_name=>'P91_DB_COLUMN_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(127798813633286291.4905)
,p_prompt=>'Db Column Name'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4238507121567312.4905)
,p_name=>'P91_COLUMN_TYPE'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(127798813633286291.4905)
,p_prompt=>'Column Type'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_type',
'from wwv_flow_worksheet_columns',
'where db_column_name = :P91_DB_COLUMN_NAME',
'and worksheet_id = :p2_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4241105389916880.4905)
,p_name=>'P91_FORMAT_MASK'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(4233920131410265.4905)
,p_prompt=>unistr('M\00E1scara de Formato para Usar Durante Altera\00E7\00E3o do Tipo de Coluna')
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'FORMAT MASK DYNAMIC'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'from wwv_flow_format_masks'))
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Informe uma m\00E1scara de formato para ser usada durante a altera\00E7\00E3o do tipo de coluna. Quando voc\00EA altera o tipo de coluna para data ou n\00FAmero, \00E9 importante informar a m\00E1scara de formato. Caso contr\00E1rio, a altera\00E7\00E3o do tipo de coluna poder\00E1 falhar.')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(4237821488533664.4905)
,p_validation_name=>'P91_NEW_COLUMN_TYPE not null'
,p_validation_sequence=>10
,p_validation=>'P91_NEW_COLUMN_TYPE'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'O novo tipo de coluna deve ser especificado.'
,p_when_button_pressed=>wwv_flow_api.id(4234716106418588.4905)
,p_associated_item=>wwv_flow_api.id(4235631474432520.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(4238113438550220.4905)
,p_validation_name=>'old type not equal new type'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P91_COLUMN_TYPE = :P91_NEW_COLUMN_TYPE then',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'O tipo de coluna Novo deve ser diferente do tipo de coluna antigo.'
,p_validation_condition=>'P91_NEW_COLUMN_TYPE'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(4234716106418588.4905)
,p_associated_item=>wwv_flow_api.id(4235631474432520.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(186914619522722819.4905)
,p_validation_name=>'P91_NEW_COLUMN_TYPE max reached'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_api.max_col_limit_reached (',
'    p_worksheet_id   => :p2_id,',
'    p_column_type    => :P91_NEW_COLUMN_TYPE) then',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('O n\00FAmero m\00E1ximo de colunas dispon\00EDveis para o tipo de coluna atingido. Escolha um tipo de coluna diferente.')
,p_validation_condition=>'replace(:P91_NEW_COLUMN_TYPE,''%''||''null%'') is not null and :P91_COLUMN_TYPE != :P91_NEW_COLUMN_TYPE'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(4234716106418588.4905)
,p_associated_item=>wwv_flow_api.id(4235631474432520.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00092
begin
wwv_flow_api.create_page(
 p_id=>92.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Redefinir Senha'
,p_step_title=>'Redefinir Senha'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-AppCards--slim .a-AppCards-icon {',
'    margin: 16px auto;',
'}',
'',
'h1.a-Login-title {',
'    font-size: 20px;',
'    margin: 24px 0;',
'}'))
,p_step_template=>wwv_flow_api.id(1418140425267007336.4905)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(506060600392166972)
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(8557512241276654.4905)
,p_plug_name=>'Reset password Container'
,p_region_css_classes=>'a-Login-region a-Form--stretchInputs a-Form--labelsAbove'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3700433754276.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_ws_applications ',
'where id = :WS_APP_ID'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1284871394951082007.4905)
,p_plug_name=>'Reset assword Header'
,p_parent_plug_id=>wwv_flow_api.id(8557512241276654.4905)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (with pkg_app_image as (',
'               select m.installed_ws_id,',
'                      p.image_identifier image_class',
'               from wwv_flow_pkg_applications p, wwv_flow_pkg_app_map m',
'               where p.app_id = m.app_id',
'               and p.app_type = ''WS''',
'               and m.security_group_id = :flow_security_group_id',
'               )',
'           select ',
'               p.image_class,',
'               case when p.image_class is null then ',
'                   wwv_flow_4000_ui.get_app_initials( name, id )',
'               else',
'                   '' ''',
'               end as app_initials,',
'               case when p.image_class is null then ',
'                   ''u-ColorBG--'' || to_char( ora_hash( name, 29 ) + 1 )',
'               else',
'                   '' ''',
'               end as app_color,',
'               name ws_name',
'           from  wwv_flow_ws_applications a,',
'                 pkg_app_image p',
'           where a.security_group_id = :flow_security_group_id',
'           and a.id = p.installed_ws_id (+)',
'           and a.id = :ws_app_id)',
'loop',
'    sys.htp.p(''<div class="a-Login-header a-AppCards--slim">'');',
'    sys.htp.p(''  <span class="a-AppCards-icon a-AppCards-icon--initials ''||',
'              wwv_flow_escape.html(c1.image_class)||'' ''||',
'              wwv_flow_escape.html(c1.app_color)||',
'              ''" role="presentation" aria-hidden="true">''||',
'              wwv_flow_escape.html(c1.app_initials)||',
'              ''</span>'');',
'    sys.htp.p(''  <h1 class="a-Login-title">''||wwv_flow_escape.html(c1.ws_name)||''</h1>'');',
'    sys.htp.p(''</div>'');',
'end loop;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1418413115140401416.4905)
,p_plug_name=>'Reset password items'
,p_parent_plug_id=>wwv_flow_api.id(8557512241276654.4905)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1418149362592020763.4905)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(692442804709370101.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1418413115140401416.4905)
,p_button_name=>'RESET_PASSWORD'
,p_button_action=>'SUBMIT'
,p_button_template_id=>wwv_flow_api.id(798473351219404350.4905)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Redefinir Senha'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>' a-Button--large'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(692442518084364512.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1418413115140401416.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(798473351219404350.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:::'
,p_button_css_classes=>'a-Button--large'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(692443304148379348.4905)
,p_branch_action=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(692442804709370101.4905)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(692437908116266949.4905)
,p_name=>'P92_EMAIL'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1418413115140401416.4905)
,p_prompt=>unistr('Seu endere\00E7o de e-mail em nosso banco de dados')
,p_placeholder=>unistr('endere\00E7o de e-mail')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(1418153120551046350.4905)
,p_item_css_classes=>'icon-login-email'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'EMAIL'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(692438611018277308.4905)
,p_name=>'P92_WORKSPACE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1418413115140401416.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('Informe seu espa\00E7o de trabalho.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(693704031500021583.4905)
,p_name=>'P92_USERNAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1418413115140401416.4905)
,p_prompt=>unistr('Nome do Usu\00E1rio')
,p_placeholder=>unistr('nome do usu\00E1rio')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(1418153120551046350.4905)
,p_item_css_classes=>'icon-login-username'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(7293128029885669.4905)
,p_validation_name=>'is valid email and username'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_fnd_user u, wwv_flow_ws_applications w',
'where upper(u.email_address) = upper(:P92_EMAIL) and',
'      upper(u.user_name) = upper(:P92_USERNAME) and',
'      u.security_group_id != 10 and',
'      u.security_group_id = w.security_group_id and',
'      w.id = :WS_APP_ID'))
,p_validation_type=>'EXISTS'
,p_error_message=>unistr('O nome do usu\00E1rio ou endere\00E7o de e-mail informado est\00E1 incorreto.')
,p_when_button_pressed=>wwv_flow_api.id(692442804709370101.4905)
,p_associated_item=>wwv_flow_api.id(.4905)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(692443023410375451.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Reset Password'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_fnd_developer_api.f4900_reset_password (',
'  p_ws_app_id => :WS_APP_ID,',
'  p_user_name => :P92_USERNAME,',
'  p_email_address=> :P92_EMAIL,',
'  p_workspace_name=> null );'))
,p_process_error_message=>unistr('N\00E3o foi poss\00EDvel redefinir a senha.')
,p_process_when_button_id=>wwv_flow_api.id(692442804709370101.4905)
,p_process_success_message=>unistr('A solicita\00E7\00E3o redefinir senha foi enviada para processamento.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(693689731931002813.4905)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Determine Workspace'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select security_group_id from wwv_flow_ws_applications where id = :WS_APP_ID) loop',
'    :P92_WORKSPACE := c1.security_group_id;',
'end loop;'))
);
end;
/
prompt --application/pages/page_00099
begin
wwv_flow_api.create_page(
 p_id=>99.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('N\00E3o Autorizado')
,p_step_title=>unistr('N\00E3o Autorizado')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456110204457776640.4905)
,p_plug_name=>'Not Authorized'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>Voc\00EA n\00E3o tem autoriza\00E7\00E3o para acessar este aplicativo ou fun\00E7\00E3o.</p>')
,p_translate_title=>'N'
,p_region_image=>'#IMAGE_PREFIX#menu/alarm_bell_wbg_64x64.png'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00101
begin
wwv_flow_api.create_page(
 p_id=>101.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Log-in'
,p_alias=>'LOGIN'
,p_step_title=>'Acessar Websheets'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-AppCards--slim .a-AppCards-icon { margin: 16px auto; }',
'h1.a-Login-title { font-size: 20px; margin: 24px 0; }',
'.a-Login-wsMsg { font-size: 14px; margin: 16px 8px; color: #707070; }',
'.a-Form-fieldContainer--hiddenLabel .apex-item-option {height: 16px;}'))
,p_step_template=>wwv_flow_api.id(1418140425267007336.4905)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1410890655888668019.4905)
,p_plug_name=>unistr('Cont\00EAiner da Regi\00E3o de Acesso')
,p_region_css_classes=>'a-Login-region a-Form--stretchInputs a-Form--labelsAbove'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3700433754276.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(154773620917091162.4905)
,p_plug_name=>'Sign In items'
,p_parent_plug_id=>wwv_flow_api.id(1410890655888668019.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="float:left; clear:both;"'
,p_plug_template=>wwv_flow_api.id(1418149362592020763.4905)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459631111530350735.4905)
,p_plug_name=>'Language Selector'
,p_parent_plug_id=>wwv_flow_api.id(1410890655888668019.4905)
,p_region_css_classes=>'a-Login-links a-Login-links--languages'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3700433754276.4905)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p( wwv_flow_lang.get_language_selector_list );'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'wwv_flow_4000_ui.is_translation_installed( p_flow_id => 4000 )'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1410890754992668020.4905)
,p_plug_name=>'Sign In Region Header'
,p_parent_plug_id=>wwv_flow_api.id(1410890655888668019.4905)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (with pkg_app_image as (',
'               select m.installed_ws_id,',
'                      p.image_identifier image_class',
'               from wwv_flow_pkg_applications p, wwv_flow_pkg_app_map m',
'               where p.app_id = m.app_id',
'               and p.app_type = ''WS''',
'               and m.security_group_id = :flow_security_group_id',
'               )',
'           select ',
'               p.image_class,',
'               case when p.image_class is null then ',
'                   wwv_flow_4000_ui.get_app_initials( name, id )',
'               else',
'                   '' ''',
'               end as app_initials,',
'               case when p.image_class is null then ',
'                   ''u-ColorBG--'' || to_char( ora_hash( name, 29 ) + 1 )',
'               else',
'                   '' ''',
'               end as app_color,',
'               name ws_name',
'           from  wwv_flow_ws_applications a,',
'                 pkg_app_image p',
'           where a.security_group_id = :flow_security_group_id',
'           and a.id = p.installed_ws_id (+)',
'           and a.id = :ws_app_id)',
'loop',
'    sys.htp.p(''<div class="a-Login-header a-AppCards--slim">'');',
'    sys.htp.p(''  <span class="a-AppCards-icon a-AppCards-icon--initials ''||',
'              wwv_flow_escape.html(c1.image_class)||'' ''||',
'              wwv_flow_escape.html(c1.app_color)||',
'              ''" role="presentation" aria-hidden="true">''||',
'              wwv_flow_escape.html(c1.app_initials)||',
'              ''</span>'');',
'    sys.htp.p(''  <h1 class="a-Login-title">''||wwv_flow_escape.html(c1.ws_name)||''</h1>'');',
'    for l_msg in (select login_page_message ',
'                  from WWV_FLOW_WS_APPLICATIONS ',
'                  where id = :WS_APP_ID',
'                  and login_page_message is not null )',
'    loop',
'        sys.htp.p(''<p class="a-Login-wsMsg">''||wwv_flow_escape.html(l_msg.login_page_message)||''</p>'');',
'    end loop;',
'    sys.htp.p(''</div>'');',
'end loop;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(61034832101787205.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(154773620917091162.4905)
,p_button_name=>'RESET_PASSWORD'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Redefinir Senha'
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:92:&SESSION.::&DEBUG.:::'
,p_button_condition=>'return wwv_flow_ws_api.show_reset_password (p_ws_app_id=>:WS_APP_ID);'
,p_button_condition_type=>'FUNCTION_BODY'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5698501044727837.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(154773620917091162.4905)
,p_button_name=>'LOGIN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(798473351219404350.4905)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Acessar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--large'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(154773716538091162.4905)
,p_name=>'P101_USERNAME'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(154773620917091162.4905)
,p_prompt=>unistr('Nome do Usu\00E1rio')
,p_placeholder=>unistr('nome do usu\00E1rio')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>128
,p_field_template=>wwv_flow_api.id(1418153120551046350.4905)
,p_item_css_classes=>'icon-login-username'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(154773815685091162.4905)
,p_name=>'P101_PASSWORD'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(154773620917091162.4905)
,p_prompt=>'Senha'
,p_placeholder=>'senha'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>40
,p_cMaxlength=>100
,p_field_template=>wwv_flow_api.id(1418153120551046350.4905)
,p_item_css_classes=>'icon-login-password'
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(216990508511910211.4905)
,p_name=>'P101_REMEMBER'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(154773620917091162.4905)
,p_prompt=>unistr('Lembrar Nome do Usu\00E1rio')
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'REMEMBER_USERNAME'
,p_lov=>'.'||wwv_flow_api.id(263997216503587205.4905)||'.'
,p_field_template=>wwv_flow_api.id(264000229814622656.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
unistr('Se voc\00EA marcar esta caixa de sele\00E7\00E3o, a websheet salvar\00E1 seu nome de usu\00E1rio em um cookie de browser persistente chamado "LOGIN_USERNAME_COOKIE".'),
unistr('Quando voc\00EA for at\00E9 a p\00E1gina de log-in na pr\00F3xima vez, '),
unistr('o campo de nome do usu\00E1rio ser\00E1 preenchido automaticamente com esse valor.'),
'</p>',
'<p>',
unistr('Se voc\00EA desmarcar esta caixa de sele\00E7\00E3o e o seu nome de usu\00E1rio j\00E1 estiver salvo no cookie,'),
unistr('a websheet o substituir\00E1 por um valor vazio.'),
unistr('Voc\00EA tamb\00E9m pode usar as ferramentas de desenvolvedor do seu browser para remover completamente o cookie.'),
'</p>'))
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(388700621118310671.4905)
,p_name=>'P101_BUILDER_SESSION_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(154773620917091162.4905)
,p_use_cache_before_default=>'NO'
,p_item_default=>'wwv_flow_security.get_builder_session_id'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_source=>'wwv_flow_security.get_builder_session_id'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(10356803620488362.4905)
,p_validation_name=>'P101_USERNAME Not Null'
,p_validation_sequence=>10
,p_validation=>'P101_USERNAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'O valor deve ser especificado.'
,p_associated_item=>wwv_flow_api.id(154773716538091162.4905)
,p_error_display_location=>'INLINE_WITH_FIELD'
,p_validation_comment=>'generated 09-OCT-2008 14:47'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(10357031948488372.4905)
,p_validation_name=>'P101_PASSWORD Not Null'
,p_validation_sequence=>20
,p_validation=>'P101_PASSWORD'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'O valor deve ser especificado.'
,p_associated_item=>wwv_flow_api.id(154773815685091162.4905)
,p_error_display_location=>'INLINE_WITH_FIELD'
,p_validation_comment=>'generated 09-OCT-2008 14:47'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(154774114072091162.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Username Cookie'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_authentication.send_login_username_cookie (',
'    p_username => :P101_USERNAME,',
'    p_consent  => :P101_REMEMBER = ''Y'' );'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(154774006644091162.4905)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Login'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_custom_auth_std.ws_login(',
'    P_UNAME            => :P101_USERNAME,',
'    P_PASSWORD         => :P101_PASSWORD,',
'    P_SESSION_ID       => v(''APP_SESSION''),',
'    P_WEBSHEET_APP_ID  => :WS_APP_ID,',
'    p_websheet_page_id => :P900_ID );'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(154774302570091162.4905)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'Clear Page(s) Cache'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'101'
,p_process_when=>'P101_REGION'
,p_process_when_type=>'REQUEST_NOT_EQUAL_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(154774210215091162.4905)
,p_process_sequence=>40
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Username Cookie'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P101_USERNAME := apex_authentication.get_login_username_cookie;',
':P101_REMEMBER := case when :P101_USERNAME is not null then ''Y'' end;'))
,p_process_when=>':P101_USERNAME is null'
,p_process_when_type=>'PLSQL_EXPRESSION'
);
end;
/
prompt --application/pages/page_00102
begin
wwv_flow_api.create_page(
 p_id=>102.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Feedback'
,p_alias=>'FEEDBACK'
,p_step_title=>'Feedback'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>wwv_flow_api.id(134255203486851095.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_page_comment=>'This page was generated by the feedback wizard'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(203493217304049113.4905)
,p_plug_name=>'Feedback'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(82536903857665765.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752334827869677901.4905)
,p_plug_name=>unistr('Regi\00E3o de Bot\00E3o')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(25109627701530900.4905)
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(203497828051049124.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(752334827869677901.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(203497606057049122.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(752334827869677901.4905)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4905)
,p_button_image_alt=>'Submeter Feedback'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203493400295049114.4905)
,p_name=>'P102_APPLICATION_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4905)
,p_prompt=>'Aplicativo'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>60
,p_cMaxlength=>2000
,p_cHeight=>1
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Identifica o Aplicativo.'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203494014853049116.4905)
,p_name=>'P102_PAGE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4905)
,p_prompt=>unistr('P\00E1gina')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>60
,p_cMaxlength=>2000
,p_cHeight=>1
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica a p\00E1gina no aplicativo.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203494614905049117.4905)
,p_name=>'P102_A'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4905)
,p_display_as=>'NATIVE_STOP_AND_START_HTML_TABLE'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_display_when_type=>'NEVER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203494830875049118.4905)
,p_name=>'P102_FEEDBACK'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4905)
,p_prompt=>'Feedback'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Informe seu feedback e pressione o bot\00E3o submeter feedback.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203495425757049118.4905)
,p_name=>'P102_X'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4905)
,p_display_as=>'NATIVE_STOP_AND_START_HTML_TABLE'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_display_when_type=>'NEVER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203495625923049119.4905)
,p_name=>'P102_FEEDBACK_TYPE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4905)
,p_prompt=>'Tipo de Feedback'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>'select the_name, id from WWV_FLOW_FEEDBACK_TYPES order by id'
,p_cSize=>20
,p_cMaxlength=>100
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Identifique o tipo de feedback que voc\00EA est\00E1 fornecendo.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203496204433049120.4905)
,p_name=>'P102_Y'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4905)
,p_display_as=>'NATIVE_STOP_AND_START_HTML_TABLE'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_display_when_type=>'NEVER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_item_comment=>'workspace 10'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203496432737049121.4905)
,p_name=>'P102_ATTRIBUTE1'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4905)
,p_prompt=>'Componente:'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'FEEDBACK_COMPONENT'
,p_lov=>'.'||wwv_flow_api.id(945870019196474793.4905)||'.'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('Forne\00E7a essas informa\00E7\00F5es para fazer log-in como feedback.')
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203497005770049121.4905)
,p_name=>'P102_ATTRIBUTE2'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4905)
,p_prompt=>'Atributo 2'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Forne\00E7a essas informa\00E7\00F5es para fazer log-in como feedback.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(203498000886049124.4905)
,p_validation_name=>'Feedback not null'
,p_validation_sequence=>10
,p_validation=>'P102_FEEDBACK'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'O valor deve ser especificado.'
,p_when_button_pressed=>wwv_flow_api.id(203497606057049122.4905)
,p_associated_item=>wwv_flow_api.id(203494830875049118.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(203498223414049125.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Submit Feedback'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.submit_feedback (',
'    p_comment         => :P102_FEEDBACK,',
'    p_type            => :P102_FEEDBACK_TYPE,',
'    p_application_id     => :P102_APPLICATION_ID,',
'    p_page_id         => :P102_PAGE_ID,',
'    p_label_01        => ''Component'',',
'    p_label_02        => ''Contact me via email'',',
'    p_attribute_01   => :P102_ATTRIBUTE1,',
'    p_attribute_02   => :P102_ATTRIBUTE2);'))
,p_process_when_button_id=>wwv_flow_api.id(203497606057049122.4905)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(203498403008049126.4905)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Window'
);
end;
/
prompt --application/pages/page_00131
begin
wwv_flow_api.create_page(
 p_id=>131.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Criar P\00E1gina')
,p_step_title=>unistr('Criar P\00E1gina')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20820515633073398.4905)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173220910407622558.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173221309115622593.4905)
,p_plug_name=>'Criar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173227111911856634.4905)
,p_plug_name=>'create page progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(29874807106517169.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4905)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(173233928842908830.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(20820515633073398.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(173234125942908830.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(20820515633073398.4905)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4905)
,p_button_image_alt=>unistr('Pr\00F3ximo')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(173234507156912066.4905)
,p_branch_action=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:205::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P131_PAGE_TYPE'
,p_branch_condition_text=>'DATA'
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(181302519582692237.4905)
,p_branch_action=>'f?p=&APP_ID.:1310:&SESSION.::&DEBUG.:1310,1320::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(173234125942908830.4905)
,p_branch_sequence=>30
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P131_PAGE_TYPE'
,p_branch_condition_text=>'REPORT'
,p_save_state_before_branch_yn=>'Y'
,p_security_scheme=>wwv_flow_api.id(495860932509802714)
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(173236415514942802.4905)
,p_name=>'P131_PAGE_TYPE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(173221309115622593.4905)
,p_item_default=>'TEXT'
,p_prompt=>unistr('Qual tipo de componente de dados voc\00EA deseja criar?')
,p_source=>'DATA'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'CREATE DATA OR REPORT'
,p_lov=>'.'||wwv_flow_api.id(173236520362944199.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'ABOVE'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>'Selecione o tipo de componente de dados a ser criado.'
,p_attribute_01=>'3'
,p_attribute_02=>'NONE'
);
end;
/
prompt --application/pages/page_00140
begin
wwv_flow_api.create_page(
 p_id=>140.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Monitorar Atividade'
,p_step_title=>'Monitorar Atividade'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(9297021464956579.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(187174414157946457.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459635018791429050.4905)
,p_plug_name=>'Atividade'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:49%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(459634320543429042.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(460619812376871783.4905)
,p_plug_name=>'Sobre'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4905)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Use estas p\00E1ginas para analisar o uso, desempenho e popularidade das p\00E1ginas e do conte\00FAdo.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(461180329066335897.4905)
,p_plug_name=>unistr('Anota\00E7\00F5es')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:49%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4905)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(461178801985335895.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4905)
);
end;
/
prompt --application/pages/page_00141
begin
wwv_flow_api.create_page(
 p_id=>141.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Principais Grades de Dados'
,p_step_title=>'Principais Grades de Dados'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23764728224473605.4905)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23764905998473606.4905)
,p_plug_name=>'Monitor Activity Tab'
,p_parent_plug_id=>wwv_flow_api.id(23764728224473605.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23689225706066046.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23765115127473607.4905)
,p_plug_name=>'Set Page'
,p_parent_plug_id=>wwv_flow_api.id(23764728224473605.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>210
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<div class="wsSmallFormComponent">'
,p_plug_footer=>'</div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(461236028506810793.4905)
,p_plug_name=>'Page Views'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'   (select max(WEBSHEET_NAME)',
'       from WWV_FLOW_WS_WEBSHEET_ATTR p',
'       where p.ws_app_id = :ws_app_id',
'       and p.id = l.DATAGRID_ID) data_grid_name,',
'    count(*) page_views,',
'    avg(elap) elap,',
'    avg(num_rows) num_rows,',
'    count(distinct userid) userid,',
'    avg(content_length) CONTENT_LENGTH',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - nvl(:P141_TIME,1)) and',
'    ( flow_id = 4900 ) and',
'    websheet_id = :ws_app_id and',
'    DATAGRID_ID is not null and',
'    datagrid_id in (select id from WWV_FLOW_WS_WEBSHEET_ATTR where ws_app_id = :ws_app_id and WEBSHEET_TYPE = ''DATA'')',
'group by     l.DATAGRID_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(461236228917810797.4905)
,p_name=>'Page Views'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461236316065810801.4905)
,p_db_column_name=>'ELAP'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Tempo M\00E9dio de Convers\00E3o')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461236430570810802.4905)
,p_db_column_name=>'NUM_ROWS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('M\00E9dia de Linhas')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461236514063810802.4905)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('Tamanho M\00E9dio do Conte\00FAdo')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461236710411810802.4905)
,p_db_column_name=>'USERID'
,p_display_order=>25
,p_column_identifier=>'Y'
,p_column_label=>unistr('Usu\00E1rios Distintos')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461236829739810802.4905)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('Views de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461242409753848980.4905)
,p_db_column_name=>'DATA_GRID_NAME'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>'Nome da Grade de Dados'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(461330100756322323.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(461237306673810811.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(461236028506810793.4905)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.:141,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(461237501740810812.4905)
,p_name=>'P141_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(23765115127473607.4905)
,p_item_default=>'1'
,p_prompt=>'Prazo'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Exibir dados do relat\00F3rio no per\00EDodo de relat\00F3rios selecionado.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00142
begin
wwv_flow_api.create_page(
 p_id=>142.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Principais Relat\00F3rios')
,p_step_title=>unistr('Principais Relat\00F3rios')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23768425584482295.4905)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23768620004482297.4905)
,p_plug_name=>'Monitor Activity Tab'
,p_parent_plug_id=>wwv_flow_api.id(23768425584482295.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23689225706066046.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23768808968482297.4905)
,p_plug_name=>'Set Page'
,p_parent_plug_id=>wwv_flow_api.id(23768425584482295.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>210
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<div class="wsSmallFormComponent">'
,p_plug_footer=>'</div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(461244005589858615.4905)
,p_plug_name=>'Page Views'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'   (select max(WEBSHEET_NAME)',
'       from WWV_FLOW_WS_WEBSHEET_ATTR p',
'       where p.ws_app_id = :ws_app_id',
'       and p.id = l.DATAGRID_ID) data_grid_name,',
'    count(*) page_views,',
'    avg(elap) elap,',
'    avg(num_rows) num_rows,',
'    count(distinct userid) userid,',
'    avg(content_length) CONTENT_LENGTH',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - nvl(:P142_TIME,1)) and',
'    ( flow_id = 4900 ) and',
'    websheet_id = :ws_app_id and',
'    DATAGRID_ID is not null and',
'    datagrid_id in (select id from WWV_FLOW_WS_WEBSHEET_ATTR where ws_app_id = :ws_app_id and WEBSHEET_TYPE = ''REPORT'')',
'group by     l.DATAGRID_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(461244219249858616.4905)
,p_name=>'Page Views'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244423593858617.4905)
,p_db_column_name=>'ELAP'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Tempo M\00E9dio de Convers\00E3o')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244509013858617.4905)
,p_db_column_name=>'NUM_ROWS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('M\00E9dia de Linhas')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244618067858617.4905)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('Tamanho M\00E9dio do Conte\00FAdo')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244716297858617.4905)
,p_db_column_name=>'USERID'
,p_display_order=>25
,p_column_identifier=>'Y'
,p_column_label=>unistr('Usu\00E1rios Distintos')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244806456858617.4905)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('Views de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244320248858616.4905)
,p_db_column_name=>'DATA_GRID_NAME'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>'Nome da Grade de Dados'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(461331213223325868.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(461245330336858618.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(461244005589858615.4905)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.:142,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(461245523336858619.4905)
,p_name=>'P142_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(23768808968482297.4905)
,p_item_default=>'1'
,p_prompt=>'Prazo'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Exibir dados do relat\00F3rio no per\00EDodo de relat\00F3rios selecionado.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00143
begin
wwv_flow_api.create_page(
 p_id=>143.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Principais Arquivos'
,p_step_title=>'Principais Arquivos'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471901413752065160.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471907103870125733.4905)
,p_plug_name=>'Top Files by User'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'       c009 created_by,',
'       count(*) c,',
'       sum(decode(greatest(d002,sysdate-1),sysdate-1,0,1)) last_day,',
'       sum(decode(greatest(d002,sysdate-7),sysdate-7,0,1)) created_last_7_days,',
'       sum(decode(greatest(d002,add_months(sysdate,-1)),add_months(sysdate,-1),0,1)) last_month,',
'       apex_util.get_since(max(d002)) most_recent',
'from wwv_flow_collections',
'where collection_name = ''APEX$_WS_FILES''',
'group by c009'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(471907203619125733.4905)
,p_name=>'Top Files by User'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471907430015125742.4905)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('Nome do Usu\00E1rio')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471907510799125744.4905)
,p_db_column_name=>'C'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Contagem de Arquivos'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471909222611156826.4905)
,p_db_column_name=>'CREATED_LAST_7_DAYS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Semana Passada'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471909706596171166.4905)
,p_db_column_name=>'LAST_MONTH'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('M\00EAs Passado')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471910003957179869.4905)
,p_db_column_name=>'LAST_DAY'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\00DAltimo Dia')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471914803012236331.4905)
,p_db_column_name=>'MOST_RECENT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Mais Recente'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(473412104980505809.4905)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23795705639561731.4905)
,p_plug_name=>'Admin Annotation Tab'
,p_parent_plug_id=>wwv_flow_api.id(473412104980505809.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23775330395531080.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(473412314903505852.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(471907103870125733.4905)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.:143,RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(471901910350068155.4905)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create collection'
,p_process_sql_clob=>'wwv_flow_ws_api.create_attachment_collection (p_ws_app_id    => :ws_app_id);'
);
end;
/
prompt --application/pages/page_00144
begin
wwv_flow_api.create_page(
 p_id=>144.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Principais Observa\00E7\00F5es')
,p_step_title=>unistr('Principais Observa\00E7\00F5es')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471902911012084490.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471912413500212406.4905)
,p_plug_name=>'Top Notes by Username'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'   c003 created_by,',
'   count(*) new_notes,',
'   sum(decode(greatest(d001,sysdate-1),sysdate-1,0,1)) last_day,',
'   sum(decode(greatest(d001,sysdate-7),sysdate-7,0,1)) created_last_7_days,',
'   sum(decode(greatest(d001,add_months(sysdate,-1)),add_months(sysdate,-1),0,1)) last_month,',
'   apex_util.get_since(max(d001)) most_recent',
'from wwv_flow_collections',
'where collection_name = ''APEX$_WS_NOTES''',
'group by c003'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(471912507778212406.4905)
,p_name=>'Top Notes by Username'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471912706310212408.4905)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('Nome do Usu\00E1rio')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471912829080212409.4905)
,p_db_column_name=>'NEW_NOTES'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Contagem de Observa\00E7\00E3o')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471913913139220374.4905)
,p_db_column_name=>'LAST_DAY'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\00DAltimo Dia')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471914029231220374.4905)
,p_db_column_name=>'CREATED_LAST_7_DAYS'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Semana Passada'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471914113108220376.4905)
,p_db_column_name=>'LAST_MONTH'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('M\00EAs Passado')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471914307729228250.4905)
,p_db_column_name=>'MOST_RECENT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Mais Recente'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(473415025889521297.4905)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4905)
,p_plug_display_sequence=>3
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23814902438579759.4905)
,p_plug_name=>'Admin Annotation Tab'
,p_parent_plug_id=>wwv_flow_api.id(473415025889521297.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23775330395531080.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(473416325674530692.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(471912413500212406.4905)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:144:&SESSION.::&DEBUG.:144,RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(471912009760200442.4905)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_note_collection (',
'    p_ws_app_id => :ws_app_id',
'    );'))
);
end;
/
prompt --application/pages/page_00145
begin
wwv_flow_api.create_page(
 p_id=>145.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Principais Tags'
,p_step_title=>'Principais Tags'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23816101530588971.4905)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(25109627701530900.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23816319486588973.4905)
,p_plug_name=>'Admin Annotation Tab'
,p_parent_plug_id=>wwv_flow_api.id(23816101530588971.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23775330395531080.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471904015280093887.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471905601524103473.4905)
,p_plug_name=>'Tag Cloud'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="clear: both"'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_webpage.show_tag_clouds (',
'    p_ws_app_id             => :ws_app_id,    ',
'    p_session_id            => :app_session);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
end;
/
prompt --application/pages/page_00146
begin
wwv_flow_api.create_page(
 p_id=>146.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Principais Usu\00E1rios')
,p_step_title=>unistr('Principais Usu\00E1rios')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23771705892505054.4905)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23771903817505055.4905)
,p_plug_name=>'Monitor Activity Tab'
,p_parent_plug_id=>wwv_flow_api.id(23771705892505054.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23689225706066046.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23772114743505056.4905)
,p_plug_name=>'Set Page'
,p_parent_plug_id=>wwv_flow_api.id(23771705892505054.4905)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>210
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<div class="wsSmallFormComponent">'
,p_plug_footer=>'</div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471916808921272522.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471919230020311098.4905)
,p_plug_name=>'Top Users'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    userid,',
'    count(*) page_views,',
'    count(distinct webpage_id) distinct_pages,',
'   sum(CONTENT_LENGTH) content_served,',
'   sum(num_rows) rows_served,',
'   sum(elap) page_generation_time',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - :P146_TIME) and',
'    ( flow_id = 4900 ) and',
'    websheet_id = :ws_app_id',
'group by userid'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(471919303440311098.4905)
,p_name=>'Top Users'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'Esta consulta retorna mais de 10.000 linhas. Filtre seus dados para garantir resultados completos.'
,p_no_data_found_message=>unistr('Dados n\00E3o encontrados.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471919508010311100.4905)
,p_db_column_name=>'USERID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('Usu\00E1rio')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471919604537311100.4905)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('Views de P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471919731265311100.4905)
,p_db_column_name=>'DISTINCT_PAGES'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('P\00E1ginas Distintas')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471919900949311100.4905)
,p_db_column_name=>'CONTENT_SERVED'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('Conte\00FAdo Fornecido')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471920018399311101.4905)
,p_db_column_name=>'ROWS_SERVED'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Linhas Fornecidas'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471920105353311101.4905)
,p_db_column_name=>'PAGE_GENERATION_TIME'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('Tempo de Gera\00E7\00E3o da P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990D99'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(472158913824081267.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(471919230020311098.4905)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4905)
,p_button_image_alt=>'Redefinir'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:146:&SESSION.::&DEBUG.:146,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472159121381081270.4905)
,p_name=>'P146_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(23772114743505056.4905)
,p_item_default=>'1'
,p_prompt=>'Prazo'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Exibir dados do relat\00F3rio no per\00EDodo de relat\00F3rios selecionado.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00200
begin
wwv_flow_api.create_page(
 p_id=>200.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Criar P\00E1gina')
,p_step_title=>unistr('Criar P\00E1gina')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1198430386542478.4905)
,p_plug_name=>unistr('Criar P\00E1gina')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11464130252463090.4905)
,p_plug_name=>unistr('Bot\00F5es da Barra de Ferramentas')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(436570726052138706.4905)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,    ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',   ',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_CREATE_PAGE''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(154880404371674336.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(11464130252463090.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(154880603784674338.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(11464130252463090.4905)
,p_button_name=>'create'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>unistr('Criar P\00E1gina')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(155398607371684404.4905)
,p_branch_action=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(173712624517222880.4905)
,p_name=>'P200_NAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1198430386542478.4905)
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Informe um nome de p\00E1gina, que ser\00E1 exibido no t\00EDtulo da janela e tamb\00E9m no breadcrumb.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(174369210872944115.4905)
,p_name=>'P200_PARENT_PAGE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1198430386542478.4905)
,p_prompt=>unistr('P\00E1gina M\00E3e')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TEXT WEBSHEETS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'from   wwv_flow_ws_webpages',
'where security_group_id = :flow_security_group_id and',
'      ws_app_id = :WS_APP_ID',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Selecionar P\00E1gina M\00E3e -')
,p_lov_null_value=>'%null%'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Se esta p\00E1gina for parte de uma hierarquia de p\00E1ginas, identifique a p\00E1gina m\00E3e.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(458468714942046990.4905)
,p_name=>'P200_PAGE_ALIAS'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(1198430386542478.4905)
,p_prompt=>unistr('Alias da P\00E1gina')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifique o alias da p\00E1gina, que pode ser usado para vincular a esta p\00E1gina.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(458480527802429176.4905)
,p_validation_name=>'P200_PAGE_ALIAS must be unique'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P200_PAGE_ALIAS is not null then',
'  if wwv_flow_ws_api.alias_exists (',
'    p_ws_app_id    => :ws_app_id,',
'    p_alias        => :P200_PAGE_ALIAS,',
'    p_alias_type   => ''PAGE'') then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('O alias da p\00E1gina j\00E1 existe. Informe outro alias.')
,p_when_button_pressed=>wwv_flow_api.id(154880603784674338.4905)
,p_associated_item=>wwv_flow_api.id(458468714942046990.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(513405225400857985.4905)
,p_validation_name=>'P200_PAGE_ALIAS is valid'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P200_PAGE_ALIAS is not null and not wwv_flow_ws_api.is_alphanumeric (p_str => :P200_PAGE_ALIAS) then',
'    return wwv_flow_lang.system_message(''WS_ALIAS_NOT_VALID'');',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>'Erro'
,p_when_button_pressed=>wwv_flow_api.id(154880603784674338.4905)
,p_associated_item=>wwv_flow_api.id(458468714942046990.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(173742624666383777.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ceate page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_webpage_id number := null;',
'begin',
'    l_webpage_id := wwv_flow_id.next_val;',
'    ',
'    wwv_flow_ws_api.create_webpage (',
'        p_webpage_id      => l_webpage_id,',
'        p_ws_app_id       => :WS_APP_ID,',
'        p_name            => :P200_NAME,',
'        p_page_alias      => :P200_PAGE_ALIAS,',
'        p_description     => null,',
'        p_parent_page_id  => replace(:P200_PARENT_PAGE,''%''||''null%'')',
'        );',
'        ',
'    :P900_ID := l_webpage_id;',
'end;'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar a p\00E1gina.')
,p_process_success_message=>unistr('P\00E1gina criada.')
);
end;
/
prompt --application/pages/page_00201
begin
wwv_flow_api.create_page(
 p_id=>201.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Criar Grade de Dados'
,p_step_title=>'Criar Grade de Dados'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function addTableRow2(pThis,pThat,pNum){',
'    //console.log(pThat);',
'    var tt = html_GetElement(pThat);',
'        tt = tt.getElementsByTagName("tbody")[0];',
'    var l_newRows = new Array();',
'    for(i=0;i<pNum;i++){',
'      var ogTR = tt.rows[tt.rows.length -1];',
'      var trClone = ogTR.cloneNode(true);',
'      if(document.all){',
'        myNewRow = tt.insertRow(tt.rows.length);',
'        oReplace = myNewRow.replaceNode(trClone);',
'      }else{',
'        tt.appendChild(trClone);',
'      }',
'      l_newRows[l_newRows.length] = trClone;',
'      ',
'      var tSelects = trClone.getElementsByTagName(''select'');',
'      for(var iSelects=0;iSelects<tSelects.length;iSelects++){',
'          tSelects[iSelects].selectedIndex = 0;',
'          tSelects[iSelects].disabled="";',
'       }',
'      var tInputs = trClone.getElementsByTagName(''input'');',
'      for(var iInputs=0;iInputs<tInputs.length;iInputs++){',
'        if(tInputs[iInputs].type=="text"){',
'        tInputs[iInputs].value="";',
'        tInputs[iInputs].disabled="";',
'        }',
'      }',
'    }',
'    return l_newRows;',
'}',
'',
'/*Add table row for add column*/',
'function ob_TableAddColumn(pThis,pThat,pNum){     ',
'  var newRows = addTableRow2(pThis,pThat,pNum);',
'  for (var i = 0;i<newRows.length;i++){',
'    var l_Inputs = newRows[i].getElementsByTagName(''input'');',
'    html_HiddenElement(l_Inputs[1]);',
'    html_HiddenElement(l_Inputs[2]);',
'  }',
'}',
'',
'var gLastRowMovedColor = ''#FFF'';'))
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20777514043457891.4905)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21434717060303392.4905)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29893532414751568.4905)
,p_plug_name=>'create page progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(29874807106517169.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(85200421058598337.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(161567019228946315.4905)
,p_plug_name=>'Criar Grade de Dados'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'wwv_flow_ws_ui.p201_define_data_grid_columns;'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_column_width=>'valign=top'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(161624313556285232.4905)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(161567019228946315.4905)
,p_button_name=>'ADD_COLUMN'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4905)
,p_button_image_alt=>'Adicionar Coluna'
,p_button_position=>'BOTTOM'
,p_button_redirect_url=>'javascript:ob_TableAddColumn(this,''htmldbNewTable'',1);'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(154889406934794672.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(20777514043457891.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(154889228692794671.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(20777514043457891.4905)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>'Criar Grade de Dados'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P201_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3021502937237873.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(20777514043457891.4905)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4905)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(459284513339156315.4905)
,p_branch_action=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:201:WS_APP_ID,P2_ID,P2_WEBSHEET_ID:&WS_APP_ID.,&P201_WORKSHEET_ID.,&P201_WEBSHEET_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(154889228692794671.4905)
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2691129726790817.4905)
,p_name=>'P201_PAGE_ID'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4905)
,p_use_cache_before_default=>'NO'
,p_item_default=>'2'
,p_prompt=>'Page ID'
,p_source=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(154889802826794677.4905)
,p_name=>'P201_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(154890025030794679.4905)
,p_name=>'P201_FLOW_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4905)
,p_source=>'APP_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(154890421381794680.4905)
,p_name=>'P201_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(161567019228946315.4905)
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Informe um nome de grade de dados.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(161620030694252400.4905)
,p_name=>'P201_COL_ORDER'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(161745022194836488.4905)
,p_name=>'P201_NEW_WORKSHEET_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(458477720127322928.4905)
,p_name=>'P201_ALIAS'
,p_item_sequence=>35
,p_item_plug_id=>wwv_flow_api.id(161567019228946315.4905)
,p_prompt=>'Alias'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Informe um alias de grade de dados. Voc\00EA pode us\00E1-lo para vincular essa grade de dados dentro das se\00E7\00F5es da p\00E1gina. Um alias de grade de dados deve ser exclusivo dentro de um aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459283706282144844.4905)
,p_name=>'P201_WORKSHEET_ID'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459283912425144845.4905)
,p_name=>'P201_WEBSHEET_ID'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(154890305337794680.4905)
,p_validation_name=>'P201_FLOW_ID not null'
,p_validation_sequence=>10
,p_validation=>'P201_FLOW_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Id do Fluxo deve ter algum valor.'
,p_associated_item=>wwv_flow_api.id(154890025030794679.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(154890725984794680.4905)
,p_validation_name=>'P201_NAME not null'
,p_validation_sequence=>20
,p_validation=>'P201_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'O nome deve ser especificado.'
,p_associated_item=>wwv_flow_api.id(154890421381794680.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(8647014897469438.4905)
,p_validation_name=>'column must be defined'
,p_validation_sequence=>40
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for i in 1..wwv_flow.g_f01.count',
'loop',
'  if wwv_flow.g_f01(i) is null then',
'    if i = 1 then',
'      return false;',
'    end if;',
'  end if;',
'end loop;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'A(s) coluna(s) da Websheet deve ser definida.'
,p_when_button_pressed=>wwv_flow_api.id(154889228692794671.4905)
,p_associated_item=>wwv_flow_api.id(.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(458488820108521527.4905)
,p_validation_name=>'P201_ALIAS must be unique'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P201_ALIAS is not null then',
'  if wwv_flow_ws_api.alias_exists (',
'    p_ws_app_id    => :ws_app_id,',
'    p_alias        => :P201_ALIAS,',
'    p_alias_type   => ''DATA_GRID'') then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('O alias j\00E1 existe. Informe outro alias.')
,p_associated_item=>wwv_flow_api.id(458477720127322928.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(660056428068767360.4905)
,p_validation_name=>'P201_NAME must be unique'
,p_validation_sequence=>60
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P201_NAME is not null then',
'  if wwv_flow_ws_api.websheet_name_exists (',
'    p_ws_app_id    => :ws_app_id,',
'    p_name         => :P201_NAME,',
'    p_type         => ''DATA'') then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('O nome da Grade de Dados j\00E1 existe. Informe outro nome.')
,p_associated_item=>wwv_flow_api.id(154890421381794680.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(865527713121965593.4905)
,p_validation_name=>'duplicate column name found'
,p_validation_sequence=>70
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_api.duplicate_found_in_array (    ',
'    p_array => wwv_flow.g_f01) then',
'  return false;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Foram encontrados nomes de colunas duplicados. O nome da coluna deve ser exclusivo.'
,p_associated_item=>wwv_flow_api.id(.4905)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(506158920514422820.4905)
,p_validation_name=>'P201_ALIAS is valid'
,p_validation_sequence=>80
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P201_ALIAS is not null and not wwv_flow_ws_api.is_alphanumeric (p_str => :P201_ALIAS) then',
'    return wwv_flow_lang.system_message(''WS_ALIAS_NOT_VALID'');',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>'Erro'
,p_associated_item=>wwv_flow_api.id(458477720127322928.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(169327811698892928.4905)
,p_process_sequence=>20
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set name'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'  r varchar2(255) := null;',
'  c pls_integer;',
'begin',
'for i in 1..12 loop',
'select  count(*) into c',
'from  wwv_flow_ws_websheet_attr w',
'where security_group_id = :flow_security_group_id and',
'websheet_name = upper(:app_user)||'' 0''||i;',
'if c = 0 then',
'   r := upper(:app_user)||'' 0''||i;',
'   exit;',
'end if;',
'end loop;',
':P201_NAME := r;',
'end;'))
,p_process_when=>'P201_NAME'
,p_process_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(161740023102827299.4905)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Data Grid'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_data_grid_from_scratch (',
'    p_ws_app_id     => :WS_APP_ID,',
'    p_name          => :P201_NAME,',
'    p_alias         => :P201_ALIAS,',
'    p_column_order  => :P201_COL_ORDER,',
'    p_worksheet_id  => :P201_WORKSHEET_ID,',
'    p_websheet_id   => :P201_WEBSHEET_ID',
'    );'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar a Grade de Dados.')
,p_process_when_button_id=>wwv_flow_api.id(154889228692794671.4905)
,p_process_success_message=>'Grades de Dados criada.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(23550931764462326.4905)
,p_process_sequence=>50
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save user input in collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_collection.create_or_truncate_collection(p_collection_name => ''WS_WIZ_COLUMNS'');',
'    ',
'wwv_flow_collection.add_members (',
'   p_collection_name => ''WS_WIZ_COLUMNS'',',
'   p_c001            => wwv_flow.g_f01,',
'   p_c002            => wwv_flow.g_f02);'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel salvar a entrada do usu\00E1rio.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(154889228692794671.4905)
);
end;
/
prompt --application/pages/page_00205
begin
wwv_flow_api.create_page(
 p_id=>205.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Criar Grade de Dados'
,p_step_title=>'Criar Grade de Dados'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2981808413059759.4905)
,p_plug_name=>'Criar Grade de Dados'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>Grades de Dados gerenciam os dados usados pelo aplicativo. Escolha como voc\00EA deseja criar sua Grade de Dados.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20775629580434005.4905)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29886309287650228.4905)
,p_plug_name=>'create page progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(29874807106517169.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(85198200626592456.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(157356222063249657.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(20775629580434005.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(157356622290249657.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(20775629580434005.4905)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4905)
,p_button_image_alt=>unistr('Pr\00F3ximo')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(157356416282249657.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(20775629580434005.4905)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4905)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(157369302417300714.4905)
,p_branch_action=>'f?p=&APP_ID.:201:&SESSION.::&DEBUG.:201,WS_WIZ_COLUMNS::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P205_CREATE'
,p_branch_condition_text=>'SCRATCH'
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(157374926444317137.4905)
,p_branch_action=>'f?p=&APP_ID.:206:&SESSION.::&DEBUG.:206,CLOB_CONTENT::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P205_CREATE'
,p_branch_condition_text=>'CUTANDPASTE'
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2962827104989463.4905)
,p_name=>'P205_CREATE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2981808413059759.4905)
,p_item_default=>'SCRATCH'
,p_source=>'SCRATCH'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'CREATE WORKSHEET OPTIONS'
,p_lov=>'.'||wwv_flow_api.id(2960208403984068.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'ABOVE'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'4'
,p_attribute_02=>'NONE'
);
end;
/
prompt --application/pages/page_00206
begin
wwv_flow_api.create_page(
 p_id=>206.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Criar Grade de Dados'
,p_step_title=>'Criar Grade de Dados'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(157592926751064610)
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20782013444514508.4905)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21432216236293657.4905)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29895108135791796.4905)
,p_plug_name=>'create websheet progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(29874807106517169.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(87067600442889007.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(157402130664498141.4905)
,p_plug_name=>'Fazer Upload da Planilha'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>'<p>Cole a planilha ou outros dados delimitados por guias a seguir.</p>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(157412930927517115.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(20782013444514508.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(157412021923514509.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(20782013444514508.4905)
,p_button_name=>'UPLOAD'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>'Fazer Upload'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3019823238234313.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(20782013444514508.4905)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4905)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(188356618124649439.4905)
,p_branch_action=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::WS_APP_ID,P2_ID,P2_WEBSHEET_ID:&WS_APP_ID.,&P206_WORKSHEET_ID.,&P206_WEBSHEET_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(157415007986529400.4905)
,p_name=>'P206_WORKSHEET_NAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(157402130664498141.4905)
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'width="100%"'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Informe o nome da grade de dados. '
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(161542600584694900.4905)
,p_name=>'P206_COLUMN_HEADINGS'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(157402130664498141.4905)
,p_item_default=>'Y'
,p_source=>'Y'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'FIRST_ROW_CONTAINS_COLUMN_HEADINGS'
,p_lov=>'.'||wwv_flow_api.id(799517811838484369.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(162619632484627537.4905)
,p_name=>'P206_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(21432216236293657.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(399301229989054252.4905)
,p_name=>'P206_SPREADSHEET'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(157402130664498141.4905)
,p_prompt=>'Colar Dados da Planilha'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.CLOB_TEXTAREA'
,p_cSize=>70
,p_cMaxlength=>4000
,p_cHeight=>15
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'spellcheck="false"'
,p_label_alignment=>'LEFT-TOP'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Copie e cole os dados que voc\00EA deseja carregar de um programa de planilhas.')
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(458479616018350127.4905)
,p_name=>'P206_WORKSHEET_ALIAS'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(157402130664498141.4905)
,p_prompt=>'Alias'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Informe um alias de grade de dados. Voc\00EA pode us\00E1-lo para vincular essa grade de dados dentro das se\00E7\00F5es da p\00E1gina. Um alias de grade de dados deve ser exclusivo dentro de um aplicativo.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459294712047212712.4905)
,p_name=>'P206_WORKSHEET_ID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(21432216236293657.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459294929831212712.4905)
,p_name=>'P206_WEBSHEET_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(21432216236293657.4905)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(458491521409540890.4905)
,p_validation_name=>'P206_WORKSHEET_ALIAS must be unique'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P206_WORKSHEET_ALIAS is not null then',
'  if wwv_flow_ws_api.alias_exists (',
'    p_ws_app_id    => :ws_app_id,',
'    p_alias        => :P206_WORKSHEET_ALIAS,',
'    p_alias_type   => ''DATA_GRID'') then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('O alias j\00E1 existe. Informe outro alias.')
,p_associated_item=>wwv_flow_api.id(458479616018350127.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(459413421772442554.4905)
,p_validation_name=>'P206_SPREADSHEET not null'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_clob clob;',
'begin',
'  l_clob := wwv_flow_utilities.get_clob_textarea_value(p_item_name => ''P206_SPREADSHEET'');',
'',
'  if (nvl(sys.dbms_lob.getlength(l_clob),0) = 0) then',
'      return false;',
'  end if;',
'',
'  return true;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Os dados devem ser fornecidos.'
,p_associated_item=>wwv_flow_api.id(399301229989054252.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(660376512709829107.4905)
,p_validation_name=>'P206_WORKSHEET_NAME must be unique'
,p_validation_sequence=>40
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P206_WORKSHEET_NAME is not null then',
'  if wwv_flow_ws_api.websheet_name_exists (',
'    p_ws_app_id    => :ws_app_id,',
'    p_name         => :P206_WORKSHEET_NAME,',
'    p_type         => ''DATA'') then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('O nome da Grade de Dados j\00E1 existe. Informe outro nome.')
,p_associated_item=>wwv_flow_api.id(157415007986529400.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(506662505047599536.4905)
,p_validation_name=>'P206_WORKSHEET_ALIAS is valid'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P206_WORKSHEET_ALIAS is not null and not wwv_flow_ws_api.is_alphanumeric (p_str => :P206_WORKSHEET_ALIAS) then',
'    return wwv_flow_lang.system_message(''WS_ALIAS_NOT_VALID'');',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>'Erro'
,p_associated_item=>wwv_flow_api.id(458479616018350127.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(159446328406626838.4905)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create data grid'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_data_grid_from_cp_paste (',
'    p_app_id            => :APP_ID,',
'    p_ws_app_id         => :WS_APP_ID,',
'    p_name              => :P206_WORKSHEET_NAME,',
'    p_alias             => :P206_WORKSHEET_ALIAS,',
'    p_headings_included => :P206_COLUMN_HEADINGS,',
'    p_collection_name   => ''P206_SPREADSHEET'',',
'    p_worksheet_id      => :P206_WORKSHEET_ID,',
'    p_websheet_id       => :P206_WEBSHEET_ID',
'    );'))
,p_process_error_message=>unistr('N\00E3o \00E9 poss\00EDvel criar a Grade de Dados.')
,p_process_when_button_id=>wwv_flow_api.id(157412021923514509.4905)
,p_process_success_message=>'Grades de Dados criada.'
);
end;
/
prompt --application/pages/page_00400
begin
wwv_flow_api.create_page(
 p_id=>400.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Painel de Controle'
,p_step_title=>'Painel de Controle'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5510207856754518.4905)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_menu_id=>wwv_flow_api.id(78897017520604216.4905)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4905)
,p_translate_title=>'N'
);
end;
/
prompt --application/pages/page_00605
begin
wwv_flow_api.create_page(
 p_id=>605.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>'Mapa Popup'
,p_step_title=>'Mapa Popup'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_html_page_onload=>'onload= "javascript:showMap()"'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="Javascript" src="http://jstraub-winsvr:8888/mapviewer/fsmc/jslib/oraclemaps.js"></script>',
'<script language="Javascript">',
'  function showMap()',
'  {	',
'    //var baseURL  = "http://jstraub-winsvr:8888/mapviewer";',
'    var baseURL  = "http://"+document.location.host+"/mapviewer";',
'    var mapCenterLon = -122.45;',
'    var mapCenterLat =  37.6706;',
'    var mapZoom      =  4;  ',
'    var mpoint = MVSdoGeometry.createPoint(mapCenterLon,mapCenterLat,8307);',
'    var mapview = new MVMapView(document.getElementById("map"), baseURL);',
'    mapview.addBaseMapLayer(new MVBaseMap("mvdemo.demo_map")); ',
'    mapview.setCenter(mpoint); ',
'    mapview.setZoomLevel(mapZoom);    ',
'    mapview.display();  			',
'  }',
'</script>'))
,p_step_template=>wwv_flow_api.id(134255203486851095.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_page_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'onload="initMap()" onunload="GUnload()"',
'',
'<script src="http://maps.google.com/maps?file=api&v=2&key=ABQIAAAAwUYWsA4XETWrnH3406u68BSpcm9k_R_VEi8Lh6rUeHFlEJtsBBTWlDwn_t67tfUX-0Tp-Cp28ozM7Q" type="text/javascript"></script>    ',
'<script type="text/javascript">    ',
'//<![CDATA[  ',
'//globals',
'var bounds = new GLatLngBounds();',
'',
'function initMap() {',
'if (GBrowserIsCompatible()) {   ',
'var map = new GMap2(document.getElementById("map"));',
'var title = "&P605_TITLE.";',
'map.addControl(new GSmallMapControl());',
'map.addControl(new GMapTypeControl());',
'var point = new GLatLng(&P605_LAT.,&P605_LNG.);',
'bounds.extend(point);',
'map.setCenter(point);',
'map.setZoom(map.getBoundsZoomLevel(bounds)-4);',
'var marker = new GMarker(point);',
'map.addOverlay(marker);',
'marker.openInfoWindowHtml(''<div class="tiny">'' + title.replace(/~/g,"<br />") + ''</div>'');',
'}',
'}',
'//]]>    ',
'</script>',
'',
'',
'',
'',
'',
''))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(176064014539794663.4905)
,p_plug_name=>'Map'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'<div id="map" style="width: 600px; height: 400px"></div>'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(176065119041796017.4905)
,p_name=>'P605_LAT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(176064014539794663.4905)
,p_item_default=>'39.961111'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(176065923543797264.4905)
,p_name=>'P605_TITLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(176064014539794663.4905)
,p_item_default=>'Oracle Columbus, OH'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(176160602221652009.4905)
,p_name=>'P605_LNG'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(176064014539794663.4905)
,p_item_default=>'-82.998889'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
end;
/
prompt --application/pages/page_00710
begin
wwv_flow_api.create_page(
 p_id=>710.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_step_title=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'bldapp_chrt_flash.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21404623275153782.4905)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(259451015474899829.4905)
,p_plug_name=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261473724838144583.4905)
,p_plug_name=>'create chart section progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(261469429368022853.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(436560332736922985.4905)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,   ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',',
'    p_parent_entry         => wwv_flow_lang.system_message(''WS_CREATE_SECTION''),',
'    p_parent_entry_page_id => 920,',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_CREATE_CHART_SECTION''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(259451227871899835.4905)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(21404623275153782.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(259451615967899838.4905)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(21404623275153782.4905)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4905)
,p_button_image_alt=>unistr('Pr\00F3ximo')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(259451427400899837.4905)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(21404623275153782.4905)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4905)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:920:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(259453009785899851.4905)
,p_branch_action=>'f?p=&APP_ID.:740:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(259451615967899838.4905)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(259453212836899853.4905)
,p_branch_action=>'f?p=&APP_ID.:710:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259451800210899839.4905)
,p_name=>'P710_CHART_TYPE'
,p_item_sequence=>280
,p_item_plug_id=>wwv_flow_api.id(259451015474899829.4905)
,p_item_default=>'COLUMN'
,p_prompt=>unistr('Selecionar Tipo de Gr\00E1fico')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'CHART_TYPE'
,p_lov=>'.'||wwv_flow_api.id(259453605523899856.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'ABOVE'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('Selecione o tipo de gr\00E1fico.')
,p_attribute_01=>'4'
,p_attribute_02=>'NONE'
,p_attribute_04=>'VERTICAL'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(259452823947899849.4905)
,p_validation_name=>'P710_DEFAULT_CHART_TYPE'
,p_validation_sequence=>20
,p_validation=>'P710_CHART_TYPE'
,p_validation_type=>'ITEM_NOT_NULL_OR_ZERO'
,p_error_message=>unistr('O tipo de gr\00E1fico deve ser especificado.')
,p_validation_condition=>'wwv_flow_flash_chart5.g_chart_engine = ''ANYCHART'''
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(259451615967899838.4905)
,p_associated_item=>wwv_flow_api.id(.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00740
begin
wwv_flow_api.create_page(
 p_id=>740.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_step_title=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21406523537172813.4905)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21407114664179699.4905)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261363204569258801.4905)
,p_plug_name=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261474625315154102.4905)
,p_plug_name=>'create chart section progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(261469429368022853.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(436560900576942084.4905)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,   ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',',
'    p_parent_entry         => wwv_flow_lang.system_message(''WS_CREATE_SECTION''),',
'    p_parent_entry_page_id => 920,',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_CREATE_CHART_SECTION''));',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261363407957258804.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(21406523537172813.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261363832524258807.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(21406523537172813.4905)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4905)
,p_button_image_alt=>unistr('Pr\00F3ximo')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261363630146258806.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(21406523537172813.4905)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4905)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:710:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(261364204030258811.4905)
,p_branch_action=>'f?p=&APP_ID.:742:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(261363832524258807.4905)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261364014478258808.4905)
,p_name=>'P740_DATA_GRID_ID'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4905)
,p_item_default=>'DATA_GRID'
,p_prompt=>'Grade de Dados'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'DATA GRID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name, id',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id',
'and websheet_type = ''DATA'''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Selecionar Grade de Dados -'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione a grade de dados que ser\00E1 usada para preencher o gr\00E1fico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261376900027371013.4905)
,p_name=>'P740_DISPLAY_SEQ'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4905)
,p_prompt=>unistr('Sequ\00EAncia de Exibi\00E7\00E3o')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_ws_api.get_next_webpg_section_seq (    ',
'    p_webpage_id  => :P900_ID);'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>6
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Informe a sequ\00EAncia de exibi\00E7\00E3o da se\00E7\00E3o. ')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261377609293392684.4905)
,p_name=>'P740_TITLE'
,p_is_required=>true
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4905)
,p_prompt=>unistr('T\00EDtulo da Se\00E7\00E3o')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Informe o t\00EDtulo da se\00E7\00E3o. ')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(262124824705602180.4905)
,p_name=>'P740_CHART_TYPE'
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4905)
,p_prompt=>unistr('Tipo de Gr\00E1fico')
,p_source=>'return wwv_flow_item.text_from_lov(:p710_chart_type,''CHART_TYPE'');'
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('O tipo de gr\00E1fico selecionado. ')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(428683227947684649.4905)
,p_name=>'P740_CHART_SOURCE'
,p_item_sequence=>35
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4905)
,p_item_default=>'DATA_GRID'
,p_prompt=>unistr('Origem do Gr\00E1fico')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'SECTION_SOURCE'
,p_lov=>'.'||wwv_flow_api.id(428681322228645128.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('Selecione o tipo de origem do gr\00E1fico.')
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(428698306448801460.4905)
,p_name=>'P740_REPORT_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4905)
,p_prompt=>unistr('Relat\00F3rio')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'REPORT'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name, id',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id',
'and websheet_type = ''REPORT'''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Selecionar Relat\00F3rio -')
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione o relat\00F3rio que ser\00E1 usado para preencher o gr\00E1fico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(428737702957923433.4905)
,p_name=>'P740_WEBSHEET_ID'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(21407114664179699.4905)
,p_prompt=>'Websheet Id'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(428752405961066251.4905)
,p_name=>'P740_WORKSHEET_ID'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(21407114664179699.4905)
,p_prompt=>'Worksheet Id'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(769439022514908016.4905)
,p_name=>'P740_SAVED_REPORT_ID'
,p_is_required=>true
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4905)
,p_prompt=>unistr('Defini\00E7\00F5es do Relat\00F3rio a Serem Usadas')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id r',
'from wwv_flow_worksheet_rpts',
'where worksheet_id = :P740_WORKSHEET_ID',
'and application_user = ''APXWS_DEFAULT''',
'and is_default = ''Y''                    ',
'and (security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and session_id is null'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'P740_SAVED_REPORTS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P740_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P740_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')) x',
'order by x.seq, x.r'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Selecionar Relat\00F3rio -')
,p_lov_cascade_parent_items=>'P740_WORKSHEET_ID'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Para a grade de dados ou o relat\00F3rio selecionado, escolha as defini\00E7\00F5es de relat\00F3rio a serem usadas. Isso permite filtrar as linhas e colunas que voc\00EA quer exibir. Se voc\00EA n\00E3o tiver um relat\00F3rio salvo com as defini\00E7\00F5es necess\00E1rias, crie-o agora, ante')
||unistr('s de adicionar a se\00E7\00E3o.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(770955330628071177.4905)
,p_name=>'P740_REPORT_COLUMNS'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(21407114664179699.4905)
,p_prompt=>'Report Columns'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(428745016378946272.4905)
,p_computation_sequence=>10
,p_computation_item=>'P740_WEBSHEET_ID'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P740_CHART_SOURCE = ''DATA_GRID'' then',
'  return :P740_DATA_GRID_ID;',
'elsif :P740_CHART_SOURCE = ''REPORT'' then',
'  return :P740_REPORT_ID;',
'end if;',
'  '))
,p_compute_when=>'replace(:P740_DATA_GRID_ID,''%''||''null%'') is not null or replace(:P740_REPORT_ID,''%''||''null%'') is not null'
,p_compute_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(428753515573087899.4905)
,p_computation_sequence=>20
,p_computation_item=>'P740_WORKSHEET_ID'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P740_CHART_SOURCE = ''DATA_GRID'' then',
'  for c1 in (select w.id',
'             from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'             where w.id = a.worksheet_id',
'             and w.security_group_id = :flow_security_group_id',
'             and a.id = :P740_DATA_GRID_ID)',
'  loop',
'    return c1.id;',
'  end loop;',
'elsif :P740_CHART_SOURCE = ''REPORT'' then',
'  for c1 in (select w.id',
'             from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'             where w.id = a.worksheet_id',
'             and w.security_group_id = :flow_security_group_id',
'             and a.id = :P740_REPORT_ID)',
'  loop',
'    return c1.id;',
'  end loop;',
'end if;'))
,p_compute_when=>'replace(:P740_DATA_GRID_ID,''%''||''null%'') is not null or replace(:P740_REPORT_ID,''%''||''null%'') is not null'
,p_compute_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(770974802016072332.4905)
,p_computation_sequence=>20
,p_computation_item=>'P740_REPORT_COLUMNS'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select report_columns',
'           from wwv_flow_worksheet_rpts',
'           where worksheet_id = :p740_worksheet_id',
'           and security_group_id = :flow_security_group_id',
'           and id = :p740_saved_report_id',
'           and session_id is null)',
'loop',
'  return c1.report_columns;',
'end loop;'))
,p_compute_when=>'P740_SAVED_REPORT_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(428748111839992173.4905)
,p_validation_name=>'P740_DATA_GRID_ID not null'
,p_validation_sequence=>10
,p_validation=>'P740_DATA_GRID_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#LABEL# deve ter algum valor.'
,p_validation_condition=>'P740_CHART_SOURCE'
,p_validation_condition2=>'DATA_GRID'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_when_button_pressed=>wwv_flow_api.id(261363832524258807.4905)
,p_associated_item=>wwv_flow_api.id(261364014478258808.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(428748522574995338.4905)
,p_validation_name=>'P740_REPORT_ID not null'
,p_validation_sequence=>20
,p_validation=>'P740_REPORT_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#LABEL# deve ter algum valor.'
,p_validation_condition=>'P740_CHART_SOURCE'
,p_validation_condition2=>'REPORT'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_when_button_pressed=>wwv_flow_api.id(261363832524258807.4905)
,p_associated_item=>wwv_flow_api.id(428698306448801460.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(261382623585453517.4905)
,p_name=>'get data grid title'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_DATA_GRID_ID'
,p_condition_element=>'P740_DATA_GRID_ID'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
,p_display_when_cond=>'P740_DATA_GRID_ID'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(261382912222453521.4905)
,p_event_id=>wwv_flow_api.id(261382623585453517.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_TITLE'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name',
'from wwv_flow_ws_websheet_attr',
'where id = :P740_DATA_GRID_ID',
'and security_group_id = :flow_security_group_id'))
,p_attribute_07=>'P740_DATA_GRID_ID'
,p_attribute_08=>'N'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(428701929781817609.4905)
,p_name=>'show hide data grid'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_CHART_SOURCE'
,p_condition_element=>'P740_CHART_SOURCE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'DATA_GRID'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(428702204856817609.4905)
,p_event_id=>wwv_flow_api.id(428701929781817609.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_DATA_GRID_ID'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(428702431656817610.4905)
,p_event_id=>wwv_flow_api.id(428701929781817609.4905)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_DATA_GRID_ID'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(428711509527849597.4905)
,p_name=>'show hide report'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_CHART_SOURCE'
,p_condition_element=>'P740_CHART_SOURCE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'REPORT'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(428711801380849598.4905)
,p_event_id=>wwv_flow_api.id(428711509527849597.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_REPORT_ID'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(428712030847849598.4905)
,p_event_id=>wwv_flow_api.id(428711509527849597.4905)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_REPORT_ID'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(428715908189877604.4905)
,p_name=>'get report title'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_REPORT_ID'
,p_condition_element=>'P740_REPORT_ID'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(428716206531877605.4905)
,p_event_id=>wwv_flow_api.id(428715908189877604.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_TITLE'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name',
'from wwv_flow_ws_websheet_attr',
'where id = :P740_REPORT_ID',
'and security_group_id = :flow_security_group_id'))
,p_attribute_07=>'P740_REPORT_ID'
,p_attribute_08=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(769744919097935359.4905)
,p_name=>'reset data grid, report id, saved report id to null if source changes'
,p_event_sequence=>50
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_CHART_SOURCE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(769745208133935360.4905)
,p_event_id=>wwv_flow_api.id(769744919097935359.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_REPORT_ID,P740_DATA_GRID_ID,P740_SAVED_REPORT_ID'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(769836400313948837.4905)
,p_name=>'set data grid worksheet and websheet id'
,p_event_sequence=>60
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_DATA_GRID_ID'
,p_condition_element=>'P740_DATA_GRID_ID'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(769836711787948837.4905)
,p_event_id=>wwv_flow_api.id(769836400313948837.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_WORKSHEET_ID'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select w.id',
'from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id',
'and w.security_group_id = :flow_security_group_id',
'and a.id = :P740_DATA_GRID_ID'))
,p_attribute_07=>'P740_DATA_GRID_ID'
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(770006016720963068.4905)
,p_event_id=>wwv_flow_api.id(769836400313948837.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_WEBSHEET_ID'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.id',
'from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id',
'and w.security_group_id = :flow_security_group_id',
'and a.id = :P740_DATA_GRID_ID'))
,p_attribute_07=>'P740_DATA_GRID_ID'
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(770182331742976872.4905)
,p_name=>'set report worksheet and websheet id'
,p_event_sequence=>70
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_REPORT_ID'
,p_condition_element=>'P740_REPORT_ID'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(770182616938976872.4905)
,p_event_id=>wwv_flow_api.id(770182331742976872.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_WORKSHEET_ID'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select w.id',
'from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id',
'and w.security_group_id = :flow_security_group_id',
'and a.id = :P740_REPORT_ID'))
,p_attribute_07=>'P740_REPORT_ID'
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(770266430488985958.4905)
,p_event_id=>wwv_flow_api.id(770182331742976872.4905)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_WEBSHEET_ID'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.id',
'from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id',
'and w.security_group_id = :flow_security_group_id',
'and a.id = :P740_REPORT_ID'))
,p_attribute_07=>'P740_REPORT_ID'
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
end;
/
prompt --application/pages/page_00742
begin
wwv_flow_api.create_page(
 p_id=>742.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_step_title=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21413916573218059.4905)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261388504493521133.4905)
,p_plug_name=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261474829471155310.4905)
,p_plug_name=>'create chart section progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(261469429368022853.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(436561331051950914.4905)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,   ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',',
'    p_parent_entry         => wwv_flow_lang.system_message(''WS_CREATE_SECTION''),',
'    p_parent_entry_page_id => 920,',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_CREATE_CHART_SECTION''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261388704242521195.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(21413916573218059.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261389116845521196.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(21413916573218059.4905)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4905)
,p_button_image_alt=>unistr('Pr\00F3ximo')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261388900323521196.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(21413916573218059.4905)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4905)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:740:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(261390303188521203.4905)
,p_branch_action=>'f?p=&APP_ID.:750:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(261389116845521196.4905)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261393406410533693.4905)
,p_name=>'P742_CHART_LABEL'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4905)
,p_prompt=>unistr('Label do Gr\00E1fico')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'P742_DATA_GRID_COLUMNS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P740_WEBSHEET_ID',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P740_SAVED_REPORT_ID',
'and worksheet_id = :P740_WORKSHEET_ID',
'and websheet_id = :P740_WEBSHEET_ID',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Selecionar Coluna -'
,p_lov_null_value=>'%null%'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Selecione a coluna a ser usada como o label.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261396115891545900.4905)
,p_name=>'P742_LABEL_TITLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4905)
,p_prompt=>unistr('T\00EDtulo do Eixo para Label')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P710_CHART_TYPE'
,p_display_when2=>'pie'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Informe o t\00EDtulo a ser exibido no eixo associado \00E0 coluna selecionada do Label.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261396329051549767.4905)
,p_name=>'P742_CHART_VALUE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4905)
,p_prompt=>unistr('Valor do Gr\00E1fico')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'P742_DATA_GRID_NUM_COLS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P740_WEBSHEET_ID',
'and c.column_type = ''NUMBER''',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P740_SAVED_REPORT_ID',
'and worksheet_id = :P740_WORKSHEET_ID',
'and websheet_id = :P740_WEBSHEET_ID',
'and column_type = ''NUMBER''',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Selecionar Coluna -'
,p_lov_null_value=>'%null%'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione a coluna a ser usada como o Valor. Se sua fun\00E7\00E3o for uma CONTAGEM, um Valor n\00E3o precisa ser selecionado.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261396504940552265.4905)
,p_name=>'P742_VALUE_TITLE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4905)
,p_prompt=>unistr('T\00EDtulo do Eixo para Valor')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P710_CHART_TYPE'
,p_display_when2=>'pie'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Informe o t\00EDtulo a ser exibido no eixo associado com a coluna seleciona do Valor.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261398411089572910.4905)
,p_name=>'P742_CHART_FUNCTION'
,p_item_sequence=>65
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4905)
,p_prompt=>unistr('Fun\00E7\00E3o')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'CHART FUNCTIONS'
,p_lov=>'.'||wwv_flow_api.id(261396928274568408.4905)||'.'
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Selecionar Fun\00E7\00E3o -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione uma fun\00E7\00E3o a ser executada na coluna selecionada para Valor.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261398613860573732.4905)
,p_name=>'P742_X'
,p_item_sequence=>45
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4905)
,p_display_as=>'NATIVE_STOP_AND_START_HTML_TABLE'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261448315339630888.4905)
,p_name=>'P742_CHART_SORT'
,p_item_sequence=>75
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4905)
,p_item_default=>'DEFAULT'
,p_prompt=>unistr('Classifica\00E7\00E3o')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'CHART SORT'
,p_lov=>'.'||wwv_flow_api.id(261446703779618102.4905)||'.'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione a dire\00E7\00E3o de classifica\00E7\00E3o do gr\00E1fico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(621666736107538434.4905)
,p_name=>'P742_CHART_ORIENTATION'
,p_item_sequence=>85
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4905)
,p_item_default=>'DEFAULT'
,p_prompt=>unistr('Orienta\00E7\00E3o')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'CHART_ORIENTATION'
,p_lov=>'.'||wwv_flow_api.id(107038275478210797.4905)||'.'
,p_cHeight=>1
,p_label_alignment=>'RIGHT-CENTER'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P710_CHART_TYPE'
,p_display_when2=>'pie'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Selecione a dire\00E7\00E3o de classifica\00E7\00E3o do gr\00E1fico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(622866606496034906.4905)
,p_validation_name=>'P742_CHART_VALUE not null'
,p_validation_sequence=>10
,p_validation=>'P742_CHART_VALUE'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#LABEL# deve ter algum valor.'
,p_validation_condition=>'P742_CHART_FUNCTION'
,p_validation_condition2=>'COUNT'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_associated_item=>wwv_flow_api.id(261396329051549767.4905)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00750
begin
wwv_flow_api.create_page(
 p_id=>750.4905
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4905)
,p_name=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_step_title=>unistr('Criar Se\00E7\00E3o do Gr\00E1fico')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4905)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21418604499242965.4905)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4905)
,p_plug_display_sequence=>61
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261476811573205292.4905)
,p_plug_name=>unistr('Confirmar Cria\00E7\00E3o de Se\00E7\00E3o do Gr\00E1fico')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4905)
,p_plug_display_sequence=>31
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_header=>unistr('Voc\00EA solicitou a cria\00E7\00E3o de uma se\00E7\00E3o de gr\00E1fico com os atributos a seguir. Confirme suas sele\00E7\00F5es.<p />')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261479831296212615.4905)
,p_plug_name=>'create chart section progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>41
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(261469429368022853.4905)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4905)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(436561528065959454.4905)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>51
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,   ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',',
'    p_parent_entry         => wwv_flow_lang.system_message(''WS_CREATE_SECTION''),',
'    p_parent_entry_page_id => 920,',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_CREATE_CHART_SECTION''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261477013637205299.4905)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(21418604499242965.4905)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4905)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261477420203205302.4905)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(21418604499242965.4905)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4905)
,p_button_image_alt=>unistr('Criar Se\00E7\00E3o')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261477215920205300.4905)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(21418604499242965.4905)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4905)
,p_button_image_alt=>'Anterior'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:742:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(261479201138205320.4905)
,p_branch_action=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(261477420203205302.4905)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261477801442205304.4905)
,p_name=>'P750_TITLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('T\00EDtulo da Se\00E7\00E3o')
,p_source=>'P740_TITLE'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261478225076205307.4905)
,p_name=>'P750_CHART_LABEL'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Label do Gr\00E1fico')
,p_source=>'P742_CHART_LABEL'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'P742_DATA_GRID_COLUMNS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P740_WEBSHEET_ID',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P740_SAVED_REPORT_ID',
'and worksheet_id = :P740_WORKSHEET_ID',
'and websheet_id = :P740_WEBSHEET_ID',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261478403806205307.4905)
,p_name=>'P750_CHART_SOURCE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Origem do Gr\00E1fico')
,p_source=>'P740_WEBSHEET_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'P750_CHART_SOURCE'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name||',
'       case when websheet_type=''DATA'' then '' (''||wwv_flow_lang.system_message(''DATA_GRID'')||'')''',
'            when websheet_type=''REPORT'' then '' (''||wwv_flow_lang.system_message(''REPORT'')||'')''',
'       end d,',
'       id r',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261481523247229241.4905)
,p_name=>'P750_CHART_TYPE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_prompt=>unistr('Tipo de Gr\00E1fico')
,p_source=>'return wwv_flow_item.text_from_lov(:P710_CHART_TYPE,''CHART_TYPE'')'
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(262132610281881794.4905)
,p_name=>'P750_LABEL_TITLE'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_prompt=>unistr('T\00EDtulo do Eixo para Label')
,p_source=>'P742_LABEL_TITLE'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P710_CHART_TYPE'
,p_display_when2=>'pie'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(262133012144891796.4905)
,p_name=>'P750_CHART_VALUE'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_prompt=>unistr('Valor do Gr\00E1fico')
,p_source=>'P742_CHART_VALUE'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'P742_DATA_GRID_NUM_COLS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P740_WEBSHEET_ID',
'and c.column_type = ''NUMBER''',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P740_SAVED_REPORT_ID',
'and worksheet_id = :P740_WORKSHEET_ID',
'and websheet_id = :P740_WEBSHEET_ID',
'and column_type = ''NUMBER''',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(262137723357904563.4905)
,p_name=>'P750_VALUE_TITLE'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_prompt=>unistr('T\00EDtulo do Eixo para Valor')
,p_source=>'P742_VALUE_TITLE'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P710_CHART_TYPE'
,p_display_when2=>'pie'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(262138724180914209.4905)
,p_name=>'P750_SORT'
,p_item_sequence=>155
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_prompt=>'Classificar'
,p_source=>'P742_CHART_SORT'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'CHART SORT'
,p_lov=>'.'||wwv_flow_api.id(261446703779618102.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(262139209766919560.4905)
,p_name=>'P750_CHART_FUNCTION'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_prompt=>unistr('Fun\00E7\00E3o')
,p_source=>'P742_CHART_FUNCTION'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'CHART FUNCTIONS'
,p_lov=>'.'||wwv_flow_api.id(261396928274568408.4905)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(429658830581943501.4905)
,p_name=>'P750_SAVED_REPORT_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Defini\00E7\00F5es do Relat\00F3rio a Serem Usadas')
,p_source=>'P740_SAVED_REPORT_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'P740_SAVED_REPORTS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P740_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P740_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')) x',
'order by x.seq, x.r'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(431069802828044934.4905)
,p_name=>'P750_DISPLAY_SEQ'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(261476811573205292.4905)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Sequ\00EAncia de Exibi\00E7\00E3o')
,p_source=>'P740_DISPLAY_SEQ'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4905)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(621666683956538433.4905)
,p_name=>'P750_CHART_ORIENTATION'
,p_item_sequence=>1