prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4417
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4417 - Oracle APEX  System Messages and Native Types
--
-- Application Export:
--   Application:     4417
--   Name:            Oracle APEX  System Messages and Native Types
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             124
--       Globalization:
--         Messages:          14,593
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX  System Messages and Native Types')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286626663492927378')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135328'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'zh-cn'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(91645213681389498.4417)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141231'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562090986404402217.4417)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48650898565635010.4417)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\6CE8\9500')
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>unistr('\4ECE Application Express \6CE8\9500')
,p_list_text_09=>'Y'
,p_list_text_10=>unistr('\6CE8\9500 \79BB\5F00 \9000\51FA :q')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(281916990329150760.4417)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5728\7535\5B50\8868\683C\4E0A\521B\5EFA\5E94\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=4000:447:&APP_SESSION.::NO:448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT::'
,p_list_text_01=>unistr('\5BFC\5165 Excel \6216 csv \6587\4EF6\5E76\521B\5EFA\5E94\7528\7A0B\5E8F')
,p_list_text_09=>'Y'
,p_list_text_10=>unistr('excel csv xsl xslx \7535\5B50\8868\683C \6570\636E \7C98\8D34 \52A0\8F7D \5BFC\5165')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(282255839842182292.4417)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Oracle APEX \4E3B\76EE\5F55')
,p_list_item_link_target=>'f?p=4500:1000:&APP_SESSION.'
,p_list_text_10=>unistr('\4E3B\9875\5F00\59CB')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(296033420364984683.4417)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\6D4F\89C8\5B57\4F53 APEX \56FE\6807')
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>unistr('\6D4F\89C8\5B57\4F53 APEX \56FE\6807\3001\6DFB\52A0\4FEE\9970\7B26\4EE5\53CA\590D\5236\6240\9700\7684 CSS \6216 HTML\3002')
,p_list_text_09=>'Y'
,p_list_text_10=>unistr('\56FE\6807 \5B57\4F53 apex \5E93 \56FE\5F62')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562091518091404815.4417)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562091727563404815.4417)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5BFC\51FA\5E94\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>unistr('\5C06\5E94\7528\7A0B\5E8F {APP_ID} \5BFC\51FA\4E3A SQL \6587\4EF6')
,p_list_text_09=>'Y'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562093357853428158.4417)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\672A\7528\5217\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562092153904409717.4417)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48392393581618193.4417)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\63A7\5236\53F0\65E5\5FD7')
,p_list_item_link_target=>'javascript:console.log(''hello friend'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14843831009863117.4417)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859012524941040.4417)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(86380554411225400.4417)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91997339122572414.4417)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(460407779408652225.4417)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(497671453666914719.4417)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attribute_01=>'fa-star'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082458703597614427.4417)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082517678315623391.4417)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072678475712055.4417)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831649180083980462.4417)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780276458994154.4417)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1832884277947217587.4417)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1840861033969283097.4417)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917665913120940054.4417)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1990227023531717243.4417)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626406749381989.4417)
,p_theme_id=>1
,p_name=>'One Level Tabs.zh-cn'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE# ',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626529080381989.4417)
,p_theme_id=>1
,p_name=>'Printer Friendly.zh-cn'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(91626823864381990.4417)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(91632832228382001.4417)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(91636711305382010.4417)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(91638400927382012.4417)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(91638400927382012.4417)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(91641225667382016.4417)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641730492382017.4417)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641814330382017.4417)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(91642503902382024.4417)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>unistr('\201C\641C\7D22\201D\5BF9\8BDD\6846')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>unistr('\641C\7D22')
,p_close_button_text=>unistr('\5173\95ED')
,p_next_button_text=>unistr('\4E0B\4E00\6B65 >')
,p_prev_button_text=>unistr('< \4E0A\4E00\6B65')
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>unistr('<br /><div style="padding:2px; font-size:8pt;">\884C #FIRST_ROW# - #LAST_ROW#</div>')
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91641910982382018.4417)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642102481382020.4417)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642303533382020.4417)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283631463004872067)
,p_name=>'2DCOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2D \67F1\72B6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283633700082872068)
,p_name=>'2DCOLUMN_LINE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2D \67F1\72B6\56FE\6298\7EBF\56FE')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283631613221872067)
,p_name=>'2DDOUGHNUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2D \5706\73AF\56FE')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283633534405872068)
,p_name=>'2DHSTACKED_PCT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2D \5806\53E0\6C34\5E73\67F1\72B6\56FE (\767E\5206\6BD4)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283631796734872067)
,p_name=>'2DLINE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2D \6298\7EBF\56FE')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283631890945872067)
,p_name=>'2DPIE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2D \997C\56FE')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283633395482872068)
,p_name=>'2DSTACKED_PCT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2D \5806\53E0\67F1\72B6\56FE (\767E\5206\6BD4)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283631910404872067)
,p_name=>'3DCOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('3D \67F1\72B6\56FE')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283633679515872068)
,p_name=>'3DHSTACKED_PCT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('3D \5806\53E0\6C34\5E73\67F1\72B6\56FE (\767E\5206\6BD4)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283632064602872067)
,p_name=>'3DPIE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('3D \997C\56FE')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283633415930872068)
,p_name=>'3DSTACKED_PCT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('3D \5806\53E0\67F1\72B6\56FE (\767E\5206\6BD4)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284529393427872728)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\63D2\5165\5C5E\6027\5B57\5178\4E2D\7684 0 \4E2A\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284529173162872728)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\66F4\65B0\7684 0 \4E2A\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284529583281872728)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\66F4\65B0\5C5E\6027\5B57\5178\7684 0 \4E2A\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284529979158872729)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\63D2\5165\5C5E\6027\5B57\5178\4E2D\7684 0 \4E2A\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284530146631872729)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\66F4\65B0\5C5E\6027\5B57\5178\7684 0 \4E2A\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284529063445872728)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\67E5\8981\66F4\65B0\7684 %0 \4E2A\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284529746996872729)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\66F4\65B0\7684 0 \4E2A\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284529242255872728)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\67E5\8981\63D2\5165\5C5E\6027\5B57\5178\4E2D\7684 %0 \4E2A\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284529420285872728)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\67E5\8981\66F4\65B0\5C5E\6027\5B57\5178\7684 %0 \4E2A\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284529881456872729)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\67E5\8981\63D2\5165\5C5E\6027\5B57\5178\4E2D\7684 %0 \4E2A\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284529601370872729)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\67E5\8981\66F4\65B0\7684 %0 \4E2A\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284530097227872729)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\67E5\8981\66F4\65B0\5C5E\6027\5B57\5178\7684 %0 \4E2A\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284219865162872505)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\5FC5\987B\4E3A\6570\5B57\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284204347015872494)
,p_name=>'4000_639_SEQ_MESG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<span class="fielddata">\7531\4E8E\533A\57DF\5E8F\5217\4E0D\662F\552F\4E00\7684, \65E0\6CD5\91CD\65B0\6392\5E8F\3002</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284204475706872494)
,p_name=>'4000_641_SEQ_MESG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<span class="fielddata">\7531\4E8E\6309\94AE\5E8F\5217\4E0D\662F\552F\4E00\7684, \65E0\6CD5\91CD\65B0\6392\5E8F\3002</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284204591397872494)
,p_name=>'4000_646_SEQ_MESG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<span class="fielddata">\7531\4E8E\5BFC\822A\680F\5E8F\5217\4E0D\662F\552F\4E00\7684, \65E0\6CD5\91CD\65B0\6392\5E8F\3002</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284204640778872494)
,p_name=>'4000_749_SEQ_MESG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<span class="fielddata">\7531\4E8E\533A\57DF\9879\5E8F\5217\4E0D\662F\552F\4E00\7684, \65E0\6CD5\91CD\65B0\6392\5E8F\3002</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284284253482872552)
,p_name=>'4000_APPLICATION_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283775963206872176)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\5E94\7528\7A0B\5E8F: %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284175934369872473)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6307\5B9A\7684\65E5\671F\683C\5F0F\65E0\6548\3002\65E5\5386\8981\6C42\65E5\671F\683C\5F0F\4E3A YYYYMMDD\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284225010768872509)
,p_name=>'4000_TREE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6811')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284284397710872552)
,p_name=>'4000_WORKSPACE_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A ID')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284057010916872386)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\5165\8981\521B\5EFA\7684\65B0\65B9\6848\7684\540D\79F0\3002\4F9D\6B21\9009\62E9\6B64\65B9\6848\7684\5BC6\7801, \9ED8\8BA4\8868\7A7A\95F4\548C\4E34\65F6\8868\7A7A\95F4\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284057118443872387)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\5165\73B0\6709\65B9\6848\7684\540D\79F0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284057222166872387)
,p_name=>'4050_106_WHEN_DONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B8C\6210\540E\5355\51FB "\4E0B\4E00\6B65 &gt;" \6309\94AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283950283935872308)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\8868\7A7A\95F4\548C\5173\8054\7684\6570\636E\6587\4EF6: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283950166852872308)
,p_name=>'4050_110_DROP_USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\6570\636E\5E93\7528\6237: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284862866656872968)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \670D\52A1\6D3B\52A8\65E5\5FD7\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284050405647872382)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\8005\6D3B\52A8\65E5\5FD7\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283669035919872095)
,p_name=>'4050_31_LOG_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\767B\5F55\8BBF\95EE\65E5\5FD7\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284049909122872381)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539\8BF7\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284050006449872381)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD0\884C\65F6\8BF7\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284049798779872381)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A\8BF7\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284052443559872383)
,p_name=>'4050_46_AD_HOC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL \547D\4EE4\5904\7406\5668\5386\53F2\8BB0\5F55\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284052316723872383)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63A7\5236\6587\4EF6\6267\884C\65E5\5FD7\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284052200511872383)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\811A\672C\6587\4EF6\6267\884C\65E5\5FD7\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284052525855872383)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL \6863\6848\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284054574456872385)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F52\6863\65E5\5FD7\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284054619371872385)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\65E5\5FD7\7F16\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284054742263872385)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\65E5\5FD7\65F6\95F4\6233')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284055374122872385)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8DDD\4E0B\4E00\6B21\65E5\5FD7\5207\6362\7684\65F6\95F4 (\5C0F\65F6)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284054948854872385)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\95F4\9694\5929\6570 (\5E38\91CF)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284055282215872385)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\5212\7684\4E0B\4E00\6B21\65E5\5FD7\5207\6362')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284055656632872385)
,p_name=>'4050_70_DEV_ACT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\8005\6D3B\52A8\65E5\5FD7\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284055806452872386)
,p_name=>'4050_71_CLICK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\70B9\8FDB\65E5\5FD7\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284056640554872386)
,p_name=>'4050_75_AD_HOC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL \547D\4EE4\5904\7406\5668\5386\53F2\8BB0\5F55\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284056585169872386)
,p_name=>'4050_75_CTRL_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63A7\5236\6587\4EF6\6267\884C\65E5\5FD7\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284056364450872386)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\811A\672C\6587\4EF6\6267\884C\65E5\5FD7\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284056763281872386)
,p_name=>'4050_75_SQL_ARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL \6863\6848\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284056879790872386)
,p_name=>'4050_82_WORKSPACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A %1 \62E5\6709 %2 \4E2A\5E94\7528\7A0B\5E8F\548C %3 \4E2A\7528\6237\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284056905534872386)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\70B9\51FB\8BA1\6570\65E5\5FD7\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284255055437872531)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\751F\4EA7\529B\548C\793A\4F8B\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284255147770872531)
,p_name=>'4050_PACKAGED_WEBSHEETS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\793A\4F8B Websheet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284254389352872530)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A\8BA1\6570')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283794635093872190)
,p_name=>'4150_COLUMN_NUMBER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217 %0')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283978319249872329)
,p_name=>'4350_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283978448512872329)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\5E94\7528\7A0B\5E8F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283684106183872106)
,p_name=>'4500 800 HD DBA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Oracle Database Express Edition 2 Day DBA\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283684267670872107)
,p_name=>'4500 800 HD DEV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Oracle Database Express Edition 2 Day Developer Guide\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283684084355872106)
,p_name=>'4500 800 HD HTMLDB'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Oracle Application Express 2 \5929\901F\6210\548C\5F00\53D1\8005\6307\5357\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283684306390872107)
,p_name=>'4500 800 HD JAVA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Oracle Database Express Edition 2 Day Plus Java Developer Guide\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283684445891872107)
,p_name=>'4500 800 HD NET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Oracle Database Express Edition 2 Day Plus .NET Developer Guide\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283684593997872107)
,p_name=>'4500 800 HD PHP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Oracle Database Express Edition 2 Day Plus PHP Developer\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283684616211872107)
,p_name=>'4500 800 MSG DBA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA8\8BBA\5E38\89C1\7684\65E5\5E38\7BA1\7406\4EFB\52A1\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283684758443872107)
,p_name=>'4500 800 MSG DEV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF4\660E\5982\4F55\5229\7528 Oracle Database Express Edition \5F00\53D1\73AF\5883\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283684854991872107)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\4F9B\4E00\7CFB\5217\8BF4\660E\5982\4F55\6784\5EFA\4EE5\6570\636E\5E93\4E3A\4E2D\5FC3\7684 Web \5E94\7528\7A0B\5E8F\7684\6559\7A0B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283685015670872107)
,p_name=>'4500 800 MSG JAVA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672C\6587\6863\63D0\4F9B\7684\6559\7A0B\8BF4\660E\5982\4F55\4F7F\7528 Java \548C JDB \6765\8FDE\63A5\5230 Oracle Database XE, \5E76\6F14\793A\5982\4F55\4F7F\7528\5B83\4EEC\6765\5F00\53D1\4E00\4E2A\53EF\8BBF\95EE\548C\4FEE\6539\6570\636E\7684\7B80\5355 Java \5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283685113420872107)
,p_name=>'4500 800 MSG NET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672C\6587\6863\8BF4\660E Oracle Data Provider for .NET \548C Oracle Developer Tools for Visual Studio .NET \7684\4E3B\8981\529F\80FD\3002\5B83\5C06\6307\5BFC\60A8\8FDB\884C\5B89\88C5\548C\914D\7F6E, \8BF4\660E\5982\4F55\4F7F\7528 Oracle Data Provider for .NET \548C Oracle Developer Tools for Visual Studio .NET \6784\5EFA\57FA\672C\5E94\7528\7A0B\5E8F, \4EE5\53CA\5982\4F55\521B\5EFA\548C\4F7F\7528 PL/SQL \53CA .NET \5B58\50A8\8FC7\7A0B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283684932596872107)
,p_name=>'4500 800 MSG PHP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672C\6587\6863\63D0\4F9B\7684\6559\7A0B\8BF4\660E\5982\4F55\4E0B\8F7D\548C\5B89\88C5 Apache \53CA Zend Core PHP \9A71\52A8\7A0B\5E8F, \4ECB\7ECD\5982\4F55\4F7F\7528 PHP \6765\8FDE\63A5\5230 Oracle Database XE, \5E76\6F14\793A\5982\4F55\4F7F\7528 PHP \6765\5F00\53D1\4E00\4E2A\53EF\8BBF\95EE\548C\4FEE\6539\6570\636E\7684\7B80\5355\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283654848260872084)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\522B\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283654766031872084)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283655077225872085)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284113732210872428)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283655405460872085)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FD\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283655591978872085)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\7EC4\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283654960371872084)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283655354553872085)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283655128761872085)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283655277223872085)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F\987A\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283658672742872087)
,p_name=>'4500_1002_QB_JOIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8054\63A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283652159604872082)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\51FB\6B64\5904\53EF\9009\62E9\8981\8054\63A5\7684\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283659050697872088)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\591A\53EF\4EE5\9009\62E9 60 \5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283652042290872082)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283651980110872082)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A/\9690\85CF\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283658733749872087)
,p_name=>'4500_1002_QB_TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283650374697872081)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \7684\7ED3\679C, \8FD0\884C %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283950407450872309)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD4\56DE\539F\59CB\67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283666348592872093)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\524D %0 \5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284143444337872449)
,p_name=>'4500_SESS_EVENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284143352485872449)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_language=>'zh-cn'
,p_message_text=>'KB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284143215738872449)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_language=>'zh-cn'
,p_message_text=>'MB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283688070693872109)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\6784\5EFA\5668\4F7F\7528\7528\6237\754C\9762\9ED8\8BA4\8BBE\7F6E\6765\586B\5145\533A\57DF\548C\9879\5C5E\6027\7684\521D\59CB\503C, \4EE5\4FBF\5728\4E00\4E2A\5E94\7528\7A0B\5E8F\7684\591A\4E2A\9875\6216\591A\4E2A\5E94\7528\7A0B\5E8F\4E4B\95F4\4FDD\6301\4E00\81F4\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283732497863872143)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\5E94\7528\7A0B\5E8F\8981\6C42\542F\7528 cookie\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283732361891872143)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\5E94\7528\7A0B\5E8F\8981\6C42\542F\7528 JavaScript\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283924021247872289)
,p_name=>'4800_9015_UPDATE_OVERDUE_FEATURES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \8FC7\671F\529F\80FD\5C06\66F4\65B0\5230\6240\9009\7684\65B0\91CC\7A0B\7891\3002')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284174290434872472)
,p_name=>'ABOUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\4E8E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284935041629873021)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\786E\8BA4\5C06\4EE5\4E0B %0 \4E2A\7528\6237\6DFB\52A0\5230\5DE5\4F5C\533A\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284186628390872481)
,p_name=>'ACCEPTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\63A5\53D7')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284153042452872456)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\8BBF\95EE\6027\5206\914D\4EBA\5458')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284151148202872455)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\8BBF\95EE\6027\5F71\54CD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284153583803872457)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\8BBF\95EE\6027\72B6\6001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285014105703873080)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6D4B\8BD5\53EF\8BBF\95EE\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283665154005872092)
,p_name=>'ACCESS_CONTROL_ADMIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\5458')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283824578745872213)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\6743\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283663680055872091)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236\7BA1\7406\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284102246580872419)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\5458')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284213321297872500)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\914D\7ED9\5E94\7528\7A0B\5E8F\7BA1\7406\5458\7684\89D2\8272\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283663885542872091)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283664482275872092)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283664388359872092)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\8BC6\5C06\5982\4F55\63A7\5236\5BF9\6B64\5E94\7528\7A0B\5E8F\7684\8BBF\95EE\6743\9650\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283665612772872093)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\5904\7406\201C\8BBE\7F6E\5E94\7528\7A0B\5E8F\6A21\5F0F\201D\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283665788592872093)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\6A21\5F0F\5DF2\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283825478134872213)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\4E0D\80FD\5220\9664\81EA\8EAB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283825531815872213)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\65E0\6CD5\5220\9664\81EA\5DF1\7684\7BA1\7406\5458\6743\9650\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283663765630872091)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284102122498872419)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5185\5BB9\63D0\4F9B\6743\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284102390404872419)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D21\732E\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284213408791872500)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\914D\7ED9\5E94\7528\7A0B\5E8F\8D21\732E\8005\7684\89D2\8272\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284145847562872451)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\521B\5EFA\4EE5\4E0B\5E94\7528\7A0B\5E8F\8BBE\7F6E\FF1A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284102459245872419)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\521B\5EFA\4EE5\4E0B\5E94\7528\7A0B\5E8F\8BBF\95EE\89D2\8272\FF1A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283681238124872104)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\521B\5EFA\4EE5\4E0B\6388\6743\65B9\6848\FF1A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283754943643872160)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\521B\5EFA\8BBF\95EE\63A7\5236\9875\3002%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283754841827872160)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\521B\5EFA\8BBF\95EE\63A7\5236\8868\3002%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283828014785872215)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\4E0D\80FD\8F93\5165\91CD\590D\7684\7528\6237\540D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283824604968872213)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236 - \7F16\8F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283665330429872092)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\5165\4E0D\533A\5206\5927\5C0F\5199\7684\67E5\8BE2\6807\51C6, \7136\540E\6309<b>\5F00\59CB</b>\6309\94AE\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283665433941872092)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\83B7\53D6\5E94\7528\7A0B\5E8F\7BA1\7406\6A21\5F0F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283665236483872092)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\6B21\66F4\6539\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283664718038872092)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283663928309872091)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\6240\6709\5185\5BB9\5177\6709\5B8C\5168\8BBF\95EE\6743\9650, \4E0D\4F7F\7528\8BBF\95EE\63A7\5236\5217\8868\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283664008961872091)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6709\9650\7684\8BBF\95EE\6743\9650\3002\4EC5\5141\8BB8\5728\8BBF\95EE\63A7\5236\5217\8868\4E2D\5B9A\4E49\7684\7528\6237\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283664135387872091)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EC5\9650\516C\5171\8BFB\53D6\3002\901A\8FC7\8BBF\95EE\63A7\5236\5217\8868\63A7\5236\7F16\8F91\548C\7BA1\7406\6743\9650\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283664200697872091)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EC5\9650\7BA1\7406\8BBF\95EE\6743\9650\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283665557578872092)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\6267\884C\6240\5C1D\8BD5\64CD\4F5C\7684\6743\9650\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283665030696872092)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6743\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284145707028872451)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BFB\8005\6743\5229')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284145631863872451)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BFB\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284213510336872500)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\914D\7ED9\5E94\7528\7A0B\5E8F\8BFB\8005\7684\89D2\8272\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283682025656872105)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\8BC6\4E0E\6B64\5E94\7528\7A0B\5E8F\9A8C\8BC1\65B9\6848\5BF9\5E94\7684\7528\6237\540D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283664556347872092)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\5E94\7528\7A0B\5E8F\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283783089956872181)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6210\529F\521B\5EFA\8BBF\95EE\63A7\5236\9875\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283664937549872092)
,p_name=>'ACCESS_CONTROL_USERNAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284102597592872420)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\73B0\6709\8BBF\95EE\63A7\5236\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283681948275872105)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\73B0\6709\6388\6743\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283681143536872104)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\73B0\6709\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283824782851872213)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236 - \67E5\770B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284114457965872428)
,p_name=>'ACCESS_DENIED_SIMPLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62D2\7EDD\8BBF\95EE')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283685427944872107)
,p_name=>'ACCOUNT_CREATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E10\6237\5DF2\521B\5EFA\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283808370929872200)
,p_name=>'ACCOUNT_HAS_BEEN_CREATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\521B\5EFA\60A8\7684 %0 \5E10\6237\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283682864233872105)
,p_name=>'ACCOUNT_LOCKED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E10\6237\5DF2\9501\5B9A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284475487213872692)
,p_name=>'ACCOUNT_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E10\6237\83DC\5355')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284132941521872442)
,p_name=>'ACKNOWLEDGED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\786E\8BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284133161927872442)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\786E\8BA4, \65E0\64CD\4F5C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284197014878872488)
,p_name=>'ACL_ADD_USER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284865697359872970)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\9762\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284865793230872970)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\76D1\89C6\6D3B\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284864836604872969)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0/\4FEE\6539')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284865506667872970)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD0\884C\5E94\7528\7A0B\5E8F\65F6\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284864075092872969)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\5E94\7528\7A0B\5E8F\6784\5EFA\5668\5185\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284864793364872969)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CE8\89E3 (\6587\4EF6, \6807\8BB0, \6CE8\91CA)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284863758113872969)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5E26\8BBF\95EE\63A7\5236\5217\8868\7684 Application Express \5E10\6237\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284863654513872969)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E26\8BBF\95EE\63A7\5236\5217\8868\7684\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284864472265872969)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91 SQL \8BBF\95EE\548C\5EFA\8BAE\7684\5BF9\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284868770606872972)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\7ECF\8FC7\5E94\7528\7A0B\5E8F\7684\9A8C\8BC1\540E, \8BBF\95EE\63A7\5236\5C06\6307\5B9A\7528\6237\53EF\5728\8BE5\5E94\7528\7A0B\5E8F\4E2D\6267\884C\54EA\4E9B\64CD\4F5C\3002\4E0B\8868\6839\636E\6B64\5E94\7528\7A0B\5E8F\4E2D\6B63\5728\4F7F\7528\7684\9A8C\8BC1\6765\6807\8BC6\4E0D\540C\7C7B\578B\7684\7528\6237\5C06\5177\6709\54EA\4E9B\529F\80FD\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284865877833872970)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EF4\62A4\8BBF\95EE\63A7\5236\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284864537412872969)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD0\884C\548C\67E5\770B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284864232723872969)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\65B0\5E94\7528\7A0B\5E8F\5C5E\6027')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284523988472872725)
,p_name=>'ACTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284863160992872968)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\64CD\4F5C\201D\83DC\5355\8BBE\7F6E')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283696517537872116)
,p_name=>'ACTIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D3B\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284110025906872425)
,p_name=>'ACTIVITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D3B\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284154557967872457)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6D3B\52A8\6982\8981'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284390038861872630)
,p_name=>'ADDED_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284860621755872966)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6DFB\52A0\5230\6E05\9664\5217\8868')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284509626825872715)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\6C42\9644\52A0\4FE1\606F')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284064265738872392)
,p_name=>'ADD_ARGUEMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\53C2\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284054301220872384)
,p_name=>'ADD_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284270522110872542)
,p_name=>'ADD_COLUMN_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\5217 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283912385148872280)
,p_name=>'ADD_CONSTRAINT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\7EA6\675F\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284052135552872383)
,p_name=>'ADD_MORE...'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\66F4\591A...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284124931611872436)
,p_name=>'ADD_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284278041572872548)
,p_name=>'ADD_USER_INTERFACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\7528\6237\754C\9762')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284281610968872550)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309 %0 MB \8C03\6574\9884\914D\7A7A\95F4')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284050629195872382)
,p_name=>'ADMIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\5458')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283676857723872101)
,p_name=>'ADMINISTRATOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A\7BA1\7406\5458')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284154354597872457)
,p_name=>'ADMINISTRATORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\5458')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284057941272872387)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\63D0\4F9B\7BA1\7406\5458\7535\5B50\90AE\4EF6')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284222093283872507)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\8BBF\95EE\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283712450337872128)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283712756221872128)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6027\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283712868041872128)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D28\91CF\4FDD\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283712544385872128)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B89\5168\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283712962053872128)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\7528\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283712670582872128)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8B66\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284355312467872604)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879 "%1" \662F\53D7\4FDD\62A4\7684, \65E0\6CD5\901A\8FC7 Ajax \8C03\7528\8FDB\884C\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284355404248872604)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879 "%1" \662F\53D7\4FDD\62A4\7684, \65E0\6CD5\901A\8FC7 Ajax \8C03\7528\8FDB\884C\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284387309617872628)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879 "%1" \662F\53D7\4FDD\62A4\7684, \65E0\6CD5\901A\8FC7 Ajax \8C03\7528\8FDB\884C\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283743211816872151)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F3A\5C11 SYS \65B9\6848\524D\7F00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284565249592872753)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('WWV_FLOW API \4F7F\7528\60C5\51B5 (\6539\7528 APEX API)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284505308453872712)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF\6E90 SQL \8BED\53E5\4E2D\4E0D\5B58\5728\5217 %0!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283722709709872135)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EA4\4E92\5F0F\62A5\8868\5217%0\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283720467102872134)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283688840685872110)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF\6E90 SQL \8BED\53E5\4E2D\4E0D\5B58\5728\5217 %0!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284599881154872777)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\683C\5F0F\8868\5355\5217%0\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283720568425872134)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\4E0D\80FD\4F5C\4E3A\5E94\7528\7A0B\5E8F\6216\9875\9879\540D\79F0\8FDB\884C\5F15\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284941031094873026)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('AJAX \56DE\8C03\5E94\7528\7A0B\5E8F\5904\7406\4E0D\53D7\6388\6743\65B9\6848\4FDD\62A4\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284940649436873026)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\4E0D\53D7\6388\6743\65B9\6848\4FDD\62A4\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283721408127872134)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\76EE\6807\9875%1 (\5728\5E94\7528\7A0B\5E8F%0\4E2D) \672A\5B9A\4E49\6388\6743\65B9\6848\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284942769521873027)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\9875\7684\6388\6743\4E0D\540C\4E8E\7236\9875 %0 \7684\6388\6743 "%1"\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283721500063872135)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\76EE\6807\9875\4E0A\7684\6388\6743 "%0" \4E0D\540C\4E8E "%1"\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283720010222872133)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283719978615872133)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\6267\884C\7ED1\5B9A\53D8\91CF\8BED\6CD5\68C0\67E5\3002\9519\8BEF: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283720102860872134)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\80FD\4F7F\7528\7ED1\5B9A\53D8\91CF\8BED\6CD5\5F15\7528%0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283722173554872135)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5176\4ED6\5206\652F\524D\7684\65E0\6761\4EF6\5206\652F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284940403789873025)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\4E8E\5305\542B\5BC6\7801\9879\7684\9875, \8BF7\5C06\201C\81EA\52A8\5B8C\6210\201D\8BBE\7F6E\4E3A "\6253\5F00"\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284940533439873025)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('"\9AD8\901F\7F13\5B58" \5141\8BB8\6D4F\89C8\5668\9AD8\901F\7F13\5B58\654F\611F\6570\636E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284825454470872941)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('"\5D4C\5165\5230\6846\67B6\4E2D" \4F1A\4F7F\5E94\7528\7A0B\5E8F\6613\906D\5230\70B9\51FB\52AB\6301\7684\653B\51FB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284825530659872941)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('"HTML \8F6C\4E49\6A21\5F0F" \53EA\5BF9\4E00\7EC4\6709\9650\7684\5B57\7B26\8FDB\884C\8F6C\4E49\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283646627594872078)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5BF9\4E8E\5728\52A8\6001\64CD\4F5C (%0) \4E2D\5F15\7528\7684\6309\94AE, \5728\6309\94AE\5C5E\6027\4E2D\53D1\73B0 ID\3002'),
'',
unistr('\5982\679C\5728\6309\94AE\5C5E\6027\4E2D\5B9A\4E49\4E86\67D0\4E2A ID, \5C06\5BFC\81F4\5F15\7528\8BE5\6309\94AE\7684\52A8\6001\64CD\4F5C\4E0D\8D77\4F5C\7528\3002\8BF7\8003\8651\5220\9664\6B64 ID, \56E0\4E3A\9ED8\8BA4\60C5\51B5\4E0B, \6309\94AE\5C06\751F\6210 ID\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283646786245872078)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6309\94AE\6A21\677F\7531\8FD9\6837\7684\6309\94AE\4F7F\7528: \8BE5\6309\94AE\672C\8EAB\5728\672A\5305\542B #BUTTON_ID# \66FF\6362\5B57\7B26\4E32\7684\52A8\6001\64CD\4F5C (%0) \4E2D\5F15\7528\3002'),
'',
unistr('\6A21\677F:'),
'%1',
'',
unistr('\8BF7\8003\8651\5411\6B64\6A21\677F\6DFB\52A0 #BUTTON_ID# \66FF\6362\5B57\7B26\4E32, \6216\8005\5C06\8BE5\6309\94AE\6A21\677F\66F4\6539\4E3A\5305\542B #BUTTON_ID# \66FF\6362\5B57\7B26\4E32\7684\6309\94AE\6A21\677F\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283649375403872080)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\4E8E\5728\52A8\6001\64CD\4F5C (%0) \4E2D\5F15\7528\7684\6309\94AE, \6309\94AE ''\64CD\4F5C'' \4E0D\662F ''\7531\52A8\6001\64CD\4F5C\5B9A\4E49''\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283656017630872085)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE (%0) \7684 ''\64CD\4F5C'' \4E3A ''\7531\52A8\6001\64CD\4F5C\5B9A\4E49'', \4F46\4E0D\5B58\5728\5F15\7528\6B64\6309\94AE\7684\76F8\5E94\52A8\6001\64CD\4F5C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284223572579872508)
,p_name=>'ADVISOR.CHECK.CHART_TYPE_IS_ACCESSIBLE.MSG_ANYCHART_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD9\662F\8F83\65E9\7684 AnyChart \56FE\8868\7C7B\578B\3002\60A8\5E94\4F7F\7528 ''\5E94\7528\7A0B\5E8F\5347\7EA7'' \8BBE\5907\5C06\6B64\56FE\8868\8FC1\79FB\4E3A\4F7F\7528\57FA\4E8E Oracle JET \7684\65B0\56FE\8868, \4EE5\5927\5E45\6539\5584\53EF\7528\6027\548C\53EF\8BBF\95EE\6027\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283721102571872134)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664\9AD8\901F\7F13\5B58\9875%0\4E0D\662F\5F53\524D\9875\6216\76EE\6807\9875%1\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283719848295872133)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284912685138873005)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\5C5E\6027\503C\5DF2\8FC7\65F6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284914191931873006)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\7EC4\4EF6\7C7B\578B\5DF2\8FC7\65F6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284355529194872604)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Ajax \8C03\7528\4E2D\7684\53D7\4FDD\62A4\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283743117626872151)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EE3\7801\5F02\5473 (APEX \5185\90E8)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283717989481872132)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\9879, \9875\9879, \5217\6216\4EA4\4E92\5F0F\62A5\8868\8FC7\6EE4\5668\7684\58F0\660E\6027\5F15\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284940374243873025)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6388\6743')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283717686029872132)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\7ED1\5B9A\53D8\91CF\8BED\6CD5\7684\5F15\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283719002315872133)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5176\4ED6\5206\652F\524D\7684\65E0\6761\4EF6\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284940875215873026)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D4F\89C8\5668\5B89\5168\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283646538079872078)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE\4E0E\52A8\6001\64CD\4F5C\4E0D\517C\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283655819285872085)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A8\6001\64CD\4F5C\548C\6309\94AE\4E4B\95F4\7684\5F15\7528\4E0D\4E00\81F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284223353725872508)
,p_name=>'ADVISOR.CHECK.DESC_CHART_TYPE_IS_ACCESSIBLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\7C7B\578B\652F\6301\53EF\8BBF\95EE\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283718297098872132)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664\7B49\4E8E\76EE\6807\6216\5F53\524D\9875\7684\9AD8\901F\7F13\5B58\9875\7684\9875\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283717578270872132)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\5217\8BED\6CD5\7684\5F15\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284912581327873005)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\65F6\7684\5C5E\6027\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283718530941872132)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\53D6, DML, MR* \5904\7406\6709\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283718929252872133)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\786C\7F16\7801\7684\5E94\7528\7A0B\5E8F ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284129587225872439)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\9879\5177\6709\5E2E\52A9\6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284221806335872507)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\6709\9875\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284247901162872525)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\5B9A\4E49\4E86\56FE\50CF\66FF\4EE3\6587\672C\7684\56FE\50CF\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284825210095872941)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\4EE5\9501\5B9A\7684\5E94\7528\7A0B\5E8F\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283717766956872132)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\88AB\5F15\7528\9879\4F4D\4E8E\5F53\524D\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283717803979872132)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\88AB\5F15\7528\9879\662F\76EE\6807\9875\7684\9875\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284222581660872507)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\9879\672A\5BFC\81F4\610F\5916\7684\4E0A\4E0B\6587\66F4\6539')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284223792234872508)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\9879\5177\6709\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283719200406872133)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879\6216\8868\683C\5F0F\8868\5355\5217\540D\7684\957F\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283718081746872132)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B57\7B26\4E32\4E2D\7684\9875\9879\5F15\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283718158671872132)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\88AB\5F15\7528\9875\7684\9875\7801\5DF2\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284222186696872507)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF\5177\6709\884C\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283719497192872133)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\5177\6709\9ED8\8BA4\987A\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284940954936873026)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F1A\8BDD\72B6\6001\4FDD\62A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283718695309872132)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66FF\6362\8BED\6CD5\4F7F\7528\4E0D\5F53')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283717478766872131)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\66FF\6362\8BED\6CD5\7684\5F15\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283718401518872132)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD8\5C06\4E3A\5F53\524D\7EC4\4EF6\8BBE\7F6E\76EE\6807\9875\6388\6743')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284222360396872507)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D4B\8BD5\4E86\4E3B\9898\6837\5F0F\7684\53EF\8BBF\95EE\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284344243573872596)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\754C\9762\5305\542B\517C\5BB9\6027 JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283719166158872133)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1\7684\76F8\5173\9879\6216\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283718387100872132)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\6709\6548 SQL \6216 PL/SQL \4EE3\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283718837235872133)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1 Clob \5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283718737956872132)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 SQL \8BED\53E5\4E2D\4F7F\7528\7684 V \51FD\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283719362897872133)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\5728\6309\4E0B\6309\94AE\65F6\201D\4E2D\5F15\7528\6309\94AE\5DF2\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283721769599872135)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8BD1\9519\8BEF - %0\8BED\53E5: %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283722092428872135)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\94FE\63A5\5305\542B\786C\7F16\7801\503C\5F62\5F0F\7684\5F53\524D\5E94\7528\7A0B\5E8F ID\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284129456757872439)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5B9A\4E49\5E2E\52A9\6587\672C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284221933103872507)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\9875\6CA1\6709\9875\6807\9898\3002\6709\610F\4E49\7684\9875\6807\9898\5BF9\4E8E\53EF\8BBF\95EE\6027\975E\5E38\91CD\8981, \8FD9\53EF\5E2E\52A9\7528\6237\4E86\89E3\5F53\524D\9875\7684\5185\5BB9\548C\7528\9014\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284248079556872526)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\9879\7F3A\5C11\56FE\50CF\6240\9700\7684\66FF\4EE3\6587\672C\3002\7528\4E8E\6B64\7528\9014\7684\826F\597D\6587\672C\5E94\8BE5\5145\5206\63CF\8FF0\4E86\56FE\50CF\7684\5185\5BB9, \540C\65F6\4E0D\5E94\91CD\590D\5728\56FE\50CF\4E0A\4E0B\6587\7684\9875\4E2D\53EF\89C1\7684\4EFB\4F55\4FE1\606F (\4EE5\907F\514D\53EF\80FD\7684\91CD\590D)\3002\6CE8: \5982\679C\56FE\50CF\7531\7528\6237\63D0\4F9B, \5219\56FE\50CF\66FF\4EE3\6587\672C\4E5F\5E94\7531\7528\6237\63D0\4F9B, \8BF7\63D0\4F9B\5408\9002\7684\6307\5357\4EE5\5E2E\52A9\7528\6237\63D0\4F9B\9AD8\8D28\91CF\6587\672C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284825336586872941)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('"\8FD0\884C\65F6 API \4F7F\7528\60C5\51B5" \5141\8BB8\4FEE\6539\5E94\7528\7A0B\5E8F\548C\5DE5\4F5C\533A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283720244348872134)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\4E0D\662F\9875%1\4E0A\7684\9879\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283720374223872134)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\4E0D\662F\76EE\6807\9875%1\4E0A\7684\9879\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284222626222872507)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\9879\7684 ''\9009\5B9A\5185\5BB9\7684\9875\64CD\4F5C'' \8BBE\7F6E\4F1A\5BFC\81F4\610F\5916\66F4\6539\7528\6237\7684\4E0A\4E0B\6587\3002\8BF7\8003\8651\5207\6362\4E3A ''\65E0'', \8FD9\6837\5C31\6CA1\6709\4E0A\4E0B\6587\66F4\6539\5E76\4F7F\7528\52A8\6001\64CD\4F5C\6216\7EA7\8054 LOV (\9700\8981\505C\7559\5728\76F8\540C\9875\65F6) \66FF\6362\529F\80FD\3002\6B64\5916, \8BF7\8003\8651\4E3A\7528\6237\63D0\4F9B\4E00\4E9B\4FE1\606F, \8FD9\6837\7528\6237\53EF\4EE5\77E5\9053\5C06\53D1\751F\4EC0\4E48\64CD\4F5C, \4F8B\5982, \5728\6807\7B7E\4E2D\6DFB\52A0 ''\542F\52A8\65B0\9875''\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284247862206872525)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\5B9A\4E49\9879\7684\6807\7B7E\3002\5982\679C\504F\597D\4E0D\663E\793A\53EF\89C1\7684\6807\7B7E, \60A8\4ECD\5E94\5B9A\4E49\6807\7B7E, \7136\540E\9009\62E9 ''\9690\85CF'' \6807\7B7E\6A21\677F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284223881967872508)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879\5B9A\4E49\4E86 ''\503C\5360\4F4D\7B26'' \503C, \800C\4E0D\662F\6807\7B7E\3002\5360\4F4D\7B26\6587\672C\4E0D\5E94\5355\7EAF\7528\4E8E\6807\8BB0\9879, \56E0\4E3A\8FD9\4F1A\5BFC\81F4\53EF\8BBF\95EE\6027\95EE\9898\3002\4E3A\4E86\5B9E\73B0\66F4\597D\7684\53EF\8BBF\95EE\6027, \5E94\8BE5\5B9A\4E49\9879\6807\7B7E\3002\5982\679C\504F\597D\4E0D\663E\793A\53EF\89C1\7684\6807\7B7E, \60A8\4ECD\5E94\5B9A\4E49\6807\7B7E, \7136\540E\9009\62E9 ''\9690\85CF'' \6807\7B7E\6A21\677F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283722428670872135)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\540D\79F0\7684\957F\5EA6\4E3A %0 \4E2A\5B57\7B26, \4F46\6700\5927\957F\5EA6\5E94\4E3A 30 \4E2A\5B57\7B26\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283720600402872134)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\53EF\80FD\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283720766038872134)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\53EF\80FD\4E0D\662F\9875\6216\5E94\7528\7A0B\5E8F\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283721061464872134)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664\9AD8\901F\7F13\5B58\9875%1 (\5728\5E94\7528\7A0B\5E8F%0\4E2D) \4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283720877531872134)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875%0\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283720997951872134)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\76EE\6807\9875%1 (\5728\5E94\7528\7A0B\5E8F%0\4E2D) \4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284145988713872451)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\5217\5207\6362\533A\57DF\6CA1\6709\5C06\201C\7528\4F5C\884C\6807\9898\201D\5C5E\6027\8BBE\7F6E\4E3A\201C\662F\201D\7684\5217\3002\884C\6807\9898\5217\5E94\8BE5\662F\80FD\591F\6700\597D\5730\786E\5B9A\5F53\524D\884C\7684\5217\FF08\4F8B\5982\FF0C\5BA2\6237\4FE1\606F\62A5\8868\4E2D\7684\5BA2\6237\540D\79F0\FF09\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284146054847872451)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\91CD\6392\533A\57DF\6CA1\6709\5C06\201C\7528\4F5C\884C\6807\9898\201D\5C5E\6027\8BBE\7F6E\4E3A\201C\662F\201D\7684\5217\3002\884C\6807\9898\5217\5E94\8BE5\662F\80FD\591F\6700\597D\5730\786E\5B9A\5F53\524D\884C\7684\5217\FF08\4F8B\5982\FF0C\5BA2\6237\4FE1\606F\62A5\8868\4E2D\7684\5BA2\6237\540D\79F0\FF09\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284222236816872507)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\8868\683C\5F0F\8868\5355\533A\57DF\6CA1\6709\5C06 "\7528\4F5C\884C\6807\9898" \5C5E\6027\8BBE\7F6E\4E3A\201C\662F\201D\7684\5217\3002\884C\6807\9898\5217\5E94\8BE5\662F\80FD\591F\6700\597D\5730\786E\5B9A\5F53\524D\884C\7684\5217 (\4F8B\5982, \5BA2\6237\4FE1\606F\8868\4E2D\7684\5BA2\6237\540D\79F0)\3002\7136\540E, \6B64\4FE1\606F\5728\5448\73B0\8868\683C\5F0F\8868\8FBE\65F6\4F7F\7528, \7528\4E8E\4E3A\6BCF\884C\7684\8868\5355\5B57\6BB5\63D0\4F9B\552F\4E00\6807\7B7E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283722617378872135)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\6CA1\6709\9ED8\8BA4\987A\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284825639818872941)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('"\4E66\7B7E\6563\5217\51FD\6570" \8BBE\7F6E\4E3A\65E7\7B97\6CD5\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284825792192872941)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('"\4F1A\8BDD\72B6\6001\4FDD\62A4" \5DF2\7981\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284940789864873026)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\5E26\6709\63D0\53D6\5904\7406\7684\9875\4E0A, \5E94\4F7F\7528\201C\9875\8BBF\95EE\4FDD\62A4\201D\5E76\5BF9\60A8\901A\8FC7 URL \4F20\9012\7684\9879\542F\7528\4FDD\62A4\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283679315182872103)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF\5305\542B\672A\901A\8FC7 APEX_UTIL.PREPARE_URL \4F20\9012\7684 "f?p" URL\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283721859607872135)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\68C0\6D4B\5230\53EF\80FD\7684 SQL \6CE8\5165\3002\5C06\5728 SQL, PL/SQL \4EE3\7801\6216\5904\7406\8868\540D\4E2D\901A\8FC7\66FF\6362\8BED\6CD5\4F7F\7528%0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283719619843872133)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283719731739872133)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\80FD\4F7F\7528\66FF\6362\8BED\6CD5\5F15\7528%0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283721677834872135)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\76EE\6807\9875%1 (\5728\5E94\7528\7A0B\5E8F%0\4E2D) \5B9A\4E49\4E86\6388\6743\65B9\6848, \4F46\5F53\524D\7EC4\4EF6\672A\5B9A\4E49\6388\6743\65B9\6848\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284222480770872507)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\5F53\524D\7684\4E3B\9898\6837\5F0F\672A\7ECF\8FC7\53EF\8BBF\95EE\6027\6D4B\8BD5\3002\8BF7\5207\6362\5230\5C06\201C\5DF2\6D4B\8BD5\53EF\8BBF\95EE\6027\201D\8BBE\7F6E\4E3A\201C\662F\201D\7684\4E3B\9898\6837\5F0F, \6216\8005, \5982\679C\60A8\5F53\524D\7684\4E3B\9898\6837\5F0F\5DF2\7ECF\8FC7\6D4B\8BD5, \8BF7\5728\201C\4E3B\9898\6D4B\8BD5\201D\4E0B\5C06\5176\201C\5DF2\6D4B\8BD5\53EF\8BBF\95EE\6027\201D\5C5E\6027\8BBE\7F6E\4E3A\201C\662F\201D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284344494828872596)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7528\6237\754C\9762\5305\542B jQuery \8FC1\79FB\3002jQuery \8FC1\79FB\5728\8FC1\79FB\5230\8F83\65B0\7248\672C\7684 jQuery \65F6, \53EF\6062\590D\5220\9664\7684 API \4EE5\53CA\5728\4F7F\7528\4E86\5DF2\5220\9664\6216\5DF2\8FC7\65F6\7684 API \65F6\5728\6D4F\89C8\5668\63A7\5236\53F0\4E2D\663E\793A\8B66\544A, \4ECE\800C\63D0\4F9B\5E2E\52A9\3002\8FD9\4F1A\5728\5E94\7528\7A0B\5E8F\4E2D\6BCF\9875\4E0A\5305\62EC\989D\5916\7684 JavaScript \6587\4EF6\3002\4E3A\5E2E\52A9\6D88\9664\8FD9\4E9B\5185\5BB9, \8BF7\67E5\770B jQuery \8FC1\79FB\5347\7EA7\6307\5357, \4E86\89E3\5E94\8BE5\66F4\6539\54EA\4E9B API \7684\8BE6\7EC6\4FE1\606F, \7136\540E\5728\786E\4FE1\4E0D\518D\4F9D\8D56\4E8E\4EFB\4F55\8FD9\4E9B API \65F6, \5C06\201C\5305\542B jQuery \8FC1\79FB\201D\8BBE\7F6E\4E3A\201C\5426\201D\3002'),
'',
'https://github.com/jquery/jquery-migrate'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284344378089872596)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\754C\9762\5305\62EC\5DF2\8FC7\65F6\6216\5DF2\53D6\6D88\652F\6301\7684 JavaScript \51FD\6570\3002\8FD9\4F1A\5728\5E94\7528\7A0B\5E8F\7684\6BCF\9875\4E0A\5305\542B\989D\5916\7684 JavaScript \6587\4EF6\3002\4E3A\5E2E\52A9\6D88\9664\8FD9\4E9B\5185\5BB9, \8BF7\68C0\67E5\53D1\884C\8BF4\660E\4E2D ''\5DF2\8FC7\65F6\529F\80FD'' \90E8\5206, \5728\5176\4E2D\53EF\4EE5\627E\5230\6709\5173\5982\4F55\68C0\67E5\4E0E\5DF2\8FC7\65F6\6216\5DF2\53D6\6D88\652F\6301\51FD\6570\7684\76F8\5173\6027\7684\8BF4\660E, \7136\540E\8FDB\884C\5904\7406\4EE5\4E0D\5728\5E94\7528\7A0B\5E8F\4E2D\5305\62EC\8FD9\4E9B\5185\5BB9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283722368810872135)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5B9A\4E49\76F8\5173\9879\6216\5217, \4F46 "\9519\8BEF\6D88\606F\663E\793A\4F4D\7F6E" \9700\8981\5B83\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283722255225872135)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\76F8\5173\9879\6216\5217\4E0D\7B49\4E8E\9A8C\8BC1\8868\8FBE\5F0F 1 \4E2D\6307\5B9A\7684 "%0"\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283721208598872134)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8BD1\9519\8BEF - %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283721371020872134)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5B9A\4E49 SQL \6216 PL/SQL \4EE3\7801\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283719544168872133)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D85\8FC7 32767 \4E2A\3002\53EA\68C0\67E5\524D 32767 \4E2A\3002\957F\5EA6: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283721911374872135)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 SQL \8BED\53E5\4E2D\5305\542B V/NV/DV \51FD\6570\8C03\7528 (\53EF\80FD\5B58\5728\6027\80FD\95EE\9898)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283722519474872135)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F15\7528\7684\6309\94AE\4E0D\518D\5B58\5728\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284116098590872429)
,p_name=>'AFTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E4B\540E')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284057374669872387)
,p_name=>'AGREEMENT_MISSING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F3A\5C11\534F\8BAE')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283862257429872242)
,p_name=>'ALIAS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\522B\540D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284568414454872755)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\5E94\7528\7A0B\5E8F\6784\5EFA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284485281997872698)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5141\8BB8\5B89\88C5\751F\4EA7\529B\548C\793A\4F8B\5E94\7528\7A0B\5E8F\3002'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284320515130872579)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\4F7F\7528 RESTful \670D\52A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284568564214872755)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\4F7F\7528 SQL \5DE5\4F5C\5BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284568759592872755)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\4F7F\7528\5C0F\7EC4\5F00\53D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284568391137872755)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\6E05\9664\5DE5\4F5C\533A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284568673178872755)
,p_name=>'ALLOW_WEBSHEET_DEV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8 Websheet \5F00\53D1')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283881523442872256)
,p_name=>'ALL_APPLICATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283667395627872094)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \5168\90E8 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283667129591872094)
,p_name=>'ALL_CATEGORIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\7C7B\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283667488831872094)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \6240\6709\7C7B\522B -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284571428446872757)
,p_name=>'ALL_MILESTONES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284249474782872527)
,p_name=>'ALL_RELEASES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\53D1\884C\7248')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283887475560872261)
,p_name=>'ALL_STATIC_FILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\9759\6001\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283886090017872260)
,p_name=>'ALL_THEMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\4E3B\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284593134576872772)
,p_name=>'ALL_TYPES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284593567586872772)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \6240\6709\7C7B\578B -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283882671389872257)
,p_name=>'ALL_USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\7528\6237')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284935203994873022)
,p_name=>'ALREADY_IN_ACL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\5DF2\5177\6709 APEX \5E10\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284925134480873014)
,p_name=>'ALREADY_IN_WS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A\4E2D\5DF2\5B58\5728\7528\6237')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284885874744872985)
,p_name=>'ALWAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\59CB\7EC8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283638800290872072)
,p_name=>'AM_PM'
,p_message_language=>'zh-cn'
,p_message_text=>'AM / PM'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284132789583872442)
,p_name=>'ANALYSIS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5206\6790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284132875252872442)
,p_name=>'ANALYZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309 %0 \8FDB\884C\5206\6790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284271788548872543)
,p_name=>'ANALYZE_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528 %0 \65B9\6CD5\5206\6790')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283740426822872149)
,p_name=>'ANCHOR.SHOW_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\663E\793A')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283884982016872259)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533F\540D\5757')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283727302763872139)
,p_name=>'ANSWERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B54\6848')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283679078923872103)
,p_name=>'ANY_DEVELOPER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('(\4EFB\4F55\5F00\53D1\8005)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284900922385872996)
,p_name=>'APEX.ACTIONS.TOGGLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5207\6362 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284940134523873025)
,p_name=>'APEX.ACTIVE_STATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('(\6D3B\52A8)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285003704131873072)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\66F4\6539:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285003612504873072)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C0F\65F6:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285008432266873075)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_language=>'zh-cn'
,p_message_text=>'%0 K'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285003839230873072)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\8BBF\95EE\91CF\FF1A ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284525847323872726)
,p_name=>'APEX.AJAX_SERVER_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Ajax \8C03\7528\4E3A%1\8FD4\56DE\4E86\670D\52A1\5668\9519\8BEF%0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284823201832872939)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5DF2\7981\6B62 API \8C03\7528\3002'),
unistr('\8BF7\4E0E\7BA1\7406\5458\8054\7CFB\3002'),
unistr('\901A\8FC7\8C03\8BD5 ID "%0" \63D0\4F9B\6709\5173\6B64\610F\5916\4E8B\4EF6\7684\8BE6\7EC6\4FE1\606F\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283929929069872293)
,p_name=>'APEX.APPLICATION.ALIAS.NON_UNIQUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\522B\540D "%0" \65E0\6CD5\8F6C\6362\4E3A\552F\4E00\7684\5E94\7528\7A0B\5E8F ID\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283930063599872293)
,p_name=>'APEX.APPLICATION.ALIAS.NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\522B\540D\4E3A "%0" \7684\5E94\7528\7A0B\5E8F\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283887676187872261)
,p_name=>'APEX.APPLICATION.ALIAS.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('ERR-1816 \8F6C\6362\5E94\7528\7A0B\5E8F\522B\540D p_flow_alias_or_id (%0) \65F6\51FA\73B0\610F\5916\9519\8BEF\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283756495049872161)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Application Express \7248\672C %1 \4E2D\5DF2\53D6\6D88\652F\6301 API \8C03\7528 "%0"\3002\901A\8FC7\8C03\8BD5 ID "%2" \63D0\4F9B\6709\5173\6B64\610F\5916\4E8B\4EF6\7684\8BE6\7EC6\4FE1\606F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283763142547872166)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNC.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\9A8C\8BC1\51FD\6570\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283650715508872081)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\9A8C\8BC1\51FD\6570\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285018585339873083)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.HOST_PREFIX_MISMATCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Oracle Cloud Identity Management \8FD4\56DE\7684\79DF\6237\540D\79F0 %0 \672A\7ECF\8FC7\57DF %1 \7684\6388\6743!<br/>\8BF7<a href="&LOGOUT_URL.">\91CD\65B0\767B\5F55</a>\5E76\6307\5B9A\5DF2\6388\6743\7684\79DF\6237\540D\79F0\6216\8005\66F4\6539 URL\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283643830728872076)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.USER_IS_NOT_DEVELOPER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E10\6237 "%0" \6CA1\6709\5DE5\4F5C\533A "%1" \7684\5FC5\9700\5F00\53D1\6743\9650 (DB_DEVELOPER \6216 DB_ADMINISTRATOR)! <br/>\8BF7\5728\63D0\4F9B\6743\9650\4E4B\540E<a href="&LOGOUT_URL.">\91CD\65B0\767B\5F55</a>\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283639278967872073)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.WRONG_GROUP_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Oracle Cloud Identity Management \8FD4\56DE\7684\79DF\6237\540D\79F0\672A\7ECF\8FC7\5F53\524D\5DE5\4F5C\533A\7684\6388\6743!<br/> \8BF7<a href="&LOGOUT_URL.">\91CD\65B0\767B\5F55</a>\5E76\6307\5B9A\5DF2\6388\6743\7684\79DF\6237\540D\79F0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283777499173872177)
,p_name=>'APEX.AUTHENTICATION.HEADER.DUPLICATE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('HTTP \6807\5934 %0 \88AB\53D1\9001\4E86\4E24\6B21\FF0C\8FD9\53EF\80FD\662F\4E00\4E2A\653B\51FB\3002'),
'<ul>',
unistr('<li>\7B2C 1 \4E2A\503C\FF1A"%1"</li>'),
unistr('<li>\7B2C 2 \4E2A\503C\FF1A"%2"</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283644028949872076)
,p_name=>'APEX.AUTHENTICATION.HOST_PREFIX_MISMATCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FA\4E8E\5B89\5168\8003\8651, \4E0D\5141\8BB8\901A\8FC7 URL \4E2D\7684\57DF\8FD0\884C\6B64\5DE5\4F5C\533A\7684\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283762873905872166)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.ASK_FOR_INSTALLATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\8981\6C42\60A8\7684 DBA \8FD0\884C $OH/rdbms/admin/catldap.sql\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283762782377872166)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.MISSING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SYS.DBMS_LDAP \5305\4E0D\5B58\5728\6216\65E0\6548\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283762689835872166)
,p_name=>'APEX.AUTHENTICATION.LDAP.EDIT_USER_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\7F16\8F91 LDAP \7528\6237\529F\80FD\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283762945180872166)
,p_name=>'APEX.AUTHENTICATION.LDAP.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406 LDAP \9A8C\8BC1\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283764168646872167)
,p_name=>'APEX.AUTHENTICATION.LOGIN.ILLEGAL_PAGE_ARG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('login_page \8FC7\7A0B\7684 p_flow_page \53C2\6570\4E2D\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283763626652872166)
,p_name=>'APEX.AUTHENTICATION.LOGIN.INVALID_ARG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('wwv_flow_custom_auth_std.login \4E2D\7684 p_session \65E0\6548 -- p_flow_page:%0 p_session_id:%1\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283763473202872166)
,p_name=>'APEX.AUTHENTICATION.LOGIN.MALFORMED_ARGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('wwv_flow_custom_auth_std.login \7684\53C2\6570\683C\5F0F\4E0D\6B63\786E -- p_flow_page:p_session_id:p_entry_point:%0:%1:%2\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283763815570872167)
,p_name=>'APEX.AUTHENTICATION.LOGIN.NULL_USER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F20\9001\5230\767B\5F55\8FC7\7A0B\7684\7528\6237\540D\4E3A\7A7A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283663543797872091)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.COUNTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\7B49\5F85 <span id="apex_login_throttle_sec">%0</span> \79D2\540E\91CD\65B0\767B\5F55\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283668542620872095)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\963B\6B62\767B\5F55\5C1D\8BD5\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284103836398872420)
,p_name=>'APEX.AUTHENTICATION.NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\627E\4E0D\5230\9A8C\8BC1 "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283677103174872101)
,p_name=>'APEX.AUTHENTICATION.NO_SECURITY_GROUP_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B89\5168\7EC4 ID \4E3A\7A7A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283763347878872166)
,p_name=>'APEX.AUTHENTICATION.POST_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6267\884C\9A8C\8BC1\540E\8FDB\7A0B\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283763058290872166)
,p_name=>'APEX.AUTHENTICATION.PRE_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\9A8C\8BC1\524D\8FDB\7A0B\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283782510088872181)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD.INSTRUCTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\5728\542F\52A8\201C\91CD\7F6E\5BC6\7801\201D\8BF7\6C42\7684\540C\4E00\6D4F\89C8\5668\4E2D\6253\5F00\6B64 URL\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285002928193873071)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD_URL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\7F6E\5BC6\7801 URL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283644204557872076)
,p_name=>'APEX.AUTHENTICATION.RM_GROUP_NOT_GRANTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D44\6E90\7BA1\7406\5668\4F7F\7528\8005\7EC4%0\672A\6388\4E88%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283644398836872076)
,p_name=>'APEX.AUTHENTICATION.RM_INFO_TO_GRANT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\4F7F\7528 DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP \6388\4E88\7F3A\5C11\7684\6743\9650\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283840321522872225)
,p_name=>'APEX.AUTHENTICATION.SESSION_SENTRY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\4F1A\8BDD\536B\58EB\51FD\6570\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283840482626872225)
,p_name=>'APEX.AUTHENTICATION.SESSION_VERIFY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\4F1A\8BDD\9A8C\8BC1\51FD\6570\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283840673478872225)
,p_name=>'APEX.AUTHENTICATION.SSO.ASK_FOR_INSTALLATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\8981\6C42\60A8\7684 %0 \7BA1\7406\5458\914D\7F6E Oracle Application Server Single Sign-On \7684\5F15\64CE\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283916754035872283)
,p_name=>'APEX.AUTHENTICATION.SSO.BAD_URLC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7531 sso \8FD4\56DE\7684 %1 \4EE4\724C\4E2D\7684 %0 \975E\6CD5\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283764010278872167)
,p_name=>'APEX.AUTHENTICATION.SSO.FIX_PARTNER_APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\7F16\8F91\9A8C\8BC1\65B9\6848\5E76\6DFB\52A0\5E94\7528\7A0B\5E8F\540D\79F0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283916368531872283)
,p_name=>'APEX.AUTHENTICATION.SSO.ILLEGAL_CALLER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \8FC7\7A0B\7684\975E\6CD5\8C03\7528\8005:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283916516603872283)
,p_name=>'APEX.AUTHENTICATION.SSO.INVALID_APP_SESSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('urlc \6807\8BB0\4E2D\7684\5E94\7528\7A0B\5E8F\4F1A\8BDD\65E0\6548: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283916142334872283)
,p_name=>'APEX.AUTHENTICATION.SSO.MISSING_APP_REGISTRATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('portal_sso_redirect \4E2D\51FA\9519: \7F3A\5C11\5E94\7528\7A0B\5E8F\6CE8\518C\4FE1\606F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283840502229872225)
,p_name=>'APEX.AUTHENTICATION.SSO.PACKAGE_MISSING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('WWSEC_SSO_ENABLER_PRIVATE \5305\4E0D\5B58\5728\6216\65E0\6548\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283763940345872167)
,p_name=>'APEX.AUTHENTICATION.SSO.PARTNER_APP_IS_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\5728\9A8C\8BC1\65B9\6848\4E2D\627E\5230\6CE8\518C\7684\5408\4F5C\4F19\4F34\5E94\7528\7A0B\5E8F\540D\79F0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283916224631872283)
,p_name=>'APEX.AUTHENTICATION.SSO.REGISTER_APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\6309\7167\5B89\88C5\6307\5357\6CE8\518C\6B64\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283840714046872225)
,p_name=>'APEX.AUTHENTICATION.SSO.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406 SSO \9A8C\8BC1\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284919799458873010)
,p_name=>'APEX.AUTHENTICATION.UNAUTHORIZED_URL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6388\6743\7684 URL:  %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283840150606872225)
,p_name=>'APEX.AUTHENTICATION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\9A8C\8BC1\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283644129653872076)
,p_name=>'APEX.AUTHENTICATION.WORKSPACE_NOT_ASSIGNED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A "%0" \4E0D\6D3B\52A8\3002\8BF7\4E0E\7BA1\7406\5458\8054\7CFB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283645369328872077)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED'
,p_message_language=>'zh-cn'
,p_message_text=>'%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283666073715872093)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\5B89\5168\68C0\67E5\62D2\7EDD\7684\8BBF\95EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283666116419872093)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\5B89\5168\68C0\67E5\62D2\7EDD\7684\8BBF\95EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283666240707872093)
,p_name=>'APEX.AUTHORIZATION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\6388\6743\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284143052198872449)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\8868\4E2D\4E0D\5B58\5728 #LABEL#\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284525482065872726)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\9875\5C5E\6027 "\63D0\4EA4\65F6\91CD\65B0\52A0\8F7D" \8BBE\7F6E\4E3A "\4EC5\6210\529F\65F6", \5219\4E0D\652F\6301\201C\4EC5\663E\793A\5206\652F\201D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283890446411872263)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\5206\652F\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284210939668872498)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528 %1 \4E0E %0 \4E00\8D77\6784\5EFA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284211033042872499)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX.ACCESSIBLE.LOVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\559C\7231')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284247633680872525)
,p_name=>'APEX.CALCULATOR.ICON_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F39\51FA\5F0F\8BA1\7B97\5668: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284875723950872978)
,p_name=>'APEX.CALENDAR.EVENT_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6\8BF4\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284875512141872977)
,p_name=>'APEX.CALENDAR.EVENT_END'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED3\675F\65E5\671F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284875873358872978)
,p_name=>'APEX.CALENDAR.EVENT_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6 ID')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284875459783872977)
,p_name=>'APEX.CALENDAR.EVENT_START'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\59CB\65E5\671F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284875640523872977)
,p_name=>'APEX.CALENDAR.EVENT_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6\6807\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284343704304872596)
,p_name=>'APEX.CLIPBOARD.COPIED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\590D\5236\5230\526A\8D34\677F\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284336799131872591)
,p_name=>'APEX.CLIPBOARD.NOTSUP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\6D4F\89C8\5668\4E0D\652F\6301\4ECE\6309\94AE\6216\83DC\5355\590D\5236\3002\8BF7\5C1D\8BD5 Ctrl+C \6216 Command+C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284213090850872500)
,p_name=>'APEX.CLOSE_NOTIFICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\95ED\901A\77E5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283634874219872069)
,p_name=>'APEX.COLOR_PICKER.ICON_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F39\51FA\5F0F\989C\8272\9009\62E9\5668: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284988968726873061)
,p_name=>'APEX.COMBOBOX.LIST_OF_VALUES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\5217\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284989092646873061)
,p_name=>'APEX.COMBOBOX.SHOW_ALL_VALUES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6253\5F00 %0 \7684\5217\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284940294084873025)
,p_name=>'APEX.COMPLETED_STATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('(\5DF2\5B8C\6210)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283645570363872077)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\8BA1\7B97\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283867843062872246)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\6761\4EF6\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283930569943872294)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\77E5\7684\6761\4EF6\7C7B\578B "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283895731361872267)
,p_name=>'APEX.CONTACT_ADMIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\4E0E\60A8\7684\5E94\7528\7A0B\5E8F\7BA1\7406\5458\8054\7CFB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283978070651872329)
,p_name=>'APEX.CONTACT_ADMIN.DEBUG'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4E0E\60A8\7684\5E94\7528\7A0B\5E8F\7BA1\7406\5458\8054\7CFB\3002'),
unistr('\901A\8FC7\8C03\8BD5 ID "%0" \63D0\4F9B\6709\5173\6B64\610F\5916\4E8B\4EF6\7684\8BE6\7EC6\4FE1\606F\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284862744800872968)
,p_name=>'APEX.CORRECT_ERRORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\5728\4FDD\5B58\4E4B\524D\66F4\6B63\9519\8BEF\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284944475731873028)
,p_name=>'APEX.CURRENT_PROGRESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\8FDB\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284563741625872752)
,p_name=>'APEX.DATA_HAS_CHANGED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\7528\6237\5F00\59CB\66F4\65B0\8FC7\7A0B\4EE5\540E, \6570\636E\5E93\4E2D\6570\636E\7684\5F53\524D\7248\672C\5DF2\7ECF\66F4\6539\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284247584287872525)
,p_name=>'APEX.DATEPICKER.ICON_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F39\51FA\5F0F\65E5\5386: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284256669889872532)
,p_name=>'APEX.DATEPICKER_VALUE_GREATER_MAX_DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \5927\4E8E\6307\5B9A\7684\6700\5927\65E5\671F %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284261929898872536)
,p_name=>'APEX.DATEPICKER_VALUE_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \4E0D\7B26\5408\683C\5F0F%0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284256568778872532)
,p_name=>'APEX.DATEPICKER_VALUE_LESS_MIN_DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \5C0F\4E8E\6307\5B9A\7684\6700\5C0F\65E5\671F %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284256794571872532)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \4E0D\5728\6709\6548\8303\56F4 %0 \5230 %1 \5185\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284260234356872535)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_IN_YEAR_RANGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \4E0D\5728\6709\6548\5E74\8303\56F4 %0 \5230 %1 \5185\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284863409290872968)
,p_name=>'APEX.DIALOG.CANCEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284969102683873047)
,p_name=>'APEX.DIALOG.CLOSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\95ED')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284974184140873050)
,p_name=>'APEX.DIALOG.HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284863284592872968)
,p_name=>'APEX.DIALOG.OK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\786E\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284074698488872399)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\6210\529F\5448\73B0\5E94\7528\7A0B\5E8F %0 \5BF9\8BDD\6846\9875 %1\3002\8BF7\786E\4FDD\5728\9875 %1 \4E0A\4F7F\7528\7684\9875\6A21\677F\7684\6A21\677F\7C7B\578B\4E3A "\5BF9\8BDD\6846\9875", \4E14\5B9A\4E49\4E86\9002\5F53\7684 JavaScript \5BF9\8BDD\6846\521D\59CB\5316, \5BF9\8BDD\6846\5173\95ED\548C\5BF9\8BDD\6846\53D6\6D88\4EE3\7801\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284863359429872968)
,p_name=>'APEX.DIALOG.SAVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284990843388873062)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7248\6743\6240\6709 (c) %0, \4FDD\7559\6240\6709\6743\5229\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284991601174873063)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5DE5\4F5C\533A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284990744804873062)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD9\662F\4E00\5C01\7CFB\7EDF\751F\6210\7684\90AE\4EF6\3002\8BF7\52FF\56DE\590D\6B64\90AE\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285000519967873070)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\73AF\5883')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285013112546873079)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Oracle Application Express \7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284992289759873063)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5165\95E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284990936199873063)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\597D, %0:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284991999553873063)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285000676610873070)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\963B\6B62\5DE5\4F5C\533A\6E05\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284992182192873063)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\51FB\4E0B\9762\7684\6309\94AE\5E76\6309\7167\5C4F\5E55\4E0A\7684\8BF4\660E\64CD\4F5C\53EF\9632\6B62\6E05\9664\60A8\7684\5DE5\4F5C\533A\3002\5982\679C\60A8\5728 %0 \5929\5185\672A\91C7\53D6\64CD\4F5C, \7CFB\7EDF\5C06\81EA\52A8\5220\9664\60A8\7684\5DE5\4F5C\533A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285000380156873069)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\60A8\4E0D\518D\9700\8981\6B64\5DE5\4F5C\533A, \5219\65E0\9700\91C7\53D6\4EFB\4F55\64CD\4F5C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285000881705873070)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5373\5C06\6E05\9664\60A8\7684\5DE5\4F5C\533A!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285000193612873069)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\533A %0 \672A\663E\793A\4EFB\4F55\8FD1\671F\6D3B\52A8, \5E76\4E14\5DF2\8C03\5EA6\4E3A\5373\5C06\6E05\9664\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285000044816873069)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8B66\544A! \5373\5C06\6E05\9664\60A8\7684\5DE5\4F5C\533A "%0"\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285000463060873070)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285001192089873070)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\5B8C\6210\5DE5\4F5C\533A\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285000993385873070)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\533A "%0" \5DF2\51C6\5907\5C31\7EEA!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285001228795873070)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6279\51C6\60A8\7684\5DE5\4F5C\533A "%0"!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285001005883873070)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\62D2\7EDD\60A8\7684\5DE5\4F5C\533A\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284991519078873063)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285000769709873070)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8B66\544A\FF01')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284991414711873063)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284991038006873063)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A\8BF7\6C42\5DF2\88AB\6279\51C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284991711978873063)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\51FB\4EE5\4E0B\6309\94AE\53EF\4EE5\5B8C\6210\5BA1\6279\8FC7\7A0B\5E76\8BBE\7F6E\5BC6\7801\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284991280688873063)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\533A\8BF7\6C42\5DF2\88AB\6279\51C6!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284991846282873063)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\51FB\4E0B\9762\7684\6309\94AE\4EE5\5F00\59CB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284992012914873063)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\533A\5DF2\51C6\5907\5C31\7EEA!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284991192800873063)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A\8BF7\6C42\5DF2\88AB\62D2\7EDD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284991357985873063)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62B1\6B49, \60A8\7684\5DE5\4F5C\533A\8BF7\6C42\5DF2\88AB\62D2\7EDD\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283890782338872263)
,p_name=>'APEX.ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283641087485872074)
,p_name=>'APEX.ERROR.CALLBACK_FAILED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6267\884C\9519\8BEF\5904\7406\56DE\8C03\65F6\51FA\73B0\4EE5\4E0B\9519\8BEF: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283682138141872105)
,p_name=>'APEX.ERROR.ERROR_PAGE.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\9519\8BEF\9875\65F6\51FA\9519: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283644819525872077)
,p_name=>'APEX.ERROR.INTERNAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5185\90E8\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284933270501873020)
,p_name=>'APEX.ERROR.INTERNAL.CONTACT_ADMINISTRATOR'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4E0E\60A8\7684\7BA1\7406\5458\8054\7CFB\3002'),
unistr('\901A\8FC7\8C03\8BD5 ID "%0" \63D0\4F9B\6709\5173\6B64\610F\5916\4E8B\4EF6\7684\8BE6\7EC6\4FE1\606F\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285014083602873080)
,p_name=>'APEX.ERROR.ORA-28353'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('ORA-28353: \65E0\6CD5\6253\5F00 wallet\3002\5E94\7528\7A0B\5E8F\6570\636E\5F53\524D\4E0D\53EF\8BBF\95EE\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284915424904873007)
,p_name=>'APEX.ERROR.PAGE_NOT_AVAILABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62B1\6B49, \6B64\9875\4E0D\53EF\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283650608971872081)
,p_name=>'APEX.ERROR.TECHNICAL_INFO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6280\672F\4FE1\606F (\4EC5\5BF9\5F00\53D1\8005\53EF\89C1)')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284478479040872694)
,p_name=>'APEX.ERROR_MESSAGE_HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9519\8BEF\6D88\606F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284552309844872744)
,p_name=>'APEX.EXPECTED_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\9700\683C\5F0F\FF1A%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284275977704872546)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.ALREADY_IN_ACL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\5DF2\5728\8BBF\95EE\63A7\5236\5217\8868\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284275832527872546)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.CREATE_CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\786E\8BA4\5C06\4EE5\4E0B %0 \4E2A <strong>%1</strong> \7528\6237\6DFB\52A0\5230\8BBF\95EE\63A7\5236\5217\8868\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284276378692872546)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.DUPLICATE_USE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B58\5728\91CD\590D\7684\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284276005637872546)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_AT_SIGN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\5730\5740\4E2D\7F3A\5C11 @ \7B26\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284276127681872546)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_DO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\5730\5740\4E2D\7F3A\5C11\53E5\70B9 (.)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284276258910872546)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.USERNAME_TOO_LONG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\540D\592A\957F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284276507174872547)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_ONLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EA\6709\5728\5E94\7528\7A0B\5E8F\8BBF\95EE\63A7\5236\5217\8868\4E2D\5B9A\4E49\7684\7528\6237\53EF\4EE5\8BBF\95EE\6B64\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284276676275872547)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_VALUE_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\610F\5916\7684\8BBF\95EE\63A7\5236\5217\8868\8BBE\7F6E\503C\FF1A%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284276457605872546)
,p_name=>'APEX.FEATURE.ACL.INFO.ALL_USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\901A\8FC7\9A8C\8BC1\7684\7528\6237\53EF\4EE5\8BBF\95EE\6B64\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284822001430872938)
,p_name=>'APEX.FEATURE.CONFIG.DISABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\7981\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284821965951872938)
,p_name=>'APEX.FEATURE.CONFIG.ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\542F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284823028386872939)
,p_name=>'APEX.FEATURE.CONFIG.IS_DISABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\FF1A\5DF2\7981\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284822101187872938)
,p_name=>'APEX.FEATURE.CONFIG.IS_ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\FF1A\5DF2\542F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284211786417872499)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6392\961F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284211858797872499)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\53D1\9001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284821863152872938)
,p_name=>'APEX.FEATURE.TOP_USERS.USERNAME.NOT_IDENTIFIED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\786E\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283675431218872100)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53CD\9988\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283675527405872100)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\89E3\51B3\53CD\9988\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283675625675872100)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284565400097872753)
,p_name=>'APEX.FILE_BROWSE.DOWNLOAD_LINK_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\8F7D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284558683891872748)
,p_name=>'APEX.FS.BATCH_APPLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284559192276872749)
,p_name=>'APEX.FS.CLEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284559258222872749)
,p_name=>'APEX.FS.CLEAR_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\6E05\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284559376214872749)
,p_name=>'APEX.FS.CLEAR_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284889936808872988)
,p_name=>'APEX.FS.COLUMN_UNAUTHORIZED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762 %0 \5F15\7528\7684\5217 %1 \4E0D\53EF\7528\6216\672A\6388\6743\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284882354685872983)
,p_name=>'APEX.FS.FACET_VALUE_LIMIT_EXCEEDED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\8D85\8FC7\9762 %1 \7684\4E0D\540C\503C\9650\5236 (%0)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284560800758872750)
,p_name=>'APEX.FS.FC_TYPE_UNSUPPORTED_FOR_DATE_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9 DATE \6216 TIMESTAMP \5217\4E0D\652F\6301\9762 %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284558772297872748)
,p_name=>'APEX.FS.FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284558834300872748)
,p_name=>'APEX.FS.GO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\59CB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284560434660872749)
,p_name=>'APEX.FS.INPUT_CURRENT_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B49\4E8E %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284560699863872750)
,p_name=>'APEX.FS.NO_SEARCH_COLUMNS_PROVIDED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\4E3A\9762 %0 \63D0\4F9B\641C\7D22\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284560133110872749)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5230 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284560251391872749)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_HI'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9AD8\4E8E %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284560301815872749)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_LO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F4E\4E8E %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284900746683872996)
,p_name=>'APEX.FS.RANGE_LOV_ITEM_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8303\56F4\9762 %0 \7684 LOV \9879 #%2 ("%1") \65E0\6548\FF08\7F3A\5C11 "|" \5206\9694\7B26\FF09\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284560569768872750)
,p_name=>'APEX.FS.RANGE_MANUAL_NOT_SUPPORTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\8303\56F4\9762 %0 \4E0D\652F\6301\624B\52A8\8F93\5165\FF0C\56E0\4E3A\5217\4E3A DATE \6216 TIMESTAMP\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284559732292872749)
,p_name=>'APEX.FS.RANGE_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284559079432872749)
,p_name=>'APEX.FS.SEARCH_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284558981673872748)
,p_name=>'APEX.FS.SEARCH_PLACEHOLDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284559977881872749)
,p_name=>'APEX.FS.SELECT_PLACEHOLDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284559582338872749)
,p_name=>'APEX.FS.SHOW_LESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\66F4\5C11')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284559665279872749)
,p_name=>'APEX.FS.SHOW_MORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\66F4\591A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284559883426872749)
,p_name=>'APEX.FS.STAR_RATING_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \661F\53CA\66F4\9AD8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284560741875872750)
,p_name=>'APEX.FS.TEXT_FIELD_ONLY_FOR_NUMBER_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\4EC5\5BF9 NUMBER \5217\652F\6301\6587\672C\5B57\6BB5\9762 %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284890177393872988)
,p_name=>'APEX.FS.UNSUPPORTED_DATA_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\9762\641C\7D22\4E0D\652F\6301 %0 \6570\636E\7C7B\578B (%1)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284823690366872939)
,p_name=>'APEX.GO_TO_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F6C\5230\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284036535507872372)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\627E\4E0D\5230\7EC4 "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284282423178872551)
,p_name=>'APEX.GV.AGG_CONTEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\805A\96C6\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284391076251872630)
,p_name=>'APEX.GV.BREAK_COLLAPSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6298\53E0\63A7\5236\5206\6BB5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284282548839872551)
,p_name=>'APEX.GV.BREAK_CONTEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63A7\5236\5206\6BB5\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284390934207872630)
,p_name=>'APEX.GV.BREAK_EXPAND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C55\5F00\63A7\5236\5206\6BB5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285020299971873084)
,p_name=>'APEX.GV.COLUMN_CONTEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217 %0\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284390785878872630)
,p_name=>'APEX.GV.DELETED_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5220\9664 %0 \884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284979731980873054)
,p_name=>'APEX.GV.DUP_REC_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\590D\7684\8EAB\4EFD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284269414466872541)
,p_name=>'APEX.GV.FIRST_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B2C\4E00\4E2A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284282735713872551)
,p_name=>'APEX.GV.GROUP_CONTEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\6807\9898\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284282688604872551)
,p_name=>'APEX.GV.HEADER_CONTEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\9898\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284269590605872541)
,p_name=>'APEX.GV.LAST_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\540E\4E00\4E2A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284431397430872660)
,p_name=>'APEX.GV.LOAD_MORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A0\8F7D\66F4\591A\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284269273367872541)
,p_name=>'APEX.GV.NEXT_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E00\9875')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284282846152872551)
,p_name=>'APEX.GV.PAGE_RANGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284269613573872542)
,p_name=>'APEX.GV.PAGE_RANGE_XY'
,p_message_language=>'zh-cn'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284269702636872542)
,p_name=>'APEX.GV.PAGE_RANGE_XYZ'
,p_message_language=>'zh-cn'
,p_message_text=>'%0 - %1 / %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284269326751872541)
,p_name=>'APEX.GV.PREV_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E00\9875')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284979548829873054)
,p_name=>'APEX.GV.ROW_ADDED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6DFB\52A0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284979656661873054)
,p_name=>'APEX.GV.ROW_CHANGED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\6539')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285020030078873084)
,p_name=>'APEX.GV.ROW_COLUMN_CONTEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C %0\FF0C\5217 %1\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285020144951873084)
,p_name=>'APEX.GV.ROW_CONTEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C %0\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284979437063873054)
,p_name=>'APEX.GV.ROW_DELETED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5220\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284311646769872572)
,p_name=>'APEX.GV.ROW_HEADER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\6807\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284268502617872541)
,p_name=>'APEX.GV.SELECTION_CELL_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\5B9A\4E86 %0 \4E2A\5355\5143')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284269801264872542)
,p_name=>'APEX.GV.SELECTION_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\9009\62E9 %0 \884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284615214410872788)
,p_name=>'APEX.GV.SELECT_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\9009')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284390888046872630)
,p_name=>'APEX.GV.SELECT_PAGE_N'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284311581917872572)
,p_name=>'APEX.GV.SELECT_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284314166320872574)
,p_name=>'APEX.GV.SORTED_ASCENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5347\5E8F\6392\5E8F %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284314259592872574)
,p_name=>'APEX.GV.SORTED_DESCENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\964D\5E8F\6392\5E8F %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284268710997872541)
,p_name=>'APEX.GV.SORT_ASCENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5347\5E8F\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284269025219872541)
,p_name=>'APEX.GV.SORT_ASCENDING_ORDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5347\5E8F\6392\5E8F %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284268815615872541)
,p_name=>'APEX.GV.SORT_DESCENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\964D\5E8F\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284269183907872541)
,p_name=>'APEX.GV.SORT_DESCENDING_ORDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\964D\5E8F\6392\5E8F %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284268950527872541)
,p_name=>'APEX.GV.SORT_OFF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284390683111872630)
,p_name=>'APEX.GV.TOTAL_PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\8BA1 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284953931889873035)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\6587\6863')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284973408614873050)
,p_name=>'APEX.ICON_LIST.GRID_DIM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F51\683C\9009\62E9\5217\8868 %0 \5217 %1 \884C\3002\4F7F\7528\7BAD\5934\952E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284389736790872629)
,p_name=>'APEX.ICON_LIST.LIST_DIM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\5217\8868 %0 \884C\3002\4F7F\7528\7BAD\5934\952E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285019884398873084)
,p_name=>'APEX.IG.ACC_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EA4\4E92\5F0F\7F51\683C %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284251962560872529)
,p_name=>'APEX.IG.ACTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284252980953872529)
,p_name=>'APEX.IG.ADD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284252805548872529)
,p_name=>'APEX.IG.ADD_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284987544989873060)
,p_name=>'APEX.IG.AGGREGATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\805A\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284950413077873033)
,p_name=>'APEX.IG.AGGREGATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\805A\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284953468894873035)
,p_name=>'APEX.IG.ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284510645790872716)
,p_name=>'APEX.IG.ALL_TEXT_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\6587\672C\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284511864204872716)
,p_name=>'APEX.IG.ALTERNATIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66FF\4EE3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284512928556872717)
,p_name=>'APEX.IG.AND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284858971385872965)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\540C\503C\8FD1\4F3C\8BA1\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284988592147873061)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT_OVERALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\4F53\4E0D\540C\503C\8FD1\4F3C\8BA1\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284946571809873030)
,p_name=>'APEX.IG.AREA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\79EF\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284952036372873034)
,p_name=>'APEX.IG.ASCENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5347\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284511925232872716)
,p_name=>'APEX.IG.AUTHORIZATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6388\6743')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284987649643873060)
,p_name=>'APEX.IG.AUTO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81EA\52A8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284859347453872965)
,p_name=>'APEX.IG.AVG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E73\5747\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284988298090873061)
,p_name=>'APEX.IG.AVG_OVERALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\4F53\5E73\5747\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284946041961873030)
,p_name=>'APEX.IG.AXIS_LABEL_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E\8F74\6807\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284946283169873030)
,p_name=>'APEX.IG.AXIS_VALUE_DECIMAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C0F\6570\4F4D\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284946110920873030)
,p_name=>'APEX.IG.AXIS_VALUE_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\8F74\6807\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284960218295873040)
,p_name=>'APEX.IG.BACKGROUND_COLOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\80CC\666F\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284946607428873030)
,p_name=>'APEX.IG.BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6761\5F62\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284494333011872704)
,p_name=>'APEX.IG.BETWEEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECB\4E8E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284961936689873041)
,p_name=>'APEX.IG.BOTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8C\8005')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284946700880873030)
,p_name=>'APEX.IG.BUBBLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6C14\6CE1\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284253166900872529)
,p_name=>'APEX.IG.CANCEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284512856785872717)
,p_name=>'APEX.IG.CASE_SENSITIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\5206\5927\5C0F\5199')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284989129551873061)
,p_name=>'APEX.IG.CASE_SENSITIVE_WITH_BRACKETS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('(\533A\5206\5927\5C0F\5199)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284898680268872995)
,p_name=>'APEX.IG.CHANGES_SAVED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539\5DF2\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284253574407872530)
,p_name=>'APEX.IG.CHANGE_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539\89C6\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284513956242872718)
,p_name=>'APEX.IG.CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284509377617872715)
,p_name=>'APEX.IG.CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\7684\67E5\8BE2\8D85\8FC7\4E86\6BCF\4E2A\56FE\8868\7684\6700\5927\6570\636E\70B9\6570 %0\3002\8BF7\5E94\7528\8FC7\6EE4\5668\6765\51CF\5C11\57FA\672C\67E5\8BE2\4E2D\7684\8BB0\5F55\6570\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284251829777872528)
,p_name=>'APEX.IG.CHART_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\89C6\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284315168388872575)
,p_name=>'APEX.IG.CLEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284945510857873029)
,p_name=>'APEX.IG.CLOSE_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6536\76D8\4EF7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284960997336873040)
,p_name=>'APEX.IG.COLORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\989C\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284960843487873040)
,p_name=>'APEX.IG.COLOR_BLUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\84DD\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284960737561873040)
,p_name=>'APEX.IG.COLOR_GREEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EFF\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284960531776873040)
,p_name=>'APEX.IG.COLOR_ORANGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A59\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284960673613873040)
,p_name=>'APEX.IG.COLOR_RED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EA2\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284960455010873040)
,p_name=>'APEX.IG.COLOR_YELLOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9EC4\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284512244994872717)
,p_name=>'APEX.IG.COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284252051350872529)
,p_name=>'APEX.IG.COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284965720559873044)
,p_name=>'APEX.IG.COLUMN_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\7528\9014')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284512337259872717)
,p_name=>'APEX.IG.COMPLEX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\6742')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284252283422872529)
,p_name=>'APEX.IG.COMPUTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284494963752872705)
,p_name=>'APEX.IG.CONTAINS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5305\542B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284518238516872721)
,p_name=>'APEX.IG.CONTROL_BREAK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63A7\5236\5206\6BB5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284314937026872575)
,p_name=>'APEX.IG.COPY_CB'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\5230\526A\8D34\677F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284315064377872575)
,p_name=>'APEX.IG.COPY_DOWN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5411\4E0B\590D\5236')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284858712215872965)
,p_name=>'APEX.IG.COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284858807925872965)
,p_name=>'APEX.IG.COUNT_DISTINCT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\540C\503C\8BA1\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284988449484873061)
,p_name=>'APEX.IG.COUNT_DISTINCT_OVERALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\4F53\4E0D\540C\503C\8BA1\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284988349397873061)
,p_name=>'APEX.IG.COUNT_OVERALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\4F53\8BA1\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284979890533873054)
,p_name=>'APEX.IG.CREATE_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284510859075872716)
,p_name=>'APEX.IG.DATA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284963162874873042)
,p_name=>'APEX.IG.DATA_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\7C7B\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284962184139873041)
,p_name=>'APEX.IG.DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\671F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284898456194872994)
,p_name=>'APEX.IG.DATE_INVALID_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\671F\503C\65E0\6548')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284495837249872705)
,p_name=>'APEX.IG.DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5929')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284511550181872716)
,p_name=>'APEX.IG.DEFAULT_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\8BBE\7F6E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284511329689872716)
,p_name=>'APEX.IG.DEFAULT_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\7C7B\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284253025341872529)
,p_name=>'APEX.IG.DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284966721640873045)
,p_name=>'APEX.IG.DELETE_REPORT_CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\5426\786E\5B9A\8981\5220\9664\6B64\62A5\8868?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284520090398872722)
,p_name=>'APEX.IG.DELETE_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\884C')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284518890570872721)
,p_name=>'APEX.IG.DELETE_ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284952145893873034)
,p_name=>'APEX.IG.DESCENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\964D\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284513668486872718)
,p_name=>'APEX.IG.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BE6\7EC6\8D44\6599')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284251539250872528)
,p_name=>'APEX.IG.DETAIL_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BE6\7EC6\8D44\6599\89C6\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284914365070873006)
,p_name=>'APEX.IG.DIRECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B9\5411')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284513356772872717)
,p_name=>'APEX.IG.DISABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\7981\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284495075742872705)
,p_name=>'APEX.IG.DOES_NOT_CONTAIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5305\542B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284495205313872705)
,p_name=>'APEX.IG.DOES_NOT_START_WITH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\5934\4E0D\4E3A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284946887842873030)
,p_name=>'APEX.IG.DONUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5706\73AF\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284518406601872721)
,p_name=>'APEX.IG.DOWNLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\8F7D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284967798049873045)
,p_name=>'APEX.IG.DOWNLOAD_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\683C\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284953000895873035)
,p_name=>'APEX.IG.DUPLICATE_AGGREGATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\590D\7684\805A\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284953135793873035)
,p_name=>'APEX.IG.DUPLICATE_CONTROLBREAK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\590D\7684\63A7\5236\5206\6BB5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284519969072872722)
,p_name=>'APEX.IG.DUPLICATE_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284518791611872721)
,p_name=>'APEX.IG.DUPLICATE_ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284252667688872529)
,p_name=>'APEX.IG.EDIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284951555844873034)
,p_name=>'APEX.IG.EDIT_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\56FE\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284975550723873051)
,p_name=>'APEX.IG.EDIT_GROUP_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\5206\7EC4\65B9\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284967300889873045)
,p_name=>'APEX.IG.EMAIL_BCC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\4EF6\6284\9001 (bcc)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284967564306873045)
,p_name=>'APEX.IG.EMAIL_BODY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D88\606F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284967201055873045)
,p_name=>'APEX.IG.EMAIL_CC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6284\9001 (cc)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284966933531873045)
,p_name=>'APEX.IG.EMAIL_SENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\5DF2\53D1\9001\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284967486903873045)
,p_name=>'APEX.IG.EMAIL_SUBJECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284967179268873045)
,p_name=>'APEX.IG.EMAIL_TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6536\4EF6\4EBA (to)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284513063138872717)
,p_name=>'APEX.IG.ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\542F\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284493399869872704)
,p_name=>'APEX.IG.EQUALS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B49\4E8E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284966334457873044)
,p_name=>'APEX.IG.EXAMPLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\793A\4F8B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284513164756872717)
,p_name=>'APEX.IG.EXPRESSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\8FBE\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284966235445873044)
,p_name=>'APEX.IG.FD_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7C7B\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284615104855872787)
,p_name=>'APEX.IG.FILE_PREPARED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\4EF6\5DF2\51C6\5907\597D\3002\6B63\5728\5F00\59CB\4E0B\8F7D\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284315259934872575)
,p_name=>'APEX.IG.FILL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\586B\5145')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284336664696872590)
,p_name=>'APEX.IG.FILL_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\586B\5145\9009\62E9\7684\65B9\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284336520089872590)
,p_name=>'APEX.IG.FILL_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\586B\5145\9009\62E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284252186441872529)
,p_name=>'APEX.IG.FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284512438393872717)
,p_name=>'APEX.IG.FILTERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284987932290873060)
,p_name=>'APEX.IG.FILTER_WITH_DOTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284952397642873034)
,p_name=>'APEX.IG.FIRST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B2C\4E00\4E2A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284252396799872529)
,p_name=>'APEX.IG.FLASHBACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\95EA\56DE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284510999448872716)
,p_name=>'APEX.IG.FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\683C\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284961833604873041)
,p_name=>'APEX.IG.FORMATMASK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\683C\5F0F\63A9\7801')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284966692470873045)
,p_name=>'APEX.IG.FORMAT_CSV'
,p_message_language=>'zh-cn'
,p_message_text=>'CSV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284966507380873045)
,p_name=>'APEX.IG.FORMAT_HTML'
,p_message_language=>'zh-cn'
,p_message_text=>'HTML'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284519612273872722)
,p_name=>'APEX.IG.FREEZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51BB\7ED3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284513296431872717)
,p_name=>'APEX.IG.FUNCTIONS_AND_OPERATORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FD\6570\548C\8FD0\7B97\7B26')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284946927309873030)
,p_name=>'APEX.IG.FUNNEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6F0F\6597\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284858686227872965)
,p_name=>'APEX.IG.GO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\59CB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284493900301872704)
,p_name=>'APEX.IG.GREATER_THAN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5927\4E8E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284494090326872704)
,p_name=>'APEX.IG.GREATER_THAN_OR_EQUALS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5927\4E8E\7B49\4E8E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284513577830872718)
,p_name=>'APEX.IG.GRID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F51\683C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284251317000872528)
,p_name=>'APEX.IG.GRID_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F51\683C\89C6\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284953331389873035)
,p_name=>'APEX.IG.GROUP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284513744128872718)
,p_name=>'APEX.IG.GROUP_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\7EC4\65B9\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284251616061872528)
,p_name=>'APEX.IG.GROUP_BY_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\7EC4\65B9\5F0F\89C6\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284962484284873042)
,p_name=>'APEX.IG.HD_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6761\4EF6\7C7B\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284961326331873041)
,p_name=>'APEX.IG.HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284961594572873041)
,p_name=>'APEX.IG.HEADING_ALIGN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\9898\5BF9\9F50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284987824727873060)
,p_name=>'APEX.IG.HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284973693234873050)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\53EF\4EE5\76F4\63A5\5728\6B64\4EA4\4E92\5F0F\7F51\683C\4E2D\63D2\5165, \66F4\65B0\548C\5220\9664\6570\636E\3002</p>'),
'',
unistr('<p>\5355\51FB\201C\6DFB\52A0\884C\201D\6309\94AE\53EF\63D2\5165\65B0\884C\3002</p>'),
'',
unistr('<p>\53CC\51FB\7279\5B9A\5355\5143\53EF\7F16\8F91\73B0\6709\6570\636E\3002\5BF9\4E8E\8F83\5927\91CF\7684\7F16\8F91\5DE5\4F5C, \5355\51FB\201C\7F16\8F91\201D\53EF\8FDB\5165\7F16\8F91\6A21\5F0F\3002\5728\7F16\8F91\6A21\5F0F\4E2D, \53EF\4EE5\5355\51FB\6216\4F7F\7528\952E\76D8\6765\7F16\8F91\7279\5B9A\5355\5143\3002</p>'),
'',
unistr('<p>\4F7F\7528\201C\66F4\6539\201D\83DC\5355\53EF\590D\5236\548C\5220\9664\884C\3002\8981\542F\7528\201C\66F4\6539\201D\83DC\5355, \8BF7\4F7F\7528\590D\9009\6846\6765\9009\62E9\4E00\884C\6216\591A\884C\3002</p>'),
'',
unistr('<p>\5355\51FB\201C\66F4\6539\201D\83DC\5355\5E76\9009\62E9\201C\590D\5236\884C\201D\53EF\590D\5236\6240\9009\884C\3002\5355\51FB\201C\66F4\6539\201D\83DC\5355\5E76\9009\62E9\201C\5220\9664\884C\201D\53EF\5220\9664\6240\9009\884C\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284976004362873052)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING_HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284976133539873052)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4EA4\4E92\5F0F\7F51\683C\5728\53EF\641C\7D22, \53EF\5B9A\5236\7684\62A5\8868\4E2D\5448\73B0\4E00\7EC4\6570\636E\3002\60A8\53EF\4EE5\6267\884C\5404\79CD\64CD\4F5C\6765\9650\5236\8FD4\56DE\7684\8BB0\5F55, \5E76\66F4\6539\6570\636E\7684\663E\793A\65B9\5F0F\3002</p>'),
'',
unistr('<p>\4F7F\7528\201C\641C\7D22\201D\5B57\6BB5\53EF\4EE5\8FC7\6EE4\8FD4\56DE\7684\8BB0\5F55\3002\5355\51FB\201C\64CD\4F5C\201D\53EF\4EE5\8BBF\95EE\7528\4E8E\4FEE\6539\62A5\8868\5E03\5C40\7684\5404\79CD\9009\9879, \6216\8005\5728\663E\793A\7684\5217\4E0A\4F7F\7528\201C\5217\6807\9898\201D\83DC\5355\3002</p>'),
'',
unistr('<p>\4F7F\7528\201C\62A5\8868\8BBE\7F6E\201D\53EF\4FDD\5B58\5BF9\62A5\8868\6240\505A\7684\5B9A\5236\8BBE\7F6E\3002\8FD8\53EF\4EE5\4ECE\62A5\8868\4E2D\5C06\6570\636E\4E0B\8F7D\5230\5916\90E8\6587\4EF6, \6216\8005\901A\8FC7\7535\5B50\90AE\4EF6\5C06\6570\636E\53D1\9001\7ED9\60A8\81EA\5DF1\6216\5176\4ED6\4EBA\3002</p>'),
'',
unistr('<p>\5982\9700\4E86\89E3\8BE6\7EC6\4FE1\606F, \8BF7\53C2\9605 <em>Oracle Application Express End User''s Guide</em> \4E2D\7684 "Using Interactive Grids"\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284975876631873051)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO_HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6982\89C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284973559150873050)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\53EF\4EE5\4F7F\7528\5185\7F6E\529F\80FD\5B9A\5236\4EA4\4E92\5F0F\7F51\683C, \4F7F\5176\4EE5\5404\79CD\4E0D\540C\65B9\5F0F\663E\793A\6570\636E\3002</p>'),
'',
unistr('<p>\4F7F\7528\201C\5217\6807\9898\201D\83DC\5355\6216\201C\64CD\4F5C\201D\83DC\5355\53EF\786E\5B9A\8981\663E\793A\7684\5217, \4F7F\7528\4EC0\4E48\987A\5E8F\548C\51BB\7ED3\5217\3002\8FD8\53EF\4EE5\5B9A\4E49\5404\79CD\6570\636E\8FC7\6EE4\5668\5E76\5BF9\8FD4\56DE\7684\6570\636E\8FDB\884C\6392\5E8F\3002</p>'),
'',
unistr('<p>\4F7F\7528\201C\89C6\56FE\201D\6309\94AE (\9760\8FD1\201C\641C\7D22\201D\5B57\6BB5) \53EF\8BBF\95EE\53EF\80FD\7531\5E94\7528\7A0B\5E8F\5F00\53D1\8005\5B9A\4E49\7684\5176\4ED6\6570\636E\89C6\56FE\3002\8FD8\53EF\4EE5\521B\5EFA\56FE\8868\6216\67E5\770B\73B0\6709\56FE\8868\3002</p>  '),
'',
unistr('<p><em>\6CE8: \5728\4EA4\4E92\5F0F\7F51\683C\5BF9\8BDD\6846\4E2D\5355\51FB<strong>\5E2E\52A9</strong>\53EF\83B7\53D6\6709\5173\6240\9009\529F\80FD\7684\66F4\8BE6\7EC6\4FE1\606F\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284975938525873051)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING_HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\544A\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284518630841872721)
,p_name=>'APEX.IG.HELP.ACTIONS_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\4EA4\4E92\5F0F\7F51\683C\201D\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284970579883873048)
,p_name=>'APEX.IG.HELP.AGGREGATE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\4EE5\805A\96C6\5217\3002\805A\96C6\503C\663E\793A\5728\6570\636E\7684\5E95\90E8; \5728\5B9A\4E49\4E86\63A7\5236\5206\6BB5\7684\60C5\51B5\4E0B, \663E\793A\5728\6BCF\4E2A\5206\6BB5\7684\5E95\90E8\3002</p>'),
'',
unistr('<p><strong>\201C\805A\96C6\201D\5217\8868</strong><br>'),
unistr('\201C\805A\96C6\201D\5217\8868\663E\793A\5DF2\5B9A\4E49\7684\805A\96C6\3002\53D6\6D88\9009\62E9\4E00\4E2A\73B0\6709\805A\96C6\53EF\7981\7528\8BE5\805A\96C6\3002<br>'),
unistr('\5355\51FB\201C\6DFB\52A0\201D( &plus; ) \53EF\521B\5EFA\65B0\805A\96C6, \6216\8005\5355\51FB\201C\5220\9664\201D( &minus; ) \53EF\5220\9664\73B0\6709\805A\96C6\3002</p>'),
'',
unistr('<p><strong>\805A\96C6\8BBE\7F6E</strong><br>'),
unistr('\4F7F\7528\53F3\4FA7\7684\8868\5355\53EF\5B9A\4E49\805A\96C6\3002<br>'),
unistr('\9009\62E9\5217\540D\548C\805A\96C6\7C7B\578B\3002<br>'),
unistr('(\53EF\9009) \8F93\5165\805A\96C6\7684\5DE5\5177\63D0\793A\3002<br>'),
unistr('\5982\679C\5B9A\4E49\4E86\63A7\5236\5206\6BB5, \5219\9009\62E9<strong>\663E\793A\603B\4F53\503C</strong>\5C06\5728\6570\636E\5E95\90E8\663E\793A\603B\4F53\5E73\5747\503C, \603B\8BA1\6216\7C7B\4F3C\503C\3002</p>'),
'',
unistr('<p><em>\6CE8: \5728\201C\64CD\4F5C\201D\83DC\5355\4E2D\8BBF\95EE\201C\805A\96C6\201D\5BF9\8BDD\6846, \6216\8005\901A\8FC7\5355\51FB\5217\6807\9898\548C\201C\603B\548C\201D( &sum; ) \6765\8BBF\95EE\8BE5\5BF9\8BDD\6846\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284974950653873051)
,p_name=>'APEX.IG.HELP.AGGREGATE_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\805A\96C6\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284971210970873048)
,p_name=>'APEX.IG.HELP.CHART'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\4EE5\5B9A\4E49\663E\793A\4E3A\5355\72EC\6570\636E\89C6\56FE\7684\56FE\8868\3002<br> '),
unistr('\9009\62E9\56FE\8868\7C7B\578B, \914D\7F6E\56FE\8868\8BBE\7F6E, \7136\540E\5355\51FB<strong>\4FDD\5B58</strong>\3002</p>'),
'',
unistr('<p><strong>\56FE\8868\8BBE\7F6E</strong></br>'),
unistr('\663E\793A\7684\56FE\8868\5C5E\6027\6839\636E\56FE\8868\7C7B\578B\800C\4E0D\540C\3002\53EF\4EE5\8F93\5165\591A\79CD\5C5E\6027\6765\5B9A\4E49\56FE\8868\3002\4F7F\7528\7EA2\8272\661F\53F7\6807\8BB0\7684\5C5E\6027\662F\5FC5\9700\5C5E\6027\3002</p>'),
'',
unistr('<p>\4E0B\9762\662F\5728\4E0D\540C\56FE\8868\7C7B\578B\4E2D\53EF\7528\7684\5168\90E8\5C5E\6027 (\6309\5B57\6BCD\987A\5E8F):'),
'<ul>',
unistr('  <li>\805A\96C6 - \9009\62E9\5982\4F55\805A\96C6\5173\8054\7684\56FE\8868\503C\3002</li> '),
unistr('  <li>\6536\76D8\4EF7 - \9009\62E9\5305\542B\6BCF\65E5\80A1\7968\6536\76D8\4EF7\7684\5217 (\4EC5\9650\80A1\4EF7\56FE)\3002</li> '),
unistr('  <li>\5C0F\6570\4F4D\6570 - \8F93\5165\5C06\503C\820D\5165\5230\7684\5C0F\6570\4F4D\6570\3002</li> '),
unistr('  <li>\65B9\5411 - \4E0E\201C\6392\5E8F\65B9\5F0F\201D\5C5E\6027\76F8\5173, \6307\5B9A\6570\636E\6309\5347\5E8F\8FD8\662F\964D\5E8F\503C\6392\5E8F\3002</li> '),
unistr('  <li>\6700\9AD8\4EF7 - \9009\62E9\5305\542B\6700\9AD8\4EF7\503C\7684\5217 (\4EC5\9650\8303\56F4\56FE\548C\80A1\4EF7\56FE)\3002</li> '),
unistr('  <li>\6807\7B7E - \9009\62E9\5305\542B\5404\6570\636E\70B9\7684\6587\672C\7684\5217\3002</li> '),
unistr('  <li>\6807\7B7E\8F74\6807\9898 - \8F93\5165\663E\793A\5728\6807\7B7E\8F74\4E0A\7684\6807\9898\3002</li> '),
unistr('  <li>\6700\4F4E\4EF7 - \9009\62E9\5305\542B\6700\4F4E\4EF7\503C\7684\5217 (\4EC5\9650\8303\56F4\56FE\548C\80A1\4EF7\56FE)\3002</li> '),
unistr('  <li>\7A7A\503C - \4E0E\201C\6392\5E8F\65B9\5F0F\201D\5C5E\6027\76F8\5173, \6307\5B9A\7A7A\503C\8BB0\5F55\76F8\5BF9\4E8E\975E\7A7A\503C\8BB0\5F55\7684\6392\5E8F\65B9\5F0F\3002</li> '),
unistr('  <li>\5F00\76D8\4EF7 - \9009\62E9\5305\542B\6BCF\65E5\80A1\7968\5F00\76D8\4EF7\7684\5217 (\4EC5\9650\80A1\4EF7\56FE)\3002</li> '),
unistr('  <li>\65B9\5411 - \9009\62E9\662F\5782\76F4\8FD8\662F\6C34\5E73\663E\793A\56FE\8868\5143\7D20 (\4F8B\5982\6761\5F62)\3002</li> '),
unistr('  <li>\7CFB\5217 - \9009\62E9\7528\4E8E\5B9A\4E49\591A\7CFB\5217\52A8\6001\67E5\8BE2\7684\5217\3002</li> '),
unistr('  <li>\5806\53E0 - \6307\5B9A\6570\636E\9879\662F\5426\5806\53E0\3002</li> '),
unistr('  <li>\6392\5E8F\65B9\5F0F - \9009\62E9\56FE\8868\662F\6309\6807\7B7E\8FD8\662F\503C\6392\5E8F\3002</li> '),
unistr('  <li>\76EE\6807 - \9009\62E9\8981\7528\4E8E\5728\6B64\56FE\8868\4E0A\5B9A\4E49\76EE\6807\503C\7684\5217\3002\8BBE\7F6E\6B64\9879\65F6,\201C\503C\201D\5C5E\6027\5B9A\4E49\5207\7247\4E2D\7684\586B\5145\533A\57DF, \800C\201C\76EE\6807\201D\8868\793A\6574\4E2A\5207\7247\7684\503C (\4EC5\9650\6F0F\6597\56FE)\3002</li> '),
unistr('  <li>\503C - \9009\62E9\5305\542B\8981\7ED8\5236\7684\6570\636E\7684\5217\3002</li> '),
unistr('  <li>\503C\8F74\6807\9898 - \8F93\5165\663E\793A\5728\503C\8F74\4E0A\7684\6807\9898\3002</li> '),
unistr('  <li>\6210\4EA4\91CF - \9009\62E9\5305\542B\6BCF\65E5\80A1\7968\6210\4EA4\91CF\7684\5217 (\4EC5\9650\80A1\4EF7\56FE)\3002</li> '),
unistr('  <li>X - \9009\62E9\5305\542B\6B64\56FE\8868\7684 x \8F74\503C\7684\5217 (\4EC5\9650\6C14\6CE1\56FE\548C\6563\70B9\56FE)\3002</li> '),
unistr('  <li>Y - \9009\62E9\5305\542B\6B64\56FE\8868\7684 y \8F74\503C\7684\5217 (\4EC5\9650\6C14\6CE1\56FE\548C\6563\70B9\56FE)\3002</li> '),
unistr('  <li>Z - \9009\62E9\5305\542B\6761\5BBD\5EA6\6216\6C14\6CE1\534A\5F84\7684\5217 (\4EC5\9650\6761\5F62\56FE, \6C14\6CE1\56FE\548C\8303\56F4\56FE)\3002</li> '),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284975387724873051)
,p_name=>'APEX.IG.HELP.CHART_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284970253323873047)
,p_name=>'APEX.IG.HELP.COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\4EE5\9009\62E9\663E\793A\54EA\4E9B\5217\4EE5\53CA\6309\7167\4EC0\4E48\987A\5E8F\663E\793A\3002</p>'),
'',
unistr('<p>\53D6\6D88\9009\62E9\67D0\5217\53EF\9690\85CF\8BE5\5217\3002<br>'),
unistr('\901A\8FC7\5355\51FB\201C\4E0A\79FB\201D( &uarr; ) \6216\4E0B\79FB ( &darr; ) \6765\5BF9\5217\91CD\65B0\6392\5E8F\3002<br>'),
unistr('\4F7F\7528\4E0B\62C9\9009\62E9\5668\53EF\5217\51FA\6240\6709\5217, \663E\793A\7684\5217\6216\672A\663E\793A\7684\5217\3002</p>'),
'',
unistr('<p>(\53EF\9009) \4F7F\7528\8868\5355\53EF\6307\5B9A\5217\7684\6700\5C0F\5BBD\5EA6, \4EE5\50CF\7D20\4E3A\5355\4F4D\3002</p>'),
'',
unistr('<p><em>\6CE8: \901A\8FC7\5355\51FB\62D6\52A8\624B\67C4 (\4F4D\4E8E\5217\6807\9898\7684\5F00\5934) \5E76\5411\5DE6\6216\5411\53F3\62D6\52A8\5217, \4E5F\53EF\5BF9\6240\663E\793A\5217\91CD\65B0\6392\5E8F\3002\8FD8\53EF\4EE5\901A\8FC7\9009\62E9\4F4D\4E8E\6807\9898\4E4B\95F4\7684\5217\5206\9694\7B26\5E76\5C06\5176\5411\5DE6\6216\5411\53F3\79FB\52A8, \6765\66F4\6539\6240\663E\793A\5217\7684\5217\5BBD\3002</em</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284975292927873051)
,p_name=>'APEX.IG.HELP.COLUMNS_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284970665956873048)
,p_name=>'APEX.IG.HELP.COMPUTE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\4EE5\57FA\4E8E\5BF9\73B0\6709\5217\6267\884C\7684\6570\5B66\548C\51FD\6570\8BA1\7B97\5B9A\4E49\989D\5916\7684\5217\3002</p>'),
'',
unistr('<p><strong>\201C\8BA1\7B97\201D\5217\8868</strong><br>'),
unistr('\201C\8BA1\7B97\201D\5217\8868\663E\793A\5DF2\5B9A\4E49\7684\8BA1\7B97\3002\53D6\6D88\9009\62E9\4E00\4E2A\73B0\6709\8BA1\7B97\53EF\7981\7528\8BE5\8BA1\7B97\3002<br>'),
unistr('\5355\51FB\201C\6DFB\52A0\201D( &plus; ) \53EF\6DFB\52A0\65B0\8BA1\7B97, \6216\8005\5355\51FB\201C\5220\9664\201D( &minus; ) \53EF\5220\9664\73B0\6709\8BA1\7B97\3002</p>'),
'',
unistr('<p><strong>\8BA1\7B97\8BBE\7F6E</strong><br>'),
unistr('\4F7F\7528\8868\5355\53EF\5B9A\4E49\8BA1\7B97\3002<br>'),
unistr('\8F93\5165\5217\8BE6\7EC6\4FE1\606F, \4F8B\5982\6807\9898, \6807\7B7E, \7136\540E\9009\62E9\5BF9\9F50\8BBE\7F6E\3002<br> '),
unistr('\4F7F\7528\201C\8868\8FBE\5F0F\201D\6587\672C\533A\57DF\4E3A\8BA1\7B97\8F93\5165\5217\548C\5173\8054\7684\51FD\6570\3002<br>'),
unistr('\4E3A\65B0\5217\9009\62E9\76F8\5E94\7684\6570\636E\7C7B\578B, (\53EF\9009) \5E76\9009\62E9\683C\5F0F\63A9\7801\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284974859970873051)
,p_name=>'APEX.IG.HELP.COMPUTE_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284970958552873048)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\4EE5\5728\4E00\5217\6216\591A\5217\4E0A\5B9A\4E49\63A7\5236\5206\6BB5\3002</p>'),
'',
unistr('<p><strong>\201C\63A7\5236\5206\6BB5\201D\5217\8868</strong><br>'),
unistr('\201C\63A7\5236\5206\6BB5\201D\5217\8868\663E\793A\5DF2\5B9A\4E49\7684\63A7\5236\5206\6BB5\3002\53D6\6D88\9009\62E9\4E00\4E2A\73B0\6709\63A7\5236\5206\6BB5\53EF\7981\7528\8BE5\63A7\5236\5206\6BB5\3002<br>'),
unistr('\5355\51FB\201C\6DFB\52A0\201D( &plus; ) \53EF\5728\63A7\5236\5206\6BB5\4E2D\5305\62EC\65B0\5217, \6216\8005\5355\51FB\201C\5220\9664\201D( &minus; ) \53EF\4ECE\63A7\5236\5206\6BB5\4E2D\5220\9664\73B0\6709\5217\3002<br>'),
unistr('\8981\5BF9\5217\91CD\65B0\6392\5E8F, \8BF7\5355\51FB\201C\4E0A\79FB\201D( &uarr; ) \6216\201C\4E0B\79FB\201D( &darr; ) \4EE5\5C06\6240\9009\5217\76F8\5BF9\4E8E\5176\4ED6\5217\4E0A\79FB\548C\4E0B\79FB\3002</p>'),
'',
unistr('<p><strong>\63A7\5236\5206\6BB5\8BBE\7F6E</strong><br>'),
unistr('\4F7F\7528\8868\5355\53EF\5B9A\4E49\63A7\5236\5206\6BB5\5217\3002<br>'),
unistr('\9009\62E9\4E00\4E2A\63A7\5236\5206\6BB5\5217, \6392\5E8F\65B9\5411\4EE5\53CA\7A7A\503C\5217 (\6CA1\6709\4EFB\4F55\503C\7684\5217) \7684\6392\5E8F\65B9\5F0F\3002</p>'),
'',
unistr('<p><em>\6CE8: \67E5\770B\4EA4\4E92\5F0F\7F51\683C\65F6, \53EF\4EE5\901A\8FC7\5355\51FB\201C\5217\6807\9898\201D\5E76\9009\62E9\63A7\5236\5206\6BB5\56FE\6807\6765\5B9A\4E49\63A7\5236\5206\6BB5\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284974580757873050)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63A7\5236\5206\6BB5\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284971185706873048)
,p_name=>'APEX.IG.HELP.DOWNLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\5C06\6240\6709\5F53\524D\884C\4E0B\8F7D\5230\5916\90E8\6587\4EF6\3002\8BE5\6587\4EF6\5C06\53EA\5305\542B\5F53\524D\663E\793A\7684\5217, \5E76\4F7F\7528\5E94\7528\5230\6570\636E\7684\6240\6709\8FC7\6EE4\5668\548C\6392\5E8F\3002</p>'),
'',
unistr('<p>\9009\62E9\6587\4EF6\683C\5F0F\5E76\5355\51FB\201C\4E0B\8F7D\201D\3002<br>'),
unistr('\6CE8: CSV \5C06\4E0D\5305\62EC\6587\672C\683C\5F0F\8BBE\7F6E, \4F8B\5982\805A\96C6\548C\63A7\5236\5206\6BB5\3002</p>'),
'',
unistr('<p>\8981\901A\8FC7\7535\5B50\90AE\4EF6\53D1\9001\6587\4EF6, \8BF7\9009\62E9\201C\4F5C\4E3A\7535\5B50\90AE\4EF6\53D1\9001\201D\5E76\8F93\5165\7535\5B50\90AE\4EF6\8BE6\7EC6\4FE1\606F (\6536\4EF6\4EBA, \4E3B\9898\548C\90AE\4EF6)\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284974363555873050)
,p_name=>'APEX.IG.HELP.DOWNLOAD_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\8F7D\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284970394551873047)
,p_name=>'APEX.IG.HELP.FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\4EE5\914D\7F6E\9650\5236\6240\8FD4\56DE\884C\7684\6570\636E\8FC7\6EE4\5668\3002</p>'),
'',
unistr('<p><strong>\201C\8FC7\6EE4\5668\201D\5217\8868</strong><br>'),
unistr('\201C\8FC7\6EE4\5668\201D\5217\8868\663E\793A\5DF2\5B9A\4E49\7684\8FC7\6EE4\5668\3002\53D6\6D88\9009\62E9\4E00\4E2A\73B0\6709\8FC7\6EE4\5668\53EF\7981\7528\8BE5\8FC7\6EE4\5668\3002<br>'),
unistr('\5355\51FB\201C\6DFB\52A0\201D( &plus; ) \53EF\521B\5EFA\65B0\8FC7\6EE4\5668, \6216\8005\5355\51FB\201C\5220\9664\201D( &minus; ) \53EF\5220\9664\73B0\6709\8FC7\6EE4\5668\3002</p>'),
'',
unistr('<p><strong>\8FC7\6EE4\5668\8BBE\7F6E</strong><br>'),
unistr('\4F7F\7528\8868\5355\53EF\5B9A\4E49\8FC7\6EE4\5668\5C5E\6027\3002<br>'),
unistr('\9009\62E9\5408\9002\7684\8FC7\6EE4\5668\7C7B\578B:<br>'),
unistr('&nbsp;&nbsp;&nbsp;\884C - \8FC7\6EE4\4EFB\610F\53EF\8FC7\6EE4\5217\4E2D\7684\8BCD\8BED\3002<br>'),
unistr('&nbsp;&nbsp;&nbsp;\5217 - \4F7F\7528\6307\5B9A\7684\8FD0\7B97\7B26\548C\503C\8FC7\6EE4\7279\5B9A\5217\3002</p>'),
'',
unistr('<p><em>\6CE8: \67E5\770B\4EA4\4E92\5F0F\7F51\683C\65F6, \53EF\4EE5\901A\8FC7\76F4\63A5\5728\201C\641C\7D22\201D\5B57\6BB5\4E2D\952E\5165\6765\5B9A\4E49\884C\8FC7\6EE4\5668\3002\5355\51FB\201C\9009\62E9\8981\641C\7D22\7684\5217\201D\53EF\5C06\641C\7D22\8303\56F4\9650\5236\4E3A\7279\5B9A\5217\3002\6B64\5916, \6253\5F00\201C\5217\6807\9898\201D\83DC\5355\5E76\9009\62E9\4E00\4E2A\503C\53EF\4EE5\521B\5EFA\5217\8FC7\6EE4\5668\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284975111615873051)
,p_name=>'APEX.IG.HELP.FILTER_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284970790161873048)
,p_name=>'APEX.IG.HELP.FLASHBACK'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\4EE5\67E5\770B\4E4B\524D\7684\67D0\4E2A\65F6\95F4\70B9\4E0A\5B58\5728\7684\6570\636E\3002</p>'),
unistr('<p>\8F93\5165\8FC7\53BB\7684\5206\949F\6570\53EF\4EE5\6267\884C\95EA\56DE\67E5\8BE2\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284974703321873051)
,p_name=>'APEX.IG.HELP.FLASHBACK_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\95EA\56DE\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284975427281873051)
,p_name=>'APEX.IG.HELP.GROUP_BY_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\7EC4\65B9\5F0F\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284970855414873048)
,p_name=>'APEX.IG.HELP.HIGHLIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\57FA\4E8E\8F93\5165\7684\6761\4EF6\7A81\51FA\663E\793A\6570\636E\884C\6216\5217\3002</p>'),
'',
unistr('<p><strong>\201C\7A81\51FA\663E\793A\201D\5217\8868</strong><br>'),
unistr('\201C\7A81\51FA\663E\793A\201D\5217\8868\663E\793A\5DF2\5B9A\4E49\7684\7A81\51FA\663E\793A\3002\53D6\6D88\9009\62E9\4E00\4E2A\73B0\6709\7684\7A81\51FA\663E\793A\53EF\7981\7528\8BE5\7A81\51FA\663E\793A\3002<br>'),
unistr('\5355\51FB\201C\6DFB\52A0\201D( &plus; ) \53EF\521B\5EFA\65B0\7A81\51FA\663E\793A, \6216\8005\5355\51FB\201C\5220\9664\201D( &minus; ) \53EF\5220\9664\73B0\6709\7A81\51FA\663E\793A\3002</p>'),
'',
unistr('<p><strong>\7A81\51FA\663E\793A\8BBE\7F6E</strong><br>'),
unistr('\4F7F\7528\8868\5355\53EF\5B9A\4E49\7A81\51FA\663E\793A\5C5E\6027\3002<br>'),
unistr('\8F93\5165\540D\79F0, \9009\62E9\201C\884C\201D\6216\201C\5217\201D, \7136\540E\4E3A\80CC\666F\548C\6587\672C\9009\62E9 HTML \989C\8272\4EE3\7801\3002<br>'),
unistr('\9009\62E9\76F8\5E94\7684<strong>\6761\4EF6\7C7B\578B</strong>\53EF\7A81\51FA\663E\793A\7279\5B9A\6570\636E:<br>'),
unistr('&nbsp;&nbsp;&nbsp;\884C - \7A81\51FA\663E\793A\4EFB\610F\5217\4E2D\7684\5355\8BCD\3002<br>'),
unistr('&nbsp;&nbsp;&nbsp;\5217 - \6839\636E\6307\5B9A\7684\8FD0\7B97\7B26\548C\503C\7A81\51FA\663E\793A\7279\5B9A\5217\3002</p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284974603475873051)
,p_name=>'APEX.IG.HELP.HIGHLIGHT_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A81\51FA\663E\793A\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284971096087873048)
,p_name=>'APEX.IG.HELP.REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\4EE5\4FDD\5B58\5BF9\5F53\524D\7F51\683C\5E03\5C40\548C\914D\7F6E\8FDB\884C\7684\66F4\6539\3002<br>'),
unistr('\5E94\7528\7A0B\5E8F\5F00\53D1\8005\53EF\4EE5\5B9A\4E49\591A\4E2A\66FF\4EE3\62A5\8868\5E03\5C40\3002\5728\5141\8BB8\7684\60C5\51B5\4E0B, \60A8\548C\5176\4ED6\6700\7EC8\7528\6237\53EF\5C06\62A5\8868\4FDD\5B58\4E3A\201C\516C\5171\201D\62A5\8868, \8FD9\4F7F\5F97\8BE5\62A5\8868\5BF9\7F51\683C\7684\6240\6709\5176\4ED6\7528\6237\53EF\7528\3002\60A8\8FD8\53EF\4EE5\5C06\62A5\8868\4FDD\5B58\4E3A\53EA\6709\60A8\624D\80FD\67E5\770B\7684\201C\4E13\7528\201D\62A5\8868\3002</p>'),
unistr('<p>\4ECE\53EF\7528\7C7B\578B\4E2D\9009\62E9, \5E76\8F93\5165\6240\4FDD\5B58\62A5\8868\7684\540D\79F0\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284974428780873050)
,p_name=>'APEX.IG.HELP.REPORT_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\62A5\8868\5E2E\52A9'),
''))
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284970478430873048)
,p_name=>'APEX.IG.HELP.SORT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5BF9\8BDD\6846\53EF\4EE5\8BBE\7F6E\663E\793A\987A\5E8F\3002</p>'),
'',
unistr('<p><strong>\201C\6392\5E8F\201D\5217\8868</strong><br>'),
unistr('\201C\6392\5E8F\201D\5BF9\8BDD\6846\663E\793A\5DF2\914D\7F6E\6392\5E8F\89C4\5219\7684\5217\8868\3002<br>'),
unistr('\5355\51FB\201C\6DFB\52A0\201D( &plus; ) \53EF\521B\5EFA\6392\5E8F\5217, \6216\8005\5355\51FB\201C\5220\9664\201D( &minus; ) \53EF\5220\9664\6392\5E8F\5217\3002<br>'),
unistr('\5355\51FB\201C\4E0A\79FB\201D( &uarr; ) \548C\201C\4E0B\79FB\201D( &darr; ) \53EF\5C06\6240\9009\6392\5E8F\5217\76F8\5BF9\4E8E\5176\4ED6\6392\5E8F\5217\4E0A\79FB\548C\4E0B\79FB\3002</p>'),
'',
unistr('<p><strong>\6392\5E8F\8BBE\7F6E</strong><br>'),
unistr('\9009\62E9\4E00\4E2A\6392\5E8F\5217, \6392\5E8F\65B9\5411\4EE5\53CA\7A7A\503C\5217 (\6CA1\6709\4EFB\4F55\503C\7684\5217) \7684\6392\5E8F\65B9\5F0F</p>'),
'',
unistr('<p><em>\6CE8: \6570\636E\53EA\80FD\6309\7167\672A\663E\793A\7684\5217\6392\5E8F\3002\4F46\662F, \5E76\975E\6240\6709\5217\5747\53EF\6392\5E8F\3002</em><br>'),
unistr('<em>\663E\793A\7684\5217\53EA\80FD\901A\8FC7\6309\5217\6807\9898\672B\5C3E\7684\4E0A\7BAD\5934 (\5347\5E8F) \6216\4E0B\7BAD\5934 (\964D\5E8F) \6765\6392\5E8F\3002\8981\5C06\540E\7EED\7684\5217\6DFB\52A0\5230\73B0\6709\6392\5E8F\4E2D, \8BF7\6309\4F4F Shift \952E\5E76\5355\51FB\4E0A\7BAD\5934\6216\4E0B\7BAD\5934\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284975092994873051)
,p_name=>'APEX.IG.HELP.SORT_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284974252265873050)
,p_name=>'APEX.IG.HELP.SUBSCRIPTION_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA2\9605\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284519529300872722)
,p_name=>'APEX.IG.HIDE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9690\85CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284252547364872529)
,p_name=>'APEX.IG.HIGHLIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A81\51FA\663E\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284945613698873029)
,p_name=>'APEX.IG.HIGH_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\9AD8\4EF7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284946415636873030)
,p_name=>'APEX.IG.HORIZONTAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6C34\5E73')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284495712919872705)
,p_name=>'APEX.IG.HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C0F\65F6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284513445072872717)
,p_name=>'APEX.IG.ICON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\6807')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284251416156872528)
,p_name=>'APEX.IG.ICON_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\6807\89C6\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284493780561872704)
,p_name=>'APEX.IG.IN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284519160216872721)
,p_name=>'APEX.IG.INACTIVE_SETTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\6D3B\52A8\8BBE\7F6E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284519224938872721)
,p_name=>'APEX.IG.INACTIVE_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\6D3B\52A8\8BBE\7F6E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284566586590872754)
,p_name=>'APEX.IG.INTERNAL_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\4EA4\4E92\5F0F\7F51\683C\8BF7\6C42\65F6\51FA\73B0\5185\90E8\9519\8BEF\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284973789207873050)
,p_name=>'APEX.IG.INVALID_DATE_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\671F\683C\5F0F\65E0\6548')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284984366860873058)
,p_name=>'APEX.IG.INVALID_SETTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6548\7684\8BBE\7F6E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284984425192873058)
,p_name=>'APEX.IG.INVALID_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6548\7684\8BBE\7F6E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284960150729873040)
,p_name=>'APEX.IG.INVALID_SORT_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F\65B9\5F0F\5DF2\8BBE\7F6E\4E3A %0, \4F46\6CA1\6709\4E3A %0 \9009\62E9\4EFB\4F55\5217\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284953290102873035)
,p_name=>'APEX.IG.INVALID_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6548\7684\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284941440757873026)
,p_name=>'APEX.IG.INVISIBLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\663E\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284494576395872705)
,p_name=>'APEX.IG.IN_THE_LAST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\8FC7\53BB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284494713172872705)
,p_name=>'APEX.IG.IN_THE_NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\672A\6765')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284493644542872704)
,p_name=>'APEX.IG.IS_NOT_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\4E3A\7A7A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284493572876872704)
,p_name=>'APEX.IG.IS_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\7A7A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284961431440873041)
,p_name=>'APEX.IG.LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284944920830873029)
,p_name=>'APEX.IG.LABEL_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284952487596873034)
,p_name=>'APEX.IG.LAST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\540E\4E00\4E2A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284392435468872631)
,p_name=>'APEX.IG.LAST.DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB 1 \5929')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284392607573872631)
,p_name=>'APEX.IG.LAST.HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB 1 \5C0F\65F6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284393196375872632)
,p_name=>'APEX.IG.LAST.MINUTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB 1 \5206\949F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284392129271872631)
,p_name=>'APEX.IG.LAST.MONTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E2A\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284392217413872631)
,p_name=>'APEX.IG.LAST.WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\5468')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284392300520872631)
,p_name=>'APEX.IG.LAST.X_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB %0 \5929')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284392507388872631)
,p_name=>'APEX.IG.LAST.X_HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB %0 \5C0F\65F6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284393217668872632)
,p_name=>'APEX.IG.LAST.X_MINUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB %0 \5206\949F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284393049588872632)
,p_name=>'APEX.IG.LAST.X_MONTHS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB %0 \4E2A\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284392972922872632)
,p_name=>'APEX.IG.LAST.X_WEEKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB %0 \5468')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284391969917872631)
,p_name=>'APEX.IG.LAST.X_YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB %0 \5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284392051172872631)
,p_name=>'APEX.IG.LAST.YEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53BB\5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284961611131873041)
,p_name=>'APEX.IG.LAYOUT_ALIGN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\5143\5BF9\9F50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284961775678873041)
,p_name=>'APEX.IG.LAYOUT_USEGROUPFOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\7EC4\7528\4E8E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284494102896872704)
,p_name=>'APEX.IG.LESS_THAN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C0F\4E8E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284494222603872704)
,p_name=>'APEX.IG.LESS_THAN_OR_EQUALS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C0F\4E8E\7B49\4E8E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284947049578873030)
,p_name=>'APEX.IG.LINE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EBF\5F62\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284947146584873030)
,p_name=>'APEX.IG.LINE_WITH_AREA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EBF\5F62\9762\79EF\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284962044872873041)
,p_name=>'APEX.IG.LISTAGG'
,p_message_language=>'zh-cn'
,p_message_text=>'Listagg'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284945780328873029)
,p_name=>'APEX.IG.LOW_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\4F4E\4EF7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284967651275873045)
,p_name=>'APEX.IG.MAILADDRESSES_COMMASEP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\9017\53F7\5206\9694\591A\4E2A\5730\5740')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284495385220872705)
,p_name=>'APEX.IG.MATCHES_REGULAR_EXPRESSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5339\914D\6B63\5219\8868\8FBE\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284859267835872965)
,p_name=>'APEX.IG.MAX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5927\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284988770224873061)
,p_name=>'APEX.IG.MAX_OVERALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\4F53\6700\5927\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284859479543872965)
,p_name=>'APEX.IG.MEDIAN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E2D\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284988883877873061)
,p_name=>'APEX.IG.MEDIAN_OVERALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\4F53\4E2D\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284859128028872965)
,p_name=>'APEX.IG.MIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5C0F\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284495676921872705)
,p_name=>'APEX.IG.MINUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\949F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284860952715872967)
,p_name=>'APEX.IG.MINUTES_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\949F\4E4B\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284988652343873061)
,p_name=>'APEX.IG.MIN_OVERALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\4F53\6700\5C0F\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284496220852872706)
,p_name=>'APEX.IG.MONTHS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284519481670872722)
,p_name=>'APEX.IG.MORE_DATA_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5305\542B\7684\884C\6570\8D85\8FC7\4E86 %0, \8FD9\8D85\8FC7\4E86\5141\8BB8\7684\6700\5927\503C\3002\8BF7\5E94\7528\5176\4ED6\8FC7\6EE4\5668\4EE5\4FBF\67E5\770B\7ED3\679C\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284511493796872716)
,p_name=>'APEX.IG.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\540D\79F0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284511632415872716)
,p_name=>'APEX.IG.NAMED_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\547D\540D\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284391397328872631)
,p_name=>'APEX.IG.NEXT.DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 1 \5929')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284391100718872630)
,p_name=>'APEX.IG.NEXT.HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 1 \5C0F\65F6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284393300238872632)
,p_name=>'APEX.IG.NEXT.MINUTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 1 \5206\949F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284391690557872631)
,p_name=>'APEX.IG.NEXT.MONTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E2A\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284391579974872631)
,p_name=>'APEX.IG.NEXT.WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\5468')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284391476179872631)
,p_name=>'APEX.IG.NEXT.X_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 %0 \5929')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284391279187872630)
,p_name=>'APEX.IG.NEXT.X_HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 %0 \5C0F\65F6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284393455942872632)
,p_name=>'APEX.IG.NEXT.X_MINUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 %0 \5206\949F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284392781339872632)
,p_name=>'APEX.IG.NEXT.X_MONTHS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 %0 \4E2A\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284392893661872632)
,p_name=>'APEX.IG.NEXT.X_WEEKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 %0 \5468')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284391800681872631)
,p_name=>'APEX.IG.NEXT.X_YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 %0 \5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284391740036872631)
,p_name=>'APEX.IG.NEXT.YEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E00\5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284494424386872704)
,p_name=>'APEX.IG.NOT_BETWEEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\4ECB\4E8E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284493452668872704)
,p_name=>'APEX.IG.NOT_EQUALS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\7B49\4E8E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285013878090873079)
,p_name=>'APEX.IG.NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('ID \4E3A %0 \7684\533A\57DF\4E0D\662F\4EA4\4E92\5F0F\7F51\683C\533A\57DF, \6216\8005\5728\5E94\7528\7A0B\5E8F %1 \4E2D\4E0D\5B58\5728\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284493888283872704)
,p_name=>'APEX.IG.NOT_IN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5728')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284494643033872705)
,p_name=>'APEX.IG.NOT_IN_THE_LAST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5728\8FC7\53BB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284494835352872705)
,p_name=>'APEX.IG.NOT_IN_THE_NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5728\672A\6765')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284519394106872721)
,p_name=>'APEX.IG.NO_DATA_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\6570\636E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284952247760873034)
,p_name=>'APEX.IG.NULLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A7A\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284962227147873041)
,p_name=>'APEX.IG.NUMBER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\5B57')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284952716224873034)
,p_name=>'APEX.IG.OFF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7981\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284952894692873034)
,p_name=>'APEX.IG.ON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284476837709872692)
,p_name=>'APEX.IG.ONE_MINUTE_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('1 \5206\949F\4E4B\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284969906834873047)
,p_name=>'APEX.IG.OPEN_COLORPICKER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6253\5F00\989C\8272\9009\62E9\5668: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284945491761873029)
,p_name=>'APEX.IG.OPEN_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\76D8\4EF7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284512581640872717)
,p_name=>'APEX.IG.OPERATOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD0\7B97\7B26')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284944828498873029)
,p_name=>'APEX.IG.ORIENTATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B9\5411')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284947285957873030)
,p_name=>'APEX.IG.PIE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\997C\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284513812417872718)
,p_name=>'APEX.IG.PIVOT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8\8868\5934')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284251763470872528)
,p_name=>'APEX.IG.PIVOT_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8\8868\5934\89C6\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284969870731873047)
,p_name=>'APEX.IG.PLACEHOLDER_INVALUES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528 "%0" \5206\9694\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284947300817873030)
,p_name=>'APEX.IG.POLAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6781\5750\6807\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284961168678873041)
,p_name=>'APEX.IG.POSITION_CENTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C45\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284961221637873041)
,p_name=>'APEX.IG.POSITION_END'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED3\5C3E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284961065000873041)
,p_name=>'APEX.IG.POSITION_START'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\5934')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284511700959872716)
,p_name=>'APEX.IG.PRIMARY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\8981')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284512056846872716)
,p_name=>'APEX.IG.PRIMARY_DEFAULT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\8981\9ED8\8BA4\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284807046738872927)
,p_name=>'APEX.IG.PRIMARY_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284947454157873031)
,p_name=>'APEX.IG.RADAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\96F7\8FBE\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284947510551873031)
,p_name=>'APEX.IG.RANGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8303\56F4\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284971348238873048)
,p_name=>'APEX.IG.REFRESH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5237\65B0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284520151810872722)
,p_name=>'APEX.IG.REFRESH_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5237\65B0\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284518954569872721)
,p_name=>'APEX.IG.REFRESH_ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5237\65B0\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284253222435872529)
,p_name=>'APEX.IG.REMOVE_CONTROL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284511175459872716)
,p_name=>'APEX.IG.REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285004565751873073)
,p_name=>'APEX.IG.REPORT.DELETED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5220\9664\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285004256890873072)
,p_name=>'APEX.IG.REPORT.SAVED.ALTERNATIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4E3A\6240\6709\7528\6237\4FDD\5B58\66FF\4EE3\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285004157001873072)
,p_name=>'APEX.IG.REPORT.SAVED.DEFAULT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4E3A\6240\6709\7528\6237\4FDD\5B58\9ED8\8BA4\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285004446998873072)
,p_name=>'APEX.IG.REPORT.SAVED.PRIVATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4FDD\5B58\4E13\7528\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285004375587873072)
,p_name=>'APEX.IG.REPORT.SAVED.PUBLIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4E3A\6240\6709\7528\6237\4FDD\5B58\516C\5171\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284476716714872692)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF.X.MINUTES_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5206\949F\4E4B\524D\7684\62A5\8868\6570\636E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284476603487872692)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF_ONE_MINUTE_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('1 \5206\949F\4E4B\524D\7684\62A5\8868\6570\636E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284975795449873051)
,p_name=>'APEX.IG.REPORT_EDIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\544A - \7F16\8F91')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284975602444873051)
,p_name=>'APEX.IG.REPORT_SAVE_AS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868 - \53E6\5B58\4E3A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284253330549872530)
,p_name=>'APEX.IG.REPORT_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\8BBE\7F6E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285013901869873079)
,p_name=>'APEX.IG.REPORT_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\9759\6001 ID %0 \4FDD\5B58\7684\4EA4\4E92\5F0F\7F51\683C\4E0D\5B58\5728\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284988071761873060)
,p_name=>'APEX.IG.REPORT_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\89C6\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284252449739872529)
,p_name=>'APEX.IG.RESET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\7F6E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284520205431872722)
,p_name=>'APEX.IG.REVERT_CHANGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD8\539F\66F4\6539')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284519073164872721)
,p_name=>'APEX.IG.REVERT_ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD8\539F\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284512108383872717)
,p_name=>'APEX.IG.ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284511079961872716)
,p_name=>'APEX.IG.ROWS_PER_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\9875\884C\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285012508403873078)
,p_name=>'APEX.IG.ROW_ACTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\64CD\4F5C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285019773072873084)
,p_name=>'APEX.IG.ROW_ACTIONS_FOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C %0 \7684\64CD\4F5C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284252796590872529)
,p_name=>'APEX.IG.SAVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284595124870872773)
,p_name=>'APEX.IG.SAVED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4FDD\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284250919738872528)
,p_name=>'APEX.IG.SAVED_REPORTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4FDD\5B58\7684\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284251085628872528)
,p_name=>'APEX.IG.SAVED_REPORT_DEFAULT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284251151264872528)
,p_name=>'APEX.IG.SAVED_REPORT_PRIVATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E13\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284251209596872528)
,p_name=>'APEX.IG.SAVED_REPORT_PUBLIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\516C\5171')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284987794835873060)
,p_name=>'APEX.IG.SAVE_AS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53E6\5B58\4E3A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284518324811872721)
,p_name=>'APEX.IG.SAVE_REPORT_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58\62A5\8868\8BBE\7F6E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284947692821873031)
,p_name=>'APEX.IG.SCATTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6563\70B9\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284250812148872528)
,p_name=>'APEX.IG.SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284966489599873045)
,p_name=>'APEX.IG.SEARCH.ALL_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22: \6240\6709\6587\672C\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284250744553872528)
,p_name=>'APEX.IG.SEARCH.COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284965241585873044)
,p_name=>'APEX.IG.SEARCH.ORACLE_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22: \5168\6587')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284476557275872692)
,p_name=>'APEX.IG.SEARCH_FOR.X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22 ''%0''')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284941163655873026)
,p_name=>'APEX.IG.SELECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9 -')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284315367603872575)
,p_name=>'APEX.IG.SELECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284913992890873006)
,p_name=>'APEX.IG.SELECT_1_ROW_IN_MASTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\4E3B\533A\57DF\4E2D\9009\62E9 1 \884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284250670139872528)
,p_name=>'APEX.IG.SELECT_COLUMNS_TO_SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\8981\641C\7D22\7684\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285011530686873078)
,p_name=>'APEX.IG.SEL_ACTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\64CD\4F5C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284315530748872575)
,p_name=>'APEX.IG.SEL_MODE_CELL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\5143\9009\62E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284315432845872575)
,p_name=>'APEX.IG.SEL_MODE_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\9009\62E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284967034615873045)
,p_name=>'APEX.IG.SEND_AS_EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E3A\7535\5B50\90AE\4EF6\53D1\9001')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284950533122873033)
,p_name=>'APEX.IG.SERIES_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7CFB\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284211537264872499)
,p_name=>'APEX.IG.SHOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284826424166872942)
,p_name=>'APEX.IG.SHOW_OVERALL_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\603B\4F53\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284519803141872722)
,p_name=>'APEX.IG.SINGLE_ROW_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\884C\89C6\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284514078022872718)
,p_name=>'APEX.IG.SORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284950692409873033)
,p_name=>'APEX.IG.SORT_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F\65B9\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285012641642873079)
,p_name=>'APEX.IG.SORT_ONLY_ONE_PER_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\4E2A\5217\53EA\80FD\5B9A\4E49\4E00\4E2A\6392\5E8F\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285011779145873078)
,p_name=>'APEX.IG.SRV_CHANGE_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539\83DC\5355')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284952950244873035)
,p_name=>'APEX.IG.STACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5806\53E0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284495122572872705)
,p_name=>'APEX.IG.STARTS_WITH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\5934\4E3A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284947701088873031)
,p_name=>'APEX.IG.STOCK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\80A1\4EF7\56FE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284140262961872447)
,p_name=>'APEX.IG.STRETCH_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62C9\4F38\5217\5BBD\5EA6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284518556151872721)
,p_name=>'APEX.IG.SUBSCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA2\9605')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284859010693872965)
,p_name=>'APEX.IG.SUM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\548C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285019908805873084)
,p_name=>'APEX.IG.SUMMARY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EA4\4E92\5F0F\7F51\683C\3002\62A5\8868\FF1A%0\FF0C\89C6\56FE\FF1A%1\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284988120705873060)
,p_name=>'APEX.IG.SUM_OVERALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\4F53\603B\548C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284945925180873029)
,p_name=>'APEX.IG.TARGET_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\76EE\6807')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284960365386873040)
,p_name=>'APEX.IG.TEXT_COLOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\672C\989C\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284253411737872530)
,p_name=>'APEX.IG.TOGGLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5207\6362')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284826302494872941)
,p_name=>'APEX.IG.TOOLTIP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\5177\63D0\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284511225956872716)
,p_name=>'APEX.IG.TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7C7B\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284519787072872722)
,p_name=>'APEX.IG.UNFREEZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\89E3\9664\51BB\7ED3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284512784275872717)
,p_name=>'APEX.IG.UNIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\4F4D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284966819040873045)
,p_name=>'APEX.IG.UNSAVED_CHANGES_CONTINUE_CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B58\5728\672A\4FDD\5B58\7684\66F4\6539\3002\662F\5426\7EE7\7EED?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284512625331872717)
,p_name=>'APEX.IG.VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284945080235873029)
,p_name=>'APEX.IG.VALUE_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284954050485873035)
,p_name=>'APEX.IG.VALUE_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\63D0\4F9B\503C\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284898589657872994)
,p_name=>'APEX.IG.VALUE_TIMESTAMP_TZ'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\FF08\4E0D\80FD\66F4\6539\65F6\533A\FF09')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284962340088873042)
,p_name=>'APEX.IG.VARCHAR2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\672C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284946308505873030)
,p_name=>'APEX.IG.VERTICAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5782\76F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284510778114872716)
,p_name=>'APEX.IG.VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284941286804873026)
,p_name=>'APEX.IG.VISIBLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284945815924873029)
,p_name=>'APEX.IG.VOLUME_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6210\4EA4\91CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284496101118872706)
,p_name=>'APEX.IG.WEEKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5468')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284941320676873026)
,p_name=>'APEX.IG.WIDTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5C0F\5217\5BBD (\50CF\7D20)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284426316462872656)
,p_name=>'APEX.IG.X.BETWEEN.Y.AND.Z'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4ECB\4E8E %1 \548C %2 \4E4B\95F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284426091156872656)
,p_name=>'APEX.IG.X.CONTAINS.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5305\542B %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284426176293872656)
,p_name=>'APEX.IG.X.DOES_NOT_CONTAIN.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5305\542B %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284207735347872496)
,p_name=>'APEX.IG.X.DOES_NOT_START_WITH.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5F00\5934\4E0D\4E3A %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284424844624872655)
,p_name=>'APEX.IG.X.EQUALS.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \7B49\4E8E %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284425046498872655)
,p_name=>'APEX.IG.X.GREATER_THAN.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5927\4E8E %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284425168609872655)
,p_name=>'APEX.IG.X.GREATER_THAN_OR_EQUALS.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5927\4E8E\7B49\4E8E %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284425811728872656)
,p_name=>'APEX.IG.X.IN.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4F4D\4E8E %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284427055804872656)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 %1 \5929\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284426893518872656)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 %1 \5C0F\65F6\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284426615315872656)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MINUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 %1 \5206\949F\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284427439986872657)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MONTHS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 %1 \4E2A\6708\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284427284901872657)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.WEEKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 %1 \5468\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284427672553872657)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 %1 \5E74\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284426951205872656)
,p_name=>'APEX.IG.X.IN_THE_LAST_DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 1 \5929\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284426774219872656)
,p_name=>'APEX.IG.X.IN_THE_LAST_HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 1 \5C0F\65F6\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284426538544872656)
,p_name=>'APEX.IG.X.IN_THE_LAST_MINUTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 1 \5206\949F\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284427314770872657)
,p_name=>'APEX.IG.X.IN_THE_LAST_MONTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 1 \4E2A\6708\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284427133842872656)
,p_name=>'APEX.IG.X.IN_THE_LAST_WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 1 \5468\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284427554610872657)
,p_name=>'APEX.IG.X.IN_THE_LAST_YEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 1 \5E74\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284429406453872658)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 %1 \5929\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284429215692872658)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 %1 \5C0F\65F6\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284429044308872658)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 %1 \5206\949F\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284429843221872658)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 %1 \4E2A\6708\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284429668334872658)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 %1 \5468\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284430053869872659)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 %1 \5E74\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284429312405872658)
,p_name=>'APEX.IG.X.IN_THE_NEXT_DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 1 \5929\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284429141858872658)
,p_name=>'APEX.IG.X.IN_THE_NEXT_HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 1 \5C0F\65F6\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284428978683872658)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MINUTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 1 \5206\949F\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284429747521872658)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MONTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 1 \4E2A\6708\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284429568567872658)
,p_name=>'APEX.IG.X.IN_THE_NEXT_WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 1 \5468\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284429958152872659)
,p_name=>'APEX.IG.X.IN_THE_NEXT_YEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 1 \5E74\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284425537117872655)
,p_name=>'APEX.IG.X.IS_NOT_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\4E3A\7A7A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284425448816872655)
,p_name=>'APEX.IG.X.IS_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E3A\7A7A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284425298161872655)
,p_name=>'APEX.IG.X.LESS_THAN.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5C0F\4E8E %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284425374617872655)
,p_name=>'APEX.IG.X.LESS_THAN_OR_EQUALS.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5C0F\4E8E\7B49\4E8E %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284425600110872655)
,p_name=>'APEX.IG.X.LIKE.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \7C7B\4F3C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284426230915872656)
,p_name=>'APEX.IG.X.MATCHES_REGULAR_EXPRESSION.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5339\914D\6B63\5219\8868\8FBE\5F0F %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284476987631872693)
,p_name=>'APEX.IG.X.MINUTES_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5206\949F\4E4B\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284426478008872656)
,p_name=>'APEX.IG.X.NOT_BETWEEN.Y.AND.Z'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\4ECB\4E8E %1 \548C %2 \4E4B\95F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284424909357872655)
,p_name=>'APEX.IG.X.NOT_EQUALS.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\7B49\4E8E %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284425910330872656)
,p_name=>'APEX.IG.X.NOT_IN.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\4F4D\4E8E %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284428298932872657)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 %1 \5929\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284428030688872657)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 %1 \5C0F\65F6\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284427857413872657)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MINUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 %1 \5206\949F\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284428636268872658)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MONTHS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 %1 \4E2A\6708\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284428453856872657)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.WEEKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 %1 \5468\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284428808869872658)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 %1 \5E74\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284428159529872657)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 1 \5929\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284427907984872657)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 1 \5C0F\65F6\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284427750245872657)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MINUTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 1 \5206\949F\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284428517953872658)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MONTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 1 \4E2A\6708\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284428385621872657)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 1 \5468\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284428718527872658)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_YEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 1 \5E74\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284430655391872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 %1 \5929\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284430425260872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 %1 \5C0F\65F6\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284430260931872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 %1 \5206\949F\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284431042796872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 %1 \4E2A\6708\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284430859404872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 %1 \5468\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284431267130872660)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 %1 \5E74\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284430509217872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 1 \5929\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284430319325872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 1 \5C0F\65F6\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284430190867872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MINUTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 1 \5206\949F\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284430958151872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MONTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 1 \4E2A\6708\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284430738193872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 1 \5468\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284431127173872659)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_YEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 1 \5E74\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284425761147872655)
,p_name=>'APEX.IG.X.NOT_LIKE.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\7C7B\4F3C %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284486818458872699)
,p_name=>'APEX.IG.X.STARTS_WITH.Y'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4EE5 %1 \5F00\5934')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284945113671873029)
,p_name=>'APEX.IG.X_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>'X'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284496344606872706)
,p_name=>'APEX.IG.YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284945245740873029)
,p_name=>'APEX.IG.Y_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>'Y'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284945370714873029)
,p_name=>'APEX.IG.Z_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>'Z'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284965806161873044)
,p_name=>'APEX.IG_FORMAT_SAMPLE_1'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2016 \5E74 1 \6708 12 \65E5\661F\671F\4E00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284965989423873044)
,p_name=>'APEX.IG_FORMAT_SAMPLE_2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E00\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284966088383873044)
,p_name=>'APEX.IG_FORMAT_SAMPLE_3'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('16 \5C0F\65F6\4E4B\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284966184341873044)
,p_name=>'APEX.IG_FORMAT_SAMPLE_4'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('16 \5C0F\65F6\4E4B\5185')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283821981764872211)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6253\5370\652F\6301\5FC5\987B\4E3A STANDARD \6216 ADVANCED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283822088162872211)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\5220\9664\9884\914D\7684\7B2C\4E00\4E2A\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283710874134872127)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F ID \65E0\6548\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284248862959872526)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\5730\5740\65E0\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283691932468872112)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\5FC5\987B\662F\96F6\6216\6B63\6574\6570\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283822159112872211)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7AEF\53E3\53F7\65E0\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284284604305872552)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA2\9605 ID \65E0\6548\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283822217754872211)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Wallet \8DEF\5F84\683C\5F0F\5FC5\987B\4E3A\201Cfile:<filesystempath>\201D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283913682296872281)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\5DE5\4F5C\533A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283913580076872281)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A ID \65E0\6548\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283841114932872225)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9E\4F8B\53C2\6570 "%0" \7684\503C "%1" \4E0E\6B63\5219\8868\8FBE\5F0F "%2" \4E0D\5339\914D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283841008538872225)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9E\4F8B\53C2\6570 "%0" \5FC5\987B\6709\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283822315602872211)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\5B9E\4F8B\53C2\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284280203080872549)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283645677483872077)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\7801 (\4EC5\7528\4E8E\9488\5BF9\5DE5\4F5C\533A\7528\6237\5E10\6237\8D44\6599\6863\6848\5E93\8FDB\884C\9A8C\8BC1)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284565756309872753)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\7801 (\4EC5\7528\4E8E\9488\5BF9\5DE5\4F5C\533A\7528\6237\5E10\6237\8D44\6599\6863\6848\5E93\8FDB\884C\9A8C\8BC1)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284387216369872628)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\7801 (\4EC5\7528\4E8E\9488\5BF9\5DE5\4F5C\533A\7528\6237\5E10\6237\8D44\6599\6863\6848\5E93\8FDB\884C\9A8C\8BC1)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283967429275872321)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\7801 (\4EC5\7528\4E8E\9488\5BF9\5DE5\4F5C\533A\7528\6237\5E10\6237\8D44\6599\6863\6848\5E93\8FDB\884C\9A8C\8BC1)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284280101974872549)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\7801 (\4EC5\7528\4E8E\9488\5BF9\5DE5\4F5C\533A\7528\6237\5E10\6237\8D44\6599\6863\6848\5E93\8FDB\884C\9A8C\8BC1)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283824293783872212)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6253\5370\670D\52A1\5668\534F\8BAE\5FC5\987B\4E3A http \6216 https')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283824392583872212)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B9\6848\4E0D\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283824433517872213)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B9\6848\662F\53D7\9650\5236\7684')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283670590731872096)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283670337619872096)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\4E0D\518D\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284614925047872787)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\914D')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284895274592872992)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5361\7247')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283672419265872098)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\52A0\6CE8\91CA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283672368162872098)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CE8\91CA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283647124227872079)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283646927182872078)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\5426\786E\5B9E\8981\5220\9664\6B64\8BC4\8BBA?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284599386186872776)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\95EE\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283656704335872086)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\5426\786E\5B9E\8981\5220\9664\6B64\95EE\9898\FF1F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283674022123872099)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\6863')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283672906986872098)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\6863')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283647083593872079)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284822834684872939)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\6CE8\91CA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284822998229872939)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\95EE\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283671145778872097)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\6B64\5DE5\4F5C\533A\4E2D\4E0D\5B58\5728\6307\5B9A\7684\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283671524526872097)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C1D\8BD5\5220\9664\6CE8\91CA\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283671426545872097)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\6CE8\91CA\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283671723633872097)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\95EE\9898\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283671884080872097)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C1D\8BD5\5C06\95EE\9898\6807\8BB0\4E3A\5F85\5220\9664\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283671290043872097)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\6B64\5DE5\4F5C\533A\4E2D\6216\63D0\4F9B\7684\5E94\7528\7A0B\5E8F\4E2D\4E0D\5B58\5728\6307\5B9A\7684\9875\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283671698365872097)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\65E0\6743\5220\9664\6B64\6CE8\91CA\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283671974010872097)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\65E0\6743\5220\9664\6B64\95EE\9898\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283671396565872097)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\65E0\6743\66F4\6539\6B64\6CE8\91CA\7684\53EF\89C1\6027\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284831788328872945)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\68C0\67E5\6587\4EF6\5927\5C0F\65F6\51FA\73B0\95EE\9898\3002\8BF7\4E0E\7CFB\7EDF\7BA1\7406\5458\8054\7CFB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284831626067872945)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5176\4E2D\4E00\4E2A\6587\4EF6\5927\4E8E\6700\5927\6587\4EF6\5927\5C0F %0 \5B57\8282\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284831567325872945)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\6587\4EF6\5927\4E8E\6700\5927\6587\4EF6\5927\5C0F %0 \5B57\8282\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283647244926872079)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9690\85CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283673891504872099)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\50CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283672764176872098)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\50CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283670146470872096)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\7CFB\7EDF\4E2D\672A\627E\5230\7684\95EE\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283630870755872066)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\7528\6237\6DFB\52A0\9996\9009\9879')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283672559738872098)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9644\52A0\6587\4EF6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283672280076872097)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\89E3\51B3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284900810233872996)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283673590607872098)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\7A7A\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283673365025872098)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5176\4E2D\4E00\4E2A\6587\4EF6\4E3A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283672144582872097)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\89E3\51B3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283674624162872099)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6C38\4E45\5220\9664\6240\9009\9879')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284600271334872777)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\6E05\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283674515349872099)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6062\590D\6240\9009\9879')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283672608889872098)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\54CD\5E94\6A21\677F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283673404434872098)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\592A\5927\FF0C\65E0\6CD5\4E0A\8F7D\3002<br>\6587\4EF6\5FC5\987B\5C0F\4E8E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283673707778872099)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\652F\6301\7684\6587\4EF6\7C7B\578B\4E3A\FF1A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284826759806872942)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\54CD\5E94\6A21\677F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283673210768872098)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\6587\4EF6\4E3A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283673669816872099)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\662F\652F\6301\7684\6587\4EF6\7C7B\578B\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284539074224872735)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_language=>'zh-cn'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284539679675872735)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\6863\95EE\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284539186997872735)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6539\8FDB\8BF7\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284539228278872735)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\529F\80FD\8BF7\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284539527667872735)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B89\88C5\95EE\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284539425307872735)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6027\80FD\95EE\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284539365109872735)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B89\5168\95EE\9898 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284539795417872735)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\57F9\8BAD\95EE\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284540429941872736)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284540116784872736)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_language=>'zh-cn'
,p_message_text=>'CSS / HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284540204439872736)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A8\6001\64CD\4F5C/JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284539953480872736)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284540526397872736)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5916\90E8\7CFB\7EDF\96C6\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284540099607872736)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('REST \96C6\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284540343247872736)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B89\5168\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284539889868872736)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_language=>'zh-cn'
,p_message_text=>'UI / UX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284538998726872735)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\914D\7ED9\95EE\9898\7684\7C7B\522B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284538054678872734)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7C7B\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284538837147872735)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\95EE\9898\5F71\54CD\7684\529F\80FD\533A\57DF\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284538123483872734)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\529F\80FD\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284538726743872735)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\914D\7ED9\95EE\9898\7684\91CD\8981\6027\7EA7\522B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284538276923872734)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\8981\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284538641927872735)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\89E3\51B3\95EE\9898\6240\9700\7684\5DE5\4F5C\91CF\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284538389291872734)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284538504237872735)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\95EE\9898\5904\7406\8FDB\5EA6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284538432216872735)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FDB\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284540999726872736)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79EF\538B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284540667632872736)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E25\91CD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284540757765872736)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284540826882872736)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5E38')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284541021493872736)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\4E0D\89E3\51B3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284541171832872736)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F7B\677E\4FEE\590D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284541360435872736)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5927\91CF\5F00\53D1\5DE5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284541282529872736)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E00\822C\5DE5\4F5C\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284541782889872737)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\4FEE\590D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284541873699872737)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B8C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284541552014872737)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\66F4\591A\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284541608881872737)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\7B49\5F85\7B2C\4E09\65B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284541482543872737)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\5904\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284552134917872744)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\5220\9664\6B64\6807\7B7E\7EC4\FF0C\56E0\4E3A\5B83\7684\4E00\4E2A\6216\591A\4E2A\6210\5458\5206\914D\7ED9\67D0\4E2A\95EE\9898\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283672033720872097)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6807\8BB0\4EE5\4E0B\9879\7684\91CD\590D\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284599768686872777)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\914D\4EBA\5458')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284599635692872776)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284600137429872777)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CC\7A0B\7891')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284599555866872776)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\72B6\6001')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283669938469872096)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284542464561872737)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EE3\7801\51BB\7ED3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284542644417872737)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\7EC8\53D1\884C\7248')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284542594367872737)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('UI \51BB\7ED3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283674492536872099)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5411 %1 \6DFB\52A0\4E86\6CE8\91CA (%2)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283630564254872066)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\6539\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284556342165872747)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A %1 \4E2D\7684\95EE\9898\7F16\53F7 %0 \5DF2\66F4\6539\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284831423072872945)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C1A\672A\5B9A\4E49\6807\7B7E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283673152668872098)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5176\4ED6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283670670230872096)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283670472597872096)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\4E0D\518D\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284892728884872990)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\6E05\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284615002824872787)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283670236676872096)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4ECE\4EE5\4E0B\9879\4E2D\5220\9664\5E94\7528\7A0B\5E8F\548C\9875\5173\8054')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283670998457872096)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5220\9664\9644\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284866581583872971)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\5426\8981\5C06\5F53\524D\6CE8\91CA\66FF\6362\4E3A\6B64\6A21\677F\FF1F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284868503896872972)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\60A8\597D\FF01'),
'',
unistr('\8FD9\662F\60A8\7684\7B2C\4E00\4E2A\95EE\9898\FF01\60A8\53EF\4EE5\521B\5EFA\95EE\9898\4EE5\8DDF\8E2A\60A8\7684\6240\6709 APEX \9879\76EE\7684\4EFB\52A1\3001\529F\80FD\3001Bug \548C\53CD\9988\FF01\60A8\53EF\4EE5\5411\95EE\9898\6DFB\52A0\6807\7B7E\3001\6DFB\52A0\5206\914D\4EBA\5458\3001\8BBE\7F6E\91CC\7A0B\7891\FF0C\751A\81F3\53EF\4EE5\4F7F\7528 Markdown \7CBE\7B80\8BED\6CD5\5E94\7528\683C\5F0F\FF01'),
'',
unistr('\4E0B\9762\662F\53EF\4EE5\4F7F\7528 Markdown \6267\884C\7684\64CD\4F5C\7684\5FEB\901F\793A\4F8B\FF1A')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284868456116872972)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B22\8FCE\4F7F\7528 Oracle APEX \4E2D\7684\5C0F\7EC4\5F00\53D1\FF01')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284615355799872788)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283671010373872097)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\72B6\6001\8BBE\7F6E\4E3A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283647430299872079)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284868351207872972)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\66F4\591A...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283670771453872096)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\8BA2\9605')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284831823867872945)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A %1 \4E2D\7684 %0 \6709 %2 \4E2A\65B0\901A\77E5\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284535558605872733)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\4E8E\8BB0\5F55 Bug \7684\6A21\677F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284535460917872732)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Bug \6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284535353632872732)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\9884\671F\884C\4E3A**'),
unistr('- \544A\8BC9\6211\4EEC\60A8\8BA4\4E3A\5E94\8BE5\53D1\751F\7684\60C5\51B5\3002'),
'',
'',
unistr('**\5F53\524D\884C\4E3A**'),
unistr('- \544A\8BC9\6211\4EEC\53D1\751F\7684\60C5\51B5\3002'),
'',
'',
unistr('**\53D7\5F71\54CD\5BF9\8C61**'),
unistr('- \544A\8BC9\6211\4EEC\53D7\5F71\54CD\7684\4EBA\5458/\5185\5BB9\3002'),
'',
unistr('**\53EF\80FD\7684\89E3\51B3\65B9\6848**'),
unistr('- \5982\679C\53EF\4EE5\FF0C\8BF7\5BF9\60A8\4F1A\5982\4F55\4FEE\590D\6B64 Bug \63D0\4F9B\5EFA\8BAE\3002'),
'',
unistr('**\518D\73B0\6B65\9AA4**'),
unistr('- \63D0\4F9B\4E00\7EC4\6E05\6670\7684\518D\73B0\6B65\9AA4\FF0C\5305\62EC\5C4F\5E55\5FEB\7167\548C\4EE3\7801\7247\6BB5\FF08\5982\679C\9002\7528\FF09\3002'),
'1.',
'2.',
'3.',
'',
unistr('**\4E0A\4E0B\6587**'),
unistr('- Bug \53D1\751F\65F6\60A8\6B63\5728\5C1D\8BD5\5B8C\6210\7684\5185\5BB9\3002Bug \4EC5\5728\7279\5B9A\6761\4EF6\4E0B\53D1\751F\6216\5728\4E00\5929\4E2D\7684\7279\5B9A\65F6\95F4\53D1\751F\7B49\3002'),
'',
unistr('**\73AF\5883**'),
'',
unistr('- \7248\672C\FF1A'),
unistr('- \5E73\53F0\FF1A'),
unistr('- \5B50\7CFB\7EDF\FF1A'),
'',
'______',
'',
unistr('_**\6CE8\FF1A**\8981\5C06\95EE\9898\4E0E\5E94\7528\7A0B\5E8F\548C/\6216\9875\5173\8054\FF0C\8BF7\5148\8BB0\5F55\8BE5\95EE\9898\FF0C\7136\540E\4F7F\7528**\64CD\4F5C**\4E0B\62C9\5217\8868\6765\5173\8054\5E94\7528\7A0B\5E8F\548C\9875\3002_')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284536618988872733)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\63D0\51FA Bug\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284536511335872733)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\63D0\51FA Bug')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284536702464872733)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5DF2\5728\9002\5F53\7684\5916\90E8\7CFB\7EDF\4E2D\5F52\6863 **Bug**\3002'),
'',
unistr('- Bug \8DDF\8E2A\7CFB\7EDF\FF1A'),
unistr('- Bug ID\FF1A'),
unistr('- Bug \7684 URL\FF1A'),
'',
unistr('\6CE8\91CA\FF1A')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284535792815872733)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\4E8E\8BB0\5F55\529F\80FD\8BF7\6C42\7684\6A21\677F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284535616042872733)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\529F\80FD\8BF7\6C42\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284535839197872733)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\529F\80FD\6982\8981**'),
unistr(' - \63D0\4F9B\4E00\6BB5\6709\5173\529F\80FD\8BF7\6C42\7684\4E00\822C\6982\89C8\3002'),
'',
'',
unistr('**\4E0A\4E0B\6587**'),
unistr(' - \6B64\8BF7\6C42\662F\5426\4E0E\7279\5B9A\60C5\51B5\6216\8FC7\7A0B\76F8\5173\FF1F\4F8B\5982\FF0C\201C\5728 [...] \65F6\FF0C\6211\603B\662F\9047\5230\95EE\9898\201D'),
'',
'',
unistr(' - \8BF7\63D0\4F9B\4EFB\4F55\652F\6301\4FE1\606F\FF0C\5305\62EC\5C4F\5E55\5FEB\7167\548C\7528\4F8B\7B49\3002'),
'',
'',
unistr('**\9996\9009\89E3\51B3\65B9\6848**'),
unistr('- \6E05\695A\5730\63CF\8FF0\60A8\5E0C\671B\770B\5230\7684\5B9E\65BD\5185\5BB9\3002'),
'',
'',
unistr('**\66FF\4EE3\89E3\51B3\65B9\6848**'),
unistr('- \63CF\8FF0\8003\8651\7684\66FF\4EE3\89E3\51B3\65B9\6848\6216\529F\80FD\FF0C\6216\8005\4F7F\7528\7684\89E3\51B3\65B9\6CD5\3002'),
'',
'',
'______',
unistr('_**\6CE8\FF1A**\8981\5C06\95EE\9898\4E0E\5E94\7528\7A0B\5E8F\548C/\6216\9875\5173\8054\FF0C\8BF7\5148\8BB0\5F55\8BE5\95EE\9898\FF0C\7136\540E\4F7F\7528**\64CD\4F5C**\4E0B\62C9\5217\8868\6765\5173\8054\5E94\7528\7A0B\5E8F\548C\9875\3002_')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284536919014872733)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5F52\6863\529F\80FD\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284536804123872733)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5F52\6863\529F\80FD\8BF7\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284537023281872734)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5DF2\5728\9002\5F53\7684\5916\90E8\7CFB\7EDF\4E2D\5F52\6863**\529F\80FD\8BF7\6C42**\3002'),
'',
unistr('- \529F\80FD\8DDF\8E2A\7CFB\7EDF\FF1A'),
unistr('- \529F\80FD ID\FF1A'),
unistr('- \529F\80FD\5B9A\4E49\7684 URL\FF1A'),
'',
unistr('\6CE8\91CA\FF1A')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284537810115872734)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\540E\7EED\64CD\4F5C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284537742824872734)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\540E\7EED\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284537938055872734)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8BF7\6267\884C\4EE5\4E0B\64CD\4F5C\FF1A'),
'',
'1.',
'2.',
'3.',
'4.',
'',
unistr('\6CE8\91CA\FF1A')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284536075069872733)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\4E8E\63D0\51FA\8FC7\7A0B\95EE\9898\7684\6A21\677F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284535973302872733)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E2E\52A9\4E3B\9898 ...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284536127657872733)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\95EE\9898**'),
unistr('- \5C3D\53EF\80FD\7B80\660E\5730\9648\8FF0\60A8\7684\95EE\9898\6216\8BF7\6C42\3002'),
'',
unistr('**\4E00\822C\4E0A\4E0B\6587**'),
unistr('- \60A8\5C1D\8BD5\6267\884C\4EC0\4E48\64CD\4F5C\FF1F'),
'',
'',
unistr('- \60A8\662F\5426\5728\5176\4ED6\4EC0\4E48\5730\65B9\67E5\627E\8FC7\6216\60A8\8054\7CFB\8FC7\5176\4ED6\4EC0\4E48\4EBA\6765\67E5\627E\7B54\6848\FF1F'),
'',
'',
unistr('**\73AF\5883** '),
unistr('\6B64\95EE\9898\662F\5426\4E0E\73AF\5883\3001\7F16\7A0B\8BED\8A00\6216\5176\4ED6\65B9\9762\7279\5B9A\76F8\5173\FF1F'),
'',
'______',
unistr('_**\6CE8\FF1A**\8981\5C06\95EE\9898\4E0E\5E94\7528\7A0B\5E8F\548C/\6216\9875\5173\8054\FF0C\8BF7\5148\8BB0\5F55\8BE5\95EE\9898\FF0C\7136\540E\4F7F\7528**\64CD\4F5C**\4E0B\62C9\5217\8868\6765\5173\8054\5E94\7528\7A0B\5E8F\548C\9875\3002_')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284537597556872734)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53C2\8003\5DF2\77E5\95EE\9898\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284537414808872734)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\77E5\95EE\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284537638926872734)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7ECF\8FC7\590D\67E5\FF0C\786E\5B9A\8FD9\662F\5DF2\77E5\95EE\9898\FF0C\8BF7\53C2\89C1\4EE5\4E0B\8BE6\7EC6\4FE1\606F\3002'),
'',
unistr('- Bug \8DDF\8E2A\7CFB\7EDF\FF1A'),
unistr('- Bug ID\FF1A'),
unistr('- Bug \7684 URL\FF1A'),
'',
unistr('\6CE8\91CA\FF1A')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284537242441872734)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\63D0\4F9B\66F4\591A\4FE1\606F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284537173283872734)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\66F4\591A\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284537339879872734)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\6B64\95EE\9898\9700\8981\66F4\591A\4FE1\606F\FF1A**'),
'',
unistr('\8BF7\63D0\4F9B\4E0B\9762\8981\6C42\7684\4FE1\606F\3002\5982\679C\6CA1\6709\6B64\4FE1\606F\FF0C\5C06\5F88\96BE\5BF9\95EE\9898\8FDB\884C\9274\522B\5206\7C7B\5E76\8FDB\4E00\6B65\89E3\51B3\95EE\9898\3002'),
'',
'',
unistr('\6CE8\91CA\FF1A')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284536328443872733)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\4E0D\5BF9\6B64\95EE\9898\8FDB\884C\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284536246600872733)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284536497219872733)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7ECF\8FC7\4ED4\7EC6\8003\8651\540E\FF0C**\5C06\4E0D\5BF9\6B64\95EE\9898\91C7\53D6\8FDB\4E00\6B65\64CD\4F5C**\3002'),
'',
unistr('\6CE8\91CA\FF1A')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283674100373872099)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\672C\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283673048149872098)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\672C\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283669842240872096)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\95EE\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284557438218872747)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\5C06\9644\4EF6 %0 \6DFB\52A0\5230 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284556427683872747)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\5C06 %0 \6DFB\52A0\5230 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284558072382872748)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\5C06 %0 \6DFB\52A0\5230 %1				')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284556652329872747)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\5C06 %0 \5206\914D\7ED9 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284557033884872747)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\5C06 %0 \4E0E %1 \5173\8054')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283674345828872099)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\4E86 %0 \7684\6CE8\91CA	(%1)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284557924483872748)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\95EE\9898\5DF2\88AB\9690\85CF\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284556840650872747)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\5C06 %0 \6807\8BB0\4E3A %1 \7684\91CD\590D\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284557830700872748)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6253\5F00 %0\FF0C\6253\5F00\8005\FF1A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284557536647872748)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\4ECE %1 \4E2D\5220\9664\9644\4EF6 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284556502533872747)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\4ECE %1 \4E2D\5220\9664 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284558105602872748)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\4ECE %1 \4E2D\5220\9664 %0 			')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284557655564872748)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\5C06 %0 \7684\72B6\6001\8BBE\7F6E\4E3A %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284557243480872747)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%1 \5DF2\8BA2\9605 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284556775888872747)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%2 \5DF2\4ECE %1 \53D6\6D88\5206\914D %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284557181521872747)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%1 \5DF2\4ECE %0 \5220\9664\5E94\7528\7A0B\5E8F\548C\9875\5173\8054')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284556926729872747)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5C06 %0 \53D6\6D88\6807\8BB0\4E3A\91CD\590D %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284557329823872747)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%1 \5DF2\53D6\6D88\8BA2\9605 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284557785940872748)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%1 \5DF2\7531 %2 \6807\8BB0\4E3A %0 \7684\91CD\590D\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283670036801872096)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5206\914D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283647364939872079)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88\9690\85CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283670844568872096)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\8BA2\9605')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284599489752872776)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\65B0...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283673988728872099)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Zip \6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283672867248872098)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Zip \6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284905702728873000)
,p_name=>'APEX.ITEM.FILE.BROWSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D4F\89C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284903613821872998)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284903772889872998)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285008603185873076)
,p_name=>'APEX.ITEM.HELP_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E2E\52A9\6587\672C: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284861757452872967)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\627E\4E0D\5230\9879 %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283657457154872086)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \4E0D\5728\6709\6548\8303\56F4 %0 \5230 %1 \5185\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283657599950872086)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_MULTIPLE_OF_STEP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \4E0D\662F %0 \7684\500D\6570\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283656808599872086)
,p_name=>'APEX.ITEM_TYPE.YES_NO.INVALID_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \5FC5\987B\4E0E\503C %0 \548C %1 \5339\914D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283657028678872086)
,p_name=>'APEX.ITEM_TYPE.YES_NO.NO_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5426')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284316664653872576)
,p_name=>'APEX.ITEM_TYPE.YES_NO.OFF_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7981\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284316744926872576)
,p_name=>'APEX.ITEM_TYPE.YES_NO.ON_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283656948953872086)
,p_name=>'APEX.ITEM_TYPE.YES_NO.YES_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283628054446872064)
,p_name=>'APEX.LIST_MANAGER.ADD_ENTRY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284573501167872759)
,p_name=>'APEX.LIST_MANAGER.BUTTON_ADD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284573632385872759)
,p_name=>'APEX.LIST_MANAGER.BUTTON_REMOVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283628110139872064)
,p_name=>'APEX.LIST_MANAGER.SELECTED_ENTRY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\9009\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284805303024872926)
,p_name=>'APEX.LTO.ADVANCED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9AD8\7EA7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284805678315872926)
,p_name=>'APEX.LTO.CANCEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284805423996872926)
,p_name=>'APEX.LTO.COMMON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E38\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284805787122872926)
,p_name=>'APEX.LTO.LIVE_TEMPLATE_OPTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9E\65F6\6A21\677F\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284806947418872927)
,p_name=>'APEX.LTO.NOT_APPLICABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7531\4E8E\6B64\7EC4\4EF6\672A\5728\9875\4E0A\5448\73B0, \6A21\677F\9009\9879\4E0D\53EF\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284805251711872926)
,p_name=>'APEX.LTO.NO_OPTIONS_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\6A21\677F\9009\9879\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284805507237872926)
,p_name=>'APEX.LTO.SAVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284803047311872924)
,p_name=>'APEX.MARKDOWN.BOLD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7C97\4F53')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284804379603872925)
,p_name=>'APEX.MARKDOWN.IMAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\50CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284803945302872925)
,p_name=>'APEX.MARKDOWN.INLINE_CODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5185\5D4C\4EE3\7801')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284898864567872995)
,p_name=>'APEX.MARKDOWN.INSERT_IMAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D2\5165\56FE\50CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284898925920872995)
,p_name=>'APEX.MARKDOWN.INSERT_LINK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D2\5165\94FE\63A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284803109659872924)
,p_name=>'APEX.MARKDOWN.ITALIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\659C\4F53')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284900660252872996)
,p_name=>'APEX.MARKDOWN.LINK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\94FE\63A5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284804291953872925)
,p_name=>'APEX.MARKDOWN.LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284804196018872925)
,p_name=>'APEX.MARKDOWN.ORDERED_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F\5217\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284803284872872925)
,p_name=>'APEX.MARKDOWN.PREVIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9884\89C8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284803760617872925)
,p_name=>'APEX.MARKDOWN.PREVIEW_EMPTY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\53EF\9884\89C8\7684\5185\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284803874478872925)
,p_name=>'APEX.MARKDOWN.STRIKETHROUGH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\7EBF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284804075730872925)
,p_name=>'APEX.MARKDOWN.UNORDERED_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6392\5E8F\5217\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284431742264872660)
,p_name=>'APEX.MENU.CURRENT_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284971934565873049)
,p_name=>'APEX.MENU.OVERFLOW_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\591A...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284431692879872660)
,p_name=>'APEX.MENU.PROCESSING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\52A0\8F7D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284882517870872983)
,p_name=>'APEX.NOTIFICATION_MESSAGE_HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\901A\77E5\6D88\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283793845552872189)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\901A\77E5\6D88\606F\6821\9A8C\548C\5185\5BB9\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283793729953872189)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\901A\77E5\6D88\606F\6821\9A8C\548C\683C\5F0F\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284507245877872713)
,p_name=>'APEX.NUMBER_FIELD.VALUE_GREATER_MAX_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \5927\4E8E\6307\5B9A\7684\6700\5927\503C%0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284507380451872713)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \5FC5\987B\662F\6570\5B57\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284507401390872713)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \4E0D\7B26\5408\6570\5B57\683C\5F0F %0 (\793A\4F8B: %1)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284507193262872713)
,p_name=>'APEX.NUMBER_FIELD.VALUE_LESS_MIN_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \5C0F\4E8E\6307\5B9A\7684\6700\5C0F\503C %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284507018805872713)
,p_name=>'APEX.NUMBER_FIELD.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \4E0D\5728\6709\6548\8303\56F4 %0 \5230 %1 \5185\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284032888770872369)
,p_name=>'APEX.PAGE.DUPLICATE_SUBMIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\9875\5DF2\7ECF\63D0\4EA4, \65E0\6CD5\91CD\590D\63D0\4EA4\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283895537654872267)
,p_name=>'APEX.PAGE.NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\627E\4E0D\5230\5E94\7528\7A0B\5E8F "%0" \9875 "%1"\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284176492022872473)
,p_name=>'APEX.PAGE_ITEM_IS_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \5FC5\987B\5177\6709\503C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284912159243873005)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\4E8E\6B64\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284911990224873004)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\914D\7F6E\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284912088756873005)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898\6837\5F0F\9009\62E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284573905646872759)
,p_name=>'APEX.POPUP_LOV.BUTTON_CLOSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\95ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284573884348872759)
,p_name=>'APEX.POPUP_LOV.BUTTON_FIND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\627E %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284574102104872759)
,p_name=>'APEX.POPUP_LOV.BUTTON_NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E00\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284574080608872759)
,p_name=>'APEX.POPUP_LOV.BUTTON_PREV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E00\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283651409339872082)
,p_name=>'APEX.POPUP_LOV.FILTER_REQ'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\5165\81F3\5C11 %0 \4E2A\5B57\7B26\7684\641C\7D22\8BCD\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284225787409872509)
,p_name=>'APEX.POPUP_LOV.ICON_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F39\51FA\5F0F\503C\5217\8868: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283651541392872082)
,p_name=>'APEX.POPUP_LOV.INITIAL_FILTER_REQ'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\5165\641C\7D22\8BCD\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283651386070872082)
,p_name=>'APEX.POPUP_LOV.NO_RESULTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\627E\4E0D\5230\7ED3\679C\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283651249249872082)
,p_name=>'APEX.POPUP_LOV.REMOVE_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284393940432872632)
,p_name=>'APEX.POPUP_LOV.SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22\8BCD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284573702870872759)
,p_name=>'APEX.POPUP_LOV.TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\641C\7D22\201D\5BF9\8BDD\6846')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283654054567872084)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\83B7\53D6\4E0B\4E00\4E2A\6216\4E0A\4E00\4E2A\4E3B\952E\503C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284386989850872627)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230 Web \670D\52A1\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283897069662872268)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\8FDB\7A0B\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284866175289872970)
,p_name=>'APEX.PROCESSING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283680786068872104)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7531\4E8E\6570\636E\5E93\4F1A\8BDD\8D44\6E90\9650\5236, Application Express \65E0\6CD5\5904\7406\8BF7\6C42\3002\8BF7\7A0D\540E\91CD\8BD5\3002'),
'<p/>',
unistr('\901A\8FC7\8C03\8BD5 ID "%0" \63D0\4F9B\6709\5173\6B64\610F\5916\4E8B\4EF6\7684\8BE6\7EC6\4FE1\606F\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284923167085873013)
,p_name=>'APEX.REGION.CSSCALENDAR.ADD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284345313291872597)
,p_name=>'APEX.REGION.CSSCALENDAR.ALL_DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284995496982873066)
,p_name=>'APEX.REGION.CSSCALENDAR.BUTTON.SENDEMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\9080\8BF7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284995158788873066)
,p_name=>'APEX.REGION.CSSCALENDAR.CHOOSE_ACTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284360499999872608)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_ALLDAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\5929\7684\6BCF\65E5\89C6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284360272803872608)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_TIME_SPECIFIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E26\6709\65F6\95F4\7684\6570\636E\6BCF\65E5\89C6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284885045371872985)
,p_name=>'APEX.REGION.CSSCALENDAR.DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284831986243872946)
,p_name=>'APEX.REGION.CSSCALENDAR.DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF4\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283743072662872151)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.CSV'
,p_message_language=>'zh-cn'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283742850197872151)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.ICALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>'iCal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283742784489872151)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.PDF'
,p_message_language=>'zh-cn'
,p_message_text=>'PDF'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283742914246872151)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.XML'
,p_message_language=>'zh-cn'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283742485717872150)
,p_name=>'APEX.REGION.CSSCALENDAR.ENDDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED3\675F\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283742619134872151)
,p_name=>'APEX.REGION.CSSCALENDAR.EVENTNAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284995267250873066)
,p_name=>'APEX.REGION.CSSCALENDAR.INVITATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9080\8BF7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284885183513872985)
,p_name=>'APEX.REGION.CSSCALENDAR.LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284884845529872984)
,p_name=>'APEX.REGION.CSSCALENDAR.MONTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284899844606872995)
,p_name=>'APEX.REGION.CSSCALENDAR.NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E00\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284953596737873035)
,p_name=>'APEX.REGION.CSSCALENDAR.NOEVENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284995858204873066)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.FORM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\73B0\6709\4E8B\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284995758721873066)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.SEND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\901A\8FC7\7535\5B50\90AE\4EF6\53D1\9001\9080\8BF7\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284899993513872995)
,p_name=>'APEX.REGION.CSSCALENDAR.PREVIOUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E00\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284939243876873024)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284938825987873024)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.BUTTON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285002888977873071)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\5B57\6BB5\90FD\5FC5\987B\586B\5199\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285002768559873071)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\9080\8BF7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284994894420873065)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.SUBJECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284939176826873024)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6536\4EF6\4EBA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283742521651872150)
,p_name=>'APEX.REGION.CSSCALENDAR.STARTDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\59CB\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284919871625873010)
,p_name=>'APEX.REGION.CSSCALENDAR.TABLEFORM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\57FA\4E8E %0 \7684\8868\5355')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284360020887872608)
,p_name=>'APEX.REGION.CSSCALENDAR.TIME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65F6\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284900572930872996)
,p_name=>'APEX.REGION.CSSCALENDAR.TODAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECA\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284885974124872985)
,p_name=>'APEX.REGION.CSSCALENDAR.VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284884904187872984)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5468')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284360375700872608)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_ALLDAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\5929\7684\5468\89C6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284360128665872608)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_TIME_SPECIFIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E26\6709\65F6\95F4\7684\6570\636E\5468\89C6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284885547291872985)
,p_name=>'APEX.REGION.CSSCALENDAR.YEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283654314335872084)
,p_name=>'APEX.REGION.FLASH_CHART.INITIALIZING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\521D\59CB\5316...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283913710575872281)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_DATA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\52A0\8F7D\6570\636E...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284924613227873014)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_RESOURCES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\52A0\8F7D\8D44\6E90...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284924787974873014)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_TEMPLATES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\52A0\8F7D\6A21\677F...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283654498016872084)
,p_name=>'APEX.REGION.FLASH_CHART.NO_DATA_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\6570\636E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283819290290872209)
,p_name=>'APEX.REGION.FLASH_CHART.SHOW_XML'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A XML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283913850634872281)
,p_name=>'APEX.REGION.FLASH_CHART.WAITING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\52A0\8F7D\6570\636E\3002\8BF7\7A0D\5019\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284885264701872985)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217...')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284885359312872985)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.LOAD_MORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A0\8F7D\66F4\591A...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284086139722872408)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.BACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5411\540E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283682223223872105)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.LOAD_MORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A0\8F7D\66F4\591A...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283707209925872124)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284885484016872985)
,p_name=>'APEX.REGION.JQM_REFLOW.LOAD_MORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A0\8F7D\66F4\591A...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284899176999872995)
,p_name=>'APEX.REGION.NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\533A\57DF ID %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283693497191872113)
,p_name=>'APEX.REGION.NO_DATA_FOUND_MESSAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\6570\636E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283901434879872272)
,p_name=>'APEX.REGION.PAGINATION.RESET_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\91CD\7F6E\533A\57DF\9875\7801\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283654234111872084)
,p_name=>'APEX.REGION.PAGINATION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\533A\57DF\9875\7801\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284826681804872942)
,p_name=>'APEX.REGION.RESPONSIVE_TABLE.COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284899065271872995)
,p_name=>'APEX.REGION.TYPE_NOT_SUPPORTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\652F\6301\533A\57DF\7C7B\578B %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283654182181872084)
,p_name=>'APEX.REGION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5448\73B0\533A\57DF "#COMPONENT_NAME#" \65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284176512886872473)
,p_name=>'APEX.REGION_COLUMN_IS_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#COLUMN_HEADER# \5FC5\987B\5177\6709\503C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284356685763872605)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528 REST \7684 SQL \670D\52A1\7684\9A8C\8BC1\5931\8D25\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283681016900872104)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1\5931\8D25\3002\503C\5217\8868\4F7F\7528\542F\7528 REST \7684 SQL \6570\636E\6E90\FF0C\4F46\5B83\5F15\7528\7684 Web \8EAB\4EFD\8BC1\660E\65E0\6548\FF0C\56E0\800C\963B\6B62\60A8\7F16\8F91\6B64 LOV \7684\5217\4FE1\606F\3002\8BF7\68C0\67E5\7528\4E8E\9A8C\8BC1\7684\8EAB\4EFD\8BC1\660E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284894921169872992)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\901A\4FE1\5931\8D25\3002\8C03\7528\503C\5217\8868\5F15\7528\7684\542F\7528 REST \7684 SQL \6570\636E\6E90\65F6\51FA\73B0\95EE\9898\FF0C\56E0\6B64\60A8\65E0\6CD5\7F16\8F91\8BE5 LOV \7684\5217\4FE1\606F\3002\8BF7\68C0\67E5\542F\7528 REST \7684 SQL \6570\636E\6E90\662F\5426\6B63\5E38\5DE5\4F5C\FF0C\4EE5\53CA\5BF9\5E94\7684\9A8C\8BC1\8EAB\4EFD\8BC1\660E\662F\5426\6B63\786E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284424377926872654)
,p_name=>'APEX.REMOTESQL.OAUTH_IS_RECOMMENDED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8B66\544A: Oracle \5EFA\8BAE\4F7F\7528 OAuth \5BA2\6237\673A\8EAB\4EFD\8BC1\660E\6765\9A8C\8BC1\542F\7528 REST \7684 SQL\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284358005820872606)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FDC\7A0B\670D\52A1\5668\51FA\9519: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284314851548872575)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\6240\6307\5B9A\542F\7528 REST \7684 SQL \5B9E\4F8B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283916099432872283)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\670D\52A1\5668\5DF2\5C06\91CD\5B9A\5411\53D1\9001\5230\FF1A%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284204025288872493)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL \8BED\53E5\7684\957F\5EA6\8D85\8FC7\4E86 32,767 \5B57\8282\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284223951835872508)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\60A8\597D, Application Express! \60A8\4EE5 #USER# \7684\8EAB\4EFD\8FDE\63A5\3002'),
unistr('\672C\5730\6570\636E\5E93\65F6\95F4\6233\4E3A: #SYSDATE#.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284552007105872744)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5C06\7F16\8F91\5DE5\4F5C\533A\7684\9ED8\8BA4\65B9\6848\7684\522B\540D\3002\8BBE\7F6E\6B64\522B\540D\8FD8\5C06\66F4\6539\5DE5\4F5C\533A\7EA7\522B\7684\8DEF\5F84\524D\7F00\3002\8FD9\5C06\5F71\54CD\60A8\53EF\80FD\5B9A\4E49\7684\4EFB\4F55\57FA\4E8E APEX \7684 RESTful \670D\52A1\7684 URL\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284211247349872499)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ORDS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D ORDS \7248\672C\4E0D\652F\6301 REST \7BA1\7406\754C\9762\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284211366095872499)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ROLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('REST \7BA1\7406\754C\9762\4E0D\652F\6301\7ED9\5B9A\7684\5BA2\6237\673A\89D2\8272\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284990616389873062)
,p_name=>'APEX.RICH_TEXT_EDITOR.ACCESSIBLE_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0, \591A\4FE1\606F\6587\672C\7F16\8F91\5668')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284201667004872492)
,p_name=>'APEX.RICH_TEXT_EDITOR.MAXIMUM_LENGTH_EXCEEDED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\591A\4FE1\606F\6587\672C HTML \6807\8BB0\8D85\8FC7\4E86\6B64\9879\7684\6700\5927\957F\5EA6\FF08\5B9E\9645\4E3A %0 \4E2A\5B57\7B26\FF0C\5141\8BB8 %1 \4E2A\5B57\7B26\FF09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284883838985872984)
,p_name=>'APEX.RV.DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284809634766872929)
,p_name=>'APEX.RV.DUPLICATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\590D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284804819254872926)
,p_name=>'APEX.RV.EXCLUDE_HIDDEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\7684\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284804782715872926)
,p_name=>'APEX.RV.EXCLUDE_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\9664\7A7A\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284883975038872984)
,p_name=>'APEX.RV.INSERT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284344009685872596)
,p_name=>'APEX.RV.MOVE_DOWN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\79FB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284344123093872596)
,p_name=>'APEX.RV.MOVE_UP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\79FB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284804536694872925)
,p_name=>'APEX.RV.NEXT_RECORD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E00\9875')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284805114035872926)
,p_name=>'APEX.RV.NOT_GROUPED_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5176\4ED6\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284804692478872926)
,p_name=>'APEX.RV.PREV_RECORD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E00\9875')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284804984843872926)
,p_name=>'APEX.RV.REC_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C%0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284805088880872926)
,p_name=>'APEX.RV.REC_XY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B2C %0 \884C, \5171 %1 \884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284809755771872929)
,p_name=>'APEX.RV.REFRESH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5237\65B0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284809813132872929)
,p_name=>'APEX.RV.REVERT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD8\539F\66F4\6539')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284804417677872925)
,p_name=>'APEX.RV.SETTINGS_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\83DC\5355')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284278874911872548)
,p_name=>'APEX.SAMPLE_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F8B\5982 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284201791013872492)
,p_name=>'APEX.SC.REFERENCES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E2A\5F15\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284543389027872738)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9E\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284543480649872738)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5E94\7528\7A0B\5E8F\5B9E\7528\7A0B\5E8F \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284550816096872743)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F6C\5230\9875')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284550723720872743)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F6C\5230\201C\5171\4EAB\7EC4\4EF6\201D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284543548504872738)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\6784\5EFA\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284543612695872738)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\6784\5EFA\5668\4EFB\52A1 > ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284543722141872738)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284543895442872738)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \5E94\7528\7A0B\5E8F\9879 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284543910968872738)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\903B\8F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284544019042872738)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284544116287872738)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \5B89\5168\9A8C\8BC1\65B9\6848 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284544283492872738)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6388\6743\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284544328896872739)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \5B89\5168\6388\6743\65B9\6848 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284544486972872739)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284544523640872739)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \9762\5305\5C51 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284544634234872739)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6784\5EFA\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284544739997872739)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \6784\5EFA\9009\9879 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284544871525872739)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\4EF6\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284544916793872739)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \7EC4\4EF6\8BBE\7F6E \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284545014980872739)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284545105675872739)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \5E94\7528\7A0B\5E8F\8BA1\7B97 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284545233158872739)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5E94\7528\7A0B\5E8F\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284545374536872739)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\9A8C\8BC1\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284545470543872739)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\6784\5EFA\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284545554258872739)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5E94\7528\7A0B\5E8F\8BA1\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284545649257872739)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\7535\5B50\90AE\4EF6\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284545760726872739)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\63D2\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284545848440872740)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\4E3B\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284545963797872740)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA Web \8EAB\4EFD\8BC1\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284546005142872740)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\5B9A\4E49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284546176467872740)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \6570\636E\52A0\8F7D\5B9A\4E49 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284546262149872740)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284546341326872740)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\4E49\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284546405377872740)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284546597065872740)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\5E03\5C40')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284546685611872740)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \62A5\8868\5E03\5C40 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284546771004872740)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E7 Web \670D\52A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284546843731872740)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \65E7 Web \670D\52A1 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284546933506872740)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284547070252872740)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \7ECF\5178\5BFC\822A\5217\8868 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284547138631872740)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284547296615872740)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \503C\5217\8868 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284547381289872741)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284547464916872741)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5176\4ED6\7EC4\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284547500987872741)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D2\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284547640657872741)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \63D2\4EF6 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284547752212872741)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284547849945872741)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \5E94\7528\7A0B\5E8F\5904\7406 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284547906530872741)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284548059405872741)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \62A5\8868\67E5\8BE2 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284548135001872741)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284548213415872741)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528 REST \7684 SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284548357991872741)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \542F\7528 REST \7684 SQL \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284548418108872741)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B89\5168\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284548594407872741)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F1A\8BDD\72B6\6001\4FDD\62A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284548689526872741)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\5E94\7528\7A0B\5E8F\72B6\6001\4FDD\62A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284548803908872742)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5171\4EAB\7EC4\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284548945585872742)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284549050915872742)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FEB\6377\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284549167011872742)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \5FEB\6377\65B9\5F0F \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284549234290872742)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\9879\5361\FF08\65E7\FF09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284549378621872742)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284549427675872742)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C UI \6A21\677F \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284549540198872742)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284549658646872742)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C UI \4E3B\9898 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284549723953872742)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\754C\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284549895832872742)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \8EAB\4EFD\8BC1\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284549906778872742)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C \5B89\5168 Web \8EAB\4EFD\8BC1\660E \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284550055359872742)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \6E90\6A21\5757')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284550159925872742)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\5230\FF1A\5171\4EAB\7EC4\4EF6 \005C Web \6E90\6A21\5757 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284550237260872743)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL \5DE5\4F5C\5BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284550307340872743)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5BF9\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284550454264872743)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 SQL \5DE5\4F5C\5BA4\4E2D\521B\5EFA %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284550551752872743)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\811A\672C\7F16\8F91\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284550633220872743)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL \5DE5\4F5C\5BA4\4EFB\52A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284933198694873020)
,p_name=>'APEX.SESSION.DB_SESSION_CLEANUP.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\6570\636E\5E93\4F1A\8BDD\6E05\9664\4EE3\7801\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283895042781872267)
,p_name=>'APEX.SESSION.DB_SESSION_INIT.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\6570\636E\5E93\4F1A\8BDD\8BBE\7F6E\4EE3\7801\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283668719508872095)
,p_name=>'APEX.SESSION.EXPIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\7684\4F1A\8BDD\5DF2\5931\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284924808875873014)
,p_name=>'APEX.SESSION.EXPIRED.CLOSE_DIALOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\5173\95ED\6B64\5BF9\8BDD\6846, \7136\540E\6309\6D4F\89C8\5668\7684\201C\91CD\65B0\52A0\8F7D\201D\6309\94AE\4EE5\83B7\53D6\65B0\4F1A\8BDD\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284985045774873058)
,p_name=>'APEX.SESSION.EXPIRED.NEW_SESSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\51FB<a href="%0">\6B64\5904</a>\4EE5\65B0\5EFA\4F1A\8BDD\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284348124918872599)
,p_name=>'APEX.SESSION.RAS.NO_DYNAMIC_ROLES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\5728 Real Application Security \4F1A\8BDD\4E2D\4E3A\7528\6237 "%0" \542F\7528\52A8\6001\89D2\8272\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283887980080872261)
,p_name=>'APEX.SESSION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('ERR-99900 \65E0\6CD5\521B\5EFA\552F\4E00\7684\4F1A\8BDD ID: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284996100843873066)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\9879 %0 \57FA\4E8E\6570\636E\5E93\5217, \4F46\5C5E\6027 ''\4F7F\7528\7684\6E90'' \8BBE\7F6E\4E3A ''\4EC5\5F53\4F1A\8BDD\72B6\6001\4E2D\7684\5F53\524D\503C\4E3A\7A7A\65F6''\3002\8FD9\975E\5E38\5371\9669, \5E76\4E14\53EF\80FD\5BFC\81F4\5728\67E5\770B\548C\4FDD\5B58\591A\4E2A\8BB0\5F55\65F6\610F\5916\5730\8986\76D6\6570\636E\3002\5C06 ''\4F7F\7528\7684\6E90'' \59CB\7EC8\8BBE\7F6E\4E3A ''\59CB\7EC8\66FF\6362\4F1A\8BDD\72B6\6001\4E2D\7684\4EFB\4F55\73B0\6709\503C''\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284905636347873000)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7981\6B62\8BBF\95EE\4F1A\8BDD\72B6\6001, \5DF2\963B\6B62\5C1D\8BD5\8BFB\53D6/\5199\5165\64CD\4F5C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283706373291872123)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\5904\7406\8FC7\7A0B\4E2D\5C1D\8BD5\4FDD\5B58\5904\4E8E\4F1A\8BDD\72B6\6001\7684\9879 %0, \9879\5177\6709\201C\4EC5\5185\90E8\201D\4FDD\62A4\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283687770048872109)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63A5\53D7\5904\7406\8FC7\7A0B\4E2D\5C1D\8BD5\4FDD\5B58\5904\4E8E\4F1A\8BDD\72B6\6001\7684\9879 %0, \9879\5177\6709\201C\4EC5\5185\90E8\201D\4FDD\62A4, \6216\8005\4E0D\662F\53EF\4EE5\6295\9012\7684\8868\5355\9879\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283962257770872317)
,p_name=>'APEX.SESSION_STATE.ITEM_VALUE_PROTECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F1A\8BDD\72B6\6001\4FDD\62A4\8FDD\89C4: \8FD9\53EF\80FD\662F\56E0\4E3A\624B\52A8\53D8\66F4\4E86\53D7\4FDD\62A4\7684\9875\9879 %0\3002\5982\679C\60A8\4E0D\786E\5B9A\5BFC\81F4\6B64\9519\8BEF\7684\539F\56E0, \8BF7\4E0E\5E94\7528\7A0B\5E8F\7BA1\7406\5458\8054\7CFB, \4EE5\83B7\53D6\5E2E\52A9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285021122670873085)
,p_name=>'APEX.SESSION_STATE.PAGE_PROTECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\4FDD\62A4\8FDD\89C4: \5BFC\81F4\51FA\73B0\8FD9\79CD\60C5\51B5\7684\539F\56E0\53EF\80FD\662F\7531\4E8E\63D0\4EA4\5C1A\672A\5B8C\6210\52A0\8F7D\7684\9875, \6216\8005\624B\52A8\66F4\6539\4E86\53D7\4FDD\62A4\7684\9875\9879\3002\5982\9700\66F4\591A\5E2E\52A9, \8BF7\4E0E\5E94\7528\7A0B\5E8F\7BA1\7406\5458\8054\7CFB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285018057683873083)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\5305\542B\4EE5\4E0B\65E0\6548\5B57\7B26\4E4B\4E00: &<>"/;,*|=% \6216 --')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285018129957873083)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR_NL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\5305\542B\4EE5\4E0B\65E0\6548\5B57\7B26\4E4B\4E00: &<>"/;,*|=% -- \6216\6362\884C\7B26\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285017889849873082)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.US_ONLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5305\542B\7279\6B8A\5B57\7B26\3002\53EA\5141\8BB8\4F7F\7528\5B57\7B26 a-Z, 0-9 \548C\7A7A\683C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285017948452873082)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\5305\542B <, > \6216 ", \8FD9\4E9B\662F\65E0\6548\5B57\7B26\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283687303155872109)
,p_name=>'APEX.SESSION_STATE.SSP_CHECKSUM_MISSING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\63D0\4F9B\7528\4E8E\663E\793A\9875\5904\7406\7684\6821\9A8C\548C, \5F53\5C06\4E00\4E2A\6216\591A\4E2A\8BF7\6C42, \6E05\9664\9AD8\901F\7F13\5B58\6216\53C2\6570\503C\4F5C\4E3A\53C2\6570\4F20\9012\65F6, \8BE5\9875\9700\8981\6821\9A8C\548C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283949217566872308)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F1A\8BDD\72B6\6001\4FDD\62A4\8FDD\89C4: \8FD9\53EF\80FD\662F\56E0\4E3A\624B\52A8\53D8\66F4\4E86\5305\542B\6821\9A8C\548C\7684 URL, \6216\8005\4F7F\7528\4E86\5177\6709\4E0D\6B63\786E\7684\6216\7F3A\5931\6821\9A8C\548C\7684\94FE\63A5\3002\5982\679C\60A8\4E0D\786E\5B9A\5BFC\81F4\6B64\9519\8BEF\7684\539F\56E0, \8BF7\4E0E\5E94\7528\7A0B\5E8F\7BA1\7406\5458\8054\7CFB, \4EE5\83B7\53D6\5E2E\52A9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283687479443872109)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6839\636E\8BF7\6C42, \6E05\9664\9AD8\901F\7F13\5B58, \53C2\6570\540D\548C\53C2\6570\503C\8BA1\7B97\7684\6821\9A8C\548C (%0) \4E0E\4F20\9012\5230\663E\793A\8FC7\7A0B\4E2D\7684\6821\9A8C\548C (%1) \4E0D\5339\914D\3002'),
'',
unistr('\6CE8: \6700\7EC8\7528\6237\5C06\5F97\5230\4E0D\540C\7684\9519\8BEF\6D88\606F\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283686391609872108)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\663E\793A\5904\7406\8FC7\7A0B\4E2D\5C1D\8BD5\4FDD\5B58\5904\4E8E\4F1A\8BDD\72B6\6001\7684\9879 %0\3002\9879\4FDD\62A4\7EA7\522B\4E3A:'),
'  %1',
'',
unistr('\672A\4F20\5165\6821\9A8C\548C, \6216\8005\4F20\5165\7684\6821\9A8C\548C\5E94\8BE5\9002\5408\4FDD\62A4\7EA7\522B\4E3A "%2" \7684\9879\3002'),
'',
unistr('\6CE8: \6700\7EC8\7528\6237\5C06\5F97\5230\4E0D\540C\7684\9519\8BEF\6D88\606F\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283896808002872268)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('ERR-1022 \65E0\6CD5\4FDD\5B58\5C5E\6027\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284805895979872926)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_OFF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\9AD8\5BF9\6BD4\5EA6\6A21\5F0F\8BBE\7F6E\4E3A\201C\5173\95ED\201D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284805992796872927)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_ON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\9AD8\5BF9\6BD4\5EA6\6A21\5F0F\8BBE\7F6E\4E3A\201C\5F00\542F\201D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283921687159872287)
,p_name=>'APEX.SHUTTLE.CONTROL_BOTTOM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E95\90E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283921883854872287)
,p_name=>'APEX.SHUTTLE.CONTROL_DOWN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5411\4E0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283921959160872287)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283922053916872287)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\79FB\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283922108973872287)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283922291243872287)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283922316393872287)
,p_name=>'APEX.SHUTTLE.CONTROL_RESET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283921561554872287)
,p_name=>'APEX.SHUTTLE.CONTROL_TOP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9876\90E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283921745535872287)
,p_name=>'APEX.SHUTTLE.CONTROL_UP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5411\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284959003367873039)
,p_name=>'APEX.SINCE.SHORT.DAYS_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>'%0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284959753189873040)
,p_name=>'APEX.SINCE.SHORT.DAYS_FROM_NOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 %0 \5929\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284958974648873039)
,p_name=>'APEX.SINCE.SHORT.HOURS_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>'%0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284959840318873040)
,p_name=>'APEX.SINCE.SHORT.HOURS_FROM_NOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 %0 \5C0F\65F6\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284958758552873039)
,p_name=>'APEX.SINCE.SHORT.MINUTES_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>'%0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284959925172873040)
,p_name=>'APEX.SINCE.SHORT.MINUTES_FROM_NOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 %0 \5206\949F\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284959363189873039)
,p_name=>'APEX.SINCE.SHORT.MONTHS_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E2A\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284959580144873039)
,p_name=>'APEX.SINCE.SHORT.MONTHS_FROM_NOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 %0 \4E2A\6708\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284958862671873039)
,p_name=>'APEX.SINCE.SHORT.SECONDS_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>'%0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284959666318873040)
,p_name=>'APEX.SINCE.SHORT.SECONDS_FROM_NOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 %0 \79D2\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284959153543873039)
,p_name=>'APEX.SINCE.SHORT.WEEKS_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>'%0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284960015119873040)
,p_name=>'APEX.SINCE.SHORT.WEEKS_FROM_NOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 %0 \5468\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284959288668873039)
,p_name=>'APEX.SINCE.SHORT.YEARS_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>'%0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284959488796873039)
,p_name=>'APEX.SINCE.SHORT.YEARS_FROM_NOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 %0 \5E74\5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284135407279872444)
,p_name=>'APEX.SPLITTER.COLLAPSE_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6298\53E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284135340220872444)
,p_name=>'APEX.SPLITTER.RESTORE_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD8\539F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284542311785872737)
,p_name=>'APEX.STAR_RATING.CLEAR_RATING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664\8BC4\7EA7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284506354575872713)
,p_name=>'APEX.STAR_RATING.INVALID_RATING_RANGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\6709\6548\7684\8BC4\7EA7\8303\56F4 1 - %1 \5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284506426924872713)
,p_name=>'APEX.STAR_RATING.IS_NOT_NUMERIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\662F\6570\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284478314323872693)
,p_name=>'APEX.SUCCESS_MESSAGE_HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6210\529F\6D88\606F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283794030885872189)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6210\529F\6D88\606F\6821\9A8C\548C\5185\5BB9\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283793963519872189)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6210\529F\6D88\606F\6821\9A8C\548C\683C\5F0F\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284990286211873062)
,p_name=>'APEX.TABS.NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E00\9875')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284990177671873062)
,p_name=>'APEX.TABS.PREVIOUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E00\9875')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283645475286872077)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97\5217 #COMPONENT_NAME# \7684\9ED8\8BA4\503C\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283646007306872078)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\201C\591A\884C\5220\9664\201D\8FDB\7A0B\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283931030605872294)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6821\9A8C\548C\5217 ("FCS") \662F\5FC5\9700\7684, \4F46\672A\63D0\4F9B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283931287914872294)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\63D0\4F9B\4E3B\952E\503C, \81F3\5C11\5FC5\987B\63D0\4F9B\4E00\884C\624D\80FD\8FDB\884C\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283932053324872295)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\4E3A\6807\8BC6\7684\6B21\7EA7\952E\5217\63D0\4F9B\6B21\7EA7\952E\5217\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284048932571872381)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\8868\683C\5F0F\8868\5355\4E2D\672A\627E\5230\6570\636E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283930976691872294)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6307\5B9A\4E3B\952E\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283931923690872295)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\8BC6\7684\6B21\7EA7\952E\5217\4E0D\5728\67E5\8BE2\7684\9009\62E9\5217\8868\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283930811461872294)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6307\5B9A\8868\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283930707205872294)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6307\5B9A\8868\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283953015999872311)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\201C\591A\884C\66F4\65B0\201D\8FDB\7A0B\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284953640770873035)
,p_name=>'APEX.TB.TOOLBAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\5177\680F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283814389689872205)
,p_name=>'APEX.TEAM.COMMITTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\63D0\4EA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283814124066872205)
,p_name=>'APEX.TEAM.CONTRIBUTOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D21\732E\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283816014589872206)
,p_name=>'APEX.TEAM.CREATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6DFB\52A0\529F\80FD %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283816120887872206)
,p_name=>'APEX.TEAM.DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5220\9664\529F\80FD %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283636471317872071)
,p_name=>'APEX.TEAM.DEPRECATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\7248\672C 19.2 \8D77\FF0CAPEX \5C0F\7EC4\5F00\53D1\5DF2\8FC7\65F6\FF0C\5E76\5C06\4ECE\672A\6765\7684\53D1\884C\7248\4E2D\5220\9664\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283814465241872205)
,p_name=>'APEX.TEAM.ESTIMATED_EFFORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F30\8BA1\5DE5\4F5C\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283814725102872205)
,p_name=>'APEX.TEAM.FEATURE_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF4\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283813900351872204)
,p_name=>'APEX.TEAM.FEATURE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283814528287872205)
,p_name=>'APEX.TEAM.FEATURE_STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\529F\80FD\72B6\6001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283814660732872205)
,p_name=>'APEX.TEAM.MILESTONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283814910569872205)
,p_name=>'APEX.TEAM.NO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5426')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283814073279872205)
,p_name=>'APEX.TEAM.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283814279417872205)
,p_name=>'APEX.TEAM.RELEASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\884C\7248')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283813087924872204)
,p_name=>'APEX.TEAM.SAVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\65B0\529F\80FD %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283814861959872205)
,p_name=>'APEX.TEAM.YES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284993008699873064)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_NAV_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C55\5F00/\6298\53E0\5BFC\822A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284993170085873064)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_SIDE_COL_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C55\5F00/\6298\53E0\4FA7\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283669195562872095)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\590D\5236\5E94\7528\7A0B\5E8F "%1" \4E2D\7684\4E3B\9898 "%0"\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284985501439873059)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5BFC\5165\7684\4E3B\9898\4E0E\5F53\524D\4E3B\9898\4E0D\517C\5BB9\3002'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284951336310873033)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898\53F7\65E0\6548\6216\8005\4E3B\9898\4E0D\662F\5F53\524D UI \4E3B\9898\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284275208461872546)
,p_name=>'APEX.TIME.DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('1 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284275094712872545)
,p_name=>'APEX.TIME.HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('1 \5C0F\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284275394028872546)
,p_name=>'APEX.TIME.N_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284275157428872546)
,p_name=>'APEX.TIME.N_HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5C0F\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284274978032872545)
,p_name=>'APEX.TIME.N_MINUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5206\949F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284275522310872546)
,p_name=>'APEX.TIME.N_WEEKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5468')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284275420745872546)
,p_name=>'APEX.TIME.WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('1 \5468')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284904766962872999)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97\5C42\6B21\9700\8981\4E3B\952E\5217\548C\7236\952E\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284904873677872999)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\8BA1\7B97\5C42\6B21\65F6\FF0C\9700\8981\8282\70B9\7EA7\522B\5217\548C\8282\70B9\72B6\6001\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285012723586873079)
,p_name=>'APEX.UI.BACK_TO_TOP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\7684\5F00\59CB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283830410859872217)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6697\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283830633182872217)
,p_name=>'APEX.UI.DISABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\7981\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283830580816872217)
,p_name=>'APEX.UI.ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\542F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284270191391872542)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\4ECE\4E0B\9762\7684\5217\8868\4E2D\9009\62E9\7528\6237\754C\9762:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284272645579872544)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 - \7528\6237\754C\9762\9009\62E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283645796781872077)
,p_name=>'APEX.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\8BF7\6C42\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283790692908872187)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6388\6743\8BBF\95EE (\672A\8BBE\7F6E\5B89\5168\7EC4\5305\53D8\91CF)\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283791212775872187)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\63D0\53D6\67E5\627E\7528\6237\4FE1\606F\3002%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283778471036872178)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237 %0 \9700\8981 ADMIN \6743\9650\624D\80FD\6267\884C\6B64\64CD\4F5C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283791131990872187)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237 %0 \672A\63D0\4F9B\7535\5B50\90AE\4EF6\5730\5740\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283746661491872154)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\672A\83B7\6388\6743\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283791048645872187)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237 %0 \4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283896973951872268)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\9A8C\8BC1\65F6\51FA\9519\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284279191021872548)
,p_name=>'APEX.VALUE_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\9700\7684\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285002360667873071)
,p_name=>'APEX.WAIT_UNTIL_PAGE_LOADED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\7B49\5F85\9875\5B8C\5168\52A0\8F7D, \7136\540E\91CD\8BD5\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284826247126872941)
,p_name=>'APEX.WARN_ON_UNSAVED_CHANGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\9875\5177\6709\672A\4FDD\5B58\7684\66F4\6539\3002')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284906170852873000)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Application Express \65E0\6CD5\4ECE\4EE5\4E0B\7C7B\578B\7684\54CD\5E94\6570\636E\8BA1\7B97\6570\636E\6982\8981\6587\4EF6\FF1A%0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284336980581872591)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284336873276872591)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284890041128872988)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668\8868\8FBE\5F0F\4E0D\662F\6709\6548\7684 JSON\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284881730666872982)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Oracle REST Data Services \4E0D\652F\6301\8FC7\6EE4\5668\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284223416390872508)
,p_name=>'APEX.WEBSRC.HIDE_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9690\85CF\6240\9009\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284316383834872576)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 200: \6210\529F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284316496774872576)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 201: \5DF2\521B\5EFA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284315869106872575)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 400: \8BF7\6C42\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284315676738872575)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 401: \672A\6388\6743')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284315988234872575)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 403: \7981\6B62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284315702578872575)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 404: \672A\627E\5230')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284316011169872575)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 405: \4E0D\5141\8BB8\4F7F\7528\6B64\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283635601076872070)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 407\FF1A\9700\8981\4EE3\7406\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283635911050872070)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 409\FF1A\51B2\7A81')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283635716764872070)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 412\FF1A\524D\7F6E\6761\4EF6\5931\8D25')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283635852764872070)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 428\FF1A\9700\8981\524D\7F6E\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284316131273872576)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 500: \5185\90E8\670D\52A1\5668\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284316229022872576)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 502: \7F51\5173\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284906593077873001)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 503\FF1A\670D\52A1\4E0D\53EF\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284906633539873001)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP 504\FF1A\7F51\5173\8D85\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284826123271872941)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \6E90\8FD4\56DE\4E86 HTTP \9519\8BEF: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284314708717872574)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230 Web \6E90\6A21\5757\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283859066425872239)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\9009\62E9\5668 "%0" \672A\9009\62E9\8981\89C6\4E3A\8868\7684\5BF9\8C61\6570\7EC4\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283859105345872239)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\9009\62E9\5668 "%0" \672A\9009\62E9\8981\89C6\4E3A\5355\884C\7684\5BF9\8C61\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284826027233872941)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7C7B\578B\4E3A "%1" \7684\5FC5\9700 Web \6E90\8F93\5165\53C2\6570 "%0" \5FC5\987B\6709\503C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284808640153872929)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\54CD\5E94\6B63\6587\592A\5927, \65E0\6CD5\663E\793A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284223646136872508)
,p_name=>'APEX.WEBSRC.SHOW_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\6240\9009\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284279011401872548)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E7 ORDS REST \670D\52A1\4F7F\7528\5C0F\56FA\5B9A\9875\5927\5C0F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284224019851872508)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\53D6\6240\6709 Web \6E90\6570\636E\65F6\8D85\65F6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284198706336872490)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\7684\672C\5730 SQL \8FC7\6EE4\5668\9700\8981\5BF9 REST \670D\52A1\53D1\51FA\8FC7\591A\7684\201C\4E0B\4E00\9875\201D\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284278937431872548)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E7 ORDS REST \670D\52A1\7684\56FA\5B9A\9875\5927\5C0F\672A\77E5\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284930504262873018)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\52A8\6001\64CD\4F5C ''#COMPONENT_NAME#'' \6307\5B9A\7684\4EA4\4E92\5F0F\7F51\683C\5217 ''%0'' \4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284930790802873018)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406 ''%0'' \5728\6267\884C\884C\9501\5B9A\65F6\5F15\53D1\4E86 ''%1''\3002\5F53\5904\7406\5728\590D\6742\89C6\56FE\4E0A\4F7F\7528 instead-of \89E6\53D1\5668\53D1\51FA SELECT FOR UPDATE \7528\4E8E\9501\5B9A\884C\65F6, \4F1A\51FA\73B0\6B64\9519\8BEF\3002\8BF7\5C06\5904\7406\5C5E\6027 ''\9501\5B9A\884C'' \8BBE\7F6E\4E3A\201C\5426\201D\6216\201CPL/SQL \4EE3\7801\201D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284930674367873018)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406 ''%0'' \5728\6267\884C DML \547D\4EE4\65F6\5F15\53D1\4E86 ''%1''\3002\5F53\5217\57FA\4E8E\805A\96C6\6216 SQL \8868\8FBE\5F0F\65F6\4F1A\51FA\73B0\6B64\9519\8BEF\3002\8BF7\5C06\5217\5C5E\6027 ''\4EC5\67E5\8BE2'' \8BBE\7F6E\4E3A\201C\662F\201D\4EE5\4ECE INSERT \548C UPDATE \8BED\53E5\4E2D\6392\9664\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284594719370872773)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\4ECE\5217 ''%0'' \4E0D\5305\542B\503C\3002\8BF7\786E\4FDD\5BF9\4E3B\533A\57DF\6267\884C\76F8\5E94\5904\7406\4E4B\540E\6267\884C ''%1'' \5904\7406\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284912347825873005)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5B9A\4E49\4EA4\4E92\5F0F\7F51\683C ''%0'' \7684\4E3B\5217, \800C\6B64\5217\662F\4E3B\4ECE\5173\7CFB\6240\5FC5\9700\7684\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284268421523872541)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5B9A\4E49\4EA4\4E92\5F0F\7F51\683C ''%0'' \7684\4E3B\952E\5217, \800C\6B64\5217\662F\7F16\8F91\6216\4E3B\4ECE\5173\7CFB\6240\5FC5\9700\7684\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284884016823872984)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\4E8E\53EF\7F16\8F91\7684\4EA4\4E92\5F0F\7F51\683C, \9875\5C5E\6027 ''\63D0\4EA4\65F6\91CD\65B0\52A0\8F7D'' \5FC5\987B\8BBE\7F6E\4E3A ''\4EC5\6210\529F\65F6''\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284884109859872984)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\4E8E\8868\683C\5F0F\8868\5355, \9875\5C5E\6027 ''\63D0\4EA4\65F6\91CD\65B0\52A0\8F7D'' \5FC5\987B\8BBE\7F6E\4E3A ''\59CB\7EC8''\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283826183569872214)
,p_name=>'APEXIR_3D'
,p_message_language=>'zh-cn'
,p_message_text=>'3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284919452508873010)
,p_name=>'APEXIR_ACTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284046883916872379)
,p_name=>'APEXIR_ACTIONS_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C\83DC\5355')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283951763616872310)
,p_name=>'APEXIR_ADD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284036430827872372)
,p_name=>'APEXIR_ADD_FUNCTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\51FD\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284036301030872371)
,p_name=>'APEXIR_ADD_GROUP_BY_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\201C\5206\7EC4\65B9\5F0F\201D\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284360806491872608)
,p_name=>'APEXIR_ADD_PIVOT_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\79FB\52A8\8868\5934\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284360932355872608)
,p_name=>'APEXIR_ADD_ROW_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\884C\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284524687138872725)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\8BA2\9605')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283826351843872214)
,p_name=>'APEXIR_AGGREGATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\805A\96C6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284070846317872396)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\805A\96C6\663E\793A\5728\6BCF\4E2A\63A7\5236\5206\6BB5\4E4B\540E\548C\62A5\8868\7684\7ED3\5C3E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284073921389872399)
,p_name=>'APEXIR_AGGREGATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\805A\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283952208401872310)
,p_name=>'APEXIR_AGG_AVG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E73\5747\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283961140159872316)
,p_name=>'APEXIR_AGG_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283978174416872329)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\540C\503C\8BA1\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283952341780872310)
,p_name=>'APEXIR_AGG_MAX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5927\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283952558326872310)
,p_name=>'APEXIR_AGG_MEDIAN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E2D\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283952461161872310)
,p_name=>'APEXIR_AGG_MIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5C0F\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283952632775872310)
,p_name=>'APEXIR_AGG_MODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283952168647872310)
,p_name=>'APEXIR_AGG_SUM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\548C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283953931057872311)
,p_name=>'APEXIR_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283825388132872213)
,p_name=>'APEXIR_ALL_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283676111345872100)
,p_name=>'APEXIR_ALL_ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284915921700873007)
,p_name=>'APEXIR_ALTERNATIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66FF\4EE3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284918077731873009)
,p_name=>'APEXIR_ALTERNATIVE_DEFAULT_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66FF\4EE3\9ED8\8BA4\503C: %0 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283912059395872279)
,p_name=>'APEXIR_AND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283832887649872219)
,p_name=>'APEXIR_APPLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284881930606872982)
,p_name=>'APEXIR_AREA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\79EF\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283796736768872191)
,p_name=>'APEXIR_ASCENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5347\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283924531754872289)
,p_name=>'APEXIR_AS_OF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284918684205873010)
,p_name=>'APEXIR_AVERAGE_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E73\5747\503C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284881896913872982)
,p_name=>'APEXIR_BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6761\5F62\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283829239067872216)
,p_name=>'APEXIR_BETWEEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECB\4E8E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283795429071872190)
,p_name=>'APEXIR_BGCOLOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\80CC\666F\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284521634344872723)
,p_name=>'APEXIR_BLACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED1\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283797530877872192)
,p_name=>'APEXIR_BLUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\84DD\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284039285288872374)
,p_name=>'APEXIR_BOTTOM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E95\90E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283953595094872311)
,p_name=>'APEXIR_CALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\5386')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283798108835872193)
,p_name=>'APEXIR_CANCEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283838259560872223)
,p_name=>'APEXIR_CATEGORY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7C7B\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283795335636872190)
,p_name=>'APEXIR_CELL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\5143')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283953481037872311)
,p_name=>'APEXIR_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284042486658872376)
,p_name=>'APEXIR_CHART_INITIALIZING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\521D\59CB\5316...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284396747076872634)
,p_name=>'APEXIR_CHART_LABEL_NOT_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\56FE\8868\6807\7B7E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284509242714872715)
,p_name=>'APEXIR_CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\7684\67E5\8BE2\8D85\8FC7\4E86\6BCF\4E2A\56FE\8868\7684\6700\5927\6570\636E\70B9\6570 %0\3002\8BF7\5E94\7528\8FC7\6EE4\5668\6765\51CF\5C11\57FA\672C\67E5\8BE2\4E2D\7684\8BB0\5F55\6570\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284503277393872711)
,p_name=>'APEXIR_CHART_MAX_ROW_CNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\67E5\8BE2\7684\6700\5927\884C\8BA1\6570\5C06\9650\5236\57FA\672C\67E5\8BE2\4E2D\7684\884C\6570, \800C\4E0D\662F\663E\793A\7684\884C\6570\3002\60A8\7684\57FA\672C\67E5\8BE2\8D85\8FC7\4E86\6700\5927\884C\8BA1\6570 (%0)\3002\8BF7\5E94\7528\8FC7\6EE4\5668\6765\51CF\5C11\57FA\672C\67E5\8BE2\4E2D\7684\8BB0\5F55\6570\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283825619497872213)
,p_name=>'APEXIR_CHART_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284479046937872694)
,p_name=>'APEXIR_CHECK_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\9009\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283924900032872289)
,p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\62A5\8868\4E0B\8F7D\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284027696394872365)
,p_name=>'APEXIR_CLEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283798030967872192)
,p_name=>'APEXIR_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284070945738872397)
,p_name=>'APEXIR_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284898167961872994)
,p_name=>'APEXIR_COLUMN_FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284037394247872372)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284031347734872368)
,p_name=>'APEXIR_COLUMN_HEADING_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\6807\9898\83DC\5355')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284042268615872376)
,p_name=>'APEXIR_COLUMN_INFO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284908374244873002)
,p_name=>'APEXIR_COLUMN_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284037073014872372)
,p_name=>'APEXIR_COLUMN_N'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283906347579872275)
,p_name=>'APEXIR_COMPARISON_CONTAINS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5305\542B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283911098421872279)
,p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5305\542B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283796477966872191)
,p_name=>'APEXIR_COMPARISON_IN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283911275031872279)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5728\8FC7\53BB\7684')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283956671593872313)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5728\672A\6765\7684')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283911138588872279)
,p_name=>'APEXIR_COMPARISON_IS_IN_LAST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\8FC7\53BB\7684')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283956528851872313)
,p_name=>'APEXIR_COMPARISON_IS_IN_NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\672A\6765\7684')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283796398527872191)
,p_name=>'APEXIR_COMPARISON_IS_NOT_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\4E3A\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283796295362872191)
,p_name=>'APEXIR_COMPARISON_IS_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283796096652872191)
,p_name=>'APEXIR_COMPARISON_LIKE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7C7B\4F3C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283796553818872191)
,p_name=>'APEXIR_COMPARISON_NOT_IN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283796176277872191)
,p_name=>'APEXIR_COMPARISON_NOT_LIKE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\7C7B\4F3C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283907013371872276)
,p_name=>'APEXIR_COMPARISON_REGEXP_LIKE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5339\914D\6B63\5219\8868\8FBE\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283924849047872289)
,p_name=>'APEXIR_COMPUTATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284502828886872710)
,p_name=>'APEXIR_COMPUTATION_EXPRESSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97\8868\8FBE\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284071252202872397)
,p_name=>'APEXIR_COMPUTATION_FOOTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\5217\522B\540D\521B\5EFA\8BA1\7B97\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284071371491872397)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E1'
,p_message_language=>'zh-cn'
,p_message_text=>'(B+C)*100'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284071421070872397)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E2'
,p_message_language=>'zh-cn'
,p_message_text=>'INITCAP(B)||'', ''||INITCAP(C)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284071532678872397)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E3'
,p_message_language=>'zh-cn'
,p_message_text=>'CASE WHEN A = 10 THEN B + C ELSE B END'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283663453437872091)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E4'
,p_message_language=>'zh-cn'
,p_message_text=>'ROUND(C / 1000000)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283954683233872312)
,p_name=>'APEXIR_COMPUTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284038006611872373)
,p_name=>'APEXIR_CONTROL_BREAK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63A7\5236\5206\6BB5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284046224002872379)
,p_name=>'APEXIR_CONTROL_BREAKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63A7\5236\5206\6BB5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284926785497873015)
,p_name=>'APEXIR_CONTROL_BREAK_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63A7\5236\4E2D\65AD\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283655655256872085)
,p_name=>'APEXIR_COUNT_DISTINCT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\540C\503C\8BA1\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284919119312873010)
,p_name=>'APEXIR_COUNT_DISTINCT_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\540C\503C\8BA1\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284919086500873010)
,p_name=>'APEXIR_COUNT_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\6570 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284522167638872723)
,p_name=>'APEXIR_DAILY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285011605354873078)
,p_name=>'APEXIR_DATA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284042386942872376)
,p_name=>'APEXIR_DATA_AS_OF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5206\949F\4E4B\524D\7684\62A5\8868\6570\636E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284873418138872976)
,p_name=>'APEXIR_DATA_GRID_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\7F51\683C\5E2E\52A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283826518526872214)
,p_name=>'APEXIR_DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284917679421873009)
,p_name=>'APEXIR_DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284068551917872395)
,p_name=>'APEXIR_DEFAULT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284915726829873007)
,p_name=>'APEXIR_DEFAULT_REPORT_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\62A5\8868\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283798245941872193)
,p_name=>'APEXIR_DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283955468452872312)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\9009\5B9A\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283827412641872215)
,p_name=>'APEXIR_DELETE_CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\5426\8981\5220\9664\8FD9\4E9B\62A5\8868\8BBE\7F6E?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284072763316872398)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\5426\8981\6267\884C\6B64\5220\9664\64CD\4F5C?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284806440717872927)
,p_name=>'APEXIR_DELETE_DEFAULT_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\9ED8\8BA4\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284037781108872373)
,p_name=>'APEXIR_DELETE_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283796858252872192)
,p_name=>'APEXIR_DESCENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\964D\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283838379347872223)
,p_name=>'APEXIR_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF4\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284031219301872368)
,p_name=>'APEXIR_DETAIL_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\884C\89C6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284069581267872396)
,p_name=>'APEXIR_DIRECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B9\5411 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284046749837872379)
,p_name=>'APEXIR_DISABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7981\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284070720848872396)
,p_name=>'APEXIR_DISABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\7981\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283826683995872214)
,p_name=>'APEXIR_DISPLAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283797715355872192)
,p_name=>'APEXIR_DISPLAYED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283825248692872213)
,p_name=>'APEXIR_DISPLAYED_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\7684\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284069437895872395)
,p_name=>'APEXIR_DISPLAY_IN_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\62A5\8868\4E2D\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283798472664872193)
,p_name=>'APEXIR_DONUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5706\73AF\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284039193513872374)
,p_name=>'APEXIR_DOWN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5411\4E0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283954734002872312)
,p_name=>'APEXIR_DOWNLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\8F7D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283826407686872214)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \4E0D\805A\96C6 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284069305109872395)
,p_name=>'APEXIR_DO_NOT_DISPLAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284926968190873016)
,p_name=>'APEXIR_DUPLICATE_PIVOT_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8\8868\5934\5217\91CD\590D\3002\79FB\52A8\8868\5934\5217\7684\5217\8868\5FC5\987B\552F\4E00\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284927336744873016)
,p_name=>'APEXIR_EDIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284866023897872970)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\66FF\4EE3\9ED8\8BA4\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284042559561872376)
,p_name=>'APEXIR_EDIT_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\56FE\8868\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284072569140872398)
,p_name=>'APEXIR_EDIT_CHART2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\56FE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284073046351872398)
,p_name=>'APEXIR_EDIT_FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284568937517872755)
,p_name=>'APEXIR_EDIT_GROUP_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\5206\7EC4\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284072962649872398)
,p_name=>'APEXIR_EDIT_HIGHLIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\7A81\51FA\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284385690030872626)
,p_name=>'APEXIR_EDIT_PIVOT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\79FB\52A8\8868\5934')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284916018336873008)
,p_name=>'APEXIR_EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283741369426872150)
,p_name=>'APEXIR_EMAIL_ADDRESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\5730\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284916396452873008)
,p_name=>'APEXIR_EMAIL_BCC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\9001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284916554766873008)
,p_name=>'APEXIR_EMAIL_BODY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\6587')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284916287613873008)
,p_name=>'APEXIR_EMAIL_CC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6284\9001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284917287794873008)
,p_name=>'APEXIR_EMAIL_FREQUENCY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9891\7387')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283776186137872176)
,p_name=>'APEXIR_EMAIL_NOT_CONFIGURED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\4E3A\6B64\5E94\7528\7A0B\5E8F\914D\7F6E\7535\5B50\90AE\4EF6\3002\8BF7\4E0E\7BA1\7406\5458\8054\7CFB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284521238488872723)
,p_name=>'APEXIR_EMAIL_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\7535\5B50\90AE\4EF6\5730\5740\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284916619812873008)
,p_name=>'APEXIR_EMAIL_SEE_ATTACHED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\9644\52A0\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284916475393873008)
,p_name=>'APEXIR_EMAIL_SUBJECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284523138929872724)
,p_name=>'APEXIR_EMAIL_SUBJECT_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\7535\5B50\90AE\4EF6\4E3B\9898\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284916190703873008)
,p_name=>'APEXIR_EMAIL_TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6536\4EF6\4EBA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284046672460872379)
,p_name=>'APEXIR_ENABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283795172181872190)
,p_name=>'APEXIR_ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\542F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284072803327872398)
,p_name=>'APEXIR_ENABLE_DISABLE_ALT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528/\7981\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284072279680872397)
,p_name=>'APEXIR_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284071696841872397)
,p_name=>'APEXIR_EXAMPLES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\793A\4F8B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284072690050872398)
,p_name=>'APEXIR_EXAMPLES_WITH_COLON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\793A\4F8B:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283825124555872213)
,p_name=>'APEXIR_EXCLUDE_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\9664\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284073576395872398)
,p_name=>'APEXIR_EXPAND_COLLAPSE_ALT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C55\5F00/\6298\53E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284070441645872396)
,p_name=>'APEXIR_EXPRESSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\8FBE\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283954230030872311)
,p_name=>'APEXIR_FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284046131338872379)
,p_name=>'APEXIR_FILTERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284130659590872440)
,p_name=>'APEXIR_FILTER_EXPRESSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668\8868\8FBE\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284993547441873064)
,p_name=>'APEXIR_FILTER_EXPR_TOO_LONG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668\8868\8FBE\5F0F\592A\957F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284130511516872440)
,p_name=>'APEXIR_FILTER_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284073763583872399)
,p_name=>'APEXIR_FINDER_ALT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\8981\641C\7D22\7684\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283954574176872312)
,p_name=>'APEXIR_FLASHBACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\95EA\56DE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284070103526872396)
,p_name=>'APEXIR_FLASHBACK_DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\95EA\56DE\67E5\8BE2\53EF\4EE5\67E5\770B\4E4B\524D\7684\67D0\4E2A\65F6\95F4\70B9\4E0A\5B58\5728\7684\6570\636E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284072076037872397)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\6267\884C\95EA\56DE\8BF7\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284521816949872723)
,p_name=>'APEXIR_FLASHBACK_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\95EA\56DE\6301\7EED\65F6\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284530454914872729)
,p_name=>'APEXIR_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\683C\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283924707578872289)
,p_name=>'APEXIR_FORMAT_MASK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\683C\5F0F\63A9\7801 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284037492522872372)
,p_name=>'APEXIR_FUNCTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FD\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284071198753872397)
,p_name=>'APEXIR_FUNCTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FD\6570 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284915630119873007)
,p_name=>'APEXIR_FUNCTIONS_OPERATORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FD\6570/\8FD0\7B97\7B26')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284503300943872711)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FD\6570\5217 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284036983411872372)
,p_name=>'APEXIR_FUNCTION_N'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FD\6570 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283954032944872311)
,p_name=>'APEXIR_GO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\59CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284521724264872723)
,p_name=>'APEXIR_GRAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7070\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283795637906872191)
,p_name=>'APEXIR_GREEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EFF\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283655708822872085)
,p_name=>'APEXIR_GROUP_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\7EC4\65B9\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284916740282873008)
,p_name=>'APEXIR_GROUP_BY_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\5206\7EC4\65B9\5F0F\201D\5217 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284396893390872634)
,p_name=>'APEXIR_GROUP_BY_COL_NOT_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\201C\5206\7EC4\65B9\5F0F\201D\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284503102200872710)
,p_name=>'APEXIR_GROUP_BY_MAX_ROW_CNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Group By \67E5\8BE2\7684\6700\5927\884C\8BA1\6570\5C06\9650\5236\57FA\672C\67E5\8BE2\4E2D\7684\884C\6570, \800C\4E0D\662F\663E\793A\7684\884C\6570\3002\60A8\7684\57FA\672C\67E5\8BE2\8D85\8FC7\4E86\6700\5927\884C\8BA1\6570 (%0)\3002\8BF7\5E94\7528\8FC7\6EE4\5668\6765\51CF\5C11\57FA\672C\67E5\8BE2\4E2D\7684\8BB0\5F55\6570\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284317272895872576)
,p_name=>'APEXIR_GROUP_BY_SORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\6392\5E8F\5206\7EC4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284926842993873015)
,p_name=>'APEXIR_GROUP_BY_SORT_ORDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\6392\5E8F\987A\5E8F\5206\7EC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283825770972872214)
,p_name=>'APEXIR_HCOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6C34\5E73\67F1\72B6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284063995265872391)
,p_name=>'APEXIR_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E2E\52A9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284029577924872366)
,p_name=>'APEXIR_HELP_01'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5229\7528\4EA4\4E92\5F0F\62A5\8868, \6700\7EC8\7528\6237\53EF\4EE5\5B9A\5236\62A5\8868\3002\7528\6237\53EF\4EE5\901A\8FC7\9009\62E9\5217, \5E94\7528\8FC7\6EE4\5668, \7A81\51FA\663E\793A\5E76\8FDB\884C\6392\5E8F, \6765\53D8\66F4\62A5\8868\6570\636E\7684\5E03\5C40\3002\6B64\5916, \7528\6237\8FD8\53EF\4EE5\5B9A\4E49\5206\6BB5, \805A\96C6, \56FE\8868, \5206\7EC4\65B9\5F0F\4EE5\53CA\6DFB\52A0\81EA\5DF1\7684\8BA1\7B97\3002\7528\6237\8FD8\53EF\4EE5\8BBE\7F6E\8BA2\9605, \4EE5\4FBF\6309\6307\5B9A\7684\65F6\95F4\95F4\9694\901A\8FC7\7535\5B50\90AE\4EF6\53D1\9001 HTML \683C\5F0F\7684\62A5\8868\3002\7528\6237\53EF\4EE5\521B\5EFA\62A5\8868\7684\591A\4E2A\53D8\4F53\5E76\5C06\5B83\4EEC\4FDD\5B58\4E3A\547D\540D\62A5\8868, \4EE5\4F9B\516C\4F17\6216\4E2A\4EBA\67E5\770B\3002'),
'<p/>',
unistr('\4E0B\9762\7684\90E8\5206\6C47\603B\4E86\53EF\5B9A\5236\4EA4\4E92\5F0F\62A5\8868\7684\65B9\5F0F\3002\8981\4E86\89E3\8BE6\7EC6\4FE1\606F, \8BF7\53C2\9605 <i>Oracle Application Express End User''s Guide</i></a> \4E2D\7684 "Using Interactive Reports"\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284046983114872379)
,p_name=>'APEXIR_HELP_ACTIONS_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\64CD\4F5C\201D\83DC\5355\663E\793A\5728\641C\7D22\680F\4E0A\201C\5F00\59CB\201D\6309\94AE\7684\53F3\4FA7\3002\4F7F\7528\6B64\83DC\5355\53EF\4EE5\5B9A\5236\4EA4\4E92\5F0F\62A5\8868\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284030530527872367)
,p_name=>'APEXIR_HELP_AGGREGATE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\201C\805A\96C6\201D\662F\5BF9\5217\6267\884C\7684\6570\5B66\8BA1\7B97\3002\5728\6BCF\4E2A\63A7\5236\5206\6BB5\4E4B\540E\548C\62A5\8868\7684\7ED3\5C3E, \805A\96C6\663E\793A\5728\5B9A\4E49\5B83\4EEC\7684\5217\4E2D\3002\9009\9879\5305\62EC:'),
'<p>',
'</p><ul>',
unistr('<li><b>\805A\96C6</b>, \7528\4E8E\9009\62E9\5148\524D'),
unistr('\5B9A\4E49\7684\805A\96C6\8FDB\884C\7F16\8F91\3002</li>'),
unistr('<li><b>\51FD\6570</b>, \662F\8981\6267\884C\7684\51FD\6570 (\4F8B\5982 SUM, MIN)\3002</li>'),
unistr('<li><b>\5217</b>, \7528\4E8E\9009\62E9\8981\5BF9\5176\5E94\7528\6570\5B66\51FD\6570\7684\5217\3002\5C06\53EA\663E\793A'),
unistr('\6570\5B57\5217\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284030644650872367)
,p_name=>'APEXIR_HELP_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\53EF\4EE5\4E3A\6BCF\4E2A\4FDD\5B58\7684\62A5\8868\5B9A\4E49\4E00\4E2A\56FE\8868\3002\5B9A\4E49'),
unistr('\4E4B\540E, \4F7F\7528\641C\7D22\680F\4E0A\7684\67E5\770B\56FE\6807\53EF\4EE5\5728\56FE\8868\89C6\56FE\548C\62A5\8868\89C6\56FE\4E4B\95F4\5207\6362\3002'),
unistr('\9009\9879\5305\62EC:'),
'<p>',
'</p><ul>',
unistr('<li><b>\56FE\8868\7C7B\578B</b>, \6807\8BC6\8981\5305\62EC\7684\56FE\8868\7C7B\578B\3002'),
unistr('\53EF\4EE5\5728\6C34\5E73\6761\5F62\56FE, \5782\76F4\6761\5F62\56FE, \997C\56FE\6216\6298\7EBF\56FE\4E2D\9009\62E9\3002</li>'),
unistr('<li><b>\6807\7B7E</b>, \7528\4E8E\9009\62E9\7528\4F5C\6807\7B7E\7684\5217\3002</li>'),
unistr('<li><b>\6807\7B7E\7684\8F74\6807\9898</b>, \662F\5728\4E0E\4E3A\201C\6807\7B7E\201D\9009\62E9\7684\5217\5173\8054\7684\8F74\4E0A\663E\793A\7684'),
unistr('\6807\9898\3002\6B64\9879\5BF9\4E8E\997C\56FE\4E0D\53EF\7528\3002</li>'),
unistr('<li><b>\503C</b>, \7528\4E8E\9009\62E9\8981\4F5C\4E3A\503C\4F7F\7528\7684\5217\3002\5982\679C\51FD\6570\4E3A'),
unistr('COUNT, \5219\4E0D\9700\8981\9009\4E2D\201C\503C\201D\3002</li>'),
unistr('<li><b>\503C\7684\8F74\6807\9898</b>, \662F\5728\4E0E\4E3A\201C\503C\201D\9009\62E9\7684\5217\5173\8054\7684\8F74\4E0A\663E\793A\7684'),
unistr('\6807\9898\3002\6B64\9879\5BF9\4E8E\997C\56FE\4E0D\53EF\7528\3002</li>'),
unistr('<li><b>\51FD\6570</b>, \662F\5728\4E3A\201C\503C\201D\9009\62E9\7684\5217\4E0A\6267\884C\7684\53EF\9009\51FD\6570\3002</li>'),
unistr('<li><b>\6392\5E8F</b>, \7528\4E8E\5BF9\7ED3\679C\96C6\8FDB\884C\6392\5E8F\3002</li></ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284029924670872367)
,p_name=>'APEXIR_HELP_COLUMN_HEADING_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5355\51FB\4EFB\610F\5217\6807\9898\53EF\4EE5\5C55\5F00\201C\5217\6807\9898\201D\83DC\5355\3002\9009\9879\5305\62EC:'),
'<p></p>',
'<ul>',
unistr('<li><b>\5347\5E8F\6392\5E8F</b>\56FE\6807, \7528\4E8E\6309\5217\7684\5347\5E8F\5BF9\62A5\8868\6392\5E8F\3002</li>'),
unistr('<li><b>\964D\5E8F\6392\5E8F</b>\56FE\6807, \7528\4E8E\6309\5217\7684\964D\5E8F\5BF9\62A5\8868\6392\5E8F\3002</li>'),
unistr('<li><b>\9690\85CF\5217</b>, \7528\4E8E\9690\85CF\5217\3002\5E76\975E\6240\6709\5217\90FD\53EF\4EE5\9690\85CF\3002\5982\679C\5217\65E0\6CD5\9690\85CF, \5C31\6CA1\6709\201C\9690\85CF\5217\201D\56FE\6807\3002</li>'),
unistr('<li><b>\5206\9694\5217</b>, \7528\4E8E\5728\5217\4E0A\521B\5EFA\5206\9694\7EC4\3002\8FD9\4F1A\4ECE\62A5\8868\4E2D\53D6\51FA\5217\4F5C\4E3A\4E3B\8BB0\5F55\3002</li>'),
unistr('<li><b>\5217\4FE1\606F</b>, \7528\4E8E\663E\793A\6709\5173\5217\7684\5E2E\52A9\6587\672C (\5982\679C\53EF\7528)\3002</li>'),
unistr('<li><b>\6587\672C\533A\57DF</b>, \7528\4E8E\8F93\5165\4E0D\533A\5206\5927\5C0F\5199\7684\641C\7D22\6807\51C6'),
unistr('(\65E0\9700\901A\914D\7B26)\3002\8F93\5165\4E00\4E2A\503C\5C06\51CF\5C11'),
unistr('\83DC\5355\5E95\90E8\7684\503C\5217\8868\3002\7136\540E\60A8\53EF\4EE5\4ECE'),
unistr('\5E95\90E8\9009\62E9\4E00\4E2A\503C, \6240\9009\7684\503C\5C06\4F7F\7528 ''='''),
unistr('\521B\5EFA\4E3A\8FC7\6EE4\5668 (\4F8B\5982, <code>column = ''ABC''</code>)\3002\6216\8005, \60A8\53EF\4EE5\5355\51FB\624B\7535\7B52\56FE\6807, \7136\540E\8F93\5165\4E00\4E2A\503C\4EE5\4F7F\7528 ''LIKE'''),
unistr('\4FEE\6539\7B26\5C06\8BE5\503C\521B\5EFA\4E3A\8FC7\6EE4\5668 (\4F8B\5982, <code>column LIKE ''%ABC%''</code>)\3002</li>'),
unistr('<li><b>\552F\4E00\503C\7684\5217\8868</b>, \5305\542B\6EE1\8DB3\8FC7\6EE4\6807\51C6'),
unistr('\7684\524D 500 \4E2A\552F\4E00\503C\3002\5982\679C\5217\4E3A\65E5\671F\5217, \5219\6539\4E3A'),
unistr('\663E\793A\65E5\671F\8303\56F4\5217\8868\3002\5982\679C\9009\62E9\4E00\4E2A\503C, \5219'),
unistr('\4F7F\7528 ''='' \521B\5EFA\8FC7\6EE4\5668 (\4F8B\5982, <code>column = ''ABC''</code>)\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284030464126872367)
,p_name=>'APEXIR_HELP_COMPUTE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7528\4E8E\5C06\8BA1\7B97\5217\6DFB\52A0\5230\62A5\8868\3002\8FD9\4E9B\53EF\4EE5\662F\6570\5B66\8BA1\7B97 (\4F8B\5982 <code>NBR_HOURS/24</code>) \6216\5728\73B0\6709\5217'),
unistr('\4E0A\5E94\7528\7684\6807\51C6 Oracle \51FD\6570\3002\5176\4E2D\90E8\5206\663E\793A\4E3A\793A\4F8B\548C\5176\4ED6\51FD\6570 (\4F8B\5982, <code>TO_DATE)</code> \4E5F\53EF\4EE5\4F7F\7528)\3002\9009\9879\5305\62EC:'),
'<p></p>',
'<ul>',
unistr('<li><b>\8BA1\7B97</b>, \7528\4E8E\9009\62E9\5148\524D\5B9A\4E49\7684\8BA1\7B97\8FDB\884C\7F16\8F91\3002</li>'),
unistr('<li><b>\5217\6807\9898</b>, \662F\65B0\5217\7684\5217\6807\9898\3002</li>'),
unistr('<li><b>\683C\5F0F\63A9\7801</b>, \662F\5BF9\5217\5E94\7528\7684 Oracle \683C\5F0F\63A9\7801 (\4F8B\5982 S9999)\3002</li>'),
unistr('<li><b>\8BA1\7B97</b>, \662F\8981\6267\884C\7684\8BA1\7B97\3002\5728\8BA1\7B97\4E2D, \4F7F\7528\663E\793A\7684\522B\540D\6765\5F15\7528\5217\3002</li>'),
'</ul>',
unistr('<p>\5728\201C\8BA1\7B97\201D\4E4B\4E0B, \663E\793A\67E5\8BE2\4E2D\7684\5217\4EE5\53CA'),
unistr('\5173\8054\7684\522B\540D\3002\5355\51FB\5217\540D\6216\522B\540D\4F1A\5C06\5176\5305\542B'),
unistr('\5728\8BA1\7B97\4E2D\3002\5728\201C\5217\201D\7684\65C1\8FB9\662F\952E\533A\3002\6B64\952E\533A\7528\4F5C'),
unistr('\5E38\7528\952E\7684\5FEB\6377\65B9\5F0F\3002\6700\53F3\4FA7\662F\201C\51FD\6570\201D\3002</p>'),
unistr('<p>\4E0B\9762\7684\8BA1\7B97\793A\4F8B\6F14\793A\5982\4F55\663E\793A\603B\8865\507F:</p>'),
'<pre>CASE WHEN A = ''SALES'' THEN B + C ELSE B END</pre>',
unistr('(\5176\4E2D A \4E3A ORGANIZATION, B \4E3A SALARY, C \4E3A COMMISSION)</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284047077592872379)
,p_name=>'APEXIR_HELP_CONTROL_BREAK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\4E8E\5728\4E00\5217\6216\591A\5217\4E0A\521B\5EFA\5206\9694\7EC4\3002\8FD9\5C06\4ECE\4EA4\4E92\5F0F\62A5\8868\4E2D\53D6\51FA\5217\5E76\5C06\5B83\4EEC\663E\793A\4E3A\4E3B\8BB0\5F55\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284031194217872368)
,p_name=>'APEXIR_HELP_DETAIL_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\6BCF\6B21\67E5\770B\4E00\884C\8BE6\7EC6\8D44\6599, \8BF7\5355\51FB\8981\67E5\770B\7684\884C\4E0A\7684\5355\884C\89C6\56FE\56FE\6807\3002\5982\679C\53EF\7528, \5219\5355\884C\89C6\56FE\5C06\59CB\7EC8\4E3A\7B2C\4E00\5217\3002\6839\636E\4EA4\4E92\5F0F\62A5\8868\7684\5B9A\5236, \5355\884C\89C6\56FE\53EF\4EE5\662F\6807\51C6\89C6\56FE\6216\5141\8BB8\66F4\65B0\7684\5B9A\5236\9875\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284031000332872368)
,p_name=>'APEXIR_HELP_DOWNLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5141\8BB8\4E0B\8F7D\5F53\524D\7ED3\679C\96C6\3002\4E0B\8F7D\683C\5F0F'),
unistr('\4F1A\56E0\5B89\88C5\548C\62A5\8868\5B9A\4E49\7684\4E0D\540C\800C\5F02, \53EF\4EE5'),
unistr('\5305\62EC CSV, HTML, \7535\5B50\90AE\4EF6, XLS, PDF \6216 RTF\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284030164463872367)
,p_name=>'APEXIR_HELP_FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\901A\8FC7\6DFB\52A0\6216\4FEE\6539\67E5\8BE2\4E0A\7684 <code>WHERE</code> \5B50\53E5\6765\805A\7126\62A5\8868\3002\53EF\4EE5\6309\5217\6216\6309\884C\8FDB\884C\8FC7\6EE4\3002'),
unistr('<p>\5982\679C\6309\5217\8FDB\884C\8FC7\6EE4, \5219\9996\5148\9009\62E9\4E00\5217 (\4E0D\5FC5'),
unistr('\662F\663E\793A\7684\5217), \4ECE\6807\51C6 Oracle \8FD0\7B97\7B26 (=, !=, not in, between) \4E2D\8FDB\884C\9009\62E9, \7136\540E\8F93\5165\7528\4E8E\8FDB\884C\6BD4\8F83\7684\8868\8FBE\5F0F\3002\8868\8FBE\5F0F\533A\5206\5927\5C0F\5199\3002\4F7F\7528 % \4F5C\4E3A\901A\914D\7B26 (\4F8B\5982 <code>STATE_NAME'),
unistr('like A%)</code>\3002</p>'),
unistr('<p>\5982\679C\6309\884C\8FDB\884C\8FC7\6EE4, \5219\53EF\4EE5\4F7F\7528\5217\522B\540D\53CA\4EFB\4F55 Oracle \51FD\6570\6216\8FD0\7B97\7B26'),
unistr('(\4F8B\5982 <code>G = ''VA'' \6216 G = ''CT''</code>, \5176\4E2D <code>G</code>'),
unistr('\662F <code>CUSTOMER_STATE</code> \7684\522B\540D) \521B\5EFA\590D\6742 <code>WHERE</code> \5B50\53E5\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284030747884872367)
,p_name=>'APEXIR_HELP_FLASHBACK'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4F7F\7528\95EA\56DE\67E5\8BE2\53EF\4EE5\67E5\770B\4E4B\524D\7684\67D0\4E2A\65F6\95F4\70B9\4E0A\5B58\5728\7684\6570\636E\3002'),
unistr('\9ED8\8BA4\53EF\4EE5\95EA\56DE\7684\65F6\95F4\957F\5EA6\662F 3 \4E2A\5C0F\65F6 (\6216 180'),
unistr('\5206\949F), \4F46\5B9E\9645\7684\95EA\56DE\65F6\95F4\957F\5EA6\5C06\6839\636E\6570\636E\5E93\7684\4E0D\540C\800C\5F02\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284530354829872729)
,p_name=>'APEXIR_HELP_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\201C\683C\5F0F\201D\53EF\4EE5\5B9A\5236\62A5\8868\7684\663E\793A\3002'),
unistr('\201C\683C\5F0F\201D\5305\542B\4E0B\5217\5B50\83DC\5355:</p>'),
unistr('<ul><li>\6392\5E8F</li>'),
unistr('<li>\63A7\5236\5206\6BB5</li>'),
unistr('<li>\7A81\51FA\663E\793A</li>'),
unistr('<li>\8BA1\7B97</li>'),
unistr('<li>\805A\96C6</li>'),
unistr('<li>\56FE\8868</li>'),
unistr('<li>\5206\7EC4\65B9\5F0F</li>'),
unistr('<li>\79FB\52A8\8868\5934</li>'),
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284521077749872723)
,p_name=>'APEXIR_HELP_GROUP_BY'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\53EF\4EE5\4E3A\6BCF\4E2A\4FDD\5B58\7684\62A5\8868\5B9A\4E49\4E00\4E2A'),
unistr('\5206\7EC4\65B9\5F0F\89C6\56FE\3002\5B9A\4E49\4E4B\540E, \4F7F\7528\641C\7D22\680F\4E0A\7684\89C6\56FE\56FE\6807\53EF\4EE5'),
unistr('\5728\5206\7EC4\65B9\5F0F\89C6\56FE\548C\62A5\8868\89C6\56FE\4E4B\95F4\5207\6362\3002\8981\521B\5EFA\5206\7EC4\65B9\5F0F\89C6\56FE,'),
unistr('\8BF7\9009\62E9:'),
'<p></p><ul>',
unistr('<li>\8981\5206\7EC4\7684\5217</li>'),
unistr('<li>\8981\805A\96C6\7684\5217\4EE5\53CA\8981\6267\884C\7684\51FD\6570 (average, sum, count \7B49)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284030336483872367)
,p_name=>'APEXIR_HELP_HIGHLIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7528\4E8E\5B9A\4E49\8FC7\6EE4\5668\3002\4F7F\7528\4E0E\8FC7\6EE4\5668\5173\8054\7684\7279\6027\7A81\51FA\663E\793A\6EE1\8DB3\8BE5\8FC7\6EE4\6807\51C6\7684\884C\3002\9009\9879\5305\62EC:</p>'),
'<ul>',
unistr('<li><b>\540D\79F0</b>, \4EC5\7528\4E8E\663E\793A\3002</li>'),
unistr('<li><b>\5E8F\5217</b>, \6807\8BC6\5BF9\89C4\5219\6C42\503C\65F6\4F7F\7528\7684\5E8F\5217\3002</li>'),
unistr('<li><b>\542F\7528</b>, \6807\8BC6\542F\7528\8FD8\662F\7981\7528\4E86\89C4\5219\3002</li>'),
unistr('<li><b>\7A81\51FA\663E\793A\7C7B\578B</b>, \6807\8BC6\5E94\7A81\51FA\663E\793A\884C\8FD8\662F'),
unistr('\5355\5143\3002\5982\679C\9009\62E9\201C\5355\5143\201D, \5219\7A81\51FA\663E\793A\5728'),
unistr('\7A81\51FA\663E\793A\6761\4EF6\4E2D\5F15\7528\7684\5217\3002</li>'),
unistr('<li><b>\80CC\666F\8272</b>, \662F\7A81\51FA\663E\793A\533A\57DF\7684\80CC\666F\7684\65B0\989C\8272\3002</li>'),
unistr('<li><b>\6587\672C\989C\8272</b>, \662F\7A81\51FA\663E\793A\533A\57DF\7684\6587\672C\7684\65B0\989C\8272\3002</li>'),
unistr('<li><b>\7A81\51FA\663E\793A\6761\4EF6</b>, \5B9A\4E49\8FC7\6EE4\6761\4EF6\3002</li>'),
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283627025703872063)
,p_name=>'APEXIR_HELP_PIVOT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\53EF\4EE5\4E3A\6BCF\4E2A\4FDD\5B58\7684\62A5\8868\5B9A\4E49\4E00\4E2A\79FB\52A8\8868\5934\89C6\56FE\3002\5B9A\4E49\4E4B\540E, \4F7F\7528\641C\7D22\680F\4E0A\7684\67E5\770B\56FE\6807\53EF\4EE5\5728\79FB\52A8\8868\5934\89C6\56FE\548C\62A5\8868\89C6\56FE\4E4B\95F4\5207\6362\3002\8981\521B\5EFA\79FB\52A8\8868\5934\89C6\56FE, \8BF7\9009\62E9: '),
'<p></p>',
'<ul>',
unistr('<li>\8981\79FB\52A8\8868\5934\7684\5217</li>'),
unistr('<li>\8981\663E\793A\4E3A\884C\7684\5217</li>'),
unistr('<li>\8981\805A\96C6\7684\5217\4EE5\53CA\8981\6267\884C\7684\51FD\6570 (average, sum, count \7B49)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284071847032872397)
,p_name=>'APEXIR_HELP_REPORT_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5982\679C\60A8\5B9A\5236\4E86\4EA4\4E92\5F0F\62A5\8868, \5219\62A5\8868\8BBE\7F6E\5C06\663E\793A'),
unistr('\5728\641C\7D22\680F\4E4B\4E0B, \62A5\8868\4E4B\4E0A\3002\4F7F\7528\5DE6\4FA7\7684\56FE\6807\53EF\4EE5\6298\53E0\548C\5C55\5F00\6B64\533A\57DF\3002'),
'<p>',
unistr('\5BF9\4E8E\6BCF\4E2A\62A5\8868\8BBE\7F6E, \60A8\53EF\4EE5\6267\884C\4EE5\4E0B\64CD\4F5C:'),
'</p><ul>',
unistr('<li>\901A\8FC7\5355\51FB\540D\79F0\6765\7F16\8F91\8BBE\7F6E\3002</li>'),
unistr('<li>\901A\8FC7\53D6\6D88\9009\4E2D\6216\9009\4E2D\201C\542F\7528/\7981\7528\201D\590D\9009\6846\6765\7981\7528/\542F\7528\8BBE\7F6E\3002\4F7F\7528\6B64\63A7\4EF6\53EF\4E34\65F6\5173\95ED\548C\5F00\542F\8BBE\7F6E\3002</li>'),
unistr('<li>\901A\8FC7\5355\51FB\201C\5220\9664\201D\56FE\6807\6765\5220\9664\8BBE\7F6E\3002</li>'),
'</ul>',
unistr('<p>\5982\679C\60A8\521B\5EFA\4E86\56FE\8868, \5206\7EC4\65B9\5F0F\6216\79FB\52A8\8868\5934, \5219\53EF\4EE5\4F7F\7528\53F3\4FA7\663E\793A\7684'),
unistr('\201C\62A5\8868\89C6\56FE\201D,\201C\56FE\8868\89C6\56FE\201D, \201C\5206\7EC4\65B9\5F0F\89C6\56FE\201D\548C\201C\79FB\52A8\8868\5934\89C6\56FE\201D\94FE\63A5\5728'),
unistr('\8FD9\4E9B\89C6\56FE\4E0E\57FA\7840\62A5\8868\4E4B\95F4\5207\6362\3002\5982\679C\60A8\6B63\5728\67E5\770B\56FE\8868, \5206\7EC4\65B9\5F0F\6216\79FB\52A8\8868\5934, '),
unistr('\5219\8FD8\53EF\4EE5\4F7F\7528\201C\7F16\8F91\201D\94FE\63A5\6765\7F16\8F91\8BBE\7F6E\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284030922708872368)
,p_name=>'APEXIR_HELP_RESET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\62A5\8868\91CD\7F6E\56DE\9ED8\8BA4\8BBE\7F6E, \8FD9\5C06\5220\9664\4EFB\4F55\6240\505A\7684\5B9A\5236\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284530667601872729)
,p_name=>'APEXIR_HELP_ROWS_PER_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\6BCF\9875\663E\793A\7684\8BB0\5F55\6570\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284030898160872367)
,p_name=>'APEXIR_HELP_SAVE_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4FDD\5B58\5B9A\5236\7684\62A5\8868\4EE5\4F9B\5C06\6765\4F7F\7528\3002\60A8\9700\8981\63D0\4F9B\540D\79F0\548C\53EF\9009\8BF4\660E, \5E76\53EF\5C06\8BE5\62A5\8868\8BBE\4E3A\53EF\4F9B\516C\5171 (\5373\53EF\8BBF\95EE\4E3B\8981\9ED8\8BA4\62A5\8868\7684\6240\6709\7528\6237) \8BBF\95EE\3002\53EF\4EE5\4FDD\5B58\56DB\79CD\7C7B\578B\7684\4EA4\4E92\5F0F\62A5\8868:</p>'),
'<ul>',
unistr('<li><strong>\4E3B\8981\9ED8\8BA4\503C</strong> (\4EC5\9650\5F00\53D1\8005)\3002\201C\4E3B\8981\9ED8\8BA4\503C\201D\662F\6700\521D\663E\793A\7684\62A5\8868\3002\4E0D\80FD\91CD\547D\540D\6216\5220\9664\4E3B\8981\9ED8\8BA4\62A5\8868\3002</li>'),
unistr('<li><strong>\66FF\4EE3\62A5\8868</strong> (\4EC5\9650\5F00\53D1\8005)\3002\5141\8BB8\5F00\53D1\8005\521B\5EFA\591A\4E2A\62A5\8868\5E03\5C40\3002\53EA\6709\5F00\53D1\8005\624D\80FD\4FDD\5B58, \91CD\547D\540D\6216\5220\9664\66FF\4EE3\62A5\8868\3002</li>'),
unistr('<li><strong>\516C\5171\62A5\8868</strong> (\6700\7EC8\7528\6237)\3002\53EF\7531\521B\5EFA\8BE5\62A5\8868\7684\7528\6237\4FDD\5B58, \91CD\547D\540D\6216\5220\9664\3002\5176\4ED6\7528\6237\53EF\4EE5\67E5\770B\62A5\8868\5E76\5C06\5E03\5C40\4FDD\5B58\4E3A\5176\4ED6\62A5\8868\3002</li>'),
unistr('<li><strong>\4E13\7528\62A5\8868</strong> (\6700\7EC8\7528\6237)\3002\53EA\6709\521B\5EFA\8BE5\62A5\8868\7684\7528\6237\624D\80FD\67E5\770B, \4FDD\5B58, \91CD\547D\540D\6216\5220\9664\5B83\3002</li>'),
'</ul>',
unistr('<p>\5982\679C\4FDD\5B58\5B9A\5236\7684\62A5\8868, \5219\4F1A\5728\884C\9009\62E9\5668\5DE6\4FA7\7684\641C\7D22\680F\4E2D\663E\793A\62A5\8868\9009\62E9\5668 (\5982\679C\542F\7528\4E86\6B64\529F\80FD)\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284029877583872367)
,p_name=>'APEXIR_HELP_SEARCH_BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\4E2A\62A5\8868\9875\9876\90E8\662F\641C\7D22\533A\57DF\3002\6B64\533A\57DF (\5373\641C\7D22\680F) \63D0\4F9B\4EE5\4E0B\529F\80FD:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284531212112872730)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ACTIONS_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<li>\4F7F\7528<b>\201C\64CD\4F5C\201D\83DC\5355</b>\53EF\4EE5\5B9A\5236\62A5\8868\3002\8BF7\53C2\9605\540E\7EED\533A\6BB5\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284530704090872729)
,p_name=>'APEXIR_HELP_SEARCH_BAR_FINDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<li>\4F7F\7528<b>\201C\9009\62E9\5217\201D\56FE\6807</b>\53EF\4EE5\6807\8BC6\8981\641C\7D22\7684\5217 (\6216\5168\90E8\5217)\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284531022227872729)
,p_name=>'APEXIR_HELP_SEARCH_BAR_REPORTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<li>\4F7F\7528<b>\62A5\8868</b>\53EF\4EE5\663E\793A\66FF\4EE3\9ED8\8BA4\62A5\8868\53CA\4FDD\5B58\7684\4E13\7528\6216\516C\5171\62A5\8868\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284530921222872729)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<li>\4F7F\7528<b>\884C\6570</b>\53EF\4EE5\8BBE\7F6E\6BCF\9875\663E\793A\7684\8BB0\5F55\6570\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284530830477872729)
,p_name=>'APEXIR_HELP_SEARCH_BAR_TEXTBOX'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li>\5728<b>\6587\672C\533A\57DF</b>, \60A8\53EF\4EE5\8F93\5165\4E0D\533A\5206\5927\5C0F\5199\7684\641C\7D22\6807\51C6 (\652F\6301\901A\914D\7B26)\3002</li>'),
unistr('<li>\5355\51FB<b>\201C\5F00\59CB\201D\6309\94AE</b>\53EF\4EE5\6267\884C\641C\7D22\3002\5F53\5149\6807\4F4D\4E8E\641C\7D22\6587\672C\533A\57DF\5185\65F6, \70B9\51FB Enter \952E\4E5F\4F1A\6267\884C\641C\7D22\3002</li>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284531143916872730)
,p_name=>'APEXIR_HELP_SEARCH_BAR_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<li><b>\89C6\56FE\56FE\6807</b>\5728\56FE\6807, \62A5\8868, \8BE6\7EC6\4FE1\606F, \56FE\8868, \5206\7EC4\65B9\5F0F\548C\62A5\8868\7684\79FB\52A8\8868\5934\89C6\56FE (\5982\679C\5DF2\5B9A\4E49) \4E4B\95F4\5207\6362\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284873538873872976)
,p_name=>'APEXIR_HELP_SEARCH_BAR_WS_MANAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<li>\4F7F\7528<b>\7BA1\7406</b>\53EF\4EE5\7BA1\7406\5C5E\6027, \5217, \884C\4EE5\53CA\67E5\770B\62A5\8868\6216\6570\636E\7F51\683C\7684\5386\53F2\8BB0\5F55\3002</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284030025544872367)
,p_name=>'APEXIR_HELP_SELECT_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\4E8E\4FEE\6539\663E\793A\7684\5217\3002\663E\793A\53F3\4FA7\7684\5217, \9690\85CF\5DE6\4FA7\7684\5217\3002\4F7F\7528\6700\53F3\4FA7\7684\7BAD\5934\53EF\4EE5\5BF9\663E\793A\7684\5217\91CD\65B0\6392\5E8F\3002\8BA1\7B97\5217\5C06\6DFB\52A0\524D\7F00 <b>**</b>\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284030227795872367)
,p_name=>'APEXIR_HELP_SORT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7528\4E8E\66F4\6539\4F5C\4E3A\6392\5E8F\4F9D\636E\7684\5217\5E76\786E\5B9A\662F\6309'),
unistr('\5347\5E8F\8FD8\662F\964D\5E8F\6392\5217\3002\8FD8\53EF\4EE5\6307\5B9A\5982\4F55\5904\7406'),
unistr('<code>NULL</code>\3002\9ED8\8BA4\8BBE\7F6E\59CB\7EC8\5C06 <code>NULL</code> \663E\793A\5728\6700\540E\6216\59CB\7EC8\5C06\5176\663E\793A\5728\6700\524D\9762\3002\5F97\5230\7684\6392\5E8F\65B9\5F0F\5C06\663E\793A\5728'),
unistr('\62A5\8868\4E2D\5217\6807\9898\7684\53F3\4FA7\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284520603359872722)
,p_name=>'APEXIR_HELP_SUBSCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\8BA2\9605\65F6, \60A8\9700\8981\63D0\4F9B\7535\5B50\90AE\4EF6\5730\5740 (\6216\591A\4E2A\7535\5B50\90AE\4EF6\5730\5740, \7528\9017\53F7\5206\9694), \7535\5B50\90AE\4EF6\4E3B\9898, \9891\7387\53CA\5F00\59CB\548C\7ED3\675F\65E5\671F\3002\6240\751F\6210\7684\7535\5B50\90AE\4EF6\5305\62EC HTML \683C\5F0F\7684\4EA4\4E92\5F0F\62A5\8868, \5176\4E2D\5305\542B\4F7F\7528\6DFB\52A0\8BA2\9605\65F6\63D0\4F9B\7684\62A5\8868\8BBE\7F6E\7684\5F53\524D\6570\636E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284873029987872976)
,p_name=>'APEXIR_HELP_WS_01'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6570\636E\7F51\683C\57FA\672C\4E0A\662F\53EF\9AD8\5EA6\5B9A\5236\7684\53EF\7F16\8F91\62A5\8868\3002\7528\6237\53EF\4EE5\901A\8FC7\9009\62E9\5217, \5E94\7528\8FC7\6EE4\5668, \7A81\51FA\663E\793A\5E76\8FDB\884C\6392\5E8F, \6765\53D8\66F4\62A5\8868\6570\636E\7684\5E03\5C40\3002\6B64\5916, \7528\6237\8FD8\53EF\4EE5\5B9A\4E49\5206\6BB5, \805A\96C6, \56FE\8868, \5206\7EC4\65B9\5F0F\4EE5\53CA\6DFB\52A0\81EA\5DF1\7684\8BA1\7B97\3002\7528\6237\53EF\4EE5\521B\5EFA\62A5\8868\7684\591A\4E2A\53D8\4F53\5E76\5C06\5B83\4EEC\4FDD\5B58\4E3A\547D\540D\62A5\8868, \4EE5\4F9B\4E2A\4EBA\67E5\770B\3002'),
'<p/>',
unistr('\53EF\4EE5\4F7F\7528\641C\7D22\680F,\201C\64CD\4F5C\201D\83DC\5355,\201C\7BA1\7406\201D\83DC\5355\6216\201C\5217\6807\9898\201D\83DC\5355\5B9A\5236\6570\636E\7F51\683C\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284925481727873014)
,p_name=>'APEXIR_HELP_WS_ACTIONS_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\64CD\4F5C\201D\83DC\5355\663E\793A\5728\641C\7D22\680F\4E0A\201C\5F00\59CB\201D\6309\94AE\7684\53F3\4FA7\3002\4F7F\7528\6B64\83DC\5355\53EF\4EE5\5B9A\5236\6570\636E\7F51\683C\62A5\8868\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284873825030872976)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\6DFB\52A0/\7F16\8F91\884C\201D\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284873948558872976)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8981\5411\6570\636E\7F51\683C\6DFB\52A0\884C, \8BF7\5355\51FB\201C\6DFB\52A0\884C\201D\3002\8981\7F16\8F91\884C\7684\8BE6\7EC6\8D44\6599, \8BF7\5728\8981\7F16\8F91\7684\884C\4E0A\5355\51FB\201C\7F16\8F91\884C\201D\56FE\6807 (\7B2C\4E00\5217)\3002\6B64\65F6\5C06\663E\793A\201C\6DFB\52A0/\7F16\8F91\884C\201D\9875, \5176\4E2D\663E\793A\4E86\6570\636E\7F51\683C\7684\5217\3002</p>'),
'',
unistr('<p>\7F16\8F91\884C\65F6, \53EF\4EE5\6267\884C\4EE5\4E0B\64CD\4F5C:</p>'),
'',
'<p><ul>',
unistr('<li><b>\5220\9664</b>\884C\3002</li>'),
unistr('<li><b>\5E94\7528\66F4\6539</b>\4EE5\4FDD\5B58\5BF9\884C\6240\505A\7684\66F4\6539\3002</li>'),
unistr('<li>\5728<b>\64CD\4F5C</b>\4E2D, \6DFB\52A0\884C, \6DFB\52A0\6587\4EF6, \6CE8\91CA, \94FE\63A5\6216\6807\8BB0\4EE5\53CA\590D\67E5\5386\53F2\8BB0\5F55\3002</li>'),
unistr('<li>\5BFC\822A\5230<b>\540E\9762\548C\524D\9762</b>\7684\884C\3002</li>'),
unistr('<li>\5728<b>\7BA1\7406</b>\4E2D, \8BBE\7F6E\5217\5C5E\6027, \5217\7EC4, \9A8C\8BC1\548C\503C\5217\8868\3002</li>'),
'</ul></p>',
'',
unistr('<p>\4F4D\4E8E\9875\5E95\90E8\7684\201C\6CE8\89E3\201D\533A\57DF\5C06\663E\793A\4E0E\5F53\524D\884C\5173\8054\7684\6240\6709\6587\4EF6, \6CE8\91CA, \94FE\63A5\6216\6807\8BB0\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284925565354873015)
,p_name=>'APEXIR_HELP_WS_CONTROL_BREAK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\4E8E\5728\4E00\5217\6216\591A\5217\4E0A\521B\5EFA\5206\9694\7EC4\3002\8FD9\5C06\4ECE\6570\636E\7F51\683C\4E2D\53D6\51FA\5217\5E76\5C06\5B83\4EEC\663E\793A\4E3A\4E3B\8BB0\5F55\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284873726381872976)
,p_name=>'APEXIR_HELP_WS_DOWNLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5141\8BB8\4E0B\8F7D\5F53\524D\7ED3\679C\96C6\3002\4E0B\8F7D\683C\5F0F'),
unistr('\5305\62EC CSV, HTML \6216\7535\5B50\90AE\4EF6\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284925608435873015)
,p_name=>'APEXIR_HELP_WS_REPORT_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5982\679C\60A8\5B9A\5236\4E86\6570\636E\7F51\683C\62A5\8868, \5219\62A5\8868\8BBE\7F6E\5C06\663E\793A'),
unistr('\5728\641C\7D22\680F\4E4B\4E0B, \62A5\8868\4E4B\4E0A\3002\4F7F\7528\5DE6\4FA7\7684\56FE\6807\53EF\4EE5\6298\53E0\548C\5C55\5F00\6B64\533A\57DF\3002'),
'<p>',
unistr('\5BF9\4E8E\6BCF\4E2A\62A5\8868\8BBE\7F6E, \60A8\53EF\4EE5\6267\884C\4EE5\4E0B\64CD\4F5C:'),
'</p><ul>',
unistr('<li>\901A\8FC7\5355\51FB\540D\79F0\6765\7F16\8F91\8BBE\7F6E\3002</li>'),
unistr('<li>\901A\8FC7\53D6\6D88\9009\4E2D\6216\9009\4E2D\201C\542F\7528/\7981\7528\201D\590D\9009\6846\6765\7981\7528/\542F\7528\8BBE\7F6E\3002\4F7F\7528\6B64\63A7\4EF6\53EF\4E34\65F6\5173\95ED\548C\5F00\542F\8BBE\7F6E\3002</li>'),
unistr('<li>\901A\8FC7\5355\51FB\201C\5220\9664\201D\56FE\6807\6765\5220\9664\8BBE\7F6E\3002</li>'),
'</ul>',
unistr('<p>\5982\679C\60A8\521B\5EFA\4E86\56FE\8868\6216\5206\7EC4\65B9\5F0F, \5219\53EF\4EE5\4F7F\7528\53F3\4FA7\663E\793A\7684'),
unistr('\201C\62A5\8868\89C6\56FE\201D,\201C\56FE\8868\89C6\56FE\201D\548C\201C\5206\7EC4\65B9\5F0F\89C6\56FE\201D\94FE\63A5\5728'),
unistr('\8FD9\4E9B\89C6\56FE\4E0E\57FA\7840\62A5\8868\4E4B\95F4\5207\6362\3002\5982\679C\60A8\6B63\5728\67E5\770B\56FE\8868\6216\5206\7EC4\65B9\5F0F, '),
unistr('\5219\8FD8\53EF\4EE5\4F7F\7528\201C\7F16\8F91\201D\94FE\63A5\6765\7F16\8F91\8BBE\7F6E\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284873657212872976)
,p_name=>'APEXIR_HELP_WS_SAVE_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4FDD\5B58\5B9A\5236\7684\6570\636E\7F51\683C\62A5\8868\5E03\5C40\4EE5\4F9B\5C06\6765\4F7F\7528\3002\60A8\9700\8981\63D0\4F9B\540D\79F0\548C\53EF\9009\8BF4\660E\3002\53EF\4EE5\4FDD\5B58\4E09\79CD\7C7B\578B\7684\6570\636E\7F51\683C\62A5\8868\5E03\5C40:</p>'),
'<ul>',
unistr('<li><strong>\4E3B\8981\9ED8\8BA4\503C</strong> (\4EC5\9650\7BA1\7406\5458)\3002\201C\4E3B\8981\9ED8\8BA4\503C\201D\662F\6700\521D\663E\793A\7684\5E03\5C40\3002\4E0D\80FD\91CD\547D\540D\6216\5220\9664\4E3B\8981\9ED8\8BA4\62A5\8868\3002</li>'),
unistr('<li><strong>\66FF\4EE3\62A5\8868</strong> (\4EC5\9650\7BA1\7406\5458)\3002\5141\8BB8\7BA1\7406\5458\521B\5EFA\591A\4E2A\62A5\8868\5E03\5C40\3002\53EA\6709\7BA1\7406\5458\624D\80FD\4FDD\5B58, \91CD\547D\540D\6216\5220\9664\66FF\4EE3\62A5\8868\3002</li>'),
unistr('<li><strong>\4E13\7528\62A5\8868</strong> (\6240\6709\7528\6237)\3002\521B\5EFA\8BE5\62A5\8868\5E03\5C40\7684\7528\6237\53EF\4EE5\67E5\770B, \4FDD\5B58, \91CD\547D\540D\6216\5220\9664\62A5\8868\3002</li>'),
'</ul>',
unistr('<p>\5982\679C\4FDD\5B58\5B9A\5236\7684\62A5\8868, \5219\4F1A\5728\884C\9009\62E9\5668\5DE6\4FA7\7684\641C\7D22\680F\4E2D\663E\793A\62A5\8868\9009\62E9\5668 (\5982\679C\542F\7528\4E86\6B64\529F\80FD)\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284042107565872376)
,p_name=>'APEXIR_HIDE_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9690\85CF\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283954436235872312)
,p_name=>'APEXIR_HIGHLIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A81\51FA\663E\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284046309383872379)
,p_name=>'APEXIR_HIGHLIGHTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A81\51FA\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284071925625872397)
,p_name=>'APEXIR_HIGHLIGHT_CONDITION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A81\51FA\663E\793A\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284521529100872723)
,p_name=>'APEXIR_HIGHLIGHT_STYLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A81\51FA\663E\793A\6837\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283795264193872190)
,p_name=>'APEXIR_HIGHLIGHT_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A81\51FA\663E\793A\7C7B\578B')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283795905841872191)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A81\51FA\663E\793A, \5F53')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284882176964872982)
,p_name=>'APEXIR_HORIZONTAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6C34\5E73')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284985678348873059)
,p_name=>'APEXIR_INACTIVE_SETTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('1 \4E2A\4E0D\6D3B\52A8\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284985781757873059)
,p_name=>'APEXIR_INACTIVE_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E2A\4E0D\6D3B\52A8\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284031502482872368)
,p_name=>'APEXIR_INTERACTIVE_REPORT_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EA4\4E92\5F0F\62A5\8868\5E2E\52A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284073297621872398)
,p_name=>'APEXIR_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284044831292872378)
,p_name=>'APEXIR_INVALID_COMPUTATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97\8868\8FBE\5F0F\65E0\6548\3002%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283742385212872150)
,p_name=>'APEXIR_INVALID_END_DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED3\675F\65E5\671F\5FC5\987B\665A\4E8E\5F00\59CB\65E5\671F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284191639482872484)
,p_name=>'APEXIR_INVALID_FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668\8868\8FBE\5F0F\65E0\6548\3002%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284918278831873009)
,p_name=>'APEXIR_INVALID_FILTER_QUERY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668\67E5\8BE2\65E0\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284985818012873059)
,p_name=>'APEXIR_INVALID_SETTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('1 \4E2A\65E0\6548\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284985927975873059)
,p_name=>'APEXIR_INVALID_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E2A\65E0\6548\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284521928067872723)
,p_name=>'APEXIR_IN_MINUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\FF08\5206\949F\FF09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284865036800872970)
,p_name=>'APEXIR_IS_IN_THE_LAST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\8FC7\53BB\7684 %1 \5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284865385641872970)
,p_name=>'APEXIR_IS_IN_THE_NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5728\672A\6765\7684 %1 \5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284865215726872970)
,p_name=>'APEXIR_IS_NOT_IN_THE_LAST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\8FC7\53BB\7684 %1 \5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284865499035872970)
,p_name=>'APEXIR_IS_NOT_IN_THE_NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E0D\5728\672A\6765\7684 %1 \5185')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284071010236872397)
,p_name=>'APEXIR_KEYPAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\952E\533A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283826210423872214)
,p_name=>'APEXIR_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284039784487872374)
,p_name=>'APEXIR_LABEL_AXIS_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E\7684\8F74\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284387024943872627)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E\524D\7F00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283958600883872315)
,p_name=>'APEXIR_LAST_DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB 1 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283958857715872315)
,p_name=>'APEXIR_LAST_HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB 1 \5C0F\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283958350080872314)
,p_name=>'APEXIR_LAST_MONTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E2A\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283958427018872314)
,p_name=>'APEXIR_LAST_WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\5468')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283958596755872315)
,p_name=>'APEXIR_LAST_X_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB %0 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283958757917872315)
,p_name=>'APEXIR_LAST_X_HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB %0 \5C0F\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283958140647872314)
,p_name=>'APEXIR_LAST_X_YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB %0 \5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283958244283872314)
,p_name=>'APEXIR_LAST_YEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53BB\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283826041591872214)
,p_name=>'APEXIR_LINE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6298\7EBF\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283798365744872193)
,p_name=>'APEXIR_LINE_WITH_AREA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EBF\5F62\9762\79EF\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284505299133872712)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\5355\51FB<a href=''%0''>\6B64\5904</a>\4EE5\7BA1\7406\8BA2\9605\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284918114403873009)
,p_name=>'APEXIR_MAP_IT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5730\56FE\5B9A\4F4D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284042757264872376)
,p_name=>'APEXIR_MAX_QUERY_COST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9884\8BA1\67E5\8BE2\4F1A\8D85\51FA\5141\8BB8\4F7F\7528\7684\8D44\6E90\4E0A\9650\3002\8BF7\4FEE\6539\62A5\8868\8BBE\7F6E, \7136\540E\91CD\8BD5\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283910916935872279)
,p_name=>'APEXIR_MAX_ROW_CNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\62A5\8868\7684\6700\5927\884C\6570\662F %0 \884C\3002\8BF7\5E94\7528\8FC7\6EE4\5668\6765\51CF\5C11\60A8\7684\67E5\8BE2\4E2D\7684\8BB0\5F55\6570\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284918729392873010)
,p_name=>'APEXIR_MAX_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5927\503C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284918952466873010)
,p_name=>'APEXIR_MEDIAN_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E2D\503C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283924614328872289)
,p_name=>'APEXIR_MIN_AGO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5206\949F\4E4B\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284918809069873010)
,p_name=>'APEXIR_MIN_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5C0F\503C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284917727870873009)
,p_name=>'APEXIR_MONTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284522349759872724)
,p_name=>'APEXIR_MONTHLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284073436916872398)
,p_name=>'APEXIR_MORE_DATA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\591A\6570\636E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284038690304872373)
,p_name=>'APEXIR_MOVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284038523570872373)
,p_name=>'APEXIR_MOVE_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\79FB\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285004043424873072)
,p_name=>'APEXIR_MULTIIR_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7531\4E8E\9875\5305\542B\591A\4E2A\4EA4\4E92\5F0F\62A5\8868, \5FC5\987B\6307\5B9A\533A\57DF\9759\6001 ID\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283797082429872192)
,p_name=>'APEXIR_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284027952960872365)
,p_name=>'APEXIR_NEW_AGGREGATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B0\5EFA\805A\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283820217436872209)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \65B0\7C7B\522B -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284987308432873060)
,p_name=>'APEXIR_NEW_CATEGORY_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B0\5EFA\7C7B\522B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284028084896872365)
,p_name=>'APEXIR_NEW_COMPUTATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B0\5EFA\8BA1\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283952790957872310)
,p_name=>'APEXIR_NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E00\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283959222290872315)
,p_name=>'APEXIR_NEXT_DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 1 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283959035696872315)
,p_name=>'APEXIR_NEXT_HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 1 \5C0F\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283959528268872315)
,p_name=>'APEXIR_NEXT_MONTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E2A\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283959421432872315)
,p_name=>'APEXIR_NEXT_WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\5468')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283959342740872315)
,p_name=>'APEXIR_NEXT_X_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 %0 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283959103579872315)
,p_name=>'APEXIR_NEXT_X_HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 %0 \5C0F\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283959788158872315)
,p_name=>'APEXIR_NEXT_X_YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6765 %0 \5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283959660518872315)
,p_name=>'APEXIR_NEXT_YEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E00\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283797399837872192)
,p_name=>'APEXIR_NO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5426')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284073694106872398)
,p_name=>'APEXIR_NONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \65E0 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284521320430872723)
,p_name=>'APEXIR_NOT_VALID_EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\662F\6709\6548\7684\7535\5B50\90AE\4EF6\5730\5740\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283955585666872312)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5B9A\4E49\805A\96C6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283909791484872278)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\5217\4FE1\606F\53EF\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283955678368872312)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5B9A\4E49\8BA1\7B97\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284917573024873009)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \65E0\7ED3\675F\65E5\671F -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284068729003872395)
,p_name=>'APEXIR_NULLS_ALWAYS_FIRST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A7A\503C\59CB\7EC8\5728\6700\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284068605118872395)
,p_name=>'APEXIR_NULLS_ALWAYS_LAST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A7A\503C\59CB\7EC8\5728\6700\540E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284069688432872396)
,p_name=>'APEXIR_NULL_SORTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A7A\503C\6392\5E8F %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284044923983872378)
,p_name=>'APEXIR_NUMERIC_FLASHBACK_TIME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\95EA\56DE\65F6\95F4\5FC5\987B\4E3A\6570\5B57\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284044480660872377)
,p_name=>'APEXIR_NUMERIC_SEQUENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E8F\5217\5FC5\987B\662F\6570\5B57\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284070394343872396)
,p_name=>'APEXIR_OPERATOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD0\7B97\7B26')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283795710755872191)
,p_name=>'APEXIR_ORANGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A59\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284882050215872982)
,p_name=>'APEXIR_ORIENTATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B9\5411')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283797808947872192)
,p_name=>'APEXIR_OTHER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5176\4ED6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284919272119873010)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_COUNT_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\603B\8BA1\6570\7684\767E\5206\6BD4 (%)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284918475916873009)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_SUM_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\603B\548C\7684\767E\5206\6BD4 (%)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284916956609873008)
,p_name=>'APEXIR_PERCENT_TOTAL_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\8BA1\6570\7684\767E\5206\6BD4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284916811634873008)
,p_name=>'APEXIR_PERCENT_TOTAL_SUM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\548C\7684\767E\5206\6BD4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283825977400872214)
,p_name=>'APEXIR_PIE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\997C\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284360722790872608)
,p_name=>'APEXIR_PIVOT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8\8868\5934')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284388309833872628)
,p_name=>'APEXIR_PIVOT_AGG_NOT_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\805A\96C6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284388646667872629)
,p_name=>'APEXIR_PIVOT_AGG_NOT_ON_ROW_COL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\5728\9009\62E9\4F5C\4E3A\884C\5217\7684\5217\4E0A\805A\96C6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284386173605872627)
,p_name=>'APEXIR_PIVOT_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8\8868\5934\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284385978865872627)
,p_name=>'APEXIR_PIVOT_COLUMN_N'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8\8868\5934\5217 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284388194400872628)
,p_name=>'APEXIR_PIVOT_COLUMN_NOT_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\79FB\52A8\8868\5934\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283626907084872063)
,p_name=>'APEXIR_PIVOT_MAX_ROW_CNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8\8868\5934\67E5\8BE2\7684\6700\5927\884C\8BA1\6570\5C06\9650\5236\57FA\672C\67E5\8BE2\4E2D\7684\884C\6570, \800C\4E0D\662F\663E\793A\7684\884C\6570\3002\60A8\7684\57FA\672C\67E5\8BE2\8D85\8FC7\4E86\6700\5927\884C\8BA1\6570 (%0)\3002\8BF7\5E94\7528\8FC7\6EE4\5668\6765\51CF\5C11\57FA\672C\67E5\8BE2\4E2D\7684\8BB0\5F55\6570\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284999933200873069)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\9009\62E9\5176\4ED6\884C\5217\3002\884C\5217\4E2D\7684 HTML \8868\8FBE\5F0F\6216\94FE\63A5\5305\542B\5B9A\4E49\4E3A\79FB\52A8\8868\5934\5217\6216\805A\96C6\5217\7684\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284387101752872627)
,p_name=>'APEXIR_PIVOT_SORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8\8868\5934\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284521452902872723)
,p_name=>'APEXIR_PREVIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9884\89C8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283952833132872310)
,p_name=>'APEXIR_PREVIOUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E00\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284915822747873007)
,p_name=>'APEXIR_PRIMARY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284525111004872725)
,p_name=>'APEXIR_PRIMARY_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284185627898872480)
,p_name=>'APEXIR_PRIVATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E13\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283827319075872215)
,p_name=>'APEXIR_PUBLIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\516C\5171')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283797608652872192)
,p_name=>'APEXIR_RED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EA2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285003951983873072)
,p_name=>'APEXIR_REGION_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF\9759\6001 ID %0 \4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284038792960872373)
,p_name=>'APEXIR_REMOVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283951884265872310)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\805A\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284038801360872373)
,p_name=>'APEXIR_REMOVE_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284986034611873059)
,p_name=>'APEXIR_REMOVE_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\56FE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284038185905872373)
,p_name=>'APEXIR_REMOVE_CONTROL_BREAK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\63A7\5236\5206\6BB5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284037818837872373)
,p_name=>'APEXIR_REMOVE_FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284037935817872373)
,p_name=>'APEXIR_REMOVE_FLASHBACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\95EA\56DE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284986196439873059)
,p_name=>'APEXIR_REMOVE_GROUP_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\5220\9664\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284038241187872373)
,p_name=>'APEXIR_REMOVE_HIGHLIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\7A81\51FA\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284986296244873059)
,p_name=>'APEXIR_REMOVE_PIVOT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\79FB\52A8\8868\5934')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284927409863873016)
,p_name=>'APEXIR_REMOVE_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\62A5\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284806356943872927)
,p_name=>'APEXIR_RENAME_DEFAULT_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\547D\540D\9ED8\8BA4\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284074069092872399)
,p_name=>'APEXIR_RENAME_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\547D\540D\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283953336330872311)
,p_name=>'APEXIR_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284919302717873010)
,p_name=>'APEXIR_REPORTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283786884864872184)
,p_name=>'APEXIR_REPORT_ALIAS_DOES_NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\522B\540D %0 \4FDD\5B58\7684\4EA4\4E92\5F0F\62A5\8868\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284336235491872590)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\4E2D\7684\663E\793A\5217\6570\8FBE\5230\4E86\9650\5236\503C\3002\8BF7\5728\201C\64CD\4F5C\201D\83DC\5355\4E0B\5355\51FB\201C\9009\62E9\5217\201D\4EE5\6700\5C0F\5316\62A5\8868\663E\793A\5217\5217\8868\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284188957434872482)
,p_name=>'APEXIR_REPORT_DOES_NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283786930149872184)
,p_name=>'APEXIR_REPORT_ID_DOES_NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('ID \4E3A %0 \7684\5DF2\4FDD\5B58\4EA4\4E92\5F0F\62A5\8868\4E0D\5B58\5728\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284071701866872397)
,p_name=>'APEXIR_REPORT_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283925163688872289)
,p_name=>'APEXIR_REPORT_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\89C6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283954949803872312)
,p_name=>'APEXIR_RESET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\7F6E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283827501215872215)
,p_name=>'APEXIR_RESET_CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\62A5\8868\8FD8\539F\4E3A\9ED8\8BA4\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283797441700872192)
,p_name=>'APEXIR_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284911658795873004)
,p_name=>'APEXIR_ROWID_NOT_SUPPORTED_FOR_WEBSOURCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\80FD\4F7F\7528 ROWID \4F5C\4E3A Web \6E90\7684\4E3B\952E\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284036802321872372)
,p_name=>'APEXIR_ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284530501305872729)
,p_name=>'APEXIR_ROWS_PER_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\9875\884C\6570')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284386240190872627)
,p_name=>'APEXIR_ROW_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284386029686872627)
,p_name=>'APEXIR_ROW_COLUMN_N'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\5217 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284388299520872628)
,p_name=>'APEXIR_ROW_COLUMN_NOT_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\884C\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284388410050872628)
,p_name=>'APEXIR_ROW_COL_DIFF_FROM_PIVOT_COL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\5217\5FC5\987B\4E0D\540C\4E8E\79FB\52A8\8868\5934\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284133589871872442)
,p_name=>'APEXIR_ROW_FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283925244679872290)
,p_name=>'APEXIR_ROW_OF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B2C %0 \884C, \5171 %1 \884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283924469884872289)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\6392\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283956491604872313)
,p_name=>'APEXIR_ROW_TEXT_CONTAINS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\6587\672C\5305\542B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283646873773872078)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\4E2D\7684\663E\793A\5217\6570\8FBE\5230\4E86\9650\5236\503C\3002\8BF7\5728\201C\64CD\4F5C\201D\83DC\5355\4E0B\5355\51FB\201C\9009\62E9\5217\201D\4EE5\6700\5C0F\5316\62A5\8868\663E\793A\5217\5217\8868\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283796653416872191)
,p_name=>'APEXIR_SAVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284046590732872379)
,p_name=>'APEXIR_SAVED_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4FDD\5B58\7684\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284046450453872379)
,p_name=>'APEXIR_SAVED_REPORT_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4FDD\5B58\7684\62A5\8868 = "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283955322011872312)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53E6\5B58\4E3A\9ED8\8BA4\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284067954247872394)
,p_name=>'APEXIR_SAVE_DEFAULT_CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\62A5\8868\8BBE\7F6E\5C06\7528\4F5C\6240\6709\7528\6237\7684\9ED8\8BA4\503C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284806298897872927)
,p_name=>'APEXIR_SAVE_DEFAULT_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58\9ED8\8BA4\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283954864673872312)
,p_name=>'APEXIR_SAVE_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58\62A5\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284987297378873060)
,p_name=>'APEXIR_SAVE_REPORT_DEFAULT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58\62A5\8868 *')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284542169706872737)
,p_name=>'APEXIR_SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284031419207872368)
,p_name=>'APEXIR_SEARCH_BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22\680F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284987128151873060)
,p_name=>'APEXIR_SEARCH_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284591467462872771)
,p_name=>'APEXIR_SEARCH_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284503037485872710)
,p_name=>'APEXIR_SELECTED_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\9009\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283796981257872192)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9\7C7B\522B -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283798547098872193)
,p_name=>'APEXIR_SELECT_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9\5217 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283954162231872311)
,p_name=>'APEXIR_SELECT_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284073808559872399)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97\5217\5C06\6DFB\52A0\524D\7F00 **\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283826713544872214)
,p_name=>'APEXIR_SELECT_FUNCTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9\51FD\6570 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284036232242872371)
,p_name=>'APEXIR_SELECT_GROUP_BY_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9\201C\5206\7EC4\65B9\5F0F\201D\5217 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284385704128872626)
,p_name=>'APEXIR_SELECT_PIVOT_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9\79FB\52A8\8868\5934\5217 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284918314893873009)
,p_name=>'APEXIR_SELECT_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284385836581872627)
,p_name=>'APEXIR_SELECT_ROW_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9\884C\5217 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284917107015873008)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9\6392\5E8F\5217 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284073397198872398)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\4E00\4E2A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283636684576872071)
,p_name=>'APEXIR_SEND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283797100623872192)
,p_name=>'APEXIR_SEQUENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E8F\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283954352800872312)
,p_name=>'APEXIR_SORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284041980398872376)
,p_name=>'APEXIR_SORT_ASCENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5347\5E8F\6392\5E8F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284917027672873008)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F\5217 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284042009868872376)
,p_name=>'APEXIR_SORT_DESCENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\964D\5E8F\6392\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284926681471873015)
,p_name=>'APEXIR_SORT_ORDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F\987A\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284027586247872365)
,p_name=>'APEXIR_SPACE_AS_IN_ONE_EMPTY_STRING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A7A\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284070616847872396)
,p_name=>'APEXIR_STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\72B6\6001 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284522057162872723)
,p_name=>'APEXIR_SUBSCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA2\9605')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284917481842873009)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED3\675F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284502906129872710)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED3\675F\5355\5143')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284917302194873009)
,p_name=>'APEXIR_SUBSCRIPTION_STARTING_FROM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D77\59CB\4E8E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284918543648873009)
,p_name=>'APEXIR_SUM_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\548C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284867881144872972)
,p_name=>'APEXIR_TABLE_SUMMARY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF = %0, \62A5\8868 = %1, \89C6\56FE = %2, \663E\793A\7684\884C\5F00\5934 = %3, \663E\793A\7684\884C\672B\5C3E = %4, \603B\884C\6570 = %5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283977908486872329)
,p_name=>'APEXIR_TABLE_SUMMARY_NO_TOTAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF = %0\FF0C\62A5\8868 = %1\FF0C\89C6\56FE = %2\FF0C\663E\793A\7684\884C\5F00\5934 = %3\FF0C\663E\793A\7684\884C\672B\5C3E = %4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283795820388872191)
,p_name=>'APEXIR_TEXT_COLOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\672C\989C\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283911587959872279)
,p_name=>'APEXIR_TIME_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283911447531872279)
,p_name=>'APEXIR_TIME_HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C0F\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283911308340872279)
,p_name=>'APEXIR_TIME_MINS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\949F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283911782132872279)
,p_name=>'APEXIR_TIME_MONTHS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283911684287872279)
,p_name=>'APEXIR_TIME_WEEKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5468')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283911812844872279)
,p_name=>'APEXIR_TIME_YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284927283776873016)
,p_name=>'APEXIR_TOGGLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5207\6362')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284038939779872373)
,p_name=>'APEXIR_TOP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9876\90E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284072109803872397)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\6388\6743')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284901022681872996)
,p_name=>'APEXIR_UNGROUPED_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5206\7EC4\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284044667546872378)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\6807\9898\5FC5\987B\552F\4E00\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284044354040872377)
,p_name=>'APEXIR_UNIQUE_HIGHLIGHT_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A81\51FA\663E\793A\540D\79F0\5FC5\987B\552F\4E00\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283825027147872213)
,p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\652F\6301\7684\6570\636E\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284039082134872373)
,p_name=>'APEXIR_UP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5411\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284044592033872377)
,p_name=>'APEXIR_VALID_COLOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\8F93\5165\6709\6548\7684\989C\8272\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284044748892872378)
,p_name=>'APEXIR_VALID_FORMAT_MASK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\8F93\5165\6709\6548\7684\683C\5F0F\63A9\7801\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283797944945872192)
,p_name=>'APEXIR_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284039848295872374)
,p_name=>'APEXIR_VALUE_AXIS_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\7684\8F74\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284073125849872398)
,p_name=>'APEXIR_VALUE_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\9700\7684\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283825814661872214)
,p_name=>'APEXIR_VCOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5782\76F4\67F1\72B6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284882290945872983)
,p_name=>'APEXIR_VERTICAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5782\76F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284072343579872398)
,p_name=>'APEXIR_VIEW_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\56FE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284571262828872757)
,p_name=>'APEXIR_VIEW_DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\8BE6\7EC6\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284990311775873062)
,p_name=>'APEXIR_VIEW_DOES_NOT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\4E3A\62A5\8868\5B9A\4E49 %0 \89C6\56FE\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284571359133872757)
,p_name=>'APEXIR_VIEW_GROUP_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\5206\7EC4\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284571144013872757)
,p_name=>'APEXIR_VIEW_ICONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\56FE\6807')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284385588338872626)
,p_name=>'APEXIR_VIEW_PIVOT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\79FB\52A8\8868\5934')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284072422560872398)
,p_name=>'APEXIR_VIEW_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284917948073873009)
,p_name=>'APEXIR_WEEK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5468')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284522239917872723)
,p_name=>'APEXIR_WEEKLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\5468')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283953260309872311)
,p_name=>'APEXIR_WORKING_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284920109375873011)
,p_name=>'APEXIR_X_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284920030017873011)
,p_name=>'APEXIR_X_HOURS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5C0F\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284919924436873010)
,p_name=>'APEXIR_X_MINS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5206\949F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284920350156873011)
,p_name=>'APEXIR_X_MONTHS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E2A\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284920268477873011)
,p_name=>'APEXIR_X_WEEKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5468')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284920406353873011)
,p_name=>'APEXIR_X_YEARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284917815306873009)
,p_name=>'APEXIR_YEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283795543230872191)
,p_name=>'APEXIR_YELLOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9EC4\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283797217704872192)
,p_name=>'APEXIR_YES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283643904130872076)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Application Express \7BA1\7406\670D\52A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284866476480872971)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\4E3A\6B64\5E94\7528\7A0B\5E8F\914D\7F6E\9A8C\8BC1\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284039674710872374)
,p_name=>'APEX_GROUP.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5305\542B\65E0\6548\5B57\7B26 < \6216 >\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284256842060872532)
,p_name=>'APEX_REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284113543730872428)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EE5\4E0B\6570\636E\5E93\5BF9\8C61\5C06%0\5230\6240\9009\65B9\6848\4E2D:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284113677905872428)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6210\529F%0\4EE5\4E0B\6570\636E\5E93\5BF9\8C61:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284601578775872778)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5411\4E0B\6EDA\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284601663593872778)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6EDA\52A8\5230\9876\90E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283649582577872080)
,p_name=>'APEX_WIZARD_FORM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\8868\5355')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284865984094872970)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284284496610872552)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6548\5BF9\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284924318436873014)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5B58\5728\5BF9\7B49\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284869234247872973)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\521B\5EFA\7684\5BF9\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284869480548872973)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\8868\4E2D\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284869677223872973)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\5BF9\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284532338497872730)
,p_name=>'APEX_WS_SETUP_DROP_TABLES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284531694370872730)
,p_name=>'APEX_WS_SETUP_MSG1'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\5728 <b>%0</b> \65B9\6848\4E2D\521B\5EFA\8FD9\4E9B\5BF9\8C61\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284869724904872973)
,p_name=>'APEX_WS_SETUP_MSG10'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD9\4E9B\5BF9\8C61\5DF2\5B58\5728\4E8E <b>%0</b> \65B9\6848\4E2D\5E76\7531\5176\4ED6\5DE5\4F5C\533A\4F7F\7528\3002\5982\679C\7EE7\7EED, \5219\7531 <b>%0</b> \62E5\6709\7684\73B0\6709 Websheet \5BF9\8C61\4E5F\5C06\4E0E\6B64\5DE5\4F5C\533A\76F8\5173\8054\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284869855572872973)
,p_name=>'APEX_WS_SETUP_MSG11'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\9009\62E9\8981\7528\4E8E\8FD9\4E9B\5BF9\8C61\7684\65B9\6848:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284869992727872973)
,p_name=>'APEX_WS_SETUP_MSG12'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\4F7F\7528\7684\73B0\6709\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284870884588872974)
,p_name=>'APEX_WS_SETUP_MSG13'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\901A\8FC7\4EE5\4E0B\4FE1\606F\91CD\7528 Websheet \6570\636E\5E93\5BF9\8C61\3002\8BF7\786E\8BA4\60A8\7684\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284531780299872730)
,p_name=>'APEX_WS_SETUP_MSG2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\66F4\613F\610F\5728\65B0\65B9\6848\4E2D\521B\5EFA Websheet \5BF9\8C61, \8BF7\4F7F\7528<a href=%0>\8BF7\6C42\6570\636E\5E93\65B9\6848</a>\5411\5BFC\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284531881393872730)
,p_name=>'APEX_WS_SETUP_MSG3'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\8FD0\884C Websheets, \9700\8981\4EE5\4E0B\5BF9\8C61:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284531947775872730)
,p_name=>'APEX_WS_SETUP_MSG5'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\4F7F\7528\4EE5\4E0B\4FE1\606F\521B\5EFA Websheet \6570\636E\5E93\5BF9\8C61\3002\8BF7\786E\8BA4\60A8\7684\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284532026079872730)
,p_name=>'APEX_WS_SETUP_MSG6'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\521B\5EFA\7684\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284532174697872730)
,p_name=>'APEX_WS_SETUP_MSG7'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5C06\8981\5220\9664 Websheet \6570\636E\5E93\5BF9\8C61\3002\8FD9\5C06\5728\5DE5\4F5C\533A\4E2D\5220\9664 Websheet \6570\636E\5E93\5BF9\8C61\4EE5\53CA\5305\542B Websheet \7EC4\4EF6\7684\5185\90E8\6570\636E\3002\662F\5426\7EE7\7EED?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284532469276872730)
,p_name=>'APEX_WS_SETUP_MSG8'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\66F4\6B63\4EE5\4E0B\65E0\6548\5BF9\8C61\624D\80FD\6B63\5E38\8FD0\884C Websheets')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284869394820872973)
,p_name=>'APEX_WS_SETUP_MSG9'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5373\5C06\5220\9664\6B64\5DE5\4F5C\533A\7684 Websheet \5B9A\4E49\3002Websheet \6570\636E\5E93\5BF9\8C61\540C\65F6\7531\5176\4ED6\5DE5\4F5C\533A\4F7F\7528, \56E0\6B64\4E0D\4F1A\5220\9664\3002\4E0E\6B64\5DE5\4F5C\533A\5173\8054\7684\8BB0\5F55\5C06\88AB\5220\9664\3002\662F\5426\7EE7\7EED?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284532517750872730)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\8C61\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284532697423872731)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\8C61\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284532276529872730)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284869112325872973)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\4F7F\7528\7684\73B0\6709\5BF9\8C61')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283660868143872089)
,p_name=>'API_PRECONDITION_VIOLATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FDD\53CD API \524D\7F6E\6761\4EF6')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283819117452872208)
,p_name=>'APP.SETTING.CANNOT.GET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7531\4E8E\7981\7528\4E86\5173\8054\7684\6784\5EFA\9009\9879\FF0C\65E0\6CD5\83B7\53D6\5E94\7528\7A0B\5E8F\8BBE\7F6E %0 \7684\503C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283819087721872208)
,p_name=>'APP.SETTING.CANNOT.SET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7531\4E8E\7981\7528\4E86\5173\8054\7684\6784\5EFA\9009\9879\FF0C\65E0\6CD5\4E3A\5E94\7528\7A0B\5E8F\8BBE\7F6E %0 \8BBE\7F6E\503C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284895805003872992)
,p_name=>'APP.SETTING.INVALID.VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8BBE\7F6E %0 \503C\65E0\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284895734285872992)
,p_name=>'APP.SETTING.NOT.DEFINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5B9A\4E49\8BF7\6C42\7684\5E94\7528\7A0B\5E8F\8BBE\7F6E %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284895942733872993)
,p_name=>'APP.SETTING.VALUE.NOT.NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8BBE\7F6E %0 \4E0D\80FD\8BBE\7F6E\4E3A\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283712250372872128)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8BA1\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283712176404872128)
,p_name=>'APPLICACTION_PROCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\5904\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284277416394872547)
,p_name=>'APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284357630259872606)
,p_name=>'APPLICATION BUILDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\6784\5EFA\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284182191295872477)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8BA1\7B97\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284184824855872479)
,p_name=>'APPLICATION IMAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\56FE\50CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284182287173872477)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\5904\7406\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284108950090872424)
,p_name=>'APPLICATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284254605717872531)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284154981614872458)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\6D3B\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284195420450872487)
,p_name=>'APPLICATION_ALIAS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\522B\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284193458421872486)
,p_name=>'APPLICATION_DELETED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\5DF2\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283643688928872076)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\5F00\53D1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284194479751872486)
,p_name=>'APPLICATION_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\8BC6\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284151524005872455)
,p_name=>'APPLICATION_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\7F16\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284040827885872375)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F ID \662F\4FDD\7559\7684\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284040718822872375)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F ID \5FC5\987B\662F\6B63\6574\6570\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284572926352872758)
,p_name=>'APPLICATION_IMAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\56FE\50CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284224790538872509)
,p_name=>'APPLICATION_ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283741248792872150)
,p_name=>'APPLICATION_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283706669968872123)
,p_name=>'APPLICATION_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284195382011872487)
,p_name=>'APPLICATION_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284923908430873013)
,p_name=>'APPLICATION_NAMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284317715103872577)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8986\76D6 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284192994346872485)
,p_name=>'APPLICATION_OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284923806153873013)
,p_name=>'APPLICATION_PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283829393953872216)
,p_name=>'APPLICATION_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284193162623872485)
,p_name=>'APPLICATION_STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\72B6\6001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284279415373872549)
,p_name=>'APPLICATION_VERSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\7248\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283659258286872088)
,p_name=>'APPLICATION_X'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284138755943872446)
,p_name=>'APPROVED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6279\51C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284199699490872490)
,p_name=>'APP_SUCCESS_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6210\529F\521B\5EFA\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284926508877873015)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\677F\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283693650574872114)
,p_name=>'APP_TYPE_DATABASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283693728390872114)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\751F\4EA7\529B\6216\793A\4F8B\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284221115247872506)
,p_name=>'APP_TYPE_PACKAGED_WS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\793A\4F8B Websheet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283693555650872114)
,p_name=>'APP_TYPE_WEBSHEET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Websheet \5E94\7528\7A0B\5E8F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284138228126872446)
,p_name=>'ARCHIVED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5F52\6863')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283706995889872124)
,p_name=>'ARCHIVELOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\5FD7\5F52\6863: \6253\5F00')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283957834473872314)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53C2\6570\5FC5\987B\5177\6709\6821\9A8C\548C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284053661571872384)
,p_name=>'ARGUMENT_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53C2\6570\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284053824685872384)
,p_name=>'ARGUMENT_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53C2\6570\7C7B\578B')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284132105159872441)
,p_name=>'ASAP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C3D\5FEB')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284128773728872439)
,p_name=>'ASSIGNED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5206\914D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283826925605872214)
,p_name=>'ASSIGNEE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\914D\4EBA\5458')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284951443715873033)
,p_name=>'ASSIGN_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\914D %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283887503016872261)
,p_name=>'ASSOCIATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\8054\7684')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283828895737872216)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\8054\7684\529F\80FD')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284160175559872461)
,p_name=>'ATTACHMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9644\4EF6')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284967833797873046)
,p_name=>'AT_RISK_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6709\98CE\9669')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283857432986872238)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\5E94\7528\7A0B\5E8F\7684\5B9A\5236\9A8C\8BC1\9009\9879\5C06\88AB\8FC1\79FB\5230\9A8C\8BC1\65B9\6848\4E2D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283856966795872237)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\9A8C\8BC1\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283857305267872238)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\5236\9A8C\8BC1\51FD\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283857018341872238)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\767B\5F55\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283857207129872238)
,p_name=>'AUTH.LOGIN_URL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\767B\5F55 URL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283857158145872238)
,p_name=>'AUTH.NONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283862531224872242)
,p_name=>'AUTHENTICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284183164662872478)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1\51FD\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284182829465872478)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283877609812872253)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5C06\8981\5220\9664\5E94\7528\7A0B\5E8F %0 \4E2D\7684\9A8C\8BC1\65B9\6848\3002\5982\679C\6B64\5E94\7528\7A0B\5E8F\5F53\524D\672A\4F7F\7528 SCHEME \9A8C\8BC1\6216\5982\679C\65B9\6848\4E0D\662F\5F53\524D\9A8C\8BC1\65B9\6848, \5219\5220\9664\8BE5\65B9\6848\4E0D\4F1A\5BF9\6B64\5E94\7528\7A0B\5E8F\7684\64CD\4F5C\9020\6210\5F71\54CD\3002\5982\679C\6B64\5E94\7528\7A0B\5E8F\4F7F\7528 SCHEME \9A8C\8BC1, \5E76\4E14\8BE5\65B9\6848\662F\5F53\524D\9A8C\8BC1\65B9\6848, \5219\6B64\5E94\7528\7A0B\5E8F\5C06\7EE7\7EED\4F7F\7528 SCHEME \9A8C\8BC1\8FD0\884C, \4F46\662F\7528\9ED8\8BA4\9A8C\8BC1\65B9\6848\8FD0\884C\3002\6B64\64CD\4F5C\5C06\4F7F\7528\5E26\6709 "\5F00\95E8" \8EAB\4EFD\8BC1\660E\9A8C\8BC1 (\5373\5141\8BB8\4EFB\4F55\4EBA\8FD0\884C\6B64\5E94\7528\7A0B\5E8F) \7684\5185\7F6E\767B\5F55\9875\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283879527055872255)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\51FB\201C\8BBE\4E3A\5F53\524D\201D\6309\94AE\53EF\4F7F\5E94\7528\7A0B\5E8F\4F7F\7528\6B64\9A8C\8BC1\65B9\6848\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284387443325872628)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Application Express \5E10\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283640298189872073)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'zh-cn'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284387548819872628)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284387826722872628)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284387693119872628)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\5E10\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284820849374872937)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTTP \6807\5934\53D8\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284388091272872628)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_language=>'zh-cn'
,p_message_text=>'Oracle Application Server Single Sign-On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284387798439872628)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('LDAP \76EE\5F55')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284387999153872628)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\95E8\8EAB\4EFD\8BC1\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283630474918872066)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SAML \767B\5F55')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283668933379872095)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\793E\4EA4\767B\5F55')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284225865281872510)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284182766716872478)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6388\6743\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283640392229872073)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'zh-cn'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283659473368872088)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B58\5728 SQL \67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283659507910872088)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD4\56DE\5E03\5C14\503C\7684 PL/SQL \51FD\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284036634848872372)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\89D2\8272\6216\7EC4\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284036702406872372)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5728\89D2\8272\6216\7EC4\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283659667079872088)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\8FBE\5F0F 1 \4E2D\7684\9879\503C\7B49\4E8E\8868\8FBE\5F0F 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283659730776872088)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\8FBE\5F0F 1 \7684\9879\4E0D\4E3A\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283659822813872088)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\8FBE\5F0F 1 \7684\9879\4E3A\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283659970450872088)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\8FBE\5F0F 1 \4E2D\7684\9879\503C\4E0D\7B49\4E8E\8868\8FBE\5F0F 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283660009460872088)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5B58\5728 SQL \67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283660106502872088)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\8FBE\5F0F 1 \4E2D\7684\9996\9009\9879\503C\7B49\4E8E\8868\8FBE\5F0F 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283660279963872088)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\8FBE\5F0F 1 \4E2D\7684\9996\9009\9879\503C\4E0D\7B49\4E8E\8868\8FBE\5F0F 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283725280877872137)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\6B21\9875\8BBF\95EE\6C42\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283725303506872137)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\4E2A\4F1A\8BDD\6C42\503C\4E00\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283662666693872090)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E10\6237\5DF2\5931\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283662518056872090)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E10\6237\5DF2\9501\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283662923642872090)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D85\8FC7\4E86\6700\5927\767B\5F55\5C1D\8BD5\6B21\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283663054139872091)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\77E5\7684\5185\90E8\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283662859491872090)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521D\6B21\4F7F\7528\5BC6\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283662733293872090)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\7801\4E0D\6B63\786E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283662339186872090)
,p_name=>'AUTH_SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5E38, \6210\529F\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283662487748872090)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\77E5\7684\7528\6237\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283777238427872177)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\77E5\7684\5DE5\4F5C\533A\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283787725169872185)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\77E5\7684\5DE5\4F5C\533A\540D\79F0: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283931567350872294)
,p_name=>'AUTOCOMMIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\4EA4\8BED\53E5\4E0D\9002\7528\3002\6240\6709\8BED\53E5\90FD\81EA\52A8\63D0\4EA4\3002')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284255236680872531)
,p_name=>'AUTOPROVISION_MODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9884\914D\6A21\5F0F')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283637974094872072)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B2C\4E00\4E2A\9879')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284281105879872550)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\7528\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283667553711872094)
,p_name=>'AVAILABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284484820920872698)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EA\53EF\7528\4E8E\5F00\53D1\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284484780288872698)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\901A\8FC7\5F00\53D1\8005\5DE5\5177\680F\53EF\7528')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284155723251872458)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E73\5747\5448\73B0\65F6\95F4 (\79D2)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283726088371872138)
,p_name=>'BACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5411\540E')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284136642430872444)
,p_name=>'BAR_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6761\5F62\56FE')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284558396444872748)
,p_name=>'BASIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\57FA\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283681385726872104)
,p_name=>'BASIC_DEVELOPER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\57FA\672C\5F00\53D1\8005')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284115920899872429)
,p_name=>'BEFORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E4B\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284929248291873017)
,p_name=>'BEFORE LIST ENTRY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\5217\8868\6761\76EE\4E4B\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284950102214873033)
,p_name=>'BEFORE_FIRST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B2C\4E00\4E2A\4E4B\524D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284186083017872480)
,p_name=>'BIND_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED1\5B9A\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284185369027872480)
,p_name=>'BIND_VARIABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED1\5B9A\53D8\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284185457340872480)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED1\5B9A\53D8\91CF\6807\7B7E')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284201281232872491)
,p_name=>'BLACK_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED1\8272\6587\672C')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283644722294872077)
,p_name=>'BLANK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A7A\767D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284159341772872461)
,p_name=>'BLOB_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('BLOB \5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284319425991872578)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\8F7D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283696459732872116)
,p_name=>'BLOB_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('BLOB \683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284319835353872578)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9644\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284319515979872578)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>'DOWNLOAD'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284319681297872578)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_language=>'zh-cn'
,p_message_text=>'IMAGE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284319749179872578)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5185\5D4C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284160310326872462)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('BLOB \683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284159836813872461)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\6B21\66F4\65B0\7684 BLOB \5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284159235545872461)
,p_name=>'BLOB_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('BLOB \8868')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284201178172872491)
,p_name=>'BLUE_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5170\8272\6587\672C')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284176391866872473)
,p_name=>'BRANCH CONDITION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\652F\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283729662857872141)
,p_name=>'BRANCHES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\652F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283953798921872311)
,p_name=>'BREADCRUMB'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284116687435872430)
,p_name=>'BREADCRUMB LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284116785908872430)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\957F\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283953820333872311)
,p_name=>'BREADCRUMBS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284209793058872498)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284224900433872509)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\6761\76EE: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284041097418872375)
,p_name=>'BREADCRUMB_PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284124894255872436)
,p_name=>'BREADCRUMB_REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283790021033872186)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6210\529F\521B\5EFA\9762\5305\5C51\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284119250540872432)
,p_name=>'BROWSE_ICON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\6D4F\89C8\201D\56FE\6807')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284119077695872432)
,p_name=>'BROWSE_PACKAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D4F\89C8\5305')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284053362976872384)
,p_name=>'BROWSE_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D4F\89C8\8868')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283648042518872079)
,p_name=>'BUFFER CACHE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F13\51B2\533A\9AD8\901F\7F13\5B58')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284132636428872442)
,p_name=>'BUG'
,p_message_language=>'zh-cn'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284156801366872459)
,p_name=>'BUGS'
,p_message_language=>'zh-cn'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284179336961872475)
,p_name=>'BUGS_ASSIGNED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5206\914D Bug')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284218554100872504)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5206\914D Bug')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283676689681872101)
,p_name=>'BUGS_CLOSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5173\95ED Bug (%0/%1):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284594025642872773)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5173\95ED Bug \767E\5206\6BD4 (%0/%1):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284218618594872504)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\5206\914D Bug')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284218709434872504)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\4FEE\590D\5B8C\6210\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284594499503872773)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Bug: %1 \4E2A\5DF2\5173\95ED, \5171 %0 \4E2A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284958332360873039)
,p_name=>'BUG_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>'Bug: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284172678966872471)
,p_name=>'BUILD QUERY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5EFA\7ACB\67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283639835021872073)
,p_name=>'BUILDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6784\5EFA\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284278614590872548)
,p_name=>'BUILDER.PLUGINS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D2\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284274185826872545)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('[\4E0D\652F\6301]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284568850765872755)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A\6D88\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283869807717872247)
,p_name=>'BUILD_OPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6784\5EFA\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284343094965872595)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6784\5EFA\9009\9879: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284957087011873038)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6784\5EFA\72B6\6001: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284343962775872596)
,p_name=>'BUILD_VERSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\7248\672C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284212144369872499)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5185\7F6E\5728\62A5\8868\6A21\677F\4E2D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284115179925872429)
,p_name=>'BUTTON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284115891655872429)
,p_name=>'BUTTON LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284321109927872579)
,p_name=>'BUTTON.ADD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283656497068872086)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\9009\6309\94AE\7684\6309\94AE\5C5E\6027\4E0D\80FD\5305\542B ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283656377083872086)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\9009\6309\94AE\7684\64CD\4F5C\5FC5\987B\8BBE\7F6E\4E3A ''\7531\52A8\6001\64CD\4F5C\5B9A\4E49''')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283656612843872086)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\9009\6309\94AE\4F7F\7528\7684 ''\6309\94AE\6A21\677F'' \672A\5305\542B #BUTTON_ID# \66FF\6362\5B57\7B26\4E32')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284320972833872579)
,p_name=>'BUTTON.DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283729999185872141)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\9875\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283706160573872123)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\62A5\8868\67E5\8BE2\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283693366451872113)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9664\975E\201C\6309\94AE\8BF7\6C42\6E90\7C7B\578B\201D\4E3A "\603B\4E3A\7A7A\503C", \5426\5219\5FC5\987B\4E3A\6240\6709\201C\6309\94AE\8BF7\6C42\6E90\7C7B\578B\201D\6307\5B9A\201C\6309\94AE\8BF7\6C42\201D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283694040716872114)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\6309\94AE\8BF7\6C42\6E90\7C7B\578B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283730091494872141)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A URL \76EE\6807\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283658932702872087)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\64CD\4F5C\4E3A ''\7531\52A8\6001\64CD\4F5C\5B9A\4E49'' \65F6, \6309\94AE\5C5E\6027\4E0D\80FD\5305\542B ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283731624706872142)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\56FE\50CF\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283731793163872142)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\6837\5F0F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283731504356872142)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\6A21\677F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283658850313872087)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\6309\94AE\6837\5F0F\4E3A ''\57FA\4E8E\6A21\677F\7684\6309\94AE'' \4E14\64CD\4F5C\4E3A ''\7531\52A8\6001\64CD\4F5C\5B9A\4E49'' \65F6, \6240\9009\6309\94AE\6A21\677F\5FC5\987B\5305\542B #BUTTON_ID# \66FF\6362\5B57\7B26\4E32')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283646446197872078)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\5220\9664\6309\94AE, \56E0\4E3A\5728\52A8\6001\64CD\4F5C (\9875: %0, \52A8\6001\64CD\4F5C: ''%1'', \64CD\4F5C: ''%2'', \5C5E\6027: ''\53D7\5F71\54CD\7684\5143\7D20'') \4E2D\5F15\7528\4E86\6309\94AE\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283646321255872078)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\5220\9664\6309\94AE, \56E0\4E3A\5728\52A8\6001\64CD\4F5C (\9875: %0, \52A8\6001\64CD\4F5C: ''%1'', \5C5E\6027: ''\65F6\95F4'') \4E2D\5F15\7528\4E86\6309\94AE\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284321062627872579)
,p_name=>'BUTTON.SUBMIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\4EA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284316958656872576)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\5728 "onclick" \5C5E\6027\4E2D\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284320426081872579)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\5728 "href" \5C5E\6027\4E2D\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283729829817872141)
,p_name=>'BUTTONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284186512534872481)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283638705029872072)
,p_name=>'BUTTON_CSS_CLASSES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE CSS \7C7B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283837250826872222)
,p_name=>'BUTTON_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\751F\6210\7684\6309\94AE ID \5C06\4E3A\6309\94AE\7684\9759\6001 ID (\5982\679C\5B9A\4E49), \6216\8005\4E3A\5185\90E8\751F\6210\7684 ID (\5982\679C\672A\5B9A\4E49), \683C\5F0F\4E3A ''B'' || [\5185\90E8\6309\94AE ID]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284956893898873038)
,p_name=>'BUTTON_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284191718565872484)
,p_name=>'BUTTON_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE\6A21\677F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283726766799872139)
,p_name=>'BYTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B57\8282')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284132227393872441)
,p_name=>'BY_NEXT_PATCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\901A\8FC7\4E0B\4E00\4E2A\8865\4E01\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284132350935872441)
,p_name=>'BY_NEXT_RELEASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\901A\8FC7\4E0B\4E00\4E2A\53D1\884C\7248')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285056268382873111)
,p_name=>'CA.ABOUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\4E8E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285022560602873086)
,p_name=>'CA.ABOUT.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\5173\4E8E\201D\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285022409731873086)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5305\542B\201C\5173\4E8E\6B64\5E94\7528\7A0B\5E8F\201D\9875\FF0C\5176\4E2D\63D0\4F9B\5E94\7528\7A0B\5E8F\7684\63CF\8FF0\3001\5E94\7528\7A0B\5E8F\7248\672C\548C\9875\8BA1\6570\3002'),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283847384121872230)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5185\5BB9\5BB9\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285056437104873111)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\5173\4E8E\201D\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285056562237873111)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6709\5173\6B64\5E94\7528\7A0B\5E8F\7684\6587\672C\53EF\4EE5\653E\7F6E\5728\6B64\5904\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285056104093873111)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\4E8E\6B64\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285068480501873120)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\4E8E\6B64\9884\89C8\53D1\884C\7248')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285022858820873086)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285058741249873113)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285048255232873105)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285021287077873085)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528\57FA\4E8E\89D2\8272\7684\7528\6237\6388\6743')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285022997514873086)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5728\5E94\7528\7A0B\5E8F\4E2D\52A0\5165\57FA\4E8E\89D2\8272\7684\7528\6237\9A8C\8BC1\3002'),
unistr('\7528\6237\53EF\4EE5\5B9A\4E49\4E3A\7BA1\7406\5458, \5185\5BB9\63D0\4F9B\8005\6216\8BFB\8005\3002'),
unistr('\7136\540E, \60A8\53EF\4EE5\76F4\63A5\5C06\5E94\7528\7A0B\5E8F\4E2D\5404\7EC4\4EF6 (\4F8B\5982\9875, \83DC\5355\6761\76EE, \533A\57DF, \5217, \9879, \6309\94AE\7B49) \7684\4E0D\540C\8BBF\95EE\6743\9650\5B9A\4E49\5230\4E0D\540C\89D2\8272\3002</p>'),
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6:'),
'<ul>',
unistr('<li>\7BA1\7406\9875\533A\57DF, \5E26\6709\8BBF\95EE\63A7\5236\529F\80FD\7684\94FE\63A5</li>'),
unistr('<li>\7528\6237\8868, \7528\4E8E\7BA1\7406\8BBF\95EE\63A7\5236</li>'),
unistr('<li>\914D\7F6E\9875, \7528\4E8E\8BBE\7F6E\5DF2\9A8C\8BC1\7528\6237\7684\8BBF\95EE\7EA7\522B</li>'),
unistr('<li>\914D\7F6E\9875, \7528\4E8E\6307\5B9A\7528\6237\540D\662F\5426\4E3A\7535\5B50\90AE\4EF6\5730\5740</li>'),
unistr('<li>\7BA1\7406\7528\6237\8BBF\95EE\9875, \7528\4E8E\62A5\544A\548C\7F16\8F91\7528\6237\8BBF\95EE\6743\9650</li>'),
unistr('<li>\6DFB\52A0\7528\6237\9875, \80FD\591F\6DFB\52A0\5355\4E2A\7528\6237</li>'),
unistr('<li>\6DFB\52A0\591A\4E2A\7528\6237\9875, \80FD\591F\6DFB\52A0\591A\4E2A\7528\6237 (\4EC5\9650\7535\5B50\90AE\4EF6\7528\6237\540D)</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285047168288873104)
,p_name=>'CA.ACCESS.ROLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285047810924873105)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\89D2\8272 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283766766945872169)
,p_name=>'CA.ACCESS.ROLES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285047211963873104)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E10\6237\5DF2\9501\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283794523746872190)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\786E\8BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285058504560873113)
,p_name=>'CA.ACL.INFORMATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('ACL \4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285059275973873113)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6743\9650\4E0D\8DB3, \7528\6237\4E0D\662F\7BA1\7406\5458')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285059397628873113)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\65E0\6743\67E5\770B\6B64\5E94\7528\7A0B\5E8F, \53EF\80FD\662F\56E0\4E3A\672A\6388\4E88\8BBF\95EE\6743\9650, \6216\8005\60A8\7684\5E10\6237\5DF2\9501\5B9A\3002\8BF7\4E0E\5E94\7528\7A0B\5E8F\7BA1\7406\5458\8054\7CFB\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285059442301873113)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6743\9650\4E0D\8DB3, \7528\6237\4E0D\662F\5185\5BB9\63D0\4F9B\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285048982320873106)
,p_name=>'CA.ACL.SAVED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4FDD\5B58\8BBF\95EE\63A7\5236\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285053602272873109)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C\6309\94AE HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285052533116873108)
,p_name=>'CA.ACTION.LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285052666371873108)
,p_name=>'CA.ACTION.LINK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C\94FE\63A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285055274431873110)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C\94FE\63A5 HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285040708895873100)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C\5DF2\5904\7406\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285046260813873104)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\5C0F\65F6\7EDF\8BA1\7684\6D3B\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285080583539873129)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D3B\52A8\9762\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285023047422873086)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D3B\52A8\62A5\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285022245573873086)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5305\62EC\7528\6237\6D3B\52A8\548C\9519\8BEF\62A5\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285023109172873086)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5305\542B\6709\5173\5E94\7528\7A0B\5E8F\7684\6700\7EC8\7528\6237\6D3B\52A8\7684\8BB8\591A\62A5\8868\3002\786E\5B9A\6700\6D3B\8DC3\7684\7528\6237\3001\4F7F\7528\6700\591A\7684\9875\3001\9875\6027\80FD\548C\5F15\53D1\7684\9519\8BEF\FF0C\4EE5\66F4\597D\5730\7406\89E3\5982\4F55\5229\7528\60A8\7684\5E94\7528\7A0B\5E8F\4EE5\53CA\6539\8FDB\65B9\9762\3002</p>'),
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6\FF1A'),
'<ul>',
unistr('<li>\6700\5E38\8BBF\95EE\7684\7528\6237\62A5\8868</li>'),
unistr('<li>\5E94\7528\7A0B\5E8F\9519\8BEF\65E5\5FD7\62A5\8868</li>'),
unistr('<li>\6309\9875\7EDF\8BA1\7684\9875\6027\80FD\3001\6D3B\52A8\548C\6027\80FD</li>'),
unistr('<li>\6309\9875\7EDF\8BA1\7684\5E94\7528\7A0B\5E8F\6D3B\52A8\62A5\8868</li>'),
unistr('<li>\9875\8BBF\95EE\91CF\8BE6\7EC6\4FE1\606F\62A5\8868</li>'),
'',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284168996106872468)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9E\9645\5F00\59CB\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285058476242873113)
,p_name=>'CA.ADD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285053873372873109)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\7535\5B50\90AE\4EF6\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285071417387873122)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\591A\4E2A\7528\6237 - \6B65\9AA4 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285056767112873111)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\65B0 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285039702950873099)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284912224741873005)
,p_name=>'CA.ADD.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285047964783873105)
,p_name=>'CA.ADD.USER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285071873057873122)
,p_name=>'CA.ADD.USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285024672747873088)
,p_name=>'CA.ADDING.PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\6DFB\52A0\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285025147304873088)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\5355\51FB<strong>\6DFB\52A0\9875</strong>\53EF\5C06\9875\6DFB\52A0\5230\5E94\7528\7A0B\5E8F\3002\7136\540E\FF0C\9009\62E9\9875\7C7B\578B\FF08\4F8B\5982\7A7A\767D\3001\56FE\8868\3001\8868\5355\3001\62A5\8868\7B49\FF09\5E76\5B9A\4E49\5176\5C5E\6027\3002\8FD8\53EF\80FD\9700\8981\6307\5B9A\6709\6548\7684\8868\6216\89C6\56FE\FF0C\6216\8005\4F7F\7528 SQL \5DE5\4F5C\5BA4\5728\5DE5\4F5C\533A\4E2D\51C6\5907\6570\636E\5E93\5BF9\8C61\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285054660457873110)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9AD8\7EA7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284168290824872467)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9644\52A0\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285047664595873105)
,p_name=>'CA.ADDRESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5730\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285027836794873090)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285028428879873090)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\6B64\5E94\7528\7A0B\5E8F\7684\5DF2\9A8C\8BC1\7528\6237\7684\8BBF\95EE\7EA7\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285026988562873089)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D3B\52A8\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285027967780873090)
,p_name=>'CA.ADMIN.ADD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285029628877873091)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285028333825873090)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\5458')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284203974821872493)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284314653077872574)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\754C\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285063240608873116)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285063336007873116)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\7EC4\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285026583107873089)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898\6837\5F0F\9009\62E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285026662330873089)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\9ED8\8BA4\5E94\7528\7A0B\5E8F\5916\89C2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285026220184873089)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\914D\7F6E\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285026110807873089)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528\6216\7981\7528\5E94\7528\7A0B\5E8F\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285027293214873089)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\9519\8BEF\65E5\5FD7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285027307476873090)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\544A\6B64\5E94\7528\7A0B\5E8F\8BB0\5F55\7684\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285026716271873089)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285026899026873089)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\5E94\7528\7A0B\5E8F\540D\79F0\548C\7B80\8981\8BF4\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285026383332873089)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285026477737873089)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EF4\62A4\5E94\7528\7A0B\5E8F\66F4\65B0\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285025853925873088)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285028200255873090)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D21\732E\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285079333744873128)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285079277063873128)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\5E94\7528\7A0B\5E8F\6D3B\52A8\5EA6\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285031359528873093)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\65F6\533A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285031441096873093)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\6B64\5E94\7528\7A0B\5E8F\7684\9ED8\8BA4\65F6\533A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285029159530873091)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285031587294873093)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285031611504873093)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\662F\5426\5E94\53D1\9001\7535\5B50\90AE\4EF6, \5982\679C\53D1\9001, \5E94\56DE\590D\7ED9\8C01')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285028638359873091)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53CD\9988')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285028954359873091)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53CD\9988\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285029043828873091)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\662F\5426\5E94\5141\8BB8\9644\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285028718383873091)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\53CD\9988')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285028884063873091)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\544A\5E94\7528\7A0B\5E8F\7528\6237\63D0\4EA4\7684\6240\6709\53CD\9988')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285029249721873091)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285029359196873091)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\6B64\5E94\7528\7A0B\5E8F\4F7F\7528\7684\7535\5B50\90AE\4EF6\6A21\677F HTML \548C CSS')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285025906631873089)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285026022764873089)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\4E3B\9875\4E0A\663E\793A\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285063999424873116)
,p_name=>'CA.ADMIN.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285027404939873090)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\6027\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285027532960873090)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\5E94\7528\7A0B\5E8F\9875\62A5\544A\6D3B\52A8\548C\6027\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285027691488873090)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\8BBF\95EE\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285027704589873090)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\7528\6237\62A5\544A\5404\9875\7684\8BBF\95EE\60C5\51B5, \5305\62EC\8BBF\95EE\65F6\95F4\548C\7528\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285028165471873090)
,p_name=>'CA.ADMIN.READERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BFB\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285072521167873123)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285072672808873123)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\6B64\5E94\7528\7A0B\5E8F\53D1\9001\57FA\4E8E\6A21\677F\7684\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285027031067873089)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5E38\8BBF\95EE\7684\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285027116711873089)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\7528\6237\6C47\603B\7684\9875\8BBF\95EE\91CF\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285028079403873090)
,p_name=>'CA.ADMIN.USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285028516892873090)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539\8BBF\95EE\63A7\5236\8BBE\7F6E\548C\7981\7528\8BBF\95EE\63A7\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285029446109873091)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\65E5\5FD7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285029525859873091)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\6B64\5E94\7528\7A0B\5E8F\53D1\9001\7684\7535\5B50\90AE\4EF6\7684\65E5\5FD7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283950516380872309)
,p_name=>'CA.ADVANCED'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\9AD8\7EA7</strong> - \5C55\5F00\53EF\67E5\770B\9AD8\7EA7\9009\9879\3002'),
'    <ul>',
unistr('      <li><strong>\8BBE\7F6E\4E3A\4E3B\9875</strong> - \4F7F\6B64\9875\6210\4E3A\5E94\7528\7A0B\5E8F\7684\4E3B\9875\3002<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\5C06\66F4\65B0\4EE5\524D\5B9A\4E49\4E3A\4E3B\9875\7684\4EFB\610F\9875\3002</li>'),
unistr('      <li><strong>\8BBE\7F6E\4E3A\7BA1\7406\9875</strong> - \5728\201C\7BA1\7406\201D\4E0B\65B9\6DFB\52A0\6B64\9875\FF0C\800C\4E0D\662F\4F5C\4E3A\5E94\7528\7A0B\5E8F\4E2D\7684\6B63\5E38\9875\3002\53EF\901A\8FC7\5355\51FB\4E3B\83DC\5355\4E2D\7684\201C\7BA1\7406\201D\FF0C\7136\540E\4ECE\201C\5E94\7528\7A0B\5E8F\7BA1\7406\201D\5217\8868\4E2D\9009\62E9\6765\8FDB\884C\8BBF\95EE\3002<br>'),
unistr('        <em><strong>\6CE8\FF1A</strong>\67D0\9875\4E0D\80FD\540C\65F6\4E3A\4E3B\9875\548C\201C\7BA1\7406\201D\4E0B\65B9\7684\9875\3002</em></li>'),
'      &nbsp;<br>',
unistr('      <li><strong>\9875\5E2E\52A9</strong> - \8F93\5165\8981\6DFB\52A0\5230\9875\7684\201C\5E2E\52A9\6587\672C\201D\4E2D\7684\6587\672C\3002</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283820882798872210)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\9AD8\7EA7</strong> - \5C55\5F00\4EE5\67E5\770B\9AD8\7EA7\9009\9879\3002'),
'    <ul>',
unistr('      <li><strong>\9875\5E2E\52A9</strong> - \8F93\5165\8981\6DFB\52A0\5230\9875\201C\5E2E\52A9\6587\672C\201D\7684\6587\672C\3002</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285064318381873117)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9AD8\7EA7\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285064457185873117)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\8BBE\7F6E\5176\4ED6\5B9A\4E49, \5B89\5168\548C\5168\7403\5316\8BBE\7F6E\3002\53EF\5728\521B\5EFA\5E94\7528\7A0B\5E8F\65F6\5E94\7528\8FD9\4E9B\8BBE\7F6E, \8FD8\53EF\5728\521B\5EFA\5E94\7528\7A0B\5E8F\540E\7F16\8F91\8FD9\4E9B\8BBE\7F6E\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285067416946873119)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\6709\5173\8BE6\7EC6\4FE1\606F, \8BF7\9605\8BFB\6BCF\4E2A\8BBE\7F6E\7684\9879\5E2E\52A9 (<span class="fa fa-question-circle" aria-hidden="true"></span>)\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285073224594873123)
,p_name=>'CA.AFTER.ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\4E4B\540E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285053524700873109)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\4E4B\540E HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285056667281873111)
,p_name=>'CA.ALL.COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285052701438873108)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\9009\62E9\9000\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284161805090872463)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\5728\53D7\9650\6A21\5F0F\4E0B\8FD0\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285046193639873103)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\9519\8BEF\65E5\5FD7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285042045046873100)
,p_name=>'CA.APP.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284214842522872501)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528\8FD8\662F\7981\7528\8BBF\95EE\63A7\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284214977336872501)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\4E8E\4E0D\5728\8BBF\95EE\63A7\5236\5217\8868\4E2D\7684\7528\6237\FF0C\5728\901A\8FC7\9A8C\8BC1\540E\5411\5176\6307\5B9A\7684\9ED8\8BA4\8BBF\95EE\7EA7\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285042425185873101)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\65B0\5E94\7528\7A0B\5E8F\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285042209018873101)
,p_name=>'CA.APP.SUBTITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B80\8981\8BF4\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285042337694873101)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\5904\8F93\5165\7684\6587\672C\663E\793A\5728\5E94\7528\7A0B\5E8F\4E3B\9875\4E0A\7684\5E94\7528\7A0B\5E8F\540D\79F0\4E0B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285031731932873093)
,p_name=>'CA.APPEARANCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5916\89C2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285031879049873093)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\5B9A\4E49\9ED8\8BA4\5E94\7528\7A0B\5E8F\989C\8272\65B9\6848 (\4E3B\9898\6837\5F0F, \5176\4E2D\786E\5B9A\4E86\5BFC\822A) \4EE5\53CA\7528\4E8E\5E94\7528\7A0B\5E8F\7684\56FE\6807\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285051218505873107)
,p_name=>'CA.APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285038372016873098)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\5916\89C2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285032362195873093)
,p_name=>'CA.APPLICATION.ICON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\56FE\6807')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285032488531873093)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\5355\51FB<strong>\9009\62E9\65B0\56FE\6807</strong>\53EF\9009\62E9\56FE\6807\989C\8272\548C\53EF\7528\56FE\6807\4E4B\4E00\3002\6240\505A\9009\62E9\5C06\663E\793A\5728\5E94\7528\7A0B\5E8F\7684\4E3B\9875\4E0A\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285032792448873094)
,p_name=>'CA.APPLICATION.ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285032886215873094)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\8F93\5165\5E94\7528\7A0B\5E8F\552F\4E00\7684\6570\5B57\6807\8BC6\7B26\3002\9ED8\8BA4\60C5\51B5\4E0B\6B64\5B57\6BB5\5305\542B\81EA\52A8\751F\6210\7684\6807\8BC6\7B26\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285051828342873108)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285044008691873102)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\4F1A\8BDD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285022608563873086)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285021550940873085)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\5E94\7528\7A0B\5E8F\540D\79F0\548C\7B80\8981\8BF4\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285022725503873086)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8BB8\5E94\7528\7A0B\5E8F\7BA1\7406\5458\66F4\65B0\5404\79CD\8BBE\7F6E, \4F8B\5982\5E94\7528\7A0B\5E8F\540D\79F0\548C\8BF4\660E, \9ED8\8BA4\65F6\533A\7B49\3002</p>'),
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6:'),
'<ul>',
unistr('<li>\7BA1\7406\9875\5217\8868\6761\76EE\548C\8868\5355</li>'),
unistr('<li>\80FD\591F\8BBE\7F6E\5E94\7528\7A0B\5E8F\540D\79F0</li>'),
unistr('<li>\80FD\591F\8BBE\7F6E\4E3B\9875\4E3B\89C6\89C9\533A\57DF\5B50\6807\9898</li>'),
unistr('<li>\80FD\591F\8BBE\7F6E\53CD\9988\6536\4EF6\4EBA (\4F7F\7528\53CD\9988\65F6)</li>'),
unistr('<li>\80FD\591F\8BBE\7F6E\5E94\7528\7A0B\5E8F\9ED8\8BA4\65F6\533A</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285078368297873127)
,p_name=>'CA.APPLICATIONITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285080153394873129)
,p_name=>'CA.APPLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285081914327873130)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\5E94\7528\5E94\7528\7A0B\5E8F\9ED8\8BA4\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285037540175873097)
,p_name=>'CA.APPLY.CHANGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\66F4\6539')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285079951544873128)
,p_name=>'CA.APPLY.FILTERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284312593037872573)
,p_name=>'CA.APP_BANNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\521B\5EFA\5E94\7528\7A0B\5E8F\5411\5BFC %0 \521B\5EFA\7684\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284313846233872574)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285084194197873132)
,p_name=>'CA.ATTACHMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9644\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284028270905872365)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9644\4EF6\8BA1\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285084298583873132)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9644\4EF6\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284028171581872365)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9644\4EF6\5927\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285080216466873129)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4E3A\6B64 %0 \5B9A\4E49\4E86\5C5E\6027\9ED8\8BA4\503C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285048308116873105)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EFB\4F55\5DF2\9A8C\8BC1\7528\6237\90FD\53EF\4EE5\8BBF\95EE\6B64\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285033524952873094)
,p_name=>'CA.AUTHENTICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285033664082873094)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\9009\62E9\7528\6237\9A8C\8BC1\5230\5E94\7528\7A0B\5E8F\7684\65B9\5F0F\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284164510801872465)
,p_name=>'CA.AUTO.DROP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81EA\52A8\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285044737025873102)
,p_name=>'CA.AVG.ELAPSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E73\5747\7528\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284211954900872499)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD4\56DE\4F5C\4E1A\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284028986967872366)
,p_name=>'CA.BCC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BC6\9001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285073105115873123)
,p_name=>'CA.BEFORE.ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\4E4B\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285053415202873109)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\4E4B\524D HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285054979850873110)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\4E4B\524D\5185\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285030241944873092)
,p_name=>'CA.BLANK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\7A7A\767D\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285030320696873092)
,p_name=>'CA.BLANK.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\7A7A\767D\9875\4F5C\4E3A\5360\4F4D\7B26\3002\5728\521B\5EFA\5E94\7528\7A0B\5E8F\4E4B\540E\FF0C\53EF\4EE5\4ECE\9875\8BBE\8BA1\5668\76F4\63A5\5728\9875\4E0A\521B\5EFA\533A\57DF\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\9875\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
unistr('<!--  <li><strong>\5305\62EC\9875\5BFC\822A</strong> - \9009\4E2D\6B64\9009\9879\53EF\663E\793A\5728\5E94\7528\7A0B\5E8F\4E2D\5B9A\4E49\7684\6240\6709\5176\4ED6\9875\7684\5361\7247\5217\8868\3002<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\6B64\9009\9879\901A\5E38\5728\5E94\7528\7A0B\5E8F\4E3B\9875\4E0A\4F7F\7528\3002</li>'),
'-->',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285063650170873116)
,p_name=>'CA.BLUEPRINT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\84DD\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285063702959873116)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\84DD\56FE\4EE5 JSON \683C\5F0F\5217\51FA\5E94\7528\7A0B\5E8F\5B9A\4E49\3002</p>'),
unistr('<p>\5F53\9996\6B21\8FDB\5165\6B64\5C4F\5E55\65F6, \5F53\524D\5E94\7528\7A0B\5E8F\5B9A\4E49\4F1A\8F6C\6362\4E3A JSON \6587\6863\5E76\663E\793A\3002\60A8\53EF\4EE5\7F16\8F91\6B64\6587\6863\4EE5\66F4\65B0\5E94\7528\7A0B\5E8F\5C5E\6027, \7136\540E\5355\51FB<strong>\5E94\7528\84DD\56FE</strong>\4EE5\66F4\6539\5F53\524D\5E94\7528\7A0B\5E8F\8BE6\7EC6\4FE1\606F\3002</p>'),
'<p>&nbsp;</p>',
unistr('<p>\5982\679C\60A8\9700\8981\521B\5EFA\5927\91CF\7684\7C7B\4F3C\9875, \53EF\590D\5236\4E00\9875\7684\76F8\5173 JSON \4EE3\7801, \591A\6B21\7C98\8D34\5E76\5BF9 JSON \7A0D\505A\8C03\6574, \8FD9\79CD\65B9\6CD5\8981\6BD4\9488\5BF9\6BCF\4E00\9875\624B\52A8\4F7F\7528<strong>\6DFB\52A0\9875</strong>\5FEB\5F97\591A\3002</p>'),
unistr('<p>\5355\51FB<strong>\52A0\8F7D\4EE5\524D\7684\84DD\56FE</strong>\53EF\5C06\84DD\56FE\66FF\6362\4E3A\4EE5\524D\6240\751F\6210\5E94\7528\7A0B\5E8F\4E2D\7684\5B9A\4E49\3002\8FD9\6837, \60A8\53EF\4EE5\975E\5E38\8F7B\677E\5730\8FED\4EE3\5E94\7528\7A0B\5E8F\8BBE\8BA1, \65B9\6CD5\662F\6DFB\52A0\5176\4ED6\9875, \66F4\6539\529F\80FD, \6216\8C03\6574\8BBE\7F6E, \7136\540E\518D\91CD\65B0\751F\6210\5E94\7528\7A0B\5E8F\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285052322219873108)
,p_name=>'CA.BODY1.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\6587 1 \6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285052489695873108)
,p_name=>'CA.BODY2.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\6587 2 \6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285073510584873124)
,p_name=>'CA.BOTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8C\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285038736762873098)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\652F\5230\7BA1\7406\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283949491548872308)
,p_name=>'CA.BUTTON.BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE\680F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285038477113873098)
,p_name=>'CA.BUTTONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285030911485873092)
,p_name=>'CA.CALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\65E5\5386\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285031056205873092)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\663E\793A\65E5\5386\7684\9875\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\9875\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
unistr('  <li><strong>\8868\6216\89C6\56FE</strong>\FF08\5FC5\9700\FF09- \4E3A\65E5\5386\9009\62E9\6570\636E\5E93\5BF9\8C61\3002</li>'),
unistr('  <li><strong>\663E\793A\5217</strong>\FF08\5FC5\9700\FF09- \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\5728\65E5\5386\4E8B\4EF6\4E2D\663E\793A\7684\5217\3002</li>'),
unistr('  <li><strong>\5F00\59CB\65E5\671F\5217</strong>\FF08\5FC5\9700\FF09- \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\7528\4F5C\65E5\5386\4E8B\4EF6\5F00\59CB\65E5\671F\7684\65E5\671F\5217\3002</li>'),
unistr('  <li><strong>\7ED3\675F\65E5\671F\5217</strong>\FF08\5FC5\9700\FF09- \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\7528\4F5C\65E5\5386\4E8B\4EF6\7ED3\675F\65E5\671F\7684\65E5\671F\5217\3002<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\5982\679C\6307\5B9A\4E86\7ED3\675F\65E5\671F\FF0C\5219\5C06\663E\793A\57FA\4E8E\6301\7EED\65F6\95F4\7684\4E8B\4EF6\3002</li>'),
unistr('  <li><strong>\663E\793A\65F6\95F4</strong> - \9009\62E9<strong>\662F</strong>\53EF\663E\793A\4E8B\4EF6\7684\65F6\95F4\90E8\5206\FF0C\8FD8\542F\7528\6BCF\5468\548C\6BCF\65E5\65E5\5386\89C6\56FE\3002\9009\62E9<strong>\5426</strong>\4EE5\4EC5\663E\793A\4E8B\4EF6\7684\65E5\671F\3002</li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285037497321873097)
,p_name=>'CA.CANCEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285039326726873099)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\53D6\6D88\201D\5BF9\8BDD\6846')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283929523383872293)
,p_name=>'CA.CANCEL.MODAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285049267480873106)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\65E0\6CD5\4ECE\81EA\5DF1\7684\8BB0\5F55\4E2D\5220\9664\7BA1\7406\6743\9650\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285081195897873129)
,p_name=>'CA.CARD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\5361\7247\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285081097750873129)
,p_name=>'CA.CARD.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\663E\793A\5361\7247\7684\9875\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\9875\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
unistr('  <li><strong>\8868\6216\89C6\56FE</strong>\FF08\5FC5\9700\FF09- \4E3A\65E5\5386\9009\62E9\6570\636E\5E93\5BF9\8C61\3002</li>'),
unistr('  <li><strong>\5361\7247\6807\9898</strong>\FF08\5FC5\9700\FF09- \4ECE\8868\6216\89C6\56FE\9009\62E9\7528\4F5C\5361\7247\6807\9898\7684\5217\3002</li>'),
unistr('  <li><strong>\63CF\8FF0\5217</strong>\FF08\5FC5\9700\FF09- \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\7528\4F5C\5361\7247\63CF\8FF0\7684\5217\3002</li>'),
unistr('  <li><strong>\9644\52A0\6587\672C\5217</strong> - \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\7528\4F5C\5361\7247\7684\8F85\52A9\63CF\8FF0\7684\5217\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285079691883873128)
,p_name=>'CA.CARDS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5361\7247')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285079711271873128)
,p_name=>'CA.CARDS.VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5361\7247\89C6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284029037082872366)
,p_name=>'CA.CC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6284\9001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284313295485872573)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285030044898873092)
,p_name=>'CA.CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\56FE\8868\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285030196551873092)
,p_name=>'CA.CHART.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\663E\793A\9762\79EF\56FE\3001\6761\5F62\56FE\3001\7EBF\5F62\56FE\6216\997C\56FE\7684\9875\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\9875\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
unistr('  <li><strong>\56FE\8868\7C7B\578B</strong> - \9009\62E9\8981\663E\793A\7684\56FE\8868\7C7B\578B [<strong>\9762\79EF\56FE</strong>\3001<strong>\6761\5F62\56FE</strong>\3001<strong>\7EBF\5F62\56FE</strong>\3001<strong>\997C\56FE</strong>]\3002</li>'),
unistr('  <li><strong>\8868\6216\89C6\56FE</strong>\FF08\5FC5\9700\FF09- \9009\62E9\56FE\8868\7684\6570\636E\5E93\5BF9\8C61\3002</li>'),
unistr('  <li><strong>\6807\7B7E\5217</strong>\FF08\5FC5\9700\FF09- \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\7528\4F5C\56FE\8868\6807\7B7E\7684\5217\3002</li>'),
unistr('  <li><strong>\503C\805A\96C6</strong> - \9009\62E9\5E94\5982\4F55\663E\793A\6216\805A\96C6\503C\5217<br>'),
unistr('      &nbsp;&nbsp;&nbsp;[\5217\503C\3001\603B\548C\3001\8BA1\6570]\3002</li>'),
unistr('  <li><strong>\503C\5217</strong>\FF08\5FC5\9700\FF09- \4ECE\8BA1\7B97\6240\663E\793A\56FE\8868\503C\65F6\4F7F\7528\7684\8868\6216\89C6\56FE\4E2D\9009\62E9\6570\503C\5217\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285030430941873092)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<h3>\793A\4F8B</h3>'),
unistr('<p>\67E5\770B\6709\5173\5982\4F55\4F7F\7528\4E0D\540C<strong>\6C47\603B</strong>\7C7B\578B\7684\793A\4F8B:</p>'),
unistr('<p><strong>\793A\4F8B 1:</strong> \663E\793A\5458\5DE5\56FE\8868, \5E76\663E\793A\6BCF\4F4D\5458\5DE5\7684\7ECF\7406\5458\5DE5\7F16\53F7\3002'),
'<code><ul>',
unistr('  <li>\8868\6216\89C6\56FE - \9009\62E9\201CEMP\201D\3002</li>'),
unistr('  <li>\6807\7B7E\5217 - \9009\62E9\201CENAME\201D\3002</li>'),
unistr('  <li>\6C47\603B - \9009\62E9<u><strong>\5217\503C</strong></u>\3002</li>'),
unistr('  <li>\503C\5217 - \9009\62E9\201CMGR\201D\3002</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>\793A\4F8B 2:</strong> \663E\793A\5458\5DE5\5217\8868, \5E76\663E\793A\6BCF\79CD\5DE5\4F5C\7684\603B\85AA\6C34\3002'),
'<code><ul>',
unistr('  <li>\8868\6216\89C6\56FE - \9009\62E9\201CEMP\201D\3002</li>'),
unistr('  <li>\6807\7B7E\5217 - \9009\62E9\201CJOB\201D\3002</li>'),
unistr('  <li>\6C47\603B - \9009\62E9<u><strong>\603B\548C</strong></u>\3002</li>'),
unistr('  <li>\503C\5217 - \9009\62E9\201CSAL\201D\3002</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>\793A\4F8B 3:</strong> \663E\793A\5458\5DE5\56FE\8868, \5E76\663E\793A\5404\90E8\95E8\7684\5458\5DE5\6570\3002'),
'<code><ul>',
unistr('  <li>\8868\6216\89C6\56FE - \9009\62E9\201CEMP\201D\3002</li>'),
unistr('  <li>\6807\7B7E\5217 - \9009\62E9\201CDEPTNO\201D\3002</li>'),
unistr('  <li>\6C47\603B - \9009\62E9<u><strong>\8BA1\6570</strong></u>\3002</li>'),
unistr('  <li>\503C\5217 - \9009\62E9\201CEMPNO\201D\3002</li>'),
'</ul></code>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284166525706872466)
,p_name=>'CA.CLIENT.ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BA2\6237\673A ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285084364815873132)
,p_name=>'CA.CLOSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\95ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283794411570872190)
,p_name=>'CA.CLOSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\89E3\51B3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285082319013873130)
,p_name=>'CA.COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285058266584873112)
,p_name=>'CA.COLUMN.1'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285058302763873112)
,p_name=>'CA.COLUMN.2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285045677580873103)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\522B\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285078117824873127)
,p_name=>'CA.COMMENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CE8\91CA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285043374628873101)
,p_name=>'CA.COMPONENT.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\4EF6\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285048141696873105)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\914D\7F6E\8BBF\95EE\63A7\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285038565437873098)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\914D\7F6E\5916\89C2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285038605939873098)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\5E94\7528\7A0B\5E8F\7684\5916\89C2\7531\4E3B\9898\6837\5F0F\5B9A\4E49\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285041922482873100)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\65B0\914D\7F6E\9009\9879\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285023806899873087)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\914D\7F6E\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285022173621873086)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528\6216\7981\7528\5E94\7528\7A0B\5E8F\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285023935186873087)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8BB8\5E94\7528\7A0B\5E8F\7BA1\7406\5458\542F\7528\6216\7981\7528\5E94\7528\7A0B\5E8F\4E2D\7684\7279\5B9A\529F\80FD\3002\5982\679C\60A8\9009\62E9\7684\4E00\4E9B\529F\80FD\9700\8981\989D\5916\7684\5F00\53D1\5DE5\4F5C\624D\80FD\4F9B\6700\7EC8\7528\6237\4F7F\7528\FF0C\5219\6B64\529F\80FD\975E\5E38\6709\7528\3002<br>'),
unistr('\6B64\529F\80FD\8FD8\53EF\4EE5\6269\5C55\5230\5E94\7528\7A0B\5E8F\7279\5B9A\529F\80FD\3002\5982\679C\5F00\53D1\8005\5B9A\4E49\4E86\989D\5916\7684\6784\5EFA\9009\9879\5E76\5728\5E94\7528\7A0B\5E8F\4E2D\5C06\5176\4E0E\7279\5B9A\529F\80FD\5173\8054\FF0C\5219\53EF\4EE5\5C06\5176\6DFB\52A0\5230\7BA1\7406\5458\7684\914D\7F6E\8BBE\7F6E\4E2D\3002\4F8B\5982\FF0C\5728\5BA2\6237\8DDF\8E2A\7A0B\5E8F\5E94\7528\7A0B\5E8F\4E2D\FF0C\7BA1\7406\5458\53EF\4EE5\542F\7528\6216\7981\7528\8054\7CFB\4EBA\3001\6570\636E\52A0\8F7D\3001\5730\7406\4F4D\7F6E\7B49\6B64\7C7B\529F\80FD\3002'),
'</p>',
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6\FF1A'),
'<ul>',
unistr('<li>\5141\8BB8\542F\7528\548C\7981\7528\5E94\7528\7A0B\5E8F\529F\80FD</li>'),
unistr('<li>\4F7F\7528\6B64\529F\80FD\9488\5BF9\6BCF\4E2A\90E8\7F72\6709\9009\62E9\5730\542F\7528\529F\80FD</li>'),
unistr('<li>\652F\6301\5BF9\76F8\5173\7684\5E94\7528\7A0B\5E8F\8BBE\7F6E\5206\7EC4</li>'),
unistr('<li>\5141\8BB8\5E94\7528\7A0B\5E8F\5F00\53D1\8005\4F7F\7528\6784\5EFA\9009\9879\63A7\5236\7EC4\4EF6</li>'),
unistr('<li>\53EF\4ECE\7BA1\7406\9875\4F7F\7528</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284161423356872462)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FDE\63A5\8EAB\4EFD\8BC1\660E\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284161501631872463)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FDE\63A5\8EAB\4EFD\8BC1\660E\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284891482037872989)
,p_name=>'CA.CONTEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E0B\6587')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285048670363873105)
,p_name=>'CA.CONTRIBUTOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D21\732E\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284168495203872468)
,p_name=>'CA.CPU.USED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('CPU \5360\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285057158890873112)
,p_name=>'CA.CREATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285062253698873115)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\7BA1\7406\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285059859440873114)
,p_name=>'CA.CREATE.APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285060983957873114)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5E94\7528\7A0B\5E8F\8BA1\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285060265777873114)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5E94\7528\7A0B\5E8F\56FE\6807')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285060802030873114)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5E94\7528\7A0B\5E8F\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285061053169873114)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5E94\7528\7A0B\5E8F\8FDB\7A0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284902429137872997)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\521B\5EFA\5E94\7528\7A0B\5E8F\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285068285818873120)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284213233292872500)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5E94\7528\7A0B\5E8F\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285060443753873114)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\6388\6743\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285061233924873115)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\7A7A\767D\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285060300818873114)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\6784\5EFA\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285061659731873115)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\65E5\5386\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285074586701873124)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\521B\5EFA\5361\7247\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285061452522873115)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\56FE\8868\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285061952158873115)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\7ECF\5178\62A5\544A\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285061570497873115)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\9762\677F\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285059768091873113)
,p_name=>'CA.CREATE.END'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B8C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285081874310873130)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5206\9762\641C\7D22\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285062569809873115)
,p_name=>'CA.CREATE.FEATURES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285079137817873128)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\521B\5EFA\5DF2\7B5B\9009\5185\5BB9\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285061330813873115)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\8868\5355\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285059956386873114)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5168\5C40\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285062183280873115)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\4E3B\9875\5BFC\822A\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285062043591873115)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\4EA4\4E92\5F0F\7F51\683C\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285061857738873115)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\4EA4\4E92\5F0F\62A5\544A\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285067978539873119)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\521B\5EFA\4E3B\4ECE\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285060644407873114)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5BFC\822A\680F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285063862262873116)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\521B\5EFA\9875\7EC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285062498764873115)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6267\884C\7FFB\8BD1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285062305641873115)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6267\884C %0 \7684\7FFB\8BD1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285061751202873115)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\62A5\544A\548C\8868\5355\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285068160218873120)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\4FDD\5B58\84DD\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285060793316873114)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5FEB\6377\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285061122976873114)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\767B\5F55\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285059666633873113)
,p_name=>'CA.CREATE.START'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\5934')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285060038237873114)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\652F\6301\5BF9\8C61\811A\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285060538685873114)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\6587\672C\6D88\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285074615628873124)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\521B\5EFA\65F6\95F4\8868\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285082049009873130)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\521B\5EFA\5411\5BFC\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285041265180873100)
,p_name=>'CA.CREATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\65F6\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285041350305873100)
,p_name=>'CA.CREATED.BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285029796512873091)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\521B\5EFA\5E94\7528\7A0B\5E8F ...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284162193647872463)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8EAB\4EFD\8BC1\660E\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284168323079872467)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8EAB\4EFD\8BC1\660E\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285041802302873100)
,p_name=>'CA.CURRENT.STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\72B6\6001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285062833160873116)
,p_name=>'CA.CUSTOM.QRY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\5236\67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284260020398872535)
,p_name=>'CA.CUSTOM.THEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\5B9A\5236\4E3B\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284260160432872535)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5207\6362\5411\5BFC\4EE5\4F7F\7528\5B9A\5236\4E3B\9898\800C\4E0D\662F\901A\7528\4E3B\9898\3002</p>'),
'',
unistr('<p>\4E3A\5E94\7528\7A0B\5E8F\9009\62E9\5DE5\4F5C\533A\4E3B\9898\3002\5982\679C\4E3B\9898\652F\6301\4E3B\9898\6837\5F0F\FF0C\5219\8FD8\53EF\4EE5\9009\62E9\6837\5F0F\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283929235948872293)
,p_name=>'CA.CUSTOM_THEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\5236\4E3B\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285063453287873116)
,p_name=>'CA.DASHBOARD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\9762\677F\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284889873884872988)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868 %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285063594927873116)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\5177\6709\591A\4E2A\56FE\8868\7684\9762\677F\9875\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\9875\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
'  </ul>',
'</ul>',
'&nbsp;<br>',
unistr('<p>\5404\56FE\8868\FF08\56FE\8868 1\3001\56FE\8868 2\3001\56FE\8868 3 \548C\56FE\8868 4\FF09\9ED8\8BA4\4E3A\4E0D\540C\7684\56FE\8868\7C7B\578B\4E14\57FA\4E8E<em>\793A\4F8B\6570\636E</em>\3002'),
unistr('  \56E0\6B64\FF0C\65E0\9700\8F93\5165\4EFB\4F55\8BE6\7EC6\4FE1\606F\5373\53EF\6DFB\52A0\6B64\9875\3002'),
unistr('  \4E0D\8FC7\FF0C\53EF\4EE5\5B9A\5236\6BCF\4E2A\56FE\8868\FF0C\5C06\9ED8\8BA4\503C\66FF\6362\4E3A\60A8\81EA\5DF1\7684\9009\62E9\9879\3002<br>'),
unistr('  \8981\5B9A\5236\56FE\8868\FF0C\8BF7\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\56FE\8868\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\56FE\8868\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\56FE\8868\7C7B\578B</strong> - \9009\62E9\8981\663E\793A\7684\56FE\8868\7C7B\578B [<strong>\9762\79EF\56FE</strong>\3001<strong>\6761\5F62\56FE</strong>\3001<strong>\7EBF\5F62\56FE</strong>\3001<strong>\997C\56FE</strong>]\3002</li>'),
unistr('  <li><strong>\8868\6216\89C6\56FE</strong>\FF08\5FC5\9700\FF09- \9009\62E9\56FE\8868\7684\6570\636E\5E93\5BF9\8C61\3002</li>'),
unistr('  <li><strong>\6807\7B7E\5217</strong>\FF08\5FC5\9700\FF09- \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\7528\4F5C\56FE\8868\6807\7B7E\7684\5217\3002</li>'),
unistr('  <li><strong>\503C\805A\96C6</strong> - \9009\62E9\5E94\5982\4F55\663E\793A\6216\805A\96C6\503C\5217<br>'),
unistr('      &nbsp;&nbsp;&nbsp;[\5217\503C\3001\603B\548C\3001\8BA1\6570]\3002</li>'),
unistr('  <li><strong>\503C\5217</strong>\FF08\5FC5\9700\FF09- \4ECE\8BA1\7B97\6240\663E\793A\56FE\8868\503C\65F6\4F7F\7528\7684\8868\6216\89C6\56FE\4E2D\9009\62E9\6570\503C\5217\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285075297432873125)
,p_name=>'CA.DATATYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285076397723873126)
,p_name=>'CA.DATEFORMATMASK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\671F\683C\5F0F\63A9\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285042595857873101)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\65F6\533A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285042631142873101)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\65B0\9ED8\8BA4\65F6\533A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285064262667873117)
,p_name=>'CA.DEFAULTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\5C5E\6027\9ED8\8BA4\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285064517290873117)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5229\7528\6B64 JSON \6587\6863, \53EF\4EE5\5BF9\62A5\544A\548C\8868\5355\5217\540D, \683C\5F0F\63A9\7801\7B49\7684\751F\6210\64CD\4F5C\8FDB\884C\7EC6\7C92\5EA6\63A7\5236\3002\60A8\8FD8\53EF\4EE5\5B9A\4E49\503C\5217\8868\548C\5176\4ED6\5171\4EAB\7EC4\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285081699386873130)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\5217\8868\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285081740435873130)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6DFB\52A0\503C\5217\8868 (LOV) \5C5E\6027\3002LOV \53EF\7528\4E8E\8868\5217\5B9A\4E49\4E2D\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027:'),
'  <ul>',
unistr('    <li><strong>\540D\79F0</strong> (\5FC5\9700) - \8F93\5165\503C\5217\8868\7684\540D\79F0\3002</li>'),
unistr('    <li><strong>\7C7B\578B</strong> - \9009\62E9\503C\5217\8868\7684\7C7B\578B [\7ED3\6784\5316, \52A8\6001, \9759\6001]\3002<br>'),
unistr('      \5BF9\4E8E<u>\7ED3\6784\5316</u>\7C7B\578B - '),
'      <ul>',
unistr('          <li><strong>\8868</strong> (\5FC5\9700) - \9009\62E9\503C\5217\8868\8981\57FA\4E8E\7684\8868\6216\89C6\56FE\3002</li>'),
unistr('          <li><strong>\663E\793A\5217</strong> (\5FC5\9700) - \9009\62E9\5411\6700\7EC8\7528\6237\663E\793A\7684\5217\3002</li>'),
unistr('          <li><strong>\5173\952E\5B57\5217</strong> (\5FC5\9700) - \9009\62E9\8FD4\56DE\7684\5217\503C\3002\8FD9\901A\5E38\662F\8868\7684\4E3B\952E\3002</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      \5BF9\4E8E<u>\52A8\6001</u>\7C7B\578B -'),
'      <ul>',
unistr('          <li><strong>SQL \67E5\8BE2</strong> (\5FC5\9700) - \8F93\5165\8FD4\56DE\4E24\4E2A\503C (\663E\793A\503C\548C\8FD4\56DE\503C) \7684\6709\6548 SQL \9009\62E9\8BED\53E5\3002</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      \5BF9\4E8E<u>\9759\6001</u>\7C7B\578B -'),
'      <ul>',
unistr('          <li><strong>\9759\6001\503C\5217\8868</strong> (\5FC5\9700) - \8F93\5165\6709\6548\7684\9759\6001\5217\8868, \683C\5F0F\4E3A:'),
'          <ul>',
unistr('            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>\5217\8868\6309\8F93\5165\7684\987A\5E8F\663E\793A</li>'),
unistr('            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>\5217\8868\6309\5B57\6BCD\987A\5E8F\6392\5E8F</li>'),
unistr('            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>\663E\793A\503C\548C\8FD4\56DE\503C\76F8\540C</li>'),
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285082878721873131)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285082987308873131)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7F16\8F91\6240\6709\62A5\8868\7684\5C5E\6027\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027:'),
'  <ul>',
unistr('    <li><strong>\6BCF\9875\884C\6570</strong> - \8F93\5165\9ED8\8BA4\60C5\51B5\4E0B\663E\793A\7684\62A5\8868\884C\6570\3002</li>'),
unistr('    <li><strong>\5206\9875\65B9\6CD5</strong> - \9009\62E9\5C06\5982\4F55\663E\793A\62A5\8868\9875\7801\3002</li>'),
unistr('    <li><strong>\6570\503C\683C\5F0F\63A9\7801</strong> - \8F93\5165\5E94\7528\5230\6570\5B57\5217\548C\9879\7684\683C\5F0F\63A9\7801\3002</li>'),
unistr('    <li><strong>\65E5\671F\683C\5F0F\63A9\7801</strong> - \8F93\5165\5E94\7528\5230\65E5\671F\5217\548C\9879\7684\683C\5F0F\63A9\7801\3002</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285082634111873130)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285082484635873130)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5217\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285082537225873130)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7F16\8F91\9009\5B9A\8868\5217\7684\5C5E\6027\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027:'),
'  <ul>',
unistr('    <li><strong>\8868</strong> (\4EC5\663E\793A) - \5173\8054\7684\8868\3002</li>'),
unistr('    <li><strong>\5217</strong> (\4EC5\663E\793A) - \9488\5BF9\5176\5B9A\4E49\5C5E\6027\7684\5217\3002</li>'),
unistr('    <li><strong>\6807\7B7E</strong> - \8F93\5165\5728\62A5\8868\6807\9898\548C\8868\5355\6807\7B7E\4E2D\4F7F\7528\7684\6807\7B7E\3002</li>'),
unistr('    <li><strong>\8868\5355\63A7\4EF6</strong> - \9009\62E9\5728\8868\5355\4E0A\4F7F\7528\7684\9879\7C7B\578B\3002</li>'),
unistr('    <li><strong>\503C\5217\8868</strong> - \9009\62E9\73B0\6709\503C\5217\8868, \4EE5\7528\4E8E\76F8\5E94\5730\663E\793A\7528\6237\53CB\597D\7684\540D\79F0\3002</li>'),
unistr('    <li><strong>\683C\5F0F\63A9\7801</strong> - \6839\636E\5217\7C7B\578B\8F93\5165\76F8\5E94\7684\683C\5F0F\63A9\7801 (\6587\672C, \6570\5B57, \65E5\671F\7B49)\3002</li>'),
unistr('    <li><strong>\9759\6001\9ED8\8BA4\503C</strong> - \8F93\5165\5217\7684\6587\672C\9ED8\8BA4\503C\3002</li>'),
unistr('    <li><strong>\5305\62EC\5728\8868\5355\4E0A</strong> - \5982\679C\5217\5E94\5305\62EC\5728\8868\5355\4E0A, \5219\5355\51FB\201C\662F\201D\3002</li>'),
unistr('    <li><strong>\5305\62EC\5728\62A5\8868\4E0A</strong> - \5982\679C\5217\5E94\5305\62EC\5728\62A5\8868\4E0A, \5219\5355\51FB\201C\662F\201D\3002</li>'),
unistr('    <li><strong>\5FC5\9700</strong> - \5982\679C\8868\5355\4E0A\7684\6B64\5217\4E2D\5FC5\987B\8F93\5165\6570\636E, \5219\5355\51FB\201C\662F\201D\3002</li>'),
unistr('    <li><strong>\5E2E\52A9</strong> - \8F93\5165\6DFB\52A0\5230\9879\5E2E\52A9\5C5E\6027\4E2D\7684\5E2E\52A9\6587\672C\3002</li>'),
'  </ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285082752283873131)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7F16\8F91\9009\5B9A\8868\5217\7684\5C5E\6027\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027:'),
'  <ul>',
unistr('    <li><strong>\8868</strong> (\4EC5\663E\793A) - \5173\8054\7684\8868\3002</li>'),
unistr('    <li><strong>\6807\7B7E, \5355\6570</strong> (\5FC5\9700) - \8F93\5165\5728\8868\5355\9875\4E0A\4F7F\7528\7684\6807\7B7E\3002</li>'),
unistr('    <li><strong>\6807\7B7E, \590D\6570</strong> (\5FC5\9700) - \8F93\5165\5728\533A\57DF\6807\9898\548C\9875\540D\4E2D\4F7F\7528\7684\6807\7B7E\3002</li>'),
unistr('    <li><strong>\4E3B\663E\793A\5217</strong> - \9009\62E9\8981\663E\793A\7684\7B2C\4E00\5217, \4F8B\5982\5728\5361\7247\533A\57DF\4E2D\3002</li>'),
unistr('    <li><strong>\6B21\663E\793A\5217</strong> - \9009\62E9\8981\663E\793A\7684\7B2C\4E8C\5217, \4F8B\5982\5728\5361\7247\533A\57DF\4E2D\3002</li>'),
unistr('    <li><strong>\4E3B\952E\5217</strong> - \4E3A\8868\9009\62E9\552F\4E00\4E3B\952E\5217\3002</li>'),
unistr('    <li><strong>\8BF4\660E</strong> - \4E3A\8868\8F93\5165\8BF4\660E\3002</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284161941345872463)
,p_name=>'CA.DEFERRED.DROP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5EF6\8FDF\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285076936561873126)
,p_name=>'CA.DEFINITION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\4E49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285059596231873113)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5378\8F7D\5B8C\6210\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285039845272873099)
,p_name=>'CA.DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285059139587873113)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\5426\8981\6267\884C\6B64\5220\9664\64CD\4F5C?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285025488107873088)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\5426\786E\5B9E\8981\5220\9664\6B64\9875?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285049679267873106)
,p_name=>'CA.DELETE.PHOTO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\7167\7247')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285040528962873099)
,p_name=>'CA.DESCRIPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF4\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285057754072873112)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\684C\9762\5BFC\822A\680F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285057643879873112)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\684C\9762\5BFC\822A\83DC\5355')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285038815797873098)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\684C\9762\4E3B\9898\6837\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285038989280873098)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\4E3B\9898\6837\5F0F\5E94\7528\5230\6240\6709\7528\6237\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284162339889872463)
,p_name=>'CA.DESTINATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\76EE\6807')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284162443026872463)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\76EE\6807\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283929303330872293)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\8BDD\6846\6309\94AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285054130678873109)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\6D3E\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285073711889873124)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\786E\5B9A\662F\5426\5E94\4ECE\7535\5B50\90AE\4EF6\6846\67B6\53D1\51FA\7535\5B50\90AE\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285040301401873099)
,p_name=>'CA.DISPLAY.FROM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\81EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285040212419873099)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\5E8F\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285040491693873099)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\81F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285075498769873125)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285043981922873102)
,p_name=>'CA.DISTINCT .USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\540C\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285057299774873112)
,p_name=>'CA.DOWNLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\8F7D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285064158288873117)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62D6\52A8\4EE5\5BF9\9875\91CD\65B0\6392\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283950663102872309)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr('  <li><strong>\7EC6\5316\94FE\63A5</strong> - \5C55\5F00\53EF\67E5\770B\7528\4E8E\5B9A\4E49\7EC6\5316\94FE\63A5\7684\5C5E\6027\3002'),
'&nbsp;<br>',
unistr('    <em><strong>\6CE8\FF1A</strong>\53EA\6709\5728\5F53\524D\9875\57FA\4E8E\8868\6216\89C6\56FE\4E14\62A5\8868\7C7B\578B\4E3A\201C\4EA4\4E92\5F0F\62A5\8868\201D\FF0C\5E76\4E14\5DF2\7ECF\5B9A\4E49\4E86\62A5\8868\FF08\4EA4\4E92\5F0F\62A5\8868\FF09\6216\4E3B\4ECE\9875\65F6\FF0C\624D\4F1A\663E\793A\201C\7EC6\5316\94FE\63A5\201D\3002</em>'),
'  <ul>',
unistr('    <li><strong>\94FE\63A5\5217</strong> - \9009\62E9\5C06\5728\62A5\8868\4E2D\66F4\6539\4E3A\94FE\63A5\5217\7684\5217\3002</li>'),
unistr('    <li><strong>\94FE\63A5\5173\952E\5B57</strong> - \9009\62E9\7528\4E8E\6307\5B9A\94FE\63A5\5230\7684\9875\4E2D\7279\5B9A\8BB0\5F55\7684\94FE\63A5\5173\952E\5B57\FF08\5916\952E\FF09\5217\3002</li>'),
unistr('    <li><strong>\94FE\63A5\5230\9875</strong> - \9009\62E9\94FE\63A5\5C06\5BFC\822A\5230\7684\62A5\8868\9875\6216\8868\5355\9875\3002</li>'),
unistr('    <li><strong>\76EE\6807\5173\952E\5B57</strong> - \4ECE\62A5\8868\9875\FF08\94FE\63A5\5C06\5BFC\822A\5230\8BE5\9875\FF09\6240\57FA\4E8E\7684\8868\4E2D\9009\62E9\76EE\6807\5173\952E\5B57\FF08\4E3B\952E\FF09\5217\3002'),
'  </ul>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285043097925873101)
,p_name=>'CA.ELAPSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285025649030873088)
,p_name=>'CA.EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\6846\67B6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285073387973873123)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\5730\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285083328804873131)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285025525038873088)
,p_name=>'CA.EMAIL.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\529F\80FD\7528\4E8E\914D\7F6E\548C\53D1\9001\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285025729229873088)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5305\62EC\4ECE\5E94\7528\7A0B\5E8F\53D1\9001\7535\5B50\90AE\4EF6\7684\529F\80FD\3002\4F7F\7528\793A\4F8B\7535\5B50\90AE\4EF6\6A21\677F\5411\7528\6237\53D1\9001\4E13\4E1A\5916\89C2\7684\7535\5B50\90AE\4EF6\3002\53D1\51FA\7684\7535\5B50\90AE\4EF6\6709\8BB0\5F55, \8FD9\6837\7BA1\7406\5458\53EF\4EE5\8DDF\8E2A\7535\5B50\90AE\4EF6\6D3B\52A8\3002</p>'),
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6:'),
'<ul>',
unistr('<li>\53EF\6269\5C55\7684 HTML \7535\5B50\90AE\4EF6\6A21\677F\7CFB\7EDF</li>'),
unistr('<li>\7528\4E8E\901A\8FC7 APEX \7A0B\5E8F\5305\53D1\9001\90AE\4EF6\7684 PL/SQL \7A0B\5E8F\5305</li>'),
unistr('<li>\7535\5B50\90AE\4EF6\6D3B\52A8\548C\72B6\6001\7684\65E5\5FD7\8BB0\5F55</li>'),
unistr('<li>\7528\4E8E\7BA1\7406\6A21\677F\7684\7BA1\7406 UI</li>'),
unistr('<li>\7528\4E8E\67E5\770B\7535\5B50\90AE\4EF6\65E5\5FD7\7684\7BA1\7406 UI</li>'),
unistr('<li>\7528\4E8E\53D1\9001\7535\5B50\90AE\4EF6\7684\7BA1\7406 UI</li>'),
'</ul>',
'</p>',
unistr('<p><em>\6CE8: \5728\9009\4E2D\4E86\201C\53CD\9988\201D\65F6\542F\7528\6B64\529F\80FD</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285079080826873128)
,p_name=>'CA.EMAIL.FROM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\53D1\4EF6\4EBA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285053155443873109)
,p_name=>'CA.EMAIL.LOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\65E5\5FD7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285083941543873131)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\63D0\4F9B\7535\5B50\90AE\4EF6\8BBE\7F6E\8BE6\7EC6\4FE1\606F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285083427055873131)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\4EF6\4EBA\5730\5740\4E0D\662F\6709\6548\7684\7535\5B50\90AE\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285074989802873125)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\4EF6\4EBA\5730\5740\4E0D\662F\6709\6548\7684\7535\5B50\90AE\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285074183506873124)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5904\7406\7535\5B50\90AE\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284029302932872366)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\62A5\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284215166717872502)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6709\5173\6392\961F\7B49\5F85\53D1\9001\7684\6240\6709\7535\5B50\90AE\4EF6\548C\6240\6709\5DF2\53D1\9001\7535\5B50\90AE\4EF6\7684\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285054068865873109)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285054465684873110)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\65B0\7535\5B50\90AE\4EF6\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285079410824873128)
,p_name=>'CA.EMAIL.STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\72B6\6001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285054502414873110)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6\6A21\677F\8BE6\7EC6\8D44\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284566212923872754)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#SERVICE_NAME# \7684\5DF2\8C03\5EA6\505C\673A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284267634822872540)
,p_name=>'CA.EMAIL2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285053045659873109)
,p_name=>'CA.EMAILS.SENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\7684\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285083537768873131)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528\9644\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284167438191872467)
,p_name=>'CA.ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\542F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284164616722872465)
,p_name=>'CA.END.DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED3\675F\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285055161526873110)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\4E4B\540E\5185\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285071291531873122)
,p_name=>'CA.ENTER.USERNAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\6B64\5904\8F93\5165\7528\6237\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285043611903873102)
,p_name=>'CA.ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285045928643873103)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9519\8BEF\5411\540E\8DDF\8E2A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285045877935873103)
,p_name=>'CA.ERROR.CODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9519\8BEF\4EE3\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285045154182873103)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9519\8BEF\6D88\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284169182751872468)
,p_name=>'CA.ERROR.NUMBER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9519\8BEF\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284168128552872467)
,p_name=>'CA.ERRORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284165002058872465)
,p_name=>'CA.EVENT.CONDITION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284165131000872465)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6\961F\5217\4EE3\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284165282016872465)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6\961F\5217\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284165394584872465)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6\961F\5217\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284164934948872465)
,p_name=>'CA.EVENT.RULE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6\89C4\5219')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285071554819873122)
,p_name=>'CA.EXCEPTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F02\5E38\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285084419576873132)
,p_name=>'CA.EXPERIENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F53\9A8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284167112962872467)
,p_name=>'CA.FAILURE.COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5931\8D25\8BA1\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285041629215873100)
,p_name=>'CA.FEATURE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284821669752872938)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\7248\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284821702168872938)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284313605059872574)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\7528\6237\6DFB\52A0\5230\8BBF\95EE\63A7\5236\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284313429342872573)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F6C\81F3\4E0B\4E00\6B65')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284313542123872574)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\96C6\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284313390009872573)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\66F4\6539\6700\540E\4E00\4E2A\7BA1\7406\5458')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284821363808872938)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E00\4E2A\6D3B\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284313186084872573)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\627E\4E0D\5230\4EFB\4F55\6D3B\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284821525118872938)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\539F\56E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284313775668872574)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81F3\5C11\9700\8981\4E00\4E2A\53CD\9988')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284314004965872574)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\83B7\53D6\6587\4EF6 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284312648712872573)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58\4E3B\9898\6837\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284312715486872573)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FDD\5B58\6700\7EC8\7528\6237\6837\5F0F\9996\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284821455762872938)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285029870912873091)
,p_name=>'CA.FEATURES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285029981875873091)
,p_name=>'CA.FEATURES.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD9\4E9B\529F\80FD\63D0\4F9B\4E86\5E94\7528\7A0B\5E8F\7EA7\522B\7684\529F\80FD\FF0C\901A\5E38\5BF9\6BCF\4E2A\5E94\7528\7A0B\5E8F\6DFB\52A0\4E00\6B21\3002\9009\62E9\8981\5305\62EC\5728\5E94\7528\7A0B\5E8F\4E2D\7684\529F\80FD\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285023726871873087)
,p_name=>'CA.FEEDBACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53CD\9988')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285021745386873085)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\7528\6237\63D0\4F9B\53CD\9988')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285023625420873087)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4E3A\6700\7EC8\7528\6237\63D0\4F9B\5C06\5E38\89C4\6CE8\91CA\53D1\9001\56DE\5E94\7528\7A0B\5E8F\7BA1\7406\5458\548C\5F00\53D1\4EBA\5458\7684\673A\5236\3002\5E16\5B50\4E2D\5305\62EC\6709\7528\7684\4F1A\8BDD\72B6\6001\4FE1\606F, \7528\4E8E\5E2E\52A9\786E\5B9A\6700\7EC8\7528\6237\53D1\9001\53CD\9988\7684\4F4D\7F6E\3002\63D0\4F9B\8FD9\79CD\7B80\5355\7684\53CD\9988\5FAA\73AF\53EF\6539\8FDB\7528\6237\793E\533A\4E0E\5E94\7528\7A0B\5E8F\6240\6709\8005\4E4B\95F4\7684\4EA4\6D41, \8FD9\4F1A\5E26\6765\7528\6237\6EE1\610F\5EA6\7684\663E\8457\6539\5584\3002</p>'),
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6:'),
'<ul>',
unistr('<li>\6700\7EC8\7528\6237\53EF\4EE5\901A\8FC7\5355\51FB\5BFC\822A\680F\56FE\6807\7559\4E0B\53CD\9988\610F\89C1</li>'),
unistr('<li>\7528\4E8E\67E5\770B\548C\66F4\65B0\53CD\9988\7684\7BA1\7406\62A5\544A</li>'),
unistr('<li>\53CD\9988\5C06\6536\96C6\7528\6237, \65E5\671F\548C\65F6\95F4\4EE5\53CA\7528\6237\4EE3\7406\4FE1\606F</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285084887531873132)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\63D0\4F9B\53CD\9988\6216\60A8\7684\4F53\9A8C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285083896123873131)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\5230')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285083205678873131)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53CD\9988\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285051177720873107)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\65B0\53CD\9988\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285084027828873132)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\63D0\4EA4\53CD\9988')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284164790323872465)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\4EF6\76D1\89C6\5668\540D\79F0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284164812634872465)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\4EF6\76D1\89C6\5668\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283819958908872209)
,p_name=>'CA.FILED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5F52\6863')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283820016047872209)
,p_name=>'CA.FILED.BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F52\6863\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285079506392873128)
,p_name=>'CA.FILTER.REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B5B\9009\62A5\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285055580229873110)
,p_name=>'CA.FILTERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285082272064873130)
,p_name=>'CA.FINISH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B8C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285049862241873106)
,p_name=>'CA.FIRST.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284161732389872463)
,p_name=>'CA.FLAGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\8BB0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285031252186873092)
,p_name=>'CA.FORM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\8868\5355\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285031175842873092)
,p_name=>'CA.FORM.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\663E\793A\8868\5355\9875\4EE5\5141\8BB8\6700\7EC8\7528\6237\7EF4\62A4\6570\636E\7684\9875\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\9875\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
unistr('  <li><strong>\8868</strong>\FF08\5FC5\9700\FF09- \4E3A\8868\5355\9009\62E9\8868\3002</li>'),
unistr('<li><strong>\5305\62EC\62A5\8868</strong>\FF08\5FC5\9700\FF09- \9009\62E9\6B64\9009\9879\53EF\521B\5EFA\62A5\8868\548C\8868\5355\3002\7B2C\4E00\9875\662F\4EA4\4E92\5F0F\62A5\8868\3002\6BCF\884C\63D0\4F9B\6307\5411\4E00\4E2A\8868\5355\7684\94FE\63A5\FF0C\7528\6237\53EF\5728\5176\4E2D\66F4\65B0\8BB0\5F55\3002</li>'),
'  &nbsp;<br>',
unistr('<li><strong>\9AD8\7EA7</strong> - \5C55\5F00\53EF\67E5\770B\9AD8\7EA7\9009\9879\3002'),
'     <ul>',
unistr('      <li><strong>\9875\5E2E\52A9</strong> - \8F93\5165\8981\6DFB\52A0\5230\9875\7684\201C\5E2E\52A9\6587\672C\201D\4E2D\7684\6587\672C\3002</li>'),
'      </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283949617863872308)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\9879\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285057489553873112)
,p_name=>'CA.FORM.ON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\57FA\4E8E %0 \7684\8868\5355')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285071059401873122)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\7C7B\578B\4E0D\662F\6709\6548\7684\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285077445172873127)
,p_name=>'CA.FORMATMASK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\683C\5F0F\63A9\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285076430492873126)
,p_name=>'CA.FORMCONTROL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\63A7\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285041020182873100)
,p_name=>'CA.FROM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285054239873873109)
,p_name=>'CA.FROM.ADDRESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\4EF6\4EBA\5730\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285078946093873128)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('"\53D1\4EF6\4EBA\5730\5740" \7535\5B50\90AE\4EF6\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285074862673873125)
,p_name=>'CA.FROM.EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\4EF6\4EBA\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285074729926873125)
,p_name=>'CA.FROM.WHO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\4EF6\4EBA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284823531623872939)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \641C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285044560004873102)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B8C\6574\9875\8BBF\95EE\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285053257142873109)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B8C\6574\6A21\677F HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285075996757873125)
,p_name=>'CA.FUNCTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FD\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285024174563873087)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\5C40\641C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285021943797873085)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\4F9B\5E94\7528\7A0B\5E8F\641C\7D22\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285024047206873087)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8BB8\6700\7EC8\7528\6237\5728\5E94\7528\7A0B\5E8F\4E2D\7684\4E3B\8981\8868\6216\89C6\56FE\4E2D\641C\7D22\6587\672C\3002\9AD8\7EA7\641C\7D22\9875\5305\542B\7B5B\9009\5668, \4F7F\5F97\6700\7EC8\7528\6237\53EF\4EE5\8F7B\677E\5730\7F29\5C0F\7ED3\679C\8303\56F4\3002<br>'),
unistr('\8FD9\6B3E\975E\5E38\5F3A\5927\7684\529F\80FD\65E0\9700\4EFB\4F55\5F00\53D1\5DE5\4F5C\6765\5B9A\4E49 SQL (\57FA\4E8E\63D0\4F9B\7684\793A\4F8B)\3002</p>'),
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6:'),
'<ul>',
unistr('<li>\5728\6807\9898\680F\4E2D\663E\793A\641C\7D22\56FE\6807</li>'),
unistr('<li>\5305\62EC\5177\6709\4FA7\8FB9\680F\7B5B\9009\5668\7684\8BE6\7EC6\641C\7D22\7ED3\679C\9875</li>'),
unistr('<li>\9700\8981\5F00\53D1\4EBA\5458\5B9E\65BD SQL \6765\5B9A\4E49\5E94\7528\7A0B\5E8F\641C\7D22</li>'),
unistr('<li>\5305\62EC\7528\4E8E\8BF4\660E\7684\793A\4F8B\6570\636E</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284166464371872466)
,p_name=>'CA.GLOBAL.UID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\5C40\552F\4E00 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284312206243872573)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\5C40\9875 - \684C\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283929491589872293)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F6C\5230\7BA1\7406\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285030799192873092)
,p_name=>'CA.GRID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\4EA4\4E92\5F0F\7F51\683C\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285030820376873092)
,p_name=>'CA.GRID.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\663E\793A\4EA4\4E92\5F0F\7F51\683C\7684\9875\FF0C\8FD9\79CD\7F51\683C\7C7B\4F3C\4E8E\7535\5B50\8868\683C\3002\5728\53EF\4EE5\8FDB\884C\7F16\8F91\65F6\FF0C\7528\6237\53EF\76F4\63A5\5728\9875\4E0A\7F16\8F91\591A\884C\FF08\5373\FF0C\5728\542F\7528\4E86\201C\5141\8BB8\7F16\8F91\201D\65F6\FF09\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\9875\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
unistr('  <li><strong>\67E5\8BE2\7C7B\578B</strong> - \9009\62E9\62A5\8868\7684\6E90 [<strong>\8868\6216\89C6\56FE</strong>\6216 <strong>SQL \67E5\8BE2</strong>]\3002<br>'),
unistr('    <strong>\8868\6216\89C6\56FE</strong>\FF1A'),
'    <ul>',
unistr('      <li><strong>\8868\6216\89C6\56FE</strong>\FF08\5FC5\9700\FF09- \9009\62E9\7F51\683C\7684\6570\636E\5E93\5BF9\8C61\3002</li>'),
'    </ul>',
unistr('    <strong>SQL \67E5\8BE2</strong>\FF1A'),
'    <ul>',
unistr('      <li><strong>SQL \67E5\8BE2</strong>\FF08\5FC5\9700\FF09- \8F93\5165\8FD4\56DE\552F\4E00\5217\7684\6709\6548 SQL \8BED\53E5\3002</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>\7F51\683C\7C7B\578B</strong> - \9009\62E9\7528\6237\662F\5426\53EF\5728\7F51\683C\4E2D\7F16\8F91\884C [<strong>\5141\8BB8\7F16\8F91</strong>\6216<strong>\53EA\8BFB</strong>]\3002\8981\542F\7528\7F16\8F91\529F\80FD\FF0C\8BF7\9009\62E9<strong>\5141\8BB8\7F16\8F91</strong>\3002</li>'),
'  &nbsp;<br>',
unistr('  <em><strong>\8B66\544A\FF1A</strong>\5982\679C\9009\62E9 <strong>SQL \67E5\8BE2</strong>\67E5\8BE2\7C7B\578B\4EE5\53CA<strong>\5141\8BB8\7F16\8F91</strong>\7F51\683C\7C7B\578B\FF0C\5E76\4E14\67E5\8BE2\8054\63A5\4E86\4E24\4E2A\6216\591A\4E2A\8868\FF0C\5219\5728\7528\6237\5C1D\8BD5\548C\66F4\65B0\8BB0\5F55\65F6\FF0C\751F\6210\7684\4EA4\4E92\5F0F\7F51\683C\5C06\5931\8D25\3002'),
unistr('\6B64\5916\FF0C\5982\679C\9009\62E9<strong>\5141\8BB8\7F16\8F91</strong>\7F51\683C\7C7B\578B\5E76\4E14\67E5\8BE2\FF08\6216\9009\62E9\4E86\201C\8868\6216\89C6\56FE\201D\FF09\4F7F\7528\65E0\6CD5\66F4\65B0\7684\89C6\56FE\FF0C\5219\5728\7528\6237\5C1D\8BD5\548C\66F4\65B0\8BB0\5F55\65F6\FF0C\751F\6210\7684\4EA4\4E92\5F0F\7F51\683C\5C06\5931\8D25\3002</em><br>'),
'  </li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285056096232873111)
,p_name=>'CA.HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E2E\52A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285048482035873105)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\6240\6709\7528\6237\5728\8BBF\95EE\63A7\5236\5217\8868\4E2D\5B9A\4E49, \5219\9009\62E9<strong>\5426</strong>\3002\5982\679C\6B64\5E94\7528\7A0B\5E8F\4E2D\8FD8\4F1A\4F7F\7528\4E0D\5728\8BBF\95EE\63A7\5236\5217\8868\4E2D\7684\5DF2\9A8C\8BC1\7528\6237, \5219\9009\62E9 <strong>\662F</strong>\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285042137451873101)
,p_name=>'CA.HELP.APP.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\5904\8F93\5165\7684\6587\672C\5728\5E94\7528\7A0B\5E8F\4E2D\4F7F\7528, \6700\663E\773C\7684\662F\5728\6BCF\9875\7684\5DE6\4E0A\89D2\3002\7BA1\7406\5458\8FDB\884C\66F4\6539\4E4B\540E, \66F4\6539\5C06\7ACB\5373\751F\6548, \4F46\5176\4ED6\7528\6237\53EA\6709\5728\83B7\53D6\65B0\4F1A\8BDD (\4F8B\5982, \4E0B\6B21\767B\5F55) \65F6\624D\4F1A\770B\5230\66F4\6539\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285036796031873097)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\5355\51FB\5E94\7528\7A0B\5E8F\4E2D\4EFB\610F\9875\4E0A\5BFC\822A\680F\4E2D\7684\201C\53CD\9988\201D\56FE\6807 (<span class="fa fa-comment-o" aria-hidden="true"></span>), \53EF\4EE5\5411\5E94\7528\7A0B\5E8F\7BA1\7406\5458\63D0\4F9B\53CD\9988\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285036479830873096)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\8FD9\662F\5E94\7528\7A0B\5E8F\7684\4E3B\9875\3002\5355\51FB\5361\7247\53EF\8BBF\95EE\5E94\7528\7A0B\5E8F\4E2D\7684\4E0D\540C\9875, \6216\8005\4F7F\7528\9875\4FA7\9762\7684\5BFC\822A\83DC\5355\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285036645184873097)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\8FD9\662F\5E94\7528\7A0B\5E8F\7684\4E3B\9875\3002\5355\51FB\5361\7247\53EF\8BBF\95EE\5E94\7528\7A0B\5E8F\4E2D\7684\4E0D\540C\9875, \6216\8005\4F7F\7528\9875\9876\90E8\7684\5BFC\822A\83DC\5355\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285036885050873097)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\5728\6B64\9875\4E0A\7684<strong>\641C\7D22\5E94\7528\7A0B\5E8F</strong>\5B57\6BB5\4E2D\8F93\5165\641C\7D22\8BCD, \6216\8005\5728\4EFB\610F\9875\7684\5BFC\822A\680F\4E2D\5355\51FB\201C\641C\7D22\201D\56FE\6807 (<span class="fa fa-search" aria-hidden="true"></span>), \641C\7D22\5E94\7528\7A0B\5E8F\4E2D\7684\8BCD\8BED\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285037153586873097)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\5355\51FB\5BFC\822A\680F\4E2D\7684\540D\79F0\4E0B\62C9\5217\8868\53EF\6CE8\9500\5E94\7528\7A0B\5E8F\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285037058606873097)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\5355\51FB\5BFC\822A\680F\4E2D\7684\7528\6237\83DC\5355 (<span class="fa fa-user" aria-hidden="true"></span>) \53EF\66F4\65B0\65F6\533A\9996\9009\9879, \4EE5\53CA\6CE8\9500\5E94\7528\7A0B\5E8F\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285036552472873096)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285037279460873097)
,p_name=>'CA.HELP.HOME.USER'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5355\51FB\5BFC\822A\680F (\9875\53F3\4E0A\89D2) \4E2D\7684\7528\6237\83DC\5355 (<span class="fa fa-user" aria-hidden="true"></span>) \53EF\8BBF\95EE\60A8\7684\7528\6237\6982\8981\4FE1\606F, \4EE5\53CA\6CE8\9500\5E94\7528\7A0B\5E8F\3002<br>'),
unistr('\5355\51FB<strong>\67E5\770B\6211\7684\6982\8981\4FE1\606F</strong>\65F6, \53EF\4EE5\968F\540E\5355\51FB<strong>\66F4\65B0\6982\8981\4FE1\606F</strong>\6765\8F93\5165\4E2A\4EBA\8BE6\7EC6\4FE1\606F\548C\4E0A\8F7D\76F8\7247\6216\5934\50CF\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285036992063873097)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5355\51FB\5BFC\822A\680F\4E2D\7684\7528\6237\83DC\5355 (<span class="fa fa-user" aria-hidden="true"></span>) \53EF\8BBF\95EE\60A8\7684\7528\6237\6982\8981\4FE1\606F, \66F4\65B0\65F6\533A\9996\9009\9879, \4EE5\53CA\6CE8\9500\5E94\7528\7A0B\5E8F\3002<br>'),
unistr('\5355\51FB<strong>\67E5\770B\6211\7684\6982\8981\4FE1\606F</strong>\65F6, \53EF\4EE5\968F\540E\5355\51FB<strong>\66F4\65B0\6982\8981\4FE1\606F</strong>\6765\8F93\5165\4E2A\4EBA\8BE6\7EC6\4FE1\606F\548C\4E0A\8F7D\7167\7247\6216\5934\50CF\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285063034209873116)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8981\67E5\627E\6570\636E, \8BF7\5728\641C\7D22\5BF9\8BDD\6846\4E2D\8F93\5165\641C\7D22\8BCD, \6216\8005\5355\51FB\5217\6807\9898\4EE5\9650\5236\8FD4\56DE\7684\8BB0\5F55\3002</p>'),
'',
unistr('<p>\5355\51FB<strong>\64CD\4F5C</strong>\6309\94AE\53EF\4EE5\6267\884C\591A\79CD\529F\80FD\3002\8FD9\5305\62EC\9009\62E9\663E\793A/\9690\85CF\7684\5217\53CA\5176\663E\793A\987A\5E8F, \4EE5\53CA\591A\79CD\6570\636E\548C\683C\5F0F\529F\80FD\3002\8FD8\53EF\4F7F\7528\56FE\8868\9009\9879\5B9A\4E49\6570\636E\7684\5176\4ED6\89C6\56FE\3002</p>'),
'',
unistr('<p>\5982\679C\8981\4FDD\5B58\5B9A\5236\8BBE\7F6E, \8BF7\9009\62E9\62A5\544A, \6216\8005\5355\51FB\4E0B\8F7D\4EE5\5378\8F7D\6570\636E\3002<p>'),
'<br>',
unistr('<p>\6709\5173\8BE6\7EC6\4FE1\606F, \8BF7\5355\51FB\4F4D\4E8E\201C\64CD\4F5C\201D\83DC\5355\5E95\90E8\7684\201C\5E2E\52A9\201D\3002</p>'),
'',
unistr('<p>\5355\51FB<strong>\91CD\7F6E</strong>\6309\94AE\53EF\5C06\4EA4\4E92\5F0F\62A5\544A\91CD\7F6E\56DE\9ED8\8BA4\8BBE\7F6E\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285062938623873116)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5728\6B64\4EA4\4E92\5F0F\7F51\683C\4E2D\53EF\4EE5\76F4\63A5\63D2\5165, \66F4\65B0\548C\5220\9664\6570\636E\3002<br>'),
unistr('  \5355\51FB\201C\6DFB\52A0\884C\201D\6309\94AE\53EF\63D2\5165\65B0\884C\3002<br>'),
unistr('  \53CC\51FB\5355\5143, \6216\8005\5355\51FB<strong>\7F16\8F91</strong>\6309\94AE\53EF\66F4\65B0\6570\636E\503C, \4E0E\5728\7535\5B50\8868\683C\4E2D\7F16\8F91\6570\636E\7C7B\4F3C\3002</p>'),
'',
unistr('<p>\4F7F\7528\4F4D\4E8E\62A5\544A\9876\90E8\7684\201C\884C\64CD\4F5C\201D\83DC\5355 (<span class="fa fa-bars" aria-hidden="true"></span>) \53EF\590D\5236, \5220\9664, \5237\65B0\6216\8FD8\539F\9009\5B9A\7684\884C\3002<br> '),
unistr('  \4F7F\7528\4F4D\4E8E\5404\884C\4E0A\7684\201C\884C\64CD\4F5C\201D\83DC\5355\8FD8\53EF\4EE5\8BBF\95EE\5355\884C\89C6\56FE\6216\8005\6DFB\52A0\65B0\884C\3002</p>'),
'',
unistr('<p>\8981\67E5\627E\6570\636E, \8BF7\5728\641C\7D22\5BF9\8BDD\6846\4E2D\8F93\5165\641C\7D22\8BCD, \6216\8005\5355\51FB\5217\6807\9898\4EE5\9650\5236\8FD4\56DE\7684\8BB0\5F55\3002</p>'),
'',
unistr('<p>\5355\51FB<strong>\64CD\4F5C</strong>\6309\94AE\53EF\4EE5\6267\884C\591A\79CD\529F\80FD\3002\8FD9\5305\62EC\9009\62E9\663E\793A/\9690\85CF\7684\5217\53CA\5176\663E\793A\987A\5E8F, \4EE5\53CA\591A\79CD\6570\636E\548C\683C\5F0F\529F\80FD\3002\8FD8\53EF\4F7F\7528\56FE\8868\9009\9879\5B9A\4E49\6570\636E\7684\5176\4ED6\89C6\56FE\3002</p>'),
'',
unistr('<p>\5982\679C\8981\4FDD\5B58\5B9A\5236\8BBE\7F6E, \8BF7\9009\62E9\62A5\544A, \6216\8005\5355\51FB\4E0B\8F7D\4EE5\5378\8F7D\6570\636E\3002<p>'),
'',
unistr('<p>\6709\5173\5176\4ED6\4FE1\606F, \8BF7\5355\51FB\4F4D\4E8E\201C\64CD\4F5C\201D\83DC\5355\5E95\90E8\7684\201C\5E2E\52A9\201D\3002</p> '),
'',
unistr('<p>\5355\51FB<strong>\91CD\7F6E</strong>\6309\94AE\53EF\5C06\4EA4\4E92\5F0F\62A5\544A\91CD\7F6E\56DE\9ED8\8BA4\8BBE\7F6E\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285036386786873096)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8981\67E5\627E\6570\636E, \8BF7\5728\641C\7D22\5BF9\8BDD\6846\4E2D\8F93\5165\641C\7D22\8BCD, \6216\8005\5355\51FB\5217\6807\9898\4EE5\9650\5236\8FD4\56DE\7684\8BB0\5F55\3002</p>'),
'',
unistr('<p>\5355\51FB<strong>\64CD\4F5C</strong>\6309\94AE\53EF\4EE5\6267\884C\591A\79CD\529F\80FD\3002\8FD9\5305\62EC\9009\62E9\663E\793A/\9690\85CF\7684\5217\53CA\5176\663E\793A\987A\5E8F, \4EE5\53CA\591A\79CD\6570\636E\548C\683C\5F0F\529F\80FD\3002\8FD8\53EF\4F7F\7528\56FE\8868, \5206\7EC4\65B9\5F0F\548C\6570\636E\900F\89C6\8868\9009\9879\5B9A\4E49\6570\636E\7684\5176\4ED6\89C6\56FE\3002</p>'),
'',
unistr('<p>\5982\679C\8981\4FDD\5B58\5B9A\5236\8BBE\7F6E, \8BF7\9009\62E9\62A5\544A, \6216\8005\5355\51FB\4E0B\8F7D\4EE5\5378\8F7D\6570\636E\3002\5728\8981\5B9A\671F\53D1\9001\7684\8BA2\9605\4E0B\8F93\5165\7535\5B50\90AE\4EF6\5730\5740\548C\65F6\95F4\8303\56F4\3002<p>'),
'',
unistr('<p>\6709\5173\8BE6\7EC6\4FE1\606F, \8BF7\5355\51FB\4F4D\4E8E\201C\64CD\4F5C\201D\83DC\5355\5E95\90E8\7684\201C\5E2E\52A9\201D\3002</p>'),
'',
unistr('<p>\5355\51FB<strong>\91CD\7F6E</strong>\6309\94AE\53EF\5C06\4EA4\4E92\5F0F\62A5\544A\91CD\7F6E\56DE\9ED8\8BA4\8BBE\7F6E\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285072062465873122)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\62A5\8868\9875\663E\793A\9875\8FB9\680F\9009\62E9\5668\4E2D\7684\4E3B\8BB0\5F55\3002'),
unistr('  \9009\62E9\4E00\6761\8BB0\5F55\53EF\67E5\770B\5B9A\4E49\7684\4E3B\8BB0\5F55\548C\4EFB\4F55\8BE6\7EC6\4FE1\606F\8BB0\5F55\3002<br> '),
unistr('  \5355\51FB\7F16\8F91\56FE\6807 (<span class="fa fa-pencil-square-o" aria-hidden="true"></span>) \53EF\7F16\8F91\4E3B\8BB0\5F55\3002'),
unistr('  \5BF9\4E8E\8BE6\7EC6\4FE1\606F\8BB0\5F55, \5355\51FB\6BCF\884C\5F00\5934\7684\94C5\7B14\53EF\7F16\8F91\76F8\5E94\8BB0\5F55\3002</p>'),
unistr('<p>\8981\9650\5236\5728\9009\62E9\5668\4E2D\663E\793A\7684\6570\636E, \8BF7\5728\641C\7D22\5BF9\8BDD\6846\4E2D\8F93\5165\641C\7D22\8BCD\3002</p>'),
'',
unistr('<p>\8981\6DFB\52A0\65B0\7684\4E3B\8BB0\5F55, \8BF7\5355\51FB\6B64\9875\9876\90E8\7684<strong>\521B\5EFA</strong>\3002'),
unistr('  \5BF9\4E8E\8BE6\7EC6\4FE1\606F\8BB0\5F55, \5355\51FB\8BE6\7EC6\4FE1\606F\533A\57DF\9876\90E8\7684\52A0\53F7\56FE\6807 (+) \53EF\6DFB\52A0\8BE6\7EC6\4FE1\606F\8BB0\5F55\3002</p>'),
'',
unistr('<p>\5355\51FB\6B64\9875\9876\90E8\7684<strong>\91CD\7F6E</strong>\53EF\5C06\6B64\9875\91CD\7F6E\56DE\9ED8\8BA4\8BBE\7F6E, \5E76\5220\9664\4EE5\524D\5B9A\4E49\7684\4EFB\4F55\641C\7D22\8BCD\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285034328839873095)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5E94\7528\7A0B\5E8F\6240\6709\8005 (\7BA1\7406\5458) \53EF\4EE5\4F7F\7528\7BA1\7406\9875\6765\914D\7F6E\5E94\7528\7A0B\5E8F\548C\7EF4\62A4\5728\5E94\7528\7A0B\5E8F\4E2D\4F7F\7528\7684\901A\7528\6570\636E\3002'),
unistr('\901A\8FC7\9009\62E9\4E00\4E2A\53EF\7528\8BBE\7F6E, \7BA1\7406\5458\53EF\4EE5\6F5C\5728\5730\66F4\6539\5982\4F55\663E\793A\5E94\7528\7A0B\5E8F\548C/\6216\53EF\4F9B\6700\7EC8\7528\6237\4F7F\7528\7684\529F\80FD\3002</p>'),
unistr('<p>\6B64\9875\5E94\4EC5\9650\7BA1\7406\5458\8BBF\95EE\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285035524292873096)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4E3A\4EFB\4F55\5DF2\9A8C\8BC1\7528\6237\9009\62E9\76F8\5E94\7684\9009\9879\3002<br>'),
unistr('\9009\62E9<strong>\5426</strong>\53EF\63D0\9AD8\5E94\7528\7A0B\5E8F\7684\5B89\5168\6027, \56E0\4E3A\53EA\6709\6307\5B9A\7528\6237\53EF\4EE5\8BBF\95EE\5E94\7528\7A0B\5E8F\3002'),
unistr('\4F46\662F, \5982\679C\5E94\7528\7A0B\5E8F\6709\5927\91CF\7528\6237\7FA4, \5219\7EF4\62A4\7528\6237\4F1A\975E\5E38\7E41\91CD, \60A8\53EF\80FD\4F1A\504F\597D\9009\62E9<strong>\662F</strong>\5E76\4EC5\8F93\5165\5E94\7528\7A0B\5E8F\7BA1\7406\5458, \4E5F\8BB8\5305\62EC\5185\5BB9\63D0\4F9B\8005\3002<br>'),
unistr('\5982\679C\60A8\9009\62E9<strong>\662F</strong>, \5219\8FD8\5FC5\987B\9009\62E9\5982\4F55\5904\7406\672A\5305\62EC\5728\7528\6237\5217\8868\4E2D\7684\7528\6237\3002</p>'),
unistr('<p>\9009\62E9\5FC5\9700\7684\7535\5B50\90AE\4EF6\5730\5740, \6216\8005\4F7F\7528\4EFB\610F\5B57\6BCD\6570\5B57\503C\7684\7528\6237\540D\3002<br>'),
unistr('\901A\5E38, \5982\679C\5E94\7528\7A0B\5E8F\4F7F\7528 (\6216\5C06\914D\7F6E\4E3A\4F7F\7528) \96C6\4E2D\9A8C\8BC1\65B9\6848, \4F8B\5982 Oracle Access Manager \6216 SSO, \5219\5E94\8BE5\5C06\6B64\8BBE\7F6E\8BBE\7F6E\4E3A<strong>\7535\5B50\90AE\4EF6\5730\5740</strong>\3002</p>'),
unistr('<p><em><strong>\6CE8:</strong> \6B64\5E94\7528\7A0B\5E8F\652F\6301\4EE5\4E0B 3 \79CD\8BBF\95EE\7EA7\522B: \8BFB\8005, \5185\5BB9\63D0\4F9B\8005\548C\7BA1\7406\5458\3002'),
'<ul>',
unistr('  <li><strong>\8BFB\8005</strong>\5177\6709\6240\6709\4FE1\606F\7684\53EA\8BFB\8BBF\95EE\6743\9650, \8FD8\53EF\4EE5\67E5\770B\62A5\544A\3002</li>'),
unistr('  <li><strong>\5185\5BB9\63D0\4F9B\8005</strong>\53EF\4EE5\521B\5EFA, \7F16\8F91\548C\5220\9664\4FE1\606F\53CA\67E5\770B\62A5\544A\3002</li>'),
unistr('  <li><strong>\7BA1\7406\5458</strong>\9664\4E86\5185\5BB9\63D0\4F9B\8005\7684\529F\80FD\4E4B\5916, \8FD8\53EF\4EE5\901A\8FC7\8BBF\95EE\5E94\7528\7A0B\5E8F\7684\201C\7BA1\7406\201D\90E8\5206\6267\884C\5E94\7528\7A0B\5E8F\7684\914D\7F6E\3002</li>'),
'</ul>',
'</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285035713129873096)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\8868\5355\53EF\8F93\5165\7528\6237, \5176\7535\5B50\90AE\4EF6\5730\5740\5E76\8BBE\7F6E\5176\8BBF\95EE\7EA7\522B\3002'),
unistr('\5728<em>\914D\7F6E\8BBF\95EE\63A7\5236</em>\4E0B\5B9A\4E49\7684\8BBE\7F6E\5C06\786E\5B9A\7528\6237\540D\662F\5FC5\987B\4E3A\7535\5B50\90AE\4EF6\5730\5740, \8FD8\662F\53EF\4EE5\4E3A\4EFB\610F\5B57\6BCD\6570\5B57\6761\76EE\3002</p>'),
unistr('<p>\6B64\5E94\7528\7A0B\5E8F\652F\6301\4EE5\4E0B 3 \79CD\8BBF\95EE\7EA7\522B: \8BFB\8005, \5185\5BB9\63D0\4F9B\8005\548C\7BA1\7406\5458\3002</p>'),
'<ul>',
unistr('  <li><strong>\8BFB\8005</strong>\5177\6709\6240\6709\4FE1\606F\7684\53EA\8BFB\8BBF\95EE\6743\9650, \8FD8\53EF\4EE5\67E5\770B\62A5\544A\3002</li>'),
unistr('  <li><strong>\5185\5BB9\63D0\4F9B\8005</strong>\53EF\4EE5\521B\5EFA, \7F16\8F91\548C\5220\9664\4FE1\606F\4EE5\53CA\67E5\770B\62A5\544A\3002</li>'),
unistr('  <li><strong>\7BA1\7406\5458</strong>\9664\4E86\5185\5BB9\63D0\4F9B\8005\7684\529F\80FD\4E4B\5916, \8FD8\53EF\4EE5\901A\8FC7\8BBF\95EE\5E94\7528\7A0B\5E8F\7684\201C\7BA1\7406\201D\90E8\5206\6267\884C\5E94\7528\7A0B\5E8F\7684\914D\7F6E\3002</li>'),
'</ul>',
unistr('<p>\7F16\8F91\73B0\6709\7528\6237\65F6, \60A8\53EF\4EE5\9501\5B9A\5176\5E10\6237, \8FD9\5C06\963B\6B62\8BE5\7528\6237\8BBF\95EE\5E94\7528\7A0B\5E8F\3002</p>'),
unistr('<p><em><strong>\6CE8:</strong>   \5982\679C\4F7F\7528 Oracle Application Express \5E10\6237, \5219\5DE5\4F5C\533A\7BA1\7406\5458\8FD8\5FC5\987B\5C06\6B64\5904\8F93\5165\7684\7528\6237\5B9A\4E49\4E3A\6700\7EC8\7528\6237, \7BA1\7406\5458\4E5F\53EF\4EE5\8BBE\7F6E\5176\5BC6\7801\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285035659489873096)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\9875\663E\793A\5E94\7528\7A0B\5E8F\7528\6237\548C\6240\6388\4E88\8BBF\95EE\7EA7\522B\7684\62A5\544A\3002</p>'),
unistr('<p>\5355\51FB\5217\6807\9898\53EF\6392\5E8F\548C\7B5B\9009\6570\636E, \5355\51FB<strong>\64CD\4F5C</strong>\6309\94AE\53EF\5B9A\5236\5217\663E\793A\4EE5\53CA\591A\79CD\5176\4ED6\7684\9AD8\7EA7\529F\80FD\3002<br>'),
unistr('\5355\51FB<strong>\91CD\7F6E</strong>\6309\94AE\53EF\5C06\4EA4\4E92\5F0F\62A5\544A\91CD\7F6E\56DE\9ED8\8BA4\8BBE\7F6E\3002</p>'),
unistr('<p>\5355\51FB\201C\7F16\8F91\201D\56FE\6807 (\9EC4\8272\94C5\7B14) \53EF\7F16\8F91\7528\6237\8BE6\7EC6\4FE1\606F\548C\8BBF\95EE\7EA7\522B, \6216\8005\5220\9664\7528\6237\3002</p>'),
unistr('<p>\5355\51FB\4F4D\4E8E\62A5\544A\9876\90E8\7684<strong>\6DFB\52A0\7528\6237</strong>\53EF\6DFB\52A0\65B0\7528\6237\53CA\5176\8BBF\95EE\7EA7\522B\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285049117644873106)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\542F\7528\8BBF\95EE\63A7\5236\65F6\FF0C\7BA1\7406\5458\53EF\4EE5\9650\5236\5DF2\9A8C\8BC1\7528\6237\5BF9\7279\5B9A\5E94\7528\7A0B\5E8F\529F\80FD\7684\8BBF\95EE\6743\9650\3002\6B64\5E94\7528\7A0B\5E8F\652F\6301\4EE5\4E0B 3 \79CD\89D2\8272\FF1A\8BFB\8005\3001\5185\5BB9\63D0\4F9B\8005\548C\7BA1\7406\5458\3002</p>'),
'<ul>',
unistr('  <li><strong>\8BFB\8005</strong>\5177\6709\6240\6709\4FE1\606F\7684\53EA\8BFB\8BBF\95EE\6743\9650\FF0C\8FD8\53EF\4EE5\67E5\770B\62A5\8868\3002</li>'),
unistr('  <li><strong>\5185\5BB9\63D0\4F9B\8005</strong>\53EF\4EE5\521B\5EFA\FF0C\7F16\8F91\548C\5220\9664\4FE1\606F\4EE5\53CA\67E5\770B\62A5\8868\3002</li>'),
unistr('  <li><strong>\7BA1\7406\5458</strong>\FF0C\9664\4E86\5185\5BB9\63D0\4F9B\8005\7684\529F\80FD\4E4B\5916\FF0C\8FD8\53EF\4EE5\6267\884C\5E94\7528\7A0B\5E8F\7684\914D\7F6E\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285071133000873122)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\5165\4EE5\9017\53F7, \5206\53F7\6216\7A7A\683C\5206\9694\7684\7528\6237\540D\3002\5C06\81EA\52A8\5FFD\7565\73B0\6709\7528\6237\540D\6216\91CD\590D\7528\6237\540D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285034558865873095)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\914D\7F6E\8BBE\7F6E\53EF\4EE5\8BA9\7279\5B9A\529F\80FD\5BF9\6700\7EC8\7528\6237\53EF\7528 (\542F\7528) \6216\4E0D\53EF\7528 (\7981\7528) \3002</p>'),
unistr('<p>\5982\679C\7279\5B9A\529F\80FD\672A\5B8C\5168\51C6\5907\597D, \6216\8005\9700\8981\4E34\65F6\5220\9664, \8BF7\5355\51FB<strong>\7981\7528</strong>\3002'),
unistr('\5982\679C\5E94\4F7F\5176\53EF\7528, \5219\53EA\9700\5355\51FB<strong>\542F\7528</strong>\3002</p>'),
unistr('<p><em><strong>\6CE8:</strong> \6B64\5904\6240\505A\7684\66F4\6539\4E0D\4F1A\4F53\73B0\5728\5F53\524D\6B63\5728\8FD0\884C\5E94\7528\7A0B\5E8F\7684\5355\4E2A\6700\7EC8\7528\6237\8EAB\4E0A\3002\5728\6700\7EC8\7528\6237\6CE8\9500\5E76\767B\5F55\56DE\4E4B\540E, \5C06\8C03\7528\4FEE\8BA2\540E\7684\529F\80FD\8BBE\7F6E\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285034631876873095)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9009\62E9\7528\4E8E\663E\793A\5E94\7528\7A0B\5E8F\7684\9ED8\8BA4\989C\8272\65B9\6848\3002</p>'),
unistr('<p>\5982\679C\9009\4E2D\4E86<strong>\5141\8BB8\6700\7EC8\7528\6237\9009\62E9\4E3B\9898\6837\5F0F</strong>, \5219\6BCF\4E2A\6700\7EC8\7528\6237\5355\51FB\4E3B\9875\5DE6\4E0B\89D2\7684<em>\5B9A\5236</em>\94FE\63A5, \4ECE\53EF\7528\4E3B\9898\6837\5F0F\4E2D\9009\62E9\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285035240850873095)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\9875\63D0\4F9B\8BE5\5E94\7528\7A0B\5E8F\8BB0\5F55\7684\6240\6709\610F\5916\9519\8BEF\7684\4EA4\4E92\5F0F\62A5\544A\3002</p>'),
unistr('<p>\5355\51FB\5217\6807\9898\53EF\6392\5E8F\548C\7B5B\9009\6570\636E, \5355\51FB<strong>\64CD\4F5C</strong>\6309\94AE\53EF\5B9A\5236\5217\663E\793A\4EE5\53CA\591A\79CD\5176\4ED6\7684\9AD8\7EA7\529F\80FD\3002\5355\51FB<strong>\91CD\7F6E</strong>\6309\94AE\53EF\5C06\4EA4\4E92\5F0F\62A5\544A\91CD\7F6E\56DE\9ED8\8BA4\8BBE\7F6E\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285035149560873095)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\62A5\544A\548C\56FE\8868\53EF\67E5\770B\6307\5B9A\65F6\95F4\8303\56F4\5185\5177\6709\6700\591A\9875\8BBF\95EE\91CF\7684\7528\6237\3002</p>'),
unistr('<p>\9009\62E9\62A5\544A\65F6\95F4\8303\56F4 (\9ED8\8BA4\503C = 1 \5929) \5E76\5728\9875\9876\90E8\7684\62A5\544A\548C\56FE\8868\56FE\6807\4E4B\95F4\9009\62E9\3002</p>'),
unistr('<p>\5BF9\4E8E\4EA4\4E92\5F0F\62A5\544A, \4F7F\7528\641C\7D22\5B57\6BB5, \6216\8005\9009\62E9<strong>\7528\6237</strong>\5217\6807\9898\6765\9009\62E9\7279\5B9A\7528\6237\3002\5355\51FB<strong>\64CD\4F5C</strong>\6309\94AE\53EF\6267\884C\591A\79CD\529F\80FD, \4F8B\5982\663E\793A/\9690\85CF\5217, \6BCF\9875\884C\6570, \7B5B\9009\5668\7B49\3002\5355\51FB<strong>\91CD\7F6E</strong>\6309\94AE\53EF\5C06\4EA4\4E92\5F0F\62A5\544A\91CD\7F6E\56DE\9ED8\8BA4\8BBE\7F6E\3002</p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285035368454873096)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\9875\63D0\4F9B\9875\6027\80FD\548C\53D7\6B22\8FCE\7A0B\5EA6\7684\4EA4\4E92\5F0F\62A5\544A\3002\62A5\544A\6309\7167<strong>\52A0\6743\6027\80FD</strong>\6392\5E8F, \8BE5\503C\901A\8FC7\5C06\7528\65F6\4E2D\503C\4E0E\9875\8BBF\95EE\91CF\76F8\4E58\5F97\5230\3002</p>'),
unistr('<p>\5982\679C\9700\8981, \53EF\5728\9875\9876\90E8\9009\62E9\62A5\544A\65F6\95F4\8303\56F4 (\9ED8\8BA4\503C = 1 \5929)\3002<br>'),
unistr('\5355\51FB\5217\6807\9898\53EF\6392\5E8F\548C\7B5B\9009\6570\636E, \5355\51FB<strong>\64CD\4F5C</strong>\6309\94AE\53EF\5B9A\5236\5217\663E\793A\4EE5\53CA\591A\79CD\5176\4ED6\7684\9AD8\7EA7\529F\80FD\3002\5355\51FB<strong>\91CD\7F6E</strong>\6309\94AE\53EF\5C06\4EA4\4E92\5F0F\62A5\544A\91CD\7F6E\56DE\9ED8\8BA4\8BBE\7F6E\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285035441661873096)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\9875\63D0\4F9B\6700\8FD1\9875\8BBF\95EE\91CF\7684\4EA4\4E92\5F0F\62A5\544A\3002</p>'),
unistr('<p>\5982\679C\9700\8981, \53EF\5728\9875\9876\90E8\9009\62E9\62A5\544A\65F6\95F4\8303\56F4 (\9ED8\8BA4\503C = 1 \5929)\3002<br>'),
unistr('\5355\51FB\5217\6807\9898\53EF\6392\5E8F\548C\7B5B\9009\6570\636E, \5355\51FB<strong>\64CD\4F5C</strong>\6309\94AE\53EF\5B9A\5236\5217\663E\793A\4EE5\53CA\591A\79CD\5176\4ED6\7684\9AD8\7EA7\529F\80FD\3002\5355\51FB<strong>\91CD\7F6E</strong>\6309\94AE\53EF\5C06\4EA4\4E92\5F0F\62A5\544A\91CD\7F6E\56DE\9ED8\8BA4\8BBE\7F6E\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285034454565873095)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5728\6D3B\52A8\65F6, \901A\77E5\663E\793A\5728\4E3B\9875\4E0A\3002</p>'),
unistr('<p>\6B64\62A5\544A\663E\793A\5B9A\4E49\7684\901A\77E5\4EE5\53CA\663E\793A\901A\77E5\7684\65F6\6BB5\3002</p>'),
unistr('<p>\5355\51FB\201C\7F16\8F91\201D\56FE\6807 (\9EC4\8272\94C5\7B14) \53EF\7F16\8F91\73B0\6709\901A\77E5, \5355\51FB<strong>\6DFB\52A0\901A\77E5</strong>\53EF\63D2\5165\65B0\901A\77E5\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285034792054873095)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4E3A\5E94\7528\7A0B\5E8F\8F93\5165\5E94\7528\7A0B\5E8F\540D\79F0\548C\7B80\8981\8BF4\660E\3002</p>'),
unistr('<p>\5E94\7528\7A0B\5E8F\540D\79F0\663E\793A\5728\4E3B\9875\4E0A\3002\7B80\8981\8BF4\660E\663E\793A\5728\5E94\7528\7A0B\5E8F\540D\79F0\4E0B\65B9\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285034977189873095)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6700\7EC8\7528\6237\53EF\4EE5\5728\5E94\7528\7A0B\5E8F\4E2D\7684\4EFB\610F\666E\901A\9875\4E0A\8F93\5165\53CD\9988\3002</p>'),
unistr('<p>\6B64\62A5\544A\663E\793A\8F93\5165\7684\53CD\9988, \7BA1\7406\5458\8F93\5165\7684\4EFB\4F55\56DE\590D, \4EE5\53CA\53CD\9988\7684\72B6\6001\3002</p>'),
unistr('<p>\5355\51FB\7F16\8F91\56FE\6807 (\9EC4\8272\94C5\7B14) \53EF\8F93\5165\54CD\5E94\6216\66F4\65B0\53CD\9988\72B6\6001\3002</p>'),
unistr('<p><em><strong>\6CE8:</strong> \5982\679C\5DF2\7ECF\5B9A\4E49\4E86\53CD\9988\6536\4EF6\4EBA, \5219\53CD\9988\63D0\4EA4\8FD8\5C06\901A\8FC7\7535\5B50\90AE\4EF6\53D1\9001\5230\53CD\9988\6536\4EF6\4EBA\5217\8868\4E2D\7684\7535\5B50\90AE\4EF6\5730\5740\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285051050030873107)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\4F9B\4EE5\9017\53F7\5206\9694\7684\7535\5B50\90AE\4EF6\5730\5740\5217\8868\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285035025122873095)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p><strong>\542F\7528\9644\4EF6</strong> - \5982\679C\4E3A\201C\662F\201D\FF0C\5219\7528\6237\53EF\4EE5\4E0A\8F7D\9644\4EF6\4EE5\4FBF\4E3A\5176\53CD\9988\63D0\4F9B\4F9D\636E\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285036030747873096)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\9875\5217\51FA\6240\5B9A\4E49\7684\7535\5B50\90AE\4EF6\6A21\677F\4EE5\53CA\8FD9\4E9B\6A21\677F\5728\6240\53D1\9001\7535\5B50\90AE\4EF6\4E2D\7684\5F15\7528\6B21\6570\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285035806978873096)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\9875\5217\51FA\53D1\9001\7684\7535\5B50\90AE\4EF6\3002</p>'),
unistr('<p>\5355\51FB\201C\653E\5927\955C\201D\56FE\6807\53EF\67E5\770B\6240\53D1\9001\7535\5B50\90AE\4EF6\7684\8BE6\7EC6\4FE1\606F\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285035903529873096)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8F93\5165\4EE5\4E0B\5B57\6BB5\4EE5\5B9A\4E49\7535\5B50\90AE\4EF6\6A21\677F:</p>'),
'<ul>',
unistr('  <li><strong>\6A21\677F\540D\79F0</strong> (\5FC5\9700) - \4E3A\6A21\677F\8F93\5165\6709\610F\4E49\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>HTML \6A21\677F</strong> (\5FC5\9700) - \8F93\5165 HTML \4EE3\7801, \8FD9\4E9B\4EE3\7801\7528\4E8E\6784\5EFA\53D1\9001\7ED9\6536\4EF6\4EBA\7684\7535\5B50\90AE\4EF6\4EE5\4F20\9001\57FA\4E8E HTML \7684\7535\5B50\90AE\4EF6\3002'),
unistr('    \66FF\4EE3\503C\5305\62EC:'),
'    <ul>',
unistr('        <li><strong>#APP_NAME#</strong> - \5C06\66FF\6362\4E3A\5E94\7528\7A0B\5E8F\7684\540D\79F0</li>'),
unistr('        <li><strong>#BODY1#</strong> - \5C06\66FF\6362\4E3A\4F7F\7528 p_body1_text \4F20\5165\7684\503C</li> '),
unistr('        <li><strong>#TABLE#</strong> - \5C06\66FF\6362\4E3A\4F7F\7528 as p_table_content \4F20\5165\7684\503C (\4F7F\7528\8868\6253\5F00 HTML, \8868\884C HTML \548C\8868\5173\95ED HTML)</li> '),
unistr('        <li><strong>#BODY2#</strong> - \5C06\66FF\6362\4E3A\4F7F\7528 p_body2_text \4F20\5165\7684\503C</li> '),
unistr('        <li><strong>#ACTION#</strong> - \5C06\66FF\6362\4E3A\4F7F\7528 p_action_label \548C p_action_link \4F20\5165\7684\503C (\4F7F\7528\64CD\4F5C\94FE\63A5\6A21\677F)</li>'),
'     </ul></li>',
unistr('  <li><strong>\7EAF\6587\672C\6A21\677F</strong> (\5FC5\9700) - \8F93\5165\7528\4E8E\6784\5EFA\7535\5B50\90AE\4EF6\7684\7EAF\6587\672C, \8BE5\7535\5B50\90AE\4EF6\53D1\9001\7ED9\4E0D\63A5\53D7\57FA\4E8E HTML \7684\7535\5B50\90AE\4EF6\7684\6536\4EF6\4EBA\3002\8FD9\4F7F\7528\4E0E HTML \6A21\677F\76F8\540C\7684\66FF\4EE3\9879, \53EA\662F #TABLE# \548C #ACTION# \5C06\5448\73B0\4E3A\7EAF\6587\672C\3002</li>'),
'<ul>',
unistr('<p>\4F7F\7528\5176\4ED6 HTML \6A21\677F\53EF\5B9E\73B0\66F4\9AD8\7EA7\7684\7535\5B50\90AE\4EF6\3002\8FD9\4E9B\9879\5305\62EC:</p>'),
'<ul>',
unistr('  <li><strong>\884C\4E4B\524D</strong> - \8F93\5165\7528\4E8E\66FF\6362 HTML \6A21\677F\4E2D\7684 #TABLE# \7684 HTML\3002\4EC5\5728\4F20\9012\4E86 p_table_content \65F6\4F7F\7528\3002</li>'),
unistr('  <li><strong>\884C\6A21\677F</strong> - \8F93\5165\7528\4E8E\5448\73B0\5404\4E2A\8868\884C\7684 HTML\3002\8FD9\5305\62EC\884C\6253\5F00/\5173\95ED\548C\6570\636E\6253\5F00/\5173\95ED (\4F7F\7528 #LABEL# \548C #VALUE# \66FF\4EE3\9879)\3002\4EC5\5728\4F20\9012\4E86 p_table_content \65F6\4F7F\7528\3002</li>'),
unistr('  <li><strong>\884C\4E4B\540E</strong> - \8F93\5165\7528\4E8E\5173\95ED\8868\6216 div \7684 HTML\3002\4EC5\5728\4F20\9012\4E86 p_table_content \65F6\4F7F\7528\3002</li>'),
unistr('  <li><strong>\64CD\4F5C\94FE\63A5 HTML</strong> - \8F93\5165\7528\4E8E\66FF\6362 HTML \6A21\677F\4E2D\7684 #ACTION# \7684 HTML\3002\5B83\5E94\5305\542B #ACTION_LINK# \548C #ACTION_TEXT#\3002\4EC5\5728\4F20\9012\4E86 p_action_label \548C p_action_link \65F6\4F7F\7528\3002</li>'),
'</ul>',
unistr('<p><em><strong>\6CE8:</strong> \53EF\4F7F\7528<strong>\9ED8\8BA4\6A21\677F</strong>\4E2D\7684\6761\76EE\4F5C\4E3A\5F00\53D1\60A8\81EA\5DF1\6A21\677F\7684\793A\4F8B\3002\9ED8\8BA4\6A21\677F\4F7F\7528\60A8\53EF\80FD\5E0C\671B, \4E5F\53EF\80FD\4E0D\5E0C\671B\5305\62EC\5230\81EA\5DF1\7535\5B50\90AE\4EF6\6A21\677F\4E2D\7684\6240\6709\66FF\4EE3\53D8\91CF\3002</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285036141257873096)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\901A\8FC7\9009\62E9<strong>\5206\53D1\7535\5B50\90AE\4EF6</strong>\9009\9879\4E4B\4E00\6765\5141\8BB8\6216\7981\6B62\53D1\9001\7535\5B50\90AE\4EF6\3002</p>'),
unistr('<p>\5728<strong>\7535\5B50\90AE\4EF6\53D1\9001\81EA</strong>\4E2D, \8F93\5165\5E94\7528\7A0B\5E8F\95EE\9898\4E3B\8981\8054\7CFB\4EBA\7684\7535\5B50\90AE\4EF6\5730\5740\3002\5F53\4F7F\7528\7535\5B50\90AE\4EF6\529F\80FD\65F6, \53EF\4EE5\4F7F\7528\6216\8986\76D6\6B64\503C\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285054330040873110)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD9\662F\5C06\7528\4E8E\53D1\9001\7535\5B50\90AE\4EF6\7684\53D1\4EF6\4EBA\5730\5740\3002\5F53\4F7F\7528\7535\5B50\90AE\4EF6\529F\80FD\65F6, \53EF\4EE5\8986\76D6\5B83\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285072798617873123)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\586B\5145\4EE5\4E0B\9879\5E76\5355\51FB [\53D1\9001\7535\5B50\90AE\4EF6]\3002\53D1\9001\7684\6240\6709\7535\5B50\90AE\4EF6\90FD\4F1A\8BB0\5F55\5728\7535\5B50\90AE\4EF6\65E5\5FD7\4E2D\3002'),
'    <ul>',
unistr('        <li><strong>\53D1\4EF6\4EBA</strong> - \5982\679C\5728\201C\7535\5B50\90AE\4EF6\8BBE\7F6E\201D\5185\8BBE\7F6E\4E86 "\53D1\4EF6\4EBA\5730\5740", \5219\8BE5\7535\5B50\90AE\4EF6\5730\5740\5C06\662F\7528\4E8E\53D1\4EF6\4EBA\7684\9009\9879\3002\5982\679C\6B64\5E94\7528\7A0B\5E8F\4F7F\7528\7535\5B50\90AE\4EF6\5730\5740\4F5C\4E3A\7528\6237\540D, \5219\60A8\53EF\4EE5\9009\62E9\4ECE\60A8\7684\7535\5B50\90AE\4EF6\53D1\9001\7535\5B50\90AE\4EF6\3002\6700\540E,\201C\53D1\9001\81EA\201D\59CB\7EC8\53EF\4EE5\4E0E\201C\53D1\9001\5230\201D\76F8\540C\3002</li>'),
unistr('        <li><strong>\53D1\9001\5230</strong> - \5982\679C\6B64\5E94\7528\7A0B\5E8F\4F7F\7528\7535\5B50\90AE\4EF6\5730\5740\4F5C\4E3A\7528\6237\540D, \5219\53EF\4EE5\9009\62E9\5C06\7535\5B50\90AE\4EF6\53D1\9001\5230\7535\5B50\90AE\4EF6\5730\5740\548C/\6216\7528\6237\3002</li>'),
unistr('        <li><strong>\7535\5B50\90AE\4EF6\5730\5740</strong> - \7528\4E8E\63A5\6536\7535\5B50\90AE\4EF6\7684\7535\5B50\90AE\4EF6\5730\5740\7684\9017\53F7\5206\9694\5217\8868\3002\5C06\4E0D\4F1A\5305\62EC\90A3\4E9B\786E\5B9A\65E0\6548\7684\7535\5B50\90AE\4EF6\5730\5740\3002</li>'),
unistr('        <li><strong>\89D2\8272</strong> - \5C06\7535\5B50\90AE\4EF6\53D1\9001\5230\9009\5B9A\89D2\8272\7684\6240\6709\7528\6237\6216\53D1\9001\5230\5B9A\4E49\7684\6240\6709\7528\6237\3002\9009\62E9\5217\8868\5305\62EC\89D2\8272\5217\8868\4EE5\53CA\76F8\5E94\89D2\8272\5185\7528\6237\7684\8BA1\6570\3002</li>'),
unistr('        <li><strong>\6A21\677F</strong> - \9009\62E9\7528\4E8E\521B\5EFA\7535\5B50\90AE\4EF6\6B63\6587\7684\7535\5B50\90AE\4EF6\6A21\677F\3002</li>'),
unistr('        <li><strong>\4E3B\9898</strong> - \7535\5B50\90AE\4EF6\7684\4E3B\9898\3002</li>'),
unistr('        <li><strong>\7535\5B50\90AE\4EF6\6B63\6587</strong> - \8981\4F5C\4E3A\7535\5B50\90AE\4EF6\6B63\6587\5305\62EC\7684\6587\672C\3002</li>'),
unistr('        <li><strong>\5141\8BB8\9009\62E9\9000\51FA</strong> - \5373\4F7F\7528\6237\9009\62E9\4E0D\63A5\6536\7535\5B50\90AE\4EF6, \4ECD\4F1A\53D1\9001\67D0\4E9B\7535\5B50\90AE\4EF6\3002\8FD9\4E9B\7535\5B50\90AE\4EF6\5305\62EC\505C\673A\6D88\606F\7B49\3002\6B64\6807\8BB0\786E\5B9A\662F\5E94\5141\8BB8\9009\62E9\4E0D\53D1\9001\6B64\7535\5B50\90AE\4EF6, \8FD8\662F\5E94\53D1\9001\6B64\7535\5B50\90AE\4EF6\800C\4E0D\8003\8651\7528\6237\7684\9996\9009\9879\3002</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285074497352873124)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\586B\5145\4EE5\4E0B\9879\5E76\5355\51FB [\53D1\9001\7535\5B50\90AE\4EF6]\3002\53D1\9001\7684\6240\6709\7535\5B50\90AE\4EF6\90FD\4F1A\8BB0\5F55\5728\7535\5B50\90AE\4EF6\65E5\5FD7\4E2D\3002'),
'    <ul>',
unistr('        <li><strong>\53D1\4EF6\4EBA</strong> - \5982\679C\5728\201C\7535\5B50\90AE\4EF6\8BBE\7F6E\201D\5185\8BBE\7F6E\4E86 "\53D1\4EF6\4EBA\5730\5740", \5219\8BE5\7535\5B50\90AE\4EF6\5730\5740\5C06\662F\7528\4E8E\53D1\4EF6\4EBA\7684\9009\9879\3002\5426\5219,\201C\53D1\9001\81EA\201D\59CB\7EC8\53EF\4EE5\4E0E\201C\53D1\9001\5230\201D\76F8\540C\3002</li>'),
unistr('        <li><strong>\7535\5B50\90AE\4EF6\5730\5740</strong> - \7528\4E8E\63A5\6536\7535\5B50\90AE\4EF6\7684\7535\5B50\90AE\4EF6\5730\5740\7684\9017\53F7\5206\9694\5217\8868\3002\5C06\4E0D\4F1A\5305\62EC\90A3\4E9B\786E\5B9A\65E0\6548\7684\7535\5B50\90AE\4EF6\5730\5740\3002</li>'),
unistr('        <li><strong>\6A21\677F</strong> - \9009\62E9\7528\4E8E\521B\5EFA\7535\5B50\90AE\4EF6\6B63\6587\7684\7535\5B50\90AE\4EF6\6A21\677F\3002</li>'),
unistr('        <li><strong>\4E3B\9898</strong> - \7535\5B50\90AE\4EF6\7684\4E3B\9898\3002</li>'),
unistr('        <li><strong>\7535\5B50\90AE\4EF6\6B63\6587</strong> - \8981\4F5C\4E3A\7535\5B50\90AE\4EF6\6B63\6587\5305\62EC\7684\6587\672C\3002</li>'),
unistr('        <li><strong>\5141\8BB8\9009\62E9\9000\51FA</strong> - \5373\4F7F\7528\6237\9009\62E9\4E0D\63A5\6536\7535\5B50\90AE\4EF6, \4ECD\4F1A\53D1\9001\67D0\4E9B\7535\5B50\90AE\4EF6\3002\8FD9\4E9B\7535\5B50\90AE\4EF6\5305\62EC\505C\673A\6D88\606F\7B49\3002\6B64\6807\8BB0\786E\5B9A\662F\5E94\5141\8BB8\9009\62E9\4E0D\53D1\9001\6B64\7535\5B50\90AE\4EF6, \8FD8\662F\5E94\53D1\9001\6B64\7535\5B50\90AE\4EF6\800C\4E0D\8003\8651\7528\6237\7684\9996\9009\9879\3002</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285034809896873095)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9009\62E9\6B64\5E94\7528\7A0B\5E8F\6240\6709\7528\6237\7684\9ED8\8BA4\65F6\533A\3002</p>'),
unistr('<p>\5355\4E2A\7528\6237\53EF\4EE5\901A\8FC7\5355\51FB\5176\7528\6237\540D (\53F3\4E0A\89D2) \5E76\9009\62E9<strong>\9996\9009\9879</strong>\6765\8986\76D6\6B64\8BBE\7F6E\3002\6B64\5916, \7528\6237\53EF\4EE5\5355\51FB\663E\793A\5728\4E3B\9875\5E95\90E8\7684\65F6\533A\94FE\63A5\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285050797303873107)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\9875\65E0\6CD5\76F4\63A5\901A\8FC7 UI \8BBF\95EE\3002\5B83\7528\4E8E\534F\52A9\6982\8981\4FE1\606F\76F8\7247\4E0B\8F7D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285050420392873107)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\201C\7528\6237\6982\8981\4FE1\606F\201D\9875\53EF\4EE5\5728\4E00\4E2A\6613\7528\7684\5C4F\5E55\4E0A\67E5\770B\7528\6237\7684\76F8\5173\4FE1\606F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285050161563873106)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\4E0A\8F7D\65B9\5F62\7684\76F8\7247, \5426\5219\76F8\7247\4F1A\53D8\5F62\3002\9996\9009\56FE\50CF\5927\5C0F\4E3A 250x250 \50CF\7D20\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285036266597873096)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\8868\5355\53EF\4EE5\66F4\65B0\4E2A\4EBA\8BE6\7EC6\4FE1\606F\548C\4E0A\8F7D\76F8\7247\6216\5934\50CF\3002</p>'),
unistr('<p>\8981\4E0A\8F7D\56FE\50CF, \8BF7\5355\51FB<strong>\6D4F\89C8</strong>\6216\5C06\56FE\50CF\62D6\653E\5230\6309\94AE\4E0A\3002<br>'),
unistr('\8BF7\4E0A\8F7D\6B63\65B9\5F62\7684\76F8\7247, \5426\5219\76F8\7247\4F1A\53D8\5F62\3002\9996\9009\56FE\50CF\5927\5C0F\4E3A 250x250 \50CF\7D20\3002</p>'),
unistr('<p>\5355\51FB<strong>\5220\9664\76F8\7247</strong>\53EF\5220\9664\56FE\50CF\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285056341795873111)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\6B64\9875\53EF\4EE5\8BBF\95EE\6240\6709\5E94\7528\7A0B\5E8F\5E2E\52A9\6587\672C\3002"\6587\6863" \533A\57DF\4E2D\7684\94FE\63A5\63D0\4F9B\4E86\6709\5173\5E94\7528\7A0B\5E8F\7279\8272\548C\529F\80FD\7684\66F4\591A\6DF1\5165\8BF4\660E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285037301291873097)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\6B64\9875\4E0A\53EF\4EE5\4E3A\5E10\6237\8BBE\7F6E\5E94\7528\7A0B\5E8F\9996\9009\9879\3002\9996\9009\9879\53EF\5F71\54CD\5E94\7528\7A0B\5E8F\7684\591A\4E2A\65B9\9762, \4F8B\5982\65F6\533A\3002\5355\51FB\9879\7EA7\522B\7684\5E2E\52A9\56FE\6807\53EF\4EE5\4E86\89E3\5404\9996\9009\9879\7684\4F5C\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284029458948872366)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\6B64\62A5\544A\663E\793A\6392\961F\7B49\5F85\53D1\9001\7684\6240\6709\7535\5B50\90AE\4EF6\4EE5\53CA\5DF2\7ECF\53D1\9001\7684\7535\5B50\90AE\4EF6\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284161383201872462)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\6B64\62A5\8868\5305\62EC\9009\5B9A\8981\7531\8BE5\5E94\7528\7A0B\5E8F\76D1\89C6\7684\6240\6709\4F5C\4E1A\3002\53EF\4EE5\901A\8FC7\5355\51FB\4F5C\4E1A\540D\79F0\6765\67E5\770B\5404\4E2A\4F5C\4E1A\7684\8BE6\7EC6\4FE1\606F\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284167980744872467)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\6B64\62A5\8868\5305\62EC\6709\5173\9009\5B9A\8981\7531\8BE5\5E94\7528\7A0B\5E8F\76D1\89C6\7684\4F5C\4E1A\7684\8FD0\884C\8BE6\7EC6\4FE1\606F\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285021642513873085)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\201C\5173\4E8E\6B64\5E94\7528\7A0B\5E8F\201D\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285038035327873098)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\4E0D\5E0C\671B\63A5\6536\6765\81EA\6B64\5E94\7528\7A0B\5E8F\7684\7535\5B50\90AE\4EF6, \5219\5C06\6B64\9009\9879\8BBE\7F6E\4E3A\201C\5426\201D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285072226981873123)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5728\641C\7D22\5BF9\8BDD\6846\4E2D\8F93\5165\641C\7D22\8BCD\5E76\5355\51FB<strong>\641C\7D22</strong>\3002<br>'),
unistr('\5355\51FB\4EFB\610F\7ED3\679C\6807\9898\53EF\5BFC\822A\5230\8BE5\7279\5B9A\8BB0\5F55\3002</p>'),
unistr('<p>\8981\9650\5236\641C\7D22, \8BF7\53D6\6D88\9009\4E2D\4E00\4E2A\6216\591A\4E2A\6E90, \8FD9\5C06\4ECE\641C\7D22\7ED3\679C\4E2D\5220\9664\8BE5\62A5\544A\3002</p>'),
unistr('<p>\5355\51FB<strong>\91CD\7F6E</strong>\53EF\5220\9664\5F53\524D\641C\7D22\8BCD\5E76\9009\4E2D\6240\6709\6E90\3002</p> ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285037841967873097)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\5728\5E94\7528\7A0B\5E8F\4E2D\4F7F\7528\7684\9996\9009\65F6\533A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283949975410872308)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9690\85CF\9879\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285057923146873112)
,p_name=>'CA.HOME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285064067258873117)
,p_name=>'CA.HOME.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285080407815873129)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\5C0F\65F6\9875\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284028573296872366)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTML \6B63\6587\5927\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285054797568873110)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('HTML \6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285051423553873107)
,p_name=>'CA.IN.PROGRESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\8FDB\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285076672941873126)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5305\62EC\5728\8868\5355\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285076581838873126)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5305\62EC\5728\62A5\8868\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285060153357873114)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B89\88C5\652F\6301\5BF9\8C61\811A\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284162048328872463)
,p_name=>'CA.INSTANCE.ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9E\4F8B ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284163212377872464)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9E\4F8B\6EDE\7559')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285033898803873094)
,p_name=>'CA.INTRO.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B22\8FCE\4F7F\7528\8FD9\79CD\53EA\652F\6301\4E91\9884\89C8\7684\5168\65B0\6539\8FDB\65B9\6CD5\6765\521B\5EFA\5177\6709\66F4\5B8C\5907\529F\80FD\7684\5E94\7528\7A0B\5E8F\3002\6807\51C6\7684\201C\521B\5EFA\5E94\7528\7A0B\5E8F\201D\5411\5BFC\53EA\5141\8BB8\60A8\9009\62E9\8981\751F\6210\7684\9875, \800C\6B64\5411\5BFC\8FD8\53EF\4EE5\5C06\591A\79CD\989D\5916\529F\80FD\5FEB\901F\9884\52A0\8F7D\5230\5E94\7528\7A0B\5E8F\4E2D\3002</p>'),
unistr('<p>\4F7F\7528\6B64\5411\5BFC\751F\6210\7684\5E94\7528\7A0B\5E8F\53EF\83B7\5F97\5B8C\6574\7684\652F\6301, \5E76\4E14\8FD8\53EF\4EE5\5305\62EC\6240\9009\529F\80FD\7684\652F\6301\5BF9\8C61, \4F8B\5982\8BBF\95EE\63A7\5236, \7535\5B50\90AE\4EF6\6846\67B6, \53CD\9988\7B49\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285034022590873095)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9996\5148\8F93\5165\5E94\7528\7A0B\5E8F\540D\79F0\3002\63A5\4E0B\6765\5C06\4E00\9875\6216\591A\9875\6DFB\52A0\5230\5E94\7528\7A0B\5E8F\3002\9009\4E2D\8981\5305\62EC\7684\529F\80FD\3002\9009\62E9\5E94\7528\7A0B\5E8F\7684\5916\89C2, \7136\540E\67E5\770B\8BBE\7F6E\3002<br>'),
unistr('\4E5F\5C31\662F\5355\51FB<strong>\521B\5EFA\5E94\7528\7A0B\5E8F</strong>\5C31\53EF\4EE5\5F00\59CB!</p>'),
unistr('<p>\5355\51FB<strong>\67E5\770B\84DD\56FE</strong>\4EE5\91CD\7528\4EE5\524D\6240\751F\6210\5E94\7528\7A0B\5E8F\4E2D\7684\6A21\578B\6216\5FEB\901F\590D\5236\9875\3002</p>'),
unistr('<p><em><strong>\6CE8:</strong> \5404\4E2A\90E8\5206\548C\5404\4E2A ''\6DFB\52A0\9875'' \5305\62EC\8BE6\7EC6\7684\5E2E\52A9, \53EF\4E3A\60A8\63D0\4F9B\8FDB\4E00\6B65\6307\5BFC\3002</em></p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285033953134873094)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\4F55\4F7F\7528\672C\5411\5BFC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285068619018873120)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4E0B\9762\5217\51FA\4E86\53D1\884C\65F6\5B58\5728\7684\91CD\5927\95EE\9898:'),
'<ol>',
unistr('  <li>\201C\4ECE\84DD\56FE\521B\5EFA\5E94\7528\7A0B\5E8F\201D\5411\5BFC\672A\7FFB\8BD1\3002</li>'),
unistr('  <li>\901A\8FC7\6B64\5411\5BFC\751F\6210\7684\5DF2\7FFB\8BD1\5E94\7528\7A0B\5E8F\4EC5\662F\90E8\5206\7FFB\8BD1\7684\3002</li>'),
unistr('  <li>\62A5\544A\7EC6\5316\4EC5\5141\8BB8\4E00\4E2A\7EC6\5316\5217\3002</li>'),
unistr('  <li>\65E0\6CD5\751F\6210\7B5B\9009\62A5\544A\9875\3002</li>'),
unistr('  <li>\7535\5B50\90AE\4EF6\529F\80FD\63D0\4F9B\4F4E\7EA7\522B API, \4F46\5C1A\672A\5305\62EC\8F83\9AD8\7EA7\522B\7684\7535\5B50\90AE\4EF6\529F\80FD\3002</li>'),
unistr('  <li>\4ECE\5F15\7528\7F3A\5C11\8868\7684\84DD\56FE\751F\6210\5E94\7528\7A0B\5E8F\7684\64CD\4F5C\5C06\975E\6B63\5E38\5931\8D25\3002</li>'),
unistr('  <li>\9AD8\7EA7\8BBE\7F6E - \672A\5411\751F\6210\7684\5E94\7528\7A0B\5E8F\5E94\7528\65E5\671F\683C\5F0F\3002</li>'),
'</ol>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285068574569873120)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\77E5\95EE\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285034284190873095)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\53D1\5E03\65F6\95F4: %0\3002</p>'),
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285034111971873095)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\884C\7248\8BE6\7EC6\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285033778237873094)
,p_name=>'CA.INTRO.TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\4ECE\84DD\56FE\521B\5EFA\5E94\7528\7A0B\5E8F\201D\5411\5BFC {\4EC5\4E91\9884\89C8}')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285045387596873103)
,p_name=>'CA.IP.ADDRESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('IP \5730\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285043552548873102)
,p_name=>'CA.IR.SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('IR \641C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285046583509873104)
,p_name=>'CA.IR.SEARCHES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('IR \641C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285075053426873125)
,p_name=>'CA.ITEMNAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284166069490872466)
,p_name=>'CA.JOB.ACTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284167553454872467)
,p_name=>'CA.JOB.CLASS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\7C7B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284166666256872466)
,p_name=>'CA.JOB.CREATOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\521B\5EFA\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284167723461872467)
,p_name=>'CA.JOB.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284164263448872464)
,p_name=>'CA.JOB.PRIORITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\4F18\5148\7EA7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284161244610872462)
,p_name=>'CA.JOB.REPORTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\62A5\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284203835199872493)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\652F\6301\6B64\5E94\7528\7A0B\5E8F\7684\4F5C\4E1A\7684\72B6\6001\548C\8FD0\884C\8BE6\7EC6\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284167821347872467)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\8FD0\884C\8BE6\7EC6\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284166763720872466)
,p_name=>'CA.JOB.STYLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\6837\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284166827059872466)
,p_name=>'CA.JOB.SUBNAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\5B50\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284166169329872466)
,p_name=>'CA.JOB.TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284162825687872463)
,p_name=>'CA.JOB.WEIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F5C\4E1A\6743\91CD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285075566161873125)
,p_name=>'CA.KEYCOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\952E\5B57\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285077301453873127)
,p_name=>'CA.LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285075811389873125)
,p_name=>'CA.LABELCOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285077571936873127)
,p_name=>'CA.LABELPLURAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E\590D\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285077217446873126)
,p_name=>'CA.LABELSINGULAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E\5355\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285032945710873094)
,p_name=>'CA.LANGUAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BED\8A00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285033080289873094)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\6B64\5E94\7528\7A0B\5E8F\7684\4E3B\8BED\8A00\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285068020289873120)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\4E3B\8BED\8A00\8868\793A\7528\4E8E\663E\793A\5728\5E94\7528\7A0B\5E8F\6784\5EFA\5668\4E2D\751F\6210\7684\9875\548C\7EC4\4EF6\7684\8BED\8A00\3002\5982\679C\9009\62E9\591A\79CD\7FFB\8BD1, \6700\7EC8\7528\6237\53EF\4EE5\9009\62E9\5448\73B0\8FD0\884C\65F6\5E94\7528\7A0B\5E8F\6240\7528\7684\8BED\8A00\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284312453910872573)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BED\8A00\9009\62E9\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285049946388873106)
,p_name=>'CA.LAST.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\59D3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284166983686872466)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\6B21\8FD0\884C\6301\7EED\65F6\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284167023060872467)
,p_name=>'CA.LAST.START.DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\6B21\5F00\59CB\65E5\671F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285080802774873129)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\65B0\6D3B\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285076728167873126)
,p_name=>'CA.LISTOFVALUES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285072191637873123)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A0\8F7D\84DD\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284169386651872468)
,p_name=>'CA.LOG.DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\5FD7\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284169585978872468)
,p_name=>'CA.LOG.ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\5FD7 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284163503402872464)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6\8BB0\5F55\7EA7\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283950761753872309)
,p_name=>'CA.LOOKUP.COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\67E5\627E\5217</strong> - \5C55\5F00\53EF\67E5\770B\7528\4E8E\5B9A\4E49\5BF9\5176\4ED6\8868\7684\67E5\627E\7684\5C5E\6027\3002\4F7F\7528\201C\67E5\627E\5217\201D\53EF\4F7F\7528\663E\793A\5217\66FF\6362\6807\8BC6\7B26\FF0C\4F8B\5982\663E\793A\90E8\95E8\540D\79F0\800C\4E0D\662F\90E8\95E8\7F16\53F7\3002<br>'),
unistr('<em><strong>\6CE8\FF1A</strong>\53EA\6709\5728\5F53\524D\9875\57FA\4E8E\8868\6216\89C6\56FE\5E76\4E14\5177\6709\5BF9\5176\4ED6\8868\7684\5916\952E\7EA6\675F\6761\4EF6\65F6\FF0C\624D\4F1A\663E\793A\201C\67E5\627E\5217\201D\3002'),
'  <ul>',
unistr('    <li><strong>\67E5\627E\5173\952E\5B57</strong> - \9009\62E9\8981\66F4\6539\4E3A\7528\4E8E\8F93\51FA\663E\793A\5217\7684\5217\3002</li>'),
unistr('    <li><strong>\663E\793A\5217</strong> - \9009\62E9\8981\663E\793A\7684\5217\FF08\4ECE\67E5\627E\8868\4E2D\FF09\3002</li>'),
'    &nbsp;<br>',
unistr('    <em><strong>\6CE8\FF1A</strong>\53EA\9009\62E9\5177\6709\5BF9\5176\4ED6\8868\7684\5F15\7528\7684\5217\FF08\4F7F\7528\5916\952E\FF09\3002</em></li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285053912039873109)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\7535\5B50\90AE\4EF6\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285051925896873108)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\53CD\9988')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285048046688873105)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7BA1\7406\7528\6237\8BBF\95EE\6743\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285081444758873130)
,p_name=>'CA.MASTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\4E3B\4ECE\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285081575817873130)
,p_name=>'CA.MASTER.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\4E00\4E2A\9875\FF0C\5728\5176\4E2D\663E\793A\4E3B\4ECE\9875\4EE5\5141\8BB8\6700\7EC8\7528\6237\67E5\770B\548C\7EF4\62A4\6570\636E\3002<br>'),
'&nbsp;</p>',
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\9875\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
unistr('  <li><strong>\9875\7C7B\578B</strong> - \9009\62E9\9875\7684\7C7B\578B [\5E76\6392\3001\5806\53E0]\3002<br>'),
unistr('    <strong>\5E76\6392</strong>\FF1A<br>'),
unistr('<em>\5229\7528\7F16\6392\5E03\5C40\548C\5305\542B\6A21\5F0F\7F16\8F91\7A97\53E3\7684\62A5\8868\533A\57DF\7684\5355\9875\4E3B\4ECE\3002</em>'),
'    <ul>',
unistr('      <li><strong>\8868</strong>\FF08\5FC5\9700\FF09- \4E3A\9875\9009\62E9\4E3B\8868\3002</li>'),
unistr('      <li><strong>\4E3B\663E\793A\5217</strong>\FF08\5FC5\9700\FF09- \9009\62E9\8981\5728\4E3B\8BB0\5F55\5217\8868\4E2D\663E\793A\7684\5217\3002</li>'),
unistr('      <li><strong>\6B21\663E\793A\5217</strong>\FF08\5FC5\9700\FF09- \9009\62E9\8981\5728\4E3B\8BB0\5F55\5217\8868\4E2D\7684\4E3B\663E\793A\5217\4E0B\65B9\663E\793A\7684\8BF4\660E\6027\5217\3002</li>'),
unistr('      <li><strong>\4ECE\8868 1</strong>\FF08\5FC5\9700\FF09- \4E3A\9875\9009\62E9\7B2C\4E00\4E2A\4ECE\8868\3002</li>'),
unistr('      <li><strong>\4ECE\8868 2</strong> - \4E3A\9875\9009\62E9\7B2C\4E8C\4E2A\4ECE\8868\3002</li>'),
unistr('      <li><strong>\4ECE\8868 3</strong> - \4E3A\9875\9009\62E9\7B2C\4E09\4E2A\4ECE\8868\3002</li>'),
unistr('      <li><strong>\4ECE\8868 4</strong> - \4E3A\9875\9009\62E9\7B2C\56DB\4E2A\4ECE\8868\3002</li>'),
'    </ul>',
unistr('   <strong>\5806\53E0</strong>\FF1A<br>'),
unistr('<em>\5229\7528\53EF\7F16\8F91\4EA4\4E92\5F0F\7F51\683C\7684\5355\9875\4E3B\4ECE\3002</em>'),
'    <ul>',
unistr('      <li><strong>\8868</strong>\FF08\5FC5\9700\FF09- \4E3A\53EF\7F16\8F91\7684\4EA4\4E92\5F0F\7F51\683C\9009\62E9\4E3B\8868\3002</li>'),
unistr('      <li><strong>\4ECE\8868</strong>\FF08\5FC5\9700\FF09- \4E3A\9875\9009\62E9\4ECE\8868\3002</li>'),
unistr('      <em><strong>\6CE8\FF1A</strong>\4F7F\7528\5411\5BFC\53EA\80FD\6DFB\52A0\4E00\4E2A\4ECE\8868\FF08\53EF\7F16\8F91\7684\4EA4\4E92\5F0F\7F51\683C\FF09\3002\53EF\5728\751F\6210\540E\8F7B\677E\5730\6DFB\52A0\5176\4ED6\4ECE\8868\3002</em>'),
'    </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284312396876872573)
,p_name=>'CA.MASTER_RECORDS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\8BB0\5F55')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285044243905873102)
,p_name=>'CA.MAX.ELAPSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\957F\7528\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284164020135872464)
,p_name=>'CA.MAX.FAILURES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5927\5931\8D25\6B21\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284163652802872464)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\957F\8FD0\884C\65F6\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284164141896872464)
,p_name=>'CA.MAX.RUNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5927\8FD0\884C\6B21\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285075797441873125)
,p_name=>'CA.MAXIMUMROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5927\884C\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285078745126873128)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5927\5BBD\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285069351141873120)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285069732088873121)
,p_name=>'CA.MD.ADD.ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285069219934873120)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285070196684873121)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\671F\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285070237508873121)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\671F\503C 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285069444422873121)
,p_name=>'CA.MD.EDIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285068809996873120)
,p_name=>'CA.MD.FILTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285068790288873120)
,p_name=>'CA.MD.FILTERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285069844590873121)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285069186998873120)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\9009\62E9\8BB0\5F55')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285069050457873120)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\627E\4E0D\5230\4EFB\4F55\8BB0\5F55')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285069687640873121)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5DF2\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285069501555873121)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \5DF2\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285068995926873120)
,p_name=>'CA.MD.SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285069944676873121)
,p_name=>'CA.MD.VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285070044987873121)
,p_name=>'CA.MD.VALUE.2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285043783810873102)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\65F6\4E2D\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285052872319873108)
,p_name=>'CA.MESSAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D88\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285078277087873127)
,p_name=>'CA.METRIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5EA6\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285044664019873102)
,p_name=>'CA.MIN.ELAPSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\77ED\7528\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285047434842873104)
,p_name=>'CA.MOBILE.PHONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\79FB\52A8\7535\8BDD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285043266519873101)
,p_name=>'CA.MODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285057049428873111)
,p_name=>'CA.MORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\591A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285046606589873104)
,p_name=>'CA.MOST RECENT'
,p_message_language=>'zh-cn'
,p_message_text=>'Most_Recent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285080614222873129)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\6D3B\8DC3\7684\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283950874418872309)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\591A\4E2A\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283950905414872309)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\68C0\67E5\4E00\4E2A\6216\591A\4E2A\8868\540D\6216\89C6\56FE\540D\79F0\3002\6B64\5916\FF0C\5355\51FB\6807\9898\4E2D\7684\590D\9009\6846\53EF\4EE5\9009\62E9\6216\53D6\6D88\9009\62E9\5217\51FA\7684\6240\6709\6570\636E\5E93\5BF9\8C61\3002</p>'),
unistr('<p>\5C06\4E3A\6BCF\4E2A\9009\4E2D\7684\6570\636E\5E93\5BF9\8C61\6DFB\52A0\5177\6709\4EA4\4E92\5F0F\62A5\8868\7684\9875\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285040681110873099)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('#LABEL# \5FC5\987B\662F\6709\6548\65F6\95F4\6233\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285078075948873127)
,p_name=>'CA.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285032183644873093)
,p_name=>'CA.NAVIGATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285032252333873093)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\6307\5B9A\5728\5E94\7528\7A0B\5E8F\4FA7\9762\8FD8\662F\9876\90E8\663E\793A\83DC\5355\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285084702777873132)
,p_name=>'CA.NEGATIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D1F\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285084625711873132)
,p_name=>'CA.NEUTRAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E2D\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285070703791873122)
,p_name=>'CA.NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E00\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284163868816872464)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\6B21\8FD0\884C\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284162715157872463)
,p_name=>'CA.NLS.ENV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('NLS \73AF\5883')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284260508328872535)
,p_name=>'CA.NO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5426')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285051516109873107)
,p_name=>'CA.NO.ACTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285063185103873116)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\6B64\9875\7684\5E2E\52A9\4FE1\606F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283950062483872308)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5B58\5728\6709\6548\7528\6237 - \9875\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285071771074873122)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\627E\4E0D\5230\6709\6548\7684\65B0\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285067845441873119)
,p_name=>'CA.NONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285047742332873105)
,p_name=>'CA.NOTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CE8\91CA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285023216566873087)
,p_name=>'CA.NOTIFICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285022098121873086)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\4E3B\9875\4E0A\663E\793A\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285023377735873087)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8BB8\5E94\7528\7A0B\5E8F\7BA1\7406\5458\6307\5B9A\5728\5E94\7528\7A0B\5E8F\4E3B\9875\4E0A\5411\6240\6709\6700\7EC8\7528\6237\663E\793A\7684\9884\8B66\FF08\9EC4\8272\FF09\6216\9519\8BEF\FF08\7EA2\8272\FF09\3002\6B64\529F\80FD\5BF9\4E8E\5411\6700\7EC8\7528\6237\793E\533A\4F20\9012\91CD\8981\4FE1\606F\975E\5E38\6709\7528\3002</p>'),
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6\FF1A<ul>'),
unistr('<li>\80FD\591F\5B9A\4E49\901A\77E5</li>'),
unistr('<li>\5728\5E94\7528\7A0B\5E8F\4E3B\9875\4E0A\663E\793A\901A\77E5</li>'),
unistr('<li>\80FD\591F\63A7\5236\663E\793A\901A\77E5\7684\65F6\95F4\7A97\53E3</li>'),
unistr('<li>\652F\6301\6309\7C7B\578B\5BF9\901A\77E5\8FDB\884C\989C\8272\7F16\7801</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285039995007873099)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285043421817873102)
,p_name=>'CA.NUM.ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284165972108872466)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53C2\6570\7684\6570\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284162513424872463)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\76EE\6807\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285076280877873126)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\5B57\683C\5F0F\63A9\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285044995210873103)
,p_name=>'CA.OCCURRENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FA\73B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285084988417873132)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9664\975E\6709\5176\4ED6\7BA1\7406\5458, \5426\5219\60A8\65E0\6CD5\6267\884C\6B64\64CD\4F5C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285051798501873108)
,p_name=>'CA.OPEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\89E3\51B3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285024720322873088)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\7EC4\7EC7\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285025022255873088)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6309\7167\60A8\5E0C\671B\5728\5E94\7528\7A0B\5E8F\4E2D\663E\793A\7684\987A\5E8F\6765\6392\5217\9875\3002<br>'),
unistr('\8981\5728\5217\8868\4E2D\5BF9\9875\8FDB\884C\91CD\65B0\6392\5E8F\FF0C\8BF7\5355\51FB\5E76\6309\4F4F\6BCF\4E2A\9875\5217\8868\5C3E\90E8\7684<em>\62D6\52A8\4EE5\5BF9\9875\91CD\65B0\6392\5E8F</em>\56FE\6807 (<span class="fa fa-bars" aria-hidden="true"></span>)\FF0C\7136\540E\5411\4E0A\6216\5411\4E0B\62D6\653E\76F8\5E94\9875\3002</p>'),
unistr('<p>\4E3B\9875\59CB\7EC8\4F18\5148\663E\793A\FF0C\4E0D\80FD\8FDB\884C\91CD\65B0\6392\5E8F\3002<br>'),
unistr('\7BA1\7406\9875\59CB\7EC8\663E\793A\5728\5217\8868\5E95\90E8\FF0C\987A\5E8F\5C06\6307\660E\8FD9\4E9B\9875\5728\201C\7BA1\7406\201D\9875\4E0A\7684\201C\5E94\7528\7A0B\5E8F\7BA1\7406\201D\5217\8868\4E2D\7684\663E\793A\987A\5E8F\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284168000788872467)
,p_name=>'CA.OUTPUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284169225832872468)
,p_name=>'CA.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285043155554873101)
,p_name=>'CA.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285046369030873104)
,p_name=>'CA.PAGE.EVENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285058854555873113)
,p_name=>'CA.PAGE.HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\5E2E\52A9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285045490922873103)
,p_name=>'CA.PAGE.ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284314353323872574)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\4E3B\8BB0\5F55')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284314514652872574)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6267\884C\641C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285042719470873101)
,p_name=>'CA.PAGE.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285058120536873112)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\5BFC\822A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285044831455873103)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\6027\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285070801721873122)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\7C7B\578B "%0" \4E0D\662F\6709\6548\7684\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285044139338873102)
,p_name=>'CA.PAGE.VIEWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\8BBF\95EE\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285025261845873088)
,p_name=>'CA.PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285025382844873088)
,p_name=>'CA.PAGES.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5B9A\4E49\8981\5305\62EC\5728\521D\59CB\5E94\7528\7A0B\5E8F\4E2D\7684\9875\3002\5FC5\987B\81F3\5C11\5148\5B9A\4E49\4E00\9875\FF0C\7136\540E\624D\80FD\521B\5EFA\5E94\7528\7A0B\5E8F\3002</p>'),
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\6B64\5411\5BFC\521B\5EFA\4EFB\610F\6570\91CF\7684\9875\6765\7F16\5199\51FA\5E94\7528\7A0B\5E8F\3002\521B\5EFA\5E94\7528\7A0B\5E8F\4E4B\540E\FF0C\4F7F\7528\201C\521B\5EFA\9875\201D\5411\5BFC\53EF\6DFB\52A0\66F4\591A\9875\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285076167272873126)
,p_name=>'CA.PAGINATIONMETHOD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\9875\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285044456600873102)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\90E8\5206\9875\8BBF\95EE\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285050268884873107)
,p_name=>'CA.PHOTO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7167\7247')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285050816848873107)
,p_name=>'CA.PHOTO.DELETED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5220\9664\7167\7247\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285050372484873107)
,p_name=>'CA.PHOTO.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7167\7247\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285050056402873106)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7167\7247\4E0A\8F7D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285054894499873110)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EAF\6587\672C\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285084548295873132)
,p_name=>'CA.POSITIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285037601601873097)
,p_name=>'CA.PREFERENCES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9996\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285082157552873130)
,p_name=>'CA.PREVIOUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E00\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285076862840873126)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\663E\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285077789995873127)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\952E\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285077868756873127)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\7236\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285045051104873103)
,p_name=>'CA.PROCEDURE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\7A0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285038250358873098)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\65B0\7535\5B50\90AE\4EF6\9996\9009\9879\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284313937918872574)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\53D6\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285039496494873099)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\4FDD\5B58\5E94\7528\7A0B\5E8F\5916\89C2\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285038102054873098)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\65B0\65F6\533A\9996\9009\9879\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285050678745873107)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6982\8981\4FE1\606F\76F8\7247\4E0B\8F7D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284166220249872466)
,p_name=>'CA.PROGRAM.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A0B\5E8F\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284166397052872466)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A0B\5E8F\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285077122969873126)
,p_name=>'CA.QUERY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284163099360872464)
,p_name=>'CA.RAISE.EVENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F15\53D1\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283794886592872190)
,p_name=>'CA.RATING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BC4\7EA7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285048500950873105)
,p_name=>'CA.READERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BFB\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285037912623873098)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63A5\6536\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285080732882873129)
,p_name=>'CA.RECENT.ERRORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\8FD1\7684\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284821146531872938)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284821229582872938)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285040108210873099)
,p_name=>'CA.RED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EA2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285053793271873109)
,p_name=>'CA.REFERENCED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F15\7528\7684')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284313048040872573)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5237\65B0\7BA1\7406\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283930436930872293)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\5BF9\8BDD\6846\5173\95ED\65F6\5237\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284314401656872574)
,p_name=>'CA.REFRESH_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5237\65B0\62A5\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285039698885873099)
,p_name=>'CA.REGION.BUTTONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285039586234873099)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\9879\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285045518818873103)
,p_name=>'CA.REGION.ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285057507380873112)
,p_name=>'CA.RELEASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\884C\7248 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285024832666873088)
,p_name=>'CA.REMOVING.PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5728\5220\9664\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285024968938873088)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\5355\51FB<strong>\7F16\8F91</strong>\53EF\9009\62E9\9875, \7136\540E\5355\51FB<strong>\5220\9664\9875</strong>\53EF\4ECE\5E94\7528\7A0B\5E8F\4E2D\5220\9664\9875\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284167681103872467)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\590D\95F4\9694 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284029196786872366)
,p_name=>'CA.REPLY.TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56DE\590D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285030622599873092)
,p_name=>'CA.REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\62A5\8868\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285030595298873092)
,p_name=>'CA.REPORT.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\663E\793A\4EA4\4E92\5F0F\62A5\8868\6216\7ECF\5178\62A5\8868\7684\9875\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\9875\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
unistr('  <li><strong>\67E5\8BE2\7C7B\578B</strong> - \9009\62E9\62A5\8868\7684\6E90 [<strong>\8868\6216\89C6\56FE</strong>\6216 <strong>SQL \67E5\8BE2</strong>]\FF1A<br>'),
unistr('    <strong>\8868\6216\89C6\56FE</strong>\FF1A'),
'    <ul>',
unistr('      <li>\8868\6216\89C6\56FE\FF08\5FC5\9700\FF09- \9009\62E9\62A5\8868\7684\6570\636E\5E93\5BF9\8C61\3002</li>'),
unistr('      <li>\5305\62EC\8868\5355 - \9009\62E9\6B64\9879\53EF\5305\62EC\94FE\63A5\7684\8868\5355\9875\FF0C\4EE5\5141\8BB8\7528\6237\7EF4\62A4\8868\503C\3002</li>'),
'    </ul>',
unistr('    <strong>SQL \67E5\8BE2</strong>\FF1A'),
'    <ul>',
unistr('      <li>SQL \67E5\8BE2\FF08\5FC5\9700\FF09- \8F93\5165\8FD4\56DE\552F\4E00\5217\7684\6709\6548 SQL \8BED\53E5\3002</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>\62A5\8868\7C7B\578B</strong> - \9009\62E9\62A5\8868\7684\7C7B\578B\FF08<strong>\4EA4\4E92\5F0F\62A5\8868</strong>\6216<strong>\7ECF\5178\62A5\8868</strong>\FF09\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285022300105873086)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E26\8868\5355\7684 %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284867131245872971)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285079804443873128)
,p_name=>'CA.REPORT.VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\89C6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285078456167873127)
,p_name=>'CA.REPORTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284169068585872468)
,p_name=>'CA.REQ.START.DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\6C42\7684\5F00\59CB\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285078667950873127)
,p_name=>'CA.REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\9700')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285055666634873110)
,p_name=>'CA.RESET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285051607646873108)
,p_name=>'CA.RESOLVED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\89E3\51B3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285051309306873107)
,p_name=>'CA.RESPONSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\54CD\5E94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284164355145872465)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\51FA\73B0\6545\969C\65F6\91CD\65B0\542F\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284164455433872465)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6062\590D\65F6\91CD\65B0\542F\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284161626895872463)
,p_name=>'CA.RESTARTABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\91CD\65B0\542F\52A8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284163936369872464)
,p_name=>'CA.RETRY.COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\8BD5\6B21\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285073608969873124)
,p_name=>'CA.ROLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285045772963873103)
,p_name=>'CA.ROW.NUMBER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285055034987873110)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285073058643873123)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\6A21\677F HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285074384210873124)
,p_name=>'CA.ROWS.CONTENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\5185\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285046469264873104)
,p_name=>'CA.ROWS.FETCHED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\63D0\53D6\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285076026443873126)
,p_name=>'CA.ROWSPERPAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\9875\884C\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284167243745872467)
,p_name=>'CA.RUN.COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD0\884C\8BA1\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284168890665872468)
,p_name=>'CA.RUN.DURATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD0\884C\6301\7EED\65F6\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284163725654872464)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8C03\5EA6\9650\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284165764809872466)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8C03\5EA6\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284165886542872466)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8C03\5EA6\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284165647099872465)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8C03\5EA6\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285033140751873094)
,p_name=>'CA.SCHEMA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285033254447873094)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\9009\62E9\5C06\8981\5728\6B64\6570\636E\5E93\4E2D\4F7F\7528\7684\6570\636E\5E93\5BF9\8C61\5B58\50A8\5230\7684\6570\636E\5E93\65B9\6848\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285075183361873125)
,p_name=>'CA.SCOPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8303\56F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285055777009873111)
,p_name=>'CA.SEARCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285055896981873111)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285055964348873111)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\641C\7D22\201D\5BF9\8BDD\6846')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285080036915873129)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22\8FC7\6EE4\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285062673470873116)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6B64\9875\57FA\4E8E\79F0\4E3A\201C\5DF2\641C\7D22\8868\201D\7684\5171\4EAB\7EC4\4EF6\5217\8868\3002'),
'',
unistr('\6700\521D\4ECE\201C\521B\5EFA\5E94\7528\7A0B\5E8F\201D\5411\5BFC\751F\6210\7684\6240\6709\4EA4\4E92\5F0F\62A5\544A\9875\90FD\5C06\81EA\52A8\6DFB\52A0\5230\6B64\5217\8868\4E2D\3002'),
unistr('\8981\5C06\60A8\81EA\5DF1\7684\8868\6DFB\52A0\5230\6B64\5217\8868\5E76\5BFC\822A\5230\5171\4EAB\7EC4\4EF6, \8BF7\9009\62E9\201C\5217\8868\201D, \7136\540E\5355\51FB\201C\5DF2\641C\7D22\8868\201D\3002'),
unistr('  \8F93\5165\4EE5\4E0B\5C5E\6027:'),
unistr('    \6761\76EE: \5217\8868\6761\76EE\6807\7B7E - \8F93\5165\8868\7684\663E\793A\540D\79F0\3002'),
unistr('    \76EE\6807: \9875 - \9009\62E9\8981\5BFC\822A\5230\7684\76F8\5E94\9875 (\9996\9009\4EA4\4E92\5F0F\62A5\544A)'),
unistr('    \76EE\6807: \6E05\9664\9AD8\901F\7F13\5B58 - \8F93\5165\4EFB\4F55\9700\8981\6E05\9664\7684\9875 (\901A\5E38\7F16\53F7\4E0E\201C\9875\201D\4E0B\65B9\8F93\5165\7684\76F8\540C)\3002'),
unistr('       \5982\679C\5BFC\822A\5230\4EA4\4E92\5F0F\62A5\544A\9875, \5219\6DFB\52A0 CIR,RIR \4EE5\6E05\9664\4EFB\4F55\73B0\6709\7684\7B5B\9009\5668\7B49\3002'),
unistr('    \76EE\6807: \8BBE\7F6E\8FD9\4E9B\9879 - \9009\62E9 (\6216\8F93\5165) \8981\586B\5145\7684\76F8\5E94\9875\9879\3002'),
unistr('       \5982\679C\5BFC\822A\5230\4EA4\4E92\5F0F\62A5\544A\9875, \5219\8F93\5165 IR_[COLUMN_NAME]\3002'),
unistr('    \76EE\6807: \4F7F\7528\8FD9\4E9B\503C - \8F93\5165 =PK='),
unistr('    \7528\6237\5B9A\4E49\7684\5C5E\6027: 1 - \8F93\5165\8981\641C\7D22\7684\5927\5199\8868\540D\3002'),
unistr('    \7528\6237\5B9A\4E49\7684\5C5E\6027: 2 - \8F93\5165\5927\5199\7684\4E3B\5217\540D\3002'),
unistr('    \7528\6237\5B9A\4E49\7684\5C5E\6027: 3 (\53EF\9009) - \8981\641C\7D22\7684\5217\7684\9017\53F7\5206\9694\5217\8868\3002'),
unistr('       \5982\679C\672A\6307\5B9A\4EFB\4F55\5217, \5219\641C\7D22\6240\6709\6587\672C (varchar2) \548C\5B57\7B26\5927\5BF9\8C61 (clob) \5217\3002'),
'',
unistr('\6CE8: \4EC5\5F53\5217\51FA\4E86\591A\4E2A\8868\65F6, \624D\4F1A\5411\7528\6237\663E\793A\8981\641C\7D22\7684\53EF\7528\8868\7684\5217\8868\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285055474343873110)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\641C\7D22\7ED3\679C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285077681736873127)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B21\663E\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285052085431873108)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\9009\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284028481282872366)
,p_name=>'CA.SEND.BEGIN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\5F00\59CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284028806582872366)
,p_name=>'CA.SEND.COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\8BA1\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284028350756872366)
,p_name=>'CA.SEND.END'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\7ED3\675F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284028720623872366)
,p_name=>'CA.SEND.ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285083610964873131)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285083748986873131)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\786E\5B9A\6536\5230\65B0\53CD\9988\65F6\662F\5426\5E94\53D1\9001\7535\5B50\90AE\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285080398694873129)
,p_name=>'CA.SEND.FROM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\81EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285072864485873123)
,p_name=>'CA.SEND.TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D1\9001\5230')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285057366947873112)
,p_name=>'CA.SERIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7CFB\5217 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284168790226872468)
,p_name=>'CA.SESSION.ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F1A\8BDD ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285075374064873125)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F1A\8BDD\72B6\6001\4FDD\62A4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285032557015873093)
,p_name=>'CA.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285032640907873094)
,p_name=>'CA.SETTINGS.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\6307\5B9A\5728\5E94\7528\7A0B\5E8F\751F\6210\4E2D\4F7F\7528\7684\8BBE\7F6E\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285056925921873111)
,p_name=>'CA.SHOW.ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283929601599872293)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A/\9690\85CF\8303\56F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285058085035873112)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\65F6\533A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285057867518873112)
,p_name=>'CA.SIGN.IN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\767B\5F55')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285059012518873113)
,p_name=>'CA.SIGN.OUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CE8\9500')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284168690826872468)
,p_name=>'CA.SLAVE.PID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\5C5E PID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284162632138872463)
,p_name=>'CA.SOURCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285070924625873122)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E90\7C7B\578B\4E0D\662F\6709\6548\7684\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285062703418873116)
,p_name=>'CA.SOURCES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284165571483872465)
,p_name=>'CA.START.DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\59CB\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284167374746872467)
,p_name=>'CA.STATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\72B6\6001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285078575863873127)
,p_name=>'CA.STATICDEFAULT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9759\6001\9ED8\8BA4\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285041721811873100)
,p_name=>'CA.STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\72B6\6001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284163377430872464)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\7A97\53E3\5173\95ED\65F6\505C\6B62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284163429349872464)
,p_name=>'CA.STORE.OUTPUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B58\50A8\8F93\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285052243956873108)
,p_name=>'CA.SUBJECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285050954222873107)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\4EA4\53CD\9988')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285075683896873125)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5EFA\8BAE\7684\53EF\89C6\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285067576523873119)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\652F\6301\5BF9\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285067661310873119)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('<p>\5411\5B89\88C5\811A\672C\4E2D\8F93\5165\4EE3\7801\FF0C\8BE5\4EE3\7801\901A\5E38\7528\4E8E\521B\5EFA\6216\64CD\4F5C\6570\636E\5E93\5BF9\8C61\6216\8005\5BF9\73B0\6709\8BB0\5F55\6267\884C\63D2\5165/\66F4\65B0/\5220\9664\64CD\4F5C\3002\5411\5378\8F7D\811A\672C\4E2D\8F93\5165\4EE3\7801\FF0C\8BE5\4EE3\7801\901A\5E38\7528\4E8E\79FB\9664\FF08\5220\9664\FF09\6570\636E\5E93\5BF9\8C61\3002\8FD9\4E9B\811A\672C\5C06\5408\5E76\5230\652F\6301\5BF9\8C61\4E2D\FF0C\4EE5\4FBF\5728\5BFC\51FA\5E94\7528\7A0B\5E8F\65F6\FF0C\5728\6D4B\8BD5\548C\751F\4EA7\73AF\5883\4E2D\6267\884C\8FD9\4E9B\76F8\540C\7684\66F4\65B0\3002</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285067778684873119)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5411\5B89\88C5\811A\672C\4E2D\8F93\5165\6709\6548\7684 SQL \548C/\6216 PL/SQL \8BED\53E5, \8FD9\4E9B\8BED\53E5\5728\5BFC\5165\5E94\7528\7A0B\5E8F\65F6\8FD0\884C\3002</p>'),
unistr('<p>\5982\679C\60A8\5E0C\671B\8FD9\4E9B\8BED\53E5\4E5F\5728\5F53\524D\73AF\5883\4E2D\8FD0\884C, \800C\4E0D\4EC5\4EC5\5728\5C06\5E94\7528\7A0B\5E8F\5BFC\5165\5230\5176\4ED6\73AF\5883\65F6\8FD0\884C, \8BF7\5355\51FB<strong>\521B\5EFA\5E94\7528\7A0B\5E8F\65F6\8FD0\884C</strong>\3002</p>'),
unistr('<p>\5411\5378\8F7D\811A\672C\4E2D\8F93\5165\6709\6548\7684 SQL \548C/\6216 PL/SQL \8BED\53E5, \8FD9\4E9B\8BED\53E5\5728\4ECE\5E94\7528\7A0B\5E8F\6784\5EFA\5668\5220\9664\5E94\7528\7A0B\5E8F\65F6\8FD0\884C\3002</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284162927884872464)
,p_name=>'CA.SYSTEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7CFB\7EDF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285077010741873126)
,p_name=>'CA.TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285033346259873094)
,p_name=>'CA.TABLE.PREFIX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6846\67B6\5BF9\8C61\524D\7F00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285033455571873094)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8F93\5165\7531\5E94\7528\7A0B\5E8F\4F7F\7528\7684\5BF9\8C61\524D\7F00\3002\4E00\4E9B\529F\80FD\5C06\6B64\524D\7F00\6DFB\52A0\5230\5176\521B\5EFA\7684\6570\636E\5E93\5BF9\8C61 (\5305\62EC\7A0B\5E8F\5305\548C\8868)\3002</p>'),
unistr('<p>\8B66\544A: \786E\4FDD\8F93\5165\672A\7531\5176\4ED6\5E94\7528\7A0B\5E8F\4F7F\7528\7684\552F\4E00\524D\7F00\3002\5982\679C\4E0D\552F\4E00, \5728\521B\5EFA\65F6\5E94\7528\7A0B\5E8F\53EF\80FD\5F15\53D1\9519\8BEF\5E76\4E14\65E0\6CD5\6B63\5E38\5DE5\4F5C\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285077992792873127)
,p_name=>'CA.TABLECOLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285072904974873123)
,p_name=>'CA.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285055303559873110)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\6A21\677F\540D\5DF2\5728\4F7F\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285052135301873108)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\677F\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285040890562873100)
,p_name=>'CA.TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284028699546872366)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\672C\6B63\6587\5927\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285053372935873109)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr(' \6587\672C\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285039034457873098)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\7EC8\7528\6237\4E3B\9898\9996\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285039263728873098)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\9009\4E2D, \5219\6700\7EC8\7528\6237\53EF\4EE5\4F7F\7528\201C\5B9A\5236\201D\94FE\63A5\9009\62E9\81EA\5DF1\7684\4E3B\9898\6837\5F0F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285039115641873098)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\6700\7EC8\7528\6237\9009\62E9\4E3B\9898\6837\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285023419778873087)
,p_name=>'CA.THEME.SELECTOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898\6837\5F0F\9009\62E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285021877978873085)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\65B0\9ED8\8BA4\5E94\7528\7A0B\5E8F\5916\89C2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285023550901873087)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8BB8\7BA1\7406\5458\4E3A\5E94\7528\7A0B\5E8F\9009\62E9\9ED8\8BA4\989C\8272\65B9\6848\FF08\4E3B\9898\6837\5F0F\FF09\3002\7BA1\7406\5458\8FD8\53EF\4EE5\9009\62E9\5141\8BB8\6700\7EC8\7528\6237\9009\62E9\81EA\5DF1\7684\4E3B\9898\6837\5F0F\3002\6700\7EC8\7528\6237\53EA\9700\5355\51FB\4F4D\4E8E\4E3B\9875\5E95\90E8\7684<em>\5B9A\5236</em>\6309\94AE\FF0C\5373\53EF\4ECE\53EF\7528\4E3B\9898\6837\5F0F\4E2D\9009\62E9\3002\4F8B\5982\FF0C\5177\6709\89C6\529B\969C\788D\7684\7528\6237\53EF\80FD\4F1A\504F\597D\989C\8272\5BF9\6BD4\5EA6\9AD8\5F97\591A\7684 <em>Vista</em> \4E3B\9898\6837\5F0F\3002</p>'),
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6\FF1A'),
'<ul>',
unistr('<li>\5141\8BB8\7BA1\7406\5458\5B9A\4E49\9ED8\8BA4\4E3B\9898\6837\5F0F</li>'),
unistr('<li>\5141\8BB8\6700\7EC8\7528\6237\9009\62E9\5404\79CD\4E3B\9898\6837\5F0F</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285031971602873093)
,p_name=>'CA.THEME.STYLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898\6837\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285032001297873093)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9009\62E9\7528\4E8E\663E\793A\5E94\7528\7A0B\5E8F\7684\9ED8\8BA4\4E3B\9898\6837\5F0F\3002</p>'),
unistr('<p>\8BE5\6837\5F0F\53EF\76F4\63A5\66F4\6539\4E3A\5176\4ED6\9884\5B9A\4E49\7684\6837\5F0F\FF0C\6216\8005\5728\751F\6210\4E4B\540E\4FEE\6539\3002\8981\66F4\6539\6837\5F0F\FF0C\8BF7\8FD0\884C\5E94\7528\7A0B\5E8F\FF0C\7136\540E\5355\51FB\5F00\53D1\8005\5DE5\5177\680F\4E2D\7684<strong>\4E3B\9898\6EDA\52A8\6761</strong>\3002</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285046033034873103)
,p_name=>'CA.TIME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65F6\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285037706697873097)
,p_name=>'CA.TIME.ZONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65F6\533A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285024581654873087)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65F6\533A\652F\6301')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285021456995873085)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\9ED8\8BA4\65F6\533A\548C\7528\6237\65F6\533A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285024209761873087)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8BB8\6700\7EC8\7528\6237\8BBE\7F6E\5176\672C\5730\65F6\533A\3002\5982\679C\5E94\7528\7A0B\5E8F\8868\4F7F\7528\80FD\591F\8BC6\522B\65F6\533A\7684\65E5\671F\7C7B\578B (\4F8B\5982\5E26\6709\672C\5730\65F6\533A\7684\65F6\95F4\6233), \4EE5\4FBF\62A5\544A\548C\6570\636E\6761\76EE\53CD\6620\7528\6237\6240\5728\7684\4F4D\7F6E, \5219\8FD9\975E\5E38\91CD\8981\3002</p>'),
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6:'),
'<ul>',
unistr('<li>\5141\8BB8\7BA1\7406\5458\8BBE\7F6E\9ED8\8BA4\65F6\533A</li>'),
unistr('<li>\5141\8BB8\6700\7EC8\7528\6237\9009\62E9\5176\65F6\533A\9996\9009\9879</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285080902167873129)
,p_name=>'CA.TIMEFRAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65F6\95F4\8303\56F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285081296325873129)
,p_name=>'CA.TIMELINE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\65F6\95F4\8868\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285081367097873129)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\663E\793A\65F6\95F4\8868\7684\9875\FF0C\8FD9\5BF9\4E8E\663E\793A\66F4\65B0\5C24\4E3A\6709\7528\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\9875\540D</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
unistr('  <li><strong>\8868\6216\89C6\56FE</strong>\FF08\5FC5\9700\FF09- \4E3A\65F6\95F4\8868\9009\62E9\6570\636E\5E93\5BF9\8C61\3002</li>'),
unistr('  <li><strong>\7528\6237\540D</strong>\FF08\5FC5\9700\FF09- \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\7528\4F5C\4E3A\65F6\95F4\8868\6761\76EE\663E\793A\7684\7528\6237\7684\5217\3002</li>'),
unistr('  <li><strong>\65E5\671F</strong>\FF08\5FC5\9700\FF09- \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\7528\4F5C\65F6\95F4\8868\6761\76EE\7684\65E5\671F\7684\5217\3002</li>'),
unistr('  <li><strong><strong>\4E8B\4EF6\540D</strong>\FF08\5FC5\9700\FF09- \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\7528\4F5C\65F6\95F4\8868\6761\76EE\7684\6807\9898\7684\5217\3002</li>'),
unistr('  <li><strong>\63CF\8FF0</strong> - \4ECE\8868\6216\89C6\56FE\4E2D\9009\62E9\7528\4F5C\65F6\95F4\8868\6761\76EE\63CF\8FF0\7684\5217\3002</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285042994445873101)
,p_name=>'CA.TIMESTAMP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65F6\95F4\6233')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285047542319873105)
,p_name=>'CA.TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284029230911872366)
,p_name=>'CA.TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6536\4EF6\4EBA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285046794666873104)
,p_name=>'CA.TOP.USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5E38\8BBF\95EE\7684\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285046830487873104)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9876\5C42\7528\6237\56FE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285044327291873102)
,p_name=>'CA.TOTAL.ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\884C\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285048778217873105)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5728\8BBF\95EE\63A7\5236\5217\8868\4E2D\7684\7528\6237\7684\9ED8\8BA4\89D2\8272\FF1A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285040947272873100)
,p_name=>'CA.TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284259859927872534)
,p_name=>'CA.UI.DEFAULTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\754C\9762\9ED8\8BA4\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284259939191872534)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\7528\6237\754C\9762\8BBE\7F6E\7684\9ED8\8BA4\503C\FF08\4F8B\5982\6BCF\9875\884C\6570\FF09\FF0C\5E76\6DFB\52A0\503C\5B9A\4E49\5217\8868\3002\5F53\5728\5E94\7528\7A0B\5E8F\4E2D\751F\6210\7EC4\4EF6\65F6\4F7F\7528\8FD9\4E9B\8BBE\7F6E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285041127431873100)
,p_name=>'CA.UNTIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284312882644872573)
,p_name=>'CA.UPDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285050559531873107)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\65B0\6982\8981\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285041454810873100)
,p_name=>'CA.UPDATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\65B0\65F6\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285041547881873100)
,p_name=>'CA.UPDATED.BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\65B0\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285042891263873101)
,p_name=>'CA.USER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285070482655873121)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\591A\4E2A\7528\6237 - \6B65\9AA4 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285070588586873121)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\591A\4E2A\7528\6237 - \6B65\9AA4 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285070604795873121)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\591A\4E2A\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285045267649873103)
,p_name=>'CA.USER.AGENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\4EE3\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285058602738873113)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\8BA1\6570\62A5\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285047095789873104)
,p_name=>'CA.USER.NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285049575814873106)
,p_name=>'CA.USER.PROFILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\6982\8981\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285024420235873087)
,p_name=>'CA.USER.PROFILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\6982\8981\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285021384832873085)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\7528\6237\66F4\65B0\5176\6982\8981\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285024332823873087)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8BB8\6700\7EC8\7528\6237\8F93\5165\6709\5173\81EA\5DF1\7684\8BE6\7EC6\4FE1\606F, \5305\62EC\7167\7247\6216\5934\50CF, \7528\4E8E\4E2A\6027\5316\5176\5E10\6237\3002</p>'),
unistr('<p>\5305\62EC\4EE5\4E0B\7EC4\4EF6:'),
'<ul>',
unistr('<li>\4F9B\6700\7EC8\7528\6237\8BBE\7F6E\5176\6982\8981\4FE1\606F\7684\8BBE\7F6E\9875</li>'),
unistr('<li>\80FD\591F\4E0A\8F7D\7167\7247/\5934\50CF</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285049774977873106)
,p_name=>'CA.USERNAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285048889552873105)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\540D\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285071352335873122)
,p_name=>'CA.USERNAMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284267559202872540)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\540D\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285071973744873122)
,p_name=>'CA.USERS.ADDED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6DFB\52A0\7528\6237\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285073499904873124)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\89D2\8272\663E\793A\7684\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285052941571873109)
,p_name=>'CA.USERS.INCLUDED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5305\542B\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285071699991873122)
,p_name=>'CA.USERS.TO.ADD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\6DFB\52A0\7684\7528\6237')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285049038965873106)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\65B0\7528\6237\540D\683C\5F0F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283949848055872308)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B58\5728\6709\6548\7528\6237 - \9875\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285064661029873117)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F ID \5DF2\5B58\5728, \6216\8005\662F\4E3A\5176\4ED6\5E94\7528\7A0B\5E8F\4FDD\7559\7684 ID\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284208117243872496)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\6307\5B9A\5E94\7528\7A0B\5E8F\540D\79F0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285074059685873124)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\63D0\4F9B\8981\5C06\7535\5B50\90AE\4EF6\53D1\9001\5230\7684\7535\5B50\90AE\4EF6\5730\5740\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285073844591873124)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\63D0\4F9B\7535\5B50\90AE\4EF6\5730\5740, \6216\8005\9009\62E9\4E00\7EC4\8981\5C06\7535\5B50\90AE\4EF6\53D1\9001\7ED9\7684\7528\6237\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285073923493873124)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FC5\987B\9009\62E9\4E00\7EC4\8981\5C06\7535\5B50\90AE\4EF6\53D1\9001\7ED9\7684\7528\6237\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285064772769873117)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\524D\7F00\4E0D\80FD\8D85\8FC7\516D\4E2A\5B57\7B26, \5FC5\987B\4EE5\5B57\6BCD\5F00\5934, \5E76\4E14\53EA\80FD\5305\542B\5B57\6BCD, \6570\5B57\548C\4E0B\5212\7EBF\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285064865376873117)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\8F93\5165\4E0D\540C\7684\8868\524D\7F00\3002\4EE5\4E0B\6570\636E\5E93\5BF9\8C61\5DF2\5B58\5728: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285049438904873106)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\540D\4E0D\662F\6709\6548\7684\7535\5B50\90AE\4EF6\5730\5740\683C\5F0F\3002\8BF7\6CE8\610F\4EE5\4E0B\5E94\7528\7A0B\5E8F\7528\6237\540D\683C\5F0F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285049318131873106)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1\7535\5B50\90AE\4EF6\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285046903787873104)
,p_name=>'CA.VIEW.AS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285068347684873120)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\84DD\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285056894598873111)
,p_name=>'CA.VIEW.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\8BE6\7EC6\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285074244560873124)
,p_name=>'CA.VIEW.EMAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\7535\5B50\90AE\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285058986972873113)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\770B\6211\7684\6982\8981\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285043846771873102)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A0\6743\6027\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285078852000873128)
,p_name=>'CA.WIDTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BBD\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285083006521873131)
,p_name=>'CA.WIZARD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5411\5BFC\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283949748509872308)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5411\5BFC\5BB9\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285083159489873131)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\521B\5EFA\7528\4F5C\5411\5BFC\7684\9875\96C6\5408\3002\901A\5E38\4F7F\7528\5411\5BFC\5728\591A\4E2A\6B65\9AA4\4E2D\8F93\5165\6570\636E\3002</p>'),
unistr('<p>\8F93\5165\4EE5\4E0B\5C5E\6027\FF1A</p>'),
'<ul>',
unistr('  <li><strong>\5411\5BFC\540D\79F0</strong>\FF08\5FC5\9700\FF09- \8F93\5165\6B64\9875\7684\540D\79F0\3002</li>'),
unistr('  <li><strong>\8BBE\7F6E\56FE\6807</strong> - \9009\62E9\5728\5BFC\822A\83DC\5355\4E2D\4E3A\6B64\9875\663E\793A\7684\56FE\6807\3002</li>'),
unistr('  <li><strong>\9875\6A21\5F0F</strong>\FF08\5FC5\9700\FF09- \9009\62E9\5411\5BFC\6B65\9AA4\5C06\663E\793A\4E3A\6A21\5F0F\9875\8FD8\662F\6B63\5E38\9875\3002\9009\62E9<strong>\6A21\5F0F\9875</strong>\6216\8005<strong>\5B8C\6574\9875</strong>\3002</li>'),
unistr('  <li><strong>\6B65\9AA4 1 ... 8</strong> - \4E3A\5411\5BFC\7684\6B65\9AA4\8F93\5165\9875\540D\3002<br><em><strong>\6CE8\FF1A</strong>\5F53\4E3A\4E4B\524D\7684\6BCF\4E2A\6B65\9AA4\8F93\5165\540D\79F0\540E\FF0C\5C06\663E\793A\6B65\9AA4 5 - 8\3002</em></li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285047396846873104)
,p_name=>'CA.WORK.PHONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\7535\8BDD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285040071967873099)
,p_name=>'CA.YELLOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9EC4\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284260438620872535)
,p_name=>'CA.YES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283794771913872190)
,p_name=>'CACHED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9AD8\901F\7F13\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283678400402872102)
,p_name=>'CACHE_CREATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\7684\9AD8\901F\7F13\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283665900472872093)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\6570\636E\529F\80FD\5DF2\7981\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283650406590872081)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\6570\636E\529F\80FD\5DF2\7981\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283650538626872081)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\65B0\6570\636E\529F\80FD\5DF2\7981\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283833701670872220)
,p_name=>'CALENDAR.NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\4E00\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283833699092872220)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E00\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283691391315872112)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F7B\677E\65E5\5386')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284854811221872962)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\65E5\5386\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283639082150872073)
,p_name=>'CALENDAR_POPUP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0\7684\65E5\5386\5F39\51FA\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283789566349872186)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6210\529F\521B\5EFA\65E5\5386\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284192346307872485)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E7\65E5\5386\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283691233734872112)
,p_name=>'CALENDAR_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\5386')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284042816453872376)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C1D\8BD5\4ECE\5E94\7528\7A0B\5E8F %0 \548C\6A21\677F ID %1 \8FDB\884C\590D\5236\65F6\672A\627E\5230\65E5\5386\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284193737954872486)
,p_name=>'CANCEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283632134381872067)
,p_name=>'CANDLESTICK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('K \7EBF\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284528423925872728)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EA7\8054\6837\5F0F\8868')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284249886819872527)
,p_name=>'CENTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C45\4E2D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284283988417872552)
,p_name=>'CHANGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284914010582873006)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284188195086872482)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539\6570\636E\5E93\5927\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283806394942872199)
,p_name=>'CHANGE_PW_REQUEST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \8BF7\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284187949063872482)
,p_name=>'CHANGE_REQUEST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539\8BF7\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284475670425872692)
,p_name=>'CHANGE_WORKSPACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\6539\5DE5\4F5C\533A')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284159987532872461)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B57\7B26\96C6\5217')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283885260092872259)
,p_name=>'CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283637437255872071)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\56FE\8868\67E5\8BE2\65E0\6548: %0<br><br>'),
unistr('\8BF7\4F7F\7528\4EE5\4E0B\8BED\6CD5:'),
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
unistr('<tr><td>LABEL</td><td>\6761\5F62\56FE\5BF9\5E94\7684\6587\672C</td></tr>'),
unistr('<tr><td>VALUE</td><td>\5B9A\4E49\6761\5F62\56FE\5927\5C0F\7684\6570\5B57\5217</td></tr>'),
'</table>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283828550316872216)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\56FE\8868\67E5\8BE2\65E0\6548\3002<br /><br />\8BF7\4F7F\7528\4EE5\4E0B\8BED\6CD5: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'),
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
unistr('<td>\5B9A\4E49\4EEA\8868\76D8\503C\7684\6570\5B57\5217\3002</td>'),
'</tr>',
'<tr>',
'<td>MAX</td>',
unistr('<td>\5B9A\4E49\6700\5927\4EEA\8868\76D8\503C\7684\6570\5B57\5217\3002</td>'),
'</tr>',
'<tr>',
unistr('<td>LOW (\53EF\9009)</td>'),
unistr('<td>\5B9A\4E49\4EE5\524D\6700\5C0F\4EEA\8868\76D8\503C\7684\6570\5B57\5217\3002</td>'),
'</tr>',
'<tr>',
unistr('<td>HIGH (\53EF\9009)</td>'),
unistr('<td>\5B9A\4E49\4EE5\524D\6700\5927\4EEA\8868\76D8\503C\7684\6570\5B57\5217\3002</td>'),
'</tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283903487086872273)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6548\7684\56FE\8868\7C7B\578B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283637340824872071)
,p_name=>'CHART.INVALID_QUERY'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\65E0\6CD5\5BF9 SQL \67E5\8BE2\8FDB\884C\8BED\6CD5\5206\6790!'),
'<p>%0</p>',
unistr('\67D0\4E9B\67E5\8BE2\53EA\80FD\5728\8FD0\884C\5E94\7528\7A0B\5E8F\65F6\6267\884C\3002\5982\679C\67E5\8BE2\7684\8BED\6CD5\6B63\786E, \53EF\4EE5\4E0D\7ECF\9A8C\8BC1\800C\4FDD\5B58\5B83 (\8BF7\53C2\9605\67E5\8BE2\6E90\4E0B\9762\7684\9009\9879)\3002')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284969265330873047)
,p_name=>'CHART_DEGREES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284136896412872445)
,p_name=>'CHART_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \56FE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283666765587872093)
,p_name=>'CHART_SERIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\7CFB\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284184478195872479)
,p_name=>'CHART_SERIES_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%1 \7684\56FE\8868\7CFB\5217\9519\8BEF %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283782766365872181)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6210\529F\521B\5EFA\56FE\8868\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283742006159872150)
,p_name=>'CHECK$'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\9009\62E9\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284901710966872997)
,p_name=>'CHECKED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284140740494872447)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\6821\9A8C\548C - \5E94\7528\7A0B\5E8F\7EA7\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283957276309872314)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\6821\9A8C\548C - \4F1A\8BDD\7EA7\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283957173746872314)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\6821\9A8C\548C - \7528\6237\7EA7\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283957010598872313)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\6821\9A8C\548C - \5E94\7528\7A0B\5E8F\7EA7\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284971689830873048)
,p_name=>'CHECK_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\9009\4E2D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284124703005872436)
,p_name=>'CLASSIC_CALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ECF\5178\65E5\5386')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284127743396872438)
,p_name=>'CLASSIC_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ECF\5178\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283827057200872215)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ECF\5178\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284125361206872436)
,p_name=>'CLASSIC_TREE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ECF\5178\6811')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284123551787872435)
,p_name=>'CLEAN_UP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664\9875')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283660917938872089)
,p_name=>'CLEAR_COMMAND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664\547D\4EE4')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284133488176872442)
,p_name=>'CLOSED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\89E3\51B3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284181053069872476)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\8FC7\53BB 7 \5929\5185\5173\95ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283946733710872306)
,p_name=>'CLOSE_WINDOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\95ED\7A97\53E3')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285065273901873117)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\95ED')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285066918101873119)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\627E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285065170567873117)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\627E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285066820526873119)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\627E\4E0B\4E00\4E2A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285066759705873119)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\627E\4E0A\4E00\4E2A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285066577404873118)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81EA\52A8\5B8C\6210')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285065803211873118)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F29\8FDB\5927\5C0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285066063957873118)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5236\8868\7B26\63D2\5165\7A7A\683C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285065485888873118)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5927\5C0F\5199\5339\914D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285065316956873118)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B63\5219\8868\8FBE\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285070311413873121)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\8BE2\6784\5EFA\5668')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285067098860873119)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\505A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285066655767873119)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66FF\6362')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285064922698873117)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\90E8\66FF\6362')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285065030538873117)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66FF\6362')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285067388099873119)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8DF3\8FC7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285066355729873118)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285065650832873118)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285066191748873118)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\884C\53F7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285065519776873118)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\6807\5C3A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285065905137873118)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5236\8868\7B26\5927\5C0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285065744540873118)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285067133407873119)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD8\539F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285066226506873118)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\7EAF\6587\672C\7F16\8F91\5668')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285066478681873118)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285067256878873119)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1\6210\529F')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284063676223872391)
,p_name=>'COLLAPSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6298\53E0')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283674265874872099)
,p_name=>'COLOR_PALETTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8C03\8272\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283900094953872271)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\62DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283899671019872270)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8865\5145')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283900244326872271)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8865\5145\989C\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283900174783872271)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\97F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283899773327872270)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\79BB\8865\5145')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283899999600872270)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56DB\5206')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283899873038872270)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E09\5206')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284520587413872722)
,p_name=>'COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284956643193873037)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\540D\79F0: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284055960841872386)
,p_name=>'COLUMN_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\540D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284261652038872536)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\901A\8FC7\9A8C\8BC1\7684\7528\6237\53EF\4EE5\8BBF\95EE\6B64\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284261745358872536)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EA\6709\5728\5E94\7528\7A0B\5E8F\8BBF\95EE\63A7\5236\5217\8868\4E2D\5B9A\4E49\7684\7528\6237\53EF\4EE5\8BBF\95EE\6B64\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284261821945872536)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\610F\5916\7684\8BBF\95EE\63A7\5236\5217\8868\8BBE\7F6E\503C\FF1A%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283667600323872094)
,p_name=>'COMING_SOON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\7A0D\5019')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284056440692872386)
,p_name=>'COMMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CE8\91CA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284193995251872486)
,p_name=>'COMMENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CE8\91CA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283947998312872307)
,p_name=>'COMPILE_FAILURE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8BD1\5931\8D25, \884C <a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284277947976872548)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8BD1\5931\8D25, \884C %0 (%2) \4E0E\7F16\8BD1\9519\8BEF\76F8\5173\8054\7684\884C\53F7\4E0E\7B2C\4E00\4E2A BEGIN \8BED\53E5\6709\5173\3002\8FD9\4EC5\5F71\54CD\6570\636E\5E93\89E6\53D1\5668\7684\7F16\8BD1\3002<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283947896817872307)
,p_name=>'COMPILE_SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6210\529F\7F16\8BD1 PL/SQL \4EE3\7801 (%0)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284130788329872440)
,p_name=>'COMPLETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B8C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284138166337872446)
,p_name=>'COMPLETED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5B8C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284145149730872451)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B8C\6210/\65E0\95EE\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284181669656872477)
,p_name=>'COMPONENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284338481136872592)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\4EF6\540D: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284609703433872784)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\4EF6\672A\542F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283786281756872184)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6210\529F\521B\5EFA\7EC4\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284951993082873034)
,p_name=>'COMPONENT_SUMMARY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\4EF6\6982\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283729496094872141)
,p_name=>'COMPUTATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284205150016872494)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\7EC4\4EF6\5DF2\6210\529F\5B89\88C5\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283948564568872307)
,p_name=>'CONDITIONAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6709\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284038462749872373)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F39\51FA\5F0F\503C\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284122258806872434)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\59CB\7EC8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283858219199872238)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283857705018872238)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879/\5217=\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283857859862872238)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879/\5217\4E0D\4E3A\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284823808888872940)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879/\5217\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283858391011872239)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\4E0D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283858470448872239)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283858048681872238)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283858110246872238)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\4E0D\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283857647448872238)
,p_name=>'CONDITIONS_SHORTCUT_PLSQL'
,p_message_language=>'zh-cn'
,p_message_text=>'PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283857929719872238)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\6C42=e1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283869557193872247)
,p_name=>'CONDITION_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6761\4EF6\7C7B\578B')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284083663355872406)
,p_name=>'CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\786E\8BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283633921088872069)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\4ECE\9875\FF08\4E24\9875\FF09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283633897980872069)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\4ECE\9875\FF08\4E09\9875\FF09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283844229037872228)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9E\9645\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284129955115872440)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\5217\805A\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284130063295872440)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\4F7F\7528\7684\805A\96C6\51FD\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283841666578872226)
,p_name=>'CONFIRM.APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283855044327872236)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\522B\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283855186351872236)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\8BED\8A00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283854995419872236)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283736157977872146)
,p_name=>'CONFIRM.ARRAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\62A5\544A\7684\7ED3\679C\6811')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283736237674872146)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\62A5\544A\7684\7ED3\679C\53C2\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283855225874872236)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284321659075872580)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\652F\5230\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284045806787872378)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\9694\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283844046250872228)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \6309\94AE\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283843905491872228)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \6309\94AE\663E\793A\6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283647632412872079)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\6DFB\52A0\6570\636E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283647554149872079)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528\62D6\653E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284264001720872537)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284321451596872579)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\53D6\6D88\201D\6309\94AE\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284311957199872572)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\5206\5927\5C0F\5199')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283946274382872306)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\66F4\6539\4EA4\4E92\5F0F\62A5\8868\67E5\8BE2\3002\5982\679C\5220\9664\67E5\8BE2\4E2D\7684\4EFB\4F55\5217, \5219\5C06\7981\7528\73B0\6709\8FC7\6EE4\5668, \7A81\51FA\663E\793A\89C4\5219\4EE5\53CA\5F15\7528\8FD9\4E9B\5217\7684\5176\4ED6\62A5\8868\8BBE\7F6E\3002\8BF7\786E\8BA4\60A8\7684\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283845168860872228)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\5750\6807\8F74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284194263150872486)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EEA\8868\76D8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284194342657872486)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EEA\8868\76D8 (\6247\9762\5F0F)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283845832705872229)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6C34\5E73\6761\5F62\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283846033670872229)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6298\7EBF\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283845393591872229)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\5B57\63A9\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283845960489872229)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\997C\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283845073387872228)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283845256959872229)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283846129336872229)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6563\70B9\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283845662370872229)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\5927\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283845559817872229)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283845418421872229)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283845795039872229)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5782\76F4\6761\5F62\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283736320407872146)
,p_name=>'CONFIRM.COLLECTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E34\65F6\7ED3\679C\96C6\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283842468196872226)
,p_name=>'CONFIRM.COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284045689083872378)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284221545886872506)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284264298444872538)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283854725498872236)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\5217\6807\9898\6392\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283961453739872317)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\590D\5236\5177\6709\4EE5\4E0B\5C5E\6027\7684\5E94\7528\7A0B\5E8F\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283853360483872235)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\590D\5236\5177\6709\4EE5\4E0B\5C5E\6027\7684\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283842922541872227)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\521B\5EFA\65B0\9009\9879\5361\96C6 "%0", \5E76\7531\6B64\9875\4F7F\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283854847333872236)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\5E94\7528\7A0B\5E8F\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283847476708872230)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\65E5\5386\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283850691482872233)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\7EC6\5316\62A5\8868\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283910383634872278)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\4EA4\4E92\5F0F\62A5\8868\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283853659763872235)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\62A5\8868\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283641223450872074)
,p_name=>'CONFIRM.CREATE_FLASH_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684 Flash \56FE\8868\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284927587515873016)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\4F7F\7528\4E0E\5F53\524D\5DE5\4F5C\533A\4E2D\73B0\6709\6570\636E\5E93\5E94\7528\7A0B\5E8F\76F8\540C\7684 ID \521B\5EFA\6570\636E\5E93\5E94\7528\7A0B\5E8F\3002\5C06\5220\9664\73B0\6709\6570\636E\5E93\5E94\7528\7A0B\5E8F, \7136\540E\66FF\6362\4E3A\65B0\6570\636E\5E93\5E94\7528\7A0B\5E8F\3002\8BF7\786E\8BA4\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284218393576872504)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\8868\5355\9875\548C\5217\8868\89C6\56FE\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284129678675872439)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\8868\5355\548C\5E26\6709\5206\6790\9875\7684\62A5\8868\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283847065161872230)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\57FA\4E8E SQL \67E5\8BE2\7684\8868\5355\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283846948193872230)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\57FA\4E8E\5B58\50A8\8FC7\7A0B\7684\8868\5355\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283846816849872230)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\57FA\4E8E\8868\7684\8868\5355\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283692301447872113)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\4F7F\7528\4EE5\4E0B\5C5E\6027\5728 Web \670D\52A1\5F15\7528\9875\4E0A\521B\5EFA\8868\5355\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283749188315872155)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\4F7F\7528\4EE5\4E0B\5C5E\6027\5728 Web \670D\52A1\5F15\7528\9875\4E0A\521B\5EFA\8868\5355\548C\62A5\8868\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284158963219872461)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\5730\56FE\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283631322215872067)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\4F7F\7528\4EE5\4E0B\5C5E\6027\521B\5EFA\4E3B\4ECE\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283848696633872231)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\9762\5305\5C51\533A\57DF\548C\9762\5305\5C51\9009\9879\3002\8BF7\786E\8BA4\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284136975799872445)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283846691830872230)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285003019836873071)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285003177881873072)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\9875\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283849499862872232)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\8868\5355\9875\548C\62A5\8868\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284923492088873013)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283853443694872235)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\62A5\8868\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283847186460872230)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684 HTML \6761\5F62\56FE\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283853098207872235)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\6982\8981\9875\3002\6309 "\6DFB\52A0\66F4\591A" \6309\94AE\53EF\4ECE\5176\4ED6\9875\548C/\6216\533A\57DF\6DFB\52A0\9644\52A0\9879\3002\6309 "\5B8C\6210" \6309\94AE\53EF\521B\5EFA\6982\8981\9879\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283847282416872230)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684 SVG \56FE\8868\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283846584570872230)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\8868\683C\5F0F\8868\5355\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283847717786872231)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\6811\9875\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283846767936872230)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\521B\5EFA\5177\6709\4EE5\4E0B\5C5E\6027\7684\5411\5BFC\3002\8BF7\786E\8BA4\60A8\7684\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284927139273873016)
,p_name=>'CONFIRM.CREATE_WS_APP_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\4F7F\7528\4E0E\5F53\524D\5DE5\4F5C\533A\4E2D\73B0\6709 Websheet \5E94\7528\7A0B\5E8F\76F8\540C\7684 ID \521B\5EFA Websheet \5E94\7528\7A0B\5E8F\3002\5C06\5220\9664\73B0\6709 Websheet \5E94\7528\7A0B\5E8F, \7136\540E\66FF\6362\4E3A\65B0 Websheet \5E94\7528\7A0B\5E8F\3002\8BF7\786E\8BA4\9009\62E9\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284041479828872375)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\94FE\63A5\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284860170153872966)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\5B9A\4E49\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284934767682873021)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\4F7F\7528\73B0\6709\8868\67E5\627E\548C\8F6C\6362\89C4\5219\91CD\65B0\521B\5EFA\6B64\6570\636E\52A0\8F7D\5B9A\4E49\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284312094026872572)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283847579542872230)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\671F\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284137018616872445)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\7684\9A8C\8BC1\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283846483523872229)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283851326737872233)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE %0 \663E\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283634352077872069)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\663E\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283852984134872234)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\9762\5305\5C51\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283852158541872234)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\8868 %0 \7684\6392\5E8F\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283850816094872233)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\9875 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283634249851872069)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283851104039872233)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\8868\540D %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283850961935872233)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BE6\7EC6\8D44\6599\9009\9879\5361\6807\7B7E %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284264516009872538)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\8F7D\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283844541418872228)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284221283804872506)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\8F7D\5217 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284221304411872506)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\8F7D\5217 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283848859532872231)
,p_name=>'CONFIRM.DISPLAY_POINT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\70B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285011948206873078)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285012074573873078)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F16\8F91\9875\9762\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284034384228872370)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('CSV \8F93\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284035066179872371)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6253\5370\8F93\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284035697583872371)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528\5217\6807\9898\6392\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284085525671872407)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E00\4E2A\533A\57DF\5C06\6DFB\52A0\5230\73B0\6709\7684\7BA1\7406\9875\FF1A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284264143671872537)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B8C\6210\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283849906326872232)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283850034059872232)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\9875\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283850290615872232)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\9875\9009\9879\5361\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283850145391872232)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\9875\9009\9879\5361\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284137183829872445)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\5165\5171\4EAB\7EC4\4EF6\81EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284594664567872773)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5305\62EC\5B9A\5236\65E5\5386')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283634523537872069)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\5426\5305\542B\4E3B\62A5\8868?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283852634052872234)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5305\62EC\9762\5305\5C51')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283843737727872227)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FE1\606F\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283843809223872227)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FE1\606F\9ED8\8BA4\6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283692560936872113)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283736527622872146)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\533A\57DF\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283736451435872146)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\5355\533A\57DF\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283846286876872229)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D2\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283843550682872227)
,p_name=>'CONFIRM.ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284264487801872538)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD4\56DE\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284263339571872537)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\627E\5173\952E\5B57\5217 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284263488255872537)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\952E\5B57\5217 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284263591693872537)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\952E\5B57\5217 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283847628697872230)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284221475072872506)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\627E\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284264357281872538)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\627E\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283634699296872069)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\4ECE\5E03\5C40')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283634135079872069)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\663E\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283634491023872069)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\4E3B\8BB0\5F55\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283634056279872069)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284045765552872378)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5927\5217\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284041291593872375)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\9875\884C\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283919028512872285)
,p_name=>'CONFIRM.MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283849120586872232)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\94FE\63A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283852788239872234)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\6839')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283848943682872231)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283849243530872232)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283766875074872169)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\5C06 Flash \56FE\8868\5347\7EA7\5230\65B0 Flash 6 \56FE\8868\3002\8BF7\786E\8BA4\60A8\7684\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284130882115872440)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6_XML'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\5C06\4E00\4E2A\57FA\4E8E\5B9A\5236 XML \7684 Flash \56FE\8868\5347\7EA7\5230\65B0 Flash 6 \56FE\8868\3002\7531\4E8E\5F53\524D Flash \56FE\8868\4E0E Flash 6 \56FE\8868\4E4B\95F4\5728 XML \7ED3\6784\4E0A\5B58\5728\5DEE\5F02, \56E0\6B64\4E0D\4F1A\663E\793A\5347\7EA7\7684\56FE\8868\3002\60A8\9700\8981\4FEE\6539\6240\5347\7EA7\56FE\8868\7684\5B9A\5236 XML \624D\80FD\4F7F\7528\65B0\7684 XML \7ED3\6784\3002\8BF7\786E\8BA4\60A8\7684\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283705142275872122)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\5C06 Flash \56FE\8868\5347\7EA7\5230\65B0 HTML5 \56FE\8868\3002\8BF7\786E\8BA4\60A8\7684\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283705263183872122)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5_XML'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\5C06\4E00\4E2A\57FA\4E8E\5B9A\5236 XML \7684 Flash \56FE\8868\5347\7EA7\5230\65B0 HTML5 \56FE\8868\3002\7531\4E8E\5F53\524D Flash \56FE\8868\4E0E HTML5 \56FE\8868\4E4B\95F4\5728 XML \7ED3\6784\4E0A\5B58\5728\5DEE\5F02, \56E0\6B64\4E0D\4F1A\663E\793A\5347\7EA7\7684\56FE\8868\3002\60A8\9700\8981\4FEE\6539\6240\5347\7EA7\56FE\8868\7684\5B9A\5236 XML \624D\80FD\4F7F\7528\65B0\7684 XML \7ED3\6784\3002\8BF7\786E\8BA4\60A8\7684\8BF7\6C42\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283705058439872122)
,p_name=>'CONFIRM.MIGRATE_HTML_TO_HTML5'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\5C06 HTML \56FE\8868\5347\7EA7\5230\65B0 HTML5 \56FE\8868\3002\8BF7\786E\8BA4\60A8\7684\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284947982892873031)
,p_name=>'CONFIRM.MIGRATE_JSTREE_TO_APEXTREE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\5C06 jsTree \5347\7EA7\5230\65B0\6811\3002\8BF7\786E\8BA4\60A8\7684\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283832914879872219)
,p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5C06\6839\636E\4EE5\4E0B\9650\5236\5347\7EA7 SVG \56FE\8868:  '),
'<ul>',
'<li>',
unistr('\53EA\8FC1\79FB\5728\8F74\683C\5F0F\5B57\7B26\4E32\4E2D\5B9A\4E49\7684\6570\5B57\683C\5F0F\3002\5FFD\7565\65E5\671F\548C\65F6\95F4\683C\5F0F\3002'),
'</li>',
'<li>',
unistr('\5C06\8FC1\79FB\5305\542B\4EE5\4E0B\5185\5BB9\7684\6570\5B57\683C\5F0F\5143\7D20:'),
'<br />',
unistr('0,9,D,G,, (\9017\53F7),. (\53E5\70B9),$,C,L,FM'),
'</li>',
'<li>',
unistr('Flash \56FE\8868\4E2D\6BCF\4E2A\7CFB\5217\7684\6807\7B7E\6D3E\751F\81EA\6BCF\4E2A\7CFB\5217\7684\5217\522B\540D\3002'),
unistr('\8FD9\4E0E SVG \56FE\8868\4E0D\540C, SVG \56FE\8868\4E2D\6BCF\4E2A\7CFB\5217\7684\6807\7B7E\6D3E\751F\81EA\7CFB\5217\540D\79F0\5C5E\6027\3002'),
'</li>',
'<li>',
unistr('Flash \4EEA\8868\76D8\56FE\8868\663E\793A\5B9E\9645\503C\800C\4E0D\662F\767E\5206\6BD4\3002'),
'</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283788083326872185)
,p_name=>'CONFIRM.MIGRATE_SVG_TO_HTML5'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5DF2\8BF7\6C42\5C06 SVG \56FE\8868\5347\7EA7\5230 HTML5 \56FE\8868\3002\8BF7\786E\8BA4\60A8\7684\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284923208598873013)
,p_name=>'CONFIRM.NAVIGATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283855596725872236)
,p_name=>'CONFIRM.NAV_BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\680F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284573493999872758)
,p_name=>'CONFIRM.NAV_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\83DC\5355\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284148782392872453)
,p_name=>'CONFIRM.NEW_ADMIN_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\6DFB\52A0\65B0\7BA1\7406\9875\FF0C\9875\FF1A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283946455544872306)
,p_name=>'CONFIRM.NEW_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B0\5EFA\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283844387935872228)
,p_name=>'CONFIRM.NEW_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B0\5EFA\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284321230170872579)
,p_name=>'CONFIRM.NEXT_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\4E0B\4E00\6B65\201D\6309\94AE\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283842872659872227)
,p_name=>'CONFIRM.NO.TABSET.SELECTED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\4E3A\6B64\9875\9009\62E9\9009\9879\5361\96C6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283843431798872227)
,p_name=>'CONFIRM.NO_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283692638018872113)
,p_name=>'CONFIRM.OUTPUT_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\51FA\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283844767155872228)
,p_name=>'CONFIRM.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283841736223872226)
,p_name=>'CONFIRM.PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283855331180872236)
,p_name=>'CONFIRM.PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283841853926872226)
,p_name=>'CONFIRM.PAGE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283842761172872227)
,p_name=>'CONFIRM.PAGE_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283851281262872233)
,p_name=>'CONFIRM.PARENT_DISPLAY_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7236\663E\793A\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283849339913872232)
,p_name=>'CONFIRM.PARENT_MENU'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7236\9762\5305\5C51')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283852869623872234)
,p_name=>'CONFIRM.PARENT_MENU_COL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7236\9762\5305\5C51\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283851419263872233)
,p_name=>'CONFIRM.PARENT_ORDER_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7236\8868\6392\5E8F\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283850799526872233)
,p_name=>'CONFIRM.PARENT_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7236\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283851065617872233)
,p_name=>'CONFIRM.PARENT_TABLE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7236\8868\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283843348585872227)
,p_name=>'CONFIRM.PARENT_TAB_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7236\9009\9879\5361\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283843208231872227)
,p_name=>'CONFIRM.PARENT_TAB_SET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7236\9009\9879\5361\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283946152674872306)
,p_name=>'CONFIRM.PARSING_SCHEMA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\65B9\6848\8FDB\884C\8BED\6CD5\5206\6790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283955105353872312)
,p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\90E8\5206\9875\5237\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284321398586872579)
,p_name=>'CONFIRM.PREVIOUS_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\4E0A\4E00\6B65\201D\6309\94AE\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283842671247872227)
,p_name=>'CONFIRM.PRIMARY_KEY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\952E\5217%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283850328030872232)
,p_name=>'CONFIRM.PRIMARY_KEY_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\952E\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284041530005872375)
,p_name=>'CONFIRM.PRINT_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\51FA\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284045982179872378)
,p_name=>'CONFIRM.PRINT_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6253\5370\94FE\63A5\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284041622769872375)
,p_name=>'CONFIRM.PRINT_OUTPUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\6253\5370')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283844657781872228)
,p_name=>'CONFIRM.PROCESS_OPTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284041315023872375)
,p_name=>'CONFIRM.REGION_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283843672473872227)
,p_name=>'CONFIRM.REGION_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283841928079872226)
,p_name=>'CONFIRM.REGION_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283848762653872231)
,p_name=>'CONFIRM.REGION_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283946375092872306)
,p_name=>'CONFIRM.REMOVED_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5220\9664\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283850450089872233)
,p_name=>'CONFIRM.REPORT_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284063792802872391)
,p_name=>'CONFIRM.REPORT_IMPLEMENTATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\5B9E\65BD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283849537147872232)
,p_name=>'CONFIRM.REPORT_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283849672756872232)
,p_name=>'CONFIRM.REPORT_PAGE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\9875\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283849864236872232)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\9875\9009\9879\5361\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283849783453872232)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_SET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\9875\9009\9879\5361\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283736722528872146)
,p_name=>'CONFIRM.REPORT_REGION_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\533A\57DF\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283736662139872146)
,p_name=>'CONFIRM.REPORT_REGION_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\533A\57DF\6807\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283853774165872235)
,p_name=>'CONFIRM.REPORT_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283739233882872148)
,p_name=>'CONFIRM.ROW_VERSION_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C\7248\672C\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283853952419872235)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME1'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\503C: HTML (\6807\51C6)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283854281306872235)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME11'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\503C: \5916\89C2 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283854395364872236)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME12'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\503C: \5916\89C2 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283945950908872305)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME13'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\503C: \5916\89C2 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283946091008872305)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME14'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\503C: \5916\89C2 4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283737289142872147)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME15'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\503C: \5916\89C2 5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283854032756872235)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4: \5782\76F4\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283854498663872236)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME21'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\51FA: CSV')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283854569719872236)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME22'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\51FA: XML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283854128031872235)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME3'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4: \5782\76F4\62A5\8868, \5916\89C2 1 (\5305\542B\7A7A\5217)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283945768916872305)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME4'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4: \5782\76F4\62A5\8868, \5916\89C2 2 (\4E0D\542B\7A7A\5217)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283945824522872305)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME5'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4: \5782\76F4\62A5\8868, \5916\89C2 2 (\5305\542B\7A7A\5217)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284264677536872538)
,p_name=>'CONFIRM.RULE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\89C4\5219\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284264847782872538)
,p_name=>'CONFIRM.RULE_SEQUENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E8F\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284264973463872538)
,p_name=>'CONFIRM.RULE_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\89C4\5219\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283666470846872093)
,p_name=>'CONFIRM.RUN_SCRIPT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\8BF7\6C42\8FD0\884C\4EE5\4E0B\811A\672C\3002\8BF7\786E\8BA4\8BF7\6C42\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283849057705872232)
,p_name=>'CONFIRM.SEQUENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E8F\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283853845760872235)
,p_name=>'CONFIRM.SORT_OPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6392\5E8F\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283844971218872228)
,p_name=>'CONFIRM.SQL_QUERY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL \67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283955000884872312)
,p_name=>'CONFIRM.STANDARD_CALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\51C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284083256235872405)
,p_name=>'CONFIRM.STARTING_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\521B\5EFA\591A\9875\FF0C\4ECE\4EE5\4E0B\9875\5F00\59CB\FF1A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283844826465872228)
,p_name=>'CONFIRM.STORED_PROCEDURE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B58\50A8\8FC7\7A0B\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283947752339872307)
,p_name=>'CONFIRM.STORED_PROCEDURE_OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B58\50A8\8FC7\7A0B\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284321585079872579)
,p_name=>'CONFIRM.SUBMIT_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\5B8C\6210\201D\6309\94AE\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284938795656873024)
,p_name=>'CONFIRM.SUBSCRIBE_THEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA2\9605\4E3B\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283844150910872228)
,p_name=>'CONFIRM.SUGGESTED_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5EFA\8BAE\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284129743292872439)
,p_name=>'CONFIRM.TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868/\89C6\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284129828842872439)
,p_name=>'CONFIRM.TABLE_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\5217\6C47\603B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284348752276872599)
,p_name=>'CONFIRM.TABLE_LOOKUPS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\67E5\627E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283842343239872226)
,p_name=>'CONFIRM.TABLE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283842294452872226)
,p_name=>'CONFIRM.TABLE_OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284520800539872722)
,p_name=>'CONFIRM.TABLE_RULE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F6C\6362\89C4\5219')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284265004004872538)
,p_name=>'CONFIRM.TABLE_RULES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F6C\6362\89C4\5219')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283946612815872306)
,p_name=>'CONFIRM.TABLE_VIEW_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868/\89C6\56FE\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283946526303872306)
,p_name=>'CONFIRM.TABLE_VIEW_OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868/\89C6\56FE\6240\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283855499723872236)
,p_name=>'CONFIRM.TABS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\9879\5361')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283843183739872227)
,p_name=>'CONFIRM.TABSET.INCOMPLETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8B66\544A, \9009\9879\5361\96C6\4FE1\606F\4E0D\5B8C\6574\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283842110686872226)
,p_name=>'CONFIRM.TAB_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\9879\5361\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283853542644872235)
,p_name=>'CONFIRM.TAB_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\9879\5361\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283842029781872226)
,p_name=>'CONFIRM.TAB_SET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\9879\5361\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283854696562872236)
,p_name=>'CONFIRM.TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\677F:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283848375761872231)
,p_name=>'CONFIRM.TREE_LOV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\57FA\4E8E\5E26\6709\5F39\51FA\5F0F\503C\5217\8868\7684\65B0\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283848004434872231)
,p_name=>'CONFIRM.TREE_MAX_LEVEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6700\5927\7EA7\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283847899024872231)
,p_name=>'CONFIRM.TREE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6811\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283848274300872231)
,p_name=>'CONFIRM.TREE_QUERY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6811\67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283848467876872231)
,p_name=>'CONFIRM.TREE_SQL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\57FA\4E8E SQL \67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283848175373872231)
,p_name=>'CONFIRM.TREE_START'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\59CB\6811')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283848569599872231)
,p_name=>'CONFIRM.TREE_STATIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9759\6001\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283847902312872231)
,p_name=>'CONFIRM.TREE_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6811\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283855606022872237)
,p_name=>'CONFIRM.UI_THEME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283855706074872237)
,p_name=>'CONFIRM.UI_THEME1'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\84DD\8272\548C\68D5\8910\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283855865947872237)
,p_name=>'CONFIRM.UI_THEME2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EA2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283855973312872237)
,p_name=>'CONFIRM.UI_THEME4'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D77\519B\84DD\548C\7070\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283856009354872237)
,p_name=>'CONFIRM.UI_THEME5'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A44\6984\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283856103342872237)
,p_name=>'CONFIRM.UI_THEME6'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6817\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283856234667872237)
,p_name=>'CONFIRM.UI_THEME7'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EAF\84DD\8272\548C\68D5\8910\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283856304659872237)
,p_name=>'CONFIRM.UI_THEME8'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\84DD\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283856437689872237)
,p_name=>'CONFIRM.UI_THEME_NONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283842581976872226)
,p_name=>'CONFIRM.UPDATEABLE_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\66F4\65B0\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283846327585872229)
,p_name=>'CONFIRM.UPDATE_PROCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283843066416872227)
,p_name=>'CONFIRM.USE.EXISTING.TABSET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\9875\5C06\4F7F\7528\73B0\6709\9009\9879\5361\96C6 "%0"\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283692478129872113)
,p_name=>'CONFIRM.WEB_SERVICE_REF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \670D\52A1\5F15\7528, \64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283850505768872233)
,p_name=>'CONFIRM.WHERE_CLAUSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Where \5B50\53E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284119152075872432)
,p_name=>'CONFIRMATION_ICON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\786E\8BA4\201D\56FE\6807')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284131247709872441)
,p_name=>'CONFIRMED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\786E\8BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284131535121872441)
,p_name=>'CONFIRMED_BY_QA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7531 QA \786E\8BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284041813593872375)
,p_name=>'CONFIRM_BREAK_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\9694\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284041748088872375)
,p_name=>'CONFIRM_PRINT_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6253\5370\683C\5F0F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284160084005872461)
,p_name=>'CONTENT_DISPOSITION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5185\5BB9\5904\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284195222473872487)
,p_name=>'CONTENT_SERVED_IN_KBYTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5904\7406\5185\5BB9')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284032785608872369)
,p_name=>'CONTINUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EE7\7EED')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285072321953873123)
,p_name=>'CONTRIBUTORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D21\732E\8005')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284964962668873043)
,p_name=>'COPY.PAGE.NEW_STATIC_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B0\5EFA\9759\6001 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283729102056872140)
,p_name=>'COPYRIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7248\6743\6240\6709 (c) %0, \4FDD\7559\6240\6709\6743\5229\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283787528584872184)
,p_name=>'COPY_APP_SUCCESS_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\590D\5236\60A8\7684\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283923155319872288)
,p_name=>'COPY_BUTTON.EXECUTION_ERR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6267\884C copy_button %0 >> %1 \65F6\51FA\9519')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283962018818872317)
,p_name=>'COPY_DEPLOYMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\5BF9\8C61\5B9A\4E49\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283760871503872164)
,p_name=>'COPY_EXISTING_APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284219177048872505)
,p_name=>'COPY_FEATURE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\529F\80FD: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283961632562872317)
,p_name=>'COPY_FROM_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\81EA\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284395810266872634)
,p_name=>'COPY_FROM_APP_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\57FA\4E8E\6A21\677F\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283961753249872317)
,p_name=>'COPY_FROM_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\81EA\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283789723417872186)
,p_name=>'COPY_LIST_ENTRY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\5217\8868\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283923557015872288)
,p_name=>'COPY_NAMED_LOV.EXECUTION_ERR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6267\884C copy_named_lov %0 \65F6\51FA\9519')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283923491877872288)
,p_name=>'COPY_NAMED_LOV.NOT_FOUND_ERR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\503C\5217\8868 ID "%0"\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283923320380872288)
,p_name=>'COPY_NAMED_LOV.NUMERIC_ERR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\5217\8868 ID "%0" \4E0D\662F\6570\5B57\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284200129926872491)
,p_name=>'COPY_PAGE.COPY_FROM_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\81EA\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284200215100872491)
,p_name=>'COPY_PAGE.COPY_TO_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\5230\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284199110319872490)
,p_name=>'COPY_PAGE.SELECT_AUTHORIZATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9\6388\6743 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284199079989872490)
,p_name=>'COPY_PAGE.SELECT_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9\5217\8868 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284198909329872490)
,p_name=>'COPY_PAGE.SELECT_NAMED_LOV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('- \9009\62E9\503C\5217\8868 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284271059869872543)
,p_name=>'COPY_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06 %0 \590D\5236\5230\8868 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283961873740872317)
,p_name=>'COPY_TO_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\5230\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283961968980872317)
,p_name=>'COPY_TO_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\5230\540D\79F0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283887374570872261)
,p_name=>'CORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6838\5FC3')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284054218024872384)
,p_name=>'COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\6570')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284112026196872427)
,p_name=>'CREATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284358282279872606)
,p_name=>'CREATE APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284358308982872606)
,p_name=>'CREATE OBJECT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5BF9\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284567999865872755)
,p_name=>'CREATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\65F6\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284568083033872755)
,p_name=>'CREATED_BY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284218892859872504)
,p_name=>'CREATED_LAST_7_DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\53BB 7 \5929\5185\521B\5EFA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283924201147872289)
,p_name=>'CREATED_ON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\65F6\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283760907355872164)
,p_name=>'CREATE_APP_FROM_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81EA\5E94\7528\7A0B\5E8F\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284862157777872967)
,p_name=>'CREATE_APP_WIZ.CANDLE_CHARTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('K \7EBF\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284861918691872967)
,p_name=>'CREATE_APP_WIZ.COL_CHARTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2D \548C 3D \67F1\72B6\56FE, \6761\5F62\56FE\548C\5806\53E0\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284862618315872968)
,p_name=>'CREATE_APP_WIZ.GAUGE_CHARTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EEA\8868\76D8\548C\4EEA\8868\76D8 (\767E\5206\6BD4) \56FE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284862090854872967)
,p_name=>'CREATE_APP_WIZ.PIE_CHARTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2D \548C 3D \997C\56FE\548C\5706\73AF\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284862389438872968)
,p_name=>'CREATE_APP_WIZ.PROJECTGANTT_CHARTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879\76EE\7518\7279\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284862570147872968)
,p_name=>'CREATE_APP_WIZ.RANGE_CHARTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('2D \548C 3D \8303\56F4\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284862406660872968)
,p_name=>'CREATE_APP_WIZ.RESOURCEGANTT_CHARTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D44\6E90\7518\7279\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284862224923872968)
,p_name=>'CREATE_APP_WIZ.SCATTER_CHARTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6563\70B9\6807\8BB0\56FE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283879268270872255)
,p_name=>'CREATE_CONDITION.AND'
,p_message_language=>'zh-cn'
,p_message_text=>'AND'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283879077193872254)
,p_name=>'CREATE_CONDITION.ARROW_DOWN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\7BAD\5934')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283879103408872255)
,p_name=>'CREATE_CONDITION.ARROW_RIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53F3\7BAD\5934')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283878819774872254)
,p_name=>'CREATE_CONDITION.COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283878986325872254)
,p_name=>'CREATE_CONDITION.CONDITIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283879390920872255)
,p_name=>'CREATE_CONDITION.OR'
,p_message_language=>'zh-cn'
,p_message_text=>'OR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283879488227872255)
,p_name=>'CREATE_CONDITION.PREVIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9884\89C8\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284219611255872505)
,p_name=>'CREATE_DEMO_APP.GRANT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\51FB\4E0B\9762\7684\201C\6388\4E88\6743\9650\201D\6309\94AE\53EF\5C06\8FD9\4E9B\6743\9650\7ACB\5373\6388\4E88 %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284219401120872505)
,p_name=>'CREATE_DEMO_APP.NO_CREATE_PRIV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \6CA1\6709 CREATE TABLE, CREATE VIEW, CREATE TRIGGER, CREATE SEQUENCE \6216 CREATE PROCEDURE \6743\9650, \65E0\6CD5\5B89\88C5\6F14\793A\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284219532144872505)
,p_name=>'CREATE_DEMO_APP.NO_EXEC_PRIV'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('%0 \6CA1\6709\5BF9 CTX_DOC \548C CTX_DDL \7684\6267\884C\6743\9650, \65E0\6CD5\5B89\88C5\201C\603B\7EDF\5C31\804C\6F14\8BF4\201D\6F14\793A\3002 \8BF7\4EE5\7279\6743\7528\6237\8EAB\4EFD\6267\884C\4EE5\4E0B\6388\6743: '),
'<pre>',
'GRANT EXECUTE ON CTXSYS.CTX_DDL TO %0; ',
'GRANT EXECUTE ON CTXSYS.CTX_DOC TO %0;',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284566095374872753)
,p_name=>'CREATE_DIALOG_CLOSED_DA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\6309\94AE - \5BF9\8BDD\6846\5DF2\5173\95ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283663382331872091)
,p_name=>'CREATE_DYNAMIC_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\52A8\6001\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283947479361872306)
,p_name=>'CREATE_DYNAMIC_LOV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\52A8\6001\503C\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283641334174872074)
,p_name=>'CREATE_FLOW.CLOUD_IDM'
,p_message_language=>'zh-cn'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283680801401872104)
,p_name=>'CREATE_FLOW.DBACCOUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\5E10\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284384487430872625)
,p_name=>'CREATE_FLOW.HTMLDB_AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Application Express \9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284220098444872505)
,p_name=>'CREATE_FLOW.LDAP'
,p_message_language=>'zh-cn'
,p_message_text=>'LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284923345532873013)
,p_name=>'CREATE_FLOW.NAVIGATION_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\83DC\5355\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284384586951872626)
,p_name=>'CREATE_FLOW.NO_AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284384178830872625)
,p_name=>'CREATE_FLOW.NO_TABS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\9009\9879\5361')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284384288105872625)
,p_name=>'CREATE_FLOW.ONE_LEVEL_TABS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E00\5C42\9009\9879\5361')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284220195169872505)
,p_name=>'CREATE_FLOW.SSO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E00\6B21\767B\5165 (SSO)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284384316030872625)
,p_name=>'CREATE_FLOW.TWO_LEVEL_TABS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E24\5C42\9009\9879\5361')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283760717772872164)
,p_name=>'CREATE_FROM_SPREADSHEET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4ECE\7535\5B50\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283637787836872072)
,p_name=>'CREATE_GLOBAL_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\6240\9009\9875\6A21\677F\4E2D\5305\542B\5168\5C40\9875\7EC4\4EF6\533A\57DF\7684\663E\793A\70B9, \5219\6240\6709\9875\4E0A\90FD\5C06\663E\793A\8FD9\4E9B\7EC4\4EF6\3002\53EF\4EE5\4F7F\7528\201C\6709\6761\4EF6\663E\793A\201D\5C5E\6027\6765\9690\85CF\663E\793A\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283912456242872280)
,p_name=>'CREATE_INDEX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\7D22\5F15')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284068016453872394)
,p_name=>'CREATE_ITEM_WIZ.NO_REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\76F8\5173\8054\7684\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283887056969872261)
,p_name=>'CREATE_NEW_LOGIN_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\65B0\7684\767B\5F55\9875\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283880966226872256)
,p_name=>'CREATE_PACKAGE.BACK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD4\56DE\521B\5EFA\8868\5411\5BFC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283880466741872256)
,p_name=>'CREATE_PACKAGE.BROWSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D4F\89C8\5305')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283880398148872256)
,p_name=>'CREATE_PACKAGE.CREATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728 "%1" \65B9\6848\4E2D\5DF2\521B\5EFA\5305 "%0"\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283881029169872256)
,p_name=>'CREATE_PACKAGE.FAILED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\8868 "%0" \5931\8D25\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283880803957872256)
,p_name=>'CREATE_PACKAGE.HOME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283880657929872256)
,p_name=>'CREATE_PACKAGE.RETURN_TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD4\56DE\5230')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283880764073872256)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL&nbsp;\5DE5\4F5C\5BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283880537016872256)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL \5DE5\4F5C\5BA4\4E3B\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283876291922872252)
,p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\627E\5230\4EFB\4F55\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283875833184872252)
,p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283876136087872252)
,p_name=>'CREATE_PAGE_ITEM.PROMPT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283875971225872252)
,p_name=>'CREATE_PAGE_ITEM.REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283876053373872252)
,p_name=>'CREATE_PAGE_ITEM.SET_REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5355\51FB\53EF\8BBE\7F6E\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283873917226872251)
,p_name=>'CREATE_PROCESS.PAGE_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283874058336872251)
,p_name=>'CREATE_PROCESS.REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283880294560872255)
,p_name=>'CREATE_TABLE.HOME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283880091180872255)
,p_name=>'CREATE_TABLE.RETURN_TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD4\56DE\5230')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283879922103872255)
,p_name=>'CREATE_TABLE.RUN_SCRIPT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD0\884C\811A\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283879692276872255)
,p_name=>'CREATE_TABLE.SCRIPT_CREATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\7ECF\5728 SQL \811A\672C\8D44\6599\6863\6848\5E93\4E2D\521B\5EFA\4E86\8868 %0 \7684\521B\5EFA\8868\811A\672C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283879758329872255)
,p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F6C\5230\811A\672C\8D44\6599\6863\6848\5E93')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283880111306872255)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL&nbsp;\5DE5\4F5C\5BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283879833167872255)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('SQL \5DE5\4F5C\5BA4\4E3B\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284337026430872591)
,p_name=>'CREATE_TABULAR_FORM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868\683C\5F0F\8868\5355')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284942632889873027)
,p_name=>'CREATE_TO_DO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5F85\529E\4E8B\9879')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284271887072872543)
,p_name=>'CREATE_TRIGGER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\89E6\53D1\5668 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284210034366872498)
,p_name=>'CREATE_WS_OBJ_SUCCESS_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Websheet \6570\636E\5E93\5BF9\8C61\5DF2\521B\5EFA\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284162241230872463)
,p_name=>'CREDENTIAL.OWNER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8EAB\4EFD\8BC1\660E\6240\6709\8005')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284124644606872436)
,p_name=>'CSS_CALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\5386')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284037511632872372)
,p_name=>'CURRENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284116413621872430)
,p_name=>'CURRENT ENTRY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284116108909872430)
,p_name=>'CURRENT FORM ELEMENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\8868\5355\5143\7D20')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283900356366872271)
,p_name=>'CURRENT ITEM HELP TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\9879\5E2E\52A9\6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284116265902872430)
,p_name=>'CURRENT ITEM IDENTIFICATION NUMBER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\9879\6807\8BC6\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284116309877872430)
,p_name=>'CURRENT ITEM LABEL NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\9879\6807\7B7E\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284175372439872472)
,p_name=>'CURRENT TAB'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\9009\9879\5361')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283862107016872241)
,p_name=>'CURRENT_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283869134095872247)
,p_name=>'CURRENT_IMAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\6620\50CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284475876181872692)
,p_name=>'CURRENT_ITEM_CONTAINER_ID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\7528\4E8E\4E00\4E2A\5C06\5F53\524D\5B57\6BB5\5305\88C5\5230\201C\6807\7B7E\548C\9879\4E4B\524D\201D\5C5E\6027\4E2D\7684\5BB9\5668\5143\7D20\7684 ID\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284951140852873033)
,p_name=>'CURRENT_ITEM_HELP_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\9879\5E2E\52A9\6807\7B7E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283827959194872215)
,p_name=>'CURRENT_MILESTONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283868281302872246)
,p_name=>'CURRENT_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284142971720872449)
,p_name=>'CURRENT_PAGE_CONTAINS_NO_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F53\524D\9875\4E0D\5305\542B\4EFB\4F55\9879\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284033347013872369)
,p_name=>'CUSTOM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284076063206872400)
,p_name=>'CUSTOMIZE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284111944457872426)
,p_name=>'CUSTOMIZE LINK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\5236\94FE\63A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284121532018872433)
,p_name=>'CUSTOMIZE.USER_PAGE_PREFS_RESET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\7528\6237 %0 \91CD\7F6E\9875\9996\9009\9879\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284121618940872434)
,p_name=>'CUSTOMIZE.USER_PREFS_CHANGED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237 %0 \7684\9996\9009\9879\5DF2\66F4\6539\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284121461518872433)
,p_name=>'CUSTOMIZE.USER_PREFS_RESET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\7528\6237 %0 \91CD\7F6E\9875\9996\9009\9879\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284825868189872941)
,p_name=>'CUSTOM_APPLICATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\5236\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283662240391872090)
,p_name=>'CUSTOM_AUTH_SCHEME_DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\8005\5DF2\5B9A\4E49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283916689160872283)
,p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('%0 \4E2D\51FA\73B0\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283828130500872215)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\5165\4EFB\4F55\5B57\7B26\4E32\4EE5\7528\4F5C\6B64\4F1A\8BDD\7684\7528\6237\6807\8BC6\7B26\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283828294621872215)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\5165\60A8\7684 %0 \7528\6237\540D\548C\5BC6\7801\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283828302531872216)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\5165\7528\6237\540D\548C\5BC6\7801\4EE5\4F9B LDAP \4E3B\673A\9A8C\8BC1: %0\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283828459430872216)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F93\5165\6570\636E\5E93\65B9\6848\7528\6237\540D\548C\5BC6\7801\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284594910991872773)
,p_name=>'CUSTOM_CALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\65B0\52A0\8F7D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284600038806872777)
,p_name=>'CUSTOM_CALENDAR.END_DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED3\675F\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284599929101872777)
,p_name=>'CUSTOM_CALENDAR.START_DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\59CB\65E5\671F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284272766018872544)
,p_name=>'DA.SET_VALUE.SQL.HELP_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\771F\64CD\4F5C\4E3A\4F7F\7528\8BBE\7F6E\7C7B\578B\7684 SQL \8BED\53E5\8BBE\7F6E\503C\65F6, \9700\8981\6309 SQL \8BED\53E5\7684\5217\987A\5E8F\5B9A\4E49\53D7\5F71\54CD\7684\5143\7D20\3002\60A8\5B9A\4E49\7684 SQL \8BED\53E5\4E3A:</p>'),
'<pre>%0</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283833528217872220)
,p_name=>'DAILY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284050736629872382)
,p_name=>'DATA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284357876839872606)
,p_name=>'DATA WORKSHOP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5DE5\4F5C\5BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283928278868872292)
,p_name=>'DATA.LOAD.ALL_COL_MAPPED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709 %0 \5217\5747\5DF2\81EA\52A8\6620\5C04\5230 %1 \8868\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283929074034872292)
,p_name=>'DATA.LOAD.APPEND_INCOMPLETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868 <code>%0</code> \4E2D\7684\6570\636E\5DF2\9644\52A0 <b id="incompl_success_row_count"></b> \4E2A\65B0\884C\3002\5DF2\62D2\7EDD <b class="u-danger-text" id="incompl_fail_row_count"></b> \884C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283928650830872292)
,p_name=>'DATA.LOAD.APPEND_SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868 <code>%0</code> \4E2D\7684\6570\636E\5DF2\9644\52A0 <b id="success_row_count"></b> \4E2A\65B0\884C\FF01')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283928879691872292)
,p_name=>'DATA.LOAD.APPEND_WARNING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868 <code>%0</code> \4E2D\7684\6570\636E\5DF2\9644\52A0 <b id="err_success_row_count"></b> \4E2A\65B0\884C\3002\5DF2\62D2\7EDD <b class="u-danger-text" id="err_fail_row_count"></b> \884C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283638270204872072)
,p_name=>'DATA.LOAD.CHOOSE_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\6587\4EF6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283675827962872100)
,p_name=>'DATA.LOAD.CONFIGURATION_SAVED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\914D\7F6E\5DF2\4FDD\5B58\FF01')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283928351112872292)
,p_name=>'DATA.LOAD.DEFINE_COL_MAPPING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\5B9A\4E49\5217\6620\5C04\FF0C\4EE5\4FBF\5C06\6B64\6570\636E\6620\5C04\5230 %0 \8868\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283638140684872072)
,p_name=>'DATA.LOAD.DRAG_DROP_FILE_HERE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C06\6587\4EF6\62D6\653E\5728\6B64\5904\6216\8005')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283638010677872072)
,p_name=>'DATA.LOAD.FILE_FORMATS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\652F\6301\7684\683C\5F0F csv\3001xlsx\3001txt\3001xml\3001json')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283639136993872073)
,p_name=>'DATA.LOAD.INVALID_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\8F7D\7684\6587\4EF6\65E0\6548\6216\5177\6709\9519\8BEF\7684\6269\5C55\540D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283807440793872200)
,p_name=>'DATA.LOAD.INVALID_SELECTOR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\7684 XML \6216 JSON \9009\62E9\5668\65E0\6548\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284355717270872605)
,p_name=>'DATA.LOAD.JOB_INTERMITTENTLY_FAILED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\4F5C\4E1A\6267\884C\5DF2\610F\5916\505C\6B62\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284279920339872549)
,p_name=>'DATA.LOAD.JOB_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE5\4F5C\533A %0 \4E2D\7684\6570\636E\52A0\8F7D\4F5C\4E1A\FF1A\52A0\8F7D\5230\8868 %1 \4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283928416854872292)
,p_name=>'DATA.LOAD.MAP_REMAINING_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6709 %0 \5217\FF08\5171 %1 \5217\FF09\81EA\52A8\6620\5C04\5230 %2 \8868\3002\8BF7\914D\7F6E\5269\4F59\7684 %3 \5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284273556579872544)
,p_name=>'DATA.LOAD.NO_FILE_CONTENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\4E0A\8F7D\7684\6587\4EF6\4E2D\627E\4E0D\5230\6570\636E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284273693027872544)
,p_name=>'DATA.LOAD.NO_WORKSHEET_CONTENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\5DE5\4F5C\8868 "%0" \4E2D\627E\4E0D\5230\6570\636E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283638575362872072)
,p_name=>'DATA.LOAD.NO_XLSX_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6307\5B9A\7684\6587\4EF6\4E0D\662F XLSX \6587\4EF6\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284320359433872579)
,p_name=>'DATA.LOAD.PASTED_DATA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7C98\8D34\7684\6570\636E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283929158310872292)
,p_name=>'DATA.LOAD.REPLACE_INCOMPLETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868 <code>%0</code> \4E2D\7684\6570\636E\5DF2\66FF\6362 <b id="incompl_success_row_count"></b> \4E2A\65B0\884C\3002\5DF2\62D2\7EDD <b class="u-danger-text" id="incompl_fail_row_count"></b> \884C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283928793255872292)
,p_name=>'DATA.LOAD.REPLACE_SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868 <code>%0</code> \4E2D\7684\6570\636E\5DF2\66FF\6362 <b id="success_row_count"></b> \4E2A\65B0\884C\FF01')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283928970372872292)
,p_name=>'DATA.LOAD.REPLACE_WARNING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868 <code>%0</code> \4E2D\7684\6570\636E\5DF2\66FF\6362 <b id="err_success_row_count"></b> \4E2A\65B0\884C\3002\5DF2\62D2\7EDD <b class="u-danger-text" id="err_fail_row_count"></b> \884C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283928569378872292)
,p_name=>'DATA.LOAD.SELECT_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BF7\9009\62E9\8981\52A0\8F7D\7684\5217\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284935456718873022)
,p_name=>'DATABASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284358435679872607)
,p_name=>'DATABASE BROWSER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\6D4F\89C8\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284874026060872976)
,p_name=>'DATABASE.DEMO.SAMPLE.APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\793A\4F8B\6570\636E\5E93\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284935542625873022)
,p_name=>'DATABASE_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283682595917872105)
,p_name=>'DATABASE_APPLICATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283710326974872126)
,p_name=>'DATABASE_APPS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284204952418872494)
,p_name=>'DATABASE_APP_SUCCESS_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F <strong>%0</strong> \5DF2\6210\529F\5B89\88C5\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284101870578872419)
,p_name=>'DATABASE_LINK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\94FE\63A5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284154627412872458)
,p_name=>'DATABASE_OBJECT_COUNTS_BY_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\5BF9\8C61\7C7B\578B\7EDF\8BA1\7684\6570\636E\5E93\5BF9\8C61\8BA1\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284157826652872460)
,p_name=>'DATABASE_ROLE_PRIVILEGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\89D2\8272\6743\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283704883124872122)
,p_name=>'DATABASE_USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284265501381872539)
,p_name=>'DATA_GRID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\7F51\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284864654650872969)
,p_name=>'DATA_GRIDS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\7F51\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284865100902872970)
,p_name=>'DATA_GRID_DATA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\7F51\683C\6570\636E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284855138022872962)
,p_name=>'DATA_LOAD.ADVANCED_SETTINGS_REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\9AD8\7EA7\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283791772679872188)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\4F7F\7528\7684\65E5\671F/\6570\5B57\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283791891514872188)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\62E9\662F\63D0\4F9B\5B9A\5236\683C\5F0F\63A9\7801\8FD8\662F\4F7F\7528\6807\51C6\683C\5F0F\63A9\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283706244165872123)
,p_name=>'DATA_LOAD.CHARSET'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\4EF6\5B57\7B26\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284346452768872598)
,p_name=>'DATA_LOAD.COLUMN_NAMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284344987402872597)
,p_name=>'DATA_LOAD.COLUMN_NAMES_MAPPING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\76EE\6807\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284203086486872493)
,p_name=>'DATA_LOAD.COLUMN_NAME_ALIASES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\540D\522B\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284559479068872749)
,p_name=>'DATA_LOAD.CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5DF2\6210\529F\4E0A\8F7D\5230\8868\4E2D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284566714784872754)
,p_name=>'DATA_LOAD.COPY_PASTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\5E76\7C98\8D34')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284553002069872744)
,p_name=>'DATA_LOAD.COPY_PASTE_TEXTAREA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236\5E76\7C98\8D34\5E26\5206\9694\7B26\7684\6570\636E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284895471178872992)
,p_name=>'DATA_LOAD.CURRENCY_ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8D27\5E01\7B26\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284895505370872992)
,p_name=>'DATA_LOAD.CURRENCY_ITEM_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\6570\636E\4E2D\5305\542B\56FD\9645\8D27\5E01\7B26\53F7, \8BF7\5728\6B64\5904\8F93\5165\3002\4F8B\5982, \5982\679C\6570\636E\4E2D\5305\542B "&euro;1,234.56" \6216 "&yen;1,234.56", \8BF7\8F93\5165 "&euro;" \6216 "&yen;"\3002\5426\5219, \5C06\65E0\6CD5\6B63\786E\52A0\8F7D\6570\636E\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283711295310872127)
,p_name=>'DATA_LOAD.DATA_LOADING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284855292546872962)
,p_name=>'DATA_LOAD.DATE_FORMAT_APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\5E94\7528\7A0B\5E8F\6807\51C6\683C\5F0F\63A9\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284855325621872963)
,p_name=>'DATA_LOAD.DATE_FORMAT_CUSTOM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\4E0A\8F7D\7684\5217\63D0\4F9B\5B9A\5236\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284897014410872993)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5C0F\6570\70B9\5B57\7B26\5C06\6570\5B57\7684\6574\6570\90E8\5206\548C\5C0F\6570\90E8\5206\5206\9694\5F00\6765\3002</p>'),
unistr('<p>\53EF\4EE5\4F7F\7528\4EFB\4F55\5B57\7B26\4F5C\4E3A\5C0F\6570\70B9\5B57\7B26\3002\6240\6307\5B9A\7684\5B57\7B26\5FC5\987B\4E3A\5355\5B57\8282\5B57\7B26, \5E76\4E14\5C0F\6570\70B9\5B57\7B26\4E0D\80FD\4E0E\7EC4\5206\9694\7B26\76F8\540C\3002\6B64\5B57\7B26\53EF\4EE5\4E3A\7A7A\683C, \4F46\4E0D\80FD\4E3A\6570\5B57\5B57\7B26\6216\4EE5\4E0B\5B57\7B26\4E4B\4E00:</p>'),
'<ul class="noIndent">',
unistr('<li>\52A0\53F7 (+)</li>'),
unistr('<li>\8FDE\5B57\53F7 (-)</li> '),
unistr('<li>\5C0F\4E8E\53F7 (<)</li>'),
unistr('<li>\5927\4E8E\53F7 (>)</li> '),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284896179894872993)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C0F\6570\70B9\7B26\53F7')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284203242853872493)
,p_name=>'DATA_LOAD.DISPLAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284346349650872598)
,p_name=>'DATA_LOAD.DO_NOT_LOAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\52A0\8F7D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284891054065872989)
,p_name=>'DATA_LOAD.FAILED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9884\5904\7406\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284803566247872925)
,p_name=>'DATA_LOAD.FAILED_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5931\8D25\884C:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284875007440872977)
,p_name=>'DATA_LOAD.FAILED_RECORD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5931\8D25\7684\8BB0\5F55')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284895026672872992)
,p_name=>'DATA_LOAD.FILE_NAME_ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\4E0A\8F7D\7684\6587\4EF6\7684\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284345207055872597)
,p_name=>'DATA_LOAD.FIRST_COLUMN_NAMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E90\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284563401012872752)
,p_name=>'DATA_LOAD.FIRST_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7B2C\4E00\884C\5177\6709\5217\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284895138464872992)
,p_name=>'DATA_LOAD.FIRST_ROW_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\6570\636E\7684\7B2C\4E00\884C\4E2D\5305\542B\5217\540D, \8BF7\9009\4E2D\6B64\6846\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284346591743872598)
,p_name=>'DATA_LOAD.FORMAT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\671F/\6570\5B57\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284895390775872992)
,p_name=>'DATA_LOAD.GLOBALIZATION_REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5168\7403\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284896087839872993)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7EC4\5206\9694\7B26\662F\5206\9694\6574\6570\7EC4\7684\5B57\7B26, \4F8B\5982, \7528\6765\8868\793A\5343\4F4D\548C\767E\4E07\4F4D\7684\5B57\7B26\3002</p>'),
unistr('<p>\53EF\4EE5\4F7F\7528\4EFB\4F55\5B57\7B26\4F5C\4E3A\7EC4\5206\9694\7B26\3002\6240\6307\5B9A\7684\5B57\7B26\5FC5\987B\4E3A\5355\5B57\8282\5B57\7B26, \5E76\4E14\7EC4\5206\9694\7B26\4E0D\80FD\4E0E\5C0F\6570\70B9\5B57\7B26\76F8\540C\3002\6B64\5B57\7B26\53EF\4EE5\4E3A\7A7A\683C, \4F46\4E0D\80FD\4E3A\6570\5B57\5B57\7B26\6216\4EE5\4E0B\5B57\7B26\4E4B\4E00:</p>'),
'<ul class="noIndent">',
unistr('<li>\52A0\53F7 (+)</li>'),
unistr('<li>\8FDE\5B57\53F7 (-)</li> '),
unistr('<li>\5C0F\4E8E\53F7 (<)</li>'),
unistr('<li>\5927\4E8E\53F7 (>)</li> '),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284895620212872992)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\5206\9694\7B26')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284890748234872989)
,p_name=>'DATA_LOAD.INSERT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D2\5165\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284803396605872925)
,p_name=>'DATA_LOAD.INSERTED_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\63D2\5165\884C:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284892500658872990)
,p_name=>'DATA_LOAD.IR_MAX_ROW_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\67E5\8BE2\8FD4\56DE\7684\884C\6570\8D85\8FC7\4E86 #MAX_ROW_COUNT#, \8BF7\8FC7\6EE4\6570\636E\4EE5\786E\4FDD\83B7\5F97\5B8C\6574\7ED3\679C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284201978113872492)
,p_name=>'DATA_LOAD.JUSTCHANGED_RECORD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5176\4ED6\7528\6237\66F4\6539\7684\8BB0\5F55\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283818257481872208)
,p_name=>'DATA_LOAD.LABEL_CASE_SENSITIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\5206\5927\5C0F\5199')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283818186343872208)
,p_name=>'DATA_LOAD.LABEL_UNIQUE_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\552F\4E00\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284526527439872726)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\80FD\52A0\8F7D\6570\636E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284526699452872726)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C\5DF2\5904\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284552215640872744)
,p_name=>'DATA_LOAD.LOAD_TO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\5165\81EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284956195173873037)
,p_name=>'DATA_LOAD.LOOKUP_FAILED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6CD5\68C0\7D22\67E5\627E\503C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284572683890872758)
,p_name=>'DATA_LOAD.MAPPING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E/\8868\6620\5C04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284263764620872537)
,p_name=>'DATA_LOAD.MAPPING_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B65\9AA4 2 - \9875\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284954871892873036)
,p_name=>'DATA_LOAD.NO_PREVIEW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\6587\4EF6\9884\89C8\53EF\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284894212271872991)
,p_name=>'DATA_LOAD.OPTIONAL_ENCLOSE_ITEM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C01\95ED\7B26 (\53EF\9009)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284858510418872965)
,p_name=>'DATA_LOAD.PROGRESS_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\5411\5BFC\8FDB\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284263910634872537)
,p_name=>'DATA_LOAD.RESULTS_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B65\9AA4 4 - \9875\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284203175039872493)
,p_name=>'DATA_LOAD.RETURN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD4\56DE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284201475170872492)
,p_name=>'DATA_LOAD.REVIEW_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8981\6210\4E3A\7ECF\8FC7\590D\67E5\7684\884C, \8BF7\6267\884C\4EE5\4E0B\64CD\4F5C:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284346627177872598)
,p_name=>'DATA_LOAD.ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284343183268872595)
,p_name=>'DATA_LOAD.RULES_PLSQL_EXPRESSION_EXAMPLES'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'to_char(sysdate)',
'',
'my_func (',
'    p_1 => :SAL,',
'    p_2 => :COMM)',
'',
unistr('\5176\4E2D SAL \548C COMM \662F\4E0A\8F7D\7684\6570\636E\7684\5217\540D, '),
unistr('my_func \662F\8FD4\56DE\76F8\5E94\503C\7684\51FD\6570, '),
unistr('\8BE5\503C\5C06\662F\5B9A\4E49\4E86\6B64\8F6C\6362\89C4\5219\7684\5217\7684\65B0\503C\3002'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284343302413872595)
,p_name=>'DATA_LOAD.RULES_PLSQL_FUNCTION_EXAMPLES'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'declare',
'    l_result number;',
'begin',
'    l_result := :SAL * :COMM;',
'    return l_result;',
'end;',
'',
unistr('\8FD4\56DE\7ED3\679C\5C06\662F\5B9A\4E49\4E86\6B64\8F6C\6362\89C4\5219\7684\5217\7684\65B0\503C\3002'),
'',
unistr(':SAL \548C :COMM \662F\6307\6240\4E0A\8F7D\6570\636E\7684 SAL \548C COMM \5217\540D\3002'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284343234670872595)
,p_name=>'DATA_LOAD.RULES_SQL_QUERY_EXAMPLES'
,p_message_language=>'zh-cn'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'select depno',
' from dept',
'where dname = :DEPTNAME',
'  and loc   = :LOC',
'',
unistr('\5176\4E2D :DEPNAME \548C :LOC \662F\6307\4E0A\8F7D\7684\6570\636E\7684 DEPNAME \548C LOC \5217\540D\3002'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284894074044872991)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\8BC6\5217\5206\9694\7B26\3002\4F7F\7528 <code>\005Ct</code> \4EE3\8868\5236\8868\7B26\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284894108301872991)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\9694\7B26')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284203370898872493)
,p_name=>'DATA_LOAD.SEQUENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E8F\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284947878116873031)
,p_name=>'DATA_LOAD.SEQUENCE_ACTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E8F\5217: \64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284854969701872962)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\9AD8\7EA7\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284855062186872962)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS_HELP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\6570\636E\52A0\8F7D\7684\9AD8\7EA7\8BBE\7F6E: \8D27\5E01\7B26\53F7, \5C0F\6570\70B9\5B57\7B26, \6587\4EF6\7F16\7801\6216\65E5\671F\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284572076955872757)
,p_name=>'DATA_LOAD.SOURCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284263693816872537)
,p_name=>'DATA_LOAD.SOURCE_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B65\9AA4 1 - \9875\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284935799625873022)
,p_name=>'DATA_LOAD.TAB_SEPARTOR_NOTE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('(\005Ct \8868\793A\5236\8868\7B26)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284276773064872547)
,p_name=>'DATA_LOAD.TRANSFORMATION_FAILED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F6C\6362\89C4\5219\5931\8D25')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284892858378872990)
,p_name=>'DATA_LOAD.UNIQUE_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\552F\4E00\5217 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284890801005872989)
,p_name=>'DATA_LOAD.UPDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66F4\65B0\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284803497557872925)
,p_name=>'DATA_LOAD.UPDATED_COUNT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\66F4\65B0\884C:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285003554733873072)
,p_name=>'DATA_LOAD.UPLOADED_NULL_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\8F7D\4E86\7A7A\503C\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284566653544872754)
,p_name=>'DATA_LOAD.UPLOAD_FILE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\8F7D\6587\4EF6, \4EE5\9017\53F7\5206\9694\7684 *.csv \683C\5F0F\6216\5236\8868\7B26\5206\9694\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284572205987872758)
,p_name=>'DATA_LOAD.UPLOAD_RESULTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\7ED3\679C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284572137726872758)
,p_name=>'DATA_LOAD.VALIDATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284263879486872537)
,p_name=>'DATA_LOAD.VALIDATION_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B65\9AA4 3 - \9875\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284267935111872540)
,p_name=>'DATA_LOAD_WIZARD_CREATED_SUCCESSFULLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\6210\529F\521B\5EFA\6570\636E\52A0\8F7D\5411\5BFC\9875\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284526703832872727)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\80FD\6620\5C04\6570\636E/\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284526848900872727)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C\5DF2\5904\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284126172011872437)
,p_name=>'DATA_UPLOAD_COLUMN_MAPPING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\4E0A\8F7D\5217\6620\5C04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284051683544872383)
,p_name=>'DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284256209537872532)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\9879%1\8F93\5165\7684\7A81\51FA\663E\793A\65E5\671F\5C5E\6027\503C%0\4E0D\7B26\5408%2\683C\5F0F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284262012800872536)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID_RELATIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\9879%1\8F93\5165\7684\7A81\51FA\663E\793A\65E5\671F\5C5E\6027\503C%0\4E0D\662F\76F8\5BF9\65E5\671F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284256406831872532)
,p_name=>'DATEPICKER.MAX_DATE_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\9879%1\8F93\5165\7684\6700\5927\65E5\671F\5C5E\6027\503C%0\4E0D\7B26\5408%2\683C\5F0F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284262206614872536)
,p_name=>'DATEPICKER.MAX_DATE_INVALID_RELATIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\9879%1\8F93\5165\7684\6700\5927\65E5\671F\5C5E\6027\503C%0\4E0D\662F\76F8\5BF9\65E5\671F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284256385749872532)
,p_name=>'DATEPICKER.MIN_DATE_INVALID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\9879%1\8F93\5165\7684\6700\5C0F\65E5\671F\5C5E\6027\503C%0\4E0D\7B26\5408%2\683C\5F0F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284262194208872536)
,p_name=>'DATEPICKER.MIN_DATE_INVALID_RELATIVE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3A\9879%1\8F93\5165\7684\6700\5C0F\65E5\671F\5C5E\6027\503C%0\4E0D\662F\76F8\5BF9\65E5\671F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284390109641872630)
,p_name=>'DATE_ADDED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284862985897872968)
,p_name=>'DATE_OF_LAST_RUN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E26\4E0A\6B21\8FD0\884C\65F6\95F4\7684 Oracle Application Express \6570\636E\5E93\4F5C\4E1A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283882108293872257)
,p_name=>'DAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283882220021872257)
,p_name=>'DAYS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284178810924872475)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5230\6700\540E\4E00\4E2A\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284178969299872475)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE_OF_RELASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5230\53D1\884C\7248 %0 \7684\6700\540E\4E00\4E2A\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284261371369872535)
,p_name=>'DA_NAME.NATIVE_ADD_CLASS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6DFB\52A0\7C7B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284867992380872972)
,p_name=>'DA_NAME.NATIVE_ALERT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9884\8B66')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284866626929872971)
,p_name=>'DA_NAME.NATIVE_CANCEL_EVENT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284868194880872972)
,p_name=>'DA_NAME.NATIVE_CLEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284868016791872972)
,p_name=>'DA_NAME.NATIVE_CONFIRM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\786E\8BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283627704175872064)
,p_name=>'DA_NAME.NATIVE_DIALOG_CANCEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\53D6\6D88\201D\5BF9\8BDD\6846')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283627872593872064)
,p_name=>'DA_NAME.NATIVE_DIALOG_CLOSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5173\95ED\5BF9\8BDD\6846')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283787422651872184)
,p_name=>'DA_NAME.NATIVE_DISABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7981\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283787389270872184)
,p_name=>'DA_NAME.NATIVE_ENABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284860299603872966)
,p_name=>'DA_NAME.NATIVE_EXECUTE_PLSQL_CODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6267\884C PL/SQL \4EE3\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283787268786872184)
,p_name=>'DA_NAME.NATIVE_HIDE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9690\85CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284173671200872471)
,p_name=>'DA_NAME.NATIVE_JAVASCRIPT_CODE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6267\884C JavaScript \4EE3\7801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284533677172872731)
,p_name=>'DA_NAME.NATIVE_REFRESH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5237\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284261487571872536)
,p_name=>'DA_NAME.NATIVE_REMOVE_CLASS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\7C7B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284261524863872536)
,p_name=>'DA_NAME.NATIVE_SET_CSS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\6837\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284506501726872713)
,p_name=>'DA_NAME.NATIVE_SET_FOCUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\7126\70B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284173544906872471)
,p_name=>'DA_NAME.NATIVE_SET_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBE\7F6E\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283787192745872184)
,p_name=>'DA_NAME.NATIVE_SHOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284506675736872713)
,p_name=>'DA_NAME.NATIVE_SUBMIT_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D0\4EA4\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284444196746872669)
,p_name=>'DA_NAME.NATIVE_TREE_COLLAPSE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9690\85CF\6811')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284444024264872669)
,p_name=>'DA_NAME.NATIVE_TREE_EXPAND'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C55\5F00\6811')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283664601253872092)
,p_name=>'DBACCOUNT_AUTH_SCHEME_DESC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\5E10\6237')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284169737336872468)
,p_name=>'DB_COLS_CASE_SEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\8868\540D\548C\5217\540D\533A\5206\5927\5C0F\5199')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284282015269872551)
,p_name=>'DB_OBJECT_CREATION_EXCEPTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\5E93\5BF9\8C61\521B\5EFA\5F02\5E38\9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283678323193872102)
,p_name=>'DB_PRODUCT_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>'Oracle Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284925940431873015)
,p_name=>'DB_SERVICES_ALIAS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\522B\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284922317335873012)
,p_name=>'DB_SERVICES_ALL_MIMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6240\6709 Mime')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284925887562873015)
,p_name=>'DB_SERVICES_CREATE_HANDLER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\5904\7406\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284922659244873012)
,p_name=>'DB_SERVICES_CREATE_METHOD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284922421173873012)
,p_name=>'DB_SERVICES_CREATE_PARAMETER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\53C2\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284922575064873012)
,p_name=>'DB_SERVICES_CREATE_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284929684257873018)
,p_name=>'DB_SERVICES_DB_SERVICES_MODULE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('RESTful \670D\52A1\6A21\5757')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284925782593873015)
,p_name=>'DB_SERVICES_HANDLER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284930108033873018)
,p_name=>'DB_SERVICES_HANDLER_BIND_VARIABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\7A0B\5E8F\7ED1\5B9A\53D8\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284899570575872995)
,p_name=>'DB_SERVICES_HANDLER_METHOD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\7A0B\5E8F\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284930412156873018)
,p_name=>'DB_SERVICES_HANDLER_SOURCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\7A0B\5E8F\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284899651049872995)
,p_name=>'DB_SERVICES_HANDLER_SRC_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\7A0B\5E8F\6E90\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284922123358873012)
,p_name=>'DB_SERVICES_METHOD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284929725735873018)
,p_name=>'DB_SERVICES_MODULE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\5757\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284930292907873018)
,p_name=>'DB_SERVICES_MODULE_URI'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\5757 URI \524D\7F00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284922769558873012)
,p_name=>'DB_SERVICES_NO_SOURCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E0\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284922061603873012)
,p_name=>'DB_SERVICES_PARAMETER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53C2\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284929973533873018)
,p_name=>'DB_SERVICES_RESTFUL_SERVICES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('RESTful \670D\52A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284922233162873012)
,p_name=>'DB_SERVICES_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284930334674873018)
,p_name=>'DB_SERVICES_TEMPLATE_URI'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('URI \6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284899496723872995)
,p_name=>'DB_SERVICES_URI'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EDF\4E00\8D44\6E90\6807\8BC6\7B26 (URI)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284929492485873017)
,p_name=>'DB_SERVICES_URI_PRIFIX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('URI \524D\7F00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284929595516873017)
,p_name=>'DB_SERVICES_URI_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('URI \6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284899723979872995)
,p_name=>'DB_SERVICE_QUERY_ONE_ROW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\67E5\8BE2\4E00\884C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284075135223872400)
,p_name=>'DEBUG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8C03\8BD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284190109738872483)
,p_name=>'DEBUGGING_OFF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\4E3A\6B64\5E94\7528\7A0B\5E8F\542F\7528\8C03\8BD5\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284186888929872481)
,p_name=>'DECLINED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\62D2\7EDD')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285001495742873070)
,p_name=>'DEFAULT_DIALOGBTNR_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\5BF9\8BDD\6846\6309\94AE\533A\57DF\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285001374835873070)
,p_name=>'DEFAULT_DIALOGR_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\5BF9\8BDD\6846\5185\5BB9\533A\57DF\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284527540867872727)
,p_name=>'DEFAULT_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284056013880872386)
,p_name=>'DEFAULT_TABLESPACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\8868\7A7A\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284057714997872387)
,p_name=>'DEFAULT_TABLESPACE_INIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\8868\7A7A\95F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284345451373872597)
,p_name=>'DEFAULT_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\6A21\677F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283660353509872089)
,p_name=>'DEFINED_BY_DA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7531\52A8\6001\64CD\4F5C\5B9A\4E49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284591128339872771)
,p_name=>'DEFINED_TABS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\5E94\7528\7A0B\5E8F\6709 %0 \4E2A\9009\9879\5361, \8FD9\4E9B\9009\9879\5361\5DF2\7EC4\7EC7\4E3A %1 \4E2A\9009\9879\5361\96C6, \5E76\4E14\5DF2\5B9A\4E49\4E86 %2 \4E2A\7236\9009\9879\5361\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283947370448872306)
,p_name=>'DEFINE_LOV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\4E49\503C\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284112286484872427)
,p_name=>'DEFINITION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B9A\4E49')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284279820967872549)
,p_name=>'DEINSTALLATION_SCRIPT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5378\8F7D\811A\672C')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283883995560872258)
,p_name=>'DELETE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283775588322872175)
,p_name=>'DELETED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284864111950872969)
,p_name=>'DELETE_APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284337148281872591)
,p_name=>'DELETE_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284312954830872573)
,p_name=>'DELETE_LINK_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283688954986872110)
,p_name=>'DELETE_MSG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\662F\5426\8981\6267\884C\6B64\5220\9664\64CD\4F5C?')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283726691431872138)
,p_name=>'DEMO.COLLECT.DESCR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528\201C\6536\85CF\54C1\5C55\793A\201D\53EF\4EE5\5B58\50A8\5728 Oracle Application Express \4F1A\8BDD\4E2D\4F7F\7528\7684\6570\636E\884C\3002\6B64\6570\636E\5E93\5E94\7528\7A0B\5E8F\8BF4\660E\5982\4F55\4F7F\7528 PL/SQL \521B\5EFA\548C\7BA1\7406\57FA\4E8E\96C6\5408\7684\4F1A\8BDD\72B6\6001\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283726474647872138)
,p_name=>'DEMO.SAMPLE.APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\793A\4F8B\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283726539621872138)
,p_name=>'DEMO.SAMPLE.APP.DESCR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EA7\54C1\95E8\6237\662F\4E00\4E2A\793A\4F8B\5E94\7528\7A0B\5E8F, \91CD\70B9\5F3A\8C03\5E38\89C1\7684\8BBE\8BA1\6982\5FF5\3002\5176\4E2D\5305\62EC\9762\5411\5BA2\6237, \4EA7\54C1\548C\8BA2\5355\7684\4E13\7528\9875, \5E76\4E14\6F14\793A\4E86\62A5\8868, \56FE\8868, \65E5\5386, \5730\56FE\548C\6811\7684\4F7F\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284134918240872443)
,p_name=>'DEMONSTRABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\6F14\793A\7684')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283864741001872243)
,p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5065\5EB7\62A5\8868\548C\9875\7801\6982\5FF5\7684\793A\4F8B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283864410473872243)
,p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F7F\7528 %0 \6784\5EFA\5728\7EBF\5546\5E97\7684\793A\4F8B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283865144685872244)
,p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E86\89E3\5982\4F55\5C06 Oracle Text \4E0E %0 \4E00\8D77\4F7F\7528\3002 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283865521905872244)
,p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528 %0 \6784\5EFA\7684\9879\76EE\72B6\6001\8DDF\8E2A\5E94\7528\7A0B\5E8F\7684\793A\4F8B\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283864960919872244)
,p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E86\89E3\5982\4F55\5C06 web \670D\52A1\4E0E %0 \4E00\8D77\4F7F\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283863219496872242)
,p_name=>'DEMO_APPLICATION.ACTION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283861031405872241)
,p_name=>'DEMO_APPLICATION.APPLICATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283860712827872240)
,p_name=>'DEMO_APPLICATION.BASIC_LEXER'
,p_message_language=>'zh-cn'
,p_message_text=>'BASIC_LEXER'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283864628219872243)
,p_name=>'DEMO_APPLICATION.BUSINESS_LOOK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5546\4E1A\6837\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283863316886872242)
,p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6536\85CF\54C1\5C55\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283860802626872240)
,p_name=>'DEMO_APPLICATION.CONTEXT_INDEX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0A\4E0B\6587\7D22\5F15')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283860241381872240)
,p_name=>'DEMO_APPLICATION.CREATE_BASIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5C06\8981\521B\5EFA\201C\57FA\672C\793A\4F8B\6F14\793A\5E94\7528\7A0B\5E8F\201D\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283858828416872239)
,p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5C06\8981\521B\5EFA (\91CD\65B0\521B\5EFA)\201C\5546\4E1A\6837\5F0F\201D\6F14\793A\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283860392939872240)
,p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5C06\8981\521B\5EFA\201C\6536\85CF\54C1\5C55\793A\201D\6F14\793A\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283860484294872240)
,p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5728\65B9\6848 %0 \4E2D\521B\5EFA\6216\91CD\65B0\521B\5EFA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283858723460872239)
,p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\521B\5EFA\793A\4F8B\5E94\7528\7A0B\5E8F\6765\6F14\793A Web \670D\52A1\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283858983398872239)
,p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5C06\8981\521B\5EFA\201C\4E16\754C\676F\72C2\70ED\4E4B\65C5\201D\6F14\793A\5E94\7528\7A0B\5E8F\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283668890006872095)
,p_name=>'DEMO_APPLICATION.DEINSTALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283863019069872242)
,p_name=>'DEMO_APPLICATION.DEMO_APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6F14\793A\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283861313900872241)
,p_name=>'DEMO_APPLICATION.FREE_SPACE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5927\7EA6\6709 %0 MB \53EF\7528\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283863840141872243)
,p_name=>'DEMO_APPLICATION.INSTALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B89\88C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283863512535872243)
,p_name=>'DEMO_APPLICATION.INSTALLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\5B89\88C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283978503588872329)
,p_name=>'DEMO_APPLICATION.INSTALL_DEMO_APP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\60A8\5C06\8981\5B89\88C5\793A\4F8B\5E94\7528\7A0B\5E8F, \8BE5\7A0B\5E8F\6F14\793A %0 \7684\4E3B\8981\529F\80FD\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283864523696872243)
,p_name=>'DEMO_APPLICATION.INSTALL_NOW'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ACB\5373\5B89\88C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283863437066872242)
,p_name=>'DEMO_APPLICATION.LEARN_ABOUT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E86\89E3 %0 \8D2D\7269\8F66\6982\5FF5\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284317196079872576)
,p_name=>'DEMO_APPLICATION.LOCKED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\9501\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283861159233872241)
,p_name=>'DEMO_APPLICATION.NEED_7M'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\201C\603B\7EDF\5C31\804C\6F14\8BF4\201D\6F14\793A\9700\8981\5927\7EA6 7MB \7684\53EF\7528\78C1\76D8\7A7A\95F4, \5E76\4E14\5728\60A8\7684\65B9\6848\4E2D\5B89\88C5\9700\8981\4E24\5206\949F\7684\65F6\95F4\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283978263606872329)
,p_name=>'DEMO_APPLICATION.NOT_ENOUGH_SPACE_ERR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\8DB3\591F\7A7A\95F4, \65E0\6CD5\521B\5EFA\6B64\6F14\793A\3002\901A\8FC7\8F6C\81F3\7BA1\7406\9875, \7136\540E\8F6C\5230\9884\914D\670D\52A1, \5355\51FB\8BF7\6C42\989D\5916\5B58\50A8\7A7A\95F4\7684\94FE\63A5, \5373\53EF\8BF7\6C42\989D\5916\7684\5B58\50A8\7A7A\95F4\3002%0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283863783227872243)
,p_name=>'DEMO_APPLICATION.NOT_INSTALLED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\5B89\88C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283859659298872240)
,p_name=>'DEMO_APPLICATION.OBJECT_EXIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283858539005872239)
,p_name=>'DEMO_APPLICATION.OBJECT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283859502259872240)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\540D\79F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283860619084872240)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\8C61\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283858674858872239)
,p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283859201913872239)
,p_name=>'DEMO_APPLICATION.OBJECT_RECREATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\5B58\5728\4EE5\4E0B\6570\636E\5E93\5BF9\8C61\5219\91CD\65B0\521B\5EFA\5B83\4EEC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283859404417872239)
,p_name=>'DEMO_APPLICATION.OBJECT_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BF9\8C61\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283860127711872240)
,p_name=>'DEMO_APPLICATION.PACKAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7A0B\5E8F\5305')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283864329515872243)
,p_name=>'DEMO_APPLICATION.PETSTORE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BA0\7269\5546\5E97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283865051670872244)
,p_name=>'DEMO_APPLICATION.PRESIDENTIAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\603B\7EDF\5C31\804C\6F14\8BF4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283865325588872244)
,p_name=>'DEMO_APPLICATION.PROJECT_TRACKING'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9879\76EE\8DDF\8E2A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284061719198872390)
,p_name=>'DEMO_APPLICATION.RE_INSTALL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\65B0\5B89\88C5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283863661796872243)
,p_name=>'DEMO_APPLICATION.RUN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FD0\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283859367367872239)
,p_name=>'DEMO_APPLICATION.SCHEMA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283859933233872240)
,p_name=>'DEMO_APPLICATION.SEQUENCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E8F\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283863185711872242)
,p_name=>'DEMO_APPLICATION.STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\72B6\6001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283859797433872240)
,p_name=>'DEMO_APPLICATION.TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283862950598872242)
,p_name=>'DEMO_APPLICATION.TABLE_SUMMARY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6F14\793A\5E94\7528\7A0B\5E8F\5B89\88C5\72B6\6001\62A5\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283860051186872240)
,p_name=>'DEMO_APPLICATION.TRIGGER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\89E6\53D1\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284317391770872576)
,p_name=>'DEMO_APPLICATION.UNLOCKED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\672A\9501\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283705851196872123)
,p_name=>'DEMO_APPLICATION.UPDATE_AVAILABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\4EE5\8FDB\884C\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284955801111873037)
,p_name=>'DEMO_APPLICATION.WEBSHEET_OBJECT_VALIDATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981\66F4\6B63\4EE5\4E0B\65E0\6548\5BF9\8C61\624D\80FD\6B63\5E38\8FD0\884C Websheets')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283864838648872244)
,p_name=>'DEMO_APPLICATION.WEB_SERVICES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \670D\52A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283861451804872241)
,p_name=>'DEMO_APPLICATION.WILL_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5982\679C\4E0D\91CD\65B0\521B\5EFA\6B64\6F14\793A, \53EF\80FD\4F1A\9047\5230\9519\8BEF\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283794319854872190)
,p_name=>'DEMO_FLOW.CREATED_ERROR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6CA1\6709\8DB3\591F\7A7A\95F4, \65E0\6CD5\521B\5EFA\6B64\6F14\793A\3002\901A\8FC7\8F6C\81F3\7BA1\7406\9875\5E76\5355\51FB "\8BF7\6C42\66F4\6539\5F53\524D\670D\52A1" \94FE\63A5\53EF\4EE5\8BF7\6C42\989D\5916\7684\5B58\50A8\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283794257573872190)
,p_name=>'DEMO_FLOW.CREATED_SUCCESS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\521B\5EFA %0 \6F14\793A\5E94\7528\7A0B\5E8F\3002')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284565347952872753)
,p_name=>'DEPRECATED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53D6\6D88')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283742293328872150)
,p_name=>'DERIVED$'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6D3E\751F\5217')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284134873211872443)
,p_name=>'DESIRABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9700\8981')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284210702591872498)
,p_name=>'DETAIL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BE6\7EC6\8D44\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284277590364872547)
,p_name=>'DETAILS_FOR_ALT_TAG'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BE6\7EC6\8D44\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284210877148872498)
,p_name=>'DETAIL_2'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BE6\7EC6\8D44\6599 2')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283676902268872101)
,p_name=>'DEVELOPER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284283767018872552)
,p_name=>'DEVELOPERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284155203878872458)
,p_name=>'DEVELOPER_ACTIVITY_SUMMARY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\8005\6D3B\52A8\6982\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284180135295872476)
,p_name=>'DEVELOPER_SUMMARY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\8005\6982\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284360637977872608)
,p_name=>'DEVELOPER_TOOLBAR_CLEAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E05\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284360580416872608)
,p_name=>'DEVELOPER_TOOLBAR_COPY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\590D\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284389281227872629)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8C03\8BD5 (%0)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284388778955872629)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9ED8\8BA4\8C03\8BD5\7EA7\522B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284388943337872629)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL4'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4FE1\606F\FF08\9ED8\8BA4\503C\FF09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284389024482872629)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL6'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8DDF\8E2A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284389150619872629)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL9'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B8C\6574\8DDF\8E2A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284348203421872599)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81EA\9875\52A0\8F7D\4EE5\6765\51FA\73B0\4E86\4E00\4E2A\6216\591A\4E2A\9519\8BEF\3002\6253\5F00\6D4F\89C8\5668\7684 JavaScript \63A7\5236\53F0\4EE5\67E5\770B\9519\8BEF\3002')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284348849246872599)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS_BTN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('JavaScript \9519\8BEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284443756467872669)
,p_name=>'DEVELOPER_TOOLBAR_NO_BUILDER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6B64\529F\80FD\9700\8981\6253\5F00 Application Express \5E94\7528\7A0B\5E8F\6784\5EFA\5668\7A97\53E3\3002\662F\5426\5728\6B64\7A97\53E3\4E2D\6253\5F00\6784\5EFA\5668?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284423605947872654)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\8005\5DE5\5177\680F\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284431932913872660)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_AUTO_HIDE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\81EA\52A8\9690\85CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284432164697872660)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_DISPLAY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\4F4D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284432021542872660)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_ICONS_ONLY'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EC5\663E\793A\56FE\6807')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284432370141872660)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_BOTTOM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E95\90E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284432235822872660)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_LEFT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DE6\5BF9\9F50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284432475534872660)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_RIGHT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53F3\5BF9\9F50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284440097808872666)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_TOP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9876\90E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284354944324872604)
,p_name=>'DEVELOPER_TOOLBAR_PAGE_INFO'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\4FE1\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284355139693872604)
,p_name=>'DEVELOPER_TOOLBAR_PERF_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\6027\80FD\8BA1\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284423756708872654)
,p_name=>'DEVELOPER_TOOLBAR_QUICK_EDIT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FEB\901F\7F16\8F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284355034942872604)
,p_name=>'DEVELOPER_TOOLBAR_SHOW_PERF'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\9875\8BA1\65F6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284971878785873049)
,p_name=>'DEVELOPER_TOOLBAR_THEME_ROLLER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898\6EDA\52A8\6761')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284431837561872660)
,p_name=>'DEVELOPER_TOOLBAR_TITLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\8005\5DE5\5177\680F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284128320315872438)
,p_name=>'DEVELOPMENT_TASK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\4EFB\52A1')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284311476332872572)
,p_name=>'DIAL_CHART_ALERT_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9884\8B66')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284311342290872572)
,p_name=>'DIAL_CHART_HIGH_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9AD8\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284311253166872572)
,p_name=>'DIAL_CHART_LOW_VALUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4F4E\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283631524973872067)
,p_name=>'DIAL_PCT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EEA\8868\76D8 (\767E\5206\6BD4)')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283713061600872128)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283715604155872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283715781323872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTHORIZATION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6388\6743\65B9\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283714815506872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BC_ENTRIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283714776093872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BREADCRUMBS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285013625475873079)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BUILD_OPTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6784\5EFA\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283714451437872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_COMPUTATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8BA1\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283714601920872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283714997928872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LISTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283715021690872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LIST_ENTRIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283715167031872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOVS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\5217\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283651195255872082)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C\5217\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283715267592872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_ENTRIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6761\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283715364061872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_NAV_BAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5BFC\822A\680F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283713163127872128)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283714365803872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BRANCHES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283713538464872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BUTTONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284101314513872419)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHARTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\56FE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284101519125872419)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_A'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8F74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284101468345872419)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_S'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7CFB\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283714049495872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_COMP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BA1\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283760291492872164)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A8\6001\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283760357462872164)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA_ACTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A8\6001\64CD\4F5C - \64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284532907590872731)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Flash 5 \56FE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284533060952872731)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5_S'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7CFB\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283713609245872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_CH'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Flash \56FE\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283713701165872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_S'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7CFB\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283713803452872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('IR \533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283713973810872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR_COL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283713313293872128)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283714285405872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_PROC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283713245138872128)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REGIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284825035147872940)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REG_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283713412971872128)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_RPT_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284920551620873011)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_TREES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6811')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283714100719872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_VAL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283715434269872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PARENT_TABS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7236\9009\9879\5361')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283714540188872129)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PROCESSES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\5904\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284951708935873034)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_LAYOUTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\5E03\5C40')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284952565635873034)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QRY_STMTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\544A\67E5\8BE2 SQL \8BED\53E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284951607756873034)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QUERIES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\67E5\8BE2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284890640304872989)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283715872893872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SHORTCUTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5FEB\6377\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283711076948872127)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_STATIC_FILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5E94\7528\7A0B\5E8F\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283717336197872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUBSTITUTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\66FF\6362')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285013326655873079)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJECTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\652F\6301\5BF9\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285013451646873079)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_BOPT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\652F\6301\5BF9\8C61\6784\5EFA\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283717147581872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_CHCK'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\652F\6301\5BF9\8C61\9A8C\8BC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283717236916872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_SCR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\652F\6301\5BF9\8C61\811A\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283715593017872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TABS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9009\9879\5361')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283716232437872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9762\5305\5C51\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283716372049872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BUTTON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6309\94AE\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283716492219872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_CALENDAR'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\5386\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283786714442872184)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_GRID'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7F51\683C\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283716597919872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6807\7B7E\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283716679455872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LIST'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\8868\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283716753992872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9875\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283716823416872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_POPUPLOV'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F39\51FA\5F0F LOV \6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283716944544872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REGION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\533A\57DF\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283717010540872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REPORT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\6A21\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283716135691872131)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEMES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283693286855872113)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_FILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283639340140872073)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_STYLES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898\6837\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284160465334872462)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANSLATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\672C\6D88\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283685731912872108)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_DYNAMIC'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\52A8\6001\7FFB\8BD1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283685830302872108)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_REPOS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53EF\7FFB\8BD1\6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283716050913872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TREES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6811')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283715988950872130)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_WEB_SERVICES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \670D\52A1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284911719317873004)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_ROLES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284911883667873004)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236\7528\6237')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284202173965872492)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USER_ROLES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\63A7\5236\7528\6237\89D2\8272\5206\914D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284955478675873037)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_CONCATENATED_FILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FDE\63A5\7684\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284109362964872425)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\8BED\6CD5\5206\6790\6982\8981\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284109449672872425)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILE_COLS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\8BED\6CD5\5206\6790\6982\8981\6587\4EF6\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284985113918873058)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DEVELOPER_COMMENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5F00\53D1\8005\6CE8\91CA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284520747463872722)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284508928587872714)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284509051186872714)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_LOOKUPS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\8868\67E5\627E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284509116099872715)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_RULES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6570\636E\52A0\8F7D\8868\8F6C\6362\89C4\5219')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283646178693872078)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CALENDARS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\65E5\5386\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284424509500872655)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4EA4\4E92\5F0F\7F51\683C\533A\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284424691600872655)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COLUMNS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62A5\8868\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284424794189872655)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COL_GROUPS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\7EC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283733486453872144)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGINS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D2\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283733585023872144)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTRIBUTES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5C5E\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284159021124872461)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTR_VALUES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283791573744872188)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_EVENTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283735940554872146)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_FILES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284211490664872499)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ITEM_FILTERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8FC7\6EE4\8FD0\7B97\7B26')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285013598865873079)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_SETTINGS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\4EF6\8BBE\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284926375583873015)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_STD_ATTRS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\63D2\4EF6\6807\51C6\5C5E\6027\5143\6570\636E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284109266429872424)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_REMOTE_SQL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\542F\7528 REST \7684 SQL \670D\52A1\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284824995259872940)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPTIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\677F\9009\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285013209632873079)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GROUPS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\677F\9009\9879\7EC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284897586554872994)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GRP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6A21\677F\9009\9879\7EC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284968608706873046)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_PAGE_DP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\70B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284968789325873046)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_REGION_DP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\70B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283789975550872186)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_THEME_DISPLAY_POINTS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E3B\9898\663E\793A\70B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283710937607872127)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_USER_INTERFACES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7528\6237\754C\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284109956165872425)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_COMP_PARAMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC4\4EF6 Web \6E90\53C2\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284109666502872425)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_MODULES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \6E90\6A21\5757')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284109750826872425)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_OPERATIONS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \6E90\64CD\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284109857192872425)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_PARAMETERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \6E90\53C2\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284109572775872425)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_SERVERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('Web \6E90\8FDC\7A0B\670D\52A1\5668')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284928843784873017)
,p_name=>'DISABLED_NEXT_BUTTON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\7981\7528\201C\4E0B\4E00\6B65\201D\6309\94AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284928767377873017)
,p_name=>'DISABLED_PREVIOUS_BUTTON'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5DF2\7981\7528\201C\4E0A\4E00\6B65\201D\6309\94AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284272125909872543)
,p_name=>'DISABLE_TRIGGER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7981\7528\89E6\53D1\5668 %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283869415972872247)
,p_name=>'DISPLAY_CONDITION'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283869629195872247)
,p_name=>'DISPLAY_CONDITION_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\6761\4EF6\6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284337302914872591)
,p_name=>'DISPLAY_ORDER_LABEL'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\987A\5E8F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283739968917872149)
,p_name=>'DISPLAY_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285012925013873079)
,p_name=>'DISPLAY_VALUE.N'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\663E\793A\503C: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284924102712873014)
,p_name=>'DISTINCT_PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\540C\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284924287613873014)
,p_name=>'DISTINCT_USERS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\540C\7528\6237')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283650861817872081)
,p_name=>'DML_FORM'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('DML \8868\5355')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283957703582872314)
,p_name=>'DO NOT UPDATE PAGE ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>'DO_NOT_UPDATE_PAGE_ITEMS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284150864393872455)
,p_name=>'DOC_IMPACT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\6863\5F71\54CD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284152070168872456)
,p_name=>'DOC_STATUS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\6863\72B6\6001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284152207758872456)
,p_name=>'DOC_WRITER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6587\6863\4F5C\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284029796517872367)
,p_name=>'DOWN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5411\4E0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283661232615872089)
,p_name=>'DOWNLOAD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\8F7D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284160271109872462)
,p_name=>'DOWNLOAD_LINK_TEXT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0B\8F7D\94FE\63A5\6587\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283957410158872314)
,p_name=>'DO_NOT_UPDATE_APPLICATION_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\66F4\65B0\5E94\7528\7A0B\5E8F\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283957579573872314)
,p_name=>'DO_NOT_UPDATE_DATA_ENTRY_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\66F4\65B0\6570\636E\6761\76EE\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283957678261872314)
,p_name=>'DO_NOT_UPDATE_DISPLAY_ONLY_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\66F4\65B0\4EC5\663E\793A\9879')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283957392220872314)
,p_name=>'DO_NOT_UPDATE_PAGES'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\66F4\65B0\9875')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283958992572872315)
,p_name=>'DO_NOT_UPDATE_PAGE_ITEMS'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\4E0D\66F4\65B0\9875\9879')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283837935087872223)
,p_name=>'DRAG_AND_DROP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\62D6\653E')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283730657993872141)
,p_name=>'DRILLDOWN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7EC6\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283730504942872141)
,p_name=>'DRILLUP'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6C47\96C6')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(283886221909872260)
,p_name=>'DRIVEN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\9A71\52A8')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284271907528872543)
,p_name=>'DROP TRIGGER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\89E6\53D1\5668 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284270847857872542)
,p_name=>'DROP_COLUMN'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5220\9664\5217 %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284504227103872711)
,p_name=>'DS_ACCESS_METHOD'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\8BBF\95EE\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284504005882872711)
,p_name=>'DS_BIND_VARIABLE_NAME'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\7ED1\5B9A\53D8\91CF\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284504446686872711)
,p_name=>'DS_HANDLER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5904\7406\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284504806397872712)
,p_name=>'DS_ITEMS_PER_PAGE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6BCF\9875\7684\9879\6570')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284504617314872711)
,p_name=>'DS_MIME_TYPES_ALLOWED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8 MIME \7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284504718115872712)
,p_name=>'DS_ORIGINS_ALLOWED'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5141\8BB8\539F\59CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284504306389872711)
,p_name=>'DS_PARAMETER_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\53C2\6570\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284504992997872712)
,p_name=>'DS_SECURITY_CONSTRAINT'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5B89\5168\7EA6\675F\6761\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284504199628872711)
,p_name=>'DS_SOURCE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284504540458872711)
,p_name=>'DS_SOURCE_TYPE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\6E90\7C7B\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284505097816872712)
,p_name=>'DS_URI_PREFIX'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('URI \524D\7F00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284503708258872711)
,p_name=>'DS_URI_TEMPLATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('URI \6A21\677F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284952666117873034)
,p_name=>'DUE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\622A\6B62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284151883624872456)
,p_name=>'DUE_DATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\622A\6B62\65E5\671F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284131668889872441)
,p_name=>'DUPLICATE'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\91CD\590D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284925032311873014)
,p_name=>'DUPLICATE_USER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\8868\4E2D\7528\6237\91CD\590D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284574226842872759)
,p_name=>'DUP_USER'
,p_message_language=>'zh-cn'
,p_message_text=>unistr('\5217\8868\4E2D\7684\7528\6237\540D\91CD\590D\3002')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_