prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4806
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4806 - Oracle APEX Team Development
--
-- Application Export:
--   Application:     4806
--   Name:            Oracle APEX Team Development
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                     68
--       Items:                  325
--       Computations:            89
--       Validations:             22
--       Processes:              103
--       Regions:                312
--       Buttons:                170
--       Dynamic Actions:         65
--     Shared Components:
--       Logic:
--         Items:                 23
--         Processes:              2
--         Computations:           3
--         Build Options:          3
--       Navigation:
--         Lists:                 17
--         Breadcrumbs:            1
--           Entries:             66
--       Security:
--         Authentication:         1
--         Authorization:         12
--       User Interface:
--         Templates:
--           Page:                11
--           Region:              40
--           Label:               11
--           List:                14
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           2
--           Button:              14
--           Report:              10
--         LOVs:                  84
--         Shortcuts:              2
--         Plug-ins:              16
--       Globalization:
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Team Development')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286633106883937394')
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135355'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'zh-cn'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(539942911020674156.4806)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_vpd=>'wwv_flow_ws_auth.init_schema;'
,p_security_scheme=>wwv_flow_api.id(178936207895752596)
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'MSG_LANGUAGE'
,p_substitution_value_01=>unistr('\8BED\8A00')
,p_substitution_string_02=>'MSG_USER'
,p_substitution_value_02=>unistr('\7528\6237')
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>unistr('\5DE5\4F5C\533A: &COMPANY.')
,p_substitution_string_04=>'DELETE_MSG'
,p_substitution_value_04=>unistr('\662F\5426\8981\6267\884C\6B64\5220\9664\64CD\4F5C?')
,p_substitution_string_05=>'PRODUCT_NAME'
,p_substitution_value_05=>'Application Express'
,p_substitution_string_06=>'HELP'
,p_substitution_value_06=>unistr('\5E2E\52A9')
,p_substitution_string_07=>'EDIT'
,p_substitution_value_07=>unistr('\7F16\8F91')
,p_substitution_string_08=>'TOP'
,p_substitution_value_08=>unistr('\9876\90E8')
,p_substitution_string_09=>'CLOSE'
,p_substitution_value_09=>unistr('\5173\95ED')
,p_substitution_string_10=>'MSG_COPYRIGHT'
,p_substitution_value_10=>unistr('\7248\6743\6240\6709 &copy; 1999\FF0C2019\FF0COracle \548C/\6216\5176\5173\8054\516C\53F8\3002\4FDD\7559\6240\6709\6743\5229\3002')
,p_substitution_string_11=>'DATE_FORMAT'
,p_substitution_value_11=>'yyyy-mm-dd'
,p_substitution_string_12=>'MSG_JSCRIPT'
,p_substitution_value_12=>unistr('\5FC5\987B\5728\542F\7528 JavaScript \7684\60C5\51B5\4E0B\8FD0\884C\6B64\4EA7\54C1\3002')
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141412'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/navigation_icons
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(177367416819197659.4806)
,p_name=>'navigation icons'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177368100019197670.4806)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\91CC\7A0B\7891')
,p_list_item_link_target=>'f?p=&APP_ID.:6000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/calendar_small.gif'
,p_list_text_01=>'milestones'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177367721534197663.4806)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\529F\80FD')
,p_list_item_link_target=>'f?p=&APP_ID.:9000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/features_small.gif'
,p_list_item_icon_attributes=>'width="12" heigh="12"'
,p_list_text_01=>'features'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177368531371197675.4806)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5F85\529E\4E8B\9879')
,p_list_item_link_target=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/check_small.gif'
,p_list_text_01=>'todos'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177368932652197676.4806)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Bug'
,p_list_item_link_target=>'f?p=&APP_ID.:3500:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/bug_small.gif'
,p_list_text_01=>'bugs'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3500'
);
end;
/
prompt --application/shared_components/navigation/lists/navigation_icons_dashboard
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(177387020956397479.4806)
,p_name=>'navigation icons / dashboard'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177387700498397480.4806)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\91CC\7A0B\7891')
,p_list_item_link_target=>'f?p=&APP_ID.:6006:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/calendar_small.gif'
,p_list_text_01=>'milestones'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6006'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177387316413397480.4806)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\529F\80FD')
,p_list_item_link_target=>'f?p=&APP_ID.:9010:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/features_small.gif'
,p_list_text_01=>'features'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9010'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177388116852397483.4806)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5F85\529E\4E8B\9879')
,p_list_item_link_target=>'f?p=&APP_ID.:3001:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/check_small.gif'
,p_list_text_01=>'todos'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3001'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177388518337397483.4806)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Bug'
,p_list_item_link_target=>'f?p=&APP_ID.:3501:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/bug_small.gif'
,p_list_text_01=>'bugs'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3501'
);
end;
/
prompt --application/shared_components/navigation/lists/tasks_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(180244521254945294.4806)
,p_name=>'tasks tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180245023686945295.4806)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\9762\677F')
,p_list_item_link_target=>'f?p=&APP_ID.:3001:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3001'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180244730943945294.4806)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\62A5\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(182641614581345206.4806)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65E5\5386')
,p_list_item_link_target=>'f?p=&APP_ID.:3013:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3013'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181603636423941210.4806)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\8FDB\5EA6\65E5\5FD7')
,p_list_item_link_target=>'f?p=&APP_ID.:3002:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3002'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_task_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(180455528493038000.4806)
,p_name=>'Edit Task Actions'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180455741728038001.4806)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\590D\5236\5F85\529E\4E8B\9879')
,p_list_item_link_target=>'f?p=&APP_ID.:3009:&SESSION.::&DEBUG.:3009:P3009_TASK_ID:&P3010_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(314430519647789435.4806)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\6DFB\52A0\6587\4EF6')
,p_list_item_link_target=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:4:P4_COMPONENT_ID,P4_GO_TO_PAGE:&P3010_ID.,3010:'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P3010_ID'
,p_security_scheme=>wwv_flow_api.id(323649802527269223)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/team
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(180799409759672829.4806)
,p_name=>'Team'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180800525086672836.4806)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\91CC\7A0B\7891')
,p_list_item_link_target=>'f?p=&APP_ID.:6006:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'team-dev-milestones'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180800217905672835.4806)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\529F\80FD')
,p_list_item_link_target=>'f?p=&APP_ID.:9010:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'team-dev-features'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180799911838672834.4806)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5F85\529E\4E8B\9879')
,p_list_item_link_target=>'f?p=&APP_ID.:3001:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'team-dev-todos'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180859515402507013.4806)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Bug'
,p_list_item_link_target=>'f?p=&APP_ID.:3501:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'team-dev-bugs'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(438648079811843849.4806)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\53CD\9988')
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'||wwv_flow.LF||
''
,p_list_item_icon=>'team-dev-feedback'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/events_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(180942927305620202.4806)
,p_name=>'events tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177384013421376441.4806)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\9762\677F')
,p_list_item_link_target=>'f?p=&APP_ID.:6006:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6006'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180943112446620204.4806)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\62A5\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:6000:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(180943422141620210.4806)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65E5\5386')
,p_list_item_link_target=>'f?p=&APP_ID.:6003:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6003'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(182424322070920902.4806)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\6309\6240\6709\8005')
,p_list_item_link_target=>'f?p=&APP_ID.:6002:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6002,6004'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183450514522693455.4806)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\6309\91CC\7A0B\7891\7EDF\8BA1\7684\529F\80FD')
,p_list_item_link_target=>'f?p=&APP_ID.:6005:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6005'
);
end;
/
prompt --application/shared_components/navigation/lists/team_development_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(181214517334339823.4806)
,p_name=>'Team Development Utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(699001137367348396.4806)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\6240\6709\5B9E\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4000,6006,9010,3001,3501,8012'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(176636215441585427.4806)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5C0F\7EC4\5F00\53D1\8BBE\7F6E')
,p_list_item_link_target=>'f?p=&APP_ID.:3005:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-team-dev-settings'
,p_list_text_01=>unistr('\4E3A\6B64\5DE5\4F5C\533A\8BBE\7F6E\9ED8\8BA4\503C\548C\8DDF\8E2A\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3005'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(191100228151295365.4806)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\53D1\884C\7248\6982\8981')
,p_list_item_link_target=>'f?p=&APP_ID.:4050:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-release-summary'
,p_list_text_01=>unistr('\590D\67E5\5DE5\4F5C\533A\548C\5F00\53D1\8005\7EDF\8BA1\4FE1\606F\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4050'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(327445213306187937.4806)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\542F\7528\6587\4EF6')
,p_list_item_link_target=>'f?p=4350:17:&SESSION.'
,p_list_item_icon=>'icon-enable-files'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_team_file.team_dev_file_enabled'
,p_list_text_01=>unistr('\542F\7528\6587\4EF6\8D44\6599\6863\6848\5E93\5E76\6307\5B9A\6587\4EF6\5927\5C0F\9650\5236\3002')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(12522018023518081)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(83498459836924798.4806)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\7981\7528\6587\4EF6')
,p_list_item_link_target=>'f?p=4350:17:&SESSION.'
,p_list_item_icon=>'icon-enable-files'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_team_file.team_dev_file_enabled'
,p_list_text_01=>'Enable the file repository and specify the file size limit.'
,p_security_scheme=>wwv_flow_api.id(12522018023518081)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(698992057860150424.4806)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\529F\80FD\5B9E\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=&APP_ID.:9013:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-feature-utilities'
,p_list_text_01=>unistr('\5206\914D\91CC\7A0B\7891\6216\4FEE\6539\529F\80FD\7684\622A\6B62\65E5\671F\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9013,3,9012,9014,9015'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(237042927529618472.4806)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\7BA1\7406\4FA7\91CD\9886\57DF')
,p_list_item_link_target=>'f?p=&APP_ID.:9020:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-manage-focus-areas'
,p_list_text_01=>unistr('\66F4\65B0\529F\80FD\4FA7\91CD\9886\57DF\540D\79F0\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(698991194662150422.4806)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\66F4\65B0\5206\914D\4EBA\5458')
,p_list_item_link_target=>'f?p=&APP_ID.:6004:&SESSION.::&DEBUG.:6004:::'
,p_list_item_icon=>'icon-utilities-update-assignees'
,p_list_text_01=>unistr('\6267\884C\5206\914D\7ED9\6307\5B9A\7528\6237\7684\7EC4\4EF6\7684\6210\6279\66F4\65B0\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6004,6007'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(319180508506565032.4806)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\67E5\770B\6587\4EF6')
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-folder-files'
,p_list_text_01=>unistr('\67E5\770B\4E0A\8F7D\5230\5C0F\7EC4\5F00\53D1\7684\6587\4EF6\7684\8BE6\7EC6\4FE1\606F\3002')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(323649802527269223)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(698991405966150423.4806)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\6E05\9664\6570\636E')
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilites-purge-data'
,p_list_text_01=>unistr('\6E05\9664\6240\9009\7EC4\4EF6\7684\6240\6709\6570\636E\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181215026983339828.4806)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\7BA1\7406\65B0\95FB')
,p_list_item_link_target=>'f?p=&APP_ID.:7000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-news'
,p_list_text_01=>unistr('\7BA1\7406\663E\793A\5728 Application Express \4E3B\9875\548C\5C0F\7EC4\5F00\53D1\4E0A\7684\65B0\95FB\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181214724033339828.4806)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\7BA1\7406\94FE\63A5')
,p_list_item_link_target=>'f?p=&APP_ID.:5000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-links'
,p_list_text_01=>unistr('\7BA1\7406\7531\5F00\53D1\8005\5B9A\4E49\7684\94FE\63A5\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/feature_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(181255317679390139.4806)
,p_name=>'Feature Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(182994215400272378.4806)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\9762\677F')
,p_list_item_link_target=>'f?p=&APP_ID.:9010:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9010'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181255519730390139.4806)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\62A5\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:9000:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(79417902595898958.4806)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\6811')
,p_list_item_link_target=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(182713212493969016.4806)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65E5\5386')
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9007'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183068615323767106.4806)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5386\53F2\8BB0\5F55')
,p_list_item_link_target=>'f?p=&APP_ID.:9011:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9011'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(182734736931515304.4806)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\8FDB\5EA6\65E5\5FD7')
,p_list_item_link_target=>'f?p=&APP_ID.:9008:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9008'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181255815187390140.4806)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\4FA7\91CD\9886\57DF')
,p_list_item_link_target=>'f?p=&APP_ID.:9003:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9003,9020'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33711911119323761.4806)
,p_list_item_display_sequence=>75
,p_list_item_link_text=>unistr('\5BA1\6279\72B6\6001 ')
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_required_patch=>wwv_flow_api.id(33112014865229171.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181841832378565088.4806)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\6240\6709\8005')
,p_list_item_link_target=>'f?p=&APP_ID.:9005:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9005'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18923522881031186.4806)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\5B9E\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=&APP_ID.:9013:&SESSION.:FF:&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9012:9013'
);
end;
/
prompt --application/shared_components/navigation/lists/bug_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(181386722752174658.4806)
,p_name=>'Bug Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181387235754174663.4806)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\9762\677F')
,p_list_item_link_target=>'f?p=&APP_ID.:3501:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3501'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181386910901174659.4806)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\62A5\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:3500:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3500'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(177401026768493838.4806)
,p_list_item_display_sequence=>21
,p_list_item_link_text=>unistr('\65E5\5386')
,p_list_item_link_target=>'f?p=&APP_ID.:3504:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3504'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(182525915786691140.4806)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6309\5F00\53D1\8005\7EDF\8BA1')
,p_list_item_link_target=>'f?p=&APP_ID.:3503:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3503'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192636619765062518.4806)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\6309\5929\7EDF\8BA1')
,p_list_item_link_target=>'f?p=&APP_ID.:3506:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3506'
);
end;
/
prompt --application/shared_components/navigation/lists/feedback_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(181722621988545302.4806)
,p_name=>'Feedback Tabs'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_bug_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(323689025720368575.4806)
,p_name=>'Edit Bug Actions'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(323689518619368576.4806)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\6DFB\52A0\6587\4EF6')
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:14:P14_COMPONENT_ID,P14_GO_TO_PAGE:&P3502_ID.,3502:'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P3502_ID'
,p_security_scheme=>wwv_flow_api.id(323649802527269223)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_feature_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(325168821012802477.4806)
,p_name=>'Edit Feature Actions'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(325169317257802479.4806)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\6DFB\52A0\6587\4EF6')
,p_list_item_link_target=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:16:P16_COMPONENT_ID,P16_GO_TO_PAGE:&P9001_ID.,9001:'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P9001_ID'
,p_security_scheme=>wwv_flow_api.id(323649802527269223)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697622747626463876.4806)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697622910977463879.4806)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\7BA1\7406')
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697623203951463880.4806)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697623539914463880.4806)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('\7BA1\7406\670D\52A1')
,p_security_scheme=>wwv_flow_api.id(12522018023518081)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697623851156463880.4806)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\7BA1\7406\670D\52A1')
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697623539914463880.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697624107320463880.4806)
,p_list_item_display_sequence=>215
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(697623539914463880.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697624464438463881.4806)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('\53D1\51FA\670D\52A1\8BF7\6C42')
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(697623539914463880.4806)
,p_security_scheme=>wwv_flow_api.id(12522018023518081)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697624782278463881.4806)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('\8BBE\7F6E\5DE5\4F5C\533A\9996\9009\9879')
,p_list_item_link_target=>'f?p=4350:17:&SESSION.::NO:RP::'
,p_parent_list_item_id=>wwv_flow_api.id(697623539914463880.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697625052130463881.4806)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\7F16\8F91\516C\544A')
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697623539914463880.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697625379538463881.4806)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('\5DE5\4F5C\533A\4F7F\7528\60C5\51B5')
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697623539914463880.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697625656669463881.4806)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\7BA1\7406\7528\6237\548C\7EC4')
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(12522018023518081)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697625907271463881.4806)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('\76D1\89C6\6D3B\52A8')
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(10594702293226668)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697626244093463882.4806)
,p_list_item_display_sequence=>500
,p_list_item_link_text=>unistr('\9762\677F')
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(10594702293226668)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1250954481019228616.4806)
,p_list_item_display_sequence=>510
,p_list_item_link_text=>unistr('\66F4\6539\6211\7684\5BC6\7801')
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_security_scheme=>wwv_flow_api.id(10594702293226668)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697627751607465406.4806)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697627933140465407.4806)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\6587\6863')
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2105956678838053645.4806)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8BBA\575B')
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2185501921567580664.4806)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Oracle \6280\672F\7F51')
,p_list_item_link_target=>'http://otn.oracle.com/apex'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697628830951465408.4806)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697629127860465408.4806)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5173\4E8E')
,p_list_item_link_target=>'f?p=4350:9:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(719134156016191341.4806)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\5E94\7528\7A0B\5E8F\6784\5EFA\5668')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW::'
,p_list_item_icon_alt_attribute=>unistr('\5E94\7528\7A0B\5E8F\6784\5EFA\5668\7EC6\5316')
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_api.id(178935310597752594)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719134692997191345.4806)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\6570\636E\5E93\5E94\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:DATABASE:'
,p_parent_list_item_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719134999610191345.4806)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('Websheet \5E94\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:WEBSHEET:'
,p_parent_list_item_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719135200661191346.4806)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719135519738191346.4806)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\521B\5EFA')
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID:'
,p_parent_list_item_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719135886260191346.4806)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\5BFC\5165')
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719136174923191346.4806)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\5BFC\51FA')
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719136419059191346.4806)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719136789999191346.4806)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>unistr('\5DE5\4F5C\533A\5B9E\7528\7A0B\5E8F')
,p_parent_list_item_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719137029686191347.4806)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>unistr('\6240\6709\5DE5\4F5C\533A\5B9E\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719136789999191346.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719137349839191347.4806)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719136789999191346.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719137648995191347.4806)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>unistr('\5E94\7528\7A0B\5E8F\6784\5EFA\5668\9ED8\8BA4\8BBE\7F6E')
,p_list_item_link_target=>'f?p=4000:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719136789999191346.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719138262683191347.4806)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>unistr('\5DE5\4F5C\533A\4E3B\9898')
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719136789999191346.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719138506564191347.4806)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>unistr('\5E94\7528\7A0B\5E8F\7EC4')
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_api.id(719136789999191346.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719138891617191347.4806)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>unistr('Application Express \89C6\56FE')
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719136789999191346.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719139116361191347.4806)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>unistr('\4EA4\53C9\5E94\7528\7A0B\5E8F\62A5\8868')
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719136789999191346.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719139403219191347.4806)
,p_list_item_display_sequence=>169
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719139770820191348.4806)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('\8FC1\79FB')
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719134345455191344.4806)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719140074893191349.4806)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('SQL \5DE5\4F5C\5BA4')
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>unistr('SQL \5DE5\4F5C\5BA4\7EC6\5316')
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_api.id(178935719467752595)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719140369667191349.4806)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\5BF9\8C61\6D4F\89C8\5668')
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719140074893191349.4806)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719140663021191349.4806)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('SQL \547D\4EE4')
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719140074893191349.4806)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719140988352191349.4806)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('SQL \811A\672C')
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719140074893191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\5B9E\7528\7A0B\5E8F')
,p_parent_list_item_id=>wwv_flow_api.id(719140074893191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719141510827191350.4806)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>unistr('\6240\6709\5B9E\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719141854229191350.4806)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719142147795191350.4806)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>unistr('\6570\636E\5DE5\4F5C\5BA4')
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719142438351191350.4806)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>unistr('\67E5\8BE2\6784\5EFA\5668')
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713691539408432182.4806)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>'Quick SQL'
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(671324563742051451.4806)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>unistr('\793A\4F8B\6570\636E\96C6')
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719142760307191350.4806)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>unistr('\751F\6210 DDL')
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719143006624191350.4806)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>unistr('\7528\6237\754C\9762\9ED8\8BA4\8BBE\7F6E')
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719144508438191351.4806)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>unistr('\65B9\6848\6BD4\8F83')
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719143349219191351.4806)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('\8868\4E0A\7684\65B9\6CD5')
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719144897157191351.4806)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>unistr('\56DE\6536\7AD9')
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719143990099191351.4806)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>unistr('\5BF9\8C61\62A5\8868')
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719143640776191351.4806)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>unistr('\5173\4E8E\6570\636E\5E93')
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719144261435191351.4806)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>unistr('\6570\636E\5E93\76D1\89C6\5668')
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(719141288001191349.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719145141725191351.4806)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>unistr('RESTful \670D\52A1')
,p_list_item_link_target=>'f?p=4850:500:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719140074893191349.4806)
,p_security_scheme=>wwv_flow_api.id(803082126936803559)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719145400878191351.4806)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\5C0F\7EC4\5F00\53D1')
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>unistr('\5C0F\7EC4\5F00\53D1\7EC6\5316')
,p_list_text_01=>'tab-team-dev'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719145710145191351.4806)
,p_list_item_display_sequence=>301
,p_list_item_link_text=>unistr('\6807\7B7E')
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719145400878191351.4806)
,p_security_scheme=>wwv_flow_api.id(12508906998268920)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719146001932191352.4806)
,p_list_item_display_sequence=>302
,p_list_item_link_text=>unistr('\91CC\7A0B\7891')
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719145400878191351.4806)
,p_security_scheme=>wwv_flow_api.id(12508906998268920)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719146366399191352.4806)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>unistr('\6A21\677F')
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719145400878191351.4806)
,p_security_scheme=>wwv_flow_api.id(12508906998268920)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719146649730191352.4806)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>unistr('\5B9E\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719145400878191351.4806)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719147205906191352.4806)
,p_list_item_display_sequence=>355
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719145400878191351.4806)
,p_security_scheme=>wwv_flow_api.id(12508906998268920)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719147517377191353.4806)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>unistr('\53CD\9988')
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719145400878191351.4806)
,p_security_scheme=>wwv_flow_api.id(12508906998268920)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719151794260191359.4806)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('\5E94\7528\7A0B\5E8F\5E93')
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_text_01=>'tab-apps'
,p_security_scheme=>wwv_flow_api.id(763730507596675445)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719152097034191359.4806)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>unistr('\751F\4EA7\529B\5E94\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:PACKAGE'
,p_parent_list_item_id=>wwv_flow_api.id(719151794260191359.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719152339093191360.4806)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>unistr('\793A\4F8B\5E94\7528\7A0B\5E8F')
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:SAMPLE'
,p_parent_list_item_id=>wwv_flow_api.id(719151794260191359.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(780160520641366871.4806)
,p_list_item_display_sequence=>425
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719151794260191359.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719152684557191360.4806)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>unistr('\7BA1\7406')
,p_list_item_link_target=>'f?p=4750:6:&SESSION.::&DEBUG.:6:'
,p_parent_list_item_id=>wwv_flow_api.id(719151794260191359.4806)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/to_do_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1267129315456592267.4806)
,p_name=>'To Do Utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1267133197132592277.4806)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\81EA\52A8\521B\5EFA\5F85\529E\4E8B\9879')
,p_list_item_link_target=>'f?p=&APP_ID.:555:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-item-native-checkbox'
,p_list_text_01=>unistr('\4E3A\5E94\7528\7A0B\5E8F\4E2D\7684\6BCF\4E2A\9875\521B\5EFA\4E00\4E2A\5F85\529E\4E8B\9879\6761\76EE')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/bug_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1267134969329603031.4806)
,p_name=>'Bug Utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1267136323477603035.4806)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\63A8\8FDF\8FC7\671F Bug')
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-bugs'
,p_list_text_01=>unistr('\66F4\65B0 Bug \7684\4F30\8BA1\4FEE\590D\65E5\671F\3002')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1121062902345547.4806)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2066937132411011.4806)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14849019738940932.4806)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91983577878572373.4806)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(269459734822405056.4806)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.D3.BARCHART'
,p_attribute_01=>'3'
,p_attribute_02=>'1.333'
,p_attribute_03=>'480'
,p_attribute_04=>'WINDOW'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765073169366712055.4806)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831722921637993879.4806)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917638134620939913.4806)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2010983164957119080.4806)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.FLOTLINECHART2'
,p_attribute_01=>'3'
,p_attribute_02=>'1.333'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(10594702293226668.4806)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>unistr('\60A8\65E0\6743\8BBF\95EE\9762\677F\548C\76D1\89C6\6D3B\52A8\3002')
,p_reference_id=>786936829326142579.4806
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12508906998268920.4806)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\60A8\65E0\6743\7F16\8F91\5E94\7528\7A0B\5E8F')
,p_reference_id=>12480509677812756.4806
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12522018023518081.4806)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>unistr('\60A8\65E0\6743\7BA1\7406\5E94\7528\7A0B\5E8F')
,p_reference_id=>12511219858301010.4806
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178935310597752594.4806)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\65E0\6743\6267\884C\5C1D\8BD5\7684\64CD\4F5C')
,p_reference_id=>786516029127697713.4806
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178935719467752595.4806)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('\60A8\65E0\6743\4F7F\7528 SQL \5DE5\4F5C\5BA4')
,p_reference_id=>786516265251697717.4806
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178936207895752596.4806)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\6CA1\6709\4E3A\6B64\5DE5\4F5C\533A\542F\7528\5C0F\7EC4\5F00\53D1')
,p_reference_id=>786516861027697723.4806
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178936725903752596.4806)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\65E0\6743\6267\884C\5C1D\8BD5\7684\64CD\4F5C')
,p_reference_id=>786517166823697723.4806
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/team_dev_file_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(323649802527269223.4806)
,p_name=>'Team Dev File Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_team_file.team_dev_file_enabled then',
'   return true;',
'else',
'   return false;',
'end if;'))
,p_error_message=>unistr('\8BBF\95EE\6B64\9875\9700\8981\542F\7528\5C0F\7EC4\5F00\53D1\6587\4EF6\3002')
,p_reference_id=>786943600005207200.4806
,p_caching=>'NOCACHE'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(334302828068964231.4806)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>unistr('\672A\542F\7528\6784\5EFA\5668 SSO')
,p_reference_id=>6738410669854771.4806
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_packaged_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(763730507596675445.4806)
,p_name=>'APEX 5.0 Packaged App Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('\60A8\65E0\6743\5B89\88C5\6253\5305\7684\5E94\7528\7A0B\5E8F')
,p_reference_id=>786517456817697723.4806
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(803082126936803559.4806)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>unistr('\65E0\6743\6267\884C\5C1D\8BD5\7684\64CD\4F5C')
,p_reference_id=>786519856057734816.4806
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/service_requests_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(917636821099038224.4806)
,p_name=>'Service Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'' then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>unistr('\65E0\6743\6267\884C\5C1D\8BD5\7684\64CD\4F5C\3002')
,p_reference_id=>786932326296107981.4806
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(110415645851235024.4806)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(233722520158552369.4806)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'    p_app_id           => wwv_flow.g_x01,',
'    p_get_apps_list    => wwv_flow.g_x02);'))
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(33153215800713938.4806)
,p_name=>'AJAX_WS_ACTION'
,p_protection_level=>'N'
,p_item_comment=>'FILTER,SEARCH,SORT'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(33181323709962234.4806)
,p_name=>'AJAX_WS_COLUMN'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(33180541239957808.4806)
,p_name=>'AJAX_WS_FILTER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(33179128079954045.4806)
,p_name=>'AJAX_WS_FILTER_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(34083233712339933.4806)
,p_name=>'AJAX_WS_NUM'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(33928836911656845.4806)
,p_name=>'APPROVAL_STATUS'
,p_data_type=>'NUMBER'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(801651311570449721.4806)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(169814614837186180.4806)
,p_name=>'F4800_LAST_VIEW'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(180658423454118341.4806)
,p_name=>'FOLDER_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(163459519314215893.4806)
,p_name=>'FSP_AFTER_LOGIN_URL'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(16610135414623003.4806)
,p_name=>'ITEM_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(206095726184433697.4806)
,p_name=>'MSG_COMPANY'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185320732159624577.4806)
,p_name=>'OWNER_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(188481619794440169.4806)
,p_name=>'RPT_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(180806016965573376.4806)
,p_name=>'SHOWNAV'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(16641230227747252.4806)
,p_name=>'TEMPORARY_ACTION'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(31763840957610292.4806)
,p_name=>'TEMPORARY_FILTER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(16640826764746255.4806)
,p_name=>'TEMPORARY_FOLDER'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(16614640281775748.4806)
,p_name=>'TEMPORARY_ITEM'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(12717221777286132.4806)
,p_name=>'WORKGROUP'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(12724838342937126.4806)
,p_name=>'WORKGROUP_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(32477213082757170.4806)
,p_name=>'WORKSHEET_FILTER_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(87594330460767481.4806)
,p_name=>'WORKSHEET_NAME'
,p_protection_level=>'I'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(801651702005456462.4806)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>unistr('\65E0\6CD5\8BA1\7B97\5DE5\4F5C\533A\540D\79F0\3002')
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(33929005212661669.4806)
,p_computation_sequence=>10
,p_computation_item=>'APPROVAL_STATUS'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'QUERY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'select default_rpt_feature_type_id from wwv_flow_task_defaults'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(180806622505575037.4806)
,p_computation_sequence=>10
,p_computation_item=>'SHOWNAV'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'Y'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/acl_priv
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12858825198618693.4806)
,p_lov_name=>'ACL_PRIV'
,p_lov_query=>'.'||wwv_flow_api.id(12858825198618693.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12859113418618697.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\67E5\770B\5E76\7F16\8F91')
,p_lov_return_value=>'EDIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12859319547618699.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4EC5\67E5\770B')
,p_lov_return_value=>'VIEW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/all_or_selected_or_null_row_domain
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(14875510890985303.4806)
,p_lov_name=>'ALL OR SELECTED OR NULL (ROW DOMAIN)'
,p_lov_query=>'.'||wwv_flow_api.id(14875510890985303.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14875718879985304.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6240\6709\884C')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14875917672985305.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6240\9009\884C')
,p_lov_return_value=>'SELECTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(28757832908555986.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\7A7A\884C')
,p_lov_return_value=>'NULL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_name_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181640725424619181.4806)
,p_lov_name=>'APPLICATION NAME RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'from   wwv_flows f',
'where  ',
'       security_group_id = :flow_security_group_id and',
'       not exists (',
'       select null from wwv_flow_language_map',
'       where translation_flow_id = f.id and ',
'         security_group_id = :flow_security_group_id) and',
'       (',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :app_user and ',
'             flow_id is null and ',
'             security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :app_user and ',
'             flow_id = f.id and ',
'             security_group_id = :flow_security_group_id ))'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/assignee_updates
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(503089027462310465.4806)
,p_lov_name=>'ASSIGNEE UPDATES'
,p_lov_query=>'.'||wwv_flow_api.id(503089027462310465.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(503089223453310470.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\529F\80FD\5206\914D\7ED9')
,p_lov_return_value=>'FA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(503089411536310474.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\529F\80FD\8D21\732E\8005')
,p_lov_return_value=>'FC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(503089620896310474.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\91CC\7A0B\7891\6240\6709\8005')
,p_lov_return_value=>'MA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(503089826628310474.4806)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5F85\529E\4E8B\9879\5206\914D\7ED9')
,p_lov_return_value=>'TA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(503090001544310474.4806)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\5F85\529E\4E8B\9879\8D21\732E\8005')
,p_lov_return_value=>'TC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(503090225260310474.4806)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('Bug \5206\914D\7ED9')
,p_lov_return_value=>'BA'
);
end;
/
prompt --application/shared_components/user_interface/lovs/attachment_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(186460639245023486.4806)
,p_lov_name=>'ATTACHMENT OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(186460639245023486.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(186460834503023487.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5728\62A5\8868\4E2D\663E\793A\65F6\5E26\6709\56FE\6807\548C\540D\79F0')
,p_lov_return_value=>'BOTH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(186461025628023487.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5728\62A5\8868\4E2D\663E\793A\65F6\53EA\5E26\6709\540D\79F0')
,p_lov_return_value=>'NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(186461210680023487.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\663E\793A\65F6\53EA\5E26\6709\56FE\6807')
,p_lov_return_value=>'ICON'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_on
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(31643224570997270.4806)
,p_lov_name=>'BREAK ON'
,p_lov_query=>'.'||wwv_flow_api.id(31643224570997270.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(32811622636141853.4806)
,p_lov_disp_sequence=>0
,p_lov_disp_value=>unistr('\65E0\5206\6BB5')
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(31643426950997271.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5217 1')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(31643622603997271.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5217 1 \548C\5217 2')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(31643818047997271.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5217 1, \5217 2 \548C\5217 3')
,p_lov_return_value=>'3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/bug_assigned_to
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(190136629997316055.4806)
,p_lov_name=>'BUG ASSIGNED TO'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct assigned_to d, assigned_to r',
'  from wwv_flow_bugs b',
' where security_group_id = :flow_security_group_id',
'   and assigned_to is not null'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/bug_priority
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177118604204266170.4806)
,p_lov_name=>'BUG PRIORITY'
,p_lov_query=>'select id||''. ''||the_name d, id from wwv_flow_bug_priority order by 1'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/bug_severity
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181415542061549256.4806)
,p_lov_name=>'BUG SEVERITY'
,p_lov_query=>'select id||''. ''||the_name the_name, id from wwv_flow_bug_severity order by 1'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/bug_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181444239646624213.4806)
,p_lov_name=>'BUG STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name the_name, id ',
'from wwv_flow_bug_status_codes',
'order by id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/bugs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(324308720167580075.4806)
,p_lov_name=>'BUGS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select bug_title d, id r',
'from   wwv_flow_bugs',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/bug_calendar_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(190135001469298376.4806)
,p_lov_name=>'BUG_CALENDAR_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(190135001469298376.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(190135205120298397.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\672A\89E3\51B3\4F46\8BBE\6709\4F30\8BA1\7684\89E3\51B3\65E5\671F\7684 Bug')
,p_lov_return_value=>'OPEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(190135410613298397.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\672A\89E3\51B3\4E14\6CA1\6709\4F30\8BA1\89E3\51B3\65E5\671F\7684 Bug')
,p_lov_return_value=>'OPEN2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(190135612636298397.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5DF2\89E3\51B3')
,p_lov_return_value=>'CLOSED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/comparison_expressions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(166223914656088196.4806)
,p_lov_name=>'COMPARISON EXPRESSIONS'
,p_lov_query=>'.'||wwv_flow_api.id(166223914656088196.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166224125218088196.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'='
,p_lov_return_value=>'='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166223317434088196.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'>'
,p_lov_return_value=>'>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(186598415366218105.4806)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'>='
,p_lov_return_value=>'>='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166224536835088196.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'<'
,p_lov_return_value=>'<'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(186599121946219977.4806)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>'<='
,p_lov_return_value=>'<='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166224913454088196.4806)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\7C7B\4F3C')
,p_lov_return_value=>'LIKE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(188468637689237146.4806)
,p_lov_disp_sequence=>51
,p_lov_disp_value=>unistr('\4E0D\7C7B\4F3C')
,p_lov_return_value=>'not like '
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166225133290088197.4806)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'!='
,p_lov_return_value=>'!='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14710821441124594.4806)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\4E3A\7A7A\503C')
,p_lov_return_value=>'is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14711224558125535.4806)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\4E0D\4E3A\7A7A\503C')
,p_lov_return_value=>'is not null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(33384633857790780.4806)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\5728')
,p_lov_return_value=>'in'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(33384935935791374.4806)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('\4E0D\5728')
,p_lov_return_value=>'not in'
);
end;
/
prompt --application/shared_components/user_interface/lovs/control_break_groups
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(31654237047076522.4806)
,p_lov_name=>'CONTROL BREAK GROUPS'
,p_lov_query=>'.'||wwv_flow_api.id(31654237047076522.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(31654419772076523.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6240\6709\63A7\5236\5206\6BB5\7EC4')
,p_lov_return_value=>'ALL_GROUPS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(31654610156076523.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4E00\4E2A\63A7\5236\5206\6BB5\7EC4')
,p_lov_return_value=>'ONE_GROUP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/default_domain
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(186424519020882375.4806)
,p_lov_name=>'DEFAULT DOMAIN'
,p_lov_query=>'.'||wwv_flow_api.id(186424519020882375.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(186424738232882375.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\521B\5EFA\6216\66F4\65B0\884C\5E76\4E14\6CA1\6709\63D0\4F9B\503C\65F6')
,p_lov_return_value=>'WHEN_NULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(186424936237882376.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4EC5\5728\521B\5EFA\65B0\884C\65F6')
,p_lov_return_value=>'WHEN_INSERTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/delete_feedback_entry
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(182068614306890492.4806)
,p_lov_name=>'DELETE FEEDBACK ENTRY'
,p_lov_query=>'.'||wwv_flow_api.id(182068614306890492.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(182068814577890528.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5220\9664\53CD\9988\6761\76EE')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/delete_report_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(32600241178193817.4806)
,p_lov_name=>'DELETE REPORT OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(32600241178193817.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(32600437169193818.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6240\6709\547D\540D\62A5\8868')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(32600632229193821.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5F53\524D\547D\540D\62A5\8868')
,p_lov_return_value=>'CURRENT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_links_as
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(23360913855307503.4806)
,p_lov_name=>'DISPLAY LINKS AS'
,p_lov_query=>'.'||wwv_flow_api.id(23360913855307503.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23361133038307505.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\672A\6392\5E8F\7684\9879\76EE\7B26\53F7\5217\8868')
,p_lov_return_value=>'UNORDERED_LIST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_rows
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(169747640792042264.4806)
,p_lov_name=>'DISPLAY ROWS'
,p_lov_query=>'.'||wwv_flow_api.id(169747640792042264.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169751015297044400.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169751417374044965.4806)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169747819516042265.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169748023121042265.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169748239791042265.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169748428211042265.4806)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169748623584042265.4806)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169748829840042265.4806)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169749036246042265.4806)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169749215038042265.4806)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169749416001042265.4806)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169749638637042265.4806)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169749839017042265.4806)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(185948111629779291.4806)
,p_lov_disp_sequence=>9999
,p_lov_disp_value=>unistr('\5168\90E8')
,p_lov_return_value=>'100000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/event_name_and_date_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174624323579332551.4806)
,p_lov_name=>'EVENT NAME AND DATE RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select event_name||'' - ''||event_date d, id r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id ',
'order by event_date'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/event_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181148130682407109.4806)
,p_lov_name=>'EVENT TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct event_type d, event_type r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and event_type is not null',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/events_show_all_or_future
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181150319263479525.4806)
,p_lov_name=>'EVENTS, SHOW ALL OR FUTURE'
,p_lov_query=>'.'||wwv_flow_api.id(181150319263479525.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181150512014479525.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6240\6709\4E8B\4EF6')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181150735413479529.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\672A\6765\7684\4E8B\4EF6')
,p_lov_return_value=>'FUTURE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_all_open_closed
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181985829388791029.4806)
,p_lov_name=>'EXPORT ALL, OPEN, CLOSED'
,p_lov_query=>'.'||wwv_flow_api.id(181985829388791029.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181986029982791031.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5168\90E8')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181986213278791033.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\672A\89E3\51B3')
,p_lov_return_value=>'Open'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181986425649791033.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5DF2\89E3\51B3')
,p_lov_return_value=>'Closed'
);
end;
/
prompt --application/shared_components/user_interface/lovs/expression_types_column_value
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184463020498784871.4806)
,p_lov_name=>'EXPRESSION TYPES (COLUMN/VALUE)'
,p_lov_query=>'.'||wwv_flow_api.id(184463020498784871.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184463332627784872.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\503C')
,p_lov_return_value=>'VALUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184463541791784872.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5217')
,p_lov_return_value=>'COLUMN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_desirability
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(430963613501118062.4806)
,p_lov_name=>'FEATURE DESIRABILITY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name d, id',
'from wwv_flow_feature_desirability',
'order by id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_focus_areas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181588909964498370.4806)
,p_lov_name=>'FEATURE FOCUS AREAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct focus_area d, focus_area r',
'from wwv_flow_features ',
'where security_group_id = :flow_security_group_id',
'and focus_area is not null',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_name_and_release_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(176718220535564610.4806)
,p_lov_name=>'FEATURE NAME AND RELEASE RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select feature_name||'' - ''||release d, id r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_priority
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(182204040473204409.4806)
,p_lov_name=>'FEATURE PRIORITY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name d, id',
'from   wwv_flow_feature_priorities',
'order by id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181252517969286098.4806)
,p_lov_name=>'FEATURE STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select status_name ||'' - ''||pct_complete||''%'' d, pct_complete r',
'from wwv_flow_feature_def_st_codes',
'order by pct_complete'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(33730633296764420.4806)
,p_lov_name=>'FEATURE TYPE'
,p_lov_query=>'select type_name, id from wwv_flow_feature_types'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_select_feature_name_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181328725841948501.4806)
,p_lov_name=>'FEATURE, SELECT FEATURE NAME RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select feature_id||'' - ''||feature_name d, id r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id',
'order by feature_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/features
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(325167106635783921.4806)
,p_lov_name=>'FEATURES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select feature_name d, id r',
'from   wwv_flow_features',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/features_distinct_release
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177704407203693195.4806)
,p_lov_name=>'FEATURES DISTINCT RELEASE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/features_distinct_app_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(176685619904751083.4806)
,p_lov_name=>'FEATURES, DISTINCT APP RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||''. ''||f.name d, f.id r',
'from (',
'select distinct application_id d, application_id r',
'from wwv_flow_features',
'where application_id is not null and security_group_id = :flow_security_group_id',
') d,',
'wwv_flows f',
'where f.id = d.d',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/features_doc_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(176614400195155309.4806)
,p_lov_name=>'FEATURES, DOC STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name the_name, id ',
'from wwv_flow_feature_docstatus',
'order by id',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181979734302622196.4806)
,p_lov_name=>'FEEDBACK STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name the_name, id ',
'from wwv_flow_feedback_status ',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(182036628376434825.4806)
,p_lov_name=>'FEEDBACK TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select the_name, id ',
'from WWV_FLOW_FEEDBACK_TYPES',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_all_open_closed
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181980620066665432.4806)
,p_lov_name=>'FEEDBACK, ALL, OPEN, CLOSED'
,p_lov_query=>'.'||wwv_flow_api.id(181980620066665432.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181980838923665432.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5168\90E8')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(190115110800149685.4806)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('\672A\89E3\51B3')
,p_lov_return_value=>'OPEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181981240516665442.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5DF2\89E3\51B3')
,p_lov_return_value=>'CLOSED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_logged_as
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1498901122193788933.4806)
,p_lov_name=>'FEEDBACK_LOGGED_AS'
,p_lov_query=>'.'||wwv_flow_api.id(1498901122193788933.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1498901421388788934.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Bug'
,p_lov_return_value=>'Bug'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1498901766400788941.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5F85\529E\4E8B\9879')
,p_lov_return_value=>'To Do'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1498902036624788941.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\529F\80FD')
,p_lov_return_value=>'Feature'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_rating
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1928042759037766.4806)
,p_lov_name=>'FEEDBACK_RATING'
,p_lov_query=>'.'||wwv_flow_api.id(1928042759037766.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1928313019037775.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6B63\9762')
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1928700205037776.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4E2D\6027')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1929175343037776.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\8D1F\9762')
,p_lov_return_value=>'1'
);
end;
/
prompt --application/shared_components/user_interface/lovs/hr_column_names
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(171492616793040784.4806)
,p_lov_name=>'HR COLUMN NAMES'
,p_lov_query=>'.'||wwv_flow_api.id(171492616793040784.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(171492929727040784.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\540D')
,p_lov_return_value=>'FIRST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(171493124935040784.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\59D3')
,p_lov_return_value=>'LAST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(171493339593040784.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5168\540D')
,p_lov_return_value=>'FULL_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(171493519548040784.4806)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\7535\5B50\90AE\4EF6\5730\5740')
,p_lov_return_value=>'EMAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/hr_column_names_for_seeding
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(175479827936740965.4806)
,p_lov_name=>'HR COLUMN NAMES (FOR SEEDING)'
,p_lov_query=>'.'||wwv_flow_api.id(175479827936740965.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175480123485740966.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\540D')
,p_lov_return_value=>'FIRST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175480323633740966.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\59D3')
,p_lov_return_value=>'LAST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175480510151740966.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\7535\5B50\90AE\4EF6\5730\5740')
,p_lov_return_value=>'EMAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175480738586740966.4806)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6B63\5411\540D\79F0')
,p_lov_return_value=>'FORWARD_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175483029452750855.4806)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\53CD\5411\540D\79F0')
,p_lov_return_value=>'REVERSE_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175483335685752691.4806)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'GUID'
,p_lov_return_value=>'USERID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175483709844754696.4806)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\81EA\7531\9009\62E9\6807\9898')
,p_lov_return_value=>'TITLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175484118155757064.4806)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\6210\672C\4E2D\5FC3')
,p_lov_return_value=>'COST_CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175484421272757983.4806)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\7EC4\7EC7')
,p_lov_return_value=>'ORGANIZATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175484825081759096.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\529E\516C\7535\8BDD')
,p_lov_return_value=>'WORK_PHONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175485129929760441.4806)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\529E\516C\5927\697C')
,p_lov_return_value=>'WORK_BUILDING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175485434431761780.4806)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\529E\516C\697C\5C42')
,p_lov_return_value=>'WORK_FLOOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175485739972763355.4806)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\529E\516C\5BA4\7535\8BDD\53F7\7801')
,p_lov_return_value=>'WORK_OFFICE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175486112399764866.4806)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\529E\516C\5730\5740')
,p_lov_return_value=>'WORK_ADDR1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175486717593766340.4806)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\5DE5\4F5C\57CE\5E02')
,p_lov_return_value=>'WORK_CITY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175487320710767297.4806)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\5DE5\4F5C\7701/\5E02/\81EA\6CBB\533A')
,p_lov_return_value=>'WORK_STATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175487725905768767.4806)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\5DE5\4F5C\90AE\7F16')
,p_lov_return_value=>'WORK_ZIP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175488031792770521.4806)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\5DE5\4F5C\56FD\5BB6/\5730\533A')
,p_lov_return_value=>'WORK_COUNTRY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175488637333772130.4806)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('\76F4\63A5\4E0B\5C5E')
,p_lov_return_value=>'DIRECTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175489041488773259.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\76F4\63A5\4E0B\5C5E\603B\6570')
,p_lov_return_value=>'TOTAL_REPORTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175489312530774345.4806)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('\662F\5426\662F\7ECF\7406?')
,p_lov_return_value=>'IS_MANAGER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/limit_to_features_80_or_100
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(63272807204082822.4806)
,p_lov_name=>'LIMIT TO FEATURES 80 OR 100'
,p_lov_query=>'.'||wwv_flow_api.id(63272807204082822.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(63273002333082825.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\53EA\5B8C\6210\4E86\4E0D\8DB3 80% \7684\529F\80FD')
,p_lov_return_value=>'80'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(63273227170082829.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\53EA\5B8C\6210\4E86\4E0D\8DB3 100% \7684\529F\80FD')
,p_lov_return_value=>'100'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lov_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(97566815502348764.4806)
,p_lov_name=>'LOV_FROM'
,p_lov_query=>'.'||wwv_flow_api.id(97566815502348764.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(97567311610348766.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5171\4EAB\503C\5217\8868')
,p_lov_return_value=>'SHARED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(97567112520348766.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4E0D\540C\5217\503C')
,p_lov_return_value=>'DISTINCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(97614119900567636.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\65B0\5EFA')
,p_lov_return_value=>'CREATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/milestone_dates_identified_as_selectable_p_9001
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(191503121998508791.4806)
,p_lov_name=>'MILESTONE DATES IDENTIFIED AS SELECTABLE P 9001'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select event_name||'' - ''||event_date d, id r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id ',
'and   (   id = :P9001_EVENT_ID ',
'       or nvl(SELECTABLE_FROM_FEATURES_YN,''Y'') = ''Y''',
'      )',
'and   (   :P9001_RELEASE is null',
'       or (   release = :P9001_RELEASE',
'           or release is null)',
'      )',
'order by event_date'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/milestone_name_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181898724795915784.4806)
,p_lov_name=>'MILESTONE NAME RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select event_name||'' ''||event_date event_name, id ',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id ',
'and (release = :P3502_FIX_BY_RELEASE or release is null)',
'order by event_date'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/milestone_details_view
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1158662523082475455.4806)
,p_lov_name=>'MILESTONE_DETAILS_VIEW'
,p_lov_query=>'.'||wwv_flow_api.id(1158662523082475455.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1158662806853475458.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6982\8981')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1158663029554475462.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\91CC\7A0B\7891\8BE6\7EC6\8D44\6599')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/milestone_util_actions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19986520769344853.4806)
,p_lov_name=>'MILESTONE_UTIL_ACTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(19986520769344853.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19986727810344856.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5411\529F\80FD (\4EC5\5F53\524D\672A\5206\914D\4EFB\4F55\91CC\7A0B\7891\7684\529F\80FD) \5206\914D\91CC\7A0B\7891\3002')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19986907669344857.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5C06\529F\80FD\622A\6B62\65E5\671F\8BBE\7F6E\4E3A\91CC\7A0B\7891\65E5\671F (\4EC5\5F71\54CD\529F\80FD)\3002')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(72747402475115826.4806)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\63A8\8FDF\672A\5B8C\6210\529F\80FD\7684\622A\6B62\65E5\671F\3002')
,p_lov_return_value=>'PUSH'
);
end;
/
prompt --application/shared_components/user_interface/lovs/open_tasks_all_tasks
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(180353541681151738.4806)
,p_lov_name=>'OPEN TASKS, ALL TASKS'
,p_lov_query=>'.'||wwv_flow_api.id(180353541681151738.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180353734636151750.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6240\6709\5F85\529E\4E8B\9879')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180353916302151766.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\672A\89E3\51B3')
,p_lov_return_value=>'OPEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180517615378762652.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5DF2\5B8C\6210')
,p_lov_return_value=>'COMPLETED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/open_all_closed
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(190147716283447333.4806)
,p_lov_name=>'OPEN,ALL,CLOSED'
,p_lov_query=>'.'||wwv_flow_api.id(190147716283447333.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(190148308756447333.4806)
,p_lov_disp_sequence=>0
,p_lov_disp_value=>unistr('\5168\90E8')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(190147917120447333.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\672A\89E3\51B3')
,p_lov_return_value=>'OPEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(190148105333447333.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5DF2\89E3\51B3')
,p_lov_return_value=>'CLOSED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/owner_tasks_assigned_to_todo_milestones_features_bugs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(180615541135479707.4806)
,p_lov_name=>'OWNER - TASKS, ASSIGNED TO (TODO, MILESTONES, FEATURES, BUGS)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lower(user_name) d, lower(user_name) r ',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'union',
'select lower(d) d, lower(r) r from (',
'    select distinct assigned_to d, assigned_to r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and ',
'         assigned_to is not null',
'    union',
'    select distinct CONTRIBUTOR d, CONTRIBUTOR r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and CONTRIBUTOR is not null',
'    union',
'    select distinct EVENT_OWNER d, EVENT_OWNER r ',
'    from wwv_flow_events ',
'    where security_group_id = :flow_security_group_id and ',
'          event_owner is not null',
'    union',
'    select distinct feature_OWNER d, feature_OWNER r ',
'    from wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_owner is not null',
'    union ',
'    select distinct feature_contributor d, feature_contributor r ',
'    from  wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_contributor is not null',
'    union',
'    select distinct assigned_to d, assigned_to r ',
'    from wwv_flow_bugs',
'    where security_group_id = :flow_security_group_id and ',
'          assigned_to is not null',
') ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1000_show
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6942420153454264.4806)
,p_lov_name=>'P1000 SHOW'
,p_lov_query=>'.'||wwv_flow_api.id(6942420153454264.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6942707144454281.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5168\90E8')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6942911606454284.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6211\7684\5206\914D')
,p_lov_return_value=>'MINE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6943116936454284.4806)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\6211\7684\6253\5F00\9879')
,p_lov_return_value=>'MY_OPEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6943319712454284.4806)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\6240\6709\6253\5F00\9879')
,p_lov_return_value=>'ALL_OPEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p3005_all_open_completed
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(176631412923527964.4806)
,p_lov_name=>'P3005 - ALL, OPEN, COMPLETED'
,p_lov_query=>'.'||wwv_flow_api.id(176631412923527964.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(176631601884527966.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6240\6709\5F85\529E\4E8B\9879\548C Bug')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(176631809601527974.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\672A\5B8C\6210\5F85\529E\4E8B\9879\548C Bug')
,p_lov_return_value=>'OPEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(176633318034548334.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5B8C\6210\7684\5F85\529E\4E8B\9879\548C Bug')
,p_lov_return_value=>'COMPLETED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p4005_report_or_cloud
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(191100911790309625.4806)
,p_lov_name=>'P4005 REPORT OR CLOUD'
,p_lov_query=>'.'||wwv_flow_api.id(191100911790309625.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(191101126364309628.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\62A5\8868')
,p_lov_return_value=>'REPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(191101327180309629.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6807\8BB0\4E91')
,p_lov_return_value=>'CLOUD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p72_response_type_list
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12319636506734189.4806)
,p_lov_name=>'P72_RESPONSE_TYPE_LIST'
,p_lov_query=>'.'||wwv_flow_api.id(12319636506734189.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12319934020734202.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'XML'
,p_lov_return_value=>'XML'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12320141249734205.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6587\672C')
,p_lov_return_value=>'TEXT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_position
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(183278830397199130.4806)
,p_lov_name=>'PAGE POSITION'
,p_lov_query=>'.'||wwv_flow_api.id(183278830397199130.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183279235794199131.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5DE6\5BF9\9F50')
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183279412908199131.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5C45\4E2D')
,p_lov_return_value=>'CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183279626248199131.4806)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\53F3\5BF9\9F50')
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/release
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6943531037454286.4806)
,p_lov_name=>'RELEASE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct d, r ',
'from (',
'select distinct release d, release r from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null',
'union all',
'select distinct release d, release r from wwv_flow_tasks',
'where security_group_id = :flow_security_group_id and release is not null',
'union all',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null',
'union all',
'select distinct release d, release r from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null',
'union all',
'select wwv_flow_lang.system_message(''ALL_RELEASES'') d, ''0'' r from dual',
') v ',
'order by d'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/release_task_events_bugs_features
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(180448841427975527.4806)
,p_lov_name=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/return_to_page_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3762413185027480.4806)
,p_lov_name=>'RETURN_TO_PAGE_Y'
,p_lov_query=>'.'||wwv_flow_api.id(3762413185027480.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3762730671027481.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8FD4\56DE\5230\9875')
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/row_security_restrict_by
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12876223269479081.4806)
,p_lov_name=>'ROW_SECURITY_RESTRICT_BY'
,p_lov_query=>'.'||wwv_flow_api.id(12876223269479081.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12876525437479082.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5217\8868\8FBE\5F0F')
,p_lov_return_value=>'COLUMN_EXPR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12876711116479082.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5217\4E2D\7684\7528\6237\540D')
,p_lov_return_value=>'USERNAME_IN_COLUMNS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12876925638479082.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5C42\6B21\4E2D\7684\7528\6237\540D')
,p_lov_return_value=>'USERNAME_IN_HIERARCHY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sharing_standard_codes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(170017624475485016.4806)
,p_lov_name=>'SHARING - STANDARD CODES'
,p_lov_query=>'.'||wwv_flow_api.id(170017624475485016.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170017820498485017.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E0E\6240\6709\4EBA\5171\4EAB')
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(31639129718970322.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4F7F\7528\8BBF\95EE\63A7\5236\5217\8868\5171\4EAB')
,p_lov_return_value=>'ACL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(170018239143485017.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\4E13\7528')
,p_lov_return_value=>'AVAILABLE_FOR_OWNER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_all_websheets_or_my_websheets
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(92577034740090136.4806)
,p_lov_name=>'SHOW ALL WEBSHEETS OR MY WEBSHEETS'
,p_lov_query=>'.'||wwv_flow_api.id(92577034740090136.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(92577238438090137.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6240\6709 WebSheets')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(92577438019090137.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6211\7684 WebSheets')
,p_lov_return_value=>'MINE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_chart_or_report
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177633706165992811.4806)
,p_lov_name=>'SHOW CHART OR REPORT'
,p_lov_query=>'.'||wwv_flow_api.id(177633706165992811.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177633901369992814.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\56FE\8868')
,p_lov_return_value=>'CHART'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177634106025992821.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\62A5\8868')
,p_lov_return_value=>'REPORT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_mine_or_all
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(167958939158881228.4806)
,p_lov_name=>'SHOW MINE OR ALL'
,p_lov_query=>'.'||wwv_flow_api.id(167958939158881228.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167959136695881229.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5168\90E8')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167959312105881229.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6211\7684\5DE5\4F5C\8868')
,p_lov_return_value=>'MINE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_open_closed_all
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(435191800849198766.4806)
,p_lov_name=>'SHOW OPEN CLOSED ALL'
,p_lov_query=>'.'||wwv_flow_api.id(435191800849198766.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(435192006225198767.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\672A\89E3\51B3')
,p_lov_return_value=>'OPEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(435192212501198769.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5DF2\89E3\51B3')
,p_lov_return_value=>'CLOSED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(435192401781198769.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5168\90E8')
,p_lov_return_value=>'ALL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/task_category
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(180448031730972672.4806)
,p_lov_name=>'TASK CATEGORY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct task_category, task_category r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/task_status_to_do
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(189636627778719823.4806)
,p_lov_name=>'TASK STATUS (TO DO)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select status_name ||'' - ''||pct_complete||''%'' d, pct_complete r',
'from wwv_flow_task_def_status_codes',
'order by pct_complete'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/tasks_contributor
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(180673226918024293.4806)
,p_lov_name=>'TASKS, CONTRIBUTOR'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct CONTRIBUTOR d, CONTRIBUTOR r',
'from wwv_flow_tasks',
'where security_group_id = :flow_security_group_id and CONTRIBUTOR is not null',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/tasks_select_task_attribute
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(180443426573923912.4806)
,p_lov_name=>'TASKS, SELECT TASK ATTRIBUTE'
,p_lov_query=>'.'||wwv_flow_api.id(180443426573923912.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180443625652923915.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7C7B\522B')
,p_lov_return_value=>'CATEGORY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180443836693923917.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4FA7\91CD\9886\57DF')
,p_lov_return_value=>'FOCUS_AREA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180444014968923918.4806)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\72B6\6001')
,p_lov_return_value=>'STATUS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/team_application_name_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(176683019707561817.4806)
,p_lov_name=>'TEAM, APPLICATION NAME RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||''. ''||substr(f.name,1,40) d, f.id r',
'from (',
'select distinct application_id d, application_id r',
'from wwv_flow_features',
'where application_id is not null and',
'      security_group_id = :flow_security_group_id',
'union',
'select distinct application_id d, application_id r',
'from wwv_flow_bugs',
'where application_id is not null and',
'      security_group_id = :flow_security_group_id',
'union',
'select distinct application_id d, application_id r',
'from wwv_flow_tasks',
'where application_id is not null and',
'      security_group_id = :flow_security_group_id',
') d,',
'wwv_flows f',
'where f.id = d.d and',
'      f.security_group_id = :flow_security_group_id',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/teamdev_components
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(498566904487182047.4806)
,p_lov_name=>'TEAMDEV_COMPONENTS'
,p_lov_query=>'.'||wwv_flow_api.id(498566904487182047.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(498567704950182148.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\529F\80FD')
,p_lov_return_value=>'Features'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(498567926308182148.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\91CC\7A0B\7891')
,p_lov_return_value=>'Milestones'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(498567323326182147.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5F85\529E\4E8B\9879')
,p_lov_return_value=>'To Dos'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(498567125586182051.4806)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Bug'
,p_lov_return_value=>'Bugs'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(498567503424182148.4806)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\53CD\9988')
,p_lov_return_value=>'Feedback'
);
end;
/
prompt --application/shared_components/user_interface/lovs/team_dev_file_components
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(320401714586742779.4806)
,p_lov_name=>'TEAM_DEV_FILE_COMPONENTS'
,p_lov_query=>'.'||wwv_flow_api.id(320401714586742779.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(320402013145742780.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\529F\80FD')
,p_lov_return_value=>'FEATURE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(320402310241742780.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\91CC\7A0B\7891')
,p_lov_return_value=>'MILESTONE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(320402609982742780.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5F85\529E\4E8B\9879')
,p_lov_return_value=>'TODO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(320402926463742780.4806)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Bug'
,p_lov_return_value=>'BUG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(320403203037742781.4806)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\53CD\9988')
,p_lov_return_value=>'FEEDBACK'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/text_websheets
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(183096638489837909.4806)
,p_lov_name=>'TEXT WEBSHEETS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'from   wwv_flow_ws_webpages',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/to_do_distinct_app_name_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(176684522964647850.4806)
,p_lov_name=>'TO DO DISTINCT APP NAME RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||''. ''||f.name d, f.id r',
'from (',
'select distinct application_id d, application_id r',
'from wwv_flow_tasks t',
'where application_id is not null and ',
't.security_group_id = :flow_security_group_id',
') d,',
'wwv_flows f',
'where f.id = d.d and ',
'f.security_group_id = :flow_security_group_id',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/todos
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(320956418119794142.4806)
,p_lov_name=>'TODOS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select task_name d, id r',
'from wwv_flow_tasks',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/view_as_icons_or_details
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(92521220091953403.4806)
,p_lov_name=>'VIEW AS ICONS OR DETAILS'
,p_lov_query=>'.'||wwv_flow_api.id(92521220091953403.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(92521438333953406.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\56FE\6807')
,p_lov_return_value=>'ICONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(92521614643953409.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8BE6\7EC6\8D44\6599')
,p_lov_return_value=>'DETAILS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/view_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(169897624168737614.4806)
,p_lov_name=>'VIEW MODE'
,p_lov_query=>'.'||wwv_flow_api.id(169897624168737614.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(169897827142737614.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\56FE\6807')
,p_lov_return_value=>'ICONS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_priv
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12947616823474136.4806)
,p_lov_name=>'WEBSHEET_PRIV'
,p_lov_query=>'.'||wwv_flow_api.id(12947616823474136.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12947925803474150.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\67E5\770B\5E76\7F16\8F91')
,p_lov_return_value=>'EDIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12948109574474152.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4EC5\67E5\770B')
,p_lov_return_value=>'VIEW_ONLY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_share_with
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12945614867340415.4806)
,p_lov_name=>'WEBSHEET_SHARE_WITH'
,p_lov_query=>'.'||wwv_flow_api.id(12945614867340415.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12946520680340421.4806)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\4E13\7528, \975E\5171\4EAB')
,p_lov_return_value=>'PRIVATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_column_lov_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(15764218902732864.4806)
,p_lov_name=>'WORKSHEET COLUMN LOV FROM'
,p_lov_query=>'.'||wwv_flow_api.id(15764218902732864.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15764424309732866.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E0D\540C\5217\503C')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15764620742732867.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\9759\6001\503C\57DF')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_column_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(168187614635103999.4806)
,p_lov_name=>'WORKSHEET_COLUMN_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(168187614635103999.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168187920611104000.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5B57\7B26\4E32')
,p_lov_return_value=>'STRING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168188120116104000.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6570\5B57')
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168188317783104000.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\65E5\671F')
,p_lov_return_value=>'DATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(168188520198104000.4806)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6587\6863')
,p_lov_return_value=>'DOCUMENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20193116815004946.4806)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\5DF2\8BA1\7B97')
,p_lov_return_value=>'COMPUTED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_column_types2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(47028721881143936.4806)
,p_lov_name=>'WORKSHEET_COLUMN_TYPES2'
,p_lov_query=>'.'||wwv_flow_api.id(47028721881143936.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(47029024813143938.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5B57\7B26\4E32')
,p_lov_return_value=>'STRING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(47029216830143938.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6570\5B57')
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(47029423103143938.4806)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\65E5\671F')
,p_lov_return_value=>'DATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returning_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(167678533936302622.4806)
,p_lov_name=>'YES NO RETURNING Y N'
,p_lov_query=>'.'||wwv_flow_api.id(167678533936302622.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167678839537302623.4806)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(167679028571302623.4806)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12766319962671326.4806)
,p_lov_name=>'YES NO RETURNS Y N'
,p_lov_query=>'.'||wwv_flow_api.id(12766319962671326.4806)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12766522613671329.4806)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12766730042671331.4806)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/worksheet_standard
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(87572326820728567.4806)
,p_name=>'worksheet standard'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(18919012756987238.4806)
,p_parent_id=>wwv_flow_api.id(19984001878291182.4806)
,p_short_name=>unistr('\529F\80FD\5B9E\7528\7A0B\5E8F')
,p_link=>'f?p=&APP_ID.:9012:&SESSION.::&DEBUG.:::'
,p_page_id=>9012
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(19984001878291182.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\529F\80FD\5B9E\7528\7A0B\5E8F')
,p_link=>'f?p=&APP_ID.:9013:&SESSION.::&DEBUG.:::'
,p_page_id=>9013
,p_display_when_cond_type=>'PLSQL_EXPRESSION'
,p_display_when_condition=>':REQUEST is null'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(20000504979820227.4806)
,p_parent_id=>wwv_flow_api.id(19984001878291182.4806)
,p_short_name=>unistr('\529F\80FD\5B9E\7528\7A0B\5E8F')
,p_link=>'f?p=&APP_ID.:9014:&SESSION.::&DEBUG.:::'
,p_page_id=>9014
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(33682188907967041.4806)
,p_parent_id=>wwv_flow_api.id(182994732653275307.4806)
,p_short_name=>unistr('\529F\80FD\7C7B\578B')
,p_link=>'f?p=&APP_ID.:1000:&SESSION.'
,p_page_id=>1000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(33689689189016248.4806)
,p_parent_id=>wwv_flow_api.id(33682188907967041.4806)
,p_short_name=>unistr('\7F16\8F91\529F\80FD\7C7B\578B')
,p_link=>'f?p=&APP_ID.:1001:&SESSION.'
,p_page_id=>1001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(95336931108127707.4806)
,p_parent_id=>wwv_flow_api.id(182994732653275307.4806)
,p_short_name=>unistr('\6811')
,p_link=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:::'
,p_page_id=>8
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112223807390141022.4806)
,p_parent_id=>wwv_flow_api.id(.4806)
,p_short_name=>unistr('\4E3B\9875')
,p_link=>'f?p=4500:1000:&SESSION.'
,p_page_id=>999
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174668118227882451.4806)
,p_parent_id=>wwv_flow_api.id(180296014219363207.4806)
,p_short_name=>unistr('\8FDB\5EA6')
,p_link=>'f?p=&APP_ID.:3006:&SESSION.::&DEBUG.:::'
,p_page_id=>3006
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(176628204414448706.4806)
,p_parent_id=>wwv_flow_api.id(182994732653275307.4806)
,p_short_name=>unistr('\590D\5236\529F\80FD')
,p_link=>'f?p=&APP_ID.:9017:&SESSION.::&DEBUG.:::'
,p_page_id=>9017
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(177386011681384540.4806)
,p_parent_id=>wwv_flow_api.id(179979238487556845.4806)
,p_short_name=>unistr('\91CC\7A0B\7891')
,p_link=>'f?p=&APP_ID.:6006:&SESSION.::&DEBUG.:::'
,p_page_id=>6006
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(177401632717496312.4806)
,p_parent_id=>wwv_flow_api.id(181749818186002409.4806)
,p_short_name=>unistr('\65E5\5386')
,p_link=>'f?p=&APP_ID.:3504:&SESSION.::&DEBUG.:::'
,p_page_id=>3504
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(179975541113538644.4806)
,p_parent_id=>wwv_flow_api.id(180296014219363207.4806)
,p_short_name=>unistr('\62A5\8868')
,p_link=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.:::'
,p_page_id=>3000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(179979238487556845.4806)
,p_parent_id=>wwv_flow_api.id(.4806)
,p_short_name=>unistr('<span class="u-VisuallyHidden">\5C0F\7EC4\5F00\53D1</span><span class="a-Icon icon-breadcrumb-previous" title="Team Development"></span>')
,p_link=>'f?p=&APP_ID.:4000:&SESSION.::&DEBUG.:::'
,p_page_id=>4000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180257911479980432.4806)
,p_parent_id=>wwv_flow_api.id(180296014219363207.4806)
,p_short_name=>unistr('\5F85\529E\4E8B\9879')
,p_link=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:::'
,p_page_id=>3010
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180296014219363207.4806)
,p_parent_id=>wwv_flow_api.id(179979238487556845.4806)
,p_short_name=>unistr('\5F85\529E\4E8B\9879')
,p_link=>'f?p=&APP_ID.:3001:&SESSION.::&DEBUG.:::'
,p_page_id=>3001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180308423173607489.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\8BBE\7F6E')
,p_link=>'f?p=&APP_ID.:3005:&SESSION.::&DEBUG.:::'
,p_page_id=>3005
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180457329753044008.4806)
,p_parent_id=>wwv_flow_api.id(180296014219363207.4806)
,p_short_name=>unistr('\590D\5236')
,p_link=>'f?p=&APP_ID.:3009:&SESSION.::&DEBUG.:::'
,p_page_id=>3009
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180843626661957599.4806)
,p_parent_id=>wwv_flow_api.id(177386011681384540.4806)
,p_short_name=>unistr('\62A5\8868')
,p_link=>'f?p=&APP_ID.:6000:&SESSION.::&DEBUG.:::'
,p_page_id=>6000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180866837154603376.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\65B0\95FB')
,p_link=>'f?p=&APP_ID.:7000:&SESSION.::&DEBUG.:::'
,p_page_id=>7000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180873020184793609.4806)
,p_parent_id=>wwv_flow_api.id(180866837154603376.4806)
,p_short_name=>unistr('\65B0\95FB\6761\76EE')
,p_link=>'f?p=&APP_ID.:7001:&SESSION.::&DEBUG.:::'
,p_page_id=>7001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180950726871741880.4806)
,p_parent_id=>wwv_flow_api.id(177386011681384540.4806)
,p_short_name=>unistr('\91CC\7A0B\7891')
,p_link=>'f?p=&APP_ID.:6001:&SESSION.::&DEBUG.:::'
,p_page_id=>6001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181191835008706146.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\94FE\63A5')
,p_link=>'f?p=&APP_ID.:5000:&SESSION.::&DEBUG.:::'
,p_page_id=>5000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181192114706706146.4806)
,p_parent_id=>wwv_flow_api.id(181191835008706146.4806)
,p_short_name=>unistr('\94FE\63A5')
,p_link=>'f?p=&APP_ID.:5001:&SESSION.::&DEBUG.:::'
,p_page_id=>5001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181234229776018395.4806)
,p_parent_id=>wwv_flow_api.id(182994732653275307.4806)
,p_short_name=>unistr('\62A5\8868')
,p_link=>'f?p=&APP_ID.:9000:&SESSION.::&DEBUG.:::'
,p_page_id=>9000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181234521535018395.4806)
,p_parent_id=>wwv_flow_api.id(182994732653275307.4806)
,p_short_name=>unistr('\529F\80FD')
,p_link=>'f?p=&APP_ID.:9001:&SESSION.::&DEBUG.:::'
,p_page_id=>9001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181385532835123872.4806)
,p_parent_id=>wwv_flow_api.id(181749818186002409.4806)
,p_short_name=>unistr('\62A5\8868')
,p_link=>'f?p=&APP_ID.:3500:&SESSION.::&DEBUG.:::'
,p_page_id=>3500
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181393817561426466.4806)
,p_parent_id=>wwv_flow_api.id(181749818186002409.4806)
,p_short_name=>'Bug'
,p_link=>'f?p=&APP_ID.:3502:&SESSION.::&DEBUG.:::'
,p_page_id=>3502
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181584730435398951.4806)
,p_parent_id=>wwv_flow_api.id(182994732653275307.4806)
,p_short_name=>unistr('\4FA7\91CD\9886\57DF')
,p_link=>'f?p=&APP_ID.:9003:&SESSION.::&DEBUG.:::'
,p_page_id=>9003
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181606313803968675.4806)
,p_parent_id=>wwv_flow_api.id(180296014219363207.4806)
,p_short_name=>unistr('\8FDB\5EA6\65E5\5FD7')
,p_link=>'f?p=&APP_ID.:3002:&SESSION.::&DEBUG.:::'
,p_page_id=>3002
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181749818186002409.4806)
,p_parent_id=>wwv_flow_api.id(179979238487556845.4806)
,p_short_name=>'Bug'
,p_link=>'f?p=&APP_ID.:3501:&SESSION.::&DEBUG.:::'
,p_page_id=>3501
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181840937862561678.4806)
,p_parent_id=>wwv_flow_api.id(182994732653275307.4806)
,p_short_name=>unistr('\6309\6240\6709\8005\7EDF\8BA1\7684\529F\80FD')
,p_link=>'f?p=&APP_ID.:9005:&SESSION.::&DEBUG.:::'
,p_page_id=>9005
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(182421335562885708.4806)
,p_parent_id=>wwv_flow_api.id(177386011681384540.4806)
,p_short_name=>unistr('\6309\6240\6709\8005\7EDF\8BA1\7684\91CC\7A0B\7891')
,p_link=>'f?p=&APP_ID.:6002:&SESSION.::&DEBUG.:::'
,p_page_id=>6002
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(182431619971024003.4806)
,p_parent_id=>wwv_flow_api.id(177386011681384540.4806)
,p_short_name=>unistr('\65E5\5386')
,p_link=>'f?p=&APP_ID.:6003:&SESSION.::&DEBUG.:::'
,p_page_id=>6003
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(182442638612224534.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\66F4\65B0\5206\914D\4EBA\5458')
,p_link=>'f?p=&APP_ID.:6004:&SESSION.::&DEBUG.:::'
,p_page_id=>6004
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(182525710990688744.4806)
,p_parent_id=>wwv_flow_api.id(181749818186002409.4806)
,p_short_name=>unistr('\6309\5F00\53D1\8005\7EDF\8BA1\7684 Bug')
,p_link=>'f?p=&APP_ID.:3503:&SESSION.::&DEBUG.:::'
,p_page_id=>3503
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(182640414675340643.4806)
,p_parent_id=>wwv_flow_api.id(180296014219363207.4806)
,p_short_name=>unistr('\65E5\5386')
,p_link=>'f?p=&APP_ID.:3013:&SESSION.::&DEBUG.:::'
,p_page_id=>3013
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(182720727176139964.4806)
,p_parent_id=>wwv_flow_api.id(182994732653275307.4806)
,p_short_name=>unistr('\65E5\5386')
,p_link=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.:::'
,p_page_id=>9007
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(182735228808519042.4806)
,p_parent_id=>wwv_flow_api.id(182994732653275307.4806)
,p_short_name=>unistr('\8FDB\5EA6\65E5\5FD7')
,p_link=>'f?p=&APP_ID.:9008:&SESSION.::&DEBUG.:::'
,p_page_id=>9008
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(182994732653275307.4806)
,p_parent_id=>wwv_flow_api.id(179979238487556845.4806)
,p_short_name=>unistr('\529F\80FD')
,p_link=>'f?p=&APP_ID.:9010:&SESSION.::&DEBUG.:::'
,p_page_id=>9010
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(183068431010764972.4806)
,p_parent_id=>wwv_flow_api.id(182994732653275307.4806)
,p_short_name=>unistr('\66F4\6539\5386\53F2\8BB0\5F55')
,p_link=>'f?p=&APP_ID.:9011:&SESSION.::&DEBUG.:::'
,p_page_id=>9011
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(183451122086697356.4806)
,p_parent_id=>wwv_flow_api.id(177386011681384540.4806)
,p_short_name=>unistr('\6309\91CC\7A0B\7891\7EDF\8BA1\7684\529F\80FD')
,p_link=>'f?p=&APP_ID.:6005:&SESSION.::&DEBUG.:::'
,p_page_id=>6005
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(191004806353341754.4806)
,p_parent_id=>wwv_flow_api.id(179979238487556845.4806)
,p_short_name=>unistr('\641C\7D22\7ED3\679C')
,p_link=>'f?p=&FLOW_ID.:8800:&SESSION.'
,p_page_id=>8800
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(191099809015279645.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\53D1\884C\7248\6982\8981')
,p_link=>'f?p=&APP_ID.:4050:&SESSION.::&DEBUG.:::'
,p_page_id=>4050
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(191113917639435202.4806)
,p_parent_id=>wwv_flow_api.id(191099809015279645.4806)
,p_short_name=>unistr('\5F00\53D1\8005\6982\8981')
,p_link=>'f?p=&FLOW_ID.:4051:&SESSION.'
,p_page_id=>4051
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(192634228225005477.4806)
,p_parent_id=>wwv_flow_api.id(181749818186002409.4806)
,p_short_name=>unistr('\6309\5929\7EDF\8BA1')
,p_link=>'f?p=&APP_ID.:3506:&SESSION.::&DEBUG.:::'
,p_page_id=>3506
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(232928315111459334.4806)
,p_parent_id=>wwv_flow_api.id(179979238487556845.4806)
,p_short_name=>unistr('\5B9E\7528\7A0B\5E8F')
,p_link=>'f?p=&FLOW_ID.:2:&SESSION.'
,p_page_id=>2
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(236935817195452169.4806)
,p_parent_id=>wwv_flow_api.id(181584730435398951.4806)
,p_short_name=>unistr('\7BA1\7406\4FA7\91CD\9886\57DF')
,p_link=>'f?p=&APP_ID.:9020:&SESSION.'
,p_page_id=>9020
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(236942120792516475.4806)
,p_parent_id=>wwv_flow_api.id(181584730435398951.4806)
,p_short_name=>unistr('\7F16\8F91\7126\70B9\533A')
,p_link=>'f?p=&APP_ID.:9021:&SESSION.'
,p_page_id=>9021
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(253911909757266167.4806)
,p_parent_id=>wwv_flow_api.id(19984001878291182.4806)
,p_short_name=>unistr('\63A8\8FDF\529F\80FD')
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(255908130737626094.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\63A8\8FDF Bug')
,p_link=>'f?p=&FLOW_ID.:5:&SESSION.'
,p_page_id=>5
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(314416510419468609.4806)
,p_parent_id=>wwv_flow_api.id(180257911479980432.4806)
,p_short_name=>unistr('\6DFB\52A0\6587\4EF6')
,p_link=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::'
,p_page_id=>4
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(319180225199563050.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\5C0F\7EC4\5F00\53D1\6587\4EF6')
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(320389712075514946.4806)
,p_parent_id=>wwv_flow_api.id(180257911479980432.4806)
,p_short_name=>unistr('\6587\4EF6')
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(320943012664694185.4806)
,p_parent_id=>wwv_flow_api.id(320389712075514946.4806)
,p_short_name=>unistr('\6587\4EF6')
,p_link=>'f?p=&FLOW_ID.:11:&SESSION.'
,p_page_id=>11
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(323871023458434771.4806)
,p_parent_id=>wwv_flow_api.id(181393817561426466.4806)
,p_short_name=>unistr('\6587\4EF6')
,p_link=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
,p_page_id=>13
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(324007312945493162.4806)
,p_parent_id=>wwv_flow_api.id(181393817561426466.4806)
,p_short_name=>unistr('\6DFB\52A0\6587\4EF6')
,p_link=>'f?p=&APP_ID.:14:&SESSION.'
,p_page_id=>14
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(324588802226611185.4806)
,p_parent_id=>wwv_flow_api.id(323871023458434771.4806)
,p_short_name=>unistr('\6587\4EF6')
,p_link=>'f?p=&APP_ID.:15:&SESSION.'
,p_page_id=>15
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(325166103468776664.4806)
,p_parent_id=>wwv_flow_api.id(181234521535018395.4806)
,p_short_name=>unistr('\6DFB\52A0\6587\4EF6')
,p_link=>'f?p=&APP_ID.:16:&SESSION.'
,p_page_id=>16
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(325303104369822815.4806)
,p_parent_id=>wwv_flow_api.id(181234521535018395.4806)
,p_short_name=>unistr('\6587\4EF6')
,p_link=>'f?p=&APP_ID.:17:&SESSION.'
,p_page_id=>17
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(325342714202855521.4806)
,p_parent_id=>wwv_flow_api.id(325303104369822815.4806)
,p_short_name=>unistr('\6587\4EF6')
,p_link=>'f?p=&APP_ID.:18:&SESSION.'
,p_page_id=>18
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(388524630490242472.4806)
,p_parent_id=>wwv_flow_api.id(.4806)
,p_short_name=>'0'
,p_link=>'f?p=&FLOW_ID.:0:&SESSION.'
,p_page_id=>0
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(430419925657117038.4806)
,p_parent_id=>wwv_flow_api.id(182735228808519042.4806)
,p_short_name=>unistr('\8FDB\5EA6')
,p_link=>'f?p=&APP_ID.:9006:&SESSION.::&DEBUG.:::'
,p_page_id=>9006
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(498565222580168239.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\6E05\9664\6570\636E')
,p_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
,p_page_id=>6
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(503083522522239443.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\66F4\65B0\5206\914D\4EBA\5458')
,p_link=>'f?p=&FLOW_ID.:6007:&SESSION.'
,p_page_id=>6007
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1267079751581502251.4806)
,p_parent_id=>wwv_flow_api.id(232928315111459334.4806)
,p_short_name=>unistr('\7BA1\7406\9875\590D\67E5\5F85\529E\4E8B\9879')
,p_link=>'f?p=&APP_ID.:555:&SESSION.::&DEBUG.:::'
,p_page_id=>555
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1492716385745725844.4806)
,p_parent_id=>wwv_flow_api.id(177386011681384540.4806)
,p_short_name=>'&P7_MILESTONE_NAME.'
,p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_0_right_sidebar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37842427600248702.4806)
,p_theme_id=>3
,p_name=>'APEX 4.0 - Right SideBar.zh-cn'
,p_internal_name=>'APEX_4.0_RIGHT_SIDEBAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-two-col">',
'      <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-splash"><div id="BB">#BODY#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'  <div>#REGION_POSITION_04#</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>18525411970780075.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_popup
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(183404645563185027.4806)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Popup.zh-cn'
,p_internal_name=>'APEX_4.2_POPUP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title><link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head><body #ONLOAD# style="padding:5px;min-width:380px;"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>',
'  <div id="RP2">#REGION_POSITION_02#</div>',
'  <div id="RP3">#REGION_POSITION_03#</div>',
'  <div id="RP4">#REGION_POSITION_04#</div>',
'  <div id="RP5">#REGION_POSITION_05#</div>',
'  <div class="popupContent" id="ContentArea">#BODY#</div>',
'</div>',
'<div id="RP8" style="text-align:middle;">#REGION_POSITION_08#</div>',
'<br />',
'<br />',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>36144306570651063.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_no_sidebar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(187455814418876120.4806)
,p_theme_id=>3
,p_name=>'APEX 4.2 - No SideBar.zh-cn'
,p_internal_name=>'APEX_4.2_NO_SIDEBAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-content">#REGION_POSITION_02#',
'      <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion failRegion #REGION_CSS_CLASSES#" id="ERROR">',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    <p><strong>#MESSAGE#</strong></p>',
'    #ADDITIONAL_INFO#',
'    #TECHNICAL_INFO#',
'  </div>',
'  <span class="aButtonContainer">',
'    <button onclick="#BACK_LINK#" class="aButton hotButton"><span>#RETURN_TO_APPLICATION#</span></button>',
'  </span>',
'</section>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>187453329378870285.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_wizard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(208642010646207804.4806)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Wizard .zh-cn'
,p_internal_name=>'APEX_4.2_WIZARD_'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="aWizard">',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'<div class="wizardOuterContainer">',
'#REGION_POSITION_01#',
'<div class="wizardContainer">',
'    <h1 class="visuallyhidden">#TITLE#</h1>',
'    #REGION_POSITION_03#',
'    #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="wizardBody">',
'    #BODY#',
'    #REGION_POSITION_04#',
'    #REGION_POSITION_05#',
'  </div>',
'</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'<script>',
'function loadWizardTrain() {',
'	var currentStep = $("li.current,li.first-current,li.last-current",''div.wizardProgress'');',
'	if (currentStep.prev().length > 0) {',
'		currentStep.prevAll().find(''span'').addClass("pastCurrent");',
'	}',
'}',
'$(document).ready(function(){',
'loadWizardTrain();',
'})',
'</script>',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aWizardMessage successMessage" id="aSuccessMessage" role="alert">',
'  <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'  <a href="javascript:void(0)" onclick="$x_Remove(''aSuccessMessage'')" class="aCloseNotification"><span class="visuallyhidden">#CLOSE_NOTIFICATION#</span></a>',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aWizardMessage errorMessage" id="aErrorMessage" role="alert">',
'  <a href="javascript:void(0)" onclick="$x_Remove(''aErrorMessage'')" class="aCloseNotification"><span class="visuallyhidden">#CLOSE_NOTIFICATION#</span></a>',
'  <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'  #MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>16
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>42231511193339128.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(314383415519061995.4806)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Edit Screen.zh-cn'
,p_internal_name=>'APEX_4.2_EDIT_SCREEN'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-two-col">',
'      <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-edit-screen">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>244139901565747496.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(389138863817227422.4806)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Right Side Bar.zh-cn'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222.4806
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159317534052372891.4806)
,p_page_template_id=>wwv_flow_api.id(389138863817227422.4806)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159318085181372891.4806)
,p_page_template_id=>wwv_flow_api.id(389138863817227422.4806)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159318532247372892.4806)
,p_page_template_id=>wwv_flow_api.id(389138863817227422.4806)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159319013173372892.4806)
,p_page_template_id=>wwv_flow_api.id(389138863817227422.4806)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159319583660372892.4806)
,p_page_template_id=>wwv_flow_api.id(389138863817227422.4806)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159320067674372893.4806)
,p_page_template_id=>wwv_flow_api.id(389138863817227422.4806)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159320528645372893.4806)
,p_page_template_id=>wwv_flow_api.id(389138863817227422.4806)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(637441482420448238.4806)
,p_theme_id=>3
,p_name=>'APEX 5.0 - No Side Bar.zh-cn'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(670195776876712847.4806)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog.zh-cn'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(694251408051447516.4806)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Edit Screen.zh-cn'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4806
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159322773813372895.4806)
,p_page_template_id=>wwv_flow_api.id(694251408051447516.4806)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159323237313372896.4806)
,p_page_template_id=>wwv_flow_api.id(694251408051447516.4806)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(694252054065447551.4806)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Dialog.zh-cn'
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.builder.initWizardModal();',
'apex.builder.initWizardProgressBar();'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="utf-8">  ',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--wizard'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689061037088924910.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(777430157181793893.4806)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Page.zh-cn'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_icon_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(46341926066173635.4806)
,p_template_name=>'APEX 4.2 - Icon Button'
,p_internal_name=>'APEX_4.2_ICON_BUTTON'
,p_template=>'<a href="#LINK#" class="aIconButton" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES# role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" /></a>'
,p_hot_template=>'<a href="#LINK#" class="aIconButton" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES# role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" /></a>'
,p_reference_id=>46198532248154431.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>0
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="xpbutton" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tbody class="FFFFFF">',
'<tr>',
'<td class="L" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'<td class="C"><a href="#LINK#">#LABEL#</a></td>',
'<td class="R" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'</tr>',
'</tbody>',
'</table>'))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/xp_square_c5d5c5
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(181959461061638813.4806)
,p_template_name=>'XP Square (C5D5C5)'
,p_internal_name=>'XP_SQUARE_C5D5C5'
,p_template=>'<input type="button" onclick="#LINK#" value="#LABEL!ATTR#" class="htmldbButton" />'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="xpbutton" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tbody class="C5D5C5">',
'<tr>',
'<td class="L" width="4"><img src="#IMAGE_PREFIX#htmldb/buttons/button_xp_left.gif" alt="" height="24" width="4"/></td>',
'<td class="C"><a href="#LINK#">#LABEL#</a></td>',
'<td class="R" width="4"><img src="#IMAGE_PREFIX#htmldb/buttons/button_xp_right.gif" alt="" height="24" width="4"/></td>',
'</tr>',
'</tbody>',
'</table>'))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_next_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(201434112983940379.4806)
,p_template_name=>'APEX 4.2 - Next Button'
,p_internal_name=>'APEX_4.2_NEXT_BUTTON'
,p_template=>'<button class="aButton nextButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" class="nextBlack" alt=""/></span></button>'
,p_hot_template=>'<button class="aButton hotButton nextButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" class="nextWhite" alt=""/></span></button>'
,p_reference_id=>40780910892272674.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_previous_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(201434311400940379.4806)
,p_template_name=>'APEX 4.2 - Previous Button'
,p_internal_name=>'APEX_4.2_PREVIOUS_BUTTON'
,p_template=>'<button title="#LABEL!ATTR#" class="aButton prevButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevBlack" alt="#LABEL!ATTR#" /></span></button>'
,p_hot_template=>'<button title="#LABEL!ATTR#" class="aButton hotButton prevButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevWhite" alt="#LABEL!ATTR#" /></span></button>'
,p_reference_id=>40781222929295107.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_1_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(301699911376661879.4806)
,p_template_name=>'APEX 4.1 - Button'
,p_internal_name=>'APEX_4.1_BUTTON'
,p_template=>'<button class="aButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_hot_template=>'<button class="aButton hotButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_reference_id=>275775519061831382.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="button-gray" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> ',
'',
'',
'<a href="#LINK#" class="button-orange" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> '))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(388504758229147633.4806)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(388504981151147634.4806)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(404863283234629578.4806)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_large
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(404863492425629583.4806)
,p_template_name=>'APEX 5.0 - Button (Large)'
,p_internal_name=>'APEX_5.0_BUTTON_LARGE'
,p_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--large #BUTTON_CSS_CLASSES#" type="button" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--large a-Button--hot #BUTTON_CSS_CLASSES#" type="button" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174756119980565636.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_small
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(404863755706629583.4806)
,p_template_name=>'APEX 5.0 - Button (Small)'
,p_internal_name=>'APEX_5.0_BUTTON_SMALL'
,p_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--small #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--small a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174755910284562884.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(404891952915809007.4806)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_0_next_gray_bg
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(492896719573418618.4806)
,p_template_name=>'APEX 4.0 - Next (gray bg)'
,p_internal_name=>'APEX_4.0_NEXT_GRAY_BG'
,p_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton nextButton rightPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="nextBlack" alt="#LABEL!ATTR#" /></span></but'
||'ton> '
,p_hot_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton hotButton nextButton rightPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="nextWhite" alt="#LABEL!ATTR#" /></'
||'span></button> '
,p_reference_id=>430240008284905073.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_0_previous_gray_bg
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(492896917688418624.4806)
,p_template_name=>'APEX 4.0 - Previous (gray bg)'
,p_internal_name=>'APEX_4.0_PREVIOUS_GRAY_BG'
,p_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton prevButton leftPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevBlack" alt="#LABEL!ATTR#" /></span></butt'
||'on>'
,p_hot_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton hotButton prevButton leftPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevWhite" alt="#LABEL!ATTR#" /></s'
||'pan></button>'
,p_reference_id=>430240500796912446.4806
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_button_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(629241199051957112.4806)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_BUTTON_LEGACY_APEX_5_MIGRATION'
,p_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_no_topbar_no_title
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(18729822820050595.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion noHeading #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <h1 class="visuallyhidden">#TITLE#</h1>',
'  <div class="aRegionContent clearfix">',
'  #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner (No Top-Bar No Title)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_NO_TOPBAR_NO_TITLE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>18729014377038660.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_message_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(38103840603408731.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-SystemMessage #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Message Region'
,p_internal_name=>'APEX_5.0_MESSAGE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>29333927116050844.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(38414033050315491.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar (Gray Header)'
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_float_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(55632913614175830.4806)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# style="float:left;clear:both;">#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div (Float Left)'
,p_internal_name=>'APEX_4.0_DIV_FLOAT_LEFT'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>35964702876463547.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(55633532876175832.4806)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #COMPONENT_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Page Anchors'
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17354206769599941.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_large
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(55634224812175832.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Large'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_LARGE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>27763613494297374.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(55635731999175833.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box'
,p_internal_name=>'APEX_4.0_WIZARD_BOX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box_confirm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(55636331541175833.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box (Confirm)'
,p_internal_name=>'APEX_4.0_WIZARD_BOX_CONFIRM'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/gray_box_worksheet
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(163461441475964749.4806)
,p_layout=>'TABLE'
,p_template=>'<table class="htmldbGBR" cellspacing="0" cellpadding="0" border="0" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="T">#TITLE#</th><th class="BT">#CLOSE#&nbsp;#EDIT##EXPAND##HELP##DELETE##COPY##CREATE#<img src="#IMAGE_PREFIX#up_arrow.gif" al'
||'t="&TOP." class="pb" onclick="uF()"/></th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>'
,p_page_plug_template_name=>'Gray Box (worksheet)'
,p_internal_name=>'GRAY_BOX_WORKSHEET'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/breadcrumb_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(163466616779278576.4806)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#">#BODY#</div>'
,p_page_plug_template_name=>'Breadcrumb Region'
,p_internal_name=>'BREADCRUMB_REGION'
,p_theme_id=>3
,p_theme_class_id=>6
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar_100
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(180239831819935577.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar (100%)'
,p_internal_name=>'APEX_4.0_TOP_BAR_100%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17357218626599946.4806
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar_99
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(180240224232935622.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="topbar" style="width:99%;clear:both;" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="topbar-top"><div class="topbar-top-r"></div></div>',
'  <div class="topbar-body"><div class="topbar-body-r"><div class="topbar-content">',
'      <div style="float:left">#BODY#</div>',
'      <div style="float:right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</div>',
'   </div></div></div>',
'  <div class="topbar-bottom"><div class="topbar-bottom-r"></div></div>',
'</div>',
'<br />'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar (99%)'
,p_internal_name=>'APEX_4.0_TOP_BAR_99%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>169048010062038708.4806
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/gray_box_c_htmldbgbr_100
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(180299038358393833.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading editRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'      <a href="#" class="aIconButton" onclick="uF();return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" class="upIcon" alt="&TOP." /></a>',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Gray Box (c:htmldbGBR) (100%)'
,p_internal_name=>'GRAY_BOX_C:HTMLDBGBR_100%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17353903289599940.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_gray_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(180327215311471582.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideNavRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner (Gray Top)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_GRAY_TOP'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>29053509612942271.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_small_gray_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(180399919088664924.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Small (Gray Top)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_SMALL_GRAY_TOP'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>32612420016685806.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/dhtml_hidden_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(182011371954547477.4806)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#" style="display:none;">#BODY#</div>'
,p_page_plug_template_name=>'(DHTML) Hidden with ID (c:htmldbHID)'
,p_internal_name=>'DHTML_HIDDEN_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(191054626665636186.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar'
,p_internal_name=>'APEX_4.0_TOP_BAR'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>191052627601630142.4806
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(191071206164693696.4806)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div  with ID (c:htmldbHID)'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>245224629509817478.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(208647221410212318.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body'
,p_internal_name=>'APEX_4.2_WIZARD_BODY'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209615589242480.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_buttons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(208648605607212320.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardButtonsContainer" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="leftButtons">',
'    #PREVIOUS##DELETE##CHANGE##CLOSE#',
'  </div>',
'  <div class="rightButtons">',
'    #EDIT##CREATE##NEXT#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Buttons'
,p_internal_name=>'APEX_4.2_WIZARD_BUTTONS'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210411889242480.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/info_c_htmldbinfo
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(242516861645003564.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Info (c:htmldbInfo) '
,p_internal_name=>'INFO_C:HTMLDBINFO_'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(379204631701472207.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="aRegionIR #REGION_CSS_CLASSES#">',
'<h1 class="visuallyhidden">#TITLE#</h1>',
'#BODY#',
'#EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##NEXT##PREVIOUS#',
'</div>'))
,p_page_plug_template_name=>'APEX 4.2 - Interactive Report Region'
,p_internal_name=>'APEX_4.2_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>379198415794456058.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(388361325811341773.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174748721787471587.4806
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(388367750536343715.4806)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/div_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(408696048877049411.4806)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#">#BODY#</div>'
,p_page_plug_template_name=>'Div  with ID (c:htmldbHID)'
,p_internal_name=>'DIV_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>7
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_navigation
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(466707824615211968.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion sideNavRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar Navigation'
,p_internal_name=>'APEX_4.0_SIDEBAR_NAVIGATION'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>456726627253419549.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_hide_and_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(502191003778578013.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title"><h3>',
'      <a href="#" onclick="htmldb_ToggleTableBody(''i#REGION_STATIC_ID#'',''body#REGION_STATIC_ID#''); return false;">',
'        <img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" class="pseudoButtonActive" id="i#REGION_STATIC_ID#" alt="" />',
'        #TITLE#',
'      </a></h3>    ',
'    </div>',
'  </div>',
'  <div class="hide-show-body" style="display:none;" id="body#REGION_STATIC_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.0 - Hide and Show Region'
,p_internal_name=>'APEX_4.0_HIDE_AND_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18662712241194598.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(678363858364331062.4806)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(688662784908046983.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>698829239393878937.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(690538778863811297.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>687153470345619376.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(690544675040811341.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'      <button class="a-Button a-Button--icon a-Button--hideShow" type="button"></button>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>689955986849128825.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_accordion
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(694257500753458953.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUBREGIONS#',
'</div>',
'<script type="text/javascript">',
'  apex.jQuery( "#accordion" ).accordion({',
'    icons: false,',
'    header: ".a-Region-header",',
'    heightStyle: ''content'',',
'    collapsible: true',
'  });',
'</script>'))
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion-item">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Accordion'
,p_internal_name=>'APEX_5.0_ACCORDION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174746301430371105.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(694258234968458963.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-PageColumn-header">',
'    <h2 class="a-PageColumn-heading">#TITLE#</h2>',
'  </div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613223222362440.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(694258964554458964.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn-body #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column (Body)'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN_BODY'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174630015632506596.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(694259700172458964.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUB_REGION_HEADERS#',
'  #SUB_REGIONS#',
'</div>',
'<script type="text/javascript">',
'    $("##REGION_STATIC_ID#").tabs({',
'      create: function() {',
'        $(this).addClass(''ui-tabs--simpleInset'')',
'      }',
'    });',
'</script>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#">#SUB_REGION_TITLE#</a></li>'
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer-item" id="#SUB_REGION_ID#">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Tabs'
,p_internal_name=>'APEX_5.0_TABS'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>183211208341566300.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(694260428797458964.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Toolbar-items a-Toolbar-items--left">#PREVIOUS#</div>',
'  <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar'
,p_internal_name=>'APEX_5.0_TOOLBAR'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613705533399534.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(694261169334458965.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--left #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Left)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_LEFT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174628415239478085.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_right
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(694261846857458965.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--right #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Right)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_RIGHT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174629130392501406.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(694262582219458966.4806)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(807048415846272366.4806)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div with ID and Region Attributes'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>2974803291668087.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_image_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(17229217805266523.4806)
,p_list_template_current=>'<li><a href="#LINK#" title="#TEXT#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />#TEXT#</a></li>'
,p_list_template_name=>'Simple Image List'
,p_internal_name=>'SIMPLE_IMAGE_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="listwithicon">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_large_icons_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(20161006231604791.4806)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX#f_spacer.gif" #IMAGE_ATTR# class="gi-Icon-#IMAGE#" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX#f_spacer.gif" #IMAGE_ATTR# class="gi-Icon-#IMAGE#" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_name=>'[EBA] Large Icons List'
,p_internal_name=>'[EBA]_LARGE_ICONS_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table class="ebaLargeIcons" width="100%" cellspacing="0" cellpadding="0" border="0" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_reference_id=>20148806760577112.4806
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/quicklinks
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(170642241329865946.4806)
,p_list_template_current=>'<td><a href="#LINK#" onclick="qF(this,''#LINK#'');return false;" id="#A01#" class="htmldbButtonListCurrent" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_noncurrent=>'<td><a href="#LINK#" onclick="qF(this,''#LINK#'');return false;" id="#A01#"  class="htmldbButtonList" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_name=>'Quicklinks'
,p_internal_name=>'QUICKLINKS'
,p_theme_id=>3
,p_theme_class_id=>3
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'.htmldbButtonListCurrent:link,.htmldbButtonListCurrent:visited,#ALL:hover,a.htmldbButtonList:hover,a.htmldbButtonListCurrent:link{padding:1px 3px;font-weight:bold;text-decoration:none;background:#aaaaaa!important;border:1px solid #999;color:#fff !imp'
||'ortant;}',
'</style>',
'<table class="htmldbButtonList" summary="" border="0" cellpadding="0" cellspacing="3" id="ql"><tr>'))
,p_list_template_after_rows=>'</tr></table><script>addLoadEvent(propTest)</script>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_second_level_tabs_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(182442550749490978.4806)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 4.0 second level tabs navigation'
,p_internal_name=>'APEX_4.0_SECOND_LEVEL_TABS_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4806
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_pull_down_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(187126031329006375.4806)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_name=>'APEX 4.0 - Pull Down Tabs'
,p_internal_name=>'APEX_4.0_PULL_DOWN_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div id="tabs" class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul id="S#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="aTabs dhtmlSubMenu pulldown-tabs" style="display:none;">',
''))
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_reference_id=>9651611091899590.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(198528142870857247.4806)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_wizard_progress_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(208654021006214577.4806)
,p_list_template_current=>'<li class="#LIST_STATUS#"><span>#TEXT#</span></li>'
,p_list_template_noncurrent=>'<li class="#LIST_STATUS#"><span>#TEXT#</span></li>'
,p_list_template_name=>'APEX 4.2 - Wizard Progress Bar'
,p_internal_name=>'APEX_4.2_WIZARD_PROGRESS_BAR'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardProgress">',
'<ul>'))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'</div>'))
,p_reference_id=>42216127932260877.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_run_edit_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(210442022107070716.4806)
,p_list_template_current=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_noncurrent=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_name=>'APEX 4.2 - Run / Edit Bar'
,p_internal_name=>'APEX_4.2_RUN_/_EDIT_BAR'
,p_theme_id=>3
,p_theme_class_id=>3
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="aRunEditBar">',
'  <li><span class="currentPage">&PAGE. &FB_FLOW_PAGE_ID.</span></li>'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>210390516819756900.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/list/horizontal_list_with_images_fixed_width_30pxc_htmldblistimageshfw
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(238220356792593834.4806)
,p_list_template_current=>'<td align="center" valign="bottom"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon" /></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a><br />Default</td>'
,p_list_template_noncurrent=>'<td align="center" valign="bottom"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon"/></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_name=>'Horizontal List with Images Fixed Width 30px(c:htmldbListImagesHFW)'
,p_internal_name=>'HORIZONTAL_LIST_WITH_IMAGES_FIXED_WIDTH_30PXC:HTMLDBLISTIMAGESHFW'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="htmldbListImages30px" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(388372306498350236.4806)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(388372628384350238.4806)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(389134312137893848.4806)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508.4806
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(687904424679688542.4806)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(698626121681757633.4806)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060.4806
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(5574228712665954.4806)
,p_row_template_name=>'APEX 4.0 - Standard Report'
,p_internal_name=>'APEX_4.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4806
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(5574228712665954.4806)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(20030628929586806.4806)
,p_row_template_name=>'[EBA] Standard Report'
,p_internal_name=>'[EBA]_STANDARD_REPORT'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#',
'<tr>',
'<td><table class="ebaStandardReport" cellspacing="0" cellpadding="0" summary="#REGION_TITLE#" width="100%">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table><div class="CSV">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="#LINK#" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="#LINK#" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="#LINK#" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="#LINK#" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>20327811817377113.4806
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(20030628929586806.4806)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(170062069413723717.4806)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report from 4999'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#"><div class="of">#COLUMN_VALUE#</div></td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#"><div class="of">#COLUMN_HEADER#</div></th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(170062069413723717.4806)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/quick_pick_list_items
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(175129351466570091.4806)
,p_row_template_name=>'quick_pick_list_items'
,p_internal_name=>'QUICK_PICK_LIST_ITEMS'
,p_row_template1=>'<li>#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="htmldbUl">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(175129351466570091.4806)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(180321418532362007.4806)
,p_row_template_name=>'APEX 4.0 - Portlet Column Template'
,p_internal_name=>'APEX_4.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(180321830795362036.4806)
,p_row_template_name=>'APEX 4.0 - Portlet Row Template'
,p_internal_name=>'APEX_4.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(389146768272330380.4806)
,p_row_template_name=>'APEX 5.0 - Badge List'
,p_internal_name=>'APEX_5.0_BADGE_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>488487951233692049.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_date_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(389147069816330386.4806)
,p_row_template_name=>'APEX 5.0 - Date List'
,p_internal_name=>'APEX_5.0_DATE_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="a-DateList-item">',
'    <div class="a-MediaBlock">',
'      <div class="a-MediaBlock-graphic">',
'        <span class="a-DateList-date">',
'          <span class="a-DateList-day">#DAY#</span>',
'          <span class="a-DateList-month">#MONTH#</span>',
'        </span>',
'      </div>',
'      <div class="a-MediaBlock-content">',
'        <span class="a-DateList-desc">#TEXT#</span>',
'        <span class="a-DateList-attribute">#CREATED_BY#</span>',
'        <span class="a-DateList-attribute">#CREATED_ON#</span>',
'      </div>',
'    </div>',
'  </li>'))
,p_row_template_before_rows=>'<ul class="a-DateList">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(696866128778092508.4806)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4806
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(696866128778092508.4806)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(696870961265092518.4806)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4806
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(696870961265092518.4806)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/label_tag_only
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(4930629023777300.4806)
,p_template_name=>'LABEL Tag Only'
,p_internal_name=>'LABEL_TAG_ONLY'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/htmldb_greenarealabel_c_htmldbgalabel
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(221193067590078727.4806)
,p_template_name=>'htmldb_GreenAreaLabel (c:htmldbGALabel)'
,p_internal_name=>'HTMLDB_GREENAREALABEL_C:HTMLDBGALABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="htmldbGALabel" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(256834263945807314.4806)
,p_template_name=>'FormField_Optional'
,p_internal_name=>'FORMFIELD_OPTIONAL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_required
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(256835961998816266.4806)
,p_template_name=>'FormField_Required'
,p_internal_name=>'FORMFIELD_REQUIRED'
,p_template_body1=>'<em>*</em><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aRequired"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>' <span class="hideMeButHearMe">(#VALUE_REQUIRED#)</span></a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>2
,p_reference_id=>17388508175892042.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional_no_link
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(401587960425963086.4806)
,p_template_name=>'FormField_Optional No Link'
,p_internal_name=>'FORMFIELD_OPTIONAL_NO_LINK'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><span class="htmldbLabelOptional">'
,p_template_body2=>'</span></label>'
,p_theme_id=>3
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_4_0_top_bar_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(468327302992069341.4806)
,p_template_name=>'APEX 4.0 - Top Bar Label'
,p_internal_name=>'APEX_4.0_TOP_BAR_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(487444889588719015.4806)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487444299516703815.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(487444999901719038.4806)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487443659585685414.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(687909483370721160.4806)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492676964457041934.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(687909659953721161.4806)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492677038682043223.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(687910747318723332.4806)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>687907221148719616.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumbs_c_htmldbbreadcrumb
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(177195862144126592.4806)
,p_name=>'Breadcrumbs (c:htmldbBreadcrumb) '
,p_internal_name=>'BREADCRUMBS_C:HTMLDBBREADCRUMB_'
,p_current_page_option=>'<span class="htmldbBreadcrumb">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#" class="htmldbBreadcrumb" title="#NAME#">#NAME#</a>'
,p_between_levels=>'<span class="htmldbBreadcrumbSep"><img alt="" src="#IMAGE_PREFIX#apex/apex_top_sep.gif"></span>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>60115300853820165.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(388374331020352607.4806)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>689285808648404711.4806
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(173678761230832643.4806)
,p_page_name=>'winlov'
,p_page_title=>unistr('\201C\641C\7D22\201D\5BF9\8BDD\6846')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>unistr('\641C\7D22')
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>unistr('\5173\95ED')
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>unistr('\4E0B\4E00\6B65 &gt;')
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>unistr('&lt; \4E0A\4E00\6B65')
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>unistr('<div class="a-PopupLOV-pagination">\884C #FIRST_ROW# - #LAST_ROW#</div>')
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17343114994581872.4806
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/default_calender
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(212207462949198022.4806)
,p_cal_template_name=>'Default Calender'
,p_internal_name=>'DEFAULT_CALENDER'
,p_day_of_week_format=>'<th scope="col" class="aCalDayCol">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aCal">',
'<h1 class="aMonth">#IMONTH# <span>#YYYY#</span></h1>'))
,p_month_open_format=>'<table class="aCal" cellpadding="0" cellspacing="0" border="0" summary="#IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></div>',
'',
''))
,p_day_title_format=>'<span class="aDayTitle">#DD#</span>'
,p_day_open_format=>'<td class="aDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="aDay today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<span class="aDayTitle weekendday">#DD#</span>'
,p_weekend_open_format=>'<td class="aDay weekendday">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<span class="aDayTitle nonday">#DD#</span>'
,p_nonday_open_format=>'<td class="aDay nonday">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(72334208468543765.4806)
,p_theme_id=>3
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(204025408989784204.4806)
,p_theme_id=>3
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686931752392028100.4806)
,p_theme_id=>101
,p_name=>'REGION_HEIGHT'
,p_display_name=>'Region Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686932694049028101.4806)
,p_theme_id=>101
,p_name=>'BODY_PADDING'
,p_display_name=>'Body Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686934223693028101.4806)
,p_theme_id=>101
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690539409466811311.4806)
,p_theme_id=>101
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690540475976811312.4806)
,p_theme_id=>101
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690548471493811346.4806)
,p_theme_id=>101
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690549460358811347.4806)
,p_theme_id=>101
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690731005419652796.4806)
,p_theme_id=>101
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690731109728652798.4806)
,p_theme_id=>101
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690731226810652798.4806)
,p_theme_id=>101
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690731380086652798.4806)
,p_theme_id=>101
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690731426387652798.4806)
,p_theme_id=>101
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690731590242652798.4806)
,p_theme_id=>101
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690731671823652798.4806)
,p_theme_id=>101
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690731768993652798.4806)
,p_theme_id=>101
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690731862543652798.4806)
,p_theme_id=>101
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690731958274652799.4806)
,p_theme_id=>101
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690732022821652799.4806)
,p_theme_id=>101
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690732159251652799.4806)
,p_theme_id=>101
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690732235292652799.4806)
,p_theme_id=>101
,p_name=>'MAX_HEIGHT'
,p_display_name=>'Max Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'No Max Height'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690732335563652799.4806)
,p_theme_id=>101
,p_name=>'MIN_HEIGHT'
,p_display_name=>'Min Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'No Min Height'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(690732410003652799.4806)
,p_theme_id=>101
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(696614171558038275.4806)
,p_theme_id=>101
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Hidden (but accessible)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697248826031708864.4806)
,p_theme_id=>101
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698626524178757639.4806)
,p_theme_id=>101
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746459684950432641.4806)
,p_theme_id=>3
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746460982636432641.4806)
,p_theme_id=>3
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746461262062432641.4806)
,p_theme_id=>3
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746461525072432641.4806)
,p_theme_id=>3
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746462646698432642.4806)
,p_theme_id=>3
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746462937691432642.4806)
,p_theme_id=>3
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746463268619432642.4806)
,p_theme_id=>3
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746463545454432642.4806)
,p_theme_id=>3
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746463838133432643.4806)
,p_theme_id=>3
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746464395553432643.4806)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746464631756432643.4806)
,p_theme_id=>3
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750710273925419649.4806)
,p_theme_id=>3
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750711049033419649.4806)
,p_theme_id=>3
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750711583609419649.4806)
,p_theme_id=>3
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750711863412419649.4806)
,p_theme_id=>3
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750712522840419649.4806)
,p_theme_id=>3
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750724391157422868.4806)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(787122308149949724.4806)
,p_theme_id=>3
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(787122617145949724.4806)
,p_theme_id=>3
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(787122928931949724.4806)
,p_theme_id=>3
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(787123715929949725.4806)
,p_theme_id=>3
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1021075768043574436.4806)
,p_theme_id=>3
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(698630113419757660.4806)
,p_theme_id=>101
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(698626524178757639)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(698630497048757661.4806)
,p_theme_id=>101
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(698626524178757639)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(698630735059757661.4806)
,p_theme_id=>101
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(698626524178757639)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(698631040202757661.4806)
,p_theme_id=>101
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(698626524178757639)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(698631381209757661.4806)
,p_theme_id=>101
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(698626524178757639)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(698631601897757661.4806)
,p_theme_id=>101
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(698631954063757662.4806)
,p_theme_id=>101
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(698632209689757662.4806)
,p_theme_id=>101
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(698632508070757662.4806)
,p_theme_id=>101
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(698632811044757664.4806)
,p_theme_id=>101
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746459789650432641.4806)
,p_theme_id=>3
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_api.id(746459684950432641)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746459971161432641.4806)
,p_theme_id=>3
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_api.id(746459684950432641)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746460146088432641.4806)
,p_theme_id=>3
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_api.id(746459684950432641)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746460332756432641.4806)
,p_theme_id=>3
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_api.id(746459684950432641)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746460579505432641.4806)
,p_theme_id=>3
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_api.id(746459684950432641)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746460781120432641.4806)
,p_theme_id=>3
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_api.id(746459684950432641)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746461015149432641.4806)
,p_theme_id=>3
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(746460982636432641)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746461378907432641.4806)
,p_theme_id=>3
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_api.id(746461262062432641)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746461654142432641.4806)
,p_theme_id=>3
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_api.id(746461525072432641)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746461869095432642.4806)
,p_theme_id=>3
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_api.id(746461262062432641)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746462066852432642.4806)
,p_theme_id=>3
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_api.id(746461262062432641)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746462292384432642.4806)
,p_theme_id=>3
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_api.id(746461262062432641)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746462405703432642.4806)
,p_theme_id=>3
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_api.id(746461525072432641)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746462751760432642.4806)
,p_theme_id=>3
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_api.id(746462646698432642)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746463037183432642.4806)
,p_theme_id=>3
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(746462937691432642)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746463387012432642.4806)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_api.id(746463268619432642)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746463668927432642.4806)
,p_theme_id=>3
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(746463545454432642)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746463910098432643.4806)
,p_theme_id=>3
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_api.id(746463838133432643)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746464147858432643.4806)
,p_theme_id=>3
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(746461525072432641)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746464425927432643.4806)
,p_theme_id=>3
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746464395553432643)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746464750779432643.4806)
,p_theme_id=>3
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_api.id(746464631756432643)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746464850348432643.4806)
,p_theme_id=>3
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746465089268432643.4806)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_api.id(746463268619432642)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746465269914432643.4806)
,p_theme_id=>3
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_api.id(746463545454432642)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746465434188432643.4806)
,p_theme_id=>3
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_api.id(746463838133432643)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746465507926432643.4806)
,p_theme_id=>3
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(746465611967432643.4806)
,p_theme_id=>3
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787122401310949724.4806)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(5574228712665954.4806)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(787122308149949724)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787122782373949724.4806)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(5574228712665954.4806)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(787122617145949724)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787123029506949724.4806)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(5574228712665954.4806)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(787122928931949724)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787123266664949725.4806)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(5574228712665954.4806)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(787122928931949724)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787123495471949725.4806)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(5574228712665954.4806)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(787122928931949724)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787123576826949725.4806)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(5574228712665954.4806)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787123813091949725.4806)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(5574228712665954.4806)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(787123715929949725)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787131936845949742.4806)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(696866128778092508.4806)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(787122308149949724)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787132157454949742.4806)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(696866128778092508.4806)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(787122617145949724)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787132375554949742.4806)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(696866128778092508.4806)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(787122928931949724)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787132503679949743.4806)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(696866128778092508.4806)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(787122928931949724)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787132758067949746.4806)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(696866128778092508.4806)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(787122928931949724)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787132847527949746.4806)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(696866128778092508.4806)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787133078295949746.4806)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(696866128778092508.4806)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(787123715929949725)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797533872373124606.4806)
,p_theme_id=>3
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690538778863811297.4806)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797534069223124607.4806)
,p_theme_id=>3
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690538778863811297.4806)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(750711863412419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797534249339124607.4806)
,p_theme_id=>3
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690538778863811297.4806)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(750711863412419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797534446958124608.4806)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690538778863811297.4806)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(750711049033419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797534630255124608.4806)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690538778863811297.4806)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(750711049033419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797534794880124608.4806)
,p_theme_id=>3
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690538778863811297.4806)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797534925088124608.4806)
,p_theme_id=>3
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690538778863811297.4806)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_api.id(750710273925419649)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(797535191655124608.4806)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690538778863811297.4806)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_api.id(750710273925419649)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926398019370707525.4806)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(388372628384350238.4806)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926398115263707526.4806)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(388372628384350238.4806)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(940697230213341583.4806)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(687904424679688542.4806)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1199561728176032427.4806)
,p_theme_id=>3
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(404891952915809007.4806)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746464395553432643)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525658306265182093.4806)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525658402893182093.4806)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525658526322182093.4806)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525658694219182093.4806)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525658895558182093.4806)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(1021075768043574436)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525659045034182094.4806)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(1021075768043574436)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544817704758478013.4806)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(696870961265092518.4806)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544817860977478013.4806)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(696870961265092518.4806)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544817930638478013.4806)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(696870961265092518.4806)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554815061297408383.4806)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(750710273925419649)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554815275480408383.4806)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(750710273925419649)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554815439028408383.4806)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(750711049033419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554815650507408383.4806)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(750711049033419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554815884246408383.4806)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750711583609419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554816035766408383.4806)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(750711863412419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554816261722408383.4806)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750712522840419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554816479266408384.4806)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750712522840419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554816667823408384.4806)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(750711049033419649)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554816715939408384.4806)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554816996915408384.4806)
,p_theme_id=>3
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(388361325811341773.4806)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(750711863412419649)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554835134031526828.4806)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(678363858364331062.4806)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554835207878526828.4806)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(678363858364331062.4806)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554835391893526828.4806)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(678363858364331062.4806)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554840973425542260.4806)
,p_theme_id=>3
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690544675040811341.4806)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554841042179542260.4806)
,p_theme_id=>3
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690544675040811341.4806)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554841286371542260.4806)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690544675040811341.4806)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(750711049033419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554841487432542260.4806)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690544675040811341.4806)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(750711049033419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554841695414542260.4806)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690544675040811341.4806)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750711583609419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554841853705542260.4806)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690544675040811341.4806)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(750711863412419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554842011531542260.4806)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690544675040811341.4806)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750712522840419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554842258575542260.4806)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690544675040811341.4806)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750712522840419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554842491526542260.4806)
,p_theme_id=>3
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_api.id(690544675040811341.4806)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(750724391157422868)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554842628566542260.4806)
,p_theme_id=>3
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(690544675040811341.4806)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(750724391157422868)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554866528938550814.4806)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(688662784908046983.4806)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554866772776550814.4806)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(688662784908046983.4806)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(750710273925419649)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554866987244550814.4806)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(688662784908046983.4806)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750712522840419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554867181395550814.4806)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(688662784908046983.4806)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(750711863412419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554867302399550814.4806)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(688662784908046983.4806)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(750711049033419649)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554867527048550814.4806)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(688662784908046983.4806)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(750710273925419649)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554867722578550814.4806)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(688662784908046983.4806)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(750711049033419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554867996488550814.4806)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(688662784908046983.4806)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750712522840419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554868188013550814.4806)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(688662784908046983.4806)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750711583609419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554868356422550814.4806)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(688662784908046983.4806)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(750711049033419649)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(33112014865229171.4806)
,p_build_option_name=>'Enable Approval Status'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(314413317596395364.4806)
,p_build_option_name=>'file attachments'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(693446095934505835.4806)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(15852115401939495.4806)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\662F\5426\786E\5B9E\8981\9000\51FA\6B64\9875\800C\4E0D\8FDB\884C\4FDD\5B58?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(163832923235109479.4806)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\662F\5426\8981\6267\884C\6B64\5220\9664\64CD\4F5C?')
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(539942911020674156.4806)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040.4806
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(12509114218268921.4806)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>unistr('\5F00\53D1\8005\6388\6743')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(786901024557512875.4806)
,p_plugin_id=>wwv_flow_api.id(12509114218268921.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786901400677512875.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786901998566512877.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786902489537512877.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786902980285512877.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786903415811512877.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786903922704512878.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786904437896512880.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786904969489512880.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786905493705512881.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786905975124512881.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786906466438512882.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786906915817512882.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(786901024557512875.4806)
,p_display_sequence=>120
,p_display_value=>'PKG_APPS: Ability to install packaged applications'
,p_return_value=>'PKG_APPS'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_searchbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(73893355682369011.4806)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.SEARCHBOX'
,p_display_name=>unistr('\641C\7D22\6846')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.SEARCHBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_searchbox'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT'
,p_substitute_attributes=>true
,p_reference_id=>42609120788689442.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513168626743230026.4806)
,p_plugin_id=>wwv_flow_api.id(73893355682369011.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Redirect URL'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:<target page>:&SESSION.::&DEBUG.::<target item>:'
,p_display_length=>80
,p_max_length=>4000
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513169089778230026.4806)
,p_plugin_id=>wwv_flow_api.id(73893355682369011.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Search Text'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Search'
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
''))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(113747205170665433.4806)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>unistr('APEX \9A8C\8BC1')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(118606684005935111.4806)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>unistr('INTERNAL \793E\4EA4\767B\5F55')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118606809296935112.4806)
,p_plugin_id=>wwv_flow_api.id(118606684005935111.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118608772497935112.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(118606809296935112.4806)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118607259987935112.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(118606809296935112.4806)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118607799749935112.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(118606809296935112.4806)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118608295092935112.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(118606809296935112.4806)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118609200592935113.4806)
,p_plugin_id=>wwv_flow_api.id(118606684005935111.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118606809296935112.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118609677394935113.4806)
,p_plugin_id=>wwv_flow_api.id(118606684005935111.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118606809296935112.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118610032278935113.4806)
,p_plugin_id=>wwv_flow_api.id(118606684005935111.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118606809296935112.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118610413522935113.4806)
,p_plugin_id=>wwv_flow_api.id(118606684005935111.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118606809296935112.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118610872287935113.4806)
,p_plugin_id=>wwv_flow_api.id(118606684005935111.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Application Express automatically adds the "openid" scope. The authent'
||'ication provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118611296233935113.4806)
,p_plugin_id=>wwv_flow_api.id(118606684005935111.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118611624558935114.4806)
,p_plugin_id=>wwv_flow_api.id(118606684005935111.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118612072905935114.4806)
,p_plugin_id=>wwv_flow_api.id(118606684005935111.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356673921904447686.4806)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>'INTERNAL Oracle Cloud Identity Management'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749806821809026.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356676709814447690.4806)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>unistr('INTERNAL \6570\636E\5E93\5E10\6237')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749511183746276.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356708605749447725.4806)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>unistr('INTERNAL HTTP \6807\5934\53D8\91CF')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>708795120396802284.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356708819240447725.4806)
,p_plugin_id=>wwv_flow_api.id(356708605749447725.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356709200154447725.4806)
,p_plugin_id=>wwv_flow_api.id(356708605749447725.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356709613127447725.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356709200154447725.4806)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356710131581447726.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356709200154447725.4806)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356710618562447726.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356709200154447725.4806)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356711112128447726.4806)
,p_plugin_id=>wwv_flow_api.id(356708605749447725.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356709200154447725.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>',
'<p>',
'<h3>Example:</h3>',
'<pre>http://sso.mycompany.com/?success=#CALLBACK#</pre>',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356711501526447727.4806)
,p_plugin_id=>wwv_flow_api.id(356708605749447725.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(356709200154447725.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356711905963447727.4806)
,p_plugin_id=>wwv_flow_api.id(356708605749447725.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356709200154447725.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'BUILTIN_URL,URL'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356712325403447727.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356711905963447727.4806)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356712817347447728.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356711905963447727.4806)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356713301873447728.4806)
,p_plugin_id=>wwv_flow_api.id(356708605749447725.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356779006815447779.4806)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>unistr('INTERNAL LDAP \76EE\5F55')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>863910941135523528.4806
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8F93\5165\9488\5BF9\767B\5F55\9875\4E0A\6807\8BC6\7684 LDAP \76EE\5F55\8FDB\884C\9A8C\8BC1\7684\7528\6237\540D\548C\5BC6\7801\3002\8BF7\8BB0\4F4F, \5BC6\7801\533A\5206\5927\5C0F\5199\3002</p>'),
''))
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356779326235447779.4806)
,p_plugin_id=>wwv_flow_api.id(356779006815447779.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356779712325447779.4806)
,p_plugin_id=>wwv_flow_api.id(356779006815447779.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356780123792447779.4806)
,p_plugin_id=>wwv_flow_api.id(356779006815447779.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356780504381447779.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356780123792447779.4806)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356781015835447779.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356780123792447779.4806)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356781517149447780.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356780123792447779.4806)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356782010078447780.4806)
,p_plugin_id=>wwv_flow_api.id(356779006815447779.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356782425005447781.4806)
,p_plugin_id=>wwv_flow_api.id(356779006815447779.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356782801418447781.4806)
,p_plugin_id=>wwv_flow_api.id(356779006815447779.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356782425005447781.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356783214800447781.4806)
,p_plugin_id=>wwv_flow_api.id(356779006815447779.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356783622732447781.4806)
,p_plugin_id=>wwv_flow_api.id(356779006815447779.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356784032604447781.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356783622732447781.4806)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356784513086447782.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356783622732447781.4806)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356785020016447782.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(356783622732447781.4806)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356820528897447809.4806)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'INTERNAL Oracle Application Server Single Sign-On'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113750429890071859.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_html5_bar_chart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(631114846055861055.4806)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_display_name=>unistr('HTML 5 \6761\5F62\56FE ***')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.HTML5_BAR_CHART'),'#IMAGE_PREFIX#plugins/com.oracle.apex.html5_bar_chart/1.0/')
,p_javascript_file_urls=>'#PLUGIN_FILES#com_oracle_apex_html5_bar_chart.js'
,p_css_file_urls=>'#PLUGIN_FILES#com_oracle_apex_html5_bar_chart.css'
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'FUNCTION RENDER (',
'    P_REGION IN APEX_PLUGIN.T_REGION,',
'    P_PLUGIN IN APEX_PLUGIN.T_PLUGIN,',
'    P_IS_PRINTER_FRIENDLY IN BOOLEAN',
') RETURN APEX_PLUGIN.T_REGION_RENDER_RESULT IS',
'BEGIN',
'    sys.HTP.PRN(''<div id="''||APEX_ESCAPE.HTML_ATTRIBUTE(P_REGION.STATIC_ID)||''_chart" class="hbc">'');',
'    sys.HTP.PRN(''</div>'');',
'    ',
'    APEX_JAVASCRIPT.ADD_ONLOAD_CODE (',
'        P_CODE => ''com_oracle_apex_html5_bar_chart(''||',
'            APEX_JAVASCRIPT.ADD_VALUE(P_REGION.STATIC_ID)||',
'            ''{''||',
'                -- Why is this attribute needed if is not used?',
'                APEX_JAVASCRIPT.ADD_ATTRIBUTE(',
'                    ''pageItems'', ',
'                    APEX_PLUGIN_UTIL.PAGE_ITEM_NAMES_TO_JQUERY(P_REGION.AJAX_ITEMS_TO_SUBMIT)',
'                )||',
'                APEX_JAVASCRIPT.ADD_ATTRIBUTE(',
'                    ''ajaxIdentifier'', ',
'                    APEX_PLUGIN.GET_AJAX_IDENTIFIER, ',
'                    FALSE, ',
'                    FALSE',
'                )||',
'            ''}''||',
'        '');''',
'    );',
'    ',
'    RETURN NULL;',
'END RENDER;',
'',
'FUNCTION AJAX (',
'    P_REGION IN APEX_PLUGIN.T_REGION,',
'    P_PLUGIN IN APEX_PLUGIN.T_PLUGIN',
') RETURN APEX_PLUGIN.T_REGION_AJAX_RESULT IS',
'    -- Map region attributes to function constants',
'    -- MODERN, CLASSIC',
'    C_CHART_TYPE CONSTANT VARCHAR2(7) := P_REGION.ATTRIBUTE_15;',
'    -- MODERN, MODERN_2, SOLAR, METRO, CUSTOM, COLUMN',
'    C_COLOR_SCHEME CONSTANT VARCHAR2(8) := P_REGION.ATTRIBUTE_17;',
'    C_CUSTOM_CHART_COLORS CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_10;',
'    C_COLOR_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_19;',
'    -- NONE, IMAGE, ICON, INITIALS',
'    C_ICON_TYPE CONSTANT VARCHAR2(8) := case when C_CHART_TYPE = ''ICON'' then P_REGION.ATTRIBUTE_01 end;',
'    C_LABEL_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_02;',
'    C_LABEL_LINK CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_03;',
'    C_VALUE_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_04;',
'    C_VALUE_LINK CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_05;',
'    -- ABOVE, AROUND',
'    C_TEXT_POSITION VARCHAR2(6) := P_REGION.ATTRIBUTE_18;',
'    C_CHART_CSS_CLASSES CONSTANT VARCHAR2(32767) := P_REGION.ATTRIBUTE_06;',
'    C_IMAGE_URL CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_07;',
'    C_CSS_ICON_CLASS_NAME CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_08;',
'    C_INITIALS_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_09;',
'    -- ABSOLUTE, RELATIVE',
'    C_BAR_WIDTH_CALCULATION CONSTANT VARCHAR2(8) := P_REGION.ATTRIBUTE_16;',
'    C_DISPLAY CONSTANT VARCHAR2(19) := P_REGION.ATTRIBUTE_11;',
'    C_PREFIX_FOR_VALUE CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_12;',
'    C_POSTFIX_FOR_VALUE CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_13;',
'    C_MAXIMUM_ROWS CONSTANT NUMBER := P_REGION.ATTRIBUTE_14;',
'    C_MESSAGE_WHEN_NO_DATA_FOUND CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_20;',
'    ',
'    L_COLOR_COLUMN_NUMBER PLS_INTEGER;',
'    L_LABEL_COLUMN_NUMBER PLS_INTEGER;',
'    L_VALUE_COLUMN_NUMBER PLS_INTEGER;',
'    L_INITIALS_COLUMN_NUMBER PLS_INTEGER;',
'    ',
'    L_COLUMN_VALUE_LIST APEX_PLUGIN_UTIL.T_COLUMN_VALUE_LIST2;',
'    ',
'    L_COLOR VARCHAR2(4000) := NULL;',
'    L_LABEL VARCHAR2(4000) := NULL;',
'    L_LABEL_LINK VARCHAR2(4000) := NULL;',
'    L_VALUE VARCHAR2(4000) := NULL;',
'    L_VALUE_LINK VARCHAR2(4000) := NULL;',
'    L_IMAGE_URL VARCHAR2(4000) := NULL;',
'    L_CSS_ICON_CLASS_NAME VARCHAR2(4000) := NULL;',
'    L_INITIALS VARCHAR2(4000) := NULL;',
'    L_MESSAGE_WHEN_NO_DATA_FOUND VARCHAR2(4000) := NULL;',
'',
'    L_CUSTOM_CHART_COLORS_TABLE APEX_APPLICATION_GLOBAL.VC_ARR2;',
'    L_CUSTOM_CHART_COLORS VARCHAR2(32767) := NULL;',
'BEGIN',
'    L_COLUMN_VALUE_LIST := APEX_PLUGIN_UTIL.GET_DATA2(',
'        P_SQL_STATEMENT  => P_REGION.SOURCE,',
'        P_MIN_COLUMNS    => 1,',
'        P_MAX_COLUMNS    => NULL,',
'        P_COMPONENT_NAME => P_REGION.NAME,',
'        P_MAX_ROWS => C_MAXIMUM_ROWS',
'    );',
'',
'    L_COLOR_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Color Column'',',
'        P_COLUMN_ALIAS      => C_COLOR_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => C_COLOR_SCHEME = ''COLUMN'',',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    L_LABEL_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Label Column'',',
'        P_COLUMN_ALIAS      => C_LABEL_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => TRUE,',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    L_VALUE_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Value Column'',',
'        P_COLUMN_ALIAS      => C_VALUE_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => TRUE,',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    if C_ICON_TYPE = ''INITIALS'' then',
'        L_INITIALS_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'            P_ATTRIBUTE_LABEL   => ''Initials Column'',',
'            P_COLUMN_ALIAS      => C_INITIALS_COLUMN,',
'            P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'            P_IS_REQUIRED       => true,',
'            P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'        );',
'    end if;',
'    -- Begin output as JSON',
'    sys.OWA_UTIL.MIME_HEADER(''application/json'', FALSE);',
'    sys.HTP.P(''Cache-Control: no-cache'');',
'    sys.HTP.P(''Pragma: no-cache'');',
'    sys.OWA_UTIL.HTTP_HEADER_CLOSE;',
'    ',
'    IF C_COLOR_SCHEME = ''CUSTOM'' THEN',
'        L_CUSTOM_CHART_COLORS_TABLE := APEX_UTIL.STRING_TO_TABLE(CASE WHEN C_CUSTOM_CHART_COLORS IS NOT NULL THEN TRIM(BOTH '''''''' FROM APEX_ESCAPE.JS_LITERAL(C_CUSTOM_CHART_COLORS)) END, '':'');',
'        L_CUSTOM_CHART_COLORS := ''"color_scheme":['';',
'        FOR I IN L_CUSTOM_CHART_COLORS_TABLE.FIRST .. L_CUSTOM_CHART_COLORS_TABLE.LAST LOOP',
'            IF I > 1 THEN',
'                L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||'','';',
'            END IF;',
'            L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||''"''||L_CUSTOM_CHART_COLORS_TABLE(I)||''"'';',
'        END LOOP;',
'        L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||''],'';',
'    END IF;',
'',
'    L_MESSAGE_WHEN_NO_DATA_FOUND := APEX_ESCAPE.HTML_WHITELIST(',
'        APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                P_VALUE  => C_MESSAGE_WHEN_NO_DATA_FOUND,',
'                P_ESCAPE => FALSE',
'            )',
'        );',
'',
'    sys.HTP.PRN(',
'        ''{''||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''chart_type'',',
'                C_CHART_TYPE,',
'                FALSE,',
'                TRUE',
'            )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''message_when_no_data_found'',',
'            L_MESSAGE_WHEN_NO_DATA_FOUND,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''chart_css_class_names'',',
'            C_CHART_CSS_CLASSES,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''icon_type'',',
'            C_ICON_TYPE,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    IF C_COLOR_SCHEME = ''CUSTOM'' THEN',
'        sys.HTP.PRN(',
'            L_CUSTOM_CHART_COLORS',
'        );',
'    ELSE',
'        sys.HTP.PRN(',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''color_scheme'',',
'                C_COLOR_SCHEME,',
'                TRUE,',
'                TRUE',
'            )',
'        );',
'    END IF;',
'    sys.HTP.PRN(',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''text_position'',',
'                C_TEXT_POSITION,',
'                FALSE,',
'                TRUE',
'            )||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''bar_width_calculation'',',
'                C_BAR_WIDTH_CALCULATION,',
'                FALSE,',
'                TRUE',
'            )||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''display'',',
'                C_DISPLAY,',
'                FALSE,',
'                TRUE',
'            )||',
'            CASE ',
'            	WHEN C_DISPLAY IN (''VALUE'') THEN',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''prefix_for_value'',',
'						C_PREFIX_FOR_VALUE,',
'						TRUE,',
'						TRUE',
'					)||',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''postfix_for_value'',',
'						C_POSTFIX_FOR_VALUE,',
'						TRUE,',
'						TRUE',
'					)',
'			END||',
'            ''"items":[''',
'    );',
'    ',
'    --FOR L_ROW_NUMBER IN L_COLUMN_VALUE_LIST(1).VALUE_LIST.FIRST .. L_COLUMN_VALUE_LIST(1).VALUE_LIST.LAST LOOP',
'    FOR L_ROW_NUMBER IN 1 .. L_COLUMN_VALUE_LIST(1).VALUE_LIST.COUNT LOOP',
'        BEGIN',
'            APEX_PLUGIN_UTIL.SET_COMPONENT_VALUES (',
'                P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'                P_ROW_NUM => L_ROW_NUMBER ',
'            );',
'            ',
'            IF L_ROW_NUMBER > 1 THEN',
'            	sys.HTP.PRN('', '');',
'            END IF;',
'            ',
'            sys.HTP.PRN(''{'');',
'            ',
'            L_LABEL := APEX_PLUGIN_UTIL.ESCAPE (',
'                APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                    P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_LABEL_COLUMN_NUMBER).DATA_TYPE,',
'                    P_VALUE => L_COLUMN_VALUE_LIST(L_LABEL_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'                ),',
'                P_REGION.ESCAPE_OUTPUT',
'            );',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''label'',',
'                    L_LABEL,',
'                    FALSE',
'            	)',
'            );',
'            L_LABEL_LINK := ',
'                CASE ',
'                    WHEN C_LABEL_LINK IS NOT NULL THEN ',
'                        APEX_UTIL.PREPARE_URL (',
'                            APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                P_VALUE  => C_LABEL_LINK,',
'                                P_ESCAPE => FALSE',
'                            )',
'                        )',
'                END;',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''label_link'',',
'                    L_LABEL_LINK',
'                )',
'            );',
'            L_VALUE := APEX_PLUGIN_UTIL.ESCAPE (',
'               APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                   P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_VALUE_COLUMN_NUMBER).DATA_TYPE,',
'                   P_VALUE => L_COLUMN_VALUE_LIST(L_VALUE_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'               ),',
'               P_REGION.ESCAPE_OUTPUT',
'            );',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''value'',',
'                    L_VALUE,',
'                    FALSE,',
'                    C_VALUE_LINK IS NOT NULL OR L_COLOR_COLUMN_NUMBER IS NOT NULL OR C_CHART_TYPE = ''ICON''',
'                )',
'            );',
'            L_VALUE_LINK := ',
'                CASE ',
'                    WHEN C_VALUE_LINK IS NOT NULL THEN ',
'                        APEX_UTIL.PREPARE_URL (',
'                            APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                P_VALUE  => C_VALUE_LINK,',
'                                P_ESCAPE => FALSE',
'                            )',
'                        )',
'                END;',
'             sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''value_link'',',
'                    L_VALUE_LINK,',
'                    TRUE,',
'                    L_COLOR_COLUMN_NUMBER IS NOT NULL OR C_CHART_TYPE = ''ICON''',
'                )',
'            );',
'            IF L_COLOR_COLUMN_NUMBER IS NOT NULL THEN',
'                L_COLOR := APEX_PLUGIN_UTIL.ESCAPE (',
'                   APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                       P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_COLOR_COLUMN_NUMBER).DATA_TYPE,',
'                       P_VALUE => L_COLUMN_VALUE_LIST(L_COLOR_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'                   ),',
'                   P_REGION.ESCAPE_OUTPUT',
'                );',
'                sys.HTP.PRN(',
'                    APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                        ''color'',',
'                        L_COLOR,',
'                        FALSE,',
'                        C_CHART_TYPE = ''ICON''',
'                    )',
'                );',
'            END IF;',
'            IF C_ICON_TYPE = ''IMAGE'' THEN',
'				L_IMAGE_URL := ',
'                    CASE ',
'                        WHEN C_IMAGE_URL IS NOT NULL THEN ',
'                            APEX_UTIL.PREPARE_URL (',
'                                APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                    P_VALUE  => C_IMAGE_URL,',
'                                    P_ESCAPE => FALSE',
'                                )',
'                            )',
'                    END;',
'				sys.HTP.PRN(',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''image_url'',',
'						L_IMAGE_URL,',
'						FALSE,',
'						FALSE',
'					)',
'				);',
'			ELSIF C_ICON_TYPE = ''ICON'' THEN',
'				L_CSS_ICON_CLASS_NAME := APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                    P_VALUE  => C_CSS_ICON_CLASS_NAME,',
'                    P_ESCAPE => TRUE',
'                );',
'				sys.HTP.PRN(',
'                	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''icon_css_class_name'',',
'						L_CSS_ICON_CLASS_NAME,',
'						FALSE,',
'						FALSE',
'					)',
'				);',
'			ELSIF C_ICON_TYPE = ''INITIALS'' THEN',
'				L_INITIALS := APEX_PLUGIN_UTIL.ESCAPE (',
'					APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'						P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_INITIALS_COLUMN_NUMBER).DATA_TYPE,',
'						P_VALUE => L_COLUMN_VALUE_LIST(L_INITIALS_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'					),',
'					P_REGION.ESCAPE_OUTPUT',
'				);',
'				sys.HTP.PRN(',
'                	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    	''initials'',',
'	                    L_INITIALS,',
'	                    FALSE,',
'	                    FALSE',
'    	            )',
'    	        );',
'            END IF;',
'            ',
'			sys.HTP.PRN(''}'');',
'            ',
'            APEX_PLUGIN_UTIL.CLEAR_COMPONENT_VALUES;',
'        EXCEPTION',
'            WHEN OTHERS THEN',
'                APEX_PLUGIN_UTIL.CLEAR_COMPONENT_VALUES;',
'                RAISE;',
'        END;',
'    END LOOP;',
'    sys.HTP.PRN(',
'            '']''||',
'        ''}''',
'    );',
'    ',
'    RETURN NULL;',
'END AJAX;'))
,p_api_version=>1
,p_render_function=>'RENDER'
,p_ajax_function=>'AJAX'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT:ESCAPE_OUTPUT'
,p_substitute_attributes=>false
,p_reference_id=>5610141522737396215.4806
,p_subscribe_plugin_settings=>true
,p_help_text=>unistr('<p>\6B64\63D2\4EF6\7528\4E8E\7ED8\5236\5305\542B\6807\7B7E, \503C\548C\56FE\6807\7684\6C34\5E73\6761\5F62\56FE</p>')
,p_version_identifier=>'1.0'
,p_files_version=>16
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702376049193248102.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Icon Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'INITIALS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702384183128248108.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ICON'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'    <li><strong>Image</strong>: Adds an image HTML element on the left side of the chart.</li>',
'    <li><strong>CSS Icon</strong>: Unlike the &quot;Image&quot; icon, instead of displaying an image HTML element, it displays an icon with the given CSS class.</li>',
'    <li><strong>Initials</strong>: Opposed to both, the &quot;Image&quot; and &quot;CSS Icon&quot; icons, this one displays a colored circle containing the given initials.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702376477940248103.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702376049193248102.4806)
,p_display_sequence=>10
,p_display_value=>'Image'
,p_return_value=>'IMAGE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702376929650248103.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702376049193248102.4806)
,p_display_sequence=>20
,p_display_value=>'CSS Icon'
,p_return_value=>'ICON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702377407571248103.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702376049193248102.4806)
,p_display_sequence=>30
,p_display_value=>'Initials'
,p_return_value=>'INITIALS'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702377934890248104.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Label Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'<p>A query column from which the label to be displayed is given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702378330227248104.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Label Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
,p_help_text=>'<p>A URL to be opened whenever the label is clicked. This attribute supports substitution strings.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702378760212248104.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'<p>A query column from which the label to be displayed is given. Notice that this value is not displayed on the chart items when the chart has been configured to display the bar width percentage instead.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702379123993248105.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Value Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
,p_help_text=>'<p>A URL to be opened whenever the displayed value is clicked. This attribute supports substitution strings.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702379580495248105.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>5
,p_prompt=>'Chart CSS Class Names'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'<p>CSS class names to be added to the root element of the chart separated with spaces.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702379945839248105.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>13
,p_prompt=>'Image URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702376049193248102.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'IMAGE'
,p_help_text=>'<p>The Image URL to be displayed as the chart icon. This attribute supports Substitution strings referring to som query column like in <strong>&amp;IMAGE_URL.</strong> which would reference the <strong>IMAGE_URL</strong> column value for each of the '
||'bars presented on the char. Notice that substitutions with no value will be replaced with an empty string.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702380386369248106.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>12
,p_prompt=>'CSS Icon Class Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702376049193248102.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ICON'
,p_help_text=>'<p>The Icon CSS Class Name.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702380729670248106.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>14
,p_prompt=>'Initials Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702376049193248102.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'INITIALS'
,p_help_text=>'<p>A query column from which initials to be displayed as an icon are given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702381140402248106.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>7
,p_prompt=>'Custom Chart Colors'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702386914886248111.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'<p>A list of CSS supported colors separated by colons.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702381574495248106.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Display'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VALUE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'<p>Displays either the item value or the calculated bar width on the right most text in the chart item.</p>'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702381990912248107.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702381574495248106.4806)
,p_display_sequence=>10
,p_display_value=>'Value'
,p_return_value=>'VALUE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702382471385248107.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702381574495248106.4806)
,p_display_sequence=>20
,p_display_value=>'Bar Width'
,p_return_value=>'BAR_WIDTH'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702382953367248107.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Prefix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1702381574495248106.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE'
,p_help_text=>'<p>When the value is displayed on the right most side of the chart item. The value of this attribute is prepended to it.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702383375006248108.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Postfix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1702381574495248106.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE'
,p_help_text=>'<p>When the value is displayed on the right most side of the chart item. The value of this attribute is appended to it.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702383739773248108.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Maximum Rows'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'5'
,p_is_translatable=>false
,p_help_text=>'<p>The maximum number of items to be displayed inside the region. Notice bar width calculations are made based on the number of items displayed.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702384183128248108.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>4
,p_prompt=>'Chart Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'TEXT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Defines how the chart will be displayed. There are two types of chart: </p>',
'<ul>',
'    <li><strong>Icon Chart</strong>: Displays bars with the label and value above and add an icon on the left.</li>',
'    <li><strong>Text Chart</strong>: Displays bars with the label and value either above or inline with the bar.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702384515570248108.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702384183128248108.4806)
,p_display_sequence=>10
,p_display_value=>'Icon Chart'
,p_return_value=>'ICON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702385012598248109.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702384183128248108.4806)
,p_display_sequence=>20
,p_display_value=>'Text Chart'
,p_return_value=>'TEXT'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702385599241248109.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>105
,p_prompt=>'Bar Width Calculation'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ABSOLUTE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Bar widths for each one of the chart items can be calculated in two ways:</p>',
'<ul>',
'    <li><strong>Absolute</strong>: 100% bar width is represented by the maximum value on the displayed chart items.</li>',
'    <li><strong>Relative</strong>: 100% bar width is represented by the sum of the values of all the displayed chart items.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702385973332248109.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702385599241248109.4806)
,p_display_sequence=>10
,p_display_value=>'Absolute'
,p_return_value=>'ABSOLUTE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702386430586248110.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702385599241248109.4806)
,p_display_sequence=>20
,p_display_value=>'Relative'
,p_return_value=>'RELATIVE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702386914886248111.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>6
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'MODERN'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The colors to be used in the chart bars. There are two special types of configuration: </p>',
'<ul>',
'    <li><strong>Custom</strong>: Provides a text box to receive a colon separated list of css supported colors.</li>',
'</ul>',
'<ul>',
'    <li><strong>Query Column</strong>: Provides a select list with the query columns which expects a css valid color.</li>',
'</ul>',
''))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702387389176248112.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702386914886248111.4806)
,p_display_sequence=>5
,p_display_value=>'Default'
,p_return_value=>'DEFAULT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702387844518248112.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702386914886248111.4806)
,p_display_sequence=>10
,p_display_value=>'Modern'
,p_return_value=>'MODERN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702388375785248113.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702386914886248111.4806)
,p_display_sequence=>20
,p_display_value=>'Modern 2'
,p_return_value=>'MODERN_2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702388897062248113.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702386914886248111.4806)
,p_display_sequence=>30
,p_display_value=>'Solar'
,p_return_value=>'SOLAR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702389346550248113.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702386914886248111.4806)
,p_display_sequence=>40
,p_display_value=>'Metro'
,p_return_value=>'METRO'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702389837661248114.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702386914886248111.4806)
,p_display_sequence=>50
,p_display_value=>'Custom'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702390353971248114.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702386914886248111.4806)
,p_display_sequence=>60
,p_display_value=>'Query Column'
,p_return_value=>'COLUMN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702390871735248114.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>55
,p_prompt=>'Text Position'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'AROUND'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702384183128248108.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'TEXT'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When displaying a text chart, two options are available for displaying the label and value texts:</p>',
'<ul>',
'    <li><strong>Above the bar</strong>: The label and value texts are displayed above the bar at the left and right most sides of it respectively.</li>',
'    <li><strong>Inline with the bar</strong>: The label, the bar and the value are displayed in one line on that order.</li>',
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702391237749248115.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702390871735248114.4806)
,p_display_sequence=>10
,p_display_value=>'Above the bar'
,p_return_value=>'ABOVE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702391778580248115.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1702390871735248114.4806)
,p_display_sequence=>20
,p_display_value=>'Inline with the bar'
,p_return_value=>'AROUND'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702392268910248116.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>8
,p_prompt=>'Chart Colors Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702386914886248111.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'COLUMN'
,p_help_text=>'<p>A query column from which CSS supported colors are given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702392512215248116.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>200
,p_prompt=>'Message When No Data Found'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_default_value=>'No data found.'
,p_is_translatable=>true
,p_help_text=>'<p>Message to be displayed when no data was found.</p>'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(1702400146781248124.4806)
,p_plugin_id=>wwv_flow_api.id(631114846055861055.4806)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>1
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_listcalendar
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.LISTCALENDAR'
,p_display_name=>unistr('\5217\8868\65E5\5386 (\6784\5EFA\5668)')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.LISTCALENDAR'),'#IMAGE_PREFIX#plugins/com.oracle.apex.listcalendar/')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'procedure render_list_calendar( p_region in apex_plugin.t_region ) is',
'    c_date_col           constant varchar2(255) := p_region.attribute_01;',
'    c_color_col          constant varchar2(255) := p_region.attribute_02;',
'    c_title_col          constant varchar2(255) := p_region.attribute_03;',
'    c_link_col           constant varchar2(255) := p_region.attribute_04;',
'    c_row1_attr1_lbl_col constant varchar2(255) := p_region.attribute_05;',
'    c_row1_attr1_val_col constant varchar2(255) := p_region.attribute_06;',
'    c_row1_attr2_lbl_col constant varchar2(255) := p_region.attribute_07;',
'    c_row1_attr2_val_col constant varchar2(255) := p_region.attribute_08;',
'    c_row2_attr1_lbl_col constant varchar2(255) := p_region.attribute_09;',
'    c_row2_attr1_val_col constant varchar2(255) := p_region.attribute_10;',
'    c_row2_attr2_lbl_col constant varchar2(255) := p_region.attribute_11;',
'    c_row2_attr2_val_col constant varchar2(255) := p_region.attribute_12;',
'    c_description_1_col  constant varchar2(255) := p_region.attribute_13;',
'    c_description_2_col  constant varchar2(255) := p_region.attribute_14;',
'    c_description_3_col  constant varchar2(255) := p_region.attribute_15;',
'',
'    l_date_col_no           pls_integer;',
'    l_color_col_no          pls_integer;',
'    l_title_col_no          pls_integer;',
'    l_link_col_no           pls_integer;',
'    l_row1_attr1_lbl_col_no pls_integer;',
'    l_row1_attr1_val_col_no pls_integer;',
'    l_row1_attr2_lbl_col_no pls_integer;',
'    l_row1_attr2_val_col_no pls_integer;',
'    l_row2_attr1_lbl_col_no pls_integer;',
'    l_row2_attr1_val_col_no pls_integer;',
'    l_row2_attr2_lbl_col_no pls_integer;',
'    l_row2_attr2_val_col_no pls_integer;',
'    l_description_1_col_no  pls_integer;',
'    l_description_2_col_no  pls_integer;',
'    l_description_3_col_no  pls_integer;',
'',
'    l_date           timestamp with local time zone;',
'    l_color          varchar2(4000);',
'    l_color_hex      varchar2(4000);',
'    l_title          varchar2(4000);',
'    l_link           varchar2(4000);',
'    l_row1_attr1_lbl varchar2(4000);',
'    l_row1_attr1_val varchar2(4000);',
'    l_row1_attr2_lbl varchar2(4000);',
'    l_row1_attr2_val varchar2(4000);',
'    l_row2_attr1_lbl varchar2(4000);',
'    l_row2_attr1_val varchar2(4000);',
'    l_row2_attr2_lbl varchar2(4000);',
'    l_row2_attr2_val varchar2(4000);',
'    l_description_1  varchar2(4000);',
'    l_description_2  varchar2(4000);',
'    l_description_3  varchar2(4000);',
'',
'    --',
'    l_no_data_found     varchar2(32767) := p_region.no_data_found_message;',
'    l_num_rows          pls_integer     := p_region.fetched_rows;',
'    --',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_region_source        varchar2(32767) := p_region.source;',
'',
'    --',
'    l_last_month  varchar2(255) := ''x'';',
'    l_this_year   varchar2(4)   := ''x'';',
'',
'    l_found boolean;',
'    l_count pls_integer := 0;',
'begin',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => l_region_source,',
'                               p_min_columns    => 3,',
'                               p_max_columns    => null,',
'                               p_component_name => p_region.name,',
'                               p_max_rows       => null );',
'',
'    -- Get the actual column number for the fields we want.',
'    l_date_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Date column'',',
'                        p_column_alias      => c_date_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => null -- might be date, timestamp, etc.',
'                    );',
'',
'    l_color_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Color column'',',
'                        p_column_alias      => c_color_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_title_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Title column'',',
'                        p_column_alias      => c_title_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_link_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Link column'',',
'                        p_column_alias      => c_link_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr1_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Attribute Label column'',',
'                        p_column_alias      => c_row1_attr1_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr1_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Attribute Value column'',',
'                        p_column_alias      => c_row1_attr1_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr2_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Attribute Label column'',',
'                        p_column_alias      => c_row1_attr2_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr2_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Attribute Value column'',',
'                        p_column_alias      => c_row1_attr2_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr1_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Attribute Label column'',',
'                        p_column_alias      => c_row2_attr1_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr1_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Attribute Value column'',',
'                        p_column_alias      => c_row2_attr1_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr2_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Fourth Attribute Label column'',',
'                        p_column_alias      => c_row2_attr2_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr2_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Fourth Attribute Value column'',',
'                        p_column_alias      => c_row2_attr2_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_1_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Description column'',',
'                        p_column_alias      => c_description_1_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_2_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Description column'',',
'                        p_column_alias      => c_description_2_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_3_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Description column (allows HTML)'',',
'                        p_column_alias      => c_description_3_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    -- Loop through the data',
'',
'    sys.htp.p(''<div class="a-StatusList a-StatusList--dates">'');',
'',
'    for l_row_num in 1..l_column_value_list(1).value_list.count loop',
'        l_found := true;',
'',
'        if l_column_value_list(l_date_col_no).value_list(l_row_num).date_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).date_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_tz_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_tz_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_ltz_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_ltz_value;',
'        else',
'            -- Couldn''t get a usable date value; ignore this row.',
'            l_found := false;',
'        end if;',
'        if l_found = true and l_count < nvl(l_num_rows,l_count) then',
'            l_count := l_count + 1;',
'            if l_color_col_no is not null then',
'                l_color := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_color_col_no).data_type,',
'                                p_value     => l_column_value_list(l_color_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_title_col_no is not null then',
'                l_title := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_title_col_no).data_type,',
'                                p_value     => l_column_value_list(l_title_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_link_col_no is not null then',
'                l_link := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_link_col_no).data_type,',
'                                p_value     => l_column_value_list(l_link_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr1_lbl_col_no is not null then',
'                l_row1_attr1_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr1_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr1_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr1_val_col_no is not null then',
'                l_row1_attr1_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr1_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr1_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr2_lbl_col_no is not null then',
'                l_row1_attr2_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr2_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr2_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr2_val_col_no is not null then',
'                l_row1_attr2_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr2_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr2_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr1_lbl_col_no is not null then',
'                l_row2_attr1_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr1_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr1_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr1_val_col_no is not null then',
'                l_row2_attr1_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr1_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr1_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr2_lbl_col_no is not null then',
'                l_row2_attr2_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr2_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr2_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr2_val_col_no is not null then',
'                l_row2_attr2_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr2_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr2_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_1_col_no is not null then',
'                l_description_1 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_1_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_1_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_2_col_no is not null then',
'                l_description_2 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_2_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_2_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_3_col_no is not null then',
'                l_description_3 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_3_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_3_col_no).value_list(l_row_num) ),',
'                            false );',
'            end if;',
'',
'            -- Limit it down to the colors we support.',
'            l_color := initcap(l_color);',
'            if l_color not in (''Red'',''Black'',''Yellow'',''Green'') then',
'                l_color_hex := l_color;',
'                l_color     := '''';',
'            else',
'                l_color_hex := '''';',
'            end if;',
'',
'            if l_color = ''Red'' then',
'                l_color := ''is-error'';',
'            elsif l_color = ''Black'' then',
'                l_color := ''is-complete'';',
'            elsif l_color = ''Yellow'' then',
'                l_color := ''is-warning'';',
'            elsif l_color = ''Green'' then',
'                l_color := ''is-open'';',
'            end if;',
'',
'            -- Start of the actual rendering code.',
'',
'            if l_last_month != to_char(l_date,''YYYYMM'') then',
'                l_last_month := to_char(l_date,''YYYYMM'');',
'',
'                if l_count > 1 then',
'                    -- Not the first row; close the previous group.',
'                    sys.htp.p(''</ul></div>'');',
'                end if;',
'',
'                sys.htp.p(''<div class="a-StatusList-block">'');',
'                -- if to_char(l_date,''YYYY'') != l_this_year then',
'                sys.htp.p(''<h3 class="a-StatusList-blockHeader"><span class="a-StatusList-headerTextPrimary">''||trim(to_char(l_date,''Month''))||',
'                    ''</span><span class="a-StatusList-headerTextAlt">''||to_char(l_date,''YYYY'')||''</span></h3>'');',
'                l_this_year := to_char(l_date,''YYYY'');',
'                -- else',
'                    -- sys.htp.p(''<h3>''||to_char(l_date,''Month'')||''</h3>'');',
'                -- end if;',
'                sys.htp.p(''<ul class="a-StatusList-list">'');',
'            end if;',
'',
'            sys.htp.p(''<li class="a-StatusList-item ''||l_color||''"><div class="a-StatusList-itemMarker"><span class="a-StatusList-marker" role="presentation">''',
'                ||to_char(l_date,''fmDD'')||''</span></div>'');',
'            -- if l_color is not null then',
'                -- sys.htp.p(''<div class="status''||l_color||''">'');',
'            -- else',
'                -- sys.htp.p(''<div style="border-left-color: ''||l_color_hex||''">'');',
'            -- end if;',
'            sys.htp.p(''<div class="a-StatusList-itemBody">'');',
'            sys.htp.p(''<p class="a-StatusList-itemTitle"><a href="''||apex_util.prepare_url(l_link)||''">''||l_title||''</a></p>'');',
'',
'            if l_row1_attr1_lbl is not null or l_row1_attr1_val is not null',
'                    or l_row1_attr2_lbl is not null or l_row1_attr2_val is not null then',
'                sys.htp.prn(''<div class="a-StatusList-itemAttrs">'');',
'                if l_row1_attr1_lbl is not null and l_row1_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr1_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row1_attr1_val||''</span></span>'');',
'                elsif l_row1_attr1_lbl is null and l_row1_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row1_attr1_val||''</span></span>'');',
'                elsif l_row1_attr1_lbl is not null and l_row1_attr1_val is null then',
'                    sys.htp.prn(''<span><span class="a-StatusList-attrLabel">''||l_row1_attr1_lbl||''</span></span>'');',
'                else',
'                    -- No attr1.',
'                    null;',
'                end if;',
'',
'                if l_row1_attr2_lbl is not null and l_row1_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr2_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row1_attr2_val||''</span></span>'');',
'                elsif l_row1_attr2_lbl is null and l_row1_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row1_attr2_val||''</span></span>'');',
'                elsif l_row1_attr2_lbl is not null and l_row1_attr2_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr2_lbl||''</span></span>'');',
'                else',
'                    -- No attr2.',
'                    null;',
'                end if;',
'                -- sys.htp.prn(''</div>'');',
'            end if;',
'',
'            if l_row2_attr1_lbl is not null or l_row2_attr1_val is not null',
'                    or l_row2_attr2_lbl is not null or l_row2_attr2_val is not null then',
'                -- sys.htp.prn(''<p>'');',
'                if l_row2_attr1_lbl is not null and l_row2_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr1_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row2_attr1_val||''</span></span>'');',
'                elsif l_row2_attr1_lbl is null and l_row2_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row2_attr1_val||''</span></span>'');',
'                elsif l_row2_attr1_lbl is not null and l_row2_attr1_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr1_lbl||''</span></span>'');',
'                else',
'                    -- No attr3.',
'                    null;',
'                end if;',
'',
'                if l_row2_attr2_lbl is not null and l_row2_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr2_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row2_attr2_val||''</span></span>'');',
'                elsif l_row2_attr2_lbl is null and l_row2_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row2_attr2_val||''</span></span>'');',
'                elsif l_row2_attr2_lbl is not null and l_row2_attr2_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr2_lbl||''</span></span>'');',
'                else',
'                    -- No attr4.',
'                    null;',
'                end if;',
'                sys.htp.prn(''</div>'');',
'            end if;',
'',
'            if l_description_1 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_1||''</p>'');',
'            end if;',
'',
'            if l_description_2 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_2||''</p>'');',
'            end if;',
'',
'            if l_description_3 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_3||''</p>'');',
'            end if;',
'',
'            sys.htp.prn(''</div></li>'');',
'        end if;',
'    end loop;',
'    if l_count > 0 then',
'        -- Close the HTML.',
'        sys.htp.p(''</ul></div>'');',
'    else',
'        sys.htp.p(''<span class="nodatafound">''||l_no_data_found||''</span>'');',
'    end if;',
'    sys.htp.p(''</div>'');',
'end render_list_calendar;',
'',
'function render ( p_region in apex_plugin.t_region,',
'    p_plugin in apex_plugin.t_plugin, p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result is',
'begin',
'    render_list_calendar( p_region );',
'    return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render'
,p_standard_attributes=>'SOURCE_SQL:FETCHED_ROWS:NO_DATA_FOUND_MESSAGE:ESCAPE_OUTPUT'
,p_substitute_attributes=>true
,p_reference_id=>1517592169582192572.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
,p_files_version=>3
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391314686037924962.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Date column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'DATE:TIMESTAMP:TIMESTAMP_TZ:TIMESTAMP_LTZ'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391315077461924962.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Color column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391315400770924962.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Title column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391315811190924962.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Link column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391316224879924962.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'First Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391316672020924964.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'First Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391317004067924965.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Second Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391317401096924965.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Second Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391317898988924965.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Third Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391318220918924966.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Third Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391318643410924966.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Fourth Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391319032196924966.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Fourth Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
end;
/
begin
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391319359089924966.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'First Description column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391319797268924966.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Second Description column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2391320124768924966.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>150
,p_prompt=>'Third Description column (allows HTML)'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(845158421122834580.4806)
,p_plugin_id=>wwv_flow_api.id(1517634981033385167.4806)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>3
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_d3_barchart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.D3.BARCHART'
,p_display_name=>unistr('D3 \6761\5F62\56FE ***')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.D3.BARCHART'),'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.barchart/')
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/d3/3.3.11/d3.min.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3/d3.oracle.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3/oracle.jql.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3/jquery.getScrollbarWidth.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.tooltip/d3.oracle.tooltip.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.ary/d3.oracle.ary.js',
'#PLUGIN_FILES#d3.oracle.barchart.js',
'#PLUGIN_FILES#d3.oracle.barchart.apex.js',
'#PLUGIN_FILES#com.oracle.apex.d3.barchart.js'))
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.tooltip/d3.oracle.tooltip.css',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.ary/d3.oracle.ary.css',
'#PLUGIN_FILES#d3.oracle.barchart.css'))
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render ',
'(',
'    p_region                in  apex_plugin.t_region,',
'    p_plugin                in  apex_plugin.t_plugin,',
'    p_is_printer_friendly   in  boolean ',
')',
'return apex_plugin.t_region_render_result',
'is',
'    c_region_static_id      constant varchar2(255)  := apex_escape.html_attribute( p_region.static_id );',
'',
'-- Assign readable names to plugin attributes. Omit data attributes, they''ll be handled in ajax function.',
'    -- Dimensions',
'    c_height_mode           constant varchar2(200)  := p_region.attribute_21;',
'    c_min_height            constant number         := nvl(p_region.attribute_18, 100);',
'    c_max_height            constant number         := nvl(p_region.attribute_19, 500);',
'    c_spacing               constant number         := nvl(p_region.attribute_16, 20);',
'    c_inner_spacing         constant number         := nvl(p_region.attribute_17, 20);',
'',
'    -- Axis titles',
'    c_x_axis_title          constant varchar2(200)  := p_region.attribute_08;',
'    c_y_axis_title          constant varchar2(200)  := p_region.attribute_09;',
'',
'    -- Axis grid',
'    c_x_axis_grid           constant boolean        := instr('':'' || p_region.attribute_22 || '':'', '':X:'') > 0;',
'    c_y_axis_grid           constant boolean        := instr('':'' || p_region.attribute_22 || '':'', '':Y:'') > 0;',
'',
'    -- Tooltip configuration',
'    c_show_tooltip          constant boolean        := p_region.attribute_10 is not null;',
'    c_series_tooltip        constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':SERIES:'') > 0;',
'    c_x_tooltip             constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':X:'') > 0;',
'    c_y_tooltip             constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':Y:'') > 0;',
'    c_custom_tooltip        constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':CUSTOM:'') > 0;',
'',
'    -- Legend',
'    c_show_legend           constant boolean        := p_region.attribute_12 is not null;',
'    c_legend_position       constant varchar2(200)  := p_region.attribute_12;',
'',
'    -- Display modes',
'    c_value_template        constant varchar2(200)  := nvl(p_region.attribute_15, p_region.attribute_25);',
'    c_horizontal            constant boolean        := substr(p_region.attribute_06, 1, instr(p_region.attribute_06, '','') - 1) = ''HORIZONTAL'';',
'    c_display               constant varchar2(200)  := substr(p_region.attribute_06, instr(p_region.attribute_06, '','') + 1);',
'    c_responsive            constant boolean        := p_plugin.attribute_06 = ''Y'';',
'    c_transitions           constant boolean        := p_plugin.attribute_05 = ''Y'';',
'',
'    -- Colors',
'    c_color_scheme          constant varchar2(200)  := p_region.attribute_13;',
'    l_colors                varchar2(200)           := p_region.attribute_14;',
'    c_multiple_colors       constant boolean        := p_region.attribute_24 = ''Y'';',
'',
'    -- Aspect ratios',
'    c_min_ar                constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_plugin.attribute_02, ''Min Aspect Radio'' ), 1.333);',
'    c_max_ar                constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_plugin.attribute_01, ''Max Aspect Radio'' ), 3);',
'    c_threshold             constant number         := p_plugin.attribute_03;',
'    c_threshold_of          constant varchar2(200)  := p_plugin.attribute_04;',
'',
'    -- Function constants',
'    c_rgb_list_regex        constant varchar2(200)  := ''^#[0-9a-fA-F]{6}(,#[0-9a-fA-F]{6})*$'';',
'begin',
'    -- Add placeholder div',
'    sys.htp.p (',
'        ''<div class="a-D3BarChart" id="'' || c_region_static_id || ''_region">'' ||',
'            ''<div class="a-D3BarChart-container" id="'' || c_region_static_id || ''_chart"></div>'' ||',
'        ''</div>'' );',
'',
'',
'    -- Color scheme',
'    case c_color_scheme',
'        when ''MODERN'' then',
'            l_colors := ''#FF3B30:#FF9500:#FFCC00:#4CD964:#34AADC:#007AFF:#5856D6:#FF2D55:#8E8E93:#C7C7CC'';',
'        when ''MODERN2'' then',
'            l_colors := ''#1ABC9C:#2ECC71:#4AA3DF:#9B59B6:#3D566E:#F1C40F:#E67E22:#E74C3C'';',
'        when ''SOLAR'' then',
'            l_colors := ''#B58900:#CB4B16:#DC322F:#D33682:#6C71C4:#268BD2:#2AA198:#859900'';',
'        when ''METRO'' then',
'            l_colors := ''#E61400:#19A2DE:#319A31:#EF9608:#8CBE29:#A500FF:#00AAAD:#FF0094:#9C5100:#E671B5'';',
'        else',
'            null;',
'    end case;',
'',
'    -- Build the initial chart. Data will be loaded with ajax.',
'    apex_javascript.add_onload_code (',
'        p_code => ''com_oracle_apex_d3_barchart('' ||',
'            apex_javascript.add_value(p_region.static_id) ||',
'            ''{'' ||',
'                apex_javascript.add_attribute(''chartRegionId'',  p_region.static_id || ''_chart'') ||',
'                apex_javascript.add_attribute(''xAxisTitle'',     c_x_axis_title) || ',
'                apex_javascript.add_attribute(''yAxisTitle'',     c_y_axis_title) || ',
'                apex_javascript.add_attribute(''showTooltip'',    c_show_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipSeries'',  c_series_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipX'',       c_x_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipY'',       c_y_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipCustom'',  c_custom_tooltip) || ',
'                apex_javascript.add_attribute(''spacing'',        c_spacing) || ',
'                apex_javascript.add_attribute(''innerSpacing'',   c_inner_spacing) || ',
'                apex_javascript.add_attribute(''horizontal'',     c_horizontal) || ',
'                apex_javascript.add_attribute(''display'',        c_display) || ',
'                apex_javascript.add_attribute(''responsive'',     c_responsive) || ',
'                apex_javascript.add_attribute(''transitions'',    c_transitions) || ',
'                apex_javascript.add_attribute(''valueTemplate'',  c_value_template) || ',
'                apex_javascript.add_attribute(''showLegend'',     c_show_legend) || ',
'                apex_javascript.add_attribute(''legendPosition'', c_legend_position) || ',
'                apex_javascript.add_attribute(''colors'',         l_colors) || ',
'                apex_javascript.add_attribute(''xGrid'',          c_x_axis_grid) || ',
'                apex_javascript.add_attribute(''yGrid'',          c_y_axis_grid) || ',
'                apex_javascript.add_attribute(''multipleColors'', c_multiple_colors) || ',
'                apex_javascript.add_attribute(''heightMode'',     c_height_mode) || ',
'                apex_javascript.add_attribute(''minHeight'',      c_min_height) || ',
'                apex_javascript.add_attribute(''maxHeight'',      c_max_height) || ',
'                apex_javascript.add_attribute(''threshold'',      c_threshold) || ',
'                apex_javascript.add_attribute(''thresholdOf'',    c_threshold_of) || ',
'                apex_javascript.add_attribute(''minAR'',          c_min_ar) || ',
'                apex_javascript.add_attribute(''maxAR'',          c_max_ar) || ',
'                apex_javascript.add_attribute(''noDataFoundMessage'', p_region.no_data_found_message) || ',
'                apex_javascript.add_attribute(''pageItems'',      apex_plugin_util.page_item_names_to_jquery(p_region.ajax_items_to_submit)) ||',
'                apex_javascript.add_attribute(''ajaxIdentifier'', apex_plugin.get_ajax_identifier, false, false) ||',
'            ''});'' );',
'    return null;',
'end;',
'',
'function ajax',
'(',
'    p_region    in  apex_plugin.t_region,',
'    p_plugin    in  apex_plugin.t_plugin ',
')',
'return apex_plugin.t_region_ajax_result',
'is',
'    -- It''s better to have named variables instead of using the generic ones, ',
'    -- makes the code more readable. ',
'',
'    c_has_multiple_series   constant boolean := ( p_region.attribute_03 = ''Y'' );',
'',
'    -- Column names',
'    c_x_column              constant varchar2(255) := p_region.attribute_01;',
'    c_y_column              constant varchar2(255) := p_region.attribute_02;',
'    c_series_column         constant varchar2(255) := case when c_has_multiple_series then p_region.attribute_04 end;',
'    c_tooltip_column        constant varchar2(255) := p_region.attribute_11;',
'    c_link_target           constant varchar2(255) := p_region.attribute_20;',
'',
'    -- Series name, for single series configuration',
'    c_series_name           constant varchar2(200) := case when not c_has_multiple_series then p_region.attribute_05 end;',
'    c_use_sql_color         constant boolean       := p_region.attribute_13 = ''COLUMN'';',
'',
'    -- Column numbers for fetching',
'    l_x_column_no           pls_integer;',
'    l_y_column_no           pls_integer;',
'    l_series_column_no      pls_integer;',
'    l_tooltip_column_no     pls_integer;',
'    l_column_value_list     apex_plugin_util.t_column_value_list2;',
'',
'    -- Holders for row data',
'    l_x                     varchar2(200);',
'    l_y                     number;',
'    l_series                varchar2(4000);',
'    l_color                 varchar2(4000);',
'    l_tooltip               varchar2(4000);',
'    l_link                  varchar2(4000);',
'',
'begin',
'',
'    apex_json.initialize_output (',
'        p_http_cache => false );',
'',
'    apex_json.open_object;',
'',
'    -- First, we must get the color mapping if the color scheme requires it.',
'    if c_use_sql_color then',
'        l_column_value_list := apex_plugin_util.get_data2 (',
'            p_sql_statement     => p_region.attribute_23,',
'            p_min_columns       => 2,',
'            p_max_columns       => 2,',
'            p_component_name    => p_region.name );',
'',
'        apex_json.open_array(''colors'');',
'        for l_row_num in 1 .. l_column_value_list(1).value_list.count loop',
'            -- Series, optional',
'            l_series := apex_plugin_util.get_value_as_varchar2 (',
'                p_data_type => l_column_value_list(1).data_type,',
'                p_value     => l_column_value_list(1).value_list(l_row_num) );',
'            l_color := apex_plugin_util.get_value_as_varchar2 (',
'                p_data_type => l_column_value_list(2).data_type,',
'                p_value     => l_column_value_list(2).value_list(l_row_num) );',
'            ',
'            apex_json.open_object;',
'            apex_json.write(''series'', l_series);',
'            apex_json.write(''color'',  l_color);',
'            apex_json.close_object;',
'',
'        end loop;',
'        apex_json.close_array;',
'',
'        l_series := null;',
'    end if;',
'',
'    -- Then, we get the actual data points.',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'        p_sql_statement  => p_region.source,',
'        p_min_columns    => 2,',
'        p_max_columns    => 5,',
'        p_component_name => p_region.name );',
'',
'    -- Get the actual column # for faster access and also verify that the data type',
'    -- of the column matches with what we are looking for',
'    l_x_column_no := apex_plugin_util.get_column_no (',
'                p_attribute_label       => ''x column'',',
'                p_column_alias          => c_x_column,',
'                p_column_value_list     => l_column_value_list,',
'                p_is_required           => true,',
'                p_data_type             => apex_plugin_util.c_data_type_varchar2 );',
'',
'    l_y_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''y column'',',
'        p_column_alias          => c_y_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => true,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    l_series_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''series column'',',
'        p_column_alias          => c_series_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_varchar2 );',
'',
'    l_tooltip_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''tooltip column'',',
'        p_column_alias          => c_tooltip_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_varchar2 );',
'',
'    apex_json.open_array(''data'');',
'',
'    -- Fetch data',
'    for l_row_num in 1 .. l_column_value_list(1).value_list.count loop',
'        begin',
'            apex_plugin_util.set_component_values (',
'                p_column_value_list => l_column_value_list,',
'                p_row_num => l_row_num ',
'            );',
'',
'            -- X is a string, required',
'            if l_x_column_no is not null then',
'                l_x := apex_plugin_util.get_value_as_varchar2 (',
'                    p_data_type => l_column_value_list(l_x_column_no).data_type,',
'                    p_value     => l_column_value_list(l_x_column_no).value_list(l_row_num) );',
'            end if;',
'',
'            -- Y is a number, required',
'            l_y := l_column_value_list(l_y_column_no).value_list(l_row_num).number_value;',
'',
'            -- Series, optional',
'            if l_series_column_no is not null then',
'                l_series := apex_plugin_util.get_value_as_varchar2 (',
'                    p_data_type => l_column_value_list(l_series_column_no).data_type,',
'                    p_value     => l_column_value_list(l_series_column_no).value_list(l_row_num) );',
'            end if;',
'',
'            -- Tooltip, optional',
'            if l_tooltip_column_no is not null then',
'                l_tooltip := apex_plugin_util.get_value_as_varchar2 (',
'                    p_data_type => l_column_value_list(l_tooltip_column_no).data_type,',
'                    p_value     => l_column_value_list(l_tooltip_column_no).value_list(l_row_num) );',
'            end if;',
'',
'            -- Link, optional',
'            if c_link_target is not null then',
'                l_link := wwv_flow_utilities.prepare_url (',
'                    apex_plugin_util.replace_substitutions (',
'                        p_value  => c_link_target,',
'                        p_escape => false ) );',
'            end if;',
'',
'            apex_json.open_object;',
'            apex_json.write(''series'',  nvl(l_series, c_series_name));',
'            apex_json.write(''tooltip'', l_tooltip);',
'            apex_json.write(''link'',    l_link);',
'            apex_json.write(''x'',       l_x);',
'            apex_json.write(''y'',       l_y);',
'            apex_json.close_object;',
'',
'            apex_plugin_util.clear_component_values;',
'        exception when others then',
'            apex_plugin_util.clear_component_values;',
'            raise;',
'        end;',
'    end loop;',
'    apex_json.close_array;',
'    apex_json.close_object;',
'',
'    return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render'
,p_ajax_function=>'ajax'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT:NO_DATA_FOUND_MESSAGE'
,p_substitute_attributes=>false
,p_reference_id=>8312108105074277335.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'0.1'
,p_files_version=>58
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269428293674405029.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Max Aspect Ratio'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'3'
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The maximum aspect ratio that Flot line charts use to recommend a height. A max aspect ratio of 3 means that the chart''s width should be no greater than 3 times its height. It can be overridden by the ''Max Height'' setting on each region.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269428675608405029.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Min Aspect Ratio'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'1.333'
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The minimum aspect ratio that Flot line charts use to recommend a height. A min aspect ratio of 1.333 means that the chart''s width should be no less than 1.333 times its height. It can be overridden by the ''Min Height'' setting on each region.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269429021528405029.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Responsive Behavior Threshold'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'480'
,p_display_length=>5
,p_max_length=>5
,p_is_translatable=>false
,p_help_text=>'The threshold (in pixels) at which the responsive behavior will be activated.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269429446592405030.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Responsive Behavior Measure'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'WINDOW'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Whether the responsive behavior threshold will be compared to the window or the region''s width.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269429871974405030.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269429446592405030.4806)
,p_display_sequence=>10
,p_display_value=>'Window'
,p_return_value=>'WINDOW'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269430304939405030.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269429446592405030.4806)
,p_display_sequence=>20
,p_display_value=>'Region'
,p_return_value=>'REGION'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269430877400405031.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Enable Transitions'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269431217540405031.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>6
,p_display_sequence=>25
,p_prompt=>'Responsive Behavior'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269431685858405031.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'X Values Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'X'
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'The column of the region SQL query to use as X values.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269432058891405032.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Y Values Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'Y'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column of the region SQL query to use as Y values.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269432483569405032.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Multiple Series'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Enable multi-series functionality on the chart. If selected, you must select a column to use as a series identifier.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269432819655405032.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269432483569405032.4806)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269433329244405033.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Series Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'SERIES'
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(269432483569405032.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The column of the region SQL query to use as a series identifier. The values on this column will become the series'' names.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269433733169405033.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Series Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(269432483569405032.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
,p_help_text=>'The name of the single data series to be shown on the legend.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269434140634405033.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>2
,p_prompt=>'Display'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VERTICAL,SIDE-BY-SIDE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269434571323405033.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269434140634405033.4806)
,p_display_sequence=>10
,p_display_value=>'Vertical, Side by Side'
,p_return_value=>'VERTICAL,SIDE-BY-SIDE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269435009213405034.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269434140634405033.4806)
,p_display_sequence=>20
,p_display_value=>'Horizontal, Side by Side'
,p_return_value=>'HORIZONTAL,SIDE-BY-SIDE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269435518289405034.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269434140634405033.4806)
,p_display_sequence=>30
,p_display_value=>'Vertical, Stacked'
,p_return_value=>'VERTICAL,STACKED'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269436052448405034.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269434140634405033.4806)
,p_display_sequence=>40
,p_display_value=>'Horizontal, Stacked'
,p_return_value=>'HORIZONTAL,STACKED'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269436509691405035.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'X Axis Title'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_help_text=>'The label for the X axis.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269436943591405035.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Y Axis Title'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_help_text=>'The label for the Y axis.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269437312404405035.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Tooltips'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Customize what is shown on the tooltip for each data point. The ''Custom column'' option allows you to specify text for each individual data point as an additional column in the region SQL query. Leave all options unselected to disable the tooltips.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269437726574405036.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269437312404405035.4806)
,p_display_sequence=>0
,p_display_value=>'Show series name'
,p_return_value=>'SERIES'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269438266325405036.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269437312404405035.4806)
,p_display_sequence=>10
,p_display_value=>'Show X value'
,p_return_value=>'X'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269438638391405036.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269437312404405035.4806)
,p_display_sequence=>20
,p_display_value=>'Show Y value'
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269439145194405037.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269437312404405035.4806)
,p_display_sequence=>30
,p_display_value=>'Custom column'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269439686716405037.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Tooltip Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(269437312404405035.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'SERIES:X:Y:CUSTOM,SERIES:X:CUSTOM,SERIES:Y:CUSTOM,X:Y:CUSTOM,SERIES:CUSTOM,X:CUSTOM,Y:CUSTOM,CUSTOM'
,p_help_text=>'The column of the region SQL query to use as custom tooltip values.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269440018624405037.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Legend'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_default_value=>'TOP'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_null_text=>'None'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269440439080405037.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269440018624405037.4806)
,p_display_sequence=>10
,p_display_value=>'Above chart'
,p_return_value=>'TOP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269440937775405038.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269440018624405037.4806)
,p_display_sequence=>20
,p_display_value=>'Below chart'
,p_return_value=>'BOTTOM'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269441429388405038.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'MODERN'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_null_text=>'Theme Default'
,p_help_text=>'The color scheme used to render the chart. A different color will be assigned to each series.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269441832092405038.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269441429388405038.4806)
,p_display_sequence=>10
,p_display_value=>'Modern'
,p_return_value=>'MODERN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269442349407405039.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269441429388405038.4806)
,p_display_sequence=>20
,p_display_value=>'Modern 2'
,p_return_value=>'MODERN2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269442854697405039.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269441429388405038.4806)
,p_display_sequence=>30
,p_display_value=>'Solar'
,p_return_value=>'SOLAR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269443364178405039.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269441429388405038.4806)
,p_display_sequence=>40
,p_display_value=>'Metro'
,p_return_value=>'METRO'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269443878832405040.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269441429388405038.4806)
,p_display_sequence=>50
,p_display_value=>'Custom'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269444378447405040.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269441429388405038.4806)
,p_display_sequence=>60
,p_display_value=>'SQL Query'
,p_return_value=>'COLUMN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269444854625405040.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Colors'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(269441429388405038.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'A colon-separated list of color strings (e.g. #FF3377, rgba(0,25,47,0.5), blue) to use as a color scheme for the chart.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269445241842405041.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>60
,p_prompt=>'Custom Value Formatting'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'FRIENDLY'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'<li><b>,d</b> = 14,435</li>',
'<li><b>d</b> = 14435</li>',
'<li><b>,.2f</b> = 14,435.49</li>',
'<li><b>.2f</b> = 14435.49</li>',
'<li><b>.3s</b> = 14.4k</li>',
'<li><b>$,d</b> = $14,435</li>',
'<li><b>$d</b> = $14435</li>',
'<li><b>$,.2f</b> = $14,435.49</li>',
'<li><b>$.2f</b> = $14435.49</li>',
'<li><b>$.3s</b> = $14.4k</li>',
'<li><b>n" ft."</b> = 14435.49 ft. **</li>',
'<li><b>"[["$.3s"]]"</b> = [[$14.4k]] **</li>',
'<li>Refer to https://github.com/mbostock/d3/wiki/Formatting#d3_format for the full syntax specification</li>',
'</ul>',
'<br/>',
'** You may use leading and trailing double-quoted literals, but this feature is not part of the standard D3 specification'))
,p_help_text=>'The D3 format string used to format the "Y" values on axes, tooltips and legends. Write "FRIENDLY" to use sensible formatting defaults for your data.'
);
end;
/
begin
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269445659083405041.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>61
,p_prompt=>'Spacing Between Categories'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'10'
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The spacing between categories, expressed as an integer percentage (1-100).'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269446065267405041.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>62
,p_prompt=>'Spacing Between Series'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'10'
,p_display_length=>5
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(269432483569405032.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NOT_NULL'
,p_help_text=>'This spacing applies between bars of different series on the same category (X value). It is represented as an integer percentage (0-100). Affects only "Side by Side" display modes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269446424220405042.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>1
,p_prompt=>'Min Height'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The minimum height, in pixels, of the chart. Chart width will adapt to the size of the region. Defaults to 100px.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269446842173405042.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>2
,p_prompt=>'Max Height'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The maximum height, in pixels, of the chart. Chart width will adapt to the size of the region. Defaults to 500px.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269447202431405042.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>115
,p_prompt=>'Link Target'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269447642157405042.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>21
,p_display_sequence=>0
,p_prompt=>'Height Measure'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BARS'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269448027988405044.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269447642157405042.4806)
,p_display_sequence=>10
,p_display_value=>'Bars Area'
,p_return_value=>'BARS'
,p_help_text=>'Min and max height for the area where the bars are drawn. Axis labels may take additional space.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269448501450405044.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269447642157405042.4806)
,p_display_sequence=>20
,p_display_value=>'Chart Area'
,p_return_value=>'CHART'
,p_help_text=>'Min and max height will include the axes'' dimensions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269449042303405044.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>22
,p_display_sequence=>220
,p_prompt=>'Show Grid Lines'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269449457984405045.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269449042303405044.4806)
,p_display_sequence=>10
,p_display_value=>'X Axis'
,p_return_value=>'X'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269449999039405046.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269449042303405044.4806)
,p_display_sequence=>20
,p_display_value=>'Y Axis'
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269450422568405046.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>23
,p_display_sequence=>230
,p_prompt=>'Color SQL Query'
,p_attribute_type=>'SQL'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(269441429388405038.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'COLUMN'
,p_help_text=>'A SQL query that maps a series name to an RGB color. The first column must contain the series names (and those values must match the ones returned from the region SQL) and the second column must have the RGB color for the series. Both columns must be'
||' VARCHAR2.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269450847374405046.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>24
,p_display_sequence=>60
,p_prompt=>'Multiple Colors'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(269432483569405032.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(269451228596405046.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>25
,p_display_sequence=>59
,p_prompt=>'Value Formatting'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'.3s'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_null_text=>'Custom'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269451687565405047.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_display_sequence=>30
,p_display_value=>'14,435'
,p_return_value=>',.0f'
,p_help_text=>'Comma-separated thousands, integers'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269452166583405047.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_display_sequence=>40
,p_display_value=>'14435'
,p_return_value=>'.0f'
,p_help_text=>'Integer'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269452659612405047.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_display_sequence=>60
,p_display_value=>'14,435.49'
,p_return_value=>',.2f'
,p_help_text=>'Comma-separated thousands, 2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269453194424405048.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_display_sequence=>70
,p_display_value=>'14435.49'
,p_return_value=>'.2f'
,p_help_text=>'2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269453656482405048.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_display_sequence=>71
,p_display_value=>'14.4k'
,p_return_value=>'.3s'
,p_help_text=>'Precision 3, SI suffixes'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269454128587405048.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_display_sequence=>80
,p_display_value=>'$14,435'
,p_return_value=>'$,.0f'
,p_help_text=>'Currency, comma-separated thousands, integer'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269454691410405049.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_display_sequence=>90
,p_display_value=>'$14435'
,p_return_value=>'$.0f'
,p_help_text=>'Currency, integer'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269455118383405049.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_display_sequence=>99
,p_display_value=>'$14,435.49'
,p_return_value=>'$,.2f'
,p_help_text=>'Currency, comma-separated thousands, 2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269455615350405049.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_display_sequence=>100
,p_display_value=>'$14435.49'
,p_return_value=>'$.2f'
,p_help_text=>'Currency, 2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(269456171238405050.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(269451228596405046.4806)
,p_display_sequence=>120
,p_display_value=>'$14.4k'
,p_return_value=>'$.3s'
,p_help_text=>'Currency, precison 3, SI suffixes'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(845158571842834582.4806)
,p_plugin_id=>wwv_flow_api.id(1544727435094305961.4806)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>2
,p_sql_max_column_count=>5
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_css_bar_chart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1810040859814215495.4806)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.CSS_BAR_CHART'
,p_display_name=>unistr('CSS \6761\5F62\56FE')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.CSS_BAR_CHART'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'procedure render_bar_chart (',
'    p_region in apex_plugin.t_region )',
'is',
'    -- constants for the columns of our region source query',
'    c_label_col constant pls_integer := 1;',
'    c_value_col constant pls_integer := 2;',
'    c_url_col   constant pls_integer := 3;',
'    c_color_col constant pls_integer := 4;',
'',
'    -- attributes of the plug-in',
'    l_display_as           varchar2(20)    := nvl(p_region.attribute_01, ''VALUE_ABSOLUTE'');',
'    l_value_prefix         varchar2(40)    := p_region.attribute_02;',
'    l_value_postfix        varchar2(40)    := p_region.attribute_03;',
'    -- page items to submit = p_region.attribute_09',
'    l_max_rows             number          := to_number(p_region.attribute_10);',
'    l_region_source        varchar2(32767) := p_region.source;',
'',
'    l_valid_data_type_list wwv_flow_global.vc_arr2;',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_max_value            number;',
'    l_total_value          number;',
'    l_label                varchar2(4000);',
'    l_value                number;',
'    l_url                  varchar2(4000);',
'    l_color                varchar2(4000);',
'    l_width                number;',
'    l_display_value        varchar2(4000);',
'begin',
'',
'    -- if percentage is displayed then the value will always have % as postfix',
'    if l_display_as like ''PERCENTAGE%'' then',
'        l_value_postfix := '' %'';',
'    end if;',
'',
'    -- define the valid column data types for the region query',
'    l_valid_data_type_list(c_label_col) := apex_plugin_util.c_data_type_varchar2;',
'    l_valid_data_type_list(c_value_col) := apex_plugin_util.c_data_type_number;',
'    l_valid_data_type_list(c_url_col)   := apex_plugin_util.c_data_type_varchar2;',
'    l_valid_data_type_list(c_color_col) := apex_plugin_util.c_data_type_varchar2;',
'',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => l_region_source,',
'                               p_min_columns    => 2,',
'                               p_max_columns    => 4,',
'                               p_data_type_list => l_valid_data_type_list,',
'                               p_component_name => p_region.name,',
'                               p_max_rows       => l_max_rows );',
'',
'    -- calculate the total or max value depending on "Display As"',
'    -- We could rewrite the region query with SUM(xxx) over ()',
'    -- but that would require that we know how the columns are named in the query.',
'    -- That''s why we just do a simple loop of the tiny array to get the',
'    -- total/max value which is probably faster anyway',
'    if l_display_as like ''%RELATIVE'' then',
'        l_total_value := 0;',
'        for i in 1 .. l_column_value_list(c_value_col).value_list.count loop',
'            -- $$$ what should we do if VALUE is NULL??? Set l_total_value to NULL as well?',
'            l_total_value := l_total_value + l_column_value_list(c_value_col).value_list(i).number_value;',
'        end loop;',
'    else',
'        l_max_value := 0;',
'        for i in 1 .. l_column_value_list(c_value_col).value_list.count loop',
'            -- $$$ what should we do if VALUE is NULL??? Set l_max_value to NULL as well?',
'            if l_column_value_list(c_value_col).value_list(i).number_value > l_max_value then',
'                l_max_value := l_column_value_list(c_value_col).value_list(i).number_value;',
'            end if;',
'        end loop;',
'    end if;',
'',
'    -- print our bar chart',
'    sys.htp.p(''<table class="cbc" border="0" cellspacing="0" cellpadding="0" ''||wwv_flow_utilities.get_layout_table_attributes||''>'');',
'',
'    for i in 1 .. l_column_value_list(c_label_col).value_list.count loop',
'        l_label := sys.htf.escape_sc(l_column_value_list(c_label_col).value_list(i).varchar2_value);',
'        l_value := l_column_value_list(c_value_col).value_list(i).number_value;',
'',
'        -- get the value of the URL and color only if the column exists in the SQL statement',
'        if l_column_value_list.exists(c_url_col) then',
'            l_url := wwv_flow_utilities.prepare_url (',
'                         apex_application.do_substitutions (',
'                             l_column_value_list(c_url_col).value_list(i).varchar2_value ));',
'        end if;',
'        if l_column_value_list.exists(c_color_col) then',
'            l_color := lower(l_column_value_list(c_color_col).value_list(i).varchar2_value);',
'            -- map a few of the standard colors to better looking ones',
'            l_color := case l_color',
'                         when ''red''     then ''#e10''',
'                         when ''yellow''  then ''#fd0''',
'                         when ''green''   then ''#0c0''',
'                         when ''black''   then ''#555''',
'                         when ''default'' then ''#ddd''',
'                         else l_color',
'                       end;',
'        end if;',
'',
'        -- calculate how long the chart bar should be',
'        if l_display_as like ''%RELATIVE'' then',
'            if l_total_value = 0 then',
'                l_width := 0;',
'            else',
'                l_width := round(l_value * 100 / l_total_value);',
'            end if;',
'        else',
'            if l_max_value = 0 then',
'                l_width := 0;',
'            else',
'                l_width := round(l_value * 100 / l_max_value);',
'            end if;',
'        end if;',
'',
'        if l_display_as like ''PERCENTAGE%'' then',
'            l_value := l_width;',
'        end if;',
'',
'        l_display_value := case when l_value_prefix is not null then l_value_prefix||'' '' end||',
'                           trim(to_char(l_value, ''999G999G999G990''))||',
'                           case when l_value_postfix is not null then '' ''||l_value_postfix end;',
'',
'        sys.htp.p(''<tr>'');',
'',
'        -- print label column and add link if an URL has been specified in the SQL statement',
'        -- otherwise just print the label',
'        sys.htp.p(''<td class="label"><span class="cbc_label">'');',
'        if l_url is not null then',
'            sys.htp.p(''<a href="''||l_url||''">''||l_label||''</a>'');',
'        else',
'            sys.htp.p(l_label);',
'        end if;',
'        sys.htp.p(''</span></td>'');',
'',
'        -- print chart bar',
'        sys.htp.p(''<td>'');',
'        sys.htp.p(''<span class="cbc_bar_background">'');',
'',
'        -- add link if an URL has been specified in the SQL statement otherwise just print the value',
'        if l_url is not null then',
'            sys.htp.p(''<span class="cbc_value"><a href="''||l_url||''">''||l_display_value||''</a></span>'');',
'        else',
'            sys.htp.p(''<span class="cbc_value">''||l_display_value||''</span>'');',
'        end if;',
'        ',
'        sys.htp.p (',
'            ''<span class="cbc_bar" style="width:''||l_width||''%;''||',
'            case when l_color is not null then ''background-color:''||l_color end||',
'            ''"></span>'' );',
'        sys.htp.p(''</span>'');',
'        sys.htp.p(''</td>'');',
'',
'        sys.htp.p(''</tr>'');',
'    end loop;',
'',
'    sys.htp.p(''</table>'');',
'end render_bar_chart;',
'',
'',
'function render (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result',
'is',
'    l_page_items_to_submit varchar2(4000)  := p_region.attribute_09;',
'begin',
'    apex_css.add_file (',
'        p_name      => ''css_bar_chart'',',
'        p_directory => p_plugin.file_prefix,',
'        p_version   => null );',
'',
'    sys.htp.p (''',
'<!--[if IE]> ',
'<style type="text/css" media="screen">',
'.cbc .cbc_bar_background {',
'  background-color: #FFF;',
'  border: 1px solid #AAA;',
'}',
'.cbc .cbc_value {',
'  color: #000;',
'  border-right: 1px solid #AAA;',
'}',
'.cbc .cbc_value a {',
'  color: #000;',
'}',
'.cbc .cbc_value a:hover {',
'  text-decoration: underline',
'}',
'</style>',
'<![endif]-->'');',
'',
'    -- print our region data',
'    sys.htp.p(''<div id="''||p_region.static_id||''_chart" class="cbc">'');',
'',
'    render_bar_chart (',
'        p_region => p_region );',
'',
'    sys.htp.p(''</div>'');',
'',
'    apex_javascript.add_library (',
'        p_name      => ''com_oracle_apex_css_bar_chart'',',
'        p_directory => p_plugin.file_prefix,',
'        p_version   => null );',
'',
'    apex_javascript.add_onload_code (',
'        p_code => ''com_oracle_apex_css_bar_chart(''||',
'                      apex_javascript.add_value(p_region.static_id)||',
'                      ''{''||',
'                      apex_javascript.add_attribute(''pageItemsToSubmit'', apex_plugin_util.page_item_names_to_jquery(l_page_items_to_submit))||',
'                      apex_javascript.add_attribute(''ajaxIdentifier'',    apex_plugin.get_ajax_identifier, false, false)||',
'                      ''});'' );',
'',
'    return null;',
'end render;',
'',
'function ajax (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin )',
'    return apex_plugin.t_region_ajax_result',
'is',
'begin',
'    sys.owa_util.mime_header(''text/html'', false);',
'    sys.htp.p(''Cache-Control: no-cache'');',
'    sys.htp.p(''Pragma: no-cache'');',
'    sys.owa_util.http_header_close;',
'',
'    render_bar_chart (',
'        p_region => p_region );',
'',
'    return null;',
'exception when others then',
'    sys.htp.p(''Error: ''||sqlerrm);',
'end ajax;'))
,p_api_version=>1
,p_render_function=>'render'
,p_ajax_function=>'ajax'
,p_standard_attributes=>'SOURCE_SQL'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'0.9'
,p_about_url=>'http://apex.oracle.com/plugins'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1810041172628219212.4806)
,p_plugin_id=>wwv_flow_api.id(1810040859814215495.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Display As'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VALUE_ABSOLUTE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(911932646986785091.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1810041172628219212.4806)
,p_display_sequence=>1
,p_display_value=>'Percentage with absolute bar width'
,p_return_value=>'PERCENTAGE_ABSOLUT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(911933160838789138.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1810041172628219212.4806)
,p_display_sequence=>1
,p_display_value=>'Percentage with relative bar width'
,p_return_value=>'PERCENTAGE_RELATIVE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(911933736035791364.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1810041172628219212.4806)
,p_display_sequence=>1
,p_display_value=>'Value with absolute bar width'
,p_return_value=>'VALUE_ABSOLUTE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(911934242961793350.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(1810041172628219212.4806)
,p_display_sequence=>1
,p_display_value=>'Value with relative bar width'
,p_return_value=>'VALUE_RELATIVE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1810041651634222605.4806)
,p_plugin_id=>wwv_flow_api.id(1810040859814215495.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Prefix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>10
,p_max_length=>40
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1810041172628219212.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE_ABSOLUTE,VALUE_RELATIVE'
,p_help_text=>'Specify the prefix which should be added to the displayed value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1810042158560224678.4806)
,p_plugin_id=>wwv_flow_api.id(1810040859814215495.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Postfix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>10
,p_max_length=>40
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1810041172628219212.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE_ABSOLUTE,VALUE_RELATIVE'
,p_help_text=>'Specify the postfix which should be added to the displayed value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(911937056036816081.4806)
,p_plugin_id=>wwv_flow_api.id(1810040859814215495.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Page Items to Submit'
,p_attribute_type=>'PAGE ITEMS'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Specify a comma separated list of page items that will be submitted to the server and thus, available for use from within your region source SQL statement.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1810042775529229535.4806)
,p_plugin_id=>wwv_flow_api.id(1810040859814215495.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Maximum Rows'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'5'
,p_display_length=>3
,p_max_length=>3
,p_is_translatable=>false
,p_help_text=>'Defines the maximum number of rows to query and to display.'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(845158625180834584.4806)
,p_plugin_id=>wwv_flow_api.id(1810040859814215495.4806)
,p_name=>'SOURCE_SQL'
,p_is_required=>false
,p_sql_min_column_count=>2
,p_sql_max_column_count=>4
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The region source has to be in the following format:',
'<pre>',
'select label,',
'       value,',
'       [link,]',
'       [color]',
'  from table',
' order by value',
'</pre>',
'<ul>',
'<li><strong>Label</strong> is the label ...</li>',
'<li><strong>Value</strong> is the value ... and has to be of type NUMBER</li>',
'<li><strong>Link</strong> is optional and can allow a user to navigate to another page within the application or a provided URL, and is activated by clicking on the chart bar of the record.</li>',
'<li><strong>Color</strong> is optional and is the background color of the chart bar for the record. The color is a hex value (for example #ff0000) or one of the standard web colors like red, green, ...</li>',
'</ul>',
'<h5>Example with a link column</h5>',
'<pre>',
'select ename,',
'       sal,',
'       ''f?p=&APP_ID.:300:''||:APP_SESSION||''::::P300_EMPNO:''||empno as link',
'  from emp',
' order by sal desc',
'</pre>'))
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_tag_cloud
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1817061076891492217.4806)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.TAG_CLOUD'
,p_display_name=>unistr('\6807\8BB0\4E91 2')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.TAG_CLOUD'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result',
'is',
'    -- Constants for the columns of our region source query',
'    c_tag_col   constant pls_integer := 1;',
'    c_count_col constant pls_integer := 2;',
'',
'    -- attributes of the plug-in',
'    l_target_url           varchar2(4000)  := p_region.attribute_01;',
'    l_max_display_tags     number          := p_region.attribute_02;',
'    l_show_count           boolean         := nvl(p_region.attribute_03,''Y'') = ''Y'';',
'',
'',
'    l_valid_data_type_list wwv_flow_global.vc_arr2;',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_printed_records    number := 0;',
'    l_available_records  number := 20;',
'    l_max                number;',
'    l_min                number;',
'    l_total              number := 0;',
'    l_cnts               number;',
'    l_tag                varchar2(4000);',
'',
'    l_class_size         number;',
'    l_class              varchar2(30);',
'',
'begin',
'    -- don''t need to load css file, styles are contained within theme_42',
'    ',
'    -- apex_css.add_file (',
'    --     p_name      => ''tag_cloud'',',
'    --     p_directory => p_plugin.file_prefix,',
'    --     p_version   => null );',
'',
'',
'    -- define the valid column data types for the region query',
'    l_valid_data_type_list(c_tag_col) := apex_plugin_util.c_data_type_varchar2;',
'    l_valid_data_type_list(c_count_col) := apex_plugin_util.c_data_type_number;',
'',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => p_region.source,',
'                               p_min_columns    => 2,',
'                               p_max_columns    => 2,',
'                               p_data_type_list => l_valid_data_type_list,',
'                               p_component_name => p_region.name );',
'',
'   l_available_records := l_column_value_list(c_tag_col).value_list.count;',
'',
'   -----------------------------------------------',
'   -- Determine total count and maximum tag counts',
'   --',
'   l_max := 0;',
'   l_min := 1000;',
'   FOR i in 1.. l_column_value_list(c_count_col).value_list.count loop',
'      l_cnts := l_column_value_list(c_count_col).value_list(i).number_value;',
'      l_total := l_total + l_cnts;',
'      if l_cnts > l_max then',
'         l_max := l_cnts;',
'      end if;',
'      if l_cnts < l_min then',
'         l_min := l_cnts;',
'      end if;',
'   end loop;',
'   if l_max = 0 then l_max := 1; end if;',
'',
'',
'   l_class_size := round((l_max-l_min)/6);',
'',
'   ------------------------',
'   -- Generate tag cloud --',
'   --',
'   ',
'   sys.htp.prn(''<ul class="a-TagCloud">'');',
'',
'   for i in 1.. l_column_value_list(c_tag_col).value_list.count loop',
'       l_printed_records := l_printed_records + 1;',
'       l_tag := sys.htf.escape_sc(l_column_value_list(c_tag_col).value_list(i).varchar2_value);',
'       l_cnts := l_column_value_list(c_count_col).value_list(i).number_value;',
'       if l_cnts < l_min + l_class_size then',
'          l_class := ''size1'';',
'       elsif l_cnts < l_min + (l_class_size*2) then',
'          l_class := ''size2'';',
'       elsif l_cnts < l_min + (l_class_size*3) then',
'          l_class := ''size3'';',
'       elsif l_cnts < l_min + (l_class_size*4) then',
'          l_class := ''size4'';',
'       elsif l_cnts < l_min + (l_class_size*5) then',
'          l_class := ''size5'';',
'       else l_class := ''size6'';',
'       end if;      ',
'       ',
'        sys.htp.prn(''<li class="a-TagCloud-item">''',
'            ||apex_plugin_util.get_link(',
'                p_url  => replace(l_target_url,''#TAG#'',l_tag),',
'                p_text => l_tag',
'                            ||case when l_show_count then',
'                                '' <span class="a-TagCloud-count">''||l_cnts||''</span>''',
'                            end,',
'                p_escape_text => false,',
'                p_attributes => ''class="a-TagCloud-link a-TagCloud-link--''',
'                    ||l_class||''"'')',
'            ||''</li>'');',
'',
'       if  l_printed_records > l_max_display_tags then',
'           exit;',
'       end if;',
'   end loop;',
'',
'   sys.htp.prn(''</ul>'');',
'',
'   return null;',
'end render;'))
,p_api_version=>1
,p_render_function=>'render'
,p_standard_attributes=>'SOURCE_SQL'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1817093257676524478.4806)
,p_plugin_id=>wwv_flow_api.id(1817061076891492217.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Target URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:2:&APP_SESSION.::::P2_FILTER:#TAG#'
,p_display_length=>60
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1817094657461533933.4806)
,p_plugin_id=>wwv_flow_api.id(1817061076891492217.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Maximum Displayed Tags'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>4
,p_max_length=>4
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1817095468196537048.4806)
,p_plugin_id=>wwv_flow_api.id(1817061076891492217.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Show Count'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(845158704100834585.4806)
,p_plugin_id=>wwv_flow_api.id(1817061076891492217.4806)
,p_name=>'SOURCE_SQL'
,p_is_required=>false
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2075480277045967334.4806)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>unistr('\6DFB\52A0\201C\5168\90E8\9009\4E2D\201D\590D\9009\6846')
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512.4806
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>"\6DFB\52A0\201C\5168\90E8\9009\4E2D\201D\590D\9009\6846" \52A8\6001\64CD\4F5C\5C06\5305\542B #CHECK_ALL_CHECKBOX# \5B57\7B26\4E32\7684\5217\6807\9898\8F6C\6362\4E3A\53EF\8BBF\95EE\7684\201C\5168\90E8\9009\4E2D\201D\6837\5F0F\590D\9009\6846, \4F7F\7528\6B64\9879\5C06\9009\4E2D\548C\53D6\6D88\9009\4E2D\5BF9\5E94\5217\4E2D\7684\6240\6709\590D\9009\6846\3002<p>'),
'<p>',
unistr('\8981\4F7F\7528\6B64\63D2\4EF6, \8BF7\786E\4FDD\8BBE\7F6E\4E86\4EE5\4E0B\5C5E\6027:'),
'<ol>',
unistr('<li>\5728\62A5\8868\5217\4E2D, \5C06 ''#CHECK_ALL_CHECKBOX#'' \5B9A\4E49\4E3A\6807\9898\503C\3002</li>'),
unistr('<li>\5BF9\4E8E\52A8\6001\64CD\4F5C\201CWhen\201D\5C5E\6027, \8BF7\9009\62E9\5305\542B\5217\7684\62A5\8868\533A\57DF\3002</li>'),
unistr('<li>\5B9A\4E49\52A8\6001\64CD\4F5C\4EE5\89E6\53D1 ''\5237\65B0\540E'', \5E76\5B9A\4E49\64CD\4F5C\4EE5 ''\52A0\8F7D\9875\65F6\89E6\53D1''\3002(\5982\679C\5728\9875\8BBE\8BA1\5668\7684 ''\5448\73B0'' \90E8\5206\4E2D\9009\62E9\533A\57DF\5E76\5728\6B64\5904\521B\5EFA\52A8\6001\64CD\4F5C, \5219\8FD9\4E24\9879\5C06\6210\4E3A\76F8\5E94\7684\9ED8\8BA4\503C\3002)</li>'),
unistr('<li>\8FD9\4E0D\4F1A\5904\7406\5728\6BCF\4E00\884C\4E0A\5448\73B0\7684\590D\9009\6846\7684\53EF\8BBF\95EE\6027, \8BE5\64CD\4F5C\5FC5\987B\5728\533A\57DF\6E90\4E2D\5355\72EC\5B8C\6210\3002(\6709\5173\793A\4F8B, \8BF7\53C2\9605 4000:656 ''\533A\57DF'' \90E8\5206)\3002</li>'),
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_raphael_justgage
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.RAPHAEL.JUSTGAGE'
,p_display_name=>unistr('JustGage \8BA1\91CF\8868 ***')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.RAPHAEL.JUSTGAGE'),'#IMAGE_PREFIX#plugins/com.oracle.apex.raphael.justgage/1.0/')
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#PLUGIN_FILES#plugin.js',
'#PLUGIN_FILES#justgage.js',
'#IMAGE_PREFIX#libraries/raphaeljs/2.1.2/apex.raphael.min.js'))
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render ',
'(',
'    p_region                in  apex_plugin.t_region,',
'    p_plugin                in  apex_plugin.t_plugin,',
'    p_is_printer_friendly   in  boolean ',
')',
'return apex_plugin.t_region_render_result',
'is',
'    -- Assign readable names to plugin attributes. Omit data attributes, they''ll be handled in ajax function.',
'    -- Label configuration',
'    c_show_labels           constant boolean        := p_region.attribute_04 = ''Y'';',
'    l_title                 varchar(200)            := nvl(p_region.attribute_05, '''');',
'    l_units                 varchar(200)            := nvl(p_region.attribute_06, '''');',
'    l_value_prefix          varchar(200)            := nvl(p_region.attribute_07, '''');',
'    l_value_suffix          varchar(200)            := nvl(p_region.attribute_08, '''');',
'    l_show_min_max          boolean                 := nvl(p_region.attribute_09, ''N'') = ''Y'';',
'    c_description_template  constant varchar(2000)  := apex_plugin_util.replace_substitutions(',
'                                                           nvl(p_region.attribute_20, ''''));',
'    l_heading               varchar(200)            := apex_plugin_util.replace_substitutions(',
'                                                           nvl(p_region.attribute_21, ''''));',
'',
'    -- Shadow configuration',
'    c_show_shadow           constant boolean        := nvl(p_region.attribute_10, ''N'') = ''Y'';',
'    c_shadow_opacity        constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_region.attribute_11, ''Shadow Opacity'' ), 0 );',
'    c_shadow_offset         constant number         := to_number(nvl(p_region.attribute_12, 0));',
'',
'    -- Gauge configuration',
'    c_gauge_width           constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_region.attribute_13, ''Gauge Width Scale'' ), 1 );',
'    c_gauge_color_scheme    constant varchar(200)   := p_region.attribute_14;',
'    l_gauge_colors          varchar(200)            := p_region.attribute_15;',
'    l_gauge_bg_color        varchar(200)            := p_region.attribute_16;',
'    c_gauge_mode            constant varchar(200)   := p_region.attribute_17;',
'    c_width                 constant number         := p_region.attribute_18;',
'    c_height                constant number         := p_region.attribute_19;',
'    c_decimals              constant number         := greatest(nvl(p_region.attribute_24, 0), 0);',
'    l_width_style           varchar(200)            := '''';',
'    l_height_style          varchar(200)            := '''';',
'',
'    -- Function constants',
'    c_rgb_single_regex      constant varchar2(200)  := ''^#[0-9a-fA-F]{6}$'';',
'    c_rgb_list_regex        constant varchar2(200)  := ''^#[0-9a-fA-F]{6}(,#[0-9a-fA-F]{6})*$'';',
'begin',
'    -- Size style settings',
'    if c_width is not null then ',
'        l_width_style := ''width:'' || c_width || ''px;'';',
'    end if;',
'    if c_height is not null then ',
'        l_height_style := ''height:'' || c_height || ''px;'';',
'    end if;',
'',
'    -- Add placeholder div',
'    sys.htp.p (',
'        ''<div class="a-BadgeChart a-BadgeChart--justGage" id="'' || p_region.static_id || ''_container">'' ||',
'            ''<div class="a-JustGage-desc"></div>'' ||',
'            ''<div id="'' || p_region.static_id || ''_gauge" class="a-JustGage-chart" style="'' || l_width_style || l_height_style || ''"></div>'' ||',
'            ''<div class="a-BadgeChart-text">'' ||',
'                ''<span class="a-BadgeChart-label"></span>'' ||',
'                ''<span class="a-BadgeChart-desc"></span>'' ||',
'            ''</div>'' ||',
'        ''</div>'');',
'',
'    -- Labels defaults',
'    if not c_show_labels then',
'        l_title := '''';',
'        l_units := '''';',
'        l_value_prefix := '''';',
'        l_value_suffix := '''';',
'        l_show_min_max := false;',
'    end if;',
'',
'    -- Donut mode has no min/max value labels',
'    l_show_min_max := l_show_min_max and c_gauge_mode <> ''donut'';',
'',
'    -- Validate shadow configuration',
'    if c_show_shadow then',
'        if c_shadow_opacity < 0 or c_shadow_opacity > 1 then',
'            -- invalid option',
'            null;',
'        end if; ',
'    end if;',
'',
'    -- Validate gauge configuration',
'    if c_gauge_width <= 0 then',
'        -- invalid option',
'        null;',
'    end if;',
'    case c_gauge_color_scheme',
'        when ''GTR'' then',
'            l_gauge_colors := ''#56bd0d,#f0dc05,#f52900'';',
'        when ''RTG'' then',
'            l_gauge_colors := ''#f52900,#f0dc05,#56bd0d'';',
'        else',
'            l_gauge_colors := replace(l_gauge_colors, '' '', '''');',
'            if not regexp_like(l_gauge_colors, c_rgb_list_regex) then',
'                -- invalid option',
'                null;',
'            end if;',
'    end case;',
'    l_gauge_bg_color := replace(l_gauge_bg_color, '' '', '''');',
'    if not regexp_like(l_gauge_bg_color, c_rgb_single_regex) then',
'        -- invalid option',
'        null;',
'    end if;',
'',
'    -- Build the initial chart. Data will be loaded with ajax.',
'    apex_javascript.add_onload_code (',
'        p_code => ''com_oracle_apex_raphael_justgage('' ||',
'            apex_javascript.add_value(p_region.static_id) ||',
'            ''{'' ||',
'                apex_javascript.add_attribute(''regionId'',       p_region.static_id || ''_gauge'') || ',
'                apex_javascript.add_attribute(''title'',          l_title) || ',
'                apex_javascript.add_attribute(''units'',          l_units) || ',
'                apex_javascript.add_attribute(''valuePrefix'',    l_value_prefix) || ',
'                apex_javascript.add_attribute(''valueSuffix'',    l_value_suffix) || ',
'                apex_javascript.add_attribute(''roundTo'',        c_decimals) || ',
'                apex_javascript.add_attribute(''showMinMax'',     l_show_min_max) || ',
'                apex_javascript.add_attribute(''showShadow'',     c_show_shadow) || ',
'                apex_javascript.add_attribute(''shadowOpacity'',  c_shadow_opacity) || ',
'                apex_javascript.add_attribute(''shadowOffset'',   c_shadow_offset) || ',
'                apex_javascript.add_attribute(''gaugeWidth'',     c_gauge_width) || ',
'                apex_javascript.add_attribute(''gaugeColors'',    l_gauge_colors) || ',
'                apex_javascript.add_attribute(''gaugeBgColor'',   l_gauge_bg_color) || ',
'                apex_javascript.add_attribute(''gaugeMode'',      c_gauge_mode) || ',
'                apex_javascript.add_attribute(''heading'',        l_heading) || ',
'                apex_javascript.add_attribute(''description'',    c_description_template) || ',
'                apex_javascript.add_attribute(''pageItems'',      apex_plugin_util.page_item_names_to_jquery(p_region.ajax_items_to_submit)) ||',
'                apex_javascript.add_attribute(''ajaxIdentifier'', apex_plugin.get_ajax_identifier, false, false) ||',
'            ''});'' );',
'    return null;',
'end;',
'',
'',
'function ajax ',
'(',
'    p_region    in  apex_plugin.t_region,',
'    p_plugin    in  apex_plugin.t_plugin ',
')',
'return apex_plugin.t_region_ajax_result',
'is',
'    -- It''s better to have named variables instead of using the generic ones, ',
'    -- makes the code more readable. ',
'    c_value_column          constant varchar2(255) := p_region.attribute_01;',
'    c_min_column            constant varchar2(255) := p_region.attribute_02;',
'    c_max_column            constant varchar2(255) := p_region.attribute_03;',
'    c_heading_link          constant varchar2(4000) := p_region.attribute_22;',
'    c_description_link      constant varchar2(4000) := p_region.attribute_23;',
'',
'    l_value_column_no       pls_integer;',
'    l_min_column_no         pls_integer;',
'    l_max_column_no         pls_integer;',
'    l_column_value_list     apex_plugin_util.t_column_value_list2;',
'',
'    l_value                 number;',
'    l_min                   number;',
'    l_max                   number;',
'    l_heading_link          varchar2(4000);',
'    l_description_link      varchar2(4000);',
'begin',
'    apex_plugin_util.print_json_http_header;',
'',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'        p_sql_statement     => p_region.source,',
'        p_min_columns       => 1,',
'        p_max_columns       => 3,',
'        p_component_name    => p_region.name );',
'',
'    -- Get the actual column # for faster access and also verify that the data type',
'    -- of the column matches with what we are looking for',
'    l_value_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''value column'',',
'        p_column_alias          => c_value_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => true,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    l_min_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''min value column'',',
'        p_column_alias          => c_min_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    l_max_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''min value column'',',
'        p_column_alias          => c_max_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    -- Fetch the data',
'    if l_column_value_list(1).value_list.count = 1 then',
'        apex_plugin_util.set_component_values (',
'            p_column_value_list => l_column_value_list,',
'            p_row_num => 1 ',
'        );',
'    ',
'        l_heading_link := case',
'            when c_heading_link is not null then',
'                apex_util.prepare_url (',
'                    apex_plugin_util.replace_substitutions (',
'                        p_value  => c_heading_link,',
'                        p_escape => false',
'                    )',
'                )',
'        end;',
'        ',
'        l_description_link := case',
'            when c_description_link is not null then',
'                apex_util.prepare_url (',
'                    apex_plugin_util.replace_substitutions (',
'                        p_value  => c_description_link,',
'                        p_escape => false',
'                    )',
'                )',
'        end;',
'        ',
'        l_value := l_column_value_list(l_value_column_no).value_list(1).number_value;',
'        if l_min_column_no is not null then',
'            l_min := l_column_value_list(l_min_column_no).value_list(1).number_value;',
'        end if;',
'        if l_max_column_no is not null then',
'            l_max := l_column_value_list(l_max_column_no).value_list(1).number_value;',
'        end if;',
'        ',
'        apex_plugin_util.clear_component_values;',
'    else',
'        --invalid number of rows',
'        null;',
'    end if;',
'',
'    -- Default value to 0.',
'    l_value := nvl(l_value, 0);',
'',
'    -- Default min value to 0.',
'    l_min := nvl(l_min, 0);',
'',
'    -- Default max value to the smallest power of 10 equal to or greater than the value, starting with 100.',
'    if l_max is null then',
'        l_max := 100;',
'        loop',
'            exit when l_max >= l_value;',
'            l_max := l_max * 10;',
'        end loop;',
'    end if;',
'',
'    -- Print the actual, max and min values',
'    sys.htp.prn (',
'        ''[{'' ||',
'            apex_javascript.add_attribute(''headingLink'',  l_heading_link) ||',
'            apex_javascript.add_attribute(''descriptionLink'',  l_description_link) ||',
'            apex_javascript.add_attribute(''value'',  l_value) ||',
'            apex_javascript.add_attribute(''min'',    l_min) ||',
'            apex_javascript.add_attribute(''max'',    l_max, false, false) ||',
'        ''}]'' );',
'',
'    return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render'
,p_ajax_function=>'ajax'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT'
,p_substitute_attributes=>false
,p_reference_id=>7534122046207970661.4806
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
,p_files_version=>7
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024566006922217497.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'VALUE'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column that contains the value to be represented on the gauge.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024566459475217497.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Min Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_default_value=>'MIN'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column containing the minimum value represented by the gauge. When the value is equal or lesser than the minimum, the gauge will be shown as completely empty empty. If left empty, the minimum value defaults to 0.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024566820788217497.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Max Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_default_value=>'MAX'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column containing the maximum value represented by the gauge. When the value is equal or greater than the minimum, the gauge will be shown as completely full. If left blank, the maximum value defaults to the lesser power of 10 greater than the va'
||'lue.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024567226982217497.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Show Labels'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2024567694645217498.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(2024567226982217497.4806)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024568179255217498.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Title'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2024567226982217497.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The text for the label above the gauge.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024568572042217498.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Units'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2024567226982217497.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The text for the label immediately below the gauge value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024568973037217498.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Value Prefix'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>2
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2024567226982217497.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The value label will be prefixed with this text.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024569328942217498.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Value Suffix'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>2
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2024567226982217497.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'This text will be appended to the value label.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024569706043217499.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Show Min and Max Values'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2024575436651217502.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'GAUGE'
,p_lov_type=>'STATIC'
,p_help_text=>'Whether to the actual minimum and maximum values on the gauge.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2024570175327217500.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(2024569706043217499.4806)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024570614290217500.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Show Shadow'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Whether to render a shadow gradient on the gauge.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2024571067803217500.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(2024570614290217500.4806)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024571595028217500.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Shadow Opacity'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_default_value=>'0.5'
,p_display_length=>5
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2024570614290217500.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The opacity of the shadow, measured between 0 and 1.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024571926025217500.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Shadow Offset'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'0'
,p_display_length=>5
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2024570614290217500.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The vertical offset of the shadow, in pixels.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024572331527217501.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Gauge Width Scale'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_default_value=>'1'
,p_display_length=>5
,p_max_length=>5
,p_is_translatable=>false
,p_help_text=>'The scale of the gauge''s width.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024572720629217501.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'GTR'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2024573166023217501.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(2024572720629217501.4806)
,p_display_sequence=>10
,p_display_value=>'Dynamic Green-to-Red'
,p_return_value=>'GTR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2024573694854217502.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(2024572720629217501.4806)
,p_display_sequence=>20
,p_display_value=>'Dynamic Red-to-Green'
,p_return_value=>'RTG'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2024574133662217502.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(2024572720629217501.4806)
,p_display_sequence=>30
,p_display_value=>'Custom Color(s)'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024574643349217502.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>150
,p_prompt=>'Gauge Color(s)'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'#144485'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2024572720629217501.4806)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'A comma-separated list of RGB colors to be used on the gauge. The first color will be used when the value is near the minimum and the last color will be used when the value is near the maximum. Leave only one color for a solid fill.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024575098386217502.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>160
,p_prompt=>'Empty Color'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'#d9d9d9'
,p_display_length=>10
,p_is_translatable=>false
,p_help_text=>'The color to be used on the ''empty'' sector of the gauge.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024575436651217502.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>1
,p_prompt=>'Gauge Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'GAUGE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Whether to render the gauge as a half circle or as a full circle.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2024575810780217503.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(2024575436651217502.4806)
,p_display_sequence=>10
,p_display_value=>'Normal'
,p_return_value=>'GAUGE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2024576355168217503.4806)
,p_plugin_attribute_id=>wwv_flow_api.id(2024575436651217502.4806)
,p_display_sequence=>20
,p_display_value=>'Donut'
,p_return_value=>'DONUT'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024576842074217503.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>2
,p_prompt=>'Width'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The fixed width of the gauge, in pixels. Leave blank for automatic/responsive.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024577293606217503.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>3
,p_prompt=>'Height'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The fixed height of the gauge, in pixels. Leave blank for automatic/responsive.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024577615236217504.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>91
,p_prompt=>'Description'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'To be shown under the Gauge. You may use the following text replacements:',
'<ul>',
'<li>:MIN:</li>',
'<li>:MAX:</li>',
'<li>:VALUE:</li>',
'</ul>',
'Example:<br/>',
'The actual value is :VALUE: (out of :MAX:)'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024578016670217504.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>21
,p_display_sequence=>95
,p_prompt=>'Heading'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_max_length=>200
,p_is_translatable=>true
,p_help_text=>'The heading is displayed directly above the description and is commonly set to the label for the chart.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024578418790217504.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>22
,p_display_sequence=>96
,p_prompt=>'Heading Link Target'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'A URL to which the user will be redirected when the heading gets clicked. This attribute supports substitution strings.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024578800101217504.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>23
,p_display_sequence=>92
,p_prompt=>'Description Link Target'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'A URL to which the user will be redirected when the description gets clicked. This attribute supports substitution strings.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2024579204197217505.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>24
,p_display_sequence=>240
,p_prompt=>'Decimals'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_default_value=>'0'
,p_display_length=>5
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(845158820849834587.4806)
,p_plugin_id=>wwv_flow_api.id(2361265739436040384.4806)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>1
,p_sql_max_column_count=>3
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(4969129446302342.4806)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>unistr('\684C\9762')
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>3
,p_home_url=>'f?p=&APP_ID.:4000:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4806
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\5168\5C40\9875')
,p_step_title=>'0'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1664171026663419.4806)
,p_plug_name=>unistr('\5E9F\5F03\901A\77E5')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="border-width: 0 0 1px 0"'
,p_plug_template=>wwv_flow_api.id(38103840603408731.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_source=>'htp.p(wwv_flow_lang.system_message(''APEX.TEAM.DEPRECATED''));'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(31675615659401489.4806)
,p_plug_name=>'widget for ws'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BEFORE_FOOTER'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="rollover" style="position:absolute;display:none;">',
'  <table cellpadding="1" cellspacing="0" border="0" width="100%">',
'    <tr>',
'      <td><input type="text" onkeyup="html_Find(''rollover_content'',this.value);" style="width:150px;" id="search" /><img onclick="ws_SearchApply()" src="#IMAGE_PREFIX#ws/find_20x.gif" /></td>',
'    </tr>',
'    <tr>',
'      <td>',
unistr('        <span id="sortup"><img src="#IMAGE_PREFIX#ws/dup.gif" alt="\5347\5E8F\6392\5E8F" title="\5347\5E8F\6392\5E8F" onclick="gReport.column.order(''ASC'')" /></span>'),
unistr('        <span id="sortdown"><img src="#IMAGE_PREFIX#ws/ddown.gif" alt="\964D\5E8F\6392\5E8F" title="\964D\5E8F\6392\5E8F" onclick="gReport.column.order(''DESC'')" /></span>'),
unistr('        <span id="removefilter"><img src="#IMAGE_PREFIX#ws/no_filter.gif" alt="\5220\9664\8FC7\6EE4\5668" title="\5220\9664\8FC7\6EE4\5668" onclick="gReport.column.filter_delete()" /></span>'),
unistr('        <span id="hide"><img src="#IMAGE_PREFIX#ws/trash.gif" alt="\9690\85CF\5217" title="\9690\85CF\5217" onclick="gReport.column.hide()" /></span>'),
unistr('        <span id="break"><img src="#IMAGE_PREFIX#ws/break_col.gif" alt="\5206\9694\5217" title="\5206\9694\5217" onclick="gReport.column.break_on()" /></span>'),
'      </td>',
'    </tr>',
'  </table>',
'  <div id="rollover_content"></div>',
'</div>',
''))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table border="0" cellspacing="0" cellpadding="0" id="rollover" style="position:absolute;display:none;" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#aria/top1.png" width="10" height="11" alt="" /></td>',
'    <td style="background-image:url(#IMAGE_PREFIX#aria/top2.png)"></td>',
'    <td><img src="#IMAGE_PREFIX#aria/top3.png" width="10" height="11" alt="" /></td>',
'  </tr>',
'  <tr>',
'    <td style="background-image:url(#IMAGE_PREFIX#aria/middle1.png)"><img src="#IMAGE_PREFIX#aria/middle1.png" width="10" height="1" /></td>',
'    <td style="background:#FFF;"><table cellpadding="1" cellspacing="0" border="0"><tr><td><input type="text" onkeyup="ws_SearchUp()" id="search" /></td><td><img onclick="ws_SearchApply()" src="#IMAGE_PREFIX#htmldb/icons/small_find.gif" /></td></tr><'
||'/table><div id="rollover_content"></div></td>',
'    <td style="background-image:url(#IMAGE_PREFIX#aria/middle2.png)"><img src="#IMAGE_PREFIX#aria/middle2.png" width="10" height="1" /></td>',
'  </tr>',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#aria/bottom1.png" width="10" height="11"></td>',
'    <td style="background-image:url(#IMAGE_PREFIX#aria/bottom2.png)"></td>',
'    <td><img src="#IMAGE_PREFIX#aria/bottom3.png" width="10" height="11"></td>',
'  </tr>',
'</table>'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37849625717303836.4806)
,p_plug_name=>'search'
,p_region_name=>'apex-search'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(408696048877049411.4806)
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388402496701409491.4806)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-team-dev'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388402615747409491.4806)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(388402496701409491.4806)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37845134759259192.4806)
,p_plug_name=>'APEX 5 - Tabs'
,p_region_name=>'a_Header_menu'
,p_parent_plug_id=>wwv_flow_api.id(388402615747409491.4806)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(719134156016191341.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388372306498350236.4806)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388403092660409491.4806)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(388402615747409491.4806)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388403274188409491.4806)
,p_plug_name=>'APEX 5 - Home Link'
,p_parent_plug_id=>wwv_flow_api.id(388402615747409491.4806)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388402839279409491.4806)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(388402496701409491.4806)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(384689659322932811.4806)
,p_plug_name=>'APEX 5 - Search'
,p_parent_plug_id=>wwv_flow_api.id(388402839279409491.4806)
,p_region_css_classes=>'a-Header-search'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-SearchBox a-SearchBox--noGoButton a-SearchBox--autoExpand a-SearchBox--fill">'');',
'sys.htp.p(''  <div class="a-SearchBox-field">'');',
'sys.htp.p(''    <span class="a-SearchBox-icon"><span class="a-Icon icon-search"></span></span>'');',
'sys.htp.p(''    <label for="P0_SEARCH" class="visuallyhidden">Search Team Development</label>'');',
'sys.htp.p(''    <input type="text" class="a-SearchBox-input" id="P0_SEARCH" placeholder="''||wwv_flow_lang.system_message(''WWV_FLOW_QUICK_FLOW.SEARCH.TEAM.DEV'')||''">'');',
'sys.htp.p(''  </div>'');',
'sys.htp.p(''</div>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388403478057409492.4806)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_api.id(388402839279409491.4806)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388520807823218403.4806)
,p_plug_name=>'APEX 5 - Administration Menu'
,p_region_name=>'adminMenu'
,p_parent_plug_id=>wwv_flow_api.id(388403478057409492.4806)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697622747626463876.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388372628384350238.4806)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(486772343299301733.4806)
,p_plug_name=>'APEX 5 - Help Menu'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_api.id(388403478057409492.4806)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697627751607465406.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388372628384350238.4806)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388403646511409492.4806)
,p_plug_name=>'APEX 5 - Account'
,p_parent_plug_id=>wwv_flow_api.id(388402839279409491.4806)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388521608795227162.4806)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-team-dev'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>310
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'4000'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388522431943228593.4806)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_api.id(388521608795227162.4806)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>320
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388524378377242472.4806)
,p_plug_name=>'APEX 5 - Breadcrumb'
,p_parent_plug_id=>wwv_flow_api.id(388522431943228593.4806)
,p_region_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_display_point=>'BODY'
,p_menu_id=>wwv_flow_api.id(87572326820728567.4806)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(388374331020352607.4806)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388522639163228593.4806)
,p_plug_name=>'APEX 5 - Control Bar Right'
,p_parent_plug_id=>wwv_flow_api.id(388521608795227162.4806)
,p_region_css_classes=>'a-ControlBar-col'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>330
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388526508799277054.4806)
,p_plug_name=>'APEX 5 - Navigation Icons'
,p_region_name=>'apex-control-icons'
,p_parent_plug_id=>wwv_flow_api.id(388522639163228593.4806)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(408696048877049411.4806)
,p_plug_display_sequence=>340
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(177367416819197659.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(210442022107070716.4806)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(233600707269079606.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(388403478057409492.4806)
,p_button_name=>'SPOTLIGHT'
,p_button_static_id=>'header-spotlightSearch'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388504981151147634.4806)
,p_button_image_alt=>unistr('Spotlight \641C\7D22')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-actionButton a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-search'
,p_button_cattributes=>'data-action="spotlight-search"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(384689242237932807.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(388403274188409491.4806)
,p_button_name=>'HOME'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388504981151147634.4806)
,p_button_image_alt=>unistr('\4E3B\9875')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4500:1000:&APP_SESSION.'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-home'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(384689378135932808.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(388403478057409492.4806)
,p_button_name=>'ADMINISTRATION'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388504758229147633.4806)
,p_button_image_alt=>unistr('\7BA1\7406')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(384689442168932809.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(388403478057409492.4806)
,p_button_name=>'FEEDBACK'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388504981151147634.4806)
,p_button_image_alt=>unistr('\53CD\9988')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
,p_required_patch=>wwv_flow_api.id(693446095934505835.4806)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(384689594080932810.4806)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(388403478057409492.4806)
,p_button_name=>'HELP'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388504758229147633.4806)
,p_button_image_alt=>unistr('\5E2E\52A9')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37850237146307202.4806)
,p_name=>'P0_SEARCH'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(37849625717303836.4806)
,p_prompt=>unistr('\641C\7D22')
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.SEARCHBOX'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(4930629023777300.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'f?p=&APP_ID.:8800:&SESSION.:::RIR:IR_ROWFILTER:'
,p_attribute_02=>unistr('\641C\7D22')
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_api.create_page(
 p_id=>2.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\5B9E\7528\7A0B\5E8F')
,p_step_title=>unistr('\5B9E\7528\7A0B\5E8F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(637441482420448238.4806)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'td_util.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(232930406294470706.4806)
,p_plug_name=>unistr('\5B9E\7528\7A0B\5E8F')
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-MediaList--cols a-MediaList--2cols'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>11
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(181214517334339823.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(503074507846538480.4806)
,p_plug_name=>unistr('\5173\4E8E')
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>\4F7F\7528\8FD9\4E9B\5B9E\7528\7A0B\5E8F\53EF\7BA1\7406\5C0F\7EC4\5F00\53D1\6570\636E\3002</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1267072915645447802.4806)
,p_plug_name=>unistr('\5F85\529E\4E8B\9879\5B9E\7528\7A0B\5E8F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>21
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(1267129315456592267.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_plug_column_width=>'apex-col--bottomBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1267139176712604876.4806)
,p_plug_name=>unistr('Bug \5B9E\7528\7A0B\5E8F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>31
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(1267134969329603031.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(698626121681757633.4806)
,p_plug_column_width=>'apex-col--leftBorder apex-col--bottomBorder'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1042076487144564133.4806)
,p_computation_sequence=>10
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'&APP_PAGE_ID.'
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_api.create_page(
 p_id=>3.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\63A8\8FDF\529F\80FD')
,p_step_title=>unistr('\63A8\8FDF\529F\80FD')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'td_util.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(253905231016104341.4806)
,p_plug_name=>unistr('\8FC7\671F\529F\80FD')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--responsiveIconView'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(678363858364331062.4806)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P3a */',
'  id,',
'  wwv_flow_item.checkbox(1,wwv_flow_escape.html(id),''title="''||wwv_flow_lang.system_message(''SELECT_ROW_C'', wwv_flow_escape.html(feature_id)||'': ''||wwv_flow_escape.html(feature_name))||''"'') c,',
'  feature_id||'': ''||feature_name feature_name,',
'  feature_owner,',
'  DUE_DATE,',
'  due_date + nvl(:P3_PUSH,0) new_due_date,',
'  sysdate - due_date days_late,',
'  RELEASE,',
'  FOCUS_AREA,',
'  FEATURE_DESC,',
'  FEATURE_PRIORITY,',
'  (select l.status_name||'' (''||l.pct_complete||''%)'' d',
'     from   wwv_flow_feature_def_st_codes l',
'     where  l.pct_complete = f.feature_status)',
'     feature_STATUS,',
'  FEATURE_TAGS',
'from wwv_flow_features f',
'where',
'  security_group_id = :flow_security_group_id and',
'  due_date is not null and',
'  nvl(FEATURE_STATUS,1) < 100 and',
'  due_date < trunc(sysdate) and',
'  (nvl(:P3_RELEASE,''0'') = ''0'' or nvl(release,''0'') = nvl(:P3_RELEASE,''0'')) and',
'  nvl(FEATURE_STATUS,0) < nvl(:P3_MAXIMUM_STATUS,70)'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(253905330528104341.4806)
,p_name=>'Past Due Features'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8BE2\8FD4\56DE\7684\884C\6570\8D85\8FC7\4E86 10,000, \8BF7\8FC7\6EE4\6570\636E\4EE5\786E\4FDD\83B7\5F97\5B8C\6574\7ED3\679C\3002')
,p_no_data_found_message=>unistr('\672A\627E\5230\529F\80FD\3002')
,p_allow_report_saving=>'N'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_finder_drop_down=>'N'
,p_report_list_mode=>'NONE'
,p_show_detail_link=>'N'
,p_show_computation=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(253905501429104348.4806)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(253905620579104355.4806)
,p_db_column_name=>'FEATURE_NAME'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\529F\80FD')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(253905726962104356.4806)
,p_db_column_name=>'FEATURE_OWNER'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\6240\6709\8005')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(253905813605104356.4806)
,p_db_column_name=>'DUE_DATE'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\622A\6B62\65E5\671F')
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(253905902800104357.4806)
,p_db_column_name=>'DAYS_LATE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\5EF6\671F\5929\6570')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(253906912820118859.4806)
,p_db_column_name=>'RELEASE'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('\53D1\884C\7248')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(253907032513118861.4806)
,p_db_column_name=>'FOCUS_AREA'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\4FA7\91CD\9886\57DF')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(253907131185118862.4806)
,p_db_column_name=>'FEATURE_DESC'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('\8BF4\660E')
,p_allow_sorting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_column_type=>'CLOB'
,p_tz_dependent=>'N'
,p_rpt_show_filter_lov=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(253907208916118863.4806)
,p_db_column_name=>'FEATURE_PRIORITY'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('\4F18\5148\7EA7')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(253907713990128669.4806)
,p_db_column_name=>'FEATURE_STATUS'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('\72B6\6001')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(255899307223590525.4806)
,p_db_column_name=>'FEATURE_TAGS'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>unistr('\529F\80FD\6807\8BB0')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(72837612050184787.4806)
,p_db_column_name=>'NEW_DUE_DATE'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>unistr('\65B0\622A\6B62\65E5\671F')
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1081055984134274931.4806)
,p_db_column_name=>'C'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>'#CHECK_ALL_CHECKBOX#'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(253912328076274622.4806)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-Form--labelsAbove:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(254088213429154694.4806)
,p_plug_name=>'Hidden'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>40
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1119578970350188944.4806)
,p_plug_name=>unistr('\5B9E\7528\7A0B\5E8F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(181214517334339823.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1119656326264443003.4806)
,p_plug_name=>unistr('\5173\4E8E')
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5728\8BBE\7F6E "\53D1\884C\7248", "\6700\9AD8\72B6\6001" \548C "\63A8\8FDF\5929\6570" \8FC7\6EE4\5668\4EE5\83B7\53D6\8981\63A8\8FDF\7684\529F\80FD\5217\8868\4E4B\540E, '),
unistr('\4F7F\7528<strong>\8BBE\7F6E</strong>\6309\94AE\3002\7136\540E\5728\62A5\8868\4E2D\9009\4E2D/\53D6\6D88\9009\4E2D\8981\63A8\8FDF\7684\529F\80FD, \5E76\5728\5B8C\6210\540E\5355\51FB<strong>\63A8\8FDF\529F\80FD</strong>\6309\94AE\3002</p>')))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(253908531567152698.4806)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(253912328076274622.4806)
,p_button_name=>'P3_SET'
,p_button_static_id=>'P3_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(404863755706629583.4806)
,p_button_image_alt=>unistr('\8BBE\7F6E')
,p_button_position=>'BODY'
,p_request_source=>'Set'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(253910304733182799.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(253912328076274622.4806)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:RP,3,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(253899511174054499.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(253912328076274622.4806)
,p_button_name=>'APPLYCHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\63A8\8FDF\529F\80FD')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(970052784104740615.4806)
,p_branch_name=>'Return to Utilities'
,p_branch_action=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(253899022215054498.4806)
,p_name=>'P3_PUSH'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(253912328076274622.4806)
,p_item_default=>'7'
,p_prompt=>unistr('\63A8\8FDF\5929\6570')
,p_source=>'7'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>4
,p_cMaxlength=>2000
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6807\8BC6\8981\5C06\6240\6709\9009\5B9A\529F\80FD\7684\622A\6B62\65E5\671F\63A8\8FDF\7684\5929\6570\3002')
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(253907820355139968.4806)
,p_name=>'P3_RELEASE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(253912328076274622.4806)
,p_item_default=>'0'
,p_prompt=>unistr('\53D1\884C\7248')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select default_release',
'from wwv_flow_task_defaults',
'where security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \5168\90E8 -')
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_new_grid=>true
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5C06\62A5\8868\9650\5236\4E3A\7279\5B9A\53D1\884C\7248, \6216\8005\663E\793A\6240\6709\53D1\884C\7248\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(254088426243158451.4806)
,p_name=>'P3_PUSH_COUNT'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(254088213429154694.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(255897706615571404.4806)
,p_name=>'P3_MAXIMUM_STATUS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(253912328076274622.4806)
,p_item_default=>'70'
,p_prompt=>unistr('\6700\9AD8\72B6\6001')
,p_source=>'70'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FEATURE STATUS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select status_name ||'' - ''||pct_complete||''%'' d, pct_complete r',
'from wwv_flow_feature_def_st_codes',
'order by pct_complete'))
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6807\8BC6\5E0C\671B\663E\793A\5728\6B64\62A5\8868\4E2D\7684\6700\9AD8\72B6\6001\3002\6B64\62A5\8868\5C06\4EC5\663E\793A\4E0D\8D85\8FC7\6700\5927\503C\7684\503C\7684\72B6\6001\4EE3\7801\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(970055177253740639.4806)
,p_name=>'P3_CHKBX_LABEL'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(253912328076274622.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(253908818323167749.4806)
,p_computation_sequence=>10
,p_computation_item=>'P3_RELEASE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select default_release',
'from wwv_flow_task_defaults',
'where security_group_id = :flow_security_group_id'))
,p_compute_when=>'P3_RELEASE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(970055257921740640.4806)
,p_computation_sequence=>20
,p_computation_item=>'P3_CHKBX_LABEL'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'wwv_flow_lang.system_message(''F4400_CHKBOX_SELECTALL'') || ''/'' || wwv_flow_lang.system_message(''F4400_CHKBOX_DESELECTALL'')'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(255864821449661317.4806)
,p_validation_name=>'P3_PUSH'
,p_validation_sequence=>10
,p_validation=>'P3_PUSH'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('\503C\5FC5\987B\4E3A\6570\5B57')
,p_when_button_pressed=>wwv_flow_api.id(253899511174054499.4806)
,p_associated_item=>wwv_flow_api.id(253899022215054498.4806)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2045581177651367908.4806)
,p_name=>'ADD CHECK ALL CHECKBOX'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(253905231016104341.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2045581288728367909.4806)
,p_event_id=>wwv_flow_api.id(2045581177651367908.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'PLUGIN_COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(254056421938996376.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Push Features'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  c pls_integer := 0;',
'  d pls_integer := 0;',
'  l_id number;',
'begin',
'd := round(nvl(:p3_push,7));',
'for i in 1..wwv_flow.g_f01.count loop',
'    l_id := to_number(wwv_flow.g_f01(i));',
'    update wwv_flow_features ',
'    set DUE_DATE = trunc(DUE_DATE) + d',
'    where security_group_id = :flow_security_group_id and',
'    id = l_id;',
'    c := c + 1;',
'end loop;',
':p3_push_count := c;',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(253899511174054499.4806)
,p_process_success_message=>unistr('&P3_PUSH_COUNT. \9879\529F\80FD\5DF2\63A8\8FDF &P3_PUSH. \5929')
);
end;
/
prompt --application/pages/page_00004
begin
wwv_flow_api.create_page(
 p_id=>4.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\6DFB\52A0\6587\4EF6')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\6DFB\52A0\6587\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(694252054065447551.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_required_patch=>wwv_flow_api.id(314413317596395364.4806)
,p_dialog_height=>'400'
,p_dialog_width=>'650'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(314416713685484282.4806)
,p_plug_name=>unistr('\6587\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(314421119357495369.4806)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(314417100760484282.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(314421119357495369.4806)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\5220\9664')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P4_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(314417002738484282.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(314421119357495369.4806)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5E94\7528\66F4\6539')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P4_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(314416908996484282.4806)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(314421119357495369.4806)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\6DFB\52A0\6587\4EF6')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P4_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(314418121961484284.4806)
,p_name=>'P4_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(314416713685484282.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(314418328065484289.4806)
,p_name=>'P4_COMPONENT_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(314416713685484282.4806)
,p_prompt=>unistr('\5F85\529E\4E8B\9879')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'TODOS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select task_name d, id r',
'from wwv_flow_tasks',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(314418523308484289.4806)
,p_name=>'P4_COMPONENT_TYPE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(314416713685484282.4806)
,p_prompt=>unistr('\7EC4\4EF6\7C7B\578B')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'TEAM_DEV_FILE_COMPONENTS'
,p_lov=>'.'||wwv_flow_api.id(320401714586742779.4806)||'.'
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\9644\52A0\8BE5\6587\4EF6\7684\5C0F\7EC4\5F00\53D1\7EC4\4EF6\3002')
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(314418726828484289.4806)
,p_name=>'P4_FILENAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(314416713685484282.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('\8F93\5165\6587\4EF6\540D')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(314418906949484289.4806)
,p_name=>'P4_FILE_MIMETYPE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(314416713685484282.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(314419117530484290.4806)
,p_name=>'P4_FILE_CHARSET'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(314416713685484282.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(314419301111484290.4806)
,p_name=>'P4_FILE_BLOB'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(314416713685484282.4806)
,p_prompt=>unistr('\6587\4EF6')
,p_display_as=>'NATIVE_FILE'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(487444999901719038.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\5728\6587\4EF6\7CFB\7EDF\4E0A\67E5\627E\6587\4EF6\5E76\5C06\5176\9644\52A0\5230\5C0F\7EC4\5F00\53D1\7EC4\4EF6\3002')
,p_attribute_01=>'WWV_FLOW_FILES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(314419516662484290.4806)
,p_name=>'P4_FILE_COMMENTS'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(314416713685484282.4806)
,p_prompt=>unistr('\8BF4\660E')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('\8F93\5165\6587\4EF6\8BF4\660E')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(322373029356618593.4806)
,p_name=>'P4_GO_TO_PAGE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(314416713685484282.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(829746014935396004.4806)
,p_validation_name=>'apex$team_dev_files table exists'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_workspace_schema varchar2(255);',
'begin',
'    select first_schema_provisioned',
'    into l_workspace_schema',
'    from wwv_flow_companies',
'    where provisioning_company_id = :flow_security_group_id;',
'',
'    for c1 in (select null',
'               from sys.dba_tables',
'               where owner = l_workspace_schema',
'               and table_name = ''APEX$TEAM_DEV_FILES'')',
'    loop',
'        return true;',
'    end loop;',
'    return false;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\7F3A\5C11\5B58\50A8\5C0F\7EC4\5F00\53D1\6587\4EF6\6240\9700\7684\8868\3002\8BF7\4E0E\5DE5\4F5C\533A\7BA1\7406\5458\8054\7CFB\3002')
,p_when_button_pressed=>wwv_flow_api.id(314416908996484282.4806)
,p_associated_item=>wwv_flow_api.id(.4806)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(318074912735690444.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.add_file (',
'    p_component_id    => :P4_COMPONENT_ID,',
'    p_component_type  => ''TODO'',',
'    p_file_name       => :P4_FILE_BLOB,',
'    p_file_comments   => :P4_FILE_COMMENTS',
'    );'))
,p_process_error_message=>unistr('\65E0\6CD5\6DFB\52A0\6587\4EF6\3002')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(314416908996484282.4806)
,p_process_success_message=>unistr('\6587\4EF6\5DF2\6DFB\52A0\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(314421009722484292.4806)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'4'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(314417100760484282.4806)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(694445455078427527.4806)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\63A8\8FDF Bug')
,p_step_title=>unistr('\63A8\8FDF Bug')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(389138863817227422.4806)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'td_util.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(255902530693625842.4806)
,p_plug_name=>'Hidden'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>40
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(255903131456625855.4806)
,p_plug_name=>unistr('\8FC7\671F Bug')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P5a */',
'  id,',
'  wwv_flow_item.checkbox(1,wwv_flow_escape.html(id),''title="''||wwv_flow_lang.system_message(''SELECT_ROW_C'', wwv_flow_escape.html(bug_title))||''"'') c,',
'  bug_title,',
'  ASSIGNED_TO,',
'  ESTIMATED_FIX_DATE,',
'  sysdate - ESTIMATED_FIX_DATE days_late,',
'  FIX_BY_RELEASE RELEASE,',
'  PRIORITY,',
'  (select l.the_name||'' (''||l.id||''%)'' d',
'     from   wwv_flow_bug_status_codes l',
'     where  l.id = b.bug_status)',
'     feature_STATUS,',
'  TAGS',
'from wwv_flow_bugs b',
'where',
'  security_group_id = :flow_security_group_id and',
'  ESTIMATED_FIX_DATE is not null and',
'  BUG_STATUS < 100 and',
'  ESTIMATED_FIX_DATE < trunc(sysdate) and',
'  (nvl(:P5_RELEASE,''0'') = ''0'' or FIX_BY_RELEASE = :P5_RELEASE) and',
'  nvl(bug_status,0) < nvl(:P5_MAXIMUM_STATUS,90)'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(255903304190625858.4806)
,p_name=>'Past Due Features'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8BE2\8FD4\56DE\7684\884C\6570\8D85\8FC7\4E86 10,000, \8BF7\8FC7\6EE4\6570\636E\4EE5\786E\4FDD\83B7\5F97\5B8C\6574\7ED3\679C\3002')
,p_no_data_found_message=>unistr('\672A\627E\5230 Bug\3002')
,p_allow_report_saving=>'N'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_finder_drop_down=>'N'
,p_show_search_bar=>'N'
,p_show_search_textbox=>'N'
,p_show_actions_menu=>'N'
,p_report_list_mode=>'NONE'
,p_show_detail_link=>'N'
,p_show_rows_per_page=>'N'
,p_show_filter=>'N'
,p_show_sort=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_reset=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(255903422330625861.4806)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(970054818814740636.4806)
,p_db_column_name=>'C'
,p_display_order=>2
,p_column_identifier=>'Q'
,p_column_label=>'#CHECK_ALL_CHECKBOX#'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(255903807005625864.4806)
,p_db_column_name=>'DAYS_LATE'
,p_display_order=>21
,p_column_identifier=>'E'
,p_column_label=>unistr('\5EF6\671F\5929\6570')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(255903911111625865.4806)
,p_db_column_name=>'RELEASE'
,p_display_order=>31
,p_column_identifier=>'F'
,p_column_label=>unistr('\53D1\884C\7248')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(255904320336625869.4806)
,p_db_column_name=>'FEATURE_STATUS'
,p_display_order=>41
,p_column_identifier=>'J'
,p_column_label=>unistr('\72B6\6001')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(255910010611686074.4806)
,p_db_column_name=>'BUG_TITLE'
,p_display_order=>51
,p_column_identifier=>'L'
,p_column_label=>'Bug'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(255910111802686075.4806)
,p_db_column_name=>'ASSIGNED_TO'
,p_display_order=>61
,p_column_identifier=>'M'
,p_column_label=>unistr('\5206\914D\4EBA\5458')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(255910220773686076.4806)
,p_db_column_name=>'ESTIMATED_FIX_DATE'
,p_display_order=>71
,p_column_identifier=>'N'
,p_column_label=>unistr('\4F30\8BA1\65E5\671F')
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(255910312935686077.4806)
,p_db_column_name=>'PRIORITY'
,p_display_order=>81
,p_column_identifier=>'O'
,p_column_label=>unistr('\4F18\5148\7EA7')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(255910426880686078.4806)
,p_db_column_name=>'TAGS'
,p_display_order=>91
,p_column_identifier=>'P'
,p_column_label=>unistr('\6807\8BB0')
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(255905021055625877.4806)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-Form--labelsAbove:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(699006812014506849.4806)
,p_plug_name=>unistr('\5B9E\7528\7A0B\5E8F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(181214517334339823.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(255906412430625887.4806)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(255905021055625877.4806)
,p_button_name=>'P5_SET'
,p_button_static_id=>'P5_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\8BBE\7F6E')
,p_button_position=>'BODY'
,p_request_source=>'Set'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(255905627467625884.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(255905021055625877.4806)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:RP,5,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(255905425024625884.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(255905021055625877.4806)
,p_button_name=>'APPLYCHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\63A8\8FDF Bug')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(255908904688626115.4806)
,p_branch_action=>'f?p=&APP_ID.:4000:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(255905425024625884.4806)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(255902713888625851.4806)
,p_name=>'P5_PUSH_COUNT'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(255902530693625842.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(255905819762625885.4806)
,p_name=>'P5_MAXIMUM_STATUS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(255905021055625877.4806)
,p_item_default=>'90'
,p_prompt=>unistr('\6700\9AD8\72B6\6001')
,p_source=>'90'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FEATURE STATUS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select status_name ||'' - ''||pct_complete||''%'' d, pct_complete r',
'from wwv_flow_feature_def_st_codes',
'order by pct_complete'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6807\8BC6\5E0C\671B\663E\793A\5728\6B64\62A5\8868\4E2D\7684\6700\9AD8\72B6\6001\3002\6B64\62A5\8868\5C06\4EC5\663E\793A\4E0D\8D85\8FC7\6700\5927\503C\7684\503C\7684\72B6\6001\4EE3\7801\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(255906624976625888.4806)
,p_name=>'P5_PUSH'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(255905021055625877.4806)
,p_item_default=>'7'
,p_prompt=>unistr('\63A8\8FDF\5929\6570')
,p_source=>'7'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>4
,p_cMaxlength=>2000
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5BF9\4E8E\5E0C\671B\5BF9\6B64\529F\80FD\8BBE\7F6E\7684\622A\6B62\65E5\671F, \6807\8BC6\4ECE\4ECA\5929\7B97\8D77\7684\5929\6570\3002')
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(255907200327625889.4806)
,p_name=>'P5_RELEASE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(255905021055625877.4806)
,p_item_default=>'0'
,p_prompt=>unistr('\53D1\884C\7248')
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \5168\90E8 -')
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5C06\62A5\8868\9650\5B9A\4E8E\7ED9\5B9A\7684\53D1\884C\7248, \6216\663E\793A\6240\6709\53D1\884C\7248\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(970055341372740641.4806)
,p_name=>'P5_CHKBX_LABEL'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(255905021055625877.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(255908326970626099.4806)
,p_computation_sequence=>10
,p_computation_item=>'P5_RELEASE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select default_release',
'from wwv_flow_task_defaults',
'where security_group_id = :flow_security_group_id'))
,p_compute_when=>'P5_RELEASE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(970055463572740642.4806)
,p_computation_sequence=>20
,p_computation_item=>'P5_CHKBX_LABEL'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'wwv_flow_lang.system_message(''F4400_CHKBOX_SELECTALL'') || ''/'' || wwv_flow_lang.system_message(''F4400_CHKBOX_DESELECTALL'')'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(255908524105626103.4806)
,p_validation_name=>'P5_PUSH'
,p_validation_sequence=>10
,p_validation=>'P5_PUSH'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('\503C\5FC5\987B\4E3A\6570\5B57')
,p_when_button_pressed=>wwv_flow_api.id(255905425024625884.4806)
,p_associated_item=>wwv_flow_api.id(255906624976625888.4806)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2045581327264367910.4806)
,p_name=>'ADD CHECK ALL CHECKBOX'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(255903131456625855.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2045581436629367911.4806)
,p_event_id=>wwv_flow_api.id(2045581327264367910.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'PLUGIN_COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(255908710570626110.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Push bugs'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  c pls_integer := 0;',
'begin',
'for i in 1..wwv_flow.g_f01.count loop',
'    update wwv_flow_bugs ',
'    set ESTIMATED_FIX_DATE = trunc(sysdate) + :p5_push',
'    where security_group_id = :flow_security_group_id and',
'    bug_status < 100 and',
'    id = to_number(wwv_flow.g_f01(i));',
'    c := c + 1;',
'end loop;',
':p5_push_count := c;',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(255905425024625884.4806)
,p_process_success_message=>unistr('&P5_PUSH_COUNT. \4E2A Bug \5DF2\63A8\8FDF &P5_PUSH. \5929')
);
end;
/
prompt --application/pages/page_00006
begin
wwv_flow_api.create_page(
 p_id=>6.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\6E05\9664\6570\636E')
,p_step_title=>unistr('\6E05\9664\6570\636E')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(389138863817227422.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(12522018023518081)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'td_util.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(498569131152189789.4806)
,p_plug_name=>unistr('\6E05\9664\6570\636E')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--hideHeader'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>20
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(498571725874207151.4806)
,p_plug_name=>unistr('\5173\4E8E')
,p_region_template_options=>'#DEFAULT#:a-Region--padded:u-Height:a-Region--sideRegion:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>\6807\8BC6\8981\6E05\9664\5176\6570\636E\7684\7EC4\4EF6\3002\8FD9\5C06\5220\9664\6240\9009\7C7B\578B\7684\6240\6709\6570\636E\3002</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(498577523805282214.4806)
,p_name=>unistr('\7EC4\4EF6\8BA1\6570')
,p_template=>wwv_flow_api.id(690544675040811341.4806)
,p_display_sequence=>50
,p_region_template_options=>'#DEFAULT#:is-expanded:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--stretch'
,p_region_attributes=>'style="width:100%;"'
,p_new_grid_row=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P6a */',
'  1 ob, ''Features'' l, count(*) cnt',
'  from wwv_flow_features',
' where security_group_id = :FLOW_SECURITY_GROUP_ID',
'union',
'select 2 ob, ''Milestones'' l, count(*) cnt',
'  from wwv_flow_events',
' where security_group_id = :FLOW_SECURITY_GROUP_ID',
'union',
'select 3 ob, ''To Dos'' l, count(*) cnt',
'  from wwv_flow_tasks',
' where security_group_id = :FLOW_SECURITY_GROUP_ID',
'union',
'select 4 ob, ''Bugs'' l, count(*) cnt',
'  from wwv_flow_bugs',
' where security_group_id = :FLOW_SECURITY_GROUP_ID',
'union',
'select 5 ob, ''Feedback'' l, count(*) cnt',
'  from wwv_flow_feedback',
' where security_group_id = :FLOW_SECURITY_GROUP_ID',
'order by ob'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(696866128778092508.4806)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_no_data_found=>unistr('\672A\627E\5230\6570\636E')
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image=>'apex/builder/dup.gif'
,p_query_asc_image_attr=>'width="16" height="16" alt="" '
,p_query_desc_image=>'apex/builder/ddown.gif'
,p_query_desc_image_attr=>'width="16" height="16" alt="" '
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(498581228363387629.4806)
,p_query_column_id=>1
,p_column_alias=>'OB'
,p_column_display_sequence=>1
,p_column_heading=>'Ob'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(498577806103282239.4806)
,p_query_column_id=>2
,p_column_alias=>'L'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\7EC4\4EF6')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(498566904487182047)
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(498577917927282243.4806)
,p_query_column_id=>3
,p_column_alias=>'CNT'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\8BA1\6570')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(699006302714477084.4806)
,p_plug_name=>unistr('\5B9E\7528\7A0B\5E8F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>60
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(181214517334339823.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(886496061201981536.4806)
,p_plug_name=>unistr('\6E05\9664\6570\636E')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder:a-ButtonRegion--showTitle'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(498570617379200995.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(886496061201981536.4806)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\6E05\9664')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:confirmDelete(''&DELETE_MSG.'',''DELETE'');'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(498574427652236026.4806)
,p_branch_action=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(498569618470195536.4806)
,p_name=>'P6_TEAMDEV_COMPONENTS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(498569131152189789.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5220\9664\6240\9009\7EC4\4EF6\7684\6240\6709\6761\76EE:')
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'TEAMDEV_COMPONENTS'
,p_lov=>'.'||wwv_flow_api.id(498566904487182047.4806)||'.'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6807\8BC6\8981\6E05\9664\5176\6570\636E\7684\7EC4\4EF6\3002\8FD9\5C06\5220\9664\6240\9009\7C7B\578B\7684\6240\6709\6570\636E\3002')
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(498573018171223885.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'DELETE'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if instr(:P6_TEAMDEV_COMPONENTS,''Bugs'') > 0 then',
'   delete from wwv_flow_bugs where security_group_id = :flow_security_group_id;',
'end if;',
'if instr(:P6_TEAMDEV_COMPONENTS,''Feedback'') > 0 then',
'   delete from wwv_flow_feedback where security_group_id = :flow_security_group_id;',
'end if;',
'if instr(:P6_TEAMDEV_COMPONENTS,''To Dos'') > 0 then',
'   delete from wwv_flow_tasks where security_group_id = :flow_security_group_id;',
'end if;',
'if instr(:P6_TEAMDEV_COMPONENTS,''Milestones'') > 0 then',
'   delete from wwv_flow_events where security_group_id = :flow_security_group_id;',
'end if;',
'if instr(:P6_TEAMDEV_COMPONENTS,''Features'') > 0 then',
'   delete from wwv_flow_features where security_group_id = :flow_security_group_id;',
'end if;'))
,p_process_when_button_id=>wwv_flow_api.id(498570617379200995.4806)
,p_process_success_message=>unistr('\6240\9009\7EC4\4EF6\5DF2\6E05\9664')
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\91CC\7A0B\7891')
,p_step_title=>unistr('\91CC\7A0B\7891')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(694251408051447516.4806)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1492716628604730875.4806)
,p_plug_name=>'Hidden Items'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1492719089108804167.4806)
,p_name=>unistr('\5173\8054\7684\5F85\529E\4E8B\9879')
,p_template=>wwv_flow_api.id(388361325811341773.4806)
,p_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--stretch'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select TASK_NAME, ASSIGNED_TO, task_status status, task_status percent_complete,',
'       ID',
'from wwv_flow_tasks',
'where event_id = :P7_ID and security_group_id = :flow_security_group_id'))
,p_display_when_condition=>'P7_ID'
,p_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(696866128778092508.4806)
,p_query_num_rows=>1500
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\62A5\8868\4E2D\4E0D\5305\542B\6570\636E')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>5000
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492719221592804172.4806)
,p_query_column_id=>1
,p_column_alias=>'TASK_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\5F85\529E\4E8B\9879')
,p_column_link=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:3010:P3010_ID:#ID#'
,p_column_linktext=>'#TASK_NAME#'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492719371844804174.4806)
,p_query_column_id=>2
,p_column_alias=>'ASSIGNED_TO'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\5206\914D\7ED9')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492809534796548171.4806)
,p_query_column_id=>3
,p_column_alias=>'STATUS'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\72B6\6001')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492719406243804174.4806)
,p_query_column_id=>4
,p_column_alias=>'PERCENT_COMPLETE'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\5B8C\6210\767E\5206\6BD4')
,p_use_as_row_header=>'N'
,p_column_format=>'PCT_GRAPH'
,p_heading_alignment=>'LEFT'
,p_default_sort_column_sequence=>1
,p_default_sort_dir=>'desc'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492719514559804174.4806)
,p_query_column_id=>5
,p_column_alias=>'ID'
,p_column_display_sequence=>2
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1492719656589805583.4806)
,p_name=>unistr('\5173\8054\7684\529F\80FD')
,p_template=>wwv_flow_api.id(388361325811341773.4806)
,p_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--stretch'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select feature_name, ',
'       FEATURE_OWNER, ',
'       feature_status status,',
'       feature_status,',
'       ID,',
'      (select count(*)',
'       from   wwv_flow_tasks',
'       where  security_group_id = :flow_security_group_id and',
'              feature_id = f.id) feature_to_dos,',
'(select count(*)',
'   from WWV_FLOW_FEATURE_PROGRESS p',
'  where security_group_id = :flow_security_group_id and',
'        p.feature_id = f.id) progress_entries',
'from wwv_flow_features f',
'where event_id = :P7_ID'))
,p_display_when_condition=>'P7_ID'
,p_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(696866128778092508.4806)
,p_query_num_rows=>1500
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\62A5\8868\4E2D\4E0D\5305\542B\6570\636E')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>1500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492719832747805584.4806)
,p_query_column_id=>1
,p_column_alias=>'FEATURE_NAME'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\529F\80FD')
,p_column_link=>'f?p=&APP_ID.:9001:&SESSION.::&DEBUG.:9001:P9001_ID:#ID#'
,p_column_linktext=>'#FEATURE_NAME#'
,p_default_sort_column_sequence=>3
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492719981734805584.4806)
,p_query_column_id=>2
,p_column_alias=>'FEATURE_OWNER'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\6240\6709\8005')
,p_use_as_row_header=>'N'
,p_default_sort_column_sequence=>1
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492732534893914173.4806)
,p_query_column_id=>3
,p_column_alias=>'STATUS'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\72B6\6001')
,p_column_alignment=>'CENTER'
,p_disable_sort_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492720052761805584.4806)
,p_query_column_id=>4
,p_column_alias=>'FEATURE_STATUS'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\5B8C\6210\767E\5206\6BD4')
,p_use_as_row_header=>'N'
,p_column_format=>'PCT_GRAPH'
,p_default_sort_column_sequence=>2
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492720166207805584.4806)
,p_query_column_id=>5
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492792052374139582.4806)
,p_query_column_id=>6
,p_column_alias=>'FEATURE_TO_DOS'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\529F\80FD\5F85\529E\4E8B\9879')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492808083528511097.4806)
,p_query_column_id=>7
,p_column_alias=>'PROGRESS_ENTRIES'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\8FDB\5EA6\6761\76EE')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1492720294699807434.4806)
,p_name=>unistr('\6309\5F00\53D1\8005\7EDF\8BA1\7684\529F\80FD')
,p_template=>wwv_flow_api.id(388361325811341773.4806)
,p_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--stretch'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEATURE_OWNER, ',
'       count(*) features, ',
'       sum(decode(feature_status,0,1,0)) not_started,',
'       sum(decode(feature_status,100,0,80,0,85,0,90,0,95,0,1)) open,',
'       sum(decode(feature_status,100,1,80,1,85,1,90,1,95,1,0)) completed,',
'       sum(decode(feature_status,100,1,0)) fully_completed,',
'       sum(feature_status)/(count(*)) pct_complete',
'from wwv_flow_features',
'where event_id = :P7_ID',
'group by feature_owner'))
,p_display_when_condition=>'P7_ID'
,p_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(696866128778092508.4806)
,p_query_num_rows=>1500
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\62A5\8868\4E2D\4E0D\5305\542B\6570\636E')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>1500
,p_report_total_text_format=>'&nbsp;'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_prn_format=>'PDF'
,p_prn_output_show_link=>'Y'
,p_prn_output_link_text=>unistr('\8F93\51FA')
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width_units=>'PERCENTAGE'
,p_prn_width=>11
,p_prn_height=>8.5
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#ffffff'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492720611323807436.4806)
,p_query_column_id=>1
,p_column_alias=>'FEATURE_OWNER'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\6240\6709\8005')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
,p_print_col_width=>'14'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492720962772807436.4806)
,p_query_column_id=>2
,p_column_alias=>'FEATURES'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\76EE\6807\529F\80FD')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
,p_print_col_width=>'14'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492720742389807436.4806)
,p_query_column_id=>3
,p_column_alias=>'NOT_STARTED'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\672A\5F00\59CB')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
,p_print_col_width=>'14'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492720838541807436.4806)
,p_query_column_id=>4
,p_column_alias=>'OPEN'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\672A\5B8C\6210')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
,p_print_col_width=>'14'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492720539623807436.4806)
,p_query_column_id=>5
,p_column_alias=>'COMPLETED'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\5DF2\5B8C\6210')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
,p_print_col_width=>'14'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492720422835807436.4806)
,p_query_column_id=>6
,p_column_alias=>'FULLY_COMPLETED'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\5168\90E8\5B8C\6210')
,p_use_as_row_header=>'N'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
,p_print_col_width=>'14'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492721063766807436.4806)
,p_query_column_id=>7
,p_column_alias=>'PCT_COMPLETE'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\5B8C\6210\767E\5206\6BD4')
,p_column_format=>'PCT_GRAPH:::'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_print_col_width=>'14'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1492722569355825895.4806)
,p_name=>'Milestone'
,p_display_sequence=>30
,p_region_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4800P6000aP7 */',
'    EVENT_NAME,',
'    EVENT_DATE,',
'    EVENT_TYPE,',
'    RELEASE,',
'    EVENT_DESC,',
'    TAGS,',
'    lower(created_by)|| '' - ''||apex_util.get_since(e.created_on) CREATED_BY,',
'    lower(updated_by)|| '' - ''||apex_util.get_since(e.updated_on) UPDATED_BY,',
'    EVENT_OWNER',
'from WWV_FLOW_EVENTS e,',
'   (select wwv_flow_lang.system_message(''YES'') m_yes,',
'           wwv_flow_lang.system_message(''NO'') m_no',
'    from dual) m',
'where security_group_id = :flow_security_group_id and ',
'      id = :P7_ID'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(180321418532362007.4806)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\672A\627E\5230\6570\636E')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492723025173825911.4806)
,p_query_column_id=>1
,p_column_alias=>'EVENT_NAME'
,p_column_display_sequence=>2
,p_column_heading=>'Milestone'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492723100797825911.4806)
,p_query_column_id=>2
,p_column_alias=>'EVENT_DATE'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\65E5\671F')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492723229723825911.4806)
,p_query_column_id=>3
,p_column_alias=>'EVENT_TYPE'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\7C7B\578B')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492723390492825911.4806)
,p_query_column_id=>4
,p_column_alias=>'RELEASE'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\53D1\884C\7248')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492723427276825911.4806)
,p_query_column_id=>5
,p_column_alias=>'EVENT_DESC'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\8BF4\660E')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492723501260825911.4806)
,p_query_column_id=>6
,p_column_alias=>'TAGS'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\6807\8BB0')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492723681680825911.4806)
,p_query_column_id=>7
,p_column_alias=>'CREATED_BY'
,p_column_display_sequence=>8
,p_column_heading=>unistr('\521B\5EFA\8005')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492723813053825912.4806)
,p_query_column_id=>8
,p_column_alias=>'UPDATED_BY'
,p_column_display_sequence=>9
,p_column_heading=>unistr('\66F4\65B0\8005')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492724095504825912.4806)
,p_query_column_id=>9
,p_column_alias=>'EVENT_OWNER'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\6240\6709\8005')
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1492725824392858392.4806)
,p_name=>'Metrics'
,p_display_sequence=>10
,p_region_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4800P6000aP7m */',
'    trunc(event_date) - trunc(sysdate) days_out,',
'    (select count(*) from WWV_FLOW_FEATURES',
'     where security_group_id = :flow_security_group_id and',
'     event_id = e.id) associated_features,',
'    (select count(*) from WWV_FLOW_FEATURES f',
'     where security_group_id = :flow_security_group_id and',
'     event_id = e.id and NVL(f.feature_status,0) >= 80) associated_features_80,',
'    (select count(*) from WWV_FLOW_FEATURES f',
'     where security_group_id = :flow_security_group_id and',
'     event_id = e.id and NVL(f.feature_status,0) = 100) associated_features_100,',
'    (select count(*) from WWV_FLOW_TASKS',
'     where security_group_id = :flow_security_group_id and',
'     event_id = e.id) associated_todos,',
'    (select count(*) from wwv_flow_bugs',
'     where security_group_id = :flow_security_group_id and',
'     TARGET_MILESTONE_ID = e.id) associated_bugs',
'from WWV_FLOW_EVENTS e,',
'   (select wwv_flow_lang.system_message(''YES'') m_yes,',
'           wwv_flow_lang.system_message(''NO'') m_no',
'    from dual) m',
'where security_group_id = :flow_security_group_id and ',
'      id = :P7_ID'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(389146768272330380.4806)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\672A\627E\5230\6570\636E')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492727013311858392.4806)
,p_query_column_id=>1
,p_column_alias=>'DAYS_OUT'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\5269\4F59\5929\6570')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492727181048858395.4806)
,p_query_column_id=>2
,p_column_alias=>'ASSOCIATED_FEATURES'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\5173\8054\7684\529F\80FD')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492800607981278989.4806)
,p_query_column_id=>3
,p_column_alias=>'ASSOCIATED_FEATURES_80'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\529F\80FD\5B8C\6210 80%')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492800958458284580.4806)
,p_query_column_id=>4
,p_column_alias=>'ASSOCIATED_FEATURES_100'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\529F\80FD\5B8C\6210 100%')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492727245036858395.4806)
,p_query_column_id=>5
,p_column_alias=>'ASSOCIATED_TODOS'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\5173\8054\7684\5F85\529E\4E8B\9879')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1492727326882858395.4806)
,p_query_column_id=>6
,p_column_alias=>'ASSOCIATED_BUGS'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\5173\8054\7684 Bug')
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1492796003554216141.4806)
,p_plug_name=>'&P7_MILESTONE_NAME.'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--wizard:a-Form--leftLabels:a-ButtonRegion--showTitle'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_04'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1492809818210569462.4806)
,p_plug_name=>'Region Display Selector'
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_translate_title=>'N'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1492798199124226034.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1492796003554216141.4806)
,p_button_name=>'EDIT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\7F16\8F91\91CC\7A0B\7891')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:6001:&SESSION.::&DEBUG.:6001:P6001_ID:&P7_ID.'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1492861963079934282.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1492796003554216141.4806)
,p_button_name=>'PREVIOUS_MILESTONE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--pillStart'
,p_button_template_id=>wwv_flow_api.id(388504981151147634.4806)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_css_classes=>'apex_disabled'
,p_icon_css_classes=>'icon-left-chevron'
,p_button_cattributes=>'disabled=""'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1492810757818621513.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1492796003554216141.4806)
,p_button_name=>'NEXT_MILESTONE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--pillEnd'
,p_button_template_id=>wwv_flow_api.id(388504981151147634.4806)
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_css_classes=>'apex_disabled'
,p_icon_css_classes=>'icon-right-chevron'
,p_button_cattributes=>'disabled=""'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2378260759322597022.4806)
,p_branch_action=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.::P7_ID:&P7_NEXT_MILESTONE_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(1492810757818621513.4806)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2378261110701601314.4806)
,p_branch_action=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.::P7_ID:&P7_PREVIOUS_MILESTONE_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(1492861963079934282.4806)
,p_branch_sequence=>20
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1492718980514801602.4806)
,p_name=>'P7_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1492716628604730875.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1492810283698576281.4806)
,p_name=>'P7_NEXT_MILESTONE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1492716628604730875.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when=>'P7_NEXT_MILESTONE_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1492810414016577737.4806)
,p_name=>'P7_PREVIOUS_MILESTONE_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1492716628604730875.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when=>'P7_PREVIOUS_MILESTONE_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1492863654107956075.4806)
,p_name=>'P7_MILESTONE_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(1492716628604730875.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1492801347634294806.4806)
,p_computation_sequence=>10
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'&APP_PAGE_ID.'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2378206887285412620.4806)
,p_name=>'ENABLE PREVIOUS'
,p_event_sequence=>10
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_display_when_cond=>'P7_PREVIOUS_MILESTONE_ID'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2378207234773412626.4806)
,p_event_id=>wwv_flow_api.id(2378206887285412620.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_api.id(1492861963079934282.4806)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2378207802208423907.4806)
,p_name=>'ENABLE NEXT'
,p_event_sequence=>20
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_display_when_cond=>'P7_NEXT_MILESTONE_ID'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2378208277497423907.4806)
,p_event_id=>wwv_flow_api.id(2378207802208423907.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_api.id(1492810757818621513.4806)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1492810534558605320.4806)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'compute next and previous milestone IDs'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P7_NEXT_MILESTONE_ID     := null;',
':P7_PREVIOUS_MILESTONE_ID := null;',
'',
'for c1 in ( select event_name',
'              from wwv_flow_events ',
'             where id = :P7_ID',
'               and security_group_id = :flow_security_group_id) loop',
'    :P7_MILESTONE_NAME := c1.event_name;',
'    exit;',
'end loop;',
'',
'for c1 in ( select id , event_id',
'              from wwv_flow_events ',
'             where EVENT_ID > (select event_id ',
'                                 from wwv_flow_events ',
'                                where id = :P7_ID',
'                                  and security_group_id = :flow_security_group_id) ',
'               and security_group_id = :flow_security_group_id',
'             order by event_date ) loop',
'    :P7_NEXT_MILESTONE_ID := c1.id;',
'    exit;',
'end loop;',
'',
'for c1 in ( select id , event_id',
'              from wwv_flow_events ',
'             where EVENT_ID < (select event_id ',
'                                 from wwv_flow_events ',
'                                where id = :P7_ID',
'                                  and security_group_id = :flow_security_group_id)',
'               and security_group_id = :flow_security_group_id',
'             order by event_date desc) loop',
'    :P7_PREVIOUS_MILESTONE_ID := c1.id;',
'    exit;',
'end loop;'))
);
end;
/
prompt --application/pages/page_00008
begin
wwv_flow_api.create_page(
 p_id=>8.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\529F\80FD\6811')
,p_step_title=>unistr('\529F\80FD\6811')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$(''div.tree >ul>li ,div.tree >ul>li'').addClass(''open'').removeClass(''closed'');',
''))
,p_step_template=>wwv_flow_api.id(637441482420448238.4806)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'td_feature_rpts.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(79455909175900826.4806)
,p_plug_name=>'Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(181255317679390139.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(182442550749490978.4806)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(79474711945901688.4806)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-Form--labelsAbove:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(83713209071785831.4806)
,p_plug_name=>unistr('\529F\80FD\5C42\6B21')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT CASE WHEN connect_by_isleaf = 1 THEN 0',
'            WHEN level = 1             THEN 1',
'            ELSE                           -1',
'       END as status ',
',      level ',
',      name as title',
',      null as icon ',
',      id as value ',
',      tip as tooltip',
',      url as link',
'--,      seq as display       ',
'FROM (',
'select unique release as name, ',
'       null as icon, ',
'       release as id, ',
'       null as parent,',
'       null as tip, ',
'       ''#'' as url,',
'       release as seq ',
'from WWV_FLOW_FEATURES f',
'where security_group_id = :flow_security_group_id',
'and   ( nvl(:P8_RELEASE,''all'') = ''all''',
'       or release = :P8_RELEASE )',
'and   release is not null',
'UNION ALL',
'select FEATURE_NAME||'' (''||feature_id||'')''|| decode(:P8_INCLUDE_PERCENT_COMP, ''Y'', '' - ''||NVL(f.feature_status, 0)|| ''%'', NULL) as name, ',
'       null as icon, ',
'       release||to_char(ID) as id, ',
'       release||to_char(parent_feature_id) as parent,',
'       :EDIT as tip, ',
'       ''f?p=''||:APP_ID||'':9001:''||:app_session||'':::9001:P9001_ID,P8_SELECTED_NODE,F4800_LAST_VIEW:''||id||'',''||id||'',8'' as url,',
'       feature_name as seq ',
'from WWV_FLOW_FEATURES f,',
'     (select wwv_flow_lang.system_message(''PERCENT_COMPLETE'') pc from dual) m',
'where security_group_id = :flow_security_group_id',
'and (nvl(:P8_RELEASE,''all'') = ''all'' or release = :P8_RELEASE )',
') start with parent is null',
'connect by prior id = parent',
'--order siblings by display',
''))
,p_plug_source_type=>'NATIVE_JSTREE'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_02=>'S'
,p_attribute_03=>'P8_SELECTED_NODE'
,p_attribute_04=>'DB'
,p_attribute_06=>'tree83713126554785831'
,p_attribute_07=>'APEX_TREE'
,p_attribute_10=>'"3"'
,p_attribute_11=>'"2"'
,p_attribute_12=>'"4"'
,p_attribute_15=>'"1"'
,p_attribute_20=>'"5"'
,p_attribute_22=>'"6"'
,p_attribute_23=>'LEVEL'
,p_attribute_24=>'"7"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(171406814563354222.4806)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(79474711945901688.4806)
,p_button_name=>'P8_SET'
,p_button_static_id=>'P8_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\8BBE\7F6E')
,p_button_position=>'BODY'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(86993427180006682.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(79474711945901688.4806)
,p_button_name=>'RESET_REPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:8::'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(83713522239785837.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(79474711945901688.4806)
,p_button_name=>'CONTRACT_ALL'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\5168\90E8\6298\53E0')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.widget.tree.collapse_all(''tree83713126554785831'');'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(83713718824785837.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(79474711945901688.4806)
,p_button_name=>'EXPAND_ALL'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\5168\90E8\5C55\5F00')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.widget.tree.expand_all(''tree83713126554785831'');'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(171150619710327245.4806)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(79474711945901688.4806)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404891952915809007.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\521B\5EFA\529F\80FD')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:9001:&SESSION.::&DEBUG.:9001::'
,p_icon_css_classes=>'icon-right-chevron'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(84653211925150641.4806)
,p_name=>'P8_RELEASE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(79474711945901688.4806)
,p_prompt=>unistr('\53D1\884C\7248')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id ',
'and release is not null ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('\6240\6709\53D1\884C\7248')
,p_lov_null_value=>'all'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6309\7ED9\5B9A\7684\53D1\884C\7248\663E\793A\529F\80FD\65F6, \5C06\4E0D\4F1A\663E\793A\5728\5176\4ED6\53D1\884C\7248\4E2D\5177\6709\7236\529F\80FD\6216\5B50\529F\80FD\7684\529F\80FD\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(88674810659484446.4806)
,p_name=>'P8_SELECTED_NODE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(83713209071785831.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(170415504090019998.4806)
,p_name=>'P8_INCLUDE_PERCENT_COMP'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(79474711945901688.4806)
,p_item_default=>'Y'
,p_prompt=>unistr('\662F\5426\5305\62EC\5B8C\6210\767E\5206\6BD4?')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES NO RETURNING Y N'
,p_lov=>'.'||wwv_flow_api.id(167678533936302622.4806)||'.'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6307\793A\662F\5426\5728\6811\4E2D\663E\793A\6BCF\4E2A\529F\80FD\7684\5B8C\6210\767E\5206\6BD4\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(86892502592999565.4806)
,p_computation_sequence=>10
,p_computation_item=>'P8_RELEASE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select default_release',
'from wwv_flow_task_defaults',
'where security_group_id = :flow_security_group_id'))
,p_compute_when=>'P8_RELEASE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(970054410693740632.4806)
,p_computation_sequence=>20
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'&APP_PAGE_ID.'
);
end;
/
prompt --application/pages/page_00009
begin
wwv_flow_api.create_page(
 p_id=>9.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\5C0F\7EC4\5F00\53D1\6587\4EF6')
,p_step_title=>unistr('\5C0F\7EC4\5F00\53D1\6587\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(389138863817227422.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(320411217759847832.4806)
,p_plug_name=>unistr('\5C0F\7EC4\5F00\53D1\6587\4EF6')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(678363858364331062.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'n001 id,',
'n002 component_id,',
'c001 component_type,',
'''<a class="attachment_link" href="''||wwv_flow_team_file.get_file_src(n001)||''" title="''||wwv_flow_escape.html(c005)||''">''||wwv_flow_escape.html(c002)||''</a>'' file_name,',
'substr(c005,1,50)||decode(greatest(length(c005),50),50,'''',''...'') file_comments,',
'--c009 tags,',
'to_number(nvl(c008,''0'')) file_size,',
'c003 mimetype,',
'd001 date_added, lower(c006) added_by,',
'd002 updated, lower(c007) updated_by',
'from wwv_flow_collections'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(320411327296847832.4806)
,p_name=>'Team Development Files'
,p_max_row_count=>'100000'
,p_max_row_count_message=>unistr('\6B64\67E5\8BE2\8FD4\56DE\7684\884C\6570\8D85\8FC7\4E86 #MAX_ROW_COUNT#, \8BF7\8FC7\6EE4\6570\636E\4EE5\786E\4FDD\83B7\5F97\5B8C\6574\7ED3\679C\3002')
,p_no_data_found_message=>unistr('\672A\627E\5230\6570\636E\3002')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'CBCHO'
,p_internal_uid=>320411327296847832
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320411514256847833.4806)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320411602538847834.4806)
,p_db_column_name=>'COMPONENT_ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\7EC4\4EF6 ID')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320411717278847834.4806)
,p_db_column_name=>'COMPONENT_TYPE'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\7C7B\578B')
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(320401714586742779)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320411802027847834.4806)
,p_db_column_name=>'FILE_NAME'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\540D\79F0')
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320411902552847834.4806)
,p_db_column_name=>'FILE_COMMENTS'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\6CE8\91CA')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320412111213847834.4806)
,p_db_column_name=>'FILE_SIZE'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\5927\5C0F')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320412205441847834.4806)
,p_db_column_name=>'MIMETYPE'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('Mime \7C7B\578B')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320412332329847834.4806)
,p_db_column_name=>'DATE_ADDED'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('\6DFB\52A0\65E5\671F')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320412424010847835.4806)
,p_db_column_name=>'ADDED_BY'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('\6DFB\52A0\8005')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320412512635847835.4806)
,p_db_column_name=>'UPDATED'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>unistr('\66F4\65B0')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320412613974847835.4806)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>unistr('\66F4\65B0\8005')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(699006075921472170.4806)
,p_plug_name=>unistr('\5B9E\7528\7A0B\5E8F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(181214517334339823.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1042124546059629967.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(320411217759847832.4806)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:&APP_PAGE_ID.:&SESSION.::&DEBUG.:&APP_PAGE_ID.,RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(320412929187851120.4806)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create file collection'
,p_process_sql_clob=>'wwv_flow_team_file.create_file_collection;'
,p_process_error_message=>unistr('\65E0\6CD5\521B\5EFA\6587\4EF6\96C6\5408\3002')
);
end;
/
prompt --application/pages/page_00010
begin
wwv_flow_api.create_page(
 p_id=>10.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\5F85\529E\4E8B\9879\6587\4EF6')
,p_step_title=>unistr('\5F85\529E\4E8B\9879\6587\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(637441482420448238.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(320390930020586382.4806)
,p_plug_name=>unistr('\6587\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(678363858364331062.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'n001 id,',
'n002 component_id,',
'''<a class="attachment_link" href="''||wwv_flow_team_file.get_file_src(n001)||''" title="''||wwv_flow_escape.html(c005)||''">''||wwv_flow_escape.html(c002)||''</a>'' file_name,',
'substr(c005,1,50)||decode(greatest(length(c005),50),50,'''',''...'') description,',
'--c009 tags,',
'to_number(nvl(c008,''0'')) file_size,',
'c003 mimetype,',
'd001 date_added, lower(c006) added_by,',
'd002 updated, lower(c007) updated_by,',
'''#'' delete_file,',
'wwv_flow_lang.system_message(''EDIT_LINK_TEXT'', wwv_flow_escape.html(c002)) link_text,',
'wwv_flow_lang.system_message(''DELETE_LINK_TEXT'', wwv_flow_escape.html(c002)) delete_text',
'from wwv_flow_collections',
'where c001 = ''TODO''',
'and n002 = :P10_COMPONENT_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(320391001208586382.4806)
,p_name=>'Files'
,p_max_row_count=>'100000'
,p_max_row_count_message=>unistr('\6B64\67E5\8BE2\8FD4\56DE\7684\884C\6570\8D85\8FC7\4E86 #MAX_ROW_COUNT#, \8BF7\8FC7\6EE4\6570\636E\4EE5\786E\4FDD\83B7\5F97\5B8C\6574\7ED3\679C\3002')
,p_no_data_found_message=>unistr('\672A\627E\5230\6587\4EF6\3002')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'C'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_detail_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:11:P11_ID:#ID#'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil2_16x16.gif" alt="#LINK_TEXT#">'
,p_owner=>'CBCHO'
,p_internal_uid=>320391001208586382
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320391217357586384.4806)
,p_db_column_name=>'FILE_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\540D\79F0')
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320391506747586385.4806)
,p_db_column_name=>'FILE_SIZE'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\5927\5C0F')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320393205699629943.4806)
,p_db_column_name=>'ID'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320393314243629944.4806)
,p_db_column_name=>'COMPONENT_ID'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('\7EC4\4EF6 ID')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320393611928629944.4806)
,p_db_column_name=>'MIMETYPE'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>unistr('Mime \7C7B\578B')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320393914832629944.4806)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>unistr('\66F4\65B0\8005')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320394018084629944.4806)
,p_db_column_name=>'DELETE_FILE'
,p_display_order=>15
,p_column_identifier=>'O'
,p_column_label=>'&nbsp;'
,p_column_link=>'f?p=&APP_ID.:10:&SESSION.:DELETE_FILE:&DEBUG.::P10_DELETE_FILE_ID:#ID#'
,p_column_linktext=>'<img src="#IMAGE_PREFIX#red_x_16.png" alt="#DELETE_TEXT#">'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320394417117639788.4806)
,p_db_column_name=>'DATE_ADDED'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>unistr('\6DFB\52A0\65E5\671F')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320394507234639788.4806)
,p_db_column_name=>'ADDED_BY'
,p_display_order=>17
,p_column_identifier=>'Q'
,p_column_label=>unistr('\6DFB\52A0\8005')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(320394610807639789.4806)
,p_db_column_name=>'UPDATED'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>unistr('\66F4\65B0')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(322790004623812411.4806)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>unistr('\8BF4\660E')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(247043972803377604.4806)
,p_db_column_name=>'LINK_TEXT'
,p_display_order=>29
,p_column_identifier=>'T'
,p_column_label=>unistr('\94FE\63A5\6587\672C')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(247044985742377614.4806)
,p_db_column_name=>'DELETE_TEXT'
,p_display_order=>39
,p_column_identifier=>'U'
,p_column_label=>unistr('\5220\9664\6587\672C')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(322354608612578348.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(320390930020586382.4806)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(322354931814584980.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(320390930020586382.4806)
,p_button_name=>'ADD_FILE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(404891952915809007.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\6DFB\52A0\6587\4EF6')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:4:P4_COMPONENT_ID,P4_GO_TO_PAGE:&P10_COMPONENT_ID.,10'
,p_icon_css_classes=>'fa-chevron-right icon-right-chevron'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320390328634528157.4806)
,p_name=>'P10_COMPONENT_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(320390930020586382.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320398101996677183.4806)
,p_name=>'P10_DELETE_FILE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(320390930020586382.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(322337405924538276.4806)
,p_computation_sequence=>10
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'10'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(694445507335427528.4806)
,p_name=>'Handle Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(320390930020586382.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694445669334427529.4806)
,p_event_id=>wwv_flow_api.id(694445507335427528.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(320390930020586382.4806)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(829748911544470316.4806)
,p_name=>'Submit Page on Create Dialog Close'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(325302109627822813.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(829749290646470318.4806)
,p_event_id=>wwv_flow_api.id(829748911544470316.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(829749383407472495.4806)
,p_name=>'Submit Page on Edit/Delete Dialog Close'
,p_event_sequence=>30
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(320390930020586382.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(829749692745472495.4806)
,p_event_id=>wwv_flow_api.id(829749383407472495.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(320399001164720058.4806)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete file'
,p_process_sql_clob=>'wwv_flow_team_file.delete_file(p_file_id => :P10_DELETE_FILE_ID);'
,p_process_error_message=>unistr('\65E0\6CD5\5220\9664\6587\4EF6\3002')
,p_process_when=>'DELETE_FILE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
,p_process_success_message=>unistr('\6587\4EF6\5DF2\5220\9664\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(320390014689525205.4806)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create file collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.create_file_collection (',
'    p_component_id    => :P10_COMPONENT_ID',
'    );'))
,p_process_error_message=>unistr('\65E0\6CD5\521B\5EFA\6587\4EF6\96C6\5408\3002')
,p_process_when=>'P10_COMPONENT_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_api.create_page(
 p_id=>11.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\6587\4EF6')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\6587\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(694252054065447551.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_dialog_height=>'450'
,p_dialog_width=>'650'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(320711230889098428.4806)
,p_plug_name=>unistr('\6587\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(320943518815699744.4806)
,p_plug_name=>'button'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(320711601538098429.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(320943518815699744.4806)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\5220\9664')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P11_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(320711512570098429.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(320943518815699744.4806)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5E94\7528\66F4\6539')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P11_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(320712431663098430.4806)
,p_branch_action=>'f?p=&APP_ID.:&F4800_LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320712817389098460.4806)
,p_name=>'P11_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(320711230889098428.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320713019430098460.4806)
,p_name=>'P11_COMPONENT_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(320711230889098428.4806)
,p_prompt=>unistr('\5F85\529E\4E8B\9879')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'TODOS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select task_name d, id r',
'from wwv_flow_tasks',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320713230894098460.4806)
,p_name=>'P11_COMPONENT_TYPE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(320711230889098428.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320713421540098460.4806)
,p_name=>'P11_FILENAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(320711230889098428.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\540D\79F0')
,p_source=>'''<a href="''||wwv_flow_team_file.get_file_src(to_number(:P11_ID))||''">''||wwv_flow_escape.html(:P11_FILENAME)||''</a>'''
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320713608079098460.4806)
,p_name=>'P11_FILE_MIMETYPE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(320711230889098428.4806)
,p_prompt=>unistr('Mime \7C7B\578B')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320714207648098461.4806)
,p_name=>'P11_FILE_COMMENTS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(320711230889098428.4806)
,p_prompt=>unistr('\8BF4\660E')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('\8F93\5165\6587\4EF6\8BF4\660E\3002')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320714604848098462.4806)
,p_name=>'P11_UPDATED'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(320711230889098428.4806)
,p_prompt=>unistr('\66F4\65B0')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT-CENTER'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320715003827098463.4806)
,p_name=>'P11_UPDATED_BY'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(320711230889098428.4806)
,p_prompt=>unistr('\66F4\65B0\8005')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_new_grid=>true
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(320990506030923074.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.delete_file (',
'    p_file_id   => :P11_ID);'))
,p_process_error_message=>unistr('\65E0\6CD5\5220\9664\6587\4EF6\3002')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(320711601538098429.4806)
,p_process_success_message=>unistr('\6587\4EF6\5DF2\5220\9664\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(322337021116534634.4806)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save file comment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.save_file_comment (',
'    p_file_id          => :P11_ID,',
'    p_file_comments    => :P11_FILE_COMMENTS);'))
,p_process_error_message=>unistr('\65E0\6CD5\4FDD\5B58\6CE8\91CA\3002')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(320711512570098429.4806)
,p_process_success_message=>unistr('\5DF2\4FDD\5B58\6587\4EF6\6CE8\91CA\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(320716529598098464.4806)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'11'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(320711601538098429.4806)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(694445772252427530.4806)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(320721029177125506.4806)
,p_process_sequence=>40
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.fetch_file (',
'    p_file_id          => :P11_ID,',
'    p_component_id     => :P11_COMPONENT_ID,',
'    p_component_type   => :P11_COMPONENT_TYPE,',
'    p_filename         => :P11_FILENAME,',
'    p_file_mimetype    => :P11_FILE_MIMETYPE,',
'    p_file_comments    => :P11_FILE_COMMENTS,',
'    p_updated_on       => :P11_UPDATED,',
'    p_updated_by       => :P11_UPDATED_BY',
'    );'))
,p_process_error_message=>unistr('\65E0\6CD5\63D0\53D6\6587\4EF6\4FE1\606F\3002')
);
end;
/
prompt --application/pages/page_00012
begin
wwv_flow_api.create_page(
 p_id=>12.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\6DFB\52A0\529F\80FD\76F8\5173\6027 ')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\6DFB\52A0\529F\80FD\76F8\5173\6027 ')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(670195776876712847.4806)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'400'
,p_dialog_width=>'600'
,p_protection_level=>'C'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(87630327387115742.4806)
,p_plug_name=>unistr('\529F\80FD')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>21
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select feature_id ||'' - '' || feature_name d, id r',
'from wwv_flow_features f',
'where security_group_id = :flow_security_group_id',
'and release = :P12_RELEASE',
''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(87645062427218815.4806)
,p_max_row_count=>'1000000'
,p_show_nulls_as=>'-'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_actions_menu=>'N'
,p_report_list_mode=>'NONE'
,p_show_detail_link=>'N'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="" />'
,p_icon_view_columns_per_row=>1
,p_owner=>'MARC'
,p_internal_uid=>87645062427218815
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(87645126798218816.4806)
,p_db_column_name=>'D'
,p_display_order=>10
,p_column_identifier=>'A'
,p_column_label=>unistr('\529F\80FD\540D\79F0')
,p_column_link=>'javascript:apex.item(''P12_DEPENDENT_ON_FEATURE_ID'').setValue(''#R#'');apex.submit(''CREATE'');'
,p_column_linktext=>'#D#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(87645233678218817.4806)
,p_db_column_name=>'R'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>unistr('\529F\80FD ID')
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(87633027338115753.4806)
,p_name=>'P12_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(87630327387115742.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'S'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(87633439392115780.4806)
,p_name=>'P12_FEATURE_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(87630327387115742.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'FEATURE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(87633860592115782.4806)
,p_name=>'P12_DEPENDENT_ON_FEATURE_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(87630327387115742.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'DEPENDENT_ON_FEATURE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('\5F53\524D\529F\80FD\53D6\51B3\4E8E\6240\9009\529F\80FD\662F\5426\5B8C\6210\3002')
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(87644112616218806.4806)
,p_name=>'P12_RELEASE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(87630327387115742.4806)
,p_use_cache_before_default=>'NO'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(87634638382115785.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_FEATURE_MAP'
,p_attribute_02=>'WWV_FLOW_FEATURE_MAP'
,p_attribute_03=>'P12_ID'
,p_attribute_04=>'ID'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(87635042733115785.4806)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_FEATURE_MAP'
,p_attribute_02=>'WWV_FLOW_FEATURE_MAP'
,p_attribute_03=>'P12_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('\64CD\4F5C\5DF2\5904\7406\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(87635429357115786.4806)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_CURRENT_PAGE'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(87643759837218802.4806)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'CREATE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00013
begin
wwv_flow_api.create_page(
 p_id=>13.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('Bug \6587\4EF6')
,p_step_title=>unistr('Bug \6587\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(637441482420448238.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(323871118327434771.4806)
,p_plug_name=>unistr('Bug \6587\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(678363858364331062.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'n001 id,',
'n002 component_id,',
'''<a class="attachment_link" href="''||wwv_flow_team_file.get_file_src(n001)||''" title="''||wwv_flow_escape.html(c005)||''">''||wwv_flow_escape.html(c002)||''</a>'' file_name,',
'substr(c005,1,50)||decode(greatest(length(c005),50),50,'''',''...'') description,',
'--c009 tags,',
'to_number(nvl(c008,''0'')) file_size,',
'c003 mimetype,',
'd001 date_added, lower(c006) added_by,',
'd002 updated, lower(c007) updated_by,',
'''#'' delete_file,',
'wwv_flow_lang.system_message(''EDIT_LINK_TEXT'', wwv_flow_escape.html(c002)) link_text,',
'wwv_flow_lang.system_message(''DELETE_LINK_TEXT'', wwv_flow_escape.html(c002)) delete_text',
'from wwv_flow_collections',
'where c001 = ''BUG''',
'and n002 = :P13_COMPONENT_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(323871215083434771.4806)
,p_name=>'Bug Files'
,p_max_row_count=>'100000'
,p_max_row_count_message=>unistr('\6B64\67E5\8BE2\8FD4\56DE\7684\884C\6570\8D85\8FC7\4E86 #MAX_ROW_COUNT#, \8BF7\8FC7\6EE4\6570\636E\4EE5\786E\4FDD\83B7\5F97\5B8C\6574\7ED3\679C\3002')
,p_no_data_found_message=>unistr('\672A\627E\5230\6587\4EF6\3002')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'C'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_detail_link=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.:15:P15_ID:#ID#'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil2_16x16.gif" alt="#LINK_TEXT#">'
,p_owner=>'CBCHO'
,p_internal_uid=>323871215083434771
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323871420364434773.4806)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323871514491434774.4806)
,p_db_column_name=>'COMPONENT_ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\7EC4\4EF6 ID')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323871616657434774.4806)
,p_db_column_name=>'FILE_NAME'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\540D\79F0')
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323871718694434774.4806)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\8BF4\660E')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323871805954434774.4806)
,p_db_column_name=>'FILE_SIZE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\5927\5C0F')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323871927357434774.4806)
,p_db_column_name=>'MIMETYPE'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('Mime \7C7B\578B')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323872003251434774.4806)
,p_db_column_name=>'DATE_ADDED'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\6DFB\52A0\65E5\671F')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323872131345434774.4806)
,p_db_column_name=>'ADDED_BY'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('\6DFB\52A0\8005')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323872223923434774.4806)
,p_db_column_name=>'UPDATED'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('\66F4\65B0')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323872322533434774.4806)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('\66F4\65B0\8005')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(323872403049434774.4806)
,p_db_column_name=>'DELETE_FILE'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'&nbsp;'
,p_column_link=>'f?p=&APP_ID.:13:&SESSION.:DELETE_FILE:&DEBUG.::P13_DELETE_FILE_ID:#ID#'
,p_column_linktext=>'<img src="#IMAGE_PREFIX#red_x_16.png" alt="#DELETE_TEXT#">'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(247044059168377605.4806)
,p_db_column_name=>'LINK_TEXT'
,p_display_order=>21
,p_column_identifier=>'L'
,p_column_label=>unistr('\94FE\63A5\6587\672C')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(247045089636377615.4806)
,p_db_column_name=>'DELETE_TEXT'
,p_display_order=>31
,p_column_identifier=>'M'
,p_column_label=>unistr('\5220\9664\6587\672C')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(323873030232445608.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(323871118327434771.4806)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:RIR::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(323873311662449691.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(323871118327434771.4806)
,p_button_name=>'ADD_FILE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404891952915809007.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\6DFB\52A0\6587\4EF6')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:14:P14_COMPONENT_ID,P14_GO_TO_PAGE:&P13_COMPONENT_ID.,13'
,p_icon_css_classes=>'icon-right-chevron'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(323872727826439767.4806)
,p_name=>'P13_COMPONENT_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(323871118327434771.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(323872924591441348.4806)
,p_name=>'P13_DELETE_FILE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(323871118327434771.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(323875116600460199.4806)
,p_computation_sequence=>10
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'13'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(825563199393976126.4806)
,p_name=>'Submit Page on Create Dialog Close'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(323873311662449691.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(825563430124976129.4806)
,p_event_id=>wwv_flow_api.id(825563199393976126.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(694446867441427541.4806)
,p_name=>'Submit Page on Edit/Delete Dialog Close'
,p_event_sequence=>20
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(323871118327434771.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694446954159427542.4806)
,p_event_id=>wwv_flow_api.id(694446867441427541.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(323876032571465207.4806)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete file'
,p_process_sql_clob=>'wwv_flow_team_file.delete_file(p_file_id => :P13_DELETE_FILE_ID);'
,p_process_error_message=>unistr('\65E0\6CD5\5220\9664\6587\4EF6\3002')
,p_process_when=>'DELETE_FILE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
,p_process_success_message=>unistr('\6587\4EF6\5DF2\5220\9664\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(323876513309469139.4806)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create file collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.create_file_collection (',
'    p_component_id    => :P13_COMPONENT_ID',
'    );'))
,p_process_error_message=>unistr('\65E0\6CD5\521B\5EFA\6587\4EF6\96C6\5408\3002')
,p_process_when=>'P13_COMPONENT_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00014
begin
wwv_flow_api.create_page(
 p_id=>14.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\6DFB\52A0\6587\4EF6')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\6DFB\52A0\6587\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(694252054065447551.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_required_patch=>wwv_flow_api.id(314413317596395364.4806)
,p_dialog_height=>'400'
,p_dialog_width=>'650'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(324002731829493157.4806)
,p_plug_name=>unistr('\6587\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(694446575705427538.4806)
,p_plug_name=>unistr('\6309\94AE\680F')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(324006718874493161.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(694446575705427538.4806)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\6DFB\52A0\6587\4EF6')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P14_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324002909905493158.4806)
,p_name=>'P14_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(324002731829493157.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324003125386493158.4806)
,p_name=>'P14_COMPONENT_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(324002731829493157.4806)
,p_prompt=>'Bug'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'BUGS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select bug_title d, id r',
'from   wwv_flow_bugs',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_tag_attributes=>'style="height:30px;"'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324003810168493159.4806)
,p_name=>'P14_FILE_MIMETYPE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(324002731829493157.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324004027690493159.4806)
,p_name=>'P14_FILE_CHARSET'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(324002731829493157.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324004200863493159.4806)
,p_name=>'P14_FILE_BLOB'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(324002731829493157.4806)
,p_prompt=>unistr('\6587\4EF6')
,p_display_as=>'NATIVE_FILE'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(487444999901719038.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\5728\6587\4EF6\7CFB\7EDF\4E0A\67E5\627E\6587\4EF6\5E76\5C06\5176\9644\52A0\5230\5C0F\7EC4\5F00\53D1\7EC4\4EF6\3002')
,p_attribute_01=>'WWV_FLOW_FILES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324004719749493160.4806)
,p_name=>'P14_FILE_COMMENTS'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(324002731829493157.4806)
,p_prompt=>unistr('\8BF4\660E')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('\8F93\5165\6587\4EF6\8BF4\660E\3002')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324005224968493160.4806)
,p_name=>'P14_FILENAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(324002731829493157.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('\8F93\5165\6587\4EF6\540D')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324005703124493160.4806)
,p_name=>'P14_GO_TO_PAGE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(324002731829493157.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(829747585725444945.4806)
,p_validation_name=>'apex$team_dev_files table exists'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_workspace_schema varchar2(255);',
'begin',
'    select first_schema_provisioned',
'    into l_workspace_schema',
'    from wwv_flow_companies',
'    where provisioning_company_id = :flow_security_group_id;',
'',
'    for c1 in (select null',
'               from sys.dba_tables',
'               where owner = l_workspace_schema',
'               and table_name = ''APEX$TEAM_DEV_FILES'')',
'    loop',
'        return true;',
'    end loop;',
'    return false;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\7F3A\5C11\5B58\50A8\5C0F\7EC4\5F00\53D1\6587\4EF6\6240\9700\7684\8868\3002\8BF7\4E0E\5DE5\4F5C\533A\7BA1\7406\5458\8054\7CFB\3002')
,p_when_button_pressed=>wwv_flow_api.id(324006718874493161.4806)
,p_associated_item=>wwv_flow_api.id(.4806)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_validation_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    for c1 in (select null',
'               from user_tables',
'               where table_name = ''APEX$TEAM_DEV_FILES'')',
'    loop',
'        return true;',
'    end loop;',
'    return false;',
'end;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(324007430416493163.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.add_file (',
'    p_component_id    => :P14_COMPONENT_ID,',
'    p_component_type  => ''BUG'',',
'    p_file_name       => :P14_FILE_BLOB,',
'    p_file_comments   => :P14_FILE_COMMENTS',
'    );'))
,p_process_error_message=>unistr('\65E0\6CD5\6DFB\52A0\6587\4EF6\3002')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(324006718874493161.4806)
,p_process_success_message=>unistr('\6587\4EF6\5DF2\6DFB\52A0\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(694446754257427540.4806)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00015
begin
wwv_flow_api.create_page(
 p_id=>15.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\6587\4EF6')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\6587\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(694252054065447551.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_dialog_height=>'500'
,p_dialog_width=>'650'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(324585516936611181.4806)
,p_plug_name=>'button'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(324586332716611182.4806)
,p_plug_name=>unistr('\6587\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(208647221410212318.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(324585908356611182.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(324585516936611181.4806)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\5220\9664')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P15_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(324586114595611182.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(324585516936611181.4806)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5E94\7528\66F4\6539')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P15_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324586519368611182.4806)
,p_name=>'P15_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(324586332716611182.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324586701984611183.4806)
,p_name=>'P15_COMPONENT_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(324586332716611182.4806)
,p_prompt=>'Bug'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'BUGS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select bug_title d, id r',
'from   wwv_flow_bugs',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324586925853611183.4806)
,p_name=>'P15_COMPONENT_TYPE'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(324586332716611182.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324587115193611183.4806)
,p_name=>'P15_FILENAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(324586332716611182.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\540D\79F0')
,p_source=>'''<a href="''||wwv_flow_team_file.get_file_src(to_number(:P15_ID))||''">''||wwv_flow_escape.html(:P15_FILENAME)||''</a>'''
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324587310725611183.4806)
,p_name=>'P15_FILE_MIMETYPE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(324586332716611182.4806)
,p_prompt=>unistr('Mime \7C7B\578B')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324587505782611183.4806)
,p_name=>'P15_FILE_COMMENTS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(324586332716611182.4806)
,p_prompt=>unistr('\8BF4\660E')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('\8F93\5165\6587\4EF6\8BF4\660E\3002')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324588030782611184.4806)
,p_name=>'P15_UPDATED'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(324586332716611182.4806)
,p_prompt=>unistr('\66F4\65B0')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_new_grid=>true
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(324588202341611184.4806)
,p_name=>'P15_UPDATED_BY'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(324586332716611182.4806)
,p_prompt=>unistr('\66F4\65B0\8005')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(324588909115611186.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.delete_file (',
'    p_file_id   => :P15_ID);'))
,p_process_error_message=>unistr('\65E0\6CD5\5220\9664\6587\4EF6\3002')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(324585908356611182.4806)
,p_process_success_message=>unistr('\6587\4EF6\5DF2\5220\9664\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(324589519323611186.4806)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save file comment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.save_file_comment (',
'    p_file_id          => :P15_ID,',
'    p_file_comments    => :P15_FILE_COMMENTS);'))
,p_process_error_message=>unistr('\65E0\6CD5\4FDD\5B58\6CE8\91CA\3002')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(324586114595611182.4806)
,p_process_success_message=>unistr('\5DF2\4FDD\5B58\6587\4EF6\6CE8\91CA\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(324589111467611186.4806)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'15'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(324585908356611182.4806)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(828917367516270132.4806)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Modal'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(324589332245611186.4806)
,p_process_sequence=>40
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.fetch_file (',
'    p_file_id          => :P15_ID,',
'    p_component_id     => :P15_COMPONENT_ID,',
'    p_component_type   => :P15_COMPONENT_TYPE,',
'    p_filename         => :P15_FILENAME,',
'    p_file_mimetype    => :P15_FILE_MIMETYPE,',
'    p_file_comments    => :P15_FILE_COMMENTS,',
'    p_updated_on       => :P15_UPDATED,',
'    p_updated_by       => :P15_UPDATED_BY',
'    );'))
,p_process_error_message=>unistr('\65E0\6CD5\63D0\53D6\6587\4EF6\4FE1\606F\3002')
);
end;
/
prompt --application/pages/page_00016
begin
wwv_flow_api.create_page(
 p_id=>16.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\6DFB\52A0\6587\4EF6')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\6DFB\52A0\6587\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(694252054065447551.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_required_patch=>wwv_flow_api.id(314413317596395364.4806)
,p_dialog_height=>'400'
,p_dialog_width=>'650'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(325161802575776656.4806)
,p_plug_name=>unistr('\6587\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(208647221410212318.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(325164505196776659.4806)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(325165304639776660.4806)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(325164505196776659.4806)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\6DFB\52A0\6587\4EF6')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P16_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325162008683776657.4806)
,p_name=>'P16_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(325161802575776656.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325162200612776657.4806)
,p_name=>'P16_COMPONENT_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(325161802575776656.4806)
,p_prompt=>unistr('\529F\80FD')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select feature_name d, id r',
'from   wwv_flow_features',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325162409046776657.4806)
,p_name=>'P16_FILE_MIMETYPE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(325161802575776656.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325162631875776657.4806)
,p_name=>'P16_FILE_CHARSET'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(325161802575776656.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325162806509776658.4806)
,p_name=>'P16_FILE_BLOB'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(325161802575776656.4806)
,p_prompt=>unistr('\6587\4EF6')
,p_display_as=>'NATIVE_FILE'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(487444999901719038.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\5728\6587\4EF6\7CFB\7EDF\4E0A\67E5\627E\6587\4EF6\5E76\5C06\5176\9644\52A0\5230\5C0F\7EC4\5F00\53D1\7EC4\4EF6\3002')
,p_attribute_01=>'WWV_FLOW_FILES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325163315231776658.4806)
,p_name=>'P16_FILE_COMMENTS'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(325161802575776656.4806)
,p_prompt=>unistr('\8BF4\660E')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('\8F93\5165\6587\4EF6\8BF4\660E')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325163817828776659.4806)
,p_name=>'P16_FILENAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(325161802575776656.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('\8F93\5165\6587\4EF6\540D')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325164308435776659.4806)
,p_name=>'P16_GO_TO_PAGE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(325161802575776656.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(829747827506447238.4806)
,p_validation_name=>'apex$team_dev_files table exists'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_workspace_schema varchar2(255);',
'begin',
'    select first_schema_provisioned',
'    into l_workspace_schema',
'    from wwv_flow_companies',
'    where provisioning_company_id = :flow_security_group_id;',
'',
'    for c1 in (select null',
'               from sys.dba_tables',
'               where owner = l_workspace_schema',
'               and table_name = ''APEX$TEAM_DEV_FILES'')',
'    loop',
'        return true;',
'    end loop;',
'    return false;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\7F3A\5C11\5B58\50A8\5C0F\7EC4\5F00\53D1\6587\4EF6\6240\9700\7684\8868\3002\8BF7\4E0E\5DE5\4F5C\533A\7BA1\7406\5458\8054\7CFB\3002')
,p_when_button_pressed=>wwv_flow_api.id(325165304639776660.4806)
,p_associated_item=>wwv_flow_api.id(.4806)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(325166225042776665.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.add_file (',
'    p_component_id    => :P16_COMPONENT_ID,',
'    p_component_type  => ''FEATURE'',',
'    p_file_name       => :P16_FILE_BLOB,',
'    p_file_comments   => :P16_FILE_COMMENTS',
'    );'))
,p_process_error_message=>unistr('\65E0\6CD5\6DFB\52A0\6587\4EF6\3002')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(325165304639776660.4806)
,p_process_success_message=>unistr('\6587\4EF6\5DF2\6DFB\52A0\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(694447240900427545.4806)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Modal'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00017
begin
wwv_flow_api.create_page(
 p_id=>17.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\529F\80FD\6587\4EF6')
,p_step_title=>unistr('\529F\80FD\6587\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(637441482420448238.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(325300313334822807.4806)
,p_plug_name=>unistr('\529F\80FD\6587\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(678363858364331062.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'n001 id,',
'n002 component_id,',
'''<a class="attachment_link" href="''||wwv_flow_team_file.get_file_src(n001)||''" title="''||wwv_flow_escape.html(c005)||''">''||wwv_flow_escape.html(c002)||''</a>'' file_name,',
'substr(c005,1,50)||decode(greatest(length(c005),50),50,'''',''...'') description,',
'--c009 tags,',
'to_number(nvl(c008,''0'')) file_size,',
'c003 mimetype,',
'd001 date_added, lower(c006) added_by,',
'd002 updated, lower(c007) updated_by,',
'''#'' delete_file,',
'wwv_flow_lang.system_message(''EDIT_LINK_TEXT'', wwv_flow_escape.html(c002)) link_text,',
'wwv_flow_lang.system_message(''DELETE_LINK_TEXT'', wwv_flow_escape.html(c002)) delete_text',
'from wwv_flow_collections',
'where c001 = ''FEATURE''',
'and n002 = :P17_COMPONENT_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(325300523870822808.4806)
,p_name=>'Bug Files'
,p_max_row_count=>'100000'
,p_max_row_count_message=>unistr('\6B64\67E5\8BE2\8FD4\56DE\7684\884C\6570\8D85\8FC7\4E86 #MAX_ROW_COUNT#, \8BF7\8FC7\6EE4\6570\636E\4EE5\786E\4FDD\83B7\5F97\5B8C\6574\7ED3\679C\3002')
,p_no_data_found_message=>unistr('\672A\627E\5230\6587\4EF6\3002')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'C'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_detail_link=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:18:P18_ID:#ID#'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil2_16x16.gif" alt="#LINK_TEXT#">'
,p_owner=>'CBCHO'
,p_internal_uid=>325300523870822808
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325300605002822810.4806)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325300710585822811.4806)
,p_db_column_name=>'COMPONENT_ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\7EC4\4EF6 ID')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325300807206822811.4806)
,p_db_column_name=>'FILE_NAME'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\540D\79F0')
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325300903722822811.4806)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\8BF4\660E')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325301016643822812.4806)
,p_db_column_name=>'FILE_SIZE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\5927\5C0F')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325301127542822812.4806)
,p_db_column_name=>'MIMETYPE'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('Mime \7C7B\578B')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325301222297822812.4806)
,p_db_column_name=>'DATE_ADDED'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\6DFB\52A0\65E5\671F')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325301310379822812.4806)
,p_db_column_name=>'ADDED_BY'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('\6DFB\52A0\8005')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325301428108822812.4806)
,p_db_column_name=>'UPDATED'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('\66F4\65B0')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325301502132822812.4806)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('\66F4\65B0\8005')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(325301618429822812.4806)
,p_db_column_name=>'DELETE_FILE'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'&nbsp;'
,p_column_link=>'f?p=&APP_ID.:17:&SESSION.:DELETE_FILE:&DEBUG.::P17_DELETE_FILE_ID:#ID#'
,p_column_linktext=>'<img src="#IMAGE_PREFIX#red_x_16.png" alt="#DELETE_TEXT#">'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(247044118361377606.4806)
,p_db_column_name=>'LINK_TEXT'
,p_display_order=>21
,p_column_identifier=>'L'
,p_column_label=>unistr('\94FE\63A5\6587\672C')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(247045141112377616.4806)
,p_db_column_name=>'DELETE_TEXT'
,p_display_order=>31
,p_column_identifier=>'M'
,p_column_label=>unistr('\5220\9664\6587\672C')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(325301915460822813.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(325300313334822807.4806)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(325302109627822813.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(325300313334822807.4806)
,p_button_name=>'ADD_FILE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(404891952915809007.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\6DFB\52A0\6587\4EF6')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:16:P16_COMPONENT_ID,P16_GO_TO_PAGE:&P17_COMPONENT_ID.,17'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325302312147822813.4806)
,p_name=>'P17_COMPONENT_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(325300313334822807.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325302502651822814.4806)
,p_name=>'P17_DELETE_FILE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(325300313334822807.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(325303327235822815.4806)
,p_computation_sequence=>10
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'17'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(694447363072427546.4806)
,p_name=>'Handle Dialog Close'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(325300313334822807.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694447439302427547.4806)
,p_event_id=>wwv_flow_api.id(694447363072427546.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(325300313334822807.4806)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(728200541296010724.4806)
,p_name=>'Add Files - Dialog Closed'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(325302109627822813.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(728200828081010728.4806)
,p_event_id=>wwv_flow_api.id(728200541296010724.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(325300313334822807.4806)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(825563520580978727.4806)
,p_name=>'Submit Page on Create Dialog Close'
,p_event_sequence=>30
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(323873311662449691.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(825563885254978751.4806)
,p_event_id=>wwv_flow_api.id(825563520580978727.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(825564125600981231.4806)
,p_name=>'Submit Page on Edit/Delete Dialog Close'
,p_event_sequence=>40
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(325300313334822807.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(825564400668981234.4806)
,p_event_id=>wwv_flow_api.id(825564125600981231.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(325303410701822815.4806)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete file'
,p_process_sql_clob=>'wwv_flow_team_file.delete_file(p_file_id => :P17_DELETE_FILE_ID);'
,p_process_error_message=>unistr('\65E0\6CD5\5220\9664\6587\4EF6\3002')
,p_process_when=>'DELETE_FILE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
,p_process_success_message=>unistr('\6587\4EF6\5DF2\5220\9664\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(325303627798822815.4806)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create file collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.create_file_collection (',
'    p_component_id    => :P17_COMPONENT_ID',
'    );'))
,p_process_error_message=>unistr('\65E0\6CD5\521B\5EFA\6587\4EF6\96C6\5408\3002')
,p_process_when=>'P17_COMPONENT_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00018
begin
wwv_flow_api.create_page(
 p_id=>18.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\6587\4EF6')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\6587\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(694252054065447551.4806)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_dialog_height=>'500'
,p_dialog_width=>'650'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(325339206655855516.4806)
,p_plug_name=>'button'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(325340017729855517.4806)
,p_plug_name=>unistr('\6587\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(208647221410212318.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(325339605183855517.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(325339206655855516.4806)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\5220\9664')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P18_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(325339830442855517.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(325339206655855516.4806)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5E94\7528\66F4\6539')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P18_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325340217156855517.4806)
,p_name=>'P18_COMPONENT_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(325340017729855517.4806)
,p_prompt=>unistr('\529F\80FD')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select feature_name d, id r',
'from   wwv_flow_features',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325340411685855517.4806)
,p_name=>'P18_COMPONENT_TYPE'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(325340017729855517.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325340623215855517.4806)
,p_name=>'P18_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(325340017729855517.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325340814197855519.4806)
,p_name=>'P18_FILENAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(325340017729855517.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\540D\79F0')
,p_source=>'''<a href="''||wwv_flow_team_file.get_file_src(to_number(:P18_ID))||''">''||wwv_flow_escape.html(:P18_FILENAME)||''</a>'''
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325341023310855519.4806)
,p_name=>'P18_FILE_MIMETYPE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(325340017729855517.4806)
,p_prompt=>unistr('Mime \7C7B\578B')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325341231486855519.4806)
,p_name=>'P18_FILE_COMMENTS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(325340017729855517.4806)
,p_prompt=>unistr('\8BF4\660E')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('\8F93\5165\6587\4EF6\8BF4\660E\3002')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325341722841855520.4806)
,p_name=>'P18_UPDATED'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(325340017729855517.4806)
,p_prompt=>unistr('\66F4\65B0')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(325341900636855520.4806)
,p_name=>'P18_UPDATED_BY'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(325340017729855517.4806)
,p_prompt=>unistr('\66F4\65B0\8005')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(325342827813855521.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.delete_file (',
'    p_file_id   => :P18_ID);'))
,p_process_error_message=>unistr('\65E0\6CD5\5220\9664\6587\4EF6\3002')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(325339605183855517.4806)
,p_process_success_message=>unistr('\6587\4EF6\5DF2\5220\9664\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(325343426390855521.4806)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save file comment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.save_file_comment (',
'    p_file_id          => :P18_ID,',
'    p_file_comments    => :P18_FILE_COMMENTS);'))
,p_process_error_message=>unistr('\65E0\6CD5\4FDD\5B58\6CE8\91CA\3002')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(325339830442855517.4806)
,p_process_success_message=>unistr('\5DF2\4FDD\5B58\6587\4EF6\6CE8\91CA\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(325343016172855521.4806)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'18'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(325339605183855517.4806)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(694447710204427550.4806)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Modal'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(325343221022855521.4806)
,p_process_sequence=>40
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.fetch_file (',
'    p_file_id          => :P18_ID,',
'    p_component_id     => :P18_COMPONENT_ID,',
'    p_component_type   => :P18_COMPONENT_TYPE,',
'    p_filename         => :P18_FILENAME,',
'    p_file_mimetype    => :P18_FILE_MIMETYPE,',
'    p_file_comments    => :P18_FILE_COMMENTS,',
'    p_updated_on       => :P18_UPDATED,',
'    p_updated_by       => :P18_UPDATED_BY',
'    );'))
,p_process_error_message=>unistr('\65E0\6CD5\63D0\53D6\6587\4EF6\4FE1\606F\3002')
);
end;
/
prompt --application/pages/page_00555
begin
wwv_flow_api.create_page(
 p_id=>555.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\7BA1\7406\9875\590D\67E5\5F85\529E\4E8B\9879')
,p_step_title=>unistr('\7BA1\7406\9875\590D\67E5\5F85\529E\4E8B\9879')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(184559920319398484)
,p_step_template=>wwv_flow_api.id(389138863817227422.4806)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1267073084475447803.4806)
,p_plug_name=>'Autocreate Options'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--hideHeader'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1267073101448447804.4806)
,p_plug_name=>unistr('\5173\4E8E')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>unistr('<p>\4F7F\7528\6B64\9879\53EF\4EE5\4E3A\5E94\7528\7A0B\5E8F\4E2D\7684\6BCF\4E00\9875\521B\5EFA\5F85\529E\4E8B\9879\3002</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1267073311970447806.4806)
,p_plug_name=>unistr('\7BA1\7406\9875\590D\67E5\5F85\529E\4E8B\9879')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--showTitle'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1267073449464447807.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1267073311970447806.4806)
,p_button_name=>'CreateToDos'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\521B\5EFA\5F85\529E\4E8B\9879')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1267017491667712450.4806)
,p_branch_name=>'Branch to Confirmation Page'
,p_branch_action=>'f?p=&APP_ID.:556:&SESSION.::&DEBUG.:RP:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1267017169780712447.4806)
,p_name=>'P555_ASSIGNED_TO'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1267073084475447803.4806)
,p_prompt=>unistr('\5206\914D\7ED9')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\5C06\64CD\4F5C\9879\81EA\52A8\5206\914D\7ED9\7528\6237\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1267017296343712448.4806)
,p_name=>'P555_DESCRIPTION'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1267073084475447803.4806)
,p_prompt=>unistr('\8BF4\660E')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\5C06\81EA\52A8\6DFB\52A0\5230\8BF4\660E\5B57\6BB5\4E2D\7684\6587\672C\3002')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1267017319810712449.4806)
,p_name=>'P555_OPTIONS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(1267073084475447803.4806)
,p_prompt=>unistr('\5305\542B')
,p_display_as=>'NATIVE_CHECKBOX'
,p_lov=>'STATIC:Page Mode;M,Page Function;F,Regions;R,Items;I,Buttons;B'
,p_lov_display_null=>'YES'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1267073250725447805.4806)
,p_name=>'P555_APPLICATION'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1267073084475447803.4806)
,p_prompt=>unistr('\5E94\7528\7A0B\5E8F')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'APPLICATION NAME RETURNING ID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'from   wwv_flows f',
'where  ',
'       security_group_id = :flow_security_group_id and',
'       not exists (',
'       select null from wwv_flow_language_map',
'       where translation_flow_id = f.id and ',
'         security_group_id = :flow_security_group_id) and',
'       (',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :app_user and ',
'             flow_id is null and ',
'             security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :app_user and ',
'             flow_id = f.id and ',
'             security_group_id = :flow_security_group_id ))'))
,p_lov_display_null=>'YES'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(487444999901719038.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00556
begin
wwv_flow_api.create_page(
 p_id=>556.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\7BA1\7406\9875\590D\67E5\5F85\529E\4E8B\9879')
,p_step_title=>unistr('\7BA1\7406\9875\590D\67E5\5F85\529E\4E8B\9879')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(184559920319398484)
,p_step_template=>wwv_flow_api.id(389138863817227422.4806)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1300702319245081679.4806)
,p_plug_name=>unistr('\81EA\52A8\521B\5EFA\9009\9879')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(688662784908046983.4806)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1300703931226081697.4806)
,p_plug_name=>unistr('\5173\4E8E')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>unistr('<p>\4F7F\7528\6B64\9879\6267\884C\529F\80FD</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1300704151037081697.4806)
,p_plug_name=>unistr('\7BA1\7406\9875\590D\67E5\5F85\529E\4E8B\9879')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--showTitle'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1300704396946081697.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1300704151037081697.4806)
,p_button_name=>'CreateToDos'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\521B\5EFA\5F85\529E\4E8B\9879')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1300704613755081701.4806)
,p_branch_name=>'Return to the Utilities Page'
,p_branch_action=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1300702519461081689.4806)
,p_name=>'P556_APPLICATION'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1300702319245081679.4806)
,p_prompt=>unistr('\5E94\7528\7A0B\5E8F')
,p_source=>'P555_APPLICATION'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(487444999901719038.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1300702751350081693.4806)
,p_name=>'P556_ASSIGNED_TO'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1300702319245081679.4806)
,p_prompt=>unistr('\5206\914D\7ED9')
,p_source=>'P555_ASSIGNED_TO'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1300703286103081694.4806)
,p_name=>'P556_DESCRIPTION'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1300702319245081679.4806)
,p_prompt=>unistr('\8BF4\660E')
,p_source=>'P555_DESCRIPTION'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1300703773650081694.4806)
,p_name=>'P556_OPTIONS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(1300702319245081679.4806)
,p_prompt=>unistr('\5305\542B')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with lov as (',
'    select ''Page Mode'' disp, ''M'' ret from dual',
'    union all',
'    select ''Page Function'' disp, ''F'' ret from dual',
'    union all',
'    select ''Regions'' disp, ''R'' ret from dual',
'    union all',
'    select ''Items'' disp, ''I'' ret from dual',
'    union all',
'    select ''Buttons'' disp, ''B'' ret from dual',
')',
'select listagg(disp,'', '') within group (order by disp) val_list',
'from lov',
'where '':''||:P555_OPTIONS||'':'' like ''%:''||lov.ret||'':%'''))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_lov=>'STATIC:Page Mode;M,Page Function;F,Regions;R,Items;I,Buttons;B'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1300719308986373701.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Auto-Create Application Todos'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_min_task number;',
'begin',
'    select nvl(max(friendly_id),0) into l_min_task',
'    from wwv_flow_tasks t',
'    where t.application_id = :P555_APPLICATION;',
'',
'    insert into wwv_flow_tasks (security_group_id,',
'                                friendly_id,',
'                                assigned_to,',
'                                task_name,',
'                                description,',
'                                task_status,',
'                                application_id,',
'                                page_id,',
'                                parent_task_id )',
'    select f.security_group_id,',
'        l_min_task+rownum friendly_id,',
'        :P555_ASSIGNED_TO assigned_to,',
'        ''Verify App ''||f.id||'' - ''||f.name task_name,',
'        :P555_DESCRIPTION||'' (''||(select count(*) from wwv_flow_steps where flow_id = f.id)||'' pages at initial load)'' description,',
'        0 task_status,',
'        f.id application_id,',
'        null page_id,',
'        null parent_task_id',
'    from wwv_flows f',
'    where f.id = :P555_APPLICATION',
'        and not exists (select null',
'                        from wwv_flow_tasks ft2',
'                        where ft2.security_group_id = f.security_group_id',
'                            and ft2.application_id = f.id',
'                            and ft2.task_name = ''Verify App ''||f.id||'' - ''||f.name);',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('\5DF2\521B\5EFA\5E94\7528\7A0B\5E8F\5F85\529E\4E8B\9879\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1300719462836373702.4806)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Auto-Create Page Todos'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_min_task number;',
'begin',
'    select nvl(max(friendly_id),0) into l_min_task',
'    from wwv_flow_tasks t',
'    where t.application_id = :P555_APPLICATION;',
'',
'    insert into wwv_flow_tasks (security_group_id,',
'                                friendly_id,',
'                                assigned_to,',
'                                task_name,',
'                                description,',
'                                task_status,',
'                                application_id,',
'                                page_id,',
'                                parent_task_id )',
'    select p.security_group_id,',
'        l_min_task+rownum friendly_id,',
'        :P555_ASSIGNED_TO assigned_to,',
'        p.page_id||''. ''||p.page_name task_name,',
'        ''''',
'            ||case when instr(:P555_OPTIONS, ''M'') > 0 then ''Page Mode: ''||p.page_mode',
'                ||chr(13)||chr(10) end',
'            ||case when instr(:P555_OPTIONS, ''F'') > 0 then ''Page Function: ''||p.page_function',
'                ||chr(13)||chr(10) end',
'            ||case when instr(:P555_OPTIONS, ''R'') > 0 then p.regions||'' regions''',
'--                ||case when p.never_regions > 0 then '' (''||p.never_regions||'' set to condition never)'' end',
'                ||chr(13)||chr(10) end',
'            ||case when instr(:P555_OPTIONS, ''I'') > 0 then p.items||'' items''',
'                ||chr(13)||chr(10) end',
'            ||case when instr(:P555_OPTIONS, ''B'') > 0 then p.buttons||'' buttons''',
'                end as description,',
'        0 task_status,',
'        p.application_id,',
'        p.page_id,',
'        p.parent_task_id',
'    from (  select ap.security_group_id,',
'                ap.id application_id,',
'                pg.id page_id,',
'                pg.name page_name,',
'                decode(nvl(pg.page_mode,''NORMAL''),',
'                   ''NORMAL'',''Normal'',',
'                   ''MODAL'',''Modal'',',
'                   ''NON_MODAL'',''Non-Modal'') page_mode,',
'                decode(substr(pg.page_component_map,1,2),',
'                    ''01'',''Tabular Form'',',
'                    ''02'',''Form'',',
'                    ''03'',''Report'',',
'                    ''04'',''Chart'',',
'                    ''05'',''Web Service'',',
'                    ''06'',''Navigation Page'',',
'                    ''07'',''Tree'',',
'                    ''08'',''Calendar'',',
'                    ''09'',''URL'',',
'                    ''10'',''Dynamic HTML'',',
'                    ''11'',''Static HTML'',',
'                    ''12'',''Login'',',
'                    ''13'',''Home'',',
'                    ''14'',''Global Page'',',
'                    ''15'',''Empty Page'',',
'                    ''16'',''Dynamic Form'',',
'                    ''17'',''Wizard Form'',',
'                    ''Unknown'') page_function,',
'                (   select count(*)',
'                    from wwv_flow_page_plugs',
'                    where flow_id = pg.flow_id',
'                        and page_id = pg.id ) regions,',
'                (   select count(*)',
'                    from wwv_flow_step_items ii',
'                    where flow_id = pg.flow_id',
'                        and flow_step_id = pg.id ) items,',
'                (   select count(*)',
'                    from wwv_flow_step_buttons',
'                    where flow_id = pg.flow_id',
'                        and flow_step_id = pg.id ) buttons,',
'                (   select count(*)',
'                    from wwv_flow_page_plugs r',
'                    where r.flow_id = ap.id',
'                        and r.page_id = pg.id',
'                        and r.plug_display_condition_type = ''NEVER''',
'                    ) never_regions,',
'                (   select id',
'                    from wwv_flow_tasks ft',
'                    where ft.application_id = ap.id',
'                        and ft.task_name = ''Verify App ''||ap.id||'' - ''||ap.name ',
'                    ) parent_task_id',
'            from wwv_flows ap,',
'                wwv_flow_steps pg',
'            where ap.id = :P555_APPLICATION',
'                and pg.flow_id = ap.id',
'        ) p',
'    where not exists (  select null',
'                        from wwv_flow_tasks ft2',
'                        where ft2.application_id = :P555_APPLICATION',
'                            and ft2.page_id = p.page_id',
'                            and ft2.task_name = p.page_id||''. ''||p.page_name );',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('\5DF2\521B\5EFA\9875\5F85\529E\4E8B\9879\3002')
);
end;
/
prompt --application/pages/page_01000
begin
wwv_flow_api.create_page(
 p_id=>1000.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\529F\80FD\7C7B\578B')
,p_step_title=>unistr('\529F\80FD\7C7B\578B')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(33677247189967024.4806)
,p_plug_name=>'Feature Types'
,p_plug_display_sequence=>11
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select "ROWID", ',
'"ID",',
'"TYPE_ID",',
'"TYPE_NAME",',
'"TYPE_DESC",',
'"SECURITY_GROUP_ID",',
'"CREATED_BY",',
'"CREATED_ON",',
'"UPDATED_BY",',
'"UPDATED_ON",',
'wwv_flow_lang.system_message(''EDIT_LINK_TEXT'', wwv_flow_escape.html(type_name)) link_text',
'from "#OWNER#"."WWV_FLOW_FEATURE_TYPES" ',
'order by "TYPE_ID" asc',
'  ',
''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(33677615289967024.4806)
,p_name=>'Feature Types'
,p_max_row_count=>'1000000'
,p_max_row_count_message=>unistr('\6B64\62A5\8868\7684\6700\5927\884C\6570\4E3A #MAX_ROW_COUNT# \884C\3002\8BF7\5E94\7528\8FC7\6EE4\5668\6765\51CF\5C11\67E5\8BE2\4E2D\7684\8BB0\5F55\6570\3002')
,p_no_data_found_message=>unistr('\672A\627E\5230\6570\636E\3002')
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'C'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_detail_link=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.::P1001_ROWID:#ROWID#'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="#LINK_TEXT#" border="0">'
,p_owner=>'MARC'
,p_internal_uid=>33677615289967024
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(33677745082967030.4806)
,p_db_column_name=>'ROWID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'ROWID'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_column_type=>'OTHER'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
,p_rpt_show_filter_lov=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(33678183029967034.4806)
,p_db_column_name=>'ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(33696666801026904.4806)
,p_db_column_name=>'TYPE_ID'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(33678514471967035.4806)
,p_db_column_name=>'TYPE_NAME'
,p_display_order=>22
,p_column_identifier=>'C'
,p_column_label=>unistr('\72B6\6001')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(33678951836967035.4806)
,p_db_column_name=>'TYPE_DESC'
,p_display_order=>32
,p_column_identifier=>'D'
,p_column_label=>unistr('\8BF4\660E')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(33679710963967036.4806)
,p_db_column_name=>'SECURITY_GROUP_ID'
,p_display_order=>52
,p_column_identifier=>'F'
,p_column_label=>unistr('\5B89\5168\7EC4 ID')
,p_column_type=>'NUMBER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(33680100138967038.4806)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>62
,p_column_identifier=>'G'
,p_column_label=>unistr('\521B\5EFA\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(33680573525967038.4806)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>72
,p_column_identifier=>'H'
,p_column_label=>unistr('\521B\5EFA\65F6\95F4')
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(33680965402967039.4806)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>82
,p_column_identifier=>'I'
,p_column_label=>unistr('\66F4\65B0\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(33681303915967039.4806)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>92
,p_column_identifier=>'J'
,p_column_label=>unistr('\66F4\65B0\65F6\95F4')
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(247044212863377607.4806)
,p_db_column_name=>'LINK_TEXT'
,p_display_order=>102
,p_column_identifier=>'M'
,p_column_label=>unistr('\94FE\63A5\6587\672C')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(33712374182360251.4806)
,p_plug_name=>'Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(807048415846272366.4806)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(181255317679390139.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(182442550749490978.4806)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33681733462967040.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(33677247189967024.4806)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\521B\5EFA')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.:1001::'
);
end;
/
prompt --application/pages/page_01001
begin
wwv_flow_api.create_page(
 p_id=>1001.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\7F16\8F91\529F\80FD\7C7B\578B')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\7F16\8F91\529F\80FD\7C7B\578B')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(670195776876712847.4806)
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'C'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(33685678018016241.4806)
,p_plug_name=>unistr('\7F16\8F91\529F\80FD\7C7B\578B')
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding:a-Region--noBorder:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(33696335973026901.4806)
,p_plug_name=>unistr('\6309\94AE')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33686019083016242.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(33696335973026901.4806)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33686415353016243.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(33696335973026901.4806)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\5220\9664')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P1001_ROWID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33686827833016243.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(33696335973026901.4806)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5E94\7528\66F4\6539')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P1001_ROWID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33687142962016243.4806)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(33696335973026901.4806)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\521B\5EFA')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P1001_ROWID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(33691174175016251.4806)
,p_branch_action=>'f?p=&APP_ID.:1000:&SESSION.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(33687509911016245.4806)
,p_name=>'P1001_ROWID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(33685678018016241.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'ROWID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'S'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(33687989307016246.4806)
,p_name=>'P1001_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(33685678018016241.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(33688347480016246.4806)
,p_name=>'P1001_TYPE_NAME'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(33685678018016241.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\7C7B\578B\540D\79F0')
,p_source=>'TYPE_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(487444999901719038.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\529F\80FD\7C7B\578B\7684\540D\79F0\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(33688777123016246.4806)
,p_name=>'P1001_TYPE_DESC'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(33685678018016241.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8BF4\660E')
,p_source=>'TYPE_DESC'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(487444999901719038.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\529F\80FD\7C7B\578B\7684\8BF4\660E\3002')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(33696509467026903.4806)
,p_name=>'P1001_TYPE_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(33685678018016241.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\7C7B\578B\6807\8BC6\7B26')
,p_source=>'TYPE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(487444999901719038.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\529F\80FD\7C7B\578B\7684\6807\8BC6\7B26\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(33689857751016250.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_FEATURE_TYPE'
,p_attribute_02=>'WWV_FLOW_FEATURE_TYPES'
,p_attribute_03=>'P1001_ROWID'
,p_attribute_04=>'ROWID'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(33690290628016250.4806)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_FEATURE_TYPE'
,p_attribute_02=>'WWV_FLOW_FEATURE_TYPES'
,p_attribute_03=>'P1001_ROWID'
,p_attribute_04=>'ROWID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('\64CD\4F5C\5DF2\5904\7406\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(33690609382016250.4806)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_CURRENT_PAGE'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(33686415353016243.4806)
);
end;
/
prompt --application/pages/page_03000
begin
wwv_flow_api.create_page(
 p_id=>3000.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\5F85\529E\4E8B\9879')
,p_step_title=>unistr('\5F85\529E\4E8B\9879')
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(637441482420448238.4806)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'td_todo.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180246234652945304.4806)
,p_plug_name=>'tasks tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(180244521254945294.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(182442550749490978.4806)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180315320381057670.4806)
,p_plug_name=>'Hidden'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display:none"'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(836120745319077001.4806)
,p_plug_name=>unistr('\5F85\529E\4E8B\9879')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* apex4800p3000a */',
'    id,',
'    friendly_id,',
'    release,',
'    feature_id,',
'    t.event_id,',
'    event_id selected_milestone_id,',
'    (select feature_id || '' - '' || feature_name from wwv_flow_features f',
'     where f.security_group_id = :flow_security_group_id and',
'           f.id = t.feature_id) feature,',
'    due_date,',
'    (select count(*)',
'     from wwv_flow_task_progress p',
'     where p.task_id = t.id and ',
'           p.security_group_id = t.security_group_id) progress_notes,',
'    assigned_to,',
'    decode(assigned_to,null,1,0) unassigned,',
'    contributor,',
'    task_name,   ',
'    wwv_flow_escape.html(decode(greatest(sys.dbms_lob.getlength(description),200),',
'        200,sys.dbms_lob.substr(description,200,1),',
'        sys.dbms_lob.substr(description,200,1)||''...'')) short_description_no_esc,',
'    description,',
'    wwv_flow_escape.html(sys.dbms_lob.substr(description,3000,1)) description_no_esc,',
'    wwv_flow_escape.html(sys.dbms_lob.substr(description,3000,3001)) description_no_esc2,',
'    task_status,',
'    decode(greatest(task_status,99),99,''yes'',''no'') is_open,',
'    task_status pct_complete,',
'    decode(greatest(task_status,99),99,''1'',''0'') is_open_01,',
'    decode(greatest(task_status,99),99,''0'',''1'') is_closed,',
'    task_category,',
'    task_tags,',
'    start_date,',
'    date_completed,',
'    application_id,',
'    page_id,',
'    websheet_id,',
'    ref_component_type,',
'    lower(created_by) created_by,',
'    created_on,',
'    lower(updated_by) updated_by,',
'    nvl(updated_on,created_on) updated_on,',
'    parent_task_id,',
'    estimated_effort_in_hours,',
'    ''<img src="#image_prefix#htmldb/icons/copy_small.gif" alt="copy" />'' copy',
'from wwv_flow_tasks t',
'where security_group_id = :flow_security_group_id',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>11
,p_prn_height=>8.5
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836120984336077003.4806)
,p_name=>'ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>40
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836121006150077004.4806)
,p_name=>'FRIENDLY_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'FRIENDLY_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\7F16\53F7')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836121144702077005.4806)
,p_name=>'RELEASE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'RELEASE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_SELECT_LIST'
,p_heading=>unistr('\53D1\884C\7248')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>170
,p_value_alignment=>'LEFT'
,p_is_required=>false
,p_lov_type=>'SHARED'
,p_lov_id=>wwv_flow_api.id(180448841427975527)
,p_lov_display_extra=>false
,p_lov_display_null=>true
,p_lov_null_text=>unistr('- \9009\62E9\53D1\884C\7248 -')
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836121280228077006.4806)
,p_name=>'FEATURE_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'FEATURE_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>70
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836121413030077008.4806)
,p_name=>'SELECTED_MILESTONE_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SELECTED_MILESTONE_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>90
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836121563105077009.4806)
,p_name=>'FEATURE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'FEATURE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\529F\80FD')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>100
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_link_target=>'f?p=&APP_ID.:9001:&SESSION.::&DEBUG.:RP:P9001_ID:&FEATURE_ID.'
,p_link_text=>'&FEATURE.'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836121665481077010.4806)
,p_name=>'DUE_DATE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DUE_DATE'
,p_data_type=>'DATE'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>110
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836121765880077011.4806)
,p_name=>'PROGRESS_NOTES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PROGRESS_NOTES'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>120
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836121890436077012.4806)
,p_name=>'ASSIGNED_TO'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ASSIGNED_TO'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_SELECT_LIST'
,p_heading=>unistr('\5206\914D\7ED9')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>130
,p_value_alignment=>'LEFT'
,p_is_required=>false
,p_lov_type=>'SHARED'
,p_lov_id=>wwv_flow_api.id(180615541135479707)
,p_lov_display_extra=>true
,p_lov_display_null=>true
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836121951899077013.4806)
,p_name=>'UNASSIGNED'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'UNASSIGNED'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>140
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836122046081077014.4806)
,p_name=>'CONTRIBUTOR'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CONTRIBUTOR'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>150
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836122125704077015.4806)
,p_name=>'TASK_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TASK_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\5F85\529E\4E8B\9879')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>160
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_link_target=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:RP:P3010_ID:&ID.'
,p_link_text=>'&TASK_NAME.'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836122276040077016.4806)
,p_name=>'SHORT_DESCRIPTION_NO_ESC'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SHORT_DESCRIPTION_NO_ESC'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>180
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836122350391077017.4806)
,p_name=>'DESCRIPTION'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DESCRIPTION'
,p_data_type=>'CLOB'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>190
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836122449458077018.4806)
,p_name=>'DESCRIPTION_NO_ESC'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DESCRIPTION_NO_ESC'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>200
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836122516415077019.4806)
,p_name=>'DESCRIPTION_NO_ESC2'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DESCRIPTION_NO_ESC2'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>210
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836122645305077020.4806)
,p_name=>'TASK_STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TASK_STATUS'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_SELECT_LIST'
,p_heading=>unistr('\72B6\6001')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>220
,p_value_alignment=>'LEFT'
,p_is_required=>false
,p_lov_type=>'SHARED'
,p_lov_id=>wwv_flow_api.id(189636627778719823)
,p_lov_display_extra=>true
,p_lov_display_null=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836122740948077021.4806)
,p_name=>'IS_OPEN'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'IS_OPEN'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>230
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836122879952077022.4806)
,p_name=>'PCT_COMPLETE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PCT_COMPLETE'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>unistr('\5B8C\6210\767E\5206\6BD4')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>240
,p_value_alignment=>'LEFT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836122989222077023.4806)
,p_name=>'IS_OPEN_01'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'IS_OPEN_01'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>250
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836123095913077024.4806)
,p_name=>'IS_CLOSED'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'IS_CLOSED'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>260
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836123117971077025.4806)
,p_name=>'TASK_CATEGORY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TASK_CATEGORY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>270
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836123275271077026.4806)
,p_name=>'TASK_TAGS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TASK_TAGS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>unistr('\6807\8BB0')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>290
,p_value_alignment=>'LEFT'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836123322426077027.4806)
,p_name=>'START_DATE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'START_DATE'
,p_data_type=>'DATE'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>300
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836123470671077028.4806)
,p_name=>'DATE_COMPLETED'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DATE_COMPLETED'
,p_data_type=>'DATE'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>310
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836123581177077029.4806)
,p_name=>'APPLICATION_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'APPLICATION_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>320
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836123615498077030.4806)
,p_name=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PAGE_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>330
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836123760525077031.4806)
,p_name=>'WEBSHEET_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'WEBSHEET_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>340
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836123835394077032.4806)
,p_name=>'REF_COMPONENT_TYPE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'REF_COMPONENT_TYPE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>350
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836123994615077033.4806)
,p_name=>'CREATED_BY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_BY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>360
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836124065903077034.4806)
,p_name=>'CREATED_ON'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_ON'
,p_data_type=>'DATE'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>370
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836124196791077035.4806)
,p_name=>'UPDATED_BY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'UPDATED_BY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>380
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836124229771077036.4806)
,p_name=>'UPDATED_ON'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'UPDATED_ON'
,p_data_type=>'DATE'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\66F4\65B0')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>390
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_format_mask=>'SINCE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836124380093077037.4806)
,p_name=>'PARENT_TASK_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARENT_TASK_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>400
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836124489615077038.4806)
,p_name=>'ESTIMATED_EFFORT_IN_HOURS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ESTIMATED_EFFORT_IN_HOURS'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>410
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836124568950077039.4806)
,p_name=>'COPY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'COPY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>420
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836124649873077040.4806)
,p_name=>'ROWID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ROWID'
,p_data_type=>'ROWID'
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>30
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_is_primary_key=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836124770399077041.4806)
,p_name=>'APEX$ROW_ACTION'
,p_item_type=>'NATIVE_ROW_ACTION'
,p_label=>unistr('\64CD\4F5C')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>20
,p_value_alignment=>'CENTER'
,p_enable_hide=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836124838445077042.4806)
,p_name=>'APEX$ROW_SELECTOR'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_enable_hide=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(836125031588077044.4806)
,p_name=>'EVENT_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'EVENT_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('\91CC\7A0B\7891')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>280
,p_value_alignment=>'RIGHT'
,p_attribute_02=>'LOV'
,p_lov_type=>'SQL_QUERY'
,p_lov_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select event_name||'' ''||event_date event_name, ',
'       id ',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id ',
'order by event_date'))
,p_lov_display_extra=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(836120841972077002.4806)
,p_internal_uid=>836120841972077002
,p_is_editable=>true
,p_edit_operations=>'u:d'
,p_lost_update_check_type=>'VALUES'
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_max_row_count=>100000
,p_show_nulls_as=>'-'
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>true
,p_show_toolbar=>true
,p_enable_save_public_report=>true
,p_enable_subscriptions=>true
,p_enable_flashback=>true
,p_define_chart_view=>true
,p_enable_download=>true
,p_download_formats=>'CSV:HTML:XLS:PDF:RTF'
,p_enable_mail_download=>true
,p_fixed_header=>'PAGE'
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(config) {',
'    var $ = apex.jQuery,',
'        toolbarData = $.apex.interactiveGrid.copyDefaultToolbar(),',
'        lastToolbarGroup = toolbarData[toolbarData.length - 1],',
'        createButton = {',
'            type: "BUTTON",',
'            hot: false,',
'            action: "create-todo"',
'        };',
'    lastToolbarGroup.controls.push( createButton );',
'    config.toolbarData = toolbarData;',
'    ',
'    // this is how actions are added',
'    config.initActions = function(actions) {',
'        actions.add({',
'            name: "create-todo",',
'            // you could define the label directly as English text',
'            // label: "Create"',
'            // But better to use a message so it can be translated. In shared',
'            // components, text messages create MY_CREATE_BUTTON = Create and ',
'            // set Used in JavaScript: Yes',
'            labelKey: "CREATE_TO_DO",',
'            // this sets the action to be what the hidden button does when you click it',
'            action: $("#hiddenCreate").prop("onclick")            ',
'        });',
'    }',
'    return config;',
'}'))
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(932208178134608102.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(180315320381057670.4806)
,p_button_name=>'Create'
,p_button_static_id=>'hiddenCreate'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\521B\5EFA')
,p_button_position=>'BELOW_BOX'
,p_button_redirect_url=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:RP,3010::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(180359929410337438.4806)
,p_branch_action=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180315730770060612.4806)
,p_name=>'P3000_APP_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(180315320381057670.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180468718720129756.4806)
,p_name=>'P3000_LOWER_APP_USER'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(180315320381057670.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(180304530145439832.4806)
,p_computation_sequence=>20
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'3000'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(180468933265133932.4806)
,p_computation_sequence=>40
,p_computation_item=>'P3000_LOWER_APP_USER'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'lower(:app_user);'
,p_compute_when=>'P3000_LOWER_APP_USER'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(836124965468077043.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_api.id(836120745319077001.4806)
,p_process_type=>'NATIVE_IG_DML'
,p_process_name=>'To Dos - Save Interactive Grid Data'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(429727127163021054.4806)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set release filter'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_default_release varchar2(255);',
'',
'    ',
'begin',
'',
'    for c1 in (select default_release',
'             from wwv_flow_task_defaults d',
'             where d.security_group_id = :flow_security_group_id',
'    ) loop',
'        l_default_release  := c1.default_release;',
'',
'    end loop;',
'',
'    if l_default_release is not null and l_default_release != ''0'' then',
'        for c1 in (select id report_id, page_id, region_id',
'                 from  wwv_flow_worksheet_rpts_dev',
'                 where flow_id = :app_id',
'                 and page_id = :app_page_id',
'                 and visibility = ''PRIMARY_DEFAULT'')',
'        loop',
'            wwv_flow_ir_api.add_filter (',
'                        p_page_id       => :app_page_id,',
'                        p_region_id     => c1.region_id,',
'                        p_report_column => ''RELEASE'',',
'                        p_filter_value  => l_default_release,',
'                        p_operator_abbr => ''EQ'',',
'                        p_report_id     => c1.report_id',
'                        );',
'        end loop;',
'    end if;',
'    ',
'end;'))
,p_process_when=>'DNSR'
,p_process_when_type=>'REQUEST_NOT_EQUAL_CONDITION'
);
end;
/
prompt --application/pages/page_03001
begin
wwv_flow_api.create_page(
 p_id=>3001.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\5F85\529E\4E8B\9879\9762\677F')
,p_step_title=>unistr('\5F85\529E\4E8B\9879\9762\677F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(389138863817227422.4806)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'td_todo_repts.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(177391019140415893.4806)
,p_plug_name=>unistr('\5BFC\822A\56FE\6807')
,p_region_name=>'apex-control-icons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(408696048877049411.4806)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(177387020956397479.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(210442022107070716.4806)
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180288541776337605.4806)
,p_plug_name=>'tasks tabs'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(180244521254945294.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(182442550749490978.4806)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180288936103337605.4806)
,p_plug_name=>'top bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-Form--labelsAbove:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(429761407086440909.4806)
,p_name=>unistr('\5F00\53D1\8005\5B8C\6210\767E\5206\6BD4')
,p_template=>wwv_flow_api.id(388361325811341773.4806)
,p_display_sequence=>30
,p_region_template_options=>'#DEFAULT#:h640:a-Region--shadowScroll:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--staticRowColors:a-Report--horizontalBorders:a-Report--stretch:a-Report--rowHighlight'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(ASSIGNED_TO,''Unassigned'') assigned_to,',
'          assigned_to link_assigned_to,',
'          case when assigned_to is null then ''IRN_ASSIGNED_TO'' else '' IR_ASSIGNED_TO'' end assigned_to_cond,',
'          open, ',
'          closed,',
'          total_count,',
'          decode(closed,0,0,100*closed/total_count) pct_complete,',
'         decode(closed,0,0,100*closed/total_count) graph,',
'          most_recent_update,',
'          id',
'from (',
'select assigned_to,',
'       sum(decode(greatest(task_status,99),99,1,0)) open,',
'       sum(decode(greatest(task_status,99),99,0,1)) closed,',
'       count(*) total_count,',
'       max(UPDATED_ON) most_recent_update,',
'       max(t.id) id',
'from wwv_flow_tasks t',
'where security_group_id = :flow_security_group_id and',
'    (nvl(:P3001_RELEASE,''0'') = ''0'' or release = :P3001_RELEASE) and',
'    (nvl(:P3001_DEVELOPER,''0'') = ''0'' or lower(:P3001_DEVELOPER) = lower(assigned_to)) and',
'    (nvl(:P3001_APPLICATION,0) = 0 or application_id = :P3001_APPLICATION) and',
'    (',
'    nvl(:P3001_SHOW,''ALL'') = ''ALL'' or ',
'    (nvl(:P3001_SHOW,''ALL'') = ''OPEN'' and task_status != 100 ) or',
'    (nvl(:P3001_SHOW,''ALL'') = ''COMPLETED'' and task_status = 100)',
'    ) ',
'group by ASSIGNED_TO',
') x',
'order by 1 asc'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(696866128778092508.4806)
,p_query_num_rows=>30
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\5F00\53D1\8005\72B6\6001\4E0D\53EF\7528\3002')
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(429761407086440909.4806)
,p_plug_column_width=>'apex-col--bottomBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(429761718010440925.4806)
,p_query_column_id=>1
,p_column_alias=>'ASSIGNED_TO'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\5206\914D\4EBA\5458')
,p_column_link=>'f?p=&APP_ID.:3000:&SESSION.:DNSR:&DEBUG.:RIR:#ASSIGNED_TO_COND#:#LINK_ASSIGNED_TO#'
,p_column_linktext=>'#ASSIGNED_TO#'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(9145305972096638.4806)
,p_query_column_id=>2
,p_column_alias=>'LINK_ASSIGNED_TO'
,p_column_display_sequence=>9
,p_column_heading=>'Link Assigned To'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(9147102842234719.4806)
,p_query_column_id=>3
,p_column_alias=>'ASSIGNED_TO_COND'
,p_column_display_sequence=>10
,p_column_heading=>'Assigned To Cond'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(429761825093440925.4806)
,p_query_column_id=>4
,p_column_alias=>'OPEN'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\672A\5B8C\6210')
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(429761902462440925.4806)
,p_query_column_id=>5
,p_column_alias=>'CLOSED'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\5DF2\89E3\51B3')
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(429762009527440925.4806)
,p_query_column_id=>6
,p_column_alias=>'TOTAL_COUNT'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\8BA1\6570')
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(429762111080440925.4806)
,p_query_column_id=>7
,p_column_alias=>'PCT_COMPLETE'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\5B8C\6210\767E\5206\6BD4')
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(429762200216440926.4806)
,p_query_column_id=>8
,p_column_alias=>'GRAPH'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\56FE\5F62')
,p_use_as_row_header=>'N'
,p_column_format=>'PCT_GRAPH:F8F8F8:9CBDF1:150'
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(429762308885440926.4806)
,p_query_column_id=>9
,p_column_alias=>'MOST_RECENT_UPDATE'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\66F4\65B0')
,p_column_format=>'SINCE'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(429762431364440926.4806)
,p_query_column_id=>10
,p_column_alias=>'ID'
,p_column_display_sequence=>8
,p_column_heading=>'Edit'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(673329531345671877.4806)
,p_plug_name=>unistr('\6700\5E38\7528\7684\72B6\6001')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:h320'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P3001d */ l.status_name||'' (''||t.task_status||''%)'' status_name, ',
'       count(*) c,',
'       t.task_status,',
'       ''f?p=4800:3000:''||:APP_SESSION||'':DNSR::RIR:IR_PCT_COMPLETE,IR_RELEASE,IR_ASSIGNED_TO:''||',
'       t.task_status||'',''||decode(:P3001_RELEASE,''0'',null,:P3001_RELEASE)||'',''||decode(:P3001_DEVELOPER,''0'',null,:P3001_DEVELOPER) the_link',
'from wwv_flow_tasks t, wwv_flow_task_def_status_codes l',
'where t.security_group_id = :flow_security_group_id and',
'    (nvl(:P3001_RELEASE,''0'') = ''0'' or release = :P3001_RELEASE) and',
'    (nvl(:P3001_DEVELOPER,''0'') = ''0'' or lower(:P3001_DEVELOPER) = lower(assigned_to)) and',
'    (',
'    nvl(:P3001_SHOW,''ALL'') = ''ALL'' or ',
'    (nvl(:P3001_SHOW,''ALL'') = ''OPEN'' and task_status != 100) or',
'    (nvl(:P3001_SHOW,''ALL'') = ''COMPLETED'' and task_status = 100)',
'    ) and',
'      l.pct_complete = t.task_status and',
'    (nvl(:P3001_APPLICATION,0) = 0 or application_id = :P3001_APPLICATION)',
'group by l.status_name, t.task_status',
'order by 2 desc'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_plug_query_num_rows=>15
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_tasks',
'where security_group_id = :flow_security_group_id'))
,p_attribute_01=>'INITIALS'
,p_attribute_02=>'STATUS_NAME'
,p_attribute_03=>'&THE_LINK.'
,p_attribute_04=>'C'
,p_attribute_11=>'VALUE'
,p_attribute_14=>'25'
,p_attribute_15=>'TEXT'
,p_attribute_16=>'ABSOLUTE'
,p_attribute_17=>'MODERN'
,p_attribute_18=>'AROUND'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(673337434921771559.4806)
,p_name=>unistr('\5F85\529E\4E8B\9879\6982\8981')
,p_template=>wwv_flow_api.id(388361325811341773.4806)
,p_display_sequence=>50
,p_region_sub_css_classes=>'a-BadgeList--cols a-BadgeList--2col a-BadgeList--large a-BadgeList--responsive a-BadgeList--bottomBorder'
,p_region_template_options=>'#DEFAULT#:h320:a-Region--scrollAuto:a-Region--noPadding'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
' select /* APEX3609c442 */  ',
'               sum(decode(greatest(task_status,99),99,1,0)) open,',
'               --sum(decode(greatest(task_status,99),99,0,1)) closed,',
'               decode(count(*),0,0,',
'                round(',
'                100*sum(decode(greatest(task_status,99),99,0,1)) ',
'                / count(*))',
'                )||''%'' pct_complete,',
'               count(*) total_count,',
'               sum(decode(task_status,100,0,0,0,1)) partially_complete',
'               --sum(decode(task_status,null,1,0,1,0)) no_progress',
'  from wwv_flow_tasks t',
'  where t.security_group_id = :FLOW_SECURITY_GROUP_ID  and',
'    (nvl(:P3001_RELEASE,''0'') = ''0'' or release = :P3001_RELEASE) and',
'    (   nvl(:P3001_DEVELOPER,''ALL'') = ''ALL'' or',
'        nvl(:P3001_DEVELOPER,''0'') = ''0'' or',
'        lower(:P3001_DEVELOPER) =  lower(assigned_to)',
'    ) and',
' (',
' nvl(:P3001_SHOW,''ALL'') = ''ALL'' or',
' (nvl(:P3001_SHOW,''ALL'') = ''OPEN'' and task_status != 100 ) or',
' (nvl(:P3001_SHOW,''ALL'') = ''COMPLETED'' and task_status = 100) ) and',
' (nvl(:P3001_APPLICATION,0) = 0 or application_id = :P3001_APPLICATION)'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_tasks',
'where security_group_id = :flow_security_group_id'))
,p_display_condition_type=>'EXISTS'
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(389146768272330380.4806)
,p_query_num_rows=>10
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\62A5\8868\4E2D\4E0D\5305\542B\6570\636E')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>10
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(673337434921771559.4806)
,p_plug_column_width=>'apex-col--leftBorder apex-col--bottomBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(673339299969794144.4806)
,p_query_column_id=>1
,p_column_alias=>'OPEN'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\672A\5B8C\6210')
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.:3000,RIR:IREQ_IS_OPEN:Yes'
,p_column_linktext=>'#OPEN#'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(673340037972814594.4806)
,p_query_column_id=>2
,p_column_alias=>'PCT_COMPLETE'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\5B8C\6210')
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.:3000,RIR:IREQ_IS_OPEN:Yes'
,p_column_linktext=>'#PCT_COMPLETE#'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(673339569160794144.4806)
,p_query_column_id=>3
,p_column_alias=>'TOTAL_COUNT'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\603B\8BA1')
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.:3000,RIR::'
,p_column_linktext=>'#TOTAL_COUNT#'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(673339606615794144.4806)
,p_query_column_id=>4
,p_column_alias=>'PARTIALLY_COMPLETE'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\90E8\5206\5B8C\6210')
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.:3000,RIR:IREQ_IS_OPEN,IRGT_PCT_COMPLETE:Yes,0'
,p_column_linktext=>'#PARTIALLY_COMPLETE#'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(703041543557276832.4806)
,p_plug_name=>unistr('\5B9E\7528\7A0B\5E8F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(181214517334339823.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
,p_plug_column_width=>' '
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(703042153785286965.4806)
,p_plug_name=>unistr('\5173\4E8E')
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>\5F85\529E\4E8B\9879\8DDF\8E2A\5DE5\4F5C\5206\914D\800C\975E\529F\80FD\3002\5F85\529E\4E8B\9879\53EF\4E0E\529F\80FD\548C\91CC\7A0B\7891\76F8\5173\8054\4EE5\5B9A\4E49\9700\8981\5B8C\6210\7684\4EFB\52A1\3002\5F85\529E\4E8B\9879\53EF\6309\53D1\884C\7248\8FDB\884C\7EC4\7EC7, \5206\914D\7ED9\5F00\53D1\8005, \4EE5\53CA\8FDB\884C\6807\8BB0\3002</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_column_width=>' '
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180355816578182365.4806)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(180288936103337605.4806)
,p_button_name=>'P3001_GO'
,p_button_static_id=>'P3001_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\8BBE\7F6E')
,p_button_position=>'BODY'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180619532505704260.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(180288936103337605.4806)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:3001:&SESSION.::&DEBUG.:3001::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180289128323337606.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(180288936103337605.4806)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404891952915809007.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\521B\5EFA\5F85\529E\4E8B\9879')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:3010::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(180355630992177105.4806)
,p_branch_action=>'f?p=&APP_ID.:3001:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(176687111686805437.4806)
,p_name=>'P3001_APPLICATION'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(180288936103337605.4806)
,p_prompt=>unistr('\5E94\7528\7A0B\5E8F')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TO DO DISTINCT APP NAME RETURNING ID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||''. ''||f.name d, f.id r',
'from (',
'select distinct application_id d, application_id r',
'from wwv_flow_tasks t',
'where application_id is not null and ',
't.security_group_id = :flow_security_group_id',
') d,',
'wwv_flows f',
'where f.id = d.d and ',
'f.security_group_id = :flow_security_group_id',
'order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \5168\90E8 -')
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5C06\62A5\8868\9650\5236\4E3A\4EC5\663E\793A\4E0E\6240\9009\5E94\7528\7A0B\5E8F\5173\8054\7684\5F85\529E\4E8B\9879\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180352818001135458.4806)
,p_name=>'P3001_SHOW'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(180288936103337605.4806)
,p_item_default=>'ALL'
,p_prompt=>unistr('\663E\793A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'OPEN TASKS, ALL TASKS'
,p_lov=>'.'||wwv_flow_api.id(180353541681151738.4806)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6807\8BC6\8981\663E\793A\7684\5F85\529E\4E8B\9879\3002\672A\5B8C\6210\5F85\529E\4E8B\9879\7684\5B8C\6210\767E\5206\6BD4\4F4E\4E8E 100%\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180359224431326568.4806)
,p_name=>'P3001_RELEASE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(180288936103337605.4806)
,p_item_default=>'0'
,p_prompt=>unistr('\53D1\884C\7248')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \5168\90E8 -')
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5C06\62A5\8868\9650\5236\4E3A\7279\5B9A\53D1\884C\7248, \6216\8005\663E\793A\6240\6709\53D1\884C\7248\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(182496338483461111.4806)
,p_name=>'P3001_DEVELOPER'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(180288936103337605.4806)
,p_prompt=>unistr('\5206\914D\4EBA\5458')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'OWNER - TASKS, ASSIGNED TO (TODO, MILESTONES, FEATURES, BUGS)'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lower(user_name) d, lower(user_name) r ',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'union',
'select lower(d) d, lower(r) r from (',
'    select distinct assigned_to d, assigned_to r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and ',
'         assigned_to is not null',
'    union',
'    select distinct CONTRIBUTOR d, CONTRIBUTOR r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and CONTRIBUTOR is not null',
'    union',
'    select distinct EVENT_OWNER d, EVENT_OWNER r ',
'    from wwv_flow_events ',
'    where security_group_id = :flow_security_group_id and ',
'          event_owner is not null',
'    union',
'    select distinct feature_OWNER d, feature_OWNER r ',
'    from wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_owner is not null',
'    union ',
'    select distinct feature_contributor d, feature_contributor r ',
'    from  wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_contributor is not null',
'    union',
'    select distinct assigned_to d, assigned_to r ',
'    from wwv_flow_bugs',
'    where security_group_id = :flow_security_group_id and ',
'          assigned_to is not null',
') ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \5168\90E8 -')
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\67E5\770B\6240\6709\5F85\529E\4E8B\9879, \6216\4EC5\67E5\770B\4E0E\7279\5B9A\5206\914D\4EBA\5458\5173\8054\7684\5F85\529E\4E8B\9879\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(180619241724697441.4806)
,p_computation_sequence=>10
,p_computation_item=>'P3001_RELEASE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select max(default_release) r',
'from wwv_flow_task_defaults',
'where security_group_id = :flow_security_group_id'))
,p_compute_when=>'P3001_RELEASE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(825404805669325697.4806)
,p_computation_sequence=>20
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'3001'
);
end;
/
prompt --application/pages/page_03002
begin
wwv_flow_api.create_page(
 p_id=>3002.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\5F85\529E\4E8B\9879\8FDB\5EA6\65E5\5FD7')
,p_step_title=>unistr('\5F85\529E\4E8B\9879\8FDB\5EA6\65E5\5FD7')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(637441482420448238.4806)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'td_todo_repts.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(181604326642957241.4806)
,p_plug_name=>'To Do tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(180244521254945294.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(182442550749490978.4806)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(181606515516983061.4806)
,p_plug_name=>unistr('\8FDB\5EA6\65E5\5FD7')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(678363858364331062.4806)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select progress_note progress_log_entry,',
'       p.CREATED_ON created,',
'       lower(p.created_by) created_by,',
'       t.id,',
'       t.TASK_NAME,',
'       lower(t.assigned_to) assigned_to,',
'       p.id progress_id',
'from WWV_FLOW_TASK_PROGRESS p,',
'     wwv_flow_tasks t',
'where t.security_group_id = :flow_security_group_id and',
'      t.id = p.task_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(181606635234983061.4806)
,p_name=>'Progress Log'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8BE2\8FD4\56DE\7684\884C\6570\8D85\8FC7\4E86 10,000, \8BF7\8FC7\6EE4\6570\636E\4EE5\786E\4FDD\83B7\5F97\5B8C\6574\7ED3\679C\3002')
,p_no_data_found_message=>unistr('\672A\627E\5230\6570\636E\3002')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181606821525983064.4806)
,p_db_column_name=>'PROGRESS_LOG_ENTRY'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\8FDB\5EA6\6761\76EE')
,p_column_link=>'f?p=&APP_ID.:3006:&SESSION.::&DEBUG.:3006:P3006_ID:#PROGRESS_ID#:'
,p_column_linktext=>'#PROGRESS_LOG_ENTRY#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181606921550983065.4806)
,p_db_column_name=>'CREATED'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\521B\5EFA')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181607028487983065.4806)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\521B\5EFA\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181607132660983065.4806)
,p_db_column_name=>'ID'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\5F85\529E\4E8B\9879')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181607635000988039.4806)
,p_db_column_name=>'TASK_NAME'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\5F85\529E\4E8B\9879')
,p_column_link=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:3010:P3010_ID:#ID#'
,p_column_linktext=>'#TASK_NAME#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181607737501988039.4806)
,p_db_column_name=>'ASSIGNED_TO'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('\5206\914D\4EBA\5458')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(174669100965893721.4806)
,p_db_column_name=>'PROGRESS_ID'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\8FDB\5EA6')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492891000549333483.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(181606515516983061.4806)
,p_button_name=>'RESET_REPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:3002:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(694446367339427536.4806)
,p_name=>'Handle Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(181606515516983061.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694446435163427537.4806)
,p_event_id=>wwv_flow_api.id(694446367339427536.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(181606515516983061.4806)
);
end;
/
prompt --application/pages/page_03005
begin
wwv_flow_api.create_page(
 p_id=>3005.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\5C0F\7EC4\5F00\53D1\8BBE\7F6E')
,p_step_title=>unistr('\5C0F\7EC4\5F00\53D1\8BBE\7F6E')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(389138863817227422.4806)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'td_util.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(177624518913816742.4806)
,p_plug_name=>unistr('\542F\7528\8DDF\8E2A\5C5E\6027')
,p_region_template_options=>'#DEFAULT#:a-Region--padded:u-Height:a-Region--defPosition:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>30
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'valign=top'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180307311495596014.4806)
,p_plug_name=>unistr('\5C0F\7EC4\5F00\53D1\8BBE\7F6E')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder:a-ButtonRegion--showTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180365229625678060.4806)
,p_plug_name=>unistr('\5DE5\4F5C\533A\5C0F\7EC4\5F00\53D1\8BBE\7F6E')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_header=>unistr('<p>\4EE5\4E0B\8BBE\7F6E\5C06\5E94\7528\4E8E\6B64\5DE5\4F5C\533A\7684\6240\6709\6210\5458\3002</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(185445714962904996.4806)
,p_plug_name=>unistr('\5173\4E8E')
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>\201C\5C0F\7EC4\5F00\53D1\8BBE\7F6E\201D\7279\5B9A\4E8E\5DE5\4F5C\533A, \800C\4E0D\662F\7279\5B9A\4E8E\6BCF\4E2A\5F00\53D1\8005\3002</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(450790416631049005.4806)
,p_plug_name=>unistr('\9ED8\8BA4\503C')
,p_region_template_options=>'#DEFAULT#:a-Region--padded:u-Height:a-Region--defPosition:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>25
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(694456967726497514.4806)
,p_plug_name=>unistr('\5B9E\7528\7A0B\5E8F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(181214517334339823.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180363540435586651.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(180307311495596014.4806)
,p_button_name=>'reset_defaults'
,p_button_action=>'SUBMIT'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E\4E3A\9ED8\8BA4\503C')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180363714234586651.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(180307311495596014.4806)
,p_button_name=>'set_preferences'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5E94\7528\66F4\6539')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(180446622942960690.4806)
,p_branch_action=>'f?p=&APP_ID.:&F4800_LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(176631229069523092.4806)
,p_name=>'P3005_SHOW_ALL_OR_OPEN'
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(180365229625678060.4806)
,p_use_cache_before_default=>'NO'
,p_item_default=>'ALL'
,p_prompt=>unistr('\663E\793A')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select SHOW_ALL_OR_OPEN',
'from wwv_flow_task_defaults ',
'where security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'P3005 - ALL, OPEN, COMPLETED'
,p_lov=>'.'||wwv_flow_api.id(176631412923527964.4806)||'.'
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9009\62E9\9996\9009\9879 -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\786E\5B9A\9ED8\8BA4\663E\793A\7684 Bug \548C\5F85\529E\4E8B\9879\7684\7C7B\578B\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180365613826683039.4806)
,p_name=>'P3005_DEFAULT_RELEASE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(450790416631049005.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\53D1\884C\7248')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select default_release ',
'from wwv_flow_task_defaults ',
'where security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \65E0\9ED8\8BA4\8BBE\7F6E -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\521B\5EFA\65B0\4EFB\52A1\65F6\4F7F\7528\6B64\9ED8\8BA4\53D1\884C\7248\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180365835713683040.4806)
,p_name=>'P3005_DEFAULT_ASSIGNEE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(450790416631049005.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\6240\6709\8005')
,p_source=>'select default_assignee from wwv_flow_task_defaults where security_group_id = :flow_security_group_id'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'OWNER - TASKS, ASSIGNED TO (TODO, MILESTONES, FEATURES, BUGS)'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lower(user_name) d, lower(user_name) r ',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'union',
'select lower(d) d, lower(r) r from (',
'    select distinct assigned_to d, assigned_to r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and ',
'         assigned_to is not null',
'    union',
'    select distinct CONTRIBUTOR d, CONTRIBUTOR r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and CONTRIBUTOR is not null',
'    union',
'    select distinct EVENT_OWNER d, EVENT_OWNER r ',
'    from wwv_flow_events ',
'    where security_group_id = :flow_security_group_id and ',
'          event_owner is not null',
'    union',
'    select distinct feature_OWNER d, feature_OWNER r ',
'    from wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_owner is not null',
'    union ',
'    select distinct feature_contributor d, feature_contributor r ',
'    from  wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_contributor is not null',
'    union',
'    select distinct assigned_to d, assigned_to r ',
'    from wwv_flow_bugs',
'    where security_group_id = :flow_security_group_id and ',
'          assigned_to is not null',
') ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \65E0\9ED8\8BA4\8BBE\7F6E -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\521B\5EFA\529F\80FD\548C\5F85\529E\4E8B\9879\65F6\4F7F\7528\9ED8\8BA4\503C\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180366239260683040.4806)
,p_name=>'P3005_DEFAULT_PRIORITY'
,p_data_type=>'NUMBER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(450790416631049005.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\4F18\5148\7EA7')
,p_source=>'select default_priority from wwv_flow_task_defaults where security_group_id = :flow_security_group_id'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FEATURE PRIORITY'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name d, id',
'from   wwv_flow_feature_priorities',
'order by id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \65E0\9ED8\8BA4\8BBE\7F6E -')
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\521B\5EFA\529F\80FD\65F6\4F7F\7528\9ED8\8BA4\4F18\5148\7EA7\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185433328665748049.4806)
,p_name=>'P3005_ENABLE_FEATURE_UI_YN'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(177624518913816742.4806)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\7528\6237\754C\9762')
,p_source=>'P3005_ENABLE_FEATURE_UI_YN'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\542F\7528\6216\7981\7528\529F\80FD\6A21\5757\5185\7684\7528\6237\754C\9762\8DDF\8E2A\3002')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185433613558753206.4806)
,p_name=>'P3005_ENABLE_FEATURE_TEST_YN'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(177624518913816742.4806)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\6D4B\8BD5')
,p_source=>'P3005_ENABLE_FEATURE_TEST_YN'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5728\201C\529F\80FD\201D\4E2D\542F\7528\6216\7981\7528\6D4B\8BD5\8DDF\8E2A\3002\9009\62E9<b>\7981\7528</b>\5C06\9690\85CF\201C\529F\80FD\201D\9875\4E0A\7684\201C\6D4B\8BD5\201D\533A\6BB5\3002')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185433821870755558.4806)
,p_name=>'P3005_ENABLE_FEATURE_DOC_YN'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(177624518913816742.4806)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\6587\6863')
,p_source=>'P3005_ENABLE_FEATURE_DOC_YN'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5728\201C\529F\80FD\201D\4E2D\542F\7528\6216\7981\7528\6587\6863\8DDF\8E2A\3002\9009\62E9<b>\7981\7528</b>\5C06\9690\85CF\201C\529F\80FD\201D\9875\4E0A\7684\201C\6587\6863\201D\533A\6BB5\3002')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185434031912758485.4806)
,p_name=>'P3005_ENABLE_FEATURE_GLOB_YN'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(177624518913816742.4806)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\5168\7403\5316')
,p_source=>'P3005_ENABLE_FEATURE_GLOB_YN'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\542F\7528\6216\7981\7528\529F\80FD\5185\7684\5168\7403\5316\8DDF\8E2A\3002')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185434206071760468.4806)
,p_name=>'P3005_ENABLE_FEATURE_SEC_YN'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(177624518913816742.4806)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\5B89\5168\6027')
,p_source=>'P3005_ENABLE_FEATURE_SEC_YN'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\542F\7528\6216\7981\7528\529F\80FD\5185\7684\5B89\5168\6027\8DDF\8E2A\3002')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185434415075763123.4806)
,p_name=>'P3005_ENABLE_FEATURE_ACC_YN'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(177624518913816742.4806)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\53EF\8BBF\95EE\6027')
,p_source=>'P3005_ENABLE_FEATURE_ACC_YN'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\542F\7528\6216\7981\7528\529F\80FD\6A21\5757\5185\7684\53EF\8BBF\95EE\6027\8DDF\8E2A\3002')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(180446731599963227.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set defaults'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'delete from wwv_flow_task_defaults where security_group_id = :flow_security_group_id;',
'',
'insert into wwv_flow_task_defaults (',
'    default_release,',
'    default_assignee,',
'    default_priority,',
'    show_all_or_open,',
'    --',
'    enable_feature_ui_yn,',
'    enable_feature_test_yn,',
'    enable_feature_doc_yn,',
'    enable_feature_glob_yn,',
'    enable_feature_sec_yn,',
'    enable_feature_acc_yn',
'    )',
'    values (',
'    replace(:P3005_DEFAULT_RELEASE,''%''||''null%'',null),',
'    replace(:P3005_DEFAULT_ASSIGNEE,''%''||''null%'',null),',
'    replace(:P3005_DEFAULT_PRIORITY,''%''||''null%'',null),',
'    replace(:P3005_SHOW_ALL_OR_OPEN,''%''||''null%'',null),',
'    --',
'    replace(:P3005_ENABLE_FEATURE_UI_YN,''%''||''null%'',null),',
'    replace(:P3005_ENABLE_FEATURE_TEST_YN,''%''||''null%'',null),',
'    replace(:P3005_ENABLE_FEATURE_DOC_YN,''%''||''null%'',null),',
'    replace(:P3005_ENABLE_FEATURE_GLOB_YN,''%''||''null%'',null),',
'    replace(:P3005_ENABLE_FEATURE_SEC_YN,''%''||''null%'',null),',
'    replace(:P3005_ENABLE_FEATURE_ACC_YN,''%''||''null%'',null)',
'    );',
'    ',
'commit;'))
,p_process_when_button_id=>wwv_flow_api.id(180363714234586651.4806)
,p_process_success_message=>unistr('\9ED8\8BA4\503C\5DF2\5E94\7528\4E8E\5F53\524D\5DE5\4F5C\7EC4\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(180621325672758985.4806)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'reset task defaults'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'delete from wwv_flow_task_defaults where security_group_id = :flow_security_group_id;',
'commit;'))
,p_process_when_button_id=>wwv_flow_api.id(180363540435586651.4806)
,p_process_success_message=>unistr('\5DF2\91CD\7F6E\5C0F\7EC4\5F00\53D1\8BBE\7F6E\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(695774428850932083.4806)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set preference'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'     l_status boolean := false;',
'begin',
'for c1 in (',
'select   ',
'    default_release,',
'    default_assignee,',
'    default_priority,',
'    show_all_or_open,',
'    nvl(enable_feature_ui_yn,''N'') enable_feature_ui_yn,',
'    nvl(enable_feature_test_yn,''N'') enable_feature_test_yn,',
'    nvl(enable_feature_doc_yn,''N'') enable_feature_doc_yn,',
'    nvl(enable_feature_glob_yn,''N'') enable_feature_glob_yn,',
'    nvl(enable_feature_sec_yn,''N'') enable_feature_sec_yn,',
'    nvl(enable_feature_acc_yn,''N'') enable_feature_acc_yn',
'from wwv_flow_task_defaults where security_group_id = :flow_security_group_id )',
'loop',
'l_status := true;',
':P3005_ENABLE_FEATURE_UI_YN := c1.enable_feature_ui_yn;',
':P3005_ENABLE_FEATURE_TEST_YN := c1.enable_feature_test_yn;',
':P3005_ENABLE_FEATURE_DOC_YN := c1.enable_feature_doc_yn;',
':P3005_ENABLE_FEATURE_GLOB_YN := c1.enable_feature_glob_yn;',
':P3005_ENABLE_FEATURE_SEC_YN:= c1.enable_feature_sec_yn;',
':P3005_ENABLE_FEATURE_ACC_YN := c1.enable_feature_acc_yn;',
':P3005_DEFAULT_RELEASE := c1.default_release;',
':P3005_DEFAULT_ASSIGNEE := c1.default_assignee;',
':P3005_DEFAULT_PRIORITY := c1.default_priority;',
'',
'end loop;',
'if not l_status  then ',
'   :P3005_ENABLE_FEATURE_UI_YN := ''N'';',
'   :P3005_ENABLE_FEATURE_TEST_YN := ''N'';',
'   :P3005_ENABLE_FEATURE_DOC_YN := ''N'';',
'   :P3005_ENABLE_FEATURE_GLOB_YN := ''N'';',
'   :P3005_ENABLE_FEATURE_SEC_YN:= ''N'';',
'   :P3005_ENABLE_FEATURE_ACC_YN := ''N'';',
'end if;',
'end;'))
);
end;
/
prompt --application/pages/page_03006
begin
wwv_flow_api.create_page(
 p_id=>3006.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\8FDB\5EA6')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\8FDB\5EA6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'//-->',
'</script>'))
,p_step_template=>wwv_flow_api.id(694252054065447551.4806)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'350'
,p_dialog_width=>'620'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'td_util.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(174665226721882445.4806)
,p_plug_name=>unistr('\5F85\529E\4E8B\9879\8FDB\5EA6')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--noBorder:a-Region--hideHeader'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(694446190188427534.4806)
,p_plug_name=>unistr('\6309\94AE\680F')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(174665630646882446.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(694446190188427534.4806)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\5220\9664')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_condition=>'P3006_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(174665512892882446.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(694446190188427534.4806)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5E94\7528\66F4\6539')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P3006_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(174666612404882447.4806)
,p_name=>'P3006_ID'
,p_item_sequence=>1
,p_item_plug_id=>wwv_flow_api.id(174665226721882445.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(174666831224882448.4806)
,p_name=>'P3006_TASK_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(174665226721882445.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5F85\529E\4E8B\9879:')
,p_source=>'TASK_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select task_name, id',
'from wwv_flow_tasks',
'where security_group_id = :flow_security_group_id and',
'      id = :P3006_TASK_ID'))
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(687909483370721160.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\76F8\5173\5F85\529E\4E8B\9879\3002')
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(174667005338882448.4806)
,p_name=>'P3006_PROGRESS_NOTE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(174665226721882445.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8FDB\5EA6\6CE8\91CA')
,p_source=>'PROGRESS_NOTE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(687909483370721160.4806)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('\8FDB\5EA6\7684\7B80\8981\8BF4\660E\3002')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(174667302804882448.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_TASK_PROGRESS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_TASK_PROGRESS'
,p_attribute_03=>'P3006_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_process_error_message=>unistr('\65E0\6CD5\63D0\53D6\884C\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(174667528108882450.4806)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_TASK_PROGRESS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_TASK_PROGRESS'
,p_attribute_03=>'P3006_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>unistr('\65E0\6CD5\5904\7406\8868 WWV_FLOW_TASK_PROGRESS \7684\884C\3002')
,p_process_success_message=>unistr('\64CD\4F5C\5DF2\5904\7406\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(174667711459882450.4806)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'3006'
,p_process_when_button_id=>wwv_flow_api.id(174665630646882446.4806)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(694446203949427535.4806)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_03009
begin
wwv_flow_api.create_page(
 p_id=>3009.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\590D\5236')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\590D\5236')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(694252054065447551.4806)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'260'
,p_dialog_width=>'550'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'td_todo.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180457426892046954.4806)
,p_plug_name=>unistr('\521B\5EFA\65B0\5F85\529E\4E8B\9879')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(694445879188427531.4806)
,p_plug_name=>unistr('\6309\94AE\680F')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180458215202050280.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(694445879188427531.4806)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\521B\5EFA\5F85\529E\4E8B\9879')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180458412825052362.4806)
,p_name=>'P3009_TASK_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(180457426892046954.4806)
,p_prompt=>unistr('\590D\5236\5230')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>50
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\5C06\4F5C\4E3A\526F\672C\521B\5EFA\7684\5F85\529E\4E8B\9879\7684\65B0\540D\79F0\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180473522885206647.4806)
,p_name=>'P3009_TASK_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(180457426892046954.4806)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180675832859480138.4806)
,p_name=>'P3009_COPY_TASK'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(180457426892046954.4806)
,p_prompt=>unistr('\590D\5236\81EA:')
,p_source=>'select task_name from wwv_flow_tasks where security_group_id = :flow_security_group_id and id = :P3009_TASK_ID'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6807\8BC6\8981\590D\5236\7684\5F85\529E\4E8B\9879\6761\76EE\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(180473928903217877.4806)
,p_validation_name=>'P3009_TASK_NAME Not Null'
,p_validation_sequence=>10
,p_validation=>'P3009_TASK_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\987B\6307\5B9A\503C\3002')
,p_associated_item=>wwv_flow_api.id(180458412825052362.4806)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
,p_validation_comment=>'generated 24-AUG-2009 08:48'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(180678324033515381.4806)
,p_validation_name=>'P3009_TASK_ID'
,p_validation_sequence=>20
,p_validation=>'P3009_TASK_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\672A\6307\5B9A\4EFB\52A1 ID\3002')
,p_when_button_pressed=>wwv_flow_api.id(180458215202050280.4806)
,p_associated_item=>wwv_flow_api.id(180473522885206647.4806)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(180459013995062131.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Copy Task'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'   select * ',
'   from wwv_flow_tasks ',
'   where security_group_id = :flow_security_group_id and ',
'         id = :P3009_TASK_ID) loop',
'   insert into wwv_flow_tasks (',
'    ASSIGNED_TO,',
'    CONTRIBUTOR,',
'    TASK_NAME,',
'    DESCRIPTION,',
'    TASK_STATUS,',
'    TASK_CATEGORY,',
'    TASK_TAGS,',
'    START_DATE,',
'    DATE_COMPLETED,',
'    APPLICATION_ID,',
'    CUSTOMER_DETAILS,',
'    PARENT_TASK_ID,',
'    TASK_GROUP,',
'    PAGE_ID,',
'    RELEASE,',
'    DUE_DATE,',
'    ESTIMATED_EFFORT_IN_HOURS)',
'    values (',
'    c1.ASSIGNED_TO,',
'    c1.CONTRIBUTOR,',
'    :P3009_TASK_NAME,',
'    c1.DESCRIPTION,',
'    c1.TASK_STATUS,',
'    c1.TASK_CATEGORY,',
'    c1.TASK_TAGS,',
'    c1.START_DATE,',
'    c1.DATE_COMPLETED,',
'    c1.APPLICATION_ID,',
'    c1.CUSTOMER_DETAILS,',
'    c1.PARENT_TASK_ID,',
'    c1.TASK_GROUP,',
'    c1.PAGE_ID,',
'    c1.RELEASE,',
'    c1.DUE_DATE,',
'    c1.ESTIMATED_EFFORT_IN_HOURS);',
'  exit;',
'end loop;'))
,p_process_when_button_id=>wwv_flow_api.id(180458215202050280.4806)
,p_process_success_message=>unistr('\4EFB\52A1\5DF2\4F5C\4E3A\73B0\6709\4EFB\52A1\7684\526F\672C\521B\5EFA\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(694445916452427532.4806)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_03010
begin
wwv_flow_api.create_page(
 p_id=>3010.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\5F85\529E\4E8B\9879')
,p_step_title=>unistr('\5F85\529E\4E8B\9879')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'//-->',
'</script>'))
,p_step_template=>wwv_flow_api.id(694251408051447516.4806)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'td_todo.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(46296621814679087.4806)
,p_plug_name=>unistr('\533A\57DF\663E\793A\9009\62E9\5668')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(55633532876175832.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(174648003324714646.4806)
,p_name=>unistr('\8FDB\5EA6')
,p_template=>wwv_flow_api.id(388361325811341773.4806)
,p_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id,',
'       substr(PROGRESS_NOTE,1,255)||',
'       '' (''||lower(created_by)||'') ''||',
'       apex_util.get_since(created_on) progress',
'from  WWV_FLOW_TASK_PROGRESS p',
'where security_group_id = :flow_security_group_id and',
'      task_id = :P3010_ID',
'order by created_on desc'))
,p_display_when_condition=>'P3010_ID'
,p_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(175129351466570091.4806)
,p_query_num_rows=>30
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\62A5\8868\4E2D\4E0D\5305\542B\6570\636E')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>30
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(174648322661714648.4806)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_column_heading=>'Id'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(174648425434714648.4806)
,p_query_column_id=>2
,p_column_alias=>'PROGRESS'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\8FDB\5EA6')
,p_column_link=>'f?p=&APP_ID.:3006:&SESSION.::&DEBUG.:RP,3006:P3006_ID:#ID#'
,p_column_linktext=>'#PROGRESS#'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180250831606980392.4806)
,p_plug_name=>unistr('\5176\4ED6\8BE6\7EC6\8D44\6599')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180260812523037340.4806)
,p_plug_name=>unistr('\5F85\529E\4E8B\9879: &P3010_FRIENDLY_ID.')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noUI:a-ButtonRegion--showTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>10
,p_plug_new_grid=>true
,p_plug_display_point=>'REGION_POSITION_04'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180261819364058303.4806)
,p_plug_name=>unistr('\8BE6\7EC6\8D44\6599')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180265633479081227.4806)
,p_plug_name=>unistr('\5E94\7528\7A0B\5E8F\4E0A\4E0B\6587')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180265912485084632.4806)
,p_plug_name=>unistr('\6807\8BB0')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180267939413111322.4806)
,p_plug_name=>unistr('\5F85\529E\4E8B\9879')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid=>true
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180456032377038002.4806)
,p_plug_name=>unistr('\64CD\4F5C')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>110
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(180455528493038000.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P3010_ID'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188487632041883370.4806)
,p_plug_name=>unistr('\5173\4E8E')
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>100
,p_plug_new_grid=>true
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>\5F85\529E\4E8B\9879\662F\53EF\4EE5\88AB\5206\914D, \6392\5217\4F18\5148\7EA7, \505A\6807\8BB0\548C\8DDF\8E2A\7684\64CD\4F5C\9879\3002\5F85\529E\4E8B\9879\53EF\4EE5\6709\5173\8054\7684\7236\5F85\529E\4E8B\9879\3002</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(314412218608391095.4806)
,p_name=>unistr('\6587\4EF6')
,p_template=>wwv_flow_api.id(388361325811341773.4806)
,p_display_sequence=>160
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'''<a class="attachment_link" href="''||wwv_flow_team_file.get_file_src(n001)||''" title="''||wwv_flow_escape.html(c005)||''">''||wwv_flow_escape.html(c002)||''</a>'' file_name, ',
'c003 mime_type,',
'c004 file_charset,',
'to_number(nvl(c008,''0'')) file_size,',
'd001 created, ',
'lower(c006) created_by,',
'case when instr(upper(c002),''.PPT'') > 0or instr(upper(c002),''.PPTX'') > 0 then',
'    ''presentation''',
'when instr(upper(c002),''.XLS'') > 0 or instr(upper(c002),''.XLSX'') > 0 then',
'    ''spreadsheet''',
'when instr(upper(c002),''.DOC'') > 0 or instr(upper(c002),''.DOCX'') > 0 then',
'    ''document''',
'when instr(upper(c002),''.PDF'') > 0 then',
'    ''pdf''',
'when instr(upper(c002),''.GIF'') > 0 or',
'     instr(upper(c002),''.PNG'') > 0 or',
'     instr(upper(c002),''.TIFF'') > 0 or',
'     instr(upper(c002),''.JPG'') > 0 then',
'    ''image''',
'else',
'    ''generic''',
'end file_type',
'from wwv_flow_collections',
'where c001 = ''TODO''',
'order by d001 desc'))
,p_required_role=>wwv_flow_api.id(323649802527269223)
,p_display_when_condition=>'P3010_ID'
,p_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(5574228712665954.4806)
,p_query_num_rows=>50
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_no_data_found=>unistr('\672A\627E\5230\6587\4EF6\3002')
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image=>'apex/builder/dup.gif'
,p_query_asc_image_attr=>'width="16" height="16" alt="" '
,p_query_desc_image=>'apex/builder/ddown.gif'
,p_query_desc_image_attr=>'width="16" height="16" alt="" '
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(319154022850421626.4806)
,p_query_column_id=>1
,p_column_alias=>'FILE_NAME'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\540D\79F0')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(314412706963391098.4806)
,p_query_column_id=>2
,p_column_alias=>'MIME_TYPE'
,p_column_display_sequence=>6
,p_column_heading=>'Mime Type'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(319154128594421627.4806)
,p_query_column_id=>3
,p_column_alias=>'FILE_CHARSET'
,p_column_display_sequence=>7
,p_column_heading=>'File Charset'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(314412616597391098.4806)
,p_query_column_id=>4
,p_column_alias=>'FILE_SIZE'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\5927\5C0F')
,p_use_as_row_header=>'N'
,p_column_format=>'FILESIZE'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(314412816482391098.4806)
,p_query_column_id=>5
,p_column_alias=>'CREATED'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\6DFB\52A0\65E5\671F')
,p_use_as_row_header=>'N'
,p_column_format=>'SINCE'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(314412904863391098.4806)
,p_query_column_id=>6
,p_column_alias=>'CREATED_BY'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\6DFB\52A0\8005')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(322193315462473067.4806)
,p_query_column_id=>7
,p_column_alias=>'FILE_TYPE'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_column_html_expression=>'<img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMini #FILE_TYPE#" />'
,p_column_alignment=>'CENTER'
,p_lov_show_nulls=>'NO'
,p_report_column_width=>16
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(450299811907164206.4806)
,p_plug_name=>unistr('\65E5\671F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180251409624980394.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(180260812523037340.4806)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4800_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180251215601980394.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(180260812523037340.4806)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\5220\9664')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'javascript:confirmDelete(htmldb_delete_message,''DELETE'');'
,p_button_condition=>'P3010_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180251140878980394.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(180260812523037340.4806)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5E94\7528\66F4\6539')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P3010_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180251038206980394.4806)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(180260812523037340.4806)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\521B\5EFA\5F85\529E\4E8B\9879')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P3010_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(320390404908541265.4806)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(314412218608391095.4806)
,p_button_name=>'VIEW_FILES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\67E5\770B\548C\7BA1\7406\6587\4EF6')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:RP,10:P10_COMPONENT_ID:&P3010_ID.'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(180252027210980396.4806)
,p_branch_action=>'f?p=&APP_ID.:&F4800_LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(174602702080099294.4806)
,p_name=>'P3010_CREATED_BY'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(180267939413111322.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\521B\5EFA\8005:')
,p_post_element_text=>', &P3010_CREATED.'
,p_source=>'CREATED_BY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_css_classes=>'fielddatabold'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P3010_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6B64\5C5E\6027\5C06\81EA\52A8\7EF4\62A4\5E76\8DDF\8E2A\6B64\5F85\529E\4E8B\9879\64CD\4F5C\7684\521B\5EFA\8005\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(174610210055177282.4806)
,p_name=>'P3010_CREATED'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(180267939413111322.4806)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'   select created_on ',
'   from wwv_flow_tasks ',
'   where security_group_id = :flow_security_group_id and ',
'         id = :P3010_ID) loop',
'   return APEX_UTIL.GET_SINCE(c1.created_on);',
'end loop;',
'return null;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when=>'P3010_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6B64\5C5E\6027\5C06\81EA\52A8\7EF4\62A4\5E76\8DDF\8E2A\6B64\5F85\529E\4E8B\9879\64CD\4F5C\7684\521B\5EFA\65E5\671F\3002')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180252224569980400.4806)
,p_name=>'P3010_ID'
,p_item_sequence=>270
,p_item_plug_id=>wwv_flow_api.id(180250831606980392.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\552F\4E00\6807\8BC6\6B64\5F85\529E\4E8B\9879\64CD\4F5C\3002')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180252440747980415.4806)
,p_name=>'P3010_FRIENDLY_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(180260812523037340.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'FRIENDLY_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when=>'P3010_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6807\8BC6\4E00\4E2A\53CB\597D\7684\6807\8BC6\53F7\3002')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180252810296980416.4806)
,p_name=>'P3010_ASSIGNED_TO'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(180267939413111322.4806)
,p_use_cache_before_default=>'NO'
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P3010_ID is null then',
'  for c1 in (select DEFAULT_ASSIGNEE',
'             from   wwv_flow_task_defaults ',
'             where  security_group_id = :flow_security_group_id and',
'                    DEFAULT_ASSIGNEE is not null) loop',
'     return c1.DEFAULT_ASSIGNEE;',
'  end loop;',
'end if;',
'return null;'))
,p_item_default_type=>'PLSQL_FUNCTION_BODY'
,p_prompt=>unistr('\5206\914D\7ED9')
,p_source=>'ASSIGNED_TO'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'OWNER - TASKS, ASSIGNED TO (TODO, MILESTONES, FEATURES, BUGS)'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lower(user_name) d, lower(user_name) r ',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'union',
'select lower(d) d, lower(r) r from (',
'    select distinct assigned_to d, assigned_to r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and ',
'         assigned_to is not null',
'    union',
'    select distinct CONTRIBUTOR d, CONTRIBUTOR r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and CONTRIBUTOR is not null',
'    union',
'    select distinct EVENT_OWNER d, EVENT_OWNER r ',
'    from wwv_flow_events ',
'    where security_group_id = :flow_security_group_id and ',
'          event_owner is not null',
'    union',
'    select distinct feature_OWNER d, feature_OWNER r ',
'    from wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_owner is not null',
'    union ',
'    select distinct feature_contributor d, feature_contributor r ',
'    from  wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_contributor is not null',
'    union',
'    select distinct assigned_to d, assigned_to r ',
'    from wwv_flow_bugs',
'    where security_group_id = :flow_security_group_id and ',
'          assigned_to is not null',
') ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9009\62E9\5206\914D\4EBA\5458 -')
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8D1F\8D23\5B8C\6210\6B64\5F85\529E\4E8B\9879\7684\4EBA\5458\3002\8981\5411\6B64\5217\8868\6DFB\52A0\503C, \8BF7\5728\201C\65B0\7684\5206\914D\4EBA\5458\201D\4E2D\8F93\5165\4E00\4E2A\540D\79F0\3002'),
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180253009379980417.4806)
,p_name=>'P3010_CONTRIBUTOR'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(180267939413111322.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8D21\732E\8005')
,p_source=>'CONTRIBUTOR'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'OWNER - TASKS, ASSIGNED TO (TODO, MILESTONES, FEATURES, BUGS)'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lower(user_name) d, lower(user_name) r ',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'union',
'select lower(d) d, lower(r) r from (',
'    select distinct assigned_to d, assigned_to r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and ',
'         assigned_to is not null',
'    union',
'    select distinct CONTRIBUTOR d, CONTRIBUTOR r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and CONTRIBUTOR is not null',
'    union',
'    select distinct EVENT_OWNER d, EVENT_OWNER r ',
'    from wwv_flow_events ',
'    where security_group_id = :flow_security_group_id and ',
'          event_owner is not null',
'    union',
'    select distinct feature_OWNER d, feature_OWNER r ',
'    from wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_owner is not null',
'    union ',
'    select distinct feature_contributor d, feature_contributor r ',
'    from  wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_contributor is not null',
'    union',
'    select distinct assigned_to d, assigned_to r ',
'    from wwv_flow_bugs',
'    where security_group_id = :flow_security_group_id and ',
'          assigned_to is not null',
') ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9009\62E9\8D21\732E\8005 -')
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\534F\52A9\5B8C\6210\6B64\5F85\529E\4E8B\9879\7684\4EBA\5458\3002\8981\5411\6B64\5217\8868\6DFB\52A0\503C, \8BF7\5728\201C\65B0\8D21\732E\8005\201D\5B57\6BB5\4E2D\8F93\5165\4E00\4E2A\540D\79F0\3002'),
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180253238251980417.4806)
,p_name=>'P3010_TASK_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(180267939413111322.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5F85\529E\4E8B\9879\64CD\4F5C')
,p_source=>'TASK_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>70
,p_cMaxlength=>255
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444999901719038.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\5F85\529E\4E8B\9879\7684\540D\79F0\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180253636228980423.4806)
,p_name=>'P3010_DESCRIPTION'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(180261819364058303.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8BF4\660E')
,p_source=>'DESCRIPTION'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>8
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180253811988980423.4806)
,p_name=>'P3010_TASK_STATUS'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(180267939413111322.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\72B6\6001')
,p_source=>'TASK_STATUS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TASK STATUS (TO DO)'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select status_name ||'' - ''||pct_complete||''%'' d, pct_complete r',
'from wwv_flow_task_def_status_codes',
'order by pct_complete'))
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6807\8BC6\5F85\529E\4E8B\9879\72B6\6001\3002\72B6\6001\8868\793A\5B8C\6210\767E\5206\6BD4\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180254034980980423.4806)
,p_name=>'P3010_TASK_CATEGORY'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(180261819364058303.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\7C7B\522B')
,p_source=>'TASK_CATEGORY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TASK CATEGORY'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct task_category, task_category r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9009\62E9\7C7B\522B -')
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8981\66F4\597D\5730\7EC4\7EC7\5F85\529E\4E8B\9879\64CD\4F5C, \8BF7\5BF9\5176\8FDB\884C\5206\7C7B\3002\9009\62E9\4E00\4E2A\7C7B\522B\3002\8981\5411\6B64\5217\8868\6DFB\52A0\503C, \8BF7\5728\201C\65B0\7C7B\522B\201D\5B57\6BB5\4E2D\8F93\5165\4E00\4E2A\540D\79F0\3002'),
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180254212432980424.4806)
,p_name=>'P3010_TASK_TAGS'
,p_item_sequence=>260
,p_item_plug_id=>wwv_flow_api.id(180265912485084632.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\6807\8BB0')
,p_source=>'TASK_TAGS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct tag as d',
'  from wwv_flow_team_tags',
' where security_group_id = to_number(:WORKSPACE_ID)',
' order by 1'))
,p_lov_display_null=>'YES'
,p_cSize=>78
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6807\8BB0\662F\8FDB\4E00\6B65\8BF4\660E\6B64\529F\80FD\7684\5173\952E\5B57\3002\4F7F\7528\9017\53F7\5206\9694\591A\4E2A\6807\8BB0\3002'),
unistr('\6807\8BB0\663E\793A\5728\201C\62A5\8868\201D\89C6\56FE\7684\5355\72EC\7684\5217\4E2D\3002')))
,p_attribute_01=>'POPUP'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_03=>'Y'
,p_attribute_04=>'Y'
,p_attribute_05=>'Y'
,p_attribute_06=>'0'
,p_attribute_11=>','
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180254631262980424.4806)
,p_name=>'P3010_DATE_COMPLETED'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(450299811907164206.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5B8C\6210\65E5\671F')
,p_source=>'DATE_COMPLETED'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DATE_PICKER'
,p_cSize=>30
,p_cMaxlength=>255
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6807\8BC6\6B64\5F85\529E\4E8B\9879\64CD\4F5C\7684\5B9E\9645\5B8C\6210\65E5\671F\3002')
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180255014886980425.4806)
,p_name=>'P3010_APPLICATION_ID'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(180265633479081227.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5E94\7528\7A0B\5E8F')
,p_source=>'APPLICATION_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'APPLICATION NAME RETURNING ID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'from   wwv_flows f',
'where  ',
'       security_group_id = :flow_security_group_id and',
'       not exists (',
'       select null from wwv_flow_language_map',
'       where translation_flow_id = f.id and ',
'         security_group_id = :flow_security_group_id) and',
'       (',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :app_user and ',
'             flow_id is null and ',
'             security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :app_user and ',
'             flow_id = f.id and ',
'             security_group_id = :flow_security_group_id ))'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \65E0\5E94\7528\7A0B\5E8F -')
,p_cSize=>70
,p_cMaxlength=>255
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\76F8\5173\5E94\7528\7A0B\5E8F\3002')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180255228289980425.4806)
,p_name=>'P3010_WEBSHEET_ID'
,p_item_sequence=>280
,p_item_plug_id=>wwv_flow_api.id(180250831606980392.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'WEBSHEET_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180255427626980425.4806)
,p_name=>'P3010_REF_COMPONENT_TYPE'
,p_item_sequence=>290
,p_item_plug_id=>wwv_flow_api.id(180250831606980392.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'REF_COMPONENT_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180255830505980427.4806)
,p_name=>'P3010_PARENT_TASK_ID'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(180267939413111322.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\7236\5F85\529E\4E8B\9879')
,p_source=>'PARENT_TASK_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select task_name d, ',
'       id r',
'  from wwv_flow_tasks',
' where security_group_id = to_number(:WORKSPACE_ID)',
' order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \65E0\7236\7EA7 -')
,p_cSize=>60
,p_cMaxlength=>255
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6807\8BC6\7236\5F85\529E\4E8B\9879\3002')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180256024196980427.4806)
,p_name=>'P3010_TASK_GROUP'
,p_item_sequence=>300
,p_item_plug_id=>wwv_flow_api.id(180250831606980392.4806)
,p_use_cache_before_default=>'NO'
,p_source=>'TASK_GROUP'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180312741814761076.4806)
,p_name=>'P3010_PAGE_ID'
,p_item_sequence=>250
,p_item_plug_id=>wwv_flow_api.id(180265633479081227.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9875')
,p_source=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'  from wwv_flow_steps',
' where security_group_id = :flow_security_group_id and ',
'    FLOW_ID = :P3010_APPLICATION_ID',
' order by id'))
,p_lov_display_null=>'YES'
,p_lov_cascade_parent_items=>'P3010_APPLICATION_ID'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5C06\6B64\5F85\529E\4E8B\9879\4E0E\9875\7801\5173\8054\3002')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_03=>'N'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180320228756239766.4806)
,p_name=>'P3010_NEW_CATEGORY'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(180261819364058303.4806)
,p_prompt=>unistr('\65B0\5EFA\7C7B\522B')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6DFB\52A0\5728<b>\7C7B\522B</b>\9009\62E9\5217\8868\4E2D\4E0D\53EF\7528\7684\7C7B\522B\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180356212123209426.4806)
,p_name=>'P3010_RELEASE'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(180261819364058303.4806)
,p_use_cache_before_default=>'NO'
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'select max(default_release) r',
'from wwv_flow_task_defaults',
'where security_group_id = :flow_security_group_id) loop',
'return c1.r;',
'end loop;',
'return null;'))
,p_item_default_type=>'PLSQL_FUNCTION_BODY'
,p_prompt=>unistr('\53D1\884C\7248')
,p_source=>'RELEASE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9009\62E9\53D1\884C\7248 -')
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6B64\4EFB\52A1\5E94\5728\5176\4E2D\5B8C\6210\7684\53D1\884C\7248\3002\8981\5411\6B64\5217\8868\4E2D\6DFB\52A0\503C, \8BF7\5728\201C\65B0\53D1\884C\7248\201D\5B57\6BB5\4E2D\8F93\5165\4E00\4E2A\503C\3002'),
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180356413986219502.4806)
,p_name=>'P3010_NEW_RELEASE'
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(180261819364058303.4806)
,p_prompt=>unistr('\65B0\53D1\884C\7248')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6DFB\52A0\5728<b>\53D1\884C\7248</b>\9009\62E9\5217\8868\4E2D\4E0D\53EF\7528\7684\53D1\884C\7248\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180481935099266972.4806)
,p_name=>'P3010_DUE_DATE'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(450299811907164206.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\622A\6B62\65E5\671F')
,p_source=>'DUE_DATE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DATE_PICKER'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5E94\5B8C\6210\6B64\5F85\529E\4E8B\9879\7684\65E5\671F\3002')
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180620409911716679.4806)
,p_name=>'P3010_NEW_ASSIGNEE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(180267939413111322.4806)
,p_prompt=>unistr('\65B0\7684\5206\914D\4EBA\5458')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6DFB\52A0\5728<b>\5206\914D\7ED9</b>\9009\62E9\5217\8868\4E2D\4E0D\53EF\7528\7684\5206\914D\4EBA\5458\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180669529856987255.4806)
,p_name=>'P3010_NEW_CONTRIBUTOR'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(180267939413111322.4806)
,p_prompt=>unistr('\65B0\8D21\732E\8005')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6DFB\52A0\5728<b>\8D21\732E\8005</b>\9009\62E9\5217\8868\4E2D\4E0D\53EF\7528\7684\8D21\732E\8005\3002')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180679220402552201.4806)
,p_name=>'P3010_PROGRESS'
,p_item_sequence=>320
,p_item_plug_id=>wwv_flow_api.id(174648003324714646.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\6307\793A\6B64\4EFB\52A1\7684\8FDB\5EA6')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\8FDB\5EA6\7684\7B80\8981\8BF4\660E\3002')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180686020317921143.4806)
,p_name=>'P3010_ESTIMATED_EFFORT_IN_HRS'
,p_item_sequence=>310
,p_item_plug_id=>wwv_flow_api.id(180250831606980392.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\4F30\8BA1\5DE5\4F5C\91CF (\5C0F\65F6)')
,p_source=>'ESTIMATED_EFFORT_IN_HOURS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\8F93\5165\5B8C\6210\6B64\5F85\529E\4E8B\9879\7684\4F30\8BA1\7528\65F6 (\5C0F\65F6)\3002')
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180942133014584042.4806)
,p_name=>'P3010_EVENT_ID'
,p_item_sequence=>230
,p_item_plug_id=>wwv_flow_api.id(180261819364058303.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\91CC\7A0B\7891')
,p_source=>'EVENT_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select event_name||'' ''||event_date event_name, ',
'       id ',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id ',
'and (id = :P3010_EVENT_ID or nvl(SELECTABLE_FROM_FEATURES_YN,''Y'') = ''Y'')',
'and (release = :P3010_RELEASE or release is null)',
'order by event_date'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9009\62E9\91CC\7A0B\7891 -')
,p_lov_cascade_parent_items=>'P3010_RELEASE'
,p_ajax_optimize_refresh=>'N'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5E94\5B8C\6210\6B64\5F85\529E\4E8B\9879\7684\91CC\7A0B\7891\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(181322741631867907.4806)
,p_name=>'P3010_FEATURE_ID'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(180261819364058303.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\529F\80FD')
,p_source=>'FEATURE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'FEATURE, SELECT FEATURE NAME RETURNING ID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select feature_id||'' - ''||feature_name d, id r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id',
'order by feature_id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \6E05\9664 -')
,p_cSize=>70
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\4E0E\6B64\5F85\529E\4E8B\9879\5173\8054\7684\529F\80FD\3002')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(192798122026977058.4806)
,p_name=>'P3010_START_DATE'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(450299811907164206.4806)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5F00\59CB\65E5\671F')
,p_source=>'START_DATE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DATE_PICKER'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6B64\5F85\529E\4E8B\9879\7684\5F00\59CB\65E5\671F\3002')
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(180320523824257311.4806)
,p_computation_sequence=>10
,p_computation_item=>'P3010_TASK_CATEGORY'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P3010_NEW_CATEGORY is not null and nvl(replace(:P3010_TASK_CATEGORY,''%''||',
'   ''null%'',null),''0'') = ''0'' then',
'   return :P3010_NEW_CATEGORY;',
'elsif :P3010_TASK_CATEGORY is not null then',
'   return :P3010_TASK_CATEGORY;',
'else',
'   return null;',
'end if;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(180356631993224646.4806)
,p_computation_sequence=>20
,p_computation_item=>'P3010_RELEASE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P3010_NEW_RELEASE is not null then',
'   return :P3010_NEW_RELEASE;',
'elsif :P3010_RELEASE is not null then',
'   return :P3010_RELEASE;',
'else',
'   return null;',
'end if;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(180620812812726941.4806)
,p_computation_sequence=>30
,p_computation_item=>'P3010_ASSIGNED_TO'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P3010_NEW_ASSIGNEE is not null then',
'   return :P3010_NEW_ASSIGNEE;',
'elsif :P3010_ASSIGNED_TO is not null then',
'   return :P3010_ASSIGNED_TO;',
'else',
'   return null;',
'end if;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(180669824099995097.4806)
,p_computation_sequence=>40
,p_computation_item=>'P3010_CONTRIBUTOR'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P3010_NEW_CONTRIBUTOR is not null then',
'   return :P3010_NEW_CONTRIBUTOR;',
'else',
'   return :P3010_CONTRIBUTOR;',
'end if;'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(180253514512980418.4806)
,p_validation_name=>'P3010_TASK_NAME not null'
,p_validation_sequence=>10
,p_validation=>'P3010_TASK_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5F85\529E\4E8B\9879\64CD\4F5C\5FC5\987B\5177\6709\503C\3002')
,p_associated_item=>wwv_flow_api.id(180253238251980417.4806)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(192854723392176196.4806)
,p_validation_name=>'P3010_DATE_COMPLETED'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P3010_DATE_COMPLETED is not null and :P3010_TASK_STATUS != ''100'' then',
'return false;',
'else',
'return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\6761\76EE\5FC5\987B\8BBE\7F6E\4E3A 100% \5B8C\6210, \7136\540E\624D\80FD\8BBE\7F6E\5B8C\6210\65E5\671F\3002')
,p_when_button_pressed=>wwv_flow_api.id(180251140878980394.4806)
,p_associated_item=>wwv_flow_api.id(180254631262980424.4806)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1119687191403584516.4806)
,p_validation_name=>'P3010_PAGE_ID is numeric'
,p_validation_sequence=>30
,p_validation=>'P3010_PAGE_ID'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('#LABEL# \5FC5\987B\662F\6570\5B57\3002')
,p_validation_condition=>'P3010_PAGE_ID'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(180312741814761076.4806)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(694444131085427514.4806)
,p_name=>'Show/Hide New Category'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P3010_TASK_CATEGORY'
,p_condition_element=>'P3010_TASK_CATEGORY'
,p_triggering_condition_type=>'NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694444272988427515.4806)
,p_event_id=>wwv_flow_api.id(694444131085427514.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3010_NEW_CATEGORY'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694444385028427516.4806)
,p_event_id=>wwv_flow_api.id(694444131085427514.4806)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3010_NEW_CATEGORY'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(694444477969427517.4806)
,p_name=>'Show/Hide New Release'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P3010_RELEASE'
,p_condition_element=>'P3010_RELEASE'
,p_triggering_condition_type=>'NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694444515290427518.4806)
,p_event_id=>wwv_flow_api.id(694444477969427517.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3010_NEW_RELEASE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694444652306427519.4806)
,p_event_id=>wwv_flow_api.id(694444477969427517.4806)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3010_NEW_RELEASE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(694444882795427521.4806)
,p_name=>'Show/Hide New Assignee'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P3010_ASSIGNED_TO'
,p_condition_element=>'P3010_ASSIGNED_TO'
,p_triggering_condition_type=>'NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694444903147427522.4806)
,p_event_id=>wwv_flow_api.id(694444882795427521.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3010_NEW_ASSIGNEE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694445050361427523.4806)
,p_event_id=>wwv_flow_api.id(694444882795427521.4806)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3010_NEW_ASSIGNEE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(694445198515427524.4806)
,p_name=>'Show/Hide New Contributor'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P3010_CONTRIBUTOR'
,p_condition_element=>'P3010_CONTRIBUTOR'
,p_triggering_condition_type=>'NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694445288131427525.4806)
,p_event_id=>wwv_flow_api.id(694445198515427524.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3010_NEW_CONTRIBUTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(694445304449427526.4806)
,p_event_id=>wwv_flow_api.id(694445198515427524.4806)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3010_NEW_CONTRIBUTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1066789625154517706.4806)
,p_name=>'Submit Page on Create Dialog Close'
,p_event_sequence=>50
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(180456032377038002.4806)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1066789944241517710.4806)
,p_event_id=>wwv_flow_api.id(1066789625154517706.4806)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'location.reload();'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(180257110272980428.4806)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_TASKS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_TASKS'
,p_attribute_03=>'P3010_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_process_error_message=>unistr('\65E0\6CD5\63D0\53D6\884C\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(319152309786369393.4806)
,p_process_sequence=>50
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create file collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team_file.create_file_collection (',
'    p_component_id    => :P3010_ID);'))
,p_process_error_message=>unistr('\65E0\6CD5\521B\5EFA\6587\4EF6\96C6\5408\3002')
,p_process_when=>'P3010_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(180257329154980430.4806)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_TASKS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_TASKS'
,p_attribute_03=>'P3010_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>unistr('\65E0\6CD5\5904\7406\884C\3002')
,p_process_success_message=>unistr('\64CD\4F5C\5DF2\5904\7406\3002')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(180679321572561964.4806)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'log progress'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if trim(:P3010_PROGRESS) is not null then',
'insert into WWV_FLOW_TASK_PROGRESS',
'(',
'TASK_ID,',
'PROGRESS_NOTE)',
'values (',
':P3010_ID,',
'substr(:P3010_PROGRESS,1,4000));',
'end if;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(180257527862980431.4806)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'3010'
,p_process_when_button_id=>wwv_flow_api.id(180251215601980394.4806)
);
end;
/
prompt --application/pages/page_03013
begin
wwv_flow_api.create_page(
 p_id=>3013.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('\5F85\529E\4E8B\9879\65E5\5386')
,p_step_title=>unistr('\5F85\529E\4E8B\9879\65E5\5386')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(637441482420448238.4806)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'td_todo_repts.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(182638619923337992.4806)
,p_plug_name=>'tasks tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(180244521254945294.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(182442550749490978.4806)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(182638819526337993.4806)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(657005892103142107.4806)
,p_plug_name=>unistr('\5F85\529E\4E8B\9879')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* apex4800p3013a */',
'    assigned_to||'': ''||task_name task_name,',
'    nvl(date_completed,due_date) due_date,',
'    task_status,',
'    application_id,',
'    id,',
'    assigned_to,',
'    friendly_id',
'from wwv_flow_tasks t',
'where security_group_id = :flow_security_group_id and',
'    (nvl(:P3013_RELEASE,''0'') = ''0'' or release = :P3013_RELEASE) and',
'    (',
'    nvl(:P3013_SHOW,''ALL'') = ''ALL'' or ',
'    (nvl(:P3013_SHOW,''ALL'') = ''OPEN'' and task_status != 100 ) or',
'    (nvl(:P3013_SHOW,''ALL'') = ''COMPLETED'' and task_status = 100)',
'    )',
'and nvl(date_completed,due_date) is not null '))
,p_plug_source_type=>'NATIVE_CSS_CALENDAR'
,p_attribute_01=>'DUE_DATE'
,p_attribute_03=>'TASK_NAME'
,p_attribute_05=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:3010:P3010_ID:&ID.:'
,p_attribute_06=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:3010:::'
,p_attribute_07=>'N'
,p_attribute_09=>'month:list:navigation'
,p_attribute_13=>'N'
,p_attribute_16=>'&ASSIGNED_TO.'
,p_attribute_17=>'Y'
,p_attribute_19=>'N'
,p_attribute_21=>'10'
,p_attribute_22=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(182639025678337993.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(182638819526337993.4806)
,p_button_name=>'P3013_GO'
,p_button_static_id=>'P3013_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\8BBE\7F6E')
,p_button_position=>'BODY'
,p_button_execute_validations=>'N'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(189487819530580536.4806)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(182638819526337993.4806)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:3013:&SESSION.::&DEBUG.:3013::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(498556531967123785.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(182638819526337993.4806)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404891952915809007.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\521B\5EFA\5F85\529E\4E8B\9879')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:3010::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(182639925242337997.4806)
,p_branch_action=>'f?p=&APP_ID.:3013:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(182639220085337994.4806)
,p_name=>'P3013_RELEASE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(182638819526337993.4806)
,p_item_default=>'0'
,p_prompt=>unistr('\53D1\884C\7248')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \5168\90E8 -')
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\5C06\62A5\8868\9650\5B9A\4E8E\7ED9\5B9A\7684\53D1\884C\7248, \6216\663E\793A\6240\6709\53D1\884C\7248\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(182639422779337994.4806)
,p_name=>'P3013_SHOW'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(182638819526337993.4806)
,p_item_default=>'ALL'
,p_prompt=>unistr('\663E\793A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'OPEN TASKS, ALL TASKS'
,p_lov=>'.'||wwv_flow_api.id(180353541681151738.4806)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(487444889588719015.4806)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6807\8BC6\8981\663E\793A\7684\5F85\529E\4E8B\9879\3002\672A\5B8C\6210\5F85\529E\4E8B\9879\7684\5B8C\6210\767E\5206\6BD4\4F4E\4E8E 100%\3002')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(182668211951429581.4806)
,p_computation_sequence=>10
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'3013'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(189487224940572684.4806)
,p_computation_sequence=>20
,p_computation_item=>'P3013_RELEASE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select max(default_release) r',
'from wwv_flow_task_defaults',
'where security_group_id = :flow_security_group_id'))
,p_compute_when=>'P3013_RELEASE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
end;
/
prompt --application/pages/page_03500
begin
wwv_flow_api.create_page(
 p_id=>3500.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>'Bug'
,p_alias=>'BUGS'
,p_step_title=>'Bug'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(637441482420448238.4806)
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(181387521325174663.4806)
,p_plug_name=>'Bug Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(181386722752174658.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(182442550749490978.4806)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(181464628381683058.4806)
,p_plug_name=>'Bug'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_template=>wwv_flow_api.id(678363858364331062.4806)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  /* APEX4800P3500a */',
'    ID,',
'    ''f?p=''||:APP_ID||'':3502:''||:app_session||'':::3502:P3502_ID:''||id edit_link,',
'    application_id,',
'    page_id,',
'    BUG_ID,',
'    PRODUCT,',
'    PRODUCT_VERSION,',
'    ASSIGNED_TO,',
'    ''f?p=''||:APP_ID||'':3500:''||:app_session||''::::IR_ASSIGNED_TO:''||wwv_flow_escape.html(assigned_to) assigned_to_link,',
'    COMPONENT,',
'    BUG_SEVERITY,',
'    bug_severity bug_severity_display,',
'    nvl(bug_status,0) bug_status_code,',
'    nvl((select lpad(id,3,''000'')||''. ''||the_name ',
'     from WWV_FLOW_BUG_STATUS_CODES ',
'     where id = b.bug_status),''0. No Status'')',
'     BUG_STATUS,',
'    nvl(least(bug_status,100),0) bug_pct_complete,',
'    PRIORITY,',
'    FIX_BY_RELEASE,',
'    TAGS,',
'    decode(nvl(bug_status,0),100,ACTUAL_FIX_DATE, estimated_fix_date) ESTIMATED_FIX_DATE,',
'    ACTUAL_FIX_DATE,',
'    substr(bug_title,1,100) BUG_TITLE,',
'    BUG_DESCRIPTION,',
'    BUG_DESCRIPTION  BUG_DESCRIPTION_NO_ESC,',
'    REPORTED_PLATFORM,',
'    REPORTED_BROWSER,',
'    REPORTED_OPERATING_SYSTEM,',
'    FEATURE_ID,',
'    (select event_name from wwv_flow_events e where b.TARGET_MILESTONE_ID = e.id) milestone,',
'    TARGET_MILESTONE_ID,',
'    impact,',
'    TASK_ID,',
'    DUPLICATE_OF_BUG,',
'    CUSTOMER_NAME,',
'    CUSTOMER_ISSUE,',
'    lower(created_by) CREATED_BY,',
'    CREATED_ON,',
'    lower(updated_by) UPDATED_BY,',
'    UPDATED_ON',
'from WWV_FLOW_BUGS b',
'where security_group_id = :flow_security_group_id '))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(181464736218683058.4806)
,p_name=>'Bugs'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8BE2\8FD4\56DE\7684\884C\6570\8D85\8FC7\4E86 10,000, \8BF7\8FC7\6EE4\6570\636E\4EE5\786E\4FDD\83B7\5F97\5B8C\6574\7ED3\679C\3002')
,p_no_data_found_message=>unistr('\62A5\8868\4E2D\4E0D\5305\542B\6570\636E')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y_OF_Z'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181464920621683061.4806)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181465016587683061.4806)
,p_db_column_name=>'BUG_ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Bug'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181465217305683061.4806)
,p_db_column_name=>'PRODUCT_VERSION'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\7248\672C')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181465441215683062.4806)
,p_db_column_name=>'COMPONENT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('\7EC4\4EF6')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181465523033683062.4806)
,p_db_column_name=>'BUG_SEVERITY'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('Bug \4E25\91CD\6027')
,p_column_type=>'NUMBER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181465725361683062.4806)
,p_db_column_name=>'PRIORITY'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('\4F18\5148\7EA7')
,p_column_type=>'NUMBER'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_column_alignment=>'RIGHT'
,p_rpt_named_lov=>wwv_flow_api.id(177118604204266170)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181465810572683062.4806)
,p_db_column_name=>'FIX_BY_RELEASE'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('\53D1\884C\7248')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181465923340683062.4806)
,p_db_column_name=>'TAGS'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>unistr('\6807\8BB0')
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_column_type=>'STRING'
,p_rpt_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct tag',
'from  wwv_flow_team_tags',
'where security_group_id = :flow_security_group_id and',
'      tag_type = ''BUG''',
'order by 1'))
,p_rpt_show_filter_lov=>'C'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181466013838683063.4806)
,p_db_column_name=>'ESTIMATED_FIX_DATE'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>unistr('\4FEE\590D\5B8C\6210')
,p_column_type=>'DATE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181466109789683063.4806)
,p_db_column_name=>'ACTUAL_FIX_DATE'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>unistr('\5B9E\9645\4FEE\590D')
,p_column_type=>'DATE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181466224031683063.4806)
,p_db_column_name=>'BUG_TITLE'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>unistr('Bug \6807\9898')
,p_column_link=>'f?p=&APP_ID.:3502:&SESSION.::&DEBUG.:RP,3502:P3502_ID:#ID#:'
,p_column_linktext=>'#BUG_TITLE#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181466320861683063.4806)
,p_db_column_name=>'BUG_DESCRIPTION'
,p_display_order=>15
,p_column_identifier=>'O'
,p_column_label=>unistr('\8BF4\660E')
,p_allow_sorting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_column_type=>'CLOB'
,p_rpt_show_filter_lov=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181466418289683063.4806)
,p_db_column_name=>'REPORTED_PLATFORM'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>unistr('\5E73\53F0')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181466526618683064.4806)
,p_db_column_name=>'REPORTED_BROWSER'
,p_display_order=>17
,p_column_identifier=>'Q'
,p_column_label=>unistr('\6D4F\89C8\5668')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181466623442683064.4806)
,p_db_column_name=>'REPORTED_OPERATING_SYSTEM'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>unistr('\64CD\4F5C\7CFB\7EDF')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181466732869683064.4806)
,p_db_column_name=>'FEATURE_ID'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>unistr('\529F\80FD')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181466824215683065.4806)
,p_db_column_name=>'TARGET_MILESTONE_ID'
,p_display_order=>20
,p_column_identifier=>'T'
,p_column_label=>unistr('\6240\9009\91CC\7A0B\7891')
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181466911520683065.4806)
,p_db_column_name=>'TASK_ID'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('\4EFB\52A1')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181467012216683065.4806)
,p_db_column_name=>'DUPLICATE_OF_BUG'
,p_display_order=>22
,p_column_identifier=>'V'
,p_column_label=>unistr('\4E0E\4EE5\4E0B\9879\91CD\590D')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181467436389683065.4806)
,p_db_column_name=>'CUSTOMER_NAME'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('\5BA2\6237')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181467535920683066.4806)
,p_db_column_name=>'CUSTOMER_ISSUE'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>unistr('\5BA2\6237\95EE\9898')
,p_allow_sorting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_column_type=>'CLOB'
,p_rpt_show_filter_lov=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181467717992683066.4806)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>29
,p_column_identifier=>'AC'
,p_column_label=>unistr('\521B\5EFA\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181467837250683066.4806)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>30
,p_column_identifier=>'AD'
,p_column_label=>unistr('\521B\5EFA')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181467936720683066.4806)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>31
,p_column_identifier=>'AE'
,p_column_label=>unistr('\66F4\65B0\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181468020690683066.4806)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>32
,p_column_identifier=>'AF'
,p_column_label=>unistr('\66F4\65B0')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181854740334841774.4806)
,p_db_column_name=>'IMPACT'
,p_display_order=>33
,p_column_identifier=>'AG'
,p_column_label=>unistr('\5F71\54CD')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(182009724921192769.4806)
,p_db_column_name=>'BUG_STATUS'
,p_display_order=>34
,p_column_identifier=>'AH'
,p_column_label=>unistr('\72B6\6001')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(189646915723896096.4806)
,p_db_column_name=>'BUG_STATUS_CODE'
,p_display_order=>44
,p_column_identifier=>'AJ'
,p_column_label=>unistr('Bug \72B6\6001')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(177122327369320168.4806)
,p_db_column_name=>'BUG_PCT_COMPLETE'
,p_display_order=>54
,p_column_identifier=>'AI'
,p_column_label=>unistr('\5B8C\6210\767E\5206\6BD4')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(192146828973519826.4806)
,p_db_column_name=>'MILESTONE'
,p_display_order=>64
,p_column_identifier=>'AK'
,p_column_label=>unistr('\91CC\7A0B\7891')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(427348207310279970.4806)
,p_db_column_name=>'EDIT_LINK'
,p_display_order=>74
,p_column_identifier=>'AL'
,p_column_label=>unistr('\7F16\8F91 Bug')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(427348520254293156.4806)
,p_db_column_name=>'ASSIGNED_TO_LINK'
,p_display_order=>84
,p_column_identifier=>'AM'
,p_column_label=>unistr('\6240\6709\8005')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(428355816865964624.4806)
,p_db_column_name=>'BUG_DESCRIPTION_NO_ESC'
,p_display_order=>94
,p_column_identifier=>'AN'
,p_column_label=>unistr('Bug \8BF4\660E')
,p_column_type=>'CLOB'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(430415229957976625.4806)
,p_db_column_name=>'APPLICATION_ID'
,p_display_order=>104
,p_column_identifier=>'AO'
,p_column_label=>unistr('\5E94\7528\7A0B\5E8F')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(430415317090976628.4806)
,p_db_column_name=>'PAGE_ID'
,p_display_order=>114
,p_column_identifier=>'AP'
,p_column_label=>unistr('\9875')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(445364931429784460.4806)
,p_db_column_name=>'PRODUCT'
,p_display_order=>124
,p_column_identifier=>'AQ'
,p_column_label=>unistr('\4EA7\54C1')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1030035629059536808.4806)
,p_db_column_name=>'BUG_SEVERITY_DISPLAY'
,p_display_order=>134
,p_column_identifier=>'AR'
,p_column_label=>unistr('\4E25\91CD\6027')
,p_column_type=>'NUMBER'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_column_alignment=>'RIGHT'
,p_rpt_named_lov=>wwv_flow_api.id(181415542061549256)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(181465331837683061.4806)
,p_db_column_name=>'ASSIGNED_TO'
,p_display_order=>144
,p_column_identifier=>'E'
,p_column_label=>unistr('\5206\914D\4EBA\5458')
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(176433928312576150.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(181464628381683058.4806)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:3500:&SESSION.::&DEBUG.:3500,RIR::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(181388218035182742.4806)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(181464628381683058.4806)
,p_button_name=>'CREATE_BUG'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404891952915809007.4806)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\521B\5EFA Bug')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:3502:&SESSION.::&DEBUG.:3502::'
,p_icon_css_classes=>'icon-right-chevron'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(182009215046152109.4806)
,p_branch_action=>'f?p=&APP_ID.:3500:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(181478727497743678.4806)
,p_computation_sequence=>20
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'3500'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(427338307292128636.4806)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set release filter'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select default_release',
'           from wwv_flow_task_defaults',
'           where security_group_id = :flow_security_group_id ',
'           and default_release is not null ',
'           and default_release != ''0'')',
'loop',
'  wwv_flow_worksheet_api.add_filter_using_alias (',
'    p_page_id       => :app_page_id,',
'    p_report_column => ''FIX_BY_RELEASE'',',
'    p_filter_value  => c1.default_release,',
'    p_operator_abbr => ''EQ''',
'    );',
'end loop;'))
,p_process_when=>'DNSR'
,p_process_when_type=>'REQUEST_NOT_EQUAL_CONDITION'
);
end;
/
prompt --application/pages/page_03501
begin
wwv_flow_api.create_page(
 p_id=>3501.4806
,p_user_interface_id=>wwv_flow_api.id(4969129446302342.4806)
,p_name=>unistr('Bug \9762\677F')
,p_step_title=>unistr('Bug \9762\677F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(389138863817227422.4806)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'td_bug.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(178466506731553965.4806)
,p_plug_name=>unistr('\5173\4E8E')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>100
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Bug \8DDF\8E2A\8F6F\4EF6\7F3A\9677\3002Bug \53EF\4EE5\88AB\6307\5B9A, \4E0E\91CC\7A0B\7891\5173\8054, \4EE5\53CA\6309\622A\6B62\65E5\671F, \72B6\6001\548C\5C5E\6027\8FDB\884C\8DDF\8E2A\3002</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(181749217062998803.4806)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-Form--labelsAbove:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(690538778863811297.4806)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(181749940399004805.4806)
,p_plug_name=>unistr('Bug \9009\9879\5361')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388367750536343715.4806)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(181386722752174658.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(182442550749490978.4806)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(591375101297176118.4806)
,p_plug_name=>unistr('\4E25\91CD\6027')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:h320'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>91
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'NATIVE_JET_CHART'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_jet_chart(
 p_id=>wwv_flow_api.id(591375248709176119.4806)
,p_region_id=>wwv_flow_api.id(591375101297176118.4806)
,p_chart_type=>'donut'
,p_height=>'280'
,p_animation_on_display=>'none'
,p_animation_on_data_change=>'none'
,p_data_cursor=>'auto'
,p_data_cursor_behavior=>'auto'
,p_hide_and_show_behavior=>'none'
,p_hover_behavior=>'none'
,p_stack=>'off'
,p_stack_label=>'off'
,p_connect_nulls=>'Y'
,p_value_position=>'auto'
,p_value_format_type=>'decimal'
,p_value_decimal_places=>0
,p_value_format_scaling=>'auto'
,p_sorting=>'label-asc'
,p_fill_multi_series_gaps=>true
,p_tooltip_rendered=>'Y'
,p_show_series_name=>true
,p_show_group_name=>true
,p_show_value=>true
,p_show_label=>true
,p_show_row=>true
,p_show_start=>true
,p_show_end=>true
,p_show_progress=>true
,p_show_baseline=>true
,p_legend_rendered=>'on'
,p_legend_position=>'auto'
,p_overview_rendered=>'off'
,p_pie_other_threshold=>0
,p_pie_selection_effect=>'highlight'
,p_horizontal_grid=>'auto'
,p_vertical_grid=>'auto'
,p_gauge_orientation=>'circular'
,p_gauge_plot_area=>'on'
,p_show_gauge_value=>true
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(591375362371176120.4806)
,p_chart_id=>wwv_flow_api.id(591375248709176119.4806)
,p_seq=>10
,p_name=>unistr('\4E25\91CD\6027')
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P3501b2 */',
'      (select id||''. ''||the_name the_name',
'         from wwv_flow_bug_severity ',
'        where id = b.bug_severity) BUG_SEVERITY,',
'      count(*) the_count,',
'      bug_severity bug_severity_id,',
'      ''f?p=4800:3500:''||:APP_SESSION||'':::3500,RIR:IR_BUG_SEVERITY,IR_FIX_BY_RELEASE:''||',
'      BUG_SEVERITY||'',''||decode(:P3501_RELEASE,''ALL'',null,:P3501_RELEASE) the_link',
'from WWV_FLOW_BUGS b',
'where security_group_id = :flow_security_group_id and',
'      BUG_SEVERITY is not null and',
'     (nvl(:P3501_RELEASE,''ALL'') = ''ALL'' or fix_by_release = :P3501_RELEASE) and',
'     (',
'        nvl(:P3501_SHOW,''ALL'') = ''ALL'' or ',
'        (:P3501_SHOW = ''OPEN'' and bug_status < 100) or ',
'        (:P3501_SHOW = ''CLOSED'' and bug_status >= 100)',
'     )',
'group by BUG_SEVERITY',
'order by 2 desc'))
,p_items_value_column_name=>'THE_COUNT'
,p_items_label_column_name=>'BUG_SEVERITY'
,p_items_label_rendered=>true
,p_items_label_position=>'auto'
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
,p_link_target=>'&THE_LINK.'
,p_link_target_type=>'REDIRECT_URL'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(672755224596854203.4806)
,p_plug_name=>unistr('\5206\914D\4EBA\5458')
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--noPadding:h320'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>81
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P3501a2 */',
'  assigned_to,',
'  count(*) the_count,',
'  ''f?p=4800:3500:''||:APP_SESSION||',
'      '':::3500,RIR:IR_ASSIGNED_TO,IR_FIX_BY_RELEASE:''||',
'      assigned_to||'',''||decode(:P3501_RELEASE,''ALL'',null,:P3501_RELEASE) the_link',
'from WWV_FLOW_BUGS',
'where security_group_id = :flow_security_group_id and',
'      assigned_to is not null and',
'     (nvl(:P3501_RELEASE,''ALL'') = ''ALL'' or fix_by_release = :P3501_RELEASE) and',
'     (',
'        nvl(:P3501_SHOW,''ALL'') = ''ALL'' or ',
'        (:P3501_SHOW = ''OPEN'' and bug_status < 100) or ',
'        (:P3501_SHOW = ''CLOSED'' and bug_status >= 100)',
'     )',
'group by assigned_to',
'order by 2 desc'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_attribute_01=>'INITIALS'
,p_attribute_02=>'ASSIGNED_TO'
,p_attribute_03=>'&THE_LINK.'
,p_attribute_04=>'THE_COUNT'
,p_attribute_11=>'VALUE'
,p_attribute_14=>'25'
,p_attribute_15=>'TEXT'
,p_attribute_16=>'ABSOLUTE'
,p_attribute_17=>'MODERN'
,p_attribute_18=>'AROUND'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(672760884565937640.4806)
,p_plug_name=>'Bug'
,p_region_css_classes=>'h190'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>31
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEXc6f38142II */',
'      sum(decode(nvl(bug_status,0),100,1,0)) bugs_closed,',
'      count(*) bug_count',
'from wwv_flow_bugs b',
'where security_group_id = :flow_security_group_id and',
'         (nvl(:P3501_RELEASE,''ALL'') = ''ALL'' or fix_by_release = :P3501_RELEASE) and',
'         (',
'            nvl(:P3501_SHOW,''ALL'') = ''ALL'' or',
'            (:P3501_SHOW = ''OPEN'' and bug_status < 100) or',
'            (:P3501_SHOW = ''CLOSED'' and bug_status >= 100)',
'         )'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.RAPHAEL.JUSTGAGE'
,p_attribute_01=>'BUG_COUNT'
,p_attribute_02=>'BUG_COUNT'
,p_attribute_03=>'BUG_COUNT'
,p_attribute_04=>'Y'
,p_attribute_10=>'MAXIMUM_VALUE'
,p_attribute_11=>'0.5'
,p_attribute_12=>'0'
,p_attribute_13=>'0.4'
,p_attribute_14=>'CUSTOM'
,p_attribute_15=>'#256FFB'
,p_attribute_16=>'#F0F0F0'
,p_attribute_17=>'DONUT'
,p_attribute_19=>'133'
,p_attribute_20=>unistr('\53D1\884C\7248 &P3501_RELEASE.')
,p_attribute_21=>unistr('\6240\6709 Bug')
,p_attribute_22=>'f?p=&APP_ID.:3500:&SESSION.::&DEBUG.:3500,RIR::'
,p_plug_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
',',
'      sum(decode(assigned_to,null,0,1)) bugs_assigned,',
'      sum(decode(actual_fix_date,null,decode(ESTIMATED_FIX_DATE,null,1,0),0)) no_fix_dates,',
'      sum(decode(nvl(bug_status,0),100,0,',
'        decode(',
'           greatest(trunc(sysdate),trunc(ESTIMATED_FIX_DATE)),',
'           trunc(sysdate),',
'           1,',
'           0',
'           ))) past_due'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(673117214314130631.4806)
,p_plug_name=>unistr('\5DF2\89E3\51B3')
,p_region_css_classes=>'h190'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>61
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEXc6f38142II */',
'      round(decode(count(*),0,0,100*sum(decode(nvl(bug_status,0),100,1,0)) /',
'      count(*))) bugs_closed,',
'      0 min_value,',
'      100 max_value',
'from wwv_flow_bugs b',
'where security_group_id = :flow_security_group_id and',
'         (nvl(:P3501_RELEASE,''ALL'') = ''ALL'' or fix_by_release = :P3501_RELEASE) and',
'         (',
'            nvl(:P3501_SHOW,''ALL'') = ''ALL'' or',
'            (:P3501_SHOW = ''OPEN'' and bug_status < 100) or',
'            (:P3501_SHOW = ''CLOSED'' and bug_status >= 100)',
'         )'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.RAPHAEL.JUSTGAGE'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_attribute_01=>'BUGS_CLOSED'
,p_attribute_02=>'MIN_VALUE'
,p_attribute_03=>'MAX_VALUE'
,p_attribute_04=>'Y'
,p_attribute_08=>'%'
,p_attribute_10=>'MAXIMUM_VALUE'
,p_attribute_13=>'0.4'
,p_attribute_14=>'CUSTOM'
,p_attribute_15=>'#256FFB'
,p_attribute_16=>'#F0F0F0'
,p_attribute_17=>'DONUT'
,p_attribute_19=>'133'
,p_attribute_20=>unistr('\53D1\884C\7248 &P3501_RELEASE.')
,p_attribute_21=>unistr('\5DF2\89E3\51B3 Bug')
,p_attribute_22=>'f?p=&APP_ID.:3500:&SESSION.::&DEBUG.:3500,RIR:IRIN_BUG_STATUS_CODE:\100,200\'
,p_plug_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
',',
'      sum(decode(assigned_to,null,0,1)) bugs_assigned,',
'      sum(decode(actual_fix_date,null,decode(ESTIMATED_FIX_DATE,null,1,0),0)) no_fix_dates,',
'      sum(decode(nvl(bug_status,0),100,0,',
'        decode(',
'           greatest(trunc(sysdate),trunc(ESTIMATED_FIX_DATE)),',
'           trunc(sysdate),',
'           1,',
'           0',
'           ))) past_due'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(673118525313161052.4806)
,p_plug_name=>unistr('\5DF2\5206\914D')
,p_region_css_classes=>'h190'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>71
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEXc6f38142II */',
'      round(decode(count(*),0,0,100*sum(decode(assigned_to,null,0,1)) /',
'      count(*))) bugs_closed,',
'      0 min_value,',
'      100 max_value',
'from wwv_flow_bugs b',
'where security_group_id = :flow_security_group_id and',
'         (nvl(:P3501_RELEASE,''ALL'') = ''ALL'' or fix_by_release = :P3501_RELEASE) and',
'         (',
'            nvl(:P3501_SHOW,''ALL'') = ''ALL'' or',
'            (:P3501_SHOW = ''OPEN'' and bug_status < 100) or',
'            (:P3501_SHOW = ''CLOSED'' and bug_status >= 100)',
'         )'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.RAPHAEL.JUSTGAGE'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_attribute_01=>'BUGS_CLOSED'
,p_attribute_02=>'MIN_VALUE'
,p_attribute_03=>'MAX_VALUE'
,p_attribute_04=>'Y'
,p_attribute_08=>'%'
,p_attribute_10=>'MAXIMUM_VALUE'
,p_attribute_11=>'0.5'
,p_attribute_12=>'0'
,p_attribute_13=>'0.4'
,p_attribute_14=>'CUSTOM'
,p_attribute_15=>'#256FFB'
,p_attribute_16=>'#F0F0F0'
,p_attribute_17=>'DONUT'
,p_attribute_19=>'133'
,p_attribute_20=>unistr('\53D1\884C\7248 &P3501_RELEASE.')
,p_attribute_21=>unistr('\5DF2\5206\914D Bug')
,p_attribute_22=>'f?p=&APP_ID.:3500:&APP_SESSION.:::3500,RIR:IRNN_ASSIGNED_TO:'
,p_plug_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
',',
'      sum(decode(assigned_to,null,0,1)) bugs_assigned,',
'      sum(decode(actual_fix_date,null,decode(ESTIMATED_FIX_DATE,null,1,0),0)) no_fix_dates,',
'      sum(decode(nvl(bug_status,0),100,0,',
'        decode(',
'           greatest(trunc(sysdate),trunc(ESTIMATED_FIX_DATE)),',
'           trunc(sysdate),',
'           1,',
'           0',
'           ))) past_due'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(673120088022189103.4806)
,p_plug_name=>unistr('\672A\89E3\51B3')
,p_region_css_classes=>'h190'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>51
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEXc6f38142II */',
'      sum(decode(nvl(bug_status,0),100,0,200,0,1)) open_bugs',
'from wwv_flow_bugs b',
'where security_group_id = :flow_security_group_id and',
'         (nvl(:P3501_RELEASE,''ALL'') = ''ALL'' or fix_by_release = :P3501_RELEASE) and',
'         (',
'            nvl(:P3501_SHOW,''ALL'') = ''ALL'' or',
'            (:P3501_SHOW = ''OPEN'' and bug_status < 100) or',
'            (:P3501_SHOW = ''CLOSED'' and bug_status >= 100)',
'         )'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.RAPHAEL.JUSTGAGE'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_attribute_01=>'OPEN_BUGS'
,p_attribute_02=>'OPEN_BUGS'
,p_attribute_03=>'OPEN_BUGS'
,p_attribute_04=>'Y'
,p_attribute_10=>'MAXIMUM_VALUE'
,p_attribute_13=>'0.4'
,p_attribute_14=>'CUSTOM'
,p_attribute_15=>'#256FFB'
,p_attribute_16=>'#F0F0F0'
,p_attribute_17=>'DONUT'
,p_attribute_19=>'133'
,p_attribute_20=>unistr('\53D1\884C\7248 &P3501_RELEASE.')
,p_attribute_21=>unistr('\672A\89E3\51B3 Bug')
,p_attribute_22=>'f?p=&APP_ID.:3500:&SESSION.::&DEBUG.:3500,RIR:IRNIN_BUG_STATUS_CODE:\0,100,200\'
,p_plug_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
',',
'      sum(decode(assigned_to,null,0,1)) bugs_assigned,',
'      sum(decode(actual_fix_date,null,decode(ESTIMATED_FIX_DATE,null,1,0),0)) no_fix_dates,',
'      sum(decode(nvl(bug_status,0),100,0,',
'        decode(',
'           greatest(trunc(sysdate),trunc(ESTIMATED_FIX_DATE)),',
'           trunc(sysdate),',
'           1,',
'           0',
'           ))) past_due'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(673142941110345972.4806)
,p_plug_name=>unistr('\72B6\6001')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>101
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  /* APEX4800P3501c */',
'(select lpad(id,3,''000'')||''. ''||the_name from WWV_FLOW_BUG_STATUS_CODES where id = b.bug_status)',
'  BUG_STATUS,',
'  count(*) the_count,',
'  bug_status bug_pct_complete,',
'  ''f?p=4800:3500:''||:APP_SESSION||'':::3500,RIR:IR_BUG_STATUS_CODE,IR_FIX_BY_RELEASE:''||',
'      BUG_STATUS||'',''||decode(:P3501_RELEASE,''ALL'',null,:P3501_RELEASE) the_link',
'from WWV_FLOW_BUGS b',
'where security_group_id = :flow_security_group_id and',
'      BUG_STATUS is not null and',
'     (nvl(:P3501_RELEASE,''ALL'') = ''ALL'' or fix_by_release = :P3501_RELEASE) and',
'     (',
'        nvl(:P3501_SHOW,''ALL'') = ''ALL'' or ',
'        (:P3501_SHOW = ''OPEN'' and bug_status < 100) or ',
'        (:P3501_SHOW = ''CLOSED'' and bug_status >= 100)',
'     )',
'group by BUG_STATUS',
'order by 2 desc'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_attribute_01=>'INITIALS'
,p_attribute_02=>'BUG_STATUS'
,p_attribute_04=>'THE_COUNT'
,p_attribute_05=>'&THE_LINK.'
,p_attribute_11=>'VALUE'
,p_attribute_14=>'25'
,p_attribute_15=>'TEXT'
,p_attribute_16=>'ABSOLUTE'
,p_attribute_17=>'MODERN'
,p_attribute_18=>'AROUND'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(703041705004277793.4806)
,p_plug_name=>unistr('\5B9E\7528\7A0B\5E8F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388361325811341773.4806)
,p_plug_display_sequence=>140
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(181214517334339823.4806)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(198528142870857247.4806)
,p_plug_column_width=>' '
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(177124910231353056.4806)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(181749217062998803.4806)
,p_button_name=>'P3501_SET'
,p_button_static_id=>'P3501_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\8BBE\7F6E')
,p_button_position=>'BODY'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(177123918627336540.4806)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(181749217062998803.4806)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404863283234629578.4806)
,p_button_image_alt=>unistr('\91CD\7F6E')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redir